#include "mbed.h"

/*
   Ejercicio 2: lectura de un sensor analógico.
   El principal objetivo de este ejercicio es probar la lectura de las entradas analógicas de la placa.
   Para ello se ha hecho uso del sensor analógico de temperatura KY-013 que conectamos al pin A0.
   Este valor es de resistencia y para convertirlo un valor de temperatura legible será necesario 
   usar la ecuación de Steinhart–Hart
   
   1/T = A + B*ln(R) + C*(ln(R))^3
   
   T: Temperatura (kelvin)
   R: Resistencia
   A, B, C coeficientes Steinhart–Hart
*/

//Usamos la función AnalogIn para marcar la lectura del pin A0 en la variable temp
AnalogIn temp(A0);

//Fórmula para calcular valor de la temperatura (Steinhart–Hart)
double Thermister(float RawADC) {
    double Temp;
    Temp = log(10000.0 * ((1024.0 / RawADC - 1))); 
    Temp = 1 / (0.001129148 + (0.000234125 + (0.0000000876741 * Temp * Temp ))* Temp );
    //conversión a Celsius
    Temp = Temp - 273.15;
    return Temp;
}

int main()
{
    printf("\nLectura de valor analógico: \n\r");
    while(1) {
        //Leemos el valor analógico
        float readVal = temp.read();
        //Expresamos el valor por consola y damos al valor de resistencia una corrección.
        printf("Analog Temp = %f C\n\r", Thermister((readVal*1000)-120));
        wait(1.0);
    }
}



