#include "mbed.h"
#include "MSCFileSystem.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "UploadHandler.hpp"
#include "HomePageHandler.hpp"

MSCFileSystem msc("usb");
Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

#if 0
IpAddr ip(10,0,0,85);
IpAddr netmask(255,255,255,0);
IpAddr nullip(0,0,0,0);
EthernetNetIf eth(ip, netmask, nullip, nullip);
#else
EthernetNetIf eth;
#endif

HTTPServer svr;

int main()
{
    pc.baud(115200);
    printf("Suspended Plotter\n\r");

    printf("Setting up...\n\r");
    EthernetErr ethErr = eth.setup();
    if(ethErr)
    {
        printf("Error %d in setup.\n\r", ethErr);
        return -1;
    }
    printf("Setup OK\n\r");

    svr.addHandler<HomePageHandler>("/");
    svr.addHandler<UploadHandler>("/upload");
    svr.bind(80);
    
    printf("Listening...\n\r");
    
    Timer tm;
    tm.start();

    while (true)
    {
        IpAddr ip = eth.getIp();
        printf("Connected as: %d.%d.%d.%d\n\r", ip[0], ip[1], ip[2], ip[3]);
        Net::poll();
        if(tm.read()>.5)
        {
            //Show that we are alive
            myled=!myled;
            tm.start();
        }

    }
}
