#include "mbed.h"
#include "USBMouse.h"
#include "USBJoystick.h"

USBJoystick joystick(0x046d, 0xc216);

// keys range: 288-303   0x120-0x134

DigitalIn l_r(p17);
DigitalIn l_l(p18);
DigitalIn l_u(p20);
DigitalIn l_d(p19);
DigitalIn l_b1(p16);
DigitalIn l_b2(p10);
DigitalIn l_b3(p6);
DigitalIn l_b4(p7);
DigitalIn l_b5(p9);
DigitalIn l_b6(p5);

DigitalIn r_r(p22);
DigitalIn r_l(p21);
DigitalIn r_u(p23);
DigitalIn r_d(p24);
DigitalIn r_b1(p11);
DigitalIn r_b2(p29);
DigitalIn r_b3(p13);
DigitalIn r_b4(p12);
DigitalIn r_b5(p15);
DigitalIn r_b6(p14);

DigitalIn c_l(p25);
DigitalIn c_r(p26);
DigitalIn c_u(p27);
DigitalIn c_d(p28);

int main() {
    int16_t x_l = 0;
    int16_t y_l = 0;
    uint8_t buttons_l = 0;
    int16_t x_r = 0;
    int16_t y_r = 0;
    uint8_t buttons_r = 0;
    uint8_t hat = 0;

/*
120 a   121 x   122 y   123 b  124 l1  125 r1  126 l2  127 r2
128 slt 129 srt 12a tl  12b tr
00 x  01 y
02 z  03 rz
10 hx 11 hy
*/

    while (1) {
        x_l = 0;
        y_l = 0;
        if(l_l) x_l = -127;
        if(l_r) x_l = 127;
        if(l_d) y_l = 127;
        if(l_u) y_l = -127;
        buttons_l = l_b6 | l_b4 << 1 | l_b3 << 2 | l_b5 << 3 | l_b1 << 4 | l_b2 << 5 | r_b5 << 6 | r_b6 << 7;

        x_r = 0;
        y_r = 0;
        if(r_l) x_r = -127;
        if(r_r) x_r = 127;
        if(r_d) y_r = 127;
        if(r_u) y_r = -127;
        buttons_r = r_b1 | r_b2 << 1 | r_b3 << 2 | r_b4 << 3 | 0 << 4 | 0 << 5 | 0 << 6 | 0 << 7;

#define HATSWITCH_UP            0x00
#define HATSWITCH_UPRIGHT       0x01
#define HATSWITCH_RIGHT         0x02
#define HATSWITCH_DOWNRIGHT     0x03
#define HATSWITCH_DOWN          0x04
#define HATSWITCH_DOWNLEFT      0x05
#define HATSWITCH_LEFT          0x06
#define HATSWITCH_UPLEFT        0x07
#define HATSWITCH_NONE          0x0F
        hat = HATSWITCH_NONE;
                
        if(c_u) {
            if(c_l) {hat = HATSWITCH_UPLEFT;} else if(c_r) {hat = HATSWITCH_UPRIGHT;} else {hat = HATSWITCH_UP;}
        } else if(c_d) {
             if(c_l) {hat = HATSWITCH_DOWNLEFT;} else if(c_r) {hat = HATSWITCH_DOWNRIGHT;} else {hat = HATSWITCH_DOWN;}
        }
        else if(c_l) {hat = HATSWITCH_LEFT;} else if(c_r) {hat = HATSWITCH_RIGHT;}

        joystick.update(x_l, y_l, buttons_l, x_r, y_r, buttons_r, hat);

        wait(0.001);
    }
}