#include "mbed.h"
/*
 * Datum: 29.07.2020.
 * Napomena: Za rad TSMD TESTER GUI Aplikacije potrebno je ucitati ovaj kod
 *           u kontroler koji se koristi za testiranje.
 *           NE MENJATI KOD UKOLIKO ZELITE ISPRAVAN RAD APLIKACIJE!
 *
 * Board: Nucleo F476RE, ili bilo koja druga ploca koja ima kompatabilne 
 *        DigitalOut pinout kao Nucleo F466RE.
 *
 * Autor: Marta Avramovic
*/

Serial pc(USBTX, USBRX); // tx, rx

//.Inicijalizacija
DigitalOut _D15(PB_8);
DigitalOut _D14(PB_9);
DigitalOut _D13(PA_5);
DigitalOut _D12(PA_6);
DigitalOut _D11(PA_7);
DigitalOut _D10(PB_6);
DigitalOut _D9(PC_7);
DigitalOut _D8(PA_9);
DigitalOut _D7(PA_8);
DigitalOut _D6(PB_10);
DigitalOut _D5(PB_4);
DigitalOut _D4(PB_5);
DigitalOut _D3(PB_3);
DigitalOut _D2(PA_10);

//.callback serial receive function
void callback() {
    
    char buffer[10];
    pc.gets(buffer, sizeof(buffer));
    
    int digitalSum = 0;
    sscanf((const char *)buffer,"%d",&digitalSum);
    //pc.printf("%d \n", digitalSum);
    
    _D2 = (digitalSum & 0b1);
    _D3 = (digitalSum & 0b10);
    _D4 = (digitalSum & 0b100);
    _D5 = (digitalSum & 0b1000);
    _D6 = (digitalSum & 0b10000);
    _D7 = (digitalSum & 0b100000);
    _D8 = (digitalSum & 0b1000000);
    _D9 = (digitalSum & 0b10000000);
    _D10 = (digitalSum & 0b100000000);
    _D11 = (digitalSum & 0b1000000000);
    _D12 = (digitalSum & 0b10000000000);
    _D13 = (digitalSum & 0b100000000000);
    _D14 = (digitalSum & 0b1000000000000);
    _D15 = (digitalSum & 0b10000000000000);
    
}

//.Main Code
int main() {  
     pc.attach(&callback);
}
