#include "CANlibrary.h"
/*
 * Datum: 1.april 2019.
 * Test primer CAN library
 * Prikazan nacin citanja i slanja poruka koriscenjem biblioteke CANlibrary.h
 * Dodato: U odnosu na osnovnu verziju dodata su tri tajmera za slanje poruka.
 * Pri tome ukoliko se ne koristi vise od jednog tajemra istovremeno moze da
 * se koristi sistem iz prvobotne bibliotke sa funkcijama:
 *      - can_initTX(37); //parametar je adresa, inicijalizacija TX CAN Funkcija
 *      - canTX_set_Interval(0.01); //interval CAN slanja
 *      - can_msg_send_tick();
 *      -  pack_data((uint16_t)data, 1);
 * Tj. Funckije bez indeksa. Ukoliko se koristi vise od jednog tajmera  potrebno,
 * je koristiti fukcije sa indeksima koje se odnose na redni broj tajmera.
 * Primer tog koriscenja dat je dole  u zakomentarisanom delu koda.
 */


DigitalOut myled(LED1);
CAN can(PB_8, PB_9);
Serial pc(USBTX, USBRX);     

int main() {
    pc.printf("main\n");
    can.frequency(100000); //CAN frequency
    can_initRX(); //inicijalizacija RX CAN funkcija
    
    can_initTX(37); //parametar je adresa, inicijalizacija TX CAN Funkcija
    canTX_set_Interval(0.01); //interval CAN slanja
    
   /* 

    // I N I C I J A  L I  Z A C I J A
    //__________________________________________________________________________________
   
    can_initTX1(37); //parametar je adresa, inicijalizacija TX CAN Funkcija za timer 1
    canTX_set_Interval_1(0.01); //interval CAN slanja timer-a 1
    
    can_initTX2(16); //parametar je adresa, inicijalizacija TX CAN Funkcija za timer 2
    canTX_set_Interval_2(0.1); //interval CAN slanja timer-a 2 
    
    can_initTX3(8); //parametar je adresa, inicijalizacija TX CAN Funkcija za timer 3
    canTX_set_Interval_3(1.0); //interval CAN slanja timer-a 3
     
    //__________________________________________________________________________________
    // P O Z I V   T A J M E R A
    
      can_msg_send_tick2(); //pozivanje funkcije koja periodicno salje CAN poruku po tajmeru 1
      can_msg_send_tick1(); //pozivanje funkcije koja periodicno salje CAN poruku po tajmeru 2
      can_msg_send_tick3(); //pozivanje funkcije koja periodicno salje CAN poruku po tajmeru 3
      
      
    //__________________________________________________________________________________
     */ 
     
     
      can_msg_send_tick();
     
    /* Poruka koja se salje automatski se upisuje u funkciju:
        pack_data(podatak, pozicija)
     */
    
    while(true){
        pc.printf("loop\n");
        while(!check_flag(14)); //14 je ID prijema poruke
        int data=get_data(TEST); //pristigli, poslati podaci sa ID 14(dec,hex=0Eh)
        pack_data((uint16_t)data, 1);
        
       /* pack_data1((uint16_t)data, 1); //spakuj podatke timera 1 i posalji
        pack_data2((uint16_t)data, 2); //spakuj podatke timera 2 i posalji
        pack_data3((uint16_t)data, 3); //spakuj podatke timera 3 i posalji
        */
        
        //can_msg_send(); //pojedinacno slanje, slanje van intervala
    }
}  