#include "mbed.h"
#include <string>
using std::string;

// User defines
#define FRMWRT_SGL_R    0x00 // single device write with response
#define FRMWRT_SGL_NR   0x10 // single device write without response
#define FRMWRT_GRP_R    0x20 // group broadcast with response
#define FRMWRT_GRP_NR   0x30 // group broadcast without response
#define FRMWRT_ALL_R    0x60 // general broadcast with response
#define FRMWRT_ALL_NR   0x70 // general broadcast without response

#define TOTALBOARDS 16
typedef unsigned char BYTE;

// CRC16 for PL455
// ITU_T polynomial: x^16 + x^15 + x^2 + 1
const uint16_t crc16_table[256] = {
    0x0000, 0xC0C1, 0xC181, 0x0140, 0xC301, 0x03C0, 0x0280, 0xC241,
    0xC601, 0x06C0, 0x0780, 0xC741, 0x0500, 0xC5C1, 0xC481, 0x0440,
    0xCC01, 0x0CC0, 0x0D80, 0xCD41, 0x0F00, 0xCFC1, 0xCE81, 0x0E40,
    0x0A00, 0xCAC1, 0xCB81, 0x0B40, 0xC901, 0x09C0, 0x0880, 0xC841,
    0xD801, 0x18C0, 0x1980, 0xD941, 0x1B00, 0xDBC1, 0xDA81, 0x1A40,
    0x1E00, 0xDEC1, 0xDF81, 0x1F40, 0xDD01, 0x1DC0, 0x1C80, 0xDC41,
    0x1400, 0xD4C1, 0xD581, 0x1540, 0xD701, 0x17C0, 0x1680, 0xD641,
    0xD201, 0x12C0, 0x1380, 0xD341, 0x1100, 0xD1C1, 0xD081, 0x1040,
    0xF001, 0x30C0, 0x3180, 0xF141, 0x3300, 0xF3C1, 0xF281, 0x3240,
    0x3600, 0xF6C1, 0xF781, 0x3740, 0xF501, 0x35C0, 0x3480, 0xF441,
    0x3C00, 0xFCC1, 0xFD81, 0x3D40, 0xFF01, 0x3FC0, 0x3E80, 0xFE41,
    0xFA01, 0x3AC0, 0x3B80, 0xFB41, 0x3900, 0xF9C1, 0xF881, 0x3840,
    0x2800, 0xE8C1, 0xE981, 0x2940, 0xEB01, 0x2BC0, 0x2A80, 0xEA41,
    0xEE01, 0x2EC0, 0x2F80, 0xEF41, 0x2D00, 0xEDC1, 0xEC81, 0x2C40,
    0xE401, 0x24C0, 0x2580, 0xE541, 0x2700, 0xE7C1, 0xE681, 0x2640,
    0x2200, 0xE2C1, 0xE381, 0x2340, 0xE101, 0x21C0, 0x2080, 0xE041,
    0xA001, 0x60C0, 0x6180, 0xA141, 0x6300, 0xA3C1, 0xA281, 0x6240,
    0x6600, 0xA6C1, 0xA781, 0x6740, 0xA501, 0x65C0, 0x6480, 0xA441,
    0x6C00, 0xACC1, 0xAD81, 0x6D40, 0xAF01, 0x6FC0, 0x6E80, 0xAE41,
    0xAA01, 0x6AC0, 0x6B80, 0xAB41, 0x6900, 0xA9C1, 0xA881, 0x6840,
    0x7800, 0xB8C1, 0xB981, 0x7940, 0xBB01, 0x7BC0, 0x7A80, 0xBA41,
    0xBE01, 0x7EC0, 0x7F80, 0xBF41, 0x7D00, 0xBDC1, 0xBC81, 0x7C40,
    0xB401, 0x74C0, 0x7580, 0xB541, 0x7700, 0xB7C1, 0xB681, 0x7640,
    0x7200, 0xB2C1, 0xB381, 0x7340, 0xB101, 0x71C0, 0x7080, 0xB041,
    0x5000, 0x90C1, 0x9181, 0x5140, 0x9301, 0x53C0, 0x5280, 0x9241,
    0x9601, 0x56C0, 0x5780, 0x9741, 0x5500, 0x95C1, 0x9481, 0x5440,
    0x9C01, 0x5CC0, 0x5D80, 0x9D41, 0x5F00, 0x9FC1, 0x9E81, 0x5E40,
    0x5A00, 0x9AC1, 0x9B81, 0x5B40, 0x9901, 0x59C0, 0x5880, 0x9841,
    0x8801, 0x48C0, 0x4980, 0x8941, 0x4B00, 0x8BC1, 0x8A81, 0x4A40,
    0x4E00, 0x8EC1, 0x8F81, 0x4F40, 0x8D01, 0x4DC0, 0x4C80, 0x8C41,
    0x4400, 0x84C1, 0x8581, 0x4540, 0x8701, 0x47C0, 0x4680, 0x8641,
    0x8201, 0x42C0, 0x4380, 0x8341, 0x4100, 0x81C1, 0x8081, 0x4040
};

/* K O N F I G U R I S I    P I N O V E*/
 
DigitalIn bmsFault(PA_4);//PC_8);
DigitalOut bmsWakeUp(PB_0);//PC_9);

// - - - UART CONFIGURATION - - - 

Serial pc(PA_0, PA_1, 250000);//PA_9, PA_10,250000);
Serial pc1(USBTX, USBRX, 9600);//PC_10, PC_11,9600);


void posaljiUARTu(int length, uint8_t * data){
    
    for(int i=0;i<length;i++)
      pc.putc(data[i]);
    
    //if(length > 10){
   //  sscanf(pBuf,"+IPD,%d,%d:%s", &linkID, &ipdLen, type); 
    //}
      wait_ms(1);
}

void WakePL455(){
    bmsWakeUp = 1;
    wait_ms(10);
    bmsWakeUp = 0;
}
uint16_t CRC16(BYTE *pBuf, int nLen)
{
   uint16_t wCRC = 0;
    int i;

    for (i = 0; i < nLen; i++)
    {
        wCRC ^= (*pBuf++) & 0x00FF;
        wCRC = crc16_table[wCRC & 0x00FF] ^ (wCRC >> 8);
    }
    
    return wCRC;
}
int  WriteFrame(BYTE bID, uint16_t& wAddr, BYTE * pData, BYTE bLen, BYTE bWriteType)
{
    
    int    bPktLen = 0;
    BYTE   pFrame[32];
    BYTE * pBuf = pFrame;
    uint16_t   wCRC;

    if (bLen == 7 || bLen > 8)
        return 0;

    memset(pFrame, 0x7F, sizeof(pFrame));
    if (wAddr > 255)    {
        *pBuf++ = 0x88 | bWriteType | bLen; // use 16-bit address
        if (bWriteType == FRMWRT_SGL_R || bWriteType == FRMWRT_SGL_NR || bWriteType == FRMWRT_GRP_R || bWriteType == FRMWRT_GRP_NR)//(bWriteType != FRMWRT_ALL_NR)// || (bWriteType != FRMWRT_ALL_R))
        {
            *pBuf++ = (bID & 0x00FF);
        }
        *pBuf++ = (wAddr & 0xFF00) >> 8;
        *pBuf++ =  wAddr & 0x00FF;
    }
    else {
        
        *pBuf++ = 0x80 | bWriteType | bLen; // use 8-bit address
        if (bWriteType == FRMWRT_SGL_R || bWriteType == FRMWRT_SGL_NR || bWriteType == FRMWRT_GRP_R || bWriteType == FRMWRT_GRP_NR)
        {
            *pBuf++ = (bID & 0x00FF);
        }
        *pBuf++ = wAddr & 0x00FF;
    }
    
    while(bLen--)
        *pBuf++ = *pData++;

    bPktLen = pBuf - pFrame;

    wCRC = CRC16(pFrame, bPktLen);
    *pBuf++ = wCRC & 0x00FF;
    *pBuf++ = (wCRC & 0xFF00) >> 8;
    bPktLen += 2;

    //sciSend(scilinREG, bPktLen, pFrame);

    posaljiUARTu(bPktLen,pFrame);
    
    return bPktLen;
}


int  ReadFrameReq(BYTE bID, uint16_t wAddr, BYTE bByteToReturn)
{
    BYTE bReturn = bByteToReturn - 1;

    if (bReturn > 127)
        return 0;

    return WriteFrame(bID, wAddr, &bReturn, 1, FRMWRT_SGL_R);
}

int  ReadReg(BYTE bID, uint16_t wAddr, void * pData, BYTE bLen, uint32_t dwTimeOut)
{
    int   bRes = 0;
    BYTE  bRX[8];

    memset(bRX, 0, sizeof(bRX));
    switch(bLen)
    {
    case 1:
        bRes = ReadFrameReq(bID, wAddr, 1);
        break;
    case 2:
        bRes = ReadFrameReq(bID, wAddr, 2);
        break;
    case 3:
        bRes = ReadFrameReq(bID, wAddr, 3);
        break;
    case 4:
        bRes = ReadFrameReq(bID, wAddr, 4);
        break;
    default:
        break;
    }
    return bRes;
}
int  WriteReg(BYTE bID, uint16_t wAddr, uint64_t dwData, BYTE bLen, BYTE bWriteType)
{
    int bRes = 0;
    BYTE bBuf[8] = {0, 0, 0, 0, 0, 0, 0, 0};
    switch(bLen)
    {
    case 1:
        bBuf[0] =  dwData & 0x00000000000000FF;
        
        bRes = WriteFrame(bID, wAddr, bBuf, 1, bWriteType);
        break;
    case 2:
        bBuf[0] = (dwData & 0x000000000000FF00) >> 8;
        bBuf[1] =  dwData & 0x00000000000000FF;
       
        bRes = WriteFrame(bID, wAddr, bBuf, 2, bWriteType);
        break;
    case 3:
        bBuf[0] = (dwData & 0x0000000000FF0000) >> 16;
        bBuf[1] = (dwData & 0x000000000000FF00) >> 8;
        bBuf[2] =  dwData & 0x00000000000000FF;
        
        bRes = WriteFrame(bID, wAddr, bBuf, 3, bWriteType);
        break;
    case 4:
        bBuf[0] = (dwData & 0x00000000FF000000) >> 24;
        bBuf[1] = (dwData & 0x0000000000FF0000) >> 16;
        bBuf[2] = (dwData & 0x000000000000FF00) >> 8;
        bBuf[3] =  dwData & 0x00000000000000FF;
        
        bRes = WriteFrame(bID, wAddr, bBuf, 4, bWriteType);
        break;
    case 5:
        bBuf[0] = (dwData & 0x000000FF00000000) >> 32;
        bBuf[1] = (dwData & 0x00000000FF000000) >> 24;
        bBuf[2] = (dwData & 0x0000000000FF0000) >> 16;
        bBuf[3] = (dwData & 0x000000000000FF00) >> 8;
        bBuf[4] =  dwData & 0x00000000000000FF;
        
        bRes = WriteFrame(bID, wAddr, bBuf, 5, bWriteType);
        break;
    case 6:
        bBuf[0] = (dwData & 0x0000FF0000000000) >> 40;
        bBuf[1] = (dwData & 0x000000FF00000000) >> 32;
        bBuf[2] = (dwData & 0x00000000FF000000) >> 24;
        bBuf[3] = (dwData & 0x0000000000FF0000) >> 16;
        bBuf[4] = (dwData & 0x000000000000FF00) >> 8;
        bBuf[5] =  dwData & 0x00000000000000FF;
        
        bRes = WriteFrame(bID, wAddr, bBuf, 6, bWriteType);
        break;
    case 7:
        bBuf[0] = (dwData & 0x00FF000000000000) >> 48;
        bBuf[1] = (dwData & 0x0000FF0000000000) >> 40;
        bBuf[2] = (dwData & 0x000000FF00000000) >> 32;
        bBuf[3] = (dwData & 0x00000000FF000000) >> 24;
        bBuf[4] = (dwData & 0x0000000000FF0000) >> 16;
        bBuf[5] = (dwData & 0x000000000000FF00) >> 8;
        bBuf[6] =  dwData & 0x00000000000000FF;;
        
        bRes = WriteFrame(bID, wAddr, bBuf, 7, bWriteType);
        break;
    case 8:
        bBuf[0] = (dwData & 0xFF00000000000000) >> 56;
        bBuf[1] = (dwData & 0x00FF000000000000) >> 48;
        bBuf[2] = (dwData & 0x0000FF0000000000) >> 40;
        bBuf[3] = (dwData & 0x000000FF00000000) >> 32;
        bBuf[4] = (dwData & 0x00000000FF000000) >> 24;
        bBuf[5] = (dwData & 0x0000000000FF0000) >> 16;
        bBuf[6] = (dwData & 0x000000000000FF00) >> 8;
        bBuf[7] =  dwData & 0x00000000000000FF;
        
        bRes = WriteFrame(bID, wAddr, bBuf, 8, bWriteType);
        break;
    default:
        break;
    }
    return bRes;
}
BYTE recBuff[1024];
int recLen=0;
int expected=0;
volatile bool full = false;
int rdLen=0;

void callback() {
    // Note: you need to actually read from the serial to clear the RX interrupt
    //pc1.printf("* * *    Uspesan PRIJEM!     * * *\n");
    while(pc.readable()){
        //pc1.printf("jepse");
        //pc1.printf("%d\n", pc.getc());
        recBuff[recLen++]=pc.getc();
        if(expected==0) expected = recBuff[0]+4;
        if(expected==recLen){
            full=true;
            rdLen=expected;
            expected=0;
            recLen=0;
        }
    }
}

void waitFrame(){
    while(!full);
    full=false;
    for(int i = 0;i<rdLen;i++){
        pc1.printf("%X ",recBuff[i]);
    }
    
    pc1.printf("\n\n- - - VOLTAGE - - -\n");
    for(int i = 1; i < recBuff[0] - 1; i += 2){
               
        int voltage = recBuff[i+1];
        voltage |= (recBuff[i]) << 8;
        double vol = ((double)voltage)/65536.0 * 5.0;
        pc1.printf("CELL[%d] = %.6f V\n",(recBuff[0] - 1)/2 -(i-1)/2,vol);
    }
      
    pc1.printf("\n");
}
 
int main() {
    uint32_t  wTemp = 0;
    pc.attach(&callback);
   /* pc.printf("Ulaz u fju \n");
    WriteReg(0, 10, 0, 1, FRMWRT_ALL_NR); 
    WriteReg(0, 16, 0x10E0, 2, FRMWRT_ALL_NR); //AKO JE PODATAK 2B onda treba da SPOJIM PODADTAK U PORUCI ehhehehehe!!!!!!!!!!!!!!
    pc.printf("Done \n");
    */
    pc1.printf("INICIJALIZACIJA START \n");
    
    WakePL455();
    
    // Wake all devices
    // The wake tone will awaken any device that is already in shutdown and the pwrdown will shutdown any device
    // that is already awake. The least number of times to sequence wake and pwrdown will be half the number of
    // boards to cover the worst case combination of boards already awake or shutdown.
    for(int nDev_ID = 0; nDev_ID < TOTALBOARDS>>1; nDev_ID++) {
        WriteReg(nDev_ID, 0x12, 0x40, 1, FRMWRT_ALL_NR);  // send out broadcast pwrdown command
        wait_ms(5); //~5ms
        WakePL455();
        wait_ms(5); //~5ms
    }
    // Mask Customer Checksum Fault bit
    WriteReg(0, 107, 0x8000, 2, FRMWRT_ALL_NR); // clear all fault summary flags

    // Clear all faults
    WriteReg(0, 82, 0xFFC0, 2, FRMWRT_ALL_NR);      // clear all fault summary flags
    WriteReg(0, 81, 0x38, 1, FRMWRT_ALL_NR); // clear fault flags in the system status register

    // Auto-address all boards (section 1.2.2)
    WriteReg(0, 14, 0x19, 1, FRMWRT_ALL_NR); // set auto-address mode on all boards
    WriteReg(0, 12, 0x08, 1, FRMWRT_ALL_NR); // enter auto address mode on all boards, the next write to this ID will be its address

    // Set addresses for all boards in daisy-chain (section 1.2.3)
    for (int nDev_ID = 0; nDev_ID < TOTALBOARDS; nDev_ID++)
    {
        WriteReg(nDev_ID, 10, nDev_ID, 1, FRMWRT_ALL_NR); // send address to each board
    }

    // Enable all communication interfaces on all boards in the stack (section 1.2.1)
    //default 250k bound
    WriteReg(0, 16, 0x10F8, 2, FRMWRT_ALL_NR);  // set communications baud rate and enable all interfaces on all boards in stack

    pc1.printf("INICIJALIZACIJA END \n");
    
    pc1.printf("Response? \n");
    for (int nDev_ID = TOTALBOARDS - 1; nDev_ID >= 0; --nDev_ID)
    {
        // read device ID to see if there is a response
        ReadReg(nDev_ID, 10, &wTemp, 1, 0); // 0ms timeout
        wait_ms(10);
    }
    wait(1);
        
    // Clear all faults (section 1.2.7)
    WriteReg(0, 82, 0xFFC0, 2, FRMWRT_ALL_NR); // clear all fault summary flags
    WriteReg(0, 81, 0x38, 1, FRMWRT_ALL_NR); // clear fault flags in the system status register

    wait_ms(10);

    // Configure AFE (section 2.2.1)

    int nDev_ID = 0;
    WriteReg(nDev_ID, 60, 0x00, 1, FRMWRT_SGL_NR); // set 0 mux delay
    WriteReg(nDev_ID, 61, 0x00, 1, FRMWRT_SGL_NR); // set 0 initial delay

    // Configure voltage and internal sample period (section 2.2.2)
    nDev_ID = 0;
    WriteReg(nDev_ID, 62, 0xCC, 1, FRMWRT_SGL_NR); // set 99.92us ADC sampling period

    // Configure the oversampling rate (section 2.2.3)
    nDev_ID = 0;
    WriteReg(nDev_ID, 7, 0x00, 1, FRMWRT_SGL_NR); // set no oversampling period
    
        // Select number of cells and channels to sample (section 2.2.5.1)
    nDev_ID = 0;
    //(nDev_ID, 13, 0x10, 1, FRMWRT_SGL_NR); // set number of cells to 16
    //WriteReg(nDev_ID, 3, 0xFFFF03C0, 4, FRMWRT_SGL_NR); // select all cell, AUX channels 0 and 1, and internal digital die and internal analog die temperatures

    // Select identical number of cells and channels on all modules simultaneously (section 2.2.5.2)
    //WriteReg(0, 13, 0x10, 1, FRMWRT_ALL_NR); // set number of cells to 16
    //WriteReg(0, 3, 0xFFFF03C0, 4, FRMWRT_ALL_NR); // select all cell, AUX channels 0 and 1, and internal digital die and internal analog die temperatures
    
   // WriteReg(0, 13, 0x07, 1, FRMWRT_ALL_NR); // set number of cells to 8
    //moze bey ove gornje fje koja nema nikakav efekat
    WriteReg(0, 3, 0xFFFF00C0, 4, FRMWRT_ALL_NR); // select all cell channels 1-8, AUX channels 0 and 1, and internal digital die and internal analog die temperatures

    // Set cell over-voltage and cell under-voltage thresholds on a single board (section 2.2.6.1)
    nDev_ID = 0;
    WriteReg(nDev_ID, 144, 0xD1EC, 2, FRMWRT_SGL_NR); // set OV threshold = 4.1000V
    WriteReg(nDev_ID, 142, 0x6148, 2, FRMWRT_SGL_NR); // set UV threshold = 1.9000V

    // Set cell over-voltage and cell under-voltage thresholds on all boards simultaneously (section 2.2.6.2)
    WriteReg(0, 144, 0xD1EC, 2, FRMWRT_ALL_NR); // set OV threshold = 4.1000V
    WriteReg(0, 142, 0x6148, 2, FRMWRT_ALL_NR); // set UV threshold = 1.9000V
    
    //-------------22.2.2020.   waitFrame();
    
    //***************************************************************************************************************************
    // Send broadcast request to all boards to sample and send results (section 3.2)
    //WriteReg(0, 2, 0x02, 1, FRMWRT_ALL_NR); // send sync sample command
    //nSent = WaitRespFrame(bFrame, 81, 0); // 24 bytes data (x3) + packet header (x3) + CRC (x3), 0ms timeout
 
    // Send broadcast request to all boards to sample and store results (section 3.3.1)
    //WriteReg(0, 2, 0x00, 1, FRMWRT_ALL_NR); // send sync sample command

    // Read sampled data from boards (section 3.3.2)
    // 24 bytes - still configured for 8 AFE channels plus 2 AUX channels plus internal digital and analog die
    // temperatures (see code for section 2.2.5.2)
    
    nDev_ID = 0;
    
    //waitFrame();
    
    WriteReg(nDev_ID, 2, 0x20, 1, FRMWRT_SGL_R); // send read sampled values command
    //nSent = WaitRespFrame(bFrame, 27, 0); // 24 bytes data + packet header + CRC, 0ms timeout
    
    waitFrame();
     // Send sample request to single board to sample and send results (section 4.2)

    nDev_ID = 0;
    //WriteReg(nDev_ID, 2, 0x01, 1, FRMWRT_SGL_R); // send sync sample command
    //nSent = WaitRespFrame(bFrame, 27, 0); // 24 bytes data + packet header + CRC, 0ms timeout
    //waitFrame();
    
    while (1) {
        pc1.printf("Main Code \n");
        wait(2);
        nDev_ID = 0;
        WriteReg(nDev_ID, 2, 0x20, 1, FRMWRT_SGL_R); // send read sampled values command
        waitFrame();
        if(bmsFault)
            pc1.printf("- - - GRESKA FAULT! - - -\n");
    

    }
    
    
}