#include "mbed.h"
#include "CANlibrary.h"
#include "Sensor.h"

/*
 *  Datum: 29.jun.2019.
 *  CAN ASAD_2: podaci koje cita su samo lvdt levi i desni na CANid=10
 *  CAN ASAD_2: podaci koje cita su samo ulje kocnice leve, desne i volan na CANid=12
 *
 *  Sensor je klasa koja kao prvi parametar prima analogni pin, ulaz sa kojeg se
 *  podaci ocitavaju, i na zahtev, novo ocitavanje analogne vrednosti vrsi se u
 *  interrupt funkciji analogUpdate() i u main()-u se pakuju u CAN pakete i salju.
 *
 *  Biblioteke: Sensor.h , CANlibrary.h
 *
 *  Problem prethodni>>> objekat AnalogIn nije hteo da vrati vrenost fje read() u
 *  kombinaciji sa CANom, pa je objekat morao biti definisan u main()u sto je stvaralo 
 *  problem azuriranja lokalnih objekata AnalogIn u main()u za globalnu fju analogUpdate()
 *  
 */

Ticker tickUpdate;

//f = k * analog.read() + n 
//Konstruktor Sensor(PinName pin,float n,float k);

Sensor lvdt_Levi(PC_5,0,100);   
Sensor lvdt_Desni(PC_1,0,100);   
Sensor uljekKoc_Levi(PA_6,0,100);  
Sensor uljekKoc_Desni(PA_1,0,100);    
Sensor volan(PA_0,0,100);   

//Inicijalizacija CAN i UART
CAN can(PA_11, PA_12,1000000);
Serial pc(PC_10,PC_11,19200);

//Pomocne promenljive koje se azuriraju i analogno citaju svakih 10ms
float val_lvdt_levi=0;
float val_lvdt_desni=0;
float val_volan=0;
float val_uljek_desni=0;
float val_uljek_levi=0;

 void analogUpdate(){
        //Analogno ocitavanje novih vrednosti svakih 10 ms
        //Analogno ocitavanje reseno u fji Sensor.value()
        //pc.printf("**************\n");
        val_lvdt_levi=lvdt_Levi.value();
        val_lvdt_desni=lvdt_Desni.value();
        val_volan=volan.value();
        val_uljek_desni=uljekKoc_Desni.value();
        val_uljek_levi=uljekKoc_Levi.value();
        
}; 
int main() {
            
    tickUpdate.attach(&analogUpdate, 0.1); //definisi vreme azuriranja AnalogIn sensor vrednosti
    
    //can.frequency(1000000);
    can_initTX1(10); //parametar je adresa, inicijalizacija TX CAN Funkcija za timer 1
    canTX_set_Interval_1(0.1); //interval CAN slanja timer-a 1
    
    can_initTX2(12); //parametar je adresa, inicijalizacija TX CAN Funkcija za timer 2
    canTX_set_Interval_2(0.1); //interval CAN slanja timer-a 2 
    
    can_msg_send_tick2(); //pozivanje funkcije koja periodicno salje CAN poruku po tajmeru 1
    can_msg_send_tick1(); //pozivanje funkcije koja periodicno salje CAN poruku po tajmeru 2


    while(1){
       
        pc.printf("Sensor ANAL value: %f\n\r",val_volan);
        
        pack_data1((uint16_t)val_lvdt_levi, 0); //spakuj podatke timera 1 i posalji na poziciji 0
        pack_data1((uint16_t)val_lvdt_desni, 1); //spakuj podatke timera 1 i posalji na poziciji 1
        
        pack_data2((uint16_t)val_uljek_levi, 0); //spakuj podatke timera 2 i posalji na poziciji 0
        pack_data2((uint16_t)val_uljek_desni, 1); //spakuj podatke timera 2 i posalji na poziciji 1
        pack_data2((uint16_t)val_volan, 2); //spakuj podatke timera 2 i posalji na poziciji 2
    
    }
}