#pragma once

#include "mbed.h"

// small wrapper to debounce a button input
// 200 ms delay means that freq button presses per second is max 5 Hz
class DebouncedInterruptIn : public InterruptIn
{
public:
    DebouncedInterruptIn(PinName pin, unsigned delayMS=200, PinMode pinMode=PullDefault)
        : InterruptIn(pin)
        , _delay_ms(delayMS)
    {
        mode(pinMode);
        _bRisen = DigitalIn(pin);
        _timer.start();
    }

    void attach(Callback<void()> func, bool rise)
    {
        if (rise)
        {
            _funcRiseCB = func;
            InterruptIn::rise([this]() { _funcRise(); });
        }
        else
        {
            _funcFallCB = func;
            InterruptIn::fall([this]() { _funcFall();});
        }
    }


private:
    void _funcRise()
    {
        if(!_bRisen && (_timer.read_ms() >= _delay_ms))
        {
            _funcRiseCB();
            _bRisen = true;
            _timer.start();
        }
    }

    void _funcFall()
    {
        if(_bRisen && (_timer.read_ms() >= _delay_ms))
        {
            _funcFallCB();
            _timer.start();
            _bRisen = false;
        }
    }
    
    Callback<void()> _funcRiseCB;
    Callback<void()> _funcFallCB;
    Timer _timer;
    unsigned const _delay_ms;
    bool    _bRisen;
};