#if defined(TARGET_LPC1768) || defined(TARGET_LPC1114) || defined(TARGET_LPC11U24) || defined(TARGET_LPC13XX)
#include "BurstSPI.h"
#include "LPC17xx.h"

#define READABLE_BIT (1<<2)
#define WRITABLE_BIT (1<<1)
#define BUSY_BIT (1<<4)

void BurstSPI::fastWrite(int data) {
    //Wait until FIFO has space
    while(((_peripheral->spi.spi->SR) & WRITABLE_BIT) == 0);
    
    //transmit data
    _peripheral->spi.spi->DR = data;
    while(((_peripheral->spi.spi->SR) & READABLE_BIT) == 0);
    int dummy = _peripheral->spi.spi->DR;
}

void BurstSPI::clearRX( void ) {
    //Do it while either data in RX buffer, or while it is busy
    while(((_peripheral->spi.spi->SR) & (BUSY_BIT + READABLE_BIT)) != 0) {
        //Wait until data in RX buffer
        while(((_peripheral->spi.spi->SR) & READABLE_BIT) == 0);
        int dummy = _peripheral->spi.spi->DR;
    }
}
#endif