#ifndef MMA8451Q_H
#define MMA8451Q_H

#include "mbed.h"

class MMA8451Q
{
public:
    /**
    * MMA8451Q constructor
    *
    * @param sda SDA pin
    * @param sdl SCL pin
    * @param addr addr of the I2C peripheral
    */
    MMA8451Q(PinName sda, PinName scl, int addr);
    
    /**
    * MMA8451Q destructor
    */
    ~MMA8451Q();
    
float getAccX();

  /**
   * Get Y axis acceleration
   *
   * @returns Y axis acceleration
   */
  float getAccY();

  /**
   * Get Z axis acceleration
   *
   * @returns Z axis acceleration
   */
  float getAccZ();

  /**
   * Get XYZ axis acceleration
   *
   * @param res array where acceleration data will be stored
   */
  void getAccAllAxis(float * res);

    /**
    * Configure the Accelerometere for motion detection
    *
    * @param pointer to the user function to execute after IRQ assertion
    * @return none
    */
    void MotionDetection( void(*fptr)(void));

    /**
    * Soft Reset
    * @param none
    * @return none
    */
    void Reset( void);
    
private:
    I2C m_i2c;
    int m_addr;
    void readRegs(int addr, uint8_t * data, int len);
    void writeRegs(uint8_t * data, int len);
    int16_t getAccAxis(uint8_t addr);
    void Standby( void);
    void Active( void);
    void Motion_IRQ( void);
};

#endif
