/**
 ******************************************************************************
 * @file    main.cpp
 * @author  AST / EST
 * @version V0.0.1
 * @date    14-August-2015
 * @brief   Simple Example application for using the X_NUCLEO_IKS01A1
 *          MEMS Inertial & Environmental Sensor Nucleo expansion board.
 ******************************************************************************
 * @attention
 *
 * <h2><center>&copy; COPYRIGHT(c) 2015 STMicroelectronics</center></h2>
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *   1. Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright notice,
 *      this list of conditions and the following disclaimer in the documentation
 *      and/or other materials provided with the distribution.
 *   3. Neither the name of STMicroelectronics nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ******************************************************************************
*/

/* Includes */
#include "mbed.h"
#include "x_nucleo_iks01a1.h"

/* Instantiate the expansion board */
static X_NUCLEO_IKS01A1 *mems_expansion_board = X_NUCLEO_IKS01A1::Instance(D14, D15);

/* Retrieve the composing elements of the expansion board */
static GyroSensor *gyroscope = mems_expansion_board->GetGyroscope();
static MotionSensor *accelerometer = mems_expansion_board->GetAccelerometer();
static MagneticSensor *magnetometer = mems_expansion_board->magnetometer;
static HumiditySensor *humidity_sensor = mems_expansion_board->ht_sensor;
static PressureSensor *pressure_sensor = mems_expansion_board->pt_sensor;
static TempSensor *temp_sensor1 = mems_expansion_board->ht_sensor;
static TempSensor *temp_sensor2 = mems_expansion_board->pt_sensor;

double pX;

/* Helper function for printing floats & doubles */
static char *printDouble(char* str, double v, int decimalDigits=2)
{
    int i = 1;
    int intPart, fractPart;
    int len;
    char *ptr;

    /* prepare decimal digits multiplicator */
    for (; decimalDigits!=0; i*=10, decimalDigits--);

    /* calculate integer & fractinal parts */
    intPart = (int)v;
    fractPart = (int)((v-(double)(int)v)*i);

    /* fill in integer part */
    sprintf(str, "%i.", intPart);

    /* prepare fill in of fractional part */
    len = strlen(str);
    ptr = &str[len];

    /* fill in leading fractional zeros */
    for (i/=10; i>1; i/=10, ptr++) {
        if(fractPart >= i) break;
        *ptr = '0';
    }

    /* fill in (rest of) fractional part */
    sprintf(ptr, "%i", fractPart);

    return str;
}

double dolno (double data)
{
    float Fc=0.1;
    float alfa=0.1;
    double x= (1- alfa) *pX+alfa*data;
    pX=x;
    return x;



}
double pasmo (double in)
{
    double hc = 0.02;
    double lc = 0.7;
    double lk = 0;
    double  hk = 0;
    double out;
    lk = lk + lc * (in - lk);
    hk = hk + hc * (lk - hk);
    out = lk - hk;


    return out;
}


/* Simple main function */
int main()
{
    uint8_t id;
    float value1, value2;
    char buffer1[32], buffer2[32];


    printf("\r\n--- Starting new run ---\r\n");

    humidity_sensor->read_id(&id);
    printf("HTS221  humidity & temperature    = 0x%X\r\n", id);

    wait(3);

    while(1) {
        //printf("\r\n");

        temp_sensor1->get_temperature(&value1);
        humidity_sensor->get_humidity(&value2);
        printf("%s%;\t",printDouble(buffer2, value2));
        //  printf("\r\n");
        double filtered=dolno(value2);
        printf( "%6.5lf;\t", filtered );
        double p=pasmo(value2);
        printf( "%6.5lf\r\n", p );

        wait(0.5);
    }
}

///////////////////////////////////////////////////////////////////////////////////////
/*
#include <iostream>
#include <cmath>
#include <iomanip>

using namespace std;

void createFilter(double gKernel[][5])
{
    // set standard deviation to 1.0
    double sigma = 1.0;
    double r, s = 2.0 * sigma * sigma;

    // sum is for normalization
    double sum = 0.0;

    // generate 5x5 kernel
    for (int x = -2; x <= 2; x++)
    {
        for(int y = -2; y <= 2; y++)
        {
            r = sqrt(x*x + y*y);
            gKernel[x + 2][y + 2] = (exp(-(r*r)/s))/(M_PI * s);
            sum += gKernel[x + 2][y + 2];
        }
    }

    // normalize the Kernel
    for(int i = 0; i < 5; ++i)
        for(int j = 0; j < 5; ++j)
            gKernel[i][j] /= sum;

}

int main()
{
    double gKernel[5][5];
    createFilter(gKernel);
    for(int i = 0; i < 5; ++i)
    {
        for (int j = 0; j < 5; ++j)
            cout<<gKernel[i][j]<<"\t";
        cout<<endl;
    }
}
*/




/* Thanks, that's obvious after reading it :) The high pass filter is just
the input minus the output of the low pass filter.

What I really need is a bandpass filter. I've combined the two filters like
this:

hc = 0.02;
lc = 0.4;
lk = 0;
hk = 0;
loop {
in = nextSensorValue();
lk = lk + lc * (in - lk);
hk = hk + hc * (lk - hk);
out = lk - hk;
writeOut(out);
}

This is already very simple and looks like it does what I want, but I
wonder if I can reduce the number of multiplications and additions even
further, because I want to implement it on a microcontroller, with the
additional complication that it doesn't support floating points. But I
think I can convert it to fixed point math.  */



//highpass

/*Sure...
x(k+1) = (1-c)*x(k) + c*u(k)
y(k) = u(k) - x(k)
c sets the cutoff frequency. There's a zero at z=1 and a pole at z=1-
c.
u(k) is the input; y(k) the output. x is a variable internal to the
filter.
Note that x(k) by itself as an output is just a low-pass function.
This is a first-order filter. */



