#ifndef _COLORS_
#define _COLORS_

/* FOREGROUND */
#define RST  "\x1B[0m"
#define KRED  "\x1B[31m"
#define KGRN  "\x1B[32m"
#define KYEL  "\x1B[33m"
#define KBLU  "\x1B[34m"
#define KMAG  "\x1B[35m"
#define KCYN  "\x1B[36m"
#define KWHT  "\x1B[37m"

#define FRED(x) KRED x RST
#define FGRN(x) KGRN x RST
#define FYEL(x) KYEL x RST
#define FBLU(x) KBLU x RST
#define FMAG(x) KMAG x RST
#define FCYN(x) KCYN x RST
#define FWHT(x) KWHT x RST

#define BOLD(x) "\x1B[1m" x RST
#define UNDL(x) "\x1B[4m" x RST

#endif  /* _COLORS_ */

#include "mbed.h"
#include "TermControl.h"
#include "rtos.h"

DigitalOut buzz(A0);

Serial saida(USBTX, USBRX);
Serial entrada(USBTX, USBRX);

TermControl terminal;

unsigned char atualiza_stk[1024];
unsigned char controle_stk[1024];

Thread atualiza_thread(osPriorityNormal, 1024, &atualiza_stk[0]);
Thread controle_thread(osPriorityNormal, 1024, &controle_stk[0]);

char tecla;

int x;
int direcao;
int cobraX[500];
int cobraY[500];
int tamanho;
int macaX;
int macaY;
int velocidade;
int aceleracao;
int pontuacao;
int statusJogo;

static void atualiza_task(void)
{
    for (;;) {

        buzz = 0;

        for (x = tamanho; x > 0; x--) {
            cobraX[x] = cobraX[x - 1];
            cobraY[x] = cobraY[x - 1];
        }

        if (direcao == 0)
            cobraX[0]--;
        if (direcao == 1)
            cobraY[0]--;
        if (direcao == 2)
            cobraX[0]++;
        if (direcao == 3)
            cobraY[0]++;

        terminal.SetCursor(cobraX[tamanho], cobraY[tamanho]);
        saida.printf(" ");

        if (macaX == cobraX[0] && macaY == cobraY[0]) {
            tamanho++;
            pontuacao++;
            
            buzz = 1;
            saida.putc('\a');
            
            macaX = 2 + (rand() % 77);
            macaY = 4 + (rand() % 18);
            
            aceleracao -= 10;
            velocidade += 10;
        }

        terminal.SetCursor(cobraX[0], cobraY[0]);
        saida.printf(FGRN("%c"), 219);

        terminal.SetCursor(macaX, macaY);
        saida.printf(FRED("%c"), 219);

        terminal.SetCursor(0, 0);
        saida.printf("Velocidade: %d", velocidade);

        terminal.SetCursor(20, 0);
        saida.printf("Pontos: %d", pontuacao);

        Thread::wait(aceleracao);

        for (x = 1; x < tamanho; x++) {
            if (cobraX[0] == cobraX[x] && cobraY[0] == cobraY[x]) {
                statusJogo = 0;
                return;
            }
        }

        if (cobraY[0] == 2 || cobraY[0] == 22 || cobraX[0] == 1 || cobraX[0] == 79) {
            statusJogo = 0;
            return;
        }
    }
}

static void controle_task(void)
{
    for(;;) {

        tecla = entrada.getc();

        if (tecla == 'a' || tecla == 'A')
            direcao = 0;
        if (tecla == 'w' || tecla == 'W')
            direcao = 1;
        if (tecla == 'd' || tecla == 'D')
            direcao = 2;
        if (tecla == 's' || tecla == 'S')
            direcao = 3;
    }
}

void resetaJogo()
{

    atualiza_thread.terminate();
    controle_thread.terminate();

    statusJogo = 1;
    
    memset(cobraX, 0, sizeof(cobraX));
    memset(cobraY, 0, sizeof(cobraY));
    cobraX[0] = 2;
    cobraY[0] = 12;
    
    tamanho = 1;
    
    direcao = 2;
    
    aceleracao = 200;
    velocidade = 10;
    
    pontuacao = 0;
}

void novoJogo()
{
    resetaJogo();

    terminal.Reset();
    terminal.Clear();

    for (x = 2; x < 22; x++) {
        terminal.SetCursor(0, x);
        saida.printf(FBLU("%c"), 219);
    }

    for (x = 0; x < 79; x++) {
        terminal.SetCursor(x, 2);
        saida.printf(FBLU("%c"), 219);
    }

    for (x = 2; x < 22; x++) {
        terminal.SetCursor(79, x);
        saida.printf(FBLU("%c"), 219);
    }

    for (x = 0; x < 80; x++) {
        terminal.SetCursor(x, 22);
        saida.printf(FBLU("%c"), 219);
    }

    srand(time(NULL));
    macaX = 2 + (rand() % 77);
    macaY = 4 + (rand() % 18);

    do {
        atualiza_thread.start(atualiza_task);
        controle_thread.start(controle_task);
    } while(statusJogo != 0);

    terminal.Reset();
    terminal.Clear();

    terminal.SetCursor(0, 0);

    saida.printf(FGRN("\r██████████████████████████████████████████████████████████████████████████████\r\n█                                                                            █\r\n█                                                                            █\r\n█          ████                           ██                                 █  \r\n█         █      ████   █       ███      █  █   █     █    ███   █ ███       █  \r\n█        █           █  █████  █   █    █    █  █     █   █   █  ██          █\r\n█        █  ███  █████  █ █ █  █████    █    █   █   █    █████  █           █\r\n█        █    █  █   █  █ █ █  █         █  █     █ █     █      █           █\r\n█         ████    ███   █ █ █   ████      ██       █       ████  █           █\r\n█                                                                            █\r\n█                                                                            █\r\n█                                                                            █\r\n█                             Pontuação: %d                                  █\r\n█                                                                            █\r\n█                                                                            █\r\n█                     Sua cobra ficou muito pequena!                         █\r\n█                                                                            █\r\n█             Pressione ENTER para tentar aumentar sua cobra.                █\r\n█                                                                            █\r\n██████████████████████████████████████████████████████████████████████████████"), pontuacao);

    resetaJogo();

    do {
        tecla = entrada.getc();
    } while((tecla != 13));

    novoJogo();
}

int main()
{
    saida.baud(115200);
    entrada.baud(115200);

    terminal.SetTerminal(&saida);
    terminal.Reset();
    terminal.Clear();
    
    terminal.SetCursor(0, 0);

    saida.printf(FGRN("\r██████████████████████████████████████████████████████████████████████████████\r\n█                                                                            █\r\n█                                                                            █\r\n█                                                                            █\r\n█                    ██████                █                                 █\r\n█                    ██   █  █ ███  ████   █   █   ███                       █\r\n█                     ██     ██  █      █  █  █   █   █                      █\r\n█                       ██   █   █  █████  ███    █████                      █\r\n█                    █   ██  █   █  █   █  █  █   █                          █\r\n█                    ██████  █   █   ███   █   █   ████                      █\r\n█                                                                            █\r\n█                                                                            █\r\n█                                                                            █\r\n█                                                                            █\r\n█                                                                            █\r\n█                                                                            █\r\n█                   Sua cobra pode ser realmente grande?                     █\r\n█                                                                            █\r\n█             Pressione ENTER para tentar aumentar sua cobra                 █\r\n█                                                                            █\r\n██████████████████████████████████████████████████████████████████████████████"));

    do {
        tecla = entrada.getc();
    } while((tecla != 13));

    novoJogo();

}