#if !defined(__XBEE_H_)
#define __XBEE_H_

#include "mbed.h"
#include <string.h>
#include <stdint.h> // uint8_t
#include <stdlib.h> // itoa
#include <math.h>

#define XB_SIZEBUF  64
#define XB_PAYLOAD  16

#define XBEE_COORD  0
#define XBEE_BROAD  1

// para poder declarar como typedef
typedef struct __attribute__ ((__packed__)) {
    uint8_t start_delimiter;
    uint8_t length_H;
    uint8_t length;
    // Frame do Pacote
    uint8_t frame_type;     // 10
    uint8_t frame_id;
    uint8_t dest_addr64[8];
    uint8_t dest_addr16[2];
    uint8_t broadcast_radius;
    uint8_t options;
    uint8_t rf_data[100]; //NOTE: last byte MUST be checksum
}pkt_tx;

// para poder declarar como typedef
typedef struct __attribute__ ((__packed__)) {
    uint8_t start_delimiter;
    uint8_t length_H;
    uint8_t length;
    // Frame do Pacote
    uint8_t frame_type;     // 8
    uint8_t frame_id;
    uint8_t command[2];         // ASCII
    uint8_t rf_data[16]; //NOTE: last byte MUST be checksum
}pkt_cmd;


/* Classe para controlar XBEE Zigbee usando API*/
class XBEE {
    public:
        uint8_t buf_tx[XB_SIZEBUF];     // Serial TX
        uint8_t buf_rx[XB_SIZEBUF];     // Serial RX
        //CircularBuffer<uint8_t, XB_SIZEBUF> buf_rx;
        int count_tx;
        int count_rx;
        // DEVICE DATA
        char NI[16];    // Device Name
        int ID;         // Net ID
        int MY;         // Device Net Address
        int SH;         // Serial High
        int SL;         // Serial Low
        int PL;         // Power Level
        int BD;         // Baud Rate
        int AO;         // API option
        int DB;         // RSSI between messages
        int TP;         // Temperature inside module
        
        //XBEE(PinName tx, PinName rx, int baud = 9600);
        XBEE(Serial* serial, int baud = 9600);
        /** Class destructor */
        virtual ~XBEE();
        void recvAttach (void);
        
        // High Level Function
        void init (void);
        int send_msg(char * str, int dest);
        int set_cfg(char * cmd, int value);
        int recv_msg(char * buf, int tam);
        int read_cfg(char * cmd, int & var);
        void clear_buf(void);
        
        // Low Level Function
        int create_TX(char * str, int dest);
        int create_CMD(char * cmd, int val);
        void sendBuffer(void);
        //void printBuffer(void);
        void recv_NI(void);
        void recv_CMD(int & cmd);
        void int_mng(int value);
        
        // Auxiliar Function
        //char validPackage (uint8_t * buf, int tam);
        int dec2hex(int nbr);
        int hex2dec(int nbr);   //ToDo
        
    protected:
        //RawSerial   *xbee;
        Serial* xbee;
        int int_ctrl;
};

#endif /* defined(__XBEE_H_) */