#ifndef GPS_H
#define GPS_H

#include "mbed.h"

#define gps_buffer  128 //GPS Buffer size
// GPS MESSAGE ID'S
#define GPMRC   "$GPRMC" //Recommended minimum specific GNSS data: time, date, position, course, speed
#define GPVTG   "$GPVTG" //Course over ground and ground speed  
#define GPGGA   "$GPGGA" //Global positioning system fixed data: time, position, fixed type
#define GPGSA   "$GPGSA"//GPS receiver operating mode,active satellites, and DOP values
#define GPGSV   "$GPGSV"//GNSS satellites in view: ID number, elevation, azimuth, and SNR values
#define GPGLL   "$GPGLL"//Geographic position:latitude, longitude, UTC time of position fix and status

//GPS class object
class GPS
{
public:
    /** Class constructor
    * @param serial is an RawSerial object that will be used for UART communication
    * @param pwr_pin the pin to power on/off GPS module
    * @param baud the baudrate for the UART that will interface the GPS module
    * */
    GPS(Serial* serial, PinName pwr_pin, int pwr_crtl = 1, int baud = 9600);
    /** Class destructor */
    virtual ~GPS();
    void recvAttach (void);
    void set_gps_on(void);
    void set_gps_off(void);
    int  data_availiable(float* _lat, float* _lon, float* _alt, float* _tFix, float* _speed, char* NS, char* EW, int* _date, char* Ualt);
    void int_mng(int value);
private:
    Serial* _gps;
    DigitalOut  *_pwr_pin;
    char gps_active;
    char data[90];

    
    float lat, lon, alt, tFix, speed, cog, hdop, vdop, pdop;
    char status, NorthSouth, EastWest,mode[2],sat[2],unit;
    int  date,fq, nst;
    int int_ctrl;
    
};
#endif