#include "gps.h"


GPS::GPS(Serial* serial, PinName pwr_pin, int pwr_crtl, int baud): _gps(serial) {
          _gps->attach(callback(this, &GPS::recvAttach), Serial::RxIrq);    
          _pwr_pin = new DigitalOut(pwr_pin, pwr_crtl);
          _gps->baud(baud);
}
GPS::~GPS(){
    delete _gps;
    delete _pwr_pin;
    
}

void GPS::recvAttach (void) 
{
   // if(int_ctrl == 1)
        if(_gps->readable()) {
            _gps->gets(data,90);
            printf("%s",data);
        }
}

void GPS::set_gps_on(void){
    *_pwr_pin = 1;
}

void GPS::set_gps_off(void){
    *_pwr_pin = 0;
}

int GPS::data_availiable(float* _lat, float* _lon, float* _alt, float* _tFix, float* _speed, char* NS, char* EW, int* _date, char* Ualt){
    // parse string.
    if(data[0] == '$'){
        if(strncmp(data, "$GPRMC", 6) == 0){
            sscanf(data, "$GPRMC,%f,%c,%f,%c,%f,%c,%f,,%d", &tFix, &status, &lat, &NorthSouth, &lon, &EastWest, &speed,  &date);     
            printf("date:%d\n",date);
            *_lat = lat;
            * _lon = lon;
            *_tFix = tFix;
            *_speed = speed;
            *NS = NorthSouth;
            *EW = EastWest;
            *_date = date;
             
        }else if (!strncmp(data, GPGSA, 6)){
            sscanf(data, "$GPSGA,%c,%d,%d,%d,,,,,,,,,,,,%f,%f,%f", &mode[0], &mode[1], &sat[0], &sat[1], &pdop, &hdop, &vdop);     
            //printf("hdop:%f\n",hdop);
            
             
        }else if(!strncmp(data, GPGGA, 6)){
            sscanf(data, "$GPGGA,%f,%f,%c,%f,%c,%d,%d,%f,,%f,%c", &tFix, &lat, &NorthSouth, &lon, &EastWest, &fq, &nst, &hdop, &alt, &unit);
            //printf("tfix:%f\n",tFix); 
            *_alt = alt;
            * _lon = lon;
            *_alt = alt;
            *NS = NorthSouth;
            *EW = EastWest;
            *_tFix = tFix;
            
        }else if(!strncmp(data, GPGLL, 6)){
            sscanf(data, "$GPGLL,%f,%c,%f,%c,%f", &lat, &NorthSouth, &lon, &EastWest, &tFix);
            //printf("lat:%f\n",lat);
            *_lat = lat;
            * _lon = lon;
            *NS = NorthSouth;
            *EW = EastWest;
            *_tFix = tFix;
        }
        data[0] = 0;
        return 1; 
    }else 
        return 0;    
}

void GPS::int_mng(int value){
    int_ctrl = value;
}
