#include "mbed.h"
//#include "ST7565SPI.h"
#include "TextLCD_ST7565SPI.h"

#define READBUFFERSIZE (32)
#define KEY_ROW0    PA_8
#define KEY_ROW1    PB_10
#define KEY_ROW2    PB_4
#define KEY_ROW3    PB_5
#define KEY_ROW4    PB_3
#define KEY_ROW5    PB_13
#define KEY_ROW6    PB_14
#define KEY_ROW7    PB_15

#define KEY_COL0    PB_1
#define KEY_COL1    PB_2
#define KEY_COL2    PB_11
#define KEY_COL3    PB_12


#define POWER_ON    PC_4

typedef struct KEYPAD {
    DigitalIn row;
    DigitalOut col;
    bool key_press;
    char name[7];
    char key;
} KEYPAD;

char buffer[50] = "HELLO, WORLD!!  HELLO, WORLD!!  HELLO, WORLD!!  ";

Serial pc(USBTX, USBRX);

DigitalIn ROW0(KEY_ROW0,PullDown);
DigitalIn ROW1(KEY_ROW1,PullDown);
DigitalIn ROW2(KEY_ROW2,PullDown);
DigitalIn ROW3(KEY_ROW3,PullDown);
DigitalIn ROW4(KEY_ROW4,PullDown);
DigitalIn ROW5(KEY_ROW5,PullDown);
DigitalIn ROW6(KEY_ROW6,PullDown);
DigitalIn ROW7(KEY_ROW7,PullDown);

   
DigitalOut COL0(KEY_COL0, 0);
DigitalOut COL1(KEY_COL1, 0);
DigitalOut COL2(KEY_COL2, 0);
DigitalOut COL3(KEY_COL3, 0);

DigitalOut POWR(POWER_ON, 0);

bool col0_pressed = false;
bool col1_pressed = false;
bool col2_pressed = false;
bool col3_pressed = false;
bool power_on = false;

TextLCD_ST7565SPI lcd(/*MOSI*/ PA_7, /*SCK*/ PA_5, /*CS*/ PB_6,
              /*RS*/ PC_7, /*RST*/ PA_9,21, 4 );// /*Frequency */1000000);

/*/ Dithered gray patterns
uint8_t const pattern[8][4] = {
    { 0xff, 0xff, 0xff, 0xff },  // 100%
    { 0x77, 0xff, 0xdd, 0xff },  // 87.5%
    { 0x55, 0xff, 0x55, 0xff },  // 75%
    { 0x55, 0xbb, 0x55, 0xee },  // 62.5%
    { 0x55, 0xaa, 0x55, 0xaa },  // 50%
    { 0x55, 0x22, 0x55, 0x88 },  // 37.5%
    { 0x55, 0x00, 0x55, 0x00 },  // 25%
    { 0x11, 0x00, 0x44, 0x00 }   // 12.5% 
};*/

void setOut(int data)
{
    switch (data)
    {
          case 0:
            COL0 = 1;
            COL1 = 0;
            COL2 = 0;
            COL3 = 0;
            break;
          case 1:
            COL0 = 0;
            COL1 = 1;
            COL2 = 0;
            COL3 = 0;
            break;
          case 2:
            COL0 = 0;
            COL1 = 0;
            COL2 = 1;
            COL3 = 0;
            break;
          case 3:
            COL0 = 0;
            COL1 = 0;
            COL2 = 0;
            COL3 = 1;
            break;
          default:
            COL0 = 0;
            COL1 = 0;
            COL2 = 0;
            COL3 = 0;    
    }
}

int ReadLineString( Serial& serial, char szReadBuffer[], const int ciReadBufferSize, int& riIndexChar, char szLineString[], const int ciLineStringSize )
{
    while( 1 )
    {
        if( !serial.readable() )
        {
            break;
        }
        char c = serial.getc();
        if( 'r' == c  )
        {
            szReadBuffer[riIndexChar] = '\0';
            strncpy( szLineString, szReadBuffer, ciLineStringSize - 1 );
            szLineString[ciLineStringSize - 1] = '\0';
            riIndexChar = 0;
            return 1;
        }
        else if( 's' == c )
        {
            szReadBuffer[riIndexChar] = '\0';
            strncpy( szLineString, szReadBuffer, ciLineStringSize - 1 );
            szLineString[ciLineStringSize - 1] = '\0';
            riIndexChar = 0;
            return 2;
        }
        else
        {
            if( (ciReadBufferSize - 1) > riIndexChar )
            {
                szReadBuffer[riIndexChar] = c;
                riIndexChar++;
            }
        }
    }
    return 0;
}

int main(void) {
   // Initialize LCD
    pc.baud(115200);
    
    POWR = 1;
    wait_ms(100);
    POWR = 0;
    
    char szReadBuffer[READBUFFERSIZE] = "";
    int iIndexChar = 0;
    
    char mesg[21];
    uint8_t count = 0;
    uint8_t a = 0;
    uint16_t c = 0;
    int x = 1;
    char szLineString[READBUFFERSIZE];
    while (1){
        
        //x = ReadLineString( pc, szReadBuffer, READBUFFERSIZE, iIndexChar, szLineString, READBUFFERSIZE );
        //pc.printf("x = %d\n", x);
        switch (x){
            case 1:
                power_on=true;
                POWR = 1;
                lcd.init(/*V0*/ 3, /*Contrast*/ 100, /*Bias*/ TextLCD_ST7565SPI::Bias1_9);
                lcd.cls();
                lcd.locate(0, 0);
                //lcd.printf(buffer);
                wait_ms(100);
                x=0;
                count = 0;
                a = 0;
                c = 0;
                //lcd.locate(count, 4);
                break;
            case 2:
                power_on=false;
                POWR = 0;
                COL0 = 0;
                COL1 = 0;
                COL2 = 0;  
                COL3 = 0;
            default:
                break;
        }
        
        if (power_on) {

            if (c==0) {
                c = 400;
                for (int i = 0; i<21; i++)
                {
                    mesg[i] = buffer[count + i];
                }
                count++;
                lcd.locate(0, 0);
                lcd.printf("%s\r\n",mesg);
                if (count==16) count = 0;
                
                lcd.locate(7, 2);
                lcd.printf("         ");
                
            }else c--;
                
                
            if(a == 0) a = 3;
            else a--;
    
            setOut(a);
            lcd.locate(7, 2);
            switch (a){
                case 0:
                    if(ROW0){                
                        if(!col0_pressed){
                            pc.printf("A");                
                            col0_pressed = true;
                        }
                        lcd.printf("  REDIAL ");
                    }else if(ROW1){
                        if(!col0_pressed){
                            pc.printf("H");
                            col0_pressed = true;
                        }
                        lcd.printf("  START  ");
                    }else if(ROW2) {
                        if(!col0_pressed){
                            pc.printf("B");
                            col0_pressed = true;
                        }
                        lcd.printf("   BACK  ");
                    }else if(ROW3){                
                        if(!col0_pressed){
                            pc.printf("C");                
                            col0_pressed = true;
                        }
                        lcd.printf("  CANCEL ");
                    }else if(ROW4){
                        if(!col0_pressed){
                            pc.printf("9");
                            col0_pressed = true;
                        }
                        lcd.printf("    9    ");
                    }else if(ROW5) {
                        if(!col0_pressed){
                            pc.printf("8");
                            col0_pressed = true;
                        }
                        lcd.printf("    8    ");
                    }else if(ROW6){
                        if(!col0_pressed){
                            pc.printf("7");
                            col0_pressed = true;
                        }
                        lcd.printf("    7    ");
                    }else if(ROW7) {
                        if(!col0_pressed){
                            pc.printf("D");
                            col0_pressed = true;
                        }
                        lcd.printf("PhoneBook");
                    }else col0_pressed = false;
                    
                    break;
                case 1:
                    if(ROW0){                
                        if(!col1_pressed){
                            pc.printf("E");                
                            col1_pressed = true;
                        }
                        lcd.printf("HandsFree");
                    }else if(ROW1){
                        if(!col1_pressed){
                            pc.printf("F");
                            col1_pressed = true;
                        }
                        lcd.printf("    OK   ");
                    }else if(ROW2) {
                        if(!col1_pressed){
                            pc.printf("G");
                            col1_pressed = true;
                        }
                        lcd.printf("   DOWN  ");
                    }else if(ROW3){                
                        if(!col1_pressed){
                            pc.printf("*");                
                            col1_pressed = true;
                        }
                        lcd.printf("    *    ");
                    }else if(ROW4){
                        if(!col1_pressed){
                            pc.printf("6");
                            col1_pressed = true;
                        }
                        lcd.printf("    6    ");
                    }else if(ROW5) {
                        if(!col1_pressed){
                            pc.printf("5");
                            col1_pressed = true;
                        }
                        lcd.printf("    5    ");
                    }else if(ROW6){
                        if(!col1_pressed){
                            pc.printf("4");
                            col1_pressed = true;
                        }
                        lcd.printf("    4    ");
                    }else col1_pressed = false;
                    
                    break;
                case 2:
                    if(ROW1){                
                        if(!col2_pressed){
                            pc.printf("I");                
                            col2_pressed = true;
                        }
                        lcd.printf("    UP   ");
                    }else if(ROW2){
                        if(!col2_pressed){
                            pc.printf("J");
                            col2_pressed = true;
                        }
                        lcd.printf("   MENU  ");
                    }else if(ROW3) {
                        if(!col2_pressed){
                            pc.printf("0");
                            col2_pressed = true;
                        }
                        lcd.printf("    0    ");
                    }else if(ROW4){                
                        if(!col2_pressed){
                            pc.printf("3");                
                            col2_pressed = true;
                        }
                        lcd.printf("    3    ");
                    }else if(ROW5){
                        if(!col2_pressed){
                            pc.printf("2");
                            col2_pressed = true;
                        }
                        lcd.printf("    2    ");
                    }else if(ROW6) {
                        if(!col2_pressed){
                            pc.printf("1");
                            col2_pressed = true;
                        }
                        lcd.printf("    1    ");
                    }else col2_pressed = false;
                    
                    break;
                case 3:
                    if(ROW0){                
                        if(!col3_pressed){
                            pc.printf("K");                
                            col3_pressed = true;
                        }
                        lcd.printf("   WiFi  ");
                    }else if(ROW1){
                        if(!col3_pressed){
                            pc.printf("L");
                            col3_pressed = true;
                        }
                        lcd.printf(" Receipt ");
                    }else if(ROW2) {
                        if(!col3_pressed){
                            pc.printf("M");
                            col3_pressed = true;
                        }
                        lcd.printf("    ID   ");
                    }else if(ROW3){                
                        if(!col3_pressed){
                            pc.printf("#");                
                            col3_pressed = true;
                        }
                        lcd.printf("    #    ");
                    }else if(ROW4){
                        if(!col3_pressed){
                            pc.printf("N");
                            col3_pressed = true;
                        }
                        lcd.printf("   COPY  ");
                    }else if(ROW5) {
                        if(!col3_pressed){
                            pc.printf("O");
                            col3_pressed = true;
                        }
                        lcd.printf("   SCAN  ");
                    }else if(ROW6){
                        if(!col3_pressed){
                            pc.printf("P");
                            col3_pressed = true;
                        }
                        lcd.printf("   FAX   ");
                    }else col3_pressed = false;
                    
                    break;
                default:
                    break;
            }
            wait_ms(1);
        }
    }

}
