// Wire Master Reader
// by Ronan S. Empig
#include "mbed.h"
#include "SDFileSystem.h"


I2C i2c(I2C_SDA, I2C_SCL);
Serial pc(SERIAL_TX, SERIAL_RX);

SDFileSystem sd(D11, D12, D13, D10, "sd"); // MOSI, MISO, SCK, CS
FILE *fp;


//State Machine
int STATEMACHINE = 0;
const int IDLESTATE = 0;
const int FWVERSIONMIN = 1;
const int UIBC5VENB = 2;
const int UIBCDISPENB = 3;
const int UIBCDISPENB2  = 4;
const int UIBCAUXTOUCHENABLE  = 5;
const int UIBCBACKLIGHTDUTY  = 6;

//Variables
char c;
int addr1 = 0;
int addr2 = 0;
int serbuff = 0;


void read8080(int faddress, int flength) {
  pinMode(D0X, INPUT);
  pinMode(D1X, INPUT);
  pinMode(D2X, INPUT);
  pinMode(D3X, INPUT);
  pinMode(D4X, INPUT);
  pinMode(D5X, INPUT);
  pinMode(D6X, INPUT);
  pinMode(D7X, INPUT);
  digitalWrite(CSX, LOW);
  digitalWrite(DCX, LOW);
  digitalWrite(WRX, HIGH);
  digitalWrite(RDX, LOW);
}

void write8080(int faddress, int flength) {
  pinMode(D0X, OUTPUT);
  pinMode(D1X, OUTPUT);
  pinMode(D2X, OUTPUT);
  pinMode(D3X, OUTPUT);
  pinMode(D4X, OUTPUT);
  pinMode(D5X, OUTPUT);
  pinMode(D6X, OUTPUT);
  pinMode(D7X, OUTPUT);
  STATE8080 = SIDLE;


  while (STATE8080 != SDONE) {
    switch (STATE8080) {
      case SIDLE:  
        digitalWrite(CSX, LOW);
        STATE8080 = SCOMMAND;
        delay(100);
      break;
      
      case SCOMMAND1:  
        digitalWrite(DCX, LOW);
        digitalWrite(CSX, LOW);
        digitalWrite(WRX, LOW);
        digitalWrite(RDX, HIGH);
        STATE8080 = SDATA;
        delay(100);
      break;
  
      case SCOMMAND2:  
        digitalWrite(WRX, HIGH);
        digitalWrite(D0X, bitRead();
        digitalWrite(D1X, LOW);
        digitalWrite(D2X, LOW);
        digitalWrite(D3X, LOW);
        digitalWrite(D4X, LOW);
        digitalWrite(D5X, LOW);
        digitalWrite(D6X, LOW);
        digitalWrite(D7X, LOW);
        STATE8080 = SDATA;
        delay(100);
      break;
  
      case SDATA:  
        digitalWrite(CSX, LOW);
        digitalWrite(DCX, LOW);
        digitalWrite(CSX, LOW);
        digitalWrite(WRX, LOW);
        digitalWrite(RDX, HIGH);
        STATE8080 = SDONE;
        delay(100);
      break;
  
      case SDONE:  
  
        STATE8080 = SCOMMAND;
        delay(100);
      break;
      
      default:  
       
      break;
    }
  }
}


int main()
{
    //char data_write[3];
    char data_write[3];
    //char data_wread[2];    
    //char data_read[2];        
    //char  data_counter = 0;
    
    pc.baud(115200);

    while(1) {
            //pc.printf("LOOPING\n");

    switch (STATEMACHINE) {
        
        case IDLESTATE:  //Wait for start from the computer
            //pc.printf("IDLE\n");
            addr1 = 0xAA;
            addr2 = 0xAA;
            serbuff = 0;

            //pc.printf("GOTCHA\n");
            if (pc.readable() ) {
                c = pc.getc();
                if( 'r' == c  ) {
                    STATEMACHINE = FWVERSIONMIN;
                    pc.printf("TRIGGERED\n");                    
                } else {
                    pc.printf("NOTTRIGGERED\n");                                        
                }
            }

        break;

    case FWVERSIONMIN:
/*      Wire.beginTransmission(addr2); // transmit to device address
      Wire.write(byte(0x01));              // sends control
      Wire.write(byte(0xFF));              // sends command
      error = Wire.endTransmission();    // stop transmitting 
      wait_ms(50);
      Wire.requestFrom(addr2, 1);
      while (Wire.available()) { 
        int c = Wire.read(); // receive a byte as character
        //Serial.write(c); //write data read from I2C to serial port for the software to read
        Serial.println(c); //write data read from I2C to serial port for the software to read
      }
*/      
//        data_wread[0] = 0x01;
//        data_wread[1] = 0xFF;
//        data_wread[0] = 0xFF;
//        i2c.write(addr2, data_wread, 1, 0);
//        i2c.read(addr2, data_read, 1, 0);        
//        pc.printf("Version Min: ");
//        pc.printf("Character: %c\n", data_read[0]);
        
        STATEMACHINE = UIBC5VENB;
    break;
        
    
    case UIBC5VENB: //power on the panel
/*
      Wire.beginTransmission(addr1); // transmit to device 0x2C
      Wire.write(byte(0x00));    // sends control
      Wire.write(byte(0x1E));    // sends command
      Wire.write(byte(0xFF));    // sends data
      error = Wire.endTransmission();    // stop transmitting    
*/
        pc.printf("UIBC5VENB\n");
        data_write[0] = 0x00;
        data_write[1] = 0x06 << 1; //shl 0x06 with 1
        data_write[2] = 0xFF;
//        data_write[0] = 0x06;
//        data_write[1] = 0xFF;
        i2c.write(addr2, data_write, 3, 0);

//        i2c.write(addr2, data_write, 2, 0);
      wait_ms(1000);
      STATEMACHINE = UIBCDISPENB;
    break;

    case UIBCDISPENB: //get panel button address from software
        pc.printf("UIBCDISPENB\n");
        data_write[0] = 0x00;
        data_write[1] = 0x02 << 1;  //shl 0x02 with 1
        data_write[2] = 0xFF;
//        data_write[0] = 0x02;
//        data_write[1] = 0xFF;

        i2c.write(addr2, data_write, 3, 0);
//        i2c.write(addr2, data_write, 2, 0);
      wait_ms(1000);
      STATEMACHINE = UIBCDISPENB2;

    break;
    
    case UIBCDISPENB2:
        pc.printf("UIBCDISPENB2\n");    
        data_write[0] = 0x00;
        data_write[1] = 0x05 << 1;  //shl 0x05 with 1
        data_write[2] = 0xFF;
//        data_write[0] = 0x05;
//        data_write[1] = 0xFF;

        i2c.write(addr2, data_write, 3, 0);
        //i2c.write(addr2, data_write, 2, 0);
        wait_ms(1000);
        STATEMACHINE = UIBCAUXTOUCHENABLE;
    break;
    
    case UIBCAUXTOUCHENABLE:
        pc.printf("UIBCAUXTOUCHENABLE\n");    
        data_write[0] = 0x00;
        data_write[1] = 0x07 << 1;  //shl 0x07 with 1
        data_write[2] = 0xFF;
//        data_write[0] = 0x07;
//        data_write[1] = 0xFF;
        
        i2c.write(addr2, data_write, 3, 0);
//        i2c.write(addr2, data_write, 2, 0);
        wait_ms(1000);
        STATEMACHINE = UIBCBACKLIGHTDUTY;
    break;

    case UIBCBACKLIGHTDUTY:
        pc.printf("UIBCBACKLIGHTDUTY\n");    
        data_write[0] = 0x10;
        data_write[1] = 0x80 << 1;  //shl 0x80 with 1
        data_write[2] = 0xFF;

//        data_write[0] = 0x80;
//        data_write[1] = 0xFF;
        
        i2c.write(addr2, data_write, 3, 0);
        //i2c.write(addr2, data_write, 2, 0);        

        wait_ms(1000);
        STATEMACHINE = IDLESTATE;
        
    break;



    default:
    
    break;
  }
  }
}