/*OP Panel Tester Offline by Ronan S. Empig*/


#include "mbed.h"
#include "SDFileSystem.h"

Serial pc(USBTX, USBRX);
SDFileSystem sd(D11, D12, D13, D10, "sd"); // MOSI, MISO, SCK, CS
FILE *fp;

I2C i2c(PB_9, PB_8);




//SD Card

// ** MOSI - pin 11
// ** MISO - pin 12
// ** CLK - pin 13
// ** CS - pin 4 (for MKRZero SD: SDCARD_SS_PIN)

//8080-I series 8-bit Parallel Interface

//State Machine

int STATEMACHINE = 0;
const int IDLESTATE = 0;
const int POWERON = 1;
const int GETADDRESS = 2;
const int GOTOAPP = 5;
const int UIBC5VENB = 14;
const int UIBCDISPENB = 15;
const int UIBCDISPENB2  = 16;
const int UIBCAUXTOUCHENABLE  = 17;
const int LED1CTRL = 18;
const int LED1DUTY = 19;
const int UIBCBACKLIGHTDUTY  = 20;
const int DONESTATE = 21;
const int LCDTESTINIT = 22;
const int LCDTEST1 = 23;
const int LCDTEST2 = 24;

const int LED2CTRL = 25;
const int LED2DUTY = 26;
const int RACASET = 27;
const int GOODDONE = 28;
/*
const int TOUCHTEST1 = 25;
const int TOUCHTEST2 = 26;
const int TOUCHTEST3 = 27;
const int TOUCHTEST4 = 28;
*/
const int TOUCHTEST5 = 29;
const int TOUCHTEST6 = 30;
const int TOUCHTEST7 = 31;
const int TOUCHTEST8 = 32;

const int TOUCHDETECT = 33;
const int TOUCHTESTINIT = 34;
const int WAITCONTINUE = 35;
const int FWUPDATE = 36;

//Variables
int addr1 = 0;
int addr2 = 0;
int addrsht = 0x00;
unsigned char LowByteChecksum;


//byte error = 0;
unsigned char command;
unsigned char data1;
int RDDIDVal = 0;
int cntbytes = 0;
int cntWrite = 0;
char fwROM[8];
char flRead[8];
char ISPRdy[8];

int pageNum = 0;

char *fName;
bool touch1 = false;
bool touch2 = false;
bool touch3 = false;
bool touch4 = false;
bool touch5 = false;
bool touchkey1 = false;
bool touchkey2 = false;
bool touchkey3 = false;
bool touchresult = false;
//---------------------------------------------------------
DigitalIn buttonNext(PC_4);  // button (pull-up) is connected to P18

DigitalOut nRD(PC_8);                        /* read data from SSD1963 active LOW - but not used */
DigitalOut nWR(PC_6);                        /* write out to SSD1963 active LOW */
DigitalOut DC(PC_5);                         /* Data/Command Select: 1=Command,  0=Data); */

DigitalOut CS(PA_10);                         /* chip select the SSD1963 active LOW */

/* data bus I/O pins */

BusInOut DB(PB_14,PB_15,PB_1,PB_2,PB_11,PB_12,PA_11,PA_12);    /* databus D7-D0 */

DigitalOut powerPanel(PB_3);

//LCD*****************************************************
//******************************************************************************
void Write_Command(unsigned char command) {
    CS=0;          
    nRD = 1;        /* make sure the RD  is HIGH just to be sure */
    DC=0;
    nWR  = 0;
    //wait_us(1);
    DB=command;    
    wait_us(1);
    DB.output();
    DB=command;
    wait_us(1);
    nWR  = 1;
}


//;******************************************************************************
void Write_Data(unsigned char data1) {
    CS=0;
    nRD = 1;
    DC=1;
    nWR  = 0;
    DB.output();
    DB=data1;
    DB=data1;
    
    //wait_us(1);    
    nWR  = 1;
}

//;******************************************************************************
int Read_Data() {
    CS=0;       
    nRD = 0;
    DC=1;
    nWR  = 1;
    wait_us(1);

    nRD  = 1;
    wait_us(1);
    DB.input();
    int intRead = DB.read();
    return intRead;
}


//====================================================
void RDDID_Read(unsigned char REG) {
    Write_Command(REG);
    int intrd;
wait_us(1);
    intrd = Read_Data();
    printf("0x%02x\n", intrd); 
wait_us(1);
    intrd = Read_Data();
    printf("0x%02x\n", intrd); 
    RDDIDVal = intrd;
wait_us(1);
    intrd = Read_Data();
    printf("0x%02x\n", intrd); 
    RDDIDVal = (RDDIDVal << 16) | intrd << 8;
wait_us(1);
    intrd = Read_Data();
    printf("0x%02x\n", intrd); 
    RDDIDVal = RDDIDVal | intrd;
    printf("0x%06x\n", RDDIDVal); 
}


//====================================================
void Command_Write(unsigned char REG,unsigned char VALUE) {
    Write_Command(REG);
    Write_Data(VALUE);
}
//======================================================
void SendData(unsigned char datahi, unsigned char datalow) {
    //Write_Data((color)>>16);    //red
    //Write_Data((color)>>8);     //green
    Write_Data(datahi);          //blue
    Write_Data(datalow);          //blue

}
//======================================================
// initialize controller
//======================================================
void tianma_2p8_st7789vi_power_on() {
    wait_ms(100);
    Write_Command(0x01);     //Software Reset
    wait_ms(1000);

    Write_Command(0x11);
    wait_ms(120);
    Write_Command(0x36);
    Write_Data(0x00);
    Write_Command(0x3a);
    Write_Data(0x55);
/*----------------------------ST7789S   Frame   rate    setting---------------------------------*/          
    Write_Command(0xb2);
    Write_Data(0x0c);
    Write_Data(0x0c);
    Write_Data(0x00);
    Write_Data(0x33);
    Write_Data(0x33);
    Write_Command(0xb7);
    Write_Data(0x35);
/*-----------------------------ST7789S  Power   setting-------------------------------------*/          
    Write_Command(0xbb);
    Write_Data(0x19);
    Write_Command(0xc0);
    Write_Data(0x2c);
    Write_Command(0xc2);
    Write_Data(0x01);
    Write_Command(0xc3);
    Write_Data(0x1d);
    Write_Command(0xc4);
    Write_Data(0x20);
    Write_Command(0xc6);
    Write_Data(0x0f);
    Write_Command(0xd0);
    Write_Data(0xa4);
    Write_Data(0xa1);
/*----------------------------ST7789S   gamma   setting--------------------------------------*/         
    Write_Command(0xe0);
    Write_Data(0xdb);
    Write_Data(0x1b);
    Write_Data(0x1d);
    Write_Data(0x0f);
    Write_Data(0x0f);
    Write_Data(0x3a);
    Write_Data(0x3e);
    Write_Data(0x45);
    Write_Data(0x4d);
    Write_Data(0x1c);
    Write_Data(0x16);
    Write_Data(0x15);
    Write_Data(0x1d);
    Write_Data(0x21);
    Write_Command(0xe1);
    Write_Data(0xdb);
    Write_Data(0x1b);
    Write_Data(0x1d);
    Write_Data(0x0f);
    Write_Data(0x0f);
    Write_Data(0x3a);
    Write_Data(0x3e);
    Write_Data(0x45);
    Write_Data(0x4d);
    Write_Data(0x1c);
    Write_Data(0x16);
    Write_Data(0x15);
    Write_Data(0x1d);
    Write_Data(0x21);
/*-----------------------------ST7789S  Display ON--------------------------------------*/          
    Write_Command(0x29);
    wait_ms(50);
};

void yeebo_st7789v_power_on() {
    wait_ms(100);
    Write_Command(0x01);     //Software Reset
    wait_ms(1000);

    Write_Command(0x11);
    wait_ms(120);
    Write_Command(0x36);
    Write_Data(0x00);
    Write_Command(0x3a);
    Write_Data(0x55);
//----------------------------ST7789S   Frame   rate    //setting----------------------------------//               
    Write_Command(0xb2);
    Write_Data(0x0c);
    Write_Data(0x0c);
    Write_Data(0x00);
    Write_Data(0x33);
    Write_Data(0x33);
    Write_Command(0xb7);
    Write_Data(0x35);
//-----------------------------ST7789S  Power   //setting--------------------------------------//           
    Write_Command(0xbb);
    Write_Data(0x28);
    Write_Command(0xc0);
    Write_Data(0x2c);
    Write_Command(0xc2);
    Write_Data(0x01);
    Write_Command(0xc3);
    Write_Data(0x10);
    Write_Command(0xc4);
    Write_Data(0x20);
    Write_Command(0xc6);
    Write_Data(0x0f);
    Write_Command(0xd0);
    Write_Data(0xa4);
    Write_Data(0xa1);
//----------------------------ST7789S   gamma   //setting---------------------------------------//          
    Write_Command(0xe0);
    Write_Data(0xd0);
    Write_Data(0x00);
    Write_Data(0x02);
    Write_Data(0x07);
    Write_Data(0x0a);
    Write_Data(0x28);
    Write_Data(0x32);
    Write_Data(0x44);
    Write_Data(0x42);
    Write_Data(0x06);
    Write_Data(0x0e);
    Write_Data(0x12);
    Write_Data(0x14);
    Write_Data(0x17);
    Write_Command(0xe1);
    Write_Data(0xd0);
    Write_Data(0x00);
    Write_Data(0x02);
    Write_Data(0x07);
    Write_Data(0x0a);
    Write_Data(0x28);
    Write_Data(0x31);
    Write_Data(0x54);
    Write_Data(0x47);
    Write_Data(0x0e);
    Write_Data(0x1c);
    Write_Data(0x17);
    Write_Data(0x1b);
    Write_Data(0x1e);
/*-----------------------------ST7789S  Display ON--------------------------------------*/          
    Write_Command(0x29);
    wait_ms(50);
};


void Init_SSD1963 (void) {
    wait_ms(100);
    Write_Command(0x01);     //Software Reset
    wait_ms(1000);

    Write_Command(0x11);
    wait_ms(120);
    Write_Command(0x36);
    Write_Data(0x00);
    Write_Command(0x3a);
    Write_Data(0x55);
    Write_Command(0xb2);
    Write_Data(0x0c);
    Write_Data(0x0c);
    Write_Data(0x00);
    Write_Data(0x33);
    Write_Data(0x33);
    Write_Command(0xb7);
    Write_Data(0x35);
    Write_Command(0xbb);
    Write_Data(0x19);
    Write_Command(0xc0);
    Write_Data(0x2c);
    Write_Command(0xc2);
    Write_Data(0x01);
    Write_Command(0xc3);
    Write_Data(0x1d);
    Write_Command(0xc4);
    Write_Data(0x20);
    Write_Command(0xc6);
    Write_Data(0x0f);
    Write_Command(0xd0);
    Write_Data(0xa4);
    Write_Data(0xa1);
    Write_Command(0xe0);
    Write_Data(0xdb);
    Write_Data(0x1b);
    Write_Data(0x1d);
    Write_Data(0x0f);
    Write_Data(0x0f);
    Write_Data(0x3a);
    Write_Data(0x3e);
    Write_Data(0x45);
    Write_Data(0x4d);
    Write_Data(0x1c);
    Write_Data(0x16);
    Write_Data(0x15);
    Write_Data(0x1d);
    Write_Data(0x21);
    Write_Command(0xe1);
    Write_Data(0xdb);
    Write_Data(0x1b);
    Write_Data(0x1d);
    Write_Data(0x0f);
    Write_Data(0x0f);
    Write_Data(0x3a);
    Write_Data(0x3e);
    Write_Data(0x45);
    Write_Data(0x4d);
    Write_Data(0x1c);
    Write_Data(0x16);
    Write_Data(0x15);
    Write_Data(0x1d);
    Write_Data(0x21);
    Write_Command(0x29);
    wait_ms(50);
}

void ChecksumCalculation(unsigned short *pChecksum,unsigned char *pInData,unsigned long Len)
{
    unsigned long i;
    for(i = 0; i < Len; i++)
    {
        *pChecksum += (unsigned short)pInData[i];
        LowByteChecksum = (unsigned char)(*pChecksum & 0xFF);
        LowByteChecksum = (LowByteChecksum) >> 7 | (LowByteChecksum) << 1;
        *pChecksum = (*pChecksum & 0xFF00) | LowByteChecksum;
    }
}

void RefreshScreen() {
    //unsigned char x,y;
    int x = 0;
    int y = 0;
    Write_Command(0x2c);

    for (x=0;x<=320;x++) {
        for (y=0;y<=240;y++) {
            if (y<80) {
                SendData(0xF8,0x00);   
            } else if (y<160) {
                SendData(0x07,(0xE0));                                   
            } else if (y<240) {
                SendData((0x00),(0x1F));                                   
            }
        }
    }    
}

void SendBlack() {
    //unsigned char x,y;
    int x = 0;
    int y = 0;
    Write_Command(0x2c);

    for (x=0;x<=320;x++) {
        for (y=0;y<=240;y++) {
            SendData(0x00,0x00);   
        }
    }    
}

void SendWhite() {
    //unsigned char x,y;
    int x = 0;
    int y = 0;
    Write_Command(0x2c);
    for (x=0;x<=320;x++) {
        for (y=0;y<=240;y++) {
            SendData(0xFF,0xFF);   
        }
    }    
}

void ControlLED(int LedAddress, int LedMode) {
    char i2cd[3];

            i2cd[0] = 0x01;
            i2cd[1] = LedAddress;
            i2cd[2] = LedMode;

            i2c.start();
            i2c.write((addr1 << 1), i2cd, 3, false); 
            i2c.stop();

          wait_ms(100);
    
            i2cd[0] = 0x01;
            i2cd[1] = LedAddress + 1;
            i2cd[2] = 0xAF;
    
            i2c.start();
            i2c.write((addr1 << 1), i2cd, 3, false); 
            i2c.stop();
          wait_ms(100);
}

void FeedbackTouch(bool touchCorrect) {
    if (touchCorrect) {
        ControlLED(0x40, 0x08);
        ControlLED(0x42, 0x00);
    } else {
        ControlLED(0x40, 0x00);
        ControlLED(0x42, 0x08);
    }         
}


void RefreshScreenGood() {
    //unsigned char x,y;
    int x = 0;
    int y = 0;
    Write_Command(0x2c);

    for (x=0;x<=320;x++) {
        for (y=0;y<=240;y++) {
            SendData(0x07,(0xE0));                                   
        }
    }    
}

//LCD*********************************************************

void initsetup() {
//  Wire.begin();        // join i2c bus (address optional for master)     
  pc.baud(115200);
  powerPanel = 0;
}


void WaitISP() {
        //ISP ready
        addrsht = (addr2 << 1) | 0x01; //control bit = 1
        int ispready=0;
        bool onceOnly = false;
        while ((ispready!=0x8F)) {
            i2c.start();            
            i2c.write(addrsht); 
            i2c.read(addrsht,ISPRdy, 8); 
            ispready = ISPRdy[0];
            i2c.stop();
            if (!onceOnly) {
                printf("ISP Ready Byte 0 : ");
                printf("0x%02x\n", ispready);
            }
            onceOnly =true;
                wait_ms(400);

        }
wait_ms(100);        
}

void ReadMem() {
        //ISP ready
        addrsht = (addr2 << 1) | 0x01; //control bit = 1
        char ISPRead[8];
    pc.printf("Initializing\r\n");
    fp = fopen("/sd/dump.bin", "r");
    if (fp != NULL) {
        fclose(fp);
        remove("/sd/dump.bin");
        //pc.printf("Remove an existing file with the same name\r\n");
    }

    fp = fopen("/sd/dump.bin", "w");
    if (fp == NULL) {
        pc.printf("Unable to write the file\r\n");
    } else {

        for (int x=0;x<0x0F;x++) {
            i2c.start();            
            i2c.write(addrsht); 
            i2c.write(0x83); 
            i2c.write(0x00);
            i2c.write(x);
            i2c.write(0x00);
            i2c.write(0x00);
            i2c.write(0x00);
            i2c.write(0x00);
            i2c.write(0x00);
            i2c.stop(); 
            wait_ms(50);
            for (int j=0;j<128;j++) {
                i2c.start();            
                i2c.write(addrsht); 
                for (int i=0;i<8;i++) {
                    i2c.read(addrsht,ISPRead, 8); 
                    
                    fwrite(ISPRead, 1, 8, fp);
                    for (int y = 0; y < 8; y++)
                    {
                        printf("%02X\r\n", ISPRead[y]);
                    }
                }            
                i2c.stop();            
            }
        }
    //    pc.printf("File successfully written!\r\n");
        fclose(fp);
    }
        
wait_ms(100);        
}

void ISPUnlock() {
            //unlock
            i2c.start();
            i2c.write((addr2 << 1)); 
            i2c.write(0x87);
            i2c.write(0x00);
            i2c.write(0x00);
            i2c.write(0x00);
            i2c.write(0x00);
            i2c.write(0x00);
            i2c.write(0x00);
            i2c.write(0x00);
            i2c.stop();    
            wait_ms(150);
}

void ISPReset() {
            //reset
            i2c.start();
            i2c.write((addr2 << 1)); 
            i2c.write(0x84);
            i2c.write(0x00);
            i2c.write(0x00);
            i2c.write(0x00);
            i2c.write(0x00);
            i2c.write(0x00);
            i2c.write(0x00);
            i2c.write(0x00);
            i2c.stop();    
}


void ISPMassErase() {
            //mass erase
            i2c.start();
            i2c.write((addr2 << 1)); 
            i2c.write(0x86);
            i2c.write(0x00);
            i2c.write(0x10);
            i2c.write(0x00);
            i2c.write(0x00);
            i2c.write(0x00);
            i2c.write(0x00);
            i2c.write(0x00);
            i2c.stop();    
}


int writeI2CSitronix(int address, char i2cWrite[], int wLen) {
    i2c.start();
    int error = i2c.write(address, i2cWrite, wLen);
    i2c.stop();
    return error;
}


int writeByteI2CSitronix(int address, char i2cWByte) {
        i2c.start();
        i2c.write(address); 
        i2c.write(0x01);
        i2c.stop();
}


int main() {
    buttonNext.mode(PullUp);
    initsetup();
    char i2cd[3];

    //char i2cwr[2];
    int i2cr = 0x00;

    int i2crkey = 0x00;    
    int i2crxhi = 0x00;
    int i2cryhi = 0x00;
    int i2crxlo = 0x00;
    int i2crylo = 0x00;

    int i2crx = 0x00;
    int i2cry = 0x00;
    
    int databin = 0x00;
    unsigned char datalo;
    unsigned char datahi;
    //i2c.frequency(100000);
  while (1) {
      switch (STATEMACHINE) {
        case IDLESTATE:  //Wait for start from the computer
        printf("IDLE\n");
          powerPanel = 0;

          addr1 = 0;
          addr2 = 0;
            STATEMACHINE = POWERON;        
          addr1 = 0;
        break;
        
        case POWERON: //power on the panel
        printf("POWERON\n");
          powerPanel = 1;
          STATEMACHINE = GETADDRESS;
        break;
    
        case GETADDRESS: //get panel button address from software
          STATEMACHINE = GOTOAPP;        
          addr1 = 44;
          addr2 = 85;
          wait_ms(100);
        break;
        
        case GOTOAPP: //Reset the panel
        //POR timing fixer
        printf("GOTOAPP\n");
          powerPanel = 0;
          wait_ms(2000);
        printf("GOTOAPPDONE1\n");

          powerPanel = 1;
          wait_ms(1500);
        printf("GOTOAPPDONE2\n");
          
          STATEMACHINE = UIBC5VENB;
        break;
    
    
        case UIBC5VENB: //power on the panel
            //char i2cd[3];
            
            i2cd[0] = 0x01;
            i2cd[1] = 0x06;
            i2cd[2] = 0xFF;
            
            i2c.start();
            i2c.write((addr1 << 1), i2cd, 3, false); 
            i2c.stop();    

          wait_ms(100);
            RDDID_Read(0x04);          //Read RDDID

          STATEMACHINE = LED1CTRL;
          //STATEMACHINE = FWUPDATE;

    wait(2);
    pc.printf("Initializing\r\n");
    fp = fopen("/sd/hello.txt", "r");
    if (fp != NULL) {
        fclose(fp);
        remove("/sd/hello.txt");
        //pc.printf("Remove an existing file with the same name\r\n");
    }

    fp = fopen("/sd/hello.txt", "w");
    if (fp == NULL) {
    //    pc.printf("Unable to write the file\r\n");
    } else {
        fprintf(fp, "mbed SDCard application!");
        fclose(fp);
    //    pc.printf("File successfully written!\r\n");
    }
                    fclose(fp);

              
        break;
        
        
        case FWUPDATE:
            RDDID_Read(0x04);          //Read RDDID
            
//Go to ISP mode   
            char i2fwupdatemode[] = {0,'S',0,'T',0,'X',0,'_',0,'F',0,'W',0,'U',0,'P'};            
            
            //i2c.start();
            //i2c.write((addr2 << 1), i2fwupdatemode, 9);
            //i2c.stop();
            
            for(int i=0;i<sizeof(i2fwupdatemode); i+=2) {
                //pc.printf("0x%02x\n", &i2fwupdatemode[i]);
                if(writeI2CSitronix((addr2 << 1), &i2fwupdatemode[i], 2) < 0)
                {
                    pc.printf("Entering ISP fail.\n");
                    goto done;
                }
            }

            wait_ms(150);


            ISPReset();
            wait(1);
        
//REG_DEVICE_STATUS
            
            addrsht = (addr2 << 1) | 0x01; //control bit = 1
            i2c.start();
            i2c.write((addr2 << 1)); 
            i2c.write(0x01);
            i2c.stop();
wait_ms(50);
            i2c.start();            
            i2c.write(addrsht); 
            i2c.read(addrsht,fwROM, 8); 
            i2c.stop();

            printf("0x%02x\n", addrsht);            
            printf("ROM Status : ");
            printf("0x%08x%08x\n\n", *(int *)(fwROM+4), *(int *)fwROM);
            
            wait_ms(100);


//Flash page erase
            for(int i=0;i<16; i++) {

                pc.printf("Unlocking...\r\n");
                    ISPUnlock();
                    
                    //ISP ready
                    WaitISP();
        
                pc.printf("Erasing page 0x%x...\r\n", i);
                    //erase
                    i2c.start();
                    i2c.write((addr2 << 1)); 
                    i2c.write(0x80);
                    i2c.write(0x00);            
                    i2c.write(i);
                    i2c.write(0x00);            
                    i2c.write(0x00);            
                    i2c.write(0x00);            
                    i2c.write(0x00);            
                    i2c.write(0x00);                                    
                    i2c.stop();
        //wait(20);
                    WaitISP();
        //wait(20);
            }

//******************************************PROGRAMSTART*****************************************************************
//Flash Page Program
            
fName = "/sd/sitronix_sitronix_st16xx.LM28_v05110323_01_20181023.bin";
        pc.printf("Reading SD...\r\n");
            //Open File
            pc.printf("Initializing\r\n");
            wait(2);
            //pc.printf(" Opening %s\r\n","/sd/sitronix_sitronix_st16xx.LM28_v05110323_01_20181023.bin");
            pc.printf("Opening %s\r\n",fName);
            //fp = fopen("/sd/sitronix_sitronix_st16xx.LM28_v05110323_01_20181023.bin", "r");
            fp = fopen(fName, "r");
            if (fp == NULL) {
                fclose(fp);
                pc.printf("Error: File not found!\r\n");
            }
            pageNum = 0;

        pc.printf("writing flash...\r\n");
            
            while ((!feof(fp)) && (pageNum < 0x0F)) { 
                //ISP_WRITE_FLASH (BIN)
                pc.printf("Unlocking...\r\n");            
                ISPUnlock();
                WaitISP();
                pc.printf("Writing bin page 0x%02x...\r\n", pageNum);

                i2c.start();
                i2c.write((addr2 << 1)); 
                i2c.write(0x82);
                i2c.write(0x00);
                i2c.write(pageNum);
                i2c.write(0x00);
                i2c.write(0x00);
                i2c.write(0x00);
                i2c.write(0x00);
                i2c.write(0x00);
                i2c.stop();
                wait_ms(50);
                int cntByteLen = 7;
                    //ISP_WRITE_DATA (BIN)
                    //open bin file
                    cntWrite = 0;
                                            
                    while ((cntWrite < 147)) { //page loop                     
                        i2c.start();
                        i2c.write((addr2 << 1)); 
                        i2c.write(0x81);
                        cntbytes = 0;
                        wait_ms(50);
                        cntByteLen = 7;
                        while ((cntbytes < cntByteLen) && (((cntWrite*7)+(cntbytes)) < 1024)) { //write data loop
                            databin = fgetc(fp);    
                            //wait(1);
 //                           if (databin == 0xffffffff) {
 //                               pc.printf("Printing FF\r\n");
 //                               i2c.write(0xFF);
 //                           } else {
                                i2c.write(databin);                            
 //                           }
                            cntbytes++;
                        } //write data loop end
                        i2c.stop();
                        cntWrite++;
                        wait_ms(50);
                    } //page loop end
                    wait_ms(150);
                    WaitISP();
                pageNum++;
            }
            fclose(fp);
            //free(fp);
            //ISP_WRITE_FLASH (CFG)
            //open bin file

            switch(RDDIDVal) {
                case 0x540000:
                    fName = "540000.cfg";
                    printf("Yeebo\r\n");
                break;
    
                case 0x448552:
                    fName = "448552.cfg";
                    printf("Tianma1\r\n");
                break;
                
                case 0x468552:
                    fName = "468552.cfg";
                    printf("Tianma2\r\n");                    
                break;

                case 0x560000:
                    fName = "/sd/560000.cfg";
                    printf("Yeebo56\r\n");                    
                break;                
                
                default:
                    fName = "540000.cfg";
                    printf("YeeboDefault\r\n");                    
                break;
            }
            pc.printf("Initializing\r\n");
wait(2);
//fName = "/sd/touchtest.bmp";
            pc.printf("Opening : %s\r\n",fName);
            fp = fopen(fName, "r");
            if (fp == NULL) {
                fclose(fp);
                pc.printf("Error: File not found!\r\n");
            }
            pc.printf("start writing cfg\r\n");
            
            pageNum = 0x0F;
                int cntByteLen = 7;

            while ((!feof(fp)) && (pageNum < 0x10)) { 
                //ISP_WRITE_FLASH (CFG)
                pc.printf("Unlocking...\r\n");            
                ISPUnlock();
                WaitISP();
                pc.printf("Writing cfg page 0x%02x...\r\n", pageNum);

                i2c.start();
                i2c.write((addr2 << 1)); 
                i2c.write(0x82);
                i2c.write(0x00);
                i2c.write(pageNum);
                i2c.write(0x00);
                i2c.write(0x00);
                i2c.write(0x00);
                i2c.write(0x00);
                i2c.write(0x00);
                i2c.stop();
                wait_ms(50);
                int cntByteLen = 7;

                    //ISP_WRITE_DATA (CFG)
                    //open bin file
                    cntWrite = 0;
                    
                    while ((cntWrite < 147)) { //page loop                     
                        i2c.start();
                        i2c.write((addr2 << 1)); 
                        i2c.write(0x81);
                        cntbytes = 0;
                        wait_ms(50);
                        //cntByteLen = 1024-cntWrite*7;
                        //if (cntByteLen>7) {
                        //    cntByteLen = 7;
                        //}
                        cntByteLen = 7;
                        while ((cntbytes < cntByteLen) && (((cntWrite*7)+(cntbytes)) < 1024)) { //write data loop
                            databin = fgetc(fp);    
                            pc.printf("Writing data 0x%02x...\r\n", databin);
                            pc.printf("CntBytes : 0x%0x\r\n",cntbytes);
                            //wait(1);
                            if (databin == 0xffffffff) {
                                pc.printf("Printing FF\r\n");
                                i2c.write(0xFF);
                            } else {
                                pc.printf("Printing Normal\r\n");
                                i2c.write(databin);                            
                            }

                            cntbytes++;
                        } //write data loop end
                        i2c.stop();
                        cntWrite++;
                        wait_ms(50);
                    } //page loop end
                    wait_ms(150);                    
                    WaitISP();
                pageNum++;
            }
            
            wait_ms(100);
            fclose(fp);
            wait_ms(100);   
     
//******************************************PROGRAMEND*****************************************************************

/*
//Flash Page Read
            addrsht = (addr2 << 1) | 0x01; //control bit = 1
            i2c.start();
            i2c.write((addr2 << 1)); 
            i2c.write(0x83);
            i2c.write(0x00);
            i2c.write(0x00); //read page 00            
            i2c.write(0x00);
            i2c.write(0x00);
            i2c.write(0x00);
            i2c.write(0x00);
            i2c.write(0x00);
            i2c.stop();

            i2c.start();            
            i2c.write(addrsht); 
            i2c.read(addrsht,flRead, 1024); 
            i2c.stop();

            printf("0x%02x\n", addrsht);            
            printf("0x%01024x\n", flRead);           
*/
            ReadMem();

            printf("1\r\n");
//Reset A008
            ISPReset();
            wait(2);
/*            
//Flash Mass Erase            
            ISPUnlock();
            WaitISP();
*/            
  
done:
          STATEMACHINE = LED1CTRL;

        break;
    

        case LED1CTRL:
            printf("2\r\n");
            ControlLED(0x40, 0x08);
            ControlLED(0x42, 0x08);

          STATEMACHINE = UIBCDISPENB;
        break;

        case UIBCDISPENB: //display enable
          //Serial.println("UIBCDISPENB");          

            i2cd[0] = 0x01;
            i2cd[1] = 0x02;
            i2cd[2] = 0xFF;
    
            i2c.start();
            i2c.write((addr1 << 1), i2cd, 3, false); 
            i2c.stop();
            wait_ms(100);
    
        STATEMACHINE = UIBCDISPENB2;
        break;
            
        case UIBCDISPENB2:
          //Serial.println("UIBCDISPENB2");
    
            i2cd[0] = 0x01;
            i2cd[1] = 0x05;
            i2cd[2] = 0xFF;

            i2c.start();
            i2c.write((addr1 << 1), i2cd, 3, false); 
            i2c.stop();
          wait_ms(100);
          STATEMACHINE = UIBCAUXTOUCHENABLE;
        break;
    
    
        case UIBCAUXTOUCHENABLE:
          //Serial.println("UIBCAUXTOUCHENABLE");

            i2cd[0] = 0x01;
            i2cd[1] = 0x07;
            i2cd[2] = 0xFF;

            i2c.start();
            i2c.write((addr1 << 1), i2cd, 3, false); 
            i2c.stop();

          wait_ms(100);
          STATEMACHINE = UIBCBACKLIGHTDUTY;
        break;
        
    
        
        case UIBCBACKLIGHTDUTY:
          printf("UIBCBACKLIGHTDUTY\n");    
    
            i2cd[0] = 0x01;
            i2cd[1] = 0x80;
            i2cd[2] = 0xAF;

            i2c.start();
            i2c.write((addr1 << 1), i2cd, 3, false); 
            i2c.stop();
          wait_ms(100);
    
            STATEMACHINE = LCDTESTINIT;
        break;

        case LCDTESTINIT:
          printf("LCDTESTINIT\n");    
            switch(RDDIDVal) {
                case 0x540000:
                    yeebo_st7789v_power_on();
                    printf("Yeebo\r\n");
                break;
    
                case 0x448552:
                    tianma_2p8_st7789vi_power_on();
                    printf("Tianma1\r\n");
                break;
                
                case 0x468552:
                    tianma_2p8_st7789vi_power_on();
                    printf("Tianma2\r\n");                    
                break;

                case 0x560000:
                    yeebo_st7789v_power_on();            
                    printf("Yeebo56\r\n");                    
                break;                
                
                default:
                    yeebo_st7789v_power_on();            
                    printf("YeeboDefault\r\n");                    
                break;
            }
                printf("RDDID : ");
                printf("0x%08x\n", RDDIDVal); 

            STATEMACHINE = LCDTEST1;

        break;

        case LCDTEST1:
        Write_Command(0x38);
        wait_ms(100);
            RefreshScreen();
            printf("Inspect color. Press enter to continue\r\n");
            //while
            
            /*
            while (buttonNext.read()==1) {
                wait_ms(50);
            }
            SendBlack();
            while (buttonNext.read()==1) {
                wait_ms(50);
            }
            SendWhite();
            while (buttonNext.read()==1) {
                wait_ms(50);
            }
            */
            STATEMACHINE = RACASET;
            wait_ms(100);
        break;

        case RACASET:
            //CASET
 /*
            SendData(0x00,0x00);
            SendData(0x00,0xAA);
            //RASET
            SendData(0x00,0x00);
            SendData(0x00,0x78);
*/
            STATEMACHINE = LCDTEST2;
//            wait_ms(100);
        break;

        case LCDTEST2:
/*
            RefreshScreen();
            printf("Inspect color. Press enter to continue\r\n");
            wait_ms(100);
*/            
            STATEMACHINE = WAITCONTINUE;
//            wait_ms(100);
        break;

        case WAITCONTINUE:
            addrsht = (addr2 << 1) | 0x01; //control bit = 1
            i2c.start();
            i2c.write((addr2 << 1)); 
            i2c.write(0x11);
            i2c.stop();
wait_ms(50);
            i2c.start();            
            i2c.write(addrsht); 
            i2cr = i2c.read(addrsht); 
            i2c.stop();
            i2crkey = i2cr; 
//            printf("0x%02x\n", addrsht);  
            if (i2crkey==0x02) {          
                STATEMACHINE = TOUCHTESTINIT;
            }

                printf("KEY : ");
                printf("0x%02x\n", i2crkey); 

            i2cr = 0;
          wait_ms(100);
            i2cr = 0;
            i2crkey = 0;

          wait_ms(100);
        
        break;
        
        case TOUCHTESTINIT:

            wait_ms(2000);
            pc.printf("Initializing touch\r\n");
            
            fp = fopen("/sd/touchtest.bmp", "r");

            if (fp == NULL) {
                fclose(fp);
//                remove("/sd/hello.txt");
                pc.printf("Error: File not found!\r\n");
            }
 
 //https://online-converting.com/image/convert2bmp/
 
            int cnt = 0;
            pc.printf("Printing image to screen\r\n");
//Red   ---   F8 00
//Green ---   07 E0
//Blue  ---   00 1F
            Write_Command(0x2c);

            while (!feof(fp)) {
                if (cnt > 65) {      //skip rgb header
                    datalo = fgetc(fp);
                    datahi = fgetc(fp);        
                    //printf("0x%02x\n", datalo); 
                    //printf("0x%02x\n", datahi); 

                    if ((datalo!=0xffffffff) && (datahi!=0xffffffff)) {
                        SendData(datahi,datalo);
                    }
                } else {
                    int datahead = fgetc(fp);
                    cnt++;                
                }
            //    pc.printf(".");
            } 
            //pc.printf(".\r\n");
            pc.printf("Done printing image to screen\r\n");

        fclose(fp);

          wait_ms(100);
            touch1 = false;
            touch2 = false;
            touch3 = false;
            touch4 = false;
            touch5 = false;
            touchkey1 = false;
            touchkey2 = false;
            touchkey3 = false;
            pc.printf("Touch test running\r\n");
            ControlLED(0x40, 0x00);
            ControlLED(0x42, 0x00);
            
            STATEMACHINE = TOUCHDETECT;            
        break;
/*
        case TOUCHTEST1:
            printf("TOUCHING1\n");
            addrsht = (addr2 << 1) | 0x01; //control bit = 1
            i2c.start();
            i2c.write((addr2 << 1)); 
            i2c.write(0x00);
            i2c.stop();
//wait_ms(50);
            i2c.start();            
            i2c.write(addrsht); 
            i2cr = i2c.read(addrsht); 
            i2c.stop();

            printf("0x%02x\n", addrsht);            
            printf("0x%02x\n", i2cr); 
            i2cr = 0;
          wait_ms(100);
    
            STATEMACHINE = TOUCHTEST2;
        break;

        case TOUCHTEST2:
            printf("TOUCHING2\n");
            addrsht = (addr2 << 1) | 0x01; //control bit = 1
            i2c.start();
            i2c.write((addr2 << 1)); 
            i2c.write(0x01);
            i2c.stop();
//wait_ms(50);
            i2c.start();            
            i2c.write(addrsht); 
            i2cr = i2c.read(addrsht); 
            i2c.stop();

            printf("0x%02x\n", addrsht);            
            printf("0x%02x\n", i2cr); 
            i2cr = 0;
          wait_ms(100);
    
            STATEMACHINE = TOUCHTEST3;
        break;

        case TOUCHTEST3:
            printf("TOUCHING3\n");
            addrsht = (addr2 << 1) | 0x01; //control bit = 1
            i2c.start();
            i2c.write((addr2 << 1)); 
            i2c.write(0x04);
            i2c.stop();
//wait_ms(50);
            i2c.start();            
            i2c.write(addrsht); 
            i2cr = i2c.read(addrsht); 
            i2c.stop();

            printf("0x%02x\n", addrsht);            
            printf("0x%02x\n", i2cr); 
            i2cr = 0;
          wait_ms(100);
    
            STATEMACHINE = TOUCHTEST4;
        break;

        case TOUCHTEST4:
            printf("TOUCHING4\n");
            addrsht = (addr2 << 1) | 0x01; //control bit = 1
            i2c.start();
            i2c.write((addr2 << 1)); 
            i2c.write(0x05);
            i2c.stop();
//wait_ms(50);
            i2c.start();            
            i2c.write(addrsht); 
            i2cr = i2c.read(addrsht); 
            i2c.stop();

            printf("0x%02x\n", addrsht);            
            printf("0x%02x\n", i2cr); 
            i2cr = 0;
          wait_ms(100);
    
            STATEMACHINE = TOUCHTEST5;
        break;
*/
        case TOUCHDETECT:
            addrsht = (addr2 << 1) | 0x01; //control bit = 1
            i2c.start();
            i2c.write((addr2 << 1)); 
            i2c.write(0x01);
            i2c.write(0x1D);
            i2c.stop();
wait_ms(50);
            i2c.start();            
            i2c.write(addrsht); 
            i2cr = i2c.read(addrsht); 
            i2c.stop();
            i2crkey = (i2cr >> 2) & 0x01; 
 //           int i2crkeytemp = i2cr;
//            printf("0x%02x\n", addrsht);            
//            printf("INT : ");
//            printf("0x%02x\n", i2crkey); 

//            printf("INTTEMP : ");
//            printf("0x%02x\n", i2crkeytemp); 
            if (i2crkey == 0x00) {
                STATEMACHINE = TOUCHTEST5;
            }
            i2cr = 0;
            i2crkey = 0;

//          wait_ms(100);

        break;
        
        case TOUCHTEST5:
//            printf("TOUCHING5\n");
            addrsht = (addr2 << 1) | 0x01; //control bit = 1
            i2c.start();
            i2c.write((addr2 << 1)); 
            i2c.write(0x11);
            i2c.stop();
wait_ms(50);
            i2c.start();            
            i2c.write(addrsht); 
            i2cr = i2c.read(addrsht); 
            i2c.stop();
            i2crkey = i2cr; 
//            printf("0x%02x\n", addrsht);            
            printf("KEY : ");
            printf("0x%02x\n", i2crkey); 
            i2cr = 0;
          wait_ms(100);
    
            //STATEMACHINE = SDTEST1;
            STATEMACHINE = TOUCHTEST6;

        break;

        case TOUCHTEST6:
//            printf("TOUCHING6\n");
            addrsht = (addr2 << 1) | 0x01; //control bit = 1
            i2c.start();
            i2c.write((addr2 << 1)); 
            i2c.write(0x12);
            i2c.stop();
wait_ms(50);
            i2c.start();            
            i2c.write(addrsht); 
            i2cr = i2c.read(addrsht); 
            i2c.stop();
//            printf("0x%02x\n", addrsht);            
//            printf("0x%02x\n", i2cr); 
            
            i2crxhi = (i2cr & 0x70) >> 4; // we want to check bits 0, 3 and 8
//            printf("0x%02x\n", i2crxhi); 
            
            i2cryhi = (i2cr & 0x07); // we want to check bits 0, 3 and 8
//            printf("0x%02x\n", i2cryhi); 
            i2cr = 0;
          wait_ms(100);
            
            STATEMACHINE = TOUCHTEST7;
        break;

        case TOUCHTEST7:
//            printf("TOUCHING7\n");
            addrsht = (addr2 << 1) | 0x01; //control bit = 1
            i2c.start();
            i2c.write((addr2 << 1)); 
            i2c.write(0x13);
            i2c.stop();
wait_ms(50);
            i2c.start();            
            i2c.write(addrsht); 
            i2cr = i2c.read(addrsht); 
            i2c.stop();

//            printf("0x%02x\n", addrsht);            
//            printf("0x%02x\n", i2cr); 

            i2crxlo = i2cr;
//            printf("0x%02x\n", i2crxlo); 
            i2cr = 0;            
          wait_ms(100);
    
            STATEMACHINE = TOUCHTEST8;

        break;

        case TOUCHTEST8:
            //printf("TOUCHING8\n");

            addrsht = (addr2 << 1) | 0x01; //control bit = 1
            i2c.start();
            i2c.write((addr2 << 1)); 
            i2c.write(0x14);
            i2c.stop();
wait_ms(50);
            i2c.start();            
            i2c.write(addrsht); 
            i2cr = i2c.read(addrsht); 
            i2c.stop();

//            printf("0x%02x\n", addrsht);            
//            printf("0x%02x\n", i2cr); 

            i2crylo = i2cr;
//            printf("0x%02x\n", i2crylo); 

            printf("Deciphered Values\r\n");
                         
            i2crx = (i2crxhi << 8) | i2crxlo;
            i2cry = (i2cryhi << 8) | i2crylo;
            
            printf("X : ");
            printf("%d\r\n", i2crx); 
            printf("Y : ");
            printf("%d\r\n", i2cry); 

/*
bool touch1 = false;
bool touch2 = false;
bool touch3 = false;
bool touch4 = false;
bool touch5 = false;
bool touchkey1 = false;
bool touchkey2 = false;
bool touchkey3 = false;
*/            

bool feedBack1 = ((i2crx>=0) && (i2crx <= 79) && (i2cry>=0) && (i2cry <= 59));
bool feedBack2 = ((i2crx>=239) && (i2crx <= 319) && (i2cry>=0) && (i2cry <= 59));
bool feedBack3 = ((i2crx>=0) && (i2crx <= 79) && (i2cry>=179) && (i2cry <= 239));
bool feedBack4 = ((i2crx>=239) && (i2crx <= 319) && (i2cry>=179) && (i2cry <= 239));
bool feedBack5 = ((i2crx>=79) && (i2crx <= 159) && (i2cry>=59) && (i2cry <= 119));
bool feedBackkey1 = (i2crkey == 0x02);
bool feedBackkey2 = (i2crkey == 0x04);
bool feedBackkey3 = (i2crkey == 0x08);

            if (feedBack1 || feedBack2 || feedBack3 || feedBack4 || feedBack5 || feedBackkey1 || feedBackkey2 || feedBackkey3) {
                FeedbackTouch(true);
            } else {
                FeedbackTouch(false);
            }
            
            if (feedBack1) {
                touch1 = true;
                printf("X : ");
                printf("%d\r\n", i2crx); 
                printf("Y : ");
                printf("%d\r\n", i2cry); 
                printf("touch1 pressed\r\n");                
            }

            if (feedBack2) {
                touch2 = true;                
                printf("touch2 pressed\r\n");                

            }
            if (feedBack3) {
                touch3 = true;                
                printf("touch3 pressed\r\n");                

            }
            if (feedBack4) {
                touch4 = true;                
                printf("touch4 pressed\r\n");                

            }

            if (feedBack5) {
                touch5 = true;                
                printf("touch5 pressed\r\n");                

            }

            if (feedBackkey1) {
                touchkey1=true;   
                printf("touchkey1 pressed\r\n");                
            }

            if (feedBackkey2) {
                touchkey2=true;   
                printf("touchkey2 pressed\r\n");                

            }

            if (feedBackkey3) {
                touchkey3=true;   
                printf("touchkey3 pressed\r\n");                

            }

//            touchresult = touch1 & touch2 & touch3 & touch4 & touch5 & touchkey1 & touchkey2 & touchkey3;
/*            
            if (touchresult) {
                printf("touchresult : ");
                printf("%s\r\n", touchresult ? "true" : "false");
                STATEMACHINE = GOODDONE;
                printf("Done Test\r\n");
            } else {
                wait_ms(100);
                printf("touchresult : ");
                printf("%s\r\n", touchresult ? "true" : "false");
                printf("touch1 : ");
                printf("%s\r\n", touch1 ? "true" : "false");
                printf("touch2 : ");
                printf("%s\r\n", touch2 ? "true" : "false");
                printf("touch3 : ");
                printf("%s\r\n", touch3 ? "true" : "false");
                printf("touch4 : ");
                printf("%s\r\n", touch4 ? "true" : "false");
                printf("touch5 : ");
                printf("%s\r\n", touch5 ? "true" : "false");
                printf("touchkey1 : ");
                printf("%s\r\n", touchkey1 ? "true" : "false");
                printf("touchkey2 : ");
                printf("%s\r\n", touchkey2 ? "true" : "false");
                printf("touchkey3 : ");
                printf("%s\r\n", touchkey3 ? "true" : "false");
                
                STATEMACHINE = TOUCHDETECT;
            }
  */
            i2cr = 0;
            i2crkey = 0;


        break;
        
        case GOODDONE:
            RefreshScreenGood();        
            STATEMACHINE = DONESTATE;
        break;
        
        case DONESTATE:
        break;
    
    
        default:
        
        break;
      }
    } //end while
}