// Inclusion of necessary libraries
#include "mbed.h"
#include "TSISensor.h"
#include "MMA8451Q.h"
#include "stdio.h"

// Declaration of constants
#define MMA8451_I2C_ADDRESS (0x1d<<1)
#define ACC_THRESH 0.1
#define WAIT_TIME 0.01

int main(void) {
    // Declare accelerometer
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    
    // Declare components of the RGB led
    PwmOut led_blue(LED_BLUE);
    PwmOut led_green(LED_GREEN);
    PwmOut led_red(LED_RED);
    
    // Declare capacitive touch slider
    float tp=0;
    TSISensor tsi;
    
    // Declare USB Serial Port
    Serial pc(USBTX, USBRX);
    
    // Turn off all the components of the RGB led
    led_blue = 1;
    led_green = 1;
    led_red = 1;
    
    while (1) 
    {   
        // Read the slider and assign the readed value to the tp variable. 
        // tp assumes a value between 0 (user is not touching the slider) 
        // and 1 (user is touching the upper part of the slider). 
        tp = tsi.readPercentage();
        
        // If the user is NOT touching the slider, then make RGB led assume
        // a color accourding to the declivity measured by the accelerometer.
        // Green intensity is used to represent the vertical axe (y), 
        // Blue intensity is used to represent the horizontal one (x).
        if (tp == 0){
            led_red = 1;
            if (abs(acc.getAccX()) >= ACC_THRESH)
                led_blue = 1-abs(acc.getAccX());
            else
                led_blue = 1;
            if (abs(acc.getAccY()) >= ACC_THRESH)
                led_green = 1-abs(acc.getAccY());
            else 
                led_green = 1;
        // If the user is touching the upper part of the slider, make the RGB led
        // assume the Red color
        } else if (tp >= 0.5) {
            led_blue = 1;
            led_green = 1;
            led_red = 0;
        // If the user is touching the lower part of the slider, make the RGB led
        // assume the White color
        } else {
            led_blue = 0;
            led_green = 0;
            led_red = 0;
        }
        // Send a JSON-format message of the measurements to the Serial Port
        pc.printf("{ \"slider\" : %f, \"acc_x\" : %f, \"acc_y\" : %f, \"acc_z\" : %f }\n", tp, acc.getAccX(), acc.getAccY(), acc.getAccZ());
        // Wait a fixed amount of time before repeating the whole while-cycle
        wait(WAIT_TIME);
    }
}