#include "mbed.h"
#include "RA8875.h"

Serial Fc(p28, p27);

int fuelcellStatus = -1;
int fuelcellAmbientRawT;
float fuelcellAmbientT;
int fuelcellStackRawV;
int fuelcellStackRawIHighByte;
int fuelcellStackRawILowByte;
int fuelcellStackRawH2Sensor;

int fuelcellStackRawT;
int fuelcellRawOutputCurrent1; //high byte
int fuelcellRawOutputCurrent2; //low byte
int fuelcellBatteryRawV;
float fuelcellStackV;
float fuelcellStackI;
float h2SensorVoltage;
float fuelcellStackPower;
float fuelcellStackT;
float fuelcellOutputCurrent;// 
float fuelcellBatteryV;
float PWRused = 0.0;

InterruptIn S(p15);
float speed = 0.0;
float avgspeed = 0.0;
float necspeed = 0.0;
float wielomtrek = 1.75;
bool rond = 0;
Timer t;
Timer teller;
Ticker tick;

int seconde = 0;
int sec = 0;
int min = 0;
int lmin = 39;
int lsec = 0;

float afstandtogo = 17000.0;
float afstand = 0.0;
float tijd = 39.0*60.0;
color_t Kleur1;
color_t Kleur6;



void tel(){
            rond=1;
        } 
    
    
void counters(){
    seconde++;
    PWRused += (fuelcellStackPower * (1.0/3600.0));
    if(seconde >= 39*60)
    {

    min = 39;
    sec = 00;
  lmin = 00;
 lsec = 00;
    Kleur1 = BrightRed;
    Kleur6 = BrightRed;
    }
    else if(seconde >= 34*60)
    {
       
        min = seconde/60;
        sec = seconde - (min*60);
        lsec--;
        if(lsec < 0){
        lsec = 59;
        lmin--;
        }
        
        Kleur1 = Yellow;
        Kleur6 = Yellow;
    }
    else
    {
        
        min = seconde/60;
        sec = seconde - (min*60);
        lsec--;
        if(lsec < 0){
        lsec = 59;
        lmin--;
        }
              
        Kleur1 = BrightGreen;
        Kleur6 = BrightGreen;
    }
    
    }
    
    void snelheidmeten(){
        if (rond){
        speed = (wielomtrek/t.read())*3,6;
        afstand += wielomtrek;
        t.reset();
        }
        tijd -= teller.read();
        necspeed = ((afstandtogo-afstand)/tijd)*3.6;
        avgspeed = (afstand/teller.read())*3.6;
        
        if(t.read() > 2.5)
        speed = 0.0;
        
        rond = 0;

        }
    
    void checkIncomingFcData() {

    // anything in the buffer? yes check if its a valid packet. no, return
    if (Fc.readable()) {



                        fuelcellStatus = Fc.getc();
                        fuelcellAmbientRawT = Fc.getc();
                        fuelcellStackRawV = Fc.getc();
                        fuelcellStackRawH2Sensor = Fc.getc();
                        fuelcellStackRawT= Fc.getc();
                        fuelcellStackRawIHighByte = Fc.getc();
                        fuelcellStackRawILowByte = Fc.getc();
                        fuelcellBatteryRawV = Fc.getc();

                        //calculate actual values
                        fuelcellAmbientT = fuelcellAmbientRawT * .5;
                        fuelcellStackV = fuelcellStackRawV * .33333;
                        fuelcellStackT = fuelcellStackRawT * .5;
                        fuelcellStackI = ((fuelcellStackRawIHighByte<<8) + fuelcellStackRawILowByte) * .2;// 
                        fuelcellBatteryV = fuelcellBatteryRawV * .10;
                        fuelcellStackPower = fuelcellStackI * fuelcellStackV;
                        h2SensorVoltage = fuelcellStackRawH2Sensor *.10;

                    }
                }

    
    
    
    
int main()
{
    teller.start();
    t.start();
    S.rise(&tel);
    float f = 10000000;
    
    
    RA8875 lcd(p5, p6, p7, p12, NC, "tft");    // MOSI, MISO, SCK, /ChipSelect, /reset, name
    lcd.init(800, 480, 24, true, false, false); 

    lcd.frequency(f);
    AnalogIn ain(A5);
    tick.attach(&counters, 1.0);
    lcd.cls();
    wait_ms(250);
    



    lcd.background(White);
    lcd.fillrect(     0,0, 800,480,              White);
    lcd.fillrect(     0,79,  800,81 ,            Black);   // hor strepen over het hele beeld
    lcd.fillrect(     0,159, 800,161,            Black);
    lcd.fillrect(     0,239, 800,241,            Black);
    lcd.fillrect(     0,319, 800,321,            Black);
    lcd.fillrect(     0,399, 800,401,            Black);
    
    lcd.fillrect(     759,80 , 761,240,          Black);   //verticale streep boven
    lcd.fillrect(     759,320, 761,480,          Black);   //verticale streep onder
    
    lcd.fillrect(     371,119, 800,121,          Black);   //hor strepen vanaf halve cirkel
    lcd.fillrect(     396,199, 800,201,          Black);
    lcd.fillrect(     371,359, 800,361,          Black);
    lcd.fillrect(     315,439, 800,441,          Black);

    lcd.line(         209,0  , 280,80 ,          Black);   //binnenste halve cirkel
    lcd.line(         280,80 , 321,160,          Black);
    lcd.line(         321,160, 331,240,          Black);
    lcd.line(         331,240, 321,320,          Black);
    lcd.line(         321,320, 280,400,          Black);
    lcd.line(         280,400, 209,480,          Black);
    
    lcd.line(         209+70,0  , 280+70,80 ,    Black);   //buitenste halve cirkel (+70)
    lcd.line(         280+70,80 , 321+70,160,    Black);
    lcd.line(         321+70,160, 331+70,240,    Black);    
    lcd.line(         331+70,240, 321+70,320,    Black);
    lcd.line(         321+70,320, 280+70,400,    Black);
    lcd.line(         280+70,400, 209+70,480,    Black);
    
    Kleur1 = BrightGreen;
    Kleur6 = BrightGreen;

    lcd.SetTextFontSize(2,2);
    int H = lcd.fontheight()/2;
    lcd.puts(411,40-H, "STATUS FUEL CELL");
    lcd.puts(411,280-H, "GENERAL STATUS");
    
    lcd.SetTextFontSize(1,1);
    H = lcd.fontheight()/2;
    
    
    color_t Kleur2;
    color_t Kleur3;
    color_t Kleur4;
    color_t Kleur5;
    
    color_t KleurA;
    color_t KleurB;
    color_t KleurC;
    color_t KleurD;
    color_t KleurE;
    color_t KleurF;
    color_t KleurG;
    color_t KleurH;
    
    
while(1){
    checkIncomingFcData();
    snelheidmeten();
        
if (avgspeed >= 26.0 && avgspeed <= 27.3)
{
     
     Kleur2 = BrightGreen;
     }
     else if(avgspeed <= 25.0 || avgspeed >= 28.5)
     Kleur2 = BrightRed;
     else{
         Kleur2 = Yellow;
         }
     Kleur3 = BrightBlue;
     
     
     Kleur4 = BrightBlue;
     
     
     Kleur5 = BrightBlue;
     
     if(fuelcellStackV >= 22 && fuelcellStackV <= 45)
     {
     KleurA = BrightGreen;
     }
     else if(fuelcellStackV <= 20 || fuelcellStackV >= 48){
         KleurA = BrightRed;
         }
         else{
             KleurA = Yellow;
             } 
         
     
if(fuelcellStackI <= 25)
     {
     KleurB = BrightGreen;
     }
     else if(fuelcellStackI >= 27){
         KleurB = BrightRed;
         }
         else{
             KleurB = Yellow;
             } 
     
     

     if(fuelcellStackPower <=1000){
         KleurC = BrightGreen;
         }
         else if(fuelcellStackPower >= 1200){
             KleurC = BrightRed;
             }
             else{
                 KleurC = Yellow;
                 }
                 
     
     if(fuelcellStackT <=38){
         KleurD = BrightGreen;
         }
         else if(fuelcellStackT >= 40){
             KleurD = BrightRed;
             }
             else{
                 KleurD = Yellow;
                 }
     
     
     if((ain*20*3.3) <=45){
         KleurE = BrightGreen;
         }
         else if((ain*20*3.3) >= 48){
             KleurE = BrightRed;
             }
             else{
                 KleurE = Yellow;
                 }
     
     
     if(fuelcellAmbientT <=28){
         KleurF = BrightGreen;
         }
         else if(fuelcellAmbientT >= 30){
             KleurF = BrightRed;
             }
             else{
                 KleurF = Yellow;
                 }
     
    

     



    lcd.foreground(Black);

    lcd.SetTextCursor(10,40-H);                     //16
    lcd.printf("Total time       %02d:%02d",min,sec );
    lcd.SetTextCursor(10,120-H);
    lcd.printf("Average speed    %.1f km/h   ",avgspeed);
    lcd.SetTextCursor(10,200-H);
    lcd.printf("Necessary speed  %.1f km/h   ",necspeed);
    lcd.SetTextCursor(10,280-H);
    lcd.printf("Actual speed     %.1f km/h   ",speed);
    lcd.SetTextCursor(10,360-H);
    lcd.printf("Power used       %.1f Wh   ",PWRused);
    lcd.SetTextCursor(10,440-H);
    lcd.printf("Time left        %02d:%02d",lmin,lsec);
    
    lcd.SetTextCursor(411,100-H);
    lcd.printf("Voltage fuel cell        %.2f V   ",fuelcellStackV);
    lcd.SetTextCursor(411,140-H);
    lcd.printf("Current fuel cell        %.2f A   ",fuelcellStackI);
    lcd.SetTextCursor(411,180-H);
    lcd.printf("Power fuel cell          %.2f W   ",fuelcellStackPower);
    lcd.SetTextCursor(411,220-H);
    lcd.printf("Temperature fuel cell    %.2f %cC   ",fuelcellStackT,176);
    lcd.SetTextCursor(411,340-H);
    lcd.printf("Voltage supercapacitors  %.2f V    ",ain*20*3.3);
    lcd.SetTextCursor(411,380-H);
    lcd.printf("Ambient temperature      %.2f %cC   ",fuelcellAmbientT,176);
    lcd.SetTextCursor(411,420-H);
    
    switch(fuelcellStatus)
{
  case 0:
lcd.printf("Status fuelcell:         NORMAL          ");
     KleurG = BrightGreen;     
     KleurH = BrightGreen;
  break;
 
  case 1:
lcd.printf("Status fuelcell:         BATTERY LOW     ");
     KleurG = BrightRed;     
     KleurH = BrightRed;
  break;
  
  case 2:
lcd.printf("Status fuelcell:         FC VOLTAGE LOW  ");
     KleurG = BrightRed;     
     KleurH = BrightRed;
  break;
  
  case 3:
lcd.printf("Status fuelcell:         H2% HIGH        ");
     KleurG = BrightRed;     
     KleurH = BrightRed;
  break;
  
    case 4:
lcd.printf("Status fuelcell:         CURRENT HIGH    ");
     KleurG = BrightRed;     
     KleurH = BrightRed;
  break;
  
    case 5:
lcd.printf("Status fuelcell:         TEMPERATURE HIGH");
     KleurG = BrightRed;     
     KleurH = BrightRed;
  break;
  
    case 20:
lcd.printf("Status fuelcell:         MANUAL TURN OFF ");
     KleurG = BrightRed;     
     KleurH = BrightRed;
  break;
 
  default:
lcd.printf("Status fuelcell:         NO STATUS       ");
     KleurG = Yellow;     
     KleurH = Yellow;
}
    
    
    
    

    
    // vakjes in de halve cirkel
    lcd.filltriangle( 210,0, 281,78, 278,0,      Kleur1);  //vakje 1
    lcd.filltriangle( 349,78, 281,78, 278,0,     Kleur1);
    
    lcd.filltriangle( 281,82, 322,158, 349,82,   Kleur2);  //vakje 2
    lcd.filltriangle( 390,158, 322,158, 349,82,  Kleur2);
    
    lcd.filltriangle( 322,162, 332,238, 390,162, Kleur3);  //vakje 3
    lcd.filltriangle( 400,238, 332,238, 390,162, Kleur3);
    
    lcd.filltriangle( 332,242, 322,318, 400,242, Kleur4);  //vakje 4
    lcd.filltriangle( 390,318, 322,318, 400,242, Kleur4);
    
    lcd.filltriangle( 322,322, 281,398, 390,322, Kleur5);  //vakje 5
    lcd.filltriangle( 349,398, 281,398, 390,322, Kleur5);
    
    lcd.filltriangle( 281,402, 210,480, 349,402, Kleur6);  //vakje 6
    lcd.filltriangle( 278,480, 210,480, 349,402, Kleur6);
    
  //vierkantjes aan de rechterkant
    
    lcd.fillrect(     762,82,  800,118,          KleurA); // Vierkant A
    lcd.fillrect(     762,122, 800,158,          KleurB); // Vierkant B
    lcd.fillrect(     762,162, 800,198,          KleurC); // Vierkant C
    lcd.fillrect(     762,202, 800,238,          KleurD); // Vierkant D
    lcd.fillrect(     762,322, 800,358,          KleurE); // Vierkant E
    lcd.fillrect(     762,362, 800,398,          KleurF); // Vierkant F
    lcd.fillrect(     762,402, 800,438,          KleurG); // Vierkant G
    lcd.fillrect(     762,442, 800,480,          KleurH); // Vierkant H
    
    wait(0.2);
    }    
}
