/*

                                   mbed LPC1768
                               ___________________
                            1 |GND    |    |  VOUT|40
                            2 |VIN    |    |    VU|39
                            3 |VB     |____|   IF-|38
                            4 |nR              IF+|37
            SPI NRF24L01+   5 |MOSI        ETH RD-|36
            SPI NRF24L01+   6 |MISO        ETH RD+|35
            SPI NRF24L01+   7 |SCK         ETH TD-|34
      SPI (CSN) NRF24L01+   8 |            ETH TD+|33
      SPI (CE)  NRF24L01+   9 |TX/SDA       USB D-|32
      SPI (IRQ) NRF24L01+   10|RX/SCL       USB D+|31
                            11|MOSI        (CAN)RD|30   CAN bus
                            12|MISO        (CAN)TD|29   CAN bus
                            13|TX/SCK       SDA/TX|28   I2C 16x2 Display
                            14|RX           SCL/RX|27   I2C 16x2 Display
     Left indicator input   15|AI           PWMOUT|26
    Right indicator input   16|AI           PWMOUT|25
         Headlights input   17|AI           PWMOUT|24   Dashboard left indicator output
              Brake input   18|AI/AOUT      PWMOUT|23   Dashboard right indicator output
                            19|AI           PWMOUT|22   Dashboard headlights output
                            20|AI           PWMOUT|21   Dashboard warning output
                               -------------------
                           
*/

#define DEBUG       1           //1 = debugging via USB serial port, 0 = debugging off

#include "mbed.h"
#include "PinDetect.h"
#include "TextLCD.h"

//pinouts
PinDetect  PIN_LEFT_IN          (p15);
PinDetect  PIN_RIGHT_IN         (p16);
PinDetect  PIN_HEADLIGHTS_IN    (p17);
PinDetect  PIN_BRAKE_IN         (p18);
DigitalOut PIN_WARNING_OUT      (p21);
DigitalOut PIN_HEADLIGHTS_OUT   (p22);
DigitalOut PIN_RIGHT_OUT        (p23);
DigitalOut PIN_LEFT_OUT         (p24);
DigitalOut LED_1                (LED1);     //onboard
DigitalOut LED_2                (LED2);     //onboard
DigitalOut LED_3                (LED3);     //onboard
DigitalOut LED_4                (LED4);     //onboard

//Setup serial pins for debugging
Serial pc(USBTX, USBRX);

//Setup I2C pins for 16x2 display
I2C i2c_lcd(p28,p27);            //SDA, SCL
TextLCD_I2C lcd(&i2c_lcd, 0x4E, TextLCD::LCD16x2);                  // I2C exp: I2C bus, PCF8574 Slaveaddress, LCD Type

//Setup CAN busses 1 en 2
CAN CAN1(p9, p10);
CAN CAN2(p30, p29);
char CANcounter = 'a';
Ticker CANticker;

//Setup tickers for blinking the indicator and warning lights on the dashboard
Ticker ticker_left;
Ticker ticker_right;
Ticker ticker_warning;

void CANsend()           //Sends a message from CAN1
{
    pc.printf("send()\n");
    CANMessage CANmsgTX(CANMessage(887, &CANcounter, 1));
    if(CAN1.write(CANmsgTX))
    {
        CANcounter++;
        pc.printf("MESSAGE SENT: %d, %d\n", CANcounter, CANmsgTX.data[0]);
        LED_1 = !LED_1;
    } 
    else
    {
        pc.printf("Failed to send the message\n");
    }
}

void toggle_left() { PIN_LEFT_OUT = !PIN_LEFT_OUT; }
void toggle_right() { PIN_RIGHT_OUT = !PIN_RIGHT_OUT; }
void toggle_warning() { PIN_WARNING_OUT = !PIN_WARNING_OUT; }

void start_left()

{
    PIN_LEFT_OUT = 1;
    ticker_left.attach(&toggle_left, 0.5);
    //SEND CAN TO LEFT_FRONT_MODULE AND BACK_MODULE
    if(DEBUG) pc.printf("Left on\n");
}

void stop_left()
{
    ticker_left.detach();
    PIN_LEFT_OUT = 0;
    //SEND CAN TO LEFT_FRONT_MODULE AND BACK_MODULE
    if(DEBUG) pc.printf("Left off\n");
}

void start_right()
{
    PIN_RIGHT_OUT = 1;
    ticker_right.attach(&toggle_right, 0.5);
    //SEND CAN TO RIGHT_FRONT_MODULE AND BACK_MODULE
    if(DEBUG) pc.printf("Right on\n");
}

void stop_right()
{
    ticker_right.detach();
    PIN_RIGHT_OUT = 0;
    //SEND CAN TO RIGHT_FRONT_MODULE AND BACK_MODULE
    if(DEBUG) pc.printf("Right off\n");
}

void start_headlights()
{
    PIN_HEADLIGHTS_OUT = 1;
    //SEND CAN TO LEFT_FRONT_MODULE AND RIGHT_FRONT_MODULE
    if(DEBUG) pc.printf("Headlights on\n");
}

void stop_headlights()
{
    PIN_HEADLIGHTS_OUT = 0;
    //SEND CAN TO LEFT_FRONT_MODULE AND RIGHT_FRONT_MODULE
    if(DEBUG) pc.printf("Headlights off\n");
}

void start_brake()
{
    PIN_WARNING_OUT = 1;
    ticker_warning.attach(&toggle_warning, 0.2);
    //SEND CAN TO BACK_MODULE
    if(DEBUG) pc.printf("Brake start\n");
}

void stop_brake()
{
    ticker_warning.detach();
    PIN_WARNING_OUT = 0;
    //SEND CAN TO BACK_MODULE
    if(DEBUG) pc.printf("Brake stop\n");
}

int main()
{
        if(DEBUG) pc.baud(230400);      //default 9600, but we want it to be as fast as possible
        if(DEBUG) pc.printf("BRW Urban Features Controller\n\n");
        if(DEBUG) pc.printf("Setting up...\n");

    //setup PinDetect; input interrupts with built-in debounce (important!)
    PIN_LEFT_IN.attach_asserted             (&start_left);              //press
    PIN_LEFT_IN.attach_deasserted           (&stop_left);               //release
    PIN_LEFT_IN.setSampleFrequency          ();                         //defaults to 20ms.
    PIN_RIGHT_IN.attach_asserted            (&start_right);
    PIN_RIGHT_IN.attach_deasserted          (&stop_right);
    PIN_RIGHT_IN.setSampleFrequency         ();
    PIN_HEADLIGHTS_IN.attach_asserted       (&start_headlights);
    PIN_HEADLIGHTS_IN.attach_deasserted     (&stop_headlights);
    PIN_HEADLIGHTS_IN.setSampleFrequency    ();
    PIN_BRAKE_IN.attach_asserted            (&start_brake);
    PIN_BRAKE_IN.attach_deasserted          (&stop_brake);
    PIN_BRAKE_IN.setSampleFrequency         ();
        if(DEBUG) pc.printf("Pin interrupts set\n");
    
    //setup 16x2 display
    lcd.setCursor(TextLCD::CurOff_BlkOff);      //cursor off, blinking off
    lcd.cls();                                  //clear screen
        if(DEBUG) pc.printf("Display initialized\n");
    
    //setup CAN bus
    CAN1.frequency(615000);
    CAN2.frequency(615000);
    CANticker.attach(&CANsend, 1);        //Calls the function CANsend() every second
    CANMessage CANmsgRX;
    
        if(DEBUG) pc.printf("Setup complete.\n\n");
    
    pc.printf("main()\n");
    
    while(1) {                     //Constantly check for a Rx'ed message on CAN2, and notify if there is one
        //pc.printf("loop()\n");
        //pc.printf("RXed MSG:%d\n", can2.read(msg1));
        if(CAN2.read(CANmsgRX)) {
            char ch = CANmsgRX.data[0];
            lcd.locate(0,0);
            lcd.printf("Message received: ");
            lcd.putc(ch);
            LED_2 = !LED_2;
            wait(0.5);
            lcd.cls();
        } 
    }
}