/*******************************************************************************
* File Name: cycfg_capsense.h
* Version: 2.0
*
* Description:
* CapSense middleware configuration
* This file should not be modified. It was automatically generated by
* CapSense Configurator 2.0.0 build 566
*
********************************************************************************
* Copyright 2019 Cypress Semiconductor Corporation
* SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#if !defined(CYCFG_CAPSENSE_H)
#define CYCFG_CAPSENSE_H

#include <stddef.h>
#include "cy_device_headers.h"
#include "cycfg_peripherals.h"

#if (CY_CAPSENSE_CORE == __CORTEX_M)


#if !defined(Cmod_PORT) || !defined(Cmod_PIN) || !defined(Cmod_PORT_NUM)
#error Cmod Capacitor is not assigned: missing #define Cmod_PORT, #define Cmod_PIN, #define Cmod_PORT_NUM
#endif

#if !defined(CintA_PORT) || !defined(CintA_PIN) || !defined(CintA_PORT_NUM)
#error CintA Capacitor is not assigned: missing #define CintA_PORT, #define CintA_PIN, #define CintA_PORT_NUM
#endif

#if !defined(CintB_PORT) || !defined(CintB_PIN) || !defined(CintB_PORT_NUM)
#error CintB Capacitor is not assigned: missing #define CintB_PORT, #define CintB_PIN, #define CintB_PORT_NUM
#endif

#if !defined(Button0_Rx0_PORT) || !defined(Button0_Rx0_PIN)
#error Button0_Rx0 Sensor is not assigned: missing #define Button0_Rx0_PORT, #define Button0_Rx0_PIN
#endif

#if !defined(Button0_Tx_PORT) || !defined(Button0_Tx_PIN)
#error Button0_Tx Sensor is not assigned: missing #define Button0_Tx_PORT, #define Button0_Tx_PIN
#endif

#if !defined(Button1_Rx0_PORT) || !defined(Button1_Rx0_PIN)
#error Button1_Rx0 Sensor is not assigned: missing #define Button1_Rx0_PORT, #define Button1_Rx0_PIN
#endif

#if !defined(Button1_Tx_PORT) || !defined(Button1_Tx_PIN)
#error Button1_Tx Sensor is not assigned: missing #define Button1_Tx_PORT, #define Button1_Tx_PIN
#endif

#if !defined(LinearSlider0_Sns0_PORT) || !defined(LinearSlider0_Sns0_PIN)
#error LinearSlider0_Sns0 Sensor is not assigned: missing #define LinearSlider0_Sns0_PORT, #define LinearSlider0_Sns0_PIN
#endif

#if !defined(LinearSlider0_Sns1_PORT) || !defined(LinearSlider0_Sns1_PIN)
#error LinearSlider0_Sns1 Sensor is not assigned: missing #define LinearSlider0_Sns1_PORT, #define LinearSlider0_Sns1_PIN
#endif

#if !defined(LinearSlider0_Sns2_PORT) || !defined(LinearSlider0_Sns2_PIN)
#error LinearSlider0_Sns2 Sensor is not assigned: missing #define LinearSlider0_Sns2_PORT, #define LinearSlider0_Sns2_PIN
#endif

#if !defined(LinearSlider0_Sns3_PORT) || !defined(LinearSlider0_Sns3_PIN)
#error LinearSlider0_Sns3 Sensor is not assigned: missing #define LinearSlider0_Sns3_PORT, #define LinearSlider0_Sns3_PIN
#endif

#if !defined(LinearSlider0_Sns4_PORT) || !defined(LinearSlider0_Sns4_PIN)
#error LinearSlider0_Sns4 Sensor is not assigned: missing #define LinearSlider0_Sns4_PORT, #define LinearSlider0_Sns4_PIN
#endif

#if !defined(CY_CAPSENSE_CPU_CLK)
#error CPU clock frequency is not set: missing #define CY_CAPSENSE_CPU_CLK
#endif

#if !defined(CY_CAPSENSE_PERI_CLK)
#error Peripheral clock core is not set: missing #define CY_CAPSENSE_PERI_CLK
#endif

#if !defined(CY_CAPSENSE_VDDA_MV)
#error VDDA voltage is not set: missing #define CY_CAPSENSE_VDDA_MV
#endif

#if !defined(CY_CAPSENSE_PERI_DIV_TYPE)
#error Peripheral clock divider type is not set: missing #define CY_CAPSENSE_PERI_DIV_TYPE
#endif

#if !defined(CY_CAPSENSE_PERI_DIV_INDEX)
#error Peripheral clock divider index is not set: missing #define CY_CAPSENSE_PERI_DIV_INDEX
#endif



#include "cy_capsense.h"

#if defined(__cplusplus)
extern "C" {
#endif

/*Widget names */
#define CY_CAPSENSE_BUTTON0_WDGT_ID                            (0u)
#define CY_CAPSENSE_BUTTON1_WDGT_ID                            (1u)
#define CY_CAPSENSE_LINEARSLIDER0_WDGT_ID                      (2u)

/* Button0 sensor names */
#define CY_CAPSENSE_BUTTON0_SNS0_ID                            (0u)

/* Button0 node names */
#define CY_CAPSENSE_BUTTON0_RX0_TX0_ID                         (0u)

/* Button0 sensor element IDs */
#define CY_CAPSENSE_BUTTON0_RX0_ID                             (0u)
#define CY_CAPSENSE_BUTTON0_TX0_ID                             (1u)

/* Button1 sensor names */
#define CY_CAPSENSE_BUTTON1_SNS0_ID                            (0u)

/* Button1 node names */
#define CY_CAPSENSE_BUTTON1_RX0_TX0_ID                         (0u)

/* Button1 sensor element IDs */
#define CY_CAPSENSE_BUTTON1_RX0_ID                             (0u)
#define CY_CAPSENSE_BUTTON1_TX0_ID                             (1u)

/* LinearSlider0 sensor names */
#define CY_CAPSENSE_LINEARSLIDER0_SNS0_ID                      (0u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS1_ID                      (1u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS2_ID                      (2u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS3_ID                      (3u)
#define CY_CAPSENSE_LINEARSLIDER0_SNS4_ID                      (4u)

/* Sensing Methods */
#define CY_CAPSENSE_CSD_EN                                     (1u)
#define CY_CAPSENSE_CSX_EN                                     (1u)
#define CY_CAPSENSE_CSD_CALIBRATION_EN                         (1u)
#define CY_CAPSENSE_CSX_CALIBRATION_EN                         (1u)
#define CY_CAPSENSE_SMARTSENSE_FULL_EN                         (0u)
#define CY_CAPSENSE_SMARTSENSE_HW_EN                           (0u)
#define CY_CAPSENSE_SMARTSENSE_DISABLED                        (1u)
#define CY_CAPSENSE_CSD_SHIELD_EN                              (0u)
#define CY_CAPSENSE_CSD_SHIELD_CAP_EN                          (0u)

/* Filtering */
#define CY_CAPSENSE_ADAPTIVE_FILTER_EN                         (0u)
#define CY_CAPSENSE_BALLISTIC_MULTIPLIER_EN                    (0u)
#define CY_CAPSENSE_RAWCOUNT_FILTER_EN                         (0u)
#define CY_CAPSENSE_POSITION_FILTER_EN                         (1u)
#define CY_CAPSENSE_CSD_POSITION_FILTER_EN                     (1u)
#define CY_CAPSENSE_CSX_POSITION_FILTER_EN                     (0u)

/* Widgets */
#define CY_CAPSENSE_CSD_BUTTON_EN                              (0u)
#define CY_CAPSENSE_CSD_MATRIX_EN                              (0u)
#define CY_CAPSENSE_CSD_SLIDER_EN                              (1u)
#define CY_CAPSENSE_CSD_TOUCHPAD_EN                            (0u)
#define CY_CAPSENSE_CSD_PROXIMITY_EN                           (0u)
#define CY_CAPSENSE_CSX_BUTTON_EN                              (1u)
#define CY_CAPSENSE_CSX_MATRIX_EN                              (0u)
#define CY_CAPSENSE_CSX_TOUCHPAD_EN                            (0u)
#define CY_CAPSENSE_ADVANCED_CENTROID_5X5_EN                   (0u)
#define CY_CAPSENSE_CSD_LINEAR_SLIDER_EN                       (1u)
#define CY_CAPSENSE_CSD_RADIAL_SLIDER_EN                       (0u)
#define CY_CAPSENSE_CSD_DIPLEX_SLIDER_EN                       (0u)

/* Features */
#define CY_CAPSENSE_GESTURE_EN                                 (0u)
#define CY_CAPSENSE_MULTI_FREQUENCY_SCAN_EN                    (0u)
#define CY_CAPSENSE_SNS_AUTO_RESET_EN                          (0u)

typedef struct {
    cy_stc_capsense_common_context_t commonContext;
    cy_stc_capsense_widget_context_t widgetContext[3];
    cy_stc_capsense_sensor_context_t sensorContext[7];
    cy_stc_capsense_position_t position[1];
} cy_stc_capsense_tuner_t;

extern cy_stc_capsense_tuner_t cy_capsense_tuner;

extern cy_stc_capsense_context_t cy_capsense_context;

/*
CAPSENSE_CONFIG_START
<?xml version="1.0"?>
<Configuration major="1" minor="1">
    <GeneralProperties>
        <Property id="REGULAR_RC_IIR_FILTER_EN" value="false"/>
        <Property id="REGULAR_IIR_RC_N" value="128"/>
        <Property id="REGULAR_RC_MEDIAN_FILTER_EN" value="false"/>
        <Property id="REGULAR_RC_AVERAGE_FILTER_EN" value="false"/>
        <Property id="REGULAR_RC_AVERAGE_SAMPLE_SIZE" value="SAMPLE_4"/>
        <Property id="PROX_RC_IIR_FILTER_EN" value="false"/>
        <Property id="PROX_IIR_RC_N" value="128"/>
        <Property id="PROX_RC_MEDIAN_FILTER_EN" value="false"/>
        <Property id="PROX_RC_AVERAGE_FILTER_EN" value="false"/>
        <Property id="PROX_RC_AVERAGE_SAMPLE_SIZE" value="SAMPLE_4"/>
        <Property id="REGULAR_IIR_BL_N" value="1"/>
        <Property id="REGULAR_IIR_BL_TYPE" value="PERFORMANCE"/>
        <Property id="PROX_IIR_BL_N" value="1"/>
        <Property id="PROX_IIR_BL_TYPE" value="PERFORMANCE"/>
        <Property id="MULTI_FREQ_SCAN_EN" value="false"/>
        <Property id="SENSOR_AUTO_RESET_EN" value="false"/>
        <Property id="SLIDER_MULTIPLIER" value="SNS_NUM_MINUS_1"/>
        <Property id="TOUCHPAD_MULTIPLIER" value="SNS_NUM_MINUS_1"/>
        <Property id="BLOCK_ANALOG_WAKEUP_DELAY_US" value="25"/>
        <Property id="VREF_SOURCE" value="SRSS"/>
        <Property id="IREF_SOURCE" value="SRSS"/>
        <Property id="PROX_TOUCH_COEFF" value="300"/>
        <Property id="NUM_CENTROIDS" value="1"/>
    </GeneralProperties>
    <CsdProperties>
        <Property id="CSD_AUTOTUNE" value="DISABLE"/>
        <Property id="CSD_MOD_CLK_DIVIDER" value="1"/>
        <Property id="CSD_INACTIVE_SNS_CONNECTION" value="GROUND"/>
        <Property id="CSD_CHARGE_TRANSFER" value="SOURCING"/>
        <Property id="CSD_IDAC_GAIN_INIT" value="4"/>
        <Property id="CSD_IDAC_ROW_COL_ALIGN_EN" value="true"/>
        <Property id="CSD_IDAC_AUTOCAL_EN" value="true"/>
        <Property id="CSD_IDAC_AUTOGAIN_EN" value="true"/>
        <Property id="CSD_IDAC_GAIN_INDEX" value="4"/>
        <Property id="CSD_IDAC_MIN" value="20"/>
        <Property id="CSD_IDAC_COMP_EN" value="true"/>
        <Property id="CSD_RAWCOUNT_CAL_LEVEL" value="85"/>
        <Property id="CSD_VREF_CUSTOM" value="false"/>
        <Property id="CSD_VREF" value="1219"/>
        <Property id="CSD_SHIELD_EN" value="false"/>
        <Property id="CSD_SHIELD_TANK_EN" value="false"/>
        <Property id="CSD_SHIELD_DELAY" value="DELAY_0NS"/>
        <Property id="CSD_TOTAL_SHIELD_COUNT" value="1"/>
        <Property id="CSD_INIT_SWITCH_RES" value="MEDIUM"/>
        <Property id="CSD_SHIELD_SWITCH_RES" value="MEDIUM"/>
        <Property id="CSD_FINE_INIT_TIME" value="10"/>
        <Property id="CSD_CALIBRATION_ERROR" value="10"/>
        <Property id="CSD_R_CONST" value="1000"/>
        <Property id="CSD_MFS_DIVIDER_OFFSET_F1" value="1"/>
        <Property id="CSD_MFS_DIVIDER_OFFSET_F2" value="2"/>
    </CsdProperties>
    <CsxProperties>
        <Property id="CSX_MOD_CLK_DIVIDER" value="1"/>
        <Property id="CSX_MAX_FINGERS" value="1"/>
        <Property id="CSX_IDAC_GAIN" value="MEDIUM"/>
        <Property id="CSX_IDAC_AUTOCAL_EN" value="true"/>
        <Property id="CSX_RAWCOUNT_CAL_LEVEL" value="85"/>
        <Property id="CSX_INIT_SWITCH_RES" value="MEDIUM"/>
        <Property id="CSX_SCAN_SWITCH_RES" value="MEDIUM"/>
        <Property id="CSX_INIT_SHIELD_SWITCH_RES" value="MEDIUM"/>
        <Property id="CSX_SCAN_SHIELD_SWITCH_RES" value="MEDIUM"/>
        <Property id="CSX_FINE_INIT_TIME" value="10"/>
        <Property id="CSX_CALIBRATION_ERROR" value="20"/>
        <Property id="CSX_MFS_DIVIDER_OFFSET_F1" value="1"/>
        <Property id="CSX_MFS_DIVIDER_OFFSET_F2" value="2"/>
    </CsxProperties>
    <Widgets>
        <Widget id="Button0" type="CSX_BUTTON">
            <WidgetProperties>
                <Property id="DIPLEXING" value="false"/>
                <Property id="MAX_POS_X" value="100"/>
                <Property id="MAX_POS_Y" value="100"/>
                <Property id="FINGER_CP" value="0.3"/>
                <Property id="SNS_CLK" value="2"/>
                <Property id="SNS_CLK_FREQ" value=""/>
                <Property id="ROW_SNS_CLK" value="2"/>
                <Property id="ROW_SNS_CLK_FREQ" value=""/>
                <Property id="SNS_CLK_SOURCE" value="DIRECT"/>
                <Property id="TX_CLK" value="80"/>
                <Property id="TX_CLK_FREQ" value=""/>
                <Property id="TX_CLK_SOURCE" value="AUTO"/>
                <Property id="RESOLUTION" value="RES12BIT"/>
                <Property id="NUM_CONV" value="100"/>
                <Property id="IDAC_MOD0" value="32"/>
                <Property id="IDAC_MOD1" value="32"/>
                <Property id="IDAC_MOD2" value="32"/>
                <Property id="ROW_IDAC_MOD0" value="32"/>
                <Property id="ROW_IDAC_MOD1" value="32"/>
                <Property id="ROW_IDAC_MOD2" value="32"/>
                <Property id="FINGER_TH" value="90"/>
                <Property id="PROX_TOUCH_TH" value="200"/>
                <Property id="NOISE_TH" value="40"/>
                <Property id="NNOISE_TH" value="40"/>
                <Property id="LOW_BSLN_RST" value="30"/>
                <Property id="HYSTERESIS" value="20"/>
                <Property id="ON_DEBOUNCE" value="3"/>
                <Property id="VELOCITY" value="2500"/>
                <Property id="IIR_FILTER" value="false"/>
                <Property id="IIR_FILTER_COEFF" value="128"/>
                <Property id="MEDIAN_FILTER" value="false"/>
                <Property id="AVG_FILTER" value="false"/>
                <Property id="JITTER_FILTER" value="false"/>
                <Property id="AIIR_FILTER" value="false"/>
                <Property id="AIIR_NO_MOV_TH" value="3"/>
                <Property id="AIIR_LITTLE_MOV_TH" value="7"/>
                <Property id="AIIR_LARGE_MOV_TH" value="12"/>
                <Property id="AIIR_MAXK" value="60"/>
                <Property id="AIIR_MINK" value="1"/>
                <Property id="AIIR_DIV_VAL" value="64"/>
                <Property id="CENTROID_TYPE" value="CSD3X3"/>
                <Property id="CROSS_COUPLING_POS_TH" value="5"/>
                <Property id="EDGE_CORRECTION" value="true"/>
                <Property id="EDGE_VIRTUAL_SENSOR_TH" value="100"/>
                <Property id="EDGE_PENULTIMATE_TH" value="100"/>
                <Property id="TWO_FINGER_DETECTION" value="false"/>
                <Property id="ACCEL_COEFF" value="9"/>
                <Property id="SPEED_COEFF" value="2"/>
                <Property id="DIVISOR" value="4"/>
                <Property id="SPEED_TH_X" value="3"/>
                <Property id="SPEED_TH_Y" value="4"/>
                <Property id="BALLISTIC_MULT" value="false"/>
                <Property id="GESTURE_ENABLE" value="false"/>
                <Property id="GESTURE_1F_SINGLE_CLICK_ENABLE" value="true"/>
                <Property id="GESTURE_1F_DOUBLE_CLICK_ENABLE" value="true"/>
                <Property id="GESTURE_1F_CLICK_DRAG_ENABLE" value="true"/>
                <Property id="GESTURE_2F_SINGLE_CLICK_ENABLE" value="true"/>
                <Property id="GESTURE_1F_SCROLL_ENABLE" value="true"/>
                <Property id="GESTURE_2F_SCROLL_ENABLE" value="true"/>
                <Property id="GESTURE_1F_EDGE_SWIPE_ENABLE" value="true"/>
                <Property id="GESTURE_1F_FLICK_ENABLE" value="true"/>
                <Property id="GESTURE_1F_ROTATE_ENABLE" value="true"/>
                <Property id="GESTURE_2F_ZOOM_ENABLE" value="true"/>
                <Property id="GESTURE_FILTERING_ENABLE" value="false"/>
                <Property id="CLICK_TIMEOUT_MAX" value="1000"/>
                <Property id="CLICK_TIMEOUT_MIN" value="0"/>
                <Property id="CLICK_DISTANCE_MAX" value="100"/>
                <Property id="SECOND_CLICK_INTERVAL_MAX" value="1000"/>
                <Property id="SECOND_CLICK_INTERVAL_MIN" value="0"/>
                <Property id="SECOND_CLICK_DISTANCE_MAX" value="100"/>
                <Property id="SCROLL_DEBOUNCE" value="3"/>
                <Property id="SCROLL_DISTANCE_MIN" value="20"/>
                <Property id="ROTATE_DEBOUNCE" value="10"/>
                <Property id="ROTATE_DISTANCE_MIN" value="50"/>
                <Property id="ZOOM_DEBOUNCE" value="3"/>
                <Property id="ZOOM_DISTANCE_MIN" value="50"/>
                <Property id="FLICK_TIMEOUT_MAX" value="300"/>
                <Property id="FLICK_DISTANCE_MIN" value="100"/>
                <Property id="EDGE_EDGE_SIZE" value="200"/>
                <Property id="EDGE_DISTANCE_MIN" value="200"/>
                <Property id="EDGE_TIMEOUT_MAX" value="2000"/>
                <Property id="EDGE_ANGLE_MAX" value="45"/>
            </WidgetProperties>
            <Electrodes>
                <Electrode id="Rx0" kind="Column">
                    <ElectrodeProperties>
                        <Property id="IDAC0" value="32"/>
                        <Property id="IDAC1" value="32"/>
                        <Property id="IDAC2" value="32"/>
                        <Property id="PINS" value="Dedicated pin"/>
                    </ElectrodeProperties>
                </Electrode>
                <Electrode id="Tx" kind="Row">
                    <ElectrodeProperties>
                        <Property id="IDAC0" value="32"/>
                        <Property id="IDAC1" value="32"/>
                        <Property id="IDAC2" value="32"/>
                        <Property id="PINS" value="Dedicated pin"/>
                    </ElectrodeProperties>
                </Electrode>
            </Electrodes>
        </Widget>
        <Widget id="Button1" type="CSX_BUTTON">
            <WidgetProperties>
                <Property id="DIPLEXING" value="false"/>
                <Property id="MAX_POS_X" value="300"/>
                <Property id="MAX_POS_Y" value="300"/>
                <Property id="FINGER_CP" value="0.16"/>
                <Property id="SNS_CLK" value="16"/>
                <Property id="SNS_CLK_FREQ" value=""/>
                <Property id="ROW_SNS_CLK" value="16"/>
                <Property id="ROW_SNS_CLK_FREQ" value=""/>
                <Property id="SNS_CLK_SOURCE" value="AUTO"/>
                <Property id="TX_CLK" value="80"/>
                <Property id="TX_CLK_FREQ" value=""/>
                <Property id="TX_CLK_SOURCE" value="AUTO"/>
                <Property id="RESOLUTION" value="RES12BIT"/>
                <Property id="NUM_CONV" value="100"/>
                <Property id="IDAC_MOD0" value="32"/>
                <Property id="IDAC_MOD1" value="32"/>
                <Property id="IDAC_MOD2" value="32"/>
                <Property id="ROW_IDAC_MOD0" value="32"/>
                <Property id="ROW_IDAC_MOD1" value="32"/>
                <Property id="ROW_IDAC_MOD2" value="32"/>
                <Property id="FINGER_TH" value="90"/>
                <Property id="PROX_TOUCH_TH" value="200"/>
                <Property id="NOISE_TH" value="40"/>
                <Property id="NNOISE_TH" value="40"/>
                <Property id="LOW_BSLN_RST" value="30"/>
                <Property id="HYSTERESIS" value="20"/>
                <Property id="ON_DEBOUNCE" value="3"/>
                <Property id="VELOCITY" value="45000"/>
                <Property id="IIR_FILTER" value="false"/>
                <Property id="IIR_FILTER_COEFF" value="128"/>
                <Property id="MEDIAN_FILTER" value="false"/>
                <Property id="AVG_FILTER" value="false"/>
                <Property id="JITTER_FILTER" value="false"/>
                <Property id="AIIR_FILTER" value="false"/>
                <Property id="AIIR_NO_MOV_TH" value="3"/>
                <Property id="AIIR_LITTLE_MOV_TH" value="7"/>
                <Property id="AIIR_LARGE_MOV_TH" value="12"/>
                <Property id="AIIR_MAXK" value="60"/>
                <Property id="AIIR_MINK" value="1"/>
                <Property id="AIIR_DIV_VAL" value="64"/>
                <Property id="CENTROID_TYPE" value="CSD3X3"/>
                <Property id="CROSS_COUPLING_POS_TH" value="5"/>
                <Property id="EDGE_CORRECTION" value="true"/>
                <Property id="EDGE_VIRTUAL_SENSOR_TH" value="100"/>
                <Property id="EDGE_PENULTIMATE_TH" value="100"/>
                <Property id="TWO_FINGER_DETECTION" value="false"/>
                <Property id="ACCEL_COEFF" value="9"/>
                <Property id="SPEED_COEFF" value="2"/>
                <Property id="DIVISOR" value="4"/>
                <Property id="SPEED_TH_X" value="3"/>
                <Property id="SPEED_TH_Y" value="4"/>
                <Property id="BALLISTIC_MULT" value="false"/>
                <Property id="GESTURE_ENABLE" value="false"/>
                <Property id="GESTURE_1F_SINGLE_CLICK_ENABLE" value="true"/>
                <Property id="GESTURE_1F_DOUBLE_CLICK_ENABLE" value="true"/>
                <Property id="GESTURE_1F_CLICK_DRAG_ENABLE" value="true"/>
                <Property id="GESTURE_2F_SINGLE_CLICK_ENABLE" value="true"/>
                <Property id="GESTURE_1F_SCROLL_ENABLE" value="true"/>
                <Property id="GESTURE_2F_SCROLL_ENABLE" value="true"/>
                <Property id="GESTURE_1F_EDGE_SWIPE_ENABLE" value="true"/>
                <Property id="GESTURE_1F_FLICK_ENABLE" value="true"/>
                <Property id="GESTURE_1F_ROTATE_ENABLE" value="true"/>
                <Property id="GESTURE_2F_ZOOM_ENABLE" value="true"/>
                <Property id="GESTURE_FILTERING_ENABLE" value="false"/>
                <Property id="CLICK_TIMEOUT_MAX" value="1000"/>
                <Property id="CLICK_TIMEOUT_MIN" value="0"/>
                <Property id="CLICK_DISTANCE_MAX" value="100"/>
                <Property id="SECOND_CLICK_INTERVAL_MAX" value="1000"/>
                <Property id="SECOND_CLICK_INTERVAL_MIN" value="0"/>
                <Property id="SECOND_CLICK_DISTANCE_MAX" value="100"/>
                <Property id="SCROLL_DEBOUNCE" value="3"/>
                <Property id="SCROLL_DISTANCE_MIN" value="20"/>
                <Property id="ROTATE_DEBOUNCE" value="10"/>
                <Property id="ROTATE_DISTANCE_MIN" value="50"/>
                <Property id="ZOOM_DEBOUNCE" value="3"/>
                <Property id="ZOOM_DISTANCE_MIN" value="50"/>
                <Property id="FLICK_TIMEOUT_MAX" value="300"/>
                <Property id="FLICK_DISTANCE_MIN" value="100"/>
                <Property id="EDGE_EDGE_SIZE" value="200"/>
                <Property id="EDGE_DISTANCE_MIN" value="200"/>
                <Property id="EDGE_TIMEOUT_MAX" value="2000"/>
                <Property id="EDGE_ANGLE_MAX" value="45"/>
            </WidgetProperties>
            <Electrodes>
                <Electrode id="Rx0" kind="Column">
                    <ElectrodeProperties>
                        <Property id="IDAC0" value="32"/>
                        <Property id="IDAC1" value="32"/>
                        <Property id="IDAC2" value="32"/>
                        <Property id="PINS" value="Dedicated pin"/>
                    </ElectrodeProperties>
                </Electrode>
                <Electrode id="Tx" kind="Row">
                    <ElectrodeProperties>
                        <Property id="IDAC0" value="32"/>
                        <Property id="IDAC1" value="32"/>
                        <Property id="IDAC2" value="32"/>
                        <Property id="PINS" value="Dedicated pin"/>
                    </ElectrodeProperties>
                </Electrode>
            </Electrodes>
        </Widget>
        <Widget id="LinearSlider0" type="LINEAR_SLIDER">
            <WidgetProperties>
                <Property id="DIPLEXING" value="false"/>
                <Property id="MAX_POS_X" value="100"/>
                <Property id="MAX_POS_Y" value="100"/>
                <Property id="FINGER_CP" value="0.1"/>
                <Property id="SNS_CLK" value="34"/>
                <Property id="SNS_CLK_FREQ" value=""/>
                <Property id="ROW_SNS_CLK" value="2"/>
                <Property id="ROW_SNS_CLK_FREQ" value=""/>
                <Property id="SNS_CLK_SOURCE" value="DIRECT"/>
                <Property id="TX_CLK" value="2"/>
                <Property id="TX_CLK_FREQ" value=""/>
                <Property id="TX_CLK_SOURCE" value="AUTO"/>
                <Property id="RESOLUTION" value="RES13BIT"/>
                <Property id="NUM_CONV" value="100"/>
                <Property id="IDAC_MOD0" value="32"/>
                <Property id="IDAC_MOD1" value="32"/>
                <Property id="IDAC_MOD2" value="32"/>
                <Property id="ROW_IDAC_MOD0" value="32"/>
                <Property id="ROW_IDAC_MOD1" value="32"/>
                <Property id="ROW_IDAC_MOD2" value="32"/>
                <Property id="FINGER_TH" value="100"/>
                <Property id="PROX_TOUCH_TH" value="200"/>
                <Property id="NOISE_TH" value="40"/>
                <Property id="NNOISE_TH" value="40"/>
                <Property id="LOW_BSLN_RST" value="30"/>
                <Property id="HYSTERESIS" value="10"/>
                <Property id="ON_DEBOUNCE" value="3"/>
                <Property id="VELOCITY" value="2500"/>
                <Property id="IIR_FILTER" value="false"/>
                <Property id="IIR_FILTER_COEFF" value="128"/>
                <Property id="MEDIAN_FILTER" value="false"/>
                <Property id="AVG_FILTER" value="false"/>
                <Property id="JITTER_FILTER" value="true"/>
                <Property id="AIIR_FILTER" value="false"/>
                <Property id="AIIR_NO_MOV_TH" value="3"/>
                <Property id="AIIR_LITTLE_MOV_TH" value="7"/>
                <Property id="AIIR_LARGE_MOV_TH" value="12"/>
                <Property id="AIIR_MAXK" value="60"/>
                <Property id="AIIR_MINK" value="1"/>
                <Property id="AIIR_DIV_VAL" value="64"/>
                <Property id="CENTROID_TYPE" value="CSD3X3"/>
                <Property id="CROSS_COUPLING_POS_TH" value="5"/>
                <Property id="EDGE_CORRECTION" value="true"/>
                <Property id="EDGE_VIRTUAL_SENSOR_TH" value="100"/>
                <Property id="EDGE_PENULTIMATE_TH" value="100"/>
                <Property id="TWO_FINGER_DETECTION" value="false"/>
                <Property id="ACCEL_COEFF" value="9"/>
                <Property id="SPEED_COEFF" value="2"/>
                <Property id="DIVISOR" value="4"/>
                <Property id="SPEED_TH_X" value="3"/>
                <Property id="SPEED_TH_Y" value="4"/>
                <Property id="BALLISTIC_MULT" value="false"/>
                <Property id="GESTURE_ENABLE" value="false"/>
                <Property id="GESTURE_1F_SINGLE_CLICK_ENABLE" value="true"/>
                <Property id="GESTURE_1F_DOUBLE_CLICK_ENABLE" value="true"/>
                <Property id="GESTURE_1F_CLICK_DRAG_ENABLE" value="true"/>
                <Property id="GESTURE_2F_SINGLE_CLICK_ENABLE" value="true"/>
                <Property id="GESTURE_1F_SCROLL_ENABLE" value="true"/>
                <Property id="GESTURE_2F_SCROLL_ENABLE" value="true"/>
                <Property id="GESTURE_1F_EDGE_SWIPE_ENABLE" value="true"/>
                <Property id="GESTURE_1F_FLICK_ENABLE" value="true"/>
                <Property id="GESTURE_1F_ROTATE_ENABLE" value="true"/>
                <Property id="GESTURE_2F_ZOOM_ENABLE" value="true"/>
                <Property id="GESTURE_FILTERING_ENABLE" value="false"/>
                <Property id="CLICK_TIMEOUT_MAX" value="1000"/>
                <Property id="CLICK_TIMEOUT_MIN" value="0"/>
                <Property id="CLICK_DISTANCE_MAX" value="100"/>
                <Property id="SECOND_CLICK_INTERVAL_MAX" value="1000"/>
                <Property id="SECOND_CLICK_INTERVAL_MIN" value="0"/>
                <Property id="SECOND_CLICK_DISTANCE_MAX" value="100"/>
                <Property id="SCROLL_DEBOUNCE" value="3"/>
                <Property id="SCROLL_DISTANCE_MIN" value="20"/>
                <Property id="ROTATE_DEBOUNCE" value="10"/>
                <Property id="ROTATE_DISTANCE_MIN" value="50"/>
                <Property id="ZOOM_DEBOUNCE" value="3"/>
                <Property id="ZOOM_DISTANCE_MIN" value="50"/>
                <Property id="FLICK_TIMEOUT_MAX" value="300"/>
                <Property id="FLICK_DISTANCE_MIN" value="100"/>
                <Property id="EDGE_EDGE_SIZE" value="200"/>
                <Property id="EDGE_DISTANCE_MIN" value="200"/>
                <Property id="EDGE_TIMEOUT_MAX" value="2000"/>
                <Property id="EDGE_ANGLE_MAX" value="45"/>
            </WidgetProperties>
            <Electrodes>
                <Electrode id="Sns0" kind="Sensor">
                    <ElectrodeProperties>
                        <Property id="IDAC0" value="32"/>
                        <Property id="IDAC1" value="32"/>
                        <Property id="IDAC2" value="32"/>
                        <Property id="PINS" value="Dedicated pin"/>
                    </ElectrodeProperties>
                </Electrode>
                <Electrode id="Sns1" kind="Sensor">
                    <ElectrodeProperties>
                        <Property id="IDAC0" value="32"/>
                        <Property id="IDAC1" value="32"/>
                        <Property id="IDAC2" value="32"/>
                        <Property id="PINS" value="Dedicated pin"/>
                    </ElectrodeProperties>
                </Electrode>
                <Electrode id="Sns2" kind="Sensor">
                    <ElectrodeProperties>
                        <Property id="IDAC0" value="32"/>
                        <Property id="IDAC1" value="32"/>
                        <Property id="IDAC2" value="32"/>
                        <Property id="PINS" value="Dedicated pin"/>
                    </ElectrodeProperties>
                </Electrode>
                <Electrode id="Sns3" kind="Sensor">
                    <ElectrodeProperties>
                        <Property id="IDAC0" value="32"/>
                        <Property id="IDAC1" value="32"/>
                        <Property id="IDAC2" value="32"/>
                        <Property id="PINS" value="Dedicated pin"/>
                    </ElectrodeProperties>
                </Electrode>
                <Electrode id="Sns4" kind="Sensor">
                    <ElectrodeProperties>
                        <Property id="IDAC0" value="32"/>
                        <Property id="IDAC1" value="32"/>
                        <Property id="IDAC2" value="32"/>
                        <Property id="PINS" value="Dedicated pin"/>
                    </ElectrodeProperties>
                </Electrode>
            </Electrodes>
        </Widget>
    </Widgets>
</Configuration>
CAPSENSE_CONFIG_END
*/

#if defined(__cplusplus)
}
#endif

#endif /* CY_CAPSENSE_CORE == __CORTEX_M */

#endif /* CYCFG_CAPSENSE_H */

/* [] END OF FILE */