/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "stats_report.h"

DigitalOut RedLED(LED1);
DigitalOut GreenLED(LED2);
DigitalOut BlueLED(LED3);
DigitalOut led1(LED4);
DigitalOut led2(LED5);
DigitalIn sw2(P0_4);

#define SLEEP_TIME                  200 // (msec)
#define PRINT_AFTER_N_LOOPS         20

// main() runs in its own thread in the OS
int main()
{
    SystemReport sys_state( SLEEP_TIME * PRINT_AFTER_N_LOOPS /* Loop delay time in ms */);

    int count = 0;
    while (true) {
        // Blink LED and wait 0.5 seconds
        if (sw2 == 1) {
            led1= !led1;
            thread_sleep_for(SLEEP_TIME);
            led2 = !led2;
        }
        else {
            thread_sleep_for(SLEEP_TIME);
            RedLED = !RedLED;
            thread_sleep_for(SLEEP_TIME);
            GreenLED = !GreenLED;
            thread_sleep_for(SLEEP_TIME);
            BlueLED = !BlueLED;
            thread_sleep_for(SLEEP_TIME);
        }

        if ((0 == count) || (PRINT_AFTER_N_LOOPS == count)) {
            // Following the main thread wait, report on the current system status
            sys_state.report_state();
            count = 0;
        }
        ++count;
    }
}
