 /**
 * @author Andrew Reed 
 * 
 * Freeware --
 * simple driver hacked together by hardware engineer, definite scope for 
 * improvement by someone who knows waht they are doing.
 *
 * @section DESCRIPTION
 *
 * SHT40 i2c Humidity and Temperature sensor.
 *
 * Datasheet, specs, and information:
 *
 * https://www.adafruit.com/product/4885
 */

/**
 * Includes
 */
#include "SHT40.h"

SHT40::SHT40(PinName sda, PinName scl) {

    i2c_ = new I2C(sda, scl);
    //400KHz, as specified by the datasheet.
    i2c_->frequency(I2C_SPEED_FAST);



}

int SHT40::tempC(void) {

    char txBuff[2];
    char rxBuff[6];

    txBuff[0] = SHT4x_NOHEAT_HIGHPRECISION; // Triggers a temperature measure by feeding correct opcode.
    txBuff[1] = SHT4x_NOHEAT_HIGHPRECISION >> 8;
    i2c_->write((SHT40_I2C_ADDRESS << 1) & 0xFE, txBuff, 2);
    thread_sleep_for(50); // Per datasheet, wait long enough for device to sample temperature
    
    // Reads triggered measure
    i2c_->read((SHT40_I2C_ADDRESS << 1) | 0x01, rxBuff, 6);
    thread_sleep_for(1);
    
    // Algorithm from arduino sht4x.h to compute temperature.
    unsigned int rawTemperature = ((unsigned int) rxBuff[0] << 8) | (unsigned int) rxBuff[1];
    rawTemperature &= 0xFFFC;

    float tempTemperature = rawTemperature / (float)65536; //2^16 = 65536
    float realTemperature = -46.85 + (175.72 * tempTemperature); //From page 14
 
    return (int)realTemperature;

}
int SHT40::relHumid(void) {

    char txBuff[2];
    char rxBuff[6];


    txBuff[0] = SHT4x_NOHEAT_HIGHPRECISION; // send command.
    txBuff[1] = SHT4x_NOHEAT_HIGHPRECISION >> 8;
    i2c_->write((SHT40_I2C_ADDRESS << 1) & 0xFE, txBuff, 2);
    thread_sleep_for(16); // delay to sample humidity
    
    // Reads measurement
    i2c_->read((SHT40_I2C_ADDRESS << 1) | 0x01, rxBuff, 6);
    thread_sleep_for(1);
    
    //Algorithm from sht4x.h.
    unsigned int rawHumidity = ((unsigned int) rxBuff[3] << 8) | (unsigned int) rxBuff[4];

    rawHumidity &= 0xFFFC; //Zero out the status bits but keep them in place
    
    //Convert to relative humidity
    float RH = rawHumidity / (float)65536; // two bytes worth to float
    float rh = -6 + (125 * RH); // adjustment values as per sht4x.h
    rh = min(max(rh, (float)0.0), (float)100.0);


    return (int)rh;

}
float SHT40::tempCF(void) {

    char txBuff[2];
    char rxBuff[6];

    txBuff[0] = SHT4x_NOHEAT_HIGHPRECISION; // Triggers a temperature measure by feeding correct opcode.
    txBuff[1] = SHT4x_NOHEAT_HIGHPRECISION >> 8;
    i2c_->write((SHT40_I2C_ADDRESS << 1) & 0xFE, txBuff, 2);
    thread_sleep_for(50); // Per datasheet, wait long enough for device to sample temperature
    
    // Reads triggered measure
    i2c_->read((SHT40_I2C_ADDRESS << 1) | 0x01, rxBuff, 6);
    thread_sleep_for(1);
    
    // Algorithm from arduino sht4x.h to compute temperature.
    unsigned int rawTemperature = ((unsigned int) rxBuff[0] << 8) | (unsigned int) rxBuff[1];
    rawTemperature &= 0xFFFC;

    float tempTemperature = rawTemperature / (float)65536; //2^16 = 65536
    float realTemperature = -46.85 + (175.72 * tempTemperature); //From page 14
 
    return (float)realTemperature;

}
float SHT40::relHumidF(void) {

    char txBuff[2];
    char rxBuff[6];


    txBuff[0] = SHT4x_NOHEAT_HIGHPRECISION; // send command.
    txBuff[1] = SHT4x_NOHEAT_HIGHPRECISION >> 8;
    i2c_->write((SHT40_I2C_ADDRESS << 1) & 0xFE, txBuff, 2);
    thread_sleep_for(16); // delay to sample humidity
    
    // Reads measurement
    i2c_->read((SHT40_I2C_ADDRESS << 1) | 0x01, rxBuff, 6);
    thread_sleep_for(1);
    
    //Algorithm from sht4x.h.
    unsigned int rawHumidity = ((unsigned int) rxBuff[3] << 8) | (unsigned int) rxBuff[4];

    rawHumidity &= 0xFFFC; //Zero out the status bits but keep them in place
    
    //Convert to relative humidity
    float RH = rawHumidity / (float)65536; // two bytes worth to float
    float rh = -6 + (125 * RH); // adjustment values as per sht4x.h
    rh = min(max(rh, (float)0.0), (float)100.0);


    return (float)rh;

}