/** Sample program to read temperature and humidity
 *
 * @author Alex Lipford
 * Georgia Institute of Technology 
 * ECE 4180 Embeded Systems Design
 * Professor Hamblen
 * 10/19/2014
 * 
 * @section LICENSE
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <alexlipford@gmail.com> wrote this file. As long as you retain this notice you
 * can do whatever you want with this stuff. If we meet some day, and you think
 * this stuff is worth it, you can buy me a beer in return.
 * ----------------------------------------------------------------------------
 *
 *
 * @section DESCRIPTION
 *
 * Honeywell HTU21D Humidity and Temperature sensor.
 *
 * Datasheet, specs, and information:
 *
 * https://www.sparkfun.com/products/12064
 */
 
#include "mbed.h"
#include "SHT40.h"
#include "platform/mbed_thread.h"

SHT40 temphumid(P6_1, P6_0); //Temp humid sensor || SDA, SCL

int tempC;
int relHumid;

int main() {
    printf("Starting humidity and temperature Sensor");
    while(1) {
        tempC = temphumid.tempC();
        thread_sleep_for(1000);
        relHumid = temphumid.relHumid();
        printf("Temperature: %d C\n\r", tempC);
        printf("Reative Humidity: %d %%\n\r", relHumid);
        printf("\n\r");
        thread_sleep_for(1000);
    }
}
