/* Hello World! for the Emwin TFT Library */

#include "mbed.h"
#include "GUI.h"
#include "cy8ckit_028_tft.h"

#define LED_DIAMETER    (32)
#define LED_RADIUS      (LED_DIAMETER/2)
#define DISPLAY_X       (320)
#define DISPLAY_Y       (240)
#define NUMLEDS_X       (DISPLAY_X/LED_DIAMETER)
#define NUMLEDS_Y       (DISPLAY_Y/LED_DIAMETER)
#define LED_OFF         (0)
#define LED_ON          (1)
#define TITLE_OFFSET    (16+LED_RADIUS)      

AnalogIn lightLevel(P10_0);

void Display_Init(void)
{
    /* Initialise EmWin driver*/
    GUI_Init();

    /* Set font size, foreground and background Colours */
    GUI_SetFont(GUI_FONT_24B_1);
    GUI_SetColor(GUI_WHITE);
    GUI_SetBkColor(GUI_BLACK);

    /* Clear screen and print splash screen */
    GUI_Clear();
    GUI_SetTextAlign(GUI_TA_HCENTER);
    GUI_DispStringAt("CITY3032 Light Level", 160, 0);
}

int main()
{
    /* Initialise display */
    Display_Init();

    printf("light level\r\n");

    GUI_SetFont(GUI_FONT_24B_1);
    GUI_SetColor(GUI_WHITE);
    while(true) {
        int lightPercent;
        lightPercent = (lightLevel.read_u16()*100)/65535;
        printf("light level is %d\r\n",lightPercent);
        ThisThread::sleep_for(1000);
    }
 
}



