/*********************************************************************
*                SEGGER Microcontroller GmbH                         *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2018  SEGGER Microcontroller GmbH                *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.48 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software  has been licensed to  Cypress Semiconductor Corporation,
whose registered  office is situated  at 198 Champion Ct. San Jose, CA 
95134 USA  solely for the  purposes of creating  libraries for Cypress
PSoC3 and  PSoC5 processor-based devices,  sublicensed and distributed
under  the  terms  and  conditions  of  the  Cypress  End User License
Agreement.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information
Licensor:                 SEGGER Microcontroller Systems LLC
Licensed to:              Cypress Semiconductor Corp, 198 Champion Ct., San Jose, CA 95134, USA
Licensed SEGGER software: emWin
License number:           GUI-00319
License model:            Services and License Agreement, signed June 10th, 2009
Licensed platform:        Any Cypress platform (Initial targets are: PSoC3, PSoC5)
----------------------------------------------------------------------
Support and Update Agreement (SUA)
SUA period:               2009-06-12 - 2022-07-27
Contact to extend SUA:    sales@segger.com
----------------------------------------------------------------------
File        : WIDGET_MultiLanguageCSV.c
Purpose     : Shows how to change the language of widgets using a CSV-file
Requirements: WindowManager - (x)
              MemoryDevices - (x)
              AntiAliasing  - ( )
              VNC-Server    - ( )
              PNG-Library   - ( )
              TrueTypeFonts - ( )
---------------------------END-OF-HEADER------------------------------
*/

#include <stddef.h>
#include <string.h>

#include "DIALOG.h"

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/
/*********************************************************************
*
*       Widget IDs
*/
#define ID_FRAMEWIN_0  (GUI_ID_USER + 0x00)
#define ID_BUTTON_0    (GUI_ID_USER + 0x01)
#define ID_BUTTON_1    (GUI_ID_USER + 0x02)
#define ID_BUTTON_2    (GUI_ID_USER + 0x03)
#define ID_CHECKBOX_0  (GUI_ID_USER + 0x04)
#define ID_RADIO_0     (GUI_ID_USER + 0x05)

/*********************************************************************
*
*       Messages
*/
#define APP_SETLANG (WM_USER + 1)

/*********************************************************************
*
*       Text IDs
*/
#define APP_TI_COLORS   0
#define APP_TI_HELP     1
#define APP_TI_EXIT     2
#define APP_TI_CONNECT  3
#define APP_TI_ENGLISH  4
#define APP_TI_GERMAN   5
#define APP_TI_ITALIAN  6
#define APP_TI_SETTINGS 7

#define MAX_TEXT_LEN 50

/*********************************************************************
*
*       Language index
*/
#define LANG_ENGLISH 0
#define LANG_GERMAN  1
#define LANG_ITALIAN 2

//
// Recommended memory to run the sample with adequate performance
//
#define RECOMMENDED_MEMORY (1024L * 10)

/*********************************************************************
*
*       Static data
*
**********************************************************************
*/
static int _IsClosed;

/*********************************************************************
*
*       Segger logo 100 x 50
*/
static GUI_CONST_STORAGE unsigned long _acSeggerLogo_100x50[] = {
#if (GUI_USE_ARGB == 1)
  0x00000000, 0x2A000000, 0xAF000000, 0xF4000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF4000000, 0xB0000000, 0x2A000000, 0x00000000,
  0x27000000, 0xE6000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE6000000, 0x27000000,
  0xA7000000, 0xFF000000, 0xFF383838, 0xFFD2D2D2, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 
        0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 
        0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 
        0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 
        0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFD2D2D2, 0xFF383838, 0xFF000000, 0xA7000000,
  0xEF000000, 0xFF000000, 0xFFCBCBCB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCBCBCB, 0xFF000000, 0xEF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFF, 0xFFE5E5F4, 0xFFF8F8FC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE3E3F3, 0xFFF9F9FD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF9393D1, 0xFF2626A2, 0xFF4E4EB3, 0xFFF2F2F9, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF8B8BCD, 0xFF2525A2, 0xFF5555B6, 0xFFF4F4FA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5656B7, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF7373C3, 0xFFFCFCFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF4F4FB3, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF7676C4, 0xFFFDFDFE, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFBABAE1, 0xFF2323A1, 0xFF1F1F9F, 0xFF2121A0, 0xFFA9A9DA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFB4B4DF, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF2121A0, 0xFFA8A8DA, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFF, 0xFF8989CC, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF2828A3, 0xFFD7D7EE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF8383CA, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF2A2AA4, 0xFFD0D0EB, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF8F8FC, 0xFF5656B6, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF4848B1, 0xFFF1F1F9, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF6F6FB, 0xFF5656B7, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF4040AD, 0xFFF0F0F8, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE3E3F3, 0xFF3333A8, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF7474C4, 0xFFFDFDFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE4E4F3, 0xFF3535A8, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF6868BE, 
        0xFFFBFBFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFBABAE2, 0xFF2424A1, 0xFF1F1F9F, 0xFF20209F, 0xFFA8A8DA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC1C1E4, 0xFF2525A1, 0xFF1F1F9F, 0xFF20209F, 
        0xFF9696D2, 0xFFFEFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFF, 0xFF8686CB, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF2C2CA4, 0xFFD7D7EE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFF, 0xFF9191D0, 0xFF1F1F9F, 0xFF1F1F9F, 
        0xFF2626A2, 0xFFC6C6E7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFD, 0xFF5555B6, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF4747B0, 0xFFF0F0F9, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFD, 0xFF6464BD, 0xFF1F1F9F, 
        0xFF1F1F9F, 0xFF3636A9, 0xFFE5E5F4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF3F3FA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE1E1F2, 0xFF3434A8, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF7373C3, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEDEDF7, 0xFF3C3CAC, 
        0xFF1F1F9F, 0xFF1F1F9F, 0xFF5A5AB8, 0xFFF8F8FC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF7979C6, 0xFFF3F3FA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFBBBBE2, 0xFF2323A1, 0xFF1F1F9F, 0xFF20209F, 0xFFA9A9DA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCDCDEA, 
        0xFF2929A3, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF8686CB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF4C4CB2, 0xFF7979C6, 0xFFFDFDFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF8787CC, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF2C2CA5, 0xFFD4D4ED, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFA2A2D7, 0xFF2121A0, 0xFF1F1F9F, 0xFF2121A0, 0xFFB7B7E0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF4C4CB2, 0xFF2121A0, 0xFFAFAFDD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF7F7FC, 0xFF5555B6, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF4747B0, 0xFFF3F3FA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFDFDFE, 0xFF7070C2, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF3232A7, 0xFFDDDDF1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF4C4CB2, 0xFF1F1F9F, 0xFF2C2CA4, 0xFFD9D9EF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE3E3F3, 0xFF3535A9, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF7272C3, 0xFFFDFDFE, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFF4F4FA, 0xFF4949B1, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF4242AE, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 
        0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 
        0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 
        0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7B7BC6, 0xFFB5B5DF, 0xFFFEFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF4C4CB2, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF4C4CB3, 0xFFF3F3FA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFBCBCE3, 0xFF2121A0, 0xFF1F1F9F, 0xFF2121A0, 0xFFA8A8DA, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFD8D8EE, 0xFF2F2FA6, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 
        0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 
        0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 
        0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF2626A2, 0xFFE3E3F3, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF4C4CB2, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF7878C5, 0xFFFEFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF8787CC, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF2C2CA5, 0xFFD4D4ED, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFB3B3DE, 0xFF2222A0, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 
        0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 
        0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 
        0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF3333A8, 0xFFECECF7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF4C4CB2, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFFAEAEDC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF7F7FC, 0xFF5757B7, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF4545AF, 0xFFF3F3FA, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCECEEA, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 
        0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 
        0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 
        0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFDFDFF2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF4C4CB2, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF2F2FA6, 0xFFD9D9EF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE2E2F3, 0xFF3232A7, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF8C8CCE, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF4C4CB2, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF2F2FA6, 0xFFD9D9EF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE2E2F3, 0xFF3232A7, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF8C8CCE, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF4C4CB2, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFFAEAEDC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF7F7FC, 0xFF5757B7, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF4545AF, 0xFFF3F3FA, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCECEEA, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 
        0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 
        0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 
        0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFB2B2DE, 0xFFDFDFF2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF4C4CB2, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF7878C5, 0xFFFEFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF8787CC, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF2C2CA5, 0xFFD4D4ED, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFB3B3DE, 0xFF2222A0, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 
        0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 
        0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 
        0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF3333A7, 0xFFECECF7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF4C4CB2, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF4C4CB3, 0xFFF3F3FA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFBCBCE3, 0xFF2121A0, 0xFF1F1F9F, 0xFF2121A0, 0xFFA8A8DA, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFD8D8EE, 0xFF2F2FA6, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 
        0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 
        0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 
        0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF2626A2, 0xFFE3E3F3, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF4C4CB2, 0xFF1F1F9F, 0xFF2C2CA4, 0xFFD9D9EF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE3E3F3, 0xFF3535A9, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF7272C3, 0xFFFDFDFE, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFF4F4FA, 0xFF4949B1, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF4242AE, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 
        0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 
        0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 
        0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7A7AC6, 0xFF7B7BC6, 0xFFB5B5DF, 0xFFFEFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF4C4CB2, 0xFF2121A0, 0xFFAFAFDD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF7F7FC, 0xFF5555B6, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF4747B0, 0xFFF3F3FA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFDFDFE, 0xFF7070C2, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF3232A7, 0xFFDDDDF1, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF4C4CB2, 0xFF7979C6, 0xFFFDFDFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF8787CC, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF2C2CA5, 0xFFD4D4ED, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFA2A2D7, 0xFF2121A0, 0xFF1F1F9F, 0xFF2121A0, 0xFFB7B7E0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF7979C6, 0xFFF3F3FA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFBBBBE2, 0xFF2323A1, 0xFF1F1F9F, 0xFF20209F, 0xFFA9A9DA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCDCDEA, 
        0xFF2929A3, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF8686CB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF3F3FA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE1E1F2, 0xFF3434A8, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF7373C3, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEDEDF7, 0xFF3C3CAC, 
        0xFF1F1F9F, 0xFF1F1F9F, 0xFF5A5AB8, 0xFFF8F8FC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFCECECE, 0xFF7F7F7F, 0xFF5A5A5A, 0xFF555555, 0xFF6D6D6D, 0xFFADADAD, 0xFFF6F6F6, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFBBBBBB, 0xFF959595, 0xFF959595, 
        0xFF959595, 0xFF959595, 0xFF959595, 0xFF959595, 0xFFA2A2A2, 0xFFF4F4F4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD7D7D7, 0xFF878787, 0xFF5C5C5C, 0xFF555555, 0xFF6B6B6B, 0xFFA6A6A6, 0xFFF0F0F0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFF0F0F0, 0xFFA2A2A2, 0xFF686868, 0xFF545454, 0xFF5F5F5F, 0xFF8A8A8A, 0xFFD6D6D6, 0xFFFEFEFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCCCCCC, 0xFF969696, 0xFF959595, 0xFF959595, 0xFF959595, 0xFF959595, 0xFF959595, 0xFF9C9C9C, 
        0xFFE8E8E8, 0xFFFFFFFF, 0xFFEEEEEE, 0xFF9F9F9F, 0xFF959595, 0xFF959595, 0xFF959595, 0xFF959595, 0xFF989898, 0xFFB7B7B7, 0xFFF0F0F0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFD, 0xFF5555B6, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF4747B0, 0xFFF0F0F9, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFD, 0xFF6464BD, 0xFF1F1F9F, 
        0xFF1F1F9F, 0xFF3636A9, 0xFFE5E5F4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF8F8F8F, 0xFF070707, 0xFF000000, 0xFF030303, 0xFF050505, 0xFF000000, 0xFF010101, 0xFF383838, 0xFFF0F0F0, 0xFFFFFFFF, 0xFFE9E9E9, 0xFF060606, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF010101, 0xFFB7B7B7, 0xFFFFFFFF, 0xFFFDFDFD, 0xFF858585, 0xFF090909, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF222222, 0xFFC6C6C6, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFCACACA, 0xFF252525, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF090909, 0xFF7B7B7B, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF9F9F9, 0xFF242424, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF888888, 0xFFFFFFFF, 0xFF868686, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF232323, 0xFFD9D9D9, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFF, 0xFF8686CB, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF2C2CA4, 0xFFD7D7EE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFF, 0xFF9191D0, 0xFF1F1F9F, 0xFF1F1F9F, 
        0xFF2626A2, 0xFFC6C6E7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEDEDED, 0xFF0D0D0D, 0xFF000000, 0xFF838383, 0xFFF9F9F9, 0xFFFCFCFC, 0xFFB7B7B7, 0xFF161616, 0xFF000000, 0xFF9F9F9F, 0xFFFFFFFF, 0xFFDDDDDD, 0xFF000000, 0xFF000000, 0xFF8C8C8C, 
        0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFC4C4C4, 0xFFFCFCFC, 0xFFFFFFFF, 0xFF969696, 0xFF010101, 0xFF020202, 0xFF636363, 0xFFD6D6D6, 0xFFECECEC, 0xFFB6B6B6, 0xFF1F1F1F, 0xFF000000, 0xFF363636, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE2E2E2, 
        0xFF171717, 0xFF000000, 0xFF2C2C2C, 0xFFB7B7B7, 0xFFECECEC, 0xFFD6D6D6, 0xFF585858, 0xFF000000, 0xFF000000, 0xFFD2D2D2, 0xFFFFFFFF, 0xFFF5F5F5, 0xFF131313, 0xFF000000, 0xFF6E6E6E, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFB4B4B4, 0xFFBDBDBD, 
        0xFFF6F6F6, 0xFFFFFFFF, 0xFF747474, 0xFF000000, 0xFF202020, 0xFFB9B9B9, 0xFFB9B9B9, 0xFFB8B8B8, 0xFF979797, 0xFF0D0D0D, 0xFF000000, 0xFF646464, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFBABAE2, 0xFF2424A1, 0xFF1F1F9F, 0xFF20209F, 0xFFA8A8DA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC1C1E4, 0xFF2525A1, 0xFF1F1F9F, 0xFF20209F, 
        0xFF9696D2, 0xFFFEFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDDDDDD, 0xFF070707, 0xFF000000, 0xFF959595, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD6D6D6, 0xFF959595, 0xFFEFEFEF, 0xFFFFFFFF, 0xFFDDDDDD, 0xFF000000, 0xFF000000, 0xFFC7C7C7, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF7F7F7, 0xFF202020, 0xFF000000, 0xFF4D4D4D, 0xFFFBFBFB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDADADA, 0xFF656565, 0xFFA2A2A2, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF7A7A7A, 
        0xFF000000, 0xFF0C0C0C, 0xFFDBDBDB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF9F9F9, 0xFF888888, 0xFF6B6B6B, 0xFFF5F5F5, 0xFFFFFFFF, 0xFFF5F5F5, 0xFF131313, 0xFF000000, 0xFF9C9C9C, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFF747474, 0xFF000000, 0xFF2C2C2C, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF4F4F4F, 0xFF000000, 0xFF4B4B4B, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE3E3F3, 0xFF3333A8, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF7474C4, 0xFFFDFDFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE4E4F3, 0xFF3535A8, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF6868BE, 
        0xFFFBFBFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFB, 0xFF313131, 0xFF000000, 0xFF020202, 0xFF232323, 0xFF5B5B5B, 0xFF919191, 0xFFCFCFCF, 0xFFF9F9F9, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDDDDDD, 0xFF000000, 0xFF000000, 0xFF424242, 
        0xFF555555, 0xFF555555, 0xFF555555, 0xFF565656, 0xFF9D9D9D, 0xFFFFFFFF, 0xFFD8D8D8, 0xFF000000, 0xFF000000, 0xFFA7A7A7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFF6F6F6, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF7F7F7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF3B3B3B, 
        0xFF000000, 0xFF454545, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF8F8F8, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFF5F5F5, 0xFF131313, 0xFF000000, 0xFF343434, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF555555, 0xFF838383, 
        0xFFFCFCFC, 0xFFFFFFFF, 0xFF747474, 0xFF000000, 0xFF252525, 0xFFD4D4D4, 0xFFD4D4D4, 0xFFD3D3D3, 0xFFB0B0B0, 0xFF141414, 0xFF000000, 0xFF8B8B8B, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF8F8FC, 0xFF5656B6, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF4848B1, 0xFFF1F1F9, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF6F6FB, 0xFF5656B7, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF4040AD, 0xFFF0F0F8, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE4E4E4, 0xFF696969, 0xFF1E1E1E, 0xFF010101, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF2C2C2C, 0xFFC6C6C6, 0xFFFFFFFF, 0xFFDDDDDD, 0xFF000000, 0xFF000000, 0xFF0B0B0B, 
        0xFF0E0E0E, 0xFF0E0E0E, 0xFF0E0E0E, 0xFF0F0F0F, 0xFF585858, 0xFFFFFFFF, 0xFFC7C7C7, 0xFF000000, 0xFF000000, 0xFFBDBDBD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFA3A3A3, 0xFF161616, 0xFF131313, 0xFF131313, 0xFF1C1C1C, 0xFFBEBEBE, 0xFFFFFFFF, 0xFF2B2B2B, 
        0xFF000000, 0xFF5C5C5C, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF282828, 0xFF131313, 0xFF131313, 0xFF141414, 0xFF6A6A6A, 0xFFFFFFFF, 0xFFF5F5F5, 0xFF131313, 0xFF000000, 0xFF090909, 0xFF0E0E0E, 0xFF0E0E0E, 0xFF0E0E0E, 0xFF0E0E0E, 0xFF363636, 
        0xFFF5F5F5, 0xFFFFFFFF, 0xFF747474, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF010101, 0xFF5F5F5F, 0xFFF9F9F9, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFF, 0xFF8989CC, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF2828A3, 0xFFD6D6EE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF8383CA, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF2A2AA4, 0xFFD0D0EB, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF4F4F4, 0xFFD4D4D4, 0xFFA0A0A0, 0xFF555555, 0xFF050505, 0xFF000000, 0xFF282828, 0xFFF9F9F9, 0xFFDDDDDD, 0xFF000000, 0xFF000000, 0xFFB7B7B7, 
        0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEBEBEB, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFDCDCDC, 0xFF000000, 0xFF000000, 0xFF9F9F9F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC5C5C5, 0xFF4B4B4B, 0xFF464646, 0xFF0E0E0E, 0xFF000000, 0xFF999999, 0xFFFFFFFF, 0xFF3F3F3F, 
        0xFF000000, 0xFF3D3D3D, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF4F4F4, 0xFF626262, 0xFF464646, 0xFF2A2A2A, 0xFF000000, 0xFF363636, 0xFFFFFFFF, 0xFFF5F5F5, 0xFF131313, 0xFF000000, 0xFF8F8F8F, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFF6F6F6, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFF747474, 0xFF000000, 0xFF141414, 0xFF757575, 0xFF757575, 0xFF737373, 0xFF343434, 0xFF000000, 0xFF0B0B0B, 0xFFD3D3D3, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFBABAE1, 0xFF2323A1, 0xFF1F1F9F, 0xFF2121A0, 0xFFA9A9DA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFB4B4DF, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF2121A0, 0xFFA8A8DA, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF7F7F7, 0xFF444444, 0xFF4A4A4A, 0xFFECECEC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF9B9B9B, 0xFF000000, 0xFF0F0F0F, 0xFFE9E9E9, 0xFFDDDDDD, 0xFF000000, 0xFF000000, 0xFFC7C7C7, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFAFAFA, 0xFF2B2B2B, 0xFF000000, 0xFF383838, 0xFFF4F4F4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDCDCDC, 0xFF0F0F0F, 0xFF000000, 0xFF999999, 0xFFFFFFFF, 0xFF878787, 
        0xFF000000, 0xFF060606, 0xFFC4C4C4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFC, 0xFF535353, 0xFF000000, 0xFF363636, 0xFFFFFFFF, 0xFFF5F5F5, 0xFF131313, 0xFF000000, 0xFF9C9C9C, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFF747474, 0xFF000000, 0xFF2C2C2C, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE5E5E5, 0xFF000000, 0xFF000000, 0xFF969696, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF5656B7, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF7373C3, 0xFFFCFCFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF4F4FB3, 0xFF1F1F9F, 0xFF1F1F9F, 0xFF7676C4, 0xFFFDFDFE, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF0F0F0, 0xFF121212, 0xFF000000, 0xFF3F3F3F, 0xFFC2C2C2, 0xFFDCDCDC, 0xFFC8C8C8, 0xFF4A4A4A, 0xFF000000, 0xFF2F2F2F, 0xFFFBFBFB, 0xFFDDDDDD, 0xFF000000, 0xFF000000, 0xFF696969, 
        0xFF868686, 0xFF868686, 0xFF868686, 0xFF868686, 0xFF898989, 0xFFD7D7D7, 0xFFFFFFFF, 0xFFABABAB, 0xFF050505, 0xFF000000, 0xFF404040, 0xFFADADAD, 0xFFC8C8C8, 0xFFA2A2A2, 0xFF272727, 0xFF000000, 0xFF000000, 0xFF999999, 0xFFFFFFFF, 0xFFEBEBEB, 
        0xFF252525, 0xFF000000, 0xFF171717, 0xFF8D8D8D, 0xFFC6C6C6, 0xFFB9B9B9, 0xFF5A5A5A, 0xFF010101, 0xFF000000, 0xFF363636, 0xFFFFFFFF, 0xFFF5F5F5, 0xFF131313, 0xFF000000, 0xFF525252, 0xFF868686, 0xFF868686, 0xFF868686, 0xFF868686, 0xFF878787, 
        0xFFC3C3C3, 0xFFFFFFFF, 0xFF747474, 0xFF000000, 0xFF2C2C2C, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF0B0B0B, 0xFF000000, 0xFF7F7F7F, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF9393D1, 0xFF2626A2, 0xFF4E4EB3, 0xFFF2F2F9, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF8B8BCD, 0xFF2525A2, 0xFF5555B6, 0xFFF4F4FA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFAFAFAF, 0xFF191919, 0xFF000000, 0xFF020202, 0xFF060606, 0xFF020202, 0xFF000000, 0xFF1D1D1D, 0xFFCACACA, 0xFFFFFFFF, 0xFFECECEC, 0xFF0B0B0B, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF696969, 0xFFFFFFFF, 0xFFFEFEFE, 0xFF9E9E9E, 0xFF101010, 0xFF000000, 0xFF000000, 0xFF010101, 0xFF000000, 0xFF171717, 0xFF5C5C5C, 0xFF000000, 0xFF9A9A9A, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFD8D8D8, 0xFF343434, 0xFF010101, 0xFF000000, 0xFF010101, 0xFF000000, 0xFF040404, 0xFF5F5F5F, 0xFF101010, 0xFF373737, 0xFFFFFFFF, 0xFFFAFAFA, 0xFF2B2B2B, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF3C3C3C, 0xFFFDFDFD, 0xFF7C7C7C, 0xFF000000, 0xFF343434, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF373737, 0xFF000000, 0xFF585858, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFF, 0xFFE5E5F4, 0xFFF8F8FC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE3E3F3, 0xFFF9F9FD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEFEFEF, 0xFFA6A6A6, 0xFF767676, 0xFF6A6A6A, 0xFF777777, 0xFFA6A6A6, 0xFFF0F0F0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD0D0D0, 0xFFACACAC, 0xFFABABAB, 
        0xFFABABAB, 0xFFABABAB, 0xFFABABAB, 0xFFABABAB, 0xFFB1B1B1, 0xFFECECEC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE7E7E7, 0xFF9C9C9C, 0xFF727272, 0xFF6D6D6D, 0xFF919191, 0xFFE7E7E7, 0xFFECECEC, 0xFF7B7B7B, 0xFFDDDDDD, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFF9F9F9, 0xFFB7B7B7, 0xFF7D7D7D, 0xFF6A6A6A, 0xFF7E7E7E, 0xFFC4C4C4, 0xFFFEFEFE, 0xFF9D9D9D, 0xFFA8A8A8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDEDEDE, 0xFFAEAEAE, 0xFFABABAB, 0xFFABABAB, 0xFFABABAB, 0xFFABABAB, 0xFFABABAB, 0xFFAEAEAE, 
        0xFFE0E0E0, 0xFFFFFFFF, 0xFFE8E8E8, 0xFF969696, 0xFFCDCDCD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD5D5D5, 0xFF919191, 0xFFD8D8D8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFFEBEBEB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEBEBEB, 0xFF000000, 0xFF000000,
  0xEF000000, 0xFF000000, 0xFFCBCBCB, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCBCBCB, 0xFF000000, 0xEF000000,
  0xA7000000, 0xFF000000, 0xFF383838, 0xFFD2D2D2, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 
        0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 
        0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 
        0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 
        0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFD2D2D2, 0xFF383838, 0xFF000000, 0xA7000000,
  0x27000000, 0xE6000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE6000000, 0x27000000,
  0x00000000, 0x2A000000, 0xAF000000, 0xF4000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF4000000, 0xB0000000, 0x2A000000, 0x00000000
#else
  0xFF000000, 0xD5000000, 0x50000000, 0x0B000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0B000000, 0x4F000000, 0xD5000000, 0xFF000000,
  0xD8000000, 0x19000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x19000000, 0xD8000000,
  0x58000000, 0x00000000, 0x00383838, 0x00D2D2D2, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 
        0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 
        0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 
        0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 
        0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00D2D2D2, 0x00383838, 0x00000000, 0x58000000,
  0x10000000, 0x00000000, 0x00CBCBCB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CBCBCB, 0x00000000, 0x10000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFE, 0x00F4E5E5, 0x00FCF8F8, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F3E3E3, 0x00FDF9F9, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00D19393, 0x00A22626, 0x00B34E4E, 0x00F9F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CD8B8B, 0x00A22525, 0x00B65555, 0x00FAF4F4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00B75656, 0x009F1F1F, 0x009F1F1F, 0x00C37373, 0x00FEFCFC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B34F4F, 0x009F1F1F, 0x009F1F1F, 0x00C47676, 0x00FEFDFD, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00E1BABA, 0x00A12323, 0x009F1F1F, 0x00A02121, 0x00DAA9A9, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DFB4B4, 0x009F1F1F, 0x009F1F1F, 0x00A02121, 0x00DAA8A8, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFE, 0x00CC8989, 0x009F1F1F, 0x009F1F1F, 0x00A32828, 0x00EED7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CA8383, 0x009F1F1F, 0x009F1F1F, 0x00A42A2A, 0x00EBD0D0, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FCF8F8, 0x00B65656, 0x009F1F1F, 0x009F1F1F, 0x00B14848, 0x00F9F1F1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FBF6F6, 0x00B75656, 0x009F1F1F, 0x009F1F1F, 0x00AD4040, 0x00F8F0F0, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F3E3E3, 0x00A83333, 0x009F1F1F, 0x009F1F1F, 0x00C47474, 0x00FEFDFD, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F3E4E4, 0x00A83535, 0x009F1F1F, 0x009F1F1F, 0x00BE6868, 
        0x00FDFBFB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E2BABA, 0x00A12424, 0x009F1F1F, 0x009F2020, 0x00DAA8A8, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E4C1C1, 0x00A12525, 0x009F1F1F, 0x009F2020, 
        0x00D29696, 0x00FFFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFE, 0x00CB8686, 0x009F1F1F, 0x009F1F1F, 0x00A42C2C, 0x00EED7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFE, 0x00D09191, 0x009F1F1F, 0x009F1F1F, 
        0x00A22626, 0x00E7C6C6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FDFBFB, 0x00B65555, 0x009F1F1F, 0x009F1F1F, 0x00B04747, 0x00F9F0F0, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FDFBFB, 0x00BD6464, 0x009F1F1F, 
        0x009F1F1F, 0x00A93636, 0x00F4E5E5, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00FAF3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E1E1, 0x00A83434, 0x009F1F1F, 0x009F1F1F, 0x00C37373, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F7EDED, 0x00AC3C3C, 
        0x009F1F1F, 0x009F1F1F, 0x00B85A5A, 0x00FCF8F8, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00C67979, 0x00FAF3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E2BBBB, 0x00A12323, 0x009F1F1F, 0x009F2020, 0x00DAA9A9, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EACDCD, 
        0x00A32929, 0x009F1F1F, 0x009F1F1F, 0x00CB8686, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00B24C4C, 0x00C67979, 0x00FEFDFD, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CC8787, 0x009F1F1F, 0x009F1F1F, 0x00A52C2C, 0x00EDD4D4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00D7A2A2, 0x00A02121, 0x009F1F1F, 0x00A02121, 0x00E0B7B7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00B24C4C, 0x00A02121, 0x00DDAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FCF7F7, 0x00B65555, 0x009F1F1F, 0x009F1F1F, 0x00B04747, 0x00FAF3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FEFDFD, 0x00C27070, 0x009F1F1F, 0x009F1F1F, 0x00A73232, 0x00F1DDDD, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00B24C4C, 0x009F1F1F, 0x00A42C2C, 0x00EFD9D9, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F3E3E3, 0x00A93535, 0x009F1F1F, 0x009F1F1F, 0x00C37272, 0x00FEFDFD, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FAF4F4, 0x00B14949, 0x009F1F1F, 0x009F1F1F, 0x00AE4242, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 
        0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 
        0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 
        0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67B7B, 0x00DFB5B5, 0x00FFFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00B24C4C, 0x009F1F1F, 0x009F1F1F, 0x00B34C4C, 0x00FAF3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E3BCBC, 0x00A02121, 0x009F1F1F, 0x00A02121, 0x00DAA8A8, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00EED8D8, 0x00A62F2F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 
        0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 
        0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 
        0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x00A22626, 0x00F3E3E3, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00B24C4C, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x00C57878, 0x00FFFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CC8787, 0x009F1F1F, 0x009F1F1F, 0x00A52C2C, 0x00EDD4D4, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEB3B3, 0x00A02222, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 
        0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 
        0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 
        0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x00A83333, 0x00F7ECEC, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00B24C4C, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x00DCAEAE, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FCF7F7, 0x00B75757, 0x009F1F1F, 0x009F1F1F, 0x00AF4545, 0x00FAF3F3, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EACECE, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 
        0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 
        0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 
        0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00F2DFDF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00B24C4C, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x00A62F2F, 0x00EFD9D9, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F3E2E2, 0x00A73232, 0x009F1F1F, 0x009F1F1F, 0x00CE8C8C, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00B24C4C, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x00A62F2F, 0x00EFD9D9, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F3E2E2, 0x00A73232, 0x009F1F1F, 0x009F1F1F, 0x00CE8C8C, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00B24C4C, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x00DCAEAE, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FCF7F7, 0x00B75757, 0x009F1F1F, 0x009F1F1F, 0x00AF4545, 0x00FAF3F3, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EACECE, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 
        0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 
        0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 
        0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00DEB2B2, 0x00F2DFDF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00B24C4C, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x00C57878, 0x00FFFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CC8787, 0x009F1F1F, 0x009F1F1F, 0x00A52C2C, 0x00EDD4D4, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DEB3B3, 0x00A02222, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 
        0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 
        0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 
        0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x00A73333, 0x00F7ECEC, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00B24C4C, 0x009F1F1F, 0x009F1F1F, 0x00B34C4C, 0x00FAF3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E3BCBC, 0x00A02121, 0x009F1F1F, 0x00A02121, 0x00DAA8A8, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00EED8D8, 0x00A62F2F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 
        0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 
        0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 
        0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x009F1F1F, 0x00A22626, 0x00F3E3E3, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00B24C4C, 0x009F1F1F, 0x00A42C2C, 0x00EFD9D9, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F3E3E3, 0x00A93535, 0x009F1F1F, 0x009F1F1F, 0x00C37272, 0x00FEFDFD, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FAF4F4, 0x00B14949, 0x009F1F1F, 0x009F1F1F, 0x00AE4242, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 
        0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 
        0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 
        0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67A7A, 0x00C67B7B, 0x00DFB5B5, 0x00FFFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00B24C4C, 0x00A02121, 0x00DDAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FCF7F7, 0x00B65555, 0x009F1F1F, 0x009F1F1F, 0x00B04747, 0x00FAF3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FEFDFD, 0x00C27070, 0x009F1F1F, 0x009F1F1F, 0x00A73232, 0x00F1DDDD, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00B24C4C, 0x00C67979, 0x00FEFDFD, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CC8787, 0x009F1F1F, 0x009F1F1F, 0x00A52C2C, 0x00EDD4D4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00D7A2A2, 0x00A02121, 0x009F1F1F, 0x00A02121, 0x00E0B7B7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00C67979, 0x00FAF3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E2BBBB, 0x00A12323, 0x009F1F1F, 0x009F2020, 0x00DAA9A9, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EACDCD, 
        0x00A32929, 0x009F1F1F, 0x009F1F1F, 0x00CB8686, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00FAF3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E1E1, 0x00A83434, 0x009F1F1F, 0x009F1F1F, 0x00C37373, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F7EDED, 0x00AC3C3C, 
        0x009F1F1F, 0x009F1F1F, 0x00B85A5A, 0x00FCF8F8, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00CECECE, 0x007F7F7F, 0x005A5A5A, 0x00555555, 0x006D6D6D, 0x00ADADAD, 0x00F6F6F6, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00BBBBBB, 0x00959595, 0x00959595, 
        0x00959595, 0x00959595, 0x00959595, 0x00959595, 0x00A2A2A2, 0x00F4F4F4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00878787, 0x005C5C5C, 0x00555555, 0x006B6B6B, 0x00A6A6A6, 0x00F0F0F0, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00F0F0F0, 0x00A2A2A2, 0x00686868, 0x00545454, 0x005F5F5F, 0x008A8A8A, 0x00D6D6D6, 0x00FEFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CCCCCC, 0x00969696, 0x00959595, 0x00959595, 0x00959595, 0x00959595, 0x00959595, 0x009C9C9C, 
        0x00E8E8E8, 0x00FFFFFF, 0x00EEEEEE, 0x009F9F9F, 0x00959595, 0x00959595, 0x00959595, 0x00959595, 0x00989898, 0x00B7B7B7, 0x00F0F0F0, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FDFBFB, 0x00B65555, 0x009F1F1F, 0x009F1F1F, 0x00B04747, 0x00F9F0F0, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FDFBFB, 0x00BD6464, 0x009F1F1F, 
        0x009F1F1F, 0x00A93636, 0x00F4E5E5, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x008F8F8F, 0x00070707, 0x00000000, 0x00030303, 0x00050505, 0x00000000, 0x00010101, 0x00383838, 0x00F0F0F0, 0x00FFFFFF, 0x00E9E9E9, 0x00060606, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00010101, 0x00B7B7B7, 0x00FFFFFF, 0x00FDFDFD, 0x00858585, 0x00090909, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00222222, 0x00C6C6C6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00CACACA, 0x00252525, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00090909, 0x007B7B7B, 0x00FFFFFF, 0x00FFFFFF, 0x00F9F9F9, 0x00242424, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00888888, 0x00FFFFFF, 0x00868686, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00232323, 0x00D9D9D9, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFE, 0x00CB8686, 0x009F1F1F, 0x009F1F1F, 0x00A42C2C, 0x00EED7D7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFE, 0x00D09191, 0x009F1F1F, 0x009F1F1F, 
        0x00A22626, 0x00E7C6C6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EDEDED, 0x000D0D0D, 0x00000000, 0x00838383, 0x00F9F9F9, 0x00FCFCFC, 0x00B7B7B7, 0x00161616, 0x00000000, 0x009F9F9F, 0x00FFFFFF, 0x00DDDDDD, 0x00000000, 0x00000000, 0x008C8C8C, 
        0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00C4C4C4, 0x00FCFCFC, 0x00FFFFFF, 0x00969696, 0x00010101, 0x00020202, 0x00636363, 0x00D6D6D6, 0x00ECECEC, 0x00B6B6B6, 0x001F1F1F, 0x00000000, 0x00363636, 0x00FFFFFF, 0x00FFFFFF, 0x00E2E2E2, 
        0x00171717, 0x00000000, 0x002C2C2C, 0x00B7B7B7, 0x00ECECEC, 0x00D6D6D6, 0x00585858, 0x00000000, 0x00000000, 0x00D2D2D2, 0x00FFFFFF, 0x00F5F5F5, 0x00131313, 0x00000000, 0x006E6E6E, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00B4B4B4, 0x00BDBDBD, 
        0x00F6F6F6, 0x00FFFFFF, 0x00747474, 0x00000000, 0x00202020, 0x00B9B9B9, 0x00B9B9B9, 0x00B8B8B8, 0x00979797, 0x000D0D0D, 0x00000000, 0x00646464, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E2BABA, 0x00A12424, 0x009F1F1F, 0x009F2020, 0x00DAA8A8, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E4C1C1, 0x00A12525, 0x009F1F1F, 0x009F2020, 
        0x00D29696, 0x00FFFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DDDDDD, 0x00070707, 0x00000000, 0x00959595, 0x00FCFCFC, 0x00FFFFFF, 0x00FFFFFF, 0x00D6D6D6, 0x00959595, 0x00EFEFEF, 0x00FFFFFF, 0x00DDDDDD, 0x00000000, 0x00000000, 0x00C7C7C7, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F7F7F7, 0x00202020, 0x00000000, 0x004D4D4D, 0x00FBFBFB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DADADA, 0x00656565, 0x00A2A2A2, 0x00FFFFFF, 0x00FFFFFF, 0x007A7A7A, 
        0x00000000, 0x000C0C0C, 0x00DBDBDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F9F9F9, 0x00888888, 0x006B6B6B, 0x00F5F5F5, 0x00FFFFFF, 0x00F5F5F5, 0x00131313, 0x00000000, 0x009C9C9C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00747474, 0x00000000, 0x002C2C2C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x004F4F4F, 0x00000000, 0x004B4B4B, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F3E3E3, 0x00A83333, 0x009F1F1F, 0x009F1F1F, 0x00C47474, 0x00FEFDFD, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F3E4E4, 0x00A83535, 0x009F1F1F, 0x009F1F1F, 0x00BE6868, 
        0x00FDFBFB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FBFBFB, 0x00313131, 0x00000000, 0x00020202, 0x00232323, 0x005B5B5B, 0x00919191, 0x00CFCFCF, 0x00F9F9F9, 0x00FFFFFF, 0x00FFFFFF, 0x00DDDDDD, 0x00000000, 0x00000000, 0x00424242, 
        0x00555555, 0x00555555, 0x00555555, 0x00565656, 0x009D9D9D, 0x00FFFFFF, 0x00D8D8D8, 0x00000000, 0x00000000, 0x00A7A7A7, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00F6F6F6, 0x00F5F5F5, 0x00F5F5F5, 0x00F7F7F7, 0x00FFFFFF, 0x00FFFFFF, 0x003B3B3B, 
        0x00000000, 0x00454545, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F8F8, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00FDFDFD, 0x00FFFFFF, 0x00F5F5F5, 0x00131313, 0x00000000, 0x00343434, 0x00555555, 0x00555555, 0x00555555, 0x00555555, 0x00838383, 
        0x00FCFCFC, 0x00FFFFFF, 0x00747474, 0x00000000, 0x00252525, 0x00D4D4D4, 0x00D4D4D4, 0x00D3D3D3, 0x00B0B0B0, 0x00141414, 0x00000000, 0x008B8B8B, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FCF8F8, 0x00B65656, 0x009F1F1F, 0x009F1F1F, 0x00B14848, 0x00F9F1F1, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FBF6F6, 0x00B75656, 0x009F1F1F, 0x009F1F1F, 0x00AD4040, 0x00F8F0F0, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E4E4E4, 0x00696969, 0x001E1E1E, 0x00010101, 0x00000000, 0x00000000, 0x00000000, 0x002C2C2C, 0x00C6C6C6, 0x00FFFFFF, 0x00DDDDDD, 0x00000000, 0x00000000, 0x000B0B0B, 
        0x000E0E0E, 0x000E0E0E, 0x000E0E0E, 0x000F0F0F, 0x00585858, 0x00FFFFFF, 0x00C7C7C7, 0x00000000, 0x00000000, 0x00BDBDBD, 0x00FFFFFF, 0x00FFFFFF, 0x00A3A3A3, 0x00161616, 0x00131313, 0x00131313, 0x001C1C1C, 0x00BEBEBE, 0x00FFFFFF, 0x002B2B2B, 
        0x00000000, 0x005C5C5C, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00282828, 0x00131313, 0x00131313, 0x00141414, 0x006A6A6A, 0x00FFFFFF, 0x00F5F5F5, 0x00131313, 0x00000000, 0x00090909, 0x000E0E0E, 0x000E0E0E, 0x000E0E0E, 0x000E0E0E, 0x00363636, 
        0x00F5F5F5, 0x00FFFFFF, 0x00747474, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00010101, 0x005F5F5F, 0x00F9F9F9, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFE, 0x00CC8989, 0x009F1F1F, 0x009F1F1F, 0x00A32828, 0x00EED6D6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CA8383, 0x009F1F1F, 0x009F1F1F, 0x00A42A2A, 0x00EBD0D0, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F4F4F4, 0x00D4D4D4, 0x00A0A0A0, 0x00555555, 0x00050505, 0x00000000, 0x00282828, 0x00F9F9F9, 0x00DDDDDD, 0x00000000, 0x00000000, 0x00B7B7B7, 
        0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EBEBEB, 0x00FAFAFA, 0x00FFFFFF, 0x00DCDCDC, 0x00000000, 0x00000000, 0x009F9F9F, 0x00FFFFFF, 0x00FFFFFF, 0x00C5C5C5, 0x004B4B4B, 0x00464646, 0x000E0E0E, 0x00000000, 0x00999999, 0x00FFFFFF, 0x003F3F3F, 
        0x00000000, 0x003D3D3D, 0x00FFFFFF, 0x00FFFFFF, 0x00F4F4F4, 0x00626262, 0x00464646, 0x002A2A2A, 0x00000000, 0x00363636, 0x00FFFFFF, 0x00F5F5F5, 0x00131313, 0x00000000, 0x008F8F8F, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00F6F6F6, 
        0x00FFFFFF, 0x00FFFFFF, 0x00747474, 0x00000000, 0x00141414, 0x00757575, 0x00757575, 0x00737373, 0x00343434, 0x00000000, 0x000B0B0B, 0x00D3D3D3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00E1BABA, 0x00A12323, 0x009F1F1F, 0x00A02121, 0x00DAA9A9, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DFB4B4, 0x009F1F1F, 0x009F1F1F, 0x00A02121, 0x00DAA8A8, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F7F7F7, 0x00444444, 0x004A4A4A, 0x00ECECEC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x009B9B9B, 0x00000000, 0x000F0F0F, 0x00E9E9E9, 0x00DDDDDD, 0x00000000, 0x00000000, 0x00C7C7C7, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FAFAFA, 0x002B2B2B, 0x00000000, 0x00383838, 0x00F4F4F4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00DCDCDC, 0x000F0F0F, 0x00000000, 0x00999999, 0x00FFFFFF, 0x00878787, 
        0x00000000, 0x00060606, 0x00C4C4C4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FCFCFC, 0x00535353, 0x00000000, 0x00363636, 0x00FFFFFF, 0x00F5F5F5, 0x00131313, 0x00000000, 0x009C9C9C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00747474, 0x00000000, 0x002C2C2C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E5E5E5, 0x00000000, 0x00000000, 0x00969696, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00B75656, 0x009F1F1F, 0x009F1F1F, 0x00C37373, 0x00FEFCFC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B34F4F, 0x009F1F1F, 0x009F1F1F, 0x00C47676, 0x00FEFDFD, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F0F0F0, 0x00121212, 0x00000000, 0x003F3F3F, 0x00C2C2C2, 0x00DCDCDC, 0x00C8C8C8, 0x004A4A4A, 0x00000000, 0x002F2F2F, 0x00FBFBFB, 0x00DDDDDD, 0x00000000, 0x00000000, 0x00696969, 
        0x00868686, 0x00868686, 0x00868686, 0x00868686, 0x00898989, 0x00D7D7D7, 0x00FFFFFF, 0x00ABABAB, 0x00050505, 0x00000000, 0x00404040, 0x00ADADAD, 0x00C8C8C8, 0x00A2A2A2, 0x00272727, 0x00000000, 0x00000000, 0x00999999, 0x00FFFFFF, 0x00EBEBEB, 
        0x00252525, 0x00000000, 0x00171717, 0x008D8D8D, 0x00C6C6C6, 0x00B9B9B9, 0x005A5A5A, 0x00010101, 0x00000000, 0x00363636, 0x00FFFFFF, 0x00F5F5F5, 0x00131313, 0x00000000, 0x00525252, 0x00868686, 0x00868686, 0x00868686, 0x00868686, 0x00878787, 
        0x00C3C3C3, 0x00FFFFFF, 0x00747474, 0x00000000, 0x002C2C2C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x000B0B0B, 0x00000000, 0x007F7F7F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00D19393, 0x00A22626, 0x00B34E4E, 0x00F9F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CD8B8B, 0x00A22525, 0x00B65555, 0x00FAF4F4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00191919, 0x00000000, 0x00020202, 0x00060606, 0x00020202, 0x00000000, 0x001D1D1D, 0x00CACACA, 0x00FFFFFF, 0x00ECECEC, 0x000B0B0B, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00696969, 0x00FFFFFF, 0x00FEFEFE, 0x009E9E9E, 0x00101010, 0x00000000, 0x00000000, 0x00010101, 0x00000000, 0x00171717, 0x005C5C5C, 0x00000000, 0x009A9A9A, 0x00FFFFFF, 0x00FFFFFF, 
        0x00D8D8D8, 0x00343434, 0x00010101, 0x00000000, 0x00010101, 0x00000000, 0x00040404, 0x005F5F5F, 0x00101010, 0x00373737, 0x00FFFFFF, 0x00FAFAFA, 0x002B2B2B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x003C3C3C, 0x00FDFDFD, 0x007C7C7C, 0x00000000, 0x00343434, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00373737, 0x00000000, 0x00585858, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFE, 0x00F4E5E5, 0x00FCF8F8, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F3E3E3, 0x00FDF9F9, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EFEFEF, 0x00A6A6A6, 0x00767676, 0x006A6A6A, 0x00777777, 0x00A6A6A6, 0x00F0F0F0, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D0D0D0, 0x00ACACAC, 0x00ABABAB, 
        0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00B1B1B1, 0x00ECECEC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E7E7E7, 0x009C9C9C, 0x00727272, 0x006D6D6D, 0x00919191, 0x00E7E7E7, 0x00ECECEC, 0x007B7B7B, 0x00DDDDDD, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00F9F9F9, 0x00B7B7B7, 0x007D7D7D, 0x006A6A6A, 0x007E7E7E, 0x00C4C4C4, 0x00FEFEFE, 0x009D9D9D, 0x00A8A8A8, 0x00FFFFFF, 0x00FFFFFF, 0x00DEDEDE, 0x00AEAEAE, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00ABABAB, 0x00AEAEAE, 
        0x00E0E0E0, 0x00FFFFFF, 0x00E8E8E8, 0x00969696, 0x00CDCDCD, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D5D5D5, 0x00919191, 0x00D8D8D8, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00EBEBEB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EBEBEB, 0x00000000, 0x00000000,
  0x10000000, 0x00000000, 0x00CBCBCB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CBCBCB, 0x00000000, 0x10000000,
  0x58000000, 0x00000000, 0x00383838, 0x00D2D2D2, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 
        0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 
        0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 
        0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 
        0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00D2D2D2, 0x00383838, 0x00000000, 0x58000000,
  0xD8000000, 0x19000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x19000000, 0xD8000000,
  0xFF000000, 0xD5000000, 0x50000000, 0x0B000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0B000000, 0x4F000000, 0xD5000000, 0xFF000000
#endif
};

GUI_CONST_STORAGE GUI_BITMAP bmSeggerLogo_100x50 = {
  100, // xSize
  50, // ySize
  400, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acSeggerLogo_100x50,  // Pointer to picture data
  NULL,  // Pointer to palette
#if (GUI_USE_ARGB == 1)
  GUI_DRAW_BMPM8888I
#else
  GUI_DRAW_BMP8888
#endif
};

/*********************************************************************
*
*       CSV-file in binary format containing the text resources
*/
static const U8 _acCSV[277UL + 1] = {
  0x22, 0x43, 0x6F, 0x6C, 0x6F, 0x72, 0x73, 0x2E, 0x2E, 0x2E, 0x22, 0x2C, 0x22, 0x46, 0x61, 0x72, 0x62, 0x65, 0x6E, 0x2E, 0x2E, 0x2E, 0x22, 0x2C, 0x22, 0x43, 0x6F, 0x6C, 0x6F, 0x72, 0x69, 0x2E, 0x2E, 0x22, 0x0D, 0x0A, 0x22, 0x48, 0x65, 0x6C,
  0x70, 0x2E, 0x2E, 0x2E, 0x22, 0x2C, 0x22, 0x48, 0x69, 0x6C, 0x66, 0x65, 0x2E, 0x2E, 0x2E, 0x22, 0x2C, 0x22, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6E, 0x7A, 0x61, 0x2E, 0x2E, 0x2E, 0x22, 0x0D, 0x0A, 0x22, 0x45, 0x78, 0x69, 0x74, 0x22,
  0x2C, 0x22, 0x42, 0x65, 0x65, 0x6E, 0x64, 0x65, 0x6E, 0x22, 0x2C, 0x22, 0x46, 0x69, 0x6E, 0x69, 0x72, 0x65, 0x22, 0x0D, 0x0A, 0x22, 0x43, 0x6F, 0x6E, 0x6E, 0x65, 0x63, 0x74, 0x22, 0x2C, 0x22, 0x56, 0x65, 0x72, 0x62, 0x69, 0x6E, 0x64, 0x65,
  0x6E, 0x22, 0x2C, 0x22, 0x43, 0x6F, 0x6E, 0x65, 0x74, 0x74, 0x65, 0x72, 0x65, 0x22, 0x0D, 0x0A, 0x22, 0x45, 0x6E, 0x67, 0x6C, 0x69, 0x73, 0x68, 0x22, 0x2C, 0x22, 0x45, 0x6E, 0x67, 0x6C, 0x69, 0x73, 0x63, 0x68, 0x22, 0x2C, 0x22, 0x49, 0x6E,
  0x67, 0x6C, 0x65, 0x73, 0x65, 0x22, 0x0D, 0x0A, 0x22, 0x47, 0x65, 0x72, 0x6D, 0x61, 0x6E, 0x22, 0x2C, 0x22, 0x44, 0x65, 0x75, 0x74, 0x73, 0x63, 0x68, 0x22, 0x2C, 0x22, 0x54, 0x65, 0x64, 0x65, 0x73, 0x63, 0x6F, 0x22, 0x0D, 0x0A, 0x22, 0x49,
  0x74, 0x61, 0x6C, 0x69, 0x61, 0x6E, 0x22, 0x2C, 0x22, 0x49, 0x74, 0x61, 0x6C, 0x69, 0x65, 0x6E, 0x69, 0x73, 0x63, 0x68, 0x22, 0x2C, 0x22, 0x49, 0x74, 0x61, 0x6C, 0x69, 0x61, 0x6E, 0x6F, 0x22, 0x0D, 0x0A, 0x22, 0x53, 0x65, 0x74, 0x74, 0x69,
  0x6E, 0x67, 0x73, 0x22, 0x2C, 0x22, 0x45, 0x69, 0x6E, 0x73, 0x74, 0x65, 0x6C, 0x6C, 0x75, 0x6E, 0x67, 0x65, 0x6E, 0x22, 0x2C, 0x22, 0x49, 0x6D, 0x70, 0x6F, 0x73, 0x74, 0x61, 0x7A, 0x69, 0x6F, 0x6E, 0x65, 0x22, 0x0D, 0x0A, 0x00
};

/*********************************************************************
*
*       _aDialogCreate
*/
static const GUI_WIDGET_CREATE_INFO _aDialogCreate[] = {
  { FRAMEWIN_CreateIndirect, "", ID_FRAMEWIN_0,   0,  0, 320, 120, 0, 0x64,   0 },
  { BUTTON_CreateIndirect,   "", ID_BUTTON_0,    15, 10,  80,  20, 0, 0x0,    0 },
  { BUTTON_CreateIndirect,   "", ID_BUTTON_1,    15, 40,  80,  20, 0, 0x0,    0 },
  { BUTTON_CreateIndirect,   "", ID_BUTTON_2,    15, 70,  80,  20, 0, 0x0,    0 },
  { CHECKBOX_CreateIndirect, "", ID_CHECKBOX_0, 125, 10,  80,  20, 0, 0x0,    0 },
  { RADIO_CreateIndirect,    "", ID_RADIO_0,    215, 10,  80,  80, 0, 0x1e03, 0 },
};

/*********************************************************************
*
*       Static code
*
**********************************************************************
*/
/*********************************************************************
*
*       _SetLanguage
*/
static void _SetLanguage(int Language) {
  WM_MESSAGE Message = {0};
  
  //
  // First set up new language in language module
  //
  GUI_LANG_SetLang(Language);
  //
  // Broadcast a message to all windows
  //
  Message.MsgId = APP_SETLANG;
  WM_BroadcastMessage(&Message);
}

/*********************************************************************
*
*       _GetData
*/
static int _GetData(void * pVoid, const U8 ** ppData, unsigned NumBytes, U32 Off) {
  U8 * pData;
  U8 * pCSV;

  pData = (U8 *)*ppData; // Pointer to be used for getting data
  pCSV  = (U8 *)pVoid;   // Use custom void pointer for getting a pointer to the file data
  memcpy(pData, pCSV + Off, NumBytes);
  return NumBytes;
}

/*********************************************************************
*
*       _cbDialog
*/
static void _cbDialog(WM_MESSAGE * pMsg) {
  WM_HWIN hItem;
  int     Id, NCode, Language;
  char acBuffer[MAX_TEXT_LEN];

  switch (pMsg->MsgId) {
  //
  // Init dialog and set language (APP_SETLANG)
  //
  case WM_INIT_DIALOG:
    Language = GUI_LANG_GetLang();
    hItem = WM_GetDialogItem(pMsg->hWin, ID_RADIO_0);    
    RADIO_SetValue(hItem, Language);
  //
  // React on APP_SETLANG - message
  //
  case APP_SETLANG:
    //
    // Initialization of 'Framewin'
    //
    hItem = pMsg->hWin;
    GUI_LANG_GetTextBuffered(APP_TI_SETTINGS, acBuffer, sizeof(acBuffer));
    FRAMEWIN_SetText(hItem, acBuffer);
    //
    // Initialization of 'Button'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_0);
    GUI_LANG_GetTextBuffered(APP_TI_COLORS, acBuffer, sizeof(acBuffer));
    BUTTON_SetText(hItem, acBuffer);
    //
    // Initialization of 'Button'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_1);
    GUI_LANG_GetTextBuffered(APP_TI_HELP, acBuffer, sizeof(acBuffer));
    BUTTON_SetText(hItem, acBuffer);
    //
    // Initialization of 'Button'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_BUTTON_2);
    GUI_LANG_GetTextBuffered(APP_TI_EXIT, acBuffer, sizeof(acBuffer));
    BUTTON_SetText(hItem, acBuffer);
    //
    // Initialization of 'Checkbox'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_CHECKBOX_0);
    GUI_LANG_GetTextBuffered(APP_TI_CONNECT, acBuffer, sizeof(acBuffer));
    CHECKBOX_SetText(hItem, acBuffer);
    //
    // Initialization of 'Radio'
    //
    hItem = WM_GetDialogItem(pMsg->hWin, ID_RADIO_0);
    GUI_LANG_GetTextBuffered(APP_TI_ENGLISH, acBuffer, sizeof(acBuffer));
    RADIO_SetText(hItem, acBuffer, 0);
    GUI_LANG_GetTextBuffered(APP_TI_GERMAN, acBuffer, sizeof(acBuffer));
    RADIO_SetText(hItem, acBuffer, 1);
    GUI_LANG_GetTextBuffered(APP_TI_ITALIAN, acBuffer, sizeof(acBuffer));
    RADIO_SetText(hItem, acBuffer, 2);
    break;
  //
  // React on user input
  //
  case WM_NOTIFY_PARENT:
    Id    = WM_GetId(pMsg->hWinSrc);
    NCode = pMsg->Data.v;
    switch(Id) {
    case ID_RADIO_0: // Notifications sent by 'Radio'
      switch(NCode) {
      case WM_NOTIFICATION_VALUE_CHANGED:
        //
        // Get language index from widget...
        //
        Language = RADIO_GetValue(pMsg->hWinSrc);
        //
        // ...and use it in the application
        //
        _SetLanguage(Language);
        break;
      }
      break;
    case ID_BUTTON_2:
      switch(NCode) {
      case WM_NOTIFICATION_RELEASED:
        GUI_EndDialog(pMsg->hWin, 0);
        _IsClosed = 1; 
        break;
      }  
    }
    break;
  default:
    WM_DefaultProc(pMsg);
    break;
  }
}
/*********************************************************************
*
*       _cbBkWindow
*/
static void _cbBkWindow(WM_MESSAGE * pMsg) {
  int xPos;
  GUI_RECT Rect = {0, 180, 320, 240};

  switch(pMsg->MsgId) {
  case WM_PAINT:
    GUI_SetBkColor(GUI_BLUE);
    GUI_Clear();
    xPos = (LCD_GetXSize() - 100 ) / 2;
    GUI_DrawBitmap(&bmSeggerLogo_100x50, xPos, 5);
    GUI_SetColor(GUI_WHITE);
    GUI_SetFont(&GUI_Font20B_1);
    GUI_DispStringInRectWrap("WIDGET_MultiLanguageCSV", &Rect, GUI_TA_HCENTER | GUI_TA_VCENTER, GUI_WRAPMODE_WORD);
    break; 
  }
}
/*********************************************************************
*
*       _CreateFramewin
*/
static WM_HWIN _CreateFramewin(void) {
  WM_HWIN hWin;

  hWin = GUI_CreateDialogBox(_aDialogCreate, GUI_COUNTOF(_aDialogCreate), _cbDialog, WM_HBKWIN, 0, 60);
  _IsClosed = 0;
  return hWin;
}

/*********************************************************************
*
*       _LanguageDemo
*/
static void _LanguageDemo(void) {
  //
  // Set access to CSV file
  //
  GUI_LANG_LoadCSVEx(_GetData, (void *)_acCSV);
  //
  // Create a dialog...
  //
  _CreateFramewin();
  //
  // ...and set the right language
  //
}

/*********************************************************************
*
*       Public code
*
**********************************************************************
*/
/*********************************************************************
*
*       MainTask
*/
void MainTask(void) {
#if GUI_SUPPORT_MEMDEV
  //
  // Use memory devices on all windows to avoid flicker
  //
  WM_SetCreateFlags(WM_CF_MEMDEV);
#endif
  GUI_Init();
  //
  // Check if recommended memory for the sample is available
  //
  if (GUI_ALLOC_GetNumFreeBytes() < RECOMMENDED_MEMORY) {
    GUI_ErrorOut("Not enough memory available."); 
    return;
  }
  //
  //  Set start language
  //
  GUI_LANG_SetLang(LANG_ENGLISH);
  //
  // Set background callback
  //
  WM_SetCallback(WM_HBKWIN, _cbBkWindow);
  _LanguageDemo();
  while (1) {
    if (_IsClosed) {
      GUI_Delay(1000);
      _CreateFramewin();
    }
    GUI_Delay(100);
  }
}

/*************************** End of file ****************************/
