/*********************************************************************
*                SEGGER Microcontroller GmbH                         *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2018  SEGGER Microcontroller GmbH                *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.48 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software  has been licensed to  Cypress Semiconductor Corporation,
whose registered  office is situated  at 198 Champion Ct. San Jose, CA 
95134 USA  solely for the  purposes of creating  libraries for Cypress
PSoC3 and  PSoC5 processor-based devices,  sublicensed and distributed
under  the  terms  and  conditions  of  the  Cypress  End User License
Agreement.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information
Licensor:                 SEGGER Microcontroller Systems LLC
Licensed to:              Cypress Semiconductor Corp, 198 Champion Ct., San Jose, CA 95134, USA
Licensed SEGGER software: emWin
License number:           GUI-00319
License model:            Services and License Agreement, signed June 10th, 2009
Licensed platform:        Any Cypress platform (Initial targets are: PSoC3, PSoC5)
----------------------------------------------------------------------
Support and Update Agreement (SUA)
SUA period:               2009-06-12 - 2022-07-27
Contact to extend SUA:    sales@segger.com
----------------------------------------------------------------------
File        : WIDGET_Iconview.c
Purpose     : Shows usage of ICONVIEW widget
Requirements: WindowManager - (x)
              MemoryDevices - ( )
              AntiAliasing  - ( )
              VNC-Server    - ( )
              PNG-Library   - ( )
              TrueTypeFonts - ( )
----------------------------------------------------------------------
*/

/*********************************************************************
*
*       Includes
*
**********************************************************************
*/
/*********************************************************************
*
*       System
*/
#include <stddef.h>

/*********************************************************************
*
*       Application
*/
#include "ICONVIEW.h"
#include "TEXT.h"

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/
#define MSG_MOVE (WM_USER + 0)

//
// Recommended memory to run the sample with adequate performance
//
#define RECOMMENDED_MEMORY (1024L * 30)

/*********************************************************************
*
*       Types
*
**********************************************************************
*/
typedef struct {
  const GUI_BITMAP * pBitmap;
  const char       * pText;
  const char       * pExplanation;
} BITMAP_ITEM;

/*********************************************************************
*
*       Static data
*
**********************************************************************
*/
/*********************************************************************
*
*       _bmBrowser
*
* Function description
*   Icon bitmap with alpha channel
*/
static GUI_CONST_STORAGE unsigned long _acBrowser[] = {
#if (GUI_USE_ARGB == 1)
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x05001093, 0x31000D8C, 0x64000B88, 0x8F000888, 
        0xB4000B8A, 0xD1001291, 0xDB001693, 0xDB001694, 0xD5001692, 0xBF00118B, 0x9D000F86, 0x76001282, 0x4900147A, 0x1700135D, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x25000C8D, 0x74000689, 0xD1001090, 0xFA10239C, 0xFF2B46B1, 0xFF4866C2, 
        0xFF6181D0, 0xFF789ADE, 0xFF81A4E3, 0xFF81A5E2, 0xFF7B9EE0, 0xFF6387D4, 0xFF4B6FC7, 0xFF2F53B8, 0xFD1535A5, 0xE6032096, 0x99001380, 0x4600146E, 0x0A000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x32000A8A, 0xA700038A, 0xF10A1697, 0xFF445EBD, 0xFF7FA3E2, 0xFFA8CEF7, 0xFFCCE7FF, 0xFFE8F9FF, 
        0xFFF4FFFF, 0xFFF7FFFF, 0xFFF9FFFF, 0xFFFAFFFF, 0xFFF5FFFF, 0xFFF0FEFF, 0xFFE5F8FF, 0xFFC9E6FF, 0xFFA3CFFA, 0xFF82ADEA, 0xFF5278CC, 0xFB1333A3, 0xCC00188B, 0x66001873, 0x10000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x07000991, 0x80000289, 0xF2060F92, 0xFF4A63C0, 0xFF8DB7EE, 0xFFC0E6FF, 0xFFE6F8FF, 0xFFF6FDFF, 0xFFFCFFFB, 0xFFFFFFFE, 
        0xFFF8FBF4, 0xFFF6FAF3, 0xFFFCFDFB, 0xFFFFFEFF, 0xFFFDFEFD, 0xFFFFFEFD, 0xFFFFFFFD, 0xFFFCFEFB, 0xFFF1F9FD, 0xFFDDF2FF, 0xFFB5E2FF, 0xFF8DBFF5, 0xFF5C82D2, 0xFE1333A5, 0xBC001781, 0x3A001249, 0x0A000000, 0x01000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x38000689, 0xC300028A, 0xFF3243AF, 0xFF81A9E9, 0xFFB6E2FF, 0xFFD8EFFC, 0xFFF3F9FA, 0xFFFFFFFF, 0xFFF3F7F3, 0xFFF3F8F4, 0xFFEEF5EE, 
        0xFFEFF5EF, 0xFFF7FAF9, 0xFFF4F8F6, 0xFFFCFEFF, 0xFFFBFDFF, 0xFFF5FAF9, 0xFFF2F8F4, 0xFFEDF4EC, 0xFFEEF5EC, 0xFFF4F7EF, 0xFFEEF5F4, 0xFFCDE9FE, 0xFFA8DBFF, 0xFF83B8F3, 0xFF486DC3, 0xEA032494, 0x7A00176B, 0x14000000, 0x04000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4B000389, 0xEB070B90, 0xFF5C76CC, 0xFF9ED3FF, 0xFFB9E2FD, 0xFFE3F0EC, 0xFFE9F2E4, 0xFFEAF3EC, 0xFFE9F2EB, 0xFFEBF3ED, 0xFFFAFDFF, 0xFFF3F8F6, 
        0xFFFCFEFF, 0xFFFCFEFF, 0xFFF4F8F6, 0xFFF2F9F5, 0xFFE8F2E9, 0xFFE4EFE4, 0xFFE4EFE4, 0xFFE4EFE4, 0xFFE4EFE4, 0xFFE3EFE3, 0xFFE5F0E3, 0xFFEBF3E5, 0xFFE2EFF0, 0xFFA8D8FD, 0xFF8FCEFF, 0xFF739DE0, 0xFE1336A5, 0x9D001870, 0x1E000000, 0x05000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x47000288, 0xF60A0E91, 0xFF6D8CD9, 0xFF9AD7FF, 0xFFB3DAF1, 0xFFE0EDDD, 0xFFDEEBDB, 0xFFDCEADC, 0xFFDBEADB, 0xFFDAE9DA, 0xFFE0ECE1, 0xFFE9F2EC, 0xFFEDF5F0, 
        0xFFEFF6F1, 0xFFF3F8F5, 0xFFE7F1E8, 0xFFDCEADC, 0xFFDBEADB, 0xFFDCEADC, 0xFFDCEADC, 0xFFDCEBDC, 0xFFDCEBDC, 0xFFDCEBDC, 0xFFDCEADC, 0xFFDCEADC, 0xFFDFEBDB, 0xFFE2EEDF, 0xFFA5D2F0, 0xFF7FC7FD, 0xFF80AEEF, 0xFF1A3FAA, 0xA300186C, 0x21000000, 
        0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4B000188, 0xF4080C90, 0xFF7EA1E8, 0xFF89CCF8, 0xFFAED5D9, 0xFFD9E8D3, 0xFFD5E6D4, 0xFFD4E6D4, 0xFFD4E6D4, 0xFFD4E6D4, 0xFFD4E6D4, 0xFFD1E4D0, 0xFFD4E6D3, 0xFFD5E6D5, 
        0xFFD4E6D4, 0xFFE5F0E6, 0xFFDAEADA, 0xFFD3E5D2, 0xFFD4E6D4, 0xFFD4E6D4, 0xFFD4E6D4, 0xFFD4E6D4, 0xFFD4E6D4, 0xFFD4E6D4, 0xFFD4E6D4, 0xFFD4E6D4, 0xFFD4E6D4, 0xFFD5E6D3, 0xFFDBE9D4, 0xFF9DC9BF, 0xFF63B2D5, 0xFF8BBCFC, 0xFF1B41AD, 0xA9001970, 
        0x22000000, 0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x36000287, 0xED070A8E, 0xFF6F8DDC, 0xFF77C1E7, 0xFF90C2B6, 0xFFD1E3C8, 0xFFCCE1CB, 0xFFCBE1CB, 0xFFCAE0C9, 0xFFC9DFC7, 0xFFCFE3D0, 0xFFE3F0EC, 0xFFDAEADD, 0xFFEFF6F6, 0xFFF5FAFA, 
        0xFFF8FBFA, 0xFFF1F8F3, 0xFFCEE2CE, 0xFFCBE1CB, 0xFFCCE1CC, 0xFFCCE1CC, 0xFFCCE1CC, 0xFFCCE1CC, 0xFFCCE1CC, 0xFFCCE1CC, 0xFFCCE1CC, 0xFFCCE1CC, 0xFFCCE1CC, 0xFFCBE1CC, 0xFFCDE1CC, 0xFFD4E6CC, 0xFF7DB48D, 0xFF4AA2AA, 0xFF84B3F4, 0xFF163CA9, 
        0x9500175E, 0x1F000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x0800038E, 0xC9000087, 0xFF5F77D0, 0xFF81C9F4, 0xFF69AB8F, 0xFFC4DCBB, 0xFFC4DEC4, 0xFFC2DCC1, 0xFFC1DBC0, 0xFFCCE2D1, 0xFFD9EAE5, 0xFFE1EFF0, 0xFFF0F8FF, 0xFFF2F9FF, 0xFFF5FAFF, 0xFFF8FBFF, 
        0xFFFAFDFF, 0xFFFBFDFE, 0xFFD5E7D7, 0xFFC1DBC0, 0xFFC3DDC3, 0xFFC3DDC3, 0xFFC3DDC3, 0xFFC3DDC3, 0xFFC3DDC3, 0xFFC3DDC3, 0xFFC3DDC3, 0xFFC3DCC2, 0xFFC3DDC3, 0xFFC3DDC3, 0xFFC3DDC3, 0xFFC4DEC5, 0xFFCAE0C3, 0xFF529957, 0xFF54A9B6, 0xFF7EAAEF, 
        0xF5082C98, 0x68000E33, 0x16000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x82000085, 0xFF3541AF, 0xFF90CCFF, 0xFF41958A, 0xFFABCCA4, 0xFFBED8BE, 0xFFB9D4B9, 0xFFBED9C2, 0xFFD0E4E1, 0xFFE2F1FD, 0xFFE8F4FF, 0xFFEBF5FF, 0xFFEBF5FF, 0xFFEEF7FF, 0xFFF1F8FF, 0xFFF4F9FF, 
        0xFFF5FBFF, 0xFFF7FBFE, 0xFFDAE9E0, 0xFFB9D5BA, 0xFFBAD5BB, 0xFFBAD5BB, 0xFFBBD6BC, 0xFFBBD6BC, 0xFFBBD6BC, 0xFFBBD6BC, 0xFFBAD5BA, 0xFFBCD7BE, 0xFFBBD6BC, 0xFFBBD6BC, 0xFFBBD6BC, 0xFFBBD6BC, 0xFFC0D9C2, 0xFFB0CFAC, 0xFF1A7633, 0xFF74BBE0, 
        0xFF547ED5, 0xDA001C7E, 0x3D000000, 0x0B000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x2F000088, 0xF4080A8E, 0xFF80ABF5, 0xFF4299A7, 0xFF77A779, 0xFFBAD3BB, 0xFFBAD4C7, 0xFFCAE1E4, 0xFFD6EAF8, 0xFFDEEFFF, 0xFFDFF0FF, 0xFFE1F0FF, 0xFFE4F2FF, 0xFFE7F3FF, 0xFFEAF5FF, 0xFFECF6FF, 0xFFEFF7FF, 
        0xFFF1F9FF, 0xFFE5F0F2, 0xFFB5D0BA, 0xFFB0CDB4, 0xFFB7D2BD, 0xFFB5D0B9, 0xFFB1CDB5, 0xFFB1CDB5, 0xFFB1CDB5, 0xFFB2CEB5, 0xFFC4DDD8, 0xFFBED8CC, 0xFFB1CEB4, 0xFFB3CFB7, 0xFFB3CFB7, 0xFFB3CFB7, 0xFFB3CEB7, 0xFFBCD4C0, 0xFF79A878, 0xFF197557, 
        0xFF85BEFA, 0xFF1D48B0, 0xA500175B, 0x27000000, 0x04000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0xAA000084, 0xFF5263C5, 0xFF77BEEA, 0xFF065521, 0xFF68976C, 0xFFBCD5CA, 0xFFD0E8FC, 0xFFD4EBFF, 0xFFD5EBFF, 0xFFD7EBFF, 0xFFDAEDFF, 0xFFDDEEFF, 0xFFE0F0FF, 0xFFE2F1FF, 0xFFE5F2FF, 0xFFE7F3FF, 0xFFEAF5FF, 
        0xFFEFF9FF, 0xFFC5DAD3, 0xFFA6C3AC, 0xFFBFD6CC, 0xFFE2F0F7, 0xFFD9EAEF, 0xFFB4CEBF, 0xFFB3CDBD, 0xFFB3CEBE, 0xFFC8DFE2, 0xFFC3DCDE, 0xFFACC8B5, 0xFFABC7B1, 0xFFABC7B2, 0xFFABC7B2, 0xFFABC7B2, 0xFFADC8B3, 0xFFB7D0BC, 0xFF73A07E, 0xFF024E0D, 
        0xFF5BA6BC, 0xFF729DE9, 0xEE00228C, 0x5600030C, 0x13000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x23000087, 0xF50C0F92, 0xFF89B6FA, 0xFF358591, 0xFF196558, 0xFF0C5633, 0xFF92C3E5, 0xFFCFE9FF, 0xFFD0E8FF, 0xFFCFE8FF, 0xFFD2E9FF, 0xFFD5EAFF, 0xFFD7ECFF, 0xFFDAEDFF, 0xFFDDEEFF, 0xFFDFF0FF, 0xFFE4F3FF, 0xFFE4F2FF, 
        0xFFCADCDE, 0xFFA6C1B1, 0xFFA2BDAB, 0xFFAFC8BC, 0xFFB2CBC1, 0xFFB3CCC3, 0xFFB0CAC0, 0xFFCDE2EC, 0xFFCDE2ED, 0xFFBDD5D8, 0xFFAFCAC3, 0xFFA2BDAC, 0xFFA3BEAC, 0xFFA3BDAD, 0xFFA3BEAD, 0xFFA8C1B1, 0xFFA8C1B1, 0xFF649175, 0xFF074D1F, 0xFF00420D, 
        0xFF1B6A60, 0xFF8FC8FF, 0xFF2450B5, 0x9F001245, 0x2B000000, 0x04000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x75000082, 0xFF4D5DC1, 0xFF76BBEC, 0xFF1A6773, 0xFF2F7A98, 0xFF3380A0, 0xFF60B3FF, 0xFF89C5FF, 0xFFBDDFFF, 0xFFCDE6FF, 0xFFCEE7FF, 0xFFCFE8FF, 0xFFD1E9FF, 0xFFD4EAFF, 0xFFD6EBFF, 0xFFDCF0FF, 0xFFD3E7F3, 0xFFAFC7C3, 
        0xFF97B2A5, 0xFF9AB4A7, 0xFF9BB5A9, 0xFF99B4A7, 0xFF98B3A6, 0xFF98B3A5, 0xFF9BB5A9, 0xFF9EB8AE, 0xFF9DB7AD, 0xFF99B3A5, 0xFF99B3A5, 0xFF9BB5A9, 0xFF9BB5A9, 0xFF9EB8AC, 0xFFA2BBAF, 0xFF8EAB9E, 0xFF3E7058, 0xFF003D1C, 0xFF00401F, 0xFF004120, 
        0xFF004124, 0xFF6CAFD8, 0xFF6D99E3, 0xDC001F77, 0x4A000000, 0x0E000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x0700008B, 0xD5020289, 0xFF80A4ED, 0xFF397E94, 0xFF287293, 0xFF246A82, 0xFF3D88B9, 0xFF62B6FF, 0xFF60B1FF, 0xFF6FB8FF, 0xFF94CBFF, 0xFFBCDEFF, 0xFFCBE6FF, 0xFFCEE7FF, 0xFFCEE7FF, 0xFFD0E8FF, 0xFFB8D1DD, 0xFF98B0AC, 0xFF8FA8A0, 
        0xFF92ABA4, 0xFF92ABA5, 0xFF92ABA5, 0xFF92ABA5, 0xFF92ABA5, 0xFF92ABA5, 0xFF92ABA4, 0xFF92AAA3, 0xFF92AAA3, 0xFF93ABA5, 0xFF94ACA6, 0xFF99B0AA, 0xFF9CB3AF, 0xFF85A19A, 0xFF456E64, 0xFF0E4334, 0xFF003424, 0xFF003929, 0xFF003A2A, 0xFF003A2A, 
        0xFF00321D, 0xFF2E7081, 0xFF8EC1FD, 0xFC0B37A3, 0x80000C29, 0x21000000, 0x01000000,
  0x00FFFFFF, 0x00FFFFFF, 0x32000085, 0xFD151899, 0xFF82B8F3, 0xFF0D4851, 0xFF3279A9, 0xFF5AB0FC, 0xFF53A7F3, 0xFF5DB0FF, 0xFF61B2FF, 0xFF64B3FF, 0xFF66B4FF, 0xFF77BCFF, 0xFF91CAFF, 0xFFAFD8FF, 0xFFC4E3FF, 0xFFC8E2FB, 0xFF96ADAE, 0xFF8EA5A3, 0xFF90A6A5, 
        0xFF8EA5A4, 0xFF8EA5A4, 0xFF8DA5A3, 0xFF8DA5A3, 0xFF8EA5A4, 0xFF8EA5A4, 0xFF8FA6A5, 0xFF91A8A7, 0xFF93A9A8, 0xFF8EA5A5, 0xFF889F9F, 0xFF668483, 0xFF3C676B, 0xFF184D54, 0xFF002A26, 0xFF00312E, 0xFF003331, 0xFF003331, 0xFF003331, 0xFF003331, 
        0xFF002F2B, 0xFF0F4751, 0xFF89C3FA, 0xFF2B59BA, 0xB300144D, 0x39000000, 0x07000000,
  0x00FFFFFF, 0x00FFFFFF, 0x6400007F, 0xFF343FB0, 0xFF75B5EB, 0xFF084348, 0xFF418FCD, 0xFF5FB8FF, 0xFF5AB0FF, 0xFF5AAEFF, 0xFF5DB0FF, 0xFF62B2FF, 0xFF66B4FF, 0xFF69B5FF, 0xFF6BB6FF, 0xFF73BAFF, 0xFF84C3FF, 0xFF94CAFB, 0xFF578187, 0xFF51746D, 0xFF648682, 
        0xFF6E8D8A, 0xFF75928F, 0xFF779591, 0xFF779591, 0xFF75938F, 0xFF6E8E8A, 0xFF658683, 0xFF577B78, 0xFF466E69, 0xFF315D59, 0xFF164743, 0xFF003530, 0xFF002E29, 0xFF114D58, 0xFF084042, 0xFF00352F, 0xFF013632, 0xFF00352F, 0xFF00352F, 0xFF023733, 
        0xFF013530, 0xFF013734, 0xFF73AED8, 0xFF4E7CD2, 0xD1001964, 0x4F000000, 0x10000000,
  0x00FFFFFF, 0x00FFFFFF, 0x9000007E, 0xFF4A5CBD, 0xFF82CDFF, 0xFF286D89, 0xFF1B5B6A, 0xFF3A87B6, 0xFF4FA1EA, 0xFF5CB3FF, 0xFF5DB2FF, 0xFF5FB0FF, 0xFF62B2FF, 0xFF66B4FF, 0xFF6AB6FF, 0xFF6DB7FF, 0xFF70B9FF, 0xFF76BEFF, 0xFF5295C2, 0xFF063F38, 0xFF01392C, 
        0xFF074035, 0xFF094136, 0xFF0A4237, 0xFF094237, 0xFF094136, 0xFF074035, 0xFF043D33, 0xFF003A2F, 0xFF00362B, 0xFF00372C, 0xFF003A2F, 0xFF023C31, 0xFF023B2E, 0xFF0D4948, 0xFF256B85, 0xFF023A2E, 0xFF033D31, 0xFF08433D, 0xFF0D4947, 0xFF023B2E, 
        0xFF013A2D, 0xFF003426, 0xFF4F8A9F, 0xFF6F9DE8, 0xE2002079, 0x61000000, 0x18000000,
  0x00FFFFFF, 0x00FFFFFF, 0xB7000080, 0xFF607AD3, 0xFF6AB4E4, 0xFF0D4D47, 0xFF003A24, 0xFF023D2B, 0xFF0C4A42, 0xFF2B7490, 0xFF4A9BD9, 0xFF5DB1FF, 0xFF61B3FF, 0xFF61B1FF, 0xFF65B3FF, 0xFF68B5FF, 0xFF6CB6FF, 0xFF6FB8FF, 0xFF79C2FF, 0xFF4D91B9, 0xFF054131, 
        0xFF003B25, 0xFF003C28, 0xFF003B26, 0xFF003B26, 0xFF034030, 0xFF044131, 0xFF044131, 0xFF054131, 0xFF054232, 0xFF064232, 0xFF064232, 0xFF064232, 0xFF054231, 0xFF033F2E, 0xFF2D7797, 0xFF135557, 0xFF185B61, 0xFF4591C1, 0xFF236775, 0xFF003B24, 
        0xFF125049, 0xFF003B28, 0xFF326F72, 0xFF83B1EE, 0xEC032B89, 0x6E000000, 0x1F000000,
  0x00FFFFFF, 0x00FFFFFF, 0xD3010187, 0xFF7292DF, 0xFF357A7D, 0xFF004125, 0xFF084932, 0xFF074831, 0xFF06462D, 0xFF034227, 0xFF094A37, 0xFF1D6569, 0xFF4999D2, 0xFF60B3FF, 0xFF60B1FF, 0xFF63B3FF, 0xFF65B3FF, 0xFF68B5FF, 0xFF6BB6FF, 0xFF71BDFF, 0xFF4F97C2, 
        0xFF1E6262, 0xFF1E6161, 0xFF276B72, 0xFF2F7383, 0xFF0A4A36, 0xFF074831, 0xFF084832, 0xFF084832, 0xFF084832, 0xFF084832, 0xFF084832, 0xFF084832, 0xFF084832, 0xFF064730, 0xFF0B4D3B, 0xFF0B4D3C, 0xFF094A36, 0xFF327B92, 0xFF1F6469, 0xFF3A7F96, 
        0xFF6DB3F0, 0xFF175A50, 0xFF327270, 0xFF95C3F7, 0xF30A3496, 0x79000000, 0x24000000,
  0x00FFFFFF, 0x00FFFFFF, 0xDA020189, 0xFF7698E0, 0xFF2F756D, 0xFF034929, 0xFF0A4E32, 0xFF0A4E32, 0xFF0A4E32, 0xFF094D32, 0xFF084C2F, 0xFF01431D, 0xFF236D76, 0xFF5EB3FF, 0xFF5EB2FF, 0xFF5EB0FF, 0xFF60B1FF, 0xFF62B2FF, 0xFF64B3FF, 0xFF66B4FF, 0xFF6AB7FF, 
        0xFF67B4FF, 0xFF66B4FD, 0xFF6BB8FF, 0xFF65B3FC, 0xFF13594A, 0xFF074B2C, 0xFF0A4E32, 0xFF0A4E32, 0xFF0A4E32, 0xFF0A4E32, 0xFF0A4E32, 0xFF0A4E32, 0xFF0A4E32, 0xFF0A4E33, 0xFF054A2A, 0xFF0F543F, 0xFF307A90, 0xFF266D72, 0xFF57A0D5, 0xFF73BBFA, 
        0xFF579CC2, 0xFF41838F, 0xFF5E9CB4, 0xFF97C5F1, 0xF60C3699, 0x7F000000, 0x28000000,
  0x00FFFFFF, 0x00FFFFFF, 0xDB020189, 0xFF7899E0, 0xFF337B70, 0xFF064F29, 0xFF0C5432, 0xFF0C5432, 0xFF0C5432, 0xFF0C5432, 0xFF0C5432, 0xFF0B5331, 0xFF0A5230, 0xFF26747C, 0xFF51A5E7, 0xFF5CB0FF, 0xFF5CAFFF, 0xFF5DAFFF, 0xFF5FB0FF, 0xFF60B1FF, 0xFF61B2FF, 
        0xFF62B3FF, 0xFF63B3FF, 0xFF63B3FF, 0xFF64B5FF, 0xFF2B7881, 0xFF074E27, 0xFF0C5432, 0xFF0C5432, 0xFF0C5432, 0xFF0C5432, 0xFF0C5432, 0xFF0C5432, 0xFF0C5432, 0xFF0A522E, 0xFF0D5536, 0xFF4998C8, 0xFF5EADF1, 0xFF57A1D1, 0xFF357E89, 0xFF418893, 
        0xFF2B736F, 0xFF4F909D, 0xFF86BFEA, 0xFF98C5EE, 0xF60C3699, 0x82000000, 0x29000000,
  0x00FFFFFF, 0x00FFFFFF, 0xD5000188, 0xFF7593DD, 0xFF388272, 0xFF075429, 0xFF0D5932, 0xFF0D5932, 0xFF0D5932, 0xFF0D5932, 0xFF0D5932, 0xFF0D5932, 0xFF0C5831, 0xFF075223, 0xFF146249, 0xFF4FA4E7, 0xFF5AAFFF, 0xFF5AAEFF, 0xFF5BAEFF, 0xFF5BAEFF, 0xFF5CAFFF, 
        0xFF5CB0FF, 0xFF5CAFFF, 0xFF5CAFFF, 0xFF61B4FF, 0xFF3D8EB1, 0xFF0A552A, 0xFF0D5932, 0xFF0D5932, 0xFF0D5932, 0xFF0D5932, 0xFF0D5932, 0xFF0D5932, 0xFF0C5930, 0xFF0C5831, 0xFF4493B9, 0xFF69B8FF, 0xFF6EBAFF, 0xFF6FB7F7, 0xFF317B7A, 0xFF1B664B, 
        0xFF2E766A, 0xFF7BB5D9, 0xFF9ED2FD, 0xFF9BC7F5, 0xF4093495, 0x82000000, 0x29000000,
  0x00FFFFFF, 0x00FFFFFF, 0xBE000080, 0xFF657ED4, 0xFF46917F, 0xFF075928, 0xFF0E5E32, 0xFF0E5E32, 0xFF0E5E32, 0xFF0E5E32, 0xFF0E5E32, 0xFF0E5E32, 0xFF0E5E31, 0xFF0D5D2D, 0xFF23756D, 0xFF51A7ED, 0xFF57ADFF, 0xFF57ACFF, 0xFF57ACFF, 0xFF57ADFF, 0xFF58ADFF, 
        0xFF58ADFF, 0xFF58ADFF, 0xFF58ADFF, 0xFF5BB0FF, 0xFF499DD6, 0xFF106036, 0xFF0D5E2F, 0xFF0E5E32, 0xFF0E5E32, 0xFF0E5E32, 0xFF0E5E32, 0xFF0E5F32, 0xFF095925, 0xFF247569, 0xFF68B7FF, 0xFF6DB8FF, 0xFF6BB4F1, 0xFF428C96, 0xFF74B6EA, 0xFF72B1DA, 
        0xFF81BCE7, 0xFF9DD2FF, 0xFFAAD9FF, 0xFF8AB5ED, 0xEF022B89, 0x7F000000, 0x28000000,
  0x00FFFFFF, 0x00FFFFFF, 0x9D000078, 0xFF5466CB, 0xFF569E90, 0xFF085E25, 0xFF116532, 0xFF116432, 0xFF116432, 0xFF116432, 0xFF116432, 0xFF106432, 0xFF0D6029, 0xFF308489, 0xFF5DB2FF, 0xFF5AAFFF, 0xFF57ACFF, 0xFF56ACFF, 0xFF56ACFF, 0xFF56ACFF, 0xFF56ACFF, 
        0xFF56ACFF, 0xFF56ACFF, 0xFF56ACFF, 0xFF58AEFF, 0xFF4BA1E1, 0xFF136739, 0xFF10632F, 0xFF116432, 0xFF116432, 0xFF116432, 0xFF106431, 0xFF0D6129, 0xFF136638, 0xFF4C9BBD, 0xFF70BAFF, 0xFF74BBFF, 0xFF6FB5ED, 0xFF509AA9, 0xFF85C2FA, 0xFF89C3F5, 
        0xFF9ED1FF, 0xFFA8D7FF, 0xFFB6E1FF, 0xFF709CDE, 0xE7002079, 0x79000000, 0x25000000,
  0x00FFFFFF, 0x00FFFFFF, 0x75000074, 0xFF3C47BB, 0xFF6DABAF, 0xFF0D662A, 0xFF126932, 0xFF136A32, 0xFF136A32, 0xFF136A32, 0xFF126931, 0xFF11682E, 0xFF126932, 0xFF51A4D6, 0xFF63B4FF, 0xFF5DAFFF, 0xFF5BAFFF, 0xFF59ADFF, 0xFF58ADFF, 0xFF58ADFF, 0xFF57ADFF, 
        0xFF57ACFF, 0xFF57ACFF, 0xFF57ACFF, 0xFF5AAFFF, 0xFF4FA4E6, 0xFF146C38, 0xFF12692F, 0xFF136A32, 0xFF136A32, 0xFF126931, 0xFF116930, 0xFF2D8172, 0xFF4798AE, 0xFF71BAFF, 0xFF74BBFF, 0xFF7DBFFF, 0xFF6DB1DC, 0xFF1B7143, 0xFF3E8C7C, 0xFF24774F, 
        0xFF74B1BF, 0xFF7EB7C2, 0xFFB7E0FB, 0xFF4F7CCE, 0xDB001863, 0x70000000, 0x20000000,
  0x00FFFFFF, 0x00FFFFFF, 0x4500006D, 0xFF181C9F, 0xFF8EBEE0, 0xFF1C763D, 0xFF136D2F, 0xFF146F32, 0xFF146F32, 0xFF136F32, 0xFF126D2E, 0xFF106C2B, 0xFF217A52, 0xFF67B4FA, 0xFF67B4FF, 0xFF63B2FF, 0xFF60B1FF, 0xFF5FB0FF, 0xFF5EAFFF, 0xFF5DB0FF, 0xFF5CAFFF, 
        0xFF5CAFFF, 0xFF5CAFFF, 0xFF5CAFFF, 0xFF5DB0FF, 0xFF5CAEFA, 0xFF247E60, 0xFF116C29, 0xFF146F32, 0xFF146F32, 0xFF116D2B, 0xFF2B8268, 0xFF388D87, 0xFF59A5C8, 0xFF79BEFF, 0xFF7CBFFF, 0xFF84C2FF, 0xFF85C2F9, 0xFF21794A, 0xFF0B6823, 0xFF126D2E, 
        0xFF0F6C2C, 0xFF3F8C65, 0xFFB8DDFE, 0xFF2D5CBC, 0xC900134A, 0x63000000, 0x19000000,
  0x00FFFFFF, 0x00FFFFFF, 0x14000045, 0xE5030488, 0xFF8AAAEA, 0xFF42966B, 0xFF0F7028, 0xFF167532, 0xFF157532, 0xFF117128, 0xFF3C907E, 0xFF5FAAC1, 0xFF60ABD2, 0xFF72BAFF, 0xFF6DB7FF, 0xFF6AB6FF, 0xFF67B4FF, 0xFF65B3FF, 0xFF64B3FF, 0xFF63B2FF, 0xFF61B2FF, 
        0xFF61B1FF, 0xFF61B1FF, 0xFF61B1FF, 0xFF62B2FF, 0xFF67B5FF, 0xFF4DA0C2, 0xFF14742F, 0xFF157431, 0xFF157431, 0xFF177635, 0xFF2D8769, 0xFF459796, 0xFF7EC0FF, 0xFF7FC0FF, 0xFF86C4FF, 0xFF8EC9FF, 0xFF8CC5F6, 0xFF247F4A, 0xFF13732D, 0xFF157532, 
        0xFF0A6D24, 0xFF6FAE99, 0xFFAFD3FF, 0xFD0B3AA6, 0xAF000A24, 0x52000000, 0x10000000,
  0x00FFFFFF, 0x00FFFFFF, 0x03000000, 0x95000072, 0xFF5A6BCE, 0xFF85C4BF, 0xFF13772B, 0xFF167A31, 0xFF13772A, 0xFF2F895A, 0xFF85C2F6, 0xFF89C8FF, 0xFF82C2FF, 0xFF7ABDFF, 0xFF76BCFF, 0xFF73BAFF, 0xFF70B9FF, 0xFF6EB8FF, 0xFF6CB7FF, 0xFF6BB6FF, 0xFF6AB6FF, 
        0xFF69B6FF, 0xFF69B5FF, 0xFF69B6FF, 0xFF6AB6FF, 0xFF6CB7FF, 0xFF6FB9FF, 0xFF2D8A66, 0xFF0F7520, 0xFF0F7520, 0xFF2C885F, 0xFF5EAAC0, 0xFF7CBEF8, 0xFF85C3FF, 0xFF8AC7FF, 0xFF82BFEA, 0xFF7DBBD6, 0xFF99CDFB, 0xFF1F7F3F, 0xFF0F7524, 0xFF14782F, 
        0xFF1F7F3A, 0xFFB7DFE9, 0xFF78A1E5, 0xEB002079, 0x8F000001, 0x3C000000, 0x07000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x4200005F, 0xFB111598, 0xFF9FC4F5, 0xFF439B66, 0xFF127B27, 0xFF198031, 0xFF78B8CA, 0xFF9ACFFF, 0xFF8DC8FF, 0xFF88C5FF, 0xFF84C2FF, 0xFF80C0FF, 0xFF7DBFFF, 0xFF7ABEFF, 0xFF77BCFF, 0xFF76BBFF, 0xFF74BBFF, 0xFF73BAFF, 
        0xFF73BAFF, 0xFF73BAFF, 0xFF73BAFF, 0xFF73BAFF, 0xFF74BBFF, 0xFF7ABEFF, 0xFF53A5AF, 0xFF308E60, 0xFF429A83, 0xFF71B7DE, 0xFF8AC8FF, 0xFF8AC5FF, 0xFF8EC8FF, 0xFF9ACFFF, 0xFF62ACA8, 0xFF70B3B3, 0xFFACD7FF, 0xFF6FB1A1, 0xFF409663, 0xFF07761D, 
        0xFF61AA80, 0xFFC5E4FF, 0xFF2857B9, 0xC800113F, 0x72000000, 0x24000000, 0x01000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x0A000000, 0xCB00007C, 0xFF6376D4, 0xFF90CEC5, 0xFF118022, 0xFF38965C, 0xFFA6D4FF, 0xFF9FD1FF, 0xFF98CDFF, 0xFF94CBFF, 0xFF8FC8FF, 0xFF8BC7FF, 0xFF88C4FF, 0xFF84C3FF, 0xFF82C1FF, 0xFF80C0FF, 0xFF7EC0FF, 0xFF7EBFFF, 
        0xFF7CBFFF, 0xFF7CBFFF, 0xFF7CBFFF, 0xFF7DBFFF, 0xFF7EC0FF, 0xFF80C0FF, 0xFF82C1FF, 0xFF85C3FF, 0xFF8CC9FF, 0xFF8FC9FF, 0xFF8FC9FF, 0xFF94CCFF, 0xFF9BCFFF, 0xFF9ACEF6, 0xFF499F76, 0xFF9CCEE8, 0xFFB7DCFF, 0xFFC7E5FF, 0xFFB7DCF1, 0xFF78B799, 
        0xFFC9E9ED, 0xFF80A8E7, 0xF600258F, 0xA100030B, 0x4F000000, 0x10000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x01000000, 0x5E000063, 0xFD0E1396, 0xFFA2C1F6, 0xFF58AD77, 0xFF269040, 0xFFA7D5F3, 0xFFADD7FF, 0xFFA4D3FF, 0xFF9FD0FF, 0xFF9ACEFF, 0xFF96CCFF, 0xFF92CAFF, 0xFF8FC9FF, 0xFF8CC7FF, 0xFF8AC7FF, 0xFF89C5FF, 0xFF88C4FF, 
        0xFF87C4FF, 0xFF87C4FF, 0xFF87C4FF, 0xFF88C4FF, 0xFF89C5FF, 0xFF8BC5FF, 0xFF8DC8FF, 0xFF90CAFF, 0xFF93CBFF, 0xFF96CCFF, 0xFF9ACEFF, 0xFFA0D1FF, 0xFFA6D4FF, 0xFFA7D4FA, 0xFF90C8D2, 0xFFB7DCFE, 0xFFC0E0FF, 0xFFC8E4FF, 0xFFD4EAFF, 0xFFECF8FF, 
        0xFFC3E0FF, 0xFF2150B5, 0xD6001554, 0x80000000, 0x2F000000, 0x04000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x0F000000, 0xB8000072, 0xFF4656BF, 0xFFBAE5F5, 0xFF379E4B, 0xFF69B593, 0xFFBFE0FF, 0xFFB1D9FF, 0xFFACD6FF, 0xFFA7D5FF, 0xFFA3D3FF, 0xFF9FD0FF, 0xFF9CCFFF, 0xFF99CDFF, 0xFF97CCFF, 0xFF96CBFF, 0xFF94CBFF, 
        0xFF94CBFF, 0xFF94CBFF, 0xFF94CBFF, 0xFF94CBFF, 0xFF96CBFF, 0xFF97CDFF, 0xFF99CDFF, 0xFF9CCFFF, 0xFF9FD0FF, 0xFFA3D3FF, 0xFFA7D4FF, 0xFFADD7FF, 0xFFB2DAFF, 0xFFB8DDFF, 0xFFC3E3FF, 0xFFC7E4FF, 0xFFCEE7FF, 0xFFD6EBFF, 0xFFE3F1FF, 0xFFE3F8FF, 
        0xFF5E89D4, 0xF0001D80, 0xA1000105, 0x58000000, 0x16000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x03000000, 0x3400013B, 0xEA020585, 0xFF7D96E2, 0xFFAFE2DB, 0xFF37A14A, 0xFFAAD7E0, 0xFFC2E1FF, 0xFFB8DDFF, 0xFFB3DAFF, 0xFFB0D9FF, 0xFFABD7FF, 0xFFA8D5FF, 0xFFA5D4FF, 0xFFA3D2FF, 0xFFA2D1FF, 0xFFA0D1FF, 
        0xFFA0D1FF, 0xFF9FD1FF, 0xFFA0D1FF, 0xFFA0D1FF, 0xFFA2D2FF, 0xFFA3D2FF, 0xFFA6D4FF, 0xFFA8D5FF, 0xFFACD6FF, 0xFFB0D9FF, 0xFFB4DAFF, 0xFFB9DDFF, 0xFFBFE0FF, 0xFFC4E2FF, 0xFFCCE6FF, 0xFFD3E9FF, 0xFFDBEDFF, 0xFFE6F2FF, 0xFFF0FDFF, 0xFF98BEEE, 
        0xFC0B34A1, 0xBF000B2A, 0x76000000, 0x2C000000, 0x05000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x09000000, 0x7400005D, 0xFD0E1495, 0xFF90ADEB, 0xFFBCE6DD, 0xFFCAE6F2, 0xFFCEE7FF, 0xFFC7E4FF, 0xFFC2E1FF, 0xFFBDDFFF, 0xFFBADDFF, 0xFFB6DCFF, 0xFFB3DAFF, 0xFFB1D9FF, 0xFFAFD8FF, 0xFFAED8FF, 
        0xFFADD7FF, 0xFFADD7FF, 0xFFADD8FF, 0xFFAED8FF, 0xFFB0D8FF, 0xFFB1D9FF, 0xFFB4DAFF, 0xFFB6DCFF, 0xFFBADDFF, 0xFFBEDFFF, 0xFFC2E1FF, 0xFFC8E4FF, 0xFFCEE7FF, 0xFFD4E9FF, 0xFFDBEDFF, 0xFFE1F0FF, 0xFFEDF5FF, 0xFFF7FFFF, 0xFFADCFF4, 0xFF1C47B0, 
        0xD7001353, 0x8E000000, 0x44000000, 0x0E000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x13000000, 0x9A000063, 0xFF121B9A, 0xFFA3C0F4, 0xFFE6F9FF, 0xFFE0EFFF, 0xFFD7EBFF, 0xFFD2E8FF, 0xFFCEE7FF, 0xFFCAE4FF, 0xFFC5E3FF, 0xFFC2E1FF, 0xFFC0E1FF, 0xFFBEE0FF, 0xFFBDDFFF, 
        0xFFBCDEFF, 0xFFBCDEFF, 0xFFBCDEFF, 0xFFBDDFFF, 0xFFBEDFFF, 0xFFC0E1FF, 0xFFC3E1FF, 0xFFC5E4FF, 0xFFCAE5FF, 0xFFCEE7FF, 0xFFD2E9FF, 0xFFD7ECFF, 0xFFDDEEFF, 0xFFE3F1FF, 0xFFEAF5FF, 0xFFF4FAFF, 0xFFFDFFFF, 0xFFBEDCF9, 0xFF224EB4, 0xE4001668, 
        0x9C000001, 0x59000000, 0x1B000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x1D000000, 0xA1000060, 0xFF131D9C, 0xFF92B2E8, 0xFFEAFDFF, 0xFFECF6FF, 0xFFE2F0FF, 0xFFDDEFFF, 0xFFD9ECFF, 0xFFD6EAFF, 0xFFD4E9FF, 0xFFD1E8FF, 0xFFCFE7FF, 0xFFCDE7FF, 
        0xFFCDE6FF, 0xFFCDE6FF, 0xFFCDE6FF, 0xFFCEE7FF, 0xFFCFE7FF, 0xFFD1E8FF, 0xFFD3E9FF, 0xFFD6EBFF, 0xFFDAECFF, 0xFFDEEEFF, 0xFFE2F1FF, 0xFFE8F4FF, 0xFFEDF6FF, 0xFFF4F9FF, 0xFFFEFEFF, 0xFFFFFFFF, 0xFFB1D1F4, 0xFF234DB4, 0xE3001666, 0xA1000104, 
        0x65000000, 0x25000000, 0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x20000000, 0xA6000061, 0xFF101898, 0xFF7E9DDE, 0xFFE1F8FF, 0xFFF9FFFF, 0xFFF0F8FF, 0xFFEAF5FF, 0xFFE9F3FF, 0xFFE7F3FF, 0xFFE3F0FF, 0xFFE1EFFF, 0xFFE1EFFF, 
        0xFFDEEFFF, 0xFFDCEEFF, 0xFFDCEEFF, 0xFFE0EFFF, 0xFFE0EFFF, 0xFFE0F0FF, 0xFFE2F1FF, 0xFFE5F2FF, 0xFFE9F4FF, 0xFFEDF6FF, 0xFFF2F8FF, 0xFFF8FBFF, 0xFFFEFFFF, 0xFFFFFFFF, 0xFFF4FFFF, 0xFF9BBEED, 0xFF1C44AF, 0xE4001567, 0xA1000103, 0x67000000, 
        0x29000000, 0x07000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x21000000, 0x94000254, 0xF2020A87, 0xFF4C63C0, 0xFFB9D5F5, 0xFFF5FFFF, 0xFFF6FEF9, 0xFFE6F5E9, 0xFF94D99F, 0xFFBCE6CA, 0xFFEDF6F9, 0xFFDFF1F0, 
        0xFFE8F5FB, 0xFFF7F9FF, 0xFFF9FAFF, 0xFFEAF5FB, 0xFFF0F7FF, 0xFFFDFCFF, 0xFFFEFDFF, 0xFFFCFDFF, 0xFFFDFDFF, 0xFFFEFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFFFF, 0xFFCEE5FB, 0xFF5F86D2, 0xFC0B2E9E, 0xD8001253, 0x9C000000, 0x65000000, 0x28000000, 
        0x07000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x05000000, 0x1F000000, 0x6700022E, 0xD700006E, 0xFF1425A0, 0xFF718CD6, 0xFFADD8E1, 0xFF86DE95, 0xFF3CC13F, 0xFF43C343, 0xFF4CC54E, 0xFF33BB37, 
        0xFF51C556, 0xFF9BDF9F, 0xFFA3E2A6, 0xFF50C455, 0xFF7FD682, 0xFF9EE0A0, 0xFFAFE5B0, 0xFFDDF5DB, 0xFFE9FAE4, 0xFFFEFFFB, 0xFFFDFFFF, 0xFFD3EAFD, 0xFF7FA4E1, 0xFF2349B2, 0xEF00157B, 0xC1000B2D, 0x8E000000, 0x5A000000, 0x25000000, 0x07000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x16000000, 0x3B000000, 0xA2000451, 0xE900037A, 0xFF2030A8, 0xFF6D87D5, 0xFF94C2D7, 0xFF77CF99, 0xFF5CD06D, 0xFF4ACF4F, 
        0xFF35C538, 0xFF2EC131, 0xFF2ABF2D, 0xFF2BBF2D, 0xFF2EC131, 0xFF2DC231, 0xFF38C93C, 0xFF54CF60, 0xFF6ECE8B, 0xFFA6CFE2, 0xFF789BDC, 0xFF284DB4, 0xF5001988, 0xD7001053, 0xA1000106, 0x76000000, 0x45000000, 0x1B000000, 0x05000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x0A000000, 0x26000000, 0x53000109, 0x9D00043E, 0xD800056A, 0xFA0B1998, 0xFF2F3FB7, 0xFF4D67C4, 0xFF698BCE, 
        0xFF7FACD3, 0xFF89C1CD, 0xFF8ACAC9, 0xFF88CAC5, 0xFF83C3C5, 0xFF74ADC4, 0xFF6492C7, 0xFF4971BE, 0xFF2F4EB8, 0xFD0D2BA0, 0xEA001373, 0xC9000B3F, 0xA100030D, 0x80000000, 0x58000000, 0x2C000000, 0x0F000000, 0x02000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x12000000, 0x2A000000, 0x49000000, 0x7E000424, 0xB1000544, 0xCF00055B, 0xE1000A6F, 
        0xEC031381, 0xF30B1C8F, 0xF60E2095, 0xF60E2196, 0xF40C2193, 0xEF061A86, 0xE7001274, 0xDB000C60, 0xC9000B48, 0xB0000724, 0x8E000000, 0x72000000, 0x4F000000, 0x30000000, 0x16000000, 0x06000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x0D000000, 0x20000000, 0x37000000, 0x4E000000, 0x60000000, 
        0x6D000000, 0x78000000, 0x7F000000, 0x82000000, 0x82000000, 0x7F000000, 0x79000000, 0x70000000, 0x63000000, 0x52000000, 0x3C000000, 0x24000000, 0x10000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x07000000, 0x0F000000, 0x18000000, 
        0x1F000000, 0x24000000, 0x27000000, 0x29000000, 0x29000000, 0x28000000, 0x25000000, 0x20000000, 0x19000000, 0x11000000, 0x08000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000
#else
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFA931000, 0xCE8C0D00, 0x9B880B00, 0x70880800, 
        0x4B8A0B00, 0x2E911200, 0x24931600, 0x24941600, 0x2A921600, 0x408B1100, 0x62860F00, 0x89821200, 0xB67A1400, 0xE85D1300, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDA8D0C00, 0x8B890600, 0x2E901000, 0x059C2310, 0x00B1462B, 0x00C26648, 
        0x00D08161, 0x00DE9A78, 0x00E3A481, 0x00E2A581, 0x00E09E7B, 0x00D48763, 0x00C76F4B, 0x00B8532F, 0x02A53515, 0x19962003, 0x66801300, 0xB96E1400, 0xF5000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCD8A0A00, 0x588A0300, 0x0E97160A, 0x00BD5E44, 0x00E2A37F, 0x00F7CEA8, 0x00FFE7CC, 0x00FFF9E8, 
        0x00FFFFF4, 0x00FFFFF7, 0x00FFFFF9, 0x00FFFFFA, 0x00FFFFF5, 0x00FFFEF0, 0x00FFF8E5, 0x00FFE6C9, 0x00FACFA3, 0x00EAAD82, 0x00CC7852, 0x04A33313, 0x338B1800, 0x99731800, 0xEF000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF8910900, 0x7F890200, 0x0D920F06, 0x00C0634A, 0x00EEB78D, 0x00FFE6C0, 0x00FFF8E6, 0x00FFFDF6, 0x00FBFFFC, 0x00FEFFFF, 
        0x00F4FBF8, 0x00F3FAF6, 0x00FBFDFC, 0x00FFFEFF, 0x00FDFEFD, 0x00FDFEFF, 0x00FDFFFF, 0x00FBFEFC, 0x00FDF9F1, 0x00FFF2DD, 0x00FFE2B5, 0x00F5BF8D, 0x00D2825C, 0x01A53313, 0x43811700, 0xC5491200, 0xF5000000, 0xFE000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xC7890600, 0x3C8A0200, 0x00AF4332, 0x00E9A981, 0x00FFE2B6, 0x00FCEFD8, 0x00FAF9F3, 0x00FFFFFF, 0x00F3F7F3, 0x00F4F8F3, 0x00EEF5EE, 
        0x00EFF5EF, 0x00F9FAF7, 0x00F6F8F4, 0x00FFFEFC, 0x00FFFDFB, 0x00F9FAF5, 0x00F4F8F2, 0x00ECF4ED, 0x00ECF5EE, 0x00EFF7F4, 0x00F4F5EE, 0x00FEE9CD, 0x00FFDBA8, 0x00F3B883, 0x00C36D48, 0x15942403, 0x856B1700, 0xEB000000, 0xFB000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xB4890300, 0x14900B07, 0x00CC765C, 0x00FFD39E, 0x00FDE2B9, 0x00ECF0E3, 0x00E4F2E9, 0x00ECF3EA, 0x00EBF2E9, 0x00EDF3EB, 0x00FFFDFA, 0x00F6F8F3, 
        0x00FFFEFC, 0x00FFFEFC, 0x00F6F8F4, 0x00F5F9F2, 0x00E9F2E8, 0x00E4EFE4, 0x00E4EFE4, 0x00E4EFE4, 0x00E4EFE4, 0x00E3EFE3, 0x00E3F0E5, 0x00E5F3EB, 0x00F0EFE2, 0x00FDD8A8, 0x00FFCE8F, 0x00E09D73, 0x01A53613, 0x62701800, 0xE1000000, 0xFA000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xB8880200, 0x09910E0A, 0x00D98C6D, 0x00FFD79A, 0x00F1DAB3, 0x00DDEDE0, 0x00DBEBDE, 0x00DCEADC, 0x00DBEADB, 0x00DAE9DA, 0x00E1ECE0, 0x00ECF2E9, 0x00F0F5ED, 
        0x00F1F6EF, 0x00F5F8F3, 0x00E8F1E7, 0x00DCEADC, 0x00DBEADB, 0x00DCEADC, 0x00DCEADC, 0x00DCEBDC, 0x00DCEBDC, 0x00DCEBDC, 0x00DCEADC, 0x00DCEADC, 0x00DBEBDF, 0x00DFEEE2, 0x00F0D2A5, 0x00FDC77F, 0x00EFAE80, 0x00AA3F1A, 0x5C6C1800, 0xDE000000, 
        0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xB4880100, 0x0B900C08, 0x00E8A17E, 0x00F8CC89, 0x00D9D5AE, 0x00D3E8D9, 0x00D4E6D5, 0x00D4E6D4, 0x00D4E6D4, 0x00D4E6D4, 0x00D4E6D4, 0x00D0E4D1, 0x00D3E6D4, 0x00D5E6D5, 
        0x00D4E6D4, 0x00E6F0E5, 0x00DAEADA, 0x00D2E5D3, 0x00D4E6D4, 0x00D4E6D4, 0x00D4E6D4, 0x00D4E6D4, 0x00D4E6D4, 0x00D4E6D4, 0x00D4E6D4, 0x00D4E6D4, 0x00D4E6D4, 0x00D3E6D5, 0x00D4E9DB, 0x00BFC99D, 0x00D5B263, 0x00FCBC8B, 0x00AD411B, 0x56701900, 
        0xDD000000, 0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xC9870200, 0x128E0A07, 0x00DC8D6F, 0x00E7C177, 0x00B6C290, 0x00C8E3D1, 0x00CBE1CC, 0x00CBE1CB, 0x00C9E0CA, 0x00C7DFC9, 0x00D0E3CF, 0x00ECF0E3, 0x00DDEADA, 0x00F6F6EF, 0x00FAFAF5, 
        0x00FAFBF8, 0x00F3F8F1, 0x00CEE2CE, 0x00CBE1CB, 0x00CCE1CC, 0x00CCE1CC, 0x00CCE1CC, 0x00CCE1CC, 0x00CCE1CC, 0x00CCE1CC, 0x00CCE1CC, 0x00CCE1CC, 0x00CCE1CC, 0x00CCE1CB, 0x00CCE1CD, 0x00CCE6D4, 0x008DB47D, 0x00AAA24A, 0x00F4B384, 0x00A93C16, 
        0x6A5E1700, 0xE0000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xF78E0300, 0x36870000, 0x00D0775F, 0x00F4C981, 0x008FAB69, 0x00BBDCC4, 0x00C4DEC4, 0x00C1DCC2, 0x00C0DBC1, 0x00D1E2CC, 0x00E5EAD9, 0x00F0EFE1, 0x00FFF8F0, 0x00FFF9F2, 0x00FFFAF5, 0x00FFFBF8, 
        0x00FFFDFA, 0x00FEFDFB, 0x00D7E7D5, 0x00C0DBC1, 0x00C3DDC3, 0x00C3DDC3, 0x00C3DDC3, 0x00C3DDC3, 0x00C3DDC3, 0x00C3DDC3, 0x00C3DDC3, 0x00C2DCC3, 0x00C3DDC3, 0x00C3DDC3, 0x00C3DDC3, 0x00C5DEC4, 0x00C3E0CA, 0x00579952, 0x00B6A954, 0x00EFAA7E, 
        0x0A982C08, 0x97330E00, 0xE9000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0x7D850000, 0x00AF4135, 0x00FFCC90, 0x008A9541, 0x00A4CCAB, 0x00BED8BE, 0x00B9D4B9, 0x00C2D9BE, 0x00E1E4D0, 0x00FDF1E2, 0x00FFF4E8, 0x00FFF5EB, 0x00FFF5EB, 0x00FFF7EE, 0x00FFF8F1, 0x00FFF9F4, 
        0x00FFFBF5, 0x00FEFBF7, 0x00E0E9DA, 0x00BAD5B9, 0x00BBD5BA, 0x00BBD5BA, 0x00BCD6BB, 0x00BCD6BB, 0x00BCD6BB, 0x00BCD6BB, 0x00BAD5BA, 0x00BED7BC, 0x00BCD6BB, 0x00BCD6BB, 0x00BCD6BB, 0x00BCD6BB, 0x00C2D9C0, 0x00ACCFB0, 0x0033761A, 0x00E0BB74, 
        0x00D57E54, 0x257E1C00, 0xC2000000, 0xF4000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xD0880000, 0x0B8E0A08, 0x00F5AB80, 0x00A79942, 0x0079A777, 0x00BBD3BA, 0x00C7D4BA, 0x00E4E1CA, 0x00F8EAD6, 0x00FFEFDE, 0x00FFF0DF, 0x00FFF0E1, 0x00FFF2E4, 0x00FFF3E7, 0x00FFF5EA, 0x00FFF6EC, 0x00FFF7EF, 
        0x00FFF9F1, 0x00F2F0E5, 0x00BAD0B5, 0x00B4CDB0, 0x00BDD2B7, 0x00B9D0B5, 0x00B5CDB1, 0x00B5CDB1, 0x00B5CDB1, 0x00B5CEB2, 0x00D8DDC4, 0x00CCD8BE, 0x00B4CEB1, 0x00B7CFB3, 0x00B7CFB3, 0x00B7CFB3, 0x00B7CEB3, 0x00C0D4BC, 0x0078A879, 0x00577519, 
        0x00FABE85, 0x00B0481D, 0x5A5B1700, 0xD8000000, 0xFB000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0x55840000, 0x00C56352, 0x00EABE77, 0x00215506, 0x006C9768, 0x00CAD5BC, 0x00FCE8D0, 0x00FFEBD4, 0x00FFEBD5, 0x00FFEBD7, 0x00FFEDDA, 0x00FFEEDD, 0x00FFF0E0, 0x00FFF1E2, 0x00FFF2E5, 0x00FFF3E7, 0x00FFF5EA, 
        0x00FFF9EF, 0x00D3DAC5, 0x00ACC3A6, 0x00CCD6BF, 0x00F7F0E2, 0x00EFEAD9, 0x00BFCEB4, 0x00BDCDB3, 0x00BECEB3, 0x00E2DFC8, 0x00DEDCC3, 0x00B5C8AC, 0x00B1C7AB, 0x00B2C7AB, 0x00B2C7AB, 0x00B2C7AB, 0x00B3C8AD, 0x00BCD0B7, 0x007EA073, 0x000D4E02, 
        0x00BCA65B, 0x00E99D72, 0x118C2200, 0xA90C0300, 0xEC000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xDC870000, 0x0A920F0C, 0x00FAB689, 0x00918535, 0x00586519, 0x0033560C, 0x00E5C392, 0x00FFE9CF, 0x00FFE8D0, 0x00FFE8CF, 0x00FFE9D2, 0x00FFEAD5, 0x00FFECD7, 0x00FFEDDA, 0x00FFEEDD, 0x00FFF0DF, 0x00FFF3E4, 0x00FFF2E4, 
        0x00DEDCCA, 0x00B1C1A6, 0x00ABBDA2, 0x00BCC8AF, 0x00C1CBB2, 0x00C3CCB3, 0x00C0CAB0, 0x00ECE2CD, 0x00EDE2CD, 0x00D8D5BD, 0x00C3CAAF, 0x00ACBDA2, 0x00ACBEA3, 0x00ADBDA3, 0x00ADBEA3, 0x00B1C1A8, 0x00B1C1A8, 0x00759164, 0x001F4D07, 0x000D4200, 
        0x00606A1B, 0x00FFC88F, 0x00B55024, 0x60451200, 0xD4000000, 0xFB000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0x8A820000, 0x00C15D4D, 0x00ECBB76, 0x0073671A, 0x00987A2F, 0x00A08033, 0x00FFB360, 0x00FFC589, 0x00FFDFBD, 0x00FFE6CD, 0x00FFE7CE, 0x00FFE8CF, 0x00FFE9D1, 0x00FFEAD4, 0x00FFEBD6, 0x00FFF0DC, 0x00F3E7D3, 0x00C3C7AF, 
        0x00A5B297, 0x00A7B49A, 0x00A9B59B, 0x00A7B499, 0x00A6B398, 0x00A5B398, 0x00A9B59B, 0x00AEB89E, 0x00ADB79D, 0x00A5B399, 0x00A5B399, 0x00A9B59B, 0x00A9B59B, 0x00ACB89E, 0x00AFBBA2, 0x009EAB8E, 0x0058703E, 0x001C3D00, 0x001F4000, 0x00204100, 
        0x00244100, 0x00D8AF6C, 0x00E3996D, 0x23771F00, 0xB5000000, 0xF1000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xF88B0000, 0x2A890202, 0x00EDA480, 0x00947E39, 0x00937228, 0x00826A24, 0x00B9883D, 0x00FFB662, 0x00FFB160, 0x00FFB86F, 0x00FFCB94, 0x00FFDEBC, 0x00FFE6CB, 0x00FFE7CE, 0x00FFE7CE, 0x00FFE8D0, 0x00DDD1B8, 0x00ACB098, 0x00A0A88F, 
        0x00A4AB92, 0x00A5AB92, 0x00A5AB92, 0x00A5AB92, 0x00A5AB92, 0x00A5AB92, 0x00A4AB92, 0x00A3AA92, 0x00A3AA92, 0x00A5AB93, 0x00A6AC94, 0x00AAB099, 0x00AFB39C, 0x009AA185, 0x00646E45, 0x0034430E, 0x00243400, 0x00293900, 0x002A3A00, 0x002A3A00, 
        0x001D3200, 0x0081702E, 0x00FDC18E, 0x03A3370B, 0x7F290C00, 0xDE000000, 0xFE000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xCD850000, 0x02991815, 0x00F3B882, 0x0051480D, 0x00A97932, 0x00FCB05A, 0x00F3A753, 0x00FFB05D, 0x00FFB261, 0x00FFB364, 0x00FFB466, 0x00FFBC77, 0x00FFCA91, 0x00FFD8AF, 0x00FFE3C4, 0x00FBE2C8, 0x00AEAD96, 0x00A3A58E, 0x00A5A690, 
        0x00A4A58E, 0x00A4A58E, 0x00A3A58D, 0x00A3A58D, 0x00A4A58E, 0x00A4A58E, 0x00A5A68F, 0x00A7A891, 0x00A8A993, 0x00A5A58E, 0x009F9F88, 0x00838466, 0x006B673C, 0x00544D18, 0x00262A00, 0x002E3100, 0x00313300, 0x00313300, 0x00313300, 0x00313300, 
        0x002B2F00, 0x0051470F, 0x00FAC389, 0x00BA592B, 0x4C4D1400, 0xC6000000, 0xF8000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0x9B7F0000, 0x00B03F34, 0x00EBB575, 0x00484308, 0x00CD8F41, 0x00FFB85F, 0x00FFB05A, 0x00FFAE5A, 0x00FFB05D, 0x00FFB262, 0x00FFB466, 0x00FFB569, 0x00FFB66B, 0x00FFBA73, 0x00FFC384, 0x00FBCA94, 0x00878157, 0x006D7451, 0x00828664, 
        0x008A8D6E, 0x008F9275, 0x00919577, 0x00919577, 0x008F9375, 0x008A8E6E, 0x00838665, 0x00787B57, 0x00696E46, 0x00595D31, 0x00434716, 0x00303500, 0x00292E00, 0x00584D11, 0x00424008, 0x002F3500, 0x00323601, 0x002F3500, 0x002F3500, 0x00333702, 
        0x00303501, 0x00343701, 0x00D8AE73, 0x00D27C4E, 0x2E641900, 0xB0000000, 0xEF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0x6F7E0000, 0x00BD5C4A, 0x00FFCD82, 0x00896D28, 0x006A5B1B, 0x00B6873A, 0x00EAA14F, 0x00FFB35C, 0x00FFB25D, 0x00FFB05F, 0x00FFB262, 0x00FFB466, 0x00FFB66A, 0x00FFB76D, 0x00FFB970, 0x00FFBE76, 0x00C29552, 0x00383F06, 0x002C3901, 
        0x00354007, 0x00364109, 0x0037420A, 0x00374209, 0x00364109, 0x00354007, 0x00333D04, 0x002F3A00, 0x002B3600, 0x002C3700, 0x002F3A00, 0x00313C02, 0x002E3B02, 0x0048490D, 0x00856B25, 0x002E3A02, 0x00313D03, 0x003D4308, 0x0047490D, 0x002E3B02, 
        0x002D3A01, 0x00263400, 0x009F8A4F, 0x00E89D6F, 0x1D792000, 0x9E000000, 0xE7000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0x48800000, 0x00D37A60, 0x00E4B46A, 0x00474D0D, 0x00243A00, 0x002B3D02, 0x00424A0C, 0x0090742B, 0x00D99B4A, 0x00FFB15D, 0x00FFB361, 0x00FFB161, 0x00FFB365, 0x00FFB568, 0x00FFB66C, 0x00FFB86F, 0x00FFC279, 0x00B9914D, 0x00314105, 
        0x00253B00, 0x00283C00, 0x00263B00, 0x00263B00, 0x00304003, 0x00314104, 0x00314104, 0x00314105, 0x00324205, 0x00324206, 0x00324206, 0x00324206, 0x00314205, 0x002E3F03, 0x0097772D, 0x00575513, 0x00615B18, 0x00C19145, 0x00756723, 0x00243B00, 
        0x00495012, 0x00283B00, 0x00726F32, 0x00EEB183, 0x13892B03, 0x91000000, 0xE0000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0x2C870101, 0x00DF9272, 0x007D7A35, 0x00254100, 0x00324908, 0x00314807, 0x002D4606, 0x00274203, 0x00374A09, 0x0069651D, 0x00D29949, 0x00FFB360, 0x00FFB160, 0x00FFB363, 0x00FFB365, 0x00FFB568, 0x00FFB66B, 0x00FFBD71, 0x00C2974F, 
        0x0062621E, 0x0061611E, 0x00726B27, 0x0083732F, 0x00364A0A, 0x00314807, 0x00324808, 0x00324808, 0x00324808, 0x00324808, 0x00324808, 0x00324808, 0x00324808, 0x00304706, 0x003B4D0B, 0x003C4D0B, 0x00364A09, 0x00927B32, 0x0069641F, 0x00967F3A, 
        0x00F0B36D, 0x00505A17, 0x00707232, 0x00F7C395, 0x0C96340A, 0x86000000, 0xDB000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0x25890102, 0x00E09876, 0x006D752F, 0x00294903, 0x00324E0A, 0x00324E0A, 0x00324E0A, 0x00324D09, 0x002F4C08, 0x001D4301, 0x00766D23, 0x00FFB35E, 0x00FFB25E, 0x00FFB05E, 0x00FFB160, 0x00FFB262, 0x00FFB364, 0x00FFB466, 0x00FFB76A, 
        0x00FFB467, 0x00FDB466, 0x00FFB86B, 0x00FCB365, 0x004A5913, 0x002C4B07, 0x00324E0A, 0x00324E0A, 0x00324E0A, 0x00324E0A, 0x00324E0A, 0x00324E0A, 0x00324E0A, 0x00334E0A, 0x002A4A05, 0x003F540F, 0x00907A30, 0x00726D26, 0x00D5A057, 0x00FABB73, 
        0x00C29C57, 0x008F8341, 0x00B49C5E, 0x00F1C597, 0x0999360C, 0x80000000, 0xD7000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0x24890102, 0x00E09978, 0x00707B33, 0x00294F06, 0x0032540C, 0x0032540C, 0x0032540C, 0x0032540C, 0x0032540C, 0x0031530B, 0x0030520A, 0x007C7426, 0x00E7A551, 0x00FFB05C, 0x00FFAF5C, 0x00FFAF5D, 0x00FFB05F, 0x00FFB160, 0x00FFB261, 
        0x00FFB362, 0x00FFB363, 0x00FFB363, 0x00FFB564, 0x0081782B, 0x00274E07, 0x0032540C, 0x0032540C, 0x0032540C, 0x0032540C, 0x0032540C, 0x0032540C, 0x0032540C, 0x002E520A, 0x0036550D, 0x00C89849, 0x00F1AD5E, 0x00D1A157, 0x00897E35, 0x00938841, 
        0x006F732B, 0x009D904F, 0x00EABF86, 0x00EEC598, 0x0999360C, 0x7D000000, 0xD6000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0x2A880100, 0x00DD9375, 0x00728238, 0x00295407, 0x0032590D, 0x0032590D, 0x0032590D, 0x0032590D, 0x0032590D, 0x0032590D, 0x0031580C, 0x00235207, 0x00496214, 0x00E7A44F, 0x00FFAF5A, 0x00FFAE5A, 0x00FFAE5B, 0x00FFAE5B, 0x00FFAF5C, 
        0x00FFB05C, 0x00FFAF5C, 0x00FFAF5C, 0x00FFB461, 0x00B18E3D, 0x002A550A, 0x0032590D, 0x0032590D, 0x0032590D, 0x0032590D, 0x0032590D, 0x0032590D, 0x0030590C, 0x0031580C, 0x00B99344, 0x00FFB869, 0x00FFBA6E, 0x00F7B76F, 0x007A7B31, 0x004B661B, 
        0x006A762E, 0x00D9B57B, 0x00FDD29E, 0x00F5C79B, 0x0B953409, 0x7D000000, 0xD6000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0x41800000, 0x00D47E65, 0x007F9146, 0x00285907, 0x00325E0E, 0x00325E0E, 0x00325E0E, 0x00325E0E, 0x00325E0E, 0x00325E0E, 0x00315E0E, 0x002D5D0D, 0x006D7523, 0x00EDA751, 0x00FFAD57, 0x00FFAC57, 0x00FFAC57, 0x00FFAD57, 0x00FFAD58, 
        0x00FFAD58, 0x00FFAD58, 0x00FFAD58, 0x00FFB05B, 0x00D69D49, 0x00366010, 0x002F5E0D, 0x00325E0E, 0x00325E0E, 0x00325E0E, 0x00325E0E, 0x00325F0E, 0x00255909, 0x00697524, 0x00FFB768, 0x00FFB86D, 0x00F1B46B, 0x00968C42, 0x00EAB674, 0x00DAB172, 
        0x00E7BC81, 0x00FFD29D, 0x00FFD9AA, 0x00EDB58A, 0x10892B02, 0x80000000, 0xD7000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0x62780000, 0x00CB6654, 0x00909E56, 0x00255E08, 0x00326511, 0x00326411, 0x00326411, 0x00326411, 0x00326411, 0x00326410, 0x0029600D, 0x00898430, 0x00FFB25D, 0x00FFAF5A, 0x00FFAC57, 0x00FFAC56, 0x00FFAC56, 0x00FFAC56, 0x00FFAC56, 
        0x00FFAC56, 0x00FFAC56, 0x00FFAC56, 0x00FFAE58, 0x00E1A14B, 0x00396713, 0x002F6310, 0x00326411, 0x00326411, 0x00326411, 0x00316410, 0x0029610D, 0x00386613, 0x00BD9B4C, 0x00FFBA70, 0x00FFBB74, 0x00EDB56F, 0x00A99A50, 0x00FAC285, 0x00F5C389, 
        0x00FFD19E, 0x00FFD7A8, 0x00FFE1B6, 0x00DE9C70, 0x18792000, 0x86000000, 0xDA000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0x8A740000, 0x00BB473C, 0x00AFAB6D, 0x002A660D, 0x00326912, 0x00326A13, 0x00326A13, 0x00326A13, 0x00316912, 0x002E6811, 0x00326912, 0x00D6A451, 0x00FFB463, 0x00FFAF5D, 0x00FFAF5B, 0x00FFAD59, 0x00FFAD58, 0x00FFAD58, 0x00FFAD57, 
        0x00FFAC57, 0x00FFAC57, 0x00FFAC57, 0x00FFAF5A, 0x00E6A44F, 0x00386C14, 0x002F6912, 0x00326A13, 0x00326A13, 0x00316912, 0x00306911, 0x0072812D, 0x00AE9847, 0x00FFBA71, 0x00FFBB74, 0x00FFBF7D, 0x00DCB16D, 0x0043711B, 0x007C8C3E, 0x004F7724, 
        0x00BFB174, 0x00C2B77E, 0x00FBE0B7, 0x00CE7C4F, 0x24631800, 0x8F000000, 0xDF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xBA6D0000, 0x009F1C18, 0x00E0BE8E, 0x003D761C, 0x002F6D13, 0x00326F14, 0x00326F14, 0x00326F13, 0x002E6D12, 0x002B6C10, 0x00527A21, 0x00FAB467, 0x00FFB467, 0x00FFB263, 0x00FFB160, 0x00FFB05F, 0x00FFAF5E, 0x00FFB05D, 0x00FFAF5C, 
        0x00FFAF5C, 0x00FFAF5C, 0x00FFAF5C, 0x00FFB05D, 0x00FAAE5C, 0x00607E24, 0x00296C11, 0x00326F14, 0x00326F14, 0x002B6D11, 0x0068822B, 0x00878D38, 0x00C8A559, 0x00FFBE79, 0x00FFBF7C, 0x00FFC284, 0x00F9C285, 0x004A7921, 0x0023680B, 0x002E6D12, 
        0x002C6C0F, 0x00658C3F, 0x00FEDDB8, 0x00BC5C2D, 0x364A1300, 0x9C000000, 0xE6000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xEB450000, 0x1A880403, 0x00EAAA8A, 0x006B9642, 0x0028700F, 0x00327516, 0x00327515, 0x00287111, 0x007E903C, 0x00C1AA5F, 0x00D2AB60, 0x00FFBA72, 0x00FFB76D, 0x00FFB66A, 0x00FFB467, 0x00FFB365, 0x00FFB364, 0x00FFB263, 0x00FFB261, 
        0x00FFB161, 0x00FFB161, 0x00FFB161, 0x00FFB262, 0x00FFB567, 0x00C2A04D, 0x002F7414, 0x00317415, 0x00317415, 0x00357617, 0x0069872D, 0x00969745, 0x00FFC07E, 0x00FFC07F, 0x00FFC486, 0x00FFC98E, 0x00F6C58C, 0x004A7F24, 0x002D7313, 0x00327515, 
        0x00246D0A, 0x0099AE6F, 0x00FFD3AF, 0x02A63A0B, 0x50240A00, 0xAD000000, 0xEF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFC000000, 0x6A720000, 0x00CE6B5A, 0x00BFC485, 0x002B7713, 0x00317A16, 0x002A7713, 0x005A892F, 0x00F6C285, 0x00FFC889, 0x00FFC282, 0x00FFBD7A, 0x00FFBC76, 0x00FFBA73, 0x00FFB970, 0x00FFB86E, 0x00FFB76C, 0x00FFB66B, 0x00FFB66A, 
        0x00FFB669, 0x00FFB569, 0x00FFB669, 0x00FFB66A, 0x00FFB76C, 0x00FFB96F, 0x00668A2D, 0x0020750F, 0x0020750F, 0x005F882C, 0x00C0AA5E, 0x00F8BE7C, 0x00FFC385, 0x00FFC78A, 0x00EABF82, 0x00D6BB7D, 0x00FBCD99, 0x003F7F1F, 0x0024750F, 0x002F7814, 
        0x003A7F1F, 0x00E9DFB7, 0x00E5A178, 0x14792000, 0x70010000, 0xC3000000, 0xF8000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xBD5F0000, 0x04981511, 0x00F5C49F, 0x00669B43, 0x00277B12, 0x00318019, 0x00CAB878, 0x00FFCF9A, 0x00FFC88D, 0x00FFC588, 0x00FFC284, 0x00FFC080, 0x00FFBF7D, 0x00FFBE7A, 0x00FFBC77, 0x00FFBB76, 0x00FFBB74, 0x00FFBA73, 
        0x00FFBA73, 0x00FFBA73, 0x00FFBA73, 0x00FFBA73, 0x00FFBB74, 0x00FFBE7A, 0x00AFA553, 0x00608E30, 0x00839A42, 0x00DEB771, 0x00FFC88A, 0x00FFC58A, 0x00FFC88E, 0x00FFCF9A, 0x00A8AC62, 0x00B3B370, 0x00FFD7AC, 0x00A1B16F, 0x00639640, 0x001D7607, 
        0x0080AA61, 0x00FFE4C5, 0x00B95728, 0x373F1100, 0x8D000000, 0xDB000000, 0xFE000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xF5000000, 0x347C0000, 0x00D47663, 0x00C5CE90, 0x00228011, 0x005C9638, 0x00FFD4A6, 0x00FFD19F, 0x00FFCD98, 0x00FFCB94, 0x00FFC88F, 0x00FFC78B, 0x00FFC488, 0x00FFC384, 0x00FFC182, 0x00FFC080, 0x00FFC07E, 0x00FFBF7E, 
        0x00FFBF7C, 0x00FFBF7C, 0x00FFBF7C, 0x00FFBF7D, 0x00FFC07E, 0x00FFC080, 0x00FFC182, 0x00FFC385, 0x00FFC98C, 0x00FFC98F, 0x00FFC98F, 0x00FFCC94, 0x00FFCF9B, 0x00F6CE9A, 0x00769F49, 0x00E8CE9C, 0x00FFDCB7, 0x00FFE5C7, 0x00F1DCB7, 0x0099B778, 
        0x00EDE9C9, 0x00E7A880, 0x098F2500, 0x5E0B0300, 0xB0000000, 0xEF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFE000000, 0xA1630000, 0x0296130E, 0x00F6C1A2, 0x0077AD58, 0x00409026, 0x00F3D5A7, 0x00FFD7AD, 0x00FFD3A4, 0x00FFD09F, 0x00FFCE9A, 0x00FFCC96, 0x00FFCA92, 0x00FFC98F, 0x00FFC78C, 0x00FFC78A, 0x00FFC589, 0x00FFC488, 
        0x00FFC487, 0x00FFC487, 0x00FFC487, 0x00FFC488, 0x00FFC589, 0x00FFC58B, 0x00FFC88D, 0x00FFCA90, 0x00FFCB93, 0x00FFCC96, 0x00FFCE9A, 0x00FFD1A0, 0x00FFD4A6, 0x00FAD4A7, 0x00D2C890, 0x00FEDCB7, 0x00FFE0C0, 0x00FFE4C8, 0x00FFEAD4, 0x00FFF8EC, 
        0x00FFE0C3, 0x00B55021, 0x29541500, 0x7F000000, 0xD0000000, 0xFB000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xF0000000, 0x47720000, 0x00BF5646, 0x00F5E5BA, 0x004B9E37, 0x0093B569, 0x00FFE0BF, 0x00FFD9B1, 0x00FFD6AC, 0x00FFD5A7, 0x00FFD3A3, 0x00FFD09F, 0x00FFCF9C, 0x00FFCD99, 0x00FFCC97, 0x00FFCB96, 0x00FFCB94, 
        0x00FFCB94, 0x00FFCB94, 0x00FFCB94, 0x00FFCB94, 0x00FFCB96, 0x00FFCD97, 0x00FFCD99, 0x00FFCF9C, 0x00FFD09F, 0x00FFD3A3, 0x00FFD4A7, 0x00FFD7AD, 0x00FFDAB2, 0x00FFDDB8, 0x00FFE3C3, 0x00FFE4C7, 0x00FFE7CE, 0x00FFEBD6, 0x00FFF1E3, 0x00FFF8E3, 
        0x00D4895E, 0x0F801D00, 0x5E050100, 0xA7000000, 0xE9000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFC000000, 0xCB3B0100, 0x15850502, 0x00E2967D, 0x00DBE2AF, 0x004AA137, 0x00E0D7AA, 0x00FFE1C2, 0x00FFDDB8, 0x00FFDAB3, 0x00FFD9B0, 0x00FFD7AB, 0x00FFD5A8, 0x00FFD4A5, 0x00FFD2A3, 0x00FFD1A2, 0x00FFD1A0, 
        0x00FFD1A0, 0x00FFD19F, 0x00FFD1A0, 0x00FFD1A0, 0x00FFD2A2, 0x00FFD2A3, 0x00FFD4A6, 0x00FFD5A8, 0x00FFD6AC, 0x00FFD9B0, 0x00FFDAB4, 0x00FFDDB9, 0x00FFE0BF, 0x00FFE2C4, 0x00FFE6CC, 0x00FFE9D3, 0x00FFEDDB, 0x00FFF2E6, 0x00FFFDF0, 0x00EEBE98, 
        0x03A1340B, 0x402A0B00, 0x89000000, 0xD3000000, 0xFA000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xF6000000, 0x8B5D0000, 0x0295140E, 0x00EBAD90, 0x00DDE6BC, 0x00F2E6CA, 0x00FFE7CE, 0x00FFE4C7, 0x00FFE1C2, 0x00FFDFBD, 0x00FFDDBA, 0x00FFDCB6, 0x00FFDAB3, 0x00FFD9B1, 0x00FFD8AF, 0x00FFD8AE, 
        0x00FFD7AD, 0x00FFD7AD, 0x00FFD8AD, 0x00FFD8AE, 0x00FFD8B0, 0x00FFD9B1, 0x00FFDAB4, 0x00FFDCB6, 0x00FFDDBA, 0x00FFDFBE, 0x00FFE1C2, 0x00FFE4C8, 0x00FFE7CE, 0x00FFE9D4, 0x00FFEDDB, 0x00FFF0E1, 0x00FFF5ED, 0x00FFFFF7, 0x00F4CFAD, 0x00B0471C, 
        0x28531300, 0x71000000, 0xBB000000, 0xF1000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xEC000000, 0x65630000, 0x009A1B12, 0x00F4C0A3, 0x00FFF9E6, 0x00FFEFE0, 0x00FFEBD7, 0x00FFE8D2, 0x00FFE7CE, 0x00FFE4CA, 0x00FFE3C5, 0x00FFE1C2, 0x00FFE1C0, 0x00FFE0BE, 0x00FFDFBD, 
        0x00FFDEBC, 0x00FFDEBC, 0x00FFDEBC, 0x00FFDFBD, 0x00FFDFBE, 0x00FFE1C0, 0x00FFE1C3, 0x00FFE4C5, 0x00FFE5CA, 0x00FFE7CE, 0x00FFE9D2, 0x00FFECD7, 0x00FFEEDD, 0x00FFF1E3, 0x00FFF5EA, 0x00FFFAF4, 0x00FFFFFD, 0x00F9DCBE, 0x00B44E22, 0x1B681600, 
        0x63010000, 0xA6000000, 0xE4000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0xE2000000, 0x5E600000, 0x009C1D13, 0x00E8B292, 0x00FFFDEA, 0x00FFF6EC, 0x00FFF0E2, 0x00FFEFDD, 0x00FFECD9, 0x00FFEAD6, 0x00FFE9D4, 0x00FFE8D1, 0x00FFE7CF, 0x00FFE7CD, 
        0x00FFE6CD, 0x00FFE6CD, 0x00FFE6CD, 0x00FFE7CE, 0x00FFE7CF, 0x00FFE8D1, 0x00FFE9D3, 0x00FFEBD6, 0x00FFECDA, 0x00FFEEDE, 0x00FFF1E2, 0x00FFF4E8, 0x00FFF6ED, 0x00FFF9F4, 0x00FFFEFE, 0x00FFFFFF, 0x00F4D1B1, 0x00B44D23, 0x1C661600, 0x5E040100, 
        0x9A000000, 0xDA000000, 0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFB000000, 0xDF000000, 0x59610000, 0x00981810, 0x00DE9D7E, 0x00FFF8E1, 0x00FFFFF9, 0x00FFF8F0, 0x00FFF5EA, 0x00FFF3E9, 0x00FFF3E7, 0x00FFF0E3, 0x00FFEFE1, 0x00FFEFE1, 
        0x00FFEFDE, 0x00FFEEDC, 0x00FFEEDC, 0x00FFEFE0, 0x00FFEFE0, 0x00FFF0E0, 0x00FFF1E2, 0x00FFF2E5, 0x00FFF4E9, 0x00FFF6ED, 0x00FFF8F2, 0x00FFFBF8, 0x00FFFFFE, 0x00FFFFFF, 0x00FFFFF4, 0x00EDBE9B, 0x00AF441C, 0x1B671500, 0x5E030100, 0x98000000, 
        0xD6000000, 0xF8000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFB000000, 0xDE000000, 0x6B540200, 0x0D870A02, 0x00C0634C, 0x00F5D5B9, 0x00FFFFF5, 0x00F9FEF6, 0x00E9F5E6, 0x009FD994, 0x00CAE6BC, 0x00F9F6ED, 0x00F0F1DF, 
        0x00FBF5E8, 0x00FFF9F7, 0x00FFFAF9, 0x00FBF5EA, 0x00FFF7F0, 0x00FFFCFD, 0x00FFFDFE, 0x00FFFDFC, 0x00FFFDFD, 0x00FFFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFC, 0x00FBE5CE, 0x00D2865F, 0x039E2E0B, 0x27531200, 0x63000000, 0x9A000000, 0xD7000000, 
        0xF8000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFA000000, 0xE0000000, 0x982E0200, 0x286E0000, 0x00A02514, 0x00D68C71, 0x00E1D8AD, 0x0095DE86, 0x003FC13C, 0x0043C343, 0x004EC54C, 0x0037BB33, 
        0x0056C551, 0x009FDF9B, 0x00A6E2A3, 0x0055C450, 0x0082D67F, 0x00A0E09E, 0x00B0E5AF, 0x00DBF5DD, 0x00E4FAE9, 0x00FBFFFE, 0x00FFFFFD, 0x00FDEAD3, 0x00E1A47F, 0x00B24923, 0x107B1500, 0x3E2D0B00, 0x71000000, 0xA5000000, 0xDA000000, 0xF8000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFB000000, 0xE9000000, 0xC4000000, 0x5D510400, 0x167A0300, 0x00A83020, 0x00D5876D, 0x00D7C294, 0x0099CF77, 0x006DD05C, 0x004FCF4A, 
        0x0038C535, 0x0031C12E, 0x002DBF2A, 0x002DBF2B, 0x0031C12E, 0x0031C22D, 0x003CC938, 0x0060CF54, 0x008BCE6E, 0x00E2CFA6, 0x00DC9B78, 0x00B44D28, 0x0A881900, 0x28531000, 0x5E060100, 0x89000000, 0xBA000000, 0xE4000000, 0xFA000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF5000000, 0xD9000000, 0xAC090100, 0x623E0400, 0x276A0500, 0x0598190B, 0x00B73F2F, 0x00C4674D, 0x00CE8B69, 
        0x00D3AC7F, 0x00CDC189, 0x00C9CA8A, 0x00C5CA88, 0x00C5C383, 0x00C4AD74, 0x00C79264, 0x00BE7149, 0x00B84E2F, 0x02A02B0D, 0x15731300, 0x363F0B00, 0x5E0D0300, 0x7F000000, 0xA7000000, 0xD3000000, 0xF0000000, 0xFD000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFB000000, 0xED000000, 0xD5000000, 0xB6000000, 0x81240400, 0x4E440500, 0x305B0500, 0x1E6F0A00, 
        0x13811303, 0x0C8F1C0B, 0x0995200E, 0x0996210E, 0x0B93210C, 0x10861A06, 0x18741200, 0x24600C00, 0x36480B00, 0x4F240700, 0x71000000, 0x8D000000, 0xB0000000, 0xCF000000, 0xE9000000, 0xF9000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0xF2000000, 0xDF000000, 0xC8000000, 0xB1000000, 0x9F000000, 
        0x92000000, 0x87000000, 0x80000000, 0x7D000000, 0x7D000000, 0x80000000, 0x86000000, 0x8F000000, 0x9C000000, 0xAD000000, 0xC3000000, 0xDB000000, 0xEF000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF8000000, 0xF0000000, 0xE7000000, 
        0xE0000000, 0xDB000000, 0xD8000000, 0xD6000000, 0xD6000000, 0xD7000000, 0xDA000000, 0xDF000000, 0xE6000000, 0xEE000000, 0xF7000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000
#endif
};

GUI_CONST_STORAGE GUI_BITMAP _bmBrowser = {
  48, // XSize */
  48, // YSize */
  192, // BytesPerLine */
  32, // BitsPerPixel */
  (unsigned char *)_acBrowser,  // Pointer to picture data */
  NULL,  // Pointer to palette */
#if (GUI_USE_ARGB == 1)
  GUI_DRAW_BMPM8888I
#else
  GUI_DRAW_BMP8888
#endif
};

/*********************************************************************
*
*       _bmClock
*
* Function description
*   Icon bitmap with alpha channel
*/
static GUI_CONST_STORAGE unsigned long _acClock[] = {
#if (GUI_USE_ARGB == 1)
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0A001D9D, 0x36001998, 0x6C00259A, 0x9D0831A1, 
        0xC7103EAA, 0xE2204FB4, 0xF0295BBC, 0xF22A5FBD, 0xE42158B8, 0xCD134DB1, 0xA90845A8, 0x7B003D9D, 0x4A00348E, 0x16002A6C, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x27000F92, 0x95001697, 0xDB1C3BA9, 0xFC607ECB, 0xFF8CAAE2, 0xFFABCAF1, 
        0xFFC2DEFA, 0xFFC8E3FC, 0xFFCBE5FD, 0xFFCBE5FE, 0xFFC9E3FD, 0xFFC3DFFB, 0xFFAFD1F4, 0xFF90B7E9, 0xFD6796D9, 0xE82362BB, 0xAD0043A4, 0x4B003381, 0x0C000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3200068A, 0x9D061695, 0xF1435AB9, 0xFF86A2DF, 0xFFBCD9F9, 0xFFDEF5FF, 0xFFE7F9FF, 0xFFE5F6FF, 
        0xFFE4F6FF, 0xFFE4F7FF, 0xFFE4F7FF, 0xFFE5F7FF, 0xFFE4F7FF, 0xFFE4F6FF, 0xFFE5F6FF, 0xFFE6F7FF, 0xFFE0F4FF, 0xFFC2E0FC, 0xFF8CB7EA, 0xF94C85D1, 0xBF0A4DA7, 0x5400337F, 0x0D000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0600018D, 0x7100028A, 0xF2303EAB, 0xFF92ADE4, 0xFFCCEAFF, 0xFFDCF3FF, 0xFFE4F6FF, 0xFFE0F6FF, 0xFFC4DFFD, 0xFFABCBF5, 
        0xFF9CB9EC, 0xFF8EA8E3, 0xFF8BA4E2, 0xFF8BA4E2, 0xFF8DA8E2, 0xFF9BB7EB, 0xFFA9C9F4, 0xFFC0DCFC, 0xFFDEF4FF, 0xFFE5F6FF, 0xFFDDF1FF, 0xFFD0E9FF, 0xFF9FC7F3, 0xFC3979CC, 0xA4003F95, 0x29001636, 0x07000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1C000083, 0xBC090B8E, 0xFF6C81CF, 0xFFB8DBFD, 0xFFD9F0FF, 0xFFDDF2FF, 0xFFC3E4FF, 0xFF98BBF0, 0xFF657DCE, 0xFF6673BF, 0xFF8084C0, 
        0xFF9193C4, 0xFFA2A3CC, 0xFF9D9DC1, 0xFF9B9CBE, 0xFFA4A5CD, 0xFF9395C4, 0xFF8286C0, 0xFF6975BF, 0xFF6277CB, 0xFF92B4ED, 0xFFBFE0FF, 0xFFDBF1FF, 0xFFDCEEFF, 0xFFBFDFFF, 0xFF79ABE7, 0xDF0E52AE, 0x5100275F, 0x0E000000, 0x01000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3000008B, 0xD71C1F99, 0xFF849FE0, 0xFFC8E9FF, 0xFFD4ECFF, 0xFFC1E3FF, 0xFF84A8EA, 0xFF677BCA, 0xFF7C81BF, 0xFFA4A2C9, 0xFFCFCDDC, 0xFFE3E2E7, 
        0xFFE7E6EB, 0xFFECEBF0, 0xFFC4C3C7, 0xFFBBBBBE, 0xFFEDECF2, 0xFFE6E6EA, 0xFFE5E4E8, 0xFFD2D1DD, 0xFFAAA8CC, 0xFF8083C0, 0xFF6879C8, 0xFF7D9FE6, 0xFFBCDFFF, 0xFFD5EBFF, 0xFFCCE5FF, 0xFF92BFF2, 0xEF2265BB, 0x74002C6E, 0x14000000, 0x03000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x2E00008F, 0xE419209F, 0xFF95B6EE, 0xFFC7E7FF, 0xFFCFE9FF, 0xFF98C5FB, 0xFF607DD3, 0xFF6769B1, 0xFFBAB8CE, 0xFFE4E3E8, 0xFFEAEAEE, 0xFFE9E9EF, 0xFFEAEAF0, 
        0xFFEBEBF1, 0xFFF0F0F6, 0xFFC4C4C9, 0xFFBABABE, 0xFFF1F1F7, 0xFFEBEBF1, 0xFFEAEAF0, 0xFFEAEAEF, 0xFFE9E9EE, 0xFFE6E5EA, 0xFFC5C2D4, 0xFF7072B1, 0xFF5B75CD, 0xFF91BEF8, 0xFFCBE7FF, 0xFFCAE3FF, 0xFFA1CBF9, 0xF6276CC3, 0x76002762, 0x17000000, 
        0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1A000294, 0xDA1A22A4, 0xFF8FB3F0, 0xFFC4E3FF, 0xFFBCE0FF, 0xFF79ABF2, 0xFF5463BC, 0xFFA8A6CC, 0xFFCECDD1, 0xFFAFAFB1, 0xFFEBEBF1, 0xFFECECF1, 0xFFECECF1, 0xFFEDEDF3, 
        0xFFEEEEF3, 0xFFF2F2F7, 0xFFD7D7DA, 0xFFD1D1D4, 0xFFF3F3F8, 0xFFEFEFF3, 0xFFEDEDF3, 0xFFEDEDF2, 0xFFEBEBF1, 0xFFEDEDF4, 0xFFAEAEB1, 0xFFC1C1C3, 0xFFB8B5D3, 0xFF5864BA, 0xFF6E9CEA, 0xFFB6DFFF, 0xFFC5E1FF, 0xFF98C5F8, 0xF62469C1, 0x67001E4B, 
        0x14000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x060009A1, 0xBD0A119F, 0xFF789AE6, 0xFFB8DEFF, 0xFFB2DAFF, 0xFF6B9CEC, 0xFF5D6ABC, 0xFFBFBCD3, 0xFFE8E8EB, 0xFFEAEAF1, 0xFFB4B4B8, 0xFFDDDDE2, 0xFFF1F1F5, 0xFFF0F0F5, 0xFFF2F2F6, 
        0xFFF3F3F6, 0xFFF3F3F7, 0xFFF5F5F8, 0xFFF5F5F8, 0xFFF3F3F7, 0xFFF3F3F6, 0xFFF2F2F6, 0xFFF1F1F5, 0xFFF0F0F5, 0xFFE6E6EB, 0xFFB8B8BB, 0xFFE8E8EE, 0xFFEAE9ED, 0xFFCAC8D8, 0xFF6871BD, 0xFF5F8EE5, 0xFFADD7FF, 0xFFBBDBFF, 0xFF89B9F5, 0xE60F52A9, 
        0x50001532, 0x0F000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x7200079E, 0xFF5C7AD8, 0xFFAED7FF, 0xFFB2D8FF, 0xFF639EF3, 0xFF5B68BD, 0xFFCCC8D7, 0xFFE8E8ED, 0xFFE9E9F0, 0xFFECECF2, 0xFFEFEFF4, 0xFFF0F0F3, 0xFFF3F3F7, 0xFFF4F4F8, 0xFFF6F6F8, 
        0xFFF7F7FA, 0xFFF8F8FA, 0xFFF9F9FB, 0xFFF9F9FB, 0xFFF8F8FA, 0xFFF8F8FA, 0xFFF6F6F9, 0xFFF5F5F8, 0xFFF3F3F7, 0xFFF0F0F4, 0xFFF0F0F5, 0xFFEEEEF3, 0xFFEAEAF1, 0xFFEAEAED, 0xFFD5D2DC, 0xFF646BB9, 0xFF5C94EE, 0xFFA8D4FF, 0xFFB1D4FF, 0xFF67A0E7, 
        0xC5033A88, 0x32000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x2D0009A5, 0xF4253CBC, 0xFF95C2FE, 0xFFA9D2FF, 0xFF68A9FB, 0xFF4B5EBD, 0xFFC1BDD3, 0xFFE8E8ED, 0xFFEAEAF0, 0xFFECECF2, 0xFFEFEFF4, 0xFFF3F3F7, 0xFFF5F5F8, 0xFFF7F7F9, 0xFFF9F9FA, 0xFFFAFAFC, 
        0xFFFCFCFD, 0xFFFDFDFD, 0xFFFDFDFE, 0xFFFDFDFE, 0xFFFDFDFD, 0xFFFCFCFD, 0xFFFBFBFC, 0xFFF9F9FB, 0xFFF7F7F9, 0xFFF5F5F8, 0xFFF2F2F6, 0xFFF0F0F4, 0xFFEDEDF2, 0xFFEAEAF0, 0xFFE9E9ED, 0xFFD1CFDB, 0xFF515FB9, 0xFF5C9AF4, 0xFFA8D2FF, 0xFF9FCAFF, 
        0xFD3A7DD1, 0x8A002253, 0x1F000000, 0x02000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x9F0817AD, 0xFF6F98EB, 0xFFA8D1FF, 0xFF7CBAFF, 0xFF406AD4, 0xFFABA8CC, 0xFFECECEF, 0xFFEAEAF1, 0xFFECECF2, 0xFFF0F0F5, 0xFFF3F3F6, 0xFFF5F5F9, 0xFFF8F8FB, 0xFFFBFBFC, 0xFFFDFDFD, 0xFFFEFEFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFE, 0xFFFBFBFC, 0xFFF8F8FB, 0xFFF6F6F9, 0xFFF3F3F7, 0xFFF0F0F5, 0xFFEDEDF2, 0xFFEAEAF0, 0xFFE9E9ED, 0xFFB9B4D1, 0xFF4768CC, 0xFF6EB1FF, 0xFFA5CDFF, 
        0xFF77ADF3, 0xE5084AA1, 0x4A000307, 0x0F000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x25000EAD, 0xF33250CB, 0xFF93C3FF, 0xFF8AC1FF, 0xFF3E7FEC, 0xFF6568B1, 0xFFADACB3, 0xFFC2C2CD, 0xFFE9E9EE, 0xFFF4F4F8, 0xFFF3F3F7, 0xFFF6F6F8, 0xFFF9F9FB, 0xFFFCFCFE, 0xFFFEFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFE, 0xFFFAFAFC, 0xFFF7F7F9, 0xFFF4F4F7, 0xFFF0F0F4, 0xFFEDEDF2, 0xFFEDEDF3, 0xFFD8D6D7, 0xFF787AB2, 0xFF3977E6, 0xFF89C0FF, 
        0xFF9BC7FF, 0xFF4385D9, 0x94001D48, 0x27000000, 0x03000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x950113B2, 0xFF5985E8, 0xFF8FC0FF, 0xFF58A3FF, 0xFF4366CD, 0xFFB7B2C5, 0xFF808091, 0xFF8C8CA1, 0xFFA5A5B3, 0xFFD5D5DB, 0xFFFAFAFC, 0xFFFEFEFF, 0xFFFDFDFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFE, 0xFFF9F9FC, 0xFFF6F6F9, 0xFFF3F3F7, 0xFFF2F2F7, 0xFFBDBDC1, 0xFFAAAAAC, 0xFFC5C1CF, 0xFF475DC0, 0xFF4B99FC, 
        0xFF8ABCFF, 0xFF6FA7F3, 0xD8043D8A, 0x46000000, 0x0D000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x080017BD, 0xDD1531C1, 0xFF7CADFB, 0xFF7EB8FF, 0xFF307CF2, 0xFF737BC0, 0xFFE7E5E8, 0xFFD3D3DA, 0xFFA1A1AF, 0xFF84849A, 0xFF8F8FA2, 0xFFB7B7C1, 0xFFE4E4E7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFE, 0xFFF9F9FB, 0xFFF5F5F8, 0xFFF2F2F6, 0xFFDDDDE2, 0xFFE9E9EF, 0xFFEBEAED, 0xFF8E90C3, 0xFF2D73E9, 
        0xFF6FB0FF, 0xFF7DB1FE, 0xFB2164C1, 0x7C00122B, 0x1F000000, 0x01000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x350013B7, 0xFD4169DD, 0xFF83BAFF, 0xFF4FA1FF, 0xFF2153CF, 0xFFAAA6C9, 0xFFEAE9EE, 0xFFF0F0F5, 0xFFF4F4F7, 0xFFCFCFD5, 0xFF9090A1, 0xFF85859D, 0xFF9595A7, 0xFFC8C8CF, 0xFFF4F4F5, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFD, 0xFFF8F8F9, 0xFFF3F3F7, 0xFFF2F2F6, 0xFFECECF2, 0xFFE9E9EE, 0xFFC4BFD4, 0xFF315FD0, 
        0xFF4C9EFF, 0xFF87B9FF, 0xFF3E7FDB, 0xB3002159, 0x37000000, 0x07000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x6C021CBA, 0xFF5384ED, 0xFF6BACFF, 0xFF2A84FC, 0xFF425DC0, 0xFFD5D1DC, 0xFFE9E9EF, 0xFFECECF1, 0xFFF1F1F5, 0xFFFAFAFD, 0xFFF7F7F7, 0xFFC7C7CE, 0xFF88889B, 0xFF85859C, 0xFFA1A1B0, 0xFFCFCFD3, 0xFFFEFEFE, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFE, 0xFFF5F5F8, 0xFFF1F1F5, 0xFFEDEDF2, 0xFFEAEAF0, 0xFFDEDBE3, 0xFF4E5FBB, 
        0xFF237BF9, 0xFF6AAAFF, 0xFF629CEE, 0xD3033179, 0x4F000000, 0x10000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x9D0827C1, 0xFF5E94F6, 0xFF4F9AFF, 0xFF146FF6, 0xFF707AC0, 0xFFE7E5E7, 0xFFEAEAF0, 0xFFEEEEF3, 0xFFF2F2F6, 0xFFF6F6F9, 0xFFFCFCFD, 0xFFFFFFFF, 0xFFEEEEEF, 0xFFB0B0BB, 0xFF88889D, 0xFF88889D, 0xFFB1B1BC, 0xFFDEDEE1, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEA8A8, 0xFFFDEFEF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF4F4F5, 0xFFE1E1E4, 0xFFCACAD1, 0xFFE2E2E6, 0xFFFBFBFC, 0xFFF2F2F6, 0xFFEEEEF3, 0xFFEAEAF0, 0xFFEBEAEB, 0xFF7678BA, 
        0xFF1061E9, 0xFF4697FF, 0xFF6FA9FB, 0xE50F4292, 0x63000000, 0x19000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xC70D2FCB, 0xFF5E9BFC, 0xFF398FFF, 0xFF0E63EC, 0xFF8C8FC3, 0xFFE9E8EB, 0xFFEBEBF1, 0xFFEEEEF3, 0xFFF3F3F6, 0xFFF7F7FA, 0xFFFCFCFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE1E1E4, 0xFF9A9AA9, 0xFF84849B, 0xFF9191A3, 
        0xFFBCBCC4, 0xFFF0F0F1, 0xFFFAFAFC, 0xFFFAF9FA, 0xFFFF9695, 0xFFF65F5E, 0xFFF3F0F0, 0xFFEFEFF0, 0xFFD6D6DB, 0xFFC0C0CA, 0xFF9C9CAB, 0xFF9393A6, 0xFF85859C, 0xFFAEAEB8, 0xFFFEFEFE, 0xFFF4F4F7, 0xFFEFEFF3, 0xFFECECF1, 0xFFEAE9ED, 0xFFA1A0C9, 
        0xFF1157DD, 0xFF328DFF, 0xFF5E9DFE, 0xF01C52A9, 0x72000000, 0x21000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xE2143DD3, 0xFF5496FE, 0xFF2685FF, 0xFF0A58E3, 0xFFA2A2CC, 0xFFEDECF0, 0xFFF0F0F6, 0xFFF2F2F7, 0xFFF3F3F7, 0xFFF8F8FA, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFD4D4D8, 0xFF9292A3, 
        0xFF828299, 0xFF9898A8, 0xFFAAABB8, 0xFF9E98A5, 0xFFB14E56, 0xFFB8A8B1, 0xFFB0B3C0, 0xFF9797AA, 0xFF8B8BA2, 0xFF7E7E96, 0xFF868699, 0xFFA4A4B0, 0xFFC2C2C9, 0xFFE7E7E9, 0xFFFAFAFC, 0xFFF4F4F7, 0xFFF3F3F7, 0xFFF1F1F6, 0xFFEEEDF2, 0xFFC0BCD3, 
        0xFF1351D5, 0xFF1980FF, 0xFF5598FF, 0xF7245DB7, 0x7C000000, 0x26000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xF01A44DA, 0xFF5195FE, 0xFF167DFF, 0xFF0653E2, 0xFF9F9FC1, 0xFFC7C5C7, 0xFFC4C4C9, 0xFFD6D6DA, 0xFFF5F5F8, 0xFFF9F9FB, 0xFFFDFDFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF6F6F6, 
        0xFFBBBBC3, 0xFF8A8B9B, 0xFFAAAAB1, 0xFF82828E, 0xFF636D7D, 0xFF83869B, 0xFF8F8FA2, 0xFF9F9FAD, 0xFFB5B5BE, 0xFFD2D2D6, 0xFFEFEFEF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF9F9FB, 0xFFF6F6F9, 0xFFD9D9DD, 0xFFC4C4C8, 0xFFC4C4C8, 0xFFB8B3C5, 
        0xFF1452D6, 0xFF0675FF, 0xFF5097FF, 0xFA2962C0, 0x84000000, 0x2A000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xF31B45DD, 0xFF4E94FE, 0xFF0F78FF, 0xFF0754E2, 0xFF9D9DBE, 0xFFBDBCBD, 0xFFBBBBBE, 0xFFD0D0D4, 0xFFF5F5F8, 0xFFF9F9FB, 0xFFFDFDFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFA1A7B2, 0xFF767783, 0xFF7D7D89, 0xFF838390, 0xFF8B8B96, 0xFFECECEC, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFF9F9FB, 0xFFF7F7FA, 0xFFD4D4D7, 0xFFBABABE, 0xFFBBBBBE, 0xFFB6B0C1, 
        0xFF1552D6, 0xFF0473FF, 0xFF4792FF, 0xFB2A60C0, 0x88000000, 0x2B000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xE41440DB, 0xFF4E94FE, 0xFF167CFF, 0xFF135CE2, 0xFFA6A6CD, 0xFFEEEDF1, 0xFFF1F1F7, 0xFFF3F3F8, 0xFFF4F4F7, 0xFFF8F8FA, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFF5F4, 0xFFE37A7E, 0xFFBEB8C0, 0xFFC5C8CD, 0xFF92929E, 0xFFAAAAB3, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFF9F9FB, 0xFFF4F4F8, 0xFFF4F4F9, 0xFFF2F2F7, 0xFFEEEEF4, 0xFFC3BFD4, 
        0xFF1B55D5, 0xFF117BFF, 0xFF4793FF, 0xF82455B5, 0x88000000, 0x2C000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xCD0C36D7, 0xFF5196FD, 0xFF2584FF, 0xFF226DEB, 0xFF9293C5, 0xFFE8E7EB, 0xFFEBEBF1, 0xFFEFEFF3, 0xFFF3F3F6, 0xFFF8F8FA, 0xFFFCFCFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFF9F9, 
        0xFFFC7979, 0xFFF39999, 0xFFF2F2F3, 0xFFEEEFF0, 0xFFF6F6F6, 0xFFFAFAFA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFE, 0xFFF8F8FA, 0xFFF4F4F7, 0xFFF0F0F4, 0xFFECECF1, 0xFFEAE9ED, 0xFFAAA6CA, 
        0xFF2360DC, 0xFF2083FF, 0xFF5098FF, 0xF31946A4, 0x85000000, 0x2A000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xA90630CF, 0xFF4C8FFB, 0xFF358CFF, 0xFF2B7AF5, 0xFF7E82BF, 0xFFE7E5E8, 0xFFEAEAF0, 0xFFEEEEF3, 0xFFF2F2F6, 0xFFF6F6F9, 0xFFFBFBFC, 0xFFFEFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFE9191, 
        0xFFF07B7B, 0xFFFBFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFBFD, 0xFFF7F7F9, 0xFFF2F2F6, 0xFFEEEEF3, 0xFFEBEBF1, 0xFFEBEAEC, 0xFF7F7FBC, 
        0xFF2C6FE7, 0xFF2F8AFF, 0xFF579BFC, 0xEA0D328B, 0x7D000000, 0x27000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x7B0229C5, 0xFF4481F6, 0xFF4597FF, 0xFF3788FC, 0xFF606EC0, 0xFFD5D2DE, 0xFFEAEAEF, 0xFFECECF2, 0xFFF1F1F5, 0xFFF5F5F8, 0xFFF9F9FB, 0xFFFDFDFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFA3A3, 0xFFF27676, 
        0xFFF9F9F9, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFAFAFB, 0xFFF6F6F8, 0xFFF1F1F5, 0xFFEDEDF3, 0xFFEAEAF0, 0xFFDEDCE4, 0xFF686DBA, 
        0xFF3B86F7, 0xFF4194FF, 0xFF4D8CED, 0xDE031E6E, 0x73000000, 0x22000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x490021B5, 0xFE346DF1, 0xFF529EFF, 0xFF4C9DFF, 0xFF4A67CB, 0xFFB1ACCC, 0xFFEAE9EE, 0xFFEBEBF1, 0xFFF0F0F5, 0xFFF3F3F7, 0xFFF7F7F9, 0xFFFBFBFC, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFC5C5, 0xFFF36D6D, 0xFFF6E8E8, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFCFCFD, 0xFFF8F8FA, 0xFFF3F3F7, 0xFFF1F1F5, 0xFFECECF2, 0xFFE9E9EE, 0xFFC5C1D6, 0xFF6077CD, 
        0xFF4D9BFF, 0xFF4E9DFF, 0xFF3469D3, 0xC900104B, 0x65000000, 0x1A000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x15001878, 0xEA1243E3, 0xFF529AFE, 0xFF519EFF, 0xFF6495EE, 0xFF8A89BF, 0xFFE6E6E9, 0xFFEDEDF4, 0xFFE6E6EB, 0xFFF0F0F5, 0xFFF5F5F8, 0xFFF8F8FB, 0xFFFCFCFD, 0xFFFFFFFF, 0xFFFFDADA, 0xFFF76464, 0xFFF4E0E0, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFE, 0xFFF9F9FB, 0xFFF6F6F9, 0xFFF2F2F6, 0xFFE6E6EB, 0xFFEDEDF3, 0xFFEAE9ED, 0xFF9E9CC7, 0xFF5B89E5, 
        0xFF52A0FF, 0xFF519CFF, 0xFD1A44B5, 0xAE000620, 0x52000000, 0x11000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x04000000, 0xAE012CD2, 0xFF3F81F9, 0xFF58A3FF, 0xFF6BABFF, 0xFF6E7BC9, 0xFFC4C2D4, 0xFFAEAEB0, 0xFFB7B7BB, 0xFFF0F0F5, 0xFFF3F3F6, 0xFFF6F5F8, 0xFFF9FFFF, 0xFFFFEBEB, 0xFFF87474, 0xFFF1CDCD, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFAFAFC, 0xFFF7F7F8, 0xFFF3F3F7, 0xFFF3F3F7, 0xFFC2C2C5, 0xFFAAAAAC, 0xFFCAC9D5, 0xFF6A70BE, 0xFF6BA6FB, 
        0xFF59A4FF, 0xFF4A8CF1, 0xE8041977, 0x8E000000, 0x3A000000, 0x07000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x49001FA0, 0xF9225CEE, 0xFF58A3FF, 0xFF6FB0FF, 0xFF7597E7, 0xFF7A77B1, 0xFFC0C0C3, 0xFFE8E8EE, 0xFFEEEEF3, 0xFFF0EFF3, 0xFFF3F7FB, 0xFFF7F1F3, 0xFFFA7C7D, 0xFFF0B4B5, 0xFFFEFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFDFE, 0xFFFAFAFC, 0xFFF7F7FA, 0xFFF4F4F7, 0xFFF1F1F4, 0xFFEDEDF3, 0xFFEBEBF1, 0xFFC8C8C9, 0xFF8582B0, 0xFF758FDF, 0xFF74B2FF, 
        0xFF5CA7FF, 0xFF2F5DCD, 0xC4000735, 0x6F000000, 0x22000000, 0x01000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x0C000000, 0xC00532D3, 0xFF478CFC, 0xFF67ABFF, 0xFF8EC1FF, 0xFF7883CD, 0xFFB6B4D2, 0xFFE9E9ED, 0xFFEAEAF0, 0xFFEDEFF4, 0xFFF1F3F7, 0xFFF99293, 0xFFEAA2A3, 0xFFF6FFFF, 0xFFFCFCFD, 0xFFFEFEFE, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFCFCFD, 0xFFF9F9FB, 0xFFF7F7F9, 0xFFF4F4F7, 0xFFF1F1F5, 0xFFEEEEF3, 0xFFEAEAF0, 0xFFEAEAEE, 0xFFC2C1D8, 0xFF7980C9, 0xFF8FBFFF, 0xFF69AEFF, 
        0xFF4A8DF2, 0xF3071A88, 0x9C000105, 0x4B000000, 0x0E000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x02000000, 0x52001F9D, 0xFD1852F1, 0xFF55A1FF, 0xFF7EB9FF, 0xFF9CC0F9, 0xFF6E6FBA, 0xFFC5C3D7, 0xFFEAEAEE, 0xFFE9F3F9, 0xFFF59EA1, 0xFFEB8D8E, 0xFFEFF5F9, 0xFFF6F8FA, 0xFFF8F8F9, 0xFFFAFAFB, 0xFFFBFBFD, 
        0xFFFDFDFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFDFDFE, 0xFFFBFBFD, 0xFFFAFAFB, 0xFFF8F8FA, 0xFFF6F6F8, 0xFFF3F3F7, 0xFFF0F0F5, 0xFFEDEDF2, 0xFFEBEBF1, 0xFFE9E9EF, 0xFFD4D4DF, 0xFF7271B8, 0xFF96B4F0, 0xFF86BDFF, 0xFF5BAAFF, 
        0xFE254BC0, 0xC9000335, 0x79000000, 0x2A000000, 0x03000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x0D000000, 0xA50027BE, 0xFF3578F8, 0xFF65ADFF, 0xFF9BCAFF, 0xFF9EB4EA, 0xFF7B7BBD, 0xFFCFD2E0, 0xFFF6B0B1, 0xFFEC898B, 0xFFE6E7EC, 0xFFF3F5FA, 0xFFF2F1F5, 0xFFF3F3F7, 0xFFF5F5F8, 0xFFF7F7F9, 
        0xFFF8F8FA, 0xFFF9F9FB, 0xFFF9F9FB, 0xFFF9F9FB, 0xFFF9F9FB, 0xFFF8F8FA, 0xFFF7F7F9, 0xFFF6F6F8, 0xFFF4F4F7, 0xFFF2F2F6, 0xFFF2F2F7, 0xFFEEEEF3, 0xFFEBEBF1, 0xFFE9E9EE, 0xFFD7D6E1, 0xFF807FBC, 0xFF9CADE5, 0xFFA2CEFF, 0xFF6AB2FF, 0xFF3B73E1, 
        0xE6030968, 0x97000000, 0x4C000000, 0x11000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x02000000, 0x25000C39, 0xE10634DB, 0xFF4189FC, 0xFF72B5FF, 0xFFB2D9FF, 0xFFA4B4E7, 0xFF7774B7, 0xFFD68B96, 0xFFE3D6D9, 0xFFEDF2F8, 0xFFBDBDC1, 0xFFDDDDE2, 0xFFF1F1F6, 0xFFF1F1F5, 0xFFF2F2F6, 
        0xFFF4F4F7, 0xFFF4F4F7, 0xFFF6F6F9, 0xFFF7F7FA, 0xFFF4F4F7, 0xFFF4F4F7, 0xFFF2F2F6, 0xFFF1F1F5, 0xFFF1F1F5, 0xFFE6E6EB, 0xFFC1C1C4, 0xFFEBEBF1, 0xFFE9E9EE, 0xFFD4D3DF, 0xFF807FBC, 0xFF9AA5DE, 0xFFB7DBFF, 0xFF7BBBFF, 0xFF488FF5, 0xF70A148D, 
        0xB3000018, 0x6A000000, 0x23000000, 0x03000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x07000000, 0x4F001774, 0xF00F41E3, 0xFF4995FD, 0xFF7FBCFF, 0xFFC1DFFF, 0xFFB8C7ED, 0xFF6D72BC, 0xFFB0B1D2, 0xFFD5D4D7, 0xFFAAAAAD, 0xFFE9E9EF, 0xFFEDEDF2, 0xFFEDEDF2, 0xFFEEEEF3, 
        0xFFEFEFF3, 0xFFF3F3F7, 0xFFD9D9DD, 0xFFD4D4D7, 0xFFF3F3F8, 0xFFF0F0F3, 0xFFEEEEF4, 0xFFEDEDF3, 0xFFEDEDF2, 0xFFEDEDF3, 0xFFAAAAAC, 0xFFC8C8C9, 0xFFBFBED8, 0xFF7171B8, 0xFFADB8E5, 0xFFC7E4FF, 0xFF87C2FF, 0xFF4D99F9, 0xFD1424A5, 0xC3000026, 
        0x81000000, 0x38000000, 0x0A000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0D000000, 0x72001C8C, 0xF61146E7, 0xFF4694FD, 0xFF80BEFF, 0xFFC7E4FF, 0xFFC9D6F4, 0xFF8B8DCB, 0xFF7D7CB3, 0xFFBCBCCF, 0xFFE9E9EC, 0xFFE9E9EE, 0xFFEAEAF0, 0xFFEBEBF0, 
        0xFFEBEBF1, 0xFFF1F1F7, 0xFFC4C4C9, 0xFFBBBBBE, 0xFFF2F2F8, 0xFFECECF1, 0xFFEBEBF0, 0xFFEAEAF0, 0xFFE9E9EE, 0xFFE9E9ED, 0xFFC7C7D5, 0xFF807FB0, 0xFF8688C8, 0xFFC3CEEF, 0xFFCEE8FF, 0xFF89C4FF, 0xFF4D99F9, 0xFC172FAF, 0xCF00003C, 0x8E000000, 
        0x48000000, 0x12000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x14000000, 0x7700187E, 0xF50F42E6, 0xFF3E8BFC, 0xFF74B9FF, 0xFFC1E1FF, 0xFFE7F3FF, 0xFFB7BCE5, 0xFF7778BF, 0xFF9392C3, 0xFFB9B9D3, 0xFFD7D7E2, 0xFFE8E8EB, 
        0xFFE8E8ED, 0xFFEDEDF3, 0xFFC4C4C8, 0xFFBBBBBE, 0xFFEEEEF4, 0xFFE8E8ED, 0xFFE9E9EB, 0xFFDBDAE4, 0xFFBDBDD6, 0xFF9998C5, 0xFF7676BD, 0xFFAAAEDE, 0xFFE7F2FF, 0xFFC9E5FF, 0xFF7FC0FF, 0xFF448FF5, 0xFC1227AD, 0xCF00003F, 0x91000000, 0x52000000, 
        0x19000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x17000000, 0x69001464, 0xE50633D1, 0xFF2D72F8, 0xFF5DABFF, 0xFF9DD0FF, 0xFFE3F4FF, 0xFFECF1FD, 0xFFC5C9E8, 0xFF9899D0, 0xFF7475BA, 0xFF7D7DBA, 
        0xFFA09FC9, 0xFFB7B7D3, 0xFFACACC5, 0xFFA9A9C2, 0xFFB9B9D4, 0xFFA3A3CA, 0xFF8282BC, 0xFF7474B9, 0xFF9494CD, 0xFFBFC0E4, 0xFFEBEEFC, 0xFFE8F6FF, 0xFFA6D5FF, 0xFF63B2FF, 0xFF3370E5, 0xF609179A, 0xC400012C, 0x8D000000, 0x51000000, 0x1C000000, 
        0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x15000000, 0x50000E40, 0xC40023AC, 0xFD1854EF, 0xFF3B88FB, 0xFF70B6FF, 0xFFA8D7FF, 0xFFDDF2FF, 0xFFFEFFFF, 0xFFEEEDF8, 0xFFCCCDE9, 
        0xFFB4B4DD, 0xFFA4A4D6, 0xFFA3A4D6, 0xFFA4A4D7, 0xFFA4A4D5, 0xFFB1B1DC, 0xFFC8C8E7, 0xFFEAEAF7, 0xFFFEFFFF, 0xFFE4F5FF, 0xFFAFDBFF, 0xFF78BDFF, 0xFF408AF4, 0xFF1C46CE, 0xE6010A74, 0xB400011C, 0x80000000, 0x48000000, 0x19000000, 0x04000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x0F000000, 0x32000000, 0x8C00156E, 0xE3022CC7, 0xFE1B5AF3, 0xFF3987FB, 0xFF59A7FF, 0xFF8CC9FF, 0xFFBCE2FF, 0xFFDBF2FF, 
        0xFFF2FEFF, 0xFFFCFFFF, 0xFFFEFFFF, 0xFFFEFFFF, 0xFFFCFFFF, 0xFFF4FFFF, 0xFFDFF4FF, 0xFFC0E5FF, 0xFF93CEFF, 0xFF5DABFF, 0xFF3C88F4, 0xFF1F51D9, 0xF2031498, 0xC9000440, 0x97000000, 0x6A000000, 0x38000000, 0x13000000, 0x02000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x08000000, 0x20000000, 0x49000107, 0x94001360, 0xD70024AA, 0xF90C41E3, 0xFF1B5DF1, 0xFF347EF8, 0xFF4C99FD, 
        0xFF58A6FF, 0xFF66B1FF, 0xFF71B8FF, 0xFF72B9FF, 0xFF67B2FF, 0xFF5AA7FE, 0xFF4E9BFD, 0xFF377FF3, 0xFF1E58E1, 0xFC0F35C9, 0xE7011389, 0xC5000641, 0x9B000107, 0x79000000, 0x4C000000, 0x23000000, 0x0A000000, 0x01000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x0F000000, 0x26000000, 0x46000000, 0x7C000C39, 0xB3001471, 0xD3001D96, 0xE50328B1, 
        0xF00A36C5, 0xF71041D3, 0xFA1246DA, 0xFB1346D9, 0xF8103ECE, 0xF30B32BC, 0xEA0421A2, 0xDD001381, 0xC9000B5B, 0xAF000529, 0x8D000000, 0x6E000000, 0x4B000000, 0x2A000000, 0x11000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x0D000000, 0x1F000000, 0x37000000, 0x4F000000, 0x63000000, 
        0x71000000, 0x7C000000, 0x84000000, 0x88000000, 0x88000000, 0x85000000, 0x7D000000, 0x73000000, 0x64000000, 0x52000000, 0x3A000000, 0x22000000, 0x0F000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x07000000, 0x10000000, 0x19000000, 
        0x21000000, 0x26000000, 0x2A000000, 0x2B000000, 0x2C000000, 0x2A000000, 0x27000000, 0x22000000, 0x1A000000, 0x11000000, 0x07000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF
#else
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF59D1D00, 0xC9981900, 0x939A2500, 0x62A13108, 
        0x38AA3E10, 0x1DB44F20, 0x0FBC5B29, 0x0DBD5F2A, 0x1BB85821, 0x32B14D13, 0x56A84508, 0x849D3D00, 0xB58E3400, 0xE96C2A00, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xD8920F00, 0x6A971600, 0x24A93B1C, 0x03CB7E60, 0x00E2AA8C, 0x00F1CAAB, 
        0x00FADEC2, 0x00FCE3C8, 0x00FDE5CB, 0x00FEE5CB, 0x00FDE3C9, 0x00FBDFC3, 0x00F4D1AF, 0x00E9B790, 0x02D99667, 0x17BB6223, 0x52A44300, 0xB4813300, 0xF3000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCD8A0600, 0x62951606, 0x0EB95A43, 0x00DFA286, 0x00F9D9BC, 0x00FFF5DE, 0x00FFF9E7, 0x00FFF6E5, 
        0x00FFF6E4, 0x00FFF7E4, 0x00FFF7E4, 0x00FFF7E5, 0x00FFF7E4, 0x00FFF6E4, 0x00FFF6E5, 0x00FFF7E6, 0x00FFF4E0, 0x00FCE0C2, 0x00EAB78C, 0x06D1854C, 0x40A74D0A, 0xAB7F3300, 0xF2000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF98D0100, 0x8E8A0200, 0x0DAB3E30, 0x00E4AD92, 0x00FFEACC, 0x00FFF3DC, 0x00FFF6E4, 0x00FFF6E0, 0x00FDDFC4, 0x00F5CBAB, 
        0x00ECB99C, 0x00E3A88E, 0x00E2A48B, 0x00E2A48B, 0x00E2A88D, 0x00EBB79B, 0x00F4C9A9, 0x00FCDCC0, 0x00FFF4DE, 0x00FFF6E5, 0x00FFF1DD, 0x00FFE9D0, 0x00F3C79F, 0x03CC7939, 0x5B953F00, 0xD6361600, 0xF8000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE3830000, 0x438E0B09, 0x00CF816C, 0x00FDDBB8, 0x00FFF0D9, 0x00FFF2DD, 0x00FFE4C3, 0x00F0BB98, 0x00CE7D65, 0x00BF7366, 0x00C08480, 
        0x00C49391, 0x00CCA3A2, 0x00C19D9D, 0x00BE9C9B, 0x00CDA5A4, 0x00C49593, 0x00C08682, 0x00BF7569, 0x00CB7762, 0x00EDB492, 0x00FFE0BF, 0x00FFF1DB, 0x00FFEEDC, 0x00FFDFBF, 0x00E7AB79, 0x20AE520E, 0xAE5F2700, 0xF1000000, 0xFE000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCF8B0000, 0x28991F1C, 0x00E09F84, 0x00FFE9C8, 0x00FFECD4, 0x00FFE3C1, 0x00EAA884, 0x00CA7B67, 0x00BF817C, 0x00C9A2A4, 0x00DCCDCF, 0x00E7E2E3, 
        0x00EBE6E7, 0x00F0EBEC, 0x00C7C3C4, 0x00BEBBBB, 0x00F2ECED, 0x00EAE6E6, 0x00E8E4E5, 0x00DDD1D2, 0x00CCA8AA, 0x00C08380, 0x00C87968, 0x00E69F7D, 0x00FFDFBC, 0x00FFEBD5, 0x00FFE5CC, 0x00F2BF92, 0x10BB6522, 0x8B6E2C00, 0xEB000000, 0xFC000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xD18F0000, 0x1B9F2019, 0x00EEB695, 0x00FFE7C7, 0x00FFE9CF, 0x00FBC598, 0x00D37D60, 0x00B16967, 0x00CEB8BA, 0x00E8E3E4, 0x00EEEAEA, 0x00EFE9E9, 0x00F0EAEA, 
        0x00F1EBEB, 0x00F6F0F0, 0x00C9C4C4, 0x00BEBABA, 0x00F7F1F1, 0x00F1EBEB, 0x00F0EAEA, 0x00EFEAEA, 0x00EEE9E9, 0x00EAE5E6, 0x00D4C2C5, 0x00B17270, 0x00CD755B, 0x00F8BE91, 0x00FFE7CB, 0x00FFE3CA, 0x00F9CBA1, 0x09C36C27, 0x89622700, 0xE8000000, 
        0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE5940200, 0x25A4221A, 0x00F0B38F, 0x00FFE3C4, 0x00FFE0BC, 0x00F2AB79, 0x00BC6354, 0x00CCA6A8, 0x00D1CDCE, 0x00B1AFAF, 0x00F1EBEB, 0x00F1ECEC, 0x00F1ECEC, 0x00F3EDED, 
        0x00F3EEEE, 0x00F7F2F2, 0x00DAD7D7, 0x00D4D1D1, 0x00F8F3F3, 0x00F3EFEF, 0x00F3EDED, 0x00F2EDED, 0x00F1EBEB, 0x00F4EDED, 0x00B1AEAE, 0x00C3C1C1, 0x00D3B5B8, 0x00BA6458, 0x00EA9C6E, 0x00FFDFB6, 0x00FFE1C5, 0x00F8C598, 0x09C16924, 0x984B1E00, 
        0xEB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xF9A10900, 0x429F110A, 0x00E69A78, 0x00FFDEB8, 0x00FFDAB2, 0x00EC9C6B, 0x00BC6A5D, 0x00D3BCBF, 0x00EBE8E8, 0x00F1EAEA, 0x00B8B4B4, 0x00E2DDDD, 0x00F5F1F1, 0x00F5F0F0, 0x00F6F2F2, 
        0x00F6F3F3, 0x00F7F3F3, 0x00F8F5F5, 0x00F8F5F5, 0x00F7F3F3, 0x00F6F3F3, 0x00F6F2F2, 0x00F5F1F1, 0x00F5F0F0, 0x00EBE6E6, 0x00BBB8B8, 0x00EEE8E8, 0x00EDE9EA, 0x00D8C8CA, 0x00BD7168, 0x00E58E5F, 0x00FFD7AD, 0x00FFDBBB, 0x00F5B989, 0x19A9520F, 
        0xAF321500, 0xF0000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0x8D9E0700, 0x00D87A5C, 0x00FFD7AE, 0x00FFD8B2, 0x00F39E63, 0x00BD685B, 0x00D7C8CC, 0x00EDE8E8, 0x00F0E9E9, 0x00F2ECEC, 0x00F4EFEF, 0x00F3F0F0, 0x00F7F3F3, 0x00F8F4F4, 0x00F8F6F6, 
        0x00FAF7F7, 0x00FAF8F8, 0x00FBF9F9, 0x00FBF9F9, 0x00FAF8F8, 0x00FAF8F8, 0x00F9F6F6, 0x00F8F5F5, 0x00F7F3F3, 0x00F4F0F0, 0x00F5F0F0, 0x00F3EEEE, 0x00F1EAEA, 0x00EDEAEA, 0x00DCD2D5, 0x00B96B64, 0x00EE945C, 0x00FFD4A8, 0x00FFD4B1, 0x00E7A067, 
        0x3A883A03, 0xCD000000, 0xF7000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xD2A50900, 0x0BBC3C25, 0x00FEC295, 0x00FFD2A9, 0x00FBA968, 0x00BD5E4B, 0x00D3BDC1, 0x00EDE8E8, 0x00F0EAEA, 0x00F2ECEC, 0x00F4EFEF, 0x00F7F3F3, 0x00F8F5F5, 0x00F9F7F7, 0x00FAF9F9, 0x00FCFAFA, 
        0x00FDFCFC, 0x00FDFDFD, 0x00FEFDFD, 0x00FEFDFD, 0x00FDFDFD, 0x00FDFCFC, 0x00FCFBFB, 0x00FBF9F9, 0x00F9F7F7, 0x00F8F5F5, 0x00F6F2F2, 0x00F4F0F0, 0x00F2EDED, 0x00F0EAEA, 0x00EDE9E9, 0x00DBCFD1, 0x00B95F51, 0x00F49A5C, 0x00FFD2A8, 0x00FFCA9F, 
        0x02D17D3A, 0x75532200, 0xE0000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0x60AD1708, 0x00EB986F, 0x00FFD1A8, 0x00FFBA7C, 0x00D46A40, 0x00CCA8AB, 0x00EFECEC, 0x00F1EAEA, 0x00F2ECEC, 0x00F5F0F0, 0x00F6F3F3, 0x00F9F5F5, 0x00FBF8F8, 0x00FCFBFB, 0x00FDFDFD, 0x00FFFEFE, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFDFD, 0x00FCFBFB, 0x00FBF8F8, 0x00F9F6F6, 0x00F7F3F3, 0x00F5F0F0, 0x00F2EDED, 0x00F0EAEA, 0x00EDE9E9, 0x00D1B4B9, 0x00CC6847, 0x00FFB16E, 0x00FFCDA5, 
        0x00F3AD77, 0x1AA14A08, 0xB5070300, 0xF0000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xDAAD0E00, 0x0CCB5032, 0x00FFC393, 0x00FFC18A, 0x00EC7F3E, 0x00B16865, 0x00B3ACAD, 0x00CDC2C2, 0x00EEE9E9, 0x00F8F4F4, 0x00F7F3F3, 0x00F8F6F6, 0x00FBF9F9, 0x00FEFCFC, 0x00FFFEFE, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFCFC, 0x00FCFAFA, 0x00F9F7F7, 0x00F7F4F4, 0x00F4F0F0, 0x00F2EDED, 0x00F3EDED, 0x00D7D6D8, 0x00B27A78, 0x00E67739, 0x00FFC089, 
        0x00FFC79B, 0x00D98543, 0x6B481D00, 0xD8000000, 0xFC000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0x6AB21301, 0x00E88559, 0x00FFC08F, 0x00FFA358, 0x00CD6643, 0x00C5B2B7, 0x00918080, 0x00A18C8C, 0x00B3A5A5, 0x00DBD5D5, 0x00FCFAFA, 0x00FFFEFE, 0x00FEFDFD, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFDFD, 0x00FCF9F9, 0x00F9F6F6, 0x00F7F3F3, 0x00F7F2F2, 0x00C1BDBD, 0x00ACAAAA, 0x00CFC1C5, 0x00C05D47, 0x00FC994B, 
        0x00FFBC8A, 0x00F3A76F, 0x278A3D04, 0xB9000000, 0xF2000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xF7BD1700, 0x22C13115, 0x00FBAD7C, 0x00FFB87E, 0x00F27C30, 0x00C07B73, 0x00E8E5E7, 0x00DAD3D3, 0x00AFA1A1, 0x009A8484, 0x00A28F8F, 0x00C1B7B7, 0x00E7E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFCFC, 0x00FBF9F9, 0x00F8F5F5, 0x00F6F2F2, 0x00E2DDDD, 0x00EFE9E9, 0x00EDEAEB, 0x00C3908E, 0x00E9732D, 
        0x00FFB06F, 0x00FEB17D, 0x04C16421, 0x832B1200, 0xE0000000, 0xFE000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xCAB71300, 0x02DD6941, 0x00FFBA83, 0x00FFA14F, 0x00CF5321, 0x00C9A6AA, 0x00EEE9EA, 0x00F5F0F0, 0x00F7F4F4, 0x00D5CFCF, 0x00A19090, 0x009D8585, 0x00A79595, 0x00CFC8C8, 0x00F5F4F4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FDFCFC, 0x00F9F8F8, 0x00F7F3F3, 0x00F6F2F2, 0x00F2ECEC, 0x00EEE9E9, 0x00D4BFC4, 0x00D05F31, 
        0x00FF9E4C, 0x00FFB987, 0x00DB7F3E, 0x4C592100, 0xC8000000, 0xF8000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x93BA1C02, 0x00ED8453, 0x00FFAC6B, 0x00FC842A, 0x00C05D42, 0x00DCD1D5, 0x00EFE9E9, 0x00F1ECEC, 0x00F5F1F1, 0x00FDFAFA, 0x00F7F7F7, 0x00CEC7C7, 0x009B8888, 0x009C8585, 0x00B0A1A1, 0x00D3CFCF, 0x00FEFEFE, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFDFD, 0x00F8F5F5, 0x00F5F1F1, 0x00F2EDED, 0x00F0EAEA, 0x00E3DBDE, 0x00BB5F4E, 
        0x00F97B23, 0x00FFAA6A, 0x00EE9C62, 0x2C793103, 0xB0000000, 0xEF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x62C12708, 0x00F6945E, 0x00FF9A4F, 0x00F66F14, 0x00C07A70, 0x00E7E5E7, 0x00F0EAEA, 0x00F3EEEE, 0x00F6F2F2, 0x00F9F6F6, 0x00FDFCFC, 0x00FFFFFF, 0x00EFEEEE, 0x00BBB0B0, 0x009D8888, 0x009D8888, 0x00BCB1B1, 0x00E1DEDE, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00A8A8FE, 0x00EFEFFD, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F5F4F4, 0x00E4E1E1, 0x00D1CACA, 0x00E6E2E2, 0x00FCFBFB, 0x00F6F2F2, 0x00F3EEEE, 0x00F0EAEA, 0x00EBEAEB, 0x00BA7876, 
        0x00E96110, 0x00FF9746, 0x00FBA96F, 0x1A92420F, 0x9C000000, 0xE6000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x38CB2F0D, 0x00FC9B5E, 0x00FF8F39, 0x00EC630E, 0x00C38F8C, 0x00EBE8E9, 0x00F1EBEB, 0x00F3EEEE, 0x00F6F3F3, 0x00FAF7F7, 0x00FDFCFC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E4E1E1, 0x00A99A9A, 0x009B8484, 0x00A39191, 
        0x00C4BCBC, 0x00F1F0F0, 0x00FCFAFA, 0x00FAF9FA, 0x009596FF, 0x005E5FF6, 0x00F0F0F3, 0x00F0EFEF, 0x00DBD6D6, 0x00CAC0C0, 0x00AB9C9C, 0x00A69393, 0x009C8585, 0x00B8AEAE, 0x00FEFEFE, 0x00F7F4F4, 0x00F3EFEF, 0x00F1ECEC, 0x00EDE9EA, 0x00C9A0A1, 
        0x00DD5711, 0x00FF8D32, 0x00FE9D5E, 0x0FA9521C, 0x8D000000, 0xDE000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x1DD33D14, 0x00FE9654, 0x00FF8526, 0x00E3580A, 0x00CCA2A2, 0x00F0ECED, 0x00F6F0F0, 0x00F7F2F2, 0x00F7F3F3, 0x00FAF8F8, 0x00FDFDFD, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D8D4D4, 0x00A39292, 
        0x00998282, 0x00A89898, 0x00B8ABAA, 0x00A5989E, 0x00564EB1, 0x00B1A8B8, 0x00C0B3B0, 0x00AA9797, 0x00A28B8B, 0x00967E7E, 0x00998686, 0x00B0A4A4, 0x00C9C2C2, 0x00E9E7E7, 0x00FCFAFA, 0x00F7F4F4, 0x00F7F3F3, 0x00F6F1F1, 0x00F2EDEE, 0x00D3BCC0, 
        0x00D55113, 0x00FF8019, 0x00FF9855, 0x08B75D24, 0x83000000, 0xD9000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x0FDA441A, 0x00FE9551, 0x00FF7D16, 0x00E25306, 0x00C19F9F, 0x00C7C5C7, 0x00C9C4C4, 0x00DAD6D6, 0x00F8F5F5, 0x00FBF9F9, 0x00FEFDFD, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F6F6F6, 
        0x00C3BBBB, 0x009B8B8A, 0x00B1AAAA, 0x008E8282, 0x007D6D63, 0x009B8683, 0x00A28F8F, 0x00AD9F9F, 0x00BEB5B5, 0x00D6D2D2, 0x00EFEFEF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FBF9F9, 0x00F9F6F6, 0x00DDD9D9, 0x00C8C4C4, 0x00C8C4C4, 0x00C5B3B8, 
        0x00D65214, 0x00FF7506, 0x00FF9750, 0x05C06229, 0x7B000000, 0xD5000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x0CDD451B, 0x00FE944E, 0x00FF780F, 0x00E25407, 0x00BE9D9D, 0x00BDBCBD, 0x00BEBBBB, 0x00D4D0D0, 0x00F8F5F5, 0x00FBF9F9, 0x00FEFDFD, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00B2A7A1, 0x00837776, 0x00897D7D, 0x00908383, 0x00968B8B, 0x00ECECEC, 0x00FEFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FBF9F9, 0x00FAF7F7, 0x00D7D4D4, 0x00BEBABA, 0x00BEBBBB, 0x00C1B0B6, 
        0x00D65215, 0x00FF7304, 0x00FF9247, 0x04C0602A, 0x77000000, 0xD4000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x1BDB4014, 0x00FE944E, 0x00FF7C16, 0x00E25C13, 0x00CDA6A6, 0x00F1EDEE, 0x00F7F1F1, 0x00F8F3F3, 0x00F7F4F4, 0x00FAF8F8, 0x00FDFDFD, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00F4F5FF, 0x007E7AE3, 0x00C0B8BE, 0x00CDC8C5, 0x009E9292, 0x00B3AAAA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FBF9F9, 0x00F8F4F4, 0x00F9F4F4, 0x00F7F2F2, 0x00F4EEEE, 0x00D4BFC3, 
        0x00D5551B, 0x00FF7B11, 0x00FF9347, 0x07B55524, 0x77000000, 0xD3000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x32D7360C, 0x00FD9651, 0x00FF8425, 0x00EB6D22, 0x00C59392, 0x00EBE7E8, 0x00F1EBEB, 0x00F3EFEF, 0x00F6F3F3, 0x00FAF8F8, 0x00FDFCFC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F9F9FF, 
        0x007979FC, 0x009999F3, 0x00F3F2F2, 0x00F0EFEE, 0x00F6F6F6, 0x00FAFAFA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFDFD, 0x00FAF8F8, 0x00F7F4F4, 0x00F4F0F0, 0x00F1ECEC, 0x00EDE9EA, 0x00CAA6AA, 
        0x00DC6023, 0x00FF8320, 0x00FF9850, 0x0CA44619, 0x7A000000, 0xD5000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x56CF3006, 0x00FB8F4C, 0x00FF8C35, 0x00F57A2B, 0x00BF827E, 0x00E8E5E7, 0x00F0EAEA, 0x00F3EEEE, 0x00F6F2F2, 0x00F9F6F6, 0x00FCFBFB, 0x00FFFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x009191FE, 
        0x007B7BF0, 0x00FFFFFB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FDFBFB, 0x00F9F7F7, 0x00F6F2F2, 0x00F3EEEE, 0x00F1EBEB, 0x00ECEAEB, 0x00BC7F7F, 
        0x00E76F2C, 0x00FF8A2F, 0x00FC9B57, 0x158B320D, 0x82000000, 0xD8000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x84C52902, 0x00F68144, 0x00FF9745, 0x00FC8837, 0x00C06E60, 0x00DED2D5, 0x00EFEAEA, 0x00F2ECEC, 0x00F5F1F1, 0x00F8F5F5, 0x00FBF9F9, 0x00FEFDFD, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00A3A3FF, 0x007676F2, 
        0x00F9F9F9, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FBFAFA, 0x00F8F6F6, 0x00F5F1F1, 0x00F3EDED, 0x00F0EAEA, 0x00E4DCDE, 0x00BA6D68, 
        0x00F7863B, 0x00FF9441, 0x00ED8C4D, 0x216E1E03, 0x8C000000, 0xDD000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xB6B52100, 0x01F16D34, 0x00FF9E52, 0x00FF9D4C, 0x00CB674A, 0x00CCACB1, 0x00EEE9EA, 0x00F1EBEB, 0x00F5F0F0, 0x00F7F3F3, 0x00F9F7F7, 0x00FCFBFB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00C5C5FF, 0x006D6DF3, 0x00E8E8F6, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FDFCFC, 0x00FAF8F8, 0x00F7F3F3, 0x00F5F1F1, 0x00F2ECEC, 0x00EEE9E9, 0x00D6C1C5, 0x00CD7760, 
        0x00FF9B4D, 0x00FF9D4E, 0x00D36934, 0x364B1000, 0x9A000000, 0xE5000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xEA781800, 0x15E34312, 0x00FE9A52, 0x00FF9E51, 0x00EE9564, 0x00BF898A, 0x00E9E6E6, 0x00F4EDED, 0x00EBE6E6, 0x00F5F0F0, 0x00F8F5F5, 0x00FBF8F8, 0x00FDFCFC, 0x00FFFFFF, 0x00DADAFF, 0x006464F7, 0x00E0E0F4, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFDFD, 0x00FBF9F9, 0x00F9F6F6, 0x00F6F2F2, 0x00EBE6E6, 0x00F3EDED, 0x00EDE9EA, 0x00C79C9E, 0x00E5895B, 
        0x00FFA052, 0x00FF9C51, 0x02B5441A, 0x51200600, 0xAD000000, 0xEE000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFB000000, 0x51D22C01, 0x00F9813F, 0x00FFA358, 0x00FFAB6B, 0x00C97B6E, 0x00D4C2C4, 0x00B0AEAE, 0x00BBB7B7, 0x00F5F0F0, 0x00F6F3F3, 0x00F8F5F6, 0x00FFFFF9, 0x00EBEBFF, 0x007474F8, 0x00CDCDF1, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FCFAFA, 0x00F8F7F7, 0x00F7F3F3, 0x00F7F3F3, 0x00C5C2C2, 0x00ACAAAA, 0x00D5C9CA, 0x00BE706A, 0x00FBA66B, 
        0x00FFA459, 0x00F18C4A, 0x17771904, 0x71000000, 0xC5000000, 0xF8000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xB6A01F00, 0x06EE5C22, 0x00FFA358, 0x00FFB06F, 0x00E79775, 0x00B1777A, 0x00C3C0C0, 0x00EEE8E8, 0x00F3EEEE, 0x00F3EFF0, 0x00FBF7F3, 0x00F3F1F7, 0x007D7CFA, 0x00B5B4F0, 0x00FFFFFE, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFDFD, 0x00FCFAFA, 0x00FAF7F7, 0x00F7F4F4, 0x00F4F1F1, 0x00F3EDED, 0x00F1EBEB, 0x00C9C8C8, 0x00B08285, 0x00DF8F75, 0x00FFB274, 
        0x00FFA75C, 0x00CD5D2F, 0x3B350700, 0x90000000, 0xDD000000, 0xFE000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xF3000000, 0x3FD33205, 0x00FC8C47, 0x00FFAB67, 0x00FFC18E, 0x00CD8378, 0x00D2B4B6, 0x00EDE9E9, 0x00F0EAEA, 0x00F4EFED, 0x00F7F3F1, 0x009392F9, 0x00A3A2EA, 0x00FFFFF6, 0x00FDFCFC, 0x00FEFEFE, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00FDFCFC, 0x00FBF9F9, 0x00F9F7F7, 0x00F7F4F4, 0x00F5F1F1, 0x00F3EEEE, 0x00F0EAEA, 0x00EEEAEA, 0x00D8C1C2, 0x00C98079, 0x00FFBF8F, 0x00FFAE69, 
        0x00F28D4A, 0x0C881A07, 0x63050100, 0xB4000000, 0xF1000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFD000000, 0xAD9D1F00, 0x02F15218, 0x00FFA155, 0x00FFB97E, 0x00F9C09C, 0x00BA6F6E, 0x00D7C3C5, 0x00EEEAEA, 0x00F9F3E9, 0x00A19EF5, 0x008E8DEB, 0x00F9F5EF, 0x00FAF8F6, 0x00F9F8F8, 0x00FBFAFA, 0x00FDFBFB, 
        0x00FEFDFD, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFDFD, 0x00FDFBFB, 0x00FBFAFA, 0x00FAF8F8, 0x00F8F6F6, 0x00F7F3F3, 0x00F5F0F0, 0x00F2EDED, 0x00F1EBEB, 0x00EFE9E9, 0x00DFD4D4, 0x00B87172, 0x00F0B496, 0x00FFBD86, 0x00FFAA5B, 
        0x01C04B25, 0x36350300, 0x86000000, 0xD5000000, 0xFC000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xF2000000, 0x5ABE2700, 0x00F87835, 0x00FFAD65, 0x00FFCA9B, 0x00EAB49E, 0x00BD7B7B, 0x00E0D2CF, 0x00B1B0F6, 0x008B89EC, 0x00ECE7E6, 0x00FAF5F3, 0x00F5F1F2, 0x00F7F3F3, 0x00F8F5F5, 0x00F9F7F7, 
        0x00FAF8F8, 0x00FBF9F9, 0x00FBF9F9, 0x00FBF9F9, 0x00FBF9F9, 0x00FAF8F8, 0x00F9F7F7, 0x00F8F6F6, 0x00F7F4F4, 0x00F6F2F2, 0x00F7F2F2, 0x00F3EEEE, 0x00F1EBEB, 0x00EEE9E9, 0x00E1D6D7, 0x00BC7F80, 0x00E5AD9C, 0x00FFCEA2, 0x00FFB26A, 0x00E1733B, 
        0x19680903, 0x68000000, 0xB3000000, 0xEE000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFD000000, 0xDA390C00, 0x1EDB3406, 0x00FC8941, 0x00FFB572, 0x00FFD9B2, 0x00E7B4A4, 0x00B77477, 0x00968BD6, 0x00D9D6E3, 0x00F8F2ED, 0x00C1BDBD, 0x00E2DDDD, 0x00F6F1F1, 0x00F5F1F1, 0x00F6F2F2, 
        0x00F7F4F4, 0x00F7F4F4, 0x00F9F6F6, 0x00FAF7F7, 0x00F7F4F4, 0x00F7F4F4, 0x00F6F2F2, 0x00F5F1F1, 0x00F5F1F1, 0x00EBE6E6, 0x00C4C1C1, 0x00F1EBEB, 0x00EEE9E9, 0x00DFD3D4, 0x00BC7F80, 0x00DEA59A, 0x00FFDBB7, 0x00FFBB7B, 0x00F58F48, 0x088D140A, 
        0x4C180000, 0x95000000, 0xDC000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xF8000000, 0xB0741700, 0x0FE3410F, 0x00FD9549, 0x00FFBC7F, 0x00FFDFC1, 0x00EDC7B8, 0x00BC726D, 0x00D2B1B0, 0x00D7D4D5, 0x00ADAAAA, 0x00EFE9E9, 0x00F2EDED, 0x00F2EDED, 0x00F3EEEE, 
        0x00F3EFEF, 0x00F7F3F3, 0x00DDD9D9, 0x00D7D4D4, 0x00F8F3F3, 0x00F3F0F0, 0x00F4EEEE, 0x00F3EDED, 0x00F2EDED, 0x00F3EDED, 0x00ACAAAA, 0x00C9C8C8, 0x00D8BEBF, 0x00B87171, 0x00E5B8AD, 0x00FFE4C7, 0x00FFC287, 0x00F9994D, 0x02A52414, 0x3C260000, 
        0x7E000000, 0xC7000000, 0xF5000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF2000000, 0x8D8C1C00, 0x09E74611, 0x00FD9446, 0x00FFBE80, 0x00FFE4C7, 0x00F4D6C9, 0x00CB8D8B, 0x00B37C7D, 0x00CFBCBC, 0x00ECE9E9, 0x00EEE9E9, 0x00F0EAEA, 0x00F0EBEB, 
        0x00F1EBEB, 0x00F7F1F1, 0x00C9C4C4, 0x00BEBBBB, 0x00F8F2F2, 0x00F1ECEC, 0x00F0EBEB, 0x00F0EAEA, 0x00EEE9E9, 0x00EDE9E9, 0x00D5C7C7, 0x00B07F80, 0x00C88886, 0x00EFCEC3, 0x00FFE8CE, 0x00FFC489, 0x00F9994D, 0x03AF2F17, 0x303C0000, 0x71000000, 
        0xB7000000, 0xED000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xEB000000, 0x887E1800, 0x0AE6420F, 0x00FC8B3E, 0x00FFB974, 0x00FFE1C1, 0x00FFF3E7, 0x00E5BCB7, 0x00BF7877, 0x00C39293, 0x00D3B9B9, 0x00E2D7D7, 0x00EBE8E8, 
        0x00EDE8E8, 0x00F3EDED, 0x00C8C4C4, 0x00BEBBBB, 0x00F4EEEE, 0x00EDE8E8, 0x00EBE9E9, 0x00E4DADB, 0x00D6BDBD, 0x00C59899, 0x00BD7676, 0x00DEAEAA, 0x00FFF2E7, 0x00FFE5C9, 0x00FFC07F, 0x00F58F44, 0x03AD2712, 0x303F0000, 0x6E000000, 0xAD000000, 
        0xE6000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0xE8000000, 0x96641400, 0x1AD13306, 0x00F8722D, 0x00FFAB5D, 0x00FFD09D, 0x00FFF4E3, 0x00FDF1EC, 0x00E8C9C5, 0x00D09998, 0x00BA7574, 0x00BA7D7D, 
        0x00C99FA0, 0x00D3B7B7, 0x00C5ACAC, 0x00C2A9A9, 0x00D4B9B9, 0x00CAA3A3, 0x00BC8282, 0x00B97474, 0x00CD9494, 0x00E4C0BF, 0x00FCEEEB, 0x00FFF6E8, 0x00FFD5A6, 0x00FFB263, 0x00E57033, 0x099A1709, 0x3B2C0100, 0x72000000, 0xAE000000, 0xE3000000, 
        0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0xEA000000, 0xAF400E00, 0x3BAC2300, 0x02EF5418, 0x00FB883B, 0x00FFB670, 0x00FFD7A8, 0x00FFF2DD, 0x00FFFFFE, 0x00F8EDEE, 0x00E9CDCC, 
        0x00DDB4B4, 0x00D6A4A4, 0x00D6A4A3, 0x00D7A4A4, 0x00D5A4A4, 0x00DCB1B1, 0x00E7C8C8, 0x00F7EAEA, 0x00FFFFFE, 0x00FFF5E4, 0x00FFDBAF, 0x00FFBD78, 0x00F48A40, 0x00CE461C, 0x19740A01, 0x4B1C0100, 0x7F000000, 0xB7000000, 0xE6000000, 0xFB000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF0000000, 0xCD000000, 0x736E1500, 0x1CC72C02, 0x01F35A1B, 0x00FB8739, 0x00FFA759, 0x00FFC98C, 0x00FFE2BC, 0x00FFF2DB, 
        0x00FFFEF2, 0x00FFFFFC, 0x00FFFFFE, 0x00FFFFFE, 0x00FFFFFC, 0x00FFFFF4, 0x00FFF4DF, 0x00FFE5C0, 0x00FFCE93, 0x00FFAB5D, 0x00F4883C, 0x00D9511F, 0x0D981403, 0x36400400, 0x68000000, 0x95000000, 0xC7000000, 0xEC000000, 0xFD000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF7000000, 0xDF000000, 0xB6070100, 0x6B601300, 0x28AA2400, 0x06E3410C, 0x00F15D1B, 0x00F87E34, 0x00FD994C, 
        0x00FFA658, 0x00FFB166, 0x00FFB871, 0x00FFB972, 0x00FFB267, 0x00FEA75A, 0x00FD9B4E, 0x00F37F37, 0x00E1581E, 0x03C9350F, 0x18891301, 0x3A410600, 0x64070100, 0x86000000, 0xB3000000, 0xDC000000, 0xF5000000, 0xFE000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0xF0000000, 0xD9000000, 0xB9000000, 0x83390C00, 0x4C711400, 0x2C961D00, 0x1AB12803, 
        0x0FC5360A, 0x08D34110, 0x05DA4612, 0x04D94613, 0x07CE3E10, 0x0CBC320B, 0x15A22104, 0x22811300, 0x365B0B00, 0x50290500, 0x72000000, 0x91000000, 0xB4000000, 0xD5000000, 0xEE000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0xF2000000, 0xE0000000, 0xC8000000, 0xB0000000, 0x9C000000, 
        0x8E000000, 0x83000000, 0x7B000000, 0x77000000, 0x77000000, 0x7A000000, 0x82000000, 0x8C000000, 0x9B000000, 0xAD000000, 0xC5000000, 0xDD000000, 0xF0000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF8000000, 0xEF000000, 0xE6000000, 
        0xDE000000, 0xD9000000, 0xD5000000, 0xD4000000, 0xD3000000, 0xD5000000, 0xD8000000, 0xDD000000, 0xE5000000, 0xEE000000, 0xF8000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF
#endif
};

GUI_CONST_STORAGE GUI_BITMAP _bmClock = {
  48, // XSize */
  48, // YSize */
  192, // BytesPerLine */
  32, // BitsPerPixel */
  (unsigned char *)_acClock,  // Pointer to picture data */
  NULL,  // Pointer to palette */
#if (GUI_USE_ARGB == 1)
  GUI_DRAW_BMPM8888I
#else
  GUI_DRAW_BMP8888
#endif
};

/*********************************************************************
*
*       _bmDate
*
* Function description
*   Icon bitmap with alpha channel
*/
static GUI_CONST_STORAGE unsigned long _acDate[] = {
#if (GUI_USE_ARGB == 1)
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0F818181, 0x4C7B7B7B, 0x99797979, 0xD87C7C7C, 0x5E626262, 0x10000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x445D5D70, 0x83666678, 0x676C6C7F, 0x193F3F45, 0x10585858, 0x447A7A7A, 0x8D797979, 0xE1787878, 0xFF7E7E7E, 0xFF8C8C8C, 0xFF8B8B8B, 0xDB707070, 0x41060606, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0D5E5E6F, 0x65676778, 0x5C6B6B7C, 0x6F5C5C6D, 
        0xFD6B6B7D, 0xFF9D9DAF, 0xFF8B8B9B, 0xE178787C, 0xE1777776, 0xFE7D7C7D, 0xFF898989, 0xFFAEAEAF, 0xFFD4D6D6, 0xFFF4F4F4, 0xFFC8CACA, 0xFE7C7C7C, 0x8E2D2D2D, 0x26000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x15626274, 0x246A6A7D, 0x11525260, 0xB95C5C6C, 0xFF7D7D90, 0xFF868699, 0xFD6E6E7A, 
        0xFF898994, 0xFF9D9DA4, 0xFF9695A4, 0xFF8A8A91, 0xFFA6A8A8, 0xFFCED1D2, 0xFFECEFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE7EAEC, 0xFF838484, 0xC44B4B4B, 0x41000000, 0x0A000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x156B6B7C, 0x0A5C5C6C, 0x645B5B6C, 0xE76C6C7F, 0xF7818195, 0xDD6C6C7B, 0xFF757583, 0xFFA6A6B1, 0xFF9B9BA8, 0xFF898992, 
        0xFF8B8B8F, 0xFF9A9C9C, 0xFFAEB2B7, 0xFFACADBF, 0xFFF7FBFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFBFFFF, 0xFF999A9C, 0xE6626262, 0x5B000000, 0x16000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x065B5B6B, 0x955F5F71, 0xF2707083, 0xDA727286, 0xF3626273, 0xFFA0A0AF, 0xFFADADBC, 0xFF8C8B97, 0xFF818084, 0xFF7F8081, 0xFF96999B, 0xFF9EA0B0, 
        0xFFD3D9E0, 0xFFFAFFFF, 0xFFF5FAFC, 0xFFB8B9C5, 0xFFF3F3F8, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFF, 0xFFFAFBFB, 0xFFE3E3E3, 0xFFD5D7D8, 0xFFB7BCBE, 0xFC757574, 0x8A212121, 0x25000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6B555564, 0xFF747486, 0xFFADADBD, 0xFF9393A4, 0xFF7E7E85, 0xFF838387, 0xFF7D7E7E, 0xFF9495A5, 0xFFA9ADB8, 0xFFE5EEF2, 0xFFF3FBFE, 0xFFC0C3D0, 
        0xFFD7DAE3, 0xFFFFFFFF, 0xFFFAFAFC, 0xFFD8D7E1, 0xFFFEFFFF, 0xFFF7F8F9, 0xFFF0F1F2, 0xFFFEFEFF, 0xFFDFE0E1, 0xFFB1B1B1, 0xFFDFE2E3, 0xFFE0E9EE, 0xFF838383, 0xC74D4D4D, 0x3E000000, 0x09000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x0F7A7A7A, 0x5B767676, 0xDE6D6D70, 0xFF7F7E86, 0xFF7B7A7C, 0xFF878890, 0xFF999BAA, 0xFFBEC8CF, 0xFFE1ECEF, 0xFFD2DBE3, 0xFFC2C5D4, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDADCE4, 
        0xFFEEEFF2, 0xFFFFFFFF, 0xFFFDFFFF, 0xFFFDFDFE, 0xFFCECFCF, 0xFFB0B1B1, 0xFFD3D4D4, 0xFFFDFDFE, 0xFFFCFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEFFBFF, 0xFF9CA0A3, 0xED656464, 0x5E020202, 0x17000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x06797979, 0x4F737373, 0xA5727272, 0xE2727170, 0xFF777776, 0xFF858686, 0xFF9DA3A8, 0xFFBCC8CD, 0xFFD5E2E7, 0xFFB3B9CC, 0xFFEBF2F9, 0xFFFDFFFF, 0xFFF0F2F6, 0xFFD2D3DD, 0xFFFFFFFF, 0xFFFDFFFF, 0xFFF3F4F7, 
        0xFFE9EAEA, 0xFFB7B8B8, 0xFFD7D9D9, 0xFFFFFFFF, 0xFFEBEDEE, 0xFFF4F6F7, 0xFFFFFFFF, 0xFFFDFEFF, 0xFFFDFEFF, 0xFFFDFEFF, 0xFFFDFEFF, 0xFFF5FFFF, 0xFFB7BFC4, 0xFE737272, 0x982B2B2B, 0x2A000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xAB757575, 0xFF7A7A7A, 0xFF8A8C8D, 0xFFA4AAAE, 0xFFBECBD1, 0xFFDBEAF1, 0xFFEDFAFF, 0xFFF6FFFF, 0xFFFCFFFF, 0xFFCDCED9, 0xFFF0F0F3, 0xFFFFFFFF, 0xFFF2F3F7, 0xFFEBEDEF, 0xFFDBDCDC, 0xFFF3F5F5, 0xFFF8F9F9, 
        0xFFC8CACA, 0xFFD8D9DA, 0xFFF4F6F7, 0xFFFCFEFF, 0xFFFEFFFF, 0xFFFEFFFF, 0xFFFCFEFF, 0xFFFCFEFF, 0xFFFCFEFF, 0xFFFCFEFF, 0xFFFDFEFF, 0xFFF8FFFF, 0xFFD3E0E9, 0xFF7D7D7D, 0xD2525251, 0x45000000, 0x0C000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xE3727271, 0xFF8D8F91, 0xFFDBEDF8, 0xFFECFBFF, 0xFFF3FFFF, 0xFFF9FEFF, 0xFFFDFEFF, 0xFFFDFEFF, 0xFFFDFDFF, 0xFFECEDF3, 0xFFF3F5F6, 0xFFFDFEFE, 0xFFECEDED, 0xFFB3B4B5, 0xFFB9BABB, 0xFFF5F7F8, 0xFFFEFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFEFF, 0xFFFCFDFF, 0xFFFCFDFF, 0xFFFCFDFF, 0xFFFCFDFF, 0xFFFCFDFF, 0xFFFCFDFF, 0xFFFCFDFF, 0xFFFCFDFF, 0xFFFCFDFF, 0xFFE7F7FF, 0xFF979CA0, 0xF3666564, 0x69090909, 0x1B000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xE16E6E6D, 0xFF8E9090, 0xFFDEF0FC, 0xFFF3FCFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFDFEFF, 0xFFDDDEDF, 0xFFAFB0B1, 0xFFC9CACB, 0xFFFAFCFD, 0xFFF6F8F9, 0xFFF6F8FA, 0xFFFFFFFF, 0xFFFCFEFF, 0xFFFBFDFF, 
        0xFFFBFDFF, 0xFFFBFDFF, 0xFFFBFDFF, 0xFFFBFDFF, 0xFFFBFDFF, 0xFFFBFDFF, 0xFFFBFDFF, 0xFFFBFDFF, 0xFFFBFDFF, 0xFFFBFDFF, 0xFFFBFDFF, 0xFFFDFDFF, 0xFFF0FDFF, 0xFFB9C8D1, 0xFF737271, 0x9F2B2B2B, 0x2E000000, 0x03000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xE16D6D6D, 0xFF8E8D8D, 0xFFD9E9F4, 0xFFECF9FF, 0xFFF3F3F4, 0xFFD6D7D9, 0xFFD8DADB, 0xFFFEFEFF, 0xFFDEE0E1, 0xFFE2E3E5, 0xFFFBFDFE, 0xFFFCFDFF, 0xFFFCFEFF, 0xFFFCFEFF, 0xFFFBFDFF, 0xFFFBFDFF, 0xFFFBFEFF, 
        0xFFFBFFFF, 0xFFFBFFFF, 0xFFFBFFFF, 0xFFFBFFFF, 0xFFFBFFFF, 0xFFFBFFFF, 0xFFFBFEFF, 0xFFFBFDFF, 0xFFFBFDFF, 0xFFFBFDFF, 0xFFFBFDFF, 0xFFFDFEFF, 0xFFF3FCFF, 0xFFD0E5F2, 0xFF7E8081, 0xCE4A4949, 0x46000000, 0x0C000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xD96B6B6B, 0xFF8E8C8B, 0xFFDAE6ED, 0xFFDEF2FC, 0xFFC8CACA, 0xFFC5C8C9, 0xFFE9EBED, 0xFFFCFEFF, 0xFFFEFFFF, 0xFFFEFFFF, 0xFFFBFEFF, 0xFFFAFDFF, 0xFFFBFDFF, 0xFFFBFDFF, 0xFFFAFEFF, 0xFFFAFFFF, 0xFFFAFEFF, 
        0xFFFBF3F4, 0xFFFCE6E7, 0xFFFDDDDE, 0xFFFDD9DA, 0xFFFDDCDD, 0xFFFCE7E8, 0xFFFBFBFC, 0xFFFAFFFF, 0xFFFBFDFF, 0xFFFBFDFF, 0xFFFBFDFF, 0xFFFBFDFF, 0xFFF8FDFF, 0xFFDFF6FF, 0xFF9CA7AD, 0xF5656362, 0x6E121212, 0x1B000000, 0x01000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xA4646464, 0xFF818180, 0xFFD5DADE, 0xFFD6EEFE, 0xFFF7FDFF, 0xFFFFFFFF, 0xFFFCFFFF, 0xFFFAFDFF, 0xFFFAFDFF, 0xFFFAFDFF, 0xFFFAFDFF, 0xFFFAFDFF, 0xFFFAFDFF, 0xFFFAFEFF, 0xFFFAFFFF, 0xFFFCEAEB, 0xFFFDCECE, 
        0xFFFFBCBC, 0xFFFFB7B7, 0xFFFFB3B3, 0xFFFFB1B1, 0xFFFFB0B0, 0xFFFFB0B0, 0xFFFEC2C2, 0xFFFAF3F4, 0xFFFAFFFF, 0xFFFAFDFF, 0xFFFAFDFF, 0xFFFAFDFF, 0xFFFDFEFF, 0xFFEAFCFF, 0xFFB8CEDA, 0xFF717171, 0xA9343333, 0x31000000, 0x05000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x695B5B5B, 0xFF737272, 0xFFC2C4C8, 0xFFD2EBFB, 0xFFE6F7FF, 0xFFFCFEFF, 0xFFFAFDFF, 0xFFFAFDFF, 0xFFFAFDFF, 0xFFFAFDFF, 0xFFFAFDFF, 0xFFFAFDFF, 0xFFFAFFFF, 0xFFFAF9FA, 0xFFFDD5D6, 0xFFFFB8B8, 0xFFFFB4B4, 
        0xFFFFB5B5, 0xFFFFB2B1, 0xFFFFB0B0, 0xFFFFB1B1, 0xFFFFB1B1, 0xFFFFAFAF, 0xFFFFA9A9, 0xFFFEBFBF, 0xFFFAFBFD, 0xFFFAFEFF, 0xFFFAFDFF, 0xFFFAFDFF, 0xFFFCFDFF, 0xFFF1FBFF, 0xFFCBE6F7, 0xFF7D8082, 0xD54A4A4A, 0x4C000000, 0x0F000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x2C4A4A4A, 0xF8686868, 0xFFA7A9AD, 0xFFD1E6F6, 0xFFD8F1FF, 0xFFFAFCFF, 0xFFF9FCFF, 0xFFF9FCFF, 0xFFF9FCFF, 0xFFF9FCFF, 0xFFF9FCFF, 0xFFF9FDFF, 0xFFFAF6F8, 0xFFFEC8C9, 0xFFFFB3B3, 0xFFFFB5B4, 0xFFFFB2B2, 
        0xFFFFB8B8, 0xFFFDC9CA, 0xFFFDCACA, 0xFFFFB2B2, 0xFFFFABAB, 0xFFFFACAC, 0xFFFFA9A9, 0xFFFFA7A7, 0xFFFBE4E6, 0xFFF9FFFF, 0xFFF9FCFF, 0xFFF9FCFF, 0xFFF9FCFF, 0xFFF9FCFF, 0xFFD9F3FF, 0xFF95A1A9, 0xF35F5E5C, 0x6C080808, 0x1C000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x07000000, 0xC6606060, 0xFF89898B, 0xFFC9D9E9, 0xFFCDECFF, 0xFFF4FAFF, 0xFFFBFCFF, 0xFFF9FCFF, 0xFFF9FCFF, 0xFFF9FCFF, 0xFFF9FCFF, 0xFFF9FFFF, 0xFFFCD8D9, 0xFFFFAEAE, 0xFFFFB1B1, 0xFFFFB1B1, 0xFFFDD5D6, 
        0xFFFAF5F6, 0xFFF9FDFF, 0xFFF9FFFF, 0xFFFAEAEC, 0xFFFFAFAF, 0xFFFFA6A6, 0xFFFFA7A7, 0xFFFFA0A0, 0xFFFCD4D5, 0xFFF9FFFF, 0xFFF9FCFF, 0xFFF9FCFF, 0xFFF9FCFF, 0xFFFCFDFF, 0xFFE8FAFF, 0xFFB0C8D8, 0xFF6F6E6D, 0xAA333333, 0x30000000, 0x04000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x01000000, 0x7B565656, 0xFF737272, 0xFFB6C0D0, 0xFFC5E7FD, 0xFFE7F6FF, 0xFFFCFDFF, 0xFFF8FCFF, 0xFFF9FCFF, 0xFFF9FCFF, 0xFFF9FCFF, 0xFFF9FDFF, 0xFFF9F8F9, 0xFFFCDADB, 0xFFFEB6B6, 0xFFFCDADC, 0xFFF8FFFF, 
        0xFFF8FEFF, 0xFFF8FDFF, 0xFFF8FDFF, 0xFFF8FFFF, 0xFFFCCFD1, 0xFFFFA0A0, 0xFFFFA3A3, 0xFFFF9C9C, 0xFFFCD2D4, 0xFFF9FFFF, 0xFFF9FCFF, 0xFFF9FCFF, 0xFFF9FCFF, 0xFFFAFDFF, 0xFFF1FAFF, 0xFFC5E7FC, 0xFF80868A, 0xDE4F4E4D, 0x4E000000, 0x10000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x374A4A4A, 0xFA666664, 0xFF9EA5B2, 0xFFC1DFF8, 0xFFD3EFFF, 0xFFFAFDFF, 0xFFF8FCFF, 0xFFF8FCFF, 0xFFF8FCFF, 0xFFF8FCFF, 0xFFF8FCFF, 0xFFF8FDFF, 0xFFF8FFFF, 0xFFF9F5F8, 0xFFF8FDFF, 0xFFF8FDFF, 
        0xFFF8FCFF, 0xFFF8FCFF, 0xFFF8FCFF, 0xFFF8FFFF, 0xFFFBD6D7, 0xFFFF9C9C, 0xFFFF9F9F, 0xFFFF9C9C, 0xFFFAE4E6, 0xFFF8FFFF, 0xFFF8FCFF, 0xFFF8FCFF, 0xFFF8FCFF, 0xFFF8FCFF, 0xFFF8FCFF, 0xFFD2F2FF, 0xFF95A7B2, 0xF85F5E5D, 0x78111111, 0x20000000, 
        0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x0C222222, 0xDA5F5E5D, 0xFF888C95, 0xFFBAD3EF, 0xFFC1E8FF, 0xFFF1FAFF, 0xFFFAFDFF, 0xFFF8FCFF, 0xFFF8FCFF, 0xFFF8FCFF, 0xFFF8FCFF, 0xFFF8FCFF, 0xFFF8FCFF, 0xFFF8FEFF, 0xFFF8FCFF, 0xFFF8FCFF, 
        0xFFF8FCFF, 0xFFF8FFFF, 0xFFF8FFFF, 0xFFF9EFF1, 0xFFFEADAD, 0xFFFF9B9B, 0xFFFF9A9A, 0xFFFDBBBC, 0xFFF8FFFF, 0xFFF8FEFF, 0xFFF8FCFF, 0xFFF8FCFF, 0xFFF8FCFF, 0xFFF8FCFF, 0xFFFBFDFF, 0xFFDFF7FF, 0xFFA8C7D9, 0xFF6B6B6A, 0xAD2E2E2E, 0x34000000, 
        0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x01000000, 0x9D585757, 0xFF737477, 0xFFABBFDE, 0xFFB7E1FD, 0xFFDFF4FF, 0xFFFBFDFF, 0xFFF7FCFF, 0xFFF8FCFF, 0xFFF8FCFF, 0xFFF8FCFF, 0xFFF8FCFF, 0xFFF8FCFF, 0xFFF8FCFF, 0xFFF8FCFF, 0xFFF8FCFF, 
        0xFFF8FDFF, 0xFFF9EEF0, 0xFFFCCACB, 0xFFFEA4A4, 0xFFFF9999, 0xFFFF9999, 0xFFFF9A9A, 0xFFFCC4C5, 0xFFF9E9EA, 0xFFF7FDFF, 0xFFF7FFFF, 0xFFF8FBFF, 0xFFF8FBFF, 0xFFF8FCFF, 0xFFF9FCFF, 0xFFF1FAFF, 0xFFBDE3FA, 0xFF7C8387, 0xDE4B4B4A, 0x4F000000, 
        0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x44474747, 0xFA656462, 0xFF939FB6, 0xFFB1D9FA, 0xFFCCEDFF, 0xFFF9FCFF, 0xFFF7FBFF, 0xFFF7FBFF, 0xFFF7FBFF, 0xFFF7FBFF, 0xFFF7FBFF, 0xFFF7FBFF, 0xFFF7FBFF, 0xFFF7FBFF, 0xFFF7FBFF, 
        0xFFF7FDFF, 0xFFFCBBBC, 0xFFFF9191, 0xFFFF9696, 0xFFFF9796, 0xFFFF9595, 0xFFFF9595, 0xFFFF8F8F, 0xFFFF9293, 0xFFFDABAC, 0xFFF9E4E6, 0xFFF7FEFF, 0xFFF7FBFF, 0xFFF7FBFF, 0xFFF7FBFF, 0xFFF9FCFF, 0xFFD0F1FF, 0xFF94ACBB, 0xFC605E5C, 0x851C1C1C, 
        0x22000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x0A000000, 0xD35A5957, 0xFF7B818E, 0xFFA8C9EF, 0xFFB9E5FF, 0xFFF0F9FF, 0xFFF9FCFF, 0xFFF7FBFF, 0xFFF7FBFF, 0xFFF7FBFF, 0xFFF7FBFF, 0xFFF7FBFF, 0xFFF7FBFF, 0xFFF7FBFF, 0xFFF7FBFF, 
        0xFFF7FFFF, 0xFFFAD4D6, 0xFFFF8E8D, 0xFFFF9595, 0xFFFF9999, 0xFFFF9393, 0xFFFF8D8D, 0xFFFF8F8F, 0xFFFF8E8E, 0xFFFF8686, 0xFFFE9595, 0xFFF8EFF2, 0xFFF7FEFF, 0xFFF7FBFF, 0xFFF7FBFF, 0xFFFBFDFF, 0xFFDFF5FF, 0xFFA7CFE8, 0xFF6A6B6B, 0xBE373737, 
        0x3C000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x02000000, 0x96535352, 0xFF6B6C6F, 0xFF98B3DF, 0xFFABDBFD, 0xFFD8F1FF, 0xFFFAFCFF, 0xFFF6FBFF, 0xFFF6FBFF, 0xFFF6FBFF, 0xFFF6FBFF, 0xFFF6FBFF, 0xFFF6FBFF, 0xFFF6FBFF, 0xFFF6FBFF, 
        0xFFF6FDFF, 0xFFF7F3F6, 0xFFFBC5C8, 0xFFF9DEE1, 0xFFF7EEF1, 0xFFF8E2E3, 0xFFFCB2B4, 0xFFFF8A8A, 0xFFFF8B8B, 0xFFFF8A8A, 0xFFFF8180, 0xFFFBBDBF, 0xFFF6FFFF, 0xFFF6FBFF, 0xFFF6FBFF, 0xFFF8FCFF, 0xFFEEF9FF, 0xFFB4E2FE, 0xFF788289, 0xE44A4948, 
        0x58000000, 0x14000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x4D484848, 0xFE61605E, 0xFF8497BC, 0xFFA2D0FC, 0xFFBEE8FF, 0xFFF6FBFF, 0xFFF7FBFF, 0xFFF6FBFF, 0xFFF6FBFF, 0xFFF6FBFF, 0xFFF6FBFF, 0xFFF6FBFF, 0xFFF6FBFF, 0xFFF6FBFF, 
        0xFFF6FBFF, 0xFFF6FCFF, 0xFFF6FFFF, 0xFFF6FFFF, 0xFFF6FEFF, 0xFFF6FFFF, 0xFFF5FEFF, 0xFFFCB4B6, 0xFFFF8282, 0xFFFF8686, 0xFFFF8181, 0xFFFE9292, 0xFFF7F6FA, 0xFFF6FDFF, 0xFFF6FBFF, 0xFFF6FBFF, 0xFFF9FDFF, 0xFFCCF0FF, 0xFF8CA8BA, 0xFC5D5A58, 
        0x891B1B1B, 0x25000000, 0x01000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x11212121, 0xDD595754, 0xFF727B8F, 0xFF96BEF3, 0xFFAEE1FF, 0xFFEBF7FF, 0xFFF8FCFF, 0xFFF6FBFF, 0xFFF6FBFF, 0xFFF6FBFF, 0xFFF6FBFF, 0xFFF6FBFF, 0xFFF6FBFF, 0xFFF6FBFF, 
        0xFFF6FBFF, 0xFFF6FBFF, 0xFFF6FBFF, 0xFFF6FBFF, 0xFFF6FBFF, 0xFFF6FBFF, 0xFFF6FFFF, 0xFFF8DDE0, 0xFFFF8383, 0xFFFF8181, 0xFFFF7F7F, 0xFFFF8384, 0xFFF7EFF2, 0xFFF6FEFF, 0xFFF6FBFF, 0xFFF6FBFF, 0xFFFAFDFF, 0xFFE2F6FF, 0xFFA2D1EE, 0xFF696C6D, 
        0xC93C3C3C, 0x3E000000, 0x0A000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x8A4D4C4B, 0xFF646568, 0xFF85A5D8, 0xFF9FD6FF, 0xFFD4EFFF, 0xFFF9FCFF, 0xFFF5FAFF, 0xFFF5FAFF, 0xFFF5FAFF, 0xFFF5FAFF, 0xFFF5FAFF, 0xFFF5FAFF, 0xFFF5FAFF, 
        0xFFF5FAFF, 0xFFF5FAFF, 0xFFF5FAFF, 0xFFF5FAFF, 0xFFF5FAFF, 0xFFF5FAFF, 0xFFF5FFFF, 0xFFF7E0E4, 0xFFFF8080, 0xFFFF7E7E, 0xFFFF7A7A, 0xFFFE8888, 0xFFF6F3F8, 0xFFF5FDFF, 0xFFF5FAFF, 0xFFF5FAFF, 0xFFF7FAFF, 0xFFF1F9FF, 0xFFB2E5FF, 0xFF798B96, 
        0xEF4F4C4B, 0x63060606, 0x18000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3B404040, 0xFB5B5955, 0xFF7388B1, 0xFF93C7FD, 0xFFB3E4FF, 0xFFF4FAFF, 0xFFF6FAFF, 0xFFF5FAFF, 0xFFF5FAFF, 0xFFF5FAFF, 0xFFF5FAFF, 0xFFF5FAFF, 0xFFF5FAFF, 
        0xFFF5FBFF, 0xFFF5FCFF, 0xFFF5FBFF, 0xFFF5FBFF, 0xFFF5FBFF, 0xFFF5FFFF, 0xFFF4FEFF, 0xFFFCAFB1, 0xFFFF7878, 0xFFFF7B7B, 0xFFFF7171, 0xFFFBB0B2, 0xFFF5FEFF, 0xFFF5FAFF, 0xFFF5FAFF, 0xFFF5FAFF, 0xFFF5FAFF, 0xFFF9FCFF, 0xFFC7EFFF, 0xFF88ADC5, 
        0xFE5C5957, 0x9A212121, 0x2B000000, 0x03000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0C161616, 0xD854524E, 0xFF657089, 0xFF81B2F5, 0xFF9FDAFF, 0xFFE0F3FF, 0xFFF8FCFF, 0xFFF4FAFF, 0xFFF5FAFF, 0xFFF5FAFF, 0xFFF5FAFF, 0xFFF5FAFF, 0xFFF4FBFF, 
        0xFFF5F6FB, 0xFFF5F6FB, 0xFFF4FDFF, 0xFFF4FFFF, 0xFFF5FBFF, 0xFFF6EAEC, 0xFFFAADB0, 0xFFFF7777, 0xFFFF7979, 0xFFFF7272, 0xFFFE8080, 0xFFF6E9ED, 0xFFF4FEFF, 0xFFF5FAFF, 0xFFF5FAFF, 0xFFF5FAFF, 0xFFF4FAFF, 0xFFF8FCFF, 0xFFE3F5FF, 0xFF9BCFEF, 
        0xFF666A6C, 0xCF3A3A3A, 0x45000000, 0x0C000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x904B4A49, 0xFF5E5F63, 0xFF7096DA, 0xFF90CFFF, 0xFFC5EBFF, 0xFFF9FCFF, 0xFFF4FAFF, 0xFFF4FAFF, 0xFFF4FAFF, 0xFFF4FAFF, 0xFFF4FAFF, 0xFFF3FEFF, 
        0xFFFAB2B5, 0xFFFD9091, 0xFFFBAAAB, 0xFFFBACAD, 0xFFFC9B9C, 0xFFFF8080, 0xFFFF7474, 0xFFFF7575, 0xFFFF6D6D, 0xFFFE8181, 0xFFF6DDDF, 0xFFF3FFFF, 0xFFF4FAFF, 0xFFF4FAFF, 0xFFF4FAFF, 0xFFF4FAFF, 0xFFF4FAFF, 0xFFF5FAFF, 0xFFF6FBFF, 0xFFB5E8FF, 
        0xFF7996A8, 0xF953504D, 0x76131313, 0x1C000000, 0x01000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x32363636, 0xF657544F, 0xFF647AA7, 0xFF82BEFE, 0xFFABE1FF, 0xFFF3FAFF, 0xFFF5FBFF, 0xFFF4FAFF, 0xFFF4FAFF, 0xFFF4FAFF, 0xFFF4FEFF, 0xFFF5EBEF, 
        0xFFFF8484, 0xFFFF7676, 0xFFFF7574, 0xFFFF7372, 0xFFFF7272, 0xFFFF7171, 0xFFFF6D6D, 0xFFFF6F6F, 0xFFFC9A9A, 0xFFF6E6E8, 0xFFF3FFFF, 0xFFF4FAFF, 0xFFF4FAFF, 0xFFF4FAFF, 0xFFF4FAFF, 0xFFF5FAFF, 0xFFF6FBFF, 0xFFF9FCFF, 0xFFFCFDFF, 0xFFCDF0FF, 
        0xFF8BBFE0, 0xFF5C5D5E, 0xBC333332, 0x37000000, 0x07000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08000000, 0xC34D4C49, 0xFF5B6477, 0xFF6EA4F2, 0xFF92D4FF, 0xFFD7F0FF, 0xFFF8FBFF, 0xFFF3F9FF, 0xFFF3FAFF, 0xFFF3FAFF, 0xFFF2FFFF, 0xFFF8C9CC, 
        0xFFFF7171, 0xFFFF706F, 0xFFFF6E6E, 0xFFFF6D6D, 0xFFFF7272, 0xFFFE8182, 0xFFFBA3A4, 0xFFF7D0D2, 0xFFF3FBFE, 0xFFF3FFFF, 0xFFF3F9FF, 0xFFF3FAFF, 0xFFF4FAFF, 0xFFF6FAFF, 0xFFF9FCFF, 0xFFF6FBFF, 0xFFE7F5FF, 0xFFD0EDFF, 0xFFB8E5FF, 0xFFA0DDFF, 
        0xFF90D0FA, 0xFF677077, 0xEF4A4947, 0x5A000000, 0x15000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x7A454545, 0xFF575659, 0xFF5B87D5, 0xFF7FC4FF, 0xFFB3E4FF, 0xFFF7FAFF, 0xFFF3F9FF, 0xFFF3F9FF, 0xFFF3F9FF, 0xFFF3FBFF, 0xFFF4EEF2, 
        0xFFF7CACE, 0xFFFAB4B7, 0xFFFAB1B3, 0xFFF9B7BA, 0xFFF7D1D5, 0xFFF4F1F6, 0xFFF3FEFF, 0xFFF2FFFF, 0xFFF3FAFF, 0xFFF4F9FF, 0xFFF6FAFF, 0xFFF9FBFF, 0xFFF3F9FF, 0xFFE7F5FF, 0xFFD1EDFF, 0xFFB1E2FF, 0xFF95D7FF, 0xFF8AD0FD, 0xFF84C8FB, 0xFF81BFF9, 
        0xFF7DB4F2, 0xFF646E78, 0xF34B4948, 0x76000000, 0x22000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x2D333333, 0xF5534F4A, 0xFF536CA1, 0xFF6BAEFE, 0xFF97D9FF, 0xFFE6F5FF, 0xFFF6FAFF, 0xFFF2F9FF, 0xFFF3F9FF, 0xFFF3F9FF, 0xFFF2FBFF, 
        0xFFF2FFFF, 0xFFF2FFFF, 0xFFF2FFFF, 0xFFF2FFFF, 0xFFF2FFFF, 0xFFF2FBFF, 0xFFF3FAFF, 0xFFF5FAFF, 0xFFF9FBFF, 0xFFF4FAFF, 0xFFE5F4FF, 0xFFC1E8FF, 0xFFA7DEFF, 0xFF92D6FF, 0xFF86CEFD, 0xFF7EC3FB, 0xFF7BBCF8, 0xFF76B1F7, 0xFF70A7F5, 0xFF65A0F8, 
        0xFF5897F2, 0xFF5C6574, 0xF2484744, 0x7F000000, 0x28000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x07000000, 0xB3484644, 0xFF545968, 0xFF5993ED, 0xFF82CDFF, 0xFFC0E7FF, 0xFFF8FBFF, 0xFFF2F9FF, 0xFFF2F9FF, 0xFFF2F9FF, 0xFFF2F9FF, 
        0xFFF2F9FF, 0xFFF2F9FF, 0xFFF2F9FF, 0xFFF3FAFF, 0xFFF6FBFF, 0xFFF9FCFF, 0xFFF4FAFF, 0xFFE5F5FF, 0xFFC2E8FF, 0xFFA5DEFF, 0xFF8ED4FF, 0xFF80CCFD, 0xFF7BC2FC, 0xFF78BBF9, 0xFF72AFF8, 0xFF6BA6F6, 0xFF619EF7, 0xFF5195F8, 0xFF458FFC, 0xFF3E87FF, 
        0xFF417FF5, 0xFF576176, 0xF3474643, 0x7F000000, 0x27000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x5B3C3C3B, 0xFF53504D, 0xFF4B75C1, 0xFF6EB9FF, 0xFF9DDBFF, 0xFFF0F8FF, 0xFFF3F9FF, 0xFFF2F9FF, 0xFFF2F9FF, 0xFFF2F9FF, 
        0xFFF3F9FF, 0xFFF6FBFF, 0xFFF9FBFF, 0xFFF0F8FF, 0xFFDBF0FF, 0xFFBFE7FF, 0xFFA5DDFF, 0xFF8AD2FF, 0xFF7BC8FD, 0xFF76C0FC, 0xFF72B7FA, 0xFF6DACF9, 0xFF63A2F8, 0xFF5799F8, 0xFF4A91F9, 0xFF3F89FC, 0xFF3782FF, 0xFF397AF6, 0xFF4271D8, 0xFF4C68AE, 
        0xFF515F85, 0xFF54555A, 0xED414141, 0x7D000000, 0x26000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x16232323, 0xE84D4943, 0xFF475E8F, 0xFF539EFF, 0xFF85D1FF, 0xFFDBF1FF, 0xFFF6FBFF, 0xFFF3FAFF, 0xFFF6FBFF, 0xFFF8FCFF, 
        0xFFF1F9FF, 0xFFDAF1FF, 0xFFBDE6FF, 0xFF98D9FF, 0xFF83CFFF, 0xFF78C8FE, 0xFF71BFFD, 0xFF6CB3FB, 0xFF68AAFA, 0xFF5E9EF9, 0xFF5194F9, 0xFF438EFA, 0xFF3383FD, 0xFF2D7DFF, 0xFF3175F9, 0xFF3C6CDB, 0xFF4664B0, 0xFF505B79, 0xFF535355, 0xFE504D46, 
        0xF042403B, 0xDB2F2F2E, 0xAD111111, 0x65000000, 0x1D000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0xAB444441, 0xFF4D5161, 0xFF3E7FED, 0xFF6FC0FF, 0xFFB7E5FF, 0xFFFBFCFF, 0xFFEFF8FF, 0xFFDBF0FF, 0xFFBDE6FF, 
        0xFF97D8FF, 0xFF7FCEFF, 0xFF74C7FE, 0xFF6FBDFD, 0xFF69B2FC, 0xFF62A8FB, 0xFF589CFA, 0xFF4C92FA, 0xFF3E8AFC, 0xFF2C81FF, 0xFF2679FF, 0xFF2A71F7, 0xFF3568DC, 0xFF4161B0, 0xFF4C597C, 0xFF525254, 0xFD4E4B46, 0xF143403C, 0xDD30302F, 0xB9161615, 
        0x96020202, 0x7C000000, 0x5B000000, 0x31000000, 0x0C000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x47333333, 0xFB4F4A44, 0xFF3B62AE, 0xFF54A6FF, 0xFF89D4FF, 0xFFACE0FF, 0xFF92D6FF, 0xFF7DCDFF, 0xFF6EC2FE, 
        0xFF67B9FD, 0xFF63AFFC, 0xFF5BA2FC, 0xFF5297FB, 0xFF438EFC, 0xFF3184FD, 0xFF237BFF, 0xFF1F72FF, 0xFF2369F9, 0xFF3062D5, 0xFF425C9C, 0xFF4B546F, 0xFF4E4F52, 0xFD4D4A44, 0xEE3E3D38, 0xD3272625, 0xB3131313, 0x94030303, 0x7C000000, 0x61000000, 
        0x43000000, 0x2A000000, 0x17000000, 0x09000000, 0x01000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0B000000, 0xD146433D, 0xFF425176, 0xFF3787FD, 0xFF75C9FF, 0xFF6BC2FF, 0xFF65B8FE, 0xFF60AEFE, 0xFF57A0FD, 
        0xFF4E96FC, 0xFF3D8BFD, 0xFF2981FF, 0xFF1C79FF, 0xFF176EFF, 0xFF1A65FB, 0xFF295FD9, 0xFF3D589F, 0xFF485270, 0xFF4E4D4F, 0xFE4D4940, 0xEE3C3B38, 0xD3262625, 0xB3131313, 0x92010101, 0x77000000, 0x5A000000, 0x3F000000, 0x2A000000, 0x19000000, 
        0x0B000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x883D3C3B, 0xFF4B494B, 0xFF2D68D3, 0xFF51A4FF, 0xFF539FFE, 0xFF4592FE, 0xFF3387FE, 0xFF247CFF, 
        0xFF1672FF, 0xFF1068FF, 0xFF1660F0, 0xFF275ACA, 0xFF3753A0, 0xFF434F72, 0xFF4C4C4F, 0xFA4A453C, 0xE9373632, 0xD2272626, 0xB5131313, 0x92010101, 0x77000000, 0x5A000000, 0x3F000000, 0x27000000, 0x15000000, 0x09000000, 0x02000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x37303030, 0xFA4B463D, 0xFF38558E, 0xFF237DFF, 0xFF1D7AFF, 0xFF0A6CFF, 0xFF0663FF, 0xFF0F5AF3, 
        0xFF2154CD, 0xFF34509A, 0xFF474D61, 0xFF4C4A47, 0xFB48443B, 0xEA383631, 0xD2252424, 0xAB0B0B0B, 0x8B000000, 0x72000000, 0x59000000, 0x40000000, 0x27000000, 0x15000000, 0x09000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08000000, 0xBD413F3D, 0xFF454C5D, 0xFF095CF4, 0xFF0756F6, 0xFF1A50D0, 0xFF2E4D9E, 0xFF444C63, 
        0xFF4B4A47, 0xFA48443B, 0xEB383633, 0xD3262625, 0xAD0D0D0D, 0x8D000000, 0x73000000, 0x56000000, 0x39000000, 0x23000000, 0x15000000, 0x0A000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x60353535, 0xFF484849, 0xFF3A4A77, 0xFF414963, 0xFF4A4948, 0xFA48443B, 0xE533322E, 
        0xC81E1E1D, 0xA70B0B0B, 0x8B000000, 0x73000000, 0x58000000, 0x3A000000, 0x23000000, 0x13000000, 0x07000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x171C1C1C, 0xC53F3F3F, 0xEE44413B, 0xE032312D, 0xC920201F, 0xA80B0B0B, 0x89000000, 
        0x6D000000, 0x4F000000, 0x37000000, 0x23000000, 0x14000000, 0x07000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x24000000, 0x5C000000, 0x76000000, 0x69000000, 0x50000000, 0x37000000, 
        0x20000000, 0x10000000, 0x06000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF
#else
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF0818181, 0xB37B7B7B, 0x66797979, 0x277C7C7C, 0xA1626262, 0xEF000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xBB705D5D, 0x7C786666, 0x987F6C6C, 0xE6453F3F, 0xEF585858, 0xBB7A7A7A, 0x72797979, 0x1E787878, 0x007E7E7E, 0x008C8C8C, 0x008B8B8B, 0x24707070, 0xBE060606, 0xEF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF26F5E5E, 0x9A786767, 0xA37C6B6B, 0x906D5C5C, 
        0x027D6B6B, 0x00AF9D9D, 0x009B8B8B, 0x1E7C7878, 0x1E767777, 0x017D7C7D, 0x00898989, 0x00AFAEAE, 0x00D6D6D4, 0x00F4F4F4, 0x00CACAC8, 0x017C7C7C, 0x712D2D2D, 0xD9000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEA746262, 0xDB7D6A6A, 0xEE605252, 0x466C5C5C, 0x00907D7D, 0x00998686, 0x027A6E6E, 
        0x00948989, 0x00A49D9D, 0x00A49596, 0x00918A8A, 0x00A8A8A6, 0x00D2D1CE, 0x00F0EFEC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00ECEAE7, 0x00848483, 0x3B4B4B4B, 0xBE000000, 0xF5000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEA7C6B6B, 0xF56C5C5C, 0x9B6C5B5B, 0x187F6C6C, 0x08958181, 0x227B6C6C, 0x00837575, 0x00B1A6A6, 0x00A89B9B, 0x00928989, 
        0x008F8B8B, 0x009C9C9A, 0x00B7B2AE, 0x00BFADAC, 0x00FEFBF7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFB, 0x009C9A99, 0x19626262, 0xA4000000, 0xE9000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF96B5B5B, 0x6A715F5F, 0x0D837070, 0x25867272, 0x0C736262, 0x00AFA0A0, 0x00BCADAD, 0x00978B8C, 0x00848081, 0x0081807F, 0x009B9996, 0x00B0A09E, 
        0x00E0D9D3, 0x00FFFFFA, 0x00FCFAF5, 0x00C5B9B8, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFE, 0x00FBFBFA, 0x00E3E3E3, 0x00D8D7D5, 0x00BEBCB7, 0x03747575, 0x75212121, 0xDA000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x94645555, 0x00867474, 0x00BDADAD, 0x00A49393, 0x00857E7E, 0x00878383, 0x007E7E7D, 0x00A59594, 0x00B8ADA9, 0x00F2EEE5, 0x00FEFBF3, 0x00D0C3C0, 
        0x00E3DAD7, 0x00FFFFFF, 0x00FCFAFA, 0x00E1D7D8, 0x00FFFFFE, 0x00F9F8F7, 0x00F2F1F0, 0x00FFFEFE, 0x00E1E0DF, 0x00B1B1B1, 0x00E3E2DF, 0x00EEE9E0, 0x00838383, 0x384D4D4D, 0xC1000000, 0xF6000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xF07A7A7A, 0xA4767676, 0x21706D6D, 0x00867E7F, 0x007C7A7B, 0x00908887, 0x00AA9B99, 0x00CFC8BE, 0x00EFECE1, 0x00E3DBD2, 0x00D4C5C2, 0x00FFFFFF, 0x00FFFFFF, 0x00E4DCDA, 
        0x00F2EFEE, 0x00FFFFFF, 0x00FFFFFD, 0x00FEFDFD, 0x00CFCFCE, 0x00B1B1B0, 0x00D4D4D3, 0x00FEFDFD, 0x00FDFDFC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFBEF, 0x00A3A09C, 0x12646465, 0xA1020202, 0xE8000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xF9797979, 0xB0737373, 0x5A727272, 0x1D707172, 0x00767777, 0x00868685, 0x00A8A39D, 0x00CDC8BC, 0x00E7E2D5, 0x00CCB9B3, 0x00F9F2EB, 0x00FFFFFD, 0x00F6F2F0, 0x00DDD3D2, 0x00FFFFFF, 0x00FFFFFD, 0x00F7F4F3, 
        0x00EAEAE9, 0x00B8B8B7, 0x00D9D9D7, 0x00FFFFFF, 0x00EEEDEB, 0x00F7F6F4, 0x00FFFFFF, 0x00FFFEFD, 0x00FFFEFD, 0x00FFFEFD, 0x00FFFEFD, 0x00FFFFF5, 0x00C4BFB7, 0x01727273, 0x672B2B2B, 0xD5000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x54757575, 0x007A7A7A, 0x008D8C8A, 0x00AEAAA4, 0x00D1CBBE, 0x00F1EADB, 0x00FFFAED, 0x00FFFFF6, 0x00FFFFFC, 0x00D9CECD, 0x00F3F0F0, 0x00FFFFFF, 0x00F7F3F2, 0x00EFEDEB, 0x00DCDCDB, 0x00F5F5F3, 0x00F9F9F8, 
        0x00CACAC8, 0x00DAD9D8, 0x00F7F6F4, 0x00FFFEFC, 0x00FFFFFE, 0x00FFFFFE, 0x00FFFEFC, 0x00FFFEFC, 0x00FFFEFC, 0x00FFFEFC, 0x00FFFEFD, 0x00FFFFF8, 0x00E9E0D3, 0x007D7D7D, 0x2D515252, 0xBA000000, 0xF3000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x1C717272, 0x00918F8D, 0x00F8EDDB, 0x00FFFBEC, 0x00FFFFF3, 0x00FFFEF9, 0x00FFFEFD, 0x00FFFEFD, 0x00FFFDFD, 0x00F3EDEC, 0x00F6F5F3, 0x00FEFEFD, 0x00EDEDEC, 0x00B5B4B3, 0x00BBBAB9, 0x00F8F7F5, 0x00FFFFFE, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFD, 0x00FFFDFC, 0x00FFFDFC, 0x00FFFDFC, 0x00FFFDFC, 0x00FFFDFC, 0x00FFFDFC, 0x00FFFDFC, 0x00FFFDFC, 0x00FFFDFC, 0x00FFF7E7, 0x00A09C97, 0x0C646566, 0x96090909, 0xE4000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x1E6D6E6E, 0x0090908E, 0x00FCF0DE, 0x00FFFCF3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFEFD, 0x00DFDEDD, 0x00B1B0AF, 0x00CBCAC9, 0x00FDFCFA, 0x00F9F8F6, 0x00FAF8F6, 0x00FFFFFF, 0x00FFFEFC, 0x00FFFDFB, 
        0x00FFFDFB, 0x00FFFDFB, 0x00FFFDFB, 0x00FFFDFB, 0x00FFFDFB, 0x00FFFDFB, 0x00FFFDFB, 0x00FFFDFB, 0x00FFFDFB, 0x00FFFDFB, 0x00FFFDFB, 0x00FFFDFD, 0x00FFFDF0, 0x00D1C8B9, 0x00717273, 0x602B2B2B, 0xD1000000, 0xFC000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x1E6D6D6D, 0x008D8D8E, 0x00F4E9D9, 0x00FFF9EC, 0x00F4F3F3, 0x00D9D7D6, 0x00DBDAD8, 0x00FFFEFE, 0x00E1E0DE, 0x00E5E3E2, 0x00FEFDFB, 0x00FFFDFC, 0x00FFFEFC, 0x00FFFEFC, 0x00FFFDFB, 0x00FFFDFB, 0x00FFFEFB, 
        0x00FFFFFB, 0x00FFFFFB, 0x00FFFFFB, 0x00FFFFFB, 0x00FFFFFB, 0x00FFFFFB, 0x00FFFEFB, 0x00FFFDFB, 0x00FFFDFB, 0x00FFFDFB, 0x00FFFDFB, 0x00FFFEFD, 0x00FFFCF3, 0x00F2E5D0, 0x0081807E, 0x3149494A, 0xB9000000, 0xF3000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x266B6B6B, 0x008B8C8E, 0x00EDE6DA, 0x00FCF2DE, 0x00CACAC8, 0x00C9C8C5, 0x00EDEBE9, 0x00FFFEFC, 0x00FFFFFE, 0x00FFFFFE, 0x00FFFEFB, 0x00FFFDFA, 0x00FFFDFB, 0x00FFFDFB, 0x00FFFEFA, 0x00FFFFFA, 0x00FFFEFA, 
        0x00F4F3FB, 0x00E7E6FC, 0x00DEDDFD, 0x00DAD9FD, 0x00DDDCFD, 0x00E8E7FC, 0x00FCFBFB, 0x00FFFFFA, 0x00FFFDFB, 0x00FFFDFB, 0x00FFFDFB, 0x00FFFDFB, 0x00FFFDF8, 0x00FFF6DF, 0x00ADA79C, 0x0A626365, 0x91121212, 0xE4000000, 0xFE000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x5B646464, 0x00808181, 0x00DEDAD5, 0x00FEEED6, 0x00FFFDF7, 0x00FFFFFF, 0x00FFFFFC, 0x00FFFDFA, 0x00FFFDFA, 0x00FFFDFA, 0x00FFFDFA, 0x00FFFDFA, 0x00FFFDFA, 0x00FFFEFA, 0x00FFFFFA, 0x00EBEAFC, 0x00CECEFD, 
        0x00BCBCFF, 0x00B7B7FF, 0x00B3B3FF, 0x00B1B1FF, 0x00B0B0FF, 0x00B0B0FF, 0x00C2C2FE, 0x00F4F3FA, 0x00FFFFFA, 0x00FFFDFA, 0x00FFFDFA, 0x00FFFDFA, 0x00FFFEFD, 0x00FFFCEA, 0x00DACEB8, 0x00717171, 0x56333334, 0xCE000000, 0xFA000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x965B5B5B, 0x00727273, 0x00C8C4C2, 0x00FBEBD2, 0x00FFF7E6, 0x00FFFEFC, 0x00FFFDFA, 0x00FFFDFA, 0x00FFFDFA, 0x00FFFDFA, 0x00FFFDFA, 0x00FFFDFA, 0x00FFFFFA, 0x00FAF9FA, 0x00D6D5FD, 0x00B8B8FF, 0x00B4B4FF, 
        0x00B5B5FF, 0x00B1B2FF, 0x00B0B0FF, 0x00B1B1FF, 0x00B1B1FF, 0x00AFAFFF, 0x00A9A9FF, 0x00BFBFFE, 0x00FDFBFA, 0x00FFFEFA, 0x00FFFDFA, 0x00FFFDFA, 0x00FFFDFC, 0x00FFFBF1, 0x00F7E6CB, 0x0082807D, 0x2A4A4A4A, 0xB3000000, 0xF0000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xD34A4A4A, 0x07686868, 0x00ADA9A7, 0x00F6E6D1, 0x00FFF1D8, 0x00FFFCFA, 0x00FFFCF9, 0x00FFFCF9, 0x00FFFCF9, 0x00FFFCF9, 0x00FFFCF9, 0x00FFFDF9, 0x00F8F6FA, 0x00C9C8FE, 0x00B3B3FF, 0x00B4B5FF, 0x00B2B2FF, 
        0x00B8B8FF, 0x00CAC9FD, 0x00CACAFD, 0x00B2B2FF, 0x00ABABFF, 0x00ACACFF, 0x00A9A9FF, 0x00A7A7FF, 0x00E6E4FB, 0x00FFFFF9, 0x00FFFCF9, 0x00FFFCF9, 0x00FFFCF9, 0x00FFFCF9, 0x00FFF3D9, 0x00A9A195, 0x0C5C5E5F, 0x93080808, 0xE3000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xF8000000, 0x39606060, 0x008B8989, 0x00E9D9C9, 0x00FFECCD, 0x00FFFAF4, 0x00FFFCFB, 0x00FFFCF9, 0x00FFFCF9, 0x00FFFCF9, 0x00FFFCF9, 0x00FFFFF9, 0x00D9D8FC, 0x00AEAEFF, 0x00B1B1FF, 0x00B1B1FF, 0x00D6D5FD, 
        0x00F6F5FA, 0x00FFFDF9, 0x00FFFFF9, 0x00ECEAFA, 0x00AFAFFF, 0x00A6A6FF, 0x00A7A7FF, 0x00A0A0FF, 0x00D5D4FC, 0x00FFFFF9, 0x00FFFCF9, 0x00FFFCF9, 0x00FFFCF9, 0x00FFFDFC, 0x00FFFAE8, 0x00D8C8B0, 0x006D6E6F, 0x55333333, 0xCF000000, 0xFB000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFE000000, 0x84565656, 0x00727273, 0x00D0C0B6, 0x00FDE7C5, 0x00FFF6E7, 0x00FFFDFC, 0x00FFFCF8, 0x00FFFCF9, 0x00FFFCF9, 0x00FFFCF9, 0x00FFFDF9, 0x00F9F8F9, 0x00DBDAFC, 0x00B6B6FE, 0x00DCDAFC, 0x00FFFFF8, 
        0x00FFFEF8, 0x00FFFDF8, 0x00FFFDF8, 0x00FFFFF8, 0x00D1CFFC, 0x00A0A0FF, 0x00A3A3FF, 0x009C9CFF, 0x00D4D2FC, 0x00FFFFF9, 0x00FFFCF9, 0x00FFFCF9, 0x00FFFCF9, 0x00FFFDFA, 0x00FFFAF1, 0x00FCE7C5, 0x008A8680, 0x214D4E4F, 0xB1000000, 0xEF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xC84A4A4A, 0x05646666, 0x00B2A59E, 0x00F8DFC1, 0x00FFEFD3, 0x00FFFDFA, 0x00FFFCF8, 0x00FFFCF8, 0x00FFFCF8, 0x00FFFCF8, 0x00FFFCF8, 0x00FFFDF8, 0x00FFFFF8, 0x00F8F5F9, 0x00FFFDF8, 0x00FFFDF8, 
        0x00FFFCF8, 0x00FFFCF8, 0x00FFFCF8, 0x00FFFFF8, 0x00D7D6FB, 0x009C9CFF, 0x009F9FFF, 0x009C9CFF, 0x00E6E4FA, 0x00FFFFF8, 0x00FFFCF8, 0x00FFFCF8, 0x00FFFCF8, 0x00FFFCF8, 0x00FFFCF8, 0x00FFF2D2, 0x00B2A795, 0x075D5E5F, 0x87111111, 0xDF000000, 
        0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xF3222222, 0x255D5E5F, 0x00958C88, 0x00EFD3BA, 0x00FFE8C1, 0x00FFFAF1, 0x00FFFDFA, 0x00FFFCF8, 0x00FFFCF8, 0x00FFFCF8, 0x00FFFCF8, 0x00FFFCF8, 0x00FFFCF8, 0x00FFFEF8, 0x00FFFCF8, 0x00FFFCF8, 
        0x00FFFCF8, 0x00FFFFF8, 0x00FFFFF8, 0x00F1EFF9, 0x00ADADFE, 0x009B9BFF, 0x009A9AFF, 0x00BCBBFD, 0x00FFFFF8, 0x00FFFEF8, 0x00FFFCF8, 0x00FFFCF8, 0x00FFFCF8, 0x00FFFCF8, 0x00FFFDFB, 0x00FFF7DF, 0x00D9C7A8, 0x006A6B6B, 0x522E2E2E, 0xCB000000, 
        0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFE000000, 0x62575758, 0x00777473, 0x00DEBFAB, 0x00FDE1B7, 0x00FFF4DF, 0x00FFFDFB, 0x00FFFCF7, 0x00FFFCF8, 0x00FFFCF8, 0x00FFFCF8, 0x00FFFCF8, 0x00FFFCF8, 0x00FFFCF8, 0x00FFFCF8, 0x00FFFCF8, 
        0x00FFFDF8, 0x00F0EEF9, 0x00CBCAFC, 0x00A4A4FE, 0x009999FF, 0x009999FF, 0x009A9AFF, 0x00C5C4FC, 0x00EAE9F9, 0x00FFFDF7, 0x00FFFFF7, 0x00FFFBF8, 0x00FFFBF8, 0x00FFFCF8, 0x00FFFCF9, 0x00FFFAF1, 0x00FAE3BD, 0x0087837C, 0x214A4B4B, 0xB0000000, 
        0xEF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xBB474747, 0x05626465, 0x00B69F93, 0x00FAD9B1, 0x00FFEDCC, 0x00FFFCF9, 0x00FFFBF7, 0x00FFFBF7, 0x00FFFBF7, 0x00FFFBF7, 0x00FFFBF7, 0x00FFFBF7, 0x00FFFBF7, 0x00FFFBF7, 0x00FFFBF7, 
        0x00FFFDF7, 0x00BCBBFC, 0x009191FF, 0x009696FF, 0x009697FF, 0x009595FF, 0x009595FF, 0x008F8FFF, 0x009392FF, 0x00ACABFD, 0x00E6E4F9, 0x00FFFEF7, 0x00FFFBF7, 0x00FFFBF7, 0x00FFFBF7, 0x00FFFCF9, 0x00FFF1D0, 0x00BBAC94, 0x035C5E60, 0x7A1C1C1C, 
        0xDD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xF5000000, 0x2C57595A, 0x008E817B, 0x00EFC9A8, 0x00FFE5B9, 0x00FFF9F0, 0x00FFFCF9, 0x00FFFBF7, 0x00FFFBF7, 0x00FFFBF7, 0x00FFFBF7, 0x00FFFBF7, 0x00FFFBF7, 0x00FFFBF7, 0x00FFFBF7, 
        0x00FFFFF7, 0x00D6D4FA, 0x008D8EFF, 0x009595FF, 0x009999FF, 0x009393FF, 0x008D8DFF, 0x008F8FFF, 0x008E8EFF, 0x008686FF, 0x009595FE, 0x00F2EFF8, 0x00FFFEF7, 0x00FFFBF7, 0x00FFFBF7, 0x00FFFDFB, 0x00FFF5DF, 0x00E8CFA7, 0x006B6B6A, 0x41373737, 
        0xC3000000, 0xF7000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFD000000, 0x69525353, 0x006F6C6B, 0x00DFB398, 0x00FDDBAB, 0x00FFF1D8, 0x00FFFCFA, 0x00FFFBF6, 0x00FFFBF6, 0x00FFFBF6, 0x00FFFBF6, 0x00FFFBF6, 0x00FFFBF6, 0x00FFFBF6, 0x00FFFBF6, 
        0x00FFFDF6, 0x00F6F3F7, 0x00C8C5FB, 0x00E1DEF9, 0x00F1EEF7, 0x00E3E2F8, 0x00B4B2FC, 0x008A8AFF, 0x008B8BFF, 0x008A8AFF, 0x008081FF, 0x00BFBDFB, 0x00FFFFF6, 0x00FFFBF6, 0x00FFFBF6, 0x00FFFCF8, 0x00FFF9EE, 0x00FEE2B4, 0x00898278, 0x1B48494A, 
        0xA7000000, 0xEB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xB2484848, 0x015E6061, 0x00BC9784, 0x00FCD0A2, 0x00FFE8BE, 0x00FFFBF6, 0x00FFFBF7, 0x00FFFBF6, 0x00FFFBF6, 0x00FFFBF6, 0x00FFFBF6, 0x00FFFBF6, 0x00FFFBF6, 0x00FFFBF6, 
        0x00FFFBF6, 0x00FFFCF6, 0x00FFFFF6, 0x00FFFFF6, 0x00FFFEF6, 0x00FFFFF6, 0x00FFFEF5, 0x00B6B4FC, 0x008282FF, 0x008686FF, 0x008181FF, 0x009292FE, 0x00FAF6F7, 0x00FFFDF6, 0x00FFFBF6, 0x00FFFBF6, 0x00FFFDF9, 0x00FFF0CC, 0x00BAA88C, 0x03585A5D, 
        0x761B1B1B, 0xDA000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xEE212121, 0x22545759, 0x008F7B72, 0x00F3BE96, 0x00FFE1AE, 0x00FFF7EB, 0x00FFFCF8, 0x00FFFBF6, 0x00FFFBF6, 0x00FFFBF6, 0x00FFFBF6, 0x00FFFBF6, 0x00FFFBF6, 0x00FFFBF6, 
        0x00FFFBF6, 0x00FFFBF6, 0x00FFFBF6, 0x00FFFBF6, 0x00FFFBF6, 0x00FFFBF6, 0x00FFFFF6, 0x00E0DDF8, 0x008383FF, 0x008181FF, 0x007F7FFF, 0x008483FF, 0x00F2EFF7, 0x00FFFEF6, 0x00FFFBF6, 0x00FFFBF6, 0x00FFFDFA, 0x00FFF6E2, 0x00EED1A2, 0x006D6C69, 
        0x363C3C3C, 0xC1000000, 0xF5000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0x754B4C4D, 0x00686564, 0x00D8A585, 0x00FFD69F, 0x00FFEFD4, 0x00FFFCF9, 0x00FFFAF5, 0x00FFFAF5, 0x00FFFAF5, 0x00FFFAF5, 0x00FFFAF5, 0x00FFFAF5, 0x00FFFAF5, 
        0x00FFFAF5, 0x00FFFAF5, 0x00FFFAF5, 0x00FFFAF5, 0x00FFFAF5, 0x00FFFAF5, 0x00FFFFF5, 0x00E4E0F7, 0x008080FF, 0x007E7EFF, 0x007A7AFF, 0x008888FE, 0x00F8F3F6, 0x00FFFDF5, 0x00FFFAF5, 0x00FFFAF5, 0x00FFFAF7, 0x00FFF9F1, 0x00FFE5B2, 0x00968B79, 
        0x104B4C4F, 0x9C060606, 0xE7000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xC4404040, 0x0455595B, 0x00B18873, 0x00FDC793, 0x00FFE4B3, 0x00FFFAF4, 0x00FFFAF6, 0x00FFFAF5, 0x00FFFAF5, 0x00FFFAF5, 0x00FFFAF5, 0x00FFFAF5, 0x00FFFAF5, 
        0x00FFFBF5, 0x00FFFCF5, 0x00FFFBF5, 0x00FFFBF5, 0x00FFFBF5, 0x00FFFFF5, 0x00FFFEF4, 0x00B1AFFC, 0x007878FF, 0x007B7BFF, 0x007171FF, 0x00B2B0FB, 0x00FFFEF5, 0x00FFFAF5, 0x00FFFAF5, 0x00FFFAF5, 0x00FFFAF5, 0x00FFFCF9, 0x00FFEFC7, 0x00C5AD88, 
        0x0157595C, 0x65212121, 0xD4000000, 0xFC000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF3161616, 0x274E5254, 0x00897065, 0x00F5B281, 0x00FFDA9F, 0x00FFF3E0, 0x00FFFCF8, 0x00FFFAF4, 0x00FFFAF5, 0x00FFFAF5, 0x00FFFAF5, 0x00FFFAF5, 0x00FFFBF4, 
        0x00FBF6F5, 0x00FBF6F5, 0x00FFFDF4, 0x00FFFFF4, 0x00FFFBF5, 0x00ECEAF6, 0x00B0ADFA, 0x007777FF, 0x007979FF, 0x007272FF, 0x008080FE, 0x00EDE9F6, 0x00FFFEF4, 0x00FFFAF5, 0x00FFFAF5, 0x00FFFAF5, 0x00FFFAF4, 0x00FFFCF8, 0x00FFF5E3, 0x00EFCF9B, 
        0x006C6A66, 0x303A3A3A, 0xBA000000, 0xF3000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0x6F494A4B, 0x00635F5E, 0x00DA9670, 0x00FFCF90, 0x00FFEBC5, 0x00FFFCF9, 0x00FFFAF4, 0x00FFFAF4, 0x00FFFAF4, 0x00FFFAF4, 0x00FFFAF4, 0x00FFFEF3, 
        0x00B5B2FA, 0x009190FD, 0x00ABAAFB, 0x00ADACFB, 0x009C9BFC, 0x008080FF, 0x007474FF, 0x007575FF, 0x006D6DFF, 0x008181FE, 0x00DFDDF6, 0x00FFFFF3, 0x00FFFAF4, 0x00FFFAF4, 0x00FFFAF4, 0x00FFFAF4, 0x00FFFAF4, 0x00FFFAF5, 0x00FFFBF6, 0x00FFE8B5, 
        0x00A89679, 0x064D5053, 0x89131313, 0xE3000000, 0xFE000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCD363636, 0x094F5457, 0x00A77A64, 0x00FEBE82, 0x00FFE1AB, 0x00FFFAF3, 0x00FFFBF5, 0x00FFFAF4, 0x00FFFAF4, 0x00FFFAF4, 0x00FFFEF4, 0x00EFEBF5, 
        0x008484FF, 0x007676FF, 0x007475FF, 0x007273FF, 0x007272FF, 0x007171FF, 0x006D6DFF, 0x006F6FFF, 0x009A9AFC, 0x00E8E6F6, 0x00FFFFF3, 0x00FFFAF4, 0x00FFFAF4, 0x00FFFAF4, 0x00FFFAF4, 0x00FFFAF5, 0x00FFFBF6, 0x00FFFCF9, 0x00FFFDFC, 0x00FFF0CD, 
        0x00E0BF8B, 0x005E5D5C, 0x43323333, 0xC8000000, 0xF8000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF7000000, 0x3C494C4D, 0x0077645B, 0x00F2A46E, 0x00FFD492, 0x00FFF0D7, 0x00FFFBF8, 0x00FFF9F3, 0x00FFFAF3, 0x00FFFAF3, 0x00FFFFF2, 0x00CCC9F8, 
        0x007171FF, 0x006F70FF, 0x006E6EFF, 0x006D6DFF, 0x007272FF, 0x008281FE, 0x00A4A3FB, 0x00D2D0F7, 0x00FEFBF3, 0x00FFFFF3, 0x00FFF9F3, 0x00FFFAF3, 0x00FFFAF4, 0x00FFFAF6, 0x00FFFCF9, 0x00FFFBF6, 0x00FFF5E7, 0x00FFEDD0, 0x00FFE5B8, 0x00FFDDA0, 
        0x00FAD090, 0x00777067, 0x1047494A, 0xA5000000, 0xEA000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0x85454545, 0x00595657, 0x00D5875B, 0x00FFC47F, 0x00FFE4B3, 0x00FFFAF7, 0x00FFF9F3, 0x00FFF9F3, 0x00FFF9F3, 0x00FFFBF3, 0x00F2EEF4, 
        0x00CECAF7, 0x00B7B4FA, 0x00B3B1FA, 0x00BAB7F9, 0x00D5D1F7, 0x00F6F1F4, 0x00FFFEF3, 0x00FFFFF2, 0x00FFFAF3, 0x00FFF9F4, 0x00FFFAF6, 0x00FFFBF9, 0x00FFF9F3, 0x00FFF5E7, 0x00FFEDD1, 0x00FFE2B1, 0x00FFD795, 0x00FDD08A, 0x00FBC884, 0x00F9BF81, 
        0x00F2B47D, 0x00786E64, 0x0C48494B, 0x89000000, 0xDD000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xD2333333, 0x0A4A4F53, 0x00A16C53, 0x00FEAE6B, 0x00FFD997, 0x00FFF5E6, 0x00FFFAF6, 0x00FFF9F2, 0x00FFF9F3, 0x00FFF9F3, 0x00FFFBF2, 
        0x00FFFFF2, 0x00FFFFF2, 0x00FFFFF2, 0x00FFFFF2, 0x00FFFFF2, 0x00FFFBF2, 0x00FFFAF3, 0x00FFFAF5, 0x00FFFBF9, 0x00FFFAF4, 0x00FFF4E5, 0x00FFE8C1, 0x00FFDEA7, 0x00FFD692, 0x00FDCE86, 0x00FBC37E, 0x00F8BC7B, 0x00F7B176, 0x00F5A770, 0x00F8A065, 
        0x00F29758, 0x0074655C, 0x0D444748, 0x80000000, 0xD7000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF8000000, 0x4C444648, 0x00685954, 0x00ED9359, 0x00FFCD82, 0x00FFE7C0, 0x00FFFBF8, 0x00FFF9F2, 0x00FFF9F2, 0x00FFF9F2, 0x00FFF9F2, 
        0x00FFF9F2, 0x00FFF9F2, 0x00FFF9F2, 0x00FFFAF3, 0x00FFFBF6, 0x00FFFCF9, 0x00FFFAF4, 0x00FFF5E5, 0x00FFE8C2, 0x00FFDEA5, 0x00FFD48E, 0x00FDCC80, 0x00FCC27B, 0x00F9BB78, 0x00F8AF72, 0x00F6A66B, 0x00F79E61, 0x00F89551, 0x00FC8F45, 0x00FF873E, 
        0x00F57F41, 0x00766157, 0x0C434647, 0x80000000, 0xD8000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xA43B3C3C, 0x004D5053, 0x00C1754B, 0x00FFB96E, 0x00FFDB9D, 0x00FFF8F0, 0x00FFF9F3, 0x00FFF9F2, 0x00FFF9F2, 0x00FFF9F2, 
        0x00FFF9F3, 0x00FFFBF6, 0x00FFFBF9, 0x00FFF8F0, 0x00FFF0DB, 0x00FFE7BF, 0x00FFDDA5, 0x00FFD28A, 0x00FDC87B, 0x00FCC076, 0x00FAB772, 0x00F9AC6D, 0x00F8A263, 0x00F89957, 0x00F9914A, 0x00FC893F, 0x00FF8237, 0x00F67A39, 0x00D87142, 0x00AE684C, 
        0x00855F51, 0x005A5554, 0x12414141, 0x82000000, 0xD9000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE9232323, 0x1743494D, 0x008F5E47, 0x00FF9E53, 0x00FFD185, 0x00FFF1DB, 0x00FFFBF6, 0x00FFFAF3, 0x00FFFBF6, 0x00FFFCF8, 
        0x00FFF9F1, 0x00FFF1DA, 0x00FFE6BD, 0x00FFD998, 0x00FFCF83, 0x00FEC878, 0x00FDBF71, 0x00FBB36C, 0x00FAAA68, 0x00F99E5E, 0x00F99451, 0x00FA8E43, 0x00FD8333, 0x00FF7D2D, 0x00F97531, 0x00DB6C3C, 0x00B06446, 0x00795B50, 0x00555353, 0x01464D50, 
        0x0F3B4042, 0x242E2F2F, 0x52111111, 0x9A000000, 0xE2000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFB000000, 0x54414444, 0x0061514D, 0x00ED7F3E, 0x00FFC06F, 0x00FFE5B7, 0x00FFFCFB, 0x00FFF8EF, 0x00FFF0DB, 0x00FFE6BD, 
        0x00FFD897, 0x00FFCE7F, 0x00FEC774, 0x00FDBD6F, 0x00FCB269, 0x00FBA862, 0x00FA9C58, 0x00FA924C, 0x00FC8A3E, 0x00FF812C, 0x00FF7926, 0x00F7712A, 0x00DC6835, 0x00B06141, 0x007C594C, 0x00545252, 0x02464B4E, 0x0E3C4043, 0x222F3030, 0x46151616, 
        0x69020202, 0x83000000, 0xA4000000, 0xCE000000, 0xF3000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xB8333333, 0x04444A4F, 0x00AE623B, 0x00FFA654, 0x00FFD489, 0x00FFE0AC, 0x00FFD692, 0x00FFCD7D, 0x00FEC26E, 
        0x00FDB967, 0x00FCAF63, 0x00FCA25B, 0x00FB9752, 0x00FC8E43, 0x00FD8431, 0x00FF7B23, 0x00FF721F, 0x00F96923, 0x00D56230, 0x009C5C42, 0x006F544B, 0x00524F4E, 0x02444A4D, 0x11383D3E, 0x2C252627, 0x4C131313, 0x6B030303, 0x83000000, 0x9E000000, 
        0xBC000000, 0xD5000000, 0xE8000000, 0xF6000000, 0xFE000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF4000000, 0x2E3D4346, 0x00765142, 0x00FD8737, 0x00FFC975, 0x00FFC26B, 0x00FEB865, 0x00FEAE60, 0x00FDA057, 
        0x00FC964E, 0x00FD8B3D, 0x00FF8129, 0x00FF791C, 0x00FF6E17, 0x00FB651A, 0x00D95F29, 0x009F583D, 0x00705248, 0x004F4D4E, 0x0140494D, 0x11383B3C, 0x2C252626, 0x4C131313, 0x6D010101, 0x88000000, 0xA5000000, 0xC0000000, 0xD5000000, 0xE6000000, 
        0xF4000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0x773B3C3D, 0x004B494B, 0x00D3682D, 0x00FFA451, 0x00FE9F53, 0x00FE9245, 0x00FE8733, 0x00FF7C24, 
        0x00FF7216, 0x00FF6810, 0x00F06016, 0x00CA5A27, 0x00A05337, 0x00724F43, 0x004F4C4C, 0x053C454A, 0x16323637, 0x2D262627, 0x4A131313, 0x6D010101, 0x88000000, 0xA5000000, 0xC0000000, 0xD8000000, 0xEA000000, 0xF6000000, 0xFD000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xC8303030, 0x053D464B, 0x008E5538, 0x00FF7D23, 0x00FF7A1D, 0x00FF6C0A, 0x00FF6306, 0x00F35A0F, 
        0x00CD5421, 0x009A5034, 0x00614D47, 0x00474A4C, 0x043B4448, 0x15313638, 0x2D242425, 0x540B0B0B, 0x74000000, 0x8D000000, 0xA6000000, 0xBF000000, 0xD8000000, 0xEA000000, 0xF6000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF7000000, 0x423D3F41, 0x005D4C45, 0x00F45C09, 0x00F65607, 0x00D0501A, 0x009E4D2E, 0x00634C44, 
        0x00474A4B, 0x053B4448, 0x14333638, 0x2C252626, 0x520D0D0D, 0x72000000, 0x8C000000, 0xA9000000, 0xC6000000, 0xDC000000, 0xEA000000, 0xF5000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0x9F353535, 0x00494848, 0x00774A3A, 0x00634941, 0x0048494A, 0x053B4448, 0x1A2E3233, 
        0x371D1E1E, 0x580B0B0B, 0x74000000, 0x8C000000, 0xA7000000, 0xC5000000, 0xDC000000, 0xEC000000, 0xF8000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE81C1C1C, 0x3A3F3F3F, 0x113B4144, 0x1F2D3132, 0x361F2020, 0x570B0B0B, 0x76000000, 
        0x92000000, 0xB0000000, 0xC8000000, 0xDC000000, 0xEB000000, 0xF8000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFB000000, 0xDB000000, 0xA3000000, 0x89000000, 0x96000000, 0xAF000000, 0xC8000000, 
        0xDF000000, 0xEF000000, 0xF9000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF
#endif
};

GUI_CONST_STORAGE GUI_BITMAP _bmDate = {
  48, // XSize */
  48, // YSize */
  192, // BytesPerLine */
  32, // BitsPerPixel */
  (unsigned char *)_acDate,  // Pointer to picture data */
  NULL,  // Pointer to palette */
#if (GUI_USE_ARGB == 1)
  GUI_DRAW_BMPM8888I
#else
  GUI_DRAW_BMP8888
#endif
};

/*********************************************************************
*
*       _bmEmail
*
* Function description
*   Icon bitmap with alpha channel
*/
static GUI_CONST_STORAGE unsigned long _acEmail[] = {
#if (GUI_USE_ARGB == 1)
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x323C3C9F, 0x8D39399F, 0xC737379D, 0x90363694, 0x15000000, 0x06000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3A3E3EA0, 0xA439399E, 0xF93738A0, 0xFF5655B2, 0xFF6562CB, 0xFF3F3EAF, 0x89232362, 0x1F000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x024343A5, 0x573F3F9F, 0xC03A3A9F, 0xFC3B3BA2, 0xFF5556B8, 0xFFAAABDC, 0xFFE7E6F7, 0xFF9791FE, 0xFF656AD0, 0xE930308E, 0x4F030309, 0x11000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x1941419E, 0x6C40409E, 0xC93B3B9C, 0xFF4343A7, 0xFF6667C0, 0xFF9497E2, 0xFFCBCEFC, 0xFFFFFFFF, 0xFFBAB6FA, 0xFF9FA2F7, 0xFFB3BCF3, 0xFF3F41AE, 0x9F1A1A4B, 0x2A000000, 0x04000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x214444A0, 0x7C40409E, 0xE63C3C9E, 0xFF4747A9, 0xFF6A6BC2, 0xFFA2A6EA, 0xFFCBCEFF, 0xFFD5D8FF, 0xFFF6F8FF, 0xFFE7E5FC, 0xFF7F7BF1, 0xFFB3C4FA, 0xFFD9E1FF, 0xFF737BD6, 0xE82E2D8B, 0x54060610, 0x10000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3244449E, 
        0xA141419E, 0xEF3E3E9F, 0xFF4E4FAD, 0xFF7F81D2, 0xFFADB1F1, 0xFFCCD0FF, 0xFFD7D9FF, 0xFFD9DBFF, 0xFFE9EBFF, 0xFFFFFEFF, 0xFF9893F3, 0xFF99A0F3, 0xFFC1D3FF, 0xFFD2DCFF, 0xFFBBC2F9, 0xFF4043AF, 0xA91F1F59, 0x2B000000, 0x04000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3444449E, 0xA941419C, 0xF440409F, 
        0xFF5051AD, 0xFF8386D5, 0xFFB3B7F5, 0xFFD0D4FF, 0xFFD5D8FF, 0xFFD9DCFF, 0xFFDFE2FF, 0xFFE5E7FF, 0xFFFFFFFF, 0xFFD0CDF9, 0xFF7F7EED, 0xFFBFCFFA, 0xFFC5D5FF, 0xFFC5D4FF, 0xFFDAE1FF, 0xFF6C72D0, 0xE72C2B87, 0x51000000, 0x12000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0A4A4AA3, 0x5945459D, 0xB442419C, 0xF74444A0, 0xFF5E5FB7, 0xFF898CD8, 
        0xFFB6BAF6, 0xFFD0D4FF, 0xFFD6D9FF, 0xFFDADDFF, 0xFFE0E2FF, 0xFFE5E7FF, 0xFFEAEBFF, 0xFFF5F6FF, 0xFFFBFBFE, 0xFF938EEF, 0xFFA8B0F3, 0xFFCBD8FF, 0xFFCAD6FF, 0xFFC8D5FF, 0xFFD6DFFF, 0xFFB2B9F7, 0xFE4042B0, 0xA21D1C52, 0x29000000, 0x04000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1248489A, 0x5F48479D, 0xD343439B, 0xFF4A49A4, 0xFF6364BA, 0xFF9295DE, 0xFFC0C4FE, 0xFFD1D4FF, 
        0xFFD6D9FF, 0xFFDBDDFF, 0xFFE1E3FF, 0xFFE7E8FF, 0xFFEBECFF, 0xFFEFF0FF, 0xFFF3F4FF, 0xFFFFFFFF, 0xFFBBB7F5, 0xFF8B8BEC, 0xFFCDD8FC, 0xFFCDD8FF, 0xFFCED7FF, 0xFFCED8FF, 0xFFD0D9FF, 0xFFE0E3FF, 0xFF7176D3, 0xEB2D2C8C, 0x5204040B, 0x11000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x184A4A9C, 0x8748489C, 0xDF45449C, 0xFF4C4CA5, 0xFF7375C7, 0xFFA4A7EB, 0xFFC4C9FF, 0xFFD2D6FF, 0xFFD6D9FF, 0xFFDCDFFF, 
        0xFFE2E4FF, 0xFFE7E9FF, 0xFFECEDFF, 0xFFF0F1FF, 0xFFF3F3FF, 0xFFF5F5FF, 0xFFFEFEFF, 0xFFF2F1FD, 0xFF827DEA, 0xFFB8BFF4, 0xFFD4DDFF, 0xFFD1D9FF, 0xFFD2D9FF, 0xFFD3DAFF, 0xFFD3DAFF, 0xFFDFE3FF, 0xFFB3B7F5, 0xFF3C3EAD, 0xB1222263, 0x2E000000, 
        0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3B4C4C9C, 0x9649499A, 0xE446459C, 0xFF5757AD, 0xFF7C7ECD, 0xFFA7AAED, 0xFFC9CDFF, 0xFFD2D6FF, 0xFFD8DAFF, 0xFFDDDFFF, 0xFFE2E4FF, 0xFFE8EAFF, 
        0xFFECEEFF, 0xFFF0F1FF, 0xFFF3F4FF, 0xFFF6F7FF, 0xFFF7F8FF, 0xFFFBFBFF, 0xFFFFFFFF, 0xFFACA9F1, 0xFF999AEB, 0xFFD6DDFD, 0xFFD5DCFF, 0xFFD6DCFF, 0xFFD7DCFF, 0xFFD7DCFF, 0xFFD8DDFF, 0xFFD9DEFF, 0xFFDDE0FF, 0xFF7176D7, 0xF02F2F92, 0x5D070713, 
        0x15000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3F4C4C9C, 0xAB49499B, 0xFB4A499D, 0xFF5B5CAF, 0xFF8183D1, 0xFFB3B6F7, 0xFFCBCFFF, 0xFFD3D6FF, 0xFFD8DAFF, 0xFFDEE0FF, 0xFFE4E6FF, 0xFFE8EAFF, 0xFFECEEFF, 0xFFF1F2FF, 
        0xFFF3F4FF, 0xFFF6F7FF, 0xFFF9F9FF, 0xFFFAFBFF, 0xFFFBFCFF, 0xFFFFFFFF, 0xFFDEDDF9, 0xFF7C78E5, 0xFFCBCFF7, 0xFFDBE0FF, 0xFFDADDFF, 0xFFDADDFF, 0xFFDBDEFF, 0xFFDCDFFF, 0xFFDCDEFF, 0xFFDDDEFF, 0xFFE5E6FF, 0xFFB7BBF9, 0xFF3F41B1, 0xAC1D1D55, 
        0x2F000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x045252A1, 0x474E4E9D, 0xB249499A, 0xFD4C4CA0, 0xFF5E5FB1, 0xFF898BD6, 0xFFB7BCFA, 0xFFCBCFFF, 0xFFD2D5FF, 0xFFD7DAFF, 0xFFDEE0FF, 0xFFE3E5FF, 0xFFE9EAFF, 0xFFEDEEFF, 0xFFF1F2FF, 0xFFF3F4FF, 0xFFF6F7FF, 
        0xFFF9F9FF, 0xFFFAFAFF, 0xFFFBFBFF, 0xFFFCFDFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF9E9AEC, 0xFFA09FEA, 0xFFDEE2FF, 0xFFDDDFFF, 0xFFDDDFFF, 0xFFDEDFFF, 0xFFDFE0FF, 0xFFE0E0FF, 0xFFE0E0FF, 0xFFE1E1FF, 0xFFE3E3FF, 0xFFDEE1FF, 0xFF7378DB, 0xEE2E2E90, 
        0x5D090918, 0x13000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x3250509B, 0xC94F4F9D, 0xFF5252A0, 0xFF7071B9, 0xFF9C9FE2, 0xFFBBBFFC, 0xFFCCD0FF, 0xFFD2D4FF, 0xFFD7DAFF, 0xFFDEE0FF, 0xFFE4E6FF, 0xFFEAEBFF, 0xFFEEEFFF, 0xFFF1F2FF, 0xFFF5F5FF, 0xFFF7F7FF, 0xFFF9F9FF, 0xFFFAFBFF, 
        0xFFFCFBFF, 0xFFFDFDFF, 0xFFFDFDFF, 0xFFFEFEFF, 0xFFFFFFFF, 0xFFD0CEF6, 0xFF8682E3, 0xFFD7D8F8, 0xFFE1E2FF, 0xFFE1E1FF, 0xFFE2E2FF, 0xFFE2E3FF, 0xFFE3E3FF, 0xFFE4E4FF, 0xFFE4E4FF, 0xFFE5E5FF, 0xFFE5E5FF, 0xFFE8E9FF, 0xFFB6BCFA, 0xFF4042B2, 
        0xB120205F, 0x30000000, 0x06000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xD04F4F9F, 0xFF5C5CA6, 0xFFACACD4, 0xFFF0F0F9, 0xFFFFFFFF, 0xFFFCFDFF, 0xFFF5F7FF, 0xFFF2F3FF, 0xFFEFF0FF, 0xFFEFF0FF, 0xFFEFF1FF, 0xFFF2F3FF, 0xFFF4F4FF, 0xFFF7F8FF, 0xFFF9F9FF, 0xFFFAFBFF, 0xFFFCFCFF, 0xFFFDFDFF, 
        0xFFFDFDFF, 0xFFFEFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF9F9FE, 0xFF8883E5, 0xFFB2B0EC, 0xFFE7E7FF, 0xFFE4E4FF, 0xFFE4E4FF, 0xFFE5E5FF, 0xFFE6E6FF, 0xFFE7E7FF, 0xFFE7E7FF, 0xFFE8E8FF, 0xFFE8E8FF, 0xFFE8E8FF, 0xFFEAEAFF, 0xFFDDE2FF, 0xFF6D71D7, 
        0xEC2D2D8D, 0x5A05050D, 0x14000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xD750509D, 0xFF5656A3, 0xFF6868AC, 0xFF6D6DB2, 0xFF9090C7, 0xFFB1B0D8, 0xFFC9C8E4, 0xFFE0DFF0, 0xFFF3F3FA, 0xFFFBFBFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFFFF, 0xFFFEFEFF, 0xFFFEFEFF, 0xFFFEFEFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC1BFF2, 0xFF8D89E1, 0xFFE1E1F9, 0xFFE7E7FF, 0xFFE7E7FF, 0xFFE8E8FF, 0xFFE9E9FF, 0xFFE9E9FF, 0xFFEAEAFF, 0xFFEAEAFF, 0xFFEBEBFF, 0xFFEBEBFF, 0xFFEBEBFF, 0xFFECECFF, 0xFFECEEFF, 0xFFAEB5FC, 
        0xFF4242B5, 0xB020205F, 0x2E000000, 0x05000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x6B42427F, 0xFF4E4EA2, 0xFF9E9FD5, 0xFF9FA9D0, 0xFF6F7ABC, 0xFF676FB4, 0xFF696EB5, 0xFF686AB6, 0xFF6968B9, 0xFF7C7AC3, 0xFF9291D1, 0xFFA8A6DD, 0xFFC9C8EA, 0xFFE9E9F8, 0xFFF8F8FD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEDEDFC, 0xFF7E7ADF, 0xFFC9C8EF, 0xFFEBECFF, 0xFFE9E9FF, 0xFFEAEAFF, 0xFFEBEBFF, 0xFFEBEBFF, 0xFFECECFF, 0xFFECECFF, 0xFFEDEDFF, 0xFFEDEDFF, 0xFFEDEDFF, 0xFFEEEEFF, 0xFFEEEEFF, 0xFFF0F0FF, 0xFFDBE2FF, 
        0xFF7074DA, 0xF22F2E95, 0x5D060612, 0x15000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x18141427, 0xD346468F, 0xFF8283D5, 0xFFE6EDFF, 0xFFBCCFFD, 0xFFB7C9F7, 0xFFB2C0EE, 0xFFAAB6E5, 0xFFA1ABDD, 0xFF949BD3, 0xFF8589CB, 0xFF7879C3, 0xFF7676C4, 0xFF7877C8, 0xFF8281CF, 0xFF9290D8, 0xFFA4A2E2, 0xFFB8B6EA, 
        0xFFCFCEF2, 0xFFE7E6F9, 0xFFF6F6FD, 0xFFA09EE8, 0xFF9693E0, 0xFFEAEBFD, 0xFFEBEBFF, 0xFFECECFF, 0xFFEDEDFF, 0xFFEEEEFF, 0xFFEEEEFF, 0xFFEFEFFF, 0xFFEFEFFF, 0xFFF0F0FF, 0xFFF0F0FF, 0xFFF0F0FF, 0xFFF0F0FF, 0xFFF1F1FF, 0xFFF2F1FF, 0xFFEEF1FF, 
        0xFFA9B1F9, 0xFF403FB4, 0xAF1E1E59, 0x30000000, 0x05000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x04000000, 0x6337376D, 0xFF4D4EA5, 0xFFC0C1F3, 0xFFDBE7FF, 0xFFC1D2FF, 0xFFC9D7FF, 0xFFCEDAFF, 0xFFD1DBFF, 0xFFD1DBFF, 0xFFD3DBFE, 0xFFD3D9FA, 0xFFC8CDF0, 0xFFBCBEE7, 0xFFB3B4DF, 0xFFA7A6DA, 0xFF918FD3, 0xFF8481D1, 
        0xFF7F7CD2, 0xFF7B77D6, 0xFF7E79DC, 0xFF7F7BDA, 0xFFD8D8F1, 0xFFEFF0FF, 0xFFEDEDFF, 0xFFEEEEFF, 0xFFEFEFFF, 0xFFF0F0FF, 0xFFF1F1FF, 0xFFF1F1FF, 0xFFF2F2FF, 0xFFF2F2FF, 0xFFF2F2FF, 0xFFF3F3FF, 0xFFF3F3FF, 0xFFF3F3FF, 0xFFF3F2FF, 0xFFF6F5FF, 
        0xFFD8E1FF, 0xFF6D70DE, 0xF1302F94, 0x5F09091A, 0x15000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x1411111F, 0xDD464692, 0xFF8181D0, 0xFFEDF1FF, 0xFFC7D5FF, 0xFFC8D4FF, 0xFFCCD7FF, 0xFFCFD8FF, 0xFFD3DAFF, 0xFFD6DCFF, 0xFFD9DEFF, 0xFFDDE0FF, 0xFFE1E3FF, 0xFFE3E3FF, 0xFFE4E4FF, 0xFFE5E5FD, 0xFFE0E0F7, 
        0xFFD5D5EE, 0xFFCCCCEA, 0xFFBFBEE5, 0xFFCECDEA, 0xFFEEEEFE, 0xFFEFEFFF, 0xFFF0F0FF, 0xFFF1F1FF, 0xFFF1F1FF, 0xFFF2F2FF, 0xFFF3F3FF, 0xFFF3F3FF, 0xFFF3F3FF, 0xFFF4F4FF, 0xFFF3F3FF, 0xFFF4F4FF, 0xFFF4F4FF, 0xFFF4F4FF, 0xFFF4F4FF, 0xFFF6F6FF, 
        0xFFEDF2FF, 0xFFA4AFFA, 0xFF3F3EB3, 0xB21F1F5D, 0x31000000, 0x06000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x03000000, 0x6D3B3B74, 0xFE5050AB, 0xFFBEBFF8, 0xFFDEE7FF, 0xFFCAD5FF, 0xFFCFD8FF, 0xFFD2D9FF, 0xFFD5DBFF, 0xFFD8DDFF, 0xFFDBDEFF, 0xFFDEDFFF, 0xFFE1E1FF, 0xFFE4E3FF, 0xFFE6E6FF, 0xFFE8E8FF, 0xFFEBEBFF, 
        0xFFEEEEFF, 0xFFEEEEFF, 0xFFEFEFFF, 0xFFF0F0FF, 0xFFF0F0FF, 0xFFF0F0FF, 0xFFF2F2FF, 0xFFF3F3FF, 0xFFF3F3FF, 0xFFF4F4FF, 0xFFF4F4FF, 0xFFF5F5FF, 0xFFF5F5FF, 0xFFF5F5FF, 0xFFF5F5FF, 0xFFF6F6FF, 0xFFF5F5FF, 0xFFF5F5FF, 0xFFF6F6FF, 0xFFF8F8FF, 
        0xFFFCFBFF, 0xFFD6E3FF, 0xFF6B6EDD, 0xED2E2D91, 0x55000000, 0x13000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x11000000, 0xD043438C, 0xFF7777CC, 0xFFEAEDFF, 0xFFD1DAFF, 0xFFD2DAFF, 0xFFD6DBFF, 0xFFD8DCFF, 0xFFDBDEFF, 0xFFDFE0FF, 0xFFE1E1FF, 0xFFE4E4FF, 0xFFE6E6FF, 0xFFE8E8FF, 0xFFEAEAFF, 0xFFECECFF, 
        0xFFEDEDFF, 0xFFEEEEFF, 0xFFF0F0FF, 0xFFF1F1FF, 0xFFF2F2FF, 0xFFF3F3FF, 0xFFF4F4FF, 0xFFF4F4FF, 0xFFF5F5FF, 0xFFF5F5FF, 0xFFF6F6FF, 0xFFF6F6FF, 0xFFF7F7FF, 0xFFF7F7FF, 0xFFF7F7FF, 0xFFF7F7FF, 0xFFF8F8FF, 0xFFF9F9FF, 0xFFFAFAFF, 0xFFF2F6FF, 
        0xFFD8E0FF, 0xFFA6AFF9, 0xFF6566D7, 0xF834349E, 0x76000000, 0x22000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x04000000, 0x6D3D3D77, 0xFF4E4EA8, 0xFFC7C5F6, 0xFFE7ECFF, 0xFFD3DAFF, 0xFFD8DDFF, 0xFFDCDEFF, 0xFFDFE0FF, 0xFFE1E1FF, 0xFFE4E4FF, 0xFFE7E7FF, 0xFFE9E9FF, 0xFFEAEAFF, 0xFFECECFF, 0xFFEEEEFF, 
        0xFFEFEFFF, 0xFFF0F0FF, 0xFFF2F2FF, 0xFFF3F3FF, 0xFFF4F4FF, 0xFFF4F4FF, 0xFFF5F5FF, 0xFFF6F6FF, 0xFFF6F6FF, 0xFFF7F7FF, 0xFFF7F7FF, 0xFFF7F7FF, 0xFFF8F8FF, 0xFFF8F8FF, 0xFFF9F9FF, 0xFFFAFAFF, 0xFFFBFBFF, 0xFFF7F8FF, 0xFFDCDFFF, 0xFFA7ACF6, 
        0xFF6A6AD9, 0xFF3F3EB3, 0xF5303093, 0xCD1B1B4F, 0x76000000, 0x24000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x15131326, 0xD344448D, 0xFF7675D1, 0xFFE8E9FF, 0xFFDBDFFF, 0xFFDBDEFF, 0xFFDEDFFF, 0xFFE1E1FF, 0xFFE4E4FF, 0xFFE7E7FF, 0xFFE9E9FF, 0xFFEBEBFF, 0xFFECECFF, 0xFFEDEDFF, 0xFFF0F0FF, 
        0xFFF1F1FF, 0xFFF1F1FF, 0xFFF3F3FF, 0xFFF4F4FF, 0xFFF5F5FF, 0xFFF6F6FF, 0xFFF6F6FF, 0xFFF7F7FF, 0xFFF7F7FF, 0xFFF8F8FF, 0xFFF8F8FF, 0xFFF9F9FF, 0xFFF9F9FF, 0xFFFBFBFF, 0xFFFCFCFF, 0xFFF6F6FF, 0xFFDCDAFF, 0xFF9C9AF1, 0xFF5F5ECC, 0xFF3E3CAE, 
        0xF12D2C87, 0xCD181848, 0xA305050F, 0x7E000000, 0x49000000, 0x13000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x6438386F, 0xFF4D4CA8, 0xFFBDBCF3, 0xFFEDEFFF, 0xFFDCDEFF, 0xFFE1E1FF, 0xFFE4E4FF, 0xFFE7E7FF, 0xFFE9E9FF, 0xFFEBEBFF, 0xFFEDEDFF, 0xFFEEEEFF, 0xFFF0F0FF, 0xFFF1F1FF, 
        0xFFF2F2FF, 0xFFF4F4FF, 0xFFF5F5FF, 0xFFF6F6FF, 0xFFF6F6FF, 0xFFF7F7FF, 0xFFF8F8FF, 0xFFF8F8FF, 0xFFF9F9FF, 0xFFF9F9FF, 0xFFFAFAFF, 0xFFFCFCFF, 0xFFFEFEFF, 0xFFF8F7FF, 0xFFDBDAFF, 0xFF9996ED, 0xFF5B59C7, 0xFF3A39AA, 0xF02D2D85, 0xCB171743, 
        0x9F030309, 0x7A000000, 0x53000000, 0x30000000, 0x14000000, 0x04000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14101020, 0xD8444591, 0xFF7C7ACF, 0xFFF1F1FF, 0xFFE3E3FF, 0xFFE3E3FF, 0xFFE7E7FF, 0xFFE9E9FF, 0xFFEBEBFF, 0xFFEDEDFF, 0xFFEFEFFF, 0xFFF0F0FF, 0xFFF1F1FF, 0xFFF3F3FF, 
        0xFFF4F4FF, 0xFFF5F5FF, 0xFFF6F6FF, 0xFFF7F7FF, 0xFFF8F8FF, 0xFFF8F8FF, 0xFFF9F9FF, 0xFFF9F9FF, 0xFFFAFAFF, 0xFFFDFDFF, 0xFFFDFDFF, 0xFFF5F5FF, 0xFFCDCCFD, 0xFF908FE4, 0xFF5857C3, 0xFC3938A1, 0xE6282873, 0xC416163D, 0x9A020205, 0x78000000, 
        0x50000000, 0x2C000000, 0x13000000, 0x05000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x6D3B3B76, 0xFE4F4EAB, 0xFFBDBBF7, 0xFFF2F3FF, 0xFFE4E4FF, 0xFFE8E8FF, 0xFFEBEBFF, 0xFFEDEDFF, 0xFFEFEFFF, 0xFFF0F0FF, 0xFFF1F1FF, 0xFFF3F3FF, 0xFFF4F4FF, 
        0xFFF5F5FF, 0xFFF6F6FF, 0xFFF7F7FF, 0xFFF8F8FF, 0xFFF9F9FF, 0xFFF9F9FF, 0xFFFBFBFF, 0xFFFCFCFF, 0xFFFEFEFF, 0xFFEFEFFF, 0xFFC7C5FA, 0xFF8886E2, 0xFF4C4BBA, 0xFA35359A, 0xE328286E, 0xB70F0F25, 0x8F000000, 0x6D000000, 0x4A000000, 0x2A000000, 
        0x11000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x11000000, 0xD042428D, 0xFF706ECC, 0xFFEEEEFF, 0xFFEBEBFF, 0xFFE9E9FF, 0xFFEDEDFF, 0xFFEEEEFF, 0xFFF0F0FF, 0xFFF1F1FF, 0xFFF3F3FF, 0xFFF4F4FF, 0xFFF5F5FF, 
        0xFFF6F6FF, 0xFFF7F7FF, 0xFFF8F8FF, 0xFFF9F9FF, 0xFFFBFBFF, 0xFFFEFEFF, 0xFFFEFEFF, 0xFFECECFF, 0xFFB5B3F8, 0xFF7170D3, 0xFF4747B1, 0xF8363694, 0xD6212157, 0xAF0C0C1C, 0x8A000000, 0x67000000, 0x40000000, 0x22000000, 0x0E000000, 0x04000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x6A3B3B76, 0xFF4C4AA8, 0xFFAFACF0, 0xFFF6F6FF, 0xFFEBEBFF, 0xFFEEEEFF, 0xFFF0F0FF, 0xFFF2F2FF, 0xFFF3F3FF, 0xFFF4F4FF, 0xFFF5F5FF, 0xFFF7F7FF, 
        0xFFF8F8FF, 0xFFF9F9FF, 0xFFFAFAFF, 0xFFFDFDFF, 0xFFFCFCFF, 0xFFE2E0FF, 0xFFA9A7EE, 0xFF6D6CCE, 0xFF4443AF, 0xEE303082, 0xD11F2050, 0xA9090917, 0x83000000, 0x5D000000, 0x3A000000, 0x1E000000, 0x0B000000, 0x01000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14101020, 0xD343448E, 0xFF6A68C4, 0xFFEDECFF, 0xFFF0F1FF, 0xFFEFEFFF, 0xFFF1F1FF, 0xFFF3F3FF, 0xFFF4F4FF, 0xFFF5F5FF, 0xFFF6F6FF, 0xFFF8F8FF, 
        0xFFFAFAFF, 0xFFFEFEFF, 0xFFFBFBFF, 0xFFDDDBFF, 0xFFA3A0EC, 0xFF5F5DC7, 0xFF4140A6, 0xED31317F, 0xC81A1A40, 0x9B010102, 0x79000000, 0x55000000, 0x34000000, 0x19000000, 0x08000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x65383972, 0xFF4C4CA6, 0xFFBAB7F4, 0xFFFAFAFF, 0xFFF0F0FF, 0xFFF2F2FF, 0xFFF4F4FF, 0xFFF5F5FF, 0xFFF6F6FF, 0xFFF9F9FF, 0xFFFDFEFF, 
        0xFFF9F8FF, 0xFFD9D8FE, 0xFF9997E8, 0xFF5A58C2, 0xFD4040A1, 0xEB31317A, 0xC619193C, 0x98000000, 0x76000000, 0x4D000000, 0x2A000000, 0x13000000, 0x07000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x12090912, 0xC942428B, 0xFF6C69CC, 0xFFEAE8FF, 0xFFF5F5FF, 0xFFF3F3FF, 0xFFF5F5FF, 0xFFF9F9FF, 0xFFFEFEFF, 0xFFF8F8FF, 0xFFCDCAFD, 
        0xFF8683DD, 0xFF5453B7, 0xFB3F3E9B, 0xE02B2B65, 0xBA13132B, 0x92000000, 0x72000000, 0x4B000000, 0x28000000, 0x10000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x55333367, 0xFD4847A4, 0xFFB0ADEE, 0xFFFDFDFF, 0xFFF7F7FF, 0xFFFDFDFF, 0xFFEEEDFF, 0xFFBFBCF5, 0xFF817ED6, 0xFF5150B5, 
        0xF53A3A8E, 0xD928285C, 0xB3101023, 0x8B000000, 0x67000000, 0x42000000, 0x24000000, 0x0F000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0D000000, 0xCD42438D, 0xFF706DC9, 0xFFF2F0FF, 0xFFEDECFF, 0xFFB5B3F1, 0xFF706DD1, 0xFF4A49AB, 0xF3393987, 0xD5252552, 
        0xA506060E, 0x82000000, 0x5E000000, 0x3B000000, 0x1E000000, 0x0B000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x5734346B, 0xFF5050A8, 0xFF817DDC, 0xFF6A68C3, 0xFF4949A7, 0xEB363679, 0xC71C1D3F, 0x9F040409, 0x7D000000, 
        0x58000000, 0x33000000, 0x19000000, 0x09000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0D000000, 0xA33E3E7E, 0xEA42428D, 0xE033336E, 0xC01A1A37, 0x96000000, 0x73000000, 0x4E000000, 0x2D000000, 
        0x15000000, 0x06000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x1D000000, 0x52000000, 0x71000000, 0x67000000, 0x47000000, 0x26000000, 0x10000000, 0x04000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x06000000, 0x16000000, 0x20000000, 0x1B000000, 0x0D000000, 0x03000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF
#else
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCD9F3C3C, 0x729F3939, 0x389D3737, 0x6F943636, 0xEA000000, 0xF9000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xC5A03E3E, 0x5B9E3939, 0x06A03837, 0x00B25556, 0x00CB6265, 0x00AF3E3F, 0x76622323, 0xE0000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFDA54343, 0xA89F3F3F, 0x3F9F3A3A, 0x03A23B3B, 0x00B85655, 0x00DCABAA, 0x00F7E6E7, 0x00FE9197, 0x00D06A65, 0x168E3030, 0xB0090303, 0xEE000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xE69E4141, 0x939E4040, 0x369C3B3B, 0x00A74343, 0x00C06766, 0x00E29794, 0x00FCCECB, 0x00FFFFFF, 0x00FAB6BA, 0x00F7A29F, 0x00F3BCB3, 0x00AE413F, 0x604B1A1A, 0xD5000000, 0xFB000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xDEA04444, 0x839E4040, 0x199E3C3C, 0x00A94747, 0x00C26B6A, 0x00EAA6A2, 0x00FFCECB, 0x00FFD8D5, 0x00FFF8F6, 0x00FCE5E7, 0x00F17B7F, 0x00FAC4B3, 0x00FFE1D9, 0x00D67B73, 0x178B2D2E, 0xAB100606, 0xEF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCD9E4444, 
        0x5E9E4141, 0x109F3E3E, 0x00AD4F4E, 0x00D2817F, 0x00F1B1AD, 0x00FFD0CC, 0x00FFD9D7, 0x00FFDBD9, 0x00FFEBE9, 0x00FFFEFF, 0x00F39398, 0x00F3A099, 0x00FFD3C1, 0x00FFDCD2, 0x00F9C2BB, 0x00AF4340, 0x56591F1F, 0xD4000000, 0xFB000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCB9E4444, 0x569C4141, 0x0B9F4040, 
        0x00AD5150, 0x00D58683, 0x00F5B7B3, 0x00FFD4D0, 0x00FFD8D5, 0x00FFDCD9, 0x00FFE2DF, 0x00FFE7E5, 0x00FFFFFF, 0x00F9CDD0, 0x00ED7E7F, 0x00FACFBF, 0x00FFD5C5, 0x00FFD4C5, 0x00FFE1DA, 0x00D0726C, 0x18872B2C, 0xAE000000, 0xED000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF5A34A4A, 0xA69D4545, 0x4B9C4142, 0x08A04444, 0x00B75F5E, 0x00D88C89, 
        0x00F6BAB6, 0x00FFD4D0, 0x00FFD9D6, 0x00FFDDDA, 0x00FFE2E0, 0x00FFE7E5, 0x00FFEBEA, 0x00FFF6F5, 0x00FEFBFB, 0x00EF8E93, 0x00F3B0A8, 0x00FFD8CB, 0x00FFD6CA, 0x00FFD5C8, 0x00FFDFD6, 0x00F7B9B2, 0x01B04240, 0x5D521C1D, 0xD6000000, 0xFB000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xED9A4848, 0xA09D4748, 0x2C9B4343, 0x00A4494A, 0x00BA6463, 0x00DE9592, 0x00FEC4C0, 0x00FFD4D1, 
        0x00FFD9D6, 0x00FFDDDB, 0x00FFE3E1, 0x00FFE8E7, 0x00FFECEB, 0x00FFF0EF, 0x00FFF4F3, 0x00FFFFFF, 0x00F5B7BB, 0x00EC8B8B, 0x00FCD8CD, 0x00FFD8CD, 0x00FFD7CE, 0x00FFD8CE, 0x00FFD9D0, 0x00FFE3E0, 0x00D37671, 0x148C2C2D, 0xAD0B0404, 0xEE000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE79C4A4A, 0x789C4848, 0x209C4445, 0x00A54C4C, 0x00C77573, 0x00EBA7A4, 0x00FFC9C4, 0x00FFD6D2, 0x00FFD9D6, 0x00FFDFDC, 
        0x00FFE4E2, 0x00FFE9E7, 0x00FFEDEC, 0x00FFF1F0, 0x00FFF3F3, 0x00FFF5F5, 0x00FFFEFE, 0x00FDF1F2, 0x00EA7D82, 0x00F4BFB8, 0x00FFDDD4, 0x00FFD9D1, 0x00FFD9D2, 0x00FFDAD3, 0x00FFDAD3, 0x00FFE3DF, 0x00F5B7B3, 0x00AD3E3C, 0x4E632222, 0xD1000000, 
        0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xC49C4C4C, 0x699A4949, 0x1B9C4546, 0x00AD5757, 0x00CD7E7C, 0x00EDAAA7, 0x00FFCDC9, 0x00FFD6D2, 0x00FFDAD8, 0x00FFDFDD, 0x00FFE4E2, 0x00FFEAE8, 
        0x00FFEEEC, 0x00FFF1F0, 0x00FFF4F3, 0x00FFF7F6, 0x00FFF8F7, 0x00FFFBFB, 0x00FFFFFF, 0x00F1A9AC, 0x00EB9A99, 0x00FDDDD6, 0x00FFDCD5, 0x00FFDCD6, 0x00FFDCD7, 0x00FFDCD7, 0x00FFDDD8, 0x00FFDED9, 0x00FFE0DD, 0x00D77671, 0x0F922F2F, 0xA2130707, 
        0xEA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xC09C4C4C, 0x549B4949, 0x049D494A, 0x00AF5C5B, 0x00D18381, 0x00F7B6B3, 0x00FFCFCB, 0x00FFD6D3, 0x00FFDAD8, 0x00FFE0DE, 0x00FFE6E4, 0x00FFEAE8, 0x00FFEEEC, 0x00FFF2F1, 
        0x00FFF4F3, 0x00FFF7F6, 0x00FFF9F9, 0x00FFFBFA, 0x00FFFCFB, 0x00FFFFFF, 0x00F9DDDE, 0x00E5787C, 0x00F7CFCB, 0x00FFE0DB, 0x00FFDDDA, 0x00FFDDDA, 0x00FFDEDB, 0x00FFDFDC, 0x00FFDEDC, 0x00FFDEDD, 0x00FFE6E5, 0x00F9BBB7, 0x00B1413F, 0x53551D1D, 
        0xD0000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFBA15252, 0xB89D4E4E, 0x4D9A4949, 0x02A04C4C, 0x00B15F5E, 0x00D68B89, 0x00FABCB7, 0x00FFCFCB, 0x00FFD5D2, 0x00FFDAD7, 0x00FFE0DE, 0x00FFE5E3, 0x00FFEAE9, 0x00FFEEED, 0x00FFF2F1, 0x00FFF4F3, 0x00FFF7F6, 
        0x00FFF9F9, 0x00FFFAFA, 0x00FFFBFB, 0x00FFFDFC, 0x00FFFFFF, 0x00FFFFFF, 0x00EC9A9E, 0x00EA9FA0, 0x00FFE2DE, 0x00FFDFDD, 0x00FFDFDD, 0x00FFDFDE, 0x00FFE0DF, 0x00FFE0E0, 0x00FFE0E0, 0x00FFE1E1, 0x00FFE3E3, 0x00FFE1DE, 0x00DB7873, 0x11902E2E, 
        0xA2180909, 0xEC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xCD9B5050, 0x369D4F4F, 0x00A05252, 0x00B97170, 0x00E29F9C, 0x00FCBFBB, 0x00FFD0CC, 0x00FFD4D2, 0x00FFDAD7, 0x00FFE0DE, 0x00FFE6E4, 0x00FFEBEA, 0x00FFEFEE, 0x00FFF2F1, 0x00FFF5F5, 0x00FFF7F7, 0x00FFF9F9, 0x00FFFBFA, 
        0x00FFFBFC, 0x00FFFDFD, 0x00FFFDFD, 0x00FFFEFE, 0x00FFFFFF, 0x00F6CED0, 0x00E38286, 0x00F8D8D7, 0x00FFE2E1, 0x00FFE1E1, 0x00FFE2E2, 0x00FFE3E2, 0x00FFE3E3, 0x00FFE4E4, 0x00FFE4E4, 0x00FFE5E5, 0x00FFE5E5, 0x00FFE9E8, 0x00FABCB6, 0x00B24240, 
        0x4E5F2020, 0xCF000000, 0xF9000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x2F9F4F4F, 0x00A65C5C, 0x00D4ACAC, 0x00F9F0F0, 0x00FFFFFF, 0x00FFFDFC, 0x00FFF7F5, 0x00FFF3F2, 0x00FFF0EF, 0x00FFF0EF, 0x00FFF1EF, 0x00FFF3F2, 0x00FFF4F4, 0x00FFF8F7, 0x00FFF9F9, 0x00FFFBFA, 0x00FFFCFC, 0x00FFFDFD, 
        0x00FFFDFD, 0x00FFFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FEF9F9, 0x00E58388, 0x00ECB0B2, 0x00FFE7E7, 0x00FFE4E4, 0x00FFE4E4, 0x00FFE5E5, 0x00FFE6E6, 0x00FFE7E7, 0x00FFE7E7, 0x00FFE8E8, 0x00FFE8E8, 0x00FFE8E8, 0x00FFEAEA, 0x00FFE2DD, 0x00D7716D, 
        0x138D2D2D, 0xA50D0505, 0xEB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x289D5050, 0x00A35656, 0x00AC6868, 0x00B26D6D, 0x00C79090, 0x00D8B0B1, 0x00E4C8C9, 0x00F0DFE0, 0x00FAF3F3, 0x00FDFBFB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFE, 0x00FFFEFE, 0x00FFFEFE, 0x00FFFEFE, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2BFC1, 0x00E1898D, 0x00F9E1E1, 0x00FFE7E7, 0x00FFE7E7, 0x00FFE8E8, 0x00FFE9E9, 0x00FFE9E9, 0x00FFEAEA, 0x00FFEAEA, 0x00FFEBEB, 0x00FFEBEB, 0x00FFEBEB, 0x00FFECEC, 0x00FFEEEC, 0x00FCB5AE, 
        0x00B54242, 0x4F5F2020, 0xD1000000, 0xFA000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x947F4242, 0x00A24E4E, 0x00D59F9E, 0x00D0A99F, 0x00BC7A6F, 0x00B46F67, 0x00B56E69, 0x00B66A68, 0x00B96869, 0x00C37A7C, 0x00D19192, 0x00DDA6A8, 0x00EAC8C9, 0x00F8E9E9, 0x00FDF8F8, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FCEDED, 0x00DF7A7E, 0x00EFC8C9, 0x00FFECEB, 0x00FFE9E9, 0x00FFEAEA, 0x00FFEBEB, 0x00FFEBEB, 0x00FFECEC, 0x00FFECEC, 0x00FFEDED, 0x00FFEDED, 0x00FFEDED, 0x00FFEEEE, 0x00FFEEEE, 0x00FFF0F0, 0x00FFE2DB, 
        0x00DA7470, 0x0D952E2F, 0xA2120606, 0xEA000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xE7271414, 0x2C8F4646, 0x00D58382, 0x00FFEDE6, 0x00FDCFBC, 0x00F7C9B7, 0x00EEC0B2, 0x00E5B6AA, 0x00DDABA1, 0x00D39B94, 0x00CB8985, 0x00C37978, 0x00C47676, 0x00C87778, 0x00CF8182, 0x00D89092, 0x00E2A2A4, 0x00EAB6B8, 
        0x00F2CECF, 0x00F9E6E7, 0x00FDF6F6, 0x00E89EA0, 0x00E09396, 0x00FDEBEA, 0x00FFEBEB, 0x00FFECEC, 0x00FFEDED, 0x00FFEEEE, 0x00FFEEEE, 0x00FFEFEF, 0x00FFEFEF, 0x00FFF0F0, 0x00FFF0F0, 0x00FFF0F0, 0x00FFF0F0, 0x00FFF1F1, 0x00FFF1F2, 0x00FFF1EE, 
        0x00F9B1A9, 0x00B43F40, 0x50591E1E, 0xCF000000, 0xFA000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFB000000, 0x9C6D3737, 0x00A54E4D, 0x00F3C1C0, 0x00FFE7DB, 0x00FFD2C1, 0x00FFD7C9, 0x00FFDACE, 0x00FFDBD1, 0x00FFDBD1, 0x00FEDBD3, 0x00FAD9D3, 0x00F0CDC8, 0x00E7BEBC, 0x00DFB4B3, 0x00DAA6A7, 0x00D38F91, 0x00D18184, 
        0x00D27C7F, 0x00D6777B, 0x00DC797E, 0x00DA7B7F, 0x00F1D8D8, 0x00FFF0EF, 0x00FFEDED, 0x00FFEEEE, 0x00FFEFEF, 0x00FFF0F0, 0x00FFF1F1, 0x00FFF1F1, 0x00FFF2F2, 0x00FFF2F2, 0x00FFF2F2, 0x00FFF3F3, 0x00FFF3F3, 0x00FFF3F3, 0x00FFF2F3, 0x00FFF5F6, 
        0x00FFE1D8, 0x00DE706D, 0x0E942F30, 0xA01A0909, 0xEA000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xEB1F1111, 0x22924646, 0x00D08181, 0x00FFF1ED, 0x00FFD5C7, 0x00FFD4C8, 0x00FFD7CC, 0x00FFD8CF, 0x00FFDAD3, 0x00FFDCD6, 0x00FFDED9, 0x00FFE0DD, 0x00FFE3E1, 0x00FFE3E3, 0x00FFE4E4, 0x00FDE5E5, 0x00F7E0E0, 
        0x00EED5D5, 0x00EACCCC, 0x00E5BEBF, 0x00EACDCE, 0x00FEEEEE, 0x00FFEFEF, 0x00FFF0F0, 0x00FFF1F1, 0x00FFF1F1, 0x00FFF2F2, 0x00FFF3F3, 0x00FFF3F3, 0x00FFF3F3, 0x00FFF4F4, 0x00FFF3F3, 0x00FFF4F4, 0x00FFF4F4, 0x00FFF4F4, 0x00FFF4F4, 0x00FFF6F6, 
        0x00FFF2ED, 0x00FAAFA4, 0x00B33E3F, 0x4D5D1F1F, 0xCE000000, 0xF9000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFC000000, 0x92743B3B, 0x01AB5050, 0x00F8BFBE, 0x00FFE7DE, 0x00FFD5CA, 0x00FFD8CF, 0x00FFD9D2, 0x00FFDBD5, 0x00FFDDD8, 0x00FFDEDB, 0x00FFDFDE, 0x00FFE1E1, 0x00FFE3E4, 0x00FFE6E6, 0x00FFE8E8, 0x00FFEBEB, 
        0x00FFEEEE, 0x00FFEEEE, 0x00FFEFEF, 0x00FFF0F0, 0x00FFF0F0, 0x00FFF0F0, 0x00FFF2F2, 0x00FFF3F3, 0x00FFF3F3, 0x00FFF4F4, 0x00FFF4F4, 0x00FFF5F5, 0x00FFF5F5, 0x00FFF5F5, 0x00FFF5F5, 0x00FFF6F6, 0x00FFF5F5, 0x00FFF5F5, 0x00FFF6F6, 0x00FFF8F8, 
        0x00FFFBFC, 0x00FFE3D6, 0x00DD6E6B, 0x12912D2E, 0xAA000000, 0xEC000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xEE000000, 0x2F8C4343, 0x00CC7777, 0x00FFEDEA, 0x00FFDAD1, 0x00FFDAD2, 0x00FFDBD6, 0x00FFDCD8, 0x00FFDEDB, 0x00FFE0DF, 0x00FFE1E1, 0x00FFE4E4, 0x00FFE6E6, 0x00FFE8E8, 0x00FFEAEA, 0x00FFECEC, 
        0x00FFEDED, 0x00FFEEEE, 0x00FFF0F0, 0x00FFF1F1, 0x00FFF2F2, 0x00FFF3F3, 0x00FFF4F4, 0x00FFF4F4, 0x00FFF5F5, 0x00FFF5F5, 0x00FFF6F6, 0x00FFF6F6, 0x00FFF7F7, 0x00FFF7F7, 0x00FFF7F7, 0x00FFF7F7, 0x00FFF8F8, 0x00FFF9F9, 0x00FFFAFA, 0x00FFF6F2, 
        0x00FFE0D8, 0x00F9AFA6, 0x00D76665, 0x079E3434, 0x89000000, 0xDD000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFB000000, 0x92773D3D, 0x00A84E4E, 0x00F6C5C7, 0x00FFECE7, 0x00FFDAD3, 0x00FFDDD8, 0x00FFDEDC, 0x00FFE0DF, 0x00FFE1E1, 0x00FFE4E4, 0x00FFE7E7, 0x00FFE9E9, 0x00FFEAEA, 0x00FFECEC, 0x00FFEEEE, 
        0x00FFEFEF, 0x00FFF0F0, 0x00FFF2F2, 0x00FFF3F3, 0x00FFF4F4, 0x00FFF4F4, 0x00FFF5F5, 0x00FFF6F6, 0x00FFF6F6, 0x00FFF7F7, 0x00FFF7F7, 0x00FFF7F7, 0x00FFF8F8, 0x00FFF8F8, 0x00FFF9F9, 0x00FFFAFA, 0x00FFFBFB, 0x00FFF8F7, 0x00FFDFDC, 0x00F6ACA7, 
        0x00D96A6A, 0x00B33E3F, 0x0A933030, 0x324F1B1B, 0x89000000, 0xDB000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xEA261313, 0x2C8D4444, 0x00D17576, 0x00FFE9E8, 0x00FFDFDB, 0x00FFDEDB, 0x00FFDFDE, 0x00FFE1E1, 0x00FFE4E4, 0x00FFE7E7, 0x00FFE9E9, 0x00FFEBEB, 0x00FFECEC, 0x00FFEDED, 0x00FFF0F0, 
        0x00FFF1F1, 0x00FFF1F1, 0x00FFF3F3, 0x00FFF4F4, 0x00FFF5F5, 0x00FFF6F6, 0x00FFF6F6, 0x00FFF7F7, 0x00FFF7F7, 0x00FFF8F8, 0x00FFF8F8, 0x00FFF9F9, 0x00FFF9F9, 0x00FFFBFB, 0x00FFFCFC, 0x00FFF6F6, 0x00FFDADC, 0x00F19A9C, 0x00CC5E5F, 0x00AE3C3E, 
        0x0E872C2D, 0x32481818, 0x5C0F0505, 0x81000000, 0xB6000000, 0xEC000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFB000000, 0x9B6F3838, 0x00A84C4D, 0x00F3BCBD, 0x00FFEFED, 0x00FFDEDC, 0x00FFE1E1, 0x00FFE4E4, 0x00FFE7E7, 0x00FFE9E9, 0x00FFEBEB, 0x00FFEDED, 0x00FFEEEE, 0x00FFF0F0, 0x00FFF1F1, 
        0x00FFF2F2, 0x00FFF4F4, 0x00FFF5F5, 0x00FFF6F6, 0x00FFF6F6, 0x00FFF7F7, 0x00FFF8F8, 0x00FFF8F8, 0x00FFF9F9, 0x00FFF9F9, 0x00FFFAFA, 0x00FFFCFC, 0x00FFFEFE, 0x00FFF7F8, 0x00FFDADB, 0x00ED9699, 0x00C7595B, 0x00AA393A, 0x0F852D2D, 0x34431717, 
        0x60090303, 0x85000000, 0xAC000000, 0xCF000000, 0xEB000000, 0xFB000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEB201010, 0x27914544, 0x00CF7A7C, 0x00FFF1F1, 0x00FFE3E3, 0x00FFE3E3, 0x00FFE7E7, 0x00FFE9E9, 0x00FFEBEB, 0x00FFEDED, 0x00FFEFEF, 0x00FFF0F0, 0x00FFF1F1, 0x00FFF3F3, 
        0x00FFF4F4, 0x00FFF5F5, 0x00FFF6F6, 0x00FFF7F7, 0x00FFF8F8, 0x00FFF8F8, 0x00FFF9F9, 0x00FFF9F9, 0x00FFFAFA, 0x00FFFDFD, 0x00FFFDFD, 0x00FFF5F5, 0x00FDCCCD, 0x00E48F90, 0x00C35758, 0x03A13839, 0x19732828, 0x3B3D1616, 0x65050202, 0x87000000, 
        0xAF000000, 0xD3000000, 0xEC000000, 0xFA000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0x92763B3B, 0x01AB4E4F, 0x00F7BBBD, 0x00FFF3F2, 0x00FFE4E4, 0x00FFE8E8, 0x00FFEBEB, 0x00FFEDED, 0x00FFEFEF, 0x00FFF0F0, 0x00FFF1F1, 0x00FFF3F3, 0x00FFF4F4, 
        0x00FFF5F5, 0x00FFF6F6, 0x00FFF7F7, 0x00FFF8F8, 0x00FFF9F9, 0x00FFF9F9, 0x00FFFBFB, 0x00FFFCFC, 0x00FFFEFE, 0x00FFEFEF, 0x00FAC5C7, 0x00E28688, 0x00BA4B4C, 0x059A3535, 0x1C6E2828, 0x48250F0F, 0x70000000, 0x92000000, 0xB5000000, 0xD5000000, 
        0xEE000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEE000000, 0x2F8D4242, 0x00CC6E70, 0x00FFEEEE, 0x00FFEBEB, 0x00FFE9E9, 0x00FFEDED, 0x00FFEEEE, 0x00FFF0F0, 0x00FFF1F1, 0x00FFF3F3, 0x00FFF4F4, 0x00FFF5F5, 
        0x00FFF6F6, 0x00FFF7F7, 0x00FFF8F8, 0x00FFF9F9, 0x00FFFBFB, 0x00FFFEFE, 0x00FFFEFE, 0x00FFECEC, 0x00F8B3B5, 0x00D37071, 0x00B14747, 0x07943636, 0x29572121, 0x501C0C0C, 0x75000000, 0x98000000, 0xBF000000, 0xDD000000, 0xF1000000, 0xFB000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFB000000, 0x95763B3B, 0x00A84A4C, 0x00F0ACAF, 0x00FFF6F6, 0x00FFEBEB, 0x00FFEEEE, 0x00FFF0F0, 0x00FFF2F2, 0x00FFF3F3, 0x00FFF4F4, 0x00FFF5F5, 0x00FFF7F7, 
        0x00FFF8F8, 0x00FFF9F9, 0x00FFFAFA, 0x00FFFDFD, 0x00FFFCFC, 0x00FFE0E2, 0x00EEA7A9, 0x00CE6C6D, 0x00AF4344, 0x11823030, 0x2E50201F, 0x56170909, 0x7C000000, 0xA2000000, 0xC5000000, 0xE1000000, 0xF4000000, 0xFE000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEB201010, 0x2C8E4443, 0x00C4686A, 0x00FFECED, 0x00FFF1F0, 0x00FFEFEF, 0x00FFF1F1, 0x00FFF3F3, 0x00FFF4F4, 0x00FFF5F5, 0x00FFF6F6, 0x00FFF8F8, 
        0x00FFFAFA, 0x00FFFEFE, 0x00FFFBFB, 0x00FFDBDD, 0x00ECA0A3, 0x00C75D5F, 0x00A64041, 0x127F3131, 0x37401A1A, 0x64020101, 0x86000000, 0xAA000000, 0xCB000000, 0xE6000000, 0xF7000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFB000000, 0x9A723938, 0x00A64C4C, 0x00F4B7BA, 0x00FFFAFA, 0x00FFF0F0, 0x00FFF2F2, 0x00FFF4F4, 0x00FFF5F5, 0x00FFF6F6, 0x00FFF9F9, 0x00FFFEFD, 
        0x00FFF8F9, 0x00FED8D9, 0x00E89799, 0x00C2585A, 0x02A14040, 0x147A3131, 0x393C1919, 0x67000000, 0x89000000, 0xB2000000, 0xD5000000, 0xEC000000, 0xF8000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xED120909, 0x368B4242, 0x00CC696C, 0x00FFE8EA, 0x00FFF5F5, 0x00FFF3F3, 0x00FFF5F5, 0x00FFF9F9, 0x00FFFEFE, 0x00FFF8F8, 0x00FDCACD, 
        0x00DD8386, 0x00B75354, 0x049B3E3F, 0x1F652B2B, 0x452B1313, 0x6D000000, 0x8D000000, 0xB4000000, 0xD7000000, 0xEF000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0xAA673333, 0x02A44748, 0x00EEADB0, 0x00FFFDFD, 0x00FFF7F7, 0x00FFFDFD, 0x00FFEDEE, 0x00F5BCBF, 0x00D67E81, 0x00B55051, 
        0x0A8E3A3A, 0x265C2828, 0x4C231010, 0x74000000, 0x98000000, 0xBD000000, 0xDB000000, 0xF0000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF2000000, 0x328D4342, 0x00C96D70, 0x00FFF0F2, 0x00FFECED, 0x00F1B3B5, 0x00D16D70, 0x00AB494A, 0x0C873939, 0x2A522525, 
        0x5A0E0606, 0x7D000000, 0xA1000000, 0xC4000000, 0xE1000000, 0xF4000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xA86B3434, 0x00A85050, 0x00DC7D81, 0x00C3686A, 0x00A74949, 0x14793636, 0x383F1D1C, 0x60090404, 0x82000000, 
        0xA7000000, 0xCC000000, 0xE6000000, 0xF6000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF2000000, 0x5C7E3E3E, 0x158D4242, 0x1F6E3333, 0x3F371A1A, 0x69000000, 0x8C000000, 0xB1000000, 0xD2000000, 
        0xEA000000, 0xF9000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xE2000000, 0xAD000000, 0x8E000000, 0x98000000, 0xB8000000, 0xD9000000, 0xEF000000, 0xFB000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF9000000, 0xE9000000, 0xDF000000, 0xE4000000, 0xF2000000, 0xFC000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF
#endif
};

GUI_CONST_STORAGE GUI_BITMAP _bmEmail = {
  48, // XSize */
  48, // YSize */
  192, // BytesPerLine */
  32, // BitsPerPixel */
  (unsigned char *)_acEmail,  // Pointer to picture data */
  NULL,  // Pointer to palette */
#if (GUI_USE_ARGB == 1)
  GUI_DRAW_BMPM8888I
#else
  GUI_DRAW_BMP8888
#endif
};

/*********************************************************************
*
*       _bmPassword
*
* Function description
*   Icon bitmap with alpha channel
*/
static GUI_CONST_STORAGE unsigned long _acPassword[] = {
#if (GUI_USE_ARGB == 1)
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x16A02111, 0x80A21811, 0xD5AE2A0F, 0xB5A41B0F, 0x27430B06, 0x09000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04A52713, 0x579D1D13, 0xDCA82612, 0xFFCD6A0B, 0xFFF6C302, 0xFFD77908, 0xCA92120D, 0x36200503, 0x0A000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3C9B2214, 0xC0A02314, 0xFFBB4F0F, 0xFFEAAA05, 0xFFFFE100, 0xFFFFDE00, 0xFFFFDD00, 0xFFD46E08, 0xCE90100C, 0x37230503, 0x0A000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x28992915, 0xAF982215, 0xFCB54D11, 0xFFE5A406, 0xFFFED900, 0xFFFFDE00, 0xFFFFD000, 0xFFFFCF00, 0xFFFFD900, 0xFFFFDE00, 0xFFDB7C06, 0xDB9A100B, 0x443C0704, 0x0C000000, 0x01000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x13932E17, 0x8D962618, 0xF1A53A14, 0xFFD5890A, 0xFFFBD301, 0xFFFFE100, 0xFFFFD200, 0xFFFFCA00, 0xFFFFCD00, 0xFFFFD400, 0xFFFFD900, 0xFFFFDD00, 0xFFFFE000, 0xFFDE8006, 0xD89A110A, 0x3D200302, 0x0B000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x42932F18, 0xDE9B3218, 0xFFC7750E, 0xFFF3C303, 0xFFFFE300, 0xFFFFD400, 0xFFFFC700, 0xFFFFC700, 0xFFFFCD00, 0xFFFFD400, 0xFFFFD900, 0xFFFFDF00, 0xFFFFDC00, 0xFFFFDC00, 0xFFFFE700, 0xFFDD7B05, 0xD6990B09, 0x3B250302, 0x0A000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x1F933118, 0xDB983219, 0xFFDE9F08, 0xFFFFE300, 0xFFFFD700, 0xFFFFC800, 0xFFFFC100, 0xFFFFC500, 0xFFFFCD00, 0xFFFFD400, 0xFFFFD900, 0xFFFED902, 0xFFDFA504, 0xFFC97208, 0xFFCE7C06, 0xFFE8B001, 0xFFFED900, 0xFFDE7705, 0xD89F0F09, 0x45410503, 
        0x0C000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0xB0902B1B, 0xFFCC850D, 0xFFFFE200, 0xFFFFCC00, 0xFFFFBB00, 0xFFFFBE00, 0xFFFFC700, 0xFFFFCE00, 0xFFFFD400, 0xFFFFD900, 0xFFFFE006, 0xFFDFA622, 0xF9A0220D, 0xE2720F0A, 0xE98B120C, 0xFFBA3C0A, 0xFFE9A801, 0xFFFFDC00, 0xFFE48004, 0xDFA50D08, 
        0x42300302, 0x0D000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6C8E2F1B, 
        0xFFB15E13, 0xFFFCD701, 0xFFFFD300, 0xFFFFB900, 0xFFFFBF00, 0xFFFFC700, 0xFFFFCE00, 0xFFFFD400, 0xFFFFDA00, 0xFFFFDC00, 0xFFFFE023, 0xFFC0613B, 0xD04C0905, 0x96000000, 0x77000000, 0xD38D0F0B, 0xFFD36B07, 0xFFFFD000, 0xFFFFCD00, 0xFFE57903, 
        0xD69D0907, 0x402C0302, 0x0B000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x238E341B, 0xEA9D4319, 
        0xFFEEC005, 0xFFFFDD00, 0xFFFFC100, 0xFFFFBE00, 0xFFFFC700, 0xFFFFCE00, 0xFFFFD400, 0xFFFFDA00, 0xFFFFE100, 0xFFFFDF00, 0xFFFFE137, 0xFEBE583D, 0xB8320703, 0x63000000, 0x2D000000, 0x85840C0A, 0xFFCE5709, 0xFFFFD901, 0xFFFFCA0D, 0xFFFFBF00, 
        0xFFE26803, 0xD6A00906, 0x40350302, 0x0B000000, 0x01000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0592391C, 0xB990351C, 0xFFDFA608, 
        0xFFFFE100, 0xFFFFC700, 0xFFFFBE00, 0xFFFFC800, 0xFFFFCE00, 0xFFFFD300, 0xFFFFDA00, 0xFFFFE000, 0xFFFFE700, 0xFFFFE600, 0xFFFFE41D, 0xFFE0A471, 0xE2861006, 0x58100201, 0x171E0402, 0xB6A90E0D, 0xFFDE8206, 0xFFFFDE08, 0xFFFFF657, 0xFFFFD32A, 
        0xFFFFB400, 0xFFE97202, 0xE3AE0B05, 0x4D4B0302, 0x0D000000, 0x01000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7588311D, 0xFFBA7312, 0xFFFFDF00, 
        0xFFFFCF00, 0xFFFFBF00, 0xFFFFC700, 0xFFFFCE00, 0xFFFFD400, 0xFFFFDA00, 0xFFFFE000, 0xFFFFE700, 0xFFFFED00, 0xFFFFF200, 0xFFFFE000, 0xFFFEDF45, 0xFFD88C67, 0xECA7261C, 0xE3AE2115, 0xFFD3610A, 0xFFFAC900, 0xFFFFD925, 0xFFFFFF76, 0xFFFFFD80, 
        0xFFFFC82D, 0xFFFFAE00, 0xFFEA6F02, 0xD2A00B04, 0x35000000, 0x0A000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3A89371D, 0xF4A45717, 0xFFF6CE02, 0xFFFFD700, 
        0xFFFFC200, 0xFFFFC500, 0xFFFFCE00, 0xFFFFD400, 0xFFFFDA00, 0xFFFFDF00, 0xFFFFE600, 0xFFFFEC00, 0xFFFFF200, 0xFFFFFA00, 0xFFFFF901, 0xFFFFDD02, 0xFFFFDA2C, 0xFFF6BE3C, 0xFFF5B121, 0xFFFEC803, 0xFFFFD114, 0xFFFFF667, 0xFFFFFF82, 0xFFFFFF9C, 
        0xFFFFD95B, 0xFFFFA700, 0xFFF38600, 0xEAA60E03, 0x62000000, 0x1A000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xA38A361D, 0xFFD69E0B, 0xFFFFE500, 0xFFFFCB00, 
        0xFFFFC400, 0xFFFFCE00, 0xFFFFD400, 0xFFFFDA00, 0xFFFFE000, 0xFFFFE600, 0xFFFFEC00, 0xFFFFF300, 0xFFFFF900, 0xFFFFFE02, 0xFFFFFF0F, 0xFFFFFC1C, 0xFFFFE917, 0xFFFFDD13, 0xFFFFDB1A, 0xFFFFE136, 0xFFFFF869, 0xFFFFFF84, 0xFFFFFF96, 0xFFFFF590, 
        0xFFFFAF13, 0xFFFC9700, 0xFFD02E04, 0xC8500202, 0x6C000000, 0x1E000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5F793019, 0xFEAE5C15, 0xFFF9CA02, 0xFFFFDB00, 
        0xFFFFD000, 0xFFFFD400, 0xFFFFDA00, 0xFFFFE100, 0xFFFFE700, 0xFFFFEC00, 0xFFFFF300, 0xFFFFF900, 0xFFFFFE01, 0xFFFFFF0F, 0xFFFFFF20, 0xFFFFFF30, 0xFFFFFF42, 0xFFFFFF52, 0xFFFFFF63, 0xFFFFFF75, 0xFFFFFF83, 0xFFFFFF92, 0xFFFFFFA8, 0xFFFFC744, 
        0xFFFFA000, 0xFFDD5303, 0xE4810304, 0x97000000, 0x4D000000, 0x10000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0F000000, 0xA46F2817, 0xFFBB6411, 0xFFFFD500, 
        0xFFFFDA00, 0xFFFFD900, 0xFFFFE000, 0xFFFFE700, 0xFFFFED00, 0xFFFFF200, 0xFFFFF900, 0xFFFFFE01, 0xFFFFFF0E, 0xFFFFFF1F, 0xFFFFFF2F, 0xFFFFFF3F, 0xFFFFFF4F, 0xFFFFFF60, 0xFFFFFF70, 0xFFFFFF80, 0xFFFFFF90, 0xFFFFFFAC, 0xFFFFE27B, 0xFFFFA200, 
        0xFFF07C00, 0xF6AF1205, 0xB21F0201, 0x6A000000, 0x23000000, 0x04000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x220D0503, 0xD47F2C18, 0xFFD37B0A, 
        0xFFFFD800, 0xFFFFD800, 0xFFFFE300, 0xFFFFED00, 0xFFFFF700, 0xFFFFFD00, 0xFFFFFE01, 0xFFFFFF0F, 0xFFFFFF1E, 0xFFFFFF2F, 0xFFFFFF40, 0xFFFFFF4F, 0xFFFFFF5F, 0xFFFFFF70, 0xFFFFFF80, 0xFFFFFF8F, 0xFFFFFFA6, 0xFFFFF7A5, 0xFFFFAE1C, 0xFFFD9600, 
        0xFFCD3105, 0xCD4F0303, 0x83000000, 0x38000000, 0x0A000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x12592312, 0xCC862F1B, 0xFFC9800E, 
        0xFFFFD700, 0xFFFFDA00, 0xFFFFEB00, 0xFFFFF800, 0xFFDCC200, 0xFFE6D801, 0xFFFFFF0F, 0xFFFFFF1F, 0xFFFFFF2F, 0xFFFFFF40, 0xFFFFFF51, 0xFFFFFF60, 0xFFFFFF70, 0xFFFFFF81, 0xFFFFFF91, 0xFFFFFFA2, 0xFFFFFFB9, 0xFFFFC24A, 0xFFFF9B00, 0xFFE05E02, 
        0xE27B0705, 0x97000000, 0x51000000, 0x15000000, 0x01000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1287391B, 0xB98A311E, 0xFFBE7811, 0xFFFFDA00, 
        0xFFFFDC00, 0xFFFFEB00, 0xFFFDF800, 0xFFDDBE00, 0xFFE18A00, 0xFFE5B407, 0xFFFEFF1F, 0xFFFFFF2F, 0xFFFFFF3F, 0xFFFFFF50, 0xFFFFFF60, 0xFFFFFF70, 0xFFFFFF80, 0xFFFFFF90, 0xFFFFFFA4, 0xFFFFFFC1, 0xFFFFDE7E, 0xFFFF9C00, 0xFFF18100, 0xF8AE1807, 
        0xB11D0201, 0x68000000, 0x22000000, 0x04000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1D883B1D, 0xC38A361E, 0xFFC28010, 0xFFFED801, 0xFFFFDE00, 
        0xFFFFEC00, 0xFFFDF600, 0xFFDEBB00, 0xFFE89300, 0xFFFFC407, 0xFFFFFA1C, 0xFFFFFF30, 0xFFFFFF40, 0xFFFFFF50, 0xFFFFFF60, 0xFFFFFF71, 0xFFFFFF81, 0xFFFFFF90, 0xFFFFFFA9, 0xFFFFFBAE, 0xFFFFD05F, 0xFFFFA10B, 0xFFFB9100, 0xFFCC3706, 0xD2570604, 
        0x85000000, 0x39000000, 0x09000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x13843D1D, 0xC28A3B1E, 0xFFC88A0F, 0xFFFFDC00, 0xFFFFDD00, 0xFFFFEE00, 
        0xFFFCF500, 0xFFD9B600, 0xFFEA9700, 0xFFFFCC08, 0xFFFFFE1F, 0xFFFFFF30, 0xFFFFFF41, 0xFFFFFF52, 0xFFFFFF61, 0xFFFFFF71, 0xFFFFFF82, 0xFFFFFF93, 0xFFFFFFAC, 0xFFFFF096, 0xFFFFB42C, 0xFFFF9900, 0xFFF58800, 0xFFCC4006, 0xE6810B08, 0x9A000000, 
        0x54000000, 0x16000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x17843F1F, 0xC2843820, 0xFFC48810, 0xFFFFDD00, 0xFFFFDC00, 0xFFFFED00, 0xFFFAF300, 
        0xFFD8B200, 0xFFED9700, 0xFFFFCD08, 0xFFFFFF1F, 0xFFFFFF30, 0xFFFFFF3F, 0xFFFFFF53, 0xFFFFFE62, 0xFFFFFE72, 0xFFFFFF85, 0xFFFFFF95, 0xFFFFFFAA, 0xFFFFE278, 0xFFFFA60F, 0xFFFF9A00, 0xFFEB7901, 0xFEBF2D08, 0xE0720907, 0xA3080100, 0x66000000, 
        0x25000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1A824120, 0xC9843C21, 0xFFBE8312, 0xFFFFD900, 0xFFFFDC00, 0xFFFFED00, 0xFFFAF300, 0xFFD7AE00, 
        0xFFEF9C00, 0xFFFFCC07, 0xFFFFFC1E, 0xFFFFFF31, 0xFFFFFF3F, 0xFFFFFF52, 0xFFFFFC5E, 0xFFFFD229, 0xFFFFCB28, 0xFFFFF681, 0xFFFFFC9D, 0xFFFFCD4F, 0xFFFFA101, 0xFFFB9400, 0xFFD96004, 0xFAAB1D0A, 0xCF4D0805, 0x97000000, 0x62000000, 0x29000000, 
        0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1B814321, 0xD4854022, 0xFFCA9210, 0xFFFFDB00, 0xFFFFDD00, 0xFFFFEF00, 0xFFF7EE00, 0xFFD6AB00, 0xFFF4A400, 
        0xFFFFD609, 0xFFFFFF20, 0xFFFFFE30, 0xFFFFFC3E, 0xFFFFFF58, 0xFFFFF755, 0xFFFFC516, 0xFFFFAF00, 0xFFFFAB00, 0xFFFFB313, 0xFFFFB31D, 0xFFFFA000, 0xFFF18800, 0xFFC23D09, 0xE981120A, 0xB41B0402, 0x86000000, 0x52000000, 0x21000000, 0x07000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1B7F4422, 0xC9814122, 0xFFCB960F, 0xFFFFDE00, 0xFFFFDC00, 0xFFFFEF00, 0xFFF5EC00, 0xFFD5A800, 0xFFF3A400, 0xFFFFDA0A, 
        0xFFFFFF20, 0xFFFFFF32, 0xFFFFDB17, 0xFFFFCA0E, 0xFFFFE236, 0xFFFFC313, 0xFFFFB100, 0xFFE17E04, 0xFFD56905, 0xFFFB9C00, 0xFFFFA000, 0xFFE17203, 0xFEB32C0C, 0xD85B0D08, 0xA0040100, 0x6F000000, 0x3B000000, 0x16000000, 0x04000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1F7D4723, 0xCF7D4124, 0xFFC08C12, 0xFFFFDC00, 0xFFFFDD00, 0xFFFFEF00, 0xFFF3E800, 0xFFD5A700, 0xFFF4A800, 0xFFFFD708, 0xFFFFFF21, 
        0xFFFFFE30, 0xFFFFD915, 0xFFFFC000, 0xFFFFBA00, 0xFFFFB800, 0xFFFFB300, 0xFFD77006, 0xF99C2712, 0xF5921D12, 0xFFC34E09, 0xFFCE5907, 0xF79C1F0E, 0xC73C0A06, 0x92000000, 0x5C000000, 0x28000000, 0x0A000000, 0x01000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x297C4825, 0xD2804923, 0xFFC79411, 0xFFFFDB00, 0xFFFFDE00, 0xFFFFF000, 0xFFF1E500, 0xFFDAAA00, 0xFFF6B000, 0xFFFFE10D, 0xFFFFFF23, 0xFFFFF829, 
        0xFFFFD30F, 0xFFFFC200, 0xFFE38E04, 0xFFCA6609, 0xFFEF9800, 0xFFCE6609, 0xEF832011, 0xB9220804, 0x97090201, 0xC568140B, 0xD673150C, 0xAC1E0603, 0x81000000, 0x4C000000, 0x1C000000, 0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x217B4925, 0xD17E4B24, 0xFFCD9E0F, 0xFFFFDE00, 0xFFFFDD00, 0xFFFFF200, 0xFFEFE100, 0xFFD6A500, 0xFFF7B200, 0xFFFFD103, 0xFFFFEB10, 0xFFFFE817, 0xFFFFCE09, 
        0xFFFFC100, 0xFFE08A04, 0xF8953313, 0xED7B2113, 0xFEA63513, 0xE8781F10, 0xAA0C0301, 0x77000000, 0x46000000, 0x3B000000, 0x53000000, 0x58000000, 0x37000000, 0x13000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x267B4A25, 0xD77A4826, 0xFFC89A11, 0xFFFFDE00, 0xFFFFDC00, 0xFFFFF000, 0xFFEDDD00, 0xFFD7A400, 0xFFF9B700, 0xFFFFD605, 0xFFFFD001, 0xFFFFC800, 0xFFFFC200, 0xFFFFBE00, 
        0xFFD77E07, 0xF9923015, 0xC5311008, 0x95000000, 0x9A2B0D06, 0x890A0301, 0x69000000, 0x32000000, 0x0D000000, 0x08000000, 0x13000000, 0x15000000, 0x0A000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x267B4A25, 0xD77C4A25, 0xFFC39612, 0xFFFFDC00, 0xFFFFDD00, 0xFFFFF100, 0xFFEFDE00, 0xFFDAA600, 0xFFFBBA00, 0xFFFFE60C, 0xFFFFEC11, 0xFFFFC900, 0xFFDB8C06, 0xFFC4670A, 0xFFBD5E0C, 
        0xF5862E15, 0xBE250D07, 0x86000000, 0x4E000000, 0x32000000, 0x31000000, 0x22000000, 0x0A000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x287C4925, 0xDF7F4C26, 0xFFD2A50E, 0xFFFFDD00, 0xFFFFDE00, 0xFFFFF200, 0xFFE8D600, 0xFFDBA800, 0xFFFCC000, 0xFFFFEB0D, 0xFFFFFF25, 0xFFFFE214, 0xFFFCBB00, 0xFD9F4C17, 0xDE561E12, 0xCC45180E, 
        0xA6160804, 0x7A000000, 0x43000000, 0x15000000, 0x04000000, 0x04000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x2C7C4925, 0xDC7D4A26, 0xFFD1A50E, 0xFFFFDD00, 0xFFFFDD00, 0xFFFFF200, 0xFFE7D300, 0xFFDCA900, 0xFFFDC500, 0xFFFFEC0D, 0xFFFFFF1E, 0xFFFFF021, 0xFFFFD20A, 0xFFF1AC02, 0xF17E3617, 0xA3030101, 0x73000000, 
        0x4F000000, 0x30000000, 0x10000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x257C4B24, 0xDC7F4D25, 0xFFC89B10, 0xFFFFDD00, 0xFFFFDD00, 0xFFFFF300, 0xFFE6D100, 0xFFDDAA00, 0xFFFEC700, 0xFFFFD402, 0xFFFFDF07, 0xFFFFD404, 0xFFFFCA00, 0xFFFFC500, 0xFFE29708, 0xE56A2B15, 0x83000000, 0x38000000, 
        0x10000000, 0x07000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x67774625, 0xFF9F6F1C, 0xFFFED900, 0xFFFFDF00, 0xFFFFF000, 0xFFE4CD00, 0xFFE2AF00, 0xFFFFD002, 0xFFFFD903, 0xFFFFCE00, 0xFFF8B600, 0xFFE99E01, 0xFFD78805, 0xFFC3700B, 0xFFA65014, 0xD34F1F10, 0x6D000000, 0x1F000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x7A714224, 0xFFAD7E18, 0xFFFFDB00, 0xFFFFEC00, 0xFFE1C900, 0xFFE1AE00, 0xFFFFD201, 0xFFFFEF0D, 0xFFFFDA04, 0xFFF4B901, 0xFFA55714, 0xF8833C1A, 0xEC6B2F18, 0xDC562414, 0xC134150C, 0x8D040201, 0x4C000000, 0x13000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x8A704025, 0xFFB88B14, 0xFFFFE200, 0xFFDFBE00, 0xFFE2B400, 0xFFFFD400, 0xFFFFF410, 0xFFFFEF13, 0xFFFFCF00, 0xFFCF8D0C, 0xE1522717, 0xA8050201, 0x8B000000, 0x74000000, 0x61000000, 0x43000000, 0x1E000000, 0x05000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x9C734224, 0xFFC59811, 0xFFE9BE00, 0xFFE5B600, 0xFFFFD700, 0xFFFFEF0C, 0xFFFFFE1D, 0xFFFFD609, 0xFFFABA00, 0xFC975518, 0xB61C0F08, 0x70000000, 0x3A000000, 0x22000000, 0x19000000, 0x0D000000, 0x04000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xB07A4A23, 0xFFD5AB0B, 0xFFF4CD00, 0xFFFFDE00, 0xFFFFD900, 0xFFFFD802, 0xFFFFD203, 0xFFFFCE00, 0xFFD5920B, 0xE85F3019, 0x8F000000, 0x3F000000, 0x0A000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xC57F4E23, 0xFFDDA006, 0xFFF1B400, 0xFFECAC00, 0xFFECA800, 0xFFECA500, 0xFFEDA200, 0xFFED9F00, 0xFEA05E18, 0xC22A160C, 0x6D000000, 0x22000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x9D764721, 0xF1894D1C, 0xF4834819, 0xF6824819, 0xF6824819, 0xF6824819, 0xF6824818, 0xF886481A, 0xE35B3118, 0x92010100, 0x46000000, 0x0D000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x16000000, 0x4E000000, 0x79000000, 0x83000000, 0x82000000, 0x82000000, 0x82000000, 0x83000000, 0x7E000000, 0x59000000, 0x20000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x06000000, 0x18000000, 0x26000000, 0x29000000, 0x29000000, 0x29000000, 0x29000000, 0x29000000, 0x27000000, 0x19000000, 0x07000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF
#else
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE91121A0, 0x7F1118A2, 0x2A0F2AAE, 0x4A0F1BA4, 0xD8060B43, 0xF6000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFB1327A5, 0xA8131D9D, 0x231226A8, 0x000B6ACD, 0x0002C3F6, 0x000879D7, 0x350D1292, 0xC9030520, 0xF5000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xC314229B, 0x3F1423A0, 0x000F4FBB, 0x0005AAEA, 0x0000E1FF, 0x0000DEFF, 0x0000DDFF, 0x00086ED4, 0x310C1090, 0xC8030523, 0xF5000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xD7152999, 0x50152298, 0x03114DB5, 0x0006A4E5, 0x0000D9FE, 0x0000DEFF, 0x0000D0FF, 0x0000CFFF, 0x0000D9FF, 0x0000DEFF, 0x00067CDB, 0x240B109A, 0xBB04073C, 0xF3000000, 0xFE000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xEC172E93, 0x72182696, 0x0E143AA5, 0x000A89D5, 0x0001D3FB, 0x0000E1FF, 0x0000D2FF, 0x0000CAFF, 0x0000CDFF, 0x0000D4FF, 0x0000D9FF, 0x0000DDFF, 0x0000E0FF, 0x000680DE, 0x270A119A, 0xC2020320, 0xF4000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xBD182F93, 0x2118329B, 0x000E75C7, 0x0003C3F3, 0x0000E3FF, 0x0000D4FF, 0x0000C7FF, 0x0000C7FF, 0x0000CDFF, 0x0000D4FF, 0x0000D9FF, 0x0000DFFF, 0x0000DCFF, 0x0000DCFF, 0x0000E7FF, 0x00057BDD, 0x29090B99, 0xC4020325, 0xF5000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xE0183193, 0x24193298, 0x00089FDE, 0x0000E3FF, 0x0000D7FF, 0x0000C8FF, 0x0000C1FF, 0x0000C5FF, 0x0000CDFF, 0x0000D4FF, 0x0000D9FF, 0x0002D9FE, 0x0004A5DF, 0x000872C9, 0x00067CCE, 0x0001B0E8, 0x0000D9FE, 0x000577DE, 0x27090F9F, 0xBA030541, 
        0xF3000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x4F1B2B90, 0x000D85CC, 0x0000E2FF, 0x0000CCFF, 0x0000BBFF, 0x0000BEFF, 0x0000C7FF, 0x0000CEFF, 0x0000D4FF, 0x0000D9FF, 0x0006E0FF, 0x0022A6DF, 0x060D22A0, 0x1D0A0F72, 0x160C128B, 0x000A3CBA, 0x0001A8E9, 0x0000DCFF, 0x000480E4, 0x20080DA5, 
        0xBD020330, 0xF2000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x931B2F8E, 
        0x00135EB1, 0x0001D7FC, 0x0000D3FF, 0x0000B9FF, 0x0000BFFF, 0x0000C7FF, 0x0000CEFF, 0x0000D4FF, 0x0000DAFF, 0x0000DCFF, 0x0023E0FF, 0x003B61C0, 0x2F05094C, 0x69000000, 0x88000000, 0x2C0B0F8D, 0x00076BD3, 0x0000D0FF, 0x0000CDFF, 0x000379E5, 
        0x2907099D, 0xBF02032C, 0xF4000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDC1B348E, 0x1519439D, 
        0x0005C0EE, 0x0000DDFF, 0x0000C1FF, 0x0000BEFF, 0x0000C7FF, 0x0000CEFF, 0x0000D4FF, 0x0000DAFF, 0x0000E1FF, 0x0000DFFF, 0x0037E1FF, 0x013D58BE, 0x47030732, 0x9C000000, 0xD2000000, 0x7A0A0C84, 0x000957CE, 0x0001D9FF, 0x000DCAFF, 0x0000BFFF, 
        0x000368E2, 0x290609A0, 0xBF020335, 0xF4000000, 0xFE000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFA1C3992, 0x461C3590, 0x0008A6DF, 
        0x0000E1FF, 0x0000C7FF, 0x0000BEFF, 0x0000C8FF, 0x0000CEFF, 0x0000D3FF, 0x0000DAFF, 0x0000E0FF, 0x0000E7FF, 0x0000E6FF, 0x001DE4FF, 0x0071A4E0, 0x1D061086, 0xA7010210, 0xE802041E, 0x490D0EA9, 0x000682DE, 0x0008DEFF, 0x0057F6FF, 0x002AD3FF, 
        0x0000B4FF, 0x000272E9, 0x1C050BAE, 0xB202034B, 0xF2000000, 0xFE000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x8A1D3188, 0x001273BA, 0x0000DFFF, 
        0x0000CFFF, 0x0000BFFF, 0x0000C7FF, 0x0000CEFF, 0x0000D4FF, 0x0000DAFF, 0x0000E0FF, 0x0000E7FF, 0x0000EDFF, 0x0000F2FF, 0x0000E0FF, 0x0045DFFE, 0x00678CD8, 0x131C26A7, 0x1C1521AE, 0x000A61D3, 0x0000C9FA, 0x0025D9FF, 0x0076FFFF, 0x0080FDFF, 
        0x002DC8FF, 0x0000AEFF, 0x00026FEA, 0x2D040BA0, 0xCA000000, 0xF5000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xC51D3789, 0x0B1757A4, 0x0002CEF6, 0x0000D7FF, 
        0x0000C2FF, 0x0000C5FF, 0x0000CEFF, 0x0000D4FF, 0x0000DAFF, 0x0000DFFF, 0x0000E6FF, 0x0000ECFF, 0x0000F2FF, 0x0000FAFF, 0x0001F9FF, 0x0002DDFF, 0x002CDAFF, 0x003CBEF6, 0x0021B1F5, 0x0003C8FE, 0x0014D1FF, 0x0067F6FF, 0x0082FFFF, 0x009CFFFF, 
        0x005BD9FF, 0x0000A7FF, 0x000086F3, 0x15030EA6, 0x9D000000, 0xE5000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x5C1D368A, 0x000B9ED6, 0x0000E5FF, 0x0000CBFF, 
        0x0000C4FF, 0x0000CEFF, 0x0000D4FF, 0x0000DAFF, 0x0000E0FF, 0x0000E6FF, 0x0000ECFF, 0x0000F3FF, 0x0000F9FF, 0x0002FEFF, 0x000FFFFF, 0x001CFCFF, 0x0017E9FF, 0x0013DDFF, 0x001ADBFF, 0x0036E1FF, 0x0069F8FF, 0x0084FFFF, 0x0096FFFF, 0x0090F5FF, 
        0x0013AFFF, 0x000097FC, 0x00042ED0, 0x37020250, 0x93000000, 0xE1000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xA0193079, 0x01155CAE, 0x0002CAF9, 0x0000DBFF, 
        0x0000D0FF, 0x0000D4FF, 0x0000DAFF, 0x0000E1FF, 0x0000E7FF, 0x0000ECFF, 0x0000F3FF, 0x0000F9FF, 0x0001FEFF, 0x000FFFFF, 0x0020FFFF, 0x0030FFFF, 0x0042FFFF, 0x0052FFFF, 0x0063FFFF, 0x0075FFFF, 0x0083FFFF, 0x0092FFFF, 0x00A8FFFF, 0x0044C7FF, 
        0x0000A0FF, 0x000353DD, 0x1B040381, 0x68000000, 0xB2000000, 0xEF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF0000000, 0x5B17286F, 0x001164BB, 0x0000D5FF, 
        0x0000DAFF, 0x0000D9FF, 0x0000E0FF, 0x0000E7FF, 0x0000EDFF, 0x0000F2FF, 0x0000F9FF, 0x0001FEFF, 0x000EFFFF, 0x001FFFFF, 0x002FFFFF, 0x003FFFFF, 0x004FFFFF, 0x0060FFFF, 0x0070FFFF, 0x0080FFFF, 0x0090FFFF, 0x00ACFFFF, 0x007BE2FF, 0x0000A2FF, 
        0x00007CF0, 0x090512AF, 0x4D01021F, 0x95000000, 0xDC000000, 0xFB000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFB000000, 0xDD03050D, 0x2B182C7F, 0x000A7BD3, 
        0x0000D8FF, 0x0000D8FF, 0x0000E3FF, 0x0000EDFF, 0x0000F7FF, 0x0000FDFF, 0x0001FEFF, 0x000FFFFF, 0x001EFFFF, 0x002FFFFF, 0x0040FFFF, 0x004FFFFF, 0x005FFFFF, 0x0070FFFF, 0x0080FFFF, 0x008FFFFF, 0x00A6FFFF, 0x00A5F7FF, 0x001CAEFF, 0x000096FD, 
        0x000531CD, 0x3203034F, 0x7C000000, 0xC7000000, 0xF5000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xED122359, 0x331B2F86, 0x000E80C9, 
        0x0000D7FF, 0x0000DAFF, 0x0000EBFF, 0x0000F8FF, 0x0000C2DC, 0x0001D8E6, 0x000FFFFF, 0x001FFFFF, 0x002FFFFF, 0x0040FFFF, 0x0051FFFF, 0x0060FFFF, 0x0070FFFF, 0x0081FFFF, 0x0091FFFF, 0x00A2FFFF, 0x00B9FFFF, 0x004AC2FF, 0x00009BFF, 0x00025EE0, 
        0x1D05077B, 0x68000000, 0xAE000000, 0xEA000000, 0xFE000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xED1B3987, 0x461E318A, 0x001178BE, 0x0000DAFF, 
        0x0000DCFF, 0x0000EBFF, 0x0000F8FD, 0x0000BEDD, 0x00008AE1, 0x0007B4E5, 0x001FFFFE, 0x002FFFFF, 0x003FFFFF, 0x0050FFFF, 0x0060FFFF, 0x0070FFFF, 0x0080FFFF, 0x0090FFFF, 0x00A4FFFF, 0x00C1FFFF, 0x007EDEFF, 0x00009CFF, 0x000081F1, 0x070718AE, 
        0x4E01021D, 0x97000000, 0xDD000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE21D3B88, 0x3C1E368A, 0x001080C2, 0x0001D8FE, 0x0000DEFF, 
        0x0000ECFF, 0x0000F6FD, 0x0000BBDE, 0x000093E8, 0x0007C4FF, 0x001CFAFF, 0x0030FFFF, 0x0040FFFF, 0x0050FFFF, 0x0060FFFF, 0x0071FFFF, 0x0081FFFF, 0x0090FFFF, 0x00A9FFFF, 0x00AEFBFF, 0x005FD0FF, 0x000BA1FF, 0x000091FB, 0x000637CC, 0x2D040657, 
        0x7A000000, 0xC6000000, 0xF6000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEC1D3D84, 0x3D1E3B8A, 0x000F8AC8, 0x0000DCFF, 0x0000DDFF, 0x0000EEFF, 
        0x0000F5FC, 0x0000B6D9, 0x000097EA, 0x0008CCFF, 0x001FFEFF, 0x0030FFFF, 0x0041FFFF, 0x0052FFFF, 0x0061FFFF, 0x0071FFFF, 0x0082FFFF, 0x0093FFFF, 0x00ACFFFF, 0x0096F0FF, 0x002CB4FF, 0x000099FF, 0x000088F5, 0x000640CC, 0x19080B81, 0x65000000, 
        0xAB000000, 0xE9000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE81F3F84, 0x3D203884, 0x001088C4, 0x0000DDFF, 0x0000DCFF, 0x0000EDFF, 0x0000F3FA, 
        0x0000B2D8, 0x000097ED, 0x0008CDFF, 0x001FFFFF, 0x0030FFFF, 0x003FFFFF, 0x0053FFFF, 0x0062FEFF, 0x0072FEFF, 0x0085FFFF, 0x0095FFFF, 0x00AAFFFF, 0x0078E2FF, 0x000FA6FF, 0x00009AFF, 0x000179EB, 0x01082DBF, 0x1F070972, 0x5C000108, 0x99000000, 
        0xDA000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE5204182, 0x36213C84, 0x001283BE, 0x0000D9FF, 0x0000DCFF, 0x0000EDFF, 0x0000F3FA, 0x0000AED7, 
        0x00009CEF, 0x0007CCFF, 0x001EFCFF, 0x0031FFFF, 0x003FFFFF, 0x0052FFFF, 0x005EFCFF, 0x0029D2FF, 0x0028CBFF, 0x0081F6FF, 0x009DFCFF, 0x004FCDFF, 0x0001A1FF, 0x000094FB, 0x000460D9, 0x050A1DAB, 0x3005084D, 0x68000000, 0x9D000000, 0xD6000000, 
        0xF7000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE4214381, 0x2B224085, 0x001092CA, 0x0000DBFF, 0x0000DDFF, 0x0000EFFF, 0x0000EEF7, 0x0000ABD6, 0x0000A4F4, 
        0x0009D6FF, 0x0020FFFF, 0x0030FEFF, 0x003EFCFF, 0x0058FFFF, 0x0055F7FF, 0x0016C5FF, 0x0000AFFF, 0x0000ABFF, 0x0013B3FF, 0x001DB3FF, 0x0000A0FF, 0x000088F1, 0x00093DC2, 0x160A1281, 0x4B02041B, 0x79000000, 0xAD000000, 0xDE000000, 0xF8000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE422447F, 0x36224181, 0x000F96CB, 0x0000DEFF, 0x0000DCFF, 0x0000EFFF, 0x0000ECF5, 0x0000A8D5, 0x0000A4F3, 0x000ADAFF, 
        0x0020FFFF, 0x0032FFFF, 0x0017DBFF, 0x000ECAFF, 0x0036E2FF, 0x0013C3FF, 0x0000B1FF, 0x00047EE1, 0x000569D5, 0x00009CFB, 0x0000A0FF, 0x000372E1, 0x010C2CB3, 0x27080D5B, 0x5F000104, 0x90000000, 0xC4000000, 0xE9000000, 0xFB000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE023477D, 0x3024417D, 0x00128CC0, 0x0000DCFF, 0x0000DDFF, 0x0000EFFF, 0x0000E8F3, 0x0000A7D5, 0x0000A8F4, 0x0008D7FF, 0x0021FFFF, 
        0x0030FEFF, 0x0015D9FF, 0x0000C0FF, 0x0000BAFF, 0x0000B8FF, 0x0000B3FF, 0x000670D7, 0x0612279C, 0x0A121D92, 0x00094EC3, 0x000759CE, 0x080E1F9C, 0x38060A3C, 0x6D000000, 0xA3000000, 0xD7000000, 0xF5000000, 0xFE000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xD625487C, 0x2D234980, 0x001194C7, 0x0000DBFF, 0x0000DEFF, 0x0000F0FF, 0x0000E5F1, 0x0000AADA, 0x0000B0F6, 0x000DE1FF, 0x0023FFFF, 0x0029F8FF, 
        0x000FD3FF, 0x0000C2FF, 0x00048EE3, 0x000966CA, 0x000098EF, 0x000966CE, 0x10112083, 0x46040822, 0x68010209, 0x3A0B1468, 0x290C1573, 0x5303061E, 0x7E000000, 0xB3000000, 0xE3000000, 0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDE25497B, 0x2E244B7E, 0x000F9ECD, 0x0000DEFF, 0x0000DDFF, 0x0000F2FF, 0x0000E1EF, 0x0000A5D6, 0x0000B2F7, 0x0003D1FF, 0x0010EBFF, 0x0017E8FF, 0x0009CEFF, 
        0x0000C1FF, 0x00048AE0, 0x07133395, 0x1213217B, 0x011335A6, 0x17101F78, 0x5501030C, 0x88000000, 0xB9000000, 0xC4000000, 0xAC000000, 0xA7000000, 0xC8000000, 0xEC000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xD9254A7B, 0x2826487A, 0x00119AC8, 0x0000DEFF, 0x0000DCFF, 0x0000F0FF, 0x0000DDED, 0x0000A4D7, 0x0000B7F9, 0x0005D6FF, 0x0001D0FF, 0x0000C8FF, 0x0000C2FF, 0x0000BEFF, 
        0x00077ED7, 0x06153092, 0x3A081031, 0x6A000000, 0x65060D2B, 0x7601030A, 0x96000000, 0xCD000000, 0xF2000000, 0xF7000000, 0xEC000000, 0xEA000000, 0xF5000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xD9254A7B, 0x28254A7C, 0x001296C3, 0x0000DCFF, 0x0000DDFF, 0x0000F1FF, 0x0000DEEF, 0x0000A6DA, 0x0000BAFB, 0x000CE6FF, 0x0011ECFF, 0x0000C9FF, 0x00068CDB, 0x000A67C4, 0x000C5EBD, 
        0x0A152E86, 0x41070D25, 0x79000000, 0xB1000000, 0xCD000000, 0xCE000000, 0xDD000000, 0xF5000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xD725497C, 0x20264C7F, 0x000EA5D2, 0x0000DDFF, 0x0000DEFF, 0x0000F2FF, 0x0000D6E8, 0x0000A8DB, 0x0000C0FC, 0x000DEBFF, 0x0025FFFF, 0x0014E2FF, 0x0000BBFC, 0x02174C9F, 0x21121E56, 0x330E1845, 
        0x59040816, 0x85000000, 0xBC000000, 0xEA000000, 0xFB000000, 0xFB000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xD325497C, 0x23264A7D, 0x000EA5D1, 0x0000DDFF, 0x0000DDFF, 0x0000F2FF, 0x0000D3E7, 0x0000A9DC, 0x0000C5FD, 0x000DECFF, 0x001EFFFF, 0x0021F0FF, 0x000AD2FF, 0x0002ACF1, 0x0E17367E, 0x5C010103, 0x8C000000, 
        0xB0000000, 0xCF000000, 0xEF000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xDA244B7C, 0x23254D7F, 0x00109BC8, 0x0000DDFF, 0x0000DDFF, 0x0000F3FF, 0x0000D1E6, 0x0000AADD, 0x0000C7FE, 0x0002D4FF, 0x0007DFFF, 0x0004D4FF, 0x0000CAFF, 0x0000C5FF, 0x000897E2, 0x1A152B6A, 0x7C000000, 0xC7000000, 
        0xEF000000, 0xF8000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x98254677, 0x001C6F9F, 0x0000D9FE, 0x0000DFFF, 0x0000F0FF, 0x0000CDE4, 0x0000AFE2, 0x0002D0FF, 0x0003D9FF, 0x0000CEFF, 0x0000B6F8, 0x00019EE9, 0x000588D7, 0x000B70C3, 0x001450A6, 0x2C101F4F, 0x92000000, 0xE0000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x85244271, 0x00187EAD, 0x0000DBFF, 0x0000ECFF, 0x0000C9E1, 0x0000AEE1, 0x0001D2FF, 0x000DEFFF, 0x0004DAFF, 0x0001B9F4, 0x001457A5, 0x071A3C83, 0x13182F6B, 0x23142456, 0x3E0C1534, 0x72010204, 0xB3000000, 0xEC000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x75254070, 0x00148BB8, 0x0000E2FF, 0x0000BEDF, 0x0000B4E2, 0x0000D4FF, 0x0010F4FF, 0x0013EFFF, 0x0000CFFF, 0x000C8DCF, 0x1E172752, 0x57010205, 0x74000000, 0x8B000000, 0x9E000000, 0xBC000000, 0xE1000000, 0xFA000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x63244273, 0x001198C5, 0x0000BEE9, 0x0000B6E5, 0x0000D7FF, 0x000CEFFF, 0x001DFEFF, 0x0009D6FF, 0x0000BAFA, 0x03185597, 0x49080F1C, 0x8F000000, 0xC5000000, 0xDD000000, 0xE6000000, 0xF2000000, 0xFB000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4F234A7A, 0x000BABD5, 0x0000CDF4, 0x0000DEFF, 0x0000D9FF, 0x0002D8FF, 0x0003D2FF, 0x0000CEFF, 0x000B92D5, 0x1719305F, 0x70000000, 0xC0000000, 0xF5000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x3A234E7F, 0x0006A0DD, 0x0000B4F1, 0x0000ACEC, 0x0000A8EC, 0x0000A5EC, 0x0000A2ED, 0x00009FED, 0x01185EA0, 0x3D0C162A, 0x92000000, 0xDD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x62214776, 0x0E1C4D89, 0x0B194883, 0x09194882, 0x09194882, 0x09194882, 0x09184882, 0x071A4886, 0x1C18315B, 0x6D000101, 0xB9000000, 0xF2000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xE9000000, 0xB1000000, 0x86000000, 0x7C000000, 0x7D000000, 0x7D000000, 0x7D000000, 0x7C000000, 0x81000000, 0xA6000000, 0xDF000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xF9000000, 0xE7000000, 0xD9000000, 0xD6000000, 0xD6000000, 0xD6000000, 0xD6000000, 0xD6000000, 0xD8000000, 0xE6000000, 0xF8000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF
#endif
};

GUI_CONST_STORAGE GUI_BITMAP _bmPassword = {
  48, // XSize */
  48, // YSize */
  192, // BytesPerLine */
  32, // BitsPerPixel */
  (unsigned char *)_acPassword,  // Pointer to picture data */
  NULL,  // Pointer to palette */
#if (GUI_USE_ARGB == 1)
  GUI_DRAW_BMPM8888I
#else
  GUI_DRAW_BMP8888
#endif
};

/*********************************************************************
*
*       _bmRead
*
* Function description
*   Icon bitmap with alpha channel
*/
static GUI_CONST_STORAGE unsigned long _acRead[] = {
#if (GUI_USE_ARGB == 1)
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02521A3F, 0x370050BE, 0x610856BE, 0x831560C5, 0xA5236CD0, 0xC33578D7, 0xD94586E2, 0xE6518FE9, 0xF25793EC, 0xEE5492EC, 0xE04888E4, 
        0xC42B72D4, 0x970E58BD, 0x4D003D93, 0x34003E97, 0x700757C3, 0x9C1664CE, 0xB21E6AD0, 0xB01E6ACF, 0xA01460C5, 0x870D59BC, 0x6C034DB1, 0x4E0042A3, 0x2800378D, 0x0B002154, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x11740000, 0x61720000, 0x8F730000, 0xA9442A5C, 0xF97DB0FA, 0xFFC7DEFF, 0xFFE0EDFF, 0xFFF7FBFF, 0xFFFCFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFBFEFF, 0xFFD9ECFF, 0xFB557CB3, 0xF94B73A9, 0xFFC7E2FF, 0xFFEEF6FF, 0xFFF7FCFF, 0xFFF5FBFF, 0xFFF1F8FF, 0xFFDFECFF, 0xFFBED9FF, 0xFE9BC4FD, 0xF874A9F0, 0xDC4E8AD9, 0xB02A6EC7, 0x800850B2, 0x34003486, 0x0C02183A, 0x01000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x057A0000, 0xC27A0000, 0xFFB90000, 0xFF8C153A, 0xFF599BF6, 0xFFEDF9FF, 0xFFFFFFFF, 0xFFFFFFFE, 0xFFFFFFFD, 0xFFFEFEFC, 0xFFFDFCFA, 0xFFFCFBFA, 0xFFFCFBFA, 0xFFFDFCFA, 0xFFFEFEFC, 
        0xFFFFFFFD, 0xFFFFFFFF, 0xFFA4A4A3, 0xFF979796, 0xFFFFFFFF, 0xFFFFFFFD, 0xFFFFFEFC, 0xFFFFFEFC, 0xFFFFFFFD, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFB7D8FF, 0xFC56A1FB, 0xCD2459B2, 0x6A5C0005, 0x45620000, 
        0x0D250000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x4D720000, 0xFF980000, 0xFFFF0000, 0xFF9D1E4E, 0xFF76B7FF, 0xFFFAFFFF, 0xFFFCFAF9, 0xFFF8F8F8, 0xFFF8F8F8, 0xFFF9F9F9, 0xFFF8F8F8, 0xFFF7F7F7, 0xFFF7F7F7, 0xFFF8F8F8, 0xFFF7F7F7, 
        0xFFF6F6F6, 0xFFFFFFFF, 0xFFA1A1A1, 0xFF929292, 0xFFFFFFFF, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF4F4F4, 0xFFF4F4F4, 0xFFF4F4F4, 0xFFF6F6F5, 0xFFFAF9F8, 0xFFFFFFFC, 0xFFEBF7FF, 0xFFCEF2FF, 0xFF647DC8, 0xFFE00004, 0xFFCA0000, 
        0xA0640000, 0x1E000000, 0x06000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x86710000, 0xFFAE0000, 0xFFFF0000, 0xFF8E285F, 0xFF7EC1FF, 0xFFFBFFFF, 0xFFFCFBFA, 0xFFF8F9F9, 0xFFF7F7F7, 0xFFF6F7F7, 0xFFF6F6F7, 0xFFF6F6F6, 0xFFF6F6F6, 0xFFF5F6F6, 0xFFF5F6F6, 
        0xFFF7F7F7, 0xFFFFFFFF, 0xFFA1A1A1, 0xFF929292, 0xFFFFFFFF, 0xFFF6F6F6, 0xFFF6F6F6, 0xFFF6F6F6, 0xFFF5F6F6, 0xFFF6F5F5, 0xFFF5F5F5, 0xFFF6F6F6, 0xFFF5F5F5, 0xFFF4F4F4, 0xFFF7F5F4, 0xFFE4F0FA, 0xFFC7ECFF, 0xFF5F86D5, 0xFFEA0007, 0xFFF70000, 
        0xF2820000, 0x5D100000, 0x18000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0xA06F0000, 0xFFBA0000, 0xFFFF0000, 0xFF833571, 0xFF8CCEFF, 0xFFFBFEFD, 0xFFF8F9F9, 0xFFF4F6F7, 0xFFF3F5F6, 0xFFF3F5F6, 0xFFF3F5F7, 0xFFF3F5F7, 0xFFF3F5F7, 0xFFF2F4F6, 0xFFF1F3F5, 
        0xFFF2F4F6, 0xFFFFFFFF, 0xFF9E9F9F, 0xFF959696, 0xFFFFFFFF, 0xFFF7F7F9, 0xFFF8F9FA, 0xFFF9F9FA, 0xFFF9FAFB, 0xFFF9FAFA, 0xFFF9F9F9, 0xFFF7F7F7, 0xFFF6F6F6, 0xFFF5F5F5, 0xFFF7F6F4, 0xFFE7F1FA, 0xFFCCEDFF, 0xFF5D8FDF, 0xFFDE000D, 0xFFF80000, 
        0xFC8E0000, 0x8D170000, 0x2B000000, 0x02000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0xB2700000, 0xFFC70000, 0xFFFF0000, 0xFF744387, 0xFF9CD4FF, 0xFFFAFCFC, 0xFFF4F7F9, 0xFFF3F5F8, 0xFFF1F4F7, 0xFFF0F3F5, 0xFFF0F3F5, 0xFFF0F3F6, 0xFFEFF2F5, 0xFFEFF2F5, 0xFFEFF2F6, 
        0xFFF0F3F6, 0xFFFDFFFF, 0xFF9A9B9D, 0xFFA0A1A2, 0xFFF7FAFC, 0xFFD4D5D7, 0xFFC1C2C3, 0xFFBABBBC, 0xFFBCBDBE, 0xFFC5C7C9, 0xFFDADBDC, 0xFFEFF0F2, 0xFFFBFCFD, 0xFFF5F6F7, 0xFFF5F4F4, 0xFFEAF3FA, 0xFFCFEFFF, 0xFF5F96E5, 0xFFCD0318, 0xFFFD0000, 
        0xFD950000, 0xA1200000, 0x37000000, 0x05000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x017A0000, 0xC5730000, 0xFFD10000, 0xFFFB0000, 0xFF61519D, 0xFFB0DBFF, 0xFFF5F8FA, 0xFFF0F5F9, 0xFFEFF4F8, 0xFFF0F4F9, 0xFFF0F4F9, 0xFFEFF4F9, 0xFFEFF4F9, 0xFFEFF4F8, 0xFFEFF4F8, 0xFFEEF3F7, 
        0xFFEDF2F6, 0xFFFCFFFF, 0xFF9CA0A1, 0xFF676869, 0xFF959696, 0xFFA1A09E, 0xFFB3B1AD, 0xFFB8B6AF, 0xFFB6B4AD, 0xFFAFADA9, 0xFF9A9997, 0xFF878787, 0xFFA9ABAC, 0xFFEEF1F3, 0xFFFCFDFD, 0xFFECF4FA, 0xFFD4F0FF, 0xFF639DEC, 0xFFB70927, 0xFFFF0000, 
        0xFE9E0000, 0xAD270000, 0x3E000000, 0x07000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x067A0000, 0xD6790000, 0xFFD90000, 0xFFF10000, 0xFF535FB3, 0xFFBDE0FE, 0xFFF2F6F9, 0xFFEDF3F9, 0xFFEDF3F9, 0xFFEDF4F9, 0xFFEDF4F9, 0xFFEDF4F9, 0xFFEDF4F9, 0xFFECF3F9, 0xFFECF2F8, 0xFFECF2F8, 
        0xFFF1F8FE, 0xFFBEC4C9, 0xFF868788, 0xFFAEACA7, 0xFFD3D1CE, 0xFFC9CDDA, 0xFFAAB6DA, 0xFF91A2D9, 0xFF8A9CD4, 0xFF97A2C9, 0xFFADB1BF, 0xFFBBB9B6, 0xFF989791, 0xFF767777, 0xFFC4C5C7, 0xFFF8FEFF, 0xFFD7F0FF, 0xFF66A4F2, 0xFFA70F33, 0xFFFF0000, 
        0xFFA50000, 0xB7300000, 0x45000000, 0x0A000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x0D6F0000, 0xE8800000, 0xFFE10000, 0xFFE60006, 0xFF456FCA, 0xFFC5E0F9, 0xFFF0F5F9, 0xFFEBF2F9, 0xFFEAF2F9, 0xFFEAF2F9, 0xFFEAF2F9, 0xFFEAF2F9, 0xFFE9F2F9, 0xFFE9F1F8, 0xFFEAF2F9, 0xFFECF5FC, 
        0xFFA8ADB1, 0xFF8E8E8D, 0xFFD3D1CD, 0xFFC2CEEA, 0xFF91ACEC, 0xFF8BACF3, 0xFF98B6F8, 0xFFA7C1FB, 0xFFA8C0FB, 0xFF96B0F6, 0xFF7D99E6, 0xFF6D87D0, 0xFF939DBA, 0xFFADAAA3, 0xFF767675, 0xFFAEB2B6, 0xFFDAF2FF, 0xFF67AAF6, 0xFF991541, 0xFFFF0000, 
        0xFFAD0000, 0xC0370000, 0x4B000000, 0x0D000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x186E0000, 0xF4860000, 0xFFE90000, 0xFFD70412, 0xFF477BD7, 0xFFCBE0F5, 0xFFEDF5FA, 0xFFE7F1F9, 0xFFE7F0F9, 0xFFE7F0F9, 0xFFE6F0F8, 0xFFE6F0F9, 0xFFE6F0F9, 0xFFE5EFF8, 0xFFECF7FF, 0xFFB5BDC3, 
        0xFF90908F, 0xFFE5E3DF, 0xFFADC2F0, 0xFF7FAAFA, 0xFFB1D5FF, 0xFFD1EBFF, 0xFFDBF1FF, 0xFFE1F2FF, 0xFFE5F5FF, 0xFFE9F8FF, 0xFFE3F4FF, 0xFFC3DEFF, 0xFF6F95EB, 0xFF6F81B2, 0xFFB1AFAA, 0xFF616060, 0xFFA0B1BE, 0xFF70B7FF, 0xFF891C4E, 0xFFFF0000, 
        0xFFB70000, 0xC73F0000, 0x51000000, 0x10000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x2C700000, 0xF98C0000, 0xFFF10000, 0xFFC80B1F, 0xFF4D84DD, 0xFFCEE0F3, 0xFFEBF5FC, 0xFFE5F1FA, 0xFFE4EFF9, 0xFFE4EFF9, 0xFFE4EFF9, 0xFFE4EFFA, 0xFFE3EFF9, 0xFFE8F3FE, 0xFFCFD9E2, 0xFF818283, 
        0xFFDFDCD8, 0xFFB3C9F4, 0xFF86B6FD, 0xFFB6DDFF, 0xFFBEE0FF, 0xFFC3E2FF, 0xFFCAE5FF, 0xFFD0E8FF, 0xFFD3E9FF, 0xFFD3E9FF, 0xFFD2E9FF, 0xFFD3EBFF, 0xFFCDE9FF, 0xFF7EA7F6, 0xFF6A7DAF, 0xFFA8A49F, 0xFF616160, 0xFF579FE7, 0xFF802860, 0xFFFF0000, 
        0xFFBF0000, 0xCF470000, 0x57000000, 0x13000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x426F0000, 0xFD930000, 0xFFF70000, 0xFFB6122E, 0xFF568DE4, 0xFFD2E1F0, 0xFFE9F4FC, 0xFFE1EEFA, 0xFFE0EDF8, 0xFFE0ECF7, 0xFFDFEBF6, 0xFFDDEAF5, 0xFFDDEAF5, 0xFFE1EFFA, 0xFF93999E, 0xFFBEBBB6, 
        0xFFCBDAF5, 0xFF83B6FE, 0xFFA4D3FF, 0xFFADD7FF, 0xFFB4D9FF, 0xFFBADDFF, 0xFFC0E1FF, 0xFFC4E2FF, 0xFFC9E4FF, 0xFFC9E4FF, 0xFFC8E3FF, 0xFFC3E1FF, 0xFFC0E1FF, 0xFFBEE2FF, 0xFF79A5EE, 0xFF818BA2, 0xFF91897E, 0xFF1F5C95, 0xFF763373, 0xFFFF0000, 
        0xFFCA0000, 0xD7500000, 0x5E000000, 0x16000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x576C0000, 0xFF9D0000, 0xFFFA0000, 0xFFA6173D, 0xFF5C96EB, 0xFFD5E1EE, 0xFFE6F3FC, 0xFFDFEDFA, 0xFFDEECF8, 0xFFDCEBF7, 0xFFDCEAF6, 0xFFDBEAF6, 0xFFDEEDFA, 0xFFC2CFDB, 0xFF858585, 0xFFE4E3E4, 
        0xFF97C0FD, 0xFF8FC7FF, 0xFF9DD0FF, 0xFFA5D2FF, 0xFFABD6FF, 0xFFB2DAFF, 0xFFB7DCFF, 0xFFBBDDFF, 0xFFBDDFFF, 0xFFBEDFFF, 0xFFBCDEFF, 0xFFBADDFF, 0xFFB5DBFF, 0xFFB2DAFF, 0xFFA4D3FF, 0xFF6282C0, 0xFFA09C96, 0xFF305878, 0xFF622A6B, 0xFFFF0000, 
        0xFFD40000, 0xE15B0000, 0x64000000, 0x1A000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x6B6D0000, 0xFFA80000, 0xFFFD0000, 0xFF971F4D, 0xFF629EEF, 0xFFDAE4ED, 0xFFE1EFFB, 0xFFDAEAF7, 0xFFD9E9F7, 0xFFD9E9F7, 0xFFD9E8F7, 0xFFD9E9F7, 0xFFE0F1FF, 0xFFA2ADB6, 0xFFA9A6A3, 0xFFD9E3F2, 
        0xFF98C8FF, 0xFF9BCFFF, 0xFF96CBFF, 0xFF9BCEFF, 0xFFA2D2FF, 0xFFA9D4FF, 0xFFADD7FF, 0xFFB0D8FF, 0xFFB2DAFF, 0xFFB3DAFF, 0xFFB2D9FF, 0xFFAFD8FF, 0xFFABD6FF, 0xFFA7D4FF, 0xFFA5D5FF, 0xFF73A6F1, 0xFF838B9E, 0xFF5D6E72, 0xFF5A1B44, 0xFFFC0000, 
        0xFFDA0000, 0xEA670000, 0x6D000000, 0x1F000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x806E0000, 0xFFB30000, 0xFFFF0000, 0xFF8A285E, 0xFF66A3F0, 0xFFDFE6ED, 0xFFDAEBF9, 0xFFD7E9F8, 0xFFD7E9F8, 0xFFD8E9F9, 0xFFD8EAF9, 0xFFD7E9F9, 0xFFDDF0FF, 0xFF98A0A7, 0xFFC7C2BD, 0xFFCADFFA, 
        0xFFA6D3FF, 0xFFA6D5FF, 0xFF9ACDFF, 0xFF95CBFF, 0xFF99CCFF, 0xFF9ECFFF, 0xFFA2D1FF, 0xFFA5D3FF, 0xFFA7D5FF, 0xFFA7D5FF, 0xFFA7D4FF, 0xFFA5D3FF, 0xFFA1D1FF, 0xFF9DCEFF, 0xFF99CEFF, 0xFF8AC1FF, 0xFF6E81A5, 0xFF717973, 0xFF581324, 0xFFF60105, 
        0xFFDD0000, 0xF2740000, 0x7A070000, 0x23000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x966E0000, 0xFFBE0000, 0xFFFF0000, 0xFF80316C, 0xFF6DA9F0, 0xFFE3E9F0, 0xFFD6E9F8, 0xFFD4E7F7, 0xFFD5E8F8, 0xFFD5E8F9, 0xFFD5E8F9, 0xFFD6E9FA, 0xFFD6E9FB, 0xFF959DA3, 0xFFD0CCC8, 0xFFC5DFFD, 
        0xFFB2DAFF, 0xFFB2DBFF, 0xFFA7D4FF, 0xFF9DCFFF, 0xFF97CBFF, 0xFF95CBFF, 0xFF98CCFF, 0xFF9BCEFF, 0xFF9DCFFF, 0xFF9DCFFF, 0xFF9CCEFF, 0xFF9ACDFF, 0xFF97CCFF, 0xFF95CBFF, 0xFF99CDFF, 0xFF9ED2FF, 0xFF6A83AA, 0xFF767D76, 0xFF53131D, 0xFFF10004, 
        0xFFE10000, 0xF9820000, 0x860C0000, 0x2A000000, 0x01000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0xB4720000, 0xFFC80000, 0xFFFC0000, 0xFF773C7C, 0xFF7AAEEC, 0xFFE7EFF5, 0xFFD3E9FB, 0xFFD2E7F9, 0xFFD2E7F9, 0xFFD2E7F9, 0xFFD2E7F9, 0xFFD2E7F9, 0xFFD1E6F9, 0xFF949BA2, 0xFFCECBC7, 0xFFC5E0FC, 
        0xFFBEE0FF, 0xFFBFE1FF, 0xFFB4DBFF, 0xFFACD7FF, 0xFFA5D3FF, 0xFF9ECFFF, 0xFF99CDFF, 0xFF97CCFF, 0xFF96CBFF, 0xFF96CBFF, 0xFF97CBFF, 0xFF97CCFF, 0xFF9ACEFF, 0xFFA0D1FF, 0xFFA7D5FF, 0xFFAEDCFF, 0xFF6E88AC, 0xFF757A74, 0xFF481523, 0xFFED0105, 
        0xFFE50000, 0xFC8C0000, 0x95150000, 0x31000000, 0x02000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x037A0000, 0xCE780000, 0xFFCF0000, 0xFFF40000, 0xFF6C468C, 0xFF88B2E6, 0xFFE7F0F8, 0xFFCFE6FB, 0xFFCFE5F9, 0xFFCEE4F8, 0xFFCDE3F7, 0xFFCDE3F7, 0xFFCDE3F7, 0xFFCFE7FB, 0xFF919BA3, 0xFFC3BFBB, 0xFFCCE4FA, 
        0xFFC4E4FF, 0xFFCBE7FF, 0xFFC2E3FF, 0xFFBADFFF, 0xFFB3DBFF, 0xFFAED8FF, 0xFFA9D6FF, 0xFFA5D4FF, 0xFFA3D2FF, 0xFFA3D2FF, 0xFFA4D2FF, 0xFFA6D4FF, 0xFFAAD6FF, 0xFFB0D9FF, 0xFFB7DDFF, 0xFFB7DEFF, 0xFF7187A4, 0xFF6E716A, 0xFF391933, 0xFFE8040C, 
        0xFFE90000, 0xFD940000, 0xA21F0000, 0x37000000, 0x04000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x0D6F0000, 0xE97E0000, 0xFFD50000, 0xFFED0000, 0xFF634F9B, 0xFF97B8E1, 0xFFE0EDF8, 0xFFCBE4FA, 0xFFCBE3F7, 0xFFCAE2F6, 0xFFCAE2F6, 0xFFCAE2F6, 0xFFCAE2F7, 0xFFD0EAFF, 0xFF94A2AD, 0xFFACA9A6, 0xFFD1E0EE, 
        0xFFC7E6FF, 0xFFD1EAFF, 0xFFCCE8FF, 0xFFC9E6FF, 0xFFC2E3FF, 0xFFBDE0FF, 0xFFB9DEFF, 0xFFB7DCFF, 0xFFB4DBFF, 0xFFB4DBFF, 0xFFB5DBFF, 0xFFB7DDFF, 0xFFBADFFF, 0xFFBFE1FF, 0xFFC9E7FF, 0xFFACD4FA, 0xFF798799, 0xFF5E6463, 0xFF252861, 0xFFE5060E, 
        0xFFED0000, 0xFE9B0000, 0xAC270000, 0x3E000000, 0x07000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x1C700000, 0xF5830000, 0xFFDA0000, 0xFFE50000, 0xFF5957A8, 0xFFA5BCDD, 0xFFDBEBF9, 0xFFC8E2FA, 0xFFC8E2F8, 0xFFC8E1F7, 0xFFC5E0F6, 0xFFC5E0F5, 0xFFC7E0F6, 0xFFCBE6FC, 0xFFA2B6C8, 0xFF898887, 0xFFD1D6DA, 
        0xFFC3E3FF, 0xFFD5ECFF, 0xFFD1EAFF, 0xFFCEE8FF, 0xFFCDE8FF, 0xFFCAE7FF, 0xFFC7E5FF, 0xFFC4E4FF, 0xFFC3E3FF, 0xFFC3E3FF, 0xFFC3E3FF, 0xFFC5E4FF, 0xFFC9E6FF, 0xFFCBE7FF, 0xFFD1EDFF, 0xFF92B7DE, 0xFF828487, 0xFF4A5761, 0xFF1F47A4, 0xFFDF040B, 
        0xFFEF0000, 0xFFA20000, 0xB7300000, 0x45000000, 0x0A000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x32710000, 0xFA870000, 0xFFE00000, 0xFFDF0003, 0xFF5261B4, 0xFFACBFDB, 0xFFD3E7F9, 0xFFC4E1F9, 0xFFC5E1F8, 0xFFC4E1F9, 0xFFC4E1F9, 0xFFC4E1F9, 0xFFC4E0F8, 0xFFC5E1FA, 0xFFBFDCF3, 0xFF7D8489, 0xFFB9B6B3, 
        0xFFC8DDF1, 0xFFCEEAFF, 0xFFD8EDFF, 0xFFD3EBFF, 0xFFD1EAFF, 0xFFD0E9FF, 0xFFCFE9FF, 0xFFCEE9FF, 0xFFCEE8FF, 0xFFCEE8FF, 0xFFCEE8FF, 0xFFCEE9FF, 0xFFCFE9FF, 0xFFD5EDFF, 0xFFC3E5FF, 0xFF76889B, 0xFF7C7872, 0xFF475565, 0xFF3369CF, 0xFFD9020B, 
        0xFFF00000, 0xFFA90000, 0xC0370000, 0x4B000000, 0x0D000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x466E0000, 0xFE8C0000, 0xFFE50000, 0xFFDA0109, 0xFF4B6ABF, 0xFFB2C0D9, 0xFFCEE6FA, 0xFFC2DFF9, 0xFFC3E0F8, 0xFFC3E1F9, 0xFFC4E1F9, 0xFFC4E1F9, 0xFFC4E1F9, 0xFFC4E1F9, 0xFFCAE7FF, 0xFF9DB1C1, 0xFF848381, 
        0xFFCBCCCD, 0xFFC7E1F8, 0xFFD7EFFF, 0xFFDBEFFF, 0xFFD7EDFF, 0xFFD6ECFF, 0xFFD5EBFF, 0xFFD3EBFF, 0xFFD3EBFF, 0xFFD3EBFF, 0xFFD3EBFF, 0xFFD4EBFF, 0xFFD8EEFF, 0xFFD6F2FF, 0xFF91B0CE, 0xFF858686, 0xFF4B4947, 0xFF687790, 0xFF3975D7, 0xFFCE0411, 
        0xFFEF0000, 0xFFB10000, 0xC73F0000, 0x51000000, 0x10000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x5C6D0000, 0xFF930000, 0xFFE90000, 0xFFCF0612, 0xFF4770C8, 0xFFB7C2D8, 0xFFCEE7FC, 0xFFC3E1F9, 0xFFC4E1F9, 0xFFC4E1F9, 0xFFC4E1F9, 0xFFC3E1F9, 0xFFC4E1F9, 0xFFC4E0F9, 0xFFC4E1FA, 0xFFC4E1F9, 0xFF87939D, 
        0xFF9A9794, 0xFFC2C8CC, 0xFFC9DFF4, 0xFFD9F0FF, 0xFFE0F2FF, 0xFFDDEFFF, 0xFFDBEEFF, 0xFFD9EEFF, 0xFFD9EEFF, 0xFFDAEEFF, 0xFFDBEEFF, 0xFFDFF2FF, 0xFFD3EDFF, 0xFF98B3CE, 0xFF81858A, 0xFF666360, 0xFF67696F, 0xFF98A5C2, 0xFF3671D1, 0xFFBC0A1E, 
        0xFFF00000, 0xFFBB0000, 0xCF470000, 0x57000000, 0x13000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x706E0000, 0xFF9B0000, 0xFFEC0000, 0xFFB70F27, 0xFF4876CB, 0xFFBBC4D8, 0xFFCFEAFF, 0xFFC3E1F9, 0xFFC4E1F9, 0xFFC4E1F9, 0xFFC4E1F9, 0xFFC3E0F9, 0xFFC3E0F8, 0xFFC3E0F8, 0xFFC3E0F8, 0xFFC7E3FC, 0xFFBEDBF2, 
        0xFF7A8288, 0xFF94918E, 0xFFB8BABB, 0xFFC0D3E4, 0xFFD1E8FC, 0xFFDDF3FF, 0xFFE2F4FF, 0xFFE2F4FF, 0xFFE2F4FF, 0xFFE1F5FF, 0xFFDBF2FF, 0xFFC1DBF4, 0xFF8FA3B5, 0xFF848585, 0xFF777573, 0xFF5E6A71, 0xFFCDDAE7, 0xFF98A1BA, 0xFF3775D1, 0xFFAB102C, 
        0xFFF00000, 0xFFC20000, 0xD54F0000, 0x5D000000, 0x16000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x846F0000, 0xFFA40000, 0xFFEE0000, 0xFFA1173A, 0xFF4B7BCE, 0xFFC1CADA, 0xFFCEEAFF, 0xFFC2E1F9, 0xFFC2E0F9, 0xFFC2E0F9, 0xFFC2E0F9, 0xFFC2E0FA, 0xFFC1E0FA, 0xFFC1E0FA, 0xFFC1E0F9, 0xFFC1DFF8, 0xFFC4E3FC, 
        0xFFBAD7ED, 0xFF7F8991, 0xFF8A8989, 0xFFA5A3A1, 0xFFB0B4B9, 0xFFB6C7D5, 0xFFBDD1E2, 0xFFC2D7E9, 0xFFBFD4E6, 0xFFB2C7DA, 0xFF9EAFBE, 0xFF898E92, 0xFF8E8D8B, 0xFFB7B6B5, 0xFF9E9F9E, 0xFF766A73, 0xFFD8CAD9, 0xFF979FB6, 0xFF3B78D1, 0xFF9B1439, 
        0xFFF00000, 0xFFCD0000, 0xDC570000, 0x62000000, 0x19000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x9F700000, 0xFFAD0000, 0xFFF10000, 0xFF8A204F, 0xFF5485D1, 0xFFD3D6DD, 0xFFD9F0FF, 0xFFD6EBFB, 0xFFD9ECFB, 0xFFDBECF9, 0xFFDDEBF8, 0xFFDFEBF6, 0xFFE1ECF6, 0xFFE1ECF6, 0xFFE0EBF7, 0xFFDEEBF8, 0xFFDBEBF9, 
        0xFFD8EDFE, 0xFFD9F2FF, 0xFF788086, 0xFF706F6C, 0xFF85827F, 0xFF938F8A, 0xFF989693, 0xFF969694, 0xFF929190, 0xFF8D8A87, 0xFF7F7C76, 0xFF686662, 0xFF686B69, 0xFFAEB2B2, 0xFFD9DEDF, 0xFFC18E87, 0xFFD74539, 0xFFA5606F, 0xFF3B83DA, 0xFF8B1A48, 
        0xFFF10000, 0xFFD20000, 0xE3600000, 0x68000000, 0x1C000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xBA730000, 0xFFB40000, 0xFFF30000, 0xFF722C66, 0xFF3D8EEB, 0xFF8DB0DF, 0xFF92B9EB, 0xFF89AFE3, 0xFF86A9DA, 0xFF81A3D3, 0xFF7B9DCF, 0xFF7798CB, 0xFF7597C9, 0xFF7597C9, 0xFF7897C4, 0xFF7A99C7, 0xFF809FCD, 
        0xFF89A9D5, 0xFF9EC3EF, 0xFF597394, 0xFF748DAC, 0xFF6985A9, 0xFF5F7894, 0xFF607487, 0xFF5C6F7E, 0xFF586A79, 0xFF556779, 0xFF566880, 0xFF6F84A1, 0xFF6B606F, 0xFF927677, 0xFFBDC2C9, 0xFFE2EBEA, 0xFFF9DA87, 0xFFD04024, 0xFF3C6DC7, 0xFF79245A, 
        0xFFF00000, 0xFFD30000, 0xE8690000, 0x6E000000, 0x1F000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xD3760000, 0xFFB90000, 0xFFEF0000, 0xFF8F2047, 0xFF4D4A9B, 0xFF534190, 0xFF503F8E, 0xFF4F3E8C, 0xFF4F3E8B, 0xFF503E8B, 0xFF503E8B, 0xFF503E8B, 0xFF4F3D8A, 0xFF4F3D8A, 0xFF513B85, 0xFF57387F, 0xFF55357D, 
        0xFF54347C, 0xFF53337B, 0xFF564087, 0xFF53428C, 0xFF523B88, 0xFF4E3F8E, 0xFF493E8C, 0xFF423E8F, 0xFF414293, 0xFF42489A, 0xFF4351A7, 0xFF3A56B1, 0xFF642B65, 0xFFD68266, 0xFFCAD6B8, 0xFFE6DC99, 0xFFFFF360, 0xFFF59F35, 0xFF6C275E, 0xFF77255A, 
        0xFFF00000, 0xFFD60000, 0xEE730000, 0x74000000, 0x22000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xD9770000, 0xFFC10707, 0xFFE50202, 0xFFE00000, 0xFFDF0000, 0xFFDF0000, 0xFFDF0000, 0xFFE10000, 0xFFE20000, 0xFFE30100, 0xFFE50504, 0xFFE60908, 0xFFE80F0E, 0xFFEA1716, 0xFFED1F1E, 0xFFF02724, 0xFFF22C2A, 
        0xFFF2312F, 0xFFF23E3C, 0xFFF35553, 0xFFF15453, 0xFFF14140, 0xFFEE3B3A, 0xFFEC3636, 0xFFE82C2E, 0xFFE31D1F, 0xFFE01113, 0xFFDB090B, 0xFFD90103, 0xFFCB0000, 0xFFCF4825, 0xFFFFC54D, 0xFFFFB62C, 0xFFFFC83B, 0xFFFFF45D, 0xFFD76126, 0xFFC80000, 
        0xFFE40000, 0xFFD80A0A, 0xF37F0101, 0x79000000, 0x25000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0xB56F0000, 0xFFB91414, 0xFFF22424, 0xFFED201F, 0xFFEE2221, 0xFFEE2625, 0xFFEF2C2B, 0xFFEF3130, 0xFFEE3636, 0xFFEB3C3B, 0xFFE94241, 0xFFE74746, 0xFFE34848, 0xFFDF4645, 0xFFDB4443, 0xFFD7403F, 0xFFD23838, 
        0xFFCC3232, 0xFFBD1F1F, 0xFFA30605, 0xFFA50A0A, 0xFFBE2727, 0xFFCD3B3A, 0xFFD84C4C, 0xFFE15C5B, 0xFFE76A69, 0xFFEC706F, 0xFFF06B6A, 0xFFF36665, 0xFFF56363, 0xFFCE3134, 0xFFE14500, 0xFFFF880F, 0xFFFFAB2B, 0xFFFFDE4B, 0xFFF9DE57, 0xFFC71E0B, 
        0xFFE01C20, 0xFFE13535, 0xF5850000, 0x7F000000, 0x27000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x47520000, 0xEE7A0202, 0xFF9D0E0E, 0xFFA51313, 0xFFA71313, 0xFFA51111, 0xFF9E0D0D, 0xFF970B0B, 0xFF930909, 0xFE8F0606, 0xFD8B0404, 0xFC860101, 0xFC810000, 0xF8790000, 0xF36E0000, 0xED640000, 0xE75C0000, 
        0xDF520000, 0xD84C0000, 0xC5350000, 0xBD300000, 0xC9410000, 0xD44D0000, 0xE0580000, 0xEA670000, 0xF4780000, 0xFB870202, 0xFD900A0A, 0xFE9A1111, 0xFFA51C1C, 0xFFA8171A, 0xFFAB0D00, 0xFFF76C08, 0xFFFF9217, 0xFFFFB834, 0xFFFFF056, 0xFFE8AD44, 
        0xFFCA3C3F, 0xFFD12425, 0xF0740000, 0x7F000000, 0x28000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x0C000000, 0x4D270000, 0xA73E0000, 0xC5410000, 0xCB400000, 0xCA400000, 0xC73B0000, 0xC0340000, 0xBA2E0000, 0xB4270000, 0xAD210000, 0xA4190000, 0x9B110000, 0x930A0000, 0x8B060000, 0x80010000, 0x78000000, 
        0x70000000, 0x69000000, 0x5F000000, 0x54000000, 0x50000000, 0x58000000, 0x62000000, 0x6D010000, 0x7B080000, 0x8C110000, 0x9E1E0000, 0xAC270000, 0xB7300000, 0xC1380000, 0xD1500000, 0xFCC53002, 0xFFFF810C, 0xFFFF9F22, 0xFFFFCC40, 0xFFFFF55D, 
        0xFFC75020, 0xF9830000, 0xC62F0000, 0x70000000, 0x20000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x02000000, 0x11000000, 0x30000000, 0x4B000000, 0x56000000, 0x58000000, 0x58000000, 0x54000000, 0x4F000000, 0x4B000000, 0x46000000, 0x40000000, 0x3A000000, 0x35000000, 0x2F000000, 0x29000000, 0x25000000, 
        0x20000000, 0x1C000000, 0x17000000, 0x12000000, 0x10000000, 0x14000000, 0x19000000, 0x1E000000, 0x24000000, 0x2B000000, 0x34000000, 0x3D000000, 0x44000000, 0x4C000000, 0x54000000, 0xC3760000, 0xFFDF4F04, 0xFFFF8C12, 0xFFFFAD2C, 0xFFFFDD4B, 
        0xFFF6D956, 0xF4961D0D, 0xA1140000, 0x4F000000, 0x11000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x01000000, 0x06000000, 0x0E000000, 0x13000000, 0x14000000, 0x13000000, 0x12000000, 0x10000000, 0x0D000000, 0x0B000000, 0x08000000, 0x06000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x04000000, 0x07000000, 0x0A000000, 0x0D000000, 0x12000000, 0x36250000, 0xE3940D00, 0xFFF36B08, 0xFFFF9519, 0xFFFFB935, 
        0xFFFFF359, 0xFFE3A644, 0xCA680001, 0x43000000, 0x0C000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08000000, 0x6F5C0000, 0xFDBD3202, 0xFFFF830C, 0xFFFFA022, 
        0xFFFFD443, 0xFFF9DF55, 0xDF791108, 0x58000000, 0x15000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x12000000, 0xB06E0100, 0xFFDC5105, 0xFFFF8F13, 
        0xFFFFAD2D, 0xFFBD511B, 0xC8400000, 0x64000000, 0x1A000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x373B0000, 0xD27B0B00, 0xFAAD2E06, 
        0xF1861805, 0xCF3D0000, 0x8E000000, 0x49000000, 0x10000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x09000000, 0x2E000000, 0x65000000, 
        0x81000000, 0x75000000, 0x4D000000, 0x1D000000, 0x04000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x0A000000, 0x1D000000, 
        0x28000000, 0x22000000, 0x12000000, 0x04000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF
#else
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD3F1A52, 0xC8BE5000, 0x9EBE5608, 0x7CC56015, 0x5AD06C23, 0x3CD77835, 0x26E28645, 0x19E98F51, 0x0DEC9357, 0x11EC9254, 0x1FE48848, 
        0x3BD4722B, 0x68BD580E, 0xB2933D00, 0xCB973E00, 0x8FC35707, 0x63CE6416, 0x4DD06A1E, 0x4FCF6A1E, 0x5FC56014, 0x78BC590D, 0x93B14D03, 0xB1A34200, 0xD78D3700, 0xF4542100, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xEE000074, 0x9E000072, 0x70000073, 0x565C2A44, 0x06FAB07D, 0x00FFDEC7, 0x00FFEDE0, 0x00FFFBF7, 0x00FFFFFC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFEFB, 0x00FFECD9, 0x04B37C55, 0x06A9734B, 0x00FFE2C7, 0x00FFF6EE, 0x00FFFCF7, 0x00FFFBF5, 0x00FFF8F1, 0x00FFECDF, 0x00FFD9BE, 0x01FDC49B, 0x07F0A974, 0x23D98A4E, 0x4FC76E2A, 0x7FB25008, 0xCB863400, 0xF33A1802, 0xFE000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFA00007A, 0x3D00007A, 0x000000B9, 0x003A158C, 0x00F69B59, 0x00FFF9ED, 0x00FFFFFF, 0x00FEFFFF, 0x00FDFFFF, 0x00FCFEFE, 0x00FAFCFD, 0x00FAFBFC, 0x00FAFBFC, 0x00FAFCFD, 0x00FCFEFE, 
        0x00FDFFFF, 0x00FFFFFF, 0x00A3A4A4, 0x00969797, 0x00FFFFFF, 0x00FDFFFF, 0x00FCFEFF, 0x00FCFEFF, 0x00FDFFFF, 0x00FEFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFD8B7, 0x03FBA156, 0x32B25924, 0x9505005C, 0xBA000062, 
        0xF2000025, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xB2000072, 0x00000098, 0x000000FF, 0x004E1E9D, 0x00FFB776, 0x00FFFFFA, 0x00F9FAFC, 0x00F8F8F8, 0x00F8F8F8, 0x00F9F9F9, 0x00F8F8F8, 0x00F7F7F7, 0x00F7F7F7, 0x00F8F8F8, 0x00F7F7F7, 
        0x00F6F6F6, 0x00FFFFFF, 0x00A1A1A1, 0x00929292, 0x00FFFFFF, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F4F4F4, 0x00F4F4F4, 0x00F4F4F4, 0x00F5F6F6, 0x00F8F9FA, 0x00FCFFFF, 0x00FFF7EB, 0x00FFF2CE, 0x00C87D64, 0x000400E0, 0x000000CA, 
        0x5F000064, 0xE1000000, 0xF9000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0x79000071, 0x000000AE, 0x000000FF, 0x005F288E, 0x00FFC17E, 0x00FFFFFB, 0x00FAFBFC, 0x00F9F9F8, 0x00F7F7F7, 0x00F7F7F6, 0x00F7F6F6, 0x00F6F6F6, 0x00F6F6F6, 0x00F6F6F5, 0x00F6F6F5, 
        0x00F7F7F7, 0x00FFFFFF, 0x00A1A1A1, 0x00929292, 0x00FFFFFF, 0x00F6F6F6, 0x00F6F6F6, 0x00F6F6F6, 0x00F6F6F5, 0x00F5F5F6, 0x00F5F5F5, 0x00F6F6F6, 0x00F5F5F5, 0x00F4F4F4, 0x00F4F5F7, 0x00FAF0E4, 0x00FFECC7, 0x00D5865F, 0x000700EA, 0x000000F7, 
        0x0D000082, 0xA2000010, 0xE7000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0x5F00006F, 0x000000BA, 0x000000FF, 0x00713583, 0x00FFCE8C, 0x00FDFEFB, 0x00F9F9F8, 0x00F7F6F4, 0x00F6F5F3, 0x00F6F5F3, 0x00F7F5F3, 0x00F7F5F3, 0x00F7F5F3, 0x00F6F4F2, 0x00F5F3F1, 
        0x00F6F4F2, 0x00FFFFFF, 0x009F9F9E, 0x00969695, 0x00FFFFFF, 0x00F9F7F7, 0x00FAF9F8, 0x00FAF9F9, 0x00FBFAF9, 0x00FAFAF9, 0x00F9F9F9, 0x00F7F7F7, 0x00F6F6F6, 0x00F5F5F5, 0x00F4F6F7, 0x00FAF1E7, 0x00FFEDCC, 0x00DF8F5D, 0x000D00DE, 0x000000F8, 
        0x0300008E, 0x72000017, 0xD4000000, 0xFD000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0x4D000070, 0x000000C7, 0x000000FF, 0x00874374, 0x00FFD49C, 0x00FCFCFA, 0x00F9F7F4, 0x00F8F5F3, 0x00F7F4F1, 0x00F5F3F0, 0x00F5F3F0, 0x00F6F3F0, 0x00F5F2EF, 0x00F5F2EF, 0x00F6F2EF, 
        0x00F6F3F0, 0x00FFFFFD, 0x009D9B9A, 0x00A2A1A0, 0x00FCFAF7, 0x00D7D5D4, 0x00C3C2C1, 0x00BCBBBA, 0x00BEBDBC, 0x00C9C7C5, 0x00DCDBDA, 0x00F2F0EF, 0x00FDFCFB, 0x00F7F6F5, 0x00F4F4F5, 0x00FAF3EA, 0x00FFEFCF, 0x00E5965F, 0x001803CD, 0x000000FD, 
        0x02000095, 0x5E000020, 0xC8000000, 0xFA000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFE00007A, 0x3A000073, 0x000000D1, 0x000000FB, 0x009D5161, 0x00FFDBB0, 0x00FAF8F5, 0x00F9F5F0, 0x00F8F4EF, 0x00F9F4F0, 0x00F9F4F0, 0x00F9F4EF, 0x00F9F4EF, 0x00F8F4EF, 0x00F8F4EF, 0x00F7F3EE, 
        0x00F6F2ED, 0x00FFFFFC, 0x00A1A09C, 0x00696867, 0x00969695, 0x009EA0A1, 0x00ADB1B3, 0x00AFB6B8, 0x00ADB4B6, 0x00A9ADAF, 0x0097999A, 0x00878787, 0x00ACABA9, 0x00F3F1EE, 0x00FDFDFC, 0x00FAF4EC, 0x00FFF0D4, 0x00EC9D63, 0x002709B7, 0x000000FF, 
        0x0100009E, 0x52000027, 0xC1000000, 0xF8000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xF900007A, 0x29000079, 0x000000D9, 0x000000F1, 0x00B35F53, 0x00FEE0BD, 0x00F9F6F2, 0x00F9F3ED, 0x00F9F3ED, 0x00F9F4ED, 0x00F9F4ED, 0x00F9F4ED, 0x00F9F4ED, 0x00F9F3EC, 0x00F8F2EC, 0x00F8F2EC, 
        0x00FEF8F1, 0x00C9C4BE, 0x00888786, 0x00A7ACAE, 0x00CED1D3, 0x00DACDC9, 0x00DAB6AA, 0x00D9A291, 0x00D49C8A, 0x00C9A297, 0x00BFB1AD, 0x00B6B9BB, 0x00919798, 0x00777776, 0x00C7C5C4, 0x00FFFEF8, 0x00FFF0D7, 0x00F2A466, 0x00330FA7, 0x000000FF, 
        0x000000A5, 0x48000030, 0xBA000000, 0xF5000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xF200006F, 0x17000080, 0x000000E1, 0x000600E6, 0x00CA6F45, 0x00F9E0C5, 0x00F9F5F0, 0x00F9F2EB, 0x00F9F2EA, 0x00F9F2EA, 0x00F9F2EA, 0x00F9F2EA, 0x00F9F2E9, 0x00F8F1E9, 0x00F9F2EA, 0x00FCF5EC, 
        0x00B1ADA8, 0x008D8E8E, 0x00CDD1D3, 0x00EACEC2, 0x00ECAC91, 0x00F3AC8B, 0x00F8B698, 0x00FBC1A7, 0x00FBC0A8, 0x00F6B096, 0x00E6997D, 0x00D0876D, 0x00BA9D93, 0x00A3AAAD, 0x00757676, 0x00B6B2AE, 0x00FFF2DA, 0x00F6AA67, 0x00411599, 0x000000FF, 
        0x000000AD, 0x3F000037, 0xB4000000, 0xF2000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xE700006E, 0x0B000086, 0x000000E9, 0x001204D7, 0x00D77B47, 0x00F5E0CB, 0x00FAF5ED, 0x00F9F1E7, 0x00F9F0E7, 0x00F9F0E7, 0x00F8F0E6, 0x00F9F0E6, 0x00F9F0E6, 0x00F8EFE5, 0x00FFF7EC, 0x00C3BDB5, 
        0x008F9090, 0x00DFE3E5, 0x00F0C2AD, 0x00FAAA7F, 0x00FFD5B1, 0x00FFEBD1, 0x00FFF1DB, 0x00FFF2E1, 0x00FFF5E5, 0x00FFF8E9, 0x00FFF4E3, 0x00FFDEC3, 0x00EB956F, 0x00B2816F, 0x00AAAFB1, 0x00606061, 0x00BEB1A0, 0x00FFB770, 0x004E1C89, 0x000000FF, 
        0x000000B7, 0x3800003F, 0xAE000000, 0xEF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xD3000070, 0x0600008C, 0x000000F1, 0x001F0BC8, 0x00DD844D, 0x00F3E0CE, 0x00FCF5EB, 0x00FAF1E5, 0x00F9EFE4, 0x00F9EFE4, 0x00F9EFE4, 0x00FAEFE4, 0x00F9EFE3, 0x00FEF3E8, 0x00E2D9CF, 0x00838281, 
        0x00D8DCDF, 0x00F4C9B3, 0x00FDB686, 0x00FFDDB6, 0x00FFE0BE, 0x00FFE2C3, 0x00FFE5CA, 0x00FFE8D0, 0x00FFE9D3, 0x00FFE9D3, 0x00FFE9D2, 0x00FFEBD3, 0x00FFE9CD, 0x00F6A77E, 0x00AF7D6A, 0x009FA4A8, 0x00606161, 0x00E79F57, 0x00602880, 0x000000FF, 
        0x000000BF, 0x30000047, 0xA8000000, 0xEC000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xBD00006F, 0x02000093, 0x000000F7, 0x002E12B6, 0x00E48D56, 0x00F0E1D2, 0x00FCF4E9, 0x00FAEEE1, 0x00F8EDE0, 0x00F7ECE0, 0x00F6EBDF, 0x00F5EADD, 0x00F5EADD, 0x00FAEFE1, 0x009E9993, 0x00B6BBBE, 
        0x00F5DACB, 0x00FEB683, 0x00FFD3A4, 0x00FFD7AD, 0x00FFD9B4, 0x00FFDDBA, 0x00FFE1C0, 0x00FFE2C4, 0x00FFE4C9, 0x00FFE4C9, 0x00FFE3C8, 0x00FFE1C3, 0x00FFE1C0, 0x00FFE2BE, 0x00EEA579, 0x00A28B81, 0x007E8991, 0x00955C1F, 0x00733376, 0x000000FF, 
        0x000000CA, 0x28000050, 0xA1000000, 0xE9000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xA800006C, 0x0000009D, 0x000000FA, 0x003D17A6, 0x00EB965C, 0x00EEE1D5, 0x00FCF3E6, 0x00FAEDDF, 0x00F8ECDE, 0x00F7EBDC, 0x00F6EADC, 0x00F6EADB, 0x00FAEDDE, 0x00DBCFC2, 0x00858585, 0x00E4E3E4, 
        0x00FDC097, 0x00FFC78F, 0x00FFD09D, 0x00FFD2A5, 0x00FFD6AB, 0x00FFDAB2, 0x00FFDCB7, 0x00FFDDBB, 0x00FFDFBD, 0x00FFDFBE, 0x00FFDEBC, 0x00FFDDBA, 0x00FFDBB5, 0x00FFDAB2, 0x00FFD3A4, 0x00C08262, 0x00969CA0, 0x00785830, 0x006B2A62, 0x000000FF, 
        0x000000D4, 0x1E00005B, 0x9B000000, 0xE5000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0x9400006D, 0x000000A8, 0x000000FD, 0x004D1F97, 0x00EF9E62, 0x00EDE4DA, 0x00FBEFE1, 0x00F7EADA, 0x00F7E9D9, 0x00F7E9D9, 0x00F7E8D9, 0x00F7E9D9, 0x00FFF1E0, 0x00B6ADA2, 0x00A3A6A9, 0x00F2E3D9, 
        0x00FFC898, 0x00FFCF9B, 0x00FFCB96, 0x00FFCE9B, 0x00FFD2A2, 0x00FFD4A9, 0x00FFD7AD, 0x00FFD8B0, 0x00FFDAB2, 0x00FFDAB3, 0x00FFD9B2, 0x00FFD8AF, 0x00FFD6AB, 0x00FFD4A7, 0x00FFD5A5, 0x00F1A673, 0x009E8B83, 0x00726E5D, 0x00441B5A, 0x000000FC, 
        0x000000DA, 0x15000067, 0x92000000, 0xE0000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0x7F00006E, 0x000000B3, 0x000000FF, 0x005E288A, 0x00F0A366, 0x00EDE6DF, 0x00F9EBDA, 0x00F8E9D7, 0x00F8E9D7, 0x00F9E9D8, 0x00F9EAD8, 0x00F9E9D7, 0x00FFF0DD, 0x00A7A098, 0x00BDC2C7, 0x00FADFCA, 
        0x00FFD3A6, 0x00FFD5A6, 0x00FFCD9A, 0x00FFCB95, 0x00FFCC99, 0x00FFCF9E, 0x00FFD1A2, 0x00FFD3A5, 0x00FFD5A7, 0x00FFD5A7, 0x00FFD4A7, 0x00FFD3A5, 0x00FFD1A1, 0x00FFCE9D, 0x00FFCE99, 0x00FFC18A, 0x00A5816E, 0x00737971, 0x00241358, 0x000501F6, 
        0x000000DD, 0x0D000074, 0x85000007, 0xDC000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0x6900006E, 0x000000BE, 0x000000FF, 0x006C3180, 0x00F0A96D, 0x00F0E9E3, 0x00F8E9D6, 0x00F7E7D4, 0x00F8E8D5, 0x00F9E8D5, 0x00F9E8D5, 0x00FAE9D6, 0x00FBE9D6, 0x00A39D95, 0x00C8CCD0, 0x00FDDFC5, 
        0x00FFDAB2, 0x00FFDBB2, 0x00FFD4A7, 0x00FFCF9D, 0x00FFCB97, 0x00FFCB95, 0x00FFCC98, 0x00FFCE9B, 0x00FFCF9D, 0x00FFCF9D, 0x00FFCE9C, 0x00FFCD9A, 0x00FFCC97, 0x00FFCB95, 0x00FFCD99, 0x00FFD29E, 0x00AA836A, 0x00767D76, 0x001D1353, 0x000400F1, 
        0x000000E1, 0x06000082, 0x7900000C, 0xD5000000, 0xFE000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0x4B000072, 0x000000C8, 0x000000FC, 0x007C3C77, 0x00ECAE7A, 0x00F5EFE7, 0x00FBE9D3, 0x00F9E7D2, 0x00F9E7D2, 0x00F9E7D2, 0x00F9E7D2, 0x00F9E7D2, 0x00F9E6D1, 0x00A29B94, 0x00C7CBCE, 0x00FCE0C5, 
        0x00FFE0BE, 0x00FFE1BF, 0x00FFDBB4, 0x00FFD7AC, 0x00FFD3A5, 0x00FFCF9E, 0x00FFCD99, 0x00FFCC97, 0x00FFCB96, 0x00FFCB96, 0x00FFCB97, 0x00FFCC97, 0x00FFCE9A, 0x00FFD1A0, 0x00FFD5A7, 0x00FFDCAE, 0x00AC886E, 0x00747A75, 0x00231548, 0x000501ED, 
        0x000000E5, 0x0300008C, 0x6A000015, 0xCE000000, 0xFD000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFC00007A, 0x31000078, 0x000000CF, 0x000000F4, 0x008C466C, 0x00E6B288, 0x00F8F0E7, 0x00FBE6CF, 0x00F9E5CF, 0x00F8E4CE, 0x00F7E3CD, 0x00F7E3CD, 0x00F7E3CD, 0x00FBE7CF, 0x00A39B91, 0x00BBBFC3, 0x00FAE4CC, 
        0x00FFE4C4, 0x00FFE7CB, 0x00FFE3C2, 0x00FFDFBA, 0x00FFDBB3, 0x00FFD8AE, 0x00FFD6A9, 0x00FFD4A5, 0x00FFD2A3, 0x00FFD2A3, 0x00FFD2A4, 0x00FFD4A6, 0x00FFD6AA, 0x00FFD9B0, 0x00FFDDB7, 0x00FFDEB7, 0x00A48771, 0x006A716E, 0x00331939, 0x000C04E8, 
        0x000000E9, 0x02000094, 0x5D00001F, 0xC8000000, 0xFB000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xF200006F, 0x1600007E, 0x000000D5, 0x000000ED, 0x009B4F63, 0x00E1B897, 0x00F8EDE0, 0x00FAE4CB, 0x00F7E3CB, 0x00F6E2CA, 0x00F6E2CA, 0x00F6E2CA, 0x00F7E2CA, 0x00FFEAD0, 0x00ADA294, 0x00A6A9AC, 0x00EEE0D1, 
        0x00FFE6C7, 0x00FFEAD1, 0x00FFE8CC, 0x00FFE6C9, 0x00FFE3C2, 0x00FFE0BD, 0x00FFDEB9, 0x00FFDCB7, 0x00FFDBB4, 0x00FFDBB4, 0x00FFDBB5, 0x00FFDDB7, 0x00FFDFBA, 0x00FFE1BF, 0x00FFE7C9, 0x00FAD4AC, 0x00998779, 0x0063645E, 0x00612825, 0x000E06E5, 
        0x000000ED, 0x0100009B, 0x53000027, 0xC1000000, 0xF8000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xE3000070, 0x0A000083, 0x000000DA, 0x000000E5, 0x00A85759, 0x00DDBCA5, 0x00F9EBDB, 0x00FAE2C8, 0x00F8E2C8, 0x00F7E1C8, 0x00F6E0C5, 0x00F5E0C5, 0x00F6E0C7, 0x00FCE6CB, 0x00C8B6A2, 0x00878889, 0x00DAD6D1, 
        0x00FFE3C3, 0x00FFECD5, 0x00FFEAD1, 0x00FFE8CE, 0x00FFE8CD, 0x00FFE7CA, 0x00FFE5C7, 0x00FFE4C4, 0x00FFE3C3, 0x00FFE3C3, 0x00FFE3C3, 0x00FFE4C5, 0x00FFE6C9, 0x00FFE7CB, 0x00FFEDD1, 0x00DEB792, 0x00878482, 0x0061574A, 0x00A4471F, 0x000B04DF, 
        0x000000EF, 0x000000A2, 0x48000030, 0xBA000000, 0xF5000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xCD000071, 0x05000087, 0x000000E0, 0x000300DF, 0x00B46152, 0x00DBBFAC, 0x00F9E7D3, 0x00F9E1C4, 0x00F8E1C5, 0x00F9E1C4, 0x00F9E1C4, 0x00F9E1C4, 0x00F8E0C4, 0x00FAE1C5, 0x00F3DCBF, 0x0089847D, 0x00B3B6B9, 
        0x00F1DDC8, 0x00FFEACE, 0x00FFEDD8, 0x00FFEBD3, 0x00FFEAD1, 0x00FFE9D0, 0x00FFE9CF, 0x00FFE9CE, 0x00FFE8CE, 0x00FFE8CE, 0x00FFE8CE, 0x00FFE9CE, 0x00FFE9CF, 0x00FFEDD5, 0x00FFE5C3, 0x009B8876, 0x0072787C, 0x00655547, 0x00CF6933, 0x000B02D9, 
        0x000000F0, 0x000000A9, 0x3F000037, 0xB4000000, 0xF2000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xB900006E, 0x0100008C, 0x000000E5, 0x000901DA, 0x00BF6A4B, 0x00D9C0B2, 0x00FAE6CE, 0x00F9DFC2, 0x00F8E0C3, 0x00F9E1C3, 0x00F9E1C4, 0x00F9E1C4, 0x00F9E1C4, 0x00F9E1C4, 0x00FFE7CA, 0x00C1B19D, 0x00818384, 
        0x00CDCCCB, 0x00F8E1C7, 0x00FFEFD7, 0x00FFEFDB, 0x00FFEDD7, 0x00FFECD6, 0x00FFEBD5, 0x00FFEBD3, 0x00FFEBD3, 0x00FFEBD3, 0x00FFEBD3, 0x00FFEBD4, 0x00FFEED8, 0x00FFF2D6, 0x00CEB091, 0x00868685, 0x0047494B, 0x00907768, 0x00D77539, 0x001104CE, 
        0x000000EF, 0x000000B1, 0x3800003F, 0xAE000000, 0xEF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xA300006D, 0x00000093, 0x000000E9, 0x001206CF, 0x00C87047, 0x00D8C2B7, 0x00FCE7CE, 0x00F9E1C3, 0x00F9E1C4, 0x00F9E1C4, 0x00F9E1C4, 0x00F9E1C3, 0x00F9E1C4, 0x00F9E0C4, 0x00FAE1C4, 0x00F9E1C4, 0x009D9387, 
        0x0094979A, 0x00CCC8C2, 0x00F4DFC9, 0x00FFF0D9, 0x00FFF2E0, 0x00FFEFDD, 0x00FFEEDB, 0x00FFEED9, 0x00FFEED9, 0x00FFEEDA, 0x00FFEEDB, 0x00FFF2DF, 0x00FFEDD3, 0x00CEB398, 0x008A8581, 0x00606366, 0x006F6967, 0x00C2A598, 0x00D17136, 0x001E0ABC, 
        0x000000F0, 0x000000BB, 0x30000047, 0xA8000000, 0xEC000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x8F00006E, 0x0000009B, 0x000000EC, 0x00270FB7, 0x00CB7648, 0x00D8C4BB, 0x00FFEACF, 0x00F9E1C3, 0x00F9E1C4, 0x00F9E1C4, 0x00F9E1C4, 0x00F9E0C3, 0x00F8E0C3, 0x00F8E0C3, 0x00F8E0C3, 0x00FCE3C7, 0x00F2DBBE, 
        0x0088827A, 0x008E9194, 0x00BBBAB8, 0x00E4D3C0, 0x00FCE8D1, 0x00FFF3DD, 0x00FFF4E2, 0x00FFF4E2, 0x00FFF4E2, 0x00FFF5E1, 0x00FFF2DB, 0x00F4DBC1, 0x00B5A38F, 0x00858584, 0x00737577, 0x00716A5E, 0x00E7DACD, 0x00BAA198, 0x00D17537, 0x002C10AB, 
        0x000000F0, 0x000000C2, 0x2A00004F, 0xA2000000, 0xE9000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x7B00006F, 0x000000A4, 0x000000EE, 0x003A17A1, 0x00CE7B4B, 0x00DACAC1, 0x00FFEACE, 0x00F9E1C2, 0x00F9E0C2, 0x00F9E0C2, 0x00F9E0C2, 0x00FAE0C2, 0x00FAE0C1, 0x00FAE0C1, 0x00F9E0C1, 0x00F8DFC1, 0x00FCE3C4, 
        0x00EDD7BA, 0x0091897F, 0x0089898A, 0x00A1A3A5, 0x00B9B4B0, 0x00D5C7B6, 0x00E2D1BD, 0x00E9D7C2, 0x00E6D4BF, 0x00DAC7B2, 0x00BEAF9E, 0x00928E89, 0x008B8D8E, 0x00B5B6B7, 0x009E9F9E, 0x00736A76, 0x00D9CAD8, 0x00B69F97, 0x00D1783B, 0x0039149B, 
        0x000000F0, 0x000000CD, 0x23000057, 0x9D000000, 0xE6000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x60000070, 0x000000AD, 0x000000F1, 0x004F208A, 0x00D18554, 0x00DDD6D3, 0x00FFF0D9, 0x00FBEBD6, 0x00FBECD9, 0x00F9ECDB, 0x00F8EBDD, 0x00F6EBDF, 0x00F6ECE1, 0x00F6ECE1, 0x00F7EBE0, 0x00F8EBDE, 0x00F9EBDB, 
        0x00FEEDD8, 0x00FFF2D9, 0x00868078, 0x006C6F70, 0x007F8285, 0x008A8F93, 0x00939698, 0x00949696, 0x00909192, 0x00878A8D, 0x00767C7F, 0x00626668, 0x00696B68, 0x00B2B2AE, 0x00DFDED9, 0x00878EC1, 0x003945D7, 0x006F60A5, 0x00DA833B, 0x00481A8B, 
        0x000000F1, 0x000000D2, 0x1C000060, 0x97000000, 0xE3000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x45000073, 0x000000B4, 0x000000F3, 0x00662C72, 0x00EB8E3D, 0x00DFB08D, 0x00EBB992, 0x00E3AF89, 0x00DAA986, 0x00D3A381, 0x00CF9D7B, 0x00CB9877, 0x00C99775, 0x00C99775, 0x00C49778, 0x00C7997A, 0x00CD9F80, 
        0x00D5A989, 0x00EFC39E, 0x00947359, 0x00AC8D74, 0x00A98569, 0x0094785F, 0x00877460, 0x007E6F5C, 0x00796A58, 0x00796755, 0x00806856, 0x00A1846F, 0x006F606B, 0x00777692, 0x00C9C2BD, 0x00EAEBE2, 0x0087DAF9, 0x002440D0, 0x00C76D3C, 0x005A2479, 
        0x000000F0, 0x000000D3, 0x17000069, 0x91000000, 0xE0000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x2C000076, 0x000000B9, 0x000000EF, 0x0047208F, 0x009B4A4D, 0x00904153, 0x008E3F50, 0x008C3E4F, 0x008B3E4F, 0x008B3E50, 0x008B3E50, 0x008B3E50, 0x008A3D4F, 0x008A3D4F, 0x00853B51, 0x007F3857, 0x007D3555, 
        0x007C3454, 0x007B3353, 0x00874056, 0x008C4253, 0x00883B52, 0x008E3F4E, 0x008C3E49, 0x008F3E42, 0x00934241, 0x009A4842, 0x00A75143, 0x00B1563A, 0x00652B64, 0x006682D6, 0x00B8D6CA, 0x0099DCE6, 0x0060F3FF, 0x00359FF5, 0x005E276C, 0x005A2577, 
        0x000000F0, 0x000000D6, 0x11000073, 0x8B000000, 0xDD000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x26000077, 0x000707C1, 0x000202E5, 0x000000E0, 0x000000DF, 0x000000DF, 0x000000DF, 0x000000E1, 0x000000E2, 0x000001E3, 0x000405E5, 0x000809E6, 0x000E0FE8, 0x001617EA, 0x001E1FED, 0x002427F0, 0x002A2CF2, 
        0x002F31F2, 0x003C3EF2, 0x005355F3, 0x005354F1, 0x004041F1, 0x003A3BEE, 0x003636EC, 0x002E2CE8, 0x001F1DE3, 0x001311E0, 0x000B09DB, 0x000301D9, 0x000000CB, 0x002548CF, 0x004DC5FF, 0x002CB6FF, 0x003BC8FF, 0x005DF4FF, 0x002661D7, 0x000000C8, 
        0x000000E4, 0x000A0AD8, 0x0C01017F, 0x86000000, 0xDA000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0x4A00006F, 0x001414B9, 0x002424F2, 0x001F20ED, 0x002122EE, 0x002526EE, 0x002B2CEF, 0x003031EF, 0x003636EE, 0x003B3CEB, 0x004142E9, 0x004647E7, 0x004848E3, 0x004546DF, 0x004344DB, 0x003F40D7, 0x003838D2, 
        0x003232CC, 0x001F1FBD, 0x000506A3, 0x000A0AA5, 0x002727BE, 0x003A3BCD, 0x004C4CD8, 0x005B5CE1, 0x00696AE7, 0x006F70EC, 0x006A6BF0, 0x006566F3, 0x006363F5, 0x003431CE, 0x000045E1, 0x000F88FF, 0x002BABFF, 0x004BDEFF, 0x0057DEF9, 0x000B1EC7, 
        0x00201CE0, 0x003535E1, 0x0A000085, 0x80000000, 0xD8000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xB8000052, 0x1102027A, 0x000E0E9D, 0x001313A5, 0x001313A7, 0x001111A5, 0x000D0D9E, 0x000B0B97, 0x00090993, 0x0106068F, 0x0204048B, 0x03010186, 0x03000081, 0x07000079, 0x0C00006E, 0x12000064, 0x1800005C, 
        0x20000052, 0x2700004C, 0x3A000035, 0x42000030, 0x36000041, 0x2B00004D, 0x1F000058, 0x15000067, 0x0B000078, 0x04020287, 0x020A0A90, 0x0111119A, 0x001C1CA5, 0x001A17A8, 0x00000DAB, 0x00086CF7, 0x001792FF, 0x0034B8FF, 0x0056F0FF, 0x0044ADE8, 
        0x003F3CCA, 0x002524D1, 0x0F000074, 0x80000000, 0xD7000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xF3000000, 0xB2000027, 0x5800003E, 0x3A000041, 0x34000040, 0x35000040, 0x3800003B, 0x3F000034, 0x4500002E, 0x4B000027, 0x52000021, 0x5B000019, 0x64000011, 0x6C00000A, 0x74000006, 0x7F000001, 0x87000000, 
        0x8F000000, 0x96000000, 0xA0000000, 0xAB000000, 0xAF000000, 0xA7000000, 0x9D000000, 0x92000001, 0x84000008, 0x73000011, 0x6100001E, 0x53000027, 0x48000030, 0x3E000038, 0x2E000050, 0x030230C5, 0x000C81FF, 0x00229FFF, 0x0040CCFF, 0x005DF5FF, 
        0x002050C7, 0x06000083, 0x3900002F, 0x8F000000, 0xDF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFD000000, 0xEE000000, 0xCF000000, 0xB4000000, 0xA9000000, 0xA7000000, 0xA7000000, 0xAB000000, 0xB0000000, 0xB4000000, 0xB9000000, 0xBF000000, 0xC5000000, 0xCA000000, 0xD0000000, 0xD6000000, 0xDA000000, 
        0xDF000000, 0xE3000000, 0xE8000000, 0xED000000, 0xEF000000, 0xEB000000, 0xE6000000, 0xE1000000, 0xDB000000, 0xD4000000, 0xCB000000, 0xC2000000, 0xBB000000, 0xB3000000, 0xAB000000, 0x3C000076, 0x00044FDF, 0x00128CFF, 0x002CADFF, 0x004BDDFF, 
        0x0056D9F6, 0x0B0D1D96, 0x5E000014, 0xB0000000, 0xEE000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFE000000, 0xF9000000, 0xF1000000, 0xEC000000, 0xEB000000, 0xEC000000, 0xED000000, 0xEF000000, 0xF2000000, 0xF4000000, 0xF7000000, 0xF9000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFB000000, 0xF8000000, 0xF5000000, 0xF2000000, 0xED000000, 0xC9000025, 0x1C000D94, 0x00086BF3, 0x001995FF, 0x0035B9FF, 
        0x0059F3FF, 0x0044A6E3, 0x35010068, 0xBC000000, 0xF3000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF7000000, 0x9000005C, 0x020232BD, 0x000C83FF, 0x0022A0FF, 
        0x0043D4FF, 0x0055DFF9, 0x20081179, 0xA7000000, 0xEA000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xED000000, 0x4F00016E, 0x000551DC, 0x00138FFF, 
        0x002DADFF, 0x001B51BD, 0x37000040, 0x9B000000, 0xE5000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0xC800003B, 0x2D000B7B, 0x05062EAD, 
        0x0E051886, 0x3000003D, 0x71000000, 0xB6000000, 0xEF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF6000000, 0xD1000000, 0x9A000000, 
        0x7E000000, 0x8A000000, 0xB2000000, 0xE2000000, 0xFB000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF5000000, 0xE2000000, 
        0xD7000000, 0xDD000000, 0xED000000, 0xFB000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF
#endif
};

GUI_CONST_STORAGE GUI_BITMAP _bmRead = {
  48, // XSize */
  48, // YSize */
  192, // BytesPerLine */
  32, // BitsPerPixel */
  (unsigned char *)_acRead,  // Pointer to picture data */
  NULL,  // Pointer to palette */
#if (GUI_USE_ARGB == 1)
  GUI_DRAW_BMPM8888I
#else
  GUI_DRAW_BMP8888
#endif
};

/*********************************************************************
*
*       _bmRemote
*
* Function description
*   Icon bitmap with alpha channel
*/
static GUI_CONST_STORAGE unsigned long _acRemote[] = {
#if (GUI_USE_ARGB == 1)
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x2A0B0B0B, 0x600A0A0A, 0x910A0A0A, 0xC30C0C0C, 
        0xE40D0D0D, 0xF30D0D0D, 0xF70E0E0E, 0xF70E0E0E, 0xF40D0D0D, 0xE50D0D0D, 0xC60B0B0B, 0x990A0A0A, 0x6A090909, 0x35070707, 0x07000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1C0B0B0B, 0x6A0B0B0B, 0xC70D0D0D, 0xF70F0F0F, 0xEB111111, 0xD7111111, 0xC1101010, 
        0xB00E0E0E, 0xA30C0C0C, 0x9F0B0B0B, 0x9F0B0B0B, 0xA40C0C0C, 0xB50D0D0D, 0xC70F0F0F, 0xDC101010, 0xEE101010, 0xF90F0F0F, 0xCE0C0C0C, 0x7B090909, 0x2B070707, 0x07000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1C0D0D0D, 0x880D0D0D, 0xED0F0F0F, 0xEC121212, 0xC2111111, 0x900B0B0B, 0x75020202, 0x6A000000, 0x64000000, 
        0x5E000000, 0x58000000, 0x52000000, 0x4F000000, 0x4F000000, 0x52000000, 0x58000000, 0x5E000000, 0x6D030303, 0x960B0B0B, 0xCD101010, 0xF0111111, 0xF10F0F0F, 0x9A0B0B0B, 0x30060606, 0x08000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x060E0E0E, 0x820E0E0E, 0xEE101010, 0xDA131313, 0x900D0D0D, 0x71030303, 0x6A000000, 0x5E000000, 0x49000000, 0x34000000, 0x25000000, 
        0x1E000000, 0x17000000, 0x13000000, 0x10000000, 0x10000000, 0x13000000, 0x17000000, 0x1E000000, 0x25000000, 0x34000000, 0x49000000, 0x68030303, 0x9E0C0C0C, 0xE3121212, 0xF1101010, 0x990B0B0B, 0x1E020202, 0x06000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x270E0E0E, 0xCE101010, 0xF5141414, 0xA0101010, 0x70020202, 0x64000000, 0x4C000000, 0x33000000, 0x1F000000, 0x0F000000, 0x04000000, 0x00000000, 
        0x0A373737, 0x12343434, 0x1F313131, 0x202F2F2F, 0x152C2C2C, 0x0D2A2A2A, 0x01000000, 0x00000000, 0x00000000, 0x04000000, 0x0F000000, 0x1F000000, 0x34000000, 0x54030303, 0xA9101010, 0xF9131313, 0xDC0E0E0E, 0x4B070707, 0x0D000000, 0x01000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4A0F0F0F, 0xED121212, 0xCB141414, 0x7D080808, 0x6E000000, 0x54000000, 0x2F000000, 0x13000000, 0x05000000, 0x0D343434, 0x54353535, 0xA2353535, 0xCD363636, 
        0xE2393939, 0xEF393939, 0xF23A3A3A, 0xF23A3A3A, 0xF0393939, 0xE4373737, 0xD1353535, 0xAA323232, 0x642C2C2C, 0x1A191919, 0x04000000, 0x01000000, 0x05000000, 0x13000000, 0x2F000000, 0x70090909, 0xD9131313, 0xF2111111, 0x72090909, 0x15000000, 
        0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6C101010, 0xF8141414, 0xB1141414, 0x6E010101, 0x64000000, 0x3E000000, 0x19000000, 0x06000000, 0x35363636, 0x98363636, 0xE13A3A3A, 0xE63B3B3B, 0xCB393939, 0xB0303030, 
        0x9E262626, 0x931F1F1F, 0x8C1A1A1A, 0x8D1A1A1A, 0x951E1E1E, 0xA1262626, 0xB72F2F2F, 0xD3373737, 0xEB3A3A3A, 0xE7393939, 0xA7313131, 0x49272727, 0x0B000000, 0x02000000, 0x06000000, 0x1A000000, 0x44020202, 0xBD131313, 0xFA131313, 0x930C0C0C, 
        0x1C000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6C121212, 0xFF151515, 0x9D131313, 0x6D000000, 0x5A000000, 0x2D000000, 0x0D000000, 0x1E343434, 0x9F393939, 0xFB3D3D3D, 0xD83D3D3D, 0x98292929, 0x6E0A0A0A, 0x65000000, 0x60000000, 
        0x57000000, 0x4E000000, 0x48000000, 0x44000000, 0x44000000, 0x48000000, 0x4E000000, 0x58000000, 0x6B0A0A0A, 0xA0272727, 0xDF393939, 0xFC3C3C3C, 0xB4313131, 0x381B1B1B, 0x0A000000, 0x03000000, 0x0D000000, 0x2D000000, 0xA3121212, 0xFF151515, 
        0x990C0C0C, 0x1F000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x48121212, 0xFB161616, 0x9E131313, 0x70000000, 0x55000000, 0x24000000, 0x07000000, 0x47383838, 0xE13D3D3D, 0xE13F3F3F, 0x94272727, 0x6F010101, 0x65000000, 0x4C000000, 0x34000000, 0x23000000, 
        0x19000000, 0x13000000, 0x0D000000, 0x0B000000, 0x0B000000, 0x0D000000, 0x13000000, 0x19000000, 0x23000000, 0x34000000, 0x4D010101, 0x9A252525, 0xE93C3C3C, 0xEB393939, 0x6C242424, 0x13000000, 0x03000000, 0x07000000, 0x24000000, 0xA0131313, 
        0xFC151515, 0x7F090909, 0x1C000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x24121212, 0xF3151515, 0xB2171717, 0x6F000000, 0x55000000, 0x21000000, 0x05000000, 0x6E3B3B3B, 0xFB3F3F3F, 0xB93A3A3A, 0x70070707, 0x6A000000, 0x4D000000, 0x2B000000, 0x13000000, 0x06000000, 0x06545454, 
        0x19606060, 0x365E5E5E, 0x475A5A5A, 0x49585858, 0x3C545454, 0x214B4B4B, 0x09383838, 0x01000000, 0x01000000, 0x06000000, 0x13000000, 0x2B000000, 0x550A0A0A, 0xC6353535, 0xFD3E3E3E, 0x942B2B2B, 0x1C000000, 0x04000000, 0x05000000, 0x21000000, 
        0xB7161616, 0xF6141414, 0x60060606, 0x14000000, 0x01000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x05131313, 0xD2151515, 0xCE191919, 0x70020202, 0x5B000000, 0x24000000, 0x05000000, 0x973D3D3D, 0xFC424242, 0x922D2D2D, 0x6D000000, 0x5D000000, 0x34000000, 0x13000000, 0x04000000, 0x39616161, 0x9D626262, 0xDA656565, 
        0xF1676767, 0xF2686868, 0xF2676767, 0xF2676767, 0xF3666666, 0xF3666666, 0xDF626262, 0xAB5A5A5A, 0x4E494949, 0x0C000000, 0x02000000, 0x04000000, 0x13000000, 0x34000000, 0x992A2A2A, 0xFD414141, 0xB6313131, 0x23000000, 0x07000000, 0x05000000, 
        0x2B050505, 0xD6181818, 0xE3131313, 0x41010101, 0x0D000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x82141414, 0xFA1B1B1B, 0x7B090909, 0x66000000, 0x2E000000, 0x07000000, 0x6F3D3D3D, 0xFF444444, 0x8B272727, 0x6F000000, 0x51000000, 0x24000000, 0x08000000, 0x2C616161, 0xBB656565, 0xF76A6A6A, 0xDE666666, 0xA94F4F4F, 
        0x90333333, 0x801F1F1F, 0x76131313, 0x75131313, 0x7F1F1F1F, 0x91323232, 0xB0494949, 0xE2636363, 0xFA686868, 0xCD5D5D5D, 0x4A3C3C3C, 0x0D000000, 0x02000000, 0x08000000, 0x24000000, 0x86282828, 0xFF434343, 0x9F2A2A2A, 0x24000000, 0x04000000, 
        0x07000000, 0x4C0F0F0F, 0xFC1A1A1A, 0xB20E0E0E, 0x2D000000, 0x06000000, 0x00000000,
  0x00000000, 0x00000000, 0x17141414, 0xF7191919, 0xA0151515, 0x70000000, 0x3E000000, 0x0D000000, 0x443D3D3D, 0xFF434343, 0x922F2F2F, 0x70000000, 0x4E000000, 0x1C000000, 0x04000000, 0x71666666, 0xF46A6A6A, 0xCE676767, 0x8B373737, 0x70040404, 0x68000000, 
        0x57000000, 0x46000000, 0x3B000000, 0x35000000, 0x35000000, 0x3B000000, 0x46000000, 0x58040404, 0x8F333333, 0xD95F5F5F, 0xF8676767, 0x944F4F4F, 0x19000000, 0x05000000, 0x04000000, 0x1C000000, 0x902F2F2F, 0xFF424242, 0x7F202020, 0x1C000000, 
        0x03000000, 0x0D000000, 0x95171717, 0xFA171717, 0x64040404, 0x19000000, 0x01000000,
  0x00000000, 0x00000000, 0x89161616, 0xDE1C1C1C, 0x73030303, 0x55000000, 0x19000000, 0x1B3C3C3C, 0xE7424242, 0xBA3E3E3E, 0x6E000000, 0x52000000, 0x1C000000, 0x0F4E4E4E, 0xA2676767, 0xF46D6D6D, 0x9F515151, 0x6D020202, 0x65000000, 0x49000000, 0x2B000000, 
        0x19000000, 0x0D000000, 0x07000000, 0x04000000, 0x04000000, 0x07000000, 0x0D000000, 0x18000000, 0x2B000000, 0x49010101, 0xA74A4A4A, 0xF76A6A6A, 0xBE585858, 0x2E191919, 0x08000000, 0x04000000, 0x1C000000, 0xBE3C3C3C, 0xF03F3F3F, 0x59121212, 
        0x13000000, 0x02000000, 0x240A0A0A, 0xE41A1A1A, 0xB7101010, 0x37000000, 0x07000000,
  0x00000000, 0x1A161616, 0xF21B1B1B, 0x8F131313, 0x66000000, 0x2F000000, 0x06000000, 0xA2414141, 0xE9474747, 0x70060606, 0x5E000000, 0x24000000, 0x04000000, 0xA4696969, 0xF3707070, 0x81343434, 0x6D000000, 0x53000000, 0x2B000000, 0x10000000, 0x03000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x0F000000, 0x2A000000, 0x79363636, 0xF76D6D6D, 0xC4585858, 0x2B000000, 0x08000000, 0x04000000, 0x2C0F0F0F, 0xED454545, 0xC7333333, 
        0x36000000, 0x0A000000, 0x06000000, 0x77171717, 0xF6191919, 0x65060606, 0x1A000000,
  0x00000000, 0x6A171717, 0xF01E1E1E, 0x71040404, 0x4D000000, 0x13000000, 0x32404040, 0xFF474747, 0x932C2C2C, 0x6C000000, 0x34000000, 0x08000000, 0x706A6A6A, 0xF8717171, 0x82353535, 0x6D000000, 0x47000000, 0x1B000000, 0x05000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x05000000, 0x1B000000, 0x703B3B3B, 0xFA6E6E6E, 0xA44A4A4A, 0x25000000, 0x05000000, 0x08000000, 0x77353535, 0xFF464646, 
        0x7C191919, 0x20000000, 0x02000000, 0x1F0E0E0E, 0xF21C1C1C, 0xA40F0F0F, 0x35000000,
  0x01191919, 0xCA1A1A1A, 0xC31D1D1D, 0x6B000000, 0x34000000, 0x05000000, 0x9A434343, 0xDC484848, 0x70000000, 0x4E000000, 0x13000000, 0x29696969, 0xFD717171, 0x9F545454, 0x6F000000, 0x48000000, 0x16000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x16000000, 0x97565656, 0xFE707070, 0x6E282828, 0x1A000000, 0x02000000, 0x13000000, 0xDE464646, 
        0xC4333333, 0x40000000, 0x0B000000, 0x05000000, 0xBB1D1D1D, 0xDC171717, 0x51000000,
  0x28191919, 0xFB1E1E1E, 0x91131313, 0x5F000000, 0x1F000000, 0x0B3F3F3F, 0xE6484848, 0x97313131, 0x66000000, 0x2B000000, 0x04000000, 0xBD6E6E6E, 0xD26F6F6F, 0x70040404, 0x55000000, 0x1C000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x035C0000, 0x0E530000, 0x0E530000, 0x04450000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x1E0C0C0C, 0xD5696969, 0xDA616161, 0x3F000000, 0x0D000000, 0x04000000, 0x7B3D3D3D, 
        0xEE454545, 0x60070707, 0x1C000000, 0x01000000, 0x5F1A1A1A, 0xFC1D1D1D, 0x7D080808,
  0x611A1A1A, 0xED202020, 0x74040404, 0x49000000, 0x0F000000, 0x53444444, 0xE94A4A4A, 0x6C090909, 0x4D000000, 0x13000000, 0x376D6D6D, 0xFF767676, 0x89383838, 0x67000000, 0x2C000000, 0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x065D0000, 
        0x74570000, 0xC9670000, 0xEC820000, 0xED7E0000, 0xCF610000, 0x854C0000, 0x1A150000, 0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x05000000, 0x5F505050, 0xFF747474, 0x842E2E2E, 0x25000000, 0x02000000, 0x1E1F1F1F, 
        0xEC484848, 0x95252525, 0x30000000, 0x04000000, 0x1B111111, 0xEF1F1F1F, 0xA10F0F0F,
  0x921C1C1C, 0xD8212121, 0x6A000000, 0x33000000, 0x04000000, 0xA4464646, 0xCC474747, 0x66000000, 0x34000000, 0x05000000, 0xA06F6F6F, 0xE0747474, 0x72040404, 0x49000000, 0x0F000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x055D0000, 0xAC5E0001, 
        0xFFAE0B01, 0xFFEA1200, 0xFFFC0B02, 0xFFF50000, 0xFFD70000, 0xFF990000, 0xC5520000, 0x2C0B0000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x12141414, 0xE0717171, 0xC8595959, 0x43000000, 0x0C000000, 0x05000000, 
        0xC6484848, 0xC5393939, 0x47000000, 0x0F000000, 0x04000000, 0xD2212121, 0xB9141414,
  0xC61E1E1E, 0xC11F1F1F, 0x64000000, 0x25000000, 0x014A4A4A, 0xCF494949, 0xB03E3E3E, 0x61000000, 0x23000000, 0x06626262, 0xDC747474, 0xA7585858, 0x69000000, 0x2B000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8E590000, 0xFFB80E01, 
        0xFFFF4B2F, 0xFFFF7158, 0xFFFB2F15, 0xFFFE0500, 0xFFF10000, 0xFFDD0000, 0xFF910000, 0xBB450000, 0x2A000000, 0x07000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x8B676767, 0xE96E6E6E, 0x5F060606, 0x1C000000, 0x01000000, 
        0x96484848, 0xDE434343, 0x5B010101, 0x1C000000, 0x00000000, 0xB0222222, 0xCE191919,
  0xE6202020, 0xB11C1C1C, 0x5F000000, 0x1E000000, 0x0A4B4B4B, 0xE44C4C4C, 0x9E323232, 0x58000000, 0x19000000, 0x1A717171, 0xF2797979, 0x8E3A3A3A, 0x57000000, 0x18000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x22560000, 0xF6870000, 0xFFFC1401, 
        0xFFFC765C, 0xFFFCBAAD, 0xFFF94427, 0xFFFD0800, 0xFFF10000, 0xFFDB0000, 0xFFAD0000, 0xFB640000, 0x731A0000, 0x1C000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x53636363, 0xF4777777, 0x76181818, 0x2A000000, 0x01000000, 
        0x70464646, 0xEA494949, 0x69070707, 0x25000000, 0x00000000, 0x90222222, 0xDB1D1D1D,
  0xF3232323, 0xA3181818, 0x59000000, 0x17000000, 0x11474747, 0xEF4F4F4F, 0x93292929, 0x4E000000, 0x12000000, 0x36707070, 0xF27C7C7C, 0x7F232323, 0x46000000, 0x0D000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6C540000, 0xFFB80000, 0xFFFF0C02, 
        0xFFFA3116, 0xFFF94427, 0xFFFB200B, 0xFFFC0400, 0xFFEC0000, 0xFFD70000, 0xFFA50000, 0xFF690000, 0xBA340000, 0x39000000, 0x07000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x2F616161, 0xF3797979, 0x882C2C2C, 0x35000000, 0x04000000, 
        0x56474747, 0xF24C4C4C, 0x710B0B0B, 0x2C000000, 0x01000000, 0x74232323, 0xDE1F1F1F,
  0xF8242424, 0x9F171717, 0x53000000, 0x13000000, 0x1F454545, 0xF2505050, 0x8C242424, 0x48000000, 0x0D000000, 0x496E6E6E, 0xF27D7D7D, 0x76151515, 0x3B000000, 0x07000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x89560000, 0xFFBA0000, 0xFFFD0101, 
        0xFFFD0800, 0xFFFD0B00, 0xFFFD0501, 0xFFF20000, 0xFFE20000, 0xFFCA0000, 0xFF910000, 0xFF600000, 0xD03A0000, 0x52000000, 0x11000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1A636363, 0xF27C7C7C, 0x91363636, 0x3E000000, 0x09000000, 
        0x46484848, 0xF44E4E4E, 0x79121212, 0x32000000, 0x03000000, 0x69242424, 0xDF212121,
  0xF8252525, 0xA0181818, 0x4F000000, 0x10000000, 0x20444444, 0xF2525252, 0x8D252525, 0x44000000, 0x0B000000, 0x4A6D6D6D, 0xF27E7E7E, 0x75161616, 0x35000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x694D0000, 0xFFA10000, 0xFFED0000, 
        0xFFEE0000, 0xFFF00000, 0xFFEC0000, 0xFFE10000, 0xFFD00000, 0xFFAA0000, 0xFF730000, 0xFF5D0000, 0xC52C0000, 0x5A000000, 0x15000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x186D6D6D, 0xF27D7D7D, 0x90373737, 0x43000000, 0x0B000000, 
        0x444C4C4C, 0xF3505050, 0x7A121212, 0x36000000, 0x04000000, 0x68252525, 0xDE222222,
  0xF4262626, 0xA51A1A1A, 0x4F000000, 0x10000000, 0x14404040, 0xF0535353, 0x952B2B2B, 0x44000000, 0x0B000000, 0x3B696969, 0xF3808080, 0x7E262626, 0x35000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x23370000, 0xF06E0000, 0xFFC90000, 
        0xFFDA0000, 0xFFDA0000, 0xFFD60000, 0xFFC70000, 0xFFA90000, 0xFF7D0000, 0xFF5F0000, 0xF9580000, 0xA50C0000, 0x4E000000, 0x0F000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x277A7A7A, 0xF27E7E7E, 0x872E2E2E, 0x43000000, 0x0B000000, 
        0x514F4F4F, 0xF1505050, 0x730B0B0B, 0x36000000, 0x04000000, 0x70272727, 0xDC232323,
  0xE7252525, 0xB51F1F1F, 0x53000000, 0x13000000, 0x0D3F3F3F, 0xE5525252, 0xA1353535, 0x48000000, 0x0D000000, 0x1F616161, 0xF4808080, 0x913D3D3D, 0x3B000000, 0x07000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x06000000, 0x93490000, 0xFF820000, 
        0xFFAE0000, 0xFFB00000, 0xFFA80000, 0xFF920000, 0xFF730000, 0xFF600000, 0xFF5E0000, 0xD8340000, 0x85000000, 0x34000000, 0x06000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x457C7C7C, 0xF37F7F7F, 0x79191919, 0x3E000000, 0x09000000, 
        0x68525252, 0xE8505050, 0x6F070707, 0x32000000, 0x03000000, 0x8A292929, 0xD7222222,
  0xC8242424, 0xC7252525, 0x58000000, 0x17000000, 0x02292929, 0xD2505050, 0xB6434343, 0x4E000000, 0x12000000, 0x09474747, 0xE17D7D7D, 0xB05D5D5D, 0x46000000, 0x0D000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x1A080000, 0xB2490000, 
        0xFC690000, 0xFF720000, 0xFF6D0000, 0xFF630000, 0xFF5D0000, 0xFD5C0000, 0xDE3B0000, 0x9B010000, 0x57000000, 0x18000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7B7F7F7F, 0xE47B7B7B, 0x6D060606, 0x35000000, 0x04000000, 
        0x8E545454, 0xDA4C4C4C, 0x68010101, 0x2C000000, 0x01000000, 0xAB2A2A2A, 0xCA202020,
  0x9A222222, 0xDC282828, 0x5F000000, 0x1E000000, 0x00000000, 0xAC4D4D4D, 0xD4505050, 0x58000000, 0x19000000, 0x01000000, 0xAB767676, 0xE77F7F7F, 0x5B060606, 0x19000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x05000000, 0x24000000, 
        0x9C390000, 0xFF640000, 0xFF6A0000, 0xFF610000, 0xFF5F0000, 0xD32B0000, 0x97000000, 0x5F000000, 0x24000000, 0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x038B8B8B, 0xD7858585, 0xBE6B6B6B, 0x67000000, 0x2A000000, 0x01000000, 
        0xBF575757, 0xBF454545, 0x63000000, 0x25000000, 0x00000000, 0xCE2A2A2A, 0xB41C1C1C,
  0x6B202020, 0xF02C2C2C, 0x6C060606, 0x25000000, 0x00000000, 0x63444444, 0xEE575757, 0x680B0B0B, 0x23000000, 0x01000000, 0x495C5C5C, 0xFE888888, 0x90404040, 0x2C000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x06000000, 
        0x6A470000, 0xFF6E0000, 0xFF780000, 0xFF6A0000, 0xFF610000, 0xC4260000, 0x67000000, 0x25000000, 0x06000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x41898989, 0xFF878787, 0x89333333, 0x5C000000, 0x1C000000, 0x0D575757, 
        0xE8595959, 0x932D2D2D, 0x5A000000, 0x1C000000, 0x0C2F2F2F, 0xEA2B2B2B, 0x9D151515,
  0x351C1C1C, 0xFB2C2C2C, 0x95181818, 0x34000000, 0x04000000, 0x18232323, 0xEB575757, 0xA03A3A3A, 0x34000000, 0x05000000, 0x0C000000, 0xCB797979, 0xDE7D7D7D, 0x4F0F0F0F, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x7E570000, 0xFF790000, 0xFF820000, 0xFF750000, 0xFF670000, 0xCC350000, 0x52000000, 0x11000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x078F8F8F, 0xC68A8A8A, 0xD0787878, 0x70000000, 0x43000000, 0x0C000000, 0x635C5C5C, 
        0xE9565656, 0x6C080808, 0x47000000, 0x0F000000, 0x4A2F2F2F, 0xFA2A2A2A, 0x810C0C0C,
  0x08050505, 0xD0272727, 0xCE292929, 0x49000000, 0x0F000000, 0x04000000, 0xA94E4E4E, 0xE3585858, 0x4D000000, 0x13000000, 0x02000000, 0x454B4B4B, 0xFC8A8A8A, 0x9F565656, 0x2B000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0xA65C0000, 0xFF8B0000, 0xFF8B0000, 0xFF7F0000, 0xFF710000, 0xDD440000, 0x5B000000, 0x16000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x618B8B8B, 0xFC888888, 0x7F2B2B2B, 0x62000000, 0x25000000, 0x02000000, 0xD45D5D5D, 
        0xB5474747, 0x65000000, 0x30000000, 0x04000000, 0xAC303030, 0xD6262626, 0x6E000000,
  0x01000000, 0x7B222222, 0xF4303030, 0x69070707, 0x1F000000, 0x01000000, 0x473B3B3B, 0xFF5E5E5E, 0x9A373737, 0x2B000000, 0x04000000, 0x0C000000, 0x825F5F5F, 0x7E323232, 0x3B000000, 0x0B000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x035E0000, 
        0xD1630000, 0xFF9A0000, 0xFF940000, 0xFF880000, 0xFF7C0000, 0xEE530000, 0x6D030000, 0x1E000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x38747474, 0x83616161, 0x61000000, 0x3E000000, 0x0D000000, 0x585F5F5F, 0xFF5C5C5C, 
        0x841F1F1F, 0x5A000000, 0x1C000000, 0x0E2F2F2F, 0xEE2F2F2F, 0x9F191919, 0x65000000,
  0x00000000, 0x29181818, 0xF52D2D2D, 0x9E1E1E1E, 0x34000000, 0x05000000, 0x0B000000, 0xB64E4E4E, 0xEF5E5E5E, 0x550B0B0B, 0x13000000, 0x02000000, 0x17000000, 0x33000000, 0x25000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x15580000, 
        0xF26F0000, 0xFFA60000, 0xFF9D0000, 0xFF920000, 0xFF860000, 0xFA620000, 0x860E0000, 0x28000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08000000, 0x25000000, 0x34000000, 0x18000000, 0x0B525252, 0xE5606060, 0xBC4B4B4B, 
        0x70000000, 0x40000000, 0x0B000000, 0x59323232, 0xF42C2C2C, 0x7A090909, 0x51000000,
  0x00000000, 0x07000000, 0x9B242424, 0xE6303030, 0x55070707, 0x13000000, 0x02000000, 0x362A2A2A, 0xEF5A5A5A, 0xC7515151, 0x34000000, 0x08000000, 0x04000000, 0x0A000000, 0x08000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x34550000, 
        0xFB7D0000, 0xFFB30000, 0xFFA70000, 0xFF9C0000, 0xFF920000, 0xFE6B0000, 0xA11C0000, 0x34000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x08000000, 0x0A000000, 0x04000000, 0xA2636363, 0xEA5B5B5B, 0x7A131313, 
        0x5E000000, 0x20000000, 0x0C2C2C2C, 0xD8323232, 0xAA222222, 0x69000000, 0x36000000,
  0x00000000, 0x01000000, 0x2D141414, 0xF9303030, 0xAA252525, 0x30000000, 0x06000000, 0x0A000000, 0x6A393939, 0xFF626262, 0x9E434343, 0x24000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x56520000, 
        0xFF8B0000, 0xFFC10000, 0xFFB10000, 0xFFA60000, 0xFF9E0000, 0xFF760000, 0xB7270000, 0x40000000, 0x09000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x67666666, 0xFF606060, 0x882C2C2C, 0x6B000000, 
        0x36000000, 0x0A000000, 0x74343434, 0xF8303030, 0x73080808, 0x56000000, 0x1B000000,
  0x00000000, 0x00000000, 0x07000000, 0x99252525, 0xFC353535, 0x6E131313, 0x1A000000, 0x02000000, 0x13000000, 0x9A464646, 0xC9515151, 0x47020202, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x74540000, 
        0xFFA40B0B, 0xFFCD0303, 0xFFB90000, 0xFFAF0000, 0xFFA80000, 0xFF830000, 0xC7310000, 0x4D000000, 0x0E000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01666666, 0xA85F5F5F, 0x9A454545, 0x6B000000, 0x47000000, 
        0x13000000, 0x24363636, 0xFA343434, 0xAA212121, 0x6D000000, 0x37000000, 0x08000000,
  0x00000000, 0x00000000, 0x01000000, 0x1E080808, 0xDF2D2D2D, 0xDC313131, 0x45070707, 0x0D000000, 0x03000000, 0x1C000000, 0x4D0E0E0E, 0x3F000000, 0x14000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x92590000, 
        0xFFCA2929, 0xFFDB1616, 0xFFC20000, 0xFFB90000, 0xFFB10000, 0xFF950000, 0xD43D0000, 0x58000000, 0x14000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1E222222, 0x40000000, 0x45000000, 0x1C000000, 
        0x0A282828, 0xC2363636, 0xDC2D2D2D, 0x73020202, 0x56000000, 0x19000000, 0x01000000,
  0x00000000, 0x00000000, 0x00000000, 0x06000000, 0x48151515, 0xF6323232, 0xBF2E2E2E, 0x2E000000, 0x07000000, 0x05000000, 0x13000000, 0x16000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xB1620000, 
        0xFFEA4141, 0xFFEC3636, 0xFFCD0000, 0xFFC30000, 0xFFBA0000, 0xFFA90000, 0xE24B0000, 0x63000000, 0x19000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08000000, 0x16000000, 0x13000000, 0x05000000, 
        0x96393939, 0xF4323232, 0x7B0D0D0D, 0x67000000, 0x2D000000, 0x06000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0D000000, 0x711D1D1D, 0xFC363636, 0xA42A2A2A, 0x27030303, 0x05000000, 0x00000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x035A0000, 0xCC750000, 
        0xFFF85555, 0xFFF54646, 0xFFD70000, 0xFFCD0000, 0xFFC30000, 0xFFB60000, 0xED5B0000, 0x70030000, 0x1F000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x023B3B3B, 0x743A3A3A, 
        0xFB353535, 0x88181818, 0x6C000000, 0x3D000000, 0x0D000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x14000000, 0x95242424, 0xFE383838, 0x781B1B1B, 0x1C000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0B500000, 0xE68B0303, 
        0xFFFF6969, 0xFFFC4A4A, 0xFFE20000, 0xFFD60000, 0xFFCD0000, 0xFFC20000, 0xF6700000, 0x7F070000, 0x26000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x393A3A3A, 0xFE373737, 
        0x9B222222, 0x6F000000, 0x49000000, 0x15000000, 0x01000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x1C000000, 0x831D1D1D, 0x680A0A0A, 0x2C000000, 0x06000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x29510000, 0xF9A00C0C, 
        0xFFFF7C7C, 0xFFFF4C4C, 0xFFED0202, 0xFFE00000, 0xFFD70000, 0xFFD10000, 0xFD850000, 0x99160000, 0x2F000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x18282828, 0x6A242424, 
        0x5D000000, 0x4F000000, 0x1C000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x1C000000, 0x2E000000, 0x1B000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5B500000, 0xFFB41C1C, 
        0xFFFF8181, 0xFFFF4949, 0xFFF80909, 0xFFEB0000, 0xFFE10000, 0xFFDD0000, 0xFF990000, 0xB7290000, 0x3D000000, 0x07000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x1B000000, 
        0x2E000000, 0x1C000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x07000000, 0x04000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x88560000, 0xFFC72D2D, 
        0xFFFF8181, 0xFFFF4545, 0xFFFE0C0C, 0xFFF50000, 0xFFEA0000, 0xFFE60000, 0xFFAC0000, 0xCF390000, 0x4F000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x04000000, 
        0x07000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xA75B0000, 0xFFD83E3E, 
        0xFFFF8181, 0xFFFF3E3E, 0xFFFF0A0A, 0xFFFD0000, 0xFFF40000, 0xFFEE0000, 0xFFC00000, 0xDD440000, 0x5E000000, 0x17000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x015C0000, 0xC5610000, 0xFFED5050, 
        0xFFFF8181, 0xFFFF3838, 0xFFFF0606, 0xFFFF0000, 0xFFFE0000, 0xFFF90000, 0xFFDA0000, 0xEA510000, 0x6B010000, 0x1D000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x095A0000, 0xE4750000, 0xFFFF6666, 
        0xFFFF7E7E, 0xFFFF3333, 0xFFFF0404, 0xFFFF0000, 0xFFFF0000, 0xFFFF0000, 0xFFF20000, 0xF5690000, 0x7C070000, 0x24000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1D590000, 0xE96C0000, 0xF8992B2B, 
        0xFB962B2B, 0xFB911010, 0xFB900101, 0xFB900000, 0xFB900000, 0xFB900000, 0xFB8F0000, 0xF7650000, 0x90120000, 0x2C000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000
#else
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xD50B0B0B, 0x9F0A0A0A, 0x6E0A0A0A, 0x3C0C0C0C, 
        0x1B0D0D0D, 0x0C0D0D0D, 0x080E0E0E, 0x080E0E0E, 0x0B0D0D0D, 0x1A0D0D0D, 0x390B0B0B, 0x660A0A0A, 0x95090909, 0xCA070707, 0xF8000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE30B0B0B, 0x950B0B0B, 0x380D0D0D, 0x080F0F0F, 0x14111111, 0x28111111, 0x3E101010, 
        0x4F0E0E0E, 0x5C0C0C0C, 0x600B0B0B, 0x600B0B0B, 0x5B0C0C0C, 0x4A0D0D0D, 0x380F0F0F, 0x23101010, 0x11101010, 0x060F0F0F, 0x310C0C0C, 0x84090909, 0xD4070707, 0xF8000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE30D0D0D, 0x770D0D0D, 0x120F0F0F, 0x13121212, 0x3D111111, 0x6F0B0B0B, 0x8A020202, 0x95000000, 0x9B000000, 
        0xA1000000, 0xA7000000, 0xAD000000, 0xB0000000, 0xB0000000, 0xAD000000, 0xA7000000, 0xA1000000, 0x92030303, 0x690B0B0B, 0x32101010, 0x0F111111, 0x0E0F0F0F, 0x650B0B0B, 0xCF060606, 0xF7000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF90E0E0E, 0x7D0E0E0E, 0x11101010, 0x25131313, 0x6F0D0D0D, 0x8E030303, 0x95000000, 0xA1000000, 0xB6000000, 0xCB000000, 0xDA000000, 
        0xE1000000, 0xE8000000, 0xEC000000, 0xEF000000, 0xEF000000, 0xEC000000, 0xE8000000, 0xE1000000, 0xDA000000, 0xCB000000, 0xB6000000, 0x97030303, 0x610C0C0C, 0x1C121212, 0x0E101010, 0x660B0B0B, 0xE1020202, 0xF9000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xD80E0E0E, 0x31101010, 0x0A141414, 0x5F101010, 0x8F020202, 0x9B000000, 0xB3000000, 0xCC000000, 0xE0000000, 0xF0000000, 0xFB000000, 0xFF000000, 
        0xF5373737, 0xED343434, 0xE0313131, 0xDF2F2F2F, 0xEA2C2C2C, 0xF22A2A2A, 0xFE000000, 0xFF000000, 0xFF000000, 0xFB000000, 0xF0000000, 0xE0000000, 0xCB000000, 0xAB030303, 0x56101010, 0x06131313, 0x230E0E0E, 0xB4070707, 0xF2000000, 0xFE000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xB50F0F0F, 0x12121212, 0x34141414, 0x82080808, 0x91000000, 0xAB000000, 0xD0000000, 0xEC000000, 0xFA000000, 0xF2343434, 0xAB353535, 0x5D353535, 0x32363636, 
        0x1D393939, 0x10393939, 0x0D3A3A3A, 0x0D3A3A3A, 0x0F393939, 0x1B373737, 0x2E353535, 0x55323232, 0x9B2C2C2C, 0xE5191919, 0xFB000000, 0xFE000000, 0xFA000000, 0xEC000000, 0xD0000000, 0x8F090909, 0x26131313, 0x0D111111, 0x8D090909, 0xEA000000, 
        0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x93101010, 0x07141414, 0x4E141414, 0x91010101, 0x9B000000, 0xC1000000, 0xE6000000, 0xF9000000, 0xCA363636, 0x67363636, 0x1E3A3A3A, 0x193B3B3B, 0x34393939, 0x4F303030, 
        0x61262626, 0x6C1F1F1F, 0x731A1A1A, 0x721A1A1A, 0x6A1E1E1E, 0x5E262626, 0x482F2F2F, 0x2C373737, 0x143A3A3A, 0x18393939, 0x58313131, 0xB6272727, 0xF4000000, 0xFD000000, 0xF9000000, 0xE5000000, 0xBB020202, 0x42131313, 0x05131313, 0x6C0C0C0C, 
        0xE3000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x93121212, 0x00151515, 0x62131313, 0x92000000, 0xA5000000, 0xD2000000, 0xF2000000, 0xE1343434, 0x60393939, 0x043D3D3D, 0x273D3D3D, 0x67292929, 0x910A0A0A, 0x9A000000, 0x9F000000, 
        0xA8000000, 0xB1000000, 0xB7000000, 0xBB000000, 0xBB000000, 0xB7000000, 0xB1000000, 0xA7000000, 0x940A0A0A, 0x5F272727, 0x20393939, 0x033C3C3C, 0x4B313131, 0xC71B1B1B, 0xF5000000, 0xFC000000, 0xF2000000, 0xD2000000, 0x5C121212, 0x00151515, 
        0x660C0C0C, 0xE0000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xB7121212, 0x04161616, 0x61131313, 0x8F000000, 0xAA000000, 0xDB000000, 0xF8000000, 0xB8383838, 0x1E3D3D3D, 0x1E3F3F3F, 0x6B272727, 0x90010101, 0x9A000000, 0xB3000000, 0xCB000000, 0xDC000000, 
        0xE6000000, 0xEC000000, 0xF2000000, 0xF4000000, 0xF4000000, 0xF2000000, 0xEC000000, 0xE6000000, 0xDC000000, 0xCB000000, 0xB2010101, 0x65252525, 0x163C3C3C, 0x14393939, 0x93242424, 0xEC000000, 0xFC000000, 0xF8000000, 0xDB000000, 0x5F131313, 
        0x03151515, 0x80090909, 0xE3000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDB121212, 0x0C151515, 0x4D171717, 0x90000000, 0xAA000000, 0xDE000000, 0xFA000000, 0x913B3B3B, 0x043F3F3F, 0x463A3A3A, 0x8F070707, 0x95000000, 0xB2000000, 0xD4000000, 0xEC000000, 0xF9000000, 0xF9545454, 
        0xE6606060, 0xC95E5E5E, 0xB85A5A5A, 0xB6585858, 0xC3545454, 0xDE4B4B4B, 0xF6383838, 0xFE000000, 0xFE000000, 0xF9000000, 0xEC000000, 0xD4000000, 0xAA0A0A0A, 0x39353535, 0x023E3E3E, 0x6B2B2B2B, 0xE3000000, 0xFB000000, 0xFA000000, 0xDE000000, 
        0x48161616, 0x09141414, 0x9F060606, 0xEB000000, 0xFE000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFA131313, 0x2D151515, 0x31191919, 0x8F020202, 0xA4000000, 0xDB000000, 0xFA000000, 0x683D3D3D, 0x03424242, 0x6D2D2D2D, 0x92000000, 0xA2000000, 0xCB000000, 0xEC000000, 0xFB000000, 0xC6616161, 0x62626262, 0x25656565, 
        0x0E676767, 0x0D686868, 0x0D676767, 0x0D676767, 0x0C666666, 0x0C666666, 0x20626262, 0x545A5A5A, 0xB1494949, 0xF3000000, 0xFD000000, 0xFB000000, 0xEC000000, 0xCB000000, 0x662A2A2A, 0x02414141, 0x49313131, 0xDC000000, 0xF8000000, 0xFA000000, 
        0xD4050505, 0x29181818, 0x1C131313, 0xBE010101, 0xF2000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x7D141414, 0x051B1B1B, 0x84090909, 0x99000000, 0xD1000000, 0xF8000000, 0x903D3D3D, 0x00444444, 0x74272727, 0x90000000, 0xAE000000, 0xDB000000, 0xF7000000, 0xD3616161, 0x44656565, 0x086A6A6A, 0x21666666, 0x564F4F4F, 
        0x6F333333, 0x7F1F1F1F, 0x89131313, 0x8A131313, 0x801F1F1F, 0x6E323232, 0x4F494949, 0x1D636363, 0x05686868, 0x325D5D5D, 0xB53C3C3C, 0xF2000000, 0xFD000000, 0xF7000000, 0xDB000000, 0x79282828, 0x00434343, 0x602A2A2A, 0xDB000000, 0xFB000000, 
        0xF8000000, 0xB30F0F0F, 0x031A1A1A, 0x4D0E0E0E, 0xD2000000, 0xF9000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xE8141414, 0x08191919, 0x5F151515, 0x8F000000, 0xC1000000, 0xF2000000, 0xBB3D3D3D, 0x00434343, 0x6D2F2F2F, 0x8F000000, 0xB1000000, 0xE3000000, 0xFB000000, 0x8E666666, 0x0B6A6A6A, 0x31676767, 0x74373737, 0x8F040404, 0x97000000, 
        0xA8000000, 0xB9000000, 0xC4000000, 0xCA000000, 0xCA000000, 0xC4000000, 0xB9000000, 0xA7040404, 0x70333333, 0x265F5F5F, 0x07676767, 0x6B4F4F4F, 0xE6000000, 0xFA000000, 0xFB000000, 0xE3000000, 0x6F2F2F2F, 0x00424242, 0x80202020, 0xE3000000, 
        0xFC000000, 0xF2000000, 0x6A171717, 0x05171717, 0x9B040404, 0xE6000000, 0xFE000000,
  0xFF000000, 0xFF000000, 0x76161616, 0x211C1C1C, 0x8C030303, 0xAA000000, 0xE6000000, 0xE43C3C3C, 0x18424242, 0x453E3E3E, 0x91000000, 0xAD000000, 0xE3000000, 0xF04E4E4E, 0x5D676767, 0x0B6D6D6D, 0x60515151, 0x92020202, 0x9A000000, 0xB6000000, 0xD4000000, 
        0xE6000000, 0xF2000000, 0xF8000000, 0xFB000000, 0xFB000000, 0xF8000000, 0xF2000000, 0xE7000000, 0xD4000000, 0xB6010101, 0x584A4A4A, 0x086A6A6A, 0x41585858, 0xD1191919, 0xF7000000, 0xFB000000, 0xE3000000, 0x413C3C3C, 0x0F3F3F3F, 0xA6121212, 
        0xEC000000, 0xFD000000, 0xDB0A0A0A, 0x1B1A1A1A, 0x48101010, 0xC8000000, 0xF8000000,
  0xFF000000, 0xE5161616, 0x0D1B1B1B, 0x70131313, 0x99000000, 0xD0000000, 0xF9000000, 0x5D414141, 0x16474747, 0x8F060606, 0xA1000000, 0xDB000000, 0xFB000000, 0x5B696969, 0x0C707070, 0x7E343434, 0x92000000, 0xAC000000, 0xD4000000, 0xEF000000, 0xFC000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0xF0000000, 0xD5000000, 0x86363636, 0x086D6D6D, 0x3B585858, 0xD4000000, 0xF7000000, 0xFB000000, 0xD30F0F0F, 0x12454545, 0x38333333, 
        0xC9000000, 0xF5000000, 0xF9000000, 0x88171717, 0x09191919, 0x9A060606, 0xE5000000,
  0xFF000000, 0x95171717, 0x0F1E1E1E, 0x8E040404, 0xB2000000, 0xEC000000, 0xCD404040, 0x00474747, 0x6C2C2C2C, 0x93000000, 0xCB000000, 0xF7000000, 0x8F6A6A6A, 0x07717171, 0x7D353535, 0x92000000, 0xB8000000, 0xE4000000, 0xFA000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFA000000, 0xE4000000, 0x8F3B3B3B, 0x056E6E6E, 0x5B4A4A4A, 0xDA000000, 0xFA000000, 0xF7000000, 0x88353535, 0x00464646, 
        0x83191919, 0xDF000000, 0xFD000000, 0xE00E0E0E, 0x0D1C1C1C, 0x5B0F0F0F, 0xCA000000,
  0xFE191919, 0x351A1A1A, 0x3C1D1D1D, 0x94000000, 0xCB000000, 0xFA000000, 0x65434343, 0x23484848, 0x8F000000, 0xB1000000, 0xEC000000, 0xD6696969, 0x02717171, 0x60545454, 0x90000000, 0xB7000000, 0xE9000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xE9000000, 0x68565656, 0x01707070, 0x91282828, 0xE5000000, 0xFD000000, 0xEC000000, 0x21464646, 
        0x3B333333, 0xBF000000, 0xF4000000, 0xFA000000, 0x441D1D1D, 0x23171717, 0xAE000000,
  0xD7191919, 0x041E1E1E, 0x6E131313, 0xA0000000, 0xE0000000, 0xF43F3F3F, 0x19484848, 0x68313131, 0x99000000, 0xD4000000, 0xFB000000, 0x426E6E6E, 0x2D6F6F6F, 0x8F040404, 0xAA000000, 0xE3000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFC00005C, 0xF1000053, 0xF1000053, 0xFB000045, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xE10C0C0C, 0x2A696969, 0x25616161, 0xC0000000, 0xF2000000, 0xFB000000, 0x843D3D3D, 
        0x11454545, 0x9F070707, 0xE3000000, 0xFE000000, 0xA01A1A1A, 0x031D1D1D, 0x82080808,
  0x9E1A1A1A, 0x12202020, 0x8B040404, 0xB6000000, 0xF0000000, 0xAC444444, 0x164A4A4A, 0x93090909, 0xB2000000, 0xEC000000, 0xC86D6D6D, 0x00767676, 0x76383838, 0x98000000, 0xD3000000, 0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF900005D, 
        0x8B000057, 0x36000067, 0x13000082, 0x1200007E, 0x30000061, 0x7A00004C, 0xE5000015, 0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFA000000, 0xA0505050, 0x00747474, 0x7B2E2E2E, 0xDA000000, 0xFD000000, 0xE11F1F1F, 
        0x13484848, 0x6A252525, 0xCF000000, 0xFB000000, 0xE4111111, 0x101F1F1F, 0x5E0F0F0F,
  0x6D1C1C1C, 0x27212121, 0x95000000, 0xCC000000, 0xFB000000, 0x5B464646, 0x33474747, 0x99000000, 0xCB000000, 0xFA000000, 0x5F6F6F6F, 0x1F747474, 0x8D040404, 0xB6000000, 0xF0000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFA00005D, 0x5301005E, 
        0x00010BAE, 0x000012EA, 0x00020BFC, 0x000000F5, 0x000000D7, 0x00000099, 0x3A000052, 0xD300000B, 0xF7000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xED141414, 0x1F717171, 0x37595959, 0xBC000000, 0xF3000000, 0xFA000000, 
        0x39484848, 0x3A393939, 0xB8000000, 0xF0000000, 0xFB000000, 0x2D212121, 0x46141414,
  0x391E1E1E, 0x3E1F1F1F, 0x9B000000, 0xDA000000, 0xFE4A4A4A, 0x30494949, 0x4F3E3E3E, 0x9E000000, 0xDC000000, 0xF9626262, 0x23747474, 0x58585858, 0x96000000, 0xD4000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x71000059, 0x00010EB8, 
        0x002F4BFF, 0x005871FF, 0x00152FFB, 0x000005FE, 0x000000F1, 0x000000DD, 0x00000091, 0x44000045, 0xD5000000, 0xF8000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0x74676767, 0x166E6E6E, 0xA0060606, 0xE3000000, 0xFE000000, 
        0x69484848, 0x21434343, 0xA4010101, 0xE3000000, 0xFF000000, 0x4F222222, 0x31191919,
  0x19202020, 0x4E1C1C1C, 0xA0000000, 0xE1000000, 0xF54B4B4B, 0x1B4C4C4C, 0x61323232, 0xA7000000, 0xE6000000, 0xE5717171, 0x0D797979, 0x713A3A3A, 0xA8000000, 0xE7000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDD000056, 0x09000087, 0x000114FC, 
        0x005C76FC, 0x00ADBAFC, 0x002744F9, 0x000008FD, 0x000000F1, 0x000000DB, 0x000000AD, 0x04000064, 0x8C00001A, 0xE3000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xAC636363, 0x0B777777, 0x89181818, 0xD5000000, 0xFE000000, 
        0x8F464646, 0x15494949, 0x96070707, 0xDA000000, 0xFF000000, 0x6F222222, 0x241D1D1D,
  0x0C232323, 0x5C181818, 0xA6000000, 0xE8000000, 0xEE474747, 0x104F4F4F, 0x6C292929, 0xB1000000, 0xED000000, 0xC9707070, 0x0D7C7C7C, 0x80232323, 0xB9000000, 0xF2000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x93000054, 0x000000B8, 0x00020CFF, 
        0x001631FA, 0x002744F9, 0x000B20FB, 0x000004FC, 0x000000EC, 0x000000D7, 0x000000A5, 0x00000069, 0x45000034, 0xC6000000, 0xF8000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xD0616161, 0x0C797979, 0x772C2C2C, 0xCA000000, 0xFB000000, 
        0xA9474747, 0x0D4C4C4C, 0x8E0B0B0B, 0xD3000000, 0xFE000000, 0x8B232323, 0x211F1F1F,
  0x07242424, 0x60171717, 0xAC000000, 0xEC000000, 0xE0454545, 0x0D505050, 0x73242424, 0xB7000000, 0xF2000000, 0xB66E6E6E, 0x0D7D7D7D, 0x89151515, 0xC4000000, 0xF8000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x76000056, 0x000000BA, 0x000101FD, 
        0x000008FD, 0x00000BFD, 0x000105FD, 0x000000F2, 0x000000E2, 0x000000CA, 0x00000091, 0x00000060, 0x2F00003A, 0xAD000000, 0xEE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE5636363, 0x0D7C7C7C, 0x6E363636, 0xC1000000, 0xF6000000, 
        0xB9484848, 0x0B4E4E4E, 0x86121212, 0xCD000000, 0xFC000000, 0x96242424, 0x20212121,
  0x07252525, 0x5F181818, 0xB0000000, 0xEF000000, 0xDF444444, 0x0D525252, 0x72252525, 0xBB000000, 0xF4000000, 0xB56D6D6D, 0x0D7E7E7E, 0x8A161616, 0xCA000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x9600004D, 0x000000A1, 0x000000ED, 
        0x000000EE, 0x000000F0, 0x000000EC, 0x000000E1, 0x000000D0, 0x000000AA, 0x00000073, 0x0000005D, 0x3A00002C, 0xA5000000, 0xEA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE76D6D6D, 0x0D7D7D7D, 0x6F373737, 0xBC000000, 0xF4000000, 
        0xBB4C4C4C, 0x0C505050, 0x85121212, 0xC9000000, 0xFB000000, 0x97252525, 0x21222222,
  0x0B262626, 0x5A1A1A1A, 0xB0000000, 0xEF000000, 0xEB404040, 0x0F535353, 0x6A2B2B2B, 0xBB000000, 0xF4000000, 0xC4696969, 0x0C808080, 0x81262626, 0xCA000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDC000037, 0x0F00006E, 0x000000C9, 
        0x000000DA, 0x000000DA, 0x000000D6, 0x000000C7, 0x000000A9, 0x0000007D, 0x0000005F, 0x06000058, 0x5A00000C, 0xB1000000, 0xF0000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xD87A7A7A, 0x0D7E7E7E, 0x782E2E2E, 0xBC000000, 0xF4000000, 
        0xAE4F4F4F, 0x0E505050, 0x8C0B0B0B, 0xC9000000, 0xFB000000, 0x8F272727, 0x23232323,
  0x18252525, 0x4A1F1F1F, 0xAC000000, 0xEC000000, 0xF23F3F3F, 0x1A525252, 0x5E353535, 0xB7000000, 0xF2000000, 0xE0616161, 0x0B808080, 0x6E3D3D3D, 0xC4000000, 0xF8000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF9000000, 0x6C000049, 0x00000082, 
        0x000000AE, 0x000000B0, 0x000000A8, 0x00000092, 0x00000073, 0x00000060, 0x0000005E, 0x27000034, 0x7A000000, 0xCB000000, 0xF9000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xBA7C7C7C, 0x0C7F7F7F, 0x86191919, 0xC1000000, 0xF6000000, 
        0x97525252, 0x17505050, 0x90070707, 0xCD000000, 0xFC000000, 0x75292929, 0x28222222,
  0x37242424, 0x38252525, 0xA7000000, 0xE8000000, 0xFD292929, 0x2D505050, 0x49434343, 0xB1000000, 0xED000000, 0xF6474747, 0x1E7D7D7D, 0x4F5D5D5D, 0xB9000000, 0xF2000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xE5000008, 0x4D000049, 
        0x03000069, 0x00000072, 0x0000006D, 0x00000063, 0x0000005D, 0x0200005C, 0x2100003B, 0x64000001, 0xA8000000, 0xE7000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x847F7F7F, 0x1B7B7B7B, 0x92060606, 0xCA000000, 0xFB000000, 
        0x71545454, 0x254C4C4C, 0x97010101, 0xD3000000, 0xFE000000, 0x542A2A2A, 0x35202020,
  0x65222222, 0x23282828, 0xA0000000, 0xE1000000, 0xFF000000, 0x534D4D4D, 0x2B505050, 0xA7000000, 0xE6000000, 0xFE000000, 0x54767676, 0x187F7F7F, 0xA4060606, 0xE6000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFA000000, 0xDB000000, 
        0x63000039, 0x00000064, 0x0000006A, 0x00000061, 0x0000005F, 0x2C00002B, 0x68000000, 0xA0000000, 0xDB000000, 0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC8B8B8B, 0x28858585, 0x416B6B6B, 0x98000000, 0xD5000000, 0xFE000000, 
        0x40575757, 0x40454545, 0x9C000000, 0xDA000000, 0xFF000000, 0x312A2A2A, 0x4B1C1C1C,
  0x94202020, 0x0F2C2C2C, 0x93060606, 0xDA000000, 0xFF000000, 0x9C444444, 0x11575757, 0x970B0B0B, 0xDC000000, 0xFE000000, 0xB65C5C5C, 0x01888888, 0x6F404040, 0xD3000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF9000000, 
        0x95000047, 0x0000006E, 0x00000078, 0x0000006A, 0x00000061, 0x3B000026, 0x98000000, 0xDA000000, 0xF9000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xBE898989, 0x00878787, 0x76333333, 0xA3000000, 0xE3000000, 0xF2575757, 
        0x17595959, 0x6C2D2D2D, 0xA5000000, 0xE3000000, 0xF32F2F2F, 0x152B2B2B, 0x62151515,
  0xCA1C1C1C, 0x042C2C2C, 0x6A181818, 0xCB000000, 0xFB000000, 0xE7232323, 0x14575757, 0x5F3A3A3A, 0xCB000000, 0xFA000000, 0xF3000000, 0x34797979, 0x217D7D7D, 0xB00F0F0F, 0xEF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x81000057, 0x00000079, 0x00000082, 0x00000075, 0x00000067, 0x33000035, 0xAD000000, 0xEE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF88F8F8F, 0x398A8A8A, 0x2F787878, 0x8F000000, 0xBC000000, 0xF3000000, 0x9C5C5C5C, 
        0x16565656, 0x93080808, 0xB8000000, 0xF0000000, 0xB52F2F2F, 0x052A2A2A, 0x7E0C0C0C,
  0xF7050505, 0x2F272727, 0x31292929, 0xB6000000, 0xF0000000, 0xFB000000, 0x564E4E4E, 0x1C585858, 0xB2000000, 0xEC000000, 0xFD000000, 0xBA4B4B4B, 0x038A8A8A, 0x60565656, 0xD4000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x5900005C, 0x0000008B, 0x0000008B, 0x0000007F, 0x00000071, 0x22000044, 0xA4000000, 0xE9000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x9E8B8B8B, 0x03888888, 0x802B2B2B, 0x9D000000, 0xDA000000, 0xFD000000, 0x2B5D5D5D, 
        0x4A474747, 0x9A000000, 0xCF000000, 0xFB000000, 0x53303030, 0x29262626, 0x91000000,
  0xFE000000, 0x84222222, 0x0B303030, 0x96070707, 0xE0000000, 0xFE000000, 0xB83B3B3B, 0x005E5E5E, 0x65373737, 0xD4000000, 0xFB000000, 0xF3000000, 0x7D5F5F5F, 0x81323232, 0xC4000000, 0xF4000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC00005E, 
        0x2E000063, 0x0000009A, 0x00000094, 0x00000088, 0x0000007C, 0x11000053, 0x92000003, 0xE1000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xC7747474, 0x7C616161, 0x9E000000, 0xC1000000, 0xF2000000, 0xA75F5F5F, 0x005C5C5C, 
        0x7B1F1F1F, 0xA5000000, 0xE3000000, 0xF12F2F2F, 0x112F2F2F, 0x60191919, 0x9A000000,
  0xFF000000, 0xD6181818, 0x0A2D2D2D, 0x611E1E1E, 0xCB000000, 0xFA000000, 0xF4000000, 0x494E4E4E, 0x105E5E5E, 0xAA0B0B0B, 0xEC000000, 0xFD000000, 0xE8000000, 0xCC000000, 0xDA000000, 0xF7000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEA000058, 
        0x0D00006F, 0x000000A6, 0x0000009D, 0x00000092, 0x00000086, 0x05000062, 0x7900000E, 0xD7000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF7000000, 0xDA000000, 0xCB000000, 0xE7000000, 0xF4525252, 0x1A606060, 0x434B4B4B, 
        0x8F000000, 0xBF000000, 0xF4000000, 0xA6323232, 0x0B2C2C2C, 0x85090909, 0xAE000000,
  0xFF000000, 0xF8000000, 0x64242424, 0x19303030, 0xAA070707, 0xEC000000, 0xFD000000, 0xC92A2A2A, 0x105A5A5A, 0x38515151, 0xCB000000, 0xF7000000, 0xFB000000, 0xF5000000, 0xF7000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCB000055, 
        0x0400007D, 0x000000B3, 0x000000A7, 0x0000009C, 0x00000092, 0x0100006B, 0x5E00001C, 0xCB000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF7000000, 0xF5000000, 0xFB000000, 0x5D636363, 0x155B5B5B, 0x85131313, 
        0xA1000000, 0xDF000000, 0xF32C2C2C, 0x27323232, 0x55222222, 0x96000000, 0xC9000000,
  0xFF000000, 0xFE000000, 0xD2141414, 0x06303030, 0x55252525, 0xCF000000, 0xF9000000, 0xF5000000, 0x95393939, 0x00626262, 0x61434343, 0xDB000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xA9000052, 
        0x0000008B, 0x000000C1, 0x000000B1, 0x000000A6, 0x0000009E, 0x00000076, 0x48000027, 0xBF000000, 0xF6000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x98666666, 0x00606060, 0x772C2C2C, 0x94000000, 
        0xC9000000, 0xF5000000, 0x8B343434, 0x07303030, 0x8C080808, 0xA9000000, 0xE4000000,
  0xFF000000, 0xFF000000, 0xF8000000, 0x66252525, 0x03353535, 0x91131313, 0xE5000000, 0xFD000000, 0xEC000000, 0x65464646, 0x36515151, 0xB8020202, 0xEF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x8B000054, 
        0x000B0BA4, 0x000303CD, 0x000000B9, 0x000000AF, 0x000000A8, 0x00000083, 0x38000031, 0xB2000000, 0xF1000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE666666, 0x575F5F5F, 0x65454545, 0x94000000, 0xB8000000, 
        0xEC000000, 0xDB363636, 0x05343434, 0x55212121, 0x92000000, 0xC8000000, 0xF7000000,
  0xFF000000, 0xFF000000, 0xFE000000, 0xE1080808, 0x202D2D2D, 0x23313131, 0xBA070707, 0xF2000000, 0xFC000000, 0xE3000000, 0xB20E0E0E, 0xC0000000, 0xEB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x6D000059, 
        0x002929CA, 0x001616DB, 0x000000C2, 0x000000B9, 0x000000B1, 0x00000095, 0x2B00003D, 0xA7000000, 0xEB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE1222222, 0xBF000000, 0xBA000000, 0xE3000000, 
        0xF5282828, 0x3D363636, 0x232D2D2D, 0x8C020202, 0xA9000000, 0xE6000000, 0xFE000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xF9000000, 0xB7151515, 0x09323232, 0x402E2E2E, 0xD1000000, 0xF8000000, 0xFA000000, 0xEC000000, 0xE9000000, 0xF7000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x4E000062, 
        0x004141EA, 0x003636EC, 0x000000CD, 0x000000C3, 0x000000BA, 0x000000A9, 0x1D00004B, 0x9C000000, 0xE6000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF7000000, 0xE9000000, 0xEC000000, 0xFA000000, 
        0x69393939, 0x0B323232, 0x840D0D0D, 0x98000000, 0xD2000000, 0xF9000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF2000000, 0x8E1D1D1D, 0x03363636, 0x5B2A2A2A, 0xD8030303, 0xFA000000, 0xFF000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC00005A, 0x33000075, 
        0x005555F8, 0x004646F5, 0x000000D7, 0x000000CD, 0x000000C3, 0x000000B6, 0x1200005B, 0x8F000003, 0xE0000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD3B3B3B, 0x8B3A3A3A, 
        0x04353535, 0x77181818, 0x93000000, 0xC2000000, 0xF2000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xEB000000, 0x6A242424, 0x01383838, 0x871B1B1B, 0xE3000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF4000050, 0x1903038B, 
        0x006969FF, 0x004A4AFC, 0x000000E2, 0x000000D6, 0x000000CD, 0x000000C2, 0x09000070, 0x80000007, 0xD9000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xC63A3A3A, 0x01373737, 
        0x64222222, 0x90000000, 0xB6000000, 0xEA000000, 0xFE000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0xE3000000, 0x7C1D1D1D, 0x970A0A0A, 0xD3000000, 0xF9000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xD6000051, 0x060C0CA0, 
        0x007C7CFF, 0x004C4CFF, 0x000202ED, 0x000000E0, 0x000000D7, 0x000000D1, 0x02000085, 0x66000016, 0xD0000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE7282828, 0x95242424, 
        0xA2000000, 0xB0000000, 0xE3000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFB000000, 0xE3000000, 0xD1000000, 0xE4000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xA4000050, 0x001C1CB4, 
        0x008181FF, 0x004949FF, 0x000909F8, 0x000000EB, 0x000000E1, 0x000000DD, 0x00000099, 0x48000029, 0xC2000000, 0xF8000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFB000000, 0xE4000000, 
        0xD1000000, 0xE3000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0xF8000000, 0xFB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x77000056, 0x002D2DC7, 
        0x008181FF, 0x004545FF, 0x000C0CFE, 0x000000F5, 0x000000EA, 0x000000E6, 0x000000AC, 0x30000039, 0xB0000000, 0xEF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFB000000, 
        0xF8000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x5800005B, 0x003E3ED8, 
        0x008181FF, 0x003E3EFF, 0x000A0AFF, 0x000000FD, 0x000000F4, 0x000000EE, 0x000000C0, 0x22000044, 0xA1000000, 0xE8000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE00005C, 0x3A000061, 0x005050ED, 
        0x008181FF, 0x003838FF, 0x000606FF, 0x000000FF, 0x000000FE, 0x000000F9, 0x000000DA, 0x15000051, 0x94000001, 0xE2000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF600005A, 0x1B000075, 0x006666FF, 
        0x007E7EFF, 0x003333FF, 0x000404FF, 0x000000FF, 0x000000FF, 0x000000FF, 0x000000F2, 0x0A000069, 0x83000007, 0xDB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE2000059, 0x1600006C, 0x072B2B99, 
        0x042B2B96, 0x04101091, 0x04010190, 0x04000090, 0x04000090, 0x04000090, 0x0400008F, 0x08000065, 0x6F000012, 0xD3000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000
#endif
};

GUI_CONST_STORAGE GUI_BITMAP _bmRemote = {
  48, // XSize */
  48, // YSize */
  192, // BytesPerLine */
  32, // BitsPerPixel */
  (unsigned char *)_acRemote,  // Pointer to picture data */
  NULL,  // Pointer to palette */
#if (GUI_USE_ARGB == 1)
  GUI_DRAW_BMPM8888I
#else
  GUI_DRAW_BMP8888
#endif
};

/*********************************************************************
*
*       _bmSystem
*
* Function description
*   Icon bitmap with alpha channel
*/
static GUI_CONST_STORAGE unsigned long _acSystem[] = {
#if (GUI_USE_ARGB == 1)
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x008A8AA0, 0x008B8BA2, 0x008C8CA4, 0x008D8DA4, 0x008C8CA4, 0x009393AC, 0x007E7E92, 0x00303038, 0x00808094, 0xA58B8BA2, 0xBD8B8BA2, 0x8385859C, 0x4E84849B, 0x2186869C, 0x0089899E, 0x00808093, 0x00808092, 0x00818193, 0x00818193, 0x00808092, 
        0x0009090A, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00050506, 0x00000000, 
        0x008A8AA0, 0x008B8BA2, 0x008C8CA4, 0x4C8989A1, 0xC58E8EA7, 0x808F8FA7, 0x007F7F93, 0x002D2D35, 0x4225252C, 0xFD9F9FB5, 0xFFD4D4E1, 0xFFC3C3D3, 0xFFAFAFC1, 0xEC9898AD, 0x5F87879C, 0x00808093, 0x00808092, 0x00818193, 0x00818193, 0x00808092, 
        0x006F6F7C, 0x00010101, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00030304, 0x00232329, 0x00717183, 0x00000000, 
        0x008F8FA6, 0x208989A0, 0xA58A8AA1, 0xFFA6A6BB, 0xFFD5D5E3, 0xFFAFAFC2, 0xA18989A1, 0x293B3B45, 0xB9515161, 0xFFC4C4D7, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC2C2D3, 0x94838398, 0x00808093, 0x00808092, 0x00818193, 0x00818193, 0x00808092, 
        0x007F7F8E, 0x00676773, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0018181C, 0x0089899F, 0x008B8B9F, 0x00000000, 
        0x2B676778, 0xE99393AA, 0xFFBFBFD1, 0xFFEDEDF5, 0xFFF8F8FD, 0xFFEFEFF7, 0xFFB7B7C9, 0xFB9B9BAF, 0xFFB1B1C4, 0xFFE4E4EE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFC9C9D8, 0xAD7E7E93, 0x00808093, 0x00808092, 0x0F7E7E90, 0x367E7E90, 0x00808092, 
        0x007C7C8B, 0x007E7E8C, 0x00313138, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00828295, 0x00868699, 0x02000000, 
        0xAF535360, 0xFFAFAFC7, 0xFFCDCDDD, 0xFFF3F3F8, 0xFFF1F1F8, 0xFFF5F5FA, 0xFFF3F3F9, 0xFFF2F2F9, 0xFFFBFBFE, 0xFFFCFCFF, 0xFFFDFDFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE1E1EB, 0xF89999AD, 0x977C7C8F, 0x8F7C7C8F, 0xE28E8EA1, 0xFF9494A7, 0x727C7C8E, 
        0x007C7C8B, 0x007A7A88, 0x00868698, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00818194, 0x00868699, 0x2B0B0B0D, 
        0xF89090A4, 0xFFB4B4CC, 0xFFB3B3C9, 0xFFE0E0EA, 0xFFF1F1F7, 0xFFF1F1F7, 0xFFF4F4FA, 0xFFF7F7FB, 0xFFF9F9FC, 0xFFFBFBFE, 0xFFFCFCFF, 0xFFFDFDFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF5F5F9, 0xFFBFBFCF, 0xFFC5C5D4, 0xFFF0F0F6, 0xFFE8E8F1, 0xFC9090A2, 
        0x47787887, 0x007A7A88, 0x007D7D8C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000B0B0D, 0x001A1A1E, 0x00000000, 0x00858599, 0x00868699, 0x350D0D10, 
        0xD16C6C7C, 0xFFAEAEC5, 0xFFB3B3CA, 0xFFD9D9E5, 0xFFEFEFF5, 0xFFEFEFF6, 0xFFF1F1F8, 0xFFF5F5FB, 0xFFF5F5FA, 0xFFF3F3F8, 0xFFF6F6FA, 0xFFFCFCFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFDBDBE6, 
        0xEA868698, 0x2B777786, 0x007A7A89, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0009090A, 0x00646475, 0x00646475, 0x0032323B, 0x00000000, 0x00555561, 0x003B3B44, 0x00000000, 0x04686878, 0xAE848497, 0xE588889B, 
        0xF287879A, 0xFF9F9FB5, 0xFFCACADB, 0xFFEBEBF2, 0xFFEBEBF2, 0xFFEEEEF4, 0xFFF0F0F6, 0xFFDBDBE6, 0xFFC8C8D6, 0xFFC2C2D2, 0xFFC5C5D5, 0xFFD1D1DE, 0xFFE9E9F1, 0xFFFEFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE9E9F2, 
        0xFF9797AA, 0x69747482, 0x0071717C, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00010101, 0x003B3B45, 0x00808096, 0x009494AD, 0x009494AD, 0x009999B3, 0x00585865, 0x00000000, 0x00000000, 0x00000000, 0x5E26262B, 0xFF9A9AAF, 0xFFCFCFDF, 
        0xFFDCDCE9, 0xFFD9D9E5, 0xFFE2E2EC, 0xFFE7E7F0, 0xFFE8E8F1, 0xFFECECF3, 0xFFCECEDD, 0xFFB2B2C8, 0xFFB2B2C8, 0xFFB6B6CB, 0xFFBBBBCF, 0xFFC0C0D1, 0xFFC3C3D3, 0xFFDCDCE6, 0xFFFDFDFE, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE5E5EE, 0xFFA0A0B4, 
        0xB3777785, 0x08757582, 0x006E6E77, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0016161A, 0x00757589, 0x009595AC, 0x008F8FA8, 0x008D8DA5, 0x008D8DA5, 0x009191AA, 0x009696AE, 0x00595967, 0x00000000, 0x04000000, 0xCA666674, 0xFFADADC2, 0xFFD3D3E0, 
        0xFFE2E2EC, 0xFFE2E2EC, 0xFFE4E4ED, 0xFFE5E5EE, 0xFFE9E9F1, 0xFFDADAE6, 0xFF9C9CB1, 0xEE7C7C8C, 0xCF676775, 0xD56A6A78, 0xF8888899, 0xFFAAAABE, 0xFFC2C2D3, 0xFFC8C8D6, 0xFFE3E3EC, 0xFFFEFEFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFCFCFDC, 0xE5797989, 
        0x0A71717D, 0x00737380, 0x006E6E78, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x008B8BA0, 0x009090A7, 0x008C8CA2, 0x008C8CA4, 0x008D8DA5, 0x008D8DA5, 0x009191AA, 0x008E8EA4, 0x008A8AA0, 0x00000000, 0x4B18181C, 0xF889899B, 0xFFAFAFC3, 0xFFD0D0DE, 
        0xFFDEDEE9, 0xFFE0E0EA, 0xFFE0E0EB, 0xFFE3E3ED, 0xFFE8E8F1, 0xFFC7C7D7, 0xD06E6E7E, 0x29030303, 0x14000000, 0x22000000, 0x4C111113, 0xB34D4D56, 0xFF9797AA, 0xFFC2C2D4, 0xFFD3D3DF, 0xFFF6F6FB, 0xFFFEFEFF, 0xFFFFFFFF, 0xFFECECF3, 0xF1808091, 
        0x44696973, 0x006D6D78, 0x006E6E78, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x008C8CA1, 0x008B8BA2, 0x008C8CA2, 0x008C8CA4, 0x478B8BA3, 0x7D8A8AA2, 0x089191AA, 0x008E8EA4, 0x00838398, 0x04000000, 0xC9535360, 0xFF9595A8, 0xFFB1B1C7, 0xFFB7B7CC, 
        0xFFC0C0D3, 0xFFD3D3E1, 0xFFDFDFE9, 0xFFE1E1EB, 0xFFE7E7F0, 0xFFBDBDCF, 0xAC767685, 0x00494950, 0x00000000, 0x00000000, 0x07000000, 0x22000000, 0xA6404047, 0xFFA0A0B3, 0xFFCFCFDD, 0xFFEEEEF5, 0xFFFDFDFF, 0xFFFEFEFF, 0xFFFBFBFE, 0xFFCACAD7, 
        0xFF9494A3, 0xC7757582, 0x626E6E78, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x0028282E, 0x00000000, 0x008B8BA0, 0x008B8BA2, 0x198B8BA1, 0x998888A0, 0xFF9B9BB2, 0xFFA6A6BB, 0xBF8B8BA2, 0x1A8D8DA4, 0x00838398, 0x4418181C, 0xFF737385, 0xFF9191A5, 0xFFB5B5CD, 0xFFB7B7CE, 
        0xFFB4B4CA, 0xFFBDBDD2, 0xFFDCDCE8, 0xFFDEDEE9, 0xFFE3E3ED, 0xFFCDCDDC, 0xDF7D7D8C, 0x08787883, 0x00505059, 0x0029292C, 0x00000000, 0x06000000, 0x36040404, 0xE36B6B78, 0xFFC1C1D3, 0xFFEFEFF5, 0xFFFBFBFE, 0xFFFBFBFE, 0xFFFDFDFF, 0xFFFFFFFF, 
        0xFFFCFCFF, 0xFFC9C9D7, 0xEC737380, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x000F0F12, 0x004F4F5C, 0x004D4D59, 0x00000000, 0x008E8EA4, 0x6289899F, 0xE48F8FA5, 0xFFB0B0C3, 0xFFE2E2ED, 0xFFECECF4, 0xFFB3B3C7, 0xD78B8BA1, 0x70808096, 0xCE656577, 0xFF858596, 0xFF8F8F9A, 0xFF8B8B9C, 0xFF9D9DB2, 
        0xFFB3B3C9, 0xFFB9B9CE, 0xFFD4D4E2, 0xFFDDDDE8, 0xFFDFDFE9, 0xFFE0E0EB, 0xFFA1A1B3, 0x8D6C6C78, 0x0072727E, 0x0075757F, 0x0057575E, 0x001D1D20, 0x0A000000, 0xBC484850, 0xFFB8B8CB, 0xFFF5F5FB, 0xFFF8F8FC, 0xFFF9F9FC, 0xFFFCFCFF, 0xFFFEFEFF, 
        0xFFFFFFFF, 0xFFCFCFDB, 0xC46D6D79, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x002C2C33, 0x008F8FA4, 0x00000000, 0x00000000, 0x5B717183, 0xFF9898AF, 0xFFC4C4D6, 0xFFF0F0F7, 0xFFF5F5FA, 0xFFF6F6FB, 0xFFF0F0F8, 0xFFBDBDCF, 0xFFACACBF, 0xFFC4C4D5, 0xFFCCCCD5, 0xFFD5D5D6, 0xFFB9B9BC, 0xFF8E8E97, 
        0xFF9A9AAF, 0xFFBFBFD3, 0xFFD4D4E2, 0xFFDBDBE7, 0xFFDCDCE8, 0xFFE0E0EB, 0xFFD9D9E6, 0xFF9898A9, 0xA86C6C77, 0x3A686871, 0x126D6D76, 0x206B6B75, 0x7E3F3F45, 0xF680808E, 0xFFDADAE6, 0xFFF5F5FB, 0xFFF5F5FA, 0xFFF8F8FC, 0xFFF4F4F9, 0xFFF4F4F9, 
        0xFFFAFAFC, 0xFFB8B8C8, 0xA266666F, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00828295, 0x00000000, 0x0C050505, 0xD96F6F80, 0xFFAFAFC8, 0xFFC0C0D4, 0xFFEDEDF4, 0xFFF1F1F7, 0xFFF2F2F8, 0xFFF5F5FA, 0xFFF4F4FA, 0xFFF6F6FC, 0xFFFDFDFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEFEFF0, 0xFF909097, 
        0xFF9F9FB2, 0xFFD4D4E2, 0xFFD7D7E4, 0xFFD8D8E5, 0xFFDBDBE6, 0xFFDCDCE7, 0xFFE0E0EB, 0xFFDDDDEA, 0xFFB8B8C8, 0xFF9292A0, 0xEB82828F, 0xF5868694, 0xFFABABBB, 0xFFDDDDE9, 0xFFF2F2F8, 0xFFF1F1F7, 0xFFF3F3F9, 0xFFF2F2F8, 0xFFD1D1DF, 0xFFCBCBDC, 
        0xFFCDCDDE, 0xFF9696A8, 0x7C636369, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00838396, 0x00000000, 0x5C2A2A31, 0xFFA1A1B8, 0xFFB3B3CA, 0xFFB0B0C7, 0xFFD5D5E2, 0xFFF1F1F6, 0xFFF0F0F7, 0xFFF2F2F8, 0xFFF4F4FA, 0xFFF6F6FB, 0xFFF8F8FC, 0xFFFAFAFD, 0xFFFFFFFF, 0xFFC0C0C4, 0xFF838394, 
        0xFFB6B6C9, 0xFFD1D1DF, 0xFFD5D5E3, 0xFFD7D7E4, 0xFFDADAE6, 0xFFDBDBE7, 0xFFDCDCE8, 0xFFDFDFEA, 0xFFE5E5EF, 0xFFE3E3EF, 0xFFDFDFEB, 0xFFE3E3EE, 0xFFECECF5, 0xFFEEEEF5, 0xFFEDEDF3, 0xFFEFEFF6, 0xFFF1F1F8, 0xFFD3D3E0, 0xFFC1C1D5, 0xFFC9C9DC, 
        0xFFB1B1C7, 0xE76F6F7A, 0x1F616166, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00838396, 0x00000000, 0x47121214, 0xF28B8B9F, 0xFFB2B2CA, 0xFFB0B0C7, 0xFFC5C5D7, 0xFFEDEDF4, 0xFFEFEFF5, 0xFFF0F0F7, 0xFFF2F2F8, 0xFFF4F4FA, 0xFFF8F8FC, 0xFFFCFCFF, 0xFFF0F0F2, 0xFF878790, 0xFFA0A0B5, 
        0xFFB1B1C3, 0xFFB9B9CB, 0xFFD1D1DF, 0xFFCECEDE, 0xFFC3C3D4, 0xFFCCCCDB, 0xFFDBDBE7, 0xFFDDDDE8, 0xFFDEDEE9, 0xFFE1E1EB, 0xFFE5E5EE, 0xFFE6E6EF, 0xFFE7E7F0, 0xFFE9E9F1, 0xFFEBEBF2, 0xFFEDEDF4, 0xFFF2F2F8, 0xFFC2C2D3, 0xFF808090, 0xFA7B7B88, 
        0xF7757580, 0x53606064, 0x00616166, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x1C838396, 0x8D555561, 0xA04D4D59, 0xE8727284, 0xFF9D9DB4, 0xFFB8B8CE, 0xFFE1E1EB, 0xFFECECF3, 0xFFEDEDF3, 0xFFEFEFF5, 0xFFF2F2F8, 0xFFEEEEF5, 0xFFDEDEE9, 0xFFD7D7E3, 0xFFB7B7C2, 0xFF7F7F89, 0xFF8E8EA0, 
        0xFFB2B2C5, 0xFFB3B3C4, 0xFFBFBFD2, 0xFFBFBFD4, 0xFFB7B7CA, 0xFFB5B5C8, 0xFFC1C1D1, 0xFFD7D7E4, 0xFFDDDDE8, 0xFFDEDEE9, 0xFFE0E0EA, 0xFFE3E3ED, 0xFFE4E4EE, 0xFFE3E3ED, 0xFFE9E9F1, 0xFFEBEBF3, 0xFFEFEFF5, 0xFFEAEAF3, 0xFF8B8B98, 0x8E2D2D2E, 
        0x270E0E0E, 0x00616165, 0x00616166, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0xA6666675, 0xFFA9A9C0, 0xFFBDBDD1, 0xFFB7B7C9, 0xFFB7B7CA, 0xFFD3D3E0, 0xFFE9E9F2, 0xFFE8E8F1, 0xFFEBEBF2, 0xFFEFEFF5, 0xFFE1E1EA, 0xFFC0C0D2, 0xFFB7B7CA, 0xFFBABACD, 0xFFB2B2C3, 0xFF9595A1, 0xFF777780, 
        0xFF9797A9, 0xFFB8B8CE, 0xFFB1B1C7, 0xFF9A9AAE, 0xFFABABBF, 0xFFBABACC, 0xFFB9B9CA, 0xFFD1D1E0, 0xFFDBDBE7, 0xFFDCDCE8, 0xFFDDDDE9, 0xFFD1D1E0, 0xFFCDCDDC, 0xFFC2C2D3, 0xFFD2D2DE, 0xFFE9E9F2, 0xFFEBEBF3, 0xFFE6E6F0, 0xFFA8A8BA, 0xB05E5E62, 
        0x00000000, 0x00616165, 0x00616166, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x33151517, 0xFC87879A, 0xFFB4B4CA, 0xFFDFDFEA, 0xFFE4E4EE, 0xFFE5E5EF, 0xFFE5E5EE, 0xFFE6E6EF, 0xFFE7E7F0, 0xFFEAEAF2, 0xFFE1E1EB, 0xFFB6B6CB, 0xFFABABC1, 0xFFA9A9BE, 0xFFA9A9BE, 0xFFB2B2C8, 0xFFACACBE, 0xFF91919C, 
        0xFF777781, 0xFF818192, 0xFF7B7B85, 0xFF86868B, 0xFF7C7C87, 0xFF9A9AAD, 0xFFBEBED2, 0xFFD0D0DE, 0xFFDADAE6, 0xFFDCDCE7, 0xFFD9D9E5, 0xFFC8C8DA, 0xFFC3C3D7, 0xFFBCBCCC, 0xFFBABAC9, 0xFFCFCFDB, 0xFFD9D9E6, 0xFFC0C0D5, 0xFF7A7A88, 0x525B5B5C, 
        0x00000000, 0x00616165, 0x00626266, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x98474751, 0xFFA4A4BA, 0xFFB8B8CB, 0xFFDEDEE9, 0xFFDFDFE9, 0xFFE0E0EA, 0xFFE2E2EC, 0xFFE4E4EE, 0xFFE6E6EF, 0xFFE9E9F2, 0xFFC2C2D4, 0xFF89899D, 0xD6666673, 0xAD4B4B55, 0xAB4B4B54, 0xCE60606D, 0xFD89899B, 0xFF9494A6, 
        0xFF8D8D99, 0xFF94949E, 0xFFBFBFCA, 0xFFDEDEE0, 0xFFADADAC, 0xFF797985, 0xFFBDBDD2, 0xFFC7C7D8, 0xFFCACADA, 0xFFD2D2E1, 0xFFBDBDD0, 0xFF9494A5, 0xFF8A8A99, 0xFFABABBE, 0xFFC0C0CE, 0xFFC7C7D7, 0xFFBFBFD4, 0xFF8E8E9F, 0x9B5A5A5C, 0x005A5A5B, 
        0x00000000, 0x0066666A, 0x004C4C4D, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x0A000000, 0xC55F5F6B, 0xFFA9A9BE, 0xFFB9B9CC, 0xFFDADAE6, 0xFFDFDFE9, 0xFFDFDFEA, 0xFFE0E0EA, 0xFFE2E2EC, 0xFFE5E5EE, 0xFFE5E5EF, 0xFFADADC0, 0xB45E5E6A, 0x15000000, 0x0A000000, 0x11000000, 0x25000000, 0x5C1A1A1D, 0xD15F5F6A, 
        0xFF9898AC, 0xFFC7C7D8, 0xFFD4D4E0, 0xFFEFEFF5, 0xFFC9C9C9, 0xFF787882, 0xFFBBBBD1, 0xFFCACADB, 0xFFC9C9D9, 0xFFC5C5D8, 0xFF8F8FA1, 0x9C303030, 0x771D1D1C, 0xF3696972, 0xFFA9A9BD, 0xFFAAAABD, 0xFB70707A, 0x8A323232, 0x08585859, 0x005A5A5B, 
        0x00000000, 0x00242424, 0x000A0A0A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x1F030303, 0xDB6E6E7C, 0xFFACACC1, 0xFFB3B3C8, 0xFFBABACF, 0xFFC7C7D8, 0xFFD6D6E3, 0xFFDFDFE9, 0xFFE0E0EA, 0xFFE3E3ED, 0xFFE3E3ED, 0xFFA2A2B4, 0x84737380, 0x00232326, 0x00000000, 0x00000000, 0x02000000, 0x0E000000, 0x36060606, 
        0xCC5B5B65, 0xFFA1A1B5, 0xFFCDCDDB, 0xFFE6E6EE, 0xFFD0D0D3, 0xFF75757B, 0xFF7F7F8F, 0xFF9292A4, 0xFFA7A7BA, 0xFFA0A0B5, 0xFE66666E, 0x8D49494F, 0x250C0C0E, 0x59111110, 0xE358585D, 0xC74B4B4F, 0x3C10100F, 0x00040404, 0x0059595A, 0x005B5B5C, 
        0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x3C0F0F11, 0xF27E7E8F, 0xFFB3B3CA, 0xFFB7B7CD, 0xFFB5B5CB, 0xFFB3B3C9, 0xFFBEBED3, 0xFFDDDDE8, 0xFFDEDEE9, 0xFFE0E0EB, 0xFFE4E4EE, 0xFFAFAFC2, 0xB7737380, 0x00797985, 0x00404046, 0x0018181A, 0x00000000, 0x00000000, 0x0C000000, 
        0x52111112, 0xF5797988, 0xFFBBBBCE, 0xFFE6E6EF, 0xFFE0E0E3, 0xFFBABABC, 0xFF9F9FA0, 0xFF8B8B8D, 0xFF7C7C80, 0xFF76767B, 0xFFB0B0B8, 0xFF9999AB, 0x83595960, 0x07000000, 0x28020201, 0x06000000, 0x00000000, 0x00090909, 0x0059595A, 0x005B5B5C, 
        0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x46111113, 0xEC757584, 0xFFA1A1B5, 0xFFADADC3, 0xFFB4B4CB, 0xFFB6B6CC, 0xFFBABACF, 0xFFD6D6E3, 0xFFDEDEE8, 0xFFDEDEE9, 0xFFE2E2EC, 0xFFCECEDD, 0xFA818191, 0x406F6F7A, 0x00777783, 0x0070707B, 0x0047474D, 0x001F1F22, 0x00000000, 
        0x17000000, 0xC14D4D56, 0xFFAAAABD, 0xFFE9E9F1, 0xFFF9F9FD, 0xFFF7F7FB, 0xFFF4F4F7, 0xFFEDEDEF, 0xFFE0E0E1, 0xFFF0F0EF, 0xFFFAFAFF, 0xFF9292A3, 0x68696971, 0x00060606, 0x00000000, 0x00000000, 0x00010101, 0x00090909, 0x005F5F60, 0x00111111, 
        0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x24000000, 0x4D111113, 0x973C3C43, 0xDD6A6A76, 0xFE8E8EA0, 0xFFB0B0C7, 0xFFB8B8CE, 0xFFCDCDDD, 0xFFDCDCE8, 0xFFDCDCE8, 0xFFDFDFE9, 0xFFE1E1EC, 0xFFB3B3C5, 0xE6737380, 0x3F6C6C76, 0x006E6E78, 0x0073737E, 0x0071717B, 0x004E4E55, 
        0x1E131313, 0xD755555F, 0xFFAEAEC1, 0xFFF2F2F9, 0xFFF6F6FB, 0xFFF8F8FC, 0xFFFBFBFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFE9E9F2, 0xFF828291, 0x4465656C, 0x00060606, 0x00000000, 0x00000000, 0x00000000, 0x00080808, 0x00282828, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x01000000, 0x08000000, 0x13000000, 0x2D000000, 0xD35C5C66, 0xFFA7A7BD, 0xFFC4C4D7, 0xFFD6D6E3, 0xFFD9D9E6, 0xFFDBDBE6, 0xFFDCDCE8, 0xFFDFDFEA, 0xFFE0E0EB, 0xFFB5B5C7, 0xFB7D7D8B, 0xA6696974, 0x5D676771, 0x4B676770, 0x756B6B75, 
        0xDA6C6C77, 0xFF9F9FB0, 0xFFE3E3ED, 0xFFF3F3F9, 0xFFF3F3F9, 0xFFF5F5FA, 0xFFF6F6FB, 0xFFE8E8F0, 0xFFE6E6EF, 0xFFECECF3, 0xFFD2D2E1, 0xFC787885, 0x27646469, 0x00030302, 0x00000000, 0x00000000, 0x00090909, 0x00010101, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x44202023, 0xF4787887, 0xFFB6B6CA, 0xFFD6D6E4, 0xFFD6D6E4, 0xFFD7D7E4, 0xFFD9D9E5, 0xFFDBDBE7, 0xFFDDDDE8, 0xFFDFDFEA, 0xFFE2E2ED, 0xFFD1D1E0, 0xFFAFAFBF, 0xFF9696A6, 0xFF90909F, 0xFF9E9EAD, 
        0xFFC2C2D3, 0xFFE8E8F1, 0xFFF1F1F6, 0xFFF0F0F6, 0xFFF1F1F8, 0xFFF5F5FB, 0xFFE8E8F0, 0xFFC7C7D9, 0xFFC7C7D9, 0xFFC8C8D9, 0xFFA5A5BB, 0xE76D6D76, 0x0D636369, 0x00161617, 0x00121213, 0x00353538, 0x00121213, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x03010101, 0xC4595961, 0xFFA2A2B7, 0xFFB9B9CB, 0xFFD1D1DF, 0xFFD4D4E3, 0xFFD5D5E3, 0xFFD8D8E5, 0xFFDADAE6, 0xFFDCDCE7, 0xFFDCDCE8, 0xFFDEDEE9, 0xFFE2E2EC, 0xFFE6E6F0, 0xFFE5E5F0, 0xFFE5E5F0, 0xFFE9E9F3, 
        0xFFEDEDF4, 0xFFECECF3, 0xFFEDEDF3, 0xFFEEEEF4, 0xFFF1F1F7, 0xFFEBEBF3, 0xFFC7C7D8, 0xFFC3C3D7, 0xFFC8C8DA, 0xFFBABAD0, 0xFF7E7E8D, 0x6C606065, 0x0063636A, 0x00636369, 0x006A6A70, 0x0046464A, 0x00010101, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x551F1F22, 0xFF898999, 0xFFB0B0C4, 0xFFAFAFC1, 0xFFBBBBCC, 0xFFD3D3E0, 0xFFD2D2E0, 0xFFCBCBDB, 0xFFC5C5D6, 0xFFD5D5E2, 0xFFDCDCE8, 0xFFDDDDE8, 0xFFDEDEE9, 0xFFE0E0EA, 0xFFE2E2ED, 0xFFE5E5EE, 0xFFE6E6EF, 
        0xFFE7E7F0, 0xFFE8E8F1, 0xFFEAEAF2, 0xFFEDEDF3, 0xFFF0F0F6, 0xFFEAEAF2, 0xFFA5A5B9, 0xFF818190, 0xFF898998, 0xFF868695, 0xB768686E, 0x00616167, 0x0063636A, 0x006B6B70, 0x0059595E, 0x00080808, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x02000000, 0x691F1F21, 0xFF828291, 0xFFAAAABF, 0xFFB2B2C4, 0xFFB0B0C2, 0xFFBFBFD1, 0xFFC2C2D5, 0xFFBABACE, 0xFFB3B3C7, 0xFFBABACD, 0xFFCCCCDA, 0xFFD9D9E6, 0xFFDDDDE8, 0xFFDEDEE9, 0xFFDFDFEA, 0xFFE2E2EC, 0xFFE5E5EE, 
        0xFFE7E7EF, 0xFFE8E8F1, 0xFFE9E9F2, 0xFFEAEAF2, 0xFFEDEDF3, 0xFFF2F2F8, 0xFFCECEDC, 0xFE6D6D77, 0x992E2E2F, 0x69222223, 0x14242425, 0x00616167, 0x0063636B, 0x00262628, 0x00101011, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x03000000, 0x20000000, 0x99333337, 0xFF8B8B9B, 0xFFADADC2, 0xFFB7B7C9, 0xFFBEBED3, 0xFFB9B9CF, 0xFFB4B4C9, 0xFFB9B9CB, 0xFFB7B7C9, 0xFFB8B8CA, 0xFFD3D3E1, 0xFFDBDBE7, 0xFFDCDCE8, 0xFFDEDEE9, 0xFFDEDEE9, 0xFFD9D9E6, 
        0xFFD7D7E4, 0xFFCFCFDD, 0xFFDCDCE7, 0xFFEAEAF2, 0xFFEBEBF3, 0xFFEFEFF5, 0xFFEAEAF3, 0xFF9B9BAC, 0xA449494C, 0x00000000, 0x00000000, 0x00616167, 0x00636369, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x07000000, 0x29000000, 0xBC46464A, 0xFF9595A6, 0xFFAFAFC5, 0xFFA1A1B5, 0xFF848493, 0xFF898998, 0xFFAAAABE, 0xFFB7B7C9, 0xFFBEBED0, 0xFFD1D1E0, 0xFFDADAE6, 0xFFDBDBE7, 0xFFDEDEE8, 0xFFD5D5E3, 0xFFC5C5D7, 
        0xFFC7C7D8, 0xFFBBBBCB, 0xFFBDBDCC, 0xFFD9D9E4, 0xFFE8E8F1, 0xFFDFDFEA, 0xFFC8C8DA, 0xFF8C8C9F, 0xA9606063, 0x00000000, 0x00000000, 0x00626268, 0x00505052, 0x00040404, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x0B000000, 0x3B060606, 0xD758585F, 0xF770707B, 0xBB47474C, 0x701F1F20, 0x912D2D2F, 0xF0696972, 0xFF9D9DB1, 0xFFC2C2D5, 0xFFCECEDC, 0xFFD6D6E3, 0xFFD9D9E5, 0xFFDBDBE7, 0xFFCBCBDB, 0xFFC1C1D5, 
        0xFFB9B9CE, 0xFFBCBCCB, 0xFFBBBBCA, 0xFFBEBECC, 0xFFCFCFDE, 0xFFCDCDDE, 0xFFA3A3B8, 0xEB646469, 0x1D5A5A5B, 0x00000000, 0x00000000, 0x005F5F62, 0x0019191A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x14000000, 0x3C060606, 0x370A0A0A, 0x05000000, 0x00000000, 0x11000000, 0x952C2C2D, 0xFF9292A2, 0xFFC3C3D7, 0xFFC4C4D6, 0xFFC7C7D7, 0xFFCBCBDB, 0xFFCBCBDC, 0xFF9999AD, 0xFF7D7D8A, 
        0xFF797986, 0xFFA3A3B7, 0xFFBDBDCD, 0xFFC5C5D4, 0xFFC3C3D8, 0xFFA3A3B8, 0xFF71717B, 0x5C575758, 0x005B5B5C, 0x00000000, 0x00212122, 0x00343434, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x80212121, 0xFF8C8C9C, 0xFFC5C5D9, 0xFFC9C9D9, 0xFFC8C8D8, 0xFFC9C9D9, 0xFFAEAEC3, 0xFE6A6A73, 0x761B1B1A, 
        0x7D20201F, 0xF766666D, 0xFF9F9FB3, 0xFFB1B1C7, 0xFF888897, 0xE1525255, 0x581D1D1D, 0x0059595C, 0x005B5B5C, 0x00000000, 0x0019191A, 0x00020202, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6C1C1C1C, 0xFF7B7B86, 0xFF9B9BAE, 0xFFA8A8BB, 0xFFB4B4CA, 0xFFBBBBD1, 0xFF858596, 0x9459595A, 0x00121212, 
        0x17000000, 0x63131313, 0xEA5B5B60, 0xFE6A6A71, 0x972F2F2E, 0x1B050504, 0x00000000, 0x0059595C, 0x005F5F60, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x34040404, 0x82232324, 0xAB373738, 0xCF4A4A4E, 0xEA5E5E65, 0xFF72727D, 0xDB626266, 0x105D5D5D, 0x001A1A1A, 
        0x02000000, 0x17000000, 0x48090908, 0x3F0E0E0D, 0x00000000, 0x00000000, 0x00000000, 0x0059595C, 0x00464647, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08000000, 0x0B000000, 0x14000000, 0x24000000, 0x3D050504, 0x5C111110, 0x251B1B1B, 0x005E5E5E, 0x00191919, 
        0x00000000, 0x00000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0059595C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF
#else
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFFA08A8A, 0xFFA28B8B, 0xFFA48C8C, 0xFFA48D8D, 0xFFA48C8C, 0xFFAC9393, 0xFF927E7E, 0xFF383030, 0xFF948080, 0x5AA28B8B, 0x42A28B8B, 0x7C9C8585, 0xB19B8484, 0xDE9C8686, 0xFF9E8989, 0xFF938080, 0xFF928080, 0xFF938181, 0xFF938181, 0xFF928080, 
        0xFF0A0909, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF060505, 0xFF000000, 
        0xFFA08A8A, 0xFFA28B8B, 0xFFA48C8C, 0xB3A18989, 0x3AA78E8E, 0x7FA78F8F, 0xFF937F7F, 0xFF352D2D, 0xBD2C2525, 0x02B59F9F, 0x00E1D4D4, 0x00D3C3C3, 0x00C1AFAF, 0x13AD9898, 0xA09C8787, 0xFF938080, 0xFF928080, 0xFF938181, 0xFF938181, 0xFF928080, 
        0xFF7C6F6F, 0xFF010101, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF040303, 0xFF292323, 0xFF837171, 0xFF000000, 
        0xFFA68F8F, 0xDFA08989, 0x5AA18A8A, 0x00BBA6A6, 0x00E3D5D5, 0x00C2AFAF, 0x5EA18989, 0xD6453B3B, 0x46615151, 0x00D7C4C4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D3C2C2, 0x6B988383, 0xFF938080, 0xFF928080, 0xFF938181, 0xFF938181, 0xFF928080, 
        0xFF8E7F7F, 0xFF736767, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1818, 0xFF9F8989, 0xFF9F8B8B, 0xFF000000, 
        0xD4786767, 0x16AA9393, 0x00D1BFBF, 0x00F5EDED, 0x00FDF8F8, 0x00F7EFEF, 0x00C9B7B7, 0x04AF9B9B, 0x00C4B1B1, 0x00EEE4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D8C9C9, 0x52937E7E, 0xFF938080, 0xFF928080, 0xF0907E7E, 0xC9907E7E, 0xFF928080, 
        0xFF8B7C7C, 0xFF8C7E7E, 0xFF383131, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF958282, 0xFF998686, 0xFD000000, 
        0x50605353, 0x00C7AFAF, 0x00DDCDCD, 0x00F8F3F3, 0x00F8F1F1, 0x00FAF5F5, 0x00F9F3F3, 0x00F9F2F2, 0x00FEFBFB, 0x00FFFCFC, 0x00FFFDFD, 0x00FFFFFF, 0x00FFFFFF, 0x00EBE1E1, 0x07AD9999, 0x688F7C7C, 0x708F7C7C, 0x1DA18E8E, 0x00A79494, 0x8D8E7C7C, 
        0xFF8B7C7C, 0xFF887A7A, 0xFF988686, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF948181, 0xFF998686, 0xD40D0B0B, 
        0x07A49090, 0x00CCB4B4, 0x00C9B3B3, 0x00EAE0E0, 0x00F7F1F1, 0x00F7F1F1, 0x00FAF4F4, 0x00FBF7F7, 0x00FCF9F9, 0x00FEFBFB, 0x00FFFCFC, 0x00FFFDFD, 0x00FFFFFF, 0x00FFFFFF, 0x00F9F5F5, 0x00CFBFBF, 0x00D4C5C5, 0x00F6F0F0, 0x00F1E8E8, 0x03A29090, 
        0xB8877878, 0xFF887A7A, 0xFF8C7D7D, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF0D0B0B, 0xFF1E1A1A, 0xFF000000, 0xFF998585, 0xFF998686, 0xCA100D0D, 
        0x2E7C6C6C, 0x00C5AEAE, 0x00CAB3B3, 0x00E5D9D9, 0x00F5EFEF, 0x00F6EFEF, 0x00F8F1F1, 0x00FBF5F5, 0x00FAF5F5, 0x00F8F3F3, 0x00FAF6F6, 0x00FFFCFC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E6DBDB, 
        0x15988686, 0xD4867777, 0xFF897A7A, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF0A0909, 0xFF756464, 0xFF756464, 0xFF3B3232, 0xFF000000, 0xFF615555, 0xFF443B3B, 0xFF000000, 0xFB786868, 0x51978484, 0x1A9B8888, 
        0x0D9A8787, 0x00B59F9F, 0x00DBCACA, 0x00F2EBEB, 0x00F2EBEB, 0x00F4EEEE, 0x00F6F0F0, 0x00E6DBDB, 0x00D6C8C8, 0x00D2C2C2, 0x00D5C5C5, 0x00DED1D1, 0x00F1E9E9, 0x00FFFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E9E9, 
        0x00AA9797, 0x96827474, 0xFF7C7171, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF010101, 0xFF453B3B, 0xFF968080, 0xFFAD9494, 0xFFAD9494, 0xFFB39999, 0xFF655858, 0xFF000000, 0xFF000000, 0xFF000000, 0xA12B2626, 0x00AF9A9A, 0x00DFCFCF, 
        0x00E9DCDC, 0x00E5D9D9, 0x00ECE2E2, 0x00F0E7E7, 0x00F1E8E8, 0x00F3ECEC, 0x00DDCECE, 0x00C8B2B2, 0x00C8B2B2, 0x00CBB6B6, 0x00CFBBBB, 0x00D1C0C0, 0x00D3C3C3, 0x00E6DCDC, 0x00FEFDFD, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00EEE5E5, 0x00B4A0A0, 
        0x4C857777, 0xF7827575, 0xFF776E6E, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1A1616, 0xFF897575, 0xFFAC9595, 0xFFA88F8F, 0xFFA58D8D, 0xFFA58D8D, 0xFFAA9191, 0xFFAE9696, 0xFF675959, 0xFF000000, 0xFB000000, 0x35746666, 0x00C2ADAD, 0x00E0D3D3, 
        0x00ECE2E2, 0x00ECE2E2, 0x00EDE4E4, 0x00EEE5E5, 0x00F1E9E9, 0x00E6DADA, 0x00B19C9C, 0x118C7C7C, 0x30756767, 0x2A786A6A, 0x07998888, 0x00BEAAAA, 0x00D3C2C2, 0x00D6C8C8, 0x00ECE3E3, 0x00FFFEFE, 0x00FFFFFF, 0x00FFFFFF, 0x00DCCFCF, 0x1A897979, 
        0xF57D7171, 0xFF807373, 0xFF786E6E, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFA08B8B, 0xFFA79090, 0xFFA28C8C, 0xFFA48C8C, 0xFFA58D8D, 0xFFA58D8D, 0xFFAA9191, 0xFFA48E8E, 0xFFA08A8A, 0xFF000000, 0xB41C1818, 0x079B8989, 0x00C3AFAF, 0x00DED0D0, 
        0x00E9DEDE, 0x00EAE0E0, 0x00EBE0E0, 0x00EDE3E3, 0x00F1E8E8, 0x00D7C7C7, 0x2F7E6E6E, 0xD6030303, 0xEB000000, 0xDD000000, 0xB3131111, 0x4C564D4D, 0x00AA9797, 0x00D4C2C2, 0x00DFD3D3, 0x00FBF6F6, 0x00FFFEFE, 0x00FFFFFF, 0x00F3ECEC, 0x0E918080, 
        0xBB736969, 0xFF786D6D, 0xFF786E6E, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFFA18C8C, 0xFFA28B8B, 0xFFA28C8C, 0xFFA48C8C, 0xB8A38B8B, 0x82A28A8A, 0xF7AA9191, 0xFFA48E8E, 0xFF988383, 0xFB000000, 0x36605353, 0x00A89595, 0x00C7B1B1, 0x00CCB7B7, 
        0x00D3C0C0, 0x00E1D3D3, 0x00E9DFDF, 0x00EBE1E1, 0x00F0E7E7, 0x00CFBDBD, 0x53857676, 0xFF504949, 0xFF000000, 0xFF000000, 0xF8000000, 0xDD000000, 0x59474040, 0x00B3A0A0, 0x00DDCFCF, 0x00F5EEEE, 0x00FFFDFD, 0x00FFFEFE, 0x00FEFBFB, 0x00D7CACA, 
        0x00A39494, 0x38827575, 0x9D786E6E, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF2E2828, 0xFF000000, 0xFFA08B8B, 0xFFA28B8B, 0xE6A18B8B, 0x66A08888, 0x00B29B9B, 0x00BBA6A6, 0x40A28B8B, 0xE5A48D8D, 0xFF988383, 0xBB1C1818, 0x00857373, 0x00A59191, 0x00CDB5B5, 0x00CEB7B7, 
        0x00CAB4B4, 0x00D2BDBD, 0x00E8DCDC, 0x00E9DEDE, 0x00EDE3E3, 0x00DCCDCD, 0x208C7D7D, 0xF7837878, 0xFF595050, 0xFF2C2929, 0xFF000000, 0xF9000000, 0xC9040404, 0x1C786B6B, 0x00D3C1C1, 0x00F5EFEF, 0x00FEFBFB, 0x00FEFBFB, 0x00FFFDFD, 0x00FFFFFF, 
        0x00FFFCFC, 0x00D7C9C9, 0x13807373, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF120F0F, 0xFF5C4F4F, 0xFF594D4D, 0xFF000000, 0xFFA48E8E, 0x9D9F8989, 0x1BA58F8F, 0x00C3B0B0, 0x00EDE2E2, 0x00F4ECEC, 0x00C7B3B3, 0x28A18B8B, 0x8F968080, 0x31776565, 0x00968585, 0x009A8F8F, 0x009C8B8B, 0x00B29D9D, 
        0x00C9B3B3, 0x00CEB9B9, 0x00E2D4D4, 0x00E8DDDD, 0x00E9DFDF, 0x00EBE0E0, 0x00B3A1A1, 0x72786C6C, 0xFF7E7272, 0xFF7F7575, 0xFF5E5757, 0xFF201D1D, 0xF5000000, 0x43504848, 0x00CBB8B8, 0x00FBF5F5, 0x00FCF8F8, 0x00FCF9F9, 0x00FFFCFC, 0x00FFFEFE, 
        0x00FFFFFF, 0x00DBCFCF, 0x3B796D6D, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF332C2C, 0xFFA48F8F, 0xFF000000, 0xFF000000, 0xA4837171, 0x00AF9898, 0x00D6C4C4, 0x00F7F0F0, 0x00FAF5F5, 0x00FBF6F6, 0x00F8F0F0, 0x00CFBDBD, 0x00BFACAC, 0x00D5C4C4, 0x00D5CCCC, 0x00D6D5D5, 0x00BCB9B9, 0x00978E8E, 
        0x00AF9A9A, 0x00D3BFBF, 0x00E2D4D4, 0x00E7DBDB, 0x00E8DCDC, 0x00EBE0E0, 0x00E6D9D9, 0x00A99898, 0x57776C6C, 0xC5716868, 0xED766D6D, 0xDF756B6B, 0x81453F3F, 0x098E8080, 0x00E6DADA, 0x00FBF5F5, 0x00FAF5F5, 0x00FCF8F8, 0x00F9F4F4, 0x00F9F4F4, 
        0x00FCFAFA, 0x00C8B8B8, 0x5D6F6666, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF958282, 0xFF000000, 0xF3050505, 0x26806F6F, 0x00C8AFAF, 0x00D4C0C0, 0x00F4EDED, 0x00F7F1F1, 0x00F8F2F2, 0x00FAF5F5, 0x00FAF4F4, 0x00FCF6F6, 0x00FFFDFD, 0x00FFFFFF, 0x00FFFFFF, 0x00F0EFEF, 0x00979090, 
        0x00B29F9F, 0x00E2D4D4, 0x00E4D7D7, 0x00E5D8D8, 0x00E6DBDB, 0x00E7DCDC, 0x00EBE0E0, 0x00EADDDD, 0x00C8B8B8, 0x00A09292, 0x148F8282, 0x0A948686, 0x00BBABAB, 0x00E9DDDD, 0x00F8F2F2, 0x00F7F1F1, 0x00F9F3F3, 0x00F8F2F2, 0x00DFD1D1, 0x00DCCBCB, 
        0x00DECDCD, 0x00A89696, 0x83696363, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF968383, 0xFF000000, 0xA3312A2A, 0x00B8A1A1, 0x00CAB3B3, 0x00C7B0B0, 0x00E2D5D5, 0x00F6F1F1, 0x00F7F0F0, 0x00F8F2F2, 0x00FAF4F4, 0x00FBF6F6, 0x00FCF8F8, 0x00FDFAFA, 0x00FFFFFF, 0x00C4C0C0, 0x00948383, 
        0x00C9B6B6, 0x00DFD1D1, 0x00E3D5D5, 0x00E4D7D7, 0x00E6DADA, 0x00E7DBDB, 0x00E8DCDC, 0x00EADFDF, 0x00EFE5E5, 0x00EFE3E3, 0x00EBDFDF, 0x00EEE3E3, 0x00F5ECEC, 0x00F5EEEE, 0x00F3EDED, 0x00F6EFEF, 0x00F8F1F1, 0x00E0D3D3, 0x00D5C1C1, 0x00DCC9C9, 
        0x00C7B1B1, 0x187A6F6F, 0xE0666161, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF968383, 0xFF000000, 0xB8141212, 0x0D9F8B8B, 0x00CAB2B2, 0x00C7B0B0, 0x00D7C5C5, 0x00F4EDED, 0x00F5EFEF, 0x00F7F0F0, 0x00F8F2F2, 0x00FAF4F4, 0x00FCF8F8, 0x00FFFCFC, 0x00F2F0F0, 0x00908787, 0x00B5A0A0, 
        0x00C3B1B1, 0x00CBB9B9, 0x00DFD1D1, 0x00DECECE, 0x00D4C3C3, 0x00DBCCCC, 0x00E7DBDB, 0x00E8DDDD, 0x00E9DEDE, 0x00EBE1E1, 0x00EEE5E5, 0x00EFE6E6, 0x00F0E7E7, 0x00F1E9E9, 0x00F2EBEB, 0x00F4EDED, 0x00F8F2F2, 0x00D3C2C2, 0x00908080, 0x05887B7B, 
        0x08807575, 0xAC646060, 0xFF666161, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xE3968383, 0x72615555, 0x5F594D4D, 0x17847272, 0x00B49D9D, 0x00CEB8B8, 0x00EBE1E1, 0x00F3ECEC, 0x00F3EDED, 0x00F5EFEF, 0x00F8F2F2, 0x00F5EEEE, 0x00E9DEDE, 0x00E3D7D7, 0x00C2B7B7, 0x00897F7F, 0x00A08E8E, 
        0x00C5B2B2, 0x00C4B3B3, 0x00D2BFBF, 0x00D4BFBF, 0x00CAB7B7, 0x00C8B5B5, 0x00D1C1C1, 0x00E4D7D7, 0x00E8DDDD, 0x00E9DEDE, 0x00EAE0E0, 0x00EDE3E3, 0x00EEE4E4, 0x00EDE3E3, 0x00F1E9E9, 0x00F3EBEB, 0x00F5EFEF, 0x00F3EAEA, 0x00988B8B, 0x712E2D2D, 
        0xD80E0E0E, 0xFF656161, 0xFF666161, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0x59756666, 0x00C0A9A9, 0x00D1BDBD, 0x00C9B7B7, 0x00CAB7B7, 0x00E0D3D3, 0x00F2E9E9, 0x00F1E8E8, 0x00F2EBEB, 0x00F5EFEF, 0x00EAE1E1, 0x00D2C0C0, 0x00CAB7B7, 0x00CDBABA, 0x00C3B2B2, 0x00A19595, 0x00807777, 
        0x00A99797, 0x00CEB8B8, 0x00C7B1B1, 0x00AE9A9A, 0x00BFABAB, 0x00CCBABA, 0x00CAB9B9, 0x00E0D1D1, 0x00E7DBDB, 0x00E8DCDC, 0x00E9DDDD, 0x00E0D1D1, 0x00DCCDCD, 0x00D3C2C2, 0x00DED2D2, 0x00F2E9E9, 0x00F3EBEB, 0x00F0E6E6, 0x00BAA8A8, 0x4F625E5E, 
        0xFF000000, 0xFF656161, 0xFF666161, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xCC171515, 0x039A8787, 0x00CAB4B4, 0x00EADFDF, 0x00EEE4E4, 0x00EFE5E5, 0x00EEE5E5, 0x00EFE6E6, 0x00F0E7E7, 0x00F2EAEA, 0x00EBE1E1, 0x00CBB6B6, 0x00C1ABAB, 0x00BEA9A9, 0x00BEA9A9, 0x00C8B2B2, 0x00BEACAC, 0x009C9191, 
        0x00817777, 0x00928181, 0x00857B7B, 0x008B8686, 0x00877C7C, 0x00AD9A9A, 0x00D2BEBE, 0x00DED0D0, 0x00E6DADA, 0x00E7DCDC, 0x00E5D9D9, 0x00DAC8C8, 0x00D7C3C3, 0x00CCBCBC, 0x00C9BABA, 0x00DBCFCF, 0x00E6D9D9, 0x00D5C0C0, 0x00887A7A, 0xAD5C5B5B, 
        0xFF000000, 0xFF656161, 0xFF666262, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0x67514747, 0x00BAA4A4, 0x00CBB8B8, 0x00E9DEDE, 0x00E9DFDF, 0x00EAE0E0, 0x00ECE2E2, 0x00EEE4E4, 0x00EFE6E6, 0x00F2E9E9, 0x00D4C2C2, 0x009D8989, 0x29736666, 0x52554B4B, 0x54544B4B, 0x316D6060, 0x029B8989, 0x00A69494, 
        0x00998D8D, 0x009E9494, 0x00CABFBF, 0x00E0DEDE, 0x00ACADAD, 0x00857979, 0x00D2BDBD, 0x00D8C7C7, 0x00DACACA, 0x00E1D2D2, 0x00D0BDBD, 0x00A59494, 0x00998A8A, 0x00BEABAB, 0x00CEC0C0, 0x00D7C7C7, 0x00D4BFBF, 0x009F8E8E, 0x645C5A5A, 0xFF5B5A5A, 
        0xFF000000, 0xFF6A6666, 0xFF4D4C4C, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xF5000000, 0x3A6B5F5F, 0x00BEA9A9, 0x00CCB9B9, 0x00E6DADA, 0x00E9DFDF, 0x00EADFDF, 0x00EAE0E0, 0x00ECE2E2, 0x00EEE5E5, 0x00EFE5E5, 0x00C0ADAD, 0x4B6A5E5E, 0xEA000000, 0xF5000000, 0xEE000000, 0xDA000000, 0xA31D1A1A, 0x2E6A5F5F, 
        0x00AC9898, 0x00D8C7C7, 0x00E0D4D4, 0x00F5EFEF, 0x00C9C9C9, 0x00827878, 0x00D1BBBB, 0x00DBCACA, 0x00D9C9C9, 0x00D8C5C5, 0x00A18F8F, 0x63303030, 0x881C1D1D, 0x0C726969, 0x00BDA9A9, 0x00BDAAAA, 0x047A7070, 0x75323232, 0xF7595858, 0xFF5B5A5A, 
        0xFF000000, 0xFF242424, 0xFF0A0A0A, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xE0030303, 0x247C6E6E, 0x00C1ACAC, 0x00C8B3B3, 0x00CFBABA, 0x00D8C7C7, 0x00E3D6D6, 0x00E9DFDF, 0x00EAE0E0, 0x00EDE3E3, 0x00EDE3E3, 0x00B4A2A2, 0x7B807373, 0xFF262323, 0xFF000000, 0xFF000000, 0xFD000000, 0xF1000000, 0xC9060606, 
        0x33655B5B, 0x00B5A1A1, 0x00DBCDCD, 0x00EEE6E6, 0x00D3D0D0, 0x007B7575, 0x008F7F7F, 0x00A49292, 0x00BAA7A7, 0x00B5A0A0, 0x016E6666, 0x724F4949, 0xDA0E0C0C, 0xA6101111, 0x1C5D5858, 0x384F4B4B, 0xC30F1010, 0xFF040404, 0xFF5A5959, 0xFF5C5B5B, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xC3110F0F, 0x0D8F7E7E, 0x00CAB3B3, 0x00CDB7B7, 0x00CBB5B5, 0x00C9B3B3, 0x00D3BEBE, 0x00E8DDDD, 0x00E9DEDE, 0x00EBE0E0, 0x00EEE4E4, 0x00C2AFAF, 0x48807373, 0xFF857979, 0xFF464040, 0xFF1A1818, 0xFF000000, 0xFF000000, 0xF3000000, 
        0xAD121111, 0x0A887979, 0x00CEBBBB, 0x00EFE6E6, 0x00E3E0E0, 0x00BCBABA, 0x00A09F9F, 0x008D8B8B, 0x00807C7C, 0x007B7676, 0x00B8B0B0, 0x00AB9999, 0x7C605959, 0xF8000000, 0xD7010202, 0xF9000000, 0xFF000000, 0xFF090909, 0xFF5A5959, 0xFF5C5B5B, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xB9131111, 0x13847575, 0x00B5A1A1, 0x00C3ADAD, 0x00CBB4B4, 0x00CCB6B6, 0x00CFBABA, 0x00E3D6D6, 0x00E8DEDE, 0x00E9DEDE, 0x00ECE2E2, 0x00DDCECE, 0x05918181, 0xBF7A6F6F, 0xFF837777, 0xFF7B7070, 0xFF4D4747, 0xFF221F1F, 0xFF000000, 
        0xE8000000, 0x3E564D4D, 0x00BDAAAA, 0x00F1E9E9, 0x00FDF9F9, 0x00FBF7F7, 0x00F7F4F4, 0x00EFEDED, 0x00E1E0E0, 0x00EFF0F0, 0x00FFFAFA, 0x00A39292, 0x97716969, 0xFF060606, 0xFF000000, 0xFF000000, 0xFF010101, 0xFF090909, 0xFF605F5F, 0xFF111111, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xDB000000, 0xB2131111, 0x68433C3C, 0x22766A6A, 0x01A08E8E, 0x00C7B0B0, 0x00CEB8B8, 0x00DDCDCD, 0x00E8DCDC, 0x00E8DCDC, 0x00E9DFDF, 0x00ECE1E1, 0x00C5B3B3, 0x19807373, 0xC0766C6C, 0xFF786E6E, 0xFF7E7373, 0xFF7B7171, 0xFF554E4E, 
        0xE1131313, 0x285F5555, 0x00C1AEAE, 0x00F9F2F2, 0x00FBF6F6, 0x00FCF8F8, 0x00FFFBFB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E9E9, 0x00918282, 0xBB6C6565, 0xFF060606, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF080808, 0xFF282828, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFE000000, 0xF7000000, 0xEC000000, 0xD2000000, 0x2C665C5C, 0x00BDA7A7, 0x00D7C4C4, 0x00E3D6D6, 0x00E6D9D9, 0x00E6DBDB, 0x00E8DCDC, 0x00EADFDF, 0x00EBE0E0, 0x00C7B5B5, 0x048B7D7D, 0x59746969, 0xA2716767, 0xB4706767, 0x8A756B6B, 
        0x25776C6C, 0x00B09F9F, 0x00EDE3E3, 0x00F9F3F3, 0x00F9F3F3, 0x00FAF5F5, 0x00FBF6F6, 0x00F0E8E8, 0x00EFE6E6, 0x00F3ECEC, 0x00E1D2D2, 0x03857878, 0xD8696464, 0xFF020303, 0xFF000000, 0xFF000000, 0xFF090909, 0xFF010101, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xBB232020, 0x0B877878, 0x00CAB6B6, 0x00E4D6D6, 0x00E4D6D6, 0x00E4D7D7, 0x00E5D9D9, 0x00E7DBDB, 0x00E8DDDD, 0x00EADFDF, 0x00EDE2E2, 0x00E0D1D1, 0x00BFAFAF, 0x00A69696, 0x009F9090, 0x00AD9E9E, 
        0x00D3C2C2, 0x00F1E8E8, 0x00F6F1F1, 0x00F6F0F0, 0x00F8F1F1, 0x00FBF5F5, 0x00F0E8E8, 0x00D9C7C7, 0x00D9C7C7, 0x00D9C8C8, 0x00BBA5A5, 0x18766D6D, 0xF2696363, 0xFF171616, 0xFF131212, 0xFF383535, 0xFF131212, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFC010101, 0x3B615959, 0x00B7A2A2, 0x00CBB9B9, 0x00DFD1D1, 0x00E3D4D4, 0x00E3D5D5, 0x00E5D8D8, 0x00E6DADA, 0x00E7DCDC, 0x00E8DCDC, 0x00E9DEDE, 0x00ECE2E2, 0x00F0E6E6, 0x00F0E5E5, 0x00F0E5E5, 0x00F3E9E9, 
        0x00F4EDED, 0x00F3ECEC, 0x00F3EDED, 0x00F4EEEE, 0x00F7F1F1, 0x00F3EBEB, 0x00D8C7C7, 0x00D7C3C3, 0x00DAC8C8, 0x00D0BABA, 0x008D7E7E, 0x93656060, 0xFF6A6363, 0xFF696363, 0xFF706A6A, 0xFF4A4646, 0xFF010101, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xAA221F1F, 0x00998989, 0x00C4B0B0, 0x00C1AFAF, 0x00CCBBBB, 0x00E0D3D3, 0x00E0D2D2, 0x00DBCBCB, 0x00D6C5C5, 0x00E2D5D5, 0x00E8DCDC, 0x00E8DDDD, 0x00E9DEDE, 0x00EAE0E0, 0x00EDE2E2, 0x00EEE5E5, 0x00EFE6E6, 
        0x00F0E7E7, 0x00F1E8E8, 0x00F2EAEA, 0x00F3EDED, 0x00F6F0F0, 0x00F2EAEA, 0x00B9A5A5, 0x00908181, 0x00988989, 0x00958686, 0x486E6868, 0xFF676161, 0xFF6A6363, 0xFF706B6B, 0xFF5E5959, 0xFF080808, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFD000000, 0x96211F1F, 0x00918282, 0x00BFAAAA, 0x00C4B2B2, 0x00C2B0B0, 0x00D1BFBF, 0x00D5C2C2, 0x00CEBABA, 0x00C7B3B3, 0x00CDBABA, 0x00DACCCC, 0x00E6D9D9, 0x00E8DDDD, 0x00E9DEDE, 0x00EADFDF, 0x00ECE2E2, 0x00EEE5E5, 
        0x00EFE7E7, 0x00F1E8E8, 0x00F2E9E9, 0x00F2EAEA, 0x00F3EDED, 0x00F8F2F2, 0x00DCCECE, 0x01776D6D, 0x662F2E2E, 0x96232222, 0xEB252424, 0xFF676161, 0xFF6B6363, 0xFF282626, 0xFF111010, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFC000000, 0xDF000000, 0x66373333, 0x009B8B8B, 0x00C2ADAD, 0x00C9B7B7, 0x00D3BEBE, 0x00CFB9B9, 0x00C9B4B4, 0x00CBB9B9, 0x00C9B7B7, 0x00CAB8B8, 0x00E1D3D3, 0x00E7DBDB, 0x00E8DCDC, 0x00E9DEDE, 0x00E9DEDE, 0x00E6D9D9, 
        0x00E4D7D7, 0x00DDCFCF, 0x00E7DCDC, 0x00F2EAEA, 0x00F3EBEB, 0x00F5EFEF, 0x00F3EAEA, 0x00AC9B9B, 0x5B4C4949, 0xFF000000, 0xFF000000, 0xFF676161, 0xFF696363, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xF8000000, 0xD6000000, 0x434A4646, 0x00A69595, 0x00C5AFAF, 0x00B5A1A1, 0x00938484, 0x00988989, 0x00BEAAAA, 0x00C9B7B7, 0x00D0BEBE, 0x00E0D1D1, 0x00E6DADA, 0x00E7DBDB, 0x00E8DEDE, 0x00E3D5D5, 0x00D7C5C5, 
        0x00D8C7C7, 0x00CBBBBB, 0x00CCBDBD, 0x00E4D9D9, 0x00F1E8E8, 0x00EADFDF, 0x00DAC8C8, 0x009F8C8C, 0x56636060, 0xFF000000, 0xFF000000, 0xFF686262, 0xFF525050, 0xFF040404, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xF4000000, 0xC4060606, 0x285F5858, 0x087B7070, 0x444C4747, 0x8F201F1F, 0x6E2F2D2D, 0x0F726969, 0x00B19D9D, 0x00D5C2C2, 0x00DCCECE, 0x00E3D6D6, 0x00E5D9D9, 0x00E7DBDB, 0x00DBCBCB, 0x00D5C1C1, 
        0x00CEB9B9, 0x00CBBCBC, 0x00CABBBB, 0x00CCBEBE, 0x00DECFCF, 0x00DECDCD, 0x00B8A3A3, 0x14696464, 0xE25B5A5A, 0xFF000000, 0xFF000000, 0xFF625F5F, 0xFF1A1919, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEB000000, 0xC3060606, 0xC80A0A0A, 0xFA000000, 0xFF000000, 0xEE000000, 0x6A2D2C2C, 0x00A29292, 0x00D7C3C3, 0x00D6C4C4, 0x00D7C7C7, 0x00DBCBCB, 0x00DCCBCB, 0x00AD9999, 0x008A7D7D, 
        0x00867979, 0x00B7A3A3, 0x00CDBDBD, 0x00D4C5C5, 0x00D8C3C3, 0x00B8A3A3, 0x007B7171, 0xA3585757, 0xFF5C5B5B, 0xFF000000, 0xFF222121, 0xFF343434, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x7F212121, 0x009C8C8C, 0x00D9C5C5, 0x00D9C9C9, 0x00D8C8C8, 0x00D9C9C9, 0x00C3AEAE, 0x01736A6A, 0x891A1B1B, 
        0x821F2020, 0x086D6666, 0x00B39F9F, 0x00C7B1B1, 0x00978888, 0x1E555252, 0xA71D1D1D, 0xFF5C5959, 0xFF5C5B5B, 0xFF000000, 0xFF1A1919, 0xFF020202, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x931C1C1C, 0x00867B7B, 0x00AE9B9B, 0x00BBA8A8, 0x00CAB4B4, 0x00D1BBBB, 0x00968585, 0x6B5A5959, 0xFF121212, 
        0xE8000000, 0x9C131313, 0x15605B5B, 0x01716A6A, 0x682E2F2F, 0xE4040505, 0xFF000000, 0xFF5C5959, 0xFF605F5F, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xCB040404, 0x7D242323, 0x54383737, 0x304E4A4A, 0x15655E5E, 0x007D7272, 0x24666262, 0xEF5D5D5D, 0xFF1A1A1A, 
        0xFD000000, 0xE8000000, 0xB7080909, 0xC00D0E0E, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF5C5959, 0xFF474646, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF7000000, 0xF4000000, 0xEB000000, 0xDB000000, 0xC2040505, 0xA3101111, 0xDA1B1B1B, 0xFF5E5E5E, 0xFF191919, 
        0xFF000000, 0xFF000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF5C5959, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF
#endif
};

GUI_CONST_STORAGE GUI_BITMAP _bmSystem = {
  48, // XSize */
  48, // YSize */
  192, // BytesPerLine */
  32, // BitsPerPixel */
  (unsigned char *)_acSystem,  // Pointer to picture data */
  NULL,  // Pointer to palette */
#if (GUI_USE_ARGB == 1)
  GUI_DRAW_BMPM8888I
#else
  GUI_DRAW_BMP8888
#endif
};

/*********************************************************************
*
*       _bmWrite
*
* Function description
*   Icon bitmap with alpha channel
*/
static GUI_CONST_STORAGE unsigned long _acWrite[] = {
#if (GUI_USE_ARGB == 1)
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x0A7C0000, 0xB2730000, 0xF46D0101, 0xF3720607, 0xF36F0000, 0xF36D0001, 0xF36C0002, 0xF26B0003, 0xE86B0003, 0xE66A0003, 0xE66A0004, 0xE66A0004, 0xE66A0005, 0xE66A0006, 0xE7690006, 0xE3680007, 0xDA690006, 0xDA690007, 0xDA680008, 0xDA680009, 
        0xDA68000A, 0xDA68000B, 0xD966000B, 0xCE64000A, 0xCD650009, 0xCD64000A, 0xCE64000C, 0xC562000C, 0x7C590006, 0x19190000, 0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x61780000, 0xFF6F0000, 0xFF5C0000, 0xFF84464A, 0xFFBD5C68, 0xFFC34952, 0xFFBC4D55, 0xFFB7565E, 0xFFBA5D65, 0xFFBD636B, 0xFFBD6770, 0xFFBE6971, 0xFFC06B74, 0xFFC06E77, 0xFFBA6F78, 0xFFBA7079, 0xFFBC727B, 0xFFBD757D, 0xFFBE767E, 0xFFBF727B, 
        0xFFC0747C, 0xFFC07680, 0xFFBA747E, 0xFFBB757F, 0xFFBC777F, 0xFFBE7981, 0xFFBF7C85, 0xFFBC7782, 0xFF8C2448, 0xCF5C000E, 0x44300000, 0x0C000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0xB2760000, 0xFF740201, 0xFF7B0203, 0xFF41143E, 0xFF805268, 0xFFD97A8D, 0xFFF26674, 0xFFEF5B66, 0xFFEE616D, 0xFFEF6773, 0xFFEF6E7A, 0xFFF07984, 0xFFF1848F, 0xFFF2939D, 0xFFF39DA7, 0xFFF4A4AD, 0xFFF4A8B1, 0xFFF6ABB3, 0xFFF7AEB6, 0xFFF8B3BA, 
        0xFFF8B6BC, 0xFFF9BAC0, 0xFFFABEC4, 0xFFFBC2C7, 0xFFFCC4CA, 0xFFFDC7CB, 0xFFFDCBCF, 0xFFFEEBEE, 0xFFF7E1E0, 0xFFBB6E80, 0xF66D0225, 0x984E0006, 0x1C0B0000, 0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0xED7B0000, 0xFF750200, 0xFF7E080D, 0xFF162596, 0xFF606799, 0xFF7A4A54, 0xFFB26071, 0xFFEA6878, 0xFFEE505B, 0xFFEA515B, 0xFFEA555F, 0xFFEB555F, 0xFFEC5862, 0xFFED5D66, 0xFFED666F, 0xFFEE717A, 0xFFEF818A, 0xFFF08F96, 0xFFF1969D, 0xFFF19CA2, 
        0xFFF29EA5, 0xFFF2A1A7, 0xFFF4A4AA, 0xFFF5A8AD, 0xFFF5AAAF, 0xFFF5AEB3, 0xFFF6AEB3, 0xFFF6C0C5, 0xFFFBE9EB, 0xFFFFEDE9, 0xFFDC9FA6, 0xFF8B1D43, 0xCE580011, 0x432E0000, 0x0B000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x14740000, 0x31720000, 0x0A3D0000, 0x02000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0xD5770000, 0xFF760201, 0xFF840D0A, 0xFF1D1A7D, 0xFF5B86D9, 0xFF94ADC2, 0xFF705F76, 0xFF955263, 0xFFD46A7A, 0xFFEF5C68, 0xFFEC4D56, 0xFFEC535D, 0xFFED555E, 0xFFED565F, 0xFFEE575F, 0xFFEF5860, 0xFFF05C63, 0xFFF1636B, 0xFFF16F76, 0xFFF17D83, 
        0xFFF28A90, 0xFFF3959B, 0xFFF49AA0, 0xFFF59EA3, 0xFFF5A0A5, 0xFFF6A4A9, 0xFFF7A6AA, 0xFFF7AFB3, 0xFFF9D4D7, 0xFFFFD1D1, 0xFFFFE2E0, 0xFFF6C8C4, 0xFFB55A75, 0xF06E0425, 0x88470006, 0x1A100000, 0x04000000, 0x00000000, 0x00000000, 0x51760000, 
        0xDC7A0302, 0xFF7E0502, 0xCA6D0000, 0x4D4B0000, 0x0D000000, 0x01000000, 0x00000000,
  0x00FFFFFF, 0x956C0000, 0xFF750000, 0xFF8C130B, 0xFF43185C, 0xFF3766CF, 0xFFA4C0D8, 0xFF8CB8DE, 0xFF7B84A1, 0xFF78495C, 0xFFB86375, 0xFFED6573, 0xFFF04C55, 0xFFED4E56, 0xFFED525A, 0xFFEF545C, 0xFFEF565D, 0xFFF1575E, 0xFFF1585F, 0xFFF1595F, 0xFFF25B61, 
        0xFFF36066, 0xFFF46E73, 0xFFF57E83, 0xFFF58C90, 0xFFF69599, 0xFFF7999D, 0xFFF89C9F, 0xFFF99FA2, 0xFFF9BEC1, 0xFFFEBDBD, 0xFFFFBFBF, 0xFFFFCCCC, 0xFFFFD8D4, 0xFFDF9199, 0xFF8A1745, 0xCA570014, 0x412E0001, 0x0D120000, 0x81730000, 0xFD7B1015, 
        0xFFB47057, 0xFFED7F20, 0xFFA32705, 0xED6E0000, 0x57300000, 0x12000000, 0x01000000,
  0x00FFFFFF, 0x5F650000, 0xFF770000, 0xFF800E0A, 0xFF771530, 0xFF1F4AC2, 0xFFA0B9D5, 0xFF90B3D5, 0xFF93BBDE, 0xFF8DADCF, 0xFF785C75, 0xFF9D576A, 0xFFDF6979, 0xFFF2535C, 0xFFF04951, 0xFFEF4F56, 0xFFF15158, 0xFFF15359, 0xFFF1545B, 0xFFF2565C, 0xFFF3585E, 
        0xFFF4595F, 0xFFF55A5F, 0xFFF55C61, 0xFFF66368, 0xFFF77276, 0xFFF88286, 0xFFF98D90, 0xFFF99194, 0xFFF9A9AC, 0xFFFDAFB0, 0xFFFFA5A5, 0xFFFFAEAE, 0xFFFFB6B6, 0xFFFFC8C5, 0xFFF6AFAE, 0xFFB3486C, 0xE96A0224, 0xCA670000, 0xFF932301, 0xFFB6A09F, 
        0xFFDBD2C7, 0xFFFFA634, 0xFFFD8817, 0xFFA72805, 0xDA610000, 0x3E0A0000, 0x0C000000,
  0x00FFFFFF, 0x27520000, 0xF4790000, 0xFF720604, 0xFF91181D, 0xFF1D34B3, 0xFF7FA2D9, 0xFF9AB9D4, 0xFF91B4D6, 0xFF97BADC, 0xFF98BDDF, 0xFF888FAC, 0xFF844D64, 0xFFBE6376, 0xFFEE626F, 0xFFF4474E, 0xFFF14950, 0xFFF14D54, 0xFFF34F55, 0xFFF35057, 0xFFF45359, 
        0xFFF5555A, 0xFFF5575B, 0xFFF6595D, 0xFFF75A5E, 0xFFF75A5E, 0xFFF85E61, 0xFFF96669, 0xFFF97174, 0xFFFA8D8F, 0xFFFC9E9F, 0xFFFF8A8A, 0xFFFF9191, 0xFFFF9999, 0xFFFFA4A4, 0xFFFFB6B5, 0xFFD17276, 0xFF80060B, 0xFFB95900, 0xFFF9C51F, 0xFFE9E7D1, 
        0xFFE8EDFB, 0xFFF6BD72, 0xFFFF9A1E, 0xFFF47C15, 0xFF8C1001, 0xAB490000, 0x29000000,
  0x00FFFFFF, 0x06000000, 0xC2710000, 0xFF720101, 0xFF971E17, 0xFF372C9B, 0xFF5087F1, 0xFFA6BFD3, 0xFF93B5D7, 0xFF97B7D8, 0xFF9ABADA, 0xFF9FC4E4, 0xFF96ADCC, 0xFF856C87, 0xFFA0586E, 0xFFDC6777, 0xFFF5555F, 0xFFF3464C, 0xFFF24A51, 0xFFF44C51, 0xFFF54D52, 
        0xFFF54E54, 0xFFF65155, 0xFFF75357, 0xFFF85659, 0xFFF9575A, 0xFFF9585B, 0xFFF9595C, 0xFFFA5A5C, 0xFFFB6365, 0xFFFC7678, 0xFFFF5353, 0xFFFF6868, 0xFFFF7C7C, 0xFFF67B7C, 0xFFAA323D, 0xFF891501, 0xFFD38403, 0xFFFFE043, 0xFFFFEE9A, 0xFFF8EDC8, 
        0xFFD6DBED, 0xFFCBBDB8, 0xFFF5A742, 0xFFFF9B1E, 0xFFBE440A, 0xE6620000, 0x52000000,
  0x00FFFFFF, 0x01000000, 0x81680000, 0xFF740000, 0xFF932117, 0xFF612D75, 0xFF377AFF, 0xFFB0C9DE, 0xFF95B5D5, 0xFF99B8D8, 0xFF9BBBDA, 0xFF9EBDDB, 0xFFA3C3E1, 0xFFA5CBE8, 0xFF9193B0, 0xFF8A536D, 0xFFBF667B, 0xFFF1616C, 0xFFF54A4F, 0xFFF5494E, 0xFFF74A4E, 
        0xFFF74A4E, 0xFFF84B4E, 0xFFFA4C4F, 0xFFFB4D50, 0xFFFB5052, 0xFFFB5253, 0xFFFD5454, 0xFFFE5556, 0xFFFE5757, 0xFFFF6161, 0xFFFF2422, 0xFFFF201F, 0xFFE63337, 0xFF8E0D16, 0xFF993200, 0xFFF0B60E, 0xFFFFEB6A, 0xFFFFF1B8, 0xFFFFEEA8, 0xFFFFDE56, 
        0xFFD2C085, 0xFFA7AED8, 0xFFB7A8A5, 0xFFF4A94A, 0xFFDE6E1C, 0xF9750000, 0x73000000,
  0x00FFFFFF, 0x00000000, 0x4C600000, 0xFE790000, 0xFF7D0F0A, 0xFF832D50, 0xFF2362F8, 0xFFB9D7F9, 0xFF9DBCD8, 0xFF99B9D8, 0xFF9DBCDB, 0xFFA0BFDD, 0xFFA3C1DE, 0xFFA5C3E0, 0xFFABCEE9, 0xFFA4BAD8, 0xFF8B6A87, 0xFFAA5F78, 0xFFDF6776, 0xFFE95D67, 0xFFE85D67, 
        0xFFEB5F69, 0xFFEB5F69, 0xFFED5F6A, 0xFFEE5F6A, 0xFFEF5E67, 0xFFF25F66, 0xFFF25F66, 0xFFF26167, 0xFFF36167, 0xFFF47178, 0xFFF14F5E, 0xFFCB0A14, 0xFF830000, 0xFFB15A00, 0xFFFED628, 0xFFFFEE8B, 0xFFFFF1B9, 0xFFFFE991, 0xFFFFD940, 0xFFFFCD00, 
        0xFFFCCC08, 0xFFCCBA80, 0xFFA3ABC0, 0xFF968D9D, 0xFF8F2F25, 0xEF640000, 0x80000000,
  0x00FFFFFF, 0x00000000, 0x1A4B0000, 0xEB770000, 0xFF730806, 0xFF99272D, 0xFF2647D1, 0xFF8EBCFF, 0xFFB7D7EF, 0xFF9AB9D8, 0xFF9FBDDB, 0xFF9EBBD8, 0xFFA2BFDB, 0xFFA9C7E2, 0xFFA9C4DF, 0xFFAFCDE7, 0xFFA9C8E2, 0xFF9C99B6, 0xFF905F7C, 0xFF915572, 0xFF965A79, 
        0xFF904E6F, 0xFF975679, 0xFF99587D, 0xFF9A587F, 0xFFA05C83, 0xFF99577A, 0xFFA36087, 0xFFA45C86, 0xFFAA6390, 0xFFA15181, 0xFF7D1837, 0xFF811801, 0xFFD89604, 0xFFFFE751, 0xFFFFF2AD, 0xFFFFF0B2, 0xFFFFE46F, 0xFFFFD318, 0xFFFFCE00, 0xFFFFCE00, 
        0xFFFFD300, 0xFFFFDC05, 0xFFC28F37, 0xFF791522, 0xE6530000, 0xAC0E0000, 0x67000000,
  0x00FFFFFF, 0x00000000, 0x04000000, 0xC4710000, 0xFF730000, 0xFF9E221B, 0xFF513794, 0xFF619FFF, 0xFFCAE8FF, 0xFFA4C7E7, 0xFFA1BFDC, 0xFF93A9C3, 0xFF8494AC, 0xFF8696AE, 0xFF90A2BA, 0xFF8FA0B7, 0xFF8898AD, 0xFF8A9DB2, 0xFF78869B, 0xFF818FA4, 0xFF9DAFC7, 
        0xFF8D9BB2, 0xFF6D7589, 0xFF7A8398, 0xFF838DA2, 0xFF8A96AB, 0xFF707A8D, 0xFF6C7588, 0xFF91A3BA, 0xFFBAB5D3, 0xFF741A32, 0xFF983600, 0xFFF0BD11, 0xFFFFF073, 0xFFFFF4BA, 0xFFFFEEA0, 0xFFFFDF52, 0xFFFFD20B, 0xFFFFCF00, 0xFFFFD100, 0xFFFFDA00, 
        0xFFFFDB06, 0xFFBE7412, 0xFD7B0604, 0xDA3F0000, 0xA0060000, 0x6B000000, 0x31000000,
  0x00FFFFFF, 0x00000000, 0x01000000, 0x916B0000, 0xFF740000, 0xFF95241D, 0xFF7E2F63, 0xFF4483FF, 0xFFC8E5FF, 0xFFB4DBFC, 0xFFA7C7E4, 0xFFA0BAD5, 0xFF9AB0CA, 0xFF8594AB, 0xFF96A9C1, 0xFFA1B7CF, 0xFF9DB0C8, 0xFF9EB2C8, 0xFFA1B5CA, 0xFFADC3D9, 0xFFB7CEE3, 
        0xFFAEC2D6, 0xFFA2B4C7, 0xFFA1B3C4, 0xFFADBFD2, 0xFFB3C8D9, 0xFFADC2D4, 0xFFA3B7C8, 0xFF815F70, 0xFF781814, 0xFFB66300, 0xFFFCDC37, 0xFFFFF494, 0xFFFFF2B6, 0xFFFFEA87, 0xFFFFDB2E, 0xFFFFD201, 0xFFFFD200, 0xFFFFD500, 0xFFFFE001, 0xFFEAB90F, 
        0xFFA24713, 0xF2630003, 0xC3250000, 0x90000000, 0x5C000000, 0x28000000, 0x0A000000,
  0x00FFFFFF, 0x00000000, 0x00000000, 0x485C0000, 0xFC770000, 0xFF851D19, 0xFFA43A4F, 0xFF366AEE, 0xFFBEDDFF, 0xFFBEE2FF, 0xFFB4D7F7, 0xFFA8C4E0, 0xFFABC7E0, 0xFF9CB1CB, 0xFFA4BBD3, 0xFFB7D2EA, 0xFFB8D3EA, 0xFFBCD5EB, 0xFFBED7EC, 0xFFBFD7ED, 0xFFC1D7EC, 
        0xFFC4DBEF, 0xFFCADFF4, 0xFFC9DDF1, 0xFFCADEF1, 0xFFD5EEFF, 0xFFCBD9EA, 0xFF884E62, 0xFF7E1A00, 0xFFDB9E06, 0xFFFFF057, 0xFFFFF5B2, 0xFFFFF2B2, 0xFFFFE668, 0xFFFFD813, 0xFFFFD400, 0xFFFFD600, 0xFFFFDA00, 0xFFFFE104, 0xFFD79E15, 0xFF83170E, 
        0xE6510000, 0xAC0D0000, 0x7C000000, 0x47000000, 0x1C000000, 0x06000000, 0x00000000,
  0x00FFFFFF, 0x00000000, 0x00000000, 0x14360000, 0xE4740000, 0xFF760F0D, 0xFFB54244, 0xFF4A53BC, 0xFFA1CDFF, 0xFFCAE7FF, 0xFFBADFFF, 0xFFB4D4F2, 0xFFAAC3DD, 0xFFADC5DE, 0xFFAFC8E0, 0xFFAFC7DE, 0xFFB0C7DE, 0xFFB6CEE4, 0xFFBCD3E8, 0xFFBCD2E7, 0xFFC2D7EB, 
        0xFFC3D9ED, 0xFFC7DAEE, 0xFFCBE0F3, 0xFFD3ECFE, 0xFFB5B4C8, 0xFF6C1F29, 0xFF8C3300, 0xFFEFC51B, 0xFFFFF680, 0xFFFFF5B9, 0xFFFFEF99, 0xFFFFE34C, 0xFFFFD607, 0xFFFFD400, 0xFFFFD400, 0xFFFFD900, 0xFFFAD00A, 0xFFB96E18, 0xFC730508, 0xD4380000, 
        0x9B000000, 0x6A000000, 0x34000000, 0x10000000, 0x02000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00000000, 0x00000000, 0x03000000, 0xB46E0000, 0xFF6E0000, 0xFFA53028, 0xFF773F83, 0xFF7BB4FF, 0xFFD2ECFF, 0xFFBADEFF, 0xFFC0E3FF, 0xFFA6BDD8, 0xFF9DB0C8, 0xFF8D9CB2, 0xFF8390A4, 0xFF8F9EB1, 0xFF737C8E, 0xFF95A4B7, 0xFF8F9CAE, 0xFFC3D8EB, 
        0xFFC7DAED, 0xFFCDE4F7, 0xFFCFE4F7, 0xFF8B6E82, 0xFF5F0E08, 0xFFBE7D00, 0xFFFFE742, 0xFFFFF7A3, 0xFFFFF4B6, 0xFFFFE87E, 0xFFFFD622, 0xFFFFCD00, 0xFFFFCB00, 0xFFFFCA00, 0xFFFFD201, 0xFFE9B015, 0xFF943413, 0xF05C0002, 0xBD1B0000, 0x8C000000, 
        0x57000000, 0x25000000, 0x09000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x7B660000, 0xFF720000, 0xFF922B26, 0xFF9F395D, 0xFF568EFA, 0xFFCDE8FF, 0xFFBEE0FF, 0xFFC0E1FF, 0xFFBEDEFB, 0xFFB0C9E1, 0xFFA1B4CB, 0xFFA2B4CA, 0xFFA5B7CC, 0xFFA3B5C9, 0xFFA4B4C8, 0xFFADBFD2, 0xFFC5D9EC, 
        0xFFCDE3F5, 0xFFBBC4D6, 0xFF6D404E, 0xFF732400, 0xFFD8A211, 0xFFFFF26F, 0xFFFFF3B4, 0xFFFFECA4, 0xFFFFDA56, 0xFFFFC911, 0xFFFFC100, 0xFFFFC000, 0xFFFFC100, 0xFFFEC208, 0xFFC57918, 0xFE7C160F, 0xDF430000, 0xA7080000, 0x78000000, 0x43000000, 
        0x19000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x324F0000, 0xF6750000, 0xFF7F1C1A, 0xFFBE4D58, 0xFF4E74E2, 0xFFBCDCFF, 0xFFC7E5FF, 0xFFC0E1FF, 0xFFC4E4FF, 0xFFC3E0FA, 0xFFBBD4EB, 0xFFBCD4E9, 0xFFBFD6EB, 0xFFC2D8EC, 0xFFC4D9EC, 0xFFC7DBED, 0xFFCBE0F1, 
        0xFFBFCCDD, 0xFF4F1A22, 0xFF8C4300, 0xFFFCD22E, 0xFFFFF194, 0xFFFFEFBB, 0xFFFFE38D, 0xFFFFCB34, 0xFFFFB900, 0xFFFFB700, 0xFFFFB400, 0xFFFFB900, 0xFFF5AE0E, 0xFFA8521C, 0xF8600005, 0xCA290000, 0x95000000, 0x63000000, 0x2F000000, 0x0E000000, 
        0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x0A230000, 0xD4700000, 0xFF740A09, 0xFFBA4B4C, 0xFF6365BF, 0xFFA1CEFF, 0xFFD3ECFF, 0xFFC0E1FF, 0xFFC4E3FF, 0xFFC8E5FF, 0xFFB6CFE7, 0xFFB4CAE0, 0xFFB9CEE4, 0xFFC5DBF0, 0xFFCADFF4, 0xFFCBE0F5, 0xFFD5ECFF, 
        0xFF75636F, 0xFF6E1C07, 0xFFFFCE55, 0xFFFFEFAC, 0xFFFFE9B2, 0xFFFFD56E, 0xFFFFBA1C, 0xFFFFAE00, 0xFFFFAD00, 0xFFFFAC00, 0xFFFFB104, 0xFFE69514, 0xFF882B12, 0xF5550000, 0xB9130000, 0x86000000, 0x4F000000, 0x20000000, 0x07000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0xA36B0000, 0xFF710000, 0xFFA83630, 0xFF855999, 0xFF7BB7FF, 0xFFD6ECFF, 0xFFC2E1FF, 0xFFC8E5FF, 0xFFBED9F4, 0xFF9FB0C9, 0xFF9DADC4, 0xFF838EA2, 0xFF98A7BB, 0xFFC8DFF4, 0xFFDEF8FF, 0xFFADB3BE, 
        0xFF3B1517, 0xFFDA9C7F, 0xFFFFD09A, 0xFFFFE39F, 0xFFFFC24B, 0xFFFFA806, 0xFFFFA300, 0xFFFFA200, 0xFFFFA200, 0xFFFFA60A, 0xFFB66118, 0xFF680B0B, 0xFF925760, 0xEF611313, 0x92020000, 0x49000000, 0x15000000, 0x03000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x72650000, 0xFF740000, 0xFF9A2A25, 0xFFA94765, 0xFF5F99FB, 0xFFCEE7FF, 0xFFC7E4FF, 0xFFC8E4FF, 0xFFC8E3FE, 0xFFC4DEF7, 0xFFBAD1E8, 0xFFBED5EB, 0xFFB5C9DF, 0xFFD0E6FB, 0xFFD7EDFE, 0xFF4B353B, 
        0xFF7F6359, 0xFFFFF3DF, 0xFFFEAA70, 0xFFFFAE25, 0xFFFF9C00, 0xFFFF9900, 0xFFFF9700, 0xFFFF9C00, 0xFFF59613, 0xFF953D13, 0xFF610F17, 0xFF97818C, 0xFFCED9E1, 0xFB944C4D, 0x91130000, 0x2E000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3C590000, 0xFA740000, 0xFF881513, 0xFFCA4349, 0xFF667ED8, 0xFFB9DDFF, 0xFFCDE8FF, 0xFFC8E4FF, 0xFFCBE6FF, 0xFFCDE8FF, 0xFFD1EBFF, 0xFFD4ECFF, 0xFFD7EEFF, 0xFFE0F9FF, 0xFF90919C, 0xFF472723, 
        0xFFECE3D0, 0xFFFBF9E4, 0xFFF8C09A, 0xFFFF8513, 0xFFFF9100, 0xFFFF9300, 0xFFFF9B06, 0xFFD37818, 0xFF701E10, 0xFF6B303C, 0xFFAAA7B1, 0xFFBBCCD7, 0xFFC4D4DC, 0xFFB28687, 0xB12B0000, 0x39000000, 0x06000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0F2F0000, 0xDC6F0000, 0xFF7F0C0B, 0xFFCE4644, 0xFF7E68AB, 0xFFA3D3FF, 0xFFD7EDFF, 0xFFC8E4FF, 0xFFCCE6FF, 0xFFCDE6FE, 0xFFD0E8FE, 0xFFCFE6FC, 0xFFD7EEFF, 0xFFCDE0F1, 0xFF2E2328, 0xFF7C7A6F, 
        0xFFFFFFE3, 0xFFF5E8C5, 0xFFF4E7C0, 0xFFFCB989, 0xFFFF9227, 0xFFFA8F07, 0xFFAE5F1D, 0xFF520D11, 0xFF7D5A64, 0xFFBBC7D1, 0xFFBCCAD3, 0xFFB7C0CB, 0xFFB9C7CF, 0xFFC1ACAE, 0xD0440505, 0x4D000000, 0x0F000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x9D660000, 0xFF770000, 0xFFC8534E, 0xFF9F628F, 0xFF8DC5FF, 0xFFDBEFFF, 0xFFC9E5FF, 0xFFCFE9FF, 0xFFBDD3EA, 0xFFB0C2D9, 0xFFB2C4D9, 0xFFA1B0C3, 0xFF5D5C65, 0xFF000A0A, 0xFF1C4D4A, 
        0xFFCECCAC, 0xFFF1DCAF, 0xFFD2B88E, 0xFFA88965, 0xFF88422B, 0xFF5B1004, 0xFF41090F, 0xFF4A383E, 0xFF818C94, 0xFFC0CBD4, 0xFFB9C2CB, 0xFFC0CAD2, 0xFFD1DCE6, 0xFFE8E4E9, 0xEE671717, 0x67050000, 0x1A000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x615F0000, 0xFF740000, 0xFFAE3532, 0xFFC54F5E, 0xFF7EA8F1, 0xFFDBF0FF, 0xFFCDE6FF, 0xFFCEE7FF, 0xFFCDE5FC, 0xFFCBE1F7, 0xFFCADEF4, 0xFF94A0B0, 0xFF090A0B, 0xFF001E1D, 0xFF001314, 
        0xFF251D16, 0xFF4B291E, 0xFF37110E, 0xFF492629, 0xFF6A555D, 0xFF887D86, 0xFF9D9FA8, 0xFF98A2AA, 0xFFA2A9B0, 0xFFCBD4DC, 0xFFDFE8F0, 0xFFEAF4FC, 0xFFEFF9FF, 0xFFF7FEFF, 0xFD924C4C, 0x931B0000, 0x2A000000, 0x02000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x2A500000, 0xF5710000, 0xFF971313, 0xFFDC494B, 0xFF8385C4, 0xFFC5E8FF, 0xFFD4EAFF, 0xFFCEE7FF, 0xFFD1E9FF, 0xFFD7EEFF, 0xFFD0E5F8, 0xFF42484F, 0xFF000000, 0xFF1C1D1F, 0xFF443A3E, 
        0xFF60565D, 0xFF7E7B84, 0xFF9FA4AE, 0xFFB5BFCA, 0xFFBECCD6, 0xFFBFCDD5, 0xFFC8D2DA, 0xFFD9E2EA, 0xFFE8F1F9, 0xFFEFF8FF, 0xFFF1FAFF, 0xFFF0F8FF, 0xFFEFF8FF, 0xFFFAFFFF, 0xFFB78686, 0xBB2F0000, 0x3E000000, 0x08000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x06000000, 0xC4690000, 0xFF870605, 0xFFDC514F, 0xFF9A72A2, 0xFFA8DBFF, 0xFFDAEEFF, 0xFFCEE7FF, 0xFFD2E9FF, 0xFFD3E9FE, 0xFFB0C2D4, 0xFF7B8691, 0xFF8E9AA6, 0xFFA9B4C2, 0xFFB4C2D0, 
        0xFFBCCCD8, 0xFFBCCAD5, 0xFFB9C5D0, 0xFFBBC4D0, 0xFFC7D1DA, 0xFFDBE5EE, 0xFFEBF5FE, 0xFFF1FAFF, 0xFFF2FAFF, 0xFFF1F8FF, 0xFFF2F8FF, 0xFFF2F8FF, 0xFFF1F8FF, 0xFFF5FFFF, 0xFFE4D0D1, 0xDB4B0505, 0x54000000, 0x12000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x87630000, 0xFF790000, 0xFFD25550, 0xFFB66F8D, 0xFF97CEFF, 0xFFDCEFFF, 0xFFCEE7FF, 0xFFD2E9FF, 0xFFD4E9FE, 0xFFD1E6F9, 0xFFD6E9FC, 0xFFD7E9FB, 0xFFD4E5F5, 0xFFD4E4F2, 
        0xFFD5E3F0, 0xFFD4E2EE, 0xFFD6E1ED, 0xFFE0EAF5, 0xFFECF6FF, 0xFFEFF9FF, 0xFFEFF8FF, 0xFFF0F8FF, 0xFFF2F8FF, 0xFFF3F9FF, 0xFFF4FAFF, 0xFFF4FAFF, 0xFFF3F9FF, 0xFFF4FCFF, 0xFFF7F6F9, 0xF6762929, 0x750D0000, 0x1F000000, 0x01000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4E5A0000, 0xFE750000, 0xFFB7211F, 0xFFD26875, 0xFF89BAF3, 0xFFD8EEFF, 0xFFDEEFFF, 0xFFD5EBFF, 0xFFD8ECFF, 0xFFDCEFFF, 0xFFDFF1FF, 0xFFE2F2FF, 0xFFE4F3FF, 0xFFE6F4FF, 
        0xFFE8F5FF, 0xFFEAF6FF, 0xFFEDF8FF, 0xFFEFF8FF, 0xFFEFF8FF, 0xFFF2F9FF, 0xFFF3FAFF, 0xFFF5FAFF, 0xFFF6FBFF, 0xFFF8FCFF, 0xFFF9FCFF, 0xFFF9FDFF, 0xFFF9FDFF, 0xFFF8FDFF, 0xFFFFFFFF, 0xFFA05D5D, 0xA3220000, 0x31000000, 0x04000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1C4A0000, 0xEE6E0000, 0xFFA31212, 0xFFE54F50, 0xFF938EBB, 0xFF97DDFF, 0xFFCBECFF, 0xFFD8F3FF, 0xFFD8F2FF, 0xFFD8F2FF, 0xFFD9F3FF, 0xFFD9F3FF, 0xFFDAF2FF, 0xFFE0F6FF, 
        0xFFE1F7FF, 0xFFE2F6FF, 0xFFE3F6FF, 0xFFE3F6FF, 0xFFE4F6FF, 0xFFE4F6FF, 0xFFE7F8FF, 0xFFEDFBFF, 0xFFEEFBFF, 0xFFEFFBFF, 0xFFF0FBFF, 0xFFF0FCFF, 0xFFF0FCFF, 0xFFEFFFFF, 0xFFF1DBE1, 0xFFC36768, 0xC5350000, 0x46000000, 0x0B000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0xC7690000, 0xFF8A0202, 0xFFE84846, 0xFFD42931, 0xFF9A82AA, 0xFF939DCE, 0xFF98A3D1, 0xFF95A3D3, 0xFF94A1D3, 0xFF93A0D3, 0xFF929ED3, 0xFF909ED3, 0xFF909DD3, 
        0xFF8E9DD4, 0xFF8BA2DC, 0xFF8AA1DC, 0xFF889FDC, 0xFF879EDC, 0xFF859DDC, 0xFF849CDC, 0xFF849BDB, 0xFF819DE0, 0xFF7E9FE6, 0xFF7D9EE6, 0xFF7B9DE6, 0xFF789EEA, 0xFF818FD4, 0xFFDD2133, 0xFFF4605E, 0xDF521313, 0x5A000000, 0x15000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x95640000, 0xFF780000, 0xFFD54948, 0xFFFB1F1E, 0xFFEC0000, 0xFFE20305, 0xFFE20406, 0xFFE40507, 0xFFE50407, 0xFFE50407, 0xFFE50407, 0xFFE40406, 0xFFE30306, 
        0xFFE30407, 0xFFE40408, 0xFFE40307, 0xFFE50307, 0xFFE50306, 0xFFE40206, 0xFFE20105, 0xFFE10105, 0xFFE10206, 0xFFE10106, 0xFFE10005, 0xFFE10004, 0xFFE00004, 0xFFEB0001, 0xFFFF0000, 0xFFFC5F5F, 0xEC6B2929, 0x6C020000, 0x1E000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x505A0000, 0xFE740000, 0xFFA11111, 0xFFD22222, 0xFFD50B0A, 0xFFD8100F, 0xFFDA1212, 0xFFDD1313, 0xFFE01615, 0xFFE21919, 0xFFE31D1C, 0xFFE72221, 0xFFEA2626, 
        0xFFEB2A29, 0xFFEE2B2A, 0xFFF02B2A, 0xFFF22E2D, 0xFFF3312F, 0xFFF53433, 0xFFF93C3B, 0xFFFA3F3E, 0xFFFB4342, 0xFFFD403E, 0xFFFE403F, 0xFFFE4342, 0xFFFF4644, 0xFFFF4A49, 0xFFFF5555, 0xFFE76363, 0xE34E0808, 0x73000000, 0x22000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x132A0000, 0xDE6E0000, 0xFF820000, 0xFF8B0101, 0xFF900303, 0xFF940303, 0xFF980303, 0xFF9C0505, 0xFFA00505, 0xFFA40505, 0xFFA80606, 0xFFAD0707, 0xFFB10909, 
        0xFFB50909, 0xFFB90A0A, 0xFFBD0C0C, 0xFFC20C0C, 0xFFC70D0D, 0xFFCC0E0E, 0xFFD01010, 0xFFD31010, 0xFFD31212, 0xFFD31313, 0xFFD41313, 0xFFD51414, 0xFFD51515, 0xFFD61717, 0xFFDA1818, 0xFF9E0707, 0xCE2E0000, 0x6A000000, 0x1D000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x604D0000, 0xDC650000, 0xF16B0000, 0xF2690000, 0xF26A0000, 0xF46D0000, 0xF6700000, 0xF6700000, 0xF6720000, 0xF6720000, 0xF6740000, 0xF6750000, 
        0xF6750000, 0xF7790000, 0xF87B0000, 0xF87F0000, 0xF87F0000, 0xF8800000, 0xF8810000, 0xF8810000, 0xF9800000, 0xFB830000, 0xFB850000, 0xFB870000, 0xFB860000, 0xFB870000, 0xFB820000, 0xE5480000, 0x9E0A0000, 0x4F000000, 0x12000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x10000000, 0x3D000000, 0x6B000000, 0x7D000000, 0x7F000000, 0x7F000000, 0x80000000, 0x82000000, 0x82000000, 0x82000000, 0x82000000, 0x82000000, 
        0x82000000, 0x83000000, 0x85000000, 0x85000000, 0x85000000, 0x85000000, 0x85000000, 0x85000000, 0x85000000, 0x87000000, 0x88000000, 0x89000000, 0x89000000, 0x89000000, 0x89000000, 0x82000000, 0x5E000000, 0x28000000, 0x06000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x0F000000, 0x1F000000, 0x26000000, 0x27000000, 0x27000000, 0x28000000, 0x29000000, 0x29000000, 0x29000000, 0x29000000, 0x29000000, 
        0x29000000, 0x29000000, 0x2A000000, 0x2B000000, 0x2B000000, 0x2B000000, 0x2B000000, 0x2B000000, 0x2B000000, 0x2B000000, 0x2C000000, 0x2D000000, 0x2D000000, 0x2D000000, 0x2D000000, 0x29000000, 0x1B000000, 0x09000000, 0x01000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF,
  0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF
#else
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xF500007C, 0x4D000073, 0x0B01016D, 0x0C070672, 0x0C00006F, 0x0C01006D, 0x0C02006C, 0x0D03006B, 0x1703006B, 0x1903006A, 0x1904006A, 0x1904006A, 0x1905006A, 0x1906006A, 0x18060069, 0x1C070068, 0x25060069, 0x25070069, 0x25080068, 0x25090068, 
        0x250A0068, 0x250B0068, 0x260B0066, 0x310A0064, 0x32090065, 0x320A0064, 0x310C0064, 0x3A0C0062, 0x83060059, 0xE6000019, 0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0x9E000078, 0x0000006F, 0x0000005C, 0x004A4684, 0x00685CBD, 0x005249C3, 0x00554DBC, 0x005E56B7, 0x00655DBA, 0x006B63BD, 0x007067BD, 0x007169BE, 0x00746BC0, 0x00776EC0, 0x00786FBA, 0x007970BA, 0x007B72BC, 0x007D75BD, 0x007E76BE, 0x007B72BF, 
        0x007C74C0, 0x008076C0, 0x007E74BA, 0x007F75BB, 0x007F77BC, 0x008179BE, 0x00857CBF, 0x008277BC, 0x0048248C, 0x300E005C, 0xBB000030, 0xF3000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0x4D000076, 0x00010274, 0x0003027B, 0x003E1441, 0x00685280, 0x008D7AD9, 0x007466F2, 0x00665BEF, 0x006D61EE, 0x007367EF, 0x007A6EEF, 0x008479F0, 0x008F84F1, 0x009D93F2, 0x00A79DF3, 0x00ADA4F4, 0x00B1A8F4, 0x00B3ABF6, 0x00B6AEF7, 0x00BAB3F8, 
        0x00BCB6F8, 0x00C0BAF9, 0x00C4BEFA, 0x00C7C2FB, 0x00CAC4FC, 0x00CBC7FD, 0x00CFCBFD, 0x00EEEBFE, 0x00E0E1F7, 0x00806EBB, 0x0925026D, 0x6706004E, 0xE300000B, 0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0x1200007B, 0x00000275, 0x000D087E, 0x00962516, 0x00996760, 0x00544A7A, 0x007160B2, 0x007868EA, 0x005B50EE, 0x005B51EA, 0x005F55EA, 0x005F55EB, 0x006258EC, 0x00665DED, 0x006F66ED, 0x007A71EE, 0x008A81EF, 0x00968FF0, 0x009D96F1, 0x00A29CF1, 
        0x00A59EF2, 0x00A7A1F2, 0x00AAA4F4, 0x00ADA8F5, 0x00AFAAF5, 0x00B3AEF5, 0x00B3AEF6, 0x00C5C0F6, 0x00EBE9FB, 0x00E9EDFF, 0x00A69FDC, 0x00431D8B, 0x31110058, 0xBC00002E, 0xF4000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xEB000074, 0xCE000072, 0xF500003D, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0x2A000077, 0x00010276, 0x000A0D84, 0x007D1A1D, 0x00D9865B, 0x00C2AD94, 0x00765F70, 0x00635295, 0x007A6AD4, 0x00685CEF, 0x00564DEC, 0x005D53EC, 0x005E55ED, 0x005F56ED, 0x005F57EE, 0x006058EF, 0x00635CF0, 0x006B63F1, 0x00766FF1, 0x00837DF1, 
        0x00908AF2, 0x009B95F3, 0x00A09AF4, 0x00A39EF5, 0x00A5A0F5, 0x00A9A4F6, 0x00AAA6F7, 0x00B3AFF7, 0x00D7D4F9, 0x00D1D1FF, 0x00E0E2FF, 0x00C4C8F6, 0x00755AB5, 0x0F25046E, 0x77060047, 0xE5000010, 0xFB000000, 0xFF000000, 0xFF000000, 0xAE000076, 
        0x2302037A, 0x0002057E, 0x3500006D, 0xB200004B, 0xF2000000, 0xFE000000, 0xFF000000,
  0xFFFFFFFF, 0x6A00006C, 0x00000075, 0x000B138C, 0x005C1843, 0x00CF6637, 0x00D8C0A4, 0x00DEB88C, 0x00A1847B, 0x005C4978, 0x007563B8, 0x007365ED, 0x00554CF0, 0x00564EED, 0x005A52ED, 0x005C54EF, 0x005D56EF, 0x005E57F1, 0x005F58F1, 0x005F59F1, 0x00615BF2, 
        0x006660F3, 0x00736EF4, 0x00837EF5, 0x00908CF5, 0x009995F6, 0x009D99F7, 0x009F9CF8, 0x00A29FF9, 0x00C1BEF9, 0x00BDBDFE, 0x00BFBFFF, 0x00CCCCFF, 0x00D4D8FF, 0x009991DF, 0x0045178A, 0x35140057, 0xBE01002E, 0xF2000012, 0x7E000073, 0x0215107B, 
        0x005770B4, 0x00207FED, 0x000527A3, 0x1200006E, 0xA8000030, 0xED000000, 0xFE000000,
  0xFFFFFFFF, 0xA0000065, 0x00000077, 0x000A0E80, 0x00301577, 0x00C24A1F, 0x00D5B9A0, 0x00D5B390, 0x00DEBB93, 0x00CFAD8D, 0x00755C78, 0x006A579D, 0x007969DF, 0x005C53F2, 0x005149F0, 0x00564FEF, 0x005851F1, 0x005953F1, 0x005B54F1, 0x005C56F2, 0x005E58F3, 
        0x005F59F4, 0x005F5AF5, 0x00615CF5, 0x006863F6, 0x007672F7, 0x008682F8, 0x00908DF9, 0x009491F9, 0x00ACA9F9, 0x00B0AFFD, 0x00A5A5FF, 0x00AEAEFF, 0x00B6B6FF, 0x00C5C8FF, 0x00AEAFF6, 0x006C48B3, 0x1624026A, 0x35000067, 0x00012393, 0x009FA0B6, 
        0x00C7D2DB, 0x0034A6FF, 0x001788FD, 0x000528A7, 0x25000061, 0xC100000A, 0xF3000000,
  0xFFFFFFFF, 0xD8000052, 0x0B000079, 0x00040672, 0x001D1891, 0x00B3341D, 0x00D9A27F, 0x00D4B99A, 0x00D6B491, 0x00DCBA97, 0x00DFBD98, 0x00AC8F88, 0x00644D84, 0x007663BE, 0x006F62EE, 0x004E47F4, 0x005049F1, 0x00544DF1, 0x00554FF3, 0x005750F3, 0x005953F4, 
        0x005A55F5, 0x005B57F5, 0x005D59F6, 0x005E5AF7, 0x005E5AF7, 0x00615EF8, 0x006966F9, 0x007471F9, 0x008F8DFA, 0x009F9EFC, 0x008A8AFF, 0x009191FF, 0x009999FF, 0x00A4A4FF, 0x00B5B6FF, 0x007672D1, 0x000B0680, 0x000059B9, 0x001FC5F9, 0x00D1E7E9, 
        0x00FBEDE8, 0x0072BDF6, 0x001E9AFF, 0x00157CF4, 0x0001108C, 0x54000049, 0xD6000000,
  0xFFFFFFFF, 0xF9000000, 0x3D000071, 0x00010172, 0x00171E97, 0x009B2C37, 0x00F18750, 0x00D3BFA6, 0x00D7B593, 0x00D8B797, 0x00DABA9A, 0x00E4C49F, 0x00CCAD96, 0x00876C85, 0x006E58A0, 0x007767DC, 0x005F55F5, 0x004C46F3, 0x00514AF2, 0x00514CF4, 0x00524DF5, 
        0x00544EF5, 0x005551F6, 0x005753F7, 0x005956F8, 0x005A57F9, 0x005B58F9, 0x005C59F9, 0x005C5AFA, 0x006563FB, 0x007876FC, 0x005353FF, 0x006868FF, 0x007C7CFF, 0x007C7BF6, 0x003D32AA, 0x00011589, 0x000384D3, 0x0043E0FF, 0x009AEEFF, 0x00C8EDF8, 
        0x00EDDBD6, 0x00B8BDCB, 0x0042A7F5, 0x001E9BFF, 0x000A44BE, 0x19000062, 0xAD000000,
  0xFFFFFFFF, 0xFE000000, 0x7E000068, 0x00000074, 0x00172193, 0x00752D61, 0x00FF7A37, 0x00DEC9B0, 0x00D5B595, 0x00D8B899, 0x00DABB9B, 0x00DBBD9E, 0x00E1C3A3, 0x00E8CBA5, 0x00B09391, 0x006D538A, 0x007B66BF, 0x006C61F1, 0x004F4AF5, 0x004E49F5, 0x004E4AF7, 
        0x004E4AF7, 0x004E4BF8, 0x004F4CFA, 0x00504DFB, 0x005250FB, 0x005352FB, 0x005454FD, 0x005655FE, 0x005757FE, 0x006161FF, 0x002224FF, 0x001F20FF, 0x003733E6, 0x00160D8E, 0x00003299, 0x000EB6F0, 0x006AEBFF, 0x00B8F1FF, 0x00A8EEFF, 0x0056DEFF, 
        0x0085C0D2, 0x00D8AEA7, 0x00A5A8B7, 0x004AA9F4, 0x001C6EDE, 0x06000075, 0x8C000000,
  0xFFFFFFFF, 0xFF000000, 0xB3000060, 0x01000079, 0x000A0F7D, 0x00502D83, 0x00F86223, 0x00F9D7B9, 0x00D8BC9D, 0x00D8B999, 0x00DBBC9D, 0x00DDBFA0, 0x00DEC1A3, 0x00E0C3A5, 0x00E9CEAB, 0x00D8BAA4, 0x00876A8B, 0x00785FAA, 0x007667DF, 0x00675DE9, 0x00675DE8, 
        0x00695FEB, 0x00695FEB, 0x006A5FED, 0x006A5FEE, 0x00675EEF, 0x00665FF2, 0x00665FF2, 0x006761F2, 0x006761F3, 0x007871F4, 0x005E4FF1, 0x00140ACB, 0x00000083, 0x00005AB1, 0x0028D6FE, 0x008BEEFF, 0x00B9F1FF, 0x0091E9FF, 0x0040D9FF, 0x0000CDFF, 
        0x0008CCFC, 0x0080BACC, 0x00C0ABA3, 0x009D8D96, 0x00252F8F, 0x10000064, 0x7F000000,
  0xFFFFFFFF, 0xFF000000, 0xE500004B, 0x14000077, 0x00060873, 0x002D2799, 0x00D14726, 0x00FFBC8E, 0x00EFD7B7, 0x00D8B99A, 0x00DBBD9F, 0x00D8BB9E, 0x00DBBFA2, 0x00E2C7A9, 0x00DFC4A9, 0x00E7CDAF, 0x00E2C8A9, 0x00B6999C, 0x007C5F90, 0x00725591, 0x00795A96, 
        0x006F4E90, 0x00795697, 0x007D5899, 0x007F589A, 0x00835CA0, 0x007A5799, 0x008760A3, 0x00865CA4, 0x009063AA, 0x008151A1, 0x0037187D, 0x00011881, 0x000496D8, 0x0051E7FF, 0x00ADF2FF, 0x00B2F0FF, 0x006FE4FF, 0x0018D3FF, 0x0000CEFF, 0x0000CEFF, 
        0x0000D3FF, 0x0005DCFF, 0x00378FC2, 0x00221579, 0x19000053, 0x5300000E, 0x98000000,
  0xFFFFFFFF, 0xFF000000, 0xFB000000, 0x3B000071, 0x00000073, 0x001B229E, 0x00943751, 0x00FF9F61, 0x00FFE8CA, 0x00E7C7A4, 0x00DCBFA1, 0x00C3A993, 0x00AC9484, 0x00AE9686, 0x00BAA290, 0x00B7A08F, 0x00AD9888, 0x00B29D8A, 0x009B8678, 0x00A48F81, 0x00C7AF9D, 
        0x00B29B8D, 0x0089756D, 0x0098837A, 0x00A28D83, 0x00AB968A, 0x008D7A70, 0x0088756C, 0x00BAA391, 0x00D3B5BA, 0x00321A74, 0x00003698, 0x0011BDF0, 0x0073F0FF, 0x00BAF4FF, 0x00A0EEFF, 0x0052DFFF, 0x000BD2FF, 0x0000CFFF, 0x0000D1FF, 0x0000DAFF, 
        0x0006DBFF, 0x001274BE, 0x0204067B, 0x2500003F, 0x5F000006, 0x94000000, 0xCE000000,
  0xFFFFFFFF, 0xFF000000, 0xFE000000, 0x6E00006B, 0x00000074, 0x001D2495, 0x00632F7E, 0x00FF8344, 0x00FFE5C8, 0x00FCDBB4, 0x00E4C7A7, 0x00D5BAA0, 0x00CAB09A, 0x00AB9485, 0x00C1A996, 0x00CFB7A1, 0x00C8B09D, 0x00C8B29E, 0x00CAB5A1, 0x00D9C3AD, 0x00E3CEB7, 
        0x00D6C2AE, 0x00C7B4A2, 0x00C4B3A1, 0x00D2BFAD, 0x00D9C8B3, 0x00D4C2AD, 0x00C8B7A3, 0x00705F81, 0x00141878, 0x000063B6, 0x0037DCFC, 0x0094F4FF, 0x00B6F2FF, 0x0087EAFF, 0x002EDBFF, 0x0001D2FF, 0x0000D2FF, 0x0000D5FF, 0x0001E0FF, 0x000FB9EA, 
        0x001347A2, 0x0D030063, 0x3C000025, 0x6F000000, 0xA3000000, 0xD7000000, 0xF5000000,
  0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xB700005C, 0x03000077, 0x00191D85, 0x004F3AA4, 0x00EE6A36, 0x00FFDDBE, 0x00FFE2BE, 0x00F7D7B4, 0x00E0C4A8, 0x00E0C7AB, 0x00CBB19C, 0x00D3BBA4, 0x00EAD2B7, 0x00EAD3B8, 0x00EBD5BC, 0x00ECD7BE, 0x00EDD7BF, 0x00ECD7C1, 
        0x00EFDBC4, 0x00F4DFCA, 0x00F1DDC9, 0x00F1DECA, 0x00FFEED5, 0x00EAD9CB, 0x00624E88, 0x00001A7E, 0x00069EDB, 0x0057F0FF, 0x00B2F5FF, 0x00B2F2FF, 0x0068E6FF, 0x0013D8FF, 0x0000D4FF, 0x0000D6FF, 0x0000DAFF, 0x0004E1FF, 0x00159ED7, 0x000E1783, 
        0x19000051, 0x5300000D, 0x83000000, 0xB8000000, 0xE3000000, 0xF9000000, 0xFF000000,
  0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xEB000036, 0x1B000074, 0x000D0F76, 0x004442B5, 0x00BC534A, 0x00FFCDA1, 0x00FFE7CA, 0x00FFDFBA, 0x00F2D4B4, 0x00DDC3AA, 0x00DEC5AD, 0x00E0C8AF, 0x00DEC7AF, 0x00DEC7B0, 0x00E4CEB6, 0x00E8D3BC, 0x00E7D2BC, 0x00EBD7C2, 
        0x00EDD9C3, 0x00EEDAC7, 0x00F3E0CB, 0x00FEECD3, 0x00C8B4B5, 0x00291F6C, 0x0000338C, 0x001BC5EF, 0x0080F6FF, 0x00B9F5FF, 0x0099EFFF, 0x004CE3FF, 0x0007D6FF, 0x0000D4FF, 0x0000D4FF, 0x0000D9FF, 0x000AD0FA, 0x00186EB9, 0x03080573, 0x2B000038, 
        0x64000000, 0x95000000, 0xCB000000, 0xEF000000, 0xFD000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFC000000, 0x4B00006E, 0x0000006E, 0x002830A5, 0x00833F77, 0x00FFB47B, 0x00FFECD2, 0x00FFDEBA, 0x00FFE3C0, 0x00D8BDA6, 0x00C8B09D, 0x00B29C8D, 0x00A49083, 0x00B19E8F, 0x008E7C73, 0x00B7A495, 0x00AE9C8F, 0x00EBD8C3, 
        0x00EDDAC7, 0x00F7E4CD, 0x00F7E4CF, 0x00826E8B, 0x00080E5F, 0x00007DBE, 0x0042E7FF, 0x00A3F7FF, 0x00B6F4FF, 0x007EE8FF, 0x0022D6FF, 0x0000CDFF, 0x0000CBFF, 0x0000CAFF, 0x0001D2FF, 0x0015B0E9, 0x00133494, 0x0F02005C, 0x4200001B, 0x73000000, 
        0xA8000000, 0xDA000000, 0xF6000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0x84000066, 0x00000072, 0x00262B92, 0x005D399F, 0x00FA8E56, 0x00FFE8CD, 0x00FFE0BE, 0x00FFE1C0, 0x00FBDEBE, 0x00E1C9B0, 0x00CBB4A1, 0x00CAB4A2, 0x00CCB7A5, 0x00C9B5A3, 0x00C8B4A4, 0x00D2BFAD, 0x00ECD9C5, 
        0x00F5E3CD, 0x00D6C4BB, 0x004E406D, 0x00002473, 0x0011A2D8, 0x006FF2FF, 0x00B4F3FF, 0x00A4ECFF, 0x0056DAFF, 0x0011C9FF, 0x0000C1FF, 0x0000C0FF, 0x0000C1FF, 0x0008C2FE, 0x001879C5, 0x010F167C, 0x20000043, 0x58000008, 0x87000000, 0xBC000000, 
        0xE6000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xCD00004F, 0x09000075, 0x001A1C7F, 0x00584DBE, 0x00E2744E, 0x00FFDCBC, 0x00FFE5C7, 0x00FFE1C0, 0x00FFE4C4, 0x00FAE0C3, 0x00EBD4BB, 0x00E9D4BC, 0x00EBD6BF, 0x00ECD8C2, 0x00ECD9C4, 0x00EDDBC7, 0x00F1E0CB, 
        0x00DDCCBF, 0x00221A4F, 0x0000438C, 0x002ED2FC, 0x0094F1FF, 0x00BBEFFF, 0x008DE3FF, 0x0034CBFF, 0x0000B9FF, 0x0000B7FF, 0x0000B4FF, 0x0000B9FF, 0x000EAEF5, 0x001C52A8, 0x07050060, 0x35000029, 0x6A000000, 0x9C000000, 0xD0000000, 0xF1000000, 
        0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xF5000023, 0x2B000070, 0x00090A74, 0x004C4BBA, 0x00BF6563, 0x00FFCEA1, 0x00FFECD3, 0x00FFE1C0, 0x00FFE3C4, 0x00FFE5C8, 0x00E7CFB6, 0x00E0CAB4, 0x00E4CEB9, 0x00F0DBC5, 0x00F4DFCA, 0x00F5E0CB, 0x00FFECD5, 
        0x006F6375, 0x00071C6E, 0x0055CEFF, 0x00ACEFFF, 0x00B2E9FF, 0x006ED5FF, 0x001CBAFF, 0x0000AEFF, 0x0000ADFF, 0x0000ACFF, 0x0004B1FF, 0x001495E6, 0x00122B88, 0x0A000055, 0x46000013, 0x79000000, 0xB0000000, 0xDF000000, 0xF8000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0x5C00006B, 0x00000071, 0x003036A8, 0x00995985, 0x00FFB77B, 0x00FFECD6, 0x00FFE1C2, 0x00FFE5C8, 0x00F4D9BE, 0x00C9B09F, 0x00C4AD9D, 0x00A28E83, 0x00BBA798, 0x00F4DFC8, 0x00FFF8DE, 0x00BEB3AD, 
        0x0017153B, 0x007F9CDA, 0x009AD0FF, 0x009FE3FF, 0x004BC2FF, 0x0006A8FF, 0x0000A3FF, 0x0000A2FF, 0x0000A2FF, 0x000AA6FF, 0x001861B6, 0x000B0B68, 0x00605792, 0x10131361, 0x6D000002, 0xB6000000, 0xEA000000, 0xFC000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x8D000065, 0x00000074, 0x00252A9A, 0x006547A9, 0x00FB995F, 0x00FFE7CE, 0x00FFE4C7, 0x00FFE4C8, 0x00FEE3C8, 0x00F7DEC4, 0x00E8D1BA, 0x00EBD5BE, 0x00DFC9B5, 0x00FBE6D0, 0x00FEEDD7, 0x003B354B, 
        0x0059637F, 0x00DFF3FF, 0x0070AAFE, 0x0025AEFF, 0x00009CFF, 0x000099FF, 0x000097FF, 0x00009CFF, 0x001396F5, 0x00133D95, 0x00170F61, 0x008C8197, 0x00E1D9CE, 0x044D4C94, 0x6E000013, 0xD1000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xC3000059, 0x05000074, 0x00131588, 0x004943CA, 0x00D87E66, 0x00FFDDB9, 0x00FFE8CD, 0x00FFE4C8, 0x00FFE6CB, 0x00FFE8CD, 0x00FFEBD1, 0x00FFECD4, 0x00FFEED7, 0x00FFF9E0, 0x009C9190, 0x00232747, 
        0x00D0E3EC, 0x00E4F9FB, 0x009AC0F8, 0x001385FF, 0x000091FF, 0x000093FF, 0x00069BFF, 0x001878D3, 0x00101E70, 0x003C306B, 0x00B1A7AA, 0x00D7CCBB, 0x00DCD4C4, 0x008786B2, 0x4E00002B, 0xC6000000, 0xF9000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF000002F, 0x2300006F, 0x000B0C7F, 0x004446CE, 0x00AB687E, 0x00FFD3A3, 0x00FFEDD7, 0x00FFE4C8, 0x00FFE6CC, 0x00FEE6CD, 0x00FEE8D0, 0x00FCE6CF, 0x00FFEED7, 0x00F1E0CD, 0x0028232E, 0x006F7A7C, 
        0x00E3FFFF, 0x00C5E8F5, 0x00C0E7F4, 0x0089B9FC, 0x002792FF, 0x00078FFA, 0x001D5FAE, 0x00110D52, 0x00645A7D, 0x00D1C7BB, 0x00D3CABC, 0x00CBC0B7, 0x00CFC7B9, 0x00AEACC1, 0x2F050544, 0xB2000000, 0xF0000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0x62000066, 0x00000077, 0x004E53C8, 0x008F629F, 0x00FFC58D, 0x00FFEFDB, 0x00FFE5C9, 0x00FFE9CF, 0x00EAD3BD, 0x00D9C2B0, 0x00D9C4B2, 0x00C3B0A1, 0x00655C5D, 0x000A0A00, 0x004A4D1C, 
        0x00ACCCCE, 0x00AFDCF1, 0x008EB8D2, 0x006589A8, 0x002B4288, 0x0004105B, 0x000F0941, 0x003E384A, 0x00948C81, 0x00D4CBC0, 0x00CBC2B9, 0x00D2CAC0, 0x00E6DCD1, 0x00E9E4E8, 0x11171767, 0x98000005, 0xE5000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x9E00005F, 0x00000074, 0x003235AE, 0x005E4FC5, 0x00F1A87E, 0x00FFF0DB, 0x00FFE6CD, 0x00FFE7CE, 0x00FCE5CD, 0x00F7E1CB, 0x00F4DECA, 0x00B0A094, 0x000B0A09, 0x001D1E00, 0x00141300, 
        0x00161D25, 0x001E294B, 0x000E1137, 0x00292649, 0x005D556A, 0x00867D88, 0x00A89F9D, 0x00AAA298, 0x00B0A9A2, 0x00DCD4CB, 0x00F0E8DF, 0x00FCF4EA, 0x00FFF9EF, 0x00FFFEF7, 0x024C4C92, 0x6C00001B, 0xD5000000, 0xFD000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xD5000050, 0x0A000071, 0x00131397, 0x004B49DC, 0x00C48583, 0x00FFE8C5, 0x00FFEAD4, 0x00FFE7CE, 0x00FFE9D1, 0x00FFEED7, 0x00F8E5D0, 0x004F4842, 0x00000000, 0x001F1D1C, 0x003E3A44, 
        0x005D5660, 0x00847B7E, 0x00AEA49F, 0x00CABFB5, 0x00D6CCBE, 0x00D5CDBF, 0x00DAD2C8, 0x00EAE2D9, 0x00F9F1E8, 0x00FFF8EF, 0x00FFFAF1, 0x00FFF8F0, 0x00FFF8EF, 0x00FFFFFA, 0x008686B7, 0x4400002F, 0xC1000000, 0xF7000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF9000000, 0x3B000069, 0x00050687, 0x004F51DC, 0x00A2729A, 0x00FFDBA8, 0x00FFEEDA, 0x00FFE7CE, 0x00FFE9D2, 0x00FEE9D3, 0x00D4C2B0, 0x0091867B, 0x00A69A8E, 0x00C2B4A9, 0x00D0C2B4, 
        0x00D8CCBC, 0x00D5CABC, 0x00D0C5B9, 0x00D0C4BB, 0x00DAD1C7, 0x00EEE5DB, 0x00FEF5EB, 0x00FFFAF1, 0x00FFFAF2, 0x00FFF8F1, 0x00FFF8F2, 0x00FFF8F2, 0x00FFF8F1, 0x00FFFFF5, 0x00D1D0E4, 0x2405054B, 0xAB000000, 0xED000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0x78000063, 0x00000079, 0x005055D2, 0x008D6FB6, 0x00FFCE97, 0x00FFEFDC, 0x00FFE7CE, 0x00FFE9D2, 0x00FEE9D4, 0x00F9E6D1, 0x00FCE9D6, 0x00FBE9D7, 0x00F5E5D4, 0x00F2E4D4, 
        0x00F0E3D5, 0x00EEE2D4, 0x00EDE1D6, 0x00F5EAE0, 0x00FFF6EC, 0x00FFF9EF, 0x00FFF8EF, 0x00FFF8F0, 0x00FFF8F2, 0x00FFF9F3, 0x00FFFAF4, 0x00FFFAF4, 0x00FFF9F3, 0x00FFFCF4, 0x00F9F6F7, 0x09292976, 0x8A00000D, 0xE0000000, 0xFE000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xB100005A, 0x01000075, 0x001F21B7, 0x007568D2, 0x00F3BA89, 0x00FFEED8, 0x00FFEFDE, 0x00FFEBD5, 0x00FFECD8, 0x00FFEFDC, 0x00FFF1DF, 0x00FFF2E2, 0x00FFF3E4, 0x00FFF4E6, 
        0x00FFF5E8, 0x00FFF6EA, 0x00FFF8ED, 0x00FFF8EF, 0x00FFF8EF, 0x00FFF9F2, 0x00FFFAF3, 0x00FFFAF5, 0x00FFFBF6, 0x00FFFCF8, 0x00FFFCF9, 0x00FFFDF9, 0x00FFFDF9, 0x00FFFDF8, 0x00FFFFFF, 0x005D5DA0, 0x5C000022, 0xCE000000, 0xFB000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE300004A, 0x1100006E, 0x001212A3, 0x00504FE5, 0x00BB8E93, 0x00FFDD97, 0x00FFECCB, 0x00FFF3D8, 0x00FFF2D8, 0x00FFF2D8, 0x00FFF3D9, 0x00FFF3D9, 0x00FFF2DA, 0x00FFF6E0, 
        0x00FFF7E1, 0x00FFF6E2, 0x00FFF6E3, 0x00FFF6E3, 0x00FFF6E4, 0x00FFF6E4, 0x00FFF8E7, 0x00FFFBED, 0x00FFFBEE, 0x00FFFBEF, 0x00FFFBF0, 0x00FFFCF0, 0x00FFFCF0, 0x00FFFFEF, 0x00E1DBF1, 0x006867C3, 0x3A000035, 0xB9000000, 0xF4000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFB000000, 0x38000069, 0x0002028A, 0x004648E8, 0x003129D4, 0x00AA829A, 0x00CE9D93, 0x00D1A398, 0x00D3A395, 0x00D3A194, 0x00D3A093, 0x00D39E92, 0x00D39E90, 0x00D39D90, 
        0x00D49D8E, 0x00DCA28B, 0x00DCA18A, 0x00DC9F88, 0x00DC9E87, 0x00DC9D85, 0x00DC9C84, 0x00DB9B84, 0x00E09D81, 0x00E69F7E, 0x00E69E7D, 0x00E69D7B, 0x00EA9E78, 0x00D48F81, 0x003321DD, 0x005E60F4, 0x20131352, 0xA5000000, 0xEA000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0x6A000064, 0x00000078, 0x004849D5, 0x001E1FFB, 0x000000EC, 0x000503E2, 0x000604E2, 0x000705E4, 0x000704E5, 0x000704E5, 0x000704E5, 0x000604E4, 0x000603E3, 
        0x000704E3, 0x000804E4, 0x000703E4, 0x000703E5, 0x000603E5, 0x000602E4, 0x000501E2, 0x000501E1, 0x000602E1, 0x000601E1, 0x000500E1, 0x000400E1, 0x000400E0, 0x000100EB, 0x000000FF, 0x005F5FFC, 0x1329296B, 0x93000002, 0xE1000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xAF00005A, 0x01000074, 0x001111A1, 0x002222D2, 0x000A0BD5, 0x000F10D8, 0x001212DA, 0x001313DD, 0x001516E0, 0x001919E2, 0x001C1DE3, 0x002122E7, 0x002626EA, 
        0x00292AEB, 0x002A2BEE, 0x002A2BF0, 0x002D2EF2, 0x002F31F3, 0x003334F5, 0x003B3CF9, 0x003E3FFA, 0x004243FB, 0x003E40FD, 0x003F40FE, 0x004243FE, 0x004446FF, 0x00494AFF, 0x005555FF, 0x006363E7, 0x1C08084E, 0x8C000000, 0xDD000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEC00002A, 0x2100006E, 0x00000082, 0x0001018B, 0x00030390, 0x00030394, 0x00030398, 0x0005059C, 0x000505A0, 0x000505A4, 0x000606A8, 0x000707AD, 0x000909B1, 
        0x000909B5, 0x000A0AB9, 0x000C0CBD, 0x000C0CC2, 0x000D0DC7, 0x000E0ECC, 0x001010D0, 0x001010D3, 0x001212D3, 0x001313D3, 0x001313D4, 0x001414D5, 0x001515D5, 0x001717D6, 0x001818DA, 0x0007079E, 0x3100002E, 0x95000000, 0xE2000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0x9F00004D, 0x23000065, 0x0E00006B, 0x0D000069, 0x0D00006A, 0x0B00006D, 0x09000070, 0x09000070, 0x09000072, 0x09000072, 0x09000074, 0x09000075, 
        0x09000075, 0x08000079, 0x0700007B, 0x0700007F, 0x0700007F, 0x07000080, 0x07000081, 0x07000081, 0x06000080, 0x04000083, 0x04000085, 0x04000087, 0x04000086, 0x04000087, 0x04000082, 0x1A000048, 0x6100000A, 0xB0000000, 0xED000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEF000000, 0xC2000000, 0x94000000, 0x82000000, 0x80000000, 0x80000000, 0x7F000000, 0x7D000000, 0x7D000000, 0x7D000000, 0x7D000000, 0x7D000000, 
        0x7D000000, 0x7C000000, 0x7A000000, 0x7A000000, 0x7A000000, 0x7A000000, 0x7A000000, 0x7A000000, 0x7A000000, 0x78000000, 0x77000000, 0x76000000, 0x76000000, 0x76000000, 0x76000000, 0x7D000000, 0xA1000000, 0xD7000000, 0xF9000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0xF0000000, 0xE0000000, 0xD9000000, 0xD8000000, 0xD8000000, 0xD7000000, 0xD6000000, 0xD6000000, 0xD6000000, 0xD6000000, 0xD6000000, 
        0xD6000000, 0xD6000000, 0xD5000000, 0xD4000000, 0xD4000000, 0xD4000000, 0xD4000000, 0xD4000000, 0xD4000000, 0xD4000000, 0xD3000000, 0xD2000000, 0xD2000000, 0xD2000000, 0xD2000000, 0xD6000000, 0xE4000000, 0xF6000000, 0xFE000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
  0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF
#endif
};

GUI_CONST_STORAGE GUI_BITMAP _bmWrite = {
  48, // XSize */
  48, // YSize */
  192, // BytesPerLine */
  32, // BitsPerPixel */
  (unsigned char *)_acWrite,  // Pointer to picture data */
  NULL,  // Pointer to palette */
#if (GUI_USE_ARGB == 1)
  GUI_DRAW_BMPM8888I
#else
  GUI_DRAW_BMP8888
#endif
};

/*********************************************************************
*
*       _bmToucan
*
* Function description
*   Toucan with alpha channel
*/
static GUI_CONST_STORAGE unsigned long _acToucan[] = {
#if (GUI_USE_ARGB == 1)
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0xD2787244, 0xCB4A3822, 0xFF7D626D, 0xFF705957, 0xFF62404A, 0xFF62404A, 0xFF5F3B38, 0xFF5F3B38, 0xFF5F3B38, 0xFF4C1527, 0xFF55322E, 0xFF55322E, 0xFF5F3B38, 0xFF62404A, 0xFF7D626D, 0xCB4A3822, 0x74404022, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x74404022, 0xFF62404A, 0xFF62404A, 0xFF62404A, 0xFF55322E, 
        0xFF62404A, 0xFF705957, 0xFF705957, 0xFF705957, 0xFF705957, 0xFF62404A, 0xFF62404A, 0xFF62404A, 0xFF62404A, 0xFF62404A, 0xFF62404A, 0xFF62404A, 0xFF5F3B38, 0xFF55322E, 0xFF55322E, 0xFF482222, 0xFF3D0022, 0xFF3B001C, 0xFF48002B, 0xFF5F3B38, 
        0xE4553B2B, 0xCB4A3822, 0x74404022, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x74404022, 0xCB4A3822, 0xFF62404A, 0xFF55322E, 0xFF635248, 0xFF837278, 0xFF837278, 0xFF837278, 0xFF7D626D, 
        0xFF705957, 0xFF635248, 0xFF7D626D, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF837278, 0xFF837278, 0xFF837278, 0xFF7D626D, 0xFF705957, 0xFF705957, 0xFF62404A, 0xFF62404A, 0xFF55322E, 0xFF4C1527, 0xFF48002B, 
        0xFF400022, 0xFF3B001C, 0xFF3B001C, 0xFF55322E, 0xCB4A3822, 0x74404022, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xD2787244, 0xCB4A3822, 0xFF705957, 0xFF705957, 0xFF7D626D, 0xFF7D626D, 0xFF837278, 0xFF7D626D, 0xFF705957, 0xFF7D626D, 0xFF908494, 0xFFACA7B6, 
        0xFFACA7B6, 0xFFACA7B6, 0xFFACA7B6, 0xFFACA7B6, 0xFF908494, 0xFF837278, 0xFF7D626D, 0xFF7D626D, 0xFF7D626D, 0xFF705957, 0xFF62404A, 0xFF62404A, 0xFF62404A, 0xFF62404A, 0xFF5F3B38, 0xFF55322E, 0xFF4C1527, 0xFF4C1527, 0xFF4C1527, 0xFF48002B, 
        0xFF46001C, 0xFF420022, 0xFF3D001C, 0xFF2E0015, 0xFF35001C, 0xFF48002B, 0xE4553B2B, 0x74404022, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x74404022, 0xD2787244, 0xFF705957, 0xFF62404A, 0xFF7D626D, 0xFF837278, 0xFF837278, 0xFF837278, 0xFF635248, 0xFF908494, 0xFFACA7B6, 0xFFACA7B6, 0xFFACA7B6, 0xFFACA7B6, 0xFF908494, 
        0xFF837278, 0xFF837278, 0xFF837278, 0xFF837278, 0xFF837278, 0xFF837278, 0xFF837278, 0xFF837278, 0xFF837278, 0xFF7D626D, 0xFF837278, 0xFF7D626D, 0xFF705957, 0xFF705957, 0xFF635248, 0xFF5F3B38, 0xFF55322E, 0xFF48002B, 0xFF48002B, 0xFF48002B, 
        0xFF420022, 0xFF420022, 0xFF420022, 0xFF38001C, 0xFF3B001C, 0xFF35001C, 0xFF35001C, 0xFF55322E, 0xFF7D626D, 0x74404022, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x6F150000, 0xFF837278, 0xFF837278, 0xFF55322E, 0xFF705957, 0xFFACA7B6, 0xFF837278, 0xFF705957, 0xFFACA7B6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFF908494, 0xFF7D626D, 0xFF7D626D, 0xFF7D626D, 0xFF7D626D, 
        0xFF837278, 0xFF908494, 0xFF908494, 0xFF908494, 0xFFACA7B6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFACA7B6, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF837278, 0xFF705957, 0xFF635248, 0xFF62404A, 0xFF55322E, 0xFF4C1527, 0xFF48002B, 
        0xFF420022, 0xFF420022, 0xFF420022, 0xFF3D0022, 0xFF38001C, 0xFF350015, 0xFF35001C, 0xFF35001C, 0xFF3B001C, 0xFF83573D, 0x74404022, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0xD2787244, 0xFF705957, 0xFF5F3B38, 0xFF4C1527, 0xFF908494, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFACA7B6, 0xFFACA7B6, 0xFF908494, 0xFF7D626D, 0xFF705957, 0xFF62404A, 0xFF705957, 0xFF705957, 0xFF7D626D, 0xFF837278, 0xFF908494, 
        0xFFACA7B6, 0xFFACA7B6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFACA7B6, 0xFF908494, 0xFF908494, 0xFF837278, 0xFF837278, 0xFF7D626D, 0xFF705957, 0xFF62404A, 0xFF55322E, 0xFF4C1527, 0xFF48002B, 0xFF46001C, 
        0xFF420022, 0xFF3D001C, 0xFF38001C, 0xFF3B001C, 0xFF35001C, 0xFF35001C, 0xFF2E0015, 0xFF35001C, 0xFF35001C, 0xFF38001C, 0xFF83573D, 0x74404022, 0x02000000, 0x02000000, 0x01000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6F150000, 
        0xC8351500, 0xFF908494, 0xFF55322E, 0xFF482222, 0xFF4C1527, 0xFF5F3B38, 0xFF62404A, 0xFF705957, 0xFF635248, 0xFF55322E, 0xFF5F3B38, 0xFF62404A, 0xFF635248, 0xFF705957, 0xFF705957, 0xFF7D626D, 0xFF908494, 0xFF908494, 0xFF908494, 0xFFACA7B6, 
        0xFFACA7B6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFACA7B6, 0xFF908494, 0xFF908494, 0xFF837278, 0xFF7D626D, 0xFF7D626D, 0xFF7D626D, 0xFF62404A, 0xFF55322E, 0xFF4C1527, 0xFF48002B, 0xFF4C1527, 0xFF400022, 0xFF420022, 
        0xFF420022, 0xFF420022, 0xFF3B001C, 0xFF2E0015, 0xFF35001C, 0xFF35001C, 0xFF35001C, 0xFF2E0015, 0xFF350015, 0xFF35001C, 0xFF3B001C, 0xFF902E27, 0x74404022, 0x05000000, 0x04000000, 0x03000000, 0x02000000, 0x02000000, 0x01000000, 0x01000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xCB4A3822, 0xFF62404A, 0xFF4C1527, 0xFF420022, 
        0xFF55322E, 0xFF574027, 0xFF4C1527, 0xFF4C1527, 0xFF55322E, 0xFF5F3B38, 0xFF4C1527, 0xFF55322E, 0xFF5F3B38, 0xFF5F3B38, 0xFF635248, 0xFF635248, 0xFF705957, 0xFF7D626D, 0xFF837278, 0xFF908494, 0xFF908494, 0xFF908494, 0xFFACA7B6, 0xFFACA7B6, 
        0xFFACA7B6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFACA7B6, 0xFFACA7B6, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF837278, 0xFF7D626D, 0xFF7D626D, 0xFF705957, 0xFF635248, 0xFF62404A, 0xFF5F3B38, 0xFF55322E, 0xFF48002B, 0xFF48002B, 0xFF3D001C, 0xFF3B001C, 
        0xFF38001C, 0xFF38001C, 0xFF35001C, 0xFF35001C, 0xFF35001C, 0xFF350022, 0xFF35001C, 0xFF35001C, 0xFF2E0015, 0xFF350015, 0xFF38001C, 0xFF400022, 0xFFACA7B6, 0x0A000000, 0x09000000, 0x07000000, 0x06000000, 0x04000000, 0x03000000, 0x02000000, 
        0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xC8351500, 0xEA3D1515, 0xFF48002B, 0xFF400022, 0xFF400022, 0xFF4C1527, 0xFF3D0022, 
        0xFFA37622, 0xFFAD8722, 0xFF6F5A22, 0xFF5F3B38, 0xFF635248, 0xFF635248, 0xFF5F3B38, 0xFF5F3B38, 0xFF5F3B38, 0xFF62404A, 0xFF705957, 0xFF705957, 0xFF837278, 0xFF837278, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF908494, 0xFFACA7B6, 0xFFACA7B6, 
        0xFFACA7B6, 0xFFACA7B6, 0xFFACA7B6, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF837278, 0xFF837278, 0xFF7D626D, 0xFF7D626D, 0xFF62404A, 0xFF62404A, 0xFF5F3B38, 0xFF48002B, 0xFF400022, 0xFF3D0022, 0xFF3B001C, 0xFF3B001C, 0xC8351500, 0xC8351500, 
        0xC8351500, 0xC8351500, 0xC8351500, 0xC8351500, 0xC8351500, 0xC8351500, 0xC8351500, 0xC8351500, 0xC8351500, 0xC8351500, 0xC8351500, 0xEA3D1515, 0xFF66001C, 0x12000000, 0x10000000, 0x0E000000, 0x0B000000, 0x09000000, 0x07000000, 0x06000000, 
        0x04000000, 0x03000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xC8351500, 0xEA3D1515, 0xFF3D001C, 0xFF3D001C, 0xFF3B001C, 0xFF38001C, 0xFF3D001C, 0xFF4C1527, 0xFF46001C, 
        0xFFC87E1C, 0xFFFCD21C, 0xFFD8BE46, 0xFF7F7B42, 0xFF705957, 0xFF635248, 0xFF5F3B38, 0xFF5F3B38, 0xFF5F3B38, 0xFF635248, 0xFF705957, 0xFF705957, 0xFF7D626D, 0xFF837278, 0xFF837278, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF908494, 
        0xFF908494, 0xFF908494, 0xFFACA7B6, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF7D626D, 0xFF705957, 0xFF62404A, 0xFF5F3B38, 0xFF48002B, 0xFF48002B, 0xFE503227, 0xC8351500, 0xC8351500, 0xC8351500, 0xC8351500, 0x8B150000, 0x34000000, 0x34000000, 
        0x34000000, 0x34000000, 0x34000000, 0x34000000, 0x34000000, 0x33000000, 0x31000000, 0x2F000000, 0x2C000000, 0x2C000000, 0x27000000, 0x25000000, 0xC8351500, 0x1D000000, 0x1B000000, 0x17000000, 0x14000000, 0x11000000, 0x0E000000, 0x0B000000, 
        0x08000000, 0x06000000, 0x04000000, 0x03000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6F150000, 0xEA3D1515, 0xFF3B001C, 0xFF38001C, 0xFF3D001C, 0xFF38001C, 0xFF38001C, 0xFF35001C, 0xFF3D001C, 0xFF55322E, 0xFF55322E, 
        0xFFC87E1C, 0xFFFBE01C, 0xFFFAE632, 0xFFD8BE46, 0xFF87994C, 0xFF705957, 0xFF705957, 0xFF705957, 0xFF705957, 0xFF635248, 0xFF705957, 0xFF705957, 0xFF7D626D, 0xFF7D626D, 0xFF837278, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF908494, 
        0xFFACA7B6, 0xFFACA7B6, 0xFF908494, 0xFF7D626D, 0xFF62404A, 0xFF482222, 0xFF4C1527, 0xEA3D1515, 0xC8351500, 0x32000000, 0x34000000, 0x39000000, 0x3C000000, 0x3F000000, 0x42000000, 0x44000000, 0x44000000, 0x46000000, 0x48000000, 0x48000000, 
        0x49000000, 0x49000000, 0x49000000, 0x48000000, 0x46000000, 0x46000000, 0x44000000, 0x44000000, 0x3F000000, 0x3C000000, 0x39000000, 0x36000000, 0x32000000, 0x2F000000, 0x29000000, 0x25000000, 0x20000000, 0x1B000000, 0x17000000, 0x13000000, 
        0x0F000000, 0x0B000000, 0x08000000, 0x05000000, 0x03000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6F150000, 0xFF420022, 0xFF3D001C, 0xFF38001C, 0xFF3D001C, 0xFF66001C, 0xFE8D1C22, 0xFF66001C, 0xFF4C1527, 0xFF3D001C, 0xFF400022, 0xFF705957, 
        0xFFC87E1C, 0xFFFCE422, 0xFFFCED40, 0xFFF5F07A, 0xFFD4ED6D, 0xFFACA7B6, 0xFF908494, 0xFF837278, 0xFF7D626D, 0xFF7D626D, 0xFF705957, 0xFF705957, 0xFF705957, 0xFF7D626D, 0xFF7D626D, 0xFF908494, 0xFF908494, 0xFF908494, 0xFFACA7B6, 0xFF908494, 
        0xFF837278, 0xFF5F3B38, 0xFF482222, 0xFF482222, 0xC8351500, 0x34000000, 0x39000000, 0x3C000000, 0x42000000, 0x44000000, 0x49000000, 0x4E000000, 0x50150000, 0x54000000, 0x54000000, 0x58000000, 0x5B000000, 0x5B000000, 0x5D150000, 0x5D150000, 
        0x5E000000, 0x5E000000, 0x5E000000, 0x5D150000, 0x5B000000, 0x5B000000, 0x5B000000, 0x58000000, 0x54000000, 0x51000000, 0x4E000000, 0x49000000, 0x44000000, 0x3F000000, 0x3B000000, 0x34000000, 0x31000000, 0x2A000000, 0x24000000, 0x1D000000, 
        0x18000000, 0x13000000, 0x0E000000, 0x0A000000, 0x07000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6B151C00, 0xFF400022, 0xFF3D001C, 0xFF3B001C, 0xFF46001C, 0xFF992B22, 0xFFC87E1C, 0xFFC87E1C, 0xFFC87E1C, 0xFF992B22, 0xFE8D1C22, 0xFF66001C, 0xFF705957, 
        0xFFC87E1C, 0xFFFFE922, 0xFFFCED40, 0xFFF5F07A, 0xFFF5F07A, 0xFFC2BEC6, 0xFFACA7B6, 0xFFC2BEC6, 0xFF7D626D, 0xFF635248, 0xFF62404A, 0xFF62404A, 0xFF62404A, 0xFF705957, 0xFF7D626D, 0xFF908494, 0xFFACA7B6, 0xFF908494, 0xFF705957, 0xFF55322E, 
        0xEA3D1515, 0x8B150000, 0x37000000, 0x3C000000, 0x42000000, 0x46000000, 0x4C150000, 0x51000000, 0x54000000, 0x5B000000, 0x5E000000, 0x61150000, 0x65150000, 0x67000000, 0x6A000000, 0x6E000000, 0x6E000000, 0x71000000, 0x71000000, 0x71000000, 
        0x71000000, 0x71000000, 0x71000000, 0x71000000, 0x71000000, 0x6F150000, 0x6E000000, 0x6B151500, 0x6A000000, 0x67000000, 0x63000000, 0x5E000000, 0x58150000, 0x54000000, 0x4E000000, 0x48000000, 0x42000000, 0x3B000000, 0x33000000, 0x2C000000, 
        0x24000000, 0x1D000000, 0x16000000, 0x10000000, 0x0B000000, 0x07000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x74404022, 0xFF482222, 0xFF3D001C, 0xFF35001C, 0xFF3B001C, 0xFF992B22, 0xFFC87E1C, 0xFF992B22, 0xFF7A382B, 0xFF902E27, 0xFF992B22, 0xFF992B22, 0xFF8D2E22, 0xFF837278, 
        0xFFAD8722, 0xFFFFEB32, 0xFFF5F07A, 0xFFF5F07A, 0xFFF5F07A, 0xFCBEC678, 0xFFC2BEC6, 0xFF908494, 0xFF7D626D, 0xFF5F3B38, 0xFF55322E, 0xFF55322E, 0xFF5F3B38, 0xFF62404A, 0xFF705957, 0xFF62404A, 0xFF4C1527, 0xEA3D1515, 0xCB4A3822, 0x37000000, 
        0x3E000000, 0x44000000, 0x4A000000, 0x50150000, 0x58150000, 0x5B000000, 0x61150000, 0x67000000, 0x6A000000, 0x6E000000, 0x71000000, 0x74000000, 0x77000000, 0x7A000000, 0x7C000000, 0x7F000000, 0x7F000000, 0x82000000, 0x82000000, 0x82000000, 
        0x82000000, 0x82000000, 0x82000000, 0x82000000, 0x82000000, 0x82000000, 0x7F000000, 0x7C000000, 0x7C000000, 0x77000000, 0x74000000, 0x71000000, 0x6B151500, 0x67000000, 0x61150000, 0x5B150000, 0x54150000, 0x4C150000, 0x44000000, 0x3B000000, 
        0x32000000, 0x27000000, 0x20000000, 0x18000000, 0x11000000, 0x0B000000, 0x07000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xFF4C1527, 0xFF3D001C, 0xFF380015, 0xFF350015, 0xFF4C1527, 0xFFC87E1C, 0xFFC87E1C, 0xFF66001C, 0xFF705957, 0xFF7D626D, 0xFF992B22, 0xFFC87E1C, 0xFF992B22, 0xFF66001C, 
        0xFF83573D, 0xFFF0C52B, 0xFFF5F07A, 0xFFF5F07A, 0xFFF5F07A, 0xFFD8BE46, 0xFF837278, 0xFF635248, 0xFF62404A, 0xFF4C1527, 0xFF4C1527, 0xFF4C1527, 0xFF4C1527, 0xFF4C1527, 0xEA3D1515, 0xC8351500, 0x34000000, 0x3B000000, 0x44000000, 0x4A000000, 
        0x51000000, 0x58150000, 0x5D150000, 0x65150000, 0x6A000000, 0x6F150000, 0x74000000, 0x77000000, 0x7C000000, 0x7F000000, 0x82000000, 0x85150000, 0x86000000, 0x8A000000, 0x8C000000, 0x8C000000, 0x8F000000, 0x8F000000, 0x8F000000, 0x8F000000, 
        0x8F000000, 0x8F000000, 0x8F000000, 0x8F000000, 0x8F000000, 0x8F000000, 0x8C000000, 0x8B150000, 0x86000000, 0x86000000, 0x82000000, 0x7F000000, 0x7C000000, 0x77150000, 0x71000000, 0x6B151500, 0x65150000, 0x5D150000, 0x54150000, 0x4A000000, 
        0x3F000000, 0x34000000, 0x2C000000, 0x21000000, 0x18000000, 0x10000000, 0x0A000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xCB4A3822, 0xFF420022, 0xFF35001C, 0xFF350015, 0xFF2E0015, 0xFF66001C, 0xFFC87E1C, 0xFF992B22, 0xFF5A001C, 0xFF705957, 0xFF7D626D, 0xFF8D2E22, 0xFFC87E1C, 0xFF992B22, 0xFF5A001C, 
        0xFF5F3B38, 0xFFD8BE46, 0xFFFCD21C, 0xFFF0C52B, 0xFFFACC1C, 0xFFF0C52B, 0xFF8E8140, 0xFF5F3B38, 0xFF48002B, 0xFF48002B, 0xFF48002B, 0xFF46001C, 0xEA3D1515, 0x8B150000, 0x34000000, 0x3C000000, 0x46000000, 0x4E000000, 0x58150000, 0x5D150000, 
        0x65150000, 0x6B151500, 0x71000000, 0x77000000, 0x7C000000, 0x80151500, 0x85150000, 0x86000000, 0x8B150000, 0x8F000000, 0x8F000000, 0x93000000, 0x93000000, 0x95000000, 0x96000000, 0x98000000, 0x98000000, 0x99000000, 0x99000000, 0x99000000, 
        0x99000000, 0x98000000, 0x98000000, 0x96000000, 0x96000000, 0x96000000, 0x93000000, 0x93000000, 0x91000000, 0x8F000000, 0x8C000000, 0x8A000000, 0x85150000, 0x82000000, 0x7E150000, 0x77150000, 0x71000000, 0x6B151500, 0x61150000, 0x58150000, 
        0x4E000000, 0x42000000, 0x36000000, 0x2A000000, 0x1F000000, 0x16000000, 0x0E000000, 0x09000000, 0x05000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xEA3D1515, 0xFF38001C, 0xFF2E0015, 0xFF2E0015, 0xFF350015, 0xFF66001C, 0xFFC87E1C, 0xFFC87E1C, 0xFF992B22, 0xFF66001C, 0xFF663D22, 0xFF992B22, 0xFFC87E1C, 0xFFC87E1C, 0xFF7A382B, 
        0xFF55322E, 0xFFD8BE46, 0xFFF8C11C, 0xFFF8C11C, 0xFFF8C11C, 0xFFFACC1C, 0xFFD8BE46, 0xFF727E3B, 0xFF705957, 0xFF55322E, 0xFF48002B, 0xEA3D1515, 0x8B150000, 0x3F000000, 0x46000000, 0x50150000, 0x58150000, 0x61150000, 0x6A150000, 0x71000000, 
        0xE4553B2B, 0xE4553B2B, 0xE4553B2B, 0xE4553B2B, 0xE4553B2B, 0xE4553B2B, 0xE4553B2B, 0xE6502222, 0xE6502222, 0xE4553B2B, 0xE4553B2B, 0xFF705957, 0xFF705957, 0x9D000000, 0x9D000000, 0x9D000000, 0x9D000000, 0x9D000000, 0x9D000000, 0x9D000000, 
        0x9C000000, 0x9C000000, 0x9A000000, 0x9A000000, 0x99000000, 0x98000000, 0x96000000, 0x95000000, 0x93000000, 0x91000000, 0x8F000000, 0x8C000000, 0x8A000000, 0x86000000, 0x82000000, 0x7E150000, 0x7A000000, 0x74151500, 0x6B151500, 0x61150000, 
        0x58150000, 0x4C150000, 0x3F000000, 0x32000000, 0x26000000, 0x1B000000, 0x12000000, 0x0B000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xE6502222, 0xFF400022, 0xFF35001C, 0xFF350015, 0xFF2E0015, 0xFF350015, 0xFF66001C, 0xFFE6841C, 0xFFE6841C, 0xFFC87E1C, 0xFFC87E1C, 0xFFC87E1C, 0xFFC87E1C, 0xFFC87E1C, 0xFFC87E1C, 0xFF7A382B, 
        0xFF4C1527, 0xFFC87E1C, 0xFFF8C11C, 0xFFF8C11C, 0xFFFCD21C, 0xFFFCED40, 0xFFF5F07A, 0xFCBEC678, 0xFF705957, 0xFF55322E, 0xEA3D1515, 0x42000000, 0x4A000000, 0x51000000, 0xD65C672E, 0xFF83573D, 0xFF8D2E22, 0xFF902E27, 0xFF902E27, 0xFF992B22, 
        0xFF992B22, 0xFF992B22, 0xFF902E27, 0xFF902E27, 0xFF8D2E22, 0xFF8D2E22, 0xFF8D2E22, 0xFF7A382B, 0xFF7A382B, 0xFF7A382B, 0xFF7A382B, 0xFF7A382B, 0xFF7A382B, 0xFF83573D, 0xFF83573D, 0xFF83573D, 0xFF83573D, 0xE4553B2B, 0xE4553B2B, 0xE4553B2B, 
        0x9A000000, 0x9A000000, 0x99000000, 0x98000000, 0x96000000, 0x95000000, 0x93000000, 0x93000000, 0x8F000000, 0x8F000000, 0x8C000000, 0x8A000000, 0x86000000, 0x85150000, 0x82000000, 0x7E150000, 0x7A000000, 0x74151500, 0x6F150000, 0x67000000, 
        0x5D150000, 0x54150000, 0x44000000, 0x37000000, 0x2C000000, 0x1F000000, 0x15000000, 0x0E000000, 0x08000000, 0x04000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xFF420022, 0xFF3D001C, 0xFF2E0015, 0xFF2E0015, 0xFF2E0015, 0xFF350015, 0xFF7A382B, 0xFFE6841C, 0xFFE6841C, 0xFFE6841C, 0xFFE6841C, 0xFFE6841C, 0xFFE6841C, 0xFFE6841C, 0xFFE6841C, 0xFF902E27, 
        0xFF46001C, 0xFFC87E1C, 0xFFFBE01C, 0xFFFCED40, 0xFFF5F07A, 0xFCBEC678, 0xFF83573D, 0xFF663D22, 0xFF7A382B, 0xFFA37622, 0xFFA37622, 0xFFC87E1C, 0xFFA37622, 0xFF992B22, 0xFF8D2E22, 0xFF7A382B, 0xFF66001C, 0xFF5F3B38, 0xFF5F3B38, 0xFF635248, 
        0xFF705957, 0xFF705957, 0xFF635248, 0xFF62404A, 0xFF635248, 0xFF62404A, 0xFF62404A, 0xFF55322E, 0xFF4C1527, 0xFF4C1527, 0xFF4C1527, 0xFF55322E, 0xFF48002B, 0xFF48002B, 0xFF48002B, 0xFF48002B, 0xFF4C1527, 0xFF5A001C, 0xFF7A382B, 0xFF83573D, 
        0xFF83573D, 0xFF83573D, 0xE4553B2B, 0xD2787244, 0xD65C672E, 0x8C000000, 0x8B150000, 0x8A000000, 0x86000000, 0x85150000, 0x82000000, 0x7F000000, 0x7E150000, 0x7C000000, 0x7A000000, 0x77000000, 0x74151500, 0x6F150000, 0x6B151500, 0x65150000, 
        0x5D150000, 0x54150000, 0x46000000, 0x3B000000, 0x2F000000, 0x22000000, 0x17000000, 0x0F000000, 0x09000000, 0x05000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xFF420022, 0xFF38001C, 0xFF350015, 0xFF2E0015, 0xFF2E0015, 0xFF46001C, 0xFF992B22, 0xFFE6841C, 0xFFE6841C, 0xFFF5AD1C, 0xFFE6841C, 0xFFE6841C, 0xFFF5AD1C, 0xFFE6841C, 0xFFE6841C, 0xFFC87E1C, 
        0xFD461C22, 0xFF992B22, 0xFFF5F07A, 0xFCBEC678, 0xFF8E8140, 0xFF663D22, 0xFF663D22, 0xFF5A001C, 0xFF663D22, 0xFF5F3B38, 0xFF705957, 0xFF7D626D, 0xFF7D626D, 0xFF7D626D, 0xFF7D626D, 0xFF7D626D, 0xFF705957, 0xFF705957, 0xFF62404A, 0xFF55322E, 
        0xFF48002B, 0xFF420022, 0xFF400022, 0xFF3B001C, 0xFF38001C, 0xFF35001C, 0xFF35001C, 0xFF35001C, 0xFF35001C, 0xFF35001C, 0xFF35001C, 0xFF2E0015, 0xFF35001C, 0xFF35001C, 0xFF35001C, 0xFF2E0015, 0xFF35001C, 0xFF35001C, 0xFF38001C, 0xFF35001C, 
        0xFF3D001C, 0xFF4C1527, 0xFF55322E, 0xFF663D22, 0xFF7A382B, 0xFF896D22, 0xFF705957, 0xA6444222, 0x7A000000, 0x77000000, 0x74000000, 0x71000000, 0x6F150000, 0x6E000000, 0x6A000000, 0x6A000000, 0x67000000, 0x65150000, 0x61150000, 0x5D150000, 
        0x54150000, 0x4C150000, 0x44000000, 0x37000000, 0x2C000000, 0x21000000, 0x17000000, 0x0F000000, 0x09000000, 0x05000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x6F150000, 0xFF3D001C, 0xFF38001C, 0xFF38001C, 0xFF35001C, 0xFF400022, 0xFFA37622, 0xFFE6841C, 0xFFF5AD1C, 0xFFF8C11C, 0xFFFCD21C, 0xFFFBCB1C, 0xFFFACC1C, 0xFFFCD21C, 0xFFF8C11C, 0xFFF8C11C, 0xFFF5AD1C, 
        0xFF896D22, 0xFF5A001C, 0xFF663D22, 0xFF5F3B38, 0xFF5D542B, 0xFF837278, 0xFF908494, 0xFF908494, 0xFF837278, 0xFF7D626D, 0xFF62404A, 0xFF3D0027, 0xFF3D0022, 0xFF38001C, 0xFF38001C, 0xFF38001C, 0xFF3B001C, 0xFF38001C, 0xFF35001C, 0xFF35001C, 
        0xFF35001C, 0xFF38001C, 0xFF38001C, 0xFF350022, 0xFF350022, 0xFF350022, 0xFF38001C, 0xFF350022, 0xFF2E0015, 0xFF2E0015, 0xFF2E0015, 0xFF2E0015, 0xFF35001C, 0xFF35001C, 0xFF2E0015, 0xFF2E0015, 0xFF2E0015, 0xFF2E0015, 0xFF2E0015, 0xFF2E0015, 
        0xFF2E0015, 0xFF2E0015, 0xFF35001C, 0xFF2E0015, 0xFF38001C, 0xFF3B001C, 0xFF5F3B38, 0xFF635248, 0xFF705957, 0xA6444222, 0x61150000, 0x5E000000, 0x5B000000, 0x5B000000, 0x58000000, 0x58000000, 0x54000000, 0x54000000, 0x51000000, 0x4E000000, 
        0x4A000000, 0x44000000, 0x3B000000, 0x32000000, 0x27000000, 0x1F000000, 0x16000000, 0x0E000000, 0x09000000, 0x05000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0xC8351500, 0xFF420022, 0xFF38001C, 0xFF38001C, 0xFF350015, 0xFF7A382B, 0xFFE6841C, 0xFFF5AD1C, 0xFFF5AD1C, 0xFFFBCB1C, 0xFFFACC1C, 0xFFFCD21C, 0xFFFBE01C, 0xFFFCE422, 0xFFFCE01C, 0xFFFCD21C, 0xFFFACC1C, 
        0xFFAD8722, 0xFF837278, 0xFCBEC678, 0xFFC2BEC6, 0xFFF5F07A, 0xFFF5F07A, 0xFFD8BE46, 0xFF83573D, 0xFF482222, 0xFF3B001C, 0xFF38001C, 0xFF38001C, 0xFF38001C, 0xFF350022, 0xFF38001C, 0xFF38001C, 0xFF38001C, 0xFF38001C, 0xFF38001C, 0xFF35001C, 
        0xFF38001C, 0xFF38001C, 0xFF35001C, 0xFF35001C, 0xFF38001C, 0xFF35001C, 0xFF35001C, 0xFF35001C, 0xFF350015, 0xFF350015, 0xFF35001C, 0xFF35001C, 0xFF48002B, 0xFF35001C, 0xFF35001C, 0xFF350015, 0xFF350015, 0xFF2E0015, 0xFF38001C, 0xFF350015, 
        0xFF350015, 0xFF350015, 0xFF3B001C, 0xFF3B001C, 0xFF3B001C, 0xFF35001C, 0xFF38001C, 0xFF35001C, 0xFF46001C, 0xFF5F3B38, 0xCB4A3822, 0x4A000000, 0x48000000, 0x46000000, 0x44000000, 0x44000000, 0x44000000, 0x42000000, 0x42000000, 0x3E000000, 
        0x3B000000, 0x36000000, 0x31000000, 0x29000000, 0x22000000, 0x1A000000, 0x12000000, 0x0C000000, 0x07000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0xFF420022, 0xFF3D001C, 0xFF400022, 0xFF35001C, 0xFF66001C, 0xFFC87E1C, 0xFFE6841C, 0xFFF5AD1C, 0xFFF8C11C, 0xFFFCE01C, 0xFFFFEB32, 0xFFFAE632, 0xFFFFEB32, 0xFFFEE622, 0xFFFAE632, 0xFFFAE632, 0xFFFBE01C, 
        0xFFAD8722, 0xFF62404A, 0xFFC87E1C, 0xFFF5F07A, 0xFFF5F07A, 0xFFF5AD1C, 0xFFF5AD1C, 0xFFC87E1C, 0xFF896D22, 0xFF3B001C, 0xFF38001C, 0xFF38001C, 0xFF35001C, 0xFF38001C, 0xFF38001C, 0xFF35001C, 0xFF35001C, 0xFF38001C, 0xFF38001C, 0xFF38001C, 
        0xFF38001C, 0xFF38001C, 0xFF38001C, 0xFF38001C, 0xFF3B001C, 0xFF3B001C, 0xFF3B001C, 0xFF3D001C, 0xFF3D001C, 0xFF3D001C, 0xFF400022, 0xFF420022, 0xFF48002B, 0xFF420022, 0xFF48002B, 0xFF482222, 0xFF4C1527, 0xFF4C1527, 0xFF4C1527, 0xFF55322E, 
        0xFF5F3B38, 0xFF5F3B38, 0xFF574027, 0xFF5F3B38, 0xFF5F3B38, 0xFF55322E, 0xFF55322E, 0xFE503227, 0xFF482222, 0xFF400022, 0xFF482222, 0xE6502222, 0x36000000, 0x34000000, 0x33000000, 0x32000000, 0x31000000, 0x31000000, 0x2F000000, 0x2F000000, 
        0x2C000000, 0x29000000, 0x25000000, 0x20000000, 0x1A000000, 0x14000000, 0x0F000000, 0x0A000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0xFF420022, 0xFF3B001C, 0xFF35001C, 0xFF380015, 0xFF992B22, 0xFFE6841C, 0xFFF5AD1C, 0xFFFBCB1C, 0xFFFCE01C, 0xFFFFEB32, 0xFFFCE422, 0xFFFCED40, 0xFFFCED40, 0xFFFFE922, 0xFFFCED40, 0xFFFCE422, 0xFFFBE01C, 
        0xFFB9C32E, 0xFF420022, 0xFF992B22, 0xFFFCD21C, 0xFFFACC1C, 0xFFF5AD1C, 0xFFE6841C, 0xFFE6841C, 0xFFC87E1C, 0xFF574027, 0xFF3D0022, 0xFF38001C, 0xFF38001C, 0xFF35001C, 0xFF38001C, 0xFF35001C, 0xFF38001C, 0xFF38001C, 0xFF3D0027, 0xFF38001C, 
        0xFF3D0022, 0xFF3B001C, 0xFF400022, 0xFF3D0022, 0xFF400022, 0xFF420022, 0xFF46001C, 0xFF4C1527, 0xFF5F3B38, 0xFF62404A, 0xFF62404A, 0xFF635248, 0xD65C672E, 0xE4553B2B, 0xE4553B2B, 0xE4553B2B, 0xCB4A3822, 0xE4553B2B, 0xE4553B2B, 0x51000000, 
        0x4E000000, 0x49000000, 0x44000000, 0x42000000, 0x3E000000, 0x3B000000, 0x37000000, 0x34000000, 0x32000000, 0x8B150000, 0xCB4A3822, 0xFF574027, 0xCB4A3822, 0x26000000, 0x24000000, 0x23000000, 0x22000000, 0x22000000, 0x21000000, 0x20000000, 
        0x1D000000, 0x1C000000, 0x1A000000, 0x16000000, 0x12000000, 0x0E000000, 0x0A000000, 0x07000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0xFF3D0022, 0xFF38001C, 0xFF38001C, 0xFF8D2E22, 0xFFE6841C, 0xFFF5AD1C, 0xFFF8C11C, 0xFFFCD21C, 0xFFFEE122, 0xFFFFEB32, 0xFFFFEB32, 0xFFFCED40, 0xFFFCED40, 0xFFFFEB32, 0xFFFEE622, 0xFFFBE01C, 0xFFFCE422, 
        0xFFD8BE46, 0xFF46001C, 0xFF5A001C, 0xFFE6841C, 0xFFF0C52B, 0xFFF0C52B, 0xFFF5AD1C, 0xFFF5AD1C, 0xFFE6841C, 0xFF6F5A22, 0xFF3D001C, 0xFF3D001C, 0xFF38001C, 0xFF35001C, 0xFF38001C, 0xFF3B001C, 0xFF3B001C, 0xFF3B001C, 0xFF3B001C, 0xFF420022, 
        0xFF400022, 0xFF4C1527, 0xFF55322E, 0xFF62404A, 0xFF705957, 0xE4553B2B, 0xE4553B2B, 0xE4553B2B, 0xCB4A3822, 0x7E150000, 0x77000000, 0x71000000, 0x6E000000, 0x67000000, 0x61150000, 0x5D150000, 0x54000000, 0x51000000, 0x4C150000, 0x46000000, 
        0x44000000, 0x3F000000, 0x3B000000, 0x37000000, 0x34000000, 0x31000000, 0x2F000000, 0x2C000000, 0x29000000, 0x26000000, 0x23000000, 0x21000000, 0x1D000000, 0x1C000000, 0x1B000000, 0x19000000, 0x18000000, 0x17000000, 0x16000000, 0x16000000, 
        0x14000000, 0x13000000, 0x11000000, 0x0F000000, 0x0C000000, 0x09000000, 0x07000000, 0x05000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0xC8351500, 0xFF35001C, 0xFF35001C, 0xFF3B001C, 0xFF8D2E22, 0xFFE6841C, 0xFFF5AD1C, 0xFFFCD21C, 0xFFFCE01C, 0xFFFFE922, 0xFFFFEB32, 0xFFFFE922, 0xFFFFEB32, 0xFFFCE422, 0xFFFAE632, 0xFFFAE632, 0xFFFBE01C, 0xFFFCD21C, 
        0xFFF0C52B, 0xFF655522, 0xFF400022, 0xFF8D2E22, 0xFFF5AD1C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFF5AD1C, 0xFFF5AD1C, 0xFF6F5A22, 0xFF400022, 0xFF38001C, 0xFF3D0022, 0xFF3D0022, 0xFF420022, 0xFF420022, 0xFF48002B, 0xFF48002B, 0xFF55322E, 0xFF55322E, 
        0xE6502222, 0xE4553B2B, 0xCB4A3822, 0x99000000, 0x93000000, 0x8F150000, 0x86000000, 0x80151500, 0x7C000000, 0x74000000, 0x6F150000, 0x6A150000, 0x65150000, 0x5E000000, 0x5B150000, 0x54150000, 0x50150000, 0x4C150000, 0x46000000, 0x44000000, 
        0x3F000000, 0x3C000000, 0x39000000, 0x36000000, 0x33000000, 0x2F000000, 0x2C000000, 0x2A000000, 0x27000000, 0x24000000, 0x21000000, 0x1D000000, 0x1C000000, 0x1A000000, 0x17000000, 0x16000000, 0x14000000, 0x12000000, 0x11000000, 0x10000000, 
        0x0E000000, 0x0D000000, 0x0B000000, 0x0A000000, 0x08000000, 0x06000000, 0x04000000, 0x03000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0xC8351500, 0xFF3B001C, 0xFF35001C, 0xFF8D2E22, 0xFFE6841C, 0xFFF5AD1C, 0xFFFACC1C, 0xFFFEE122, 0xFFFEE622, 0xFFFFEB32, 0xFFFFEB32, 0xFFFFEB32, 0xFFFEE622, 0xFFFCE422, 0xFFFEE122, 0xFFFCE422, 0xFFFBE01C, 0xFFFCD21C, 
        0xFFFACC1C, 0xFFD8BE46, 0xFF83573D, 0xFF4C1527, 0xFF5A001C, 0xFFA37622, 0xFFD8BE46, 0xFFF5AD1C, 0xFFF0C52B, 0xFFD8BE46, 0xFF8E8140, 0xFF655522, 0xFF5F3B38, 0xFF5F3B38, 0xFF55322E, 0xFF55322E, 0xE6502222, 0xC8351500, 0xA6000000, 0xA5000000, 
        0xA2000000, 0x9F000000, 0x9A000000, 0x95000000, 0x8F150000, 0x86000000, 0x82000000, 0x7C000000, 0x74000000, 0x6F150000, 0x6A150000, 0x65150000, 0x61150000, 0x5D150000, 0x58150000, 0x54150000, 0x50150000, 0x4C150000, 0x4A000000, 0x46000000, 
        0x44000000, 0x42000000, 0x3E000000, 0x3B000000, 0x37000000, 0x34000000, 0x32000000, 0x2F000000, 0x2C000000, 0x29000000, 0x26000000, 0x23000000, 0x20000000, 0x1D000000, 0x1B000000, 0x18000000, 0x16000000, 0x13000000, 0x11000000, 0x0F000000, 
        0x0D000000, 0x0B000000, 0x09000000, 0x07000000, 0x05000000, 0x04000000, 0x03000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0xEA3D1515, 0xFF420022, 0xFF4C1527, 0xFFC87E1C, 0xFFF5AD1C, 0xFFFBCB1C, 0xFFFEE622, 0xFFFFE922, 0xFFFFEB32, 0xFFFCED40, 0xFFFFEB32, 0xFFFFEB32, 0xFFFEE622, 0xFFFCE422, 0xFFFCE01C, 0xFFFCE01C, 0xFFFCD21C, 0xFFFCD21C, 
        0xFFF8C11C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFC87E1C, 0xFFA37622, 0xFF7A382B, 0xFF66001C, 0xFF55322E, 0xFF5A3D22, 0xE6502222, 0xE4553B2B, 0xE4553B2B, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA4000000, 
        0xA0000000, 0x9D000000, 0x99000000, 0x93000000, 0x8B150000, 0x85150000, 0x7F000000, 0x77000000, 0x74151500, 0x6F150000, 0x6A150000, 0x65150000, 0x61150000, 0x5E000000, 0x5D150000, 0x5B150000, 0x58150000, 0x54150000, 0x54150000, 0x50150000, 
        0x4E000000, 0x4C150000, 0x49000000, 0x46000000, 0x44000000, 0x42000000, 0x3E000000, 0x3B000000, 0x37000000, 0x34000000, 0x31000000, 0x2F000000, 0x2A000000, 0x27000000, 0x23000000, 0x20000000, 0x1C000000, 0x19000000, 0x16000000, 0x13000000, 
        0x10000000, 0x0D000000, 0x0A000000, 0x07000000, 0x05000000, 0x04000000, 0x02000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0xFF420022, 0xFF3B001C, 0xFF7A382B, 0xFFE6841C, 0xFFF5AD1C, 0xFFFCE01C, 0xFFFEE622, 0xFFFFEB32, 0xFFFCED40, 0xFFFFEB32, 0xFFFCED40, 0xFFFCED40, 0xFFFCE422, 0xFFFEE122, 0xFFFCE422, 0xFFFCD21C, 0xFFFCD21C, 0xFFFACC1C, 
        0xFFF8C11C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFF5AD1C, 0xFFE6841C, 0xFF896D22, 0xFF663D22, 0xE6502222, 0xC8351500, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA5000000, 0xA4000000, 
        0xA0000000, 0x9D000000, 0x98000000, 0x93000000, 0x8B150000, 0x85150000, 0x7F000000, 0x7A000000, 0x74000000, 0x71000000, 0x6F150000, 0x6B151500, 0x6A150000, 0x67000000, 0x65150000, 0x65150000, 0x63000000, 0x61150000, 0x61150000, 0x5D150000, 
        0x5D150000, 0x5B150000, 0x58150000, 0x58150000, 0x54150000, 0x50150000, 0x4E000000, 0x4A000000, 0x46000000, 0x44000000, 0x3F000000, 0x3C000000, 0x37000000, 0x34000000, 0x31000000, 0x2C000000, 0x27000000, 0x23000000, 0x1D000000, 0x1A000000, 
        0x15000000, 0x11000000, 0x0D000000, 0x0A000000, 0x07000000, 0x05000000, 0x03000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0xFF38001C, 0xFF46001C, 0xFFC87E1C, 0xFFF5AD1C, 0xFFFCD21C, 0xFFFFE922, 0xFFFEE622, 0xFFFFEB32, 0xFFFFEB32, 0xFFFFE922, 0xFFFFEB32, 0xFFFFEB32, 0xFFFCE422, 0xFFFCE01C, 0xFFFCD21C, 0xFFFACC1C, 0xFFFBCB1C, 0xFFF8C11C, 
        0xFFF5AD1C, 0xFFF5AD1C, 0xFFE6841C, 0xFFC87E1C, 0xFFA37622, 0xFE503227, 0xC8351500, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA5000000, 0xA4000000, 
        0xA0000000, 0x9D000000, 0x98000000, 0x93000000, 0x8C000000, 0x86000000, 0x82000000, 0x7E150000, 0x7C000000, 0x77000000, 0x77000000, 0x74151500, 0x74151500, 0x74151500, 0x74151500, 0x71000000, 0x71000000, 0x6F150000, 0x6F150000, 0x6F150000, 
        0x6B151500, 0x6B151500, 0x6A150000, 0x65150000, 0x65150000, 0x61150000, 0x5D150000, 0x5B150000, 0x58150000, 0x54000000, 0x50150000, 0x4C150000, 0x48000000, 0x44000000, 0x3F000000, 0x3B000000, 0x34000000, 0x2F000000, 0x2A000000, 0x24000000, 
        0x1D000000, 0x18000000, 0x13000000, 0x0E000000, 0x0A000000, 0x07000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x74404022, 0x74404022, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0xFF35001C, 0xFF66001C, 0xFFE6841C, 0xFFF8C11C, 0xFFFCE01C, 0xFFFFEB32, 0xFFFFE922, 0xFFFCED40, 0xFFFFEB32, 0xFFFFEB32, 0xFFFFEB32, 0xFFFCED40, 0xFFFCE422, 0xFFFBE01C, 0xFFF8C11C, 0xFFF8C11C, 0xFFF8C11C, 0xFFF5AD1C, 
        0xFFE6841C, 0xFFE6841C, 0xFFC87E1C, 0xFF992B22, 0xFF5A3D22, 0xC8351500, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA4000000, 
        0xA2000000, 0x9D000000, 0x9A000000, 0x96000000, 0x91000000, 0x8B150000, 0x86000000, 0x85150000, 0x82000000, 0x80151500, 0x80151500, 0x7F000000, 0x7E150000, 0x7E150000, 0x7E150000, 0x7E150000, 0x7E150000, 0x7E150000, 0x7C000000, 0x7C000000, 
        0x7A000000, 0x77150000, 0x77150000, 0x74151500, 0x71000000, 0x6F150000, 0x6E000000, 0x6A150000, 0x65150000, 0x63000000, 0x5E000000, 0x5B150000, 0x58150000, 0x51000000, 0x4C150000, 0x48000000, 0x42000000, 0x3C000000, 0x36000000, 0x2F000000, 
        0x27000000, 0x21000000, 0x1A000000, 0x14000000, 0x0E000000, 0x0A000000, 0x06000000, 0x03000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0xFF87994C, 0xFF97C335, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0xC8351500, 0xFF46001C, 0xFFC87E1C, 0xFFF5AD1C, 0xFFF8C11C, 0xFFFCE422, 0xFFFEE122, 0xFFFFEB32, 0xFFFCED40, 0xFFFFEB32, 0xFFFFEB32, 0xFFFCED40, 0xFFFCED40, 0xFFFCD21C, 0xFFFCD21C, 0xFFFBCB1C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFF5AD1C, 
        0xFFE6841C, 0xFFC87E1C, 0xFFC87E1C, 0xFF992B22, 0xFF5A3D22, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA4000000, 
        0xA2000000, 0xA0000000, 0x9C000000, 0x99000000, 0x95000000, 0x91000000, 0x8F000000, 0x8C000000, 0x8B150000, 0x8A000000, 0x8A000000, 0x8A000000, 0x8A000000, 0x86000000, 0x86000000, 0x86000000, 0x86000000, 0x85150000, 0x85150000, 0x85150000, 
        0x82000000, 0x80151500, 0x7E150000, 0x7E150000, 0x7C000000, 0x7A000000, 0x77150000, 0x74151500, 0x6F150000, 0x6E000000, 0x6A150000, 0x65150000, 0x61150000, 0x5D150000, 0x58150000, 0x51000000, 0x4C150000, 0x46000000, 0x3F000000, 0x39000000, 
        0x31000000, 0x2A000000, 0x22000000, 0x1A000000, 0x13000000, 0x0D000000, 0x09000000, 0x05000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0xFF7F7B42, 0xFFACC32E, 0xF1849C4C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0xEA3D1515, 0xFF7A382B, 0xFFE6841C, 0xFFF5AD1C, 0xFFFCD21C, 0xFFFEE622, 0xFFFFEB32, 0xFFFEE622, 0xFFFFE922, 0xFFFCED40, 0xFFFCED40, 0xFFFFEB32, 0xFFFFE922, 0xFFFCE422, 0xFFFCE01C, 0xFFFCD21C, 0xFFFBCB1C, 0xFFFBCB1C, 0xFFF5AD1C, 
        0xFFE6841C, 0xFFE6841C, 0xFFC87E1C, 0xFFA37622, 0xFE503227, 0xA7000000, 0xA7000000, 0xA7000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 
        0xA3000000, 0xA0000000, 0x9D000000, 0x9A000000, 0x98000000, 0x96000000, 0x93000000, 0x93000000, 0x91000000, 0x8F000000, 0x8F000000, 0x8F000000, 0x8F150000, 0x8C000000, 0x8C000000, 0x8B150000, 0x8B150000, 0x8A000000, 0x86000000, 0x86000000, 
        0x85150000, 0x82000000, 0x80151500, 0x7E150000, 0x7E150000, 0x7C000000, 0x77150000, 0x77150000, 0x74151500, 0x6F150000, 0x6B151500, 0x6A150000, 0x65150000, 0x61150000, 0x5D150000, 0x58150000, 0x51000000, 0x4C150000, 0x46000000, 0x3F000000, 
        0x37000000, 0x31000000, 0x27000000, 0x1F000000, 0x17000000, 0x10000000, 0x0B000000, 0x06000000, 0x03000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0xD65C672E, 0xFF98B427, 0xFFBAE42E, 0xD2787244, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x6F150000, 0xFF420022, 0xFFC87E1C, 0xFFF5AD1C, 0xFFFBCB1C, 0xFFFEE122, 0xFFFFEB32, 0xFFFFE922, 0xFFFFEB32, 0xFFFFEB32, 0xFFFCED40, 0xFFFFEB32, 0xFFFFEB32, 0xFFFFEB32, 0xFFFFEB32, 0xFFFCE01C, 0xFFFCE422, 0xFFFCE01C, 0xFFFBCB1C, 0xFFF5AD1C, 
        0xFFF5AD1C, 0xFFE6841C, 0xFFE6841C, 0xFFA37622, 0xFF4C1527, 0xFD461C22, 0xEA3D1515, 0xA8000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA4000000, 
        0xA2000000, 0xA0000000, 0x9D000000, 0x9C000000, 0x9A000000, 0x96000000, 0x96000000, 0x93000000, 0x93000000, 0x93000000, 0x8F000000, 0x8F000000, 0x8F150000, 0x8C000000, 0x8B150000, 0x8B150000, 0x86000000, 0x85150000, 0x85150000, 0x82000000, 
        0x80151500, 0x7E150000, 0x7C000000, 0x7A000000, 0x77150000, 0x74151500, 0x74151500, 0x71000000, 0x6F150000, 0x6B151500, 0x67000000, 0x65150000, 0x61150000, 0x5D150000, 0x58150000, 0x54150000, 0x50150000, 0x4C150000, 0x46000000, 0x42000000, 
        0x3B000000, 0x33000000, 0x2A000000, 0x22000000, 0x1A000000, 0x13000000, 0x0C000000, 0x08000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x74404022, 0xFF98B427, 0xFFACC32E, 0xFEA8C346, 0xD65C672E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0xEA3D1515, 0xFF7A382B, 0xFFF5AD1C, 0xFFFBCB1C, 0xFFFBCB1C, 0xFFFCE422, 0xFFFEE622, 0xFFFFE922, 0xFFFFEB32, 0xFFFFEB32, 0xFFFCED40, 0xFFFCED40, 0xFFFFEB32, 0xFFFFEB32, 0xFFFCED40, 0xFFFCE422, 0xFFFBE01C, 0xFFFCD21C, 0xFFFBCB1C, 0xFFF8C11C, 
        0xFFF5AD1C, 0xFFF5AD1C, 0xFFE6841C, 0xFFC87E1C, 0xFF663D22, 0xFF420022, 0xFF4C1527, 0xFD461C22, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA4000000, 0xA2000000, 
        0xA0000000, 0x9D000000, 0x9C000000, 0x9A000000, 0x98000000, 0x95000000, 0x93000000, 0x93000000, 0x8F000000, 0x8F000000, 0x8C000000, 0x8A000000, 0x86000000, 0x85150000, 0x85150000, 0x82000000, 0x7E150000, 0x7E150000, 0x7A000000, 0x77150000, 
        0x74151500, 0x71000000, 0x6F150000, 0x6E000000, 0x6B151500, 0x6A150000, 0x67000000, 0x65150000, 0x63000000, 0x61150000, 0x5D150000, 0x5B150000, 0x58150000, 0x54000000, 0x50150000, 0x4E000000, 0x4A000000, 0x46000000, 0x42000000, 0x3C000000, 
        0x37000000, 0x31000000, 0x2A000000, 0x22000000, 0x1A000000, 0x13000000, 0x0D000000, 0x08000000, 0x05000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0xFF829544, 0xFF97C335, 0xFFB9C32E, 0xFF84AE4C, 0xD2787244, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0xFF3B001C, 0xFFC87E1C, 0xFFF8C11C, 0xFFFBCB1C, 0xFFFCD21C, 0xFFFEE122, 0xFFFCE422, 0xFFFEE122, 0xFFFFEB32, 0xFFFCED40, 0xFFFCED40, 0xFFFCED40, 0xFFFCED40, 0xFFFFEB32, 0xFFFCED40, 0xFFFEE622, 0xFFFCE01C, 0xFFFCE01C, 0xFFFBCB1C, 0xFFF8C11C, 
        0xFFF5AD1C, 0xFFF5AD1C, 0xFFF5AD1C, 0xFFE6841C, 0xFF7A382B, 0xFF420022, 0xFF420022, 0xFF48002B, 0xFD461C22, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA4000000, 0xA3000000, 0xA0000000, 0x9D000000, 
        0x9C000000, 0x99000000, 0x96000000, 0x93000000, 0x91000000, 0x8F000000, 0x8C000000, 0x8A000000, 0x86000000, 0x85150000, 0x82000000, 0x7F000000, 0x7C000000, 0x7A000000, 0x77000000, 0x74000000, 0x71000000, 0x6E000000, 0x6A150000, 0x67000000, 
        0x65150000, 0x61150000, 0x5E000000, 0x5D150000, 0x5B150000, 0x58150000, 0x58150000, 0x54000000, 0x51000000, 0x50150000, 0x4E000000, 0x4A000000, 0x48000000, 0x44000000, 0x44000000, 0x3F000000, 0x3E000000, 0x3B000000, 0x39000000, 0x34000000, 
        0x31000000, 0x2C000000, 0x26000000, 0x1F000000, 0x19000000, 0x12000000, 0x0C000000, 0x08000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xD2787244, 
        0xFFADE12E, 0xFF97C335, 0xFFC8E42E, 0xFF84AE4C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 
        0xFF4C1527, 0xFFE6841C, 0xFFF8C11C, 0xFFFACC1C, 0xFFFACC1C, 0xFFFEE122, 0xFFFCE01C, 0xFFFFEB32, 0xFFFFEB32, 0xFFFFEB32, 0xFFFCED40, 0xFFFFEB32, 0xFFFCED40, 0xFFFFEB32, 0xFFFFEB32, 0xFFFFEB32, 0xFFFCE422, 0xFFFCD21C, 0xFFFCE01C, 0xFFFCD21C, 
        0xFFF8C11C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFE6841C, 0xFFA37622, 0xFF420022, 0xFF400022, 0xFF46001C, 0xFF4C1527, 0xFE503227, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA4000000, 0xA0000000, 0x9F000000, 0x9C000000, 0x98000000, 
        0x95000000, 0x91000000, 0x8C000000, 0x8A000000, 0x86000000, 0x85150000, 0x82000000, 0x7E150000, 0x7C000000, 0x77000000, 0x74000000, 0x71000000, 0x6E000000, 0x6A000000, 0x65150000, 0x61150000, 0x5D150000, 0x5B150000, 0x58150000, 0x54000000, 
        0x51000000, 0x4E000000, 0x4C150000, 0x49000000, 0x46000000, 0x44000000, 0x44000000, 0x42000000, 0x3F000000, 0x3E000000, 0x3C000000, 0x39000000, 0x37000000, 0x34000000, 0x33000000, 0x31000000, 0x31000000, 0x2F000000, 0x2C000000, 0x2A000000, 
        0x27000000, 0x24000000, 0x20000000, 0x1B000000, 0x15000000, 0x10000000, 0x0B000000, 0x07000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF8FA435, 0xFF6F7822, 0x74404022, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xD65C672E, 0xFF98B427, 
        0xFF9AD646, 0xFFB9C32E, 0xFFC8E42E, 0xFF74A422, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x01000000, 0x02000000, 0x02000000, 0x02000000, 0x02000000, 0x01000000, 0x01000000, 
        0xFF992B22, 0xFFF5AD1C, 0xFFFCD21C, 0xFFFCE01C, 0xFFFEE122, 0xFFFEE122, 0xFFFFEB32, 0xFFFCE01C, 0xFFFFEB32, 0xFFFEE122, 0xFFFCED40, 0xFFFCED40, 0xFFFFEB32, 0xFFFFEB32, 0xFFFEE622, 0xFFFFEB32, 0xFFFEE622, 0xFFFEE622, 0xFFFAE632, 0xFFFCE01C, 
        0xFFF8C11C, 0xFFF8C11C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFC87E1C, 0xFF55322E, 0xFF400022, 0xFF3D0022, 0xFF3D0027, 0xFF48002B, 0xFF55322E, 0xA7000000, 0xA6000000, 0xA5000000, 0xA3000000, 0xA0000000, 0x9D000000, 0x99000000, 0x95000000, 0x8F000000, 
        0x8A000000, 0x85150000, 0x7F000000, 0x7C000000, 0x77000000, 0x74000000, 0x71000000, 0x6E000000, 0x6A000000, 0x65150000, 0x63000000, 0x5E000000, 0x58000000, 0x54000000, 0x51000000, 0x4E000000, 0x4A000000, 0x46000000, 0x44000000, 0x3F000000, 
        0x3C000000, 0x3B000000, 0x37000000, 0x36000000, 0x34000000, 0x32000000, 0x31000000, 0x31000000, 0x2F000000, 0x2C000000, 0x2C000000, 0x29000000, 0x27000000, 0x25000000, 0x24000000, 0x23000000, 0x22000000, 0x21000000, 0x20000000, 0x1F000000, 
        0x1D000000, 0x1B000000, 0x18000000, 0x14000000, 0x10000000, 0x0C000000, 0x09000000, 0x05000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFB9C32E, 0xFFACC32E, 0xFF7E9A22, 0xFF626B27, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x74404022, 0xFF8FA435, 0xFFBAE42E, 
        0xFF97C335, 0xFFD4E62E, 0xFFADE12E, 0xD65C672E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x03000000, 0x03000000, 0x04000000, 0x04000000, 0x04000000, 0x04000000, 0x03000000, 0x02000000, 
        0xFFC87E1C, 0xFFFACC1C, 0xFFFCE01C, 0xFFF8C11C, 0xFFFCE01C, 0xFFFFEB32, 0xFFFEE122, 0xFFFEE622, 0xFFFEE122, 0xFFFFEB32, 0xFFFFEB32, 0xFFFCED40, 0xFFFFEB32, 0xFFFCED40, 0xFFFFEB32, 0xFFFFE922, 0xFFFFE922, 0xFFFBE01C, 0xFFFCE01C, 0xFFFCE01C, 
        0xFFFACC1C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFF5AD1C, 0xFFE6841C, 0xFF83573D, 0xFF400022, 0xFF400022, 0xFF400022, 0xFF420022, 0xFF48002B, 0xFD461C22, 0xA6000000, 0xA4000000, 0xA0000000, 0x9D000000, 0x98000000, 0x93000000, 0x8B150000, 0x85150000, 
        0x7C000000, 0x77000000, 0x71000000, 0x6A000000, 0x67000000, 0x61150000, 0x5D150000, 0x58000000, 0x54000000, 0x51000000, 0x4E000000, 0x49000000, 0x44000000, 0x42000000, 0x3C000000, 0x3B000000, 0x36000000, 0x33000000, 0x31000000, 0x2C000000, 
        0x2C000000, 0x27000000, 0x26000000, 0x24000000, 0x23000000, 0x22000000, 0x21000000, 0x20000000, 0x1D000000, 0x1D000000, 0x1C000000, 0x1B000000, 0x19000000, 0x18000000, 0x17000000, 0x16000000, 0x16000000, 0x16000000, 0x15000000, 0x15000000, 
        0x14000000, 0x13000000, 0x11000000, 0x0E000000, 0x0C000000, 0x09000000, 0x06000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFB9C32E, 0xFFC8E42E, 0xFFBAE42E, 0xFFACC32E, 0xFF7E9A22, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xF1849C4C, 0xFFBAE42E, 0xFF9AD646, 
        0xFFB9C32E, 0xFFDCEA32, 0xFF97C335, 0x74404022, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x02000000, 0x04000000, 0x05000000, 0x07000000, 0x08000000, 0x08000000, 0x08000000, 0x06000000, 0x05000000, 0x04000000, 
        0xFFC87E1C, 0xFFFEE122, 0xFFF8C11C, 0xFFFCD21C, 0xFFFEE122, 0xFFFEE122, 0xFFFEE122, 0xFFFEE622, 0xFFFFEB32, 0xFFFFEB32, 0xFFFEE622, 0xFFFCED40, 0xFFFFEB32, 0xFFFFEB32, 0xFFFEE122, 0xFFFEE622, 0xFFFFE922, 0xFFFBE01C, 0xFFFCD21C, 0xFFFBE01C, 
        0xFFFACC1C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFA37622, 0xFF46001C, 0xFF3D0022, 0xFF400022, 0xFF420022, 0xFF48002B, 0xFF48002B, 0xFD461C22, 0xA2000000, 0x9D000000, 0x99000000, 0x93000000, 0x8A000000, 0x82000000, 0x77000000, 
        0x6E000000, 0x67000000, 0x5E000000, 0x58000000, 0x51000000, 0x4E000000, 0x49000000, 0x44000000, 0x42000000, 0x3C000000, 0x39000000, 0x34000000, 0x32000000, 0x2F000000, 0x2C000000, 0x27000000, 0x25000000, 0x22000000, 0x20000000, 0x1D000000, 
        0x1C000000, 0x1A000000, 0x18000000, 0x17000000, 0x16000000, 0x15000000, 0x14000000, 0x13000000, 0x12000000, 0x11000000, 0x11000000, 0x10000000, 0x0F000000, 0x0E000000, 0x0D000000, 0x0D000000, 0x0D000000, 0x0D000000, 0x0D000000, 0x0C000000, 
        0x0C000000, 0x0C000000, 0x0B000000, 0x09000000, 0x08000000, 0x06000000, 0x04000000, 0x03000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFADE12E, 0xFFBAE42E, 0xFFC8E42E, 0xFFC8E42E, 0xFFADE12E, 0xFF627D27, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xD2787244, 0xFFACC32E, 0xFFBAE42E, 0xFF97B446, 
        0xFFD4E62E, 0xFFDCEA32, 0xFF87BA3B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x05000000, 0x07000000, 0x09000000, 0x0B000000, 0x0D000000, 0x0D000000, 0x0C000000, 0x0B000000, 0x08000000, 0x6F150000, 
        0xFFC87E1C, 0xFFFCE01C, 0xFFFBCB1C, 0xFFFACC1C, 0xFFFCE01C, 0xFFFEE122, 0xFFFFE922, 0xFFFEE122, 0xFFFFE922, 0xFFFCE422, 0xFFFEE622, 0xFFFFEB32, 0xFFFEE622, 0xFFFCED40, 0xFFFCE422, 0xFFFFEB32, 0xFFFEE622, 0xFFFBE01C, 0xFFFCD21C, 0xFFFBE01C, 
        0xFFFCD21C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFC87E1C, 0xFF604022, 0xFF400022, 0xFF420022, 0xFF3D0022, 0xFF3D0027, 0xFF400022, 0xFF48002B, 0xFF4C1527, 0x9A000000, 0x95000000, 0x8C000000, 0x82000000, 0x77000000, 0x6A000000, 
        0x5E000000, 0x54000000, 0x4C150000, 0x44000000, 0x3F000000, 0x3B000000, 0x34000000, 0x32000000, 0x2F000000, 0x2C000000, 0x27000000, 0x24000000, 0x21000000, 0x1F000000, 0x1C000000, 0x1A000000, 0x17000000, 0x15000000, 0x14000000, 0x12000000, 
        0x10000000, 0x0F000000, 0x0E000000, 0x0D000000, 0x0C000000, 0x0C000000, 0x0B000000, 0x0A000000, 0x0A000000, 0x09000000, 0x09000000, 0x08000000, 0x08000000, 0x07000000, 0x07000000, 0x07000000, 0x06000000, 0x06000000, 0x07000000, 0x07000000, 
        0x07000000, 0x06000000, 0x06000000, 0x05000000, 0x04000000, 0x03000000, 0x02000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFB3E442, 0xFFADE12E, 0xFFBAE42E, 0xFFBAE42E, 0xFFC8E42E, 0xFF97C335, 0x74404022, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xFF7F7B42, 0xFFBAE42E, 0xFF9AD646, 0xFFACC32E, 
        0xFFD4E62E, 0xFFD4E62E, 0xD2787244, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x05000000, 0x08000000, 0x0B000000, 0x0F000000, 0x12000000, 0x14000000, 0x14000000, 0x13000000, 0x10000000, 0x0C000000, 0xEA3D1515, 
        0xFFD8BE46, 0xFFFEE122, 0xFFFBCB1C, 0xFFFCD21C, 0xFFFEE622, 0xFFFEE622, 0xFFFFEB32, 0xFFFEE622, 0xFFFEE622, 0xFFFEE622, 0xFFFEE622, 0xFFFFEB32, 0xFFFCE422, 0xFFFFEB32, 0xFFFCE01C, 0xFFFFEB32, 0xFFFCE422, 0xFFFBE01C, 0xFFFCE01C, 0xFFFBE01C, 
        0xFFF8C11C, 0xFFF8C11C, 0xFFF8C11C, 0xFFFACC1C, 0xFFF5AD1C, 0xFFE6841C, 0xFF8D2E22, 0xFF400022, 0xFF420022, 0xFF3D0022, 0xFF420022, 0xFF3D0022, 0xFF420022, 0xFF4C1527, 0xFF5F3B38, 0x91000000, 0x86000000, 0x7A000000, 0x6B151500, 0x5E000000, 
        0x51000000, 0x46000000, 0x3C000000, 0x34000000, 0x2F000000, 0x29000000, 0x25000000, 0x21000000, 0x1F000000, 0x1C000000, 0x19000000, 0x17000000, 0x15000000, 0x13000000, 0x11000000, 0x0F000000, 0x0D000000, 0x0C000000, 0x0B000000, 0x0A000000, 
        0x09000000, 0x08000000, 0x07000000, 0x07000000, 0x06000000, 0x06000000, 0x05000000, 0x05000000, 0x05000000, 0x04000000, 0x04000000, 0x04000000, 0x03000000, 0x03000000, 0x03000000, 0x03000000, 0x03000000, 0x03000000, 0x03000000, 0x03000000, 
        0x03000000, 0x03000000, 0x03000000, 0x03000000, 0x02000000, 0x02000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFADE12E, 0xFFB3E442, 0xFF9AD646, 0xFFBAE42E, 0xFFD4E62E, 0xFFC8E42E, 0xFF74A422, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xD65C672E, 0xFFA3B12E, 0xFFBAE42E, 0xFF97B446, 0xFFC8E42E, 
        0xFFDAEB42, 0xFFC9EA4C, 0xD2787244, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x05000000, 0x08000000, 0x0C000000, 0x11000000, 0x16000000, 0x1A000000, 0x1C000000, 0x1C000000, 0x1A000000, 0x16000000, 0x77150000, 0xFF3D001C, 
        0xFFC87E1C, 0xFFFEE622, 0xFFFCE01C, 0xFFFCD21C, 0xFFFEE622, 0xFFFEE622, 0xFFFFEB32, 0xFFFEE622, 0xFFFEE622, 0xFFFFE922, 0xFFFEE622, 0xFFFFEB32, 0xFFFFE922, 0xFFFEE622, 0xFFFCE422, 0xFFFFE922, 0xFFFCE422, 0xFFFCE01C, 0xFFFCE01C, 0xFFFCE01C, 
        0xFFFACC1C, 0xFFFACC1C, 0xFFF8C11C, 0xFFFCD21C, 0xFFF5AD1C, 0xFFE6841C, 0xFFC87E1C, 0xFF46001C, 0xFF420022, 0xFF3D001C, 0xFF420022, 0xFF420022, 0xFF38001C, 0xFF4C1527, 0xFF48002B, 0xFF55322E, 0x82000000, 0x74000000, 0x65150000, 0x54000000, 
        0x46000000, 0x3B000000, 0x31000000, 0x27000000, 0x21000000, 0x1C000000, 0x18000000, 0x15000000, 0x13000000, 0x11000000, 0x0F000000, 0x0D000000, 0x0C000000, 0x0A000000, 0x09000000, 0x08000000, 0x07000000, 0x06000000, 0x05000000, 0x05000000, 
        0x04000000, 0x04000000, 0x03000000, 0x03000000, 0x02000000, 0x02000000, 0x02000000, 0x02000000, 0x02000000, 0x02000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 
        0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF98B427, 0xFFADE12E, 0xFFADE12E, 0xFF97D227, 0xFFBAE42E, 0xFFD4E62E, 0xFFADE12E, 0xD2787244, 0x00000000, 0x01000000, 0x01000000, 0x02000000, 0xFF727E3B, 0xFFACC32E, 0xFFACC32E, 0xFFA3B12E, 0xFFDCEA32, 
        0xFFDCEA32, 0xFFADE12E, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x04000000, 0x08000000, 0x0C000000, 0x12000000, 0x19000000, 0x1F000000, 0x24000000, 0x26000000, 0x26000000, 0x22000000, 0x1D000000, 0xC8351500, 0xFF38001C, 
        0xFFD8BE46, 0xFFFFE922, 0xFFF8C11C, 0xFFFCD21C, 0xFFFEE622, 0xFFFEE122, 0xFFFFEB32, 0xFFFFEB32, 0xFFFEE622, 0xFFFFEB32, 0xFFFFEB32, 0xFFFFE922, 0xFFFCE01C, 0xFFFFE922, 0xFFFFE922, 0xFFFEE622, 0xFFFFE922, 0xFFFFE922, 0xFFFCE01C, 0xFFFCD21C, 
        0xFFFCD21C, 0xFFFCD21C, 0xFFFCD21C, 0xFFFCD21C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFC87E1C, 0xFF5A001C, 0xFF420022, 0xFF400022, 0xFF420022, 0xFF400022, 0xFF3D0022, 0xFF48002B, 0xFF400022, 0xFF4C1527, 0xC8351500, 0x71000000, 0x63000000, 0x51000000, 
        0x42000000, 0x34000000, 0x29000000, 0x20000000, 0x19000000, 0x13000000, 0x10000000, 0x0D000000, 0x0B000000, 0x09000000, 0x08000000, 0x07000000, 0x06000000, 0x05000000, 0x04000000, 0x04000000, 0x03000000, 0x02000000, 0x02000000, 0x02000000, 
        0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFB554627, 0xFFACC32E, 0xFFADE12E, 0xFFB3E442, 0xFF97C335, 0xFFC8E42E, 0xFFBAE42E, 0xFF87BA3B, 0x01000000, 0x02000000, 0x03000000, 0x04000000, 0xFF8FA435, 0xFFB9C32E, 0xFF98B427, 0xFFB9C32E, 0xFFDCEA32, 
        0xFFDCEA32, 0xFF83BC22, 0x01000000, 0x01000000, 0x01000000, 0x02000000, 0x04000000, 0x07000000, 0x0C000000, 0x12000000, 0x1A000000, 0x22000000, 0x29000000, 0x2F000000, 0x31000000, 0x2F000000, 0x2A000000, 0x23000000, 0xC8351500, 0xFF3B001C, 
        0xFFC87E1C, 0xFFFEE122, 0xFFF8C11C, 0xFFF8C11C, 0xFFFCD21C, 0xFFFBCB1C, 0xFFFFE922, 0xFFFCE422, 0xFFFEE622, 0xFFFFEB32, 0xFFFFEB32, 0xFFFCE422, 0xFFFCE422, 0xFFFEE122, 0xFFFEE622, 0xFFFCD21C, 0xFFFBE01C, 0xFFFCE422, 0xFFFCD21C, 0xFFFCE01C, 
        0xFFFACC1C, 0xFFFBE01C, 0xFFFCE01C, 0xFFFCD21C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFE6841C, 0xFF7A382B, 0xFF46001C, 0xFF3D0027, 0xFF420022, 0xFF400022, 0xFF420022, 0xFF48002B, 0xFF420022, 0xFF48002B, 0xFF5F3B38, 0x74000000, 0x63000000, 0x54000000, 
        0x44000000, 0x34000000, 0x27000000, 0x1D000000, 0x15000000, 0x0F000000, 0x0B000000, 0x08000000, 0x06000000, 0x05000000, 0x04000000, 0x03000000, 0x02000000, 0x02000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0xFF7D7522, 0xFFADE12E, 0xFFADE12E, 0xFFADE12E, 0xFFACC32E, 0xFFC8E42E, 0xFFADE12E, 0xD2787244, 0x04000000, 0x05000000, 0xCB4A3822, 0xFFA3B12E, 0xFEA8C346, 0xFF8FA435, 0xFFD4E62E, 0xFFD4E62E, 
        0xFFC8E42E, 0x74404022, 0x03000000, 0x02000000, 0x02000000, 0x03000000, 0x74404022, 0xD65C672E, 0xFF727E3B, 0xFF727E3B, 0xFF829544, 0xFF7E9A22, 0xFF7E9A22, 0xFF829544, 0xFF829544, 0xFF727E3B, 0xFF727E3B, 0xD65C672E, 0xFF4C3822, 0xFF2E0015, 
        0xFFC87E1C, 0xFFFCD21C, 0xFFFCD21C, 0xFFF8C11C, 0xFFF8C11C, 0xFFFEE122, 0xFFFCE422, 0xFFFEE622, 0xFFFFEB32, 0xFFFFEB32, 0xFFFFE922, 0xFFFEE622, 0xFFFCE422, 0xFFFEE622, 0xFFFFEB32, 0xFFFCE01C, 0xFFFCD21C, 0xFFFEE622, 0xFFFCD21C, 0xFFFCE01C, 
        0xFFFACC1C, 0xFFFCE01C, 0xFFFCE01C, 0xFFFACC1C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFE6841C, 0xFF902E27, 0xFF4C1527, 0xFF420022, 0xFF420022, 0xFF38001C, 0xFF420022, 0xFF48002B, 0xFF420022, 0xFF48002B, 0xFF48002B, 0xE4553B2B, 0x6A000000, 0x58000000, 
        0x48000000, 0x39000000, 0x2C000000, 0x20000000, 0x17000000, 0x10000000, 0x0B000000, 0x07000000, 0x04000000, 0x03000000, 0x02000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x74404022, 0xFFA3B12E, 0xFFADE12E, 0xFFBAE42E, 0xFF97D227, 0xFFACC32E, 0xFFB9C32E, 0xFF8FA435, 0x06000000, 0x09000000, 0xCB4A3822, 0xFFA3B12E, 0xFF98B427, 0xFFA3B12E, 0xFFD4E62E, 0xFFD4E62E, 
        0xFF97D227, 0x08000000, 0x06000000, 0x74404022, 0xFF606722, 0xFF829544, 0xFF8FA435, 0xFF98B427, 0xFFA3B12E, 0xFFA3B12E, 0xFFACC32E, 0xFFACC32E, 0xFFA3B12E, 0xFFA3B12E, 0xFF8FA435, 0xFF8FA435, 0xFFA3B12E, 0xFF8FA435, 0xFF4C3822, 0xFF2E0015, 
        0xFFA37622, 0xFFFCD21C, 0xFFFCE01C, 0xFFF5AD1C, 0xFFF5AD1C, 0xFFFEE122, 0xFFFCD21C, 0xFFFEE122, 0xFFFFE922, 0xFFFEE622, 0xFFFEE622, 0xFFFEE122, 0xFFFEE622, 0xFFFEE622, 0xFFFCE422, 0xFFFCE01C, 0xFFFBE01C, 0xFFFCE422, 0xFFFCD21C, 0xFFFCE01C, 
        0xFFFCE01C, 0xFFFCD21C, 0xFFFCE422, 0xFFFCD21C, 0xFFFACC1C, 0xFFF8C11C, 0xFFF5AD1C, 0xFF992B22, 0xFF66001C, 0xFF3D0022, 0xFF400022, 0xFF400022, 0xFF420022, 0xFF3D0022, 0xFF3D0022, 0xFF420022, 0xFF48002B, 0xFF4C1527, 0x71000000, 0x63000000, 
        0x51000000, 0x44000000, 0x34000000, 0x27000000, 0x1D000000, 0x14000000, 0x0D000000, 0x08000000, 0x05000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0xFF7D7522, 0xFFADE12E, 0xFFBAE42E, 0xFFADE12E, 0xFF97C335, 0xFFACC32E, 0xFFACC32E, 0x74404022, 0x0E000000, 0xD65C672E, 0xFF98B427, 0xFF85A42B, 0xFFB9C32E, 0xFFD4E62E, 0xFFC8E42E, 
        0xD2787244, 0x74404022, 0xD2787244, 0xFF829544, 0xFFA3B12E, 0xFFB9C32E, 0xFFB9C32E, 0xFFA3B12E, 0xFF8FA435, 0xFFA3B12E, 0xFFA3B12E, 0xFFA3B12E, 0xFFA3B12E, 0xFFACC32E, 0xFFACC32E, 0xFFACC32E, 0xFFACC32E, 0xFEA8C346, 0xFE4C3D22, 0xFF2E0015, 
        0xFF8D2E22, 0xFFFCE422, 0xFFFCD21C, 0xFFF5AD1C, 0xFFF8C11C, 0xFFFBCB1C, 0xFFFCD21C, 0xFFFCE01C, 0xFFFFE922, 0xFFFEE622, 0xFFFEE622, 0xFFFEE122, 0xFFFEE122, 0xFFFCE422, 0xFFFCE01C, 0xFFFCE01C, 0xFFFEE622, 0xFFFBE01C, 0xFFFCE01C, 0xFFFCD21C, 
        0xFFFBE01C, 0xFFFCE01C, 0xFFFBE01C, 0xFFFCD21C, 0xFFFCD21C, 0xFFFACC1C, 0xFFF0C52B, 0xFFA37622, 0xFE8D1C22, 0xFF46001C, 0xFF3D0027, 0xFF400022, 0xFF400022, 0xFF420022, 0xFF420022, 0xFF400022, 0xFF48002B, 0xFF48002B, 0xE4553B2B, 0x6E000000, 
        0x5E000000, 0x4E000000, 0x3F000000, 0x32000000, 0x26000000, 0x1B000000, 0x12000000, 0x0C000000, 0x07000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xFF8FA435, 0xFFBAE42E, 0xFFBAE42E, 0xFF97D227, 0xFF98B427, 0xFFACC32E, 0xF1849C4C, 0x14000000, 0xD65C672E, 0xFF8FA435, 0xFF7E9A22, 0xFFD4E62E, 0xFFD4E62E, 0xFF98B427, 
        0x1A000000, 0xFF98B427, 0xFFDAEB42, 0xFFB9C32E, 0xFFB9C32E, 0xFFB9C32E, 0xFFC8E42E, 0xFFC8E42E, 0xFFC8E42E, 0xFFD4E62E, 0xFFC8E42E, 0xFFD4E62E, 0xFFD4E62E, 0xFFD4E62E, 0xFFC8E42E, 0xFFD4E62E, 0xFFD4E62E, 0xFFD4E62E, 0xFF626735, 0xFF38001C, 
        0xFF66001C, 0xFFFACC1C, 0xFFFCD21C, 0xFFF5AD1C, 0xFFFBCB1C, 0xFFF8C11C, 0xFFF8C11C, 0xFFFCE01C, 0xFFFCE422, 0xFFFCE01C, 0xFFFCE01C, 0xFFFCE01C, 0xFFFEE122, 0xFFFCE01C, 0xFFFCE422, 0xFFFCE01C, 0xFFFFE922, 0xFFFCE422, 0xFFFBE01C, 0xFFFBE01C, 
        0xFFFBE01C, 0xFFFBE01C, 0xFFFBE01C, 0xFFFBE01C, 0xFFFAE632, 0xFFFBE01C, 0xFFFACC1C, 0xFFA37622, 0xFE8D1C22, 0xFF66001C, 0xFF400022, 0xFF3D0022, 0xFF3D0022, 0xFF48002B, 0xFF48002B, 0xFF4C1527, 0xFF46001C, 0xFF4C1527, 0xFF55322E, 0x7A000000, 
        0x6A000000, 0x5D150000, 0x4E000000, 0x3F000000, 0x31000000, 0x25000000, 0x1B000000, 0x12000000, 0x0C000000, 0x07000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xD2787244, 0xFFACC32E, 0xFFBAE42E, 0xFFBAE42E, 0xFF98B427, 0xFFA3B12E, 0xFF98B427, 0x74404022, 0xD65C672E, 0xFF7E9A22, 0xFF829544, 0xFFDAEB42, 0xFFB9C32E, 0x74404022, 
        0xFF7D7522, 0xFF98B427, 0xFFC8E42E, 0xFFDAEB42, 0xFFDCEA32, 0xFFDCEA32, 0xFFDCEA32, 0xFFDCEA32, 0xFFD4E62E, 0xFFD4E62E, 0xFFD4E62E, 0xFFD4E62E, 0xFFDCEA32, 0xFFD4E62E, 0xFFBAE42E, 0xFFB9C32E, 0xFFA3B12E, 0xFF757522, 0xFF55322E, 0xFF420022, 
        0xFF400015, 0xFFD8BE46, 0xFFFEE122, 0xFFFACC1C, 0xFFF8C11C, 0xFFF8C11C, 0xFFF8C11C, 0xFFFCE01C, 0xFFFCE01C, 0xFFFBCB1C, 0xFFFCD21C, 0xFFFCE422, 0xFFFCE01C, 0xFFFCE01C, 0xFFFEE122, 0xFFFCE01C, 0xFFFFEB32, 0xFFFCE422, 0xFFFEE622, 0xFFFBE01C, 
        0xFFFCE422, 0xFFFCE422, 0xFFFCE422, 0xFFFBE01C, 0xFFFAE632, 0xFFFAE632, 0xFFE6841C, 0xFF992B22, 0xFF992B22, 0xFF7A382B, 0xFF5A001C, 0xFF3D0022, 0xFF3D0022, 0xFF400022, 0xFF420022, 0xFF4C1527, 0xFF420022, 0xFF48002B, 0xFF48002B, 0xE4553B2B, 
        0x7A000000, 0x6A000000, 0x5D150000, 0x4E000000, 0x3F000000, 0x31000000, 0x25000000, 0x1A000000, 0x12000000, 0x0B000000, 0x07000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xFF829544, 0xFFBAE42E, 0xFFBAE42E, 0xFFADE12E, 0xFF8FA435, 0xFFA3B12E, 0xFF626B27, 0xD65C672E, 0xFF829544, 0xFF87994C, 0xFFDAEB42, 0xD2787244, 0x8F150000, 
        0xFF8FA435, 0xFF80B122, 0xFFADE12E, 0xFFFCED40, 0xFFDCEA32, 0xFFDCEA32, 0xFFD4E62E, 0xFFB9C32E, 0xFFA3B12E, 0xFFA3B12E, 0xFF89A422, 0xFF829544, 0xFF727E3B, 0xFF626B27, 0xFE4C3D22, 0xFE482B1C, 0xFF663D22, 0xFF5D542B, 0xFF574027, 0xFF420022, 
        0xFF35001C, 0xFFC87E1C, 0xFFFFEB32, 0xFFFEE122, 0xFFF8C11C, 0xFFF5AD1C, 0xFFF8C11C, 0xFFFCD21C, 0xFFFBCB1C, 0xFFFBCB1C, 0xFFFCD21C, 0xFFFCD21C, 0xFFFCD21C, 0xFFFCD21C, 0xFFFCE422, 0xFFFCD21C, 0xFFFCE01C, 0xFFFEE622, 0xFFFBE01C, 0xFFFBE01C, 
        0xFFFBE01C, 0xFFFCE422, 0xFFFBE01C, 0xFFFEE622, 0xFFFAE632, 0xFFFACC1C, 0xFFA37622, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFF66001C, 0xFF4C1527, 0xFF3D0027, 0xFF48002B, 0xFF420022, 0xFF420022, 0xFF48002B, 0xFF46001C, 0xFF48002B, 0xFF55322E, 
        0x85150000, 0x7A000000, 0x6A000000, 0x5D150000, 0x4E000000, 0x3E000000, 0x31000000, 0x24000000, 0x19000000, 0x11000000, 0x0A000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xCB4A3822, 0xD65C672E, 0xD2787244, 0xD65C672E, 0xFF6F5A22, 0xFF829544, 0xFFACC32E, 0xFFB9C32E, 0xFF98B427, 0xFF8FA435, 0xFF829544, 0xFF5D542B, 0xFF757522, 0xFF8FA435, 0xFEA8C346, 0x4E000000, 0xFF829544, 
        0xFFD4E62E, 0xFF97C335, 0xFF9AD646, 0xFFC8E42E, 0xFFC9EA4C, 0xFF626B27, 0xFF574027, 0xFE482B1C, 0xFE482B1C, 0xFE503227, 0xFF4C3822, 0xFF482222, 0xFF4C3822, 0xFE4C3D22, 0xFF595422, 0xFF5D542B, 0xFF5D542B, 0xFF5A3D22, 0xFE503227, 0xFF48002B, 
        0xFF35001C, 0xFF7A382B, 0xFFFCD21C, 0xFFFFEB32, 0xFFFCD21C, 0xFFF5AD1C, 0xFFF5AD1C, 0xFFF8C11C, 0xFFF8C11C, 0xFFF8C11C, 0xFFFBCB1C, 0xFFFBCB1C, 0xFFFCD21C, 0xFFFCD21C, 0xFFFCD21C, 0xFFFCD21C, 0xFFFCD21C, 0xFFFCE422, 0xFFFCE01C, 0xFFFBE01C, 
        0xFFFAE632, 0xFFFCE422, 0xFFFAE632, 0xFFFFEB32, 0xFFFBE01C, 0xFFC87E1C, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF902E27, 0xFE8D1C22, 0xFF66001C, 0xFF46001C, 0xFF3D0022, 0xFF420022, 0xFF420022, 0xFF48002B, 0xFF420022, 0xFF48002B, 0xFF55322E, 
        0x8F000000, 0x85150000, 0x7A000000, 0x6A000000, 0x5B000000, 0x4E000000, 0x3C000000, 0x2F000000, 0x22000000, 0x18000000, 0x0F000000, 0x09000000, 0x05000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF9AD646, 0xFF9AD646, 0xFF97C335, 0xFF97C335, 0xFF97B446, 0xFF85A42B, 0xFF69862B, 0xFF626B27, 0xFF7D7522, 0xFF829544, 0xFF8FA435, 0xFF626B27, 0xFF757522, 0xFFACC32E, 0xFF69862B, 0xFF8E8140, 0xFFD4E62E, 
        0xFFD4E62E, 0xFF8FA435, 0xFF97D227, 0xFFB3E442, 0xFFDAEB42, 0xFF69862B, 0xFF4C3822, 0xFE503227, 0xFE482B1C, 0xFE503227, 0xFF5F3B38, 0xFF5F3B38, 0xFF574027, 0xFE503227, 0xFE482B1C, 0xFF482222, 0xFF574027, 0xFF574027, 0xFF55322E, 0xFF4C1527, 
        0xFF35001C, 0xFF46001C, 0xFFC87E1C, 0xFFFAE632, 0xFFFFE922, 0xFFF8C11C, 0xFFF5AD1C, 0xFFF8C11C, 0xFFF8C11C, 0xFFF8C11C, 0xFFF8C11C, 0xFFFBCB1C, 0xFFFACC1C, 0xFFFACC1C, 0xFFFCD21C, 0xFFFCD21C, 0xFFFCE01C, 0xFFFCE01C, 0xFFFCE422, 0xFFFAE632, 
        0xFFFCED40, 0xFFFCED40, 0xFFFCED40, 0xFFFAE632, 0xFFC87E1C, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFF7A382B, 0xFF5A001C, 0xFF420022, 0xFF3D0022, 0xFF400022, 0xFF400022, 0xFF420022, 0xFF48002B, 0xFF48002B, 
        0xC8351500, 0x8F000000, 0x85150000, 0x77000000, 0x6A000000, 0x5B000000, 0x4A000000, 0x3B000000, 0x2C000000, 0x20000000, 0x16000000, 0x0E000000, 0x08000000, 0x04000000, 0x74404022, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFC8E42E, 0xFFBAE42E, 0xFFBAE42E, 0xFFC8E42E, 0xFFBAE42E, 0xFFC8E42E, 0xFFC8E42E, 0xFFB3E442, 0xFF87BA3B, 0xFF626B27, 0xFF757522, 0xFF8FA435, 0xFF829544, 0xFFACC32E, 0xFF8E8140, 0xFFC8E42E, 0xFF8FA435, 
        0xFF606722, 0xFF727E3B, 0xFF8CC92B, 0xFFADE12E, 0xFFC8E42E, 0xFFD4ED6D, 0xFF97B446, 0xFF98B427, 0xFF85A42B, 0xFF85A42B, 0xFF85A42B, 0xFF7E9A22, 0xFF7E9A22, 0xFF69862B, 0xFF6F7822, 0xFF5D542B, 0xFF4C3822, 0xFF482222, 0xFF55322E, 0xFE503227, 
        0xFF3D001C, 0xFF350015, 0xFF5A001C, 0xFFC87E1C, 0xFFFCED40, 0xFFFFE922, 0xFFFCD21C, 0xFFF8C11C, 0xFFF8C11C, 0xFFFBCB1C, 0xFFFACC1C, 0xFFFCD21C, 0xFFF8C11C, 0xFFF8C11C, 0xFFFCE01C, 0xFFFCE422, 0xFFFCE422, 0xFFFFE922, 0xFFFFEB32, 0xFFFCED40, 
        0xFFFCED40, 0xFFFCED40, 0xFFF0C52B, 0xFFC87E1C, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF7A382B, 0xFF66001C, 0xFF5A001C, 0xFF3D001C, 0xFF3D001C, 0xFF420022, 0xFF400022, 0xFF400022, 0xFF420022, 
        0xE6502222, 0x96000000, 0x8F000000, 0x85150000, 0x77000000, 0x67000000, 0x58000000, 0x48000000, 0x37000000, 0xD65C672E, 0xD65C672E, 0xCB4A3822, 0x0B000000, 0x74404022, 0xFF89A650, 0xFF5D542B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF97D227, 0xFFACC32E, 0xFFACC32E, 0xFFACC32E, 0xFEA8C346, 0xFF97C335, 0xFFACC32E, 0xFFACC32E, 0xFFACC32E, 0xFFACC32E, 0xFF8FA435, 0xFF8FA435, 0xFFACC32E, 0xFFBAE42E, 0xFFC8E42E, 0xFEA8C346, 0xFF8FA435, 
        0xFF98B427, 0xFF97C335, 0xFF8CC92B, 0xFF9AD646, 0xFFADE12E, 0xFFDAEB42, 0xFFC9EA4C, 0xFFACC32E, 0xFF97C335, 0xFF97C335, 0xFF97C335, 0xFF97C335, 0xFF97C335, 0xFF97C335, 0xFF97C335, 0xFF80B122, 0xFF7E9A22, 0xFF69862B, 0xFF606722, 0xFE503227, 
        0xFF420022, 0xFF2E0015, 0xFF46001C, 0xFF7A382B, 0xFFF5AD1C, 0xFFFAE632, 0xFFFCED40, 0xFFFEE622, 0xFFFCE01C, 0xFFFCD21C, 0xFFFACC1C, 0xFFFACC1C, 0xFFFCD21C, 0xFFFCD21C, 0xFFFAE632, 0xFFFCED40, 0xFFFCED40, 0xFFFCED40, 0xFFFCED40, 0xFFFCED40, 
        0xFFFAE632, 0xFFE6841C, 0xFFC87E1C, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFE8D1C22, 0xFF7A382B, 0xFF66001C, 0xFF420022, 0xFF38001C, 0xFF3D001C, 0xFF3D0022, 0xFF420022, 0xFF3D001C, 
        0xEA3D1515, 0x9C000000, 0x96000000, 0x8C000000, 0x82000000, 0x74000000, 0x65150000, 0x54000000, 0xA6444222, 0xFF89A650, 0xFF89A650, 0xFF69862B, 0xFF626735, 0xFF97B446, 0xFF84AE4C, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFDAEB42, 0xFFDCEA32, 0xFFDCEA32, 0xFFDAEB42, 0xFFDAEB42, 0xFFDAEB42, 0xFFDAEB42, 0xFFD4E62E, 0xFFC8E42E, 0xFFB9C32E, 0xFFB9C32E, 0xFFD4E62E, 0xFFC8E42E, 0xFFD4E62E, 0xFFC8E42E, 0xFFBAE42E, 0xFFBAE42E, 
        0xFFADE12E, 0xFF97D227, 0xFF87BA3B, 0xFF9AD646, 0xFF97D227, 0xFFC8E42E, 0xFFF5F07A, 0xFFDAEB42, 0xFFD4E62E, 0xFFC8E42E, 0xFFC8E42E, 0xFFB9C32E, 0xFFB9C32E, 0xFFACC32E, 0xFFACC32E, 0xFF97C335, 0xFF97C335, 0xFEA8C346, 0xFF98B427, 0xFF80B122, 
        0xFF69862B, 0xFE4A3B1C, 0xFF380015, 0xFF66001C, 0xFF992B22, 0xFFE6841C, 0xFFFACC1C, 0xFFFCED40, 0xFFFCED40, 0xFFFCED40, 0xFFFCE422, 0xFFFEE122, 0xFFFAE632, 0xFFFCED40, 0xFFF0C52B, 0xFFFACC1C, 0xFFFCD21C, 0xFFFCD21C, 0xFFF0C52B, 0xFFF5AD1C, 
        0xFFC87E1C, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFF7A382B, 0xFF66001C, 0xFF4C1527, 0xFF3D0022, 0xFF38001C, 0xFF3D001C, 0xFF4C1527, 0xFF3D001C, 
        0xFF4C1527, 0xA0000000, 0x9C000000, 0x95000000, 0x8C000000, 0x7F000000, 0x71000000, 0x61150000, 0xA6444222, 0x3E000000, 0x74404022, 0xFF97B446, 0xFF829544, 0xFF9AD646, 0xFF84AE4C, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFDCEA32, 0xFFDAEB42, 0xFFDAEB42, 0xFFDCEA32, 0xFFDCEA32, 0xFFDCEA32, 0xFFDCEA32, 0xFFDCEA32, 0xFFDCEA32, 0xFFDCEA32, 0xFFDCEA32, 0xFFC8E42E, 0xFF7E9A22, 0xFFAD8722, 0xFF98B427, 0xFB554627, 0xFF6F5A22, 
        0xFFB9C32E, 0xFFBAE42E, 0xFF83BC22, 0xFF97D227, 0xFF7ECA27, 0xFFADE12E, 0xFFDAEB42, 0xFFF5F07A, 0xFFDCEA32, 0xFFFCED40, 0xFFFCED40, 0xFFDCEA32, 0xFFFCED40, 0xFFFCED40, 0xFFFCED40, 0xFFFCED40, 0xFFFCED40, 0xFFFCED40, 0xFFFCED40, 0xFFDAEB42, 
        0xFFD4E62E, 0xFFB9C32E, 0xFF7E9A22, 0xFF482222, 0xFF7A382B, 0xFF992B22, 0xFFA37622, 0xFFE6841C, 0xFFF5AD1C, 0xFFFAE632, 0xFFFCED40, 0xFFFCED40, 0xFFFAE632, 0xFFD8BE46, 0xFF992B22, 0xFF992B22, 0xFFC87E1C, 0xFFC87E1C, 0xFFA37622, 0xFF992B22, 
        0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFE8D1C22, 0xFE8D1C22, 0xFF7A382B, 0xFF66001C, 0xFF5A001C, 0xFF3D001C, 0xFF3D0022, 0xFF3D001C, 0xFF3D001C, 0xFF420022, 
        0xFF46001C, 0xA3000000, 0xA0000000, 0x9A000000, 0x93000000, 0x8A000000, 0x7C000000, 0x6B151500, 0x5B000000, 0xFF727E3B, 0xFF97B446, 0xFF84AE4C, 0xFF829544, 0xFF84AE4C, 0xFF97B446, 0xFF97B446, 0xFF97B446, 0xD2787244, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xFF8FA435, 0xFFB9C32E, 0xFFC8E42E, 
        0xFFB9C32E, 0xFF98B427, 0xFF727E3B, 0x74404022, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFDCEA32, 0xFFDCEA32, 0xFFDCEA32, 0xFFDAEB42, 0xFFDAEB42, 0xFFDAEB42, 0xFFDAEB42, 0xFFDCEA32, 0xFFDAEB42, 0xFFC9EA4C, 0xFEA8C346, 0xFF6F7822, 0xFF4C3822, 0xFF896D22, 0xFFB9C32E, 0xFF87994C, 0xFF574027, 
        0xFF482222, 0xFF8E8140, 0xFF85A42B, 0xFF7ECA27, 0xFF97D227, 0xFF97C335, 0xFFD4E62E, 0xFFDAEB42, 0xFFF5F07A, 0xFFDCEA32, 0xFFDCEA32, 0xFFDCEA32, 0xFFDCEA32, 0xFFDCEA32, 0xFFDAEB42, 0xFFD4E62E, 0xFFB9C32E, 0xFFB9C32E, 0xFF8FA435, 0xFF7D7522, 
        0xFF757522, 0xFF6F5A22, 0xFF7D7522, 0xFF626735, 0xFF4C1527, 0xFF7A382B, 0xFE8D1C22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFFC87E1C, 0xFFC87E1C, 0xFFA37622, 0xFF902E27, 0xFF7A382B, 0xFF7A382B, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 
        0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFE8D1C22, 0xFF7A382B, 0xFE8D1C22, 0xFF7A382B, 0xFF66001C, 0xFF3D001C, 0xFF400022, 0xFF3D001C, 0xFF3D001C, 0xFF420022, 
        0xFF420022, 0xEA3D1515, 0xA3000000, 0x9F000000, 0xCB4A3822, 0xD2787244, 0xF1849C4C, 0xD2787244, 0xD2787244, 0xFF84AE4C, 0xFF727E3B, 0xFF97B446, 0xFF84AE4C, 0xFF84AE4C, 0xFF89A650, 0xF1849C4C, 0x74404022, 0x74404022, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xFF8FA435, 0xFFB9C32E, 0xFFB9C32E, 0xFFB9C32E, 
        0xFFB9C32E, 0xFFB9C32E, 0xFFA3B12E, 0xF1849C4C, 0x74404022, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF98B427, 0xFFACC32E, 0xFFACC32E, 0xFFACC32E, 0xFFACC32E, 0xFFACC32E, 0xFFC8E42E, 0xFFC9EA4C, 0xFFBAE42E, 0xFFADE12E, 0xFF97B446, 0xFF6F7822, 0xFF4C3822, 0xFF896D22, 0xFFD4E62E, 0xFFACC32E, 0xFF8E8140, 
        0xFF5D542B, 0xFF420022, 0xFF5D542B, 0xFF83BC22, 0xFF7ECA27, 0xFF83BC22, 0xFFACC32E, 0xFFC8E42E, 0xFFF5F07A, 0xFF97B446, 0xFF7D7522, 0xFF6F5A22, 0xFF595422, 0xFF5A3D22, 0xFF6F5A22, 0xFF5D542B, 0xFF574027, 0xFF574027, 0xFF574027, 0xFB554627, 
        0xFF595422, 0xFE4C3D22, 0xFF4C3822, 0xFF3D0022, 0xFF3B001C, 0xFF5A001C, 0xFF7A382B, 0xFE8D1C22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFE8D1C22, 0xFF7A382B, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 
        0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF902E27, 0xFE8D1C22, 0xFE8D1C22, 0xFF7A382B, 0xFF7A382B, 0xFF66001C, 0xFF46001C, 0xFF3D001C, 0xFF3D0015, 0xFF3D001C, 0xFF3D001C, 
        0xFF4C1527, 0xEA3D1515, 0xE4553B2B, 0xFF595422, 0xFF6F7822, 0xFF87994C, 0xFF97B446, 0xFF97B446, 0xFF97B446, 0xFFA3B12E, 0xFF89A650, 0xFF84AE4C, 0xFF6F5A22, 0xFF829544, 0xFF829544, 0xFF97B446, 0xFEA8C346, 0xF1849C4C, 0xD2787244, 0xD2787244, 
        0xD2787244, 0xD2787244, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xFF7F7B42, 0xFF8FA435, 0xFFA3B12E, 0xFFA3B12E, 0xFFA3B12E, 0xFF8FA435, 
        0xFF87994C, 0xFF8FA435, 0xFFAD8722, 0xFFA3B12E, 0xFF8FA435, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF757522, 0xFF6F7822, 0xFF6F7822, 0xFF606722, 0xFF829544, 0xFFC8E42E, 0xFFC9EA4C, 0xFFC9EA4C, 0xFFBAE42E, 0xFFBAE42E, 0xFFC8E42E, 0xFFC9EA4C, 0xFFB9C32E, 0xFF8FA435, 0xFFD4E62E, 0xFFD4E62E, 0xFF98B427, 
        0xFF8E8140, 0xFF595422, 0xFF5D542B, 0xFF80B122, 0xFF7ECA27, 0xFF7ECA27, 0xFF98B427, 0xFFC8E42E, 0xFFDAEB42, 0xFFD4ED6D, 0xFF5D542B, 0xFE482B1C, 0xFF3B151C, 0xFF400015, 0xFF595422, 0xFF606722, 0xFF574027, 0xFF574027, 0xFE503227, 0xFF4C3822, 
        0xFF574027, 0xFF595422, 0xFF574027, 0xFF4C3822, 0xFF3B151C, 0xFF46001C, 0xFF5A001C, 0xFF7A382B, 0xFE8D1C22, 0xFF992B22, 0xFF992B22, 0xFF902E27, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFE8D1C22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 
        0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFE8D1C22, 0xFE8D1C22, 0xFF992B22, 0xFE8D1C22, 0xFF7A382B, 0xFF66001C, 0xFF4C1527, 0xFF38001C, 0xFF3D001C, 0xFF482222, 0xFE503227, 
        0xFF604022, 0xFF655522, 0xFF757522, 0xFF757522, 0xFF757522, 0xFF7D7522, 0xFF7F7B42, 0xFF7D7522, 0xFF87994C, 0xFF829544, 0xFF87994C, 0xFF626B27, 0xFF655522, 0xFF6F5A22, 0xFF8FA435, 0xFF8FA435, 0xFF8FA435, 0xFF89A422, 0xFF8FA435, 0xFF8FA435, 
        0xFFA3B12E, 0xFFA3B12E, 0xFF98B427, 0xFF8FA435, 0xD2787244, 0x03000000, 0x03000000, 0x02000000, 0x02000000, 0x01000000, 0x01000000, 0x74404022, 0xD2787244, 0xFFA3B12E, 0xFFA3B12E, 0xFFA3B12E, 0xFF87994C, 0xFF8FA435, 0xFF8FA435, 0xFF87994C, 
        0xFF87994C, 0xFF8E8140, 0xFF8E8140, 0xFF8E8140, 0xFFA3B12E, 0xD2787244, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF7F7B42, 0xFF727E3B, 0xFF85A42B, 0xFF85A42B, 0xFFC8E42E, 0xFFC9EA4C, 0xFFBAE42E, 0xFFB3E442, 0xFFC9EA4C, 0xFFDAEB42, 0xFFDAEB42, 0xFFF5F07A, 0xFFF5F07A, 0xFFF5F07A, 0xFFF5F07A, 0xFFDCEA32, 0xFFC8E42E, 
        0xFF829544, 0xFF7D7522, 0xFF5D542B, 0xFF7E9A22, 0xFF83BC22, 0xFF7ECA27, 0xFF80B122, 0xFFBAE42E, 0xFFC9EA4C, 0xFFF5F07A, 0xFF89A650, 0xFF5A3D22, 0xFF574027, 0xFF4C3822, 0xFF595422, 0xFF626735, 0xFF574027, 0xFF574027, 0xFF5D542B, 0xFF6F7822, 
        0xFF829544, 0xFF89A650, 0xFF97B446, 0xFF97B446, 0xFF89A650, 0xFF87994C, 0xFF6F7822, 0xFF655522, 0xFF66001C, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFE8D1C22, 0xFE8D1C22, 0xFF902E27, 0xFF992B22, 
        0xFF902E27, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFE8D1C22, 0xFE8D1C22, 0xFE8D1C22, 0xFE8D1C22, 0xFE8D1C22, 0xFF7A382B, 0xFF5A001C, 0xFF4C1527, 0xFF482222, 0xFF5A3D22, 0xFF663D22, 0xFF6F5A22, 
        0xFF757522, 0xFF6F5A22, 0xFF626735, 0xFF655522, 0xFF6F5A22, 0xFF757522, 0xFF6F5A22, 0xFF7D7522, 0xFF757522, 0xFF757522, 0xFF757522, 0xFF6F5A22, 0xFF6F5A22, 0xFF7D7522, 0xFF8E8140, 0xFF8FA435, 0xFF829544, 0xFF6F7822, 0xFF757522, 0xFF8E8140, 
        0xFF829544, 0xFF8E8140, 0xFF8FA435, 0xFFA3B12E, 0xFF98B427, 0xFF829544, 0xFF829544, 0xFF829544, 0xFF98B427, 0xFF98B427, 0xFF98B427, 0xFFA3B12E, 0xFFACC32E, 0xFFA3B12E, 0xFF8FA435, 0xFF8FA435, 0xFF829544, 0xFF7D7522, 0xFF87994C, 0xFF7F7B42, 
        0xFF7F7B42, 0xFF896D22, 0xFF7F7B42, 0xFF83573D, 0xFFAD8722, 0xFF8FA435, 0x74404022, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFADE12E, 0xFF97C335, 0xFF7E9A22, 0xFFB9C32E, 0xFFC9EA4C, 0xFFADE12E, 0xFFB3E442, 0xFFDAEB42, 0xFFDAEB42, 0xFFDAEB42, 0xFFC9EA4C, 0xFEA8C346, 0xFF8FA435, 0xFF87994C, 0xFF8FA435, 0xFFB9C32E, 0xFFC8E42E, 
        0xFFACC32E, 0xFF8E8140, 0xFF655522, 0xFF626B27, 0xFF83BC22, 0xFF83BC22, 0xFF83BC22, 0xFF97C335, 0xFFC8E42E, 0xFFDAEB42, 0xFCBEC678, 0xFF604022, 0xFF574027, 0xFF574027, 0xFF574027, 0xFF4C3822, 0xFF5D542B, 0xFF8FA435, 0xFF9AD646, 0xFFBAE42E, 
        0xFFC9EA4C, 0xFFD4ED6D, 0xFFD4ED6D, 0xFFF5F07A, 0xFFF5F07A, 0xFFF5F07A, 0xFFF5F07A, 0xFFD4ED6D, 0xFCBEC678, 0xFF8FA435, 0xFF902E27, 0xFF902E27, 0xFF992B22, 0xFF992B22, 0xFF902E27, 0xFE8D1C22, 0xFF66001C, 0xFF7A382B, 0xFE8D1C22, 0xFF992B22, 
        0xFF902E27, 0xFF902E27, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFE8D1C22, 0xFE8D1C22, 0xFE8D1C22, 0xFF7A382B, 0xFF66001C, 0xFF4C1527, 0xFF5A3D22, 0xFF655522, 0xFF6F5A22, 0xFF6F5A22, 0xFF655522, 
        0xFF757522, 0xFF6F5A22, 0xFF6F7822, 0xFF6F5A22, 0xFF6F5A22, 0xFF7D7522, 0xFF757522, 0xFF7D7522, 0xFF7D7522, 0xFF6F5A22, 0xFF655522, 0xFF6F5A22, 0xFF7D7522, 0xFF8E8140, 0xFF6F5A22, 0xFF7D7522, 0xFF8E8140, 0xFF757522, 0xFF5D542B, 0xFF7D7522, 
        0xFF7D7522, 0xFF7D7522, 0xFF7D7522, 0xFF8FA435, 0xFF8E8140, 0xFF8FA435, 0xFF8FA435, 0xFF8FA435, 0xFF8FA435, 0xFF98B427, 0xFF8FA435, 0xFFB9C32E, 0xFF8FA435, 0xFF87994C, 0xFF8E8140, 0xFF8FA435, 0xFF829544, 0xFF626735, 0xFF8E8140, 0xFF6F5A22, 
        0xFF6F5A22, 0xFF7A382B, 0xFF6F5A22, 0xFF655522, 0xFF896D22, 0xFF8E8140, 0xD2787244, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x02000000, 0x02000000, 0x02000000, 0x01000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFADE12E, 0xFFB3E442, 0xFF97C335, 0xFFBAE42E, 0xFFADE12E, 0xFFBAE42E, 0xFFD4ED6D, 0xFFD4ED6D, 0xFEA8C346, 0xFF87994C, 0xFF757522, 0xFF5D542B, 0xFF727E3B, 0xFF626B27, 0xFF5D542B, 0xFF595422, 0xFF655522, 
        0xFF8E8140, 0xFF829544, 0xFF7D7522, 0xFE4C3D22, 0xFF74A422, 0xFF83BC22, 0xFF83BC22, 0xFF7DAF2B, 0xFFBAE42E, 0xFFD4E62E, 0xFFD4ED6D, 0xFF69862B, 0xFF574027, 0xFF574027, 0xFF5D542B, 0xFF6F5A22, 0xFFACC32E, 0xFFBAE42E, 0xFFBAE42E, 0xFFBAE42E, 
        0xFFC9EA4C, 0xFFF5F07A, 0xFFF5F07A, 0xFFF5F07A, 0xFFF5F07A, 0xFCBEC678, 0xFF829544, 0xFF5D542B, 0xFF655522, 0xFF7F7B42, 0xFF8E8140, 0xFF896D22, 0xFF902E27, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFF7A382B, 0xFF7A382B, 0xFE8D1C22, 0xFF992B22, 
        0xFF992B22, 0xFE8D1C22, 0xFE8D1C22, 0xFF902E27, 0xFF992B22, 0xFE8D1C22, 0xFF902E27, 0xFE8D1C22, 0xFF7D626D, 0xFF837278, 0xFF66001C, 0xFF66001C, 0xFF55322E, 0xFF5A3D22, 0xFF6F5A22, 0xFF6F5A22, 0xFF6F5A22, 0xFF6F5A22, 0xFF757522, 0xFF6F5A22, 
        0xFF6F5A22, 0xFF7D7522, 0xFF757522, 0xFF6F5A22, 0xFF655522, 0xFF6F5A22, 0xFF6F5A22, 0xFF7D7522, 0xFF757522, 0xFF604022, 0xFF604022, 0xFF6F5A22, 0xFF6F5A22, 0xFF6F5A22, 0xFF6F5A22, 0xFF7D7522, 0xFF757522, 0xFF7D7522, 0xFF5D542B, 0xFF5A3D22, 
        0xFF6F5A22, 0xFF6F5A22, 0xFF7D7522, 0xFF7D7522, 0xFF7F7B42, 0xFF7D7522, 0xFF7F7B42, 0xFF7F7B42, 0xFF8E8140, 0xFF8E8140, 0xFF7D7522, 0xFF8E8140, 0xFF7D7522, 0xFF7D7522, 0xFF6F5A22, 0xFFAD8722, 0xFF7F7B42, 0xFF6F5A22, 0xFF896D22, 0xFF6F5A22, 
        0xFF5F3B38, 0xFF5F3B38, 0xFF55322E, 0xFF5F3B38, 0xFF6F5A22, 0xFF83573D, 0xD2787244, 0x02000000, 0x03000000, 0x04000000, 0x04000000, 0x04000000, 0x05000000, 0x04000000, 0x04000000, 0x03000000, 0x02000000, 0x02000000, 0x01000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFB3E442, 0xFFB3E442, 0xFFACC32E, 0xFFBAE42E, 0xFFADE12E, 0xFFC9EA4C, 0xFFBAE42E, 0xFF69862B, 0xFF635248, 0xFF6F5A22, 0xFF5A3D22, 0xFF400022, 0xFF606722, 0xFF7E9A22, 0xFF69862B, 0xFF626735, 0xFF595422, 
        0xFF574027, 0xFFAD8722, 0xFF7F7B42, 0xFF606722, 0xFF627D27, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF98B427, 0xFFBAE42E, 0xFFDAEB42, 0xFCBEC678, 0xFE503227, 0xFF574027, 0xFF6F5A22, 0xFF97C335, 0xFFADE12E, 0xFFACC32E, 0xFFACC32E, 0xFFC8E42E, 
        0xFFD4ED6D, 0xFFD4ED6D, 0xFFF5F07A, 0xFFD4ED6D, 0xFF727E3B, 0xFF626735, 0xFF626735, 0xFE4C3D22, 0xFF38001C, 0xFF46001C, 0xFF4C1527, 0xFF7A382B, 0xFE8D1C22, 0xFE8D1C22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFF7A382B, 0xFF7A382B, 0xFE8D1C22, 
        0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFF7D626D, 0xFF7D626D, 0xFF7D626D, 0xFFC2BEC6, 0xFF4C3822, 0xFF574027, 0xFE503227, 0xFF5A3D22, 0xFF604022, 0xFF606722, 0xFF6F5A22, 0xFF6F5A22, 0xFF6F7822, 0xFF6F5A22, 
        0xFF757522, 0xFF7D7522, 0xFF626B27, 0xFF757522, 0xFF606722, 0xFF655522, 0xFF757522, 0xFF7D7522, 0xFF606722, 0xFF5A3D22, 0xFF574027, 0xFF604022, 0xFF604022, 0xFF6F5A22, 0xFF5A3D22, 0xFF7D7522, 0xFF6F5A22, 0xFF574027, 0xFF55322E, 0xFF5A3D22, 
        0xFF5A3D22, 0xFF604022, 0xFF7D7522, 0xFF7D7522, 0xFF757522, 0xFF5D542B, 0xFF757522, 0xFF757522, 0xFF6F5A22, 0xFF7D7522, 0xFF757522, 0xFF896D22, 0xFF6F5A22, 0xFF896D22, 0xFF757522, 0xFF8E8140, 0xFF7F7B42, 0xFF5A3D22, 0xFF6F5A22, 0xFE503227, 
        0xFF604022, 0xE4553B2B, 0xD2787244, 0xFF574027, 0xFF5F3B38, 0xFF6F5A22, 0xD2787244, 0x05000000, 0x07000000, 0x08000000, 0x09000000, 0x09000000, 0x0A000000, 0x09000000, 0x08000000, 0x07000000, 0x05000000, 0x04000000, 0x03000000, 0x01000000, 
        0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFADE12E, 0xFF9AD646, 0xFFACC32E, 0xFF9AD646, 0xFFC9EA4C, 0xFFB3E442, 0xFF97C335, 0xFF69862B, 0xFF574027, 0xFF6F5A22, 0xFF482222, 0xFF3D001C, 0xFE503227, 0xFF69862B, 0xFF69862B, 0xFF69862B, 0xFF7F7B42, 
        0xFF7E9A22, 0xFF89A422, 0xFF7E9A22, 0xFF7E9A22, 0xFF606722, 0xFF74A422, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF85A42B, 0xFFC8E42E, 0xFFDAEB42, 0xFFB6E45F, 0xFE4C3D22, 0xFF574027, 0xFF7F7B42, 0xFF97C335, 0xFF97C335, 0xFF97C335, 0xFFB9C32E, 0xFFDAEB42, 
        0xFFD4ED6D, 0xFFD4ED6D, 0xFFD4ED6D, 0xFF727E3B, 0xFF5D542B, 0xFE4C3D22, 0xFE4C3D22, 0xFF5D542B, 0xFE4C3D22, 0xFF38001C, 0xFF3B001C, 0xFF5A001C, 0xFF66001C, 0xFF7A382B, 0xFE8D1C22, 0xFE8D1C22, 0xFF902E27, 0xFF7A382B, 0xFF7A382B, 0xFE8D1C22, 
        0xFE8D1C22, 0xFF992B22, 0xFF7A382B, 0xFE8D1C22, 0xFF66001C, 0xFF5A001C, 0xFF705957, 0xFF908494, 0xFF62404A, 0xFF908494, 0xFF595422, 0xFF5D542B, 0xFF5A3D22, 0xFF655522, 0xFF604022, 0xFF6F5A22, 0xFF626B27, 0xFF655522, 0xFF7D7522, 0xFF6F7822, 
        0xFF6F5A22, 0xFF7D7522, 0xFF655522, 0xFF6F5A22, 0xFF757522, 0xFE503227, 0xFF604022, 0xFF6F5A22, 0xFF757522, 0xFF46001C, 0xFE503227, 0xFF46001C, 0xFF4C1527, 0xFF5A3D22, 0xFF46001C, 0xFF663D22, 0xFF604022, 0xFF4C1527, 0xFF420022, 0xFF5A3D22, 
        0xFF604022, 0xFF604022, 0xFF6F5A22, 0xFF7D7522, 0xFF6F5A22, 0xFF4C3822, 0xFF655522, 0xFF626B27, 0xFF655522, 0xFF6F5A22, 0xFF757522, 0xFF6F5A22, 0xFF6F5A22, 0xFF6F5A22, 0xFF6F5A22, 0xFF83573D, 0xFF6F5A22, 0xFF4C1527, 0xFF6F5A22, 0xCB4A3822, 
        0x01000000, 0x02000000, 0x02000000, 0x03000000, 0xFF655522, 0xFF5F3B38, 0xD65C672E, 0x0B000000, 0x0D000000, 0x0F000000, 0x11000000, 0x12000000, 0x12000000, 0x11000000, 0x0F000000, 0x0D000000, 0x0A000000, 0x08000000, 0x05000000, 0x03000000, 
        0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF7E9A22, 0xFF7E9A22, 0xFFACC32E, 0xFFADE12E, 0xFFBAE42E, 0xFF7E9A22, 0xFF829544, 0xFF85A42B, 0xFF595422, 0xFF5D542B, 0xFF574027, 0xFF626B27, 0xFF7E9A22, 0xFF98B427, 0xFFACC32E, 0xFFACC32E, 0xFEA8C346, 
        0xFFA3B12E, 0xFF98B427, 0xFF98B427, 0xFF98B427, 0xFF627D27, 0xFF627D27, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF7DAF2B, 0xFFACC32E, 0xFFC8E42E, 0xFFD4ED6D, 0xFF627D27, 0xFF574027, 0xFF7E9A22, 0xFF85A42B, 0xFF98B427, 0xFF97C335, 0xFFD4E62E, 0xFFDAEB42, 
        0xFFD4ED6D, 0xFFD4ED6D, 0xFF727E3B, 0xFE482B1C, 0xFF3D001C, 0xFF574027, 0xFF626735, 0xFF574027, 0xFF574027, 0xFF4C3822, 0xFF3D001C, 0xFF3D001C, 0xFF4C1527, 0xFF66001C, 0xFF7A382B, 0xFF7A382B, 0xFE8D1C22, 0xFF7A382B, 0xFF66001C, 0xFF5A001C, 
        0xFF66001C, 0xFF66001C, 0xFE503227, 0xFF4C1527, 0xFF46001C, 0xFD461C22, 0xFF62404A, 0xFF908494, 0xFF55322E, 0xFF908494, 0xFF626735, 0xFF5D542B, 0xFF606722, 0xFF655522, 0xFF5A3D22, 0xFF6F5A22, 0xFF6F5A22, 0xFF6F5A22, 0xFF7D7522, 0xFF757522, 
        0xFF655522, 0xFF8E8140, 0xFF6F5A22, 0xFF604022, 0xFF7D7522, 0xFF574027, 0xFF574027, 0xFF6F5A22, 0xFF757522, 0xFF46001C, 0xFF4C1527, 0xFF46001C, 0xFF4C1527, 0xFF482222, 0xFF3D001C, 0xFE503227, 0xFF482222, 0xFF420022, 0xFF46001C, 0xFF55322E, 
        0xFF604022, 0xFF655522, 0xFF6F5A22, 0xFF655522, 0xFF663D22, 0xFE503227, 0xFF6F5A22, 0xFF6F5A22, 0xFF6F5A22, 0xFF655522, 0xFF6F5A22, 0xFF663D22, 0xFF6F5A22, 0xFF663D22, 0xFF635248, 0xFF6F5A22, 0xFF5D542B, 0xFF635248, 0xD65C672E, 0x04000000, 
        0x04000000, 0x04000000, 0x05000000, 0x07000000, 0x09000000, 0x0C000000, 0x74404022, 0x13000000, 0x16000000, 0x19000000, 0x1C000000, 0x1D000000, 0x1D000000, 0x1B000000, 0x19000000, 0x15000000, 0x11000000, 0x0D000000, 0x09000000, 0x06000000, 
        0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF74A422, 0xFF4C3822, 0xFF97C335, 0xFFADE12E, 0xFF87BA3B, 0xFF574027, 0xFF6F5A22, 0xFF8FA435, 0xFF626B27, 0xFF7E9A22, 0xFF97C335, 0xFFACC32E, 0xFFADE12E, 0xFFADE12E, 0xFFADE12E, 0xFFACC32E, 0xFEA8C346, 
        0xFF98B427, 0xFF8FA435, 0xFF89A422, 0xFF8FA435, 0xFF69862B, 0xFF595422, 0xFF74A422, 0xFF74A422, 0xFF7DAF2B, 0xFF8FA435, 0xFFC8E42E, 0xFFD4ED6D, 0xFF74A422, 0xFE503227, 0xFF69862B, 0xFF7E9A22, 0xFF7E9A22, 0xFFB9C32E, 0xFFD4E62E, 0xFFDAEB42, 
        0xFFDAEB42, 0xFF89A650, 0xFD461C22, 0xFE482B1C, 0xFF5D542B, 0xFF626735, 0xFE4C3D22, 0xFF5D542B, 0xFF705957, 0xFF635248, 0xFF837278, 0xFE4C3D22, 0xFF400022, 0xFF46001C, 0xFF5A001C, 0xFF66001C, 0xFF5A001C, 0xFF4C1527, 0xFF482222, 0xFE503227, 
        0xFF574027, 0xFF574027, 0xFF604022, 0xFE503227, 0xFE503227, 0xFE482B1C, 0xFF55322E, 0xFF908494, 0xFF635248, 0xFF837278, 0xFF727E3B, 0xFF606722, 0xFF655522, 0xFF655522, 0xFF5D542B, 0xFF655522, 0xFF5D542B, 0xFF6F5A22, 0xFF7D7522, 0xFF757522, 
        0xFF6F5A22, 0xFF896D22, 0xFF7D7522, 0xFF482222, 0xFF7D7522, 0xFF574027, 0xFF482222, 0xFF663D22, 0xFF7D7522, 0xFF46001C, 0xFF3D0015, 0xFF400015, 0xFF482222, 0xFE503227, 0xFF482222, 0xFF482222, 0xFF46001C, 0xFF3D001C, 0xFF400015, 0xFF4C1527, 
        0xFF55322E, 0xFF655522, 0xFF655522, 0xFF5D542B, 0xFF55322E, 0xFF55322E, 0xFF5A3D22, 0xFF5F3B38, 0xFF5A3D22, 0xFF663D22, 0xFF5D542B, 0xFF5A3D22, 0xFF655522, 0xFF4C1527, 0xFF46001C, 0xFF663D22, 0xFF6F5A22, 0x74404022, 0x09000000, 0x08000000, 
        0x08000000, 0x09000000, 0x0B000000, 0x0D000000, 0x10000000, 0x14000000, 0x19000000, 0x1D000000, 0x23000000, 0x27000000, 0x2A000000, 0x2C000000, 0x2C000000, 0x2A000000, 0x26000000, 0x21000000, 0x1B000000, 0x15000000, 0x0F000000, 0x0A000000, 
        0x06000000, 0x03000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFB3E442, 0xFF69862B, 0xFF7E9A22, 0xFFADE12E, 0xFF6F7822, 0xFF5D542B, 0xFF7D7522, 0xFF98B427, 0xFFADE12E, 0xFF9AD646, 0xFFADE12E, 0xFFADE12E, 0xFFADE12E, 0xFFADE12E, 0xFFADE12E, 0xFFB3E442, 0xFFBAE42E, 
        0xFFBAE42E, 0xFFBAE42E, 0xFFBAE42E, 0xFFADE12E, 0xFF8CC92B, 0xFF627D27, 0xFF606722, 0xFF74A422, 0xFF7DAF2B, 0xFF74A422, 0xFFACC32E, 0xFFC8E42E, 0xFF9AD646, 0xFF69862B, 0xFF6F7822, 0xFF69862B, 0xFF8FA435, 0xFFC8E42E, 0xFFD4E62E, 0xFFD4E62E, 
        0xFEA8C346, 0xFF4C3822, 0xFB554627, 0xFF595422, 0xFF5D542B, 0xFE4C3D22, 0xFF482222, 0xFF62404A, 0xFFACA7B6, 0xFF837278, 0xFFC2BEC6, 0xFF635248, 0xFF604022, 0xFE503227, 0xFF5A3D22, 0xFF604022, 0xFF4C3822, 0xFF5A3D22, 0xFF4C3822, 0xFE503227, 
        0xFF5A3D22, 0xFF5A3D22, 0xFF604022, 0xFF655522, 0xFF5D542B, 0xFF655522, 0xFF4C1527, 0xFF837278, 0xFF635248, 0xFF908494, 0xFF829544, 0xFF6F7822, 0xFF626B27, 0xFF606722, 0xFF574027, 0xFF6F5A22, 0xFF6F5A22, 0xFF6F5A22, 0xFF896D22, 0xFF6F5A22, 
        0xFE503227, 0xFF6F5A22, 0xFF6F5A22, 0xFF4C1527, 0xFF604022, 0xFE503227, 0xFF482222, 0xFF6F5A22, 0xFF635248, 0xE4553B2B, 0x86000000, 0x7A000000, 0x6A000000, 0x5B000000, 0x4E000000, 0x44000000, 0x3F000000, 0x3F000000, 0xCB4A3822, 0xEA3D1515, 
        0xFF46001C, 0xFF4C1527, 0xFF655522, 0xFF8E8140, 0xFF757522, 0xFE503227, 0xFF4C1527, 0xFF4C1527, 0xFF46001C, 0xFF663D22, 0xFF482222, 0xFF5A001C, 0xFF6F5A22, 0xFF62404A, 0xFF6F5A22, 0x74404022, 0x14000000, 0x12000000, 0x11000000, 0x10000000, 
        0x10000000, 0x11000000, 0x13000000, 0x16000000, 0x1A000000, 0x20000000, 0x26000000, 0x2C000000, 0x33000000, 0x37000000, 0x3C000000, 0x3E000000, 0x3E000000, 0x3B000000, 0x36000000, 0x2F000000, 0x27000000, 0x1D000000, 0x16000000, 0x0F000000, 
        0x0A000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF98B427, 0xFF9AD646, 0xFF7F7B42, 0xFFADE12E, 0xFF85A42B, 0xFF98B427, 0xFF97D227, 0xFFADE12E, 0xFFBAE42E, 0xFFBAE42E, 0xFFB3E442, 0xFFB3E442, 0xFFB3E442, 0xFFC9EA4C, 0xFFBAE42E, 0xFFBAE42E, 0xFFBAE42E, 
        0xFFBAE42E, 0xFFC9EA4C, 0xFFBAE42E, 0xFFBAE42E, 0xFFADE12E, 0xFF69862B, 0xFF595422, 0xFF69862B, 0xFF74A422, 0xFF74A422, 0xFF8FA435, 0xFFBAE42E, 0xFFADE12E, 0xFF85A42B, 0xFF6F7822, 0xFF69862B, 0xFFB9C32E, 0xFFC8E42E, 0xFFC8E42E, 0xFFC9EA4C, 
        0xFF626B27, 0xFF574027, 0xFF5D542B, 0xFF595422, 0xFF626735, 0xFF595422, 0xFE482B1C, 0xFF62404A, 0xFFC2BEC6, 0xFF7D626D, 0xFF908494, 0xFF5D542B, 0xFF55322E, 0xFF574027, 0xFF5A3D22, 0xFF5D542B, 0xFF574027, 0xFF5A3D22, 0xFF574027, 0xFF574027, 
        0xFF55322E, 0xFF663D22, 0xFF574027, 0xFF655522, 0xFF655522, 0xFF655522, 0xFE503227, 0xFF62404A, 0xFF635248, 0xFF62404A, 0xFF908494, 0xFF7F7B42, 0xFF6F7822, 0xFF606722, 0xFF595422, 0xFF6F5A22, 0xFF6F5A22, 0xFF663D22, 0xFF6F5A22, 0xFF7D7522, 
        0xFF482222, 0xFF663D22, 0xFF7D7522, 0xFE503227, 0xFE503227, 0xFE482B1C, 0xFF482222, 0xCB4A3822, 0x9D000000, 0x96000000, 0x8C000000, 0x82000000, 0x74000000, 0x67000000, 0x5D150000, 0x54150000, 0x50150000, 0x50150000, 0x54150000, 0x58150000, 
        0xFF574027, 0xFE482B1C, 0xFF55322E, 0xFF757522, 0xFF8E8140, 0xFF757522, 0xE4553B2B, 0xCB4A3822, 0xCB4A3822, 0xCB4A3822, 0xFF635248, 0xFF7F7B42, 0xD2787244, 0x74404022, 0x29000000, 0x25000000, 0x21000000, 0x1D000000, 0x1C000000, 0x1B000000, 
        0x1B000000, 0x1C000000, 0x1F000000, 0x23000000, 0x27000000, 0x2F000000, 0x36000000, 0x3E000000, 0x44000000, 0x4A000000, 0x4E000000, 0x51000000, 0x51000000, 0x4E000000, 0x46000000, 0x3E000000, 0x34000000, 0x29000000, 0x1F000000, 0x15000000, 
        0x0E000000, 0x08000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF606722, 0xFFA3B12E, 0xFFBAE42E, 0xFFBAE42E, 0xFFADE12E, 0xFF74A422, 0xFF627D27, 0xFF626735, 0xFF727E3B, 0xFF97C335, 0xFFADE12E, 0xFFB6E45F, 0xFFB3E442, 0xFFB3E442, 0xFFBAE42E, 0xFFBAE42E, 0xFFB3E442, 
        0xFFB3E442, 0xFFB3E442, 0xFFBAE42E, 0xFFB3E442, 0xFFADE12E, 0xFF7DAF2B, 0xFF627D27, 0xFB554627, 0xFF7E9A22, 0xFF74A422, 0xFF7E9A22, 0xFFBAE42E, 0xFFB6E45F, 0xFF97D227, 0xFF627D27, 0xFF829544, 0xFFC8E42E, 0xFFC8E42E, 0xFFC8E42E, 0xFF97B446, 
        0xFE4C3D22, 0xFF595422, 0xFF595422, 0xFF595422, 0xFF595422, 0xFF4C3822, 0xFF400015, 0xFF5F3B38, 0xFFACA7B6, 0xFF705957, 0xFF837278, 0xFB554627, 0xFF4C3822, 0xFF574027, 0xFF574027, 0xFF5D542B, 0xFF604022, 0xFE503227, 0xFF4C1527, 0xFF482222, 
        0xFF482222, 0xFF5A3D22, 0xFF604022, 0xFF6F5A22, 0xFF5D542B, 0xFF55322E, 0xFF6F5A22, 0xFE503227, 0xFF62404A, 0xFF5F3B38, 0xFF908494, 0xFF606722, 0xFF606722, 0xFF606722, 0xFF5D542B, 0xFF6F5A22, 0xFF6F5A22, 0xFF4C1527, 0xFF663D22, 0xFF604022, 
        0xFF420022, 0xFF7D7522, 0xFF757522, 0xFF4C3822, 0xFB554627, 0xC8351500, 0xA6000000, 0xA3000000, 0xA0000000, 0x9A000000, 0x93000000, 0x8A000000, 0x7F000000, 0x74000000, 0x6B151500, 0x65150000, 0x61150000, 0x61150000, 0x65150000, 0x6B151C00, 
        0xA8000000, 0xE4553B2B, 0xFF46001C, 0xFF55322E, 0xFF5F3B38, 0xFF896D22, 0xFF83573D, 0xD2787244, 0x6B151C00, 0x61150000, 0x58150000, 0x50150000, 0x48000000, 0x42000000, 0x3B000000, 0x34000000, 0x31000000, 0x2C000000, 0x2C000000, 0x2A000000, 
        0x2A000000, 0x2C000000, 0x2F000000, 0x33000000, 0x39000000, 0x3F000000, 0x48000000, 0x50150000, 0x58150000, 0x5D150000, 0x61150000, 0x65150000, 0x63000000, 0x5E000000, 0x58150000, 0x4C150000, 0x42000000, 0x34000000, 0x27000000, 0x1C000000, 
        0x12000000, 0x0B000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFE482B1C, 0xFF8FA435, 0xFFADE12E, 0xFFADE12E, 0xFF9AD646, 0xFF85A42B, 0xFF97C335, 0xFF97D227, 0xFF85A42B, 0xFF69862B, 0xFF595422, 0xFF595422, 0xFF606722, 0xFF727E3B, 0xFF829544, 0xFF7E9A22, 0xFF84AE4C, 
        0xFF84AE4C, 0xFF7DAF2B, 0xFF85A42B, 0xFF7E9A22, 0xFF7E9A22, 0xFF627D27, 0xFF595422, 0xFE4C3D22, 0xFF595422, 0xFF74A422, 0xFF69862B, 0xFFACC32E, 0xFFB6E45F, 0xFF8CC92B, 0xFF626B27, 0xFF8FA435, 0xFFBAE42E, 0xFFBAE42E, 0xFFBAE42E, 0xFE4C3D22, 
        0xFE4C3D22, 0xFF595422, 0xFB554627, 0xFB554627, 0xFF574027, 0xFE482B1C, 0xFF400022, 0xFF62404A, 0xFF908494, 0xFF837278, 0xFF908494, 0xFF727E3B, 0xFF595422, 0xFF574027, 0xFF4C3822, 0xFE503227, 0xFF4C1527, 0xFF400022, 0xFF46001C, 0xFD461C22, 
        0xFF400022, 0xFF55322E, 0xFF663D22, 0xFF655522, 0xFF655522, 0xFF626735, 0xFF604022, 0xFF5D542B, 0xFF5F3B38, 0xFF5F3B38, 0xFF837278, 0xFF655522, 0xFF757522, 0xFF7F7B42, 0xFF5D542B, 0xFF604022, 0xFF6F5A22, 0xFE482B1C, 0xFF5A001C, 0xFF4C1527, 
        0xFF3B001C, 0xFF4C1527, 0xFF4C3822, 0xFB554627, 0xA7000000, 0xA7000000, 0xA6000000, 0xA4000000, 0xA2000000, 0x9D000000, 0x98000000, 0x91000000, 0x8A000000, 0x80151500, 0x7A000000, 0x74151500, 0x74151500, 0x74151500, 0x74151500, 0x7E151C00, 
        0x7E151C00, 0x85150000, 0xE4553B2B, 0xFF55322E, 0xFF5F3B38, 0xFF663D22, 0xFF5F3B38, 0xFF83573D, 0xFF8E8140, 0x74151500, 0x6B151C00, 0x61150000, 0x5B150000, 0x54150000, 0x4E000000, 0x48000000, 0x44000000, 0x3F000000, 0x3C000000, 0x3C000000, 
        0x3C000000, 0x3C000000, 0x42000000, 0x44000000, 0x4C150000, 0x54000000, 0x5B150000, 0x63000000, 0x6B151500, 0x6F150000, 0x74151500, 0x74151500, 0x71000000, 0x6F150000, 0x65150000, 0x5B150000, 0x4C150000, 0x3F000000, 0x31000000, 0x23000000, 
        0x17000000, 0x0E000000, 0x08000000, 0x04000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF606722, 0xFF9AD646, 0xFF87BA3B, 0xFF80B122, 0xFF9AD646, 0xFE4C3D22, 0xFF606722, 0xFF80B122, 0xFFADE12E, 0xFFADE12E, 0xFEA8C346, 0xFF74A422, 0xFF69862B, 0xFF606722, 0xFE4C3D22, 0xFB554627, 0xFF606722, 
        0xFF6F7822, 0xFF69862B, 0xFF69862B, 0xFF627D27, 0xFF627D27, 0xFF627D27, 0xFF595422, 0xFE482B1C, 0xFF3D001C, 0xFF595422, 0xFF69862B, 0xFF89A422, 0xFFB3E442, 0xFF627D27, 0xFF606722, 0xFFACC32E, 0xFFBAE42E, 0xFFB9C32E, 0xFF606722, 0xFF4C3822, 
        0xFE4C3D22, 0xFB554627, 0xFE4C3D22, 0xFB554627, 0xFF626735, 0xFF626735, 0xFF7F7B42, 0xFF8FA435, 0xFCBEC678, 0xFCBEC678, 0xFFB6E45F, 0xFEA8C346, 0xFF97B446, 0xFF8FA435, 0xFF829544, 0xFF5D542B, 0xFE503227, 0xFE503227, 0xFF5D542B, 0xFF604022, 
        0xFF4C3822, 0xFF482222, 0xFF4C1527, 0xFF655522, 0xFF6F5A22, 0xFF6F5A22, 0xFF604022, 0xFF6F5A22, 0xFF4C3822, 0xFF4C1527, 0xFE503227, 0xFF655522, 0xFF655522, 0xFF7D7522, 0xFE482B1C, 0xFF663D22, 0xFF663D22, 0xFF482222, 0xFF38001C, 0xFF4C1527, 
        0xFF3B151C, 0xFF420022, 0xEA3D1515, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA5000000, 0xA3000000, 0xA0000000, 0x9C000000, 0x96000000, 0x91000000, 0x8B150000, 0x86000000, 0x85150000, 0x80151500, 0x85150000, 0x85150000, 0x8B150000, 
        0x8B150000, 0x8F150000, 0x97151500, 0xC8351500, 0xE4553B2B, 0xFB554627, 0xFF5D542B, 0xFE503227, 0xFF6F5A22, 0xFF8E8140, 0x7E151C00, 0x74151500, 0x6B151C00, 0x67000000, 0x61150000, 0x5D150000, 0x58000000, 0x54000000, 0x51000000, 0x50150000, 
        0x50150000, 0x51000000, 0x54000000, 0x58150000, 0x5E000000, 0x65150000, 0x6B151500, 0x74151500, 0x7A000000, 0x7E150000, 0x80151500, 0x80151500, 0x7E150000, 0x77150000, 0x6F150000, 0x65150000, 0x58150000, 0x46000000, 0x37000000, 0x27000000, 
        0x1B000000, 0x11000000, 0x0A000000, 0x05000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF7DAF2B, 0xFFADE12E, 0xFF626B27, 0xFF626B27, 0xFF97B446, 0xFF8CC92B, 0xFE482B1C, 0xFE4C3D22, 0xFF69862B, 0xFF80B122, 0xFFACC32E, 0xFFC9EA4C, 0xFFB6E45F, 0xFEA8C346, 0xFF98B427, 0xFF74A422, 0xFF7DAF2B, 
        0xFF7DAF2B, 0xFF74A422, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF80B122, 0xFF7DAF2B, 0xFF69862B, 0xFE4C3D22, 0xFF574027, 0xFF7E9A22, 0xFFB9C32E, 0xFF627D27, 0xFF7D7522, 0xFFB9C32E, 0xFFA3B12E, 0xFF595422, 0xFE482B1C, 0xFF626735, 
        0xFF829544, 0xFF97B446, 0xFEA8C346, 0xFFB6E45F, 0xFFB6E45F, 0xFFB6E45F, 0xFFB6E45F, 0xFFB6E45F, 0xFFB3E442, 0xFFB3E442, 0xFFB3E442, 0xFFB3E442, 0xFFB3E442, 0xFFB3E442, 0xFFC9EA4C, 0xFFC9EA4C, 0xFFB6E45F, 0xFEA8C346, 0xFF89A650, 0xFF626735, 
        0xFF5A3D22, 0xFE503227, 0xFF4C1527, 0xFF5A3D22, 0xFF6F5A22, 0xFF83573D, 0xFF5A3D22, 0xFF6F5A22, 0xFF5D542B, 0xFF46001C, 0xFF482222, 0xFF604022, 0xFF5D542B, 0xFF6F5A22, 0xFE4A3B1C, 0xFF420022, 0xFE4C3D22, 0xFF35001C, 0xFF35001C, 0xFF3D001C, 
        0xFD461C22, 0xFF3D0015, 0xEA3D1515, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA3000000, 0xA0000000, 0x9D000000, 0x99000000, 0x95000000, 0x93000000, 0x8F150000, 0x8F150000, 0x8F150000, 0x91000000, 0x93000000, 
        0x97151500, 0x97151500, 0x9A000000, 0x9D1C0000, 0x9D1C0000, 0x9D1C0000, 0xC8351500, 0xFF635248, 0xFF5A3D22, 0xFF6F5A22, 0xFF8E8140, 0xD2787244, 0x7E151C00, 0x7A000000, 0x74151500, 0x71000000, 0x6B151500, 0x67000000, 0x67000000, 0x63000000, 
        0x63000000, 0x67000000, 0x67000000, 0x6B151500, 0x71000000, 0x77150000, 0x7C000000, 0x80151500, 0x85150000, 0x85150000, 0x86000000, 0x85150000, 0x80151500, 0x7C000000, 0x74151500, 0x6A150000, 0x5B150000, 0x4C150000, 0x3B000000, 0x2C000000, 
        0x1D000000, 0x13000000, 0x0B000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF83BC22, 0xFFB3E442, 0xFF595422, 0xFF595422, 0xFF69862B, 0xFFADE12E, 0xFF74A422, 0xFF482222, 0xFF595422, 0xFF7E9A22, 0xFF7E9A22, 0xFF97C335, 0xFFB3E442, 0xFFC9EA4C, 0xFFD4ED6D, 0xFFB6E45F, 0xFF97C335, 
        0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF80B122, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF74A422, 0xFF606722, 0xFF626B27, 0xFEA8C346, 0xFF7DAF2B, 0xFF98B427, 0xFF8FA435, 0xFF87994C, 0xFF97B446, 0xFEA8C346, 0xFFB6E45F, 
        0xFFB6E45F, 0xFFB6E45F, 0xFFB6E45F, 0xFFB3E442, 0xFFADE12E, 0xFFADE12E, 0xFFADE12E, 0xFF9AD646, 0xFF9AD646, 0xFF9AD646, 0xFF9AD646, 0xFF9AD646, 0xFF9AD646, 0xFF9AD646, 0xFF9AD646, 0xFFADE12E, 0xFFADE12E, 0xFFB3E442, 0xFFC9EA4C, 0xFFB6E45F, 
        0xFEA8C346, 0xFF727E3B, 0xFF4C3822, 0xFE503227, 0xFF655522, 0xFF6F5A22, 0xFF4C3822, 0xFF604022, 0xFF6F5A22, 0xFE503227, 0xFF46001C, 0xFE503227, 0xFF5A3D22, 0xFE503227, 0xFE482B1C, 0xFF3B001C, 0xFF3B151C, 0xFF35001C, 0xFF38001C, 0xFF38001C, 
        0xFF4C1527, 0xFF3B001C, 0xC8351500, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA3000000, 0xA0000000, 0x9D000000, 0x9C000000, 0x9A000000, 0x99000000, 0x97151500, 0x97151500, 0x97151500, 0x97151500, 
        0x9A000000, 0x9C000000, 0x9D000000, 0x9D000000, 0x9D000000, 0x9C000000, 0x9A000000, 0x97151500, 0xFF574027, 0xFF5A3D22, 0xFF8E8140, 0xFF8E8140, 0xFFAD8722, 0x86000000, 0x85150000, 0x80151500, 0x7C000000, 0x7A000000, 0x77000000, 0x77000000, 
        0x77000000, 0x77000000, 0x7A000000, 0x7C000000, 0x80151500, 0x82000000, 0x85150000, 0x86000000, 0x8A000000, 0x8A000000, 0x86000000, 0x85150000, 0x80151500, 0x7A000000, 0x74151500, 0x67000000, 0x5B150000, 0x4C150000, 0x3C000000, 0x2C000000, 
        0x20000000, 0x14000000, 0x0C000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF97D227, 0xFFC9EA4C, 0xFF98B427, 0xFF606722, 0xFF69862B, 0xFF97C335, 0xFFB6E45F, 0xFF626B27, 0xFF3D001C, 0xFF606722, 0xFF74A422, 0xFF74A422, 0xFF85A42B, 0xFF97D227, 0xFFB3E442, 0xFFC9EA4C, 0xFFC9EA4C, 
        0xFFC9EA4C, 0xFF8CC92B, 0xFF97D227, 0xFF97D227, 0xFF7ECA27, 0xFF7ECA27, 0xFF7ECA27, 0xFF7ECA27, 0xFF7ECA27, 0xFF83BC22, 0xFF83BC22, 0xFF80B122, 0xFF9AD646, 0xFFB3E442, 0xFFB3E442, 0xFFB6E45F, 0xFFB6E45F, 0xFF97B446, 0xFF84AE4C, 0xFF84AE4C, 
        0xFF7DAF2B, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF7E9A22, 0xFF7E9A22, 0xFF7E9A22, 0xFF7E9A22, 0xFF69862B, 0xFF7E9A22, 0xFF7E9A22, 0xFF7E9A22, 0xFF85A42B, 0xFF85A42B, 0xFF87BA3B, 0xFF97C335, 0xFF9AD646, 
        0xFFADE12E, 0xFFD4ED6D, 0xFCBEC678, 0xFF727E3B, 0xFF6F5A22, 0xFF7D7522, 0xFF574027, 0xFF5A001C, 0xFF655522, 0xFF46001C, 0xFF350022, 0xFF3D0022, 0xFF3B151C, 0xFF3D0015, 0xFE482B1C, 0xFF350015, 0xFF3B001C, 0xFF350015, 0xFF3B001C, 0xFF350015, 
        0xFF46001C, 0xFF3D001C, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA4000000, 0xA2000000, 0xA0000000, 0x9F000000, 0x9D000000, 0x9D000000, 0x9C000000, 0x9C000000, 0x9C000000, 
        0x9A000000, 0x9A000000, 0x9A000000, 0x9A000000, 0x9A000000, 0x99000000, 0x97151500, 0x97151500, 0x97151500, 0xFF663D22, 0xFF626735, 0xFF655522, 0xFF604022, 0xFFA37622, 0x8F150000, 0x8C000000, 0x8B150000, 0x8A000000, 0x86000000, 0x86000000, 
        0x85150000, 0x85150000, 0x85150000, 0x86000000, 0x8A000000, 0x8B150000, 0x8B150000, 0x8B150000, 0x8A000000, 0x86000000, 0x82000000, 0x7E150000, 0x77150000, 0x74151500, 0x6B151500, 0x61150000, 0x54150000, 0x48000000, 0x3B000000, 0x2C000000, 
        0x1F000000, 0x14000000, 0x0C000000, 0x07000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFADE12E, 0xFFC9EA4C, 0xFF97D227, 0xFF69862B, 0xFF627D27, 0xFF7E9A22, 0xFF9AD646, 0xFFB6E45F, 0xFE4C3D22, 0xFF595422, 0xFF69862B, 0xFF85A42B, 0xFF7DAF2B, 0xFF7E9A22, 0xFF98B427, 0xFFADE12E, 0xFFB3E442, 
        0xFFC9EA4C, 0xFFD4ED6D, 0xFFB3E442, 0xFF83BC22, 0xFF7ECA27, 0xFF83BC22, 0xFF69862B, 0xFF606722, 0xFE4A3B1C, 0xFE4A3B1C, 0xFF606722, 0xFFB6E45F, 0xFFBAE42E, 0xFFBAE42E, 0xFF97D227, 0xFF97C335, 0xFF97C335, 0xFF626B27, 0xFE482B1C, 0xFF420022, 
        0xFF4C3822, 0xFF5D542B, 0xFF69862B, 0xFF7E9A22, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF74A422, 0xFF7E9A22, 0xFF7E9A22, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF7DAF2B, 0xFF80B122, 0xFF80B122, 0xFF7DAF2B, 0xFF74A422, 
        0xFF7E9A22, 0xFF89A422, 0xFF97C335, 0xFFB6E45F, 0xFEA8C346, 0xFF626B27, 0xFF3D001C, 0xFF46001C, 0xFF655522, 0xFF3B001C, 0xFF38001C, 0xFF38001C, 0xFF3D001C, 0xFF38001C, 0xFF38001C, 0xFF35001C, 0xFF35001C, 0xFF35001C, 0xFF46001C, 0xFF3D001C, 
        0xFF3D001C, 0xFF48002B, 0xA8000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA4000000, 0xA3000000, 0xA2000000, 0xA0000000, 0x9F000000, 0x9D000000, 0x9A000000, 0x9A000000, 
        0x98000000, 0x96000000, 0x95000000, 0x93000000, 0x93000000, 0x93000000, 0x91000000, 0x91000000, 0x91000000, 0x93000000, 0xE6502222, 0xFB554627, 0xFF574027, 0xFF604022, 0xFFAD8722, 0x95000000, 0x93000000, 0x93000000, 0x91000000, 0x8F000000, 
        0x8F150000, 0x8F150000, 0x8F150000, 0x8F150000, 0x8C000000, 0x8B150000, 0x8B150000, 0x86000000, 0x85150000, 0x7E150000, 0x7A000000, 0x71000000, 0x6B151500, 0x65150000, 0x5D150000, 0x54150000, 0x4C150000, 0x3F000000, 0x34000000, 0x27000000, 
        0x1C000000, 0x13000000, 0x0B000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFBAE42E, 0xFFB6E45F, 0xFF98B427, 0xFF74A422, 0xFF627D27, 0xFF69862B, 0xFF97C335, 0xFFB3E442, 0xFF9AD646, 0xFF626B27, 0xFF595422, 0xFF69862B, 0xFF80B122, 0xFF80B122, 0xFF74A422, 0xFF85A42B, 0xFF97D227, 
        0xFFADE12E, 0xFFB3E442, 0xFFC9EA4C, 0xFFB6E45F, 0xFF7E9A22, 0xFE4A3B1C, 0xFE4C3D22, 0xFF595422, 0xFF626B27, 0xFF74A422, 0xFF9AD646, 0xFF97D227, 0xFF7F7B42, 0xFFACC32E, 0xFF9AD646, 0xFF595422, 0xFF626B27, 0xFF97B446, 0xFEA8C346, 0xFF97B446, 
        0xFF727E3B, 0xFE4C3D22, 0xFE482B1C, 0xFE4C3D22, 0xFF595422, 0xFF627D27, 0xFF69862B, 0xFF7E9A22, 0xFF74A422, 0xFF7DAF2B, 0xFF74A422, 0xFF74A422, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF80B122, 0xFF87BA3B, 0xFF8CC92B, 0xFF97C335, 0xFF8CC92B, 0xFF97C335, 
        0xFF97C335, 0xFF87BA3B, 0xFF80B122, 0xFF80B122, 0xFF98B427, 0xFEA8C346, 0xFF84AE4C, 0xFE4C3D22, 0xFE482B1C, 0xFF38001C, 0xFF38001C, 0xFF35001C, 0xFF35001C, 0xFF38001C, 0xFF350015, 0xFF35001C, 0xFF35001C, 0xFF3D001C, 0xFF4C1527, 0xFF46001C, 
        0xFF380015, 0xFF4C1527, 0xE6502222, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA6000000, 0xA5000000, 0xA3000000, 0xA2000000, 0xA0000000, 0x9D000000, 0x9A000000, 0x96000000, 0x93000000, 
        0x8F000000, 0x8C000000, 0x8B150000, 0x86000000, 0x86000000, 0x86000000, 0x86000000, 0x86000000, 0x86000000, 0x8A000000, 0x8C000000, 0x8F000000, 0xC8351500, 0xFF574027, 0xFF896D22, 0xD2787244, 0x98000000, 0x98000000, 0x97151500, 0x95000000, 
        0x93000000, 0x93000000, 0x91000000, 0x8F150000, 0x8B150000, 0x8A000000, 0x85150000, 0x7E150000, 0x7A000000, 0x71000000, 0x6A150000, 0x61150000, 0x5B150000, 0x54150000, 0x4C150000, 0x46000000, 0x3F000000, 0x36000000, 0x2C000000, 0x22000000, 
        0x18000000, 0x10000000, 0x0A000000, 0x05000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFC9EA4C, 0xFF9AD646, 0xFF74A422, 0xFF69862B, 0xFF626B27, 0xFF627D27, 0xFF7E9A22, 0xFF97D227, 0xFFB6E45F, 0xFF87BA3B, 0xFF595422, 0xFF595422, 0xFF7E9A22, 0xFF83BC22, 0xFF83BC22, 0xFF87BA3B, 0xFF85A42B, 
        0xFF80B122, 0xFF9AD646, 0xFFADE12E, 0xFFB3E442, 0xFFD4ED6D, 0xFF97C335, 0xFF6F7822, 0xFF8CC92B, 0xFF9AD646, 0xFF9AD646, 0xFFADE12E, 0xFF74A422, 0xFE482B1C, 0xFF606722, 0xFF97B446, 0xFF9AD646, 0xFF4C3822, 0xFF595422, 0xFF74A422, 0xFF7DAF2B, 
        0xFEA8C346, 0xFFB6E45F, 0xFCBEC678, 0xFF89A650, 0xFF595422, 0xFE482B1C, 0xFF574027, 0xFF595422, 0xFF595422, 0xFF626B27, 0xFF626B27, 0xFF626B27, 0xFF727E3B, 0xFF69862B, 0xFF69862B, 0xFF7E9A22, 0xFF69862B, 0xFF69862B, 0xFF7E9A22, 0xFF7E9A22, 
        0xFF7E9A22, 0xFF7E9A22, 0xFF85A42B, 0xFF80B122, 0xFF80B122, 0xFF80B122, 0xFF97C335, 0xFEA8C346, 0xFF69862B, 0xFF38001C, 0xFF38001C, 0xFF3B001C, 0xFF35001C, 0xFF38001C, 0xFF3B001C, 0xFF38001C, 0xFF3D001C, 0xFF5A001C, 0xFF5A001C, 0xFF4C1527, 
        0xFF35001C, 0xFF46001C, 0xE6502222, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA4000000, 0xA2000000, 0x9F000000, 0x9C000000, 0x98000000, 0x93000000, 0x8F000000, 0x8A000000, 
        0x85150000, 0x7F000000, 0x7C000000, 0x7A000000, 0x77000000, 0x77000000, 0x77000000, 0x77000000, 0x7A000000, 0x7C000000, 0x82000000, 0x86000000, 0x8C000000, 0xCB4A3822, 0xFF604022, 0xFF8E8140, 0x98000000, 0x98000000, 0x97151500, 0x97151500, 
        0x93000000, 0x91000000, 0x8F150000, 0x8B150000, 0x85150000, 0x80151500, 0x7A000000, 0x71000000, 0x6A150000, 0x61150000, 0x58150000, 0x50150000, 0x49000000, 0x42000000, 0x3C000000, 0x36000000, 0x31000000, 0x2A000000, 0x22000000, 0x1B000000, 
        0x13000000, 0x0D000000, 0x08000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFD4ED6D, 0xFF97C335, 0xFF69862B, 0xFF69862B, 0xFF626B27, 0xFF627D27, 0xFF69862B, 0xFF83BC22, 0xFF9AD646, 0xFFC9EA4C, 0xFF74A422, 0xFF606722, 0xFF595422, 0xFF74A422, 0xFF8CC92B, 0xFF83BC22, 0xFF87BA3B, 
        0xFF80B122, 0xFF85A42B, 0xFF97D227, 0xFFADE12E, 0xFFADE12E, 0xFFC9EA4C, 0xFF9AD646, 0xFF7DAF2B, 0xFF8CC92B, 0xFFADE12E, 0xFFB3E442, 0xFF606722, 0xFE4A3B1C, 0xFF4C3822, 0xFF69862B, 0xFFB6E45F, 0xFF89A650, 0xFE4C3D22, 0xFF606722, 0xFF7E9A22, 
        0xFF74A422, 0xFF85A42B, 0xFEA8C346, 0xFFB6E45F, 0xFFB6E45F, 0xFCBEC678, 0xFF89A650, 0xFF626735, 0xFE4C3D22, 0xFF604022, 0xFF606722, 0xFF574027, 0xFF5D542B, 0xFF5D542B, 0xFF574027, 0xFF5D542B, 0xFF5A3D22, 0xFF604022, 0xFF5D542B, 0xFF574027, 
        0xFF655522, 0xFF5D542B, 0xFF4C3822, 0xFF4C3822, 0xFE4C3D22, 0xFF5D542B, 0xFF6F7822, 0xFF7E9A22, 0xFF97B446, 0xFF627D27, 0xFF38001C, 0xFF38001C, 0xFF35001C, 0xFF3B001C, 0xFF38001C, 0xFF400015, 0xFF5A001C, 0xFF66001C, 0xFF5A001C, 0xFF4C1527, 
        0xFF38001C, 0xFF3D001C, 0xE6502222, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA4000000, 0xA2000000, 0x9F000000, 0x9A000000, 0x96000000, 0x8F000000, 0x8A000000, 0x82000000, 0x7C000000, 
        0x74000000, 0x6F150000, 0x6A000000, 0x67000000, 0x63000000, 0x63000000, 0x63000000, 0x65150000, 0x67000000, 0x6E000000, 0x74000000, 0x7A000000, 0x7F000000, 0x86000000, 0xCB4A3822, 0xD65C672E, 0x93000000, 0x95000000, 0x93000000, 0x93000000, 
        0x8F150000, 0x8B150000, 0x85150000, 0x80151500, 0x7C000000, 0x74151500, 0x6B151500, 0x63000000, 0x58150000, 0x50150000, 0x46000000, 0x3E000000, 0x37000000, 0x31000000, 0x2C000000, 0x27000000, 0x23000000, 0x1D000000, 0x19000000, 0x13000000, 
        0x0E000000, 0x0A000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFD4ED6D, 0xFF74A422, 0xFF595422, 0xFF69862B, 0xFF627D27, 0xFF69862B, 0xFF69862B, 0xFF74A422, 0xFF8CC92B, 0xFFB3E442, 0xFFB6E45F, 0xFF69862B, 0xFF595422, 0xFF606722, 0xFF80B122, 0xFF8CC92B, 0xFF97C335, 
        0xFF87BA3B, 0xFF80B122, 0xFF85A42B, 0xFF8CC92B, 0xFF9AD646, 0xFFADE12E, 0xFFB6E45F, 0xFF9AD646, 0xFF87BA3B, 0xFFB3E442, 0xFF8CC92B, 0xFB554627, 0xFE482B1C, 0xFF482222, 0xFF627D27, 0xFF8FA435, 0xFFB6E45F, 0xFF627D27, 0xFF4C3822, 0xFF626B27, 
        0xFF69862B, 0xFF69862B, 0xFF7E9A22, 0xFF85A42B, 0xFF97B446, 0xFEA8C346, 0xFCBEC678, 0xFFB6E45F, 0xFF89A650, 0xFF606722, 0xFF6F5A22, 0xFF595422, 0xFF655522, 0xFF655522, 0xFF574027, 0xFF6F5A22, 0xFF604022, 0xFF574027, 0xFF5A3D22, 0xFF655522, 
        0xFF6F5A22, 0xFF6F5A22, 0xFF5A3D22, 0xFF3B001C, 0xFF38001C, 0xFF3B001C, 0xFF38001C, 0xFF400022, 0xFF5A3D22, 0xFF6F7822, 0xFE482B1C, 0xFF3B001C, 0xFF3B001C, 0xFF3D001C, 0xFF400015, 0xFF5A001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF4C1527, 
        0xFF350015, 0xFF350015, 0xFF62404A, 0xA8000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA2000000, 0x9F000000, 0x9A000000, 0x93000000, 0x8C000000, 0x85150000, 0x7C000000, 0x74000000, 0x6A000000, 
        0x63000000, 0x5B000000, 0x58000000, 0x51000000, 0x4E000000, 0x4E000000, 0x4E000000, 0x51000000, 0x54000000, 0x5B000000, 0x61150000, 0x6A000000, 0x71000000, 0x7A000000, 0x80151500, 0x86000000, 0x8B150000, 0x8B150000, 0x8B150000, 0x8B150000, 
        0x8B150000, 0x85150000, 0x7E150000, 0x77150000, 0x6F150000, 0x65150000, 0x5D150000, 0x51000000, 0x48000000, 0x3E000000, 0x34000000, 0x2C000000, 0x27000000, 0x22000000, 0x1D000000, 0x1A000000, 0x17000000, 0x14000000, 0x11000000, 0x0D000000, 
        0x0A000000, 0x06000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFD4ED6D, 0xFF626B27, 0xFF420022, 0xFE4C3D22, 0xFF627D27, 0xFF69862B, 0xFF69862B, 0xFF69862B, 0xFF83BC22, 0xFF97D227, 0xFFC9EA4C, 0xFF8CC92B, 0xFE4A3B1C, 0xFF38001C, 0xFF5D542B, 0xFF80B122, 0xFF8CC92B, 
        0xFF97C335, 0xFF98B427, 0xFF98B427, 0xFF85A42B, 0xFF83BC22, 0xFF97D227, 0xFF9AD646, 0xFFB6E45F, 0xFFADE12E, 0xFF87BA3B, 0xFF626B27, 0xFF574027, 0xFE4C3D22, 0xFF482222, 0xFF626B27, 0xFF6F7822, 0xFF9AD646, 0xFFB6E45F, 0xFE4C3D22, 0xFE4C3D22, 
        0xFF627D27, 0xFF69862B, 0xFF74A422, 0xFF74A422, 0xFF69862B, 0xFF74A422, 0xFF87BA3B, 0xFF97C335, 0xFFB6E45F, 0xFFB6E45F, 0xFF89A650, 0xFF626735, 0xFF5D542B, 0xFF574027, 0xFF655522, 0xFF574027, 0xFF655522, 0xFF604022, 0xFB554627, 0xFF5A3D22, 
        0xFF574027, 0xFF55322E, 0xFF5A3D22, 0xFE482B1C, 0xFF420022, 0xFF420022, 0xFF3D001C, 0xFF3B001C, 0xFF38001C, 0xFF3B001C, 0xFF3D001C, 0xFF3B001C, 0xFF420022, 0xFF4C1527, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF4C1527, 
        0xFF350015, 0xFF35001C, 0xFF5A001C, 0xA8000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA3000000, 0xA0000000, 0x9A000000, 0x93000000, 0x8C000000, 0x82000000, 0x77000000, 0x6E000000, 0x63000000, 0x58000000, 
        0x50150000, 0x49000000, 0x44000000, 0x3E000000, 0x3B000000, 0x3B000000, 0x3B000000, 0x3C000000, 0x42000000, 0x46000000, 0x4E000000, 0x58000000, 0x61150000, 0x6A000000, 0x74151500, 0x7A000000, 0x7E150000, 0x85150000, 0x85150000, 0x80151500, 
        0x7E151C00, 0x77150000, 0x6F150000, 0x6B151C00, 0x61150000, 0x58150000, 0x4C150000, 0x42000000, 0x37000000, 0x2F000000, 0x26000000, 0x1F000000, 0x1A000000, 0x15000000, 0x12000000, 0x10000000, 0x0E000000, 0x0C000000, 0x0A000000, 0x08000000, 
        0x06000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFB6E45F, 0xFE4C3D22, 0xFF420022, 0xFF46001C, 0xFF627D27, 0xFF627D27, 0xFF69862B, 0xFF69862B, 0xFF7E9A22, 0xFF97C335, 0xFEA8C346, 0xFFB6E45F, 0xFF69862B, 0xFE4A3B1C, 0xFE482B1C, 0xFF595422, 0xFF85A42B, 
        0xFF97D227, 0xFF97C335, 0xFF98B427, 0xFF98B427, 0xFF85A42B, 0xFF80B122, 0xFF8CC92B, 0xFF97D227, 0xFFB3E442, 0xFF9AD646, 0xFF606722, 0xFF4C3822, 0xFF4C3822, 0xFE482B1C, 0xFF626B27, 0xFF627D27, 0xFF7E9A22, 0xFFB6E45F, 0xFF9AD646, 0xFF595422, 
        0xFF595422, 0xFF606722, 0xFF69862B, 0xFF74A422, 0xFF7DAF2B, 0xFF74A422, 0xFF7E9A22, 0xFF74A422, 0xFF80B122, 0xFF97C335, 0xFFB6E45F, 0xFFB6E45F, 0xFF829544, 0xFF5D542B, 0xFF574027, 0xFE503227, 0xFF574027, 0xFF4C3822, 0xFF574027, 0xFF482222, 
        0xFF482222, 0xFF4C1527, 0xFE503227, 0xFF55322E, 0xFF400022, 0xFF46001C, 0xFF4C1527, 0xFF4C1527, 0xFF4C1527, 0xFF5A001C, 0xFF5A001C, 0xFF5A001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF4C1527, 
        0xFF38001C, 0xFF2E0015, 0xFF420022, 0xCB4A3822, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA4000000, 0xA0000000, 0x9C000000, 0x96000000, 0x8C000000, 0x82000000, 0x77000000, 0x6A000000, 0x5D150000, 0x51000000, 0x46000000, 
        0x3C000000, 0x36000000, 0x31000000, 0x2C000000, 0x29000000, 0x27000000, 0x29000000, 0x2C000000, 0x2F000000, 0x34000000, 0x3C000000, 0x44000000, 0x4E000000, 0x58000000, 0x61150000, 0x6A150000, 0x71000000, 0x74151500, 0x77150000, 0x74151500, 
        0x74151500, 0x6B151C00, 0x65150000, 0x5D150000, 0x54150000, 0x49000000, 0x3E000000, 0x34000000, 0x2A000000, 0x22000000, 0x1B000000, 0x15000000, 0x10000000, 0x0D000000, 0x0B000000, 0x09000000, 0x08000000, 0x07000000, 0x06000000, 0x04000000, 
        0x03000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF9AD646, 0xFF69862B, 0xFF46001C, 0xFE4C3D22, 0xFF74A422, 0xFF69862B, 0xFF69862B, 0xFF69862B, 0xFF69862B, 0xFF98B427, 0xFF98B427, 0xFEA8C346, 0xFF9AD646, 0xFF626B27, 0xFF595422, 0xFF4C3822, 0xFF574027, 
        0xFF7E9A22, 0xFF97C335, 0xFF97C335, 0xFF98B427, 0xFF98B427, 0xFF98B427, 0xFF7E9A22, 0xFF83BC22, 0xFF8CC92B, 0xFF9AD646, 0xFFB6E45F, 0xFF595422, 0xFF595422, 0xFF5D542B, 0xFF595422, 0xFF69862B, 0xFF626B27, 0xFF8CC92B, 0xFFB6E45F, 0xFF84AE4C, 
        0xFF5D542B, 0xFF626735, 0xFF595422, 0xFF69862B, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF69862B, 0xFF74A422, 0xFF80B122, 0xFF97C335, 0xFFB6E45F, 0xFF97B446, 0xFE4A3B1C, 0xFF420022, 0xFF3B001C, 0xFF46001C, 0xFF420022, 0xFF420022, 
        0xFF482222, 0xFF4C3822, 0xFF635248, 0xFE4C3D22, 0xFF482222, 0xFF3D001C, 0xFF46001C, 0xFF5A001C, 0xFF5A001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF5A001C, 0xFF4C1527, 
        0xFF3D001C, 0xFF2E0015, 0xFF3B001C, 0xE6502222, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA5000000, 0xA3000000, 0x9F000000, 0x99000000, 0x8F000000, 0x85150000, 0x77000000, 0x6A000000, 0x5B000000, 0x4E000000, 0x3F000000, 0x36000000, 
        0x2C000000, 0x26000000, 0x20000000, 0x1D000000, 0x1B000000, 0x1A000000, 0x1A000000, 0x1C000000, 0x1F000000, 0x25000000, 0x2C000000, 0x33000000, 0x3C000000, 0x46000000, 0x50150000, 0x58150000, 0x61150000, 0x65150000, 0x6A150000, 0x6B151C00, 
        0x6A150000, 0x61150000, 0x5D150000, 0x54150000, 0x4A000000, 0x3F000000, 0x34000000, 0x2A000000, 0x21000000, 0x19000000, 0x12000000, 0x0D000000, 0x0A000000, 0x07000000, 0x05000000, 0x04000000, 0x04000000, 0x03000000, 0x03000000, 0x02000000, 
        0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF74A422, 0xFF8FA435, 0xFF6F7822, 0xFF626B27, 0xFF7DAF2B, 0xFF83BC22, 0xFF69862B, 0xFF69862B, 0xFF69862B, 0xFF7E9A22, 0xFF80B122, 0xFF85A42B, 0xFF97B446, 0xFF7E9A22, 0xFF626B27, 0xFF606722, 0xFF626B27, 
        0xFF626B27, 0xFF727E3B, 0xFF97C335, 0xFF97C335, 0xFF98B427, 0xFF98B427, 0xFF98B427, 0xFF7E9A22, 0xFF80B122, 0xFF8CC92B, 0xFEA8C346, 0xFF9AD646, 0xFB554627, 0xFF574027, 0xFF595422, 0xFF69862B, 0xFF626B27, 0xFF7E9A22, 0xFF9AD646, 0xFFB6E45F, 
        0xFF627D27, 0xA8000000, 0xC8351500, 0xFB554627, 0xFF627D27, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF7E9A22, 0xFF80B122, 0xFF97C335, 0xFF9AD646, 0xFF9AD646, 0xFF595422, 0xEA3D1515, 0xEA3D1515, 0xEA3D1515, 0xEA3D1515, 
        0xCB4A3822, 0xA8000000, 0xA8000000, 0xA8000000, 0xFB554627, 0xFF400022, 0xFF400022, 0xFF4C1527, 0xFF5A001C, 0xFF5A001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF5A001C, 0xFF46001C, 
        0xFF3D0022, 0xFF35001C, 0xFF35001C, 0xFF55322E, 0xA8000000, 0xA8000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA2000000, 0x9D000000, 0x95000000, 0x8B150000, 0x7E150000, 0x6E000000, 0x5E000000, 0x4E000000, 0x3F000000, 0x32000000, 0x27000000, 
        0x1F000000, 0x19000000, 0x14000000, 0x11000000, 0x10000000, 0x0F000000, 0x0F000000, 0x11000000, 0x14000000, 0x18000000, 0x1D000000, 0x25000000, 0x2C000000, 0x36000000, 0x3F000000, 0x48000000, 0x50150000, 0x58150000, 0x5B150000, 0x5D150000, 
        0x5D150000, 0x5B150000, 0x54150000, 0x4C150000, 0x44000000, 0x39000000, 0x2F000000, 0x24000000, 0x1B000000, 0x13000000, 0x0D000000, 0x09000000, 0x06000000, 0x04000000, 0x02000000, 0x02000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF69862B, 0xFFA3B12E, 0xFFACC32E, 0xFF7E9A22, 0xFF7ECA27, 0xFF74A422, 0xFF626B27, 0xFF69862B, 0xFF69862B, 0xFF727E3B, 0xFF89A422, 0xFF7E9A22, 0xFF69862B, 0xFF69862B, 0xFF606722, 0xFF627D27, 0xFF83BC22, 
        0xFF7DAF2B, 0xFF606722, 0xFF6F7822, 0xFF80B122, 0xFF97C335, 0xFF97C335, 0xFF98B427, 0xFF8FA435, 0xFF7E9A22, 0xFF85A42B, 0xFF83BC22, 0xFEA8C346, 0xFF87BA3B, 0xFE4A3B1C, 0xFF574027, 0xFF69862B, 0xFF627D27, 0xFF626B27, 0xFF8CC92B, 0xFF9AD646, 
        0xFF9AD646, 0xCB4A3822, 0xA8000000, 0xA8000000, 0xFB554627, 0xFF626B27, 0xFF69862B, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF7E9A22, 0xFF7DAF2B, 0xFF97C335, 0xFF9AD646, 0xFF9AD646, 0xD65C672E, 0xA8000000, 0xA8000000, 0xA8000000, 
        0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xC8351500, 0xFE482B1C, 0xFF38001C, 0xFF46001C, 0xFF5A001C, 0xFF5A001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF4C1527, 0xFF3D001C, 
        0xFF3D001C, 0xFF400022, 0xFF35001C, 0xFF3D001C, 0xCB4A3822, 0xA8000000, 0xA7000000, 0xA6000000, 0xA4000000, 0xA0000000, 0x9A000000, 0x93000000, 0x86000000, 0x77000000, 0x67000000, 0x54000000, 0x44000000, 0x33000000, 0x26000000, 0x1C000000, 
        0x15000000, 0x0F000000, 0x0C000000, 0x0A000000, 0x08000000, 0x08000000, 0x08000000, 0x09000000, 0x0B000000, 0x0F000000, 0x13000000, 0x18000000, 0x1F000000, 0x27000000, 0x2F000000, 0x37000000, 0x3F000000, 0x46000000, 0x4C150000, 0x50150000, 
        0x50150000, 0x50150000, 0x4C150000, 0x46000000, 0x3F000000, 0x36000000, 0x2C000000, 0x22000000, 0x19000000, 0x11000000, 0x0B000000, 0x07000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF727E3B, 0xFFA3B12E, 0xFFACC32E, 0xFF87BA3B, 0xFF74A422, 0xFF4C3822, 0xFF595422, 0xFF69862B, 0xFF7E9A22, 0xFF69862B, 0xFF69862B, 0xFF627D27, 0xFF626B27, 0xFF626B27, 0xFF606722, 0xFF7DAF2B, 0xFF7ECA27, 
        0xFF7ECA27, 0xFF74A422, 0xFF606722, 0xFF606722, 0xFF89A422, 0xFF97C335, 0xFF97C335, 0xFF98B427, 0xFF98B427, 0xFF85A42B, 0xFF85A42B, 0xFF87BA3B, 0xFEA8C346, 0xFF74A422, 0xFE482B1C, 0xFF69862B, 0xFF69862B, 0xFF627D27, 0xFF7E9A22, 0xFF97D227, 
        0xFFB6E45F, 0xFF74A422, 0xA8000000, 0xA8000000, 0xA8000000, 0xC8351500, 0xFF595422, 0xFF69862B, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF7E9A22, 0xFF85A42B, 0xFF97C335, 0xFFB3E442, 0xFEA8C346, 0xD65C672E, 0xA8000000, 0xA8000000, 
        0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xC8351500, 0xFF3D001C, 0xFF38001C, 0xFF46001C, 0xFF4C1527, 0xFF5A001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF5A001C, 0xFF46001C, 0xFF3B001C, 
        0xFF3D001C, 0xFF420022, 0xFF2E0015, 0xFF350015, 0xE6502222, 0xA8000000, 0xA7000000, 0xA6000000, 0xA4000000, 0xA0000000, 0x99000000, 0x8F000000, 0x82000000, 0x71000000, 0x5E000000, 0x4C150000, 0x3B000000, 0x2C000000, 0x1D000000, 0x14000000, 
        0x0E000000, 0x09000000, 0x06000000, 0x05000000, 0x04000000, 0x04000000, 0x04000000, 0x05000000, 0x06000000, 0x08000000, 0x0B000000, 0x0F000000, 0x14000000, 0x1A000000, 0x21000000, 0x27000000, 0x2F000000, 0x36000000, 0x3C000000, 0x42000000, 
        0x44000000, 0x46000000, 0x46000000, 0x44000000, 0x3C000000, 0x34000000, 0x2C000000, 0x22000000, 0x19000000, 0x11000000, 0x0B000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF627D27, 0xFFA3B12E, 0xFFACC32E, 0xFFB9C32E, 0xFF69862B, 0xFD461C22, 0xFE482B1C, 0xFF626B27, 0xFF69862B, 0xFF69862B, 0xFF626B27, 0xFF626735, 0xFF595422, 0xFF595422, 0xFF7DAF2B, 0xFF7ECA27, 0xFF7ECA27, 
        0xFF97D227, 0xFFB3E442, 0xFF8CC92B, 0xFF626B27, 0xFF69862B, 0xFF6F7822, 0xFF7E9A22, 0xFEA8C346, 0xFFACC32E, 0xFFACC32E, 0xFF98B427, 0xFF7E9A22, 0xFF80B122, 0xFF97C335, 0xFF74A422, 0xFF627D27, 0xFF69862B, 0xFF69862B, 0xFF69862B, 0xFF97C335, 
        0xFF97D227, 0xFFB6E45F, 0xD65C672E, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xC8351500, 0xFF595422, 0xFF69862B, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF7E9A22, 0xFF97C335, 0xFFBAE42E, 0xFF9AD646, 0xD65C672E, 0xA8000000, 
        0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xEA3D1515, 0xFF3B001C, 0xFF35001C, 0xFF3B001C, 0xFF420022, 0xFF4C1527, 0xFF5A001C, 0xFF5A001C, 0xFF5A001C, 0xFF5A001C, 0xFF4C1527, 0xFF46001C, 0xFF3D001C, 0xFF38001C, 
        0xFF38001C, 0xFF420022, 0xFF3B001C, 0xFF35001C, 0xFF55322E, 0xA8000000, 0xA7000000, 0xA6000000, 0xA3000000, 0x9F000000, 0x98000000, 0x8C000000, 0x7F000000, 0x6E000000, 0x5B000000, 0x46000000, 0x34000000, 0x25000000, 0x18000000, 0x0F000000, 
        0x09000000, 0x05000000, 0x03000000, 0x02000000, 0x01000000, 0x01000000, 0x01000000, 0x02000000, 0x03000000, 0x04000000, 0x06000000, 0x09000000, 0x0C000000, 0x11000000, 0x16000000, 0x1B000000, 0x21000000, 0x27000000, 0x2F000000, 0x34000000, 
        0x3B000000, 0x3C000000, 0x3E000000, 0x3C000000, 0x39000000, 0x33000000, 0x2C000000, 0x22000000, 0x19000000, 0x11000000, 0x0B000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF69862B, 0xFF8FA435, 0xFFD4E62E, 0xFFC8E42E, 0xFEA8C346, 0xFF4C3822, 0xFF4C3822, 0xFF574027, 0xFF69862B, 0xFF69862B, 0xFF595422, 0xFF595422, 0xFE4C3D22, 0xFF7E9A22, 0xFF7ECA27, 0xFF7ECA27, 0xFFADE12E, 
        0xFFB3E442, 0xFFC9EA4C, 0xFFB3E442, 0xFF87BA3B, 0xFF829544, 0xFE482B1C, 0xFE482B1C, 0xFF757522, 0xFF98B427, 0xFFACC32E, 0xFFB9C32E, 0xFFA3B12E, 0xFF7E9A22, 0xFF80B122, 0xFF97C335, 0xFF7E9A22, 0xFF69862B, 0xFF69862B, 0xFF69862B, 0xFF7E9A22, 
        0xFF97D227, 0xFF9AD646, 0xFF97C335, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xE6502222, 0xFF606722, 0xFF69862B, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF7E9A22, 0xFF98B427, 0xFFBAE42E, 0xFF97C335, 0xCB4A3822, 
        0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xFE482B1C, 0xFF38001C, 0xFF38001C, 0xFF35001C, 0xFF35001C, 0xFF3B001C, 0xFF420022, 0xFF46001C, 0xFF46001C, 0xFF3B001C, 0xFF3B001C, 0xFF38001C, 0xFF38001C, 
        0xFF38001C, 0xFF3D001C, 0xFF48002B, 0xFF35001C, 0xFF420022, 0xCB4A3822, 0xA7000000, 0xA6000000, 0xA3000000, 0x9F000000, 0x96000000, 0x8C000000, 0x7E150000, 0x6B151500, 0x58000000, 0x44000000, 0x32000000, 0x22000000, 0x15000000, 0x0D000000, 
        0x07000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x03000000, 0x04000000, 0x07000000, 0x0A000000, 0x0D000000, 0x11000000, 0x16000000, 0x1C000000, 0x22000000, 0x27000000, 
        0x2F000000, 0x33000000, 0x36000000, 0x36000000, 0x34000000, 0x31000000, 0x29000000, 0x22000000, 0x19000000, 0x12000000, 0x0B000000, 0x07000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF69862B, 0xFF7E9A22, 0xFFB9C32E, 0xFFC8E42E, 0xFFC9EA4C, 0xFF595422, 0xFF4C3822, 0xFE503227, 0xFF626735, 0xFF626B27, 0xFF5D542B, 0xFE4C3D22, 0xFF6F7822, 0xFF7ECA27, 0xFF7ECA27, 0xFF9AD646, 0xFFBAE42E, 
        0xFFC9EA4C, 0xFFC9EA4C, 0xFFD4ED6D, 0xFF89A650, 0xC8351500, 0xA8000000, 0xA8000000, 0xFE4A3B1C, 0xFF595422, 0xFF7F7B42, 0xFFACC32E, 0xFFB9C32E, 0xFFACC32E, 0xFF85A42B, 0xFF85A42B, 0xFF97C335, 0xFF74A422, 0xFF69862B, 0xFF69862B, 0xFF627D27, 
        0xFF98B427, 0xFF97D227, 0xFFB6E45F, 0xD65C672E, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xE4553B2B, 0xFF626B27, 0xFF85A42B, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF74A422, 0xFF98B427, 0xFFBAE42E, 0xFF74A422, 
        0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xC8351500, 0xFF400022, 0xFF38001C, 0xFF38001C, 0xFF35001C, 0xFF35001C, 0xFF350022, 0xFF35001C, 0xFF3B001C, 0xFF3B001C, 0xFF3B001C, 0xFF35001C, 0xFF38001C, 
        0xFF3D001C, 0xFF3D001C, 0xFF46001C, 0xFF350015, 0xFF38001C, 0xE6502222, 0xA7000000, 0xA6000000, 0xA3000000, 0x9F000000, 0x98000000, 0x8C000000, 0x7E150000, 0x6B151500, 0x58000000, 0x44000000, 0x31000000, 0x21000000, 0x14000000, 0x0B000000, 
        0x06000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x03000000, 0x05000000, 0x07000000, 0x0A000000, 0x0E000000, 0x12000000, 0x18000000, 0x1D000000, 
        0x23000000, 0x27000000, 0x2C000000, 0x2F000000, 0x2F000000, 0x2C000000, 0x26000000, 0x20000000, 0x18000000, 0x11000000, 0x0B000000, 0x07000000, 0x04000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF69862B, 0xFF74A422, 0xFFA3B12E, 0xFFC8E42E, 0xFFC8E42E, 0xFF85A42B, 0xFF4C3822, 0xFE482B1C, 0xFF4C3822, 0xFF5D542B, 0xFE4C3D22, 0xFF595422, 0xFF83BC22, 0xFF7ECA27, 0xFFADE12E, 0xFFBAE42E, 0xFFC9EA4C, 
        0xFFC9EA4C, 0xFFD4ED6D, 0xFF87994C, 0xC8351500, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xC8351500, 0xFD461C22, 0xFF595422, 0xFF7E9A22, 0xFFACC32E, 0xFFADE12E, 0xFF87BA3B, 0xFF80B122, 0xFF97C335, 0xFF74A422, 0xFF69862B, 0xFF69862B, 
        0xFF7E9A22, 0xFF97C335, 0xFEA8C346, 0xFF97B446, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA6000000, 0xFB554627, 0xFF6F7822, 0xFF7E9A22, 0xFF7DAF2B, 0xFF74A422, 0xFF98B427, 0xFFADE12E, 
        0xFF69862B, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA6000000, 0xFE482B1C, 0xFF38001C, 0xFF3B001C, 0xFF35001C, 0xFF38001C, 0xFF35001C, 0xFF35001C, 0xFF35001C, 0xFF3B001C, 0xFF38001C, 0xFF35001C, 0xFF3D001C, 
        0xFF38001C, 0xFF3D001C, 0xFF420022, 0xFF3B001C, 0xFF2E0015, 0xFF5F3B38, 0xA7000000, 0xA6000000, 0xA4000000, 0x9F000000, 0x98000000, 0x8F000000, 0x7F000000, 0x6E000000, 0x5B000000, 0x44000000, 0x32000000, 0x21000000, 0x15000000, 0x0C000000, 
        0x06000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x02000000, 0x04000000, 0x06000000, 0x08000000, 0x0B000000, 0x0F000000, 0x14000000, 
        0x19000000, 0x1D000000, 0x22000000, 0x25000000, 0x26000000, 0x25000000, 0x21000000, 0x1C000000, 0x16000000, 0x10000000, 0x0B000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF7E9A22, 0xFF7DAF2B, 0xFF7E9A22, 0xFFB9C32E, 0xFFC8E42E, 0xFEA8C346, 0xFF4C3822, 0xFE482B1C, 0xFE482B1C, 0xFF4C3822, 0xFF4C3822, 0xFF74A422, 0xFF7ECA27, 0xFFADE12E, 0xFFBAE42E, 0xFFC9EA4C, 0xFFD4ED6D, 
        0xFFB6E45F, 0xFF727E3B, 0xC8351500, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xC8351500, 0xFE482B1C, 0xFF5D542B, 0xFF7E9A22, 0xFEA8C346, 0xFF97D227, 0xFF83BC22, 0xFF8CC92B, 0xFF7E9A22, 0xFF69862B, 
        0xFF69862B, 0xFF97C335, 0xFF97C335, 0xFFB6E45F, 0xE4553B2B, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA5000000, 0xA4000000, 0xC8351500, 0xFF606722, 0xFF69862B, 0xFF7DAF2B, 0xFF74A422, 0xFF97C335, 
        0xFF97C335, 0xCB4A3822, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA5000000, 0xA3000000, 0xFE482B1C, 0xFF38001C, 0xFF3D0022, 0xFF38001C, 0xFF38001C, 0xFF38001C, 0xFF350022, 0xFF3B001C, 0xFF3B001C, 0xFF38001C, 0xFF3D001C, 
        0xFF400022, 0xFF3D001C, 0xFF420022, 0xFF420022, 0xFF350015, 0xFF46001C, 0xCB4A3822, 0xA6000000, 0xA4000000, 0xA0000000, 0x99000000, 0x8F000000, 0x82000000, 0x71000000, 0x5B000000, 0x48000000, 0x34000000, 0x23000000, 0x16000000, 0x0D000000, 
        0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x03000000, 0x04000000, 0x07000000, 0x09000000, 0x0D000000, 
        0x11000000, 0x15000000, 0x19000000, 0x1C000000, 0x1D000000, 0x1D000000, 0x1B000000, 0x17000000, 0x13000000, 0x0E000000, 0x09000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF7E9A22, 0xFF83BC22, 0xFF7DAF2B, 0xFFA3B12E, 0xFFB9C32E, 0xFFB6E45F, 0xFB554627, 0xFE503227, 0xFF4C3822, 0xFF574027, 0xFF74A422, 0xFF7ECA27, 0xFFB3E442, 0xFFB3E442, 0xFFD4ED6D, 0xFFD4ED6D, 0xFFD4ED6D, 
        0xFF626B27, 0xA5000000, 0xA7000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xC8351500, 0xFE482B1C, 0xFF574027, 0xFF727E3B, 0xFF87BA3B, 0xFF83BC22, 0xFF83BC22, 0xFF7E9A22, 
        0xFF69862B, 0xFF85A42B, 0xFF97C335, 0xFFB9C32E, 0xFF87BA3B, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA4000000, 0xA3000000, 0xA2000000, 0xA0000000, 0xA0000000, 0xC8351500, 0xFF626B27, 0xFF74A422, 0xFF74A422, 
        0xFF97C335, 0xFF80B122, 0xA6000000, 0xA6000000, 0xA6000000, 0xA5000000, 0xA4000000, 0xA2000000, 0xA0000000, 0xEA3D1515, 0xFF3B001C, 0xFF3D001C, 0xFF38001C, 0xFF3D001C, 0xFF38001C, 0xFF350015, 0xFF35001C, 0xFF400015, 0xFF38001C, 0xFF400022, 
        0xFF3D001C, 0xFF3D0022, 0xFF3B001C, 0xFF46001C, 0xFF35001C, 0xFF380015, 0xE6502222, 0xA6000000, 0xA4000000, 0xA0000000, 0x9A000000, 0x91000000, 0x85150000, 0x74000000, 0x61150000, 0x4A000000, 0x37000000, 0x26000000, 0x18000000, 0x0E000000, 
        0x07000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x03000000, 0x05000000, 0x08000000, 
        0x0B000000, 0x0E000000, 0x11000000, 0x13000000, 0x15000000, 0x15000000, 0x14000000, 0x12000000, 0x0E000000, 0x0B000000, 0x07000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF606722, 0xFF80B122, 0xFF7DAF2B, 0xFF98B427, 0xFFC8E42E, 0xFFC8E42E, 0xFF595422, 0xFF4C3822, 0xFF4C3822, 0xFF626B27, 0xFF7ECA27, 0xFFADE12E, 0xFFC9EA4C, 0xFFD4ED6D, 0xFFC9EA4C, 0xFFBAE42E, 0xFFC9EA4C, 
        0xFF87BA3B, 0xA5000000, 0xA7000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xC8351500, 0xFD461C22, 0xFF595422, 0xFF69862B, 0xFF74A422, 0xFF87BA3B, 
        0xFF829544, 0xFF727E3B, 0xFF98B427, 0xFFA3B12E, 0xFEA8C346, 0xC8351500, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA4000000, 0xA2000000, 0xA0000000, 0x9D000000, 0x9D000000, 0x9D000000, 0x9D000000, 0x9D000000, 0xD65C672E, 0xFF7E9A22, 
        0xFF74A422, 0xFF97C335, 0xFF627D27, 0xA5000000, 0xA5000000, 0xA4000000, 0xA2000000, 0x9F000000, 0x9C000000, 0x98000000, 0xFD461C22, 0xFF38001C, 0xFF420022, 0xFF3D0015, 0xFF38001C, 0xFF35001C, 0xFF350015, 0xFF3D001C, 0xFF3D001C, 0xFF3D0022, 
        0xFF3D001C, 0xFF3D001C, 0xFF3B001C, 0xFF46001C, 0xFF3D0022, 0xFF3B001C, 0xFF5A3D22, 0xA7000000, 0xA5000000, 0xA2000000, 0x9C000000, 0x93000000, 0x86000000, 0x77000000, 0x63000000, 0x4E000000, 0x3C000000, 0x2A000000, 0x1B000000, 0x10000000, 
        0x09000000, 0x04000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x02000000, 0x04000000, 
        0x06000000, 0x08000000, 0x0A000000, 0x0C000000, 0x0E000000, 0x0E000000, 0x0E000000, 0x0C000000, 0x0A000000, 0x08000000, 0x05000000, 0x03000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x74404022, 0xFF7E9A22, 0xFF83BC22, 0xFF85A42B, 0xFFB9C32E, 0xFFC8E42E, 0xFF627D27, 0xFF4C3822, 0xFF574027, 0xFF74A422, 0xFFADE12E, 0xFFC9EA4C, 0xFFD4ED6D, 0xFFB6E45F, 0xFF98B427, 0xFFACC32E, 0xFFB3E442, 
        0xFFB6E45F, 0xA5000000, 0xA7000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xEA3D1515, 0xFE4C3D22, 0xFF626B27, 
        0xFF7E9A22, 0xFF6F7822, 0xFF8FA435, 0xFFA3B12E, 0xFFB9C32E, 0xD65C672E, 0xA7000000, 0xA6000000, 0xA5000000, 0xA4000000, 0xA2000000, 0x9F000000, 0x9C000000, 0x9A000000, 0x98000000, 0x97151500, 0x97151500, 0x98000000, 0x9A000000, 0xCB4A3822, 
        0xFF7E9A22, 0xFF80B122, 0xFF85A42B, 0xCB4A3822, 0xA2000000, 0xA0000000, 0x9F000000, 0x9A000000, 0x97151500, 0x91000000, 0x8B150000, 0xFF3B151C, 0xFF3B001C, 0xFF38001C, 0xFF38001C, 0xFF350022, 0xFF35001C, 0xFF38001C, 0xFF3D001C, 0xFF3D0022, 
        0xFF3D0015, 0xFF420022, 0xFF3D001C, 0xFF46001C, 0xFF48002B, 0xFF35001C, 0xFF46001C, 0xCB4A3822, 0xA5000000, 0xA2000000, 0x9D000000, 0x95000000, 0x8A000000, 0x7C000000, 0x67000000, 0x54000000, 0x3F000000, 0x2F000000, 0x1F000000, 0x13000000, 
        0x0A000000, 0x05000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 
        0x03000000, 0x04000000, 0x06000000, 0x07000000, 0x08000000, 0x09000000, 0x09000000, 0x08000000, 0x07000000, 0x05000000, 0x03000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0xFF6F7822, 0xFF83BC22, 0xFF74A422, 0xFFB9C32E, 0xFFC8E42E, 0xFF627D27, 0xFF4C3822, 0xFF626B27, 0xFF97D227, 0xFFC9EA4C, 0xFFC9EA4C, 0xFF89A650, 0xFF98B427, 0xFF98B427, 0xFF98B427, 0xFFBAE42E, 
        0xFFD4ED6D, 0xD65C672E, 0xA7000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA6000000, 0xA5000000, 0xA5000000, 0xA5000000, 0xFF574027, 0xFF626735, 
        0xFF626B27, 0xFF69862B, 0xFF8E8140, 0xFFA3B12E, 0xFFA3B12E, 0xFF69862B, 0xA7000000, 0xA6000000, 0xA5000000, 0xA3000000, 0xA0000000, 0x9C000000, 0x97151500, 0x93000000, 0x91000000, 0x8F150000, 0x8F150000, 0x8F150000, 0x93000000, 0x95000000, 
        0xE4553B2B, 0xFF7E9A22, 0xFF87BA3B, 0xFF626B27, 0x9F000000, 0x9D000000, 0x9A000000, 0x97151500, 0x8F150000, 0x8A000000, 0x82000000, 0xFD461C22, 0xFF38001C, 0xFF3D001C, 0xFF38001C, 0xFF35001C, 0xFF38001C, 0xFF35001C, 0xFF3D001C, 0xFF46001C, 
        0xFF3D001C, 0xFF3D001C, 0xFF400015, 0xFF400022, 0xFF46001C, 0xFF38001C, 0xFF3D001C, 0xE6502222, 0xA6000000, 0xA3000000, 0x9F000000, 0x98000000, 0x8C000000, 0x7F000000, 0x6E000000, 0x5B000000, 0x46000000, 0x33000000, 0x23000000, 0x16000000, 
        0x0C000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 
        0x01000000, 0x02000000, 0x03000000, 0x04000000, 0x04000000, 0x05000000, 0x05000000, 0x04000000, 0x04000000, 0x03000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0xCB4A3822, 0xFF7DAF2B, 0xFF83BC22, 0xFFACC32E, 0xFFC8E42E, 0xFF627D27, 0xFB554627, 0xFF87BA3B, 0xFFC9EA4C, 0xFFB6E45F, 0xFF626735, 0xCB4A3822, 0xFF7D7522, 0xFF98B427, 0xFF8FA435, 0xFFACC32E, 
        0xFFC9EA4C, 0xFF87BA3B, 0xA7000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA4000000, 0xA3000000, 0xA3000000, 0xA2000000, 0xA0000000, 0xC8351500, 0xFF757522, 
        0xFF829544, 0xFF829544, 0xFF7D7522, 0xFF8FA435, 0xFFA3B12E, 0xFF87994C, 0xA6000000, 0xA6000000, 0xA4000000, 0xA2000000, 0x9D000000, 0x99000000, 0x93000000, 0x8F150000, 0x8B150000, 0x85150000, 0x85150000, 0x85150000, 0x86000000, 0x8B150000, 
        0x8F000000, 0xE4553B2B, 0xFF7E9A22, 0xFF74A422, 0x9A000000, 0x99000000, 0x97151500, 0x91000000, 0x8B150000, 0x80151500, 0x77150000, 0xA8000000, 0xFF3D001C, 0xFF3D001C, 0xFF3D001C, 0xFF3B001C, 0xFF38001C, 0xFF35001C, 0xFF350015, 0xFF420022, 
        0xFF420022, 0xFF420022, 0xFF420022, 0xFF420022, 0xFF46001C, 0xFF420022, 0xFF3B001C, 0xFF604022, 0xA6000000, 0xA4000000, 0xA0000000, 0x9A000000, 0x8F000000, 0x82000000, 0x74000000, 0x5E000000, 0x4A000000, 0x37000000, 0x27000000, 0x19000000, 
        0x0F000000, 0x08000000, 0x04000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x01000000, 0x01000000, 0x02000000, 0x02000000, 0x02000000, 0x02000000, 0x02000000, 0x02000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0xFF69862B, 0xFF83BC22, 0xFF98B427, 0xFFC8E42E, 0xFF627D27, 0xFF69862B, 0xFFC9EA4C, 0xFF97B446, 0xFB554627, 0x49000000, 0x5E000000, 0xA8000000, 0xFF626B27, 0xFF80B122, 0xFF8FA435, 
        0xFFADE12E, 0xFEA8C346, 0xA7000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA3000000, 0xA2000000, 0xA0000000, 0x9D000000, 0x9D000000, 0x9C000000, 0x9C000000, 0xFF655522, 
        0xFF7E9A22, 0xFF829544, 0xFF6F7822, 0xFF829544, 0xFFA3B12E, 0xFF97B446, 0xA5000000, 0xA5000000, 0xA4000000, 0xA0000000, 0x9D000000, 0x97151500, 0x8F150000, 0x8A000000, 0x82000000, 0x7E150000, 0x7A000000, 0x7A000000, 0x7C000000, 0x7E150000, 
        0x82000000, 0x86000000, 0xC8351500, 0xFF7E9A22, 0x93000000, 0x93000000, 0x91000000, 0x8B150000, 0x82000000, 0x7A000000, 0x6F150000, 0x65150000, 0xA3000000, 0xFF3B151C, 0xFF400022, 0xFF3D0022, 0xFF35001C, 0xFF38001C, 0xFF35001C, 0xFF400022, 
        0xFF400015, 0xFF420022, 0xFF400015, 0xFF46001C, 0xFF46001C, 0xFF420022, 0xFF3B001C, 0xFF46001C, 0xCB4A3822, 0xA5000000, 0xA0000000, 0x9C000000, 0x93000000, 0x86000000, 0x77000000, 0x65150000, 0x51000000, 0x3E000000, 0x2C000000, 0x1D000000, 
        0x12000000, 0x0A000000, 0x05000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0xFF606722, 0xFF83BC22, 0xFF98B427, 0xFFBAE42E, 0xFF626B27, 0xFF97C335, 0xFF829544, 0x80151500, 0x34000000, 0x49000000, 0x5E000000, 0x71000000, 0xC8351500, 0xFF727E3B, 0xFF85A42B, 
        0xFFACC32E, 0xFFB6E45F, 0xE4553B2B, 0xA7000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA4000000, 0xA3000000, 0xA0000000, 0x9D000000, 0x9A000000, 0x96000000, 0x95000000, 0x93000000, 0x93000000, 0xC8351500, 
        0xFF7D7522, 0xFF7E9A22, 0xFF727E3B, 0xFF829544, 0xFFA3B12E, 0xFFA3B12E, 0xE4553B2B, 0xA3000000, 0xA2000000, 0xA0000000, 0x9C000000, 0x95000000, 0x8F150000, 0x85150000, 0x7E151C00, 0x74151500, 0x6F150000, 0x6E000000, 0x6E000000, 0x71000000, 
        0x74000000, 0x7C000000, 0x80151500, 0x85150000, 0x8B150000, 0x8B150000, 0x8B150000, 0x85150000, 0x7E151C00, 0x74151500, 0x6B151C00, 0x5D150000, 0x54150000, 0xC8351500, 0xFF3D001C, 0xFF420022, 0xFF38001C, 0xFF38001C, 0xFF350015, 0xFF38001C, 
        0xFF46001C, 0xFF46001C, 0xFF46001C, 0xFF400015, 0xFF46001C, 0xFF46001C, 0xFF3B001C, 0xFF3B001C, 0xE4553B2B, 0xA5000000, 0xA3000000, 0x9D000000, 0x96000000, 0x8B150000, 0x7C000000, 0x6A000000, 0x58000000, 0x44000000, 0x32000000, 0x22000000, 
        0x15000000, 0x0C000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0xCB4A3822, 0xFF7DAF2B, 0xFF98B427, 0xFFADE12E, 0xFF626B27, 0xFF727E3B, 0x77150000, 0x23000000, 0x34000000, 0x49000000, 0x5E000000, 0x71000000, 0x82000000, 0xFB554627, 0xFF7E9A22, 
        0xFF98B427, 0xFFC9EA4C, 0xD65C672E, 0xA7000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA3000000, 0x9F000000, 0x9A000000, 0x96000000, 0x93000000, 0x8C000000, 0x8A000000, 0x86000000, 0x86000000, 0x8A000000, 
        0xFF655522, 0xFF7E9A22, 0xFF829544, 0xFF8E8140, 0xFF8FA435, 0xFFA3B12E, 0xE4553B2B, 0xA0000000, 0xA0000000, 0x9F000000, 0x9A000000, 0x93000000, 0x8B150000, 0x80151500, 0x77150000, 0x6F150000, 0x67000000, 0x61150000, 0x61150000, 0x61150000, 
        0x67000000, 0x6A000000, 0x71000000, 0x7A000000, 0x7E150000, 0x80151500, 0x80151500, 0x7E151C00, 0x7A000000, 0x6F150000, 0x65150000, 0x58150000, 0x50150000, 0x46000000, 0xFD461C22, 0xFF3D001C, 0xFF3B001C, 0xFF3B001C, 0xFF38001C, 0xFF2E0015, 
        0xFF46001C, 0xFF420022, 0xFF420022, 0xFF46001C, 0xFF46001C, 0xFF46001C, 0xFF3B001C, 0xFF3B001C, 0xFF5A3D22, 0xA6000000, 0xA4000000, 0xA0000000, 0x99000000, 0x8F000000, 0x82000000, 0x71000000, 0x5E000000, 0x4A000000, 0x37000000, 0x27000000, 
        0x19000000, 0x0F000000, 0x08000000, 0x04000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xFF7E9A22, 0xFF97C335, 0xFF97D227, 0xEA3D1515, 0x0C000000, 0x16000000, 0x23000000, 0x34000000, 0x48000000, 0x5D150000, 0x71000000, 0x82000000, 0x91000000, 0xFF6F5A22, 
        0xFF8FA435, 0xFFB6E45F, 0xFF74A422, 0xA7000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA3000000, 0xA0000000, 0x9A000000, 0x96000000, 0x8F000000, 0x86000000, 0x82000000, 0x7C000000, 0x7A000000, 0x77000000, 0x7A000000, 
        0xA8000000, 0xFF7D7522, 0xFF7E9A22, 0xFF7D7522, 0xFF8FA435, 0xFFA3B12E, 0xD65C672E, 0x9C000000, 0x9D000000, 0x9D000000, 0x99000000, 0x93000000, 0x8B150000, 0x80151500, 0x74151500, 0x6B151C00, 0x61150000, 0x58150000, 0x54000000, 0x54000000, 
        0x54000000, 0x5B000000, 0x63000000, 0x6A000000, 0x71000000, 0x74151500, 0x77150000, 0x77150000, 0x74151500, 0x6B151C00, 0x61150000, 0x58150000, 0x4C150000, 0x44000000, 0xC8351500, 0xFF3D001C, 0xFF46001C, 0xFF3B001C, 0xFF38001C, 0xFF2E0015, 
        0xFF3D001C, 0xFF46001C, 0xFF48002B, 0xFF46001C, 0xFF420022, 0xFF420022, 0xFF46001C, 0xFF38001C, 0xFF55322E, 0xA6000000, 0xA5000000, 0xA0000000, 0x9C000000, 0x93000000, 0x86000000, 0x77000000, 0x65150000, 0x51000000, 0x3E000000, 0x2C000000, 
        0x1D000000, 0x12000000, 0x0A000000, 0x05000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xFF7E9A22, 0xFF97C335, 0xFF85A42B, 0x06000000, 0x0C000000, 0x16000000, 0x23000000, 0x34000000, 0x48000000, 0x5D150000, 0x71000000, 0x82000000, 0x8F000000, 0xC8351500, 
        0xFF7D7522, 0xFFA3B12E, 0xFF84AE4C, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA4000000, 0xA0000000, 0x9D000000, 0x96000000, 0x8F000000, 0x85150000, 0x7C000000, 0x74000000, 0x6B151500, 0x67000000, 0x67000000, 0x67000000, 
        0x6B151500, 0xFB554627, 0xFF8E8140, 0xFF7D7522, 0xFF8FA435, 0xFFA3B12E, 0xD65C672E, 0x96000000, 0x98000000, 0x99000000, 0x98000000, 0x93000000, 0x8B150000, 0x80151500, 0x74151500, 0x67000000, 0x5D150000, 0x51000000, 0x4A000000, 0x46000000, 
        0x46000000, 0x4A000000, 0x50150000, 0x58000000, 0x61150000, 0x65150000, 0x6B151500, 0x6B151C00, 0x6B151C00, 0x67000000, 0x61150000, 0x58150000, 0x4C150000, 0x42000000, 0x3B000000, 0xFE482B1C, 0xFF3D001C, 0xFF3D001C, 0xFF3D001C, 0xFF35001C, 
        0xFF2E0015, 0xFF3D001C, 0xFF46001C, 0xFF46001C, 0xFF46001C, 0xFF420022, 0xFF4C1527, 0xFF3D001C, 0xFF400015, 0xCB4A3822, 0xA5000000, 0xA3000000, 0x9D000000, 0x96000000, 0x8B150000, 0x7C000000, 0x6A000000, 0x58000000, 0x44000000, 0x31000000, 
        0x22000000, 0x15000000, 0x0C000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xFF69862B, 0xFF97C335, 0xFF595422, 0x06000000, 0x0C000000, 0x15000000, 0x22000000, 0x33000000, 0x46000000, 0x5B000000, 0x71000000, 0x82000000, 0x8F000000, 0x99000000, 
        0xE6502222, 0xFF8FA435, 0xFF97B446, 0xA7000000, 0xA7000000, 0xA6000000, 0xA6000000, 0xA4000000, 0xA2000000, 0x9D000000, 0x98000000, 0x91000000, 0x86000000, 0x7C000000, 0x6F150000, 0x63000000, 0x5B000000, 0x54000000, 0x54000000, 0x54000000, 
        0x58000000, 0x61150000, 0xFF7D7522, 0xFF7F7B42, 0xFF8FA435, 0xFF8FA435, 0xE4553B2B, 0x8C000000, 0x91000000, 0x93000000, 0x93000000, 0x93000000, 0x8B150000, 0x82000000, 0x77150000, 0x6B151C00, 0x5B150000, 0x4E000000, 0x44000000, 0x3C000000, 
        0x3B000000, 0x3B000000, 0x3F000000, 0x46000000, 0x4E000000, 0x58150000, 0x5D150000, 0x61150000, 0x63000000, 0x61150000, 0x5D150000, 0x54150000, 0x4C150000, 0x42000000, 0x3B000000, 0xC8351500, 0xFF3B001C, 0xFF3B001C, 0xFF3D001C, 0xFF38001C, 
        0xFF35001C, 0xFF380015, 0xFF46001C, 0xFF4C1527, 0xFF4C1527, 0xFF420022, 0xFF46001C, 0xFF46001C, 0xFF3D001C, 0xE6502222, 0xA6000000, 0xA4000000, 0xA0000000, 0x99000000, 0x8F000000, 0x82000000, 0x71000000, 0x5E000000, 0x4A000000, 0x37000000, 
        0x26000000, 0x19000000, 0x0F000000, 0x08000000, 0x04000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xFF7E9A22, 0xFF85A42B, 0xEA3D1515, 0x05000000, 0x0B000000, 0x14000000, 0x21000000, 0x31000000, 0x44000000, 0x5B000000, 0x6E000000, 0x7F000000, 0x8F000000, 0x98000000, 
        0x9F000000, 0xFF896D22, 0xFF97B446, 0xA5000000, 0xA5000000, 0xA5000000, 0xA4000000, 0xA2000000, 0x9F000000, 0x9A000000, 0x93000000, 0x8B150000, 0x7F000000, 0x71000000, 0x63000000, 0x54000000, 0x4C150000, 0x44000000, 0x42000000, 0x42000000, 
        0x46000000, 0x4C150000, 0xFF757522, 0xFF829544, 0xFF8FA435, 0xFF89A650, 0x77000000, 0x7F000000, 0x86000000, 0x8C000000, 0x8F000000, 0x8F000000, 0x8B150000, 0x85150000, 0x7A000000, 0x6B151C00, 0x5D150000, 0x4C150000, 0x3F000000, 0x36000000, 
        0x31000000, 0x2F000000, 0x31000000, 0x36000000, 0x3C000000, 0x44000000, 0x4E000000, 0x54000000, 0x58150000, 0x58150000, 0x58150000, 0x54150000, 0x4C150000, 0x44000000, 0x3B000000, 0x34000000, 0xEA3D1515, 0xFF3B001C, 0xFF420022, 0xFF38001C, 
        0xFF38001C, 0xFF3D001C, 0xFF420022, 0xFF4C1527, 0xFF4C1527, 0xFF420022, 0xFF46001C, 0xFF4C1527, 0xFF400022, 0xEA3D1515, 0xA6000000, 0xA4000000, 0xA0000000, 0x9A000000, 0x93000000, 0x86000000, 0x77000000, 0x65150000, 0x51000000, 0x3E000000, 
        0x2C000000, 0x1D000000, 0x12000000, 0x0A000000, 0x05000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xFF7E9A22, 0xFF626B27, 0x02000000, 0x05000000, 0x0A000000, 0x13000000, 0x1F000000, 0x2F000000, 0x42000000, 0x58000000, 0x6A000000, 0x7C000000, 0x8B150000, 0x96000000, 
        0x9D000000, 0xE6502222, 0xFF727E3B, 0xA3000000, 0xA3000000, 0xA0000000, 0xA0000000, 0x9D000000, 0x9A000000, 0x96000000, 0x8F150000, 0x85150000, 0x77150000, 0x67000000, 0x58150000, 0x4A000000, 0x3E000000, 0x36000000, 0x31000000, 0x31000000, 
        0x34000000, 0x3B000000, 0xCB4A3822, 0xFF829544, 0xFF8FA435, 0xFF69862B, 0x67000000, 0x71000000, 0x7A000000, 0x82000000, 0x86000000, 0x8B150000, 0x8B150000, 0x85150000, 0x7C000000, 0x6F150000, 0x5D150000, 0x4E000000, 0x3E000000, 0x32000000, 
        0x29000000, 0x25000000, 0x25000000, 0x27000000, 0x2F000000, 0x34000000, 0x3C000000, 0x44000000, 0x4A000000, 0x4E000000, 0x50150000, 0x4E000000, 0x4A000000, 0x44000000, 0x3B000000, 0x34000000, 0x8B150000, 0xFF3B001C, 0xFF3D001C, 0xFF400022, 
        0xFF38001C, 0xFF46001C, 0xFF48002B, 0xFF420022, 0xFF4C1527, 0xFF482222, 0xFF3D001C, 0xFF48002B, 0xFF3D001C, 0xEA3D1515, 0xA6000000, 0xA5000000, 0xA2000000, 0x9D000000, 0x96000000, 0x8B150000, 0x7C000000, 0x6A000000, 0x58000000, 0x44000000, 
        0x31000000, 0x22000000, 0x15000000, 0x0C000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xFF727E3B, 0xC8351500, 0x02000000, 0x04000000, 0x09000000, 0x12000000, 0x1D000000, 0x2C000000, 0x3F000000, 0x54000000, 0x67000000, 0x7A000000, 0x86000000, 0x93000000, 
        0x9A000000, 0x9D000000, 0x9F000000, 0x9F000000, 0x9D000000, 0x9C000000, 0x9A000000, 0x98000000, 0x96000000, 0x91000000, 0x8B150000, 0x7E151C00, 0x71000000, 0x61150000, 0x50150000, 0x42000000, 0x33000000, 0x2A000000, 0x24000000, 0x23000000, 
        0x25000000, 0x29000000, 0xCB4A3822, 0xFF829544, 0xFF8FA435, 0xD65C672E, 0x54000000, 0x61150000, 0x6A000000, 0x74000000, 0x7E150000, 0x85150000, 0x86000000, 0x85150000, 0x7C000000, 0x71000000, 0x61150000, 0x50150000, 0x3F000000, 0x31000000, 
        0x26000000, 0x1F000000, 0x1C000000, 0x1D000000, 0x21000000, 0x27000000, 0x2F000000, 0x34000000, 0x3C000000, 0x42000000, 0x46000000, 0x46000000, 0x44000000, 0x42000000, 0x3B000000, 0x33000000, 0x2C000000, 0xEA3D1515, 0xFF3D001C, 0xFF420022, 
        0xFF3B001C, 0xFF48002B, 0xFF420022, 0xFF4C1527, 0xE4553B2B, 0xFB554627, 0xFE4A3B1C, 0xFF4C3822, 0xFF574027, 0xC8351500, 0xA5000000, 0xA5000000, 0xA3000000, 0xA0000000, 0x99000000, 0x8F000000, 0x82000000, 0x71000000, 0x5E000000, 0x4A000000, 
        0x37000000, 0x26000000, 0x19000000, 0x0F000000, 0x08000000, 0x04000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xCB4A3822, 0x00000000, 0x01000000, 0x04000000, 0x08000000, 0x10000000, 0x1A000000, 0x29000000, 0x3B000000, 0x4E000000, 0x63000000, 0x74000000, 0x85150000, 0x8F000000, 
        0x96000000, 0x99000000, 0x9A000000, 0x99000000, 0x96000000, 0x95000000, 0x93000000, 0x8F000000, 0x8F150000, 0x8B150000, 0x82000000, 0x7A000000, 0x6B151C00, 0x5D150000, 0x4A000000, 0x3B000000, 0x2C000000, 0x22000000, 0x1B000000, 0x18000000, 
        0x19000000, 0x1C000000, 0xCB4A3822, 0xFF8FA435, 0xFF627D27, 0x39000000, 0x44000000, 0x4E000000, 0x5B000000, 0x67000000, 0x74000000, 0x7C000000, 0x82000000, 0x82000000, 0x7E150000, 0x74151500, 0x65150000, 0x54000000, 0x42000000, 0x31000000, 
        0x24000000, 0x1B000000, 0x16000000, 0x15000000, 0x16000000, 0x1B000000, 0x21000000, 0x27000000, 0x2F000000, 0x36000000, 0x3B000000, 0x3E000000, 0x3E000000, 0x3C000000, 0x37000000, 0x31000000, 0x2A000000, 0x27000000, 0xEA3D1515, 0xFF3D001C, 
        0xFF3D001C, 0xFF46001C, 0xFE503227, 0xA6000000, 0x74000000, 0x82000000, 0x8F000000, 0x98000000, 0x9D000000, 0xA2000000, 0xA5000000, 0xA5000000, 0xA4000000, 0xA0000000, 0x9A000000, 0x93000000, 0x86000000, 0x77000000, 0x65150000, 0x51000000, 
        0x3C000000, 0x2C000000, 0x1D000000, 0x12000000, 0x0A000000, 0x05000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x07000000, 0x0E000000, 0x17000000, 0x25000000, 0x36000000, 0x49000000, 0x5B000000, 0x6F150000, 0x7E150000, 0x8A000000, 
        0x8F000000, 0x93000000, 0x93000000, 0x8F000000, 0x8C000000, 0x8A000000, 0x86000000, 0x85150000, 0x82000000, 0x80151500, 0x7E151C00, 0x74151500, 0x67000000, 0x58150000, 0x46000000, 0x37000000, 0x27000000, 0x1D000000, 0x15000000, 0x11000000, 
        0x10000000, 0x12000000, 0x15000000, 0xD65C672E, 0x21000000, 0x29000000, 0x33000000, 0x3E000000, 0x4A000000, 0x58000000, 0x67000000, 0x71000000, 0x7C000000, 0x7F000000, 0x7C000000, 0x74151500, 0x67000000, 0x58150000, 0x44000000, 0x33000000, 
        0x24000000, 0x19000000, 0x12000000, 0x0F000000, 0x0F000000, 0x11000000, 0x16000000, 0x1C000000, 0x22000000, 0x29000000, 0x2F000000, 0x34000000, 0x36000000, 0x34000000, 0x31000000, 0x2C000000, 0x26000000, 0x22000000, 0x80151500, 0xFF46001C, 
        0xFF482222, 0xC8351500, 0xA6444222, 0x58000000, 0x6A000000, 0x7A000000, 0x86000000, 0x93000000, 0x9A000000, 0xA0000000, 0xA3000000, 0xA5000000, 0xA5000000, 0xA2000000, 0x9D000000, 0x96000000, 0x8B150000, 0x7C000000, 0x6A000000, 0x58150000, 
        0x44000000, 0x31000000, 0x21000000, 0x15000000, 0x0C000000, 0x06000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x06000000, 0x0C000000, 0x14000000, 0x21000000, 0x31000000, 0x42000000, 0x54000000, 0x67000000, 0x77000000, 0x82000000, 
        0x86000000, 0x8A000000, 0x8A000000, 0x85150000, 0x7F000000, 0x7C000000, 0x7A000000, 0x77000000, 0x77000000, 0x77150000, 0x74151500, 0x6B151C00, 0x63000000, 0x58150000, 0x46000000, 0x34000000, 0x26000000, 0x1A000000, 0x12000000, 0x0D000000, 
        0x0B000000, 0x0B000000, 0x0D000000, 0x11000000, 0x16000000, 0x1D000000, 0x25000000, 0x31000000, 0x3C000000, 0x4A000000, 0x5B000000, 0x67000000, 0x74000000, 0x7A000000, 0x7C000000, 0x77150000, 0x6B151500, 0x5B000000, 0x48000000, 0x36000000, 
        0x26000000, 0x19000000, 0x10000000, 0x0C000000, 0x0A000000, 0x0B000000, 0x0E000000, 0x12000000, 0x18000000, 0x1D000000, 0x24000000, 0x27000000, 0x2C000000, 0x2C000000, 0x2A000000, 0x26000000, 0x21000000, 0x1D000000, 0x1B000000, 0x1D000000, 
        0x24000000, 0x2F000000, 0x3C000000, 0x4E000000, 0x5E000000, 0x71000000, 0x7F000000, 0x8C000000, 0x96000000, 0x9D000000, 0xA2000000, 0xA4000000, 0xA5000000, 0xA3000000, 0x9F000000, 0x99000000, 0x8F000000, 0x80151500, 0x71000000, 0x5D150000, 
        0x4A000000, 0x36000000, 0x26000000, 0x18000000, 0x0E000000, 0x07000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x05000000, 0x0A000000, 0x11000000, 0x1C000000, 0x2C000000, 0x3C000000, 0x4E000000, 0x61150000, 0x6F150000, 0x7A000000, 
        0x7F000000, 0x7F000000, 0x7C000000, 0x77000000, 0x71000000, 0x6B151500, 0x67000000, 0x67000000, 0x67000000, 0x6A150000, 0x6A150000, 0x65150000, 0x5D150000, 0x54150000, 0x44000000, 0x34000000, 0x26000000, 0x1A000000, 0x10000000, 0x0A000000, 
        0x07000000, 0x06000000, 0x07000000, 0x0A000000, 0x0D000000, 0x13000000, 0x1A000000, 0x24000000, 0x31000000, 0x3F000000, 0x4E000000, 0x5E000000, 0x6A000000, 0x74151500, 0x77150000, 0x74151500, 0x6B151500, 0x5B000000, 0x4A000000, 0x37000000, 
        0x27000000, 0x1A000000, 0x10000000, 0x0A000000, 0x07000000, 0x07000000, 0x08000000, 0x0B000000, 0x10000000, 0x14000000, 0x19000000, 0x1D000000, 0x21000000, 0x22000000, 0x21000000, 0x1D000000, 0x1B000000, 0x17000000, 0x16000000, 0x17000000, 
        0x1D000000, 0x26000000, 0x33000000, 0x44000000, 0x54000000, 0x67000000, 0x77000000, 0x85150000, 0x8F000000, 0x99000000, 0x9F000000, 0xA3000000, 0xA4000000, 0xA4000000, 0xA0000000, 0x9A000000, 0x93000000, 0x85150000, 0x77000000, 0x63000000, 
        0x4E000000, 0x3C000000, 0x2A000000, 0x1B000000, 0x11000000, 0x09000000, 0x04000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x04000000, 0x08000000, 0x0F000000, 0x18000000, 0x26000000, 0x34000000, 0x46000000, 0x58000000, 0x65150000, 0x6F150000, 
        0x74000000, 0x74000000, 0x6E000000, 0x67000000, 0x61150000, 0x5B000000, 0x58000000, 0x54000000, 0x58150000, 0x5B150000, 0x5D150000, 0x5D150000, 0x58150000, 0x50150000, 0x44000000, 0x34000000, 0x26000000, 0x1A000000, 0x10000000, 0x09000000, 
        0x06000000, 0x04000000, 0x04000000, 0x05000000, 0x08000000, 0x0C000000, 0x12000000, 0x1A000000, 0x25000000, 0x33000000, 0x44000000, 0x54000000, 0x61150000, 0x6E000000, 0x74151500, 0x71000000, 0x6B151500, 0x5D150000, 0x4C150000, 0x3B000000, 
        0x29000000, 0x1B000000, 0x10000000, 0x09000000, 0x05000000, 0x04000000, 0x04000000, 0x07000000, 0x0A000000, 0x0D000000, 0x11000000, 0x15000000, 0x18000000, 0x19000000, 0x19000000, 0x17000000, 0x14000000, 0x11000000, 0x10000000, 0x11000000, 
        0x16000000, 0x1D000000, 0x29000000, 0x37000000, 0x49000000, 0x5B000000, 0x6B151500, 0x7C000000, 0x8A000000, 0x93000000, 0x9C000000, 0xA0000000, 0xA3000000, 0xA3000000, 0xA0000000, 0x9D000000, 0x95000000, 0x8A000000, 0x7A000000, 0x67000000, 
        0x54000000, 0x3F000000, 0x2F000000, 0x1F000000, 0x13000000, 0x0A000000, 0x05000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x06000000, 0x0C000000, 0x15000000, 0x21000000, 0x2F000000, 0x3F000000, 0x4E000000, 0x5B000000, 0x63000000, 
        0x67000000, 0x65150000, 0x5E000000, 0x58000000, 0x4E000000, 0x48000000, 0x44000000, 0x44000000, 0x46000000, 0x4C150000, 0x51000000, 0x54150000, 0x50150000, 0x4C150000, 0x3F000000, 0x33000000, 0x26000000, 0x1A000000, 0x10000000, 0x09000000, 
        0x05000000, 0x03000000, 0x02000000, 0x02000000, 0x04000000, 0x07000000, 0x0C000000, 0x13000000, 0x1D000000, 0x2A000000, 0x39000000, 0x49000000, 0x58150000, 0x65150000, 0x6E000000, 0x6F150000, 0x67000000, 0x5D150000, 0x4C150000, 0x3B000000, 
        0x29000000, 0x1B000000, 0x10000000, 0x09000000, 0x05000000, 0x03000000, 0x02000000, 0x03000000, 0x05000000, 0x08000000, 0x0B000000, 0x0D000000, 0x10000000, 0x11000000, 0x11000000, 0x10000000, 0x0E000000, 0x0C000000, 0x0B000000, 0x0C000000, 
        0x10000000, 0x17000000, 0x21000000, 0x2F000000, 0x3E000000, 0x50150000, 0x63000000, 0x74000000, 0x82000000, 0x8F000000, 0x96000000, 0x9D000000, 0xA0000000, 0xA2000000, 0xA0000000, 0x9D000000, 0x96000000, 0x8B150000, 0x7C000000, 0x6B151500, 
        0x58150000, 0x44000000, 0x32000000, 0x21000000, 0x15000000, 0x0C000000, 0x06000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x05000000, 0x0A000000, 0x12000000, 0x1C000000, 0x29000000, 0x37000000, 0x46000000, 0x51000000, 0x58000000, 
        0x5B000000, 0x58000000, 0x50150000, 0x46000000, 0x3E000000, 0x37000000, 0x34000000, 0x34000000, 0x37000000, 0x3E000000, 0x44000000, 0x48000000, 0x48000000, 0x44000000, 0x3C000000, 0x31000000, 0x25000000, 0x19000000, 0x10000000, 0x09000000, 
        0x05000000, 0x02000000, 0x01000000, 0x01000000, 0x02000000, 0x04000000, 0x08000000, 0x0E000000, 0x16000000, 0x22000000, 0x31000000, 0x3F000000, 0x4E000000, 0x5D150000, 0x65150000, 0x67000000, 0x65150000, 0x58150000, 0x4A000000, 0x39000000, 
        0x29000000, 0x1B000000, 0x10000000, 0x09000000, 0x04000000, 0x02000000, 0x01000000, 0x01000000, 0x03000000, 0x04000000, 0x06000000, 0x08000000, 0x0A000000, 0x0B000000, 0x0B000000, 0x0A000000, 0x09000000, 0x08000000, 0x07000000, 0x08000000, 
        0x0B000000, 0x11000000, 0x19000000, 0x25000000, 0x34000000, 0x44000000, 0x58000000, 0x6A000000, 0x7A000000, 0x86000000, 0x93000000, 0x9A000000, 0x9D000000, 0xA0000000, 0x9F000000, 0x9C000000, 0x95000000, 0x8B150000, 0x7E150000, 0x6E000000, 
        0x5B150000, 0x46000000, 0x34000000, 0x23000000, 0x16000000, 0x0D000000, 0x07000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x04000000, 0x08000000, 0x0F000000, 0x18000000, 0x24000000, 0x31000000, 0x3C000000, 0x46000000, 0x4C150000, 
        0x4E000000, 0x49000000, 0x42000000, 0x37000000, 0x2F000000, 0x29000000, 0x26000000, 0x27000000, 0x2A000000, 0x31000000, 0x37000000, 0x3C000000, 0x3F000000, 0x3C000000, 0x36000000, 0x2C000000, 0x22000000, 0x18000000, 0x0F000000, 0x09000000, 
        0x04000000, 0x02000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x05000000, 0x0A000000, 0x11000000, 0x1B000000, 0x27000000, 0x37000000, 0x46000000, 0x54000000, 0x5D150000, 0x61150000, 0x5D150000, 0x54150000, 0x46000000, 0x37000000, 
        0x27000000, 0x1A000000, 0x10000000, 0x08000000, 0x04000000, 0x01000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x03000000, 0x04000000, 0x05000000, 0x06000000, 0x06000000, 0x06000000, 0x05000000, 0x05000000, 0x04000000, 0x05000000, 
        0x07000000, 0x0C000000, 0x13000000, 0x1D000000, 0x2C000000, 0x3B000000, 0x4E000000, 0x5E000000, 0x71000000, 0x7F000000, 0x8B150000, 0x93000000, 0x99000000, 0x9C000000, 0x9A000000, 0x98000000, 0x93000000, 0x8A000000, 0x7C000000, 0x6B151500, 
        0x5B150000, 0x46000000, 0x34000000, 0x24000000, 0x17000000, 0x0D000000, 0x07000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x07000000, 0x0C000000, 0x15000000, 0x1D000000, 0x2A000000, 0x34000000, 0x3C000000, 0x42000000, 
        0x3F000000, 0x3B000000, 0x34000000, 0x2C000000, 0x23000000, 0x1D000000, 0x1B000000, 0x1B000000, 0x1F000000, 0x25000000, 0x2C000000, 0x31000000, 0x34000000, 0x34000000, 0x2F000000, 0x27000000, 0x1F000000, 0x16000000, 0x0E000000, 0x08000000, 
        0x04000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x07000000, 0x0D000000, 0x16000000, 0x21000000, 0x2F000000, 0x3C000000, 0x4A000000, 0x54150000, 0x58150000, 0x58150000, 0x50150000, 0x42000000, 0x33000000, 
        0x25000000, 0x18000000, 0x0F000000, 0x08000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x02000000, 0x02000000, 0x03000000, 0x03000000, 0x03000000, 0x03000000, 0x02000000, 0x02000000, 0x03000000, 
        0x05000000, 0x08000000, 0x0E000000, 0x17000000, 0x23000000, 0x31000000, 0x42000000, 0x54000000, 0x65150000, 0x74000000, 0x82000000, 0x8C000000, 0x93000000, 0x95000000, 0x93000000, 0x91000000, 0x8C000000, 0x82000000, 0x77000000, 0x67000000, 
        0x58000000, 0x44000000, 0x33000000, 0x24000000, 0x17000000, 0x0D000000, 0x07000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x06000000, 0x0A000000, 0x11000000, 0x1A000000, 0x23000000, 0x2C000000, 0x33000000, 0x36000000, 
        0x34000000, 0x31000000, 0x27000000, 0x20000000, 0x19000000, 0x14000000, 0x12000000, 0x12000000, 0x16000000, 0x1B000000, 0x21000000, 0x26000000, 0x2A000000, 0x2A000000, 0x27000000, 0x21000000, 0x1A000000, 0x13000000, 0x0C000000, 0x07000000, 
        0x04000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x05000000, 0x0A000000, 0x11000000, 0x1B000000, 0x27000000, 0x34000000, 0x3F000000, 0x4A000000, 0x50150000, 0x4E000000, 0x46000000, 0x3C000000, 0x2F000000, 
        0x21000000, 0x16000000, 0x0D000000, 0x07000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 
        0x03000000, 0x06000000, 0x0A000000, 0x12000000, 0x1C000000, 0x29000000, 0x37000000, 0x49000000, 0x5B000000, 0x6A000000, 0x77000000, 0x82000000, 0x86000000, 0x8B150000, 0x8A000000, 0x86000000, 0x82000000, 0x7A000000, 0x6E000000, 0x61150000, 
        0x51000000, 0x3F000000, 0x31000000, 0x22000000, 0x16000000, 0x0D000000, 0x07000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x04000000, 0x08000000, 0x0E000000, 0x15000000, 0x1D000000, 0x24000000, 0x29000000, 0x2C000000, 
        0x2A000000, 0x25000000, 0x1F000000, 0x18000000, 0x12000000, 0x0D000000, 0x0C000000, 0x0C000000, 0x0E000000, 0x13000000, 0x18000000, 0x1C000000, 0x20000000, 0x20000000, 0x1F000000, 0x1A000000, 0x15000000, 0x0F000000, 0x0A000000, 0x06000000, 
        0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x07000000, 0x0D000000, 0x16000000, 0x20000000, 0x2C000000, 0x37000000, 0x3F000000, 0x44000000, 0x44000000, 0x3C000000, 0x34000000, 0x27000000, 
        0x1D000000, 0x13000000, 0x0B000000, 0x06000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x02000000, 0x04000000, 0x07000000, 0x0D000000, 0x15000000, 0x20000000, 0x2F000000, 0x3C000000, 0x4E000000, 0x5D150000, 0x6A000000, 0x74000000, 0x7A000000, 0x7C000000, 0x7C000000, 0x7A000000, 0x74000000, 0x6B151500, 0x63000000, 0x54000000, 
        0x48000000, 0x39000000, 0x2C000000, 0x1D000000, 0x13000000, 0x0B000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x07000000, 0x0B000000, 0x11000000, 0x17000000, 0x1C000000, 0x20000000, 0x21000000, 
        0x20000000, 0x1C000000, 0x16000000, 0x11000000, 0x0C000000, 0x08000000, 0x07000000, 0x07000000, 0x09000000, 0x0C000000, 0x10000000, 0x14000000, 0x17000000, 0x18000000, 0x17000000, 0x14000000, 0x10000000, 0x0B000000, 0x07000000, 0x04000000, 
        0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x05000000, 0x0A000000, 0x11000000, 0x1A000000, 0x23000000, 0x2C000000, 0x34000000, 0x39000000, 0x37000000, 0x33000000, 0x2C000000, 0x21000000, 
        0x18000000, 0x0F000000, 0x09000000, 0x05000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x01000000, 0x02000000, 0x05000000, 0x09000000, 0x10000000, 0x19000000, 0x25000000, 0x32000000, 0x3F000000, 0x4E000000, 0x5B000000, 0x63000000, 0x6A000000, 0x6B151500, 0x6B151500, 0x67000000, 0x63000000, 0x5B000000, 0x51000000, 0x48000000, 
        0x3C000000, 0x31000000, 0x24000000, 0x19000000, 0x10000000, 0x0A000000, 0x05000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x05000000, 0x08000000, 0x0D000000, 0x11000000, 0x15000000, 0x18000000, 0x19000000, 
        0x17000000, 0x14000000, 0x10000000, 0x0B000000, 0x08000000, 0x05000000, 0x04000000, 0x04000000, 0x05000000, 0x08000000, 0x0B000000, 0x0D000000, 0x0F000000, 0x10000000, 0x10000000, 0x0E000000, 0x0B000000, 0x08000000, 0x05000000, 0x03000000, 
        0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x04000000, 0x08000000, 0x0D000000, 0x14000000, 0x1C000000, 0x24000000, 0x2A000000, 0x2C000000, 0x2C000000, 0x29000000, 0x22000000, 0x1B000000, 
        0x13000000, 0x0C000000, 0x07000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x01000000, 0x03000000, 0x06000000, 0x0B000000, 0x13000000, 0x1C000000, 0x27000000, 0x34000000, 0x3F000000, 0x4A000000, 0x54000000, 0x58000000, 0x5B000000, 0x58000000, 0x54000000, 0x50150000, 0x49000000, 0x42000000, 0x39000000, 
        0x2F000000, 0x25000000, 0x1C000000, 0x14000000, 0x0D000000, 0x07000000, 0x04000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x03000000, 0x06000000, 0x09000000, 0x0C000000, 0x0F000000, 0x11000000, 0x11000000, 
        0x10000000, 0x0E000000, 0x0B000000, 0x07000000, 0x05000000, 0x03000000, 0x02000000, 0x02000000, 0x03000000, 0x04000000, 0x06000000, 0x08000000, 0x0A000000, 0x0A000000, 0x0A000000, 0x09000000, 0x07000000, 0x05000000, 0x03000000, 0x02000000, 
        0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x05000000, 0x0A000000, 0x0F000000, 0x15000000, 0x1B000000, 0x20000000, 0x22000000, 0x22000000, 0x1F000000, 0x1A000000, 0x14000000, 
        0x0E000000, 0x09000000, 0x05000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x01000000, 0x02000000, 0x04000000, 0x08000000, 0x0D000000, 0x15000000, 0x1D000000, 0x27000000, 0x31000000, 0x3B000000, 0x42000000, 0x44000000, 0x46000000, 0x44000000, 0x42000000, 0x3C000000, 0x37000000, 0x31000000, 0x2A000000, 
        0x23000000, 0x1B000000, 0x14000000, 0x0E000000, 0x09000000, 0x05000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x04000000, 0x06000000, 0x08000000, 0x0A000000, 0x0B000000, 0x0B000000, 
        0x0A000000, 0x09000000, 0x07000000, 0x04000000, 0x03000000, 0x02000000, 0x01000000, 0x01000000, 0x01000000, 0x02000000, 0x03000000, 0x05000000, 0x05000000, 0x06000000, 0x06000000, 0x05000000, 0x04000000, 0x03000000, 0x02000000, 0x01000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x04000000, 0x07000000, 0x0A000000, 0x0F000000, 0x13000000, 0x16000000, 0x18000000, 0x18000000, 0x16000000, 0x12000000, 0x0E000000, 
        0x0A000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x05000000, 0x09000000, 0x0E000000, 0x15000000, 0x1C000000, 0x24000000, 0x2C000000, 0x31000000, 0x33000000, 0x34000000, 0x32000000, 0x2F000000, 0x2C000000, 0x27000000, 0x22000000, 0x1D000000, 
        0x18000000, 0x12000000, 0x0E000000, 0x09000000, 0x06000000, 0x03000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x04000000, 0x05000000, 0x06000000, 0x07000000, 0x07000000, 
        0x06000000, 0x05000000, 0x04000000, 0x02000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x02000000, 0x03000000, 0x03000000, 0x03000000, 0x03000000, 0x02000000, 0x01000000, 0x01000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x04000000, 0x07000000, 0x0A000000, 0x0D000000, 0x0F000000, 0x10000000, 0x10000000, 0x0E000000, 0x0C000000, 0x09000000, 
        0x06000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x06000000, 0x09000000, 0x0E000000, 0x13000000, 0x18000000, 0x1D000000, 0x21000000, 0x23000000, 0x24000000, 0x22000000, 0x20000000, 0x1D000000, 0x19000000, 0x16000000, 0x12000000, 
        0x0F000000, 0x0C000000, 0x08000000, 0x06000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x02000000, 0x03000000, 0x03000000, 0x04000000, 0x04000000, 
        0x03000000, 0x03000000, 0x02000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x04000000, 0x06000000, 0x08000000, 0x09000000, 0x0A000000, 0x0A000000, 0x09000000, 0x07000000, 0x05000000, 
        0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x03000000, 0x06000000, 0x08000000, 0x0C000000, 0x0F000000, 0x13000000, 0x15000000, 0x16000000, 0x17000000, 0x16000000, 0x14000000, 0x12000000, 0x0F000000, 0x0D000000, 0x0B000000, 
        0x08000000, 0x06000000, 0x05000000, 0x03000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x02000000, 0x02000000, 0x02000000, 
        0x01000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x02000000, 0x03000000, 0x04000000, 0x05000000, 0x05000000, 0x05000000, 0x05000000, 0x04000000, 0x03000000, 
        0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x03000000, 0x05000000, 0x07000000, 0x09000000, 0x0B000000, 0x0C000000, 0x0D000000, 0x0D000000, 0x0C000000, 0x0B000000, 0x0A000000, 0x08000000, 0x07000000, 0x05000000, 
        0x04000000, 0x03000000, 0x02000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x02000000, 0x02000000, 0x03000000, 0x03000000, 0x02000000, 0x02000000, 0x01000000, 
        0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x02000000, 0x03000000, 0x05000000, 0x06000000, 0x06000000, 0x07000000, 0x07000000, 0x06000000, 0x06000000, 0x05000000, 0x04000000, 0x03000000, 0x02000000, 
        0x02000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x02000000, 0x02000000, 0x03000000, 0x03000000, 0x03000000, 0x03000000, 0x02000000, 0x02000000, 0x01000000, 0x01000000, 0x01000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000
#else
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0x2D447278, 0x3422384A, 0x006D627D, 0x00575970, 0x004A4062, 0x004A4062, 0x00383B5F, 0x00383B5F, 0x00383B5F, 0x0027154C, 0x002E3255, 0x002E3255, 0x00383B5F, 0x004A4062, 0x006D627D, 0x3422384A, 0x8B224040, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x8B224040, 0x004A4062, 0x004A4062, 0x004A4062, 0x002E3255, 
        0x004A4062, 0x00575970, 0x00575970, 0x00575970, 0x00575970, 0x004A4062, 0x004A4062, 0x004A4062, 0x004A4062, 0x004A4062, 0x004A4062, 0x004A4062, 0x00383B5F, 0x002E3255, 0x002E3255, 0x00222248, 0x0022003D, 0x001C003B, 0x002B0048, 0x00383B5F, 
        0x1B2B3B55, 0x3422384A, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x8B224040, 0x3422384A, 0x004A4062, 0x002E3255, 0x00485263, 0x00787283, 0x00787283, 0x00787283, 0x006D627D, 
        0x00575970, 0x00485263, 0x006D627D, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 0x00787283, 0x00787283, 0x00787283, 0x006D627D, 0x00575970, 0x00575970, 0x004A4062, 0x004A4062, 0x002E3255, 0x0027154C, 0x002B0048, 
        0x00220040, 0x001C003B, 0x001C003B, 0x002E3255, 0x3422384A, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x2D447278, 0x3422384A, 0x00575970, 0x00575970, 0x006D627D, 0x006D627D, 0x00787283, 0x006D627D, 0x00575970, 0x006D627D, 0x00948490, 0x00B6A7AC, 
        0x00B6A7AC, 0x00B6A7AC, 0x00B6A7AC, 0x00B6A7AC, 0x00948490, 0x00787283, 0x006D627D, 0x006D627D, 0x006D627D, 0x00575970, 0x004A4062, 0x004A4062, 0x004A4062, 0x004A4062, 0x00383B5F, 0x002E3255, 0x0027154C, 0x0027154C, 0x0027154C, 0x002B0048, 
        0x001C0046, 0x00220042, 0x001C003D, 0x0015002E, 0x001C0035, 0x002B0048, 0x1B2B3B55, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x8B224040, 0x2D447278, 0x00575970, 0x004A4062, 0x006D627D, 0x00787283, 0x00787283, 0x00787283, 0x00485263, 0x00948490, 0x00B6A7AC, 0x00B6A7AC, 0x00B6A7AC, 0x00B6A7AC, 0x00948490, 
        0x00787283, 0x00787283, 0x00787283, 0x00787283, 0x00787283, 0x00787283, 0x00787283, 0x00787283, 0x00787283, 0x006D627D, 0x00787283, 0x006D627D, 0x00575970, 0x00575970, 0x00485263, 0x00383B5F, 0x002E3255, 0x002B0048, 0x002B0048, 0x002B0048, 
        0x00220042, 0x00220042, 0x00220042, 0x001C0038, 0x001C003B, 0x001C0035, 0x001C0035, 0x002E3255, 0x006D627D, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x90000015, 0x00787283, 0x00787283, 0x002E3255, 0x00575970, 0x00B6A7AC, 0x00787283, 0x00575970, 0x00B6A7AC, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00948490, 0x006D627D, 0x006D627D, 0x006D627D, 0x006D627D, 
        0x00787283, 0x00948490, 0x00948490, 0x00948490, 0x00B6A7AC, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00B6A7AC, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 0x00787283, 0x00575970, 0x00485263, 0x004A4062, 0x002E3255, 0x0027154C, 0x002B0048, 
        0x00220042, 0x00220042, 0x00220042, 0x0022003D, 0x001C0038, 0x00150035, 0x001C0035, 0x001C0035, 0x001C003B, 0x003D5783, 0x8B224040, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x2D447278, 0x00575970, 0x00383B5F, 0x0027154C, 0x00948490, 0x00C6BEC2, 0x00C6BEC2, 0x00B6A7AC, 0x00B6A7AC, 0x00948490, 0x006D627D, 0x00575970, 0x004A4062, 0x00575970, 0x00575970, 0x006D627D, 0x00787283, 0x00948490, 
        0x00B6A7AC, 0x00B6A7AC, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00B6A7AC, 0x00948490, 0x00948490, 0x00787283, 0x00787283, 0x006D627D, 0x00575970, 0x004A4062, 0x002E3255, 0x0027154C, 0x002B0048, 0x001C0046, 
        0x00220042, 0x001C003D, 0x001C0038, 0x001C003B, 0x001C0035, 0x001C0035, 0x0015002E, 0x001C0035, 0x001C0035, 0x001C0038, 0x003D5783, 0x8B224040, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x90000015, 
        0x37001535, 0x00948490, 0x002E3255, 0x00222248, 0x0027154C, 0x00383B5F, 0x004A4062, 0x00575970, 0x00485263, 0x002E3255, 0x00383B5F, 0x004A4062, 0x00485263, 0x00575970, 0x00575970, 0x006D627D, 0x00948490, 0x00948490, 0x00948490, 0x00B6A7AC, 
        0x00B6A7AC, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00B6A7AC, 0x00948490, 0x00948490, 0x00787283, 0x006D627D, 0x006D627D, 0x006D627D, 0x004A4062, 0x002E3255, 0x0027154C, 0x002B0048, 0x0027154C, 0x00220040, 0x00220042, 
        0x00220042, 0x00220042, 0x001C003B, 0x0015002E, 0x001C0035, 0x001C0035, 0x001C0035, 0x0015002E, 0x00150035, 0x001C0035, 0x001C003B, 0x00272E90, 0x8B224040, 0xFA000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x3422384A, 0x004A4062, 0x0027154C, 0x00220042, 
        0x002E3255, 0x00274057, 0x0027154C, 0x0027154C, 0x002E3255, 0x00383B5F, 0x0027154C, 0x002E3255, 0x00383B5F, 0x00383B5F, 0x00485263, 0x00485263, 0x00575970, 0x006D627D, 0x00787283, 0x00948490, 0x00948490, 0x00948490, 0x00B6A7AC, 0x00B6A7AC, 
        0x00B6A7AC, 0x00C6BEC2, 0x00C6BEC2, 0x00B6A7AC, 0x00B6A7AC, 0x00948490, 0x00948490, 0x00948490, 0x00787283, 0x006D627D, 0x006D627D, 0x00575970, 0x00485263, 0x004A4062, 0x00383B5F, 0x002E3255, 0x002B0048, 0x002B0048, 0x001C003D, 0x001C003B, 
        0x001C0038, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C0035, 0x00220035, 0x001C0035, 0x001C0035, 0x0015002E, 0x00150035, 0x001C0038, 0x00220040, 0x00B6A7AC, 0xF5000000, 0xF6000000, 0xF8000000, 0xF9000000, 0xFB000000, 0xFC000000, 0xFD000000, 
        0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x37001535, 0x1515153D, 0x002B0048, 0x00220040, 0x00220040, 0x0027154C, 0x0022003D, 
        0x002276A3, 0x002287AD, 0x00225A6F, 0x00383B5F, 0x00485263, 0x00485263, 0x00383B5F, 0x00383B5F, 0x00383B5F, 0x004A4062, 0x00575970, 0x00575970, 0x00787283, 0x00787283, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 0x00B6A7AC, 0x00B6A7AC, 
        0x00B6A7AC, 0x00B6A7AC, 0x00B6A7AC, 0x00948490, 0x00948490, 0x00948490, 0x00787283, 0x00787283, 0x006D627D, 0x006D627D, 0x004A4062, 0x004A4062, 0x00383B5F, 0x002B0048, 0x00220040, 0x0022003D, 0x001C003B, 0x001C003B, 0x37001535, 0x37001535, 
        0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x1515153D, 0x001C0066, 0xED000000, 0xEF000000, 0xF1000000, 0xF4000000, 0xF6000000, 0xF8000000, 0xF9000000, 
        0xFB000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x37001535, 0x1515153D, 0x001C003D, 0x001C003D, 0x001C003B, 0x001C0038, 0x001C003D, 0x0027154C, 0x001C0046, 
        0x001C7EC8, 0x001CD2FC, 0x0046BED8, 0x00427B7F, 0x00575970, 0x00485263, 0x00383B5F, 0x00383B5F, 0x00383B5F, 0x00485263, 0x00575970, 0x00575970, 0x006D627D, 0x00787283, 0x00787283, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 
        0x00948490, 0x00948490, 0x00B6A7AC, 0x00948490, 0x00948490, 0x00948490, 0x006D627D, 0x00575970, 0x004A4062, 0x00383B5F, 0x002B0048, 0x002B0048, 0x01273250, 0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x74000015, 0xCB000000, 0xCB000000, 
        0xCB000000, 0xCB000000, 0xCB000000, 0xCB000000, 0xCB000000, 0xCC000000, 0xCE000000, 0xD0000000, 0xD3000000, 0xD3000000, 0xD8000000, 0xDA000000, 0x37001535, 0xE2000000, 0xE4000000, 0xE8000000, 0xEB000000, 0xEE000000, 0xF1000000, 0xF4000000, 
        0xF7000000, 0xF9000000, 0xFB000000, 0xFC000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x90000015, 0x1515153D, 0x001C003B, 0x001C0038, 0x001C003D, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C003D, 0x002E3255, 0x002E3255, 
        0x001C7EC8, 0x001CE0FB, 0x0032E6FA, 0x0046BED8, 0x004C9987, 0x00575970, 0x00575970, 0x00575970, 0x00575970, 0x00485263, 0x00575970, 0x00575970, 0x006D627D, 0x006D627D, 0x00787283, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 
        0x00B6A7AC, 0x00B6A7AC, 0x00948490, 0x006D627D, 0x004A4062, 0x00222248, 0x0027154C, 0x1515153D, 0x37001535, 0xCD000000, 0xCB000000, 0xC6000000, 0xC3000000, 0xC0000000, 0xBD000000, 0xBB000000, 0xBB000000, 0xB9000000, 0xB7000000, 0xB7000000, 
        0xB6000000, 0xB6000000, 0xB6000000, 0xB7000000, 0xB9000000, 0xB9000000, 0xBB000000, 0xBB000000, 0xC0000000, 0xC3000000, 0xC6000000, 0xC9000000, 0xCD000000, 0xD0000000, 0xD6000000, 0xDA000000, 0xDF000000, 0xE4000000, 0xE8000000, 0xEC000000, 
        0xF0000000, 0xF4000000, 0xF7000000, 0xFA000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x90000015, 0x00220042, 0x001C003D, 0x001C0038, 0x001C003D, 0x001C0066, 0x01221C8D, 0x001C0066, 0x0027154C, 0x001C003D, 0x00220040, 0x00575970, 
        0x001C7EC8, 0x0022E4FC, 0x0040EDFC, 0x007AF0F5, 0x006DEDD4, 0x00B6A7AC, 0x00948490, 0x00787283, 0x006D627D, 0x006D627D, 0x00575970, 0x00575970, 0x00575970, 0x006D627D, 0x006D627D, 0x00948490, 0x00948490, 0x00948490, 0x00B6A7AC, 0x00948490, 
        0x00787283, 0x00383B5F, 0x00222248, 0x00222248, 0x37001535, 0xCB000000, 0xC6000000, 0xC3000000, 0xBD000000, 0xBB000000, 0xB6000000, 0xB1000000, 0xAF000015, 0xAB000000, 0xAB000000, 0xA7000000, 0xA4000000, 0xA4000000, 0xA2000015, 0xA2000015, 
        0xA1000000, 0xA1000000, 0xA1000000, 0xA2000015, 0xA4000000, 0xA4000000, 0xA4000000, 0xA7000000, 0xAB000000, 0xAE000000, 0xB1000000, 0xB6000000, 0xBB000000, 0xC0000000, 0xC4000000, 0xCB000000, 0xCE000000, 0xD5000000, 0xDB000000, 0xE2000000, 
        0xE7000000, 0xEC000000, 0xF1000000, 0xF5000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x94001C15, 0x00220040, 0x001C003D, 0x001C003B, 0x001C0046, 0x00222B99, 0x001C7EC8, 0x001C7EC8, 0x001C7EC8, 0x00222B99, 0x01221C8D, 0x001C0066, 0x00575970, 
        0x001C7EC8, 0x0022E9FF, 0x0040EDFC, 0x007AF0F5, 0x007AF0F5, 0x00C6BEC2, 0x00B6A7AC, 0x00C6BEC2, 0x006D627D, 0x00485263, 0x004A4062, 0x004A4062, 0x004A4062, 0x00575970, 0x006D627D, 0x00948490, 0x00B6A7AC, 0x00948490, 0x00575970, 0x002E3255, 
        0x1515153D, 0x74000015, 0xC8000000, 0xC3000000, 0xBD000000, 0xB9000000, 0xB3000015, 0xAE000000, 0xAB000000, 0xA4000000, 0xA1000000, 0x9E000015, 0x9A000015, 0x98000000, 0x95000000, 0x91000000, 0x91000000, 0x8E000000, 0x8E000000, 0x8E000000, 
        0x8E000000, 0x8E000000, 0x8E000000, 0x8E000000, 0x8E000000, 0x90000015, 0x91000000, 0x94001515, 0x95000000, 0x98000000, 0x9C000000, 0xA1000000, 0xA7000015, 0xAB000000, 0xB1000000, 0xB7000000, 0xBD000000, 0xC4000000, 0xCC000000, 0xD3000000, 
        0xDB000000, 0xE2000000, 0xE9000000, 0xEF000000, 0xF4000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x8B224040, 0x00222248, 0x001C003D, 0x001C0035, 0x001C003B, 0x00222B99, 0x001C7EC8, 0x00222B99, 0x002B387A, 0x00272E90, 0x00222B99, 0x00222B99, 0x00222E8D, 0x00787283, 
        0x002287AD, 0x0032EBFF, 0x007AF0F5, 0x007AF0F5, 0x007AF0F5, 0x0378C6BE, 0x00C6BEC2, 0x00948490, 0x006D627D, 0x00383B5F, 0x002E3255, 0x002E3255, 0x00383B5F, 0x004A4062, 0x00575970, 0x004A4062, 0x0027154C, 0x1515153D, 0x3422384A, 0xC8000000, 
        0xC1000000, 0xBB000000, 0xB5000000, 0xAF000015, 0xA7000015, 0xA4000000, 0x9E000015, 0x98000000, 0x95000000, 0x91000000, 0x8E000000, 0x8B000000, 0x88000000, 0x85000000, 0x83000000, 0x80000000, 0x80000000, 0x7D000000, 0x7D000000, 0x7D000000, 
        0x7D000000, 0x7D000000, 0x7D000000, 0x7D000000, 0x7D000000, 0x7D000000, 0x80000000, 0x83000000, 0x83000000, 0x88000000, 0x8B000000, 0x8E000000, 0x94001515, 0x98000000, 0x9E000015, 0xA4000015, 0xAB000015, 0xB3000015, 0xBB000000, 0xC4000000, 
        0xCD000000, 0xD8000000, 0xDF000000, 0xE7000000, 0xEE000000, 0xF4000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x0027154C, 0x001C003D, 0x00150038, 0x00150035, 0x0027154C, 0x001C7EC8, 0x001C7EC8, 0x001C0066, 0x00575970, 0x006D627D, 0x00222B99, 0x001C7EC8, 0x00222B99, 0x001C0066, 
        0x003D5783, 0x002BC5F0, 0x007AF0F5, 0x007AF0F5, 0x007AF0F5, 0x0046BED8, 0x00787283, 0x00485263, 0x004A4062, 0x0027154C, 0x0027154C, 0x0027154C, 0x0027154C, 0x0027154C, 0x1515153D, 0x37001535, 0xCB000000, 0xC4000000, 0xBB000000, 0xB5000000, 
        0xAE000000, 0xA7000015, 0xA2000015, 0x9A000015, 0x95000000, 0x90000015, 0x8B000000, 0x88000000, 0x83000000, 0x80000000, 0x7D000000, 0x7A000015, 0x79000000, 0x75000000, 0x73000000, 0x73000000, 0x70000000, 0x70000000, 0x70000000, 0x70000000, 
        0x70000000, 0x70000000, 0x70000000, 0x70000000, 0x70000000, 0x70000000, 0x73000000, 0x74000015, 0x79000000, 0x79000000, 0x7D000000, 0x80000000, 0x83000000, 0x88000015, 0x8E000000, 0x94001515, 0x9A000015, 0xA2000015, 0xAB000015, 0xB5000000, 
        0xC0000000, 0xCB000000, 0xD3000000, 0xDE000000, 0xE7000000, 0xEF000000, 0xF5000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x3422384A, 0x00220042, 0x001C0035, 0x00150035, 0x0015002E, 0x001C0066, 0x001C7EC8, 0x00222B99, 0x001C005A, 0x00575970, 0x006D627D, 0x00222E8D, 0x001C7EC8, 0x00222B99, 0x001C005A, 
        0x00383B5F, 0x0046BED8, 0x001CD2FC, 0x002BC5F0, 0x001CCCFA, 0x002BC5F0, 0x0040818E, 0x00383B5F, 0x002B0048, 0x002B0048, 0x002B0048, 0x001C0046, 0x1515153D, 0x74000015, 0xCB000000, 0xC3000000, 0xB9000000, 0xB1000000, 0xA7000015, 0xA2000015, 
        0x9A000015, 0x94001515, 0x8E000000, 0x88000000, 0x83000000, 0x7F001515, 0x7A000015, 0x79000000, 0x74000015, 0x70000000, 0x70000000, 0x6C000000, 0x6C000000, 0x6A000000, 0x69000000, 0x67000000, 0x67000000, 0x66000000, 0x66000000, 0x66000000, 
        0x66000000, 0x67000000, 0x67000000, 0x69000000, 0x69000000, 0x69000000, 0x6C000000, 0x6C000000, 0x6E000000, 0x70000000, 0x73000000, 0x75000000, 0x7A000015, 0x7D000000, 0x81000015, 0x88000015, 0x8E000000, 0x94001515, 0x9E000015, 0xA7000015, 
        0xB1000000, 0xBD000000, 0xC9000000, 0xD5000000, 0xE0000000, 0xE9000000, 0xF1000000, 0xF6000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x1515153D, 0x001C0038, 0x0015002E, 0x0015002E, 0x00150035, 0x001C0066, 0x001C7EC8, 0x001C7EC8, 0x00222B99, 0x001C0066, 0x00223D66, 0x00222B99, 0x001C7EC8, 0x001C7EC8, 0x002B387A, 
        0x002E3255, 0x0046BED8, 0x001CC1F8, 0x001CC1F8, 0x001CC1F8, 0x001CCCFA, 0x0046BED8, 0x003B7E72, 0x00575970, 0x002E3255, 0x002B0048, 0x1515153D, 0x74000015, 0xC0000000, 0xB9000000, 0xAF000015, 0xA7000015, 0x9E000015, 0x95000015, 0x8E000000, 
        0x1B2B3B55, 0x1B2B3B55, 0x1B2B3B55, 0x1B2B3B55, 0x1B2B3B55, 0x1B2B3B55, 0x1B2B3B55, 0x19222250, 0x19222250, 0x1B2B3B55, 0x1B2B3B55, 0x00575970, 0x00575970, 0x62000000, 0x62000000, 0x62000000, 0x62000000, 0x62000000, 0x62000000, 0x62000000, 
        0x63000000, 0x63000000, 0x65000000, 0x65000000, 0x66000000, 0x67000000, 0x69000000, 0x6A000000, 0x6C000000, 0x6E000000, 0x70000000, 0x73000000, 0x75000000, 0x79000000, 0x7D000000, 0x81000015, 0x85000000, 0x8B001515, 0x94001515, 0x9E000015, 
        0xA7000015, 0xB3000015, 0xC0000000, 0xCD000000, 0xD9000000, 0xE4000000, 0xED000000, 0xF4000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x19222250, 0x00220040, 0x001C0035, 0x00150035, 0x0015002E, 0x00150035, 0x001C0066, 0x001C84E6, 0x001C84E6, 0x001C7EC8, 0x001C7EC8, 0x001C7EC8, 0x001C7EC8, 0x001C7EC8, 0x001C7EC8, 0x002B387A, 
        0x0027154C, 0x001C7EC8, 0x001CC1F8, 0x001CC1F8, 0x001CD2FC, 0x0040EDFC, 0x007AF0F5, 0x0378C6BE, 0x00575970, 0x002E3255, 0x1515153D, 0xBD000000, 0xB5000000, 0xAE000000, 0x292E675C, 0x003D5783, 0x00222E8D, 0x00272E90, 0x00272E90, 0x00222B99, 
        0x00222B99, 0x00222B99, 0x00272E90, 0x00272E90, 0x00222E8D, 0x00222E8D, 0x00222E8D, 0x002B387A, 0x002B387A, 0x002B387A, 0x002B387A, 0x002B387A, 0x002B387A, 0x003D5783, 0x003D5783, 0x003D5783, 0x003D5783, 0x1B2B3B55, 0x1B2B3B55, 0x1B2B3B55, 
        0x65000000, 0x65000000, 0x66000000, 0x67000000, 0x69000000, 0x6A000000, 0x6C000000, 0x6C000000, 0x70000000, 0x70000000, 0x73000000, 0x75000000, 0x79000000, 0x7A000015, 0x7D000000, 0x81000015, 0x85000000, 0x8B001515, 0x90000015, 0x98000000, 
        0xA2000015, 0xAB000015, 0xBB000000, 0xC8000000, 0xD3000000, 0xE0000000, 0xEA000000, 0xF1000000, 0xF7000000, 0xFB000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x00220042, 0x001C003D, 0x0015002E, 0x0015002E, 0x0015002E, 0x00150035, 0x002B387A, 0x001C84E6, 0x001C84E6, 0x001C84E6, 0x001C84E6, 0x001C84E6, 0x001C84E6, 0x001C84E6, 0x001C84E6, 0x00272E90, 
        0x001C0046, 0x001C7EC8, 0x001CE0FB, 0x0040EDFC, 0x007AF0F5, 0x0378C6BE, 0x003D5783, 0x00223D66, 0x002B387A, 0x002276A3, 0x002276A3, 0x001C7EC8, 0x002276A3, 0x00222B99, 0x00222E8D, 0x002B387A, 0x001C0066, 0x00383B5F, 0x00383B5F, 0x00485263, 
        0x00575970, 0x00575970, 0x00485263, 0x004A4062, 0x00485263, 0x004A4062, 0x004A4062, 0x002E3255, 0x0027154C, 0x0027154C, 0x0027154C, 0x002E3255, 0x002B0048, 0x002B0048, 0x002B0048, 0x002B0048, 0x0027154C, 0x001C005A, 0x002B387A, 0x003D5783, 
        0x003D5783, 0x003D5783, 0x1B2B3B55, 0x2D447278, 0x292E675C, 0x73000000, 0x74000015, 0x75000000, 0x79000000, 0x7A000015, 0x7D000000, 0x80000000, 0x81000015, 0x83000000, 0x85000000, 0x88000000, 0x8B001515, 0x90000015, 0x94001515, 0x9A000015, 
        0xA2000015, 0xAB000015, 0xB9000000, 0xC4000000, 0xD0000000, 0xDD000000, 0xE8000000, 0xF0000000, 0xF6000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x00220042, 0x001C0038, 0x00150035, 0x0015002E, 0x0015002E, 0x001C0046, 0x00222B99, 0x001C84E6, 0x001C84E6, 0x001CADF5, 0x001C84E6, 0x001C84E6, 0x001CADF5, 0x001C84E6, 0x001C84E6, 0x001C7EC8, 
        0x02221C46, 0x00222B99, 0x007AF0F5, 0x0378C6BE, 0x0040818E, 0x00223D66, 0x00223D66, 0x001C005A, 0x00223D66, 0x00383B5F, 0x00575970, 0x006D627D, 0x006D627D, 0x006D627D, 0x006D627D, 0x006D627D, 0x00575970, 0x00575970, 0x004A4062, 0x002E3255, 
        0x002B0048, 0x00220042, 0x00220040, 0x001C003B, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C0035, 0x001C0035, 0x001C0035, 0x001C0035, 0x0015002E, 0x001C0035, 0x001C0035, 0x001C0035, 0x0015002E, 0x001C0035, 0x001C0035, 0x001C0038, 0x001C0035, 
        0x001C003D, 0x0027154C, 0x002E3255, 0x00223D66, 0x002B387A, 0x00226D89, 0x00575970, 0x59224244, 0x85000000, 0x88000000, 0x8B000000, 0x8E000000, 0x90000015, 0x91000000, 0x95000000, 0x95000000, 0x98000000, 0x9A000015, 0x9E000015, 0xA2000015, 
        0xAB000015, 0xB3000015, 0xBB000000, 0xC8000000, 0xD3000000, 0xDE000000, 0xE8000000, 0xF0000000, 0xF6000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x90000015, 0x001C003D, 0x001C0038, 0x001C0038, 0x001C0035, 0x00220040, 0x002276A3, 0x001C84E6, 0x001CADF5, 0x001CC1F8, 0x001CD2FC, 0x001CCBFB, 0x001CCCFA, 0x001CD2FC, 0x001CC1F8, 0x001CC1F8, 0x001CADF5, 
        0x00226D89, 0x001C005A, 0x00223D66, 0x00383B5F, 0x002B545D, 0x00787283, 0x00948490, 0x00948490, 0x00787283, 0x006D627D, 0x004A4062, 0x0027003D, 0x0022003D, 0x001C0038, 0x001C0038, 0x001C0038, 0x001C003B, 0x001C0038, 0x001C0035, 0x001C0035, 
        0x001C0035, 0x001C0038, 0x001C0038, 0x00220035, 0x00220035, 0x00220035, 0x001C0038, 0x00220035, 0x0015002E, 0x0015002E, 0x0015002E, 0x0015002E, 0x001C0035, 0x001C0035, 0x0015002E, 0x0015002E, 0x0015002E, 0x0015002E, 0x0015002E, 0x0015002E, 
        0x0015002E, 0x0015002E, 0x001C0035, 0x0015002E, 0x001C0038, 0x001C003B, 0x00383B5F, 0x00485263, 0x00575970, 0x59224244, 0x9E000015, 0xA1000000, 0xA4000000, 0xA4000000, 0xA7000000, 0xA7000000, 0xAB000000, 0xAB000000, 0xAE000000, 0xB1000000, 
        0xB5000000, 0xBB000000, 0xC4000000, 0xCD000000, 0xD8000000, 0xE0000000, 0xE9000000, 0xF1000000, 0xF6000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x37001535, 0x00220042, 0x001C0038, 0x001C0038, 0x00150035, 0x002B387A, 0x001C84E6, 0x001CADF5, 0x001CADF5, 0x001CCBFB, 0x001CCCFA, 0x001CD2FC, 0x001CE0FB, 0x0022E4FC, 0x001CE0FC, 0x001CD2FC, 0x001CCCFA, 
        0x002287AD, 0x00787283, 0x0378C6BE, 0x00C6BEC2, 0x007AF0F5, 0x007AF0F5, 0x0046BED8, 0x003D5783, 0x00222248, 0x001C003B, 0x001C0038, 0x001C0038, 0x001C0038, 0x00220035, 0x001C0038, 0x001C0038, 0x001C0038, 0x001C0038, 0x001C0038, 0x001C0035, 
        0x001C0038, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C0035, 0x00150035, 0x00150035, 0x001C0035, 0x001C0035, 0x002B0048, 0x001C0035, 0x001C0035, 0x00150035, 0x00150035, 0x0015002E, 0x001C0038, 0x00150035, 
        0x00150035, 0x00150035, 0x001C003B, 0x001C003B, 0x001C003B, 0x001C0035, 0x001C0038, 0x001C0035, 0x001C0046, 0x00383B5F, 0x3422384A, 0xB5000000, 0xB7000000, 0xB9000000, 0xBB000000, 0xBB000000, 0xBB000000, 0xBD000000, 0xBD000000, 0xC1000000, 
        0xC4000000, 0xC9000000, 0xCE000000, 0xD6000000, 0xDD000000, 0xE5000000, 0xED000000, 0xF3000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x00220042, 0x001C003D, 0x00220040, 0x001C0035, 0x001C0066, 0x001C7EC8, 0x001C84E6, 0x001CADF5, 0x001CC1F8, 0x001CE0FC, 0x0032EBFF, 0x0032E6FA, 0x0032EBFF, 0x0022E6FE, 0x0032E6FA, 0x0032E6FA, 0x001CE0FB, 
        0x002287AD, 0x004A4062, 0x001C7EC8, 0x007AF0F5, 0x007AF0F5, 0x001CADF5, 0x001CADF5, 0x001C7EC8, 0x00226D89, 0x001C003B, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C0038, 0x001C0038, 0x001C0038, 
        0x001C0038, 0x001C0038, 0x001C0038, 0x001C0038, 0x001C003B, 0x001C003B, 0x001C003B, 0x001C003D, 0x001C003D, 0x001C003D, 0x00220040, 0x00220042, 0x002B0048, 0x00220042, 0x002B0048, 0x00222248, 0x0027154C, 0x0027154C, 0x0027154C, 0x002E3255, 
        0x00383B5F, 0x00383B5F, 0x00274057, 0x00383B5F, 0x00383B5F, 0x002E3255, 0x002E3255, 0x01273250, 0x00222248, 0x00220040, 0x00222248, 0x19222250, 0xC9000000, 0xCB000000, 0xCC000000, 0xCD000000, 0xCE000000, 0xCE000000, 0xD0000000, 0xD0000000, 
        0xD3000000, 0xD6000000, 0xDA000000, 0xDF000000, 0xE5000000, 0xEB000000, 0xF0000000, 0xF5000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x00220042, 0x001C003B, 0x001C0035, 0x00150038, 0x00222B99, 0x001C84E6, 0x001CADF5, 0x001CCBFB, 0x001CE0FC, 0x0032EBFF, 0x0022E4FC, 0x0040EDFC, 0x0040EDFC, 0x0022E9FF, 0x0040EDFC, 0x0022E4FC, 0x001CE0FB, 
        0x002EC3B9, 0x00220042, 0x00222B99, 0x001CD2FC, 0x001CCCFA, 0x001CADF5, 0x001C84E6, 0x001C84E6, 0x001C7EC8, 0x00274057, 0x0022003D, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C0038, 0x001C0035, 0x001C0038, 0x001C0038, 0x0027003D, 0x001C0038, 
        0x0022003D, 0x001C003B, 0x00220040, 0x0022003D, 0x00220040, 0x00220042, 0x001C0046, 0x0027154C, 0x00383B5F, 0x004A4062, 0x004A4062, 0x00485263, 0x292E675C, 0x1B2B3B55, 0x1B2B3B55, 0x1B2B3B55, 0x3422384A, 0x1B2B3B55, 0x1B2B3B55, 0xAE000000, 
        0xB1000000, 0xB6000000, 0xBB000000, 0xBD000000, 0xC1000000, 0xC4000000, 0xC8000000, 0xCB000000, 0xCD000000, 0x74000015, 0x3422384A, 0x00274057, 0x3422384A, 0xD9000000, 0xDB000000, 0xDC000000, 0xDD000000, 0xDD000000, 0xDE000000, 0xDF000000, 
        0xE2000000, 0xE3000000, 0xE5000000, 0xE9000000, 0xED000000, 0xF1000000, 0xF5000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x0022003D, 0x001C0038, 0x001C0038, 0x00222E8D, 0x001C84E6, 0x001CADF5, 0x001CC1F8, 0x001CD2FC, 0x0022E1FE, 0x0032EBFF, 0x0032EBFF, 0x0040EDFC, 0x0040EDFC, 0x0032EBFF, 0x0022E6FE, 0x001CE0FB, 0x0022E4FC, 
        0x0046BED8, 0x001C0046, 0x001C005A, 0x001C84E6, 0x002BC5F0, 0x002BC5F0, 0x001CADF5, 0x001CADF5, 0x001C84E6, 0x00225A6F, 0x001C003D, 0x001C003D, 0x001C0038, 0x001C0035, 0x001C0038, 0x001C003B, 0x001C003B, 0x001C003B, 0x001C003B, 0x00220042, 
        0x00220040, 0x0027154C, 0x002E3255, 0x004A4062, 0x00575970, 0x1B2B3B55, 0x1B2B3B55, 0x1B2B3B55, 0x3422384A, 0x81000015, 0x88000000, 0x8E000000, 0x91000000, 0x98000000, 0x9E000015, 0xA2000015, 0xAB000000, 0xAE000000, 0xB3000015, 0xB9000000, 
        0xBB000000, 0xC0000000, 0xC4000000, 0xC8000000, 0xCB000000, 0xCE000000, 0xD0000000, 0xD3000000, 0xD6000000, 0xD9000000, 0xDC000000, 0xDE000000, 0xE2000000, 0xE3000000, 0xE4000000, 0xE6000000, 0xE7000000, 0xE8000000, 0xE9000000, 0xE9000000, 
        0xEB000000, 0xEC000000, 0xEE000000, 0xF0000000, 0xF3000000, 0xF6000000, 0xF8000000, 0xFA000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x37001535, 0x001C0035, 0x001C0035, 0x001C003B, 0x00222E8D, 0x001C84E6, 0x001CADF5, 0x001CD2FC, 0x001CE0FC, 0x0022E9FF, 0x0032EBFF, 0x0022E9FF, 0x0032EBFF, 0x0022E4FC, 0x0032E6FA, 0x0032E6FA, 0x001CE0FB, 0x001CD2FC, 
        0x002BC5F0, 0x00225565, 0x00220040, 0x00222E8D, 0x001CADF5, 0x001CC1F8, 0x001CADF5, 0x001CADF5, 0x001CADF5, 0x00225A6F, 0x00220040, 0x001C0038, 0x0022003D, 0x0022003D, 0x00220042, 0x00220042, 0x002B0048, 0x002B0048, 0x002E3255, 0x002E3255, 
        0x19222250, 0x1B2B3B55, 0x3422384A, 0x66000000, 0x6C000000, 0x70000015, 0x79000000, 0x7F001515, 0x83000000, 0x8B000000, 0x90000015, 0x95000015, 0x9A000015, 0xA1000000, 0xA4000015, 0xAB000015, 0xAF000015, 0xB3000015, 0xB9000000, 0xBB000000, 
        0xC0000000, 0xC3000000, 0xC6000000, 0xC9000000, 0xCC000000, 0xD0000000, 0xD3000000, 0xD5000000, 0xD8000000, 0xDB000000, 0xDE000000, 0xE2000000, 0xE3000000, 0xE5000000, 0xE8000000, 0xE9000000, 0xEB000000, 0xED000000, 0xEE000000, 0xEF000000, 
        0xF1000000, 0xF2000000, 0xF4000000, 0xF5000000, 0xF7000000, 0xF9000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x37001535, 0x001C003B, 0x001C0035, 0x00222E8D, 0x001C84E6, 0x001CADF5, 0x001CCCFA, 0x0022E1FE, 0x0022E6FE, 0x0032EBFF, 0x0032EBFF, 0x0032EBFF, 0x0022E6FE, 0x0022E4FC, 0x0022E1FE, 0x0022E4FC, 0x001CE0FB, 0x001CD2FC, 
        0x001CCCFA, 0x0046BED8, 0x003D5783, 0x0027154C, 0x001C005A, 0x002276A3, 0x0046BED8, 0x001CADF5, 0x002BC5F0, 0x0046BED8, 0x0040818E, 0x00225565, 0x00383B5F, 0x00383B5F, 0x002E3255, 0x002E3255, 0x19222250, 0x37001535, 0x59000000, 0x5A000000, 
        0x5D000000, 0x60000000, 0x65000000, 0x6A000000, 0x70000015, 0x79000000, 0x7D000000, 0x83000000, 0x8B000000, 0x90000015, 0x95000015, 0x9A000015, 0x9E000015, 0xA2000015, 0xA7000015, 0xAB000015, 0xAF000015, 0xB3000015, 0xB5000000, 0xB9000000, 
        0xBB000000, 0xBD000000, 0xC1000000, 0xC4000000, 0xC8000000, 0xCB000000, 0xCD000000, 0xD0000000, 0xD3000000, 0xD6000000, 0xD9000000, 0xDC000000, 0xDF000000, 0xE2000000, 0xE4000000, 0xE7000000, 0xE9000000, 0xEC000000, 0xEE000000, 0xF0000000, 
        0xF2000000, 0xF4000000, 0xF6000000, 0xF8000000, 0xFA000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x1515153D, 0x00220042, 0x0027154C, 0x001C7EC8, 0x001CADF5, 0x001CCBFB, 0x0022E6FE, 0x0022E9FF, 0x0032EBFF, 0x0040EDFC, 0x0032EBFF, 0x0032EBFF, 0x0022E6FE, 0x0022E4FC, 0x001CE0FC, 0x001CE0FC, 0x001CD2FC, 0x001CD2FC, 
        0x001CC1F8, 0x001CC1F8, 0x001CADF5, 0x001C7EC8, 0x002276A3, 0x002B387A, 0x001C0066, 0x002E3255, 0x00223D5A, 0x19222250, 0x1B2B3B55, 0x1B2B3B55, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5B000000, 
        0x5F000000, 0x62000000, 0x66000000, 0x6C000000, 0x74000015, 0x7A000015, 0x80000000, 0x88000000, 0x8B001515, 0x90000015, 0x95000015, 0x9A000015, 0x9E000015, 0xA1000000, 0xA2000015, 0xA4000015, 0xA7000015, 0xAB000015, 0xAB000015, 0xAF000015, 
        0xB1000000, 0xB3000015, 0xB6000000, 0xB9000000, 0xBB000000, 0xBD000000, 0xC1000000, 0xC4000000, 0xC8000000, 0xCB000000, 0xCE000000, 0xD0000000, 0xD5000000, 0xD8000000, 0xDC000000, 0xDF000000, 0xE3000000, 0xE6000000, 0xE9000000, 0xEC000000, 
        0xEF000000, 0xF2000000, 0xF5000000, 0xF8000000, 0xFA000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x00220042, 0x001C003B, 0x002B387A, 0x001C84E6, 0x001CADF5, 0x001CE0FC, 0x0022E6FE, 0x0032EBFF, 0x0040EDFC, 0x0032EBFF, 0x0040EDFC, 0x0040EDFC, 0x0022E4FC, 0x0022E1FE, 0x0022E4FC, 0x001CD2FC, 0x001CD2FC, 0x001CCCFA, 
        0x001CC1F8, 0x001CC1F8, 0x001CADF5, 0x001CADF5, 0x001C84E6, 0x00226D89, 0x00223D66, 0x19222250, 0x37001535, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x5A000000, 0x5B000000, 
        0x5F000000, 0x62000000, 0x67000000, 0x6C000000, 0x74000015, 0x7A000015, 0x80000000, 0x85000000, 0x8B000000, 0x8E000000, 0x90000015, 0x94001515, 0x95000015, 0x98000000, 0x9A000015, 0x9A000015, 0x9C000000, 0x9E000015, 0x9E000015, 0xA2000015, 
        0xA2000015, 0xA4000015, 0xA7000015, 0xA7000015, 0xAB000015, 0xAF000015, 0xB1000000, 0xB5000000, 0xB9000000, 0xBB000000, 0xC0000000, 0xC3000000, 0xC8000000, 0xCB000000, 0xCE000000, 0xD3000000, 0xD8000000, 0xDC000000, 0xE2000000, 0xE5000000, 
        0xEA000000, 0xEE000000, 0xF2000000, 0xF5000000, 0xF8000000, 0xFA000000, 0xFC000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x001C0038, 0x001C0046, 0x001C7EC8, 0x001CADF5, 0x001CD2FC, 0x0022E9FF, 0x0022E6FE, 0x0032EBFF, 0x0032EBFF, 0x0022E9FF, 0x0032EBFF, 0x0032EBFF, 0x0022E4FC, 0x001CE0FC, 0x001CD2FC, 0x001CCCFA, 0x001CCBFB, 0x001CC1F8, 
        0x001CADF5, 0x001CADF5, 0x001C84E6, 0x001C7EC8, 0x002276A3, 0x01273250, 0x37001535, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x5A000000, 0x5B000000, 
        0x5F000000, 0x62000000, 0x67000000, 0x6C000000, 0x73000000, 0x79000000, 0x7D000000, 0x81000015, 0x83000000, 0x88000000, 0x88000000, 0x8B001515, 0x8B001515, 0x8B001515, 0x8B001515, 0x8E000000, 0x8E000000, 0x90000015, 0x90000015, 0x90000015, 
        0x94001515, 0x94001515, 0x95000015, 0x9A000015, 0x9A000015, 0x9E000015, 0xA2000015, 0xA4000015, 0xA7000015, 0xAB000000, 0xAF000015, 0xB3000015, 0xB7000000, 0xBB000000, 0xC0000000, 0xC4000000, 0xCB000000, 0xD0000000, 0xD5000000, 0xDB000000, 
        0xE2000000, 0xE7000000, 0xEC000000, 0xF1000000, 0xF5000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x8B224040, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x001C0035, 0x001C0066, 0x001C84E6, 0x001CC1F8, 0x001CE0FC, 0x0032EBFF, 0x0022E9FF, 0x0040EDFC, 0x0032EBFF, 0x0032EBFF, 0x0032EBFF, 0x0040EDFC, 0x0022E4FC, 0x001CE0FB, 0x001CC1F8, 0x001CC1F8, 0x001CC1F8, 0x001CADF5, 
        0x001C84E6, 0x001C84E6, 0x001C7EC8, 0x00222B99, 0x00223D5A, 0x37001535, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5B000000, 
        0x5D000000, 0x62000000, 0x65000000, 0x69000000, 0x6E000000, 0x74000015, 0x79000000, 0x7A000015, 0x7D000000, 0x7F001515, 0x7F001515, 0x80000000, 0x81000015, 0x81000015, 0x81000015, 0x81000015, 0x81000015, 0x81000015, 0x83000000, 0x83000000, 
        0x85000000, 0x88000015, 0x88000015, 0x8B001515, 0x8E000000, 0x90000015, 0x91000000, 0x95000015, 0x9A000015, 0x9C000000, 0xA1000000, 0xA4000015, 0xA7000015, 0xAE000000, 0xB3000015, 0xB7000000, 0xBD000000, 0xC3000000, 0xC9000000, 0xD0000000, 
        0xD8000000, 0xDE000000, 0xE5000000, 0xEB000000, 0xF1000000, 0xF5000000, 0xF9000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x004C9987, 0x0035C397, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0x37001535, 0x001C0046, 0x001C7EC8, 0x001CADF5, 0x001CC1F8, 0x0022E4FC, 0x0022E1FE, 0x0032EBFF, 0x0040EDFC, 0x0032EBFF, 0x0032EBFF, 0x0040EDFC, 0x0040EDFC, 0x001CD2FC, 0x001CD2FC, 0x001CCBFB, 0x001CC1F8, 0x001CADF5, 0x001CADF5, 
        0x001C84E6, 0x001C7EC8, 0x001C7EC8, 0x00222B99, 0x00223D5A, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5B000000, 
        0x5D000000, 0x5F000000, 0x63000000, 0x66000000, 0x6A000000, 0x6E000000, 0x70000000, 0x73000000, 0x74000015, 0x75000000, 0x75000000, 0x75000000, 0x75000000, 0x79000000, 0x79000000, 0x79000000, 0x79000000, 0x7A000015, 0x7A000015, 0x7A000015, 
        0x7D000000, 0x7F001515, 0x81000015, 0x81000015, 0x83000000, 0x85000000, 0x88000015, 0x8B001515, 0x90000015, 0x91000000, 0x95000015, 0x9A000015, 0x9E000015, 0xA2000015, 0xA7000015, 0xAE000000, 0xB3000015, 0xB9000000, 0xC0000000, 0xC6000000, 
        0xCE000000, 0xD5000000, 0xDD000000, 0xE5000000, 0xEC000000, 0xF2000000, 0xF6000000, 0xFA000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x00427B7F, 0x002EC3AC, 0x0E4C9C84, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0x1515153D, 0x002B387A, 0x001C84E6, 0x001CADF5, 0x001CD2FC, 0x0022E6FE, 0x0032EBFF, 0x0022E6FE, 0x0022E9FF, 0x0040EDFC, 0x0040EDFC, 0x0032EBFF, 0x0022E9FF, 0x0022E4FC, 0x001CE0FC, 0x001CD2FC, 0x001CCBFB, 0x001CCBFB, 0x001CADF5, 
        0x001C84E6, 0x001C84E6, 0x001C7EC8, 0x002276A3, 0x01273250, 0x58000000, 0x58000000, 0x58000000, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 
        0x5C000000, 0x5F000000, 0x62000000, 0x65000000, 0x67000000, 0x69000000, 0x6C000000, 0x6C000000, 0x6E000000, 0x70000000, 0x70000000, 0x70000000, 0x70000015, 0x73000000, 0x73000000, 0x74000015, 0x74000015, 0x75000000, 0x79000000, 0x79000000, 
        0x7A000015, 0x7D000000, 0x7F001515, 0x81000015, 0x81000015, 0x83000000, 0x88000015, 0x88000015, 0x8B001515, 0x90000015, 0x94001515, 0x95000015, 0x9A000015, 0x9E000015, 0xA2000015, 0xA7000015, 0xAE000000, 0xB3000015, 0xB9000000, 0xC0000000, 
        0xC8000000, 0xCE000000, 0xD8000000, 0xE0000000, 0xE8000000, 0xEF000000, 0xF4000000, 0xF9000000, 0xFC000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0x292E675C, 0x0027B498, 0x002EE4BA, 0x2D447278, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x90000015, 0x00220042, 0x001C7EC8, 0x001CADF5, 0x001CCBFB, 0x0022E1FE, 0x0032EBFF, 0x0022E9FF, 0x0032EBFF, 0x0032EBFF, 0x0040EDFC, 0x0032EBFF, 0x0032EBFF, 0x0032EBFF, 0x0032EBFF, 0x001CE0FC, 0x0022E4FC, 0x001CE0FC, 0x001CCBFB, 0x001CADF5, 
        0x001CADF5, 0x001C84E6, 0x001C84E6, 0x002276A3, 0x0027154C, 0x02221C46, 0x1515153D, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 
        0x5D000000, 0x5F000000, 0x62000000, 0x63000000, 0x65000000, 0x69000000, 0x69000000, 0x6C000000, 0x6C000000, 0x6C000000, 0x70000000, 0x70000000, 0x70000015, 0x73000000, 0x74000015, 0x74000015, 0x79000000, 0x7A000015, 0x7A000015, 0x7D000000, 
        0x7F001515, 0x81000015, 0x83000000, 0x85000000, 0x88000015, 0x8B001515, 0x8B001515, 0x8E000000, 0x90000015, 0x94001515, 0x98000000, 0x9A000015, 0x9E000015, 0xA2000015, 0xA7000015, 0xAB000015, 0xAF000015, 0xB3000015, 0xB9000000, 0xBD000000, 
        0xC4000000, 0xCC000000, 0xD5000000, 0xDD000000, 0xE5000000, 0xEC000000, 0xF3000000, 0xF7000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x8B224040, 0x0027B498, 0x002EC3AC, 0x0146C3A8, 0x292E675C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x1515153D, 0x002B387A, 0x001CADF5, 0x001CCBFB, 0x001CCBFB, 0x0022E4FC, 0x0022E6FE, 0x0022E9FF, 0x0032EBFF, 0x0032EBFF, 0x0040EDFC, 0x0040EDFC, 0x0032EBFF, 0x0032EBFF, 0x0040EDFC, 0x0022E4FC, 0x001CE0FB, 0x001CD2FC, 0x001CCBFB, 0x001CC1F8, 
        0x001CADF5, 0x001CADF5, 0x001C84E6, 0x001C7EC8, 0x00223D66, 0x00220042, 0x0027154C, 0x02221C46, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5D000000, 
        0x5F000000, 0x62000000, 0x63000000, 0x65000000, 0x67000000, 0x6A000000, 0x6C000000, 0x6C000000, 0x70000000, 0x70000000, 0x73000000, 0x75000000, 0x79000000, 0x7A000015, 0x7A000015, 0x7D000000, 0x81000015, 0x81000015, 0x85000000, 0x88000015, 
        0x8B001515, 0x8E000000, 0x90000015, 0x91000000, 0x94001515, 0x95000015, 0x98000000, 0x9A000015, 0x9C000000, 0x9E000015, 0xA2000015, 0xA4000015, 0xA7000015, 0xAB000000, 0xAF000015, 0xB1000000, 0xB5000000, 0xB9000000, 0xBD000000, 0xC3000000, 
        0xC8000000, 0xCE000000, 0xD5000000, 0xDD000000, 0xE5000000, 0xEC000000, 0xF2000000, 0xF7000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x00449582, 0x0035C397, 0x002EC3B9, 0x004CAE84, 0x2D447278, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x001C003B, 0x001C7EC8, 0x001CC1F8, 0x001CCBFB, 0x001CD2FC, 0x0022E1FE, 0x0022E4FC, 0x0022E1FE, 0x0032EBFF, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0032EBFF, 0x0040EDFC, 0x0022E6FE, 0x001CE0FC, 0x001CE0FC, 0x001CCBFB, 0x001CC1F8, 
        0x001CADF5, 0x001CADF5, 0x001CADF5, 0x001C84E6, 0x002B387A, 0x00220042, 0x00220042, 0x002B0048, 0x02221C46, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5C000000, 0x5F000000, 0x62000000, 
        0x63000000, 0x66000000, 0x69000000, 0x6C000000, 0x6E000000, 0x70000000, 0x73000000, 0x75000000, 0x79000000, 0x7A000015, 0x7D000000, 0x80000000, 0x83000000, 0x85000000, 0x88000000, 0x8B000000, 0x8E000000, 0x91000000, 0x95000015, 0x98000000, 
        0x9A000015, 0x9E000015, 0xA1000000, 0xA2000015, 0xA4000015, 0xA7000015, 0xA7000015, 0xAB000000, 0xAE000000, 0xAF000015, 0xB1000000, 0xB5000000, 0xB7000000, 0xBB000000, 0xBB000000, 0xC0000000, 0xC1000000, 0xC4000000, 0xC6000000, 0xCB000000, 
        0xCE000000, 0xD3000000, 0xD9000000, 0xE0000000, 0xE6000000, 0xED000000, 0xF3000000, 0xF7000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x2D447278, 
        0x002EE1AD, 0x0035C397, 0x002EE4C8, 0x004CAE84, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x0027154C, 0x001C84E6, 0x001CC1F8, 0x001CCCFA, 0x001CCCFA, 0x0022E1FE, 0x001CE0FC, 0x0032EBFF, 0x0032EBFF, 0x0032EBFF, 0x0040EDFC, 0x0032EBFF, 0x0040EDFC, 0x0032EBFF, 0x0032EBFF, 0x0032EBFF, 0x0022E4FC, 0x001CD2FC, 0x001CE0FC, 0x001CD2FC, 
        0x001CC1F8, 0x001CC1F8, 0x001CADF5, 0x001C84E6, 0x002276A3, 0x00220042, 0x00220040, 0x001C0046, 0x0027154C, 0x01273250, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5F000000, 0x60000000, 0x63000000, 0x67000000, 
        0x6A000000, 0x6E000000, 0x73000000, 0x75000000, 0x79000000, 0x7A000015, 0x7D000000, 0x81000015, 0x83000000, 0x88000000, 0x8B000000, 0x8E000000, 0x91000000, 0x95000000, 0x9A000015, 0x9E000015, 0xA2000015, 0xA4000015, 0xA7000015, 0xAB000000, 
        0xAE000000, 0xB1000000, 0xB3000015, 0xB6000000, 0xB9000000, 0xBB000000, 0xBB000000, 0xBD000000, 0xC0000000, 0xC1000000, 0xC3000000, 0xC6000000, 0xC8000000, 0xCB000000, 0xCC000000, 0xCE000000, 0xCE000000, 0xD0000000, 0xD3000000, 0xD5000000, 
        0xD8000000, 0xDB000000, 0xDF000000, 0xE4000000, 0xEA000000, 0xEF000000, 0xF4000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0035A48F, 0x0022786F, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x292E675C, 0x0027B498, 
        0x0046D69A, 0x002EC3B9, 0x002EE4C8, 0x0022A474, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 
        0x00222B99, 0x001CADF5, 0x001CD2FC, 0x001CE0FC, 0x0022E1FE, 0x0022E1FE, 0x0032EBFF, 0x001CE0FC, 0x0032EBFF, 0x0022E1FE, 0x0040EDFC, 0x0040EDFC, 0x0032EBFF, 0x0032EBFF, 0x0022E6FE, 0x0032EBFF, 0x0022E6FE, 0x0022E6FE, 0x0032E6FA, 0x001CE0FC, 
        0x001CC1F8, 0x001CC1F8, 0x001CC1F8, 0x001CADF5, 0x001C7EC8, 0x002E3255, 0x00220040, 0x0022003D, 0x0027003D, 0x002B0048, 0x002E3255, 0x58000000, 0x59000000, 0x5A000000, 0x5C000000, 0x5F000000, 0x62000000, 0x66000000, 0x6A000000, 0x70000000, 
        0x75000000, 0x7A000015, 0x80000000, 0x83000000, 0x88000000, 0x8B000000, 0x8E000000, 0x91000000, 0x95000000, 0x9A000015, 0x9C000000, 0xA1000000, 0xA7000000, 0xAB000000, 0xAE000000, 0xB1000000, 0xB5000000, 0xB9000000, 0xBB000000, 0xC0000000, 
        0xC3000000, 0xC4000000, 0xC8000000, 0xC9000000, 0xCB000000, 0xCD000000, 0xCE000000, 0xCE000000, 0xD0000000, 0xD3000000, 0xD3000000, 0xD6000000, 0xD8000000, 0xDA000000, 0xDB000000, 0xDC000000, 0xDD000000, 0xDE000000, 0xDF000000, 0xE0000000, 
        0xE2000000, 0xE4000000, 0xE7000000, 0xEB000000, 0xEF000000, 0xF3000000, 0xF6000000, 0xFA000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EC3B9, 0x002EC3AC, 0x00229A7E, 0x00276B62, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x8B224040, 0x0035A48F, 0x002EE4BA, 
        0x0035C397, 0x002EE6D4, 0x002EE1AD, 0x292E675C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFC000000, 0xFB000000, 0xFB000000, 0xFB000000, 0xFB000000, 0xFC000000, 0xFD000000, 
        0x001C7EC8, 0x001CCCFA, 0x001CE0FC, 0x001CC1F8, 0x001CE0FC, 0x0032EBFF, 0x0022E1FE, 0x0022E6FE, 0x0022E1FE, 0x0032EBFF, 0x0032EBFF, 0x0040EDFC, 0x0032EBFF, 0x0040EDFC, 0x0032EBFF, 0x0022E9FF, 0x0022E9FF, 0x001CE0FB, 0x001CE0FC, 0x001CE0FC, 
        0x001CCCFA, 0x001CC1F8, 0x001CADF5, 0x001CADF5, 0x001C84E6, 0x003D5783, 0x00220040, 0x00220040, 0x00220040, 0x00220042, 0x002B0048, 0x02221C46, 0x59000000, 0x5B000000, 0x5F000000, 0x62000000, 0x67000000, 0x6C000000, 0x74000015, 0x7A000015, 
        0x83000000, 0x88000000, 0x8E000000, 0x95000000, 0x98000000, 0x9E000015, 0xA2000015, 0xA7000000, 0xAB000000, 0xAE000000, 0xB1000000, 0xB6000000, 0xBB000000, 0xBD000000, 0xC3000000, 0xC4000000, 0xC9000000, 0xCC000000, 0xCE000000, 0xD3000000, 
        0xD3000000, 0xD8000000, 0xD9000000, 0xDB000000, 0xDC000000, 0xDD000000, 0xDE000000, 0xDF000000, 0xE2000000, 0xE2000000, 0xE3000000, 0xE4000000, 0xE6000000, 0xE7000000, 0xE8000000, 0xE9000000, 0xE9000000, 0xE9000000, 0xEA000000, 0xEA000000, 
        0xEB000000, 0xEC000000, 0xEE000000, 0xF1000000, 0xF3000000, 0xF6000000, 0xF9000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EC3B9, 0x002EE4C8, 0x002EE4BA, 0x002EC3AC, 0x00229A7E, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x0E4C9C84, 0x002EE4BA, 0x0046D69A, 
        0x002EC3B9, 0x0032EADC, 0x0035C397, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xFA000000, 0xF8000000, 0xF7000000, 0xF7000000, 0xF7000000, 0xF9000000, 0xFA000000, 0xFB000000, 
        0x001C7EC8, 0x0022E1FE, 0x001CC1F8, 0x001CD2FC, 0x0022E1FE, 0x0022E1FE, 0x0022E1FE, 0x0022E6FE, 0x0032EBFF, 0x0032EBFF, 0x0022E6FE, 0x0040EDFC, 0x0032EBFF, 0x0032EBFF, 0x0022E1FE, 0x0022E6FE, 0x0022E9FF, 0x001CE0FB, 0x001CD2FC, 0x001CE0FB, 
        0x001CCCFA, 0x001CC1F8, 0x001CADF5, 0x001CC1F8, 0x001CADF5, 0x002276A3, 0x001C0046, 0x0022003D, 0x00220040, 0x00220042, 0x002B0048, 0x002B0048, 0x02221C46, 0x5D000000, 0x62000000, 0x66000000, 0x6C000000, 0x75000000, 0x7D000000, 0x88000000, 
        0x91000000, 0x98000000, 0xA1000000, 0xA7000000, 0xAE000000, 0xB1000000, 0xB6000000, 0xBB000000, 0xBD000000, 0xC3000000, 0xC6000000, 0xCB000000, 0xCD000000, 0xD0000000, 0xD3000000, 0xD8000000, 0xDA000000, 0xDD000000, 0xDF000000, 0xE2000000, 
        0xE3000000, 0xE5000000, 0xE7000000, 0xE8000000, 0xE9000000, 0xEA000000, 0xEB000000, 0xEC000000, 0xED000000, 0xEE000000, 0xEE000000, 0xEF000000, 0xF0000000, 0xF1000000, 0xF2000000, 0xF2000000, 0xF2000000, 0xF2000000, 0xF2000000, 0xF3000000, 
        0xF3000000, 0xF3000000, 0xF4000000, 0xF6000000, 0xF7000000, 0xF9000000, 0xFB000000, 0xFC000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EE1AD, 0x002EE4BA, 0x002EE4C8, 0x002EE4C8, 0x002EE1AD, 0x00277D62, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x2D447278, 0x002EC3AC, 0x002EE4BA, 0x0046B497, 
        0x002EE6D4, 0x0032EADC, 0x003BBA87, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xFA000000, 0xF8000000, 0xF6000000, 0xF4000000, 0xF2000000, 0xF2000000, 0xF3000000, 0xF4000000, 0xF7000000, 0x90000015, 
        0x001C7EC8, 0x001CE0FC, 0x001CCBFB, 0x001CCCFA, 0x001CE0FC, 0x0022E1FE, 0x0022E9FF, 0x0022E1FE, 0x0022E9FF, 0x0022E4FC, 0x0022E6FE, 0x0032EBFF, 0x0022E6FE, 0x0040EDFC, 0x0022E4FC, 0x0032EBFF, 0x0022E6FE, 0x001CE0FB, 0x001CD2FC, 0x001CE0FB, 
        0x001CD2FC, 0x001CC1F8, 0x001CADF5, 0x001CC1F8, 0x001CADF5, 0x001C7EC8, 0x00224060, 0x00220040, 0x00220042, 0x0022003D, 0x0027003D, 0x00220040, 0x002B0048, 0x0027154C, 0x65000000, 0x6A000000, 0x73000000, 0x7D000000, 0x88000000, 0x95000000, 
        0xA1000000, 0xAB000000, 0xB3000015, 0xBB000000, 0xC0000000, 0xC4000000, 0xCB000000, 0xCD000000, 0xD0000000, 0xD3000000, 0xD8000000, 0xDB000000, 0xDE000000, 0xE0000000, 0xE3000000, 0xE5000000, 0xE8000000, 0xEA000000, 0xEB000000, 0xED000000, 
        0xEF000000, 0xF0000000, 0xF1000000, 0xF2000000, 0xF3000000, 0xF3000000, 0xF4000000, 0xF5000000, 0xF5000000, 0xF6000000, 0xF6000000, 0xF7000000, 0xF7000000, 0xF8000000, 0xF8000000, 0xF8000000, 0xF9000000, 0xF9000000, 0xF8000000, 0xF8000000, 
        0xF8000000, 0xF9000000, 0xF9000000, 0xFA000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0042E4B3, 0x002EE1AD, 0x002EE4BA, 0x002EE4BA, 0x002EE4C8, 0x0035C397, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x00427B7F, 0x002EE4BA, 0x0046D69A, 0x002EC3AC, 
        0x002EE6D4, 0x002EE6D4, 0x2D447278, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xFA000000, 0xF7000000, 0xF4000000, 0xF0000000, 0xED000000, 0xEB000000, 0xEB000000, 0xEC000000, 0xEF000000, 0xF3000000, 0x1515153D, 
        0x0046BED8, 0x0022E1FE, 0x001CCBFB, 0x001CD2FC, 0x0022E6FE, 0x0022E6FE, 0x0032EBFF, 0x0022E6FE, 0x0022E6FE, 0x0022E6FE, 0x0022E6FE, 0x0032EBFF, 0x0022E4FC, 0x0032EBFF, 0x001CE0FC, 0x0032EBFF, 0x0022E4FC, 0x001CE0FB, 0x001CE0FC, 0x001CE0FB, 
        0x001CC1F8, 0x001CC1F8, 0x001CC1F8, 0x001CCCFA, 0x001CADF5, 0x001C84E6, 0x00222E8D, 0x00220040, 0x00220042, 0x0022003D, 0x00220042, 0x0022003D, 0x00220042, 0x0027154C, 0x00383B5F, 0x6E000000, 0x79000000, 0x85000000, 0x94001515, 0xA1000000, 
        0xAE000000, 0xB9000000, 0xC3000000, 0xCB000000, 0xD0000000, 0xD6000000, 0xDA000000, 0xDE000000, 0xE0000000, 0xE3000000, 0xE6000000, 0xE8000000, 0xEA000000, 0xEC000000, 0xEE000000, 0xF0000000, 0xF2000000, 0xF3000000, 0xF4000000, 0xF5000000, 
        0xF6000000, 0xF7000000, 0xF8000000, 0xF8000000, 0xF9000000, 0xF9000000, 0xFA000000, 0xFA000000, 0xFA000000, 0xFB000000, 0xFB000000, 0xFB000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFC000000, 
        0xFC000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EE1AD, 0x0042E4B3, 0x0046D69A, 0x002EE4BA, 0x002EE6D4, 0x002EE4C8, 0x0022A474, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x292E675C, 0x002EB1A3, 0x002EE4BA, 0x0046B497, 0x002EE4C8, 
        0x0042EBDA, 0x004CEAC9, 0x2D447278, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xFA000000, 0xF7000000, 0xF3000000, 0xEE000000, 0xE9000000, 0xE5000000, 0xE3000000, 0xE3000000, 0xE5000000, 0xE9000000, 0x88000015, 0x001C003D, 
        0x001C7EC8, 0x0022E6FE, 0x001CE0FC, 0x001CD2FC, 0x0022E6FE, 0x0022E6FE, 0x0032EBFF, 0x0022E6FE, 0x0022E6FE, 0x0022E9FF, 0x0022E6FE, 0x0032EBFF, 0x0022E9FF, 0x0022E6FE, 0x0022E4FC, 0x0022E9FF, 0x0022E4FC, 0x001CE0FC, 0x001CE0FC, 0x001CE0FC, 
        0x001CCCFA, 0x001CCCFA, 0x001CC1F8, 0x001CD2FC, 0x001CADF5, 0x001C84E6, 0x001C7EC8, 0x001C0046, 0x00220042, 0x001C003D, 0x00220042, 0x00220042, 0x001C0038, 0x0027154C, 0x002B0048, 0x002E3255, 0x7D000000, 0x8B000000, 0x9A000015, 0xAB000000, 
        0xB9000000, 0xC4000000, 0xCE000000, 0xD8000000, 0xDE000000, 0xE3000000, 0xE7000000, 0xEA000000, 0xEC000000, 0xEE000000, 0xF0000000, 0xF2000000, 0xF3000000, 0xF5000000, 0xF6000000, 0xF7000000, 0xF8000000, 0xF9000000, 0xFA000000, 0xFA000000, 
        0xFB000000, 0xFB000000, 0xFC000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 
        0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0027B498, 0x002EE1AD, 0x002EE1AD, 0x0027D297, 0x002EE4BA, 0x002EE6D4, 0x002EE1AD, 0x2D447278, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0x003B7E72, 0x002EC3AC, 0x002EC3AC, 0x002EB1A3, 0x0032EADC, 
        0x0032EADC, 0x002EE1AD, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xF7000000, 0xF3000000, 0xED000000, 0xE6000000, 0xE0000000, 0xDB000000, 0xD9000000, 0xD9000000, 0xDD000000, 0xE2000000, 0x37001535, 0x001C0038, 
        0x0046BED8, 0x0022E9FF, 0x001CC1F8, 0x001CD2FC, 0x0022E6FE, 0x0022E1FE, 0x0032EBFF, 0x0032EBFF, 0x0022E6FE, 0x0032EBFF, 0x0032EBFF, 0x0022E9FF, 0x001CE0FC, 0x0022E9FF, 0x0022E9FF, 0x0022E6FE, 0x0022E9FF, 0x0022E9FF, 0x001CE0FC, 0x001CD2FC, 
        0x001CD2FC, 0x001CD2FC, 0x001CD2FC, 0x001CD2FC, 0x001CC1F8, 0x001CADF5, 0x001C7EC8, 0x001C005A, 0x00220042, 0x00220040, 0x00220042, 0x00220040, 0x0022003D, 0x002B0048, 0x00220040, 0x0027154C, 0x37001535, 0x8E000000, 0x9C000000, 0xAE000000, 
        0xBD000000, 0xCB000000, 0xD6000000, 0xDF000000, 0xE6000000, 0xEC000000, 0xEF000000, 0xF2000000, 0xF4000000, 0xF6000000, 0xF7000000, 0xF8000000, 0xF9000000, 0xFA000000, 0xFB000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFD000000, 
        0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x04274655, 0x002EC3AC, 0x002EE1AD, 0x0042E4B3, 0x0035C397, 0x002EE4C8, 0x002EE4BA, 0x003BBA87, 0xFE000000, 0xFD000000, 0xFC000000, 0xFB000000, 0x0035A48F, 0x002EC3B9, 0x0027B498, 0x002EC3B9, 0x0032EADC, 
        0x0032EADC, 0x0022BC83, 0xFE000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xF8000000, 0xF3000000, 0xED000000, 0xE5000000, 0xDD000000, 0xD6000000, 0xD0000000, 0xCE000000, 0xD0000000, 0xD5000000, 0xDC000000, 0x37001535, 0x001C003B, 
        0x001C7EC8, 0x0022E1FE, 0x001CC1F8, 0x001CC1F8, 0x001CD2FC, 0x001CCBFB, 0x0022E9FF, 0x0022E4FC, 0x0022E6FE, 0x0032EBFF, 0x0032EBFF, 0x0022E4FC, 0x0022E4FC, 0x0022E1FE, 0x0022E6FE, 0x001CD2FC, 0x001CE0FB, 0x0022E4FC, 0x001CD2FC, 0x001CE0FC, 
        0x001CCCFA, 0x001CE0FB, 0x001CE0FC, 0x001CD2FC, 0x001CC1F8, 0x001CADF5, 0x001C84E6, 0x002B387A, 0x001C0046, 0x0027003D, 0x00220042, 0x00220040, 0x00220042, 0x002B0048, 0x00220042, 0x002B0048, 0x00383B5F, 0x8B000000, 0x9C000000, 0xAB000000, 
        0xBB000000, 0xCB000000, 0xD8000000, 0xE2000000, 0xEA000000, 0xF0000000, 0xF4000000, 0xF7000000, 0xF9000000, 0xFA000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0x0022757D, 0x002EE1AD, 0x002EE1AD, 0x002EE1AD, 0x002EC3AC, 0x002EE4C8, 0x002EE1AD, 0x2D447278, 0xFB000000, 0xFA000000, 0x3422384A, 0x002EB1A3, 0x0146C3A8, 0x0035A48F, 0x002EE6D4, 0x002EE6D4, 
        0x002EE4C8, 0x8B224040, 0xFC000000, 0xFD000000, 0xFD000000, 0xFC000000, 0x8B224040, 0x292E675C, 0x003B7E72, 0x003B7E72, 0x00449582, 0x00229A7E, 0x00229A7E, 0x00449582, 0x00449582, 0x003B7E72, 0x003B7E72, 0x292E675C, 0x0022384C, 0x0015002E, 
        0x001C7EC8, 0x001CD2FC, 0x001CD2FC, 0x001CC1F8, 0x001CC1F8, 0x0022E1FE, 0x0022E4FC, 0x0022E6FE, 0x0032EBFF, 0x0032EBFF, 0x0022E9FF, 0x0022E6FE, 0x0022E4FC, 0x0022E6FE, 0x0032EBFF, 0x001CE0FC, 0x001CD2FC, 0x0022E6FE, 0x001CD2FC, 0x001CE0FC, 
        0x001CCCFA, 0x001CE0FC, 0x001CE0FC, 0x001CCCFA, 0x001CC1F8, 0x001CADF5, 0x001C84E6, 0x00272E90, 0x0027154C, 0x00220042, 0x00220042, 0x001C0038, 0x00220042, 0x002B0048, 0x00220042, 0x002B0048, 0x002B0048, 0x1B2B3B55, 0x95000000, 0xA7000000, 
        0xB7000000, 0xC6000000, 0xD3000000, 0xDF000000, 0xE8000000, 0xEF000000, 0xF4000000, 0xF8000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0x8B224040, 0x002EB1A3, 0x002EE1AD, 0x002EE4BA, 0x0027D297, 0x002EC3AC, 0x002EC3B9, 0x0035A48F, 0xF9000000, 0xF6000000, 0x3422384A, 0x002EB1A3, 0x0027B498, 0x002EB1A3, 0x002EE6D4, 0x002EE6D4, 
        0x0027D297, 0xF7000000, 0xF9000000, 0x8B224040, 0x00226760, 0x00449582, 0x0035A48F, 0x0027B498, 0x002EB1A3, 0x002EB1A3, 0x002EC3AC, 0x002EC3AC, 0x002EB1A3, 0x002EB1A3, 0x0035A48F, 0x0035A48F, 0x002EB1A3, 0x0035A48F, 0x0022384C, 0x0015002E, 
        0x002276A3, 0x001CD2FC, 0x001CE0FC, 0x001CADF5, 0x001CADF5, 0x0022E1FE, 0x001CD2FC, 0x0022E1FE, 0x0022E9FF, 0x0022E6FE, 0x0022E6FE, 0x0022E1FE, 0x0022E6FE, 0x0022E6FE, 0x0022E4FC, 0x001CE0FC, 0x001CE0FB, 0x0022E4FC, 0x001CD2FC, 0x001CE0FC, 
        0x001CE0FC, 0x001CD2FC, 0x0022E4FC, 0x001CD2FC, 0x001CCCFA, 0x001CC1F8, 0x001CADF5, 0x00222B99, 0x001C0066, 0x0022003D, 0x00220040, 0x00220040, 0x00220042, 0x0022003D, 0x0022003D, 0x00220042, 0x002B0048, 0x0027154C, 0x8E000000, 0x9C000000, 
        0xAE000000, 0xBB000000, 0xCB000000, 0xD8000000, 0xE2000000, 0xEB000000, 0xF2000000, 0xF7000000, 0xFA000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0x0022757D, 0x002EE1AD, 0x002EE4BA, 0x002EE1AD, 0x0035C397, 0x002EC3AC, 0x002EC3AC, 0x8B224040, 0xF1000000, 0x292E675C, 0x0027B498, 0x002BA485, 0x002EC3B9, 0x002EE6D4, 0x002EE4C8, 
        0x2D447278, 0x8B224040, 0x2D447278, 0x00449582, 0x002EB1A3, 0x002EC3B9, 0x002EC3B9, 0x002EB1A3, 0x0035A48F, 0x002EB1A3, 0x002EB1A3, 0x002EB1A3, 0x002EB1A3, 0x002EC3AC, 0x002EC3AC, 0x002EC3AC, 0x002EC3AC, 0x0146C3A8, 0x01223D4C, 0x0015002E, 
        0x00222E8D, 0x0022E4FC, 0x001CD2FC, 0x001CADF5, 0x001CC1F8, 0x001CCBFB, 0x001CD2FC, 0x001CE0FC, 0x0022E9FF, 0x0022E6FE, 0x0022E6FE, 0x0022E1FE, 0x0022E1FE, 0x0022E4FC, 0x001CE0FC, 0x001CE0FC, 0x0022E6FE, 0x001CE0FB, 0x001CE0FC, 0x001CD2FC, 
        0x001CE0FB, 0x001CE0FC, 0x001CE0FB, 0x001CD2FC, 0x001CD2FC, 0x001CCCFA, 0x002BC5F0, 0x002276A3, 0x01221C8D, 0x001C0046, 0x0027003D, 0x00220040, 0x00220040, 0x00220042, 0x00220042, 0x00220040, 0x002B0048, 0x002B0048, 0x1B2B3B55, 0x91000000, 
        0xA1000000, 0xB1000000, 0xC0000000, 0xCD000000, 0xD9000000, 0xE4000000, 0xED000000, 0xF3000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x0035A48F, 0x002EE4BA, 0x002EE4BA, 0x0027D297, 0x0027B498, 0x002EC3AC, 0x0E4C9C84, 0xEB000000, 0x292E675C, 0x0035A48F, 0x00229A7E, 0x002EE6D4, 0x002EE6D4, 0x0027B498, 
        0xE5000000, 0x0027B498, 0x0042EBDA, 0x002EC3B9, 0x002EC3B9, 0x002EC3B9, 0x002EE4C8, 0x002EE4C8, 0x002EE4C8, 0x002EE6D4, 0x002EE4C8, 0x002EE6D4, 0x002EE6D4, 0x002EE6D4, 0x002EE4C8, 0x002EE6D4, 0x002EE6D4, 0x002EE6D4, 0x00356762, 0x001C0038, 
        0x001C0066, 0x001CCCFA, 0x001CD2FC, 0x001CADF5, 0x001CCBFB, 0x001CC1F8, 0x001CC1F8, 0x001CE0FC, 0x0022E4FC, 0x001CE0FC, 0x001CE0FC, 0x001CE0FC, 0x0022E1FE, 0x001CE0FC, 0x0022E4FC, 0x001CE0FC, 0x0022E9FF, 0x0022E4FC, 0x001CE0FB, 0x001CE0FB, 
        0x001CE0FB, 0x001CE0FB, 0x001CE0FB, 0x001CE0FB, 0x0032E6FA, 0x001CE0FB, 0x001CCCFA, 0x002276A3, 0x01221C8D, 0x001C0066, 0x00220040, 0x0022003D, 0x0022003D, 0x002B0048, 0x002B0048, 0x0027154C, 0x001C0046, 0x0027154C, 0x002E3255, 0x85000000, 
        0x95000000, 0xA2000015, 0xB1000000, 0xC0000000, 0xCE000000, 0xDA000000, 0xE4000000, 0xED000000, 0xF3000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x2D447278, 0x002EC3AC, 0x002EE4BA, 0x002EE4BA, 0x0027B498, 0x002EB1A3, 0x0027B498, 0x8B224040, 0x292E675C, 0x00229A7E, 0x00449582, 0x0042EBDA, 0x002EC3B9, 0x8B224040, 
        0x0022757D, 0x0027B498, 0x002EE4C8, 0x0042EBDA, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x002EE6D4, 0x002EE6D4, 0x002EE6D4, 0x002EE6D4, 0x0032EADC, 0x002EE6D4, 0x002EE4BA, 0x002EC3B9, 0x002EB1A3, 0x00227575, 0x002E3255, 0x00220042, 
        0x00150040, 0x0046BED8, 0x0022E1FE, 0x001CCCFA, 0x001CC1F8, 0x001CC1F8, 0x001CC1F8, 0x001CE0FC, 0x001CE0FC, 0x001CCBFB, 0x001CD2FC, 0x0022E4FC, 0x001CE0FC, 0x001CE0FC, 0x0022E1FE, 0x001CE0FC, 0x0032EBFF, 0x0022E4FC, 0x0022E6FE, 0x001CE0FB, 
        0x0022E4FC, 0x0022E4FC, 0x0022E4FC, 0x001CE0FB, 0x0032E6FA, 0x0032E6FA, 0x001C84E6, 0x00222B99, 0x00222B99, 0x002B387A, 0x001C005A, 0x0022003D, 0x0022003D, 0x00220040, 0x00220042, 0x0027154C, 0x00220042, 0x002B0048, 0x002B0048, 0x1B2B3B55, 
        0x85000000, 0x95000000, 0xA2000015, 0xB1000000, 0xC0000000, 0xCE000000, 0xDA000000, 0xE5000000, 0xED000000, 0xF4000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x00449582, 0x002EE4BA, 0x002EE4BA, 0x002EE1AD, 0x0035A48F, 0x002EB1A3, 0x00276B62, 0x292E675C, 0x00449582, 0x004C9987, 0x0042EBDA, 0x2D447278, 0x70000015, 
        0x0035A48F, 0x0022B180, 0x002EE1AD, 0x0040EDFC, 0x0032EADC, 0x0032EADC, 0x002EE6D4, 0x002EC3B9, 0x002EB1A3, 0x002EB1A3, 0x0022A489, 0x00449582, 0x003B7E72, 0x00276B62, 0x01223D4C, 0x011C2B48, 0x00223D66, 0x002B545D, 0x00274057, 0x00220042, 
        0x001C0035, 0x001C7EC8, 0x0032EBFF, 0x0022E1FE, 0x001CC1F8, 0x001CADF5, 0x001CC1F8, 0x001CD2FC, 0x001CCBFB, 0x001CCBFB, 0x001CD2FC, 0x001CD2FC, 0x001CD2FC, 0x001CD2FC, 0x0022E4FC, 0x001CD2FC, 0x001CE0FC, 0x0022E6FE, 0x001CE0FB, 0x001CE0FB, 
        0x001CE0FB, 0x0022E4FC, 0x001CE0FB, 0x0022E6FE, 0x0032E6FA, 0x001CCCFA, 0x002276A3, 0x00222B99, 0x00222B99, 0x01221C8D, 0x001C0066, 0x0027154C, 0x0027003D, 0x002B0048, 0x00220042, 0x00220042, 0x002B0048, 0x001C0046, 0x002B0048, 0x002E3255, 
        0x7A000015, 0x85000000, 0x95000000, 0xA2000015, 0xB1000000, 0xC1000000, 0xCE000000, 0xDB000000, 0xE6000000, 0xEE000000, 0xF5000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x3422384A, 0x292E675C, 0x2D447278, 0x292E675C, 0x00225A6F, 0x00449582, 0x002EC3AC, 0x002EC3B9, 0x0027B498, 0x0035A48F, 0x00449582, 0x002B545D, 0x00227575, 0x0035A48F, 0x0146C3A8, 0xB1000000, 0x00449582, 
        0x002EE6D4, 0x0035C397, 0x0046D69A, 0x002EE4C8, 0x004CEAC9, 0x00276B62, 0x00274057, 0x011C2B48, 0x011C2B48, 0x01273250, 0x0022384C, 0x00222248, 0x0022384C, 0x01223D4C, 0x00225459, 0x002B545D, 0x002B545D, 0x00223D5A, 0x01273250, 0x002B0048, 
        0x001C0035, 0x002B387A, 0x001CD2FC, 0x0032EBFF, 0x001CD2FC, 0x001CADF5, 0x001CADF5, 0x001CC1F8, 0x001CC1F8, 0x001CC1F8, 0x001CCBFB, 0x001CCBFB, 0x001CD2FC, 0x001CD2FC, 0x001CD2FC, 0x001CD2FC, 0x001CD2FC, 0x0022E4FC, 0x001CE0FC, 0x001CE0FB, 
        0x0032E6FA, 0x0022E4FC, 0x0032E6FA, 0x0032EBFF, 0x001CE0FB, 0x001C7EC8, 0x00222B99, 0x00222B99, 0x00222B99, 0x00272E90, 0x01221C8D, 0x001C0066, 0x001C0046, 0x0022003D, 0x00220042, 0x00220042, 0x002B0048, 0x00220042, 0x002B0048, 0x002E3255, 
        0x70000000, 0x7A000015, 0x85000000, 0x95000000, 0xA4000000, 0xB1000000, 0xC3000000, 0xD0000000, 0xDD000000, 0xE7000000, 0xF0000000, 0xF6000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0046D69A, 0x0046D69A, 0x0035C397, 0x0035C397, 0x0046B497, 0x002BA485, 0x002B8669, 0x00276B62, 0x0022757D, 0x00449582, 0x0035A48F, 0x00276B62, 0x00227575, 0x002EC3AC, 0x002B8669, 0x0040818E, 0x002EE6D4, 
        0x002EE6D4, 0x0035A48F, 0x0027D297, 0x0042E4B3, 0x0042EBDA, 0x002B8669, 0x0022384C, 0x01273250, 0x011C2B48, 0x01273250, 0x00383B5F, 0x00383B5F, 0x00274057, 0x01273250, 0x011C2B48, 0x00222248, 0x00274057, 0x00274057, 0x002E3255, 0x0027154C, 
        0x001C0035, 0x001C0046, 0x001C7EC8, 0x0032E6FA, 0x0022E9FF, 0x001CC1F8, 0x001CADF5, 0x001CC1F8, 0x001CC1F8, 0x001CC1F8, 0x001CC1F8, 0x001CCBFB, 0x001CCCFA, 0x001CCCFA, 0x001CD2FC, 0x001CD2FC, 0x001CE0FC, 0x001CE0FC, 0x0022E4FC, 0x0032E6FA, 
        0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0032E6FA, 0x001C7EC8, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x002B387A, 0x001C005A, 0x00220042, 0x0022003D, 0x00220040, 0x00220040, 0x00220042, 0x002B0048, 0x002B0048, 
        0x37001535, 0x70000000, 0x7A000015, 0x88000000, 0x95000000, 0xA4000000, 0xB5000000, 0xC4000000, 0xD3000000, 0xDF000000, 0xE9000000, 0xF1000000, 0xF7000000, 0xFB000000, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EE4C8, 0x002EE4BA, 0x002EE4BA, 0x002EE4C8, 0x002EE4BA, 0x002EE4C8, 0x002EE4C8, 0x0042E4B3, 0x003BBA87, 0x00276B62, 0x00227575, 0x0035A48F, 0x00449582, 0x002EC3AC, 0x0040818E, 0x002EE4C8, 0x0035A48F, 
        0x00226760, 0x003B7E72, 0x002BC98C, 0x002EE1AD, 0x002EE4C8, 0x006DEDD4, 0x0046B497, 0x0027B498, 0x002BA485, 0x002BA485, 0x002BA485, 0x00229A7E, 0x00229A7E, 0x002B8669, 0x0022786F, 0x002B545D, 0x0022384C, 0x00222248, 0x002E3255, 0x01273250, 
        0x001C003D, 0x00150035, 0x001C005A, 0x001C7EC8, 0x0040EDFC, 0x0022E9FF, 0x001CD2FC, 0x001CC1F8, 0x001CC1F8, 0x001CCBFB, 0x001CCCFA, 0x001CD2FC, 0x001CC1F8, 0x001CC1F8, 0x001CE0FC, 0x0022E4FC, 0x0022E4FC, 0x0022E9FF, 0x0032EBFF, 0x0040EDFC, 
        0x0040EDFC, 0x0040EDFC, 0x002BC5F0, 0x001C7EC8, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x002B387A, 0x001C0066, 0x001C005A, 0x001C003D, 0x001C003D, 0x00220042, 0x00220040, 0x00220040, 0x00220042, 
        0x19222250, 0x69000000, 0x70000000, 0x7A000015, 0x88000000, 0x98000000, 0xA7000000, 0xB7000000, 0xC8000000, 0x292E675C, 0x292E675C, 0x3422384A, 0xF4000000, 0x8B224040, 0x0050A689, 0x002B545D, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0027D297, 0x002EC3AC, 0x002EC3AC, 0x002EC3AC, 0x0146C3A8, 0x0035C397, 0x002EC3AC, 0x002EC3AC, 0x002EC3AC, 0x002EC3AC, 0x0035A48F, 0x0035A48F, 0x002EC3AC, 0x002EE4BA, 0x002EE4C8, 0x0146C3A8, 0x0035A48F, 
        0x0027B498, 0x0035C397, 0x002BC98C, 0x0046D69A, 0x002EE1AD, 0x0042EBDA, 0x004CEAC9, 0x002EC3AC, 0x0035C397, 0x0035C397, 0x0035C397, 0x0035C397, 0x0035C397, 0x0035C397, 0x0035C397, 0x0022B180, 0x00229A7E, 0x002B8669, 0x00226760, 0x01273250, 
        0x00220042, 0x0015002E, 0x001C0046, 0x002B387A, 0x001CADF5, 0x0032E6FA, 0x0040EDFC, 0x0022E6FE, 0x001CE0FC, 0x001CD2FC, 0x001CCCFA, 0x001CCCFA, 0x001CD2FC, 0x001CD2FC, 0x0032E6FA, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 
        0x0032E6FA, 0x001C84E6, 0x001C7EC8, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x002B387A, 0x001C0066, 0x00220042, 0x001C0038, 0x001C003D, 0x0022003D, 0x00220042, 0x001C003D, 
        0x1515153D, 0x63000000, 0x69000000, 0x73000000, 0x7D000000, 0x8B000000, 0x9A000015, 0xAB000000, 0x59224244, 0x0050A689, 0x0050A689, 0x002B8669, 0x00356762, 0x0046B497, 0x004CAE84, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0042EBDA, 0x0032EADC, 0x0032EADC, 0x0042EBDA, 0x0042EBDA, 0x0042EBDA, 0x0042EBDA, 0x002EE6D4, 0x002EE4C8, 0x002EC3B9, 0x002EC3B9, 0x002EE6D4, 0x002EE4C8, 0x002EE6D4, 0x002EE4C8, 0x002EE4BA, 0x002EE4BA, 
        0x002EE1AD, 0x0027D297, 0x003BBA87, 0x0046D69A, 0x0027D297, 0x002EE4C8, 0x007AF0F5, 0x0042EBDA, 0x002EE6D4, 0x002EE4C8, 0x002EE4C8, 0x002EC3B9, 0x002EC3B9, 0x002EC3AC, 0x002EC3AC, 0x0035C397, 0x0035C397, 0x0146C3A8, 0x0027B498, 0x0022B180, 
        0x002B8669, 0x011C3B4A, 0x00150038, 0x001C0066, 0x00222B99, 0x001C84E6, 0x001CCCFA, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0022E4FC, 0x0022E1FE, 0x0032E6FA, 0x0040EDFC, 0x002BC5F0, 0x001CCCFA, 0x001CD2FC, 0x001CD2FC, 0x002BC5F0, 0x001CADF5, 
        0x001C7EC8, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x002B387A, 0x001C0066, 0x0027154C, 0x0022003D, 0x001C0038, 0x001C003D, 0x0027154C, 0x001C003D, 
        0x0027154C, 0x5F000000, 0x63000000, 0x6A000000, 0x73000000, 0x80000000, 0x8E000000, 0x9E000015, 0x59224244, 0xC1000000, 0x8B224040, 0x0046B497, 0x00449582, 0x0046D69A, 0x004CAE84, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0032EADC, 0x0042EBDA, 0x0042EBDA, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x002EE4C8, 0x00229A7E, 0x002287AD, 0x0027B498, 0x04274655, 0x00225A6F, 
        0x002EC3B9, 0x002EE4BA, 0x0022BC83, 0x0027D297, 0x0027CA7E, 0x002EE1AD, 0x0042EBDA, 0x007AF0F5, 0x0032EADC, 0x0040EDFC, 0x0040EDFC, 0x0032EADC, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0042EBDA, 
        0x002EE6D4, 0x002EC3B9, 0x00229A7E, 0x00222248, 0x002B387A, 0x00222B99, 0x002276A3, 0x001C84E6, 0x001CADF5, 0x0032E6FA, 0x0040EDFC, 0x0040EDFC, 0x0032E6FA, 0x0046BED8, 0x00222B99, 0x00222B99, 0x001C7EC8, 0x001C7EC8, 0x002276A3, 0x00222B99, 
        0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x002B387A, 0x001C0066, 0x001C005A, 0x001C003D, 0x0022003D, 0x001C003D, 0x001C003D, 0x00220042, 
        0x001C0046, 0x5C000000, 0x5F000000, 0x65000000, 0x6C000000, 0x75000000, 0x83000000, 0x94001515, 0xA4000000, 0x003B7E72, 0x0046B497, 0x004CAE84, 0x00449582, 0x004CAE84, 0x0046B497, 0x0046B497, 0x0046B497, 0x2D447278, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x0035A48F, 0x002EC3B9, 0x002EE4C8, 
        0x002EC3B9, 0x0027B498, 0x003B7E72, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0042EBDA, 0x0042EBDA, 0x0042EBDA, 0x0042EBDA, 0x0032EADC, 0x0042EBDA, 0x004CEAC9, 0x0146C3A8, 0x0022786F, 0x0022384C, 0x00226D89, 0x002EC3B9, 0x004C9987, 0x00274057, 
        0x00222248, 0x0040818E, 0x002BA485, 0x0027CA7E, 0x0027D297, 0x0035C397, 0x002EE6D4, 0x0042EBDA, 0x007AF0F5, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0042EBDA, 0x002EE6D4, 0x002EC3B9, 0x002EC3B9, 0x0035A48F, 0x0022757D, 
        0x00227575, 0x00225A6F, 0x0022757D, 0x00356762, 0x0027154C, 0x002B387A, 0x01221C8D, 0x00222B99, 0x00222B99, 0x00222B99, 0x001C7EC8, 0x001C7EC8, 0x002276A3, 0x00272E90, 0x002B387A, 0x002B387A, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 
        0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x002B387A, 0x01221C8D, 0x002B387A, 0x001C0066, 0x001C003D, 0x00220040, 0x001C003D, 0x001C003D, 0x00220042, 
        0x00220042, 0x1515153D, 0x5C000000, 0x60000000, 0x3422384A, 0x2D447278, 0x0E4C9C84, 0x2D447278, 0x2D447278, 0x004CAE84, 0x003B7E72, 0x0046B497, 0x004CAE84, 0x004CAE84, 0x0050A689, 0x0E4C9C84, 0x8B224040, 0x8B224040, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x0035A48F, 0x002EC3B9, 0x002EC3B9, 0x002EC3B9, 
        0x002EC3B9, 0x002EC3B9, 0x002EB1A3, 0x0E4C9C84, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0027B498, 0x002EC3AC, 0x002EC3AC, 0x002EC3AC, 0x002EC3AC, 0x002EC3AC, 0x002EE4C8, 0x004CEAC9, 0x002EE4BA, 0x002EE1AD, 0x0046B497, 0x0022786F, 0x0022384C, 0x00226D89, 0x002EE6D4, 0x002EC3AC, 0x0040818E, 
        0x002B545D, 0x00220042, 0x002B545D, 0x0022BC83, 0x0027CA7E, 0x0022BC83, 0x002EC3AC, 0x002EE4C8, 0x007AF0F5, 0x0046B497, 0x0022757D, 0x00225A6F, 0x00225459, 0x00223D5A, 0x00225A6F, 0x002B545D, 0x00274057, 0x00274057, 0x00274057, 0x04274655, 
        0x00225459, 0x01223D4C, 0x0022384C, 0x0022003D, 0x001C003B, 0x001C005A, 0x002B387A, 0x01221C8D, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x002B387A, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 
        0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00272E90, 0x01221C8D, 0x01221C8D, 0x002B387A, 0x002B387A, 0x001C0066, 0x001C0046, 0x001C003D, 0x0015003D, 0x001C003D, 0x001C003D, 
        0x0027154C, 0x1515153D, 0x1B2B3B55, 0x00225459, 0x0022786F, 0x004C9987, 0x0046B497, 0x0046B497, 0x0046B497, 0x002EB1A3, 0x0050A689, 0x004CAE84, 0x00225A6F, 0x00449582, 0x00449582, 0x0046B497, 0x0146C3A8, 0x0E4C9C84, 0x2D447278, 0x2D447278, 
        0x2D447278, 0x2D447278, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x00427B7F, 0x0035A48F, 0x002EB1A3, 0x002EB1A3, 0x002EB1A3, 0x0035A48F, 
        0x004C9987, 0x0035A48F, 0x002287AD, 0x002EB1A3, 0x0035A48F, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x00227575, 0x0022786F, 0x0022786F, 0x00226760, 0x00449582, 0x002EE4C8, 0x004CEAC9, 0x004CEAC9, 0x002EE4BA, 0x002EE4BA, 0x002EE4C8, 0x004CEAC9, 0x002EC3B9, 0x0035A48F, 0x002EE6D4, 0x002EE6D4, 0x0027B498, 
        0x0040818E, 0x00225459, 0x002B545D, 0x0022B180, 0x0027CA7E, 0x0027CA7E, 0x0027B498, 0x002EE4C8, 0x0042EBDA, 0x006DEDD4, 0x002B545D, 0x011C2B48, 0x001C153B, 0x00150040, 0x00225459, 0x00226760, 0x00274057, 0x00274057, 0x01273250, 0x0022384C, 
        0x00274057, 0x00225459, 0x00274057, 0x0022384C, 0x001C153B, 0x001C0046, 0x001C005A, 0x002B387A, 0x01221C8D, 0x00222B99, 0x00222B99, 0x00272E90, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x00222B99, 0x00222B99, 0x00222B99, 
        0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x00222B99, 0x01221C8D, 0x002B387A, 0x001C0066, 0x0027154C, 0x001C0038, 0x001C003D, 0x00222248, 0x01273250, 
        0x00224060, 0x00225565, 0x00227575, 0x00227575, 0x00227575, 0x0022757D, 0x00427B7F, 0x0022757D, 0x004C9987, 0x00449582, 0x004C9987, 0x00276B62, 0x00225565, 0x00225A6F, 0x0035A48F, 0x0035A48F, 0x0035A48F, 0x0022A489, 0x0035A48F, 0x0035A48F, 
        0x002EB1A3, 0x002EB1A3, 0x0027B498, 0x0035A48F, 0x2D447278, 0xFC000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 0x8B224040, 0x2D447278, 0x002EB1A3, 0x002EB1A3, 0x002EB1A3, 0x004C9987, 0x0035A48F, 0x0035A48F, 0x004C9987, 
        0x004C9987, 0x0040818E, 0x0040818E, 0x0040818E, 0x002EB1A3, 0x2D447278, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x00427B7F, 0x003B7E72, 0x002BA485, 0x002BA485, 0x002EE4C8, 0x004CEAC9, 0x002EE4BA, 0x0042E4B3, 0x004CEAC9, 0x0042EBDA, 0x0042EBDA, 0x007AF0F5, 0x007AF0F5, 0x007AF0F5, 0x007AF0F5, 0x0032EADC, 0x002EE4C8, 
        0x00449582, 0x0022757D, 0x002B545D, 0x00229A7E, 0x0022BC83, 0x0027CA7E, 0x0022B180, 0x002EE4BA, 0x004CEAC9, 0x007AF0F5, 0x0050A689, 0x00223D5A, 0x00274057, 0x0022384C, 0x00225459, 0x00356762, 0x00274057, 0x00274057, 0x002B545D, 0x0022786F, 
        0x00449582, 0x0050A689, 0x0046B497, 0x0046B497, 0x0050A689, 0x004C9987, 0x0022786F, 0x00225565, 0x001C0066, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x00272E90, 0x00222B99, 
        0x00272E90, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x002B387A, 0x001C005A, 0x0027154C, 0x00222248, 0x00223D5A, 0x00223D66, 0x00225A6F, 
        0x00227575, 0x00225A6F, 0x00356762, 0x00225565, 0x00225A6F, 0x00227575, 0x00225A6F, 0x0022757D, 0x00227575, 0x00227575, 0x00227575, 0x00225A6F, 0x00225A6F, 0x0022757D, 0x0040818E, 0x0035A48F, 0x00449582, 0x0022786F, 0x00227575, 0x0040818E, 
        0x00449582, 0x0040818E, 0x0035A48F, 0x002EB1A3, 0x0027B498, 0x00449582, 0x00449582, 0x00449582, 0x0027B498, 0x0027B498, 0x0027B498, 0x002EB1A3, 0x002EC3AC, 0x002EB1A3, 0x0035A48F, 0x0035A48F, 0x00449582, 0x0022757D, 0x004C9987, 0x00427B7F, 
        0x00427B7F, 0x00226D89, 0x00427B7F, 0x003D5783, 0x002287AD, 0x0035A48F, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EE1AD, 0x0035C397, 0x00229A7E, 0x002EC3B9, 0x004CEAC9, 0x002EE1AD, 0x0042E4B3, 0x0042EBDA, 0x0042EBDA, 0x0042EBDA, 0x004CEAC9, 0x0146C3A8, 0x0035A48F, 0x004C9987, 0x0035A48F, 0x002EC3B9, 0x002EE4C8, 
        0x002EC3AC, 0x0040818E, 0x00225565, 0x00276B62, 0x0022BC83, 0x0022BC83, 0x0022BC83, 0x0035C397, 0x002EE4C8, 0x0042EBDA, 0x0378C6BE, 0x00224060, 0x00274057, 0x00274057, 0x00274057, 0x0022384C, 0x002B545D, 0x0035A48F, 0x0046D69A, 0x002EE4BA, 
        0x004CEAC9, 0x006DEDD4, 0x006DEDD4, 0x007AF0F5, 0x007AF0F5, 0x007AF0F5, 0x007AF0F5, 0x006DEDD4, 0x0378C6BE, 0x0035A48F, 0x00272E90, 0x00272E90, 0x00222B99, 0x00222B99, 0x00272E90, 0x01221C8D, 0x001C0066, 0x002B387A, 0x01221C8D, 0x00222B99, 
        0x00272E90, 0x00272E90, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x002B387A, 0x001C0066, 0x0027154C, 0x00223D5A, 0x00225565, 0x00225A6F, 0x00225A6F, 0x00225565, 
        0x00227575, 0x00225A6F, 0x0022786F, 0x00225A6F, 0x00225A6F, 0x0022757D, 0x00227575, 0x0022757D, 0x0022757D, 0x00225A6F, 0x00225565, 0x00225A6F, 0x0022757D, 0x0040818E, 0x00225A6F, 0x0022757D, 0x0040818E, 0x00227575, 0x002B545D, 0x0022757D, 
        0x0022757D, 0x0022757D, 0x0022757D, 0x0035A48F, 0x0040818E, 0x0035A48F, 0x0035A48F, 0x0035A48F, 0x0035A48F, 0x0027B498, 0x0035A48F, 0x002EC3B9, 0x0035A48F, 0x004C9987, 0x0040818E, 0x0035A48F, 0x00449582, 0x00356762, 0x0040818E, 0x00225A6F, 
        0x00225A6F, 0x002B387A, 0x00225A6F, 0x00225565, 0x00226D89, 0x0040818E, 0x2D447278, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EE1AD, 0x0042E4B3, 0x0035C397, 0x002EE4BA, 0x002EE1AD, 0x002EE4BA, 0x006DEDD4, 0x006DEDD4, 0x0146C3A8, 0x004C9987, 0x00227575, 0x002B545D, 0x003B7E72, 0x00276B62, 0x002B545D, 0x00225459, 0x00225565, 
        0x0040818E, 0x00449582, 0x0022757D, 0x01223D4C, 0x0022A474, 0x0022BC83, 0x0022BC83, 0x002BAF7D, 0x002EE4BA, 0x002EE6D4, 0x006DEDD4, 0x002B8669, 0x00274057, 0x00274057, 0x002B545D, 0x00225A6F, 0x002EC3AC, 0x002EE4BA, 0x002EE4BA, 0x002EE4BA, 
        0x004CEAC9, 0x007AF0F5, 0x007AF0F5, 0x007AF0F5, 0x007AF0F5, 0x0378C6BE, 0x00449582, 0x002B545D, 0x00225565, 0x00427B7F, 0x0040818E, 0x00226D89, 0x00272E90, 0x00222B99, 0x00222B99, 0x01221C8D, 0x002B387A, 0x002B387A, 0x01221C8D, 0x00222B99, 
        0x00222B99, 0x01221C8D, 0x01221C8D, 0x00272E90, 0x00222B99, 0x01221C8D, 0x00272E90, 0x01221C8D, 0x006D627D, 0x00787283, 0x001C0066, 0x001C0066, 0x002E3255, 0x00223D5A, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x00227575, 0x00225A6F, 
        0x00225A6F, 0x0022757D, 0x00227575, 0x00225A6F, 0x00225565, 0x00225A6F, 0x00225A6F, 0x0022757D, 0x00227575, 0x00224060, 0x00224060, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x0022757D, 0x00227575, 0x0022757D, 0x002B545D, 0x00223D5A, 
        0x00225A6F, 0x00225A6F, 0x0022757D, 0x0022757D, 0x00427B7F, 0x0022757D, 0x00427B7F, 0x00427B7F, 0x0040818E, 0x0040818E, 0x0022757D, 0x0040818E, 0x0022757D, 0x0022757D, 0x00225A6F, 0x002287AD, 0x00427B7F, 0x00225A6F, 0x00226D89, 0x00225A6F, 
        0x00383B5F, 0x00383B5F, 0x002E3255, 0x00383B5F, 0x00225A6F, 0x003D5783, 0x2D447278, 0xFD000000, 0xFC000000, 0xFB000000, 0xFB000000, 0xFB000000, 0xFA000000, 0xFB000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0042E4B3, 0x0042E4B3, 0x002EC3AC, 0x002EE4BA, 0x002EE1AD, 0x004CEAC9, 0x002EE4BA, 0x002B8669, 0x00485263, 0x00225A6F, 0x00223D5A, 0x00220040, 0x00226760, 0x00229A7E, 0x002B8669, 0x00356762, 0x00225459, 
        0x00274057, 0x002287AD, 0x00427B7F, 0x00226760, 0x00277D62, 0x002BAF7D, 0x002BAF7D, 0x002BAF7D, 0x0027B498, 0x002EE4BA, 0x0042EBDA, 0x0378C6BE, 0x01273250, 0x00274057, 0x00225A6F, 0x0035C397, 0x002EE1AD, 0x002EC3AC, 0x002EC3AC, 0x002EE4C8, 
        0x006DEDD4, 0x006DEDD4, 0x007AF0F5, 0x006DEDD4, 0x003B7E72, 0x00356762, 0x00356762, 0x01223D4C, 0x001C0038, 0x001C0046, 0x0027154C, 0x002B387A, 0x01221C8D, 0x01221C8D, 0x00222B99, 0x00222B99, 0x01221C8D, 0x002B387A, 0x002B387A, 0x01221C8D, 
        0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x006D627D, 0x006D627D, 0x006D627D, 0x00C6BEC2, 0x0022384C, 0x00274057, 0x01273250, 0x00223D5A, 0x00224060, 0x00226760, 0x00225A6F, 0x00225A6F, 0x0022786F, 0x00225A6F, 
        0x00227575, 0x0022757D, 0x00276B62, 0x00227575, 0x00226760, 0x00225565, 0x00227575, 0x0022757D, 0x00226760, 0x00223D5A, 0x00274057, 0x00224060, 0x00224060, 0x00225A6F, 0x00223D5A, 0x0022757D, 0x00225A6F, 0x00274057, 0x002E3255, 0x00223D5A, 
        0x00223D5A, 0x00224060, 0x0022757D, 0x0022757D, 0x00227575, 0x002B545D, 0x00227575, 0x00227575, 0x00225A6F, 0x0022757D, 0x00227575, 0x00226D89, 0x00225A6F, 0x00226D89, 0x00227575, 0x0040818E, 0x00427B7F, 0x00223D5A, 0x00225A6F, 0x01273250, 
        0x00224060, 0x1B2B3B55, 0x2D447278, 0x00274057, 0x00383B5F, 0x00225A6F, 0x2D447278, 0xFA000000, 0xF8000000, 0xF7000000, 0xF6000000, 0xF6000000, 0xF5000000, 0xF6000000, 0xF7000000, 0xF8000000, 0xFA000000, 0xFB000000, 0xFC000000, 0xFE000000, 
        0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EE1AD, 0x0046D69A, 0x002EC3AC, 0x0046D69A, 0x004CEAC9, 0x0042E4B3, 0x0035C397, 0x002B8669, 0x00274057, 0x00225A6F, 0x00222248, 0x001C003D, 0x01273250, 0x002B8669, 0x002B8669, 0x002B8669, 0x00427B7F, 
        0x00229A7E, 0x0022A489, 0x00229A7E, 0x00229A7E, 0x00226760, 0x0022A474, 0x002BAF7D, 0x002BAF7D, 0x002BA485, 0x002EE4C8, 0x0042EBDA, 0x005FE4B6, 0x01223D4C, 0x00274057, 0x00427B7F, 0x0035C397, 0x0035C397, 0x0035C397, 0x002EC3B9, 0x0042EBDA, 
        0x006DEDD4, 0x006DEDD4, 0x006DEDD4, 0x003B7E72, 0x002B545D, 0x01223D4C, 0x01223D4C, 0x002B545D, 0x01223D4C, 0x001C0038, 0x001C003B, 0x001C005A, 0x001C0066, 0x002B387A, 0x01221C8D, 0x01221C8D, 0x00272E90, 0x002B387A, 0x002B387A, 0x01221C8D, 
        0x01221C8D, 0x00222B99, 0x002B387A, 0x01221C8D, 0x001C0066, 0x001C005A, 0x00575970, 0x00948490, 0x004A4062, 0x00948490, 0x00225459, 0x002B545D, 0x00223D5A, 0x00225565, 0x00224060, 0x00225A6F, 0x00276B62, 0x00225565, 0x0022757D, 0x0022786F, 
        0x00225A6F, 0x0022757D, 0x00225565, 0x00225A6F, 0x00227575, 0x01273250, 0x00224060, 0x00225A6F, 0x00227575, 0x001C0046, 0x01273250, 0x001C0046, 0x0027154C, 0x00223D5A, 0x001C0046, 0x00223D66, 0x00224060, 0x0027154C, 0x00220042, 0x00223D5A, 
        0x00224060, 0x00224060, 0x00225A6F, 0x0022757D, 0x00225A6F, 0x0022384C, 0x00225565, 0x00276B62, 0x00225565, 0x00225A6F, 0x00227575, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x003D5783, 0x00225A6F, 0x0027154C, 0x00225A6F, 0x3422384A, 
        0xFE000000, 0xFD000000, 0xFD000000, 0xFC000000, 0x00225565, 0x00383B5F, 0x292E675C, 0xF4000000, 0xF2000000, 0xF0000000, 0xEE000000, 0xED000000, 0xED000000, 0xEE000000, 0xF0000000, 0xF2000000, 0xF5000000, 0xF7000000, 0xFA000000, 0xFC000000, 
        0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x00229A7E, 0x00229A7E, 0x002EC3AC, 0x002EE1AD, 0x002EE4BA, 0x00229A7E, 0x00449582, 0x002BA485, 0x00225459, 0x002B545D, 0x00274057, 0x00276B62, 0x00229A7E, 0x0027B498, 0x002EC3AC, 0x002EC3AC, 0x0146C3A8, 
        0x002EB1A3, 0x0027B498, 0x0027B498, 0x0027B498, 0x00277D62, 0x00277D62, 0x002BAF7D, 0x002BAF7D, 0x002BAF7D, 0x002EC3AC, 0x002EE4C8, 0x006DEDD4, 0x00277D62, 0x00274057, 0x00229A7E, 0x002BA485, 0x0027B498, 0x0035C397, 0x002EE6D4, 0x0042EBDA, 
        0x006DEDD4, 0x006DEDD4, 0x003B7E72, 0x011C2B48, 0x001C003D, 0x00274057, 0x00356762, 0x00274057, 0x00274057, 0x0022384C, 0x001C003D, 0x001C003D, 0x0027154C, 0x001C0066, 0x002B387A, 0x002B387A, 0x01221C8D, 0x002B387A, 0x001C0066, 0x001C005A, 
        0x001C0066, 0x001C0066, 0x01273250, 0x0027154C, 0x001C0046, 0x02221C46, 0x004A4062, 0x00948490, 0x002E3255, 0x00948490, 0x00356762, 0x002B545D, 0x00226760, 0x00225565, 0x00223D5A, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x0022757D, 0x00227575, 
        0x00225565, 0x0040818E, 0x00225A6F, 0x00224060, 0x0022757D, 0x00274057, 0x00274057, 0x00225A6F, 0x00227575, 0x001C0046, 0x0027154C, 0x001C0046, 0x0027154C, 0x00222248, 0x001C003D, 0x01273250, 0x00222248, 0x00220042, 0x001C0046, 0x002E3255, 
        0x00224060, 0x00225565, 0x00225A6F, 0x00225565, 0x00223D66, 0x01273250, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x00225565, 0x00225A6F, 0x00223D66, 0x00225A6F, 0x00223D66, 0x00485263, 0x00225A6F, 0x002B545D, 0x00485263, 0x292E675C, 0xFB000000, 
        0xFB000000, 0xFB000000, 0xFA000000, 0xF8000000, 0xF6000000, 0xF3000000, 0x8B224040, 0xEC000000, 0xE9000000, 0xE6000000, 0xE3000000, 0xE2000000, 0xE2000000, 0xE4000000, 0xE6000000, 0xEA000000, 0xEE000000, 0xF2000000, 0xF6000000, 0xF9000000, 
        0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0022A474, 0x0022384C, 0x0035C397, 0x002EE1AD, 0x003BBA87, 0x00274057, 0x00225A6F, 0x0035A48F, 0x00276B62, 0x00229A7E, 0x0035C397, 0x002EC3AC, 0x002EE1AD, 0x002EE1AD, 0x002EE1AD, 0x002EC3AC, 0x0146C3A8, 
        0x0027B498, 0x0035A48F, 0x0022A489, 0x0035A48F, 0x002B8669, 0x00225459, 0x0022A474, 0x0022A474, 0x002BAF7D, 0x0035A48F, 0x002EE4C8, 0x006DEDD4, 0x0022A474, 0x01273250, 0x002B8669, 0x00229A7E, 0x00229A7E, 0x002EC3B9, 0x002EE6D4, 0x0042EBDA, 
        0x0042EBDA, 0x0050A689, 0x02221C46, 0x011C2B48, 0x002B545D, 0x00356762, 0x01223D4C, 0x002B545D, 0x00575970, 0x00485263, 0x00787283, 0x01223D4C, 0x00220040, 0x001C0046, 0x001C005A, 0x001C0066, 0x001C005A, 0x0027154C, 0x00222248, 0x01273250, 
        0x00274057, 0x00274057, 0x00224060, 0x01273250, 0x01273250, 0x011C2B48, 0x002E3255, 0x00948490, 0x00485263, 0x00787283, 0x003B7E72, 0x00226760, 0x00225565, 0x00225565, 0x002B545D, 0x00225565, 0x002B545D, 0x00225A6F, 0x0022757D, 0x00227575, 
        0x00225A6F, 0x00226D89, 0x0022757D, 0x00222248, 0x0022757D, 0x00274057, 0x00222248, 0x00223D66, 0x0022757D, 0x001C0046, 0x0015003D, 0x00150040, 0x00222248, 0x01273250, 0x00222248, 0x00222248, 0x001C0046, 0x001C003D, 0x00150040, 0x0027154C, 
        0x002E3255, 0x00225565, 0x00225565, 0x002B545D, 0x002E3255, 0x002E3255, 0x00223D5A, 0x00383B5F, 0x00223D5A, 0x00223D66, 0x002B545D, 0x00223D5A, 0x00225565, 0x0027154C, 0x001C0046, 0x00223D66, 0x00225A6F, 0x8B224040, 0xF6000000, 0xF7000000, 
        0xF7000000, 0xF6000000, 0xF4000000, 0xF2000000, 0xEF000000, 0xEB000000, 0xE6000000, 0xE2000000, 0xDC000000, 0xD8000000, 0xD5000000, 0xD3000000, 0xD3000000, 0xD5000000, 0xD9000000, 0xDE000000, 0xE4000000, 0xEA000000, 0xF0000000, 0xF5000000, 
        0xF9000000, 0xFC000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0042E4B3, 0x002B8669, 0x00229A7E, 0x002EE1AD, 0x0022786F, 0x002B545D, 0x0022757D, 0x0027B498, 0x002EE1AD, 0x0046D69A, 0x002EE1AD, 0x002EE1AD, 0x002EE1AD, 0x002EE1AD, 0x002EE1AD, 0x0042E4B3, 0x002EE4BA, 
        0x002EE4BA, 0x002EE4BA, 0x002EE4BA, 0x002EE1AD, 0x002BC98C, 0x00277D62, 0x00226760, 0x0022A474, 0x002BAF7D, 0x0022A474, 0x002EC3AC, 0x002EE4C8, 0x0046D69A, 0x002B8669, 0x0022786F, 0x002B8669, 0x0035A48F, 0x002EE4C8, 0x002EE6D4, 0x002EE6D4, 
        0x0146C3A8, 0x0022384C, 0x04274655, 0x00225459, 0x002B545D, 0x01223D4C, 0x00222248, 0x004A4062, 0x00B6A7AC, 0x00787283, 0x00C6BEC2, 0x00485263, 0x00224060, 0x01273250, 0x00223D5A, 0x00224060, 0x0022384C, 0x00223D5A, 0x0022384C, 0x01273250, 
        0x00223D5A, 0x00223D5A, 0x00224060, 0x00225565, 0x002B545D, 0x00225565, 0x0027154C, 0x00787283, 0x00485263, 0x00948490, 0x00449582, 0x0022786F, 0x00276B62, 0x00226760, 0x00274057, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x00226D89, 0x00225A6F, 
        0x01273250, 0x00225A6F, 0x00225A6F, 0x0027154C, 0x00224060, 0x01273250, 0x00222248, 0x00225A6F, 0x00485263, 0x1B2B3B55, 0x79000000, 0x85000000, 0x95000000, 0xA4000000, 0xB1000000, 0xBB000000, 0xC0000000, 0xC0000000, 0x3422384A, 0x1515153D, 
        0x001C0046, 0x0027154C, 0x00225565, 0x0040818E, 0x00227575, 0x01273250, 0x0027154C, 0x0027154C, 0x001C0046, 0x00223D66, 0x00222248, 0x001C005A, 0x00225A6F, 0x004A4062, 0x00225A6F, 0x8B224040, 0xEB000000, 0xED000000, 0xEE000000, 0xEF000000, 
        0xEF000000, 0xEE000000, 0xEC000000, 0xE9000000, 0xE5000000, 0xDF000000, 0xD9000000, 0xD3000000, 0xCC000000, 0xC8000000, 0xC3000000, 0xC1000000, 0xC1000000, 0xC4000000, 0xC9000000, 0xD0000000, 0xD8000000, 0xE2000000, 0xE9000000, 0xF0000000, 
        0xF5000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0027B498, 0x0046D69A, 0x00427B7F, 0x002EE1AD, 0x002BA485, 0x0027B498, 0x0027D297, 0x002EE1AD, 0x002EE4BA, 0x002EE4BA, 0x0042E4B3, 0x0042E4B3, 0x0042E4B3, 0x004CEAC9, 0x002EE4BA, 0x002EE4BA, 0x002EE4BA, 
        0x002EE4BA, 0x004CEAC9, 0x002EE4BA, 0x002EE4BA, 0x002EE1AD, 0x002B8669, 0x00225459, 0x002B8669, 0x0022A474, 0x0022A474, 0x0035A48F, 0x002EE4BA, 0x002EE1AD, 0x002BA485, 0x0022786F, 0x002B8669, 0x002EC3B9, 0x002EE4C8, 0x002EE4C8, 0x004CEAC9, 
        0x00276B62, 0x00274057, 0x002B545D, 0x00225459, 0x00356762, 0x00225459, 0x011C2B48, 0x004A4062, 0x00C6BEC2, 0x006D627D, 0x00948490, 0x002B545D, 0x002E3255, 0x00274057, 0x00223D5A, 0x002B545D, 0x00274057, 0x00223D5A, 0x00274057, 0x00274057, 
        0x002E3255, 0x00223D66, 0x00274057, 0x00225565, 0x00225565, 0x00225565, 0x01273250, 0x004A4062, 0x00485263, 0x004A4062, 0x00948490, 0x00427B7F, 0x0022786F, 0x00226760, 0x00225459, 0x00225A6F, 0x00225A6F, 0x00223D66, 0x00225A6F, 0x0022757D, 
        0x00222248, 0x00223D66, 0x0022757D, 0x01273250, 0x01273250, 0x011C2B48, 0x00222248, 0x3422384A, 0x62000000, 0x69000000, 0x73000000, 0x7D000000, 0x8B000000, 0x98000000, 0xA2000015, 0xAB000015, 0xAF000015, 0xAF000015, 0xAB000015, 0xA7000015, 
        0x00274057, 0x011C2B48, 0x002E3255, 0x00227575, 0x0040818E, 0x00227575, 0x1B2B3B55, 0x3422384A, 0x3422384A, 0x3422384A, 0x00485263, 0x00427B7F, 0x2D447278, 0x8B224040, 0xD6000000, 0xDA000000, 0xDE000000, 0xE2000000, 0xE3000000, 0xE4000000, 
        0xE4000000, 0xE3000000, 0xE0000000, 0xDC000000, 0xD8000000, 0xD0000000, 0xC9000000, 0xC1000000, 0xBB000000, 0xB5000000, 0xB1000000, 0xAE000000, 0xAE000000, 0xB1000000, 0xB9000000, 0xC1000000, 0xCB000000, 0xD6000000, 0xE0000000, 0xEA000000, 
        0xF1000000, 0xF7000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x00226760, 0x002EB1A3, 0x002EE4BA, 0x002EE4BA, 0x002EE1AD, 0x0022A474, 0x00277D62, 0x00356762, 0x003B7E72, 0x0035C397, 0x002EE1AD, 0x005FE4B6, 0x0042E4B3, 0x0042E4B3, 0x002EE4BA, 0x002EE4BA, 0x0042E4B3, 
        0x0042E4B3, 0x0042E4B3, 0x002EE4BA, 0x0042E4B3, 0x002EE1AD, 0x002BAF7D, 0x00277D62, 0x04274655, 0x00229A7E, 0x0022A474, 0x00229A7E, 0x002EE4BA, 0x005FE4B6, 0x0027D297, 0x00277D62, 0x00449582, 0x002EE4C8, 0x002EE4C8, 0x002EE4C8, 0x0046B497, 
        0x01223D4C, 0x00225459, 0x00225459, 0x00225459, 0x00225459, 0x0022384C, 0x00150040, 0x00383B5F, 0x00B6A7AC, 0x00575970, 0x00787283, 0x04274655, 0x0022384C, 0x00274057, 0x00274057, 0x002B545D, 0x00224060, 0x01273250, 0x0027154C, 0x00222248, 
        0x00222248, 0x00223D5A, 0x00224060, 0x00225A6F, 0x002B545D, 0x002E3255, 0x00225A6F, 0x01273250, 0x004A4062, 0x00383B5F, 0x00948490, 0x00226760, 0x00226760, 0x00226760, 0x002B545D, 0x00225A6F, 0x00225A6F, 0x0027154C, 0x00223D66, 0x00224060, 
        0x00220042, 0x0022757D, 0x00227575, 0x0022384C, 0x04274655, 0x37001535, 0x59000000, 0x5C000000, 0x5F000000, 0x65000000, 0x6C000000, 0x75000000, 0x80000000, 0x8B000000, 0x94001515, 0x9A000015, 0x9E000015, 0x9E000015, 0x9A000015, 0x94001C15, 
        0x57000000, 0x1B2B3B55, 0x001C0046, 0x002E3255, 0x00383B5F, 0x00226D89, 0x003D5783, 0x2D447278, 0x94001C15, 0x9E000015, 0xA7000015, 0xAF000015, 0xB7000000, 0xBD000000, 0xC4000000, 0xCB000000, 0xCE000000, 0xD3000000, 0xD3000000, 0xD5000000, 
        0xD5000000, 0xD3000000, 0xD0000000, 0xCC000000, 0xC6000000, 0xC0000000, 0xB7000000, 0xAF000015, 0xA7000015, 0xA2000015, 0x9E000015, 0x9A000015, 0x9C000000, 0xA1000000, 0xA7000015, 0xB3000015, 0xBD000000, 0xCB000000, 0xD8000000, 0xE3000000, 
        0xED000000, 0xF4000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x011C2B48, 0x0035A48F, 0x002EE1AD, 0x002EE1AD, 0x0046D69A, 0x002BA485, 0x0035C397, 0x0027D297, 0x002BA485, 0x002B8669, 0x00225459, 0x00225459, 0x00226760, 0x003B7E72, 0x00449582, 0x00229A7E, 0x004CAE84, 
        0x004CAE84, 0x002BAF7D, 0x002BA485, 0x00229A7E, 0x00229A7E, 0x00277D62, 0x00225459, 0x01223D4C, 0x00225459, 0x0022A474, 0x002B8669, 0x002EC3AC, 0x005FE4B6, 0x002BC98C, 0x00276B62, 0x0035A48F, 0x002EE4BA, 0x002EE4BA, 0x002EE4BA, 0x01223D4C, 
        0x01223D4C, 0x00225459, 0x04274655, 0x04274655, 0x00274057, 0x011C2B48, 0x00220040, 0x004A4062, 0x00948490, 0x00787283, 0x00948490, 0x003B7E72, 0x00225459, 0x00274057, 0x0022384C, 0x01273250, 0x0027154C, 0x00220040, 0x001C0046, 0x02221C46, 
        0x00220040, 0x002E3255, 0x00223D66, 0x00225565, 0x00225565, 0x00356762, 0x00224060, 0x002B545D, 0x00383B5F, 0x00383B5F, 0x00787283, 0x00225565, 0x00227575, 0x00427B7F, 0x002B545D, 0x00224060, 0x00225A6F, 0x011C2B48, 0x001C005A, 0x0027154C, 
        0x001C003B, 0x0027154C, 0x0022384C, 0x04274655, 0x58000000, 0x58000000, 0x59000000, 0x5B000000, 0x5D000000, 0x62000000, 0x67000000, 0x6E000000, 0x75000000, 0x7F001515, 0x85000000, 0x8B001515, 0x8B001515, 0x8B001515, 0x8B001515, 0x81001C15, 
        0x81001C15, 0x7A000015, 0x1B2B3B55, 0x002E3255, 0x00383B5F, 0x00223D66, 0x00383B5F, 0x003D5783, 0x0040818E, 0x8B001515, 0x94001C15, 0x9E000015, 0xA4000015, 0xAB000015, 0xB1000000, 0xB7000000, 0xBB000000, 0xC0000000, 0xC3000000, 0xC3000000, 
        0xC3000000, 0xC3000000, 0xBD000000, 0xBB000000, 0xB3000015, 0xAB000000, 0xA4000015, 0x9C000000, 0x94001515, 0x90000015, 0x8B001515, 0x8B001515, 0x8E000000, 0x90000015, 0x9A000015, 0xA4000015, 0xB3000015, 0xC0000000, 0xCE000000, 0xDC000000, 
        0xE8000000, 0xF1000000, 0xF7000000, 0xFB000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x00226760, 0x0046D69A, 0x003BBA87, 0x0022B180, 0x0046D69A, 0x01223D4C, 0x00226760, 0x0022B180, 0x002EE1AD, 0x002EE1AD, 0x0146C3A8, 0x0022A474, 0x002B8669, 0x00226760, 0x01223D4C, 0x04274655, 0x00226760, 
        0x0022786F, 0x002B8669, 0x002B8669, 0x00277D62, 0x00277D62, 0x00277D62, 0x00225459, 0x011C2B48, 0x001C003D, 0x00225459, 0x002B8669, 0x0022A489, 0x0042E4B3, 0x00277D62, 0x00226760, 0x002EC3AC, 0x002EE4BA, 0x002EC3B9, 0x00226760, 0x0022384C, 
        0x01223D4C, 0x04274655, 0x01223D4C, 0x04274655, 0x00356762, 0x00356762, 0x00427B7F, 0x0035A48F, 0x0378C6BE, 0x0378C6BE, 0x005FE4B6, 0x0146C3A8, 0x0046B497, 0x0035A48F, 0x00449582, 0x002B545D, 0x01273250, 0x01273250, 0x002B545D, 0x00224060, 
        0x0022384C, 0x00222248, 0x0027154C, 0x00225565, 0x00225A6F, 0x00225A6F, 0x00224060, 0x00225A6F, 0x0022384C, 0x0027154C, 0x01273250, 0x00225565, 0x00225565, 0x0022757D, 0x011C2B48, 0x00223D66, 0x00223D66, 0x00222248, 0x001C0038, 0x0027154C, 
        0x001C153B, 0x00220042, 0x1515153D, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x5A000000, 0x5C000000, 0x5F000000, 0x63000000, 0x69000000, 0x6E000000, 0x74000015, 0x79000000, 0x7A000015, 0x7F001515, 0x7A000015, 0x7A000015, 0x74000015, 
        0x74000015, 0x70000015, 0x68001515, 0x37001535, 0x1B2B3B55, 0x04274655, 0x002B545D, 0x01273250, 0x00225A6F, 0x0040818E, 0x81001C15, 0x8B001515, 0x94001C15, 0x98000000, 0x9E000015, 0xA2000015, 0xA7000000, 0xAB000000, 0xAE000000, 0xAF000015, 
        0xAF000015, 0xAE000000, 0xAB000000, 0xA7000015, 0xA1000000, 0x9A000015, 0x94001515, 0x8B001515, 0x85000000, 0x81000015, 0x7F001515, 0x7F001515, 0x81000015, 0x88000015, 0x90000015, 0x9A000015, 0xA7000015, 0xB9000000, 0xC8000000, 0xD8000000, 
        0xE4000000, 0xEE000000, 0xF5000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002BAF7D, 0x002EE1AD, 0x00276B62, 0x00276B62, 0x0046B497, 0x002BC98C, 0x011C2B48, 0x01223D4C, 0x002B8669, 0x0022B180, 0x002EC3AC, 0x004CEAC9, 0x005FE4B6, 0x0146C3A8, 0x0027B498, 0x0022A474, 0x002BAF7D, 
        0x002BAF7D, 0x0022A474, 0x002BAF7D, 0x002BAF7D, 0x002BAF7D, 0x002BAF7D, 0x0022B180, 0x002BAF7D, 0x002B8669, 0x01223D4C, 0x00274057, 0x00229A7E, 0x002EC3B9, 0x00277D62, 0x0022757D, 0x002EC3B9, 0x002EB1A3, 0x00225459, 0x011C2B48, 0x00356762, 
        0x00449582, 0x0046B497, 0x0146C3A8, 0x005FE4B6, 0x005FE4B6, 0x005FE4B6, 0x005FE4B6, 0x005FE4B6, 0x0042E4B3, 0x0042E4B3, 0x0042E4B3, 0x0042E4B3, 0x0042E4B3, 0x0042E4B3, 0x004CEAC9, 0x004CEAC9, 0x005FE4B6, 0x0146C3A8, 0x0050A689, 0x00356762, 
        0x00223D5A, 0x01273250, 0x0027154C, 0x00223D5A, 0x00225A6F, 0x003D5783, 0x00223D5A, 0x00225A6F, 0x002B545D, 0x001C0046, 0x00222248, 0x00224060, 0x002B545D, 0x00225A6F, 0x011C3B4A, 0x00220042, 0x01223D4C, 0x001C0035, 0x001C0035, 0x001C003D, 
        0x02221C46, 0x0015003D, 0x1515153D, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5C000000, 0x5F000000, 0x62000000, 0x66000000, 0x6A000000, 0x6C000000, 0x70000015, 0x70000015, 0x70000015, 0x6E000000, 0x6C000000, 
        0x68001515, 0x68001515, 0x65000000, 0x6200001C, 0x6200001C, 0x6200001C, 0x37001535, 0x00485263, 0x00223D5A, 0x00225A6F, 0x0040818E, 0x2D447278, 0x81001C15, 0x85000000, 0x8B001515, 0x8E000000, 0x94001515, 0x98000000, 0x98000000, 0x9C000000, 
        0x9C000000, 0x98000000, 0x98000000, 0x94001515, 0x8E000000, 0x88000015, 0x83000000, 0x7F001515, 0x7A000015, 0x7A000015, 0x79000000, 0x7A000015, 0x7F001515, 0x83000000, 0x8B001515, 0x95000015, 0xA4000015, 0xB3000015, 0xC4000000, 0xD3000000, 
        0xE2000000, 0xEC000000, 0xF4000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0022BC83, 0x0042E4B3, 0x00225459, 0x00225459, 0x002B8669, 0x002EE1AD, 0x0022A474, 0x00222248, 0x00225459, 0x00229A7E, 0x00229A7E, 0x0035C397, 0x0042E4B3, 0x004CEAC9, 0x006DEDD4, 0x005FE4B6, 0x0035C397, 
        0x0022A474, 0x0022A474, 0x0022A474, 0x002BAF7D, 0x002BAF7D, 0x002BAF7D, 0x0022B180, 0x002BAF7D, 0x002BAF7D, 0x0022A474, 0x00226760, 0x00276B62, 0x0146C3A8, 0x002BAF7D, 0x0027B498, 0x0035A48F, 0x004C9987, 0x0046B497, 0x0146C3A8, 0x005FE4B6, 
        0x005FE4B6, 0x005FE4B6, 0x005FE4B6, 0x0042E4B3, 0x002EE1AD, 0x002EE1AD, 0x002EE1AD, 0x0046D69A, 0x0046D69A, 0x0046D69A, 0x0046D69A, 0x0046D69A, 0x0046D69A, 0x0046D69A, 0x0046D69A, 0x002EE1AD, 0x002EE1AD, 0x0042E4B3, 0x004CEAC9, 0x005FE4B6, 
        0x0146C3A8, 0x003B7E72, 0x0022384C, 0x01273250, 0x00225565, 0x00225A6F, 0x0022384C, 0x00224060, 0x00225A6F, 0x01273250, 0x001C0046, 0x01273250, 0x00223D5A, 0x01273250, 0x011C2B48, 0x001C003B, 0x001C153B, 0x001C0035, 0x001C0038, 0x001C0038, 
        0x0027154C, 0x001C003B, 0x37001535, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5C000000, 0x5F000000, 0x62000000, 0x63000000, 0x65000000, 0x66000000, 0x68001515, 0x68001515, 0x68001515, 0x68001515, 
        0x65000000, 0x63000000, 0x62000000, 0x62000000, 0x62000000, 0x63000000, 0x65000000, 0x68001515, 0x00274057, 0x00223D5A, 0x0040818E, 0x0040818E, 0x002287AD, 0x79000000, 0x7A000015, 0x7F001515, 0x83000000, 0x85000000, 0x88000000, 0x88000000, 
        0x88000000, 0x88000000, 0x85000000, 0x83000000, 0x7F001515, 0x7D000000, 0x7A000015, 0x79000000, 0x75000000, 0x75000000, 0x79000000, 0x7A000015, 0x7F001515, 0x85000000, 0x8B001515, 0x98000000, 0xA4000015, 0xB3000015, 0xC3000000, 0xD3000000, 
        0xDF000000, 0xEB000000, 0xF3000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0027D297, 0x004CEAC9, 0x0027B498, 0x00226760, 0x002B8669, 0x0035C397, 0x005FE4B6, 0x00276B62, 0x001C003D, 0x00226760, 0x0022A474, 0x0022A474, 0x002BA485, 0x0027D297, 0x0042E4B3, 0x004CEAC9, 0x004CEAC9, 
        0x004CEAC9, 0x002BC98C, 0x0027D297, 0x0027D297, 0x0027CA7E, 0x0027CA7E, 0x0027CA7E, 0x0027CA7E, 0x0027CA7E, 0x0022BC83, 0x0022BC83, 0x0022B180, 0x0046D69A, 0x0042E4B3, 0x0042E4B3, 0x005FE4B6, 0x005FE4B6, 0x0046B497, 0x004CAE84, 0x004CAE84, 
        0x002BAF7D, 0x002BAF7D, 0x002BAF7D, 0x002BAF7D, 0x0022A474, 0x0022A474, 0x0022A474, 0x00229A7E, 0x00229A7E, 0x00229A7E, 0x00229A7E, 0x002B8669, 0x00229A7E, 0x00229A7E, 0x00229A7E, 0x002BA485, 0x002BA485, 0x003BBA87, 0x0035C397, 0x0046D69A, 
        0x002EE1AD, 0x006DEDD4, 0x0378C6BE, 0x003B7E72, 0x00225A6F, 0x0022757D, 0x00274057, 0x001C005A, 0x00225565, 0x001C0046, 0x00220035, 0x0022003D, 0x001C153B, 0x0015003D, 0x011C2B48, 0x00150035, 0x001C003B, 0x00150035, 0x001C003B, 0x00150035, 
        0x001C0046, 0x001C003D, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5D000000, 0x5F000000, 0x60000000, 0x62000000, 0x62000000, 0x63000000, 0x63000000, 0x63000000, 
        0x65000000, 0x65000000, 0x65000000, 0x65000000, 0x65000000, 0x66000000, 0x68001515, 0x68001515, 0x68001515, 0x00223D66, 0x00356762, 0x00225565, 0x00224060, 0x002276A3, 0x70000015, 0x73000000, 0x74000015, 0x75000000, 0x79000000, 0x79000000, 
        0x7A000015, 0x7A000015, 0x7A000015, 0x79000000, 0x75000000, 0x74000015, 0x74000015, 0x74000015, 0x75000000, 0x79000000, 0x7D000000, 0x81000015, 0x88000015, 0x8B001515, 0x94001515, 0x9E000015, 0xAB000015, 0xB7000000, 0xC4000000, 0xD3000000, 
        0xE0000000, 0xEB000000, 0xF3000000, 0xF8000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EE1AD, 0x004CEAC9, 0x0027D297, 0x002B8669, 0x00277D62, 0x00229A7E, 0x0046D69A, 0x005FE4B6, 0x01223D4C, 0x00225459, 0x002B8669, 0x002BA485, 0x002BAF7D, 0x00229A7E, 0x0027B498, 0x002EE1AD, 0x0042E4B3, 
        0x004CEAC9, 0x006DEDD4, 0x0042E4B3, 0x0022BC83, 0x0027CA7E, 0x0022BC83, 0x002B8669, 0x00226760, 0x011C3B4A, 0x011C3B4A, 0x00226760, 0x005FE4B6, 0x002EE4BA, 0x002EE4BA, 0x0027D297, 0x0035C397, 0x0035C397, 0x00276B62, 0x011C2B48, 0x00220042, 
        0x0022384C, 0x002B545D, 0x002B8669, 0x00229A7E, 0x0022A474, 0x0022A474, 0x0022A474, 0x002BAF7D, 0x002BAF7D, 0x0022A474, 0x00229A7E, 0x00229A7E, 0x0022A474, 0x0022A474, 0x0022A474, 0x002BAF7D, 0x0022B180, 0x0022B180, 0x002BAF7D, 0x0022A474, 
        0x00229A7E, 0x0022A489, 0x0035C397, 0x005FE4B6, 0x0146C3A8, 0x00276B62, 0x001C003D, 0x001C0046, 0x00225565, 0x001C003B, 0x001C0038, 0x001C0038, 0x001C003D, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C0035, 0x001C0046, 0x001C003D, 
        0x001C003D, 0x002B0048, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5C000000, 0x5D000000, 0x5F000000, 0x60000000, 0x62000000, 0x65000000, 0x65000000, 
        0x67000000, 0x69000000, 0x6A000000, 0x6C000000, 0x6C000000, 0x6C000000, 0x6E000000, 0x6E000000, 0x6E000000, 0x6C000000, 0x19222250, 0x04274655, 0x00274057, 0x00224060, 0x002287AD, 0x6A000000, 0x6C000000, 0x6C000000, 0x6E000000, 0x70000000, 
        0x70000015, 0x70000015, 0x70000015, 0x70000015, 0x73000000, 0x74000015, 0x74000015, 0x79000000, 0x7A000015, 0x81000015, 0x85000000, 0x8E000000, 0x94001515, 0x9A000015, 0xA2000015, 0xAB000015, 0xB3000015, 0xC0000000, 0xCB000000, 0xD8000000, 
        0xE3000000, 0xEC000000, 0xF4000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EE4BA, 0x005FE4B6, 0x0027B498, 0x0022A474, 0x00277D62, 0x002B8669, 0x0035C397, 0x0042E4B3, 0x0046D69A, 0x00276B62, 0x00225459, 0x002B8669, 0x0022B180, 0x0022B180, 0x0022A474, 0x002BA485, 0x0027D297, 
        0x002EE1AD, 0x0042E4B3, 0x004CEAC9, 0x005FE4B6, 0x00229A7E, 0x011C3B4A, 0x01223D4C, 0x00225459, 0x00276B62, 0x0022A474, 0x0046D69A, 0x0027D297, 0x00427B7F, 0x002EC3AC, 0x0046D69A, 0x00225459, 0x00276B62, 0x0046B497, 0x0146C3A8, 0x0046B497, 
        0x003B7E72, 0x01223D4C, 0x011C2B48, 0x01223D4C, 0x00225459, 0x00277D62, 0x002B8669, 0x00229A7E, 0x0022A474, 0x002BAF7D, 0x0022A474, 0x0022A474, 0x002BAF7D, 0x002BAF7D, 0x0022B180, 0x003BBA87, 0x002BC98C, 0x0035C397, 0x002BC98C, 0x0035C397, 
        0x0035C397, 0x003BBA87, 0x0022B180, 0x0022B180, 0x0027B498, 0x0146C3A8, 0x004CAE84, 0x01223D4C, 0x011C2B48, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C0038, 0x00150035, 0x001C0035, 0x001C0035, 0x001C003D, 0x0027154C, 0x001C0046, 
        0x00150038, 0x0027154C, 0x19222250, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x59000000, 0x5A000000, 0x5C000000, 0x5D000000, 0x5F000000, 0x62000000, 0x65000000, 0x69000000, 0x6C000000, 
        0x70000000, 0x73000000, 0x74000015, 0x79000000, 0x79000000, 0x79000000, 0x79000000, 0x79000000, 0x79000000, 0x75000000, 0x73000000, 0x70000000, 0x37001535, 0x00274057, 0x00226D89, 0x2D447278, 0x67000000, 0x67000000, 0x68001515, 0x6A000000, 
        0x6C000000, 0x6C000000, 0x6E000000, 0x70000015, 0x74000015, 0x75000000, 0x7A000015, 0x81000015, 0x85000000, 0x8E000000, 0x95000015, 0x9E000015, 0xA4000015, 0xAB000015, 0xB3000015, 0xB9000000, 0xC0000000, 0xC9000000, 0xD3000000, 0xDD000000, 
        0xE7000000, 0xEF000000, 0xF5000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x004CEAC9, 0x0046D69A, 0x0022A474, 0x002B8669, 0x00276B62, 0x00277D62, 0x00229A7E, 0x0027D297, 0x005FE4B6, 0x003BBA87, 0x00225459, 0x00225459, 0x00229A7E, 0x0022BC83, 0x0022BC83, 0x003BBA87, 0x002BA485, 
        0x0022B180, 0x0046D69A, 0x002EE1AD, 0x0042E4B3, 0x006DEDD4, 0x0035C397, 0x0022786F, 0x002BC98C, 0x0046D69A, 0x0046D69A, 0x002EE1AD, 0x0022A474, 0x011C2B48, 0x00226760, 0x0046B497, 0x0046D69A, 0x0022384C, 0x00225459, 0x0022A474, 0x002BAF7D, 
        0x0146C3A8, 0x005FE4B6, 0x0378C6BE, 0x0050A689, 0x00225459, 0x011C2B48, 0x00274057, 0x00225459, 0x00225459, 0x00276B62, 0x00276B62, 0x00276B62, 0x003B7E72, 0x002B8669, 0x002B8669, 0x00229A7E, 0x002B8669, 0x002B8669, 0x00229A7E, 0x00229A7E, 
        0x00229A7E, 0x00229A7E, 0x002BA485, 0x0022B180, 0x0022B180, 0x0022B180, 0x0035C397, 0x0146C3A8, 0x002B8669, 0x001C0038, 0x001C0038, 0x001C003B, 0x001C0035, 0x001C0038, 0x001C003B, 0x001C0038, 0x001C003D, 0x001C005A, 0x001C005A, 0x0027154C, 
        0x001C0035, 0x001C0046, 0x19222250, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5D000000, 0x60000000, 0x63000000, 0x67000000, 0x6C000000, 0x70000000, 0x75000000, 
        0x7A000015, 0x80000000, 0x83000000, 0x85000000, 0x88000000, 0x88000000, 0x88000000, 0x88000000, 0x85000000, 0x83000000, 0x7D000000, 0x79000000, 0x73000000, 0x3422384A, 0x00224060, 0x0040818E, 0x67000000, 0x67000000, 0x68001515, 0x68001515, 
        0x6C000000, 0x6E000000, 0x70000015, 0x74000015, 0x7A000015, 0x7F001515, 0x85000000, 0x8E000000, 0x95000015, 0x9E000015, 0xA7000015, 0xAF000015, 0xB6000000, 0xBD000000, 0xC3000000, 0xC9000000, 0xCE000000, 0xD5000000, 0xDD000000, 0xE4000000, 
        0xEC000000, 0xF2000000, 0xF7000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x006DEDD4, 0x0035C397, 0x002B8669, 0x002B8669, 0x00276B62, 0x00277D62, 0x002B8669, 0x0022BC83, 0x0046D69A, 0x004CEAC9, 0x0022A474, 0x00226760, 0x00225459, 0x0022A474, 0x002BC98C, 0x0022BC83, 0x003BBA87, 
        0x0022B180, 0x002BA485, 0x0027D297, 0x002EE1AD, 0x002EE1AD, 0x004CEAC9, 0x0046D69A, 0x002BAF7D, 0x002BC98C, 0x002EE1AD, 0x0042E4B3, 0x00226760, 0x011C3B4A, 0x0022384C, 0x002B8669, 0x005FE4B6, 0x0050A689, 0x01223D4C, 0x00226760, 0x00229A7E, 
        0x0022A474, 0x002BA485, 0x0146C3A8, 0x005FE4B6, 0x005FE4B6, 0x0378C6BE, 0x0050A689, 0x00356762, 0x01223D4C, 0x00224060, 0x00226760, 0x00274057, 0x002B545D, 0x002B545D, 0x00274057, 0x002B545D, 0x00223D5A, 0x00224060, 0x002B545D, 0x00274057, 
        0x00225565, 0x002B545D, 0x0022384C, 0x0022384C, 0x01223D4C, 0x002B545D, 0x0022786F, 0x00229A7E, 0x0046B497, 0x00277D62, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C003B, 0x001C0038, 0x00150040, 0x001C005A, 0x001C0066, 0x001C005A, 0x0027154C, 
        0x001C0038, 0x001C003D, 0x19222250, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5B000000, 0x5D000000, 0x60000000, 0x65000000, 0x69000000, 0x70000000, 0x75000000, 0x7D000000, 0x83000000, 
        0x8B000000, 0x90000015, 0x95000000, 0x98000000, 0x9C000000, 0x9C000000, 0x9C000000, 0x9A000015, 0x98000000, 0x91000000, 0x8B000000, 0x85000000, 0x80000000, 0x79000000, 0x3422384A, 0x292E675C, 0x6C000000, 0x6A000000, 0x6C000000, 0x6C000000, 
        0x70000015, 0x74000015, 0x7A000015, 0x7F001515, 0x83000000, 0x8B001515, 0x94001515, 0x9C000000, 0xA7000015, 0xAF000015, 0xB9000000, 0xC1000000, 0xC8000000, 0xCE000000, 0xD3000000, 0xD8000000, 0xDC000000, 0xE2000000, 0xE6000000, 0xEC000000, 
        0xF1000000, 0xF5000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x006DEDD4, 0x0022A474, 0x00225459, 0x002B8669, 0x00277D62, 0x002B8669, 0x002B8669, 0x0022A474, 0x002BC98C, 0x0042E4B3, 0x005FE4B6, 0x002B8669, 0x00225459, 0x00226760, 0x0022B180, 0x002BC98C, 0x0035C397, 
        0x003BBA87, 0x0022B180, 0x002BA485, 0x002BC98C, 0x0046D69A, 0x002EE1AD, 0x005FE4B6, 0x0046D69A, 0x003BBA87, 0x0042E4B3, 0x002BC98C, 0x04274655, 0x011C2B48, 0x00222248, 0x00277D62, 0x0035A48F, 0x005FE4B6, 0x00277D62, 0x0022384C, 0x00276B62, 
        0x002B8669, 0x002B8669, 0x00229A7E, 0x002BA485, 0x0046B497, 0x0146C3A8, 0x0378C6BE, 0x005FE4B6, 0x0050A689, 0x00226760, 0x00225A6F, 0x00225459, 0x00225565, 0x00225565, 0x00274057, 0x00225A6F, 0x00224060, 0x00274057, 0x00223D5A, 0x00225565, 
        0x00225A6F, 0x00225A6F, 0x00223D5A, 0x001C003B, 0x001C0038, 0x001C003B, 0x001C0038, 0x00220040, 0x00223D5A, 0x0022786F, 0x011C2B48, 0x001C003B, 0x001C003B, 0x001C003D, 0x00150040, 0x001C005A, 0x001C0066, 0x001C0066, 0x001C0066, 0x0027154C, 
        0x00150035, 0x00150035, 0x004A4062, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5D000000, 0x60000000, 0x65000000, 0x6C000000, 0x73000000, 0x7A000015, 0x83000000, 0x8B000000, 0x95000000, 
        0x9C000000, 0xA4000000, 0xA7000000, 0xAE000000, 0xB1000000, 0xB1000000, 0xB1000000, 0xAE000000, 0xAB000000, 0xA4000000, 0x9E000015, 0x95000000, 0x8E000000, 0x85000000, 0x7F001515, 0x79000000, 0x74000015, 0x74000015, 0x74000015, 0x74000015, 
        0x74000015, 0x7A000015, 0x81000015, 0x88000015, 0x90000015, 0x9A000015, 0xA2000015, 0xAE000000, 0xB7000000, 0xC1000000, 0xCB000000, 0xD3000000, 0xD8000000, 0xDD000000, 0xE2000000, 0xE5000000, 0xE8000000, 0xEB000000, 0xEE000000, 0xF2000000, 
        0xF5000000, 0xF9000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x006DEDD4, 0x00276B62, 0x00220042, 0x01223D4C, 0x00277D62, 0x002B8669, 0x002B8669, 0x002B8669, 0x0022BC83, 0x0027D297, 0x004CEAC9, 0x002BC98C, 0x011C3B4A, 0x001C0038, 0x002B545D, 0x0022B180, 0x002BC98C, 
        0x0035C397, 0x0027B498, 0x0027B498, 0x002BA485, 0x0022BC83, 0x0027D297, 0x0046D69A, 0x005FE4B6, 0x002EE1AD, 0x003BBA87, 0x00276B62, 0x00274057, 0x01223D4C, 0x00222248, 0x00276B62, 0x0022786F, 0x0046D69A, 0x005FE4B6, 0x01223D4C, 0x01223D4C, 
        0x00277D62, 0x002B8669, 0x0022A474, 0x0022A474, 0x002B8669, 0x0022A474, 0x003BBA87, 0x0035C397, 0x005FE4B6, 0x005FE4B6, 0x0050A689, 0x00356762, 0x002B545D, 0x00274057, 0x00225565, 0x00274057, 0x00225565, 0x00224060, 0x04274655, 0x00223D5A, 
        0x00274057, 0x002E3255, 0x00223D5A, 0x011C2B48, 0x00220042, 0x00220042, 0x001C003D, 0x001C003B, 0x001C0038, 0x001C003B, 0x001C003D, 0x001C003B, 0x00220042, 0x0027154C, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x0027154C, 
        0x00150035, 0x001C0035, 0x001C005A, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5C000000, 0x5F000000, 0x65000000, 0x6C000000, 0x73000000, 0x7D000000, 0x88000000, 0x91000000, 0x9C000000, 0xA7000000, 
        0xAF000015, 0xB6000000, 0xBB000000, 0xC1000000, 0xC4000000, 0xC4000000, 0xC4000000, 0xC3000000, 0xBD000000, 0xB9000000, 0xB1000000, 0xA7000000, 0x9E000015, 0x95000000, 0x8B001515, 0x85000000, 0x81000015, 0x7A000015, 0x7A000015, 0x7F001515, 
        0x81001C15, 0x88000015, 0x90000015, 0x94001C15, 0x9E000015, 0xA7000015, 0xB3000015, 0xBD000000, 0xC8000000, 0xD0000000, 0xD9000000, 0xE0000000, 0xE5000000, 0xEA000000, 0xED000000, 0xEF000000, 0xF1000000, 0xF3000000, 0xF5000000, 0xF7000000, 
        0xF9000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x005FE4B6, 0x01223D4C, 0x00220042, 0x001C0046, 0x00277D62, 0x00277D62, 0x002B8669, 0x002B8669, 0x00229A7E, 0x0035C397, 0x0146C3A8, 0x005FE4B6, 0x002B8669, 0x011C3B4A, 0x011C2B48, 0x00225459, 0x002BA485, 
        0x0027D297, 0x0035C397, 0x0027B498, 0x0027B498, 0x002BA485, 0x0022B180, 0x002BC98C, 0x0027D297, 0x0042E4B3, 0x0046D69A, 0x00226760, 0x0022384C, 0x0022384C, 0x011C2B48, 0x00276B62, 0x00277D62, 0x00229A7E, 0x005FE4B6, 0x0046D69A, 0x00225459, 
        0x00225459, 0x00226760, 0x002B8669, 0x0022A474, 0x002BAF7D, 0x0022A474, 0x00229A7E, 0x0022A474, 0x0022B180, 0x0035C397, 0x005FE4B6, 0x005FE4B6, 0x00449582, 0x002B545D, 0x00274057, 0x01273250, 0x00274057, 0x0022384C, 0x00274057, 0x00222248, 
        0x00222248, 0x0027154C, 0x01273250, 0x002E3255, 0x00220040, 0x001C0046, 0x0027154C, 0x0027154C, 0x0027154C, 0x001C005A, 0x001C005A, 0x001C005A, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x0027154C, 
        0x001C0038, 0x0015002E, 0x00220042, 0x3422384A, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x59000000, 0x5B000000, 0x5F000000, 0x63000000, 0x69000000, 0x73000000, 0x7D000000, 0x88000000, 0x95000000, 0xA2000015, 0xAE000000, 0xB9000000, 
        0xC3000000, 0xC9000000, 0xCE000000, 0xD3000000, 0xD6000000, 0xD80000