/*********************************************************************
*                SEGGER Microcontroller GmbH                         *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2018  SEGGER Microcontroller GmbH                *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.48 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software  has been licensed to  Cypress Semiconductor Corporation,
whose registered  office is situated  at 198 Champion Ct. San Jose, CA 
95134 USA  solely for the  purposes of creating  libraries for Cypress
PSoC3 and  PSoC5 processor-based devices,  sublicensed and distributed
under  the  terms  and  conditions  of  the  Cypress  End User License
Agreement.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information
Licensor:                 SEGGER Microcontroller Systems LLC
Licensed to:              Cypress Semiconductor Corp, 198 Champion Ct., San Jose, CA 95134, USA
Licensed SEGGER software: emWin
License number:           GUI-00319
License model:            Services and License Agreement, signed June 10th, 2009
Licensed platform:        Any Cypress platform (Initial targets are: PSoC3, PSoC5)
----------------------------------------------------------------------
Support and Update Agreement (SUA)
SUA period:               2009-06-12 - 2022-07-27
Contact to extend SUA:    sales@segger.com
----------------------------------------------------------------------
File        : SPRITE_CreateAnimSpriteByGIF.c
Purpose     : Shows how to create an animated sprite using a GIF
Requirements: WindowManager - ( )
              MemoryDevices - (x)
              AntiAliasing  - ( )
              VNC-Server    - ( )
              PNG-Library   - ( )
              TrueTypeFonts - ( )
----------------------------------------------------------------------
*/

#include <stdlib.h>
#include <string.h>

#include "GUI.h"

/*********************************************************************
*
*       Static (const) data
*
**********************************************************************
*/
static const U8 _acGIF[] = {
  0x47, 0x49, 0x46, 0x38, 0x39, 0x61, 0x20, 0x00, 0x20, 0x00, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x33, 0x00, 0x00, 0x66, 0x00, 0x00, 0x99, 0x00, 0x00, 0xCC, 0x00, 0x00, 0xFF, 0x33, 0x00, 0x00, 0x33, 0x00, 0x33, 0x33, 0x00, 0x66,
  0x33, 0x00, 0x99, 0x33, 0x00, 0xCC, 0x33, 0x00, 0xFF, 0x66, 0x00, 0x00, 0x66, 0x00, 0x33, 0x66, 0x00, 0x66, 0x66, 0x00, 0x99, 0x66, 0x00, 0xCC, 0x66, 0x00, 0xFF, 0x99, 0x00, 0x00, 0x99, 0x00, 0x33, 0x99, 0x00, 0x66, 0x99, 0x00, 0x99, 0x99,
  0x00, 0xCC, 0x99, 0x00, 0xFF, 0xCC, 0x00, 0x00, 0xCC, 0x00, 0x33, 0xCC, 0x00, 0x66, 0xCC, 0x00, 0x99, 0xCC, 0x00, 0xCC, 0xCC, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x33, 0xFF, 0x00, 0x66, 0xFF, 0x00, 0x99, 0xFF, 0x00, 0xCC, 0xFF, 0x00,
  0xFF, 0x00, 0x33, 0x00, 0x00, 0x33, 0x33, 0x00, 0x33, 0x66, 0x00, 0x33, 0x99, 0x00, 0x33, 0xCC, 0x00, 0x33, 0xFF, 0x33, 0x33, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x66, 0x33, 0x33, 0x99, 0x33, 0x33, 0xCC, 0x33, 0x33, 0xFF, 0x66, 0x33, 0x00,
  0x66, 0x33, 0x33, 0x66, 0x33, 0x66, 0x66, 0x33, 0x99, 0x66, 0x33, 0xCC, 0x66, 0x33, 0xFF, 0x99, 0x33, 0x00, 0x99, 0x33, 0x33, 0x99, 0x33, 0x66, 0x99, 0x33, 0x99, 0x99, 0x33, 0xCC, 0x99, 0x33, 0xFF, 0xCC, 0x33, 0x00, 0xCC, 0x33, 0x33, 0xCC,
  0x33, 0x66, 0xCC, 0x33, 0x99, 0xCC, 0x33, 0xCC, 0xCC, 0x33, 0xFF, 0xFF, 0x33, 0x00, 0xFF, 0x33, 0x33, 0xFF, 0x33, 0x66, 0xFF, 0x33, 0x99, 0xFF, 0x33, 0xCC, 0xFF, 0x33, 0xFF, 0x00, 0x66, 0x00, 0x00, 0x66, 0x33, 0x00, 0x66, 0x66, 0x00, 0x66,
  0x99, 0x00, 0x66, 0xCC, 0x00, 0x66, 0xFF, 0x33, 0x66, 0x00, 0x33, 0x66, 0x33, 0x33, 0x66, 0x66, 0x33, 0x66, 0x99, 0x33, 0x66, 0xCC, 0x33, 0x66, 0xFF, 0x66, 0x66, 0x00, 0x66, 0x66, 0x33, 0x66, 0x66, 0x66, 0x66, 0x66, 0x99, 0x66, 0x66, 0xCC,
  0x66, 0x66, 0xFF, 0x99, 0x66, 0x00, 0x99, 0x66, 0x33, 0x99, 0x66, 0x66, 0x99, 0x66, 0x99, 0x99, 0x66, 0xCC, 0x99, 0x66, 0xFF, 0xCC, 0x66, 0x00, 0xCC, 0x66, 0x33, 0xCC, 0x66, 0x66, 0xCC, 0x66, 0x99, 0xCC, 0x66, 0xCC, 0xCC, 0x66, 0xFF, 0xFF,
  0x66, 0x00, 0xFF, 0x66, 0x33, 0xFF, 0x66, 0x66, 0xFF, 0x66, 0x99, 0xFF, 0x66, 0xCC, 0xFF, 0x66, 0xFF, 0x00, 0x99, 0x00, 0x00, 0x99, 0x33, 0x00, 0x99, 0x66, 0x00, 0x99, 0x99, 0x00, 0x99, 0xCC, 0x00, 0x99, 0xFF, 0x33, 0x99, 0x00, 0x33, 0x99,
  0x33, 0x33, 0x99, 0x66, 0x33, 0x99, 0x99, 0x33, 0x99, 0xCC, 0x33, 0x99, 0xFF, 0x66, 0x99, 0x00, 0x66, 0x99, 0x33, 0x66, 0x99, 0x66, 0x66, 0x99, 0x99, 0x66, 0x99, 0xCC, 0x66, 0x99, 0xFF, 0x99, 0x99, 0x00, 0x99, 0x99, 0x33, 0x99, 0x99, 0x66,
  0x99, 0x99, 0x99, 0x99, 0x99, 0xCC, 0x99, 0x99, 0xFF, 0xCC, 0x99, 0x00, 0xCC, 0x99, 0x33, 0xCC, 0x99, 0x66, 0xCC, 0x99, 0x99, 0xCC, 0x99, 0xCC, 0xCC, 0x99, 0xFF, 0xFF, 0x99, 0x00, 0xFF, 0x99, 0x33, 0xFF, 0x99, 0x66, 0xFF, 0x99, 0x99, 0xFF,
  0x99, 0xCC, 0xFF, 0x99, 0xFF, 0x00, 0xCC, 0x00, 0x00, 0xCC, 0x33, 0x00, 0xCC, 0x66, 0x00, 0xCC, 0x99, 0x00, 0xCC, 0xCC, 0x00, 0xCC, 0xFF, 0x33, 0xCC, 0x00, 0x33, 0xCC, 0x33, 0x33, 0xCC, 0x66, 0x33, 0xCC, 0x99, 0x33, 0xCC, 0xCC, 0x33, 0xCC,
  0xFF, 0x66, 0xCC, 0x00, 0x66, 0xCC, 0x33, 0x66, 0xCC, 0x66, 0x66, 0xCC, 0x99, 0x66, 0xCC, 0xCC, 0x66, 0xCC, 0xFF, 0x99, 0xCC, 0x00, 0x99, 0xCC, 0x33, 0x99, 0xCC, 0x66, 0x99, 0xCC, 0x99, 0x99, 0xCC, 0xCC, 0x99, 0xCC, 0xFF, 0xCC, 0xCC, 0x00,
  0xCC, 0xCC, 0x33, 0xCC, 0xCC, 0x66, 0xCC, 0xCC, 0x99, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xFF, 0xFF, 0xCC, 0x00, 0xFF, 0xCC, 0x33, 0xFF, 0xCC, 0x66, 0xFF, 0xCC, 0x99, 0xFF, 0xCC, 0xCC, 0xFF, 0xCC, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0xFF, 0x33, 0x00,
  0xFF, 0x66, 0x00, 0xFF, 0x99, 0x00, 0xFF, 0xCC, 0x00, 0xFF, 0xFF, 0x33, 0xFF, 0x00, 0x33, 0xFF, 0x33, 0x33, 0xFF, 0x66, 0x33, 0xFF, 0x99, 0x33, 0xFF, 0xCC, 0x33, 0xFF, 0xFF, 0x66, 0xFF, 0x00, 0x66, 0xFF, 0x33, 0x66, 0xFF, 0x66, 0x66, 0xFF,
  0x99, 0x66, 0xFF, 0xCC, 0x66, 0xFF, 0xFF, 0x99, 0xFF, 0x00, 0x99, 0xFF, 0x33, 0x99, 0xFF, 0x66, 0x99, 0xFF, 0x99, 0x99, 0xFF, 0xCC, 0x99, 0xFF, 0xFF, 0xCC, 0xFF, 0x00, 0xCC, 0xFF, 0x33, 0xCC, 0xFF, 0x66, 0xCC, 0xFF, 0x99, 0xCC, 0xFF, 0xCC,
  0xCC, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x33, 0xFF, 0xFF, 0x66, 0xFF, 0xFF, 0x99, 0xFF, 0xFF, 0xCC, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0xFF, 0x0B, 0x4E, 0x45, 0x54, 0x53, 0x43, 0x41, 0x50, 0x45, 0x32, 0x2E, 0x30, 0x03, 0x01, 0xE8, 0x03, 0x00,
  0x21, 0xF9, 0x04, 0x09, 0x14, 0x00, 0xD2, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x07, 0x08, 0x94, 0x00, 0xA5, 0x09, 0x1C, 0x48, 0xB0, 0xA0, 0xC1, 0x83, 0x08, 0x13, 0x2A, 0x5C, 0xC8, 0xB0, 0xA1, 0xC3, 0x87, 0x10, 0x23,
  0x46, 0x7C, 0x43, 0xB1, 0xA2, 0x45, 0x8A, 0x00, 0x24, 0x4A, 0xA3, 0x98, 0xAB, 0x63, 0xAE, 0x8B, 0x6F, 0x32, 0x6A, 0x04, 0x40, 0xB2, 0xA4, 0x49, 0x91, 0x1A, 0x03, 0xB1, 0x5A, 0xC9, 0x92, 0x25, 0x4A, 0x89, 0x2A, 0xAF, 0x5D, 0x6B, 0xB9, 0xF2,
  0x65, 0xC4, 0x98, 0x33, 0x69, 0xDA, 0x84, 0xA8, 0x12, 0xC0, 0x35, 0x00, 0xAC, 0x80, 0x0A, 0xD5, 0x38, 0x50, 0x68, 0xD0, 0xA3, 0x3B, 0x25, 0x1A, 0x1D, 0x4A, 0xB4, 0xE0, 0xD2, 0xA6, 0x07, 0x99, 0x42, 0x2D, 0xD8, 0x73, 0x2A, 0x55, 0x97, 0x56,
  0x05, 0xC6, 0xC4, 0x3A, 0x15, 0x67, 0xCB, 0xA4, 0x0F, 0xBD, 0xEA, 0x6C, 0x2A, 0xF6, 0x2B, 0x59, 0x56, 0x32, 0x69, 0x06, 0x3D, 0x9B, 0x76, 0x2C, 0x51, 0x90, 0x16, 0xC1, 0x32, 0xE4, 0xE8, 0x11, 0xA4, 0x5C, 0x85, 0x27, 0xF3, 0x92, 0xCC, 0xCA,
  0xB7, 0xAF, 0xDF, 0xBF, 0x80, 0x09, 0x06, 0x04, 0x00, 0x21, 0xF9, 0x04, 0x09, 0x14, 0x00, 0xD2, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x07, 0x08, 0x97, 0x00, 0xA5, 0x09, 0x1C, 0x48, 0xB0, 0xA0, 0xC1, 0x83, 0x08, 0x13,
  0x2A, 0x5C, 0xC8, 0xB0, 0xA1, 0xC3, 0x87, 0x10, 0x23, 0x46, 0x7C, 0x43, 0xB1, 0xA2, 0x45, 0x8A, 0x00, 0x24, 0x4A, 0xA3, 0x98, 0xAB, 0x63, 0xAE, 0x8B, 0x6F, 0x32, 0x6A, 0x04, 0x40, 0xB2, 0xA4, 0x49, 0x91, 0x1A, 0x03, 0xB1, 0x5A, 0xC9, 0x92,
  0x25, 0x4A, 0x89, 0x2A, 0xAF, 0x5D, 0x6B, 0xB9, 0xF2, 0x65, 0xC4, 0x98, 0x33, 0x69, 0xDA, 0x84, 0xA8, 0x12, 0xC0, 0x35, 0x00, 0x2E, 0x59, 0xED, 0x84, 0x08, 0xB4, 0xA8, 0x50, 0xA1, 0x1A, 0x0B, 0x1A, 0x2D, 0x9A, 0xD4, 0xE0, 0xD2, 0xA6, 0x07,
  0x99, 0x42, 0x35, 0xD8, 0x73, 0x6A, 0x41, 0x95, 0x35, 0xAD, 0x0A, 0x8C, 0x09, 0x14, 0xE9, 0x54, 0x9C, 0x2D, 0x87, 0x3E, 0x04, 0xAB, 0xB3, 0x29, 0xD9, 0xB0, 0x66, 0x59, 0xC9, 0xA4, 0xE9, 0x35, 0xA5, 0xDA, 0x9C, 0x68, 0x93, 0x82, 0xB4, 0x28,
  0x96, 0x21, 0x47, 0x8F, 0x20, 0xEB, 0x2A, 0x3C, 0xC9, 0x97, 0xA4, 0xD6, 0xBF, 0x80, 0x03, 0x0B, 0x1E, 0x4C, 0x30, 0x20, 0x00, 0x21, 0xF9, 0x04, 0x09, 0x14, 0x00, 0xD2, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x07, 0x08,
  0x97, 0x00, 0xA5, 0x09, 0x1C, 0x48, 0xB0, 0xA0, 0xC1, 0x83, 0x08, 0x13, 0x2A, 0x5C, 0xC8, 0xB0, 0xA1, 0xC3, 0x87, 0x10, 0x23, 0x46, 0x7C, 0x43, 0xB1, 0xA2, 0x45, 0x8A, 0x00, 0x24, 0x4A, 0xA3, 0x98, 0xAB, 0x63, 0xAE, 0x8B, 0x6F, 0x32, 0x6A,
  0x04, 0x40, 0xB2, 0xA4, 0x49, 0x91, 0x1A, 0x03, 0xB1, 0x5A, 0xC9, 0x92, 0x25, 0x4A, 0x89, 0x2A, 0xAF, 0x5D, 0x6B, 0xB9, 0xF2, 0x65, 0xC4, 0x98, 0x33, 0x69, 0xDA, 0x84, 0xA8, 0x12, 0x40, 0xCE, 0x9A, 0xAC, 0x76, 0x42, 0x04, 0x10, 0xB4, 0x28,
  0x51, 0xA1, 0x11, 0x8F, 0x1A, 0xD5, 0x78, 0x50, 0x29, 0x52, 0xA6, 0x47, 0x99, 0x26, 0xEC, 0x29, 0xF5, 0xA0, 0xCA, 0x9A, 0x55, 0x09, 0xC6, 0x24, 0x1A, 0x34, 0xAB, 0x34, 0x9C, 0x2D, 0x9F, 0x36, 0x04, 0xCB, 0x15, 0x2B, 0x53, 0xB0, 0x3A, 0xA5,
  0xA2, 0x0D, 0xAB, 0x96, 0x95, 0x4C, 0x9A, 0x5D, 0x99, 0x82, 0xB4, 0x28, 0x56, 0x21, 0x47, 0x8F, 0x20, 0xEB, 0x22, 0x3C, 0xC9, 0x97, 0xA4, 0xD7, 0xBF, 0x80, 0x03, 0x0B, 0x1E, 0xAC, 0x30, 0x20, 0x00, 0x21, 0xF9, 0x04, 0x09, 0x14, 0x00, 0xD2,
  0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x07, 0x08, 0x95, 0x00, 0xA5, 0x09, 0x1C, 0x48, 0xB0, 0xA0, 0xC1, 0x83, 0x08, 0x13, 0x2A, 0x5C, 0xC8, 0xB0, 0xA1, 0xC3, 0x87, 0x10, 0x23, 0x46, 0x7C, 0x43, 0xB1, 0xA2, 0x45, 0x8A,
  0x00, 0x24, 0x4A, 0xA3, 0x98, 0xAB, 0x63, 0xAE, 0x8B, 0x6F, 0x32, 0x6A, 0x04, 0x40, 0xB2, 0xA4, 0x49, 0x91, 0x1A, 0x03, 0xB1, 0x5A, 0xC9, 0x92, 0x25, 0x4A, 0x89, 0x2A, 0xAF, 0x5D, 0x6B, 0xB9, 0xF2, 0x65, 0xC4, 0x98, 0x33, 0x69, 0xDA, 0x84,
  0xA8, 0x12, 0x40, 0xCE, 0x96, 0x3B, 0x21, 0x02, 0x60, 0x35, 0xB4, 0x28, 0x51, 0x8D, 0x05, 0x8D, 0x16, 0x45, 0x6A, 0x50, 0x29, 0xD3, 0x83, 0x4B, 0x9F, 0x1A, 0xEC, 0x29, 0xB5, 0xA0, 0xCA, 0x9A, 0x55, 0x05, 0xC6, 0x1C, 0x7A, 0x54, 0x2A, 0x4E,
  0xA0, 0x4F, 0xBF, 0x72, 0xC5, 0x8A, 0xF4, 0xAB, 0x4E, 0xA6, 0x62, 0xC1, 0x96, 0x65, 0x25, 0x93, 0x66, 0x57, 0x8D, 0x20, 0x2D, 0x06, 0x6D, 0xC8, 0xD1, 0x23, 0xC8, 0xB9, 0x0B, 0x4F, 0xEA, 0x25, 0x99, 0xB5, 0xAF, 0xDF, 0xBF, 0x80, 0x03, 0x13,
  0x0C, 0x08, 0x00, 0x21, 0xF9, 0x04, 0x09, 0x14, 0x00, 0xD2, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x07, 0x08, 0x95, 0x00, 0xA5, 0x09, 0x1C, 0x48, 0xB0, 0xA0, 0xC1, 0x83, 0x08, 0x13, 0x2A, 0x5C, 0xC8, 0xB0, 0xA1, 0xC3,
  0x87, 0x10, 0x23, 0x46, 0x7C, 0x43, 0xB1, 0xA2, 0x45, 0x8A, 0x00, 0x24, 0x4A, 0xA3, 0x98, 0xAB, 0x63, 0xAE, 0x8B, 0x6F, 0x32, 0x6A, 0x04, 0x40, 0xB2, 0xA4, 0x49, 0x91, 0x1A, 0x03, 0xB1, 0x5A, 0xC9, 0x92, 0x25, 0x4A, 0x89, 0x2A, 0xAF, 0x5D,
  0x6B, 0xB9, 0xF2, 0x65, 0xC4, 0x98, 0x33, 0x69, 0xDA, 0x84, 0x88, 0x93, 0x26, 0xAB, 0x9D, 0x10, 0x01, 0xFC, 0x1C, 0x2A, 0x14, 0x68, 0xC4, 0xA2, 0x44, 0x35, 0x1E, 0x44, 0x6A, 0x54, 0x69, 0x51, 0xA5, 0x09, 0x55, 0x36, 0x4D, 0xE9, 0x12, 0x6A,
  0xC1, 0x98, 0x42, 0x7F, 0x5A, 0x15, 0xD8, 0xB3, 0x2A, 0xD4, 0x9E, 0x59, 0x6B, 0x7E, 0x65, 0x25, 0xD3, 0xE7, 0xD4, 0x85, 0x60, 0x5B, 0x9E, 0x55, 0x88, 0x33, 0xAC, 0x58, 0xA5, 0x20, 0x2D, 0xAE, 0x45, 0xC8, 0xD1, 0x23, 0xC8, 0xB9, 0x06, 0x4F,
  0xEA, 0x25, 0xB9, 0xB5, 0xAF, 0xDF, 0xBF, 0x80, 0x03, 0x43, 0x0C, 0x08, 0x00, 0x21, 0xF9, 0x04, 0x09, 0x14, 0x00, 0xD2, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x07, 0x08, 0x97, 0x00, 0xA5, 0x09, 0x1C, 0x48, 0xB0, 0xA0,
  0xC1, 0x83, 0x08, 0x13, 0x2A, 0x5C, 0xC8, 0xB0, 0xA1, 0xC3, 0x87, 0x10, 0x23, 0x46, 0x7C, 0x43, 0xB1, 0xA2, 0x45, 0x8A, 0x00, 0x24, 0x4A, 0xA3, 0x98, 0xAB, 0x63, 0xAE, 0x8B, 0x6F, 0x32, 0x6A, 0x04, 0x40, 0xB2, 0xA4, 0x49, 0x91, 0x1A, 0x03,
  0xB1, 0x5A, 0xC9, 0x92, 0x25, 0x4A, 0x89, 0x2A, 0xAF, 0x5D, 0x6B, 0xB9, 0xF2, 0x65, 0xC4, 0x98, 0x33, 0x69, 0xDA, 0x84, 0x88, 0x93, 0x26, 0xAB, 0x9D, 0x10, 0x01, 0xFC, 0x74, 0xF9, 0x53, 0x63, 0x41, 0xA1, 0x48, 0x8B, 0x1A, 0x3D, 0x3A, 0x14,
  0xE8, 0x52, 0xA4, 0x4B, 0x11, 0xAA, 0x74, 0x6A, 0x54, 0x65, 0xCD, 0xA8, 0x04, 0x63, 0x0A, 0x55, 0x1A, 0xB5, 0xA7, 0xCB, 0xAE, 0xAC, 0x64, 0x0E, 0xFD, 0x5A, 0x35, 0x6C, 0xCE, 0x96, 0x54, 0x19, 0xF6, 0xDC, 0x7A, 0xB5, 0xAC, 0xCC, 0xA4, 0x6D,
  0x35, 0x82, 0xB4, 0x98, 0x56, 0x21, 0x47, 0x8F, 0x20, 0xEB, 0x22, 0x3C, 0xC9, 0x97, 0x24, 0xD6, 0xBF, 0x80, 0x03, 0x0B, 0x1E, 0x0C, 0x31, 0x20, 0x00, 0x21, 0xF9, 0x04, 0x09, 0x14, 0x00, 0xD2, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00,
  0x20, 0x00, 0x07, 0x08, 0x96, 0x00, 0xA5, 0x09, 0x1C, 0x48, 0xB0, 0xA0, 0xC1, 0x83, 0x08, 0x13, 0x2A, 0x5C, 0xC8, 0xB0, 0xA1, 0xC3, 0x87, 0x10, 0x23, 0x46, 0x7C, 0x43, 0xB1, 0xA2, 0x45, 0x8A, 0x00, 0x24, 0x4A, 0xA3, 0x98, 0xAB, 0x63, 0xAE,
  0x8B, 0x6F, 0x32, 0x6A, 0x04, 0x40, 0xB2, 0xA4, 0x49, 0x91, 0x1A, 0x03, 0xB1, 0x5A, 0xC9, 0x92, 0x25, 0x4A, 0x89, 0x2A, 0xAF, 0x5D, 0x6B, 0xB9, 0xF2, 0x65, 0xC4, 0x98, 0x33, 0x69, 0xDA, 0x84, 0x88, 0x93, 0x26, 0xAB, 0x9D, 0x10, 0x01, 0xFC,
  0xD4, 0xA9, 0xB1, 0xA0, 0xD0, 0xA3, 0x3F, 0x8B, 0x1A, 0x44, 0x0A, 0x54, 0xE9, 0x51, 0xA5, 0x08, 0x55, 0x36, 0x2D, 0xAA, 0xB2, 0x26, 0x54, 0x82, 0x31, 0x85, 0x26, 0xBD, 0xDA, 0xD3, 0x25, 0xD4, 0x9E, 0x5A, 0xAD, 0x52, 0x65, 0x25, 0xD3, 0xE7,
  0x54, 0x86, 0x60, 0x5B, 0x9E, 0x5D, 0x28, 0xF5, 0x1A, 0x52, 0xB1, 0x1A, 0x41, 0x5A, 0x5C, 0x9B, 0x90, 0xA3, 0x47, 0x90, 0x74, 0x0F, 0x9E, 0xDC, 0x4B, 0xF2, 0xAA, 0xDF, 0xBF, 0x80, 0x03, 0x0B, 0x86, 0x18, 0x10, 0x00, 0x21, 0xF9, 0x04, 0x09,
  0x14, 0x00, 0xD2, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x07, 0x08, 0x97, 0x00, 0xA5, 0x09, 0x1C, 0x48, 0xB0, 0xA0, 0xC1, 0x83, 0x08, 0x13, 0x2A, 0x5C, 0xC8, 0xB0, 0xA1, 0xC3, 0x87, 0x10, 0x23, 0x46, 0x7C, 0x43, 0xB1,
  0xA2, 0x45, 0x8A, 0x00, 0x24, 0x4A, 0xA3, 0x98, 0xAB, 0x63, 0xAE, 0x8B, 0x6F, 0x32, 0x6A, 0x04, 0x40, 0xB2, 0xA4, 0x49, 0x91, 0x1A, 0x03, 0xB1, 0x5A, 0xC9, 0x92, 0x25, 0x4A, 0x89, 0x2A, 0xAF, 0x5D, 0x6B, 0xB9, 0xF2, 0x65, 0xC4, 0x98, 0x33,
  0x69, 0xDA, 0x84, 0x88, 0x93, 0x26, 0xAB, 0x9D, 0x10, 0x01, 0xF8, 0xFC, 0xA9, 0xB1, 0xA0, 0xD0, 0xA3, 0x44, 0x8B, 0x1A, 0xFD, 0x99, 0x54, 0xE9, 0x52, 0xA0, 0x4E, 0x55, 0x42, 0x2D, 0xAA, 0xB2, 0xA6, 0x53, 0x82, 0x31, 0x85, 0x36, 0x55, 0xDA,
  0xD3, 0x65, 0x54, 0x56, 0x32, 0x99, 0x7A, 0xA5, 0x0A, 0x36, 0x67, 0xCB, 0xA9, 0x0C, 0x7B, 0x6A, 0xB5, 0x4A, 0x16, 0xC0, 0x35, 0xA4, 0x47, 0x95, 0x82, 0xB4, 0x88, 0x56, 0x21, 0x47, 0x8F, 0x20, 0xEB, 0x22, 0x3C, 0xC9, 0x97, 0xE4, 0xD5, 0xBF,
  0x80, 0x03, 0x0B, 0x1E, 0x0C, 0x31, 0x20, 0x00, 0x21, 0xF9, 0x04, 0x09, 0x14, 0x00, 0xD2, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x07, 0x08, 0x98, 0x00, 0xA5, 0x09, 0x1C, 0x48, 0xB0, 0xA0, 0xC1, 0x83, 0x08, 0x13, 0x2A,
  0x5C, 0xC8, 0xB0, 0xA1, 0xC3, 0x87, 0x10, 0x23, 0x46, 0x7C, 0x43, 0xB1, 0xA2, 0x45, 0x8A, 0x00, 0x24, 0x4A, 0xA3, 0x98, 0xAB, 0x63, 0xAE, 0x8B, 0x6F, 0x32, 0x6A, 0x04, 0x40, 0xB2, 0xA4, 0x49, 0x91, 0x1A, 0x03, 0xB1, 0x5A, 0xC9, 0x92, 0x25,
  0x4A, 0x89, 0x2A, 0xAF, 0x5D, 0x6B, 0xB9, 0xF2, 0x65, 0xC4, 0x98, 0x33, 0x69, 0xDA, 0x84, 0x88, 0x93, 0x26, 0xAB, 0x9D, 0x10, 0x01, 0xF8, 0xFC, 0xA9, 0xB1, 0xA0, 0x50, 0xA1, 0x35, 0x8B, 0x1A, 0x3C, 0x4A, 0x54, 0xE9, 0xD2, 0xA6, 0x4E, 0x0B,
  0xAA, 0x04, 0xAA, 0x54, 0x65, 0xD2, 0xA8, 0x02, 0x63, 0x22, 0xA5, 0xCA, 0x93, 0x95, 0xCC, 0x96, 0x5C, 0x1B, 0xF6, 0x44, 0x7A, 0x35, 0xA5, 0xD7, 0x9C, 0x60, 0xAB, 0x7A, 0x65, 0xEA, 0x52, 0x2D, 0x80, 0x6B, 0x4C, 0x8F, 0x2A, 0x05, 0x69, 0x31,
  0xAC, 0x42, 0x8E, 0x1E, 0x41, 0xDA, 0x45, 0x78, 0xB2, 0x2F, 0x49, 0xAC, 0x80, 0x03, 0x0B, 0x1E, 0x4C, 0x58, 0x61, 0x40, 0x00, 0x21, 0xF9, 0x04, 0x09, 0x14, 0x00, 0xD2, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x07, 0x08,
  0x95, 0x00, 0xA5, 0x09, 0x1C, 0x48, 0xB0, 0xA0, 0xC1, 0x83, 0x08, 0x13, 0x2A, 0x5C, 0xC8, 0xB0, 0xA1, 0xC3, 0x87, 0x10, 0x23, 0x46, 0x7C, 0x43, 0xB1, 0xA2, 0x45, 0x8A, 0x00, 0x24, 0x4A, 0xA3, 0x98, 0xAB, 0x63, 0xAE, 0x8B, 0x6F, 0x32, 0x6A,
  0x04, 0x40, 0xB2, 0xA4, 0x49, 0x91, 0x1A, 0x03, 0xB1, 0x5A, 0xC9, 0x92, 0x25, 0x4A, 0x89, 0x2A, 0xAF, 0x5D, 0x6B, 0xB9, 0xF2, 0x65, 0xC4, 0x98, 0x33, 0x69, 0xDA, 0x84, 0x88, 0x93, 0x26, 0xAB, 0x9D, 0x10, 0x01, 0xF8, 0xFC, 0xA9, 0xB1, 0xA0,
  0xD0, 0x96, 0x40, 0x47, 0xFE, 0x24, 0x5A, 0xF4, 0xA0, 0xD0, 0xA4, 0x4D, 0x55, 0x42, 0x4D, 0xE9, 0xB2, 0x69, 0xC1, 0x98, 0x47, 0xA7, 0x3A, 0xEC, 0x59, 0x35, 0x2A, 0x2B, 0x99, 0x4B, 0xBB, 0x52, 0x05, 0xAB, 0xD3, 0xEB, 0xB5, 0xA7, 0x61, 0xB5,
  0x2A, 0x94, 0x7A, 0x76, 0xE9, 0xD3, 0xA6, 0x20, 0x2D, 0xAA, 0x45, 0xC8, 0xD1, 0x23, 0xC8, 0xB9, 0x06, 0x4F, 0xEA, 0x25, 0x69, 0xB5, 0xAF, 0xDF, 0xBF, 0x80, 0x03, 0x5B, 0x0D, 0x08, 0x00, 0x21, 0xF9, 0x04, 0x09, 0x14, 0x00, 0xD2, 0x00, 0x2C,
  0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x07, 0x08, 0x95, 0x00, 0xA5, 0x09, 0x1C, 0x48, 0xB0, 0xA0, 0xC1, 0x83, 0x08, 0x13, 0x2A, 0x5C, 0xC8, 0xB0, 0xA1, 0xC3, 0x87, 0x10, 0x23, 0x46, 0x7C, 0x43, 0xB1, 0xA2, 0x45, 0x8A, 0x00, 0x24,
  0x4A, 0xA3, 0x98, 0xAB, 0x63, 0xAE, 0x8B, 0x6F, 0x32, 0x6A, 0x04, 0x40, 0xB2, 0xA4, 0x49, 0x91, 0x1A, 0x03, 0xB1, 0x5A, 0xC9, 0x92, 0x25, 0x4A, 0x89, 0x2A, 0xAF, 0x5D, 0x6B, 0xB9, 0xF2, 0x65, 0xC4, 0x98, 0x33, 0x69, 0xDA, 0x84, 0x88, 0x93,
  0x26, 0xAB, 0x9D, 0x10, 0x01, 0xF8, 0xFC, 0xA9, 0xB1, 0xA0, 0xD0, 0x96, 0x40, 0x47, 0xBA, 0x2C, 0x8A, 0x50, 0x68, 0x52, 0xA6, 0x2A, 0x9F, 0xA6, 0x5C, 0xCA, 0x94, 0x60, 0xCC, 0xA3, 0x52, 0x1D, 0xF6, 0xA4, 0x5A, 0xB4, 0xE7, 0xD1, 0x9A, 0x50,
  0x59, 0xC9, 0xFC, 0x0A, 0xB6, 0xAB, 0x58, 0xA7, 0x3F, 0xCB, 0x4E, 0x05, 0x70, 0x0D, 0xAD, 0x53, 0xA6, 0x20, 0x2D, 0x66, 0x4D, 0xC8, 0xD1, 0x23, 0xC8, 0xB9, 0x07, 0x4F, 0xEA, 0x25, 0x59, 0xB5, 0xAF, 0xDF, 0xBF, 0x80, 0x03, 0x57, 0x0D, 0x08,
  0x00, 0x21, 0xF9, 0x04, 0x09, 0x14, 0x00, 0xD2, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x07, 0x08, 0x94, 0x00, 0xA5, 0x09, 0x1C, 0x48, 0xB0, 0xA0, 0xC1, 0x83, 0x08, 0x13, 0x2A, 0x5C, 0xC8, 0xB0, 0xA1, 0xC3, 0x87, 0x10,
  0x23, 0x46, 0x7C, 0x43, 0xB1, 0xA2, 0x45, 0x8A, 0x00, 0x24, 0x4A, 0xA3, 0x98, 0xAB, 0x63, 0xAE, 0x8B, 0x6F, 0x32, 0x6A, 0x04, 0x40, 0xB2, 0xA4, 0x49, 0x91, 0x1A, 0x03, 0xB1, 0x5A, 0xC9, 0x92, 0x25, 0x4A, 0x89, 0x2A, 0xAF, 0x5D, 0x6B, 0xB9,
  0xF2, 0x65, 0xC4, 0x98, 0x33, 0x69, 0xDA, 0x84, 0x88, 0x93, 0x26, 0xAB, 0x9D, 0x10, 0x01, 0xF8, 0xFC, 0xA9, 0xB1, 0xA0, 0xD0, 0x96, 0x40, 0x47, 0xBA, 0x2C, 0x8A, 0x50, 0x68, 0x52, 0xA6, 0x2A, 0x9F, 0xA6, 0x5C, 0xCA, 0x94, 0x60, 0x4C, 0xAA,
  0x55, 0x7B, 0x62, 0x9D, 0x2A, 0xF3, 0x27, 0x52, 0xA8, 0xAC, 0x64, 0x3A, 0xDD, 0x7A, 0x33, 0xEC, 0xD8, 0xA3, 0x52, 0x17, 0x46, 0xBD, 0x76, 0x96, 0x68, 0x51, 0x90, 0x16, 0xD3, 0x26, 0xE4, 0xE8, 0x11, 0xA4, 0xDC, 0x83, 0x27, 0xF3, 0x92, 0xAC,
  0xCA, 0xB7, 0xAF, 0xDF, 0xBF, 0x80, 0xAB, 0x06, 0x04, 0x00, 0x21, 0xF9, 0x04, 0x09, 0x14, 0x00, 0xD2, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x07, 0x08, 0x99, 0x00, 0xA5, 0x09, 0x1C, 0x48, 0xB0, 0xA0, 0xC1, 0x83, 0x08,
  0x13, 0x2A, 0x5C, 0xC8, 0xB0, 0xA1, 0xC3, 0x87, 0x10, 0x23, 0x4A, 0x3C, 0xF8, 0x06, 0xC0, 0xC4, 0x85, 0x6F, 0x2A, 0x5E, 0x4C, 0xF8, 0x26, 0x97, 0xC6, 0x8D, 0x05, 0x03, 0xB1, 0xEA, 0xF8, 0x11, 0xA4, 0x34, 0x91, 0xD7, 0xAE, 0x91, 0xB4, 0x08,
  0x12, 0xE5, 0x35, 0x56, 0x23, 0x33, 0xB2, 0xBC, 0x18, 0x28, 0x25, 0x4C, 0x98, 0x19, 0x4B, 0x4A, 0xAC, 0x79, 0xF3, 0x66, 0xCE, 0x99, 0x11, 0x79, 0xF6, 0x84, 0x09, 0xA0, 0x28, 0xCD, 0x97, 0x43, 0x81, 0x3A, 0x0C, 0xC4, 0x94, 0x29, 0xD2, 0x9E,
  0x4A, 0x1B, 0xBA, 0xB4, 0xC9, 0xAA, 0xA8, 0xD5, 0x9D, 0xAC, 0xA8, 0x12, 0xBD, 0x28, 0xB3, 0xEA, 0x35, 0x00, 0x50, 0xB9, 0x7A, 0x04, 0xF0, 0xB5, 0xEA, 0xCD, 0xA8, 0x0F, 0x57, 0x9A, 0x05, 0x6B, 0x74, 0xA3, 0x5A, 0xB6, 0x55, 0x4D, 0xFE, 0x5C,
  0x6B, 0x52, 0xE0, 0x5C, 0xB4, 0x5C, 0x65, 0xD6, 0x2D, 0xA8, 0x77, 0x2F, 0xC1, 0xB6, 0x7E, 0x03, 0x0B, 0x1E, 0x4C, 0xB8, 0x70, 0xC1, 0x80, 0x00, 0x21, 0xF9, 0x04, 0x09, 0x14, 0x00, 0xD2, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20,
  0x00, 0x07, 0x08, 0xA1, 0x00, 0xA5, 0x09, 0x1C, 0x48, 0xB0, 0xA0, 0xC1, 0x83, 0x08, 0x13, 0x2A, 0x5C, 0xC8, 0xB0, 0xA1, 0xC3, 0x87, 0x10, 0x23, 0x4A, 0x9C, 0x48, 0xB1, 0xA2, 0xC5, 0x8B, 0x11, 0xDF, 0xBC, 0x91, 0xF8, 0x06, 0x80, 0x42, 0x8D,
  0x00, 0x02, 0x89, 0x0C, 0x84, 0x70, 0x64, 0x20, 0x90, 0x1F, 0x73, 0x01, 0x60, 0xC5, 0x92, 0x95, 0xC7, 0x82, 0x81, 0x5A, 0xB2, 0x7A, 0xA3, 0x32, 0xE5, 0xCA, 0x6B, 0x38, 0x5D, 0x12, 0x8C, 0x89, 0x13, 0x27, 0xCD, 0x97, 0x08, 0x7F, 0xB2, 0xEA,
  0xC9, 0xF2, 0x25, 0xCF, 0x9E, 0xD7, 0x7E, 0xDA, 0x1C, 0x9A, 0xB3, 0xE8, 0x51, 0x99, 0x4A, 0x13, 0x82, 0x94, 0x49, 0xB5, 0xEA, 0xCC, 0x8E, 0x1F, 0x3B, 0xBA, 0xDC, 0xBA, 0x12, 0xC0, 0xCA, 0xAA, 0x28, 0xA5, 0x76, 0xEC, 0xCA, 0x55, 0xE0, 0x57,
  0xA8, 0x58, 0xC5, 0x92, 0xED, 0x4A, 0xF0, 0x2C, 0xCB, 0xB0, 0x41, 0xC7, 0x96, 0x2D, 0xE8, 0x16, 0xEE, 0x41, 0x90, 0x5E, 0xBD, 0x22, 0xCC, 0xEB, 0x35, 0xED, 0x5E, 0xA0, 0x0F, 0xF5, 0x62, 0x1C, 0x4C, 0xB8, 0xB0, 0xE1, 0xC3, 0x88, 0x13, 0x2B,
  0x5E, 0xCC, 0xB8, 0x60, 0x40, 0x00, 0x21, 0xF9, 0x04, 0x09, 0x14, 0x00, 0xD2, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x07, 0x08, 0x9E, 0x00, 0xA5, 0x09, 0x1C, 0x48, 0xB0, 0xA0, 0xC1, 0x83, 0x08, 0x13, 0x2A, 0x5C, 0xC8,
  0xB0, 0xA1, 0xC3, 0x87, 0x10, 0x23, 0x4A, 0x94, 0x06, 0x00, 0xC0, 0x44, 0x85, 0x00, 0xDE, 0x58, 0xBC, 0x78, 0x30, 0xA3, 0x46, 0x8E, 0x06, 0x3D, 0xBE, 0x61, 0xB5, 0x11, 0x24, 0xC5, 0x37, 0x28, 0x59, 0xA9, 0x2C, 0x79, 0x31, 0x63, 0xAE, 0x91,
  0x2A, 0x57, 0x72, 0x74, 0x09, 0x33, 0x26, 0xC9, 0x96, 0x6F, 0x5E, 0xDA, 0x24, 0x79, 0x73, 0x22, 0xCA, 0x91, 0xD7, 0xAE, 0x01, 0xE0, 0x59, 0xD1, 0x64, 0x20, 0x92, 0x42, 0x89, 0x9A, 0x94, 0x76, 0x14, 0x80, 0xD0, 0xA4, 0x81, 0xA2, 0x06, 0x62,
  0x09, 0xB1, 0xA2, 0xD5, 0x6B, 0x3B, 0x7B, 0x82, 0x0C, 0x84, 0x75, 0x27, 0x55, 0x89, 0x5C, 0xB3, 0x92, 0x2C, 0x3A, 0x31, 0xAC, 0x57, 0x94, 0x5F, 0x1D, 0x72, 0xED, 0xBA, 0xF2, 0x27, 0xC7, 0xA3, 0x41, 0xDB, 0xA2, 0x34, 0xCA, 0x2A, 0xA8, 0xC8,
  0xA5, 0x4C, 0x49, 0xE6, 0x7C, 0x83, 0x57, 0x20, 0xCD, 0xBE, 0x02, 0xF7, 0x02, 0x0E, 0xCC, 0x77, 0xB0, 0xE1, 0xC3, 0x88, 0x13, 0x73, 0x0C, 0x08, 0x00, 0x21, 0xFE, 0xEF, 0x54, 0x68, 0x69, 0x73, 0x20, 0x47, 0x49, 0x46, 0x20, 0x66, 0x69, 0x6C,
  0x65, 0x20, 0x77, 0x61, 0x73, 0x20, 0x61, 0x73, 0x73, 0x65, 0x6D, 0x62, 0x6C, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x47, 0x49, 0x46, 0x20, 0x43, 0x6F, 0x6E, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x53, 0x65,
  0x74, 0x20, 0x66, 0x72, 0x6F, 0x6D, 0x3A, 0x0D, 0x0A, 0x0D, 0x0A, 0x41, 0x6C, 0x63, 0x68, 0x65, 0x6D, 0x79, 0x20, 0x4D, 0x69, 0x6E, 0x64, 0x77, 0x6F, 0x72, 0x6B, 0x73, 0x20, 0x49, 0x6E, 0x63, 0x2E, 0x0D, 0x0A, 0x50, 0x2E, 0x4F, 0x2E, 0x20,
  0x42, 0x6F, 0x78, 0x20, 0x35, 0x30, 0x30, 0x0D, 0x0A, 0x42, 0x65, 0x65, 0x74, 0x6F, 0x6E, 0x2C, 0x20, 0x4F, 0x6E, 0x74, 0x61, 0x72, 0x69, 0x6F, 0x0D, 0x0A, 0x4C, 0x30, 0x47, 0x20, 0x31, 0x41, 0x30, 0x0D, 0x0A, 0x43, 0x41, 0x4E, 0x41, 0x44,
  0x41, 0x2E, 0x0D, 0x0A, 0x0D, 0x0A, 0x54, 0x68, 0x69, 0x73, 0x20, 0x63, 0x6F, 0x6D, 0x6D, 0x65, 0x6E, 0x74, 0x20, 0x62, 0x6C, 0x6F, 0x63, 0x6B, 0x20, 0x77, 0x69, 0x6C, 0x6C, 0x20, 0x6E, 0x6F, 0x74, 0x20, 0x61, 0x70, 0x70, 0x65, 0x61, 0x72,
  0x20, 0x69, 0x6E, 0x20, 0x66, 0x69, 0x6C, 0x65, 0x73, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x61, 0x20, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x65, 0x64, 0x20, 0x76, 0x65, 0x72, 0x73,
  0x69, 0x6F, 0x6E, 0x20, 0x6F, 0x66, 0x20, 0x47, 0x49, 0x46, 0x20, 0x43, 0x6F, 0x6E, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x53, 0x65, 0x74, 0x00, 0x21, 0xFF, 0x0B, 0x47, 0x49, 0x46, 0x43, 0x4F, 0x4E, 0x6E, 0x62, 0x31,
  0x2E, 0x30, 0x02, 0x0F, 0x00, 0x0E, 0x2F, 0x00, 0x02, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0x43, 0x3A, 0x5C, 0x57, 0x49, 0x4E, 0x44, 0x4F, 0x57, 0x53, 0x5C, 0x44, 0x65, 0x73, 0x6B, 0x74, 0x6F, 0x70, 0x5C,
  0x41, 0x6E, 0x69, 0x6D, 0x5C, 0x69, 0x6E, 0x73, 0x74, 0x61, 0x6C, 0x6C, 0x5C, 0x74, 0x69, 0x6D, 0x65, 0x5C, 0x4E, 0x65, 0x77, 0x2D, 0x35, 0x2E, 0x67, 0x69, 0x66, 0x00, 0x0E, 0x2F, 0x00, 0x02, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x2F, 0x43, 0x3A, 0x5C, 0x57, 0x49, 0x4E, 0x44, 0x4F, 0x57, 0x53, 0x5C, 0x44, 0x65, 0x73, 0x6B, 0x74, 0x6F, 0x70, 0x5C, 0x41, 0x6E, 0x69, 0x6D, 0x5C, 0x69, 0x6E, 0x73, 0x74, 0x61, 0x6C, 0x6C, 0x5C, 0x74, 0x69, 0x6D, 0x65,
  0x5C, 0x4E, 0x65, 0x77, 0x2D, 0x36, 0x2E, 0x67, 0x69, 0x66, 0x00, 0x0E, 0x2F, 0x00, 0x02, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0x43, 0x3A, 0x5C, 0x57, 0x49, 0x4E, 0x44, 0x4F, 0x57, 0x53, 0x5C, 0x44, 0x65,
  0x73, 0x6B, 0x74, 0x6F, 0x70, 0x5C, 0x41, 0x6E, 0x69, 0x6D, 0x5C, 0x69, 0x6E, 0x73, 0x74, 0x61, 0x6C, 0x6C, 0x5C, 0x74, 0x69, 0x6D, 0x65, 0x5C, 0x4E, 0x65, 0x77, 0x2D, 0x37, 0x2E, 0x67, 0x69, 0x66, 0x00, 0x0E, 0x2F, 0x00, 0x02, 0x00, 0x09,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0x43, 0x3A, 0x5C, 0x57, 0x49, 0x4E, 0x44, 0x4F, 0x57, 0x53, 0x5C, 0x44, 0x65, 0x73, 0x6B, 0x74, 0x6F, 0x70, 0x5C, 0x41, 0x6E, 0x69, 0x6D, 0x5C, 0x69, 0x6E, 0x73, 0x74, 0x61, 0x6C,
  0x6C, 0x5C, 0x74, 0x69, 0x6D, 0x65, 0x5C, 0x4E, 0x65, 0x77, 0x2D, 0x38, 0x2E, 0x67, 0x69, 0x66, 0x00, 0x0E, 0x2F, 0x00, 0x02, 0x00, 0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0x43, 0x3A, 0x5C, 0x57, 0x49, 0x4E, 0x44,
  0x4F, 0x57, 0x53, 0x5C, 0x44, 0x65, 0x73, 0x6B, 0x74, 0x6F, 0x70, 0x5C, 0x41, 0x6E, 0x69, 0x6D, 0x5C, 0x69, 0x6E, 0x73, 0x74, 0x61, 0x6C, 0x6C, 0x5C, 0x74, 0x69, 0x6D, 0x65, 0x5C, 0x4E, 0x65, 0x77, 0x2D, 0x39, 0x2E, 0x67, 0x69, 0x66, 0x00,
  0x0E, 0x30, 0x00, 0x02, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x43, 0x3A, 0x5C, 0x57, 0x49, 0x4E, 0x44, 0x4F, 0x57, 0x53, 0x5C, 0x44, 0x65, 0x73, 0x6B, 0x74, 0x6F, 0x70, 0x5C, 0x41, 0x6E, 0x69, 0x6D, 0x5C,
  0x69, 0x6E, 0x73, 0x74, 0x61, 0x6C, 0x6C, 0x5C, 0x74, 0x69, 0x6D, 0x65, 0x5C, 0x4E, 0x65, 0x77, 0x2D, 0x31, 0x30, 0x2E, 0x67, 0x69, 0x66, 0x00, 0x0E, 0x30, 0x00, 0x02, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30,
  0x43, 0x3A, 0x5C, 0x57, 0x49, 0x4E, 0x44, 0x4F, 0x57, 0x53, 0x5C, 0x44, 0x65, 0x73, 0x6B, 0x74, 0x6F, 0x70, 0x5C, 0x41, 0x6E, 0x69, 0x6D, 0x5C, 0x69, 0x6E, 0x73, 0x74, 0x61, 0x6C, 0x6C, 0x5C, 0x74, 0x69, 0x6D, 0x65, 0x5C, 0x4E, 0x65, 0x77,
  0x2D, 0x31, 0x31, 0x2E, 0x67, 0x69, 0x66, 0x00, 0x0E, 0x30, 0x00, 0x02, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x43, 0x3A, 0x5C, 0x57, 0x49, 0x4E, 0x44, 0x4F, 0x57, 0x53, 0x5C, 0x44, 0x65, 0x73, 0x6B, 0x74,
  0x6F, 0x70, 0x5C, 0x41, 0x6E, 0x69, 0x6D, 0x5C, 0x69, 0x6E, 0x73, 0x74, 0x61, 0x6C, 0x6C, 0x5C, 0x74, 0x69, 0x6D, 0x65, 0x5C, 0x4E, 0x65, 0x77, 0x2D, 0x31, 0x32, 0x2E, 0x67, 0x69, 0x66, 0x00, 0x0E, 0x30, 0x00, 0x02, 0x00, 0x13, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x43, 0x3A, 0x5C, 0x57, 0x49, 0x4E, 0x44, 0x4F, 0x57, 0x53, 0x5C, 0x44, 0x65, 0x73, 0x6B, 0x74, 0x6F, 0x70, 0x5C, 0x41, 0x6E, 0x69, 0x6D, 0x5C, 0x69, 0x6E, 0x73, 0x74, 0x61, 0x6C, 0x6C, 0x5C,
  0x74, 0x69, 0x6D, 0x65, 0x5C, 0x4E, 0x65, 0x77, 0x2D, 0x31, 0x33, 0x2E, 0x67, 0x69, 0x66, 0x00, 0x0E, 0x30, 0x00, 0x02, 0x00, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x43, 0x3A, 0x5C, 0x57, 0x49, 0x4E, 0x44, 0x4F,
  0x57, 0x53, 0x5C, 0x44, 0x65, 0x73, 0x6B, 0x74, 0x6F, 0x70, 0x5C, 0x41, 0x6E, 0x69, 0x6D, 0x5C, 0x69, 0x6E, 0x73, 0x74, 0x61, 0x6C, 0x6C, 0x5C, 0x74, 0x69, 0x6D, 0x65, 0x5C, 0x4E, 0x65, 0x77, 0x2D, 0x31, 0x34, 0x2E, 0x67, 0x69, 0x66, 0x00,
  0x0E, 0x30, 0x00, 0x02, 0x00, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x43, 0x3A, 0x5C, 0x57, 0x49, 0x4E, 0x44, 0x4F, 0x57, 0x53, 0x5C, 0x44, 0x65, 0x73, 0x6B, 0x74, 0x6F, 0x70, 0x5C, 0x41, 0x6E, 0x69, 0x6D, 0x5C,
  0x69, 0x6E, 0x73, 0x74, 0x61, 0x6C, 0x6C, 0x5C, 0x74, 0x69, 0x6D, 0x65, 0x5C, 0x4E, 0x65, 0x77, 0x2D, 0x31, 0x35, 0x2E, 0x67, 0x69, 0x66, 0x00, 0x0E, 0x30, 0x00, 0x02, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30,
  0x43, 0x3A, 0x5C, 0x57, 0x49, 0x4E, 0x44, 0x4F, 0x57, 0x53, 0x5C, 0x44, 0x65, 0x73, 0x6B, 0x74, 0x6F, 0x70, 0x5C, 0x41, 0x6E, 0x69, 0x6D, 0x5C, 0x69, 0x6E, 0x73, 0x74, 0x61, 0x6C, 0x6C, 0x5C, 0x74, 0x69, 0x6D, 0x65, 0x5C, 0x4E, 0x65, 0x77,
  0x2D, 0x31, 0x36, 0x2E, 0x67, 0x69, 0x66, 0x00, 0x0E, 0x30, 0x00, 0x02, 0x00, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x43, 0x3A, 0x5C, 0x57, 0x49, 0x4E, 0x44, 0x4F, 0x57, 0x53, 0x5C, 0x44, 0x65, 0x73, 0x6B, 0x74,
  0x6F, 0x70, 0x5C, 0x41, 0x6E, 0x69, 0x6D, 0x5C, 0x69, 0x6E, 0x73, 0x74, 0x61, 0x6C, 0x6C, 0x5C, 0x74, 0x69, 0x6D, 0x65, 0x5C, 0x4E, 0x65, 0x77, 0x2D, 0x31, 0x37, 0x2E, 0x67, 0x69, 0x66, 0x00, 0x0E, 0x30, 0x00, 0x02, 0x00, 0x1D, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x43, 0x3A, 0x5C, 0x57, 0x49, 0x4E, 0x44, 0x4F, 0x57, 0x53, 0x5C, 0x44, 0x65, 0x73, 0x6B, 0x74, 0x6F, 0x70, 0x5C, 0x41, 0x6E, 0x69, 0x6D, 0x5C, 0x69, 0x6E, 0x73, 0x74, 0x61, 0x6C, 0x6C, 0x5C,
  0x74, 0x69, 0x6D, 0x65, 0x5C, 0x4E, 0x65, 0x77, 0x2D, 0x31, 0x38, 0x2E, 0x67, 0x69, 0x66, 0x00, 0x0E, 0x30, 0x00, 0x02, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x43, 0x3A, 0x5C, 0x57, 0x49, 0x4E, 0x44, 0x4F,
  0x57, 0x53, 0x5C, 0x44, 0x65, 0x73, 0x6B, 0x74, 0x6F, 0x70, 0x5C, 0x41, 0x6E, 0x69, 0x6D, 0x5C, 0x69, 0x6E, 0x73, 0x74, 0x61, 0x6C, 0x6C, 0x5C, 0x74, 0x69, 0x6D, 0x65, 0x5C, 0x4E, 0x65, 0x77, 0x2D, 0x31, 0x39, 0x2E, 0x67, 0x69, 0x66, 0x00,
  0x00, 0x3B, 0x00
};

/*********************************************************************
*
*       Static code
*
**********************************************************************
*/
/*********************************************************************
*
*       _GetData
*/
static int _GetData(void * pVoid, const U8 ** ppData, unsigned NumBytesReq, U32 Off) {
  static U8 acBuffer[0x200];
  U8 * pImage;

  pImage = (U8 *)pVoid;
  //
  // Check buffer size
  //
  if (NumBytesReq > sizeof(acBuffer)) {
    NumBytesReq = sizeof(acBuffer);
  }
  //
  // Read data into buffer
  //
  memcpy(acBuffer, pImage + Off, NumBytesReq);
  //
  // Set data pointer to the beginning of the buffer
  //
  *ppData = acBuffer;
  //
  // Return number of available bytes
  //
  return NumBytesReq;
}

/*********************************************************************
*
*       _CreateAnimateStriteFromGIF
*/
static void _CreateAnimateStriteFromGIF(void) {
  GUI_MEMDEV_Handle hMem, hMemOld;
  GUI_GIF_INFO Info;
  GUI_GIF_IMAGE_INFO ImageInfo;
  char ** apImage;
  int BitmapSize;
  unsigned i;
  static GUI_COLOR aColor[256];
  void * pData;
  GUI_BITMAP * apBm;
  GUI_BITMAP ** ppBm;
  static GUI_LOGPALETTE Pal;
  unsigned * pDelay;
  
  //
  // Calculate palette entries
  //
  for (i = 0; i < GUI_COUNTOF(aColor); i++) {
    aColor[i] = LCD_API_ColorConv_8666.pfIndex2Color(i);
  }
  //
  // Initialize palette
  //
  Pal.pPalEntries = aColor;
  Pal.HasTrans    = 0;
  Pal.NumEntries  = 256;
  //
  // Get GIF information
  //
  GUI_GIF_GetInfoEx(_GetData, (void *)_acGIF, &Info);
  //
  // Allocate memory for pixel pointers
  //
  apImage = (char **)malloc(sizeof(char *) * Info.NumImages);
  BitmapSize = Info.xSize * Info.ySize;
  //
  // Allocate memory for bitmap structures
  //
  apBm = (GUI_BITMAP *)malloc(sizeof(GUI_BITMAP) * Info.NumImages);
  ppBm = (GUI_BITMAP **)malloc(sizeof(GUI_BITMAP *) * Info.NumImages);
  //
  // Allocate memory for delays
  //
  pDelay = (unsigned *)malloc(sizeof(unsigned) * Info.NumImages);
  //
  // Create and select temporary memory device
  //
  hMem = GUI_MEMDEV_CreateFixed(0, 0, Info.xSize, Info.ySize, GUI_MEMDEV_NOTRANS, GUI_MEMDEV_APILIST_8, GUICC_8666);
  hMemOld = GUI_MEMDEV_Select(hMem);
  for (i = 0; i < (unsigned)Info.NumImages; i++) {
    //
    // Draw sub image into memory device
    //
    GUI_GIF_DrawSubEx(_GetData, (void *)_acGIF, 0, 0, i);
    GUI_GIF_GetImageInfoEx(_GetData, (void *)_acGIF, &ImageInfo, i);
    *(pDelay + i) = ImageInfo.Delay * 10;
    //
    // Allocate memory for pixels
    //
    *(apImage + i) = (char *)malloc(BitmapSize);
    //
    // Copy data from memory device into pixel array
    //
    pData = GUI_MEMDEV_GetDataPtr(hMem);
    memcpy(*(apImage + i), pData, BitmapSize);
    //
    // Initialize bitmap structure
    //
    (apBm + i)->BitsPerPixel = 8;
    (apBm + i)->BytesPerLine = Info.xSize;
    (apBm + i)->pData        = (const U8 *)*(apImage + i);
    (apBm + i)->pMethods     = NULL;
    (apBm + i)->pPal         = &Pal;
    (apBm + i)->XSize        = Info.xSize;
    (apBm + i)->YSize        = Info.ySize;
    *(ppBm + i) = (apBm + i);
  }
  //
  // Deselect and free temporary memory device
  //
  GUI_MEMDEV_Select(hMemOld);
  GUI_MEMDEV_Delete(hMem);
  //
  // Create animated sprite
  //
  GUI_SPRITE_CreateAnim((const GUI_BITMAP **)ppBm, 0, 0, 0, pDelay, Info.NumImages);
}

/*********************************************************************
*
*       Public code
*
**********************************************************************
*/
/*********************************************************************
*
*       MainTask
*/
void MainTask(void) {
  GUI_Init();
  _CreateAnimateStriteFromGIF();
  while (1) {
    GUI_Delay(100);
  }
}

/*************************** End of file ****************************/
