/*********************************************************************
*                SEGGER Microcontroller GmbH                         *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2018  SEGGER Microcontroller GmbH                *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.48 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software  has been licensed to  Cypress Semiconductor Corporation,
whose registered  office is situated  at 198 Champion Ct. San Jose, CA 
95134 USA  solely for the  purposes of creating  libraries for Cypress
PSoC3 and  PSoC5 processor-based devices,  sublicensed and distributed
under  the  terms  and  conditions  of  the  Cypress  End User License
Agreement.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information
Licensor:                 SEGGER Microcontroller Systems LLC
Licensed to:              Cypress Semiconductor Corp, 198 Champion Ct., San Jose, CA 95134, USA
Licensed SEGGER software: emWin
License number:           GUI-00319
License model:            Services and License Agreement, signed June 10th, 2009
Licensed platform:        Any Cypress platform (Initial targets are: PSoC3, PSoC5)
----------------------------------------------------------------------
Support and Update Agreement (SUA)
SUA period:               2009-06-12 - 2022-07-27
Contact to extend SUA:    sales@segger.com
----------------------------------------------------------------------
File        : MTOUCH_ScratchAndGestures.c
Purpose     : Demonstrates how to use multi touch support and gestures
----------------------------------------------------------------------
*/

#include "DIALOG.h"

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/
//
// Commands to be used by menu
//
#define EXEC_SCRATCHPAD 0
#define EXEC_GESTURES   1

#define TIME_WAIT          3000 // Time after a demo ends if no input is detected
#define TIME_UP              20 // Dwell time for scratch pad to be allowed without input
#define TIME_CLEAN_SCRATCH 1000 // Time after scratch pad clears itself if no input is detected

//
// Button colors of main menu
//
#define BUTTON_COLOR0      GUI_LIGHTGRAY // Gradient color 0
#define BUTTON_COLOR1      GUI_DARKGRAY  // Gradient color 1
#define BUTTON_COLOR_FRAME GUI_WHITE     // Used for frame

#define REACT_ON_MOVE (WM_USER + 0) // Message send to gesture window if it should react on move events

//
// Min- and max values for factor used for gesture sample
//
#define FACTOR_MIN   100
#define FACTOR_MAX 20000

#define BUTTON_SIZE_CHECKBOX 20 // Size of check box button in main menu

//
// Recommended memory to run the sample with adequate performance
//
#define RECOMMENDED_MEMORY (1024L * 320)

/*********************************************************************
*
*       Types
*
**********************************************************************
*/
typedef struct {
  GUI_COLOR        Color;
  GUI_MTOUCH_INPUT Input;
} SCRATCH_DATA;

//
// 2-D Vector object used by drawing objects. Using vectors simplifies
// scaling and rotating in opposite of using x/y-coordinates.
//
typedef struct {
  int Dist; // Distance
  int Ang;  // Angle
} VECTOR;

typedef struct {
  const VECTOR * pVector;  // Pointer to an array of vectors
  int            NumItems; // Number of vector objects
  int            PenSize;  // Pen size to be used for drawing
  GUI_COLOR      Color;    // Color to be used for drawing
} DRAW_OBJ;

/*********************************************************************
*
*       Static data
*
**********************************************************************
*/
//
// Buffer of colors (and touch input) to be used by scratch pad demo
//
static SCRATCH_DATA _aData[] = {
  { GUI_GREEN     },
  { GUI_RED       },
  { GUI_CYAN      },
  { GUI_MAGENTA   },
  { GUI_YELLOW    },
  { GUI_WHITE     },
  { GUI_BLUE      },
  { GUI_LIGHTBLUE },
  { GUI_LIGHTGREEN},
  { GUI_LIGHTRED  },
  { 0             }
};

//
// Vector arrays to be used in gesture demo picture. Please note that these
// vectors are relative to the center of the object (Distance, Angle).
//
static const VECTOR _av0[] = {  {  71,  45 },  { 100, 270 },  { 100, 180 },  { 100,  90 },  { 100,   0 } };
static const VECTOR _av1[] = {  {  57, 225 },  {  85,  45 } };
static const VECTOR _av2[] = {  {  32,  72 },  {  32,  18 },  {  32, 252 }, {  29, 135 } };
static const VECTOR _av3[] = {  {  57, 135 },  {  42, 315 } };
static const VECTOR _av4[] = {  {  41, 166 },  {  42,  45 } };
static const VECTOR _av5[] = {  {  57, 315 },  {  42, 135 } };
static const VECTOR _av6[] = {  {  41, 344 },  {  42, 225 } };

//
// The following array defines the drawing to be modified in the gesture demo
//
static const DRAW_OBJ _aDraw[] = {
  { _av0, GUI_COUNTOF(_av0), 2, GUI_WHITE },
  { _av1, GUI_COUNTOF(_av1), 3, GUI_RED },
  { _av2, GUI_COUNTOF(_av2), 3, GUI_RED },
  { _av3, GUI_COUNTOF(_av3), 4, GUI_DARKGREEN },
  { _av4, GUI_COUNTOF(_av4), 4, GUI_DARKGREEN },
  { _av5, GUI_COUNTOF(_av5), 4, GUI_YELLOW },
  { _av6, GUI_COUNTOF(_av6), 4, GUI_YELLOW },
};

/*********************************************************************
*
*       GUI_Font32_AA4
*/
GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0020[  1] = { /* code 0020, SPACE */
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0021[ 38] = { /* code 0021, EXCLAMATION MARK */
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xDF, 0xE0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xDF, 0xD0,
  0xCF, 0xD0,
  0xBF, 0xB0,
  0xBF, 0xB0,
  0xBF, 0xB0,
  0xBF, 0xB0,
  0x9F, 0xB0,
  0x9F, 0x90,
  0x9F, 0x90,
  0x00, 0x00,
  0x00, 0x00,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0022[ 28] = { /* code 0022, QUOTATION MARK */
  0xFF, 0xF0, 0x0F, 0xFF,
  0xDF, 0xD0, 0x0D, 0xFD,
  0xCF, 0xC0, 0x0C, 0xFC,
  0xBF, 0xB0, 0x0B, 0xFB,
  0x9F, 0x90, 0x09, 0xF9,
  0x8F, 0x80, 0x08, 0xF8,
  0x7F, 0x70, 0x07, 0xF7
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0023[152] = { /* code 0023, NUMBER SIGN */
  0x00, 0x00, 0x00, 0x2F, 0xE0, 0x03, 0xFD, 0x00,
  0x00, 0x00, 0x00, 0x6F, 0xA0, 0x07, 0xF9, 0x00,
  0x00, 0x00, 0x00, 0xAF, 0x60, 0x0B, 0xF5, 0x00,
  0x00, 0x00, 0x00, 0xEF, 0x20, 0x0F, 0xF1, 0x00,
  0x00, 0x00, 0x03, 0xFE, 0x00, 0x4F, 0xC0, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x0F, 0xF1, 0x01, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x4F, 0xC0, 0x04, 0xFB, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0x80, 0x08, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0x40, 0x0C, 0xF4, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x10, 0x1F, 0xF0, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0x0C, 0xF4, 0x00, 0xEF, 0x30, 0x00, 0x00,
  0x00, 0x1F, 0xF0, 0x02, 0xFE, 0x00, 0x00, 0x00,
  0x00, 0x5F, 0xB0, 0x06, 0xFA, 0x00, 0x00, 0x00,
  0x00, 0x9F, 0x70, 0x0A, 0xF6, 0x00, 0x00, 0x00,
  0x00, 0xDF, 0x30, 0x0E, 0xF2, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0024[150] = { /* code 0024, DOLLAR SIGN */
  0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x4A, 0xEF, 0xFD, 0xB8, 0x50,
  0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x5F, 0xFB, 0x2F, 0x02, 0x59, 0xD0,
  0xCF, 0xF3, 0x0F, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x0F, 0x00, 0x00, 0x00,
  0xEF, 0xF1, 0x0F, 0x00, 0x00, 0x00,
  0xAF, 0xF8, 0x0F, 0x00, 0x00, 0x00,
  0x2E, 0xFF, 0xDF, 0x73, 0x00, 0x00,
  0x02, 0x9E, 0xFF, 0xFF, 0xE9, 0x20,
  0x00, 0x00, 0x2F, 0x9D, 0xFF, 0xE3,
  0x00, 0x00, 0x0F, 0x00, 0x7F, 0xFB,
  0x00, 0x00, 0x0F, 0x00, 0x1F, 0xFF,
  0x00, 0x00, 0x0F, 0x00, 0x0F, 0xFF,
  0xB2, 0x00, 0x0F, 0x00, 0x4F, 0xFB,
  0xFF, 0x94, 0x1F, 0x26, 0xEF, 0xE3,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x30,
  0x16, 0xAD, 0xFF, 0xDA, 0x50, 0x00,
  0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0025[228] = { /* code 0025, PERCENT SIGN */
  0x01, 0x9E, 0xFE, 0x92, 0x00, 0x00, 0x00, 0x07, 0xFB, 0x00, 0x00, 0x00,
  0x1D, 0xFF, 0xFF, 0xFD, 0x10, 0x00, 0x00, 0x1E, 0xF2, 0x00, 0x00, 0x00,
  0x7F, 0xC2, 0x02, 0xCF, 0x80, 0x00, 0x00, 0x9F, 0x90, 0x00, 0x00, 0x00,
  0xCF, 0x40, 0x00, 0x4F, 0xC0, 0x00, 0x03, 0xFE, 0x10, 0x00, 0x00, 0x00,
  0xFF, 0x10, 0x00, 0x1F, 0xF0, 0x00, 0x0B, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x4F, 0xD0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x10, 0x00, 0x1F, 0xF0, 0x00, 0xDF, 0x40, 0x00, 0x00, 0x00, 0x00,
  0xCF, 0x40, 0x00, 0x4F, 0xC0, 0x07, 0xFB, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x8F, 0xC2, 0x02, 0xCF, 0x80, 0x1E, 0xF3, 0x01, 0x9E, 0xFE, 0x92, 0x00,
  0x1D, 0xFF, 0xFF, 0xFD, 0x10, 0x9F, 0x90, 0x1D, 0xFF, 0xFF, 0xFD, 0x10,
  0x01, 0x9E, 0xFE, 0x91, 0x03, 0xFE, 0x10, 0x7F, 0xC2, 0x02, 0xCF, 0x80,
  0x00, 0x00, 0x00, 0x00, 0x0B, 0xF7, 0x00, 0xCF, 0x40, 0x00, 0x4F, 0xC0,
  0x00, 0x00, 0x00, 0x00, 0x4F, 0xD0, 0x00, 0xFF, 0x10, 0x00, 0x1F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0xDF, 0x40, 0x00, 0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x06, 0xFB, 0x00, 0x00, 0xFF, 0x10, 0x00, 0x1F, 0xF0,
  0x00, 0x00, 0x00, 0x1E, 0xF3, 0x00, 0x00, 0xCF, 0x40, 0x00, 0x4F, 0xC0,
  0x00, 0x00, 0x00, 0x9F, 0x90, 0x00, 0x00, 0x8F, 0xC2, 0x02, 0xCF, 0x80,
  0x00, 0x00, 0x02, 0xFE, 0x10, 0x00, 0x00, 0x1D, 0xFF, 0xFF, 0xFD, 0x10,
  0x00, 0x00, 0x0B, 0xF7, 0x00, 0x00, 0x00, 0x01, 0x9E, 0xFE, 0x91, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0026[171] = { /* code 0026, AMPERSAND */
  0x00, 0x07, 0xCF, 0xFD, 0x81, 0x00, 0x00, 0x00, 0x00,
  0x01, 0xBF, 0xFF, 0xFF, 0xFE, 0x20, 0x00, 0x00, 0x00,
  0x08, 0xFF, 0xB1, 0x1B, 0xFF, 0xB0, 0x00, 0x00, 0x00,
  0x0E, 0xFF, 0x20, 0x02, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  0x0F, 0xFF, 0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, 0x00,
  0x0D, 0xFF, 0x30, 0x02, 0xFF, 0xB0, 0x00, 0x00, 0x00,
  0x07, 0xFF, 0xD2, 0x07, 0xFF, 0x40, 0x00, 0x00, 0x00,
  0x00, 0x9F, 0xFE, 0x8F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0B, 0xFF, 0xFE, 0x20, 0x00, 0xFF, 0xF0, 0x00,
  0x01, 0xCF, 0x9D, 0xFF, 0xA0, 0x00, 0xFF, 0xF0, 0x00,
  0x1D, 0xFB, 0x01, 0xDF, 0xF9, 0x00, 0xFF, 0xD0, 0x00,
  0x8F, 0xF4, 0x00, 0x1D, 0xFF, 0x80, 0xFF, 0xA0, 0x00,
  0xDF, 0xF1, 0x00, 0x01, 0xDF, 0xF8, 0xEF, 0x60, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x1D, 0xFF, 0xFE, 0x10, 0x00,
  0xEF, 0xF2, 0x00, 0x00, 0x01, 0xDF, 0xFB, 0x00, 0x00,
  0xAF, 0xF9, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x80, 0x00,
  0x3F, 0xFF, 0xA3, 0x00, 0x3A, 0xFB, 0xBF, 0xF8, 0x00,
  0x05, 0xEF, 0xFF, 0xFF, 0xFF, 0xA1, 0x1B, 0xFF, 0x80,
  0x00, 0x28, 0xDF, 0xFD, 0xA4, 0x00, 0x01, 0xBF, 0xF8
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0027[ 14] = { /* code 0027, APOSTROPHE */
  0xFF, 0xF0,
  0xDF, 0xD0,
  0xCF, 0xC0,
  0xBF, 0xB0,
  0x9F, 0x90,
  0x8F, 0x80,
  0x7F, 0x70
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0028[100] = { /* code 0028, LEFT PARENTHESIS */
  0x00, 0x00, 0x7F, 0xFA,
  0x00, 0x04, 0xFF, 0xB0,
  0x00, 0x1E, 0xFE, 0x20,
  0x00, 0x9F, 0xF6, 0x00,
  0x03, 0xFF, 0xD0, 0x00,
  0x09, 0xFF, 0x60, 0x00,
  0x1F, 0xFF, 0x10, 0x00,
  0x5F, 0xFB, 0x00, 0x00,
  0x9F, 0xF7, 0x00, 0x00,
  0xCF, 0xF4, 0x00, 0x00,
  0xDF, 0xF2, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xDF, 0xF2, 0x00, 0x00,
  0xCF, 0xF3, 0x00, 0x00,
  0x9F, 0xF7, 0x00, 0x00,
  0x6F, 0xFB, 0x00, 0x00,
  0x1F, 0xFF, 0x10, 0x00,
  0x0A, 0xFF, 0x60, 0x00,
  0x03, 0xFF, 0xD0, 0x00,
  0x00, 0x9F, 0xF6, 0x00,
  0x00, 0x1D, 0xFE, 0x20,
  0x00, 0x04, 0xFF, 0xB0,
  0x00, 0x00, 0x7F, 0xFA
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0029[100] = { /* code 0029, RIGHT PARENTHESIS */
  0xAF, 0xF7, 0x00, 0x00,
  0x0B, 0xFF, 0x40, 0x00,
  0x02, 0xEF, 0xD1, 0x00,
  0x00, 0x6F, 0xF9, 0x00,
  0x00, 0x0D, 0xFF, 0x30,
  0x00, 0x06, 0xFF, 0x90,
  0x00, 0x01, 0xFF, 0xF1,
  0x00, 0x00, 0xBF, 0xF6,
  0x00, 0x00, 0x7F, 0xF9,
  0x00, 0x00, 0x4F, 0xFC,
  0x00, 0x00, 0x2F, 0xFD,
  0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x00, 0x2F, 0xFD,
  0x00, 0x00, 0x4F, 0xFC,
  0x00, 0x00, 0x7F, 0xF9,
  0x00, 0x00, 0xBF, 0xF5,
  0x00, 0x01, 0xFF, 0xF1,
  0x00, 0x06, 0xFF, 0xA0,
  0x00, 0x0D, 0xFF, 0x30,
  0x00, 0x6F, 0xF9, 0x00,
  0x02, 0xEF, 0xE1, 0x00,
  0x0B, 0xFF, 0x40, 0x00,
  0xAF, 0xF7, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_002A[ 72] = { /* code 002A, ASTERISK */
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x79, 0x10, 0x0F, 0xE0, 0x01, 0x87,
  0x9F, 0xD4, 0x0D, 0xD0, 0x4D, 0xFA,
  0x04, 0xCF, 0xAE, 0xEA, 0xFC, 0x40,
  0x00, 0x06, 0xEF, 0xFD, 0x60, 0x00,
  0x00, 0x06, 0xEF, 0xFE, 0x60, 0x00,
  0x04, 0xCF, 0xAE, 0xEA, 0xFC, 0x40,
  0x9F, 0xD4, 0x0D, 0xD0, 0x5D, 0xF9,
  0x79, 0x10, 0x0F, 0xF0, 0x01, 0x97,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_002B[ 98] = { /* code 002B, PLUS SIGN */
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_002C[ 24] = { /* code 002C, COMMA */
  0x01, 0xFF, 0xC0,
  0x05, 0xFF, 0x60,
  0x09, 0xFE, 0x00,
  0x0D, 0xF8, 0x00,
  0x1F, 0xF2, 0x00,
  0x5F, 0xB0, 0x00,
  0x9F, 0x50, 0x00,
  0xDE, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_002D[  8] = { /* code 002D, HYPHEN-MINUS */
  0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_002E[  8] = { /* code 002E, FULL STOP */
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_002F[120] = { /* code 002F, SOLIDUS */
  0x00, 0x00, 0x00, 0x03, 0xFD,
  0x00, 0x00, 0x00, 0x08, 0xF8,
  0x00, 0x00, 0x00, 0x0D, 0xF3,
  0x00, 0x00, 0x00, 0x3F, 0xD0,
  0x00, 0x00, 0x00, 0x8F, 0x80,
  0x00, 0x00, 0x00, 0xDF, 0x30,
  0x00, 0x00, 0x03, 0xFD, 0x00,
  0x00, 0x00, 0x08, 0xF8, 0x00,
  0x00, 0x00, 0x0D, 0xF3, 0x00,
  0x00, 0x00, 0x3F, 0xD0, 0x00,
  0x00, 0x00, 0x8F, 0x80, 0x00,
  0x00, 0x00, 0xDF, 0x30, 0x00,
  0x00, 0x03, 0xFD, 0x00, 0x00,
  0x00, 0x08, 0xF8, 0x00, 0x00,
  0x00, 0x0D, 0xF3, 0x00, 0x00,
  0x00, 0x3F, 0xD0, 0x00, 0x00,
  0x00, 0x8F, 0x80, 0x00, 0x00,
  0x00, 0xDF, 0x30, 0x00, 0x00,
  0x03, 0xFD, 0x00, 0x00, 0x00,
  0x08, 0xF8, 0x00, 0x00, 0x00,
  0x0D, 0xF3, 0x00, 0x00, 0x00,
  0x3F, 0xD0, 0x00, 0x00, 0x00,
  0x8F, 0x80, 0x00, 0x00, 0x00,
  0xDF, 0x30, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0030[114] = { /* code 0030, DIGIT ZERO */
  0x00, 0x17, 0xCF, 0xFC, 0x70, 0x00,
  0x01, 0xCF, 0xFF, 0xFF, 0xFC, 0x10,
  0x0A, 0xFF, 0x81, 0x18, 0xFF, 0x90,
  0x2F, 0xFB, 0x00, 0x00, 0xBF, 0xF2,
  0x7F, 0xF6, 0x00, 0x00, 0x6F, 0xF6,
  0xAF, 0xF3, 0x00, 0x00, 0x3F, 0xFA,
  0xCF, 0xF2, 0x00, 0x00, 0x2F, 0xFC,
  0xEF, 0xF0, 0x00, 0x00, 0x0F, 0xFE,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xEF, 0xF0, 0x00, 0x00, 0x0F, 0xFE,
  0xCF, 0xF2, 0x00, 0x00, 0x2F, 0xFC,
  0xAF, 0xF3, 0x00, 0x00, 0x3F, 0xFA,
  0x7F, 0xF6, 0x00, 0x00, 0x6F, 0xF7,
  0x2F, 0xFB, 0x00, 0x00, 0xBF, 0xF2,
  0x09, 0xFF, 0x81, 0x18, 0xFF, 0xA0,
  0x01, 0xCF, 0xFF, 0xFF, 0xFC, 0x10,
  0x00, 0x17, 0xCF, 0xFC, 0x71, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0031[ 95] = { /* code 0031, DIGIT ONE */
  0x00, 0x07, 0xFF, 0x00, 0x00,
  0x00, 0x0B, 0xFF, 0x00, 0x00,
  0x03, 0x8F, 0xFF, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0032[114] = { /* code 0032, DIGIT TWO */
  0x16, 0xAD, 0xFF, 0xEA, 0x40, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0xFE, 0x83, 0x01, 0x6E, 0xFF, 0x50,
  0xB1, 0x00, 0x00, 0x06, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x01, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x03, 0xFF, 0xD0,
  0x00, 0x00, 0x00, 0x07, 0xFF, 0xA0,
  0x00, 0x00, 0x00, 0x1E, 0xFF, 0x30,
  0x00, 0x00, 0x00, 0xAF, 0xFA, 0x00,
  0x00, 0x00, 0x06, 0xFF, 0xD1, 0x00,
  0x00, 0x00, 0x4F, 0xFE, 0x20, 0x00,
  0x00, 0x02, 0xEF, 0xE2, 0x00, 0x00,
  0x00, 0x2E, 0xFE, 0x20, 0x00, 0x00,
  0x01, 0xDF, 0xE2, 0x00, 0x00, 0x00,
  0x1D, 0xFD, 0x20, 0x00, 0x00, 0x00,
  0xDF, 0xD1, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0033[114] = { /* code 0033, DIGIT THREE */
  0x01, 0x7B, 0xEF, 0xFC, 0x70, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFC, 0x10,
  0x0F, 0xD6, 0x10, 0x4D, 0xFF, 0x90,
  0x0A, 0x00, 0x00, 0x04, 0xFF, 0xE0,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x01, 0xFF, 0xD0,
  0x00, 0x00, 0x00, 0x06, 0xFF, 0x60,
  0x00, 0x00, 0x01, 0x7F, 0xF9, 0x00,
  0x00, 0x00, 0xFF, 0xFC, 0x40, 0x00,
  0x00, 0x00, 0xFF, 0xFF, 0xC3, 0x00,
  0x00, 0x00, 0x00, 0x4E, 0xFE, 0x30,
  0x00, 0x00, 0x00, 0x04, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xE0,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x02, 0xFF, 0xD0,
  0xB1, 0x00, 0x00, 0x09, 0xFF, 0x90,
  0xFE, 0x72, 0x02, 0x8F, 0xFE, 0x20,
  0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0x00,
  0x16, 0xBD, 0xFF, 0xD8, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0034[133] = { /* code 0034, DIGIT FOUR */
  0x00, 0x00, 0x00, 0x05, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x3E, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x02, 0xED, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x1D, 0xE2, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0xBF, 0x40, 0xFF, 0xF0, 0x00,
  0x00, 0x0A, 0xF6, 0x00, 0xFF, 0xF0, 0x00,
  0x00, 0x7F, 0x80, 0x00, 0xFF, 0xF0, 0x00,
  0x05, 0xFA, 0x00, 0x00, 0xFF, 0xF0, 0x00,
  0x4F, 0xB0, 0x00, 0x00, 0xFF, 0xF0, 0x00,
  0xED, 0x10, 0x00, 0x00, 0xFF, 0xF0, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0035[114] = { /* code 0035, DIGIT FIVE */
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xFF, 0xFF, 0xFC, 0x60, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFA, 0x00,
  0x00, 0x00, 0x02, 0x7F, 0xFF, 0x50,
  0x00, 0x00, 0x00, 0x07, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x02, 0xFF, 0xE0,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xE0,
  0x00, 0x00, 0x00, 0x03, 0xFF, 0xC0,
  0xB1, 0x00, 0x00, 0x0B, 0xFF, 0x70,
  0xFE, 0x82, 0x02, 0x9F, 0xFD, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xD2, 0x00,
  0x27, 0xBE, 0xFF, 0xC7, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0036[114] = { /* code 0036, DIGIT SIX */
  0x00, 0x00, 0x4A, 0xDF, 0xFC, 0x00,
  0x00, 0x09, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0xAF, 0xFB, 0x30, 0x29, 0x00,
  0x06, 0xFF, 0x90, 0x00, 0x00, 0x00,
  0x0E, 0xFE, 0x10, 0x00, 0x00, 0x00,
  0x4F, 0xF8, 0x00, 0x00, 0x00, 0x00,
  0x8F, 0xF5, 0x00, 0x00, 0x00, 0x00,
  0xCF, 0xF3, 0x8D, 0xFF, 0xB5, 0x00,
  0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0xFF, 0xFB, 0x30, 0x15, 0xEF, 0xF4,
  0xFF, 0xF0, 0x00, 0x00, 0x7F, 0xFB,
  0xFF, 0xF0, 0x00, 0x00, 0x2F, 0xFE,
  0xDF, 0xF1, 0x00, 0x00, 0x0F, 0xFF,
  0xBF, 0xF3, 0x00, 0x00, 0x0F, 0xFF,
  0x8F, 0xF7, 0x00, 0x00, 0x3F, 0xFC,
  0x2F, 0xFC, 0x00, 0x00, 0x8F, 0xF7,
  0x09, 0xFF, 0xA1, 0x06, 0xFF, 0xD0,
  0x01, 0xBF, 0xFF, 0xFF, 0xFD, 0x20,
  0x00, 0x07, 0xCF, 0xFC, 0x71, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0037[114] = { /* code 0037, DIGIT SEVEN */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x0E, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x7F, 0xF8,
  0x00, 0x00, 0x00, 0x00, 0xEF, 0xF1,
  0x00, 0x00, 0x00, 0x07, 0xFF, 0x90,
  0x00, 0x00, 0x00, 0x0D, 0xFF, 0x20,
  0x00, 0x00, 0x00, 0x6F, 0xF9, 0x00,
  0x00, 0x00, 0x00, 0xDF, 0xF2, 0x00,
  0x00, 0x00, 0x06, 0xFF, 0x90, 0x00,
  0x00, 0x00, 0x0D, 0xFF, 0x30, 0x00,
  0x00, 0x00, 0x5F, 0xFA, 0x00, 0x00,
  0x00, 0x00, 0xCF, 0xF3, 0x00, 0x00,
  0x00, 0x05, 0xFF, 0xA0, 0x00, 0x00,
  0x00, 0x0C, 0xFF, 0x30, 0x00, 0x00,
  0x00, 0x5F, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0xCF, 0xF4, 0x00, 0x00, 0x00,
  0x04, 0xFF, 0xB0, 0x00, 0x00, 0x00,
  0x0B, 0xFF, 0x40, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0038[114] = { /* code 0038, DIGIT EIGHT */
  0x00, 0x39, 0xDF, 0xFD, 0xA4, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x5F, 0xFE, 0x50, 0x05, 0xEF, 0xF6,
  0xCF, 0xF4, 0x00, 0x00, 0x5F, 0xFD,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xEF, 0xF2, 0x00, 0x00, 0x1F, 0xFD,
  0xAF, 0xFB, 0x10, 0x00, 0x4F, 0xF7,
  0x2E, 0xFF, 0xE7, 0x11, 0xCF, 0xB0,
  0x01, 0xBF, 0xFF, 0xED, 0xF8, 0x00,
  0x03, 0xEF, 0xAF, 0xFF, 0xF9, 0x10,
  0x2E, 0xF8, 0x01, 0x7E, 0xFF, 0xD1,
  0x9F, 0xF3, 0x00, 0x01, 0xCF, 0xF9,
  0xDF, 0xF0, 0x00, 0x00, 0x3F, 0xFE,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xEF, 0xF2, 0x00, 0x00, 0x1F, 0xFE,
  0xAF, 0xF9, 0x00, 0x00, 0x6F, 0xFA,
  0x3F, 0xFF, 0x71, 0x05, 0xEF, 0xE2,
  0x05, 0xFF, 0xFF, 0xFF, 0xFE, 0x30,
  0x00, 0x29, 0xDF, 0xFC, 0x81, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0039[114] = { /* code 0039, DIGIT NINE */
  0x00, 0x17, 0xCF, 0xFC, 0x70, 0x00,
  0x02, 0xDF, 0xFF, 0xFF, 0xFB, 0x10,
  0x0D, 0xFF, 0x60, 0x19, 0xFF, 0x90,
  0x7F, 0xF8, 0x00, 0x00, 0xCF, 0xF3,
  0xCF, 0xF3, 0x00, 0x00, 0x6F, 0xF8,
  0xFF, 0xF0, 0x00, 0x00, 0x3F, 0xFB,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFE,
  0xEF, 0xF2, 0x00, 0x00, 0x0F, 0xFF,
  0xBF, 0xF7, 0x00, 0x00, 0x0F, 0xFF,
  0x4F, 0xFE, 0x51, 0x04, 0xBF, 0xFF,
  0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD,
  0x00, 0x5B, 0xFF, 0xD8, 0x3F, 0xFB,
  0x00, 0x00, 0x00, 0x00, 0x4F, 0xF8,
  0x00, 0x00, 0x00, 0x00, 0x8F, 0xF4,
  0x00, 0x00, 0x00, 0x00, 0xEF, 0xE0,
  0x00, 0x00, 0x00, 0x09, 0xFF, 0x60,
  0x00, 0xA2, 0x03, 0xAF, 0xFB, 0x00,
  0x00, 0xFF, 0xFF, 0xFF, 0xA1, 0x00,
  0x00, 0xCF, 0xFD, 0xA4, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_003A[ 28] = { /* code 003A, COLON */
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_003B[ 54] = { /* code 003B, SEMICOLON */
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x01, 0xFF, 0xC0,
  0x05, 0xFF, 0x60,
  0x09, 0xFE, 0x00,
  0x0D, 0xF8, 0x00,
  0x1F, 0xF2, 0x00,
  0x5F, 0xB0, 0x00,
  0x9F, 0x50, 0x00,
  0xDE, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_003C[105] = { /* code 003C, LESS-THAN SIGN */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4B,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x5C, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x5C, 0xFF, 0xD7,
  0x00, 0x00, 0x00, 0x6D, 0xFF, 0xD6, 0x00,
  0x00, 0x00, 0x6D, 0xFF, 0xC6, 0x00, 0x00,
  0x00, 0x7E, 0xFF, 0xC5, 0x00, 0x00, 0x00,
  0x7E, 0xFF, 0xB5, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF7, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7E, 0xFF, 0xB5, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x7E, 0xFF, 0xC5, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x6D, 0xFF, 0xC6, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x6D, 0xFF, 0xD6, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x5C, 0xFF, 0xD7,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x5C, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4B
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_003D[ 49] = { /* code 003D, EQUALS SIGN */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_003E[105] = { /* code 003E, GREATER-THAN SIGN */
  0xB4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xC5, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7D, 0xFF, 0xC5, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x6D, 0xFF, 0xD6, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x6C, 0xFF, 0xD6, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x5C, 0xFF, 0xE7, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x5B, 0xFF, 0xE7,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x5B, 0xFF, 0xE7,
  0x00, 0x00, 0x00, 0x5C, 0xFF, 0xE7, 0x00,
  0x00, 0x00, 0x6C, 0xFF, 0xD6, 0x00, 0x00,
  0x00, 0x6D, 0xFF, 0xD6, 0x00, 0x00, 0x00,
  0x7D, 0xFF, 0xC5, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xC5, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xB4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_003F[ 95] = { /* code 003F, QUESTION MARK */
  0x6A, 0xCF, 0xFE, 0xB6, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xA0,
  0xC7, 0x30, 0x04, 0xEF, 0xF7,
  0x00, 0x00, 0x00, 0x4F, 0xFD,
  0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x00, 0x00, 0x00, 0x1F, 0xFE,
  0x00, 0x00, 0x00, 0x4F, 0xFB,
  0x00, 0x00, 0x01, 0xCF, 0xF4,
  0x00, 0x00, 0x1B, 0xFF, 0x80,
  0x00, 0x03, 0xDF, 0xF7, 0x00,
  0x00, 0x0F, 0xFC, 0x30, 0x00,
  0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x0F, 0xF0, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0040[220] = { /* code 0040, COMMERCIAL AT */
  0x00, 0x00, 0x00, 0x49, 0xDF, 0xFE, 0xC8, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x3C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x10, 0x00,
  0x00, 0x05, 0xFF, 0xD7, 0x30, 0x01, 0x49, 0xFF, 0xD1, 0x00,
  0x00, 0x5F, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x2C, 0xFC, 0x00,
  0x02, 0xEF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x01, 0xCF, 0x70,
  0x0A, 0xFA, 0x00, 0x06, 0xDF, 0xEA, 0xFF, 0x00, 0x3F, 0xE1,
  0x3F, 0xE1, 0x00, 0x8F, 0xFF, 0xFF, 0xFF, 0x00, 0x0B, 0xF6,
  0x8F, 0x90, 0x04, 0xFF, 0x50, 0x16, 0xFF, 0x00, 0x06, 0xFA,
  0xBF, 0x40, 0x0A, 0xF7, 0x00, 0x00, 0xFF, 0x00, 0x02, 0xFD,
  0xEF, 0x10, 0x0D, 0xF2, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00, 0x01, 0xFF,
  0xEF, 0x10, 0x0E, 0xF1, 0x00, 0x00, 0xFF, 0x00, 0x03, 0xFD,
  0xCF, 0x40, 0x0B, 0xF5, 0x00, 0x00, 0xFF, 0x00, 0x05, 0xFA,
  0x8F, 0x80, 0x06, 0xFD, 0x30, 0x4C, 0xFF, 0x00, 0x0A, 0xF5,
  0x4F, 0xD0, 0x00, 0xDF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xD0,
  0x0D, 0xF7, 0x00, 0x1A, 0xFF, 0xA1, 0xCF, 0xFF, 0xFF, 0x50,
  0x04, 0xFF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x8F, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x09, 0xFF, 0xB5, 0x20, 0x02, 0x6B, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x6E, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x7B, 0xEF, 0xFE, 0xC8, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0041[152] = { /* code 0041, LATIN CAPITAL LETTER A */
  0x00, 0x00, 0x00, 0xBF, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0xFF, 0xFF, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x06, 0xFF, 0xFF, 0x60, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0xFF, 0xFF, 0xB0, 0x00, 0x00,
  0x00, 0x00, 0x2F, 0xFE, 0xDF, 0xF2, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF9, 0x8F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0xF4, 0x3F, 0xFB, 0x00, 0x00,
  0x00, 0x02, 0xFF, 0xE0, 0x0D, 0xFF, 0x20, 0x00,
  0x00, 0x07, 0xFF, 0x90, 0x09, 0xFF, 0x70, 0x00,
  0x00, 0x0B, 0xFF, 0x40, 0x04, 0xFF, 0xB0, 0x00,
  0x00, 0x2F, 0xFE, 0x00, 0x00, 0xEF, 0xF2, 0x00,
  0x00, 0x7F, 0xF9, 0x00, 0x00, 0x9F, 0xF7, 0x00,
  0x00, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x02, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x20,
  0x07, 0xFF, 0xA0, 0x00, 0x00, 0x0A, 0xFF, 0x70,
  0x0C, 0xFF, 0x50, 0x00, 0x00, 0x05, 0xFF, 0xC0,
  0x2F, 0xFE, 0x00, 0x00, 0x00, 0x00, 0xEF, 0xF2,
  0x7F, 0xFA, 0x00, 0x00, 0x00, 0x00, 0xAF, 0xF7,
  0xCF, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xFC
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0042[114] = { /* code 0042, LATIN CAPITAL LETTER B */
  0xFF, 0xFF, 0xFF, 0xFC, 0x81, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x20,
  0xFF, 0xF0, 0x00, 0x2B, 0xFF, 0xA0,
  0xFF, 0xF0, 0x00, 0x02, 0xFF, 0xE0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xE0,
  0xFF, 0xF0, 0x00, 0x04, 0xFF, 0x90,
  0xFF, 0xF0, 0x00, 0x3D, 0xFE, 0x20,
  0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x60,
  0xFF, 0xF0, 0x00, 0x15, 0xEF, 0xF4,
  0xFF, 0xF0, 0x00, 0x00, 0x5F, 0xFB,
  0xFF, 0xF0, 0x00, 0x00, 0x1F, 0xFE,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x1F, 0xFD,
  0xFF, 0xF0, 0x00, 0x00, 0x7F, 0xF9,
  0xFF, 0xF0, 0x00, 0x28, 0xFF, 0xE2,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x30,
  0xFF, 0xFF, 0xFF, 0xEC, 0x71, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0043[133] = { /* code 0043, LATIN CAPITAL LETTER C */
  0x00, 0x00, 0x28, 0xCF, 0xFE, 0xB7, 0x10,
  0x00, 0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0x00, 0xAF, 0xFE, 0x72, 0x01, 0x6D, 0xFF,
  0x07, 0xFF, 0xD1, 0x00, 0x00, 0x00, 0x9F,
  0x1E, 0xFF, 0x30, 0x00, 0x00, 0x00, 0x09,
  0x6F, 0xFB, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xAF, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xF2, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xF2, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xAF, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x6F, 0xFB, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1F, 0xFF, 0x30, 0x00, 0x00, 0x00, 0x09,
  0x07, 0xFF, 0xD1, 0x00, 0x00, 0x00, 0x9F,
  0x00, 0xBF, 0xFE, 0x62, 0x01, 0x6D, 0xFF,
  0x00, 0x19, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7,
  0x00, 0x00, 0x39, 0xCF, 0xFE, 0xB6, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0044[152] = { /* code 0044, LATIN CAPITAL LETTER D */
  0xFF, 0xFF, 0xFF, 0xEC, 0x94, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD4, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x25, 0xAF, 0xFF, 0x60, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x04, 0xEF, 0xF4, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x4F, 0xFD, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0B, 0xFF, 0x50,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x06, 0xFF, 0xA0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x02, 0xFF, 0xD0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x02, 0xFF, 0xC0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x05, 0xFF, 0x90,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0B, 0xFF, 0x40,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x4F, 0xFC, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x04, 0xEF, 0xF3, 0x00,
  0xFF, 0xF0, 0x00, 0x24, 0xAF, 0xFF, 0x50, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC3, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xEC, 0x94, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0045[114] = { /* code 0045, LATIN CAPITAL LETTER E */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0046[114] = { /* code 0046, LATIN CAPITAL LETTER F */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0047[152] = { /* code 0047, LATIN CAPITAL LETTER G */
  0x00, 0x00, 0x17, 0xBE, 0xFF, 0xDA, 0x61, 0x00,
  0x00, 0x06, 0xEF, 0xFF, 0xFF, 0xFF, 0xFE, 0x70,
  0x00, 0x8F, 0xFE, 0x72, 0x00, 0x38, 0xEF, 0xF0,
  0x05, 0xFF, 0xE2, 0x00, 0x00, 0x00, 0x2B, 0xF0,
  0x0E, 0xFF, 0x40, 0x00, 0x00, 0x00, 0x00, 0xA0,
  0x5F, 0xFB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xAF, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xF2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xF0,
  0xDF, 0xF2, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xAF, 0xF5, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x6F, 0xFA, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x1E, 0xFF, 0x30, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x07, 0xFF, 0xD1, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0xAF, 0xFE, 0x62, 0x00, 0x37, 0xFF, 0xF0,
  0x00, 0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x90,
  0x00, 0x00, 0x27, 0xBE, 0xFF, 0xDA, 0x51, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0048[133] = { /* code 0048, LATIN CAPITAL LETTER H */
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0049[ 76] = { /* code 0049, LATIN CAPITAL LETTER I */
  0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_004A[ 95] = { /* code 004A, LATIN CAPITAL LETTER J */
  0x00, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x01, 0xFF, 0xF0,
  0x00, 0x00, 0x04, 0xFF, 0xC0,
  0xC4, 0x00, 0x4D, 0xFF, 0x60,
  0xFF, 0xFF, 0xFF, 0xF9, 0x00,
  0xBD, 0xFF, 0xEB, 0x50, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_004B[133] = { /* code 004B, LATIN CAPITAL LETTER K */
  0xFF, 0xF0, 0x00, 0x00, 0x6F, 0xFF, 0x90,
  0xFF, 0xF0, 0x00, 0x03, 0xFF, 0xFB, 0x00,
  0xFF, 0xF0, 0x00, 0x1E, 0xFF, 0xC1, 0x00,
  0xFF, 0xF0, 0x00, 0xCF, 0xFE, 0x20, 0x00,
  0xFF, 0xF0, 0x09, 0xFF, 0xE3, 0x00, 0x00,
  0xFF, 0xF0, 0x6F, 0xFF, 0x50, 0x00, 0x00,
  0xFF, 0xF4, 0xFF, 0xF7, 0x00, 0x00, 0x00,
  0xFF, 0xFE, 0xFF, 0x90, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00,
  0xFF, 0xFD, 0xFF, 0xF3, 0x00, 0x00, 0x00,
  0xFF, 0xF1, 0xCF, 0xFC, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x2E, 0xFF, 0x80, 0x00, 0x00,
  0xFF, 0xF0, 0x06, 0xFF, 0xF3, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0xBF, 0xFD, 0x10, 0x00,
  0xFF, 0xF0, 0x00, 0x2E, 0xFF, 0x90, 0x00,
  0xFF, 0xF0, 0x00, 0x06, 0xFF, 0xF4, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0xAF, 0xFD, 0x10,
  0xFF, 0xF0, 0x00, 0x00, 0x1E, 0xFF, 0xA0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_004C[114] = { /* code 004C, LATIN CAPITAL LETTER L */
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_004D[152] = { /* code 004D, LATIN CAPITAL LETTER M */
  0xFF, 0xFF, 0x20, 0x00, 0x00, 0x01, 0xFF, 0xFF,
  0xFF, 0xFF, 0x80, 0x00, 0x00, 0x06, 0xFF, 0xFF,
  0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0C, 0xFF, 0xFF,
  0xFF, 0xFA, 0xF5, 0x00, 0x00, 0x3F, 0xAF, 0xFF,
  0xFF, 0xF4, 0xFB, 0x00, 0x00, 0x8F, 0x4F, 0xFF,
  0xFF, 0xF0, 0xEF, 0x20, 0x00, 0xDE, 0x0F, 0xFF,
  0xFF, 0xF0, 0x8F, 0x70, 0x04, 0xF8, 0x0F, 0xFF,
  0xFF, 0xF0, 0x2F, 0xD0, 0x0A, 0xF2, 0x0F, 0xFF,
  0xFF, 0xF0, 0x0C, 0xF4, 0x1F, 0xB0, 0x0F, 0xFF,
  0xFF, 0xF0, 0x06, 0xFA, 0x6F, 0x60, 0x0F, 0xFF,
  0xFF, 0xF0, 0x01, 0xFF, 0xCE, 0x10, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0xAF, 0xF9, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x4F, 0xF3, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0D, 0xD0, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_004E[133] = { /* code 004E, LATIN CAPITAL LETTER N */
  0xFF, 0xFF, 0x30, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xFF, 0x90, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xFF, 0xE0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xFA, 0xF6, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF3, 0xFC, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0xCF, 0x30, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x6F, 0x90, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x1F, 0xE0, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x09, 0xF6, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x03, 0xFC, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0xCF, 0x30, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x6F, 0x90, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x1E, 0xE0, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x09, 0xF6, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x03, 0xFC, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xCF, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x6F, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x0E, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x09, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_004F[152] = { /* code 004F, LATIN CAPITAL LETTER O */
  0x00, 0x00, 0x4A, 0xDF, 0xFD, 0xA4, 0x00, 0x00,
  0x00, 0x1B, 0xFF, 0xFF, 0xFF, 0xFF, 0xB1, 0x00,
  0x01, 0xCF, 0xFB, 0x30, 0x03, 0xBF, 0xFC, 0x10,
  0x08, 0xFF, 0xA0, 0x00, 0x00, 0x0A, 0xFF, 0x80,
  0x1F, 0xFE, 0x10, 0x00, 0x00, 0x01, 0xEF, 0xF1,
  0x7F, 0xF9, 0x00, 0x00, 0x00, 0x00, 0x8F, 0xF7,
  0xBF, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xFB,
  0xDF, 0xF2, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xFD,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xDF, 0xF2, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xFD,
  0xBF, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xFB,
  0x7F, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x8F, 0xF7,
  0x1F, 0xFE, 0x10, 0x00, 0x00, 0x01, 0xEF, 0xF1,
  0x08, 0xFF, 0xB0, 0x00, 0x00, 0x0A, 0xFF, 0x80,
  0x01, 0xCF, 0xFB, 0x40, 0x03, 0xBF, 0xFB, 0x00,
  0x00, 0x1B, 0xFF, 0xFF, 0xFF, 0xFF, 0xB1, 0x00,
  0x00, 0x00, 0x4A, 0xDF, 0xFD, 0xA4, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0050[114] = { /* code 0050, LATIN CAPITAL LETTER P */
  0xFF, 0xFF, 0xFF, 0xEB, 0x71, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x30,
  0xFF, 0xF0, 0x00, 0x39, 0xFF, 0xE2,
  0xFF, 0xF0, 0x00, 0x00, 0x9F, 0xF9,
  0xFF, 0xF0, 0x00, 0x00, 0x2F, 0xFD,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x3F, 0xFC,
  0xFF, 0xF0, 0x00, 0x00, 0xBF, 0xF6,
  0xFF, 0xF0, 0x00, 0x3A, 0xFF, 0xC0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x10,
  0xFF, 0xFF, 0xFF, 0xEB, 0x50, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0051[192] = { /* code 0051, LATIN CAPITAL LETTER Q */
  0x00, 0x00, 0x4A, 0xDF, 0xFD, 0xA4, 0x00, 0x00,
  0x00, 0x1B, 0xFF, 0xFF, 0xFF, 0xFF, 0xB1, 0x00,
  0x01, 0xCF, 0xFB, 0x30, 0x03, 0xBF, 0xFC, 0x10,
  0x08, 0xFF, 0xA0, 0x00, 0x00, 0x0A, 0xFF, 0x80,
  0x1F, 0xFE, 0x10, 0x00, 0x00, 0x01, 0xEF, 0xF1,
  0x7F, 0xF9, 0x00, 0x00, 0x00, 0x00, 0x8F, 0xF7,
  0xBF, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xFB,
  0xDF, 0xF2, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xFD,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xDF, 0xF2, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xFD,
  0xBF, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xFB,
  0x7F, 0xF9, 0x00, 0x00, 0x00, 0x00, 0x9F, 0xF7,
  0x1F, 0xFE, 0x10, 0x00, 0x00, 0x01, 0xEF, 0xF1,
  0x08, 0xFF, 0xB0, 0x00, 0x00, 0x0B, 0xFF, 0x80,
  0x01, 0xCF, 0xFB, 0x40, 0x03, 0xBF, 0xFC, 0x00,
  0x00, 0x1B, 0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x00,
  0x00, 0x00, 0x4A, 0xDF, 0xFF, 0xFF, 0x20, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0x50, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xC1, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xCF, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0xEF, 0xEC
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0052[133] = { /* code 0052, LATIN CAPITAL LETTER R */
  0xFF, 0xFF, 0xFF, 0xDB, 0x50, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x4E, 0xFF, 0x60, 0x00,
  0xFF, 0xF0, 0x00, 0x04, 0xFF, 0xC0, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0, 0x00,
  0xFF, 0xF0, 0x00, 0x02, 0xFF, 0xC0, 0x00,
  0xFF, 0xF0, 0x00, 0x07, 0xFF, 0x80, 0x00,
  0xFF, 0xF0, 0x01, 0x6E, 0xFD, 0x10, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xC2, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x3F, 0xFF, 0x70, 0x00, 0x00,
  0xFF, 0xF0, 0x07, 0xFF, 0xF3, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0xBF, 0xFD, 0x10, 0x00,
  0xFF, 0xF0, 0x00, 0x1E, 0xFF, 0xA0, 0x00,
  0xFF, 0xF0, 0x00, 0x04, 0xFF, 0xF6, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x8F, 0xFF, 0x30,
  0xFF, 0xF0, 0x00, 0x00, 0x0C, 0xFF, 0xD1,
  0xFF, 0xF0, 0x00, 0x00, 0x02, 0xEF, 0xF9
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0053[114] = { /* code 0053, LATIN CAPITAL LETTER S */
  0x00, 0x29, 0xDF, 0xFD, 0xB7, 0x10,
  0x05, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x3F, 0xFE, 0x71, 0x02, 0x7E, 0xF0,
  0xAF, 0xF6, 0x00, 0x00, 0x01, 0xA0,
  0xEF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xF4, 0x00, 0x00, 0x00, 0x00,
  0x8F, 0xFE, 0x40, 0x00, 0x00, 0x00,
  0x1D, 0xFF, 0xFE, 0xB7, 0x30, 0x00,
  0x01, 0x8E, 0xFF, 0xFF, 0xFB, 0x30,
  0x00, 0x01, 0x48, 0xCF, 0xFF, 0xE2,
  0x00, 0x00, 0x00, 0x02, 0xCF, 0xFA,
  0x00, 0x00, 0x00, 0x00, 0x3F, 0xFE,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x90, 0x00, 0x00, 0x00, 0x1F, 0xFD,
  0xF9, 0x00, 0x00, 0x00, 0x7F, 0xF9,
  0xFF, 0xD6, 0x10, 0x27, 0xFF, 0xE2,
  0xAF, 0xFF, 0xFF, 0xFF, 0xFE, 0x40,
  0x02, 0x8C, 0xEF, 0xFD, 0x81, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0054[171] = { /* code 0054, LATIN CAPITAL LETTER T */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0055[133] = { /* code 0055, LATIN CAPITAL LETTER U */
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xDF, 0xF1, 0x00, 0x00, 0x01, 0xFF, 0xD0,
  0xBF, 0xF4, 0x00, 0x00, 0x04, 0xFF, 0xB0,
  0x6F, 0xFB, 0x00, 0x00, 0x0B, 0xFF, 0x60,
  0x0D, 0xFF, 0x92, 0x02, 0x9F, 0xFD, 0x00,
  0x02, 0xDF, 0xFF, 0xFF, 0xFF, 0xD2, 0x00,
  0x00, 0x17, 0xCE, 0xFF, 0xC7, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0056[152] = { /* code 0056, LATIN CAPITAL LETTER V */
  0xCF, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xFC,
  0x7F, 0xFA, 0x00, 0x00, 0x00, 0x00, 0xAF, 0xF7,
  0x2F, 0xFF, 0x10, 0x00, 0x00, 0x01, 0xFF, 0xF2,
  0x0B, 0xFF, 0x50, 0x00, 0x00, 0x05, 0xFF, 0xB0,
  0x07, 0xFF, 0xB0, 0x00, 0x00, 0x0A, 0xFF, 0x70,
  0x02, 0xFF, 0xF1, 0x00, 0x00, 0x1F, 0xFF, 0x20,
  0x00, 0xBF, 0xF6, 0x00, 0x00, 0x5F, 0xFB, 0x00,
  0x00, 0x6F, 0xFB, 0x00, 0x00, 0xAF, 0xF6, 0x00,
  0x00, 0x1F, 0xFF, 0x10, 0x01, 0xFF, 0xF1, 0x00,
  0x00, 0x0A, 0xFF, 0x60, 0x05, 0xFF, 0xA0, 0x00,
  0x00, 0x05, 0xFF, 0xB0, 0x0A, 0xFF, 0x50, 0x00,
  0x00, 0x01, 0xEF, 0xF1, 0x1F, 0xFE, 0x10, 0x00,
  0x00, 0x00, 0xAF, 0xF6, 0x6F, 0xFA, 0x00, 0x00,
  0x00, 0x00, 0x5F, 0xFB, 0xBF, 0xF5, 0x00, 0x00,
  0x00, 0x00, 0x0E, 0xFF, 0xFF, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0x09, 0xFF, 0xFF, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x04, 0xFF, 0xFF, 0x40, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xDF, 0xFD, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x8F, 0xF8, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0057[228] = { /* code 0057, LATIN CAPITAL LETTER W */
  0xDF, 0xF3, 0x00, 0x00, 0x00, 0xDF, 0xE0, 0x00, 0x00, 0x03, 0xFF, 0xD0,
  0x9F, 0xF7, 0x00, 0x00, 0x01, 0xFF, 0xF3, 0x00, 0x00, 0x07, 0xFF, 0x90,
  0x5F, 0xFA, 0x00, 0x00, 0x05, 0xFF, 0xF7, 0x00, 0x00, 0x0A, 0xFF, 0x60,
  0x1F, 0xFE, 0x00, 0x00, 0x09, 0xFD, 0xFA, 0x00, 0x00, 0x0E, 0xFF, 0x20,
  0x0D, 0xFF, 0x30, 0x00, 0x0C, 0xF7, 0xFE, 0x00, 0x00, 0x2F, 0xFD, 0x00,
  0x09, 0xFF, 0x70, 0x00, 0x1F, 0xE1, 0xFF, 0x30, 0x00, 0x6F, 0xF9, 0x00,
  0x05, 0xFF, 0xA0, 0x00, 0x5F, 0xB0, 0xCF, 0x60, 0x00, 0xAF, 0xF5, 0x00,
  0x01, 0xFF, 0xE0, 0x00, 0x8F, 0x70, 0x9F, 0xA0, 0x00, 0xDF, 0xF1, 0x00,
  0x00, 0xCF, 0xF2, 0x00, 0xCF, 0x40, 0x5F, 0xE0, 0x02, 0xFF, 0xD0, 0x00,
  0x00, 0x8F, 0xF6, 0x01, 0xFF, 0x10, 0x2F, 0xF2, 0x05, 0xFF, 0x90, 0x00,
  0x00, 0x5F, 0xFA, 0x04, 0xFC, 0x00, 0x0E, 0xF6, 0x09, 0xFF, 0x50, 0x00,
  0x00, 0x1F, 0xFD, 0x08, 0xF9, 0x00, 0x0A, 0xF9, 0x0C, 0xFF, 0x10, 0x00,
  0x00, 0x0C, 0xFF, 0x2B, 0xF5, 0x00, 0x07, 0xFD, 0x1F, 0xFD, 0x00, 0x00,
  0x00, 0x08, 0xFF, 0x6F, 0xF2, 0x00, 0x03, 0xFF, 0x6F, 0xF9, 0x00, 0x00,
  0x00, 0x04, 0xFF, 0xDF, 0xE0, 0x00, 0x00, 0xFF, 0xDF, 0xF5, 0x00, 0x00,
  0x00, 0x01, 0xFF, 0xFF, 0xA0, 0x00, 0x00, 0xCF, 0xFF, 0xF1, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0xFF, 0x70, 0x00, 0x00, 0x8F, 0xFF, 0xD0, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0x30, 0x00, 0x00, 0x5F, 0xFF, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x4F, 0xFF, 0x00, 0x00, 0x00, 0x2F, 0xFF, 0x50, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0058[152] = { /* code 0058, LATIN CAPITAL LETTER X */
  0xAF, 0xF5, 0x00, 0x00, 0x00, 0x05, 0xFF, 0xA0,
  0x2E, 0xFE, 0x10, 0x00, 0x00, 0x1D, 0xFE, 0x20,
  0x06, 0xFF, 0x90, 0x00, 0x00, 0x9F, 0xF6, 0x00,
  0x00, 0xCF, 0xF3, 0x00, 0x03, 0xFF, 0xC0, 0x00,
  0x00, 0x3F, 0xFD, 0x00, 0x0C, 0xFF, 0x30, 0x00,
  0x00, 0x08, 0xFF, 0x70, 0x7F, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0xDF, 0xF4, 0xFF, 0xD0, 0x00, 0x00,
  0x00, 0x00, 0x4F, 0xFF, 0xFF, 0x40, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0xFF, 0xFA, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x02, 0xFF, 0xF2, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0xFF, 0xFA, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x4F, 0xFF, 0xFF, 0x40, 0x00, 0x00,
  0x00, 0x00, 0xDF, 0xF5, 0xFF, 0xD0, 0x00, 0x00,
  0x00, 0x08, 0xFF, 0x70, 0x7F, 0xF8, 0x00, 0x00,
  0x00, 0x3F, 0xFD, 0x00, 0x0D, 0xFF, 0x30, 0x00,
  0x00, 0xCF, 0xF3, 0x00, 0x03, 0xFF, 0xC0, 0x00,
  0x06, 0xFF, 0x90, 0x00, 0x00, 0x9F, 0xF6, 0x00,
  0x2E, 0xFD, 0x10, 0x00, 0x00, 0x1E, 0xFE, 0x20,
  0xAF, 0xF5, 0x00, 0x00, 0x00, 0x05, 0xFF, 0xA0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0059[152] = { /* code 0059, LATIN CAPITAL LETTER Y */
  0xBF, 0xFB, 0x00, 0x00, 0x00, 0x0B, 0xFF, 0xB0,
  0x3F, 0xFF, 0x40, 0x00, 0x00, 0x4F, 0xFF, 0x20,
  0x09, 0xFF, 0xC0, 0x00, 0x00, 0xCF, 0xF9, 0x00,
  0x01, 0xFF, 0xF5, 0x00, 0x06, 0xFF, 0xE1, 0x00,
  0x00, 0x7F, 0xFD, 0x00, 0x1E, 0xFF, 0x70, 0x00,
  0x00, 0x1E, 0xFF, 0x70, 0x7F, 0xFD, 0x00, 0x00,
  0x00, 0x06, 0xFF, 0xE2, 0xFF, 0xF5, 0x00, 0x00,
  0x00, 0x00, 0xDF, 0xFE, 0xFF, 0xB0, 0x00, 0x00,
  0x00, 0x00, 0x4F, 0xFF, 0xFF, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0xFF, 0xF9, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0xFF, 0xF1, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_005A[133] = { /* code 005A, LATIN CAPITAL LETTER Z */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x05, 0xFF, 0xA0,
  0x00, 0x00, 0x00, 0x00, 0x1E, 0xFE, 0x10,
  0x00, 0x00, 0x00, 0x00, 0xBF, 0xF5, 0x00,
  0x00, 0x00, 0x00, 0x06, 0xFF, 0xA0, 0x00,
  0x00, 0x00, 0x00, 0x2E, 0xFE, 0x10, 0x00,
  0x00, 0x00, 0x00, 0xBF, 0xF5, 0x00, 0x00,
  0x00, 0x00, 0x06, 0xFF, 0xA0, 0x00, 0x00,
  0x00, 0x00, 0x2E, 0xFE, 0x10, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0xF5, 0x00, 0x00, 0x00,
  0x00, 0x06, 0xFF, 0xA0, 0x00, 0x00, 0x00,
  0x00, 0x2E, 0xFE, 0x10, 0x00, 0x00, 0x00,
  0x00, 0xBF, 0xF5, 0x00, 0x00, 0x00, 0x00,
  0x06, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00,
  0x2E, 0xFD, 0x10, 0x00, 0x00, 0x00, 0x00,
  0xBF, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_005B[100] = { /* code 005B, LEFT SQUARE BRACKET */
  0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_005C[120] = { /* code 005C, REVERSE SOLIDUS */
  0xDF, 0x30, 0x00, 0x00, 0x00,
  0x8F, 0x80, 0x00, 0x00, 0x00,
  0x3F, 0xD0, 0x00, 0x00, 0x00,
  0x0D, 0xF3, 0x00, 0x00, 0x00,
  0x08, 0xF8, 0x00, 0x00, 0x00,
  0x03, 0xFD, 0x00, 0x00, 0x00,
  0x00, 0xDF, 0x30, 0x00, 0x00,
  0x00, 0x8F, 0x80, 0x00, 0x00,
  0x00, 0x3F, 0xD0, 0x00, 0x00,
  0x00, 0x0D, 0xF3, 0x00, 0x00,
  0x00, 0x08, 0xF8, 0x00, 0x00,
  0x00, 0x03, 0xFD, 0x00, 0x00,
  0x00, 0x00, 0xDF, 0x30, 0x00,
  0x00, 0x00, 0x8F, 0x80, 0x00,
  0x00, 0x00, 0x3F, 0xD0, 0x00,
  0x00, 0x00, 0x0D, 0xF3, 0x00,
  0x00, 0x00, 0x08, 0xF8, 0x00,
  0x00, 0x00, 0x03, 0xFD, 0x00,
  0x00, 0x00, 0x00, 0xDF, 0x30,
  0x00, 0x00, 0x00, 0x8F, 0x80,
  0x00, 0x00, 0x00, 0x3F, 0xD0,
  0x00, 0x00, 0x00, 0x0D, 0xF3,
  0x00, 0x00, 0x00, 0x08, 0xF8,
  0x00, 0x00, 0x00, 0x03, 0xFD
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_005D[100] = { /* code 005D, RIGHT SQUARE BRACKET */
  0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_005E[ 80] = { /* code 005E, CIRCUMFLEX ACCENT */
  0x00, 0x00, 0x00, 0x3F, 0xF3, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0xDF, 0xFD, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x09, 0xFA, 0x9F, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x5F, 0xD1, 0x1D, 0xF5, 0x00, 0x00,
  0x00, 0x02, 0xEF, 0x30, 0x03, 0xFE, 0x20, 0x00,
  0x00, 0x0B, 0xF7, 0x00, 0x00, 0x7F, 0xB0, 0x00,
  0x00, 0x7F, 0xB0, 0x00, 0x00, 0x0B, 0xF8, 0x00,
  0x03, 0xFE, 0x20, 0x00, 0x00, 0x02, 0xEF, 0x30,
  0x1D, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xD1,
  0xAF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x09, 0xFA
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_005F[ 14] = { /* code 005F, LOW LINE */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0060[ 15] = { /* code 0060, GRAVE ACCENT */
  0xAF, 0xF1, 0x00,
  0x2E, 0xF8, 0x00,
  0x06, 0xFE, 0x00,
  0x00, 0xBF, 0x50,
  0x00, 0x2E, 0xC0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0061[ 84] = { /* code 0061, LATIN SMALL LETTER A */
  0x07, 0xBD, 0xFF, 0xEC, 0x81, 0x00,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFD, 0x20,
  0x0C, 0x73, 0x00, 0x3B, 0xFF, 0x90,
  0x00, 0x00, 0x00, 0x02, 0xFF, 0xE0,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x26, 0xAC, 0xDF, 0xFF, 0xF0,
  0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x6F, 0xFF, 0x95, 0x31, 0xFF, 0xF0,
  0xCF, 0xF6, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xEF, 0xF1, 0x00, 0x05, 0xFF, 0xF0,
  0xAF, 0xF9, 0x11, 0x6F, 0xFF, 0xF0,
  0x3E, 0xFF, 0xFF, 0xF8, 0xFF, 0xF0,
  0x03, 0xBF, 0xFB, 0x40, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0062[120] = { /* code 0062, LATIN SMALL LETTER B */
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x5C, 0xFE, 0x80, 0x00,
  0xFF, 0xF9, 0xFF, 0xFF, 0xF9, 0x00,
  0xFF, 0xFF, 0x60, 0x3E, 0xFF, 0x30,
  0xFF, 0xF5, 0x00, 0x07, 0xFF, 0x90,
  0xFF, 0xF0, 0x00, 0x03, 0xFF, 0xC0,
  0xFF, 0xF0, 0x00, 0x01, 0xFF, 0xE0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x01, 0xFF, 0xD0,
  0xFF, 0xF0, 0x00, 0x04, 0xFF, 0xA0,
  0xFF, 0xF0, 0x00, 0x09, 0xFF, 0x60,
  0xFF, 0xF9, 0x20, 0x6F, 0xFD, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0x00,
  0xFF, 0xE4, 0xBF, 0xFB, 0x30, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0063[ 70] = { /* code 0063, LATIN SMALL LETTER C */
  0x00, 0x07, 0xCF, 0xFD, 0x83,
  0x01, 0xCF, 0xFF, 0xFF, 0xFF,
  0x0C, 0xFF, 0xB2, 0x03, 0xBF,
  0x5F, 0xFC, 0x00, 0x00, 0x08,
  0xAF, 0xF5, 0x00, 0x00, 0x00,
  0xEF, 0xF2, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00,
  0xEF, 0xF2, 0x00, 0x00, 0x00,
  0xBF, 0xF5, 0x00, 0x00, 0x00,
  0x6F, 0xFC, 0x00, 0x00, 0x08,
  0x0D, 0xFF, 0xB2, 0x03, 0xBF,
  0x02, 0xDF, 0xFF, 0xFF, 0xFF,
  0x00, 0x18, 0xCF, 0xFD, 0x82
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0064[120] = { /* code 0064, LATIN SMALL LETTER D */
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x2A, 0xEF, 0xC5, 0xFF, 0xF0,
  0x03, 0xEF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0D, 0xFF, 0x70, 0x18, 0xFF, 0xF0,
  0x6F, 0xFA, 0x00, 0x00, 0xFF, 0xF0,
  0xBF, 0xF4, 0x00, 0x00, 0xFF, 0xF0,
  0xEF, 0xF1, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xEF, 0xF1, 0x00, 0x00, 0xFF, 0xF0,
  0xCF, 0xF3, 0x00, 0x00, 0xFF, 0xF0,
  0x8F, 0xF7, 0x00, 0x04, 0xFF, 0xF0,
  0x3F, 0xFE, 0x30, 0x5E, 0xFF, 0xF0,
  0x08, 0xFF, 0xFF, 0xFA, 0xFF, 0xF0,
  0x00, 0x7D, 0xFD, 0x60, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0065[ 84] = { /* code 0065, LATIN SMALL LETTER E */
  0x00, 0x05, 0xBE, 0xFE, 0xB4, 0x00,
  0x01, 0xBF, 0xFF, 0xFF, 0xFF, 0x80,
  0x0A, 0xFF, 0x71, 0x04, 0xDF, 0xF4,
  0x4F, 0xF7, 0x00, 0x00, 0x4F, 0xFA,
  0xAF, 0xF1, 0x00, 0x00, 0x0F, 0xFE,
  0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xEF, 0xF2, 0x00, 0x00, 0x00, 0x00,
  0xAF, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x5F, 0xFE, 0x10, 0x00, 0x00, 0x1A,
  0x0B, 0xFF, 0xD6, 0x10, 0x27, 0xEF,
  0x01, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x04, 0xAD, 0xFF, 0xEA, 0x61
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0066[100] = { /* code 0066, LATIN SMALL LETTER F */
  0x00, 0x01, 0x8D, 0xFF, 0xD0,
  0x00, 0x0C, 0xFF, 0xFF, 0xF0,
  0x00, 0x7F, 0xFB, 0x20, 0x00,
  0x00, 0xCF, 0xF3, 0x00, 0x00,
  0x00, 0xEF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0067[114] = { /* code 0067, LATIN SMALL LETTER G */
  0x00, 0x2A, 0xEF, 0xB4, 0xEF, 0xF0,
  0x03, 0xEF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0D, 0xFF, 0x70, 0x29, 0xFF, 0xF0,
  0x5F, 0xFA, 0x00, 0x00, 0xFF, 0xF0,
  0xAF, 0xF4, 0x00, 0x00, 0xFF, 0xF0,
  0xDF, 0xF2, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xEF, 0xF1, 0x00, 0x00, 0xFF, 0xF0,
  0xCF, 0xF3, 0x00, 0x00, 0xFF, 0xF0,
  0x9F, 0xF7, 0x00, 0x02, 0xFF, 0xF0,
  0x3F, 0xFE, 0x30, 0x5E, 0xFF, 0xF0,
  0x09, 0xFF, 0xFF, 0xFB, 0xFF, 0xF0,
  0x00, 0x7D, 0xFE, 0x81, 0xFF, 0xE0,
  0x00, 0x00, 0x00, 0x01, 0xFF, 0xC0,
  0x00, 0x00, 0x00, 0x05, 0xFF, 0x80,
  0x0C, 0x72, 0x01, 0x5E, 0xFF, 0x20,
  0x0F, 0xFF, 0xFF, 0xFF, 0xF5, 0x00,
  0x08, 0xBE, 0xFF, 0xDA, 0x30, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0068[120] = { /* code 0068, LATIN SMALL LETTER H */
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x4B, 0xFF, 0xB2, 0x00,
  0xFF, 0xF8, 0xFF, 0xFF, 0xFE, 0x20,
  0xFF, 0xFF, 0x71, 0x1B, 0xFF, 0x90,
  0xFF, 0xF3, 0x00, 0x03, 0xFF, 0xD0,
  0xFF, 0xF0, 0x00, 0x01, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0069[ 38] = { /* code 0069, LATIN SMALL LETTER I */
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0x00, 0x00,
  0x00, 0x00,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_006A[ 96] = { /* code 006A, LATIN SMALL LETTER J */
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0xF0,
  0x00, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x03, 0xFF, 0xD0,
  0x00, 0x3C, 0xFF, 0x80,
  0xFF, 0xFF, 0xFD, 0x10,
  0xEF, 0xFC, 0x71, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_006B[120] = { /* code 006B, LATIN SMALL LETTER K */
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x1D, 0xFF, 0x80,
  0xFF, 0xF0, 0x00, 0xBF, 0xF9, 0x00,
  0xFF, 0xF0, 0x0A, 0xFF, 0xA0, 0x00,
  0xFF, 0xF0, 0x8F, 0xFB, 0x00, 0x00,
  0xFF, 0xF6, 0xFF, 0xB1, 0x00, 0x00,
  0xFF, 0xFF, 0xFD, 0x10, 0x00, 0x00,
  0xFF, 0xFF, 0xFE, 0x20, 0x00, 0x00,
  0xFF, 0xFE, 0xFF, 0xC1, 0x00, 0x00,
  0xFF, 0xF2, 0xEF, 0xFA, 0x00, 0x00,
  0xFF, 0xF0, 0x4F, 0xFF, 0x70, 0x00,
  0xFF, 0xF0, 0x07, 0xFF, 0xF4, 0x00,
  0xFF, 0xF0, 0x00, 0xBF, 0xFE, 0x20,
  0xFF, 0xF0, 0x00, 0x1D, 0xFF, 0xC0,
  0xFF, 0xF0, 0x00, 0x03, 0xFF, 0xF9
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_006C[ 40] = { /* code 006C, LATIN SMALL LETTER L */
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_006D[140] = { /* code 006D, LATIN SMALL LETTER M */
  0xFF, 0xF0, 0x4B, 0xFE, 0xB3, 0x00, 0x4B, 0xFF, 0xB3, 0x00,
  0xFF, 0xF7, 0xFF, 0xFF, 0xFE, 0x28, 0xFF, 0xFF, 0xFE, 0x20,
  0xFF, 0xFF, 0x81, 0x1A, 0xFF, 0xDF, 0x81, 0x1A, 0xFF, 0x90,
  0xFF, 0xF7, 0x00, 0x03, 0xFF, 0xF7, 0x00, 0x03, 0xFF, 0xD0,
  0xFF, 0xF0, 0x00, 0x01, 0xFF, 0xF0, 0x00, 0x01, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_006E[ 84] = { /* code 006E, LATIN SMALL LETTER N */
  0xFF, 0xF0, 0x4B, 0xFF, 0xB2, 0x00,
  0xFF, 0xF8, 0xFF, 0xFF, 0xFE, 0x20,
  0xFF, 0xFF, 0x71, 0x1B, 0xFF, 0x90,
  0xFF, 0xF3, 0x00, 0x03, 0xFF, 0xD0,
  0xFF, 0xF0, 0x00, 0x01, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_006F[ 84] = { /* code 006F, LATIN SMALL LETTER O */
  0x00, 0x17, 0xCF, 0xFC, 0x81, 0x00,
  0x02, 0xDF, 0xFF, 0xFF, 0xFD, 0x20,
  0x0C, 0xFF, 0x71, 0x17, 0xFF, 0xC0,
  0x5F, 0xFA, 0x00, 0x00, 0x9F, 0xF6,
  0xBF, 0xF4, 0x00, 0x00, 0x4F, 0xFB,
  0xEF, 0xF1, 0x00, 0x00, 0x1F, 0xFE,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xEF, 0xF1, 0x00, 0x00, 0x1F, 0xFE,
  0xBF, 0xF4, 0x00, 0x00, 0x4F, 0xFB,
  0x5F, 0xFA, 0x00, 0x00, 0xAF, 0xF6,
  0x0C, 0xFF, 0x71, 0x17, 0xFF, 0xD0,
  0x02, 0xDF, 0xFF, 0xFF, 0xFD, 0x20,
  0x00, 0x18, 0xCF, 0xFC, 0x81, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0070[114] = { /* code 0070, LATIN SMALL LETTER P */
  0xFF, 0xF0, 0x6C, 0xFE, 0x80, 0x00,
  0xFF, 0xFA, 0xFF, 0xFF, 0xF9, 0x00,
  0xFF, 0xFE, 0x50, 0x3E, 0xFF, 0x30,
  0xFF, 0xF2, 0x00, 0x07, 0xFF, 0x90,
  0xFF, 0xF0, 0x00, 0x03, 0xFF, 0xC0,
  0xFF, 0xF0, 0x00, 0x01, 0xFF, 0xE0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x01, 0xFF, 0xD0,
  0xFF, 0xF0, 0x00, 0x04, 0xFF, 0xA0,
  0xFF, 0xF0, 0x00, 0x0A, 0xFF, 0x60,
  0xFF, 0xF7, 0x10, 0x6F, 0xFD, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0x00,
  0xFF, 0xF5, 0xCF, 0xFB, 0x30, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0071[114] = { /* code 0071, LATIN SMALL LETTER Q */
  0x00, 0x2A, 0xEF, 0xC5, 0xEF, 0xF0,
  0x03, 0xEF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x0D, 0xFF, 0x60, 0x17, 0xFF, 0xF0,
  0x6F, 0xF9, 0x00, 0x00, 0xFF, 0xF0,
  0xBF, 0xF4, 0x00, 0x00, 0xFF, 0xF0,
  0xDF, 0xF1, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xEF, 0xF1, 0x00, 0x00, 0xFF, 0xF0,
  0xCF, 0xF3, 0x00, 0x00, 0xFF, 0xF0,
  0x8F, 0xF7, 0x00, 0x01, 0xFF, 0xF0,
  0x3F, 0xFE, 0x30, 0x4D, 0xFF, 0xF0,
  0x08, 0xFF, 0xFF, 0xFD, 0xFF, 0xF0,
  0x00, 0x7D, 0xFD, 0x81, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0072[ 56] = { /* code 0072, LATIN SMALL LETTER R */
  0xFF, 0xF0, 0x5D, 0xF0,
  0xFF, 0xF7, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFE, 0x60, 0x00,
  0xFF, 0xF2, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0073[ 84] = { /* code 0073, LATIN SMALL LETTER S */
  0x00, 0x6B, 0xEF, 0xEC, 0x72, 0x00,
  0x1B, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x8F, 0xFB, 0x30, 0x15, 0xDF, 0x00,
  0xEF, 0xF1, 0x00, 0x00, 0x0A, 0x00,
  0xFF, 0xF2, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xFD, 0x63, 0x00, 0x00, 0x00,
  0x5F, 0xFF, 0xFF, 0xFB, 0x71, 0x00,
  0x06, 0xEF, 0xFF, 0xFF, 0xFE, 0x30,
  0x00, 0x03, 0x69, 0xDF, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x05, 0xFF, 0xF0,
  0xB1, 0x00, 0x00, 0x00, 0xFF, 0xE0,
  0xFE, 0x83, 0x00, 0x39, 0xFF, 0x80,
  0xEF, 0xFF, 0xFF, 0xFF, 0xFB, 0x10,
  0x16, 0xAD, 0xFF, 0xEB, 0x50, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0074[ 90] = { /* code 0074, LATIN SMALL LETTER T */
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xFF, 0xF0, 0x00, 0x00,
  0x00, 0xEF, 0xF1, 0x00, 0x00,
  0x00, 0xBF, 0xF9, 0x10, 0x00,
  0x00, 0x4F, 0xFF, 0xFF, 0xF0,
  0x00, 0x04, 0xBE, 0xFE, 0xC0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0075[ 84] = { /* code 0075, LATIN SMALL LETTER U */
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xDF, 0xF3, 0x00, 0x07, 0xFF, 0xF0,
  0x9F, 0xFB, 0x11, 0x8F, 0xFF, 0xF0,
  0x2E, 0xFF, 0xFF, 0xF7, 0xFF, 0xF0,
  0x02, 0xBF, 0xFB, 0x40, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0076[ 98] = { /* code 0076, LATIN SMALL LETTER V */
  0xCF, 0xF6, 0x00, 0x00, 0x06, 0xFF, 0xC0,
  0x6F, 0xFB, 0x00, 0x00, 0x0B, 0xFF, 0x60,
  0x1F, 0xFF, 0x20, 0x00, 0x2F, 0xFF, 0x10,
  0x0A, 0xFF, 0x70, 0x00, 0x7F, 0xFA, 0x00,
  0x04, 0xFF, 0xD0, 0x00, 0xCF, 0xF4, 0x00,
  0x00, 0xDF, 0xF3, 0x03, 0xFF, 0xD0, 0x00,
  0x00, 0x7F, 0xF9, 0x08, 0xFF, 0x70, 0x00,
  0x00, 0x2F, 0xFE, 0x1D, 0xFF, 0x20, 0x00,
  0x00, 0x0B, 0xFF, 0x9F, 0xFB, 0x00, 0x00,
  0x00, 0x05, 0xFF, 0xFF, 0xF5, 0x00, 0x00,
  0x00, 0x00, 0xEF, 0xFF, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0x9F, 0xFF, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xFF, 0x20, 0x00, 0x00,
  0x00, 0x00, 0x0C, 0xFC, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0077[140] = { /* code 0077, LATIN SMALL LETTER W */
  0xDF, 0xF3, 0x00, 0x00, 0x9F, 0xB0, 0x00, 0x03, 0xFF, 0xD0,
  0x9F, 0xF6, 0x00, 0x00, 0xEF, 0xF1, 0x00, 0x05, 0xFF, 0x90,
  0x5F, 0xF8, 0x00, 0x03, 0xFF, 0xF6, 0x00, 0x07, 0xFF, 0x50,
  0x1F, 0xFB, 0x00, 0x08, 0xFC, 0xFB, 0x00, 0x0A, 0xFF, 0x10,
  0x0C, 0xFE, 0x00, 0x0D, 0xF2, 0xFF, 0x10, 0x0C, 0xFC, 0x00,
  0x08, 0xFF, 0x20, 0x3F, 0xB0, 0xBF, 0x60, 0x0F, 0xF8, 0x00,
  0x04, 0xFF, 0x50, 0x8F, 0x70, 0x6F, 0xA0, 0x3F, 0xF4, 0x00,
  0x00, 0xFF, 0x70, 0xCF, 0x20, 0x2F, 0xF1, 0x5F, 0xF1, 0x00,
  0x00, 0xBF, 0xA2, 0xFB, 0x00, 0x0B, 0xF5, 0x7F, 0xB0, 0x00,
  0x00, 0x7F, 0xD7, 0xF7, 0x00, 0x07, 0xFA, 0xAF, 0x70, 0x00,
  0x00, 0x3F, 0xFC, 0xF2, 0x00, 0x02, 0xFF, 0xDF, 0x30, 0x00,
  0x00, 0x0E, 0xFF, 0xB0, 0x00, 0x00, 0xBF, 0xFE, 0x00, 0x00,
  0x00, 0x0A, 0xFF, 0x70, 0x00, 0x00, 0x7F, 0xFB, 0x00, 0x00,
  0x00, 0x06, 0xFF, 0x20, 0x00, 0x00, 0x2F, 0xF7, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0078[ 98] = { /* code 0078, LATIN SMALL LETTER X */
  0xAF, 0xF6, 0x00, 0x00, 0x06, 0xFF, 0xA0,
  0x1D, 0xFE, 0x20, 0x00, 0x2E, 0xFD, 0x10,
  0x03, 0xFF, 0xC0, 0x00, 0xCF, 0xF3, 0x00,
  0x00, 0x8F, 0xF8, 0x08, 0xFF, 0x80, 0x00,
  0x00, 0x0C, 0xFF, 0x7F, 0xFC, 0x00, 0x00,
  0x00, 0x02, 0xEF, 0xFF, 0xE2, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0xFF, 0x50, 0x00, 0x00,
  0x00, 0x00, 0x5F, 0xFF, 0x50, 0x00, 0x00,
  0x00, 0x02, 0xEF, 0xFF, 0xE2, 0x00, 0x00,
  0x00, 0x0C, 0xFF, 0x7F, 0xFC, 0x00, 0x00,
  0x00, 0x8F, 0xF8, 0x08, 0xFF, 0x80, 0x00,
  0x03, 0xFF, 0xC0, 0x00, 0xCF, 0xF3, 0x00,
  0x1D, 0xFE, 0x20, 0x00, 0x2E, 0xFD, 0x10,
  0xAF, 0xF6, 0x00, 0x00, 0x06, 0xFF, 0xA0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0079[133] = { /* code 0079, LATIN SMALL LETTER Y */
  0xCF, 0xF6, 0x00, 0x00, 0x06, 0xFF, 0xC0,
  0x6F, 0xFC, 0x00, 0x00, 0x0C, 0xFF, 0x60,
  0x1E, 0xFF, 0x30, 0x00, 0x3F, 0xFE, 0x00,
  0x09, 0xFF, 0x90, 0x00, 0x8F, 0xF9, 0x00,
  0x03, 0xFF, 0xE0, 0x00, 0xEF, 0xF3, 0x00,
  0x00, 0xCF, 0xF5, 0x05, 0xFF, 0xB0, 0x00,
  0x00, 0x6F, 0xFB, 0x0B, 0xFF, 0x50, 0x00,
  0x00, 0x1F, 0xFF, 0x3F, 0xFE, 0x00, 0x00,
  0x00, 0x09, 0xFF, 0xDF, 0xF8, 0x00, 0x00,
  0x00, 0x03, 0xFF, 0xFF, 0xF2, 0x00, 0x00,
  0x00, 0x00, 0xCF, 0xFF, 0xB0, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0x40, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xFD, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x9F, 0xF7, 0x00, 0x00, 0x00,
  0x00, 0x01, 0xFF, 0xF1, 0x00, 0x00, 0x00,
  0x00, 0x08, 0xFF, 0xA0, 0x00, 0x00, 0x00,
  0x00, 0x0E, 0xFF, 0x40, 0x00, 0x00, 0x00,
  0x00, 0x6F, 0xFD, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xCF, 0xF7, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_007A[ 70] = { /* code 007A, LATIN SMALL LETTER Z */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x8F, 0xF7,
  0x00, 0x00, 0x03, 0xFF, 0xC0,
  0x00, 0x00, 0x0D, 0xFF, 0x30,
  0x00, 0x00, 0x8F, 0xF7, 0x00,
  0x00, 0x03, 0xFF, 0xC0, 0x00,
  0x00, 0x0D, 0xFF, 0x30, 0x00,
  0x00, 0x7F, 0xF8, 0x00, 0x00,
  0x03, 0xFF, 0xD0, 0x00, 0x00,
  0x0C, 0xFF, 0x30, 0x00, 0x00,
  0x7F, 0xF8, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_007B[125] = { /* code 007B, LEFT CURLY BRACKET */
  0x00, 0x00, 0x02, 0x9E, 0xFF,
  0x00, 0x00, 0x2E, 0xFF, 0xFF,
  0x00, 0x00, 0x9F, 0xFB, 0x10,
  0x00, 0x00, 0xDF, 0xF3, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00,
  0x00, 0x01, 0xFF, 0xF0, 0x00,
  0x00, 0x03, 0xFF, 0xD0, 0x00,
  0x00, 0x09, 0xFF, 0x60, 0x00,
  0x02, 0x8F, 0xF8, 0x00, 0x00,
  0xFF, 0xFA, 0x30, 0x00, 0x00,
  0xFF, 0xFA, 0x20, 0x00, 0x00,
  0x02, 0x9F, 0xF6, 0x00, 0x00,
  0x00, 0x0B, 0xFF, 0x40, 0x00,
  0x00, 0x04, 0xFF, 0xB0, 0x00,
  0x00, 0x01, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0xFF, 0xF0, 0x00,
  0x00, 0x00, 0xFF, 0xF1, 0x00,
  0x00, 0x00, 0xCF, 0xF3, 0x00,
  0x00, 0x00, 0x8F, 0xFC, 0x20,
  0x00, 0x00, 0x1D, 0xFF, 0xFF,
  0x00, 0x00, 0x01, 0x9D, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_007C[ 50] = { /* code 007C, VERTICAL LINE */
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0,
  0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_007D[125] = { /* code 007D, RIGHT CURLY BRACKET */
  0xFF, 0xE9, 0x20, 0x00, 0x00,
  0xFF, 0xFF, 0xE2, 0x00, 0x00,
  0x01, 0xBF, 0xF9, 0x00, 0x00,
  0x00, 0x3F, 0xFD, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x10, 0x00,
  0x00, 0x0D, 0xFF, 0x30, 0x00,
  0x00, 0x06, 0xFF, 0x90, 0x00,
  0x00, 0x00, 0x8F, 0xF8, 0x20,
  0x00, 0x00, 0x03, 0xAF, 0xFF,
  0x00, 0x00, 0x02, 0xAF, 0xFF,
  0x00, 0x00, 0x6F, 0xF9, 0x20,
  0x00, 0x04, 0xFF, 0xB0, 0x00,
  0x00, 0x0B, 0xFF, 0x40, 0x00,
  0x00, 0x0F, 0xFF, 0x10, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x0F, 0xFF, 0x00, 0x00,
  0x00, 0x1F, 0xFF, 0x00, 0x00,
  0x00, 0x3F, 0xFC, 0x00, 0x00,
  0x02, 0xCF, 0xF8, 0x00, 0x00,
  0xFF, 0xFF, 0xD1, 0x00, 0x00,
  0xFF, 0xD9, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_007E[ 56] = { /* code 007E, TILDE */
  0x00, 0x8E, 0xFB, 0x40, 0x00, 0x00, 0x0F, 0xF0,
  0x09, 0xFF, 0xFF, 0xF4, 0x00, 0x00, 0x2F, 0xD0,
  0x3F, 0xE3, 0x1A, 0xFE, 0x20, 0x00, 0x3F, 0xB0,
  0x8F, 0x70, 0x00, 0xBF, 0xC0, 0x00, 0x7F, 0x80,
  0xBF, 0x30, 0x00, 0x2E, 0xFA, 0x13, 0xEF, 0x30,
  0xDF, 0x20, 0x00, 0x04, 0xFF, 0xFF, 0xF9, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x3B, 0xFE, 0x80, 0x00
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_Font32_AA4_CharInfo[95] = {
   {   1,   1,   0,  27,   8, acGUI_Font32_AA4_0020 } /* code 0020, SPACE */
  ,{   3,  19,   3,   8,   9, acGUI_Font32_AA4_0021 } /* code 0021, EXCLAMATION MARK */
  ,{   8,   7,   1,   7,  10, acGUI_Font32_AA4_0022 } /* code 0022, QUOTATION MARK */
  ,{  16,  19,   1,   8,  19, acGUI_Font32_AA4_0023 } /* code 0023, NUMBER SIGN */
  ,{  12,  25,   1,   7,  14, acGUI_Font32_AA4_0024 } /* code 0024, DOLLAR SIGN */
  ,{  23,  19,   1,   8,  25, acGUI_Font32_AA4_0025 } /* code 0025, PERCENT SIGN */
  ,{  18,  19,   1,   8,  18, acGUI_Font32_AA4_0026 } /* code 0026, AMPERSAND */
  ,{   3,   7,   1,   7,   5, acGUI_Font32_AA4_0027 } /* code 0027, APOSTROPHE */
  ,{   8,  25,   1,   7,  10, acGUI_Font32_AA4_0028 } /* code 0028, LEFT PARENTHESIS */
  ,{   8,  25,   1,   7,  10, acGUI_Font32_AA4_0029 } /* code 0029, RIGHT PARENTHESIS */
  ,{  12,  12,   1,   7,  14, acGUI_Font32_AA4_002A } /* code 002A, ASTERISK */
  ,{  14,  14,   2,  12,  19, acGUI_Font32_AA4_002B } /* code 002B, PLUS SIGN */
  ,{   5,   8,   1,  23,   8, acGUI_Font32_AA4_002C } /* code 002C, COMMA */
  ,{   7,   2,   1,  18,   9, acGUI_Font32_AA4_002D } /* code 002D, HYPHEN-MINUS */
  ,{   3,   4,   2,  23,   8, acGUI_Font32_AA4_002E } /* code 002E, FULL STOP */
  ,{  10,  24,   0,   7,  10, acGUI_Font32_AA4_002F } /* code 002F, SOLIDUS */
  ,{  12,  19,   1,   8,  14, acGUI_Font32_AA4_0030 } /* code 0030, DIGIT ZERO */
  ,{   9,  19,   3,   8,  14, acGUI_Font32_AA4_0031 } /* code 0031, DIGIT ONE */
  ,{  12,  19,   1,   8,  14, acGUI_Font32_AA4_0032 } /* code 0032, DIGIT TWO */
  ,{  11,  19,   1,   8,  14, acGUI_Font32_AA4_0033 } /* code 0033, DIGIT THREE */
  ,{  13,  19,   1,   8,  14, acGUI_Font32_AA4_0034 } /* code 0034, DIGIT FOUR */
  ,{  11,  19,   2,   8,  14, acGUI_Font32_AA4_0035 } /* code 0035, DIGIT FIVE */
  ,{  12,  19,   1,   8,  14, acGUI_Font32_AA4_0036 } /* code 0036, DIGIT SIX */
  ,{  12,  19,   1,   8,  14, acGUI_Font32_AA4_0037 } /* code 0037, DIGIT SEVEN */
  ,{  12,  19,   1,   8,  14, acGUI_Font32_AA4_0038 } /* code 0038, DIGIT EIGHT */
  ,{  12,  19,   1,   8,  14, acGUI_Font32_AA4_0039 } /* code 0039, DIGIT NINE */
  ,{   3,  14,   3,  13,   9, acGUI_Font32_AA4_003A } /* code 003A, COLON */
  ,{   5,  18,   1,  13,   9, acGUI_Font32_AA4_003B } /* code 003B, SEMICOLON */
  ,{  14,  15,   3,  11,  19, acGUI_Font32_AA4_003C } /* code 003C, LESS-THAN SIGN */
  ,{  14,   7,   2,  15,  19, acGUI_Font32_AA4_003D } /* code 003D, EQUALS SIGN */
  ,{  14,  15,   3,  11,  19, acGUI_Font32_AA4_003E } /* code 003E, GREATER-THAN SIGN */
  ,{  10,  19,   1,   8,  12, acGUI_Font32_AA4_003F } /* code 003F, QUESTION MARK */
  ,{  20,  22,   2,   8,  24, acGUI_Font32_AA4_0040 } /* code 0040, COMMERCIAL AT */
  ,{  16,  19,   0,   8,  16, acGUI_Font32_AA4_0041 } /* code 0041, LATIN CAPITAL LETTER A */
  ,{  12,  19,   2,   8,  15, acGUI_Font32_AA4_0042 } /* code 0042, LATIN CAPITAL LETTER B */
  ,{  14,  19,   1,   8,  16, acGUI_Font32_AA4_0043 } /* code 0043, LATIN CAPITAL LETTER C */
  ,{  15,  19,   2,   8,  18, acGUI_Font32_AA4_0044 } /* code 0044, LATIN CAPITAL LETTER D */
  ,{  12,  19,   2,   8,  15, acGUI_Font32_AA4_0045 } /* code 0045, LATIN CAPITAL LETTER E */
  ,{  12,  19,   2,   8,  14, acGUI_Font32_AA4_0046 } /* code 0046, LATIN CAPITAL LETTER F */
  ,{  15,  19,   1,   8,  17, acGUI_Font32_AA4_0047 } /* code 0047, LATIN CAPITAL LETTER G */
  ,{  14,  19,   2,   8,  18, acGUI_Font32_AA4_0048 } /* code 0048, LATIN CAPITAL LETTER H */
  ,{   7,  19,   2,   8,  10, acGUI_Font32_AA4_0049 } /* code 0049, LATIN CAPITAL LETTER I */
  ,{   9,  19,   0,   8,  11, acGUI_Font32_AA4_004A } /* code 004A, LATIN CAPITAL LETTER J */
  ,{  13,  19,   2,   8,  15, acGUI_Font32_AA4_004B } /* code 004B, LATIN CAPITAL LETTER K */
  ,{  11,  19,   2,   8,  13, acGUI_Font32_AA4_004C } /* code 004C, LATIN CAPITAL LETTER L */
  ,{  16,  19,   2,   8,  20, acGUI_Font32_AA4_004D } /* code 004D, LATIN CAPITAL LETTER M */
  ,{  13,  19,   2,   8,  17, acGUI_Font32_AA4_004E } /* code 004E, LATIN CAPITAL LETTER N */
  ,{  16,  19,   1,   8,  18, acGUI_Font32_AA4_004F } /* code 004F, LATIN CAPITAL LETTER O */
  ,{  12,  19,   2,   8,  14, acGUI_Font32_AA4_0050 } /* code 0050, LATIN CAPITAL LETTER P */
  ,{  16,  24,   1,   8,  18, acGUI_Font32_AA4_0051 } /* code 0051, LATIN CAPITAL LETTER Q */
  ,{  14,  19,   2,   8,  16, acGUI_Font32_AA4_0052 } /* code 0052, LATIN CAPITAL LETTER R */
  ,{  12,  19,   1,   8,  14, acGUI_Font32_AA4_0053 } /* code 0053, LATIN CAPITAL LETTER S */
  ,{  17,  19,  -1,   8,  15, acGUI_Font32_AA4_0054 } /* code 0054, LATIN CAPITAL LETTER T */
  ,{  13,  19,   2,   8,  17, acGUI_Font32_AA4_0055 } /* code 0055, LATIN CAPITAL LETTER U */
  ,{  16,  19,   0,   8,  16, acGUI_Font32_AA4_0056 } /* code 0056, LATIN CAPITAL LETTER V */
  ,{  23,  19,   0,   8,  23, acGUI_Font32_AA4_0057 } /* code 0057, LATIN CAPITAL LETTER W */
  ,{  15,  19,   0,   8,  15, acGUI_Font32_AA4_0058 } /* code 0058, LATIN CAPITAL LETTER X */
  ,{  15,  19,   0,   8,  15, acGUI_Font32_AA4_0059 } /* code 0059, LATIN CAPITAL LETTER Y */
  ,{  13,  19,   1,   8,  15, acGUI_Font32_AA4_005A } /* code 005A, LATIN CAPITAL LETTER Z */
  ,{   7,  25,   2,   7,  10, acGUI_Font32_AA4_005B } /* code 005B, LEFT SQUARE BRACKET */
  ,{  10,  24,   1,   7,  10, acGUI_Font32_AA4_005C } /* code 005C, REVERSE SOLIDUS */
  ,{   7,  25,   1,   7,  10, acGUI_Font32_AA4_005D } /* code 005D, RIGHT SQUARE BRACKET */
  ,{  16,  10,   2,   8,  19, acGUI_Font32_AA4_005E } /* code 005E, CIRCUMFLEX ACCENT */
  ,{  14,   2,   0,  29,  14, acGUI_Font32_AA4_005F } /* code 005F, LOW LINE */
  ,{   5,   5,   3,   5,  14, acGUI_Font32_AA4_0060 } /* code 0060, GRAVE ACCENT */
  ,{  11,  14,   1,  13,  14, acGUI_Font32_AA4_0061 } /* code 0061, LATIN SMALL LETTER A */
  ,{  11,  20,   2,   7,  14, acGUI_Font32_AA4_0062 } /* code 0062, LATIN SMALL LETTER B */
  ,{  10,  14,   1,  13,  12, acGUI_Font32_AA4_0063 } /* code 0063, LATIN SMALL LETTER C */
  ,{  11,  20,   1,   7,  14, acGUI_Font32_AA4_0064 } /* code 0064, LATIN SMALL LETTER D */
  ,{  12,  14,   1,  13,  14, acGUI_Font32_AA4_0065 } /* code 0065, LATIN SMALL LETTER E */
  ,{   9,  20,   0,   7,   8, acGUI_Font32_AA4_0066 } /* code 0066, LATIN SMALL LETTER F */
  ,{  11,  19,   1,  13,  14, acGUI_Font32_AA4_0067 } /* code 0067, LATIN SMALL LETTER G */
  ,{  11,  20,   2,   7,  15, acGUI_Font32_AA4_0068 } /* code 0068, LATIN SMALL LETTER H */
  ,{   3,  19,   2,   8,   6, acGUI_Font32_AA4_0069 } /* code 0069, LATIN SMALL LETTER I */
  ,{   7,  24,  -2,   8,   7, acGUI_Font32_AA4_006A } /* code 006A, LATIN SMALL LETTER J */
  ,{  12,  20,   2,   7,  13, acGUI_Font32_AA4_006B } /* code 006B, LATIN SMALL LETTER K */
  ,{   3,  20,   2,   7,   6, acGUI_Font32_AA4_006C } /* code 006C, LATIN SMALL LETTER L */
  ,{  19,  14,   2,  13,  22, acGUI_Font32_AA4_006D } /* code 006D, LATIN SMALL LETTER M */
  ,{  11,  14,   2,  13,  15, acGUI_Font32_AA4_006E } /* code 006E, LATIN SMALL LETTER N */
  ,{  12,  14,   1,  13,  14, acGUI_Font32_AA4_006F } /* code 006F, LATIN SMALL LETTER O */
  ,{  11,  19,   2,  13,  14, acGUI_Font32_AA4_0070 } /* code 0070, LATIN SMALL LETTER P */
  ,{  11,  19,   1,  13,  14, acGUI_Font32_AA4_0071 } /* code 0071, LATIN SMALL LETTER Q */
  ,{   7,  14,   2,  13,   9, acGUI_Font32_AA4_0072 } /* code 0072, LATIN SMALL LETTER R */
  ,{  11,  14,   1,  13,  12, acGUI_Font32_AA4_0073 } /* code 0073, LATIN SMALL LETTER S */
  ,{   9,  18,   0,   9,   9, acGUI_Font32_AA4_0074 } /* code 0074, LATIN SMALL LETTER T */
  ,{  11,  14,   2,  13,  15, acGUI_Font32_AA4_0075 } /* code 0075, LATIN SMALL LETTER U */
  ,{  13,  14,   0,  13,  13, acGUI_Font32_AA4_0076 } /* code 0076, LATIN SMALL LETTER V */
  ,{  19,  14,   0,  13,  19, acGUI_Font32_AA4_0077 } /* code 0077, LATIN SMALL LETTER W */
  ,{  13,  14,   0,  13,  13, acGUI_Font32_AA4_0078 } /* code 0078, LATIN SMALL LETTER X */
  ,{  13,  19,   0,  13,  13, acGUI_Font32_AA4_0079 } /* code 0079, LATIN SMALL LETTER Y */
  ,{  10,  14,   1,  13,  12, acGUI_Font32_AA4_007A } /* code 007A, LATIN SMALL LETTER Z */
  ,{  10,  25,   1,   7,  13, acGUI_Font32_AA4_007B } /* code 007B, LEFT CURLY BRACKET */
  ,{   3,  25,   4,   7,  10, acGUI_Font32_AA4_007C } /* code 007C, VERTICAL LINE */
  ,{  10,  25,   2,   7,  13, acGUI_Font32_AA4_007D } /* code 007D, RIGHT CURLY BRACKET */
  ,{  15,   7,   2,  15,  19, acGUI_Font32_AA4_007E } /* code 007E, TILDE */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font32_AA4_Prop1 = {
   0x0020 /* first character */
  ,0x007E /* last character  */
  ,&GUI_Font32_AA4_CharInfo[  0] /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT GUI_Font32_AA4 = {
   GUI_FONTTYPE_PROP_AA4_EXT /* type of font    */
  ,32 /* height of font  */
  ,32 /* space of font y */
  ,1 /* magnification x */
  ,1 /* magnification y */
  ,{&GUI_Font32_AA4_Prop1}
  ,27 /* Baseline */
  ,14 /* Height of lowercase characters */
  ,19 /* Height of capital characters */
};

/*********************************************************************
*
*       bmGestures_120x100
*/
static GUI_CONST_STORAGE GUI_COLOR _ColorsGestures_120x100[] = {
#if (GUI_USE_ARGB == 1)
  0xFF000000, 0xFF000000, 0xFF000093, 0xFF0000B3,
  0xFF0000C3, 0xFF0000A3, 0xFF0000BB, 0xFF00009A,
  0xFF0000AB, 0xFF0000CB, 0xFF0000E9, 0xFF0000ED,
  0xFFFFFFFF, 0xFF0000E1, 0xFF0000DD, 0xFF0000D1,
  0xFF0000D5, 0xFF0000D9, 0xFF0000F1, 0xFF0000E5,
  0xFF00008F, 0xFFFEFE00, 0xFFFE0000, 0xFF008500,
  0xFF0B0B9E, 0xFFE3E3F4, 0xFF7474F1, 0xFF6161C2,
  0xFFAEAEF5, 0xFFD7D7F3, 0xFFB5B5EB, 0xFF008101,
  0xFFA8003B, 0xFFDE0019, 0xFF9F9FEB, 0xFF9F9FE3,
  0xFF77775B, 0xFF003B6D, 0xFFDE0016, 0xFFB5B5E4,
  0xFFA90042, 0xFF7676D3, 0xFFD7D7F8, 0xFF003A74,
  0xFF7676E3, 0xFF7676DB, 0xFF9E9EDC, 0xFFB5B5F1,
  0xFF767660, 0xFF1600BB, 0xFFC6002D, 0xFFB5B5F4,
  0xFF9F9FF1, 0xFF003A70, 0xFF2D0093, 0xFF2D00A3,
  0xFF2C009C, 0xFF7676CD, 0xFF7575ED, 0xFF1616A3,
  0xFF2D008C, 0xFF2C00AA, 0xFF7676E9, 0xFFF80005,
  0xFFD2D21D, 0xFF008006, 0xFFD30023, 0xFF00347D,
  0xFF16169C, 0xFF212195, 0xFF1300C3, 0xFF0505E1,
  0xFFBABA2C, 0xFFC6C626, 0xFFC5C528, 0xFF007D0A,
  0xFF1313AB, 0xFF2500B2, 0xFF2600BA, 0xFF22229D,
  0xFF0505D1, 0xFF0505D5, 0xFF0505D9, 0xFF0505DD,
  0xFFB9003A, 0xFFCC0025, 0xFFEA0012, 0xFFB9B932,
  0xFFDEDE15, 0xFFD2D220, 0xFF00367B, 0xFF00455C,
  0xFF004565, 0xFF0E0EA0, 0xFF002C85, 0xFF002C91,
  0xFF2B2B8A, 0xFF0E00CA, 0xFF580090, 0xFFBB0033,
  0xFFB20041, 0xFFE10019, 0xFFB2B2F6, 0xFFD8D8FA,
  0xFF005C3C, 0xFF007F06, 0xFF005743, 0xFF6E007C,
  0xFF616165, 0xFF0C009A, 0xFF0F0FAE, 0xFF0F00B2,
  0xFF0900BE, 0xFF0D0DB0, 0xFF1B00AC, 0xFF1A00BD,
  0xFF002094, 0xFF002893, 0xFF003180, 0xFF003480,
  0xFF2100BA, 0xFF2100BD, 0xFF2C2C9A, 0xFF0A00D4,
  0xFF1000CB, 0xFF1600C8, 0xFF650080, 0xFF6A0081,
  0xFF484885, 0xFF5F5FBE, 0xFF008D00, 0xFFAB0035,
  0xFFB7003E, 0xFF9C0054, 0xFF810065, 0xFFA4004E,
  0xFFCA002A, 0xFFCC002A, 0xFFE50012, 0xFFE60015,
  0xFFF3000A, 0xFFFB0003, 0xFFDCDC19, 0xFFCACA24,
  0xFFF5F507, 0xFFF1F109, 0xFF9E9EF4, 0xFF00337F,
  0xFF006F1B, 0xFF007B09, 0xFF007219, 0xFF00652F,
  0xFF006C2A, 0xFF004E52, 0xFF004164, 0xFF004662,
  0xFF004169, 0xFF00416C, 0xFF006240, 0xFF420078,
  0xFF6E005D, 0xFF6B007C, 0xFF7D0064, 0xFF720073,
  0xFF730075, 0xFF770073, 0xFF760076, 0xFF7B0070,
  0xFF56566C, 0xFF777757, 0xFF7E7E5D, 0xFF6E6E69,
  0xFF001C9D, 0xFF1D1D8F, 0xFF1F1F9F, 0xFF0014BC,
  0xFF1200B0, 0xFF1212B0, 0xFF00268B, 0xFF002998,
  0xFF003088, 0xFF0021A5, 0xFF360083, 0xFF2100A3,
  0xFF2300AA, 0xFF2F00B0, 0xFF2C00B4, 0xFF3700A0,
  0xFF3700AD, 0xFF24248C, 0xFF2E2E87, 0xFF2121A0,
  0xFF000DC8, 0xFF0A00C4, 0xFF0F00CC, 0xFF0700D0,
  0xFF0500D6, 0xFF0800D0, 0xFF0010C3, 0xFF1C00C1,
  0xFF1D00C6, 0xFF1300D4, 0xFF2300C0, 0xFF3939EA,
  0xFF4F008E, 0xFF450093, 0xFF400098, 0xFF47009E,
  0xFF4A009A, 0xFF5B0087, 0xFF510096, 0xFF630089,
  0xFF6C0080, 0xFF464687, 0xFF4848EC, 0xFF6F6FC7,
  0xFF6B6BF0, 0xFF6E6EF0, 0xFF7272F0, 0xFF008800,
  0xFFB8003C, 0xFFBC003A, 0xFF8F0059, 0xFF960055,
  0xFF93005C, 0xFF83006A, 0xFFA40047, 0xFFA50049,
  0xFFA90048, 0xFFA10050, 0xFFDB001F, 0xFFC9002C,
  0xFFCC002C, 0xFFC00032, 0xFFC20034, 0xFFC50030,
  0xFFD80020, 0xFFF0000C, 0xFFF4000B, 0xFFABAB3B,
  0xFFB6B635, 0xFF83834F, 0xFF8E8E47, 0xFF828255,
  0xFF898953, 0xFF9B9B41, 0xFF929250, 0xFFE7E710,
  0xFFE9E910, 0xFF8888D1, 0xFFA7A7DC, 0xFFADADE0,
  0xFFC8C8EA, 0xFFD8D8EF, 0xFFDADAF0, 0xFFE9E9FC
#else
  0x000000, 0x000000, 0x930000, 0xB30000,
  0xC30000, 0xA30000, 0xBB0000, 0x9A0000,
  0xAB0000, 0xCB0000, 0xE90000, 0xED0000,
  0xFFFFFF, 0xE10000, 0xDD0000, 0xD10000,
  0xD50000, 0xD90000, 0xF10000, 0xE50000,
  0x8F0000, 0x00FEFE, 0x0000FE, 0x008500,
  0x9E0B0B, 0xF4E3E3, 0xF17474, 0xC26161,
  0xF5AEAE, 0xF3D7D7, 0xEBB5B5, 0x018100,
  0x3B00A8, 0x1900DE, 0xEB9F9F, 0xE39F9F,
  0x5B7777, 0x6D3B00, 0x1600DE, 0xE4B5B5,
  0x4200A9, 0xD37676, 0xF8D7D7, 0x743A00,
  0xE37676, 0xDB7676, 0xDC9E9E, 0xF1B5B5,
  0x607676, 0xBB0016, 0x2D00C6, 0xF4B5B5,
  0xF19F9F, 0x703A00, 0x93002D, 0xA3002D,
  0x9C002C, 0xCD7676, 0xED7575, 0xA31616,
  0x8C002D, 0xAA002C, 0xE97676, 0x0500F8,
  0x1DD2D2, 0x068000, 0x2300D3, 0x7D3400,
  0x9C1616, 0x952121, 0xC30013, 0xE10505,
  0x2CBABA, 0x26C6C6, 0x28C5C5, 0x0A7D00,
  0xAB1313, 0xB20025, 0xBA0026, 0x9D2222,
  0xD10505, 0xD50505, 0xD90505, 0xDD0505,
  0x3A00B9, 0x2500CC, 0x1200EA, 0x32B9B9,
  0x15DEDE, 0x20D2D2, 0x7B3600, 0x5C4500,
  0x654500, 0xA00E0E, 0x852C00, 0x912C00,
  0x8A2B2B, 0xCA000E, 0x900058, 0x3300BB,
  0x4100B2, 0x1900E1, 0xF6B2B2, 0xFAD8D8,
  0x3C5C00, 0x067F00, 0x435700, 0x7C006E,
  0x656161, 0x9A000C, 0xAE0F0F, 0xB2000F,
  0xBE0009, 0xB00D0D, 0xAC001B, 0xBD001A,
  0x942000, 0x932800, 0x803100, 0x803400,
  0xBA0021, 0xBD0021, 0x9A2C2C, 0xD4000A,
  0xCB0010, 0xC80016, 0x800065, 0x81006A,
  0x854848, 0xBE5F5F, 0x008D00, 0x3500AB,
  0x3E00B7, 0x54009C, 0x650081, 0x4E00A4,
  0x2A00CA, 0x2A00CC, 0x1200E5, 0x1500E6,
  0x0A00F3, 0x0300FB, 0x19DCDC, 0x24CACA,
  0x07F5F5, 0x09F1F1, 0xF49E9E, 0x7F3300,
  0x1B6F00, 0x097B00, 0x197200, 0x2F6500,
  0x2A6C00, 0x524E00, 0x644100, 0x624600,
  0x694100, 0x6C4100, 0x406200, 0x780042,
  0x5D006E, 0x7C006B, 0x64007D, 0x730072,
  0x750073, 0x730077, 0x760076, 0x70007B,
  0x6C5656, 0x577777, 0x5D7E7E, 0x696E6E,
  0x9D1C00, 0x8F1D1D, 0x9F1F1F, 0xBC1400,
  0xB00012, 0xB01212, 0x8B2600, 0x982900,
  0x883000, 0xA52100, 0x830036, 0xA30021,
  0xAA0023, 0xB0002F, 0xB4002C, 0xA00037,
  0xAD0037, 0x8C2424, 0x872E2E, 0xA02121,
  0xC80D00, 0xC4000A, 0xCC000F, 0xD00007,
  0xD60005, 0xD00008, 0xC31000, 0xC1001C,
  0xC6001D, 0xD40013, 0xC00023, 0xEA3939,
  0x8E004F, 0x930045, 0x980040, 0x9E0047,
  0x9A004A, 0x87005B, 0x960051, 0x890063,
  0x80006C, 0x874646, 0xEC4848, 0xC76F6F,
  0xF06B6B, 0xF06E6E, 0xF07272, 0x008800,
  0x3C00B8, 0x3A00BC, 0x59008F, 0x550096,
  0x5C0093, 0x6A0083, 0x4700A4, 0x4900A5,
  0x4800A9, 0x5000A1, 0x1F00DB, 0x2C00C9,
  0x2C00CC, 0x3200C0, 0x3400C2, 0x3000C5,
  0x2000D8, 0x0C00F0, 0x0B00F4, 0x3BABAB,
  0x35B6B6, 0x4F8383, 0x478E8E, 0x558282,
  0x538989, 0x419B9B, 0x509292, 0x10E7E7,
  0x10E9E9, 0xD18888, 0xDCA7A7, 0xE0ADAD,
  0xEAC8C8, 0xEFD8D8, 0xF0DADA, 0xFCE9E9
#endif
};

static GUI_CONST_STORAGE GUI_LOGPALETTE _PalGestures_120x100 = {
  256,  // Number of entries
  0,    // No transparency
  &_ColorsGestures_120x100[0]
};

static GUI_CONST_STORAGE unsigned char _acGestures_120x100[] = {
  0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
  0x0C, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
        0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
        0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0C,
  0x0C, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
        0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
        0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0C,
  0x0C, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
        0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12,
        0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x0C,
  0x0C, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B,
        0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B,
        0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0C,
  0x0C, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B,
        0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B,
        0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0C,
  0x0C, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B,
        0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B,
        0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0C,
  0x0C, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B,
        0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B,
        0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0C,
  0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C,
  0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C,
  0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C,
  0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C,
  0x0C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0C,
  0x0C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13,
        0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13,
        0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x0C,
  0x0C, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0xD6, 0xD9, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A,
        0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0xDA, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A,
        0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0x1A, 0xD8, 0xCB, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x0C,
  0x0C, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x47, 0x67, 0x67, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C,
        0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x66, 0x66, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C,
        0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0x1C, 0xFF, 0x66, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0C,
  0x0C, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x47, 0x67, 0x1A, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x92, 0x33, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0C,
  0x0C, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x47, 0x67, 0x3A, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x92, 0x33, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0C,
  0x0C, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x47, 0x67, 0x3A, 0x0E, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0E, 0x92, 0x33, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0C,
  0x0C, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x47, 0x67, 0x3A, 0x0E, 0x0D, 0x0D, 0x0D, 0x13, 0x0D, 0x0A, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0A, 0x13, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D,
        0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0E, 0x92, 0x33, 0x0E, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x0C,
  0x0C, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x47, 0x67, 0x3A, 0x0E, 0x0E, 0x0D, 0x13, 0xB3, 0x9E, 0x77, 0x13, 0x0D, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0D, 0x0D, 0xB5, 0xAF, 0x0D, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
        0x0E, 0x0D, 0x0D, 0x0A, 0x0E, 0x7B, 0x0D, 0x0E, 0x0E, 0x0E, 0x0E, 0x34, 0x33, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0C,
  0x0C, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x53, 0x2A, 0x3A, 0x0E, 0x0E, 0x0D, 0x0E, 0x97, 0x82, 0x17, 0x2B, 0x0A, 0x0D, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0D, 0x13, 0x5C, 0x17, 0x96, 0xC0, 0x0D, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0D, 0x0D,
        0x0A, 0x0D, 0xC8, 0xD3, 0xDD, 0x65, 0xBC, 0x13, 0x0E, 0x0E, 0x0E, 0x34, 0x33, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0C,
  0x0C, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x53, 0x2A, 0x3A, 0x11, 0x0E, 0x0E, 0x13, 0x77, 0x17, 0x17, 0x17, 0x2B, 0x0A, 0x0D, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0D, 0x13, 0x5C, 0x17, 0xDB, 0x95, 0xC6, 0x0D, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0D, 0x0A, 0x0D, 0xCA,
        0x7F, 0x64, 0xEE, 0x16, 0x16, 0x16, 0xCF, 0x13, 0x0E, 0x0E, 0x11, 0x34, 0x33, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0C,
  0x0C, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x53, 0x2A, 0x3A, 0x11, 0x0E, 0x0E, 0x0E, 0x0D, 0x2B, 0x17, 0x17, 0x17, 0x2B, 0x13, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E,
        0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0D, 0x5C, 0x17, 0x17, 0x69, 0x5F, 0x0D, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0D, 0x0A, 0x0D, 0xCA, 0x7F, 0x84, 0x3F,
        0x16, 0x16, 0x56, 0xE8, 0x16, 0xE6, 0x7B, 0x0D, 0x0E, 0x0E, 0x11, 0x34, 0x33, 0x11, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0C,
  0x0C, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x52, 0x2A, 0x3E, 0x11, 0x11, 0x11, 0x11, 0x0E, 0x13, 0x2B, 0x17, 0x17, 0x17, 0x2B, 0x13, 0x0E, 0x11, 0x11, 0x11,
        0x11, 0x11, 0x11, 0x11, 0x0E, 0x13, 0x9D, 0x17, 0x17, 0x41, 0x5F, 0x0A, 0x0E, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0E, 0x0D, 0x0A, 0x0E, 0x4E, 0xD4, 0x84, 0x3F, 0x16, 0x16, 0x56,
        0x87, 0x62, 0xC9, 0xA7, 0x16, 0xE0, 0x13, 0x0E, 0x11, 0x11, 0x11, 0x34, 0x33, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0C,
  0x0C, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x52, 0x2A, 0x3E, 0x10, 0x11, 0x11, 0x11, 0x11, 0x0E, 0x13, 0x2B, 0x17, 0x17, 0x17, 0x2B, 0x13, 0x0E, 0x11, 0x11,
        0x11, 0x11, 0x11, 0x0E, 0x13, 0x2B, 0x17, 0x17, 0x41, 0x5F, 0x13, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0E, 0x0D, 0x13, 0x0E, 0x4E, 0x6B, 0xDD, 0x8D, 0x16, 0x16, 0x56, 0x87, 0x62, 0x7D,
        0x0D, 0x0A, 0x0E, 0x89, 0x16, 0xD0, 0x13, 0x11, 0x11, 0x11, 0x10, 0x34, 0x33, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0C,
  0x0C, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x52, 0x2A, 0x3E, 0x10, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0E, 0x0D, 0x2B, 0x17, 0x17, 0x17, 0x2B, 0x0D, 0x11, 0x11,
        0x11, 0x11, 0x11, 0x0D, 0x2B, 0x17, 0x17, 0x1F, 0xB4, 0x13, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0D, 0x13, 0x11, 0x4E, 0x6B, 0x54, 0x3F, 0x16, 0x16, 0x8B, 0x85, 0x62, 0x7D, 0x0D, 0x13, 0x0E,
        0x11, 0x0D, 0xB9, 0x16, 0x8B, 0xC2, 0x0E, 0x11, 0x11, 0x11, 0x10, 0x34, 0x33, 0x10, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0C,
  0x0C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x52, 0x2A, 0x3E, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0x0D, 0x2B, 0x17, 0x17, 0x17, 0x2B, 0x0D, 0x11,
        0x10, 0x11, 0x0D, 0x2B, 0x17, 0x17, 0x1F, 0x77, 0x0D, 0x11, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 0xBA, 0xA6, 0xEA, 0x8D, 0x16, 0x16, 0x8A, 0x85, 0xD2, 0x7C, 0x0D, 0x0D, 0x0E, 0x11, 0x10, 0x10,
        0x10, 0x13, 0xA5, 0x16, 0xE5, 0x0D, 0x11, 0x10, 0x10, 0x10, 0x10, 0x34, 0x33, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0C,
  0x0C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x51, 0x2A, 0x3E, 0x0F, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0x0E, 0x99, 0xDB, 0x17, 0x17, 0x75, 0x13,
        0x11, 0x13, 0x75, 0x17, 0x17, 0xDB, 0x9B, 0x0D, 0x11, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0xC4, 0xE4, 0x3F, 0x16, 0x16, 0x8D, 0x42, 0xE1, 0x7D, 0x0D, 0x0D, 0x11, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
        0x10, 0x0E, 0x64, 0x16, 0x7E, 0x0D, 0x10, 0x10, 0x10, 0x10, 0x10, 0x34, 0x33, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0C,
  0x0C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x51, 0x2A, 0x3E, 0x0F, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0x10, 0x9C, 0x17, 0x17, 0x4B, 0x5A,
        0x0D, 0x5A, 0x4B, 0x17, 0x1F, 0x2B, 0x11, 0x11, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0xC5, 0x42, 0x16, 0x8D, 0xA4, 0x4E, 0xC3, 0x0D, 0x11, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
        0x0E, 0x78, 0x8C, 0xED, 0x73, 0x11, 0x10, 0x10, 0x10, 0x10, 0x0F, 0x34, 0x33, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0C,
  0x0C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x51, 0x2A, 0x3E, 0x0F, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0x0D, 0x35, 0x17, 0x17, 0x1F,
        0x68, 0x1F, 0x17, 0x1F, 0x77, 0x0D, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x11, 0xC7, 0xE7, 0x16, 0xDC, 0x7C, 0x0D, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
        0x0D, 0xA1, 0x16, 0x64, 0x0E, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0F, 0x34, 0x2F, 0x0F, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0C,
  0x0C, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x51, 0x2A, 0x3E, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x10, 0x0E, 0x35, 0x41, 0x1F,
        0x17, 0x1F, 0x4B, 0x77, 0x0E, 0x10, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0E, 0x79, 0x42, 0x16, 0xEB, 0x7D, 0x0E, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x10,
        0x11, 0x64, 0x16, 0x7E, 0x0D, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x22, 0x2F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0C,
  0x0C, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x50, 0x2A, 0x3E, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x10, 0x0D, 0x6A, 0xDB,
        0x1F, 0xDB, 0x6A, 0x0D, 0x10, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0E, 0x78, 0x42, 0x16, 0x54, 0x7C, 0x11, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x10,
        0x73, 0x8C, 0x3F, 0x78, 0x10, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x22, 0x2F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0C,
  0x0C, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x50, 0x2A, 0x2C, 0x09, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0E, 0x93, 0x4B, 0x1F,
        0x17, 0x1F, 0x41, 0x35, 0x0E, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0E, 0x4D, 0x21, 0x16, 0x54, 0x61, 0x11, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0E,
        0xD1, 0x16, 0xDD, 0x10, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x22, 0x2F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0C,
  0x0C, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x50, 0x2A, 0x2C, 0x09, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0E, 0x43, 0x1F, 0x17, 0x1F,
        0x68, 0x1F, 0x17, 0x17, 0x35, 0x11, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0E, 0xB9, 0x21, 0x16, 0x64, 0x61, 0x10, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x11,
        0xE3, 0x16, 0xA3, 0x0E, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x09, 0x22, 0x2F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0C,
  0x0C, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x09, 0x50, 0x2A, 0x2C, 0x09, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x11, 0x43, 0x1F, 0x17, 0x17, 0x35,
        0x0E, 0x35, 0x17, 0x17, 0x17, 0x35, 0x11, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x11, 0x4D, 0x65, 0x16, 0xE7, 0x73, 0x11, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x46,
        0x56, 0x16, 0x3D, 0x10, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x09, 0x22, 0x2F, 0x09, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0C,
  0x0C, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x50, 0x2A, 0x2C, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0F, 0x11, 0x43, 0x1F, 0x17, 0x17, 0x25, 0x10,
        0x0F, 0x10, 0x25, 0x17, 0x17, 0x17, 0x25, 0x10, 0x0F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x11, 0x4D, 0x21, 0x16, 0x16, 0x32, 0x73, 0x10, 0x09, 0x09, 0x09, 0x11, 0xCC,
        0x16, 0x89, 0x09, 0x0F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x22, 0x2F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0C,
  0x0C, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x50, 0x2A, 0x2C, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x43, 0x1F, 0x17, 0x17, 0x25, 0x10, 0x0F,
        0x09, 0x0F, 0x10, 0x25, 0x17, 0x17, 0x17, 0x25, 0x10, 0x0F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x11, 0x3D, 0x21, 0x16, 0x28, 0xE9, 0x16, 0x32, 0x31, 0x10, 0x09, 0x09, 0x10, 0xDF,
        0x16, 0x86, 0x11, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x22, 0x2F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0C,
  0x0C, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x50, 0x2A, 0x2C, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x11, 0x76, 0x1F, 0x17, 0x17, 0x25, 0x10, 0x0F, 0x09,
        0x09, 0x09, 0x0F, 0x10, 0x25, 0x17, 0x17, 0x17, 0x25, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x3D, 0x21, 0x16, 0x28, 0x0F, 0x46, 0x32, 0x16, 0x32, 0x31, 0x10, 0x0F, 0xC1, 0x65,
        0x16, 0xBB, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x22, 0x2F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0C,
  0x0C, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x50, 0x2A, 0x2C, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x5E, 0x41, 0x17, 0x17, 0x25, 0x10, 0x09, 0x09, 0x09,
        0x09, 0x09, 0x09, 0x09, 0x10, 0x25, 0x17, 0x17, 0x17, 0x25, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x3D, 0x21, 0x16, 0x28, 0xC3, 0x0F, 0x0F, 0x31, 0x32, 0x16, 0x32, 0x31, 0x0E, 0xCE, 0x16,
        0xEC, 0xC1, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x22, 0x2F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0C,
  0x0C, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x50, 0x2A, 0x2C, 0x04, 0x09, 0x09, 0x09, 0x09, 0x10, 0x5E, 0x41, 0x17, 0x17, 0x9A, 0x10, 0x09, 0x09, 0x09, 0x09,
        0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x25, 0x17, 0x17, 0x17, 0x25, 0x0F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x3D, 0x21, 0x16, 0x28, 0xC1, 0x0F, 0x09, 0x09, 0x0F, 0x31, 0x32, 0x16, 0x32, 0x46, 0x86, 0x16,
        0xDE, 0x10, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x04, 0x22, 0x2F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0C,
  0x0C, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x50, 0x2A, 0x2C, 0x04, 0x09, 0x09, 0x09, 0x0F, 0x5E, 0x69, 0x17, 0x17, 0x5B, 0x0F, 0x09, 0x09, 0x09, 0x09, 0x09,
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0F, 0x25, 0x17, 0x17, 0x17, 0x35, 0x0F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x10, 0x3D, 0x21, 0x16, 0x28, 0xC1, 0x0F, 0x09, 0x09, 0x09, 0x09, 0x0F, 0x31, 0x32, 0x16, 0x32, 0xEC, 0x16,
        0xCD, 0x0F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x04, 0x22, 0x2F, 0x04, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0C,
  0x0C, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x04, 0x09, 0x2A, 0x2C, 0x04, 0x09, 0x09, 0x0F, 0xAC, 0x1F, 0x17, 0x17, 0x5B, 0x0F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09,
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0F, 0x25, 0x17, 0x82, 0x94, 0x04, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0F, 0x3D, 0x21, 0x16, 0x28, 0xC1, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0F, 0x31, 0x32, 0x16, 0x16, 0x21,
        0x70, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x04, 0x22, 0x2F, 0x04, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0C,
  0x0C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x09, 0x2A, 0x2C, 0x04, 0x04, 0x04, 0x0F, 0x74, 0x1F, 0x17, 0x5B, 0x09, 0x09, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x09, 0x09, 0x35, 0x98, 0x35, 0x09, 0x09, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0F, 0x37, 0x21, 0x16, 0x28, 0xC1, 0x09, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0F, 0x31, 0x88, 0x16, 0xE2,
        0x0F, 0x09, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x22, 0x1E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0C,
  0x0C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xC1, 0x2A, 0x2C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x74, 0xB2, 0x09, 0x09, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x09, 0x04, 0x09, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0F, 0x37, 0x21, 0x16, 0x28, 0xC1, 0x09, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x09, 0xB8, 0xA2, 0x37,
        0x09, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x22, 0x1E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0C,
  0x0C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xC1, 0x1D, 0x2C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x09, 0x09, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x09, 0x37, 0x21, 0x16, 0x28, 0xC1, 0x09, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x09, 0x0F, 0x09,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x22, 0x1E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0C,
  0x0C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xC1, 0x1D, 0x2C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x09, 0x72, 0x21, 0x16, 0x28, 0xC1, 0x09, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x22, 0x1E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0C,
  0x0C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xC1, 0x1D, 0x2C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x09, 0x37, 0x55, 0x16, 0x28, 0xC1, 0x09, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x22, 0x1E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0C,
  0x0C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1D, 0x2D, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x09, 0x37, 0x21, 0x16, 0x28, 0x70, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x22, 0x1E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0C,
  0x0C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1D, 0x2D, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x09, 0x37, 0x21, 0x16, 0xE9, 0x70, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x22, 0x1E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0C,
  0x0C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x70, 0x1D, 0x2D, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x09, 0x37, 0x21, 0x16, 0x28, 0x31, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x22, 0x1E, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0C,
  0x0C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x70, 0x1D, 0x2D, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x09, 0x38, 0x21, 0x16, 0x28, 0x70, 0x04, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x22, 0x1E, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0C,
  0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x70, 0x1D, 0x2D, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x09, 0x38, 0x21, 0x16, 0x28, 0x70, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x23, 0x1E, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C,
  0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x70, 0x1D, 0x2D, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x38, 0x21, 0x16, 0x28, 0x70, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x23, 0x1E, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C,
  0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x70, 0x1D, 0x2D, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x38, 0x21, 0x16, 0x28, 0x70, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x23, 0x1E, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C,
  0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x1D, 0x2D, 0x03, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x38, 0x21, 0x16, 0x20, 0x70, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x71, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x03, 0x23, 0x1E, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C,
  0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x1D, 0x2D, 0x03, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x6F, 0x55, 0x16, 0x42, 0x6F, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xF6, 0xF8, 0x80, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x04, 0x71, 0xD5, 0x4C, 0x06, 0x06, 0x06, 0x06, 0x03, 0x23, 0x1E, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C,
  0x0C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x1D, 0x2D, 0x03, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0xB0, 0x63, 0x16, 0x42, 0xB7, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x4C, 0x15, 0x15, 0x91, 0x80, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x04, 0xB1, 0x57, 0x15, 0xF0, 0x06, 0x06, 0x06, 0x06, 0x03, 0x23, 0x1E, 0x03, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0C,
  0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x06, 0x1D, 0x2D, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x38, 0x55, 0x16, 0x20, 0x72, 0x04, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x06, 0x06, 0xAA, 0x15, 0x15, 0x90, 0xAB, 0x04, 0x06, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x04, 0x7A, 0x8F, 0x15, 0x15, 0xEF, 0x06, 0x06, 0x03, 0x03, 0x03, 0x23, 0x1E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0C,
  0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x06, 0x1D, 0x29, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x38, 0x26, 0x16, 0x20, 0x03, 0x06, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x06, 0x04, 0x30, 0x15, 0x15, 0x15, 0x30, 0x04, 0x06, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04,
        0x7A, 0x58, 0x15, 0x15, 0x57, 0xB1, 0x06, 0x03, 0x03, 0x03, 0x03, 0x23, 0x1E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0C,
  0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1D, 0x29, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x04, 0x38, 0x26, 0x16, 0x20, 0x03, 0x06, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x06, 0x06, 0x30, 0x15, 0x15, 0x15, 0x30, 0x06, 0x06, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x06, 0xBF,
        0x8E, 0x15, 0x15, 0x57, 0x6E, 0x06, 0x03, 0x03, 0x03, 0x03, 0x03, 0x23, 0x1E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0C,
  0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1D, 0x29, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x04, 0x36, 0x26, 0x16, 0x20, 0x03, 0x06, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x06, 0x30, 0x15, 0x15, 0x15, 0x30, 0x06, 0x03, 0x03, 0x03, 0x03, 0x03, 0x06, 0xBF, 0x59,
        0x15, 0x15, 0x57, 0x6E, 0x06, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x23, 0x1E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0C,
  0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1D, 0x29, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x06, 0x36, 0x26, 0x16, 0x20, 0x03, 0x06, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x06, 0x30, 0x15, 0x15, 0x15, 0x30, 0x06, 0x03, 0x03, 0x03, 0x06, 0xBF, 0x59, 0x15,
        0x15, 0x4A, 0x4C, 0x06, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x23, 0x1E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0C,
  0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1D, 0x29, 0x08, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x06, 0x36, 0x26, 0x16, 0x20, 0x03, 0x06, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x06, 0x30, 0x15, 0x15, 0x15, 0x30, 0x06, 0x03, 0x06, 0x4F, 0x59, 0x15, 0x15,
        0x4A, 0x3B, 0x06, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x23, 0x1E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0C,
  0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1D, 0x29, 0x08, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x06, 0x36, 0x26, 0x16, 0x20, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x06, 0x30, 0x15, 0x15, 0x15, 0x30, 0x04, 0xAE, 0x59, 0x15, 0x15, 0x4A,
        0x3B, 0x06, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x08, 0x23, 0x1E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0C,
  0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1D, 0x29, 0x08, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x06,
        0x36, 0x26, 0x16, 0x20, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x06, 0x30, 0x15, 0x15, 0x15, 0xF4, 0x8F, 0x15, 0x15, 0x4A, 0x3B,
        0x06, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x08, 0x23, 0x1E, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0C,
  0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1D, 0x29, 0x08, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x06, 0x36,
        0x26, 0x16, 0x20, 0x08, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x06, 0x30, 0x15, 0x15, 0x15, 0x15, 0x15, 0x4A, 0x3B, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x08, 0x23, 0x1E, 0x08, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0C,
  0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x08, 0x03, 0x1D, 0x29, 0x08, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x08, 0x08, 0x06, 0x36, 0x26,
        0x16, 0x20, 0x08, 0x03, 0x08, 0x08, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x08, 0x03, 0x06, 0xF3, 0x15, 0x15, 0x15, 0x58, 0x3B, 0x03, 0x08,
        0x08, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x08, 0x23, 0x27, 0x08, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0C,
  0x0C, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x03, 0x1D, 0x29, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x03, 0x36, 0x26, 0x16,
        0x20, 0x08, 0x03, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x03, 0x3B, 0x48, 0x15, 0x15, 0x15, 0x90, 0x30, 0x03, 0x03,
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x23, 0x27, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0C,
  0x0C, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x03, 0x1D, 0x29, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x03, 0x36, 0x26, 0x16, 0x20,
        0x08, 0x03, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x03, 0x3B, 0x49, 0x15, 0x15, 0xF7, 0x15, 0x15, 0x15, 0x24, 0x03,
        0x03, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x23, 0x27, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0C,
  0x0C, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1D, 0x29, 0x05, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x03, 0x3C, 0x26, 0x16, 0x20, 0x08,
        0x03, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x03, 0x44, 0x49, 0x15, 0x15, 0x40, 0x45, 0x30, 0x15, 0x15, 0x15, 0x24,
        0x03, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x05, 0x23, 0x27, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0C,
  0x0C, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1D, 0x29, 0x05, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x03, 0x3C, 0x26, 0x16, 0x20, 0x08, 0x03,
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x03, 0x44, 0x49, 0x15, 0x15, 0x40, 0x45, 0x03, 0x03, 0x24, 0x15, 0x15, 0x15,
        0x24, 0x03, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x05, 0x2E, 0x27, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0C,
  0x0C, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1D, 0x29, 0x05, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x03, 0x3C, 0x26, 0x16, 0x20, 0x08, 0x08, 0x08,
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x03, 0x44, 0x49, 0x15, 0x15, 0x40, 0x45, 0x03, 0x08, 0x08, 0x03, 0x24, 0x15, 0x15,
        0x15, 0x24, 0x03, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x05, 0x2E, 0x27, 0x05, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0C,
  0x0C, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x05, 0x08, 0x1D, 0x29, 0x05, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x03, 0x3C, 0x26, 0x16, 0x20, 0x08, 0x08, 0x08, 0x08,
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x44, 0x49, 0x15, 0x15, 0x40, 0x45, 0x03, 0x08, 0x08, 0x08, 0x08, 0x03, 0x24, 0x15,
        0x15, 0x15, 0x24, 0x03, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x05, 0x2E, 0x27, 0x05, 0x05, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0C,
  0x0C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x08, 0x1D, 0x29, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x03, 0x3C, 0x26, 0x16, 0x20, 0x05, 0x08, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x08, 0x5D, 0x48, 0x15, 0x15, 0x40, 0x45, 0x03, 0x05, 0x05, 0x05, 0x05, 0x05, 0x08, 0x03, 0x24,
        0x15, 0x15, 0x15, 0x24, 0x03, 0x08, 0x05, 0x05, 0x05, 0x05, 0x05, 0x2E, 0x27, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0C,
  0x0C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x08, 0x1D, 0x39, 0x05, 0x05, 0x05, 0x05, 0x05, 0x03, 0x3C, 0x26, 0x16, 0x20, 0x05, 0x08, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x08, 0x5D, 0x57, 0x15, 0x15, 0x40, 0x45, 0x08, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x08, 0x08,
        0x24, 0x15, 0x15, 0x15, 0x24, 0x08, 0x08, 0x05, 0x05, 0x05, 0x05, 0x2E, 0x27, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0C,
  0x0C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x1D, 0x39, 0x05, 0x05, 0x05, 0x05, 0x08, 0x3C, 0x26, 0x16, 0x20, 0x05, 0x08, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x08, 0x5D, 0x48, 0x15, 0x15, 0x58, 0x60, 0x08, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x08, 0xA9, 0x15, 0x15, 0x15, 0xA9, 0x08, 0x05, 0x05, 0x05, 0x05, 0x2E, 0x27, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0C,
  0x0C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0xFD, 0x39, 0x07, 0x05, 0x05, 0x08, 0xB6, 0x8A, 0x16, 0x83, 0x05, 0x08, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x44, 0x48, 0x15, 0x15, 0x58, 0xBE, 0x08, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x08, 0xA9, 0x15, 0x15, 0x15, 0x6C, 0x08, 0x05, 0x05, 0x05, 0x2E, 0x27, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0C,
  0x0C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0xFD, 0x39, 0x07, 0x05, 0x05, 0x08, 0xA0, 0x16, 0x83, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x08, 0xF1, 0x15, 0x15, 0x58, 0xBE, 0x08, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x08, 0xA9, 0x15, 0x15, 0xF5, 0x08, 0x05, 0x05, 0x07, 0x2E, 0x27, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0C,
  0x0C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0xFD, 0x39, 0x07, 0x05, 0x05, 0x05, 0x6D, 0x9F, 0x6D, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x08, 0xA8, 0x90, 0x40, 0xBE, 0x08, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x05, 0x05, 0x6C, 0xF2, 0xBD, 0x05, 0x05, 0x05, 0x07, 0x2E, 0x27, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0C,
  0x0C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0xFD, 0x39, 0x07, 0x05, 0x05, 0x05, 0x05, 0x08, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0xAD, 0x5D, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x05, 0x05, 0x08, 0x08, 0x05, 0x05, 0x05, 0x05, 0x07, 0x2E, 0x27, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0C,
  0x0C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0xFD, 0x39, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x2E, 0x27, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0C,
  0x0C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x05, 0xFD, 0x39, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x07, 0x2E, 0x27, 0x07, 0x07, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0C,
  0x0C, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x05, 0xFD, 0xD7, 0x02, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x02, 0x2E, 0x27, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x0C,
  0x0C, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x18, 0xFE, 0xFB, 0x81, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
        0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B,
        0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x1B, 0x81, 0xFC, 0x27, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x0C,
  0x0C, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0xFA, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
        0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19,
        0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0x19, 0xF9, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x0C,
  0x0C, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
        0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,
        0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x0C,
  0x0C, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x0C,
  0x0C, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x0C,
  0x0C, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x0C,
  0x0C, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x0C,
  0x0C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0C,
  0x0C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0C,
  0x0C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0C,
  0x0C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0C,
  0x0C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0C,
  0x0C, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0C,
  0x0C, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0C,
  0x0C, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14,
        0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x0C,
  0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C
};

GUI_CONST_STORAGE GUI_BITMAP bmGestures_120x100 = {
  120, // xSize
  100, // ySize
  120, // BytesPerLine
  8, // BitsPerPixel
  _acGestures_120x100,  // Pointer to picture data (indices)
  &_PalGestures_120x100   // Pointer to palette
};

/*********************************************************************
*
*       bmScratchPad_120x100
*/
static GUI_CONST_STORAGE GUI_COLOR _ColorsScratchPad_120x100[] = {
#if (GUI_USE_ARGB == 1)
  0xFFE9E9FC, 0xFF0000AE, 0xFF000096, 0xFF0000E8,
  0xFF0000D6, 0xFF0000C8, 0xFFFD0001, 0xFF00FE00,
  0xFF00FEFE, 0xFFFE00FE, 0xFFFEFE00, 0xFFFFFFFF,
  0xFF0000F0, 0xFFB30033, 0xFF0083F4, 0xFF4D00CF,
  0xFF8C004F, 0xFF69006A, 0xFF00B737, 0xFFE700F9,
  0xFF003192, 0xFF2D008C, 0xFFC80024, 0xFF00D4F9,
  0xFFB9B83A, 0xFF00E414, 0xFF00E5FB, 0xFFB700E9,
  0xFF8B00D9, 0xFF4A0089, 0xFFD500F5, 0xFF6B00D3,
  0xFF00C729, 0xFFE4E516, 0xFF4B0073, 0xFF6E0058,
  0xFF2E02AE, 0xFF1601C6, 0xFF004896, 0xFF008459,
  0xFF00C8F9, 0xFF009557, 0xFF00B6F3, 0xFF034F76,
  0xFF0019C7, 0xFF0048D6, 0xFF009B48, 0xFF00EB0D,
  0xFFD80019, 0xFF9600E9, 0xFFD3D324, 0xFF0028E8,
  0xFF0047F1, 0xFF0166E6, 0xFF008363, 0xFF00D81D,
  0xFF00D322, 0xFF0398E9, 0xFFA900EA, 0xFFE617FE,
  0xFFC4C432, 0xFF363594, 0xFF005688, 0xFF0055ED,
  0xFF0063F1, 0xFF0075F3, 0xFF545497, 0xFF8200E4,
  0xFF9B9956, 0xFF33007A, 0xFF00666A, 0xFF0019EA,
  0xFF0047E9, 0xFF4645A3, 0xFF656586, 0xFF00AA43,
  0xFF708F8F, 0xFF898864, 0xFFA9A947, 0xFFB7B741,
  0xFF737376, 0xFF002AA8, 0xFF002AB3, 0xFF2929A8,
  0xFF2B2BBC, 0xFF1515CA, 0xFF003AEB, 0xFF004784,
  0xFF0072E8, 0xFF4402E4, 0xFF0089EA, 0xFF0099F5,
  0xFF00AAF6, 0xFF18E4FE, 0xFFF92C05, 0xFFB900F4,
  0xFFC800F3, 0xFFF3E60A, 0xFF006377, 0xFF007869,
  0xFF007176, 0xFF63637A, 0xFF0338D9, 0xFF2D00D8,
  0xFF3800D6, 0xFF6400E6, 0xFF7500E4, 0xFF15FFEA,
  0xFF3AC5FF, 0xFFA40645, 0xFFC600EC, 0xFFC9CA2A,
  0xFFE9FC02, 0xFF0037A5, 0xFF3737B5, 0xFF1500E1,
  0xFF0528D6, 0xFF2900C1, 0xFF3900C8, 0xFF0058F2,
  0xFF4500BC, 0xFF4A4B8B, 0xFF464696, 0xFF00AA3B,
  0xFF2AFE00, 0xFF00A8EC, 0xFF36C9C9, 0xFF28D7FF,
  0xFF26FAD9, 0xFF36FDCB, 0xFF48B8FF, 0xFF46FCB9,
  0xFF54FCAB, 0xFF9C003A, 0xFFFB7503, 0xFF9768FF,
  0xFFC638FF, 0xFFFF00CE, 0xFF99944E, 0xFF808071,
  0xFF9AFF66, 0xFFF88805, 0xFFFFB300, 0xFFD6FF29,
  0xFFFDC601, 0xFF007D5C, 0xFF7A6C75, 0xFF3636A9,
  0xFF001ADA, 0xFF1300D6, 0xFF1416D3, 0xFF0063DA,
  0xFF4400F2, 0xFF5600E3, 0xFF56588B, 0xFF707080,
  0xFF008C4E, 0xFF16FE00, 0xFF4AFF00, 0xFF7DFF00,
  0xFF1CE3E3, 0xFF57AAFF, 0xFF629EFF, 0xFFB44B4B,
  0xFFCA3635, 0xFFF20058, 0xFFAA00F1, 0xFF8A53F7,
  0xFF8878FF, 0xFFFF0095, 0xFFD000EE, 0xFFD92BFF,
  0xFFFC1BE4, 0xFFFF7887, 0xFF919162, 0xFFA2FF00,
  0xFF8DFF73, 0xFFADFF52, 0xFFDEDE1C, 0xFFC8FF38,
  0xFFFEC53A, 0xFFEEEB0C, 0xFFE6FF19, 0xFFF7E51A,
  0xFF1D6175, 0xFF5F005F, 0xFF58587A, 0xFF687478,
  0xFF3227B7, 0xFF0020CD, 0xFF003BC7, 0xFF0038F0,
  0xFF2715CC, 0xFF006188, 0xFF1358E9, 0xFF4B3BB2,
  0xFF4F5588, 0xFF4052A4, 0xFF5C7297, 0xFF605A90,
  0xFF00BE2E, 0xFF008071, 0xFF00C233, 0xFF37C800,
  0xFF46BB00, 0xFF4F9C53, 0xFF749879, 0xFF40C300,
  0xFF4EC333, 0xFF76C230, 0xFF6AFF00, 0xFF1D9DEE,
  0xFF00B6EF, 0xFF13ACE2, 0xFF18B8F5, 0xFF38B9FD,
  0xFF1BCBE0, 0xFF29E6D5, 0xFF748CFF, 0xFF709DFF,
  0xFF67A8FF, 0xFF64FF9C, 0xFF7CFF83, 0xFFA42926,
  0xFF832067, 0xFFBD4400, 0xFF854859, 0xFFE20072,
  0xFF9E3AB8, 0xFFB83EBC, 0xFF8300F0, 0xFF9F00F0,
  0xFFA857FF, 0xFFB947FF, 0xFFFF00ED, 0xFFFF10F0,
  0xFFFF2ED1, 0xFFFF6B96, 0xFFABAB3F, 0xFF88885E,
  0xFF938154, 0xFF9FA84A, 0xFFA8995D, 0xFFBAFF00,
  0xFF98D15D, 0xFFA2FF60, 0xFFFF926E, 0xFFFF9070,
  0xFFE3AF4E, 0xFFC6DF3A, 0xFFD5C826, 0xFFCDFF00,
  0xFFECD10F, 0xFFECDE1C, 0xFFF6D529, 0xFF808180
#else
  0xFCE9E9, 0xAE0000, 0x960000, 0xE80000,
  0xD60000, 0xC80000, 0x0100FD, 0x00FE00,
  0xFEFE00, 0xFE00FE, 0x00FEFE, 0xFFFFFF,
  0xF00000, 0x3300B3, 0xF48300, 0xCF004D,
  0x4F008C, 0x6A0069, 0x37B700, 0xF900E7,
  0x923100, 0x8C002D, 0x2400C8, 0xF9D400,
  0x3AB8B9, 0x14E400, 0xFBE500, 0xE900B7,
  0xD9008B, 0x89004A, 0xF500D5, 0xD3006B,
  0x29C700, 0x16E5E4, 0x73004B, 0x58006E,
  0xAE022E, 0xC60116, 0x964800, 0x598400,
  0xF9C800, 0x579500, 0xF3B600, 0x764F03,
  0xC71900, 0xD64800, 0x489B00, 0x0DEB00,
  0x1900D8, 0xE90096, 0x24D3D3, 0xE82800,
  0xF14700, 0xE66601, 0x638300, 0x1DD800,
  0x22D300, 0xE99803, 0xEA00A9, 0xFE17E6,
  0x32C4C4, 0x943536, 0x885600, 0xED5500,
  0xF16300, 0xF37500, 0x975454, 0xE40082,
  0x56999B, 0x7A0033, 0x6A6600, 0xEA1900,
  0xE94700, 0xA34546, 0x866565, 0x43AA00,
  0x8F8F70, 0x648889, 0x47A9A9, 0x41B7B7,
  0x767373, 0xA82A00, 0xB32A00, 0xA82929,
  0xBC2B2B, 0xCA1515, 0xEB3A00, 0x844700,
  0xE87200, 0xE40244, 0xEA8900, 0xF59900,
  0xF6AA00, 0xFEE418, 0x052CF9, 0xF400B9,
  0xF300C8, 0x0AE6F3, 0x776300, 0x697800,
  0x767100, 0x7A6363, 0xD93803, 0xD8002D,
  0xD60038, 0xE60064, 0xE40075, 0xEAFF15,
  0xFFC53A, 0x4506A4, 0xEC00C6, 0x2ACAC9,
  0x02FCE9, 0xA53700, 0xB53737, 0xE10015,
  0xD62805, 0xC10029, 0xC80039, 0xF25800,
  0xBC0045, 0x8B4B4A, 0x964646, 0x3BAA00,
  0x00FE2A, 0xECA800, 0xC9C936, 0xFFD728,
  0xD9FA26, 0xCBFD36, 0xFFB848, 0xB9FC46,
  0xABFC54, 0x3A009C, 0x0375FB, 0xFF6897,
  0xFF38C6, 0xCE00FF, 0x4E9499, 0x718080,
  0x66FF9A, 0x0588F8, 0x00B3FF, 0x29FFD6,
  0x01C6FD, 0x5C7D00, 0x756C7A, 0xA93636,
  0xDA1A00, 0xD60013, 0xD31614, 0xDA6300,
  0xF20044, 0xE30056, 0x8B5856, 0x807070,
  0x4E8C00, 0x00FE16, 0x00FF4A, 0x00FF7D,
  0xE3E31C, 0xFFAA57, 0xFF9E62, 0x4B4BB4,
  0x3536CA, 0x5800F2, 0xF100AA, 0xF7538A,
  0xFF7888, 0x9500FF, 0xEE00D0, 0xFF2BD9,
  0xE41BFC, 0x8778FF, 0x629191, 0x00FFA2,
  0x73FF8D, 0x52FFAD, 0x1CDEDE, 0x38FFC8,
  0x3AC5FE, 0x0CEBEE, 0x19FFE6, 0x1AE5F7,
  0x75611D, 0x5F005F, 0x7A5858, 0x787468,
  0xB72732, 0xCD2000, 0xC73B00, 0xF03800,
  0xCC1527, 0x886100, 0xE95813, 0xB23B4B,
  0x88554F, 0xA45240, 0x97725C, 0x905A60,
  0x2EBE00, 0x718000, 0x33C200, 0x00C837,
  0x00BB46, 0x539C4F, 0x799874, 0x00C340,
  0x33C34E, 0x30C276, 0x00FF6A, 0xEE9D1D,
  0xEFB600, 0xE2AC13, 0xF5B818, 0xFDB938,
  0xE0CB1B, 0xD5E629, 0xFF8C74, 0xFF9D70,
  0xFFA867, 0x9CFF64, 0x83FF7C, 0x2629A4,
  0x672083, 0x0044BD, 0x594885, 0x7200E2,
  0xB83A9E, 0xBC3EB8, 0xF00083, 0xF0009F,
  0xFF57A8, 0xFF47B9, 0xED00FF, 0xF010FF,
  0xD12EFF, 0x966BFF, 0x3FABAB, 0x5E8888,
  0x548193, 0x4AA89F, 0x5D99A8, 0x00FFBA,
  0x5DD198, 0x60FFA2, 0x6E92FF, 0x7090FF,
  0x4EAFE3, 0x3ADFC6, 0x26C8D5, 0x00FFCD,
  0x0FD1EC, 0x1CDEEC, 0x29D5F6, 0x808180
#endif
};

static GUI_CONST_STORAGE GUI_LOGPALETTE _PalScratchPad_120x100 = {
  256,  // Number of entries
  0,    // No transparency
  &_ColorsScratchPad_120x100[0]
};

static GUI_CONST_STORAGE unsigned char _acScratchPad_120x100[] = {
  0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B,
        0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B,
        0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B,
  0x0B, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0B,
  0x0B, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0B,
  0x0B, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0B,
  0x0B, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0B,
  0x0B, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0B,
  0x0B, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
        0x0C, 0x0C, 0x0C, 0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0C, 0x47, 0x34, 0x34, 0x34, 0x77, 0x0E, 0x0E, 0x0E, 0x0E, 0x77, 0x34, 0x34, 0x34, 0x34, 0x47, 0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C,
        0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0B,
  0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x47, 0x34, 0x40, 0x0E, 0x2A, 0x17, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1A, 0x17, 0x5C, 0x0E, 0x77, 0xBF, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0B,
  0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0xBF, 0x40, 0x5B, 0x28, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1A, 0x0E, 0xBF, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0B,
  0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33,
        0x0E, 0x17, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x28, 0x41, 0x33, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0B,
  0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x41, 0x28, 0x08,
        0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x5C, 0x40, 0x47,
        0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0B,
  0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x34, 0x0E, 0x3F, 0x47, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x3F, 0x5C, 0x08, 0x08, 0x08, 0x08,
        0x80, 0x8C, 0xB1, 0xDE, 0x80, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1A, 0x17, 0x2A, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x0E, 0x2A, 0x17, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1A,
        0x40, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0B,
  0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x41, 0x08, 0x08, 0x08, 0x1A, 0x5B, 0x56, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x41, 0x17, 0x08, 0x08, 0x08, 0x08, 0x08, 0x6B,
        0x8F, 0x0A, 0x0A, 0x0A, 0x0A, 0xB1, 0x84, 0x39, 0x41, 0x40, 0x48, 0x47, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x47, 0x34, 0x41, 0x5B, 0x1A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
        0x08, 0x40, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0B,
  0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x17, 0x41, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x48, 0x17, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x83,
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xFA, 0x92, 0x03, 0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x47, 0x3F, 0x5C, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
        0x08, 0x28, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0B,
  0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x1A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x17, 0x77, 0x33, 0x03, 0x47, 0x40, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xD9,
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x4F, 0x72, 0x03, 0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x5B, 0x17, 0x08, 0x08, 0x08, 0x08,
        0x08, 0x5B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0B,
  0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x3F, 0x1A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x5B, 0x17, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x28, 0x40, 0x47,
        0x42, 0xB2, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x4F, 0x54, 0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0C, 0x0C, 0x0C, 0x03, 0x03, 0x03, 0x94, 0x66, 0x39, 0x80, 0x83,
        0xD5, 0x74, 0x96, 0x96, 0x03, 0x0C, 0x0C, 0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0B,
  0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x33, 0x41, 0x28, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1A, 0x5B, 0x56, 0x03, 0x03, 0x03,
        0x0C, 0x96, 0x4A, 0x3C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xAE, 0x96, 0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0C, 0x03, 0x95, 0x96, 0x54, 0x49, 0x9B, 0xAE, 0x4F, 0x4F, 0x4F, 0x32, 0x61, 0x61, 0x0A, 0x0A,
        0x61, 0xB5, 0xB5, 0xB5, 0x18, 0xAE, 0x4A, 0x49, 0x72, 0x04, 0x0C, 0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0B,
  0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x56, 0x5A, 0x17, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0E, 0x47, 0x03, 0x04, 0x03, 0x03, 0x03,
        0x03, 0x03, 0x0C, 0x73, 0xC3, 0xF2, 0xB7, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x6F, 0x72, 0x0C, 0x03, 0x03, 0x03, 0x03, 0x0C, 0x03, 0x95, 0x54, 0x4A, 0x4E, 0xB2, 0xB5, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x32, 0xAE, 0x42, 0x96, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0B,
  0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x03, 0x3F, 0x17, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x1A, 0x40, 0x73, 0x59, 0x59, 0x69, 0xE6, 0x5F,
        0x5F, 0x5F, 0x1E, 0x13, 0x13, 0x13, 0xAC, 0xAD, 0xB7, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xB5, 0x9B, 0x03, 0x0C, 0x03, 0x96, 0x42, 0x44, 0xB2, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xB2, 0x42, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0B,
  0x0B, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x03, 0x17, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xD7, 0x88, 0x09, 0x09, 0x09, 0x09,
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0xAC, 0xF7, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x4E, 0x42, 0xAE, 0xB2, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A,
        0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xB5, 0x55, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x0B,
  0x0B, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x33, 0x28, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xA8, 0x09, 0x09, 0x09,
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0xEC, 0xB4, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xB5, 0xB5, 0xB5, 0x32, 0x4F, 0x4F, 0x4F,
        0x4F, 0x4F, 0x3C, 0xB5, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x49, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0B,
  0x0B, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x33, 0x1A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x7F, 0x87, 0x6C, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x82, 0x3B, 0x09,
        0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0xEB, 0xF6, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x21, 0x3C, 0x4F, 0x44, 0x8B, 0x9A, 0x49, 0x55, 0x96, 0x96, 0x04, 0x03, 0x04, 0x04,
        0x04, 0x03, 0x04, 0x55, 0x49, 0x9B, 0x8B, 0x44, 0x32, 0x0A, 0x0A, 0x0A, 0x0A, 0x32, 0x95, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0B,
  0x0B, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x5C, 0x08, 0x08, 0x08, 0x08, 0x08, 0x6C, 0x3B, 0x09, 0x09, 0xA8, 0x5D, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x5D, 0xE8,
        0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x09, 0x09, 0x09, 0x09, 0xAD, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xB5, 0x3C, 0x8B, 0x49, 0x73, 0x03, 0x03, 0x03, 0x0C, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x03, 0x03, 0x03, 0x0C, 0x03, 0x04, 0x54, 0x50, 0x4F, 0x44, 0x54, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0B,
  0x0B, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x48, 0x08, 0x08, 0x08, 0x08, 0x08, 0x6C, 0x3B, 0x09, 0x09, 0x09, 0x09, 0xAB, 0xDC, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
        0xC2, 0x95, 0x73, 0x73, 0x73, 0x73, 0x73, 0x95, 0x73, 0x98, 0xE4, 0xB4, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x4A, 0x03, 0x0C, 0x2C, 0x64, 0xC1, 0x04, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x04, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0B,
  0x0B, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x17, 0x08, 0x08, 0x08, 0x08, 0x7F, 0x3B, 0x09, 0x09, 0x09, 0x09, 0x09, 0x1E, 0x31, 0xC2, 0x1A, 0x08, 0x08, 0x08, 0x08, 0x08,
        0x08, 0x35, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0xBB, 0x70, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x21, 0xC7, 0x2C, 0x37, 0x07, 0x07, 0x38, 0xC9, 0x2C, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0B,
  0x0B, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x59, 0xA7, 0x08, 0x08, 0x08, 0x08, 0x08, 0xE9, 0x09, 0x09, 0x09, 0x1E, 0xE6, 0x67, 0x04, 0x04, 0x04, 0x94, 0x2A, 0x08, 0x08, 0x08, 0x08,
        0x08, 0x08, 0x58, 0x04, 0x04, 0x04, 0x03, 0x04, 0x44, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xF8, 0xED, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xD0, 0x07, 0x07, 0x07, 0x07, 0x07, 0x2F, 0x29, 0x71, 0x04, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0B,
  0x0B, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x99, 0x13, 0xDB, 0x08, 0x08, 0x08, 0x08, 0xA1, 0x09, 0x09, 0xE7, 0x59, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x58, 0x08, 0x08, 0x08,
        0x08, 0x08, 0x08, 0x0E, 0x04, 0x04, 0x55, 0x3C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x4A, 0x73, 0x98, 0xE5, 0xFE, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xAF, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x12, 0x26, 0x04, 0x03, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0B,
  0x0B, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x95, 0xE7, 0x09, 0x09, 0x5D, 0x08, 0x08, 0x08, 0x08, 0x88, 0xE7, 0x67, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x35, 0x08, 0x08,
        0x08, 0x08, 0x08, 0x08, 0x48, 0x03, 0x4D, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x3C, 0x93, 0x03, 0x04, 0x04, 0x03, 0xC0, 0x3C, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x9E, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x12, 0x26, 0x03, 0x04, 0x04,
        0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0B,
  0x0B, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x95, 0xA6, 0x09, 0x09, 0xAB, 0x08, 0x08, 0x08, 0x08, 0x5D, 0x59, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x5A, 0x08,
        0x08, 0x08, 0x08, 0x08, 0x17, 0xC5, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x18, 0x04, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x18, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xD2, 0x9D, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x29, 0x2C, 0x04,
        0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0B,
  0x0B, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x69, 0x1E, 0x09, 0x09, 0x09, 0x87, 0x08, 0x08, 0x08, 0x08, 0x2A, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x5A,
        0x08, 0x08, 0x08, 0x08, 0x08, 0x83, 0x0A, 0x0A, 0x0A, 0x0A, 0xB2, 0x42, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x50, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x70, 0xCD, 0x36, 0x2F, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x2F, 0x12,
        0x26, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0B,
  0x0B, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x31, 0x09, 0x09, 0x09, 0x09, 0x09, 0xA2, 0x08, 0x08, 0x08, 0x08, 0x39, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x2A, 0x08, 0x08, 0x08, 0x08, 0x08, 0xB0, 0x0A, 0x0A, 0x0A, 0x9A, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x4A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xFD, 0xBC, 0x2C, 0x29, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
        0x07, 0x12, 0x52, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0B,
  0x0B, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x69, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x82, 0x08, 0x08, 0x08, 0x08, 0x35, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x94, 0x17, 0x08, 0x08, 0x08, 0x08, 0x6B, 0x8F, 0x0A, 0x18, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x50, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x6F, 0x55, 0x03, 0x52, 0x29, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07,
        0x07, 0x07, 0x07, 0x29, 0x52, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0B,
  0x0B, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x99, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0xA6, 0xD6, 0x08, 0x08, 0x08, 0x08, 0x2D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x66, 0x08, 0x08, 0x08, 0x08, 0x08, 0xDD, 0x0A, 0x53, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x4E, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x4D, 0x04, 0x04, 0x04, 0x52, 0x29, 0x2F, 0x07, 0x07, 0x07,
        0x07, 0x07, 0x07, 0x07, 0x19, 0x64, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0B,
  0x0B, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x68, 0x13, 0x09, 0x09, 0x09, 0x09, 0x13, 0x6A, 0x04, 0x2A, 0x08, 0x08, 0x08, 0x08, 0x2D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x05, 0x58, 0x08, 0x08, 0x08, 0x08, 0x6B, 0xCE, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x55, 0x6F, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x7A, 0x04, 0x04, 0x04, 0x04, 0x2C, 0x64, 0x19, 0x07,
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x12, 0x2C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0B,
  0x0B, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x95, 0x1E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x69, 0x05, 0x04, 0x2A, 0x08, 0x08, 0x08, 0x08, 0x2D, 0x05, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x04, 0x9A, 0x81, 0x08, 0x08, 0x08, 0x08, 0x2D, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x93, 0xB5, 0x0A, 0x0A, 0x0A, 0x0A, 0x18, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x2C, 0x29,
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x19, 0x3E, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0B,
  0x0B, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x05, 0x05, 0x31, 0x09, 0x09, 0x09, 0x09, 0x09, 0x6A, 0x05, 0x04, 0x04, 0x2A, 0x08, 0x08, 0x08, 0x08, 0x58, 0x05, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x04, 0x03, 0xF0, 0x8C, 0x08, 0x08, 0x08, 0x08, 0x5A, 0x05, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x65, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x7A, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
        0x52, 0xCA, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x29, 0x2C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0B,
  0x0B, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x95, 0x99, 0x09, 0x09, 0x09, 0x09, 0x09, 0x5F, 0x05, 0x05, 0x05, 0x05, 0x39, 0x08, 0x08, 0x08, 0x08, 0x39, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x04, 0x04, 0x8A, 0xB3, 0x08, 0x08, 0x08, 0x08, 0x17, 0x04, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x04, 0x04, 0x18, 0x0A, 0x0A, 0x0A, 0x0A, 0x44, 0x04, 0x04, 0x05, 0x05, 0x05, 0x05, 0x04,
        0x04, 0x2C, 0x29, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x38, 0x71, 0x03, 0x04, 0x05, 0x52, 0x26, 0x26, 0x26, 0x63, 0x3E, 0x26, 0x26, 0x2C, 0x2C, 0x2C, 0x2C, 0x05, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0B,
  0x0B, 0x05, 0x05, 0x05, 0x05, 0x05, 0x43, 0x13, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x68, 0x05, 0x05, 0x05, 0x05, 0x35, 0x08, 0x08, 0x08, 0x08, 0x7D, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x04, 0x05, 0x18, 0x0A, 0x6B, 0x08, 0x08, 0x08, 0x08, 0x74, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x04, 0x7A, 0x0A, 0x0A, 0x0A, 0x0A, 0x32, 0x05, 0x04, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x04, 0x04, 0x26, 0x19, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x19, 0x36, 0x4B, 0x38, 0x2F, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x2F, 0x2F, 0x2F, 0x2F, 0x20, 0x12, 0x4B, 0x36, 0x64, 0x26, 0x51, 0x2C, 0x05, 0x0B,
  0x0B, 0x05, 0x05, 0x05, 0x05, 0x59, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x6A, 0x05, 0x05, 0x05, 0x05, 0x05, 0x66, 0x08, 0x08, 0x08, 0x08, 0x17, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x18, 0x0A, 0x84, 0x08, 0x08, 0x08, 0x08, 0x35, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x04, 0x05, 0x21, 0x0A, 0x0A, 0x0A, 0x0A, 0x53, 0x04, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x04, 0x03, 0x52, 0x12, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x2F, 0x20, 0x0B,
  0x0B, 0x05, 0x05, 0x05, 0x05, 0x43, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0xE7, 0x67, 0x05, 0x05, 0x05, 0x05, 0x05, 0x1A, 0x08, 0x08, 0x08, 0x08, 0x74, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x18, 0x0A, 0xB0, 0x08, 0x08, 0x08, 0x08, 0xD4, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x04, 0xEE, 0x0A, 0x0A, 0x0A, 0x0A, 0x50, 0x04, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x04, 0x05, 0x71, 0x29, 0xCA, 0x2F, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x0B,
  0x0B, 0x05, 0x05, 0x05, 0x05, 0x67, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x3A, 0x68, 0x05, 0x05, 0x05, 0x7D, 0x08, 0x08, 0x08, 0x08, 0x39, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x18, 0x0A, 0xB3, 0x08, 0x08, 0x08, 0x08, 0x1A, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x04, 0x65, 0x0A, 0x0A, 0x0A, 0x0A, 0x4E, 0x04, 0x05, 0x05, 0x05, 0x04, 0x05,
        0x26, 0xCA, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x0B,
  0x0B, 0x05, 0x05, 0x05, 0x05, 0x05, 0x5F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x43, 0x25, 0x05, 0x58, 0x08, 0x08, 0x08, 0x08, 0x1A, 0x2C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x18, 0x0A, 0x70, 0x6B, 0x08, 0x08, 0x08, 0x1A, 0x2C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x04, 0x53, 0x0A, 0x0A, 0x0A, 0x0A, 0x21, 0x55, 0x05, 0x04, 0x04, 0x3E, 0x12,
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x36, 0x63, 0x36, 0x36, 0x36, 0x12, 0x12, 0x12, 0x12, 0x19, 0x2F, 0x2F, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x0B,
  0x0B, 0x05, 0x05, 0x05, 0x05, 0x25, 0x13, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x1E, 0x0F, 0xBD, 0x08, 0x08, 0x08, 0x08, 0x08, 0x97, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x04, 0xEF, 0x0A, 0xB6, 0x6B, 0x08, 0x08, 0x08, 0x1A, 0x2C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x04, 0x04, 0x04, 0x04, 0x05, 0x32, 0x0A, 0x0A, 0x0A, 0x0A, 0x79, 0x04, 0x2C, 0x4B, 0x07, 0x07,
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x2F, 0x2F, 0x20, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x27, 0x04, 0x04, 0x04, 0x04, 0x05, 0x05, 0x05, 0x05, 0x05, 0x2C, 0x52, 0x26, 0x3E, 0x36, 0x2E, 0x12, 0x19, 0x2F, 0x0B,
  0x0B, 0x05, 0x05, 0x05, 0x05, 0x69, 0x09, 0x09, 0x09, 0x09, 0x1E, 0x5F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x3A, 0xD3, 0x08, 0x08, 0x08, 0x08, 0x1A, 0xBD, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x04, 0x65, 0x0A, 0xF5, 0x08, 0x08, 0x08, 0x08, 0x28, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x04, 0x04, 0x04, 0x05, 0x25, 0x25, 0x25, 0x1D, 0x1D, 0x1D, 0x1D, 0x25, 0x8A, 0x0A, 0x0A, 0x0A, 0x0A, 0x92, 0x51, 0x37, 0x07, 0x07, 0x07,
        0x07, 0x07, 0x07, 0x07, 0x07, 0x38, 0x29, 0x3E, 0x52, 0x2C, 0x05, 0x2E, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x62, 0x04, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x04, 0x04, 0x04, 0x05, 0x05, 0x05, 0x2C, 0x0B,
  0x0B, 0x05, 0x05, 0x05, 0x05, 0xA6, 0x09, 0x09, 0x09, 0x09, 0x43, 0x05, 0x0F, 0x5F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x3B, 0x82, 0x08, 0x08, 0x08, 0x08, 0xD4, 0x05, 0x05, 0x05, 0x05, 0x04, 0x04, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x3D, 0x0A, 0x84, 0x08, 0x08, 0x08, 0x08, 0x5A, 0x05, 0x05, 0x05, 0x05, 0x04, 0x04, 0x05, 0x25, 0x1D, 0x1D, 0x10, 0x0D, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x86, 0x0A, 0x0A, 0x0A, 0x0A, 0xD1, 0x19, 0x07, 0x07, 0x07, 0x07,
        0x07, 0x07, 0x07, 0x4B, 0x3E, 0x05, 0x04, 0x04, 0x05, 0x05, 0x05, 0x05, 0x29, 0x07, 0x07, 0x07, 0x07, 0x07, 0x2F, 0x71, 0x04, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0B,
  0x0B, 0x05, 0x05, 0x05, 0x25, 0x09, 0x09, 0x09, 0x09, 0x09, 0x68, 0x05, 0x05, 0x05, 0x99, 0x1E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0xDA, 0x08, 0x08, 0x08, 0x08, 0x39, 0x05, 0x05, 0x24, 0x11, 0x11, 0x15, 0x05, 0x05, 0x04, 0x05, 0x05, 0x05, 0x05,
        0x05, 0x05, 0x25, 0xF4, 0x6B, 0x08, 0x08, 0x08, 0x08, 0x66, 0x05, 0x05, 0x05, 0x25, 0x1D, 0x10, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x8D, 0x0A, 0x0A, 0x0A, 0x0A, 0x9F, 0x07, 0x07, 0x07, 0x07, 0x07,
        0x07, 0x4B, 0x51, 0x05, 0x04, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x62, 0x07, 0x07, 0x07, 0x07, 0x07, 0x38, 0x2C, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0B,
  0x0B, 0x05, 0x05, 0x05, 0x0F, 0x09, 0x09, 0x09, 0x09, 0x1E, 0x05, 0x05, 0x05, 0x05, 0x05, 0x25, 0x31, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x87, 0x5D, 0x08, 0x08, 0x08, 0xD4, 0x54, 0x30, 0x06, 0x06, 0x06, 0x30, 0x6D, 0x1D, 0x25, 0x05, 0x04, 0x05,
        0x05, 0x05, 0x2C, 0x17, 0x08, 0x08, 0x08, 0x08, 0x81, 0xC4, 0x04, 0x24, 0x6D, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x90, 0x0A, 0x0A, 0x0A, 0x0A, 0x9E, 0x07, 0x07, 0x07, 0x07, 0x19,
        0x3E, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x04, 0x63, 0x07, 0x07, 0x07, 0x07, 0x07, 0x2E, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0B,
  0x0B, 0x05, 0x05, 0x05, 0x1F, 0x09, 0x09, 0x09, 0x09, 0x1B, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x76, 0x60, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x3B, 0x6C, 0x08, 0x08, 0x08, 0x4C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x30, 0x6D, 0x11, 0x24,
        0x05, 0xBD, 0x7D, 0x08, 0x08, 0x08, 0x08, 0x08, 0xF5, 0xB5, 0x6D, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x5E, 0x0A, 0x0A, 0x0A, 0x0A, 0x70, 0x9D, 0x07, 0x07, 0x07, 0xCF, 0xDF,
        0x24, 0x04, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x4B, 0x07, 0x07, 0x07, 0x07, 0x07, 0x62, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0B,
  0x0B, 0x05, 0x05, 0x05, 0x43, 0x09, 0x09, 0x09, 0x09, 0x31, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x25, 0x3A, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x3B, 0xA1, 0x08, 0x08, 0x4C, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
        0xE0, 0xD8, 0x08, 0x08, 0x08, 0x08, 0x08, 0x81, 0xB6, 0x0A, 0x8E, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0x0D, 0x0D, 0x0D, 0x0D, 0x0D, 0x8D, 0x0A, 0x0A, 0x0A, 0x0A, 0xF3, 0x07, 0x07, 0x07, 0xCB, 0x06, 0x06,
        0x06, 0x10, 0x25, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x2C, 0x37, 0x07, 0x07, 0x07, 0x07, 0x2F, 0x14, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0B,
  0x0B, 0x05, 0x05, 0x05, 0x3A, 0x09, 0x09, 0x09, 0x09, 0x6A, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x43, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0xA2, 0x08, 0x08, 0xA3, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x5E, 0xFF, 0xA0, 0x08, 0x08, 0x6B, 0x8F, 0x0A, 0x0A, 0x0A, 0x86, 0x06, 0x06, 0x06, 0x06, 0x06, 0x30, 0x0D, 0x6D, 0x11, 0x1D, 0x25, 0x05, 0x05, 0x05, 0x05, 0x05, 0x53, 0x21, 0x0A, 0x0A, 0x0A, 0x0A, 0x9F, 0x07, 0x07, 0x07, 0xE1, 0x06, 0x06,
        0x06, 0x06, 0x0D, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0xCA, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0B,
  0x0B, 0x05, 0x05, 0x05, 0x1B, 0x09, 0x09, 0x09, 0x09, 0x0F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0F, 0x13, 0x09, 0x09, 0x09, 0x09, 0x09, 0x3B, 0x7F, 0x08, 0x08, 0x7E, 0x4C, 0xA4, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x30, 0xFF, 0x7E, 0xF9, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x86, 0x06, 0x0D, 0x11, 0x24, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x79, 0x32, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x7C, 0x07, 0x07, 0xCC, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x1D, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x63, 0x07, 0x07, 0x07, 0x07, 0x07, 0x57, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0B,
  0x0B, 0x05, 0x05, 0x05, 0x1E, 0x09, 0x09, 0x09, 0x09, 0x0F, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x25, 0x6E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x88, 0x08, 0x08, 0x08, 0x08, 0x08, 0xD9, 0x4C, 0xA3, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x5E, 0x61, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xFC, 0x79, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x53, 0x4E, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xAF, 0x07, 0x07, 0x07, 0xB8, 0x6D, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x1D, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x37, 0x07, 0x07, 0x07, 0x07, 0x12, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0B,
  0x0B, 0x05, 0x05, 0x25, 0x09, 0x09, 0x09, 0x09, 0x13, 0x25, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x05, 0x31, 0x09, 0x09, 0x09, 0x09, 0x09, 0xA7, 0x17, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xA0, 0x4C, 0xA4, 0x06,
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x5E, 0x8E, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x32, 0xEF, 0x3D, 0x01, 0x01, 0x01, 0x01, 0x53, 0x65, 0xEE, 0xB5, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xFB, 0x7C, 0x07, 0x07, 0x2F, 0x01, 0x05, 0x1D, 0x30,
        0x06, 0x06, 0x0D, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x62, 0x07, 0x07, 0x07, 0x07, 0x07, 0x51, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0B,
  0x0B, 0x05, 0x05, 0x25, 0x09, 0x09, 0x09, 0x09, 0x13, 0x25, 0x01, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x05, 0x1B, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0F, 0xBE, 0x39, 0x1A, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xC6,
        0x30, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x8D, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0xB5, 0xB5, 0xB5, 0xB5, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x70, 0x7C, 0x07, 0x07, 0x07, 0x38, 0x01, 0x05, 0x05, 0x24,
        0x11, 0x11, 0x01, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x37, 0x07, 0x07, 0x07, 0x07, 0x91, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0B,
  0x0B, 0x05, 0x01, 0x05, 0x1E, 0x09, 0x09, 0x09, 0x09, 0x0F, 0x01, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x25, 0x13, 0x09, 0x09, 0x09, 0x09, 0x13, 0x75, 0x01, 0x2C, 0x2D, 0x2D, 0x2D, 0x97, 0x2D, 0x2D, 0x53,
        0x30, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x5E, 0x90, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x8A, 0xB8, 0x07, 0x07, 0x07, 0x07, 0x20, 0x01, 0x05, 0x01, 0x05,
        0x05, 0x05, 0x05, 0x01, 0x01, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x9C, 0x07, 0x07, 0x07, 0x07, 0x37, 0x01, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x1B, 0x09, 0x09, 0x09, 0x09, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x60, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x15, 0x30,
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x8E, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x6F, 0x3D, 0x05, 0x51, 0x2F, 0x07, 0x07, 0x07, 0x2F, 0x01, 0x05, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x14, 0x07, 0x07, 0x07, 0x07, 0x07, 0x57, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x1B, 0x09, 0x09, 0x09, 0x09, 0x1F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x31, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05, 0x16, 0x06,
        0x06, 0x06, 0x06, 0x06, 0x16, 0x30, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x5E, 0x90, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x0A, 0x21, 0x8A, 0x01, 0x05, 0x05, 0x01, 0x2F, 0x07, 0x07, 0x07, 0x2F, 0x51, 0x05, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x01, 0x37, 0x07, 0x07, 0x07, 0x07, 0x9C, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x1C, 0x09, 0x09, 0x09, 0x09, 0x1C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x25, 0x1E, 0x09, 0x09, 0x09, 0x09, 0x1B, 0x01, 0x01, 0x01, 0x01, 0x05, 0x11, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x30, 0x01, 0x24, 0x0D, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x30, 0xE2, 0xF1, 0x6F, 0xB5, 0x0A, 0x0A, 0x0A, 0x0A, 0xB5, 0xB2, 0x18, 0xBA, 0x01, 0x05, 0x05, 0x01, 0x05, 0x01, 0x19, 0x07, 0x07, 0x07, 0x07, 0x46, 0x05, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x91, 0x07, 0x07, 0x07, 0x07, 0x38, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x1F, 0x09, 0x09, 0x09, 0x09, 0x6E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0F, 0x01, 0x01, 0x05, 0x1D, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x16, 0x24, 0x05, 0x05, 0x01, 0x1D, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x10, 0x01, 0x01, 0x3D, 0x3D, 0x3D, 0x3D, 0x53, 0x01, 0x01, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x2E, 0x07, 0x07, 0x07, 0x07, 0x19, 0x51, 0x05, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x51, 0x2F, 0x07, 0x07, 0x07, 0x07, 0x14, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x76, 0x09, 0x09, 0x09, 0x09, 0x13, 0x25, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1B, 0x09, 0x09, 0x09, 0x09, 0x1B, 0x01, 0x01, 0x01, 0x30, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x15, 0x05, 0x01, 0x01, 0x01, 0x05, 0x01, 0x10, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x10, 0x05, 0x05, 0x05, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x51, 0x2F, 0x07, 0x07, 0x07, 0x07, 0x91, 0x05, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xC8, 0x07, 0x07, 0x07, 0x07, 0x57, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x25, 0x13, 0x09, 0x09, 0x09, 0x09, 0x76, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x75, 0x05, 0x10, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x23, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x11, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x10, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x91, 0x07, 0x07, 0x07, 0x07, 0x2F, 0x14, 0x05,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0x07, 0x07, 0x07, 0x07, 0x57, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x01, 0x1B, 0x09, 0x09, 0x09, 0x09, 0x1F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1E, 0x09, 0x09, 0x09, 0x09, 0x6A, 0x01, 0x30, 0x06, 0x06, 0x06, 0x06,
        0x6D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x1D, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x51, 0x2F, 0x07, 0x07, 0x07, 0x07, 0x38, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x20, 0x07, 0x07, 0x07, 0x07, 0x14, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x01, 0x1C, 0x09, 0x09, 0x09, 0x09, 0x3A, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1C, 0x09, 0x09, 0x09, 0x09, 0x60, 0x11, 0x06, 0x06, 0x06, 0x06, 0x30,
        0x24, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x11, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x11, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x63, 0x07, 0x07, 0x07, 0x07, 0x07, 0x2E,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x14, 0x07, 0x07, 0x07, 0x07, 0x2F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x01, 0x76, 0x09, 0x09, 0x09, 0x09, 0x09, 0x25, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x75, 0x09, 0x09, 0x09, 0x09, 0x09, 0xA5, 0x06, 0x06, 0x06, 0x06, 0x10,
        0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x23, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x24, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x7B, 0x07, 0x07, 0x07, 0x07, 0x07,
        0x2E, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xC8, 0x07, 0x07, 0x07, 0x07, 0xC8, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1E, 0x09, 0x09, 0x09, 0x09, 0x1C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6E, 0x09, 0x09, 0x09, 0x09, 0xA9, 0x06, 0x06, 0x06, 0x06, 0x15,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x6D, 0x06, 0x06, 0x06, 0x06, 0x06, 0x6D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x37, 0x07, 0x07, 0x07, 0x07,
        0x07, 0xC8, 0x14, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 0x07, 0x07, 0x07, 0x07, 0x07, 0x62, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x43, 0x09, 0x09, 0x09, 0x09, 0x13, 0x25, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1F, 0x09, 0x09, 0x09, 0x09, 0x89, 0x06, 0x06, 0x06, 0x16, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x11, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x14, 0x2F, 0x07, 0x07, 0x07,
        0x07, 0x07, 0x2F, 0x91, 0x14, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x14, 0x12, 0x07, 0x07, 0x07, 0x07, 0x07, 0x19, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x25, 0x13, 0x09, 0x09, 0x09, 0x09, 0x1C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x75, 0x09, 0x09, 0x09, 0x09, 0xEA, 0x06, 0x06, 0x06, 0x10, 0x05,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x14, 0x2F, 0x07, 0x07,
        0x07, 0x07, 0x07, 0x07, 0x07, 0x7B, 0x46, 0x51, 0x01, 0x05, 0x05, 0x05, 0x01, 0x01, 0x01, 0x14, 0x2E, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x2B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1C, 0x09, 0x09, 0x09, 0x09, 0x13, 0x25, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x13, 0x09, 0x09, 0x09, 0xEA, 0x06, 0x06, 0x06, 0x11, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x11, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x14, 0x37, 0x07,
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x19, 0x2E, 0x91, 0x27, 0x91, 0x2E, 0x12, 0x20, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x9C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x25, 0x13, 0x09, 0x09, 0x09, 0x09, 0x1C, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x13, 0x09, 0x09, 0x09, 0xEA, 0x06, 0x06, 0x06, 0x15, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x06, 0x06, 0x06, 0x06, 0x06, 0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x51, 0x7B,
        0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x2F, 0x91, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1C, 0x09, 0x09, 0x09, 0x09, 0x09, 0x0F, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x13, 0x09, 0x09, 0x09, 0xEA, 0x06, 0x06, 0x06, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x30, 0x06, 0x06, 0x06, 0x06, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x46, 0x38, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x20, 0x57, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x25, 0x13, 0x09, 0x09, 0x09, 0x09, 0x13, 0x75, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x13, 0x09, 0x09, 0x09, 0xEA, 0x06, 0x06, 0x06, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x06, 0x06, 0x06, 0x06, 0x06, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x57, 0x12, 0x2F, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x20, 0x46, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x1B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x78, 0x09, 0x09, 0x09, 0x09, 0x89, 0x06, 0x06, 0x06, 0x02, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x06, 0x06, 0x06, 0x06, 0x23, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x51, 0x46, 0x20, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x2F, 0x19, 0x9C, 0x57, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3A, 0x09, 0x09, 0x09, 0x09, 0x09, 0x31, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x31, 0x09, 0x09, 0x09, 0x09, 0xA9, 0x06, 0x06, 0x06, 0x45, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x06, 0x06, 0x06, 0x06, 0x85, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x57, 0x57, 0x2B, 0x2B, 0x57, 0x2B, 0x14, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x25, 0x13, 0x09, 0x09, 0x09, 0x09, 0x09, 0x6E, 0x24, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x78, 0x09, 0x09, 0x09, 0x09, 0x09, 0xA5, 0x06, 0x06, 0x06, 0x22, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x06, 0x06, 0x06, 0x06, 0x30, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x78, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x13, 0x1F, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x89, 0x06, 0x06, 0x06, 0x06, 0x23, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x30, 0x06, 0x06, 0x06, 0x06, 0x45, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x1F, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x1B, 0x1F, 0x24, 0x01, 0x01, 0x01, 0x01, 0x24, 0x31, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0xE3, 0x06, 0x06, 0x06, 0x06, 0x10, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x85, 0x06, 0x06, 0x06, 0x06, 0x23, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x0F, 0x13, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x6E, 0x1B, 0x1B, 0xAA, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x43, 0x23, 0x06, 0x06, 0x06, 0x06, 0x16, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x11, 0x06, 0x06, 0x06, 0x06, 0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x78, 0x1E, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x1B, 0x01, 0x15, 0x06, 0x06, 0x06, 0x06, 0x06, 0x15,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x06, 0x06, 0x06, 0x06, 0x06, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x1C, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x1C, 0x01, 0x01, 0x01, 0x16, 0x06, 0x06, 0x06, 0x06, 0x10,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x06, 0x06, 0x06, 0x06, 0x06, 0x15, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x78, 0x1B, 0x13, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0xAA, 0x0F, 0x02, 0x02, 0x01, 0x01, 0x10, 0x06, 0x06, 0x06, 0x06, 0x30,
        0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0D, 0x06, 0x06, 0x06, 0x06, 0x22, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
        0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0B,
  0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x01, 0x78, 0x1C, 0x13, 0x13, 0x09, 0x09, 0x13, 0xAA, 0x1C, 0x78, 0x01, 0x02, 0x02, 0x02, 0x02, 0x01, 0x15, 0x06, 0x06, 0x06, 0x06, 0x06,
        0x22, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x0D, 0x06, 0x06, 0x06, 0x06, 0x22, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B,
  0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x01, 0x01, 0x24, 0x24, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x01, 0x16, 0x06, 0x06, 0x06, 0x06,
        0x16, 0x02, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x01, 0x0D, 0x06, 0x06, 0x06, 0x06, 0x22, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B,
  0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x01, 0xB9, 0x06, 0x06, 0x06, 0x06,
        0x06, 0x23, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x30, 0x06, 0x06, 0x06, 0x06, 0x22, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B,
  0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0D, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x15, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x01, 0x22, 0x06, 0x06, 0x06, 0x06, 0x30, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B,
  0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x01, 0x15, 0x06, 0x06, 0x06,
        0x06, 0x06, 0x16, 0x02, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x01, 0x0D, 0x06, 0x06, 0x06, 0x06, 0x0D, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B,
  0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x01, 0x10, 0x06, 0x06,
        0x06, 0x06, 0x06, 0x85, 0x02, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x30, 0x06, 0x06, 0x06, 0x06, 0xB9, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B,
  0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x16, 0x06,
        0x06, 0x06, 0x06, 0x06, 0x16, 0x22, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x01, 0xB9, 0x06, 0x06, 0x06, 0x06, 0x30, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B,
  0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0x30,
        0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x10, 0x02, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x01, 0x22, 0x06, 0x06, 0x06, 0x06, 0x06, 0x10, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B,
  0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x45,
        0x30, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x30, 0x45, 0x01, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B,
  0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x45, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x10, 0x45, 0x02, 0x02, 0x02, 0x02, 0x15, 0x0D, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0xB9, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B,
  0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x15, 0x0D, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x30, 0x0D, 0x0D, 0x0D, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0D, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B,
  0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x23, 0x30, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x0D, 0x15, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B,
  0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x45, 0x16, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x85, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B,
  0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x23, 0x30, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x16, 0xB9, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B,
  0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x15, 0xB9, 0x85, 0x30, 0x06, 0x06, 0x06, 0x06, 0x06, 0x85, 0xB9, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B,
  0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x45, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B,
  0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B,
  0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B,
  0x0B, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
        0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0B,
  0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B,
        0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B,
        0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B, 0x0B
};

GUI_CONST_STORAGE GUI_BITMAP bmScratchPad_120x100 = {
  120, // xSize
  100, // ySize
  120, // BytesPerLine
  8, // BitsPerPixel
  _acScratchPad_120x100,  // Pointer to picture data (indices)
  &_PalScratchPad_120x100   // Pointer to palette
};

/*********************************************************************
*
*       Static code
*
**********************************************************************
*/
/*********************************************************************
*
*       _DrawBkScratch
*
* Purpose:
*   Drawing of scratch sample background
*/
static void _DrawBkScratch(void) {
  int xSize, ySize;

  xSize = LCD_GetXSize();
  ySize = LCD_GetYSize();
  GUI_DrawGradientV(0, 0, xSize - 1, ySize - 1, GUI_BLUE, GUI_DARKBLUE);
  GUI_SetFont(&GUI_Font32_AA4);
  GUI_SetTextMode(GUI_TM_TRANS);
  GUI_SetColor(GUI_WHITE);
  GUI_DispStringHCenterAt("Scratchpad", xSize / 2, 10);
  GUI_SetFont(GUI_FONT_16_ASCII);
  GUI_DispStringHCenterAt("Please scratch me...", xSize / 2, ySize - 28);
}

/*********************************************************************
*
*       _IncPointer
*
* Purpose:
*   Pointer increment for ring buffer operation.
*/
static SCRATCH_DATA * _IncPointer(SCRATCH_DATA * p) {
  SCRATCH_DATA * pNew;

  pNew = p;
  if (pNew == (_aData + (GUI_COUNTOF(_aData) - 1))) {
    pNew = _aData;
  } else {
    ++pNew;
  }
  return pNew;
}

/*********************************************************************
*
*       _GetColorAndPrevInputById
*
* Purpose:
*   Uses a small ring buffer for associating a unique color to each touch point.
*   It also saves the given input to the according id.
*   If pInput == NULL the pointers will be (re)set to the beginning of the array.
*/
static void _GetColorAndPrevInputById(const GUI_MTOUCH_INPUT * pInput, SCRATCH_DATA * pData) {
  static SCRATCH_DATA * pRead  = _aData; // Read pointer
  static SCRATCH_DATA * pWrite = _aData; // Write pointer
  SCRATCH_DATA * pi;

  if (pInput == NULL) {
    pRead = pWrite = _aData;
    return;
  }
  //
  // First try to find already existing entry
  //
  pi = pRead;
  while (pi != pWrite) {
    if (pi->Input.Id == pInput->Id) {
      *pData    = *pi;
      pi->Input = *pInput;
      return;
    }
    pi = _IncPointer(pi);
  }
  //
  // Does not exist...
  //
  pWrite->Input = *pInput;
  pData->Input  = *pInput;
  pData->Color  = pWrite->Color;
  pWrite = _IncPointer(pWrite);
  if (pRead == pWrite) {        // Check if buffer is full
    pRead = _IncPointer(pRead); // Remove oldest element
  }
}

/*********************************************************************
*
*       _ClearScratchBuffer
*
* Purpose:
*   Clears the scratch buffer
*/
static void _ClearScratchBuffer(void) {
  unsigned i;

  for (i = 0; i < GUI_COUNTOF(_aData); i++) {
    _aData[i].Input.Id    = 0;
    _aData[i].Input.Flags = 0;
  }
  _GetColorAndPrevInputById(NULL, NULL); // Reset pointers
}

/*********************************************************************
*
*       _ExecScratchPad
*
* Purpose:
*   Executes the scratch pad demo until no input is detected for a dedicated
*   amount of time. It also clears the screen after no input is detected
*   for a smaller period.
*/
static void _ExecScratchPad(void) {
  GUI_MTOUCH_EVENT Event;
  GUI_MTOUCH_INPUT Input;
  unsigned i;
  SCRATCH_DATA Data;
  int IsDown = 0;
  int IsClear = 0;
  GUI_TIMER_TIME TimeEnd;
  GUI_TIMER_TIME TimeClear;
  GUI_TIMER_TIME TimeUp;
  GUI_TIMER_TIME TimeNow;

  WM_GESTURE_Enable(0);
  GUI_MTOUCH_Enable(1);
  _DrawBkScratch();
  _ClearScratchBuffer();
  GUI_SetPenSize(15);
  TimeEnd = GUI_GetTime() + TIME_WAIT;
  TimeClear = TimeUp = 0;
  do {
    GUI_X_Delay(1);
    if (GUI_MTOUCH_GetEvent(&Event) == 0) {
      TimeNow = GUI_GetTime();
      TimeEnd = TimeNow + TIME_WAIT;
      TimeUp  = TimeNow + TIME_UP;
      if (Event.NumPoints <= GUI_COUNTOF(_aData)) {
        //
        // Process incoming touch point events
        //
        for (i = 0; i < Event.NumPoints; i++) {
          IsDown = 1;
          //
          // Get touch point information for only one point
          //
          GUI_MTOUCH_GetTouchInput(&Event, &Input, i);
          //
          // Get color and previous input associated with the touch point's id
          //
          _GetColorAndPrevInputById(&Input, &Data);
          //
          // Only react on move events
          //
          if (Input.Flags == GUI_MTOUCH_FLAG_MOVE) {
            GUI_SetColor(Data.Color);
            GUI_DrawLine(Data.Input.x, Data.Input.y, Input.x, Input.y);
          }
        }
      }
    } else {
      if (IsDown) {
        TimeClear = GUI_GetTime() + TIME_CLEAN_SCRATCH;
        if (GUI_GetTime() > TimeUp) {
          //
          // No touch point is down, so reset color buffer and calculate time for clearing operation
          //
          IsDown    = 0;
          IsClear   = 0;
          _ClearScratchBuffer();
        }
      }
      if ((IsClear == 0) && (GUI_GetTime() > TimeClear)) {
        //
        // If period is expired clear the screen
        //
        _DrawBkScratch();
        IsClear = 1;
      }
    }
  } while (GUI_GetTime() < TimeEnd);
}

/*********************************************************************
*
*       _RotateAndMove
*
* Purpose:
*   Uses the given array of vectors to calculate an array of points observing
*   the given angle, factor and offsets
*/
static void _RotateAndMove(const VECTOR * pVect, GUI_POINT * pPoint, int NumItems, I32 Ang, I32 Factor, int xOff, int yOff) {
  I32 SinHQ, CosHQ, a, x, y, d;

  x = y = 0;
  while (NumItems--) {
    a = pVect->Ang * 1000 + ((Ang * 10) >> 16) * 100;
    SinHQ = GUI__SinHQ(a);
    CosHQ = GUI__CosHQ(a);
    d = (pVect->Dist * Factor) / 1000;
    x += CosHQ * d;
    y -= SinHQ * d;
    pPoint->x = xOff + (x >> 16);
    pPoint->y = yOff + (y >> 16);
    pPoint++;
    pVect++;
  }
}

/*********************************************************************
*
*       _DrawBkGestures
*
* Purpose:
*   Drawing of gesture sample background
*/
static void _DrawBkGestures(void) {
  int xSize, ySize;

  xSize = LCD_GetXSize();
  ySize = LCD_GetYSize();
  GUI_DrawGradientV(0, 0, xSize - 1, ySize - 1, GUI_BLUE, GUI_DARKBLUE);
  GUI_SetFont(&GUI_Font32_AA4);
  GUI_SetTextMode(GUI_TM_TRANS);
  GUI_SetColor(GUI_WHITE);
  GUI_DispStringHCenterAt("Gestures", xSize / 2, 10);
  GUI_SetFont(GUI_FONT_16_ASCII);
  GUI_DispStringHCenterAt("Please touch, resize and rotate me...", xSize / 2, ySize - 28);
}

/*********************************************************************
*
*       _OnPaint
*
* Purpose:
*   Drawing of the gesture sample window.
*/
static void _OnPaint(int xOff, int yOff, I32 Ang, I32 Factor) {
  int i, j;
  GUI_POINT aPoint[GUI_MAX(GUI_COUNTOF(_av0), GUI_COUNTOF(_av1))];

  //
  // Background
  //
  _DrawBkGestures();
  //
  // Foreground drawn by using the draw objects of _aDraw[]
  //
  for (i = 0; (unsigned)i < GUI_COUNTOF(_aDraw); i++) {
    //
    // Each entry has its own color and pen size
    //
    GUI_SetColor  (_aDraw[i].Color);
    GUI_SetPenSize((_aDraw[i].PenSize * Factor) / 1000);
    //
    // Calculate the points to be used
    //
    _RotateAndMove(_aDraw[i].pVector, aPoint, _aDraw[i].NumItems, Ang, Factor, xOff, yOff);
    //
    // Simply draw lines between the points
    //
    for (j = 0; j < _aDraw[i].NumItems - 1; j++) {
      GUI_AA_DrawLine(aPoint[j].x, aPoint[j].y, aPoint[j + 1].x, aPoint[j + 1].y);
    }
  }
}

/*********************************************************************
*
*       _cbGestures
*
* Purpose:
*   Callback routine of gesture sample window
*/
static void _cbGestures(WM_MESSAGE * pMsg) {
  static int xOff;
  static int yOff;
  static I32 Ang;
  static I32 Factor;
  static int ReactOnMove;
  static WM_ZOOM_INFO ZoomInfo = {
    FACTOR_MIN, FACTOR_MAX
  };
  WM_GESTURE_INFO * pGestureInfo;
  GUI_TIMER_TIME * pTimeEnd;
  int xSize, ySize;

  switch (pMsg->MsgId) {
  case REACT_ON_MOVE:
    ReactOnMove = 1;
    break;
  case WM_CREATE:
    //
    // Initialization of default values on each create event
    //
    xSize = WM_GetXSize(pMsg->hWin);
    ySize = WM_GetYSize(pMsg->hWin);
    xOff = xSize / 2;
    yOff = ySize / 2;
    Factor = 1600;
    Ang = 0;
    ReactOnMove = 0;
    break;
  case WM_GESTURE:
    //
    // Manage gesture messages
    //
    WM_GetUserData(pMsg->hWin, &pTimeEnd, sizeof(pTimeEnd));
    *pTimeEnd = GUI_GetTime() + TIME_WAIT;
    pGestureInfo = (WM_GESTURE_INFO *)pMsg->Data.p;
    switch (pGestureInfo->Flags & ~(WM_GF_BEGIN | WM_GF_END)) {
    case WM_GF_ZOOM:
      pGestureInfo->pZoomInfo = &ZoomInfo;
      if (pGestureInfo->Flags & WM_GF_BEGIN) {
        //
        // If zoom message starts, application has to provide a factor
        //
        pGestureInfo->Factor = Factor;
      } else if ((pGestureInfo->Flags & WM_GF_END) == 0) {
        //
        // Otherwise the factor which comes with the message has to be used
        //
        Factor = pGestureInfo->Factor;
        //
        // If the according flag is set, react on move events
        //
        if (ReactOnMove) {
          xOff += pGestureInfo->Point.x;
          yOff += pGestureInfo->Point.y;
        }
        //
        // Make sure window gets a new paint event
        //
        WM_InvalidateWindow(pMsg->hWin);
      }
      break;
    case WM_GF_ROTATE:
      //
      // Here it is required to process the angle difference by adding it to the current value
      //
      Ang += pGestureInfo->Angle;
      if        (Ang > (360L << 16)) {
        Ang -= (360L << 16);
      } else if (Ang < 0) {
        Ang += (360L << 16);
      }
      //
      // If the according flag is set, react on move events
      //
      if (ReactOnMove) {
        xOff += pGestureInfo->Point.x;
        yOff += pGestureInfo->Point.y;
      }
      WM_InvalidateWindow(pMsg->hWin);
      break;
    case WM_GF_PAN:
      //
      // Only reacting on move events has to be done
      //
      xOff += pGestureInfo->Point.x;
      yOff += pGestureInfo->Point.y;
      WM_InvalidateWindow(pMsg->hWin);
      break;
    }
    break;
  case WM_PAINT:
    _OnPaint(xOff, yOff, Ang, Factor);
    break;
  }
}

/*********************************************************************
*
*       _ExecGestures
*
* Purpose:
*   Creates the gesture sample window. After not detecting any touch
*   input for a specified period it removes the window and returns.
*/
static void _ExecGestures(int ReactOnMove) {
  WM_HWIN hWin;
  GUI_TIMER_TIME TimeEnd;
  GUI_TIMER_TIME * pTimeEnd;
  int xSize, ySize;

  //
  // Create gesture sample window
  //
  xSize = LCD_GetXSize();
  ySize = LCD_GetYSize();
  pTimeEnd = &TimeEnd;
  hWin = WM_CreateWindowAsChild(0, 0, xSize, ySize, WM_HBKWIN, WM_CF_SHOW | WM_CF_GESTURE, _cbGestures, sizeof(pTimeEnd));
  //
  // Specify time stamp for ending sample
  //
  TimeEnd = GUI_GetTime() + TIME_WAIT;
  WM_SetUserData(hWin, &pTimeEnd, sizeof(pTimeEnd));
  //
  // Tell the window that it should react on move messages when zooming and/or rotating
  //
  if (ReactOnMove) {
    WM_SendMessageNoPara(hWin, REACT_ON_MOVE);
  }
  //
  // Loop until no input comes
  //
  do {
    WM_Exec();
    GUI_X_Delay(1);
  } while (GUI_GetTime() < TimeEnd);
  //
  // Remove window and return
  //
  WM_DeleteWindow(hWin);
}

/*********************************************************************
*
*       _DrawBkMenu
*
* Purpose:
*   Drawing of main menu background
*/
static void _DrawBkMenu(void) {
  int xSize, ySize;

  xSize = LCD_GetXSize();
  ySize = LCD_GetYSize();
  GUI_DrawGradientV(0, 0, xSize - 1, ySize - 1, GUI_BLUE, GUI_DARKBLUE);
  GUI_SetFont(&GUI_Font32_AA4);
  GUI_SetTextMode(GUI_TM_TRANS);
  GUI_SetColor(GUI_WHITE);
  GUI_DispStringHCenterAt("Multitouch demo", xSize / 2, 10);
}

/*********************************************************************
*
*       _cbWin
*
* Purpose:
*   Callback function of main menu. After pressing a button it deletes
*   the dialog and returns the according selection value.
*/
static void _cbWin(WM_MESSAGE * pMsg) {
  int Id, NCode;
  WM_HWIN hWin;
  int * pReactOnMove;

  hWin = pMsg->hWin;
  switch (pMsg->MsgId) {
  case WM_NOTIFY_PARENT:
    Id    = WM_GetId(pMsg->hWinSrc);
    NCode = pMsg->Data.v;
    switch (NCode) {
    //
    // Manage reaction on move events
    //
    case WM_NOTIFICATION_VALUE_CHANGED:
      switch (Id) {
      case GUI_ID_CHECK0:
        WINDOW_GetUserData(hWin, &pReactOnMove, sizeof(pReactOnMove));
        if (pReactOnMove) {
          *pReactOnMove = CHECKBOX_GetState(pMsg->hWinSrc);
        }
        break;
      }
      break;
    //
    // Manage sample selection
    //
    case WM_NOTIFICATION_RELEASED:
      switch (Id) {
      case GUI_ID_BUTTON0:
        GUI_EndDialog(hWin, EXEC_GESTURES);
        break;
      case GUI_ID_BUTTON1:
        GUI_EndDialog(hWin, EXEC_SCRATCHPAD);
        break;
      }
      break;
    }
    break;
  case WM_PAINT:
    _DrawBkMenu();
  }
}

/*********************************************************************
*
*       _DrawSkinFlex
*
* Purpose:
*   Skinning function for buttons of main menu
*/
static int _DrawSkinFlex(const WIDGET_ITEM_DRAW_INFO * pDrawItemInfo) {
  switch (pDrawItemInfo->Cmd) {
  case WIDGET_ITEM_DRAW_BACKGROUND:
    //
    // Only draw background here, ...
    //
    if (BUTTON_IsPressed(pDrawItemInfo->hWin)) {
      GUI_DrawGradientRoundedV(pDrawItemInfo->x0, pDrawItemInfo->y0, pDrawItemInfo->x1, pDrawItemInfo->y1, 20, BUTTON_COLOR0, BUTTON_COLOR1);
    } else {
      GUI_DrawGradientRoundedV(pDrawItemInfo->x0, pDrawItemInfo->y0, pDrawItemInfo->x1, pDrawItemInfo->y1, 20, BUTTON_COLOR1, BUTTON_COLOR0);
    }
    GUI_SetColor(BUTTON_COLOR_FRAME);
    GUI_SetPenSize(5);
    GUI_AA_DrawRoundedRect(pDrawItemInfo->x0 + 2, pDrawItemInfo->y0 + 2, pDrawItemInfo->x1 - 2, pDrawItemInfo->y1 - 2, 20);
    break;
  default:
    //
    // ... all other items should be done by the widget itself
    //
    BUTTON_DrawSkinFlex(pDrawItemInfo);
    break;
  }
  return 0;
}

/*********************************************************************
*
*       _DoMenu
*
* Purpose:
*   Creates and executes the main menu with two custom drawn buttons
*
* Return value:
*   User selection EXEC_SCRATCHPAD or EXEC_GESTURES
*/
static int _DoMenu(int * pReactOnMove) {
  WM_HWIN hButton0, hButton1, hWin, hCheck;
  int xSize, ySize, dx, dy, xSizeWidget, xSizeButton;
  GUI_CONST_STORAGE GUI_BITMAP * pBm;
  const char acText[] = "React on panning when rotating and zooming";
  const GUI_FONT GUI_UNI_PTR * pFont;

  WM_GESTURE_Enable(1);
  pBm = &bmGestures_120x100;
  xSize = LCD_GetXSize();
  ySize = LCD_GetYSize();
  dx = xSize / 7;
  dy = ySize / 4;
  hWin = WINDOW_CreateUser(0, 0, xSize, ySize, WM_HBKWIN, WM_CF_SHOW, 0, 0, _cbWin, sizeof(pReactOnMove));
  WINDOW_SetUserData(hWin, &pReactOnMove, sizeof(pReactOnMove));
  BUTTON_SetDefaultSkin(_DrawSkinFlex);
  BUTTON_SetDefaultFont(GUI_FONT_16B_ASCII);
  BUTTON_SetDefaultTextColor(GUI_WHITE, BUTTON_CI_UNPRESSED);
  BUTTON_SetDefaultTextColor(GUI_WHITE, BUTTON_CI_PRESSED);
  xSizeButton = (dx * 5) / 2;
  if (xSizeButton < (pBm->XSize + 20)) {
    xSizeButton = (pBm->XSize + 20);
  }
  dx = (xSize - (xSizeButton * 2)) / 3;
  hButton0 = BUTTON_CreateEx(dx,                   (dy * 6) / 5 - 10, xSizeButton, dy * 2 + 20, hWin, WM_CF_SHOW, 0, GUI_ID_BUTTON0);
  hButton1 = BUTTON_CreateEx(dx * 2 + xSizeButton, (dy * 6) / 5 - 10, xSizeButton, dy * 2 + 20, hWin, WM_CF_SHOW, 0, GUI_ID_BUTTON1);
  BUTTON_SetBitmapEx(hButton0, BUTTON_BI_UNPRESSED, pBm, (xSizeButton - pBm->XSize) / 2, ((dy * 2 - pBm->YSize) * 2) / 3 + 10);
  pBm = &bmScratchPad_120x100;
  BUTTON_SetBitmapEx(hButton1, BUTTON_BI_UNPRESSED, pBm, (xSizeButton - pBm->XSize) / 2, ((dy * 2 - pBm->YSize) * 2) / 3 + 10);
  BUTTON_SetText(hButton0, "Gestures");
  BUTTON_SetTextOffset(hButton0, 0, -(pBm->YSize / 2 + 5));
  pBm = &bmScratchPad_120x100;
  BUTTON_SetText(hButton1, "Scratchpad");
  BUTTON_SetTextOffset(hButton1, 0, -(pBm->YSize / 2 + 5));
  CHECKBOX_SetDefaultSkin(CHECKBOX_SKIN_FLEX);
  pFont = GUI_FONT_16_ASCII;
  CHECKBOX_SetDefaultFont(pFont);
  GUI_SetFont(pFont);
  xSizeWidget = GUI_GetStringDistX(acText) + BUTTON_SIZE_CHECKBOX + 5;
  hCheck = CHECKBOX_CreateEx((xSize - xSizeWidget) / 2, ySize - 30, xSizeWidget, 20, hWin, WM_CF_SHOW, 0, GUI_ID_CHECK0);
  CHECKBOX_SetTextColor(hCheck, GUI_WHITE);
  CHECKBOX_SetText(hCheck, acText);
  CHECKBOX_SetSkinFlexButtonSize(hCheck, BUTTON_SIZE_CHECKBOX);
  if (*pReactOnMove) {
    CHECKBOX_SetState(hCheck, 1);
  }
  return GUI_ExecCreatedDialog(hWin);
}

/*********************************************************************
*
*       _cbBk
*
* Purpose:
*   Draws the background of the desktop window
*/
static void _cbBk(WM_MESSAGE * pMsg) {
  int xSize, ySize;

  switch (pMsg->MsgId) {
  case WM_PAINT:
    xSize = LCD_GetXSize();
    ySize = LCD_GetYSize();
    GUI_DrawGradientV(0, 0, xSize - 1, ySize - 1, GUI_BLUE, GUI_DARKBLUE);
    break;
  default:
    WM_DefaultProc(pMsg);
    break;
  }
}

/*********************************************************************
*
*       Public code
*
**********************************************************************
*/
/*********************************************************************
*
*       MainTask
*/
void MainTask(void) {
  int ReactOnMove;

  ReactOnMove = 1;
  #if GUI_SUPPORT_MEMDEV
    WM_SetCreateFlags(WM_CF_MEMDEV);
  #endif
  GUI_Init();
  //
  // Check if recommended memory for the sample is available
  //
  if (GUI_ALLOC_GetNumFreeBytes() < RECOMMENDED_MEMORY) {
    GUI_ErrorOut("Not enough memory available."); 
    return;
  }
  WM_SetCallback(WM_HBKWIN, _cbBk);
  while (1) {
    switch (_DoMenu(&ReactOnMove)) {
    case EXEC_SCRATCHPAD:
      _ExecScratchPad();
      break;
    case EXEC_GESTURES:
      _ExecGestures(ReactOnMove);
      break;
    }
    GUI_Delay(100);
  }
}

/*************************** End of file ****************************/
