/*********************************************************************
*                SEGGER Microcontroller GmbH                         *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2018  SEGGER Microcontroller GmbH                *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.48 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software  has been licensed to  Cypress Semiconductor Corporation,
whose registered  office is situated  at 198 Champion Ct. San Jose, CA 
95134 USA  solely for the  purposes of creating  libraries for Cypress
PSoC3 and  PSoC5 processor-based devices,  sublicensed and distributed
under  the  terms  and  conditions  of  the  Cypress  End User License
Agreement.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information
Licensor:                 SEGGER Microcontroller Systems LLC
Licensed to:              Cypress Semiconductor Corp, 198 Champion Ct., San Jose, CA 95134, USA
Licensed SEGGER software: emWin
License number:           GUI-00319
License model:            Services and License Agreement, signed June 10th, 2009
Licensed platform:        Any Cypress platform (Initial targets are: PSoC3, PSoC5)
----------------------------------------------------------------------
Support and Update Agreement (SUA)
SUA period:               2009-06-12 - 2022-07-27
Contact to extend SUA:    sales@segger.com
----------------------------------------------------------------------
File        : moscow_480x272.h
Content     : Bitmap 480 * 272
---------------------------END-OF-HEADER------------------------------
*/

#include <stdlib.h>

#include "GUI.h"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

extern GUI_CONST_STORAGE GUI_BITMAP bmmoscow_480x272;

static GUI_CONST_STORAGE unsigned short _acmoscow_480x272[] = {
  0x8492, 0x8492, 0x8492, 0x84B2, 0x8492, 0x8492, 0x8492, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84D3, 
        0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CD3, 0x84D3, 0x8CD3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 
        0x8CF3, 0x8CD3, 0x8CD3, 0x84D3, 0x84B3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x84D3, 0x84D3, 0x8CF3, 0x84F3, 0x84D3, 0x84D3, 0x84B3, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x8492, 0x8493, 0x84B3, 0x84B3, 0x8493, 0x8493, 
        0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8D14, 0x9514, 0x9514, 0x9534, 0x9534, 0x9534, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x8D14, 0x8D14, 0x8CF4, 0x8CF4, 0x9514, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CB3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x8492, 0x8492, 0x8492, 0x84B3, 0x84B3, 0x8CB2, 0xB552, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 
        0x7C72, 0x7C52, 0x7C52, 0x7C52, 0x7452, 0x7C52, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x8493, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 
        0x84B3, 0x8492, 0x8492, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C52, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 
        0x8492, 0x8472, 0x7C72, 0x7C72, 0x8472, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x8493, 0x7C92, 0x7C93, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 
        0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 
        0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7452, 0x7452, 0x7452, 0x7472, 0x7472, 0x7472, 
        0x7452, 0x7C52, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7451, 0x7451, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x6C31, 0x6C31, 0x6C11, 0x6C10, 0x6C10, 
        0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6BF0, 0x6BF0, 0x6BF0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63D0, 0x5BD0, 0x5BD0, 0x63D0, 0x63AF, 0x63CF, 0x63CF, 0x5BCF, 0x63CF, 0x63D0, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 
        0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5B8F, 0x5BAF, 0x5BAF, 0x538F, 0x5B8F, 0x5B8F, 0x5B8F, 0x538F, 0x538F, 0x538F, 
        0x538F, 0x538F, 0x538F, 0x538F, 0x538E, 0x538F, 0x538E, 0x538F, 0x538F, 0x538F, 0x538E, 0x5B8F, 0x5B8F, 0x538F, 0x538F, 0x538F, 0x538F, 0x538F, 0x538E, 0x538F, 0x538F, 0x538F, 0x538E, 0x538F, 0x538F, 0x538E, 0x538E, 0x538F, 0x538E,
  0x8492, 0x8492, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B2, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84D3, 0x84D3, 0x84D3, 
        0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF4, 0x8CF4, 0x8CF3, 0x84D3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CD3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF4, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84F4, 0x84D3, 0x84D3, 
        0x8CD4, 0x8CD3, 0x8CD3, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8D14, 0x8D14, 0x8CF4, 0x8D14, 0x8D14, 0x9514, 0x9534, 0x9534, 0x9534, 0x9555, 0x9535, 0x9534, 
        0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x8D14, 0x8D14, 0x8D14, 0x9514, 0x9514, 0x8D14, 0x8D14, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x94D2, 0xBD72, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 
        0x7C72, 0x7C52, 0x7C52, 0x7C52, 0x7452, 0x7C52, 0x7C52, 0x7452, 0x7C52, 0x7452, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x8492, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 
        0x84B2, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C72, 0x7C92, 0x8492, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 
        0x7C92, 0x8492, 0x7C72, 0x7C92, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8493, 0x8493, 0x7C92, 0x7C93, 0x7C92, 0x8492, 
        0x8492, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 
        0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7C72, 0x7452, 0x7452, 0x7C72, 0x7C72, 0x7452, 
        0x7452, 0x7C72, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7C52, 0x7452, 0x7451, 0x7451, 0x7451, 0x7431, 0x7431, 0x7431, 0x7431, 0x7451, 0x7431, 0x7451, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x6C31, 0x6C31, 0x6C10, 
        0x6C10, 0x6C11, 0x6C10, 0x6C11, 0x6C11, 0x6BF0, 0x6C10, 0x6C10, 0x6BF0, 0x6BF0, 0x6BF0, 0x6BF0, 0x6BF0, 0x6BF0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x5BD0, 0x63CF, 0x5BAF, 0x5BAF, 
        0x5BAF, 0x5BAF, 0x5BD0, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x63AF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5B8F, 0x5B8F, 0x538F, 0x538F, 0x538F, 
        0x538F, 0x538F, 0x538F, 0x5B8F, 0x538F, 0x5B8F, 0x5B8F, 0x5B8F, 0x5B8F, 0x5B8F, 0x5B8F, 0x5B8F, 0x5B8F, 0x5B8F, 0x538F, 0x538F, 0x5B8F, 0x5B8F, 0x538F, 0x5B8F, 0x5B8F, 0x5B8F, 0x538F, 0x5B8F, 0x5B8F, 0x5B8F, 0x538E, 0x538F, 0x538F,
  0x8492, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x84D3, 
        0x84D3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF4, 0x8CF3, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF3, 
        0x8CF4, 0x8CF4, 0x8CD3, 0x8CF3, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF4, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8CF4, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8CF4, 0x8CF4, 0x8D14, 0x8D14, 0x8D14, 0x8CF4, 
        0x8CF4, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8CF4, 0x8CF4, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x9534, 0x9534, 0x9535, 0x9555, 0x9555, 0x9555, 0x9D55, 0x9D55, 
        0x9D55, 0x9D55, 0x9D55, 0x9555, 0x9554, 0x9D54, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x94F4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CB3, 0x84B3, 0x84B3, 0x94D2, 0xBD72, 0x8CB2, 0x84B3, 0x8CB3, 0x84B3, 0x84B3, 0x84B2, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C72, 0x7C72, 0x7C92, 0x7C72, 0x7C72, 
        0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C52, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8493, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8492, 
        0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 
        0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x8493, 0x8493, 0x8493, 0x8493, 0x8493, 0x8493, 0x84B3, 0x84B3, 0x8492, 0x8492, 
        0x8492, 0x8493, 0x7C93, 0x8493, 0x8492, 0x8493, 0x7C92, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 
        0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7C72, 0x7452, 0x7452, 0x7C52, 0x7C52, 0x7452, 
        0x7452, 0x7472, 0x7452, 0x7C52, 0x7C52, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 
        0x6C31, 0x6C11, 0x6C11, 0x6C11, 0x6C11, 0x6C11, 0x6C11, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6BF0, 0x6BF0, 0x6BF0, 0x6BF0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63CF, 0x63CF, 0x63CF, 
        0x63CF, 0x5BD0, 0x5BD0, 0x5BB0, 0x5BAF, 0x5BAF, 0x5BCF, 0x63CF, 0x63CF, 0x5BCF, 0x5BAF, 0x63CF, 0x63D0, 0x63CF, 0x63CF, 0x63CF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5B8F, 0x5BAF, 0x5BAF, 0x5BAF, 
        0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5B8F, 0x5BAF, 0x5BAF, 0x5B8F, 0x5B8F, 0x5B8F, 0x5BAF, 0x5BAF, 0x5B8F, 0x5B8F, 0x5B8F,
  0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF4, 0x8CF4, 0x8D14, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8D14, 0x8CF4, 0x8D14, 0x8CF4, 0x8CF4, 0x8D14, 0x8CF4, 0x8CF4, 0x8CF4, 
        0x8D14, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF4, 0x8CF4, 0x8D14, 0x8D14, 0x8CF4, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D34, 0x8D34, 0x8D34, 0x8D34, 0x8D34, 0x8D14, 0x8D34, 0x9535, 0x8D35, 0x8D34, 
        0x8D34, 0x8D14, 0x8D14, 0x8D34, 0x8D14, 0x8D34, 0x8D35, 0x8D15, 0x8D34, 0x8D34, 0x8D34, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x9534, 0x9534, 0x9535, 0x9555, 0x9555, 0x9555, 0x9D55, 0x9D75, 0x9D75, 0x9D75, 
        0x9D75, 0x9D75, 0xA575, 0xA575, 0xA575, 0xA575, 0x9D55, 0x9D55, 0x9D55, 0x9555, 0x9535, 0x9535, 0x9535, 0x9535, 0x9534, 0x9534, 0x9514, 0x9534, 0x9514, 0x9514, 0x9514, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x9CF2, 0xC593, 0x8CB2, 0x8CB3, 0x8CB3, 0x8CB3, 0x8CB3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8493, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 
        0x8492, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C72, 0x7C72, 0x8492, 0x84B3, 0x8492, 0x8492, 0x84B2, 0x84B2, 0x84B3, 0x8493, 0x8493, 0x8493, 0x84B3, 0x8CB3, 0x8CD3, 0x84D3, 0x84D3, 0x8CB3, 0x84B3, 0x84B3, 
        0x8492, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x8472, 0x8492, 0x7C92, 
        0x8492, 0x8493, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8493, 0x8493, 0x8492, 
        0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x8472, 0x8492, 0x7C92, 0x8492, 0x7C92, 0x8492, 0x7C92, 0x8493, 0x8493, 0x8493, 0x8493, 0x8493, 0x8493, 0x8493, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x8492, 
        0x84B3, 0x84B3, 0x8493, 0x8493, 0x8493, 0x84B3, 0x7CB3, 0x8493, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 
        0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7C52, 0x7C52, 0x7452, 
        0x7452, 0x7452, 0x7452, 0x7C52, 0x7C52, 0x7C72, 0x7472, 0x7472, 0x7452, 0x7C52, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7431, 0x7451, 0x7451, 0x7431, 0x7431, 
        0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x6C11, 0x6C11, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6BF0, 0x6C10, 0x6C10, 0x6BF0, 0x6BF0, 0x6BF0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63D0, 0x63F0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 
        0x63CF, 0x63D0, 0x63D0, 0x63D0, 0x5BD0, 0x5BCF, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63F0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63CF, 0x63D0, 0x63D0, 0x63CF, 0x63AF, 0x63CF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 
        0x5BAF, 0x5BAF, 0x5BCF, 0x5BAF, 0x5BCF, 0x63AF, 0x63AF, 0x63AF, 0x63AF, 0x63AF, 0x63CF, 0x63CF, 0x63AF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5B8F,
  0x84B2, 0x84D3, 0x84D3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8D14, 0x8D13, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8CF4, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8CF4, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 
        0x8D14, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF3, 0x8CF4, 0x8CF4, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x9534, 0x9534, 0x8D14, 0x8D35, 0x8D34, 0x8D34, 0x8D34, 0x9535, 0x8D35, 0x8D35, 0x9535, 0x9535, 0x9535, 0x8D35, 0x9535, 
        0x9535, 0x9535, 0x9535, 0x9535, 0x8D35, 0x8D35, 0x9535, 0x9535, 0x8D35, 0x8D35, 0x9534, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x9534, 0x9534, 0x9534, 0x9535, 0x9535, 0x9535, 0x9555, 0x9D55, 0x9D55, 0x9D75, 0xA575, 0xA575, 0xA595, 
        0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA575, 0xA575, 0x9D75, 0x9D55, 0x9535, 0x9535, 0x9535, 0x9534, 0x9535, 0x9535, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x8D14, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x84D3, 0x9CF2, 0xC5D3, 0x8CB2, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CB3, 0x8CB3, 0x8CB3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8492, 0x8492, 0x8492, 
        0x84B2, 0x8492, 0x8492, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8493, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CD3, 0x8CD3, 0x84B3, 0x84B3, 
        0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8492, 0x8492, 0x8492, 0x7C92, 0x8492, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 
        0x8493, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8493, 0x8492, 0x8492, 0x8492, 
        0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8493, 0x8493, 0x8493, 0x8493, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8493, 
        0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8493, 0x8493, 0x8493, 0x8493, 0x8493, 0x8493, 0x8493, 0x8493, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 
        0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7472, 0x7C72, 
        0x7C72, 0x7C72, 0x7C52, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7C52, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7451, 0x7451, 0x7452, 0x7451, 0x7451, 0x7451, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 
        0x7431, 0x7451, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x6C11, 0x6C11, 0x6C11, 0x6C11, 0x6C11, 0x6C11, 0x6C11, 0x6C10, 0x6C10, 0x6C10, 0x6BF0, 0x6BF0, 0x6BF0, 0x6BF0, 0x63F0, 0x6BF0, 0x6BF0, 0x63F0, 
        0x63F0, 0x63F0, 0x63F0, 0x63D0, 0x63D0, 0x63D0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x6BF0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 
        0x63CF, 0x63D0, 0x63D0, 0x63CF, 0x63CF, 0x63CF, 0x63AF, 0x63CF, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63CF, 0x63CF, 0x63CF, 0x5BCF, 0x63CF, 0x63CF, 0x63CF, 0x63CF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF,
  0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x84D3, 0x84D3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF4, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 
        0x8D14, 0x8CF4, 0x8CF4, 0x8D14, 0x8D14, 0x8D13, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D34, 0x8D34, 0x9514, 0x9534, 0x9534, 0x9515, 0x9535, 0x9534, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9555, 0x9535, 0x9535, 
        0x9535, 0x9535, 0x9535, 0x9535, 0x8D55, 0x9535, 0x9535, 0x9535, 0x8D35, 0x9535, 0x9535, 0x8D35, 0x9534, 0x9534, 0x9535, 0x9515, 0x9534, 0x9534, 0x9535, 0x9535, 0x9535, 0x9535, 0x9555, 0x9D55, 0x9D55, 0x9D75, 0xA575, 0xA596, 0xA596, 0xA595, 
        0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB5, 0xAD95, 0xA595, 0xA595, 0xA595, 0x9D75, 0x9555, 0x9555, 0x9555, 0x9535, 0x9535, 0x9535, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9513, 0x8CF3, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x94F3, 0x94F3, 0x8CF3, 0x94F3, 0x94F3, 0x8CF3, 0x94F3, 0x8D13, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x9D13, 0xC5D3, 0x8CB2, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CB3, 0x8CB3, 0x8CB3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 
        0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 
        0x84D3, 0x84D3, 0x84B3, 0x84B3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x8492, 0x8492, 0x8492, 0x8492, 0x8493, 0x84B3, 0x84B3, 0x84B2, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 
        0x8492, 0x8492, 0x8492, 0x7C92, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x84B2, 0x84B2, 
        0x84B2, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x84B2, 0x8492, 0x8493, 0x8493, 0x8493, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 
        0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x8493, 0x8493, 0x8493, 0x84B3, 0x8493, 0x8493, 0x8492, 0x7C92, 0x7C93, 0x7C92, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7472, 0x7C72, 
        0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7472, 0x7452, 0x7C52, 0x7472, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7452, 0x7451, 0x7451, 0x7451, 
        0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7411, 0x7431, 0x7430, 0x6C30, 0x6C31, 0x6C10, 0x6C11, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6BF0, 
        0x6BF0, 0x6BF0, 0x6BF0, 0x6BF0, 0x6BF0, 0x6BF0, 0x6BF0, 0x6BF0, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6BF0, 0x6BF0, 0x6BF0, 0x6BF0, 0x6C10, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x6BF0, 0x6BF0, 0x6BF0, 0x63F0, 0x63D0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 
        0x63F0, 0x63D0, 0x63D0, 0x63F0, 0x63F0, 0x63CF, 0x63CF, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x5BD0, 0x63D0, 0x63CF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF,
  0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF4, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF4, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF4, 0x8CF4, 0x8D14, 0x8D14, 
        0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x9514, 0x9514, 0x9514, 0x9514, 0x8D14, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 
        0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D34, 0x8D34, 0x9534, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9555, 0x9555, 0x9535, 0x9555, 0x9555, 0x9535, 0x9555, 0x9555, 0x9555, 0x9555, 
        0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9555, 0x9555, 0x9D55, 0x9D75, 0x9D96, 0xA596, 0xADB6, 0xADB6, 0xADB6, 
        0xADB6, 0xADB6, 0xB5D6, 0xADB6, 0xADB6, 0xADB5, 0xADB5, 0xADB5, 0xA595, 0x9D75, 0x9555, 0x9555, 0x9555, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x94F3, 0x9513, 0x9513, 0x8CF3, 0x8CF3, 
        0x94F3, 0x94F3, 0x9513, 0x9513, 0x8D13, 0x8CF3, 0x94F3, 0x9514, 0x9513, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0xA533, 0xC5D3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CB3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CB3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x8492, 0x8492, 0x84B2, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 
        0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x84B2, 0x84B3, 0x84B3, 
        0x84B2, 0x84B2, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x8492, 0x8493, 0x8492, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x8493, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 
        0x84B3, 0x84B3, 0x8493, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8493, 0x8493, 0x8493, 0x7C92, 0x8493, 0x8493, 0x8492, 0x8493, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7C72, 
        0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7452, 0x7452, 0x7452, 0x7472, 0x7472, 0x7452, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7452, 0x7452, 0x7452, 0x7452, 0x7451, 0x7451, 
        0x7451, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7431, 0x7431, 0x7431, 0x7451, 0x7431, 0x7451, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x7431, 0x6C31, 0x6C11, 0x6C11, 0x6C11, 
        0x6C11, 0x6C31, 0x6C31, 0x6C11, 0x6C11, 0x6C11, 0x6C10, 0x6C11, 0x6C11, 0x6C11, 0x6C11, 0x6C11, 0x6C11, 0x6C11, 0x6C11, 0x6C31, 0x6C31, 0x6C11, 0x6C11, 0x6C31, 0x6C11, 0x6C11, 0x6C10, 0x6C10, 0x6C10, 0x6BF0, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 
        0x6410, 0x6BF0, 0x63F0, 0x63F0, 0x63F0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63CF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF,
  0x84D3, 0x84D3, 0x84D3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF4, 0x8CF4, 0x8D14, 0x8D14, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8D13, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 
        0x8D14, 0x9514, 0x9514, 0x9514, 0x8D14, 0x8D14, 0x8D14, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9534, 0x9534, 0x9534, 0x8D14, 0x9534, 0x9534, 
        0x9534, 0x9534, 0x8D14, 0x8D14, 0x9514, 0x8D14, 0x8D14, 0x8D14, 0x8D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 
        0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9535, 0x9535, 0x9555, 0x9555, 0x9535, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9D76, 0x9D76, 0x9D96, 0xA5B6, 0xADB6, 0xADB6, 0xADB6, 
        0xADD6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xADB6, 0xADB6, 0xA5B6, 0x9D95, 0x9575, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9554, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 
        0x9514, 0x9513, 0x9513, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x94F4, 0x9514, 0x9514, 0x9514, 0x8CF4, 0xA553, 0xCDF2, 0x8CD3, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x84D3, 0x84B3, 0x84B3, 0x8CB3, 0x8CB3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x84B2, 0x84B2, 0x8492, 
        0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x84B2, 0x84B2, 0x8492, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 
        0x8493, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x84B2, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 
        0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8493, 0x8493, 0x84B3, 0x8493, 0x8493, 0x8493, 0x8492, 0x8492, 0x8493, 0x8493, 0x8493, 0x8493, 0x7C93, 0x8493, 0x8493, 0x8493, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 
        0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7452, 0x7452, 0x7472, 0x7452, 0x7472, 0x7472, 0x7452, 0x7452, 0x7451, 0x7452, 0x7452, 0x7452, 0x7452, 0x7451, 0x7452, 0x7C52, 0x7451, 0x7451, 
        0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7452, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7431, 0x7451, 0x7451, 0x7431, 0x7431, 0x7431, 
        0x7431, 0x7431, 0x6C31, 0x7431, 0x7431, 0x7431, 0x6C31, 0x7431, 0x7431, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x7431, 0x7431, 0x6C31, 0x6C51, 0x6C51, 0x6C51, 0x7451, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 
        0x6C11, 0x6C10, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x5BD0, 0x5BD0, 0x5BD0, 0x63CF, 0x63CF, 0x63CF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF,
  0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 
        0x9514, 0x9534, 0x9514, 0x9534, 0x9534, 0x8D34, 0x8D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9535, 0x9535, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 
        0x9534, 0x9534, 0x8D34, 0x9534, 0x9514, 0x9514, 0x9534, 0x8D34, 0x8D34, 0x9534, 0x9535, 0x9535, 0x9535, 0x9555, 0x9535, 0x9535, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 
        0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9D55, 0x9D56, 0x9D76, 0x9D76, 0x9D96, 0xA5B6, 0xADB6, 0xADD6, 0xB5D6, 
        0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5D6, 0xB5D6, 0xADD6, 0xADB6, 0xADB6, 0xA596, 0x9D75, 0x9D75, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9554, 0x9534, 0x9535, 0x9535, 0x9535, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x8D14, 0xA533, 0xBD92, 0x94F3, 0x94F4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x8CB3, 0x8CB3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x84B2, 0x84B2, 0x8492, 
        0x8492, 0x8492, 0x8492, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x84B3, 0x8492, 0x8492, 0x8492, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 
        0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x8492, 0x8492, 0x8492, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 
        0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8493, 0x8493, 0x8492, 0x8493, 0x8493, 0x7C93, 0x7CB3, 0x8493, 0x8493, 0x8493, 0x8493, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 
        0x8492, 0x7C92, 0x7C92, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 
        0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7472, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7452, 0x7452, 0x7472, 0x7C72, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7472, 0x7452, 0x7452, 0x7472, 0x7452, 0x7452, 0x7451, 
        0x7451, 0x7451, 0x7451, 0x7452, 0x7452, 0x7452, 0x7451, 0x7451, 0x7452, 0x7452, 0x7452, 0x7451, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 
        0x7451, 0x7451, 0x7451, 0x7431, 0x7431, 0x7431, 0x6C31, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x6C51, 0x6C51, 0x7452, 0x7452, 0x6C52, 0x7452, 0x7452, 0x7452, 0x6C51, 0x6C51, 0x6C51, 0x7431, 0x7431, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 
        0x6C31, 0x6C11, 0x6C10, 0x6C10, 0x6BF0, 0x6BF0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63CF, 0x63CF, 0x63AF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x5BAF, 0x63AF, 0x63AF,
  0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x9514, 0x8D14, 0x8D14, 
        0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9554, 0x9534, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 
        0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9534, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 
        0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9D75, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D96, 0x9D96, 0xA5B6, 0xADD6, 0xADD6, 0xB5D6, 
        0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xADD6, 0xADD6, 0xADB6, 0xA5B6, 0x9D96, 0x9D76, 0x9D76, 0x9556, 0x9555, 0x9555, 0x9D55, 0x9555, 0x9555, 0x9555, 0x9D55, 0x9555, 0x9555, 0x9555, 0x9555, 0x9D34, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9D12, 0xAD10, 0x94F4, 0x94F4, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF4, 0x8D14, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF4, 0x8CD4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CB3, 0x8CB3, 0x8CB3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8492, 0x84B2, 0x84B3, 0x8492, 0x8492, 0x8492, 0x84B3, 0x8492, 0x8492, 
        0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x8492, 0x8492, 0x8493, 0x84B2, 0x84B3, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 
        0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 
        0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8493, 0x8493, 0x84B3, 0x8493, 0x8493, 0x8493, 0x8493, 0x7C92, 0x7C92, 0x8493, 0x8492, 0x8493, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 
        0x8492, 0x7C92, 0x7C92, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 
        0x7472, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7472, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7452, 0x7C52, 0x7C52, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7472, 0x7472, 0x7472, 0x7452, 0x7452, 0x7452, 
        0x7451, 0x7451, 0x7451, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 
        0x7451, 0x7451, 0x7451, 0x6C31, 0x7431, 0x6C31, 0x6C51, 0x7451, 0x7452, 0x7451, 0x6C51, 0x7451, 0x7431, 0x7451, 0x7452, 0x7452, 0x7452, 0x6C52, 0x7452, 0x7452, 0x7452, 0x7451, 0x6C31, 0x6C51, 0x6C31, 0x6C31, 0x6C31, 0x6C51, 0x6C51, 0x6C31, 
        0x6C31, 0x6C31, 0x6C10, 0x6C10, 0x6BF0, 0x6BF0, 0x6BF0, 0x6BF0, 0x63F0, 0x63F0, 0x63D0, 0x63F0, 0x63F0, 0x63D0, 0x63D0, 0x63D0, 0x63D0, 0x63CF, 0x63CF, 0x5BCF, 0x5BCF, 0x5BAF, 0x5BCF, 0x5BAF, 0x63CF, 0x63CF, 0x63AF, 0x63AF, 0x63AF,
  0x8CF3, 0x8D14, 0x8D14, 0x8CF3, 0x8D14, 0x8D14, 0x8D14, 0x8CF4, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x9534, 0x9534, 0x9534, 0x9534, 0x8D14, 0x8D34, 0x8D14, 0x8D14, 0x8D14, 0x9534, 0x8D14, 0x9514, 0x9514, 0x9514, 0x9534, 
        0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9535, 0x9535, 0x9535, 0x9555, 0x9555, 0x9555, 0x9535, 0x9535, 0x9535, 0x9535, 0x9555, 0x9535, 0x9535, 
        0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9535, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9556, 0x9556, 0x9576, 0x9555, 0x9555, 0x9556, 0x9556, 0x9555, 
        0x9555, 0x9576, 0x9555, 0x9555, 0x9555, 0x9555, 0x9556, 0x9576, 0x9556, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9D55, 0x9D56, 0x9D76, 0x9D76, 0x9D75, 0x9576, 0x9D76, 0x9D76, 0x9D76, 0x9D96, 0x9D96, 0x9D96, 0xA5B6, 0xADD6, 0xADD6, 0xADD6, 
        0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xADD6, 0xADD6, 0xA5B6, 0xA5B6, 0x9D96, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9555, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9555, 0x9D55, 0x9D55, 0x9D55, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 
        0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0xAD73, 0xCDD2, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x94F4, 0x94F3, 0x8CF3, 0x8CF3, 0x94F4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF4, 0x8CF4, 0x8CF3, 
        0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CB3, 0x8CD3, 0x8CB3, 0x8CB3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B3, 0x84B2, 0x84B2, 0x84B3, 0x84B2, 0x8492, 0x8492, 0x84B3, 0x8492, 0x8492, 
        0x84B2, 0x84B2, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x84B3, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x8492, 0x8492, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 
        0x8CB3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8CB3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84D3, 0x8CD3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84D3, 0x84B3, 0x84B3, 
        0x84B3, 0x84B3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8493, 0x8493, 0x8493, 0x8493, 0x84B3, 0x84B3, 0x84B3, 0x8493, 0x8493, 0x8493, 0x8493, 0x8492, 0x7C92, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 
        0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7452, 0x7C52, 0x7452, 0x7452, 0x7472, 0x7452, 0x7472, 0x7452, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7452, 0x7452, 0x7472, 
        0x7451, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7451, 0x7451, 0x7452, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7431, 0x7451, 0x7452, 0x7451, 
        0x7451, 0x7451, 0x7431, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x6C52, 0x6C52, 0x6C31, 0x6C31, 0x6C51, 0x6C31, 0x7451, 0x7452, 0x6C52, 0x6C52, 0x6C51, 
        0x6C31, 0x6C31, 0x6C11, 0x6C11, 0x6C11, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6BF0, 0x6BF0, 0x63F0, 0x63F0, 0x63D0, 0x63F0, 0x63D0, 0x63D0, 0x63CF, 0x63CF, 0x63D0, 0x63D0, 0x63CF, 0x63CF, 0x63CF, 0x63CF, 0x63CF, 0x63CF, 0x63CF, 0x63CF,
  0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x9514, 0x8D14, 0x8D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 
        0x9534, 0x9535, 0x9535, 0x9535, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 
        0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9535, 0x9535, 0x9535, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9575, 0x9576, 0x9576, 0x9D76, 0x9576, 0x9576, 0x9576, 0x9576, 0x9575, 0x9575, 0x9575, 
        0x9575, 0x9576, 0x9576, 0x9556, 0x9576, 0x9576, 0x9576, 0x9576, 0x9D76, 0x9D76, 0x9575, 0x9576, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D96, 0x9D76, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0xA5B6, 0xA5B6, 0xA5B6, 0xADD6, 0xADD7, 
        0xADF7, 0xB5F6, 0xB5F6, 0xB5F7, 0xB5F7, 0xADD6, 0xA5B6, 0xA5B6, 0x9D96, 0x9D96, 0x9D96, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9576, 0x9D76, 0x9D76, 0x9575, 0x9D75, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D54, 0x9D34, 0x9534, 0x9534, 
        0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0xB573, 0xCE13, 0x94F3, 0x9514, 0x9514, 0x94F3, 0x94F3, 0x9513, 0x94F3, 0x9514, 0x94F3, 0x8CF3, 0x8CF3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 
        0x9513, 0x8CF3, 0x8CF4, 0x8CF3, 0x8CF3, 0x9513, 0x8CF3, 0x8CF3, 0x8D14, 0x9514, 0x9513, 0x9513, 0x8D14, 0x8D14, 0x8CF4, 0x8CF4, 0x8CF3, 0x8D13, 0x8CF3, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF4, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84B3, 0x8CD3, 0x84B3, 0x8CB3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B3, 0x8492, 0x8492, 0x8492, 0x84B3, 0x84B2, 
        0x8492, 0x8492, 0x8492, 0x8492, 0x84B2, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x84B3, 0x84B3, 0x84B3, 0x8492, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 
        0x8CB3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84D3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x84D3, 0x84D3, 0x84B3, 
        0x84B3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B3, 0x8492, 0x84B2, 0x8492, 0x8493, 0x8493, 0x7C92, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C72, 0x7C72, 
        0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7452, 0x7452, 0x7452, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7452, 
        0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7472, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7451, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7451, 0x7452, 0x7451, 0x7451, 0x7451, 
        0x7451, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7451, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x6C52, 0x6C52, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x6C52, 0x7452, 0x7431, 0x7431, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x6C52, 0x6C51, 
        0x7451, 0x7431, 0x7431, 0x6C11, 0x6C11, 0x6C10, 0x6C11, 0x6C31, 0x6C11, 0x6C10, 0x6BF0, 0x6BF0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63D0, 0x63CF, 0x63D0, 0x63D0, 0x63CF, 0x63CF, 0x63F0, 0x63EF, 0x63F0, 0x63F0, 0x63CF,
  0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x9514, 0x9514, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 
        0x9534, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9D55, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 
        0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9575, 0x9575, 0x9D75, 0x9576, 0x9D76, 0x9576, 0x9576, 0x9576, 0x9576, 0x9576, 0x9D76, 0x9D76, 0x9575, 
        0x9575, 0x9576, 0x9576, 0x9576, 0x9576, 0x9576, 0x9576, 0x9D96, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D96, 0x9D96, 0x9D96, 0x9D76, 0x9D96, 0x9D96, 0xA596, 0xA596, 0xA596, 0xA5B6, 0xA5B6, 0xADD6, 0xADD7, 0xADD7, 
        0xADD7, 0xADF7, 0xADF7, 0xADF7, 0xADD7, 0xA5D7, 0xA5B6, 0xA5B6, 0x9DB6, 0x9D96, 0x9D96, 0x9D96, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D75, 0x9D75, 0x9D55, 0x9D55, 0x9D55, 0x9D54, 0x9D34, 0x9534, 
        0x9534, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0xB593, 0xCE13, 0x94F3, 0x9514, 0x9514, 0x94F3, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x94F3, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x9513, 
        0x9513, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8D13, 0x8D14, 0x9514, 0x9514, 0x9514, 0x9514, 0x8D14, 0x8D14, 0x8CF4, 0x94F4, 0x9514, 0x9513, 0x9514, 0x94F4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x84B2, 0x8492, 0x84B2, 0x8492, 
        0x84B2, 0x8492, 0x8492, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x84B2, 0x8492, 0x84B2, 0x8492, 0x8492, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8CB3, 0x84B3, 
        0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8CB3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CB3, 0x8CB3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 
        0x84B3, 0x84D3, 0x84B3, 0x84B3, 0x84D3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x8492, 0x7C92, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 
        0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7C72, 0x7452, 0x7452, 0x7452, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7C52, 
        0x7452, 0x7452, 0x7472, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7472, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7451, 0x7451, 0x7451, 
        0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7451, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x6C31, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x6C51, 0x6C51, 
        0x7452, 0x6C31, 0x6C10, 0x6C11, 0x6C11, 0x6C11, 0x6C31, 0x6C31, 0x6C11, 0x6C11, 0x6BF0, 0x6BF0, 0x6BF0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x63D0, 0x63F0, 0x63F0, 0x63F0, 0x63F0, 0x6BF0, 0x63F0, 0x63F0, 0x63F0, 0x63F0,
  0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8D34, 0x8D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9554, 0x9534, 0x9554, 0x9555, 0x9534, 0x9554, 0x9534, 0x9534, 0x9554, 0x9534, 0x9534, 0x9554, 0x9554, 0x9534, 
        0x9554, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 
        0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9575, 0x9555, 0x9555, 0x9575, 0x9575, 0x9D76, 0x9D75, 0x9576, 0x9576, 0x9576, 0x9D76, 0x9D76, 0x9576, 0x9576, 0x9576, 0x9576, 0x9576, 
        0x9576, 0x9D76, 0x9D76, 0x9D76, 0x9576, 0x9576, 0x9D96, 0x9D96, 0x9D96, 0x9D76, 0x9D76, 0x9D76, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0xA596, 0xA596, 0x9D96, 0x9D96, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B7, 0xA5D6, 0xA5D7, 0xADD7, 
        0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADD7, 0xA5D7, 0xA5B7, 0xA5B6, 0xA5B7, 0xA5B6, 0x9DB6, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D75, 0x9D75, 0x9D55, 0x9D55, 0x9D54, 0x9D34, 
        0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0xB593, 0xCE13, 0x94F3, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x94F3, 0x94F3, 0x9513, 0x9513, 
        0x94F3, 0x8CF4, 0x8CF4, 0x8CF3, 0x8D13, 0x8CF3, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x94F4, 0x9514, 0x9514, 0x9514, 0x9514, 0x94F4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CB3, 0x8CD3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8492, 0x84B3, 0x8492, 0x84B2, 
        0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x8493, 0x8493, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x8493, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8CB3, 0x8CB3, 0x8CB3, 
        0x8CB3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84D3, 0x8CB3, 0x8CB3, 0x8CB3, 0x8CB3, 0x8CB3, 0x84B3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CB3, 0x8CB3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 
        0x84B3, 0x84D3, 0x84B3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 
        0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8493, 0x8492, 0x8492, 0x8492, 0x8493, 0x8493, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 
        0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7C72, 0x7C72, 0x7C72, 0x7452, 0x7472, 0x7472, 0x7472, 0x7452, 0x7C72, 0x7C72, 
        0x7472, 0x7472, 0x7472, 0x7452, 0x7472, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7451, 0x7451, 0x7451, 0x7452, 
        0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7472, 0x7452, 0x7452, 0x7452, 0x6C51, 0x7451, 0x7452, 0x7452, 0x7452, 0x7452, 0x7451, 0x7452, 0x7451, 
        0x7431, 0x6C31, 0x6C31, 0x6C11, 0x6C11, 0x6C11, 0x6C31, 0x6C31, 0x6C31, 0x6C11, 0x6C10, 0x6C10, 0x6BF0, 0x6BF0, 0x6BF0, 0x6BF0, 0x6BF0, 0x6BF0, 0x63F0, 0x63F0, 0x63F0, 0x6BF0, 0x6BF0, 0x6BF0, 0x6BF0, 0x63F0, 0x6BF0, 0x6BF0, 0x63F0,
  0x9514, 0x9514, 0x9534, 0x8D14, 0x8D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9D55, 0x9D55, 
        0x9D55, 0x9555, 0x9555, 0x9D55, 0x9555, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9555, 0x9555, 0x9555, 0x9575, 0x9D55, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9575, 
        0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9575, 0x9575, 0x9575, 0x9575, 0x9D55, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9576, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9576, 0x9576, 0x9596, 
        0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9596, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B7, 0xA5D6, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xADD7, 0xADD7, 
        0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADD7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5B7, 0xA5B7, 0xA5B7, 0x9DB6, 0x9DB6, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D76, 0x9D96, 0x9D96, 0x9D96, 0x9D76, 0x9D76, 0x9D75, 0x9D75, 0x9D75, 0x9D55, 0x9D55, 0x9D55, 
        0x9D55, 0x9D55, 0x9D54, 0x9D54, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0xB594, 0xCDF3, 0x94F3, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x9514, 
        0x94F4, 0x94F4, 0x94F4, 0x8CF4, 0x8D13, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x94F4, 0x9514, 0x9514, 0x9514, 0x8D14, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF4, 0x8CF3, 0x8CF4, 0x8CF4, 
        0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x8493, 0x84B3, 0x84B3, 0x84B3, 
        0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8CB3, 0x8CB3, 0x8CB3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8CB3, 0x8CB3, 0x8CB3, 
        0x8CB3, 0x8CB3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84D3, 0x84D3, 0x84B3, 0x8CB3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CB3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84B3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 
        0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x84B2, 0x8492, 
        0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C93, 0x8492, 0x84B2, 0x8492, 0x8493, 0x8493, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C93, 0x8493, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7472, 0x7472, 0x7C72, 0x7472, 0x7472, 
        0x7472, 0x7472, 0x7472, 0x7472, 0x7C72, 0x7472, 0x7472, 0x7472, 0x7472, 0x7452, 0x7452, 0x7452, 0x7452, 0x7472, 0x7452, 0x7472, 0x7452, 0x7452, 0x7452, 0x7472, 0x7472, 0x7452, 0x7452, 0x7472, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7452, 
        0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7472, 0x7452, 0x7452, 0x7472, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7451, 0x7451, 0x7452, 0x6C51, 0x6C51, 0x7451, 0x7451, 0x7451, 0x6C31, 
        0x7431, 0x6C31, 0x6C11, 0x6C11, 0x6C11, 0x6C11, 0x6C31, 0x6C31, 0x6C11, 0x6C11, 0x6C11, 0x6C11, 0x6C11, 0x6C11, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6C10,
  0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9D55, 0x9D55, 
        0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 
        0x9D75, 0x9D75, 0x9D55, 0x9D75, 0x9D55, 0x9555, 0x9555, 0x9555, 0x9555, 0x9575, 0x9D75, 0x9D76, 0x9575, 0x9576, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D96, 0x9D76, 0x9576, 0x9D76, 0x9D96, 0x9D76, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 
        0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5D6, 0xA5B6, 0xA5B7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xADF7, 0xADF7, 0xADF7, 
        0xB5F7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADD7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5B7, 0xA5B7, 0xA5B6, 0xA5B6, 0xA5B6, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D76, 0x9D76, 0x9D96, 0x9D75, 0x9D75, 0x9D75, 0x9D55, 0x9D55, 
        0x9D55, 0x9D54, 0x9D54, 0x9D55, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0xB594, 0xCDD3, 0x9513, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x8D13, 
        0x8D13, 0x9514, 0x8CF4, 0x8CF4, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x8D14, 0x9514, 0x8D14, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x8CF4, 0x9514, 0x94F4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 
        0x8CF4, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84B3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 
        0x84B3, 0x8CB3, 0x8CB3, 0x8CB3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8CB3, 0x8CB3, 0x84B3, 0x8CB3, 0x8CB3, 0x8CB3, 0x8CB3, 0x84B3, 0x84D3, 0x84B3, 0x84B3, 0x8CB3, 0x8CB3, 
        0x8CB3, 0x8CD3, 0x84D3, 0x84B3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 
        0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x84D3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 
        0x84B2, 0x84B2, 0x8492, 0x84B2, 0x8492, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x8492, 0x8493, 0x8493, 0x8493, 0x8493, 0x8493, 0x7C92, 0x8493, 0x7C93, 0x8492, 0x8492, 0x8492, 0x8CB2, 0xAD93, 0x8CB2, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7C72, 0x7C72, 0x7472, 0x7C72, 
        0x7C72, 0x7C52, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7452, 0x7452, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7C72, 0x7472, 0x7472, 0x7472, 0x7472, 0x7452, 0x7451, 0x7451, 0x7452, 0x7472, 0x7452, 
        0x7C72, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7472, 0x7452, 0x7452, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7452, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7431, 0x6C51, 0x6C31, 0x6C31, 
        0x6C31, 0x6C31, 0x6C11, 0x6C11, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C11, 0x6C31, 0x6C31, 0x6C31, 0x7431, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C11, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6C10, 0x6C10,
  0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9555, 0x9555, 0x9534, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9D75, 0x9555, 0x9555, 0x9555, 0x9575, 0x9555, 0x9D55, 0x9D55, 
        0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D75, 0x9D75, 0x9D75, 0x9D76, 0x9D76, 0x9D76, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 
        0x9D75, 0x9D75, 0x9D75, 0x9D55, 0x9D55, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D76, 0x9D96, 0x9D76, 0x9D76, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 
        0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9DB6, 0xA5B6, 0xA596, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5D6, 0xA5D6, 0xA5D6, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xADF7, 0xADF7, 0xADF7, 0xB5F7, 
        0xB618, 0xB618, 0xB617, 0xB617, 0xADF7, 0xADF7, 0xADF7, 0xADD7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D75, 0x9D75, 0xA575, 0xA575, 
        0x9D75, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D54, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0xB593, 0xCDD3, 0x9514, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9514, 0x9514, 0x8D14, 0x8D14, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x94F4, 0x94F4, 0x94F4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8CB3, 0x84B3, 
        0x84B3, 0x8CB3, 0x8CD3, 0x8CB3, 0x8CB3, 0x8CB3, 0x8CB3, 0x8CB3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8CB3, 0x8CB3, 0x84B3, 0x8CB3, 0x8CB3, 0x8CB3, 0x8CB3, 0x84B3, 0x84D3, 0x84D3, 0x84B3, 0x8CB3, 0x8CB3, 
        0x8CB3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CD3, 0x84D3, 0x8CD3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 
        0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x8493, 0x8493, 0x7C92, 0x7C92, 0x8493, 0x8493, 0x8492, 0x7C92, 0x8493, 0x8492, 0x84B2, 0x7C92, 0x8472, 0xC614, 0xFF95, 0xAD72, 0x7C71, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 
        0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7472, 0x7C72, 0x7452, 0x7472, 0x7C72, 0x7C52, 0x7472, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7451, 0x7451, 0x7452, 0x7472, 0x7472, 0x7452, 
        0x7452, 0x7472, 0x7472, 0x7472, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7472, 0x7472, 0x7452, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7452, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7431, 0x7431, 0x6C31, 0x6C31, 0x7431, 
        0x7431, 0x7431, 0x6C31, 0x7431, 0x6C31, 0x6C31, 0x6C31, 0x7431, 0x6C31, 0x7431, 0x7451, 0x7451, 0x7451, 0x7451, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C11, 0x6C11, 0x6C11, 0x6C11, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31,
  0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9555, 0x9555, 0x9554, 0x9554, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9D55, 0x9555, 0x9D55, 0x9D55, 0x9D55, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D55, 0x9D55, 
        0x9D55, 0x9D55, 0x9D54, 0x9D54, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D75, 0x9D75, 0x9D75, 0x9D76, 0x9D96, 0x9D95, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 
        0x9D75, 0x9D75, 0x9D75, 0x9D55, 0x9D55, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D76, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 
        0x9D96, 0x9D96, 0x9D96, 0x9D96, 0xA596, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5D7, 0xADD7, 0xADD7, 0xA5D7, 0xADD7, 0xA5D7, 0xA5D7, 0xADD7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xAE17, 0xB617, 
        0xB617, 0xB638, 0xB638, 0xB618, 0xB617, 0xB5F7, 0xADF7, 0xADF7, 0xADF7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA596, 0xA5B6, 0xA5B6, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0xA596, 0xA596, 0xA575, 0xA575, 0xA575, 
        0xA575, 0xA575, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D54, 0x9D54, 0x9D34, 0x9D54, 0x9D54, 0x9534, 0xB593, 0xC5D2, 0x9514, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9514, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x8D14, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 
        0x8CF4, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8CD3, 0x8CB3, 
        0x8CB3, 0x8CB3, 0x8CB3, 0x8CD3, 0x8CD3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8CB3, 0x8CB3, 0x84B3, 0x84B3, 0x8CB3, 0x8CB3, 0x84B3, 0x8CB3, 0x8CB3, 0x84B3, 0x8CB3, 0x8CB3, 0x8CD3, 0x84B3, 0x84B3, 0x84D3, 0x8CB3, 0x8CB3, 0x8CD3, 
        0x8CB3, 0x84B3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x84D3, 0x84B3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x84D3, 0x84D3, 0x8CB3, 0x84B3, 0x84D3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 
        0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8492, 0x84B3, 0x84B3, 0x84B3, 0x8493, 0x8493, 0x8492, 0x8493, 0x8492, 0x8492, 0x8493, 0x8493, 0x8492, 0x8492, 0xA553, 0xB5F5, 0xE6F4, 0xFF53, 0xDEB3, 0xCE34, 0xA532, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 
        0x7C72, 0x7C72, 0x7472, 0x7C52, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7472, 0x7472, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7451, 0x7452, 0x7451, 0x7451, 0x7452, 0x7452, 
        0x7452, 0x7472, 0x7472, 0x7472, 0x7C72, 0x7472, 0x7452, 0x7472, 0x7472, 0x7472, 0x7452, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7452, 0x7452, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7431, 0x7431, 0x7451, 0x6C31, 
        0x6C31, 0x7431, 0x7431, 0x7431, 0x6C31, 0x6C51, 0x7451, 0x7451, 0x7451, 0x7452, 0x7452, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x6C31, 0x6C31, 0x6C31, 0x7431, 0x7431, 0x7431, 0x6C31, 0x6C31, 0x6C31, 0x7451, 0x7451, 0x7451, 0x7451,
  0x9554, 0x9554, 0x9554, 0x9554, 0x9554, 0x9554, 0x9555, 0x9534, 0x9555, 0x9555, 0x9555, 0x9554, 0x9554, 0x9555, 0x9555, 0x9555, 0x9555, 0x9D55, 0x9D75, 0x9D55, 0x9D55, 0x9D75, 0x9D55, 0x9D55, 0x9D75, 0x9D75, 0xA595, 0xA595, 0x9D75, 0x9D55, 0x9D55, 
        0x9D55, 0x9D54, 0x9D34, 0x9D54, 0x9D55, 0x9D55, 0x9D54, 0x9D55, 0x9D55, 0x9D55, 0x9D75, 0x9D75, 0x9D75, 0x9D95, 0x9D95, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D95, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 
        0x9D75, 0x9D95, 0x9D75, 0x9D75, 0x9D55, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 
        0x9DB6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5D6, 0xA5D6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5D6, 0xA5B6, 0xA5D7, 0xADD7, 0xADF7, 0xB5F7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADD7, 0xADF7, 0xADF7, 0xB5F7, 0xB5F7, 0xB618, 0xB618, 0xB617, 
        0xB617, 0xB638, 0xBE38, 0xB638, 0xB617, 0xB617, 0xB617, 0xAE17, 0xADF7, 0xADF7, 0xADF7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA596, 0xA596, 0xA596, 0xA596, 0xA595, 
        0xA595, 0xA575, 0xA575, 0xA575, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9534, 0xBDD4, 0xCE12, 0x9514, 0x9534, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9514, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9534, 0x9514, 0x9514, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x8D14, 0x9514, 0x9514, 0x9514, 0x8CF4, 0x8D14, 0x8CF4, 0x8CF4, 0x8D14, 0x8CF4, 0x8CF4, 
        0x8CF4, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CB3, 0x84B3, 0x84B3, 0x84B3, 0x8CB3, 0x8CB3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84D3, 0x84D3, 0x8CB3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x8CB3, 0x8CB3, 0x84D3, 0x8CB3, 0x8CB3, 0x8CB3, 0x8CB3, 0x8CB3, 0x84B3, 0x84B3, 0x8CB3, 0x84B3, 0x8CB3, 0x8CD3, 0x8CB3, 0x8CB3, 0x8CB3, 0x8CB3, 0x8CB3, 0x8CB3, 0x8CB3, 
        0x8CB3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CB3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CB3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 
        0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8493, 0x8493, 0x8493, 0x8493, 0x8493, 0x8493, 0x8493, 0x84B3, 0x8493, 0x8492, 0xC615, 0xDE96, 0xD653, 0xEF14, 0xB592, 0xA512, 0x8CB2, 0x7C92, 0x8492, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 
        0x7C72, 0x7C72, 0x7472, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C52, 0x7C52, 0x7451, 0x7451, 0x7451, 0x7452, 0x7451, 0x7452, 
        0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7452, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7452, 0x7452, 0x7472, 0x7472, 0x7452, 0x7452, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 
        0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7452, 0x7472, 0x7452, 0x7452, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7452, 0x7452, 0x7452, 0x7472,
  0x9554, 0x9554, 0x9555, 0x9554, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9D54, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 
        0x9D55, 0x9D55, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D75, 0x9D95, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D95, 0x9D95, 0x9D95, 0x9D96, 0x9D96, 0x9D96, 
        0x9D96, 0x9D96, 0x9D95, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9DB6, 0x9DB6, 0x9DB6, 0x9DB6, 0x9DB6, 0x9DB6, 
        0x9DB6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5D6, 0xADD7, 0xADD7, 0xA5D7, 0xA5D7, 0xADD7, 0xADD7, 0xADD7, 0xADF7, 0xB5F7, 0xBE17, 0xBE17, 0xB617, 0xB5F7, 0xADF7, 0xADF7, 0xB5F7, 0xB617, 0xB617, 0xB617, 0xB617, 0xB638, 0xBE38, 0xBE38, 
        0xBE38, 0xBE38, 0xBE38, 0xBE38, 0xBE38, 0xB617, 0xB617, 0xB617, 0xAE17, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D6, 0xA5D7, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 
        0xA596, 0xA595, 0xA595, 0xA575, 0xA575, 0xA575, 0x9D55, 0x9D55, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9534, 0xC5D4, 0xCE12, 0x9514, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9514, 0x9534, 0x9534, 0x9514, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x8D14, 0x8D14, 0x94F4, 0x8CF4, 0x8D14, 0x8D14, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 
        0x8CF3, 0x8CF3, 0x8CF4, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8CB3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8CB3, 0x8CB3, 0x84D3, 0x84D3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CB3, 0x8CB3, 0x84D3, 0x8CD3, 0x8CB3, 0x8CB3, 0x8CD3, 0x8CD3, 0x8CB3, 0x8CD3, 0x8CD3, 0x8CB3, 0x8CB3, 0x8CB3, 0x8CB3, 0x84B3, 0x84D3, 0x8CD3, 
        0x8CB3, 0x8CB3, 0x8CB3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x84D3, 0x84B3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 
        0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B3, 0x84B3, 0x8492, 0x84B3, 0x8492, 0x84B3, 0x8493, 0x7C92, 0x8493, 0x8493, 0x8492, 0x8493, 0x8CB2, 0x8491, 0xA511, 0xE6D5, 0x8491, 0x84B2, 0x8492, 0x8492, 0x7C93, 0x8492, 0x7C92, 
        0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 
        0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C52, 0x7452, 0x7451, 0x7451, 0x7451, 0x7452, 0x7451, 0x7452, 
        0x7C52, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7452, 0x7472, 0x7472, 0x7472, 0x7C72, 0x7472, 0x7472, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7451, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 
        0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7452, 0x7452, 0x7452, 0x7472, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7451, 0x7452, 0x7451, 0x7451, 0x7471, 0x7472, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7472, 0x7472, 0x7472,
  0x9555, 0x9555, 0x9555, 0x9554, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9555, 0x9D55, 0x9D54, 0x9D55, 0x9D55, 0x9D55, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D54, 0x9D55, 0x9D55, 0x9D55, 
        0x9D55, 0x9D55, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D75, 0x9D75, 0xA595, 0xA595, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D95, 0x9D95, 0x9D95, 0x9D96, 0x9D96, 0x9D96, 
        0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D95, 0x9D95, 0x9D96, 0x9D96, 0xA595, 0x9D75, 0x9D75, 0xA596, 0xA596, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0x9D96, 0xA5B6, 0x9DB6, 0x9DB6, 0x9DB6, 0x9DB6, 0x9DB6, 0x9DB6, 
        0xA5B6, 0xA5B7, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5D6, 0xA5D6, 0xADD7, 0xADD7, 0xADD7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xB5F7, 0xBE17, 0xBE37, 0xBE37, 0xB637, 0xB617, 0xB617, 0xB617, 0xB617, 0xBE37, 0xBE38, 0xBE38, 0xBE38, 0xBE38, 0xC658, 0xC658, 
        0xC658, 0xC658, 0xC658, 0xC658, 0xBE38, 0xBE37, 0xB617, 0xB617, 0xB617, 0xB5F7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADD7, 0xA5D7, 0xA5D7, 0xA5D6, 0xA5D6, 0xA5D6, 0xA5B6, 0xA5D6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xADD6, 0xA5B6, 0xA5B6, 
        0xA5B6, 0xA595, 0xA595, 0xA595, 0xA575, 0xA575, 0xA575, 0x9D55, 0x9D55, 0x9D55, 0x9D54, 0x9D54, 0x9D34, 0xC5F4, 0xCDF2, 0x9514, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8CF4, 0x8CF4, 0x8D14, 0x8D14, 0x8D14, 0x8CF4, 0x8CF3, 
        0x8CF3, 0x8CF4, 0x8CF4, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84B3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CB3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84B3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 
        0x8CB3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CB3, 0x8CB3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x84D3, 0x84B3, 0x84B3, 
        0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x8493, 0x84B3, 0x84B2, 0x8492, 0x84B2, 0x8CB2, 0x8492, 0xAD52, 0xE6F5, 0x8CB1, 0x8CB2, 0x84B2, 0x8492, 0x8492, 0x8493, 0x8493, 
        0x7C92, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 
        0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7C72, 0x7452, 0x7452, 0x7451, 0x7452, 0x7451, 0x7452, 0x7C52, 
        0x7C52, 0x7451, 0x7472, 0x7472, 0x7472, 0x7452, 0x7472, 0x7C72, 0x7C52, 0x7C72, 0x7472, 0x7C72, 0x7C72, 0x7C72, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7452, 0x7452, 0x7452, 0x7452, 0x7451, 
        0x7452, 0x7451, 0x7451, 0x7451, 0x7452, 0x7452, 0x7452, 0x7452, 0x6C52, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7451, 0x7451, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7452, 0x7452, 0x7472, 0x7472, 0x7472,
  0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D55, 0x9555, 0x9555, 0x9D55, 0x9D54, 0x9D54, 0x9D55, 0x9D54, 0x9D54, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0xA575, 0x9D75, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D54, 0x9D55, 0x9D55, 0x9D55, 
        0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D54, 0x9D54, 0x9D54, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D75, 0x9D75, 0xA575, 0xA595, 0xA595, 0x9D75, 0x9D75, 0x9D95, 0xA596, 0xA596, 0x9D95, 0xA596, 0x9D96, 0x9D96, 0xA596, 0xA596, 0x9D96, 
        0x9D96, 0x9DB6, 0x9DB6, 0x9D96, 0x9D96, 0x9D96, 0xA596, 0x9D96, 0x9D96, 0xA596, 0xA596, 0xA596, 0xA596, 0x9D96, 0x9DB6, 0x9D96, 0x9DB6, 0x9DB6, 0x9DB6, 0x9DB6, 0x9DB6, 0x9DB6, 0x9DB6, 0xA5B6, 0x9DB6, 0x9DB6, 0x9DB6, 0x9DB6, 0x9DB6, 0xA5B7, 
        0xA5B7, 0xA5B7, 0xA5B6, 0xA5D7, 0xA5B7, 0xA5D7, 0xA5D6, 0xADD7, 0xADF7, 0xADF7, 0xADF7, 0xB5F7, 0xB5F7, 0xB617, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xCE58, 0xCE78, 
        0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xC658, 0xC658, 0xBE38, 0xBE38, 0xBE37, 0xB617, 0xB617, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADD7, 0xADD7, 0xADD7, 0xA5D7, 0xADD7, 0xADD7, 0xA5D7, 0xA5D7, 0xA5D6, 0xA5D6, 0xA5D6, 0xADD7, 0xADD6, 0xADD6, 
        0xADD6, 0xADB6, 0xADB6, 0xA595, 0xA595, 0xA575, 0xA575, 0xA575, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D54, 0xC5F4, 0xCE13, 0x9534, 0x9D54, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9534, 0x9514, 0x9534, 0x9514, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x94F4, 0x94F4, 0x9514, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8CF4, 0x8CF4, 0x8D14, 0x8D14, 0x8D14, 0x8CF4, 0x8CF4, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x8CB3, 0x8CB3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CB3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x84D3, 0x84D3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x84B3, 
        0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x8493, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x8CB2, 0x8492, 0xAD52, 0xE6F4, 0x8CB1, 0x84B2, 0x84B2, 0x84B2, 0x8493, 0x8492, 0x8492, 
        0x8493, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 
        0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7471, 0x7451, 0x7451, 0x7452, 0x7452, 0x7452, 0x7452, 
        0x7451, 0x7451, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7452, 0x7472, 0x7472, 0x7472, 0x7472, 0x7452, 0x7452, 0x7452, 0x7451, 0x7451, 0x7451, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 
        0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7492, 0x7472, 0x7472, 0x7472, 0x6C72, 0x6C72, 0x7472, 0x7472, 0x7472,
  0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xA575, 0x9D75, 0x9D55, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D55, 0x9D55, 0x9D55, 0x9D75, 0x9D75, 0x9D75, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 
        0x9D54, 0x9D55, 0x9D55, 0x9D55, 0x9D54, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D75, 0x9D75, 0xA575, 0xA595, 0xA596, 0x9D95, 0x9D96, 0xA596, 0xA596, 0xA596, 0xA596, 0x9D96, 0x9D96, 0xA596, 0xA5B6, 0xA5B6, 
        0xA5B6, 0x9DB6, 0x9DB6, 0x9DB6, 0xA5B6, 0x9DB6, 0x9DB6, 0x9DB6, 0xA596, 0xA596, 0xA596, 0xA596, 0xA596, 0xA5B6, 0x9DB6, 0xA5B6, 0xA5B6, 0xA5B7, 0x9DB6, 0x9DB6, 0x9DB6, 0xA5B7, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B7, 0xA5B7, 0xA5B7, 0xA5B7, 0xA5B7, 
        0xA5B7, 0x9DB7, 0x9DD7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xADD7, 0xADF7, 0xADF7, 0xADF7, 0xB617, 0xB617, 0xBE37, 0xBE37, 0xC637, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xC637, 0xBE37, 0xC637, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xCE78, 
        0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE58, 0xC658, 0xC658, 0xC637, 0xBE37, 0xBE17, 0xB617, 0xB617, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADD7, 0xADD7, 0xADD7, 0xADD7, 0xADD7, 0xADD7, 0xADD7, 0xADD7, 0xADD7, 0xADD7, 0xADD7, 0xADD7, 
        0xADD7, 0xADD6, 0xADD6, 0xADB6, 0xA596, 0xA595, 0xA595, 0xA575, 0xA575, 0x9D55, 0x9D55, 0x9D55, 0x9D54, 0xC5F4, 0xCDF3, 0x9534, 0x9D54, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9514, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 
        0x9534, 0x9514, 0x9514, 0x9514, 0x9534, 0x9534, 0x9534, 0x9514, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x94F4, 0x9514, 0x94F4, 0x8D14, 0x8D14, 0x8D14, 0x8D14, 0x8CF4, 0x8D14, 0x8D14, 0x8CF4, 0x8CF4, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x84D3, 0x84B3, 0x8CB3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8CB3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CB3, 0x8CB3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CD3, 0x84D3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 
        0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x8493, 0x8493, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0xB592, 0xE6B3, 0x8CB1, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x8492, 0x7C92, 
        0x84B2, 0x8492, 0x84B2, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 
        0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C72, 0x7C72, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7471, 0x7C51, 0x7451, 0x7451, 0x7452, 0x7452, 0x7451, 
        0x7452, 0x7C72, 0x7472, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7452, 0x7452, 0x7472, 0x7472, 0x7472, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 
        0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x6C72, 0x6C72, 0x6C72, 0x7472, 0x7472,
  0xB5D6, 0xB5D6, 0xB5D5, 0xADB5, 0xA595, 0xA574, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D55, 0x9D55, 0x9D55, 0x9D54, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D54, 0x9D54, 0x9D55, 0x9D55, 0x9D55, 
        0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0xA575, 0xA575, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0xA575, 0xA596, 0xA596, 0xA596, 0xA596, 0xA596, 0xA5B6, 0xA5B6, 0xA596, 0xA596, 0xA596, 0xA5B6, 0xA5B6, 0xA5B6, 
        0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0x9DB6, 0x9DB6, 0xA5B6, 0xA5B6, 0xA5B6, 0x9DB6, 0x9DB6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B7, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B7, 0xA5B6, 0xA5B6, 0x9DB6, 0xA5B6, 0xA5B7, 0xA5B7, 0xA5B7, 0xA5B7, 
        0xA5B7, 0xA5B7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xADD7, 0xADF7, 0xADF7, 0xADF7, 0xB617, 0xB617, 0xBE37, 0xC637, 0xC658, 0xC657, 0xC637, 0xC637, 0xC638, 0xC637, 0xC637, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 
        0xC658, 0xCE78, 0xCE58, 0xCE78, 0xCE78, 0xCE58, 0xCE58, 0xC658, 0xC658, 0xC637, 0xBE37, 0xBE37, 0xBE17, 0xB617, 0xB617, 0xB617, 0xB5F7, 0xB5F7, 0xB5F7, 0xB5F7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 
        0xB5F7, 0xADF7, 0xADF7, 0xADD6, 0xADB6, 0xADB6, 0xA595, 0xA575, 0xA575, 0x9D75, 0x9D55, 0x9D55, 0x9D55, 0xC5F4, 0xCDD2, 0x9D34, 0x9D54, 0x9D55, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 
        0x9534, 0x9534, 0x9534, 0x9514, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x8CF4, 0x8D14, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 
        0x8CF4, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x8CB3, 0x84D3, 0x84B3, 0x84B3, 0x84D3, 0x84B3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 
        0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8493, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0xC5F3, 0xEEF3, 0x94F2, 0x8492, 0x84B2, 0x84B2, 0x7C92, 0x7C92, 0x8492, 
        0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 
        0x7C72, 0x7C72, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C52, 0x7C52, 0x7C52, 0x7452, 
        0x7C72, 0x7C72, 0x7472, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7472, 0x7452, 0x7472, 0x7452, 0x7472, 0x7472, 0x7452, 0x7452, 0x7452, 0x7452, 0x6C52, 0x7452, 
        0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x6C52, 0x6C52, 0x7452, 0x7452, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7492, 0x7472, 0x7472, 0x6C72, 0x6C72, 0x7472, 0x7472, 0x7472,
  0xB5D5, 0xB5D5, 0xADB5, 0xAD95, 0xA595, 0xA575, 0xA575, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D55, 0x9D55, 0x9D55, 0x9D54, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D54, 0x9D55, 0x9D54, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 
        0x9D55, 0x9D75, 0x9D75, 0x9D75, 0x9D55, 0x9D55, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA595, 0xA596, 0xA596, 0xA596, 0xA596, 0xA596, 0xA596, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 
        0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B7, 0xA5B7, 0xA5B7, 0xA5B7, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0x9DD6, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 
        0xA5D7, 0xA5B7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xB617, 0xB617, 0xBE37, 0xC657, 0xC657, 0xC658, 0xC658, 0xC637, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 
        0xC658, 0xC658, 0xCE78, 0xCE78, 0xCE78, 0xCE58, 0xCE58, 0xC658, 0xC658, 0xC637, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xB617, 0xB617, 0xB617, 0xB617, 0xB617, 0xB5F7, 0xB5F7, 0xB5F7, 0xB5F7, 0xB5F7, 0xB5F7, 0xADF7, 0xADF7, 0xADF7, 
        0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADD7, 0xADB6, 0xA596, 0xA595, 0xA575, 0x9D75, 0x9D75, 0x9D55, 0x9D55, 0xC5F4, 0xC5D2, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9534, 0x9534, 
        0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9534, 0x9534, 0x9514, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x94F4, 0x8D14, 0x8D14, 0x8D14, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 
        0x8CF4, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CB3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CB3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 
        0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0xA511, 0xE6B4, 0x8CD1, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x8493, 
        0x7C93, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 
        0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 
        0x7C72, 0x7472, 0x7492, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7472, 0x7452, 0x7472, 0x7452, 0x7472, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x6C52, 0x6C32, 
        0x7432, 0x6C52, 0x6C32, 0x7452, 0x6C52, 0x6C52, 0x6C52, 0x6C32, 0x7452, 0x6C52, 0x6C52, 0x6C52, 0x7432, 0x6C52, 0x6C52, 0x7452, 0x7452, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x6C72, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472,
  0xB5D5, 0xADB5, 0xAD95, 0xAD95, 0xA595, 0xA595, 0xA575, 0xA574, 0xA574, 0xA574, 0xA574, 0x9D74, 0x9D74, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA555, 0x9D55, 0x9D55, 0x9D75, 0x9D75, 0x9D75, 0x9D55, 0x9D55, 0x9D75, 0x9D55, 0x9D55, 0x9D55, 
        0xA555, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0xA575, 0x9D75, 0xA575, 0xA595, 0xA595, 0xA575, 0xA575, 0xA595, 0xA595, 0xA596, 0xA596, 0xA5B6, 0xA5B6, 0xA5B6, 0xA596, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 
        0xA5B6, 0xA5B6, 0xA5D6, 0xA5D6, 0xA5D7, 0xA5D7, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B7, 0xA5B7, 0xA5B7, 0xA5B7, 0xA5B6, 0xA5B6, 0xA5D7, 0xA5B6, 0xA5B6, 0xA5D7, 0xA5D6, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 
        0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xADF7, 0xADF7, 0xADF7, 0xB617, 0xB617, 0xBE37, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC678, 0xC678, 
        0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE58, 0xCE58, 0xC658, 0xC658, 0xC658, 0xC657, 0xC657, 0xC637, 0xC637, 0xC637, 0xC637, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE17, 0xB617, 0xB5F7, 0xB617, 0xB617, 0xB617, 0xB617, 0xB617, 0xB617, 0xB5F7, 
        0xB617, 0xB617, 0xB5F7, 0xADF7, 0xADF7, 0xADD6, 0xADB6, 0xA595, 0xA575, 0xA575, 0xA575, 0xA575, 0x9D54, 0xC614, 0xCDF3, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 
        0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x94F4, 0x8D14, 0x8D14, 0x8D14, 0x8CF4, 0x8D14, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 
        0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CB3, 0x8CB3, 0x8CB3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x8CD3, 0x84D3, 0x8CD3, 0x84D3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 
        0x84D3, 0x84D3, 0x84B3, 0x84B3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x7CB2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0xA4F0, 0xDE32, 0x8CD1, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B2, 0x8493, 
        0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 
        0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 
        0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7C72, 0x7472, 0x7472, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x6C52, 0x6C52, 0x6C32, 0x6C32, 
        0x6C32, 0x6C31, 0x6C31, 0x6C32, 0x6C32, 0x6C32, 0x6C52, 0x6C51, 0x7451, 0x7452, 0x6C32, 0x6C32, 0x7432, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C72, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x6C72,
  0xB5D6, 0xADB5, 0xADB5, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xADB5, 0xB5D5, 0xADB5, 0xAD95, 0xAD95, 0xAD95, 0xADB5, 0xA595, 0xA595, 0xA595, 0xA595, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0x9D75, 0xA575, 0xA575, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0xA575, 
        0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA595, 0xA596, 0xA595, 0xA596, 0xA596, 0xA595, 0xA5B5, 0xA5B6, 0xADB6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5D6, 0xA5D7, 0xA5D6, 0xA5D6, 0xA5D7, 0xA5D6, 
        0xA5D6, 0xA5D6, 0xA5D6, 0xADF7, 0xB617, 0xB5F7, 0xADD7, 0xA5D7, 0xA5B6, 0xA5D6, 0xA5D6, 0xA5D6, 0xA5D6, 0xA5D6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5B6, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D6, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D7, 
        0xA5D7, 0xA5D7, 0xADD7, 0xA5F7, 0xA5F7, 0xADF7, 0xADF7, 0xB617, 0xB617, 0xB617, 0xBE37, 0xC658, 0xD698, 0xD698, 0xD698, 0xD678, 0xCE78, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC678, 0xC678, 0xC678, 0xC678, 0xC678, 0xC678, 0xCE78, 
        0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE58, 0xCE58, 0xC658, 0xC658, 0xC658, 0xC658, 0xC657, 0xC657, 0xC657, 0xC657, 0xC658, 0xC638, 0xC637, 0xBE37, 0xBE37, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xB617, 0xB617, 0xB617, 
        0xB617, 0xB617, 0xB617, 0xADF7, 0xADD6, 0xADB6, 0xA595, 0xA595, 0xA595, 0xA575, 0xA575, 0xA575, 0x9D55, 0xC5F4, 0xCDD3, 0x9D54, 0x9D55, 0x9D55, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9D34, 0x9534, 0x9534, 0x9D34, 
        0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9514, 0x9514, 0x8D13, 0x8D14, 0x8CF4, 0x94F4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF3, 
        0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CB3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CD3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 
        0x84D3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x8C91, 0xD632, 0xFF96, 0xCE13, 0x8492, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 
        0x8492, 0x8492, 0x8492, 0x84B2, 0x8492, 0x8492, 0x8492, 0x7C92, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7472, 0x7472, 0x6C52, 0x6C51, 0x6C31, 0x6C32, 0x6C32, 0x6C31, 
        0x6C32, 0x6C31, 0x6C31, 0x6C31, 0x6C32, 0x6C32, 0x6C31, 0x6C52, 0x6C52, 0x6C32, 0x6C32, 0x6C32, 0x6C32, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C72, 0x6C72, 0x7472, 0x7472, 0x7472, 0x7472, 0x6C72, 0x6C72, 0x6C72,
  0xB5D6, 0xB5B5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xB5D5, 0xB5F6, 0xBDF6, 0xB5F6, 0xADB5, 0xADB5, 0xB5D6, 0xB5F6, 0xB5D6, 0xB5D5, 0xADB5, 0xADB5, 0xA595, 0xA595, 0xA575, 0xA575, 0xA595, 0xA575, 0xA575, 0xA575, 0x9D75, 0x9D75, 0x9D75, 0x9D75, 0xA575, 
        0xA575, 0xA575, 0xA575, 0xA575, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xADB6, 0xADB6, 0xA596, 0xA596, 0xA595, 0xA5B6, 0xADD6, 0xADD6, 0xADF6, 0xADF6, 0xADF6, 0xADD6, 0xADD6, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xB617, 0xBE37, 0xB617, 
        0xADD7, 0xA5D7, 0xADF7, 0xBE37, 0xC657, 0xC637, 0xB617, 0xADF7, 0xA5D6, 0xA5D6, 0xA5D6, 0xA5D6, 0xA5D6, 0xA5D6, 0xA5D7, 0xA5D7, 0xA5D7, 0xA5D6, 0xA5D6, 0xA5D6, 0xA5D7, 0xA5D7, 0xA5D7, 0xADD7, 0xADD7, 0xA5D7, 0xA5D7, 0xADF7, 0xADF7, 0xADF7, 
        0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xB617, 0xB637, 0xBE38, 0xBE37, 0xC637, 0xCE78, 0xDEB9, 0xDEB8, 0xD698, 0xD698, 0xD678, 0xCE78, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xCE78, 0xCE78, 0xC678, 0xC678, 0xC678, 0xCE78, 0xCE78, 
        0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE58, 0xCE58, 0xC658, 0xC658, 0xC658, 0xC658, 0xC657, 0xC657, 0xC657, 0xC658, 0xC658, 0xC658, 0xC658, 0xC637, 0xBE37, 0xBE37, 0xBE37, 0xC637, 0xBE37, 0xBE17, 0xBE37, 0xBE17, 0xB617, 0xB617, 
        0xB617, 0xB617, 0xB617, 0xB5F7, 0xADD6, 0xADB6, 0xA595, 0xA595, 0xA595, 0xA595, 0xA575, 0xA575, 0x9D55, 0xC5F4, 0xC5B2, 0x9D54, 0x9D55, 0x9D55, 0x9D55, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9D34, 
        0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x8D13, 0x8D13, 0x8D14, 0x8CF4, 0x94F4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CB3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 
        0x8CD3, 0x8CD3, 0x84D3, 0x84B3, 0x84D3, 0x84B3, 0x84B3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x9CD1, 0xD610, 0xB54D, 0xACCE, 0x8CB2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x8492, 
        0x84B2, 0x8492, 0x8492, 0x84B2, 0x8492, 0x8492, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8493, 0x8493, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x7C92, 0x7C92, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C92, 0x7C72, 
        0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C92, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7452, 0x7452, 0x7452, 0x7452, 0x6C52, 0x6C51, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 
        0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C32, 0x6C31, 0x6C31, 0x6C32, 0x6C32, 0x6C32, 0x6C31, 0x6C32, 0x6C52, 0x6C31, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C72, 0x6C72, 0x7472, 0x6C72, 0x7472, 0x7472, 0x7472, 0x6C72, 0x6C72,
  0xADB5, 0xAD95, 0xAD95, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xB5D6, 0xB5D6, 0xB5D6, 0xADB5, 0xADB5, 0xADD5, 0xB5D6, 0xB5D6, 0xB5D5, 0xB5D6, 0xADB6, 0xADB6, 0xADB5, 0xAD95, 0xA595, 0xA595, 0xA595, 0xA595, 0xA575, 0x9D75, 0xA575, 0xA575, 0xA575, 0xA575, 
        0xA575, 0xA575, 0xA575, 0xA575, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xADB6, 0xADB6, 0xADB6, 0xA595, 0xA5B5, 0xA5B6, 0xADD6, 0xADD6, 0xB617, 0xB617, 0xB617, 0xB5F7, 0xB5F6, 0xB617, 0xBE37, 0xBE37, 0xBE37, 0xC657, 0xC658, 0xBE37, 
        0xB5F7, 0xADF7, 0xB617, 0xC657, 0xCE57, 0xC657, 0xC637, 0xBE17, 0xADF7, 0xADD7, 0xADD7, 0xADD7, 0xADD6, 0xA5D6, 0xA5D7, 0xA5D7, 0xA5D7, 0xADD7, 0xADD6, 0xADD7, 0xADD7, 0xADD7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 
        0xADF7, 0xADF7, 0xB618, 0xB638, 0xB617, 0xB617, 0xB617, 0xBE58, 0xCE78, 0xCE78, 0xCE98, 0xDEB9, 0xDEB9, 0xDEB9, 0xD698, 0xD698, 0xD678, 0xCE78, 0xC658, 0xC658, 0xC678, 0xC658, 0xC678, 0xC678, 0xC678, 0xC678, 0xC678, 0xC678, 0xCE78, 0xCE78, 
        0xCE78, 0xCE79, 0xCE79, 0xCE79, 0xCE78, 0xCE78, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC637, 0xC658, 0xC658, 0xC657, 0xC658, 0xC637, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 
        0xB637, 0xB617, 0xB617, 0xB617, 0xB5F7, 0xADD6, 0xADB6, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0x9D55, 0xBD92, 0xC592, 0x9D55, 0x9D55, 0x9D54, 0x9D55, 0x9D55, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 
        0x9534, 0x9534, 0x9534, 0x9534, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9514, 0x9514, 0x8D13, 0x9513, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF3, 0x8CF4, 0x8CF3, 0x8CF3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CD3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF4, 0x8CF4, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84B3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B3, 0x8C91, 0x9C09, 0x9C07, 0x73AC, 0x8CD3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 
        0x8492, 0x84B2, 0x7C92, 0x8492, 0x84B2, 0x7C92, 0x7C92, 0x8492, 0x84B2, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C72, 
        0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7472, 0x7472, 0x7452, 0x7452, 0x7452, 0x7452, 0x7452, 0x6C52, 0x6C32, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 
        0x6C31, 0x6C32, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C32, 0x6C52, 0x6C32, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472, 0x7472,
  0xA595, 0xA595, 0xA595, 0xA574, 0xA575, 0xA575, 0xA575, 0xA575, 0xA595, 0xA595, 0xAD95, 0xAD95, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB6, 0xADB6, 0xADB6, 0xADB5, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA575, 0xA575, 0xA575, 0xA575, 
        0xA575, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA5B6, 0xADB6, 0xADB6, 0xADD6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADB6, 0xADD6, 0xADD6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB617, 0xB617, 0xB617, 0xB616, 0xBE17, 0xBE17, 0xB616, 
        0xB5F7, 0xADF7, 0xB5F7, 0xBE17, 0xC637, 0xC637, 0xBE37, 0xBE37, 0xB617, 0xB5F7, 0xB617, 0xB617, 0xB5F7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F7, 0xB5F7, 0xB617, 0xBE37, 0xBE37, 0xBE17, 0xB617, 0xB617, 0xB617, 0xB5F7, 
        0xB5F7, 0xB617, 0xC658, 0xC658, 0xBE38, 0xB637, 0xBE37, 0xCE78, 0xD6B9, 0xDEB9, 0xDEB9, 0xDEB9, 0xDEB9, 0xDEB9, 0xD698, 0xD698, 0xCE78, 0xCE78, 0xC658, 0xC658, 0xC678, 0xC678, 0xC678, 0xC678, 0xC678, 0xC678, 0xC678, 0xCE78, 0xCE78, 0xCE78, 
        0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xC678, 0xC658, 0xC658, 0xC658, 0xBE58, 0xBE58, 0xBE58, 0xC638, 0xC638, 0xC637, 0xC658, 0xC658, 0xC658, 0xC658, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 
        0xBE37, 0xB637, 0xB617, 0xB617, 0xB5F7, 0xB5F6, 0xADD6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xA595, 0xA575, 0xC5B1, 0xCDD2, 0xA555, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 
        0x9534, 0x9534, 0x9534, 0x9534, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x94F3, 0x8CF4, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x94F3, 0x94F3, 0x8CF3, 0x8D13, 0x94F3, 0x8CF3, 
        0x8CF3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF4, 0x8CF4, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x84D3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8CB2, 0x8CB2, 0x84B3, 0x8492, 0xAD31, 0xEED3, 0x94D1, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 
        0x84B2, 0x84B3, 0x8492, 0x8492, 0x8492, 0x84B2, 0x84B2, 0x8492, 0x84B2, 0x8492, 0x8492, 0x8492, 0x7C92, 0x8492, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7472, 0x7472, 0x7472, 0x7452, 0x7452, 0x7452, 0x6C52, 0x6C32, 0x6C52, 0x6C32, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 
        0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C32, 0x6C32, 0x6C31, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x7472, 0x7472, 0x6C72, 0x7472, 0x7472, 0x7472, 0x7472,
  0xA574, 0xA575, 0xA575, 0xA575, 0xA575, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA575, 0xA575, 0xA595, 0xA575, 0xA575, 0xA595, 0xA595, 0xA595, 0xAD95, 0xADB5, 0xADB5, 0xADB5, 0xA5B5, 0xA595, 0xA595, 0xA595, 0xAD95, 0xAD95, 0xA595, 0xA595, 0xA595, 
        0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xADB6, 0xADB5, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 
        0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5F6, 0xBE17, 0xBE17, 0xB616, 0xB5F7, 0xBE17, 0xBE37, 0xBE17, 0xB617, 0xB5F6, 0xB617, 0xB5F7, 0xB5F6, 0xB616, 0xB5F6, 0xB617, 0xBE17, 0xBE37, 0xC637, 0xC657, 0xC657, 0xBE37, 0xBE37, 0xBE37, 0xB617, 
        0xB617, 0xBE17, 0xBE37, 0xC658, 0xC658, 0xBE58, 0xC658, 0xD698, 0xDEB9, 0xDED9, 0xDEB9, 0xDEB9, 0xD698, 0xD698, 0xD698, 0xD678, 0xCE78, 0xC658, 0xC637, 0xC658, 0xC658, 0xC678, 0xC678, 0xCE78, 0xCE78, 0xC678, 0xC678, 0xCE78, 0xCE78, 0xCE78, 
        0xCE78, 0xCE78, 0xCE79, 0xCE78, 0xCE78, 0xCE78, 0xC678, 0xC658, 0xC658, 0xBE58, 0xBE58, 0xBE38, 0xBE38, 0xBE38, 0xBE58, 0xC658, 0xC658, 0xC658, 0xC658, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE58, 0xBE57, 
        0xBE57, 0xBE37, 0xBE37, 0xBE37, 0xB617, 0xB617, 0xB5F7, 0xB5D6, 0xADD6, 0xADB6, 0xADB6, 0xADB5, 0xA575, 0xCDB0, 0xC56F, 0xA534, 0xA555, 0x9D55, 0x9D55, 0x9D54, 0x9D54, 0x9D55, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9534, 
        0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9D34, 0x9D54, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x94F4, 0x8CF3, 0x8CF4, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF4, 0x94F4, 0x94F3, 0x94F3, 0x9513, 0x94F3, 0x9513, 0x94F3, 0x94F3, 
        0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CB3, 0x8CB3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8CB2, 0x8CB3, 0x84B3, 0x8492, 0xA4F0, 0xF715, 0x94F1, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 
        0x84B3, 0x84B3, 0x84B3, 0x8492, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x8492, 0x8492, 0x7C92, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7452, 0x7452, 0x6C52, 0x6C51, 0x6C31, 0x6C31, 0x6C32, 0x6C31, 0x6C31, 0x6C31, 0x6C11, 0x6C11, 0x6C31, 
        0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C32, 0x6C31, 0x6C31, 0x6C52, 0x6C32, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C72, 0x6C72, 0x6C72, 0x7472,
  0xA574, 0xA574, 0xA575, 0xA575, 0xA575, 0xA575, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA575, 0xA575, 0xA575, 0xA575, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xADB5, 0xADB5, 0xADB6, 0xADB5, 0xADB5, 0xADB5, 0xADB6, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 
        0xAD95, 0xA595, 0xA595, 0xA5B5, 0xA595, 0xA595, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADB6, 0xADD6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xA5B6, 0xA5B5, 0xADB6, 
        0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xB5F6, 0xB616, 0xB617, 0xBE17, 0xBE17, 0xC637, 0xBE17, 0xB5F7, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F7, 0xB5F6, 0xB5F6, 0xB616, 0xBE37, 0xC637, 0xC657, 0xC657, 0xC657, 0xBE37, 0xBE37, 0xB617, 0xB5F7, 
        0xB5F7, 0xB617, 0xBE17, 0xBE37, 0xC637, 0xC658, 0xCE78, 0xDE98, 0xDEB9, 0xDEB9, 0xD698, 0xCE57, 0xC637, 0xCE58, 0xCE78, 0xCE58, 0xC637, 0xBE17, 0xBE17, 0xBE37, 0xC658, 0xC678, 0xC678, 0xC658, 0xC658, 0xC658, 0xC658, 0xC678, 0xCE78, 0xCE78, 
        0xCE78, 0xCE79, 0xCE79, 0xCE79, 0xCE79, 0xCE79, 0xCE78, 0xC678, 0xC678, 0xC658, 0xBE58, 0xBE38, 0xBE58, 0xBE58, 0xC658, 0xC658, 0xC658, 0xC658, 0xBE38, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xC638, 0xC658, 0xBE58, 
        0xBE58, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE17, 0xB617, 0xB5F7, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xAD95, 0xE60F, 0xDDAD, 0xA532, 0xA555, 0x9D55, 0x9D54, 0x9D54, 0x9D54, 0x9D55, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9534, 
        0x9534, 0x9534, 0x9534, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x8CF4, 0x8CF4, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF4, 0x8CF3, 0x8CF3, 0x9514, 0x94F3, 0x94F3, 0x94F3, 0x9513, 0x94F3, 0x94F3, 0x94F3, 
        0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CB3, 0x8CB3, 0x84D3, 0x84D3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x84B3, 0x84D3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x8CD2, 0x8CB3, 0x8CB3, 0x8492, 0xB50F, 0xFF14, 0xA532, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 
        0x84B2, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x84B2, 0x84B3, 0x84B2, 0x84B2, 0x7C92, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x8492, 0x7C92, 0x8492, 0x7C92, 0x8492, 
        0x8492, 0x8492, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7452, 0x6C52, 0x6C52, 0x6C51, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C11, 0x6411, 0x6C11, 0x6C31, 
        0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C32, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C32, 0x6C32, 0x6C52, 0x6C52, 0x6C52, 0x6C72, 0x6C52, 0x6C52, 0x6C52, 0x6C72, 0x6C72, 0x6C72, 0x7472,
  0xADB5, 0xB5B5, 0xADB5, 0xADB5, 0xADB5, 0xB5B5, 0xB5B5, 0xADB5, 0xAD95, 0xA595, 0xA595, 0xA595, 0xA595, 0xAD95, 0xAD95, 0xA595, 0xA595, 0xA595, 0xA595, 0xADB5, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5D6, 0xADD6, 0xADD6, 
        0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xB5D6, 0xADD6, 0xADD6, 0xADD6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xA5B6, 0xADB6, 
        0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xB5F6, 0xB617, 0xBE17, 0xBE17, 0xBE17, 0xB617, 0xB5F6, 0xB5F7, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F6, 0xBE37, 0xC658, 0xC657, 0xC637, 0xBE17, 0xB5F6, 0xB5F7, 0xB5F6, 
        0xB5F6, 0xB5F6, 0xB5F6, 0xB617, 0xB617, 0xBE37, 0xCE78, 0xD699, 0xD698, 0xC657, 0xBE37, 0xBE17, 0xB5F7, 0xB617, 0xBE17, 0xB617, 0xB5F7, 0xB5F7, 0xBE17, 0xBE37, 0xBE37, 0xBE38, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE38, 0xC658, 0xC658, 0xC678, 
        0xC678, 0xCE79, 0xCE78, 0xCE79, 0xCE99, 0xCE99, 0xCE79, 0xCE78, 0xC678, 0xC678, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xBE58, 0xBE38, 0xBE38, 0xBE38, 0xBE37, 0xBE37, 0xBE37, 0xC637, 0xC658, 0xC658, 0xC658, 0xC678, 
        0xBE58, 0xBE58, 0xBE38, 0xBE38, 0xBE38, 0xBE37, 0xBE37, 0xB617, 0xADD6, 0xADB6, 0xADB6, 0xADD6, 0xB5B4, 0xD58C, 0xC4C9, 0xAD12, 0xA575, 0x9D55, 0x9D55, 0x9D54, 0x9D54, 0x9D55, 0x9D54, 0x9D54, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9D34, 0x9D34, 
        0x9534, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x8CF4, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 
        0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x84D3, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x8CB3, 0x8492, 0xB50D, 0xFF13, 0xBD92, 0x8492, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 
        0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x7C92, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x84B2, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x84B2, 
        0x8492, 0x84B2, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7472, 0x7472, 0x7452, 0x7452, 0x7452, 0x6C52, 0x6C51, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C11, 0x6C11, 0x6411, 0x6431, 0x6C31, 
        0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C32, 0x6C31, 0x6C31, 0x6C32, 0x6C31, 0x6C31, 0x6C32, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x7472, 0x6C72, 0x6C72,
  0xBDF6, 0xBE16, 0xBE16, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xBDF6, 0xB5D5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xB5D5, 0xADD5, 0xADB5, 0xADB5, 0xADB5, 0xB5F6, 0xBE16, 0xBE16, 0xBE16, 0xBE17, 0xBE16, 0xBE37, 0xC637, 0xC637, 0xC637, 0xC636, 0xBE16, 
        0xBE16, 0xB5F6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xADD6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xAD96, 0xA5B5, 0xA5B5, 0xA595, 0xA595, 0xA595, 0xADB5, 0xADB5, 0xA595, 0xA5B5, 0xA5B6, 
        0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5D6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5F6, 0xBE17, 0xB617, 0xB5F6, 0xADD6, 0xADD6, 0xB5F7, 0xB5F6, 
        0xADF6, 0xADD6, 0xADD6, 0xB5F6, 0xB5F7, 0xB5F7, 0xBE17, 0xBE17, 0xBE17, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F7, 0xB5F7, 0xB5F7, 0xB617, 0xB617, 0xB617, 0xB617, 0xB617, 0xB617, 0xBE37, 
        0xBE37, 0xC638, 0xC638, 0xC658, 0xCE78, 0xCE99, 0xCE99, 0xCE79, 0xCE78, 0xC678, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC678, 0xC678, 0xC658, 0xC658, 0xC638, 0xBE38, 0xBE58, 0xBE58, 0xBE58, 0xC638, 0xC638, 0xC658, 0xC658, 0xC678, 0xC678, 
        0xC658, 0xBE58, 0xBE38, 0xBE38, 0xBE37, 0xBE37, 0xBE37, 0xB617, 0xB5F7, 0xADD6, 0xADB6, 0xADD6, 0xAD31, 0xC4EA, 0xD56B, 0xB530, 0xA575, 0xA555, 0x9D54, 0x9D54, 0x9D54, 0x9D55, 0x9D55, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 
        0x9D34, 0x9D54, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x8D14, 0x8CF4, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 
        0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x9513, 0x9514, 0x9514, 0x94F3, 0x9513, 0x9513, 0x9514, 0x9514, 0x94F3, 0x9514, 0x94F3, 
        0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x94F3, 0x94F3, 0x94F3, 
        0x8CF3, 0x8CF3, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84B3, 0x84B3, 0x8CB2, 0x8CB2, 0x8CD3, 0x84D3, 0x8C91, 0xCD4D, 0xFF13, 0xD653, 0x8492, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 
        0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x8492, 0x7C92, 0x84B2, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 
        0x8492, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x7CB2, 0x8492, 0x84B2, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7492, 0x7472, 0x7472, 0x7452, 0x6C52, 0x6C51, 0x7452, 0x6C31, 0x6C32, 0x6C31, 0x6C31, 0x6C31, 0x6C11, 0x6C11, 0x6C11, 0x6C31, 0x6C31, 
        0x6C11, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C32, 0x6C32, 0x6C32, 0x6C51, 0x6C31, 0x6C32, 0x6C31, 0x6C31, 0x6C32, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C72, 0x7452, 0x6C72,
  0xBDF6, 0xBE16, 0xC636, 0xCE57, 0xCE37, 0xCE36, 0xCE57, 0xCE57, 0xC636, 0xBE16, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 0xBE16, 0xBDF6, 0xB5D6, 0xB5D6, 0xB5F6, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xC637, 0xC637, 0xCE57, 0xCE57, 0xD678, 0xDE98, 0xD698, 0xD698, 
        0xD677, 0xC637, 0xBE16, 0xBE16, 0xBE16, 0xB5F6, 0xBE16, 0xBE17, 0xBE37, 0xBE17, 0xB5D6, 0xADD6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xA595, 0xA5B5, 0xA5B5, 0xADB5, 0xA595, 0xA595, 0xA595, 0xA5B5, 0xA595, 0xAD95, 0xA5B5, 
        0xA595, 0xAD96, 0xAD96, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 
        0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB617, 0xB617, 0xB617, 0xB617, 
        0xBE17, 0xBE17, 0xBE37, 0xC637, 0xC658, 0xCE99, 0xCE99, 0xCE99, 0xCE79, 0xCE78, 0xC678, 0xC678, 0xC678, 0xC658, 0xC678, 0xC678, 0xC678, 0xC678, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC678, 0xC658, 
        0xC658, 0xBE58, 0xBE38, 0xBE38, 0xBE38, 0xBE37, 0xBE17, 0xB617, 0xB617, 0xB5F6, 0xADD6, 0xAD95, 0xC590, 0xF6F1, 0xFF54, 0xDE31, 0xA533, 0x9D55, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 
        0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9514, 0x8D13, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 
        0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x94F3, 0x9513, 0x9513, 0x8CF3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD2, 0x8CD3, 0x84B3, 0x9CAF, 0xE5EE, 0xFF34, 0xF715, 0x94F1, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 
        0x84B3, 0x84B2, 0x84B2, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x84B2, 0x8492, 0x7C92, 0x7C92, 0x8492, 0x84B2, 0x84B2, 0x84B2, 0x8492, 
        0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x84B2, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 
        0x7CB2, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7472, 0x7472, 0x7472, 0x7452, 0x7452, 0x6C51, 0x7452, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C11, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 
        0x6C31, 0x6C31, 0x6C32, 0x6C32, 0x6C32, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C32, 0x6C52, 0x6C51, 0x6C51, 0x6C51, 0x6C31, 0x6C31, 0x6C52, 0x6C32, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C72,
  0xB5B5, 0xB5D5, 0xBDF6, 0xBE16, 0xC616, 0xC636, 0xCE57, 0xCE57, 0xCE57, 0xC616, 0xB5D6, 0xB5D5, 0xB5D6, 0xBDF6, 0xBE16, 0xBE16, 0xBDF6, 0xBDF6, 0xBDF6, 0xBE16, 0xBE16, 0xB5F6, 0xB5F6, 0xBE16, 0xC637, 0xCE77, 0xD677, 0xDE98, 0xDEB8, 0xDEB8, 0xDEB8, 
        0xDE98, 0xD678, 0xCE57, 0xC637, 0xC637, 0xBE37, 0xBE17, 0xBE37, 0xBE37, 0xBDF6, 0xB5D6, 0xADD6, 0xADB6, 0xADB6, 0xADB6, 0xADB5, 0xADB6, 0xAD96, 0xADB6, 0xA595, 0xADB6, 0xADB6, 0xADB6, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 
        0xA595, 0xA595, 0xA595, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 
        0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F7, 0xB5F7, 0xB617, 
        0xBE17, 0xBE17, 0xBE37, 0xC637, 0xCE58, 0xCE99, 0xD699, 0xCE98, 0xCE98, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xC678, 0xC678, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xBE58, 0xBE58, 0xC658, 0xC658, 
        0xC658, 0xBE58, 0xBE37, 0xBE37, 0xBE38, 0xBE38, 0xBE17, 0xBE17, 0xB617, 0xB5F7, 0xB5D6, 0xAD95, 0xCD6D, 0xCDAB, 0xBCEA, 0xB4CB, 0xA553, 0x9D55, 0x9D55, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 
        0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 
        0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8D13, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x94F3, 0x9514, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CD3, 
        0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 
        0x8CF3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CB2, 0xB50E, 0xEE2F, 0xFF34, 0xFF55, 0xBD92, 0x8492, 0x84D3, 0x8CD2, 0x8CB2, 0x84B2, 
        0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B2, 0x84B3, 0x8492, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B2, 0x8492, 0x8492, 0x8492, 0x8492, 0x84B2, 0x84B2, 0x84B2, 
        0x84B2, 0x84B2, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 
        0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7452, 0x7452, 0x7451, 0x7452, 0x7452, 0x6C51, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 
        0x6C31, 0x6C32, 0x7452, 0x6C52, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x7451, 0x7452, 0x6C51, 0x6C51, 0x6C51, 0x6C51, 0x6C51, 0x6C31, 0x6C52, 0x6C31, 0x6C51, 0x6C51, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52,
  0xA595, 0xA595, 0xAD95, 0xADB5, 0xADB5, 0xB5B5, 0xB5F6, 0xBE16, 0xC616, 0xBE16, 0xB5D6, 0xB5B5, 0xB5F6, 0xBE16, 0xBE16, 0xBE16, 0xBDF6, 0xB5D6, 0xB5D6, 0xB5D6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xBE16, 0xCE57, 0xCE77, 0xD677, 0xDE98, 0xDEB8, 0xDEB8, 
        0xDE98, 0xDE98, 0xD677, 0xCE57, 0xC657, 0xC657, 0xC657, 0xC657, 0xC637, 0xBE17, 0xBE16, 0xBE16, 0xB5F6, 0xB5D6, 0xADD6, 0xADD6, 0xADB6, 0xADB6, 0xA5B6, 0xA596, 0xA596, 0xA595, 0xADB6, 0xA595, 0xA595, 0xA595, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 
        0xA595, 0xA595, 0xA595, 0xA595, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xA5B6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 
        0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F7, 0xB5F7, 0xB5F7, 
        0xBE17, 0xBE17, 0xBE17, 0xC657, 0xCE78, 0xD698, 0xD699, 0xD699, 0xD698, 0xD678, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xC678, 0xC678, 0xC678, 0xC678, 0xC658, 0xC658, 0xC658, 0xBE58, 0xBE58, 0xC658, 0xC658, 
        0xBE58, 0xBE58, 0xBE38, 0xBE37, 0xBE38, 0xBE38, 0xBE37, 0xBE37, 0xBE37, 0xB617, 0xB5F7, 0xB5B5, 0xC50B, 0xC4A6, 0xCCE7, 0xC50B, 0xAD53, 0x9D75, 0x9D54, 0x9D54, 0x9D54, 0x9D55, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 
        0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x8CF3, 0x8D13, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 
        0x9513, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x94F3, 
        0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8D13, 0x8CF3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D3, 0x84D3, 0x8CD3, 0x8CD3, 0x8CB2, 0x9C8F, 0xD58F, 0xEE4F, 0xF6B0, 0xF692, 0xDDF1, 0xA4D0, 0x84B2, 0x8CB3, 0x8CB2, 0x84B3, 
        0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x84B2, 0x8492, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 
        0x84B2, 0x84B2, 0x8492, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x8492, 
        0x8492, 0x8492, 0x7C92, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7452, 0x7452, 0x7452, 0x6C51, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 
        0x6C32, 0x6C52, 0x7452, 0x7451, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x7452, 0x7452, 0x6C51, 0x6C51, 0x6C52, 0x6C51, 0x6C52, 0x6C51, 0x6C51, 0x6C51, 0x6C51, 0x6C51, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C32, 0x6C52, 0x6C52, 0x6C52, 0x6C52,
  0xA574, 0xA574, 0xA575, 0xA575, 0xA575, 0xA574, 0xA595, 0xAD95, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5D6, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB6, 0xADB6, 0xADD6, 0xB5D6, 0xB5F6, 0xB5F6, 0xBDF6, 0xBE17, 0xCE57, 0xD698, 
        0xDE98, 0xDE98, 0xD698, 0xCE77, 0xCE57, 0xCE57, 0xCE57, 0xCE77, 0xCE77, 0xCE77, 0xCE77, 0xCE77, 0xCE57, 0xC637, 0xBE16, 0xBE16, 0xB5F6, 0xADD6, 0xADB6, 0xADB6, 0xADB6, 0xA595, 0xA5B5, 0xA5B5, 0xA595, 0xA595, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 
        0xA595, 0xA595, 0xA595, 0xA595, 0xA5B6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 
        0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F7, 0xB5F7, 0xB5F7, 0xB5F7, 
        0xB617, 0xBE17, 0xBE37, 0xC658, 0xCE78, 0xD698, 0xD699, 0xD699, 0xD698, 0xD678, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE99, 0xCE79, 0xCE79, 0xCE78, 0xCE78, 0xCE78, 0xC678, 0xC658, 0xC658, 0xC658, 0xBE58, 0xBE58, 0xC658, 0xC658, 
        0xBE58, 0xBE38, 0xBE38, 0xBE38, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xB617, 0xB617, 0xB5D6, 0xAD10, 0xBC46, 0xB425, 0xA4AE, 0xA575, 0xA575, 0x9D54, 0x9D54, 0x9D54, 0x9D55, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D55, 0x9D55, 0x9D54, 0x9D54, 
        0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x8D13, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF4, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x94F3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x94F3, 0x9513, 0x8CF3, 0x8CF3, 0x94F3, 
        0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x9513, 0x94F3, 0x8CF3, 0x94F3, 0x94F3, 0x94F3, 0x8CF4, 0x8CF3, 0x8D13, 0x8CF3, 0x8D13, 0x9513, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD2, 0x8CD3, 0x8CD3, 0x8CD3, 0x8C91, 0x948F, 0xBD2E, 0xDDCF, 0xE60F, 0xEE4E, 0xEE50, 0xDDF0, 0xCD6F, 0xA4F0, 0x8CB1, 0x8CB2, 0x8CB2, 
        0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 
        0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x7C92, 
        0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7452, 0x7452, 0x7452, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 
        0x6C51, 0x7452, 0x7452, 0x7431, 0x6C31, 0x6C52, 0x6C51, 0x7452, 0x6C52, 0x6C52, 0x6C51, 0x6C31, 0x6C52, 0x6C52, 0x6C51, 0x6C51, 0x6C51, 0x6C51, 0x6C51, 0x6C51, 0x6C51, 0x6C31, 0x6C31, 0x6C51, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52,
  0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA575, 0xA575, 0xA575, 0xA575, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xAD95, 0xAD95, 0xADB5, 0xA5B5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xB5D6, 0xB5F6, 0xBE37, 
        0xCE57, 0xCE78, 0xCE57, 0xC637, 0xBE17, 0xBE17, 0xBE37, 0xC657, 0xD678, 0xD698, 0xD698, 0xD698, 0xD698, 0xD678, 0xCE77, 0xC657, 0xBE37, 0xBDF6, 0xB5F6, 0xADD6, 0xADB6, 0xADB6, 0xA5B5, 0xADB5, 0xADB5, 0xA595, 0xAD95, 0xAD95, 0xAD95, 0xA595, 
        0xAD95, 0xAD95, 0xA595, 0xA595, 0xA5B6, 0xADB6, 0xADB6, 0xADB6, 0xAD96, 0xADB6, 0xADB6, 0xA595, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 
        0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xADD6, 0xB5D6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F7, 0xB5F7, 0xB617, 0xBDF7, 
        0xBE17, 0xBE17, 0xBE17, 0xC637, 0xC658, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xC657, 0xC658, 0xCE58, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE79, 0xCE99, 0xCE79, 0xCE79, 0xCE78, 0xC678, 0xC678, 0xC658, 0xC658, 0xBE58, 0xBE58, 0xC658, 0xBE58, 
        0xBE58, 0xBE38, 0xBE38, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE17, 0xBE17, 0xBE17, 0xB617, 0xB5F7, 0xB573, 0xDD6B, 0xCD0A, 0xB532, 0xA575, 0xA575, 0xA575, 0x9D54, 0x9D55, 0x9D55, 0x9D55, 0x9D54, 0x9D54, 0x9D55, 0x9D55, 0x9D55, 0x9D54, 0x9D54, 
        0x9D54, 0x9D34, 0x9D54, 0x9D54, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x94F3, 0x9513, 0x9513, 0x94F3, 0x9513, 0x9513, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF4, 0x94F4, 0x8CF4, 0x9514, 0x8D14, 0x8D14, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x9513, 0x9514, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x9513, 0x94F3, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x94D3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x9513, 0x94F3, 0x8CF3, 0x8CF3, 0x94F3, 
        0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x9513, 0x9514, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x9513, 0x8CF3, 0x8CF3, 0x8D13, 0x8CF3, 0x8D13, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD2, 0x8C6F, 0xB4EE, 0xCD8F, 0xE5EF, 0xEE71, 0xF6F2, 0xFF13, 0xFF35, 0xF713, 0xF6D2, 0xEE71, 0xCDD1, 0x9CD1, 0x8CB2, 
        0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 
        0x84B2, 0x84B2, 0x8492, 0x8492, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x7C92, 0x8492, 0x8492, 0x8492, 0x7C92, 0x8492, 0x8492, 0x7C92, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7CB2, 
        0x7C92, 0x8492, 0x84B2, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7452, 0x7452, 0x7452, 0x7452, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C51, 
        0x7451, 0x7452, 0x7451, 0x7451, 0x6C51, 0x6C52, 0x6C52, 0x7452, 0x6C52, 0x6C52, 0x6C51, 0x6C51, 0x6C52, 0x6C52, 0x6C31, 0x6C31, 0x6C31, 0x6C51, 0x6C51, 0x6C51, 0x6C31, 0x6C31, 0x6C31, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52,
  0x9D74, 0xA574, 0xA574, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA5B5, 0xADB5, 0xADB5, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xB5D6, 
        0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5D6, 0xB5D6, 0xB5F6, 0xBE17, 0xCE57, 0xD698, 0xD698, 0xD698, 0xD698, 0xDE98, 0xD698, 0xCE78, 0xC637, 0xC637, 0xBE37, 0xBE16, 0xB5D6, 0xADB6, 0xADB6, 0xA5B5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xAD95, 0xAD95, 
        0xADB5, 0xADB5, 0xADB6, 0xADB6, 0xA595, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xA596, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 
        0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F7, 0xB5F6, 0xB5F7, 0xB617, 0xBE17, 0xBE17, 
        0xBE17, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xC657, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xC657, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE98, 0xD699, 0xCE99, 0xCE98, 0xCE78, 0xCE78, 0xC678, 0xC678, 0xC658, 0xBE58, 0xBE58, 0xBE58, 0xBE58, 
        0xBE58, 0xBE58, 0xBE38, 0xBE38, 0xBE38, 0xBE38, 0xBE37, 0xBE17, 0xBE17, 0xB616, 0xB5F6, 0xC5D4, 0xDD8C, 0xE5AA, 0xE56A, 0xDD8D, 0xBD72, 0xAD75, 0xA575, 0xA575, 0xA555, 0x9D55, 0x9D55, 0x9D55, 0x9D54, 0x9D54, 0x9D54, 0x9D55, 0x9D54, 0x9D54, 
        0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x94F3, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x9514, 0x9534, 0x9534, 0x9534, 0x9514, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x9513, 0x9513, 0x94F3, 0x9513, 0x9513, 0x94F3, 
        0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x8D13, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x9513, 0x8D13, 0x8D13, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8C6F, 0xB4ED, 0xD58E, 0xD5AE, 0xE5EE, 0xF690, 0xFEF2, 0xFF33, 0xFF75, 0xFF55, 0xFF55, 0xFF55, 0xFF35, 0xD612, 0x9CD0, 
        0x8CB2, 0x84B2, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 
        0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x84B2, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x84B2, 
        0x84B2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C92, 0x7C92, 0x7472, 0x7472, 0x7472, 0x7452, 0x7452, 0x7472, 0x7452, 0x6C51, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x7452, 0x7451, 
        0x7451, 0x7452, 0x7451, 0x7451, 0x6C52, 0x6C52, 0x6C51, 0x6C51, 0x6C51, 0x6C52, 0x6C51, 0x6C51, 0x6C31, 0x6C31, 0x6C32, 0x6C32, 0x6C32, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C32, 0x6C31, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52, 0x6C52,
  0x9D74, 0xA574, 0xA574, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA5B5, 0xADB5, 0xADB5, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 
        0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5F6, 0xBE17, 0xC637, 0xC637, 0xCE78, 0xD698, 0xCE78, 0xC657, 0xC657, 0xC658, 0xC657, 0xC637, 0xBE17, 0xB5D6, 0xADD6, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 
        0xADB5, 0xADB5, 0xADB6, 0xADB6, 0xA595, 0xADB6, 0xADB6, 0xADB5, 0xADB5, 0xAD95, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 
        0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F7, 0xB5F6, 0xB5F7, 0xB616, 0xB617, 0xBE17, 0xBE37, 0xBE37, 
        0xC637, 0xC637, 0xC637, 0xBE37, 0xBE37, 0xC637, 0xBE37, 0xBE17, 0xBE37, 0xBE37, 0xBE37, 0xC637, 0xC658, 0xCE58, 0xCE58, 0xCE58, 0xCE58, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xC678, 0xC678, 0xC678, 0xC658, 0xC658, 0xBE58, 0xBE58, 
        0xBE58, 0xBE58, 0xBE38, 0xBE38, 0xBE38, 0xBE38, 0xBE37, 0xB617, 0xB617, 0xB5F6, 0xBDB4, 0xC52C, 0xF62A, 0xEE2C, 0xEDEB, 0xE5AA, 0xCD0C, 0xAD53, 0xA554, 0xA575, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D54, 0x9D54, 0x9D55, 0x9D55, 0x9D54, 
        0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x94F3, 0x9513, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF4, 0x94F3, 0x9514, 0x9514, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9513, 0x94F3, 0x94F3, 0x8CF3, 0x94F3, 0x94F4, 0x9514, 0x9534, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x94F3, 0x8CF3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x94F3, 0x8CF3, 0x8CF3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x94F3, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9514, 0x9513, 0x9513, 0x9513, 0x9513, 
        0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x8D13, 0x9513, 0x9513, 0x9513, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8470, 0x9C6C, 0xCD4D, 0xDD8D, 0xDDAD, 0xEE0E, 0xF690, 0xF6F2, 0xFF12, 0xFF54, 0xFF55, 0xFF55, 0xFF75, 0xFF97, 0xFF33, 0xDDF0, 
        0x9CD1, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 
        0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x84B2, 0x7C92, 0x84B2, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 
        0x84B2, 0x84B3, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7472, 0x7452, 0x7452, 0x7452, 0x6C52, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C51, 0x6C51, 0x7452, 0x7451, 
        0x7452, 0x7451, 0x7451, 0x7431, 0x6C52, 0x6C32, 0x6C31, 0x6C31, 0x6C51, 0x6C52, 0x6C51, 0x6C31, 0x6C31, 0x6C31, 0x6C32, 0x6C31, 0x6C52, 0x6C32, 0x6C31, 0x6C31, 0x6C51, 0x6C31, 0x6C32, 0x6C52, 0x6C31, 0x6C31, 0x6C52, 0x6C52, 0x6C52,
  0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xAD95, 0xADB5, 0xADB6, 0xADB6, 0xADB5, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 
        0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5F6, 0xBE16, 0xBE37, 0xBDF6, 0xB616, 0xBE16, 0xBE17, 0xC637, 0xC657, 0xBE17, 0xB5F6, 0xB5D6, 0xADD6, 0xADB6, 0xADB5, 0xADB6, 0xADB6, 0xADB5, 0xADB5, 
        0xADB5, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB5, 0xADB5, 0xADB6, 0xAD95, 0xADB5, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADB6, 0xADD6, 0xADD6, 
        0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F7, 0xB5F6, 0xB616, 0xB616, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xC637, 0xC637, 
        0xCE58, 0xCE58, 0xC657, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xBE17, 0xBE37, 0xC637, 0xC637, 0xC637, 0xC657, 0xC657, 0xC658, 0xCE58, 0xC658, 0xC658, 0xC658, 0xC658, 0xC678, 0xC658, 0xC658, 0xC658, 0xC658, 0xBE58, 0xBE58, 
        0xBE58, 0xBE58, 0xBE38, 0xBE38, 0xBE38, 0xBE37, 0xBE17, 0xB637, 0xB617, 0xBDF6, 0xC5F5, 0xB4AC, 0xCCC7, 0xE5AA, 0xE5AB, 0xDDAB, 0xC50C, 0xB553, 0xAD74, 0xA575, 0xA575, 0xA555, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0x9D54, 0x9D54, 
        0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF4, 
        0x8CF3, 0x8CF4, 0x8CF4, 0x9514, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9513, 0x9513, 0x8CF3, 0x94F3, 0x94F3, 0x9514, 0x9514, 0x9534, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x94F3, 0x8CF3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x9513, 0x9514, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9514, 0x9514, 0x9513, 0x9513, 0x9513, 
        0x9513, 0x94F3, 0x9513, 0x9513, 0x9513, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x9514, 0x8D13, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8D13, 0x94F3, 0x8CF3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8491, 0x7BAB, 0xA46A, 0xCD4C, 0xE62E, 0xEE8F, 0xF6B1, 0xF6F2, 0xFF34, 0xFF55, 0xFF76, 0xFF55, 0xFF55, 0xFF55, 0xFF75, 0xFF34, 0xF6F2, 
        0xB52F, 0x8492, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 
        0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x84B2, 0x8492, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B2, 0x84B2, 
        0x8492, 0x84B2, 0x84B2, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7452, 0x7452, 0x7452, 0x7451, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C51, 0x6C51, 0x6C51, 0x7451, 
        0x6C51, 0x7431, 0x6C31, 0x7431, 0x6C31, 0x6C51, 0x7431, 0x6C52, 0x6C51, 0x6C51, 0x6C51, 0x6C31, 0x6C51, 0x6C31, 0x6C31, 0x6C31, 0x6C51, 0x6C51, 0x6C31, 0x6C31, 0x6C31, 0x6C51, 0x6C52, 0x6C32, 0x6C31, 0x6C31, 0x6C52, 0x6C52, 0x6C52,
  0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xADB6, 0xADB5, 0xADB5, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 
        0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xADD6, 0xB5F6, 0xB5F7, 0xBE17, 0xBE17, 0xB5F6, 0xB5D6, 0xB5D6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADB6, 0xADB5, 
        0xADB5, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xBDF5, 0xADD6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADB6, 
        0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F7, 0xB5F7, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE37, 0xBE37, 0xC637, 0xC657, 
        0xCE78, 0xCE78, 0xCE58, 0xCE57, 0xC657, 0xC657, 0xC637, 0xC637, 0xC637, 0xC637, 0xBE37, 0xBE37, 0xBE17, 0xC617, 0xBE17, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xC637, 0xC658, 0xC658, 0xC658, 
        0xC658, 0xC658, 0xC658, 0xC658, 0xBE37, 0xBE37, 0xBE37, 0xBE17, 0xC5F5, 0xDDF1, 0xDD8E, 0xDD4B, 0xDD49, 0xE56A, 0xE569, 0xDD09, 0xE58C, 0xDDAE, 0xCD70, 0xB594, 0xA555, 0xA555, 0xA555, 0xA555, 0x9D54, 0x9D55, 0x9D55, 0x9D54, 0x9D54, 0x9D54, 
        0x9D54, 0x9D54, 0x9D55, 0x9D55, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x94F4, 0x9514, 0x9514, 0x9514, 0x9514, 0x8D13, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF4, 0x8CF4, 0x9514, 0x9514, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x9514, 0x9514, 0x9534, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9514, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 
        0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x94F3, 0x94F3, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x9513, 0x94F3, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x9514, 0x9514, 0x9513, 0x9513, 0x9514, 
        0x9514, 0x9513, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x94F3, 0x9513, 0x9513, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x9513, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 
        0x8CF3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x840E, 0x7B68, 0xB4AA, 0xEE8F, 0xFF95, 0xFFB6, 0xFFB6, 0xFFB7, 0xFFB8, 0xFFB8, 0xFF97, 0xFF77, 0xFF57, 0xFF56, 0xFF76, 0xFF54, 0xF690, 
        0xA48C, 0x8470, 0x84B3, 0x84B2, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 
        0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 
        0x84B2, 0x8492, 0x84B2, 0x84B2, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7472, 0x7472, 0x7452, 0x7451, 0x6C31, 0x6C31, 0x6C31, 0x7431, 0x6C31, 0x6C31, 0x6C31, 0x6C51, 0x6C31, 
        0x6C31, 0x6C31, 0x6C31, 0x7451, 0x6C31, 0x6C31, 0x7452, 0x7452, 0x6C51, 0x6C51, 0x6C51, 0x6C31, 0x6C51, 0x6C31, 0x6C31, 0x6C51, 0x6C51, 0x6C51, 0x6C51, 0x6C31, 0x6C51, 0x6C51, 0x6C52, 0x6C52, 0x6C52, 0x6C31, 0x6C52, 0x6C52, 0x6C52,
  0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xADB6, 0xADB5, 0xADB5, 0xADB5, 0xAD96, 0xAD96, 0xADB6, 0xADB6, 0xADB6, 
        0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5D6, 0xB5D6, 0xADD6, 0xADD6, 0xADD6, 0xADB6, 0xADB6, 0xADB6, 
        0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xC615, 0xB5D6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 
        0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB616, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F7, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE37, 0xC637, 0xC637, 0xC637, 0xC637, 0xC657, 
        0xCE58, 0xCE58, 0xCE57, 0xCE57, 0xC657, 0xC657, 0xC637, 0xC637, 0xC637, 0xBE37, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xC637, 0xC637, 0xC658, 
        0xC658, 0xC657, 0xC637, 0xC637, 0xC637, 0xC637, 0xBDF5, 0xC570, 0xDD8D, 0xEDCB, 0xEDA9, 0xEDEB, 0xEDAA, 0xEDAA, 0xEDCA, 0xCCC8, 0xD508, 0xEDEB, 0xEDAB, 0xDD8D, 0xB552, 0xA554, 0xA554, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D55, 0x9D55, 0x9D55, 
        0x9D54, 0x9D55, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x8CF3, 0x9513, 0x94F3, 0x94F3, 0x9513, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF4, 
        0x8CF4, 0x8CF4, 0x9514, 0x9514, 0x9514, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x94F3, 0x94F3, 0x9513, 0x9514, 0x9514, 0x9534, 0x9534, 0x9534, 0x9514, 0x9534, 0x9534, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 
        0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 
        0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x9514, 0x9514, 0x9513, 0x9514, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x946E, 0x9C29, 0xDDCC, 0xFFD5, 0xFFF7, 0xFFD6, 0xFF74, 0xF6F2, 0xEEB2, 0xEED2, 0xE671, 0xE691, 0xEEB2, 0xF6F3, 0xFF13, 0xFF12, 0xEE2E, 
        0xA44A, 0x842F, 0x84D3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 
        0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 
        0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x7C92, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7472, 0x7472, 0x7452, 0x7451, 0x7451, 0x7451, 0x6C51, 0x6C51, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 
        0x6C31, 0x6C51, 0x7431, 0x7431, 0x6C31, 0x6C51, 0x6C51, 0x6C51, 0x6C51, 0x6C51, 0x7431, 0x7451, 0x6C31, 0x6C31, 0x6C31, 0x6C51, 0x6C51, 0x6C51, 0x6C51, 0x6C51, 0x6C51, 0x6C31, 0x6C51, 0x6C51, 0x6C51, 0x6C52, 0x6C32, 0x6C52, 0x6C52,
  0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA5B5, 0xA5B5, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xADB6, 0xADB6, 0xADB6, 
        0xADB6, 0xADB6, 0xADB5, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 
        0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5F6, 0xCE35, 0xB5F6, 0xB5F6, 0xB5D6, 0xB5D6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 
        0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDF6, 0xB616, 0xB5F6, 0xBE17, 0xBE17, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xC657, 0xC657, 0xC657, 0xCE57, 
        0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xC657, 0xC637, 0xC637, 0xC637, 0xC617, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xC637, 0xC637, 0xC637, 0xBE37, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE37, 0xBE37, 
        0xC657, 0xC657, 0xC637, 0xC637, 0xC5F5, 0xBD72, 0xC52F, 0xCCE9, 0xE58A, 0xEDEC, 0xE58A, 0xE589, 0xE5AA, 0xE56A, 0xE58B, 0xCCC8, 0xCCC8, 0xDD69, 0xE5AA, 0xE569, 0xE5CD, 0xC571, 0x9C8F, 0xA512, 0xA554, 0x9D54, 0x9D54, 0xA555, 0x9D55, 0x9D55, 
        0x9D54, 0x9D55, 0x9D55, 0x9D54, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9514, 0x9514, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x9514, 0x9513, 0x9514, 0x9513, 0x94F3, 0x94F4, 
        0x94F4, 0x94F4, 0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9534, 0x9514, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9534, 
        0x9534, 0x9534, 0x9514, 0x9514, 0x9534, 0x9534, 0x9514, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x94F3, 0x9513, 0x94F3, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 
        0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x9513, 0x94F3, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0xBD70, 0xBCAA, 0xC4C9, 0xD58C, 0xCD4A, 0xBCC9, 0xAC67, 0x9C07, 0x93A6, 0x8366, 0x8346, 0x7B46, 0x7B26, 0x8BA7, 0x93E7, 0xAC28, 0xB449, 
        0xB48B, 0xA511, 0x84B2, 0x8CB2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84D2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8CB2, 
        0x8CB2, 0x84B2, 0x84B2, 0x84B2, 0x8CB2, 0x84B2, 0x84D2, 0x84D2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 
        0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x7C92, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x6C51, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C51, 0x6C51, 
        0x6C31, 0x6C51, 0x7431, 0x7431, 0x7431, 0x7431, 0x6C51, 0x6C51, 0x6C51, 0x6C31, 0x6C31, 0x6C31, 0x6C51, 0x6C51, 0x6C31, 0x6C31, 0x6C31, 0x6C51, 0x6C31, 0x6C51, 0x6C51, 0x6C51, 0x6C51, 0x6C51, 0x6C31, 0x6C31, 0x6C31, 0x6C52, 0x6C52,
  0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA574, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA595, 0xA575, 0xA575, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA5B5, 0xAD95, 0xAD95, 0xA5B5, 0xADB5, 0xADB6, 0xADB6, 0xADB6, 
        0xADB6, 0xADB6, 0xADB5, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5D6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 
        0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 0xBDF6, 0xCE35, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 
        0xADD6, 0xADD6, 0xB5D6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xBE16, 0xBE16, 0xBE16, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xC637, 0xC637, 0xC637, 0xC657, 0xC657, 0xCE57, 0xCE77, 0xCE77, 0xCE77, 0xCE77, 
        0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xCE58, 0xCE58, 0xCE57, 0xC657, 0xC637, 0xC637, 0xC637, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBDF6, 0xBE17, 0xBDF7, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 
        0xBE37, 0xC637, 0xC637, 0xC616, 0xC571, 0xB46A, 0xBC68, 0xDD6A, 0xF66D, 0xD549, 0xDD8B, 0xE5CB, 0xD58A, 0xCD4A, 0xD56B, 0xD56A, 0xDDAB, 0xE60D, 0xDD8B, 0xD52A, 0xCCE9, 0xCD0C, 0xB48C, 0xB50F, 0xA554, 0x9D55, 0x9D55, 0x9D54, 0x9D54, 0x9D54, 
        0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9534, 0x9514, 0x9514, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x9513, 0x9514, 0x9514, 0x9513, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x94F3, 0x9514, 0x9514, 0x9514, 0x9534, 0x9534, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 
        0x9D34, 0x9534, 0x9514, 0x9514, 0x9534, 0x9514, 0x9514, 0x9513, 0x9513, 0x9514, 0x9513, 0x9513, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 
        0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9514, 0x9514, 0x9D14, 0x9514, 0x9D14, 0x9513, 0x9513, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9514, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9514, 0x9514, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x94F3, 
        0x8CF3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x94F3, 0xB50F, 0x8366, 0x72E5, 0x8B25, 0xA3A6, 0x8B45, 0x8346, 0x8326, 0x72E5, 0x6AA4, 0x72E5, 0x5A65, 0x41C4, 0x4A04, 0x5224, 0x5245, 0x5A65, 
        0x93E9, 0xB593, 0x84B2, 0x8CD2, 0x8CD2, 0x8CB2, 0x84B2, 0x84B2, 0x84B2, 0x8CD2, 0x8CD2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8CB2, 0x8CB2, 0x8CB2, 0x8CB2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8CD2, 0x8CB2, 0x84B2, 
        0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8CB2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B2, 0x84B2, 
        0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x6C31, 0x6C31, 0x6C51, 0x6C31, 0x6C31, 0x6C51, 0x7451, 
        0x7451, 0x6C51, 0x6C31, 0x7451, 0x6C51, 0x6C51, 0x6C51, 0x7451, 0x7431, 0x7451, 0x7431, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C51, 0x6C51, 0x6C51, 0x6C51, 0x6C31, 0x6C31, 0x6C31, 0x6C51, 0x6C52,
  0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA574, 0xA574, 0xA575, 0xA575, 0xA575, 0xA595, 0xA575, 0xA575, 0xA575, 0xA575, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xAD95, 0xAD95, 0xAD95, 0xA595, 0xA5B5, 0xA595, 0xA595, 0xAD95, 
        0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5D6, 0xADD6, 0xADD6, 0xADD6, 
        0xADD6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F6, 0xBDF6, 0xCE55, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xADD6, 0xADD6, 0xB5D6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 
        0xB5D6, 0xADD6, 0xB5D6, 0xB5D6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB616, 0xBE17, 0xBE17, 0xBE16, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xC617, 0xC637, 0xC637, 0xC637, 0xC657, 0xCE57, 0xCE77, 0xCE78, 0xCE78, 0xD678, 0xD678, 
        0xCE77, 0xCE78, 0xCE78, 0xCE77, 0xCE77, 0xCE78, 0xCE57, 0xCE57, 0xC657, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBDF7, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDF7, 0xBDF7, 0xBDF7, 0xBDF7, 0xBDF7, 
        0xBE17, 0xBE16, 0xB572, 0xCDAF, 0xC4C8, 0xBC46, 0xBC46, 0xD528, 0xF6CF, 0xDDA8, 0xEE6D, 0xEE8F, 0xE66E, 0xDE2D, 0xDE2D, 0xD5CB, 0xD5CB, 0xDE2E, 0xD569, 0xDD69, 0xD529, 0xBC67, 0xBC46, 0xD56C, 0x9CD0, 0x9D54, 0xA555, 0x9D54, 0x9D54, 0x9D54, 
        0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x9513, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 
        0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x9513, 0x94F3, 0x9513, 0x94F3, 
        0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9514, 0x9D14, 0x9D14, 0x9514, 0x9D14, 0x9D33, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9534, 0x9514, 0x9514, 0x9534, 0x9514, 0x9514, 0x9513, 0x9534, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 
        0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x94F3, 0x9CAF, 0x6AC5, 0x6264, 0x8305, 0x9366, 0x9345, 0x9345, 0x9345, 0x8B25, 0x7B05, 0x6AC4, 0x5A44, 0x41A3, 0x3162, 0x3162, 0x31A3, 0x41C4, 
        0x83A9, 0xA532, 0x84B2, 0x84D2, 0x8CD3, 0x8CD2, 0x8CD2, 0x84D3, 0x8CD2, 0x8CD2, 0x8CD2, 0x84D2, 0x8CD2, 0x84B2, 0x8CD2, 0x8CD2, 0x8CB2, 0x8CB2, 0x8CB2, 0x8CB2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84D2, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CB2, 0x84D2, 
        0x84B2, 0x84D2, 0x84D2, 0x84D2, 0x84B2, 0x84D2, 0x84B2, 0x84B2, 0x8CB2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x84B2, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 
        0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7472, 0x7451, 0x7451, 0x7451, 0x7451, 0x7431, 0x7431, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x7451, 
        0x7431, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x6C51, 0x6C31, 0x7431, 0x7451, 0x7451, 0x7431, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C51, 0x6C31, 0x6C51, 0x6C51, 0x6C51, 0x6C51, 0x6C31, 0x6C31, 0x6C31, 0x6C31,
  0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA595, 0xA575, 0xA575, 0xA575, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA5B5, 0xA595, 0xA5B5, 0xA595, 0xA5B5, 0xA595, 0xADB6, 0xADB6, 
        0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xA5B6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xA5B6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 
        0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xBE16, 0xCE56, 0xB5F6, 0xB616, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5D6, 0xB5F6, 0xB5D6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 
        0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xBE16, 0xBE16, 0xBE17, 0xBE16, 0xBE17, 0xBE17, 0xBE17, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xC657, 0xCE57, 0xCE57, 0xCE77, 0xCE78, 0xD678, 0xD678, 0xD678, 
        0xD678, 0xD678, 0xD678, 0xD678, 0xCE78, 0xCE78, 0xCE57, 0xCE57, 0xCE57, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xB5F6, 0xB5F6, 0xB5F6, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDF6, 
        0xBDF6, 0xB5F6, 0xB551, 0xDE0E, 0xEE6C, 0xEDE9, 0xE5EB, 0xEE4C, 0xE60A, 0xF6AB, 0xFF73, 0xFF75, 0xFF74, 0xFF75, 0xFF75, 0xFF94, 0xEE6C, 0xDDEB, 0xF6CF, 0xF66D, 0xF64C, 0xEE0B, 0xDD07, 0xBC86, 0xB50C, 0xBDB3, 0xA554, 0x9D54, 0x9D54, 0x9D54, 
        0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x8D13, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 
        0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9513, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x94F3, 0x9513, 0x9513, 0x9513, 0x94F3, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x94F3, 
        0x94F3, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9D14, 0x9D13, 0x9D14, 0x9D34, 0x9D34, 0x9D34, 0x9D33, 0x9D34, 0x9534, 0x9D34, 0x9534, 0x9534, 0x9514, 
        0x9D14, 0x9D34, 0x9533, 0x9534, 0x9534, 0x9534, 0x9534, 0x9D34, 0x9D14, 0x9514, 0x9533, 0x9513, 0x9514, 0x9514, 0x9513, 0x9514, 0x9514, 0x9514, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9514, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 
        0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x94D1, 0x6B07, 0x6A84, 0xA3A5, 0xBC44, 0xD526, 0xDD66, 0xE586, 0xDD46, 0xD4E6, 0xC4A5, 0xBC66, 0xBC86, 0xB446, 0xA3E5, 0x6A84, 0x41C2, 
        0x8BEC, 0x94F3, 0x8CB2, 0x8CD2, 0x8CD2, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD2, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CD3, 0x8CB2, 0x8CB2, 0x8CD2, 0x8CB2, 0x8CB2, 0x8CB2, 0x8CD2, 0x8CD2, 0x84D2, 0x8CD3, 0x8CD3, 0x8CD2, 0x8CD2, 0x8CD2, 
        0x8CD2, 0x8CD2, 0x8CD2, 0x8CB2, 0x8CB2, 0x8CD2, 0x8CD2, 0x8CB2, 0x8CB2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84D2, 0x8CD2, 0x84B2, 0x84B2, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B3, 0x84B2, 0x84B2, 
        0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7451, 0x7451, 0x7451, 0x7451, 0x7431, 0x7451, 0x7431, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x7451, 
        0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x6C51, 0x7451, 0x7451, 0x7451, 0x7431, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C51, 0x7431, 0x6C31, 0x6C51, 0x6C51, 0x6C31, 0x6C31, 0x6C31, 0x6C51, 0x6C31, 0x6C31,
  0xA574, 0xA574, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA5B5, 0xA5B5, 0xA595, 0xA5B5, 0xA5B5, 0xA5B5, 0xA595, 0xA595, 0xADB6, 
        0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xA5B6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 
        0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xADF6, 0xB5F6, 0xB5F6, 0xBE16, 0xCE56, 0xB5F6, 0xB616, 0xB5F6, 0xB5F6, 0xB616, 0xB616, 0xB5F6, 0xB616, 0xB616, 0xB616, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 
        0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xBDF6, 0xBE16, 0xBE16, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xC637, 0xC637, 0xC637, 0xC637, 0xC657, 0xCE57, 0xCE57, 0xCE57, 0xCE77, 0xCE78, 0xCE78, 0xD678, 0xD678, 0xD678, 
        0xD698, 0xD698, 0xD698, 0xD698, 0xD678, 0xD678, 0xCE77, 0xCE78, 0xCE57, 0xCE57, 0xCE57, 0xC657, 0xC637, 0xC637, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBDF6, 0xBDF6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xBDF6, 0xBDF6, 0xBDF6, 0xBE16, 
        0xBE16, 0xB5F6, 0xC615, 0xE670, 0xFF0E, 0xFF30, 0xFEEF, 0xEE4C, 0xEE0A, 0xF68B, 0xFF73, 0xFF96, 0xFF96, 0xFF96, 0xFF96, 0xFF74, 0xF66B, 0xDDAA, 0xF711, 0xFF73, 0xFF52, 0xFF32, 0xF62A, 0xE568, 0xEEB1, 0xBD93, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 
        0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x94F3, 0x9514, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9534, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9514, 0x9534, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 
        0x9D34, 0x9D34, 0x9534, 0x9534, 0x9514, 0x9513, 0x9513, 0x9D13, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x9513, 0x94F3, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 
        0x9513, 0x9513, 0x94F3, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9533, 0x9533, 0x9533, 0x9533, 0x9533, 0x9533, 0x9D34, 0x9D34, 0x9D33, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9534, 
        0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D33, 0x9D33, 0x9534, 0x9D34, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x9514, 0x9513, 0x94F3, 0x9513, 0x9513, 0x94F3, 0x94F3, 
        0x9513, 0x9513, 0x9513, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CF3, 0x94F3, 0x946E, 0x9BE8, 0xCCA8, 0xEDEA, 0xEE4C, 0xDDCC, 0xE5ED, 0xDDAC, 0xD58C, 0xCD4C, 0xCD6C, 0xDDCD, 0xDDCD, 0xDDCD, 0xC4EB, 0x940A, 
        0x9490, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD2, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CD3, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CD3, 0x8CB2, 0x8CB2, 0x8CB3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD2, 0x8CD3, 0x8CD3, 0x8CD2, 
        0x8CD3, 0x8CD3, 0x8CB2, 0x8CB2, 0x8CB2, 0x8CB2, 0x8CD2, 0x8CB2, 0x8CD2, 0x84D2, 0x8CD2, 0x8CD2, 0x8CD2, 0x84D2, 0x84B2, 0x84B2, 0x84B2, 0x8CD2, 0x8CD3, 0x8CB2, 0x8CB2, 0x8CB3, 0x8CD3, 0x8CD2, 0x84D2, 0x84D2, 0x84B2, 0x84B2, 0x84D2, 0x84D2, 
        0x8CB2, 0x84D3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C51, 0x6C31, 0x7451, 
        0x7451, 0x7451, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7431, 0x6C51, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C51, 0x6C51, 0x6C31, 0x7432, 0x7431, 0x6C51, 0x6C51, 0x6C51, 0x6C51, 0x6C31, 0x6C51, 0x6C31, 0x6C51,
  0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA5B5, 0xADB5, 0xADB5, 
        0xADB5, 0xADB5, 0xADB5, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 
        0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xADD6, 0xB5D6, 0xB5D6, 0xBE16, 0xD656, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB616, 0xB616, 0xB616, 0xB616, 0xB616, 0xB616, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 
        0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xBE16, 0xBE16, 0xBE16, 0xBE17, 0xBE17, 0xBE17, 0xC637, 0xC637, 0xC637, 0xC637, 0xC657, 0xCE57, 0xCE57, 0xCE57, 0xCE77, 0xCE77, 0xCE77, 0xCE78, 0xD678, 0xD678, 0xD678, 
        0xD698, 0xD698, 0xD698, 0xD698, 0xD698, 0xD678, 0xD678, 0xD678, 0xCE78, 0xCE57, 0xCE57, 0xC657, 0xC657, 0xC637, 0xC637, 0xC637, 0xBE37, 0xBE17, 0xBE17, 0xBE17, 0xBE16, 0xB5F6, 0xB5F6, 0xB5F6, 0xBDF6, 0xBDF6, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 
        0xBE16, 0xBDF5, 0xE693, 0xFEF1, 0xFEED, 0xF68B, 0xEDA9, 0xEE4C, 0xEE2B, 0xEDE8, 0xFECF, 0xF6AF, 0xF6CF, 0xFECF, 0xFECF, 0xFECF, 0xEE0A, 0xE5EB, 0xF66D, 0xF66E, 0xF6AE, 0xF68E, 0xEDE8, 0xF5E7, 0xDE0E, 0xB593, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 
        0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9534, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9534, 0x9534, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 
        0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9513, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9D13, 
        0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9533, 0x9533, 0x9533, 0x9533, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 
        0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9513, 0x9514, 0x9514, 0x9513, 0x9513, 0x9513, 0x9514, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 
        0x9513, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CB2, 0x9CAF, 0x9C6D, 0xA48D, 0xCD90, 0xDE93, 0xCDF1, 0xD611, 0xDE51, 0xCDF0, 0xB550, 0x948E, 0xB571, 0xBD4F, 0xB50E, 0xA48E, 0x7BED, 
        0x7C0E, 0x8CB2, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD2, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD2, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CB2, 0x8CB3, 0x8CD3, 0x8CD2, 0x8CB2, 0x8CB2, 0x8CD2, 0x8CD2, 0x84D2, 0x8CD2, 0x8CD2, 0x8CD3, 0x8CD3, 0x8CD2, 0x8CD2, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD2, 0x84D2, 0x8CD2, 0x8CD2, 0x84D2, 
        0x84B2, 0x84D3, 0x84B3, 0x84B3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7451, 0x7451, 0x7451, 0x7451, 0x7431, 0x7431, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x7431, 0x7451, 
        0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7431, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x6C31, 0x6C51, 0x6C31, 0x6C51, 0x6C31, 0x6C31, 0x7451, 0x6C31, 0x6C31,
  0xA575, 0xA575, 0xA595, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xAD95, 0xA595, 0xA595, 0xA595, 0xAD95, 0xAD95, 0xAD95, 0xA5B5, 0xA5B5, 0xADB5, 
        0xADB5, 0xADB5, 0xADB5, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADD6, 0xADD6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 
        0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xBE16, 0xD656, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xBDF6, 0xBE16, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 
        0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xBE16, 0xBE17, 0xBE16, 0xBE16, 0xBE17, 0xBE17, 0xBE17, 0xC637, 0xC637, 0xC637, 0xC637, 0xC657, 0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xCE77, 0xCE57, 0xCE77, 0xD678, 0xD678, 0xD698, 
        0xD698, 0xD698, 0xD698, 0xD698, 0xD698, 0xD678, 0xD678, 0xD678, 0xD678, 0xCE57, 0xCE57, 0xCE57, 0xC657, 0xC637, 0xC637, 0xC637, 0xBE37, 0xBE37, 0xBE17, 0xBE17, 0xBDF6, 0xB5F6, 0xBDF6, 0xBDF7, 0xBDF6, 0xBE16, 0xBDF6, 0xBE16, 0xBE17, 0xBE16, 
        0xBE17, 0xBD93, 0xE62E, 0xFEAE, 0xFE4A, 0xEDA8, 0xD56A, 0xE6D1, 0xDEB1, 0xB54C, 0xAD6E, 0x9D4E, 0xADAE, 0xC5EF, 0xD630, 0xD60E, 0xD60F, 0xD670, 0xDE2E, 0xEDEB, 0xF62B, 0xEDA9, 0xE506, 0xED25, 0xC4C8, 0xE693, 0xAD74, 0x9D54, 0x9D54, 0x9D54, 
        0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9D34, 0x9D14, 0x9D14, 0x9514, 0x9514, 0x9514, 0x9513, 0x9514, 0x9514, 0x9513, 0x9513, 0x9513, 0x8D13, 0x9514, 0x9514, 0x9514, 0x9513, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9534, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0xA554, 0xA554, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 
        0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9D13, 
        0x9D13, 0x9513, 0x9513, 0x9D33, 0x9513, 0x9D33, 0x9D34, 0x9D34, 0x9534, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 
        0x9D34, 0x9D34, 0x9D33, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9514, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 
        0x9513, 0x9513, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94D2, 0x83ED, 0x6AE8, 0x93EA, 0xDDF0, 0xFF95, 0xF6F2, 0xEE90, 0xEE6F, 0xD5CE, 0xD5D0, 0xA4AD, 0xC5B1, 0xD5CF, 0xCD6E, 0xB48C, 0x5AA8, 
        0x7BEE, 0x94F3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD2, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD2, 0x8CD3, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CD3, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CD3, 0x8CD2, 0x8CD2, 0x8CD3, 0x8CD2, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD2, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D2, 
        0x84B2, 0x84D3, 0x84D3, 0x84D3, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7472, 0x7452, 0x7451, 0x7451, 0x7451, 0x7431, 0x7431, 0x6C31, 0x6C31, 0x7451, 0x7451, 0x7431, 0x7431, 0x7451, 
        0x7452, 0x7C51, 0x7451, 0x7451, 0x7C52, 0x7452, 0x7452, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x6C51, 0x6C51, 0x6C51, 0x6C51, 0x6C51, 0x6C31,
  0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA575, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xAD95, 0xAD95, 0xAD95, 0xA595, 0xA595, 0xAD95, 0xA595, 0xA595, 0xADB5, 0xADB5, 0xADB5, 
        0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB6, 0xADB5, 0xA5B6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 
        0xADD6, 0xB5D6, 0xB5D6, 0xB5D6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xBE16, 0xD656, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xBE16, 0xBE16, 0xB5F6, 0xBE16, 0xBE16, 0xBE16, 0xBDF6, 0xBDF6, 0xB616, 0xB5F6, 0xB5F6, 
        0xB5F6, 0xB5F6, 0xB5F6, 0xB616, 0xB616, 0xBE16, 0xBE16, 0xBE16, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xC657, 0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xCE77, 0xCE77, 0xD678, 0xD698, 0xD698, 
        0xD698, 0xD698, 0xD698, 0xD698, 0xD698, 0xD698, 0xD698, 0xD678, 0xD678, 0xCE78, 0xCE77, 0xCE57, 0xCE57, 0xC657, 0xC657, 0xC657, 0xC637, 0xC637, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xC617, 0xC637, 0xC637, 0xC637, 0xBE16, 0xB616, 
        0xADD6, 0x9D31, 0xB5AE, 0xB56D, 0xA50C, 0x8CED, 0x74EE, 0x750F, 0x6D0F, 0x6D10, 0x6D10, 0x6D51, 0x6D51, 0x6D50, 0x7550, 0x7D50, 0x752F, 0x752F, 0x7D0E, 0xA56E, 0xBDAE, 0xC5AD, 0xB50B, 0xB50A, 0x948A, 0xA4ED, 0xA573, 0x9D54, 0x9D54, 0x9D54, 
        0x9D54, 0xA554, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x9514, 0x9514, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D55, 0xA574, 0xA554, 0xA554, 0xA554, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 
        0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9534, 0x9514, 0x9514, 0x9D34, 0x9D34, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9533, 0x9533, 0x9D33, 0x9D33, 0x9D13, 
        0x9D33, 0x9D33, 0x9D33, 0x9D34, 0x9D33, 0x9D33, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 
        0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D54, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9534, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9534, 0x9514, 0x9513, 0x9513, 0x9513, 0x9514, 0x9513, 
        0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F2, 0x944D, 0x940A, 0xA429, 0xCD6D, 0xDE0E, 0xD5CE, 0xBD0C, 0xCDAE, 0xC56D, 0xACCC, 0xB50D, 0xB50D, 0xB4CB, 0xAC8B, 0x9C0A, 0x7349, 
        0x8C4F, 0x94F3, 0x94D3, 0x94F3, 0x94F3, 0x94F3, 0x94D3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x94F3, 
        0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD2, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 
        0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x84D3, 0x84D2, 0x84D2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x8492, 0x7C72, 0x7C72, 0x7472, 0x7452, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 
        0x7C52, 0x7C72, 0x7C72, 0x7C72, 0x7C71, 0x7472, 0x7472, 0x7452, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7471, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x6C51, 0x6C31,
  0xA595, 0xA575, 0xA575, 0xA575, 0xA575, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xADB5, 0xADB5, 0xA5B5, 0xA5B5, 0xAD95, 0xAD95, 0xADB5, 
        0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB6, 0xADB5, 0xA5B5, 0xADB5, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 
        0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xBDF6, 0xD656, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xBE16, 0xBE16, 0xBDF6, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xB5F6, 0xB5F6, 
        0xB5F6, 0xB5F6, 0xBE16, 0xB616, 0xBE16, 0xBE16, 0xBE16, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xC657, 0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xCE77, 0xD678, 0xD678, 0xD698, 0xDE98, 
        0xDE98, 0xDE98, 0xDE98, 0xD698, 0xD698, 0xD698, 0xD698, 0xD698, 0xD678, 0xD678, 0xCE77, 0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xC657, 0xC637, 0xC637, 0xBE37, 0xC637, 0xC615, 0xDE32, 0xB5D4, 0x9594, 0x8D53, 0x8552, 0x7D11, 0x6CF0, 
        0x64D0, 0x64CF, 0x5CCE, 0x5CCF, 0x64EF, 0x6510, 0x6510, 0x6510, 0x6510, 0x6D30, 0x6510, 0x6530, 0x6D31, 0x6D31, 0x6530, 0x6530, 0x6D30, 0x6510, 0x6530, 0x6530, 0x6D10, 0x6D10, 0x6D30, 0x6D10, 0x64EF, 0x64EF, 0x6D10, 0x7511, 0x8511, 0xAD30, 
        0x8D11, 0x7D12, 0x8D12, 0x8D33, 0x9533, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9D34, 0x9D34, 0x9534, 0x9D34, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9534, 0x9534, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0x9D54, 0x9D54, 0x9D54, 
        0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9533, 0x9D33, 0x9513, 0x9D33, 0x9D33, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 
        0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D33, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0xA554, 0xA554, 0x9D54, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0x9D54, 
        0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0xA554, 0xA554, 0x9D54, 0x9D34, 0x9D14, 0x9513, 0x9513, 0x9513, 0x9514, 0x9513, 0x9534, 0x9D33, 0x9D33, 0x9513, 0x9513, 0x9514, 0x9514, 0x9513, 
        0x9514, 0x9533, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F2, 0x83EC, 0x7B48, 0xA42A, 0xE64F, 0xF711, 0xEEB1, 0xC56E, 0xE671, 0xD60F, 0xB50D, 0xD5EF, 0xDE30, 0xDE0F, 0xD5AE, 0x8BAA, 0x5A87, 
        0x7BEE, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x9513, 0x9533, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 
        0x94F3, 0x9513, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94D3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CF3, 0x8CF3, 0x8CF3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD2, 0x8CB2, 0x8CB2, 0x8CB2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x7C92, 0x7C72, 0x7C72, 0x7C71, 0x7C71, 0x7C51, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7C52, 0x7C72, 
        0x7C72, 0x7C72, 0x7C71, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C51, 0x7C51, 0x7C51, 0x7451, 0x7451, 0x7471, 0x7471, 0x7C72, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7431, 0x6C51, 0x6C51,
  0xA575, 0xA595, 0xA595, 0xA595, 0xA575, 0xA575, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xAD95, 0xADB5, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xAD95, 0xAD95, 0xADB5, 
        0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 
        0xADD6, 0xADD6, 0xB5D6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xADD6, 0xBDF5, 0xCE14, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xBE16, 0xBE16, 0xBE16, 0xBDF6, 0xBE16, 0xBDF6, 0xBDF6, 0xB5F6, 0xB616, 0xB5F6, 
        0xB5F6, 0xBE16, 0xBE16, 0xBE16, 0xBE17, 0xBE17, 0xBE16, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xC637, 0xBE37, 0xBE37, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xC657, 0xCE57, 0xCE57, 0xCE57, 0xCE77, 0xCE77, 0xCE78, 0xD678, 0xD698, 0xD698, 0xDE98, 
        0xDE98, 0xDE98, 0xDE98, 0xD698, 0xD698, 0xD698, 0xD698, 0xD698, 0xD678, 0xD678, 0xCE77, 0xCE77, 0xD657, 0xD677, 0xCE77, 0xCE78, 0xD678, 0xCE57, 0xCE57, 0xCE57, 0xC657, 0xA5D5, 0xB54E, 0xEDAB, 0x94ED, 0x5CAF, 0x5CCF, 0x5CCF, 0x5CEF, 0x5CEF, 
        0x64EF, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CEF, 0x64EF, 0x650F, 0x650F, 0x650F, 0x650F, 0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6510, 0x6510, 0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6531, 0x5D10, 0x9D2D, 0xEE2D, 
        0x950D, 0x6530, 0x6D30, 0x6D31, 0x7511, 0x7D32, 0x8D33, 0x9534, 0x9D34, 0x9D34, 0x9D34, 0x9534, 0x9D34, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x94F3, 0x9513, 0x9513, 0x9513, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9534, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D55, 0x9D54, 0x9D54, 0x9D54, 0xA554, 0xA574, 0xA554, 0xA554, 0xA554, 0xA574, 0xA554, 0xA555, 0xA555, 0xA554, 0x9D54, 
        0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D33, 0x9D33, 0x9D33, 0x9513, 0x9D13, 0x9D33, 0x9513, 0x9D13, 0x9D33, 0x9D13, 0x9D33, 0x9D34, 0x9D33, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 
        0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 
        0xA554, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0x9D34, 0x9D34, 0x9D14, 0x9513, 0x9513, 0x9513, 0x9513, 0x9514, 0x9D34, 0x9D34, 0x9D34, 0x9D33, 0x9D33, 0x9D34, 0x9533, 0x9D34, 
        0x9D34, 0x9D34, 0x9533, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x94F3, 0x9513, 0x944E, 0x93EA, 0xBCAB, 0xCD4B, 0xC52B, 0xB4AA, 0xB4AA, 0xAC8A, 0xAC8B, 0xA48B, 0xA46B, 0xA46A, 0xBD0C, 0xD5AE, 0xC56E, 0xA48D, 
        0x8C90, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9D33, 0x9D33, 0x9513, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 
        0x9513, 0x9D33, 0x9D33, 0x9533, 0x9513, 0x94F3, 0x94F2, 0x94F3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x94F3, 0x8CF3, 0x8CF3, 
        0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CF3, 0x8CD3, 0x8CD2, 0x8CD3, 0x8CD2, 0x8CB2, 0x8CB2, 0x8CB2, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C52, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7452, 0x7471, 0x7C71, 0x7C72, 
        0x7C72, 0x7C72, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7471, 0x7472, 0x7C72, 0x7C72, 0x7471, 0x7471, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7431, 0x7451, 0x7451,
  0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xAD95, 0xADB5, 0xADB5, 
        0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADB6, 0xADD6, 0xADD6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 
        0xB5D6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xADD6, 0xBDD5, 0xCDF2, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB616, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xB5F6, 0xBE16, 0xBDF6, 
        0xBDF6, 0xBE17, 0xBE17, 0xBE17, 0xBE16, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE37, 0xBE37, 0xBE17, 0xBE17, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xC657, 0xC657, 0xC657, 0xCE57, 0xCE77, 0xCE78, 0xD678, 0xD678, 0xD698, 0xDE98, 0xDE98, 
        0xDE98, 0xDE98, 0xDE98, 0xDE98, 0xDE98, 0xDE98, 0xD678, 0xD678, 0xD678, 0xD677, 0xD677, 0xD678, 0xD678, 0xD678, 0xD698, 0xD698, 0xD678, 0xD678, 0xD678, 0xB616, 0x9572, 0x9CED, 0xC508, 0xDCE6, 0xD58B, 0x8D0C, 0x64EF, 0x6510, 0x6510, 0x5CCF, 
        0x5CCF, 0x5CCF, 0x5CCE, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CEF, 0x650F, 0x6510, 0x5D0F, 0x6510, 0x6510, 0x5D10, 0x6510, 0x6510, 0x6530, 0x6510, 0x6510, 0x6510, 0x6510, 0x6510, 0x5D10, 0x6510, 0x5CEF, 0x64CE, 0xA52D, 0xE60D, 0xDD69, 
        0xAC89, 0x7D0F, 0x6D30, 0x6D51, 0x6D31, 0x6D51, 0x6D11, 0x7D32, 0x8D33, 0x9D34, 0x9D34, 0x9534, 0x9D34, 0x9514, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9534, 0x9534, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D55, 0xA555, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA574, 0xA575, 0xA574, 0xA554, 0xA554, 0x9D54, 0x9D34, 
        0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0x9D14, 0x9D34, 0x9D33, 0x9D34, 0x9D34, 0x9D33, 0x9D34, 0x9D33, 0x9D33, 0x9D33, 0x9D34, 0x9D34, 0x9D54, 
        0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA554, 0xA554, 0xA554, 
        0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0xA554, 0xA554, 0xA574, 0xA574, 0x9D54, 0x9D34, 0x9D34, 0x9534, 0x9514, 0x9513, 0x9513, 0x9533, 0x9D33, 0x9D34, 0xA553, 0x9D53, 0x9D34, 0x9D33, 0x9D33, 0x9D33, 0x9D34, 
        0x9D33, 0x9D33, 0x9D33, 0x9D33, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x94D2, 0x7B8B, 0x7308, 0x8348, 0xC56D, 0xD5CF, 0xD60F, 0xDE2F, 0xC58E, 0xCDAF, 0xBD6E, 0xBD6F, 0xBD4E, 0xBD2E, 0xB4AC, 0xA44B, 0x83AA, 
        0x948F, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 
        0x9D33, 0xA554, 0x9D53, 0x9D33, 0x9D33, 0x9513, 0x94F2, 0x8CF3, 0x8CF3, 0x8CF3, 0x94F3, 0x8CD3, 0x8CF3, 0x94F3, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x9513, 0x9D33, 0x9D53, 0xA554, 0xA554, 0x9D54, 0x9D33, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 
        0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CD3, 0x8CD2, 0x8CD2, 0x8CD3, 0x8CD3, 0x8CD2, 0x8CB2, 0x84B2, 0x8492, 0x8492, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C52, 0x7C52, 0x7451, 0x7451, 0x7451, 0x7451, 0x7472, 0x7451, 0x7C71, 0x7C72, 
        0x7C72, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x8492, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C51, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451,
  0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xA595, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 
        0xADB5, 0xADB5, 0xADB6, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADB6, 0xADD6, 0xADD6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 
        0xB5D6, 0xB5D6, 0xB5D6, 0xADD6, 0xADB6, 0xADD6, 0xB5D6, 0xADD6, 0xBDD3, 0xCDD1, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 
        0xBE16, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xC657, 0xC657, 0xC657, 0xCE57, 0xCE77, 0xD678, 0xD678, 0xD698, 0xDE98, 0xDE98, 0xDEB8, 
        0xDE98, 0xDE98, 0xDEB8, 0xDE98, 0xDE98, 0xDE98, 0xD678, 0xD678, 0xD678, 0xD698, 0xDE98, 0xDE98, 0xDE98, 0xDE98, 0xDE98, 0xD698, 0xDE98, 0xCE57, 0x9593, 0x64EF, 0x8D4F, 0xEE0B, 0xD508, 0xB406, 0xEDEB, 0xE64D, 0x74CD, 0x5CF0, 0x5CF0, 0x548E, 
        0x54AE, 0x54AE, 0x54CE, 0x5CEE, 0x5CEE, 0x5CEF, 0x5CEF, 0x5CCE, 0x5CCE, 0x5CCF, 0x5CEF, 0x5CCF, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CF0, 0x5D10, 0x5D10, 0x6510, 0x5D10, 0x5CEF, 0x5CCF, 0x54AF, 0x8CAB, 0xFE8E, 0xE58A, 0xAC05, 
        0xD56A, 0xDDED, 0x8D4F, 0x5D10, 0x6530, 0x6530, 0x6531, 0x6530, 0x6D11, 0x7D12, 0x9533, 0x9D34, 0x9D34, 0x9D34, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9513, 0x9513, 0x9514, 0x9514, 0x9513, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9534, 0x9534, 0x9D34, 0x9534, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0xA574, 0xA574, 0xA554, 0xA554, 0xAD75, 0xAD95, 0xAD95, 0xA575, 0xA574, 0xA554, 0x9D54, 0x9D54, 
        0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D33, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D33, 0x9D33, 0x9D34, 0x9D54, 0x9D54, 
        0x9D54, 0xA554, 0x9D54, 0x9D54, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA574, 0xA574, 0xA554, 0xA554, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA554, 0x9D54, 0x9D54, 
        0x9D54, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0xA554, 0xA554, 0xA574, 0xA574, 0xA574, 0xA574, 0xA554, 0x9D34, 0x9D34, 0x9D33, 0x9533, 0x9533, 0x9533, 0x9533, 0x9D34, 0x9D33, 0x9D33, 0xD5F2, 0xCDD2, 0xA553, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 
        0x9D53, 0x9D33, 0x9D33, 0x9D34, 0x9D34, 0x9D33, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x7BCD, 0x6B29, 0x9C6D, 0xDE33, 0xEED4, 0xEED5, 0xE694, 0xDE75, 0xD675, 0xCE55, 0xCE55, 0xD655, 0xD634, 0xCDB2, 0x9C6D, 0x62EA, 
        0x844F, 0x9513, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x9513, 0x9D33, 0x9D33, 0x9D33, 0x9D53, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0xA554, 0xA554, 0xA554, 0x9D33, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9D33, 
        0x9D53, 0xA554, 0xA554, 0x9D53, 0x9D33, 0x9513, 0x9513, 0x94F3, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x9513, 0x9D33, 0xA554, 0xA574, 0xAD94, 0xAD74, 0xA554, 0x9D54, 0x9D33, 0x9D13, 0x9513, 0x9513, 0x9513, 
        0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CD3, 0x8CB2, 0x8CB2, 0x84B2, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C71, 0x7451, 0x7C52, 0x7451, 0x7451, 0x7451, 0x7451, 0x7471, 0x7451, 0x7C52, 0x7C72, 
        0x7C72, 0x8492, 0x84B2, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C72, 0x7C92, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C91, 0x7C71, 0x7C72, 0x7C52, 0x7C72, 0x7451, 0x7451, 0x7452, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451,
  0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xA595, 0xA595, 0xAD95, 0xAD95, 0xAD95, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 
        0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB6, 0xADB5, 0xADB5, 0xADB5, 0xADB6, 0xADB5, 0xADB6, 0xADB5, 0xADB5, 0xADB6, 0xADB5, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xADD6, 
        0xADD6, 0xB5D6, 0xB5D6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xBDD3, 0xC591, 0xB5D5, 0xB616, 0xB617, 0xB616, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 
        0xBE17, 0xC637, 0xC637, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xC657, 0xC657, 0xC658, 0xC658, 0xCE77, 0xCE78, 0xD678, 0xD698, 0xDE98, 0xDE98, 0xDEB8, 
        0xDEB8, 0xDE98, 0xDE98, 0xDE98, 0xDE98, 0xD698, 0xD698, 0xD698, 0xD698, 0xDE98, 0xDE98, 0xDE98, 0xDE98, 0xDE98, 0xDE98, 0xDE98, 0xB616, 0x7530, 0x5CEF, 0x5CEF, 0x9D0C, 0xD529, 0x62A5, 0x39A4, 0xB489, 0xEDEB, 0xC56C, 0x750F, 0x5CCF, 0x548E, 
        0x4C8E, 0x54AE, 0x54CE, 0x54CE, 0x54CE, 0x5CCE, 0x5CCE, 0x5CCE, 0x54CE, 0x54CF, 0x54CF, 0x54CF, 0x5CEF, 0x54CF, 0x5CEF, 0x54CF, 0x54CF, 0x54CF, 0x54EF, 0x5CEF, 0x5CEF, 0x54CF, 0x54CF, 0x54CF, 0x64AE, 0x9D0C, 0xD58A, 0xEDEB, 0x9BA7, 0x6AC6, 
        0x7B47, 0xD54A, 0xA52C, 0x64EF, 0x6510, 0x6510, 0x6530, 0x6530, 0x6530, 0x6510, 0x6D11, 0x8D33, 0x9D34, 0x9D34, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9534, 0x9534, 0x9534, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0xA574, 0xA554, 0xA554, 0xA575, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xA575, 0xA554, 0x9D54, 
        0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D33, 0x9D34, 0x9D34, 0x9D34, 0x9D33, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D53, 0xA554, 0xA554, 
        0xA574, 0xA554, 0xA554, 0xA554, 0xA554, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xAD74, 0xAD74, 0xAD74, 0xA574, 0xAD74, 0xAD74, 0xAD74, 0xAD74, 0xAD74, 0xAD74, 0xAD74, 0xA574, 0xA554, 0x9D54, 0x9D54, 0x9D54, 
        0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0xA554, 0xA554, 0xA574, 0xA574, 0xA574, 0xA575, 0xA574, 0x9D54, 0x9D34, 0x9D34, 0x9D33, 0x9D33, 0x9D33, 0x9D34, 0x9D34, 0x9D34, 0x9D33, 0xBD92, 0xE651, 0xD5D1, 0xBD93, 0xA554, 0x9D54, 0xA554, 0x9D54, 
        0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0x9533, 0x9533, 0x9513, 0x9513, 0x9D13, 0xBDB4, 0xDE77, 0xE6F9, 0xDED9, 0xDEB8, 0xEF1B, 0xE6FA, 0xD698, 0xEF3B, 0xE71B, 0xD6B9, 0xDEDA, 0xE6FB, 0xD698, 0xDEB9, 0xCE57, 
        0xA574, 0x94F3, 0x94F3, 0x9513, 0x9513, 0x9513, 0x9D33, 0xA554, 0xA554, 0xA574, 0xA574, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0x9D33, 0x9D33, 0x9D33, 0x9513, 0x9513, 0x9513, 0x9513, 0x9D33, 0x9D34, 0x9D54, 
        0xA554, 0xA574, 0xA554, 0x9D53, 0x9D53, 0x9D33, 0x9D33, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9D33, 0x9D33, 0x9D33, 0xA554, 0xAD74, 0xAD94, 0xAD94, 0xAD74, 0xA554, 0x9D33, 0x9D33, 0x9D13, 0x9513, 0x9513, 
        0x9513, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x8CF3, 0x8CD3, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CB2, 0x8CB2, 0x84B2, 0x8492, 0x8492, 0x7C92, 0x8472, 0x7C72, 0x7C72, 0x7C71, 0x7C71, 0x7C72, 0x7471, 0x7451, 0x7451, 0x7C51, 0x7C71, 0x7C51, 0x7451, 
        0x7C72, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C71, 0x7C72, 0x7C72, 0x7C72, 0x7451, 0x7451, 0x7451, 0x7451,
  0xADB5, 0xADB5, 0xADB5, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 
        0xADB6, 0xADB5, 0xADB5, 0xADB5, 0xADB6, 0xADB5, 0xADB5, 0xADB5, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB5, 0xADB5, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 
        0xB5D6, 0xB5D6, 0xADD6, 0xADD6, 0xB5D6, 0xADD6, 0xADD6, 0xADD6, 0xC657, 0xCE98, 0xAD52, 0xAD32, 0xB574, 0xBDD5, 0xBE37, 0xC657, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE17, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 
        0xBE17, 0xBE37, 0xC637, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xBE17, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xC657, 0xC637, 0xC637, 0xC637, 0xC637, 0xC657, 0xC657, 0xC657, 0xC657, 0xCE78, 0xCE77, 0xCE78, 0xD678, 0xD698, 0xDE98, 0xDE98, 
        0xDE98, 0xDE98, 0xDE98, 0xDE98, 0xDE98, 0xD698, 0xD698, 0xD698, 0xD698, 0xD678, 0xD698, 0xD698, 0xD678, 0xD678, 0xDE98, 0xBE16, 0x64CF, 0x5CCE, 0x5CCE, 0x648D, 0xB487, 0x9C06, 0x3A06, 0x4AA9, 0x8BE9, 0xE5CA, 0xFEEF, 0x8CED, 0x3BCB, 0x3BEC, 
        0x442D, 0x4CAE, 0x54CE, 0x54CE, 0x5CCE, 0x54CE, 0x54CE, 0x54CE, 0x54CE, 0x54EF, 0x54CF, 0x54CF, 0x54CF, 0x54CF, 0x54CF, 0x54CF, 0x54CF, 0x54CF, 0x54EF, 0x54CF, 0x54CF, 0x54AE, 0x4C8E, 0x442D, 0x8CCC, 0xF68E, 0xF62B, 0xB489, 0x39A5, 0x31A6, 
        0x39E5, 0x8B65, 0xB447, 0x94CC, 0x5CCF, 0x5CEF, 0x5CEF, 0x5D10, 0x6510, 0x6510, 0x5D10, 0x6D10, 0x8D33, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9513, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9514, 0x9514, 0x9534, 0x9534, 0x9534, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0xA554, 0xA554, 0xA574, 0xAD95, 0xAD95, 0xB5B5, 0xADB5, 0xADB5, 0xAD95, 0xAD95, 0xA574, 0x9D54, 
        0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9533, 0x9533, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D34, 0x9D54, 0x9D54, 0xA554, 0xA554, 0xA554, 
        0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xAD74, 0xA574, 0xA574, 0xAD75, 0xAD75, 0xAD75, 0xAD95, 0xAD75, 0xAD74, 0xAD75, 0xAD95, 0xAD95, 0xAD94, 0xAD94, 0xAD74, 0xA554, 0x9D54, 0x9D54, 0x9D54, 
        0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0xA554, 0xA554, 0xA554, 0xA574, 0xA574, 0xA574, 0xA554, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D33, 0x9D54, 0x9D54, 0xA553, 0xCDD2, 0xB593, 0x9D33, 0xA574, 0xA554, 0xA574, 0xA554, 
        0xA554, 0xA554, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0x9533, 0x9513, 0x9513, 0x9D33, 0xDE97, 0xDE98, 0xE6F9, 0xDEB8, 0xC5F5, 0xEF3B, 0xD678, 0xAD53, 0xEF3B, 0xE71B, 0xAD53, 0xDED9, 0xDEFA, 0xC5F6, 0xDEDA, 0xCE78, 
        0xB5D6, 0x94F3, 0x9513, 0x9513, 0x9513, 0x9D33, 0x9D53, 0xA574, 0xAD94, 0xAD74, 0xA574, 0xAD74, 0xAD74, 0xAD74, 0xAD74, 0xAD74, 0xA574, 0xA554, 0xAD74, 0xAD74, 0xA554, 0xA554, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0x9D54, 0xA554, 
        0xA574, 0xA574, 0xA574, 0xA554, 0x9D54, 0x9D53, 0x9D33, 0x9D33, 0x9D13, 0x9D33, 0x9D33, 0xA553, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0xA554, 0xA574, 0xA574, 0xAD74, 0xAD74, 0xA574, 0xA574, 0xAD74, 0xA554, 0x9D33, 0x9D33, 0x9D13, 0x9513, 0x9513, 
        0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CB2, 0x84B2, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C72, 0x7C92, 0x7C92, 0x7C72, 0x7C71, 0x7C72, 0x7C51, 0x7451, 0x7C51, 0x7C51, 0x7C51, 0x7C72, 
        0x7C72, 0x7C92, 0x8472, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x84B2, 0x8492, 0x8492, 0x84B2, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7451, 0x7C51, 0x7471, 0x7471,
  0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 
        0xADD6, 0xADD6, 0xADB5, 0xADB5, 0xADB6, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB5, 0xADB6, 0xADB5, 0xADB5, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 
        0xB5D6, 0xADD6, 0xADD6, 0xB5D6, 0xADD6, 0xB5D6, 0xB5D6, 0xADD6, 0xCE98, 0xDED9, 0xA4F1, 0x9C6E, 0xA48F, 0xA4AF, 0xA4D0, 0xA4F1, 0xAD52, 0xB573, 0xB594, 0xB594, 0xB5B5, 0xBDF6, 0xBE16, 0xBE17, 0xBE37, 0xBE16, 0xC637, 0xC637, 0xC637, 0xBE37, 
        0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE37, 0xBE17, 0xC617, 0xC637, 0xC637, 0xC657, 0xCE57, 0xC657, 0xC657, 0xC657, 0xC657, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xC657, 0xC657, 0xC657, 0xCE57, 0xCE57, 0xCE78, 0xD698, 0xD698, 0xD698, 
        0xD698, 0xD698, 0xD698, 0xD698, 0xD698, 0xD698, 0xD678, 0xD678, 0xD678, 0xD678, 0xD678, 0xD678, 0xD678, 0xD698, 0xCE57, 0x7510, 0x54CE, 0x5CCE, 0x54AE, 0x9D2D, 0xF62A, 0x8C06, 0x21A5, 0x2184, 0x6B27, 0xE5A9, 0xCD49, 0x63E9, 0x33AB, 0x33CB, 
        0x444D, 0x54CE, 0x54CE, 0x54EE, 0x5CCE, 0x5CEE, 0x5CEF, 0x5CEF, 0x5CEE, 0x5D0F, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CEF, 0x54EF, 0x54EF, 0x54EF, 0x54EF, 0x54EF, 0x54CF, 0x54AF, 0x4C8E, 0x444D, 0x336A, 0x94CA, 0xF6AE, 0xEDCA, 0x93C9, 0x2145, 0x31A6, 
        0x31A5, 0x93C8, 0xDD69, 0xD5AC, 0x74EE, 0x54CF, 0x54CF, 0x5CCF, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CF0, 0x6CF1, 0x9533, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 
        0x9514, 0x9534, 0x9D34, 0x9D34, 0x9534, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9534, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0xA555, 0xA575, 0xA575, 0xAD95, 0xAD95, 0xB5B5, 0xB5D5, 0xB5D5, 0xB5B5, 0xAD95, 0xAD75, 0xA554, 
        0xA554, 0xA554, 0xA554, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0xA554, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0xA554, 0xA554, 0xA554, 0xA574, 0xA574, 0xAD74, 
        0xAD74, 0xAD74, 0xAD74, 0xAD74, 0xAD74, 0xAD74, 0xAD74, 0xAD74, 0xAD75, 0xAD74, 0xAD74, 0xAD74, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD74, 0xA554, 0x9D54, 0x9D54, 0x9D54, 
        0x9D54, 0x9D54, 0x9D54, 0x9D54, 0xA554, 0x9D54, 0x9D54, 0xA554, 0xA554, 0xA554, 0xA554, 0x9D54, 0x9D34, 0x9D34, 0x9D33, 0x9D34, 0x9D34, 0x9D33, 0x9D33, 0x9D54, 0x9D54, 0xA554, 0xA554, 0xCDD3, 0xBDD3, 0xA554, 0xA554, 0xA554, 0xAD74, 0xAD94, 
        0xAD94, 0xAD95, 0xA554, 0xA554, 0xA554, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D33, 0x9533, 0x9D13, 0x9513, 0xA533, 0xDEB8, 0xD656, 0xE6D9, 0xDE98, 0xBDB4, 0xEF3B, 0xD678, 0xAD53, 0xEF5B, 0xE71A, 0xAD53, 0xDED9, 0xDEDA, 0xBDD6, 0xDEDA, 0xCE57, 
        0xB5D5, 0x94F3, 0x9513, 0x9513, 0x9533, 0x9D33, 0x9D54, 0xA574, 0xAD94, 0xAD74, 0xA574, 0xAD74, 0xAD74, 0xAD94, 0xAD94, 0xAD94, 0xAD74, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA554, 0x9D53, 0x9D53, 0x9D53, 0x9D33, 0x9D33, 0x9D54, 0xA554, 
        0xA574, 0xA574, 0xA574, 0xA574, 0xA554, 0x9D53, 0x9D33, 0x9D33, 0x9D33, 0xA554, 0xAD74, 0xA574, 0xA554, 0xA554, 0xA554, 0xA554, 0xA574, 0xAD74, 0xAD74, 0xA574, 0xAD74, 0xA574, 0xA554, 0xA554, 0xA554, 0x9D33, 0x9D33, 0x9D13, 0x9513, 0x9513, 
        0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F3, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CD2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C72, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C51, 0x7C71, 0x7C72, 
        0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7471, 0x7451,
  0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 0xADD5, 0xADD5, 0xADD5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5B5, 0xB5B6, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 0xADD5, 0xADD5, 0xADD5, 0xADD5, 0xADD6, 0xADD6, 0xADD6, 0xADD5, 0xADD5, 0xADD6, 0xADD6, 0xADD6, 
        0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADB5, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5D6, 
        0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5D6, 0xC658, 0xD6B9, 0xB552, 0xACF1, 0xACD0, 0xA4AF, 0xA4AF, 0xA4CF, 0xA4AF, 0xA4AF, 0xA4AF, 0xA4AF, 0xA4D0, 0xACF1, 0xAD11, 0xAD11, 0xAD11, 0xB552, 0xB573, 0xB594, 0xBDB4, 0xBDB5, 
        0xBDF6, 0xBE16, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xC657, 0xCE57, 0xCE78, 0xCE78, 0xCE77, 0xCE77, 0xCE57, 0xC657, 0xC657, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xC657, 0xC657, 0xC657, 0xC657, 0xCE57, 0xCE58, 0xCE78, 0xCE78, 0xD678, 
        0xD678, 0xD678, 0xD678, 0xCE77, 0xD678, 0xD678, 0xCE78, 0xCE78, 0xCE77, 0xCE77, 0xCE77, 0xCE77, 0xD678, 0xC657, 0x7D10, 0x54AD, 0x54CE, 0x5CCE, 0x54AE, 0xA52C, 0xFE4B, 0x8408, 0x11C5, 0x1164, 0x7B47, 0xDD47, 0xBD49, 0x4389, 0x2BAB, 0x3C0C, 
        0x4CAE, 0x54EE, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CEF, 0x5D0F, 0x6510, 0x5D10, 0x5D10, 0x5D10, 0x5D10, 0x5D10, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CEF, 0x54EF, 0x54CF, 0x54AF, 0x444D, 0x338A, 0x5B67, 0xCDAA, 0xE5AA, 0x9BA8, 0x4A26, 0x5AA8, 
        0x3185, 0x93C8, 0xF62B, 0xF66D, 0x850E, 0x4CAE, 0x54CF, 0x54CF, 0x54CF, 0x54CF, 0x5CEF, 0x54CF, 0x54CF, 0x6CF1, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9534, 0x9514, 
        0x9514, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0xA555, 0xAD75, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xB5D5, 0xBDD5, 0xB5D5, 0xB5B5, 0xAD95, 0xA574, 0xA554, 
        0xA554, 0xA554, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D34, 0x9D54, 0xA554, 0xA574, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA574, 0xA574, 0xAD94, 
        0xAD94, 0xAD94, 0xAD74, 0xAD74, 0xAD94, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD94, 0xAD94, 0xAD94, 0xAD95, 0xAD95, 0xB595, 0xAD95, 0xB595, 0xB595, 0xB595, 0xB5B5, 0xB595, 0xB595, 0xB5B5, 0xB5B5, 0xAD95, 0xAD95, 0xA574, 0xA554, 0x9D54, 0x9D54, 
        0x9D54, 0x9D54, 0x9D54, 0x9D54, 0xA554, 0x9D54, 0x9D54, 0xA554, 0xA554, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D33, 0x9D54, 0x9D54, 0x9D54, 0xA554, 0xA554, 0xCDF3, 0xC5D3, 0xAD74, 0xA574, 0xA574, 0xAD95, 0xB5B5, 
        0xADB5, 0xAD95, 0xAD74, 0xA574, 0xA574, 0xA554, 0xA554, 0x9D54, 0x9D54, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0xA553, 0xDE98, 0xD676, 0xE6D9, 0xDE98, 0xBDB4, 0xEF3B, 0xD698, 0xAD53, 0xEF5C, 0xE71B, 0xAD53, 0xDEDA, 0xDEDA, 0xBDD5, 0xDEDA, 0xCE77, 
        0xB5D5, 0x94F3, 0x9513, 0x9513, 0x9533, 0x9D33, 0x9D54, 0xA574, 0xA574, 0xA574, 0xA574, 0xAD74, 0xAD94, 0xAD94, 0xAD95, 0xAD95, 0xAD75, 0xA574, 0xA574, 0xA574, 0xAD74, 0xAD74, 0xAD74, 0xA574, 0xA554, 0x9D33, 0x9D33, 0x9D33, 0x9D54, 0xA554, 
        0xA554, 0xA574, 0xAD74, 0xAD74, 0xAD74, 0xA574, 0xA554, 0xA554, 0xAD74, 0xAD94, 0xB5B4, 0xAD94, 0xAD74, 0xA574, 0xA574, 0xA574, 0xAD74, 0xAD74, 0xAD74, 0xAD74, 0xAD94, 0xAD94, 0xAD74, 0xA553, 0x9D53, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 
        0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x94F3, 0x9513, 0x94F3, 0x94F3, 0x94F3, 0x94F2, 0x8CD2, 0x8CD2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x7C92, 0x7C91, 0x7C91, 0x7C71, 0x7C72, 0x7C72, 0x7C72, 0x7C71, 0x7C71, 0x7C71, 0x7C72, 
        0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C72, 0x7C51,
  0xC636, 0xC616, 0xBE16, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDF6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xADD6, 0xADD6, 0xADD6, 
        0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xADD6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5D6, 
        0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 0xADD6, 0x9D94, 0x8D53, 0x74F1, 0x8532, 0xA5D5, 0x9DB4, 0xADD5, 0xB5F6, 0xB5F6, 0xBDF6, 0xBDF5, 0xBDD5, 0xC5D5, 0xBDB4, 0xBD73, 0xB552, 0xACF1, 0xA4D0, 0xACD0, 0xACCF, 0xACCF, 0xACCF, 0xB4F0, 0xB4F0, 0xACD0, 
        0xACD0, 0xACF0, 0xAD10, 0xB531, 0xB552, 0xB573, 0xBD93, 0xBDB4, 0xC5F5, 0xC616, 0xCE37, 0xCE57, 0xCE78, 0xCE98, 0xCE98, 0xCE78, 0xC657, 0xC657, 0xC657, 0xC657, 0xC657, 0xC657, 0xC657, 0xC657, 0xC657, 0xC657, 0xC657, 0xC657, 0xCE57, 0xCE57, 
        0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xCE57, 0x8552, 0x54AE, 0x54CE, 0x5CAE, 0x5CAE, 0x54AE, 0x8CEC, 0xED89, 0xB52B, 0x2AC8, 0x2A67, 0x9C07, 0xE5C9, 0xEE6E, 0x6C0A, 0x33CB, 0x548E, 
        0x5CEE, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CEF, 0x6530, 0x6510, 0x6510, 0x6510, 0x5D10, 0x5D10, 0x5D10, 0x5D10, 0x5D0F, 0x5D0F, 0x5D10, 0x5CEF, 0x54CF, 0x4C8E, 0x33AA, 0x63A8, 0xDDEC, 0xEDEA, 0xC488, 0x6AC7, 0x41E6, 
        0x31A5, 0xB4CB, 0xF68D, 0xE62D, 0x6CAD, 0x4C8E, 0x54CF, 0x54CF, 0x54CF, 0x54CF, 0x54CF, 0x54CF, 0x54CF, 0x54AF, 0x74F2, 0x9534, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9D34, 0x9534, 0x9534, 0x9534, 
        0x9534, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D54, 0xA575, 0xADB5, 0xB5B5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 0xBDD5, 0xBDD6, 0xB5D5, 0xAD95, 0xA574, 0xA554, 
        0xA554, 0xA554, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0xA554, 0xAD74, 0xAD75, 0xA574, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA574, 0xAD95, 0xAD95, 
        0xAD95, 0xAD94, 0xAD94, 0xAD95, 0xB595, 0xB595, 0xB595, 0xB5B5, 0xB5B5, 0xAD95, 0xAD95, 0xB5B5, 0xB595, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xADB5, 0xAD95, 0xA574, 0xA554, 0xA554, 0xA554, 
        0xA554, 0xA554, 0xA554, 0x9D54, 0xA554, 0x9D54, 0x9D54, 0xA554, 0xA554, 0xA554, 0xA554, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0xA554, 0xA554, 0xA554, 0xA554, 0xA553, 0xD5F2, 0xC5F3, 0xAD74, 0xAD74, 0xAD74, 0xAD94, 0xB5B5, 
        0xB5B5, 0xB5B5, 0xB5B5, 0xAD94, 0xAD74, 0xAD74, 0xAD74, 0xA554, 0x9D54, 0x9D34, 0x9D34, 0x9D53, 0x9D34, 0xA554, 0xDEB8, 0xD656, 0xE6D9, 0xDEB8, 0xBDB4, 0xEF5B, 0xD678, 0xAD32, 0xEF5C, 0xE6FA, 0xAD53, 0xDED9, 0xDEDA, 0xBDD5, 0xDEDA, 0xCE78, 
        0xB5B5, 0x9513, 0x9513, 0x9D33, 0x9D33, 0x9D54, 0x9D53, 0xA554, 0xA554, 0xA554, 0xA554, 0xA574, 0xAD94, 0xAD74, 0xAD94, 0xAD95, 0xAD95, 0xAD74, 0xA574, 0xA574, 0xAD74, 0xAD94, 0xAD94, 0xA574, 0xA554, 0x9D53, 0x9D33, 0x9D33, 0xA553, 0xA554, 
        0xA574, 0xAD74, 0xAD94, 0xB5B4, 0xB5B4, 0xB594, 0xAD94, 0xAD94, 0xB5B4, 0xB5B5, 0xB5B4, 0xB594, 0xAD94, 0xAD74, 0xA574, 0xA574, 0xA574, 0xAD74, 0xAD94, 0xAD94, 0xB5B5, 0xB595, 0xAD94, 0xA554, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 
        0x9533, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9513, 0x9D13, 0x9D13, 0x9D33, 0x9513, 0x9513, 0x94F2, 0x8CD2, 0x8CD2, 0x8CB2, 0x8CB2, 0x84B2, 0x8492, 0x7C92, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C72, 0x7C72, 0x7C92, 0x7C72, 0x7C72, 
        0x7C72, 0x7C72, 0x7C71, 0x7C71, 0x7C72, 0x7C72, 0x7C72, 0x7C71, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C71, 0x7C71, 0x7C72, 0x7451,
  0xD677, 0xD657, 0xCE57, 0xC636, 0xC616, 0xC616, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBDF6, 0xBDF6, 0xBDF6, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBDF6, 0xB5F6, 0xB5F6, 0xB5D6, 0xB5F6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 
        0xB5D6, 0xB5D6, 0xB5F6, 0xB5D6, 0xB5F6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5D6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5D6, 0xADD6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 
        0xB5F6, 0xADD5, 0x9D94, 0x8533, 0x6CB0, 0x546F, 0x548F, 0x5CCF, 0x6D31, 0x6510, 0x64D0, 0x64D0, 0x6CF0, 0x6CF1, 0x74F1, 0x7CF1, 0x8D53, 0xA5F6, 0xB637, 0xC678, 0xCE98, 0xCE58, 0xBE16, 0xBDF5, 0xBDB4, 0xC5B4, 0xC593, 0xC572, 0xBD51, 0xB530, 
        0xB510, 0xB510, 0xB50F, 0xB50F, 0xB4EF, 0xB4EF, 0xB4EF, 0xB510, 0xB531, 0xB511, 0xACF0, 0xAD11, 0xB553, 0xBDB4, 0xC5F5, 0xC616, 0xC636, 0xC637, 0xC657, 0xC658, 0xC657, 0xCE78, 0xCE78, 0xC658, 0xC658, 0xC658, 0xC657, 0xC657, 0xC657, 0xC657, 
        0xC657, 0xC657, 0xC657, 0xC657, 0xC657, 0xCE57, 0xCE57, 0xC657, 0xC657, 0xC657, 0xC657, 0xCE57, 0xADD5, 0x5CAE, 0x54CE, 0x5CCE, 0x5CCE, 0x5CCE, 0x54AE, 0x94EC, 0xEDEA, 0xE5AB, 0x946A, 0x7BA7, 0xD568, 0xF64B, 0xE5CB, 0x6BE9, 0x442C, 0x5CCE, 
        0x5CEE, 0x5CEF, 0x5CEF, 0x5D0F, 0x6510, 0x7551, 0x7D72, 0x8572, 0x8593, 0x8593, 0x7D92, 0x7551, 0x6D51, 0x6530, 0x6510, 0x5D0F, 0x5D0F, 0x5D0F, 0x5D0F, 0x5D10, 0x5D10, 0x5CEF, 0x54CF, 0x43EC, 0x7C08, 0xE5CB, 0xE5CA, 0xE589, 0x8B87, 0x5A87, 
        0x7B68, 0xEEAF, 0xFEAD, 0xD5AB, 0x64AD, 0x54AF, 0x54CF, 0x54CF, 0x54CF, 0x54CF, 0x54CF, 0x54CF, 0x54CF, 0x54CF, 0x5CCF, 0x8D13, 0x9D34, 0x9534, 0x9534, 0x9514, 0x9514, 0x9514, 0x9514, 0x9534, 0x9534, 0x9D34, 0x9534, 0x9D34, 0x9D34, 0x9D34, 
        0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0xA554, 0xADB5, 0xB5D6, 0xB5D5, 0xB5D5, 0xBDF6, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xB5D5, 0xAD95, 0xAD95, 0xA574, 
        0xA554, 0xA554, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D54, 0xA554, 0xA554, 0xA554, 0xA554, 0x9D54, 0x9D54, 0xA554, 0xAD74, 0xAD95, 0xAD95, 0xAD95, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA574, 0xA554, 0xAD74, 0xAD95, 0xB5B5, 
        0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5D5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xADB5, 0xAD75, 0xA574, 0xA574, 0xA574, 0xA554, 
        0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xCDF2, 0xC5D3, 0xAD94, 0xAD94, 0xAD94, 0xB594, 0xB5B5, 
        0xBDD5, 0xBDD5, 0xBDD5, 0xB5D5, 0xB5B5, 0xAD94, 0xAD74, 0xA554, 0xA554, 0x9D33, 0x9D53, 0x9D53, 0x9D34, 0xA554, 0xDEB8, 0xCE36, 0xE6D9, 0xDEB8, 0xBDB4, 0xEF5B, 0xD678, 0xA532, 0xEF5C, 0xE6FA, 0xAD32, 0xDED9, 0xDEDA, 0xB5B4, 0xDEDA, 0xCE58, 
        0xB5B5, 0x9513, 0x9D33, 0x9D33, 0x9D54, 0x9D53, 0x9D53, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA574, 0xAD74, 0xAD74, 0xAD94, 0xAD94, 0xAD74, 0xA574, 0xA574, 0xAD74, 0xAD94, 0xAD94, 0xA574, 0xA554, 0x9D33, 0x9D33, 0x9D33, 0xA554, 0xA574, 
        0xA574, 0xAD94, 0xB594, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B4, 0xB5B4, 0xB5B5, 0xB5B5, 0xB594, 0xB594, 0xAD94, 0xAD94, 0xAD94, 0xAD94, 0xAD74, 0xAD94, 0xB594, 0xB5B5, 0xB5B5, 0xB5B5, 0xAD94, 0xAD74, 0xA553, 0x9D53, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 
        0x9D33, 0x9D33, 0x9D13, 0x9D33, 0x9513, 0x9513, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0x9D13, 0x9513, 0x94D2, 0x8CD2, 0x8CD2, 0x8CB2, 0x8CB2, 0x8492, 0x8492, 0x7C92, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 
        0x7C72, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7451, 0x7C71, 0x7C71, 0x7C51, 0x7C51, 0x7C72, 0x7C72, 0x7471, 0x7471, 0x7C71, 0x7C72, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7451,
  0xDE97, 0xD697, 0xD677, 0xCE57, 0xC616, 0xBE16, 0xBE16, 0xC616, 0xC636, 0xC636, 0xCE57, 0xCE37, 0xC636, 0xC636, 0xC637, 0xC636, 0xCE57, 0xCE57, 0xCE57, 0xC637, 0xC637, 0xC637, 0xBE16, 0xBE16, 0xBE16, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 
        0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB5F6, 0xADD6, 0xA5B5, 0x8D53, 
        0x7D12, 0x64B0, 0x548F, 0x548F, 0x4C8F, 0x548F, 0x5CF0, 0x6530, 0x6511, 0x6531, 0x6510, 0x5D10, 0x5D10, 0x5D10, 0x6510, 0x6510, 0x5CF0, 0x5CCF, 0x64F0, 0x6D10, 0x6D11, 0x7531, 0x7D52, 0x8D94, 0x95B4, 0xA5F5, 0xAE16, 0xB616, 0xBE16, 0xC657, 
        0xC636, 0xCE36, 0xCE15, 0xC5F4, 0xC5D4, 0xCDD4, 0xCDB3, 0xCDB2, 0xC572, 0xBD51, 0xB531, 0xB510, 0xB510, 0xB510, 0xB510, 0xB531, 0xBD51, 0xB532, 0xB552, 0xB552, 0xB593, 0xBDB4, 0xBDD5, 0xBDF6, 0xBE16, 0xC637, 0xC658, 0xC658, 0xC658, 0xC658, 
        0xC678, 0xC658, 0xC658, 0xC658, 0xC657, 0xC657, 0xC657, 0xC657, 0xC657, 0xC637, 0xC657, 0xB616, 0x6CF0, 0x54CE, 0x5CEF, 0x5CEF, 0x5CCE, 0x5CCE, 0x5CCE, 0xB54B, 0xEDCA, 0xDD48, 0xCCA6, 0xD527, 0xD527, 0xD528, 0xB488, 0x63EA, 0x6D10, 0x7D51, 
        0x8592, 0x95D3, 0x9DF4, 0xA5F5, 0xA5F4, 0x9D93, 0xADD4, 0xD6D9, 0xCEB9, 0x9D94, 0x9553, 0x9D94, 0x9DD5, 0x9DF5, 0x9DF5, 0x95F5, 0x8DB4, 0x8DD3, 0x7D92, 0x6D51, 0x6D51, 0x6D31, 0x6530, 0x548D, 0x73E7, 0xCD08, 0xDD49, 0xDD48, 0xD529, 0xB428, 
        0xDD6B, 0xE5EB, 0xF60B, 0xD508, 0x84ED, 0x54CF, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CF0, 0x5CEF, 0x54EF, 0x5CEF, 0x54CF, 0x6CF0, 0x8D33, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9534, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 
        0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0xA554, 0xA554, 0xA554, 0xA574, 0xAD95, 0xB5B5, 0xB5D5, 0xBDF6, 0xBDF6, 0xBDD5, 0xB5D5, 0xB5B5, 0xB5B5, 0xADB5, 0xAD95, 0xAD95, 
        0xA575, 0xA554, 0xA554, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0xA554, 0xA574, 0xA574, 0xA574, 0xA574, 0xAD75, 0xB5B5, 0xB595, 0xB5B5, 0xAD94, 0xA554, 0xA554, 0xA554, 0xA574, 0xAD95, 0xAD75, 0xA574, 0xAD94, 0xB5B5, 0xB5B5, 
        0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5B5, 0xB5B5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 0xADB5, 0xAD94, 0xA574, 0xA574, 0xA574, 0xA574, 0xA554, 
        0xA554, 0xA574, 0xA574, 0xA554, 0xA554, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA554, 0xA554, 0xA554, 0xA553, 0xCE13, 0xC5F4, 0xB594, 0xB5B4, 0xB5B5, 0xB5B4, 0xB5D5, 
        0xBDD5, 0xBDD5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5B5, 0xAD94, 0xA574, 0xA554, 0xA554, 0x9D54, 0x9D54, 0x9D34, 0xA554, 0xDE97, 0xCE36, 0xDEB9, 0xDED9, 0xCE36, 0xEF3B, 0xDEB9, 0xC636, 0xE71B, 0xE6FA, 0xC616, 0xDED9, 0xDEDA, 0xC616, 0xDEB9, 0xCE57, 
        0xB5D6, 0x9D33, 0x9D33, 0x9D54, 0x9D54, 0x9D54, 0xA554, 0xA554, 0xA554, 0xA554, 0xA553, 0xA554, 0xA554, 0xA574, 0xAD74, 0xAD74, 0xAD94, 0xA574, 0xA574, 0xAD74, 0xAD74, 0xAD74, 0xA554, 0xA554, 0x9D53, 0x9D33, 0x9D33, 0xA554, 0xA574, 0xA574, 
        0xAD94, 0xB594, 0xB5B5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5B5, 0xB5B5, 0xB5B4, 0xAD94, 0xAD74, 0xAD74, 0xAD94, 0xAD94, 0xAD94, 0xAD94, 0xB594, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB594, 0xAD94, 0xAD74, 0xA574, 0xA574, 0xA554, 0xA554, 0x9D53, 
        0x9D33, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0xA553, 0xA553, 0x9D53, 0x9D33, 0x9D33, 0x9D33, 0x9D13, 0x94F2, 0x8CD2, 0x8CD2, 0x8CB2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x84B2, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C92, 
        0x7C91, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C52, 0x7C71, 0x7C71, 0x7C51, 0x7451, 0x7C72, 0x7C72, 0x7452, 0x7472, 0x7472, 0x7472, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C72, 0x7C71, 0x7471, 0x7471, 0x7C71, 0x7C71, 0x7C71, 0x7C52,
  0xDE97, 0xD677, 0xD677, 0xCE57, 0xC636, 0xC616, 0xBE16, 0xC616, 0xC636, 0xCE57, 0xD677, 0xD677, 0xD657, 0xD677, 0xD677, 0xD677, 0xD697, 0xD697, 0xD697, 0xD677, 0xCE57, 0xCE57, 0xC657, 0xC637, 0xC636, 0xBE16, 0xBE16, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 
        0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xB616, 0xB616, 0xB616, 0xB616, 0xB616, 0xBE16, 0xBDF6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5F6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5D6, 0xB5F6, 0xB5F6, 0xB616, 0xB5F6, 0xA5B5, 0x9553, 0x7D12, 0x64B0, 0x548F, 0x4C6E, 
        0x4C8F, 0x54AF, 0x4CAF, 0x4C8E, 0x54AF, 0x5D10, 0x6510, 0x6510, 0x6510, 0x6510, 0x5D10, 0x5D10, 0x5D10, 0x5D10, 0x5D10, 0x5D10, 0x5D10, 0x5D10, 0x6510, 0x6510, 0x6510, 0x5D10, 0x6510, 0x6510, 0x5CF0, 0x64F0, 0x64F0, 0x6510, 0x6D10, 0x6D31, 
        0x7531, 0x8573, 0x95B4, 0x95B4, 0x9DB4, 0xAE16, 0xB637, 0xBE37, 0xC657, 0xC636, 0xC636, 0xCE16, 0xC5F5, 0xCDD4, 0xC5D4, 0xCDD3, 0xC592, 0xBD52, 0xB551, 0xB511, 0xB4F0, 0xAD10, 0xACF0, 0xACF1, 0xACF1, 0xACF1, 0xAD32, 0xB552, 0xBD73, 0xBD94, 
        0xBDB4, 0xBDD5, 0xBDF6, 0xC616, 0xCE57, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xB636, 0x7510, 0x54CE, 0x54CF, 0x54CE, 0x54CE, 0x54CE, 0x54AE, 0x5C8D, 0xC58C, 0xCD2A, 0xB4A9, 0xD56C, 0xD5CF, 0xB570, 0xB592, 0xB592, 0xA5B3, 0xBE57, 0xD6B8, 
        0x9D52, 0x84CF, 0x7C6D, 0x6BEB, 0x63CB, 0x63CB, 0x8CAE, 0xE71A, 0xDEFB, 0x84AF, 0x63EC, 0x642C, 0x642D, 0x640C, 0x6C6E, 0x7CAF, 0x84F1, 0x8D31, 0xADF5, 0xC6B9, 0x9DD5, 0x9DD5, 0x9DF5, 0x9DD5, 0x9D51, 0xB50E, 0xAD0E, 0xB4EC, 0xBCEA, 0xB449, 
        0xBC68, 0xCD4B, 0xCD4A, 0xDD69, 0x9D0C, 0x54AF, 0x5CEF, 0x5CEF, 0x5CEF, 0x5D10, 0x5D10, 0x5D10, 0x5CF0, 0x5CF0, 0x5D10, 0x5CEF, 0x6D11, 0x9533, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 
        0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0xA554, 0xA574, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xB5D5, 0xBDD5, 0xBDD5, 0xB5D5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 
        0xADB5, 0xAD74, 0xA554, 0xA554, 0x9D54, 0x9D54, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0xA554, 0xAD94, 0xAD95, 0xA574, 0xA574, 0xB595, 0xB5D5, 0xB5B5, 0xB5B5, 0xAD95, 0xA554, 0xA554, 0xA554, 0xAD94, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5D5, 0xB5D5, 
        0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xB5D5, 0xB5B5, 0xAD95, 0xAD74, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 
        0xA554, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xAD74, 0xAD95, 0xAD75, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD94, 0xAD94, 0xAD94, 0xAD94, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xAD54, 0xCDD1, 0xC5B2, 0xB5B5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 
        0xBDD5, 0xB5D5, 0xB5B5, 0xB5B5, 0xB5D5, 0xB5B5, 0xAD94, 0xAD94, 0xAD74, 0xA574, 0xA554, 0xA554, 0xA554, 0xA553, 0xC5D4, 0xDEB7, 0xD677, 0xDE98, 0xE6DA, 0xDE98, 0xD678, 0xDEFA, 0xDEB9, 0xD698, 0xDEDA, 0xD699, 0xC637, 0xD6B9, 0xCE58, 0xCE57, 
        0xB595, 0x9D33, 0x9D33, 0x9D53, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0xA553, 0xA554, 0xA554, 0xA554, 0xA554, 0xA574, 0xAD74, 0xAD74, 0xAD74, 0xAD74, 0xAD74, 0xAD74, 0xAD74, 0xA574, 0xA554, 0x9D33, 0x9D33, 0xA533, 0xA574, 0xAD74, 0xAD74, 0xAD94, 
        0xB594, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 0xBDD5, 0xB5D5, 0xB5B5, 0xB5B5, 0xB594, 0xAD94, 0xAD94, 0xA574, 0xAD74, 0xB594, 0xB5B5, 0xB5B5, 0xB5B5, 0xBDD5, 0xBDD5, 0xB5D5, 0xB5B4, 0xB5B4, 0xB5D5, 0xB5D5, 0xB5B4, 0xAD94, 0xAD74, 0xAD74, 0xA554, 
        0xA554, 0x9D33, 0x9D33, 0x9D33, 0x9D53, 0xA554, 0xA554, 0xA553, 0xA553, 0x9D33, 0x9D33, 0x9D13, 0x9D13, 0x9D13, 0x94F2, 0x8CD2, 0x8CB2, 0x8CB2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C91, 0x7C92, 0x8492, 0x7C92, 
        0x7C91, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C52, 0x7C71, 0x7451, 0x7451, 0x7C52, 0x7452, 0x7C52, 0x7C52, 0x7472, 0x7452, 0x7451, 0x7452, 0x7451, 0x7471, 0x7C72, 0x7C72, 0x7471, 0x7451, 0x7452, 0x7452, 0x7C72, 0x7471, 0x7C72,
  0xD677, 0xD677, 0xD677, 0xD677, 0xCE56, 0xCE36, 0xC616, 0xC616, 0xCE36, 0xCE56, 0xD677, 0xD677, 0xD677, 0xD677, 0xDE97, 0xDE98, 0xDE98, 0xDE98, 0xDE98, 0xDE97, 0xD697, 0xD677, 0xD677, 0xCE57, 0xC637, 0xC636, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 
        0xBE36, 0xC637, 0xBE37, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE36, 0xBE36, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xB5F6, 0xB5F6, 0xB617, 0xB5F6, 0xB616, 0xB5F6, 0xADD6, 0x9553, 0x7D12, 0x6CD0, 0x546E, 0x4C6E, 0x444E, 0x4C6E, 0x4C8F, 0x4C8F, 
        0x4C8E, 0x444D, 0x4C6E, 0x54AF, 0x54F0, 0x5CF0, 0x5CEF, 0x5CF0, 0x5CF0, 0x5D10, 0x5D10, 0x5D10, 0x5D10, 0x5D10, 0x5D10, 0x5D10, 0x5D10, 0x5D10, 0x5D10, 0x6510, 0x5D10, 0x6510, 0x6510, 0x6510, 0x6510, 0x6510, 0x6510, 0x6510, 0x6510, 0x6510, 
        0x6510, 0x6510, 0x6510, 0x6510, 0x6510, 0x6510, 0x6D30, 0x6D31, 0x7531, 0x7531, 0x7D52, 0x8D93, 0x95B4, 0xA5F5, 0xADF6, 0xADF5, 0xB616, 0xC657, 0xC657, 0xCE36, 0xCE16, 0xC5F5, 0xC5D4, 0xBD93, 0xB552, 0xAD31, 0xB511, 0xB530, 0xB530, 0xB510, 
        0xB510, 0xB531, 0xB510, 0xAD10, 0xB531, 0xAD31, 0xAD12, 0xAD52, 0xB574, 0xAD73, 0x9532, 0x8531, 0x8552, 0x7D72, 0x7D72, 0x8592, 0x95F4, 0x9DF4, 0xA5D4, 0xB5B2, 0xC635, 0xC656, 0x9D31, 0x8CD0, 0x7C8F, 0x744D, 0x63CB, 0x5B89, 0xA552, 0xE71A, 
        0x8CCF, 0x848E, 0x9D30, 0xAD92, 0xB5F4, 0xA572, 0xC656, 0xCE98, 0xCE99, 0xC678, 0xBE77, 0xBE36, 0xADF5, 0x9D93, 0x9572, 0x8510, 0x7CAF, 0x640D, 0xA594, 0xD6DA, 0x6C2D, 0x5BEC, 0x5C0D, 0x6C4E, 0x7CD0, 0x84F1, 0x8D12, 0x9533, 0xA593, 0xC636, 
        0xB5D4, 0x9D52, 0x9D52, 0xBD91, 0x9D72, 0x7D73, 0x7551, 0x6D31, 0x6510, 0x5CF0, 0x5CEF, 0x5D10, 0x5D10, 0x5D10, 0x5D10, 0x5D10, 0x5D10, 0x6D11, 0x8D33, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 
        0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0xA554, 0xAD95, 0xB5D6, 0xBDF6, 0xBDF6, 0xB5D5, 0xB5D5, 0xB5D5, 0xBDF6, 0xBDF6, 0xBDD5, 0xB5D5, 0xB5D5, 0xB5D5, 0xBDD5, 0xBDD6, 
        0xB5B5, 0xAD75, 0xA574, 0xA554, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D33, 0xA554, 0xA574, 0xAD95, 0xAD74, 0xAD74, 0xB5B5, 0xBDD5, 0xBDD5, 0xBDD5, 0xB5B5, 0xAD74, 0xAD74, 0xAD74, 0xAD94, 0xB5B5, 0xB5D5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDF5, 
        0xBDD5, 0xBDD5, 0xBDD5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDD5, 0xB5B5, 0xAD94, 0xAD74, 0xAD74, 0xA574, 0xA574, 0xA574, 0xA574, 
        0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xAD74, 0xAD95, 0xAD95, 0xADB5, 0xB5B5, 0xB5B5, 0xB5B5, 0xAD94, 0xAD94, 0xAD94, 0xAD95, 0xAD74, 0xA574, 0xAD74, 0xAD94, 0xAD94, 0xB594, 0xCDB1, 0xC5B2, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDF5, 0xBDD5, 
        0xB5D5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xAD94, 0xAD94, 0xA574, 0xA574, 0xA554, 0xA554, 0xA574, 0x8C90, 0x9C8F, 0xBDB3, 0xD656, 0xCE36, 0xCE36, 0xD677, 0xCE57, 0xD698, 0xD678, 0xCE78, 0xD698, 0xC637, 0xC636, 0xB5B5, 0xB5B4, 0xBDD6, 
        0x8C91, 0x9D54, 0x9D34, 0x9D33, 0x9D53, 0x9D53, 0x9D53, 0x9D53, 0x9D33, 0xA554, 0xA554, 0xA554, 0xA574, 0xAD94, 0xAD94, 0xAD94, 0xAD94, 0xAD94, 0xAD74, 0xAD94, 0xAD74, 0xAD74, 0xA554, 0xA554, 0xA554, 0xA554, 0xAD94, 0xAD94, 0xAD94, 0xB594, 
        0xB5B4, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xB5D5, 0xB5B5, 0xB5B4, 0xAD94, 0xAD94, 0xAD94, 0xAD74, 0xAD74, 0xB5B4, 0xB5B5, 0xB5B5, 0xBDD5, 0xBDD5, 0xBDF5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDF5, 0xBDF5, 0xBDF5, 0xB5B5, 0xB594, 0xAD94, 0xAD74, 
        0xA554, 0xA553, 0xA533, 0x9D53, 0xA553, 0xA574, 0xA554, 0xA554, 0xA553, 0xA533, 0x9D33, 0x9D13, 0x9D13, 0x9D33, 0x9513, 0x94F2, 0x8CB2, 0x8CB2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x8492, 0x8492, 0x7C92, 
        0x7C91, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C51, 0x7451, 0x7451, 0x7451, 0x7452, 0x7451, 0x7452, 0x7452, 0x7472, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7471, 0x7471, 0x7451, 0x7452, 0x7451, 0x7451, 0x7451, 0x7472, 0x7C52,
  0xD677, 0xD677, 0xD677, 0xD677, 0xD677, 0xCE56, 0xCE36, 0xCE36, 0xCE56, 0xD677, 0xD677, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE98, 0xDE98, 0xDE98, 0xDE98, 0xDE98, 0xDE97, 0xD697, 0xD677, 0xD677, 0xCE57, 0xC637, 0xC636, 0xC636, 0xC637, 0xC637, 0xC637, 
        0xC657, 0xC657, 0xC657, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xC637, 0xC657, 0xC657, 0xC637, 0xC637, 0xBE37, 0xBE17, 0xB5D5, 0x9553, 0x9594, 0x9594, 0x8D73, 0x5C8F, 0x442D, 0x446E, 0x4C8E, 0x446E, 0x4C8E, 0x4C8E, 0x4C6E, 0x4C8E, 0x4C8E, 
        0x4C4E, 0x4C8E, 0x54CF, 0x54CF, 0x54CF, 0x54CF, 0x54CF, 0x5CF0, 0x5CF0, 0x5CCF, 0x54AF, 0x54CF, 0x5CF0, 0x5CF0, 0x5CF0, 0x5CF0, 0x54EF, 0x54CF, 0x54CF, 0x5CF0, 0x5D10, 0x5D10, 0x5CF0, 0x5CEF, 0x5D10, 0x6510, 0x6510, 0x6510, 0x6510, 0x6510, 
        0x6510, 0x6510, 0x6510, 0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6510, 0x6510, 0x6510, 0x64F0, 0x6D10, 0x6D31, 0x7531, 0x7D32, 0x8D93, 0xA616, 0xAE16, 0xBE78, 0xCE98, 0xCE99, 0xCE78, 0xCE36, 0xC5F5, 0xC5D4, 0xC5B3, 
        0xC592, 0xBD72, 0xB531, 0xB531, 0xBD31, 0xACD0, 0x9C8F, 0x9C8F, 0x8C2D, 0x73EB, 0x7C2C, 0x844D, 0x94AF, 0x9D11, 0x9D31, 0x9511, 0x9D52, 0x9511, 0x6BEC, 0x5328, 0x9D52, 0xDED9, 0x742C, 0x63CA, 0x744D, 0x84CF, 0x8CF0, 0x9D31, 0xBE16, 0xDEF9, 
        0xCE98, 0xBE56, 0xB5F5, 0xB5F5, 0x8CF1, 0x5BEC, 0x748E, 0x63CC, 0x536C, 0x6C0F, 0x7CB1, 0x9533, 0xA575, 0xB5F6, 0xBE58, 0xC699, 0xC699, 0xC678, 0xCEDA, 0xDEFB, 0x9D73, 0x8D31, 0x8511, 0x7CCF, 0x748E, 0x6C4D, 0x640C, 0x5BCB, 0x746E, 0xD6DA, 
        0xADB5, 0x640D, 0x7CB0, 0x8512, 0x9D74, 0xA5B5, 0xAE16, 0xB657, 0xAE37, 0x95D5, 0x8DB4, 0x8DB4, 0x85B3, 0x7572, 0x6D51, 0x6D51, 0x6530, 0x6510, 0x6CF1, 0x8D33, 0x9534, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D34, 0x9D54, 0x9D54, 
        0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0xA554, 0xB5B5, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDD5, 0xBDD5, 0xBDF5, 0xBDF5, 0xBDD5, 
        0xB5B5, 0xAD75, 0xA574, 0xA574, 0x9D54, 0x9D54, 0x9D54, 0x9D34, 0x9D54, 0xA553, 0xA554, 0xA554, 0xAD75, 0xAD94, 0xAD74, 0xAD95, 0xBDD5, 0xBDD5, 0xB5D5, 0xB5B5, 0xAD94, 0xAD94, 0xAD94, 0xAD95, 0xB5B5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDF5, 0xBDF5, 
        0xBDD5, 0xBDD5, 0xBDF5, 0xC5F5, 0xC5F6, 0xC5F5, 0xBDF5, 0xBDF6, 0xC5F6, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xC5F5, 0xBDF5, 0xBDF5, 0xBDF5, 0xB5D5, 0xB5B5, 0xAD95, 0xAD95, 0xAD95, 0xAD74, 0xA574, 0xA574, 0xA574, 
        0xA574, 0xAD94, 0xAD95, 0xAD74, 0xAD74, 0xAD74, 0xA574, 0xAD75, 0xAD94, 0xAD94, 0xB5B5, 0xB5B5, 0xB5B5, 0xAD94, 0xAD95, 0xAD95, 0xAD95, 0xAD94, 0xAD74, 0xAD94, 0xB5B4, 0xB5B5, 0xBDB5, 0xDE74, 0xD634, 0xBDD5, 0xBDD5, 0xBDF5, 0xBDF5, 0xBDF5, 
        0xBDD5, 0xB5B5, 0xB5B5, 0xB5D5, 0xB5B5, 0xB5B5, 0xB595, 0xAD94, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0x73ED, 0x8C6E, 0xB552, 0xD636, 0xD636, 0xB593, 0xD677, 0xD698, 0xCE57, 0xCE57, 0xDED9, 0xCE57, 0xC637, 0xCE77, 0x94B1, 0xBDD5, 0x9D12, 
        0x844F, 0x9D33, 0x9D34, 0x9D54, 0x9D53, 0x9D53, 0x9D53, 0x9D53, 0x9D53, 0xA554, 0xA554, 0xA574, 0xAD94, 0xB595, 0xB5B5, 0xB5B5, 0xB5B5, 0xAD94, 0xAD94, 0xAD94, 0xAD74, 0xAD74, 0xA574, 0xA574, 0xAD74, 0xAD94, 0xAD94, 0xB594, 0xB594, 0xB5B4, 
        0xB5D5, 0xB5D5, 0xBDD5, 0xBDD5, 0xBDB5, 0xB5D5, 0xB5B5, 0xB5B5, 0xB5B4, 0xB5B4, 0xB594, 0xAD94, 0xAD94, 0xAD94, 0xB5B4, 0xB5D5, 0xB5D5, 0xBDD5, 0xBDD5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xB5D5, 0xB5B4, 0xAD94, 0xAD74, 
        0xA574, 0xA553, 0xA553, 0xA553, 0xA553, 0xA554, 0xA554, 0xA553, 0xA553, 0xA533, 0x9D33, 0x9D13, 0x9D13, 0x9D13, 0x9513, 0x94F2, 0x8CD2, 0x8CB2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x8492, 0x7C71, 
        0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C51, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451,
  0xDE97, 0xDE97, 0xD677, 0xD677, 0xD697, 0xD697, 0xD677, 0xD677, 0xD677, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE98, 0xDE98, 0xDE98, 0xDE98, 0xDE98, 0xDE97, 0xD697, 0xD697, 0xD697, 0xD677, 0xCE77, 0xCE57, 0xCE57, 0xCE57, 0xC657, 0xCE57, 
        0xCE77, 0xD677, 0xCE77, 0xCE77, 0xCE57, 0xCE57, 0xCE57, 0xC637, 0xC657, 0xCE77, 0xCE77, 0xCE57, 0xBE16, 0xB5F6, 0x9D94, 0x74B0, 0x8D11, 0x6CF0, 0x448E, 0x446E, 0x446E, 0x446E, 0x4C8E, 0x4C8E, 0x4C8E, 0x4C8E, 0x446E, 0x4C6E, 0x4C6E, 0x548F, 
        0x54AF, 0x54AF, 0x5CF0, 0x5CF0, 0x5CCF, 0x54AF, 0x54AF, 0x5CCF, 0x5CCF, 0x5CCF, 0x54CF, 0x54CF, 0x54EF, 0x54EF, 0x54F0, 0x4CAF, 0x54CF, 0x54CF, 0x54AF, 0x4C6E, 0x446D, 0x5CCF, 0x74D0, 0x644E, 0x5C8E, 0x5D10, 0x6530, 0x5D10, 0x6510, 0x6530, 
        0x6530, 0x6510, 0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6531, 0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6510, 0x6530, 0x6510, 0x6510, 0x6D10, 0x6D11, 0x7531, 0x7531, 0x7D52, 0x8D93, 0x95B4, 0x9DF5, 0xA5F5, 
        0xB616, 0xBE36, 0xBE16, 0xC657, 0xCE57, 0xC5F6, 0xBDD5, 0xBD94, 0xA512, 0x94AF, 0x8C4D, 0x7BAB, 0x842D, 0xA4D0, 0x6B28, 0x5AE7, 0x6BAA, 0x742D, 0x848E, 0x94EF, 0xBE15, 0xD6D9, 0xBE15, 0xB615, 0xB5F5, 0xADB4, 0xA573, 0x9D52, 0x8D11, 0x84D0, 
        0x7CAF, 0x7C6E, 0x8CCF, 0x9D31, 0x6BAA, 0x94CF, 0x9CEF, 0x948E, 0x8C90, 0x8490, 0x8470, 0x7C70, 0x744F, 0x6C0E, 0x6C2F, 0x6C4F, 0x7470, 0x7C90, 0x84D1, 0x8512, 0x9D74, 0xA5B5, 0xADF6, 0xB637, 0xC678, 0xBE57, 0xADF5, 0xADD5, 0xB616, 0xDF3B, 
        0xBE37, 0x7CAF, 0x748E, 0x640C, 0x6C4D, 0x6C2D, 0x5BEC, 0x640C, 0x640C, 0xADB4, 0xD6FA, 0x9552, 0x8D32, 0x9573, 0x9594, 0x9DB4, 0x9DD5, 0x9DF5, 0x95D5, 0x9DB5, 0xA5B5, 0xADB6, 0xA595, 0xA575, 0x9D55, 0x9D54, 0x9D34, 0x9534, 0x9D34, 0x9D34, 
        0x9D34, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0xA574, 0xAD95, 0xB5D5, 0xBDF6, 0xBDF6, 0xBE16, 0xBDF6, 0xBDF6, 0xBDF6, 0xBE16, 0xBE16, 0xBDF6, 0xBDF6, 0xB5D5, 0xBDD5, 0xBDF5, 0xBDD5, 
        0xB5B5, 0xAD95, 0xAD75, 0xA574, 0xA554, 0x9D54, 0x9D54, 0x9D54, 0xA554, 0xB594, 0xAD54, 0xA554, 0xAD74, 0xAD95, 0xAD95, 0xAD94, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xAD94, 0xAD94, 0xB5B5, 0xBDD5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 
        0xBDF5, 0xBDF5, 0xC615, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC5F5, 0xC5F5, 0xC615, 0xC616, 0xC616, 0xC616, 0xC615, 0xC616, 0xC5F6, 0xBDF5, 0xB5D5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xAD95, 0xAD94, 0xAD94, 0xAD74, 
        0xAD74, 0xAD95, 0xAD95, 0xAD95, 0xAD94, 0xAD94, 0xAD74, 0xAD75, 0xAD94, 0xAD95, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB595, 0xB595, 0xAD94, 0xAD94, 0xAD94, 0xB5B4, 0xB5D5, 0xBDF5, 0xBDD4, 0xDE53, 0xDE74, 0xBDF5, 0xC5F5, 0xC5F5, 0xBDF5, 0xBDF5, 
        0xBDD5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xAD94, 0xAD94, 0xAD94, 0xAD94, 0xAD74, 0xA574, 0x632B, 0x8C2E, 0xCE15, 0xB553, 0xCE16, 0xCE16, 0xA4F1, 0xB574, 0xD678, 0xBDF6, 0x9CD1, 0xC616, 0xD698, 0xA532, 0xA532, 0xC637, 0xA533, 
        0x846F, 0x9512, 0x9D53, 0x9D53, 0x9D53, 0x9D53, 0xA553, 0xA554, 0xA554, 0xA574, 0xAD74, 0xAD95, 0xB5B5, 0xB5D5, 0xB5D5, 0xB5B5, 0xB5B5, 0xAD94, 0xAD94, 0xAD74, 0xAD74, 0xA574, 0xAD74, 0xAD94, 0xAD94, 0xAD94, 0xB594, 0xB5B4, 0xB5B4, 0xB5B5, 
        0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B4, 0xB594, 0xB594, 0xB594, 0xB594, 0xB5B5, 0xB5D5, 0xBDD5, 0xBDD5, 0xBDF5, 0xBDF5, 0xBDF5, 0xC5F5, 0xC5F5, 0xC5F5, 0xC615, 0xC615, 0xBDF5, 0xB5D5, 0xB5B4, 0xB594, 0xAD94, 
        0xAD74, 0xA554, 0xA553, 0x9D53, 0xA554, 0xA554, 0xA554, 0xA553, 0xA553, 0xA533, 0x9D33, 0x9D13, 0x9D13, 0x94F2, 0x9512, 0x94F2, 0x8CD2, 0x8CB2, 0x8CB2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C92, 0x7C72, 0x7C71, 0x7C71, 
        0x7C71, 0x7C71, 0x7C72, 0x7C71, 0x7C71, 0x7451, 0x7451, 0x7C51, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7452, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451,
  0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE98, 0xDE98, 0xDE98, 0xDE97, 0xDE97, 0xDE97, 0xD697, 0xD677, 0xD677, 0xD677, 0xCE77, 0xD678, 0xD677, 0xD677, 
        0xD677, 0xD698, 0xD697, 0xCE57, 0xCE57, 0xC637, 0xBDF6, 0xBE36, 0xC657, 0xADD5, 0xA5B4, 0x9573, 0x6CD0, 0x546E, 0x4C2D, 0x5C6E, 0x8511, 0x5C8E, 0x3C2D, 0x446E, 0x4C6E, 0x4C6E, 0x4C6E, 0x4C6E, 0x444D, 0x442D, 0x440C, 0x440D, 0x442D, 0x54AF, 
        0x5CAF, 0x546E, 0x548F, 0x5CF0, 0x5CF0, 0x5CF0, 0x5CCF, 0x5CCF, 0x5CCF, 0x54CF, 0x54AF, 0x54AF, 0x5CCF, 0x54CF, 0x54AF, 0x54AF, 0x54CF, 0x54EF, 0x54CF, 0x4CAF, 0x3C2C, 0x548E, 0x8D52, 0x8CF1, 0x6CB0, 0x442D, 0x5CF0, 0x5CF0, 0x54EF, 0x54CF, 
        0x5CF0, 0x5D10, 0x5D10, 0x5D10, 0x5D10, 0x6530, 0x6510, 0x5D10, 0x5D10, 0x5D10, 0x5D10, 0x6530, 0x6530, 0x6530, 0x5D10, 0x6531, 0x6D30, 0x6530, 0x6530, 0x6530, 0x6510, 0x6531, 0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6510, 0x6510, 
        0x6D30, 0x6D31, 0x6D31, 0x7552, 0x7D73, 0x8DB4, 0x95D5, 0x9DD5, 0x9DB4, 0xADD5, 0xA574, 0xA573, 0xADB4, 0xB5D5, 0xA511, 0xA531, 0xB5F4, 0xADB4, 0x9D73, 0x9552, 0x8CF1, 0x84AF, 0x84AF, 0x7C8E, 0x7C8E, 0x84AE, 0x848E, 0x848D, 0x8C8D, 0x948D, 
        0x9CAE, 0xA4AD, 0xACCE, 0xB550, 0x9C6C, 0xB4CD, 0xC50E, 0xB50F, 0xB4EF, 0xACAE, 0xA46E, 0xA48E, 0x9C8F, 0x9CB0, 0x9CB0, 0x9CB0, 0x948F, 0x8CB0, 0x848F, 0x7C6F, 0x7C6F, 0x744F, 0x6C2E, 0x6C0E, 0x742E, 0x7C6F, 0x7C90, 0x84D1, 0x9533, 0x9553, 
        0xA595, 0xADF6, 0xB637, 0xBE78, 0xBE57, 0xB5F6, 0xADD5, 0xA5D4, 0x9551, 0xBE36, 0xD6DA, 0x7CAF, 0x63EC, 0x640C, 0x640C, 0x640C, 0x5BEC, 0x640D, 0x6C6E, 0x8D32, 0xCEB9, 0x9D74, 0x9D54, 0xAD95, 0xADB6, 0xB5D6, 0xB5F7, 0xB5D6, 0xADD6, 0xADD6, 
        0xA575, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0xA554, 0xA574, 0xAD75, 0xB5D5, 0xBDD5, 0xBDF6, 0xBE16, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xBDF5, 0xBDD5, 0xB5D5, 0xBDD5, 0xBDD5, 0xBDF5, 
        0xB5D5, 0xB5B5, 0xAD95, 0xAD95, 0xA574, 0x9D54, 0xA554, 0xA554, 0xA574, 0xC5D4, 0xAD94, 0xAD95, 0xB5B5, 0xB5B5, 0xB5B5, 0xB595, 0xB5B5, 0xB5B5, 0xB5B5, 0xBDF5, 0xBDF5, 0xBDD5, 0xB595, 0xB594, 0xB5B5, 0xBDD5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 
        0xBDF5, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xBDF5, 0xBDD5, 0xBDD5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5B5, 0xAD94, 0xAD74, 
        0xAD94, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD94, 0xAD95, 0xAD95, 0xAD95, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xADB5, 0xB5B5, 0xBDD5, 0xBDF5, 0xBDF5, 0xBDB4, 0xDE32, 0xEEB4, 0xC5F5, 0xC615, 0xC5F5, 0xC5F5, 0xBDD5, 
        0xBDF5, 0xB5D5, 0xB5B4, 0xAD94, 0xB5B4, 0xAD94, 0xAD95, 0xB595, 0xAD94, 0xAD94, 0xAD94, 0xAD94, 0xAD74, 0x738C, 0xA4F1, 0xE6D6, 0x946E, 0xC5D3, 0xEEF6, 0xA50F, 0xB573, 0xDE95, 0xC5F4, 0xA532, 0xD654, 0xD634, 0xB553, 0xB552, 0xA532, 0xA532, 
        0x9CF2, 0x9512, 0xA554, 0xA554, 0x9D54, 0xA554, 0xA554, 0xA554, 0xA574, 0xAD94, 0xAD94, 0xADB4, 0xB5D5, 0xBDD5, 0xB5D5, 0xB5B4, 0xAD94, 0xAD94, 0xAD94, 0xAD94, 0xAD74, 0xAD74, 0xAD94, 0xAD94, 0xB573, 0xCD91, 0xBD92, 0xB5B4, 0xB5B4, 0xBDD5, 
        0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5D5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDF5, 0xC5F5, 0xC5F5, 0xC5F5, 0xC5F5, 0xC5F5, 0xC615, 0xC615, 0xC615, 0xBDF5, 0xB5D5, 0xB5B4, 0xB594, 0xAD94, 
        0xAD74, 0xA554, 0xA553, 0x9D53, 0xA553, 0xA553, 0x9D53, 0x9D53, 0x9D33, 0x9D33, 0x9D33, 0x9D13, 0x9513, 0x94F2, 0x94F2, 0x94F2, 0x8CD2, 0x8CB2, 0x8CB2, 0x8CB2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x7C92, 0x7C92, 0x7C72, 0x7C72, 0x7C71, 0x7C71, 
        0x7C71, 0x7C71, 0x7C71, 0x7451, 0x7C51, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x6C51, 0x6C51, 0x7451, 0x6C31, 0x7451, 0x7451, 0x7431, 0x7451,
  0xDE77, 0xDE97, 0xDE98, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE98, 0xDE98, 0xDE98, 0xDE98, 0xDE98, 0xDE98, 0xDE97, 0xD697, 0xD677, 0xD677, 0xCE77, 0xCE57, 0xCE57, 0xD677, 
        0xCE36, 0xD677, 0xDE97, 0xCE36, 0xCE36, 0xCE77, 0xB5F5, 0x9D73, 0x74D0, 0x546E, 0x4C2D, 0x4C2D, 0x442D, 0x444E, 0x3C2D, 0x442D, 0x444D, 0x444D, 0x444D, 0x4C4D, 0x43EB, 0x43EB, 0x542D, 0x4C0C, 0x542D, 0x7CF0, 0x8D52, 0x8512, 0x6CB0, 0x5C8F, 
        0x5C8F, 0x546E, 0x43ED, 0x4BED, 0x440D, 0x440C, 0x442D, 0x4C6E, 0x548E, 0x548E, 0x548E, 0x548E, 0x5CAF, 0x54CF, 0x54AF, 0x54AE, 0x54AF, 0x54CF, 0x5CCF, 0x54AF, 0x4CAE, 0x548E, 0x5C8E, 0x5C6E, 0x544E, 0x3BEC, 0x54AF, 0x54F0, 0x54CF, 0x54CF, 
        0x5CF0, 0x5CF0, 0x5CF0, 0x54CF, 0x5CEF, 0x5D10, 0x5D10, 0x5CEF, 0x54CF, 0x54AF, 0x4C8E, 0x54CF, 0x6510, 0x64CF, 0x544E, 0x548F, 0x6D51, 0x6531, 0x6531, 0x6530, 0x6D31, 0x6530, 0x6510, 0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 
        0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6510, 0x6510, 0x6510, 0x64F0, 0x6D10, 0x6D11, 0x7531, 0x7D32, 0x8552, 0x8552, 0x4B8B, 0x53AB, 0x7C8E, 0x8CCF, 0xA551, 0xA530, 0x94AE, 0x8C4D, 0x946D, 0x946C, 0xA4AD, 0xB4CD, 0xBCED, 0xBCCD, 
        0xCD2E, 0xCD4E, 0xD56E, 0xD54E, 0xCD70, 0xD54E, 0xE58E, 0xD5F3, 0xCD91, 0xDD4E, 0xDD4E, 0xD54F, 0xD52F, 0xBCEE, 0x8C0C, 0xBCEE, 0xBD0F, 0xBCEF, 0xB4CF, 0xA48E, 0x9C6E, 0x9C4E, 0x946E, 0x8C4F, 0x83ED, 0x7C0E, 0x844F, 0x8CB0, 0x8490, 0x7C6F, 
        0x7C6F, 0x744F, 0x6C0E, 0x63ED, 0x640E, 0x744F, 0x7CB1, 0x8D12, 0xA595, 0xBE78, 0xCEBA, 0xCE99, 0xC678, 0xBE57, 0xBE56, 0xAE15, 0x9D73, 0x84F0, 0x746E, 0x8CF1, 0xDEFA, 0x744E, 0x5BEC, 0x6BED, 0x7C2F, 0x8470, 0x94F2, 0xA533, 0xA574, 0x9512, 
        0xC658, 0xA575, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0x9D54, 0xA554, 0xA554, 0xA574, 0xAD95, 0xB5D5, 0xBDF6, 0xBDF6, 0xBE16, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xBDF5, 0xBDF5, 0xBDD5, 0xBDD5, 0xBDF5, 0xBDD5, 
        0xBDD5, 0xBDD5, 0xB5B5, 0xADB5, 0xAD94, 0xA574, 0xA554, 0xA554, 0xAD94, 0xC5F4, 0xB5B4, 0xAD94, 0xB5B5, 0xB5D5, 0xB5D5, 0xBDD5, 0xBDF5, 0xBDD5, 0xBDF5, 0xC616, 0xC5F6, 0xBDF5, 0xBDD5, 0xBDD5, 0xBDF5, 0xBDF5, 0xBDF5, 0xC5F6, 0xC5F6, 0xC5F5, 
        0xC5F5, 0xC616, 0xCE36, 0xCE16, 0xCE36, 0xCE16, 0xCE16, 0xCE36, 0xC636, 0xC636, 0xC636, 0xC616, 0xC616, 0xCE36, 0xC616, 0xC616, 0xC616, 0xC636, 0xC636, 0xC616, 0xC615, 0xBDF5, 0xBDF5, 0xBDF6, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDD5, 0xB595, 0xAD95, 
        0xAD95, 0xAD95, 0xAD95, 0xADB5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5D5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDB4, 0xD5F0, 0xF6F4, 0xCDF4, 0xC615, 0xC615, 0xBDF5, 0xBDD5, 
        0xBDF5, 0xBDD5, 0xB594, 0xB594, 0xAD94, 0xAD94, 0xAD94, 0xAD94, 0xAD94, 0xAD94, 0xAD74, 0xAD74, 0xAD53, 0xA4F1, 0xE697, 0xF755, 0xBD70, 0xCE14, 0xF6F4, 0xAD0F, 0xAD53, 0xBDB1, 0xBD93, 0xBDB5, 0xC5D2, 0xC5B1, 0xB573, 0xACCF, 0xC5B4, 0xB530, 
        0xB594, 0x9D13, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA574, 0xAD74, 0xAD94, 0xAD94, 0xB5B4, 0xB5D5, 0xB5D5, 0xB5B5, 0xB5B4, 0xB5B4, 0xB5B4, 0xADB4, 0xAD94, 0xAD94, 0xAD74, 0xAD94, 0xB5B5, 0xB552, 0xDDD0, 0xC592, 0xB594, 0xB5B4, 0xBDD5, 
        0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5B5, 0xB5B5, 0xB5D5, 0xBDD5, 0xBDD5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xC5F5, 0xC615, 0xC615, 0xC615, 0xC5F5, 0xC615, 0xCE36, 0xC615, 0xBDD5, 0xB5D5, 0xB5B4, 0xB594, 0xAD94, 
        0xAD74, 0xA574, 0xA553, 0xA553, 0xA553, 0xA553, 0xA553, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0x9513, 0x9512, 0x94F2, 0x94D2, 0x8CD2, 0x8CD2, 0x8CB2, 0x8CB2, 0x8CB2, 0x84B2, 0x8492, 0x8492, 0x8492, 0x7C92, 0x7C72, 0x7C72, 0x7C72, 0x7C71, 0x7471, 
        0x7471, 0x7471, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x6C51, 0x7451, 0x7451, 0x6C51, 0x6C51, 0x6C51, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x7431,
  0xDE77, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE98, 0xDE98, 0xDE98, 0xDEB8, 0xDEB8, 0xDE97, 0xD697, 0xD677, 0xD677, 0xC616, 0xBDF5, 0xB5F5, 0xCE77, 
        0xCE57, 0xCE56, 0xCE57, 0xB5F5, 0x9D93, 0x7D11, 0x5C8E, 0x4C2D, 0x440D, 0x442D, 0x442D, 0x440C, 0x3C0C, 0x440C, 0x4C2D, 0x4C4D, 0x4C4D, 0x544D, 0x5C4D, 0x6CAF, 0x7CF0, 0x84CF, 0x9D31, 0x948F, 0x9D10, 0xB593, 0xAD52, 0x94D1, 0x8CF1, 0x84B1, 
        0x7C90, 0x6C0E, 0x6C0D, 0x8D12, 0x746F, 0x6C8F, 0x6C8F, 0x648F, 0x5C8F, 0x546E, 0x548F, 0x546E, 0x4C6E, 0x4C6D, 0x4C6D, 0x4C4D, 0x4C4D, 0x4C4D, 0x4C6E, 0x4C8E, 0x4C8E, 0x54AF, 0x54CF, 0x54AF, 0x548E, 0x54AF, 0x54CF, 0x54CF, 0x54AF, 0x54AF, 
        0x5CF0, 0x5CEF, 0x54CF, 0x54AF, 0x5CF0, 0x5CF0, 0x5CF0, 0x54F0, 0x54CF, 0x54EF, 0x4CAE, 0x444D, 0x4C6E, 0x8532, 0x8D32, 0x6CB0, 0x54CF, 0x5D10, 0x6510, 0x6510, 0x6510, 0x6511, 0x6510, 0x6530, 0x6530, 0x6530, 0x6530, 0x6531, 0x6530, 0x6530, 
        0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6551, 0x6530, 0x6530, 0x6D30, 0x6530, 0x6510, 0x6510, 0x6510, 0x64EF, 0x5CEF, 0x5CCF, 0x546E, 0x4C0C, 0x5BEC, 0x4B4A, 0x7BEB, 0xA46D, 0xAC8D, 0xB48C, 0xC50D, 0xCD4E, 0xDD6E, 0xDD8E, 0xDDAF, 0xDD8E, 
        0xDD8E, 0xDD8E, 0xDD6D, 0xDD6D, 0xD5B0, 0xD56E, 0xE5D0, 0xCDD2, 0xCD92, 0xDD8F, 0xDD6E, 0xDD4E, 0xE56E, 0xA48C, 0x9511, 0xD5D2, 0xE58F, 0xE58F, 0xD54F, 0xC571, 0xD56F, 0xD54F, 0xCD2F, 0xBD0F, 0x940C, 0xA46D, 0xA46D, 0xA46D, 0xA48E, 0xA4AF, 
        0x9CAF, 0x9CB0, 0x948F, 0x8C8F, 0x844E, 0x7C4E, 0x740E, 0x6C0D, 0x6BEE, 0x6C0E, 0x744F, 0x7C70, 0x7C91, 0x84D2, 0x9533, 0xA595, 0xADD6, 0xB5F6, 0xB616, 0xBE57, 0xCEB9, 0xB616, 0xADD5, 0xA594, 0xA574, 0x9D32, 0x94D0, 0x7BED, 0x73CC, 0x844E, 
        0xD6BA, 0xADB6, 0x9D54, 0x9D54, 0xA554, 0x9D54, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0xA574, 0xAD95, 0xB5B5, 0xB5D5, 0xBDD5, 0xC5F6, 0xC616, 0xC616, 0xC616, 0xC616, 0xC5F6, 0xC616, 0xC616, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xC5F6, 0xBDF5, 
        0xBDF5, 0xBDF6, 0xB5D5, 0xB5B5, 0xADB5, 0xAD95, 0xA574, 0xA574, 0xB5B4, 0xCE14, 0xBDB4, 0xB5B5, 0xB5D5, 0xBDD5, 0xBDF5, 0xC5F6, 0xC5F6, 0xBDF5, 0xC616, 0xC616, 0xC616, 0xC616, 0xC5F5, 0xC615, 0xC616, 0xC5F5, 0xC5F5, 0xC5F6, 0xC616, 0xC616, 
        0xC616, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xC636, 0xCE36, 0xCE36, 0xCE36, 0xC636, 0xC616, 0xC636, 0xC636, 0xC636, 0xCE36, 0xC616, 0xBDF5, 0xB5D5, 0xB5B5, 
        0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5D5, 0xBDD5, 0xBDD5, 0xBDF5, 0xB571, 0xDE0F, 0xFF75, 0xDE54, 0xC5F5, 0xC615, 0xC5F5, 0xBDD5, 
        0xBDD5, 0xBDF5, 0xBDF5, 0xBDF5, 0xB5D5, 0xB594, 0xAD94, 0xAD94, 0xAD94, 0xAD94, 0xAD74, 0xAD74, 0xAD73, 0xAD52, 0xCE15, 0xCE13, 0xBD92, 0xCE14, 0xCDD3, 0xC5F4, 0xBE16, 0xBDB5, 0xC5F6, 0xBE16, 0xBDD5, 0xB5B4, 0xB5B4, 0x9CF1, 0xAD73, 0x9CF1, 
        0xAD74, 0xA533, 0xA574, 0xA554, 0xA554, 0xA554, 0xA554, 0xA574, 0xAD74, 0xAD94, 0xB594, 0xB5B5, 0xB5D5, 0xB5D5, 0xB5B5, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB594, 0xAD94, 0xB594, 0xB5B5, 0xAD73, 0xCDD2, 0xBDB3, 0xB5B4, 0xB5B5, 0xBDD5, 
        0xBDD5, 0xBDD5, 0xB5B5, 0xB5B4, 0xB5B5, 0xB5D5, 0xB5D5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDF5, 0xBDF5, 0xC5F5, 0xC5F5, 0xBDF5, 0xBDF5, 0xBDF5, 0xC5F5, 0xC615, 0xC615, 0xC615, 0xC615, 0xCE16, 0xCE36, 0xC615, 0xBDF5, 0xBDD5, 0xB5B5, 0xB594, 0xB594, 
        0xB594, 0xAD74, 0xA553, 0xA553, 0xA553, 0x9D53, 0x9D53, 0x9D33, 0x9D33, 0x9D33, 0x9D13, 0x9513, 0x9512, 0x94F2, 0x94F2, 0x94F2, 0x8CD2, 0x8CB2, 0x8CD2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x8492, 0x7C72, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7471, 
        0x7471, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7431, 0x7451, 0x6C51, 0x6C51, 0x6C51, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31,
  0xD677, 0xD677, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xD697, 0xD677, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE98, 0xDE98, 0xDE98, 0xDE98, 0xDEB8, 0xDE98, 0xDE97, 0xDE97, 0xD697, 0xDE98, 0xCE57, 0xBDF5, 0xB5F4, 0xADB4, 
        0x9552, 0x7CF0, 0x544D, 0x442D, 0x3C0C, 0x3BCB, 0x3BCB, 0x440C, 0x4C2C, 0x4C0C, 0x544D, 0x648E, 0x84F0, 0x8D11, 0x9531, 0x9D51, 0xA551, 0xAD92, 0xAD52, 0xA4AE, 0xC54F, 0xCD4F, 0xCD4F, 0xC550, 0xBD0E, 0xD655, 0xD656, 0xBE15, 0xBE16, 0xB5D5, 
        0xA532, 0x8369, 0x8389, 0xAD31, 0x93EB, 0x940B, 0x940C, 0x8C0C, 0x8C2D, 0x7C0D, 0x7C8F, 0x7CB0, 0x7CB0, 0x74B0, 0x6C8F, 0x6CD0, 0x6CD0, 0x64B0, 0x5CAF, 0x548F, 0x548F, 0x54AF, 0x4C8E, 0x4C8E, 0x446D, 0x4C6E, 0x4C8E, 0x4C8E, 0x54AF, 0x4C8E, 
        0x54CF, 0x54CF, 0x5CCF, 0x548E, 0x548E, 0x5CF0, 0x54CF, 0x54AF, 0x54CF, 0x5CF0, 0x5CF0, 0x4C8E, 0x4C4D, 0x74D0, 0x7D11, 0x74D0, 0x442D, 0x54CF, 0x5CF0, 0x5CF0, 0x5CEF, 0x54CF, 0x5D10, 0x5D10, 0x6510, 0x5CEF, 0x5D10, 0x5D10, 0x5D10, 0x5D10, 
        0x5CEF, 0x5CF0, 0x5D10, 0x6510, 0x5CEF, 0x5CAF, 0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6530, 0x6510, 0x6510, 0x6510, 0x6510, 0x64F0, 0x5CCF, 0x4C6E, 0x3BAB, 0x43AA, 0x742C, 0xACCD, 0xDD6E, 0xE58E, 0xE58E, 0xDD8E, 0xDD6E, 0xE58E, 0xDD8E, 
        0xE58E, 0xDD8E, 0xDD6D, 0xDD6D, 0xDDD0, 0xD56F, 0xD634, 0xDE97, 0xD656, 0xCDB2, 0xD54E, 0xE56E, 0xD54E, 0x94CE, 0xC678, 0xCE14, 0xDD8F, 0xE5D0, 0xD590, 0xB530, 0xE58F, 0xE5AF, 0xEDAF, 0xBCED, 0x9D11, 0xDDF3, 0xDD8F, 0xDD8F, 0xDD6F, 0xC530, 
        0xCD50, 0xCD0E, 0xC4ED, 0xC4EE, 0xACAE, 0xA44D, 0xAC8E, 0xA48E, 0xA4AF, 0x9C8F, 0x946F, 0x8C8F, 0x846F, 0x7C4F, 0x7C4F, 0x7C4F, 0x7C6F, 0x742E, 0x6C0E, 0x744F, 0x7C70, 0x84B1, 0x8CF2, 0x9553, 0xA574, 0xA595, 0xADB5, 0xB5F6, 0xBDF6, 0xBE16, 
        0xD6BA, 0xB5D6, 0xA575, 0xA575, 0xA574, 0xA574, 0xA575, 0xA554, 0xA574, 0xA574, 0xA574, 0xA575, 0xADB5, 0xB5D6, 0xBDF6, 0xBDF5, 0xBDF6, 0xC616, 0xC616, 0xC616, 0xC616, 0xC5F6, 0xBDF6, 0xBDF5, 0xBDF5, 0xBDF5, 0xC5F6, 0xC5F6, 0xC5F6, 0xC5F6, 
        0xC616, 0xC616, 0xBDF5, 0xBDD5, 0xB5B5, 0xB5B5, 0xAD94, 0xAD95, 0xBDD5, 0xD635, 0xC5F5, 0xBDD5, 0xBDF5, 0xBDF5, 0xC616, 0xC615, 0xC616, 0xC616, 0xC616, 0xC615, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC5F5, 0xC615, 0xC616, 0xCE16, 
        0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xC636, 0xC5F5, 0xBDF5, 
        0xBDD5, 0xB5D5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5B5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5D5, 0xB593, 0xBD2F, 0xEE50, 0xFF14, 0xE672, 0xC5B3, 0xC616, 0xC615, 0xBDF5, 
        0xBDF5, 0xC616, 0xC616, 0xBE15, 0xB5D5, 0xB5B4, 0xB594, 0xB594, 0xB5B5, 0xB5B5, 0xB594, 0xB5B5, 0xB594, 0xC5F5, 0xDEB8, 0xE6B9, 0xE6F9, 0xE6F9, 0xE6FA, 0xE71A, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xDEFA, 0xD6B9, 0xCE98, 0xCE78, 
        0xC617, 0xAD94, 0xAD74, 0xA574, 0xA574, 0xA574, 0xA574, 0xA574, 0xAD74, 0xAD94, 0xAD94, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5D5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB594, 0xB594, 0xB5B4, 0xB594, 0xCDD2, 0xBDB4, 0xB5B4, 0xB5B5, 0xB5B5, 
        0xB5B5, 0xB5B5, 0xB5B4, 0xB594, 0xB5B5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDF5, 0xBDF5, 0xBDF5, 0xC615, 0xC5F5, 0xC5F5, 0xBDF5, 0xBDF5, 0xC5F5, 0xC615, 0xC615, 0xC616, 0xC616, 0xCE36, 0xCE36, 0xCE16, 0xC615, 0xC615, 0xC615, 0xBDD5, 0xB5B5, 0xB5D5, 
        0xB5B4, 0xAD74, 0xA574, 0xA553, 0xA553, 0x9D53, 0x9D53, 0x9D33, 0x9D33, 0x9D33, 0x9D13, 0x9513, 0x9513, 0x94F3, 0x94F2, 0x94F2, 0x8CD2, 0x8CB2, 0x8CD2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x8492, 0x8472, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7451, 
        0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31,
  0xD677, 0xD677, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE77, 0xD677, 0xD677, 0xD677, 0xD677, 0xD677, 0xD677, 0xD697, 0xDE97, 0xDE97, 0xDE98, 0xDE98, 0xDE98, 0xDE98, 0xDE98, 0xDEB8, 0xDEB8, 0xCE77, 0xBE16, 0x9D73, 0x6C8E, 0x542D, 0x4BEC, 
        0x43CB, 0x43EB, 0x4C2C, 0x4C2D, 0x5C4D, 0x6CAF, 0x7CD0, 0x8CF0, 0x9510, 0xA531, 0xAD72, 0x9CCF, 0xB50F, 0xCD70, 0xD56F, 0xD54E, 0xD52E, 0xD614, 0xCE35, 0xCD2E, 0xE56D, 0xE56D, 0xE54D, 0xDD8F, 0xCDD2, 0xDE97, 0xD697, 0xCE98, 0xD6D9, 0xD6B9, 
        0xC636, 0xB48C, 0xC550, 0xCD91, 0xC4AB, 0xCCCC, 0xCCCC, 0xC4AC, 0xBC6B, 0x9BEA, 0x9CCF, 0xAD94, 0x9CD0, 0x93EB, 0x9C0B, 0x9C2C, 0x942C, 0x8C2D, 0x8C4E, 0x8C6E, 0x7C2E, 0x744E, 0x7CD1, 0x74F1, 0x7511, 0x6CF1, 0x64AF, 0x5C8F, 0x546E, 0x546E, 
        0x548F, 0x54AF, 0x4C8E, 0x4C6D, 0x4C6E, 0x54AF, 0x54CF, 0x5CCF, 0x54CF, 0x5CF0, 0x5CF0, 0x5CEF, 0x54CF, 0x5CCF, 0x5CCF, 0x54AF, 0x4C8E, 0x54AF, 0x5CCF, 0x5CCF, 0x54CF, 0x5CD0, 0x5CF0, 0x5CF0, 0x5CF0, 0x54CF, 0x5CF0, 0x5CF0, 0x5D10, 0x5CEF, 
        0x54CF, 0x4C8E, 0x444D, 0x5CCF, 0x7D12, 0x7CF1, 0x5C8E, 0x5D10, 0x6510, 0x6510, 0x6530, 0x6510, 0x6510, 0x6510, 0x6510, 0x6510, 0x6510, 0x64F0, 0x5CEF, 0x5CCF, 0x4C6D, 0x43EB, 0x4BAA, 0x740B, 0xB4CC, 0xD54E, 0xE58E, 0xDD6E, 0xDD6E, 0xDD6E, 
        0xDD8E, 0xDD8E, 0xE58E, 0xAC4A, 0xACEE, 0xD56F, 0xDE34, 0xD697, 0xCE56, 0xD5B2, 0xDD4E, 0xE58E, 0xA4CD, 0xADB4, 0xCE57, 0xC636, 0xCD91, 0xC551, 0xD656, 0xCE56, 0xD5F3, 0xDD90, 0xE58E, 0x94AD, 0xBE16, 0xCE36, 0xDD8F, 0xE5AF, 0xDD90, 0xB4EF, 
        0xCD70, 0xEDAF, 0xE5AF, 0xE5AF, 0x9C8D, 0xBD92, 0xDD90, 0xDD8F, 0xDD6F, 0xCD2F, 0xBD30, 0xC50E, 0xBCEE, 0xB4AE, 0xAC8E, 0x944D, 0x9C6D, 0x9C8F, 0x9C8F, 0x9490, 0x948F, 0x8C6F, 0x846F, 0x844F, 0x8470, 0x8470, 0x7C90, 0x7C6F, 0x7C90, 0x84B1, 
        0x84B1, 0x84B1, 0x8CD2, 0x9D54, 0xA575, 0xA575, 0xA575, 0xA575, 0xA595, 0xA595, 0xAD95, 0xAD95, 0xADB5, 0xB5F5, 0xBDF6, 0xBDF6, 0xBDF6, 0xBE16, 0xC616, 0xC616, 0xC616, 0xC616, 0xC5F6, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDF6, 
        0xC616, 0xC5F6, 0xBDF6, 0xBDD5, 0xB5B5, 0xB5B5, 0xBDD5, 0xBDF5, 0xC615, 0xD635, 0xC5F5, 0xC5F5, 0xBDF6, 0xC5F6, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xCE36, 0xC636, 0xCE36, 0xCE36, 0xCE16, 0xCE16, 0xCE16, 0xCE16, 0xCE36, 
        0xCE36, 0xCE36, 0xCE36, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE56, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE56, 0xCE56, 0xCE56, 0xD656, 0xD656, 0xD656, 0xD656, 0xCE56, 0xCE36, 0xC616, 0xC5F5, 
        0xBDF5, 0xBDF5, 0xBDD5, 0xB5D5, 0xB5D5, 0xB5D5, 0xBDF5, 0xBDD5, 0xB5D5, 0xB5B5, 0xB5B5, 0xB5D5, 0xB5D5, 0xB5B5, 0xB5B5, 0xB5B5, 0xAD94, 0xB5B5, 0xB5B5, 0xB594, 0xAD52, 0xA48E, 0xBD0D, 0xE5EE, 0xE60F, 0xCD6E, 0xB50F, 0xBD72, 0xC5F4, 0xC615, 
        0xCE36, 0xCE36, 0xC616, 0xBDF5, 0xB5D5, 0xB5B5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 0xBDD5, 0xBDD5, 0xBDD5, 0xD677, 0xEF1A, 0xEF1A, 0xEF1A, 0xE6FA, 0xE6FA, 0xE6FA, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xDEFA, 0xDEFB, 0xE6FB, 
        0xD699, 0xAD94, 0xAD74, 0xAD94, 0xAD94, 0xAD94, 0xAD74, 0xAD94, 0xAD94, 0xAD94, 0xB5B4, 0xB5D5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5D5, 0xB5D5, 0xB5D5, 0xB5D5, 0xBDD5, 0xB5D5, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4, 0xCDD2, 0xBDB4, 0xB594, 0xB5B4, 0xB5B5, 
        0xB5B5, 0xB5D5, 0xB5D5, 0xB5D5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDF5, 0xC5F5, 0xC5F5, 0xC5F5, 0xC5F5, 0xC5F5, 0xC5F5, 0xBDF5, 0xC5F5, 0xC615, 0xC5F5, 0xC5F5, 0xC636, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xC616, 0xC615, 0xC615, 0xBDD5, 0xB5D5, 0xB5D5, 
        0xB5B5, 0xB594, 0xAD74, 0xA553, 0xA553, 0xA553, 0xA553, 0xA553, 0xA533, 0x9D33, 0x9D13, 0x9D13, 0x9513, 0x94F3, 0x94F2, 0x94D2, 0x8CD2, 0x8CB2, 0x8CD2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x8491, 0x7C91, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7471, 
        0x7471, 0x7C71, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31,
  0xD676, 0xD677, 0xDE77, 0xDE97, 0xDE97, 0xD677, 0xD677, 0xD677, 0xD677, 0xD677, 0xD677, 0xCE57, 0xCE57, 0xCE77, 0xCE77, 0xD677, 0xD677, 0xD677, 0xD697, 0xDE97, 0xDE98, 0xDE97, 0xCE77, 0xA572, 0x7C8F, 0x5C0C, 0x4BCB, 0x43CB, 0x4BEC, 0x6C8E, 0x8510, 
        0x9552, 0x9D52, 0x9510, 0x94F0, 0x8C6E, 0xACEF, 0xBD50, 0xC54F, 0xCD2E, 0xCD4F, 0xD655, 0xCDD3, 0xDD4D, 0xE56D, 0xE56D, 0xE56D, 0xE56E, 0xDE55, 0xD677, 0xD58F, 0xE58D, 0xE56D, 0xE56D, 0xDDAF, 0xD5F3, 0xDEB8, 0xDED9, 0xD6B9, 0xDEDA, 0xD6DA, 
        0xCE77, 0xBD0F, 0xD5F3, 0xC50E, 0xD50C, 0xD52D, 0xDD2D, 0xD52D, 0xD50D, 0xC4CD, 0xC5D3, 0xCE78, 0xC5F4, 0xC4CD, 0xCCEC, 0xCD0C, 0xCCEC, 0xCCCC, 0xCCCC, 0xBC8B, 0xAC2A, 0x8BEB, 0x9D11, 0x9D12, 0x840D, 0x8BCB, 0x8BEC, 0x8C2D, 0x846E, 0x844E, 
        0x7C4E, 0x746F, 0x6C8F, 0x74F0, 0x6CB0, 0x544E, 0x4C2D, 0x542D, 0x542D, 0x4C2D, 0x442D, 0x440D, 0x442D, 0x4C6E, 0x548E, 0x54AE, 0x54CF, 0x54CF, 0x5CCF, 0x54AF, 0x54AF, 0x54AF, 0x5CF0, 0x5CF0, 0x5CCF, 0x5CCF, 0x5CF0, 0x5CF0, 0x5CCF, 0x5CCF, 
        0x5CCF, 0x5CF0, 0x4C6E, 0x546E, 0x8D53, 0xA5D5, 0x648F, 0x4C8E, 0x54CF, 0x5CF0, 0x5D10, 0x6510, 0x5CEF, 0x6510, 0x6510, 0x5CF0, 0x6510, 0x64F0, 0x64F0, 0x5CEF, 0x5CCF, 0x5CAE, 0x546D, 0x440B, 0x4BAA, 0x6BEB, 0xACCC, 0xDD6E, 0xDD6E, 0xDD6E, 
        0xDD6D, 0xDD6E, 0xE58E, 0x7B27, 0x942C, 0xDD8F, 0xDDF2, 0xDED8, 0xD676, 0xCD50, 0xE58F, 0xCD2E, 0x94CF, 0xCE78, 0xC637, 0xC637, 0xCDD3, 0xCD91, 0xCE56, 0xD698, 0xD614, 0xE58F, 0xBD0D, 0x9D51, 0xCE98, 0xC637, 0xD5D2, 0xC52E, 0xC5B3, 0xCE36, 
        0xCDF4, 0xDDD2, 0xEDAF, 0xCD2D, 0x94EF, 0xCE77, 0xDD90, 0xE58E, 0xE5D0, 0xC50E, 0xACCF, 0xDD6F, 0xE58F, 0xE58F, 0xCD4F, 0x948E, 0xD570, 0xDD4F, 0xD52E, 0xC50E, 0xBD0F, 0xBCCE, 0xB4EF, 0xACAE, 0x9C4E, 0x8C0D, 0x944E, 0x948F, 0x8C4F, 0x842E, 
        0x8C90, 0x9533, 0x9D54, 0xA594, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xAD95, 0xADB5, 0xADB5, 0xB5B5, 0xB5D5, 0xB5D5, 0xBDF5, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDF5, 0xC5F6, 0xC5F6, 0xC5F6, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 
        0xBDF5, 0xBDF5, 0xBDF5, 0xB5D5, 0xB5B5, 0xBDD5, 0xBDF6, 0xBDF5, 0xC615, 0xD655, 0xC5F5, 0xC5F6, 0xBDF6, 0xBDF6, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xCE36, 0xCE36, 0xCE36, 0xCE16, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 
        0xCE36, 0xCE36, 0xD656, 0xD656, 0xD656, 0xD656, 0xCE56, 0xCE56, 0xD636, 0xCE36, 0xCE56, 0xCE56, 0xD656, 0xD656, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD657, 0xD657, 0xD656, 0xD656, 0xCE36, 0xC615, 
        0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDD5, 0xB5D5, 0xBDF5, 0xBDF5, 0xB5D5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB595, 0xAD94, 0xAD94, 0xB5B4, 0xAD31, 0xACCF, 0xBD2E, 0xDDD0, 0xEE51, 0xF6B2, 0xF6D2, 0xEE92, 0xE631, 0xD5D0, 0xCD90, 0xC592, 
        0xCE15, 0xCE36, 0xC616, 0xBDF5, 0xB5D5, 0xBDD5, 0xBDD5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xD677, 0xEEFA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE6FB, 0xDEDA, 0xDEFA, 0xDEFB, 
        0xD699, 0xAD94, 0xAD94, 0xB5B5, 0xB5D5, 0xB5B5, 0xB5B4, 0xAD94, 0xAD94, 0xB5B4, 0xB5D5, 0xBDF5, 0xBDD5, 0xB5D5, 0xB5D5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xB5D5, 0xB5B4, 0xB5B4, 0xB5B5, 0xBDB4, 0xDDF2, 0xBDB4, 0xB594, 0xB5B4, 0xB5B4, 
        0xB5B5, 0xB5D5, 0xB5D5, 0xBDF5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDF5, 0xC5F5, 0xC5F5, 0xC5F5, 0xC5F5, 0xC5F5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xC615, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE16, 0xC615, 0xC5F5, 0xBDF5, 0xBDD5, 0xB5D5, 
        0xB5D5, 0xB594, 0xAD74, 0xA553, 0xA553, 0xA553, 0xA553, 0xA553, 0xA533, 0x9D33, 0x9D13, 0x9D13, 0x94F3, 0x94F3, 0x94F2, 0x94D2, 0x8CD2, 0x8CB2, 0x8CB2, 0x8CB2, 0x84B2, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C91, 0x7C92, 0x7C71, 0x7C71, 0x7C71, 
        0x7C71, 0x7C71, 0x7471, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7471, 0x7471, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x6C51, 0x6C31, 0x6C51, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31,
  0xD677, 0xD677, 0xD677, 0xD677, 0xD677, 0xD677, 0xD677, 0xD677, 0xD677, 0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xCE57, 0xD677, 0xD677, 0xCE56, 0xC636, 0xC636, 0x94F1, 0x7C6E, 0x7CAF, 0x7CCF, 0x84F0, 0x8D10, 0x9531, 0x94CF, 0xBD72, 0xBD71, 
        0xBD50, 0xC52F, 0xBD50, 0xC5F4, 0xB50F, 0xD54D, 0xDD6D, 0xDD6D, 0xE56D, 0xDDAF, 0xDE97, 0xD614, 0xDD6E, 0xE58E, 0xE58E, 0xE58D, 0xE58E, 0xDE76, 0xDE97, 0xDDB0, 0xEDAE, 0xE5AE, 0xE56D, 0xD590, 0xC5B2, 0xCE35, 0xB5B4, 0xADB4, 0xB616, 0xBE37, 
        0xC616, 0xBD71, 0xCDB2, 0xD52D, 0xDD6E, 0xDD6E, 0xDD6E, 0xDD6E, 0xDD4D, 0xCD2D, 0xC5F4, 0xCE99, 0xCE15, 0xD52D, 0xD52D, 0xDD2D, 0xDD2D, 0xDD2D, 0xD52D, 0xD50D, 0xD4ED, 0xBCCE, 0xC615, 0xC657, 0xBD2F, 0xC48B, 0xC4CC, 0xC4CC, 0xBCAC, 0xB46C, 
        0xAC6C, 0xA44C, 0x8BEB, 0x94AF, 0x9D53, 0x8CB1, 0x6BEC, 0x8CF1, 0x8D11, 0x6C4E, 0x6C6F, 0x6C6F, 0x6C8F, 0x5C4E, 0x544E, 0x546E, 0x548F, 0x548F, 0x548F, 0x548E, 0x4C6E, 0x446D, 0x4C6E, 0x4C8E, 0x4C8E, 0x4C8E, 0x54AF, 0x54CF, 0x5CCF, 0x5CCF, 
        0x5CCF, 0x5CF0, 0x5CF0, 0x548E, 0x5CAF, 0x6CF0, 0x546E, 0x4C6E, 0x54AF, 0x5CEF, 0x5CF0, 0x5CF0, 0x5CCF, 0x6510, 0x6510, 0x5CF0, 0x5CCF, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CCF, 0x5CAE, 0x5CAE, 0x548D, 0x4C2C, 0x43EB, 0x4BCA, 0x844B, 0xBD0D, 0xDD6E, 
        0xDD8E, 0xDD6E, 0xDD6E, 0xBC8B, 0xC550, 0xD56E, 0xD54E, 0xD613, 0xCD71, 0xD52E, 0xC52D, 0xAD30, 0xBDF5, 0xCE57, 0xBDF6, 0xC637, 0xC616, 0xB593, 0xC636, 0xD678, 0xD614, 0xDD8F, 0x9CCD, 0xBE16, 0xCE78, 0xC657, 0xCDF4, 0xCD4E, 0xCE14, 0xCE77, 
        0xC636, 0xCD91, 0xEDAF, 0xACCD, 0xB5D4, 0xCE78, 0xD5F3, 0xDD6F, 0xD5B1, 0xCE14, 0xC5B3, 0xDDB1, 0xE5AF, 0xEDAF, 0xA48C, 0xA573, 0xDDF3, 0xE56E, 0xE58E, 0xD54E, 0xC551, 0xDD6F, 0xDD8F, 0xE590, 0xB4CD, 0x9CAE, 0xC50F, 0xC4EE, 0xB48D, 0xAC8E, 
        0xAC8E, 0xAD53, 0xB5D6, 0xADD5, 0xB5D6, 0xB5D5, 0xADD5, 0xADB5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5D5, 0xBDD5, 0xBDF5, 0xBDF5, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDF5, 0xC5F6, 0xC5F6, 0xC5F6, 0xBDF6, 0xBDF6, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF6, 
        0xBDF6, 0xBDF6, 0xBDF6, 0xBDD5, 0xB5D5, 0xBDF5, 0xC5F5, 0xC5F6, 0xC616, 0xDE55, 0xC615, 0xC5F6, 0xBDF6, 0xBDF6, 0xC5F6, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC615, 0xC616, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 
        0xCE36, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xCE56, 0xCE56, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD676, 0xD656, 0xD677, 0xD677, 0xD677, 0xD656, 0xCE56, 0xC616, 
        0xBDF5, 0xBDF5, 0xBDF5, 0xBDF6, 0xBDF5, 0xB5D5, 0xBDF5, 0xC616, 0xBDF5, 0xB5D5, 0xB5B5, 0xB5B5, 0xB5B5, 0xAD95, 0xAD94, 0xAD94, 0xAD74, 0xA4CF, 0xB4EE, 0xCD8F, 0xDDCE, 0xEE2F, 0xF6B2, 0xFF13, 0xFF54, 0xFF55, 0xFF34, 0xFF55, 0xF6F4, 0xE651, 
        0xC591, 0xCE15, 0xC616, 0xBDF5, 0xBDF5, 0xBDF5, 0xC5F5, 0xC615, 0xC615, 0xC5F5, 0xBDF5, 0xC5F5, 0xC5F5, 0xD677, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xDEFB, 0xDEDA, 0xDEFA, 0xDEFA, 
        0xCE78, 0xAD94, 0xB5B5, 0xBDD5, 0xBDF5, 0xB5D5, 0xB5D5, 0xB5B5, 0xB5B5, 0xB5B5, 0xBDD5, 0xBDF5, 0xBDF5, 0xB5D5, 0xBDF5, 0xBDF5, 0xBDF5, 0xC5F5, 0xBDF5, 0xBDD5, 0xB5B5, 0xB5B4, 0xB5B4, 0xB5B5, 0xBDD5, 0xCDB2, 0xBDD4, 0xB5B5, 0xB5B4, 0xB5B4, 
        0xB5B4, 0xB5B5, 0xBDD5, 0xBDF5, 0xBDD5, 0xBDD5, 0xBDF5, 0xBDF5, 0xC615, 0xC5F5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xB5D5, 0xBDD5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xCE16, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xC616, 0xC615, 0xBDF5, 0xBDF5, 0xBDF5, 
        0xB5D5, 0xB594, 0xAD74, 0xA573, 0xAD73, 0xA553, 0xA553, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0x9D13, 0x9513, 0x94F2, 0x94F2, 0x8CF2, 0x8CD2, 0x8CD2, 0x8CB2, 0x8CB2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x7C91, 0x7C91, 
        0x7C71, 0x7C72, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7471, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31, 0x6C31,
  0xCE77, 0xD677, 0xD677, 0xD677, 0xD677, 0xD677, 0xCE57, 0xCE57, 0xCE56, 0xCE56, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE56, 0xCE57, 0xCE57, 0xBDF5, 0xAD73, 0x9511, 0x94D0, 0x948F, 0x8C4D, 0xB550, 0xC570, 0xCD6F, 0xC591, 0xCE35, 0xBD0F, 0xDD4D, 0xDD6E, 
        0xE56D, 0xDD4D, 0xDDD1, 0xDE97, 0xD5B2, 0xDD6D, 0xE56D, 0xE58E, 0xE56D, 0xDDD0, 0xDEB7, 0xD635, 0xE58E, 0xEDAE, 0xEDAE, 0xE58E, 0xDD6E, 0xCE34, 0xC615, 0xBD2F, 0xBCEC, 0xA48C, 0xA4AD, 0xAD0F, 0x9CCF, 0x9CEF, 0x844E, 0x740D, 0x7C2E, 0x7C4F, 
        0x7C6F, 0x846F, 0x840C, 0x8C0B, 0x9C6C, 0xB4AD, 0xBCED, 0xC50D, 0xCD2D, 0xC50E, 0xBDF4, 0xCEB9, 0xD635, 0xDD6E, 0xDD6E, 0xE58E, 0xE58E, 0xE56E, 0xDD6E, 0xDD4E, 0xDD4D, 0xC52F, 0xCE56, 0xCE98, 0xD591, 0xD52D, 0xDD4D, 0xDD4D, 0xDD2D, 0xDD4D, 
        0xDD2D, 0xD52D, 0xC4CD, 0xC593, 0xCE57, 0xAD11, 0x8B68, 0xB510, 0xB4EF, 0xB48C, 0xB4AD, 0xAC8D, 0xA44D, 0x83EB, 0x846E, 0x8D12, 0x84D1, 0x848F, 0x7C6E, 0x744E, 0x748F, 0x6CB0, 0x74D1, 0x6CF1, 0x64D0, 0x5CAF, 0x5C8E, 0x5CAF, 0x54AF, 0x54AF, 
        0x4C8E, 0x4C6E, 0x4C8E, 0x54AF, 0x548E, 0x54AF, 0x5CCF, 0x5CCF, 0x5CCF, 0x5CF0, 0x5CF0, 0x5CCF, 0x5CCF, 0x5CEF, 0x5CF0, 0x5CEF, 0x5CCF, 0x64F0, 0x6510, 0x64EF, 0x5CCF, 0x5CCE, 0x5CCF, 0x5CCE, 0x5C8E, 0x544D, 0x544D, 0x4BEB, 0x53EB, 0x742B, 
        0xACCC, 0xD54E, 0xDD4E, 0xDD4D, 0xD5D1, 0xD56F, 0xDD6E, 0xCCEC, 0xCCED, 0xACCD, 0x9530, 0xC636, 0xCE57, 0xC616, 0xBDB4, 0xC636, 0xC616, 0xBDF6, 0xBDD4, 0xD614, 0xB52F, 0xB571, 0xBE15, 0xCE78, 0xC636, 0xC657, 0xC636, 0xC5B2, 0xC5D4, 0xC636, 
        0xCE36, 0xDDB1, 0xC50D, 0x9D10, 0xCE78, 0xC657, 0xCE56, 0xD5B0, 0xCD70, 0xD677, 0xD677, 0xCDF4, 0xDD8F, 0xC52D, 0x848E, 0xCE78, 0xCE15, 0xDD8F, 0xDDB1, 0xD5D2, 0xBD72, 0xDDB0, 0xE5B0, 0xDD8E, 0x8C8C, 0xBE16, 0xD5B1, 0xDD2D, 0xDD4E, 0xDD6E, 
        0xCD2E, 0xBD93, 0xB552, 0xB573, 0xB573, 0xB594, 0xB594, 0xB5B5, 0xB5D5, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDF6, 0xBE16, 0xC616, 0xC616, 0xBE16, 0xBE16, 0xBDF6, 0xBDF6, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF6, 
        0xBDF6, 0xBDF6, 0xBDF6, 0xBDF5, 0xBDF5, 0xBDF5, 0xC5F5, 0xBDF6, 0xC615, 0xD655, 0xC615, 0xC5F6, 0xBDF5, 0xBDF5, 0xC5F6, 0xC616, 0xC616, 0xC615, 0xC615, 0xC615, 0xC616, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 
        0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD676, 0xD676, 0xD676, 0xD677, 0xDE77, 0xDE77, 0xDE77, 0xDE77, 0xD677, 0xD656, 0xC616, 
        0xC616, 0xBE16, 0xBDF5, 0xBDF5, 0xBDD5, 0xBDD5, 0xBDF5, 0xC616, 0xBE16, 0xBDD5, 0xB5D5, 0xB5B5, 0xB5B5, 0xADB5, 0xAD94, 0xB5B5, 0x948F, 0xA48C, 0xCD6E, 0xDDAD, 0xE5EE, 0xEE4F, 0xF6B2, 0xFF13, 0xFF54, 0xFF75, 0xF6B1, 0xEE91, 0xFF96, 0xFF33, 
        0xE651, 0xBD72, 0xC616, 0xC615, 0xC615, 0xC616, 0xCE36, 0xCE36, 0xCE36, 0xC615, 0xC615, 0xC615, 0xC615, 0xD677, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE71B, 0xE6FB, 0xE71B, 0xE6FB, 0xE71B, 0xE71B, 0xDEFB, 0xDEDA, 0xDEDA, 0xDEFA, 
        0xCE78, 0xB5B4, 0xBDD5, 0xC615, 0xC5F5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBE15, 0xC615, 0xC5F5, 0xBDF5, 0xBDD5, 0xBDD5, 0xBDD5, 0xB5B5, 0xB5B5, 0xC5B2, 0xD5B0, 0xCDF3, 0xBDD5, 0xB5B5, 0xB5B4, 
        0xB5B4, 0xB5B5, 0xB5D5, 0xBDD5, 0xBDF5, 0xBDF5, 0xBDF5, 0xC5F5, 0xC5F5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDD5, 0xB5D5, 0xB5B4, 0xBDD5, 0xC615, 0xC615, 0xC615, 0xBDF5, 0xC615, 0xC615, 0xC5F5, 0xC615, 0xC616, 0xCE36, 0xC615, 0xC5F5, 0xC5F5, 0xC5F5, 
        0xB5D5, 0xAD94, 0xAD74, 0xAD73, 0xAD73, 0xA574, 0xA553, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0x9513, 0x9512, 0x94F2, 0x94F2, 0x8CF2, 0x8CD2, 0x8CD2, 0x8CB2, 0x8CB2, 0x8CB2, 0x8CB2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x8492, 
        0x8492, 0x8491, 0x8491, 0x7C92, 0x7C92, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x6C51, 0x6C51, 0x7431, 0x7451, 0x7451, 0x6C51, 0x6C31, 0x6C51, 0x7451, 0x7451, 0x7451, 0x6C31, 0x6C51,
  0xCE57, 0xCE77, 0xCE57, 0xCE56, 0xCE57, 0xCE57, 0xCE57, 0xCE36, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xCE36, 0xCE57, 0xCE57, 0xCE57, 0xC615, 0xB5B3, 0xBDB3, 0xB572, 0xBD2F, 0xCCEC, 0xDD6E, 0xE56E, 0xE54D, 0xDDD1, 0xD677, 0xD5B1, 0xE56D, 0xE58D, 
        0xE58D, 0xDD6D, 0xDDF1, 0xDEB7, 0xD5D2, 0xE56D, 0xE58E, 0xE58E, 0xE58E, 0xDDF1, 0xD697, 0xC5D3, 0xBCED, 0xB4AB, 0xAC8B, 0xB4CD, 0xACCE, 0xA510, 0x946E, 0x9CEF, 0xB571, 0xB551, 0xAD31, 0xAD31, 0xB572, 0xB572, 0x9CAF, 0x8C6F, 0x94B1, 0x94D1, 
        0x94B1, 0x846F, 0x7C0E, 0x7C0E, 0x844F, 0x846F, 0x846F, 0x846E, 0x7C0C, 0x7BCB, 0x844E, 0x8490, 0x846F, 0x944C, 0xA48C, 0xA48C, 0xB4CD, 0xC50D, 0xCD2E, 0xD54E, 0xDD6E, 0xCD50, 0xCE77, 0xD6B9, 0xDDF2, 0xDD6E, 0xDD6E, 0xDD6E, 0xDD6E, 0xDD6E, 
        0xDD6E, 0xDD6E, 0xD54E, 0xCDF4, 0xD699, 0xC5B3, 0xBCAC, 0xCDB3, 0xCD2E, 0xDD2D, 0xDD2D, 0xD52D, 0xD50D, 0xC4AC, 0xB4EF, 0xBE16, 0xB573, 0xAC4B, 0xB46B, 0xB48C, 0xB48D, 0xA46D, 0x9C4C, 0x942D, 0x83CC, 0x846F, 0x8CF1, 0x84B0, 0x7CB0, 0x7C90, 
        0x74B0, 0x74B0, 0x6CB0, 0x64B0, 0x64AF, 0x5C8F, 0x4C4D, 0x4C4D, 0x4C4D, 0x4C6E, 0x4C4D, 0x548E, 0x548E, 0x5CAF, 0x5CCF, 0x5CCF, 0x5CCF, 0x64F0, 0x6510, 0x64EF, 0x5CEF, 0x5CCF, 0x64EF, 0x64CF, 0x5CAE, 0x5C8E, 0x64AE, 0x5C8D, 0x4C4C, 0x43EB, 
        0x4BCB, 0x742B, 0xA48C, 0xBCCD, 0xC52E, 0xCD2D, 0xDD6E, 0xD52D, 0xC4CD, 0x8CCE, 0xC657, 0xC637, 0xBD73, 0xB531, 0xCE15, 0xBDB4, 0xBDF5, 0xC636, 0xC636, 0xAD10, 0xA572, 0xCE78, 0xC637, 0xCE36, 0xBDF5, 0xC636, 0xC636, 0xBE16, 0xB593, 0xBDD4, 
        0xCDB2, 0xB50F, 0xB593, 0xBE36, 0xC657, 0xC637, 0xC637, 0xCDF4, 0xC571, 0xD677, 0xD6B9, 0xD634, 0xDD8F, 0x948C, 0xB5F5, 0xCE78, 0xC636, 0xD5B1, 0xC52F, 0xCE36, 0xD677, 0xCE15, 0xDD90, 0xB4ED, 0x9D52, 0xCE78, 0xCDF4, 0xD54E, 0xDD4E, 0xD5B1, 
        0xD5D2, 0xB4EF, 0xB4AE, 0xB4CF, 0xB4CF, 0xACAF, 0xACCF, 0xACD0, 0xACD0, 0xA4D0, 0xACF1, 0xA4F1, 0xAD32, 0xB553, 0xB573, 0xB594, 0xBDB5, 0xBDD5, 0xC5F6, 0xC616, 0xC636, 0xC636, 0xC616, 0xBDF6, 0xBDF6, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 
        0xBDF5, 0xBDF6, 0xBDF6, 0xBDF6, 0xBDF6, 0xC5F6, 0xC5F6, 0xC5F6, 0xC615, 0xD613, 0xC615, 0xBE15, 0xC615, 0xC615, 0xC5F5, 0xC615, 0xC615, 0xC5F5, 0xC615, 0xC616, 0xC616, 0xC636, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xD656, 
        0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD676, 0xD676, 0xD676, 0xDE76, 0xDE77, 0xDE77, 0xDE77, 0xDE77, 0xDE77, 0xD677, 0xCE36, 0xCE36, 
        0xCE36, 0xC616, 0xBDF5, 0xBDF5, 0xBDD5, 0xBDF5, 0xC5F5, 0xC615, 0xBE16, 0xBDD5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5B5, 0xAD73, 0x83CA, 0xB4CB, 0xDDCD, 0xEED2, 0xF754, 0xFF96, 0xFF97, 0xFFB8, 0xFF97, 0xFF97, 0xEEB2, 0xBCA8, 0xEEB1, 0xFF34, 
        0xEE91, 0xACCD, 0xC5F5, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xC616, 0xC615, 0xC615, 0xC615, 0xD656, 0xE6FA, 0xE6D9, 0xE6D8, 0xE6D8, 0xE6D9, 0xE6FA, 0xE6FB, 0xDEDA, 0xDED9, 0xDEDA, 0xDEDA, 0xE6FA, 0xDEFA, 0xCE99, 0xC657, 0xCE99, 
        0xCE78, 0xB5D5, 0xBDF5, 0xC615, 0xC616, 0xC615, 0xC615, 0xC5F5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xC5F5, 0xBDF5, 0xBDD5, 0xBDF5, 0xBDF5, 0xBDD5, 0xB5B5, 0xBDD5, 0xBD6F, 0xACA9, 0xBD50, 0xBDF5, 0xB5B4, 0xB5B4, 
        0xB5B4, 0xB5B5, 0xB5D5, 0xBDD5, 0xBDF5, 0xBDF5, 0xBDF5, 0xC5F5, 0xC5F5, 0xC615, 0xBDF5, 0xBDF5, 0xB5D5, 0xB5D4, 0xBDD5, 0xC5F5, 0xC616, 0xCE36, 0xC636, 0xC615, 0xBDF5, 0xBDD4, 0xBDD5, 0xC5F5, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xBDF5, 
        0xB5D5, 0xAD94, 0xAD74, 0xAD73, 0xAD73, 0xAD74, 0xA553, 0xA553, 0x9D53, 0x9D33, 0x9D33, 0x9D13, 0x9513, 0x9513, 0x94F2, 0x94F2, 0x94F2, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CD2, 
        0x8CB2, 0x84B2, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C71, 0x7C91, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x6C51, 0x7451, 0x7451, 0x7451, 0x6C51, 0x7451,
  0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE57, 0xCE57, 0xCE36, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xCE57, 0xCE56, 0xCE56, 0xCE57, 0xD677, 0xCE56, 0xCE35, 0xCD91, 0xD52C, 0xE58E, 0xE58E, 0xE56D, 0xDDF1, 0xD697, 0xD5B1, 0xE56D, 0xE5AE, 
        0xE5AE, 0xE58E, 0xE612, 0xDEB8, 0xCDB2, 0xCD0D, 0xCD0D, 0xC4ED, 0xB4CC, 0xA4AD, 0x948F, 0x7BEC, 0x8C4C, 0x9CCE, 0xAD30, 0xB572, 0xBDB3, 0xC5D3, 0xAD31, 0xB572, 0xAD51, 0xA510, 0xAD30, 0xAD30, 0xB551, 0xBDB3, 0xB552, 0x9CF1, 0x9CF2, 0x9CD1, 
        0x8C4F, 0x842F, 0x844F, 0x842E, 0x844F, 0x8CB0, 0x94F2, 0x9D12, 0x94F1, 0x8C8F, 0x94F1, 0x8CB1, 0x8C90, 0x8490, 0x844F, 0x6BAC, 0x73CC, 0x73CC, 0x7BEC, 0x840C, 0x840B, 0x842C, 0x94F1, 0x9D53, 0xAD0F, 0xC50D, 0xCD2D, 0xD54D, 0xDD6E, 0xDD8E, 
        0xDD8E, 0xE58E, 0xDD8F, 0xD635, 0xD6DA, 0xCDF4, 0xCD50, 0xD5D2, 0xD52D, 0xDD4D, 0xDD4D, 0xDD6D, 0xDD4D, 0xD50D, 0xC592, 0xCE98, 0xCE35, 0xD52E, 0xD52D, 0xDD2D, 0xDD2D, 0xD52D, 0xD50D, 0xCCED, 0xB44B, 0xA4AF, 0xBDD5, 0xA511, 0x9BEB, 0xAC4C, 
        0xA46D, 0x9C4C, 0x940C, 0x8C0D, 0x8C6E, 0x848F, 0x7C8F, 0x746F, 0x6C90, 0x5C2E, 0x6C6E, 0x6C8F, 0x5C4E, 0x542D, 0x4C2D, 0x544D, 0x546D, 0x4C6D, 0x4C6D, 0x548E, 0x548E, 0x548E, 0x5CAE, 0x5CAE, 0x5CAE, 0x5C8E, 0x64CE, 0x64AE, 0x5CAE, 0x5C8D, 
        0x544D, 0x4BEB, 0x4B89, 0x6BCA, 0x9C2B, 0xC4CC, 0xDD6E, 0xDD2D, 0x9C6B, 0x9572, 0xCE57, 0xC616, 0xBD0F, 0xA42C, 0xB531, 0xACCF, 0xB593, 0xC616, 0xCE57, 0xAD93, 0xBE36, 0xCE57, 0xBDD5, 0xC593, 0xCE15, 0xBDD5, 0xB5B4, 0xC636, 0xC637, 0xBDB3, 
        0xA4CD, 0xBDF5, 0xC657, 0xCE57, 0xC637, 0xC616, 0xC657, 0xBDF6, 0xBDB3, 0xBDB3, 0xDE97, 0xCD71, 0xB50E, 0xAD93, 0xCE98, 0xC637, 0xC657, 0xCE15, 0xCD90, 0xCE56, 0xD698, 0xD635, 0xDD8F, 0x948C, 0xBE36, 0xCE57, 0xC636, 0xD570, 0xD52D, 0xB4CE, 
        0xCE15, 0xCE16, 0xC5D5, 0xC5B4, 0xC593, 0xC593, 0xBD52, 0xBD51, 0xB531, 0xACD0, 0xA4AF, 0xA48E, 0xA48E, 0xA48E, 0xA46E, 0xA46E, 0xA48F, 0xA48F, 0x9C8F, 0xA4D0, 0xB552, 0xC5B4, 0xC5F5, 0xC5F5, 0xBDF5, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 
        0xC616, 0xC616, 0xC616, 0xBDF6, 0xBDF6, 0xBDF6, 0xC5F6, 0xBDF6, 0xC5F4, 0xD5F2, 0xC5F5, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xBDF5, 0xBDF5, 0xC5F5, 0xC615, 0xC616, 0xC616, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE56, 0xD656, 0xD656, 
        0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD676, 0xD676, 0xD656, 0xD676, 0xD676, 0xD676, 0xD677, 0xD677, 0xDE77, 0xDE76, 0xDE77, 0xDE97, 0xDE97, 0xDE97, 0xDE77, 0xD677, 0xD656, 0xCE36, 
        0xCE36, 0xC616, 0xC615, 0xC615, 0xBDF5, 0xBDF5, 0xBDF5, 0xC5F5, 0xBDF5, 0xB5D5, 0xB5D5, 0xB5B5, 0xB5B5, 0xB5B5, 0xBDD5, 0xB572, 0xAC6A, 0xEE6F, 0xFFD6, 0xFFD9, 0xFFD6, 0xFF75, 0xF714, 0xF714, 0xFF56, 0xF736, 0xEEB2, 0xC4A8, 0xE670, 0xFF94, 
        0xE5ED, 0xA46B, 0xC5D4, 0xCE56, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xC616, 0xC615, 0xC615, 0xC615, 0xD676, 0xE6FA, 0xE6F9, 0xE6D9, 0xE71A, 0xE71A, 0xE6FA, 0xE71B, 0xE71B, 0xE6FB, 0xDEDA, 0xE71B, 0xE71B, 0xE6FB, 0xDEDA, 0xD6DA, 0xD6B9, 
        0xD6B9, 0xBE15, 0xC615, 0xC616, 0xC636, 0xC616, 0xC615, 0xC615, 0xC5F5, 0xBDD5, 0xBDD5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDD5, 0xBDF5, 0xBDF5, 0xBDD5, 0xB5D5, 0xBDD5, 0xC5B2, 0xDE10, 0xC5D4, 0xBDD5, 0xB5B4, 0xB5B4, 
        0xBDD5, 0xBDD5, 0xBDD5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xC5F5, 0xC615, 0xC615, 0xBDF5, 0xBDF5, 0xBDD5, 0xBDD5, 0xC615, 0xC616, 0xCE36, 0xCE36, 0xCE36, 0xC615, 0xBDF5, 0xBDD5, 0xBDF5, 0xC5F5, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xBDF5, 
        0xB5D4, 0xAD94, 0xAD74, 0xAD74, 0xAD74, 0xAD74, 0xA553, 0xA553, 0xA553, 0xA553, 0xA553, 0xA533, 0x9D33, 0x9D33, 0x9D13, 0x9513, 0x94F2, 0x94F2, 0x94D2, 0x94F2, 0x94F2, 0x94F2, 0x94F2, 0x94F2, 0x94F2, 0x94F2, 0x94F2, 0x8CF2, 0x94F2, 0x94F2, 
        0x8CD2, 0x8CD2, 0x8CB2, 0x8CB2, 0x8492, 0x8492, 0x8492, 0x8492, 0x7C91, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7451, 0x7451, 0x7451, 0x7471, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451, 0x7451,
  0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xC636, 0xC636, 0xC636, 0xCE36, 0xC636, 0xC636, 0xC636, 0xC636, 0xCE36, 0xCE57, 0xCE57, 0xCE57, 0xD677, 0xD677, 0xCE56, 0xD5B1, 0xDD4D, 0xE5AE, 0xE5AE, 0xE5AE, 0xDE12, 0xD697, 0xCD91, 0xD52D, 0xCD2D, 
        0xC4ED, 0xB48C, 0xACCE, 0x94CF, 0x8C6D, 0x9CAE, 0x9CAE, 0xA50F, 0xB571, 0xB572, 0xAD31, 0xA4CF, 0xB592, 0xBDB3, 0xB572, 0xAD51, 0xB551, 0xB572, 0xAD31, 0xAD51, 0xC5F3, 0xC614, 0xCE15, 0xC614, 0xC5D4, 0xDE97, 0xD697, 0xCE57, 0xC657, 0xC636, 
        0xAD73, 0xA553, 0xAD94, 0xAD94, 0xAD73, 0xA553, 0x9D12, 0x94F1, 0x94D1, 0x8C6F, 0x94B0, 0x94B1, 0x8C90, 0x8C6F, 0x8C70, 0x94D1, 0x94F1, 0x94D1, 0x94D1, 0x8CB0, 0x7C4E, 0x846F, 0x8CB0, 0x848F, 0x846F, 0x844E, 0x7C0D, 0x7C0C, 0x8C4D, 0x8C4D, 
        0x944D, 0x9C4C, 0x9C4C, 0x9CF0, 0xADD5, 0xAD72, 0xBDB3, 0xC54F, 0xD54D, 0xDD6E, 0xE58E, 0xE58E, 0xE58E, 0xDD6E, 0xCDD3, 0xD6B9, 0xD656, 0xDD6E, 0xDD6E, 0xDD6E, 0xDD8E, 0xDD6E, 0xDD4E, 0xDD4D, 0xD50D, 0xC572, 0xCE98, 0xCE15, 0xD50D, 0xD50D, 
        0xD52D, 0xD52D, 0xD50D, 0xD50D, 0xC4AC, 0xA42B, 0xB572, 0xB5D5, 0x948F, 0x7B69, 0xB552, 0x9C8F, 0x946E, 0x94AF, 0x8C8F, 0x7C4E, 0x744E, 0x74D0, 0x7CF1, 0x7511, 0x6CB0, 0x64AF, 0x648E, 0x5C8E, 0x546E, 0x546E, 0x5C8E, 0x5C6E, 0x546D, 0x544D, 
        0x5C8D, 0x5C8D, 0x542D, 0x4BEB, 0x538A, 0x73CA, 0xB4CD, 0xCCED, 0x846C, 0xA5B4, 0xC616, 0xC5D5, 0xD5B2, 0xBCEE, 0xB4CE, 0xCDD3, 0xBD93, 0xBDF5, 0xC636, 0xC657, 0xCE57, 0xBDB4, 0xC550, 0xB46C, 0xBD51, 0xC530, 0xB552, 0xBDF5, 0xC637, 0xBDF5, 
        0xA573, 0xCE78, 0xC636, 0xC5D5, 0xCDD4, 0xC5F5, 0xBDD5, 0xBE16, 0xBE16, 0xBDB3, 0xBD50, 0xA4EF, 0xBE16, 0xC657, 0xCE58, 0xC616, 0xC657, 0xC616, 0xB5B4, 0xB5B4, 0xD698, 0xC5B2, 0xACCE, 0xA551, 0xCE78, 0xBE16, 0xC636, 0xCDD3, 0xD54D, 0xCD4F, 
        0xCE56, 0x9D94, 0x8552, 0x9594, 0x9DB4, 0xA5D5, 0xAE15, 0xB616, 0xBE16, 0xBDF5, 0xBDF5, 0xBDD5, 0xBDB4, 0xBD94, 0xB552, 0xB532, 0xB511, 0xACD0, 0xACD0, 0xA48E, 0xA46E, 0xAC8E, 0xAC8E, 0xACCF, 0xACCF, 0xA4AF, 0xACF0, 0xB532, 0xB553, 0xB573, 
        0xB594, 0xB5B4, 0xBDB5, 0xBDD5, 0xBE16, 0xC616, 0xC616, 0xC616, 0xCE15, 0xD5F1, 0xC5F4, 0xBE16, 0xC615, 0xC615, 0xC615, 0xBDF5, 0xBDF5, 0xBDD5, 0xC5F5, 0xC616, 0xC616, 0xC616, 0xC616, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xD656, 0xD656, 0xD656, 
        0xD656, 0xD656, 0xD676, 0xD656, 0xD656, 0xD656, 0xD676, 0xD676, 0xD656, 0xD656, 0xD656, 0xD656, 0xD676, 0xD656, 0xD676, 0xD677, 0xD677, 0xD677, 0xDE77, 0xDE77, 0xDE77, 0xDE77, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE77, 0xDE77, 0xD676, 0xD656, 
        0xD636, 0xCE36, 0xC636, 0xC616, 0xC616, 0xC615, 0xBDF5, 0xBDF5, 0xBDD5, 0xB5D5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5D5, 0xB5D5, 0xC5D3, 0xB48A, 0xBD4C, 0xCD8C, 0xC4A8, 0xB467, 0xAC27, 0xA407, 0x93A6, 0x93C7, 0x8BA7, 0xA408, 0xB448, 0x9C08, 0xB4AA, 
        0xA408, 0xC54E, 0xD675, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xC616, 0xC615, 0xC615, 0xC615, 0xDE97, 0xE71A, 0xEF1B, 0xAD73, 0x6B4B, 0xDED9, 0xE71A, 0xE71B, 0xE73B, 0x8450, 0x52CA, 0xDEBA, 0xE73B, 0xE71B, 0xC637, 0x9D13, 0xE71B, 
        0xDEB9, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE16, 0xC615, 0xC615, 0xBDF5, 0xBDF5, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xBDF5, 0xBDF5, 0xBDD5, 0xBDD5, 0xB5B4, 0xB5D5, 0xBDD5, 0xC591, 0xF6B0, 0xCE14, 0xBDF5, 0xB5D5, 0xB5B4, 
        0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xC5F5, 0xC5F5, 0xC615, 0xC615, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xC5F5, 0xC615, 0xC615, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xC615, 0xBDF5, 0xBDF5, 0xBDF5, 0xC5F5, 0xC5F5, 0xBDF5, 0xC5F5, 0xBDF5, 0xBDF5, 
        0xB5D5, 0xB594, 0xAD74, 0xAD74, 0xAD94, 0xAD74, 0xAD74, 0xAD74, 0xAD74, 0xAD94, 0xAD94, 0xAD74, 0xAD74, 0xA553, 0xA553, 0x9D53, 0x9D33, 0x9D13, 0x9D13, 0x9D13, 0x9D13, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0x9D13, 0x9D33, 0x9D13, 0x9D13, 0x9512, 
        0x94F2, 0x94F2, 0x8CD2, 0x8CB2, 0x8CB2, 0x84B2, 0x84B2, 0x84B2, 0x8491, 0x8491, 0x7C92, 0x7C91, 0x7C92, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7451, 0x7451, 0x7451, 0x7451, 0x7471, 0x7471,
  0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xCE57, 0xCE57, 0xCE77, 0xD697, 0xD697, 0xCE77, 0xCD71, 0xD54D, 0xD54E, 0xC50D, 0xB4CD, 0xAD0F, 0x94CF, 0x948E, 0x9CAE, 0x9CAE, 
        0xA4EF, 0xB551, 0xAD51, 0xA4EF, 0xA510, 0xBDB3, 0xBDB3, 0xB572, 0xAD31, 0xB571, 0xBD92, 0xAD30, 0xBDB2, 0xC5F4, 0xCE14, 0xCE35, 0xCE35, 0xD676, 0xCE56, 0xD656, 0xDEB8, 0xDEB8, 0xDEB8, 0xDE97, 0xCE56, 0xD676, 0xCE36, 0xC636, 0xCE57, 0xC657, 
        0xC636, 0xBE16, 0xC658, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xC657, 0xC637, 0xB5D5, 0xB5D5, 0xBE16, 0xB5B5, 0xAD73, 0xAD73, 0xA553, 0xA533, 0x9D32, 0x9D32, 0x9D12, 0x94D1, 0x8C6F, 0x94D1, 0x94D0, 0x94B0, 0x8C90, 0x94B0, 0x94D1, 0x8CD1, 0x8CB1, 
        0x8CB1, 0x8C90, 0x7C2E, 0x8C90, 0x8490, 0x7C2F, 0x7C4F, 0x7C0D, 0x840C, 0x8C4D, 0x944C, 0x9C6C, 0xA46C, 0xA48D, 0xA510, 0xB5F6, 0xBDD4, 0xCD4E, 0xD56E, 0xDD8E, 0xE5AF, 0xE5AF, 0xE58F, 0xE58F, 0xDD6E, 0xCDD3, 0xD6D9, 0xD656, 0xDD6E, 0xDD6E, 
        0xDD4E, 0xDD6E, 0xDD6E, 0xDD6E, 0xDD4E, 0xD52E, 0xCE36, 0xD698, 0xC572, 0xBC8C, 0xD5F3, 0xCD0D, 0xCCEC, 0xCCEC, 0xC4AC, 0xB44B, 0xA48E, 0xAD94, 0xA532, 0x942D, 0x9C2C, 0x944D, 0x946E, 0x948F, 0x8CAF, 0x7C8F, 0x6C2D, 0x7CB0, 0x7CF1, 0x74F1, 
        0x6CAF, 0x5C4E, 0x542E, 0x542D, 0x540D, 0x43AB, 0x4B6A, 0x63AA, 0x640C, 0xB615, 0xCDF5, 0xC5D4, 0xCDF4, 0xB510, 0xB552, 0xD656, 0xCDF4, 0xC5F5, 0xC657, 0xC657, 0xCE15, 0xC592, 0xD5F3, 0xC4EE, 0xB4CE, 0xD5B2, 0xC592, 0xBDB4, 0xC637, 0xC657, 
        0xCE57, 0xCE36, 0xBD72, 0xC50E, 0xACCF, 0xC572, 0xB531, 0xB5B4, 0xC636, 0xCE57, 0xAD52, 0xB5F5, 0xCE78, 0xBDF5, 0xC5F5, 0xCDF5, 0xBE16, 0xBE16, 0xC636, 0xBDD5, 0xBD72, 0x94AE, 0xADB4, 0xC657, 0xC637, 0xBDD5, 0xC636, 0xBDF5, 0xCD91, 0xC4CD, 
        0xBD71, 0x7D31, 0x5CCF, 0x5CCF, 0x5CCF, 0x5CCF, 0x64EF, 0x64F0, 0x6D10, 0x7531, 0x7531, 0x8572, 0x8DB4, 0x95B4, 0x9DB4, 0xA5F5, 0xAE16, 0xB616, 0xBE16, 0xBDF5, 0xBDF5, 0xBDD4, 0xBD93, 0xBD93, 0xBD52, 0xACF0, 0xA4D0, 0xA4AF, 0xA4AF, 0xA4AF, 
        0xA4D0, 0xA4AF, 0xA48E, 0xA48F, 0xA4AF, 0xAD11, 0xB531, 0xB552, 0xB552, 0xCE35, 0xC636, 0xBDF5, 0xC615, 0xC615, 0xC615, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF6, 0xC616, 0xC616, 0xC616, 0xC636, 0xCE36, 0xCE36, 0xD656, 0xD656, 0xD656, 0xD656, 
        0xD656, 0xD656, 0xD676, 0xD677, 0xD676, 0xD676, 0xD676, 0xD676, 0xD676, 0xD676, 0xD656, 0xD656, 0xD656, 0xD656, 0xD676, 0xD677, 0xDE77, 0xDE77, 0xDE77, 0xDE77, 0xDE77, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE77, 0xDE76, 0xDE76, 
        0xD656, 0xD656, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xC615, 0xC5F5, 0xBDF5, 0xBDD5, 0xB5B5, 0xB5B5, 0xB5D5, 0xB5D5, 0xBDF5, 0xC5D3, 0x6AC5, 0x7B05, 0xAC06, 0xC528, 0xC549, 0xCD49, 0xCD49, 0xBD29, 0xBCE8, 0xB4C8, 0xBC88, 0xBC47, 0x9BC6, 0x8325, 
        0x6A84, 0xA48D, 0xDE97, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xC615, 0xC615, 0xC615, 0xC615, 0xDE97, 0xEF1A, 0xEF3B, 0xA553, 0x2964, 0xDE78, 0xEF5B, 0xEF3C, 0xEF5C, 0x5B2B, 0x2144, 0xDE99, 0xEF5C, 0xEF5C, 0xB5D5, 0x73CD, 0xE71B, 
        0xDED9, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE16, 0xC616, 0xC615, 0xC5F5, 0xC615, 0xC615, 0xC615, 0xC616, 0xC616, 0xC615, 0xBDF5, 0xBDD5, 0xB5D5, 0xB5B4, 0xB5B4, 0xB5D5, 0xB5B4, 0xCD6E, 0xFEAE, 0xD633, 0xB5B4, 0xB5D5, 0xB5D4, 
        0xBDD5, 0xBDD5, 0xBDD5, 0xB5D4, 0xBDF5, 0xC5F5, 0xC5F5, 0xC5F5, 0xC5F5, 0xC5F5, 0xBDF5, 0xC5F5, 0xC616, 0xC615, 0xC615, 0xC616, 0xCE36, 0xC636, 0xC615, 0xC615, 0xC615, 0xBDF5, 0xBDF5, 0xBDD5, 0xC5F5, 0xBDF5, 0xBDD5, 0xBDF5, 0xBDF5, 0xC5F5, 
        0xBDD5, 0xB5B5, 0xB594, 0xB594, 0xB5B4, 0xB5D4, 0xB5B4, 0xB5B4, 0xB5B4, 0xBDF5, 0xC615, 0xC5F5, 0xBDD5, 0xB5B4, 0xB594, 0xAD94, 0xAD73, 0xA553, 0xA553, 0xA553, 0xA553, 0xAD53, 0xAD73, 0xAD74, 0xAD74, 0xA573, 0xA554, 0xA553, 0xA533, 0x9D33, 
        0x9D13, 0x9512, 0x94F2, 0x94F2, 0x94F2, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CD2, 0x8CD2, 0x84B2, 0x84B2, 0x84B2, 0x8492, 0x8492, 0x7C91, 0x7C91, 0x7C91, 0x7C91, 0x7C91, 0x7C91, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C71, 0x7C91,
  0xC616, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xBDD5, 0xAD73, 0xA532, 0xA511, 0x94AF, 0x8C6E, 0x8C4D, 0x9CCE, 0xA4EF, 0xAD30, 0xAD51, 0xAD51, 0x9CCF, 0xAD11, 0xBDB3, 0xBDB2, 
        0xB571, 0xAD30, 0xB571, 0xB572, 0xAD30, 0xBDD3, 0xC5F4, 0xCE14, 0xCE35, 0xCE55, 0xD676, 0xCE35, 0xDE97, 0xDEB8, 0xDEB8, 0xDEB8, 0xDEB8, 0xDE98, 0xCE56, 0xD656, 0xD677, 0xD656, 0xD656, 0xD656, 0xCE35, 0xCE35, 0xC5F5, 0xBDF6, 0xBE16, 0xBE16, 
        0xBDF5, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xC637, 0xC657, 0xCE58, 0xC657, 0xC657, 0xCE98, 0xCE98, 0xCE98, 0xCE98, 0xCE98, 0xCE78, 0xCE77, 0xC657, 0xBE36, 0xBDF6, 0xAD94, 0xBDF5, 0xBDF5, 0xAD73, 0xA553, 0xA553, 0xA532, 0x9D32, 0x9D32, 
        0x9D12, 0x94F1, 0x844F, 0x8C90, 0x94D1, 0x94F1, 0x94D1, 0x8C90, 0x8CB0, 0x8CB1, 0x8CB0, 0x8CB0, 0x8490, 0x740D, 0x7C4F, 0x8490, 0x846F, 0x844E, 0x842D, 0x83EB, 0x8C2C, 0x9C4C, 0x9C6C, 0xACAC, 0xACAD, 0xA510, 0xB616, 0xC5F4, 0xD56F, 0xE58F, 
        0xE5AF, 0xE5AF, 0xE5AF, 0xE5AE, 0xE58E, 0xDD6F, 0xD657, 0xD6B9, 0xCDB2, 0xCD91, 0xD5D2, 0xDD4D, 0xDD6E, 0xDD4E, 0xDD4D, 0xDD2D, 0xCD71, 0xCE78, 0xCE57, 0xCD0E, 0xD50D, 0xD50D, 0xD50D, 0xCCED, 0xC4CC, 0xBC8C, 0xA42B, 0xA511, 0xA553, 0x94AF, 
        0x942D, 0x946E, 0x948F, 0x948F, 0x844E, 0x744F, 0x6C0E, 0x6BED, 0x9512, 0xA532, 0xAD11, 0xC5B3, 0xCE14, 0xC5B3, 0xD677, 0xC5D4, 0xD634, 0xD614, 0xCE57, 0xCE78, 0xD5F3, 0xCDB3, 0xCE36, 0xB530, 0xBD72, 0xCE15, 0xDE35, 0xCDB2, 0xC636, 0xC636, 
        0xCE57, 0xCDB2, 0xCDF4, 0xD591, 0xB4CE, 0xCD2F, 0xD5D3, 0xBD93, 0xC616, 0xC637, 0xC657, 0xCE78, 0xC5D4, 0xC52F, 0xAC6D, 0xBD93, 0xB551, 0xB594, 0xBE16, 0xCE57, 0xA532, 0xADD4, 0xCE78, 0xC616, 0xCDF4, 0xCE36, 0xB5D5, 0xBDF6, 0xBDF5, 0xCD92, 
        0xB4CD, 0x6CCF, 0x5CCF, 0x5CCF, 0x5CEF, 0x5CCF, 0x5CF0, 0x5CF0, 0x64F0, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CEF, 0x5CCF, 0x5CEF, 0x64F0, 0x6D10, 0x6D31, 0x7531, 0x7D52, 0x8573, 0x8DB4, 0x9DD5, 0xA5F6, 0xAE16, 0xB616, 0xBE16, 0xBE16, 0xC616, 
        0xC616, 0xBDD4, 0xB552, 0xACF0, 0xA48E, 0xA44D, 0xA42C, 0xA40B, 0xA42C, 0xCE36, 0xCE78, 0xBDF5, 0xC615, 0xC615, 0xBE15, 0xC5F5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xC616, 0xC616, 0xC616, 0xCE16, 0xCE36, 0xCE36, 0xCE36, 0xD656, 0xD656, 
        0xD656, 0xD656, 0xD656, 0xD677, 0xD677, 0xD676, 0xD676, 0xD677, 0xD676, 0xD676, 0xD656, 0xD656, 0xD676, 0xD676, 0xD677, 0xDE77, 0xDE77, 0xDE77, 0xDE77, 0xDE77, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE77, 
        0xDE76, 0xD656, 0xCE56, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE16, 0xC615, 0xBDF5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xC615, 0xBD93, 0x9C4C, 0xBCCC, 0xD5AE, 0xDE71, 0xDE71, 0xDE50, 0xDE30, 0xD630, 0xD5F0, 0xD5F0, 0xBD4D, 0xB4AB, 0xC54C, 0xBD0C, 
        0x9C0A, 0x9C6D, 0xBDB4, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE15, 0xC615, 0xCE16, 0xC615, 0xCE36, 0xD698, 0xD658, 0x94D1, 0x4206, 0xB573, 0xC5F6, 0xBDF6, 0xB5D5, 0x73CD, 0x52E9, 0xB595, 0xBDF6, 0xC617, 0xA533, 0x844F, 0xC617, 
        0xCE58, 0xCE36, 0xCE56, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xC615, 0xC615, 0xCE16, 0xCE36, 0xCE36, 0xC615, 0xC5F5, 0xBDF5, 0xBDF5, 0xBDD5, 0xBDB5, 0xB5B4, 0xB5B4, 0xB573, 0xCD4C, 0xFECF, 0xDE31, 0xB594, 0xB5B5, 0xB5B4, 
        0xB5B4, 0xB5D5, 0xB5D4, 0xBDD4, 0xBDD5, 0xC5F5, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xC616, 0xCE16, 0xCE16, 0xCE36, 0xCE36, 0xCE36, 0xCE35, 0xCE36, 0xCE36, 0xC615, 0xC615, 0xC5F5, 0xBDF5, 0xC5F5, 0xC5F5, 0xC5F5, 0xC615, 0xC636, 0xCE36, 
        0xC5F5, 0xBDF5, 0xBDD5, 0xBDD5, 0xBDF5, 0xBDF5, 0xC615, 0xC615, 0xCE36, 0xD656, 0xD676, 0xD676, 0xCE36, 0xBDF5, 0xBDD4, 0xBDD4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB594, 0xB594, 0xB5B4, 0xB594, 0xAD74, 0xAD73, 0xAD73, 0xA553, 
        0xA553, 0xA553, 0x9D33, 0xA553, 0xA553, 0x9D33, 0x9D13, 0x9D13, 0x9D12, 0x9D33, 0x9D33, 0x9D13, 0x94F2, 0x94F2, 0x94F2, 0x94D2, 0x8CD2, 0x8CD2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B2, 0x84B1, 0x84B2, 0x84B2, 0x8CD2, 0x8CD2,
  0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC637, 0xC636, 0xAD53, 0x948F, 0xA4F0, 0xAD31, 0x9CCF, 0x9CAE, 0xAD51, 0xBDD3, 0xBDB3, 0xAD31, 0x9CCF, 0xAD31, 0xAD31, 0xA510, 0xBDB2, 0xBDB3, 
        0xC5F3, 0xC5F3, 0xCE35, 0xCE35, 0xCE15, 0xDEB7, 0xDEB8, 0xDEB8, 0xDEB8, 0xDEB8, 0xDEB8, 0xD676, 0xDE97, 0xDE97, 0xD677, 0xD676, 0xD676, 0xCE36, 0xC5F4, 0xC615, 0xD656, 0xD697, 0xD697, 0xDE97, 0xD676, 0xD676, 0xCE77, 0xC657, 0xC657, 0xC637, 
        0xBE16, 0xBE37, 0xC678, 0xCE78, 0xCE78, 0xC637, 0xBE17, 0xBDF6, 0xBDF6, 0xB5D5, 0xB5D5, 0xBE16, 0xBE16, 0xC637, 0xC637, 0xCE77, 0xCE78, 0xCE78, 0xCE78, 0xCE98, 0xCE98, 0xC657, 0xCE98, 0xD6B9, 0xCE98, 0xCE98, 0xCE78, 0xCE78, 0xC657, 0xBE16, 
        0xBDF6, 0xB5D5, 0xA553, 0xA553, 0xAD94, 0xA512, 0x9D12, 0x94F1, 0x9D12, 0x9D12, 0x9CF1, 0x8CB0, 0x8C6F, 0x7C2E, 0x846F, 0x94F1, 0x9D32, 0x9D32, 0x94B1, 0x8470, 0x8CB0, 0x8CB0, 0x846F, 0x7C2E, 0x6BAB, 0x73AC, 0x73ED, 0x740D, 0x842C, 0x942C, 
        0x9C6C, 0xACCD, 0xBD0D, 0xC52E, 0xCD4E, 0xCD4F, 0xCE56, 0xD6B9, 0xCDF3, 0xD5D2, 0xD590, 0xE58E, 0xE5AF, 0xE58E, 0xDD6E, 0xDD6E, 0xD5B2, 0xD698, 0xD677, 0xD56F, 0xDD4D, 0xDD6E, 0xDD4E, 0xDD4E, 0xDD4E, 0xDD2D, 0xCD0D, 0xCE15, 0xD698, 0xCDB2, 
        0xCCEC, 0xD50D, 0xCCED, 0xCCCD, 0xBC8C, 0xAC4C, 0x93CB, 0x83AB, 0xB5B5, 0xAD73, 0xB552, 0xBD72, 0xD676, 0xCE76, 0xCE36, 0xCE36, 0xD5F3, 0xCDD2, 0xB5B4, 0xC616, 0xCDB2, 0xC592, 0xCE15, 0xB552, 0xCE16, 0xB572, 0xDE56, 0xDDD2, 0xCE77, 0xCE57, 
        0xD656, 0xD570, 0xD656, 0xC5B3, 0xB530, 0xBD92, 0xD677, 0xCDD2, 0xC5F5, 0xC657, 0xCE57, 0xCE36, 0xC572, 0xD5B1, 0xB46C, 0xB4AE, 0xCD50, 0xB572, 0xBDF5, 0xC657, 0xBE16, 0xC637, 0xCE36, 0xC551, 0xBD30, 0xD656, 0xB573, 0xBDD5, 0xBE16, 0xC5F5, 
        0xBD50, 0x6CAE, 0x5CAF, 0x5CCF, 0x5CCF, 0x5CCF, 0x5CEF, 0x5CCF, 0x5CF0, 0x5CF0, 0x5CEF, 0x5CEF, 0x64F0, 0x6510, 0x64F0, 0x6510, 0x64F0, 0x64F0, 0x64F0, 0x6510, 0x6510, 0x64F0, 0x64F0, 0x64EF, 0x6510, 0x6D10, 0x6D11, 0x7531, 0x7D52, 0x8D93, 
        0x9DF5, 0xAE57, 0xBE57, 0xC678, 0xCE98, 0xCE57, 0xC5F5, 0xC593, 0xBD72, 0xD698, 0xCE78, 0xBDF5, 0xC616, 0xBDF6, 0xC5F6, 0xC5F6, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xC5F5, 0xC616, 0xC616, 0xC616, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xD656, 
        0xD656, 0xD656, 0xD656, 0xD676, 0xD676, 0xD676, 0xD676, 0xD677, 0xD677, 0xD677, 0xD656, 0xD656, 0xD676, 0xDE76, 0xDE77, 0xDE77, 0xDE77, 0xDE77, 0xDE97, 0xDE97, 0xDE97, 0xDE77, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE77, 
        0xDE77, 0xD676, 0xD676, 0xD656, 0xD656, 0xD656, 0xD656, 0xCE36, 0xCE36, 0xC615, 0xC615, 0xC615, 0xC5F5, 0xC5F5, 0xBDD4, 0x9C8E, 0xBD92, 0xCE35, 0xD656, 0xDE77, 0xDE97, 0xDE98, 0xDE98, 0xD698, 0xCE77, 0xCE57, 0xC616, 0xB5D4, 0xAD52, 0x9CF1, 
        0x9CAF, 0x8C0D, 0x946E, 0xCE15, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE16, 0xCE16, 0xCE16, 0xC5F5, 0xAD32, 0xA4D1, 0xA4F1, 0xAD53, 0xBDB4, 0xCE56, 0xD698, 0xD6B8, 0xD699, 0xD678, 0xDEB9, 0xDEDA, 0xCE98, 0xD698, 0xD6B9, 0xC657, 0xAD94, 0x94F2, 
        0x94D2, 0x9CF2, 0xA532, 0xCE15, 0xCE36, 0xCE36, 0xCE35, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xC615, 0xC5F5, 0xC5F5, 0xC615, 0xBDD5, 0xB5B4, 0xB5B5, 0xAD31, 0xD56B, 0xFEEF, 0xE670, 0xB593, 0xB5B4, 0xB5B4, 
        0xB5B4, 0xBDD5, 0xBDF5, 0xC5F5, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xC615, 0xC5F5, 0xC615, 0xC615, 0xCE16, 0xCE36, 0xD656, 0xD656, 
        0xCE36, 0xC615, 0xC636, 0xCE36, 0xCE16, 0xCE36, 0xCE36, 0xD656, 0xDE76, 0xDE97, 0xDEB7, 0xDE97, 0xD656, 0xCE15, 0xC615, 0xC5F5, 0xC5F5, 0xC5F5, 0xBDD5, 0xBDD4, 0xBDD4, 0xBDD4, 0xBDD4, 0xBDD4, 0xB5D4, 0xB5B4, 0xB5B4, 0xB5B4, 0xADB4, 0xB594, 
        0xB594, 0xB594, 0xB594, 0xB5B4, 0xB5B4, 0xAD94, 0xAD73, 0xAD73, 0xAD73, 0xAD73, 0xA573, 0xA553, 0x9D33, 0x9D33, 0x9D33, 0x9D33, 0x9D12, 0x9512, 0x9512, 0x94F2, 0x94F2, 0x94F2, 0x94F2, 0x94F2, 0x9512, 0x9512, 0x9513, 0x9D33, 0x9D33,
  0xC636, 0xC616, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC637, 0xCE57, 0xCE36, 0xB572, 0xA4F0, 0x9CAF, 0x946D, 0x9CEF, 0xB592, 0xB592, 0xBDB2, 0xC5D3, 0xC5F4, 0xCE14, 0xC5F4, 0xD697, 0xDE97, 
        0xDEB8, 0xDEB8, 0xDEB8, 0xDE97, 0xD676, 0xDE97, 0xD697, 0xD677, 0xD676, 0xD656, 0xD656, 0xC5F5, 0xD676, 0xD677, 0xD697, 0xD697, 0xD697, 0xD697, 0xD656, 0xDE76, 0xDE76, 0xDE35, 0xE634, 0xDE13, 0xDE76, 0xDEB8, 0xD698, 0xD698, 0xD699, 0xD698, 
        0xC616, 0xC615, 0xCDD3, 0xD5F4, 0xD635, 0xD636, 0xCE57, 0xCE57, 0xCE77, 0xC636, 0xC637, 0xCE78, 0xC657, 0xC637, 0xC658, 0xC658, 0xC657, 0xC637, 0xC637, 0xC637, 0xC637, 0xB5D5, 0xC616, 0xC637, 0xC637, 0xC657, 0xCE78, 0xCE78, 0xCE98, 0xCE78, 
        0xCE98, 0xCE98, 0xCE98, 0xCE77, 0xD6B9, 0xC616, 0xBE16, 0xC637, 0xC637, 0xBE16, 0xBDF6, 0xB5D5, 0xB5B5, 0xA553, 0x9D12, 0xA553, 0x9D12, 0x94B0, 0x94D1, 0x94F1, 0x94D1, 0x94D1, 0x94F1, 0x94F1, 0x8C90, 0x94D0, 0x94F1, 0x94D1, 0x8CB0, 0x8C6F, 
        0x846F, 0x8C8F, 0x8C6F, 0x844E, 0x7C2D, 0x7BEC, 0x846F, 0x8CD0, 0x8C8F, 0x948F, 0x9C6C, 0xACAC, 0xBD0D, 0xC52E, 0xCD2E, 0xCD4E, 0xC592, 0xCE99, 0xD6B8, 0xDDB0, 0xE5AE, 0xEDAF, 0xE5AE, 0xE58E, 0xE58E, 0xE56E, 0xDD6E, 0xD636, 0xD6B9, 0xD5F3, 
        0xDD4D, 0xDD6E, 0xDD6E, 0xDD6E, 0xDD4E, 0xD52D, 0xC48B, 0xB4AE, 0xC636, 0xCE78, 0xD5F4, 0xBCEF, 0xC5B3, 0xC615, 0xBDD4, 0xCE15, 0xD590, 0xC591, 0xB594, 0xB5F6, 0xC571, 0xC570, 0xCE56, 0xCE35, 0xC615, 0xC5F4, 0xDE14, 0xDDB1, 0xC5F5, 0xBE16, 
        0xD636, 0xCD4F, 0xCE35, 0xBD93, 0xBD92, 0xC5F5, 0xCE56, 0xDE13, 0xD5F4, 0xCE78, 0xCE78, 0xD5F4, 0xCDB2, 0xC5D3, 0xB4EF, 0xBD71, 0xD656, 0xCDD3, 0xC5B3, 0xC657, 0xCE57, 0xCE57, 0xC5D4, 0xD570, 0xAC6C, 0xB4EF, 0xC572, 0xB5B4, 0xBE16, 0xCE57, 
        0xB593, 0x5C6D, 0x548E, 0x548E, 0x5CAF, 0x5CCF, 0x5CCF, 0x5CCF, 0x5CCF, 0x5CCF, 0x5CEF, 0x5CF0, 0x5CCF, 0x54AF, 0x54CF, 0x5CCF, 0x5CCF, 0x54AF, 0x5CCF, 0x5D10, 0x6510, 0x6510, 0x5D10, 0x5D10, 0x6510, 0x6510, 0x6510, 0x6510, 0x6510, 0x6510, 
        0x6510, 0x6510, 0x6D10, 0x6D31, 0x7531, 0x7D72, 0x8D93, 0x95D4, 0x9DF5, 0x9DD5, 0x9DB4, 0xADD4, 0xBE15, 0xC616, 0xC616, 0xC616, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDD5, 0xBDF5, 0xBDF5, 0xC615, 0xC616, 0xC616, 0xC616, 0xCE36, 0xCE36, 0xCE36, 0xD656, 
        0xD656, 0xD656, 0xD656, 0xD676, 0xD676, 0xD676, 0xD676, 0xD677, 0xD677, 0xDE77, 0xDE77, 0xD676, 0xD676, 0xDE76, 0xDE77, 0xDE77, 0xDE77, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE77, 0xDE77, 
        0xDE97, 0xDE97, 0xDE76, 0xDE76, 0xD676, 0xD656, 0xD656, 0xD656, 0xD656, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE15, 0xDE96, 0xE6D8, 0xE6D9, 0xE6F9, 0xE6FA, 0xE6FA, 0xE6FA, 0xDED9, 0xDED9, 0xDEB9, 0xD6B8, 0xD698, 0xCE57, 0xC636, 
        0xC616, 0xBDB4, 0xCE15, 0xD636, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE16, 0xCE16, 0xCE15, 0xC5D4, 0xE6D9, 0xEF1A, 0xEF3B, 0xE71A, 0xE6FA, 0xE6D9, 0xDEB9, 0xD699, 0xD699, 0xD6B9, 0xD699, 0xCE38, 0xD6BA, 0xD6BA, 0xD6BA, 0xD699, 0xD6BA, 0xDEDA, 
        0xDEDA, 0xDEDA, 0xD678, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xC615, 0xC615, 0xC615, 0xC5F5, 0xBDF5, 0xBDD4, 0xACCD, 0xE5CC, 0xFEF0, 0xF6AF, 0xBD92, 0xBDD5, 0xBDD5, 
        0xBDF5, 0xC5F5, 0xC615, 0xC615, 0xCE35, 0xCE36, 0xCE36, 0xCE36, 0xCE35, 0xCE36, 0xCE36, 0xCE36, 0xD656, 0xD656, 0xD656, 0xCE56, 0xD656, 0xD656, 0xD656, 0xD656, 0xCE56, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xD656, 0xD656, 0xD656, 
        0xD656, 0xD656, 0xD676, 0xD676, 0xDE76, 0xD676, 0xD676, 0xDE96, 0xDE97, 0xE6B7, 0xE6B7, 0xDE96, 0xDE76, 0xD656, 0xCE56, 0xCE35, 0xCE36, 0xCE56, 0xCE15, 0xC615, 0xCE35, 0xCE35, 0xCE35, 0xC635, 0xC615, 0xC615, 0xC615, 0xC5F5, 0xC615, 0xC615, 
        0xC615, 0xC615, 0xC615, 0xC615, 0xC5F4, 0xBDF5, 0xBDD4, 0xBDD4, 0xB5B4, 0xB5B4, 0xB594, 0xAD94, 0xAD94, 0xAD94, 0xAD94, 0xAD94, 0xAD94, 0xAD73, 0xAD73, 0xA573, 0xA553, 0xA553, 0xA553, 0xA553, 0xA553, 0xA573, 0xAD74, 0xAD94, 0xAD74,
  0xC616, 0xC616, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC637, 0xC636, 0xCE37, 0xCE36, 0xC5F4, 0xC5F4, 0xBDD3, 0xBDD3, 0xD656, 0xDE97, 0xDEB7, 0xDEB7, 0xDEB7, 0xD697, 0xD676, 0xDEB8, 0xD697, 
        0xD697, 0xD677, 0xD656, 0xCE35, 0xC5F4, 0xD677, 0xD677, 0xD697, 0xD697, 0xD697, 0xDE97, 0xCE56, 0xDE76, 0xDE76, 0xDE55, 0xE633, 0xDE13, 0xDE76, 0xD656, 0xDDD1, 0xEDD0, 0xD590, 0xCD4E, 0xEDCF, 0xDE75, 0xDEB8, 0xD698, 0xD698, 0xD699, 0xD6B9, 
        0xCE36, 0xD5F4, 0xDD4E, 0xDD6E, 0xCD4E, 0xC550, 0xD58F, 0xDDB0, 0xDDB0, 0xD591, 0xCE36, 0xC678, 0xCE16, 0xD5F4, 0xD615, 0xD635, 0xD656, 0xD677, 0xD677, 0xCE78, 0xCE78, 0xBDF6, 0xCE57, 0xCE58, 0xC637, 0xC657, 0xC657, 0xC657, 0xC637, 0xC657, 
        0xC637, 0xC637, 0xC636, 0xBE16, 0xC657, 0xC616, 0xC636, 0xC657, 0xCE78, 0xD699, 0xD699, 0xD699, 0xD699, 0xCE98, 0xC657, 0xD699, 0xCE78, 0xC636, 0xBE36, 0xBE36, 0xBE16, 0xB5F6, 0xB5D5, 0xAD94, 0x9D12, 0x9CF1, 0xA533, 0x9D12, 0x94B1, 0x94B1, 
        0x94D1, 0x94D1, 0x94D1, 0x9CF2, 0x9CF1, 0x8C6F, 0x94B0, 0x8CB0, 0x8C90, 0x8C90, 0x846F, 0x844E, 0x844E, 0x842E, 0x844D, 0x7C0C, 0x842D, 0x8CD1, 0x94D0, 0x948D, 0xA48D, 0xB4AC, 0xBCED, 0xC52D, 0xCD4E, 0xD54E, 0xD56F, 0xCE56, 0xD6DA, 0xDE34, 
        0xE58F, 0xE5AF, 0xE5AF, 0xE5AF, 0xE58F, 0xDD6E, 0xD50D, 0xCD50, 0xC636, 0xD698, 0xDE35, 0xCCED, 0xB4EF, 0xB572, 0xBDD4, 0xCDF4, 0xDDF2, 0xD5F3, 0xCE77, 0xDEDA, 0xDE14, 0xC4ED, 0xC5B3, 0xC615, 0xBDD4, 0xD656, 0xDDB1, 0xDDB0, 0xB593, 0xB5D5, 
        0xBDB4, 0xCD2F, 0xCDF4, 0xCE35, 0xD677, 0xC5F5, 0xCE36, 0xDDF2, 0xD5D3, 0xC637, 0xD698, 0xD5D2, 0xC592, 0xC5F5, 0xA4AE, 0xC5D4, 0xC5F5, 0xDE55, 0xD5D2, 0xCE57, 0xCE57, 0xD615, 0xC5D3, 0xCDD3, 0xB510, 0xB531, 0xD676, 0xC5F5, 0xC615, 0xC636, 
        0xB5D5, 0x5C6E, 0x546E, 0x4C4E, 0x546E, 0x5CAF, 0x548F, 0x548E, 0x54AF, 0x5CAF, 0x54AF, 0x54AF, 0x54CF, 0x4C6D, 0x3BEC, 0x3BEC, 0x6CD0, 0x84F1, 0x64AF, 0x5CCF, 0x5D10, 0x6510, 0x6510, 0x5D10, 0x6510, 0x5CF0, 0x5D10, 0x6510, 0x6510, 0x6510, 
        0x6510, 0x6510, 0x6530, 0x6510, 0x6510, 0x6510, 0x6510, 0x6510, 0x6510, 0x6510, 0x64F0, 0x6D11, 0x7532, 0x8D73, 0xA5B4, 0xB5F5, 0xBE16, 0xBE16, 0xBDF5, 0xBDF5, 0xBDF5, 0xC5F6, 0xC616, 0xC616, 0xC616, 0xC615, 0xC616, 0xCE36, 0xCE36, 0xD677, 
        0xD677, 0xD677, 0xD677, 0xD656, 0xD656, 0xD656, 0xD676, 0xD676, 0xD677, 0xDE77, 0xDE77, 0xD677, 0xDE77, 0xDE77, 0xDE76, 0xDE76, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 
        0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE77, 0xDE76, 0xD676, 0xD676, 0xD676, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD676, 0xDEB8, 0xE6F9, 0xE6FA, 0xE71A, 0xE71A, 0xE6FA, 0xE6FA, 0xE71A, 0xE6FA, 0xE6FA, 0xDEDA, 0xDED9, 0xD6B8, 0xD677, 
        0xCE77, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE16, 0xCE36, 0xC615, 0xCE15, 0xC5D5, 0xBDD5, 0xBDB4, 0xA4F1, 0xB553, 0xB593, 0xB553, 0xAD53, 0xA553, 0xA533, 0xA532, 0x94D1, 0xA533, 0xA533, 0xA533, 0xA533, 0xA553, 0x9D33, 
        0x94B1, 0xA554, 0xB5B5, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE16, 0xCE16, 0xCE15, 0xC615, 0xC616, 0xBDB3, 0xBCAA, 0xEDEC, 0xFEF0, 0xFF10, 0xD5F1, 0xBDF5, 0xC615, 
        0xC615, 0xC615, 0xC615, 0xCE35, 0xCE35, 0xCE36, 0xCE36, 0xCE36, 0xCE56, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xCE56, 0xCE56, 0xCE56, 0xCE36, 0xCE56, 0xD656, 0xD676, 0xDE76, 0xDE76, 
        0xDE77, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE96, 0xDE76, 0xDE97, 0xDE97, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE6B7, 0xDE96, 0xDE76, 0xDE96, 0xDE76, 0xD676, 0xD676, 0xDE76, 0xDE76, 0xDE76, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xCE35, 
        0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xC615, 0xC615, 0xC5F5, 0xC5F5, 0xBDF5, 0xBDF4, 0xBDD4, 0xBDD5, 0xBDD4, 0xBDD4, 0xBDD4, 0xB5D4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB594, 0xAD94, 0xB594, 0xB594, 0xB5B4, 0xB5B4, 0xB594,
  0xC616, 0xC616, 0xC616, 0xC616, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC616, 0xC636, 0xC636, 0xC636, 0xCE36, 0xD697, 0xDE97, 0xD656, 0xBDD3, 0xDE97, 0xDE97, 0xD676, 0xCE56, 0xCE35, 0xC614, 0xC5F4, 0xD697, 0xD697, 
        0xD697, 0xD697, 0xD677, 0xD676, 0xCE56, 0xDEB7, 0xDE76, 0xDE35, 0xDE13, 0xDE34, 0xD677, 0xD613, 0xE5D0, 0xE5D0, 0xCD6F, 0xE5AE, 0xE5CF, 0xDE97, 0xDE77, 0xE5CF, 0xDD8F, 0xC5D3, 0x9CAC, 0xE5AF, 0xE675, 0xDEB8, 0xD698, 0xD698, 0xD699, 0xD6B9, 
        0xCE36, 0xD614, 0xDD6F, 0xDD6E, 0xA4AD, 0xB593, 0xC54F, 0xE58E, 0xE5AE, 0xDD8F, 0xD656, 0xD6BA, 0xDE14, 0xE56E, 0xE58F, 0xE58F, 0xCD4F, 0xBD2F, 0xDDB0, 0xDDB0, 0xDDB1, 0xCDB3, 0xCE57, 0xCE78, 0xCE15, 0xCE15, 0xD657, 0xD678, 0xD699, 0xD699, 
        0xCE98, 0xCE78, 0xC637, 0xBE16, 0xCE78, 0xC637, 0xC637, 0xC657, 0xC657, 0xC637, 0xBE17, 0xBDF6, 0xBE16, 0xC636, 0xBDF6, 0xCE58, 0xCE78, 0xCE98, 0xD699, 0xD6B9, 0xD6B9, 0xD6B9, 0xD6B9, 0xD699, 0xCE78, 0xC657, 0xCE98, 0xC657, 0xBE16, 0xBE16, 
        0xBE16, 0xBDF6, 0xB5D5, 0xAD74, 0xA532, 0x94D1, 0x9CF1, 0x9D12, 0x94D1, 0x94D1, 0x94B0, 0x94D1, 0x94F1, 0x94F1, 0x94D1, 0x846F, 0x842E, 0x8C90, 0x94D1, 0x9D32, 0x94D1, 0x7C2E, 0x842E, 0x842E, 0x842E, 0x7C0C, 0x73AB, 0x7C2E, 0x8490, 0x8C8E, 
        0xACCD, 0xBD0E, 0xCD4E, 0xDD8F, 0xDD8F, 0xDD8E, 0xD50D, 0xCDD3, 0xBE16, 0xD6B8, 0xDE56, 0xCCED, 0xAC8D, 0xC5D4, 0xBD92, 0xAD10, 0xCD70, 0xD5F3, 0xCE78, 0xDEFA, 0xDE34, 0xD52D, 0xB4EE, 0xAD31, 0xBDD4, 0xBD93, 0xE654, 0xDDD1, 0xD657, 0xDED9, 
        0xDE98, 0xD54F, 0xCD71, 0xCE15, 0xC615, 0xC615, 0xCE14, 0xDD90, 0xCD91, 0xAD53, 0xAD94, 0xBD51, 0xC592, 0xCE36, 0xCE15, 0xCE36, 0xC615, 0xDE34, 0xDDD1, 0xCE36, 0xD698, 0xD5D3, 0xC592, 0xCDF4, 0xB551, 0xCE15, 0xCE36, 0xD614, 0xC5F5, 0xC616, 
        0xBE36, 0x646E, 0x4C0D, 0x4C4D, 0x4C6E, 0x548E, 0x4C6E, 0x4C6E, 0x54AF, 0x5CCF, 0x548E, 0x548F, 0x54AF, 0x54CF, 0x4C6E, 0x33CB, 0x7D11, 0x9D94, 0x8D73, 0x4C6E, 0x5CF0, 0x5CCF, 0x54AF, 0x5CF0, 0x5CF0, 0x5CF0, 0x64F0, 0x5CF0, 0x6510, 0x64F0, 
        0x5CF0, 0x5CCF, 0x5CF0, 0x6510, 0x6510, 0x5CF0, 0x6510, 0x6530, 0x6D30, 0x6530, 0x6510, 0x6510, 0x5D10, 0x5D10, 0x5D10, 0x6D11, 0x7D52, 0x9593, 0xADD5, 0xBE16, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC615, 0xC616, 0xC636, 0xBDF5, 0x9D52, 
        0x7CB0, 0x8D32, 0xBDF5, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD677, 0xD677, 0xD677, 0xD677, 0xDE77, 0xDE77, 0xDE77, 0xDE77, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE77, 0xDE97, 0xDE97, 0xDE97, 
        0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE76, 0xDE76, 0xDE76, 0xD677, 0xD677, 0xD676, 0xD676, 0xD676, 0xD676, 0xD676, 0xDE76, 0xDEB8, 0xE6D9, 0xE6F9, 0xE6FA, 0xE6D9, 0xDED9, 0xDED9, 0xDEB9, 0xD698, 0xD698, 0xD698, 0xD698, 0xD698, 0xCE77, 
        0xD677, 0xD677, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xBD93, 0xAD11, 0xD676, 0xDE77, 0xD676, 0xD676, 0xDEB8, 0xE6F9, 0xE6D9, 0xDED9, 0xDED9, 0xDED9, 0xDED9, 0xDED9, 0xDEFA, 0xDEFA, 0xDEFA, 0xD6D9, 0xCE78, 0xBE16, 
        0xB5B5, 0xBDD6, 0xBDD5, 0xB593, 0xCE36, 0xCE56, 0xCE36, 0xCE56, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE16, 0xCE16, 0xC636, 0xB52F, 0xCCE9, 0xEDEC, 0xFEF1, 0xFF31, 0xE630, 0xC5D4, 0xC615, 
        0xC615, 0xC615, 0xCE35, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE56, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xCE56, 0xCE56, 0xD656, 0xCE56, 0xCE56, 0xD656, 0xD676, 0xDE97, 0xDE97, 
        0xDE97, 0xDE97, 0xE6B7, 0xE6B7, 0xE697, 0xDE97, 0xDE97, 0xDE97, 0xE6B7, 0xE6D7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xE696, 0xE697, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 
        0xD636, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xC615, 0xC615, 0xC615, 0xC615, 0xC5F5, 0xC5F5, 0xC5F5, 0xBDF4, 0xBDD4, 0xBDD4, 0xBDD4, 0xBDD4, 0xBDD4, 0xBDD4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4,
  0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC637, 0xC636, 0xCE15, 0xC614, 0xBDB3, 0xC5F4, 0xD656, 0xD656, 0xD656, 0xD656, 0xD677, 0xD656, 0xCE56, 0xDEB7, 0xDE96, 
        0xE675, 0xDE34, 0xDE55, 0xD677, 0xD5F2, 0xE5D0, 0xDDB0, 0xCD6F, 0xE5AE, 0xE612, 0xDEB8, 0xDE13, 0xEDAE, 0xDDD1, 0xB571, 0xC52D, 0xEE10, 0xDE97, 0xDE76, 0xDDB0, 0xBD50, 0xCDF4, 0xAD0F, 0xB4ED, 0xDE76, 0xDEB8, 0xD698, 0xD698, 0xD6B9, 0xD6B9, 
        0xCE36, 0xD5F4, 0xCD4E, 0xBD2F, 0xA4F0, 0xB5B4, 0xA4CF, 0xCD90, 0xE5AF, 0xDD90, 0xD656, 0xD6DA, 0xDE34, 0xE58F, 0xE5AF, 0xD54E, 0xA4CF, 0xBDB3, 0xCD4E, 0xE5AE, 0xE58E, 0xD5D2, 0xD698, 0xD678, 0xDDB1, 0xDD8F, 0xDDB0, 0xDDB1, 0xCD91, 0xD5D2, 
        0xDDF3, 0xDDF3, 0xD5D3, 0xC616, 0xCE78, 0xC637, 0xCE57, 0xCE57, 0xD698, 0xCE98, 0xCE78, 0xCE78, 0xC658, 0xC637, 0xBDF6, 0xC657, 0xC637, 0xBE37, 0xC637, 0xC657, 0xC637, 0xC658, 0xC657, 0xCE57, 0xC657, 0xC616, 0xCE78, 0xCE78, 0xCE78, 0xD699, 
        0xD699, 0xD6B9, 0xD6B9, 0xD698, 0xCE78, 0xC637, 0xC636, 0xCE57, 0xAD94, 0xB5B4, 0xB5D5, 0xB5B5, 0xB5B4, 0xAD74, 0xA532, 0x94D1, 0x8C90, 0x94D1, 0x94D1, 0x8C90, 0x8CB0, 0x94F1, 0x9D12, 0x9D12, 0x94F1, 0x94B1, 0x844F, 0x846F, 0x8C6F, 0x846F, 
        0x846E, 0x7BEC, 0x7BEC, 0x8C2D, 0x944D, 0x944D, 0x8C0C, 0x8C6F, 0x846F, 0x9512, 0x9D11, 0xA4AF, 0x9C8E, 0xA531, 0xB592, 0x9C4C, 0xBD0E, 0xCDF4, 0xC657, 0xD6B9, 0xDE34, 0xDD4E, 0xBCAD, 0xBD93, 0xB572, 0xA4CF, 0xD5B1, 0xDDD1, 0xD677, 0xDEDA, 
        0xDEB8, 0xDD8F, 0xCCEE, 0xB510, 0xB593, 0xBDF5, 0xDE56, 0xE5D0, 0xD5D3, 0xCE77, 0xD6B9, 0xD5F4, 0xC50F, 0xCE15, 0xCE57, 0xBDF5, 0xD656, 0xDDD1, 0xD5B0, 0xB573, 0xB5D5, 0xBD72, 0xC592, 0xCE35, 0xCE36, 0xCE56, 0xC615, 0xD614, 0xC5D4, 0xBDD5, 
        0xBDF5, 0x6C6E, 0x4C0D, 0x4C4D, 0x544E, 0x546E, 0x546E, 0x546E, 0x548F, 0x54AF, 0x548F, 0x54AF, 0x5CCF, 0x54AF, 0x548E, 0x54AF, 0x5CAF, 0x5CAF, 0x5C8F, 0x4C8E, 0x5CCF, 0x54AF, 0x54AF, 0x5CEF, 0x5CCF, 0x5CAE, 0x5CCF, 0x5CF0, 0x5CEF, 0x54AF, 
        0x5CEF, 0x548E, 0x442D, 0x444D, 0x5CAF, 0x74F0, 0x5C6E, 0x5CEF, 0x6531, 0x6510, 0x6510, 0x6510, 0x6511, 0x6531, 0x6511, 0x6510, 0x5D10, 0x64F0, 0x6D11, 0x8552, 0x9593, 0xADD5, 0xBDF5, 0xC616, 0xCE36, 0xCE36, 0xCE16, 0xCE36, 0x8CD0, 0x2AA7, 
        0x2287, 0x2AC8, 0x6C2D, 0xC615, 0xD656, 0xD656, 0xD656, 0xD656, 0xD676, 0xD677, 0xD677, 0xD677, 0xDE76, 0xDE76, 0xDE77, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 
        0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE77, 0xDE77, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xCE35, 0xCE35, 0xCE36, 0xCE56, 0xD677, 0xD677, 0xCE57, 0xCE77, 0xCE56, 0xC616, 0xBDF5, 0xBDD5, 0xB5B4, 0xAD74, 0xAD53, 
        0xAD53, 0xB573, 0xC5F5, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE16, 0xCE36, 0xCE35, 0xCE15, 0xCE14, 0xE6D8, 0xE6D8, 0xDEB8, 0xE6D9, 0xE6D9, 0xE6D9, 0xDED9, 0xDED9, 0xDEDA, 0xDEDA, 0xDEDA, 0xDEDA, 0xDEFA, 0xDEDA, 0xDEDA, 0xD6B9, 0xD699, 0xCE98, 
        0xCE78, 0xCE78, 0xCE78, 0xCE56, 0xCE56, 0xCE56, 0xCE36, 0xCE56, 0xCE36, 0xCE56, 0xCE56, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE16, 0xCE36, 0xC5D3, 0xBCAB, 0xDD4B, 0xEE0D, 0xE5ED, 0xF6B0, 0xF690, 0xCDB1, 0xCE36, 
        0xCE36, 0xCE15, 0xCE35, 0xCE36, 0xCE36, 0xCE36, 0xCE56, 0xCE56, 0xD656, 0xD656, 0xD676, 0xD676, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xD656, 0xD656, 0xDE76, 0xDE96, 
        0xDE97, 0xDE97, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6D7, 0xE6D7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xE697, 0xDE96, 0xDE96, 0xDE96, 0xDE76, 0xDE56, 0xDE56, 0xD656, 0xD656, 0xD656, 
        0xD656, 0xD636, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE15, 0xC615, 0xC615, 0xC615, 0xC615, 0xC5F5, 0xBDF5, 0xBDF5, 0xBDD5, 0xBDD4, 0xBDD4, 0xBDD4, 0xBDD4, 0xBDD4, 0xB5D4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4,
  0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC636, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xCE56, 0xCE36, 0xC615, 0xCE56, 0xDE76, 0xDE55, 0xDE55, 0xDE33, 0xDE55, 0xD656, 0xDDD2, 0xE5F0, 0xD590, 
        0xD58F, 0xEDCE, 0xE633, 0xDE97, 0xDDD1, 0xE58E, 0xCDD2, 0xA4EF, 0xDD6D, 0xEE32, 0xE6B8, 0xDE13, 0xD58F, 0xBD51, 0xC5D3, 0xA4CD, 0xD58F, 0xE6B7, 0xDE56, 0xC5B2, 0xC5B3, 0xD5F3, 0xCDF3, 0xA50F, 0xC5F5, 0xDED9, 0xDE98, 0xD698, 0xD6B9, 0xD6B9, 
        0xCE16, 0xBDD4, 0xAD31, 0xB5B3, 0xC5B3, 0xCDF5, 0xBD71, 0xB5B4, 0xC591, 0xD590, 0xD656, 0xD6DA, 0xDE34, 0xE58F, 0xD56F, 0xB50F, 0xAD31, 0xBDD4, 0xACEF, 0xDD90, 0xE5AF, 0xD5D2, 0xD6B9, 0xDEB8, 0xDDD0, 0xE58E, 0xEDCF, 0xBCED, 0xB572, 0xBD50, 
        0xE58E, 0xE5AE, 0xDD8F, 0xD635, 0xD699, 0xCE36, 0xD5D2, 0xDD8F, 0xDDB1, 0xCD91, 0xCDB2, 0xDDF3, 0xDE14, 0xD5F4, 0xC636, 0xCE99, 0xCE57, 0xCE57, 0xD678, 0xCE78, 0xD698, 0xCE78, 0xCE78, 0xCE78, 0xC637, 0xBDF6, 0xCE58, 0xC637, 0xC637, 0xC657, 
        0xC657, 0xC637, 0xC657, 0xC657, 0xCE78, 0xC657, 0xCE57, 0xCE98, 0xC637, 0xC677, 0xCE99, 0xD6B9, 0xD6B9, 0xD698, 0xCE78, 0xCE58, 0xBE16, 0xC657, 0xC637, 0xB5B5, 0xB5B5, 0xB5B4, 0xAD94, 0xA553, 0xA533, 0xA532, 0x94D1, 0x9CF1, 0x9CF1, 0x94D0, 
        0x8C8F, 0x9490, 0x94D1, 0x94D1, 0x94B0, 0x8C90, 0x846F, 0x7C0D, 0x846F, 0x8CB0, 0x8C8F, 0x846F, 0x7C0E, 0x6BED, 0x7C4E, 0x8490, 0x846F, 0x846F, 0x846F, 0x8490, 0x94F0, 0xAD0F, 0xACEF, 0xAD31, 0xB572, 0xACCD, 0xCD2E, 0xD5D2, 0xCE77, 0xD699, 
        0xDE97, 0xE5AF, 0xCCAB, 0xB4CE, 0xBDD4, 0xAD10, 0xC592, 0xDDAF, 0xD5F3, 0xD698, 0xDEFB, 0xE635, 0xCD0D, 0xB50F, 0xB592, 0xBDD4, 0xCE15, 0xE5F2, 0xDDB0, 0xCE36, 0xD6B9, 0xD614, 0xC52F, 0xCE35, 0xCE56, 0xBDF5, 0xCE35, 0xD5B1, 0xB551, 0xA532, 
        0xA532, 0x636B, 0x6C0E, 0x642E, 0x5C2E, 0x542E, 0x544E, 0x544E, 0x546E, 0x4C6D, 0x4C4D, 0x4C4D, 0x4C6E, 0x548E, 0x548E, 0x548E, 0x548F, 0x548E, 0x4C8E, 0x54AF, 0x54AF, 0x54AF, 0x54CF, 0x5CCF, 0x6CAE, 0x94ED, 0x84AC, 0x64CF, 0x54CF, 0x54AF, 
        0x5CCF, 0x5CCF, 0x4C8E, 0x3C0C, 0x5C8F, 0x9553, 0x8552, 0x548E, 0x5CF0, 0x5CCF, 0x5CF0, 0x5CF0, 0x5CF0, 0x5D10, 0x5D10, 0x6510, 0x6510, 0x5D10, 0x5CF0, 0x5CD0, 0x5CF0, 0x6510, 0x6D11, 0x7D32, 0x9573, 0xADD5, 0xBE16, 0xD657, 0x8510, 0x3369, 
        0x3BEB, 0x3C2C, 0x5C6E, 0xC636, 0xD656, 0xD656, 0xD656, 0xD656, 0xDE77, 0xDE77, 0xDE77, 0xDE97, 0xDE97, 0xDE97, 0xDEB7, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE76, 0xDE55, 0xDE97, 0xDE97, 0xDE97, 0xDE76, 
        0xE6B7, 0xDE96, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE77, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xCE15, 0xD656, 0xE6B8, 0xE6D9, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xDED9, 0xDEB9, 0xD698, 0xCE77, 0xC636, 
        0xC616, 0xB573, 0xC5D4, 0xCE56, 0xCE36, 0xCE36, 0xCE36, 0xCE16, 0xCE36, 0xCE36, 0xCE35, 0xD655, 0xE6B8, 0xE6F9, 0xE6D9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6FA, 0xE6FA, 0xE6FA, 0xDED9, 0xDEDA, 0xDEDA, 0xDEDA, 0xDEDA, 0xE71B, 0xDEFA, 0xD6B9, 0xD6B9, 
        0xD6B9, 0xD6BA, 0xD698, 0xCE56, 0xCE36, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE35, 0xCE36, 0xCDF4, 0xB4AC, 0xCCEA, 0xDD4B, 0xEDEC, 0xEE6E, 0xEE6F, 0xF68F, 0xDDCF, 0xCDD3, 
        0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE56, 0xCE56, 0xD656, 0xD656, 0xD676, 0xD676, 0xD676, 0xD676, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xCE56, 0xCE36, 0xCE36, 0xCE56, 0xCE36, 0xCE36, 0xCE56, 0xD656, 0xD656, 0xD676, 0xDE96, 
        0xDE97, 0xDE97, 0xE6B7, 0xE6B7, 0xE6D7, 0xE6D7, 0xE6B8, 0xE6D7, 0xE6D7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xE697, 0xE697, 0xDE96, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 0xDE56, 0xD656, 0xD656, 0xD656, 
        0xD656, 0xD656, 0xD636, 0xCE36, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE15, 0xCE15, 0xC615, 0xC615, 0xC615, 0xC615, 0xC5F5, 0xC5F5, 0xC5F5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDD5, 0xBDD4, 0xBDD4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4,
  0xBE16, 0xBE16, 0xBE16, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC636, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC636, 0xC636, 0xCE57, 0xD677, 0xCE56, 0xCDB2, 0xE5AF, 0xD58F, 0xD54E, 0xE5AE, 0xE632, 0xDE97, 0xE5D0, 0xDD8E, 0xBD71, 
        0xACCE, 0xE5AE, 0xE653, 0xDEB8, 0xDDD1, 0xCD70, 0xBD51, 0xBD71, 0xACAC, 0xE612, 0xDED8, 0xCE14, 0xBDB2, 0xC5B3, 0xD614, 0xC5B2, 0x9CAD, 0xDE97, 0xCE36, 0xB551, 0xBDB3, 0xBD93, 0xBD92, 0xBDB3, 0xCE56, 0xDED9, 0xD698, 0xD698, 0xD6B9, 0xD6B9, 
        0xC616, 0xBDD5, 0x9D12, 0x9D32, 0xA553, 0xA553, 0xAD73, 0xA553, 0xA532, 0xAD10, 0xD656, 0xDEDA, 0xD5F4, 0xBCEE, 0xB572, 0xBDB4, 0xCDF4, 0xCDB3, 0xB551, 0xBD93, 0xD590, 0xD5B2, 0xDEB9, 0xDEB8, 0xE5D0, 0xE5AF, 0xCD4F, 0xA4EF, 0xBDF5, 0xB531, 
        0xCD4F, 0xE5AF, 0xDD8F, 0xD656, 0xDEDA, 0xCE57, 0xDDB1, 0xEDAE, 0xD54E, 0xB551, 0xBD72, 0xDD8E, 0xE5AE, 0xDD8F, 0xD635, 0xD699, 0xDE35, 0xDD8F, 0xDDB0, 0xDDD1, 0xCD91, 0xCDB2, 0xDDF3, 0xDE14, 0xD5F4, 0xC616, 0xCE99, 0xCE78, 0xCE57, 0xD678, 
        0xD698, 0xD699, 0xCE99, 0xCE78, 0xCE78, 0xBE16, 0xC616, 0xC637, 0xC637, 0xC637, 0xC657, 0xC657, 0xC657, 0xC657, 0xC657, 0xC658, 0xC637, 0xCE78, 0xD699, 0xD699, 0xD6B9, 0xD6B9, 0xD6B9, 0xD6B9, 0xCE98, 0xCE78, 0xBE16, 0xBE16, 0xC636, 0xBDD5, 
        0xB594, 0xAD94, 0xAD74, 0xA553, 0xA532, 0xA512, 0x94B1, 0x8C8F, 0x844F, 0x94B0, 0x9490, 0x8C90, 0x8C90, 0x94D1, 0x94D1, 0x8CB0, 0x8490, 0x7BED, 0x846F, 0x8CB0, 0x8C90, 0x8CB1, 0x846F, 0x740D, 0x7C4E, 0x848F, 0x846F, 0x846F, 0x8CB0, 0x846F, 
        0x848F, 0xA4CF, 0xB52F, 0xAD10, 0xB5B4, 0xB510, 0xC50D, 0xD54E, 0xCDF3, 0xCE77, 0xD6B9, 0xE654, 0xDD4D, 0xB4CE, 0xB593, 0xB572, 0xB531, 0xDDB1, 0xDDB1, 0xCE57, 0xDEDA, 0xDE55, 0xCD0D, 0xACEF, 0xB592, 0xBDD4, 0xCE15, 0xDDF2, 0xC5B3, 0xCE57, 
        0xCE36, 0x942D, 0xB552, 0x9C4C, 0x9C2C, 0x9C8D, 0x948E, 0x8C8E, 0x742D, 0x748F, 0x748F, 0x6C8F, 0x646F, 0x648F, 0x5C6E, 0x5C6F, 0x5C8F, 0x546E, 0x546E, 0x4C4D, 0x4C4D, 0x4C6E, 0x4C4D, 0x546E, 0x5C6D, 0x9CAC, 0x94AC, 0x64EF, 0x5CCF, 0x5CAF, 
        0x5CCF, 0x5CAF, 0x54AF, 0x5CCF, 0x5CCF, 0x5CAF, 0x5CAF, 0x548E, 0x5CCF, 0x54AF, 0x5CD0, 0x5CF0, 0x5CCF, 0x54CF, 0x5CF0, 0x5CD0, 0x54CF, 0x5CF0, 0x5CF0, 0x54AF, 0x446D, 0x444D, 0x548E, 0x74F1, 0x6C8F, 0x5C8E, 0x7531, 0x8D72, 0x64EF, 0x33CB, 
        0x3BEC, 0x3C4D, 0x5C6E, 0xC636, 0xD656, 0xCE56, 0xCE56, 0xC615, 0xBDD4, 0xBDD4, 0xBDF4, 0xB5B3, 0xB592, 0xAD51, 0xAD31, 0xBD92, 0xDE97, 0xE697, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xE675, 0xDE33, 0xDE97, 0xDE97, 0xDE77, 0xE6B7, 
        0xFF99, 0xEF17, 0xDE96, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE77, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xDE77, 0xE6B8, 0xE6D9, 0xE6D9, 0xE6D9, 0xE6FA, 0xE71A, 0xE6FA, 0xE6DA, 0xDEB9, 0xDEB9, 0xDEB9, 0xDEB9, 0xDEB9, 0xD698, 
        0xCE57, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE35, 0xD636, 0xE6D9, 0xE6FA, 0xDED8, 0xE6D9, 0xE6F9, 0xE6D9, 0xE6FA, 0xE6FB, 0xE6FA, 0xDEB9, 0xE71B, 0xE71B, 0xDEFA, 0xDEDA, 0xE71B, 0xE6FB, 0xD699, 0xCE99, 
        0xCE78, 0xD699, 0xDEB9, 0xCE56, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xCE56, 0xCE56, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE15, 0xB4CD, 0xC4CA, 0xDD4B, 0xDD4B, 0xE5AC, 0xEE0D, 0xDD8C, 0xE5AC, 0xE5CD, 0xD56D, 
        0xCDF4, 0xCE56, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE56, 0xCE56, 0xD656, 0xD656, 0xD676, 0xD676, 0xD676, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE56, 0xD656, 0xD676, 0xDE76, 
        0xDE97, 0xDE97, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6D7, 0xE6D7, 0xE6D7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xE697, 0xE697, 0xE697, 0xE697, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xD656, 
        0xD656, 0xD656, 0xD656, 0xD656, 0xCE36, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE15, 0xC615, 0xCE15, 0xC615, 0xC615, 0xC5F5, 0xC5F5, 0xC5F5, 0xC5F5, 0xBDF5, 0xBDF5, 0xBDD4, 0xBDD4, 0xBDD4, 0xBDD4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4,
  0xBE16, 0xBE16, 0xBE16, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xBE16, 0xBE16, 0xC616, 0xBE16, 0xC616, 0xC616, 0xC616, 0xC636, 0xD677, 0xDE97, 0xD677, 0xD5B1, 0xE58E, 0xC591, 0xA4AD, 0xE5AE, 0xE633, 0xDE97, 0xDDD1, 0xC52F, 0xB551, 
        0xAD10, 0xBCED, 0xE654, 0xDEB8, 0xCDB2, 0xBD92, 0xC5B2, 0xCE13, 0xA50F, 0xB550, 0xE6D8, 0xBDD3, 0xB572, 0xBDD3, 0xBD93, 0xB572, 0xAD10, 0xDE97, 0xD615, 0xBD51, 0xC5F4, 0xCE14, 0xC5F4, 0xC614, 0xD697, 0xDEB8, 0xD698, 0xD698, 0xD6B9, 0xD6B9, 
        0xCE16, 0xCE36, 0xB5F5, 0xB5B5, 0xB594, 0xAD93, 0xAD73, 0xA553, 0xA532, 0xACCF, 0xCE36, 0xDEFA, 0xBD72, 0x948E, 0xA553, 0xAD73, 0xB594, 0xB5B4, 0xBDB4, 0xAD73, 0xB552, 0xBD72, 0xDEB9, 0xDEB9, 0xD590, 0xC54F, 0xBD93, 0xC592, 0xCDF4, 0xBD0F, 
        0xBDB3, 0xD5B0, 0xDD8F, 0xDE56, 0xDEDA, 0xCE57, 0xDDD1, 0xDD6E, 0xB4CE, 0xB5B4, 0xB5B4, 0xC54F, 0xE5AF, 0xE5AF, 0xD635, 0xDEDA, 0xDE34, 0xE58E, 0xEDCF, 0xDD6E, 0xAD10, 0xB530, 0xDD8E, 0xEDAF, 0xDD8F, 0xD614, 0xCE78, 0xD635, 0xDD90, 0xDDB1, 
        0xDDD2, 0xD5F3, 0xDE35, 0xDE56, 0xDE56, 0xCE16, 0xCE58, 0xCE78, 0xC657, 0xCE78, 0xCE99, 0xD699, 0xD699, 0xCE79, 0xC658, 0xBE37, 0xB5F6, 0xC617, 0xBE17, 0xBE37, 0xC657, 0xCE58, 0xCE78, 0xCE78, 0xCE98, 0xCE98, 0xCE78, 0xCE78, 0xD6B9, 0xD698, 
        0xD699, 0xD6B9, 0xD6B9, 0xD699, 0xCE98, 0xC657, 0xAD94, 0xA553, 0xAD94, 0xBDF5, 0xB594, 0x9CF2, 0x9D12, 0x9D12, 0x9D12, 0x9D12, 0x94D1, 0x842E, 0x8C4F, 0x8C6F, 0x8C4F, 0x8C70, 0x94D1, 0x9CF1, 0x94F1, 0x94D1, 0x94B0, 0x7C2E, 0x844E, 0x846F, 
        0x7C0E, 0x73ED, 0x740E, 0x740D, 0x848F, 0x94F1, 0x9D32, 0x94CF, 0x9CF0, 0x94D0, 0x8CD1, 0xAD10, 0xC50F, 0xACAE, 0xA511, 0xBD92, 0xB48C, 0xDD6E, 0xD5D1, 0xCE77, 0xDEDA, 0xE676, 0xDD4E, 0xB4EE, 0xBDD3, 0xB5B3, 0xBD93, 0xD5B2, 0xC5D3, 0xCE77, 
        0xD677, 0xB510, 0xCD91, 0xCCED, 0xD52D, 0xD50D, 0xCCED, 0xC4CC, 0xA42B, 0xAD52, 0xA573, 0x8C2D, 0x93EB, 0x940C, 0x8C2D, 0x948E, 0x94D0, 0x84AF, 0x746E, 0x74B0, 0x74F0, 0x6CD0, 0x6CB0, 0x64AF, 0x5C2D, 0x740C, 0x642D, 0x548F, 0x548E, 0x546E, 
        0x5CAF, 0x54AF, 0x548E, 0x54AF, 0x54AF, 0x54AF, 0x548E, 0x5CCF, 0x5CAF, 0x54AF, 0x5CCF, 0x5CCF, 0x54CF, 0x5CD0, 0x5CF0, 0x5CCF, 0x54CF, 0x5CF0, 0x5CF0, 0x5CCF, 0x54CF, 0x442D, 0x4C2D, 0x8D52, 0x9573, 0x5C4E, 0x54AF, 0x54AF, 0x5CEF, 0x54CF, 
        0x4CAF, 0x4C6E, 0x5C8E, 0xBE15, 0xCE56, 0xD656, 0xD657, 0xA510, 0x8BEA, 0x942B, 0x9C2B, 0x946C, 0xACCD, 0xB48B, 0xB46B, 0xB52F, 0xDE97, 0xE697, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xE696, 0xEE74, 0xDE96, 0xDE97, 0xDE77, 0xE6B7, 
        0xF758, 0xEED7, 0xDE97, 0xDE97, 0xDE97, 0xDE77, 0xDE77, 0xDE77, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xDE77, 0xE6D9, 0xE6D9, 0xDE97, 0xDE97, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xBDD5, 0xD677, 0xDEB9, 0xDEB9, 0xDEB9, 0xCE36, 
        0xBDD4, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xD636, 0xE6D9, 0xE6FA, 0xE71A, 0xD698, 0xD678, 0xE71A, 0xE6FA, 0xE71B, 0xE71B, 0xEF3C, 0xAD74, 0x7BEF, 0xD678, 0xEF3B, 0xE71B, 0xE6FB, 0xDEDA, 0xBDF6, 
        0xC658, 0xDEFA, 0xDED9, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xCE56, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE35, 0xBCEE, 0xB449, 0xCCEA, 0xDD4B, 0xE5AC, 0xEE0C, 0xEE0C, 0xE5AB, 0xDD8B, 0xE58B, 0xDD6B, 
        0xCD4E, 0xCDF4, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xD656, 0xD656, 0xD656, 0xD676, 0xD676, 0xD676, 0xD676, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xCE56, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE56, 0xD656, 0xD656, 0xD656, 
        0xDE77, 0xDE97, 0xDE97, 0xE6B7, 0xE6B7, 0xE6D7, 0xE6D7, 0xE6D7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xE697, 0xE697, 0xE697, 0xE697, 0xDE96, 0xDE96, 0xDE96, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 
        0xD676, 0xD656, 0xD656, 0xD656, 0xCE56, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE15, 0xC615, 0xC615, 0xC615, 0xC5F5, 0xC5F5, 0xC5F5, 0xC5F5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDD4, 0xBDD4, 0xBDD4, 0xBDD4, 0xB5D4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4,
  0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xC616, 0xBE16, 0xBE16, 0xBE16, 0xC616, 0xBE16, 0xBE16, 0xC616, 0xC616, 0xC636, 0xD677, 0xD697, 0xD677, 0xD591, 0xC54F, 0xB551, 0xA50F, 0xBCED, 0xE653, 0xDE97, 0xCDB2, 0xBD72, 0xBD72, 
        0xC5B2, 0xA4CE, 0xC5D3, 0xDEB8, 0xAD52, 0xB572, 0xBD92, 0xB592, 0xB572, 0xB572, 0xE6D8, 0xC592, 0xBD92, 0xC5D4, 0xC5F4, 0xC5F4, 0xD614, 0xDEB7, 0xDE56, 0xDE13, 0xB572, 0xC5F4, 0xA510, 0xBDD3, 0xDEB8, 0xDEB8, 0xD698, 0xD698, 0xD6B9, 0xD6B9, 
        0xCE16, 0xCE57, 0xC657, 0x8C90, 0x9D11, 0xCE57, 0x844E, 0xB5B4, 0xCE15, 0xD590, 0xDE77, 0xDEDA, 0xD5F3, 0xBD72, 0xB5B4, 0xAD73, 0xAD73, 0xAD74, 0xAD73, 0xA552, 0xA4D0, 0xB530, 0xDED9, 0xDE98, 0xACAE, 0xA4F1, 0xAD73, 0xB593, 0xB5B4, 0xBDB4, 
        0xB5B4, 0xB593, 0xC550, 0xCE36, 0xDEDA, 0xCE57, 0xC572, 0xBD71, 0xC5B3, 0xCE15, 0xC592, 0xBD72, 0xCDB1, 0xDD8F, 0xDE35, 0xDEDA, 0xDE55, 0xEDAF, 0xE5AF, 0xBCEE, 0xB593, 0xB552, 0xC52E, 0xE5CF, 0xE5AF, 0xDE35, 0xDEDA, 0xDE34, 0xE58F, 0xEDCF, 
        0xD54E, 0xB50F, 0xC54F, 0xE5AF, 0xE5AF, 0xDDB1, 0xD678, 0xCE99, 0xCE57, 0xD5D3, 0xDDD2, 0xDE14, 0xD614, 0xD635, 0xD656, 0xD656, 0xCE36, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE79, 0xCE78, 0xCE78, 0xC678, 0xCE78, 0xC637, 0xC616, 0xC657, 0xC637, 
        0xC637, 0xCE58, 0xCE78, 0xCE78, 0xCE78, 0xCE98, 0xC616, 0xB5B4, 0xC657, 0xD6B9, 0xD698, 0xCE78, 0xCE78, 0xCE78, 0xC657, 0xC637, 0xBDF6, 0xAD94, 0xB5B4, 0xBDF5, 0xAD53, 0x9CF2, 0x9D12, 0xA512, 0x9D12, 0x9D12, 0x9CF1, 0x8C8F, 0x8C6F, 0x94B1, 
        0x9CF1, 0x94D1, 0x8C90, 0x8C90, 0x8CB0, 0x8CB0, 0x8CB0, 0x846F, 0x7C0D, 0x7C2E, 0x7C2E, 0x742E, 0x848F, 0x848F, 0x846F, 0x8CB0, 0x94AF, 0x9CAE, 0x9CEF, 0xA532, 0xA553, 0xB572, 0xBD0F, 0xACAE, 0xAD31, 0xB572, 0xB48D, 0xCD4F, 0xC5F4, 0xCE98, 
        0xD698, 0xC571, 0xCDB1, 0xDD4E, 0xDD6E, 0xDD6E, 0xDD6E, 0xDD6E, 0xCD2E, 0xCE15, 0xCE78, 0xCD50, 0xD50C, 0xD52D, 0xD50D, 0xCCEC, 0xC4CC, 0xB44B, 0xA46D, 0xAD73, 0x9CAF, 0x9C4C, 0xA46D, 0x9C8D, 0x9CAE, 0x9C8E, 0x73AB, 0x742E, 0x74B0, 0x74B0, 
        0x644E, 0x6C8F, 0x648F, 0x5C4E, 0x5C6E, 0x5C6E, 0x548E, 0x548E, 0x546E, 0x4C6E, 0x548E, 0x4C6E, 0x4C6E, 0x4C6E, 0x54AF, 0x54AF, 0x548E, 0x5CCF, 0x5CCF, 0x5CCF, 0x5CD0, 0x5CF0, 0x54AE, 0x5CAF, 0x6CD0, 0x5C8E, 0x548E, 0x54CF, 0x5CD0, 0x54CF, 
        0x54CF, 0x5CF0, 0x5CD0, 0x64F0, 0x8552, 0xA5B4, 0xB5F5, 0xBDB3, 0xBCCC, 0xD50C, 0xD4EC, 0xD5F3, 0xD5B1, 0xD50C, 0xE56E, 0xE634, 0xE6B8, 0xE697, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xE675, 0xEE93, 0xF6B2, 0xE653, 0xDE76, 0xDE97, 0xE696, 
        0xF737, 0xE6B6, 0xDE97, 0xDE97, 0xDE97, 0xDE77, 0xDE77, 0xDE97, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE97, 0xE6D8, 0xE6D9, 0xD677, 0xCE15, 0xEF1B, 0xE6FA, 0xE6FA, 0xE71A, 0x9CF1, 0xCE36, 0xDED9, 0xDEB9, 0xDEB8, 0xD657, 
        0xBDD4, 0xCE56, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xDE77, 0xEEFA, 0xEF1A, 0xE6FA, 0x842E, 0x630A, 0xE6D9, 0xEF1A, 0xE71A, 0xE71B, 0xCE58, 0x3A27, 0x2164, 0x8C2F, 0xEF3B, 0xE71B, 0xE6FB, 0xC617, 0x5B2B, 
        0x94D1, 0xDEFB, 0xDEFA, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xCE56, 0xCE56, 0xCE36, 0xCE36, 0xCE56, 0xC5D4, 0xB4EE, 0xB469, 0xC489, 0xDD2B, 0xE58B, 0xEDEC, 0xF66E, 0xF68E, 0xF68E, 0xF66E, 0xEE4D, 0xEE0C, 
        0xE5AC, 0xD56E, 0xC5D3, 0xCE35, 0xD656, 0xD636, 0xD656, 0xD656, 0xD656, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xD676, 0xD676, 0xD656, 0xD656, 0xCE56, 0xCE56, 0xCE36, 0xCE36, 0xCE35, 0xCE35, 0xCE35, 0xCE36, 0xCE36, 0xCE56, 0xD656, 0xD656, 0xD656, 
        0xDE76, 0xDE97, 0xDE97, 0xE6B7, 0xE6B7, 0xE6D7, 0xE6D7, 0xE6D7, 0xE6D7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xE697, 0xE697, 0xDE96, 0xDE96, 0xDE96, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 
        0xDE76, 0xDE76, 0xDE56, 0xD656, 0xD656, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE15, 0xC615, 0xC615, 0xC615, 0xC615, 0xC5F5, 0xC5F5, 0xBDF5, 0xBDF5, 0xBDD5, 0xBDD4, 0xBDD4, 0xBDD4, 0xBDD4, 0xBDD4, 0xBDD4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4,
  0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xC616, 0xBE16, 0xBE16, 0xBE16, 0xC616, 0xC616, 0xC616, 0xC636, 0xD677, 0xD697, 0xD677, 0xBD92, 0xB592, 0xC592, 0xC5B2, 0x9C8D, 0xBD71, 0xDE97, 0xAD51, 0xB572, 0xBD92, 
        0xB592, 0xB551, 0xC5F4, 0xDEB8, 0xBD71, 0xC5B3, 0xBDD3, 0xBDD3, 0xC5F3, 0xD635, 0xDEB8, 0xDE14, 0xCDD3, 0xAD31, 0xC5F4, 0x9CCF, 0xD635, 0xE6B8, 0xDE76, 0xDE13, 0x9CD0, 0xAD31, 0x9CD0, 0xAD31, 0xDEB8, 0xDEB8, 0xD698, 0xD698, 0xD6B9, 0xD6B9, 
        0xCE16, 0xCE37, 0xBDF6, 0x738C, 0x8C6F, 0xB594, 0x52C8, 0x9CF1, 0xD656, 0xDDD1, 0xDE97, 0xDEDA, 0xDE14, 0xD5F4, 0xC616, 0x842E, 0xB5D5, 0xBDF5, 0x94D0, 0xBE16, 0xD5B2, 0xD5D2, 0xDED9, 0xDE98, 0xCD71, 0xBDB4, 0xB594, 0xAD94, 0xB594, 0xAD94, 
        0xAD73, 0xA532, 0xACCF, 0xCE16, 0xDEDA, 0xCE37, 0xAD74, 0xAD73, 0xB594, 0xBDD5, 0xC5D5, 0xBDD5, 0xB594, 0xBD51, 0xCE15, 0xDEFA, 0xDE35, 0xCD4F, 0xBD71, 0xBD93, 0xC5F4, 0xB531, 0xB552, 0xCDB1, 0xDDAF, 0xDE55, 0xDEDA, 0xDE34, 0xE5AF, 0xDD8F, 
        0xB4EE, 0xB5B4, 0xACF0, 0xCD4F, 0xEDAF, 0xDDB0, 0xDE98, 0xD6BA, 0xD657, 0xE5B0, 0xEDCF, 0xC52E, 0xAD10, 0xD56F, 0xE5AF, 0xE5AF, 0xD614, 0xCE99, 0xD657, 0xDDD1, 0xDDD2, 0xDE13, 0xDE14, 0xD614, 0xD635, 0xD636, 0xD636, 0xCE57, 0xCE78, 0xCE78, 
        0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xBE17, 0xB5B5, 0xBDF6, 0xC657, 0xC637, 0xC637, 0xC658, 0xCE78, 0xCE98, 0xCE98, 0xCE98, 0xCE57, 0xCE57, 0xD6B9, 0xCE98, 0xCE78, 0xCE98, 0xCE78, 0xCE78, 0xC657, 0xC616, 0xB5D5, 0xB594, 0xBDD5, 
        0xB594, 0x9D12, 0x9CF2, 0x9D32, 0x9D32, 0x9D12, 0x9CF1, 0x94D1, 0x8C4F, 0x94B0, 0x94D1, 0x94D1, 0x94B0, 0x8C6F, 0x8C90, 0x8CD0, 0x94D1, 0x8C90, 0x7C2E, 0x842E, 0x844F, 0x7C4E, 0x846F, 0x846F, 0x7C4E, 0x846F, 0x8C8F, 0x948F, 0x94F1, 0x94F1, 
        0x9D32, 0xA4F0, 0xC570, 0xD56E, 0xDDAF, 0xE5AF, 0xE5AF, 0xE5AF, 0xDD6F, 0xD677, 0xDEB9, 0xDDD1, 0xDD6E, 0xE56E, 0xDD6E, 0xDD6E, 0xDD6E, 0xDD4D, 0xC550, 0xCE78, 0xCDD3, 0xD52D, 0xDD4D, 0xDD2D, 0xD52D, 0xCCEC, 0xA3E9, 0xA44C, 0xAD73, 0xA532, 
        0x7B8A, 0xAD11, 0x9C8D, 0x944D, 0x948E, 0x8C8E, 0x742D, 0x746E, 0x74B0, 0x74D0, 0x74D0, 0x6CD0, 0x6CD0, 0x648F, 0x544E, 0x546E, 0x546E, 0x548E, 0x548E, 0x4C4E, 0x4C6E, 0x548E, 0x5CAF, 0x54AF, 0x5CCF, 0x54AF, 0x5CAF, 0x5CAF, 0x5CCF, 0x54AF, 
        0x54CF, 0x5CD0, 0x5CCF, 0x54AF, 0x5CCF, 0x5CCF, 0x64AF, 0x74EF, 0x8CEE, 0xACED, 0xACCC, 0xCDF3, 0xC570, 0xBCCC, 0xDD6E, 0xDE13, 0xCE56, 0xD636, 0xDE76, 0xE697, 0xDE97, 0xDE97, 0xDE97, 0xE675, 0xEE73, 0xEE92, 0xDE54, 0xDE96, 0xDE97, 0xE696, 
        0xEED6, 0xE6B6, 0xDE97, 0xDE97, 0xDE97, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xDE97, 0xE6D9, 0xE6F9, 0xD677, 0xCDF5, 0xEF1B, 0xE6FA, 0xE6FA, 0xE71A, 0xA531, 0xCE56, 0xDED9, 0xDED9, 0xDEB8, 0xD677, 
        0xC5F5, 0xCE56, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE35, 0xD676, 0xE6D9, 0xE6F9, 0xD698, 0x73EE, 0x4A88, 0xD657, 0xE6F9, 0xDED9, 0xE71A, 0xB5D5, 0x3A47, 0x31E6, 0x73AD, 0xDED9, 0xDEFA, 0xDEB9, 0xB5D5, 0x52EA, 
        0x94B1, 0xCE78, 0xD698, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xCE56, 0xCE36, 0xCE36, 0xCE56, 0xCE15, 0xA44B, 0xAC29, 0xC4A9, 0xCD0A, 0xDD6B, 0xE5AC, 0xEE2D, 0xF68E, 0xF6AF, 0xFEF0, 0xFF11, 0xFF11, 0xFF11, 
        0xFEF0, 0xF64E, 0xD54D, 0xC592, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xD676, 0xD656, 0xD656, 0xD656, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE36, 0xCE56, 0xD656, 0xDE76, 
        0xDE97, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6D7, 0xE6D7, 0xE6D7, 0xE6D7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xE697, 0xDE96, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE96, 
        0xDE96, 0xDE76, 0xDE76, 0xD656, 0xD656, 0xD656, 0xCE35, 0xCE35, 0xCE35, 0xCE15, 0xC615, 0xC615, 0xC615, 0xC5F5, 0xC5F5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDD4, 0xBDD4, 0xBDD4, 0xBDD4, 0xBDD4, 0xB5D4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4,
  0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xBE16, 0xBE16, 0xBE16, 0xC616, 0xC616, 0xC636, 0xC636, 0xD677, 0xD697, 0xCE56, 0xB572, 0xB572, 0xBD92, 0xBD92, 0xB551, 0xBD92, 0xDE97, 0xC571, 0xBDB2, 0xC5D3, 
        0xBDD3, 0xC5D3, 0xDE76, 0xDEB8, 0xDDF3, 0xC5B2, 0xAD51, 0xB552, 0xAD31, 0xDE76, 0xDEB8, 0xDE35, 0xC5D3, 0x944E, 0xB572, 0x946E, 0xCDF4, 0xDEB8, 0xDE76, 0xD614, 0xA511, 0xA511, 0x9CAF, 0xAD52, 0xDEB8, 0xDEB8, 0xD698, 0xD698, 0xD6B9, 0xDEB9, 
        0xCE36, 0xCE37, 0xBDF6, 0x7BEE, 0x842E, 0xA533, 0x632A, 0x9CF1, 0xCE15, 0xDDB1, 0xDE97, 0xDEDA, 0xDE34, 0xD614, 0xB594, 0x634B, 0xA553, 0x9CD1, 0x634A, 0xB5D5, 0xDDF3, 0xDDF2, 0xDEDA, 0xDEB8, 0xDDF2, 0xD677, 0xA512, 0x9CF1, 0xCE77, 0xA512, 
        0xB5B4, 0xD635, 0xDD90, 0xDE76, 0xDEDA, 0xCE57, 0xBDD5, 0xB593, 0xAD94, 0xB594, 0xB594, 0xAD73, 0xA532, 0xACCF, 0xC5F4, 0xDF1B, 0xBD93, 0x9CAF, 0xAD53, 0xB593, 0xBDB4, 0xBDB4, 0xB594, 0xAD53, 0xB551, 0xCE15, 0xDEFA, 0xDE34, 0xC54F, 0xBD92, 
        0xC593, 0xC5F4, 0xBD10, 0xBD72, 0xD5B1, 0xDDB0, 0xDEB9, 0xD6DA, 0xD656, 0xE5D1, 0xD54E, 0xA4AE, 0xB5B4, 0xB50F, 0xE5AF, 0xEDAF, 0xDE13, 0xDEFA, 0xDE77, 0xE5AF, 0xEDAF, 0xDD8E, 0xBD0F, 0xC570, 0xE5AF, 0xE5CF, 0xDDB0, 0xD677, 0xD698, 0xD614, 
        0xDDD2, 0xDDF2, 0xE634, 0xDE35, 0xDE35, 0xDE56, 0xCE15, 0xBDB4, 0xC637, 0xD699, 0xCE78, 0xCE78, 0xCE99, 0xCE78, 0xCE58, 0xC657, 0xC657, 0xBDF6, 0xBDF6, 0xC657, 0xC657, 0xC657, 0xC657, 0xCE58, 0xCE78, 0xCE78, 0xCE98, 0xCE78, 0xCE57, 0xD6B9, 
        0xD6B9, 0xCE98, 0xCE98, 0xCE78, 0xCE78, 0xC637, 0xBE36, 0xBDF6, 0xB594, 0xB5B4, 0xB5B4, 0xA553, 0x9CF1, 0x9D32, 0xA532, 0x9D12, 0x9CF1, 0x94B1, 0x8C6F, 0x8C6F, 0x94D1, 0x9CF1, 0x94D1, 0x8C90, 0x8C70, 0x8C90, 0x8C90, 0x844F, 0x7C0D, 0x846F, 
        0x846F, 0x846F, 0x8C6E, 0x7BEC, 0x8C2C, 0x946C, 0x9C6C, 0xA48C, 0x9C8D, 0xA572, 0xADD4, 0xBD70, 0xD56E, 0xDD8F, 0xDD8F, 0xE5AF, 0xE5AF, 0xE58E, 0xD5B1, 0xD698, 0xDE14, 0xE56E, 0xE58E, 0xE58E, 0xE58E, 0xD50C, 0xB448, 0xC4ED, 0xCE36, 0xCE35, 
        0xBCCD, 0xCD91, 0xCD0D, 0xD50D, 0xD50D, 0xC4CC, 0xAC2B, 0xA4F0, 0xA553, 0x9C4C, 0xA44B, 0xA44C, 0x9C4D, 0x946D, 0x948E, 0x844D, 0x746E, 0x748F, 0x6C6F, 0x6C6F, 0x6C8F, 0x6C8F, 0x6C90, 0x6C8F, 0x5C6E, 0x648F, 0x548E, 0x546E, 0x4C6E, 0x4C4D, 
        0x4C2D, 0x4C4E, 0x4C6E, 0x4C6E, 0x4C6E, 0x4C4D, 0x4C6E, 0x548E, 0x5CCF, 0x64AE, 0x64AE, 0x8D30, 0x8CCE, 0x73EA, 0x9C8C, 0xC591, 0xB5B3, 0xC614, 0xD656, 0xE697, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xE675, 0xE674, 0xDE76, 0xDE76, 0xDE96, 0xE696, 
        0xE653, 0xDE76, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xDE97, 0xE6D9, 0xDEB8, 0xDE97, 0xD677, 0xE6FA, 0xE71A, 0xE71A, 0xDED9, 0xCE56, 0xD698, 0xD698, 0xDED9, 0xD6B8, 0xCE36, 
        0xBDB4, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE35, 0xD636, 0xE6D9, 0xE6FA, 0xD698, 0x8470, 0x52A8, 0xD657, 0xEF3B, 0xE71B, 0xEF5C, 0xADB4, 0x3A47, 0x4268, 0x73CD, 0xEF1B, 0xE73B, 0xE71B, 0xBDF6, 0x4AC9, 
        0xA533, 0xD6B9, 0xD6B9, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xCE56, 0xCE36, 0xD656, 0xB4EF, 0xA3E8, 0xBC69, 0xCCC9, 0xDD4A, 0xE58B, 0xEDEC, 0xF64D, 0xF66E, 0xF66E, 0xFEF0, 0xFF11, 0xFF11, 0xFF11, 
        0xFF31, 0xFEF0, 0xEE2D, 0xC52D, 0xCDF4, 0xD676, 0xD656, 0xD656, 0xD676, 0xD676, 0xD676, 0xD676, 0xD676, 0xD676, 0xD676, 0xD656, 0xD656, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xD656, 0xD676, 0xDE97, 
        0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6D7, 0xE6D8, 0xE6D7, 0xE6D7, 0xE6D8, 0xEED8, 0xEED8, 0xE6D7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xDE96, 0xDE96, 0xDE96, 0xDE96, 0xDE96, 0xDE76, 0xDE96, 0xDE96, 0xDE96, 
        0xDE96, 0xDE76, 0xDE76, 0xD676, 0xD656, 0xD656, 0xCE35, 0xCE35, 0xCE35, 0xCE15, 0xC615, 0xC615, 0xC615, 0xC615, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDD5, 0xBDD4, 0xBDD4, 0xBDD5, 0xBDD4, 0xBDD4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4,
  0xBE16, 0xBE16, 0xBE16, 0xC616, 0xC616, 0xC616, 0xC616, 0xC636, 0xC636, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC636, 0xC636, 0xD677, 0xD697, 0xCE56, 0xB551, 0xC5D3, 0xC5F4, 0xC5F4, 0xC5D3, 0xD635, 0xDE97, 0xDDF3, 0xB551, 0xAD31, 
        0xAD51, 0xB592, 0xDE96, 0xDEB8, 0xDE13, 0xAD31, 0x8C2D, 0x9CD0, 0x9CCF, 0xD676, 0xDEB8, 0xDE34, 0xC5B3, 0x9CD0, 0xAD52, 0x9CAF, 0xCDF3, 0xDEB7, 0xDE76, 0xD614, 0xAD52, 0x8C4E, 0x948F, 0xAD52, 0xDEB8, 0xDEB8, 0xD698, 0xD698, 0xD6B9, 0xD6B9, 
        0xCE36, 0xCE57, 0xC616, 0x8C70, 0x7C0E, 0x94B1, 0x6B8C, 0xA553, 0xCE15, 0xDDB1, 0xDE97, 0xDEDA, 0xDE14, 0xCDF4, 0xBDD5, 0x73CD, 0xAD53, 0x9CD1, 0x73CD, 0xB5B4, 0xDDF3, 0xDDF3, 0xDEBA, 0xDE98, 0xDDF2, 0xD656, 0x842F, 0x7C0D, 0xBDF5, 0x6B8B, 
        0x9D12, 0xD656, 0xE5B0, 0xDE76, 0xDEDA, 0xD657, 0xCE37, 0xBDD5, 0x94B0, 0xCE77, 0xBDD5, 0xB593, 0xC615, 0xD570, 0xD635, 0xDEFA, 0xD5F4, 0xBD52, 0xB594, 0xB594, 0xA553, 0xA553, 0xA533, 0x94B1, 0x9C8F, 0xC5D5, 0xE71B, 0xBD72, 0xA510, 0xAD94, 
        0xBDB4, 0xC615, 0xCDF4, 0xBDD5, 0xB593, 0xC592, 0xDEB9, 0xD6DA, 0xD656, 0xBD50, 0xAD30, 0xBD92, 0xC5B3, 0xB531, 0xC5B2, 0xDD8F, 0xDE14, 0xDEFA, 0xDE77, 0xE5CF, 0xE5AF, 0xBCEE, 0xAD52, 0xC5B3, 0xDD6F, 0xEDCF, 0xE5B0, 0xDE97, 0xDEB9, 0xE5F2, 
        0xE5AF, 0xEDCF, 0xD54E, 0xB50F, 0xDD8F, 0xEDCF, 0xDD4E, 0xCD71, 0xCE78, 0xD699, 0xD636, 0xDDF3, 0xDE35, 0xDE76, 0xDE76, 0xD657, 0xD677, 0xC616, 0xC636, 0xD699, 0xCE78, 0xCE99, 0xCE99, 0xCE78, 0xC657, 0xC637, 0xC637, 0xBE16, 0xB5D5, 0xC616, 
        0xC637, 0xC657, 0xCE78, 0xCE98, 0xCE98, 0xD698, 0xD698, 0xD698, 0xCE77, 0xD698, 0xD6B9, 0xCE98, 0xCE78, 0xCE78, 0xCE57, 0xC637, 0xBDF6, 0xB5B5, 0xAD53, 0xA532, 0xAD93, 0x9D12, 0x9490, 0x9CD1, 0x9CF2, 0x9CF2, 0x94D1, 0x8C6F, 0x7BED, 0x8C6F, 
        0x94B0, 0x9D12, 0x9D12, 0x8C90, 0x8CB0, 0x8CD1, 0x8CD0, 0x846F, 0x73CC, 0x73EC, 0x73ED, 0x7C2D, 0x842D, 0x8C2C, 0x946D, 0x9C8D, 0xACEE, 0xB4ED, 0xAD30, 0xB616, 0xC5B2, 0xD54E, 0xDD8F, 0xE5AF, 0xE5AF, 0xD52C, 0xBC89, 0xC50E, 0xD697, 0xD676, 
        0xCD70, 0xD5D1, 0xDD4E, 0xDD6E, 0xDD6E, 0xDD6D, 0xD52D, 0xC5D3, 0xCE57, 0xD54F, 0xD52D, 0xDD2D, 0xD52D, 0xD50D, 0xCCEC, 0xB46C, 0xAD11, 0xAD94, 0x9C8E, 0xA44C, 0xA46D, 0x9C2D, 0x940D, 0x7BCB, 0x8C6F, 0xA573, 0x7C90, 0x746F, 0x748F, 0x74B0, 
        0x74B0, 0x6CD0, 0x6CD0, 0x64AF, 0x5C8F, 0x546E, 0x4C4D, 0x4C4D, 0x4C6D, 0x4C6E, 0x444D, 0x546D, 0x5C8E, 0x546D, 0x542D, 0x7CCF, 0xA592, 0xC615, 0xDE76, 0xE6B7, 0xE697, 0xE697, 0xDE97, 0xDE76, 0xEE94, 0xEE72, 0xDE76, 0xDE76, 0xDE97, 0xD614, 
        0xE673, 0xE695, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xD656, 0xE6B8, 0xE6D9, 0xE6D9, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xDED9, 0xDEB9, 0xDED9, 0xD6B9, 0xCE36, 
        0xC5F5, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xD656, 0xD636, 0xD676, 0xE6F9, 0xEF1A, 0xDEB9, 0x8C90, 0x4A67, 0xD637, 0xEF1B, 0xE71B, 0xEF5C, 0xAD73, 0x4288, 0x532B, 0x73CD, 0xEF1B, 0xE71B, 0xE71B, 0xC637, 0x638C, 
        0xA554, 0xDEB9, 0xDED9, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xCE56, 0xD656, 0xCE35, 0x9C2A, 0xAC29, 0xBC89, 0xCD09, 0xDD6B, 0xE5AB, 0xEE0C, 0xF64D, 0xF64D, 0xF64C, 0xFEF0, 0xFF31, 0xFF11, 0xFF10, 
        0xFF11, 0xFF10, 0xFE8E, 0xD56B, 0xC550, 0xDE77, 0xD676, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xD656, 0xD656, 0xD656, 0xD656, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE56, 0xD656, 0xD656, 0xD656, 0xD656, 0xDE76, 0xDE97, 
        0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6D7, 0xE6D7, 0xE6D8, 0xE6D7, 0xE6D7, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xE6D7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xE697, 0xDE97, 0xDE96, 0xDE96, 0xDE96, 0xDE76, 0xDE96, 0xDE96, 0xDE96, 
        0xDE96, 0xDE96, 0xDE76, 0xD676, 0xD656, 0xD656, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE15, 0xC615, 0xC615, 0xC615, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDD5, 0xBDD4, 0xBDD4, 0xBDD4, 0xB5D4, 0xB5D4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4,
  0xBE16, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC636, 0xC636, 0xD677, 0xD697, 0xD656, 0xC5B2, 0xBD92, 0xAD51, 0xA4F0, 0xBD92, 0xD656, 0xDE97, 0xDE13, 0xAD10, 0x946E, 
        0x9CAF, 0xAD30, 0xDE96, 0xDEB8, 0xDE13, 0xB572, 0x946F, 0x9CD0, 0xA4F0, 0xD656, 0xDEB8, 0xDE34, 0xCDF4, 0x948F, 0x946E, 0x948E, 0xCE14, 0xDEB8, 0xDE76, 0xD614, 0xB573, 0x8C6E, 0xAD31, 0xBDD4, 0xDEB8, 0xDEB8, 0xD697, 0xD698, 0xD6B9, 0xDEB9, 
        0xCE36, 0xCE36, 0xBDF6, 0x9CF2, 0xA532, 0x9D12, 0x7C0E, 0xB5B4, 0xCE15, 0xDDD1, 0xDE97, 0xDEDA, 0xDE14, 0xD614, 0xBE16, 0x844F, 0x9CF1, 0x94D1, 0x842E, 0xBDF5, 0xD5F3, 0xDDF3, 0xDEDA, 0xDE98, 0xD5D2, 0xCE36, 0x9490, 0x844E, 0xB5B4, 0x73AC, 
        0x9CF1, 0xD636, 0xDDB0, 0xDE77, 0xDEDA, 0xCE56, 0xCE57, 0xA532, 0x73AC, 0xC5F6, 0x8C2E, 0x8C6F, 0xCE36, 0xDDD1, 0xDE56, 0xDEFA, 0xDE35, 0xD635, 0xC636, 0x9CF1, 0xCE57, 0xAD74, 0xAD73, 0xCE36, 0xD590, 0xD635, 0xDEFB, 0xCDD3, 0xB572, 0xB5B4, 
        0xAD94, 0xAD53, 0xAD74, 0xAD73, 0xA532, 0xB511, 0xDE99, 0xDEBA, 0xCE37, 0xA552, 0xB594, 0xBDB4, 0xC5F5, 0xC5D4, 0xB5B4, 0xBD72, 0xCDF4, 0xDEFA, 0xDE97, 0xDD8F, 0xC550, 0xBD72, 0xC5B4, 0xBD52, 0xBD72, 0xDDB0, 0xE5D0, 0xDE98, 0xDED9, 0xE612, 
        0xEDCF, 0xDD8F, 0x9C6D, 0xB5B4, 0xC550, 0xE5AF, 0xE54D, 0xCD91, 0xD698, 0xDED9, 0xDE34, 0xE58E, 0xEDAF, 0xDDAF, 0xDDB0, 0xE5D0, 0xE5D0, 0xD590, 0xCE36, 0xCE78, 0xD615, 0xDE13, 0xDE34, 0xDE55, 0xDE56, 0xD656, 0xD677, 0xD657, 0xC616, 0xCE78, 
        0xCE78, 0xC658, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xC678, 0xC658, 0xBE16, 0xC616, 0xCE57, 0xCE57, 0xCE78, 0xCE78, 0xCE98, 0xD699, 0xD698, 0xD699, 0xCE78, 0xCE57, 0xD6B9, 0xCE78, 0xC637, 0xC657, 0xC637, 0xC636, 0xBE16, 0xB5B5, 0xAD52, 0xB5B4, 
        0xB594, 0x948F, 0x94D1, 0x9D12, 0x9D32, 0x9D12, 0x9CF1, 0x94F1, 0x8C90, 0x94D1, 0x9CF1, 0x94D1, 0x8CB0, 0x8C90, 0x94D0, 0x8CD0, 0x8CB0, 0x844E, 0x7C2D, 0x846F, 0x844E, 0x8C6E, 0x8C4D, 0x946D, 0x9C8C, 0xB50B, 0xAC8C, 0xA48E, 0xB5D4, 0xBDD4, 
        0xBD72, 0xCD90, 0xDD6E, 0xDD8F, 0xE5AF, 0xE5AF, 0xDD8F, 0xD615, 0xD6B8, 0xDDB0, 0xE58E, 0xE58E, 0xDD6E, 0xDD6E, 0xDD6E, 0xD52E, 0xC5D4, 0xCE77, 0xD591, 0xD54D, 0xDD4D, 0xD54D, 0xD50D, 0xBC4A, 0xACAD, 0xB5B4, 0xAD93, 0xACCF, 0xB48D, 0xB4AD, 
        0xAC8D, 0xA48D, 0x9C8E, 0x8C4D, 0x848F, 0x84B0, 0x7C8F, 0x7CB0, 0x7C8F, 0x74B0, 0x6CB0, 0x6CAF, 0x5C6E, 0x5C6E, 0x5CAF, 0x5C8E, 0x5C8E, 0x6CAF, 0x8D32, 0xA5B3, 0xC636, 0xD656, 0xDE97, 0xE6B8, 0xE673, 0xE632, 0xDE76, 0xDE76, 0xDE76, 0xD655, 
        0xCE35, 0xD635, 0xDE97, 0xDE97, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xD656, 0xDE98, 0xE6D9, 0xE6D9, 0xE6D9, 0xE6D9, 0xDED9, 0xDED9, 0xDED9, 0xDED9, 0xDED9, 0xDEB9, 0xD698, 0xD678, 0xCE57, 
        0xCE37, 0xC616, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xD636, 0xD656, 0xD656, 0xDE77, 0xE6F9, 0xEF1A, 0xDEB9, 0x8C70, 0x4A88, 0xD637, 0xEF1B, 0xE71B, 0xEF3B, 0xB5B4, 0x4268, 0x3A48, 0x6B8D, 0xE71B, 0xE71B, 0xE6FB, 0xC637, 0x634C, 
        0x9D33, 0xDEB9, 0xDED9, 0xD676, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD677, 0xBD72, 0x9BC8, 0xBC69, 0xC4C9, 0xDD6A, 0xEE0C, 0xF66D, 0xF6AE, 0xF6CF, 0xFEEF, 0xFEF0, 0xFF31, 0xFF31, 0xFF11, 0xF710, 
        0xFF10, 0xFF10, 0xFECE, 0xE5AB, 0xBCED, 0xD656, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xD656, 0xD656, 0xD656, 0xCE56, 0xCE36, 0xCE56, 0xD656, 0xD656, 0xD676, 0xD676, 0xD656, 0xD656, 0xDE76, 0xDE97, 
        0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6D7, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D7, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xE6D7, 0xE6B7, 0xE697, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xE697, 0xE697, 0xDE96, 0xDE96, 0xDE96, 0xDE76, 0xDE96, 0xDE96, 0xDE96, 
        0xDE96, 0xDE96, 0xDE76, 0xDE76, 0xD656, 0xD656, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xC615, 0xC615, 0xC5F5, 0xC5F5, 0xBDF5, 0xBDD4, 0xBDD4, 0xBDD4, 0xBDD4, 0xB5D4, 0xB5D4, 0xB5D4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4,
  0xBE16, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xBE16, 0xBE16, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC636, 0xC636, 0xD677, 0xD697, 0xD677, 0xCDD3, 0xA510, 0x948F, 0x948F, 0xB551, 0xD656, 0xDE97, 0xD613, 0xB552, 0x9CCF, 
        0x948E, 0xAD31, 0xDE96, 0xDEB7, 0xDE13, 0xC5B4, 0x842D, 0x8C2D, 0xA510, 0xDE76, 0xDEB8, 0xDE34, 0xCDF4, 0x9CD0, 0x94AF, 0xB572, 0xCDF4, 0xDEB8, 0xDE76, 0xD614, 0xB573, 0x94AF, 0xAD31, 0xBDD4, 0xDEB8, 0xDE98, 0xD697, 0xD698, 0xD6B9, 0xDEB9, 
        0xCE36, 0xC636, 0xBDF5, 0x9CF1, 0xAD73, 0xA512, 0x8C8F, 0xADB4, 0xD615, 0xDDD1, 0xDE98, 0xDEDA, 0xDE14, 0xCDF4, 0xBE16, 0xAD53, 0xB5B4, 0x9D12, 0x94D1, 0xC636, 0xDDF3, 0xDE13, 0xDEDA, 0xDE98, 0xD5D2, 0xD657, 0xAD52, 0x8C6F, 0xB593, 0x844E, 
        0xA532, 0xD636, 0xDDB0, 0xDE77, 0xDEDA, 0xCE57, 0xCE57, 0xAD32, 0x7BED, 0xBDD5, 0x7BED, 0x8C6F, 0xCE35, 0xDDD1, 0xDE56, 0xDEDA, 0xDE35, 0xDE35, 0xAD73, 0x738C, 0xC5F5, 0x73AC, 0x8C6F, 0xD656, 0xE5D1, 0xDE76, 0xDEFA, 0xDE34, 0xD635, 0xBDF5, 
        0x9CF1, 0xCE77, 0xAD53, 0xB5B4, 0xD635, 0xD591, 0xDEB9, 0xD6BA, 0xCE57, 0xB5B5, 0xB594, 0xAD94, 0xAD73, 0xAD74, 0xA553, 0xA4F1, 0xBDB4, 0xDEFB, 0xD636, 0xA4AF, 0xAD73, 0xB593, 0xC5D5, 0xC5F4, 0xB5B4, 0xB593, 0xC591, 0xDE98, 0xDED9, 0xE5F2, 
        0xCD6F, 0xBD51, 0xBD51, 0xC5D4, 0xB551, 0xCDB2, 0xDD4D, 0xCD91, 0xD698, 0xDEDA, 0xE634, 0xEDAF, 0xD56F, 0xBD51, 0xBD72, 0xD5B0, 0xEDCF, 0xDD8F, 0xD656, 0xDEDA, 0xE5F2, 0xE58E, 0xEDCF, 0xE5AF, 0xDDAF, 0xE5D0, 0xE5D0, 0xDDB0, 0xD614, 0xCE78, 
        0xCE36, 0xDDF3, 0xDE14, 0xDE35, 0xD636, 0xD657, 0xD677, 0xD678, 0xCE36, 0xC657, 0xD699, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xC658, 0xC658, 0xC657, 0xBDF5, 0xC657, 0xC657, 0xCE57, 0xCE78, 0xCE78, 0xCE98, 0xCE98, 0xD698, 0xCE57, 0xD698, 
        0xD6B9, 0xBDD5, 0xC657, 0xCE78, 0xCE77, 0xC657, 0xC636, 0xBE16, 0xB5B4, 0xB5B4, 0xB5B4, 0xA552, 0xA532, 0xA553, 0xA553, 0xA532, 0x9D12, 0x94D0, 0x8C6F, 0x94D1, 0x9CF2, 0x94D1, 0x8C90, 0x8C90, 0xB50E, 0xF68F, 0xA50F, 0x7C2E, 0x8C6F, 0x846F, 
        0x8C8F, 0x8C6E, 0x8C4D, 0x948D, 0x9C8D, 0xA4AD, 0x9C6C, 0x9CF0, 0xADB4, 0xC54F, 0xCD4E, 0xD56E, 0xDD8F, 0xE5AF, 0xE5AF, 0xDD8F, 0xCE35, 0xD6B9, 0xDDF2, 0xE58E, 0xE58F, 0xE58E, 0xDD6E, 0xD52D, 0xCD4F, 0xC636, 0xCE57, 0xD590, 0xDD4D, 0xDD4E, 
        0xDD4D, 0xDD4D, 0xD52D, 0xC4CD, 0xB552, 0xBDB4, 0xB48D, 0xBCAD, 0xBCCD, 0xB4AD, 0xAC8D, 0x9C6D, 0x8C2D, 0x8CD1, 0x84B0, 0x846E, 0x7C6F, 0x746F, 0x6C6F, 0x748F, 0x748F, 0x9532, 0x9D52, 0xB5D5, 0xC5B1, 0xD58F, 0xDE76, 0xDE76, 0xDE76, 0xDEB8, 
        0xDEB9, 0xDE97, 0xDE96, 0xDE96, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xD656, 0xDE77, 0xE6D8, 0xE6F9, 0xE6FA, 0xE6F9, 0xDEB8, 0xDED9, 0xDEB9, 0xDEB8, 0xDEB9, 0xDEDA, 0xDEDA, 0xDEB9, 0xD698, 0xCE78, 
        0xD678, 0xCE57, 0xD656, 0xCE36, 0xCE35, 0xCE35, 0xCE36, 0xCE36, 0xD636, 0xD656, 0xD656, 0xDE76, 0xE6D9, 0xE71A, 0xD698, 0x73CE, 0x4AA9, 0xD657, 0xEF3B, 0xEF1B, 0xEF3B, 0xBDD5, 0x4AA9, 0x4248, 0x73CE, 0xE71B, 0xE71B, 0xE71B, 0xC616, 0x4AA9, 
        0x8C91, 0xDEB9, 0xDEB9, 0xD676, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xACAD, 0xA3C7, 0xCCC9, 0xE56A, 0xF68D, 0xFF30, 0xFF71, 0xFF72, 0xFF72, 0xFF51, 0xFF10, 0xFF31, 0xFF32, 0xFF32, 0xFF11, 
        0xFF52, 0xFF51, 0xFEEE, 0xEE0C, 0xB46A, 0xCDF4, 0xDE77, 0xDE76, 0xDE76, 0xDE76, 0xDE96, 0xDE96, 0xDE76, 0xDE96, 0xDE97, 0xDE77, 0xDE76, 0xDE76, 0xDE76, 0xDE77, 0xDE76, 0xD676, 0xD676, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xD676, 0xDE97, 0xE697, 
        0xE6B7, 0xDE97, 0xD634, 0xCDD3, 0xEED8, 0xE6D8, 0xE6D8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED7, 0xE6B7, 0xE697, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xE697, 0xE697, 0xDE96, 0xDE96, 0xDE96, 0xDE96, 0xDE96, 0xDE96, 0xDE96, 
        0xDE96, 0xDE76, 0xDE76, 0xDE76, 0xD656, 0xD656, 0xCE36, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE15, 0xC615, 0xC615, 0xC615, 0xBDF5, 0xBDD5, 0xBDD4, 0xBDD4, 0xBDD4, 0xB5D4, 0xB5D4, 0xB5B4, 0xB5D4, 0xB5D4, 0xB5B4, 0xB5B4, 0xB5B4,
  0xBE16, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xC616, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xC616, 0xC616, 0xC616, 0xC616, 0xC636, 0xC636, 0xD697, 0xD697, 0xD656, 0xC5B2, 0xA511, 0x9CD0, 0x8C6E, 0xB552, 0xD656, 0xDE97, 0xD5F3, 0xB593, 0x94AF, 
        0x946E, 0xB551, 0xDE97, 0xDE97, 0xDE13, 0xC5D4, 0x946E, 0x9CAF, 0xBD92, 0xDE56, 0xDEB8, 0xDE14, 0xC5D3, 0x9CF1, 0x94AF, 0xAD51, 0xCDF4, 0xDEB8, 0xDE76, 0xD5F3, 0xB593, 0x8C4E, 0xAD51, 0xBDB3, 0xDEB8, 0xDEB8, 0xD697, 0xD698, 0xD6B9, 0xDEB9, 
        0xCE16, 0xCE36, 0xC615, 0xB552, 0xB594, 0xAD52, 0x840D, 0xB5B4, 0xCE14, 0xDDF1, 0xDE98, 0xD6BA, 0xDE14, 0xCDF4, 0xBDF5, 0xA532, 0xAD73, 0x9CD1, 0x94D1, 0xBE16, 0xDDF3, 0xDDF3, 0xD6DA, 0xDE98, 0xDDF2, 0xD657, 0xC615, 0xB5B4, 0xBDF5, 0x9CD0, 
        0xB594, 0xD635, 0xDDB0, 0xDE77, 0xDEDA, 0xD656, 0xCE77, 0xB594, 0x842E, 0xAD73, 0x8C6F, 0x94F1, 0xCE56, 0xDDD1, 0xDE76, 0xDEDA, 0xDE34, 0xD615, 0xAD73, 0x7BED, 0xBDD5, 0x73CD, 0x844F, 0xCE36, 0xDDD1, 0xDE76, 0xDEFA, 0xDE34, 0xDE55, 0xA512, 
        0x738C, 0xBDD5, 0x6B6B, 0x9CF1, 0xDE56, 0xE5F2, 0xDEB9, 0xDEB9, 0xCE77, 0xCE77, 0xAD93, 0xAD73, 0xCE57, 0xA532, 0xC636, 0xCDD2, 0xDE13, 0xDEFA, 0xDE56, 0xBD71, 0xB5D4, 0xB5B4, 0xAD73, 0xA553, 0xA532, 0x9CF1, 0xACF0, 0xD678, 0xE6FA, 0xBD50, 
        0x9CD0, 0xB594, 0xC5F5, 0xCE36, 0xBDD4, 0xB594, 0xBD50, 0xBD71, 0xD698, 0xDEFA, 0xE654, 0xC52F, 0xBDB3, 0xC656, 0xBE16, 0xBDB3, 0xD5B0, 0xDD8F, 0xD656, 0xDEDA, 0xE612, 0xEDCF, 0xDD8F, 0xB52F, 0xBD72, 0xD590, 0xEDCF, 0xE5AF, 0xDE14, 0xDEDA, 
        0xDE56, 0xE5AF, 0xEDAF, 0xEDCF, 0xE5AF, 0xE5B0, 0xE5D0, 0xE5D0, 0xDDB1, 0xCE56, 0xC657, 0xD614, 0xDE13, 0xDE35, 0xDE56, 0xDE77, 0xDE98, 0xD698, 0xD678, 0xC636, 0xCE78, 0xCE57, 0xCE78, 0xCE99, 0xCE99, 0xCE99, 0xCE78, 0xC657, 0xBDF5, 0xC616, 
        0xC616, 0xBE16, 0xC657, 0xCE78, 0xD698, 0xD698, 0xD6B9, 0xD6B9, 0xD698, 0xD698, 0xD6B9, 0xD698, 0xCE98, 0xCE98, 0xCE78, 0xCE57, 0xC657, 0xBE16, 0xB5B4, 0xB5D5, 0xAD73, 0xA532, 0x9D32, 0xA532, 0xD5AF, 0xF66E, 0xC590, 0x8C70, 0x94B0, 0x94D1, 
        0x94F1, 0x8C90, 0x8C90, 0x8C90, 0x94F1, 0x9D32, 0x8CB0, 0x8C8F, 0x8CB0, 0x846F, 0x844E, 0x840C, 0x842C, 0x8C0C, 0x8C4C, 0x946D, 0x9D11, 0xADB4, 0xBD71, 0xD56E, 0xDD8F, 0xE5AF, 0xE5AF, 0xDD6E, 0xD591, 0xCE77, 0xD698, 0xDDF2, 0xE58E, 0xE58F, 
        0xE58F, 0xDD8E, 0xE56E, 0xDD4E, 0xCE15, 0xD677, 0xD56F, 0xDD6E, 0xDD6E, 0xDD6E, 0xDD4E, 0xD52D, 0xBCEE, 0xC5F5, 0xBD93, 0xB48D, 0xBCAC, 0xBCCD, 0xBCAD, 0x9C2B, 0x8C0C, 0x94D1, 0x73ED, 0x7C90, 0x9CAF, 0xE651, 0xE696, 0xDE76, 0xDE56, 0xDE77, 
        0xD677, 0xD676, 0xDE96, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xD656, 0xDE96, 0xBDD3, 0xAD92, 0xBE15, 0xD677, 0xC635, 0xB593, 0xBDD4, 0xC636, 0xC636, 0xC636, 0xCE57, 0xC657, 0xB5F5, 0x94F0, 0xAD93, 
        0xB5D4, 0xA552, 0xBDD4, 0xD656, 0xCE36, 0xCE36, 0xCE56, 0xCE56, 0xD636, 0xD656, 0xD656, 0xDE76, 0xEF1A, 0xEF3B, 0xD698, 0x52C9, 0x4A47, 0xD637, 0xE6DA, 0xDEDA, 0xE6FA, 0xB595, 0x4227, 0x3A07, 0x6B4C, 0xDEB9, 0xDEBA, 0xD6B9, 0xC5F7, 0x4289, 
        0x7BEE, 0xDEFA, 0xDED9, 0xD677, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD636, 0xB48B, 0xBC67, 0xEDCA, 0xF6CC, 0xFFB1, 0xFFD2, 0xFF2F, 0xFEEE, 0xFF0F, 0xF6AE, 0xF68E, 0xEE4D, 0xEE6E, 0xF6AF, 0xFEF0, 
        0xF6CE, 0xF68D, 0xEE2C, 0xEDEC, 0xB469, 0xCDB2, 0xDE97, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE96, 0xDE96, 0xDE97, 0xDE97, 0xDE97, 0xDE96, 0xDE96, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE77, 0xDE97, 0xDE76, 0xDE76, 0xDE76, 0xDE97, 0xE6B7, 0xE6B7, 
        0xE6D8, 0xD615, 0x7308, 0x93AA, 0xCDF4, 0xEEF8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xDE96, 0xDE96, 0xDE96, 0xDE76, 0xDE96, 0xDE97, 0xDEB7, 0xDE96, 0xDE96, 0xDE96, 
        0xDE96, 0xDE76, 0xDE76, 0xDE56, 0xD656, 0xD656, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE15, 0xC615, 0xC615, 0xBDF5, 0xBDF5, 0xBDD5, 0xBDD4, 0xBDF5, 0xBDD5, 0xBDD4, 0xB5B4, 0xB5D4, 0xB5D4, 0xB5B4, 0xB5B4, 0xB5B4,
  0xBE16, 0xC616, 0xC636, 0xC616, 0xC616, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xC616, 0xC616, 0xC636, 0xC636, 0xC636, 0xD697, 0xD697, 0xD657, 0xC5B3, 0xAD52, 0x946E, 0x944E, 0xBD92, 0xDE76, 0xDE77, 0xD5F3, 0xBDB4, 0x9CF0, 
        0xA511, 0xBDB3, 0xDE76, 0xDE97, 0xDE13, 0xBDB3, 0x9CB0, 0x9CF0, 0xBD92, 0xD656, 0xDEB8, 0xDE34, 0xC5D4, 0x94D0, 0x8C6E, 0xB572, 0xCDF4, 0xDEB8, 0xDE56, 0xD613, 0xB593, 0x946E, 0xAD52, 0xBDD3, 0xDE98, 0xDEB8, 0xD697, 0xD698, 0xD6B9, 0xD6B9, 
        0xCE36, 0xCE37, 0xC5F5, 0xB573, 0xBDB4, 0xB593, 0x8C6F, 0xB5B4, 0xCE14, 0xDDF1, 0xDE98, 0xDEDA, 0xDE14, 0xCDF4, 0xCE56, 0xC5D4, 0xC615, 0xA511, 0x8C6F, 0xC636, 0xDDF3, 0xDE13, 0xDEDA, 0xDE97, 0xDDF2, 0xCE56, 0xB573, 0xB573, 0xAD73, 0x9CD0, 
        0xB594, 0xD635, 0xDDB0, 0xDE77, 0xDED9, 0xD656, 0xCE57, 0xC615, 0xAD73, 0xBDF5, 0x9CD1, 0xA552, 0xD656, 0xDDD1, 0xDE76, 0xDEFA, 0xDE34, 0xD635, 0xBDD5, 0x840D, 0xA532, 0x7BEE, 0x9490, 0xCE56, 0xDDD1, 0xDE76, 0xDEFA, 0xDE34, 0xD635, 0xA512, 
        0x7BED, 0xB5B4, 0x6B6B, 0x94D1, 0xD635, 0xDDF2, 0xDEB9, 0xDEB9, 0xCE57, 0xCE57, 0x844E, 0x94D0, 0xB5B4, 0x7BED, 0xC616, 0xDE13, 0xDE34, 0xDEDA, 0xDE76, 0xDE13, 0xC636, 0x9CF1, 0xCE57, 0xB5B4, 0xB5D4, 0xCE15, 0xD570, 0xDE98, 0xDED9, 0xCD71, 
        0xB552, 0xAD73, 0xA553, 0xAD53, 0xAD94, 0xA533, 0xA4D0, 0xB572, 0xD698, 0xE6FA, 0xC5D3, 0xA511, 0xBDF6, 0xC637, 0xCE57, 0xBDF6, 0xBD93, 0xCD71, 0xD656, 0xDEDA, 0xE612, 0xCD4E, 0xB550, 0xBDF5, 0xB5D5, 0xB593, 0xD5B0, 0xE5AF, 0xDE35, 0xDEDA, 
        0xDE56, 0xEDCF, 0xEDCF, 0xD56F, 0xBD50, 0xCD91, 0xE5CF, 0xEDCF, 0xDDB0, 0xD697, 0xD6B9, 0xE612, 0xE5AE, 0xEDCF, 0xE5AF, 0xE5B0, 0xE5D0, 0xE5F1, 0xDDD1, 0xD615, 0xCE98, 0xCE36, 0xD5F4, 0xD635, 0xD656, 0xD677, 0xD698, 0xD698, 0xC636, 0xCE78, 
        0xCE78, 0xC616, 0xC658, 0xC678, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xC637, 0xC636, 0xCE57, 0xCE57, 0xCE78, 0xCE98, 0xD698, 0xD698, 0xD698, 0xD698, 0xCE77, 0xD698, 0xD698, 0xCE98, 0xCE98, 0xBDF5, 0x6B49, 0x6B28, 0x9CAF, 0xB5B4, 0xB5B4, 0xB5B4, 
        0xA552, 0xA532, 0xA532, 0x9D12, 0x9CF2, 0x9CF1, 0x8C8F, 0x94B0, 0x9D12, 0x9CF1, 0x94B0, 0x94B1, 0x94D0, 0x8CB0, 0x8CB0, 0x844E, 0x844E, 0x846F, 0x846E, 0x8C6E, 0x8C2D, 0x946D, 0x9C8D, 0x9C8D, 0x948E, 0xA532, 0xAD94, 0xBD50, 0xC52E, 0xD54E, 
        0xD56E, 0xDD8F, 0xE5AF, 0xDD8F, 0xD636, 0xDEB8, 0xDDB0, 0xE5AF, 0xE5AF, 0xE58F, 0xE58E, 0xE58E, 0xCD70, 0xD677, 0xD656, 0xD56E, 0xDD4E, 0xDD6E, 0xDD4D, 0xCCCC, 0xB4AD, 0xB593, 0xAD73, 0xBDD4, 0xCD6E, 0xF68F, 0xDE54, 0xDE97, 0xCDF4, 0x842D, 
        0x6BCC, 0x840D, 0xD635, 0xDE97, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xDE76, 0xC5F4, 0x94CE, 0x94CE, 0xAD51, 0xAD51, 0xAD52, 0xB592, 0xCE36, 0xBDF5, 0xC616, 0xC636, 0xBDD5, 0xC616, 0xAD52, 0xAD52, 0x8C8E, 
        0x844D, 0x73EB, 0x6BEB, 0xB593, 0xD656, 0xD656, 0xD636, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xC5D5, 0xBDB5, 0xAD53, 0x7BAC, 0x8C2E, 0xBD94, 0xBDB4, 0xB574, 0xB574, 0xA533, 0x9490, 0x844F, 0x94B1, 0xAD74, 0xAD54, 0xAD53, 0xA533, 0x73CD, 
        0x73CE, 0xAD52, 0xCD91, 0xCDF4, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD655, 0xCD4D, 0xD4C8, 0xEE4B, 0xFF4E, 0xFF6F, 0xEE8C, 0xDD47, 0xCCE8, 0xAC47, 0xC4E8, 0xCD49, 0xA448, 0xACA9, 0xAC68, 0xBCE9, 
        0xCD49, 0xCD09, 0xBC87, 0xB447, 0xBCCA, 0xDE74, 0xDE96, 0xDE76, 0xDE96, 0xDE76, 0xDE77, 0xDE97, 0xDE97, 0xDE96, 0xDE54, 0xDE33, 0xDE96, 0xDE96, 0xDE96, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE96, 0xDE96, 0xDE96, 0xDE97, 0xDE97, 0xE6B7, 0xE6B7, 
        0xE6B8, 0xEED8, 0x9C0B, 0x8329, 0xE696, 0xEEF8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xDE96, 0xDE96, 0xDE96, 0xDE76, 0xDE96, 0xDE96, 0xDE96, 0xDE96, 0xDE96, 0xDE76, 
        0xDE76, 0xDE76, 0xDE76, 0xDE56, 0xD656, 0xD656, 0xD635, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE15, 0xCE15, 0xC615, 0xC615, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDD4, 0xB5D4, 0xB5D4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4,
  0xBE16, 0xC616, 0xC636, 0xC636, 0xC636, 0xC616, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xC616, 0xC636, 0xC636, 0xC636, 0xD697, 0xD697, 0xD657, 0xC5B3, 0xB572, 0x9CD0, 0xA511, 0xC5B3, 0xD676, 0xDE77, 0xD5F3, 0xB593, 0x9CD0, 
        0xA4F0, 0xBD92, 0xDE76, 0xDE97, 0xDDF3, 0xBDB3, 0x8C6F, 0x9CAF, 0xB592, 0xD656, 0xDEB8, 0xDE14, 0xCDF4, 0x9CF1, 0x94AF, 0xB592, 0xCE14, 0xDEB8, 0xDE56, 0xD614, 0xB593, 0x8C6E, 0xAD51, 0xBDD3, 0xDEB8, 0xDE98, 0xD698, 0xD6B9, 0xD6B9, 0xD6B9, 
        0xCE36, 0xCE36, 0xBDD5, 0xAD12, 0xB573, 0xA532, 0x8C6F, 0xB5D5, 0xD614, 0xDDD1, 0xDE98, 0xD6DA, 0xDE13, 0xCDF4, 0xCE56, 0xBDB4, 0xCE56, 0xBD93, 0x9CD1, 0xC636, 0xDDF2, 0xDE13, 0xDEDA, 0xDE97, 0xDDF2, 0xCE36, 0xC5F5, 0xBDD4, 0xC5D4, 0x8C6F, 
        0xAD94, 0xD635, 0xDDD1, 0xDE97, 0xDEB9, 0xD656, 0xCE77, 0xB5B4, 0xAD53, 0xB594, 0x9CF1, 0xA553, 0xD656, 0xDDD1, 0xDE77, 0xDEDA, 0xDE34, 0xD635, 0xC616, 0xAD73, 0xB5B4, 0x8C6F, 0xA532, 0xD656, 0xDDD1, 0xDE76, 0xDEDA, 0xDE34, 0xD656, 0xB594, 
        0x842E, 0xAD53, 0x7BED, 0xA532, 0xD655, 0xDDF2, 0xDEB9, 0xDEB9, 0xCE57, 0xC637, 0x842E, 0x94B0, 0xA532, 0x7BED, 0xB5B5, 0xDE14, 0xDE35, 0xDEFA, 0xDE76, 0xDE34, 0xAD53, 0x6B8B, 0xBDF5, 0x8C4E, 0xA512, 0xD656, 0xE5F1, 0xDEB8, 0xDED9, 0xE5F2, 
        0xDE56, 0xAD73, 0xB594, 0xCE57, 0xAD73, 0xC636, 0xBD2F, 0xC571, 0xD699, 0xE6FA, 0xC5F5, 0xAD73, 0xAD74, 0xAD73, 0xB594, 0xAD74, 0xA532, 0xACD0, 0xCE16, 0xE6FA, 0xBD51, 0x9CF0, 0xB5D5, 0xC636, 0xC636, 0xBDF6, 0xB593, 0xCD70, 0xD615, 0xDEDA, 
        0xDE76, 0xE5AF, 0xC54F, 0xB592, 0xBE16, 0xB5B4, 0xC5B2, 0xE5AF, 0xE5B0, 0xD698, 0xDEDA, 0xE612, 0xEDCF, 0xDD8F, 0xBD2F, 0xBD71, 0xDDB0, 0xEDCF, 0xE5AF, 0xDE35, 0xDEDA, 0xDE14, 0xE58E, 0xEDAF, 0xE5AF, 0xE5B0, 0xE5D0, 0xDDB0, 0xD5B2, 0xD678, 
        0xCE77, 0xCE15, 0xD635, 0xDE35, 0xDE56, 0xD656, 0xD657, 0xD677, 0xCE56, 0xCE77, 0xD698, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xC657, 0xBE16, 0xC637, 0xC657, 0xCE57, 0xCE98, 0x844F, 0x5288, 0x4A67, 0x736B, 0xB5B4, 0xD6B9, 0xD698, 
        0xC616, 0xD698, 0xD698, 0xCE78, 0xCE57, 0xC637, 0xBDF5, 0xB5D5, 0xBDF5, 0xAD73, 0xA553, 0xAD73, 0xA553, 0xA553, 0xA532, 0x94B0, 0x8C90, 0x94D1, 0x94D1, 0x94B0, 0x8CB0, 0x8CB0, 0x8CB0, 0x8C90, 0x7C2E, 0x7C2E, 0x8C90, 0x8C8F, 0x846E, 0x7C0D, 
        0x844D, 0x946D, 0x9C8E, 0x946D, 0x94F0, 0xA552, 0xA4CE, 0xB4ED, 0xC52E, 0xCD6E, 0xD58F, 0xDD8F, 0xD5B1, 0xD698, 0xDE97, 0xE5CF, 0xE5AF, 0xE5AF, 0xE58F, 0xDD4D, 0xCD2E, 0xC615, 0xC657, 0xD698, 0xE60F, 0xF66E, 0xDDD1, 0xE697, 0xC5D4, 0x848E, 
        0x7C8E, 0x846E, 0xD636, 0xDE97, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xDE97, 0xB571, 0xBD92, 0xCE15, 0xDE97, 0xC615, 0xDE97, 0xD677, 0xDEB8, 0xCE36, 0xD698, 0xCE56, 0xCE36, 0xCE57, 0xCE36, 0xD656, 0xAD32, 
        0xAD52, 0xA531, 0x8C8E, 0xC5D4, 0xD656, 0xD656, 0xD636, 0xD636, 0xD656, 0xD656, 0xCE15, 0xC5D4, 0xCE35, 0xCE36, 0xD636, 0xDE76, 0xE6D8, 0xDEB8, 0xDEB8, 0xDED9, 0xDEB9, 0xDED9, 0xDED9, 0xDEB8, 0xDED9, 0xDED9, 0xD6B9, 0xCE78, 0xC636, 0xC657, 
        0xB5D5, 0xB572, 0xD5B0, 0xC592, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD676, 0xBCED, 0xA3C6, 0xB406, 0xC487, 0xBC66, 0x9BA5, 0x8B44, 0x7B04, 0x72C4, 0xA3C6, 0xC4E9, 0x5A63, 0x4A24, 0x4A24, 0x4A03, 
        0x5A64, 0x6284, 0x6AC5, 0x5A44, 0x8BA8, 0xE695, 0xDE97, 0xDE96, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xE697, 0xDE56, 0xDE12, 0xDE33, 0xDE76, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE96, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xE6B7, 0xE6B7, 
        0xE6B8, 0xE6B7, 0xD5D2, 0xB530, 0xE697, 0xEEF8, 0xEEF8, 0xEEF8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 0xDE96, 0xDE96, 0xDE96, 0xDE96, 0xDE96, 0xDE76, 
        0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xD656, 0xD655, 0xD635, 0xD635, 0xD635, 0xCE35, 0xCE55, 0xCE35, 0xCE35, 0xCE15, 0xC615, 0xC5F5, 0xC5F5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDD4, 0xB5D4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5D4,
  0xBE16, 0xC616, 0xC636, 0xC636, 0xC636, 0xC636, 0xC616, 0xBE16, 0xC616, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xC616, 0xC616, 0xC616, 0xC636, 0xD697, 0xD697, 0xD677, 0xC5B3, 0xB572, 0x94AF, 0x9CD0, 0xBDB2, 0xD676, 0xDE76, 0xD5F3, 0xBDB4, 0x94AF, 
        0xA510, 0xBD92, 0xD676, 0xDE97, 0xDDF3, 0xBDB4, 0x948F, 0x9CD0, 0xB592, 0xD656, 0xDEB8, 0xDE14, 0xC5D4, 0x9CF1, 0x94AF, 0xB572, 0xCDF4, 0xDEB8, 0xDE56, 0xD614, 0xB594, 0x948F, 0xB572, 0xC5F4, 0xD697, 0xD677, 0xCE57, 0xCE78, 0xCE98, 0xD678, 
        0xC616, 0xCE57, 0xC616, 0xAD53, 0xB5B4, 0xAD53, 0x8C6F, 0xB5F5, 0xD615, 0xDDD1, 0xDEB8, 0xDEBA, 0xDE13, 0xCDF4, 0xC616, 0xB573, 0xC5F5, 0xA4F1, 0x94B0, 0xC636, 0xDDF2, 0xDE14, 0xDEDA, 0xDE97, 0xDDF2, 0xCE36, 0xC5F5, 0xC5F5, 0xCE36, 0x94D0, 
        0xADB4, 0xD615, 0xDDD0, 0xDE97, 0xD6B9, 0xCE56, 0xCE57, 0xBDD5, 0xAD73, 0xB5D5, 0x844F, 0xA553, 0xD636, 0xDDD1, 0xDE97, 0xDEDA, 0xDE34, 0xD635, 0xBDD5, 0xA532, 0xB593, 0x9490, 0xA532, 0xD656, 0xDDD1, 0xDE77, 0xDEDA, 0xDE34, 0xD635, 0xBDF6, 
        0xAD73, 0xBDD5, 0x8C6F, 0xB5B4, 0xDE55, 0xDDF2, 0xDED9, 0xDEB9, 0xCE57, 0xCE77, 0xA4F1, 0x94B0, 0xA511, 0x846F, 0xBDF6, 0xDE14, 0xDE35, 0xDEFA, 0xDE76, 0xDE14, 0xA553, 0x73CD, 0xB594, 0x840D, 0x9D11, 0xD656, 0xDDF2, 0xDEB8, 0xDED9, 0xE5F2, 
        0xD636, 0x842E, 0x9490, 0xBDD5, 0x7BED, 0xC616, 0xD591, 0xD5B2, 0xD699, 0xDEFA, 0xD656, 0xCE36, 0xA532, 0xC616, 0xBDF5, 0xAD93, 0xCE35, 0xCD50, 0xD656, 0xDEFA, 0xC592, 0xB573, 0xAD94, 0xAD73, 0xAD73, 0xAD73, 0xA552, 0xB510, 0xCE15, 0xDEFB, 
        0xD635, 0xAC8D, 0xAD53, 0xB5D5, 0xC616, 0xC616, 0xB5B5, 0xBD92, 0xD5B1, 0xDE98, 0xDEDA, 0xE613, 0xCD4F, 0xB571, 0xBDF5, 0xBDF5, 0xBDB3, 0xDDB0, 0xE5AF, 0xDE35, 0xDEDA, 0xE633, 0xEDAF, 0xDD8F, 0xC570, 0xBD72, 0xDDB0, 0xEDAE, 0xDDD1, 0xDEB8, 
        0xD698, 0xD614, 0xE5B0, 0xE5AF, 0xC52F, 0xCD70, 0xE5D0, 0xE5D0, 0xDDB1, 0xD677, 0xD678, 0xDDF3, 0xDE13, 0xDE34, 0xDE35, 0xD635, 0xD656, 0xD656, 0xCE16, 0xCE78, 0xCE78, 0xD698, 0xC616, 0x52C8, 0x4A67, 0x4227, 0x5AE9, 0x738C, 0xCE57, 0xC657, 
        0xC636, 0xC657, 0xCE57, 0xCE57, 0xCE78, 0xCE78, 0xCE78, 0xCE57, 0xD698, 0xCE98, 0xCE98, 0xD698, 0xD698, 0xCE78, 0xCE77, 0xC636, 0xBDF5, 0xC616, 0xB5D5, 0xB594, 0xAD94, 0xAD73, 0xAD53, 0xA533, 0x9CF1, 0xA512, 0x94D1, 0x94B0, 0x8CB0, 0x94D1, 
        0x9CF2, 0x94D1, 0x94B1, 0x844F, 0x844F, 0x8C90, 0x8CB0, 0x8C8F, 0x842E, 0x8C4E, 0x8C4D, 0x946D, 0x8C6D, 0x9511, 0x94F1, 0xA4AE, 0xB4CD, 0xBD0E, 0xC54E, 0xCD2E, 0xC50E, 0xC615, 0xC636, 0xD698, 0xEE71, 0xFEAF, 0xF62F, 0xDE12, 0xAD92, 0x84EF, 
        0x8510, 0x84CF, 0xB5B3, 0xE697, 0xDE76, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xD676, 0xD635, 0xD676, 0xDE97, 0xE6D9, 0xDE97, 0xDEB8, 0xDEB8, 0xDEB8, 0xD677, 0xDED9, 0xD677, 0xDEB8, 0xD677, 0xD677, 0xCE57, 0xB593, 
        0xBDD4, 0xBDB4, 0xC5D5, 0xD656, 0xD656, 0xD636, 0xD636, 0xCE36, 0xCE36, 0xCE56, 0xCE15, 0xCDF4, 0xDEB8, 0xE6D9, 0xE6D9, 0xE6F9, 0xE6F9, 0xE6FA, 0xE6FA, 0xE6FA, 0xE71B, 0xDEFA, 0xE6FB, 0xE6FB, 0xE71B, 0xE6FB, 0xE71B, 0xDEDA, 0xD6B9, 0xD6B9, 
        0xD699, 0xD678, 0xDE75, 0xD635, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xDE76, 0xBD2F, 0x9366, 0xA3C6, 0xABE6, 0x8B65, 0x6AC4, 0x62A4, 0x6284, 0x72C3, 0x9BA6, 0xB448, 0x72E4, 0x5223, 0x41E3, 0x41C3, 
        0x6285, 0x72E5, 0x5224, 0x39A3, 0x7348, 0xDE96, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xE6B7, 0xDE96, 0xE675, 0xE675, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE96, 0xDE97, 0xDE97, 0xDE97, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 
        0xE6B8, 0xE6B7, 0xEED6, 0xEED6, 0xEED8, 0xEEF8, 0xEEF8, 0xEEF8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED7, 0xEED7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xE696, 0xDE96, 0xDE96, 0xDE96, 0xDE96, 0xDE96, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 
        0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xD656, 0xD655, 0xD635, 0xD635, 0xD635, 0xD635, 0xD635, 0xCE35, 0xCE35, 0xCE15, 0xC615, 0xC5F5, 0xC5F5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDD5, 0xB5D4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5D4,
  0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC636, 0xC616, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xBE16, 0xC616, 0xC616, 0xC616, 0xC636, 0xD697, 0xD697, 0xD676, 0xC5B3, 0xB573, 0x94B0, 0xA511, 0xBDB2, 0xD676, 0xDE77, 0xD5F3, 0xBDD4, 0x94B0, 
        0xA510, 0xBD93, 0xD677, 0xDE97, 0xD614, 0xBDB4, 0x8C6E, 0x9CD0, 0xB592, 0xD676, 0xDEB8, 0xDE14, 0xC5F4, 0x9CF1, 0x9CF0, 0xB592, 0xCDF4, 0xD697, 0xCDF4, 0xCDD3, 0xAD53, 0x840D, 0x8C2D, 0xA511, 0xBDD4, 0xBDD4, 0xA552, 0x9D52, 0xAD74, 0xAD73, 
        0xA532, 0xB5B5, 0xA533, 0x842E, 0x9490, 0x94D1, 0x842F, 0xB5B4, 0xD615, 0xD5B1, 0xDE98, 0xD6B9, 0xDE13, 0xD615, 0xC5F5, 0xB552, 0xCE15, 0x9C8F, 0x8C8F, 0xC636, 0xDDF2, 0xDE14, 0xDEDA, 0xDE97, 0xDDF2, 0xCE36, 0xB593, 0xBDB4, 0xC5D4, 0x948F, 
        0xB5B4, 0xD615, 0xDDB0, 0xDE97, 0xD6B9, 0xD657, 0xCE57, 0xBDF5, 0xB5B4, 0xC616, 0x8C90, 0xAD74, 0xD636, 0xDDD1, 0xDE97, 0xDEDA, 0xDE34, 0xD635, 0xBDF6, 0xAD53, 0xC615, 0x7C0D, 0xA512, 0xD656, 0xDDD1, 0xDE77, 0xDEDA, 0xDE34, 0xD635, 0xB594, 
        0xA512, 0xAD53, 0x9490, 0xAD74, 0xD655, 0xDDF2, 0xDED9, 0xDEB9, 0xCE77, 0xCE57, 0xBDD5, 0xBDD5, 0xB573, 0x9CF1, 0xC636, 0xDE14, 0xDE35, 0xDEDA, 0xDE76, 0xDE34, 0xAD94, 0x7C2E, 0xA532, 0x844F, 0xAD53, 0xD677, 0xDDD2, 0xDEB8, 0xDED9, 0xDDB2, 
        0xCE15, 0x8C4F, 0x8C90, 0xB573, 0x7BED, 0xBDF5, 0xD591, 0xCD92, 0xD699, 0xDEFA, 0xDE56, 0xC5F5, 0x73AC, 0xB5B4, 0x9CD0, 0x8C6F, 0xD676, 0xDDD1, 0xDE77, 0xDED9, 0xDE14, 0xD677, 0xAD53, 0xB5B4, 0xBDF5, 0x9D11, 0xCE36, 0xDD91, 0xD635, 0xDEFA, 
        0xDE35, 0xBD30, 0xAD73, 0xAD94, 0xAD53, 0xA553, 0x9D12, 0xA4D1, 0xBD30, 0xDE98, 0xDEFA, 0xBD30, 0xA4F0, 0xBE16, 0xC637, 0xCE57, 0xBDF6, 0xBDB3, 0xD590, 0xDE35, 0xDEDA, 0xE634, 0xD54F, 0xBD92, 0xC636, 0xBDF5, 0xBDD3, 0xDDAF, 0xDDD1, 0xDEB8, 
        0xDEB8, 0xD613, 0xEDF0, 0xD54E, 0xAD31, 0xBD93, 0xDD8F, 0xEDCF, 0xE5D0, 0xDEB8, 0xDEB8, 0xE5D0, 0xEDCF, 0xD54E, 0xB50F, 0xCD70, 0xEDCF, 0xE5AF, 0xDDF3, 0xD698, 0xD614, 0xE5F2, 0xA4AF, 0x4A67, 0x4A88, 0x39E6, 0x62E9, 0x4A88, 0xBDF6, 0xD699, 
        0xCE57, 0xCE78, 0xCE78, 0xCE78, 0xCE99, 0xCE98, 0xC657, 0xC636, 0xCE77, 0xBE16, 0xBE16, 0xC616, 0xC637, 0xCE57, 0xCE77, 0xCE57, 0xCE57, 0xD699, 0xD698, 0xD698, 0xD6B9, 0xD6B9, 0xD699, 0xCE78, 0xB5B4, 0xC616, 0xC657, 0xBDF6, 0xBDF6, 0xB5F5, 
        0xADB4, 0xAD73, 0xA532, 0x9CF1, 0x94D1, 0x9CF2, 0x94B0, 0x94B0, 0x9CD1, 0x9CF1, 0x94D1, 0x8CB0, 0x7C0D, 0x842E, 0x94B0, 0x9D12, 0x8CB0, 0x844E, 0x846E, 0x844E, 0x7C0D, 0x7C0D, 0x7C0D, 0x846F, 0x946C, 0xAC8C, 0xCD2C, 0xE58E, 0xB50E, 0x84CF, 
        0x8CEF, 0x94EE, 0x94D0, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xD656, 0xD656, 0xDE56, 0xDEB8, 0xDE97, 0xE6D9, 0xDEB8, 0xDED8, 0xDEB8, 0xDEB9, 0xD698, 0xDED9, 0xD698, 0xDED9, 0xD698, 0xDEB8, 0xD677, 0xBDD4, 
        0xC5F5, 0xBDD4, 0xC5F5, 0xD656, 0xD636, 0xD636, 0xD636, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xD656, 0xE6D9, 0xE6D9, 0xDEB8, 0xDEB8, 0xDEB8, 0xE6D9, 0xEF1A, 0xE71B, 0xE71B, 0xD6B9, 0xD6BA, 0xDEDA, 0xDED9, 0xDEDA, 0xE73B, 0xE71B, 0xD6B9, 0xC658, 
        0xCE58, 0xD678, 0xE676, 0xD655, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xDE76, 0xD614, 0x8B87, 0x8B25, 0x9B44, 0xAB84, 0xB3E3, 0xB404, 0xBC04, 0xC444, 0xBC26, 0xB428, 0xBC25, 0x9363, 0x82E3, 0x6A82, 
        0x9365, 0x9365, 0x41C3, 0x3162, 0x942C, 0xE6D7, 0xDE97, 0xDE97, 0xE6B7, 0xE6B7, 0xDE97, 0xDE97, 0xE6B7, 0xDE97, 0xE675, 0xE675, 0xDE97, 0xE697, 0xE697, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xE697, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 
        0xE6D7, 0xE6B7, 0xE674, 0xEED5, 0xE6D8, 0xEEF8, 0xEEF8, 0xEEF8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED7, 0xE6D7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xE696, 0xE696, 0xDE96, 0xDE96, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 
        0xDE76, 0xDE76, 0xDE76, 0xDE56, 0xD655, 0xD655, 0xD635, 0xD635, 0xD635, 0xD635, 0xD635, 0xCE35, 0xCE35, 0xC615, 0xC615, 0xC615, 0xC5F5, 0xBDF4, 0xBDD4, 0xBDD4, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDD5, 0xB5D4, 0xB5D5, 0xB5D5, 0xB5D4, 0xB5B4,
  0xC636, 0xCE77, 0xCE57, 0xCE57, 0xCE57, 0xC637, 0xC636, 0xC636, 0xC636, 0xC636, 0xC616, 0xC636, 0xC636, 0xC637, 0xC637, 0xCE57, 0xC657, 0xC637, 0xD697, 0xD697, 0xD677, 0xC5B3, 0xB593, 0x9CD0, 0xA4F0, 0xBDB3, 0xD676, 0xDE76, 0xD5D3, 0xBDB4, 0x94AF, 
        0xA510, 0xBDB3, 0xDE77, 0xDE97, 0xD5F4, 0xBDD4, 0x8C6E, 0x9CF0, 0xBDB3, 0xD635, 0xD657, 0xCDB3, 0xC5D4, 0x9CD0, 0x948F, 0xAD51, 0xBDB3, 0xBDD4, 0xAD51, 0xB593, 0xB5B3, 0xB5B3, 0xC5F4, 0xC615, 0xCE36, 0xD676, 0xC636, 0xC636, 0xC637, 0xB5D5, 
        0xAD73, 0xB616, 0xAD95, 0xAD94, 0xA553, 0x9D33, 0x9D12, 0xA594, 0xBDD5, 0xAD31, 0xB5D5, 0xB5D5, 0xBD52, 0xBDB4, 0xAD94, 0x9490, 0xAD53, 0x842E, 0x8C90, 0xC636, 0xD5D2, 0xD614, 0xD6DA, 0xDE97, 0xDDF3, 0xCE57, 0xB573, 0xBDD4, 0xBDB4, 0x842E, 
        0xB5B5, 0xD635, 0xDDB1, 0xDE98, 0xDEB9, 0xCE57, 0xCE57, 0xB5B4, 0xAD53, 0xB5B4, 0x8C4F, 0xAD74, 0xCE36, 0xDDD1, 0xDE97, 0xDEDA, 0xDE34, 0xD635, 0xC616, 0xB594, 0xCE57, 0x8C4F, 0xA552, 0xD656, 0xDDD1, 0xDE97, 0xDEDA, 0xDE34, 0xD635, 0xBDF5, 
        0xAD73, 0xAD73, 0x73CD, 0xAD94, 0xD635, 0xDDF2, 0xDED9, 0xDEB9, 0xCE77, 0xC637, 0xAD32, 0xB573, 0xAD52, 0x9CF1, 0xC616, 0xDE13, 0xDE35, 0xDEDA, 0xDE76, 0xDE14, 0xBDF6, 0xA553, 0xB5D5, 0x94B0, 0xB5B4, 0xD656, 0xDDD1, 0xDEB8, 0xDEB9, 0xDDB2, 
        0xD656, 0x94B0, 0x8C8F, 0x9D12, 0x844F, 0xC636, 0xD591, 0xCDB2, 0xD699, 0xDEFA, 0xD636, 0xC5F5, 0x7BED, 0xB594, 0x9490, 0x8C6F, 0xD636, 0xDDD1, 0xDE97, 0xDED9, 0xDE34, 0xD657, 0x8C2E, 0xA532, 0xA511, 0x7BED, 0xCE36, 0xE5F1, 0xDE55, 0xDEDA, 
        0xDE55, 0xDDF3, 0xC636, 0xA552, 0xC636, 0xB593, 0xBDF5, 0xCDD3, 0xDD90, 0xDE98, 0xDEFA, 0xC571, 0xAD32, 0xAD73, 0xAD73, 0xAD73, 0xAD73, 0xA532, 0xB510, 0xD615, 0xE6FB, 0xBD92, 0xA4F0, 0xB5F5, 0xC616, 0xC636, 0xBDF5, 0xBD92, 0xCD92, 0xDED9, 
        0xDEB8, 0xD5F4, 0xCD70, 0xBD50, 0xC5B3, 0xBD92, 0xBD92, 0xDDD0, 0xE5D1, 0xDEB9, 0xDEB9, 0xE5F1, 0xEDCF, 0xB4CD, 0xB593, 0xBD71, 0xE5AF, 0xEDCF, 0xDDF3, 0xDED9, 0xE633, 0xEDCF, 0x6B29, 0x4247, 0x4A47, 0x39E6, 0x52A8, 0x4247, 0x844F, 0xDE98, 
        0xD615, 0xDDF3, 0xDE14, 0xD614, 0xD635, 0xDE56, 0xD635, 0xCE57, 0xD6B9, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xCE58, 0xCE58, 0xC637, 0xC616, 0xCE78, 0xC657, 0xC637, 0xC657, 0xC657, 0xC657, 0xCE57, 0xBDD5, 0xCE78, 0xCE98, 0xCE78, 0xD698, 0xD6B9, 
        0xD698, 0xCE98, 0xCE78, 0xC637, 0xC616, 0xC616, 0xB5D5, 0xBDD5, 0xB5D5, 0xB5B4, 0xAD94, 0xA552, 0x94B0, 0x94D1, 0x9CD1, 0x94B0, 0x94D1, 0x9CF2, 0x9D12, 0x9D12, 0x94B0, 0x842E, 0x840E, 0x848F, 0x844E, 0x9C8D, 0xD58D, 0xEE2E, 0xE5CD, 0xBD2D, 
        0xA50F, 0xAD51, 0x84AF, 0xC5F4, 0xDE97, 0xDE76, 0xDE77, 0xD656, 0xCDD3, 0xDE76, 0xDE76, 0xD676, 0xD656, 0xD656, 0xD676, 0xDEB8, 0xDEB8, 0xE6D9, 0xDEB8, 0xDED8, 0xDEB8, 0xDEB9, 0xD698, 0xDED9, 0xD677, 0xDED9, 0xD677, 0xD698, 0xD677, 0xBDD4, 
        0xC5F5, 0xBDF5, 0xC5F5, 0xD656, 0xD636, 0xD636, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xD656, 0xE6F9, 0xE6FA, 0xE6D9, 0xE6F9, 0xE6FA, 0xE6FA, 0xE71A, 0xE71B, 0xE71B, 0xE6FB, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE6FB, 0xDEDA, 0xD6B9, 
        0xD699, 0xD699, 0xDE55, 0xDE56, 0xD656, 0xD676, 0xD676, 0xD676, 0xD676, 0xD676, 0xD656, 0xD656, 0xD656, 0xD656, 0xD676, 0xDE76, 0xB4AC, 0xA3E8, 0xC468, 0xDD05, 0xF5C7, 0xF5C8, 0xF5E8, 0xF5C8, 0xE569, 0xDD6B, 0xE588, 0xDD48, 0xDD27, 0xDD27, 
        0xDD27, 0xCCA7, 0x9345, 0x6285, 0xCDB3, 0xE6B7, 0xDE97, 0xE697, 0xE697, 0xE697, 0xE697, 0xDE97, 0xDE97, 0xDE97, 0xDE54, 0xDE54, 0xDEB7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 
        0xE6D8, 0xE6D7, 0xCDD1, 0xDE13, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED7, 0xEED7, 0xE6D7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE696, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 
        0xDE76, 0xDE76, 0xDE76, 0xD656, 0xD656, 0xD655, 0xD635, 0xD635, 0xD635, 0xD635, 0xCE35, 0xCE35, 0xCE35, 0xC615, 0xC615, 0xC615, 0xBDF5, 0xBDF4, 0xBDF5, 0xBDD4, 0xBDD4, 0xBDD4, 0xBDF5, 0xBDD5, 0xBDD4, 0xBDF4, 0xBDF5, 0xB5D5, 0xB5D4,
  0xC616, 0xB574, 0xBDD5, 0xC616, 0xBDF5, 0xCE77, 0xCE57, 0xC657, 0xC636, 0xBE36, 0xBE16, 0xB5F5, 0xA5B4, 0x9D73, 0x9553, 0x8D32, 0x8511, 0x84F1, 0xCE77, 0xD697, 0xD677, 0xC5B2, 0xB573, 0x94D0, 0xA4F0, 0xBDB3, 0xDE76, 0xDE97, 0xD5F3, 0xBDB4, 0x94B0, 
        0xA4F0, 0xBDB3, 0xCE36, 0xC615, 0xBD72, 0xB593, 0x948F, 0x9CF0, 0xB572, 0xBDB3, 0xB593, 0xA510, 0xBDB4, 0xBDD4, 0xC615, 0xCE35, 0xCE15, 0xCE35, 0xCE35, 0xD656, 0xDE54, 0xDE54, 0xDE33, 0xDE13, 0xDEB7, 0xDED9, 0xDED9, 0xDEDA, 0xDEFA, 0xDEDA, 
        0xCE57, 0xCE15, 0xD5D3, 0xD614, 0xD615, 0xCE35, 0xCE35, 0xCE15, 0xBDF5, 0xBDF5, 0xBDF5, 0xB5D5, 0xB5B5, 0xB5D5, 0xB5F6, 0xB5D5, 0xAD94, 0xA574, 0xA573, 0xB5D5, 0xB573, 0xAD52, 0xB5D6, 0xBDB4, 0xBD72, 0xBDD5, 0x94B0, 0xA532, 0x9CD1, 0x7C0E, 
        0xB5B5, 0xD615, 0xD590, 0xD677, 0xD699, 0xCE36, 0xD678, 0xAD73, 0xA532, 0xAD73, 0x73CD, 0xAD94, 0xD656, 0xDDD1, 0xDE97, 0xDEDA, 0xDE34, 0xD635, 0xB5B4, 0xA532, 0xB5B4, 0x840E, 0xA553, 0xD656, 0xDDD1, 0xDE97, 0xDEDA, 0xDE34, 0xD636, 0xBDF6, 
        0xB594, 0xB5D5, 0x844F, 0xB5D5, 0xD635, 0xDDF2, 0xDED9, 0xDEB9, 0xCE57, 0xCE57, 0xB593, 0xBDD5, 0xA532, 0x94B0, 0xC636, 0xDE13, 0xDE35, 0xDEFA, 0xDE55, 0xDE14, 0xB5B5, 0x9D12, 0xAD94, 0x94B0, 0xB5B4, 0xD636, 0xE5D1, 0xDEB8, 0xDEB9, 0xE5D2, 
        0xD636, 0xAD94, 0xB5B4, 0xA532, 0x94D1, 0xC636, 0xD590, 0xCDD2, 0xD699, 0xDEDA, 0xDE36, 0xC616, 0x8C6F, 0xA552, 0x948F, 0x94D1, 0xCE35, 0xDDD1, 0xDE97, 0xDEDA, 0xDDF4, 0xCE36, 0x842E, 0xA511, 0x9490, 0x840D, 0xCE16, 0xE5F1, 0xDE56, 0xDEDA, 
        0xDE56, 0xDE13, 0xB5B4, 0x7BCC, 0xBDD5, 0x842E, 0xB5B5, 0xDE34, 0xE5D1, 0xDEB8, 0xDEDA, 0xDE13, 0xD656, 0xA552, 0xBDD5, 0xBDF5, 0xB593, 0xCDF5, 0xD56F, 0xD635, 0xE6FA, 0xC5B3, 0xAD52, 0xAD93, 0xAD73, 0xAD73, 0xAD73, 0xA532, 0xBD52, 0xDED9, 
        0xDEB8, 0xC5F4, 0xA552, 0xB573, 0xBDD4, 0xC5D4, 0xB5B4, 0xBD93, 0xCD92, 0xDEB9, 0xDEB9, 0xDDB0, 0xC570, 0xBD72, 0xC5F4, 0xBD72, 0xC5B2, 0xE5AF, 0xDE13, 0xDED9, 0xE653, 0xA44C, 0x3A06, 0x4A88, 0x39E6, 0x31E5, 0x52C9, 0x4A88, 0x52A9, 0xB552, 
        0xDE14, 0xEDF0, 0xBCED, 0xB530, 0xD590, 0xEDD0, 0xDD90, 0xD636, 0xD698, 0xDDD1, 0xDDD1, 0xDDF2, 0xDDF3, 0xDE14, 0xDE34, 0xD614, 0xCE36, 0xD698, 0xCE57, 0xD677, 0xD698, 0xD698, 0xCE98, 0xCE78, 0xBDD5, 0xCE78, 0xC657, 0xC657, 0xC658, 0xC658, 
        0xC678, 0xC658, 0xC657, 0xC637, 0xC636, 0xCE78, 0xCE78, 0xCE78, 0xD698, 0xD698, 0xCE98, 0xCE98, 0xC636, 0xCE77, 0xCE57, 0xBE16, 0xBE16, 0xBDF5, 0xB5D5, 0xB594, 0x9CF2, 0x9CF1, 0x94B0, 0xA532, 0xC56F, 0xFEF0, 0xFF31, 0xFF11, 0xFEF0, 0xFE8F, 
        0xDDCF, 0xB572, 0x7C8F, 0xA552, 0xDE77, 0xDE76, 0xDE76, 0xD676, 0xD635, 0xD676, 0xDE76, 0xD676, 0xD656, 0xD656, 0xD676, 0xDEB8, 0xCE56, 0xDE98, 0xCE56, 0xD656, 0xCE36, 0xCE57, 0xB5B4, 0xCE36, 0xBDD5, 0xC616, 0xC616, 0xBDF5, 0xC5F5, 0xB573, 
        0xBDF5, 0xBDD4, 0xC5F5, 0xD656, 0xD636, 0xD636, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xDE77, 0xE6FA, 0xE71A, 0xEF1A, 0xEF1A, 0xE71A, 0xE71A, 0xE71A, 0xE71B, 0xE71B, 0xE6FB, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE6FB, 0xDEDA, 0xDEDA, 
        0xDEFA, 0xDEDA, 0xDE55, 0xDE76, 0xD656, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xD676, 0xD676, 0xD676, 0xD676, 0xD676, 0xD676, 0xACEF, 0x8B89, 0xAC6C, 0xBD2D, 0xD5CC, 0xD5CE, 0xCDCE, 0xD610, 0xCD8E, 0xC4EB, 0xE5CE, 0xCD8E, 0xBD6F, 0xBD4E, 0xC58D, 
        0xCD8C, 0xCD4B, 0xCD0A, 0x9BE8, 0xBD71, 0xDEB7, 0xDE97, 0xDE97, 0xE697, 0xE697, 0xE697, 0xDE97, 0xDE96, 0xDEB7, 0xE675, 0xE654, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 
        0xE6D8, 0xE6D7, 0xA4EE, 0xACEF, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED8, 0xEED7, 0xEED7, 0xEED7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE696, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 0xDE96, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 
        0xDE76, 0xDE76, 0xDE76, 0xD656, 0xD656, 0xD655, 0xD635, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE15, 0xC615, 0xC615, 0xC615, 0xC615, 0xC5F5, 0xBDF5, 0xBDF5, 0xBDD4, 0xBDD4, 0xBDD4, 0xBDD4, 0xBDD5, 0xBDD5, 0xBDF5, 0xBDF5, 0xBE15, 0xBE15,
  0xBDF6, 0x6BCD, 0x6BED, 0x744F, 0x744E, 0x8532, 0x7CF1, 0x74D0, 0x7CF1, 0x6CAF, 0x5C4E, 0x544E, 0x4C2D, 0x4C2D, 0x4C2D, 0x442D, 0x440D, 0x546D, 0xCE76, 0xD697, 0xD677, 0xC5B3, 0xB593, 0x94B0, 0x9CD0, 0xB592, 0xC5D4, 0xA511, 0xB551, 0xAD73, 0x9CD0, 
        0xA511, 0xB593, 0xB593, 0xAD52, 0xAD72, 0xC635, 0xCE56, 0xCE35, 0xCE15, 0xCE35, 0xD656, 0xD676, 0xDE55, 0xDE33, 0xDE12, 0xDDF2, 0xDE13, 0xDEB8, 0xDEB8, 0xE675, 0xE611, 0xDDF2, 0xDDF1, 0xD5D2, 0xC5F4, 0xC5F5, 0xB5B4, 0xAD94, 0xB5B5, 0xB5B5, 
        0xB5B5, 0xC615, 0xCDB3, 0xD5F4, 0xDE14, 0xDE34, 0xDE33, 0xDE13, 0xDE13, 0xD6B8, 0xD6D9, 0xD6B9, 0xD635, 0xD5D2, 0xD5F3, 0xD613, 0xD614, 0xD615, 0xD635, 0xCE15, 0xBDF5, 0xBE16, 0xB5D5, 0xB5D5, 0xB5D5, 0xBE16, 0xBDF6, 0xB5B5, 0xAD94, 0xA553, 
        0xA574, 0xB5B4, 0xAD11, 0xB594, 0xB5B5, 0xB5D5, 0xC637, 0xA533, 0x94D1, 0x9CF1, 0x73AD, 0xA553, 0xCE56, 0xD5B1, 0xD698, 0xD6D9, 0xDE34, 0xD656, 0xAD74, 0x9CF1, 0xB573, 0x6B8C, 0xA553, 0xD656, 0xDDD1, 0xDE97, 0xDEDA, 0xDE34, 0xCE35, 0xB594, 
        0xAD53, 0xAD74, 0x840E, 0xB5B4, 0xD635, 0xDDF2, 0xDED9, 0xDEB9, 0xCE77, 0xC657, 0xB594, 0xC5F5, 0xB594, 0x9CF1, 0xC636, 0xDE13, 0xDE55, 0xDEFA, 0xDE55, 0xD614, 0xC616, 0xAD73, 0xBDF5, 0x844F, 0xB5B4, 0xD636, 0xDDF2, 0xDEB9, 0xDEB9, 0xE5F2, 
        0xD635, 0xAD53, 0xB594, 0x9D12, 0x94D1, 0xC636, 0xD590, 0xD5D3, 0xD699, 0xDEDA, 0xDE36, 0xCE16, 0xB594, 0xBDF5, 0x9CD1, 0xA553, 0xD656, 0xDDB1, 0xDE77, 0xDED9, 0xDE14, 0xD657, 0x9CF1, 0x9CF1, 0x8C6F, 0x94D0, 0xCE36, 0xE5D1, 0xDE55, 0xDEDA, 
        0xDE56, 0xDDF3, 0xB573, 0x7BCC, 0xB593, 0x842E, 0xB594, 0xDE34, 0xE5F1, 0xDEB8, 0xDED9, 0xDE13, 0xD635, 0x840D, 0xA532, 0x9CF1, 0x94B0, 0xD656, 0xE5D0, 0xDE55, 0xDEDA, 0xDE34, 0xD656, 0xAD52, 0xC616, 0xBDF5, 0xAD93, 0xD614, 0xD5B2, 0xDED9, 
        0xDEB8, 0xCE15, 0xB5D5, 0xB5B4, 0xB5B4, 0xB5B4, 0xAD73, 0xAD32, 0xC550, 0xDEB9, 0xDEB9, 0xACCE, 0xA532, 0xB573, 0xBDB4, 0xB5B4, 0xAD53, 0xBD51, 0xCDD3, 0xDEFA, 0xDE13, 0x5287, 0x29C5, 0x52A8, 0x31E6, 0x31E6, 0x5AE9, 0x4A47, 0x4A68, 0x6309, 
        0xDE14, 0xD590, 0xA4CE, 0xB593, 0xBD51, 0xE5D0, 0xE5B0, 0xDE76, 0xDEB8, 0xE5D0, 0xEDCF, 0xD54E, 0xB530, 0xD58F, 0xEDAF, 0xE58F, 0xD636, 0xD698, 0xDDF2, 0xE5B0, 0xDDD1, 0xCD91, 0xD5D2, 0xDE12, 0xC5B2, 0xD698, 0xCE98, 0xD636, 0xD656, 0xD656, 
        0xD677, 0xD678, 0xD698, 0xCE57, 0xC637, 0xCE78, 0xC637, 0xC657, 0xCE58, 0xCE58, 0xCE57, 0xCE57, 0xC616, 0xC637, 0xCE57, 0xC657, 0xCE78, 0xCE78, 0xD698, 0xCE98, 0xBDF6, 0xC616, 0xC637, 0xD697, 0xE5ED, 0xEE4C, 0xFEF0, 0xFF31, 0xFF31, 0xFF30, 
        0xF62D, 0xB4CD, 0x84AF, 0x84AF, 0xCE36, 0xDE77, 0xDE76, 0xD656, 0xC5D4, 0xD656, 0xD676, 0xD656, 0xD656, 0xD656, 0xCE15, 0xC5F4, 0xBDB3, 0xC615, 0xBDB3, 0xC5F4, 0xC5F4, 0xCE77, 0xB5B4, 0xC615, 0xB5B4, 0xBDD4, 0xBDF5, 0xB593, 0xBDB4, 0x94B0, 
        0x9CF1, 0x9CD1, 0x9CD0, 0xBDD4, 0xD656, 0xD636, 0xCE36, 0xCE36, 0xCE36, 0xCE36, 0xD636, 0xDE97, 0xE6FA, 0xE6FA, 0xE71A, 0xE71A, 0xE71A, 0xE6FA, 0xE6FA, 0xE71B, 0xE71B, 0xE6FB, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xDEFB, 0xDEDA, 0xDEDA, 
        0xDEFA, 0xDEB9, 0xC54F, 0xCDF3, 0xDE76, 0xD676, 0xDE76, 0xDE76, 0xD676, 0xD676, 0xD676, 0xD676, 0xD676, 0xD676, 0xDE76, 0xB551, 0xA48E, 0xB550, 0xB551, 0xBD92, 0xCDF4, 0xD656, 0xC5F5, 0xAD11, 0x9C8E, 0xACF0, 0xAD52, 0xB5B4, 0xC5F6, 0xBDD4, 
        0xB573, 0xAD32, 0x9CD0, 0x942C, 0xBD72, 0xE6B7, 0xDE97, 0xDE97, 0xDE97, 0xE697, 0xE6B7, 0xE6B7, 0xDE97, 0xE6B7, 0xD5F2, 0xD5D2, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 
        0xE6D8, 0xE6B7, 0xA50F, 0xA4EF, 0xEED7, 0xEEF8, 0xEED8, 0xEED8, 0xEED8, 0xEED7, 0xEED7, 0xE6D7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xE696, 0xDE96, 0xDE96, 0xE696, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 
        0xDE76, 0xDE76, 0xDE76, 0xD656, 0xD656, 0xD656, 0xD656, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE15, 0xC615, 0xC615, 0xC615, 0xC615, 0xC5F5, 0xBDF5, 0xBDF5, 0xBDD4, 0xBDD4, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDF4, 0xBDF5, 0xC615, 0xC615,
  0x542D, 0x43AB, 0x3BAB, 0x3BCB, 0x3BAB, 0x33AB, 0x3BCC, 0x544E, 0x5C8F, 0x4C4D, 0x440D, 0x4C2D, 0x440D, 0x4C2D, 0x4C2D, 0x442D, 0x4C4E, 0x5C6E, 0xBE35, 0xBDF5, 0xBDD4, 0xB572, 0xA532, 0x94B0, 0x94AF, 0xAD52, 0xBD93, 0xAD72, 0xC615, 0xC636, 0xCE36, 
        0xCE35, 0xCE35, 0xCE56, 0xD676, 0xD676, 0xDE54, 0xDE13, 0xDE12, 0xDDD1, 0xDE55, 0xDEB8, 0xDE97, 0xDDF2, 0xDDD0, 0xE5F1, 0xDDF1, 0xD5D3, 0xBDF5, 0xB5B3, 0xC5D3, 0xCDD3, 0xC592, 0xBD51, 0xBD71, 0xC615, 0xCE56, 0xCE56, 0xCE57, 0xC637, 0xBDF6, 
        0xB573, 0xB573, 0xA4D0, 0xAD11, 0xAD32, 0xB593, 0xBDD4, 0xC5D5, 0xC5D5, 0xB5D5, 0xBE16, 0xC617, 0xCE36, 0xD634, 0xDE34, 0xDE13, 0xDE12, 0xDE12, 0xE612, 0xDDF2, 0xDE35, 0xDED9, 0xD6B9, 0xD698, 0xCDF3, 0xD5F3, 0xD614, 0xD635, 0xD656, 0xCE56, 
        0xCE36, 0xBDF5, 0xB5D5, 0xB5D5, 0xAD94, 0xBDF6, 0xBE37, 0xBE16, 0xBE16, 0xADB5, 0xA574, 0xA533, 0xB5B5, 0xAD31, 0xB5B4, 0xBDF6, 0xBD72, 0xC5F5, 0xA553, 0x94D1, 0xA532, 0x6B8C, 0xA553, 0xD656, 0xDDB1, 0xDE97, 0xDEDA, 0xDE34, 0xD656, 0xAD74, 
        0xAD73, 0xA553, 0x73CD, 0xBDF5, 0xDE35, 0xDDF2, 0xDEDA, 0xDEB9, 0xCE57, 0xC637, 0xAD53, 0xB5B4, 0xA512, 0x94D1, 0xC636, 0xDE13, 0xDE56, 0xDEFA, 0xDE55, 0xDE14, 0xC616, 0xB594, 0xC636, 0x8CB0, 0xB5B5, 0xD635, 0xDDF2, 0xDEB9, 0xDEB8, 0xDDD2, 
        0xD635, 0xB593, 0xBE15, 0x9D12, 0x8C90, 0xCE36, 0xD570, 0xCDB3, 0xD699, 0xDEDA, 0xDE36, 0xC5F5, 0xA553, 0xB5B4, 0x9CF1, 0xA553, 0xD635, 0xDDB1, 0xDE77, 0xDED9, 0xDE14, 0xCE56, 0xB5B4, 0xBDD4, 0x9CD1, 0xA552, 0xCE56, 0xE5F1, 0xDE56, 0xDEFA, 
        0xDE55, 0xDE14, 0xBDD5, 0x842E, 0xA512, 0x8C4E, 0xBDD5, 0xDE34, 0xDDD1, 0xDEB8, 0xDED9, 0xDE13, 0xC5F4, 0x842E, 0xAD52, 0x94B0, 0x9490, 0xD636, 0xE5D0, 0xDE55, 0xDEDA, 0xDE34, 0xCE15, 0x7BED, 0xB594, 0x9D11, 0x94B0, 0xDE35, 0xDDF2, 0xDEB9, 
        0xDEB9, 0xCE36, 0xCE77, 0xA532, 0xBDF5, 0xBDB4, 0xBDF5, 0xD635, 0xDDD1, 0xDEB9, 0xDEB8, 0xCD91, 0xB5B4, 0xB593, 0xB593, 0xAD74, 0xA532, 0xACF0, 0xC592, 0xE71B, 0x9CD0, 0x31C5, 0x31E6, 0x4226, 0x29C5, 0x29C5, 0x632A, 0x4A47, 0x4227, 0x4227, 
        0xB552, 0xBD72, 0xC5D3, 0xC5F4, 0xBD72, 0xCDD2, 0xDDB0, 0xDE77, 0xDEB8, 0xE5F1, 0xE5AF, 0xB4EE, 0xB573, 0xB530, 0xE5D0, 0xE5B0, 0xDE56, 0xDEB9, 0xE5F1, 0xEDEF, 0xC50E, 0xB572, 0xD590, 0xEDAF, 0xD56F, 0xDEB8, 0xD698, 0xE5D1, 0xE5D0, 0xE5D0, 
        0xD591, 0xDDD1, 0xDDF2, 0xD5F3, 0xCE57, 0xD698, 0xD656, 0xD656, 0xD677, 0xD698, 0xD698, 0xD699, 0xCE57, 0xCE78, 0xCE78, 0xC657, 0xC637, 0xC637, 0xC637, 0xC637, 0xB5D5, 0xBDF6, 0xBDF5, 0xCE57, 0xDDEE, 0xEE4D, 0xF6AF, 0xF6F1, 0xFF31, 0xFF30, 
        0xF60C, 0xBCCB, 0x9510, 0x746E, 0xB5B4, 0xDE97, 0xD676, 0xD676, 0xCE15, 0xD656, 0xD676, 0xD656, 0xD656, 0xD656, 0xBDB3, 0xCE35, 0xD677, 0xE6D8, 0xDE97, 0xE6D8, 0xDEB8, 0xDEB9, 0xCE77, 0xDEB8, 0xD697, 0xDED8, 0xCE77, 0xD677, 0xCE56, 0xAD52, 
        0xB593, 0xAD52, 0xA512, 0xCE15, 0xD656, 0xD636, 0xD636, 0xCE36, 0xCE36, 0xCE36, 0xD636, 0xDE97, 0xE6F9, 0xE6FA, 0xE71A, 0xE71A, 0xE71A, 0xE6FA, 0xE6FA, 0xE71B, 0xE71B, 0xE6FB, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xDEFB, 0xDEDA, 0xDEDA, 
        0xDEFA, 0xDEB9, 0x9C2B, 0xC5D3, 0xDE97, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xD676, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xDE97, 0xD655, 0xCE14, 0xCE15, 0xD656, 0xD656, 0xAD53, 0x94B1, 0x9CD1, 0xA533, 0xB5B5, 0xB5B5, 0xAD74, 0xBDD5, 0xCE57, 
        0xCE78, 0xCE57, 0xC616, 0xD636, 0xE6B7, 0xDE97, 0xDE97, 0xE697, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xDE97, 0xE6D8, 0xC570, 0xB50F, 0xE6D8, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 
        0xEED8, 0xDE96, 0x9CCE, 0x9CCE, 0xE6B7, 0xEEF8, 0xEED8, 0xEED8, 0xEED8, 0xEED7, 0xE6D7, 0xE6D7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xDE97, 0xDE96, 0xDE96, 0xE696, 0xE697, 0xE696, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 
        0xDE76, 0xDE76, 0xDE76, 0xDE56, 0xD656, 0xD656, 0xD656, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xC615, 0xC615, 0xC615, 0xC615, 0xC5F5, 0xBDF5, 0xBDF5, 0xBDD4, 0xBDD4, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDF5, 0xBDF5, 0xC615, 0xC615, 0xC615,
  0x3BCC, 0x3BCB, 0x3BCC, 0x3BEC, 0x3BEC, 0x4C2D, 0x544E, 0x5C8F, 0x548E, 0x442D, 0x440C, 0x442D, 0x442D, 0x4C4D, 0x4C2D, 0x4C2D, 0x4C2D, 0x648E, 0xB592, 0xA531, 0xB5B4, 0xBDF5, 0xC635, 0xCE15, 0xD635, 0xD634, 0xD656, 0xCE76, 0xD656, 0xDE13, 0xE612, 
        0xDDF2, 0xDDF1, 0xDE56, 0xD677, 0xD635, 0xDDD1, 0xDDF1, 0xDDF1, 0xD5B1, 0xC5B2, 0xBDB4, 0xBD72, 0xCDB1, 0xC571, 0xC591, 0xCD70, 0xC591, 0xC614, 0xC5D3, 0xDD8F, 0xDD8F, 0xBD0E, 0xD56E, 0xEDF0, 0xDE97, 0xDEB8, 0xD6B8, 0xDEB9, 0xDEDA, 0xDED9, 
        0xCE36, 0xD5D2, 0xE58F, 0xE58F, 0xC52F, 0xBD30, 0xD56F, 0xD56F, 0xD54F, 0xC571, 0xC616, 0xB5D6, 0xBD52, 0xBD51, 0xC592, 0xBD92, 0xBD73, 0xBD93, 0xBDB4, 0xBDB4, 0xBDB4, 0xBDD5, 0xBE16, 0xC616, 0xD5F4, 0xD614, 0xDE14, 0xDE13, 0xDE13, 0xDE13, 
        0xDE13, 0xDE14, 0xDEB8, 0xD6D9, 0xD6B9, 0xCE77, 0xCDF4, 0xD5F3, 0xD614, 0xCE15, 0xCE35, 0xCE15, 0xC5F5, 0xBDD5, 0xBDF5, 0xB5F5, 0xB5D5, 0xB5F6, 0xBDF6, 0xB5D5, 0xAD95, 0xAD74, 0xAD94, 0xBDF6, 0xB552, 0xB594, 0xB5D5, 0xBD92, 0xBDF5, 0x9CF2, 
        0x94D1, 0x94B0, 0x7C0E, 0xB5D5, 0xD635, 0xD5B2, 0xD699, 0xD698, 0xCE57, 0xCE57, 0xA512, 0xBDD5, 0x94B0, 0x94D1, 0xCE56, 0xDE13, 0xDE56, 0xDEFB, 0xE655, 0xDE14, 0xBDD5, 0xAD52, 0xBDD5, 0x8C6F, 0xB5D5, 0xD635, 0xDDF2, 0xDEB9, 0xDEB8, 0xDDD1, 
        0xD636, 0xB594, 0xC636, 0xAD53, 0x94F1, 0xCE56, 0xD570, 0xCDB3, 0xD699, 0xDED9, 0xDE35, 0xCE16, 0xAD73, 0xBDF5, 0x8C6F, 0xA553, 0xD635, 0xDDB1, 0xDE77, 0xDED9, 0xDE14, 0xCE56, 0xAD53, 0xB594, 0x94D0, 0xA512, 0xCE56, 0xE5F1, 0xDE55, 0xDEFA, 
        0xDE55, 0xDE13, 0xC616, 0xB573, 0xBDB4, 0x9CD1, 0xC616, 0xDE34, 0xDDD1, 0xDEB8, 0xDED9, 0xDE13, 0xCE36, 0x9490, 0x9CF1, 0x9490, 0xA511, 0xD656, 0xE5D1, 0xDE55, 0xDEDA, 0xD614, 0xCDF5, 0x7BED, 0xAD73, 0x8C6F, 0x94B0, 0xD635, 0xDDF3, 0xDEB9, 
        0xDEB8, 0xCE15, 0xCE57, 0x842E, 0xB573, 0x946F, 0xA532, 0xDE55, 0xDDF2, 0xDEB9, 0xDEB8, 0xDE13, 0xC615, 0x9CF1, 0xCE77, 0xA532, 0xC615, 0xDDD1, 0xDE13, 0xDED9, 0x632A, 0x29C5, 0x3206, 0x4247, 0x29A5, 0x29A5, 0x4A67, 0x4A67, 0x3A27, 0x3A27, 
        0x73CD, 0xB594, 0xB594, 0xB5B4, 0xB5B4, 0xAD73, 0xBD51, 0xD657, 0xE6B9, 0xCD4F, 0xB530, 0xBD92, 0xC5D4, 0xBD93, 0xC5B3, 0xD5B1, 0xDE76, 0xDEB9, 0xE612, 0xDD8F, 0xACEF, 0xBDB4, 0xBD51, 0xD58F, 0xD56F, 0xDEB8, 0xDEB8, 0xE5F1, 0xEDEF, 0xCD2E, 
        0xBD72, 0xD590, 0xEDCF, 0xDDB0, 0xD677, 0xDE76, 0xE5D0, 0xE5D0, 0xDDB0, 0xCD91, 0xDDD2, 0xDDF2, 0xD5F3, 0xCE78, 0xD677, 0xD635, 0xDE35, 0xD656, 0xD656, 0xD677, 0xC5F5, 0xC616, 0xC616, 0xCE57, 0xBCAB, 0xABC5, 0x8B66, 0x8386, 0x8BA7, 0x93C7, 
        0x9BA5, 0xBCAB, 0xAD72, 0x6C4D, 0x9D32, 0xD677, 0xCE56, 0xD656, 0xCDF4, 0xD656, 0xD676, 0xD656, 0xD656, 0xD656, 0xD656, 0xDEB8, 0xDED9, 0xE6F9, 0xDEB8, 0xDEB8, 0xE6D9, 0xD698, 0xD698, 0xDED9, 0xBDD5, 0xD677, 0xD698, 0xDEB8, 0xCE57, 0xB5B4, 
        0xBDD5, 0xBDD5, 0xBDF5, 0xD656, 0xD656, 0xD656, 0xCE36, 0xCE36, 0xD636, 0xD656, 0xD656, 0xDE97, 0xE6FA, 0xE6FA, 0xE71A, 0xE71A, 0xE71A, 0xE6FA, 0xE6FA, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE6FB, 0xDEDA, 0xDEBA, 
        0xDEFA, 0xE6DA, 0xD5B0, 0xD614, 0xDE97, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xCE15, 0xCE35, 0xD656, 0xD656, 0x94B0, 0x8C4F, 0x9CF2, 0x9CF1, 0xB594, 0xC657, 0xC637, 0xC637, 0xB5B4, 0xAD53, 
        0xCE57, 0xCE37, 0xC5F6, 0xCE36, 0xDE97, 0xE697, 0xDE97, 0xE697, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xDE97, 0xE6B7, 0xDE54, 0xE633, 0xE6B7, 0xE697, 0xE697, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xE6B7, 0xE6B7, 0xDEB7, 0xDEB7, 0xE6B7, 0xE6B7, 0xE6B7, 
        0xEED8, 0xDE76, 0x948D, 0x94AE, 0xDE96, 0xEEF8, 0xEEF8, 0xEED8, 0xEED7, 0xEED7, 0xEED7, 0xE6D7, 0xE6D7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xDE97, 0xDE96, 0xDE96, 0xE696, 0xE696, 0xE696, 0xDE96, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 
        0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xD656, 0xD656, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE35, 0xCE15, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xBDF5, 0xBDF5, 0xBDF5, 0xBDD5, 0xBDD4, 0xBDD4, 0xBDF4, 0xBE15, 0xC615, 0xC635, 0xC615, 0xC615,
  0x3BCB, 0x3BCC, 0x442D, 0x442D, 0x4C2D, 0x4C4D, 0x546E, 0x546E, 0x546E, 0x442D, 0x4C2D, 0x4C2D, 0x4C2D, 0x4C4D, 0x4C2D, 0x4C2C, 0x43EB, 0x540C, 0xCE97, 0xD677, 0xD697, 0xCE14, 0xE612, 0xE612, 0xE5F1, 0xDDD1, 0xD655, 0xCE36, 0xD614, 0xD5B1, 0xD5B1, 
        0xD5B1, 0xC571, 0xBDB3, 0xBD93, 0xBD51, 0xC550, 0xBD30, 0xC54F, 0xD56F, 0xCDD3, 0xC615, 0xD591, 0xE58E, 0xD590, 0xBD2F, 0xE5AE, 0xEE11, 0xDEB8, 0xDE55, 0xEDCF, 0xD590, 0xA531, 0xA46B, 0xE5F0, 0xDE97, 0xDEB8, 0xD698, 0xD6B9, 0xDEB9, 0xD6B9, 
        0xD656, 0xDDF2, 0xE58E, 0xC50D, 0xAD10, 0xC5F4, 0xCD4F, 0xE5AF, 0xEDAF, 0xE5F2, 0xDED9, 0xD6B9, 0xE5F2, 0xEDAF, 0xEDCF, 0xD56F, 0xB510, 0xBD50, 0xDD6F, 0xD56F, 0xCD4F, 0xCDD4, 0xC616, 0xBDD5, 0xBD31, 0xBD51, 0xBD72, 0xBD72, 0xB552, 0xBD93, 
        0xBDB3, 0xC5B4, 0xB5B4, 0xBDF6, 0xBDF6, 0xC636, 0xCDF4, 0xD5F4, 0xDE14, 0xDE13, 0xDE13, 0xDE13, 0xDE13, 0xD697, 0xD6D9, 0xDED9, 0xD656, 0xD5F3, 0xDDF3, 0xDE14, 0xD614, 0xD635, 0xCE15, 0xC5F5, 0xBDF6, 0xBE16, 0xB5D5, 0xB5B5, 0xBDF5, 0xBE16, 
        0xB5F6, 0xB5B5, 0xAD94, 0xB5B5, 0xB5D5, 0xAD32, 0xB5B4, 0xB5B5, 0xBDF6, 0xBDF6, 0x8C90, 0x9D12, 0x842F, 0x94B1, 0xCE57, 0xD613, 0xD615, 0xD6B9, 0xDE35, 0xDE34, 0xB5B4, 0xAD52, 0xC5F5, 0x948F, 0xBDF5, 0xD656, 0xE5F2, 0xDED9, 0xDEB8, 0xDDD1, 
        0xD656, 0xAD53, 0xBDF5, 0x9D12, 0x94D1, 0xCE57, 0xD570, 0xCDD3, 0xD699, 0xDED9, 0xD635, 0xCE15, 0xAD73, 0xBDF5, 0x9490, 0xAD73, 0xD635, 0xDDB1, 0xDE77, 0xDED9, 0xDE13, 0xD656, 0xB5B4, 0xBE15, 0x9490, 0xA552, 0xCE56, 0xE5D1, 0xDE55, 0xDEFA, 
        0xDE55, 0xDE14, 0xBDB5, 0xAD32, 0xB553, 0x94B0, 0xC616, 0xDE34, 0xDDD1, 0xDEB9, 0xDED9, 0xDE13, 0xCE36, 0xAD94, 0xBDF5, 0x9CF1, 0xB573, 0xD656, 0xE5D1, 0xDE55, 0xDEDA, 0xD615, 0xCE15, 0x9490, 0xA512, 0x842F, 0xA532, 0xD655, 0xDDF3, 0xDED9, 
        0xDEB8, 0xCE36, 0xCE77, 0x844E, 0xA512, 0x8C4F, 0xA532, 0xDE55, 0xDDF2, 0xDEB9, 0xDEB8, 0xDE13, 0xAD52, 0x840D, 0xBDD4, 0x7BCD, 0xBDD4, 0xE612, 0xE654, 0xB594, 0x31E5, 0x3A47, 0x5B4A, 0x4AC9, 0x29A5, 0x29C5, 0x3A27, 0x52A9, 0x31E6, 0x4B29, 
        0x5B6B, 0xAD73, 0xB5B5, 0xBDF5, 0xB5B4, 0xB5B4, 0xC530, 0xD656, 0xDEB8, 0xACEF, 0xAD52, 0xAD73, 0xB594, 0xB594, 0xAD53, 0xAD31, 0xD656, 0xDED9, 0xC550, 0xAD10, 0xBDB3, 0xCE15, 0xBD93, 0xBD92, 0xC571, 0xDEB9, 0xDEB9, 0xE5F1, 0xCD6F, 0xB530, 
        0xBDB3, 0xBD51, 0xDDB0, 0xE5B0, 0xDE78, 0xDE97, 0xEDF0, 0xEDCF, 0xB4EE, 0xBD72, 0xD56F, 0xEDCF, 0xDDD2, 0xDEB9, 0xDE35, 0xE5AF, 0xE5AF, 0xC54F, 0xCD90, 0xDDB0, 0xCD4F, 0xCE15, 0xCE57, 0xD677, 0xBC8A, 0xC405, 0x8AC3, 0x6243, 0x6A63, 0x6A63, 
        0x72A4, 0xB4CD, 0xB5B3, 0x6C2D, 0x9511, 0xC636, 0xBDB4, 0xC5D4, 0xC571, 0xCDD3, 0xD656, 0xD656, 0xD656, 0xCE56, 0xD676, 0xDEB8, 0xE6D9, 0xE6F9, 0xCE35, 0xD656, 0xE6FA, 0xDEB9, 0xDEB9, 0xE71A, 0x9CF1, 0xC5D5, 0xDEB8, 0xDEB9, 0xD677, 0xBDD4, 
        0xC615, 0xC615, 0xC616, 0xD656, 0xD656, 0xD656, 0xCE56, 0xD656, 0xD656, 0xD656, 0xD656, 0xDE97, 0xE6FA, 0xE6FA, 0xE71A, 0xE71A, 0xE71A, 0xE6FA, 0xE6FA, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE6FB, 0xDEDA, 0xDEDA, 
        0xE71B, 0xD677, 0xDD6E, 0xE633, 0xDE97, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xD676, 0xCE15, 0xCE35, 0xCE15, 0xAD52, 0x842F, 0x9D12, 0xAD94, 0xB5B5, 0xC637, 0xCE79, 0xC679, 0xC658, 0xBE37, 0xAD74, 
        0xAD74, 0xC637, 0xC616, 0xD656, 0xDEB7, 0xDE97, 0xDE97, 0xE697, 0xE697, 0xE697, 0xE697, 0xDE97, 0xE6B7, 0xE6B7, 0xD5B0, 0xE611, 0xE6B7, 0xE6B7, 0xDE97, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xE697, 0xE6B7, 0xDEB7, 0xDEB7, 0xE6B7, 0xE6B7, 0xE6B7, 
        0xEEF8, 0xCE14, 0x8C8D, 0x8C8D, 0xD635, 0xEEF8, 0xEED8, 0xEED8, 0xEED7, 0xEED7, 0xEED7, 0xE6D7, 0xE6D7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xE697, 0xE697, 0xE696, 0xE696, 0xE696, 0xE696, 0xE696, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 
        0xDE76, 0xDE76, 0xDE56, 0xD656, 0xD655, 0xCE35, 0xCE35, 0xCE35, 0xC635, 0xCE35, 0xCE35, 0xC615, 0xC615, 0xC615, 0xC615, 0xC5F5, 0xC615, 0xC615, 0xC615, 0xC615, 0xBDF5, 0xBDF5, 0xBE15, 0xC615, 0xC635, 0xC636, 0xC636, 0xC636, 0xC635,
  0x3BCB, 0x3BCB, 0x3BCC, 0x43CC, 0x43CC, 0x43EC, 0x4C4D, 0x546E, 0x4C4D, 0x43EC, 0x43EC, 0x43EB, 0x43CB, 0x43CB, 0x3BAA, 0x43CB, 0x4BEB, 0x642C, 0xC636, 0xBDF5, 0xBE15, 0xBD92, 0xC591, 0xCD91, 0xC591, 0xC571, 0xBDB3, 0xAD52, 0xBD2F, 0xCD70, 0xC54F, 
        0xD56F, 0xDD8F, 0xD634, 0xD656, 0xDDD0, 0xE5AE, 0xC590, 0xBD0D, 0xEDAE, 0xE654, 0xDE98, 0xE5F2, 0xD56E, 0xC5B2, 0xA530, 0xBCEC, 0xE611, 0xDEB8, 0xD614, 0xD590, 0xB531, 0xC5B3, 0x9CCE, 0xACEE, 0xDE97, 0xDEB8, 0xD698, 0xD6B9, 0xDEB9, 0xDEB9, 
        0xD657, 0xC571, 0xB4EE, 0xB530, 0xBD72, 0xBD72, 0xB530, 0xCDB2, 0xE58F, 0xDDF2, 0xDEB9, 0xDEB9, 0xE5F2, 0xEDCF, 0xE5AF, 0xB4CD, 0xB5B3, 0xB572, 0xCD2E, 0xEDCF, 0xEDAE, 0xDE75, 0xDEDA, 0xDE77, 0xEDAF, 0xEDAF, 0xE5AF, 0xBD2F, 0xB551, 0xD56F, 
        0xDD8F, 0xDD6F, 0xCD71, 0xC636, 0xC616, 0xC5F5, 0xC571, 0xBD50, 0xBD51, 0xB552, 0xBD92, 0xBD93, 0xBD93, 0xB594, 0xB5F5, 0xBDF6, 0xBDB4, 0xCDB4, 0xCDF4, 0xD614, 0xDE14, 0xDE34, 0xE634, 0xE633, 0xDEB8, 0xDEFA, 0xDED9, 0xDE35, 0xDDD2, 0xDDF3, 
        0xD5F3, 0xD613, 0xD614, 0xD614, 0xCE15, 0xC637, 0xC636, 0xBDF6, 0xC617, 0xBE16, 0xBE16, 0xBDF6, 0xBDF6, 0xB5B5, 0xB5D5, 0xB593, 0xAD52, 0xB5B5, 0xB593, 0xBDD4, 0xAD74, 0x9CF1, 0xAD32, 0x946F, 0xB594, 0xCE36, 0xCD91, 0xCE57, 0xDE77, 0xDDD1, 
        0xD657, 0xA532, 0xBE16, 0x94B0, 0x94D1, 0xCE77, 0xD570, 0xCDD3, 0xD6B9, 0xDEDA, 0xD635, 0xC615, 0xAD73, 0xBDB4, 0x8C4F, 0xAD53, 0xD635, 0xDDD1, 0xD697, 0xDED9, 0xDE13, 0xD656, 0xB594, 0xBDF5, 0x94B0, 0xAD73, 0xCE56, 0xDDD1, 0xDE56, 0xDEFA, 
        0xDE55, 0xDE14, 0xCE36, 0xC5F5, 0xB593, 0x946F, 0xC616, 0xDE34, 0xDDD1, 0xDEB8, 0xDED9, 0xDE13, 0xCE15, 0xAD52, 0xBDD5, 0x9CB0, 0xAD53, 0xDE56, 0xE5D0, 0xDE55, 0xDEDA, 0xDE35, 0xCE15, 0xAD73, 0xB574, 0x9490, 0xAD73, 0xD635, 0xDDF3, 0xDED9, 
        0xDEB8, 0xD636, 0xCE77, 0xA532, 0xAD53, 0x94B0, 0xAD94, 0xDE55, 0xDDF1, 0xDEB9, 0xDEB8, 0xDE13, 0xB573, 0x840D, 0xAD52, 0x840E, 0xBDD5, 0xE612, 0xE633, 0x6B6B, 0x29A4, 0x6AC9, 0x7248, 0x6B0A, 0x31E6, 0x29A5, 0x3A06, 0x5AA9, 0x3A47, 0x6C4E, 
        0x5B09, 0x7BCD, 0x9CD1, 0xC616, 0x94D1, 0xD656, 0xE5D1, 0xDE77, 0xDEB8, 0xD5D2, 0xCE16, 0xB594, 0xBDF5, 0xB593, 0xBDD5, 0xC571, 0xD656, 0xDEB9, 0xBD51, 0xAD52, 0xAD73, 0xAD73, 0xB573, 0xA532, 0xAD31, 0xDEB9, 0xDEB9, 0xBD2F, 0xAD52, 0xBDB4, 
        0xC5F5, 0xBDD4, 0xBDB3, 0xCDB1, 0xD678, 0xDE97, 0xDDB0, 0xC54F, 0xBD51, 0xB572, 0xB530, 0xDDD0, 0xDDF2, 0xDEB9, 0xDE55, 0xEDD0, 0xCD2E, 0xAD52, 0xBD92, 0xDD6E, 0xDD4E, 0xD615, 0xCE78, 0xDE97, 0xC50A, 0xDD48, 0xDD08, 0xC487, 0xD4A6, 0xCC66, 
        0xA3A7, 0xCDF4, 0xBE15, 0x6C2D, 0x84AF, 0xA532, 0xAD73, 0xB552, 0xB4EE, 0xBD51, 0xD656, 0xD656, 0xD656, 0xD656, 0xD656, 0xDEB8, 0xE6D9, 0xE6FA, 0xCE36, 0xD677, 0xE6FA, 0xDED9, 0xDEB9, 0xE6FA, 0x9CF1, 0xC616, 0xDED9, 0xDEB9, 0xD698, 0xBDF5, 
        0xC615, 0xC5F5, 0xC616, 0xC615, 0xBDD4, 0xC615, 0xD656, 0xD656, 0xD676, 0xD656, 0xD656, 0xDE97, 0xE6FA, 0xE6FA, 0xE6FA, 0xE71A, 0xE71A, 0xE6FA, 0xE6FA, 0xE71B, 0xE71B, 0xE6FB, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE6FB, 0xDEDA, 0xDEFB, 
        0xCE79, 0xA4F1, 0xACAE, 0xACF0, 0xC5D4, 0xDE77, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xCE35, 0xB572, 0xCE14, 0x948E, 0x73AC, 0x94B1, 0xAD74, 0xBDF5, 0xC636, 0xC679, 0xC679, 0xBE59, 0xB638, 0xBE17, 0xADB6, 
        0x8C91, 0x9CF2, 0xAD73, 0xB573, 0xDE97, 0xDE97, 0xDE97, 0xE697, 0xE697, 0xE697, 0xE697, 0xE6B7, 0xDEB7, 0xBD93, 0xA48D, 0xB50F, 0xC5B4, 0xDE97, 0xDEB7, 0xDE97, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xE6B7, 0xE6B7, 0xE6D8, 
        0xEEF8, 0xC5D2, 0x8CAD, 0x8CAD, 0xC5F3, 0xEEF8, 0xEED8, 0xEED7, 0xEED7, 0xEED7, 0xEED7, 0xE6D7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xE697, 0xE696, 0xE697, 0xE697, 0xE696, 0xE696, 0xDE96, 0xDE76, 0xDE76, 
        0xDE76, 0xDE56, 0xD656, 0xD656, 0xCE55, 0xCE35, 0xCE35, 0xC615, 0xC635, 0xC635, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xBDF5, 0xC615, 0xC635, 0xCE56, 0xCE36, 0xC635, 0xC615, 0xC635, 0xC636, 0xC636, 0xC636, 0xCE36, 0xCE36, 0xC636,
  0x6C4E, 0x644E, 0x5BEC, 0x53CC, 0x53AB, 0x3B2A, 0x4BAC, 0x5C0D, 0x3B29, 0x53EC, 0x5C2D, 0x642C, 0x6C4D, 0x6C4D, 0x7C8E, 0x94CF, 0xA530, 0xAD30, 0xAD52, 0xA531, 0xB5B4, 0xBD30, 0xD56F, 0xC52F, 0xD56F, 0xDDB0, 0xDE55, 0xD635, 0xE5AF, 0xDD6E, 0xB530, 
        0xC50D, 0xEDEF, 0xDE76, 0xDE77, 0xE5D0, 0xC54E, 0xBDD3, 0x94AD, 0xD54D, 0xE654, 0xDEB8, 0xD5D2, 0xBD51, 0xBD72, 0xC5D3, 0x9C8D, 0xCD91, 0xDE98, 0x8C4E, 0xB572, 0xBD72, 0xC5B3, 0xBD92, 0x94CF, 0xD676, 0xDEB8, 0xD698, 0xD6B9, 0xDEB9, 0xDEB9, 
        0xCE36, 0xAD52, 0xADB4, 0xBDD4, 0xC5D4, 0xCDB3, 0xBD72, 0xB5B4, 0xC591, 0xD5D2, 0xDEB9, 0xDEDA, 0xE613, 0xD56E, 0xB50F, 0xB530, 0xBD93, 0xACF0, 0xB510, 0xD5B0, 0xE5AF, 0xDE55, 0xDEDA, 0xDE77, 0xEDD0, 0xEDCF, 0xD54E, 0xAD30, 0xC636, 0xBD0F, 
        0xEDCF, 0xEDCF, 0xDDF1, 0xDEB9, 0xDEB9, 0xD635, 0xE5D0, 0xEDCF, 0xD54E, 0xB50F, 0xCD6F, 0xE5AF, 0xDD8F, 0xCD71, 0xCE57, 0xC616, 0xBD72, 0xBD30, 0xB510, 0xACF0, 0xACF1, 0xB553, 0xBD93, 0xC5D4, 0xBDB4, 0xBDF6, 0xBDF6, 0xC5F5, 0xD615, 0xDE35, 
        0xDE14, 0xDE13, 0xDE13, 0xDE12, 0xDE13, 0xDEB8, 0xDEFA, 0xDEDA, 0xCE57, 0xD5F2, 0xDDF2, 0xD613, 0xD634, 0xD635, 0xD635, 0xC615, 0xC636, 0xBE16, 0xBDD5, 0xB5B5, 0xB5F6, 0xBE16, 0xBE16, 0xC637, 0xBDF6, 0xB5B5, 0xA511, 0xA552, 0xB5B4, 0xBD72, 
        0xBDF6, 0x94D1, 0xA532, 0x8C6F, 0x94D1, 0xCE77, 0xC550, 0xC5B3, 0xCE78, 0xD699, 0xD615, 0xCE16, 0xAD53, 0xCE15, 0x946F, 0xAD73, 0xD635, 0xDDD1, 0xD698, 0xDED9, 0xDE13, 0xD656, 0xB573, 0xBDD4, 0x8C4F, 0xAD53, 0xCE56, 0xDDD1, 0xDE56, 0xDEFA, 
        0xDE55, 0xDE13, 0xD656, 0xC5F5, 0xB594, 0x94B0, 0xC616, 0xDE14, 0xDDD1, 0xDEB8, 0xDED9, 0xDE13, 0xD636, 0xB5B4, 0xCE36, 0x948F, 0xAD53, 0xD656, 0xE5D0, 0xDE56, 0xDEDA, 0xDE15, 0xCE15, 0xA532, 0xAD52, 0x9490, 0xAD53, 0xD635, 0xD5F2, 0xDED9, 
        0xDE98, 0xD636, 0xCE77, 0xB5B4, 0xBDD5, 0x9CF1, 0xB5B4, 0xDE35, 0xE5F1, 0xDED9, 0xDE97, 0xDE13, 0xBDD5, 0x9CD0, 0x9CF1, 0x8C4E, 0xC616, 0xE633, 0xC50F, 0x3A06, 0x31A5, 0x6206, 0x71E6, 0x61E6, 0x31C5, 0x31E6, 0x39C6, 0x5AC9, 0x31E6, 0x52A8, 
        0x6247, 0x4A67, 0x8C70, 0xAD52, 0x83ED, 0xCE15, 0xE5F1, 0xDE77, 0xDEB8, 0xDE13, 0xC5F5, 0x8C6F, 0xBDD5, 0x94B0, 0xCE36, 0xDDF2, 0xDE76, 0xDEB8, 0xDDF3, 0xC615, 0xB5B4, 0xC636, 0xBDD4, 0xBDB4, 0xBD10, 0xDEB9, 0xDEB8, 0xBD51, 0xAD53, 0xA532, 
        0xA532, 0xA553, 0x9D32, 0xAD11, 0xD677, 0xD676, 0xA48D, 0xAD52, 0xBDD4, 0xC5D4, 0xBDB4, 0xBD92, 0xCDD2, 0xDEB9, 0xDE75, 0xD56F, 0xB530, 0xC5D4, 0xB572, 0xBD71, 0xD52E, 0xD615, 0xD678, 0xDE77, 0xDDAD, 0xE5EC, 0xDDAC, 0xD52A, 0xEE0C, 0xE56A, 
        0xB48A, 0xC5F5, 0xAD94, 0x638B, 0x63AB, 0x8C6F, 0x9D12, 0x9CF1, 0xB510, 0xBD93, 0xD656, 0xD676, 0xD656, 0xCE36, 0xD676, 0xDEB8, 0xE6D9, 0xE6FA, 0xD676, 0xD677, 0xE6FA, 0xDEB9, 0xDEB9, 0xDED9, 0xA532, 0xBDB5, 0xBDD5, 0xCE77, 0xC616, 0xA512, 
        0xA532, 0x94D1, 0x842E, 0xC5D5, 0xCE36, 0x840E, 0x8C4F, 0xA512, 0xBDB4, 0xC5F5, 0xCDF5, 0xDE77, 0xE6FA, 0xE6FA, 0xE71A, 0xE71A, 0xE6FA, 0xE6FA, 0xE6FA, 0xE71B, 0xE71B, 0xE6FB, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xDEBA, 0xB5B5, 
        0x8C70, 0x8C70, 0x94B0, 0x94D1, 0x9470, 0xA512, 0xCE36, 0xDE97, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE77, 0xCE35, 0xC5D3, 0xD655, 0x946E, 0x738C, 0x9CD1, 0xBDD4, 0xC616, 0xC657, 0xC678, 0xBE79, 0xB638, 0xB617, 0xB617, 0xADB5, 
        0x8C91, 0xAD53, 0xBE16, 0xBDD4, 0xDE97, 0xDE97, 0xDE97, 0xE697, 0xE697, 0xE697, 0xE6B7, 0xD656, 0xAD11, 0x9CD0, 0x946F, 0xA512, 0xAD73, 0xAD73, 0xCE36, 0xDE97, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDE97, 0xDEB7, 0xDE97, 0xDE97, 0xE6B7, 0xE6D8, 
        0xEEF8, 0xB571, 0x848D, 0x848D, 0xB571, 0xEEF8, 0xEED8, 0xEED7, 0xEED7, 0xE6D7, 0xE6D7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xE697, 0xE697, 0xE697, 0xE697, 0xE696, 0xE696, 0xDE96, 0xDE76, 0xDE76, 
        0xDE76, 0xD656, 0xD656, 0xD636, 0xCE35, 0xCE35, 0xCE35, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xCE36, 0xCE56, 0xCE56, 0xCE56, 0xC636, 0xC636, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE36, 0xCE56,
  0x9D31, 0x946E, 0x8BA9, 0x93CA, 0x93CA, 0x83AA, 0x83EC, 0x73AC, 0x6B49, 0x9C6D, 0xAC8C, 0xB48C, 0xBD0F, 0xB510, 0xBCAC, 0xCCEC, 0xCCCC, 0xCD2E, 0xD696, 0xD677, 0xD656, 0xDD6F, 0xDD8F, 0xB530, 0xBD0D, 0xEDF0, 0xDE96, 0xD656, 0xDDB0, 0xBD2F, 0xBDB3, 
        0xA4AD, 0xD56E, 0xDE96, 0xD677, 0xCD91, 0xB551, 0xC5B2, 0xBD92, 0xA4AD, 0xD614, 0xDEB8, 0xBD72, 0xB572, 0xBD72, 0xB551, 0xAD31, 0xAD31, 0xBD94, 0x632A, 0xA511, 0xB552, 0xAD31, 0xB551, 0xB572, 0xD697, 0xDEB8, 0xD698, 0xD6B9, 0xDEB9, 0xD6B9, 
        0xCE36, 0xB594, 0x9D32, 0xA553, 0xA532, 0xA552, 0xAD53, 0xA532, 0x9D11, 0xB531, 0xDEB9, 0xDEDA, 0xBD30, 0xACF0, 0xAD94, 0xBD93, 0xC5B3, 0xC572, 0xB572, 0xB593, 0xCD70, 0xD635, 0xDEFA, 0xDE97, 0xDD8F, 0xC52F, 0xB551, 0xBD72, 0xBDB3, 0xACEF, 
        0xCDB1, 0xE5AF, 0xDDD1, 0xDEB9, 0xDEB9, 0xD655, 0xE5D0, 0xDD6E, 0xACAE, 0xC616, 0xBD51, 0xDDAF, 0xEDCF, 0xE5F1, 0xDEB9, 0xDEB9, 0xE612, 0xEDAE, 0xEDEF, 0xD56F, 0xBD51, 0xD570, 0xDD8F, 0xDD6F, 0xCD71, 0xCE36, 0xC616, 0xC572, 0xC550, 0xC551, 
        0xBD51, 0xBD51, 0xC572, 0xC593, 0xBD93, 0xB594, 0xBDD6, 0xBDD6, 0xC616, 0xCDF4, 0xD5F4, 0xD614, 0xDE34, 0xDE13, 0xDDF3, 0xD636, 0xD6B9, 0xDED9, 0xDE98, 0xDE13, 0xDE13, 0xDE14, 0xDE14, 0xD614, 0xD614, 0xD614, 0xCE77, 0xCE57, 0xC616, 0xBDD5, 
        0xBDF5, 0xC616, 0xBDF5, 0xB5D5, 0xB5B5, 0xB5D5, 0xA532, 0xAD53, 0xB5B5, 0xBDF6, 0xBDB4, 0xB5D5, 0x9CF1, 0xA532, 0x8C6F, 0xA532, 0xCE36, 0xC571, 0xCE36, 0xD698, 0xD5F3, 0xCE36, 0xAD32, 0xB594, 0x7C0D, 0xAD73, 0xD676, 0xDDD1, 0xDE56, 0xDEFB, 
        0xDE55, 0xDE34, 0xBDD4, 0xAD52, 0xA4F1, 0x8C6F, 0xC636, 0xDE34, 0xDDD1, 0xDEB8, 0xDED9, 0xDE13, 0xD636, 0xB593, 0xC616, 0x94B0, 0xAD73, 0xD656, 0xE5D1, 0xDE56, 0xDEDA, 0xD614, 0xD656, 0xBDD4, 0xC615, 0x946F, 0xB573, 0xD635, 0xD5F3, 0xDED9, 
        0xDE98, 0xCE36, 0xCE57, 0xB573, 0xB573, 0x8C6F, 0xB594, 0xDE35, 0xE5F2, 0xDED9, 0xDE97, 0xDE13, 0xC5F5, 0xB593, 0xAD52, 0x9CD0, 0xC5F5, 0xEE33, 0x838A, 0x29A5, 0x31A5, 0x6A07, 0x69A5, 0x59E6, 0x31C5, 0x31E6, 0x31A5, 0x5AA9, 0x31C5, 0x41A5, 
        0x6206, 0x39C5, 0x840E, 0x9D11, 0x8C6F, 0xD656, 0xDDD1, 0xDE77, 0xDEB8, 0xDE13, 0xBDD5, 0x842E, 0xAD52, 0x840D, 0xC5F5, 0xDE12, 0xDE97, 0xDEB8, 0xE634, 0xBDB4, 0x8C4F, 0xC5F5, 0x8C6F, 0xC5F4, 0xCD91, 0xDEB9, 0xDEB8, 0xDE13, 0xC5F5, 0xA512, 
        0xC636, 0xB593, 0xC5F5, 0xCD71, 0xDE77, 0xD676, 0xBD51, 0xB594, 0xAD73, 0xAD73, 0xAD53, 0xA512, 0xBD72, 0xDED9, 0xCDF4, 0xA4AF, 0xAD73, 0xB5B4, 0xBDB3, 0xAD73, 0xB551, 0xCE36, 0xD698, 0xDE98, 0xC4EB, 0xCCEB, 0xC551, 0xB551, 0xBD51, 0xC571, 
        0xA48E, 0xA4F0, 0x9CF1, 0x73ED, 0x94B0, 0xAD73, 0xA532, 0x8C4E, 0x9C4D, 0xA4F1, 0xBDB4, 0xC5F5, 0xCE56, 0xCE36, 0xBD93, 0xD677, 0xE6FA, 0xE6D9, 0xE6D9, 0xE6F9, 0xE6F9, 0xE6FA, 0xD698, 0xD697, 0xDED9, 0xBDF5, 0x5B6A, 0x7C4E, 0x7C0D, 0x634A, 
        0x6BAB, 0x6BAB, 0x6B8A, 0x94AF, 0xA512, 0x5B09, 0x4AA8, 0x4AC8, 0x5B09, 0x6BAC, 0x7BED, 0xCDF5, 0xEF1A, 0xE6FA, 0xE71A, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE71B, 0xE71B, 0xE6FB, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xDEBA, 0x9CF2, 0x8450, 
        0x94D2, 0x94D1, 0xAD74, 0xB594, 0xA512, 0x8C70, 0x8C4F, 0xC5F5, 0xDE97, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xD676, 0xCE35, 0xD656, 0x946E, 0x6B8C, 0x9CD1, 0xC615, 0xC615, 0xC616, 0xC658, 0xBE38, 0xB617, 0xB617, 0xB5F6, 0xA554, 
        0x8C91, 0xB5B5, 0xC616, 0xD656, 0xDEB7, 0xDE97, 0xDE97, 0xDEB7, 0xDE97, 0xE6B7, 0xD656, 0x946E, 0x9CD1, 0xAD53, 0xA532, 0xB5B5, 0xBDF6, 0xBDF6, 0xB5B5, 0xCE16, 0xE6B7, 0xDE97, 0xDEB7, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDEB7, 0xDEB7, 0xE6B7, 
        0xE6D7, 0xA52F, 0x8CAE, 0x8CAE, 0xA530, 0xEED7, 0xEED7, 0xEED7, 0xEED7, 0xE6D7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE6B7, 0xE6B7, 0xE697, 0xE696, 0xE696, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 
        0xD656, 0xD656, 0xD656, 0xCE35, 0xCE35, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xC636, 0xCE36, 0xCE56, 0xCE56, 0xCE56, 0xCE36, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE56,
  0xB5D4, 0xB510, 0xB42A, 0xC48B, 0xBC6B, 0xB409, 0x9BEB, 0x7B8A, 0x9C0B, 0xBC6B, 0xC4AB, 0xCCAB, 0xC52E, 0xBD51, 0xBCAC, 0xC4CC, 0xBCAB, 0xBCED, 0xDE97, 0xCE77, 0xD656, 0xCD70, 0xB50F, 0xB572, 0xA4AD, 0xCD6F, 0xDE96, 0xD636, 0xC591, 0xB551, 0xBD72, 
        0xBD72, 0x9CAD, 0xD676, 0xCE56, 0xAD52, 0xAD52, 0xAD31, 0xB551, 0xA510, 0xB592, 0xDEB8, 0xAD10, 0xB551, 0xB572, 0xB572, 0xBD92, 0xC5F4, 0xCE15, 0x8C0C, 0xC592, 0xBDB3, 0xCDF4, 0xBD93, 0xCE35, 0xD697, 0xDEB8, 0xD698, 0xD6B9, 0xDEB9, 0xD6B9, 
        0xCE57, 0xC616, 0xC616, 0xAD73, 0xBE15, 0xBDF6, 0xAD94, 0xB5D5, 0xBD51, 0xC550, 0xDED9, 0xDEDA, 0xBD30, 0xAD31, 0xA553, 0xAD53, 0xA532, 0xA552, 0xA553, 0x9D32, 0xA4F0, 0xC5D4, 0xDF1B, 0xD636, 0xA48E, 0xAD52, 0xB5B4, 0xC5D3, 0xC5D4, 0xC5B3, 
        0xB5B4, 0xBD91, 0xCD91, 0xDEB9, 0xDEB9, 0xD636, 0xBD2F, 0xB530, 0xBD51, 0xCDF4, 0xB4F0, 0xC592, 0xDDB0, 0xE5F1, 0xDEB9, 0xDEDA, 0xE612, 0xEDCF, 0xDD8E, 0xACCE, 0xBE15, 0xBD51, 0xDDB0, 0xEDCF, 0xE5F1, 0xDEB9, 0xDEB9, 0xE5F2, 0xEDCF, 0xEDEF, 
        0xCD4E, 0xBD91, 0xDD8F, 0xE5AF, 0xDD6E, 0xD5B2, 0xCE57, 0xC636, 0xC5F4, 0xCD71, 0xCD71, 0xBD31, 0xB531, 0xBD72, 0xC572, 0xBD72, 0xB594, 0xB5D6, 0xBDB5, 0xC5B4, 0xCDD4, 0xCDF4, 0xD614, 0xDE34, 0xDE14, 0xD614, 0xD677, 0xD699, 0xDEB8, 0xDE34, 
        0xE613, 0xDE33, 0xDE13, 0xDE13, 0xDE13, 0xD5F3, 0xC5D3, 0xC616, 0xC657, 0xCE57, 0xC5F5, 0xBDD4, 0xC5F5, 0xBDF5, 0xBE16, 0xBDF6, 0xBDD5, 0xAD52, 0xB593, 0xB5B4, 0xB594, 0xBDF6, 0xA553, 0xA533, 0x94B0, 0xA532, 0xC616, 0xC551, 0xBDB4, 0xC657, 
        0xD614, 0xD614, 0xC5D4, 0xB552, 0x9CD0, 0x8C6F, 0xCE77, 0xE634, 0xDDD1, 0xDEB9, 0xDED9, 0xDE13, 0xD635, 0xB572, 0xBDD5, 0x840D, 0xAD73, 0xDE56, 0xE5D0, 0xDE56, 0xDEDA, 0xD614, 0xD636, 0xBDB4, 0xC5D5, 0x948F, 0xB594, 0xD635, 0xD5F2, 0xDED9, 
        0xDE98, 0xCE36, 0xCE77, 0xBDD4, 0xC5F5, 0x94B0, 0xB5B4, 0xDE34, 0xDDF2, 0xDED9, 0xDEB7, 0xDE13, 0xC5F5, 0xBDB4, 0xA511, 0x8C4F, 0xC616, 0xB530, 0x3A26, 0x29A5, 0x31C5, 0x6227, 0x59A5, 0x51E6, 0x31C5, 0x29A5, 0x31C5, 0x5AEA, 0x4247, 0x41C6, 
        0x6A48, 0x39A5, 0x5AEA, 0x94B0, 0x9CF1, 0xD656, 0xDDD1, 0xDE77, 0xDEB8, 0xDE13, 0xC5F5, 0x8C2E, 0x9CD1, 0x9490, 0xCE36, 0xDE13, 0xDE77, 0xDEB8, 0xDE13, 0xB552, 0x8C2E, 0xAD53, 0x7BED, 0xC5F4, 0xD592, 0xDEB9, 0xDEB8, 0xDE34, 0xAD32, 0x840D, 
        0xB593, 0x946F, 0xD636, 0xDDF2, 0xDE97, 0xDE77, 0xDE14, 0xBDD4, 0xAD52, 0xBDD4, 0xAD32, 0xD614, 0xD5D2, 0xDED9, 0xDE35, 0xBD72, 0xB594, 0xB5B4, 0xB594, 0xAD73, 0xACF0, 0xCE36, 0xD698, 0xDEB8, 0xD52C, 0xE58C, 0xDDF1, 0xC593, 0xB553, 0xBDD5, 
        0xBD94, 0xBDB4, 0xBDD5, 0xB5B4, 0xAD53, 0x7BEE, 0x842E, 0x73AC, 0xA46B, 0x738A, 0x52E9, 0x73ED, 0xCE57, 0xC616, 0x94CF, 0xC5F4, 0xCE15, 0xCE15, 0xBDD4, 0xC5F4, 0xB593, 0xBDD4, 0xB572, 0xAD31, 0xAD72, 0xAD51, 0x9CF0, 0xA531, 0xB592, 0xC5F4, 
        0xCE35, 0xD656, 0xD677, 0xD676, 0xB593, 0xA4F1, 0x94B0, 0x8C4E, 0x7BED, 0x6B8B, 0x6B6A, 0xC5F5, 0xEF1A, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE71B, 0xE71B, 0xE6FB, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xE73B, 0xAD54, 0x842F, 0x9CF2, 
        0xA533, 0xAD54, 0xAD74, 0xAD95, 0xAD74, 0x94D2, 0x7BEE, 0x8C4F, 0xD656, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xD676, 0xD676, 0xD676, 0xD656, 0xD656, 0x946E, 0x738C, 0x9490, 0xA512, 0xA512, 0xA532, 0xA554, 0xA554, 0xA554, 0xA554, 0xA554, 0x9D13, 
        0x94B1, 0xB5B5, 0xCE57, 0xD677, 0xDE97, 0xDE97, 0xDE97, 0xDEB7, 0xDEB7, 0xDEB7, 0x9CAF, 0x8C2E, 0xAD53, 0xB5B5, 0xB5B5, 0xBE17, 0xBE37, 0xC658, 0xBE16, 0xB594, 0xDE97, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDE97, 0xDE97, 0xE6B7, 
        0xDE97, 0x9CEE, 0x8CAD, 0x8CCE, 0x9CEF, 0xE6B7, 0xEED7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xE696, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 
        0xD656, 0xD655, 0xCE36, 0xCE35, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xC635, 0xC615, 0xC615, 0xC615, 0xC615, 0xC615, 0xC636, 0xC636, 0xC636, 0xCE56, 0xCE56, 0xCE36, 0xC636, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE56,
  0x6BAC, 0x738B, 0x7B69, 0x7B48, 0x8368, 0x7B68, 0x8BEB, 0x736A, 0x83EB, 0x8BA9, 0x8BA9, 0x8BCA, 0x8BEB, 0x7BCB, 0x944D, 0x946D, 0x9CAE, 0xAD30, 0xD697, 0xD677, 0xCE56, 0xB572, 0xB551, 0xC592, 0xB551, 0x94AD, 0xD676, 0xC615, 0xAD52, 0xAD52, 0x9CCF, 
        0xA510, 0xAD30, 0xD656, 0xCE15, 0xACF0, 0xB572, 0xB592, 0xBDB3, 0xBDB2, 0xCE15, 0xDE97, 0xCDB2, 0xC5D3, 0xBDD4, 0xC5F4, 0xBDB2, 0xD655, 0xD677, 0xA4AD, 0xD614, 0xAD31, 0xC5F4, 0x9CCF, 0xCE35, 0xD698, 0xD698, 0xD698, 0xD6B9, 0xDEB9, 0xD6B9, 
        0xCE57, 0xCE57, 0xC5F6, 0x73ED, 0xBDF5, 0xAD94, 0x7C0D, 0xCE57, 0xDE14, 0xDDD2, 0xDEB9, 0xDED9, 0xDDD2, 0xCE15, 0xC616, 0xAD53, 0xC636, 0xBE16, 0xB5D5, 0xBDF5, 0xC550, 0xD615, 0xDF1B, 0xD635, 0xB50F, 0xAD73, 0xAD73, 0xA532, 0xA512, 0xA553, 
        0xA532, 0xA511, 0xA4AF, 0xD698, 0xDEB9, 0xC5F6, 0xAD73, 0xB5B4, 0xC5F4, 0xCE15, 0xC5B3, 0xB5B4, 0xBDB3, 0xCDB2, 0xDEB9, 0xDEDA, 0xE5F2, 0xC52E, 0xBD71, 0xBD71, 0xC5D3, 0xB4F0, 0xC5B3, 0xDDB0, 0xE5F2, 0xDEB9, 0xDEDA, 0xE612, 0xEDCF, 0xD54E, 
        0xACCF, 0xC615, 0xBD50, 0xE5AF, 0xEDCF, 0xE633, 0xDEDA, 0xDEB9, 0xD614, 0xEDCF, 0xEDAE, 0xBD4F, 0xC592, 0xE58F, 0xEDAF, 0xDD8F, 0xD615, 0xCE78, 0xCDF4, 0xD56F, 0xD590, 0xD570, 0xBD10, 0xBD51, 0xBD31, 0xBD51, 0xB552, 0xB594, 0xAD74, 0xAD32, 
        0xB553, 0xBDB4, 0xD635, 0xDE56, 0xDE56, 0xDE14, 0xC5D4, 0xCE57, 0xCE78, 0xD699, 0xDE14, 0xE5F2, 0xE5F2, 0xDDF2, 0xDDF2, 0xDDF2, 0xD5F3, 0xCE57, 0xD678, 0xCE77, 0xCE15, 0xCE15, 0xCE36, 0xC636, 0xC636, 0xBE16, 0xBE16, 0xB5B4, 0xB5B4, 0xB5D5, 
        0xB594, 0xB5D5, 0xB5D5, 0xB593, 0xA532, 0x8C90, 0xB5B5, 0xCDF4, 0xC571, 0xCE77, 0xD6B8, 0xD5F3, 0xCE15, 0xAD32, 0xBDD4, 0x7BED, 0xB5B4, 0xDE56, 0xE5D0, 0xDE56, 0xDEDA, 0xD614, 0xCE15, 0xBD93, 0xB573, 0x7BCD, 0xAD94, 0xD635, 0xDDF2, 0xDED9, 
        0xDEB8, 0xCE36, 0xCE57, 0xB573, 0xB594, 0x948F, 0xB5D5, 0xDE34, 0xDDD1, 0xDEB9, 0xDE97, 0xDE13, 0xC5F5, 0xC5F5, 0xB573, 0x948F, 0xC636, 0x634A, 0x29C5, 0x29C5, 0x31A5, 0x4206, 0x39E5, 0x31C5, 0x29A5, 0x2985, 0x29A5, 0x4A88, 0x4A68, 0x39C6, 
        0x4A07, 0x39E6, 0x31C6, 0x7BED, 0xAD53, 0xCE35, 0xDDD1, 0xDE77, 0xDEB8, 0xDE13, 0xC5F5, 0xAD53, 0xA532, 0xA512, 0xCE36, 0xDDF2, 0xDE77, 0xDEB8, 0xDE34, 0xBD93, 0x8C4E, 0x8C6F, 0x8C4E, 0xCE15, 0xD592, 0xDEB9, 0xDEB8, 0xDE34, 0xA511, 0x7BED, 
        0xAD52, 0x946F, 0xCE35, 0xDDF2, 0xDE97, 0xDE77, 0xDE35, 0x9CD0, 0x946F, 0x946F, 0x8C4E, 0xD635, 0xDE12, 0xDEB9, 0xDE55, 0xD635, 0x9CF1, 0xBDF5, 0xAD73, 0xBDD4, 0xCD71, 0xD635, 0xD678, 0xDEB8, 0xD56B, 0xF68E, 0xFEB0, 0xDDCE, 0xBD51, 0xC5F5, 
        0xC5F5, 0xBDB5, 0x9CD0, 0x842E, 0x842D, 0x636A, 0x638A, 0x6B8A, 0xBD2C, 0x948D, 0x844D, 0x94CE, 0xAD51, 0xB5B3, 0xBDB3, 0xC5D4, 0xC5F4, 0xCE15, 0xCE36, 0xCE14, 0xCDF4, 0xD677, 0xD697, 0xDE97, 0xDEB8, 0xE6D9, 0xEEF9, 0xEF1A, 0xEF3B, 0xF75B, 
        0xEF3A, 0xE6FA, 0xE6FA, 0xDED9, 0xBDF5, 0xBDF5, 0xBDD5, 0xBDB4, 0xBD93, 0xB573, 0xB552, 0xD656, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE71B, 0xE71B, 0xE6FB, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xDED9, 0x844F, 0x9490, 0xA532, 
        0xAD53, 0xB5B5, 0xB5D6, 0xB5D6, 0xA574, 0x9D13, 0x842F, 0x6B8C, 0xB573, 0xDE97, 0xD676, 0xD676, 0xD676, 0xD676, 0xD676, 0xD676, 0xD656, 0xC5F4, 0x946E, 0x946E, 0x9CB0, 0xA512, 0xAD53, 0xAD73, 0xA553, 0xA553, 0xA553, 0xA553, 0x9D13, 0x94D1, 
        0x8C70, 0x9491, 0xC616, 0xD677, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xE6B7, 0xC5F4, 0x7BCC, 0x94B0, 0xAD53, 0xBDF6, 0xBE16, 0xBE37, 0xBE38, 0xB617, 0xB5F6, 0xA553, 0xCE36, 0xE6B7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDE97, 0xDE97, 0xE6B7, 
        0xD655, 0x948D, 0x7C8D, 0x84AD, 0x8C8D, 0xDE55, 0xEED8, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE696, 0xE696, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xD656, 
        0xD655, 0xCE35, 0xCE35, 0xC615, 0xC615, 0xC615, 0xC615, 0xC635, 0xC635, 0xC635, 0xC636, 0xC636, 0xC636, 0xC615, 0xC636, 0xC636, 0xC636, 0xCE36, 0xCE56, 0xCE56, 0xC636, 0xC636, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE56,
  0x83ED, 0x7BEC, 0x738B, 0x6B29, 0x6B49, 0x6B6A, 0x6B69, 0x6B6A, 0x73AB, 0x840C, 0x946E, 0x9CAF, 0xA4F0, 0x9CAF, 0xAD51, 0xB552, 0xB551, 0xB592, 0xD697, 0xD677, 0xBDF5, 0xA531, 0xAD31, 0xA4F0, 0xAD31, 0xA510, 0xD697, 0xC5D4, 0xAD10, 0xB572, 0xB572, 
        0xB592, 0xBDB3, 0xD677, 0xD636, 0xC592, 0xB592, 0xC5F4, 0xB572, 0xC5D3, 0xD656, 0xDE97, 0xDDF3, 0xBD72, 0xA511, 0xB593, 0xA510, 0xD676, 0xD677, 0xB530, 0xD614, 0x9CAF, 0xB572, 0x9CAF, 0xC615, 0xDE98, 0xD698, 0xD698, 0xD6B9, 0xDEB9, 0xD6B9, 
        0xCE57, 0xCE57, 0xB593, 0x73AC, 0xAD73, 0xAD52, 0x73CC, 0xB5D5, 0xDE34, 0xDDF2, 0xDEB9, 0xDED9, 0xDE12, 0xD656, 0xB573, 0x7C0D, 0xCE57, 0x94B0, 0x94D0, 0xCE77, 0xDDD2, 0xDE55, 0xDEFB, 0xDE76, 0xD5F3, 0xCE77, 0xB5B4, 0xBDF5, 0xC636, 0xAD93, 
        0xBDF5, 0xC592, 0xC530, 0xDEB9, 0xD6B9, 0xC5F5, 0xA553, 0xA553, 0xA553, 0xA532, 0xAD53, 0xA552, 0xA512, 0xAD11, 0xDEB9, 0xDEFA, 0xB510, 0x8C2D, 0x9D11, 0xBD93, 0xC5D4, 0xBD92, 0xB594, 0xBD92, 0xCD92, 0xDEB9, 0xDEDA, 0xDDD2, 0xC52F, 0xB571, 
        0xC592, 0xC5D4, 0xB530, 0xC5B2, 0xE5AF, 0xDE13, 0xDEDA, 0xDEB9, 0xDE35, 0xDD8F, 0xC50E, 0xB551, 0xBDB4, 0xCD70, 0xEDCF, 0xE5CF, 0xDE76, 0xDEFB, 0xDE55, 0xEDCF, 0xEDEF, 0xC50D, 0xB551, 0xD5B1, 0xEDCF, 0xE5AF, 0xDDD2, 0xD698, 0xCE36, 0xCD2F, 
        0xCD4F, 0xC54F, 0xB510, 0xB531, 0xC572, 0xC592, 0xB510, 0xB593, 0xB5B5, 0xBDD6, 0xBD94, 0xC5B3, 0xC5B3, 0xCDD4, 0xD5F4, 0xD614, 0xD614, 0xCE77, 0xCE78, 0xD698, 0xDE13, 0xDE13, 0xE633, 0xE633, 0xE634, 0xDE34, 0xDE13, 0xCE35, 0xCE78, 0xCE78, 
        0xCE36, 0xC5D4, 0xCE15, 0xCE36, 0xC636, 0xC616, 0xBDF6, 0xBDD5, 0xAD72, 0xB5B4, 0xB5D5, 0xB594, 0xBDD5, 0xAD53, 0xAD93, 0x94D1, 0xAD74, 0xC616, 0xC571, 0xBDB4, 0xC637, 0xC5D4, 0xCE15, 0xAD32, 0xAD52, 0x73CD, 0xB594, 0xDE35, 0xDDF3, 0xDED9, 
        0xDEB8, 0xCE36, 0xCE56, 0xAD52, 0xB552, 0x842D, 0xBDD5, 0xDE35, 0xDDF2, 0xDED9, 0xDE97, 0xDE13, 0xBDD5, 0xB593, 0xAD32, 0x9CB0, 0xA512, 0x3A06, 0x29C5, 0x29C6, 0x29A5, 0x4A67, 0x5288, 0x29A5, 0x29C5, 0x2984, 0x2964, 0x4A68, 0x5289, 0x29A5, 
        0x4227, 0x4A68, 0x29A5, 0x4A88, 0x9CF1, 0xD636, 0xDDD1, 0xDE77, 0xDEB8, 0xDE13, 0xC5F5, 0xAD53, 0xA532, 0xA512, 0xCE36, 0xDDF2, 0xDE77, 0xDEB8, 0xDE33, 0xBDD4, 0xA532, 0x948F, 0x94D0, 0xCE15, 0xD592, 0xDEB9, 0xDEB9, 0xE654, 0xB573, 0x840D, 
        0x946F, 0x9CB0, 0xD636, 0xDDF2, 0xDE97, 0xDE76, 0xDE35, 0xA4F1, 0x946F, 0x8C6F, 0x9CB0, 0xD614, 0xDE13, 0xDEB9, 0xDE75, 0xCDF4, 0x8C6F, 0xB573, 0x94AF, 0xAD52, 0xD5B2, 0xD635, 0xD698, 0xDEB8, 0xDDCD, 0xFEF0, 0xFF31, 0xFEF0, 0xD5AF, 0xCE16, 
        0xC5F5, 0xBDD5, 0xA4F1, 0xA4F1, 0xC5F4, 0xCE35, 0xCE56, 0xD635, 0xE60F, 0xEEB5, 0xE6F9, 0xE6B8, 0xE6B8, 0xE6D9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xDE97, 0xDE56, 0xE6D9, 0xE6FA, 0xE6D9, 0xE6FA, 0xE6FA, 0xE71A, 0xDED9, 0xAD54, 0x9491, 
        0xC5D6, 0xEF1A, 0xE6FA, 0xE6D9, 0xC616, 0xC5F5, 0xBDF5, 0xBDF5, 0xBDD4, 0xBDD4, 0xBDD4, 0xD677, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE71B, 0xE71B, 0xE6FB, 0xE71B, 0xE71B, 0xE71B, 0xEF3B, 0xC637, 0x7C0E, 0x9CD1, 0xB593, 
        0xB594, 0xB5D5, 0xBE17, 0xAD95, 0x94F2, 0x94B2, 0x7C2F, 0x632B, 0x9CD0, 0xDE97, 0xD676, 0xD676, 0xD676, 0xD676, 0xD676, 0xD676, 0xD636, 0xCE15, 0xA4F0, 0xBD92, 0xCE15, 0xD677, 0xD698, 0xD6B8, 0xD6B8, 0xD699, 0xD6B9, 0xD699, 0xCE78, 0xC637, 
        0xB5D5, 0xB5B5, 0xC616, 0xCE56, 0xDEB7, 0xDE97, 0xDE97, 0xDE97, 0xE6D8, 0xBD93, 0x73AB, 0x94B0, 0xA512, 0xB5B5, 0xB5D6, 0xB5D6, 0xADD6, 0xADB6, 0xADB5, 0x9CF2, 0xCE15, 0xE6D8, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDE97, 0xE6B8, 
        0xC614, 0x8C6D, 0x7C8D, 0x84CE, 0x848D, 0xCE14, 0xEED8, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE697, 0xE697, 0xE697, 0xDE96, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xD675, 0xD655, 
        0xD655, 0xCE35, 0xCE15, 0xC615, 0xC615, 0xC615, 0xC615, 0xC635, 0xC635, 0xC635, 0xC636, 0xCE36, 0xCE56, 0xCE36, 0xC636, 0xC636, 0xC636, 0xCE36, 0xCE56, 0xCE36, 0xC636, 0xCE36, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE56,
  0xA511, 0x840D, 0x738B, 0x8C4E, 0x8C4E, 0x8C2E, 0x7BCC, 0x7BCC, 0x946E, 0xA4F0, 0xAD51, 0xB572, 0xBDB3, 0xBDB3, 0xC5F4, 0xCE35, 0xCE55, 0xCE56, 0xD697, 0xCE57, 0xBDB3, 0xAD10, 0xB572, 0xBD93, 0xBDB3, 0xC5D3, 0xDE97, 0xCDF5, 0xCDB2, 0xB552, 0xC5F4, 
        0xAD31, 0xC5F4, 0xDE97, 0xD656, 0xCDF3, 0xA4F0, 0xB572, 0x9CF0, 0xBD92, 0xDE76, 0xDE77, 0xDDF3, 0xB572, 0x9CD0, 0xAD32, 0xA511, 0xD635, 0xD677, 0xB510, 0xCE14, 0x9CF1, 0xA511, 0x946E, 0xC5F4, 0xD698, 0xD698, 0xD698, 0xDEB9, 0xDEB9, 0xD699, 
        0xCE57, 0xC616, 0xB5B4, 0x842E, 0x9D12, 0xA532, 0x844E, 0xB5D5, 0xD613, 0xDDF2, 0xDEB9, 0xDED9, 0xDDF2, 0xD676, 0x9CF2, 0x73CD, 0xBDF5, 0x73CC, 0x842E, 0xCE56, 0xDDF2, 0xDE76, 0xDEFB, 0xDE76, 0xDE13, 0xCE77, 0x842E, 0xAD73, 0xB5B4, 0x7BEC, 
        0xC636, 0xDE34, 0xDDF2, 0xDED9, 0xDEB9, 0xCE36, 0xCE57, 0xB5D4, 0xB594, 0xCE77, 0xB5B4, 0xB5F5, 0xC5B3, 0xCD70, 0xDEB9, 0xDEFA, 0xC550, 0x5266, 0x52C8, 0xAD73, 0xA553, 0xAD73, 0xA552, 0x9CF1, 0xB510, 0xDEB9, 0xDEDA, 0xACF0, 0x9CF1, 0xAD73, 
        0xB572, 0xB552, 0xBD93, 0xB5B4, 0xBD72, 0xCDD3, 0xDEFA, 0xDEB9, 0xCE15, 0xB551, 0xC5B3, 0xCDF4, 0xC5B3, 0xBD72, 0xCDB2, 0xDDB0, 0xDE76, 0xDEFB, 0xE655, 0xEDAF, 0xCD4F, 0xACCF, 0xBDB4, 0xBD51, 0xDDB0, 0xEDCF, 0xE5F2, 0xDEDA, 0xDE97, 0xEDD0, 
        0xF5F0, 0xE58F, 0xB550, 0xC5D3, 0xDD8F, 0xEDCF, 0xD50D, 0xC5D3, 0xCE78, 0xD678, 0xCD91, 0xD56F, 0xD590, 0xCD70, 0xC550, 0xC550, 0xC551, 0xB551, 0xB5B4, 0xB5D5, 0xBD93, 0xC5B3, 0xC5B3, 0xC5D4, 0xCDD4, 0xCDD4, 0xCDF4, 0xCE15, 0xC637, 0xCE99, 
        0xD656, 0xD5F3, 0xDE13, 0xDE33, 0xDE33, 0xE633, 0xE613, 0xDE13, 0xD677, 0xD698, 0xD698, 0xCE15, 0xCE14, 0xCE15, 0xCE15, 0xCE35, 0xC615, 0xC616, 0xBDF5, 0xBDF5, 0xBE16, 0xB5D5, 0xB5D5, 0xB594, 0xAD74, 0x9D32, 0xB594, 0xC5F5, 0xB552, 0xBDF6, 
        0xBDF6, 0xBDF5, 0xCE57, 0xA532, 0xAD32, 0x842E, 0xB5D5, 0xDE35, 0xD5B1, 0xD699, 0xDE77, 0xDE13, 0xBDB4, 0xB573, 0x9CD0, 0x8C4F, 0x6B6B, 0x29A4, 0x29A5, 0x31E6, 0x29A5, 0x5AE9, 0x4247, 0x31C6, 0x3A07, 0x3206, 0x31C5, 0x4227, 0x4247, 0x31A6, 
        0x39E6, 0x4A68, 0x31C6, 0x3A06, 0x9490, 0xD636, 0xDDD1, 0xDE97, 0xDEB8, 0xDE13, 0xC5F5, 0xB594, 0xA552, 0xA532, 0xCE36, 0xDDF2, 0xDE77, 0xDEB8, 0xDE33, 0xBDD4, 0xAD52, 0x9CD0, 0x9CD1, 0xCE15, 0xCD91, 0xDEB9, 0xDEB8, 0xDE34, 0xBDD4, 0xAD52, 
        0x9CD0, 0xA511, 0xD656, 0xDDF2, 0xDE98, 0xDE77, 0xDE35, 0xAD53, 0x946F, 0x842E, 0xAD32, 0xD614, 0xDDF3, 0xDEB9, 0xDE55, 0xCE15, 0x9490, 0xAD12, 0x9CB0, 0xB573, 0xD5B2, 0xD636, 0xD698, 0xDE98, 0xDDAC, 0xF6CF, 0xF6D0, 0xF6F0, 0xDD6B, 0xBCEF, 
        0xB553, 0xBD94, 0xBD73, 0xCDF5, 0xE6FA, 0xE71A, 0xDE97, 0xDDB0, 0xE58C, 0xE610, 0xE675, 0xE6D9, 0xE6F9, 0xE6FA, 0xE6FA, 0xE6FA, 0xE71A, 0xEF3B, 0xEEFA, 0xD614, 0xCDB3, 0xDE98, 0xE6FA, 0xE6FA, 0xE6FA, 0xE71A, 0xDED9, 0x844F, 0x31E6, 0x2123, 
        0x2964, 0xB574, 0xEF3B, 0xE6F9, 0xCE56, 0xC616, 0xBDF5, 0xBDF5, 0xBDD5, 0xBDD5, 0xC5D5, 0xD677, 0xE6FA, 0xE6FA, 0xE6FA, 0xD677, 0xE6D9, 0xE6FA, 0xE6FA, 0xE71B, 0xE71B, 0xE6FB, 0xE71B, 0xE71B, 0xE71B, 0xEF3B, 0xBDD6, 0x7BCD, 0x94B0, 0xA512, 
        0x9CF1, 0x9D12, 0x9D33, 0x94F2, 0x8C91, 0x8430, 0x73EE, 0x632B, 0x8C4F, 0xDE77, 0xD676, 0xD676, 0xD676, 0xD676, 0xD676, 0xD676, 0xCE36, 0xCE35, 0xA4CF, 0xAD31, 0xC5D4, 0xC5F5, 0xCE36, 0xC636, 0xC616, 0xBDF6, 0xC616, 0xBDF6, 0xBDF6, 0xBDF6, 
        0xB5B5, 0xBDD5, 0xC5F6, 0xCE36, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDEB7, 0xA4D0, 0x738B, 0x8C4E, 0x94B0, 0x94D1, 0x94B1, 0x94D2, 0x94F2, 0x94F2, 0x94D1, 0x8C70, 0xAD32, 0xDE97, 0xE6B7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xE6D8, 
        0xBDD3, 0x848D, 0x746D, 0x84AE, 0x848D, 0xC5D3, 0xEED8, 0xE6D7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xE696, 0xE696, 0xE696, 0xDE96, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xD655, 0xD655, 
        0xCE35, 0xCE35, 0xC615, 0xC615, 0xC615, 0xC615, 0xC635, 0xC635, 0xC636, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xC636, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE36, 0xCE56, 0xCE76, 0xCE76, 0xCE76, 0xCE56, 0xCE76, 0xCE76,
  0xAD52, 0x73AC, 0x6B6B, 0xAD32, 0xA511, 0x9CF1, 0x9490, 0x8C6F, 0xA511, 0xB572, 0xBDD4, 0xBDF5, 0xC615, 0xBDD3, 0xCE15, 0xD635, 0xD635, 0xD635, 0xD697, 0xCE56, 0xC5D4, 0xBD72, 0x9CCF, 0xB572, 0xA4F0, 0xCE14, 0xDE97, 0xD635, 0xD5F3, 0x948F, 0xA4F0, 
        0x9CCF, 0xBDB3, 0xDE97, 0xD656, 0xCDF3, 0xA511, 0xB572, 0xA511, 0xAD51, 0xD676, 0xDE97, 0xD5F3, 0xBD93, 0x9CD0, 0x9CAF, 0x9CAF, 0xD635, 0xCE57, 0xB551, 0xCDF4, 0xA511, 0x948F, 0x9CD0, 0xC615, 0xD698, 0xD698, 0xD698, 0xD6B9, 0xDEB9, 0xD699, 
        0xCE57, 0xC616, 0xB5B4, 0x94B0, 0x9D12, 0x9CF1, 0x9CF1, 0xBDF5, 0xD5F3, 0xDDF2, 0xDED9, 0xDED9, 0xDDD2, 0xD636, 0xA532, 0x7BED, 0xB5B4, 0x7C0E, 0x8C8F, 0xCE36, 0xDDD1, 0xDE76, 0xDEFB, 0xDE76, 0xD5F3, 0xC636, 0x7C0D, 0xAD53, 0x9CF1, 0x6B8B, 
        0xBDD5, 0xDE54, 0xDDF2, 0xDED9, 0xDEB9, 0xCE57, 0xCE78, 0x8C6F, 0x94B0, 0xC616, 0x73CC, 0xAD93, 0xDE55, 0xDDF2, 0xDED9, 0xDED9, 0x940B, 0x4204, 0x4226, 0xAD73, 0xD698, 0xA532, 0xBDF5, 0xCDF4, 0xD591, 0xDED9, 0xDED9, 0xCD92, 0xB593, 0xAD93, 
        0xAD73, 0xAD73, 0xAD73, 0xA553, 0xA4F1, 0xBD72, 0xDEFA, 0xD699, 0xBDD5, 0xA553, 0xAD73, 0xAD73, 0xB572, 0xB573, 0xAD53, 0xB551, 0xCE36, 0xDF1B, 0xD614, 0xBD0E, 0xBDB3, 0xC593, 0xCDF5, 0xBD92, 0xBDD4, 0xD5B1, 0xDDF2, 0xDEDA, 0xE697, 0xEDD0, 
        0xDD8F, 0xBD0F, 0xBD93, 0xBDD4, 0xBD50, 0xE5D0, 0xDD2D, 0xCDF4, 0xD6DA, 0xDED9, 0xE612, 0xEDCF, 0xD56F, 0xBD70, 0xD5D1, 0xEDCF, 0xEDAF, 0xDDF2, 0xD698, 0xD698, 0xDDB0, 0xDD8F, 0xDD8F, 0xD56F, 0xD570, 0xD590, 0xD590, 0xC550, 0xBDB4, 0xBDF6, 
        0xB593, 0xBD72, 0xC592, 0xC593, 0xC593, 0xC5B3, 0xC5B3, 0xC5D3, 0xC5F5, 0xC637, 0xCE58, 0xD615, 0xDE13, 0xDE13, 0xDE14, 0xDE33, 0xE633, 0xE633, 0xDE76, 0xDEB9, 0xD6B9, 0xD635, 0xD5F3, 0xDE34, 0xD635, 0xD655, 0xCE15, 0xC5F5, 0xBDF5, 0xBDF6, 
        0xBDF5, 0xBDF5, 0xBE16, 0xB5B5, 0xB594, 0xAD73, 0xAD95, 0xBDF5, 0xB572, 0xBDD5, 0xBDF5, 0xC5D4, 0xB594, 0xA512, 0x94B0, 0x7BCC, 0x3A05, 0x31E6, 0x29A5, 0x29A5, 0x31C5, 0x52A9, 0x39E6, 0x29C5, 0x31E6, 0x4268, 0x31E6, 0x39E6, 0x52A8, 0x29A5, 
        0x29A6, 0x4A68, 0x3A07, 0x31E6, 0x5AEA, 0xD635, 0xDDD1, 0xDE97, 0xDEB8, 0xDDF3, 0xC5F5, 0xB594, 0xAD52, 0xA532, 0xCE36, 0xDDF2, 0xDE77, 0xDEB8, 0xDE34, 0xC5F5, 0xB5B4, 0x9CB0, 0x94B0, 0xCE15, 0xD5B1, 0xDEB9, 0xDEB8, 0xDE34, 0xBDB4, 0xAD52, 
        0x948F, 0xA511, 0xD656, 0xDDF2, 0xDE98, 0xDE76, 0xDE34, 0xBDB4, 0xAD32, 0x948F, 0xAD53, 0xD614, 0xDDF2, 0xDEB9, 0xDE55, 0xD614, 0xB573, 0xAD52, 0xA4F1, 0xBDB4, 0xD5B1, 0xD636, 0xD678, 0xDE97, 0xD56C, 0xBC66, 0xA3C5, 0x9BA5, 0xABC5, 0xBCEE, 
        0xB553, 0xA4D1, 0xB552, 0xCDF5, 0xEF1B, 0xCDF4, 0xBC68, 0xE58A, 0xF68E, 0xFEF0, 0xF6B0, 0xE632, 0xE6D9, 0xE6FA, 0xE6FA, 0xE6FA, 0xCE57, 0xAD32, 0x94B0, 0xACF0, 0xDE76, 0xE71A, 0xE6FA, 0xE6DA, 0xE6FA, 0xE71A, 0xB594, 0x5B2B, 0x4268, 0x3A07, 
        0x2144, 0x5AA9, 0xE6FA, 0xE6F9, 0xCE36, 0xC5F5, 0xBDF5, 0xBDD5, 0xBDD5, 0xBDD5, 0xC5D5, 0xD677, 0xE6FA, 0xE6FA, 0xE6FA, 0xD657, 0xDED9, 0xE6FA, 0xE6FA, 0xE71B, 0xE71B, 0xE6FB, 0xE71B, 0xE71B, 0xE71B, 0xDEFA, 0xA511, 0x946F, 0xA512, 0xAD53, 
        0xB593, 0xB594, 0xB594, 0xAD94, 0xAD53, 0x9CF2, 0x94B1, 0x842F, 0x7BAD, 0xC5B4, 0xD677, 0xD676, 0xD676, 0xD676, 0xD677, 0xD677, 0xCE15, 0xC5D4, 0xAD11, 0xBD93, 0xAD32, 0xCE16, 0xD697, 0xD698, 0xB594, 0x9490, 0xCE57, 0xCE57, 0xC637, 0xA533, 
        0xB5B5, 0xB5B5, 0xBDF6, 0xCE36, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xB552, 0xA4F1, 0xB594, 0xBDD5, 0xBE16, 0xC637, 0xC658, 0xC657, 0xC637, 0xBDF6, 0xAD94, 0xB593, 0xDE97, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xE6D8, 
        0xAD51, 0x846D, 0x84AE, 0x8CAE, 0x744D, 0xAD51, 0xEED8, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE696, 0xE696, 0xE696, 0xDE96, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xD656, 0xD655, 0xD655, 
        0xCE35, 0xCE35, 0xC635, 0xC615, 0xC615, 0xC636, 0xC636, 0xCE36, 0xCE36, 0xD676, 0xD676, 0xCE56, 0xCE56, 0xD676, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE76, 0xCE77, 0xCE76, 0xCE76, 0xCE77, 0xD677, 0xD677, 0xCE77, 0xCE76, 0xCE76,
  0x9CB0, 0x6B4B, 0x7329, 0xB4AE, 0xACAE, 0xACAF, 0x9CAF, 0x842D, 0xA4CF, 0xB510, 0xBD30, 0xC550, 0xC5B3, 0xA4EF, 0xBD0F, 0xCD2F, 0xC52F, 0xBD50, 0xD697, 0xCE57, 0xCDF5, 0xBD72, 0x946E, 0xA4F0, 0x9CAF, 0xC5F4, 0xDE97, 0xD635, 0xCDD3, 0x9CD0, 0x9CB0, 
        0x9CAF, 0xB572, 0xD697, 0xD656, 0xCDD3, 0xAD31, 0x9CD0, 0x946E, 0xAD10, 0xD676, 0xDE97, 0xD5F3, 0xBD93, 0x948F, 0x946E, 0xB572, 0xD656, 0xB574, 0xB531, 0xD615, 0xAD52, 0x9CD0, 0xAD72, 0xC635, 0xD698, 0xD697, 0xD698, 0xDEB9, 0xDEB9, 0xD6B9, 
        0xCE57, 0xC616, 0xB5B4, 0xAD53, 0xB5B5, 0xA512, 0xA552, 0xC636, 0xDDF3, 0xE612, 0xDED9, 0xDEB9, 0xDDF2, 0xD656, 0xB5B4, 0x94F1, 0xB594, 0x7C0E, 0x94D1, 0xCE56, 0xDDD2, 0xDE76, 0xDEFB, 0xDE76, 0xD5F3, 0xCE56, 0x842E, 0xA532, 0xA532, 0x7C0E, 
        0xB5D5, 0xD614, 0xDDF2, 0xDED9, 0xDEB9, 0xCE57, 0xCE78, 0x844E, 0x94B0, 0xB594, 0x634A, 0xA553, 0xDE35, 0xDDF2, 0xDED9, 0xE6FA, 0x8BAB, 0x3183, 0x52A8, 0x8C6F, 0xBDF5, 0x73AC, 0xAD73, 0xDE56, 0xDDF2, 0xDED9, 0xDED9, 0xDE13, 0xD677, 0xB574, 
        0xAD52, 0xCE77, 0x94D0, 0xC636, 0xD5F3, 0xDDF2, 0xDEFA, 0xD698, 0xC5F6, 0xB5B4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB594, 0xAD53, 0xACF0, 0xCE16, 0xE71B, 0xBD72, 0x94AF, 0xA532, 0xA512, 0xA512, 0xA532, 0xA533, 0xAD52, 0xB552, 0xDEDA, 0xE697, 0xC50E, 
        0xB531, 0xC5D4, 0xCDF4, 0xCDD4, 0xBD93, 0xC5B2, 0xCD0D, 0xCDF4, 0xD6DA, 0xDED9, 0xE5F2, 0xC50E, 0xB592, 0xBE16, 0xB5B4, 0xCDB2, 0xEDAF, 0xDDF2, 0xDEB9, 0xDED9, 0xE5F1, 0xEDEF, 0xDD6E, 0xBD30, 0xCDB2, 0xE5D0, 0xEDCF, 0xE5B0, 0xDE77, 0xDEDA, 
        0xDE35, 0xE5AF, 0xE5CF, 0xE5AF, 0xD56F, 0xDD6F, 0xDD90, 0xD56F, 0xC551, 0xC616, 0xC616, 0xB552, 0xB531, 0xB552, 0xB552, 0xB572, 0xB573, 0xB552, 0xB593, 0xB594, 0xC616, 0xCE36, 0xDE35, 0xDE34, 0xDE33, 0xE633, 0xE613, 0xDE34, 0xDEB9, 0xDEFA, 
        0xDEB8, 0xCE15, 0xDDF3, 0xDE13, 0xDE34, 0xDE34, 0xD635, 0xCE35, 0xCE57, 0xC636, 0xC636, 0xC616, 0xC616, 0xC616, 0xC636, 0x630A, 0x2163, 0x29E5, 0x3A06, 0x31C6, 0x29C5, 0x6B2A, 0x39E6, 0x29A5, 0x31E6, 0x4268, 0x31E6, 0x2985, 0x4A68, 0x29A5, 
        0x29A6, 0x4227, 0x4A88, 0x31C6, 0x3A07, 0xB531, 0xE612, 0xDE77, 0xE6B8, 0xDE13, 0xC615, 0xBDD4, 0xBDB3, 0xAD52, 0xCE36, 0xDDF2, 0xDE77, 0xDEB8, 0xDE34, 0xC5D4, 0xAD73, 0x94D0, 0x9CD0, 0xCE15, 0xCD91, 0xDEB9, 0xDEB8, 0xDE14, 0xBDD4, 0xBD93, 
        0x9CB0, 0xA531, 0xCE35, 0xDDF2, 0xDE98, 0xDE76, 0xDE14, 0xBDB4, 0xAD52, 0x842E, 0xB573, 0xD614, 0xDDF3, 0xDEB9, 0xDE55, 0xCDF4, 0xB573, 0xAD52, 0xA4F1, 0xBDB4, 0xCD91, 0xD636, 0xCE78, 0xDE77, 0xDE0E, 0xE60D, 0xE5CD, 0xE5ED, 0xCCEA, 0x93A9, 
        0x8BED, 0x9C6F, 0xACF1, 0xCDF5, 0xE6D9, 0xB46C, 0xCC67, 0xF62B, 0xFF51, 0xFF52, 0xFF52, 0xEE2E, 0xDE76, 0xE6FA, 0xE6FA, 0xC616, 0x73AD, 0x52A8, 0x2943, 0x41A3, 0x93EB, 0xDEB9, 0xE6FA, 0xE6DA, 0xE6FA, 0xE6FA, 0x9D12, 0x73EE, 0x5B2B, 0x4AA9, 
        0x3A27, 0x4A47, 0xDE98, 0xE6FA, 0xCE36, 0xC5F5, 0xBDF5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xD677, 0xE6FA, 0xE6FA, 0xE6FA, 0xD677, 0xDED9, 0xE6FA, 0xE6FA, 0xE71B, 0xE71B, 0xE6FB, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xD657, 0xCE15, 0xD677, 0xD677, 
        0xD678, 0xCE78, 0xCE78, 0xC637, 0xBDF6, 0xB5D5, 0xB5B5, 0xAD33, 0xAD53, 0xD677, 0xD656, 0xD656, 0xD676, 0xD677, 0xD677, 0xD656, 0xCE35, 0xBD93, 0xA4F0, 0xCE15, 0xA4D0, 0xCE16, 0xDEB9, 0xDED9, 0xAD53, 0x840E, 0xDEB9, 0xD6D9, 0xD6B9, 0xA512, 
        0xCE37, 0xBE16, 0xBDF6, 0xCE36, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDEB8, 0xC5F5, 0xAD32, 0xB5B4, 0xB594, 0xB5B5, 0xBDF6, 0xBDF6, 0xBE16, 0xC637, 0xC637, 0xBE16, 0xCE56, 0xE6B7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDE97, 0xE6B8, 
        0x9D0F, 0x844D, 0xA4EF, 0x948E, 0x744D, 0x9D10, 0xEEB7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xDE96, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE76, 0xDE56, 0xD655, 0xD655, 0xCE55, 
        0xCE35, 0xC635, 0xC635, 0xC635, 0xC636, 0xC636, 0xC636, 0xCE36, 0xCE56, 0xD677, 0xD677, 0xD677, 0xD676, 0xD676, 0xD677, 0xCE76, 0xCE56, 0xCE56, 0xCE56, 0xCE77, 0xD677, 0xD677, 0xD677, 0xD677, 0xD697, 0xD697, 0xD697, 0xD697, 0xD697,
  0x946F, 0x7329, 0x8307, 0xABA8, 0xABA8, 0xA388, 0x940B, 0x8C2D, 0x9C4D, 0xAC8D, 0xB510, 0xB4EF, 0xB531, 0xA4CF, 0xACEF, 0xBD92, 0xC5B3, 0xC5D4, 0xD677, 0xCE56, 0xCE15, 0xBD72, 0x9CD0, 0xA4F1, 0x9CB0, 0xBDD3, 0xD697, 0xD615, 0xCDB3, 0xA4F1, 0x8C4E, 
        0x8C2D, 0xB572, 0xDE97, 0xD656, 0xCDD3, 0xB572, 0x946E, 0x9CCF, 0xB572, 0xD676, 0xDE97, 0xD5F3, 0xC5D4, 0x9CF1, 0xA4F0, 0xBDB3, 0xD615, 0xA532, 0xACEF, 0xD615, 0xAD73, 0xA531, 0xB572, 0xC615, 0xD698, 0xD698, 0xD698, 0xD6B9, 0xD6D9, 0xD6B9, 
        0xCE57, 0xC616, 0xB5B4, 0xAD74, 0xBDF5, 0xAD94, 0xAD73, 0xBE16, 0xDDF3, 0xDE12, 0xDED9, 0xDEB9, 0xDDF2, 0xD656, 0xBDF6, 0xB5B4, 0xBE16, 0x8C90, 0xA552, 0xCE56, 0xDDF1, 0xDE76, 0xDEFA, 0xDE56, 0xDE13, 0xD677, 0xA532, 0xB5B4, 0xA532, 0x8C6F, 
        0xC616, 0xDE14, 0xDDF2, 0xDEDA, 0xDEB9, 0xCE57, 0xCE57, 0x9490, 0x8C6F, 0xA553, 0x6BCC, 0xAD93, 0xD635, 0xDDF2, 0xDEFA, 0xD698, 0x734A, 0x31A4, 0x738C, 0x94D0, 0xB594, 0x738C, 0xAD73, 0xDE35, 0xE612, 0xDEDA, 0xDED9, 0xDE33, 0xD657, 0x842E, 
        0x9CD1, 0xB5B4, 0x73AC, 0xBDD5, 0xDE34, 0xE633, 0xDEFA, 0xDE99, 0xCE56, 0xC636, 0x94B0, 0xC616, 0xBDF5, 0xB594, 0xCE57, 0xDDD2, 0xDE77, 0xDEFB, 0xD614, 0xC5B3, 0xB5B4, 0xAD94, 0xB5B4, 0xAD73, 0xA552, 0xAD11, 0x8BEC, 0xC657, 0xDE77, 0xA46D, 
        0xA532, 0xAD52, 0xAD53, 0xAD73, 0xB573, 0xAD53, 0xACF0, 0xBDD4, 0xDEDA, 0xDED9, 0xB510, 0xB572, 0xC636, 0xCE57, 0xC636, 0xBDF5, 0xD5B2, 0xD5D2, 0xDEB9, 0xE6D9, 0xE5D1, 0xCD4E, 0xB551, 0xBE15, 0xB5D5, 0xC5D3, 0xE5D0, 0xE5CF, 0xDE77, 0xDEFA, 
        0xE655, 0xEDCF, 0xE5CF, 0xCD4F, 0xBD71, 0xD5B1, 0xEDCF, 0xEDCF, 0xDDD1, 0xDEB8, 0xDEB8, 0xE5F1, 0xE5AF, 0xE5B0, 0xD56F, 0xD56F, 0xDD8F, 0xD56F, 0xC52F, 0xBDB4, 0xBDF6, 0xBD73, 0xC572, 0xCDB3, 0xC5B3, 0xC5D4, 0xCDD4, 0xCDD4, 0xBDB4, 0xBDF6, 
        0xBDF6, 0xC5F5, 0xD614, 0xD614, 0xDE34, 0xDE14, 0xDE13, 0xD614, 0xD677, 0xD699, 0xDE98, 0xDE34, 0xE654, 0xE675, 0xC592, 0x4247, 0x29C5, 0x29A5, 0x31E5, 0x29C5, 0x31C5, 0x4A67, 0x31E5, 0x3A06, 0x3A06, 0x4266, 0x3A25, 0x4A86, 0x83EA, 0x5286, 
        0x4226, 0x39E6, 0x4A88, 0x31C6, 0x31C5, 0x7BCC, 0xC550, 0xBDD4, 0xCE36, 0xD5F4, 0xC616, 0xB594, 0xB573, 0xA532, 0xD656, 0xDDF2, 0xDE97, 0xE6D8, 0xE634, 0xC5F5, 0xB593, 0x8C8F, 0x94B0, 0xCE35, 0xCD91, 0xDEB9, 0xDEB9, 0xDE34, 0xBDB4, 0xB552, 
        0x94AF, 0xA532, 0xD656, 0xDDF2, 0xDE98, 0xDE76, 0xDE14, 0xBDD4, 0xB573, 0x8C6F, 0xB5B4, 0xD614, 0xDDF3, 0xDEB9, 0xDE55, 0xCDF4, 0xB5B4, 0xB5B4, 0xA4F1, 0xBDB4, 0xCD91, 0xD636, 0xD678, 0xDE97, 0xEE4E, 0xE651, 0xCE15, 0xD614, 0xD5F4, 0xACEF, 
        0x62C9, 0x4A26, 0x732A, 0x946F, 0xC5D5, 0x8327, 0x9324, 0xB406, 0xCD09, 0xC54B, 0xD58B, 0xC4E9, 0xDE35, 0xE71B, 0xDEB9, 0x8C90, 0x634B, 0x39E6, 0x2964, 0x6AC7, 0x7307, 0x9490, 0xEF1B, 0xE6DA, 0xE6FA, 0xDED9, 0xA553, 0x8470, 0x6B8D, 0x530A, 
        0x4A68, 0x4A68, 0xDE98, 0xE6FA, 0xCE36, 0xC5F5, 0xBDF5, 0xBDD5, 0xBDD5, 0xBDD5, 0xC5F5, 0xD677, 0xE6FA, 0xE6FA, 0xE6FA, 0xDEB8, 0xE6DA, 0xE6FA, 0xE6FA, 0xE71B, 0xE71B, 0xE6FB, 0xE71B, 0xE71B, 0xE71B, 0xE71B, 0xCE57, 0xB573, 0xBDB4, 0xC5F5, 
        0xC5F6, 0xBDD5, 0xAD53, 0xBDF6, 0xB5B5, 0xAD74, 0x9CD1, 0x9CB1, 0x9CB0, 0xCE56, 0xD676, 0xD656, 0xD676, 0xD676, 0xD677, 0xCE15, 0xC5F5, 0xC5D4, 0xA4D0, 0xCE16, 0xA4F1, 0xC5F5, 0xDEB9, 0xDED9, 0xAD74, 0x842F, 0xDEB9, 0xDEDA, 0xD699, 0x9CF1, 
        0xC637, 0xBE16, 0xB5D5, 0xCE36, 0xDE97, 0xDE97, 0xDE97, 0xDEB8, 0xD697, 0xA511, 0x9CD0, 0x9CB0, 0xB574, 0xB5B4, 0xA532, 0x94B1, 0xBDF6, 0xBE16, 0xA532, 0xA533, 0xBDD5, 0xDEB8, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xE6B7, 0xDE96, 
        0x8C8D, 0x846D, 0x94AE, 0x842D, 0x746D, 0x848E, 0xDE96, 0xE6D7, 0xE6B7, 0xE6B7, 0xDEB7, 0xDEB7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE6B7, 0xE697, 0xDE96, 0xDE96, 0xDE96, 0xDE96, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 0xD656, 0xD656, 0xCE55, 0xCE56, 
        0xCE36, 0xCE36, 0xCE36, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xCE56, 0xD676, 0xD697, 0xD697, 0xD697, 0xD677, 0xD677, 0xD677, 0xD677, 0xD677, 0xCE77, 0xD677, 0xD697, 0xD697, 0xD697, 0xD697, 0xD697, 0xD697, 0xD697, 0xD697, 0xD697, 0xD697,
  0xAD11, 0x9369, 0xA3A9, 0xBC29, 0xBC09, 0xB3E8, 0xA42B, 0x9C4D, 0xA4CF, 0xAD31, 0xB531, 0xBD93, 0xB593, 0xB531, 0xBD92, 0xBD72, 0xBD72, 0xCE15, 0xD697, 0xCE56, 0xCDF5, 0xBD72, 0xA4F1, 0x948F, 0x948F, 0xBDD3, 0xD697, 0xD615, 0xCDD3, 0xAD32, 0x840D, 
        0xA4F0, 0xBDD3, 0xDE97, 0xD656, 0xD5D3, 0xB593, 0x9CF1, 0xAD52, 0xBDB3, 0xD677, 0xDE77, 0xD5F3, 0xC5D4, 0xA511, 0xA511, 0xB592, 0xDE76, 0xAD53, 0x9C6D, 0xD635, 0xAD73, 0x9CD0, 0xAD52, 0xC615, 0xD698, 0xD698, 0xD698, 0xDEB9, 0xDEDA, 0xD6B9, 
        0xD677, 0xC636, 0xBDD4, 0xB573, 0xC615, 0xB572, 0xAD53, 0xC636, 0xDE13, 0xE613, 0xDED9, 0xDEB9, 0xDDF2, 0xD656, 0xB5B5, 0xAD73, 0xBDF5, 0x9CF1, 0xAD73, 0xCE56, 0xE5F1, 0xDE76, 0xDEDA, 0xDE55, 0xDDF3, 0xCE57, 0xC616, 0xC657, 0xAD74, 0x94D1, 
        0xC656, 0xDE14, 0xDDF2, 0xDEDA, 0xD6B9, 0xBDD5, 0xB5D4, 0xA511, 0x948F, 0x7BEC, 0x6BCB, 0xBDF5, 0xDE34, 0xE612, 0xEF3B, 0xC5F6, 0x31C4, 0x29A3, 0x5B09, 0x94D0, 0xAD52, 0x842E, 0xB5B4, 0xD614, 0xDDF2, 0xDEDA, 0xDED9, 0xDDF3, 0xCE16, 0x842E, 
        0x9CD1, 0xAD52, 0x7BED, 0xB5D5, 0xDE34, 0xE634, 0xDEFB, 0xDE98, 0xD677, 0xAD73, 0x632A, 0xB5B4, 0x94B0, 0x94B0, 0xD677, 0xE612, 0xDE97, 0xDEFB, 0xDE55, 0xDE76, 0xA532, 0x9CF1, 0xD698, 0x9CF1, 0xC636, 0xDE35, 0x8BCB, 0xB5D6, 0xE6B7, 0xDDB1, 
        0xC615, 0xB5B4, 0xBDB4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB4AE, 0xC5B4, 0xDEDA, 0xDEB9, 0xAD12, 0xAD73, 0xAD94, 0xAD94, 0xB594, 0xAD73, 0xA532, 0xA4F0, 0xD698, 0xE6B9, 0xB4EF, 0xB572, 0xC616, 0xC657, 0xC636, 0xB5F5, 0xC5B3, 0xD590, 0xDE77, 0xDEFB, 
        0xE655, 0xD56E, 0xB530, 0xBDD4, 0xBE36, 0xBDD4, 0xD5D1, 0xE5AF, 0xDDF1, 0xDEB9, 0xDED9, 0xE611, 0xE5AF, 0xC54F, 0xB571, 0xBD92, 0xDDD0, 0xEDEF, 0xEDCF, 0xDE76, 0xDEDA, 0xE613, 0xEDCF, 0xE5AF, 0xCD4F, 0xD590, 0xE5AF, 0xDD8F, 0xCDB2, 0xC657, 
        0xC616, 0xBD93, 0xCD91, 0xC571, 0xAD31, 0xB551, 0xC572, 0xC592, 0xBD93, 0xBDF6, 0xBDF5, 0xBD92, 0xC5D2, 0xDE33, 0xBD4E, 0x6B27, 0x7BA9, 0x7BA8, 0x83C8, 0x8BE8, 0x9429, 0xBD0B, 0xACAA, 0xB4EB, 0xB4CA, 0xB4CA, 0xB4CA, 0xB4A9, 0xBCA9, 0x9BC8, 
        0x5245, 0x5266, 0x6B09, 0x5267, 0x4206, 0x5287, 0xAD73, 0xBDD5, 0xB5D5, 0xAD94, 0xB5B5, 0xA573, 0xA553, 0xA553, 0xBDF6, 0xBD92, 0xBDB4, 0xC5F5, 0xC5B3, 0xB594, 0x9D11, 0x844E, 0x94B0, 0xCE16, 0xC591, 0xD6B9, 0xDE98, 0xDE34, 0xBDB4, 0xB573, 
        0x8C4E, 0xA532, 0xD656, 0xDDF2, 0xDEB8, 0xE696, 0xDE14, 0xB593, 0xAD32, 0x8C4E, 0xB5B4, 0xD614, 0xDDF3, 0xDEB9, 0xDE55, 0xCDF4, 0xB594, 0xB5B4, 0xA511, 0xBDD4, 0xCD91, 0xD656, 0xCE78, 0xDE97, 0xEE2E, 0xE5EE, 0xC592, 0xB594, 0xC637, 0xB574, 
        0x83CD, 0x9C8F, 0xB552, 0xD656, 0xBD94, 0x62A7, 0x8B48, 0xB44A, 0xCD4D, 0xD5AE, 0xDD8D, 0xC50C, 0xD636, 0xEF1B, 0xBDD5, 0x8450, 0x5B0B, 0x3A06, 0x39E6, 0x7B48, 0x7B68, 0x4A47, 0xD657, 0xE6FA, 0xE6FA, 0xDEB9, 0x9D33, 0x8470, 0x73AD, 0x5B2B, 
        0x4A88, 0x52A8, 0xDE98, 0xE6FA, 0xCE36, 0xBDF5, 0xBDF5, 0xBDD5, 0xBDB4, 0xBDD5, 0xC5D5, 0xD677, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6FA, 0xE6DA, 0xE6FA, 0xE71B, 0xE71B, 0xE71B, 0xEF3C, 0xEF3C, 0xEF3C, 0xEF3C, 0xCE36, 0xAD32, 0xAD11, 0xD677, 
        0xD677, 0xBDB5, 0x842E, 0xC616, 0xC616, 0xBDD5, 0x7BCD, 0xA532, 0x8C4F, 0xB593, 0xD697, 0xD676, 0xD676, 0xD676, 0xD676, 0xD676, 0xCE15, 0xC5B3, 0xA4B0, 0xC615, 0x9CF0, 0xC5D5, 0xD698, 0xDEB9, 0xAD74, 0x842F, 0xDEB9, 0xDEDA, 0xCE78, 0x9490, 
        0xCE57, 0xC616, 0xB5B5, 0xCE36, 0xDEB7, 0xDEB7, 0xDEB7, 0xE6B8, 0xCE56, 0x842E, 0xA511, 0x946F, 0xBDF5, 0xC657, 0xA553, 0x8C90, 0xCE78, 0xCE78, 0xA512, 0xB574, 0xCE36, 0xE6B8, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xE6B7, 0xCE56, 0xBE15, 0x9D71, 
        0x640B, 0x846E, 0xAD93, 0x7C8D, 0x6C8D, 0x53CB, 0xAD73, 0x9D72, 0xC615, 0xE6B8, 0xE6B7, 0xDEB7, 0xE6B7, 0xE6B7, 0xE6B7, 0xDE97, 0xDE97, 0xDE96, 0xDE96, 0xDE96, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 0xD676, 0xD656, 0xD656, 0xD656, 0xCE56, 0xCE56, 
        0xCE56, 0xCE56, 0xD676, 0xD676, 0xD676, 0xD676, 0xD676, 0xD676, 0xD697, 0xD697, 0xDEB7, 0xDEB7, 0xD697, 0xD697, 0xD697, 0xD697, 0xD697, 0xD697, 0xD6B7, 0xD6B7, 0xD6B8, 0xDEB8, 0xD6B8, 0xD6B8, 0xD6B8, 0xDEB8, 0xDEB8, 0xDEB8, 0xDEB8,
  0xB511, 0x9BAA, 0xA3C9, 0xBC4A, 0xBC29, 0xB409, 0xAC4B, 0xA48E, 0xAD10, 0xB4F0, 0xB510, 0xB552, 0xBDB3, 0xBD52, 0xC592, 0xB4EF, 0xB510, 0xB531, 0xD677, 0xCE56, 0xCE15, 0xBD72, 0xAD52, 0x9CB0, 0xA511, 0xC5D4, 0xD677, 0xD615, 0xCDD3, 0xAD52, 0x9CD0, 
        0xA531, 0xC5D3, 0xDE97, 0xD636, 0xD5D3, 0xB593, 0x94B0, 0xA531, 0xBD93, 0xD676, 0xDE77, 0xD5F3, 0xC5D4, 0x9CD1, 0x9CD0, 0xB572, 0xDE76, 0x94B1, 0x942D, 0xD635, 0xAD73, 0xA511, 0xB552, 0xC615, 0xDE98, 0xD698, 0xD6B8, 0xDEB9, 0xDEDA, 0xD6B9, 
        0xCE36, 0xC616, 0xC615, 0xBDD4, 0xCE36, 0xC5D3, 0xB573, 0xC656, 0xDE13, 0xE613, 0xDEDA, 0xDED9, 0xDDF2, 0xD656, 0xAD74, 0xA532, 0xC616, 0x73AC, 0xA532, 0xD677, 0xE5F1, 0xDE97, 0xDEDA, 0xDE55, 0xDE13, 0xCE57, 0xBDF5, 0xC637, 0xB5D5, 0xAD94, 
        0xC636, 0xDE13, 0xDE13, 0xD698, 0xBDD4, 0x5AE7, 0x6B89, 0x94CF, 0x6369, 0x4284, 0x5B27, 0x9D10, 0xD613, 0xDDD2, 0x9490, 0x6BAC, 0x4266, 0x5AE8, 0x52C8, 0xB593, 0xBDB4, 0x8C8F, 0xBE16, 0xDE34, 0xE612, 0xDEDA, 0xDED9, 0xDE13, 0xD656, 0x9CD0, 
        0xA511, 0x9CF1, 0x844E, 0xBDF5, 0xDE14, 0xDE34, 0xDEFA, 0xDEB8, 0xD677, 0xAD73, 0x6B4B, 0xAD53, 0x8C6F, 0x94D0, 0xCE56, 0xDDF2, 0xDE97, 0xE71B, 0xE655, 0xDE55, 0x8C4F, 0x8C4F, 0xB594, 0x73AB, 0xAD72, 0xE696, 0xAC8D, 0xCE58, 0xE697, 0xE5F2, 
        0xCE57, 0x8C4F, 0xBDF5, 0xB5B4, 0xA532, 0xD676, 0xC50E, 0xC5D4, 0xDEDA, 0xDEB9, 0xCDF4, 0xC636, 0xB594, 0xC636, 0xB5B4, 0xB5B4, 0xC592, 0xC550, 0xDEB9, 0xDEB9, 0xBD31, 0xAD73, 0xAD73, 0xAD73, 0xB594, 0xAD74, 0xA532, 0xBD10, 0xD656, 0xE71B, 
        0xCDB3, 0xA4AE, 0xAD94, 0xB5D5, 0xBE16, 0xBE16, 0xB5D5, 0xC592, 0xD5B1, 0xDEB9, 0xDEDA, 0xDDB1, 0xBD2F, 0xBDD4, 0xC636, 0xBDF5, 0xBDB3, 0xD5B0, 0xE5AF, 0xDE56, 0xDEDA, 0xE633, 0xDD8E, 0xB52F, 0xB5B4, 0xBDB4, 0xD5D1, 0xEDCF, 0xDE13, 0xDEDA, 
        0xDEB8, 0xD5F3, 0xEDEF, 0xD54E, 0xB572, 0xD5F2, 0xEDCF, 0xEDCF, 0xDDF2, 0xD698, 0xD636, 0xDD6E, 0xC50B, 0xAC69, 0xAC48, 0xAC28, 0xA3E8, 0xA3C7, 0x9B87, 0x9367, 0x9327, 0x8AE7, 0x82C6, 0x7A86, 0x7A45, 0x7225, 0x7225, 0x71E5, 0x71E5, 0x69C5, 
        0x59A5, 0x59A4, 0x51A4, 0x51E5, 0x5205, 0x5225, 0x6AC8, 0x736A, 0x8C0D, 0xB551, 0xDE34, 0xDE34, 0xD635, 0xD635, 0xCDF5, 0xC5F5, 0xBDF5, 0xC616, 0xBDF5, 0xBDF6, 0xB5D5, 0xADB4, 0xAD94, 0xB5D5, 0xB593, 0xC637, 0xB5B4, 0xBDB4, 0xAD73, 0xA532, 
        0x8C6F, 0x9D12, 0xCE36, 0xCD91, 0xCE16, 0xD635, 0xD634, 0xB593, 0xA531, 0x842E, 0xBDB4, 0xD634, 0xDDF3, 0xDED9, 0xE675, 0xCE14, 0xB5B4, 0xBDD4, 0xA532, 0xBDD4, 0xCD91, 0xD656, 0xCE78, 0xE6B7, 0xF66F, 0xF68F, 0xEE2F, 0xCD91, 0xCE37, 0xB574, 
        0x83ED, 0xA4D1, 0x9C90, 0xB553, 0xAD32, 0x7B8C, 0xA4B0, 0xB533, 0xBD73, 0xAD12, 0xC5D5, 0xC5B4, 0xD657, 0xDEB9, 0xA533, 0x8C90, 0x5B2B, 0x52A9, 0x3A06, 0xA44A, 0xA48B, 0x4206, 0xB553, 0xEF1B, 0xE6FA, 0xDEB9, 0xBDD5, 0xB5B5, 0xBDD5, 0xBDD5, 
        0xC5F5, 0xCE36, 0xE6D9, 0xE6D9, 0xC616, 0xBDF5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xBDD5, 0xD677, 0xE6FA, 0xE6DA, 0xE6DA, 0xE6FA, 0xE6FA, 0xE6DA, 0xE6FA, 0xE71B, 0xEF3C, 0xDEDA, 0xBDD6, 0xBDF7, 0xC638, 0xCE79, 0xC616, 0xB573, 0xAD32, 0xD698, 
        0xDEB9, 0xC616, 0x844F, 0xDEBA, 0xD6B9, 0xCE58, 0x842E, 0xB574, 0x8C70, 0xB573, 0xDEB7, 0xD677, 0xD677, 0xD677, 0xD677, 0xD676, 0xC5F4, 0xBDB4, 0xA4D0, 0xC615, 0x9CB0, 0xBDD5, 0xCE57, 0xD678, 0xAD53, 0x8C4F, 0xDEBA, 0xDEDA, 0xD678, 0x9490, 
        0xCE37, 0xC617, 0xB5B5, 0xCE36, 0xDEB8, 0xDEB7, 0xDEB8, 0xE6D8, 0xCE36, 0x8C90, 0xAD53, 0x9490, 0xC637, 0xCE78, 0xA553, 0x94B1, 0xDEBA, 0xD6BA, 0xA533, 0xBDD5, 0xDE98, 0xE6D8, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xE6D8, 0x9550, 0x744D, 0x642C, 
        0x5C8D, 0x7C8E, 0x83CD, 0x8CAF, 0x64AE, 0x644D, 0x7BCC, 0x642D, 0x8D30, 0xE6D8, 0xE6B7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDE96, 0xDE76, 0xDE76, 0xDE76, 0xD696, 0xD696, 0xD676, 0xD697, 0xD697, 0xD697, 
        0xD697, 0xDE97, 0xDEB7, 0xDEB7, 0xD697, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB8, 0xDEB8, 0xDEB8, 0xDEB8, 0xDEB8, 0xDEB8, 0xD6B8, 0xD6B8, 0xD6B8, 0xD6B8, 0xDEB8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED8,
  0xAD11, 0x938A, 0xA3C9, 0xBC4A, 0xBC29, 0xB409, 0xAC4B, 0xACAE, 0xB531, 0xACCF, 0x9C4D, 0xA48E, 0xAD10, 0xC593, 0xC572, 0xACCE, 0xACEF, 0xAD31, 0xD677, 0xCE56, 0xCDF5, 0xBD72, 0xAD32, 0xA511, 0xAD52, 0xC5F4, 0xD677, 0xD615, 0xCDD3, 0xA532, 0x7BCC, 
        0x948F, 0xBDB3, 0xDE97, 0xD636, 0xD5D3, 0xB594, 0x948F, 0xA511, 0xBDB3, 0xD676, 0xDE77, 0xD5F3, 0xBDD4, 0xA4F1, 0x9CD0, 0xB593, 0xD656, 0x6B4B, 0x734A, 0xCE35, 0xB593, 0x94B0, 0xA531, 0xC615, 0xD698, 0xD698, 0xD6B9, 0xDEB9, 0xDEDA, 0xD6B9, 
        0xC616, 0xC616, 0xBDD5, 0xB593, 0xCE36, 0xBDB3, 0xAD93, 0xC656, 0xDE13, 0xE633, 0xDEDA, 0xDED9, 0xDDF3, 0xD656, 0x9D12, 0x9D12, 0xB594, 0x636B, 0xAD73, 0xD677, 0xE5F2, 0xDE97, 0xDEFB, 0xDE55, 0xD613, 0xD677, 0xB593, 0xCE36, 0xAD11, 0x94B0, 
        0xCE77, 0xDE13, 0xE613, 0x948F, 0x52C7, 0x4264, 0x4AA5, 0x52E6, 0x4285, 0x4264, 0x4284, 0x6B89, 0xAD0F, 0x7348, 0x2982, 0x31E3, 0x29C4, 0x73CC, 0x844E, 0xBDF5, 0xC615, 0x9D11, 0xC636, 0xDE34, 0xE612, 0xDEDA, 0xDED9, 0xDE13, 0xD677, 0xC5F5, 
        0xCE36, 0xB573, 0x9CD0, 0xC636, 0xDE34, 0xE654, 0xDEFA, 0xDE98, 0xCE57, 0xB594, 0x7BED, 0xA532, 0x7C0E, 0xA532, 0xCE36, 0xE612, 0xE6B8, 0xBDF6, 0xC591, 0xD635, 0x94AF, 0x7C0C, 0x73AB, 0x6348, 0x6B89, 0xDE14, 0xBCCE, 0xD698, 0xE697, 0xE612, 
        0xC616, 0x73AC, 0xB5B4, 0x9CF1, 0x8C4E, 0xD656, 0xCD2F, 0xCDF4, 0xDEDA, 0xDEB9, 0xD636, 0xC5F6, 0x9490, 0xD677, 0x9CB0, 0xB594, 0xDE34, 0xDDF2, 0xDEB9, 0xE6B9, 0xDE13, 0xCE57, 0xB5B4, 0xC616, 0xBDD5, 0xB5D5, 0xCE14, 0xD56F, 0xDE77, 0xE71B, 
        0xD5D3, 0xB511, 0xAD73, 0xA553, 0xA532, 0xA532, 0x9D12, 0xA4F0, 0xBD50, 0xDEB9, 0xE6D9, 0xACEF, 0xAD52, 0xB5D5, 0xBDF5, 0xC616, 0xB5F5, 0xB593, 0xCD71, 0xDE56, 0xE6FA, 0xCDB2, 0xB4EF, 0xC616, 0xCE77, 0xC636, 0xBDF4, 0xD5B0, 0xDE13, 0xDEDA, 
        0xDEB8, 0xD613, 0xD54F, 0xB4EE, 0xBDB3, 0xBD72, 0xDDB0, 0xEDCF, 0xE612, 0xDEFA, 0xE697, 0xF610, 0xC48C, 0x61A4, 0x61A5, 0x69A5, 0x69C5, 0x71C5, 0x69C5, 0x71E6, 0x7A06, 0x7A07, 0x7A06, 0x7A06, 0x7A06, 0x7A06, 0x8206, 0x8227, 0x8A47, 0x8247, 
        0x7A27, 0x7A47, 0x7207, 0x69E6, 0x61C5, 0x59A5, 0x51A5, 0x4963, 0x8BED, 0xCDF4, 0xDE35, 0xDE34, 0xDE33, 0xDE13, 0xDDF3, 0xDE76, 0xDEDA, 0xDED9, 0xDE34, 0xDE13, 0xDE35, 0xDE55, 0xDE76, 0xD635, 0xC5F5, 0xCE78, 0xBE16, 0xB5D4, 0xBDF5, 0xBDF5, 
        0xC636, 0xBE16, 0xB5D6, 0xAD52, 0xA552, 0xAD53, 0xBDB4, 0xB594, 0x9CF1, 0x8C6F, 0xA553, 0xCDF5, 0xC572, 0xCE57, 0xD635, 0xCDF4, 0xB593, 0xB5B4, 0xA532, 0xBDD5, 0xCD92, 0xD656, 0xD678, 0xE6B8, 0xFEF1, 0xFF71, 0xFF71, 0xEE4E, 0xC572, 0xB594, 
        0x9C70, 0xC5D5, 0xBD73, 0xCE16, 0xB574, 0x83ED, 0xA4F2, 0xB554, 0xB574, 0xB574, 0xCE37, 0xC5F6, 0xCE37, 0xC5F6, 0x9CD1, 0x8C50, 0x632B, 0x5AC9, 0x4A47, 0xC50B, 0xC56D, 0x31C5, 0xA4F2, 0xEF1B, 0xE6DA, 0xE6D9, 0xE6FA, 0xE71A, 0xE71A, 0xEF1A, 
        0xE71A, 0xE6FA, 0xE6D9, 0xDED9, 0xC616, 0xBDD5, 0xBDD5, 0xBDB5, 0xBDB5, 0xBDD4, 0xBDD5, 0xD677, 0xE6D9, 0xB574, 0xAD32, 0xD678, 0xE6FA, 0xE6DA, 0xE6FA, 0xEF3B, 0xDEB9, 0x8C4F, 0x7BCD, 0x73AD, 0x634B, 0x5B4B, 0x4AA9, 0x52EA, 0x636C, 0x73EE, 
        0x7C2F, 0x7C0E, 0x6B8D, 0x9CF2, 0x9D13, 0xA533, 0x7BED, 0x9D12, 0x844F, 0xAD32, 0xCE56, 0xCE56, 0xD656, 0xD677, 0xD677, 0xD656, 0xC5D4, 0xBD93, 0x9C8F, 0xC616, 0x9CD0, 0xBDD5, 0xCE57, 0xD698, 0xA553, 0x8C50, 0xDEDA, 0xDEFA, 0xD699, 0x9490, 
        0xCE37, 0xBDF6, 0xB5B5, 0xCE57, 0xE6F8, 0xE6D8, 0xE6D8, 0xE6F9, 0xCE36, 0x9491, 0xB574, 0x9490, 0xC657, 0xCE78, 0xA532, 0x9CD2, 0xDEDA, 0xDEDA, 0xA532, 0xBDD5, 0xDEB8, 0xE6B8, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xE6D8, 0xA592, 0x738B, 0x5308, 
        0x6CAE, 0x73EC, 0x20E2, 0x5AA8, 0x7CCE, 0x534A, 0x4A26, 0x740D, 0x9551, 0xE6D8, 0xE6B8, 0xDEB8, 0xDEB8, 0xDEB8, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDEB7, 0xDE97, 0xDE97, 0xDE97, 0xDE97, 0xDEB7, 0xDEB7, 0xDE97, 0xDEB8, 0xDEB8, 0xDEB8, 
        0xDEB8, 0xDEB8, 0xDEB8, 0xDEB8, 0xDEB8, 0xDED8, 0xDED8, 0xDEB8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDEB8, 0xDEB8, 0xDEB8, 0xDEB8, 0xDEB8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED9, 0xDED9, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED9, 0xDED9,
  0xAD11, 0x8B8A, 0xA3C9, 0xC44A, 0xBC2A, 0xBC09, 0xAC4C, 0xACCF, 0xB531, 0xA4AF, 0x9C8F, 0x944E, 0xA510, 0xC5B3, 0xB531, 0xA4CF, 0x8C2D, 0x9CAF, 0xD677, 0xCE56, 0xC5D4, 0xBD72, 0xAD53, 0x94AF, 0x9CF0, 0xC5D4, 0xD677, 0xD614, 0xCDD3, 0xAD32, 0x8C2E, 
        0x9CD0, 0xBDB3, 0xDE77, 0xD636, 0xCDD3, 0xB593, 0x946F, 0xA511, 0xBDB3, 0xD677, 0xDE77, 0xDDF3, 0xC5F5, 0xA4F1, 0x94B0, 0xB593, 0xB552, 0x4A88, 0x52A8, 0xB593, 0xB593, 0x948F, 0xAD31, 0xCE36, 0xDEB8, 0xDEB8, 0xDEB9, 0xDEDA, 0xDEDA, 0xD6B9, 
        0xCE57, 0xCE57, 0xC5F5, 0xBDB4, 0xCE36, 0xBD93, 0xAD73, 0xC656, 0xDE13, 0xE633, 0xDEDA, 0xDED9, 0xDDF3, 0xD656, 0xB5B4, 0xAD94, 0xB5D5, 0x8C6F, 0xAD94, 0xD677, 0xE5F2, 0xDE97, 0xDEFB, 0xE655, 0xDE13, 0xCE56, 0xBD93, 0xCE36, 0x9CAF, 0x9D11, 
        0xCE77, 0xDE13, 0xCD90, 0x5B07, 0x2182, 0x3203, 0x3A23, 0x3223, 0x3223, 0x4264, 0x3A64, 0x4284, 0x4AA5, 0x4AA5, 0x3A24, 0x3204, 0x29C3, 0x29A3, 0x3A05, 0xA532, 0xC5F4, 0xA531, 0xC616, 0xDE34, 0xE612, 0xDEDA, 0xDED9, 0xDE13, 0xCE36, 0xB5B4, 
        0xC636, 0xBDD5, 0xAD52, 0xC636, 0xDE34, 0xE634, 0xDEFA, 0xDE98, 0xCE57, 0xC616, 0xAD53, 0xBDF5, 0x844F, 0xAD74, 0xD677, 0xBD2F, 0x8C4C, 0x52E7, 0x6B67, 0xAD31, 0x5B07, 0x4AA5, 0x4AA5, 0x4AC5, 0x4AC5, 0x6B68, 0x7B89, 0xD6B8, 0xE676, 0xDDD1, 
        0xBDD4, 0x842D, 0xB594, 0xA511, 0x9CF1, 0xCE56, 0xCD4F, 0xCE15, 0xDEDA, 0xDEB9, 0xD635, 0xB593, 0x8C2E, 0xC5F5, 0x7BCC, 0xAD53, 0xDE35, 0xDE13, 0xDED9, 0xE6B8, 0xDE34, 0xCE56, 0x842E, 0xC5F5, 0x9CB0, 0xA532, 0xDE76, 0xE5B0, 0xDE97, 0xDEFB, 
        0xE634, 0xDE34, 0xBE16, 0xAD73, 0xCE56, 0xB593, 0xC636, 0xD5D2, 0xD590, 0xDED9, 0xDED9, 0xCD71, 0xB593, 0xB594, 0xAD94, 0xB594, 0xAD73, 0xAD32, 0xBD2F, 0xD636, 0xE6FA, 0xAD11, 0xA532, 0xB5B5, 0xB5B4, 0xBDD5, 0xB5B4, 0xAD52, 0xBD93, 0xE6DA, 
        0xDEB9, 0xBD93, 0xAD31, 0xBDB3, 0xCDF4, 0xC5B3, 0xBDD4, 0xD5B1, 0xDE13, 0xDEFA, 0xE697, 0xE5D0, 0xBC4C, 0x8247, 0x8A67, 0x8A67, 0x8227, 0x7A27, 0x7A27, 0x8247, 0x8A88, 0x8A67, 0x8247, 0x7227, 0x7206, 0x8247, 0x8A47, 0x8A67, 0x9288, 0x8A67, 
        0x8A68, 0x8247, 0x7227, 0x8A88, 0x8A88, 0x8248, 0x7A27, 0x7A47, 0xBD31, 0xCDB2, 0xCD71, 0xC571, 0xB552, 0xC5B3, 0xC5B3, 0xC5B3, 0xBDD5, 0xC5F6, 0xC5D3, 0xCDD3, 0xCDF3, 0xDE14, 0xDE34, 0xD613, 0xCE15, 0xD6B9, 0xD698, 0xDE14, 0xDE34, 0xDE34, 
        0xDE34, 0xDE34, 0xDE34, 0xD676, 0xD698, 0xCE57, 0xC5F4, 0xCDF5, 0xC615, 0xC616, 0xC616, 0xC616, 0xB5B4, 0xB5D5, 0xB5D5, 0xB5B4, 0xA553, 0xA532, 0x9D32, 0xB5D5, 0xB552, 0xBDB4, 0xAD94, 0xC615, 0xC56D, 0xD5ED, 0xE66F, 0xDDCC, 0xBCEE, 0x83AD, 
        0x62C9, 0x7B8C, 0x836C, 0xA4B1, 0xAD12, 0x83AC, 0x944F, 0xB554, 0xB554, 0xB574, 0xC5D5, 0xC5D5, 0xDEB9, 0xD698, 0xAD53, 0x94D1, 0x6B6C, 0x632A, 0x8BA9, 0xEDCC, 0xE5ED, 0x7B27, 0xAD12, 0xE71B, 0xE6DA, 0xE6D9, 0xDEDA, 0xDEDA, 0xDEB9, 0xDEB9, 
        0xE6FA, 0xDED9, 0xE6D9, 0xDED9, 0xC616, 0xBDD5, 0xBDB5, 0xB5B4, 0xB5B4, 0xB5B4, 0xBDD4, 0xD677, 0xE6FA, 0xD657, 0xC616, 0xDED9, 0xE6FA, 0xE6FA, 0xEF1B, 0xD699, 0x9490, 0xB572, 0xBDD4, 0xB552, 0x94B0, 0x6B8C, 0x5B0A, 0x4268, 0x4AA9, 0x5B2A, 
        0x5B2A, 0x5B2A, 0x5B2A, 0x4A88, 0x6B4B, 0x738C, 0x634A, 0x634B, 0x634B, 0x632A, 0x632B, 0x5B0A, 0x6B8C, 0x73AD, 0x73ED, 0x73CD, 0x73AD, 0x6B6B, 0x6B8C, 0xAD53, 0x7BED, 0xAD53, 0xC616, 0xDEB9, 0xADB5, 0x844F, 0xDEB9, 0xDEFA, 0xD6B9, 0x9490, 
        0xD698, 0x8CB1, 0x636C, 0x94B1, 0xB573, 0xB594, 0xBDD5, 0xCE56, 0xBDD5, 0x8C70, 0xAD53, 0x9490, 0xC637, 0xD699, 0xAD94, 0x94D1, 0xDEDA, 0xDEBA, 0xA532, 0xBDF6, 0xDEB8, 0xE6B8, 0xDEB8, 0xDEB7, 0xDEB7, 0xE6B8, 0xDEB7, 0xAD51, 0x738B, 0x5B09, 
        0x8CAF, 0x5AE9, 0x2964, 0x62C9, 0x948F, 0x4AE8, 0x52C9, 0x7C0D, 0x94F0, 0xDEB8, 0xE6D8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDEB8, 0xDED8, 0xDEB8, 0xDEB8, 0xDEB8, 0xDEB8, 0xDEB8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDEB8, 0xDED8, 0xDED8, 0xDED8, 
        0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED9, 0xDED9, 0xDED9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9,
  0xAD11, 0x8B89, 0x8367, 0x93A8, 0x93C8, 0xA3E9, 0x9C4B, 0xA48D, 0xACEF, 0xACF0, 0x8C2D, 0x840C, 0x948E, 0xAD0F, 0xBD51, 0xAD10, 0x7BEC, 0xB572, 0xCE77, 0xCE56, 0xC5F4, 0xBD92, 0xB573, 0x9CB0, 0x9D11, 0xBDD4, 0xD677, 0xD614, 0xCDD3, 0xAD52, 0x8C4E, 
        0x9CD0, 0xC5F4, 0xDEB8, 0xD656, 0xCDD3, 0xAD52, 0x840D, 0x9CAF, 0xB592, 0xC615, 0xC5F5, 0xBD51, 0xAD11, 0x946E, 0x8C2D, 0x948F, 0x73CC, 0x4AC8, 0x5B2A, 0x7C4E, 0x94B0, 0x844E, 0x8C8F, 0xA552, 0xB5B4, 0xBDD5, 0xC637, 0xCE78, 0xCE99, 0xCE78, 
        0xC616, 0xC616, 0xC615, 0xC5D5, 0xD677, 0xC5F5, 0xB5B4, 0xCE77, 0xE613, 0xE633, 0xE6FA, 0xE6D9, 0xE612, 0xD656, 0xD6B9, 0xC657, 0xDED9, 0xB5B4, 0xB5D5, 0xD656, 0xE612, 0xE6B8, 0xE71B, 0xE676, 0xCDD2, 0xD677, 0xA4F0, 0xA531, 0xAD32, 0xAD73, 
        0xCE77, 0xDE13, 0x9C0A, 0x4285, 0x29E3, 0x21A3, 0x29C3, 0x29A2, 0x21A2, 0x3A43, 0x4284, 0x4AA4, 0x3202, 0x3A44, 0x3A24, 0x3204, 0x29C3, 0x31E4, 0x3A05, 0x636A, 0x9C8E, 0xA511, 0xCE77, 0xDE14, 0xE612, 0xDEFA, 0xDED9, 0xDE13, 0xD657, 0xB593, 
        0xBDF5, 0xB552, 0x9CF1, 0xC656, 0xDE13, 0xE654, 0xDEFA, 0xDE98, 0xCE77, 0xBDF5, 0xAD73, 0xC636, 0xA532, 0xB5B4, 0xA511, 0x4A85, 0x3A03, 0x4264, 0x4264, 0x4AC6, 0x4264, 0x4244, 0x3A43, 0x4264, 0x4AA5, 0x4244, 0x4244, 0x9CF0, 0x948E, 0x7368, 
        0x73AA, 0x6349, 0x8C4E, 0x6B8A, 0x73CB, 0xC5F4, 0xD52F, 0xCDF5, 0xDEFA, 0xDEB8, 0xCE15, 0xBD93, 0x946F, 0xBDB3, 0x840D, 0xB594, 0xDE34, 0xDE13, 0xDED9, 0xE6B8, 0xDE33, 0xC5D5, 0x840D, 0xBDB4, 0x946F, 0xA512, 0xDE56, 0xE5D1, 0xDE97, 0xDEFA, 
        0xE655, 0xDE75, 0xA512, 0x946F, 0xC5F5, 0x946E, 0xCE57, 0xE633, 0xDDF1, 0xDEDA, 0xDED9, 0xE613, 0xD656, 0x9D11, 0xCE56, 0xB5B4, 0xB5B4, 0xDE55, 0xE5B0, 0xDE76, 0xE6DA, 0xCDD3, 0xC5F5, 0xB5B4, 0xBDF5, 0xBDD5, 0xB5B4, 0xB552, 0xC592, 0xDEFA, 
        0xDEB8, 0xB593, 0xAD53, 0xAD94, 0xAD73, 0x9CD1, 0xA532, 0xAD31, 0xC592, 0xDEFA, 0xDE76, 0xB4AE, 0xAC8F, 0x8288, 0x8267, 0x8247, 0x7A68, 0x49C5, 0x3102, 0x61C5, 0x8A68, 0x8247, 0x7AA9, 0x39C5, 0x18A1, 0x59A5, 0x8267, 0x8247, 0x8267, 0x8A67, 
        0x8A88, 0x5A26, 0x6AA9, 0x8AA9, 0x7A68, 0x6247, 0x7A68, 0x8AA9, 0xCDB3, 0xEE11, 0xF610, 0xC52E, 0xBD92, 0xD590, 0xE5CF, 0xDD90, 0xCE36, 0xD677, 0xD591, 0xD590, 0xC570, 0xB530, 0xC571, 0xC571, 0xB551, 0xC657, 0xBDD5, 0xC593, 0xC5B3, 0xC5B4, 
        0xC5D3, 0xCDD3, 0xCDD3, 0xC5F5, 0xCE57, 0xD656, 0xDE14, 0xDE34, 0xDE34, 0xDE34, 0xDE34, 0xDE34, 0xD698, 0xD6B9, 0xD676, 0xD614, 0xD655, 0xD655, 0xD635, 0xC614, 0xB5B4, 0xBDF6, 0xB5B4, 0xC636, 0x7B68, 0x6283, 0x6AA4, 0x72E4, 0xC572, 0x9C70, 
        0x6AEA, 0x7B8C, 0x4A26, 0x734C, 0xB553, 0x8BED, 0x62C9, 0xA4B1, 0x9C90, 0x944F, 0x942E, 0x9C6F, 0xCE16, 0xC5D5, 0x9CD2, 0x8C71, 0x7B8B, 0xBC6A, 0xE56A, 0xF64D, 0xFEAF, 0xF68F, 0xDE12, 0xDED9, 0xDEDA, 0xDED9, 0xE6DA, 0xDEB8, 0x8C4F, 0x52C9, 
        0xC616, 0xE6FA, 0xDED9, 0xDED9, 0xC616, 0xBDD5, 0xB5B4, 0xB594, 0xB5B4, 0xBDD5, 0xB594, 0xCE57, 0xDEDA, 0xD699, 0xCE37, 0xDE99, 0xE71B, 0xEF1B, 0xDED9, 0x9CF1, 0xBDB4, 0xBDB4, 0xAD32, 0xAD11, 0xBD73, 0xA531, 0x6B8C, 0x636B, 0x634B, 0x5B2A, 
        0x5B4B, 0x5B2A, 0x52C9, 0x946F, 0xBDB4, 0xAD52, 0x948F, 0x73AC, 0x73AC, 0x6B8C, 0x634B, 0x52C9, 0x3A27, 0x4AA9, 0x636B, 0x634B, 0x530A, 0x4AE9, 0x52EA, 0x52EA, 0x4AA9, 0x634B, 0x73CD, 0x7C2F, 0x636C, 0x73EE, 0xD6B9, 0xD6B9, 0xC637, 0x8C70, 
        0x9CF2, 0x6B6C, 0x3A48, 0x4268, 0x4288, 0x4AA9, 0x52C9, 0x52C9, 0x52EA, 0x52E9, 0x5B2B, 0x632B, 0x73EE, 0x8470, 0x73EE, 0x9CD2, 0xDEBA, 0xDED9, 0xA533, 0xC616, 0xDEB8, 0xE6B8, 0xDEB8, 0xDEB7, 0xDEB7, 0xE6B8, 0xE6D8, 0xC5F4, 0x730A, 0x5247, 
        0xAD31, 0x5268, 0x738D, 0x9C8F, 0xACF1, 0x6B4B, 0x3184, 0x83AC, 0xBDD4, 0xE6F9, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xDED8, 0xDED8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xE6D8, 0xE6D8, 0xE6D9, 
        0xE6D9, 0xE6F9, 0xDEF9, 0xDEF9, 0xDED9, 0xDED9, 0xDED9, 0xDED9, 0xDED8, 0xDEF9, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED9, 0xDED9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9,
  0xAD11, 0x8369, 0x6326, 0x62E5, 0x52A4, 0x5AE5, 0x6B47, 0x7BA8, 0x7388, 0x7BA8, 0x5B05, 0x6B68, 0x7388, 0x8C2B, 0x9C8D, 0x9CAF, 0x840D, 0xB572, 0xCE77, 0xCE56, 0xC5F5, 0xBD93, 0xB593, 0x94B0, 0xA4F1, 0xBDD4, 0xDEB8, 0xD635, 0xCDD3, 0x9CF1, 0x7BED, 
        0x946E, 0xA511, 0xB593, 0xB531, 0xACCF, 0x944E, 0x83AB, 0x83EB, 0x944C, 0x9C4D, 0xA46E, 0xA46D, 0xA48D, 0xACCF, 0xACEF, 0xACEF, 0xAD73, 0xA553, 0xBDD4, 0xBD92, 0xA532, 0xA532, 0xA511, 0x9D11, 0x9D11, 0x9CF1, 0x9CD0, 0x9CD0, 0x9CD0, 0x94D1, 
        0x9CD0, 0x9CF1, 0x9D11, 0x9CF1, 0xA532, 0x94F0, 0x94F1, 0xA553, 0xBD51, 0xBD51, 0xBDF5, 0xCE36, 0xCD91, 0xCE36, 0xD6B9, 0xCE98, 0xDEFA, 0xB5B5, 0xBE16, 0xD697, 0xD5B1, 0xC5F3, 0x94F0, 0x9CAD, 0x7BE9, 0x9D0F, 0x7BEA, 0x5B06, 0x7C0B, 0xB5B4, 
        0xCE77, 0xDE34, 0xD591, 0x4AA6, 0x2182, 0x2162, 0x2182, 0x2182, 0x31E3, 0x3A23, 0x31E2, 0x3A23, 0x3A44, 0x3203, 0x29E3, 0x21A2, 0x29C3, 0x29A3, 0x29C4, 0x3204, 0x52E7, 0x73CB, 0x9D31, 0xD5D2, 0xE633, 0xDEFA, 0xDED9, 0xDE13, 0xD677, 0xBD93, 
        0xCE36, 0xB531, 0xA531, 0xCE77, 0xDE13, 0xE634, 0xDEFB, 0xD698, 0xCE77, 0xC615, 0xAD52, 0xB572, 0x946E, 0x8C4E, 0x4A85, 0x31C3, 0x29A2, 0x3203, 0x3A24, 0x4244, 0x4264, 0x3A23, 0x3203, 0x4244, 0x4244, 0x3A23, 0x3A24, 0x4245, 0x4286, 0x3A24, 
        0x3A24, 0x3A04, 0x3A24, 0x3203, 0x3A44, 0x8C2C, 0xC52F, 0xC5F4, 0xCE78, 0xDEB8, 0xD635, 0xD636, 0xCDD4, 0xD634, 0x944E, 0xBDD5, 0xDE34, 0xDE13, 0xDED9, 0xE6B8, 0xDE13, 0xCE35, 0x9CAF, 0xB572, 0x8C4E, 0xAD52, 0xD635, 0xE5D1, 0xDE98, 0xDEFB, 
        0xE654, 0xDE35, 0xA511, 0x8C6E, 0xBDB3, 0x8C4E, 0xC636, 0xDE13, 0xDDF2, 0xDEDA, 0xE6D9, 0xE613, 0xC5F5, 0x842E, 0xBDB4, 0x94B0, 0xA552, 0xDE76, 0xE5D0, 0xDE97, 0xDEDA, 0xDE34, 0xCE56, 0x94B0, 0xCE36, 0xAD52, 0xB594, 0xDE34, 0xDE13, 0xDEFA, 
        0xDE98, 0xC615, 0xC636, 0xB593, 0xC636, 0x842E, 0x948F, 0xD5D2, 0xD5B2, 0xDEFA, 0xDE76, 0xC551, 0xA46F, 0x7A67, 0x8267, 0x8267, 0x7AC9, 0x39C5, 0x20E2, 0x51A5, 0x8267, 0x8267, 0x6A88, 0x2924, 0x10A1, 0x59C5, 0x7A47, 0x7A26, 0x7A26, 0x7226, 
        0x7A47, 0x5A27, 0x62A9, 0x7A68, 0x6A27, 0x62C9, 0x7AA9, 0x8288, 0xCD72, 0xEE11, 0xCD2E, 0xAD10, 0xBDD4, 0xBD51, 0xE5D0, 0xE5D0, 0xDE98, 0xE6D8, 0xEE11, 0xEDCF, 0xB4CD, 0xBDF4, 0xD5B1, 0xEDAE, 0xD570, 0xDEB9, 0xDE97, 0xE5B0, 0xE5AF, 0xC52F, 
        0xB530, 0xD590, 0xD590, 0xCD70, 0xC5F5, 0xBDB4, 0xC551, 0xC592, 0xBD72, 0xBD92, 0xCDD3, 0xC5B3, 0xBDB4, 0xBDF6, 0xBDD5, 0xCDB3, 0xCDF3, 0xD614, 0xD614, 0xD614, 0xCDF4, 0xD698, 0xDED9, 0xDEB8, 0xAC6A, 0xBCA9, 0xBC69, 0x9367, 0x8BCC, 0x6AEA, 
        0x6ACA, 0x7B8C, 0x4A46, 0x5289, 0xA4D1, 0x83CD, 0x6B2B, 0xB554, 0xB574, 0xB574, 0xB532, 0xACF1, 0xCE37, 0xBDD5, 0x9491, 0x8C50, 0x93A9, 0xCC67, 0xEDCA, 0xFEEF, 0xFF51, 0xFF71, 0xF68F, 0xD634, 0xDEFA, 0xDED9, 0xE6FA, 0xCE57, 0x5B0B, 0x18E2, 
        0x9CB1, 0xEF3B, 0xDED9, 0xDED9, 0xC616, 0xB5B4, 0xB5B4, 0xB594, 0xAD53, 0x7BED, 0x83ED, 0x7BED, 0x73EE, 0x7BEE, 0xA533, 0x8C91, 0x842F, 0x8C70, 0x8C70, 0xB593, 0xB573, 0xA4D0, 0xA4AF, 0xA4D0, 0xACF0, 0xAD11, 0x94AF, 0x636B, 0x636B, 0x5B4B, 
        0x530A, 0x52E9, 0xA512, 0xC5D4, 0xB553, 0xAD32, 0xBDD4, 0xA511, 0x73CC, 0x73CC, 0x6BAC, 0x636B, 0x5B2A, 0x5B2A, 0x530A, 0x52E9, 0x52C9, 0x532A, 0x530A, 0x52EA, 0x52E9, 0x4AA9, 0x634B, 0x8C90, 0x52EA, 0x4AA9, 0x8C91, 0x8450, 0x5B2B, 0x4268, 
        0x4268, 0x4AA9, 0x4AA9, 0x52EA, 0x3A27, 0x4A88, 0x4AA9, 0x4AA9, 0x4AA8, 0x4AA9, 0x4AA9, 0x4A88, 0x52EA, 0x94D2, 0x7C4F, 0x7C0E, 0xCE78, 0xD699, 0x9CD2, 0xC616, 0xDED8, 0xE6D8, 0xDEB8, 0xDEB7, 0xDEB7, 0xE6D8, 0xE6F9, 0xDE76, 0x6AA8, 0x5227, 
        0xB552, 0x62C9, 0x6B6C, 0x5AC8, 0xACF1, 0x738B, 0x3964, 0x8BCD, 0xDE97, 0xE6F9, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D9, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6F9, 0xE6F9, 0xE6F9, 
        0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xDEF9, 0xDED8, 0xDED8, 0xDED8, 0xDED8, 0xDED9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9,
  0xA4F0, 0x6B08, 0x52A5, 0x4AA4, 0x4A83, 0x52A4, 0x6305, 0x5AC5, 0x52A4, 0x52A4, 0x4243, 0x4263, 0x4AA4, 0x6347, 0x7388, 0x7BAA, 0x8C6E, 0xAD73, 0xCE57, 0xC636, 0xBDB4, 0xB573, 0xA532, 0x8C4E, 0x948F, 0x9CD0, 0xAD52, 0xA4D0, 0x944E, 0x83EC, 0x83EC, 
        0x9C4D, 0xA48D, 0xA48E, 0xACAE, 0x9C6D, 0x8BCB, 0x7B49, 0x7B8A, 0x8BEB, 0x9C2C, 0xB50F, 0xB4CD, 0xA4CE, 0xB571, 0xBDB3, 0xBD92, 0xCE57, 0xC678, 0xA530, 0xBDB2, 0xC657, 0xBE37, 0xBE16, 0xBDF6, 0xBE16, 0xC616, 0xBDD5, 0xCDF3, 0xC5D3, 0xBDB4, 
        0xCDD3, 0xBDB3, 0xB593, 0xB572, 0x946D, 0x7BEA, 0x9CF0, 0x9CCF, 0x842D, 0x7BCA, 0x73A9, 0x840B, 0x83EB, 0x842C, 0x8CAF, 0x94F1, 0xA552, 0x848F, 0x9D31, 0xB593, 0x83EA, 0x5B26, 0x4AC4, 0x4AC4, 0x52E5, 0x52C4, 0x52E5, 0x52C4, 0x4284, 0x94EF, 
        0xCE57, 0xDDF3, 0xBD0F, 0x3A45, 0x1962, 0x1942, 0x2142, 0x29A3, 0x3A44, 0x3203, 0x3203, 0x3203, 0x29A2, 0x2182, 0x29C3, 0x29C3, 0x31E4, 0x2983, 0x29A3, 0x29A3, 0x4265, 0x3A65, 0x6BAB, 0xDE13, 0xE613, 0xDEFA, 0xE6D9, 0xDE13, 0xD656, 0xBD93, 
        0xCE36, 0xAD31, 0xAD72, 0xCE77, 0xE633, 0xE655, 0xDEFB, 0xD698, 0xCE77, 0xCE36, 0xA4F0, 0x5B07, 0x6B89, 0x5AE8, 0x4244, 0x4244, 0x3A04, 0x29A2, 0x29C3, 0x3A04, 0x4264, 0x4285, 0x3203, 0x31E3, 0x31E3, 0x4265, 0x3A04, 0x4286, 0x4285, 0x31E3, 
        0x3203, 0x31C3, 0x3A03, 0x3A23, 0x3A23, 0x52A6, 0x6B27, 0x7BCB, 0x7C2D, 0xAD51, 0xCDF4, 0xE6B7, 0xD656, 0xDE76, 0xAD31, 0xC616, 0xDE34, 0xDE13, 0xDED9, 0xE6B8, 0xDE14, 0xE6B7, 0xDE76, 0xCE35, 0x94B0, 0xB5B4, 0xD655, 0xE5F1, 0xDE98, 0xDEFA, 
        0xE654, 0xDE35, 0xB593, 0x9CF0, 0xC5B3, 0x9C8F, 0xC616, 0xDDF3, 0xDDF2, 0xDEDA, 0xE6D9, 0xDDF3, 0xC615, 0x8C6F, 0xB594, 0x9CD0, 0xAD73, 0xDE55, 0xE5D0, 0xDE97, 0xDEDA, 0xDE34, 0xC5F5, 0x840D, 0xBDD5, 0x7BED, 0xA532, 0xDE55, 0xDE34, 0xDEFA, 
        0xDE98, 0xCE56, 0xCE56, 0x948F, 0xC616, 0x62E9, 0x6B4A, 0xDE13, 0xE613, 0xDEDA, 0xE696, 0xDE33, 0x93ED, 0x7226, 0x7A27, 0x8267, 0x59C5, 0x3123, 0x3144, 0x59C5, 0x7226, 0x7206, 0x5185, 0x20C2, 0x18E2, 0x51E6, 0x7A27, 0x7A06, 0x7A27, 0x7A47, 
        0x7247, 0x4964, 0x4123, 0x69E6, 0x6A07, 0x51E6, 0x6227, 0x7A68, 0xB46E, 0xBCEE, 0xAD10, 0xC5D4, 0xC5D4, 0xB593, 0xC5D3, 0xDDB1, 0xDE98, 0xE6D9, 0xE611, 0xC50E, 0xAD10, 0xC5F4, 0xB551, 0xDD8F, 0xDD90, 0xDEDA, 0xE6B8, 0xEE10, 0xE5AF, 0xA4CD, 
        0xBDB4, 0xD590, 0xEDEF, 0xE5D0, 0xDEB8, 0xE676, 0xEDCF, 0xEDEF, 0xBD0E, 0xBD50, 0xE5B0, 0xDD8F, 0xD5B2, 0xCE57, 0xCDD4, 0xCD50, 0xC571, 0xAD10, 0xAD30, 0xBD52, 0xAD31, 0xB5D5, 0xAD94, 0xBDD5, 0xACCD, 0xBD0D, 0xD58E, 0x9BEA, 0x62C9, 0x62C9, 
        0x4A06, 0x39C5, 0x4206, 0x4A67, 0x8C2E, 0x734B, 0x5268, 0x7B8D, 0x7BAD, 0x738D, 0x7BAD, 0x83CD, 0xB574, 0xBDD5, 0x9CF2, 0x94B1, 0x8B48, 0x9345, 0xBC46, 0xE60C, 0xDE0D, 0xEE4E, 0xE5CB, 0xCD91, 0xE6FA, 0xDED9, 0xE6FA, 0xC616, 0x73CD, 0x52A8, 
        0x9CB1, 0xEF3B, 0xE6FA, 0xDED9, 0xC615, 0xB5B4, 0xB594, 0xBDB5, 0x946F, 0x7BAC, 0xB553, 0x8C4E, 0x5B0A, 0x52C9, 0x4A89, 0x52CA, 0x52EA, 0x4AA9, 0x94B0, 0xBDB4, 0xAD11, 0xAD11, 0xBD93, 0xBDB4, 0xBD93, 0xB552, 0xB531, 0x7BCD, 0x5B2B, 0x5B2A, 
        0x4AA8, 0x8C6F, 0xBDB4, 0x9CD0, 0x948F, 0x946F, 0x9CAF, 0xAD52, 0x9CB0, 0x6BAC, 0x6BAC, 0x6B6B, 0x5B0A, 0x52E9, 0x5B2B, 0x5B2B, 0x4AA8, 0x4AC9, 0x52EA, 0x52EA, 0x4AC9, 0x73CD, 0xA553, 0xBDF6, 0xA554, 0x52C9, 0x3A07, 0x3A48, 0x4A89, 0x4AA9, 
        0x4AA9, 0x4AA9, 0x6B8D, 0x9D12, 0x7C2E, 0x3A47, 0x4A88, 0x4AA9, 0x4AA9, 0x4AA9, 0x4AA9, 0x52A9, 0x94F1, 0xBE16, 0xBE37, 0x7C2F, 0x94D2, 0xCE78, 0x7C2F, 0x842F, 0xC616, 0xDE98, 0xDEB8, 0xE6F8, 0xE6D8, 0xE6D8, 0xE6F9, 0xD676, 0x730A, 0x6AC9, 
        0xB531, 0x736B, 0x944E, 0x732A, 0xB511, 0x83ED, 0x5A27, 0x8BEE, 0xDE97, 0xE6F9, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D9, 0xE6D9, 0xE6D9, 0xE6D9, 0xE6D9, 0xE6F9, 0xE6F9, 0xE6F9, 
        0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xDEF9, 0xDEF9, 0xDEF9, 0xE6F9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9,
  0x948E, 0x52C5, 0x4A84, 0x4A63, 0x4263, 0x4A84, 0x52A4, 0x4A84, 0x52C5, 0x52A5, 0x3A03, 0x3A03, 0x3A23, 0x4263, 0x52C5, 0x5B07, 0x73AA, 0x948E, 0x9CD0, 0x9CAF, 0x946E, 0x944D, 0x944E, 0x9C6E, 0xACAE, 0xACAE, 0xAC8D, 0xA4AE, 0xAD10, 0xAD11, 0xB531, 
        0xBD30, 0xC551, 0xB4EF, 0xBD30, 0x9C8F, 0x7369, 0x5AA7, 0x6308, 0x83AA, 0x93EB, 0x942C, 0x942B, 0x83CA, 0x83EA, 0x9CCF, 0xAD30, 0xBE16, 0x8CB0, 0x4A84, 0x5B27, 0xA572, 0xB5F5, 0xB5D5, 0xB5F5, 0xBDF6, 0xBE16, 0xBE16, 0xD634, 0xCE15, 0xC637, 
        0xD634, 0xD655, 0xC658, 0xB594, 0x6B69, 0x6B67, 0x842A, 0x73E9, 0x5B05, 0x6B66, 0x6346, 0x6B87, 0x8408, 0x7BA7, 0x6B66, 0x83E9, 0x6B47, 0x52E5, 0x6B68, 0x8C4D, 0x52E6, 0x3A22, 0x4263, 0x4263, 0x4242, 0x4AA4, 0x4243, 0x4263, 0x4AA4, 0x52E6, 
        0x844C, 0x7389, 0x3A24, 0x21A2, 0x2182, 0x2162, 0x1942, 0x2162, 0x3203, 0x3203, 0x3203, 0x29C3, 0x1942, 0x1942, 0x2182, 0x3204, 0x29C3, 0x29A3, 0x2183, 0x2182, 0x3A45, 0x638A, 0xA552, 0xDE13, 0xE634, 0xDEFA, 0xE6D9, 0xE613, 0xDE98, 0xD698, 
        0xD698, 0xCE36, 0xB5B4, 0xCE57, 0xE633, 0xE655, 0xDEFB, 0xD698, 0xCE77, 0xC5F5, 0x946E, 0x4AA5, 0x4A85, 0x4244, 0x4244, 0x4264, 0x3A04, 0x1921, 0x2162, 0x29A3, 0x3A03, 0x3203, 0x31C3, 0x29C3, 0x29A2, 0x31E3, 0x31E4, 0x844F, 0x4AC7, 0x31E3, 
        0x31E3, 0x3A24, 0x4244, 0x3A44, 0x4265, 0x4244, 0x3A03, 0x3A44, 0x4AC6, 0x4AA5, 0x94AE, 0xC5F4, 0xBDB4, 0xCDF4, 0x94B0, 0xC616, 0xDE34, 0xDE13, 0xDEDA, 0xE6B8, 0xDE34, 0xD677, 0xD656, 0xD657, 0xAD73, 0xBDF5, 0xDE55, 0xE5F1, 0xDEB8, 0xDEFA, 
        0xE654, 0xDE35, 0xDE97, 0xD656, 0xDE35, 0xAD11, 0xCE57, 0xE613, 0xE612, 0xDEDA, 0xDED9, 0xDE13, 0xCE15, 0xA552, 0xC5F5, 0xA4CF, 0xB594, 0xDE55, 0xE5D0, 0xDE97, 0xDED9, 0xD614, 0xC615, 0x948F, 0xB593, 0x8C4E, 0xB573, 0xDE34, 0xDE34, 0xDEFA, 
        0xDE98, 0xCE36, 0xBDD5, 0x8C4E, 0xB593, 0x4A67, 0x39E5, 0x838A, 0xE633, 0xDEFA, 0xE676, 0xE654, 0xB512, 0x7226, 0x7A26, 0x7A27, 0x5985, 0x30E3, 0x20C2, 0x4964, 0x7A27, 0x7A27, 0x61C5, 0x28E3, 0x10A1, 0x4A06, 0x7A67, 0x71E6, 0x7A26, 0x8247, 
        0x7207, 0x4924, 0x5165, 0x7227, 0x61C6, 0x3903, 0x61E6, 0x6A26, 0xA42D, 0xB510, 0xAD73, 0xAD73, 0xAD53, 0xAD73, 0xA532, 0xB531, 0xD678, 0xE6D9, 0xB4EF, 0xAD31, 0xBDB3, 0xC5D4, 0xB593, 0xBD92, 0xC572, 0xDED9, 0xE6B8, 0xD56F, 0xB530, 0xBD72, 
        0xC5D3, 0xBD72, 0xDDD1, 0xE5D1, 0xDEB9, 0xE676, 0xEDF0, 0xCD4E, 0xAD10, 0xBD92, 0xCD70, 0xEDCF, 0xE613, 0xDED9, 0xE654, 0xEDF0, 0xD56F, 0xAD31, 0xCDB2, 0xE58F, 0xCD2E, 0xC636, 0xCE57, 0xCE37, 0x8BED, 0x93ED, 0xA490, 0x6AE9, 0x5268, 0x62E9, 
        0x5248, 0x5288, 0x4A68, 0x4A68, 0x4A47, 0x7308, 0x5A86, 0x5268, 0x630B, 0x5ACA, 0x41E5, 0x5268, 0x944F, 0x7B8C, 0x6B0A, 0x62C9, 0x5225, 0x72A4, 0x9304, 0x9B64, 0x8B23, 0x8304, 0x8305, 0xC572, 0xE6FA, 0xDEB9, 0xDED9, 0xBDD5, 0x634B, 0x52A9, 
        0x94B0, 0xDED9, 0xD698, 0xD657, 0xB594, 0xB594, 0xB594, 0x9CD1, 0x7BED, 0xB573, 0xBD93, 0xB552, 0x9C90, 0x634B, 0x530A, 0x52EA, 0x52EA, 0x7C0E, 0xBDD5, 0xAD53, 0xB553, 0xC5F5, 0xC5F5, 0xBDB4, 0xBD93, 0xC5D4, 0xBD73, 0x9CB0, 0x52E9, 0x4A88, 
        0x6B6B, 0xB593, 0xA4F1, 0x9CB0, 0x9C8F, 0x946F, 0x946E, 0x944E, 0xB572, 0x948F, 0x634A, 0x52C9, 0x52EA, 0x8470, 0xA574, 0xB5B5, 0x94F2, 0x4A88, 0x4288, 0x4288, 0x73CD, 0xB5D5, 0xB595, 0xA553, 0xADB5, 0x9D32, 0x4AA9, 0x4268, 0x4AA9, 0x42A9, 
        0x4288, 0x7BEE, 0xAD54, 0xB595, 0xBDF6, 0x8CB0, 0x4268, 0x4268, 0x4AA9, 0x4AA9, 0x4A88, 0x8C90, 0xBDF6, 0xAD95, 0xB5B5, 0xB5B5, 0x7C2F, 0x7C2F, 0x52EA, 0x3A47, 0x52CA, 0x5B0A, 0x73CD, 0x94B0, 0xD656, 0xEF19, 0xE6F9, 0xCE14, 0x72E9, 0x8B6B, 
        0xBD93, 0x7B6B, 0x62A8, 0x834A, 0xC593, 0x9C4E, 0x6A67, 0x93ED, 0xC615, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6F8, 0xE6D8, 0xE6D8, 0xE6D8, 0xE6D9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 
        0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xDEF9, 0xDEF9, 0xDEF9, 0xDEF9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9,
  0x5B07, 0x4A84, 0x4AA5, 0x4A84, 0x3A23, 0x31E2, 0x3A23, 0x3A03, 0x3A23, 0x39E2, 0x39E2, 0x4A65, 0x4244, 0x4A84, 0x52C5, 0x4AA4, 0x7BEA, 0xB4EE, 0xB510, 0xBCEF, 0xB531, 0xB552, 0xB552, 0xB572, 0xA4AD, 0xB551, 0xBD30, 0xAD51, 0xB593, 0xAD52, 0xB572, 
        0xB530, 0xB510, 0xA46E, 0xA48E, 0x7BAB, 0x5AA7, 0x4A05, 0x5266, 0x5A86, 0x62A6, 0x6B27, 0x7B89, 0x6B48, 0x5AC6, 0x6307, 0x6B48, 0x6348, 0x6348, 0x4A85, 0x4A84, 0x5306, 0x6387, 0x846D, 0x9D33, 0x9D32, 0x9D32, 0x9D12, 0x9D31, 0x9D31, 0x9D32, 
        0xAD72, 0xA50F, 0x9CF0, 0x9CF0, 0x6328, 0x52A5, 0x5AE5, 0x4AA4, 0x52C4, 0x52C4, 0x4AA3, 0x4AA4, 0x4AA3, 0x5AE5, 0x4A83, 0x6B66, 0x6B25, 0x6B25, 0x52C5, 0x52C5, 0x4264, 0x3A22, 0x4263, 0x52E5, 0x52E5, 0x52C4, 0x3A43, 0x3A23, 0x3A43, 0x4AC5, 
        0x4A84, 0x4264, 0x21A2, 0x29A2, 0x29A3, 0x29A2, 0x3A44, 0x4285, 0x3A23, 0x3203, 0x3A44, 0x31E3, 0x2983, 0x2962, 0x2983, 0x31C3, 0x31A3, 0x2982, 0x2162, 0x29C3, 0x3204, 0x4286, 0x5B4A, 0xA4CE, 0xD5F3, 0xD6B9, 0xDE98, 0xDDF3, 0xDE98, 0xDEB9, 
        0xDEFA, 0xDEB9, 0xC616, 0xD678, 0xE633, 0xE655, 0xE71B, 0xDE98, 0xD697, 0x948E, 0x4A85, 0x3A44, 0x31E3, 0x3203, 0x31E3, 0x3A24, 0x3A24, 0x6329, 0x3A25, 0x2982, 0x31C3, 0x29C3, 0x29C3, 0x29A3, 0x31E4, 0x2162, 0x2162, 0x4A87, 0x31E5, 0x2162, 
        0x3A24, 0x3203, 0x31E3, 0x3A44, 0x3A44, 0x3A44, 0x3203, 0x3A24, 0x3A44, 0x31E3, 0x4245, 0x6328, 0xA530, 0xCDD3, 0x840D, 0xC636, 0xDE34, 0xDE13, 0xDEDA, 0xE6B8, 0xDE34, 0xDE97, 0xCE15, 0xD656, 0xA4F0, 0xBDF5, 0xDE55, 0xE5F0, 0xDEB8, 0xDEFA, 
        0xE654, 0xDE35, 0xC615, 0xC5F5, 0xCDF5, 0xAD73, 0xCE57, 0xE612, 0xE612, 0xE6FA, 0xE6F9, 0xE613, 0xD657, 0xC636, 0xDEB8, 0xAD51, 0xBDF5, 0xDE55, 0xE5D0, 0xDE97, 0xDED9, 0xDE34, 0xCE56, 0xBDD4, 0xC5F5, 0x9CAF, 0xBDB4, 0xDE34, 0xDE34, 0xDEFA, 
        0xDE98, 0xCE36, 0xC615, 0x7BED, 0x4226, 0x3184, 0x7BAC, 0xB4EE, 0xE633, 0xDEFA, 0xE676, 0xDE13, 0xB512, 0x7206, 0x7206, 0x7206, 0x59A5, 0x3103, 0x28E3, 0x4164, 0x7206, 0x7206, 0x61C6, 0x2903, 0x18C2, 0x5A88, 0x7A67, 0x71E6, 0x7A06, 0x8247, 
        0x7207, 0x4944, 0x5985, 0x7227, 0x59C6, 0x4144, 0x6A07, 0x7247, 0xCDB3, 0xDE34, 0xC636, 0xB593, 0xC615, 0xB594, 0xC5D4, 0xCD70, 0xDE97, 0xE6D9, 0xBD51, 0xAD73, 0xAD73, 0xAD53, 0xAD73, 0xAD32, 0xAD31, 0xDEDA, 0xDE98, 0x9CAE, 0xAD73, 0xB593, 
        0xBD93, 0xB573, 0xB573, 0xC572, 0xDEB9, 0xDE56, 0xB4EE, 0xAD31, 0xBDB3, 0xBD92, 0xBD92, 0xCDB1, 0xDE13, 0xDEDA, 0xE655, 0xD56F, 0xB50F, 0xB5B3, 0xBD72, 0xCD70, 0xD54E, 0xD656, 0xD698, 0xD698, 0x8BAC, 0x9BCC, 0xA44E, 0x8B8B, 0x8369, 0x7308, 
        0x41E6, 0x41E6, 0x41E6, 0x5287, 0x83AB, 0xA4AF, 0x9C2D, 0x8B89, 0x5A67, 0x62C9, 0x62A8, 0x4A06, 0xAD32, 0xC616, 0x73AD, 0x5AEA, 0x5226, 0x6A85, 0x9B66, 0xD56B, 0xDDAC, 0xC4A8, 0xAC08, 0xC5B3, 0xCE77, 0xCE77, 0xD698, 0xC616, 0x4A88, 0x29A5, 
        0x9CB1, 0xE6F9, 0xDEB9, 0xD678, 0xBDB4, 0xB594, 0x9CF1, 0x7BCD, 0xAD52, 0xAD52, 0x9CB0, 0xA48F, 0xA4D0, 0x946F, 0x5B2B, 0x4AEA, 0x52EA, 0xAD74, 0xBDD5, 0xB594, 0xC615, 0xC616, 0xCE56, 0xC615, 0x9CD0, 0xC5F5, 0xC5F5, 0xAD31, 0x4267, 0x4A67, 
        0xAD53, 0xB573, 0xAD32, 0x9CB0, 0x944E, 0x9C8F, 0xAD11, 0x9C8F, 0x9C8F, 0xC5F5, 0x94B0, 0x634B, 0xA533, 0xD699, 0xBDF6, 0xAD54, 0xB5D5, 0x8C90, 0x3A27, 0x530A, 0xB5B5, 0xAD74, 0xA533, 0xA533, 0xAD53, 0xAD94, 0x8CB0, 0x4268, 0x3A48, 0x3A48, 
        0x636C, 0xA533, 0x9D12, 0x9D12, 0xA553, 0xBDF6, 0x8CB1, 0x4268, 0x4248, 0x3A48, 0x73EE, 0xA554, 0x94B1, 0x94B1, 0x94D1, 0xA574, 0xA574, 0x4AA9, 0x3A27, 0x4268, 0x4289, 0x4AA9, 0x73EE, 0x8C90, 0x7C0E, 0xBDB4, 0xEF19, 0xC5B3, 0x7B29, 0x836A, 
        0xA44E, 0x8BAB, 0x7B8B, 0x8BAB, 0xA42E, 0x940D, 0x734A, 0x8BED, 0xBD73, 0xE6D9, 0xE6D9, 0xE6D9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 
        0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xDEF9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE719, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE719, 0xE719,
  0x29A1, 0x3223, 0x3A23, 0x29A2, 0x29A2, 0x29C2, 0x31C2, 0x39E3, 0x31C2, 0x3A23, 0x3A03, 0x4223, 0x4AA4, 0x4A64, 0x4243, 0x4AA4, 0x6BA9, 0xA4AD, 0xBDB2, 0xBD50, 0xB572, 0xAD32, 0xA531, 0xAD51, 0x6B48, 0x5B26, 0x5B06, 0x6327, 0x73CB, 0x73AB, 0x83EC, 
        0x8C0D, 0x948E, 0x9CAF, 0x738A, 0x6B29, 0x4A46, 0x41E4, 0x41E4, 0x5265, 0x5AA5, 0x5265, 0x5286, 0x5AA6, 0x5265, 0x52A5, 0x4A64, 0x52E6, 0x4AA5, 0x4AC4, 0x4AA4, 0x3A23, 0x52E4, 0x6367, 0xA4F0, 0xACF1, 0x9CD0, 0xA511, 0x9D12, 0x9CF2, 0x9512, 
        0x94D1, 0x6348, 0x52E5, 0x5B27, 0x5B27, 0x52C5, 0x52C5, 0x4243, 0x4A83, 0x52C4, 0x4263, 0x4283, 0x4AA4, 0x52C4, 0x5AE5, 0x52C4, 0x52A4, 0x6305, 0x4263, 0x3A22, 0x4264, 0x5306, 0x4AC4, 0x4263, 0x6346, 0x52E5, 0x42A4, 0x3202, 0x4AA4, 0x4263, 
        0x4AC5, 0x4284, 0x3A23, 0x3203, 0x3203, 0x3203, 0x3A44, 0x3202, 0x3203, 0x1941, 0x1942, 0x31E4, 0x31C3, 0x39E4, 0x41E4, 0x41C4, 0x39A3, 0x4204, 0x31C3, 0x39E4, 0x3A04, 0x31E3, 0x3A25, 0x8C4D, 0x9CB0, 0x94D0, 0x9CD0, 0x9CAF, 0x94D1, 0x94F1, 
        0x9512, 0x94F2, 0x9512, 0xADB4, 0xCDB3, 0xD614, 0xD6B9, 0xD678, 0xB5B4, 0x7C0B, 0x4265, 0x3A03, 0x31E3, 0x3A04, 0x3A23, 0x3203, 0x3A44, 0x6B8A, 0x4266, 0x2142, 0x2182, 0x29A3, 0x2163, 0x1921, 0x31C4, 0x2142, 0x2983, 0x4267, 0x4A67, 0x2983, 
        0x31E3, 0x31E4, 0x29C3, 0x3204, 0x29C3, 0x29A2, 0x31C3, 0x29A2, 0x3204, 0x31E4, 0x4225, 0x4244, 0x9CEF, 0xC5B2, 0x8C6F, 0xC636, 0xDE34, 0xDE13, 0xDEDA, 0xE6B8, 0xDE34, 0xDE76, 0xCDF4, 0xDE55, 0xA4D0, 0xBDF5, 0xDE55, 0xE5F1, 0xDEB8, 0xDEFA, 
        0xE654, 0xDE55, 0xC5F5, 0xC5D4, 0xBD72, 0xA511, 0xD677, 0xE633, 0xBD0D, 0xA531, 0xAD31, 0xC570, 0xCE36, 0xBDD5, 0xCE56, 0xAD52, 0xBDF5, 0xDE55, 0xE5D0, 0xDE97, 0xDED9, 0xDE34, 0xD656, 0xCE37, 0xCE56, 0xA511, 0xC616, 0xDE34, 0xDE34, 0xDEDA, 
        0xDE98, 0xCE36, 0xCE77, 0xBDD4, 0x8C4F, 0x2943, 0x7BAC, 0x940B, 0xE613, 0xDEFA, 0xE676, 0xDE34, 0xBD73, 0x7206, 0x7206, 0x7206, 0x59A5, 0x3103, 0x2903, 0x4164, 0x7206, 0x7206, 0x61C6, 0x3103, 0x2103, 0x6B0A, 0x7247, 0x7206, 0x7A26, 0x7A27, 
        0x7227, 0x4964, 0x5985, 0x7A27, 0x61C6, 0x4944, 0x6A07, 0x6A47, 0xCD92, 0xE695, 0xBDD5, 0x946F, 0xBDB4, 0x9CF1, 0xD676, 0xE612, 0xDE98, 0xE6B8, 0xDE33, 0xC615, 0xAD53, 0xD677, 0xB594, 0xCE15, 0xC550, 0xDEDA, 0xDE97, 0xCDB2, 0xBDD5, 0xB5B4, 
        0xBDB4, 0xB5B4, 0xB552, 0xBD30, 0xDEB9, 0xCDF4, 0x9CAF, 0xA532, 0xA532, 0xAD52, 0xAD32, 0xA4F1, 0xBD93, 0xE6FA, 0xCDD3, 0xA4EF, 0xB593, 0xBDB4, 0xBD93, 0xB593, 0xBD51, 0xD656, 0xD698, 0xD698, 0x8B8A, 0x9BAB, 0x8B4A, 0xA40C, 0x93EC, 0x838B, 
        0x72E9, 0x62C9, 0x5AA8, 0x9C4C, 0xD656, 0xD699, 0xB594, 0xACF0, 0x838A, 0x5A88, 0x732A, 0x5A67, 0x5A46, 0x7BAC, 0x6B4C, 0x5AEA, 0x5268, 0x834A, 0x9BEC, 0xA46D, 0xACAE, 0xB4CE, 0xACAE, 0xD636, 0xE6DA, 0xDED9, 0xE6D9, 0xBDD5, 0x4A67, 0x39C5, 
        0xA4F1, 0xE71A, 0xDED9, 0xD698, 0xBDD5, 0xAD73, 0x73AC, 0xAD32, 0xB573, 0x9CD0, 0xA4D0, 0x944E, 0x942E, 0x9CAF, 0x948F, 0x4AA8, 0x636C, 0xBDD5, 0xB5B5, 0xBDF6, 0xC636, 0xCE57, 0xCE57, 0xC616, 0xBDB4, 0xCE36, 0xCE36, 0xB573, 0x6B6C, 0x842E, 
        0xBDF5, 0xB594, 0xA4F1, 0x944E, 0xA4F0, 0xB552, 0xBD94, 0xB552, 0x9CAF, 0xAD53, 0xB5B4, 0x9CF1, 0xCE78, 0xBE16, 0x9D12, 0xA533, 0xAD74, 0xADB5, 0x5B0A, 0x8CB1, 0xB595, 0x94D1, 0x94B1, 0x94B1, 0xA553, 0xAD94, 0xB5D5, 0x73CD, 0x3A27, 0x52CA, 
        0x94D1, 0x8C90, 0x8C90, 0x9CD1, 0xA533, 0xA574, 0xBE37, 0x8470, 0x3A47, 0x73CD, 0xA554, 0x94D1, 0x8C70, 0x8C90, 0x94F2, 0x9D33, 0xADB5, 0x9D33, 0x4A88, 0x3A27, 0x4AA9, 0x9D12, 0xBE16, 0xC637, 0xB5D5, 0x844E, 0xC5F5, 0xACAF, 0x9C4E, 0x93CC, 
        0x6226, 0x8BAC, 0x9CD0, 0x8BEC, 0x6A46, 0x834A, 0xA532, 0x838B, 0x93ED, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 
        0xE6F9, 0xE6F9, 0xE6F9, 0xE719, 0xE71A, 0xE719, 0xE719, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE719, 0xE6F9, 0xE719, 0xE719, 0xE719, 0xE719, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE719, 0xE719, 0xE719, 0xE719, 0xE719, 0xE719,
  0x3A04, 0x31E3, 0x3A24, 0x2162, 0x29C2, 0x31A2, 0x3A04, 0x4224, 0x3A23, 0x3A03, 0x2162, 0x31C2, 0x3A03, 0x3A03, 0x29C2, 0x31E2, 0x4285, 0x6327, 0x7BCA, 0x942C, 0x9CCF, 0x7BEB, 0x844D, 0x94AF, 0x73CA, 0x5AE6, 0x52C5, 0x4243, 0x42A5, 0x5B28, 0x7BEB, 
        0xA4D0, 0x948F, 0xACAE, 0x7B69, 0x5AA7, 0x4A05, 0x5A66, 0x4A04, 0x5245, 0x5264, 0x5264, 0x5264, 0x4A24, 0x4A24, 0x5285, 0x5AE6, 0x5B28, 0x5B48, 0x4264, 0x3A23, 0x3A23, 0x3A43, 0x4263, 0xAD0E, 0xD614, 0xB550, 0x7BC9, 0x8C2B, 0x946D, 0x948E, 
        0xACCF, 0x7BA9, 0x4AA4, 0x4AC4, 0x5305, 0x5B26, 0x52E5, 0x4AA4, 0x4284, 0x4AA4, 0x4263, 0x4283, 0x4A84, 0x4243, 0x4AA4, 0x4A63, 0x52A4, 0x5B05, 0x52E5, 0x31E2, 0x3202, 0x3A23, 0x4AA5, 0x3A43, 0x4283, 0x4AC4, 0x52E5, 0x4AA4, 0x52E5, 0x52E5, 
        0x52E5, 0x4284, 0x4284, 0x4AC5, 0x3203, 0x3223, 0x4264, 0x4223, 0x3A03, 0x2141, 0x2142, 0x29C3, 0x29A3, 0x39C4, 0x39C4, 0x39A4, 0x39C4, 0x41E4, 0x4204, 0x39E3, 0x3A24, 0x31E3, 0x4A86, 0xAD52, 0xB5B4, 0xB5B4, 0xB593, 0xAD52, 0xB551, 0xB551, 
        0xA511, 0xA4F0, 0x9CAF, 0x94B0, 0x94AF, 0x94B0, 0x8C6E, 0x7C0D, 0x6349, 0x3A24, 0x3A03, 0x3203, 0x29A2, 0x31E3, 0x4264, 0x31E3, 0x3203, 0x31E3, 0x29A3, 0x2163, 0x2162, 0x29A3, 0x3A26, 0x2163, 0x29A4, 0x2163, 0x2142, 0x1922, 0x2143, 0x31C4, 
        0x29C3, 0x31E4, 0x2182, 0x31C3, 0x29A2, 0x29A2, 0x31E3, 0x2982, 0x2982, 0x31C4, 0x3A25, 0x4245, 0x9CCF, 0xDE97, 0xAD52, 0xC636, 0xDE34, 0xDE13, 0xDEDA, 0xE6B8, 0xDE34, 0xD656, 0xC5D4, 0xD635, 0xA4F1, 0xC616, 0xDE55, 0xE5F1, 0xDEB8, 0xDEFA, 
        0xE654, 0xDE55, 0xC5B3, 0xC5D4, 0xB531, 0xA532, 0xD677, 0xC591, 0x7367, 0x52A5, 0x52A5, 0x942B, 0xC5F5, 0xC5F5, 0xD676, 0x9CAF, 0xC5F5, 0xE655, 0xE5D0, 0xDE97, 0xDED9, 0xDE34, 0xD656, 0xBDD4, 0xC616, 0xA512, 0xBDF5, 0xDE34, 0xE654, 0xDEFA, 
        0xDE98, 0xD657, 0xCE77, 0xBDD5, 0x9470, 0x2943, 0x7BCD, 0xACAD, 0xE634, 0xE71B, 0xE676, 0xDE54, 0xCDD5, 0x7226, 0x71E6, 0x71E6, 0x59A5, 0x3103, 0x2903, 0x4164, 0x69E6, 0x7206, 0x61C6, 0x3103, 0x2102, 0x72EA, 0x7A47, 0x71E6, 0x7A06, 0x8247, 
        0x7227, 0x5185, 0x59A5, 0x7227, 0x59C5, 0x4944, 0x6A27, 0x6A47, 0xCD93, 0xE655, 0xB5B4, 0x948F, 0xAD52, 0x948F, 0xD676, 0xE612, 0xDEB8, 0xE6B8, 0xE654, 0xB573, 0x94B0, 0xBDB4, 0x946F, 0xD635, 0xD591, 0xDEDA, 0xDEB7, 0xDE54, 0xBDD5, 0xA512, 
        0xCE36, 0xB593, 0xDE56, 0xDDD1, 0xDEB9, 0xDE56, 0xCDD3, 0xBDF5, 0xB5B4, 0xB5B4, 0xB594, 0xBD72, 0xCDB2, 0xDEFA, 0xC5D3, 0xA4F0, 0xAD53, 0xAD52, 0xAD73, 0xA552, 0xA4F1, 0xCE37, 0xD698, 0xD698, 0x93AB, 0x93AB, 0x8B29, 0x9BCC, 0x93ED, 0x7B4B, 
        0x8328, 0x6AC7, 0x62A8, 0x940D, 0x9CB2, 0x9491, 0x9491, 0x8C4F, 0x83AB, 0x4A26, 0x62A9, 0x72E9, 0x7B29, 0x7309, 0x5AC8, 0x5AEA, 0x5288, 0x834A, 0x830A, 0x9BED, 0xA46F, 0xACB0, 0xBD93, 0xDED9, 0xDED9, 0xDED9, 0xCE77, 0xBDD5, 0xA532, 0xB573, 
        0xC616, 0xDEB8, 0xDEB8, 0xCE57, 0xB594, 0x7BED, 0x9CD1, 0xBDB4, 0xAD52, 0x9CD0, 0x942D, 0x944E, 0xA4B0, 0x944E, 0x9C8F, 0x6B4B, 0x7C0E, 0xC636, 0xBDF6, 0xC637, 0xCE57, 0xC616, 0xC616, 0xB594, 0xA4F1, 0xBDD5, 0xB573, 0xAD53, 0xA512, 0xBDD5, 
        0xBE16, 0xB5B4, 0x9CD0, 0xA4D0, 0xB552, 0xB593, 0xBDD4, 0xBD93, 0xAD11, 0xAD52, 0xBDD5, 0xAD53, 0xCE58, 0xAD94, 0x9CF1, 0x9CF2, 0xB5B5, 0xB5F6, 0xA553, 0xA533, 0xAD53, 0xB5B4, 0xAD94, 0x9D12, 0x9D12, 0xB5D5, 0xBE16, 0x9D32, 0x7C0E, 0x8CB1, 
        0x9CF2, 0x9D12, 0x9D12, 0x94B1, 0xA532, 0xAD94, 0xB5F6, 0xB5F6, 0x94B1, 0x9D13, 0x94D2, 0xA554, 0xAD74, 0x94D1, 0x844F, 0xA533, 0xAD94, 0xBE16, 0x7C2F, 0x5AEA, 0x94D1, 0xB5B5, 0xA533, 0xA553, 0xBE16, 0xBE16, 0x94B0, 0x8BCC, 0xA4AF, 0xA4CF, 
        0x9C4E, 0xA4AF, 0x9CF0, 0xA4D0, 0x9C6F, 0x9C8F, 0xA552, 0x946E, 0xA4AF, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE719, 0xE719, 0xE719, 0xE719, 0xE719, 0xE719, 0xE719, 0xE719, 
        0xE719, 0xE719, 0xE6F9, 0xE71A, 0xE71A, 0xE71A, 0xE719, 0xE71A, 0xE6FA, 0xE6FA, 0xE719, 0xE6F9, 0xE719, 0xE719, 0xE719, 0xE719, 0xE719, 0xE719, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE719, 0xE719, 0xE719, 0xE719, 0xE719, 0xE719,
  0x4AC6, 0x3A44, 0x31E3, 0x31C3, 0x4264, 0x4244, 0x3A03, 0x39E3, 0x31E3, 0x2141, 0x2141, 0x29A2, 0x31C2, 0x29A2, 0x31E2, 0x3203, 0x52C7, 0x738A, 0x842C, 0x6B49, 0x6B68, 0x5B06, 0x6BAA, 0x73EA, 0x5B07, 0x6B68, 0x6B47, 0x4AA4, 0x4284, 0x3A43, 0x4A85, 
        0x942B, 0x940D, 0xB46C, 0xB44B, 0x62A7, 0x5286, 0x5AC7, 0x4A25, 0x4A44, 0x4A24, 0x4A64, 0x4A23, 0x41E3, 0x4A25, 0x52A6, 0x4A85, 0x4AA5, 0x52E5, 0x4284, 0x3A44, 0x31E2, 0x3203, 0x3202, 0x4AE5, 0xB5B3, 0xB572, 0x4243, 0x4283, 0x4AC4, 0x6368, 
        0xAD0E, 0x7367, 0x4AA4, 0x4AC4, 0x52E5, 0x4283, 0x31E2, 0x31E2, 0x31C2, 0x31E3, 0x31E2, 0x4263, 0x4A84, 0x4A84, 0x4A84, 0x4A84, 0x4243, 0x5B05, 0x52E5, 0x4A84, 0x31E2, 0x29A1, 0x29A1, 0x3A63, 0x4AC4, 0x4AC4, 0x4AC4, 0x4AA4, 0x3A43, 0x4283, 
        0x52E5, 0x4AA5, 0x3A23, 0x4AA4, 0x4AA4, 0x3A64, 0x4264, 0x4A84, 0x4A84, 0x4244, 0x4264, 0x3203, 0x2182, 0x31C3, 0x31A4, 0x2943, 0x2943, 0x39A3, 0x39C3, 0x31C3, 0x39E3, 0x31E3, 0x4245, 0x8C8F, 0xB5D5, 0x9D32, 0xA553, 0xBE16, 0xDE55, 0xD655, 
        0xCE57, 0xDE54, 0xCE16, 0xBE16, 0xBE16, 0xBDF5, 0x73CA, 0x4264, 0x3A23, 0x3A23, 0x31A2, 0x4244, 0x31E3, 0x3A03, 0x3A24, 0x3A03, 0x3203, 0x3A03, 0x3204, 0x2142, 0x2983, 0x2983, 0x2142, 0x31E4, 0x2983, 0x2162, 0x1922, 0x10E1, 0x1922, 0x31C4, 
        0x29A3, 0x2162, 0x2162, 0x29A3, 0x29C3, 0x3A24, 0x3203, 0x31C3, 0x31E3, 0x31C3, 0x29A3, 0x5308, 0x94AF, 0xEF3A, 0xBDD5, 0xC657, 0xE654, 0xDE33, 0xE6FA, 0xE6D8, 0xDE34, 0xE6D8, 0xD657, 0xDEB8, 0xB5B4, 0xC616, 0xDE55, 0xE5F1, 0xDEB8, 0xDEFB, 
        0xE654, 0xDE35, 0xC5F4, 0xCE16, 0xAD11, 0xAD52, 0xCE56, 0x6B68, 0x3203, 0x3A03, 0x3A03, 0x6B68, 0xC5F4, 0xB5B3, 0x9CAE, 0x8C4D, 0x9CF0, 0x9C8D, 0xCD2E, 0xE6B8, 0xE6D9, 0xDE55, 0xDE97, 0xCDF4, 0xBDD4, 0x8C4E, 0xC636, 0xD5F2, 0xCDD2, 0xE71B, 
        0xDE98, 0xAD52, 0x73AC, 0x4226, 0x2984, 0x2964, 0x2963, 0x62A7, 0x8BEC, 0xC617, 0xE696, 0xE654, 0xC594, 0x7A46, 0x7A26, 0x7A27, 0x61E6, 0x3984, 0x39A4, 0x59E5, 0x7A27, 0x7A27, 0x6A06, 0x41C5, 0x41C5, 0x6206, 0x8267, 0x8A47, 0x8A67, 0x8A67, 
        0x8268, 0x59E5, 0x5226, 0x7A68, 0x6A06, 0x4984, 0x6A06, 0x7247, 0xCD72, 0xDE55, 0xBDD5, 0x94B0, 0xAD52, 0xA4F1, 0xD656, 0xDDF2, 0xDEB8, 0xE6D8, 0xDE34, 0xAD32, 0x94AF, 0xA511, 0x8C4E, 0xD635, 0xD592, 0xDEDA, 0xE6B8, 0xDE54, 0x9CF1, 0x9CB0, 
        0xA4F1, 0x840D, 0xDE76, 0xE612, 0xDED9, 0xDE76, 0xDE55, 0xAD52, 0xAD52, 0xAD52, 0xA532, 0xDE54, 0xDE13, 0xDED9, 0xDE55, 0xCDF4, 0xAD73, 0xC615, 0xB5B4, 0xBDD4, 0xBD30, 0xCE57, 0xD698, 0xD678, 0x836A, 0x834A, 0x8B6A, 0x93CC, 0xAC8F, 0xAC6E, 
        0x9BAB, 0x6AA7, 0x6AC9, 0xACF2, 0xA512, 0x9CB1, 0x83CD, 0x8C0E, 0x7BAD, 0x4A06, 0x3984, 0x5226, 0x93ED, 0x93ED, 0x732A, 0x7B8C, 0x8BED, 0x834A, 0x8B6B, 0x9BCC, 0xB46F, 0x9C0D, 0xB4F1, 0xBDB4, 0xC5F5, 0xCE36, 0xD6B8, 0xDEB8, 0xDEB8, 0xDEB9, 
        0xDED9, 0xDEB8, 0xD677, 0xC616, 0x840D, 0x94B0, 0xC615, 0xB5B4, 0xAD32, 0x944E, 0x9C8F, 0xACF1, 0xAD32, 0xACF1, 0x9C8F, 0x9490, 0xAD74, 0xC637, 0xC637, 0xCE57, 0xCE57, 0xBDD5, 0x9CF1, 0xB5B4, 0x52A8, 0x7BED, 0xA511, 0xA4F1, 0xB573, 0xB5B5, 
        0xC636, 0xBDD5, 0xAD32, 0xB552, 0xB573, 0xC5D4, 0xC5D4, 0xB593, 0xB552, 0xB553, 0xBDD5, 0xA512, 0xBDF6, 0xAD94, 0xC616, 0xAD73, 0xBDD5, 0xCE78, 0xC657, 0xAD95, 0xB5D5, 0xBE16, 0xBDF6, 0xB5B4, 0xA532, 0xB5B5, 0xC657, 0xC637, 0xB5B5, 0xA533, 
        0xB5B5, 0xBDF6, 0xBDF6, 0xB5B4, 0xA512, 0xAD94, 0xB5F6, 0xC657, 0xBE17, 0xA553, 0xAD74, 0xBDF6, 0xB5B5, 0xAD94, 0xA532, 0x9CF1, 0xB5B5, 0xB5F6, 0xB5F6, 0xAD74, 0xAD94, 0x94D1, 0x94B1, 0x9D33, 0xAD94, 0xBE37, 0xBE37, 0x73AC, 0x946F, 0xACAF, 
        0x9C0D, 0x9C0D, 0xB4F1, 0x9C2E, 0x93CD, 0x93CD, 0x8BAD, 0x93CD, 0xC5B4, 0xEF1A, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE719, 0xE719, 0xE719, 0xE719, 0xE719, 0xE71A, 0xE71A, 0xE71A, 
        0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE719, 0xE719, 0xE71A, 0xE71A, 0xE71A, 0xE71A,
  0x3203, 0x3A44, 0x3A24, 0x4A84, 0x4244, 0x4224, 0x4224, 0x39E3, 0x29A2, 0x2141, 0x2962, 0x2983, 0x31C2, 0x3A03, 0x31C2, 0x31C2, 0x5AE6, 0x7B89, 0x4A85, 0x4223, 0x4A85, 0x3A43, 0x3A23, 0x4263, 0x52C5, 0x52C5, 0x4243, 0x5305, 0x4AA4, 0x3A23, 0x31E2, 
        0x6B89, 0xA4F0, 0x942D, 0x7B49, 0x5245, 0x39C4, 0x39A3, 0x31A3, 0x4A65, 0x31A3, 0x31A2, 0x31A2, 0x39E4, 0x52A6, 0x3A03, 0x31E2, 0x4AC4, 0x5305, 0x4284, 0x3A23, 0x31C2, 0x31E2, 0x4AA5, 0x4AA4, 0x5B47, 0x6368, 0x4284, 0x31E2, 0x3222, 0x4AC4, 
        0x4AA5, 0x3A22, 0x4263, 0x4AA4, 0x4283, 0x4284, 0x3A23, 0x2981, 0x29A2, 0x29A2, 0x3A23, 0x4283, 0x4263, 0x4AA4, 0x4A84, 0x4AA4, 0x4242, 0x52C4, 0x4AA4, 0x4283, 0x4AC5, 0x4284, 0x4263, 0x4263, 0x4243, 0x29C2, 0x31E3, 0x29A2, 0x2161, 0x29C2, 
        0x3A43, 0x4284, 0x4AA4, 0x4284, 0x3A23, 0x3A64, 0x29E2, 0x29C2, 0x4264, 0x4A64, 0x4AA5, 0x4AC5, 0x3A03, 0x31C3, 0x31C3, 0x31A3, 0x3983, 0x41E4, 0x4204, 0x31A2, 0x2962, 0x29A3, 0x31C3, 0x4245, 0x52C8, 0x3A25, 0x7C2D, 0xAD73, 0xBDB3, 0xB5B3, 
        0xB5B4, 0xC5F3, 0xBDD4, 0xAD73, 0x9D31, 0x94CF, 0x6327, 0x4A84, 0x5B05, 0x52C5, 0x4A84, 0x52E5, 0x5B25, 0x4A84, 0x4264, 0x31C2, 0x2162, 0x29A2, 0x3204, 0x2962, 0x31C3, 0x4245, 0x31E3, 0x3A25, 0x3A05, 0x29C3, 0x1942, 0x1922, 0x1922, 0x2142, 
        0x2983, 0x1922, 0x1922, 0x1922, 0x2162, 0x31E3, 0x29A3, 0x29A3, 0x31E3, 0x29A3, 0x31E3, 0x844E, 0xA532, 0xB5B4, 0x9D12, 0xAD74, 0xBD72, 0xBD72, 0xCE58, 0xD656, 0xCDF4, 0xDEB9, 0xCE57, 0xDEB9, 0xBDF6, 0xC636, 0xDE75, 0xEE11, 0xE6D9, 0xE71B, 
        0xE654, 0xDE55, 0xE6D9, 0xDEB8, 0x9CCF, 0x73CB, 0x73CB, 0x52C6, 0x31C2, 0x3A03, 0x52A5, 0x5AE6, 0x94CF, 0x94AE, 0x5B07, 0x6348, 0x6328, 0x4224, 0x83A9, 0xE6D8, 0xE6FA, 0xC592, 0xAD30, 0xBDB3, 0xC5F4, 0x948F, 0x94CF, 0x73A9, 0x840B, 0xB5B3, 
        0xDE98, 0x948F, 0x7BCC, 0x7BCC, 0x2984, 0x4247, 0x4A88, 0x2943, 0x8C0D, 0xD699, 0xE696, 0xE654, 0xBD32, 0x8267, 0x8A67, 0x8267, 0x7226, 0x6A06, 0x6A06, 0x7A27, 0x8A47, 0x8A47, 0x7A26, 0x7206, 0x7A06, 0x8227, 0x8A67, 0x9267, 0x9267, 0x9267, 
        0x8A68, 0x7206, 0x6206, 0x8268, 0x7A68, 0x6226, 0x7A67, 0x8268, 0xC531, 0xE675, 0xC636, 0xBDF5, 0xB594, 0xAD52, 0xD656, 0xE5F2, 0xDEB8, 0xE6D8, 0xE634, 0xBDB4, 0xAD32, 0x948F, 0x94D0, 0xD635, 0xCD91, 0xDEDA, 0xDEB8, 0xDE34, 0xA532, 0x9CF1, 
        0x9CD0, 0x52A8, 0x944E, 0xBD30, 0xE6F9, 0xDE76, 0xDE35, 0x9CB0, 0xA4F1, 0x948F, 0xA4F1, 0xDE34, 0xDE34, 0xDEDA, 0xE655, 0xCE15, 0x94D0, 0xC5F5, 0x9CF1, 0xBDB4, 0xD592, 0xD677, 0xD698, 0xDEB9, 0x93ED, 0x7B09, 0xA44E, 0x836A, 0x93AB, 0x93EC, 
        0x7BCD, 0x83AD, 0x734B, 0x9CD1, 0xA512, 0x9C90, 0x8C0E, 0x9CB1, 0x9C90, 0x62C9, 0x5226, 0x6AEA, 0x5A67, 0x83AC, 0x7B4B, 0x83CC, 0xA46F, 0x6267, 0x8B8B, 0x9B8B, 0xB44E, 0x832A, 0x9C2E, 0xBDB4, 0xC5D5, 0xBD94, 0xC636, 0xD698, 0xDED9, 0xDEB8, 
        0xBDF5, 0xCE57, 0xDEB9, 0xAD53, 0x73AC, 0xC616, 0xBDF5, 0xBDB5, 0xAD12, 0xACF1, 0xB531, 0xAD31, 0xAD32, 0xAD11, 0xA4D1, 0x9CD1, 0xBE16, 0xC637, 0xCE58, 0xCE78, 0xCE57, 0xCE36, 0xB5B4, 0xC636, 0x5AE9, 0x842E, 0xC615, 0xC615, 0xBDF5, 0xAD53, 
        0xAD74, 0xB5B4, 0xB573, 0xB573, 0xB572, 0xB573, 0xAD32, 0x9CB0, 0x944F, 0x946F, 0x946F, 0x844F, 0xAD74, 0xA553, 0xB5B5, 0xAD74, 0xAD74, 0xBDF6, 0xBDF6, 0xAD54, 0xAD53, 0xB5B5, 0xC616, 0xBDF5, 0xAD94, 0xB5B4, 0xC637, 0xBDF6, 0xB5D5, 0xAD73, 
        0xB5D5, 0xC636, 0xCE57, 0xC636, 0xB5B4, 0xB5B5, 0xC637, 0xCE78, 0xC658, 0xAD74, 0xB5D5, 0xC636, 0xBDF6, 0xBDF6, 0xB5D5, 0xAD53, 0xB5B5, 0xC637, 0xBE37, 0xB5F6, 0xAD74, 0xAD94, 0xA553, 0xA533, 0xB5B5, 0xBE16, 0xCE98, 0xB553, 0x83AC, 0x72A8, 
        0x7A47, 0x82C9, 0xACF0, 0x8309, 0x7A67, 0x7247, 0x6206, 0x7227, 0xACD0, 0xEF3A, 0xE6F9, 0xE6F9, 0xE6F9, 0xE6F9, 0xE719, 0xE719, 0xE719, 0xE719, 0xE719, 0xE719, 0xE719, 0xE719, 0xE719, 0xE719, 0xE71A, 0xE719, 0xE719, 0xE71A, 0xE71A, 0xE71A, 
        0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A,
  0x31E3, 0x3A24, 0x3203, 0x31E3, 0x2982, 0x2161, 0x2982, 0x2962, 0x2982, 0x2142, 0x2982, 0x2162, 0x31C2, 0x3A03, 0x3A03, 0x4A65, 0x4A85, 0x4A65, 0x4A65, 0x4244, 0x31C2, 0x2982, 0x1941, 0x31E2, 0x4284, 0x4AA5, 0x3A23, 0x4263, 0x52C5, 0x4AC5, 0x3A03, 
        0x4245, 0x4AA6, 0x5AE8, 0x4225, 0x2921, 0x2942, 0x2962, 0x2962, 0x31C4, 0x2983, 0x2142, 0x2983, 0x39E3, 0x3A04, 0x4243, 0x4284, 0x4283, 0x4AA4, 0x3203, 0x3203, 0x3A64, 0x3A23, 0x4264, 0x42A4, 0x4A84, 0x3A43, 0x3A64, 0x3A43, 0x3203, 0x3203, 
        0x29A2, 0x3A44, 0x39E3, 0x2982, 0x2982, 0x2982, 0x31C2, 0x31C2, 0x3A23, 0x4AC4, 0x52E5, 0x52E5, 0x3202, 0x3A22, 0x4AA4, 0x4A84, 0x4AA4, 0x52E4, 0x52E5, 0x4AC4, 0x4263, 0x4AA4, 0x4263, 0x31E2, 0x4264, 0x29C2, 0x1921, 0x2141, 0x29C2, 0x3203, 
        0x3223, 0x3202, 0x29E2, 0x3A63, 0x4263, 0x4284, 0x3223, 0x2182, 0x3A23, 0x3203, 0x29C2, 0x4263, 0x52E5, 0x5AE5, 0x3A03, 0x4204, 0x41E4, 0x41E4, 0x4A24, 0x39E3, 0x2962, 0x31A3, 0x31A3, 0x39E4, 0x31E4, 0x3A25, 0x632A, 0x9CD1, 0xA532, 0x9D32, 
        0xA553, 0xAD73, 0xAD72, 0x73CA, 0x7C2C, 0x52E5, 0x52E5, 0x52E5, 0x4AA4, 0x4223, 0x3A23, 0x4242, 0x4AA4, 0x52C4, 0x4A84, 0x4264, 0x31E3, 0x29A3, 0x2962, 0x2141, 0x29A2, 0x29C3, 0x31C3, 0x31E3, 0x29E3, 0x31E3, 0x29C3, 0x1902, 0x1942, 0x2142, 
        0x2162, 0x1922, 0x2963, 0x1922, 0x2982, 0x31E4, 0x2142, 0x2162, 0x2182, 0x2162, 0x3204, 0xB550, 0xB593, 0xB551, 0xB531, 0xA511, 0xA511, 0xA4F1, 0x9CF1, 0x9CD0, 0x94B0, 0x9CD1, 0x9CD1, 0xA511, 0x94D1, 0x94D0, 0x9CD0, 0xA4AE, 0xAD53, 0xBDD5, 
        0xCDB2, 0xCE15, 0xDED9, 0xAD31, 0x52C7, 0x4264, 0x4A84, 0x4A64, 0x4224, 0x4224, 0x4A85, 0x4AA5, 0x6348, 0x52E6, 0x52E5, 0x52E5, 0x52C5, 0x4243, 0x52A5, 0x7BEB, 0x8C6E, 0x4A85, 0x4224, 0x9CEF, 0xDED9, 0x9CD0, 0x4265, 0x4264, 0x4284, 0x5B27, 
        0xAD52, 0xCE35, 0xD697, 0x6B6B, 0x1902, 0x2164, 0x29A4, 0x2122, 0x5AC9, 0xDEDA, 0xE696, 0xE654, 0xB511, 0x8267, 0x8A67, 0x8A68, 0x8247, 0x7206, 0x7A07, 0x8A27, 0x8A47, 0x8A48, 0x8227, 0x7A06, 0x8206, 0x8A26, 0x9267, 0x9267, 0x9268, 0x9268, 
        0x9288, 0x7A27, 0x7A06, 0x8A68, 0x8A88, 0x7226, 0x8267, 0x8A88, 0xC4CF, 0xE675, 0xC616, 0xBDD5, 0xB5D4, 0xB5B4, 0xD656, 0xE612, 0xDEB8, 0xE6D8, 0xDE34, 0xC615, 0xC615, 0x9CD0, 0xA552, 0xD635, 0xD591, 0xDEDA, 0xE6B8, 0xDE55, 0xC5F5, 0xBE15, 
        0x7BED, 0x4A67, 0x734A, 0xA44C, 0xC616, 0xE696, 0xDE35, 0xAD32, 0x9CF0, 0x948F, 0xAD52, 0xD5F3, 0xDE34, 0xDEDA, 0xDE35, 0xC5D4, 0x94D0, 0xBDB4, 0xA511, 0xBDB3, 0xCDB2, 0xD657, 0xD698, 0xDEB9, 0x8BAC, 0x7B07, 0xB4CE, 0x9BEC, 0x9368, 0xBD0D, 
        0xB532, 0x8BCC, 0x8328, 0xA4CF, 0xA553, 0xA512, 0x7BCD, 0x9490, 0x8C0F, 0x736C, 0x8BEE, 0x630A, 0x4A47, 0x5226, 0x5A88, 0x62A8, 0x72E8, 0x6A87, 0x7B09, 0x8B29, 0x9BEC, 0x938B, 0xB4F1, 0xDE77, 0xCE15, 0xC5D4, 0xBDB4, 0xCE57, 0xE6FA, 0xDED9, 
        0xC636, 0xCE77, 0xC636, 0xA512, 0xBD94, 0xC616, 0xC616, 0xBDF6, 0xA512, 0xB552, 0xBD73, 0xB552, 0xAD11, 0xA4F1, 0xA4D0, 0x9CB0, 0xCE77, 0xCE99, 0xD6B9, 0xD6B9, 0xD698, 0xCE57, 0xCE57, 0xCE16, 0xB573, 0xC5F5, 0xBDD5, 0x9CF1, 0x946F, 0x946F, 
        0x840E, 0x8C6F, 0x944F, 0x8C4E, 0x8C2E, 0x8C0D, 0x8C2E, 0x8C4E, 0x8C0D, 0x7BAC, 0x736B, 0x9CF2, 0xBE16, 0xA554, 0xA533, 0xA553, 0x9CF1, 0xA512, 0xA553, 0x9CF2, 0x94B1, 0x9D12, 0x9D12, 0xA553, 0xA553, 0x9CF2, 0x94D1, 0x9D12, 0xA533, 0x94B1, 
        0x9CF2, 0xAD94, 0xB5D5, 0xBE16, 0xBDF6, 0xBDD6, 0xCE78, 0xCE98, 0xCE58, 0xAD73, 0xB5B4, 0xBE16, 0xC636, 0xC637, 0xC636, 0xBDF6, 0xBDF6, 0xC658, 0xBDF6, 0xC657, 0xC616, 0xC636, 0xBE36, 0xB5D5, 0xBDF6, 0xBE37, 0xCE99, 0xAD12, 0x8B6B, 0x7AA8, 
        0x7A47, 0x7AA8, 0xA4F0, 0x7AA8, 0x8AA8, 0x8288, 0x7A88, 0x7247, 0x83AB, 0xE6F9, 0xE719, 0xE6F9, 0xE719, 0xE719, 0xE719, 0xE719, 0xE719, 0xE719, 0xE71A, 0xE71A, 0xE719, 0xE719, 0xEF19, 0xEF19, 0xEF1A, 0xE71A, 0xE71A, 0xEF1A, 0xEF1A, 0xE719, 
        0xE719, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE71A, 0xE73A, 0xE71A, 0xE73A, 0xE73A, 0xE73A, 0xE73A, 0xE71A, 0xE71A, 0xE71A, 0xE71A,
  0x29E3, 0x2182, 0x2982, 0x29A2, 0x2162, 0x2982, 0x31C3, 0x2983, 0x1921, 0x2142, 0x2982, 0x2982, 0x1921, 0x2982, 0x4223, 0x4A64, 0x4A64, 0x4244, 0x3A03, 0x4243, 0x3A23, 0x2982, 0x2161, 0x2182, 0x29C2, 0x3A63, 0x4284, 0x3203, 0x4A84, 0x4AA4, 0x4AA4, 
        0x3A43, 0x2181, 0x29C2, 0x52A6, 0x31A3, 0x2121, 0x2122, 0x2101, 0x2122, 0x2122, 0x2102, 0x2122, 0x31A3, 0x31C3, 0x4264, 0x3A43, 0x3203, 0x29A2, 0x29A2, 0x2181, 0x31E2, 0x3A23, 0x29E2, 0x31E2, 0x3A44, 0x29E2, 0x3203, 0x3A23, 0x2181, 0x2161, 
        0x2161, 0x3203, 0x3223, 0x29A2, 0x31E3, 0x2161, 0x3203, 0x4264, 0x3202, 0x4AA4, 0x4243, 0x3A43, 0x3202, 0x31E2, 0x3A23, 0x3A43, 0x3203, 0x3A23, 0x4AA4, 0x52C5, 0x3A22, 0x4AA4, 0x4243, 0x21A1, 0x29E3, 0x29A2, 0x2182, 0x3203, 0x3203, 0x29A2, 
        0x29C2, 0x29A2, 0x2181, 0x3A23, 0x4AC4, 0x3A43, 0x29C2, 0x1941, 0x3203, 0x3A44, 0x29A2, 0x3203, 0x4AA4, 0x4AA5, 0x31C2, 0x2962, 0x39E3, 0x41E3, 0x4A04, 0x31A3, 0x2142, 0x2982, 0x31C3, 0x4225, 0x3A04, 0x3A04, 0x62E8, 0xA48D, 0xB4EF, 0xACEF, 
        0xA4D0, 0x946E, 0x5B07, 0x4285, 0x5B06, 0x4A84, 0x4264, 0x4263, 0x4AA4, 0x4264, 0x3A23, 0x4AA4, 0x4243, 0x4A83, 0x4AA4, 0x4AA4, 0x4A84, 0x4244, 0x3A23, 0x3A24, 0x2162, 0x2162, 0x31C3, 0x4244, 0x31C3, 0x29C3, 0x29C3, 0x1922, 0x2162, 0x1922, 
        0x29A3, 0x29A3, 0x2983, 0x2162, 0x29A3, 0x31C3, 0x1901, 0x2142, 0x29C3, 0x29A3, 0x29C4, 0x7BCA, 0x9D11, 0xDE55, 0xDE35, 0xBE16, 0xC616, 0xC616, 0xC616, 0xBDF5, 0xB5B4, 0xC5B2, 0xC5B2, 0xB593, 0xBD72, 0xAD11, 0xA4F1, 0xA4F1, 0x9CD0, 0x9CD0, 
        0x9CD0, 0x9CD0, 0xA4F1, 0x5B08, 0x31C3, 0x31C3, 0x3A24, 0x31C3, 0x4A64, 0x3A24, 0x29C2, 0x4264, 0x4264, 0x3A43, 0x4283, 0x52C5, 0x52E5, 0x5AE5, 0x52E5, 0x4264, 0x4244, 0x3A23, 0x4244, 0x73CA, 0xBE15, 0x94D0, 0x3203, 0x4264, 0x3A23, 0x3A03, 
        0x4AA5, 0x6BAA, 0x73CB, 0x3A06, 0x31A5, 0x31C5, 0x31A5, 0x29A4, 0x31C4, 0xBDF6, 0xE696, 0xDE34, 0xC573, 0x7A46, 0x8247, 0x8247, 0x7206, 0x69E6, 0x7206, 0x7A26, 0x8247, 0x8247, 0x7A26, 0x7A26, 0x7A47, 0x7A47, 0x8267, 0x8287, 0x8AA8, 0x82A8, 
        0x7A88, 0x7A27, 0x7206, 0x8268, 0x8A88, 0x7227, 0x8267, 0x8A88, 0xC4EF, 0xE675, 0xC5F5, 0xB5B4, 0xAD73, 0xB593, 0xDE76, 0xE612, 0xDEB8, 0xE6D8, 0xE634, 0xC615, 0xBDF5, 0xA532, 0xAD73, 0xD655, 0xD5B1, 0xDEDA, 0xE6B8, 0xDE34, 0xCE56, 0xC636, 
        0x634A, 0x630A, 0x942D, 0xBCEE, 0xBDB4, 0xE696, 0xDE55, 0xC615, 0xBDD4, 0x9CF0, 0xB5B3, 0xDE13, 0xDE34, 0xDEDA, 0xE655, 0xD615, 0xA552, 0xB593, 0xA532, 0xBDB4, 0xCD91, 0xD676, 0xD698, 0xD678, 0x838A, 0x938A, 0xAC6D, 0xB48C, 0xC4ED, 0xBCEE, 
        0xAC6D, 0xA3A9, 0xBC8C, 0xB4EE, 0xA4F1, 0xA4F2, 0x840F, 0xA4F2, 0xA533, 0x8C2F, 0x9471, 0x6B4B, 0x83EE, 0x942E, 0x83AC, 0x7329, 0x72C7, 0x5A66, 0x6AA8, 0x7B2A, 0x836B, 0x836B, 0x9C4E, 0xAD11, 0xAD31, 0xA511, 0x9CF1, 0xA512, 0xAD52, 0xAD32, 
        0xA511, 0xA532, 0xA552, 0x9CD0, 0x9C90, 0xBDB5, 0xCE57, 0xBDF6, 0xAD52, 0xB553, 0xB573, 0xB573, 0xAD32, 0x944E, 0x840D, 0x8C2E, 0xA532, 0xAD53, 0xAD53, 0xAD33, 0xA4F2, 0xA4F1, 0x9CB0, 0x946F, 0x944E, 0x8C2E, 0x840D, 0x83ED, 0x83CC, 0x942E, 
        0x840D, 0x7BAC, 0x840D, 0xA4F1, 0xA4F1, 0xA4D0, 0x8C2E, 0xAD32, 0xAD32, 0x946F, 0x9CB0, 0xC616, 0xD6B9, 0xCE78, 0xCE78, 0xC657, 0xB5D5, 0xBDF6, 0xCE58, 0xAD94, 0xB5B5, 0xBE17, 0xBE16, 0xBDF6, 0xB5D5, 0x9D12, 0x94B1, 0xAD74, 0xAD74, 0xA533, 
        0xA553, 0xA553, 0xA553, 0xA553, 0xA553, 0xA533, 0xA553, 0xA553, 0xA553, 0x94D1, 0x94D1, 0xA553, 0xAD94, 0xAD94, 0xB5D5, 0xB5B5, 0xB5B5, 0xB5B5, 0xB5D6, 0xCE78, 0xBDD5, 0xBE16, 0xCE57, 0xC637, 0xC657, 0xCE78, 0xD6B9, 0xBD94, 0x8B8B, 0x7AA8, 
        0x7227, 0x834A, 0xB531, 0x8B6B, 0x7A68, 0x8288, 0x7A67, 0x7A67, 0x9C4E, 0xE6F9, 0xE719, 0xE719, 0xE719, 0xE719, 0xE719, 0xE719, 0xE719, 0xEF19, 0xEF19, 0xEF19, 0xEF19, 0xEF19, 0xEF19, 0xEF19, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF19, 
        0xEF19, 0xEF19, 0xEF1A, 0xEF1A, 0xE71A, 0xE71A, 0xE71A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF3A, 0xEF3A, 0xEF3A, 0xEF3A, 0xEF3A, 0xF75A, 0xF75A, 0xEF3A, 0xEF3A, 0xEF5A, 0xEF39, 0xEF5A, 0xF75B, 0xEF3A, 0xE73A,
  0x2162, 0x2162, 0x1901, 0x1901, 0x1901, 0x2122, 0x39E4, 0x3A05, 0x29A4, 0x2141, 0x2962, 0x1901, 0x2142, 0x4A85, 0x4244, 0x52C6, 0x52A6, 0x2141, 0x31C2, 0x3A03, 0x4244, 0x29A2, 0x2161, 0x1941, 0x2162, 0x29A2, 0x29C2, 0x31E2, 0x3A23, 0x4264, 0x3A43, 
        0x3A64, 0x3A64, 0x3A23, 0x4AA5, 0x31A3, 0x2101, 0x2122, 0x2942, 0x2942, 0x39C3, 0x2982, 0x2962, 0x31C3, 0x3A44, 0x3A23, 0x29A2, 0x31E3, 0x2162, 0x2182, 0x3A23, 0x4263, 0x3A43, 0x3A23, 0x3203, 0x1941, 0x29E3, 0x3A23, 0x4264, 0x3203, 0x2182, 
        0x21A2, 0x29A2, 0x21A2, 0x21A2, 0x31E3, 0x2182, 0x3A03, 0x31E2, 0x3A23, 0x3A23, 0x1921, 0x3A03, 0x4AA4, 0x3203, 0x29A2, 0x29A2, 0x29C2, 0x3A44, 0x3A23, 0x4244, 0x4AC5, 0x52E4, 0x4AA4, 0x31E2, 0x29C2, 0x29C2, 0x2182, 0x2162, 0x2162, 0x1921, 
        0x21A2, 0x3223, 0x29C2, 0x29C2, 0x4263, 0x4284, 0x3A03, 0x2141, 0x2162, 0x29C3, 0x29A3, 0x1101, 0x29C2, 0x3A44, 0x4265, 0x3A23, 0x4A64, 0x39E3, 0x39C3, 0x2982, 0x2962, 0x2983, 0x2962, 0x2983, 0x39E4, 0x4225, 0x7BCB, 0xB4EF, 0xBD2F, 0xB551, 
        0xBDD5, 0x842C, 0x3202, 0x3A43, 0x29C2, 0x31E3, 0x2182, 0x31E3, 0x3203, 0x31E2, 0x31E2, 0x4A84, 0x4A84, 0x52C4, 0x52A4, 0x6325, 0x6305, 0x5AE5, 0x4A84, 0x3A43, 0x2162, 0x1922, 0x31E3, 0x3A24, 0x3A24, 0x4265, 0x3204, 0x2983, 0x1922, 0x1942, 
        0x3A04, 0x3A24, 0x2142, 0x18E2, 0x2122, 0x31E4, 0x31A3, 0x2162, 0x29A3, 0x29C3, 0x29C3, 0x4AA6, 0x4266, 0x7C0B, 0xB592, 0xBDF5, 0xADB4, 0xB5D5, 0xB5D5, 0xBE16, 0xBDF6, 0xCE35, 0xD635, 0xCE57, 0xDE54, 0xCE15, 0xBE36, 0xC636, 0xBE16, 0xC5F5, 
        0xB593, 0x948E, 0x6B28, 0x94CF, 0x5B08, 0x2982, 0x2962, 0x31E3, 0x3A04, 0x2142, 0x2162, 0x52C7, 0x4264, 0x4264, 0x4A84, 0x4264, 0x4264, 0x4A84, 0x4AA4, 0x4AA5, 0x4A84, 0x3A44, 0x4A85, 0x4AC5, 0x6369, 0x4A86, 0x3A23, 0x4AA5, 0x4AC5, 0x3A44, 
        0x3A24, 0x3A44, 0x4264, 0x31E4, 0x4A67, 0x29A5, 0x73CD, 0x5AE9, 0x31C3, 0x6B6A, 0x7389, 0xA4F0, 0xAD32, 0x7329, 0x834A, 0x834A, 0x7B4A, 0x7B6A, 0x7B6A, 0x838B, 0x8BAB, 0x8BAB, 0x83AB, 0x8BEC, 0x8BEC, 0x8BEC, 0x8BEC, 0x940D, 0x8BED, 0x7B8B, 
        0x736B, 0x7B6B, 0x7B4B, 0x7B2A, 0x7309, 0x72C9, 0x72C8, 0x7AC9, 0xB4CF, 0xDE34, 0xC615, 0xBDF5, 0xB5B4, 0xB594, 0xDE76, 0xE612, 0xE6B8, 0xE6D8, 0xE634, 0xC615, 0xC615, 0x94D0, 0xA532, 0xD656, 0xD5B1, 0xDEDA, 0xE6B8, 0xDE54, 0xC636, 0xB5D4, 
        0x6B8B, 0x52A8, 0x946E, 0xC550, 0xE6FA, 0xE676, 0xDE55, 0xC616, 0xBDF5, 0xAD52, 0xBDD4, 0xDE14, 0xDE34, 0xE6DA, 0xE655, 0xD635, 0xC616, 0xC636, 0xB594, 0xC5F4, 0xCD91, 0xD677, 0xD698, 0xDE98, 0xAC8F, 0xAC2E, 0xA42E, 0x93CB, 0xB4AF, 0xB4B0, 
        0x938B, 0x9BCA, 0x838B, 0x93ED, 0xA46D, 0x6B2A, 0x62EA, 0x6B6C, 0x73AD, 0x52A9, 0x5268, 0x62CA, 0x7B8B, 0x93A9, 0xB409, 0x9389, 0xA3CA, 0xB46B, 0x7309, 0x836B, 0x938B, 0x93CA, 0x734A, 0x736A, 0x6B8A, 0x9CD0, 0xA511, 0x9C6D, 0xACD0, 0xAD32, 
        0xA4F1, 0xB552, 0xB594, 0xA512, 0x8C2E, 0x9490, 0x9CB1, 0x946F, 0x944F, 0x948F, 0x946F, 0x944E, 0x942E, 0x8C2E, 0x8C0D, 0x83CD, 0x944E, 0x944F, 0x840D, 0x946F, 0x944F, 0x83ED, 0xA4B0, 0xA4B0, 0xA4D0, 0x9C8F, 0x8C0D, 0xA4B0, 0x9CB0, 0xAD11, 
        0xA4F1, 0x8C4F, 0x9CD1, 0xAD53, 0xB553, 0xB553, 0xAD52, 0xB553, 0xAD12, 0x9CB0, 0xAD53, 0xB5B5, 0xC637, 0xC637, 0xC657, 0xCE58, 0xBDF6, 0xBE16, 0xCE78, 0xBDF6, 0xC637, 0xCE78, 0xCE78, 0xCE78, 0xC658, 0xB5B5, 0xA533, 0xCE78, 0xCE78, 0xC637, 
        0xCE78, 0xCE78, 0xC657, 0xC637, 0xC637, 0xB5D6, 0xAD94, 0xBDF6, 0xAD94, 0x9CF2, 0xAD94, 0xAD94, 0xAD74, 0xA574, 0xA554, 0xA533, 0x9490, 0x8C70, 0x94D1, 0x9D12, 0x94D1, 0xA533, 0xAD74, 0xAD74, 0xAD74, 0xB5B5, 0xB5B5, 0xB5B5, 0x8BCC, 0x6A87, 
        0x72A8, 0x9BED, 0x8309, 0xA42C, 0x8309, 0x7267, 0x7267, 0x7AA8, 0xA4D0, 0xDED8, 0xEF19, 0xEF19, 0xEEF9, 0xEF19, 0xEF19, 0xEF19, 0xEF19, 0xEF19, 0xEF1A, 0xEF19, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF19, 0xEF19, 0xEF1A, 0xEF1A, 0xEF19, 
        0xEF19, 0xEF19, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF19, 0xEF19, 0xEF39, 0xEF1A, 0xF73A, 0xF75A, 0xF75A, 0xF75A, 0xF75B, 0xF75A, 0xE6F9, 0xEF19, 0xF75A, 0xF73A, 0xC5D3, 0xBDD4, 0x844D, 0x6349, 0x7C0C, 0x73CB, 0x9D10, 0xA531, 0xD676, 0xEF3A,
  0x2182, 0x2162, 0x10E1, 0x10C1, 0x10A1, 0x2122, 0x39E4, 0x4226, 0x2963, 0x2142, 0x2141, 0x1901, 0x31E3, 0x3A43, 0x3A23, 0x4284, 0x3A03, 0x31E2, 0x4A64, 0x4243, 0x4243, 0x29A2, 0x2182, 0x2162, 0x29A2, 0x29C2, 0x29A2, 0x2181, 0x2181, 0x3A44, 0x3203, 
        0x29A1, 0x3203, 0x3A23, 0x3A43, 0x29A2, 0x2142, 0x18E1, 0x31A3, 0x31C3, 0x39E3, 0x3A03, 0x31A3, 0x2162, 0x29A2, 0x2141, 0x2162, 0x2142, 0x08C1, 0x2162, 0x3A44, 0x4AC5, 0x3A43, 0x29A2, 0x29C3, 0x1921, 0x2182, 0x3203, 0x3A43, 0x3203, 0x29C3, 
        0x2162, 0x1921, 0x1901, 0x1101, 0x1921, 0x2162, 0x3203, 0x29C2, 0x29C2, 0x29A2, 0x1921, 0x3203, 0x4A84, 0x4284, 0x3A23, 0x29A2, 0x29A2, 0x2982, 0x2141, 0x2181, 0x3203, 0x3A02, 0x52C4, 0x4A64, 0x3A03, 0x29A2, 0x10E1, 0x1101, 0x10E1, 0x10C1, 
        0x1942, 0x31E3, 0x29C3, 0x29C2, 0x3203, 0x3203, 0x3A24, 0x31E3, 0x2162, 0x1101, 0x2162, 0x2162, 0x29C3, 0x31E3, 0x29A2, 0x3203, 0x4AA5, 0x3A03, 0x2982, 0x2962, 0x2962, 0x2983, 0x31A3, 0x31A3, 0x31C4, 0x6329, 0xA4AE, 0xB551, 0xB593, 0xA532, 
        0xA532, 0x6BAA, 0x29C2, 0x29C2, 0x29A2, 0x2182, 0x2162, 0x3A44, 0x3A44, 0x29C2, 0x31E2, 0x4A84, 0x52A4, 0x4A63, 0x4A83, 0x52A4, 0x52A4, 0x4A84, 0x4A64, 0x31E3, 0x31E3, 0x29A3, 0x29A2, 0x29A2, 0x29E3, 0x3A24, 0x29C3, 0x29A3, 0x2983, 0x29C3, 
        0x29A3, 0x3A24, 0x3A04, 0x18E1, 0x2162, 0x31E3, 0x4A85, 0x31C3, 0x2162, 0x29A3, 0x29C3, 0x29C3, 0x3204, 0x21A2, 0x52E7, 0x8C6E, 0x6B69, 0x844D, 0x8C8F, 0xAD73, 0xA553, 0xAD73, 0xB593, 0xAD73, 0xAD72, 0xAD73, 0xAD72, 0xAD92, 0xA531, 0x94AE, 
        0x8C2B, 0x6306, 0x5AA5, 0x8C6E, 0x6B8A, 0x31A3, 0x31C3, 0x4265, 0x31E4, 0x2162, 0x2982, 0x52E7, 0x3A24, 0x4284, 0x4264, 0x3A64, 0x29C2, 0x3203, 0x31E2, 0x4284, 0x4AC5, 0x3A44, 0x4284, 0x4AA5, 0x4264, 0x29A2, 0x3203, 0x3A44, 0x3A44, 0x31E3, 
        0x29A2, 0x3A24, 0x3A24, 0x4265, 0x3A25, 0x2983, 0x5AEA, 0x73AB, 0x3A04, 0x3A23, 0x29A2, 0x73CB, 0x844E, 0x83CC, 0x8BCC, 0x8BCC, 0x838B, 0x836B, 0x7B6B, 0x7B4A, 0x6AE9, 0x6AE9, 0x6AC9, 0x62A8, 0x5A88, 0x5A67, 0x5A67, 0x5A67, 0x5A47, 0x5247, 
        0x4A27, 0x5A68, 0x5AA9, 0x62EA, 0x6B0A, 0x6B2A, 0x736C, 0x738C, 0x7BCC, 0xA511, 0xC615, 0xBDF5, 0xB593, 0xB5B4, 0xDE76, 0xE612, 0xE6B8, 0xE6D8, 0xE634, 0xC615, 0xC615, 0x94D0, 0xAD73, 0xD656, 0xD591, 0xDEDA, 0xE6B7, 0xDE55, 0xC636, 0xBDD4, 
        0x4A67, 0x4247, 0x41E5, 0x8BAA, 0xB594, 0xE696, 0xDE55, 0xBDD4, 0xB5B4, 0x9CF0, 0xBDF4, 0xDE14, 0xE634, 0xE6DA, 0xE655, 0xD635, 0xBE15, 0xBE16, 0xB593, 0xC5F5, 0xD5B1, 0xD677, 0xD698, 0xD698, 0x9C6F, 0x942E, 0xA490, 0x942E, 0x7BAB, 0x83EC, 
        0x7BCB, 0x83CB, 0x734A, 0x83CD, 0x9C8F, 0x9490, 0x6B2B, 0x6B2B, 0x738D, 0x3165, 0x2903, 0x5226, 0x6265, 0x72C7, 0x8307, 0x82C5, 0x6AA7, 0xA3CA, 0x8B8A, 0x8349, 0x93CA, 0xB4AD, 0x93C9, 0x8B89, 0x838A, 0x8C0C, 0xACD0, 0xA3C9, 0xCD70, 0xDE77, 
        0xC5D5, 0xCE16, 0xD657, 0xCE36, 0x9CD0, 0x8C0E, 0x946F, 0x8C2E, 0x9CB0, 0xA4D0, 0xACF1, 0x9C8F, 0x9C6F, 0xA4F1, 0xA4B0, 0x8C2E, 0xAD32, 0xB573, 0xAD11, 0xAD31, 0xA4D0, 0x9C8F, 0xAD12, 0xAD12, 0xAD11, 0xA4F1, 0xA4B0, 0x9C8F, 0x9C8F, 0x9C6F, 
        0x9CB0, 0x94B0, 0xA532, 0xAD52, 0xAD53, 0xB573, 0xB594, 0xB5B4, 0xB594, 0xAD52, 0x9CB0, 0xA512, 0xB594, 0xC616, 0xCE78, 0xCE78, 0xBDF6, 0xB5B5, 0xBDF6, 0xBE16, 0xC658, 0xC658, 0xC658, 0xC658, 0xC658, 0xB5D6, 0x9CF2, 0xB5B5, 0xBDF6, 0xC658, 
        0xC678, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xC658, 0xBE16, 0xCE98, 0xC637, 0xB5D5, 0xC658, 0xCE78, 0xCE78, 0xCE78, 0xCE78, 0xC657, 0xAD74, 0x9D12, 0xC616, 0xBDF6, 0xB5B5, 0xB5D6, 0xB5D5, 0xB594, 0xA553, 0xAD53, 0xAD94, 0x844E, 0x5AA8, 0x6AC8, 
        0xB48C, 0xB46A, 0xC4CB, 0xBCCA, 0xC54D, 0x7B69, 0x5246, 0x6B6A, 0x9D10, 0xCE56, 0xEF3A, 0xEF19, 0xEF19, 0xEF19, 0xEF19, 0xEF19, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF19, 0xEF19, 0xEF19, 0xEF19, 0xF719, 0xF719, 0xEF19, 
        0xEF19, 0xEF19, 0xEF19, 0xEF19, 0xEF19, 0xEF19, 0xEF1A, 0xEF3A, 0xFF7B, 0xDE97, 0xC5F4, 0xC5F4, 0xCE55, 0x94AE, 0x73CB, 0x52E7, 0x842D, 0xAD52, 0xB571, 0x4A86, 0x29C4, 0x2163, 0x1943, 0x2163, 0x2163, 0x2983, 0x29A4, 0x6309, 0x738B,
  0x3204, 0x2182, 0x1101, 0x1902, 0x10A1, 0x10C1, 0x1901, 0x31C4, 0x2983, 0x1921, 0x2121, 0x2962, 0x3A44, 0x29C2, 0x31E2, 0x3202, 0x31E2, 0x3A23, 0x4244, 0x4243, 0x3A03, 0x29A2, 0x29A2, 0x2162, 0x31E3, 0x3203, 0x29C3, 0x29A2, 0x29C2, 0x29A2, 0x3223, 
        0x3223, 0x4264, 0x3202, 0x3203, 0x3A03, 0x2162, 0x10C0, 0x2982, 0x31C3, 0x2141, 0x2121, 0x2162, 0x2162, 0x2162, 0x3183, 0x2942, 0x1901, 0x10C1, 0x3224, 0x31E2, 0x4AA4, 0x4AA4, 0x29A2, 0x2182, 0x3203, 0x3A44, 0x3203, 0x3203, 0x31E3, 0x2161, 
        0x2182, 0x2162, 0x1941, 0x1921, 0x1921, 0x3204, 0x3A44, 0x3A44, 0x3A24, 0x29C3, 0x3A44, 0x3203, 0x3A44, 0x29C2, 0x3A44, 0x3A23, 0x2162, 0x2162, 0x2182, 0x2182, 0x31E3, 0x3A03, 0x4243, 0x4A84, 0x5AE5, 0x4244, 0x3A24, 0x2982, 0x10A1, 0x10E1, 
        0x1942, 0x1942, 0x1901, 0x29C3, 0x31E3, 0x2182, 0x3203, 0x31E3, 0x2162, 0x2182, 0x31E3, 0x3203, 0x3203, 0x3223, 0x29A2, 0x29C2, 0x4264, 0x3A03, 0x3A23, 0x39C3, 0x2942, 0x2963, 0x31A3, 0x2983, 0x31C4, 0x52A7, 0x6309, 0x9CB0, 0xA46D, 0x8B89, 
        0x6B07, 0x4264, 0x29C2, 0x29A2, 0x29C3, 0x1942, 0x2182, 0x29C3, 0x29C2, 0x3A24, 0x4264, 0x4243, 0x4A84, 0x4243, 0x4A84, 0x4A63, 0x4222, 0x4223, 0x4243, 0x4223, 0x5B05, 0x5AE6, 0x4244, 0x31E3, 0x29C3, 0x31E3, 0x2162, 0x1942, 0x1922, 0x2142, 
        0x2142, 0x31E3, 0x4264, 0x29A3, 0x2162, 0x4A84, 0x5B25, 0x6326, 0x4AA5, 0x3A23, 0x3A23, 0x3A24, 0x3204, 0x31E4, 0x3A25, 0x52C7, 0x52E6, 0x5B07, 0xA4F0, 0xAD11, 0xACF1, 0xAD32, 0xAD53, 0xAD74, 0xAD94, 0xB594, 0xA531, 0x7BEB, 0x6B68, 0x6B26, 
        0x6B26, 0x5AA5, 0x62E6, 0x4A24, 0x4245, 0x4A44, 0x5AE6, 0x5285, 0x4224, 0x2142, 0x29C3, 0x3A44, 0x31E3, 0x31E3, 0x3A23, 0x3A44, 0x2162, 0x2182, 0x29C2, 0x3A23, 0x4284, 0x3A23, 0x3A64, 0x3A23, 0x3A44, 0x3A24, 0x2182, 0x3204, 0x3A24, 0x3A24, 
        0x2162, 0x29C3, 0x29C3, 0x3A44, 0x4264, 0x4225, 0x4246, 0x4A86, 0x4224, 0x3203, 0x3A24, 0x5B29, 0x6B6A, 0x41A5, 0x41C5, 0x49E6, 0x41A5, 0x3985, 0x39A5, 0x39A5, 0x4A47, 0x39E6, 0x39E6, 0x29A5, 0x31C5, 0x31A5, 0x31C6, 0x29A5, 0x4A67, 0x7BED, 
        0x39E6, 0x3A06, 0x3A06, 0x39E6, 0x41E6, 0x4A06, 0x5207, 0x4A06, 0x5A67, 0xB552, 0xCE77, 0xC616, 0xB5B4, 0xB5B4, 0xDE76, 0xE612, 0xE6B8, 0xE6D8, 0xE654, 0xCE77, 0xCE77, 0xB5B4, 0xB593, 0xD635, 0xD591, 0xDEDA, 0xE6B7, 0xDE55, 0xC636, 0xB5B4, 
        0x5AE9, 0x632A, 0x62C8, 0x8BAA, 0x948F, 0xE696, 0xDE55, 0xB593, 0xB594, 0x9CF0, 0xC615, 0xDE14, 0xE634, 0xE6DA, 0xE655, 0xD635, 0xC616, 0xC616, 0xB593, 0xC5F5, 0xD5B2, 0xD677, 0xD698, 0xDEB8, 0xACF1, 0x9C6F, 0x83CC, 0x944E, 0x5AC7, 0x4265, 
        0x6B8A, 0x6349, 0x6329, 0x7BCB, 0x6328, 0x5AE8, 0x52A8, 0x62EA, 0x6B2B, 0x39A5, 0x39A5, 0x4A06, 0x6287, 0x838B, 0x72E9, 0x6A87, 0x6AE9, 0x7B2A, 0x72C8, 0x93CB, 0xBD30, 0xB553, 0x9C0B, 0x93AA, 0xC573, 0x9C4D, 0x8349, 0xB4AE, 0xBD0F, 0xBD51, 
        0xBDB4, 0xCE36, 0xB594, 0xC5F5, 0xA511, 0x944F, 0x9CB0, 0x9CB0, 0x7BAC, 0x6B2A, 0xAD32, 0xAD32, 0xAD32, 0xA4D1, 0x9C8F, 0x944E, 0xA4F1, 0xB553, 0xA511, 0xACF1, 0xA4F1, 0xAD12, 0xAD12, 0xA511, 0xA512, 0xAD32, 0xAD32, 0xAD11, 0xAD11, 0x944E, 
        0x9CD1, 0xA512, 0xB5B4, 0xBDD5, 0xBDD4, 0xB594, 0xB594, 0xB594, 0xAD53, 0xA512, 0xB573, 0xB5B4, 0xC616, 0xBDF6, 0xBE17, 0xC637, 0xC657, 0xC616, 0xC657, 0xC657, 0xCE99, 0xD6BA, 0xD6B9, 0xCE99, 0xCE99, 0xB5D6, 0x9D12, 0xB5D5, 0xBE16, 0xD6BA, 
        0xD6DA, 0xD6DA, 0xD6DA, 0xD6BA, 0xD6BA, 0xCE78, 0xB5B4, 0xB5B5, 0xB5B5, 0xBE37, 0xC678, 0xC658, 0xBE37, 0xBE37, 0xBE17, 0xBE37, 0xB5B5, 0xA512, 0xC637, 0xCE78, 0xCE58, 0xCE78, 0xCE78, 0xCE78, 0xC616, 0xC636, 0xD6B9, 0xAD73, 0x8C6E, 0xB4ED, 
        0xC4EB, 0x8367, 0xAC6B, 0x7327, 0xA449, 0xC54D, 0x8C6E, 0x9511, 0x94EF, 0xC5D2, 0xEF3A, 0xEF19, 0xEF19, 0xEF19, 0xEF19, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF19, 0xEF19, 0xEF19, 0xEF19, 0xF719, 0xF719, 0xEF19, 
        0xEF19, 0xEF3A, 0xEF19, 0xEF19, 0xEF19, 0xEF19, 0xF75A, 0xE6F8, 0x94AF, 0x4286, 0x3224, 0x3225, 0x3205, 0x2162, 0x1922, 0x2183, 0x2183, 0x29A4, 0x29C4, 0x2163, 0x2143, 0x2143, 0x2143, 0x2143, 0x2164, 0x2984, 0x2984, 0x1922, 0x2163,
  0x29A3, 0x2142, 0x1901, 0x10E1, 0x10C1, 0x18E1, 0x18E1, 0x1902, 0x2143, 0x2141, 0x3A03, 0x31E3, 0x3A03, 0x31C2, 0x3A03, 0x31E3, 0x29C2, 0x31E3, 0x3A03, 0x3203, 0x31C2, 0x31C2, 0x31E3, 0x31C2, 0x29A2, 0x29C3, 0x21A2, 0x3203, 0x3A64, 0x3203, 0x3223, 
        0x3A43, 0x3223, 0x3202, 0x3203, 0x3A24, 0x2161, 0x2982, 0x2142, 0x2962, 0x2121, 0x18E1, 0x1901, 0x2122, 0x1901, 0x1902, 0x18C1, 0x10E1, 0x1921, 0x3A44, 0x4264, 0x4263, 0x3A43, 0x3203, 0x3203, 0x3A24, 0x4284, 0x3203, 0x29C2, 0x3203, 0x29A2, 
        0x4264, 0x3A64, 0x29A2, 0x2182, 0x2162, 0x29A2, 0x2182, 0x29A2, 0x1962, 0x1901, 0x2162, 0x2161, 0x29A2, 0x29A2, 0x31C2, 0x31E3, 0x1941, 0x1942, 0x29C2, 0x3203, 0x3203, 0x4244, 0x3A23, 0x4223, 0x4263, 0x4A84, 0x4A84, 0x4AA5, 0x29A3, 0x1921, 
        0x2183, 0x1942, 0x1921, 0x29C3, 0x3A23, 0x31E3, 0x3A64, 0x2162, 0x1101, 0x29C3, 0x3A64, 0x4285, 0x3A23, 0x4264, 0x3203, 0x2181, 0x31E3, 0x3A23, 0x3A03, 0x3A03, 0x2982, 0x2983, 0x31A3, 0x2983, 0x31A3, 0x31C4, 0x4A66, 0x83EC, 0x944C, 0x6327, 
        0x4AA5, 0x3223, 0x3A23, 0x31E3, 0x2182, 0x1901, 0x1942, 0x29A2, 0x29A2, 0x2982, 0x31E3, 0x29C2, 0x3A03, 0x3A23, 0x3A23, 0x4A64, 0x4A63, 0x4A63, 0x4A84, 0x4A63, 0x5284, 0x52A4, 0x3A23, 0x21A2, 0x2182, 0x29C3, 0x2162, 0x31C3, 0x4244, 0x2141, 
        0x2142, 0x31C3, 0x52C5, 0x52C5, 0x4AA4, 0x5AE5, 0x5B04, 0x6345, 0x52C4, 0x4A84, 0x4AA4, 0x4264, 0x29C3, 0x3204, 0x31C4, 0x4204, 0x52A5, 0x5AE6, 0x9CAE, 0xB551, 0xCDD3, 0xDE13, 0xC550, 0xA511, 0xBD51, 0xBD0F, 0x9C4C, 0x5AE5, 0x62E5, 0x6B26, 
        0x6AE6, 0x7347, 0x62C5, 0x5284, 0x6305, 0x7366, 0x6B66, 0x5AC5, 0x4244, 0x39E3, 0x4285, 0x3A44, 0x2182, 0x29C3, 0x31E3, 0x3A44, 0x29E3, 0x2162, 0x29C2, 0x4264, 0x4284, 0x4264, 0x3203, 0x3203, 0x3A44, 0x3A24, 0x29C2, 0x2182, 0x2162, 0x29C3, 
        0x2183, 0x29A3, 0x31E4, 0x29C3, 0x31C3, 0x3203, 0x3A24, 0x3A04, 0x3A24, 0x31E3, 0x31E3, 0x3A24, 0x5AE9, 0x2984, 0x29A5, 0x29C5, 0x2185, 0x29A5, 0x29A5, 0x29C5, 0x4AA8, 0x39E6, 0x29C5, 0x29C5, 0x29E6, 0x29C6, 0x29C5, 0x2985, 0x39E6, 0x6B4B, 
        0x31E6, 0x31E6, 0x31E7, 0x31E7, 0x4268, 0x4268, 0x4268, 0x3A47, 0x4226, 0x842C, 0xBDD5, 0xBDD5, 0xAD73, 0xB593, 0xD656, 0xDDD2, 0xDE98, 0xE6D8, 0xDE34, 0xD697, 0xDED9, 0xCE77, 0xBDF5, 0xD656, 0xD5B2, 0xE6FA, 0xE6D8, 0xE655, 0xD698, 0xCE77, 
        0x8C4E, 0x9490, 0xB511, 0xA44C, 0x8C4E, 0xE696, 0xDE76, 0xC636, 0xBE15, 0xA552, 0xC615, 0xDE14, 0xDE34, 0xDEDA, 0xE655, 0xD635, 0xBE15, 0xC616, 0xB593, 0xC615, 0xD591, 0xD677, 0xD699, 0xDE98, 0xACB0, 0x7B8B, 0x4245, 0x4AA6, 0x4224, 0x3A04, 
        0x52C7, 0x4245, 0x3A24, 0x4244, 0x4244, 0x3A44, 0x4266, 0x52A8, 0x52A9, 0x5AA9, 0x6B2B, 0x5AA8, 0x7B4B, 0x83AC, 0x7B4B, 0x7B2B, 0x732A, 0x7B6B, 0x732A, 0xA490, 0xAD12, 0xBD53, 0xA4B0, 0x9C4E, 0xC5B4, 0xACF1, 0x93EC, 0xB4F1, 0xBD73, 0xA4AF, 
        0xACF0, 0xCE37, 0xBDB4, 0xBDB4, 0xA4D1, 0x944E, 0x946F, 0x840E, 0x83ED, 0x4A46, 0x738C, 0xB553, 0xAD52, 0xAD32, 0xAD32, 0xA4F1, 0x8C2E, 0xA4F1, 0xB573, 0xB573, 0xB573, 0xB573, 0xB573, 0xB573, 0xB573, 0xAD53, 0xA512, 0xA4F1, 0xA4D0, 0xAD12, 
        0xAD32, 0xAD53, 0xBDD5, 0xAD32, 0xAD32, 0xAD53, 0xAD53, 0xAD53, 0xAD53, 0xAD52, 0xB573, 0xBDD5, 0xC657, 0xCE78, 0xCE78, 0xCE57, 0xCE57, 0xC637, 0xC657, 0xBDF6, 0xBDF6, 0xB5B5, 0xB5D5, 0xBDF6, 0xBE17, 0xC637, 0xAD74, 0xC637, 0xCE99, 0xE71B, 
        0xE71C, 0xE71C, 0xDF1B, 0xE71C, 0xE71C, 0xDEFB, 0xC637, 0xBDF5, 0xB5B5, 0xC657, 0xCE78, 0xCE78, 0xCE79, 0xCE99, 0xCE99, 0xCE79, 0xB5B5, 0x9CF2, 0xB594, 0xB5D5, 0xCE58, 0xCE78, 0xCE78, 0xCE78, 0xBE16, 0xB5D5, 0xC616, 0xAD73, 0xB52F, 0xCD6C, 
        0x62A6, 0x4A47, 0x31C6, 0x39C6, 0x4A46, 0xB4CA, 0xAD0D, 0x948F, 0x9CAE, 0xCDD2, 0xEF3A, 0xEF19, 0xEF19, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF19, 0xEF39, 0xEF3A, 0xEF3A, 0xF73A, 0xF73A, 0xF73A, 
        0xF719, 0xF73A, 0xF73A, 0xEF3A, 0xEF3A, 0xF73A, 0xBDD3, 0x9D10, 0x21A3, 0x1963, 0x21A3, 0x2163, 0x2143, 0x2163, 0x2163, 0x2143, 0x2143, 0x1923, 0x1923, 0x1923, 0x1923, 0x2143, 0x1923, 0x1943, 0x2984, 0x2964, 0x2984, 0x29A5, 0x2984,
  0x1922, 0x10E1, 0x10C1, 0x1081, 0x08A1, 0x10C1, 0x2963, 0x31A5, 0x31C5, 0x2983, 0x31A3, 0x2962, 0x2142, 0x2982, 0x2141, 0x1921, 0x1942, 0x1921, 0x1901, 0x2962, 0x31C3, 0x29A2, 0x2982, 0x3A03, 0x3A24, 0x1921, 0x2162, 0x29E3, 0x3A23, 0x4243, 0x31E2, 
        0x3222, 0x3A43, 0x4263, 0x3A43, 0x3223, 0x2162, 0x1921, 0x1921, 0x18E1, 0x18E1, 0x18E1, 0x1902, 0x1901, 0x2962, 0x2162, 0x2142, 0x29C3, 0x3223, 0x2162, 0x2161, 0x3203, 0x3A24, 0x2142, 0x10E1, 0x2182, 0x31E3, 0x3203, 0x29C2, 0x3A43, 0x4AA4, 
        0x4AA4, 0x4284, 0x4284, 0x29C2, 0x1941, 0x2142, 0x2162, 0x2162, 0x2182, 0x1101, 0x2182, 0x2182, 0x29C2, 0x29C2, 0x2982, 0x29C3, 0x1901, 0x2182, 0x3203, 0x29C2, 0x2982, 0x31C3, 0x3A24, 0x31E3, 0x3A03, 0x3A23, 0x4243, 0x4AA4, 0x3A23, 0x1921, 
        0x29A3, 0x2162, 0x1921, 0x2162, 0x31E3, 0x31E3, 0x29C3, 0x2182, 0x2162, 0x21A2, 0x3A24, 0x29C2, 0x31E2, 0x3203, 0x3A44, 0x31E3, 0x3A23, 0x4A84, 0x3A23, 0x3A03, 0x39E3, 0x39E4, 0x31C3, 0x31A3, 0x31C4, 0x31C4, 0x3A24, 0x5B08, 0x5B29, 0x3A03, 
        0x29C2, 0x31E3, 0x4264, 0x4264, 0x3A23, 0x29C2, 0x2982, 0x29C3, 0x31E3, 0x31E3, 0x29A2, 0x2182, 0x2962, 0x39E3, 0x2982, 0x39E2, 0x5AC5, 0x4243, 0x4223, 0x4223, 0x3A02, 0x4243, 0x29C2, 0x1921, 0x2162, 0x3A24, 0x4AA5, 0x4AA4, 0x52E5, 0x52E5, 
        0x4AA5, 0x2162, 0x3203, 0x52C5, 0x4AA4, 0x3A43, 0x4243, 0x52A4, 0x4AA4, 0x4AC4, 0x4AA4, 0x4264, 0x3A23, 0x4224, 0x4A45, 0x4A45, 0x52A5, 0x52A5, 0x5B07, 0x948D, 0xC571, 0xACEE, 0xA4EF, 0xB594, 0xBD72, 0x83C9, 0x62C5, 0x5AA4, 0x5284, 0x5284, 
        0x62E6, 0x6B06, 0x6305, 0x6B46, 0x7366, 0x62E5, 0x52A4, 0x52C5, 0x4244, 0x4A84, 0x4AA5, 0x3A64, 0x21A2, 0x29A3, 0x2982, 0x2182, 0x29E3, 0x3A24, 0x4264, 0x3203, 0x29A2, 0x29C3, 0x29C3, 0x3A44, 0x3A44, 0x3203, 0x3224, 0x1942, 0x10E1, 0x1922, 
        0x29A3, 0x2162, 0x2183, 0x29A3, 0x2182, 0x29A2, 0x2182, 0x29A3, 0x29C3, 0x29A3, 0x1921, 0x3A05, 0x4247, 0x2184, 0x29A5, 0x21A5, 0x29C6, 0x29A5, 0x29C5, 0x29E6, 0x52A8, 0x31C6, 0x29A5, 0x29A5, 0x29A5, 0x29A5, 0x29A5, 0x21A5, 0x31C5, 0x630A, 
        0x3206, 0x29C6, 0x3207, 0x29C6, 0x4268, 0x3227, 0x2A07, 0x2A07, 0x29E6, 0x52C7, 0x842D, 0xA4F0, 0xA4F0, 0x9CF0, 0xA4F0, 0xA4CF, 0xA512, 0xAD32, 0xA511, 0xA552, 0xB594, 0xAD73, 0xA532, 0xB572, 0xB510, 0xC616, 0xCE15, 0xCDD3, 0xCE77, 0xDED9, 
        0x94B0, 0x4A88, 0xBD52, 0xE613, 0xD657, 0xBD72, 0xD635, 0xCE57, 0xCE97, 0xBDF5, 0xC615, 0xDE34, 0xE634, 0xE6FA, 0xE675, 0xD635, 0xC615, 0xBDF5, 0xAD73, 0xCE15, 0xD5B1, 0xD677, 0xD699, 0xDE98, 0x8BCC, 0x52A7, 0x4265, 0x31E3, 0x3A04, 0x39E4, 
        0x4225, 0x4225, 0x3A24, 0x4285, 0x3A44, 0x29C3, 0x31E3, 0x3204, 0x4246, 0x52A8, 0x6B2A, 0x5AA8, 0x6B2B, 0x736C, 0x6B0A, 0x6B0A, 0x6B2B, 0x7B6B, 0x734B, 0xACF1, 0xAD12, 0xB532, 0xAD12, 0xACF2, 0xBD73, 0xACF1, 0xACF1, 0xACD1, 0xB532, 0xA490, 
        0xAD32, 0xCE57, 0xB553, 0xAD53, 0x9CB1, 0x7BED, 0x9490, 0x8C90, 0x9CD1, 0x4206, 0x4226, 0xB553, 0xB553, 0xAD12, 0xA511, 0x9CB0, 0x9CB0, 0xAD53, 0xBDF5, 0xBDB4, 0xA512, 0x9CD0, 0x946F, 0xA512, 0xA512, 0x9CD1, 0x8C2E, 0xA4D1, 0xAD11, 0xAD52, 
        0xB574, 0xAD73, 0xC636, 0xC616, 0xC616, 0xB5B4, 0xBDF5, 0xC616, 0xC616, 0xB5B4, 0xBDF6, 0xC657, 0xD6B9, 0xD699, 0xCE58, 0xD6B9, 0xCE98, 0xCE98, 0xD699, 0xCE58, 0xCE78, 0x8C4F, 0xAD53, 0xCE99, 0xD699, 0xC637, 0xB595, 0xCE79, 0xDEDA, 0xE71C, 
        0xE73C, 0xCE99, 0x8C91, 0xBDF6, 0xE73C, 0xE71C, 0xDEDA, 0xCE78, 0xBE16, 0xBDF6, 0xBE17, 0xBE17, 0xBE17, 0xC617, 0xBE17, 0xC637, 0xBDF6, 0xA533, 0xBDD5, 0xC617, 0xDEFA, 0xD6B9, 0xD699, 0xDEFB, 0xD699, 0xBDF6, 0xB5D5, 0xA4F1, 0xCD6C, 0x83A7, 
        0x39E6, 0x2145, 0x5288, 0x4A67, 0x39C6, 0x7B48, 0xDDEE, 0x838A, 0x8C0C, 0xC592, 0xEF3A, 0xEF1A, 0xEF19, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF1A, 0xEF3A, 0xEF1A, 0xEF3A, 0xEF19, 0xEF39, 0xEF3A, 0xEF3A, 0xF73A, 0xF73A, 0xF73A, 
        0xF73A, 0xE6D8, 0xE6D7, 0xF73A, 0xF75A, 0xE6F8, 0x4AE7, 0x2183, 0x2184, 0x1963, 0x1963, 0x2163, 0x2143, 0x1923, 0x1943, 0x2143, 0x2143, 0x2123, 0x1902, 0x1943, 0x1943, 0x2163, 0x2143, 0x2143, 0x2143, 0x2123, 0x2143, 0x2984, 0x2964,
  0x10E1, 0x1101, 0x10C1, 0x10C1, 0x10A1, 0x0880, 0x18C2, 0x18E2, 0x18E2, 0x2982, 0x2982, 0x2121, 0x18E1, 0x18E1, 0x10C1, 0x10E1, 0x10E1, 0x10E1, 0x1902, 0x1922, 0x2142, 0x2962, 0x2121, 0x29A2, 0x2982, 0x10E1, 0x1921, 0x2182, 0x21A2, 0x3202, 0x3A23, 
        0x3202, 0x4283, 0x4AC4, 0x4AA4, 0x3222, 0x31E3, 0x31E3, 0x1901, 0x10A1, 0x10A1, 0x10A1, 0x10C1, 0x2122, 0x31C3, 0x3203, 0x29C2, 0x3203, 0x3A43, 0x3A03, 0x31E3, 0x2141, 0x1922, 0x08A1, 0x0880, 0x1101, 0x2162, 0x2182, 0x2182, 0x31E2, 0x4263, 
        0x4263, 0x3A23, 0x4284, 0x3A44, 0x2182, 0x2162, 0x29C3, 0x29E3, 0x2162, 0x1101, 0x2162, 0x2182, 0x2182, 0x31E3, 0x3A23, 0x3A24, 0x1901, 0x1901, 0x29C3, 0x31C3, 0x2162, 0x10E1, 0x10E1, 0x1901, 0x2982, 0x31C2, 0x3A03, 0x4264, 0x4264, 0x29E3, 
        0x2182, 0x1921, 0x10C1, 0x1101, 0x2182, 0x2161, 0x2182, 0x29E3, 0x2142, 0x1901, 0x1101, 0x2141, 0x29C3, 0x3A44, 0x3203, 0x3203, 0x3A43, 0x4264, 0x4243, 0x3A23, 0x39E3, 0x39E3, 0x2983, 0x31A3, 0x39C4, 0x39E4, 0x3A04, 0x4A65, 0x4245, 0x31E3, 
        0x31C3, 0x2982, 0x3A23, 0x3A43, 0x3A23, 0x4264, 0x29C2, 0x2141, 0x29A2, 0x4A85, 0x3A44, 0x31C2, 0x31C3, 0x39E3, 0x31A2, 0x31A2, 0x4A64, 0x4A64, 0x3A03, 0x31A2, 0x4243, 0x52A5, 0x3A23, 0x2141, 0x29C3, 0x29C2, 0x3A23, 0x3A43, 0x4263, 0x52C4, 
        0x5B05, 0x3A43, 0x3A23, 0x4243, 0x31C2, 0x29A2, 0x3A03, 0x4263, 0x4AC4, 0x4A84, 0x4243, 0x4AC5, 0x52C6, 0x4A85, 0x52A5, 0x5285, 0x5285, 0x5AA5, 0x5AE6, 0x6306, 0x62E6, 0x4A85, 0x4A65, 0x7BEB, 0x83EB, 0x5AC5, 0x5AA4, 0x52A4, 0x52A5, 0x5264, 
        0x4203, 0x5284, 0x7366, 0x62E4, 0x6305, 0x4A63, 0x4A84, 0x4AA4, 0x4A84, 0x4243, 0x3A23, 0x3A43, 0x31E3, 0x2162, 0x1942, 0x1921, 0x29A3, 0x3A23, 0x29E3, 0x29C3, 0x2162, 0x2162, 0x3A44, 0x3A43, 0x3A43, 0x4AA5, 0x3223, 0x29A3, 0x2162, 0x1942, 
        0x1922, 0x1922, 0x2162, 0x2183, 0x2983, 0x2162, 0x2162, 0x2983, 0x2162, 0x2162, 0x10C0, 0x39E5, 0x3206, 0x29E6, 0x29C5, 0x3227, 0x31E6, 0x29A5, 0x3207, 0x31E6, 0x52A9, 0x2985, 0x29A5, 0x31C6, 0x29A5, 0x21A5, 0x29A5, 0x29A5, 0x29A5, 0x630A, 
        0x3A07, 0x29C6, 0x29C6, 0x29A6, 0x4248, 0x3A48, 0x29E7, 0x2A07, 0x2A07, 0x4A86, 0x842D, 0xD635, 0xD655, 0xCE36, 0xD5F3, 0xBDD4, 0xB5B4, 0xB5B4, 0xB5B4, 0xB573, 0xB572, 0xBD71, 0xB572, 0xB551, 0xAD11, 0xA532, 0xA511, 0xA511, 0x9490, 0x73AD, 
        0x5288, 0x4226, 0x7BCC, 0xACF0, 0x8C4F, 0x7BCC, 0x946F, 0xAD53, 0xB594, 0xAD73, 0xAD73, 0xC5B2, 0xCDB3, 0xCE78, 0xD614, 0xCE15, 0xCE57, 0xCE57, 0xB5D4, 0xCE36, 0xD5B2, 0xDE98, 0xDEB9, 0xDEB9, 0x8BED, 0x6B29, 0x4A66, 0x31E4, 0x3204, 0x3204, 
        0x29C3, 0x31E3, 0x3A24, 0x3A44, 0x3A24, 0x29C3, 0x2182, 0x29C3, 0x31E4, 0x3A25, 0x4A66, 0x4A47, 0x5268, 0x4206, 0x39C5, 0x5268, 0x5268, 0x5A88, 0x62C9, 0x83CD, 0x838D, 0x940E, 0x9C4F, 0x942E, 0x9C6F, 0x9C4F, 0xB512, 0xB532, 0xBD94, 0xB533, 
        0xAD53, 0xBDF6, 0x844F, 0x8490, 0x7C6F, 0x740E, 0x846F, 0x740E, 0x7BED, 0x2964, 0x2123, 0x946F, 0xB593, 0xB553, 0xAD32, 0xA4D1, 0xA4D1, 0xAD52, 0xBDD5, 0xC616, 0xBDB5, 0x9CB0, 0x738C, 0xA4F1, 0xBDD5, 0x946F, 0x5AC9, 0x8C0E, 0xB594, 0xC5F6, 
        0xBDD5, 0xAD94, 0xC637, 0xC637, 0xC637, 0x9CD1, 0x9CD1, 0xC637, 0xBE16, 0xB5B5, 0xBDF6, 0xC637, 0xD6B9, 0xCE58, 0xAD53, 0xD6B9, 0xD699, 0xD699, 0xD6BA, 0xCE78, 0xCE57, 0x9CD1, 0xC636, 0xDEDA, 0xD6DA, 0xC657, 0xB5F6, 0xDEFA, 0xDEFB, 0xE73C, 
        0xE73C, 0xDEFB, 0xA553, 0xB594, 0xDEFB, 0xE73C, 0xE73C, 0xDF1B, 0xD6B9, 0xCE78, 0xD699, 0xAD94, 0xA532, 0xCE58, 0xC658, 0xC657, 0xBE16, 0xAD94, 0xC637, 0xD699, 0xE71C, 0xC658, 0xBDF6, 0xDEDA, 0xDEFB, 0xCE78, 0xC657, 0x93ED, 0xBCCA, 0x8387, 
        0x39E6, 0x5267, 0x83A9, 0x31E6, 0x31A5, 0x7B47, 0xDE0D, 0x7AC7, 0x7BAB, 0xAD30, 0xEF3A, 0xE719, 0xE719, 0xEF3A, 0xEF1A, 0xEF1A, 0xEF3A, 0xEF3A, 0xEF3A, 0xEF3A, 0xEF3A, 0xEF3A, 0xEF3A, 0xEF3A, 0xEF3A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 
        0xF73A, 0xA4EF, 0xDE56, 0xF75A, 0xFF7B, 0xAD72, 0x2183, 0x1943, 0x1922, 0x1903, 0x1923, 0x1923, 0x1923, 0x1923, 0x2123, 0x2123, 0x1923, 0x2123, 0x2143, 0x1922, 0x1922, 0x1922, 0x1923, 0x2143, 0x1923, 0x1923, 0x2144, 0x2144, 0x2984,
  0x08A1, 0x10C1, 0x10C1, 0x10C1, 0x10A1, 0x10C1, 0x2942, 0x2963, 0x10C1, 0x2982, 0x29A2, 0x2962, 0x2122, 0x10A1, 0x10C1, 0x1901, 0x18E1, 0x1922, 0x29A3, 0x1922, 0x2162, 0x3A24, 0x2982, 0x1922, 0x1922, 0x1901, 0x1921, 0x2182, 0x2161, 0x29E2, 0x3222, 
        0x3A42, 0x3A62, 0x3A62, 0x4AA3, 0x42A3, 0x4284, 0x3A44, 0x2142, 0x1081, 0x1080, 0x0881, 0x18C1, 0x10A1, 0x10A0, 0x1942, 0x29A2, 0x4265, 0x31E3, 0x31E3, 0x3A24, 0x2182, 0x1922, 0x10A1, 0x10A1, 0x1101, 0x1921, 0x1942, 0x2182, 0x2182, 0x3A44, 
        0x4284, 0x3223, 0x3203, 0x3203, 0x3203, 0x29A2, 0x29A2, 0x21A2, 0x1961, 0x2162, 0x29C3, 0x2182, 0x2162, 0x1921, 0x2182, 0x29A2, 0x1921, 0x10C1, 0x10E1, 0x1921, 0x1921, 0x1901, 0x1902, 0x1902, 0x1901, 0x2162, 0x2982, 0x3203, 0x3A23, 0x31E3, 
        0x1921, 0x1942, 0x1901, 0x1101, 0x1901, 0x29A3, 0x2142, 0x1922, 0x10E1, 0x08A0, 0x1101, 0x2982, 0x2182, 0x2182, 0x2182, 0x3223, 0x3203, 0x3A44, 0x3203, 0x3A23, 0x4244, 0x4224, 0x2142, 0x2142, 0x31C3, 0x4224, 0x3A04, 0x39E3, 0x31E3, 0x39E4, 
        0x31C3, 0x2161, 0x29A2, 0x4264, 0x4AA4, 0x4264, 0x29A2, 0x31C2, 0x31E3, 0x4244, 0x4A84, 0x3A23, 0x3A23, 0x4243, 0x31A2, 0x31A2, 0x2981, 0x2982, 0x31A2, 0x31A2, 0x4A64, 0x52A4, 0x4A64, 0x31E3, 0x4AA4, 0x4284, 0x3A43, 0x31E2, 0x3A22, 0x4263, 
        0x52C5, 0x3A23, 0x31C2, 0x29A2, 0x29A2, 0x29C2, 0x3A44, 0x4AA5, 0x4AA5, 0x4A84, 0x3A23, 0x4244, 0x4A65, 0x4A65, 0x4A85, 0x4A65, 0x5285, 0x5285, 0x4A84, 0x5285, 0x4A45, 0x4204, 0x39E3, 0x5AE6, 0x52C4, 0x52A4, 0x4A43, 0x39E3, 0x39E3, 0x4223, 
        0x4A23, 0x5AC4, 0x6B25, 0x52A3, 0x5AC5, 0x52A4, 0x52A4, 0x5AC5, 0x52C5, 0x3A02, 0x3A23, 0x3A43, 0x2181, 0x2162, 0x1941, 0x1101, 0x3A24, 0x5B06, 0x31E3, 0x2162, 0x2162, 0x2162, 0x29C2, 0x4264, 0x4264, 0x4AA5, 0x3203, 0x2162, 0x2163, 0x1942, 
        0x1102, 0x2163, 0x2162, 0x2142, 0x29A3, 0x2983, 0x2183, 0x1942, 0x2142, 0x2142, 0x1922, 0x52A8, 0x3206, 0x29C6, 0x3207, 0x3207, 0x31E6, 0x2164, 0x29A5, 0x31C5, 0x4A68, 0x2185, 0x2985, 0x29A5, 0x2185, 0x2185, 0x2185, 0x21A5, 0x2164, 0x4AA8, 
        0x3227, 0x29A6, 0x29C6, 0x29C6, 0x4247, 0x3A47, 0x21E7, 0x2A07, 0x2A07, 0x3206, 0x844D, 0xC614, 0xC5F3, 0xC5F4, 0xD614, 0xC636, 0xC636, 0xC616, 0xC636, 0xCE77, 0xD676, 0xDE55, 0xCE57, 0xDE34, 0xCE56, 0xCE57, 0xC657, 0xC636, 0x6B8C, 0x4226, 
        0xACF0, 0x83ED, 0x4A67, 0x73AC, 0x5B09, 0x7BCC, 0x9CF0, 0xAD52, 0xAD31, 0xA510, 0x9CAF, 0x9CAF, 0x946E, 0x948F, 0x94AF, 0x9CF0, 0xA532, 0xA553, 0x9D11, 0xAD53, 0xB511, 0xBDD5, 0xC616, 0xCE57, 0x6B6B, 0x5AE9, 0x4245, 0x31E4, 0x29A3, 0x2983, 
        0x31C3, 0x4244, 0x3224, 0x31E3, 0x3A24, 0x3A45, 0x29C3, 0x1942, 0x29A3, 0x31E3, 0x3A04, 0x4246, 0x62E9, 0x2964, 0x2123, 0x630A, 0x4A27, 0x39E6, 0x630A, 0x838C, 0x62CA, 0x8BED, 0x940E, 0x6B0A, 0x5A88, 0x730A, 0x7B6C, 0x732B, 0x83AD, 0x83EE, 
        0x840F, 0x8CB1, 0x638C, 0x6BCD, 0x742E, 0x6BAC, 0x6BCD, 0x3206, 0x4A68, 0x9470, 0x4A47, 0x6B4B, 0xA532, 0xBDB4, 0xBDD5, 0xAD32, 0xB594, 0xBDD5, 0xC616, 0xC616, 0xBDB4, 0x7BCD, 0x39C5, 0x6B2A, 0xB594, 0x6B6B, 0x31C4, 0x5AA8, 0xB553, 0xC616, 
        0xBDD5, 0xAD74, 0xC636, 0xC637, 0xC637, 0x9D12, 0x9CB1, 0xC637, 0xBE16, 0xB5D5, 0xBDF5, 0xC616, 0xD699, 0xD6B9, 0xDEB9, 0xD699, 0xD699, 0xCE98, 0xD6B9, 0xD699, 0xD699, 0xAD53, 0xCE78, 0xDEFB, 0xD6BA, 0xC657, 0xB5F6, 0xDEFA, 0xDEDA, 0xDEFB, 
        0xE73C, 0xE73C, 0xC617, 0xAD74, 0xD699, 0xE73C, 0xE73C, 0xE73C, 0xE73C, 0xDEFA, 0xDEDA, 0xA533, 0xB5B4, 0xD6B9, 0xDEDA, 0xD6BA, 0xC637, 0xB5D6, 0xDEDA, 0xE71C, 0xE73C, 0xCE79, 0xAD94, 0xD699, 0xE73C, 0xD6DA, 0xCE99, 0x8BED, 0xA3C8, 0xB4A9, 
        0x8368, 0x7328, 0x2164, 0x2165, 0x39E6, 0x9C09, 0xB489, 0x7287, 0x7BCB, 0xA4EF, 0xF75A, 0xDED8, 0xE719, 0xEF3A, 0xEF1A, 0xEF3A, 0xEF3A, 0xEF3A, 0xEF3A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 
        0xEF19, 0x8C2D, 0xD636, 0xFF7B, 0xD676, 0x3A45, 0x1943, 0x1943, 0x1923, 0x1923, 0x1923, 0x1903, 0x2143, 0x2144, 0x2143, 0x2123, 0x1903, 0x1923, 0x2143, 0x1923, 0x1902, 0x1922, 0x1922, 0x2143, 0x1923, 0x1923, 0x1923, 0x2143, 0x2143,
  0x1902, 0x10C1, 0x10A1, 0x0881, 0x10A1, 0x10C1, 0x2983, 0x1902, 0x2122, 0x2962, 0x29A3, 0x2142, 0x10A1, 0x0881, 0x10E1, 0x2162, 0x2142, 0x2162, 0x1922, 0x10A1, 0x10C1, 0x1902, 0x10C1, 0x08A0, 0x2983, 0x3A24, 0x29C2, 0x29A2, 0x1101, 0x21A1, 0x3242, 
        0x3A42, 0x3221, 0x3A63, 0x4243, 0x4283, 0x4283, 0x3A23, 0x31C2, 0x2962, 0x10A1, 0x10A1, 0x10A1, 0x18E1, 0x18E1, 0x10A1, 0x1901, 0x1942, 0x1901, 0x29A3, 0x2162, 0x1922, 0x1902, 0x10A1, 0x10C1, 0x1942, 0x1922, 0x1901, 0x1921, 0x1901, 0x1901, 
        0x29C2, 0x3203, 0x31C3, 0x1942, 0x21A2, 0x2182, 0x3A24, 0x29C3, 0x21A2, 0x2182, 0x29E2, 0x29A2, 0x1941, 0x10E1, 0x1921, 0x3A03, 0x31E3, 0x29A2, 0x2162, 0x1901, 0x1921, 0x2142, 0x1902, 0x1902, 0x10A1, 0x1901, 0x1901, 0x29C3, 0x2182, 0x29E3, 
        0x31E3, 0x4265, 0x3A24, 0x1921, 0x1901, 0x2142, 0x10C1, 0x0881, 0x0880, 0x08A1, 0x1922, 0x2983, 0x2162, 0x2182, 0x1922, 0x2162, 0x2161, 0x3A44, 0x3A44, 0x29A2, 0x3A44, 0x4285, 0x29A3, 0x2122, 0x31C3, 0x39E4, 0x31C3, 0x39E3, 0x31C3, 0x2982, 
        0x31C3, 0x39E3, 0x3A03, 0x3A44, 0x4263, 0x4AA4, 0x4AA5, 0x4A84, 0x29A2, 0x3A03, 0x4AA4, 0x4244, 0x3A23, 0x4AA4, 0x4A84, 0x52A4, 0x4244, 0x2141, 0x31A2, 0x31C2, 0x39E2, 0x4244, 0x4A84, 0x4AA4, 0x4AC4, 0x52E5, 0x4263, 0x4264, 0x4264, 0x3A22, 
        0x4243, 0x3A03, 0x29A2, 0x4264, 0x5305, 0x4264, 0x2182, 0x31E3, 0x31C3, 0x31C3, 0x29A2, 0x2982, 0x39E3, 0x4A44, 0x4A45, 0x4244, 0x4A44, 0x4A24, 0x4203, 0x4224, 0x4204, 0x3A03, 0x3A23, 0x3A23, 0x4A83, 0x5AE5, 0x52A4, 0x4A43, 0x4223, 0x4A43, 
        0x4A43, 0x6B05, 0x5AE4, 0x5AA4, 0x52A4, 0x52A4, 0x6305, 0x6B66, 0x5B05, 0x52C4, 0x4263, 0x4AA4, 0x4A84, 0x4AA5, 0x4264, 0x31C3, 0x3A23, 0x4264, 0x4284, 0x29E3, 0x2162, 0x2162, 0x29A3, 0x29C3, 0x31E3, 0x3A44, 0x3A44, 0x29A3, 0x1942, 0x1922, 
        0x1902, 0x1922, 0x1942, 0x1942, 0x2142, 0x1922, 0x10E1, 0x10E1, 0x1901, 0x2162, 0x31C4, 0x4267, 0x2185, 0x21A5, 0x29A5, 0x29E6, 0x31E6, 0x29C6, 0x29A5, 0x31E6, 0x4267, 0x2185, 0x31C6, 0x29A5, 0x2985, 0x29A5, 0x29A5, 0x29A5, 0x2164, 0x52C9, 
        0x3A47, 0x29A6, 0x29A6, 0x29A6, 0x31E6, 0x4268, 0x29E7, 0x2A07, 0x2A07, 0x3206, 0x5B28, 0x5B07, 0x842C, 0xAD52, 0xAD51, 0xAD72, 0xB5B4, 0x9D12, 0x9CF1, 0xB5D4, 0xB593, 0xB572, 0xAD73, 0xB593, 0xAD93, 0xAD52, 0xC636, 0x8C90, 0x52A8, 0x5AC9, 
        0x6B2A, 0x31A4, 0x4246, 0x6BAB, 0x94D0, 0x8C6F, 0xB5D5, 0xC637, 0xCE36, 0xD634, 0xCE16, 0xD614, 0xC5F5, 0xBDD5, 0xB5B4, 0xB5B4, 0xB593, 0xB592, 0xBD92, 0xB572, 0xB551, 0xA511, 0xA511, 0xA4F1, 0x94B0, 0x73CC, 0x29C3, 0x2183, 0x2163, 0x2163, 
        0x2983, 0x29A3, 0x2182, 0x31E3, 0x3A24, 0x29C3, 0x1101, 0x1902, 0x2182, 0x29C3, 0x29C4, 0x3A25, 0x4266, 0x3A04, 0x3A24, 0x5AE8, 0x4A47, 0x31A5, 0x5AC9, 0x83AD, 0x62A9, 0x732B, 0x8BCD, 0x838C, 0x6B0A, 0x8C0E, 0x83CD, 0x5A88, 0x7B8C, 0x7B8C, 
        0x6B4B, 0x73AD, 0x4AC9, 0x5B0A, 0x636B, 0x636B, 0x3A06, 0x2164, 0x31C5, 0x7BEE, 0x6B6C, 0x31A5, 0x83EE, 0x946F, 0xBDF5, 0xAD53, 0xBDB4, 0xBDD5, 0xC616, 0xC616, 0xB594, 0x6B6C, 0x4206, 0x52A8, 0x7BCC, 0x4A66, 0x3A05, 0x4A87, 0x9C90, 0xBDF5, 
        0xBDD5, 0xAD73, 0xC637, 0xCE57, 0xCE57, 0xA512, 0x9CB1, 0xCE57, 0xB594, 0xA553, 0xBDF6, 0xC637, 0xD6B9, 0xD6BA, 0xDEDA, 0xDEBA, 0xD6B9, 0xCE78, 0xDEDA, 0xC657, 0xA552, 0x7C0C, 0xA552, 0xAD73, 0xD6B9, 0xC658, 0xB5F6, 0xDEDA, 0xD6DA, 0xD6BA, 
        0xE73C, 0xE73C, 0xD6B9, 0xAD73, 0xCE58, 0xE73C, 0xE73C, 0xE73C, 0xE73C, 0xDEFB, 0xDEDA, 0xB594, 0xC637, 0xD6DA, 0xDEFA, 0xDEDA, 0xC658, 0xB5D5, 0xD6BA, 0xEF3C, 0xE73C, 0xE71B, 0xBDF6, 0xC637, 0xE71C, 0xE73C, 0xEF5D, 0xB553, 0x7AE7, 0xD56C, 
        0xAC29, 0x5A66, 0x41E6, 0x31A5, 0x5A66, 0xBCCB, 0x7B28, 0x7288, 0x8C2D, 0xB531, 0xF75B, 0xE6F8, 0xE6F8, 0xEF19, 0xEF3A, 0xEF3A, 0xEF3A, 0xEF3A, 0xEF3A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xFF5A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF75A, 
        0xE6B7, 0x73AB, 0xBD93, 0xFFBC, 0x8C6D, 0x1902, 0x2984, 0x2143, 0x2123, 0x1903, 0x10E2, 0x1903, 0x1923, 0x2143, 0x2143, 0x2143, 0x2143, 0x1943, 0x1943, 0x1943, 0x1923, 0x1922, 0x2123, 0x2143, 0x2123, 0x1923, 0x1902, 0x1903, 0x2123,
  0x3A46, 0x3A26, 0x2143, 0x0881, 0x0881, 0x0881, 0x0881, 0x0860, 0x2122, 0x2142, 0x10A1, 0x1081, 0x0881, 0x1081, 0x10C1, 0x1922, 0x2182, 0x2162, 0x2142, 0x18E1, 0x1902, 0x10E1, 0x10A1, 0x10E1, 0x2182, 0x3A44, 0x4264, 0x3A23, 0x29C3, 0x2182, 0x2A02, 
        0x29E1, 0x29E1, 0x29C1, 0x3202, 0x3202, 0x4262, 0x3A42, 0x29A1, 0x29A2, 0x18E1, 0x10A1, 0x18E2, 0x1902, 0x1901, 0x2142, 0x2182, 0x29C3, 0x10E1, 0x1101, 0x1942, 0x10C1, 0x0881, 0x10E1, 0x1942, 0x1922, 0x1902, 0x10A1, 0x10C1, 0x1901, 0x1921, 
        0x31E3, 0x2982, 0x1081, 0x10A1, 0x1901, 0x1922, 0x1922, 0x2182, 0x1942, 0x2162, 0x3204, 0x3A44, 0x3A03, 0x31E3, 0x2162, 0x31E3, 0x4A84, 0x4AA5, 0x4264, 0x29A2, 0x29C3, 0x29A3, 0x18E1, 0x18C1, 0x1902, 0x18E1, 0x18E1, 0x10E1, 0x10C1, 0x08C0, 
        0x1921, 0x29A3, 0x29A3, 0x1942, 0x2983, 0x2162, 0x1922, 0x08A1, 0x10C1, 0x10C1, 0x10E1, 0x10E1, 0x1922, 0x1942, 0x10E1, 0x10E1, 0x2162, 0x29A2, 0x31C3, 0x2182, 0x31E3, 0x4285, 0x31E3, 0x2142, 0x2142, 0x2962, 0x2982, 0x31A3, 0x2142, 0x2141, 
        0x31C3, 0x39E3, 0x39E3, 0x31E3, 0x3A23, 0x3A23, 0x4264, 0x3A23, 0x31E3, 0x29C2, 0x3203, 0x31E3, 0x29C2, 0x3A23, 0x4A84, 0x52A4, 0x5AE5, 0x4A84, 0x52A5, 0x4223, 0x31E2, 0x31E2, 0x4243, 0x4264, 0x4284, 0x4AA4, 0x4263, 0x4243, 0x4264, 0x31C2, 
        0x31C2, 0x2982, 0x2161, 0x3A23, 0x3A43, 0x31E3, 0x2162, 0x1942, 0x1942, 0x29A3, 0x29A3, 0x31C3, 0x4224, 0x4A44, 0x4224, 0x4A64, 0x4A44, 0x4224, 0x39E3, 0x39E3, 0x4A44, 0x4A64, 0x4264, 0x4A64, 0x5AA5, 0x5AC5, 0x5AC5, 0x5AA5, 0x5AA5, 0x5284, 
        0x5284, 0x5284, 0x5AC4, 0x5AC4, 0x5AA4, 0x52A4, 0x5AC4, 0x5AE4, 0x6B25, 0x6B45, 0x6325, 0x52C4, 0x52A4, 0x4A84, 0x5AC5, 0x4AA5, 0x31E2, 0x3203, 0x3A24, 0x3203, 0x3203, 0x1942, 0x2162, 0x29C3, 0x29C2, 0x31E3, 0x3A44, 0x31E3, 0x2183, 0x10A1, 
        0x1902, 0x1942, 0x29A3, 0x29A3, 0x2142, 0x10E1, 0x1102, 0x2142, 0x2983, 0x1901, 0x2983, 0x3A26, 0x2185, 0x29C6, 0x29C6, 0x29C6, 0x29C6, 0x29C6, 0x29A5, 0x4227, 0x4247, 0x29A5, 0x29C5, 0x29C5, 0x29C6, 0x29C6, 0x29A5, 0x2185, 0x1944, 0x52A9, 
        0x4248, 0x21A6, 0x29C6, 0x29C6, 0x31E6, 0x4268, 0x29E6, 0x2A07, 0x29E7, 0x29C6, 0x4A87, 0x52E5, 0x6BA8, 0x842B, 0x6B68, 0x6B89, 0x8C2C, 0xACEF, 0xACF0, 0xB531, 0xAD31, 0xAD31, 0xA511, 0xA511, 0x840C, 0x5AE7, 0x73AB, 0x83ED, 0x6329, 0x4A86, 
        0x31A4, 0x31A4, 0x4245, 0x4265, 0x4A65, 0x73CC, 0xA532, 0xB5B5, 0xB5D4, 0xBDD3, 0xBDD4, 0xCDF4, 0xBDF5, 0xBDF6, 0xB5D5, 0xBDF5, 0xC636, 0xCE36, 0xD655, 0xD656, 0xD655, 0xC657, 0xC636, 0xC636, 0xBE36, 0xAD73, 0x52C8, 0x29A3, 0x2183, 0x2163, 
        0x2142, 0x31E4, 0x3204, 0x29C3, 0x2983, 0x29A3, 0x2142, 0x1902, 0x29A3, 0x29A3, 0x29C3, 0x29C3, 0x29C3, 0x3224, 0x3A03, 0x4A85, 0x4A86, 0x3A04, 0x4A66, 0x9C70, 0x83CD, 0x83CD, 0x8C0E, 0x83AD, 0x734B, 0x8BCD, 0x83CD, 0x62E9, 0x7BAC, 0x7BAC, 
        0x8C6F, 0x8CAF, 0x6BAB, 0x7C2E, 0x73ED, 0x5B2A, 0x634B, 0x52EA, 0x31C5, 0x29A4, 0x4A67, 0x4A67, 0x6B4B, 0x6B6B, 0xC616, 0xAD33, 0xBDB5, 0xBDD5, 0xC616, 0xC616, 0xAD53, 0x6B4B, 0x3A05, 0x3A05, 0x3A25, 0x3A05, 0x31E4, 0x3A25, 0x52C8, 0x8C90, 
        0xBDF6, 0xB594, 0xAD94, 0x9CF0, 0xA552, 0x8C6F, 0x9CD1, 0xCE57, 0xB5B4, 0xAD73, 0xBDF5, 0xAD73, 0xD6B9, 0xD6BA, 0xDEFA, 0xC657, 0xAD94, 0xAD73, 0xCE78, 0x7C4D, 0x3A64, 0x4285, 0x4285, 0x4AA6, 0xB5B4, 0xCE99, 0xBE16, 0xDEDA, 0xD6DA, 0xCE99, 
        0xDEFB, 0xE73C, 0xE71B, 0xB5B5, 0xBDD6, 0xE71B, 0xE71C, 0xE71C, 0xE73C, 0xE71B, 0xD6BA, 0xB5B4, 0xCE57, 0xDEDA, 0xDEDA, 0xDEDA, 0xC657, 0xB5B5, 0xCE79, 0xE73C, 0xE73C, 0xE73C, 0xCE58, 0xBDD5, 0xE71B, 0xE71C, 0xE73C, 0xDEFB, 0xB552, 0xB550, 
        0xAC69, 0xA429, 0x93A9, 0x8BA8, 0x93C8, 0xA46D, 0xA4F0, 0x9C8F, 0xB552, 0xB531, 0xF75B, 0xE6F9, 0xDEB7, 0xEF19, 0xEF3A, 0xEF3A, 0xEF3A, 0xEF3A, 0xEF3A, 0xF73A, 0xF73A, 0xF73A, 0xEF39, 0xC5F4, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF75A, 
        0xCE34, 0x4A86, 0xC5D5, 0xCE56, 0x3A46, 0x1923, 0x2984, 0x2143, 0x1902, 0x1903, 0x1903, 0x1903, 0x1903, 0x1923, 0x1923, 0x1923, 0x18E2, 0x2164, 0x1923, 0x1923, 0x1923, 0x1902, 0x1903, 0x2144, 0x1923, 0x1903, 0x1923, 0x1903, 0x2123,
  0x2143, 0x2163, 0x10A1, 0x10C1, 0x10A1, 0x08A1, 0x0860, 0x10E1, 0x2963, 0x2122, 0x1081, 0x10A1, 0x0881, 0x10A1, 0x10C1, 0x10E1, 0x1922, 0x1901, 0x2122, 0x1921, 0x1101, 0x1942, 0x1901, 0x1101, 0x1942, 0x2141, 0x2161, 0x29C2, 0x3203, 0x1121, 0x1961, 
        0x29C2, 0x3222, 0x29E1, 0x3202, 0x3202, 0x3222, 0x3A62, 0x3A63, 0x3A43, 0x1921, 0x10A0, 0x2122, 0x1901, 0x1901, 0x31C4, 0x29A3, 0x29C3, 0x29E3, 0x2183, 0x2162, 0x2142, 0x10E1, 0x10C1, 0x10E1, 0x0881, 0x0881, 0x1081, 0x10C1, 0x10C1, 0x1101, 
        0x1941, 0x29A3, 0x0860, 0x0860, 0x0881, 0x10A1, 0x0860, 0x0860, 0x0880, 0x1922, 0x31E3, 0x3A23, 0x3A04, 0x31E3, 0x1941, 0x1121, 0x2161, 0x3A23, 0x4264, 0x3A44, 0x3203, 0x2182, 0x18E1, 0x18C1, 0x18E1, 0x1902, 0x10C1, 0x10A1, 0x1102, 0x1102, 
        0x10E1, 0x1942, 0x2162, 0x1101, 0x29A3, 0x2163, 0x10C1, 0x10C1, 0x10C1, 0x10E2, 0x2163, 0x2142, 0x1922, 0x1902, 0x1922, 0x21A3, 0x2162, 0x29A2, 0x29C3, 0x1922, 0x29A2, 0x3A23, 0x4A84, 0x4244, 0x2962, 0x2982, 0x2983, 0x31C3, 0x31C3, 0x31C3, 
        0x31A3, 0x39E3, 0x31C3, 0x31E3, 0x29A2, 0x29A2, 0x29E3, 0x31E3, 0x31E2, 0x29C2, 0x2982, 0x31E3, 0x29C2, 0x3A03, 0x3A02, 0x4A84, 0x52C4, 0x52C5, 0x4A63, 0x39E3, 0x2982, 0x31C2, 0x31E3, 0x31E3, 0x3203, 0x3A23, 0x4AA4, 0x3A43, 0x3A02, 0x3A03, 
        0x3A02, 0x4264, 0x4264, 0x4A84, 0x29A1, 0x1941, 0x1941, 0x1901, 0x2183, 0x2983, 0x31A3, 0x4204, 0x4A65, 0x39E3, 0x39E3, 0x4A44, 0x4203, 0x39E3, 0x4204, 0x4203, 0x4A64, 0x5285, 0x5285, 0x5285, 0x5264, 0x4A84, 0x4A43, 0x5AA5, 0x5284, 0x4A43, 
        0x5264, 0x4203, 0x4223, 0x4A43, 0x4203, 0x4223, 0x4A43, 0x4A43, 0x4A63, 0x52A3, 0x5AE4, 0x52A4, 0x3A02, 0x4223, 0x4203, 0x3A03, 0x2982, 0x2182, 0x29C3, 0x29C3, 0x29C3, 0x1901, 0x1921, 0x2182, 0x2161, 0x31E3, 0x3224, 0x31E3, 0x2162, 0x10E1, 
        0x1902, 0x2162, 0x2162, 0x2163, 0x1902, 0x10C1, 0x1922, 0x2183, 0x2163, 0x10A0, 0x39E5, 0x3206, 0x2185, 0x2185, 0x2164, 0x3206, 0x3207, 0x2165, 0x2165, 0x3A06, 0x31E6, 0x2164, 0x2164, 0x3A48, 0x29A5, 0x2985, 0x2185, 0x2185, 0x2164, 0x4287, 
        0x4248, 0x2185, 0x21A5, 0x3A28, 0x29C5, 0x3A27, 0x29C6, 0x29A6, 0x29E7, 0x29C6, 0x3A26, 0x52C5, 0x5306, 0x4AA5, 0x4284, 0x5B05, 0x6325, 0xACEF, 0xC5B3, 0xC5B3, 0xDDF1, 0xCD2E, 0xACCF, 0xCD70, 0xC54F, 0x6307, 0x4223, 0x946D, 0x6B29, 0x3A04, 
        0x3A24, 0x4224, 0x3A04, 0x3A03, 0x4A85, 0x31C3, 0x8C4E, 0xAD32, 0x9CF1, 0x9D12, 0xA532, 0xA553, 0xAD74, 0xB5B4, 0xA532, 0x9CF1, 0xAD94, 0xA532, 0xA532, 0xA532, 0xAD52, 0xA573, 0xB5F5, 0x844E, 0x6B8B, 0xB5D4, 0x6BAB, 0x29A3, 0x29A3, 0x2983, 
        0x1922, 0x2142, 0x2183, 0x29A3, 0x29C3, 0x3A24, 0x31E4, 0x1942, 0x2183, 0x2182, 0x2983, 0x29C3, 0x2182, 0x2162, 0x2983, 0x3203, 0x3A24, 0x29C3, 0x4245, 0x944F, 0x9490, 0x6349, 0x83EC, 0xA4B0, 0xACF2, 0x942F, 0x942F, 0x8C0E, 0x8C0D, 0x6308, 
        0x6B89, 0x6348, 0x52C6, 0x5B27, 0x4AC5, 0x6349, 0x6BAD, 0x31C5, 0x6B6C, 0x6B6A, 0x5AE8, 0x4A66, 0x6B4A, 0x4A67, 0x9490, 0xAD53, 0xBDD5, 0xBDD5, 0xC616, 0xC616, 0xBDF6, 0x7BED, 0x3A05, 0x3A05, 0x4246, 0x29C4, 0x29C4, 0x29C4, 0x31E5, 0x6B6C, 
        0xAD53, 0xB594, 0x8C8F, 0x3A45, 0x4A85, 0x5AE7, 0x8C4E, 0xC5F6, 0xBDF5, 0xB594, 0xB5B4, 0x6349, 0xA552, 0xDEFA, 0xAD93, 0x52E7, 0x4285, 0x5B48, 0x6369, 0x3A64, 0x31E3, 0x31E3, 0x3A44, 0x3A24, 0x8C6E, 0xD6B8, 0xBE16, 0xDEDA, 0xDEDA, 0xCE78, 
        0xDEDA, 0xE73C, 0xE73C, 0xC617, 0xB594, 0xDEDA, 0xE73C, 0xE71C, 0xE71C, 0xE71C, 0xD6DA, 0xB594, 0xCE57, 0xD6BA, 0xDEDA, 0xD6DA, 0xC637, 0xB5D5, 0xC637, 0xE71C, 0xE73C, 0xE73C, 0xD699, 0xB5B4, 0xD6BA, 0xE71C, 0xDF1B, 0xE73C, 0xCE78, 0x9C8F, 
        0x6287, 0x7B28, 0x8328, 0x82E8, 0x5A25, 0x836B, 0x8C6E, 0x7BEC, 0x9C4E, 0xBD73, 0xF75B, 0xE6F8, 0xD656, 0xE6F9, 0xF73A, 0xEF3A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF75A, 0xEF19, 0x5B08, 0xBDB3, 0xFF7B, 0xEF19, 0xF73A, 0xF75A, 0xEF19, 
        0x6B69, 0x2984, 0x7BAC, 0x5B0A, 0x08C1, 0x10E2, 0x2144, 0x2123, 0x18E2, 0x1923, 0x1943, 0x1923, 0x10E2, 0x1903, 0x1903, 0x18E2, 0x10C2, 0x1903, 0x2143, 0x1923, 0x1923, 0x1923, 0x1903, 0x1903, 0x1903, 0x1923, 0x1903, 0x1923, 0x2143,
  0x1902, 0x29A4, 0x1922, 0x1922, 0x10C1, 0x08A1, 0x0860, 0x0860, 0x10C1, 0x18E1, 0x10A1, 0x10A1, 0x1081, 0x0881, 0x0881, 0x0881, 0x10A1, 0x1901, 0x2162, 0x1922, 0x10E1, 0x2182, 0x2182, 0x1942, 0x2162, 0x1921, 0x2162, 0x29A2, 0x2161, 0x1100, 0x1101, 
        0x2161, 0x29E2, 0x3202, 0x29E2, 0x29E1, 0x29E2, 0x29E2, 0x3202, 0x3A63, 0x29C2, 0x1922, 0x1902, 0x18C1, 0x10C1, 0x10C1, 0x10C1, 0x2983, 0x2183, 0x1902, 0x10E1, 0x10E1, 0x1902, 0x1902, 0x0880, 0x0880, 0x08A1, 0x10C1, 0x10E1, 0x10E1, 0x1921, 
        0x1942, 0x2162, 0x10C1, 0x0881, 0x0881, 0x0881, 0x10C1, 0x10C1, 0x10E1, 0x1101, 0x1101, 0x2182, 0x29C2, 0x29A2, 0x2162, 0x1941, 0x2162, 0x3A43, 0x3A23, 0x3A43, 0x4264, 0x29C3, 0x1901, 0x0881, 0x10A1, 0x10C1, 0x1901, 0x1922, 0x10C1, 0x08C1, 
        0x1902, 0x2162, 0x1922, 0x08A1, 0x10C1, 0x10C2, 0x0840, 0x0881, 0x08A1, 0x10E1, 0x10E1, 0x2183, 0x29A3, 0x10C1, 0x0881, 0x10E1, 0x2182, 0x29C3, 0x29A3, 0x2142, 0x1921, 0x29A2, 0x4243, 0x4A64, 0x39C3, 0x31A3, 0x3182, 0x31C3, 0x31A3, 0x31A3, 
        0x31C3, 0x39E4, 0x39E3, 0x31A2, 0x2162, 0x2162, 0x29A2, 0x3203, 0x3203, 0x4264, 0x29A2, 0x31E3, 0x2181, 0x3A43, 0x31E2, 0x29A1, 0x31E2, 0x4A84, 0x4223, 0x2141, 0x2142, 0x2162, 0x2142, 0x1941, 0x1921, 0x29C2, 0x4263, 0x4263, 0x31C2, 0x4223, 
        0x4A84, 0x52C4, 0x4AA4, 0x4AA4, 0x4263, 0x4264, 0x3203, 0x2162, 0x1941, 0x2982, 0x2983, 0x39C3, 0x3A04, 0x4203, 0x39E3, 0x4204, 0x4203, 0x41E3, 0x4224, 0x4224, 0x5285, 0x4A44, 0x4A44, 0x4A23, 0x4A64, 0x5284, 0x4223, 0x4A44, 0x4A24, 0x5244, 
        0x4A23, 0x4A23, 0x4203, 0x4223, 0x3A03, 0x4223, 0x39C2, 0x39C2, 0x39E2, 0x5284, 0x5AC4, 0x5AC5, 0x4A84, 0x4203, 0x3A03, 0x3A03, 0x2162, 0x1922, 0x2142, 0x2162, 0x2162, 0x1921, 0x2183, 0x31E3, 0x29A2, 0x31E3, 0x29C3, 0x29C3, 0x29C3, 0x29A3, 
        0x1942, 0x1942, 0x1101, 0x1102, 0x1902, 0x10E1, 0x1922, 0x1922, 0x1902, 0x1922, 0x52C9, 0x29A5, 0x2185, 0x1944, 0x2144, 0x3A27, 0x4248, 0x1944, 0x2165, 0x4A68, 0x31E6, 0x1944, 0x2185, 0x4A89, 0x29C5, 0x2185, 0x2185, 0x2185, 0x2164, 0x4247, 
        0x4268, 0x2185, 0x2185, 0x3A48, 0x29A5, 0x4268, 0x3207, 0x31E7, 0x29E6, 0x29C6, 0x3206, 0x4A85, 0x4284, 0x3A23, 0x29C2, 0x4A84, 0x52C5, 0x846D, 0xB593, 0xC5B2, 0xD5D1, 0xC5D4, 0xB594, 0xCDD3, 0x9C8D, 0x4A65, 0x3A03, 0x4AA5, 0x4244, 0x4224, 
        0x39E3, 0x4245, 0x3A04, 0x3A04, 0x4265, 0x4A45, 0x942D, 0xC592, 0xCD70, 0xBD0E, 0xACCF, 0xB530, 0xBD51, 0xBD51, 0xB510, 0xB531, 0xB572, 0xB573, 0xAD52, 0xA511, 0xAD32, 0xA512, 0x7C2D, 0x4265, 0x4AC7, 0x844E, 0x52E8, 0x29A3, 0x29A3, 0x31C4, 
        0x2163, 0x2143, 0x1942, 0x29A3, 0x29C4, 0x31E4, 0x2183, 0x1942, 0x1942, 0x2142, 0x2183, 0x2183, 0x2162, 0x29C3, 0x29C3, 0x29C3, 0x29A3, 0x29A2, 0x4224, 0x6B6A, 0x6B6B, 0x4AA6, 0x52C6, 0x7BCB, 0x9C90, 0x8BED, 0x942F, 0x942E, 0x5AC7, 0x4264, 
        0x4AA6, 0x4AA5, 0x4A84, 0x4A84, 0x4284, 0x52E7, 0x3A25, 0x31E5, 0x6B6A, 0x5B28, 0x4A85, 0x4A85, 0x6308, 0x738B, 0x842E, 0x9CF1, 0xBDB5, 0xBDD5, 0xC616, 0xC616, 0xC616, 0x7C0D, 0x31E5, 0x31E5, 0x3A26, 0x31E5, 0x29C4, 0x4267, 0x73CC, 0x7BED, 
        0xAD53, 0x94D0, 0x6369, 0x3203, 0x3A23, 0x4264, 0x6348, 0x7BEC, 0x9D11, 0x9CF0, 0x636A, 0x4265, 0x7C0D, 0x94D0, 0x73EB, 0x3A45, 0x3A44, 0x3A44, 0x4284, 0x4264, 0x3203, 0x29A2, 0x29C3, 0x3A24, 0x4AA6, 0x7C0C, 0x7C2E, 0xCE58, 0xDEDA, 0xCE78, 
        0xD6DA, 0xE73C, 0xE73C, 0xD699, 0xA553, 0xCE78, 0xE73D, 0xE73C, 0xE73C, 0xE73C, 0xDEFB, 0xBDD5, 0xCE57, 0xDEDA, 0xDEFA, 0xD6DA, 0xC637, 0xB5D5, 0xBE16, 0xD6DA, 0xE73C, 0xDEFB, 0xDEDB, 0xB5B4, 0xCE58, 0xE71C, 0xDF1B, 0xE71C, 0xD699, 0x838C, 
        0x8B0A, 0x7AA9, 0x8B2A, 0x82A9, 0x8AE9, 0x7AA8, 0x6B8B, 0x7BCC, 0x6A67, 0xC5D5, 0xF77B, 0xDED8, 0xCE36, 0xEF19, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xE6D7, 0x52C8, 0x83CD, 0xFF7B, 0xDE55, 0xEF19, 0xFF7B, 0xE6D7, 
        0x4AA7, 0x2964, 0x5AEA, 0x4A68, 0x10E2, 0x1903, 0x2144, 0x1903, 0x10C2, 0x1902, 0x1902, 0x1903, 0x1903, 0x10E2, 0x1923, 0x1923, 0x1903, 0x1923, 0x2164, 0x1923, 0x18E2, 0x1923, 0x1903, 0x1902, 0x10E2, 0x10E2, 0x1903, 0x1923, 0x1943,
  0x2163, 0x42A7, 0x3A25, 0x1101, 0x10C1, 0x2963, 0x2163, 0x18E1, 0x2982, 0x2983, 0x2102, 0x1902, 0x2143, 0x1081, 0x0881, 0x1922, 0x2142, 0x1922, 0x2163, 0x10E1, 0x29A3, 0x29C3, 0x31E3, 0x2162, 0x2182, 0x2162, 0x1921, 0x1921, 0x2162, 0x1921, 0x1921, 
        0x2181, 0x31E2, 0x29E2, 0x29C1, 0x29E2, 0x3A42, 0x3202, 0x3202, 0x3223, 0x4264, 0x3204, 0x2122, 0x0881, 0x0881, 0x08A1, 0x0880, 0x10A1, 0x08A1, 0x0860, 0x0881, 0x0881, 0x10E1, 0x1922, 0x1942, 0x2162, 0x1942, 0x2183, 0x2162, 0x1941, 0x29A3, 
        0x29A2, 0x1922, 0x10C1, 0x08A1, 0x0881, 0x10C1, 0x1101, 0x1942, 0x10E1, 0x1101, 0x2162, 0x2182, 0x2161, 0x29C2, 0x29C2, 0x2982, 0x2141, 0x31C2, 0x3203, 0x3A23, 0x31E3, 0x31E3, 0x18E1, 0x0860, 0x10A1, 0x10C1, 0x2142, 0x31E3, 0x2122, 0x10E1, 
        0x1921, 0x1922, 0x10C1, 0x0881, 0x0881, 0x0861, 0x0861, 0x0861, 0x08A1, 0x2163, 0x2183, 0x1901, 0x1922, 0x10C1, 0x0881, 0x10C1, 0x10E1, 0x1941, 0x2162, 0x1941, 0x2182, 0x31C2, 0x31E2, 0x3A03, 0x31A2, 0x2962, 0x31A3, 0x2983, 0x2962, 0x2983, 
        0x29A3, 0x2142, 0x2122, 0x2162, 0x2182, 0x29C3, 0x29A2, 0x29C3, 0x31E3, 0x4284, 0x3A23, 0x3203, 0x29C2, 0x4264, 0x4A85, 0x3A43, 0x3A23, 0x3203, 0x3A03, 0x31E2, 0x29C3, 0x2182, 0x1941, 0x2162, 0x2142, 0x2141, 0x3203, 0x4263, 0x4284, 0x52C5, 
        0x52A4, 0x4AA4, 0x52C4, 0x4A84, 0x52C4, 0x52E5, 0x5B25, 0x4AA4, 0x3A03, 0x4A65, 0x4224, 0x39C3, 0x31C3, 0x4204, 0x3A04, 0x4204, 0x4204, 0x41E3, 0x4203, 0x39E3, 0x4A64, 0x4224, 0x4203, 0x4A64, 0x4A44, 0x4A24, 0x4A24, 0x4A24, 0x4A24, 0x41E3, 
        0x39C3, 0x4203, 0x41E3, 0x4A24, 0x4223, 0x4223, 0x39E3, 0x31A2, 0x39E3, 0x4223, 0x5284, 0x52A4, 0x5284, 0x4223, 0x39E2, 0x4A64, 0x29A2, 0x2982, 0x29A3, 0x2162, 0x1922, 0x10E1, 0x2182, 0x29C3, 0x29C3, 0x2182, 0x29A2, 0x29A2, 0x29C3, 0x29C3, 
        0x1942, 0x1922, 0x1922, 0x1102, 0x1902, 0x10E2, 0x1902, 0x10E1, 0x08C1, 0x31E5, 0x4AA8, 0x1964, 0x2185, 0x1944, 0x1944, 0x3A07, 0x3A07, 0x1944, 0x1944, 0x4267, 0x2985, 0x1964, 0x29A5, 0x4268, 0x2165, 0x2165, 0x2165, 0x2165, 0x2164, 0x4227, 
        0x4A88, 0x21A5, 0x29A6, 0x3A48, 0x29A5, 0x4248, 0x3227, 0x3227, 0x29E6, 0x29C6, 0x29A5, 0x4286, 0x3A03, 0x3A23, 0x4264, 0x4A84, 0x4243, 0x52C5, 0x6326, 0x6B46, 0x840A, 0x8C6D, 0x7BCB, 0x6329, 0x3A04, 0x2982, 0x3A03, 0x4244, 0x4264, 0x3A23, 
        0x29A2, 0x31E3, 0x31E3, 0x31C3, 0x3204, 0x6B6A, 0x7BEE, 0xBD92, 0xE633, 0xCDF3, 0xB5B4, 0xCDD3, 0xD5D2, 0xCE14, 0xBD93, 0xBDB4, 0xCDF4, 0xDE13, 0xC591, 0x9CAE, 0xB530, 0x9C8D, 0x4AA5, 0x4AA6, 0x4286, 0x4266, 0x3A45, 0x2983, 0x31C4, 0x29A3, 
        0x2983, 0x2142, 0x1902, 0x1922, 0x2162, 0x29A3, 0x29C4, 0x2162, 0x1922, 0x2183, 0x29C3, 0x2183, 0x2162, 0x29A3, 0x31E3, 0x2182, 0x2182, 0x29C3, 0x3A24, 0x4265, 0x4285, 0x4A85, 0x4AA5, 0x52C6, 0x6329, 0x6329, 0x62E8, 0x52C7, 0x5AC7, 0x4AA6, 
        0x4264, 0x4264, 0x4264, 0x4284, 0x4264, 0x3A44, 0x3A44, 0x3A04, 0x31E4, 0x3A04, 0x4A85, 0x4A65, 0x4A85, 0x840D, 0xB594, 0x9CF1, 0xBDB4, 0xB5D5, 0xC616, 0xBDF6, 0xB594, 0x6BAC, 0x3A06, 0x31C4, 0x3205, 0x3A26, 0x3205, 0x3A26, 0x4AA8, 0x4AA8, 
        0x6BAB, 0x52E8, 0x29A2, 0x29C2, 0x29E3, 0x4264, 0x52C5, 0x3A44, 0x6389, 0x5308, 0x3A24, 0x3A44, 0x4265, 0x3A44, 0x29C3, 0x3A24, 0x4285, 0x3203, 0x3223, 0x4264, 0x3A04, 0x3A44, 0x3A24, 0x3A24, 0x3203, 0x3203, 0x3204, 0xA552, 0xDEFB, 0xCE98, 
        0xA573, 0xC638, 0xEF5D, 0xE71C, 0xB595, 0xBDD6, 0xE73C, 0xE71C, 0xE71C, 0xE71C, 0xDEDB, 0xD6B9, 0xD6B9, 0xDEFA, 0xDEFB, 0xDEDA, 0xC637, 0xB5D5, 0xBDF6, 0xCE78, 0xE73C, 0xDF1B, 0xE71C, 0xBDF6, 0xBDF6, 0xE71C, 0xDF1B, 0xDF1B, 0xE73C, 0xCE37, 
        0x9C4E, 0x9BED, 0xCDF5, 0x9C6E, 0xA42E, 0x7B09, 0x946E, 0xA4D0, 0x6A88, 0xCE15, 0xEF3A, 0xD697, 0xC615, 0xDEB8, 0xF75A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF75B, 0xC5F4, 0x636A, 0x3A06, 0x4A27, 0xA4D0, 0x83EC, 0xB531, 0xEEF8, 0xAD51, 
        0x2163, 0x2143, 0x39E6, 0x29C5, 0x1903, 0x1923, 0x1923, 0x18E3, 0x10E2, 0x10E2, 0x1903, 0x1903, 0x10E2, 0x10E2, 0x2123, 0x2143, 0x10C2, 0x1923, 0x2123, 0x1923, 0x10E2, 0x1903, 0x1903, 0x1903, 0x1923, 0x1903, 0x1903, 0x10E2, 0x1903,
  0x1961, 0x3A44, 0x3A44, 0x2982, 0x2162, 0x2182, 0x3A64, 0x3203, 0x4264, 0x29C3, 0x2162, 0x1902, 0x10C1, 0x08A1, 0x10A0, 0x2142, 0x2142, 0x10E1, 0x10C1, 0x10E1, 0x29A3, 0x2182, 0x2162, 0x2142, 0x1942, 0x2983, 0x2162, 0x1921, 0x2182, 0x29E3, 0x29C2, 
        0x29A2, 0x29E2, 0x3A42, 0x3202, 0x3202, 0x3A43, 0x3222, 0x3203, 0x29C2, 0x2182, 0x2182, 0x1902, 0x10A1, 0x08A1, 0x10C1, 0x10E2, 0x0881, 0x0881, 0x08A1, 0x0881, 0x0861, 0x0860, 0x0881, 0x1902, 0x2162, 0x1921, 0x2162, 0x2162, 0x1901, 0x29A3, 
        0x31C3, 0x10E1, 0x0880, 0x0860, 0x0860, 0x1922, 0x2162, 0x2162, 0x1101, 0x08C1, 0x1942, 0x2182, 0x31E3, 0x29C3, 0x29C2, 0x29C3, 0x29C3, 0x3203, 0x3A43, 0x3A43, 0x2162, 0x1921, 0x10E1, 0x10C1, 0x1902, 0x2142, 0x1901, 0x3A04, 0x4224, 0x2982, 
        0x1942, 0x1101, 0x08A1, 0x0881, 0x0881, 0x0881, 0x0861, 0x0861, 0x10A1, 0x08A1, 0x08A1, 0x10A1, 0x10A1, 0x10C1, 0x10E1, 0x2163, 0x2162, 0x3204, 0x31E3, 0x2162, 0x29A2, 0x29A2, 0x31C2, 0x31E3, 0x31C3, 0x31C3, 0x31A3, 0x2962, 0x2983, 0x2962, 
        0x2983, 0x2122, 0x2142, 0x2983, 0x2182, 0x2162, 0x2162, 0x2182, 0x29C2, 0x3223, 0x3203, 0x3A23, 0x2182, 0x29A2, 0x31C2, 0x3A03, 0x29A2, 0x29C3, 0x29A2, 0x3A44, 0x3A43, 0x4264, 0x3A44, 0x3A23, 0x31E3, 0x29C2, 0x31E3, 0x4264, 0x3A43, 0x3A23, 
        0x4AA4, 0x52C4, 0x52A4, 0x52A4, 0x4243, 0x3A02, 0x4243, 0x4284, 0x4284, 0x4264, 0x4A64, 0x4245, 0x39E4, 0x3A04, 0x3A04, 0x39E4, 0x39C3, 0x39C3, 0x39E3, 0x39C3, 0x4204, 0x4204, 0x4223, 0x4A64, 0x5AA5, 0x4A44, 0x4203, 0x4204, 0x4204, 0x39C3, 
        0x39C3, 0x4204, 0x31A3, 0x39C3, 0x39C3, 0x39C3, 0x39C3, 0x39C3, 0x39E3, 0x39E3, 0x39E3, 0x4223, 0x4A64, 0x4A84, 0x4A43, 0x4A64, 0x3A03, 0x3A23, 0x3A03, 0x3224, 0x29C3, 0x10A1, 0x1902, 0x2182, 0x29A2, 0x29C3, 0x3A24, 0x3224, 0x29C3, 0x2162, 
        0x1901, 0x10E1, 0x10E2, 0x10C1, 0x10C1, 0x10A1, 0x10A1, 0x10A1, 0x10C1, 0x3A06, 0x31E6, 0x1944, 0x2164, 0x1944, 0x1944, 0x29C6, 0x29A5, 0x1944, 0x2144, 0x4267, 0x2165, 0x1964, 0x2185, 0x2185, 0x1964, 0x2164, 0x2165, 0x2165, 0x1944, 0x3A27, 
        0x52A9, 0x2185, 0x29A6, 0x3207, 0x29C5, 0x4247, 0x3A27, 0x3227, 0x3247, 0x29E7, 0x2985, 0x3A05, 0x4264, 0x4AC5, 0x4AA4, 0x4284, 0x3A23, 0x4A84, 0x4A84, 0x3202, 0x4A84, 0x6B67, 0x52A5, 0x3A23, 0x4A64, 0x29A2, 0x3A24, 0x31C2, 0x4263, 0x4AA4, 
        0x4A84, 0x31E3, 0x31C3, 0x29A3, 0x2983, 0x73CC, 0x842D, 0xACEF, 0xD635, 0xA4F0, 0x8C4E, 0xB594, 0xCE15, 0xCDF4, 0xB5D5, 0xC616, 0xCE14, 0xD636, 0xC5F5, 0x7C0C, 0x5B07, 0x5AE7, 0x4AA6, 0x4AA7, 0x3A25, 0x29C3, 0x29A3, 0x29A3, 0x31E3, 0x3A24, 
        0x29C3, 0x1922, 0x10E1, 0x1102, 0x1902, 0x2142, 0x29A3, 0x2983, 0x1942, 0x2183, 0x29A3, 0x29C3, 0x29C3, 0x2162, 0x2183, 0x29C3, 0x2162, 0x2183, 0x29E3, 0x3204, 0x3204, 0x3203, 0x3A24, 0x3A44, 0x4285, 0x4265, 0x4A65, 0x4A64, 0x4A85, 0x3204, 
        0x3203, 0x31E3, 0x31E3, 0x4A84, 0x4284, 0x3A24, 0x31E3, 0x29A2, 0x2183, 0x2162, 0x31C3, 0x3A24, 0x4265, 0x52E7, 0x7BCB, 0x946F, 0xBDB4, 0xBDD5, 0xC637, 0xC5F6, 0xAD53, 0x4AA8, 0x31E5, 0x3A05, 0x3A05, 0x4246, 0x3A26, 0x4AA7, 0x52A7, 0x52E8, 
        0x4245, 0x3203, 0x3A24, 0x3A44, 0x3A24, 0x4A85, 0x4AC5, 0x4284, 0x3A64, 0x3223, 0x3203, 0x3A44, 0x31E3, 0x3A24, 0x29C3, 0x29C3, 0x3A44, 0x4AA5, 0x3A64, 0x3A44, 0x3203, 0x3A44, 0x4285, 0x3A64, 0x42A5, 0x3A44, 0x29E3, 0x6349, 0xBDF5, 0xCE77, 
        0x636A, 0x844E, 0xE71C, 0xEF5D, 0xEF5D, 0xE73C, 0xEF5D, 0xEF5D, 0xEF5D, 0xE73C, 0xDEFB, 0x9D33, 0x8C91, 0x94D2, 0xA533, 0xA574, 0x9D13, 0x94F2, 0xB5D5, 0xBE17, 0xE71C, 0xE71C, 0xE73D, 0xC637, 0x9CF2, 0xDEBA, 0xE73C, 0xE71C, 0xE73C, 0xE71C, 
        0xBDD4, 0x9CAF, 0xC5F4, 0xA4F0, 0xB552, 0x83CC, 0x9CAF, 0xAD31, 0x8BED, 0xBDB3, 0xB552, 0xC5F5, 0xBDB4, 0xC5D4, 0xF75B, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF73A, 0xF75A, 0xFF9B, 0xA531, 0x29A4, 0x31A4, 0x4A67, 0x4246, 0x4A67, 0x83ED, 0x5AE9, 
        0x1923, 0x1923, 0x1102, 0x1102, 0x2164, 0x1944, 0x1903, 0x1903, 0x10C2, 0x10E2, 0x10E3, 0x10E2, 0x10C2, 0x10C2, 0x2143, 0x2964, 0x10E2, 0x1903, 0x18E3, 0x1903, 0x10E2, 0x1903, 0x1923, 0x1923, 0x1903, 0x1903, 0x18E3, 0x1923, 0x1903,
  0x21A2, 0x21C2, 0x29C2, 0x29E2, 0x3A44, 0x3A44, 0x3A44, 0x3223, 0x4244, 0x29A2, 0x1901, 0x0860, 0x0860, 0x08A1, 0x3A06, 0x638B, 0x52E9, 0x10E1, 0x10C1, 0x10C1, 0x10C1, 0x2162, 0x1902, 0x10C1, 0x10A1, 0x1922, 0x1902, 0x10E1, 0x1942, 0x29C2, 0x31E3, 
        0x2161, 0x2161, 0x2A02, 0x29E2, 0x29E2, 0x3202, 0x2182, 0x2182, 0x2182, 0x29C3, 0x1922, 0x10E1, 0x10E1, 0x10E1, 0x1102, 0x10E1, 0x10E2, 0x10C1, 0x10C1, 0x10C1, 0x0861, 0x10E3, 0x0861, 0x0860, 0x10C1, 0x2142, 0x2183, 0x2142, 0x1921, 0x1921, 
        0x2162, 0x2163, 0x10C1, 0x0881, 0x0881, 0x2143, 0x2183, 0x31E4, 0x2983, 0x2162, 0x3224, 0x29E3, 0x31E3, 0x29A2, 0x29C3, 0x2162, 0x29C3, 0x29A2, 0x3A23, 0x4284, 0x4264, 0x2142, 0x18E1, 0x1901, 0x1922, 0x2983, 0x2142, 0x3182, 0x3A03, 0x52A5, 
        0x4A44, 0x2142, 0x08A1, 0x10C1, 0x0881, 0x0881, 0x0881, 0x10A1, 0x10A1, 0x08A1, 0x08A1, 0x10C1, 0x10A1, 0x0881, 0x10A1, 0x1942, 0x2162, 0x29A2, 0x29A2, 0x2162, 0x2162, 0x29A3, 0x2982, 0x31C3, 0x3A03, 0x3A04, 0x2942, 0x2122, 0x2962, 0x2142, 
        0x2963, 0x2983, 0x2982, 0x2962, 0x2142, 0x2162, 0x2162, 0x1942, 0x2182, 0x3203, 0x29A2, 0x29A2, 0x1941, 0x3203, 0x4AA4, 0x3A23, 0x2181, 0x2182, 0x2182, 0x29C2, 0x3A43, 0x3A43, 0x3A63, 0x4264, 0x2982, 0x2141, 0x2161, 0x2182, 0x3203, 0x3A23, 
        0x3A43, 0x4264, 0x31E2, 0x4223, 0x4243, 0x29A2, 0x31C2, 0x3A23, 0x4284, 0x3A23, 0x39E3, 0x31C3, 0x31C3, 0x3183, 0x31C3, 0x39C3, 0x2983, 0x31C3, 0x4203, 0x41E4, 0x39C3, 0x39E3, 0x4203, 0x52A4, 0x5AC5, 0x4A64, 0x4203, 0x39C3, 0x39E4, 0x39C3, 
        0x39C3, 0x31A3, 0x31A3, 0x3183, 0x31A3, 0x3183, 0x3183, 0x2982, 0x39C3, 0x39E4, 0x3A04, 0x39E3, 0x5264, 0x4A84, 0x3A02, 0x31C2, 0x3A03, 0x4244, 0x31E3, 0x29E3, 0x2162, 0x1081, 0x10C1, 0x1942, 0x2162, 0x31C3, 0x3204, 0x29C3, 0x2182, 0x2182, 
        0x2162, 0x10C1, 0x0880, 0x10A1, 0x0881, 0x10C1, 0x10E2, 0x10E1, 0x18E2, 0x4247, 0x29A5, 0x1944, 0x1944, 0x2165, 0x2164, 0x1965, 0x2185, 0x2165, 0x2185, 0x52C9, 0x2985, 0x2165, 0x1944, 0x1944, 0x1964, 0x1964, 0x2165, 0x2165, 0x1964, 0x3A06, 
        0x52C9, 0x21A5, 0x29A6, 0x29C6, 0x2185, 0x31E6, 0x3A27, 0x21A5, 0x21C6, 0x2A07, 0x29C6, 0x31E5, 0x3A03, 0x4244, 0x4264, 0x3A23, 0x29C3, 0x3203, 0x3A23, 0x3A23, 0x3A43, 0x52C5, 0x4AA4, 0x52C4, 0x5B25, 0x4264, 0x4223, 0x4263, 0x4AA4, 0x52E4, 
        0x5B05, 0x4A84, 0x31C3, 0x29A3, 0x2162, 0x4265, 0x6348, 0x73AA, 0xAD31, 0xA46D, 0x9C0A, 0x940C, 0xBDF6, 0xCE14, 0xBDD4, 0xCE15, 0xCE14, 0xC5D5, 0x8C0C, 0x5AE6, 0x4A85, 0x31E3, 0x4266, 0x3204, 0x31C4, 0x31E4, 0x31E4, 0x31C3, 0x31E3, 0x29C2, 
        0x31E3, 0x4A85, 0x31E3, 0x2162, 0x1902, 0x2142, 0x29A3, 0x29A3, 0x2163, 0x1922, 0x2163, 0x29A3, 0x31E4, 0x2162, 0x1922, 0x29C3, 0x2163, 0x2162, 0x29C3, 0x2183, 0x31E4, 0x4285, 0x3A24, 0x29C3, 0x3203, 0x4244, 0x4244, 0x4244, 0x31E3, 0x29C3, 
        0x29E3, 0x29A2, 0x29A2, 0x3A23, 0x4264, 0x3203, 0x3224, 0x3A64, 0x3203, 0x2162, 0x2122, 0x3204, 0x3A44, 0x4AA6, 0x9CAF, 0xAD53, 0xB573, 0x9CD1, 0x9490, 0xA4F1, 0x842E, 0x3A05, 0x29A3, 0x3205, 0x31E4, 0x31E4, 0x4245, 0x4285, 0x4285, 0x4264, 
        0x3204, 0x31E3, 0x3204, 0x3203, 0x3A24, 0x4264, 0x4284, 0x4284, 0x3A24, 0x3A44, 0x3203, 0x29E3, 0x29A3, 0x31E3, 0x3204, 0x29E3, 0x3203, 0x4AA5, 0x4AA5, 0x3A24, 0x29C3, 0x29C2, 0x3A64, 0x3243, 0x3A64, 0x4285, 0x3203, 0x3A44, 0x73EB, 0x6BAA, 
        0x4265, 0x4285, 0x73EC, 0x9513, 0xA575, 0xA554, 0xAD96, 0xB5B6, 0xB5F7, 0xBE17, 0xCE59, 0x7C2F, 0x52EA, 0x5B2B, 0x5B0B, 0x5B0B, 0x52EA, 0x52EA, 0x7C0E, 0xB595, 0xE71C, 0xE73D, 0xE75D, 0xD6BA, 0xA533, 0xCE79, 0xEF5D, 0xE73C, 0xE73C, 0xE73C, 
        0xD698, 0xAD72, 0xC5F4, 0xBD93, 0xAD32, 0xA511, 0xAD32, 0xB593, 0xA511, 0xB552, 0x9CAF, 0xB572, 0xA531, 0x94CF, 0xF75A, 0xF75A, 0xF73A, 0xF73A, 0xF73A, 0xF75A, 0xEEF9, 0xAD52, 0x6B6B, 0x31E5, 0x4247, 0x3A27, 0x4AA9, 0x2144, 0x4268, 0x29C5, 
        0x1923, 0x1923, 0x1102, 0x1103, 0x1923, 0x1903, 0x1903, 0x1923, 0x10E2, 0x10E2, 0x10C2, 0x10C2, 0x10C2, 0x0881, 0x10E2, 0x1923, 0x1923, 0x2983, 0x2983, 0x1943, 0x1902, 0x2163, 0x2983, 0x2143, 0x1903, 0x10C2, 0x10C2, 0x1903, 0x2143,
  0x29C2, 0x3203, 0x21A2, 0x2182, 0x29A2, 0x29C2, 0x29A2, 0x29C2, 0x31E2, 0x3A03, 0x2983, 0x0840, 0x10A1, 0x3206, 0x4AA9, 0x52EB, 0x52EA, 0x18E1, 0x1901, 0x10E1, 0x0881, 0x10A1, 0x1922, 0x1902, 0x10E2, 0x10E2, 0x0880, 0x10E1, 0x2182, 0x29C2, 0x31E3, 
        0x29A2, 0x1941, 0x2181, 0x29E2, 0x29E1, 0x29E2, 0x2182, 0x2162, 0x1941, 0x2162, 0x2182, 0x10E1, 0x1101, 0x1922, 0x1922, 0x10E1, 0x10C1, 0x1101, 0x1942, 0x1102, 0x08C1, 0x0881, 0x0881, 0x0881, 0x10C1, 0x1902, 0x1902, 0x2162, 0x2183, 0x1922, 
        0x1921, 0x2142, 0x10A1, 0x0881, 0x0881, 0x0860, 0x0880, 0x1901, 0x2162, 0x2142, 0x2162, 0x29A2, 0x31E3, 0x1941, 0x2162, 0x10E1, 0x10E1, 0x1921, 0x31E3, 0x3203, 0x3A03, 0x31E4, 0x1901, 0x1902, 0x2142, 0x2162, 0x2982, 0x2162, 0x2121, 0x39E3, 
        0x5284, 0x4224, 0x18E1, 0x10C1, 0x18E2, 0x10C2, 0x10A1, 0x08A1, 0x08A1, 0x10A1, 0x0881, 0x08A1, 0x08A1, 0x10A1, 0x0881, 0x10E1, 0x1901, 0x2162, 0x29A2, 0x29A2, 0x2982, 0x2142, 0x2982, 0x31A2, 0x31A2, 0x31C3, 0x2142, 0x1922, 0x1922, 0x2162, 
        0x2162, 0x2983, 0x2982, 0x29A3, 0x2963, 0x2142, 0x2162, 0x1901, 0x10E1, 0x1922, 0x29A3, 0x2982, 0x31C3, 0x3A04, 0x3A23, 0x3A03, 0x3A44, 0x29A2, 0x2182, 0x2162, 0x2181, 0x4284, 0x4284, 0x3A43, 0x3203, 0x4264, 0x3203, 0x29A2, 0x29A2, 0x29A2, 
        0x3223, 0x3A43, 0x31E2, 0x4244, 0x4244, 0x31C2, 0x2982, 0x39E3, 0x4244, 0x3A03, 0x3A04, 0x39E3, 0x31A3, 0x2962, 0x2962, 0x2983, 0x2962, 0x3183, 0x39E3, 0x39E3, 0x4203, 0x4A84, 0x4A43, 0x4A64, 0x4243, 0x52A5, 0x4A44, 0x39C3, 0x3183, 0x3183, 
        0x3183, 0x2963, 0x2942, 0x2943, 0x2943, 0x2963, 0x3183, 0x2963, 0x3183, 0x3182, 0x31C3, 0x31C3, 0x31A2, 0x39E3, 0x4223, 0x31C2, 0x2981, 0x31E3, 0x29A2, 0x2182, 0x1902, 0x0881, 0x10E1, 0x21A3, 0x29A3, 0x29A3, 0x2182, 0x2162, 0x2182, 0x3204, 
        0x31E4, 0x2142, 0x10E1, 0x10C1, 0x10E2, 0x10A1, 0x10C1, 0x1902, 0x2122, 0x3A06, 0x2144, 0x2165, 0x2164, 0x1944, 0x21A5, 0x21A5, 0x1964, 0x2165, 0x2985, 0x4A68, 0x2165, 0x1924, 0x3207, 0x3227, 0x1944, 0x1965, 0x2165, 0x2165, 0x1964, 0x31E6, 
        0x52C9, 0x2185, 0x21A6, 0x21A6, 0x3227, 0x3206, 0x3A27, 0x21A5, 0x21C6, 0x29E6, 0x21C6, 0x31E6, 0x29C3, 0x29C2, 0x4264, 0x31C3, 0x2162, 0x2142, 0x2141, 0x3A03, 0x4264, 0x4284, 0x52C5, 0x4243, 0x4AA4, 0x52C5, 0x52C4, 0x5B05, 0x5B05, 0x52C4, 
        0x52C4, 0x5B06, 0x4224, 0x29A3, 0x31E3, 0x3A03, 0x4244, 0x6349, 0x8C6F, 0x94B1, 0xB573, 0xBCEE, 0xB552, 0xCE56, 0xC5B3, 0xCE15, 0xA532, 0x736B, 0x840C, 0x6B48, 0x7369, 0x3A24, 0x4265, 0x52E7, 0x31C3, 0x31C3, 0x31E3, 0x4244, 0x4A85, 0x52C5, 
        0x4A84, 0x4264, 0x52E5, 0x4A85, 0x2162, 0x1942, 0x1901, 0x2122, 0x2143, 0x1902, 0x1902, 0x1942, 0x2163, 0x1902, 0x1902, 0x2163, 0x2183, 0x2162, 0x2183, 0x1942, 0x2183, 0x3204, 0x29A3, 0x31E4, 0x29C3, 0x3A04, 0x3A24, 0x31E3, 0x31E3, 0x31E3, 
        0x3A23, 0x31E3, 0x2161, 0x31E3, 0x4284, 0x3223, 0x3A23, 0x3A64, 0x4284, 0x4A85, 0x29C3, 0x2183, 0x31E3, 0x4265, 0x6349, 0x73AC, 0x636B, 0x4246, 0x3A05, 0x4AA8, 0x3205, 0x2984, 0x29A4, 0x29C4, 0x29A4, 0x29A4, 0x31E3, 0x3A24, 0x3A64, 0x4284, 
        0x4264, 0x3A03, 0x29C3, 0x2182, 0x2182, 0x31E3, 0x3A23, 0x3A24, 0x3203, 0x3A24, 0x4285, 0x21A2, 0x2183, 0x3204, 0x29A3, 0x2183, 0x29A3, 0x3A44, 0x4284, 0x3A23, 0x31E3, 0x2162, 0x29C3, 0x3244, 0x4285, 0x4AA5, 0x3203, 0x3203, 0x3203, 0x3204, 
        0x29E3, 0x3203, 0x4AC7, 0x636B, 0x530A, 0x5B0B, 0x5B2B, 0x5B4C, 0x634C, 0x5B4C, 0x5B4C, 0x5B2B, 0x5B0B, 0x5B2B, 0x5B4B, 0x5B4B, 0x5B2B, 0x530A, 0x530A, 0x6BAD, 0xB5B6, 0xCE79, 0xCE9A, 0xDEFB, 0xDF1C, 0xDEFB, 0xE71C, 0xE73C, 0xE73D, 0xEF5D, 
        0xE73C, 0xBE16, 0xB532, 0xC5F4, 0x738B, 0x734A, 0xBDB4, 0xBDD4, 0x83ED, 0x62C8, 0xAD31, 0xBDB3, 0xAD52, 0x9CD0, 0xF73A, 0xF75A, 0xF73A, 0xF73A, 0xF73A, 0xF75A, 0xEF19, 0x5AE8, 0x1943, 0x4267, 0x29C5, 0x1944, 0x1923, 0x1923, 0x1923, 0x2143, 
        0x1903, 0x1923, 0x10E3, 0x1903, 0x1944, 0x1903, 0x10E2, 0x1923, 0x10E2, 0x10E2, 0x10C2, 0x10C2, 0x10A2, 0x1923, 0x2143, 0x1923, 0x1942, 0x3A24, 0x4A85, 0x4264, 0x3A04, 0x31E4, 0x3204, 0x3A24, 0x2983, 0x1902, 0x10C2, 0x10E2, 0x10E2,
  0x2162, 0x2162, 0x2182, 0x29A2, 0x1941, 0x2162, 0x2182, 0x1941, 0x2162, 0x29C3, 0x1902, 0x1922, 0x3A25, 0x2984, 0x2123, 0x2143, 0x2122, 0x2162, 0x2983, 0x18E2, 0x0881, 0x0860, 0x0881, 0x10E1, 0x1902, 0x10C1, 0x0860, 0x0881, 0x2142, 0x2142, 0x2142, 
        0x29A3, 0x2142, 0x29C2, 0x3222, 0x3202, 0x1941, 0x1921, 0x2182, 0x31E3, 0x29A2, 0x2162, 0x1921, 0x2162, 0x2162, 0x29A3, 0x2983, 0x29A3, 0x1921, 0x10E1, 0x2162, 0x1922, 0x10C1, 0x10A1, 0x10A1, 0x10A1, 0x10C1, 0x10C1, 0x1922, 0x29A3, 0x1901, 
        0x1922, 0x1922, 0x0860, 0x1081, 0x0860, 0x0860, 0x0880, 0x08A1, 0x10C1, 0x10E1, 0x1922, 0x2142, 0x2162, 0x10E1, 0x10E1, 0x10C1, 0x10E1, 0x10A1, 0x10C1, 0x2142, 0x2142, 0x31C4, 0x18E1, 0x18E2, 0x1902, 0x2122, 0x2122, 0x18E1, 0x18E1, 0x1901, 
        0x2983, 0x2962, 0x18E1, 0x10E2, 0x1902, 0x10C1, 0x08A1, 0x08A1, 0x10A1, 0x10A1, 0x10C1, 0x10C1, 0x0881, 0x10E2, 0x1902, 0x2182, 0x2982, 0x31E3, 0x3A44, 0x3A24, 0x2962, 0x2122, 0x2962, 0x2962, 0x2962, 0x2122, 0x2122, 0x2122, 0x2142, 0x1902, 
        0x1901, 0x2122, 0x2102, 0x2122, 0x1901, 0x1921, 0x2182, 0x2182, 0x29C3, 0x1901, 0x2142, 0x2162, 0x2142, 0x1921, 0x1100, 0x31E3, 0x31E3, 0x2182, 0x1942, 0x2162, 0x2182, 0x29A2, 0x3A23, 0x31E3, 0x31E2, 0x3A64, 0x3A43, 0x3A43, 0x3A23, 0x3203, 
        0x3A23, 0x3A43, 0x3A23, 0x29A2, 0x31E2, 0x31E3, 0x2982, 0x29A3, 0x31A2, 0x31A2, 0x31A3, 0x31A3, 0x31A3, 0x2983, 0x2962, 0x31A3, 0x2963, 0x2962, 0x39C3, 0x39E3, 0x4A84, 0x5AE5, 0x52A4, 0x4A64, 0x4243, 0x4A64, 0x39E3, 0x39C3, 0x31C3, 0x2942, 
        0x2942, 0x4A64, 0x4224, 0x31C3, 0x2963, 0x2943, 0x2963, 0x2984, 0x2983, 0x3183, 0x31C3, 0x3A04, 0x31C2, 0x3A03, 0x4A64, 0x4223, 0x3A03, 0x31E3, 0x2982, 0x1922, 0x08A1, 0x0881, 0x1102, 0x1922, 0x1922, 0x1901, 0x10E1, 0x1942, 0x2183, 0x1942, 
        0x1942, 0x1942, 0x18E2, 0x1102, 0x10C1, 0x0881, 0x1102, 0x10C1, 0x2984, 0x31E6, 0x1924, 0x2144, 0x1944, 0x31E6, 0x5AE9, 0x52E9, 0x29E6, 0x1924, 0x2985, 0x4268, 0x1944, 0x4A88, 0x6ACA, 0x6AE9, 0x3A27, 0x2185, 0x2165, 0x2185, 0x1964, 0x31C5, 
        0x5B0A, 0x2185, 0x1985, 0x3288, 0x5BAB, 0x4288, 0x4247, 0x2185, 0x3AC9, 0x3A88, 0x21C6, 0x29A5, 0x3A05, 0x31E3, 0x4AA5, 0x52C5, 0x3203, 0x3204, 0x2142, 0x29A2, 0x4AA5, 0x4AC5, 0x3A23, 0x2181, 0x3A43, 0x52E4, 0x52E4, 0x5305, 0x52C4, 0x3A42, 
        0x3202, 0x4243, 0x3A23, 0x3A23, 0x3A44, 0x3A03, 0x4224, 0x73CB, 0x7BED, 0x5B2B, 0xA554, 0xCDD3, 0xC571, 0xCE57, 0xC5B2, 0xB573, 0x94F2, 0x52E8, 0x52E8, 0x6B6A, 0x7369, 0x840C, 0x6B8A, 0x52C7, 0x3A24, 0x3A24, 0x3A03, 0x3A24, 0x31E2, 0x3A23, 
        0x4A84, 0x3203, 0x3A23, 0x4AA4, 0x4244, 0x3204, 0x1902, 0x1922, 0x1902, 0x1902, 0x1902, 0x2142, 0x1902, 0x1922, 0x1922, 0x2162, 0x29C3, 0x29A3, 0x2162, 0x1102, 0x1943, 0x2183, 0x2983, 0x29A3, 0x29A3, 0x29C3, 0x3A24, 0x31E3, 0x29A2, 0x4264, 
        0x4264, 0x4A84, 0x31C3, 0x31E3, 0x4264, 0x4285, 0x31E3, 0x29C3, 0x3A23, 0x4AA5, 0x3A04, 0x1942, 0x29A3, 0x29C3, 0x4266, 0x3A25, 0x29C4, 0x2163, 0x29A4, 0x31C5, 0x31E5, 0x2163, 0x29A4, 0x29A4, 0x2183, 0x2983, 0x29A3, 0x3204, 0x3203, 0x3A44, 
        0x4264, 0x4AA5, 0x3203, 0x1942, 0x1922, 0x2142, 0x31E3, 0x3203, 0x31E3, 0x3203, 0x3203, 0x2182, 0x29C3, 0x29C3, 0x2162, 0x1902, 0x2162, 0x29A2, 0x3203, 0x4AA5, 0x4285, 0x29E3, 0x29C3, 0x2182, 0x2162, 0x31E3, 0x3203, 0x29C3, 0x29A3, 0x29C3, 
        0x2182, 0x31E3, 0x52C7, 0xA553, 0x846F, 0x634B, 0x5B2A, 0x5B2B, 0x634C, 0x5B2B, 0x5B2B, 0x634B, 0x634B, 0x5B2B, 0x5B0B, 0x5B2B, 0x634B, 0x634B, 0x636B, 0x634B, 0x636C, 0x638D, 0x638D, 0x6BAE, 0x73EF, 0x8450, 0x8471, 0x8471, 0x8CB2, 0xA554, 
        0xAD96, 0xBDD6, 0x7AE9, 0xA44E, 0xBD93, 0x7BCC, 0x6B2A, 0x7B8B, 0x41C5, 0x8C0E, 0xDE76, 0x83AB, 0x7BAB, 0x9CB0, 0xF73A, 0xF75A, 0xF73A, 0xF73A, 0xF73A, 0xFF7B, 0xD676, 0x4AA8, 0x2163, 0x3A26, 0x31E6, 0x2985, 0x2144, 0x2143, 0x2144, 0x1923, 
        0x1903, 0x1903, 0x10E2, 0x1923, 0x1903, 0x10E2, 0x10C2, 0x1903, 0x1103, 0x10E2, 0x08C2, 0x10A2, 0x10E2, 0x2143, 0x2163, 0x3A25, 0x3A24, 0x3204, 0x3A44, 0x4284, 0x4285, 0x3A23, 0x3A24, 0x3A24, 0x3A24, 0x3204, 0x2163, 0x1102, 0x10C2,
  0x1901, 0x08A1, 0x2182, 0x1921, 0x10C1, 0x1942, 0x2162, 0x29A3, 0x29C3, 0x31E4, 0x2984, 0x3A25, 0x4266, 0x31E4, 0x3A24, 0x4244, 0x1902, 0x0881, 0x10A1, 0x0880, 0x0861, 0x0861, 0x0860, 0x0861, 0x0881, 0x0881, 0x0881, 0x0881, 0x08A1, 0x10E1, 0x10E1, 
        0x10C1, 0x10E1, 0x1921, 0x21A2, 0x29A2, 0x29C2, 0x1921, 0x10E1, 0x1942, 0x29C2, 0x29A2, 0x29E3, 0x29E3, 0x21A2, 0x2162, 0x29A2, 0x3A44, 0x3204, 0x1942, 0x1101, 0x1922, 0x10E1, 0x10A1, 0x10A1, 0x10A1, 0x10A1, 0x0881, 0x0880, 0x10C1, 0x10E1, 
        0x10A1, 0x0860, 0x0840, 0x0860, 0x10A1, 0x10A1, 0x10E1, 0x1902, 0x1922, 0x1922, 0x2142, 0x2163, 0x2163, 0x0881, 0x08A1, 0x10A1, 0x18E1, 0x18E1, 0x10E1, 0x10E1, 0x10C1, 0x10C1, 0x10A1, 0x10A1, 0x10C1, 0x18C1, 0x18C1, 0x18E2, 0x2142, 0x2122, 
        0x0861, 0x10A1, 0x10C1, 0x1102, 0x10E1, 0x1902, 0x10A1, 0x10A1, 0x10C1, 0x1102, 0x1902, 0x10E1, 0x1902, 0x1901, 0x2162, 0x3204, 0x29E3, 0x29A2, 0x29A2, 0x29A3, 0x2101, 0x2121, 0x2122, 0x2122, 0x1902, 0x18C1, 0x18C1, 0x1902, 0x1902, 0x1902, 
        0x1902, 0x18E1, 0x18E2, 0x18E1, 0x18E1, 0x2983, 0x29C3, 0x31E3, 0x3224, 0x31E3, 0x29C3, 0x4AC8, 0x7C4F, 0x638C, 0x3A47, 0x2162, 0x2162, 0x1942, 0x1922, 0x2182, 0x2183, 0x2162, 0x29A2, 0x29E3, 0x3203, 0x31E3, 0x3203, 0x3A23, 0x3A44, 0x3A24, 
        0x29A2, 0x3203, 0x31A2, 0x2962, 0x31A2, 0x39C3, 0x31A3, 0x2982, 0x39E3, 0x31A3, 0x2962, 0x2983, 0x31A3, 0x31A3, 0x2942, 0x2983, 0x2942, 0x2962, 0x31C2, 0x4A44, 0x5284, 0x4A84, 0x4A63, 0x4223, 0x4223, 0x4223, 0x4A85, 0x4223, 0x3A03, 0x4223, 
        0x4203, 0x52A5, 0x52A4, 0x52A5, 0x31C4, 0x2123, 0x2143, 0x2943, 0x2142, 0x2963, 0x31A3, 0x31C3, 0x39E3, 0x39E3, 0x39C3, 0x4203, 0x4243, 0x4243, 0x3A24, 0x2162, 0x10C1, 0x10C1, 0x10C1, 0x10E1, 0x2162, 0x2183, 0x2143, 0x1902, 0x1942, 0x1942, 
        0x1922, 0x18E2, 0x10C1, 0x10A1, 0x08A1, 0x10C2, 0x10C1, 0x0860, 0x39E6, 0x29A5, 0x2145, 0x1944, 0x29A5, 0x62A9, 0x7247, 0x7247, 0x52A8, 0x2185, 0x2985, 0x4267, 0x2985, 0x6A89, 0x7207, 0x7207, 0x5A47, 0x21A5, 0x2164, 0x2185, 0x2164, 0x29A5, 
        0x52C9, 0x2185, 0x1985, 0x42E9, 0x62E9, 0x5A88, 0x52A9, 0x29E5, 0x5B8B, 0x5AC9, 0x3A48, 0x29A5, 0x29C4, 0x31E3, 0x3A03, 0x52C5, 0x4A84, 0x4264, 0x4244, 0x29C2, 0x3203, 0x3A44, 0x3A43, 0x3A43, 0x4AA4, 0x52C4, 0x4AA4, 0x5B05, 0x4AA4, 0x31E2, 
        0x4A84, 0x4243, 0x4A84, 0x52C5, 0x52C5, 0x4A64, 0x3A03, 0x4224, 0x7C0D, 0x7BED, 0xA554, 0xCE36, 0xD5D2, 0xD698, 0xBD94, 0x842E, 0x6B8B, 0x6348, 0x5AE6, 0x5B06, 0x6306, 0x62E6, 0x4A64, 0x31E3, 0x31C3, 0x3A04, 0x3A23, 0x3A23, 0x3203, 0x31C2, 
        0x3A03, 0x3A03, 0x3A43, 0x4AA5, 0x5305, 0x4AA5, 0x2162, 0x2163, 0x2983, 0x29A3, 0x1922, 0x10E1, 0x1922, 0x2163, 0x31C3, 0x31C3, 0x29C3, 0x31E4, 0x29A3, 0x10E2, 0x10E1, 0x1102, 0x1922, 0x2162, 0x2142, 0x2162, 0x3204, 0x3204, 0x3204, 0x4265, 
        0x3A44, 0x3203, 0x29A2, 0x29A2, 0x3203, 0x31E3, 0x2162, 0x2162, 0x29C3, 0x3203, 0x2982, 0x2163, 0x29C3, 0x29C3, 0x3A05, 0x31C4, 0x29C4, 0x31E4, 0x31E4, 0x31E4, 0x29A4, 0x2143, 0x2984, 0x2984, 0x2984, 0x29A4, 0x29C3, 0x29C3, 0x2162, 0x2162, 
        0x2182, 0x29C3, 0x2183, 0x1102, 0x1942, 0x31E4, 0x3203, 0x3A24, 0x31E3, 0x2182, 0x31E3, 0x3A44, 0x3203, 0x1942, 0x10E1, 0x1922, 0x2162, 0x2162, 0x3A24, 0x3A44, 0x3A23, 0x3224, 0x29E4, 0x1942, 0x2142, 0x29C3, 0x3204, 0x3A44, 0x3204, 0x29C3, 
        0x29C3, 0x29A2, 0x3A45, 0xA552, 0xD699, 0xAD74, 0x844F, 0x6BAD, 0x52EA, 0x4AA9, 0x4AA9, 0x4AA9, 0x4AA9, 0x4AA9, 0x52C9, 0x52EA, 0x52C9, 0x52E9, 0x52E9, 0x530A, 0x52EA, 0x52EA, 0x52CA, 0x4ACA, 0x52CA, 0x52EA, 0x5B2B, 0x5B2B, 0x5B2C, 0x530B, 
        0x530B, 0x634C, 0x5A89, 0x6A68, 0x940D, 0xC5B4, 0x7309, 0x6AA8, 0x49E5, 0xB531, 0xD675, 0x5A86, 0x5A86, 0x8BEC, 0xF73A, 0xF75A, 0xF75A, 0xF73A, 0xF739, 0xEF18, 0x7BEC, 0x3A26, 0x2164, 0x29A5, 0x2184, 0x2144, 0x1923, 0x1903, 0x1903, 0x1903, 
        0x18E2, 0x10C2, 0x10A2, 0x1903, 0x1903, 0x10C2, 0x10C2, 0x1903, 0x10E2, 0x10C2, 0x08A2, 0x1943, 0x3205, 0x29E3, 0x29C3, 0x3A24, 0x31E3, 0x29A2, 0x29C3, 0x3A23, 0x3A23, 0x4264, 0x4A85, 0x3223, 0x3203, 0x3A24, 0x3A24, 0x2183, 0x29C4,
  0x10C1, 0x0840, 0x18E2, 0x2142, 0x0860, 0x10E2, 0x2183, 0x31E4, 0x3A25, 0x31E4, 0x2983, 0x4267, 0x52EA, 0x52E9, 0x3A24, 0x3A24, 0x10C1, 0x0860, 0x0860, 0x0881, 0x10A1, 0x10A1, 0x10A1, 0x0881, 0x0881, 0x10C1, 0x10A1, 0x10A1, 0x10E1, 0x10E1, 0x10C0, 
        0x10E1, 0x1921, 0x1921, 0x10E0, 0x2162, 0x31E3, 0x1901, 0x10E1, 0x10E1, 0x2182, 0x29A2, 0x3223, 0x29E3, 0x2182, 0x1121, 0x1941, 0x29E3, 0x29A3, 0x10E1, 0x1102, 0x1101, 0x08A1, 0x0881, 0x0881, 0x10C1, 0x10C1, 0x0881, 0x0881, 0x10A1, 0x10C1, 
        0x10A1, 0x0861, 0x0861, 0x0840, 0x0860, 0x10A1, 0x1942, 0x1942, 0x1942, 0x1921, 0x10E1, 0x10C1, 0x0880, 0x0880, 0x1081, 0x10A1, 0x10C1, 0x1902, 0x2142, 0x1902, 0x10C1, 0x10C1, 0x18E1, 0x10A1, 0x18C1, 0x10A1, 0x10A1, 0x1901, 0x2963, 0x2983, 
        0x18E1, 0x10A1, 0x18E2, 0x10A1, 0x10C1, 0x2143, 0x0881, 0x0860, 0x08A1, 0x1102, 0x1902, 0x10A1, 0x10C1, 0x1902, 0x10E1, 0x2183, 0x3204, 0x3A24, 0x2982, 0x2122, 0x2142, 0x2142, 0x2121, 0x1901, 0x18E1, 0x18E2, 0x18E2, 0x18E1, 0x18E2, 0x18E2, 
        0x2102, 0x18E1, 0x18E1, 0x18E1, 0x18E1, 0x2142, 0x2182, 0x2162, 0x2142, 0x29E3, 0x29A2, 0x4287, 0x6BCE, 0x7C70, 0x7C90, 0x4267, 0x2983, 0x2183, 0x29A3, 0x10E1, 0x08C0, 0x2162, 0x3204, 0x29A3, 0x3A24, 0x3204, 0x29A2, 0x29C2, 0x3203, 0x3203, 
        0x2982, 0x31E3, 0x39E3, 0x31A3, 0x3182, 0x31A3, 0x31A3, 0x2982, 0x31E3, 0x31A3, 0x31A3, 0x31A3, 0x3183, 0x2963, 0x18E1, 0x1901, 0x31A3, 0x3A03, 0x39E3, 0x4224, 0x39E2, 0x31C2, 0x4243, 0x4A84, 0x4244, 0x4243, 0x5AE5, 0x5AE5, 0x4A84, 0x52C5, 
        0x52A4, 0x4A84, 0x39E2, 0x3A03, 0x2942, 0x2123, 0x2122, 0x1902, 0x2122, 0x2142, 0x2963, 0x2983, 0x2982, 0x2941, 0x31A2, 0x39E2, 0x4243, 0x31C2, 0x2142, 0x10E1, 0x10C1, 0x1922, 0x2143, 0x10A1, 0x1902, 0x1922, 0x2123, 0x10E1, 0x1101, 0x1942, 
        0x10E1, 0x0881, 0x0881, 0x0840, 0x0861, 0x1081, 0x0861, 0x1081, 0x39E6, 0x2165, 0x2165, 0x1945, 0x2144, 0x61C6, 0x7206, 0x7206, 0x51C6, 0x1944, 0x29A5, 0x3A26, 0x2123, 0x69E6, 0x7227, 0x7A07, 0x59C6, 0x2144, 0x1964, 0x2185, 0x2185, 0x29A5, 
        0x52C9, 0x2185, 0x2165, 0x2984, 0x7248, 0x59E6, 0x3A26, 0x3226, 0x62A9, 0x7268, 0x4A48, 0x2185, 0x3A06, 0x29C3, 0x1941, 0x4244, 0x4AA4, 0x4264, 0x4243, 0x4264, 0x3A44, 0x3A44, 0x3A03, 0x4AA4, 0x4AA4, 0x52E5, 0x52C4, 0x4AA4, 0x4263, 0x3A22, 
        0x6346, 0x52C4, 0x4283, 0x4AA4, 0x4A83, 0x4AA5, 0x4264, 0x3A03, 0x73AB, 0x8C8F, 0xADB5, 0xD656, 0xCDD2, 0xCE77, 0xAD53, 0x73CC, 0x5AE6, 0x52C4, 0x52C4, 0x5AE5, 0x5AE5, 0x52A4, 0x52A4, 0x3A23, 0x29A2, 0x4264, 0x4263, 0x4A84, 0x4243, 0x3A23, 
        0x29C2, 0x2182, 0x3223, 0x4AA4, 0x4AC4, 0x4284, 0x3204, 0x2142, 0x2983, 0x2983, 0x10E1, 0x08A1, 0x10E2, 0x2142, 0x2162, 0x2163, 0x1942, 0x2162, 0x2142, 0x1922, 0x2163, 0x2163, 0x1902, 0x2142, 0x29A3, 0x2162, 0x31E4, 0x29C3, 0x29A2, 0x29E3, 
        0x29C3, 0x1921, 0x1921, 0x29E3, 0x29A2, 0x2983, 0x1922, 0x2162, 0x2183, 0x29C3, 0x1901, 0x1922, 0x29A3, 0x31E4, 0x3204, 0x29A4, 0x29A3, 0x4245, 0x4265, 0x31C4, 0x2163, 0x2163, 0x2143, 0x2143, 0x2983, 0x29A3, 0x29E4, 0x2182, 0x2142, 0x2163, 
        0x2162, 0x1901, 0x2183, 0x1942, 0x1922, 0x29A3, 0x29A2, 0x29C3, 0x31E3, 0x29A2, 0x2182, 0x3203, 0x3223, 0x2162, 0x1922, 0x3A45, 0x4285, 0x3202, 0x3A23, 0x3A23, 0x3203, 0x3203, 0x2182, 0x2183, 0x2162, 0x29A3, 0x2182, 0x3223, 0x3A44, 0x29C3, 
        0x3204, 0x29A3, 0x29E3, 0x5308, 0xB5B4, 0xDEBA, 0xAD94, 0x8CB1, 0x8C91, 0x8470, 0x7C2F, 0x740E, 0x6BAD, 0x634B, 0x52C9, 0x5B09, 0x52E9, 0x5B09, 0x52C8, 0x5B2A, 0x636C, 0x634B, 0x5B0B, 0x52CA, 0x4AA9, 0x4A89, 0x4AA9, 0x4AA9, 0x4AA9, 0x4AA9, 
        0x4AA9, 0x4AA9, 0x52EA, 0x52C9, 0x5288, 0xA511, 0x940D, 0x83AC, 0x83CC, 0xA4CF, 0xA4EF, 0x7329, 0x734A, 0x8BEC, 0xD634, 0xDE96, 0xF75A, 0xFFBC, 0xC5D2, 0x7C2C, 0x3205, 0x1923, 0x2984, 0x2985, 0x2144, 0x1923, 0x1103, 0x10E2, 0x1903, 0x1903, 
        0x10C2, 0x10A2, 0x08A2, 0x10C2, 0x10E2, 0x18E2, 0x10C2, 0x18E3, 0x10C2, 0x10C2, 0x10C2, 0x29C4, 0x3224, 0x31E3, 0x3203, 0x3224, 0x3A24, 0x29C3, 0x31E3, 0x29C3, 0x29E3, 0x3A44, 0x4244, 0x3A23, 0x3A44, 0x3A44, 0x3A44, 0x29A3, 0x3204,
  0x0861, 0x0861, 0x0840, 0x0881, 0x0861, 0x0860, 0x2143, 0x2183, 0x2183, 0x3A46, 0x29A4, 0x2984, 0x31A4, 0x31E4, 0x3A44, 0x31C3, 0x0881, 0x0860, 0x0841, 0x0861, 0x08A1, 0x10A1, 0x1081, 0x10A1, 0x0881, 0x10C1, 0x10A1, 0x10A1, 0x10C1, 0x10E1, 0x1921, 
        0x1921, 0x2161, 0x2162, 0x2142, 0x10C1, 0x18E1, 0x10A1, 0x10A1, 0x10E1, 0x2162, 0x2182, 0x29E3, 0x29C2, 0x29C2, 0x29C3, 0x1962, 0x29C2, 0x3204, 0x1942, 0x1922, 0x1922, 0x08A1, 0x0881, 0x0881, 0x0881, 0x10E2, 0x10E2, 0x10C1, 0x10E2, 0x10A1, 
        0x0861, 0x0861, 0x0861, 0x0861, 0x0840, 0x0861, 0x0881, 0x10A1, 0x1902, 0x1922, 0x10C1, 0x10C1, 0x10C1, 0x10C1, 0x10C1, 0x10A1, 0x10A1, 0x10A1, 0x10C1, 0x10A1, 0x10A1, 0x10C1, 0x10C1, 0x10E1, 0x18E1, 0x1922, 0x1901, 0x2122, 0x2142, 0x2982, 
        0x31C3, 0x2122, 0x18E2, 0x0881, 0x0881, 0x1902, 0x10C1, 0x0881, 0x08A1, 0x08A1, 0x0881, 0x10A1, 0x0881, 0x10E1, 0x10E2, 0x10E1, 0x1921, 0x2142, 0x2162, 0x29C3, 0x31E3, 0x31E3, 0x3204, 0x2162, 0x2162, 0x1902, 0x1902, 0x18C1, 0x10C1, 0x1901, 
        0x2122, 0x18E2, 0x18E1, 0x18E2, 0x18E1, 0x18E1, 0x1921, 0x2142, 0x1921, 0x1921, 0x29A3, 0x2142, 0x1922, 0x2163, 0x21A4, 0x5309, 0x5329, 0x4A87, 0x4AA7, 0x4AC7, 0x3A45, 0x2183, 0x1941, 0x1922, 0x10E1, 0x2162, 0x31E3, 0x3A44, 0x3203, 0x29A2, 
        0x29A2, 0x39E3, 0x39C3, 0x3183, 0x2962, 0x2942, 0x2942, 0x2122, 0x2963, 0x2983, 0x2983, 0x2983, 0x2983, 0x2983, 0x39E3, 0x4244, 0x4A84, 0x4A84, 0x4244, 0x39E3, 0x3A03, 0x2982, 0x2981, 0x31C2, 0x3A23, 0x3A03, 0x39E3, 0x52A5, 0x4A84, 0x4244, 
        0x4243, 0x31A2, 0x31C2, 0x3A04, 0x3A04, 0x2963, 0x2143, 0x2142, 0x2162, 0x2962, 0x2142, 0x2963, 0x3183, 0x3182, 0x31A2, 0x3A03, 0x4263, 0x31E2, 0x2162, 0x2182, 0x1942, 0x1101, 0x2183, 0x1902, 0x10C1, 0x10C1, 0x08A1, 0x10C1, 0x1902, 0x10E1, 
        0x10C1, 0x10C2, 0x0881, 0x18E2, 0x1922, 0x10A1, 0x0841, 0x18E2, 0x4247, 0x1924, 0x1924, 0x1944, 0x2144, 0x6207, 0x6206, 0x59C5, 0x59E6, 0x1923, 0x31C6, 0x4247, 0x2124, 0x6A07, 0x59C6, 0x5184, 0x61E6, 0x2144, 0x1944, 0x2165, 0x1944, 0x2185, 
        0x52C9, 0x29A5, 0x2165, 0x39A5, 0x7A68, 0x5A06, 0x4AA9, 0x3A06, 0x6207, 0x7248, 0x31A5, 0x2185, 0x31E5, 0x2983, 0x2142, 0x3A23, 0x4AA5, 0x4243, 0x4A84, 0x31E3, 0x29C2, 0x3A44, 0x3203, 0x3A44, 0x4284, 0x52E5, 0x52E5, 0x4A84, 0x4A84, 0x52E5, 
        0x5B05, 0x5B25, 0x4263, 0x4263, 0x4AA4, 0x4AA4, 0x52A5, 0x52C6, 0x840D, 0x840D, 0xBDF6, 0xD656, 0xBD50, 0x844D, 0x5AE7, 0x6B49, 0x52A5, 0x4A84, 0x4A63, 0x52A4, 0x52C4, 0x4A84, 0x4A63, 0x52A4, 0x4AA4, 0x52C5, 0x52E5, 0x52E5, 0x4AA4, 0x3A44, 
        0x29C2, 0x3224, 0x3A24, 0x3A23, 0x4264, 0x3A23, 0x29A3, 0x1922, 0x1901, 0x31E4, 0x31E4, 0x2122, 0x1902, 0x1922, 0x2162, 0x1942, 0x10E1, 0x1942, 0x1902, 0x1902, 0x2183, 0x29C4, 0x2162, 0x2163, 0x2183, 0x2142, 0x29A3, 0x29C3, 0x31C3, 0x31E4, 
        0x29A3, 0x2162, 0x29C3, 0x31E3, 0x31E3, 0x2162, 0x1942, 0x2162, 0x2162, 0x2142, 0x08A1, 0x10C1, 0x2983, 0x3A24, 0x3A24, 0x31E4, 0x29C3, 0x3204, 0x3A24, 0x31C4, 0x2983, 0x1943, 0x2163, 0x2163, 0x2163, 0x29A3, 0x31E4, 0x2162, 0x10E1, 0x1902, 
        0x2142, 0x2982, 0x3A24, 0x29A3, 0x1922, 0x2162, 0x31C3, 0x29A2, 0x31E3, 0x3A44, 0x3203, 0x31E2, 0x3203, 0x31E3, 0x3224, 0x4264, 0x4284, 0x4284, 0x3A44, 0x3A43, 0x3A44, 0x3224, 0x29C3, 0x29A3, 0x21A2, 0x1962, 0x29C3, 0x3203, 0x3203, 0x31E3, 
        0x2182, 0x29A3, 0x31E3, 0x3A44, 0x52E7, 0xA532, 0xD6B9, 0xA554, 0xBE17, 0xC658, 0xC658, 0xC658, 0xBE17, 0xAD94, 0x94D1, 0x842E, 0x7BED, 0x844E, 0x7C2E, 0x8C8F, 0x9D33, 0x9D13, 0x94F2, 0x94F2, 0x8CB1, 0x8470, 0x8450, 0x7C2F, 0x73EE, 0x6BCD, 
        0x6BAD, 0x6B8D, 0x5B2B, 0x52EA, 0x52A9, 0x52A9, 0x6B2B, 0x946F, 0xB593, 0xB572, 0x9C8F, 0x7BCB, 0x5AE8, 0x5AE8, 0x73CB, 0x4A85, 0x6B8A, 0x8C8E, 0x5307, 0x2182, 0x1943, 0x2164, 0x2143, 0x1943, 0x1943, 0x1923, 0x1903, 0x18E3, 0x18E3, 0x18E3, 
        0x10C2, 0x10C2, 0x10C2, 0x10E2, 0x10E2, 0x18E2, 0x10A2, 0x10E2, 0x10C2, 0x08A1, 0x1902, 0x29C3, 0x29C3, 0x29E3, 0x3203, 0x29E3, 0x21A3, 0x21A3, 0x29A3, 0x1921, 0x29A3, 0x29C2, 0x31E3, 0x31E3, 0x3203, 0x29E3, 0x29C3, 0x3204, 0x29A2,
  0x0840, 0x0861, 0x0861, 0x0861, 0x0881, 0x2123, 0x29A4, 0x2163, 0x29A4, 0x2983, 0x3204, 0x29C3, 0x3A03, 0x3203, 0x29C3, 0x29A3, 0x29A3, 0x0881, 0x0040, 0x0860, 0x0840, 0x0840, 0x0840, 0x0840, 0x0861, 0x0881, 0x10C1, 0x08A1, 0x08A1, 0x10E1, 0x1922, 
        0x1941, 0x1941, 0x1921, 0x1922, 0x0881, 0x08A1, 0x10E1, 0x1101, 0x1902, 0x1942, 0x2162, 0x1941, 0x2182, 0x29C3, 0x2162, 0x1942, 0x1941, 0x3204, 0x1921, 0x1902, 0x1942, 0x10E1, 0x0881, 0x0881, 0x0881, 0x10E2, 0x2142, 0x10C1, 0x10E1, 0x1922, 
        0x10C2, 0x0840, 0x0861, 0x0861, 0x0840, 0x0861, 0x0881, 0x0861, 0x0881, 0x10A1, 0x10C1, 0x10C1, 0x10C1, 0x10E1, 0x10C1, 0x08A1, 0x10A1, 0x08A1, 0x10A1, 0x10A1, 0x10C1, 0x10C1, 0x10C1, 0x18E2, 0x1902, 0x2122, 0x2122, 0x2122, 0x2122, 0x2962, 
        0x31C3, 0x4244, 0x2982, 0x10C1, 0x10C2, 0x08A1, 0x0881, 0x10E2, 0x10C1, 0x10E2, 0x10C1, 0x10A1, 0x1081, 0x10C1, 0x10C1, 0x10C1, 0x18E1, 0x10E1, 0x1901, 0x2162, 0x1922, 0x2182, 0x29E3, 0x29E3, 0x29C3, 0x1922, 0x1902, 0x1902, 0x1902, 0x10C1, 
        0x18E2, 0x10A1, 0x1081, 0x10E2, 0x18E2, 0x0881, 0x10C1, 0x2162, 0x2162, 0x2162, 0x2162, 0x2162, 0x1901, 0x1921, 0x3A67, 0x84B1, 0x8CD2, 0x740E, 0x4246, 0x3A25, 0x4286, 0x5B29, 0x4266, 0x2162, 0x1901, 0x29C3, 0x3A23, 0x3A44, 0x3203, 0x31E3, 
        0x29A2, 0x2982, 0x2142, 0x2122, 0x2122, 0x2122, 0x2122, 0x2122, 0x2962, 0x2962, 0x2942, 0x2942, 0x2122, 0x2942, 0x31C3, 0x31C2, 0x2982, 0x3A03, 0x31C2, 0x39E2, 0x3A03, 0x31E3, 0x31C3, 0x29A2, 0x2982, 0x31A2, 0x31C3, 0x3A03, 0x31E3, 0x31C2, 
        0x31C2, 0x3A03, 0x3A23, 0x2962, 0x2963, 0x2963, 0x2963, 0x2162, 0x2162, 0x2122, 0x2122, 0x2942, 0x2963, 0x39E3, 0x3A03, 0x39E3, 0x4223, 0x3A23, 0x4244, 0x4244, 0x31E3, 0x31C3, 0x31C3, 0x2963, 0x10E2, 0x10C1, 0x10C2, 0x0881, 0x10E1, 0x10C1, 
        0x10E1, 0x2163, 0x2163, 0x2163, 0x1922, 0x10E2, 0x0861, 0x2985, 0x31C6, 0x1924, 0x1944, 0x2165, 0x2965, 0x6227, 0x51A5, 0x4964, 0x59E6, 0x1924, 0x39E6, 0x3A06, 0x2144, 0x6A07, 0x4965, 0x4944, 0x51E6, 0x1944, 0x1944, 0x2164, 0x1944, 0x2185, 
        0x52C9, 0x29A5, 0x2165, 0x39A6, 0x6A07, 0x5A07, 0x39E6, 0x4A68, 0x59C6, 0x6A27, 0x3185, 0x2185, 0x29C5, 0x31C4, 0x2182, 0x2182, 0x2182, 0x2182, 0x4264, 0x4264, 0x31E3, 0x2182, 0x2982, 0x31E3, 0x3A23, 0x4A84, 0x3A02, 0x3203, 0x3A43, 0x3A43, 
        0x4263, 0x4283, 0x5B05, 0x4AA4, 0x4AA4, 0x4A84, 0x4264, 0x4A85, 0x6B8A, 0x634A, 0x94F1, 0xCE15, 0xB4EE, 0x52A5, 0x3A23, 0x3A23, 0x4243, 0x4243, 0x4A64, 0x4A84, 0x52A4, 0x4A84, 0x5284, 0x52C5, 0x4AA4, 0x3A43, 0x3203, 0x3A23, 0x4264, 0x31E3, 
        0x2182, 0x1942, 0x2162, 0x29A3, 0x29C3, 0x29C3, 0x29C3, 0x31E3, 0x1941, 0x3203, 0x4A85, 0x4244, 0x2142, 0x2162, 0x1922, 0x10E1, 0x1922, 0x2983, 0x1922, 0x1102, 0x2162, 0x29A3, 0x29C3, 0x29C3, 0x1942, 0x10E1, 0x1942, 0x2163, 0x2162, 0x29C3, 
        0x2182, 0x1101, 0x2183, 0x29A3, 0x31E3, 0x2182, 0x2162, 0x29C3, 0x3204, 0x2162, 0x1922, 0x2142, 0x2183, 0x31E4, 0x2183, 0x29C3, 0x2183, 0x29A3, 0x31E3, 0x3204, 0x29C4, 0x2163, 0x2143, 0x2163, 0x2143, 0x2163, 0x2162, 0x1922, 0x1942, 0x2182, 
        0x29A3, 0x3A24, 0x4264, 0x3204, 0x1101, 0x2162, 0x29C3, 0x3203, 0x3A44, 0x3A43, 0x3A43, 0x4284, 0x3223, 0x3203, 0x29C3, 0x29A2, 0x29E3, 0x3A64, 0x3203, 0x3A24, 0x4285, 0x1962, 0x21A2, 0x31E3, 0x3204, 0x31E3, 0x31E3, 0x29C3, 0x29E3, 0x3204, 
        0x2183, 0x2162, 0x2182, 0x3224, 0x3A44, 0x844D, 0xC636, 0xC636, 0xB5D6, 0xD6DA, 0xBE37, 0x94B2, 0x94D2, 0xA533, 0xB5D5, 0xA532, 0x8C4F, 0xA553, 0x94D1, 0x7C2E, 0xAD74, 0xC658, 0xCE99, 0xCE99, 0xCE79, 0xCE79, 0xC678, 0xC658, 0xC638, 0xBE37, 
        0xBE37, 0xBE17, 0xB5F6, 0xADB5, 0xA533, 0x9490, 0x8C2E, 0x7BCC, 0x83AC, 0x838B, 0x5AC8, 0x3A25, 0x3A25, 0x31E4, 0x29A3, 0x21A3, 0x1922, 0x1922, 0x2182, 0x1942, 0x1942, 0x1963, 0x1923, 0x1923, 0x1923, 0x1903, 0x18E3, 0x1903, 0x18E2, 0x10C2, 
        0x10C2, 0x10C2, 0x10C2, 0x10E2, 0x10E2, 0x10C2, 0x18E3, 0x1923, 0x10C2, 0x1902, 0x31C4, 0x3204, 0x31E3, 0x29E3, 0x29A3, 0x2183, 0x29C3, 0x2183, 0x29C3, 0x1921, 0x29C3, 0x29E3, 0x29C3, 0x29C3, 0x29E3, 0x3203, 0x21A2, 0x29C3, 0x29A3,
  0x0861, 0x0881, 0x1922, 0x1922, 0x0860, 0x29A4, 0x31E5, 0x29A4, 0x29C3, 0x29C3, 0x3A44, 0x3203, 0x2161, 0x29C2, 0x2142, 0x1101, 0x2183, 0x18E2, 0x0840, 0x0861, 0x0860, 0x0840, 0x0860, 0x0840, 0x0861, 0x0861, 0x0040, 0x0881, 0x10C1, 0x10C1, 0x0881, 
        0x10C1, 0x1101, 0x1101, 0x10C1, 0x0881, 0x10E1, 0x2182, 0x1922, 0x10E1, 0x2162, 0x1921, 0x2162, 0x29C3, 0x21A2, 0x31E3, 0x2162, 0x2182, 0x2182, 0x1922, 0x10C1, 0x10E1, 0x2142, 0x1902, 0x0881, 0x0881, 0x10C1, 0x2142, 0x1902, 0x08A1, 0x08C1, 
        0x0881, 0x0040, 0x0861, 0x0861, 0x0040, 0x0840, 0x0861, 0x0881, 0x0881, 0x10E1, 0x1102, 0x1902, 0x10C1, 0x10C1, 0x1102, 0x18E2, 0x08A1, 0x10C1, 0x10E1, 0x10E1, 0x10E2, 0x1901, 0x10C1, 0x10E1, 0x18E1, 0x18E2, 0x1902, 0x2963, 0x1902, 0x10C1, 
        0x1901, 0x31A3, 0x39E3, 0x31A3, 0x10E1, 0x0060, 0x0881, 0x08A1, 0x08A1, 0x08A1, 0x1922, 0x10E1, 0x10C1, 0x10E2, 0x1102, 0x1902, 0x1922, 0x2142, 0x2142, 0x1901, 0x08C1, 0x1942, 0x2162, 0x29A2, 0x29C3, 0x31C3, 0x18E2, 0x2122, 0x2143, 0x10C1, 
        0x18C2, 0x2123, 0x10A1, 0x10A1, 0x10C1, 0x10A1, 0x1902, 0x2983, 0x2142, 0x2182, 0x2162, 0x2162, 0x2182, 0x10E1, 0x29A4, 0x3A46, 0x4288, 0x5B2A, 0x4AA9, 0x5309, 0x3225, 0x29A3, 0x6369, 0x4AC7, 0x3223, 0x31E3, 0x1921, 0x29C2, 0x31E3, 0x3A24, 
        0x31E3, 0x2962, 0x2122, 0x2142, 0x2962, 0x2942, 0x2142, 0x2122, 0x2142, 0x2122, 0x2142, 0x2142, 0x2942, 0x2962, 0x31A3, 0x39C3, 0x4224, 0x39E3, 0x39E3, 0x4224, 0x4244, 0x4224, 0x3A03, 0x31A2, 0x31C3, 0x2982, 0x2982, 0x2982, 0x2162, 0x2141, 
        0x31E3, 0x4264, 0x4AA5, 0x31C3, 0x2122, 0x2963, 0x29A2, 0x2142, 0x2122, 0x2142, 0x2983, 0x2983, 0x29A3, 0x2122, 0x2962, 0x2982, 0x29C2, 0x3A44, 0x3A44, 0x3A23, 0x39E3, 0x31A2, 0x31A3, 0x2963, 0x10C1, 0x08A1, 0x0881, 0x08A1, 0x1902, 0x1942, 
        0x1902, 0x1942, 0x2183, 0x2142, 0x1922, 0x08A1, 0x0860, 0x31A5, 0x2164, 0x1944, 0x1944, 0x1944, 0x2965, 0x5A07, 0x41A5, 0x4185, 0x49A6, 0x1924, 0x3A47, 0x31C6, 0x2965, 0x59E7, 0x41C5, 0x41A5, 0x41A6, 0x1944, 0x2165, 0x1944, 0x2165, 0x2184, 
        0x630A, 0x29A5, 0x1965, 0x2985, 0x5207, 0x5207, 0x31A5, 0x4227, 0x49C6, 0x6A07, 0x31A5, 0x2185, 0x29A6, 0x4266, 0x31E3, 0x3204, 0x1942, 0x1921, 0x29C2, 0x4264, 0x4284, 0x3A43, 0x29C3, 0x2182, 0x3223, 0x4A84, 0x4263, 0x3A44, 0x29C2, 0x2141, 
        0x31E2, 0x3A43, 0x52E5, 0x52E5, 0x4263, 0x4A84, 0x3A03, 0x3A03, 0x4244, 0x3A24, 0x4AA7, 0x5AE8, 0x52A6, 0x4223, 0x31C2, 0x4244, 0x4A85, 0x4A84, 0x4A84, 0x3A03, 0x3A03, 0x3A03, 0x4244, 0x3A23, 0x31E2, 0x3203, 0x29A2, 0x31E3, 0x3A23, 0x31E3, 
        0x2182, 0x1101, 0x10E1, 0x29A3, 0x31E3, 0x31C3, 0x4244, 0x4A85, 0x3A44, 0x3A03, 0x31E2, 0x4244, 0x2982, 0x2162, 0x29A3, 0x1942, 0x1942, 0x1942, 0x1922, 0x1922, 0x1942, 0x2982, 0x31E4, 0x29C3, 0x2183, 0x1922, 0x1922, 0x1942, 0x2162, 0x29A3, 
        0x3204, 0x1901, 0x10C1, 0x1942, 0x2162, 0x29A3, 0x1922, 0x2182, 0x31E3, 0x3224, 0x29C3, 0x21A3, 0x1902, 0x2142, 0x2163, 0x1902, 0x1922, 0x1922, 0x2162, 0x29E3, 0x29C3, 0x29A4, 0x2163, 0x2163, 0x2163, 0x2143, 0x2142, 0x1942, 0x29C4, 0x3204, 
        0x29A3, 0x2182, 0x2162, 0x1942, 0x1942, 0x2162, 0x29A2, 0x31E3, 0x29A2, 0x29C2, 0x29C2, 0x3A44, 0x3224, 0x29A2, 0x2182, 0x1962, 0x29A3, 0x3204, 0x2162, 0x29C3, 0x3224, 0x21A2, 0x29A3, 0x3203, 0x2182, 0x1101, 0x2162, 0x1922, 0x29A3, 0x1942, 
        0x2162, 0x29C3, 0x1942, 0x3204, 0x3A24, 0x73CB, 0xBDD5, 0xC637, 0x8C6F, 0x94D1, 0x5B2B, 0x31E6, 0x7BEE, 0x94B1, 0xAD54, 0xBE16, 0xA532, 0x94B0, 0x9D12, 0xA573, 0x94F2, 0x5AEA, 0x7BEF, 0xD69A, 0xD6DB, 0xD6BA, 0xD6BA, 0xD6BA, 0xD6DA, 0xDEDB, 
        0xA554, 0x94B2, 0xBDF7, 0xD6DA, 0xC678, 0xAD74, 0x948F, 0x736B, 0x5205, 0x5A06, 0x41E5, 0x29C4, 0x29A3, 0x29A4, 0x29C4, 0x21A3, 0x1942, 0x3205, 0x29A4, 0x1963, 0x1923, 0x1943, 0x1923, 0x1923, 0x10E2, 0x10C2, 0x18E3, 0x18E3, 0x18C2, 0x18C2, 
        0x10A2, 0x10A2, 0x10C2, 0x10C2, 0x10C2, 0x10E2, 0x1923, 0x2163, 0x31C4, 0x2182, 0x3A04, 0x3A44, 0x3A24, 0x21A3, 0x1962, 0x2183, 0x2183, 0x2983, 0x29C4, 0x29C3, 0x2162, 0x3204, 0x1942, 0x29C3, 0x1942, 0x29C3, 0x31E4, 0x1922, 0x2142,
  0x0881, 0x0861, 0x1902, 0x29A3, 0x2162, 0x3205, 0x31E5, 0x10C1, 0x1921, 0x31E3, 0x31E2, 0x31E2, 0x31C2, 0x29A2, 0x1921, 0x1942, 0x10C1, 0x0860, 0x0881, 0x0861, 0x0861, 0x0861, 0x0860, 0x0881, 0x0861, 0x0860, 0x0860, 0x0860, 0x0881, 0x10E1, 0x0881, 
        0x08A1, 0x10E1, 0x1102, 0x1922, 0x10E2, 0x10C1, 0x2162, 0x29E3, 0x2982, 0x2982, 0x29A3, 0x29C3, 0x3203, 0x31C3, 0x2162, 0x1901, 0x29C3, 0x2182, 0x29A3, 0x1922, 0x1942, 0x1942, 0x10C1, 0x0881, 0x0880, 0x10E1, 0x1922, 0x1902, 0x08A1, 0x0881, 
        0x0861, 0x0840, 0x0861, 0x0861, 0x0861, 0x0840, 0x0861, 0x10C1, 0x10C1, 0x10E1, 0x1101, 0x1942, 0x1922, 0x10A1, 0x1102, 0x10C1, 0x0881, 0x10A1, 0x10E1, 0x10C1, 0x1902, 0x1922, 0x10C1, 0x10A1, 0x10A1, 0x1081, 0x10A1, 0x10E2, 0x10C1, 0x10A1, 
        0x0881, 0x10C1, 0x2963, 0x39E3, 0x3A04, 0x1902, 0x0040, 0x0861, 0x10A1, 0x10C1, 0x10C1, 0x10E1, 0x10C1, 0x10C2, 0x10E1, 0x1922, 0x2142, 0x2162, 0x29C3, 0x29A3, 0x10C1, 0x10C1, 0x2162, 0x2162, 0x2162, 0x2142, 0x18E2, 0x10A1, 0x10A1, 0x0881, 
        0x18C2, 0x2164, 0x2144, 0x10A1, 0x10A1, 0x18E2, 0x2963, 0x29A3, 0x2162, 0x1942, 0x29A3, 0x3203, 0x29C3, 0x1922, 0x2182, 0x3203, 0x3204, 0x29A3, 0x1101, 0x29A4, 0x3A66, 0x42A7, 0x3A25, 0x5B08, 0x3203, 0x29C3, 0x1921, 0x1921, 0x3203, 0x3A24, 
        0x31C3, 0x2122, 0x1901, 0x2942, 0x3182, 0x2942, 0x2122, 0x2122, 0x2142, 0x2101, 0x2101, 0x2962, 0x31A3, 0x31A2, 0x31C3, 0x39E3, 0x39E3, 0x29A2, 0x31A2, 0x2982, 0x4224, 0x4204, 0x39E3, 0x31E3, 0x3A03, 0x2982, 0x2162, 0x2142, 0x1921, 0x2142, 
        0x4224, 0x4264, 0x4223, 0x4224, 0x2963, 0x2122, 0x31E3, 0x2162, 0x1902, 0x2102, 0x2122, 0x2142, 0x2122, 0x2122, 0x2122, 0x2982, 0x29A2, 0x29C2, 0x31E3, 0x3A44, 0x31C3, 0x2982, 0x31A2, 0x31C3, 0x10E1, 0x0881, 0x10C2, 0x10A1, 0x1902, 0x2142, 
        0x2142, 0x2142, 0x1922, 0x1922, 0x10C1, 0x0881, 0x1081, 0x39E6, 0x2144, 0x1924, 0x1924, 0x1944, 0x2165, 0x2985, 0x29A5, 0x2985, 0x2965, 0x1944, 0x4268, 0x31C6, 0x2164, 0x29A5, 0x29A5, 0x29A5, 0x2165, 0x1945, 0x1944, 0x2144, 0x2165, 0x1944, 
        0x52A9, 0x29A5, 0x2165, 0x2185, 0x31E6, 0x31C6, 0x31C5, 0x4A88, 0x39C5, 0x5207, 0x39C6, 0x2185, 0x2165, 0x3A46, 0x4265, 0x3A23, 0x29A2, 0x31E3, 0x2141, 0x31E3, 0x4AA5, 0x4284, 0x4284, 0x2141, 0x29C2, 0x4284, 0x4284, 0x3A63, 0x29C2, 0x2982, 
        0x31E2, 0x4AA4, 0x52E5, 0x4AA4, 0x4A84, 0x52E5, 0x31E2, 0x31C3, 0x4224, 0x31C3, 0x3A04, 0x5B08, 0x4224, 0x4244, 0x4244, 0x4244, 0x4244, 0x4244, 0x4244, 0x39E3, 0x4223, 0x4223, 0x39E3, 0x31E3, 0x29A2, 0x2141, 0x2161, 0x29A2, 0x31E3, 0x4264, 
        0x3A24, 0x2982, 0x1942, 0x29A2, 0x3A24, 0x4264, 0x3A24, 0x31C2, 0x31C2, 0x4264, 0x3A23, 0x3A22, 0x4284, 0x2162, 0x1942, 0x2163, 0x1102, 0x1943, 0x2163, 0x1922, 0x2142, 0x2983, 0x29A3, 0x29C3, 0x29C3, 0x2162, 0x1902, 0x1922, 0x29A3, 0x31C3, 
        0x3204, 0x2162, 0x1901, 0x1942, 0x2162, 0x2162, 0x2163, 0x29A3, 0x29C3, 0x3224, 0x29A3, 0x2162, 0x1942, 0x2183, 0x2163, 0x1922, 0x1922, 0x1942, 0x29C4, 0x3204, 0x3A44, 0x4285, 0x31C4, 0x2123, 0x1922, 0x1922, 0x2142, 0x2183, 0x2183, 0x2142, 
        0x1942, 0x1942, 0x2163, 0x10E1, 0x1902, 0x29A3, 0x31E3, 0x31E3, 0x29C3, 0x2182, 0x1922, 0x1942, 0x2162, 0x29C3, 0x31E4, 0x21A3, 0x2182, 0x29C3, 0x1921, 0x1941, 0x29A3, 0x1942, 0x1942, 0x29E3, 0x3204, 0x2162, 0x1101, 0x1942, 0x21A3, 0x29C3, 
        0x21A3, 0x29C3, 0x21A3, 0x3204, 0x29E3, 0x4AA7, 0x94B0, 0xBDD5, 0x94D1, 0x636C, 0x5B2B, 0x3A26, 0x4267, 0x7C0E, 0x9CD2, 0xA553, 0x8C70, 0x7C0E, 0x7BEE, 0x9490, 0x4A67, 0x2984, 0x2124, 0x6B6D, 0xD6BA, 0xD6DB, 0xD6BA, 0xD6DA, 0xDEFB, 0x94D2, 
        0x4AA9, 0x73AD, 0x8C70, 0xC637, 0xD6B9, 0x9D32, 0x7C2E, 0x5B29, 0x4A45, 0x4A25, 0x3A04, 0x29C4, 0x31C4, 0x29C4, 0x21C3, 0x2183, 0x2163, 0x29C4, 0x29A4, 0x3206, 0x1923, 0x1903, 0x1903, 0x1923, 0x10E2, 0x1903, 0x1903, 0x18E2, 0x18E2, 0x10C2, 
        0x10A2, 0x10C2, 0x10E2, 0x1903, 0x2123, 0x1902, 0x31A4, 0x3A25, 0x3A24, 0x29C3, 0x3204, 0x3204, 0x3A44, 0x3A44, 0x29A3, 0x1942, 0x1922, 0x1101, 0x2142, 0x29A3, 0x1921, 0x29A3, 0x2142, 0x29C3, 0x29C3, 0x1942, 0x1942, 0x1922, 0x1942,
  0x0861, 0x0881, 0x0880, 0x1922, 0x29C3, 0x4267, 0x2143, 0x08C1, 0x1922, 0x2982, 0x29C3, 0x3203, 0x3203, 0x31E3, 0x31C3, 0x29A3, 0x10A1, 0x0861, 0x0881, 0x0861, 0x0861, 0x0861, 0x0060, 0x10E1, 0x1902, 0x10C1, 0x0880, 0x0881, 0x0881, 0x0860, 0x0881, 
        0x10A1, 0x10C1, 0x1101, 0x1922, 0x10C1, 0x1922, 0x2162, 0x2162, 0x2162, 0x2182, 0x2162, 0x2982, 0x3203, 0x2983, 0x2142, 0x1901, 0x1942, 0x2183, 0x29C3, 0x2162, 0x1922, 0x1942, 0x10E1, 0x10E2, 0x10E2, 0x10E1, 0x1902, 0x10E1, 0x10A1, 0x0861, 
        0x0861, 0x0861, 0x0861, 0x0860, 0x0840, 0x0860, 0x10A1, 0x10E2, 0x1902, 0x10C1, 0x1101, 0x1902, 0x1922, 0x18E1, 0x1901, 0x10A1, 0x10A1, 0x10C1, 0x18E2, 0x10C1, 0x10C1, 0x10A1, 0x1081, 0x10A1, 0x18E2, 0x10A1, 0x0881, 0x0881, 0x0881, 0x08A1, 
        0x10C1, 0x0880, 0x0861, 0x10C1, 0x29A3, 0x29A3, 0x10C2, 0x08A1, 0x0881, 0x10E2, 0x10E1, 0x1922, 0x10C1, 0x08A1, 0x0881, 0x10C1, 0x10E1, 0x10E1, 0x18E1, 0x1942, 0x1101, 0x1922, 0x2142, 0x1901, 0x1902, 0x10A1, 0x10A1, 0x10A1, 0x0860, 0x0861, 
        0x2144, 0x1903, 0x0881, 0x0881, 0x10A1, 0x1902, 0x29A3, 0x2962, 0x2122, 0x1901, 0x2162, 0x3204, 0x3203, 0x2162, 0x2162, 0x29A3, 0x31E3, 0x29A3, 0x1942, 0x29A3, 0x10C1, 0x2164, 0x4AA8, 0x52C8, 0x31E4, 0x29C3, 0x2982, 0x29C3, 0x31E3, 0x31C2, 
        0x2962, 0x3182, 0x3183, 0x39C3, 0x31A3, 0x2122, 0x2122, 0x2962, 0x2942, 0x2101, 0x1901, 0x2983, 0x31C3, 0x39E3, 0x29A2, 0x31C3, 0x31C3, 0x39E3, 0x3182, 0x31A3, 0x3182, 0x31A2, 0x39C3, 0x2962, 0x31A3, 0x2982, 0x2142, 0x2142, 0x2983, 0x2122, 
        0x2142, 0x2982, 0x2982, 0x31A3, 0x2142, 0x1901, 0x2982, 0x31E4, 0x2983, 0x2122, 0x2102, 0x2122, 0x1902, 0x18E1, 0x18E1, 0x2142, 0x29C3, 0x29C3, 0x2182, 0x29C3, 0x2982, 0x2962, 0x2982, 0x31C3, 0x29A3, 0x1101, 0x10E1, 0x2162, 0x29C3, 0x3A24, 
        0x3204, 0x2182, 0x1942, 0x2142, 0x1902, 0x10A1, 0x2102, 0x3A27, 0x1903, 0x1924, 0x1944, 0x1944, 0x1944, 0x1944, 0x1965, 0x2165, 0x1945, 0x1944, 0x4248, 0x2985, 0x1944, 0x2165, 0x1944, 0x2144, 0x1965, 0x2165, 0x2165, 0x2165, 0x1944, 0x1944, 
        0x52C9, 0x31C6, 0x2165, 0x2185, 0x2185, 0x2185, 0x2185, 0x4267, 0x29C5, 0x29A6, 0x2985, 0x2985, 0x2185, 0x31E5, 0x31C4, 0x3A24, 0x3203, 0x31E3, 0x29C3, 0x3203, 0x4264, 0x4264, 0x4284, 0x4264, 0x4264, 0x4284, 0x4AC5, 0x4263, 0x29A1, 0x3A03, 
        0x31E2, 0x4263, 0x4AA4, 0x4AA4, 0x4AA4, 0x4283, 0x4284, 0x31E3, 0x31C3, 0x4223, 0x4A65, 0x6328, 0x4224, 0x4244, 0x4A64, 0x3A03, 0x4223, 0x39E3, 0x39E3, 0x39E3, 0x4244, 0x3A03, 0x31C3, 0x29A2, 0x2182, 0x1941, 0x29A2, 0x29A3, 0x2162, 0x29C3, 
        0x3A44, 0x3A44, 0x29A2, 0x2982, 0x29C2, 0x4A84, 0x3A23, 0x3A03, 0x4244, 0x4AA4, 0x4AA4, 0x4284, 0x52E5, 0x4265, 0x2142, 0x1922, 0x10C1, 0x1922, 0x21A3, 0x2183, 0x2162, 0x2183, 0x29A3, 0x29A3, 0x29A3, 0x2983, 0x1902, 0x10E1, 0x1942, 0x29C3, 
        0x31E3, 0x4265, 0x4285, 0x4264, 0x3204, 0x10E1, 0x08A0, 0x2162, 0x31C3, 0x3A04, 0x29A3, 0x2163, 0x1942, 0x29C4, 0x31E4, 0x1943, 0x1943, 0x2143, 0x29A3, 0x3203, 0x4265, 0x4264, 0x4265, 0x2983, 0x10E2, 0x1102, 0x2142, 0x2142, 0x1902, 0x10E1, 
        0x10E1, 0x1902, 0x2163, 0x10C1, 0x10E1, 0x29A3, 0x29A3, 0x2162, 0x29C3, 0x21A3, 0x2182, 0x2142, 0x31E3, 0x4285, 0x3203, 0x3203, 0x4264, 0x31C3, 0x29A3, 0x1942, 0x2162, 0x2162, 0x1942, 0x2182, 0x29E3, 0x3A44, 0x29A3, 0x1922, 0x29C4, 0x21A3, 
        0x21A2, 0x3224, 0x3A44, 0x31E3, 0x31C4, 0x4245, 0x6B6B, 0x632A, 0x52E9, 0x31E5, 0x31C6, 0x31C5, 0x2984, 0x31C5, 0x4A68, 0x4A88, 0x4227, 0x39E5, 0x4226, 0x39E6, 0x31A5, 0x2944, 0x2124, 0x2124, 0x9491, 0xDEDB, 0xDEFB, 0xDEFB, 0xBE17, 0x532B, 
        0x4A88, 0x73AD, 0x94D1, 0xB595, 0xD6BA, 0xB5D5, 0x636A, 0x3A45, 0x3204, 0x31E4, 0x3204, 0x31E4, 0x29C3, 0x2183, 0x1942, 0x2984, 0x2164, 0x2123, 0x18E2, 0x2164, 0x1903, 0x10E2, 0x10C2, 0x10E2, 0x18E3, 0x1903, 0x18E3, 0x1903, 0x18E3, 0x10E2, 
        0x10E2, 0x10C2, 0x10E2, 0x1923, 0x3A04, 0x3A04, 0x4244, 0x4244, 0x31C3, 0x29C3, 0x2162, 0x29A3, 0x29A3, 0x2142, 0x21A3, 0x2163, 0x1101, 0x2162, 0x31E4, 0x31C3, 0x29C3, 0x3A45, 0x31E3, 0x2162, 0x2162, 0x1922, 0x10C1, 0x1922, 0x2183,
  0x10C1, 0x1922, 0x1921, 0x2162, 0x2183, 0x4288, 0x10E2, 0x10E1, 0x2142, 0x2122, 0x1901, 0x2983, 0x2142, 0x2162, 0x3A24, 0x31E4, 0x10C1, 0x0861, 0x0840, 0x0860, 0x0861, 0x0881, 0x10C1, 0x10E1, 0x10E1, 0x10E1, 0x10C1, 0x0881, 0x10A1, 0x10A1, 0x0860, 
        0x0881, 0x10A1, 0x10A1, 0x10E2, 0x10A1, 0x08A1, 0x1922, 0x29C3, 0x2182, 0x29A2, 0x29C3, 0x2162, 0x2982, 0x2142, 0x10C1, 0x1942, 0x2183, 0x1942, 0x1922, 0x1901, 0x1942, 0x1942, 0x08A1, 0x1101, 0x1942, 0x1922, 0x1922, 0x10C1, 0x1102, 0x10C1, 
        0x0861, 0x0861, 0x0861, 0x0861, 0x0861, 0x0881, 0x0060, 0x0881, 0x10A1, 0x10A1, 0x08A1, 0x10A1, 0x10E1, 0x1922, 0x1922, 0x1081, 0x0881, 0x1081, 0x10C1, 0x10E2, 0x1922, 0x2142, 0x10A1, 0x1081, 0x18E2, 0x2122, 0x2122, 0x10A1, 0x0861, 0x0881, 
        0x1902, 0x18E2, 0x0861, 0x0881, 0x10A1, 0x18E1, 0x10C1, 0x10A1, 0x0881, 0x0881, 0x10C1, 0x10A1, 0x10C1, 0x10E2, 0x10C1, 0x0880, 0x10C1, 0x1901, 0x10C1, 0x1902, 0x1942, 0x2122, 0x2122, 0x2982, 0x2982, 0x2142, 0x10A1, 0x10A1, 0x1081, 0x10A2, 
        0x0881, 0x10E2, 0x1902, 0x18E1, 0x1901, 0x2962, 0x2962, 0x31C3, 0x31A3, 0x2962, 0x31C3, 0x3A04, 0x31E4, 0x1902, 0x08A1, 0x1922, 0x1922, 0x2162, 0x1921, 0x1922, 0x08A1, 0x0880, 0x2984, 0x6B8B, 0x2983, 0x1942, 0x29C3, 0x3203, 0x31C3, 0x31C2, 
        0x39A3, 0x39A3, 0x3183, 0x3983, 0x31A3, 0x2942, 0x2942, 0x3183, 0x3183, 0x2142, 0x2942, 0x2962, 0x2962, 0x2982, 0x31A2, 0x2962, 0x2962, 0x2942, 0x2142, 0x2962, 0x2142, 0x2962, 0x2122, 0x1921, 0x4246, 0x5AE8, 0x39E4, 0x29A2, 0x31E3, 0x31C3, 
        0x2982, 0x31C3, 0x31E3, 0x29A3, 0x31C3, 0x2963, 0x1922, 0x2142, 0x2963, 0x2122, 0x2963, 0x2142, 0x1922, 0x1901, 0x10E1, 0x1942, 0x1942, 0x1942, 0x29C3, 0x3204, 0x3203, 0x31C3, 0x2982, 0x29A2, 0x31C3, 0x29A3, 0x1922, 0x2183, 0x2162, 0x2983, 
        0x3204, 0x29A3, 0x2162, 0x2162, 0x2142, 0x10C1, 0x39E5, 0x29C5, 0x1923, 0x1944, 0x1924, 0x1944, 0x1945, 0x1944, 0x1965, 0x1944, 0x1924, 0x2144, 0x4247, 0x2185, 0x1944, 0x1944, 0x2164, 0x1944, 0x1965, 0x1945, 0x1945, 0x1944, 0x1944, 0x1944, 
        0x4A88, 0x31E6, 0x2185, 0x2185, 0x2985, 0x2185, 0x2185, 0x4247, 0x29A5, 0x2985, 0x2185, 0x29C6, 0x29C5, 0x31E6, 0x31C5, 0x2142, 0x3A03, 0x29C2, 0x31E3, 0x31E3, 0x3A44, 0x4264, 0x3A23, 0x4284, 0x3A43, 0x29A1, 0x4263, 0x4A84, 0x4264, 0x4264, 
        0x4284, 0x4243, 0x4284, 0x4AA4, 0x4A83, 0x4AA4, 0x4A84, 0x3A03, 0x39E3, 0x4A64, 0x4224, 0x3A03, 0x3A03, 0x39E3, 0x31A2, 0x3A03, 0x4224, 0x39E3, 0x3A03, 0x31C2, 0x3A03, 0x31E3, 0x29A2, 0x1942, 0x29A3, 0x3203, 0x31E3, 0x31E4, 0x2142, 0x1942, 
        0x29C3, 0x29E3, 0x29A3, 0x3A44, 0x3A03, 0x4264, 0x4AA5, 0x4284, 0x3203, 0x29C2, 0x31E3, 0x4244, 0x3A23, 0x3204, 0x2183, 0x10E2, 0x10C2, 0x10C2, 0x1102, 0x1942, 0x1922, 0x1922, 0x1902, 0x10E1, 0x2142, 0x2163, 0x1902, 0x1902, 0x2142, 0x31E3, 
        0x31E3, 0x3A03, 0x3A44, 0x4264, 0x4284, 0x3204, 0x31E4, 0x29C3, 0x31E3, 0x2182, 0x2162, 0x2162, 0x1922, 0x1102, 0x1942, 0x1102, 0x1922, 0x1943, 0x2162, 0x3203, 0x3A44, 0x3203, 0x3204, 0x3204, 0x1942, 0x1922, 0x2183, 0x2142, 0x10E1, 0x10C1, 
        0x10C1, 0x1902, 0x10E2, 0x08A1, 0x10C1, 0x10E1, 0x1102, 0x1101, 0x1921, 0x1942, 0x29A2, 0x29C3, 0x3A44, 0x4AA5, 0x4284, 0x3A44, 0x4AA4, 0x52E5, 0x4AC5, 0x3203, 0x29C3, 0x2162, 0x2182, 0x2182, 0x2182, 0x29C3, 0x3A44, 0x29C3, 0x1942, 0x2162, 
        0x29C3, 0x31E4, 0x3203, 0x31E3, 0x29A3, 0x29C3, 0x4225, 0x39E5, 0x31C4, 0x29C4, 0x31A4, 0x2964, 0x2144, 0x1903, 0x18E2, 0x2944, 0x31C5, 0x2984, 0x39E5, 0x2964, 0x2123, 0x2103, 0x2103, 0x2103, 0x4207, 0x94B2, 0xBDF7, 0xC638, 0xA554, 0x740F, 
        0x73CE, 0x83EE, 0xA532, 0xB5B5, 0xCE78, 0xC637, 0x6BAC, 0x29E4, 0x21A3, 0x2183, 0x29A3, 0x31E4, 0x29C4, 0x2183, 0x1923, 0x1902, 0x2164, 0x31E5, 0x29A4, 0x1102, 0x2143, 0x1923, 0x1103, 0x1903, 0x1903, 0x10E3, 0x18E3, 0x10E2, 0x1903, 0x1923, 
        0x10A1, 0x2163, 0x31C4, 0x29A3, 0x3A24, 0x3A23, 0x4264, 0x4264, 0x3A24, 0x2982, 0x3A04, 0x29A2, 0x31E3, 0x2982, 0x3A24, 0x3A44, 0x2162, 0x29C3, 0x31E3, 0x31E3, 0x29C3, 0x31E3, 0x31E3, 0x1942, 0x1102, 0x08A1, 0x10C1, 0x2143, 0x2162,
  0x1942, 0x2162, 0x2183, 0x1922, 0x1942, 0x4A88, 0x1902, 0x10A1, 0x0880, 0x0860, 0x10A1, 0x10A1, 0x2142, 0x29C3, 0x29C3, 0x1902, 0x0860, 0x0860, 0x0860, 0x0861, 0x0861, 0x0840, 0x08A1, 0x10E2, 0x10C1, 0x08A0, 0x1902, 0x0881, 0x0881, 0x10C2, 0x0861, 
        0x0860, 0x0860, 0x0881, 0x10A1, 0x08A1, 0x10C1, 0x08A1, 0x1922, 0x2182, 0x1941, 0x29C2, 0x31E3, 0x29A2, 0x2162, 0x0860, 0x08C1, 0x1922, 0x2183, 0x2163, 0x18E1, 0x1921, 0x1942, 0x1942, 0x2183, 0x1922, 0x10E1, 0x1922, 0x1902, 0x0881, 0x0881, 
        0x08A1, 0x0860, 0x0860, 0x0860, 0x0861, 0x0881, 0x08A1, 0x0881, 0x0860, 0x08A1, 0x0881, 0x0881, 0x10C1, 0x1922, 0x1901, 0x10A1, 0x0881, 0x0881, 0x10C2, 0x10C1, 0x10E1, 0x1942, 0x10C1, 0x0881, 0x10C1, 0x2122, 0x1902, 0x10A1, 0x0861, 0x0881, 
        0x0881, 0x10C1, 0x10A1, 0x10A1, 0x08A1, 0x08A1, 0x0881, 0x1081, 0x0881, 0x0881, 0x10C1, 0x10A1, 0x0840, 0x0881, 0x10A1, 0x10E2, 0x1922, 0x2143, 0x10E1, 0x1922, 0x2142, 0x2122, 0x2122, 0x2121, 0x29C3, 0x2141, 0x1901, 0x1902, 0x18C1, 0x10A1, 
        0x0881, 0x10C1, 0x2142, 0x2963, 0x2141, 0x31C3, 0x2962, 0x2982, 0x4224, 0x39E3, 0x2141, 0x29C3, 0x1921, 0x0860, 0x10A1, 0x1942, 0x2182, 0x2162, 0x29C3, 0x1942, 0x1922, 0x1902, 0x10C1, 0x6B8B, 0x29A4, 0x1922, 0x2162, 0x29C3, 0x31E3, 0x31C3, 
        0x4245, 0x3162, 0x2942, 0x2922, 0x2102, 0x2122, 0x2942, 0x2942, 0x2942, 0x2962, 0x2962, 0x2942, 0x2102, 0x2942, 0x31A3, 0x2962, 0x2122, 0x18C1, 0x2101, 0x2122, 0x18E1, 0x10A1, 0x2122, 0x5B4A, 0x7C2E, 0x7C0E, 0x5AE8, 0x31C2, 0x31C3, 0x31E3, 
        0x29A2, 0x2162, 0x2982, 0x2142, 0x29A3, 0x2962, 0x2963, 0x2162, 0x18E1, 0x18E1, 0x2163, 0x2162, 0x2182, 0x2142, 0x1922, 0x2183, 0x2162, 0x1922, 0x1922, 0x2183, 0x3A44, 0x3A23, 0x29A2, 0x2982, 0x29C3, 0x2142, 0x10C1, 0x10E1, 0x10E1, 0x1922, 
        0x2122, 0x1922, 0x10E1, 0x1922, 0x1922, 0x10C1, 0x3206, 0x2184, 0x1103, 0x1923, 0x1123, 0x1944, 0x1924, 0x1944, 0x1944, 0x1944, 0x1944, 0x2164, 0x3A26, 0x2164, 0x1944, 0x1944, 0x1944, 0x1964, 0x2164, 0x1964, 0x2185, 0x1964, 0x1985, 0x21C5, 
        0x3A88, 0x3206, 0x29A5, 0x21A5, 0x2185, 0x1964, 0x1964, 0x4267, 0x3206, 0x2185, 0x2185, 0x21A5, 0x29A5, 0x2185, 0x31C5, 0x10C1, 0x2162, 0x29A2, 0x2161, 0x2982, 0x3A24, 0x31E2, 0x29C2, 0x3A23, 0x3A23, 0x31C2, 0x29A2, 0x3203, 0x4284, 0x4264, 
        0x4264, 0x31E3, 0x29A2, 0x3A44, 0x3A02, 0x4AA4, 0x4AA5, 0x4A84, 0x4243, 0x31E3, 0x31C2, 0x31A2, 0x31C3, 0x2962, 0x2982, 0x31C3, 0x31C3, 0x2962, 0x2942, 0x2982, 0x31A3, 0x31C3, 0x2142, 0x1921, 0x3204, 0x3A24, 0x31C3, 0x2983, 0x10E1, 0x10E1, 
        0x2162, 0x2142, 0x10C1, 0x4265, 0x4AC5, 0x29A2, 0x29C2, 0x4264, 0x31C2, 0x2141, 0x3203, 0x29C3, 0x1901, 0x10E1, 0x1102, 0x10E2, 0x18E2, 0x08A1, 0x08A1, 0x10E2, 0x1902, 0x1902, 0x1902, 0x10C1, 0x1922, 0x29A3, 0x2163, 0x2163, 0x1901, 0x1922, 
        0x3A24, 0x29C3, 0x3203, 0x31E3, 0x31E3, 0x3A44, 0x4284, 0x4264, 0x3223, 0x3203, 0x31E3, 0x2182, 0x10C1, 0x1922, 0x10E2, 0x10C1, 0x10C1, 0x1101, 0x29C3, 0x3A24, 0x3223, 0x29E3, 0x2162, 0x3203, 0x3A24, 0x21A2, 0x29C3, 0x29A3, 0x2183, 0x1102, 
        0x10C1, 0x10E2, 0x1902, 0x1902, 0x08A1, 0x10A1, 0x1902, 0x2183, 0x31E4, 0x3A44, 0x3203, 0x2182, 0x3A23, 0x3A44, 0x4AA5, 0x4A85, 0x3A43, 0x4AA5, 0x4AA4, 0x4AA4, 0x4284, 0x3A23, 0x4285, 0x3A44, 0x29C2, 0x2162, 0x29A2, 0x29E3, 0x10C1, 0x10C1, 
        0x1942, 0x1942, 0x29A2, 0x3204, 0x3204, 0x29C3, 0x31C4, 0x31C4, 0x29C3, 0x29A3, 0x29A4, 0x2984, 0x2143, 0x2103, 0x18E3, 0x2144, 0x3184, 0x2943, 0x4206, 0x2964, 0x2103, 0x2124, 0x18E3, 0x2944, 0x2924, 0x31A6, 0x3A28, 0x6B6D, 0x7C30, 0x8471, 
        0x7C0F, 0x7BEE, 0xA553, 0xBDF6, 0xC637, 0xA533, 0x846F, 0x3A66, 0x2163, 0x1943, 0x2984, 0x2163, 0x2163, 0x1923, 0x2163, 0x2183, 0x3A46, 0x5B2A, 0x4267, 0x1943, 0x2144, 0x1944, 0x1103, 0x1923, 0x1903, 0x10E2, 0x10C2, 0x10C2, 0x2983, 0x3A04, 
        0x2982, 0x3A24, 0x3A43, 0x4264, 0x4264, 0x3A23, 0x4284, 0x3203, 0x31C2, 0x3A23, 0x4AA5, 0x4AA5, 0x4264, 0x3203, 0x3A23, 0x3A44, 0x3A64, 0x3A44, 0x29A2, 0x3A24, 0x3A24, 0x29C3, 0x29E3, 0x29C3, 0x2183, 0x2183, 0x1102, 0x1102, 0x1902,
  0x2162, 0x2162, 0x1922, 0x2163, 0x2183, 0x4A88, 0x1902, 0x10A1, 0x0881, 0x0881, 0x0881, 0x10A1, 0x10C1, 0x10E1, 0x10E1, 0x0881, 0x0861, 0x0860, 0x0840, 0x0840, 0x0881, 0x0881, 0x0881, 0x0860, 0x10A1, 0x1902, 0x10C1, 0x0861, 0x08A1, 0x0881, 0x0840, 
        0x0840, 0x0861, 0x0861, 0x0881, 0x0881, 0x08A1, 0x0881, 0x10A1, 0x29A3, 0x1942, 0x2162, 0x31C3, 0x29C3, 0x29A3, 0x10C1, 0x0040, 0x08A1, 0x0881, 0x10A1, 0x1901, 0x2162, 0x2162, 0x1942, 0x2162, 0x1922, 0x1922, 0x2142, 0x1922, 0x10E1, 0x1902, 
        0x10C1, 0x08A1, 0x0861, 0x0861, 0x0860, 0x0881, 0x08A1, 0x10A1, 0x08A1, 0x0881, 0x0881, 0x10E1, 0x10E1, 0x1901, 0x1942, 0x1921, 0x1902, 0x10E2, 0x10E1, 0x10C1, 0x1101, 0x1921, 0x1922, 0x10A1, 0x1081, 0x18E1, 0x2142, 0x10E1, 0x08A1, 0x08A1, 
        0x10C1, 0x10C1, 0x10A1, 0x08A1, 0x10C1, 0x10C1, 0x0881, 0x0881, 0x10A1, 0x10A1, 0x10E2, 0x08A1, 0x0861, 0x0881, 0x10A1, 0x10C1, 0x1902, 0x10C1, 0x10A1, 0x10E1, 0x1922, 0x18E1, 0x18E1, 0x2122, 0x2142, 0x1921, 0x2162, 0x2162, 0x1901, 0x2102, 
        0x18C1, 0x18E2, 0x1902, 0x2142, 0x31E3, 0x31C3, 0x31A3, 0x31A3, 0x31C3, 0x31A2, 0x2962, 0x2162, 0x29A3, 0x1922, 0x10A1, 0x1902, 0x29A3, 0x2162, 0x2162, 0x29A3, 0x29C3, 0x29A3, 0x10C1, 0x5B2A, 0x3A05, 0x08A0, 0x10C1, 0x2162, 0x29A2, 0x2141, 
        0x31E4, 0x2122, 0x18E1, 0x2102, 0x2102, 0x18E2, 0x2122, 0x2942, 0x2122, 0x2102, 0x2102, 0x2102, 0x18E1, 0x1901, 0x2102, 0x2102, 0x2122, 0x2101, 0x2142, 0x2962, 0x2143, 0x2984, 0x31C5, 0x4A88, 0x3A05, 0x31C4, 0x31C4, 0x3A04, 0x31C3, 0x2141, 
        0x2142, 0x18E1, 0x18E1, 0x1901, 0x2962, 0x2983, 0x2122, 0x1922, 0x2142, 0x2122, 0x18E1, 0x1922, 0x2162, 0x1941, 0x2141, 0x2162, 0x1942, 0x1922, 0x1922, 0x2182, 0x2182, 0x3A24, 0x3A24, 0x2982, 0x29C3, 0x31E3, 0x1901, 0x10C1, 0x10C1, 0x10C1, 
        0x1901, 0x10C1, 0x10C1, 0x1902, 0x2184, 0x3246, 0x42E9, 0x3AA8, 0x3287, 0x3288, 0x3288, 0x3A88, 0x3A88, 0x3A88, 0x3AA8, 0x42C9, 0x42E9, 0x4AE9, 0x4B29, 0x4B09, 0x4B2A, 0x4B2A, 0x4B2A, 0x4B4A, 0x536B, 0x534A, 0x536A, 0x536B, 0x4B6A, 0x4B6A, 
        0x538B, 0x4AE9, 0x42A8, 0x42C9, 0x42C9, 0x42A9, 0x3A68, 0x3A67, 0x4288, 0x3206, 0x2A06, 0x29E6, 0x29C6, 0x2164, 0x31E5, 0x29C3, 0x3A03, 0x4244, 0x31C3, 0x31E3, 0x3203, 0x3A24, 0x31E2, 0x31E3, 0x3A24, 0x31E3, 0x2182, 0x2181, 0x4244, 0x52C5, 
        0x31E3, 0x10A0, 0x10C0, 0x29A2, 0x3A43, 0x4264, 0x4264, 0x4244, 0x31E2, 0x31A2, 0x31C3, 0x31A3, 0x29A2, 0x2962, 0x2982, 0x2982, 0x2142, 0x1901, 0x2142, 0x2962, 0x2122, 0x2102, 0x1902, 0x1922, 0x2142, 0x2122, 0x2142, 0x1901, 0x1922, 0x29C3, 
        0x2142, 0x18E1, 0x10C1, 0x2983, 0x4244, 0x2982, 0x1941, 0x4284, 0x3A23, 0x31E3, 0x29A2, 0x31E4, 0x18E2, 0x08A1, 0x10C1, 0x10E2, 0x10C2, 0x10C2, 0x10C1, 0x10E2, 0x10E2, 0x10C1, 0x10E2, 0x10C1, 0x10C1, 0x1922, 0x29A3, 0x31E4, 0x31A3, 0x1901, 
        0x29A3, 0x29E3, 0x29C2, 0x29A2, 0x2142, 0x2182, 0x29E3, 0x3203, 0x3A24, 0x3203, 0x3203, 0x3204, 0x2163, 0x1922, 0x1102, 0x10A1, 0x0881, 0x2183, 0x3A24, 0x3224, 0x3A24, 0x31E3, 0x29C3, 0x29C3, 0x3A44, 0x4285, 0x3204, 0x2162, 0x1922, 0x10E1, 
        0x08C1, 0x10E2, 0x1922, 0x10E2, 0x1102, 0x1922, 0x1922, 0x1922, 0x29A3, 0x4264, 0x52E6, 0x4264, 0x3A44, 0x29C3, 0x31E3, 0x3A44, 0x3203, 0x29C2, 0x42A5, 0x3A63, 0x42A5, 0x4284, 0x4264, 0x3A64, 0x3A44, 0x3224, 0x29A2, 0x29E3, 0x1902, 0x0881, 
        0x08A1, 0x1922, 0x29A2, 0x29C3, 0x31E4, 0x3A04, 0x31E4, 0x31E4, 0x29A3, 0x2983, 0x31A4, 0x2984, 0x2984, 0x2143, 0x2143, 0x2984, 0x2964, 0x31A5, 0x41E6, 0x2944, 0x2123, 0x2944, 0x2103, 0x2103, 0x20E3, 0x2103, 0x2103, 0x31C6, 0x632C, 0x9D13, 
        0x94D2, 0x8C50, 0xAD53, 0xB5B5, 0xBDF6, 0xB5B5, 0xB5B5, 0x52E9, 0x1942, 0x2143, 0x2984, 0x2163, 0x2163, 0x2163, 0x2183, 0x1943, 0x1922, 0x2163, 0x1942, 0x1922, 0x3A07, 0x2164, 0x10E2, 0x1923, 0x10C2, 0x18E2, 0x2983, 0x3A04, 0x3A24, 0x3A23, 
        0x3A44, 0x4284, 0x3A22, 0x4264, 0x4284, 0x3202, 0x29C2, 0x3203, 0x29C2, 0x4264, 0x4AA5, 0x4AA4, 0x4AA4, 0x4AC5, 0x3A23, 0x3203, 0x3223, 0x4264, 0x4AA5, 0x52E5, 0x4AC5, 0x29C3, 0x29A3, 0x3204, 0x3224, 0x29C3, 0x1122, 0x08C1, 0x10E1,
  0x1921, 0x1902, 0x10A1, 0x10E1, 0x1922, 0x4A88, 0x10A1, 0x0881, 0x0861, 0x08A1, 0x10A1, 0x10C1, 0x10C1, 0x10A1, 0x0881, 0x10C1, 0x08A1, 0x08A1, 0x0881, 0x0881, 0x10C1, 0x10A1, 0x1081, 0x10A1, 0x10C1, 0x10C1, 0x10A1, 0x0861, 0x0840, 0x0840, 0x0020, 
        0x0040, 0x0840, 0x0860, 0x10A1, 0x10E2, 0x08A1, 0x0861, 0x0861, 0x10C1, 0x18E1, 0x1901, 0x1922, 0x1902, 0x0881, 0x0881, 0x0881, 0x10A1, 0x10C1, 0x08A1, 0x10E1, 0x2142, 0x1922, 0x1901, 0x1901, 0x2162, 0x2142, 0x2142, 0x1942, 0x2183, 0x29A3, 
        0x1922, 0x1922, 0x29C3, 0x29C4, 0x10C2, 0x0860, 0x0881, 0x0881, 0x10C1, 0x10C1, 0x10C1, 0x10C1, 0x10E1, 0x1922, 0x1942, 0x1921, 0x1101, 0x10A1, 0x10C1, 0x1922, 0x1102, 0x1922, 0x2142, 0x10E1, 0x10A1, 0x1922, 0x1922, 0x10E2, 0x08A1, 0x0881, 
        0x08A1, 0x08C1, 0x0881, 0x0881, 0x08A1, 0x0881, 0x0881, 0x1081, 0x0881, 0x10C1, 0x0881, 0x0881, 0x0881, 0x0881, 0x08A1, 0x10C1, 0x10A1, 0x0881, 0x0881, 0x10E1, 0x1902, 0x18E1, 0x18E1, 0x2102, 0x18C1, 0x18E1, 0x2142, 0x29A2, 0x2982, 0x2962, 
        0x2162, 0x2963, 0x2962, 0x2142, 0x2982, 0x31C3, 0x2982, 0x2982, 0x2982, 0x2982, 0x31C3, 0x3A04, 0x2983, 0x1922, 0x10E2, 0x10C1, 0x1922, 0x29A3, 0x2142, 0x2182, 0x31C3, 0x3204, 0x2142, 0x52E9, 0x4266, 0x1921, 0x1942, 0x2142, 0x2982, 0x1901, 
        0x2122, 0x18E1, 0x18C1, 0x18E1, 0x18E1, 0x18E2, 0x18E2, 0x2122, 0x2942, 0x2922, 0x20E2, 0x20E2, 0x18E1, 0x18C1, 0x2122, 0x2102, 0x2142, 0x39E4, 0x3A25, 0x39E5, 0x4246, 0x4A67, 0x4247, 0x2122, 0x1901, 0x2142, 0x1901, 0x2162, 0x1922, 0x1922, 
        0x2142, 0x2983, 0x29A3, 0x2162, 0x2962, 0x2962, 0x18E2, 0x1922, 0x2982, 0x2982, 0x2162, 0x29A2, 0x2181, 0x1921, 0x3A44, 0x3203, 0x2182, 0x2142, 0x1942, 0x2982, 0x2162, 0x3203, 0x3A44, 0x2161, 0x2182, 0x29E3, 0x29C3, 0x2162, 0x2142, 0x1922, 
        0x29A3, 0x1922, 0x2142, 0x3205, 0x3A46, 0x3A46, 0x3A46, 0x3A26, 0x3A06, 0x3A06, 0x3A06, 0x4206, 0x39E6, 0x39E5, 0x39E5, 0x39E5, 0x39C5, 0x39C5, 0x39C5, 0x39C5, 0x39A4, 0x41C4, 0x41C5, 0x39C5, 0x41A5, 0x39A4, 0x41A4, 0x41A4, 0x41A4, 0x41A4, 
        0x4184, 0x49A5, 0x41A4, 0x4184, 0x41C5, 0x41E6, 0x4206, 0x4A47, 0x4A67, 0x4288, 0x4AA8, 0x4AC9, 0x4AC9, 0x4AE9, 0x4B0A, 0x5B8A, 0x4AE7, 0x3A64, 0x4264, 0x31C2, 0x29C2, 0x3203, 0x4244, 0x29A2, 0x3203, 0x29C3, 0x2982, 0x2182, 0x29C3, 0x3A23, 
        0x29C3, 0x1922, 0x4A88, 0x5309, 0x3A65, 0x3203, 0x3A44, 0x3A03, 0x29A2, 0x29A2, 0x29A2, 0x2962, 0x2982, 0x2142, 0x2142, 0x2142, 0x2122, 0x1901, 0x1901, 0x2102, 0x10C1, 0x10E2, 0x1922, 0x1902, 0x10C1, 0x10C1, 0x1902, 0x1942, 0x29A3, 0x3A45, 
        0x3A24, 0x2142, 0x1922, 0x1102, 0x10E1, 0x1921, 0x2141, 0x3A23, 0x3A44, 0x3A44, 0x29C3, 0x2182, 0x1902, 0x1102, 0x1943, 0x1922, 0x1942, 0x2163, 0x1942, 0x10E1, 0x10E1, 0x10C1, 0x10C1, 0x18E2, 0x10C1, 0x10E2, 0x2142, 0x3A04, 0x3A24, 0x31E3, 
        0x29A3, 0x29C3, 0x29C3, 0x29A2, 0x1922, 0x2162, 0x29E3, 0x29C2, 0x3A44, 0x3A03, 0x31E3, 0x3A23, 0x3A24, 0x10E1, 0x2163, 0x1922, 0x10C1, 0x29C3, 0x29C3, 0x29C3, 0x3203, 0x29E3, 0x3203, 0x3203, 0x2182, 0x3204, 0x3204, 0x1962, 0x1102, 0x10C1, 
        0x08C1, 0x10E2, 0x10E2, 0x1902, 0x1942, 0x29A3, 0x2142, 0x10E1, 0x2983, 0x29A2, 0x31E3, 0x29C3, 0x29A3, 0x2183, 0x29A3, 0x2162, 0x2182, 0x29C3, 0x29A2, 0x3203, 0x3A44, 0x3A44, 0x3203, 0x3203, 0x29E3, 0x3203, 0x3203, 0x2182, 0x1942, 0x1102, 
        0x10C1, 0x1922, 0x2182, 0x29A3, 0x31C4, 0x3A05, 0x3A04, 0x31C4, 0x3A04, 0x31E5, 0x3205, 0x29A4, 0x2183, 0x2163, 0x2984, 0x31C5, 0x2964, 0x2984, 0x3185, 0x2924, 0x2944, 0x2964, 0x2944, 0x2103, 0x18E3, 0x18E2, 0x18E3, 0x2965, 0x31A6, 0x632C, 
        0x94D2, 0x9CF2, 0xAD94, 0xB5D5, 0xBDF6, 0xBDD6, 0xC617, 0x6BCD, 0x2163, 0x2183, 0x2984, 0x2183, 0x2163, 0x1942, 0x1102, 0x1102, 0x2184, 0x3A26, 0x1122, 0x1102, 0x2164, 0x1944, 0x1923, 0x1903, 0x10C2, 0x2163, 0x4264, 0x3A44, 0x29C2, 0x29A2, 
        0x29A2, 0x3203, 0x3A23, 0x3A43, 0x4284, 0x3A43, 0x4284, 0x3A64, 0x3203, 0x4264, 0x3A23, 0x3202, 0x3A43, 0x4AA4, 0x4AC4, 0x4284, 0x3203, 0x3A64, 0x4284, 0x4AA4, 0x52E4, 0x4284, 0x3223, 0x29C2, 0x29E3, 0x2183, 0x1102, 0x08C1, 0x10E1,
  0x1902, 0x10C1, 0x10C1, 0x0880, 0x2123, 0x4A88, 0x10A1, 0x0881, 0x0881, 0x0881, 0x10A1, 0x10C1, 0x10C1, 0x0880, 0x0881, 0x0881, 0x0881, 0x10A1, 0x10C1, 0x0881, 0x0860, 0x0860, 0x0860, 0x0860, 0x0881, 0x10A1, 0x0860, 0x0880, 0x0881, 0x0881, 0x0861, 
        0x0840, 0x0841, 0x0861, 0x0861, 0x10C1, 0x10E2, 0x0861, 0x0840, 0x0860, 0x0880, 0x0881, 0x10C1, 0x08A1, 0x0861, 0x0881, 0x10C1, 0x0881, 0x10C1, 0x08A1, 0x08A1, 0x1901, 0x2162, 0x1922, 0x10C1, 0x10E1, 0x10E1, 0x1942, 0x2162, 0x1922, 0x1942, 
        0x2183, 0x2182, 0x31E3, 0x29C3, 0x18E2, 0x0860, 0x0881, 0x08A1, 0x08A1, 0x10E1, 0x1922, 0x10E2, 0x10C1, 0x1922, 0x1922, 0x1921, 0x2142, 0x1902, 0x08A1, 0x10C1, 0x10A1, 0x10E1, 0x2142, 0x1922, 0x10C1, 0x10E1, 0x18E2, 0x0881, 0x0861, 0x0881, 
        0x0881, 0x08A1, 0x0881, 0x0881, 0x0881, 0x0881, 0x10C1, 0x10C1, 0x08A1, 0x08A1, 0x10C1, 0x10E2, 0x08A1, 0x0860, 0x0881, 0x10A1, 0x10A1, 0x10A1, 0x10A1, 0x10C1, 0x10C1, 0x1902, 0x18E1, 0x18E1, 0x18E1, 0x1901, 0x2142, 0x2962, 0x2982, 0x29A2, 
        0x31A2, 0x2982, 0x29A2, 0x31C2, 0x2121, 0x2121, 0x1921, 0x29A2, 0x2982, 0x1901, 0x18E1, 0x2122, 0x10C1, 0x10A1, 0x0881, 0x10A1, 0x10C1, 0x2142, 0x29A3, 0x1942, 0x2142, 0x29A3, 0x1941, 0x5B29, 0x4A87, 0x31E3, 0x31C3, 0x2982, 0x31C3, 0x31C3, 
        0x2942, 0x2122, 0x2102, 0x2102, 0x2963, 0x2963, 0x1081, 0x18C1, 0x2942, 0x2942, 0x2963, 0x2922, 0x2122, 0x18E1, 0x2142, 0x2963, 0x39E5, 0x3A05, 0x3A25, 0x2963, 0x4226, 0x52A8, 0x4A88, 0x2963, 0x1901, 0x18E1, 0x18E1, 0x10C1, 0x1901, 0x1921, 
        0x2142, 0x29A3, 0x31E3, 0x31C3, 0x3A04, 0x2122, 0x18E1, 0x2122, 0x2963, 0x2162, 0x2161, 0x29A2, 0x29E2, 0x29E2, 0x3A63, 0x3A63, 0x3203, 0x31C3, 0x2182, 0x1922, 0x10E1, 0x2142, 0x31E3, 0x31E3, 0x2182, 0x21A2, 0x3A24, 0x31C3, 0x1942, 0x1901, 
        0x2162, 0x31E4, 0x1922, 0x1080, 0x28E2, 0x3923, 0x3903, 0x4124, 0x4124, 0x4124, 0x4944, 0x4944, 0x4944, 0x5165, 0x5164, 0x5185, 0x5185, 0x5165, 0x5185, 0x5985, 0x5985, 0x59A5, 0x59A5, 0x61A5, 0x61C6, 0x61C6, 0x61C6, 0x61C6, 0x69C6, 0x69E6, 
        0x69E6, 0x69E6, 0x61E6, 0x61E6, 0x59C6, 0x59C5, 0x59A5, 0x5185, 0x4964, 0x4144, 0x4164, 0x4164, 0x4164, 0x4185, 0x3984, 0x39C5, 0x39E5, 0x4245, 0x4264, 0x3A23, 0x3A23, 0x3A23, 0x3A44, 0x29C2, 0x2982, 0x1942, 0x1922, 0x2142, 0x2182, 0x3203, 
        0x3A23, 0x3A45, 0x638B, 0x742E, 0x742E, 0x52E8, 0x4AA6, 0x31C3, 0x2961, 0x29A2, 0x2962, 0x2162, 0x29A3, 0x2962, 0x2142, 0x2962, 0x2962, 0x2163, 0x2122, 0x2102, 0x2142, 0x1922, 0x10A1, 0x10A1, 0x10C1, 0x10C1, 0x10A1, 0x1902, 0x2182, 0x1901, 
        0x2122, 0x1942, 0x1102, 0x1901, 0x1922, 0x29A3, 0x2982, 0x31C2, 0x31E2, 0x31E2, 0x3A64, 0x3A44, 0x3204, 0x2183, 0x1942, 0x1922, 0x2163, 0x1962, 0x2183, 0x2183, 0x1922, 0x10E1, 0x18E2, 0x1923, 0x1902, 0x1922, 0x2162, 0x29A3, 0x31C3, 0x29A3, 
        0x1942, 0x1942, 0x2182, 0x29A3, 0x29A3, 0x2162, 0x29C3, 0x3203, 0x31E3, 0x31E3, 0x3A44, 0x4244, 0x3A23, 0x29E3, 0x29C3, 0x2983, 0x1902, 0x2183, 0x2162, 0x2162, 0x2182, 0x29C3, 0x31E3, 0x3203, 0x29C3, 0x29C3, 0x29A3, 0x1122, 0x1102, 0x10E2, 
        0x10C1, 0x10E2, 0x08A1, 0x1902, 0x1962, 0x2183, 0x1922, 0x1101, 0x31E3, 0x31E3, 0x2982, 0x29A2, 0x1942, 0x2182, 0x1942, 0x1922, 0x2162, 0x3224, 0x29A2, 0x29A2, 0x3203, 0x3A44, 0x3203, 0x29E3, 0x21A2, 0x29E3, 0x3A44, 0x2182, 0x1942, 0x21A3, 
        0x2182, 0x29A2, 0x29A2, 0x31E3, 0x3A04, 0x3A04, 0x31C4, 0x39E4, 0x4245, 0x3A25, 0x3A25, 0x29A3, 0x29A3, 0x2183, 0x2163, 0x2163, 0x2143, 0x2964, 0x3185, 0x2944, 0x2123, 0x2124, 0x2124, 0x2103, 0x18E3, 0x18C2, 0x18C2, 0x18E3, 0x18C2, 0x39E7, 
        0xAD75, 0xBDF6, 0xAD74, 0xB595, 0xBDF6, 0xB5B5, 0x7C0F, 0x8C90, 0x3205, 0x2983, 0x29A4, 0x2183, 0x2163, 0x1922, 0x1102, 0x1122, 0x2184, 0x3A26, 0x1102, 0x10E2, 0x1103, 0x2144, 0x2165, 0x10E2, 0x2963, 0x3A24, 0x29C2, 0x29A2, 0x29A2, 0x2182, 
        0x1961, 0x29C2, 0x3A43, 0x4264, 0x4AA4, 0x31E3, 0x29C2, 0x3203, 0x3203, 0x31E3, 0x3A23, 0x3A43, 0x3A43, 0x4284, 0x4AA4, 0x42A4, 0x29C2, 0x2182, 0x29E2, 0x3A43, 0x52C5, 0x4AC4, 0x4284, 0x3223, 0x29C2, 0x29C3, 0x2183, 0x1902, 0x1102,
  0x0880, 0x10C1, 0x10C1, 0x0860, 0x10E2, 0x4267, 0x0860, 0x0060, 0x0881, 0x08A1, 0x10A1, 0x10A1, 0x10C1, 0x0860, 0x0861, 0x10A1, 0x10A1, 0x0881, 0x10A1, 0x10C1, 0x10A1, 0x10A1, 0x18E2, 0x18E1, 0x10C1, 0x10C1, 0x10A1, 0x10E1, 0x0881, 0x0840, 0x0841, 
        0x0840, 0x0840, 0x0040, 0x0840, 0x0840, 0x0860, 0x0861, 0x0860, 0x0861, 0x08A1, 0x10A1, 0x0881, 0x0881, 0x0860, 0x08A1, 0x10C1, 0x10C1, 0x08A1, 0x10C1, 0x1922, 0x10E1, 0x1942, 0x1901, 0x10C1, 0x10C1, 0x0860, 0x10C1, 0x1102, 0x10E1, 0x1901, 
        0x2142, 0x1922, 0x29A3, 0x1922, 0x0840, 0x0881, 0x0880, 0x0881, 0x10A1, 0x08A1, 0x10C1, 0x10E2, 0x10E2, 0x1922, 0x1921, 0x1922, 0x2162, 0x2142, 0x10A1, 0x0881, 0x0881, 0x0881, 0x10C1, 0x1942, 0x1922, 0x10C1, 0x0861, 0x0861, 0x0861, 0x0861, 
        0x0881, 0x10A1, 0x10A1, 0x0881, 0x10C1, 0x10C1, 0x10C1, 0x10C1, 0x08A1, 0x08A1, 0x10C1, 0x10C1, 0x10C1, 0x0861, 0x0861, 0x08A1, 0x10A1, 0x10C1, 0x10C1, 0x10C1, 0x10C1, 0x10E1, 0x10E1, 0x18E1, 0x18E1, 0x18E1, 0x1901, 0x1921, 0x2142, 0x2961, 
        0x2982, 0x2962, 0x2982, 0x3A03, 0x39E3, 0x2141, 0x2962, 0x31C2, 0x3A03, 0x2942, 0x0860, 0x0840, 0x0861, 0x0861, 0x1081, 0x1922, 0x2142, 0x1922, 0x2143, 0x10A1, 0x10E1, 0x29C4, 0x29E3, 0x5B49, 0x4266, 0x2141, 0x29A2, 0x3A04, 0x39C3, 0x3A03, 
        0x4203, 0x2962, 0x2142, 0x2121, 0x39E4, 0x39E4, 0x2122, 0x18C1, 0x2102, 0x2922, 0x3183, 0x2922, 0x2122, 0x2122, 0x2122, 0x39E5, 0x2963, 0x2964, 0x4267, 0x31C5, 0x18C1, 0x2143, 0x2122, 0x2163, 0x2122, 0x10A1, 0x10C1, 0x10C1, 0x1901, 0x2962, 
        0x2122, 0x2982, 0x31E3, 0x3A03, 0x3A03, 0x2142, 0x10C1, 0x10C1, 0x10E1, 0x08A0, 0x10E1, 0x2181, 0x21A2, 0x21A1, 0x2181, 0x3222, 0x42A3, 0x29C2, 0x1901, 0x1921, 0x1901, 0x2982, 0x2982, 0x29A3, 0x2162, 0x2162, 0x3203, 0x3A24, 0x2162, 0x10C1, 
        0x1922, 0x2183, 0x10E1, 0x0860, 0x3923, 0x59A5, 0x59A5, 0x59A6, 0x59C6, 0x61A6, 0x61C6, 0x61C6, 0x61E6, 0x61E6, 0x69E6, 0x69E6, 0x69E7, 0x69E7, 0x6A07, 0x7207, 0x7227, 0x7227, 0x7227, 0x7207, 0x7227, 0x7207, 0x7227, 0x7207, 0x7A07, 0x7A07, 
        0x7A07, 0x8268, 0x8A89, 0x8AA9, 0x8288, 0x7A48, 0x7A68, 0x7A68, 0x7A68, 0x7248, 0x6A27, 0x6A06, 0x61C6, 0x61C6, 0x61C6, 0x59A5, 0x49C4, 0x4244, 0x3A23, 0x29A2, 0x3A44, 0x31E3, 0x29C2, 0x3203, 0x31E3, 0x2182, 0x2142, 0x1901, 0x2182, 0x3203, 
        0x3A44, 0x31E3, 0x31E3, 0x3205, 0x29C3, 0x4265, 0x6369, 0x52E8, 0x4A86, 0x3A05, 0x2962, 0x1901, 0x2142, 0x2142, 0x2122, 0x2142, 0x2983, 0x2122, 0x18E1, 0x2122, 0x2963, 0x10A1, 0x10A1, 0x2122, 0x31E4, 0x31A3, 0x10C1, 0x2963, 0x29A3, 0x10C1, 
        0x10A1, 0x08A1, 0x1101, 0x3A45, 0x4265, 0x31E3, 0x29A2, 0x2141, 0x3A03, 0x4244, 0x5306, 0x4AC5, 0x3A43, 0x2162, 0x1942, 0x1942, 0x1942, 0x29A3, 0x2183, 0x29C3, 0x1942, 0x1922, 0x1902, 0x1942, 0x2142, 0x2163, 0x2162, 0x29A3, 0x2983, 0x2182, 
        0x2183, 0x2983, 0x2162, 0x1942, 0x1922, 0x2162, 0x1942, 0x31E3, 0x29A2, 0x2982, 0x4264, 0x4264, 0x4244, 0x29E3, 0x29E3, 0x29C3, 0x21A3, 0x2183, 0x2183, 0x2162, 0x2162, 0x1921, 0x29C3, 0x3A44, 0x3204, 0x2183, 0x1102, 0x10C2, 0x08C1, 0x10A1, 
        0x0861, 0x10E2, 0x10E1, 0x1902, 0x1922, 0x2162, 0x2183, 0x2183, 0x3A44, 0x3A44, 0x3A24, 0x29C3, 0x2162, 0x1962, 0x1922, 0x10E1, 0x2142, 0x3A24, 0x3A64, 0x2182, 0x29A2, 0x3A64, 0x3A44, 0x29E3, 0x29C3, 0x3204, 0x3A24, 0x29C3, 0x2162, 0x29C3, 
        0x29C3, 0x29E3, 0x31E3, 0x3223, 0x3A24, 0x3204, 0x31C4, 0x39E4, 0x29C3, 0x29C3, 0x3204, 0x29C3, 0x29C4, 0x31E4, 0x31E4, 0x2983, 0x2163, 0x2143, 0x39A5, 0x2964, 0x18C2, 0x18C2, 0x18E3, 0x18E3, 0x18E2, 0x18C2, 0x18C2, 0x18C2, 0x18E3, 0x2945, 
        0x7C0F, 0xA554, 0x6B6C, 0x6B8D, 0x842F, 0x9D12, 0x530A, 0x52E9, 0x3A06, 0x2163, 0x2984, 0x2123, 0x1923, 0x1922, 0x1102, 0x10E2, 0x08A1, 0x08C2, 0x10C2, 0x08C2, 0x10E2, 0x1903, 0x18E3, 0x2143, 0x3204, 0x3203, 0x2142, 0x2142, 0x29C3, 0x31E3, 
        0x29C2, 0x2982, 0x4264, 0x3A24, 0x3203, 0x29C2, 0x2182, 0x2182, 0x2182, 0x2162, 0x31E3, 0x3A44, 0x31E2, 0x31E2, 0x4284, 0x4AA5, 0x29A2, 0x1121, 0x31E3, 0x4264, 0x3A43, 0x4AA4, 0x4AC5, 0x4AA4, 0x4AA4, 0x4264, 0x4264, 0x29A3, 0x1942,
  0x1902, 0x2963, 0x2143, 0x08A1, 0x2144, 0x4247, 0x0860, 0x08A1, 0x10C1, 0x0880, 0x0881, 0x0880, 0x10A1, 0x0840, 0x0040, 0x0860, 0x10A1, 0x08A1, 0x10C1, 0x10E1, 0x10C1, 0x1081, 0x0881, 0x18E2, 0x2142, 0x1902, 0x10E1, 0x10C1, 0x0840, 0x0840, 0x0860, 
        0x0861, 0x0861, 0x0840, 0x0840, 0x0840, 0x0840, 0x0840, 0x0881, 0x10C1, 0x10C1, 0x18E2, 0x10C1, 0x0881, 0x08A1, 0x0881, 0x10A1, 0x18E2, 0x10E1, 0x1902, 0x1921, 0x2142, 0x1922, 0x1922, 0x2142, 0x1942, 0x10E1, 0x1902, 0x10E1, 0x10C1, 0x1922, 
        0x2122, 0x10C1, 0x1922, 0x2143, 0x0861, 0x08A1, 0x10E2, 0x08A1, 0x08A1, 0x10C1, 0x08A1, 0x10C1, 0x08E1, 0x1902, 0x1922, 0x10E1, 0x1942, 0x1902, 0x10C1, 0x10A1, 0x10A1, 0x0861, 0x0861, 0x10C1, 0x10C1, 0x10C1, 0x10C1, 0x0881, 0x0881, 0x0881, 
        0x08A1, 0x08A1, 0x08A1, 0x08A1, 0x08A1, 0x10A1, 0x08A1, 0x10C1, 0x10C1, 0x10A1, 0x10C1, 0x10E1, 0x10C1, 0x0881, 0x0881, 0x0861, 0x10A1, 0x0881, 0x08A1, 0x10E1, 0x10E1, 0x10E1, 0x1902, 0x1922, 0x10C1, 0x10A1, 0x18C1, 0x1922, 0x2121, 0x1921, 
        0x2141, 0x2982, 0x2962, 0x2982, 0x29A2, 0x29A2, 0x31C2, 0x3A03, 0x3A03, 0x31C2, 0x2142, 0x18C1, 0x10A1, 0x10A1, 0x1081, 0x10C1, 0x2142, 0x1922, 0x10C2, 0x0860, 0x0861, 0x0881, 0x18E2, 0x52C9, 0x3A05, 0x10E1, 0x2182, 0x31E3, 0x4224, 0x4204, 
        0x4203, 0x39E3, 0x4204, 0x39A3, 0x2962, 0x2942, 0x2983, 0x18E1, 0x18C1, 0x18E1, 0x2102, 0x18C1, 0x18E2, 0x2102, 0x2122, 0x31E5, 0x31A4, 0x2984, 0x2122, 0x18E1, 0x18E1, 0x1902, 0x18E1, 0x2122, 0x2142, 0x1902, 0x1902, 0x1902, 0x2142, 0x2983, 
        0x2162, 0x2142, 0x2142, 0x29A2, 0x39E3, 0x31C3, 0x1921, 0x18E1, 0x10C1, 0x10A1, 0x10A1, 0x1921, 0x2181, 0x2182, 0x2182, 0x3203, 0x3A23, 0x4264, 0x3A04, 0x2142, 0x1902, 0x2142, 0x2142, 0x2982, 0x29A3, 0x2182, 0x2182, 0x3A24, 0x2162, 0x10E1, 
        0x1901, 0x2142, 0x1942, 0x10A1, 0x3923, 0x61C6, 0x61C6, 0x61C6, 0x61E6, 0x61C6, 0x69E7, 0x6A07, 0x6A07, 0x6A07, 0x7207, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7207, 0x6A07, 0x69E7, 0x7207, 0x7227, 0x7A27, 0x7A07, 
        0x7A27, 0x8A88, 0x8AA9, 0x8AC9, 0x7A89, 0x8289, 0x8AC9, 0x8AC9, 0x8AC9, 0x8288, 0x8AA9, 0x8AA9, 0x8AA9, 0x8288, 0x8288, 0x8289, 0x5205, 0x2161, 0x3A03, 0x31E3, 0x2982, 0x1901, 0x2162, 0x3203, 0x3224, 0x3A04, 0x2983, 0x1922, 0x2162, 0x29A2, 
        0x31E3, 0x3203, 0x3A23, 0x29C2, 0x3A45, 0x740E, 0x740D, 0x5B4A, 0x4225, 0x4A87, 0x4A67, 0x31C5, 0x10A1, 0x1922, 0x2942, 0x2142, 0x2942, 0x18E2, 0x10A1, 0x1081, 0x1081, 0x10C1, 0x2142, 0x4225, 0x31C3, 0x31A3, 0x2983, 0x2122, 0x1902, 0x10C1, 
        0x29C3, 0x2982, 0x2182, 0x29E3, 0x31E3, 0x3A44, 0x4265, 0x2982, 0x31E3, 0x4284, 0x42A4, 0x4AA4, 0x52E5, 0x3A24, 0x2142, 0x1922, 0x2163, 0x2162, 0x1942, 0x29A3, 0x2162, 0x1942, 0x1922, 0x1922, 0x1922, 0x1922, 0x2183, 0x2183, 0x1922, 0x2183, 
        0x2162, 0x2163, 0x2162, 0x2183, 0x1922, 0x1942, 0x1942, 0x29C3, 0x3A44, 0x3A24, 0x31E3, 0x3A03, 0x4264, 0x29C3, 0x2162, 0x29C3, 0x2183, 0x2162, 0x29A3, 0x2983, 0x1942, 0x1942, 0x2182, 0x3A64, 0x29C3, 0x10E1, 0x08A1, 0x10A2, 0x0881, 0x08A1, 
        0x10C1, 0x1922, 0x2983, 0x29A3, 0x29A3, 0x3A04, 0x3204, 0x29C3, 0x29C3, 0x29A2, 0x3A04, 0x29C3, 0x2162, 0x2183, 0x1942, 0x1922, 0x2142, 0x29C3, 0x3203, 0x29C2, 0x2182, 0x29E3, 0x3A44, 0x3A44, 0x21A3, 0x29C3, 0x29C3, 0x29C3, 0x1922, 0x1901, 
        0x2182, 0x3A24, 0x3A44, 0x3A44, 0x31E3, 0x31E3, 0x31E4, 0x29C3, 0x29A3, 0x2182, 0x29A3, 0x29C3, 0x31E4, 0x29A4, 0x29C4, 0x29C4, 0x29A3, 0x31E5, 0x39E5, 0x2964, 0x10C2, 0x10C2, 0x10C2, 0x18C2, 0x18C3, 0x18E3, 0x18C2, 0x18E3, 0x18E3, 0x18E2, 
        0x31A5, 0x52AA, 0x2985, 0x39E6, 0x39E6, 0x4247, 0x31C5, 0x2984, 0x2984, 0x2964, 0x2143, 0x1902, 0x18E2, 0x18E3, 0x18E2, 0x10C2, 0x08A1, 0x10C1, 0x08A1, 0x10C2, 0x10C2, 0x1903, 0x18E3, 0x2983, 0x29A3, 0x1942, 0x2182, 0x2162, 0x1901, 0x2141, 
        0x3203, 0x3203, 0x29C3, 0x29A2, 0x2161, 0x29C3, 0x29C3, 0x29C2, 0x2182, 0x2162, 0x29C3, 0x29E3, 0x3203, 0x3A43, 0x4284, 0x3A23, 0x29C3, 0x1941, 0x21A2, 0x29E2, 0x3203, 0x3202, 0x4264, 0x4284, 0x3A43, 0x4A84, 0x4A84, 0x31E3, 0x29A3,
  0x6B4B, 0x5247, 0x41C6, 0x41C5, 0x5268, 0x632B, 0x52A9, 0x5268, 0x41C6, 0x2944, 0x31A5, 0x31A5, 0x2964, 0x2985, 0x2964, 0x18C2, 0x18E2, 0x18E2, 0x10C1, 0x1902, 0x18C2, 0x10A1, 0x10A1, 0x18E2, 0x0860, 0x0840, 0x0860, 0x0840, 0x0040, 0x0860, 0x10A1, 
        0x1081, 0x0860, 0x0840, 0x0840, 0x0840, 0x0861, 0x0840, 0x0881, 0x10C1, 0x10C1, 0x10E2, 0x0881, 0x0881, 0x10C1, 0x08C1, 0x10C1, 0x08A1, 0x08A1, 0x10E1, 0x10E1, 0x2183, 0x2122, 0x10C1, 0x10E1, 0x29A3, 0x2162, 0x10E1, 0x10C1, 0x10C1, 0x10C1, 
        0x1902, 0x1902, 0x10C1, 0x08A1, 0x0881, 0x10C1, 0x10C1, 0x10C1, 0x10C1, 0x10C1, 0x0881, 0x08A1, 0x10E1, 0x10E1, 0x10C1, 0x10C1, 0x1922, 0x10C1, 0x18E2, 0x1902, 0x10A1, 0x0861, 0x0860, 0x0861, 0x0881, 0x0881, 0x10C1, 0x10C1, 0x10C1, 0x10A1, 
        0x10A1, 0x08A1, 0x0881, 0x0881, 0x10A1, 0x10E2, 0x10C1, 0x10C1, 0x10C1, 0x08A1, 0x10C1, 0x10E1, 0x10E2, 0x10C2, 0x0881, 0x0861, 0x08A1, 0x0881, 0x0881, 0x10E2, 0x1102, 0x10E1, 0x1902, 0x1922, 0x1902, 0x10C1, 0x18E1, 0x10E1, 0x18E1, 0x18E1, 
        0x18E1, 0x2122, 0x2142, 0x2122, 0x1921, 0x2162, 0x29A2, 0x29A2, 0x29A2, 0x2982, 0x31E3, 0x31C3, 0x2122, 0x2122, 0x18C2, 0x0861, 0x0881, 0x0881, 0x0881, 0x0861, 0x0881, 0x0881, 0x0860, 0x4AA8, 0x3A25, 0x10E1, 0x2162, 0x29A3, 0x2142, 0x2122, 
        0x2122, 0x2102, 0x2102, 0x2942, 0x2942, 0x2962, 0x2982, 0x2963, 0x2983, 0x1902, 0x10C1, 0x18C1, 0x18C1, 0x18C1, 0x2964, 0x3A06, 0x2984, 0x1901, 0x1922, 0x1901, 0x18E1, 0x18E1, 0x2122, 0x2983, 0x2142, 0x1922, 0x18E2, 0x10C1, 0x10E1, 0x1901, 
        0x2122, 0x2162, 0x2962, 0x29A2, 0x31C3, 0x29A2, 0x29A3, 0x29C3, 0x1921, 0x10C1, 0x1901, 0x2141, 0x2182, 0x1942, 0x10E1, 0x1101, 0x2182, 0x2162, 0x31E3, 0x1902, 0x10C1, 0x2142, 0x2983, 0x29C3, 0x2982, 0x1921, 0x2983, 0x1922, 0x10C1, 0x10C1, 
        0x1922, 0x2162, 0x1902, 0x0881, 0x3924, 0x61E6, 0x61E7, 0x61E6, 0x61C6, 0x51C6, 0x3924, 0x3924, 0x61E6, 0x7227, 0x7227, 0x7227, 0x7248, 0x7248, 0x7247, 0x7247, 0x7227, 0x7227, 0x7227, 0x6A48, 0x4185, 0x28E2, 0x4985, 0x7207, 0x7227, 0x8AA9, 
        0x7A27, 0x8A89, 0x932B, 0x6A48, 0x5226, 0x7288, 0x8AC9, 0x8AEA, 0x6A68, 0x6227, 0x7A88, 0x8AC9, 0x8AC9, 0x7268, 0x7A88, 0x92C9, 0x6226, 0x2182, 0x31C3, 0x3A04, 0x2142, 0x0881, 0x1922, 0x2162, 0x29C3, 0x3A24, 0x2182, 0x1901, 0x2162, 0x31E3, 
        0x31E3, 0x3203, 0x3A44, 0x4264, 0x4265, 0x52E9, 0x5B4A, 0x52E9, 0x4A67, 0x4A87, 0x31C4, 0x4A87, 0x31A4, 0x2142, 0x31A3, 0x31A3, 0x2142, 0x10C1, 0x1081, 0x1081, 0x10C1, 0x2162, 0x1922, 0x2162, 0x2983, 0x2962, 0x1922, 0x1902, 0x1902, 0x1922, 
        0x31E3, 0x3A44, 0x31E3, 0x31E3, 0x31E3, 0x3A23, 0x4264, 0x29A3, 0x2162, 0x2982, 0x29C3, 0x3A23, 0x4243, 0x4AA5, 0x3A44, 0x2162, 0x1942, 0x1902, 0x1922, 0x2162, 0x2162, 0x1942, 0x1942, 0x1942, 0x2183, 0x2183, 0x2162, 0x1942, 0x2983, 0x29A3, 
        0x1901, 0x1922, 0x10E1, 0x10E1, 0x2163, 0x2183, 0x1941, 0x29A2, 0x3A24, 0x3203, 0x31C3, 0x3A24, 0x3A24, 0x3A03, 0x2182, 0x2983, 0x2162, 0x2183, 0x31E3, 0x29C3, 0x2162, 0x2183, 0x2183, 0x29A3, 0x29C3, 0x29C3, 0x1922, 0x08A1, 0x0881, 0x10C2, 
        0x10E2, 0x1922, 0x2183, 0x2162, 0x31C3, 0x3A04, 0x31E3, 0x29A3, 0x29A3, 0x31C3, 0x3204, 0x2182, 0x29A3, 0x21A3, 0x1122, 0x1102, 0x1922, 0x2182, 0x3203, 0x3204, 0x2162, 0x1942, 0x29E3, 0x3224, 0x29C3, 0x1942, 0x2183, 0x29E4, 0x21A3, 0x1942, 
        0x29A2, 0x2162, 0x2162, 0x2182, 0x29A3, 0x31E3, 0x29C3, 0x29A3, 0x2182, 0x29A3, 0x29C3, 0x2183, 0x29C4, 0x29A4, 0x29A3, 0x29A3, 0x29A4, 0x31E5, 0x4246, 0x2984, 0x10C2, 0x10C2, 0x10A2, 0x10A2, 0x18C2, 0x18E3, 0x10C2, 0x18E2, 0x2123, 0x2964, 
        0x2964, 0x18E3, 0x2965, 0x2964, 0x2144, 0x1923, 0x2984, 0x2984, 0x2984, 0x2984, 0x1923, 0x10C2, 0x18C2, 0x18E3, 0x18E2, 0x18E2, 0x10E2, 0x10E2, 0x10C2, 0x0881, 0x0881, 0x10C2, 0x10C2, 0x1902, 0x2162, 0x29A3, 0x29A3, 0x2182, 0x2142, 0x2182, 
        0x4264, 0x3A64, 0x31E2, 0x29E2, 0x29C2, 0x29C2, 0x3A24, 0x3A24, 0x2162, 0x1942, 0x29A2, 0x2162, 0x21A2, 0x29A2, 0x29C3, 0x3203, 0x3203, 0x2141, 0x3203, 0x3A44, 0x3203, 0x29E2, 0x31E3, 0x3A44, 0x31E2, 0x3203, 0x3A44, 0x3203, 0x29E3,
  0x8BAD, 0x4985, 0x38E3, 0x4964, 0x6227, 0x6B2B, 0x734C, 0x6A68, 0x4944, 0x4144, 0x59E6, 0x5A47, 0x6B2B, 0x730B, 0x49A5, 0x3944, 0x4185, 0x5248, 0x738C, 0x6B4B, 0x5248, 0x41C5, 0x41E6, 0x41E6, 0x4207, 0x4A48, 0x4207, 0x3165, 0x2103, 0x2964, 0x2102, 
        0x18C1, 0x2103, 0x18C2, 0x18C2, 0x18C2, 0x0020, 0x0020, 0x0040, 0x10C1, 0x10E1, 0x0880, 0x0020, 0x0860, 0x10C1, 0x0880, 0x08C1, 0x0881, 0x0881, 0x10C1, 0x1902, 0x10C1, 0x10C1, 0x2142, 0x1901, 0x2162, 0x2983, 0x1922, 0x10C1, 0x1902, 0x10E2, 
        0x10E1, 0x08A1, 0x0860, 0x0860, 0x0881, 0x08A1, 0x0881, 0x0881, 0x10A1, 0x0881, 0x10C1, 0x1102, 0x10C1, 0x1902, 0x18E1, 0x1902, 0x1901, 0x0880, 0x31A5, 0x4A88, 0x1923, 0x2143, 0x08A1, 0x0861, 0x0860, 0x0861, 0x0881, 0x08A1, 0x10E1, 0x1102, 
        0x10E1, 0x10A1, 0x0881, 0x0861, 0x0881, 0x10C1, 0x10E2, 0x10C1, 0x1102, 0x10C1, 0x1102, 0x10E1, 0x10E2, 0x10C1, 0x0881, 0x0881, 0x0881, 0x08A1, 0x10C1, 0x10E1, 0x10E1, 0x10C1, 0x10C1, 0x10E1, 0x1922, 0x1901, 0x18E1, 0x18E1, 0x10C1, 0x10C1, 
        0x18E1, 0x18E2, 0x10A1, 0x10C1, 0x1901, 0x2142, 0x2141, 0x2161, 0x2962, 0x18E1, 0x10C1, 0x10C1, 0x10C1, 0x10E2, 0x10A1, 0x08A1, 0x0881, 0x10A1, 0x10A1, 0x10A2, 0x10C1, 0x4AA8, 0x2123, 0x4AA8, 0x3A26, 0x1901, 0x2942, 0x2142, 0x18E1, 0x18E2, 
        0x10C1, 0x10C1, 0x10C1, 0x18E1, 0x1902, 0x2122, 0x2942, 0x2963, 0x2983, 0x2942, 0x18C1, 0x18E1, 0x1902, 0x1080, 0x39C5, 0x3A06, 0x18E1, 0x2122, 0x2122, 0x10C1, 0x1902, 0x10E1, 0x1901, 0x2142, 0x1921, 0x1902, 0x1902, 0x18E1, 0x10C1, 0x18E1, 
        0x1901, 0x2122, 0x2122, 0x2962, 0x31C3, 0x31A3, 0x2161, 0x31E3, 0x29A2, 0x29C2, 0x29C2, 0x2982, 0x3203, 0x31E3, 0x29A2, 0x10E1, 0x10C1, 0x1902, 0x1922, 0x2142, 0x2162, 0x2983, 0x18E1, 0x10E1, 0x2142, 0x1942, 0x2162, 0x2182, 0x2142, 0x18E1, 
        0x1902, 0x2183, 0x10C1, 0x18A2, 0x6B0B, 0x6228, 0x61C6, 0x61C6, 0x6248, 0x39C6, 0x18E2, 0x18C2, 0x4164, 0x6A07, 0x69E7, 0x6A07, 0x6A07, 0x7207, 0x6A07, 0x7227, 0x7207, 0x7207, 0x7268, 0x6289, 0x2924, 0x2924, 0x3124, 0x6A27, 0x6A06, 0x6A68, 
        0x6A07, 0x7288, 0x82EA, 0x5A07, 0x52A9, 0x72EA, 0x8289, 0x7A89, 0x4A27, 0x62A9, 0x7A89, 0x82A9, 0x6227, 0x5247, 0x6A68, 0x8AA9, 0x6246, 0x29A2, 0x2141, 0x2982, 0x2142, 0x1081, 0x10A1, 0x1922, 0x2162, 0x31E3, 0x29C3, 0x10E1, 0x1942, 0x2162, 
        0x2162, 0x29C3, 0x31E3, 0x3203, 0x3203, 0x3203, 0x3223, 0x3204, 0x2983, 0x2983, 0x3A05, 0x4AA7, 0x52A7, 0x2983, 0x29A3, 0x2962, 0x1901, 0x18E1, 0x18E2, 0x10C1, 0x1902, 0x2142, 0x1922, 0x1922, 0x2142, 0x18E1, 0x10C1, 0x2983, 0x31E4, 0x29C3, 
        0x29A3, 0x3204, 0x29A2, 0x2982, 0x31C3, 0x2142, 0x2162, 0x2162, 0x10E1, 0x10E1, 0x1901, 0x2161, 0x29A2, 0x3A44, 0x2162, 0x2162, 0x2183, 0x2183, 0x2183, 0x2162, 0x2142, 0x2142, 0x1942, 0x2163, 0x21A3, 0x29C4, 0x2163, 0x2183, 0x31E3, 0x31E4, 
        0x2183, 0x1922, 0x10E1, 0x1102, 0x2163, 0x29A3, 0x31E3, 0x31E3, 0x3A03, 0x31E3, 0x31C3, 0x2982, 0x31E3, 0x31C3, 0x2162, 0x29C3, 0x2183, 0x29C3, 0x29A3, 0x29C3, 0x31E4, 0x29E4, 0x2182, 0x1962, 0x3204, 0x3224, 0x29E4, 0x10E2, 0x08A1, 0x10E2, 
        0x10C1, 0x1902, 0x2142, 0x2142, 0x29C3, 0x31E3, 0x29A3, 0x29A3, 0x29A2, 0x3A03, 0x3A44, 0x3203, 0x31E4, 0x1942, 0x1101, 0x10C1, 0x2162, 0x31E3, 0x29C2, 0x2182, 0x1942, 0x1942, 0x2183, 0x2182, 0x29A2, 0x1921, 0x2182, 0x29E3, 0x29C3, 0x29C3, 
        0x2182, 0x1921, 0x1101, 0x1101, 0x2163, 0x29C3, 0x29C3, 0x2183, 0x2182, 0x29C4, 0x31E4, 0x2183, 0x2163, 0x2183, 0x29A3, 0x29C4, 0x3A06, 0x52A9, 0x4AA8, 0x29A4, 0x10C2, 0x10A2, 0x0881, 0x1082, 0x18E2, 0x2123, 0x1903, 0x2123, 0x2963, 0x2964, 
        0x29A5, 0x18E3, 0x1903, 0x2123, 0x29A5, 0x2144, 0x2964, 0x2964, 0x2964, 0x2164, 0x1923, 0x10C2, 0x10A2, 0x10C2, 0x18C2, 0x18C2, 0x18C2, 0x18E2, 0x10A2, 0x0881, 0x10A2, 0x1103, 0x1922, 0x29C3, 0x29A3, 0x2182, 0x29C3, 0x29A3, 0x29C3, 0x3203, 
        0x3A23, 0x3203, 0x3223, 0x31E3, 0x3223, 0x4264, 0x4284, 0x3A23, 0x29C3, 0x3223, 0x3203, 0x1921, 0x1922, 0x1101, 0x2182, 0x3203, 0x29E3, 0x2182, 0x2182, 0x3203, 0x4264, 0x1941, 0x1941, 0x29C2, 0x29E2, 0x31E3, 0x3A44, 0x3203, 0x29C2,
  0x59E6, 0x5185, 0x3903, 0x5185, 0x7268, 0x5A68, 0x5206, 0x7A48, 0x4944, 0x4944, 0x69E6, 0x59A5, 0x5A68, 0x7B0B, 0x5165, 0x4103, 0x5185, 0x59C6, 0x6AEA, 0x83AD, 0x51A5, 0x3903, 0x4985, 0x5185, 0x732B, 0x8C0E, 0x5A27, 0x3944, 0x4164, 0x51E6, 0x6B0A, 
        0x6B2B, 0x6AEA, 0x4A06, 0x5227, 0x5268, 0x4A47, 0x4A48, 0x5289, 0x4206, 0x39E5, 0x31C5, 0x2103, 0x2103, 0x31C5, 0x2143, 0x1902, 0x10E2, 0x0881, 0x10C1, 0x2123, 0x18E2, 0x1902, 0x1922, 0x1922, 0x10E1, 0x1901, 0x10A0, 0x0880, 0x08A1, 0x10C1, 
        0x10E1, 0x0880, 0x0860, 0x0860, 0x10A1, 0x10A1, 0x0881, 0x0860, 0x0840, 0x0881, 0x1922, 0x1942, 0x10E1, 0x10A1, 0x1922, 0x2142, 0x2142, 0x10C1, 0x2143, 0x29C5, 0x10E2, 0x08A1, 0x0881, 0x08A1, 0x0881, 0x0861, 0x0861, 0x08A1, 0x10C1, 0x10C1, 
        0x08A1, 0x0881, 0x10A1, 0x08A1, 0x0861, 0x0881, 0x08A1, 0x10C1, 0x10C1, 0x10C1, 0x1102, 0x1101, 0x10E1, 0x10E2, 0x10C1, 0x0881, 0x0861, 0x08A1, 0x08C1, 0x1102, 0x10E1, 0x10C1, 0x10C1, 0x10E1, 0x1902, 0x1942, 0x1102, 0x1901, 0x18E2, 0x18E2, 
        0x18E2, 0x18E1, 0x10A1, 0x10A1, 0x1901, 0x1921, 0x2141, 0x2962, 0x2142, 0x2162, 0x1922, 0x10C1, 0x10E1, 0x1922, 0x10E1, 0x10A1, 0x10A1, 0x10C2, 0x10A1, 0x0840, 0x4248, 0x94B1, 0x4226, 0x6B6B, 0x3A05, 0x1921, 0x2122, 0x2122, 0x18E1, 0x18C1, 
        0x10A1, 0x10C1, 0x18E1, 0x10C1, 0x10A1, 0x18E1, 0x2122, 0x2142, 0x2102, 0x2142, 0x2102, 0x1901, 0x2142, 0x18E1, 0x4226, 0x3A06, 0x18E1, 0x1902, 0x1902, 0x18E2, 0x10E1, 0x10E1, 0x1902, 0x2122, 0x1921, 0x1901, 0x10E1, 0x10C1, 0x18E2, 0x1901, 
        0x1922, 0x2122, 0x2102, 0x18E2, 0x18E2, 0x2962, 0x2982, 0x2141, 0x1921, 0x29E2, 0x2A02, 0x2161, 0x2982, 0x3223, 0x4284, 0x29C3, 0x10C1, 0x08A1, 0x1902, 0x2162, 0x29A3, 0x31E4, 0x29A4, 0x10C1, 0x10C1, 0x1942, 0x2182, 0x29A3, 0x2982, 0x2182, 
        0x1942, 0x1902, 0x10C2, 0x1081, 0x39C6, 0x51E7, 0x59C6, 0x59E6, 0x6ACA, 0x39A5, 0x18C2, 0x18E2, 0x3944, 0x7227, 0x7227, 0x7247, 0x6A07, 0x6A07, 0x6A07, 0x7227, 0x7227, 0x7227, 0x7268, 0x6289, 0x2103, 0x2123, 0x3164, 0x6247, 0x6A27, 0x61E6, 
        0x6A07, 0x7248, 0x7AA9, 0x6207, 0x62EA, 0x8BAD, 0x8ACA, 0x7A89, 0x5247, 0x7B8D, 0x7AC9, 0x8289, 0x5207, 0x6B2B, 0x7B2B, 0x8288, 0x6226, 0x31E3, 0x3203, 0x2162, 0x0860, 0x10A1, 0x10A1, 0x1902, 0x2163, 0x29A3, 0x29A3, 0x10C1, 0x1901, 0x1942, 
        0x2182, 0x29A2, 0x31E3, 0x3A24, 0x3A23, 0x29E2, 0x3A23, 0x4A85, 0x29A2, 0x1921, 0x10E1, 0x4A67, 0x6B6A, 0x31C4, 0x1901, 0x2101, 0x2122, 0x1902, 0x18E2, 0x1902, 0x1902, 0x2122, 0x2142, 0x2142, 0x1902, 0x10C1, 0x1081, 0x1902, 0x29A3, 0x1942, 
        0x1922, 0x29A3, 0x2162, 0x10A0, 0x10C1, 0x08A1, 0x0881, 0x10E1, 0x10E1, 0x29A3, 0x2162, 0x2982, 0x3A04, 0x3A04, 0x10C1, 0x10C1, 0x2142, 0x2163, 0x2162, 0x2142, 0x2163, 0x2142, 0x1942, 0x2162, 0x2183, 0x1922, 0x2983, 0x29A3, 0x2182, 0x2162, 
        0x2183, 0x2142, 0x1922, 0x1902, 0x10E1, 0x1922, 0x29C3, 0x3A24, 0x39E3, 0x31C2, 0x31A2, 0x2142, 0x2162, 0x2983, 0x2142, 0x2983, 0x2983, 0x2163, 0x1942, 0x2162, 0x29C3, 0x29C3, 0x29A3, 0x29A3, 0x4AA7, 0x4AA7, 0x4286, 0x29A4, 0x10C1, 0x08A1, 
        0x10C1, 0x1102, 0x10E1, 0x2142, 0x29A2, 0x3A04, 0x29C3, 0x2182, 0x31E3, 0x3A03, 0x3A23, 0x3A24, 0x29A3, 0x1922, 0x2142, 0x2162, 0x29A3, 0x3A24, 0x2182, 0x1101, 0x2162, 0x1942, 0x2162, 0x29A2, 0x2182, 0x1921, 0x2182, 0x29C3, 0x29A3, 0x21A3, 
        0x2162, 0x1962, 0x1942, 0x1922, 0x2183, 0x2183, 0x29C3, 0x2162, 0x4266, 0x31E4, 0x29A3, 0x31E5, 0x2983, 0x2142, 0x31C4, 0x3A46, 0x4267, 0x4AA8, 0x2184, 0x31E5, 0x2163, 0x10A2, 0x10C2, 0x10C2, 0x10C2, 0x2123, 0x2123, 0x2143, 0x1923, 0x18E2, 
        0x2103, 0x10A2, 0x18E3, 0x1903, 0x2144, 0x2163, 0x2964, 0x2964, 0x2963, 0x2143, 0x1923, 0x10E2, 0x10A2, 0x18C2, 0x18E2, 0x18C2, 0x18C2, 0x18C2, 0x10C2, 0x10C2, 0x1903, 0x2143, 0x29A3, 0x3203, 0x2182, 0x1921, 0x21A3, 0x21A2, 0x1942, 0x2162, 
        0x29A2, 0x3A24, 0x3204, 0x1941, 0x2182, 0x3A44, 0x29C3, 0x2182, 0x3203, 0x3A44, 0x4264, 0x3204, 0x1101, 0x1942, 0x2182, 0x2162, 0x2162, 0x29A2, 0x29A2, 0x2182, 0x31E3, 0x29A2, 0x3203, 0x3203, 0x3223, 0x29A2, 0x3A24, 0x3A23, 0x29A2,
  0x59C6, 0x4124, 0x28E2, 0x4144, 0x6248, 0x6268, 0x59A5, 0x61E6, 0x4124, 0x4124, 0x61C6, 0x61E6, 0x4985, 0x6206, 0x4965, 0x4103, 0x59A5, 0x69E6, 0x4164, 0x6A68, 0x61C6, 0x4124, 0x59A6, 0x6A07, 0x49A5, 0x6A89, 0x61E6, 0x4104, 0x4985, 0x61C6, 0x51E6, 
        0x838D, 0x6248, 0x4123, 0x4964, 0x51C5, 0x5A88, 0x8C0E, 0x7B0A, 0x4964, 0x51A5, 0x5A06, 0x62EA, 0x7BCD, 0x6268, 0x49C6, 0x49C6, 0x4A26, 0x630A, 0x6B6C, 0x5268, 0x4206, 0x4206, 0x4A27, 0x39E5, 0x39E6, 0x39C5, 0x2943, 0x2964, 0x2984, 0x2163, 
        0x2964, 0x2143, 0x1923, 0x10E2, 0x10A1, 0x10E2, 0x1902, 0x10C2, 0x0881, 0x0881, 0x0860, 0x0880, 0x10E1, 0x0881, 0x0860, 0x1901, 0x2162, 0x2142, 0x18C1, 0x10A1, 0x0881, 0x0881, 0x0881, 0x0861, 0x0881, 0x08A1, 0x08A1, 0x08A1, 0x08A1, 0x08A1, 
        0x08A1, 0x08A1, 0x0881, 0x08A1, 0x0861, 0x0881, 0x0881, 0x10A1, 0x10C1, 0x10C1, 0x10C1, 0x1101, 0x10E1, 0x1102, 0x1922, 0x10C1, 0x10C1, 0x10E2, 0x10C1, 0x10E1, 0x1922, 0x10E1, 0x10C1, 0x1102, 0x10E1, 0x1101, 0x1942, 0x10C1, 0x10A1, 0x18C2, 
        0x10C1, 0x18E1, 0x10C1, 0x10A1, 0x18E1, 0x1901, 0x1921, 0x2142, 0x18E1, 0x1922, 0x18E1, 0x10E1, 0x1902, 0x1942, 0x2162, 0x2162, 0x10E2, 0x0881, 0x0880, 0x29A5, 0x8C6F, 0x7BEE, 0x6B6C, 0x8C4F, 0x3A25, 0x2142, 0x2102, 0x2122, 0x2102, 0x18E1, 
        0x18E2, 0x18C1, 0x18E1, 0x18C1, 0x18E2, 0x1902, 0x18C1, 0x18C1, 0x10A1, 0x18C1, 0x18E1, 0x1901, 0x2122, 0x2102, 0x4A67, 0x31A4, 0x18E1, 0x1902, 0x1902, 0x1901, 0x1902, 0x1902, 0x10E1, 0x1901, 0x1921, 0x1901, 0x10E1, 0x10E1, 0x1922, 0x2982, 
        0x2963, 0x2122, 0x1081, 0x0861, 0x0861, 0x1081, 0x10A1, 0x18E1, 0x18E1, 0x21A2, 0x21A2, 0x21A2, 0x31E3, 0x2161, 0x29A2, 0x3A44, 0x2142, 0x0861, 0x10A1, 0x10E1, 0x2142, 0x29A3, 0x1902, 0x10C1, 0x08A1, 0x10E1, 0x29C3, 0x3A24, 0x31E3, 0x3204, 
        0x1922, 0x10A1, 0x0860, 0x0861, 0x3124, 0x4985, 0x5185, 0x5185, 0x4985, 0x2944, 0x2103, 0x2944, 0x4185, 0x59C6, 0x59A5, 0x61E6, 0x6A68, 0x3103, 0x28C2, 0x5985, 0x61C6, 0x61A6, 0x59C5, 0x4164, 0x2103, 0x2144, 0x39C5, 0x59E6, 0x61C6, 0x69C6, 
        0x69C6, 0x6A07, 0x7227, 0x51C5, 0x3944, 0x59C6, 0x7A68, 0x7248, 0x4185, 0x5227, 0x7268, 0x8289, 0x51E6, 0x5A89, 0x72CA, 0x8AA9, 0x6226, 0x2982, 0x3A04, 0x3204, 0x29A3, 0x1081, 0x10A1, 0x18E2, 0x1101, 0x1922, 0x2183, 0x1901, 0x1922, 0x2162, 
        0x2983, 0x2142, 0x2162, 0x31E3, 0x31E3, 0x29A2, 0x31E3, 0x3A44, 0x4264, 0x29A3, 0x08A0, 0x1902, 0x6B6B, 0x39E5, 0x31A4, 0x4A67, 0x31A4, 0x10C1, 0x10A1, 0x2142, 0x2142, 0x18E1, 0x1902, 0x18E1, 0x10C1, 0x10C1, 0x10C1, 0x10A1, 0x2142, 0x2983, 
        0x1922, 0x2162, 0x29A3, 0x2142, 0x18E2, 0x10A1, 0x10A1, 0x10E1, 0x1942, 0x3204, 0x31E3, 0x2162, 0x31E3, 0x3A04, 0x2142, 0x1102, 0x1902, 0x10E1, 0x10E1, 0x10E1, 0x1922, 0x2142, 0x2142, 0x2142, 0x2183, 0x2163, 0x2142, 0x2162, 0x1921, 0x2162, 
        0x29A3, 0x1922, 0x1922, 0x1922, 0x10E2, 0x1102, 0x2983, 0x31C3, 0x29A3, 0x2142, 0x31A3, 0x31C3, 0x29A2, 0x29C3, 0x2142, 0x29A3, 0x1922, 0x1922, 0x1942, 0x1942, 0x1922, 0x1101, 0x1942, 0x2182, 0x3205, 0x3A45, 0x3A45, 0x3A45, 0x2163, 0x10A1, 
        0x2142, 0x29A3, 0x2162, 0x29C3, 0x31C3, 0x31E3, 0x31E3, 0x29A3, 0x2162, 0x2162, 0x31E3, 0x3203, 0x21A2, 0x1921, 0x2983, 0x29A3, 0x2182, 0x29C2, 0x29A3, 0x31E3, 0x2183, 0x1942, 0x2182, 0x29C3, 0x31E3, 0x2182, 0x29A3, 0x29C3, 0x2182, 0x2183, 
        0x2163, 0x2162, 0x1942, 0x1922, 0x1922, 0x1922, 0x2162, 0x2162, 0x3204, 0x29E3, 0x2182, 0x29E4, 0x4AC8, 0x52E8, 0x31E4, 0x3A05, 0x31C4, 0x2984, 0x2943, 0x52A9, 0x31E5, 0x1903, 0x1903, 0x2163, 0x18E2, 0x1902, 0x2123, 0x2143, 0x1903, 0x2144, 
        0x2144, 0x18E3, 0x18E3, 0x18E3, 0x1903, 0x2143, 0x1943, 0x2163, 0x2163, 0x2164, 0x2143, 0x1903, 0x10C2, 0x18C2, 0x18C2, 0x18C2, 0x18C2, 0x18C2, 0x18C2, 0x18E2, 0x2963, 0x29A3, 0x29A3, 0x29C3, 0x2162, 0x1921, 0x29C3, 0x29A2, 0x1901, 0x1101, 
        0x2182, 0x2182, 0x1101, 0x1101, 0x1962, 0x1962, 0x1101, 0x10E1, 0x29A2, 0x3224, 0x3A23, 0x29C3, 0x29A3, 0x2183, 0x1942, 0x2182, 0x2182, 0x29A2, 0x3203, 0x29A2, 0x2162, 0x29C2, 0x3A64, 0x29E2, 0x31E3, 0x3224, 0x29C3, 0x31C3, 0x31C3,
  0x6A06, 0x4124, 0x30E3, 0x4144, 0x6268, 0x6A89, 0x61C6, 0x5185, 0x28C2, 0x3903, 0x59A5, 0x61C6, 0x61C6, 0x59A5, 0x30E3, 0x30E3, 0x5185, 0x61E6, 0x59A5, 0x61A5, 0x4944, 0x30E3, 0x4965, 0x61E6, 0x59C5, 0x59A5, 0x59A6, 0x3904, 0x4165, 0x69E7, 0x59A5, 
        0x51C6, 0x59C6, 0x4124, 0x4964, 0x6A27, 0x59C5, 0x6247, 0x6A27, 0x4944, 0x5185, 0x6A07, 0x59C5, 0x72EA, 0x6207, 0x4123, 0x5185, 0x59C5, 0x5A47, 0x8BAD, 0x6207, 0x4124, 0x51A5, 0x5A07, 0x7BAD, 0x838D, 0x49A5, 0x4165, 0x51A5, 0x62A9, 0x7BCD, 
        0x6AC9, 0x49A5, 0x49C5, 0x4A07, 0x52A9, 0x62EA, 0x5268, 0x41E6, 0x41E6, 0x39C6, 0x31A5, 0x39C5, 0x31A5, 0x2985, 0x2123, 0x2123, 0x2142, 0x2963, 0x18C2, 0x10A1, 0x0881, 0x0860, 0x0860, 0x0840, 0x0020, 0x0040, 0x0881, 0x08A1, 0x08A1, 0x08A1, 
        0x08C1, 0x10C1, 0x10C1, 0x08A1, 0x0861, 0x10C1, 0x10C1, 0x10A1, 0x10C1, 0x08C1, 0x10C1, 0x1102, 0x1102, 0x1902, 0x10C1, 0x10C1, 0x0881, 0x0880, 0x08A1, 0x10E1, 0x1922, 0x10E1, 0x10C1, 0x10C1, 0x10C1, 0x10C1, 0x10E1, 0x10E2, 0x10A1, 0x1081, 
        0x1081, 0x10A1, 0x18E1, 0x18E1, 0x1902, 0x10A1, 0x08A1, 0x10E1, 0x1081, 0x1081, 0x1081, 0x1081, 0x10A1, 0x10E1, 0x1922, 0x10E1, 0x10E2, 0x0881, 0x08A1, 0x6B8C, 0x5AEA, 0x4A68, 0x52EA, 0x7BEE, 0x4AA8, 0x2142, 0x2122, 0x2102, 0x18E2, 0x18E1, 
        0x18E1, 0x18E2, 0x18E2, 0x10A1, 0x10A1, 0x1902, 0x18E2, 0x18C1, 0x18E1, 0x1902, 0x2102, 0x1901, 0x2102, 0x18E1, 0x52A8, 0x2984, 0x10C1, 0x10C1, 0x1902, 0x2163, 0x1902, 0x1942, 0x2142, 0x2142, 0x2122, 0x18E1, 0x1902, 0x1902, 0x1922, 0x2142, 
        0x18E2, 0x10C1, 0x10A1, 0x1081, 0x0861, 0x0861, 0x1081, 0x18C2, 0x10C1, 0x10C1, 0x10E1, 0x1901, 0x29C2, 0x29E2, 0x2162, 0x2982, 0x2163, 0x0881, 0x0881, 0x10C1, 0x18E2, 0x1922, 0x0861, 0x1081, 0x10A1, 0x10A1, 0x10E1, 0x2983, 0x29A3, 0x29A3, 
        0x18E2, 0x0840, 0x0841, 0x0841, 0x28E3, 0x4965, 0x5165, 0x5185, 0x5185, 0x3164, 0x18E3, 0x2944, 0x3144, 0x59A5, 0x5985, 0x69E6, 0x51E6, 0x28C2, 0x28C2, 0x4944, 0x6A07, 0x61C6, 0x69E6, 0x49A5, 0x2124, 0x2124, 0x39C6, 0x59E6, 0x69E6, 0x69E7, 
        0x69C6, 0x7227, 0x7A48, 0x51C6, 0x3103, 0x61E6, 0x7A68, 0x6A27, 0x3103, 0x4124, 0x6A07, 0x7A68, 0x4985, 0x38E3, 0x5185, 0x7247, 0x5A06, 0x2962, 0x2162, 0x29A3, 0x31E4, 0x1902, 0x10C1, 0x10C1, 0x10E1, 0x1902, 0x1922, 0x2983, 0x31C3, 0x2142, 
        0x2982, 0x2162, 0x10E1, 0x2142, 0x2162, 0x10E1, 0x2982, 0x3203, 0x4284, 0x3A24, 0x10E1, 0x10E2, 0x52C9, 0x52C9, 0x4A67, 0x52A9, 0x31C5, 0x0860, 0x10A1, 0x2122, 0x2142, 0x2142, 0x1902, 0x10C1, 0x1902, 0x1902, 0x18E2, 0x10A1, 0x10A1, 0x10C1, 
        0x10C1, 0x1902, 0x2983, 0x2142, 0x1902, 0x10A1, 0x10A1, 0x18E2, 0x1922, 0x2162, 0x29A3, 0x29A3, 0x2982, 0x3A44, 0x31C4, 0x2183, 0x1963, 0x1922, 0x1902, 0x10E2, 0x1902, 0x1922, 0x2142, 0x2142, 0x29C4, 0x3A05, 0x2163, 0x1942, 0x1902, 0x2142, 
        0x29A3, 0x1922, 0x10E2, 0x1922, 0x1922, 0x1102, 0x1902, 0x2163, 0x2142, 0x1901, 0x2121, 0x31C3, 0x4244, 0x3A24, 0x2162, 0x1901, 0x1102, 0x2142, 0x29A3, 0x2142, 0x1922, 0x2142, 0x29A3, 0x31E4, 0x29A3, 0x29A3, 0x29E4, 0x3204, 0x3A25, 0x31C4, 
        0x29A3, 0x29A3, 0x1922, 0x1922, 0x2162, 0x2162, 0x2162, 0x1922, 0x1101, 0x1922, 0x29A3, 0x31C3, 0x29C3, 0x2182, 0x29A3, 0x29C3, 0x5309, 0x5329, 0x3A45, 0x31E3, 0x2162, 0x1902, 0x1101, 0x2162, 0x31E4, 0x29C3, 0x29A2, 0x21A3, 0x21A3, 0x2162, 
        0x2183, 0x2162, 0x1942, 0x1922, 0x1922, 0x1922, 0x1902, 0x2162, 0x2182, 0x31E3, 0x3204, 0x29A4, 0x3204, 0x4AC7, 0x52E8, 0x5B09, 0x4246, 0x31A4, 0x5AC9, 0x5B0A, 0x29A4, 0x1902, 0x1922, 0x2143, 0x2163, 0x2164, 0x2163, 0x31C5, 0x2964, 0x2985, 
        0x4AA9, 0x31E6, 0x2964, 0x2143, 0x2163, 0x2163, 0x2164, 0x2163, 0x2163, 0x2164, 0x2164, 0x1923, 0x10C2, 0x10C2, 0x10C2, 0x18C2, 0x18C2, 0x18E2, 0x18E2, 0x2102, 0x2122, 0x2142, 0x29A2, 0x2162, 0x2182, 0x2182, 0x29C3, 0x2182, 0x2142, 0x29C3, 
        0x2182, 0x1901, 0x1942, 0x29A3, 0x21A2, 0x2162, 0x2162, 0x1942, 0x1942, 0x2182, 0x2162, 0x1901, 0x2162, 0x21A3, 0x1101, 0x2182, 0x29C3, 0x3203, 0x29E3, 0x29A2, 0x29E3, 0x3203, 0x3A64, 0x3223, 0x1941, 0x29C3, 0x29A2, 0x2982, 0x2982,
  0x7207, 0x4144, 0x30E3, 0x4944, 0x6AA9, 0x72C9, 0x7207, 0x59A5, 0x30E3, 0x4124, 0x61E6, 0x7207, 0x7227, 0x69E6, 0x30E3, 0x3103, 0x5185, 0x7207, 0x6A06, 0x7207, 0x4944, 0x30E3, 0x4985, 0x6A07, 0x6A06, 0x6A06, 0x5185, 0x30E3, 0x4144, 0x61E6, 0x61E6, 
        0x59E6, 0x4964, 0x30E2, 0x3923, 0x59C6, 0x59A5, 0x59A5, 0x59A5, 0x4123, 0x4985, 0x7207, 0x61C6, 0x61E6, 0x59A5, 0x4103, 0x5185, 0x7207, 0x5185, 0x6206, 0x59A5, 0x4123, 0x6206, 0x6206, 0x51E6, 0x72A9, 0x5185, 0x4924, 0x61E6, 0x51C5, 0x5A68, 
        0x7268, 0x4123, 0x5185, 0x61C6, 0x5A88, 0x838D, 0x5165, 0x4124, 0x51C5, 0x6AA9, 0x944F, 0x732B, 0x4185, 0x41A5, 0x5227, 0x83CD, 0x734C, 0x4A27, 0x41C5, 0x41C6, 0x5AA9, 0x5ACA, 0x5AA9, 0x4207, 0x4A48, 0x4227, 0x2123, 0x2984, 0x2984, 0x2963, 
        0x1902, 0x08C1, 0x10E2, 0x1922, 0x10E2, 0x10A1, 0x0080, 0x08A1, 0x10A1, 0x0880, 0x0880, 0x08C1, 0x08C1, 0x10C1, 0x0881, 0x10A1, 0x10C1, 0x10E1, 0x10E1, 0x1101, 0x1922, 0x1942, 0x1922, 0x10C1, 0x10A1, 0x10A1, 0x10C1, 0x10E2, 0x10A1, 0x1081, 
        0x10A1, 0x10C1, 0x1901, 0x1901, 0x10A1, 0x0861, 0x0881, 0x0881, 0x0881, 0x0861, 0x0861, 0x0861, 0x1081, 0x18E2, 0x10A1, 0x0861, 0x0861, 0x0840, 0x2144, 0x3A27, 0x2123, 0x31E6, 0x4A89, 0x4AAA, 0x5B0A, 0x3A06, 0x2122, 0x18E1, 0x18E2, 0x18C1, 
        0x10C1, 0x18C1, 0x10C1, 0x10A1, 0x10A1, 0x1081, 0x18C1, 0x18E1, 0x18C1, 0x18C1, 0x2122, 0x2122, 0x18E1, 0x18E1, 0x52A8, 0x2963, 0x18E2, 0x1902, 0x1081, 0x18E1, 0x18E1, 0x1101, 0x1942, 0x2162, 0x2962, 0x18E1, 0x10C1, 0x10C1, 0x1902, 0x2102, 
        0x10A1, 0x10A1, 0x10A2, 0x10A1, 0x10C1, 0x1081, 0x0861, 0x0881, 0x10A1, 0x08A1, 0x10A1, 0x10A1, 0x1101, 0x2162, 0x2982, 0x2162, 0x10C1, 0x0881, 0x10A1, 0x10C1, 0x10A1, 0x10A1, 0x1081, 0x0861, 0x0881, 0x10A1, 0x10A1, 0x1922, 0x2122, 0x1902, 
        0x10C2, 0x0820, 0x0861, 0x0841, 0x28C2, 0x5185, 0x59A6, 0x51A5, 0x59C6, 0x3965, 0x18E3, 0x2965, 0x2944, 0x59A5, 0x5985, 0x61C6, 0x4965, 0x30C3, 0x30E3, 0x4965, 0x69C6, 0x61C6, 0x61C6, 0x51C6, 0x2944, 0x2144, 0x31C5, 0x4164, 0x69E6, 0x69C6, 
        0x61A5, 0x61C6, 0x7248, 0x51E6, 0x3924, 0x61E6, 0x7A48, 0x6227, 0x3964, 0x5185, 0x7248, 0x7A68, 0x49A6, 0x4124, 0x61E6, 0x7A68, 0x51E5, 0x10C1, 0x1080, 0x18E1, 0x10C1, 0x10C1, 0x1902, 0x10E2, 0x10C1, 0x1102, 0x1942, 0x2182, 0x31E3, 0x3A03, 
        0x3A04, 0x29A3, 0x1101, 0x1101, 0x2183, 0x2142, 0x2162, 0x29C2, 0x3A03, 0x4AA6, 0x4266, 0x2984, 0x52A9, 0x39E6, 0x10C1, 0x18E2, 0x10A1, 0x0861, 0x2122, 0x2162, 0x2122, 0x2122, 0x18E1, 0x18C1, 0x10A1, 0x10A1, 0x1081, 0x0881, 0x1081, 0x1081, 
        0x10C1, 0x1902, 0x2163, 0x2163, 0x1902, 0x0881, 0x0881, 0x18E2, 0x1922, 0x2162, 0x29A3, 0x29A3, 0x1921, 0x29C3, 0x2163, 0x2162, 0x21A3, 0x2163, 0x1102, 0x10C1, 0x10E1, 0x1902, 0x2142, 0x2983, 0x2983, 0x2163, 0x29A3, 0x2163, 0x1922, 0x1902, 
        0x1922, 0x1922, 0x10E2, 0x1902, 0x1902, 0x1902, 0x10C1, 0x10E1, 0x2142, 0x2983, 0x39E4, 0x31E3, 0x2982, 0x3A24, 0x4265, 0x31C3, 0x2163, 0x2163, 0x29A3, 0x29A3, 0x1942, 0x29C4, 0x29E4, 0x29E3, 0x29C4, 0x21A3, 0x29A3, 0x31E4, 0x4265, 0x3A66, 
        0x31E4, 0x1101, 0x10E1, 0x1942, 0x1942, 0x1922, 0x2163, 0x1922, 0x1901, 0x1922, 0x29A3, 0x29A2, 0x31E3, 0x31C3, 0x29C3, 0x3204, 0x52E9, 0x63AC, 0x6BCC, 0x4AC7, 0x29E4, 0x1943, 0x08A1, 0x10C1, 0x2162, 0x2183, 0x2162, 0x1942, 0x1942, 0x1101, 
        0x1922, 0x2183, 0x1942, 0x1921, 0x1942, 0x1902, 0x1902, 0x2183, 0x29A3, 0x29A3, 0x29A3, 0x2162, 0x21A3, 0x31E4, 0x3A25, 0x4AA8, 0x31C5, 0x4247, 0x4227, 0x2984, 0x29A4, 0x2163, 0x2143, 0x2143, 0x29A5, 0x29A5, 0x3A06, 0x4A88, 0x31C5, 0x1923, 
        0x2164, 0x31E6, 0x8470, 0x4AC9, 0x29C5, 0x2163, 0x2163, 0x2143, 0x2143, 0x2964, 0x2985, 0x2144, 0x10C2, 0x18E2, 0x18C2, 0x10A2, 0x10A2, 0x10A2, 0x10A2, 0x1902, 0x31C4, 0x3203, 0x3A24, 0x29C3, 0x29C3, 0x29A2, 0x29A3, 0x1942, 0x2162, 0x29A3, 
        0x2142, 0x10E1, 0x3204, 0x3A24, 0x31E3, 0x1941, 0x2182, 0x2162, 0x2162, 0x2162, 0x2162, 0x10E1, 0x0860, 0x08C1, 0x10E1, 0x2142, 0x29A2, 0x31E3, 0x29E3, 0x1101, 0x3203, 0x3A43, 0x3A44, 0x2182, 0x29A3, 0x3A44, 0x29C3, 0x3A24, 0x2162,
  0x6A06, 0x4124, 0x30E3, 0x4144, 0x6B0A, 0x836C, 0x7207, 0x59A5, 0x30E3, 0x4124, 0x61C6, 0x7207, 0x7206, 0x69E6, 0x3103, 0x3103, 0x5185, 0x7207, 0x7206, 0x7207, 0x4964, 0x3123, 0x5185, 0x7227, 0x7227, 0x7227, 0x51A5, 0x3103, 0x4965, 0x7227, 0x7227, 
        0x7227, 0x5185, 0x38E3, 0x4144, 0x61E6, 0x69E6, 0x69E6, 0x5164, 0x30E3, 0x4964, 0x61E6, 0x61E6, 0x61E6, 0x4944, 0x30E2, 0x4964, 0x69E6, 0x59C6, 0x61E6, 0x4144, 0x30E3, 0x49A5, 0x61E6, 0x51A5, 0x61E6, 0x4944, 0x4124, 0x61C6, 0x61C5, 0x59A5, 
        0x61C6, 0x4123, 0x4964, 0x69E6, 0x51A5, 0x6A47, 0x5185, 0x3923, 0x59C6, 0x59C6, 0x5A68, 0x6A89, 0x4124, 0x4985, 0x59C6, 0x5A88, 0x732B, 0x3923, 0x3903, 0x59A5, 0x6ACA, 0x8C0E, 0x6289, 0x4165, 0x59E6, 0x62A9, 0x944F, 0x7B2B, 0x41A5, 0x49C5, 
        0x5207, 0x632B, 0x62EA, 0x4A06, 0x39C5, 0x4206, 0x4A48, 0x4A27, 0x39E6, 0x31A5, 0x31C5, 0x29A4, 0x2144, 0x2924, 0x2103, 0x2944, 0x2123, 0x2102, 0x2143, 0x1922, 0x10E1, 0x10E1, 0x1902, 0x1922, 0x10C1, 0x08A0, 0x10C1, 0x10A1, 0x1081, 0x0861, 
        0x18C1, 0x18E1, 0x1901, 0x1922, 0x10E1, 0x10A1, 0x10A1, 0x0861, 0x0861, 0x0881, 0x1081, 0x0881, 0x10A1, 0x10C1, 0x1081, 0x0861, 0x0861, 0x0861, 0x10A2, 0x1081, 0x10A1, 0x31E6, 0x5B0A, 0x52C9, 0x632B, 0x2963, 0x1902, 0x18E1, 0x18E1, 0x18E1, 
        0x10C1, 0x10C1, 0x10C1, 0x10A1, 0x10A1, 0x18C1, 0x2963, 0x2962, 0x1902, 0x2142, 0x29C3, 0x2142, 0x18E1, 0x10A1, 0x4A88, 0x2963, 0x1080, 0x2163, 0x2122, 0x2142, 0x2962, 0x2162, 0x2162, 0x2162, 0x2142, 0x10C1, 0x10A1, 0x10A1, 0x18E2, 0x18E2, 
        0x18E2, 0x10C1, 0x0881, 0x0861, 0x0881, 0x10A1, 0x1081, 0x1081, 0x0881, 0x0881, 0x0881, 0x10A1, 0x10C1, 0x2122, 0x10E1, 0x10A1, 0x10A1, 0x0881, 0x10A1, 0x10A1, 0x10C2, 0x1081, 0x0881, 0x1081, 0x1081, 0x10A1, 0x10A1, 0x10C1, 0x1902, 0x1902, 
        0x0840, 0x0020, 0x0840, 0x0000, 0x2082, 0x4985, 0x51A6, 0x5185, 0x51C6, 0x3164, 0x18E2, 0x2964, 0x3144, 0x59A6, 0x59A5, 0x61C6, 0x4985, 0x3103, 0x3103, 0x4985, 0x6A07, 0x69E6, 0x6A07, 0x5207, 0x3185, 0x2965, 0x4207, 0x51E6, 0x7248, 0x7228, 
        0x6A07, 0x6207, 0x7268, 0x5227, 0x4164, 0x6207, 0x7A48, 0x5A07, 0x3144, 0x4964, 0x7228, 0x7228, 0x49A6, 0x4124, 0x61C6, 0x7248, 0x49C5, 0x10A1, 0x1081, 0x10C2, 0x10C1, 0x10E1, 0x1922, 0x1922, 0x10E1, 0x1922, 0x1902, 0x2162, 0x29C3, 0x3A04, 
        0x4244, 0x3A44, 0x29A3, 0x2162, 0x2162, 0x2162, 0x2142, 0x3A04, 0x4A86, 0x4AA7, 0x29A4, 0x3A06, 0x6B6C, 0x4227, 0x0860, 0x1081, 0x1081, 0x1081, 0x18E2, 0x1922, 0x2142, 0x2122, 0x1902, 0x1081, 0x0861, 0x0861, 0x0881, 0x10A1, 0x10A1, 0x10A1, 
        0x10A1, 0x10A1, 0x1902, 0x10E2, 0x1081, 0x10A1, 0x10C1, 0x18E1, 0x1922, 0x2982, 0x29C3, 0x2982, 0x2183, 0x1922, 0x1102, 0x1942, 0x2163, 0x2183, 0x2163, 0x1922, 0x1902, 0x1902, 0x10E1, 0x10E2, 0x1902, 0x1922, 0x2183, 0x29A3, 0x1942, 0x1922, 
        0x1102, 0x1902, 0x2142, 0x2142, 0x1902, 0x10C1, 0x10C1, 0x10C1, 0x1922, 0x2963, 0x2962, 0x2162, 0x2142, 0x31C3, 0x4A85, 0x3A24, 0x2162, 0x1922, 0x2983, 0x2163, 0x2162, 0x2183, 0x2162, 0x1942, 0x2183, 0x29E4, 0x1942, 0x2163, 0x3204, 0x3A24, 
        0x29A2, 0x1962, 0x1942, 0x1922, 0x1121, 0x1901, 0x1922, 0x2163, 0x2162, 0x1942, 0x2182, 0x29A2, 0x3203, 0x3A04, 0x3204, 0x31E4, 0x2162, 0x29A3, 0x4266, 0x638B, 0x42A8, 0x31C5, 0x3206, 0x3205, 0x29A3, 0x1962, 0x2183, 0x21A3, 0x21A3, 0x1942, 
        0x1922, 0x2163, 0x21A3, 0x2163, 0x1942, 0x1102, 0x1922, 0x1942, 0x1922, 0x1922, 0x1902, 0x1901, 0x31C4, 0x39E5, 0x31E4, 0x3A26, 0x2983, 0x2964, 0x31C5, 0x2964, 0x29A4, 0x29A4, 0x2163, 0x29A4, 0x4247, 0x4A88, 0x5ACA, 0x31C5, 0x29A4, 0x2143, 
        0x2143, 0x29C5, 0x3A27, 0x29E5, 0x1963, 0x1923, 0x1923, 0x1923, 0x1902, 0x2123, 0x10E2, 0x10A2, 0x10C2, 0x10A2, 0x10A2, 0x10A2, 0x1082, 0x10A1, 0x2122, 0x31E4, 0x3A24, 0x3223, 0x3224, 0x29E3, 0x29C3, 0x2162, 0x1101, 0x1942, 0x29A2, 0x29A2, 
        0x1942, 0x10E1, 0x2183, 0x2142, 0x10E1, 0x10C1, 0x10E1, 0x1101, 0x10E1, 0x2162, 0x1101, 0x2162, 0x1922, 0x10C1, 0x1922, 0x1942, 0x29A2, 0x29A2, 0x2162, 0x10E1, 0x2162, 0x2182, 0x29C2, 0x2983, 0x2162, 0x3223, 0x3223, 0x3A44, 0x29C2,
  0x69E6, 0x4124, 0x30E3, 0x4144, 0x6B0B, 0x736D, 0x7206, 0x5985, 0x30E3, 0x3903, 0x61C6, 0x7207, 0x7206, 0x69E6, 0x38E3, 0x3103, 0x5185, 0x7206, 0x7206, 0x7207, 0x4944, 0x3903, 0x5185, 0x7207, 0x7227, 0x7207, 0x5985, 0x3903, 0x4944, 0x69E6, 0x7206, 
        0x7207, 0x5185, 0x3923, 0x4944, 0x6A06, 0x7227, 0x7227, 0x59A5, 0x3903, 0x4965, 0x6A07, 0x6A27, 0x7227, 0x4964, 0x3103, 0x4964, 0x6A07, 0x6A07, 0x6A07, 0x4143, 0x30E3, 0x51A5, 0x6A06, 0x6206, 0x61C6, 0x38E2, 0x3903, 0x61C6, 0x61C6, 0x69E6, 
        0x61A5, 0x30E3, 0x4944, 0x69E6, 0x69E6, 0x69E6, 0x4124, 0x3103, 0x49A5, 0x59C6, 0x51A5, 0x51C5, 0x3123, 0x4965, 0x6207, 0x51A5, 0x51E6, 0x4144, 0x4144, 0x6A07, 0x51A5, 0x5A07, 0x59E6, 0x4124, 0x61E6, 0x59C6, 0x5A48, 0x6248, 0x3923, 0x4985, 
        0x59E6, 0x6AC9, 0x72EA, 0x4144, 0x5165, 0x6206, 0x730B, 0x838D, 0x49A5, 0x4985, 0x5A07, 0x6B0B, 0x7B6D, 0x49C6, 0x4185, 0x5A48, 0x8C4F, 0xA4F1, 0x6ACA, 0x4A07, 0x5288, 0x630A, 0x630A, 0x5288, 0x41E5, 0x39C5, 0x39C5, 0x39C5, 0x31A5, 0x2123, 
        0x2123, 0x2122, 0x2963, 0x29A3, 0x2162, 0x18E1, 0x0881, 0x10A2, 0x1081, 0x0860, 0x0020, 0x0040, 0x0881, 0x0881, 0x1081, 0x0861, 0x1081, 0x0881, 0x0861, 0x0860, 0x10A1, 0x1902, 0x4A88, 0x73CD, 0x73CD, 0x31C5, 0x10A1, 0x1902, 0x1902, 0x18E1, 
        0x18C1, 0x10A1, 0x1081, 0x10A1, 0x2963, 0x31A3, 0x31A2, 0x39E3, 0x31A3, 0x2182, 0x2182, 0x29A3, 0x29A3, 0x10C1, 0x4A88, 0x31C4, 0x18E2, 0x2122, 0x2162, 0x2122, 0x2142, 0x29A3, 0x2162, 0x2162, 0x2142, 0x1902, 0x1902, 0x1902, 0x18E2, 0x10A1, 
        0x2102, 0x2142, 0x10A1, 0x1081, 0x10C1, 0x18C1, 0x18E2, 0x1902, 0x18E2, 0x10A1, 0x0881, 0x0861, 0x0860, 0x1081, 0x0881, 0x1081, 0x10A1, 0x0861, 0x0861, 0x0881, 0x0881, 0x10A1, 0x1081, 0x0861, 0x0861, 0x10C2, 0x1902, 0x18C2, 0x0861, 0x18E3, 
        0x18E3, 0x2124, 0x2965, 0x3185, 0x49C6, 0x5A07, 0x51E6, 0x5A27, 0x6248, 0x5227, 0x41E6, 0x4A27, 0x5248, 0x6AA9, 0x6A89, 0x72A9, 0x6289, 0x5A68, 0x5A69, 0x6AA9, 0x72CA, 0x6A89, 0x6A89, 0x62A9, 0x5A88, 0x5289, 0x62A9, 0x6AA9, 0x72A9, 0x6AA9, 
        0x6288, 0x6268, 0x6A89, 0x62A9, 0x62A9, 0x6AA9, 0x7B0B, 0x6AEA, 0x62A9, 0x6AA9, 0x830A, 0x7B0A, 0x5A88, 0x51E6, 0x6A48, 0x7AA9, 0x5206, 0x2143, 0x18E2, 0x10C2, 0x10C1, 0x1902, 0x10C1, 0x1101, 0x1102, 0x2163, 0x2142, 0x1902, 0x1922, 0x29A2, 
        0x31E3, 0x4244, 0x31C3, 0x29C3, 0x2162, 0x2182, 0x3A25, 0x4245, 0x4A86, 0x3A26, 0x2964, 0x2964, 0x52A9, 0x3A06, 0x10A1, 0x10A1, 0x1081, 0x1061, 0x10A1, 0x10C1, 0x18E2, 0x10A1, 0x10A1, 0x1081, 0x0861, 0x0861, 0x0861, 0x0881, 0x0881, 0x0881, 
        0x10A1, 0x10C1, 0x10C1, 0x10A1, 0x10A1, 0x10A1, 0x18E2, 0x1902, 0x2142, 0x2162, 0x29A2, 0x29A3, 0x2983, 0x1102, 0x10E1, 0x1102, 0x1942, 0x2183, 0x2183, 0x2183, 0x2183, 0x1902, 0x10C1, 0x1901, 0x1901, 0x2983, 0x2162, 0x2162, 0x1922, 0x1102, 
        0x1922, 0x1902, 0x1922, 0x1942, 0x29A4, 0x1922, 0x10E1, 0x1102, 0x1942, 0x1922, 0x18E1, 0x18E1, 0x2122, 0x31C3, 0x4203, 0x3A03, 0x2183, 0x1902, 0x1922, 0x1922, 0x2162, 0x2142, 0x1101, 0x1942, 0x2183, 0x29A3, 0x1922, 0x1902, 0x1962, 0x29E3, 
        0x3204, 0x2163, 0x1102, 0x1101, 0x1922, 0x1922, 0x1922, 0x1922, 0x1101, 0x2983, 0x29C3, 0x29C3, 0x29C3, 0x31C3, 0x2983, 0x2162, 0x2983, 0x29A2, 0x4246, 0x6BAD, 0x6BCE, 0x4269, 0x3207, 0x3205, 0x4AA7, 0x3A46, 0x1942, 0x1942, 0x2183, 0x1943, 
        0x1102, 0x1962, 0x2163, 0x2163, 0x1922, 0x10C1, 0x1102, 0x1102, 0x10E1, 0x1942, 0x1922, 0x2142, 0x2983, 0x29C4, 0x31C4, 0x29A4, 0x2163, 0x2984, 0x2984, 0x2163, 0x29A4, 0x2984, 0x29A4, 0x29C4, 0x31E5, 0x4227, 0x4A67, 0x3A27, 0x31C5, 0x2163, 
        0x1943, 0x2143, 0x29A5, 0x1943, 0x1922, 0x1902, 0x18E2, 0x1923, 0x2123, 0x1902, 0x10A2, 0x1081, 0x10A2, 0x10C2, 0x10A2, 0x18E2, 0x10C2, 0x2163, 0x3A44, 0x3203, 0x3203, 0x31E3, 0x29C2, 0x29E3, 0x29C3, 0x2182, 0x1101, 0x1101, 0x1942, 0x2162, 
        0x1922, 0x2162, 0x1922, 0x10E1, 0x2142, 0x2162, 0x10C1, 0x08A1, 0x1921, 0x1942, 0x1942, 0x1942, 0x1902, 0x0881, 0x10A1, 0x10E2, 0x1942, 0x2162, 0x1901, 0x0881, 0x08A1, 0x1901, 0x2182, 0x1921, 0x1921, 0x29C2, 0x31E3, 0x3203, 0x4264,
  0x69E6, 0x4124, 0x30E3, 0x4124, 0x630B, 0x6B2C, 0x6A07, 0x5985, 0x30E3, 0x3924, 0x61C6, 0x7207, 0x7226, 0x69E6, 0x38E3, 0x3103, 0x5165, 0x7206, 0x7206, 0x7207, 0x4945, 0x3903, 0x5185, 0x7206, 0x7206, 0x7206, 0x5985, 0x30E3, 0x4964, 0x6A06, 0x7206, 
        0x7207, 0x5185, 0x3903, 0x4944, 0x69E6, 0x7206, 0x6A06, 0x5985, 0x3903, 0x4964, 0x6A06, 0x6A06, 0x7207, 0x4964, 0x30E3, 0x5165, 0x6A07, 0x7207, 0x7207, 0x4944, 0x3903, 0x59A6, 0x7227, 0x7247, 0x61E6, 0x30E3, 0x4124, 0x61E6, 0x7227, 0x7227, 
        0x59A5, 0x30E3, 0x4144, 0x6A06, 0x7227, 0x6A27, 0x3903, 0x3103, 0x59A5, 0x6A07, 0x6A07, 0x59A5, 0x30C2, 0x4964, 0x61E6, 0x61E6, 0x59E6, 0x30E3, 0x3103, 0x51C6, 0x59E6, 0x59C5, 0x4964, 0x30E3, 0x5185, 0x61E6, 0x59A5, 0x51A5, 0x3103, 0x4965, 
        0x61E6, 0x51A5, 0x6206, 0x4144, 0x5185, 0x7227, 0x51A5, 0x6A47, 0x5165, 0x4965, 0x6A07, 0x51C6, 0x6268, 0x4944, 0x4944, 0x59A5, 0x5A27, 0x8B8C, 0x5185, 0x4944, 0x6207, 0x6AEA, 0x732B, 0x4985, 0x51C6, 0x5A27, 0x7B8D, 0x7B4C, 0x4185, 0x49A5, 
        0x5A68, 0x7BAD, 0x62A9, 0x49E6, 0x5226, 0x5AC9, 0x6B4B, 0x62EA, 0x3985, 0x39A5, 0x5288, 0x4A68, 0x39C5, 0x2964, 0x31A5, 0x2944, 0x31A5, 0x2944, 0x2123, 0x2123, 0x1922, 0x2963, 0x31A5, 0x6B6C, 0x7BEE, 0x632B, 0x31C5, 0x1902, 0x10A1, 0x10A1, 
        0x10A1, 0x10A1, 0x10C1, 0x2102, 0x2982, 0x2962, 0x2982, 0x2982, 0x2142, 0x2162, 0x2183, 0x1921, 0x2162, 0x18E1, 0x52A8, 0x2943, 0x1901, 0x2122, 0x2122, 0x2942, 0x2122, 0x2142, 0x2142, 0x2162, 0x1921, 0x18E1, 0x10E1, 0x18E2, 0x2143, 0x18E1, 
        0x10C1, 0x18E1, 0x2162, 0x2962, 0x2142, 0x2142, 0x2142, 0x2142, 0x18E2, 0x10A1, 0x1081, 0x10A1, 0x10A1, 0x0861, 0x0840, 0x0861, 0x0861, 0x0861, 0x0881, 0x0861, 0x0861, 0x0881, 0x1081, 0x0861, 0x0840, 0x0861, 0x10A1, 0x18E2, 0x1081, 0x20C2, 
        0x3124, 0x3124, 0x4185, 0x3965, 0x49A5, 0x4144, 0x4985, 0x4985, 0x4985, 0x49A5, 0x4965, 0x51C6, 0x4985, 0x51C6, 0x4985, 0x51A6, 0x51A6, 0x49A5, 0x51C6, 0x49A5, 0x51C6, 0x4965, 0x51A5, 0x5185, 0x51A5, 0x59A5, 0x5165, 0x5185, 0x4965, 0x59A5, 
        0x4964, 0x61A5, 0x6A27, 0x59C6, 0x59E6, 0x5A07, 0x59E7, 0x5A07, 0x5A27, 0x5A27, 0x5A07, 0x6268, 0x62A9, 0x6AA9, 0x72EA, 0x72CA, 0x6AEA, 0x5AA9, 0x5A89, 0x5AA9, 0x4A48, 0x4226, 0x4247, 0x29A5, 0x10C1, 0x1902, 0x29A3, 0x1922, 0x10E1, 0x2162, 
        0x3A03, 0x3A03, 0x1921, 0x1921, 0x1922, 0x2183, 0x4266, 0x4265, 0x3A24, 0x1902, 0x10A1, 0x0860, 0x3A06, 0x39E6, 0x10A1, 0x10A1, 0x1081, 0x10A1, 0x18C2, 0x10C1, 0x0881, 0x10A1, 0x10A1, 0x0881, 0x0861, 0x1081, 0x10C2, 0x10A1, 0x10A1, 0x10C1, 
        0x10C2, 0x10C2, 0x10E2, 0x10A1, 0x08A1, 0x10A1, 0x10E1, 0x1902, 0x2142, 0x2983, 0x2182, 0x29C3, 0x2983, 0x1902, 0x1122, 0x1922, 0x1902, 0x1102, 0x1942, 0x2183, 0x29A3, 0x1922, 0x1942, 0x29A3, 0x31E4, 0x31E3, 0x2182, 0x2162, 0x1922, 0x1101, 
        0x1102, 0x1922, 0x10E1, 0x10A1, 0x1902, 0x2143, 0x1922, 0x2142, 0x29A3, 0x31A3, 0x2942, 0x2122, 0x18E1, 0x2122, 0x39E3, 0x39E3, 0x29A3, 0x1102, 0x1942, 0x2162, 0x1942, 0x1102, 0x1942, 0x1942, 0x1942, 0x2162, 0x1942, 0x1922, 0x1942, 0x1902, 
        0x18E2, 0x1902, 0x1942, 0x2162, 0x2162, 0x1942, 0x2163, 0x1962, 0x1942, 0x29C3, 0x2983, 0x2183, 0x1942, 0x2182, 0x1942, 0x10E1, 0x1922, 0x2162, 0x2162, 0x29A3, 0x2984, 0x10E2, 0x2144, 0x3A06, 0x3A05, 0x4247, 0x2184, 0x1101, 0x10E2, 0x10E1, 
        0x1102, 0x1102, 0x1102, 0x1922, 0x1102, 0x1102, 0x1102, 0x10E2, 0x1922, 0x2183, 0x29A3, 0x29A3, 0x2142, 0x2162, 0x2162, 0x2163, 0x2163, 0x2163, 0x1942, 0x2143, 0x2163, 0x2983, 0x2163, 0x29A3, 0x2163, 0x2984, 0x1102, 0x1122, 0x1943, 0x1922, 
        0x1922, 0x2143, 0x2143, 0x1922, 0x1902, 0x1943, 0x1922, 0x1902, 0x2123, 0x1903, 0x1081, 0x10C2, 0x2143, 0x1902, 0x18E2, 0x2163, 0x2163, 0x29C3, 0x3223, 0x2182, 0x1941, 0x2182, 0x29A2, 0x2182, 0x1942, 0x1922, 0x1942, 0x10E1, 0x10E1, 0x1921, 
        0x1922, 0x2162, 0x10C1, 0x10C1, 0x2162, 0x31E3, 0x31C3, 0x29C3, 0x29A3, 0x29A3, 0x1921, 0x1902, 0x1102, 0x0881, 0x10A1, 0x10C1, 0x1101, 0x1901, 0x2162, 0x2142, 0x10A1, 0x0881, 0x10C1, 0x1922, 0x21A2, 0x3203, 0x4264, 0x4264, 0x4264,
  0x69E6, 0x4124, 0x30E3, 0x4124, 0x62EB, 0x5AAA, 0x6A47, 0x51A5, 0x30E3, 0x3923, 0x61C6, 0x7207, 0x7206, 0x69E6, 0x3903, 0x3903, 0x5165, 0x69E6, 0x61A6, 0x69E6, 0x4944, 0x3903, 0x5185, 0x7206, 0x7206, 0x7206, 0x5985, 0x30E3, 0x4964, 0x6A06, 0x7207, 
        0x7207, 0x5185, 0x3903, 0x4144, 0x69E6, 0x7206, 0x7207, 0x5985, 0x38E3, 0x4964, 0x6A06, 0x7207, 0x7207, 0x4964, 0x3903, 0x5165, 0x7207, 0x7207, 0x7207, 0x4944, 0x3903, 0x59A5, 0x6A27, 0x7227, 0x61C6, 0x30E3, 0x4124, 0x61C6, 0x7207, 0x7227, 
        0x5185, 0x30E3, 0x4144, 0x69E6, 0x6A07, 0x69E6, 0x3903, 0x3903, 0x59A5, 0x7227, 0x7227, 0x59A5, 0x30E3, 0x4965, 0x6A07, 0x7227, 0x6A06, 0x38E3, 0x3924, 0x61E6, 0x7227, 0x6A27, 0x4944, 0x30E3, 0x59A5, 0x6A07, 0x6A07, 0x5185, 0x30E3, 0x4965, 
        0x6A06, 0x69E6, 0x59C6, 0x30E3, 0x4144, 0x6A06, 0x61E6, 0x61E6, 0x3903, 0x4123, 0x59C6, 0x59A5, 0x59C5, 0x4124, 0x4144, 0x69E6, 0x59C5, 0x61C6, 0x4944, 0x4944, 0x6206, 0x51A5, 0x59E6, 0x4124, 0x5185, 0x6207, 0x51E6, 0x6227, 0x4123, 0x51A5, 
        0x59C6, 0x6289, 0x6227, 0x4123, 0x61C6, 0x6248, 0x940E, 0x5A27, 0x4944, 0x6207, 0x7B4C, 0x940E, 0x49A5, 0x49A5, 0x5A27, 0x83EE, 0x6AA9, 0x4985, 0x49C6, 0x734C, 0x7BAD, 0x5248, 0x39C5, 0x6B6C, 0x94D1, 0x73AD, 0x6B8C, 0x5AC9, 0x4206, 0x4206, 
        0x41E6, 0x2984, 0x3183, 0x2942, 0x2963, 0x2963, 0x2962, 0x2122, 0x2142, 0x1901, 0x1922, 0x1901, 0x1901, 0x0880, 0x4A88, 0x2102, 0x1922, 0x2122, 0x18E1, 0x18C1, 0x2122, 0x2142, 0x2122, 0x2162, 0x1901, 0x10E1, 0x10E2, 0x1902, 0x1902, 0x10C1, 
        0x10E1, 0x18E1, 0x2162, 0x31C3, 0x31E2, 0x29A2, 0x2162, 0x2142, 0x10A1, 0x0840, 0x0861, 0x1081, 0x10A1, 0x1081, 0x0861, 0x0881, 0x0861, 0x0881, 0x0861, 0x1081, 0x0861, 0x1081, 0x0861, 0x0841, 0x0841, 0x0841, 0x0861, 0x0861, 0x0841, 0x1882, 
        0x4144, 0x3903, 0x4965, 0x4144, 0x4985, 0x4965, 0x4965, 0x51A6, 0x4965, 0x59A6, 0x5165, 0x59A6, 0x51A5, 0x59C6, 0x59C6, 0x59A6, 0x59A6, 0x5185, 0x59C6, 0x59C6, 0x59C6, 0x59A6, 0x59A5, 0x61C6, 0x59C6, 0x61C6, 0x61A5, 0x61C6, 0x61C6, 0x69C6, 
        0x69C6, 0x69E6, 0x7A48, 0x7227, 0x6A27, 0x6A27, 0x6207, 0x6207, 0x6207, 0x6207, 0x59E6, 0x5A07, 0x59E6, 0x59C6, 0x51A6, 0x51A6, 0x51C6, 0x59C6, 0x59E6, 0x5A07, 0x5A07, 0x6227, 0x5A27, 0x3164, 0x1081, 0x10A1, 0x2163, 0x2163, 0x1902, 0x2162, 
        0x31E3, 0x31C3, 0x2162, 0x1921, 0x1941, 0x3205, 0x4267, 0x29A3, 0x31E3, 0x1902, 0x0880, 0x0840, 0x39C6, 0x39E6, 0x1081, 0x10A1, 0x1081, 0x1081, 0x10A1, 0x10C1, 0x10A1, 0x10E2, 0x0881, 0x0861, 0x0861, 0x1081, 0x10C2, 0x1902, 0x1902, 0x10E1, 
        0x10E2, 0x10C1, 0x10C2, 0x10A1, 0x0881, 0x10C1, 0x1902, 0x1902, 0x18E1, 0x1922, 0x1922, 0x1922, 0x18E1, 0x10C1, 0x10C1, 0x1102, 0x1102, 0x10E1, 0x1122, 0x1942, 0x1962, 0x1122, 0x1942, 0x29C3, 0x29A3, 0x29C3, 0x29E3, 0x2182, 0x1922, 0x2162, 
        0x1942, 0x1101, 0x1102, 0x10E1, 0x1942, 0x29A3, 0x2182, 0x2142, 0x2122, 0x2142, 0x2983, 0x2142, 0x10A1, 0x18E1, 0x2982, 0x31A3, 0x31C4, 0x1922, 0x1922, 0x1922, 0x10C1, 0x1922, 0x1942, 0x2163, 0x2162, 0x2183, 0x1922, 0x1102, 0x2183, 0x2983, 
        0x10E1, 0x10C1, 0x1902, 0x1102, 0x1902, 0x1902, 0x1922, 0x1922, 0x2142, 0x2983, 0x2983, 0x1922, 0x10E1, 0x2162, 0x2183, 0x1902, 0x08C1, 0x08C1, 0x2143, 0x52A8, 0x634B, 0x1923, 0x0881, 0x10A1, 0x31E5, 0x52E9, 0x4246, 0x1102, 0x1102, 0x08C1, 
        0x1102, 0x10E2, 0x1102, 0x1122, 0x10E1, 0x1102, 0x1102, 0x10E1, 0x1942, 0x2182, 0x29A3, 0x29C3, 0x2183, 0x2182, 0x2182, 0x2183, 0x2182, 0x2182, 0x2182, 0x2162, 0x2183, 0x2183, 0x2183, 0x2162, 0x2983, 0x1942, 0x1122, 0x08E1, 0x10E1, 0x1922, 
        0x1942, 0x1942, 0x1902, 0x1902, 0x1902, 0x1922, 0x1922, 0x1922, 0x2122, 0x2123, 0x08A1, 0x10C1, 0x2163, 0x2163, 0x2162, 0x2182, 0x21A3, 0x29A2, 0x29A2, 0x2141, 0x29C3, 0x29C3, 0x21A2, 0x1942, 0x08C1, 0x10E1, 0x10E1, 0x2142, 0x29A3, 0x2163, 
        0x1942, 0x10E1, 0x08C1, 0x1922, 0x2182, 0x3204, 0x3203, 0x3223, 0x3203, 0x29A2, 0x1100, 0x29A2, 0x29C3, 0x2142, 0x1902, 0x2162, 0x2162, 0x29A3, 0x31E3, 0x3A24, 0x3204, 0x10E1, 0x0880, 0x1902, 0x29A3, 0x29A3, 0x29E3, 0x4263, 0x4AC5,
  0x69E6, 0x4124, 0x30E3, 0x4144, 0x630B, 0x5AAA, 0x6227, 0x5185, 0x30E3, 0x3924, 0x61C6, 0x69E6, 0x7206, 0x69E6, 0x38E3, 0x30E3, 0x5185, 0x61C6, 0x5144, 0x69E7, 0x4944, 0x3903, 0x5184, 0x6A06, 0x71E6, 0x7206, 0x5185, 0x30E3, 0x4944, 0x6A07, 0x61C6, 
        0x6A06, 0x5185, 0x3903, 0x4944, 0x69E6, 0x6A06, 0x7206, 0x5185, 0x38E3, 0x4964, 0x69E6, 0x69E6, 0x6A07, 0x5165, 0x38E3, 0x5165, 0x6A06, 0x7207, 0x6A07, 0x4144, 0x3903, 0x59A5, 0x6A07, 0x7227, 0x61C6, 0x38E3, 0x4124, 0x61C6, 0x6A06, 0x6A07, 
        0x5185, 0x30E3, 0x4144, 0x69E6, 0x6A07, 0x69E6, 0x3903, 0x3903, 0x59A5, 0x7227, 0x7227, 0x59A5, 0x30E3, 0x4964, 0x6A06, 0x7207, 0x61E6, 0x30E3, 0x3924, 0x61E6, 0x7207, 0x7227, 0x4965, 0x3903, 0x59A5, 0x7227, 0x7227, 0x5185, 0x3103, 0x4965, 
        0x7227, 0x7227, 0x61E6, 0x30E3, 0x4965, 0x6A07, 0x7227, 0x61E6, 0x30E3, 0x4944, 0x6A06, 0x6A06, 0x61C6, 0x38E3, 0x4123, 0x6A06, 0x6A06, 0x6A06, 0x4103, 0x4124, 0x61E6, 0x69E6, 0x61C6, 0x3903, 0x4964, 0x61E6, 0x59A5, 0x5185, 0x3903, 0x4985, 
        0x61E6, 0x59C6, 0x51A5, 0x3923, 0x61C6, 0x61C6, 0x6227, 0x51A5, 0x4944, 0x6A07, 0x59E6, 0x72C9, 0x4964, 0x59C6, 0x6207, 0x6AA9, 0x6A68, 0x4144, 0x59E6, 0x6268, 0x730B, 0x3944, 0x3944, 0x6B8C, 0x94B1, 0x73CD, 0x7BCD, 0x62A9, 0x732B, 0x8BEE, 
        0x5227, 0x5206, 0x5A88, 0x6B4B, 0x5A68, 0x5227, 0x5A88, 0x6B2A, 0x5AA9, 0x41C5, 0x4226, 0x4A67, 0x4A88, 0x4A67, 0x630A, 0x4A67, 0x39E5, 0x3A05, 0x2943, 0x2122, 0x2983, 0x39E4, 0x31A3, 0x2162, 0x1922, 0x10E1, 0x10C1, 0x18E1, 0x18E1, 0x10A0, 
        0x1901, 0x1901, 0x1921, 0x2161, 0x29C2, 0x29A2, 0x10A1, 0x10A1, 0x10A1, 0x0840, 0x0841, 0x0841, 0x0861, 0x1081, 0x10A1, 0x08A1, 0x0881, 0x10A2, 0x1081, 0x0881, 0x1081, 0x0861, 0x0841, 0x0841, 0x0841, 0x0840, 0x0861, 0x10C2, 0x0840, 0x20A2, 
        0x4165, 0x4145, 0x4985, 0x4985, 0x5185, 0x51C6, 0x51A5, 0x59C6, 0x59A6, 0x61E6, 0x61C6, 0x61C6, 0x61E6, 0x61C6, 0x61E6, 0x61E6, 0x61E7, 0x61C6, 0x61E6, 0x61E6, 0x61C6, 0x61E7, 0x61E6, 0x6207, 0x61E6, 0x61E6, 0x69E6, 0x69E6, 0x69E6, 0x69C6, 
        0x69C6, 0x69E6, 0x7A47, 0x8268, 0x7A68, 0x7268, 0x7A68, 0x7A88, 0x7288, 0x7288, 0x7268, 0x7268, 0x6A48, 0x6A48, 0x6A48, 0x6A28, 0x6A47, 0x6A27, 0x6A07, 0x6207, 0x61E6, 0x6A07, 0x6A07, 0x3964, 0x0881, 0x10A1, 0x1902, 0x2162, 0x2162, 0x29A3, 
        0x29A2, 0x2982, 0x21A3, 0x2182, 0x29A3, 0x4266, 0x3A05, 0x2162, 0x29C3, 0x2983, 0x1902, 0x0881, 0x39E6, 0x4226, 0x10A1, 0x10A1, 0x10C1, 0x0881, 0x18C2, 0x10C1, 0x10A1, 0x10C1, 0x0881, 0x10A1, 0x10A1, 0x10A1, 0x10C2, 0x10E2, 0x1942, 0x1902, 
        0x10A1, 0x1902, 0x10C1, 0x10A1, 0x10C1, 0x10E2, 0x1922, 0x1901, 0x1902, 0x10C1, 0x1922, 0x1902, 0x1902, 0x1102, 0x10E2, 0x10E2, 0x10E2, 0x1922, 0x2163, 0x2163, 0x1942, 0x2162, 0x2183, 0x2162, 0x2183, 0x29A3, 0x29C3, 0x29E3, 0x1962, 0x1942, 
        0x29A3, 0x2163, 0x1922, 0x1922, 0x2983, 0x2983, 0x2162, 0x2142, 0x1922, 0x1901, 0x2142, 0x1902, 0x10C1, 0x18E1, 0x1922, 0x2162, 0x1922, 0x1922, 0x1942, 0x1902, 0x2142, 0x1922, 0x1922, 0x1942, 0x1942, 0x29C3, 0x2183, 0x1942, 0x1942, 0x29A3, 
        0x2163, 0x10E2, 0x10E2, 0x10E1, 0x10E2, 0x1102, 0x10C1, 0x08A1, 0x10E2, 0x1922, 0x2163, 0x10E2, 0x10C1, 0x2163, 0x31E4, 0x29A3, 0x2184, 0x2184, 0x31C5, 0x4247, 0x31E6, 0x1102, 0x08A1, 0x10C2, 0x10C1, 0x4247, 0x4AA8, 0x10E1, 0x08A1, 0x08A1, 
        0x10A2, 0x0881, 0x10C1, 0x1902, 0x1942, 0x10E1, 0x10E2, 0x1101, 0x1922, 0x1942, 0x1962, 0x21A3, 0x21A3, 0x2183, 0x2183, 0x21A3, 0x2182, 0x21A2, 0x29C3, 0x29A3, 0x29A3, 0x29A3, 0x29A3, 0x2183, 0x2183, 0x2162, 0x1962, 0x1942, 0x1962, 0x1962, 
        0x2182, 0x1962, 0x1942, 0x1942, 0x1922, 0x1922, 0x1102, 0x1902, 0x2163, 0x29A3, 0x1922, 0x1942, 0x29A3, 0x2163, 0x2162, 0x2183, 0x21A2, 0x21A2, 0x2182, 0x2182, 0x29A3, 0x2182, 0x1941, 0x1942, 0x1962, 0x1942, 0x1101, 0x2142, 0x2983, 0x29A3, 
        0x29A3, 0x2182, 0x29C3, 0x2162, 0x2182, 0x21A2, 0x2162, 0x2182, 0x3A24, 0x5329, 0x5B6B, 0x5B28, 0x4284, 0x4264, 0x2182, 0x1962, 0x2182, 0x21A2, 0x2182, 0x29C3, 0x3203, 0x29C3, 0x10E1, 0x10E1, 0x10E1, 0x10E1, 0x1941, 0x29C2, 0x4264,
  0x69E6, 0x4124, 0x30E3, 0x4144, 0x630C, 0x52AA, 0x6227, 0x51A5, 0x3923, 0x3924, 0x61C6, 0x69E6, 0x69E6, 0x61C6, 0x3903, 0x3903, 0x5185, 0x61C6, 0x4944, 0x69E6, 0x4944, 0x3103, 0x5165, 0x69E6, 0x69E6, 0x7206, 0x5185, 0x30E3, 0x4944, 0x6A07, 0x5164, 
        0x61C6, 0x5185, 0x38E3, 0x4944, 0x61E6, 0x6A06, 0x7227, 0x5185, 0x38E3, 0x5165, 0x6A07, 0x59A5, 0x69E6, 0x5165, 0x3903, 0x5165, 0x6A06, 0x7206, 0x6A06, 0x4144, 0x3903, 0x59A5, 0x6A07, 0x6A06, 0x61C6, 0x38E3, 0x4124, 0x61C6, 0x6A06, 0x6A07, 
        0x5185, 0x30E3, 0x4124, 0x61E6, 0x6A07, 0x69E6, 0x3903, 0x3903, 0x59A5, 0x6A06, 0x7227, 0x59A5, 0x30E3, 0x4964, 0x6A06, 0x7206, 0x61E6, 0x30E3, 0x3923, 0x61C6, 0x69E6, 0x7206, 0x4964, 0x38E3, 0x59A5, 0x7207, 0x7207, 0x5185, 0x30E3, 0x4965, 
        0x7207, 0x7227, 0x61C6, 0x3903, 0x4964, 0x7206, 0x7207, 0x61E6, 0x30E3, 0x4944, 0x6A06, 0x7207, 0x69E6, 0x3903, 0x4944, 0x7227, 0x7247, 0x7247, 0x4123, 0x4944, 0x7227, 0x7227, 0x69E6, 0x38E3, 0x4965, 0x6A07, 0x7207, 0x5985, 0x30E3, 0x5165, 
        0x6A07, 0x6A06, 0x4944, 0x30E3, 0x59A5, 0x6A06, 0x61E6, 0x4124, 0x3923, 0x61E6, 0x61E6, 0x59A5, 0x3903, 0x5185, 0x6A07, 0x61C6, 0x5185, 0x3903, 0x59C6, 0x61C6, 0x59E6, 0x4164, 0x41A5, 0x5289, 0x5268, 0x5247, 0x5A88, 0x6A68, 0x59E6, 0x6A88, 
        0x4965, 0x51A6, 0x59E6, 0x6AA9, 0x5A07, 0x4965, 0x6206, 0x730A, 0x72CA, 0x4164, 0x59E6, 0x730A, 0xAD53, 0xA532, 0xA552, 0xAD73, 0x83AD, 0x5206, 0x5206, 0x62A9, 0x83AD, 0x5A67, 0x49E5, 0x5AA8, 0x738B, 0x4A27, 0x39A5, 0x4A27, 0x4A68, 0x4A47, 
        0x39E5, 0x52A7, 0x5AE8, 0x4A26, 0x31C4, 0x2983, 0x18E2, 0x18C2, 0x18C2, 0x18E2, 0x1081, 0x10A2, 0x10C2, 0x10A1, 0x10A1, 0x0861, 0x10A1, 0x0861, 0x0840, 0x0020, 0x0861, 0x0861, 0x0820, 0x0840, 0x0840, 0x0840, 0x0861, 0x10A1, 0x0861, 0x2082, 
        0x3924, 0x4145, 0x4965, 0x4965, 0x4985, 0x51A5, 0x51A5, 0x51A5, 0x59A6, 0x59A6, 0x59A6, 0x59A6, 0x61C6, 0x61C6, 0x61C6, 0x61E6, 0x61C6, 0x61E6, 0x61E6, 0x61E6, 0x69E6, 0x69E6, 0x61C6, 0x69E7, 0x6A07, 0x69E7, 0x61C6, 0x61A5, 0x69E6, 0x69C6, 
        0x69C6, 0x69E6, 0x7247, 0x7A68, 0x7A68, 0x7A88, 0x8288, 0x82A8, 0x82A9, 0x82A9, 0x82A9, 0x82A9, 0x7A88, 0x82A9, 0x82A9, 0x82A9, 0x82A8, 0x8288, 0x7A68, 0x7A48, 0x7A68, 0x7248, 0x7248, 0x3964, 0x10C1, 0x10C1, 0x10C1, 0x1922, 0x2142, 0x2162, 
        0x31C3, 0x29A3, 0x2142, 0x2182, 0x29A3, 0x4AA7, 0x29A3, 0x2142, 0x2162, 0x2983, 0x29A3, 0x1901, 0x3A06, 0x3A26, 0x10C1, 0x18E2, 0x10C1, 0x10A1, 0x18C1, 0x10E1, 0x1902, 0x1901, 0x2162, 0x2162, 0x2142, 0x10C1, 0x18E2, 0x1902, 0x10E1, 0x1902, 
        0x10E2, 0x1922, 0x1902, 0x10E2, 0x1902, 0x1942, 0x2142, 0x1922, 0x1902, 0x10C1, 0x10C1, 0x10C1, 0x10E2, 0x10E2, 0x10E2, 0x1902, 0x1902, 0x1922, 0x2142, 0x29C4, 0x29C4, 0x29C3, 0x2163, 0x1942, 0x1942, 0x1942, 0x2183, 0x31E4, 0x31E4, 0x2183, 
        0x2182, 0x29A3, 0x1942, 0x2142, 0x2162, 0x2962, 0x2122, 0x2962, 0x2162, 0x2162, 0x2162, 0x2162, 0x2162, 0x2962, 0x2142, 0x29A3, 0x2142, 0x2162, 0x29A3, 0x2183, 0x29E4, 0x29A3, 0x29C4, 0x2183, 0x29A3, 0x2183, 0x29A3, 0x21A3, 0x2162, 0x1942, 
        0x29C3, 0x2163, 0x1902, 0x10C1, 0x10C1, 0x10E1, 0x10C1, 0x10C2, 0x0881, 0x08A1, 0x10E2, 0x10C1, 0x2143, 0x31E5, 0x4266, 0x3A25, 0x4267, 0x52C9, 0x31C5, 0x10C1, 0x10E2, 0x0881, 0x0881, 0x08A1, 0x08A1, 0x1923, 0x52C9, 0x1902, 0x10E2, 0x10C2, 
        0x10C2, 0x10E2, 0x10E2, 0x1102, 0x1942, 0x1122, 0x1922, 0x1942, 0x2162, 0x1942, 0x2162, 0x2183, 0x2983, 0x2183, 0x29C4, 0x29A3, 0x2183, 0x29C3, 0x3204, 0x31E4, 0x29A4, 0x31E4, 0x31E4, 0x3A04, 0x4245, 0x4285, 0x4286, 0x4285, 0x4265, 0x3A45, 
        0x31E4, 0x29C4, 0x2183, 0x21A3, 0x1942, 0x1122, 0x1922, 0x1942, 0x2162, 0x2183, 0x2183, 0x2183, 0x2183, 0x2183, 0x2163, 0x2183, 0x21A3, 0x21C3, 0x21A2, 0x2182, 0x2182, 0x1942, 0x1101, 0x1942, 0x2163, 0x2162, 0x1922, 0x08A0, 0x1901, 0x21A2, 
        0x29C3, 0x3203, 0x29E3, 0x1962, 0x1942, 0x1101, 0x29C3, 0x31E3, 0x2162, 0x3A66, 0x5B4B, 0x5B4A, 0x52E7, 0x4AC5, 0x3204, 0x2182, 0x3A44, 0x3A23, 0x29A2, 0x2182, 0x29C2, 0x3A44, 0x2162, 0x1942, 0x10E1, 0x10E1, 0x1922, 0x2162, 0x29C2,
  0x69C6, 0x4124, 0x3103, 0x4165, 0x632C, 0x6AEB, 0x59C6, 0x5185, 0x3924, 0x4144, 0x61C6, 0x69E6, 0x69E6, 0x61C6, 0x3903, 0x3924, 0x5185, 0x61C6, 0x5985, 0x69E6, 0x4944, 0x38E3, 0x5165, 0x69E6, 0x69E6, 0x69E6, 0x5185, 0x30E3, 0x4144, 0x69E7, 0x5165, 
        0x61E6, 0x5185, 0x30E3, 0x4124, 0x6247, 0x72EA, 0x8BAD, 0x6A68, 0x30E3, 0x4965, 0x6A07, 0x5165, 0x69E6, 0x5145, 0x3903, 0x5164, 0x6A06, 0x7207, 0x7207, 0x4144, 0x38E3, 0x59A5, 0x61C6, 0x5185, 0x61C6, 0x38E3, 0x4124, 0x61C6, 0x7207, 0x7207, 
        0x5185, 0x28C3, 0x4144, 0x61E6, 0x59A5, 0x61E6, 0x3903, 0x3903, 0x59A5, 0x6A06, 0x6A07, 0x5985, 0x30E3, 0x4964, 0x6A06, 0x69E6, 0x61E6, 0x30E3, 0x3924, 0x61C5, 0x6A06, 0x7206, 0x4944, 0x38E3, 0x59A5, 0x6A06, 0x7207, 0x5185, 0x38E3, 0x5164, 
        0x7206, 0x7207, 0x61C6, 0x38E3, 0x4965, 0x6A06, 0x7206, 0x69E6, 0x38E3, 0x4944, 0x69E6, 0x7206, 0x69E6, 0x3903, 0x4944, 0x7227, 0x7A47, 0x7227, 0x4103, 0x4944, 0x7206, 0x7227, 0x69E6, 0x38E3, 0x5165, 0x7207, 0x7207, 0x5985, 0x3903, 0x5985, 
        0x7227, 0x7207, 0x4944, 0x3903, 0x61C6, 0x7227, 0x7207, 0x4944, 0x4144, 0x7227, 0x7227, 0x61E6, 0x38E3, 0x59A5, 0x7A27, 0x7A27, 0x5164, 0x3903, 0x61C6, 0x7207, 0x61E6, 0x4144, 0x41A5, 0x6B4C, 0x5A68, 0x4985, 0x3103, 0x61E6, 0x69E6, 0x61E6, 
        0x4124, 0x51A5, 0x61E6, 0x61C6, 0x5185, 0x4944, 0x69E6, 0x61C6, 0x59C5, 0x4123, 0x59C6, 0x836B, 0xA511, 0x9CF0, 0xBDD4, 0x7BED, 0x6288, 0x4944, 0x59A5, 0x6A07, 0x72A9, 0x5185, 0x5185, 0x6207, 0x836C, 0x6A68, 0x4984, 0x6248, 0x838D, 0x62A9, 
        0x4164, 0x6288, 0xB532, 0x836C, 0x4964, 0x6A88, 0x942F, 0x732B, 0x49E6, 0x6B0A, 0xA4D1, 0x6B0A, 0x4A06, 0x734B, 0x8C2E, 0x62EA, 0x4A27, 0x4A47, 0x4A47, 0x4A27, 0x39C6, 0x2944, 0x2103, 0x2924, 0x18E2, 0x10A2, 0x2102, 0x18E2, 0x10A1, 0x2081, 
        0x3944, 0x4144, 0x4144, 0x4124, 0x3923, 0x49A5, 0x51A5, 0x59A5, 0x59A6, 0x59A6, 0x5165, 0x38E3, 0x59A6, 0x59A6, 0x59C6, 0x59C6, 0x38E3, 0x59C6, 0x61E6, 0x61E6, 0x61E6, 0x59C6, 0x3903, 0x59A5, 0x61E6, 0x61C6, 0x59C6, 0x49A5, 0x61C6, 0x61C6, 
        0x61C6, 0x61C6, 0x6A27, 0x7A68, 0x59C5, 0x7247, 0x7268, 0x6A06, 0x82A9, 0x7227, 0x82A9, 0x7A68, 0x82A9, 0x7A68, 0x7A88, 0x7A88, 0x7247, 0x7A88, 0x7A67, 0x7A68, 0x7A48, 0x7A48, 0x7A68, 0x3143, 0x10C1, 0x18E2, 0x10C1, 0x1902, 0x1922, 0x1922, 
        0x2162, 0x2983, 0x18E1, 0x1101, 0x2182, 0x4AA7, 0x2183, 0x1942, 0x2162, 0x2162, 0x2162, 0x2142, 0x4247, 0x4A67, 0x18E1, 0x2143, 0x18C2, 0x18C2, 0x10C1, 0x10E1, 0x2183, 0x29A3, 0x2162, 0x2162, 0x21A3, 0x10E1, 0x10A1, 0x10A1, 0x10C1, 0x1902, 
        0x1902, 0x1922, 0x2162, 0x2183, 0x1902, 0x1902, 0x1942, 0x2183, 0x1921, 0x1902, 0x18E2, 0x10A1, 0x10C2, 0x1902, 0x1102, 0x1902, 0x1922, 0x1943, 0x1942, 0x29A3, 0x29A3, 0x2183, 0x1922, 0x1942, 0x1942, 0x2162, 0x2183, 0x29C3, 0x31E3, 0x1942, 
        0x1922, 0x1922, 0x1102, 0x1922, 0x1922, 0x1942, 0x2142, 0x2982, 0x2142, 0x3A04, 0x4224, 0x4224, 0x4204, 0x2962, 0x2162, 0x29A3, 0x31C3, 0x2982, 0x29C3, 0x29A3, 0x2162, 0x1942, 0x1962, 0x21A3, 0x29C4, 0x2163, 0x1101, 0x29A3, 0x29A3, 0x2182, 
        0x29C3, 0x29C3, 0x29A4, 0x1922, 0x10E2, 0x10C1, 0x10E2, 0x10E2, 0x10A1, 0x10A1, 0x10C1, 0x2164, 0x31E5, 0x3A05, 0x4266, 0x3205, 0x31E6, 0x3A26, 0x2984, 0x0881, 0x10A2, 0x0881, 0x0881, 0x10A1, 0x10C2, 0x18E2, 0x4AA8, 0x1102, 0x10E1, 0x10E1, 
        0x1102, 0x1922, 0x1122, 0x1122, 0x1922, 0x1942, 0x1102, 0x1902, 0x1942, 0x1922, 0x1102, 0x1922, 0x2183, 0x1962, 0x2162, 0x2163, 0x2163, 0x29C3, 0x3204, 0x3205, 0x2163, 0x31E4, 0x31E4, 0x31E4, 0x4AA6, 0x5AE7, 0x52C6, 0x52A6, 0x4A65, 0x4245, 
        0x4265, 0x3A05, 0x29A3, 0x2183, 0x2163, 0x29A4, 0x2163, 0x29A4, 0x2183, 0x2983, 0x2183, 0x2183, 0x2163, 0x1962, 0x2163, 0x1962, 0x21A3, 0x29E4, 0x29E3, 0x2162, 0x2162, 0x1921, 0x1101, 0x10E1, 0x1101, 0x1922, 0x1922, 0x10A1, 0x1922, 0x1942, 
        0x1921, 0x2162, 0x1922, 0x1101, 0x1922, 0x3204, 0x4264, 0x3A44, 0x1942, 0x1902, 0x1101, 0x2163, 0x6BAC, 0x6BAB, 0x4AE7, 0x42A6, 0x4AA6, 0x4285, 0x29A2, 0x1921, 0x1962, 0x29E3, 0x29E3, 0x2182, 0x1101, 0x1922, 0x1101, 0x1942, 0x29A2,
  0x61C6, 0x4124, 0x3103, 0x4144, 0x632C, 0x6AEB, 0x61C6, 0x5185, 0x28C2, 0x3924, 0x61C6, 0x69E6, 0x69E6, 0x61E6, 0x3903, 0x3924, 0x5185, 0x69E6, 0x69E6, 0x6A06, 0x4964, 0x3924, 0x5185, 0x69E6, 0x69E6, 0x69E6, 0x5165, 0x30E3, 0x4944, 0x69E6, 0x61C5, 
        0x69E6, 0x5165, 0x3103, 0x4144, 0x5206, 0x5A27, 0x49C6, 0x4965, 0x3903, 0x4965, 0x69E7, 0x5185, 0x69E6, 0x4945, 0x38E3, 0x5165, 0x6A06, 0x7206, 0x6A06, 0x4144, 0x3903, 0x59A5, 0x61C6, 0x5184, 0x61C6, 0x30E3, 0x3923, 0x61E6, 0x7207, 0x7206, 
        0x5185, 0x30E3, 0x4144, 0x61E6, 0x5165, 0x61E6, 0x3903, 0x3903, 0x59A5, 0x6A06, 0x6A27, 0x5185, 0x30E3, 0x4985, 0x61E6, 0x5985, 0x61C6, 0x30E3, 0x3924, 0x61E6, 0x6A06, 0x6A06, 0x4944, 0x3903, 0x59A5, 0x69E6, 0x69E6, 0x5185, 0x30E3, 0x4964, 
        0x6A06, 0x71E6, 0x61C6, 0x30E3, 0x4944, 0x6A06, 0x6A06, 0x69E6, 0x38E3, 0x4964, 0x69E6, 0x71E6, 0x69C6, 0x3903, 0x4144, 0x7206, 0x8247, 0x7207, 0x4103, 0x4944, 0x7206, 0x7227, 0x69E6, 0x38E3, 0x5165, 0x7207, 0x7206, 0x5985, 0x3903, 0x5185, 
        0x7206, 0x7207, 0x4944, 0x3903, 0x61C5, 0x7207, 0x7207, 0x4944, 0x4944, 0x7227, 0x7A27, 0x69E6, 0x3903, 0x59A5, 0x7A27, 0x7A27, 0x5185, 0x4124, 0x61E6, 0x7A27, 0x6A06, 0x3903, 0x4985, 0x7BCE, 0x730B, 0x51A5, 0x4124, 0x7207, 0x7A47, 0x6A07, 
        0x3903, 0x59A6, 0x7A28, 0x7A27, 0x4944, 0x4944, 0x71E7, 0x71E7, 0x5164, 0x3903, 0x61C5, 0x6A68, 0x4A06, 0x5AC9, 0x6B4B, 0x4206, 0x5A07, 0x4124, 0x59A5, 0x7207, 0x7206, 0x5164, 0x5985, 0x7206, 0x6A06, 0x6206, 0x4964, 0x6207, 0x5A06, 0x5A06, 
        0x4984, 0x61E6, 0x6247, 0x6A47, 0x5164, 0x6A07, 0x730A, 0x6AA9, 0x5164, 0x6227, 0x9C4F, 0x72EA, 0x4944, 0x72E9, 0xBD54, 0x6AA9, 0x4985, 0x730A, 0x942E, 0x6268, 0x51E6, 0x7B8D, 0x942F, 0x6289, 0x5A68, 0x736C, 0x7B8C, 0x5267, 0x5247, 0x5A68, 
        0x5A68, 0x51E6, 0x49C6, 0x49E6, 0x5207, 0x51E6, 0x51C5, 0x51A5, 0x4985, 0x51A5, 0x4965, 0x3903, 0x51A5, 0x4985, 0x5185, 0x51A5, 0x30E3, 0x4964, 0x59C6, 0x59C6, 0x5185, 0x4965, 0x3103, 0x4944, 0x59A5, 0x5185, 0x59E6, 0x51E6, 0x5165, 0x5985, 
        0x5985, 0x5985, 0x69E6, 0x6A06, 0x5185, 0x61E6, 0x7AC9, 0x7288, 0x6206, 0x5185, 0x6A47, 0x59C5, 0x7248, 0x61C6, 0x6A27, 0x6A47, 0x61E6, 0x7AA9, 0x7A89, 0x7A88, 0x59A5, 0x7A68, 0x7A88, 0x3123, 0x10A1, 0x10C1, 0x10A1, 0x18E1, 0x2163, 0x1922, 
        0x1922, 0x2163, 0x1902, 0x1902, 0x29A3, 0x4AC7, 0x2183, 0x2163, 0x2182, 0x2983, 0x29C3, 0x2162, 0x4247, 0x52A9, 0x2123, 0x2123, 0x2103, 0x18E2, 0x10C1, 0x10C1, 0x2183, 0x21A3, 0x21A2, 0x3204, 0x3204, 0x29A3, 0x1922, 0x10C1, 0x10E1, 0x10A1, 
        0x1922, 0x2183, 0x2183, 0x2142, 0x1922, 0x1902, 0x2162, 0x2182, 0x2142, 0x10E1, 0x10C1, 0x10A1, 0x10C2, 0x1102, 0x10C1, 0x10E1, 0x10C1, 0x10E1, 0x1922, 0x2142, 0x2183, 0x2183, 0x10E1, 0x1922, 0x2142, 0x2142, 0x1942, 0x2182, 0x29C3, 0x29C3, 
        0x1922, 0x10E1, 0x10E1, 0x10E1, 0x1102, 0x1922, 0x1902, 0x2962, 0x2983, 0x2962, 0x3183, 0x31C3, 0x3A04, 0x31A3, 0x2142, 0x2142, 0x2183, 0x2162, 0x2983, 0x29A3, 0x2142, 0x1101, 0x2162, 0x2182, 0x2183, 0x2163, 0x1101, 0x2183, 0x2183, 0x2183, 
        0x29E4, 0x29E3, 0x29C4, 0x1942, 0x10E1, 0x10C1, 0x10C1, 0x10C1, 0x10C1, 0x08A1, 0x1102, 0x29A5, 0x29A5, 0x29A4, 0x1942, 0x2163, 0x10C1, 0x1902, 0x1102, 0x10C2, 0x10A2, 0x10A2, 0x10A1, 0x10A1, 0x10E2, 0x1902, 0x4A88, 0x1102, 0x10E1, 0x10E2, 
        0x1922, 0x1942, 0x1922, 0x1942, 0x1942, 0x1942, 0x1102, 0x10E1, 0x1902, 0x08A1, 0x08C1, 0x1902, 0x1922, 0x2183, 0x2183, 0x2183, 0x2163, 0x29A3, 0x29E3, 0x21A3, 0x2163, 0x4246, 0x31E4, 0x4245, 0x4A85, 0x4AA6, 0x52C6, 0x52C6, 0x4265, 0x31E4, 
        0x4A86, 0x3A05, 0x1942, 0x1943, 0x2163, 0x29A3, 0x1942, 0x1942, 0x1942, 0x29A3, 0x29C4, 0x29A4, 0x2183, 0x2142, 0x2162, 0x2183, 0x29A3, 0x3A24, 0x31E3, 0x2162, 0x2162, 0x2162, 0x1942, 0x1101, 0x1942, 0x1922, 0x1902, 0x10C1, 0x1902, 0x10E1, 
        0x2162, 0x1962, 0x1921, 0x2162, 0x29C3, 0x31E3, 0x31E2, 0x31C3, 0x1942, 0x0881, 0x10C2, 0x1943, 0x3A46, 0x5309, 0x5329, 0x4AA7, 0x4265, 0x4AA6, 0x4286, 0x1921, 0x31E3, 0x3A44, 0x4AA5, 0x3223, 0x2162, 0x1942, 0x2162, 0x1101, 0x1901,
  0x61C6, 0x4985, 0x4165, 0x49A5, 0x6B6D, 0x6AEB, 0x61C6, 0x4985, 0x3103, 0x3944, 0x61C6, 0x69E6, 0x6A06, 0x61E6, 0x30E3, 0x30E3, 0x4965, 0x69E6, 0x69E6, 0x69E6, 0x4965, 0x4164, 0x59E6, 0x6A27, 0x6A06, 0x71E6, 0x5185, 0x3103, 0x4964, 0x69E6, 0x71E6, 
        0x69E6, 0x51A5, 0x3985, 0x3923, 0x61C6, 0x61C6, 0x61C6, 0x5165, 0x3903, 0x4964, 0x69E6, 0x69E6, 0x6A07, 0x4944, 0x3903, 0x5165, 0x6A07, 0x7207, 0x7207, 0x4144, 0x3903, 0x59A5, 0x61E6, 0x59A5, 0x59C6, 0x30E3, 0x3924, 0x61C6, 0x6A06, 0x7207, 
        0x5185, 0x30E3, 0x4144, 0x61E6, 0x5185, 0x61E6, 0x3903, 0x3903, 0x59A5, 0x6A06, 0x6A07, 0x5185, 0x30E3, 0x4985, 0x61E6, 0x5185, 0x61C6, 0x30E3, 0x4124, 0x61E6, 0x7227, 0x7268, 0x51A5, 0x38E3, 0x59C5, 0x61C6, 0x59A5, 0x5185, 0x30E3, 0x4965, 
        0x6A07, 0x7207, 0x61E6, 0x30E3, 0x4965, 0x69E6, 0x61A5, 0x69E6, 0x38E3, 0x4964, 0x6A06, 0x7206, 0x69E6, 0x3903, 0x4944, 0x7206, 0x7206, 0x7A27, 0x4103, 0x4944, 0x6A06, 0x7207, 0x61C6, 0x38E3, 0x5185, 0x7207, 0x7207, 0x5985, 0x3903, 0x5185, 
        0x7206, 0x7207, 0x4944, 0x3903, 0x61C5, 0x7207, 0x7206, 0x4924, 0x4124, 0x7207, 0x7A27, 0x69E6, 0x3903, 0x59A5, 0x7A27, 0x7A27, 0x5185, 0x4124, 0x61C6, 0x7A27, 0x69E6, 0x3903, 0x4985, 0x840F, 0x834C, 0x51A5, 0x4124, 0x7206, 0x8247, 0x7206, 
        0x4124, 0x61A6, 0x8247, 0x7A47, 0x4965, 0x4965, 0x7A27, 0x7A47, 0x5985, 0x4124, 0x7207, 0x7A27, 0x61E6, 0x4A47, 0x52A9, 0x6ACA, 0x6A48, 0x4103, 0x59A5, 0x7A68, 0x7227, 0x4123, 0x5184, 0x7227, 0x7227, 0x4964, 0x4144, 0x6A07, 0x6A07, 0x5185, 
        0x4944, 0x6A07, 0x61E6, 0x5164, 0x4944, 0x7207, 0x59E6, 0x51A5, 0x5164, 0x69C6, 0x59C5, 0x61E6, 0x5185, 0x61E6, 0x6227, 0x61C6, 0x59A5, 0x6206, 0x6A68, 0x59C5, 0x61E6, 0x5A27, 0x7AEA, 0x51A5, 0x61E6, 0x6AA9, 0x72CA, 0x4985, 0x6248, 0x7B6C, 
        0x6268, 0x51A5, 0x72EA, 0x836C, 0x59E6, 0x6206, 0x7B4B, 0x72EA, 0x51C6, 0x6268, 0x730A, 0x6247, 0x6227, 0x6AEA, 0x72C9, 0x59E6, 0x5206, 0x6289, 0x6228, 0x59E6, 0x6A88, 0x6A69, 0x4964, 0x4964, 0x5185, 0x5185, 0x4123, 0x30C2, 0x4964, 0x5985, 
        0x5164, 0x5985, 0x69E6, 0x59A5, 0x5185, 0x61E6, 0x51A5, 0x6A27, 0x59A5, 0x59C6, 0x6206, 0x5185, 0x61E6, 0x5185, 0x6A07, 0x51A5, 0x61E6, 0x61C6, 0x6A48, 0x61E6, 0x5985, 0x6A07, 0x6A27, 0x3143, 0x2944, 0x2103, 0x2123, 0x2122, 0x2122, 0x2122, 
        0x2122, 0x2142, 0x10E1, 0x1901, 0x2162, 0x4287, 0x2162, 0x1921, 0x2142, 0x29A3, 0x29C3, 0x2122, 0x4A87, 0x6B4B, 0x31A4, 0x2143, 0x18E2, 0x10E1, 0x2142, 0x2163, 0x2983, 0x31E4, 0x31E3, 0x31E3, 0x3224, 0x29E3, 0x2162, 0x29C3, 0x29A3, 0x1922, 
        0x1102, 0x1922, 0x1942, 0x1922, 0x1922, 0x2162, 0x29A3, 0x2183, 0x2162, 0x2142, 0x1922, 0x1902, 0x1922, 0x1922, 0x10E1, 0x1922, 0x1902, 0x10E2, 0x2143, 0x29A4, 0x29A3, 0x1922, 0x2142, 0x1922, 0x1922, 0x1922, 0x1942, 0x1942, 0x29A3, 0x31E4, 
        0x29A3, 0x1942, 0x10E1, 0x1922, 0x2142, 0x1902, 0x10E1, 0x18E2, 0x18E1, 0x18E1, 0x18E1, 0x10C1, 0x1902, 0x1902, 0x10E1, 0x1922, 0x1922, 0x1922, 0x2162, 0x29A3, 0x2163, 0x1942, 0x29A3, 0x29A3, 0x1922, 0x1922, 0x1942, 0x1942, 0x1922, 0x1942, 
        0x2182, 0x21A3, 0x1942, 0x1922, 0x1922, 0x10C2, 0x10C1, 0x10E2, 0x10E2, 0x10A1, 0x1903, 0x3206, 0x1923, 0x10C1, 0x10E1, 0x1922, 0x1922, 0x10E2, 0x10C2, 0x10C1, 0x08A1, 0x08A1, 0x10C2, 0x10C1, 0x08C1, 0x1902, 0x4288, 0x1902, 0x10E2, 0x10E2, 
        0x1902, 0x1922, 0x1922, 0x1922, 0x1902, 0x1102, 0x1922, 0x1922, 0x1922, 0x10A1, 0x10E1, 0x10E2, 0x1902, 0x1942, 0x2162, 0x2162, 0x2162, 0x21A3, 0x29A3, 0x29A3, 0x2163, 0x4225, 0x4225, 0x4A86, 0x4AA6, 0x4245, 0x4A85, 0x4265, 0x3A04, 0x31E4, 
        0x29A3, 0x29C4, 0x1943, 0x1102, 0x1943, 0x1943, 0x1102, 0x1102, 0x1922, 0x2183, 0x29C4, 0x2122, 0x2163, 0x31C4, 0x39E4, 0x31E4, 0x3204, 0x3A24, 0x29C3, 0x2182, 0x1942, 0x1921, 0x1942, 0x1101, 0x1101, 0x1101, 0x10C1, 0x0881, 0x1922, 0x31E3, 
        0x3204, 0x2182, 0x2182, 0x2162, 0x29A2, 0x21A2, 0x2182, 0x2182, 0x29C5, 0x4AEA, 0x532A, 0x2183, 0x2182, 0x2182, 0x1941, 0x3204, 0x4266, 0x4286, 0x4A87, 0x29A3, 0x29E2, 0x3A23, 0x4264, 0x3A64, 0x29E3, 0x1101, 0x1922, 0x1922, 0x1942,
  0x61C6, 0x6227, 0x6A88, 0x6268, 0x6B8E, 0x6AEB, 0x61A5, 0x59C6, 0x5227, 0x5A68, 0x6A07, 0x69E6, 0x6A06, 0x61E6, 0x51C6, 0x5206, 0x5A07, 0x69E6, 0x69E6, 0x69E6, 0x49A5, 0x41A5, 0x59E6, 0x69E6, 0x69E6, 0x7206, 0x5185, 0x3924, 0x49A5, 0x69E6, 0x69E6, 
        0x69E6, 0x51C5, 0x3985, 0x3944, 0x61E6, 0x69E6, 0x69E7, 0x5185, 0x30E3, 0x4944, 0x69E6, 0x69E6, 0x6A06, 0x4944, 0x38E3, 0x4965, 0x6A06, 0x7207, 0x6A07, 0x4144, 0x3903, 0x59A5, 0x69E7, 0x6A06, 0x61C6, 0x30E3, 0x4124, 0x59C6, 0x6A06, 0x6A07, 
        0x5185, 0x30E3, 0x4124, 0x61E6, 0x61E6, 0x61E6, 0x38E3, 0x3903, 0x59A5, 0x69E6, 0x6A06, 0x5185, 0x30E3, 0x5185, 0x61E6, 0x59A5, 0x61C6, 0x30E3, 0x3924, 0x59E6, 0x72C9, 0x7B4C, 0x7B2B, 0x4124, 0x59A5, 0x61C6, 0x59A5, 0x5185, 0x30E3, 0x4965, 
        0x7207, 0x7207, 0x61E6, 0x30E3, 0x4965, 0x61E6, 0x5985, 0x69E6, 0x3903, 0x4964, 0x6A06, 0x7206, 0x69E6, 0x3903, 0x4964, 0x6A06, 0x61A5, 0x7227, 0x4103, 0x4144, 0x6A06, 0x7207, 0x61C6, 0x38E3, 0x5185, 0x69E7, 0x61C6, 0x59A5, 0x38E3, 0x5185, 
        0x7206, 0x6A07, 0x4944, 0x3903, 0x61A6, 0x69E6, 0x6A06, 0x4144, 0x4124, 0x7207, 0x7A27, 0x69E6, 0x3923, 0x59A5, 0x7227, 0x7227, 0x5164, 0x4123, 0x69E6, 0x7A27, 0x6A06, 0x4144, 0x49C5, 0x8C30, 0x832C, 0x5185, 0x4124, 0x6A06, 0x7A27, 0x6A06, 
        0x4103, 0x59A5, 0x7A27, 0x7A27, 0x4964, 0x4965, 0x7A27, 0x7A47, 0x5985, 0x4123, 0x71E7, 0x7A27, 0x6A07, 0x5268, 0x636C, 0x6AEA, 0x6A27, 0x3903, 0x59A5, 0x7A68, 0x7247, 0x4124, 0x5185, 0x7A47, 0x7A47, 0x4944, 0x4944, 0x7247, 0x7247, 0x5185, 
        0x4944, 0x7A47, 0x7A48, 0x5165, 0x4944, 0x7227, 0x7A47, 0x5185, 0x4944, 0x7206, 0x69E6, 0x5164, 0x5164, 0x69E6, 0x69E6, 0x5164, 0x5185, 0x6A07, 0x61E6, 0x4944, 0x59C6, 0x61E6, 0x59E6, 0x4964, 0x6A07, 0x61E6, 0x59C6, 0x4964, 0x61E6, 0x61E6, 
        0x59C6, 0x5185, 0x61E6, 0x6A47, 0x5185, 0x61E6, 0x6227, 0x6227, 0x5985, 0x6A07, 0x6A68, 0x59C5, 0x61C6, 0x6A88, 0x7AC9, 0x5164, 0x6207, 0x7B0B, 0x6227, 0x5185, 0x6AA9, 0x6A89, 0x4985, 0x5185, 0x5985, 0x5985, 0x5165, 0x4924, 0x5185, 0x61A6, 
        0x6A48, 0x8B2B, 0x7A88, 0x61E6, 0x6A27, 0x6A27, 0x61E6, 0x6A27, 0x59C6, 0x6A07, 0x61E6, 0x61E6, 0x61E6, 0x59C6, 0x61E6, 0x59A5, 0x6A06, 0x5164, 0x69E6, 0x61C6, 0x61A6, 0x6A06, 0x6A27, 0x4964, 0x62A9, 0x62CA, 0x41A5, 0x6AEA, 0x5A68, 0x3985, 
        0x5AA9, 0x4206, 0x39A5, 0x4A67, 0x4226, 0x632A, 0x5B09, 0x4226, 0x4A66, 0x4A66, 0x2963, 0x2983, 0x5B0A, 0x73AD, 0x1922, 0x31A4, 0x2142, 0x10C1, 0x2122, 0x1942, 0x1921, 0x2162, 0x29A3, 0x29A2, 0x29E3, 0x3203, 0x29C3, 0x29E3, 0x29A3, 0x1942, 
        0x2162, 0x1902, 0x1902, 0x2163, 0x2183, 0x2983, 0x2183, 0x2182, 0x2183, 0x2162, 0x1101, 0x1922, 0x1922, 0x1942, 0x1922, 0x1943, 0x1943, 0x1922, 0x2163, 0x2983, 0x2983, 0x2983, 0x2983, 0x1902, 0x1102, 0x1101, 0x1922, 0x1922, 0x1921, 0x2142, 
        0x2982, 0x29A3, 0x3224, 0x4285, 0x3224, 0x1101, 0x10C1, 0x10A1, 0x10C1, 0x10C1, 0x10A1, 0x10A1, 0x10A1, 0x10E1, 0x10E1, 0x1902, 0x10E2, 0x10E2, 0x1102, 0x10E1, 0x1922, 0x1942, 0x2183, 0x29A3, 0x2183, 0x1942, 0x2183, 0x1942, 0x1922, 0x1942, 
        0x29A3, 0x2183, 0x1102, 0x10E2, 0x1102, 0x10E2, 0x10C2, 0x10E2, 0x10E2, 0x10C2, 0x29A5, 0x31E6, 0x10C1, 0x1902, 0x1942, 0x1922, 0x10E2, 0x10C2, 0x10A2, 0x1081, 0x10A2, 0x10C1, 0x10A1, 0x08A1, 0x08A1, 0x18E2, 0x4A88, 0x1922, 0x10E2, 0x10E1, 
        0x1922, 0x1902, 0x1902, 0x1942, 0x1922, 0x10E1, 0x1902, 0x1922, 0x1922, 0x2142, 0x2163, 0x1922, 0x1102, 0x1922, 0x1942, 0x1942, 0x21A3, 0x29C3, 0x29A3, 0x2183, 0x2163, 0x31C4, 0x3A45, 0x3A24, 0x31E3, 0x4245, 0x52C6, 0x4A86, 0x29C3, 0x2142, 
        0x2142, 0x1943, 0x1102, 0x1102, 0x1902, 0x1922, 0x1902, 0x10E2, 0x10E2, 0x1922, 0x1943, 0x2143, 0x29A4, 0x2983, 0x3A25, 0x4AA6, 0x4AC6, 0x3A24, 0x2182, 0x1922, 0x1942, 0x2162, 0x21A3, 0x1942, 0x10C1, 0x10A1, 0x10A1, 0x10E1, 0x29A3, 0x2182, 
        0x2182, 0x1922, 0x1901, 0x2142, 0x29A3, 0x31E4, 0x3205, 0x3A66, 0x3226, 0x2183, 0x1102, 0x10C1, 0x1101, 0x29C3, 0x2983, 0x1901, 0x1922, 0x2163, 0x52C8, 0x3A65, 0x29C2, 0x29E2, 0x29C2, 0x3223, 0x4264, 0x29E3, 0x1942, 0x1102, 0x10E1,
  0x69E6, 0x69E6, 0x6A07, 0x59E6, 0x6B8D, 0x6AEB, 0x61A5, 0x6A06, 0x6A27, 0x6A27, 0x6A07, 0x61C6, 0x59A5, 0x69E6, 0x6A27, 0x6A47, 0x6A27, 0x69E6, 0x69E6, 0x69E6, 0x6206, 0x6247, 0x6A27, 0x69E6, 0x69E6, 0x69E6, 0x61E6, 0x6247, 0x6268, 0x6A06, 0x69E6, 
        0x61E6, 0x51C6, 0x49E6, 0x5227, 0x6207, 0x61E6, 0x69E6, 0x59C6, 0x5207, 0x6227, 0x6A06, 0x6A07, 0x69E7, 0x59C6, 0x51E6, 0x59E6, 0x6A07, 0x7207, 0x7207, 0x4144, 0x3923, 0x59A5, 0x6A07, 0x6A06, 0x59C6, 0x30C2, 0x3923, 0x59E6, 0x6A07, 0x6A26, 
        0x4985, 0x30E3, 0x4144, 0x61E6, 0x6A06, 0x61E6, 0x30E3, 0x3903, 0x59A5, 0x69E6, 0x6A06, 0x5185, 0x30E3, 0x4985, 0x6A06, 0x6A06, 0x59C6, 0x3924, 0x4165, 0x51A5, 0x59E6, 0x59E6, 0x4165, 0x3103, 0x59A5, 0x69E6, 0x69E6, 0x5185, 0x30E3, 0x4964, 
        0x7207, 0x7207, 0x61C6, 0x38E3, 0x4964, 0x61E6, 0x61A5, 0x69E6, 0x3103, 0x4964, 0x6A06, 0x7206, 0x69E6, 0x3904, 0x4964, 0x6A07, 0x61C5, 0x7247, 0x3903, 0x4944, 0x6A06, 0x7206, 0x61C6, 0x3903, 0x5185, 0x69E7, 0x61A5, 0x59A5, 0x38E3, 0x5185, 
        0x6A06, 0x6A27, 0x4144, 0x30E3, 0x61C6, 0x59A5, 0x61C6, 0x4123, 0x4144, 0x7227, 0x7A27, 0x69E6, 0x3924, 0x59A5, 0x69E6, 0x69E6, 0x5185, 0x3923, 0x61C6, 0x7227, 0x6A27, 0x4164, 0x49C5, 0x8430, 0x7B2B, 0x5185, 0x4124, 0x69E6, 0x7A27, 0x7206, 
        0x4103, 0x59A5, 0x7A27, 0x7A27, 0x4965, 0x4965, 0x7A27, 0x7A47, 0x5985, 0x4123, 0x69E7, 0x7A27, 0x61C6, 0x41E7, 0x6B6D, 0x72A9, 0x7247, 0x3903, 0x59A5, 0x7A67, 0x7227, 0x4124, 0x5185, 0x7A47, 0x7A47, 0x4944, 0x4944, 0x7227, 0x7A47, 0x5165, 
        0x4944, 0x7A47, 0x7A47, 0x5185, 0x4944, 0x7A27, 0x7A47, 0x59A5, 0x5165, 0x8227, 0x7A47, 0x59A5, 0x5985, 0x7A47, 0x7A27, 0x5185, 0x59A5, 0x7A47, 0x7227, 0x4943, 0x61C6, 0x7A48, 0x69E6, 0x4144, 0x6A06, 0x7247, 0x59A5, 0x4944, 0x7207, 0x7207, 
        0x4964, 0x5185, 0x7207, 0x61E6, 0x4124, 0x61E6, 0x6A06, 0x5185, 0x5164, 0x6A06, 0x69E6, 0x4944, 0x61C5, 0x69E6, 0x61C5, 0x5144, 0x69E6, 0x69E6, 0x5985, 0x5985, 0x59C6, 0x51A5, 0x51A5, 0x59A6, 0x59A6, 0x59A5, 0x5965, 0x5165, 0x61C6, 0x69E6, 
        0x7248, 0x82C9, 0x82A9, 0x8288, 0x7A88, 0x8289, 0x7A68, 0x7A88, 0x7A88, 0x7A68, 0x7A88, 0x7268, 0x7A68, 0x7248, 0x7A68, 0x7A68, 0x7A68, 0x7247, 0x7268, 0x6A27, 0x7A89, 0x7A89, 0x51A5, 0x5165, 0x61E7, 0x5A07, 0x5185, 0x6A48, 0x5A07, 0x51A5, 
        0x6AA9, 0x59E6, 0x59E6, 0x72EA, 0x51E6, 0x7B4B, 0x9C6F, 0x49C5, 0x7B4B, 0x838C, 0x41A5, 0x62C9, 0x83EE, 0x73CE, 0x4A27, 0x39C5, 0x632A, 0x6B0A, 0x39E5, 0x3A05, 0x31A4, 0x29A3, 0x29A3, 0x29E4, 0x31E3, 0x3203, 0x29E3, 0x1921, 0x29E3, 0x2982, 
        0x1921, 0x29A3, 0x10E1, 0x1922, 0x2983, 0x2182, 0x1941, 0x2162, 0x2162, 0x2142, 0x10E1, 0x10C1, 0x10C1, 0x1902, 0x1902, 0x2143, 0x1942, 0x10E2, 0x10E2, 0x2163, 0x29A3, 0x1942, 0x10E1, 0x1922, 0x1922, 0x1922, 0x2162, 0x2163, 0x1922, 0x2182, 
        0x29C3, 0x42A6, 0x42A5, 0x4AC6, 0x4AC6, 0x3A45, 0x3204, 0x3225, 0x2163, 0x10E1, 0x10E2, 0x08A1, 0x0881, 0x10A1, 0x10C1, 0x10C2, 0x10C1, 0x10C1, 0x10C1, 0x10E2, 0x1922, 0x2163, 0x2142, 0x2162, 0x1942, 0x2162, 0x1942, 0x1942, 0x2182, 0x2182, 
        0x29C3, 0x29A3, 0x1942, 0x10E1, 0x10C1, 0x10C1, 0x10C2, 0x10C1, 0x10C1, 0x10E1, 0x31C5, 0x29C5, 0x10E1, 0x1942, 0x2163, 0x1902, 0x10C1, 0x08A2, 0x08A2, 0x10C2, 0x10C1, 0x10C2, 0x10C2, 0x10A2, 0x1081, 0x18E2, 0x4AA8, 0x1942, 0x1902, 0x1902, 
        0x1922, 0x10E2, 0x1902, 0x1102, 0x1102, 0x10C1, 0x10C1, 0x1902, 0x10E1, 0x1942, 0x2183, 0x1102, 0x1102, 0x1922, 0x1922, 0x1942, 0x2183, 0x29A3, 0x29C4, 0x29A3, 0x2163, 0x2163, 0x3205, 0x29A3, 0x31E3, 0x4A85, 0x52A6, 0x4A85, 0x4A65, 0x4225, 
        0x2983, 0x10E1, 0x10E1, 0x10E2, 0x1922, 0x1922, 0x1902, 0x10E2, 0x10E2, 0x1902, 0x18E2, 0x2123, 0x2983, 0x2983, 0x29C3, 0x4245, 0x3A24, 0x29C2, 0x2162, 0x1922, 0x2183, 0x21A3, 0x1942, 0x10C1, 0x1101, 0x10E1, 0x1902, 0x29A3, 0x2982, 0x2162, 
        0x10E1, 0x08A1, 0x1903, 0x2143, 0x31C5, 0x3205, 0x4267, 0x52E9, 0x3A46, 0x1102, 0x08A1, 0x0060, 0x0040, 0x10A1, 0x1902, 0x0880, 0x10C1, 0x10A0, 0x4246, 0x4AA7, 0x2182, 0x3203, 0x2182, 0x29C2, 0x29C3, 0x2162, 0x08C1, 0x10E2, 0x08C1,
  0x69E6, 0x69E6, 0x69E6, 0x6207, 0x6B8D, 0x6AEB, 0x61C6, 0x6A06, 0x6A07, 0x7207, 0x69E6, 0x59A5, 0x4964, 0x6A06, 0x7207, 0x7206, 0x6A06, 0x69E6, 0x69E6, 0x69E6, 0x6A06, 0x7206, 0x69E6, 0x69E6, 0x5985, 0x61C6, 0x69E6, 0x6A07, 0x6A06, 0x69E6, 0x69E6, 
        0x61E6, 0x6207, 0x6207, 0x6207, 0x69E6, 0x61C6, 0x61C6, 0x6206, 0x6247, 0x6227, 0x69E6, 0x6A06, 0x69E6, 0x72A9, 0x834B, 0x7ACA, 0x7227, 0x7207, 0x69E6, 0x6227, 0x62A8, 0x6A48, 0x6A07, 0x6A06, 0x61E6, 0x49C5, 0x5206, 0x59E6, 0x6A07, 0x6A27, 
        0x49A5, 0x3944, 0x49A5, 0x6206, 0x6A06, 0x61E6, 0x3923, 0x4164, 0x59C6, 0x6A06, 0x6A06, 0x5185, 0x3123, 0x4985, 0x6A06, 0x6A06, 0x59E6, 0x41C6, 0x41A5, 0x59A5, 0x69E6, 0x69E7, 0x4144, 0x30E2, 0x59A5, 0x69E6, 0x69E7, 0x4965, 0x30E2, 0x4964, 
        0x6A07, 0x7207, 0x61E6, 0x3103, 0x4964, 0x6A07, 0x69E7, 0x69E6, 0x3903, 0x4965, 0x6A06, 0x7206, 0x61E6, 0x3903, 0x4144, 0x6A07, 0x6A06, 0x6A27, 0x3903, 0x4944, 0x6A07, 0x7207, 0x61E6, 0x3903, 0x5185, 0x6A07, 0x61C6, 0x51A5, 0x3103, 0x5185, 
        0x6A88, 0x836C, 0x8BAD, 0x4985, 0x59C6, 0x59C6, 0x6A47, 0x51C5, 0x4985, 0x7207, 0x7A27, 0x69E6, 0x3903, 0x59A5, 0x69E6, 0x61C6, 0x5185, 0x3903, 0x61C6, 0x7207, 0x69E6, 0x3903, 0x49A5, 0x8C30, 0x832C, 0x5185, 0x4123, 0x6A06, 0x7A27, 0x71E6, 
        0x4103, 0x61C5, 0x69E6, 0x69E6, 0x4964, 0x4984, 0x7227, 0x7A27, 0x5185, 0x4123, 0x69E6, 0x7207, 0x59A5, 0x41A6, 0x73AE, 0x7AA9, 0x7A88, 0x4124, 0x5185, 0x7247, 0x7227, 0x4123, 0x5165, 0x7227, 0x7227, 0x4944, 0x4944, 0x7227, 0x7A47, 0x5165, 
        0x4944, 0x7227, 0x7A47, 0x5185, 0x4944, 0x7227, 0x7A27, 0x5185, 0x5164, 0x7A27, 0x7A47, 0x5985, 0x5985, 0x8247, 0x7A27, 0x5164, 0x59A5, 0x7A47, 0x7227, 0x4124, 0x61A6, 0x7A27, 0x69E6, 0x4124, 0x6A06, 0x7A47, 0x59A5, 0x4944, 0x7A27, 0x7A27, 
        0x4965, 0x61C6, 0x8247, 0x69E6, 0x4944, 0x7207, 0x7A47, 0x5185, 0x5165, 0x7A47, 0x7227, 0x4124, 0x61C6, 0x7A47, 0x59A5, 0x4923, 0x6A06, 0x69E6, 0x4924, 0x5165, 0x61A5, 0x5185, 0x5185, 0x61C6, 0x69C6, 0x69E6, 0x5985, 0x5965, 0x69E6, 0x69E6, 
        0x69C6, 0x7A27, 0x92A9, 0x92A9, 0x92C9, 0x92A9, 0x92A9, 0x8AA9, 0x8AA9, 0x8AA9, 0x8AA9, 0x8AA9, 0x8AA9, 0x8AA9, 0x92A9, 0x92A9, 0x8A88, 0x8AA9, 0x82A8, 0x8288, 0x82A9, 0x82E9, 0x4964, 0x4944, 0x6A06, 0x5185, 0x5185, 0x69E7, 0x4944, 0x5185, 
        0x69E7, 0x5164, 0x61E6, 0x61E6, 0x51A5, 0x6AA9, 0x6227, 0x59A5, 0x6207, 0x6207, 0x5185, 0x6A48, 0x83EE, 0x7BCE, 0x6AEA, 0x51C6, 0x72EA, 0x8BAD, 0x4964, 0x6AA9, 0x5A68, 0x5247, 0x7B8C, 0x5267, 0x5AC8, 0x6B2A, 0x4A25, 0x52A7, 0x4A46, 0x4A66, 
        0x52A7, 0x4246, 0x2983, 0x18E2, 0x1922, 0x2983, 0x2983, 0x2142, 0x29A3, 0x2162, 0x10C1, 0x10E1, 0x10C1, 0x10E1, 0x08A0, 0x1922, 0x2142, 0x1922, 0x10E1, 0x1902, 0x2183, 0x1942, 0x1102, 0x1922, 0x1942, 0x2142, 0x2162, 0x2183, 0x2162, 0x21A2, 
        0x3A65, 0x42A6, 0x42A5, 0x4AC6, 0x4AE6, 0x42C5, 0x42C6, 0x4B07, 0x3204, 0x1922, 0x1902, 0x0881, 0x1081, 0x10A1, 0x10E2, 0x10C2, 0x10E2, 0x10E2, 0x10E2, 0x10E2, 0x1902, 0x2142, 0x2162, 0x2142, 0x10C1, 0x10E1, 0x1902, 0x2142, 0x29C4, 0x3204, 
        0x31E4, 0x2182, 0x1922, 0x1902, 0x10E1, 0x10E2, 0x10E2, 0x10A1, 0x10C2, 0x08A1, 0x31C5, 0x29A4, 0x1901, 0x1922, 0x2183, 0x1942, 0x10E1, 0x08A1, 0x08A1, 0x10E2, 0x1922, 0x1102, 0x1902, 0x10C1, 0x0881, 0x18C2, 0x4AA8, 0x2163, 0x1922, 0x10E2, 
        0x10E1, 0x10E2, 0x1902, 0x10E2, 0x1102, 0x10E2, 0x10C1, 0x1102, 0x10E2, 0x1902, 0x2163, 0x10E2, 0x10E2, 0x1922, 0x1922, 0x1942, 0x2162, 0x2162, 0x29A3, 0x29E4, 0x21A3, 0x21A3, 0x29C3, 0x29A3, 0x31C3, 0x4A65, 0x52C6, 0x4A85, 0x52C6, 0x5AE7, 
        0x3A04, 0x2163, 0x1922, 0x10C1, 0x1922, 0x1922, 0x1902, 0x10E2, 0x10C2, 0x1902, 0x18E2, 0x10E2, 0x2142, 0x29A3, 0x29A3, 0x4245, 0x31E3, 0x2161, 0x10E1, 0x18E1, 0x2142, 0x1922, 0x08C1, 0x10E2, 0x2163, 0x1902, 0x1902, 0x2142, 0x10E1, 0x10A1, 
        0x0840, 0x10C2, 0x29A5, 0x1903, 0x29A5, 0x31E4, 0x3204, 0x3204, 0x1922, 0x08A1, 0x0881, 0x0060, 0x0861, 0x0861, 0x10A1, 0x10E1, 0x1902, 0x10A1, 0x2984, 0x4287, 0x1921, 0x3224, 0x29A2, 0x2182, 0x29C3, 0x1922, 0x08A1, 0x10E1, 0x10E1,
  0x69E6, 0x69E6, 0x69E6, 0x6207, 0x738D, 0x6ACA, 0x61C6, 0x6A07, 0x69E6, 0x6A06, 0x6A06, 0x59C6, 0x4984, 0x6A07, 0x6A07, 0x6A07, 0x6A07, 0x6A06, 0x69E6, 0x69E6, 0x61E6, 0x6A06, 0x69E6, 0x6206, 0x49A5, 0x6206, 0x6A27, 0x6A07, 0x6A27, 0x6A27, 0x6206, 
        0x59E6, 0x59E6, 0x6A07, 0x69E6, 0x69E6, 0x5165, 0x61C6, 0x6A06, 0x7227, 0x7227, 0x7206, 0x6A06, 0x7227, 0x7227, 0x6A27, 0x6A07, 0x69E6, 0x61A5, 0x6A06, 0x6A47, 0x7268, 0x6A27, 0x6A07, 0x6A07, 0x6A07, 0x6A48, 0x6A48, 0x6A27, 0x6A07, 0x6A06, 
        0x6206, 0x6A88, 0x6A68, 0x6A06, 0x6A06, 0x6206, 0x6268, 0x6AA9, 0x6A27, 0x6A06, 0x69E6, 0x59E6, 0x5A48, 0x6247, 0x6A06, 0x6A06, 0x59E6, 0x4A06, 0x5247, 0x6207, 0x69E6, 0x6A06, 0x51C5, 0x41A5, 0x61E6, 0x69E6, 0x6A07, 0x51A5, 0x3944, 0x51A5, 
        0x6A07, 0x7227, 0x61E6, 0x3923, 0x4985, 0x6A07, 0x7207, 0x61E6, 0x3103, 0x4964, 0x6A07, 0x7206, 0x61E6, 0x3103, 0x4124, 0x6A06, 0x7227, 0x6A07, 0x3924, 0x4944, 0x6A06, 0x7207, 0x61E6, 0x3903, 0x5185, 0x6A07, 0x6A06, 0x51A5, 0x3964, 0x4985, 
        0x6207, 0x6248, 0x5207, 0x4165, 0x61E6, 0x6A07, 0x6A27, 0x4144, 0x4124, 0x7207, 0x7A07, 0x69E6, 0x38E3, 0x59A5, 0x69E6, 0x69E6, 0x5165, 0x3903, 0x61C6, 0x7A27, 0x69E6, 0x3903, 0x49A5, 0x8C30, 0x832C, 0x5185, 0x4143, 0x6A06, 0x7A27, 0x69E6, 
        0x3903, 0x61C5, 0x61C5, 0x61C6, 0x4964, 0x4984, 0x7227, 0x7A47, 0x51A5, 0x3923, 0x6A06, 0x61E6, 0x6247, 0x4A28, 0x6B8D, 0x7268, 0x69E6, 0x3903, 0x59A6, 0x69E6, 0x6A07, 0x4124, 0x5165, 0x7A27, 0x7227, 0x4944, 0x4944, 0x6A27, 0x6A27, 0x4964, 
        0x4944, 0x7227, 0x7A47, 0x5165, 0x4944, 0x7227, 0x7227, 0x5185, 0x5164, 0x7A27, 0x8227, 0x5985, 0x59A5, 0x7A47, 0x7A47, 0x4944, 0x5985, 0x7A47, 0x7207, 0x4124, 0x61C6, 0x7A27, 0x69E6, 0x4924, 0x7206, 0x7A47, 0x59A5, 0x4944, 0x7227, 0x7227, 
        0x4964, 0x59A5, 0x7A27, 0x69E6, 0x4944, 0x69E6, 0x7A47, 0x59A5, 0x5185, 0x7A27, 0x7227, 0x4944, 0x61C6, 0x8247, 0x61C6, 0x4944, 0x7A07, 0x7A27, 0x5164, 0x59A5, 0x69E6, 0x59C5, 0x5185, 0x61C6, 0x69E6, 0x61C6, 0x5965, 0x5165, 0x69E6, 0x69E6, 
        0x69C6, 0x8227, 0x92A9, 0x92A9, 0x92A9, 0x92A9, 0x92C9, 0x92C9, 0x8A88, 0x92A9, 0x92A9, 0x92A9, 0x92A9, 0x92A9, 0x9288, 0x92A9, 0x92A9, 0x92A8, 0x92A8, 0x8AA9, 0x8A89, 0x8268, 0x59A5, 0x59A5, 0x8288, 0x5185, 0x59A5, 0x7248, 0x4944, 0x61C6, 
        0x7A48, 0x4944, 0x7207, 0x69E7, 0x4965, 0x7B2B, 0x59A5, 0x4944, 0x7207, 0x5185, 0x5164, 0x61C6, 0x6B0B, 0x83CE, 0x59C6, 0x5185, 0x61C6, 0x59C6, 0x5185, 0x6A27, 0x51A5, 0x59C6, 0x6A68, 0x4985, 0x6248, 0x72A9, 0x59C6, 0x6ACA, 0x5A27, 0x6A88, 
        0x72EA, 0x51E6, 0x732B, 0x5A27, 0x6268, 0x6AEA, 0x4A05, 0x5AA8, 0x5267, 0x5AC9, 0x5288, 0x3985, 0x4A47, 0x31A5, 0x39E6, 0x39E5, 0x2984, 0x2184, 0x2184, 0x1923, 0x2983, 0x2163, 0x1942, 0x1942, 0x2142, 0x2163, 0x2162, 0x31E4, 0x4286, 0x3224, 
        0x3A65, 0x3A65, 0x42A6, 0x4AC6, 0x42A6, 0x42A5, 0x42A6, 0x4AE7, 0x4286, 0x29C3, 0x2163, 0x10C1, 0x08A1, 0x10A1, 0x1902, 0x10E2, 0x10E2, 0x10C1, 0x1902, 0x2163, 0x1902, 0x1922, 0x2163, 0x1942, 0x08A1, 0x10E2, 0x10E1, 0x18E1, 0x2162, 0x29A3, 
        0x2983, 0x2162, 0x1922, 0x1922, 0x1922, 0x1922, 0x1922, 0x10C2, 0x10C2, 0x08A1, 0x31C5, 0x29A4, 0x1122, 0x1922, 0x1902, 0x1902, 0x1902, 0x10C2, 0x08A1, 0x10C2, 0x10E2, 0x1102, 0x1902, 0x10E2, 0x10C2, 0x1902, 0x4AA8, 0x1943, 0x1102, 0x1102, 
        0x1922, 0x1902, 0x1902, 0x10E2, 0x10E2, 0x1102, 0x1902, 0x1902, 0x10E2, 0x10E2, 0x1102, 0x10E2, 0x1922, 0x1902, 0x10E2, 0x1922, 0x1942, 0x1962, 0x2183, 0x21A3, 0x1962, 0x2162, 0x29A3, 0x29A3, 0x3204, 0x4A85, 0x4A85, 0x4245, 0x52A6, 0x4A65, 
        0x4A65, 0x31C4, 0x1922, 0x1902, 0x10E1, 0x10E2, 0x10E2, 0x10E2, 0x10C2, 0x1902, 0x10E2, 0x1902, 0x1942, 0x2163, 0x31E4, 0x3A24, 0x31E3, 0x1921, 0x1901, 0x2122, 0x1921, 0x1901, 0x10E1, 0x10C1, 0x10C1, 0x10A1, 0x0881, 0x0881, 0x0861, 0x0040, 
        0x0860, 0x2163, 0x31C5, 0x2123, 0x10C1, 0x29A3, 0x2982, 0x2182, 0x2162, 0x10E1, 0x08A1, 0x0861, 0x0861, 0x0881, 0x1922, 0x2162, 0x2983, 0x2162, 0x2983, 0x4266, 0x1101, 0x1922, 0x1941, 0x2182, 0x3204, 0x21A3, 0x1922, 0x08C1, 0x10E1,
  0x69E6, 0x69E6, 0x69E6, 0x6206, 0x6B4C, 0x6289, 0x6207, 0x6207, 0x6227, 0x6227, 0x6227, 0x5A07, 0x51E6, 0x6227, 0x6227, 0x6227, 0x6227, 0x6207, 0x6207, 0x6206, 0x51C5, 0x51E5, 0x5A06, 0x51E6, 0x5206, 0x6227, 0x6247, 0x5A06, 0x51E6, 0x6227, 0x6227, 
        0x49A5, 0x51C5, 0x69E6, 0x69E6, 0x6A06, 0x5164, 0x61C6, 0x69E6, 0x7206, 0x7207, 0x7207, 0x6A06, 0x7207, 0x7227, 0x7227, 0x7227, 0x6A06, 0x4944, 0x6A06, 0x7207, 0x7227, 0x7206, 0x7207, 0x7207, 0x7207, 0x7227, 0x7227, 0x7227, 0x5985, 0x69E6, 
        0x7227, 0x7227, 0x7206, 0x6A06, 0x6A06, 0x6A06, 0x6A27, 0x6A27, 0x6A06, 0x61A5, 0x61C6, 0x6A27, 0x7248, 0x6A27, 0x69E6, 0x6A06, 0x6A06, 0x6A48, 0x7268, 0x6A07, 0x61E6, 0x61E6, 0x6A27, 0x7268, 0x6A27, 0x69E6, 0x69E6, 0x6A27, 0x6A88, 0x6A68, 
        0x6A07, 0x6A07, 0x61E6, 0x5A26, 0x6247, 0x7207, 0x7207, 0x6A06, 0x5A27, 0x6A68, 0x6A07, 0x7206, 0x61E6, 0x49A5, 0x51E6, 0x6A27, 0x7227, 0x6A07, 0x3943, 0x4985, 0x6A06, 0x6A07, 0x61C6, 0x3903, 0x51A5, 0x6A07, 0x6A06, 0x51C6, 0x3164, 0x4144, 
        0x6227, 0x6207, 0x4164, 0x3943, 0x6206, 0x7227, 0x6A07, 0x4164, 0x4164, 0x7227, 0x7A27, 0x69E6, 0x3903, 0x59C6, 0x7247, 0x7227, 0x4985, 0x3924, 0x61E6, 0x7A47, 0x6206, 0x3944, 0x49C6, 0x7BEF, 0x7B2B, 0x51C5, 0x4144, 0x6A06, 0x7A27, 0x69E6, 
        0x3903, 0x59C6, 0x69E6, 0x69E6, 0x4944, 0x4965, 0x6A47, 0x7AEA, 0x8B8D, 0x6248, 0x61C6, 0x6207, 0x738C, 0x5B0B, 0x7BEF, 0x7A89, 0x69E6, 0x3903, 0x5185, 0x61C6, 0x61E6, 0x4944, 0x5185, 0x7227, 0x7227, 0x4944, 0x4944, 0x61E6, 0x6206, 0x4964, 
        0x4944, 0x7207, 0x7A27, 0x5185, 0x4944, 0x69E6, 0x6A06, 0x59A5, 0x5985, 0x8247, 0x8248, 0x5985, 0x59A5, 0x7206, 0x7A27, 0x4944, 0x5985, 0x7A47, 0x7207, 0x4124, 0x61C6, 0x6A27, 0x61E6, 0x4124, 0x6A06, 0x7A47, 0x59A5, 0x4944, 0x7227, 0x7227, 
        0x4964, 0x59A5, 0x7A47, 0x69E6, 0x4944, 0x69E6, 0x7A27, 0x59A5, 0x5185, 0x7A27, 0x7206, 0x4944, 0x61C5, 0x8247, 0x61A5, 0x4944, 0x7207, 0x7A07, 0x5164, 0x59A5, 0x69E6, 0x61C6, 0x59A5, 0x61A5, 0x61C6, 0x61C6, 0x5985, 0x5165, 0x69C6, 0x69E6, 
        0x69C6, 0x8227, 0x92A8, 0x92A9, 0x92A9, 0x92A9, 0x92A9, 0x92A9, 0x8A68, 0x92A9, 0x92A9, 0x92A9, 0x92A9, 0x92A9, 0x9288, 0x9288, 0x92A9, 0x92A8, 0x8A68, 0x8A88, 0x8A88, 0x8247, 0x59A5, 0x5985, 0x8A68, 0x5985, 0x59A5, 0x7A68, 0x4964, 0x69E6, 
        0x8268, 0x4944, 0x7A27, 0x7A27, 0x4985, 0x83CE, 0x59E6, 0x5164, 0x8268, 0x59A5, 0x59A5, 0x7207, 0x6AEB, 0x83AD, 0x69E6, 0x4964, 0x7207, 0x5164, 0x5164, 0x6A07, 0x4944, 0x69E7, 0x61C6, 0x5165, 0x6A06, 0x5185, 0x59A5, 0x59C6, 0x4985, 0x61E6, 
        0x5185, 0x59A5, 0x6207, 0x51A5, 0x6207, 0x61E7, 0x59C6, 0x6A68, 0x59C5, 0x6A89, 0x72CA, 0x59C6, 0x7ACA, 0x59E6, 0x72CA, 0x6268, 0x6288, 0x6AEA, 0x49C6, 0x62A9, 0x6B2B, 0x49E5, 0x49E6, 0x630A, 0x4A06, 0x39C4, 0x4A87, 0x4AC7, 0x4AC6, 0x42A6, 
        0x42A6, 0x4AA6, 0x4285, 0x4285, 0x42A6, 0x42A6, 0x42A6, 0x42A6, 0x42A6, 0x4285, 0x3A65, 0x1922, 0x10C1, 0x10C1, 0x1902, 0x1101, 0x1922, 0x10E1, 0x10C1, 0x2122, 0x10C1, 0x1901, 0x2142, 0x2162, 0x10E1, 0x10E1, 0x10E2, 0x18E1, 0x2142, 0x2163, 
        0x2122, 0x2142, 0x1102, 0x10E1, 0x1902, 0x1102, 0x1922, 0x10E2, 0x1903, 0x10C1, 0x31E5, 0x29A4, 0x10E2, 0x10E2, 0x10C1, 0x10C2, 0x10C2, 0x10C2, 0x10E2, 0x10E2, 0x10E2, 0x10E2, 0x10E2, 0x1902, 0x10E1, 0x1902, 0x5B0A, 0x1922, 0x10E2, 0x1902, 
        0x1902, 0x10E2, 0x10C2, 0x10A1, 0x10C2, 0x10E2, 0x10C1, 0x10E2, 0x10A1, 0x10C2, 0x10C1, 0x10C2, 0x1902, 0x1902, 0x10E2, 0x1902, 0x1922, 0x1942, 0x1962, 0x2162, 0x1942, 0x1942, 0x29C4, 0x29C3, 0x31E4, 0x4285, 0x31E3, 0x31E3, 0x4A85, 0x4245, 
        0x31C3, 0x2143, 0x2983, 0x2163, 0x10E1, 0x10E2, 0x10E2, 0x10E2, 0x10C2, 0x10E2, 0x10E2, 0x1102, 0x2143, 0x29E4, 0x29C3, 0x4265, 0x4244, 0x31A3, 0x39C4, 0x4225, 0x31E4, 0x2122, 0x1902, 0x10E1, 0x0881, 0x0861, 0x0861, 0x0861, 0x0861, 0x0881, 
        0x0881, 0x2985, 0x2985, 0x0881, 0x0861, 0x10C1, 0x10E1, 0x10C1, 0x10E1, 0x1102, 0x10C1, 0x0881, 0x08A1, 0x10C1, 0x1922, 0x29C3, 0x29C3, 0x31E3, 0x3A25, 0x4266, 0x10C1, 0x10C1, 0x0880, 0x10C1, 0x1922, 0x1121, 0x2162, 0x1942, 0x10E1,
  0x69C6, 0x69E6, 0x69E6, 0x6227, 0x630B, 0x5247, 0x59E6, 0x59E6, 0x61E6, 0x6206, 0x6206, 0x61E6, 0x61E6, 0x61E6, 0x69E6, 0x69E6, 0x6A06, 0x61E6, 0x61E6, 0x61E6, 0x59C6, 0x59C6, 0x59C6, 0x59C6, 0x61E6, 0x61E6, 0x61E6, 0x61C6, 0x6206, 0x6206, 0x59C6, 
        0x61E6, 0x69E6, 0x6A06, 0x6A06, 0x6A06, 0x59A5, 0x61E6, 0x6A06, 0x7206, 0x7207, 0x7207, 0x6A06, 0x7207, 0x7207, 0x6A07, 0x7227, 0x6A06, 0x5144, 0x6A06, 0x7207, 0x7207, 0x7206, 0x6A06, 0x69E6, 0x6A06, 0x7207, 0x7207, 0x6A07, 0x5985, 0x61C6, 
        0x6A07, 0x7207, 0x7206, 0x7206, 0x7206, 0x7206, 0x7206, 0x7226, 0x7206, 0x5964, 0x59A5, 0x7227, 0x7227, 0x7207, 0x69E6, 0x6A06, 0x6A07, 0x7207, 0x6A07, 0x6A07, 0x5185, 0x61C6, 0x7207, 0x7207, 0x7206, 0x7206, 0x69E6, 0x6A06, 0x7207, 0x7206, 
        0x69E6, 0x61A5, 0x7227, 0x7247, 0x7247, 0x7206, 0x71E6, 0x7207, 0x7268, 0x7247, 0x6A06, 0x6A07, 0x6A06, 0x7268, 0x7288, 0x7227, 0x7207, 0x7227, 0x6A68, 0x6A88, 0x6A07, 0x6A06, 0x6A07, 0x6227, 0x6A68, 0x6A06, 0x6A07, 0x59E6, 0x5A67, 0x6A88, 
        0x5A27, 0x5A27, 0x5A88, 0x5AA9, 0x6A88, 0x6A68, 0x6A68, 0x5206, 0x5A68, 0x6247, 0x6247, 0x6268, 0x4A26, 0x6268, 0x72A8, 0x7288, 0x5A47, 0x4A26, 0x6268, 0x6A68, 0x5A47, 0x49E6, 0x4A07, 0x7BEF, 0x7B0B, 0x5185, 0x3923, 0x6A06, 0x7A27, 0x69E6, 
        0x3903, 0x59A5, 0x7227, 0x7206, 0x49A5, 0x4965, 0x69E6, 0x6A47, 0x5A27, 0x4985, 0x69E6, 0x7247, 0x736C, 0x52EB, 0x7BCF, 0x7A89, 0x69E6, 0x3923, 0x5185, 0x6A07, 0x6A07, 0x4104, 0x5185, 0x7227, 0x7247, 0x4965, 0x4964, 0x61E6, 0x6A07, 0x4965, 
        0x4964, 0x7206, 0x7227, 0x5185, 0x4944, 0x69E6, 0x69E6, 0x59A5, 0x5984, 0x8248, 0x8247, 0x5184, 0x59A5, 0x69C5, 0x7206, 0x4964, 0x5985, 0x7A27, 0x7207, 0x4124, 0x59C6, 0x61C6, 0x61C6, 0x4144, 0x6A06, 0x7A47, 0x59A5, 0x4944, 0x6A06, 0x61E6, 
        0x4964, 0x59A5, 0x7A47, 0x69E6, 0x4944, 0x69E6, 0x7207, 0x59A5, 0x5185, 0x7A27, 0x7207, 0x4924, 0x61A5, 0x7A27, 0x61C5, 0x4944, 0x7207, 0x7A07, 0x5164, 0x59A5, 0x69E6, 0x59C6, 0x59A5, 0x61A5, 0x61A6, 0x61A6, 0x5965, 0x5165, 0x69C6, 0x69C6, 
        0x69C6, 0x7A47, 0x92A9, 0x92A9, 0x92A9, 0x92A9, 0x92A9, 0x92A9, 0x8AA9, 0x92A9, 0x92C9, 0x9B2A, 0x92C9, 0x92A9, 0x92A9, 0x92A9, 0x92A9, 0x9288, 0x8268, 0x8A88, 0x8A68, 0x7A27, 0x59A5, 0x5985, 0x8A68, 0x5985, 0x59A5, 0x7227, 0x4944, 0x69E6, 
        0x8268, 0x4944, 0x7A27, 0x7206, 0x49A6, 0x8C30, 0x6227, 0x5144, 0x7A27, 0x5185, 0x59A5, 0x7A07, 0x6AEA, 0x8BEF, 0x7207, 0x5185, 0x8268, 0x5985, 0x59A5, 0x8268, 0x5165, 0x8248, 0x7207, 0x5985, 0x8268, 0x5985, 0x69E6, 0x7207, 0x5185, 0x7227, 
        0x5184, 0x61C6, 0x7207, 0x4944, 0x7207, 0x5185, 0x61C6, 0x61E6, 0x5164, 0x61E6, 0x5164, 0x5985, 0x59A6, 0x5985, 0x61E6, 0x59A5, 0x61E6, 0x59C6, 0x4944, 0x6207, 0x6248, 0x4944, 0x59C6, 0x6AA9, 0x5226, 0x4A06, 0x52A7, 0x4AC7, 0x42A6, 0x3A65, 
        0x4285, 0x42A6, 0x4286, 0x3A85, 0x42A6, 0x4285, 0x3A65, 0x42A6, 0x4AC6, 0x4AE7, 0x4AA6, 0x4AA6, 0x6309, 0x5247, 0x4206, 0x4A88, 0x4A47, 0x39C5, 0x4A47, 0x4A26, 0x4206, 0x39E5, 0x3A05, 0x31E4, 0x2143, 0x1902, 0x1902, 0x2142, 0x2143, 0x2122, 
        0x1902, 0x10E1, 0x10E2, 0x08C1, 0x10C1, 0x10C1, 0x08A0, 0x10C1, 0x18E2, 0x08A1, 0x3A06, 0x29A4, 0x10E1, 0x10E1, 0x08A1, 0x08A1, 0x08A1, 0x1902, 0x10E2, 0x08A1, 0x10A1, 0x10C1, 0x10C1, 0x1902, 0x10E1, 0x2143, 0x73EE, 0x18E2, 0x0861, 0x0881, 
        0x0881, 0x10A1, 0x10C2, 0x10A2, 0x10E2, 0x1102, 0x10C2, 0x10C2, 0x0881, 0x0881, 0x08A1, 0x10C1, 0x1922, 0x1902, 0x10C2, 0x1922, 0x2143, 0x1922, 0x1922, 0x1942, 0x1942, 0x2162, 0x29C3, 0x2162, 0x29C3, 0x3204, 0x29C3, 0x29C3, 0x3A24, 0x3A04, 
        0x1921, 0x1942, 0x31C4, 0x29A4, 0x10E2, 0x10E2, 0x10E2, 0x10C2, 0x10E2, 0x18E2, 0x10E2, 0x1902, 0x1902, 0x29A3, 0x2182, 0x39E4, 0x4A85, 0x4A65, 0x4A86, 0x4A65, 0x2162, 0x2122, 0x10E1, 0x10C1, 0x0881, 0x0861, 0x0861, 0x0881, 0x0881, 0x1081, 
        0x0861, 0x29A5, 0x1923, 0x0860, 0x0881, 0x10C2, 0x08A1, 0x0880, 0x08A1, 0x1902, 0x1102, 0x10E2, 0x10C1, 0x10C1, 0x10A1, 0x29C3, 0x29A3, 0x29A2, 0x3A24, 0x4266, 0x10E1, 0x10E1, 0x10E2, 0x08A1, 0x1902, 0x1901, 0x1942, 0x1942, 0x1942,
  0x61E6, 0x69E6, 0x69E6, 0x6227, 0x6B6C, 0x6289, 0x61E6, 0x61E6, 0x61E6, 0x69E6, 0x6A06, 0x61E6, 0x61E6, 0x69E6, 0x69E6, 0x6A06, 0x6A06, 0x69E6, 0x69E6, 0x69E6, 0x6A06, 0x69E6, 0x69E6, 0x69E6, 0x69E6, 0x69E6, 0x69E6, 0x69E6, 0x6A06, 0x6A27, 0x61E6, 
        0x61E6, 0x6A06, 0x6A06, 0x6A06, 0x6A06, 0x6A06, 0x6A06, 0x6A06, 0x6A06, 0x6A06, 0x6A06, 0x6A06, 0x7207, 0x7207, 0x6A07, 0x7227, 0x7227, 0x69E6, 0x7206, 0x7206, 0x7207, 0x7206, 0x7227, 0x6A06, 0x7206, 0x7207, 0x7207, 0x69E6, 0x61A5, 0x69E6, 
        0x6A07, 0x7207, 0x7206, 0x7206, 0x7206, 0x7206, 0x7206, 0x7206, 0x7206, 0x5985, 0x61C5, 0x7207, 0x7207, 0x7207, 0x69E6, 0x6A07, 0x6A07, 0x6A07, 0x6A07, 0x6A07, 0x5185, 0x61C6, 0x6A06, 0x7206, 0x7206, 0x71E6, 0x7206, 0x7206, 0x7206, 0x7207, 
        0x69C6, 0x5985, 0x7227, 0x7227, 0x7207, 0x7206, 0x7206, 0x7207, 0x7227, 0x7227, 0x6A06, 0x61A5, 0x7207, 0x7227, 0x7227, 0x7206, 0x7207, 0x7227, 0x7A48, 0x7227, 0x69E6, 0x61C6, 0x7227, 0x7247, 0x7227, 0x7206, 0x6A06, 0x6A27, 0x7288, 0x6A48, 
        0x61E6, 0x61C6, 0x6A27, 0x6A88, 0x6A47, 0x6A06, 0x6A07, 0x6247, 0x6268, 0x6A27, 0x61E6, 0x6207, 0x5A47, 0x6A47, 0x6A27, 0x6A27, 0x5A27, 0x5247, 0x6A47, 0x6A07, 0x6206, 0x49C5, 0x5227, 0x8450, 0x7B0B, 0x51A5, 0x4984, 0x6A26, 0x7A27, 0x69E6, 
        0x4144, 0x59E6, 0x7207, 0x6A06, 0x49C5, 0x4964, 0x7207, 0x7227, 0x4984, 0x3903, 0x6A06, 0x7227, 0x5A07, 0x39C6, 0x738E, 0x7B0A, 0x7288, 0x3923, 0x5185, 0x7227, 0x6A27, 0x4123, 0x5165, 0x7227, 0x7227, 0x4964, 0x4964, 0x6A27, 0x6A27, 0x4964, 
        0x4944, 0x7227, 0x7227, 0x5185, 0x4944, 0x7207, 0x7207, 0x5185, 0x5185, 0x8268, 0x8AA9, 0x6227, 0x61C5, 0x7206, 0x7226, 0x4944, 0x59A5, 0x7A47, 0x6A06, 0x4124, 0x59C6, 0x61C6, 0x59C6, 0x4924, 0x6A06, 0x7A27, 0x5985, 0x4944, 0x61E6, 0x61E6, 
        0x4964, 0x59A5, 0x7A27, 0x69E6, 0x4944, 0x61C6, 0x69C6, 0x59A5, 0x5185, 0x7A27, 0x7206, 0x4103, 0x59A5, 0x7206, 0x61C6, 0x4944, 0x7207, 0x7207, 0x5164, 0x5985, 0x61C6, 0x59C6, 0x59A5, 0x59A5, 0x61C6, 0x6A07, 0x5165, 0x5165, 0x69C6, 0x69C6, 
        0x69C6, 0x8247, 0x92A9, 0x92A9, 0x92A9, 0x92A9, 0x92A9, 0x92A9, 0x92A9, 0x92A9, 0x92C9, 0xAC4E, 0x9B6B, 0x92A9, 0x92A9, 0x92A9, 0x92A9, 0x9288, 0x8A88, 0x8A88, 0x8A88, 0x7A27, 0x59A5, 0x5185, 0x7A48, 0x5985, 0x59A5, 0x7227, 0x4944, 0x61E6, 
        0x7A48, 0x5164, 0x7227, 0x61E6, 0x51E6, 0x7BAE, 0x6248, 0x59C6, 0x7227, 0x5164, 0x5985, 0x7A27, 0x6AEB, 0x83CE, 0x6A06, 0x5185, 0x8268, 0x5985, 0x59A5, 0x7A48, 0x5165, 0x8248, 0x7A07, 0x5985, 0x8248, 0x59A5, 0x6A07, 0x7A27, 0x59A5, 0x8289, 
        0x59A5, 0x61C6, 0x7227, 0x5185, 0x8268, 0x59A5, 0x7207, 0x7227, 0x59A5, 0x7A48, 0x5185, 0x69E6, 0x61C6, 0x59A5, 0x7207, 0x5165, 0x7207, 0x5164, 0x4924, 0x6A07, 0x61C6, 0x4944, 0x61C6, 0x61E6, 0x41A5, 0x4A25, 0x4A86, 0x4AA7, 0x4AE7, 0x42A6, 
        0x3A25, 0x3A45, 0x4286, 0x4286, 0x3A65, 0x3A65, 0x3A65, 0x4285, 0x42C6, 0x4AE7, 0x4AA6, 0x4A86, 0x6329, 0x5206, 0x5185, 0x72EA, 0x5A67, 0x49C5, 0x6B49, 0x6329, 0x52A7, 0x736B, 0x6AC9, 0x51E6, 0x6B0A, 0x62A9, 0x49C5, 0x6B2A, 0x5A88, 0x39C5, 
        0x5AC9, 0x4A47, 0x3184, 0x5268, 0x41E6, 0x31A5, 0x4206, 0x31A5, 0x31A5, 0x31A5, 0x4A47, 0x31E5, 0x1922, 0x10E2, 0x10C2, 0x10A1, 0x18C2, 0x10A1, 0x10C2, 0x10C2, 0x10C1, 0x10C1, 0x10C1, 0x10C1, 0x10E1, 0x1923, 0x6B8D, 0x18E3, 0x0840, 0x0860, 
        0x0861, 0x0861, 0x0861, 0x1081, 0x10C2, 0x10E2, 0x10C2, 0x0881, 0x0861, 0x0861, 0x0881, 0x10A1, 0x1902, 0x2143, 0x10E1, 0x1902, 0x1902, 0x1902, 0x1922, 0x2183, 0x2163, 0x2162, 0x1942, 0x1942, 0x2162, 0x2162, 0x29A3, 0x29C3, 0x29C3, 0x31E4, 
        0x1962, 0x2163, 0x1942, 0x1922, 0x1102, 0x1902, 0x1903, 0x10C2, 0x10C2, 0x10C2, 0x10E2, 0x1902, 0x1922, 0x1922, 0x1942, 0x31E3, 0x31E3, 0x3A04, 0x3A24, 0x31E4, 0x1902, 0x1101, 0x10C1, 0x08A1, 0x0881, 0x0861, 0x0881, 0x10C1, 0x10C1, 0x0881, 
        0x0860, 0x31A6, 0x1903, 0x0861, 0x10A1, 0x10A1, 0x0881, 0x0881, 0x10C1, 0x1902, 0x1922, 0x10C1, 0x10E1, 0x10E1, 0x10E1, 0x1942, 0x29A3, 0x2182, 0x3A25, 0x3A46, 0x1101, 0x2183, 0x1902, 0x10C1, 0x2162, 0x2162, 0x1942, 0x1921, 0x2182,
  0x69E6, 0x69E6, 0x71E6, 0x6A27, 0x6B8D, 0x6A8A, 0x69E6, 0x6A07, 0x6A06, 0x7227, 0x7207, 0x6A06, 0x6A06, 0x69E6, 0x69E6, 0x6A06, 0x6A06, 0x69E6, 0x69C6, 0x69E6, 0x6A06, 0x6A06, 0x6A06, 0x69E6, 0x69E6, 0x69E6, 0x6A06, 0x69E6, 0x69E6, 0x6A07, 0x6227, 
        0x61E6, 0x61E6, 0x69E6, 0x6A06, 0x6A06, 0x61E6, 0x61E6, 0x6A06, 0x6A07, 0x6A07, 0x6A06, 0x6A06, 0x6A27, 0x6A07, 0x61E6, 0x6A27, 0x6A27, 0x6A27, 0x6A06, 0x6A06, 0x6A06, 0x6A07, 0x6A07, 0x7227, 0x7227, 0x7207, 0x7207, 0x6A06, 0x6A07, 0x7207, 
        0x7227, 0x7207, 0x7206, 0x7206, 0x7207, 0x7206, 0x7206, 0x7206, 0x7206, 0x6A06, 0x6A06, 0x6A06, 0x7207, 0x6A06, 0x6A06, 0x6A07, 0x6A06, 0x6A06, 0x7206, 0x69E6, 0x61C5, 0x69E6, 0x7206, 0x7206, 0x7206, 0x7206, 0x7206, 0x7206, 0x7207, 0x7207, 
        0x69C6, 0x61A5, 0x7227, 0x7227, 0x7227, 0x7207, 0x7206, 0x7227, 0x7227, 0x7227, 0x6A07, 0x5985, 0x6A07, 0x7227, 0x7227, 0x7206, 0x7207, 0x7227, 0x7227, 0x7227, 0x69E6, 0x59A5, 0x7207, 0x7227, 0x7227, 0x7206, 0x7206, 0x7207, 0x7227, 0x7207, 
        0x61A5, 0x61A5, 0x7207, 0x7247, 0x7227, 0x7207, 0x7206, 0x7227, 0x7207, 0x69E6, 0x5985, 0x7227, 0x7A48, 0x7227, 0x7206, 0x7207, 0x7248, 0x7A88, 0x7227, 0x69E6, 0x7227, 0x6A48, 0x6A68, 0x8C50, 0x7AEB, 0x6A27, 0x7AA9, 0x7A47, 0x7227, 0x7227, 
        0x6A68, 0x7268, 0x7207, 0x7206, 0x5A06, 0x6226, 0x6A06, 0x7207, 0x61E6, 0x5A27, 0x7268, 0x7227, 0x61E6, 0x5A68, 0x7BEF, 0x72A9, 0x6A47, 0x51E6, 0x6227, 0x7247, 0x6A27, 0x4164, 0x51A5, 0x7227, 0x6A07, 0x4164, 0x4984, 0x6A27, 0x6A27, 0x49A5, 
        0x4985, 0x7227, 0x7227, 0x5185, 0x4144, 0x7227, 0x7227, 0x51C5, 0x51A5, 0x7288, 0x7B0A, 0x7B4C, 0x7288, 0x7227, 0x7247, 0x4144, 0x59A5, 0x7247, 0x6A06, 0x4123, 0x59C6, 0x7227, 0x61E6, 0x4124, 0x6A06, 0x7A47, 0x59A5, 0x4944, 0x6A07, 0x6A07, 
        0x4964, 0x59C5, 0x7A27, 0x69E6, 0x4944, 0x61E6, 0x6A07, 0x59A5, 0x4965, 0x7247, 0x7AEA, 0x7B2B, 0x7268, 0x69E6, 0x61C6, 0x4144, 0x6A07, 0x7206, 0x5164, 0x5985, 0x59A5, 0x61A6, 0x59A5, 0x59A5, 0x7AEA, 0x7B2B, 0x59A6, 0x5145, 0x69C6, 0x69E6, 
        0x69C6, 0x7A27, 0x92A9, 0x92A9, 0x92A9, 0x92A9, 0x92A9, 0x92A9, 0x92A9, 0x92A9, 0x92C9, 0x9BED, 0x936B, 0x8AA9, 0x92A9, 0x92A9, 0x92A8, 0x9288, 0x9289, 0x8AA9, 0x8A88, 0x8268, 0x5985, 0x4984, 0x7227, 0x5185, 0x59C5, 0x7A48, 0x4944, 0x61E6, 
        0x7227, 0x5185, 0x7227, 0x6A07, 0x49A5, 0x738E, 0x730B, 0x7B0A, 0x8288, 0x5164, 0x59A5, 0x7A07, 0x6AEB, 0x83CE, 0x69E6, 0x5185, 0x8248, 0x5165, 0x5985, 0x7207, 0x5165, 0x7A48, 0x7227, 0x5185, 0x7227, 0x5185, 0x61C6, 0x7227, 0x59A5, 0x7A27, 
        0x59A5, 0x61C6, 0x7A27, 0x5185, 0x8248, 0x59A5, 0x7207, 0x7227, 0x5985, 0x8248, 0x5185, 0x7227, 0x69E6, 0x61C6, 0x7A28, 0x5985, 0x8268, 0x5985, 0x4944, 0x8248, 0x69E6, 0x4944, 0x7207, 0x7A27, 0x4984, 0x4A46, 0x4A86, 0x3A66, 0x3A86, 0x3A45, 
        0x3A66, 0x3A45, 0x3A45, 0x3A65, 0x3225, 0x3225, 0x3225, 0x3204, 0x3A45, 0x42A6, 0x42C6, 0x4285, 0x4A66, 0x49E5, 0x5205, 0x5A67, 0x4A45, 0x4A65, 0x4AA6, 0x4285, 0x4A86, 0x5A87, 0x49A5, 0x5164, 0x6A27, 0x59C6, 0x5185, 0x6A68, 0x59E6, 0x4964, 
        0x7289, 0x6207, 0x51A5, 0x72CA, 0x6247, 0x51E6, 0x7B2B, 0x5A07, 0x5206, 0x730B, 0x62C9, 0x62A9, 0x6B0A, 0x4A05, 0x5A68, 0x62A9, 0x49C6, 0x5A89, 0x5A68, 0x41C5, 0x4A27, 0x41C5, 0x41C5, 0x5288, 0x39A5, 0x39E6, 0x636D, 0x2964, 0x2964, 0x2944, 
        0x20E3, 0x20E3, 0x18C2, 0x18C2, 0x18C2, 0x10C2, 0x1081, 0x1081, 0x1081, 0x0881, 0x1082, 0x0861, 0x10C1, 0x10C1, 0x10C1, 0x1902, 0x1102, 0x1101, 0x2142, 0x2162, 0x2163, 0x1922, 0x1942, 0x1942, 0x2162, 0x29A3, 0x29A3, 0x2162, 0x2162, 0x31E4, 
        0x29A3, 0x1922, 0x10E2, 0x10E2, 0x1102, 0x10E2, 0x10C2, 0x10C2, 0x10E2, 0x10C2, 0x10E2, 0x1902, 0x2984, 0x29A4, 0x29A3, 0x31E4, 0x29A3, 0x1921, 0x1921, 0x1102, 0x10C1, 0x10E1, 0x10E1, 0x0881, 0x08A1, 0x10A1, 0x10C1, 0x10E1, 0x10C1, 0x08A1, 
        0x0060, 0x29A5, 0x1903, 0x0840, 0x0881, 0x10A1, 0x0881, 0x08A1, 0x10E2, 0x10C1, 0x10A1, 0x10A1, 0x10E1, 0x10C1, 0x10E1, 0x1922, 0x1922, 0x10E1, 0x2163, 0x3A26, 0x10E1, 0x29C3, 0x1901, 0x10C1, 0x2162, 0x2182, 0x2162, 0x21A2, 0x2182,
  0x59E6, 0x59E6, 0x61E7, 0x5A27, 0x6B8D, 0x5A69, 0x6207, 0x6A27, 0x7227, 0x7227, 0x7227, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 0x6A06, 0x6A07, 0x69E6, 0x6A06, 0x7206, 0x7206, 0x7207, 0x6A07, 0x6A06, 0x6A06, 0x7207, 0x69E6, 0x69E6, 0x6A06, 0x6A27, 
        0x6A27, 0x6A06, 0x7227, 0x7227, 0x7207, 0x6A06, 0x6A06, 0x6A07, 0x6A27, 0x6A06, 0x6A06, 0x6A06, 0x6A07, 0x6A07, 0x61E6, 0x6A07, 0x6A06, 0x61E6, 0x69E6, 0x6A07, 0x6A07, 0x6A07, 0x6A07, 0x6A07, 0x6A07, 0x6A07, 0x7207, 0x6A07, 0x6A27, 0x7227, 
        0x7227, 0x6A06, 0x6A06, 0x7207, 0x6A07, 0x6A06, 0x6A06, 0x6A06, 0x6A06, 0x6A07, 0x6A06, 0x6A07, 0x6A06, 0x6A06, 0x6A06, 0x6A06, 0x6A06, 0x7207, 0x6A06, 0x69E6, 0x69E6, 0x6A07, 0x7206, 0x7206, 0x7206, 0x7206, 0x7206, 0x7207, 0x7207, 0x6A06, 
        0x6A06, 0x6A06, 0x7207, 0x7207, 0x7207, 0x7206, 0x7206, 0x7206, 0x7207, 0x7207, 0x6A06, 0x61C6, 0x6A06, 0x7207, 0x7207, 0x7207, 0x7207, 0x7227, 0x7227, 0x7207, 0x69E6, 0x61C6, 0x7207, 0x7207, 0x7206, 0x7207, 0x7206, 0x7207, 0x7207, 0x7207, 
        0x61C5, 0x61C6, 0x7227, 0x7227, 0x7227, 0x7A07, 0x7A07, 0x7A27, 0x7A27, 0x69E6, 0x5944, 0x7227, 0x7A27, 0x7A07, 0x7206, 0x7227, 0x7227, 0x7A27, 0x7227, 0x61A5, 0x6A06, 0x7A27, 0x7247, 0x8C30, 0x7AEA, 0x7206, 0x7A27, 0x7206, 0x69C6, 0x7A27, 
        0x7A47, 0x7A27, 0x7A27, 0x7206, 0x7227, 0x7227, 0x6A06, 0x69C6, 0x7A27, 0x7A68, 0x7A27, 0x7A07, 0x7227, 0x72C9, 0x840F, 0x6A68, 0x6A06, 0x7268, 0x7268, 0x7227, 0x7227, 0x7288, 0x7AA9, 0x7227, 0x7206, 0x6A47, 0x7288, 0x7227, 0x6A06, 0x6A47, 
        0x7288, 0x7247, 0x7227, 0x6226, 0x6247, 0x7227, 0x7207, 0x5A06, 0x5A06, 0x7227, 0x6A27, 0x51C5, 0x6206, 0x7227, 0x7227, 0x49A5, 0x59E6, 0x7227, 0x6A06, 0x4964, 0x61E6, 0x7227, 0x61E6, 0x4144, 0x6A06, 0x7A47, 0x59A5, 0x4123, 0x7207, 0x7227, 
        0x4144, 0x59A5, 0x7A27, 0x69E6, 0x4144, 0x61E6, 0x7A27, 0x59C5, 0x49A5, 0x6A07, 0x6A48, 0x6248, 0x6A27, 0x7227, 0x61C5, 0x4144, 0x6A07, 0x7206, 0x5164, 0x59A5, 0x61C6, 0x61A6, 0x59C6, 0x59A5, 0x7ACA, 0x7B2B, 0x59A6, 0x5145, 0x69C6, 0x69C6, 
        0x69A6, 0x7A27, 0x92A9, 0x92A9, 0x92A9, 0x8A88, 0x8A88, 0x92A9, 0x8AA9, 0x92A9, 0x92A9, 0x9BED, 0x936B, 0x8A88, 0x8AA9, 0x8AA9, 0x8AA9, 0x8AA8, 0x8A88, 0x8A89, 0x8A89, 0x8268, 0x6A07, 0x6A27, 0x7227, 0x59C5, 0x61E6, 0x7A48, 0x4985, 0x6206, 
        0x7227, 0x5185, 0x7A47, 0x7227, 0x4185, 0x83EF, 0x5A48, 0x4923, 0x8268, 0x5184, 0x5184, 0x69E6, 0x6AEB, 0x8BEF, 0x6A06, 0x5164, 0x7207, 0x5165, 0x59A5, 0x7A48, 0x5165, 0x7207, 0x69E6, 0x5185, 0x6A27, 0x72A9, 0x8B4B, 0x6A27, 0x5985, 0x7207, 
        0x5185, 0x61C6, 0x7227, 0x5185, 0x7206, 0x5985, 0x6A07, 0x7227, 0x5185, 0x7227, 0x5185, 0x7227, 0x69E6, 0x61A6, 0x6A07, 0x5985, 0x8268, 0x5164, 0x4123, 0x8248, 0x71E6, 0x4964, 0x7207, 0x7A27, 0x49E5, 0x4A46, 0x4245, 0x31E4, 0x29A3, 0x31E4, 
        0x3225, 0x3225, 0x3225, 0x3A25, 0x3225, 0x29C4, 0x29C4, 0x29A3, 0x29E4, 0x3A45, 0x3A86, 0x4285, 0x4A86, 0x4225, 0x4205, 0x4A86, 0x4AA6, 0x3A65, 0x3A65, 0x3A65, 0x4265, 0x5AA6, 0x5205, 0x59C5, 0x7227, 0x5164, 0x5185, 0x7207, 0x4944, 0x5185, 
        0x7207, 0x4944, 0x61C6, 0x6A07, 0x4964, 0x59A5, 0x6A07, 0x4964, 0x59C6, 0x59E6, 0x6B0B, 0x6AA9, 0x41E4, 0x41E4, 0x5225, 0x5205, 0x4985, 0x6247, 0x6226, 0x59E5, 0x6A68, 0x59C6, 0x59E6, 0x7B0A, 0x51E6, 0x5A68, 0x634C, 0x49E6, 0x6AA9, 0x6248, 
        0x59E6, 0x6ACA, 0x49A5, 0x5A27, 0x5A68, 0x49E6, 0x62A9, 0x49E6, 0x49E6, 0x5268, 0x3964, 0x4A48, 0x4206, 0x39A5, 0x4A47, 0x3184, 0x39E6, 0x31C5, 0x2984, 0x39E5, 0x31C4, 0x2143, 0x2143, 0x2183, 0x2183, 0x2183, 0x29C3, 0x2183, 0x2162, 0x2183, 
        0x1942, 0x10C1, 0x10C1, 0x10C1, 0x10C1, 0x08A1, 0x0861, 0x0861, 0x0881, 0x10A1, 0x10C2, 0x1902, 0x2143, 0x2983, 0x3A04, 0x3A04, 0x3A04, 0x1921, 0x1101, 0x1102, 0x10C1, 0x08A1, 0x08C1, 0x08A1, 0x10E1, 0x1101, 0x1101, 0x10E1, 0x10C1, 0x08A1, 
        0x0881, 0x31C5, 0x1903, 0x0861, 0x10A1, 0x10C1, 0x10C1, 0x10C1, 0x08A1, 0x0860, 0x08A1, 0x10E2, 0x1102, 0x1101, 0x10E1, 0x2163, 0x1942, 0x08C1, 0x1923, 0x4268, 0x10A1, 0x29C3, 0x29C3, 0x10C1, 0x1101, 0x1942, 0x2162, 0x29C3, 0x1961,
  0x3A07, 0x3A07, 0x3A07, 0x3A28, 0x530C, 0x2986, 0x31C6, 0x5A27, 0x6A06, 0x7227, 0x7207, 0x7206, 0x7207, 0x7206, 0x7227, 0x7206, 0x69E6, 0x6A06, 0x69E6, 0x69E6, 0x6A06, 0x6A07, 0x69E6, 0x69E6, 0x69E6, 0x69E6, 0x69E6, 0x69E6, 0x69E6, 0x69E6, 0x61E6, 
        0x6A27, 0x6A06, 0x6A27, 0x6A27, 0x7227, 0x6A06, 0x7227, 0x7227, 0x7247, 0x7227, 0x7227, 0x7227, 0x7207, 0x6A07, 0x7227, 0x7227, 0x7207, 0x7207, 0x7227, 0x7227, 0x6A07, 0x7227, 0x7227, 0x7227, 0x7207, 0x6A06, 0x6A06, 0x6A07, 0x7227, 0x7227, 
        0x7227, 0x7227, 0x6A06, 0x6A06, 0x6A27, 0x6A27, 0x6A27, 0x6A06, 0x6A06, 0x6A06, 0x6A07, 0x6A06, 0x6A06, 0x6A06, 0x7207, 0x6A06, 0x6A27, 0x6A06, 0x6A06, 0x6A07, 0x6A07, 0x7207, 0x7207, 0x7227, 0x7206, 0x7206, 0x7206, 0x6A07, 0x6A06, 0x6A06, 
        0x6A06, 0x6A07, 0x6A06, 0x7227, 0x7207, 0x7207, 0x6A06, 0x7206, 0x7206, 0x7207, 0x7207, 0x7207, 0x7207, 0x7227, 0x7227, 0x7227, 0x7A27, 0x7A27, 0x7227, 0x7227, 0x7207, 0x6A07, 0x7207, 0x7227, 0x7227, 0x7206, 0x7206, 0x7226, 0x7227, 0x7207, 
        0x71E6, 0x7206, 0x7206, 0x7227, 0x7227, 0x7227, 0x7A27, 0x7A27, 0x7A07, 0x71E6, 0x69A5, 0x7A07, 0x7A07, 0x7A27, 0x7A27, 0x7206, 0x7A27, 0x7A27, 0x7A27, 0x61A5, 0x7207, 0x7A27, 0x7247, 0x8C50, 0x7AEA, 0x7206, 0x7207, 0x7206, 0x61C5, 0x7227, 
        0x7A27, 0x7A27, 0x7206, 0x7207, 0x7A27, 0x7A27, 0x69E6, 0x61A5, 0x7A27, 0x7A27, 0x7A07, 0x7A27, 0x7A27, 0x7289, 0x7BEE, 0x6247, 0x7247, 0x7A68, 0x7A47, 0x7227, 0x7A27, 0x7A27, 0x7A27, 0x69E6, 0x6A06, 0x7A47, 0x7A27, 0x7207, 0x7206, 0x7A47, 
        0x7A67, 0x6A06, 0x69E6, 0x7A48, 0x7A68, 0x7227, 0x7207, 0x6A27, 0x7227, 0x6A06, 0x6A07, 0x7248, 0x7A68, 0x7A27, 0x7207, 0x7A88, 0x7288, 0x7207, 0x7227, 0x7AA9, 0x7A88, 0x7207, 0x6A06, 0x6A67, 0x7247, 0x7227, 0x6A27, 0x6A88, 0x7227, 0x6A06, 
        0x6227, 0x6A47, 0x7A47, 0x6A06, 0x4964, 0x6A06, 0x7A27, 0x51C5, 0x49A5, 0x7207, 0x7206, 0x4143, 0x59C5, 0x7A27, 0x59A5, 0x4144, 0x6A07, 0x7207, 0x4964, 0x5985, 0x69E7, 0x61A6, 0x59C6, 0x59C6, 0x61E6, 0x61E7, 0x5165, 0x5165, 0x69C6, 0x69C6, 
        0x69A5, 0x7A07, 0x92A9, 0x8AA9, 0x92A9, 0x8288, 0x7A47, 0x8AA9, 0x8A88, 0x8AA8, 0x8AA8, 0x930A, 0x8AE9, 0x8AA8, 0x8AA8, 0x8AA8, 0x8AA8, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8247, 0x7A48, 0x7A67, 0x7227, 0x7A88, 0x7A89, 0x7207, 0x7289, 0x7AA8, 
        0x7227, 0x7288, 0x8288, 0x7227, 0x6AA9, 0x840F, 0x6AA9, 0x7268, 0x8268, 0x59C5, 0x61C6, 0x69E6, 0x6AEB, 0x940F, 0x6A06, 0x5185, 0x7207, 0x4944, 0x5185, 0x7A47, 0x4944, 0x7207, 0x61E6, 0x51A5, 0x6A27, 0x59E6, 0x6227, 0x61C6, 0x59A5, 0x7227, 
        0x5185, 0x59A5, 0x69E6, 0x5165, 0x7227, 0x5985, 0x69E6, 0x69E6, 0x5985, 0x7227, 0x5185, 0x6A06, 0x69E6, 0x61A6, 0x69E6, 0x5985, 0x7A68, 0x6A89, 0x72CA, 0x8288, 0x69E6, 0x4944, 0x6A06, 0x6206, 0x4A06, 0x3A05, 0x31C4, 0x29C4, 0x2983, 0x2163, 
        0x29C4, 0x31E4, 0x31E4, 0x3204, 0x3225, 0x29C3, 0x3225, 0x3204, 0x21A3, 0x29C4, 0x3A45, 0x3A85, 0x4AA6, 0x4245, 0x3A04, 0x3A45, 0x3A65, 0x3204, 0x3224, 0x3A85, 0x3A45, 0x5286, 0x52A6, 0x6226, 0x7A47, 0x5165, 0x59A5, 0x8248, 0x5164, 0x59A5, 
        0x8248, 0x5164, 0x61C6, 0x7A47, 0x5165, 0x69E6, 0x7A48, 0x4944, 0x69E6, 0x6A27, 0x7B8D, 0x5AC9, 0x2963, 0x2982, 0x39C3, 0x41A4, 0x4984, 0x6266, 0x51E5, 0x49C4, 0x6226, 0x4964, 0x61C6, 0x61E6, 0x4964, 0x6227, 0x632C, 0x51A6, 0x61E6, 0x5185, 
        0x59C5, 0x61E6, 0x5184, 0x61E6, 0x59C5, 0x59A5, 0x6A27, 0x59C5, 0x59E6, 0x6207, 0x5185, 0x6A48, 0x6207, 0x59E6, 0x72CA, 0x51C5, 0x6289, 0x51E6, 0x49C5, 0x6AEA, 0x49C5, 0x5A88, 0x5A88, 0x49E6, 0x5A88, 0x41A4, 0x5A88, 0x4A26, 0x5A88, 0x6B2B, 
        0x3984, 0x4A27, 0x39A5, 0x39C5, 0x39C5, 0x31C5, 0x3164, 0x31A5, 0x20E2, 0x18E2, 0x1902, 0x1902, 0x2123, 0x2984, 0x5287, 0x5AE7, 0x5AC7, 0x3A04, 0x3204, 0x1922, 0x08C1, 0x08C1, 0x10C1, 0x08C1, 0x10C1, 0x10C1, 0x1102, 0x1101, 0x10E2, 0x10C1, 
        0x0861, 0x29A5, 0x1923, 0x0861, 0x10E1, 0x1922, 0x1922, 0x1922, 0x1922, 0x10C1, 0x10A1, 0x1902, 0x10C1, 0x10C1, 0x10C1, 0x1942, 0x10E1, 0x1902, 0x2964, 0x5AEA, 0x0861, 0x1922, 0x2183, 0x1902, 0x1902, 0x10E1, 0x10E1, 0x29A3, 0x29A2,
  0x3A27, 0x3207, 0x31E6, 0x3228, 0x5B6D, 0x2985, 0x31C6, 0x5A27, 0x6A06, 0x7227, 0x7227, 0x7227, 0x7A27, 0x7A27, 0x7227, 0x7227, 0x6A27, 0x6A07, 0x7207, 0x7207, 0x6A07, 0x7207, 0x6A07, 0x6A07, 0x6A06, 0x6A07, 0x6A07, 0x6A06, 0x61E6, 0x61E6, 0x61E6, 
        0x6207, 0x6A27, 0x6A07, 0x6A07, 0x6A07, 0x6A06, 0x6A07, 0x6A07, 0x6A27, 0x6A07, 0x6A07, 0x6A07, 0x6A07, 0x69E6, 0x6A07, 0x6A07, 0x6A07, 0x7207, 0x6A07, 0x6A07, 0x7207, 0x6A06, 0x7227, 0x7207, 0x6A07, 0x6A06, 0x6A06, 0x6A07, 0x7227, 0x7207, 
        0x7207, 0x6A07, 0x6A07, 0x6A07, 0x6A07, 0x6A07, 0x6A07, 0x6A27, 0x6A06, 0x6A07, 0x6A07, 0x6A06, 0x6A06, 0x6A07, 0x6A07, 0x6A27, 0x6A27, 0x6A27, 0x6A27, 0x6A07, 0x7247, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x6A27, 0x6A27, 0x7227, 0x7227, 
        0x7207, 0x7207, 0x7207, 0x7A47, 0x7A47, 0x7227, 0x7227, 0x7227, 0x7227, 0x7A27, 0x7207, 0x7207, 0x7227, 0x7227, 0x7A27, 0x7A27, 0x7A27, 0x7A47, 0x7227, 0x7227, 0x7206, 0x7227, 0x7207, 0x7A27, 0x7207, 0x7227, 0x7227, 0x7226, 0x7227, 0x7227, 
        0x7207, 0x7207, 0x7A07, 0x7A27, 0x7A27, 0x7206, 0x7A27, 0x7A07, 0x7A07, 0x7206, 0x7207, 0x7A06, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7206, 0x7A27, 0x7A27, 0x7247, 0x9450, 0x830A, 0x7A06, 0x7A27, 0x7206, 0x69E6, 0x7A27, 
        0x7227, 0x7227, 0x7206, 0x7206, 0x7227, 0x7207, 0x69E6, 0x69C5, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7268, 0x6B8D, 0x5A68, 0x7AA9, 0x6A47, 0x6A47, 0x6A47, 0x7247, 0x7247, 0x7248, 0x6A07, 0x6A27, 0x7268, 0x7248, 0x7227, 0x7227, 0x7247, 
        0x7247, 0x6A06, 0x69E6, 0x7A47, 0x7A27, 0x7227, 0x7207, 0x7227, 0x7A47, 0x61C5, 0x61C6, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7A47, 0x7A47, 0x61C5, 0x69E6, 0x7A47, 0x7A27, 0x7227, 0x7A27, 0x7A68, 0x7227, 0x69E6, 0x7A47, 0x7AA8, 0x7227, 0x7207, 
        0x7A88, 0x7A88, 0x7206, 0x7227, 0x7AA9, 0x7A68, 0x6A06, 0x6227, 0x6A47, 0x7227, 0x7207, 0x6227, 0x6A47, 0x7227, 0x6A06, 0x6226, 0x6A47, 0x6A27, 0x59E6, 0x6207, 0x69E6, 0x59A6, 0x59A6, 0x59C6, 0x59A5, 0x59A5, 0x5145, 0x5165, 0x69C6, 0x69C6, 
        0x69C6, 0x7227, 0x8A88, 0x8AA8, 0x8A89, 0x8268, 0x8268, 0x8AA9, 0x8AA8, 0x8A88, 0x8AA8, 0x8A88, 0x8AA9, 0x8AA9, 0x8AA9, 0x8AA8, 0x8AA8, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x7A27, 0x7A27, 0x7227, 0x7A27, 0x7227, 0x7227, 0x7A27, 0x7A27, 0x7A27, 
        0x7A27, 0x7A47, 0x8247, 0x8247, 0x7288, 0x7BAE, 0x7B0A, 0x8B0A, 0x7A27, 0x8288, 0x8AA9, 0x7A27, 0x7B4C, 0x8BEE, 0x6A27, 0x7288, 0x7A47, 0x6A07, 0x7268, 0x7227, 0x6A27, 0x7A68, 0x6206, 0x6227, 0x7207, 0x59A5, 0x61C6, 0x61C6, 0x59C5, 0x7227, 
        0x51A5, 0x59C6, 0x69E6, 0x5985, 0x7A48, 0x5985, 0x69E6, 0x61C6, 0x5164, 0x7A47, 0x5184, 0x61C6, 0x61A5, 0x61A5, 0x7207, 0x51A5, 0x6A07, 0x6268, 0x72EA, 0x7248, 0x61E6, 0x49C5, 0x5A47, 0x5A06, 0x39C4, 0x31A4, 0x29A4, 0x29A3, 0x2183, 0x1962, 
        0x1942, 0x2183, 0x29C3, 0x29E4, 0x3204, 0x3224, 0x3A45, 0x3A45, 0x21A3, 0x29A3, 0x3A45, 0x4286, 0x4286, 0x3A45, 0x3A45, 0x3A45, 0x3A45, 0x2A04, 0x2A04, 0x3A65, 0x3224, 0x4265, 0x4265, 0x5A26, 0x7206, 0x5185, 0x5985, 0x8227, 0x5184, 0x59A5, 
        0x7A27, 0x5164, 0x61C6, 0x8247, 0x5144, 0x61C6, 0x7A48, 0x4964, 0x6A06, 0x6A27, 0x736D, 0x4AA9, 0x1922, 0x29A3, 0x31E3, 0x39C4, 0x31A3, 0x4A25, 0x4204, 0x41C3, 0x6A46, 0x4984, 0x6A06, 0x6A07, 0x4964, 0x6A48, 0x6B4C, 0x59E6, 0x7227, 0x4944, 
        0x59C5, 0x61E6, 0x4144, 0x69E7, 0x5185, 0x5185, 0x69E6, 0x4964, 0x59C6, 0x5185, 0x4944, 0x59C5, 0x4964, 0x51A5, 0x51A5, 0x4964, 0x51C5, 0x4164, 0x51A5, 0x51C5, 0x4984, 0x49E5, 0x49E5, 0x49A5, 0x51C6, 0x4964, 0x59E6, 0x49A5, 0x51C6, 0x6248, 
        0x4185, 0x6268, 0x4165, 0x5A47, 0x5A67, 0x49C5, 0x7B4B, 0x838C, 0x4184, 0x49C6, 0x5A68, 0x5A68, 0x3144, 0x49E5, 0x6B0A, 0x62A8, 0x49E5, 0x5246, 0x62E9, 0x2983, 0x10E1, 0x10E1, 0x10E1, 0x10A1, 0x1081, 0x10E1, 0x1922, 0x1901, 0x1102, 0x10E1, 
        0x0881, 0x29A5, 0x1943, 0x0881, 0x18E2, 0x2142, 0x2182, 0x2162, 0x2162, 0x2983, 0x1101, 0x10E1, 0x10C1, 0x10C1, 0x10A1, 0x10E1, 0x0881, 0x10C1, 0x31C6, 0x634C, 0x0860, 0x0881, 0x10C1, 0x10C1, 0x10C1, 0x10E1, 0x1902, 0x2182, 0x29A2,
  0x3207, 0x3207, 0x3207, 0x3228, 0x530C, 0x31C7, 0x3A07, 0x5A27, 0x6A06, 0x6A07, 0x7227, 0x7227, 0x7227, 0x7227, 0x6A06, 0x6A06, 0x6A06, 0x61E6, 0x6A06, 0x61E6, 0x61E5, 0x6A27, 0x61E6, 0x61E6, 0x61E6, 0x59C6, 0x59C6, 0x59E6, 0x59C5, 0x59C5, 0x59E6, 
        0x6206, 0x6206, 0x6A27, 0x6A27, 0x6A06, 0x6A06, 0x6A06, 0x6A07, 0x6A27, 0x6A07, 0x7207, 0x7207, 0x6A07, 0x6A07, 0x6A07, 0x7227, 0x6A07, 0x7227, 0x6A07, 0x6A07, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 
        0x7227, 0x7227, 0x6A06, 0x6A27, 0x6A27, 0x6A27, 0x6A27, 0x6A07, 0x6A06, 0x6A07, 0x6A07, 0x6A27, 0x6A07, 0x6A07, 0x6A47, 0x6A27, 0x6A27, 0x6A27, 0x6A27, 0x6A27, 0x6207, 0x51C6, 0x6207, 0x6A06, 0x6A06, 0x6A07, 0x6A07, 0x6A06, 0x6A27, 0x6A27, 
        0x6A07, 0x6A07, 0x7227, 0x7207, 0x7227, 0x7207, 0x7227, 0x7227, 0x7207, 0x7207, 0x7207, 0x6A06, 0x6A06, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7207, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x7A47, 0x7A27, 0x7207, 
        0x7A27, 0x7A27, 0x7227, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7248, 0x9430, 0x82EA, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 
        0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7227, 0x7206, 0x7207, 0x7227, 0x7A27, 0x7227, 0x7227, 0x7206, 0x6A68, 0x7BCE, 0x6A68, 0x7206, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x6A07, 0x6227, 0x6A67, 0x7288, 0x7268, 0x7268, 0x6A47, 
        0x6A47, 0x6227, 0x6247, 0x7AA8, 0x7268, 0x7247, 0x7247, 0x6A47, 0x6A27, 0x51E5, 0x5A06, 0x7247, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A47, 0x61A5, 0x69E6, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7A47, 0x6A06, 0x5985, 0x7A27, 0x7A27, 0x7227, 0x7226, 
        0x7A27, 0x7A27, 0x61A5, 0x7207, 0x7A47, 0x7A27, 0x6A07, 0x7227, 0x7247, 0x69E6, 0x6A27, 0x7A68, 0x7248, 0x7247, 0x7247, 0x7268, 0x6A27, 0x6A06, 0x6A27, 0x6A07, 0x61E6, 0x59C6, 0x59A5, 0x59A5, 0x59A5, 0x59A5, 0x5144, 0x5165, 0x69C6, 0x69C6, 
        0x69C6, 0x7A27, 0x8A88, 0x8A88, 0x8AA9, 0x8A88, 0x9288, 0x8AA9, 0x8AA9, 0x8AA8, 0x8AA8, 0x8AA9, 0x8AA9, 0x8AA9, 0x8AA8, 0x8AA8, 0x8AA8, 0x8AA8, 0x8AA8, 0x8A88, 0x8A88, 0x8247, 0x7227, 0x7247, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x8247, 0x7A47, 
        0x7A47, 0x7A47, 0x7A67, 0x7A47, 0x7248, 0x7BAE, 0x7AEA, 0x7247, 0x7A48, 0x7A68, 0x7A47, 0x7247, 0x6ACA, 0x7B8D, 0x6A27, 0x7A68, 0x7A47, 0x8268, 0x8268, 0x7A47, 0x7A68, 0x7247, 0x6A27, 0x7248, 0x7207, 0x7227, 0x7248, 0x7227, 0x7A69, 0x7227, 
        0x6A47, 0x7268, 0x6A27, 0x7268, 0x7248, 0x7247, 0x7A48, 0x6A07, 0x7268, 0x7227, 0x6206, 0x7247, 0x6A06, 0x7247, 0x7227, 0x59C5, 0x7207, 0x4964, 0x4964, 0x69E6, 0x6206, 0x41E5, 0x4A05, 0x4A05, 0x31A4, 0x31C4, 0x2163, 0x2163, 0x2143, 0x1943, 
        0x1963, 0x2163, 0x2183, 0x21A3, 0x29C4, 0x29E3, 0x3204, 0x3204, 0x2A04, 0x29A3, 0x3225, 0x3A65, 0x3A65, 0x3204, 0x29E4, 0x3225, 0x3225, 0x2A04, 0x3204, 0x3204, 0x3224, 0x2A04, 0x3A45, 0x5A46, 0x6A06, 0x5185, 0x5985, 0x7A27, 0x5164, 0x51A5, 
        0x7206, 0x5164, 0x61C6, 0x8289, 0x6227, 0x61E6, 0x6A27, 0x4984, 0x5A05, 0x5A46, 0x6B6C, 0x52C9, 0x29C3, 0x1942, 0x1962, 0x29A3, 0x29A3, 0x21A3, 0x29A3, 0x29A3, 0x5A46, 0x4984, 0x69E6, 0x69E6, 0x5164, 0x7248, 0x6B4C, 0x51E6, 0x7207, 0x4944, 
        0x61E6, 0x6A06, 0x4144, 0x7227, 0x59A5, 0x51A5, 0x6A27, 0x4984, 0x6206, 0x59A5, 0x4944, 0x69E7, 0x5164, 0x59C6, 0x59C6, 0x4964, 0x6206, 0x4984, 0x49C5, 0x41A4, 0x3183, 0x39A4, 0x39A4, 0x49C5, 0x4964, 0x4124, 0x51A5, 0x4124, 0x4985, 0x4144, 
        0x4964, 0x5185, 0x3903, 0x5185, 0x4144, 0x4144, 0x51A5, 0x51A5, 0x30E2, 0x5185, 0x59C6, 0x51A5, 0x3903, 0x5185, 0x59E6, 0x49A5, 0x30E2, 0x5185, 0x49E5, 0x2963, 0x1902, 0x10E2, 0x1902, 0x18E2, 0x10E1, 0x1902, 0x1101, 0x1902, 0x1902, 0x18C1, 
        0x0860, 0x31E6, 0x2984, 0x10C1, 0x10C1, 0x2162, 0x31E3, 0x29E3, 0x29C2, 0x29A2, 0x29A3, 0x2182, 0x10C1, 0x10C1, 0x10E2, 0x10C2, 0x0861, 0x0040, 0x2965, 0x636C, 0x0861, 0x0860, 0x0861, 0x0861, 0x10A1, 0x10A1, 0x10C1, 0x1101, 0x2182,
  0x3207, 0x3207, 0x31E7, 0x3228, 0x530C, 0x29A6, 0x3227, 0x6248, 0x7206, 0x7207, 0x7207, 0x7207, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7207, 0x7206, 0x7206, 0x7227, 0x7207, 0x6A06, 0x6A06, 0x69E6, 0x6A06, 0x6A07, 0x6A07, 0x7207, 0x69E6, 
        0x69E6, 0x6A06, 0x7207, 0x6A07, 0x6A06, 0x6A06, 0x69E6, 0x6A06, 0x7207, 0x7207, 0x7206, 0x69E6, 0x6A06, 0x6A06, 0x69E6, 0x6A07, 0x6A06, 0x6A07, 0x6A07, 0x6A07, 0x6A07, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x6A27, 0x6A07, 0x6A07, 0x6A27, 
        0x6A07, 0x6A06, 0x6A27, 0x7227, 0x6A27, 0x6A27, 0x6A27, 0x6A07, 0x7227, 0x6A27, 0x6A07, 0x6A27, 0x6A07, 0x6206, 0x6A07, 0x6A27, 0x6A27, 0x6A27, 0x6A27, 0x7247, 0x59C6, 0x39C5, 0x5206, 0x6A26, 0x6A27, 0x7227, 0x6A27, 0x7247, 0x7247, 0x7247, 
        0x7247, 0x7227, 0x7247, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x6A27, 0x6A27, 0x6A07, 0x6A07, 0x6A07, 0x6A07, 0x6A27, 0x6A07, 0x6A27, 0x6A07, 0x6A06, 0x6A07, 0x6A07, 0x6A07, 0x6A07, 0x6A06, 0x6A07, 0x6A07, 0x6A07, 0x6A27, 0x7227, 
        0x6A06, 0x7227, 0x69E6, 0x6A06, 0x7227, 0x7227, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7227, 0x7227, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7268, 0x8C10, 0x7AEA, 0x7227, 0x7A47, 0x7247, 0x7A27, 0x7A27, 
        0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7227, 0x7227, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7288, 0x7BCF, 0x7A89, 0x7A27, 0x7A47, 0x7A47, 0x7227, 0x7A27, 0x7A27, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7247, 0x7227, 
        0x6A26, 0x6A26, 0x6A27, 0x7247, 0x7247, 0x7227, 0x7227, 0x7227, 0x6A47, 0x6226, 0x6A27, 0x7227, 0x7227, 0x7227, 0x7A27, 0x7A27, 0x7227, 0x69E6, 0x6A06, 0x7227, 0x7227, 0x7227, 0x7227, 0x7A27, 0x7206, 0x61C5, 0x7207, 0x7A27, 0x7227, 0x7206, 
        0x7A27, 0x7A27, 0x61C5, 0x7206, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A47, 0x69E6, 0x6A06, 0x7A47, 0x7247, 0x7247, 0x7A67, 0x7A47, 0x6A06, 0x61E6, 0x7227, 0x6A27, 0x69E6, 0x61C6, 0x59A6, 0x59A5, 0x59A5, 0x59A5, 0x4944, 0x5165, 0x61C6, 0x61A6, 
        0x61A5, 0x7A27, 0x8AA9, 0x8AA8, 0x8AA8, 0x8AA8, 0x92A8, 0x8AA8, 0x8AA9, 0x92A9, 0x8AA9, 0x8AA9, 0x92A9, 0x92A9, 0x8AA8, 0x8AA8, 0x8AA8, 0x92A8, 0x92A8, 0x8A88, 0x8A88, 0x8268, 0x7247, 0x7267, 0x7A88, 0x7A68, 0x7267, 0x7A68, 0x7A68, 0x7A88, 
        0x7A88, 0x7A68, 0x7A68, 0x7A67, 0x7288, 0x7B8D, 0x7B0B, 0x7A88, 0x7AA8, 0x7A88, 0x7A88, 0x7268, 0x6AEA, 0x83CE, 0x7A68, 0x8268, 0x8247, 0x8247, 0x8247, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7227, 0x7207, 0x7207, 0x7207, 0x7227, 0x7207, 0x7227, 
        0x7227, 0x7207, 0x7227, 0x7A27, 0x7A27, 0x7A48, 0x7A47, 0x7A27, 0x8268, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7A68, 0x7A27, 0x7A68, 0x7A47, 0x7248, 0x7A88, 0x7A47, 0x6A47, 0x5246, 0x39C5, 0x31E5, 0x31C4, 0x29A4, 0x2163, 0x1943, 0x1922, 0x1943, 
        0x29A4, 0x2983, 0x2183, 0x2162, 0x2183, 0x29A3, 0x29A3, 0x3204, 0x3A45, 0x29C4, 0x29E4, 0x3225, 0x3A65, 0x3205, 0x21A3, 0x29E4, 0x29E4, 0x29E4, 0x3204, 0x29E4, 0x29E4, 0x29E3, 0x3A65, 0x5A66, 0x7247, 0x5164, 0x5985, 0x69E6, 0x4964, 0x5985, 
        0x7227, 0x51A5, 0x59C5, 0x7288, 0x72E9, 0x5A46, 0x5A26, 0x49E4, 0x31C3, 0x29A3, 0x636C, 0x4AA9, 0x2183, 0x21A3, 0x21A3, 0x2183, 0x2162, 0x1942, 0x2183, 0x2182, 0x4204, 0x41E4, 0x6226, 0x61C6, 0x5164, 0x6A68, 0x738D, 0x6A89, 0x69E6, 0x4964, 
        0x61C6, 0x69E6, 0x4144, 0x59C5, 0x49A4, 0x3984, 0x41C4, 0x39A4, 0x59E5, 0x51A5, 0x4944, 0x69E6, 0x5165, 0x59A6, 0x59A5, 0x4964, 0x51C5, 0x3984, 0x3183, 0x2983, 0x2183, 0x2163, 0x2983, 0x49E5, 0x4985, 0x4944, 0x59C6, 0x4144, 0x51A5, 0x4984, 
        0x4965, 0x59C5, 0x4123, 0x59C6, 0x4144, 0x4144, 0x61E6, 0x51A5, 0x30E2, 0x5185, 0x69E6, 0x51A5, 0x3103, 0x5185, 0x61C6, 0x51A5, 0x3103, 0x59C6, 0x59C5, 0x3183, 0x1942, 0x1922, 0x10E1, 0x10C1, 0x1902, 0x1922, 0x1922, 0x10E1, 0x18E2, 0x10A1, 
        0x0020, 0x4A68, 0x3226, 0x1101, 0x18E1, 0x2162, 0x29A2, 0x29A2, 0x29C2, 0x29E3, 0x31E3, 0x29A3, 0x1902, 0x0861, 0x0861, 0x08A1, 0x0861, 0x0040, 0x2145, 0x5B6C, 0x0881, 0x0861, 0x0861, 0x0861, 0x0881, 0x10A1, 0x1902, 0x2142, 0x1942,
  0x31E7, 0x3207, 0x31E7, 0x3A68, 0x638D, 0x29A6, 0x3227, 0x6248, 0x69E6, 0x7207, 0x7227, 0x7207, 0x7207, 0x7227, 0x7A27, 0x7A27, 0x7207, 0x7207, 0x7207, 0x7207, 0x7226, 0x7A27, 0x7207, 0x7227, 0x7206, 0x7206, 0x7207, 0x7207, 0x7207, 0x7A27, 0x7227, 
        0x7227, 0x7227, 0x7A27, 0x7A27, 0x7A27, 0x7A07, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7A27, 0x7227, 0x7227, 0x7A27, 0x7227, 0x7227, 0x7227, 0x7227, 
        0x7227, 0x7227, 0x7227, 0x7227, 0x6A07, 0x6A07, 0x6A07, 0x6A06, 0x6A06, 0x6A07, 0x69E6, 0x6A07, 0x6A06, 0x61E6, 0x6A06, 0x6A06, 0x61E6, 0x6A07, 0x6A06, 0x6A27, 0x51C5, 0x2985, 0x49E6, 0x6A27, 0x7247, 0x7227, 0x6A27, 0x6A27, 0x6A27, 0x6A27, 
        0x7227, 0x7227, 0x7248, 0x7227, 0x7247, 0x7247, 0x7247, 0x7247, 0x7247, 0x7247, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x6A27, 0x6A27, 0x6A27, 0x6A07, 0x7227, 0x6A07, 0x6A27, 0x6A27, 
        0x6A06, 0x6A27, 0x6206, 0x6A26, 0x6A27, 0x6A07, 0x7227, 0x7227, 0x6A27, 0x6A27, 0x6A07, 0x6A27, 0x7227, 0x7248, 0x7A47, 0x7247, 0x7227, 0x6A27, 0x7227, 0x7247, 0x7247, 0x7227, 0x7268, 0x8C30, 0x7AEA, 0x7227, 0x7A47, 0x7227, 0x7227, 0x7A47, 
        0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7227, 0x7227, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7289, 0x8410, 0x7AA9, 0x8247, 0x8248, 0x8247, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7247, 0x7247, 0x7247, 0x7227, 0x7247, 0x7247, 0x7227, 
        0x6A26, 0x7267, 0x7247, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7247, 0x7247, 0x7227, 0x7227, 0x7A27, 0x7227, 0x7A27, 0x7A27, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7226, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7A27, 0x7227, 
        0x7227, 0x7A27, 0x7206, 0x7227, 0x7A27, 0x7A27, 0x7227, 0x7227, 0x7A47, 0x7227, 0x7227, 0x7A67, 0x8268, 0x8268, 0x7A68, 0x7A68, 0x6A27, 0x6A07, 0x7247, 0x6A07, 0x69E6, 0x61C6, 0x59A5, 0x59A5, 0x59A5, 0x59A5, 0x4944, 0x5165, 0x61A5, 0x5985, 
        0x61A6, 0x7227, 0x8AA9, 0x8AA9, 0x8A88, 0x8AA8, 0x8AA8, 0x8A88, 0x8AA8, 0x92A8, 0x8AA8, 0x8AA8, 0x92A9, 0x92A9, 0x8AA8, 0x8AA8, 0x9288, 0x92A8, 0x8A88, 0x8A88, 0x8A88, 0x8247, 0x7A27, 0x8247, 0x8247, 0x7A47, 0x7A27, 0x7A27, 0x7A47, 0x7A47, 
        0x8247, 0x8247, 0x8247, 0x8247, 0x7A47, 0x83CE, 0x830B, 0x8227, 0x8247, 0x8247, 0x8247, 0x8227, 0x834C, 0x93EF, 0x8248, 0x8248, 0x8247, 0x8247, 0x8247, 0x7A47, 0x8268, 0x8268, 0x7A47, 0x7A27, 0x7A27, 0x7227, 0x7227, 0x7A27, 0x7A27, 0x7A27, 
        0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x8247, 0x8227, 0x8227, 0x8227, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7227, 0x5A46, 0x4A46, 0x3A05, 0x29C4, 0x2183, 0x21A4, 0x2163, 0x1943, 0x1922, 0x1922, 
        0x29A4, 0x2183, 0x2163, 0x2183, 0x1943, 0x1942, 0x2163, 0x29E3, 0x3225, 0x29C4, 0x29C4, 0x29E4, 0x3225, 0x29E4, 0x2A04, 0x1962, 0x21A3, 0x29E4, 0x3204, 0x29E4, 0x3204, 0x3204, 0x4285, 0x5AA7, 0x7267, 0x59E6, 0x6206, 0x6A06, 0x51A5, 0x59C6, 
        0x7A27, 0x51C5, 0x51C5, 0x61E6, 0x41A4, 0x3183, 0x39E4, 0x31E4, 0x2182, 0x1101, 0x5B2B, 0x4AC9, 0x1962, 0x21A3, 0x2183, 0x2182, 0x1922, 0x1922, 0x1963, 0x1922, 0x31C3, 0x31E3, 0x5245, 0x5A06, 0x4964, 0x5A27, 0x6B8D, 0x6A89, 0x69E6, 0x4964, 
        0x59A5, 0x61C6, 0x4144, 0x49A5, 0x4184, 0x2943, 0x2963, 0x2963, 0x49C5, 0x51A5, 0x4944, 0x61E6, 0x5165, 0x5985, 0x5185, 0x4984, 0x49C5, 0x2963, 0x2142, 0x1942, 0x1943, 0x1963, 0x2963, 0x41A4, 0x41A4, 0x4164, 0x59C6, 0x4124, 0x4985, 0x4984, 
        0x4944, 0x59A5, 0x3923, 0x51A5, 0x4144, 0x4944, 0x69E6, 0x59A5, 0x30E2, 0x5185, 0x61E6, 0x5185, 0x3103, 0x59A5, 0x6A06, 0x51C5, 0x3102, 0x59C6, 0x51E5, 0x2962, 0x1101, 0x2122, 0x10E2, 0x08A1, 0x10C1, 0x1942, 0x1121, 0x10E1, 0x0860, 0x0840, 
        0x0020, 0x4A69, 0x3A46, 0x1921, 0x2162, 0x2162, 0x2982, 0x29A2, 0x29C3, 0x31E3, 0x29C3, 0x29A2, 0x2162, 0x08A1, 0x0881, 0x0881, 0x0881, 0x0040, 0x2124, 0x5B4C, 0x0881, 0x0861, 0x08A1, 0x0881, 0x0881, 0x10C1, 0x1943, 0x29A3, 0x2162,
  0x3207, 0x31E7, 0x31E7, 0x3A69, 0x530C, 0x2985, 0x3207, 0x6248, 0x6A07, 0x7207, 0x7206, 0x7227, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 0x7206, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 0x7227, 0x7227, 0x7227, 
        0x7227, 0x7227, 0x7A27, 0x7A27, 0x7A27, 0x7A07, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7226, 0x7207, 0x7227, 0x7A27, 0x7227, 0x7227, 0x7227, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 
        0x7A27, 0x7A27, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 0x7227, 0x7227, 0x7227, 0x7247, 0x7247, 0x7247, 0x7248, 0x6A07, 0x3123, 0x5A06, 0x7247, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 
        0x7227, 0x7227, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x6A27, 0x7227, 0x7227, 0x7207, 0x7227, 0x7207, 0x6A07, 0x6A07, 0x6A07, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x6A27, 0x6A27, 
        0x6A27, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7247, 0x7227, 0x7227, 0x6A27, 0x6A27, 0x7227, 0x7227, 0x7247, 0x7227, 0x6A07, 0x6A07, 0x6A27, 0x6A07, 0x7227, 0x7227, 0x7268, 0x8C30, 0x7ACA, 0x6A07, 0x6A07, 0x6A06, 0x6A06, 0x7227, 
        0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x6A48, 0x6B2C, 0x6248, 0x6A27, 0x6A06, 0x6A06, 0x6A27, 0x7227, 0x7227, 0x6A06, 0x6A27, 0x6A47, 0x6226, 0x6206, 0x6226, 0x6227, 0x6227, 
        0x6227, 0x6267, 0x5A26, 0x5A47, 0x6A47, 0x6206, 0x6A27, 0x7227, 0x7247, 0x7247, 0x7227, 0x7227, 0x7227, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7227, 0x7227, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7227, 0x7227, 0x7227, 0x7A27, 0x7227, 0x7227, 0x7227, 
        0x7A27, 0x7227, 0x7207, 0x7227, 0x7227, 0x7227, 0x7247, 0x7227, 0x7227, 0x7227, 0x7247, 0x8267, 0x8268, 0x8268, 0x8268, 0x8268, 0x7A47, 0x7A27, 0x7247, 0x6A27, 0x6A06, 0x59C6, 0x59A6, 0x51A5, 0x51A5, 0x5185, 0x4944, 0x5165, 0x61A5, 0x5985, 
        0x61A6, 0x7227, 0x8288, 0x8AA8, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8AA8, 0x8AA8, 0x8AA8, 0x8AA8, 0x8AA8, 0x8AA8, 0x8AA8, 0x8A88, 0x8A88, 0x8268, 0x8A68, 0x8A88, 0x8247, 0x8247, 0x8247, 0x8247, 0x8247, 0x8247, 0x8247, 0x8247, 0x8248, 
        0x8247, 0x8247, 0x8247, 0x8248, 0x7A68, 0x7BAE, 0x830B, 0x8247, 0x8248, 0x8A68, 0x8247, 0x8227, 0x834C, 0x8BEF, 0x8247, 0x8247, 0x8247, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7227, 0x7227, 0x7227, 0x7A27, 0x7A27, 0x7A27, 
        0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x8227, 0x8227, 0x8227, 0x7A27, 0x8247, 0x8247, 0x8227, 0x8247, 0x8247, 0x8247, 0x7A27, 0x7A47, 0x8247, 0x7A27, 0x7A27, 0x6A26, 0x4205, 0x31A4, 0x29A4, 0x2163, 0x1942, 0x2163, 0x1943, 0x10E2, 0x10E2, 0x1922, 
        0x2163, 0x2163, 0x1942, 0x2163, 0x2183, 0x2163, 0x2163, 0x21A3, 0x3205, 0x3205, 0x3205, 0x3204, 0x3225, 0x3A45, 0x3245, 0x29A3, 0x29C4, 0x29C4, 0x29C4, 0x29C3, 0x3224, 0x3204, 0x3A45, 0x5286, 0x7247, 0x7A68, 0x82A9, 0x7A27, 0x7A88, 0x82A9, 
        0x7A27, 0x7247, 0x6A67, 0x6206, 0x5246, 0x4205, 0x31A3, 0x31C3, 0x29C4, 0x1922, 0x5B0B, 0x4AA9, 0x0080, 0x10E1, 0x1101, 0x1962, 0x1922, 0x10C1, 0x10E1, 0x2162, 0x29A3, 0x2983, 0x31A3, 0x4A25, 0x49E5, 0x5A07, 0x634C, 0x51C6, 0x7227, 0x4984, 
        0x59C5, 0x61C5, 0x4164, 0x51C5, 0x3984, 0x2142, 0x1922, 0x2163, 0x41C5, 0x49A5, 0x4944, 0x59C6, 0x4964, 0x59A5, 0x59A6, 0x4184, 0x39A4, 0x2183, 0x2163, 0x1922, 0x1922, 0x1943, 0x2163, 0x31A3, 0x41A4, 0x4144, 0x51A5, 0x4123, 0x4965, 0x4964, 
        0x4944, 0x51A5, 0x3923, 0x4985, 0x3943, 0x4144, 0x59A6, 0x51A5, 0x30E2, 0x5185, 0x6227, 0x51C6, 0x3103, 0x59A5, 0x6206, 0x49A4, 0x3103, 0x51A5, 0x3983, 0x1922, 0x1101, 0x10C1, 0x10A1, 0x0881, 0x0881, 0x1922, 0x1921, 0x1922, 0x18E2, 0x10C1, 
        0x0860, 0x4A89, 0x3A47, 0x1921, 0x29A2, 0x2162, 0x2162, 0x2162, 0x1942, 0x10E1, 0x1901, 0x2162, 0x2162, 0x1942, 0x1922, 0x0881, 0x0881, 0x0881, 0x29A5, 0x638D, 0x08A1, 0x0861, 0x10C1, 0x08A1, 0x08A1, 0x10C1, 0x10E1, 0x2163, 0x31A3,
  0x3A08, 0x3207, 0x31E7, 0x4269, 0x4AEB, 0x2986, 0x3A27, 0x6248, 0x71E7, 0x7207, 0x7227, 0x7A48, 0x7227, 0x7206, 0x7207, 0x7207, 0x7207, 0x7207, 0x7206, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 
        0x7227, 0x7247, 0x7227, 0x7A27, 0x7A27, 0x7227, 0x7207, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7227, 0x7A27, 0x7207, 0x7207, 0x7227, 0x7227, 0x7207, 0x7207, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 
        0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A07, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 0x7227, 0x7227, 0x7227, 0x7247, 0x7227, 0x7227, 0x7227, 0x6A27, 0x5185, 0x6A27, 0x7247, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 
        0x7227, 0x7A27, 0x7A27, 0x7A27, 0x7227, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7227, 0x7227, 0x7227, 0x7207, 0x7A27, 0x7227, 0x7207, 0x7207, 0x7207, 0x7207, 0x7227, 0x7207, 0x69E6, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 
        0x7227, 0x7227, 0x7A27, 0x7227, 0x7227, 0x7227, 0x7227, 0x7A27, 0x7A27, 0x7A27, 0x7207, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7247, 0x7227, 0x7A27, 0x7227, 0x7248, 0x83EF, 0x72AA, 0x832C, 0xA4B2, 0xA4B2, 0xA4B2, 0xA4D2, 
        0xACF2, 0xA471, 0x7A89, 0x7227, 0x7247, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x6A27, 0x6247, 0x62EB, 0x39E6, 0x51E6, 0x6A06, 0x6A26, 0x6A07, 0x6A27, 0x6A27, 0x6A06, 0x7247, 0x6A47, 0x6A27, 0x7247, 0x7247, 0x7227, 0x7227, 
        0x6A27, 0x6A27, 0x6A27, 0x6206, 0x6247, 0x6247, 0x6A67, 0x6A26, 0x6206, 0x6A47, 0x7247, 0x6A07, 0x7207, 0x7227, 0x7207, 0x7207, 0x7207, 0x6A06, 0x6A06, 0x7207, 0x7207, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7207, 
        0x7A27, 0x7A27, 0x7A27, 0x8247, 0x8247, 0x7A27, 0x7A27, 0x7227, 0x7227, 0x7A47, 0x7A47, 0x8247, 0x8247, 0x8247, 0x8247, 0x7A47, 0x7A47, 0x7227, 0x7227, 0x6A07, 0x6A06, 0x61E6, 0x51A6, 0x59C6, 0x51A5, 0x5185, 0x4965, 0x5165, 0x61A6, 0x61A5, 
        0x61A5, 0x7227, 0x82A8, 0x8AA9, 0x8AA8, 0x8A88, 0x8AA9, 0x8AA8, 0x8AA8, 0x8AA8, 0x8AA8, 0x8AA8, 0x8AA8, 0x8AA9, 0x8AA9, 0x92A9, 0x92A8, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8268, 0x8247, 0x8247, 0x8247, 0x8247, 0x8247, 0x8A47, 0x8A47, 0x8A48, 
        0x8248, 0x8247, 0x8247, 0x8248, 0x8248, 0x7BAE, 0x832B, 0x8247, 0x8248, 0x8267, 0x8267, 0x7A47, 0x832C, 0x8BEF, 0x7247, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A68, 0x7A68, 0x7247, 0x7227, 0x7247, 0x6A27, 0x6A47, 0x7247, 0x7A27, 0x7A27, 0x7A27, 
        0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x8247, 0x8247, 0x8247, 0x8247, 0x8247, 0x8247, 0x8247, 0x8247, 0x8247, 0x8247, 0x8247, 0x7A27, 0x7A27, 0x6A26, 0x41C4, 0x2143, 0x2984, 0x1922, 0x10E2, 0x1922, 0x1902, 0x1102, 0x2143, 0x2184, 
        0x2163, 0x2163, 0x2163, 0x1942, 0x2163, 0x2163, 0x1922, 0x2163, 0x29C4, 0x3225, 0x3225, 0x3204, 0x3225, 0x3225, 0x3205, 0x2A04, 0x21A3, 0x2183, 0x21A3, 0x29C3, 0x29E3, 0x3204, 0x3224, 0x4266, 0x6A87, 0x7A67, 0x7A47, 0x7A47, 0x7A27, 0x8247, 
        0x7A27, 0x7A47, 0x6A46, 0x4A04, 0x39E4, 0x4205, 0x3A05, 0x3A25, 0x3A46, 0x3205, 0x5B0A, 0x530A, 0x29A4, 0x2184, 0x21A4, 0x29C4, 0x29A4, 0x2143, 0x29A4, 0x29C4, 0x29A4, 0x2183, 0x29C4, 0x4245, 0x62C7, 0x62A8, 0x6B6C, 0x72A9, 0x7227, 0x7247, 
        0x7247, 0x6A07, 0x5A47, 0x5206, 0x39A4, 0x1922, 0x1902, 0x1943, 0x31A4, 0x49E5, 0x5206, 0x51C5, 0x51C6, 0x6206, 0x59C6, 0x39A4, 0x2983, 0x1942, 0x1942, 0x1942, 0x1922, 0x1922, 0x1942, 0x2983, 0x3984, 0x4164, 0x4985, 0x4143, 0x51A5, 0x4964, 
        0x4144, 0x49A5, 0x3903, 0x51A5, 0x3923, 0x4123, 0x4944, 0x4964, 0x3123, 0x4985, 0x6227, 0x51C5, 0x30E2, 0x5185, 0x5184, 0x4984, 0x30E2, 0x51A5, 0x3983, 0x1921, 0x1102, 0x10C1, 0x0881, 0x0881, 0x10A1, 0x1922, 0x2122, 0x18E1, 0x2963, 0x31A4, 
        0x2163, 0x4AA9, 0x52E8, 0x31E4, 0x2182, 0x2982, 0x2182, 0x2182, 0x1901, 0x1901, 0x2162, 0x1962, 0x10E1, 0x1922, 0x2183, 0x2162, 0x1922, 0x08A1, 0x2965, 0x5B6C, 0x08C1, 0x0881, 0x10C1, 0x10E1, 0x10C1, 0x10E1, 0x1922, 0x2162, 0x31C3,
  0x4A67, 0x3A27, 0x3207, 0x4ACA, 0x5B4D, 0x29E7, 0x3A48, 0x6268, 0x6A06, 0x7207, 0x7227, 0x7207, 0x7206, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x7207, 0x7207, 0x7227, 0x7207, 0x7207, 0x7227, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x7247, 0x7227, 
        0x7227, 0x7247, 0x7A47, 0x7A47, 0x7A27, 0x7227, 0x7207, 0x7A27, 0x7A27, 0x7227, 0x7227, 0x7227, 0x7227, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 0x7A07, 0x7A07, 0x7A07, 0x7A27, 0x7A27, 0x7A07, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 
        0x7A27, 0x7207, 0x7227, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7207, 0x7207, 0x7207, 0x7207, 0x7227, 0x7207, 0x7207, 0x7207, 0x7227, 0x7227, 0x6A07, 0x6A07, 0x7227, 0x6A07, 0x5185, 0x6A27, 0x7227, 0x7207, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 
        0x7207, 0x7207, 0x7227, 0x7207, 0x7227, 0x7A27, 0x7A07, 0x7207, 0x7207, 0x7227, 0x7227, 0x7206, 0x7227, 0x7227, 0x7227, 0x7207, 0x7207, 0x7207, 0x7207, 0x7227, 0x7207, 0x7207, 0x7207, 0x7227, 0x7A47, 0x7A27, 0x7227, 0x7227, 0x7227, 0x7227, 
        0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x8227, 0x8227, 0x7A47, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7289, 0x73CE, 0x6269, 0x9450, 0xD71C, 0xCEBA, 0xD6FB, 0xCEBB, 
        0xC69A, 0xB5B6, 0x7ACA, 0x7A27, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7227, 0x7A27, 0x7A47, 0x7A47, 0x7A27, 0x6A68, 0x736D, 0x39E6, 0x5A07, 0x8268, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A48, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 
        0x7A47, 0x8248, 0x8247, 0x8248, 0x8268, 0x7A47, 0x7A47, 0x7A47, 0x7247, 0x7247, 0x7A67, 0x7A47, 0x7A47, 0x7A27, 0x7A47, 0x7A47, 0x7247, 0x7227, 0x7227, 0x7227, 0x7227, 0x7A27, 0x7A27, 0x7227, 0x7227, 0x7207, 0x7207, 0x7227, 0x7207, 0x6A07, 
        0x7227, 0x7A27, 0x7A27, 0x8227, 0x8247, 0x7A27, 0x7227, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7A47, 0x7A47, 0x7A27, 0x7227, 0x7A27, 0x7A27, 0x6A06, 0x7207, 0x6A07, 0x61E6, 0x51C6, 0x4185, 0x49A6, 0x51A5, 0x4985, 0x4144, 0x4965, 0x59A6, 0x59A6, 
        0x61A5, 0x6A07, 0x8288, 0x8288, 0x8288, 0x8268, 0x8288, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8AA8, 0x8AA8, 0x8A88, 0x8A89, 0x8AA9, 0x8A88, 0x8A68, 0x8A88, 0x8AA8, 0x8AA8, 0x8268, 0x7A47, 0x7A47, 0x7A27, 0x7A47, 0x7A47, 0x8247, 0x8247, 0x8247, 
        0x8268, 0x8247, 0x7A47, 0x7A27, 0x7A48, 0x736D, 0x72EA, 0x7A68, 0x7A67, 0x7A68, 0x7A68, 0x7A47, 0x7B4C, 0x8BEE, 0x6A47, 0x7268, 0x7247, 0x7247, 0x7227, 0x7227, 0x7227, 0x6A27, 0x6A06, 0x7227, 0x6A26, 0x7227, 0x7227, 0x7227, 0x7207, 0x7A27, 
        0x7A27, 0x7227, 0x7A27, 0x7A27, 0x7A27, 0x8268, 0x8247, 0x7A27, 0x8247, 0x8247, 0x8247, 0x8247, 0x8247, 0x8267, 0x8247, 0x8247, 0x8268, 0x7A27, 0x7A27, 0x7247, 0x4A26, 0x31E5, 0x29C4, 0x29A4, 0x1922, 0x10E2, 0x10E2, 0x1943, 0x29A4, 0x2163, 
        0x1922, 0x1942, 0x2163, 0x2163, 0x2163, 0x2163, 0x1942, 0x1943, 0x2183, 0x29E4, 0x29C4, 0x21A3, 0x21A3, 0x29E4, 0x3204, 0x2A04, 0x21C4, 0x21A3, 0x21C3, 0x21A3, 0x29A3, 0x29C3, 0x29E4, 0x3225, 0x4245, 0x5225, 0x6A46, 0x7A27, 0x7A27, 0x8247, 
        0x7A47, 0x6A26, 0x4A05, 0x31A3, 0x29A3, 0x29A4, 0x2163, 0x29A4, 0x2163, 0x29A4, 0x52EA, 0x52EA, 0x29A4, 0x29C4, 0x29C4, 0x2984, 0x3205, 0x31E4, 0x3A45, 0x3A25, 0x31E4, 0x3205, 0x4266, 0x4A86, 0x52A6, 0x4A86, 0x636C, 0x6AA8, 0x7267, 0x7A47, 
        0x7A27, 0x6A27, 0x41E5, 0x3184, 0x39C5, 0x2163, 0x1902, 0x1922, 0x2983, 0x39C4, 0x5206, 0x59E5, 0x51E5, 0x51E6, 0x51E5, 0x31A4, 0x2142, 0x1922, 0x1922, 0x2163, 0x1942, 0x1922, 0x1942, 0x2983, 0x49C5, 0x5206, 0x59C5, 0x51C5, 0x51E5, 0x49A4, 
        0x41A4, 0x41C5, 0x49E5, 0x59E6, 0x49A5, 0x49A5, 0x5184, 0x4985, 0x49C5, 0x49A5, 0x59A5, 0x51A5, 0x49A5, 0x51C5, 0x5184, 0x49A4, 0x3943, 0x51C5, 0x49A4, 0x2142, 0x1902, 0x10C1, 0x0881, 0x0881, 0x18C2, 0x41A4, 0x4184, 0x18E1, 0x2122, 0x2983, 
        0x1963, 0x4AC9, 0x52E8, 0x3204, 0x1942, 0x1942, 0x2982, 0x2162, 0x2162, 0x1922, 0x1942, 0x1922, 0x1922, 0x2183, 0x2982, 0x3203, 0x3A24, 0x2163, 0x2164, 0x638D, 0x08C1, 0x08A1, 0x10C1, 0x10E1, 0x1902, 0x1922, 0x2162, 0x2162, 0x2183,
  0x7B47, 0x4227, 0x31E7, 0x4AAA, 0x5B2D, 0x29A6, 0x4227, 0x6247, 0x69E6, 0x7207, 0x7207, 0x7206, 0x7206, 0x7206, 0x7207, 0x7227, 0x7207, 0x7207, 0x7207, 0x7207, 0x7227, 0x7227, 0x7207, 0x7227, 0x7207, 0x7207, 0x7227, 0x7227, 0x7247, 0x7247, 0x7206, 
        0x7227, 0x7247, 0x7227, 0x7227, 0x7227, 0x7227, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 0x7206, 0x7207, 0x7207, 0x7207, 0x7206, 0x7206, 0x7207, 0x7207, 0x7207, 0x7A27, 0x7A27, 0x7A07, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7207, 0x7206, 
        0x7A27, 0x7207, 0x7226, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7227, 0x7207, 0x7207, 0x7227, 0x7227, 0x7207, 0x7207, 0x7207, 0x7227, 0x7227, 0x6A27, 0x7227, 0x7227, 0x6A07, 0x51A5, 0x6A27, 0x7207, 0x7207, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 
        0x7207, 0x7207, 0x7227, 0x7227, 0x7227, 0x7A27, 0x7206, 0x7206, 0x7207, 0x7227, 0x7207, 0x7207, 0x7A27, 0x7207, 0x7227, 0x7227, 0x7206, 0x7207, 0x7227, 0x7A27, 0x7207, 0x7207, 0x7227, 0x7227, 0x7A47, 0x7A27, 0x7A27, 0x7A47, 0x7A47, 0x7A27, 
        0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x8227, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A47, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7A67, 0x7A47, 0x7A47, 0x7A27, 0x7AC9, 0x8C71, 0x6A89, 0x940F, 0xCEDA, 0xCEBA, 0xCE79, 0xCEBB, 
        0xCEDB, 0xB5B6, 0x7ACA, 0x7A27, 0x7A27, 0x8247, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x6227, 0x5AA9, 0x41A5, 0x6A07, 0x8248, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A68, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 
        0x7A27, 0x8247, 0x7A27, 0x8248, 0x8268, 0x8268, 0x8247, 0x7A47, 0x7A47, 0x7A47, 0x7247, 0x7A67, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7227, 0x7A27, 0x7A27, 0x7A47, 
        0x7A47, 0x8247, 0x8247, 0x8247, 0x8247, 0x8247, 0x8227, 0x8268, 0x8288, 0x8268, 0x8267, 0x8268, 0x8268, 0x8247, 0x7A47, 0x7A47, 0x7A47, 0x7227, 0x7227, 0x7207, 0x69E6, 0x49A5, 0x3185, 0x41A5, 0x5185, 0x4965, 0x4944, 0x4965, 0x59A5, 0x59A5, 
        0x59A5, 0x6A07, 0x8288, 0x7A68, 0x7A48, 0x8AC9, 0x8B2A, 0x8268, 0x8268, 0x8268, 0x8268, 0x8268, 0x8268, 0x8268, 0x8268, 0x8288, 0x8268, 0x8247, 0x8268, 0x8288, 0x8288, 0x7A68, 0x7227, 0x7227, 0x7227, 0x7A27, 0x7A47, 0x7A27, 0x7A27, 0x7A47, 
        0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7A47, 0x734C, 0x6AAA, 0x7247, 0x7A47, 0x7A48, 0x7A48, 0x7A47, 0x832B, 0x8BEE, 0x7A47, 0x7A48, 0x7A47, 0x7A47, 0x7A27, 0x7227, 0x7227, 0x7227, 0x6A07, 0x7227, 0x6A07, 0x7227, 0x7227, 0x7207, 0x6A06, 0x7207, 
        0x7207, 0x7207, 0x7207, 0x7206, 0x7247, 0x9C2E, 0x7B2A, 0x9BEE, 0x82A9, 0x7A27, 0x7A27, 0x7A27, 0x7A47, 0x8247, 0x8247, 0x8247, 0x8247, 0x7A27, 0x7A27, 0x6247, 0x39E5, 0x31E5, 0x31E5, 0x31E5, 0x2164, 0x10E2, 0x1922, 0x2184, 0x2163, 0x1922, 
        0x1902, 0x1922, 0x1922, 0x2163, 0x2163, 0x2183, 0x1943, 0x1943, 0x2163, 0x21C4, 0x2183, 0x1963, 0x29A4, 0x29C4, 0x29E4, 0x29E4, 0x21A3, 0x21A3, 0x2163, 0x2163, 0x1942, 0x1962, 0x2183, 0x21A3, 0x29C3, 0x4A25, 0x6266, 0x7A47, 0x7A27, 0x8247, 
        0x7A27, 0x6206, 0x3183, 0x2963, 0x2182, 0x29C3, 0x2183, 0x2183, 0x1942, 0x1122, 0x5B2B, 0x5B4B, 0x2162, 0x2183, 0x1962, 0x1902, 0x31E4, 0x29E4, 0x3204, 0x3A25, 0x31E4, 0x31C4, 0x3A24, 0x31E3, 0x31E4, 0x3A26, 0x6B8D, 0x4A86, 0x5A66, 0x6A27, 
        0x7A27, 0x6A27, 0x39A4, 0x2943, 0x2143, 0x1922, 0x1922, 0x1943, 0x1922, 0x2143, 0x41E5, 0x6206, 0x59E5, 0x41A4, 0x39A4, 0x2963, 0x1902, 0x1922, 0x1922, 0x1943, 0x1922, 0x1922, 0x1942, 0x2983, 0x49C5, 0x59E6, 0x59C6, 0x59C6, 0x49A5, 0x3983, 
        0x31A4, 0x39C4, 0x4A25, 0x51E6, 0x49C5, 0x49E5, 0x51C5, 0x51A5, 0x51A5, 0x59A5, 0x59A5, 0x59C5, 0x6206, 0x61E5, 0x59C5, 0x49E5, 0x5246, 0x59E5, 0x51C5, 0x2142, 0x1902, 0x10C1, 0x0881, 0x18E3, 0x2903, 0x61C6, 0x51C5, 0x2142, 0x2142, 0x2162, 
        0x1102, 0x4AA9, 0x42A7, 0x2182, 0x2163, 0x10E1, 0x1922, 0x2142, 0x2142, 0x1942, 0x1102, 0x10E1, 0x1942, 0x29C3, 0x31E3, 0x3203, 0x3203, 0x3A45, 0x3206, 0x63AD, 0x1102, 0x08C1, 0x10E1, 0x1922, 0x2142, 0x2183, 0x2183, 0x1942, 0x1922,
  0x6226, 0x5A06, 0x51E6, 0x5AAA, 0x5B4D, 0x49E7, 0x59E6, 0x69E6, 0x69E6, 0x7206, 0x7206, 0x7206, 0x71E6, 0x7206, 0x7206, 0x7207, 0x7206, 0x7206, 0x7206, 0x7206, 0x7207, 0x7206, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x7A27, 0x7A47, 0x7247, 0x7227, 
        0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7207, 0x69E6, 0x6A07, 0x7207, 0x7207, 0x7206, 0x71E6, 0x7206, 0x7207, 0x7206, 0x7207, 0x7207, 0x7207, 0x7207, 0x7227, 0x7207, 0x7A27, 0x7A07, 0x7A07, 0x7A07, 0x7A07, 0x7A27, 0x7A27, 0x7207, 0x7206, 
        0x7A27, 0x7227, 0x7207, 0x7206, 0x7206, 0x7207, 0x7207, 0x7207, 0x7227, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x6A06, 0x5185, 0x6A27, 0x7227, 0x7227, 0x7227, 0x7207, 0x7227, 0x7227, 0x7227, 
        0x7227, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x7206, 0x7206, 0x7207, 0x7227, 0x7207, 0x7227, 0x7207, 0x7207, 0x7227, 0x7207, 0x7207, 0x7207, 0x7A27, 0x7207, 0x7207, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7A47, 0x7A47, 0x7A47, 
        0x7227, 0x7227, 0x7A47, 0x7A27, 0x7A07, 0x7207, 0x7A07, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A47, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7ACA, 0x8C51, 0x6A89, 0x9C2F, 0xC699, 0xB5F7, 0x9CD1, 0xC638, 
        0xD6FB, 0xBDD6, 0x7AC9, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7288, 0x7BCE, 0x6248, 0x7227, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A68, 0x7A47, 0x8247, 0x8247, 0x8247, 
        0x8247, 0x8247, 0x8247, 0x8247, 0x8247, 0x7A47, 0x7A47, 0x8247, 0x8247, 0x8247, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7A47, 0x7A47, 0x7A27, 0x7A47, 
        0x8247, 0x8247, 0x8247, 0x8247, 0x8247, 0x8227, 0x7A27, 0x8A68, 0x8A68, 0x8A68, 0x8247, 0x8247, 0x8268, 0x8247, 0x8247, 0x8247, 0x7A27, 0x7A27, 0x7227, 0x7207, 0x69E6, 0x59C6, 0x3164, 0x4985, 0x59A6, 0x6A69, 0x51A6, 0x5165, 0x61A6, 0x61A6, 
        0x5985, 0x7207, 0x8A88, 0x8A88, 0x8288, 0x936C, 0xA44F, 0x82A9, 0x8288, 0x8268, 0x8268, 0x8268, 0x8268, 0x8288, 0x8288, 0x8288, 0x8AC9, 0x9B6C, 0x82A9, 0x7A68, 0x7A68, 0x7247, 0x7227, 0x7227, 0x7247, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 
        0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7227, 0x7B6D, 0x7B0B, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x832B, 0x93EE, 0x7A27, 0x7227, 0x7207, 0x7207, 0x7206, 0x69E6, 0x7207, 0x7207, 0x69E6, 0x6A07, 0x7207, 0x6A06, 0x7207, 0x7207, 0x69E6, 0x7207, 
        0x7207, 0x7207, 0x7207, 0x7206, 0x5A06, 0x632A, 0x52A9, 0x738C, 0x7AE9, 0x7A07, 0x7A27, 0x7A27, 0x7A47, 0x7A47, 0x7A27, 0x7A47, 0x8247, 0x7A27, 0x7227, 0x5226, 0x29A4, 0x29C4, 0x31E5, 0x2184, 0x2184, 0x1943, 0x1943, 0x2183, 0x1922, 0x10E2, 
        0x10E2, 0x10E2, 0x1922, 0x1923, 0x1943, 0x1922, 0x1922, 0x1943, 0x1943, 0x2163, 0x2183, 0x2183, 0x1943, 0x2143, 0x29C4, 0x21A3, 0x2163, 0x1942, 0x1922, 0x1943, 0x2183, 0x1942, 0x2183, 0x29A3, 0x29E4, 0x4245, 0x5A66, 0x7247, 0x7A47, 0x8247, 
        0x7A27, 0x51C4, 0x2963, 0x2983, 0x29A3, 0x29C3, 0x29A3, 0x21A3, 0x2183, 0x1942, 0x4AC9, 0x5B4B, 0x3225, 0x3A25, 0x2183, 0x2163, 0x3205, 0x3205, 0x3205, 0x4245, 0x3A25, 0x3204, 0x31E4, 0x31E4, 0x3A05, 0x3A26, 0x6B8D, 0x3A05, 0x5246, 0x6A47, 
        0x7227, 0x7227, 0x4984, 0x2943, 0x1902, 0x1943, 0x2163, 0x2143, 0x1943, 0x2983, 0x39C4, 0x49E5, 0x5A06, 0x49A5, 0x3183, 0x2142, 0x10E1, 0x1102, 0x1922, 0x1922, 0x1922, 0x1922, 0x1922, 0x2142, 0x39A4, 0x49E5, 0x59C5, 0x59C5, 0x49A5, 0x39A3, 
        0x31A3, 0x2983, 0x2983, 0x2983, 0x31A3, 0x31A4, 0x39A4, 0x51C5, 0x59C5, 0x59A5, 0x59C5, 0x59C5, 0x59C5, 0x59C5, 0x51E5, 0x41C4, 0x39C4, 0x41E4, 0x49E5, 0x31A3, 0x1902, 0x10A1, 0x0881, 0x0881, 0x18A1, 0x4964, 0x4184, 0x2183, 0x1963, 0x1942, 
        0x1102, 0x4AA9, 0x4267, 0x1901, 0x2162, 0x1922, 0x10E1, 0x18E2, 0x10A1, 0x10C1, 0x08C1, 0x1101, 0x2162, 0x2183, 0x29A3, 0x29C2, 0x31E3, 0x3203, 0x3205, 0x638C, 0x1902, 0x2923, 0x2102, 0x3163, 0x41C4, 0x39C4, 0x2163, 0x1922, 0x1922,
  0x69E6, 0x69E6, 0x69E6, 0x62CA, 0x638E, 0x6207, 0x69C6, 0x69E6, 0x6A06, 0x7206, 0x7206, 0x7206, 0x71E6, 0x7206, 0x7207, 0x7227, 0x7206, 0x7207, 0x7206, 0x7206, 0x7207, 0x7207, 0x7227, 0x7227, 0x7207, 0x7207, 0x7227, 0x7247, 0x7227, 0x7227, 0x7227, 
        0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7207, 0x7207, 0x7207, 0x7227, 0x7227, 0x7207, 0x7206, 0x7206, 0x7206, 0x7206, 0x7207, 0x7227, 0x7227, 0x7227, 0x7A27, 0x7207, 0x7206, 0x7227, 0x7206, 0x7A27, 0x7A27, 0x7A07, 0x7A27, 0x7A27, 0x7227, 
        0x7227, 0x7227, 0x7227, 0x7227, 0x6A06, 0x6A07, 0x6A07, 0x6A07, 0x6A07, 0x69E6, 0x69E6, 0x6A07, 0x7207, 0x6A07, 0x6A06, 0x6A07, 0x6A07, 0x7227, 0x7227, 0x6A27, 0x6A06, 0x51A5, 0x6A27, 0x7227, 0x7227, 0x7227, 0x6A07, 0x7227, 0x7227, 0x7227, 
        0x7207, 0x7207, 0x7227, 0x7A27, 0x7227, 0x7227, 0x7207, 0x7207, 0x7207, 0x7207, 0x7206, 0x7206, 0x7207, 0x7207, 0x7207, 0x7207, 0x7206, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 0x7227, 0x7207, 0x7227, 0x7207, 0x7207, 0x7A27, 0x7A27, 0x7A27, 
        0x7227, 0x7227, 0x7A27, 0x7A27, 0x7A27, 0x7A07, 0x7A27, 0x8247, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A67, 0x7A47, 0x7A47, 0x7A47, 0x7AEA, 0x8451, 0x6A89, 0x9C4F, 0xB617, 0x9D54, 0xADF6, 0xA5B4, 
        0xC679, 0xBDD6, 0x82C9, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x6A69, 0x6B6D, 0x5A48, 0x7227, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7247, 0x7247, 0x7A47, 0x7A67, 0x7A47, 0x8247, 0x8247, 0x8247, 
        0x8247, 0x8247, 0x8247, 0x8247, 0x8247, 0x8247, 0x7A27, 0x7A47, 0x8247, 0x8247, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x8247, 0x7A47, 0x7A47, 0x7A27, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A47, 
        0x7A47, 0x8247, 0x8247, 0x8247, 0x8247, 0x8247, 0x7A27, 0x8A67, 0x8A47, 0x8A48, 0x8247, 0x8247, 0x8247, 0x8247, 0x7A27, 0x8247, 0x7A27, 0x7A26, 0x7206, 0x7206, 0x61E6, 0x59E6, 0x4185, 0x4965, 0x6248, 0x8BAD, 0x5A07, 0x4944, 0x61A5, 0x61A6, 
        0x61A5, 0x7A27, 0x8AA8, 0x8AA9, 0x8A89, 0x9B8C, 0xACB0, 0x8AC9, 0x8AA9, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8AA8, 0x8AA8, 0x8A88, 0x934B, 0xAC90, 0x8B0A, 0x82A8, 0x8288, 0x7A47, 0x7A47, 0x7A47, 0x7A48, 0x7A68, 0x8248, 0x8247, 0x8248, 0x8248, 
        0x8247, 0x7A47, 0x8248, 0x7A47, 0x7247, 0x734C, 0x7B2B, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x832B, 0x8BEE, 0x7248, 0x82EA, 0x830B, 0x830B, 0x832B, 0x834C, 0x82EA, 0x7227, 0x49A5, 0x49C6, 0x7227, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 
        0x7207, 0x7207, 0x7207, 0x7207, 0x6A07, 0x4164, 0x49E6, 0x3985, 0x7268, 0x7227, 0x7A27, 0x7A27, 0x7A27, 0x7A47, 0x7A27, 0x7A47, 0x7A47, 0x7227, 0x6A27, 0x49E5, 0x2163, 0x2163, 0x2184, 0x2163, 0x2184, 0x1943, 0x2163, 0x2183, 0x1922, 0x10E2, 
        0x08C1, 0x10E2, 0x1902, 0x10E2, 0x1902, 0x1923, 0x1923, 0x1943, 0x1922, 0x1963, 0x2184, 0x21A3, 0x2183, 0x1963, 0x2183, 0x2183, 0x2163, 0x2184, 0x2163, 0x2163, 0x1943, 0x10C1, 0x1923, 0x2142, 0x29A3, 0x31E4, 0x5245, 0x7247, 0x7A47, 0x7A27, 
        0x7A47, 0x59E5, 0x2902, 0x2142, 0x2182, 0x2183, 0x29A3, 0x2162, 0x1942, 0x2163, 0x4AA9, 0x4ACA, 0x2183, 0x29C4, 0x31E5, 0x31E4, 0x2183, 0x2183, 0x2183, 0x29A4, 0x3A04, 0x3A04, 0x31C3, 0x29A3, 0x3204, 0x4226, 0x638D, 0x3205, 0x4A25, 0x6A47, 
        0x7227, 0x7227, 0x6227, 0x39A4, 0x2143, 0x1943, 0x2143, 0x1922, 0x1943, 0x2143, 0x2983, 0x39A4, 0x5206, 0x41A4, 0x3183, 0x2142, 0x1922, 0x1102, 0x10E2, 0x10E2, 0x1102, 0x1902, 0x1922, 0x2142, 0x2983, 0x41C4, 0x51C5, 0x51C5, 0x49C5, 0x39A4, 
        0x2983, 0x2163, 0x1922, 0x1922, 0x2183, 0x2163, 0x3183, 0x49C5, 0x59C5, 0x59C5, 0x59C5, 0x59C5, 0x59E5, 0x49E5, 0x39C4, 0x31A3, 0x29C4, 0x29A4, 0x31C4, 0x4225, 0x2963, 0x10A1, 0x10A1, 0x18C2, 0x18A1, 0x4164, 0x2922, 0x1942, 0x1942, 0x2163, 
        0x21A4, 0x4ACA, 0x4288, 0x29C4, 0x29A4, 0x1903, 0x10C2, 0x10E2, 0x1902, 0x1902, 0x1922, 0x2143, 0x2183, 0x2183, 0x29C3, 0x29E3, 0x2A03, 0x29A2, 0x3205, 0x638C, 0x2123, 0x59E6, 0x61E6, 0x6A06, 0x59E5, 0x3183, 0x1942, 0x1922, 0x1922,
  0x61C5, 0x69E6, 0x61E6, 0x5ACA, 0x638E, 0x6227, 0x69C6, 0x69E6, 0x6A06, 0x7206, 0x7206, 0x6A06, 0x69E6, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 0x7206, 0x7206, 0x7207, 0x7227, 0x7227, 0x7227, 0x7207, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x7207, 
        0x7207, 0x7207, 0x7227, 0x7227, 0x7206, 0x69E6, 0x69E6, 0x6A06, 0x6A07, 0x7207, 0x7207, 0x7206, 0x7206, 0x7207, 0x7206, 0x7227, 0x7227, 0x7206, 0x7207, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7A27, 0x7207, 0x7207, 
        0x7227, 0x7227, 0x7227, 0x7227, 0x7207, 0x7227, 0x7227, 0x6A07, 0x6A07, 0x69E6, 0x69E6, 0x69E6, 0x6A06, 0x6A27, 0x6A07, 0x6A06, 0x6A27, 0x6A27, 0x6A27, 0x6A27, 0x6A06, 0x51A5, 0x6A27, 0x7227, 0x7227, 0x7227, 0x7207, 0x7227, 0x7227, 0x7227, 
        0x7227, 0x7207, 0x7227, 0x7227, 0x7227, 0x7207, 0x7207, 0x7207, 0x7227, 0x7207, 0x7206, 0x71E6, 0x7206, 0x7206, 0x7206, 0x7206, 0x7207, 0x7206, 0x7206, 0x7207, 0x7206, 0x71E6, 0x7207, 0x7227, 0x7227, 0x7227, 0x7207, 0x7227, 0x7227, 0x7227, 
        0x7227, 0x7227, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x8247, 0x7A47, 0x7A27, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7ACA, 0x8C51, 0x6A89, 0x9C2F, 0xB616, 0xB617, 0xADF7, 0xA5D4, 
        0xB5F5, 0xB5B6, 0x7AC9, 0x7A27, 0x7A27, 0x7A47, 0x7A27, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x6A89, 0x634D, 0x5A28, 0x7227, 0x7A68, 0x7A67, 0x7A47, 0x7A47, 0x7A47, 0x7247, 0x7247, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x8247, 0x8247, 
        0x8248, 0x8268, 0x8247, 0x8248, 0x8248, 0x8248, 0x7A47, 0x7A68, 0x7A47, 0x7A47, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7247, 
        0x7A47, 0x7A47, 0x8227, 0x8247, 0x8247, 0x7A27, 0x7A06, 0x8A68, 0x8A68, 0x8A68, 0x8A67, 0x8268, 0x8A68, 0x8247, 0x8227, 0x8247, 0x8247, 0x7A27, 0x7206, 0x6A06, 0x61E6, 0x59E6, 0x4985, 0x4965, 0x5A07, 0x836C, 0x5A07, 0x5145, 0x61A5, 0x61A5, 
        0x5985, 0x7A27, 0x92A9, 0x8AA9, 0x8A88, 0x9B8C, 0xAC90, 0x92E9, 0x8AA8, 0x92A9, 0x92A8, 0x9288, 0x9288, 0x8A88, 0x8A88, 0x8A88, 0x934B, 0xA46F, 0x8AE9, 0x8AA8, 0x8288, 0x8248, 0x7A47, 0x7A47, 0x8248, 0x8248, 0x8268, 0x8268, 0x8268, 0x8248, 
        0x8248, 0x8268, 0x8268, 0x8268, 0x7A68, 0x7B8D, 0x834C, 0x8247, 0x8268, 0x8268, 0x8248, 0x7A47, 0x7B0B, 0x7B6D, 0x72AA, 0xBDD6, 0xBE18, 0xCE79, 0xCE79, 0xD6BA, 0xA4B2, 0x7227, 0x4985, 0x49A5, 0x7227, 0x7227, 0x7227, 0x7207, 0x7207, 0x7207, 
        0x7207, 0x7207, 0x7207, 0x7207, 0x7227, 0x59A5, 0x59E6, 0x51A5, 0x7227, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x6A27, 0x41C5, 0x2143, 0x2143, 0x1943, 0x1902, 0x1943, 0x2164, 0x2163, 0x1943, 0x1943, 0x1943, 
        0x1902, 0x18E2, 0x10E2, 0x10E2, 0x1903, 0x2123, 0x1923, 0x2143, 0x2163, 0x2183, 0x2184, 0x29A4, 0x21A3, 0x2163, 0x29A4, 0x2184, 0x2985, 0x2184, 0x2163, 0x1922, 0x1922, 0x1922, 0x1902, 0x1902, 0x2162, 0x31E4, 0x4A45, 0x6A67, 0x7247, 0x7A27, 
        0x7A47, 0x6A47, 0x3163, 0x2162, 0x2163, 0x1942, 0x2162, 0x2183, 0x1922, 0x1102, 0x4AA9, 0x530B, 0x1922, 0x1942, 0x29A3, 0x29A3, 0x2183, 0x1922, 0x1922, 0x1922, 0x2162, 0x31E4, 0x4265, 0x3A45, 0x29C3, 0x3A25, 0x6B8D, 0x3A45, 0x5225, 0x7247, 
        0x7A27, 0x6A27, 0x39A4, 0x2984, 0x1922, 0x1902, 0x1902, 0x1922, 0x1922, 0x2143, 0x2163, 0x41C5, 0x5A06, 0x41C5, 0x2984, 0x2143, 0x1102, 0x1102, 0x1102, 0x10E2, 0x10E2, 0x1902, 0x1943, 0x1942, 0x2163, 0x39A4, 0x41E4, 0x31A4, 0x31A4, 0x2183, 
        0x2163, 0x2183, 0x2183, 0x2163, 0x2183, 0x2983, 0x39A4, 0x51E5, 0x61C5, 0x59C5, 0x59C5, 0x51E5, 0x49E4, 0x39E4, 0x29C3, 0x21A3, 0x2183, 0x1963, 0x2162, 0x31E4, 0x31A3, 0x1901, 0x2902, 0x3944, 0x4964, 0x59E6, 0x3183, 0x1942, 0x1943, 0x1943, 
        0x1902, 0x4A89, 0x3A47, 0x2143, 0x2984, 0x1903, 0x2143, 0x1943, 0x2184, 0x29A4, 0x29A4, 0x31E5, 0x29C5, 0x29C5, 0x29E5, 0x3205, 0x4286, 0x4266, 0x4246, 0x5B6C, 0x2963, 0x59E6, 0x7227, 0x7227, 0x6226, 0x3183, 0x1102, 0x1102, 0x1101,
  0x61C6, 0x6A06, 0x6206, 0x5ACA, 0x6B8E, 0x6227, 0x69C6, 0x69E6, 0x69E6, 0x7206, 0x7227, 0x6A06, 0x69E6, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 0x7206, 0x7206, 0x7206, 0x7227, 0x7227, 0x7227, 0x6A07, 0x7207, 0x7227, 0x6A27, 0x7227, 0x7227, 0x7207, 
        0x7207, 0x7207, 0x7227, 0x7227, 0x7227, 0x69E6, 0x69C6, 0x6A07, 0x7207, 0x7207, 0x7207, 0x69E6, 0x7206, 0x7227, 0x7207, 0x7207, 0x7227, 0x7206, 0x7206, 0x7207, 0x7207, 0x7226, 0x7A27, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 0x71E6, 0x7206, 
        0x7227, 0x7227, 0x7227, 0x7207, 0x7206, 0x7206, 0x7207, 0x6A06, 0x69E6, 0x6A06, 0x6A07, 0x6A27, 0x6A07, 0x6A07, 0x6A06, 0x6A06, 0x6A27, 0x6A27, 0x6A27, 0x6A27, 0x6A06, 0x51A5, 0x6A27, 0x7227, 0x7227, 0x7207, 0x6A07, 0x7227, 0x7227, 0x7227, 
        0x7227, 0x7207, 0x7227, 0x7227, 0x7247, 0x7227, 0x7207, 0x7227, 0x7227, 0x7207, 0x7206, 0x69E6, 0x7206, 0x7206, 0x7206, 0x7207, 0x7207, 0x7206, 0x7206, 0x7206, 0x69E6, 0x69C6, 0x7207, 0x7207, 0x7207, 0x7227, 0x7207, 0x7227, 0x7227, 0x7227, 
        0x7207, 0x7207, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A67, 0x7A67, 0x7A47, 0x7A47, 0x7A27, 0x7AEA, 0x8451, 0x6A89, 0x940F, 0xAE35, 0xA5D5, 0x9533, 0xA5D4, 
        0xB615, 0xB5B6, 0x82C9, 0x7A27, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x6A89, 0x636D, 0x5A28, 0x7227, 0x7A47, 0x7A67, 0x7A67, 0x7A47, 0x7A47, 0x7A47, 0x7247, 0x7A47, 0x7A47, 0x7A68, 0x8267, 0x8247, 0x7A47, 
        0x7A47, 0x8247, 0x8247, 0x8248, 0x7A48, 0x7A47, 0x7A47, 0x7A67, 0x7A47, 0x7A47, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x8267, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7227, 
        0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7A47, 0x7227, 0x69E6, 0x7A47, 0x8267, 0x8268, 0x7A47, 0x7A47, 0x8268, 0x8247, 0x7A27, 0x8248, 0x8227, 0x7A27, 0x7A27, 0x7227, 0x61E6, 0x59E6, 0x4985, 0x5185, 0x5185, 0x5185, 0x4945, 0x5165, 0x61A5, 0x61A5, 
        0x5985, 0x7227, 0x8AA9, 0x8AA9, 0x8A89, 0x932B, 0xA40E, 0x92C9, 0x8AA8, 0x92A8, 0x9288, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x934B, 0xAC8F, 0x8AC9, 0x8288, 0x8288, 0x8248, 0x7A47, 0x8268, 0x8268, 0x8248, 0x8268, 0x8268, 0x8268, 0x8268, 
        0x8248, 0x8268, 0x8268, 0x8268, 0x7A68, 0x7BAD, 0x836C, 0x8247, 0x8268, 0x8268, 0x8268, 0x8248, 0x836C, 0x83AE, 0x7AAA, 0xC618, 0xC69A, 0xCEBA, 0xCEDA, 0xCE9A, 0xA4B2, 0x7228, 0x61C6, 0x61C6, 0x7227, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 
        0x7207, 0x7207, 0x7207, 0x7207, 0x7227, 0x6A27, 0x4185, 0x4165, 0x6A27, 0x7A47, 0x7A47, 0x8247, 0x8247, 0x7A47, 0x7A47, 0x7A47, 0x8247, 0x7A47, 0x6A06, 0x39C4, 0x2143, 0x1902, 0x1102, 0x10E1, 0x18E2, 0x1922, 0x1943, 0x1922, 0x1902, 0x1923, 
        0x1902, 0x18E2, 0x10C2, 0x10E2, 0x1902, 0x1923, 0x1902, 0x1902, 0x1943, 0x1943, 0x1943, 0x2163, 0x1963, 0x1942, 0x2163, 0x1943, 0x2144, 0x1922, 0x1922, 0x08C1, 0x10E2, 0x10E2, 0x10C1, 0x1922, 0x2183, 0x31E4, 0x4225, 0x5A66, 0x7267, 0x7A47, 
        0x6226, 0x41E5, 0x31C4, 0x2163, 0x1922, 0x2983, 0x29A3, 0x2183, 0x1942, 0x1922, 0x4AA9, 0x530B, 0x1942, 0x1963, 0x21A3, 0x29C4, 0x29A3, 0x2143, 0x2143, 0x1922, 0x1922, 0x2983, 0x29A3, 0x31E4, 0x29C3, 0x3A05, 0x638D, 0x4245, 0x4A25, 0x6A26, 
        0x6A26, 0x49A5, 0x2143, 0x2143, 0x1943, 0x1902, 0x1902, 0x1922, 0x1923, 0x1943, 0x2984, 0x41C5, 0x5206, 0x41C5, 0x2963, 0x2143, 0x1902, 0x1902, 0x1902, 0x1902, 0x1902, 0x1902, 0x1922, 0x1943, 0x2163, 0x31A4, 0x39C4, 0x2963, 0x2163, 0x2183, 
        0x2163, 0x2163, 0x2163, 0x2163, 0x2163, 0x29A3, 0x39C4, 0x49E5, 0x61E6, 0x59E5, 0x51E5, 0x41E4, 0x31C4, 0x29A3, 0x2183, 0x2183, 0x1942, 0x1963, 0x1963, 0x29A3, 0x39E4, 0x39A4, 0x51A5, 0x59C5, 0x59E6, 0x51E5, 0x2963, 0x1942, 0x1922, 0x1922, 
        0x1102, 0x4268, 0x3A47, 0x2984, 0x31C5, 0x2964, 0x2164, 0x2164, 0x2164, 0x2184, 0x29A4, 0x29C4, 0x2184, 0x2184, 0x29A4, 0x29A4, 0x3A25, 0x3A25, 0x4246, 0x6BAD, 0x2163, 0x3984, 0x6206, 0x6206, 0x49C4, 0x3184, 0x1902, 0x1942, 0x2183,
  0x61C6, 0x6A06, 0x6206, 0x5AEA, 0x6BAE, 0x6207, 0x69C6, 0x69E6, 0x69E6, 0x6A06, 0x6A06, 0x6A06, 0x69E6, 0x6A06, 0x7207, 0x7207, 0x7207, 0x7206, 0x71E6, 0x7206, 0x7206, 0x7206, 0x7207, 0x7207, 0x69E6, 0x69E6, 0x6A07, 0x6A27, 0x6A27, 0x7227, 0x6A06, 
        0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x69E6, 0x69C6, 0x7207, 0x7227, 0x7207, 0x7227, 0x6A06, 0x6A06, 0x7207, 0x7207, 0x7227, 0x7227, 0x7206, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x7207, 0x7207, 0x7227, 0x7207, 0x7207, 0x7206, 0x7206, 
        0x7227, 0x7227, 0x7227, 0x7207, 0x7206, 0x6A06, 0x7207, 0x6A07, 0x6A06, 0x6A06, 0x6A06, 0x6A07, 0x6A07, 0x6A07, 0x6A06, 0x6A06, 0x6A06, 0x6A27, 0x6A27, 0x6A27, 0x6A07, 0x51A5, 0x6A47, 0x7247, 0x7227, 0x7227, 0x7207, 0x7227, 0x7247, 0x7227, 
        0x7227, 0x6A07, 0x7227, 0x7227, 0x7227, 0x7227, 0x69E6, 0x7207, 0x7227, 0x7227, 0x7207, 0x69E6, 0x6A06, 0x7207, 0x7207, 0x6A06, 0x6A06, 0x7206, 0x7206, 0x7206, 0x7207, 0x69E6, 0x7207, 0x7207, 0x7227, 0x7227, 0x7227, 0x6A27, 0x6A26, 0x6206, 
        0x6A06, 0x7207, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A47, 0x8247, 0x7A47, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x72EA, 0x8451, 0x6A89, 0x940F, 0xB656, 0xADF3, 0xADB2, 0xADD3, 
        0xB616, 0xB5B6, 0x82CA, 0x7A27, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x6A89, 0x636D, 0x5A48, 0x7227, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A67, 0x7A68, 0x8268, 0x7A47, 0x7A47, 
        0x7A47, 0x7A47, 0x7A47, 0x8268, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A67, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7227, 0x7227, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7227, 
        0x7A27, 0x7A47, 0x7A47, 0x7A27, 0x7A47, 0x7227, 0x61C6, 0x7227, 0x7A68, 0x7A88, 0x7227, 0x7227, 0x7A47, 0x7A27, 0x7206, 0x8248, 0x8247, 0x7A27, 0x7A27, 0x7227, 0x6206, 0x59C6, 0x4985, 0x5185, 0x5185, 0x5165, 0x4924, 0x5165, 0x61A5, 0x59A5, 
        0x5985, 0x7227, 0x8AC9, 0x8AA9, 0x8AA9, 0x8AA8, 0x8A88, 0x8A89, 0x8AA9, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x92EA, 0x9B8C, 0x8AA9, 0x82A8, 0x8288, 0x8248, 0x8248, 0x8268, 0x8268, 0x8248, 0x8248, 0x8268, 0x8268, 0x8268, 
        0x8248, 0x8268, 0x8268, 0x8268, 0x8268, 0x7B6D, 0x7B4C, 0x7A47, 0x8268, 0x8268, 0x8268, 0x7A47, 0x7B4C, 0x7BAE, 0x7ACA, 0xC638, 0xC69A, 0xCE7A, 0xCDB7, 0xC4D5, 0xA471, 0x7248, 0x6A07, 0x69E6, 0x7227, 0x7227, 0x7207, 0x7207, 0x7207, 0x7207, 
        0x7207, 0x6A07, 0x7207, 0x6A06, 0x7AA9, 0x730B, 0x3164, 0x18C2, 0x4985, 0x7A47, 0x7A27, 0x7A47, 0x8247, 0x8248, 0x8248, 0x8248, 0x8268, 0x7A47, 0x6A27, 0x4A05, 0x29A4, 0x2184, 0x2184, 0x1922, 0x1922, 0x2143, 0x1943, 0x1943, 0x1902, 0x1902, 
        0x10E2, 0x10A1, 0x0881, 0x10A1, 0x1903, 0x1902, 0x10E2, 0x10E2, 0x10C1, 0x1902, 0x1943, 0x2183, 0x2183, 0x2183, 0x2183, 0x1922, 0x10E2, 0x08A1, 0x1102, 0x10E2, 0x10E2, 0x10E2, 0x10C1, 0x1943, 0x29C4, 0x29C4, 0x39E4, 0x6246, 0x7A68, 0x6226, 
        0x31A3, 0x2143, 0x1922, 0x10E2, 0x10A1, 0x1902, 0x2163, 0x2163, 0x1963, 0x1942, 0x4289, 0x532B, 0x21A4, 0x21A3, 0x21A3, 0x29C4, 0x2183, 0x1942, 0x1922, 0x1942, 0x2163, 0x2142, 0x1922, 0x29A3, 0x29A3, 0x31E5, 0x636D, 0x3A46, 0x4AA7, 0x5AA8, 
        0x62A9, 0x4227, 0x3A47, 0x2164, 0x1902, 0x1102, 0x1922, 0x1923, 0x1923, 0x2143, 0x29A4, 0x29A4, 0x31A4, 0x2163, 0x1922, 0x1943, 0x1923, 0x1923, 0x18E2, 0x1902, 0x1923, 0x1923, 0x1922, 0x1922, 0x2143, 0x2984, 0x39C5, 0x2983, 0x1943, 0x1943, 
        0x2143, 0x1943, 0x2163, 0x2164, 0x2143, 0x2163, 0x2983, 0x39A4, 0x5A05, 0x49E5, 0x39A4, 0x3184, 0x2163, 0x2163, 0x1922, 0x1922, 0x1922, 0x1942, 0x1963, 0x2183, 0x31E4, 0x5226, 0x6206, 0x6206, 0x49C5, 0x3184, 0x2143, 0x2143, 0x1923, 0x1943, 
        0x1943, 0x4268, 0x3A47, 0x2163, 0x2184, 0x2184, 0x1102, 0x1902, 0x1902, 0x1943, 0x29A4, 0x2183, 0x1943, 0x1943, 0x1122, 0x1942, 0x2162, 0x29C3, 0x3A26, 0x6BAD, 0x1922, 0x2142, 0x49C5, 0x6206, 0x3184, 0x1943, 0x1922, 0x1922, 0x2183,
  0x61C6, 0x69E6, 0x61E6, 0x5AEB, 0x6B8E, 0x6207, 0x69E6, 0x69E6, 0x69E6, 0x6A06, 0x6A07, 0x6A06, 0x69E6, 0x6A06, 0x7207, 0x7207, 0x7227, 0x7207, 0x6A06, 0x7206, 0x7207, 0x7207, 0x7227, 0x7207, 0x69E6, 0x69E6, 0x6A07, 0x6A27, 0x6A27, 0x6A27, 0x61E6, 
        0x6A06, 0x6A27, 0x6A27, 0x6A27, 0x7227, 0x69E6, 0x69E6, 0x7227, 0x6A27, 0x7227, 0x7227, 0x7207, 0x7207, 0x7207, 0x7227, 0x6A07, 0x6A07, 0x7207, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7207, 0x7227, 0x7227, 0x7227, 0x7207, 0x7206, 
        0x7227, 0x7227, 0x7227, 0x7227, 0x7207, 0x7207, 0x7207, 0x7207, 0x6A06, 0x6A06, 0x6A06, 0x6A07, 0x6A07, 0x6A27, 0x6A27, 0x6A07, 0x7227, 0x7227, 0x6A27, 0x7227, 0x6A06, 0x51A5, 0x6A27, 0x7247, 0x7A47, 0x7227, 0x7227, 0x7227, 0x7247, 0x7227, 
        0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x7206, 0x7207, 0x7227, 0x7227, 0x7207, 0x6A07, 0x7227, 0x7227, 0x7227, 0x7207, 0x69E6, 0x6A27, 0x6A47, 0x6226, 0x5A06, 0x5205, 0x41C4, 0x31A4, 0x31A3, 
        0x41C4, 0x5205, 0x6226, 0x6226, 0x7247, 0x7A47, 0x7A27, 0x7A27, 0x8247, 0x7A47, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7A47, 0x7A27, 0x7AEA, 0x8451, 0x6A69, 0x940F, 0xCEDA, 0xBE36, 0xADD3, 0xB657, 
        0xCEBA, 0xB5D6, 0x7ACA, 0x7A27, 0x8247, 0x8247, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x6A69, 0x636E, 0x5A48, 0x7227, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A67, 0x7A47, 0x7A47, 
        0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x8267, 0x7A47, 0x7A47, 0x8248, 0x8268, 0x7A47, 0x7A47, 0x7A47, 0x7A48, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7227, 0x7227, 0x7A27, 0x7A47, 0x7A27, 0x7A47, 0x7A27, 0x7A27, 0x7227, 0x7227, 0x7227, 0x7227, 
        0x7A27, 0x7A47, 0x7A47, 0x7227, 0x7A47, 0x7227, 0x61C6, 0x7227, 0x7A68, 0x7A68, 0x7247, 0x7A47, 0x8268, 0x7A47, 0x69E6, 0x8248, 0x8268, 0x7A27, 0x7A27, 0x7227, 0x61E6, 0x59A6, 0x4985, 0x5185, 0x5185, 0x5165, 0x4924, 0x5165, 0x59A5, 0x59A5, 
        0x5985, 0x7A27, 0x92A9, 0x8AA9, 0x8AA9, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A68, 0x8A88, 0x8288, 0x8288, 0x8268, 0x8248, 0x8268, 0x8268, 0x8268, 0x8268, 0x8268, 0x8268, 0x8248, 
        0x8268, 0x8248, 0x8268, 0x8268, 0x8268, 0x732C, 0x7B6D, 0x7A47, 0x8268, 0x8268, 0x8268, 0x7A47, 0x730B, 0x736D, 0x7ACA, 0xC638, 0xBE59, 0xB515, 0xC3D3, 0xCC34, 0xAC51, 0x7248, 0x69E6, 0x69E6, 0x7227, 0x7207, 0x7207, 0x7207, 0x7207, 0x7207, 
        0x7207, 0x6A06, 0x69E6, 0x7207, 0x6A88, 0x41C6, 0x2103, 0x18C2, 0x51C6, 0x7A47, 0x7A27, 0x7A27, 0x7A47, 0x8247, 0x7A47, 0x8248, 0x8248, 0x7A47, 0x6A47, 0x4205, 0x2984, 0x2184, 0x29A4, 0x29A4, 0x29A4, 0x2163, 0x1943, 0x1943, 0x10E2, 0x10C2, 
        0x1902, 0x10A1, 0x10A1, 0x10C2, 0x10C2, 0x10E2, 0x10E2, 0x10C2, 0x10E2, 0x10C1, 0x1902, 0x1942, 0x2183, 0x21A4, 0x21A4, 0x1943, 0x10E2, 0x08C1, 0x10E2, 0x1922, 0x1922, 0x1922, 0x1922, 0x1942, 0x3205, 0x31E4, 0x31C4, 0x5246, 0x5A26, 0x39C4, 
        0x1922, 0x1902, 0x1902, 0x1902, 0x10E2, 0x10E2, 0x1102, 0x1102, 0x1963, 0x1102, 0x4268, 0x530B, 0x1943, 0x2183, 0x21A3, 0x29C3, 0x29C4, 0x31E4, 0x3204, 0x1942, 0x2163, 0x31E4, 0x2983, 0x1922, 0x2984, 0x29A4, 0x530B, 0x4A88, 0xB5D6, 0xBE37, 
        0xBE38, 0xB5F7, 0xB617, 0x6BCD, 0x08C1, 0x10C2, 0x10E2, 0x1943, 0x1922, 0x1922, 0x1943, 0x2183, 0x2183, 0x1922, 0x1943, 0x2163, 0x2143, 0x1922, 0x1943, 0x1923, 0x1102, 0x1102, 0x1922, 0x1943, 0x2143, 0x2984, 0x29A3, 0x2163, 0x1922, 0x1922, 
        0x1902, 0x1923, 0x1102, 0x10E2, 0x1923, 0x1943, 0x2143, 0x3184, 0x49E5, 0x41E4, 0x31C4, 0x2163, 0x1943, 0x1943, 0x1922, 0x1922, 0x1943, 0x1102, 0x1922, 0x1942, 0x29A4, 0x4205, 0x49E5, 0x51C5, 0x41C5, 0x2943, 0x2143, 0x1923, 0x1922, 0x1922, 
        0x1102, 0x4289, 0x3A67, 0x1102, 0x2163, 0x2163, 0x10C1, 0x0860, 0x10A1, 0x2163, 0x1942, 0x1902, 0x1942, 0x1122, 0x1122, 0x1122, 0x1943, 0x2183, 0x3205, 0x6BED, 0x2183, 0x2143, 0x39A4, 0x49E5, 0x3184, 0x10E2, 0x10C1, 0x10C1, 0x1102,
  0x61C6, 0x61E6, 0x6206, 0x5AEB, 0x6BAE, 0x59E7, 0x61E6, 0x69E6, 0x61E6, 0x6A06, 0x6A27, 0x6A06, 0x69E6, 0x6A06, 0x6A07, 0x6A06, 0x6A07, 0x6A06, 0x6A06, 0x69E6, 0x6A06, 0x7207, 0x7207, 0x6A07, 0x69E6, 0x69E6, 0x6A07, 0x6A06, 0x6A07, 0x6A27, 0x61E6, 
        0x61E6, 0x6206, 0x6A27, 0x6A27, 0x7227, 0x69E6, 0x69E6, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x6A07, 0x6A07, 0x7227, 0x7227, 0x7227, 0x7207, 0x7227, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7207, 0x7207, 
        0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x6A06, 0x6A07, 0x6A27, 0x7227, 0x7227, 0x7227, 0x6A07, 0x7227, 0x6A27, 0x7227, 0x7227, 0x6A07, 0x59C6, 0x7247, 0x7227, 0x7247, 0x7227, 0x7227, 0x7227, 0x7247, 0x7A27, 
        0x7A47, 0x7227, 0x7227, 0x7247, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7207, 0x7207, 0x7227, 0x7247, 0x7227, 0x6A07, 0x6227, 0x49E5, 0x2983, 0x2963, 0x2183, 0x29C4, 0x21A3, 0x2183, 
        0x2183, 0x21A3, 0x29C3, 0x31C4, 0x5225, 0x6A47, 0x7247, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7227, 0x7A47, 0x7A27, 0x7AEA, 0x8451, 0x6A69, 0x940F, 0xD6DB, 0xC679, 0xB617, 0xC6BA, 
        0xD6DB, 0xB5B6, 0x7ACA, 0x7A27, 0x7A47, 0x8268, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x7A27, 0x6A89, 0x636E, 0x5A48, 0x6A07, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7247, 0x7A47, 0x7A47, 0x7A47, 0x7A68, 0x7A67, 0x7A47, 0x7A47, 
        0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7A47, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7227, 
        0x7A27, 0x7A47, 0x7227, 0x7A27, 0x7A47, 0x6A07, 0x61A6, 0x7227, 0x8288, 0x8288, 0x7A47, 0x7A47, 0x8268, 0x8248, 0x6A06, 0x8247, 0x8247, 0x7A27, 0x7A27, 0x7227, 0x61E6, 0x51A5, 0x4965, 0x4965, 0x5185, 0x5165, 0x4945, 0x5185, 0x59C6, 0x59A5, 
        0x5985, 0x7A27, 0x92A9, 0x8AA8, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A68, 0x8A68, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8288, 0x8288, 0x8268, 0x7A48, 0x8268, 0x8268, 0x8268, 0x8268, 0x8268, 0x8268, 0x8268, 
        0x8268, 0x8268, 0x8268, 0x8268, 0x8268, 0x736D, 0x7B8D, 0x7A48, 0x8268, 0x8268, 0x8268, 0x7A47, 0x732C, 0x736D, 0x7AA9, 0xC617, 0xA5F6, 0xA533, 0xC413, 0xCC54, 0xA451, 0x7268, 0x61E6, 0x6A07, 0x7207, 0x7207, 0x7207, 0x69E6, 0x6A06, 0x7207, 
        0x6A07, 0x7207, 0x7207, 0x7207, 0x7207, 0x5185, 0x2923, 0x2924, 0x6207, 0x7A47, 0x7A27, 0x7A27, 0x8247, 0x8247, 0x8248, 0x8247, 0x8267, 0x7227, 0x5A06, 0x3184, 0x1902, 0x2163, 0x1922, 0x1922, 0x2183, 0x2163, 0x29A4, 0x2143, 0x10C1, 0x10C2, 
        0x10C2, 0x10E2, 0x10E2, 0x10C1, 0x10C2, 0x10C2, 0x08A1, 0x10C2, 0x1902, 0x1102, 0x1902, 0x1922, 0x1943, 0x1943, 0x1922, 0x1943, 0x1922, 0x10E2, 0x10E1, 0x1902, 0x1922, 0x1943, 0x1963, 0x1962, 0x29C4, 0x29C4, 0x39C4, 0x41E4, 0x2942, 0x1901, 
        0x1902, 0x1922, 0x10E2, 0x10E1, 0x1922, 0x1922, 0x1902, 0x1923, 0x10C2, 0x08A1, 0x3A48, 0x5B4C, 0x08C1, 0x1102, 0x1922, 0x21A3, 0x29C3, 0x29A3, 0x29A3, 0x2162, 0x2142, 0x29A3, 0x2183, 0x1102, 0x1922, 0x29C5, 0x5B4D, 0x3A27, 0xBE38, 0xCEBA, 
        0xC658, 0xCE9A, 0xD6DB, 0x7C2F, 0x08A1, 0x08A1, 0x10C2, 0x1903, 0x1922, 0x1922, 0x1922, 0x1943, 0x2183, 0x1922, 0x1943, 0x2163, 0x1922, 0x1922, 0x1922, 0x1922, 0x1122, 0x1102, 0x1922, 0x1943, 0x1942, 0x2983, 0x2183, 0x1922, 0x10E1, 0x10C1, 
        0x1902, 0x2143, 0x1922, 0x10E2, 0x10E2, 0x10E2, 0x1102, 0x2183, 0x31A4, 0x31A4, 0x31A4, 0x2163, 0x2164, 0x1922, 0x1943, 0x1922, 0x1102, 0x1102, 0x1922, 0x1943, 0x2163, 0x39C4, 0x41C4, 0x3184, 0x2984, 0x1922, 0x1922, 0x1922, 0x1102, 0x1102, 
        0x10E2, 0x4268, 0x4288, 0x1122, 0x2163, 0x2163, 0x2143, 0x10E2, 0x10E2, 0x2183, 0x2163, 0x1922, 0x1963, 0x1942, 0x1102, 0x1102, 0x1122, 0x1963, 0x29E5, 0x6BCD, 0x2184, 0x39A5, 0x41C5, 0x2943, 0x18E2, 0x10C1, 0x18E2, 0x1922, 0x2143,
  0x61C6, 0x69E6, 0x61E6, 0x5AEB, 0x6BAE, 0x59E7, 0x61C6, 0x61E6, 0x69E6, 0x6A06, 0x6A06, 0x69E6, 0x61E6, 0x6A06, 0x6A07, 0x6A06, 0x6A07, 0x6A06, 0x6A06, 0x6A06, 0x7207, 0x6A07, 0x6A06, 0x6A06, 0x69E6, 0x69E6, 0x6A07, 0x6A07, 0x6A07, 0x6A07, 0x6A06, 
        0x6A06, 0x6206, 0x6206, 0x6206, 0x6A07, 0x69E6, 0x69E6, 0x6A07, 0x7207, 0x7207, 0x7227, 0x7227, 0x7227, 0x7207, 0x7207, 0x7207, 0x6A07, 0x6A06, 0x7227, 0x7227, 0x7227, 0x7207, 0x7207, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x6A06, 0x7207, 
        0x7227, 0x7227, 0x7227, 0x7227, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x6A07, 0x6A07, 0x7227, 0x7227, 0x7207, 0x7227, 0x7227, 0x6A27, 0x6A27, 0x7227, 0x6A27, 0x6A06, 0x59C6, 0x7227, 0x7227, 0x7227, 0x7227, 0x6A27, 0x7227, 0x7247, 0x7A27, 
        0x7A27, 0x7227, 0x7247, 0x7247, 0x7247, 0x7227, 0x7227, 0x7247, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7207, 0x7227, 0x7227, 0x7247, 0x6206, 0x49C4, 0x39A4, 0x2963, 0x2163, 0x2163, 0x2163, 0x2183, 0x2163, 0x2183, 
        0x2183, 0x2183, 0x1982, 0x2183, 0x29A3, 0x31C4, 0x49E5, 0x6A26, 0x7A48, 0x7A47, 0x7A47, 0x7A48, 0x7A68, 0x7A48, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x72CA, 0x7C10, 0x6269, 0x942F, 0xD71C, 0xCEFB, 0xCEDB, 0xCEFB, 
        0xD71C, 0xBDD7, 0x7ACA, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7227, 0x6A89, 0x6B8E, 0x5A48, 0x6A07, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7A47, 0x7A67, 0x7A47, 0x7A47, 0x7A47, 
        0x7A47, 0x8247, 0x7A47, 0x7A47, 0x7A67, 0x7A47, 0x7A47, 0x8268, 0x7A68, 0x7A47, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7227, 0x7247, 0x7A47, 0x7A68, 0x7A67, 0x7A47, 0x7A47, 0x7A47, 0x7227, 0x7227, 0x7227, 
        0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7207, 0x59A5, 0x7227, 0x8268, 0x8A68, 0x7A47, 0x7A27, 0x8268, 0x8268, 0x7207, 0x8248, 0x8248, 0x7A47, 0x7A27, 0x7227, 0x61E6, 0x5185, 0x4965, 0x4965, 0x5185, 0x4964, 0x4924, 0x5165, 0x59A5, 0x5985, 
        0x5985, 0x7227, 0x8AA9, 0x8A88, 0x8A88, 0x8A88, 0x8A68, 0x8A68, 0x8A68, 0x8A68, 0x8A68, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8A88, 0x8248, 0x7A47, 0x7A47, 0x7A47, 0x8268, 0x8268, 0x8268, 0x8268, 0x8268, 
        0x8268, 0x8268, 0x8268, 0x8268, 0x7A68, 0x736D, 0x736D, 0x7A68, 0x8268, 0x8268, 0x8268, 0x7A68, 0x734C, 0x736D, 0x72A9, 0xAD94, 0x9DF3, 0xA634, 0xB492, 0xCC14, 0xAC31, 0x6A48, 0x61E6, 0x69E7, 0x7207, 0x7207, 0x71E7, 0x6A06, 0x6A06, 0x6A06, 
        0x6A07, 0x7207, 0x7207, 0x7207, 0x7207, 0x7A27, 0x4144, 0x18A2, 0x4985, 0x8248, 0x7A47, 0x7A27, 0x8247, 0x8247, 0x8248, 0x8268, 0x7A67, 0x6A27, 0x41A4, 0x2963, 0x1922, 0x2143, 0x1943, 0x1922, 0x1922, 0x1922, 0x1902, 0x1902, 0x18E2, 0x10C2, 
        0x10C2, 0x10E2, 0x18E2, 0x10C2, 0x08A2, 0x10C2, 0x1902, 0x1923, 0x1943, 0x1903, 0x1102, 0x1943, 0x2163, 0x1963, 0x1922, 0x1102, 0x1102, 0x1102, 0x10E2, 0x10C1, 0x10E2, 0x1902, 0x1942, 0x2163, 0x21A3, 0x29C3, 0x4A25, 0x6A47, 0x59E5, 0x41C5, 
        0x2122, 0x1922, 0x1922, 0x1902, 0x10E2, 0x1922, 0x1922, 0x1902, 0x10E2, 0x08A1, 0x4248, 0x5B4C, 0x08A1, 0x10E2, 0x1943, 0x1962, 0x21A3, 0x2183, 0x2183, 0x29A4, 0x2183, 0x1922, 0x2163, 0x1902, 0x10E1, 0x2984, 0x6B8E, 0x3A27, 0xB5F7, 0xA5B6, 
        0x9D53, 0xB5D6, 0xD6DB, 0x7C2F, 0x08A2, 0x10C2, 0x10C2, 0x10E2, 0x1902, 0x1902, 0x1923, 0x1922, 0x2184, 0x2163, 0x1922, 0x1922, 0x1922, 0x1943, 0x1102, 0x1922, 0x1922, 0x1122, 0x1102, 0x1902, 0x1942, 0x2183, 0x2983, 0x1902, 0x08A1, 0x08A1, 
        0x10E2, 0x10C2, 0x10E2, 0x1943, 0x10E2, 0x08C1, 0x10E2, 0x1943, 0x2183, 0x2983, 0x2983, 0x1902, 0x1102, 0x1102, 0x1102, 0x10E2, 0x1923, 0x1122, 0x1122, 0x1922, 0x1922, 0x3184, 0x41E5, 0x2963, 0x1922, 0x1102, 0x1102, 0x1102, 0x1902, 0x1102, 
        0x10E2, 0x3A68, 0x3A27, 0x1102, 0x1922, 0x1942, 0x2163, 0x2183, 0x1942, 0x1942, 0x1122, 0x1102, 0x1943, 0x1963, 0x1122, 0x10E1, 0x1102, 0x1122, 0x29C5, 0x5B4C, 0x4268, 0x8C50, 0x8C91, 0x9491, 0x8C91, 0x6BAC, 0x1902, 0x1902, 0x1922,
  0x61C6, 0x69E6, 0x61E6, 0x5B0B, 0x6B8E, 0x59E7, 0x61C6, 0x69E6, 0x69E6, 0x6A06, 0x6A06, 0x69E6, 0x61C6, 0x6A07, 0x6A07, 0x7227, 0x6A07, 0x6A06, 0x69E6, 0x6A06, 0x7207, 0x6A27, 0x6A07, 0x6A06, 0x69E6, 0x6A07, 0x6A07, 0x6A07, 0x6A06, 0x6A06, 0x6206, 
        0x6A07, 0x6A07, 0x6207, 0x6A07, 0x6A07, 0x69E6, 0x69E6, 0x6A07, 0x7227, 0x7227, 0x7227, 0x6A06, 0x7227, 0x7207, 0x6A07, 0x6A07, 0x6A07, 0x69E6, 0x7206, 0x7227, 0x7227, 0x7227, 0x7227, 0x7207, 0x7227, 0x7227, 0x7227, 0x7207, 0x69E6, 0x69E6, 
        0x7207, 0x7227, 0x7227, 0x7207, 0x69E6, 0x69E6, 0x6A07, 0x6A07, 0x6A07, 0x69E6, 0x69E6, 0x6A07, 0x6A27, 0x6A06, 0x6A06, 0x6A07, 0x7227, 0x7227, 0x7227, 0x7227, 0x6A06, 0x51A5, 0x6A47, 0x6A27, 0x7227, 0x7227, 0x6A07, 0x7227, 0x7247, 0x7227, 
        0x7227, 0x7227, 0x7247, 0x7247, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x6A06, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x7227, 0x7247, 0x6206, 0x3183, 0x1942, 0x1942, 0x2163, 0x2163, 0x1942, 0x1922, 0x1922, 0x1942, 0x1942, 
        0x1942, 0x1962, 0x1942, 0x1942, 0x1962, 0x1962, 0x2162, 0x39C4, 0x6A47, 0x7A47, 0x7247, 0x7A47, 0x7247, 0x7A48, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x72CA, 0x73EF, 0x6268, 0x834C, 0xA4F3, 0x9CB2, 0x9C92, 0x9C91, 
        0x9CB2, 0x942F, 0x7AA9, 0x7A27, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7227, 0x6A69, 0x6B6E, 0x5A28, 0x6A06, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7226, 0x7227, 0x7A47, 0x7227, 0x7A27, 0x7A47, 
        0x8247, 0x8247, 0x7A47, 0x7A47, 0x8267, 0x7A47, 0x7A47, 0x8247, 0x7A68, 0x7A47, 0x7A47, 0x7A47, 0x8247, 0x8247, 0x7A47, 0x7A47, 0x7A47, 0x7227, 0x7A27, 0x7A47, 0x7227, 0x7227, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7227, 0x7227, 0x7227, 0x7227, 
        0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7227, 0x59A5, 0x7227, 0x8268, 0x8A88, 0x7A47, 0x7A47, 0x8A68, 0x8268, 0x7227, 0x7A47, 0x8268, 0x8247, 0x7A27, 0x6A07, 0x61E6, 0x59A5, 0x4985, 0x51A5, 0x51C5, 0x51C6, 0x49A5, 0x51C5, 0x6206, 0x6206, 
        0x59C6, 0x7268, 0x8AE9, 0x82A9, 0x8AA9, 0x82A8, 0x8288, 0x8288, 0x8288, 0x8268, 0x8247, 0x8248, 0x8A68, 0x8A88, 0x8A88, 0x8A88, 0x8A68, 0x9288, 0x8A88, 0x8A88, 0x8A88, 0x8248, 0x7A48, 0x7A68, 0x7A68, 0x7A68, 0x7A67, 0x7A48, 0x7A48, 0x7A68, 
        0x7A68, 0x8268, 0x8247, 0x8247, 0x7A47, 0x736D, 0x83CE, 0x7A68, 0x7A47, 0x7A48, 0x7A48, 0x7A47, 0x732C, 0x736D, 0x72A9, 0xAD94, 0xA634, 0x9DF3, 0xB534, 0xCC34, 0xA451, 0x6A47, 0x61E6, 0x61E7, 0x7207, 0x6A07, 0x6A07, 0x6A07, 0x6A07, 0x6A06, 
        0x6A07, 0x6A07, 0x6A07, 0x7207, 0x7207, 0x7A27, 0x4964, 0x20C2, 0x59C6, 0x7A47, 0x7A27, 0x7A27, 0x8247, 0x8247, 0x7A48, 0x7A47, 0x7A68, 0x6A27, 0x51E5, 0x31C4, 0x2183, 0x2163, 0x29A4, 0x2184, 0x1943, 0x1943, 0x1902, 0x10E2, 0x1902, 0x18E2, 
        0x10C2, 0x18E2, 0x18E2, 0x1902, 0x10E2, 0x10C2, 0x1923, 0x1922, 0x1102, 0x1102, 0x10E2, 0x1902, 0x2163, 0x2183, 0x2183, 0x1102, 0x08C2, 0x10E2, 0x1122, 0x10E2, 0x10E2, 0x10E2, 0x1922, 0x1962, 0x1942, 0x2182, 0x29A3, 0x49E5, 0x6226, 0x41C4, 
        0x18E2, 0x1902, 0x10E2, 0x10C2, 0x10E2, 0x10C2, 0x1902, 0x1902, 0x1902, 0x0060, 0x4248, 0x638D, 0x1102, 0x10C1, 0x10E2, 0x2163, 0x29A3, 0x1102, 0x10E2, 0x10E2, 0x10E2, 0x10C1, 0x0881, 0x0881, 0x10A1, 0x2164, 0x73EF, 0x3A27, 0xAD95, 0x9573, 
        0xADF6, 0x9D94, 0xBE58, 0x7C50, 0x10E2, 0x10E2, 0x10E2, 0x10E2, 0x10E2, 0x10E2, 0x1902, 0x1922, 0x1922, 0x2143, 0x1923, 0x10C1, 0x1102, 0x1922, 0x1922, 0x1102, 0x1922, 0x1922, 0x10E2, 0x10E2, 0x1122, 0x2163, 0x2183, 0x1902, 0x10A1, 0x0881, 
        0x10A1, 0x0881, 0x08A1, 0x1923, 0x2143, 0x1943, 0x1102, 0x1102, 0x29A3, 0x31C4, 0x2983, 0x29A4, 0x1943, 0x10C1, 0x10E1, 0x10E2, 0x1102, 0x1943, 0x1922, 0x1922, 0x2983, 0x41E5, 0x49E5, 0x2983, 0x1922, 0x1102, 0x1102, 0x10C1, 0x10C1, 0x10E2, 
        0x10C2, 0x4268, 0x3247, 0x08C1, 0x1102, 0x1922, 0x2163, 0x2183, 0x1942, 0x1102, 0x10E2, 0x08C2, 0x08E2, 0x1942, 0x1943, 0x1922, 0x1942, 0x1942, 0x31E6, 0x5B4C, 0x5B2B, 0xC679, 0xC699, 0xCEDA, 0xD6BA, 0x9D32, 0x1922, 0x1102, 0x10E2,
  0x69E6, 0x69E7, 0x59E6, 0x5B0C, 0x634D, 0x59E7, 0x61E6, 0x6A06, 0x69E6, 0x6A06, 0x6A07, 0x6A06, 0x61C6, 0x6A07, 0x6A07, 0x6A07, 0x6A06, 0x6A07, 0x69E6, 0x6A06, 0x6A27, 0x6A27, 0x7207, 0x7207, 0x6A06, 0x6A06, 0x6A07, 0x6A06, 0x6A06, 0x6A07, 0x6A06, 
        0x6A07, 0x6A27, 0x6A27, 0x6A27, 0x6A27, 0x69E7, 0x69E6, 0x6A07, 0x6A27, 0x6A27, 0x7227, 0x7227, 0x7227, 0x7207, 0x6A07, 0x6A06, 0x6A06, 0x6A06, 0x6A06, 0x7227, 0x7227, 0x7227, 0x7227, 0x7207, 0x7207, 0x7207, 0x7207, 0x7206, 0x69E6, 0x69E6, 
        0x7207, 0x7227, 0x7227, 0x7207, 0x69E6, 0x6A06, 0x6A06, 0x6A06, 0x6A07, 0x61E6, 0x61E6, 0x6A07, 0x6A07, 0x7207, 0x69E6, 0x69E6, 0x6A07, 0x6A27, 0x6A27, 0x7227, 0x69E6, 0x51A5, 0x7247, 0x7227, 0x7227, 0x6A07, 0x6A06, 0x6A27, 0x7227, 0x7227, 
        0x7227, 0x7206, 0x7227, 0x7247, 0x7227, 0x7227, 0x7226, 0x7227, 0x7227, 0x7227, 0x7227, 0x7207, 0x7227, 0x7227, 0x7247, 0x7247, 0x7227, 0x7247, 0x6A27, 0x3183, 0x1902, 0x1922, 0x1922, 0x1102, 0x10E1, 0x1102, 0x10E2, 0x1102, 0x1942, 0x1922, 
        0x1102, 0x1922, 0x1922, 0x1922, 0x1942, 0x1942, 0x1942, 0x1962, 0x41E5, 0x7247, 0x7247, 0x7247, 0x7247, 0x7A47, 0x7A67, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7227, 0x7AEA, 0x7C30, 0x6AA9, 0x7227, 0x6A06, 0x7206, 0x6A06, 0x6A06, 
        0x6A06, 0x7227, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7A47, 0x7A27, 0x7A27, 0x7227, 0x6288, 0x636D, 0x5228, 0x6A06, 0x7A47, 0x7A67, 0x7A47, 0x7227, 0x7A47, 0x7A47, 0x7A47, 0x7226, 0x7247, 0x7A47, 0x7A27, 0x7227, 0x7A27, 
        0x7A47, 0x7A47, 0x7227, 0x7A47, 0x8267, 0x7A27, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7227, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7227, 0x7207, 0x7207, 0x7227, 0x7A27, 0x7227, 0x7207, 0x7227, 0x7227, 0x7206, 
        0x7A27, 0x7A27, 0x7A27, 0x7206, 0x7A47, 0x7A47, 0x5985, 0x7227, 0x8268, 0x8A88, 0x8267, 0x7A47, 0x8A68, 0x8288, 0x7A47, 0x8248, 0x8268, 0x8268, 0x7207, 0x7207, 0x6A07, 0x59A6, 0x49A5, 0x62A8, 0x6AE9, 0x6AE9, 0x7B8C, 0x8BCD, 0x9C4F, 0x9C90, 
        0x7B6C, 0x9C6F, 0xB552, 0xB511, 0xACF1, 0xACF1, 0xACB0, 0xA490, 0xA46F, 0x9C2E, 0xA42E, 0x9B8C, 0x82A8, 0x8288, 0x8268, 0x8268, 0x82A8, 0x7AA8, 0x6A67, 0x5A46, 0x5A26, 0x5226, 0x5226, 0x5246, 0x6246, 0x6A47, 0x7268, 0x7A68, 0x7A68, 0x7A68, 
        0x8268, 0x7A48, 0x8248, 0x8248, 0x7A47, 0x736D, 0x83CF, 0x7A68, 0x7A47, 0x7A48, 0x7A68, 0x7A47, 0x732B, 0x736D, 0x72A9, 0xB5F5, 0xA614, 0xA5F4, 0xC637, 0xCD76, 0xACD2, 0x6A27, 0x61E6, 0x61E7, 0x6A07, 0x6A07, 0x6A07, 0x6A07, 0x6A07, 0x6A07, 
        0x6A07, 0x6A07, 0x6A06, 0x7206, 0x7227, 0x7247, 0x4984, 0x59C6, 0x7A47, 0x7A47, 0x7A47, 0x7247, 0x6A26, 0x5A05, 0x49E5, 0x41E4, 0x49E5, 0x5206, 0x5226, 0x39E5, 0x29E5, 0x29A4, 0x2163, 0x2163, 0x1943, 0x10E1, 0x1102, 0x1922, 0x1902, 0x18E2, 
        0x10A1, 0x10C2, 0x10E2, 0x10E2, 0x10E2, 0x10E2, 0x1922, 0x1902, 0x10E2, 0x10E2, 0x10C1, 0x10E1, 0x1943, 0x2183, 0x2183, 0x1922, 0x10E2, 0x08C1, 0x10E2, 0x1102, 0x1922, 0x08C1, 0x10E1, 0x2163, 0x2162, 0x1922, 0x1942, 0x39E4, 0x5246, 0x41C4, 
        0x2963, 0x18E2, 0x10C1, 0x10E2, 0x1902, 0x10A1, 0x08A1, 0x10C2, 0x10C2, 0x08A1, 0x3A48, 0x638E, 0x1922, 0x10E2, 0x10E2, 0x1942, 0x2183, 0x1942, 0x1102, 0x10C1, 0x10C1, 0x10E2, 0x10C2, 0x0881, 0x0881, 0x2123, 0x6BCE, 0x31E6, 0xA553, 0xAE14, 
        0x9D73, 0x9D72, 0xB5F6, 0x7C50, 0x10E2, 0x08A1, 0x10C2, 0x18E3, 0x08A1, 0x10E2, 0x10E2, 0x1922, 0x1922, 0x10E2, 0x08A1, 0x0881, 0x10A2, 0x10E2, 0x1902, 0x1102, 0x10E2, 0x1902, 0x10E2, 0x1902, 0x1922, 0x1943, 0x21A3, 0x1942, 0x10C2, 0x08A1, 
        0x10A1, 0x10C2, 0x10E2, 0x10C1, 0x1902, 0x2163, 0x2183, 0x1963, 0x2163, 0x2183, 0x2183, 0x2183, 0x1943, 0x10A1, 0x10A1, 0x1102, 0x10E1, 0x10E1, 0x1102, 0x1922, 0x2183, 0x41E5, 0x49E5, 0x3163, 0x10E2, 0x10C2, 0x10C1, 0x10E2, 0x10C1, 0x08C1, 
        0x08C1, 0x4268, 0x4288, 0x10E1, 0x10E2, 0x10E2, 0x1963, 0x1942, 0x10E1, 0x08A1, 0x08A1, 0x10E2, 0x10C1, 0x1102, 0x1922, 0x1943, 0x2163, 0x1943, 0x29C5, 0x636C, 0x52EA, 0xC679, 0xBE58, 0xBD56, 0xC473, 0x9450, 0x1943, 0x08C1, 0x10C2,
  0x61E6, 0x61E6, 0x59E7, 0x5B0B, 0x6B6E, 0x5A07, 0x61E6, 0x6A27, 0x6247, 0x6A68, 0x7288, 0x6A68, 0x6A68, 0x72A9, 0x7268, 0x6A07, 0x6A06, 0x6A07, 0x69E6, 0x6A07, 0x7227, 0x6A27, 0x6A06, 0x6A27, 0x6A07, 0x6A27, 0x7227, 0x6A06, 0x6206, 0x6A07, 0x61E6, 
        0x6A07, 0x6A27, 0x7227, 0x6A27, 0x6A07, 0x69E6, 0x61E6, 0x6A07, 0x6A27, 0x6A07, 0x6A27, 0x6A27, 0x7227, 0x7207, 0x6A06, 0x69E6, 0x6A06, 0x69E6, 0x6A06, 0x7227, 0x7247, 0x7227, 0x7227, 0x7206, 0x7207, 0x7227, 0x7207, 0x7227, 0x7206, 0x69E6, 
        0x7207, 0x7227, 0x7227, 0x7207, 0x69E6, 0x6A07, 0x6A07, 0x6A07, 0x6A07, 0x69E6, 0x69E6, 0x6A07, 0x6A07, 0x7207, 0x69E6, 0x69E6, 0x7207, 0x7227, 0x6A27, 0x7207, 0x69C6, 0x51A5, 0x7247, 0x7227, 0x6A06, 0x6A06, 0x6A06, 0x7227, 0x7227, 0x7227, 
        0x7227, 0x6A06, 0x7227, 0x7227, 0x7227, 0x7227, 0x7206, 0x7227, 0x7227, 0x7227, 0x7227, 0x7207, 0x7207, 0x7227, 0x7247, 0x7227, 0x7227, 0x7247, 0x49C5, 0x1902, 0x1102, 0x1102, 0x1922, 0x10E1, 0x1102, 0x1922, 0x1122, 0x1102, 0x1122, 0x1102, 
        0x1102, 0x1902, 0x1922, 0x1922, 0x1922, 0x1922, 0x1942, 0x1962, 0x2962, 0x6A27, 0x7A48, 0x7247, 0x7247, 0x7A68, 0x7A67, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7AEB, 0x7C30, 0x62A9, 0x6A27, 0x7A27, 0x7A47, 0x7A27, 0x7A27, 
        0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7A47, 0x7A27, 0x7A27, 0x7227, 0x7227, 0x6A89, 0x636D, 0x5228, 0x69E6, 0x7A47, 0x7A67, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7226, 0x7A47, 0x7A67, 0x7227, 0x7226, 0x7A47, 
        0x7A47, 0x7A27, 0x7227, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7227, 0x7A47, 0x7A47, 0x7227, 0x6206, 0x6226, 0x6226, 0x6A47, 0x7227, 0x7A47, 0x7227, 0x7207, 0x7227, 0x7227, 0x7227, 0x7206, 0x7206, 0x7A27, 0x7227, 0x7206, 
        0x7227, 0x7A07, 0x7206, 0x7206, 0x7A27, 0x7A47, 0x59A5, 0x7207, 0x8268, 0x8A68, 0x8268, 0x7A47, 0x8268, 0x8268, 0x7A47, 0x8268, 0x8A88, 0x8267, 0x7207, 0x7207, 0x6A07, 0x61A6, 0x49A6, 0x62C9, 0x6B0A, 0x6B2A, 0x7BCD, 0x9C90, 0x9CB1, 0x9CB1, 
        0x8C2F, 0xA4F1, 0xBDB4, 0xB593, 0xB594, 0xB594, 0xBDB4, 0xBDB4, 0xBDD4, 0xBDD4, 0xC616, 0xC5F5, 0xB512, 0xA490, 0xAC90, 0xA44F, 0x6AE8, 0x39E4, 0x31A3, 0x29A3, 0x29A3, 0x29E3, 0x29C3, 0x29C3, 0x29C3, 0x31C4, 0x4A05, 0x6A67, 0x7268, 0x7A68, 
        0x7A68, 0x7A47, 0x8268, 0x7A47, 0x7247, 0x734C, 0x83EF, 0x7A68, 0x7A67, 0x7A68, 0x7A68, 0x7A47, 0x6AEB, 0x6B4D, 0x6AA9, 0xA5D5, 0x9E35, 0xAE76, 0xBE98, 0xCE99, 0xAD13, 0x6A47, 0x61E6, 0x61E7, 0x6A07, 0x6A06, 0x69E6, 0x6A07, 0x6A07, 0x69E6, 
        0x6A07, 0x6A07, 0x6A07, 0x6A07, 0x7227, 0x7247, 0x4985, 0x61E6, 0x7A47, 0x7247, 0x6A27, 0x49C5, 0x3183, 0x2163, 0x2183, 0x21A3, 0x21A3, 0x29A3, 0x29C3, 0x29C4, 0x2183, 0x1942, 0x1922, 0x2163, 0x1102, 0x1922, 0x2183, 0x2183, 0x1943, 0x1102, 
        0x10C2, 0x10C2, 0x10A1, 0x10C2, 0x10C2, 0x10E2, 0x10E2, 0x1922, 0x1943, 0x1943, 0x08C1, 0x1102, 0x1922, 0x1942, 0x1943, 0x1102, 0x08C1, 0x10E2, 0x10C2, 0x10C1, 0x1102, 0x10E1, 0x1102, 0x1102, 0x1983, 0x1962, 0x1942, 0x29A3, 0x4A25, 0x49E5, 
        0x3163, 0x10E2, 0x08A1, 0x10C1, 0x10E2, 0x1102, 0x10E2, 0x10E2, 0x10E2, 0x08C1, 0x4268, 0x638D, 0x1102, 0x1102, 0x1922, 0x1922, 0x2183, 0x1943, 0x1943, 0x1902, 0x10A1, 0x0881, 0x10E2, 0x10E2, 0x10C2, 0x2164, 0x73CF, 0x31E6, 0xA595, 0xB635, 
        0xADD2, 0xA5B3, 0xBE37, 0x8450, 0x08C1, 0x0881, 0x0861, 0x10C2, 0x10C2, 0x10E2, 0x10E2, 0x1923, 0x1943, 0x10E2, 0x10C2, 0x10A2, 0x0881, 0x0881, 0x10C2, 0x08A1, 0x08A1, 0x10E2, 0x1102, 0x1102, 0x1102, 0x1943, 0x2183, 0x2163, 0x10E2, 0x10C1, 
        0x10E2, 0x1902, 0x1943, 0x10E2, 0x1102, 0x1943, 0x2184, 0x29C4, 0x1942, 0x1942, 0x2163, 0x2983, 0x1902, 0x10E2, 0x10E2, 0x10E1, 0x10E2, 0x1122, 0x10E2, 0x1102, 0x1922, 0x39C4, 0x5225, 0x3163, 0x10A1, 0x0881, 0x10C2, 0x08C1, 0x10C1, 0x0881, 
        0x08A1, 0x4268, 0x3A68, 0x08E1, 0x1102, 0x1102, 0x1922, 0x1102, 0x08C1, 0x08A1, 0x10C1, 0x1102, 0x1943, 0x1922, 0x1102, 0x1922, 0x1922, 0x1122, 0x29A5, 0x638C, 0x52EA, 0xBE38, 0xADD5, 0xB432, 0xC3F2, 0x9C30, 0x1943, 0x08C2, 0x10C2,
  0x9CB1, 0x9CD2, 0x9CF3, 0x9D34, 0xA575, 0xA513, 0xA534, 0xAD54, 0xAD74, 0xB5B6, 0xB5D6, 0xB5D6, 0xB5F7, 0xBE17, 0xA491, 0x6A07, 0x6A06, 0x6A06, 0x61E6, 0x69E6, 0x6A27, 0x7227, 0x7227, 0x6A27, 0x6A06, 0x6A27, 0x7227, 0x7247, 0x7247, 0x6A06, 0x6A06, 
        0x6A07, 0x6A27, 0x6A27, 0x6A27, 0x7227, 0x6A06, 0x6A06, 0x6A27, 0x7247, 0x7227, 0x7227, 0x7207, 0x7227, 0x7227, 0x7227, 0x6A27, 0x6A06, 0x61C6, 0x6A06, 0x7227, 0x7A47, 0x7227, 0x7207, 0x7206, 0x7227, 0x7226, 0x7227, 0x7227, 0x6A06, 0x69E6, 
        0x7207, 0x7227, 0x7227, 0x7227, 0x6A06, 0x6A27, 0x7227, 0x7227, 0x6A07, 0x69E6, 0x6A06, 0x6A07, 0x6A27, 0x6A06, 0x69E6, 0x69E6, 0x7207, 0x7227, 0x7207, 0x7227, 0x69E6, 0x5185, 0x7227, 0x7227, 0x7227, 0x6A06, 0x69E6, 0x6A07, 0x7227, 0x6A27, 
        0x6A27, 0x7207, 0x7227, 0x7227, 0x7227, 0x7227, 0x6A06, 0x7227, 0x7227, 0x7227, 0x7207, 0x69E6, 0x6A07, 0x7227, 0x7227, 0x7227, 0x7227, 0x6206, 0x3143, 0x10C1, 0x1102, 0x1101, 0x1101, 0x10E1, 0x1102, 0x1102, 0x1102, 0x1122, 0x1922, 0x1102, 
        0x1922, 0x1922, 0x1942, 0x1122, 0x1922, 0x1942, 0x1942, 0x1942, 0x2142, 0x5A06, 0x7247, 0x7227, 0x7247, 0x7A68, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7A27, 0x7A27, 0x7B0B, 0x8430, 0x6268, 0x7227, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 
        0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7227, 0x7227, 0x7A47, 0x7A27, 0x7227, 0x7227, 0x6A89, 0x636D, 0x5A28, 0x6A07, 0x7A47, 0x7A68, 0x7A27, 0x7227, 0x7A47, 0x7A47, 0x7A47, 0x7227, 0x7A47, 0x7A47, 0x7227, 0x7227, 0x7247, 
        0x7A47, 0x7A47, 0x7227, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7247, 0x5A05, 0x3984, 0x2943, 0x2143, 0x2983, 0x2983, 0x39A4, 0x6A27, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7206, 0x7206, 0x7A47, 0x7A27, 0x7206, 
        0x7A47, 0x7A27, 0x7A07, 0x7206, 0x7A27, 0x7227, 0x61A5, 0x69E6, 0x8247, 0x8268, 0x8247, 0x7A47, 0x8268, 0x8288, 0x7A68, 0x7A67, 0x8268, 0x7A47, 0x7227, 0x7207, 0x6A07, 0x59C6, 0x49A6, 0x8C0E, 0x9C90, 0x9C90, 0x9C90, 0x8C0E, 0x8C2E, 0x944F, 
        0x9470, 0xAD32, 0xBDB4, 0xAD52, 0xB573, 0xB593, 0xB5B4, 0xB573, 0xB593, 0xBDD4, 0xBDD4, 0xC615, 0xBDF5, 0xBDF5, 0xC615, 0x6B6B, 0x29A3, 0x2163, 0x2162, 0x2163, 0x2183, 0x2183, 0x2183, 0x2162, 0x2163, 0x1942, 0x1942, 0x31A3, 0x4A25, 0x5A46, 
        0x7267, 0x8268, 0x7A47, 0x7A48, 0x7247, 0x734C, 0x83EF, 0x7A68, 0x7A68, 0x7A68, 0x7A48, 0x7A47, 0x6AEA, 0x6B4D, 0x6A69, 0x83CD, 0x7C0E, 0x83ED, 0x83EE, 0x8BEF, 0x836C, 0x6A27, 0x61C6, 0x61E6, 0x6A07, 0x6A06, 0x69E6, 0x6A06, 0x6206, 0x61E6, 
        0x6A06, 0x6A06, 0x6A06, 0x6A07, 0x7227, 0x7227, 0x4984, 0x61E6, 0x6A47, 0x5205, 0x39A4, 0x2983, 0x2163, 0x2163, 0x2162, 0x2162, 0x1962, 0x2182, 0x21A3, 0x2183, 0x2183, 0x29A3, 0x29C4, 0x2163, 0x2143, 0x2183, 0x29C4, 0x2183, 0x1902, 0x1102, 
        0x10E2, 0x10E2, 0x10C2, 0x08A1, 0x10C2, 0x08A1, 0x0881, 0x1102, 0x1102, 0x1922, 0x10E1, 0x1922, 0x2163, 0x1963, 0x1922, 0x1922, 0x1102, 0x10E2, 0x10C2, 0x10C1, 0x1102, 0x1902, 0x1943, 0x1122, 0x1122, 0x1122, 0x1942, 0x31C4, 0x4A25, 0x41A4, 
        0x2102, 0x10E1, 0x10C2, 0x08A1, 0x0881, 0x10E2, 0x1102, 0x1102, 0x10E2, 0x08C1, 0x3A27, 0x638D, 0x1102, 0x1122, 0x1102, 0x1102, 0x1942, 0x1122, 0x10C1, 0x10C2, 0x0881, 0x08A1, 0x10C2, 0x10E2, 0x08A1, 0x2144, 0x73CE, 0x31E6, 0xB5D6, 0xCEBA, 
        0xB616, 0xBE58, 0xD6DA, 0x8490, 0x10E2, 0x10E2, 0x10E2, 0x10E2, 0x1102, 0x08A1, 0x2164, 0x1943, 0x2163, 0x10C1, 0x08A1, 0x08A1, 0x08A1, 0x0881, 0x0881, 0x08A1, 0x10C2, 0x10E2, 0x1102, 0x08E2, 0x10E2, 0x1922, 0x2183, 0x21A3, 0x1902, 0x10A1, 
        0x1102, 0x10C2, 0x10E2, 0x1102, 0x10E2, 0x10C2, 0x10E2, 0x1922, 0x1943, 0x1122, 0x1922, 0x2183, 0x2163, 0x1102, 0x1102, 0x1102, 0x1943, 0x1102, 0x1102, 0x1102, 0x1943, 0x29A3, 0x41E5, 0x3983, 0x2902, 0x2103, 0x10C2, 0x08C1, 0x08A1, 0x08A1, 
        0x08A1, 0x3A48, 0x42A9, 0x1102, 0x1922, 0x1922, 0x10C1, 0x10E2, 0x10E2, 0x10C2, 0x1102, 0x10E2, 0x1102, 0x1902, 0x1922, 0x1102, 0x1943, 0x1963, 0x31E6, 0x638D, 0x52EA, 0xA594, 0x9DD3, 0xACF2, 0xC3F2, 0x9C31, 0x1102, 0x08A1, 0x10E2,
  0xBE79, 0xBE79, 0xBE79, 0xBE59, 0xBE59, 0xBE59, 0xBE79, 0xBE79, 0xBE59, 0xBE79, 0xBE79, 0xBE79, 0xBE79, 0xBE9A, 0xA513, 0x6206, 0x6A27, 0x6A07, 0x61E6, 0x6A06, 0x6A27, 0x6A27, 0x6A27, 0x6A27, 0x6A06, 0x6A06, 0x6A27, 0x7247, 0x7247, 0x6A27, 0x6A27, 
        0x6A27, 0x6A27, 0x6A27, 0x6A27, 0x7227, 0x6A07, 0x69E6, 0x6A27, 0x7227, 0x7227, 0x7207, 0x69E6, 0x6A06, 0x7227, 0x7227, 0x7207, 0x6A07, 0x61C6, 0x69E6, 0x7227, 0x7227, 0x6A27, 0x6A06, 0x6A06, 0x7227, 0x7227, 0x7227, 0x7227, 0x69E6, 0x69E6, 
        0x7227, 0x7247, 0x7247, 0x59C5, 0x61E6, 0x6A07, 0x6A06, 0x6A07, 0x6A06, 0x61C6, 0x61E6, 0x69E6, 0x61E6, 0x69E6, 0x61E6, 0x61E6, 0x6A07, 0x7207, 0x6A07, 0x7227, 0x61E6, 0x5185, 0x6A07, 0x7227, 0x7227, 0x6A06, 0x69E6, 0x6A27, 0x7227, 0x7227, 
        0x7207, 0x6A06, 0x7227, 0x7227, 0x7227, 0x7227, 0x6A06, 0x6A06, 0x7227, 0x7227, 0x7227, 0x69E6, 0x6A06, 0x7227, 0x7227, 0x7227, 0x7227, 0x49A5, 0x18E2, 0x08A1, 0x10C1, 0x1922, 0x1102, 0x1102, 0x1122, 0x1101, 0x1102, 0x10E2, 0x1102, 0x10E1, 
        0x1102, 0x1922, 0x1122, 0x1122, 0x1102, 0x1122, 0x1942, 0x1942, 0x1942, 0x49A4, 0x7227, 0x7227, 0x7227, 0x7A47, 0x7227, 0x7227, 0x7247, 0x7A47, 0x7227, 0x7207, 0x7227, 0x7207, 0x7AEB, 0x8451, 0x6A68, 0x7207, 0x7227, 0x7247, 0x7227, 0x7227, 
        0x7A47, 0x7A47, 0x7A47, 0x7A47, 0x7A68, 0x7A67, 0x7A48, 0x7A27, 0x7A47, 0x7A47, 0x7A47, 0x7A27, 0x7227, 0x6269, 0x636D, 0x5A28, 0x69E6, 0x7247, 0x7A67, 0x7A47, 0x7206, 0x7A47, 0x7A47, 0x7A47, 0x7207, 0x7247, 0x7A47, 0x7A47, 0x7227, 0x7247, 
        0x7A47, 0x7A47, 0x7227, 0x7A47, 0x8268, 0x7A47, 0x7A47, 0x7A47, 0x7A67, 0x7A67, 0x7247, 0x41C4, 0x2162, 0x1942, 0x2142, 0x1962, 0x1943, 0x1942, 0x1922, 0x39A4, 0x7247, 0x7A47, 0x7227, 0x7A47, 0x7A47, 0x7207, 0x7206, 0x7A47, 0x7247, 0x7206, 
        0x7227, 0x7A47, 0x7A27, 0x7206, 0x7A27, 0x7247, 0x59A5, 0x69E6, 0x8247, 0x8268, 0x8247, 0x7A47, 0x8268, 0x8288, 0x8267, 0x7A48, 0x7A68, 0x7A48, 0x7227, 0x6A27, 0x6207, 0x59E6, 0x49A5, 0x8BCE, 0x9CB1, 0x9C90, 0x942F, 0x8BEE, 0x944F, 0x944F, 
        0x942F, 0xA4F1, 0xB573, 0xB552, 0xB552, 0xAD52, 0xB573, 0xAD52, 0xB593, 0xBDD4, 0xBDB4, 0xBDD4, 0xBDD4, 0xB5B4, 0x7BED, 0x1962, 0x2162, 0x1962, 0x2163, 0x2163, 0x1942, 0x1942, 0x2162, 0x2162, 0x2162, 0x2162, 0x1942, 0x1942, 0x2183, 0x29C3, 
        0x3A04, 0x6A67, 0x7A68, 0x7A48, 0x7A68, 0x734C, 0x83EF, 0x7A88, 0x7A68, 0x7A68, 0x7A48, 0x7227, 0x730B, 0x6B6D, 0x6288, 0x6A07, 0x6A07, 0x69E6, 0x61E6, 0x61E6, 0x6207, 0x6A27, 0x59E6, 0x61E6, 0x6207, 0x6206, 0x6206, 0x6206, 0x61E6, 0x6206, 
        0x61E6, 0x69E6, 0x6A06, 0x6A06, 0x6A27, 0x6A27, 0x4964, 0x59E6, 0x3184, 0x1922, 0x1942, 0x1942, 0x1922, 0x1122, 0x1942, 0x1942, 0x1922, 0x1122, 0x1942, 0x2183, 0x2183, 0x21A3, 0x2183, 0x2183, 0x2163, 0x1963, 0x2163, 0x2163, 0x1922, 0x1102, 
        0x10C2, 0x10A2, 0x10A1, 0x0881, 0x08A1, 0x0881, 0x08C1, 0x10E2, 0x1102, 0x1922, 0x10E2, 0x1122, 0x1943, 0x1942, 0x1922, 0x1102, 0x10E2, 0x08E2, 0x10E2, 0x10C1, 0x10E2, 0x1102, 0x1102, 0x1122, 0x10E1, 0x1122, 0x2162, 0x31C4, 0x4205, 0x4A26, 
        0x4A05, 0x20E2, 0x10A1, 0x08A1, 0x0881, 0x10E2, 0x10E2, 0x08C1, 0x08C1, 0x1122, 0x3A47, 0x63AD, 0x1922, 0x1943, 0x1962, 0x1102, 0x1102, 0x10E2, 0x08A1, 0x0881, 0x10A2, 0x10A2, 0x08A1, 0x08C1, 0x10A1, 0x2123, 0x6B8D, 0x5A88, 0xB5B6, 0xCEBA, 
        0xC679, 0xCEBA, 0xD6DB, 0x84B1, 0x10E2, 0x10E2, 0x1902, 0x1922, 0x10E2, 0x08A1, 0x2144, 0x2184, 0x1922, 0x1922, 0x10C2, 0x08C2, 0x08A2, 0x08A1, 0x08A1, 0x10E2, 0x1122, 0x1122, 0x1122, 0x1102, 0x1102, 0x1102, 0x1963, 0x21A3, 0x1922, 0x10E2, 
        0x1922, 0x10E2, 0x10C2, 0x10C1, 0x10C2, 0x08A1, 0x0881, 0x08A1, 0x1922, 0x1942, 0x1943, 0x21A3, 0x2163, 0x1902, 0x08C1, 0x08C1, 0x10E2, 0x10E2, 0x08C1, 0x10E2, 0x1902, 0x2983, 0x49E5, 0x49C5, 0x2923, 0x1902, 0x1902, 0x10E2, 0x10E2, 0x08C2, 
        0x08A1, 0x4268, 0x4288, 0x10E2, 0x1942, 0x2163, 0x1122, 0x10C1, 0x10C2, 0x08A1, 0x08C2, 0x10E2, 0x10C2, 0x10C2, 0x1102, 0x1102, 0x1942, 0x1923, 0x31C6, 0x638D, 0x52C9, 0xA5D4, 0x9DF3, 0xAD93, 0xBC53, 0x9C51, 0x1943, 0x08C2, 0x08C1,
  0xB638, 0xB658, 0xBE59, 0xBE59, 0xB659, 0xB638, 0xB639, 0xBE59, 0xB639, 0xBE59, 0xBE59, 0xB639, 0xB639, 0xBE79, 0xA4F3, 0x6A68, 0x6A68, 0x6A68, 0x6A47, 0x6A68, 0x7288, 0x7288, 0x7268, 0x7268, 0x6A68, 0x6A47, 0x6A68, 0x6A68, 0x6A68, 0x6A68, 0x6A47, 
        0x7268, 0x7268, 0x7268, 0x7268, 0x7268, 0x6A47, 0x6A27, 0x7247, 0x7248, 0x7248, 0x7247, 0x6A07, 0x6A06, 0x7227, 0x6A27, 0x6A27, 0x6A07, 0x59C6, 0x59C6, 0x6A27, 0x6A27, 0x6A27, 0x6A06, 0x69E6, 0x6A06, 0x6A26, 0x6A26, 0x6A06, 0x69E6, 0x59A5, 
        0x6A27, 0x9B8C, 0x6A67, 0x51C6, 0x51A5, 0x59C6, 0x61C6, 0x61E6, 0x61C6, 0x59A5, 0x5185, 0x59A5, 0x61E6, 0x6A06, 0x61E6, 0x61C6, 0x61E6, 0x6A06, 0x6A06, 0x6A07, 0x59C6, 0x4985, 0x51A6, 0x59C6, 0x7227, 0x7227, 0x61E6, 0x61E6, 0x6A06, 0x69E6, 
        0x6A06, 0x69E6, 0x6A06, 0x7227, 0x7227, 0x7227, 0x6A06, 0x6A06, 0x7207, 0x6A07, 0x6A06, 0x61C6, 0x61C6, 0x6A06, 0x7227, 0x7206, 0x69E6, 0x4164, 0x1902, 0x10E2, 0x08A1, 0x08C1, 0x10E2, 0x1102, 0x1102, 0x1122, 0x1102, 0x10E1, 0x1922, 0x1922, 
        0x10E2, 0x10E1, 0x1102, 0x1122, 0x1101, 0x1122, 0x1121, 0x1101, 0x1922, 0x49E5, 0x6A27, 0x7206, 0x7227, 0x7227, 0x7227, 0x7207, 0x7227, 0x7247, 0x7227, 0x7206, 0x7206, 0x7206, 0x7AEA, 0x8C71, 0x6A68, 0x7206, 0x7227, 0x7227, 0x7227, 0x7227, 
        0x7A47, 0x7A27, 0x7A27, 0x7227, 0x7227, 0x7A47, 0x7A47, 0x7227, 0x7227, 0x7A27, 0x7A27, 0x7227, 0x7226, 0x6288, 0x636D, 0x5228, 0x69E6, 0x7247, 0x7A47, 0x7227, 0x7227, 0x7A47, 0x7A68, 0x7A47, 0x6A06, 0x7A47, 0x7A48, 0x7227, 0x7227, 0x7A47, 
        0x7A47, 0x7A47, 0x7A47, 0x7A67, 0x8268, 0x8268, 0x7A47, 0x7A47, 0x7A67, 0x6A47, 0x41C4, 0x1942, 0x1942, 0x1963, 0x1962, 0x1962, 0x1963, 0x1963, 0x2183, 0x2183, 0x4A06, 0x7247, 0x7A67, 0x7A47, 0x7A47, 0x7227, 0x7207, 0x7A27, 0x7227, 0x7206, 
        0x7227, 0x7A68, 0x7A47, 0x7206, 0x7227, 0x7247, 0x59A5, 0x69C6, 0x8248, 0x8268, 0x8247, 0x7A47, 0x8267, 0x8268, 0x8247, 0x7A68, 0x7A68, 0x7A47, 0x7247, 0x7247, 0x6A27, 0x6207, 0x49A5, 0x838C, 0x944F, 0x942F, 0x83CD, 0x7B8C, 0x942F, 0x8BEE, 
        0x8BEE, 0xAD12, 0xB573, 0xB553, 0xAD52, 0xB573, 0xB593, 0xB593, 0xB593, 0xBDD4, 0xB593, 0xAD32, 0xCE36, 0x842D, 0x2162, 0x2162, 0x2183, 0x1942, 0x1102, 0x1922, 0x1102, 0x1122, 0x1942, 0x2162, 0x2182, 0x21A3, 0x1962, 0x1122, 0x1942, 0x21A3, 
        0x21A2, 0x3A04, 0x6A67, 0x7A67, 0x7A47, 0x732C, 0x83EF, 0x7A88, 0x7A68, 0x7A68, 0x7268, 0x7247, 0x730B, 0x6B8D, 0x6A68, 0x7247, 0x6A27, 0x6A27, 0x6A27, 0x6A27, 0x6A27, 0x6A27, 0x59E6, 0x61E6, 0x6207, 0x6206, 0x6206, 0x6206, 0x6206, 0x61E6, 
        0x61E6, 0x6206, 0x69E6, 0x6A06, 0x6A06, 0x6A07, 0x4984, 0x41A5, 0x1902, 0x1101, 0x1902, 0x1902, 0x10E1, 0x1102, 0x1942, 0x1942, 0x1942, 0x1101, 0x1101, 0x1942, 0x2163, 0x2183, 0x1942, 0x1942, 0x1942, 0x1942, 0x2163, 0x2163, 0x1942, 0x1102, 
        0x10C1, 0x0881, 0x10C2, 0x10C1, 0x10C1, 0x10E2, 0x1102, 0x10E1, 0x1102, 0x1102, 0x1922, 0x1943, 0x1942, 0x1922, 0x1102, 0x10E1, 0x1102, 0x1102, 0x10E2, 0x1122, 0x10C1, 0x10E2, 0x1102, 0x1122, 0x1962, 0x1962, 0x2183, 0x29A3, 0x31C4, 0x5246, 
        0x6247, 0x49C5, 0x2902, 0x10A1, 0x0881, 0x10C2, 0x1102, 0x10E1, 0x10E1, 0x10E1, 0x3A27, 0x6BAE, 0x1102, 0x1922, 0x1942, 0x1101, 0x10A1, 0x0881, 0x0881, 0x08A1, 0x10A2, 0x08A1, 0x10A1, 0x08A1, 0x08A1, 0x2144, 0x6B6D, 0x72A9, 0x832B, 0x838D, 
        0x630B, 0x4289, 0x42A9, 0x29E6, 0x0881, 0x08C1, 0x08C2, 0x1923, 0x1102, 0x1102, 0x10E2, 0x4247, 0x29A4, 0x1102, 0x10E2, 0x10E2, 0x10C2, 0x10C2, 0x10C2, 0x10C2, 0x10E2, 0x1102, 0x1922, 0x1102, 0x1102, 0x1943, 0x1963, 0x1962, 0x10E2, 0x1102, 
        0x1102, 0x1923, 0x1102, 0x10C2, 0x10E2, 0x10C2, 0x0881, 0x08A1, 0x10C1, 0x1943, 0x2163, 0x2142, 0x2163, 0x1942, 0x1102, 0x1102, 0x10E2, 0x1102, 0x10E1, 0x10E2, 0x1922, 0x31C4, 0x4A05, 0x3984, 0x2102, 0x10E2, 0x1102, 0x1902, 0x10E2, 0x10E2, 
        0x08C1, 0x4269, 0x4268, 0x08E1, 0x1922, 0x2163, 0x1922, 0x1102, 0x10E2, 0x08A1, 0x08A1, 0x0881, 0x08A1, 0x08C2, 0x08E1, 0x10E2, 0x1122, 0x1122, 0x29C5, 0x638C, 0x630A, 0xAE35, 0x9E14, 0xB656, 0xCE18, 0xA554, 0x1923, 0x08A1, 0x08C1,
  0xB618, 0xB638, 0xB639, 0xB639, 0xB659, 0xB638, 0xB659, 0xBE59, 0xB639, 0xBE59, 0xBE59, 0xB659, 0xB639, 0xBE79, 0xA534, 0x734B, 0x7B6B, 0x732B, 0x6AC9, 0x732B, 0x838C, 0x838C, 0x7B6B, 0x732B, 0x6AEA, 0x730A, 0x732B, 0x72EA, 0x7B4B, 0x730A, 0x5A47, 
        0x6288, 0x732B, 0x836C, 0x7B6B, 0x7B4B, 0x72E9, 0x72C9, 0x730A, 0x730A, 0x730A, 0x72EA, 0x730A, 0x730A, 0x730A, 0x838C, 0x838C, 0x7B2B, 0x7B4B, 0x7B2B, 0x834B, 0x832B, 0x7B2B, 0x7B2B, 0x7B2B, 0x7B0B, 0x834B, 0x7B2B, 0x832B, 0x834B, 0x7B0A, 
        0x6AC9, 0x6AC9, 0x838C, 0x9C70, 0x8BCD, 0x72EA, 0x730A, 0x72EA, 0x7B2B, 0x72EA, 0x7B0B, 0x834B, 0x7ACA, 0x72A9, 0x72C9, 0x6A89, 0x72EA, 0x832B, 0x7ACA, 0x6A68, 0x6A89, 0x5A48, 0x6289, 0x5207, 0x832B, 0x8B4B, 0x72C9, 0x6AC9, 0x7AEA, 0x830B, 
        0x7B0A, 0x7AEA, 0x7AEA, 0x832B, 0x832B, 0x830A, 0x72A8, 0x72C9, 0x830A, 0x830A, 0x7B0A, 0x6A88, 0x72A9, 0x830A, 0x830A, 0x82EA, 0x7ACA, 0x3984, 0x10E1, 0x1102, 0x10E2, 0x10C1, 0x10E2, 0x1102, 0x1102, 0x1102, 0x1102, 0x10C1, 0x10E2, 0x1122, 
        0x10E1, 0x1102, 0x1102, 0x1922, 0x1102, 0x1101, 0x1101, 0x1102, 0x1922, 0x4A46, 0x7288, 0x7268, 0x7AA9, 0x7A88, 0x7247, 0x7268, 0x7A88, 0x7A88, 0x7A88, 0x7247, 0x7247, 0x7227, 0x730B, 0x8451, 0x72A9, 0x7227, 0x7248, 0x7247, 0x7227, 0x7227, 
        0x7247, 0x7247, 0x7247, 0x7227, 0x7227, 0x7227, 0x7207, 0x69E6, 0x6A06, 0x7227, 0x7A47, 0x7206, 0x6A06, 0x5A48, 0x5B4D, 0x5227, 0x61E6, 0x7227, 0x7247, 0x7227, 0x69E6, 0x7227, 0x7247, 0x7227, 0x69E6, 0x7207, 0x7227, 0x6A07, 0x61E6, 0x6A07, 
        0x7227, 0x6A06, 0x6A06, 0x6A27, 0x7227, 0x7227, 0x6A06, 0x6A06, 0x7247, 0x49C4, 0x2142, 0x1942, 0x1942, 0x1963, 0x1962, 0x1942, 0x1962, 0x2182, 0x2183, 0x1962, 0x29A3, 0x5226, 0x7247, 0x7A67, 0x7A47, 0x7206, 0x69E6, 0x7207, 0x7207, 0x7206, 
        0x7227, 0x7A47, 0x61E6, 0x69E6, 0x7227, 0x6A06, 0x4964, 0x69C6, 0x8248, 0x8268, 0x8267, 0x7A47, 0x8267, 0x8268, 0x7A67, 0x7A47, 0x7A68, 0x7A67, 0x7247, 0x7247, 0x6A27, 0x59E6, 0x4985, 0x7B4B, 0x942F, 0x9450, 0x8C0E, 0x7BAD, 0x8C2F, 0x942F, 
        0x944F, 0xAD32, 0xBDB4, 0xB573, 0xB593, 0xBDD4, 0xBDD5, 0xBDB4, 0xB593, 0xB594, 0xB573, 0xAD12, 0xA552, 0x31E5, 0x1942, 0x2183, 0x21A4, 0x2184, 0x2184, 0x2163, 0x2184, 0x2183, 0x2183, 0x29A3, 0x2183, 0x21A3, 0x2183, 0x1942, 0x1942, 0x1962, 
        0x1982, 0x29A2, 0x4204, 0x6A67, 0x7248, 0x6B2C, 0x840F, 0x7288, 0x7268, 0x7267, 0x7267, 0x6A47, 0x6B0B, 0x7BCE, 0x6A48, 0x6A47, 0x6A27, 0x6A27, 0x6A27, 0x6A27, 0x6A27, 0x6227, 0x59C6, 0x61E6, 0x6207, 0x6206, 0x6206, 0x6206, 0x61E6, 0x61E6, 
        0x61E6, 0x61E6, 0x6A06, 0x6A06, 0x6A06, 0x6A27, 0x4185, 0x2943, 0x1102, 0x1102, 0x1902, 0x1922, 0x1922, 0x10C1, 0x1922, 0x1942, 0x1942, 0x1942, 0x1922, 0x1942, 0x1942, 0x2163, 0x1922, 0x1922, 0x1942, 0x1102, 0x1942, 0x1943, 0x1922, 0x1922, 
        0x10C1, 0x10C1, 0x10E2, 0x10C2, 0x08C1, 0x10E2, 0x1102, 0x1922, 0x1942, 0x1902, 0x10C1, 0x10E2, 0x1102, 0x1102, 0x10C1, 0x08A1, 0x08A1, 0x1102, 0x1102, 0x10E2, 0x10E2, 0x10C1, 0x1102, 0x1963, 0x1942, 0x2182, 0x2182, 0x21A3, 0x3A04, 0x6267, 
        0x6A68, 0x6A27, 0x51C5, 0x3984, 0x20E2, 0x10A1, 0x10C2, 0x1902, 0x1922, 0x10E1, 0x3A27, 0x73EF, 0x2184, 0x1942, 0x1101, 0x10E1, 0x0881, 0x0861, 0x0881, 0x0881, 0x0881, 0x10C1, 0x08C1, 0x10E2, 0x10C1, 0x31A5, 0x7C0F, 0x6AA9, 0x7227, 0x7247, 
        0x3144, 0x0881, 0x08C2, 0x08A1, 0x0881, 0x10A1, 0x08A1, 0x10C2, 0x1902, 0x1102, 0x10E1, 0x52C9, 0x3A47, 0x08A1, 0x0881, 0x08A1, 0x08C2, 0x08A1, 0x10C2, 0x08A1, 0x10C2, 0x08C1, 0x1102, 0x10E2, 0x10C1, 0x1122, 0x1922, 0x1922, 0x10E2, 0x10C1, 
        0x1902, 0x1902, 0x10E2, 0x1102, 0x10C2, 0x10C2, 0x0881, 0x10A1, 0x10A1, 0x2143, 0x31A4, 0x2963, 0x1902, 0x1102, 0x10E1, 0x1102, 0x1102, 0x1922, 0x1102, 0x1102, 0x2163, 0x41E5, 0x5205, 0x41A4, 0x2102, 0x10C2, 0x10C2, 0x10E2, 0x10E2, 0x10E2, 
        0x08C1, 0x3A68, 0x42A9, 0x1102, 0x1122, 0x1942, 0x1942, 0x1922, 0x10C1, 0x10C2, 0x10E2, 0x08A1, 0x08C2, 0x08C1, 0x10E2, 0x10E2, 0x10C1, 0x10E2, 0x29C5, 0x636C, 0x5288, 0x8CD0, 0x8CF0, 0x9D12, 0xA533, 0x8450, 0x1923, 0x0881, 0x08A1,
  0xB618, 0xB618, 0xB618, 0xB638, 0xB638, 0xB638, 0xB659, 0xB639, 0xB639, 0xBE59, 0xB658, 0xB639, 0xB639, 0xBE7A, 0x9CD3, 0x51E6, 0x59E6, 0x51C5, 0x4985, 0x49A5, 0x49A5, 0x51C6, 0x51C6, 0x59E6, 0x59E6, 0x51C6, 0x59E6, 0x59E6, 0x59E6, 0x59E6, 0x51C5, 
        0x51A5, 0x51C5, 0x59E6, 0x59E6, 0x59E6, 0x51C6, 0x51C5, 0x51C5, 0x51C6, 0x51E6, 0x51E6, 0x51E6, 0x59E6, 0x59E6, 0x5A07, 0x5A27, 0x5A27, 0x5A27, 0x5A06, 0x5A06, 0x51E6, 0x51E6, 0x5206, 0x51E6, 0x51E6, 0x5206, 0x5206, 0x5A07, 0x5206, 0x5207, 
        0x3144, 0x2103, 0x736C, 0x6B2B, 0x8C2E, 0x5A47, 0x5227, 0x5227, 0x5227, 0x5227, 0x5227, 0x5A68, 0x5A48, 0x5206, 0x49C6, 0x49C6, 0x5207, 0x5A68, 0x6227, 0x69E7, 0x51A6, 0x2924, 0x2924, 0x2103, 0x4A07, 0x5227, 0x5227, 0x5227, 0x5A48, 0x6268, 
        0x6288, 0x5A47, 0x5A68, 0x62A8, 0x6288, 0x5A68, 0x4A06, 0x5227, 0x62A9, 0x6AA9, 0x6AA9, 0x5247, 0x5A88, 0x6AC9, 0x6AC9, 0x6AA9, 0x5A88, 0x2943, 0x10C1, 0x1101, 0x10C1, 0x08C1, 0x10E1, 0x10E2, 0x1102, 0x1102, 0x1122, 0x1102, 0x10E1, 0x10E1, 
        0x10E1, 0x10C1, 0x10E1, 0x10E2, 0x1102, 0x1101, 0x10E1, 0x1101, 0x2162, 0x6309, 0x838C, 0x72E9, 0x7B2A, 0x7B2B, 0x6A89, 0x72EA, 0x836C, 0x7B2B, 0x6AC9, 0x730A, 0x730A, 0x730A, 0x734C, 0x8450, 0x6B0B, 0x6AA9, 0x6AA9, 0x6AA9, 0x72EA, 0x6AC9, 
        0x72EA, 0x730A, 0x7B2A, 0x7B4B, 0x7B2B, 0x7AEA, 0x6AA9, 0x72C9, 0x7B0A, 0x832B, 0x82EA, 0x8B4B, 0x7B0B, 0x6B0B, 0x634D, 0x5AA9, 0x6268, 0x6A88, 0x72C9, 0x7B0A, 0x730A, 0x7B0A, 0x7B0A, 0x7B0A, 0x72C9, 0x72A9, 0x7B0A, 0x72C9, 0x6A88, 0x6AA9, 
        0x72C9, 0x7B2B, 0x6AC9, 0x72EA, 0x834B, 0x7AEA, 0x7B0A, 0x7B2A, 0x72E9, 0x2983, 0x1102, 0x1922, 0x1122, 0x1962, 0x1962, 0x1942, 0x1962, 0x1982, 0x2182, 0x1962, 0x21A3, 0x21A3, 0x39E4, 0x5245, 0x7AE9, 0x7AEA, 0x72C9, 0x7AC9, 0x82EA, 0x72C9, 
        0x72A9, 0x82A9, 0x6986, 0x6A27, 0x7AEA, 0x9C71, 0x9C51, 0x7AC9, 0x8B2A, 0x934B, 0x932B, 0x930A, 0x8AC9, 0x8AC9, 0x82C9, 0x82E9, 0x8AC9, 0x8AC9, 0x82C9, 0x6227, 0x7288, 0x834C, 0x9C30, 0x838D, 0x942F, 0x942F, 0x9450, 0x9C90, 0x9C90, 0x9470, 
        0x9C90, 0xAD32, 0xC5D5, 0xBDD4, 0xC5F5, 0xBDF5, 0xC615, 0xBDF5, 0xBDD5, 0xBDB4, 0xBDB4, 0xB552, 0x842D, 0x7C2F, 0x9D33, 0xA553, 0xA574, 0xAD95, 0xADB5, 0xAD95, 0xADB6, 0xA554, 0x9D34, 0x9D34, 0x9D34, 0x9513, 0x9513, 0x9D54, 0x7C0E, 0x1942, 
        0x1962, 0x2182, 0x29C2, 0x5A46, 0x7268, 0x6B2C, 0x840F, 0x72A9, 0x7A88, 0x7A88, 0x7A68, 0x7268, 0x730C, 0x7BCE, 0x6A68, 0x6A47, 0x7247, 0x6A27, 0x6A27, 0x6A07, 0x6207, 0x6207, 0x51C6, 0x59E6, 0x6206, 0x61E6, 0x61E6, 0x61E6, 0x61E6, 0x61E6, 
        0x61E6, 0x61E6, 0x61E6, 0x6A06, 0x6A06, 0x6206, 0x2923, 0x18E2, 0x1922, 0x1902, 0x1902, 0x1902, 0x1922, 0x10E1, 0x10E1, 0x1102, 0x1122, 0x1102, 0x1102, 0x1942, 0x1962, 0x1942, 0x2162, 0x1922, 0x1922, 0x10E1, 0x10E2, 0x1102, 0x1922, 0x1102, 
        0x10C1, 0x08C1, 0x08A1, 0x10C1, 0x10A1, 0x10E1, 0x1102, 0x1922, 0x1902, 0x10C2, 0x08A1, 0x08A1, 0x10C1, 0x10C1, 0x10C1, 0x10E2, 0x08A1, 0x08A1, 0x10C2, 0x10C2, 0x10E2, 0x1102, 0x10E2, 0x1122, 0x1922, 0x1942, 0x1922, 0x2163, 0x4225, 0x6A68, 
        0x6A67, 0x6A47, 0x6A47, 0x6247, 0x9C70, 0x840F, 0x8C50, 0x8C70, 0x8C90, 0x9490, 0x630B, 0x5288, 0x39C5, 0x39C5, 0x3184, 0x3144, 0x2924, 0x2903, 0x2924, 0x2924, 0x2923, 0x2944, 0x2944, 0x2923, 0x2923, 0x41C6, 0x6B2C, 0x5A68, 0x6227, 0x51E6, 
        0x3964, 0x3164, 0x3185, 0x1923, 0x10C2, 0x10C1, 0x10C1, 0x10C2, 0x10E2, 0x1102, 0x1102, 0x4AAA, 0x4288, 0x0881, 0x08A1, 0x08A1, 0x08A1, 0x08C2, 0x10E2, 0x08C1, 0x10E2, 0x1102, 0x10E2, 0x08C1, 0x08C1, 0x1102, 0x10E2, 0x10E2, 0x10A1, 0x10A1, 
        0x10A2, 0x0881, 0x0881, 0x1102, 0x10E2, 0x10C2, 0x08A1, 0x10A1, 0x10C1, 0x2163, 0x41A4, 0x3984, 0x2123, 0x10E2, 0x10C1, 0x10E1, 0x10E2, 0x10E2, 0x1102, 0x1902, 0x3183, 0x5206, 0x59E6, 0x49A5, 0x2102, 0x10A1, 0x08A1, 0x08C2, 0x08C2, 0x10C2, 
        0x10C2, 0x3A48, 0x42A9, 0x1122, 0x1122, 0x1942, 0x1942, 0x1102, 0x1922, 0x10E2, 0x10C1, 0x10C2, 0x10C2, 0x10C2, 0x08A1, 0x10E1, 0x1102, 0x10E1, 0x29A5, 0x6BAD, 0x5247, 0x6227, 0x6247, 0x5207, 0x2944, 0x10C2, 0x08A1, 0x08A1, 0x10C2,
  0xADF8, 0xAE18, 0xAE18, 0xB638, 0xB638, 0xB638, 0xB639, 0xB638, 0xB638, 0xB638, 0xB638, 0xB638, 0xB639, 0xBE79, 0xA4F3, 0x6A68, 0x7268, 0x7268, 0x6A07, 0x6A07, 0x7247, 0x7A48, 0x7A68, 0x7A48, 0x7A48, 0x7A48, 0x7A48, 0x7247, 0x7A47, 0x7A48, 0x7247, 
        0x7A48, 0x7A48, 0x7A48, 0x7248, 0x7248, 0x7A68, 0x7247, 0x6A47, 0x6A48, 0x7268, 0x7A68, 0x7A48, 0x7247, 0x7227, 0x7247, 0x7247, 0x6A47, 0x6A47, 0x7247, 0x7288, 0x8B6D, 0x8B8D, 0x8B8D, 0x838D, 0x836D, 0x836D, 0x836D, 0x834C, 0x7B0B, 0x7AEB, 
        0x4A07, 0x29A6, 0x632C, 0x3A07, 0x83AD, 0x6A68, 0x7268, 0x6A48, 0x6A47, 0x6207, 0x59E6, 0x6A27, 0x6A27, 0x6A07, 0x61E6, 0x61E6, 0x6207, 0x6A07, 0x61A6, 0x58E4, 0x48E4, 0x2903, 0x2924, 0x18C2, 0x3985, 0x41A6, 0x59E7, 0x6A07, 0x6A27, 0x6A27, 
        0x6A27, 0x61E6, 0x61E6, 0x61E6, 0x6206, 0x6206, 0x59E6, 0x61E6, 0x6206, 0x6206, 0x6227, 0x59E6, 0x6206, 0x6206, 0x6206, 0x6207, 0x5A06, 0x2102, 0x10C1, 0x10E1, 0x08C1, 0x08A1, 0x0881, 0x10C1, 0x1102, 0x1102, 0x1101, 0x10E1, 0x10E1, 0x10E1, 
        0x10E1, 0x10E1, 0x08C1, 0x10C1, 0x1102, 0x10E1, 0x1101, 0x1922, 0x1922, 0x3984, 0x6227, 0x6A27, 0x6A27, 0x6A27, 0x6A27, 0x7247, 0x6A47, 0x7267, 0x7267, 0x6227, 0x5A07, 0x5206, 0x62EA, 0x8430, 0x5A48, 0x5206, 0x5A27, 0x6227, 0x6227, 0x5A06, 
        0x5A27, 0x6247, 0x6227, 0x5A06, 0x6227, 0x6227, 0x6207, 0x6227, 0x5A06, 0x6227, 0x6A47, 0x6A68, 0x6227, 0x5ACA, 0x6B8D, 0x5ACA, 0x51E6, 0x6227, 0x6247, 0x5A27, 0x5A27, 0x6247, 0x6267, 0x5A47, 0x5A27, 0x5A27, 0x5A47, 0x5A27, 0x49E6, 0x4A06, 
        0x5A47, 0x6AA9, 0x6A68, 0x7288, 0x7AC9, 0x7288, 0x7288, 0x7288, 0x5227, 0x1922, 0x1922, 0x1922, 0x1942, 0x1942, 0x1962, 0x1962, 0x1982, 0x1962, 0x1962, 0x1962, 0x1942, 0x1922, 0x1962, 0x2182, 0x4246, 0x5AA8, 0x5A68, 0x6AA9, 0x6AC9, 0x6288, 
        0x5247, 0x71E7, 0xB129, 0x8208, 0x738D, 0xA598, 0xB619, 0x9430, 0x6AA9, 0x72EA, 0x72EA, 0x7B0A, 0x6AA9, 0x72A9, 0x72C9, 0x72EA, 0x72C9, 0x7AEA, 0x830B, 0x9249, 0x8B2C, 0xBDB8, 0xCE5B, 0x7B8D, 0x4A06, 0x5A68, 0x5247, 0x5268, 0x5A48, 0x5248, 
        0x5A68, 0x6AEA, 0x7B6B, 0x7B6B, 0x7B6C, 0x838C, 0x7B6C, 0x7B8C, 0x838C, 0x83AC, 0x83AC, 0x7B8C, 0x4AA8, 0xBE17, 0xCE9A, 0xC699, 0xC69A, 0xCE9A, 0xC69A, 0xC699, 0xC69A, 0xBE39, 0xBE59, 0xC659, 0xBE38, 0xBE39, 0xC65A, 0xCE9B, 0xA574, 0x1962, 
        0x1962, 0x2182, 0x2182, 0x5266, 0x6AA9, 0x6B4C, 0x7C0F, 0x62A9, 0x6AA9, 0x72EA, 0x730A, 0x6AC9, 0x6B4C, 0x7BCE, 0x6AA9, 0x72C9, 0x72E9, 0x72C9, 0x6AA9, 0x6AA9, 0x6AA9, 0x6AA9, 0x5227, 0x5A47, 0x6288, 0x5A68, 0x6268, 0x5A47, 0x5A27, 0x5A07, 
        0x6248, 0x6248, 0x6247, 0x5A47, 0x6268, 0x4A26, 0x1902, 0x10E2, 0x10E1, 0x1102, 0x10E2, 0x10E1, 0x1102, 0x1102, 0x10E2, 0x10E2, 0x10E1, 0x10E1, 0x10E1, 0x1902, 0x1922, 0x1942, 0x1962, 0x1102, 0x1922, 0x1102, 0x1102, 0x1102, 0x1902, 0x1102, 
        0x10E1, 0x08C1, 0x10C1, 0x1102, 0x10E1, 0x10C1, 0x1902, 0x10C1, 0x08A1, 0x10A2, 0x10C2, 0x10C2, 0x10C2, 0x08A1, 0x10A1, 0x10C2, 0x10C2, 0x10C2, 0x10C1, 0x10E2, 0x10C2, 0x10C2, 0x10E2, 0x1922, 0x1102, 0x1922, 0x2122, 0x2983, 0x4A05, 0x6A88, 
        0x6A88, 0x6A88, 0x6A88, 0x6288, 0xBD94, 0x7B4C, 0xB513, 0xB574, 0xAD54, 0xC5F6, 0x83AD, 0x4164, 0x51E6, 0x5A07, 0x49C6, 0x4985, 0x51E6, 0x51E5, 0x49E6, 0x41A6, 0x49A6, 0x49A6, 0x49E6, 0x41A5, 0x4186, 0x4185, 0x41A5, 0x5227, 0x49C6, 0x51E7, 
        0x93CE, 0x72EA, 0x49E6, 0x2123, 0x08C2, 0x10C1, 0x10E2, 0x10E2, 0x1102, 0x10E2, 0x1944, 0x636F, 0x634C, 0x10C2, 0x0881, 0x08A1, 0x08A1, 0x08A1, 0x08C1, 0x10E2, 0x08C1, 0x10E2, 0x10C1, 0x1102, 0x10E2, 0x1102, 0x10E2, 0x10C2, 0x10C2, 0x10A1, 
        0x10A1, 0x10C2, 0x10E2, 0x10C2, 0x10E2, 0x1102, 0x10E2, 0x18E2, 0x1902, 0x2942, 0x49C5, 0x51C5, 0x3964, 0x2923, 0x10A1, 0x10C1, 0x10C1, 0x10C1, 0x18E2, 0x2943, 0x51C5, 0x6206, 0x6206, 0x49A5, 0x2102, 0x0881, 0x0881, 0x08A2, 0x10A2, 0x10C2, 
        0x08A1, 0x3A48, 0x4288, 0x08C1, 0x2143, 0x2142, 0x1902, 0x1922, 0x3164, 0x18E2, 0x08A1, 0x08A1, 0x10C2, 0x08C1, 0x08C2, 0x10E2, 0x1102, 0x10E1, 0x2984, 0x73AD, 0x6268, 0x5A06, 0x49A5, 0x3164, 0x10C2, 0x0881, 0x08A1, 0x08A1, 0x08A1,
  0xADF7, 0xAE18, 0xB618, 0xB618, 0xB638, 0xB638, 0xB638, 0xB638, 0xB638, 0xB638, 0xB638, 0xB638, 0xBE59, 0xBE9A, 0xA4F3, 0x6A47, 0x7268, 0x7A68, 0x6A27, 0x7247, 0x7A48, 0x7A68, 0x7A68, 0x7248, 0x7A48, 0x7A48, 0x7248, 0x7A48, 0x7A68, 0x7A48, 0x7248, 
        0x7A48, 0x7247, 0x7268, 0x7248, 0x7247, 0x7247, 0x6A27, 0x51C5, 0x3923, 0x6A27, 0x7247, 0x7A68, 0x7A48, 0x7247, 0x7227, 0x6A27, 0x6A47, 0x6A27, 0x6A27, 0x8BAD, 0xBE17, 0xAD95, 0xBDD6, 0xBE37, 0xC659, 0xD6DB, 0xDEFC, 0xD6DB, 0xD6DB, 0xCEBB, 
        0xCE9A, 0xBE59, 0xBE38, 0xADB7, 0xBE18, 0xA4B2, 0x6A68, 0x6A47, 0x7248, 0x6A48, 0x6A27, 0x6A27, 0x7248, 0x6A47, 0x6A27, 0x6A07, 0x6A47, 0x69E6, 0x4924, 0x3842, 0x4124, 0x3165, 0x20C3, 0x18E3, 0x39A5, 0x2924, 0x51A5, 0x6A28, 0x7247, 0x7248, 
        0x7268, 0x7247, 0x6A47, 0x6A47, 0x7247, 0x7247, 0x7247, 0x7247, 0x7268, 0x7248, 0x7268, 0x7248, 0x6A47, 0x7247, 0x7247, 0x6A47, 0x6A47, 0x3984, 0x18E1, 0x10C1, 0x10A1, 0x0881, 0x10A1, 0x10E2, 0x10C1, 0x10E2, 0x10E2, 0x10E2, 0x10E1, 0x10A1, 
        0x10A1, 0x10E2, 0x1102, 0x10E1, 0x10E1, 0x10E1, 0x10E1, 0x10E1, 0x1901, 0x5A26, 0x7A88, 0x7A68, 0x7A68, 0x7A68, 0x8288, 0x8288, 0x7A68, 0x8288, 0x8288, 0x7A68, 0x6A47, 0x6AA9, 0x73AD, 0x8430, 0x7B4C, 0x6A47, 0x7248, 0x7268, 0x7247, 0x7247, 
        0x7248, 0x7268, 0x7248, 0x7227, 0x7227, 0x7247, 0x7227, 0x7227, 0x6A07, 0x7248, 0x7A68, 0x7268, 0x6A27, 0x5A89, 0x636D, 0x5ACA, 0x6206, 0x7268, 0x7A68, 0x7268, 0x6A47, 0x6A28, 0x6A68, 0x6A47, 0x6A27, 0x7247, 0x7248, 0x6A48, 0x6227, 0x6248, 
        0x6A48, 0x7A68, 0x7A68, 0x8268, 0x8268, 0x8268, 0x8267, 0x8288, 0x51E5, 0x10C1, 0x1102, 0x1922, 0x1942, 0x1942, 0x1962, 0x1982, 0x2182, 0x21A2, 0x1101, 0x10E1, 0x1102, 0x10C1, 0x1101, 0x1942, 0x2182, 0x39C4, 0x6247, 0x6A68, 0x6A68, 0x7268, 
        0x59E6, 0x38A3, 0x90E7, 0x81C7, 0x7B2C, 0xBE5A, 0xA536, 0x6A69, 0x7A48, 0x7247, 0x7247, 0x7247, 0x7247, 0x7247, 0x6A27, 0x6A27, 0x7248, 0x7268, 0x69A6, 0xB1CA, 0x828A, 0xB577, 0xB5B9, 0x736D, 0x4164, 0x49A6, 0x49A5, 0x49A5, 0x51A6, 0x51C6, 
        0x59A6, 0x6A27, 0x82C9, 0x82C9, 0x82C9, 0x82EA, 0x82CA, 0x82C9, 0x82EA, 0x7AEA, 0x7AEA, 0x7AE9, 0x4A47, 0xB617, 0xC69A, 0xC679, 0xC699, 0xC69A, 0xC69A, 0xC69A, 0xC67A, 0xCE9B, 0xC67A, 0xC5B0, 0xBD4A, 0xC5F3, 0xCEBB, 0xCEDC, 0x9D54, 0x1942, 
        0x1942, 0x1962, 0x39E4, 0x5A06, 0x5A07, 0x632B, 0x7C10, 0x6AEA, 0x6206, 0x5A27, 0x5A27, 0x59E6, 0x62CA, 0x73CE, 0x5206, 0x5207, 0x5206, 0x5206, 0x51E6, 0x51E6, 0x51E6, 0x51C6, 0x4185, 0x41A5, 0x49C5, 0x49A5, 0x49A6, 0x4985, 0x4985, 0x4185, 
        0x49A5, 0x49A5, 0x41A5, 0x49A5, 0x49A5, 0x3985, 0x1902, 0x10C2, 0x08A1, 0x10E2, 0x1102, 0x10E1, 0x08C1, 0x08C1, 0x10E2, 0x1902, 0x10E2, 0x10C1, 0x10A1, 0x10E2, 0x10E1, 0x1922, 0x1942, 0x08A1, 0x10E2, 0x1902, 0x10E1, 0x10E2, 0x1102, 0x10C1, 
        0x10E2, 0x10E1, 0x10E1, 0x10E1, 0x10E2, 0x10E2, 0x1943, 0x10E2, 0x0881, 0x0881, 0x10C2, 0x10C2, 0x08A1, 0x0881, 0x10C1, 0x18E2, 0x18C2, 0x1081, 0x1081, 0x10A1, 0x10A1, 0x1902, 0x1902, 0x10C1, 0x10E1, 0x1902, 0x2963, 0x4206, 0x4A26, 0x5247, 
        0x5A47, 0x6289, 0x6288, 0x6B0A, 0xBD94, 0x7B0B, 0xACB1, 0xA512, 0xA4F2, 0xBDD5, 0x7B8D, 0x4185, 0x5207, 0x5206, 0x51E6, 0x49A5, 0x5A46, 0x6AE6, 0x6266, 0x4185, 0x49C5, 0x49E5, 0x5A25, 0x5A45, 0x6266, 0x5205, 0x49C6, 0x5227, 0x49C5, 0x7B0B, 
        0xCD54, 0x9BEE, 0x41A5, 0x2123, 0x08C1, 0x1923, 0x10C2, 0x1902, 0x10E2, 0x10E2, 0x31C6, 0x6B8E, 0x632B, 0x1922, 0x08C1, 0x10E2, 0x1102, 0x10C2, 0x10C1, 0x10C2, 0x0881, 0x08C1, 0x10E2, 0x10E2, 0x10E2, 0x10E2, 0x10E2, 0x10E2, 0x10C2, 0x10E2, 
        0x10E2, 0x10E2, 0x10E2, 0x10C2, 0x08A1, 0x10E2, 0x10E2, 0x2122, 0x39C5, 0x49E5, 0x5A06, 0x5A06, 0x49C6, 0x3984, 0x18E2, 0x18E2, 0x18E2, 0x39A5, 0x51E6, 0x59E6, 0x6207, 0x6A27, 0x6227, 0x51E6, 0x2963, 0x18C2, 0x10A1, 0x10C2, 0x10A2, 0x10E2, 
        0x0060, 0x3A28, 0x4288, 0x2102, 0x51E6, 0x49E6, 0x10C1, 0x2923, 0x41C5, 0x18C2, 0x10A1, 0x08A1, 0x08C1, 0x10E2, 0x10C1, 0x10E2, 0x1902, 0x2943, 0x41E6, 0x7BAE, 0x6A48, 0x6227, 0x49A4, 0x3143, 0x1081, 0x0861, 0x10A1, 0x2923, 0x3144,
  0xADF8, 0xAE18, 0xAE18, 0xB618, 0xB638, 0xB638, 0xB638, 0xB638, 0xB618, 0xB638, 0xB638, 0xB618, 0xB618, 0xBE59, 0xA4F3, 0x6A48, 0x7268, 0x7A68, 0x7A68, 0x7A68, 0x7248, 0x7A68, 0x7A68, 0x7A68, 0x7A68, 0x7A68, 0x7A48, 0x7227, 0x7227, 0x7A47, 0x7227, 
        0x7247, 0x7227, 0x7247, 0x7247, 0x61C5, 0x6A47, 0x6A48, 0x5A27, 0x49E6, 0x6A27, 0x7248, 0x7A67, 0x7A68, 0x7248, 0x6A27, 0x7247, 0x7247, 0x7248, 0x6A48, 0x9470, 0xAD95, 0xA554, 0xA574, 0xADB5, 0xB5F7, 0xC6BA, 0xCEFC, 0xCEDB, 0xCEDB, 0xCEDB, 
        0xC6BB, 0xCEDB, 0xCEDB, 0xD6FC, 0xD71C, 0xDF5D, 0xC5F7, 0x832B, 0x6A07, 0x6A27, 0x6A27, 0x6A27, 0x6A47, 0x6A47, 0x6A27, 0x6A27, 0x6A27, 0x6A07, 0x50E4, 0x3842, 0x4104, 0x3185, 0x2145, 0x2944, 0x4A68, 0x4A27, 0x49A5, 0x61E6, 0x6A07, 0x6A27, 
        0x6A07, 0x6206, 0x6227, 0x6A27, 0x6A27, 0x7247, 0x7227, 0x7227, 0x7247, 0x7268, 0x7268, 0x6A47, 0x6A47, 0x6A47, 0x6A47, 0x6A27, 0x6A47, 0x6227, 0x2902, 0x0860, 0x1081, 0x08A1, 0x08A1, 0x10A1, 0x10A2, 0x0881, 0x0881, 0x0881, 0x10C1, 0x10E2, 
        0x10C1, 0x10E1, 0x10E1, 0x1102, 0x10E1, 0x1101, 0x1101, 0x10E1, 0x3984, 0x7268, 0x7A68, 0x7248, 0x7A68, 0x7A68, 0x8268, 0x7A68, 0x7A68, 0x7A68, 0x7A68, 0x7248, 0x6A47, 0x6288, 0x632B, 0x6B6D, 0x6AEA, 0x6A27, 0x7247, 0x7247, 0x6A27, 0x6A07, 
        0x6A27, 0x7268, 0x7288, 0x6A68, 0x7268, 0x6A47, 0x6A06, 0x6A06, 0x6A27, 0x7247, 0x7A68, 0x7A48, 0x6A48, 0x6B4C, 0x7C30, 0x738E, 0x6A68, 0x8289, 0x8288, 0x8288, 0x7268, 0x6A27, 0x7248, 0x7247, 0x6A27, 0x7248, 0x8268, 0x7A68, 0x6A47, 0x6248, 
        0x72A9, 0x834C, 0x8BAE, 0x93AE, 0xABEE, 0x8BCE, 0x8B6D, 0x82A9, 0x49C4, 0x10C1, 0x08C1, 0x1102, 0x1101, 0x1102, 0x1122, 0x1962, 0x1962, 0x1102, 0x10E1, 0x1102, 0x1102, 0x10E1, 0x1122, 0x1962, 0x2182, 0x2983, 0x6A67, 0x7288, 0x7268, 0x7268, 
        0x6227, 0x4144, 0x30C3, 0x5185, 0x838D, 0xBE5B, 0xBDF9, 0x6228, 0x7A68, 0x7A68, 0x7A68, 0x7A68, 0x7268, 0x7A68, 0x7A68, 0x7A68, 0x7A68, 0x7A88, 0x6186, 0x99C9, 0x7269, 0x4A29, 0x422A, 0x39A7, 0x49C6, 0x49E6, 0x51E6, 0x51C6, 0x59C6, 0x59C6, 
        0x61C6, 0x7227, 0x92CA, 0x92EA, 0x92EA, 0x92EA, 0x92EA, 0x92EA, 0x92EA, 0x92EA, 0x8AEA, 0x8B6C, 0x83CE, 0xC679, 0xD6DB, 0xCEBA, 0xCEDB, 0xD6FB, 0xC6BA, 0xC699, 0xC67A, 0xC67A, 0xBE17, 0xC569, 0xD585, 0xCDF1, 0xC67A, 0xCEDC, 0x9D54, 0x1142, 
        0x1962, 0x1942, 0x4A26, 0x7268, 0x6A68, 0x632C, 0x740F, 0x732C, 0x7248, 0x7268, 0x6A68, 0x6A48, 0x7BAD, 0x8C91, 0x6AA9, 0x6227, 0x6247, 0x6247, 0x6227, 0x6207, 0x6207, 0x59E7, 0x49A5, 0x49C6, 0x59E6, 0x59E6, 0x59E6, 0x59C6, 0x51C6, 0x51C6, 
        0x51C6, 0x51C6, 0x51E6, 0x59E6, 0x5A06, 0x41A5, 0x1902, 0x10E2, 0x10E1, 0x10E1, 0x10E1, 0x10E1, 0x10E1, 0x08A1, 0x0881, 0x10A1, 0x08A1, 0x10C1, 0x10E1, 0x10C1, 0x10C1, 0x10C1, 0x10E1, 0x2984, 0x18E2, 0x10E2, 0x1902, 0x1102, 0x1102, 0x10E2, 
        0x1102, 0x1102, 0x10E1, 0x1102, 0x10E2, 0x1902, 0x2143, 0x31A4, 0x2123, 0x18C2, 0x1902, 0x10C2, 0x08A1, 0x10C1, 0x10E2, 0x2964, 0x3184, 0x3984, 0x41A5, 0x3984, 0x2923, 0x3184, 0x39C5, 0x2102, 0x2963, 0x2943, 0x31A4, 0x49E6, 0x5206, 0x51E6, 
        0x51E6, 0x51E6, 0x49C5, 0x5247, 0xBDB5, 0x8B8D, 0xACD2, 0xAD33, 0xAD33, 0xC5F6, 0x7B8C, 0x4185, 0x51E6, 0x51E6, 0x5207, 0x51E6, 0x5A46, 0x7B46, 0x7B06, 0x7306, 0x6AC6, 0x6AE5, 0x7B06, 0x7B46, 0xBCE7, 0xAC88, 0x49C5, 0x49C6, 0x51E6, 0x9BEE, 
        0xCD74, 0xB491, 0x51E6, 0x2123, 0x08A1, 0x2143, 0x10C2, 0x10E2, 0x10E2, 0x10E2, 0x1923, 0x2184, 0x6B6B, 0x4A87, 0x1102, 0x10E2, 0x1922, 0x1102, 0x1102, 0x1102, 0x08A2, 0x10E2, 0x10E2, 0x08C1, 0x10E2, 0x10C1, 0x10C2, 0x10E2, 0x1902, 0x2143, 
        0x1902, 0x2102, 0x2943, 0x18E2, 0x20E2, 0x2103, 0x3143, 0x39A5, 0x5226, 0x5227, 0x5206, 0x49E6, 0x41A5, 0x4A06, 0x39A4, 0x41E6, 0x3985, 0x4A06, 0x5A27, 0x5206, 0x5A47, 0x6268, 0x6247, 0x5227, 0x41C5, 0x3985, 0x3164, 0x39A5, 0x2123, 0x2143, 
        0x1902, 0x4A69, 0x5AEA, 0x5206, 0x5A26, 0x5206, 0x18C2, 0x3164, 0x5247, 0x18E2, 0x10C2, 0x10E2, 0x10C1, 0x10C1, 0x18E2, 0x39C5, 0x41E6, 0x5227, 0x62A9, 0x73CE, 0x62A8, 0x6AA8, 0x6288, 0x49E6, 0x39A5, 0x4206, 0x4206, 0x5A88, 0x6288,
  0xADF7, 0xB618, 0xB618, 0xAE18, 0xB618, 0xB618, 0xB617, 0xB618, 0xB5F7, 0xB5F7, 0xB5F7, 0xADF7, 0xADD7, 0xB5F7, 0x9C91, 0x6227, 0x6A27, 0x6A47, 0x7247, 0x7227, 0x7247, 0x7248, 0x7247, 0x7268, 0x7A88, 0x7268, 0x7289, 0x7289, 0x72CA, 0x830B, 0x834B, 
        0x830B, 0x7AEA, 0x72A9, 0x7288, 0x8309, 0x7AC9, 0x49A5, 0x2104, 0x2124, 0x51C6, 0x7268, 0x7267, 0x7248, 0x7248, 0x7248, 0x7248, 0x6A47, 0x6A47, 0x6288, 0x9CF2, 0x9D13, 0x9D33, 0xA554, 0x9D33, 0xA595, 0xC699, 0xCEDB, 0xC6BB, 0xC6BB, 0xC6BB, 
        0xC6BB, 0xC6BB, 0xC6BB, 0xCEDB, 0xCEDC, 0x9555, 0x8492, 0x94D3, 0x72EB, 0x61E6, 0x6207, 0x6207, 0x6A27, 0x6A27, 0x6227, 0x6206, 0x6207, 0x61E7, 0x48C3, 0x3862, 0x3904, 0x2165, 0x39E7, 0x4207, 0x630A, 0x736C, 0x62A9, 0x6248, 0x6248, 0x6248, 
        0x6227, 0x51C6, 0x51C5, 0x5A06, 0x6206, 0x6A26, 0x6206, 0x6206, 0x6A27, 0x6A27, 0x6A27, 0x6A27, 0x6207, 0x6A27, 0x6A27, 0x6207, 0x6207, 0x5A07, 0x51E6, 0x20E2, 0x18E3, 0x2103, 0x10C2, 0x10A2, 0x18C2, 0x18C2, 0x0881, 0x0861, 0x0881, 0x10E1, 
        0x10C1, 0x10E1, 0x10C1, 0x10E1, 0x10E1, 0x10E1, 0x10E1, 0x2142, 0x5A66, 0x6A67, 0x6247, 0x6247, 0x6267, 0x6A67, 0x6247, 0x6247, 0x6247, 0x6267, 0x6A67, 0x5A46, 0x5A26, 0x62C9, 0x6B6C, 0x7BEF, 0x736D, 0x6269, 0x5A68, 0x4A68, 0x5289, 0x52AA, 
        0x738D, 0x6B4C, 0x6B2C, 0x630C, 0x6B0B, 0x7BAE, 0x9C71, 0x7B2B, 0x5A06, 0x6A47, 0x6A47, 0x6A47, 0x5A47, 0x5AEA, 0x638E, 0x6B6D, 0x6288, 0x7288, 0x7288, 0x7288, 0x6A87, 0x6246, 0x6247, 0x6247, 0x6226, 0x6226, 0x6A47, 0x6A47, 0x5A26, 0x5A68, 
        0x6B2C, 0x7C31, 0x7411, 0x7BD0, 0x7BAF, 0x5B8F, 0x5B6E, 0x62A9, 0x49C5, 0x10E1, 0x08C1, 0x08C1, 0x08A1, 0x10E2, 0x10E1, 0x10E1, 0x1101, 0x08C1, 0x08C1, 0x1102, 0x10E2, 0x10E1, 0x1101, 0x1122, 0x1922, 0x2983, 0x5A47, 0x6A67, 0x6247, 0x6247, 
        0x6267, 0x5226, 0x18C2, 0x3964, 0x6AAA, 0x52CC, 0x3A29, 0x49A6, 0x7247, 0x6A47, 0x7267, 0x7247, 0x6A47, 0x7247, 0x7247, 0x7247, 0x7268, 0x72A9, 0x628A, 0x3145, 0x6207, 0x20C3, 0x0020, 0x1061, 0x3985, 0x39A5, 0x41C6, 0x51E6, 0x51A5, 0x59A5, 
        0x59A6, 0x6A06, 0x8AA9, 0x8AA9, 0x8AA9, 0x92A9, 0x8AA9, 0x8A88, 0x92A9, 0x92A9, 0x7AEA, 0x7BEF, 0x7C30, 0x6BCF, 0x6BF0, 0x8CF3, 0xA576, 0x84B3, 0xADF7, 0xC69A, 0xCE9A, 0xC67A, 0xBE18, 0xBDB0, 0xCDCE, 0xC636, 0xC67A, 0xCEBB, 0xA574, 0x1983, 
        0x1122, 0x2162, 0x4A46, 0x5A46, 0x5267, 0x636D, 0x7C30, 0x738D, 0x5A66, 0x5A66, 0x5A66, 0x5266, 0x634C, 0x73EF, 0x52C8, 0x4A45, 0x4A65, 0x4A45, 0x4A45, 0x4A45, 0x4A25, 0x4245, 0x3183, 0x39C4, 0x4225, 0x4225, 0x4205, 0x4224, 0x4225, 0x4224, 
        0x4225, 0x4225, 0x4225, 0x4225, 0x39C4, 0x10C2, 0x1903, 0x1902, 0x1922, 0x1101, 0x1101, 0x1101, 0x10E2, 0x10E1, 0x10C1, 0x10E2, 0x2123, 0x2144, 0x1923, 0x2143, 0x31C5, 0x31C5, 0x2144, 0x52A9, 0x2143, 0x10C1, 0x1902, 0x10E1, 0x1102, 0x1102, 
        0x10C1, 0x1102, 0x10E1, 0x1102, 0x1922, 0x2164, 0x31E4, 0x4A86, 0x4225, 0x3A04, 0x31E5, 0x10C1, 0x29A4, 0x29C4, 0x2183, 0x29C4, 0x3A05, 0x4A86, 0x4A85, 0x4A65, 0x3A05, 0x4226, 0x4A66, 0x3A24, 0x3A24, 0x3A45, 0x3A24, 0x4A45, 0x4A45, 0x4A66, 
        0x4A45, 0x4A45, 0x4A25, 0x5287, 0xC5D5, 0xA4B1, 0xB574, 0xBDB5, 0xB595, 0xC616, 0x83CD, 0x4185, 0x49C6, 0x49A6, 0x5206, 0x5A06, 0x6A87, 0x6266, 0x6286, 0x6AE6, 0x6AC6, 0x6AC6, 0x6AC6, 0x8365, 0xB4C6, 0x8BA6, 0x49A5, 0x5206, 0x51E6, 0xAC0F, 
        0xCD12, 0xBC90, 0x5207, 0x2963, 0x10E1, 0x2984, 0x10E2, 0x10E2, 0x10C2, 0x10C2, 0x08C1, 0x0880, 0x6B2A, 0x8C6F, 0x1923, 0x08C1, 0x10E2, 0x10E1, 0x10E1, 0x1102, 0x10E2, 0x08A1, 0x0881, 0x0881, 0x10C1, 0x08A1, 0x10C1, 0x10E1, 0x2163, 0x39A4, 
        0x41A5, 0x49C5, 0x51E5, 0x3164, 0x4185, 0x5A06, 0x59C5, 0x51C5, 0x51C5, 0x51C5, 0x49A5, 0x4185, 0x4185, 0x51A5, 0x51A5, 0x51C5, 0x4185, 0x49A5, 0x51A5, 0x59C6, 0x59C6, 0x51E6, 0x59E6, 0x59E6, 0x5A06, 0x59E6, 0x5A06, 0x6265, 0x5A66, 0x31A5, 
        0x5A89, 0x5AAA, 0x632B, 0x59E6, 0x59E6, 0x51E6, 0x2103, 0x3144, 0x5A07, 0x18C2, 0x18C2, 0x18E2, 0x2943, 0x3984, 0x3964, 0x6227, 0x6227, 0x6207, 0x6248, 0x738D, 0x5A47, 0x6227, 0x6A27, 0x6227, 0x5A06, 0x6247, 0x6227, 0x6227, 0x6227,
  0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADF7, 0xADD6, 0xADD6, 0xADB6, 0xADB6, 0xADD6, 0xADB6, 0xADB6, 0xB5D6, 0x8C50, 0x5206, 0x5A26, 0x5A26, 0x5206, 0x5A06, 0x5A06, 0x5A06, 0x6269, 0x5AAA, 0x5ACB, 0x4AAB, 0x4ACB, 0x8C92, 0x8C92, 0x6BCE, 0x94F3, 
        0x6B6D, 0x4249, 0x52CA, 0x736C, 0xB4EF, 0xA3ED, 0x20E3, 0x0861, 0x0882, 0x3185, 0x5A67, 0x5A46, 0x6246, 0x5A46, 0x5A46, 0x6247, 0x5A27, 0x49E6, 0x62EA, 0x94D2, 0x840F, 0x8CB1, 0xA533, 0x8450, 0x8CD2, 0xBE79, 0xC6BB, 0xBE9A, 0xC69B, 0xC69B, 
        0xBE9A, 0xC69B, 0xC6BB, 0xC6BB, 0xCEFC, 0x8451, 0x29A5, 0x3228, 0x634C, 0x62AA, 0x41A6, 0x41E6, 0x41E7, 0x41E7, 0x39A6, 0x39A6, 0x39C6, 0x39A6, 0x3165, 0x3145, 0x3165, 0x31E7, 0x3A48, 0x428A, 0x5B2D, 0x8451, 0x6B8F, 0x52AB, 0x5B0C, 0x634C, 
        0x5B2C, 0x73CF, 0x632B, 0x4A45, 0x5265, 0x5265, 0x5265, 0x5266, 0x5266, 0x5266, 0x5A86, 0x5A86, 0x5266, 0x5266, 0x4A26, 0x4A07, 0x4228, 0x3A29, 0x3A29, 0x3209, 0x3209, 0x428A, 0x3A49, 0x4ACB, 0x638E, 0x6B6E, 0x530C, 0x530C, 0x4AA9, 0x4288, 
        0x31E6, 0x18E2, 0x29A4, 0x3A45, 0x31C3, 0x3A04, 0x4264, 0x4AC6, 0x52C6, 0x52C6, 0x4AA6, 0x4AA6, 0x52A7, 0x52A7, 0x52A7, 0x4A87, 0x4A86, 0x5286, 0x4A66, 0x4AA6, 0x52A6, 0x5AE9, 0x634C, 0x6B8D, 0x6B6D, 0x4A8A, 0x3249, 0x3A69, 0x3A69, 0x7C51, 
        0x6B8E, 0x3A08, 0x31E7, 0x31E7, 0x3A08, 0x3A28, 0x636D, 0x8C71, 0x630B, 0x52A8, 0x52E9, 0x632A, 0x6B0A, 0x738D, 0x5B4D, 0x638D, 0x5AE9, 0x4AA6, 0x52C6, 0x52E6, 0x52E6, 0x52E6, 0x52C6, 0x52C6, 0x52C6, 0x52C6, 0x52C6, 0x4AA6, 0x4A87, 0x3A27, 
        0x2986, 0x31E7, 0x31C7, 0x3A08, 0x31A7, 0x31C7, 0x31E6, 0x4247, 0x52C7, 0x4285, 0x3A44, 0x3A24, 0x29A3, 0x1942, 0x2183, 0x29A4, 0x1943, 0x1943, 0x1943, 0x2164, 0x2984, 0x3206, 0x3A27, 0x3A27, 0x3206, 0x3A26, 0x4A47, 0x4226, 0x4A67, 0x52A7, 
        0x4A86, 0x4226, 0x31A6, 0x39E7, 0x39E7, 0x31C7, 0x4228, 0x4A69, 0x5288, 0x52A8, 0x5AA7, 0x5AC7, 0x5AC7, 0x62C7, 0x62C7, 0x62C7, 0x5AE7, 0x5AE8, 0x4267, 0x2985, 0x52A7, 0x2123, 0x10A2, 0x2964, 0x39C6, 0x3185, 0x39A5, 0x41E6, 0x41C6, 0x49E6, 
        0x4A06, 0x5A66, 0x6AC7, 0x6AC7, 0x72E7, 0x72C7, 0x6AC7, 0x6AC7, 0x72E8, 0x6AE9, 0x5AEA, 0x4AEA, 0x3228, 0x1966, 0x1966, 0x7410, 0x636D, 0x3A69, 0x8492, 0xBE79, 0xC69A, 0xC65A, 0xBE18, 0xB618, 0xC67A, 0xC67A, 0xBE5A, 0xD6DB, 0xA595, 0x29C5, 
        0x2163, 0x3204, 0x4AE6, 0x4AE6, 0x4AA6, 0x52EB, 0x636E, 0x5B2A, 0x4AC6, 0x4AE6, 0x4AE6, 0x5308, 0x7C2F, 0x9CF3, 0x6BCB, 0x42C5, 0x42C5, 0x42C5, 0x4AE5, 0x4AE6, 0x4AC6, 0x4AE7, 0x4287, 0x4AA8, 0x5328, 0x4AE8, 0x5328, 0x5328, 0x4AE7, 0x42A5, 
        0x3AA4, 0x3AA4, 0x3A84, 0x3A64, 0x29E4, 0x10A2, 0x10E2, 0x2A04, 0x3224, 0x29E4, 0x29C4, 0x29A5, 0x2185, 0x2185, 0x2185, 0x29E7, 0x3A49, 0x3A28, 0x3208, 0x4A8A, 0x52CB, 0x4269, 0x3A48, 0x5B4C, 0x3A07, 0x10C1, 0x10C1, 0x0881, 0x10C1, 0x10C1, 
        0x0881, 0x10A1, 0x0880, 0x08A1, 0x1902, 0x2984, 0x29A4, 0x29A3, 0x29C3, 0x31E4, 0x2163, 0x0881, 0x3224, 0x3A44, 0x3244, 0x2A03, 0x2A03, 0x42A5, 0x3AA5, 0x42A5, 0x3A65, 0x3A65, 0x42C5, 0x42C5, 0x42A5, 0x42A5, 0x42A5, 0x42A5, 0x42A5, 0x42A5, 
        0x4285, 0x4286, 0x4287, 0x5B2A, 0xC5F6, 0xA4B1, 0xAD12, 0xA4D1, 0x9C70, 0xBD94, 0x8BEE, 0x49C5, 0x51E6, 0x49C6, 0x6247, 0x6268, 0x5A06, 0x49A6, 0x49A5, 0x4985, 0x49C5, 0x49A6, 0x4165, 0x8346, 0xC547, 0x7306, 0x6AA8, 0x5A47, 0x49C6, 0xA3CE, 
        0xCCD2, 0xB450, 0x5206, 0x39E5, 0x29E5, 0x31E5, 0x1924, 0x2165, 0x1102, 0x10C1, 0x08A1, 0x10E1, 0x4A67, 0x9CF1, 0x1943, 0x0060, 0x0880, 0x10E2, 0x10E1, 0x2163, 0x2143, 0x10C2, 0x10C1, 0x1102, 0x3204, 0x29E4, 0x3204, 0x3244, 0x3A65, 0x4265, 
        0x4265, 0x4246, 0x4246, 0x31E5, 0x31E5, 0x4246, 0x4A25, 0x4225, 0x4245, 0x4225, 0x4225, 0x39E5, 0x31A4, 0x4205, 0x4205, 0x41E5, 0x39C5, 0x41E5, 0x41E5, 0x41E5, 0x4A05, 0x4A05, 0x4A05, 0x4A05, 0x5225, 0x4A05, 0x49E5, 0x6AA5, 0x5244, 0x10A2, 
        0x5268, 0x52A9, 0x634C, 0x5226, 0x5A06, 0x4A06, 0x18E2, 0x2944, 0x5206, 0x18A2, 0x18A2, 0x18E2, 0x3964, 0x5206, 0x41A5, 0x6226, 0x6227, 0x6226, 0x62A9, 0x842F, 0x6AC9, 0x6206, 0x6206, 0x6247, 0x59E6, 0x5A07, 0x6207, 0x6207, 0x6207,
  0xADF7, 0xADD7, 0xADB6, 0xADB6, 0xADB6, 0xAD95, 0xA595, 0xA574, 0x9D34, 0xA554, 0xA574, 0xA574, 0xA554, 0xA534, 0x844F, 0x4285, 0x4285, 0x42A5, 0x4A85, 0x4225, 0x39E6, 0x4AAA, 0x4ACB, 0x42CC, 0x42CC, 0x3229, 0x6BEF, 0x8471, 0x4ACA, 0x42AA, 0x7C30, 
        0x6B8E, 0x1924, 0x2965, 0x4A87, 0x9C2D, 0x9C0D, 0x18C2, 0x0862, 0x0882, 0x29C4, 0x4AC6, 0x4AC5, 0x4AC5, 0x4AC5, 0x4AC6, 0x4266, 0x31E6, 0x29C6, 0x5B4C, 0x842F, 0x73AD, 0x8C91, 0x7C0F, 0x7C0F, 0x9513, 0xBE79, 0xC69B, 0xBE9A, 0xBE9A, 0xBE9A, 
        0xBE9A, 0xBE9A, 0xBE9A, 0xBE9A, 0xC6DB, 0x94F4, 0x3247, 0x2A47, 0x29E7, 0x5B6D, 0x428A, 0x3A69, 0x3A8A, 0x3A69, 0x3208, 0x31E7, 0x31E7, 0x31C7, 0x31E7, 0x31C7, 0x29A6, 0x29C7, 0x3249, 0x3A8A, 0x7C72, 0x6BAE, 0x2165, 0x29A6, 0x3228, 0x4B0A, 
        0x4B09, 0x5B8E, 0x9556, 0x5B6B, 0x42A5, 0x4AA5, 0x4AA5, 0x42A5, 0x4284, 0x4284, 0x4284, 0x4284, 0x4265, 0x3A46, 0x3A88, 0x430B, 0x3ACB, 0x3ACB, 0x328C, 0x326B, 0x29E8, 0x29C7, 0x29A7, 0x2A07, 0x7C51, 0xB5D7, 0x5B4D, 0x63CF, 0x7451, 0x63AE, 
        0x6BCE, 0x6BCF, 0x530A, 0x4AC7, 0x3A24, 0x4AE6, 0x4AE5, 0x4AE5, 0x4AE6, 0x4AC7, 0x4AE9, 0x4AC9, 0x4AA9, 0x4AA9, 0x4207, 0x4227, 0x4227, 0x4227, 0x52A9, 0x4267, 0x4AA6, 0x4246, 0x4227, 0x4A89, 0x4A49, 0x3A29, 0x3269, 0x3229, 0x73EF, 0x9CF3, 
        0x8C71, 0x5AEB, 0x3A28, 0x4248, 0x52AA, 0x4A8A, 0x29C7, 0x4B0C, 0x5BAE, 0x42AA, 0x4AEA, 0x6BCD, 0x2964, 0x4288, 0x638C, 0x42CA, 0x5B4B, 0x4288, 0x4AC8, 0x52E6, 0x5305, 0x5305, 0x5305, 0x5305, 0x5325, 0x5326, 0x5306, 0x4AE8, 0x3A89, 0x3A69, 
        0x3A49, 0x426A, 0x4269, 0x3A49, 0x4289, 0x4269, 0x530B, 0x4289, 0x3A26, 0x4AE7, 0x5306, 0x4AE5, 0x4AE6, 0x3204, 0x3205, 0x3A27, 0x3207, 0x3208, 0x3A28, 0x4249, 0x52AA, 0x5B0C, 0x4A8A, 0x4249, 0x4289, 0x4AAA, 0x4269, 0x31E7, 0x31E6, 0x42A8, 
        0x42A9, 0x3A89, 0x3A69, 0x3A89, 0x4ACA, 0x636D, 0x4AEB, 0x3A48, 0x3228, 0x3A48, 0x4AA8, 0x4AC8, 0x4AA8, 0x4AA8, 0x52C8, 0x4AA7, 0x4AE8, 0x5308, 0x4AA7, 0x2984, 0x4AE6, 0x2984, 0x29C7, 0x3A69, 0x3A48, 0x3A48, 0x4228, 0x3A28, 0x4268, 0x4ACA, 
        0x4AAA, 0x4A88, 0x7BCA, 0x7389, 0x73A9, 0x73A9, 0x6347, 0x4AE5, 0x5307, 0x5B4B, 0x532B, 0x4AEA, 0x4289, 0x530C, 0x63AF, 0x6BEF, 0x530B, 0x6BAE, 0x6C10, 0xAE17, 0xC69A, 0xCE9A, 0xC67A, 0xC67A, 0xBE7A, 0xB639, 0xB619, 0xCEBB, 0xADD7, 0x532C, 
        0x4289, 0x4287, 0x5326, 0x5B46, 0x4AE7, 0x52EB, 0x5B4D, 0x4AEA, 0x4288, 0x3A46, 0x4267, 0x52EA, 0x73EE, 0x8491, 0x7C2E, 0x5326, 0x5326, 0x4AC7, 0x42A7, 0x42A8, 0x4AA9, 0x530B, 0x5B4D, 0x5B4D, 0x5B4D, 0x7410, 0x636D, 0x52EB, 0x636C, 0x638C, 
        0x4AE6, 0x4AC5, 0x4AC5, 0x42A4, 0x3204, 0x10C1, 0x1902, 0x3203, 0x29E3, 0x29E5, 0x3227, 0x3228, 0x3228, 0x3A8A, 0x3A49, 0x3249, 0x428A, 0x428A, 0x4AAB, 0x4A8A, 0x29A6, 0x2165, 0x2145, 0x5B0C, 0x4269, 0x2185, 0x1922, 0x10E1, 0x2142, 0x2142, 
        0x18E2, 0x2103, 0x2123, 0x2143, 0x2143, 0x2165, 0x1103, 0x10E2, 0x1923, 0x2123, 0x2903, 0x3944, 0x41A5, 0x59E5, 0x61E5, 0x49A4, 0x41A4, 0x39E3, 0x29E2, 0x2A03, 0x31E4, 0x3226, 0x3A86, 0x42A7, 0x42C7, 0x4AE7, 0x4AE7, 0x4AE7, 0x4AC6, 0x4AC6, 
        0x42A7, 0x3268, 0x3228, 0x4A89, 0xC5D6, 0xACD1, 0xBD54, 0xA470, 0xACF2, 0xBDB5, 0x83CD, 0x49A5, 0x49E6, 0x5A26, 0x72C9, 0x6247, 0x49C6, 0x49A6, 0x4985, 0x4185, 0x49A6, 0x49A6, 0x4185, 0x6AA5, 0x9C26, 0x5205, 0x7B09, 0x5A47, 0x51C6, 0x72EA, 
        0x8B8D, 0x730B, 0x41A5, 0x5AAA, 0x636D, 0x6BAD, 0x5B2C, 0x530C, 0x52EB, 0x42A9, 0x3205, 0x29E3, 0x4245, 0xA510, 0x3204, 0x29A3, 0x29A3, 0x29C3, 0x29A3, 0x29C4, 0x2184, 0x7BEE, 0x6B8B, 0x2182, 0x29E3, 0x2A03, 0x3A44, 0x3A65, 0x3A85, 0x3A87, 
        0x3A47, 0x3227, 0x3248, 0x3A48, 0x3A48, 0x3206, 0x3226, 0x4286, 0x4AC6, 0x4AC6, 0x3A66, 0x3206, 0x29E6, 0x3227, 0x3227, 0x3A47, 0x31E6, 0x29C5, 0x3A45, 0x4285, 0x3A84, 0x3A65, 0x3A25, 0x3A46, 0x3A26, 0x3205, 0x3206, 0x4AA9, 0x3A06, 0x2985, 
        0x4247, 0x52EA, 0x740F, 0x4AA7, 0x3A24, 0x39E4, 0x2122, 0x2983, 0x39E4, 0x18E1, 0x18E2, 0x2102, 0x3164, 0x4A46, 0x5267, 0x4A65, 0x4A45, 0x4A45, 0x52A8, 0x7BEE, 0x52E8, 0x4245, 0x4245, 0x4A65, 0x31C4, 0x39E6, 0x31C5, 0x31A6, 0x31A6,
  0xA575, 0xA554, 0x9CF3, 0x94D2, 0x94D2, 0x94D2, 0x8C70, 0x8450, 0x842F, 0x844F, 0x8C70, 0x9491, 0x8C70, 0x8450, 0x73ED, 0x3A84, 0x3A84, 0x3A64, 0x3205, 0x3A48, 0x4A8A, 0x3A6A, 0x3AAB, 0x42EC, 0x42AB, 0x7C51, 0x9514, 0x7C31, 0x4AAA, 0x42CA, 0x7430, 
        0x94D3, 0x6B6E, 0x7BEF, 0x41C6, 0x72C9, 0x6267, 0x10A2, 0x1082, 0x0041, 0x1922, 0x4284, 0x3A84, 0x4284, 0x4265, 0x3205, 0x3A27, 0x42AA, 0x42EB, 0x740F, 0x8C70, 0x8C50, 0x9D13, 0x94B1, 0x8C91, 0x9D13, 0xBE59, 0xAE18, 0xA5B7, 0xA5D7, 0xA5B7, 
        0xB639, 0xBEBB, 0xBE9B, 0xBE9B, 0xC6DB, 0x9D76, 0x2A28, 0x2A07, 0x2A07, 0x1965, 0x3228, 0x532D, 0x428A, 0x29A6, 0x29C6, 0x3A07, 0x31E7, 0x31C6, 0x31E7, 0x31E7, 0x31A7, 0x2986, 0x29C7, 0x5B4D, 0x636D, 0x532C, 0x6B8E, 0x4AEB, 0x4AEB, 0x638D, 
        0x6BEE, 0x63AE, 0x9D77, 0x9D56, 0x52C8, 0x4245, 0x4265, 0x4265, 0x4265, 0x3A65, 0x3A45, 0x3A05, 0x2184, 0x29E7, 0x2A49, 0x2A69, 0x430D, 0x3AEE, 0x3A8D, 0x3229, 0x2A08, 0x29E8, 0x3228, 0x21A6, 0x8450, 0x9CF3, 0x2A08, 0x3228, 0x534C, 0x2A07, 
        0x3A89, 0x636D, 0x4289, 0x3206, 0x3225, 0x3A44, 0x3A44, 0x3A44, 0x3A45, 0x530A, 0x5B4B, 0x530B, 0x52CA, 0x4A89, 0x52EB, 0x5B0B, 0x632B, 0x3A07, 0x634B, 0x6B8C, 0x5AEA, 0x52C9, 0x6B6C, 0x73CE, 0x6B8D, 0x73CF, 0x8CB2, 0xA555, 0xC658, 0x8451, 
        0xA554, 0xAD75, 0xA554, 0xA554, 0xAD95, 0x73EE, 0x538D, 0x6430, 0x534D, 0x4AEB, 0x6BAE, 0x8CB1, 0x73AD, 0x634B, 0x94F1, 0x63AD, 0x638C, 0x6BAD, 0x636C, 0x52E9, 0x4AA5, 0x4AE5, 0x4AE5, 0x4AC5, 0x4AC5, 0x4285, 0x4AA8, 0x42A9, 0x3A8A, 0x3A8A, 
        0x3A6A, 0x4269, 0x29C7, 0x42AA, 0x530C, 0x4289, 0x4AAA, 0x4A89, 0x3A28, 0x29C5, 0x3225, 0x3A64, 0x3A64, 0x31E5, 0x2986, 0x31C7, 0x3208, 0x3208, 0x3A29, 0x5B4D, 0x6B8E, 0x3A08, 0x31E7, 0x4289, 0x4ACB, 0x3A28, 0x4A8A, 0x4269, 0x31E7, 0x3A89, 
        0x42AA, 0x3A69, 0x3A69, 0x428A, 0x52EB, 0x4AEB, 0x4ACA, 0x4AAA, 0x3A69, 0x3A48, 0x4269, 0x3A28, 0x3208, 0x4269, 0x31C6, 0x2965, 0x530B, 0x5B6C, 0x42A9, 0x31E6, 0x3A46, 0x3A48, 0x42AA, 0x3A69, 0x428A, 0x52EB, 0x4228, 0x4269, 0x4289, 0x3208, 
        0x3228, 0x2986, 0x31C6, 0x2985, 0x4248, 0x6B4B, 0x7BCA, 0x6B47, 0x8CAF, 0xCEBB, 0xC679, 0xBE59, 0xC67A, 0xC69A, 0xDF3D, 0x9D76, 0x9D55, 0xBE7A, 0xB659, 0xAE18, 0xC69A, 0xCEBB, 0xC69A, 0xB619, 0xB639, 0xC67A, 0xCEBB, 0xC65A, 0xADB6, 0x4B0C, 
        0x42AA, 0x3A69, 0x3A26, 0x3A46, 0x3A67, 0x3AAA, 0x42CB, 0x42CA, 0x3A28, 0x1903, 0x31E7, 0x52EA, 0x7C0F, 0x7C30, 0x636A, 0x4AE5, 0x4AC6, 0x5B49, 0x4AC9, 0x3A69, 0x3A69, 0x42AA, 0x3229, 0x3229, 0x532C, 0x8472, 0x2125, 0x2125, 0x2986, 0x428A, 
        0x6BAC, 0x4AE5, 0x4AC5, 0x4AC5, 0x42A4, 0x3203, 0x3A24, 0x4285, 0x3A87, 0x42C9, 0x42A9, 0x3A69, 0x3A08, 0x3A29, 0x3208, 0x3228, 0x3A28, 0x4269, 0x3A49, 0x29C7, 0x3208, 0x31E7, 0x29A6, 0x6B8E, 0x4AAA, 0x2185, 0x3225, 0x4284, 0x3A84, 0x3A64, 
        0x4267, 0x52CA, 0x4A89, 0x52EB, 0x52CA, 0x1904, 0x2145, 0x31A6, 0x4208, 0x4228, 0x4228, 0x4249, 0x5269, 0x8A29, 0x5104, 0x3103, 0x59C7, 0x61E6, 0x4224, 0x3224, 0x3A47, 0x3A48, 0x3A68, 0x3AA9, 0x638D, 0x4268, 0x3A68, 0x42A8, 0x4AA9, 0x530A, 
        0x3A89, 0x3A69, 0x3A28, 0x73CD, 0xBDB4, 0xB574, 0xA513, 0xAD54, 0xA533, 0xBDF6, 0x8C4F, 0x5A88, 0x5268, 0x5268, 0x62C9, 0x5247, 0x41E6, 0x5248, 0x6AEA, 0x6AEA, 0x4A07, 0x5248, 0x41E6, 0x5246, 0x7B68, 0x4A06, 0x6B0A, 0x5A47, 0x49E6, 0x62A9, 
        0x4A07, 0x5228, 0x5248, 0x734C, 0x73EF, 0x7C0F, 0x52CA, 0x73CE, 0x73CE, 0x7C0F, 0x6BCD, 0x4AC8, 0x52E6, 0xC615, 0x7C0C, 0x4AC8, 0x530A, 0x5B4B, 0x6C0E, 0x638C, 0x530B, 0xA532, 0x6BEA, 0x3A84, 0x42A4, 0x42A5, 0x3A65, 0x3226, 0x3A88, 0x42AA, 
        0x3A49, 0x3249, 0x428A, 0x428A, 0x3A29, 0x3A29, 0x3A49, 0x426A, 0x4248, 0x3227, 0x31E7, 0x3208, 0x3A69, 0x42AA, 0x42A9, 0x3A68, 0x21A6, 0x1944, 0x2164, 0x4285, 0x42A6, 0x3A67, 0x3A27, 0x3228, 0x3228, 0x3A28, 0x3A49, 0x29E7, 0x3207, 0x2185, 
        0x29A5, 0x4AEA, 0x6BAE, 0x4AE8, 0x4264, 0x4285, 0x4AA5, 0x4265, 0x4246, 0x4247, 0x4227, 0x4207, 0x4207, 0x4A07, 0x4A48, 0x4246, 0x4A86, 0x4AA5, 0x5B2A, 0x8CB2, 0x6BAB, 0x4285, 0x4AA5, 0x4AA5, 0x3206, 0x3247, 0x3248, 0x3229, 0x3A49,
  0x840F, 0x840E, 0x73AD, 0x73AD, 0x73AD, 0x73AD, 0x738C, 0x738D, 0x73AD, 0x738C, 0x738C, 0x73AD, 0x7BAD, 0x83CD, 0x738C, 0x6308, 0x6308, 0x5AC8, 0x62E9, 0x6B4C, 0x6B4C, 0x634C, 0x6B8D, 0x73EF, 0x9CF2, 0xB595, 0x6B6D, 0x8C70, 0x94B1, 0xA533, 0xAD74, 
        0xB5B6, 0xBDD6, 0xBDD6, 0x7B4C, 0x6226, 0x5A47, 0x5247, 0x4A27, 0x4A27, 0x4A67, 0x62C8, 0x62E9, 0x62E9, 0x62EA, 0x630B, 0x6B2C, 0x6B2C, 0x632B, 0x7BAD, 0x83EE, 0x840E, 0x944F, 0x7BCD, 0x8C4F, 0x8C70, 0x8430, 0x94D2, 0x94F3, 0x94F3, 0x9513, 
        0x9513, 0x9D54, 0xA554, 0xA554, 0x9D54, 0x9D54, 0x8450, 0x842F, 0x6B6C, 0x4A27, 0x52A9, 0x94B2, 0x6B4C, 0x4A27, 0x5268, 0x5AC9, 0x62EA, 0x62C9, 0x62CA, 0x62CA, 0x5AA9, 0x5AA9, 0x62A9, 0x62CA, 0x5AA9, 0x73CE, 0x8C91, 0x94B2, 0x9CF3, 0x9D14, 
        0x9D14, 0x9D13, 0x9D34, 0x9D14, 0x8B8D, 0x6B29, 0x6B29, 0x6329, 0x6329, 0x6309, 0x5AE9, 0x5288, 0x5289, 0x52AA, 0x52AA, 0x52EC, 0x636F, 0x534F, 0x634E, 0x73CE, 0x73AD, 0x738D, 0x7BAD, 0x738D, 0x94D2, 0x9491, 0x6B6C, 0x630B, 0x7BCD, 0x632B, 
        0x636C, 0x73CD, 0x6B8C, 0x5B0A, 0x52C9, 0x5B09, 0x6329, 0x6309, 0x62E9, 0x632A, 0x630A, 0x62EA, 0x6B2B, 0x62EA, 0x6B0A, 0x7B8C, 0x7B8C, 0x62C9, 0x6B0A, 0x738C, 0x736C, 0x734B, 0x738C, 0x738D, 0x7BAD, 0xAD54, 0xC637, 0xC5F7, 0xAD74, 0x9CD2, 
        0x9491, 0x9CD1, 0x9CD1, 0x9470, 0x7BED, 0x632B, 0x6B6C, 0x632B, 0x6B4C, 0x7C0E, 0x94B1, 0x8C2F, 0x94B0, 0x94B0, 0x9490, 0x94B0, 0x9490, 0x9490, 0x94B0, 0x840E, 0x6B2A, 0x6B29, 0x6B29, 0x6B29, 0x6B29, 0x62E9, 0x62EA, 0x62EB, 0x5ACA, 0x5ACA, 
        0x5AEB, 0x62EA, 0x52A9, 0x630B, 0x5B0B, 0x5ACA, 0x5AEA, 0x52CA, 0x52A9, 0x4A89, 0x4A69, 0x4AA9, 0x5AE9, 0x52A9, 0x4AAA, 0x4A8A, 0x4A89, 0x4A89, 0x52EB, 0x7C10, 0x6B8D, 0x52EB, 0x52CA, 0x530B, 0x638D, 0x5B2C, 0x52EB, 0x52AA, 0x4AA9, 0x4AAA, 
        0x4AAA, 0x4AAA, 0x4AAA, 0x52EB, 0x52CA, 0x634C, 0x5B2C, 0x5B0B, 0x52EB, 0x52CA, 0x52AA, 0x4A89, 0x4269, 0x4A69, 0x4A69, 0x5B2B, 0x5B0B, 0x5B0B, 0x530B, 0x52A9, 0x4A89, 0x4A8A, 0x4A89, 0x4269, 0x52CA, 0x5AEB, 0x4248, 0x4268, 0x4A89, 0x4248, 
        0x4228, 0x4207, 0x39E7, 0x3A07, 0x5289, 0x7BAD, 0x83CC, 0xA4AE, 0x9491, 0x9D75, 0xA596, 0xA5B6, 0xADB6, 0x9534, 0xADB6, 0xADB6, 0x9D76, 0x8CF4, 0x9D75, 0x9D54, 0xADB6, 0xB5F8, 0xB5D7, 0xADB7, 0xADD7, 0xB5D7, 0xB5F7, 0xADB6, 0x9D13, 0x530B, 
        0x52CA, 0x52CA, 0x4248, 0x3A08, 0x4269, 0x52EB, 0x5B2B, 0x52EA, 0x4AA9, 0x4A69, 0x52CA, 0x632B, 0x842F, 0x8430, 0x73CD, 0x52C7, 0x4AA9, 0x5AEA, 0x634C, 0x5B2C, 0x5B2C, 0x530B, 0x530C, 0x5B4D, 0x8471, 0x9D14, 0x7C10, 0x5B2C, 0x6BAE, 0x73CF, 
        0x8C92, 0x73ED, 0x5307, 0x5307, 0x5B27, 0x5B27, 0x52E7, 0x4A87, 0x4269, 0x94B2, 0x52CA, 0x3A07, 0x3A28, 0x3A28, 0x73CE, 0xB5D6, 0x7C0F, 0x4249, 0x31C7, 0x29A6, 0x31C6, 0x2985, 0x2965, 0x52EC, 0x52CB, 0x2965, 0x4226, 0x5306, 0x52C6, 0x4267, 
        0x4268, 0x4A69, 0x4A69, 0x4A89, 0x4A69, 0x2924, 0x41A6, 0x7269, 0x726A, 0x728A, 0x72AA, 0x72AA, 0x8AEB, 0x8A49, 0x7A08, 0x7249, 0x8289, 0x9269, 0x8AA9, 0x5B2B, 0x6BCD, 0x94D2, 0x8470, 0x6BCE, 0x8470, 0x6B8D, 0x636C, 0x8450, 0x8471, 0x8C92, 
        0x8C92, 0x8CB2, 0xB5B5, 0xBDF6, 0xB594, 0xA553, 0x8C91, 0x9CF2, 0x94F2, 0x9D33, 0x94B1, 0x6B4C, 0x73AD, 0x634C, 0x4268, 0x3A28, 0x4248, 0x73ED, 0xA511, 0xB573, 0x736C, 0x6B6C, 0x8C70, 0x7BEE, 0x738D, 0x842F, 0x9CF2, 0x9470, 0x738C, 0x9491, 
        0x7BEE, 0x9C90, 0xA4D1, 0x9CB1, 0xAD74, 0x9CF1, 0xC5F6, 0xD678, 0xCE57, 0xC636, 0x9CD2, 0x632B, 0x8C6F, 0xD698, 0xB5B5, 0x6BCD, 0x73EE, 0x8471, 0x8CB1, 0x6B8D, 0x6BAD, 0x73EE, 0x6B8A, 0x5B27, 0x4AC6, 0x4AA7, 0x4AA8, 0x3207, 0x3A28, 0x3228, 
        0x3A29, 0x4269, 0x3A69, 0x3A29, 0x3229, 0x3A29, 0x428A, 0x4AAB, 0x29C7, 0x2186, 0x2186, 0x2166, 0x29A7, 0x3228, 0x2185, 0x1924, 0x1924, 0x1904, 0x1924, 0x2964, 0x31E7, 0x3228, 0x3228, 0x3228, 0x3229, 0x3A69, 0x4289, 0x29C6, 0x29A6, 0x21A6, 
        0x29C6, 0x4ACA, 0x740F, 0x5308, 0x3A43, 0x3243, 0x3224, 0x3226, 0x4248, 0x4248, 0x4229, 0x4249, 0x528A, 0x5228, 0x4A07, 0x39C6, 0x39E5, 0x4225, 0x5B2A, 0x8472, 0x636B, 0x3243, 0x3A64, 0x3A24, 0x3206, 0x3228, 0x42AA, 0x4AAB, 0x428A,
  0x738C, 0x73AC, 0x7BAD, 0x7BAD, 0x7BAD, 0x6B6C, 0x7BAD, 0x7BAD, 0x7BAD, 0x7BAD, 0x7BAD, 0x738C, 0x7BAC, 0x8C0E, 0x8BED, 0x8C0E, 0x8BEE, 0x8C0D, 0x8C0E, 0x8C0E, 0x944F, 0x8C0E, 0x83CD, 0x8BED, 0x8BED, 0x83CD, 0x8BED, 0x8BED, 0x83CD, 0x83CD, 0x83CD, 
        0x83CD, 0x7B8C, 0x83CD, 0x8BED, 0x8BED, 0x8BED, 0x8BED, 0x8C0D, 0x8BED, 0x8BCD, 0x83AC, 0x83AC, 0x8BCC, 0x8BAC, 0x8BCD, 0x83CD, 0x83AC, 0x83AC, 0x83AC, 0x83AC, 0x83AC, 0x83AC, 0x83AC, 0x738B, 0x7BAD, 0x7BAD, 0x7BAD, 0x7BAD, 0x7BAD, 0x7BAD, 
        0x7BAC, 0x7BAC, 0x8BCD, 0x83CD, 0x83AC, 0x83CD, 0x83CD, 0x7BAC, 0x8BED, 0x8C0E, 0x8BED, 0x83CD, 0x8C0E, 0x83CD, 0x93ED, 0x8BED, 0x8BED, 0x8BED, 0x8BED, 0x8BAD, 0x83AC, 0x8BCD, 0x8BCD, 0x8BCD, 0x8BCC, 0x8BCD, 0x8BCD, 0x83AC, 0x83CD, 0x83CD, 
        0x83CD, 0x8BCD, 0x83AC, 0x8BCD, 0x8BED, 0x83CD, 0x8C0E, 0x8C0E, 0x8C0E, 0x8C0E, 0x8C0E, 0x83ED, 0x83CD, 0x8C0E, 0x8BEE, 0x8C0E, 0x83CD, 0x83CD, 0x8C0E, 0x8BED, 0x8BED, 0x8BED, 0x8BED, 0x83CD, 0x83CD, 0x83CD, 0x83ED, 0x83CD, 0x83CD, 0x83CD, 
        0x7BCD, 0x83ED, 0x83ED, 0x83CD, 0x83CD, 0x83CD, 0x83CD, 0x8C0E, 0x8C0E, 0x8BED, 0x8C0D, 0x940E, 0x8BED, 0x8BED, 0x8BED, 0x8BED, 0x8BED, 0x83CD, 0x8BCD, 0x83AC, 0x838C, 0x8BCD, 0x838C, 0x7B6B, 0x83AC, 0x83CD, 0x83CD, 0x7BAC, 0x736C, 0x7B8C, 
        0x7B8C, 0x838C, 0x8BCD, 0x8BAC, 0x83CC, 0x8BCD, 0x83AC, 0x83AD, 0x7BAD, 0x7BAC, 0x7B8C, 0x7B8C, 0x7B8C, 0x7BAC, 0x8BCC, 0x83AC, 0x83CC, 0x83CD, 0x7B8C, 0x83AD, 0x83CD, 0x83AD, 0x83AD, 0x7BAC, 0x83CD, 0x83CD, 0x83CD, 0x83CD, 0x7B8C, 0x83CD, 
        0x83CD, 0x83CD, 0x83CD, 0x83CD, 0x736C, 0x738C, 0x7BAD, 0x738D, 0x738C, 0x6B8C, 0x6B8D, 0x6BAD, 0x73AD, 0x6B8D, 0x6B6C, 0x6B6C, 0x6B6C, 0x6B4C, 0x634B, 0x6B6D, 0x6B8D, 0x6B8D, 0x6B8D, 0x6BAD, 0x6B8D, 0x6B8D, 0x6BAD, 0x6BAD, 0x73AE, 0x73AD, 
        0x73AD, 0x73AD, 0x6BAD, 0x6B8D, 0x6B8D, 0x6B8D, 0x6B8D, 0x636C, 0x6B8D, 0x6BAD, 0x73AE, 0x7BEE, 0x73AD, 0x6BAD, 0x6BAD, 0x6BAD, 0x6BAD, 0x6BAD, 0x6B8D, 0x6B8D, 0x73AD, 0x738D, 0x738D, 0x73AD, 0x73AD, 0x73AD, 0x73AD, 0x738D, 0x738D, 0x738D, 
        0x6B6C, 0x6B6C, 0x6B6C, 0x738D, 0x7BCE, 0x7BEE, 0x73EE, 0x73AD, 0x73AE, 0x73AE, 0x73CE, 0x73AE, 0x6B8D, 0x6B6C, 0x6B6C, 0x6B6C, 0x6B8D, 0x6B8D, 0x6B8D, 0x6B8D, 0x6B8D, 0x73AD, 0x738D, 0x6B8D, 0x6B8D, 0x73AE, 0x73AE, 0x73CE, 0x73AE, 0x6BAE, 
        0x6B8D, 0x6B8D, 0x6B8D, 0x6B8D, 0x73AE, 0x73CE, 0x6B8D, 0x73AD, 0x73CE, 0x73AD, 0x6B8D, 0x73AD, 0x73AD, 0x73AD, 0x73AD, 0x6BAD, 0x6BAD, 0x6B8D, 0x73AD, 0x6B8D, 0x738D, 0x6B4C, 0x6B8D, 0x73AD, 0x738D, 0x738D, 0x73AD, 0x7BEE, 0x7C0E, 0x73CE, 
        0x6B8D, 0x73CE, 0x6B8D, 0x73AD, 0x83ED, 0x83ED, 0x7BCD, 0x7BCE, 0x73AD, 0x842F, 0x73AD, 0x6B6C, 0x634C, 0x6B6C, 0x73AD, 0x842F, 0x73AD, 0x6B8D, 0x6B6D, 0x6B6C, 0x6B6C, 0x6B8D, 0x6B8E, 0x52ED, 0x73CF, 0x73AD, 0x7BCD, 0x7BCD, 0x7BCD, 0x7BCD, 
        0x83EE, 0x840E, 0x842F, 0x840F, 0x83CE, 0x8C0E, 0x940E, 0x9C4F, 0xB4F2, 0xB512, 0xBD33, 0xB512, 0xB4F2, 0xA4D1, 0x9C50, 0xA450, 0x9C70, 0x9C50, 0x942F, 0x8C50, 0x8C91, 0xA533, 0xA533, 0x9CF2, 0x9D13, 0x9D12, 0xAD74, 0xBE16, 0xB5B5, 0xADB5, 
        0xBDD6, 0xC637, 0xC617, 0xBDF6, 0xB594, 0xAD74, 0xB5B4, 0xBDD5, 0xBDD5, 0xB5B5, 0xBDD6, 0xBDF6, 0xCE57, 0xBE16, 0xB5D5, 0xB594, 0xB594, 0xBDF6, 0xBDD5, 0xBDD5, 0xBDD6, 0xBDB5, 0xCE57, 0xCE57, 0xC616, 0xC5F6, 0xC636, 0xD698, 0xCE57, 0xC5F5, 
        0xC616, 0xC616, 0xCE78, 0xCE57, 0xC637, 0xC616, 0xC616, 0xBE16, 0xBE16, 0xC617, 0xC636, 0xC616, 0xB5D5, 0xB5B5, 0xC657, 0xC657, 0xBE16, 0xB5D5, 0xAD94, 0xAD94, 0x8470, 0x9D33, 0xBDF6, 0xB5D5, 0xBDD5, 0xB5B5, 0xAD94, 0x9CF2, 0x7C0F, 0x5AEA, 
        0x6B8D, 0x73CE, 0x6B4D, 0x634C, 0x6B6D, 0x634C, 0x634C, 0x634C, 0x5B0B, 0x630B, 0x632B, 0x632B, 0x5B0B, 0x5B0B, 0x52CA, 0x52A9, 0x52CA, 0x5AEA, 0x5AEA, 0x62EB, 0x6B4C, 0x634C, 0x632C, 0x634C, 0x634C, 0x636C, 0x634C, 0x530B, 0x5B0B, 0x632B, 
        0x632C, 0x6B8D, 0x842F, 0x73CC, 0x6B69, 0x6329, 0x5AC9, 0x6AEA, 0x730A, 0x72EA, 0x72CA, 0x72EA, 0x7B2B, 0x72A9, 0x7289, 0x6AA9, 0x6AA9, 0x6AA8, 0x7BAD, 0x9491, 0x7C0D, 0x6328, 0x5AC8, 0xAD12, 0x94B1, 0x5B0A, 0x6B8D, 0x7BEE, 0x8450,
  0x7BAD, 0x7BAD, 0x7BCD, 0x7BCD, 0x7BAD, 0x6B4B, 0x7BCD, 0x7BAD, 0x7BCD, 0x7BCD, 0x7BCD, 0x7BAD, 0x7BAC, 0x8BEE, 0x8BED, 0x8BED, 0x8BEE, 0x8C0E, 0x8BED, 0x8C0D, 0x944F, 0x8C0E, 0x7BAC, 0x83CD, 0x83CD, 0x83CD, 0x8BCD, 0x8BCD, 0x83CD, 0x83CD, 0x83CD, 
        0x83CD, 0x83AC, 0x8BCD, 0x8BCD, 0x8BCD, 0x83AD, 0x83AC, 0x83CD, 0x83AC, 0x83AC, 0x83AC, 0x83AC, 0x83AC, 0x83AC, 0x83AC, 0x8BAD, 0x83AC, 0x83AC, 0x83AC, 0x83AC, 0x83CC, 0x83CD, 0x83CC, 0x7B8C, 0x7BCD, 0x7BAD, 0x83CD, 0x83CD, 0x83ED, 0x83CD, 
        0x83CD, 0x83ED, 0x8BED, 0x8BED, 0x8BED, 0x8BED, 0x8BCD, 0x7B8C, 0x83CD, 0x83ED, 0x8BEE, 0x8BED, 0x83EE, 0x83CD, 0x8BED, 0x8BCD, 0x8BED, 0x8BED, 0x8BCD, 0x83AC, 0x838C, 0x8BCD, 0x8BAC, 0x8BAC, 0x8BAC, 0x8BCC, 0x8BCD, 0x83AC, 0x83CD, 0x83CD, 
        0x8BCD, 0x8BED, 0x8BED, 0x8BED, 0x8BED, 0x7B8C, 0x8C0E, 0x8BEE, 0x8BEE, 0x8BEE, 0x8BEE, 0x8BED, 0x83CD, 0x8C0E, 0x8BEE, 0x8BEE, 0x8BED, 0x7BAC, 0x8BEE, 0x8C0E, 0x8BED, 0x8C0E, 0x8BED, 0x7B8C, 0x83CD, 0x83CD, 0x83CD, 0x83ED, 0x8C0E, 0x83CD, 
        0x7BAC, 0x83ED, 0x83EE, 0x83CD, 0x83CD, 0x83CD, 0x83CD, 0x940E, 0x8BED, 0x8BED, 0x8BED, 0x8C0E, 0x83CD, 0x8BCD, 0x8BCD, 0x8BED, 0x8C0E, 0x838C, 0x83AC, 0x83AC, 0x838C, 0x8BAC, 0x83AC, 0x7B8C, 0x8BED, 0x940E, 0x83CD, 0x7BAC, 0x7BAC, 0x83CD, 
        0x8BED, 0x83AC, 0x8BCD, 0x8BCC, 0x83CC, 0x83CC, 0x7BAC, 0x7BAD, 0x7B8C, 0x7B8C, 0x7B8C, 0x7B8C, 0x7B8C, 0x83AC, 0x8BED, 0x8BED, 0x8BCD, 0x83CD, 0x7BAC, 0x7BAD, 0x83AD, 0x83AD, 0x7BAD, 0x7B8C, 0x83CD, 0x83CD, 0x83CD, 0x7BAD, 0x7B8C, 0x83CD, 
        0x7BAC, 0x7BAC, 0x7BAD, 0x83CD, 0x736C, 0x738C, 0x7BAD, 0x738C, 0x738C, 0x6B6C, 0x6B8D, 0x6B8D, 0x6BAD, 0x6B6C, 0x634C, 0x6B6D, 0x6B6C, 0x632B, 0x632B, 0x6B6D, 0x6BAD, 0x638D, 0x636D, 0x6BAD, 0x636C, 0x6B8D, 0x6BAD, 0x6BAD, 0x73AD, 0x73AD, 
        0x73AE, 0x73AE, 0x73AD, 0x6BAD, 0x73AD, 0x73AD, 0x6BAD, 0x6B8D, 0x6B8D, 0x73AD, 0x73CE, 0x7BEE, 0x73AE, 0x73AE, 0x6BAD, 0x6BAD, 0x6BAD, 0x6BAD, 0x6B8D, 0x6B6D, 0x6B8D, 0x6B8D, 0x73AD, 0x73AD, 0x73AE, 0x7BCE, 0x73AD, 0x73AD, 0x738D, 0x6B6D, 
        0x738D, 0x738D, 0x738D, 0x73AD, 0x6B8D, 0x73AE, 0x73CE, 0x6BAE, 0x73CE, 0x73CE, 0x73EF, 0x73CE, 0x6B8D, 0x6B8D, 0x6B6D, 0x6B8D, 0x738D, 0x738D, 0x738D, 0x73AD, 0x6B8D, 0x73AD, 0x73AD, 0x738D, 0x6B6D, 0x738D, 0x73AE, 0x73AE, 0x6BAD, 0x73AE, 
        0x73CE, 0x73AE, 0x73AE, 0x73AD, 0x73CE, 0x73CE, 0x73AD, 0x73CE, 0x73CE, 0x6BAD, 0x6B8D, 0x6BAD, 0x73AD, 0x73AD, 0x73AE, 0x6BAE, 0x73CE, 0x73AE, 0x73AD, 0x6B6C, 0x738C, 0x6B6C, 0x6B6D, 0x738D, 0x73AD, 0x73AD, 0x73CD, 0x73CD, 0x738D, 0x6B6C, 
        0x6B6C, 0x73AE, 0x6BAD, 0x73AD, 0x83EE, 0x83EE, 0x7BEE, 0x7BED, 0x73AD, 0x6B8D, 0x738D, 0x73AD, 0x6B6C, 0x6B8C, 0x736C, 0x6B4C, 0x6B6C, 0x6BAD, 0x73AD, 0x6BAE, 0x6BAD, 0x6BAD, 0x738D, 0x624A, 0x7BAF, 0x73CD, 0x83EE, 0x7BEE, 0x7BCD, 0x7BED, 
        0x8C2E, 0x8C2F, 0x8C70, 0x8C4F, 0x8C0E, 0x8C4F, 0x944F, 0x946F, 0x9490, 0x840E, 0x840D, 0x632A, 0x4A88, 0x7BCD, 0x738C, 0x6B4C, 0x4247, 0x3A27, 0x4A88, 0x4A47, 0x4227, 0x4206, 0x4227, 0x31C5, 0x39C6, 0x4227, 0x4A47, 0x4A68, 0x4A88, 0x5B2B, 
        0x4A68, 0x632B, 0x632B, 0x6B6C, 0x840E, 0x8C6F, 0x8C70, 0x8C70, 0x844F, 0x9490, 0x9490, 0x8C70, 0x8CB1, 0x94B1, 0x8C90, 0x8C70, 0x8C90, 0x8C70, 0x8C90, 0x9490, 0x8C90, 0x94D1, 0x94D1, 0x94D2, 0x9D12, 0x9D12, 0x94D1, 0x8C90, 0x8C70, 0x844F, 
        0x842F, 0x7C0E, 0x7C0F, 0x7C2F, 0x8450, 0x8470, 0x7C2F, 0x73AD, 0x6BAD, 0x73CE, 0x6BAD, 0x6BAD, 0x636C, 0x5B2B, 0x5B0B, 0x5B0B, 0x5AEA, 0x52C9, 0x52CA, 0x634C, 0x634C, 0x5B4B, 0x5B4C, 0x5B4B, 0x52CA, 0x4A89, 0x52C9, 0x73AD, 0x840E, 0x7BEE, 
        0x7BEE, 0x844F, 0x8C70, 0x8C70, 0x9490, 0x9490, 0x8C4F, 0x9470, 0x9490, 0x9490, 0x94B1, 0x9490, 0x9491, 0x9470, 0x8450, 0x8C70, 0x8C70, 0x8C70, 0x8C70, 0x8C50, 0x9490, 0x9490, 0x8C4F, 0x9470, 0x8C70, 0x8C90, 0x8C90, 0x844F, 0x7C0E, 0x8C70, 
        0x94B1, 0x94B1, 0x8C4F, 0x9490, 0x946F, 0x944F, 0x9C6F, 0x942E, 0x942E, 0x942E, 0x942E, 0x940E, 0x8C0E, 0x940E, 0x8BED, 0x8C0E, 0x940E, 0x8C0D, 0x8C0D, 0x8C0D, 0x8C2E, 0x8C2E, 0x8C0D, 0xA4B1, 0x9470, 0x8C0D, 0x8C0D, 0x8BED, 0x8C2E,
  0x7BCD, 0x7BAD, 0x7BCD, 0x7BCD, 0x7BCD, 0x6B6C, 0x73AD, 0x73AD, 0x73AD, 0x7BAD, 0x7BCD, 0x7BAD, 0x7BAD, 0x8C0E, 0x8C0E, 0x8BED, 0x8BED, 0x8C0D, 0x8BED, 0x8C0D, 0x942E, 0x8C0E, 0x83CD, 0x8BCD, 0x83CD, 0x83CD, 0x83CD, 0x83CD, 0x83CD, 0x83CD, 0x83CD, 
        0x83CD, 0x7BAD, 0x83CD, 0x83CD, 0x8BCD, 0x83CD, 0x83AC, 0x83AD, 0x83AD, 0x83AC, 0x8BCC, 0x8BAC, 0x83CC, 0x83CC, 0x83AC, 0x8BCD, 0x83AC, 0x83AC, 0x83AC, 0x83AC, 0x8BCC, 0x8BCD, 0x83AC, 0x7B8C, 0x83AD, 0x83CD, 0x83CD, 0x83CD, 0x83CD, 0x83CD, 
        0x83CD, 0x8BED, 0x8BED, 0x8BCD, 0x8BCD, 0x8BED, 0x8BED, 0x83AD, 0x8BED, 0x83ED, 0x8BEE, 0x8BEE, 0x83ED, 0x83CD, 0x8BED, 0x8BED, 0x8BCD, 0x8BED, 0x8BED, 0x83CD, 0x838C, 0x8BAC, 0x8BAC, 0x8BAC, 0x8BAC, 0x8BAC, 0x8BCC, 0x838C, 0x7B8C, 0x83CD, 
        0x83CD, 0x8BED, 0x8BED, 0x8BED, 0x8BCD, 0x7B8C, 0x8C0E, 0x8BEE, 0x8BED, 0x8BEE, 0x8BEE, 0x83ED, 0x83EE, 0x8C0E, 0x8C0E, 0x8BEE, 0x8BEE, 0x7BAD, 0x8C0E, 0x8C0E, 0x8C0E, 0x8C0E, 0x8BEE, 0x7BAC, 0x83ED, 0x83ED, 0x83ED, 0x83ED, 0x8C0E, 0x83ED, 
        0x7BAC, 0x83EE, 0x83EE, 0x83EE, 0x83ED, 0x83CD, 0x83CD, 0x8C0E, 0x8C0E, 0x8C0E, 0x8BED, 0x8C0E, 0x83AC, 0x83CD, 0x83CD, 0x83CD, 0x83ED, 0x7B6B, 0x7B6B, 0x838C, 0x83AC, 0x83AC, 0x83AC, 0x83AC, 0x8C0E, 0x8BED, 0x7B8C, 0x7BAC, 0x83AC, 0x83CD, 
        0x8BCD, 0x83AC, 0x8BCD, 0x8BCD, 0x8BCD, 0x83CC, 0x83AD, 0x83AD, 0x7BAD, 0x7BAC, 0x7BAC, 0x7BAD, 0x736B, 0x7B8C, 0x8BED, 0x8BED, 0x8BED, 0x83CD, 0x7BAD, 0x83CD, 0x83AD, 0x83CD, 0x83AD, 0x7B8C, 0x83CD, 0x83CE, 0x83CD, 0x7BCD, 0x7B8C, 0x83AC, 
        0x83AC, 0x83AC, 0x83CD, 0x83CD, 0x736B, 0x738C, 0x7BAD, 0x7BAC, 0x738C, 0x6B8C, 0x6B8D, 0x738D, 0x73AD, 0x6B6C, 0x6B4B, 0x6B8C, 0x6B6C, 0x6B4C, 0x632B, 0x6B8C, 0x6BAD, 0x6BAD, 0x6B8D, 0x6B8D, 0x634C, 0x636D, 0x6BAD, 0x6BAD, 0x6BAD, 0x73AD, 
        0x73AD, 0x73AE, 0x73AD, 0x6BAD, 0x73AD, 0x6B8D, 0x6BAE, 0x6BAD, 0x73AD, 0x73CE, 0x73EE, 0x73EE, 0x73AE, 0x73AE, 0x6BAD, 0x6BAD, 0x6BAD, 0x6BAD, 0x6B8D, 0x6B6D, 0x6B8D, 0x6BAE, 0x73AE, 0x73AD, 0x73AD, 0x73AE, 0x73AE, 0x73AD, 0x73AD, 0x738D, 
        0x738D, 0x73AD, 0x738D, 0x73AD, 0x73CE, 0x73CE, 0x73CE, 0x73AE, 0x73CE, 0x73AE, 0x73CE, 0x73CE, 0x6B8D, 0x6B8D, 0x6B8D, 0x6B8D, 0x6B8D, 0x738D, 0x738D, 0x73AD, 0x6B8D, 0x738D, 0x738D, 0x6B8D, 0x6B6C, 0x738D, 0x73AE, 0x73AE, 0x6B8E, 0x73AE, 
        0x73CE, 0x73AE, 0x73AE, 0x73AD, 0x73AE, 0x73CE, 0x73AD, 0x73AE, 0x73AE, 0x6BAD, 0x6BAD, 0x6B8D, 0x738D, 0x73AE, 0x73AE, 0x73CE, 0x73CE, 0x73AE, 0x6B8D, 0x6B6C, 0x738C, 0x738D, 0x738D, 0x6B6C, 0x738D, 0x73AD, 0x73AD, 0x73AD, 0x73AD, 0x738D, 
        0x6B8D, 0x6BAE, 0x73AD, 0x73AD, 0x840E, 0x840E, 0x7BEE, 0x7BEE, 0x73AD, 0x738D, 0x73AD, 0x73AD, 0x6B6C, 0x6B6C, 0x738D, 0x6B8C, 0x6B8D, 0x73AE, 0x73CE, 0x6BAE, 0x6B8D, 0x6BAD, 0x7B4D, 0x91E9, 0x938E, 0x73CD, 0x83EE, 0x7BCD, 0x7BCD, 0x7BAD, 
        0x8C0E, 0x942F, 0x8C2F, 0x8C2F, 0x83EE, 0x942F, 0x8C4F, 0x9470, 0x944F, 0x8C2F, 0x8C0E, 0x736C, 0x6B4C, 0x9450, 0x9470, 0x9491, 0x83ED, 0x5AEA, 0x9470, 0x8C2F, 0x8C0E, 0x8C2F, 0x8C2F, 0x5AC9, 0x7BCD, 0x944F, 0x8C2F, 0x8C0E, 0x8C2F, 0x83EE, 
        0x6B2B, 0x83EE, 0x83EE, 0x83EE, 0x840E, 0x840E, 0x83EE, 0x83EE, 0x840E, 0x8C4F, 0x840E, 0x7BCD, 0x7BED, 0x840E, 0x842F, 0x73AD, 0x73AD, 0x7BEE, 0x7BCD, 0x8C2F, 0x8C2F, 0x7BCD, 0x840F, 0x8C50, 0x8C4F, 0x7BEE, 0x5AE9, 0x2963, 0x2964, 0x2944, 
        0x2123, 0x18E2, 0x18E2, 0x2123, 0x3A06, 0x52A8, 0x5B0A, 0x31C5, 0x2123, 0x2144, 0x2144, 0x1944, 0x1924, 0x2144, 0x10E2, 0x31E6, 0x31C5, 0x31E6, 0x3A27, 0x4268, 0x4A68, 0x4226, 0x4A68, 0x7C0F, 0x29A5, 0x29A5, 0x4228, 0x6B6C, 0x840E, 0x8C2F, 
        0x840E, 0x842F, 0x8C50, 0x844F, 0x8C4F, 0x8C70, 0x842F, 0x8C70, 0x8C70, 0x8C70, 0x9490, 0x8C50, 0x8C70, 0x8C4F, 0x842F, 0x8C50, 0x842F, 0x8C4F, 0x842F, 0x842F, 0x8C70, 0x8C6F, 0x8C4F, 0x8C6F, 0x8C4F, 0x8C70, 0x8C70, 0x840F, 0x7BEE, 0x842E, 
        0x8C4F, 0x8C70, 0x8C6F, 0x9490, 0x8C4F, 0x8C0E, 0x942E, 0x8C2E, 0x942E, 0x942E, 0x942E, 0x942E, 0x8C0E, 0x8C2E, 0x8C0D, 0x8C0E, 0x8C0D, 0x8C0E, 0x8C0E, 0x8C0E, 0x8C0E, 0x8BED, 0x8C0D, 0x8C2E, 0x8C0E, 0x942E, 0x8C2E, 0x8C0E, 0x8C0E,
  0x7BCD, 0x7BAD, 0x7BCD, 0x7BCD, 0x7BAD, 0x6B4B, 0x738D, 0x73AD, 0x73AD, 0x7BAD, 0x7BAD, 0x73AD, 0x736C, 0x8BED, 0x8C0E, 0x8BED, 0x8BED, 0x83ED, 0x83ED, 0x8BED, 0x8BED, 0x83ED, 0x83CD, 0x8BCD, 0x83CD, 0x83CD, 0x83CD, 0x83CD, 0x83CD, 0x83CD, 0x83CD, 
        0x83CD, 0x7BAD, 0x83CD, 0x8BED, 0x8BCD, 0x83CD, 0x83CD, 0x83CD, 0x7BAC, 0x838C, 0x8BAC, 0x8BCC, 0x8BCC, 0x8BCD, 0x8BCD, 0x8BCD, 0x83AC, 0x83AC, 0x83AC, 0x83CC, 0x8BCC, 0x8BCC, 0x83AC, 0x736B, 0x83CD, 0x83CD, 0x83CD, 0x83CD, 0x83ED, 0x83CD, 
        0x83CD, 0x8BED, 0x8BED, 0x8BCD, 0x8BCC, 0x93ED, 0x93ED, 0x83AC, 0x8BED, 0x8BEE, 0x8BEE, 0x8BEE, 0x8BED, 0x83CC, 0x8BED, 0x8BED, 0x8BCD, 0x8BED, 0x8BED, 0x8BCD, 0x83AC, 0x8BCD, 0x8BCD, 0x8BAC, 0x8BAC, 0x8BAC, 0x93CC, 0x838B, 0x7B8C, 0x83CD, 
        0x83CD, 0x8BED, 0x8BED, 0x8BED, 0x8BCD, 0x7B8C, 0x8C2E, 0x8C0E, 0x8BEE, 0x8BEE, 0x8C0E, 0x83ED, 0x83EE, 0x8C0E, 0x8C0E, 0x940E, 0x8C0E, 0x7BAD, 0x8C0E, 0x8C2E, 0x942E, 0x940E, 0x8C0E, 0x7BAD, 0x840E, 0x83ED, 0x840E, 0x83EE, 0x8BEE, 0x83CD, 
        0x7BCD, 0x8C0E, 0x8C0F, 0x840E, 0x83ED, 0x83CD, 0x7BAC, 0x8BEE, 0x8C0E, 0x8BED, 0x8BED, 0x8BED, 0x7B8C, 0x7B6B, 0x7B8C, 0x7B8C, 0x7B8C, 0x734B, 0x6B09, 0x734B, 0x7B4B, 0x732A, 0x6B2A, 0x7B8C, 0x83CD, 0x7B8C, 0x7B8B, 0x83AC, 0x83CD, 0x83CD, 
        0x83AC, 0x838C, 0x8BCD, 0x8BED, 0x8BED, 0x83CD, 0x7BAC, 0x83AD, 0x7BAD, 0x7BAC, 0x83AD, 0x7BAD, 0x734B, 0x83AC, 0x8BED, 0x8BEE, 0x8BEE, 0x8BED, 0x83CD, 0x83AD, 0x7B8C, 0x83AD, 0x83AD, 0x736C, 0x7BCD, 0x7BCD, 0x7BAD, 0x738C, 0x6B4B, 0x7BAC, 
        0x83CD, 0x83CD, 0x83CD, 0x83AD, 0x736B, 0x7BAD, 0x7BAD, 0x7BAC, 0x736C, 0x6B8C, 0x73AD, 0x73AD, 0x73AE, 0x6B6C, 0x6B4C, 0x6B6C, 0x6B6C, 0x6B6C, 0x632B, 0x6B6C, 0x6BAD, 0x6BAE, 0x73AE, 0x6B8D, 0x6B8D, 0x6BAD, 0x73AE, 0x73AE, 0x6BAE, 0x73AE, 
        0x73AE, 0x73CE, 0x73CE, 0x73AE, 0x73AE, 0x6BAE, 0x6BAE, 0x6B8D, 0x6BAD, 0x73CE, 0x7BEE, 0x7BEE, 0x73AE, 0x73AE, 0x6BCE, 0x6BAD, 0x6BAD, 0x73AE, 0x73AD, 0x6B8D, 0x73AE, 0x73AE, 0x73AE, 0x73AE, 0x738D, 0x73AE, 0x73AE, 0x73AE, 0x73AD, 0x738D, 
        0x73AD, 0x73AD, 0x738D, 0x738D, 0x7BCE, 0x73AD, 0x73CE, 0x73AD, 0x73CE, 0x73CE, 0x7BEE, 0x73CE, 0x6B6C, 0x738D, 0x6B8D, 0x6B8D, 0x6B6C, 0x6B8D, 0x738D, 0x73AD, 0x6B6D, 0x6B6C, 0x738D, 0x6B6C, 0x6B4C, 0x6B6C, 0x6BAD, 0x6BAE, 0x6B6D, 0x6BAE, 
        0x73CE, 0x73AE, 0x73AD, 0x73AD, 0x73AE, 0x73CE, 0x73CE, 0x6BAD, 0x73AE, 0x73CE, 0x73AD, 0x6B8D, 0x738D, 0x73AE, 0x73AD, 0x73AD, 0x73CE, 0x73AE, 0x6B8D, 0x6B6C, 0x738C, 0x738C, 0x6B6D, 0x6B4C, 0x6B8D, 0x738D, 0x738D, 0x738D, 0x738D, 0x738C, 
        0x6B8D, 0x6BAE, 0x6BAD, 0x73AD, 0x83EE, 0x83ED, 0x7BAD, 0x7BAD, 0x73AD, 0x73AD, 0x738D, 0x738D, 0x6B4C, 0x6B6C, 0x738D, 0x738D, 0x6B6D, 0x73AE, 0x73AE, 0x6BAD, 0x6B8D, 0x73AD, 0x836D, 0x99E8, 0x938E, 0x6B8D, 0x7BAD, 0x7BAD, 0x73AC, 0x736C, 
        0x8BAD, 0x8B6C, 0x4A07, 0x62EA, 0x7B8C, 0x83CD, 0x83EE, 0x83EE, 0x83ED, 0x83CD, 0x7BCD, 0x7BAD, 0x83ED, 0x840E, 0x840E, 0x83EE, 0x8C2E, 0x4A68, 0x738C, 0x840E, 0x83ED, 0x8C2F, 0x738C, 0x4A88, 0x83EE, 0x8C0E, 0x8C2F, 0x8C2F, 0x7BCD, 0x7BAD, 
        0x83CD, 0x83EE, 0x83ED, 0x83EE, 0x840E, 0x840E, 0x7BED, 0x7BCD, 0x9490, 0x9490, 0x7BCD, 0x83EE, 0x840E, 0x842F, 0xAD74, 0x7C0E, 0x73AC, 0x7BAD, 0x73AD, 0x7BED, 0x840E, 0x73CD, 0x7BEE, 0x840E, 0x7BEE, 0x7BCD, 0x73AC, 0x39C5, 0x39E5, 0x3A06, 
        0x39E6, 0x3185, 0x2103, 0x31C5, 0x4A47, 0x5B0A, 0x6B6B, 0x31C5, 0x2985, 0x31C6, 0x31C6, 0x29C6, 0x2985, 0x2185, 0x2124, 0x4A88, 0x4268, 0x4A89, 0x530A, 0x5B0B, 0x4A68, 0x39C5, 0x52A9, 0xAD95, 0x4A69, 0x31C6, 0x4268, 0x73AD, 0x7BCD, 0x73AD, 
        0x73AD, 0x73AD, 0x7BEE, 0x73CD, 0x73AD, 0x738C, 0x738C, 0x840E, 0x842F, 0x842F, 0x8C50, 0x7BEE, 0x73AD, 0x7BCD, 0x73CD, 0x7BEE, 0x6B8D, 0x73CD, 0x73CD, 0x6B8C, 0x7BCD, 0x7BEE, 0x842F, 0x9470, 0x840E, 0x7BEE, 0x7BEE, 0x7BCD, 0x7BCD, 0x73AD, 
        0x73CD, 0x73AD, 0x7BCD, 0x7BED, 0x73AC, 0x736B, 0x7B8C, 0x7B8C, 0x7BAC, 0x83CD, 0x83CD, 0x7BAC, 0x7BAC, 0x83ED, 0x7BAC, 0x7B8C, 0x7B8C, 0x83CD, 0x83CD, 0x7B8C, 0x738B, 0x736B, 0x7BAC, 0x8C0D, 0x83ED, 0x83CD, 0x7BAC, 0x83CD, 0x8BED,
  0x7BCD, 0x7BCD, 0x7BCD, 0x7BCD, 0x7BAD, 0x6B4B, 0x73AC, 0x738D, 0x7BAD, 0x7BCD, 0x7BAD, 0x7BAD, 0x6B2B, 0x83AC, 0x8BCD, 0x83CC, 0x7BAC, 0x83CD, 0x83CD, 0x8BED, 0x8BED, 0x83CD, 0x83AC, 0x83CD, 0x83CC, 0x8BCD, 0x8BCD, 0x8BCD, 0x8BCD, 0x83CD, 0x83CD, 
        0x83CD, 0x7BAC, 0x83ED, 0x8BED, 0x8BED, 0x83CD, 0x83CD, 0x83CD, 0x7B8C, 0x734B, 0x7B6B, 0x838B, 0x838C, 0x8BCC, 0x8BCC, 0x8BCC, 0x7B6B, 0x7B8B, 0x7B8C, 0x7B8B, 0x83AC, 0x7B8B, 0x7B8B, 0x736B, 0x7BAD, 0x7BAD, 0x83CD, 0x83CD, 0x83CD, 0x83CD, 
        0x83CD, 0x8BED, 0x93ED, 0x8BCD, 0x8BCD, 0x940D, 0x93ED, 0x838C, 0x83ED, 0x8C0E, 0x8C0E, 0x8C0E, 0x8BED, 0x83AC, 0x8BED, 0x8BED, 0x8BCC, 0x8BED, 0x8BED, 0x83AC, 0x838C, 0x8BCD, 0x8BCC, 0x8BCC, 0x8BAC, 0x8BAC, 0x8BAC, 0x7B4B, 0x7B6C, 0x83CD, 
        0x83CD, 0x8BCD, 0x83AC, 0x8BED, 0x83AD, 0x6B4A, 0x83ED, 0x83ED, 0x83CD, 0x83CD, 0x83CD, 0x7BAC, 0x7BAD, 0x83EE, 0x83ED, 0x8C0E, 0x83CD, 0x734B, 0x83CD, 0x8BED, 0x83ED, 0x83ED, 0x7BAD, 0x736B, 0x738C, 0x7BAC, 0x83CD, 0x83CD, 0x83CD, 0x738B, 
        0x7B8C, 0x83EE, 0x83CD, 0x7BAD, 0x7BAC, 0x736B, 0x6B4A, 0x7B8C, 0x83AC, 0x83AC, 0x7B8C, 0x7B8B, 0x734B, 0x734B, 0x7B6B, 0x7B6B, 0x736B, 0x6B4B, 0x6B0A, 0x62E9, 0x62C9, 0x62C8, 0x62E9, 0x6B2A, 0x6B4A, 0x7B6B, 0x7B6B, 0x7BAC, 0x7B8C, 0x7B8B, 
        0x736B, 0x734A, 0x838B, 0x83AC, 0x8BCC, 0x838C, 0x736B, 0x734B, 0x736B, 0x736B, 0x738C, 0x738B, 0x6B2A, 0x7B8C, 0x7BAC, 0x7B8C, 0x83CD, 0x7BAC, 0x7B6B, 0x736B, 0x736B, 0x736C, 0x736C, 0x6B4B, 0x6B6B, 0x6B6C, 0x6B6B, 0x632A, 0x62E9, 0x736B, 
        0x7B8C, 0x7B8C, 0x7B8B, 0x736B, 0x6B2B, 0x738C, 0x738C, 0x7B8C, 0x6B4B, 0x6B6C, 0x73AD, 0x738D, 0x738D, 0x6B6C, 0x6B4B, 0x6B4B, 0x6B4B, 0x6B4B, 0x632B, 0x6B6C, 0x6B8D, 0x73AD, 0x73AD, 0x738D, 0x73AD, 0x73AD, 0x73AD, 0x6BAD, 0x6B8D, 0x73AD, 
        0x73AD, 0x73AD, 0x73CD, 0x73AD, 0x73AD, 0x6B8D, 0x738D, 0x6B8D, 0x6B8C, 0x6B6C, 0x73AD, 0x73AD, 0x6B6C, 0x6B6C, 0x6B6C, 0x6B6C, 0x636C, 0x6B8D, 0x73AD, 0x73AD, 0x73AD, 0x73AD, 0x73AD, 0x73AD, 0x73AD, 0x7BAD, 0x7BAD, 0x7BCD, 0x7BAD, 0x73AD, 
        0x7BCD, 0x83CD, 0x7BCD, 0x7BCD, 0x7BEE, 0x7BCD, 0x7BCE, 0x73AD, 0x7BCD, 0x7BCD, 0x7BCD, 0x7BCD, 0x7BAD, 0x7BCD, 0x7BAD, 0x73AD, 0x73AD, 0x738D, 0x73AD, 0x7BAD, 0x738D, 0x736C, 0x736C, 0x736C, 0x6B4C, 0x6B6C, 0x73AD, 0x73AD, 0x6B8C, 0x73AD, 
        0x7C0E, 0x840E, 0x7BCD, 0x738D, 0x73AD, 0x7BCD, 0x73CE, 0x7BEE, 0x83EE, 0x840E, 0x83EE, 0x7BEE, 0x7BEE, 0x7BCD, 0x7BCD, 0x7BEE, 0x7BEE, 0x840E, 0x840E, 0x83EE, 0x840E, 0x8C0E, 0x8C0E, 0x7BCD, 0x7BCD, 0x7BED, 0x7BCD, 0x7BAD, 0x83EE, 0x83EE, 
        0x83EE, 0x840E, 0x7BEE, 0x7BED, 0x83ED, 0x83EE, 0x840E, 0x83EE, 0x7BCD, 0x83EE, 0x840E, 0x7BEE, 0x8C2F, 0x8C0E, 0x840E, 0x83EE, 0x7BAD, 0x73AD, 0x73AD, 0x7BCD, 0x7BEE, 0x83CE, 0x8BAD, 0x81E7, 0x9BAE, 0x8C4F, 0x840E, 0x83EE, 0x8C0E, 0x8C0E, 
        0xA4F2, 0x8C71, 0x2145, 0x5269, 0x940E, 0x83AD, 0x93AD, 0x9C0F, 0x8C2F, 0x944F, 0x8C0E, 0x83EE, 0x8C0E, 0x840E, 0x8C2E, 0x946F, 0x946F, 0x736C, 0x5AC9, 0x8C0E, 0x83EE, 0x8C2F, 0x5AC9, 0x738C, 0x840E, 0x944F, 0x8C4F, 0x83ED, 0x7BCD, 0x83EE, 
        0x840E, 0x840E, 0x8C2E, 0x8C4F, 0x9470, 0x8C2E, 0x840E, 0x842F, 0x9490, 0x9D12, 0x7BEE, 0x842E, 0x7BEE, 0xA532, 0xAD74, 0x7BCD, 0x83ED, 0x7BED, 0x83EE, 0x840E, 0x842E, 0x8C2F, 0x840E, 0x840E, 0x840E, 0x7BEE, 0x840D, 0x4A26, 0x4A26, 0x3A06, 
        0x3A06, 0x31C6, 0x2143, 0x4247, 0x4AA8, 0x632A, 0x6B8C, 0x3A26, 0x3A07, 0x3A28, 0x3A49, 0x3228, 0x29A6, 0x2185, 0x1924, 0x52EA, 0x4ACA, 0x52EA, 0x6B8D, 0x6BAD, 0x4A47, 0x3184, 0x4227, 0xB5B5, 0x52EA, 0x3A07, 0x5AEA, 0x6B8D, 0x8C6F, 0x6B4B, 
        0x5B0A, 0x7BCD, 0x7BCD, 0x7BEE, 0x842F, 0x842F, 0x840E, 0x840E, 0x842F, 0x8C4F, 0x8C70, 0x7C0E, 0x7BED, 0x842E, 0x8C4F, 0x842E, 0x7BEE, 0x840E, 0x842E, 0x840E, 0x840E, 0x840E, 0x8C2F, 0x8C4F, 0x8C4F, 0x8C2F, 0x8C70, 0x8C6F, 0x842E, 0x7BEE, 
        0x8C4F, 0x8C6F, 0x8C6F, 0x8C4F, 0x8C4F, 0x8C2E, 0x8C2E, 0x8C2E, 0x8C4F, 0x8C0E, 0x8C0E, 0x840E, 0x840E, 0x840E, 0x840D, 0x83ED, 0x8C0E, 0x8C0E, 0x8C0E, 0x83ED, 0x8C2E, 0x840E, 0x8C4F, 0x8C4F, 0x8C4F, 0x8C2E, 0x840E, 0x944F, 0x944F,
  0x738C, 0x738C, 0x7BAD, 0x7BAD, 0x738C, 0x630A, 0x6B4B, 0x736C, 0x736C, 0x738C, 0x738C, 0x738C, 0x6B2A, 0x738B, 0x7B6B, 0x6B4A, 0x736B, 0x7B8C, 0x7B8C, 0x7BAC, 0x83AC, 0x7B8C, 0x736B, 0x83AC, 0x7B8B, 0x7B8B, 0x7B8C, 0x7B6B, 0x7B8B, 0x7BAC, 0x7BAC, 
        0x736B, 0x734B, 0x83CD, 0x8BCD, 0x83CC, 0x7BAC, 0x7B8C, 0x7B8C, 0x736B, 0x734B, 0x734B, 0x732A, 0x734B, 0x7B6B, 0x7B8B, 0x7B8B, 0x734A, 0x734B, 0x734B, 0x734A, 0x7B6B, 0x736B, 0x736B, 0x738B, 0x736B, 0x6B4B, 0x738C, 0x7BAC, 0x7BAD, 0x7BAC, 
        0x736B, 0x83AC, 0x8BAC, 0x838B, 0x838C, 0x8BAC, 0x83AC, 0x7B4B, 0x7B8C, 0x7BAC, 0x7BAD, 0x7BCD, 0x83CD, 0x7BAC, 0x8BCC, 0x8BCD, 0x8BCC, 0x8BED, 0x8BED, 0x83AC, 0x83AC, 0x83AC, 0x7B8B, 0x7B8B, 0x7B6B, 0x7B4B, 0x836B, 0x7B4B, 0x736C, 0x736B, 
        0x734B, 0x7B8C, 0x738C, 0x7B8C, 0x7BAC, 0x738C, 0x83ED, 0x83ED, 0x83ED, 0x83ED, 0x8C0E, 0x8C0E, 0x7BCD, 0x8C0E, 0x840E, 0x83CD, 0x7BAD, 0x7BCD, 0x840D, 0x83CD, 0x83ED, 0x8C0E, 0x83ED, 0x7BAD, 0x7BAD, 0x7BCD, 0x83ED, 0x840D, 0x840D, 0x840E, 
        0x83CD, 0x83ED, 0x83ED, 0x7BCD, 0x83ED, 0x8C0E, 0x8C0E, 0x8C0E, 0x83CD, 0x83ED, 0x83CD, 0x83CD, 0x8C0E, 0x8C0E, 0x83ED, 0x7BCD, 0x83ED, 0x8C2E, 0x83EE, 0x736C, 0x738C, 0x7BAC, 0x7BAC, 0x7BAD, 0x840E, 0x944E, 0x8C0D, 0x840E, 0x8C0E, 0x8C0E, 
        0x83ED, 0x7BCD, 0x8C0E, 0x83ED, 0x83CD, 0x83ED, 0x83CD, 0x8C0E, 0x8C2E, 0x8C0E, 0x83ED, 0x840E, 0x83EE, 0x83EE, 0x83ED, 0x83CD, 0x840D, 0x944F, 0x944F, 0x944F, 0x8C2E, 0x83ED, 0x840E, 0x840E, 0x83ED, 0x7BCD, 0x7BAD, 0x7BCD, 0x83ED, 0x840D, 
        0x840E, 0x9490, 0x840E, 0x83ED, 0x83ED, 0x7BCD, 0x7BED, 0x83EE, 0x7BCD, 0x7BCD, 0x83EE, 0x7BCD, 0x83EE, 0x840F, 0x8C2F, 0x840E, 0x7BCD, 0x6B6C, 0x73AD, 0x73AD, 0x842F, 0x8C70, 0x840F, 0x842F, 0x7BEE, 0x83EE, 0x840E, 0x840F, 0x7BCD, 0x7BCD, 
        0x840F, 0x8C2F, 0x8C2F, 0x8C2F, 0x8C2F, 0x842F, 0x8C4F, 0x840E, 0x83EE, 0x83EE, 0x7BEE, 0x840E, 0x8C2F, 0x7BEE, 0x738D, 0x7BEE, 0x7BEE, 0x840E, 0x8C70, 0x842F, 0x842E, 0x8C4F, 0x8C4F, 0x8C4F, 0x83EE, 0x842F, 0x9470, 0x8C2F, 0x9470, 0x840E, 
        0x8C2F, 0x9C90, 0x9490, 0x8C0E, 0x7BCD, 0x840E, 0x840E, 0x7BAD, 0x7BAD, 0x7BAD, 0x7BCD, 0x7BCD, 0x83EE, 0x7BAD, 0x7BCD, 0x8C50, 0x8C4F, 0x8C4F, 0x7BCD, 0x840E, 0x8C4F, 0x8C2F, 0x738D, 0x6B6C, 0x6B6C, 0x738D, 0x73AD, 0x840E, 0x8C2F, 0x7BEE, 
        0x7BCD, 0x842F, 0x840E, 0x840E, 0x738D, 0x738C, 0x6B4B, 0x738C, 0x738D, 0x7BCD, 0x7BAD, 0x6B8C, 0x738C, 0x738C, 0x6B6C, 0x6B8C, 0x6B6C, 0x6B8C, 0x73AD, 0x6B6C, 0x738D, 0x7BCD, 0x7BCD, 0x6B4C, 0x632B, 0x6B4C, 0x6B6C, 0x632B, 0x632B, 0x632B, 
        0x6B4C, 0x738C, 0x738D, 0x6B6C, 0x73AD, 0x7BAD, 0x7BCD, 0x73AD, 0x6B6C, 0x6B8C, 0x73AD, 0x6B6C, 0x7BCD, 0x7BCD, 0x7BAD, 0x73AD, 0x7BAD, 0x73AD, 0x6B6C, 0x6B6C, 0x6B4C, 0x39E6, 0x39C6, 0x6966, 0x830C, 0x73AD, 0x738C, 0x6B6C, 0x6B4C, 0x6B6C, 
        0x8471, 0x4AEC, 0x10C3, 0x2986, 0x7BEF, 0x62A9, 0x6289, 0x6AA9, 0x6B4C, 0x738C, 0x6B2B, 0x632B, 0x738C, 0x6B6C, 0x738C, 0x73AD, 0x738C, 0x6B6C, 0x4A88, 0x6B6C, 0x6B4B, 0x6B4C, 0x4227, 0x6B8C, 0x73AD, 0x7BEE, 0x7BCD, 0x630B, 0x6B4C, 0x6B6C, 
        0x73AD, 0x6B8C, 0x630A, 0x632B, 0x736C, 0x5268, 0x4227, 0x6B4C, 0x6B6C, 0xA533, 0x7C0E, 0x4A68, 0x4227, 0xAD74, 0x6B8C, 0x5AEA, 0x630A, 0x5AC9, 0x52A9, 0x5288, 0x4A68, 0x4A48, 0x4A27, 0x4207, 0x4A68, 0x632A, 0x8C2E, 0x4206, 0x4A46, 0x4A47, 
        0x39E5, 0x2944, 0x2943, 0x4AA8, 0x4A68, 0x5AC9, 0x634B, 0x4267, 0x4269, 0x4A8A, 0x42AA, 0x3A69, 0x29C6, 0x2165, 0x2145, 0x5B4C, 0x530B, 0x530A, 0x6BAD, 0x7C2F, 0x52A8, 0x3184, 0x41E6, 0xB5B6, 0x632B, 0x4247, 0x634B, 0x634C, 0x6B6C, 0x52C9, 
        0x5AEA, 0x630B, 0x5AEA, 0x5AEA, 0x632B, 0x6B6C, 0x6B6C, 0x6B6B, 0x632B, 0x632B, 0x6B4B, 0x5B0A, 0x634B, 0x634B, 0x634B, 0x632B, 0x5AEA, 0x5B0A, 0x5B0A, 0x632B, 0x632B, 0x5B0A, 0x630B, 0x5B0A, 0x5B0A, 0x5B0A, 0x634B, 0x634B, 0x5B0A, 0x52C9, 
        0x630A, 0x5B0A, 0x5B0A, 0x5B0A, 0x630A, 0x630A, 0x5AEA, 0x5B0A, 0x630A, 0x62EA, 0x5AEA, 0x5AC9, 0x5AEA, 0x62EA, 0x5AE9, 0x5AC9, 0x630A, 0x630A, 0x5B0A, 0x5AEA, 0x632B, 0x630A, 0x632B, 0x5B0A, 0x5B0A, 0x5AEA, 0x5AEA, 0x630A, 0x630A,
  0x7BCD, 0x7BAD, 0x7BED, 0x83EE, 0x7BCD, 0x73AD, 0x7BCD, 0x7BCD, 0x7BED, 0x83ED, 0x840E, 0x83EE, 0x7BCD, 0x7BCD, 0x7BCD, 0x840E, 0x840E, 0x7BCD, 0x83ED, 0x83ED, 0x83ED, 0x7BCD, 0x7BAC, 0x7BCD, 0x7BCD, 0x7BAC, 0x738C, 0x7BAD, 0x7BCD, 0x7BCD, 0x83EE, 
        0x7BCD, 0x83EE, 0x8C0E, 0x83EE, 0x840E, 0x840E, 0x8C2E, 0x8C2E, 0x7BCD, 0x7BCD, 0x7BAD, 0x7BCD, 0x7BCD, 0x7BAC, 0x7BAC, 0x83ED, 0x83ED, 0x7BAC, 0x83ED, 0x7BCD, 0x7BAD, 0x840E, 0x8C2E, 0x8C2F, 0x8C2E, 0x7BED, 0x83ED, 0x8C2E, 0x8C4F, 0x944F, 
        0x840E, 0x738C, 0x8C0E, 0x946F, 0x946F, 0x9C90, 0x946F, 0x944F, 0x8C0E, 0x8C2F, 0x842F, 0x842F, 0x8C4F, 0x8C4F, 0x8C4F, 0x8C6F, 0x83EE, 0x840E, 0x842E, 0x7BAD, 0x7BCD, 0x840E, 0x7BED, 0x6B8C, 0x7BCD, 0x6B8C, 0x6B4C, 0x736C, 0x738C, 0x738C, 
        0x7BAD, 0x7BAD, 0x73AD, 0x7BCD, 0x7BAD, 0x738C, 0x738C, 0x738C, 0x738C, 0x738C, 0x7BEE, 0x842F, 0x6B8C, 0x73AD, 0x7BEE, 0x6B6C, 0x6B4B, 0x7BCD, 0x840F, 0x738C, 0x736C, 0x738C, 0x738D, 0x73AD, 0x7BCD, 0x73AD, 0x6B6C, 0x6B6C, 0x738C, 0x7BCD, 
        0x632B, 0x5AEA, 0x634B, 0x630A, 0x632B, 0x73AD, 0x73AD, 0x6B6C, 0x5B0A, 0x632B, 0x632B, 0x630B, 0x6B4C, 0x632B, 0x632B, 0x5AEA, 0x5AEA, 0x736C, 0x6B4C, 0x5AEA, 0x630A, 0x634B, 0x630A, 0x5AEA, 0x6B8C, 0x738C, 0x630A, 0x5AC9, 0x5AEA, 0x630A, 
        0x630B, 0x5AEA, 0x5B0B, 0x5AEA, 0x52C9, 0x52A9, 0x52A9, 0x5AEA, 0x630B, 0x5AEA, 0x52A9, 0x52A9, 0x5AC9, 0x5ACA, 0x5ACA, 0x5AA9, 0x52A9, 0x5AEA, 0x5B0A, 0x52C9, 0x52A9, 0x4A68, 0x52A9, 0x5AC9, 0x5289, 0x4A89, 0x4A68, 0x4A68, 0x52C9, 0x52A9, 
        0x4A88, 0x52A9, 0x4A68, 0x4A68, 0x4A68, 0x4A88, 0x4A68, 0x4A48, 0x4A68, 0x4227, 0x4227, 0x4A68, 0x4A68, 0x4A68, 0x4A68, 0x4A68, 0x4A48, 0x31C6, 0x4227, 0x4248, 0x4A89, 0x52A9, 0x4A88, 0x4A89, 0x4A69, 0x4A68, 0x4A68, 0x5289, 0x4248, 0x4247, 
        0x4A68, 0x4A89, 0x4A68, 0x4A68, 0x4A89, 0x4A89, 0x4A68, 0x4268, 0x4A68, 0x4A88, 0x4A48, 0x4247, 0x4A68, 0x4248, 0x4227, 0x4268, 0x4A68, 0x4247, 0x4268, 0x4247, 0x4247, 0x4A68, 0x4A68, 0x4268, 0x4247, 0x4268, 0x4268, 0x4247, 0x4268, 0x4227, 
        0x4247, 0x4247, 0x4227, 0x3A06, 0x4206, 0x4227, 0x3A07, 0x39E6, 0x3A07, 0x4227, 0x4227, 0x39E6, 0x39E6, 0x39E6, 0x4227, 0x4227, 0x4227, 0x4247, 0x4227, 0x4247, 0x4227, 0x3A27, 0x39E6, 0x39E6, 0x39E7, 0x39E6, 0x4207, 0x4227, 0x4207, 0x4227, 
        0x4227, 0x4247, 0x4A47, 0x4247, 0x4227, 0x4227, 0x3A06, 0x4227, 0x4227, 0x4248, 0x4A68, 0x4248, 0x4227, 0x4227, 0x4A48, 0x4247, 0x4A48, 0x4A88, 0x4A47, 0x4247, 0x4A47, 0x4A68, 0x4A48, 0x4A47, 0x4247, 0x4A68, 0x4A48, 0x4227, 0x4227, 0x4227, 
        0x4227, 0x4247, 0x4247, 0x4A68, 0x4A48, 0x4A68, 0x4A68, 0x4A88, 0x4A88, 0x4A88, 0x4A68, 0x4AA9, 0x4A88, 0x4A68, 0x4A88, 0x4A88, 0x4A68, 0x4206, 0x4A67, 0x5288, 0x4A68, 0x2965, 0x0882, 0x4105, 0x6AAA, 0x62A9, 0x5AA9, 0x62EA, 0x5AA9, 0x4A26, 
        0x5289, 0x1924, 0x10A3, 0x10E3, 0x31A6, 0x3144, 0x3965, 0x3164, 0x4A07, 0x5AEA, 0x52C9, 0x5B0A, 0x52A9, 0x39C6, 0x4207, 0x3164, 0x2143, 0x2944, 0x3A07, 0x4A47, 0x5288, 0x31C6, 0x4248, 0x4A89, 0x31C5, 0x52C9, 0x31A5, 0x3185, 0x4A68, 0x5B0B, 
        0x39E6, 0x2964, 0x3143, 0x5246, 0x41A5, 0x2902, 0x1081, 0x18C2, 0x31E6, 0x8450, 0x9D13, 0x0880, 0x5269, 0xAD74, 0x20E2, 0x2944, 0x31A5, 0x630B, 0x4206, 0x2903, 0x20E3, 0x1041, 0x18A2, 0x1061, 0x2923, 0x4A47, 0x630A, 0x39A5, 0x39C5, 0x39C5, 
        0x3164, 0x3164, 0x2123, 0x5AEA, 0x4207, 0x52A8, 0x5B0A, 0x4268, 0x4227, 0x41E6, 0x52EB, 0x42AA, 0x29A6, 0x1925, 0x10E3, 0x634C, 0x6BCE, 0x6B8D, 0x7C2F, 0x8470, 0x6B8C, 0x4A67, 0x52A9, 0xB5B5, 0x73CD, 0x4A88, 0x6B8C, 0x6B8C, 0x6B8C, 0x634C, 
        0x7BEE, 0x634B, 0x6B6C, 0x6B4C, 0x6B6C, 0x6B2B, 0x6B8C, 0x6B6C, 0x6B4B, 0x632B, 0x5B0A, 0x634B, 0x6B6C, 0x632A, 0x630A, 0x632B, 0x632B, 0x632B, 0x634B, 0x6B6C, 0x6B4B, 0x630B, 0x738C, 0x840E, 0x7BCD, 0x736C, 0x7BAD, 0x7BCD, 0x7BCD, 0x738C, 
        0x6B8C, 0x73AD, 0x7BCD, 0x73AD, 0x738C, 0x736C, 0x6B4B, 0x6B6C, 0x6B4B, 0x6B2B, 0x630A, 0x6B6C, 0x6B6C, 0x736C, 0x6B6B, 0x6B6B, 0x6B4B, 0x6B6C, 0x738C, 0x632B, 0x6B4B, 0x6B4B, 0x6B6C, 0x6B4B, 0x632B, 0x634B, 0x632B, 0x634B, 0x634B,
  0x5B2B, 0x5AEA, 0x5B0B, 0x634C, 0x634C, 0x632B, 0x5B0B, 0x5B2B, 0x5B0B, 0x5AEA, 0x5B0A, 0x52EA, 0x52CA, 0x5AEA, 0x5AEA, 0x5B0A, 0x5AEA, 0x52A9, 0x4AA9, 0x4AA9, 0x52CA, 0x52A9, 0x4AA9, 0x52A9, 0x52C9, 0x52EA, 0x52EA, 0x52CA, 0x5ACA, 0x5ACA, 0x52EA, 
        0x4AA9, 0x52CA, 0x52A9, 0x52A9, 0x4A89, 0x4A89, 0x52C9, 0x52A9, 0x4A88, 0x4248, 0x4247, 0x4248, 0x4247, 0x3A27, 0x3A06, 0x4227, 0x4227, 0x3A07, 0x4227, 0x4227, 0x3A07, 0x4227, 0x4227, 0x4247, 0x4248, 0x4227, 0x39E6, 0x3A07, 0x3A07, 0x3A27, 
        0x3A07, 0x31C6, 0x3A07, 0x4227, 0x3A07, 0x4227, 0x3A06, 0x3A27, 0x3A06, 0x39E6, 0x39E7, 0x3A07, 0x3A27, 0x4227, 0x3A27, 0x3A27, 0x31C6, 0x31E6, 0x39E6, 0x31C6, 0x31E6, 0x3A06, 0x39E6, 0x31A5, 0x39E6, 0x31C6, 0x31C5, 0x31C6, 0x31C6, 0x31E6, 
        0x39E6, 0x31C5, 0x31C5, 0x31A5, 0x31A5, 0x31A5, 0x29A5, 0x3185, 0x31A5, 0x29A5, 0x29A5, 0x31A6, 0x29A5, 0x31A5, 0x31C5, 0x31C5, 0x3A06, 0x3A06, 0x39C6, 0x2985, 0x2985, 0x3185, 0x31A5, 0x31A5, 0x29A5, 0x29A5, 0x31A5, 0x39C6, 0x31C5, 0x31A5, 
        0x31A5, 0x31A5, 0x31C5, 0x31C5, 0x31A5, 0x31A5, 0x31A5, 0x3A07, 0x3A06, 0x31E6, 0x3A06, 0x31E6, 0x39E6, 0x31C6, 0x31C6, 0x4207, 0x3A06, 0x39E6, 0x39E6, 0x39E6, 0x31C6, 0x39E6, 0x3A06, 0x39C6, 0x31C5, 0x31C6, 0x39E6, 0x3A07, 0x3A07, 0x39E6, 
        0x39E6, 0x4227, 0x3A07, 0x4227, 0x4227, 0x3A07, 0x4227, 0x3A06, 0x4207, 0x39E6, 0x39E6, 0x4227, 0x4227, 0x4247, 0x4227, 0x4A68, 0x4A48, 0x4A68, 0x4247, 0x4227, 0x4248, 0x5289, 0x4A68, 0x4A68, 0x4A89, 0x4A89, 0x4A68, 0x4A68, 0x4A88, 0x4A88, 
        0x52A9, 0x4227, 0x4A48, 0x4A68, 0x4A68, 0x4A68, 0x52A9, 0x4A88, 0x4A48, 0x4A89, 0x4A88, 0x52A9, 0x52A9, 0x52A9, 0x52A9, 0x52A9, 0x52A9, 0x4A88, 0x4A68, 0x52A9, 0x52C9, 0x5AEA, 0x5ACA, 0x5AEA, 0x5AEA, 0x630A, 0x630A, 0x630A, 0x5AEA, 0x632B, 
        0x6B4B, 0x6B4B, 0x632B, 0x6B6C, 0x6B4B, 0x738C, 0x6B6C, 0x630A, 0x630A, 0x630A, 0x62EA, 0x6B2B, 0x6B2B, 0x736C, 0x6B4C, 0x6B6C, 0x632B, 0x630A, 0x5AEA, 0x5ACA, 0x630A, 0x6B4B, 0x632B, 0x632B, 0x6B6C, 0x6B4C, 0x6B6C, 0x7BCD, 0x736C, 0x6B4B, 
        0x6B2B, 0x6B4B, 0x6B2B, 0x6B6C, 0x6B6C, 0x736C, 0x6B4B, 0x738C, 0x840E, 0x7BEE, 0x7BEE, 0x6B6C, 0x736C, 0x736C, 0x83EE, 0x7B8C, 0x736C, 0x738D, 0x738D, 0x6B6C, 0x6B4C, 0x5AEA, 0x630B, 0x6B4C, 0x6B4B, 0x6B2B, 0x83CE, 0x7BCD, 0x738C, 0x83CE, 
        0x83EE, 0x83CE, 0x83EE, 0x7BAD, 0x736C, 0x7B8C, 0x736B, 0x6B4B, 0x738C, 0x7BCD, 0x7BEE, 0x83EE, 0x6B6C, 0x738C, 0x8C2F, 0x840E, 0x7BCD, 0x83EE, 0x8C2E, 0x840E, 0x840E, 0x738C, 0x738C, 0x7BCD, 0x8C0E, 0x944F, 0x7BCD, 0x738D, 0x736C, 0x73AD, 
        0x7BCD, 0x7BAD, 0x7BAD, 0x7BCE, 0x7BAD, 0x7BCD, 0x8C2F, 0x840E, 0x8C0E, 0x83ED, 0x7BED, 0x8C2E, 0x7BCD, 0x7BCD, 0x7BCD, 0x83EE, 0x7BCD, 0x5227, 0x5247, 0x6B4B, 0x7BEE, 0x634C, 0x2924, 0x3925, 0x62EB, 0x8B8D, 0x836C, 0x83ED, 0x62A8, 0x72E9, 
        0x5268, 0x08A3, 0x08A3, 0x10C3, 0x738D, 0x39A5, 0x2903, 0x2944, 0x5A89, 0x5AA9, 0x73AD, 0x4A68, 0x736C, 0x5248, 0x2944, 0x2104, 0x2104, 0x18C2, 0x31A6, 0x4248, 0x6B2B, 0x3A06, 0x738D, 0x6B4B, 0x2965, 0x73CF, 0x8494, 0x8CD4, 0x632C, 0x5ACA, 
        0x3185, 0x3143, 0x51E5, 0x72C8, 0x8C0F, 0x9452, 0x52AB, 0x10A2, 0x2103, 0x2965, 0xAD75, 0x4A69, 0x9CB2, 0x7BEE, 0x2944, 0x31C6, 0x5ACA, 0x83EE, 0x6B08, 0x41A4, 0x1081, 0x2944, 0x18A2, 0x1081, 0x2123, 0x2924, 0x52AA, 0x52EB, 0x29A5, 0x10A2, 
        0x10A2, 0x2103, 0x4228, 0x632B, 0x18C2, 0x18C2, 0x62EA, 0x4247, 0x3144, 0x5247, 0x5AEA, 0x42AA, 0x2165, 0x2104, 0x0882, 0x5B0B, 0x6B8D, 0x6B6C, 0x7C0E, 0x8C91, 0x842F, 0x5289, 0x5AA9, 0xA554, 0x8C91, 0x5ACA, 0x7BEE, 0x7C0E, 0xA533, 0x8C70, 
        0x8C70, 0x7BEE, 0x7BCE, 0x840F, 0x842F, 0x840E, 0x9470, 0x8C4F, 0x83ED, 0x83ED, 0x83EE, 0x8C2F, 0x9470, 0x83ED, 0x73AC, 0x840E, 0x8C4F, 0x8C2F, 0x840E, 0x8C2E, 0x840E, 0x7BCD, 0x840E, 0x8C4F, 0x8C4F, 0x840E, 0x8C2E, 0x8C4F, 0x9CD0, 0x94B0, 
        0x8C2F, 0x8C2F, 0x944F, 0x8C4E, 0x946F, 0x8C0E, 0x8C0E, 0x83ED, 0x8C0E, 0x840D, 0x7BAC, 0x83ED, 0x83ED, 0x840E, 0x840E, 0x8C2E, 0x7BAC, 0x73AC, 0x8C4F, 0x83ED, 0x7BCC, 0x7BCC, 0x840D, 0x8C2E, 0x840E, 0x7BED, 0x83EE, 0x83ED, 0x840E,
  0x2124, 0x2144, 0x2124, 0x2103, 0x2124, 0x2144, 0x2124, 0x2144, 0x2144, 0x2164, 0x2144, 0x2124, 0x2144, 0x2144, 0x2144, 0x2964, 0x2964, 0x2144, 0x2164, 0x2965, 0x2164, 0x2965, 0x2965, 0x29A5, 0x2985, 0x29A5, 0x29C5, 0x31C6, 0x31C6, 0x31A5, 0x2985, 
        0x31A6, 0x31C6, 0x29A5, 0x31E6, 0x3A07, 0x3A07, 0x3A27, 0x3A27, 0x31E6, 0x3A07, 0x3A07, 0x31A5, 0x31C6, 0x39E6, 0x3A07, 0x3A27, 0x3A27, 0x4227, 0x4248, 0x4248, 0x4268, 0x4227, 0x4A69, 0x4A68, 0x4A89, 0x4A89, 0x4248, 0x4A48, 0x4248, 0x3A27, 
        0x4248, 0x4227, 0x4227, 0x4227, 0x4247, 0x4A68, 0x4A68, 0x3A27, 0x4227, 0x4227, 0x4A88, 0x4A88, 0x4A48, 0x4A68, 0x4A89, 0x4A89, 0x4A89, 0x4A68, 0x4A68, 0x4A68, 0x52CA, 0x4A68, 0x4A89, 0x4A88, 0x4A88, 0x4A88, 0x52A9, 0x630B, 0x632B, 0x52CA, 
        0x52C9, 0x52C9, 0x5289, 0x4A88, 0x52A9, 0x52A9, 0x5289, 0x52A9, 0x5AEA, 0x5B0B, 0x5AEA, 0x5AEA, 0x5B0B, 0x630A, 0x630A, 0x632B, 0x73AD, 0x738C, 0x6B4B, 0x630A, 0x62EA, 0x632B, 0x738C, 0x5B0A, 0x5AEA, 0x5AEA, 0x630A, 0x7BAD, 0x7BAD, 0x6B4B, 
        0x6B6B, 0x738C, 0x738C, 0x736B, 0x7BAC, 0x738C, 0x6B6B, 0x73AD, 0x73AD, 0x6B6C, 0x6B4B, 0x632B, 0x6B6C, 0x6B4B, 0x6B4B, 0x738C, 0x6B6C, 0x6B6C, 0x6B4B, 0x6B4B, 0x6B4B, 0x6B6B, 0x736C, 0x6B4B, 0x6B2B, 0x73AC, 0x7BCD, 0x7BAD, 0x73AC, 0x7BAD, 
        0x736C, 0x738C, 0x7BAD, 0x7BAD, 0x73AC, 0x7BCD, 0x7BEE, 0x6B6C, 0x738C, 0x738C, 0x738C, 0x7BCD, 0x738D, 0x738C, 0x6B6C, 0x7BAC, 0x7BAD, 0x7BCD, 0x7BAD, 0x738C, 0x73AC, 0x7BCD, 0x7BAD, 0x736C, 0x6B6C, 0x738D, 0x738D, 0x738C, 0x7BAD, 0x738C, 
        0x8C2F, 0x738C, 0x6B6C, 0x738D, 0x7BCD, 0x7BCD, 0x73AD, 0x738C, 0x73AD, 0x7BEE, 0x73AD, 0x7BEE, 0x73AD, 0x7BCD, 0x7BCD, 0x73AD, 0x6B8C, 0x632A, 0x630A, 0x83EE, 0x8C2E, 0x8C4F, 0x840E, 0x83EE, 0x7BEE, 0x840E, 0x840E, 0x944F, 0x7BED, 0x83ED, 
        0x8C2F, 0x946F, 0x840E, 0x8C4F, 0x8C2F, 0x8C2F, 0x9490, 0x840E, 0x83EE, 0x8C0E, 0x83CD, 0x83EE, 0x8C0E, 0x946F, 0x944F, 0x944F, 0x83EE, 0x7BCD, 0x7BCD, 0x738C, 0x7BAD, 0x83CD, 0x83EE, 0x8C4F, 0x842F, 0x8C2F, 0x840E, 0x8C2E, 0x83EE, 0x83ED, 
        0x83ED, 0x83ED, 0x738C, 0x7BCD, 0x840E, 0x8C4F, 0x738C, 0x7BCD, 0x9C90, 0x9470, 0x9470, 0x8C2F, 0x8C2E, 0x7BCD, 0x944E, 0x944F, 0x944F, 0x944F, 0x8C2F, 0x8C2F, 0x9470, 0x7BCD, 0x73AD, 0x83EE, 0x83EE, 0x840E, 0x944F, 0x9CB1, 0x9470, 0x8C2F, 
        0x8C0E, 0x8C2F, 0x8C2F, 0x83EE, 0x83CD, 0x940E, 0x8C0D, 0x83CD, 0x7BCD, 0x840E, 0x840E, 0x840E, 0x7BCD, 0x83CD, 0x83ED, 0x83ED, 0x8C2F, 0x8C2E, 0x9C90, 0x8C2E, 0x946F, 0x8C0E, 0x8C0E, 0x8BED, 0x942F, 0x944F, 0x840E, 0x83EE, 0x7BAD, 0x7BCD, 
        0x8C2F, 0x840E, 0x83EE, 0x83ED, 0x7BCD, 0x83EE, 0x944F, 0x946F, 0x9C8F, 0x944E, 0x8C2E, 0x8C2E, 0x8C0D, 0x83ED, 0x9470, 0x9CB0, 0x942F, 0x8410, 0x4AAB, 0x7BCF, 0x8C50, 0x634C, 0x31C7, 0x3187, 0x630C, 0xB574, 0x8C2F, 0x632C, 0x4A89, 0x634D, 
        0x5AEC, 0x4A8A, 0x4AAA, 0x4A8A, 0x7BCE, 0x5AEB, 0x52A9, 0x738D, 0x5AEA, 0x4248, 0x5B0B, 0x4A89, 0x5B2B, 0x3207, 0x29A7, 0x21A7, 0x3A49, 0x530B, 0x1904, 0x18E4, 0x3A07, 0x3A27, 0x6B6C, 0x2985, 0x3A09, 0x7CB5, 0x8537, 0x8559, 0x8537, 0x3A49, 
        0x18C2, 0x41C5, 0x62A7, 0x7308, 0x9450, 0x9D37, 0xADD9, 0x2986, 0x0861, 0x0020, 0x73AE, 0xBE17, 0xCE78, 0x5ACA, 0x2145, 0x52EB, 0x8C92, 0x94F2, 0xAD52, 0x7B6B, 0x2103, 0x31C6, 0x3124, 0x2103, 0x2144, 0x2124, 0x4A89, 0x638E, 0x52CB, 0x39E7, 
        0x4228, 0x4A69, 0x634C, 0x840F, 0x5B0B, 0x6B6D, 0x844F, 0x8C50, 0x8C30, 0xA4B1, 0x8C70, 0x8450, 0x842F, 0x8C0E, 0x83CD, 0x9C6F, 0xA4D0, 0x9C6F, 0x83AC, 0x7B8C, 0x6AEB, 0x5AA9, 0x5AA9, 0x4A48, 0x4A48, 0x9D13, 0xC658, 0xADB5, 0xB595, 0xB5B5, 
        0x842F, 0x83EE, 0x7BEE, 0x842F, 0x7BEE, 0x7BEE, 0x8C2F, 0x946F, 0x7BCD, 0x946F, 0x8C0E, 0x840E, 0x9490, 0x8C2E, 0x7BAC, 0x83EE, 0x8C2F, 0x8C2F, 0x7BCD, 0x7BCC, 0x83ED, 0x83ED, 0x83ED, 0x842E, 0x8C4F, 0x840E, 0x7BED, 0x842E, 0x8C4E, 0x948F, 
        0x840E, 0x840E, 0x840D, 0x8C2E, 0x944F, 0x8C2E, 0x942E, 0x83CD, 0x83ED, 0x83ED, 0x83ED, 0x7BCC, 0x738C, 0x7BED, 0x7BCD, 0x840D, 0x7BCC, 0x73AC, 0x83ED, 0x83CC, 0x738B, 0x738B, 0x83CD, 0x83ED, 0x8C0E, 0x73AC, 0x7BCD, 0x7BED, 0x7BED,
  0x4207, 0x4268, 0x4247, 0x4227, 0x4227, 0x4A68, 0x4A68, 0x4AA9, 0x4A89, 0x52A9, 0x52CA, 0x52A9, 0x5AEB, 0x5B0B, 0x5ACA, 0x52EA, 0x52CA, 0x52A9, 0x4AA9, 0x4AA9, 0x4A89, 0x5AEA, 0x52CA, 0x5B0A, 0x634C, 0x634B, 0x634B, 0x6B6C, 0x6B6C, 0x738D, 0x634C, 
        0x5B0B, 0x632B, 0x5AEA, 0x5B0B, 0x6B8C, 0x6B6C, 0x738D, 0x73CE, 0x6B6D, 0x634C, 0x73AD, 0x634B, 0x630A, 0x5AEA, 0x632B, 0x634C, 0x634C, 0x6B8D, 0x6B8D, 0x6B6C, 0x738D, 0x6B6C, 0x73AD, 0x6B8D, 0x73CD, 0x7BEE, 0x7BEE, 0x7BEE, 0x7BEE, 0x6B8D, 
        0x73AD, 0x73AD, 0x73AD, 0x7BCD, 0x7BCE, 0x7BEE, 0x73CD, 0x5B2B, 0x634B, 0x6B6C, 0x7BAD, 0x7BAD, 0x738D, 0x6B8D, 0x6B6C, 0x73AD, 0x73AD, 0x6B6C, 0x634B, 0x632B, 0x738D, 0x6B4B, 0x738D, 0x738C, 0x6B6C, 0x738C, 0x6B6C, 0x73CD, 0x7BCE, 0x73AD, 
        0x6B6C, 0x738C, 0x6B4B, 0x634B, 0x6B4B, 0x738C, 0x738C, 0x73AC, 0x83EE, 0x738C, 0x738C, 0x73AD, 0x73CD, 0x7BEE, 0x7BCD, 0x83CD, 0x8C2F, 0x8C2F, 0x840E, 0x8C2E, 0x944F, 0x8C2E, 0x8C4F, 0x8C4F, 0x7BCD, 0x738C, 0x73AC, 0x8C0E, 0x946F, 0x83ED, 
        0x83CD, 0x83ED, 0x8C0D, 0x942E, 0x942E, 0x944F, 0x8C2E, 0x83ED, 0x8C2F, 0x83CE, 0x83ED, 0x736C, 0x7BCD, 0x73AD, 0x738C, 0x7BAD, 0x7BAD, 0x7BCD, 0x7BAD, 0x738C, 0x7BAC, 0x7BAC, 0x738C, 0x7B8C, 0x8C0E, 0x8C2E, 0x8C2E, 0x8C2F, 0x840E, 0x8C2E, 
        0x83CD, 0x7BAD, 0x8C2F, 0x8C0E, 0x8C2E, 0x8C0E, 0x8C4F, 0x83EE, 0x83EE, 0x7BCD, 0x7BCD, 0x83EE, 0x83ED, 0x83EE, 0x7BCD, 0x8C2E, 0x8C0E, 0x8C0E, 0x8BED, 0x83ED, 0x7BCD, 0x8C0E, 0x942E, 0x83ED, 0x83CD, 0x7BAD, 0x7BCD, 0x7BAC, 0x83EE, 0x738C, 
        0x8C2E, 0x83CD, 0x6B4B, 0x6B4B, 0x7BCD, 0x83EE, 0x83ED, 0x7BAD, 0x7BAD, 0x840E, 0x7BCD, 0x840E, 0x83EE, 0x83EE, 0x83EE, 0x840E, 0x7BCD, 0x6B4B, 0x630A, 0x83CD, 0x8C4F, 0x946F, 0x944F, 0x8C2F, 0x840E, 0x944F, 0x8C0E, 0x8C2F, 0x83ED, 0x7BCD, 
        0x8C2E, 0x840E, 0x840E, 0x840E, 0x840E, 0x8C2E, 0x9C90, 0x840E, 0x83EE, 0x8C0E, 0x840E, 0x83EE, 0x8C0E, 0x946F, 0x9C90, 0x946F, 0x8C2E, 0x83ED, 0x83EE, 0x73AC, 0x738C, 0x83ED, 0x83ED, 0x9490, 0x944F, 0x946F, 0x8C0E, 0x83CD, 0x83ED, 0x83ED, 
        0x83ED, 0x8C2E, 0x7BAC, 0x736C, 0x7BCD, 0x8C0E, 0x738C, 0x738C, 0x9470, 0x9C90, 0x946F, 0x8C2E, 0x83CD, 0x7BCD, 0x7BAC, 0x942E, 0x9C90, 0x8C2F, 0x8C2F, 0x944F, 0x9C90, 0x8C2F, 0x840E, 0x83ED, 0x83EE, 0x8C0E, 0x944F, 0xA4D1, 0x9C90, 0x944F, 
        0x8C0E, 0x8C0F, 0x8C0E, 0x83ED, 0x83ED, 0x942E, 0x944E, 0x940E, 0x83ED, 0x83ED, 0x8C0E, 0x8C0E, 0x83ED, 0x83ED, 0x83ED, 0x8C0E, 0x942E, 0x946F, 0x9CB0, 0x8C4F, 0x9490, 0x946F, 0x8C2E, 0x8C0E, 0x942E, 0x944F, 0x8C2F, 0x840E, 0x7BAD, 0x7BCD, 
        0x840E, 0x83EE, 0x83EE, 0x83EE, 0x8C2E, 0x83ED, 0x8C4F, 0x9C90, 0x9C8F, 0x9C8F, 0x944F, 0x8C2E, 0x8C2E, 0x83ED, 0xA4F1, 0xB533, 0xA4D1, 0x7410, 0x534E, 0x7BEF, 0xA4D1, 0x73AD, 0x3A08, 0x3A08, 0x6B4C, 0xBDD6, 0x9CD2, 0x4A89, 0x39E7, 0x3A08, 
        0x4A8A, 0x52CB, 0x4AAB, 0x4AAA, 0x6B4C, 0x4227, 0x4207, 0x94B1, 0x31A5, 0x20E3, 0x20E3, 0x39C6, 0x4227, 0x1882, 0x20C4, 0x20C4, 0x5208, 0x632C, 0x21A7, 0x3209, 0x3229, 0x1146, 0x1105, 0x10E5, 0x21EA, 0x32AE, 0x53B2, 0x53D2, 0x4B91, 0x534F, 
        0x31C7, 0x83EE, 0x9CB0, 0x94B1, 0x9D13, 0xA556, 0xAD97, 0x6B6D, 0x2945, 0x3185, 0x4A6A, 0x8410, 0x83EF, 0x49E7, 0x41C6, 0x5A68, 0x6AAA, 0x7B0A, 0x9C2E, 0xA44E, 0x9C4D, 0x9C6E, 0xACD0, 0xA512, 0xAD53, 0xA554, 0xAD74, 0xAD74, 0xB5D5, 0xB5F6, 
        0xAD94, 0xB5B5, 0xB595, 0xB595, 0xBDF6, 0xBDF6, 0xBDF6, 0xB5D5, 0xB5B5, 0xB5D6, 0xAD95, 0xC616, 0xCE56, 0xCE14, 0xC571, 0xBCEE, 0xB46C, 0x9349, 0x7A66, 0x7265, 0x5A04, 0x49E3, 0x5244, 0x6AE5, 0x3122, 0x9451, 0xCEB9, 0xAD74, 0xA554, 0xC657, 
        0x8C4F, 0x840E, 0x7BCD, 0x7BED, 0x83EE, 0x7BCD, 0x83EE, 0x8C0E, 0x8C0E, 0x944F, 0x8C2E, 0x83EE, 0x842E, 0x840E, 0x83ED, 0x83ED, 0x8C2E, 0x840E, 0x83ED, 0x7BCD, 0x83ED, 0x840E, 0x83ED, 0x842E, 0x840E, 0x840E, 0x840E, 0x840E, 0x83ED, 0x840D, 
        0x8C0E, 0x8C2E, 0x8C0D, 0x8C0D, 0x8C0E, 0x8C2E, 0x942E, 0x83ED, 0x83ED, 0x83ED, 0x83ED, 0x8BED, 0x83ED, 0x83ED, 0x7BAC, 0x83ED, 0x8C2E, 0x8C0D, 0x8C0D, 0x7BAC, 0x83CC, 0x83CC, 0x83ED, 0x83ED, 0x83ED, 0x83CD, 0x83CD, 0x83ED, 0x83ED,
  0x632B, 0x6B6C, 0x738D, 0x738D, 0x6B8C, 0x634B, 0x632B, 0x6B8D, 0x6B6C, 0x6B6C, 0x6B8D, 0x6B8D, 0x73AD, 0x7BCE, 0x73CD, 0x6B4B, 0x634B, 0x634B, 0x5B0A, 0x5B2B, 0x5B0A, 0x6B6B, 0x6B6C, 0x634B, 0x73AD, 0x73AD, 0x6B8C, 0x840E, 0x7BCD, 0x6B8C, 0x6B6C, 
        0x632B, 0x636C, 0x634C, 0x6B6C, 0x73CD, 0x73AD, 0x73CD, 0x8C50, 0x7BEE, 0x6B8C, 0x73AD, 0x738C, 0x6B6C, 0x5B0A, 0x5B0A, 0x634B, 0x6B6C, 0x73CD, 0x73AD, 0x738C, 0x7BCD, 0x738C, 0x73AD, 0x7BCD, 0x7BCD, 0x8C2F, 0x83EE, 0x842F, 0x840F, 0x7BCD, 
        0x7BED, 0x840E, 0x73AD, 0x840E, 0x8C2E, 0x7BEE, 0x840F, 0x6B8C, 0x73AD, 0x7BAD, 0x840E, 0x9470, 0x83EE, 0x6B8C, 0x6B8C, 0x7BCD, 0x840E, 0x73AD, 0x7BCD, 0x738C, 0x738C, 0x6B4B, 0x7BCD, 0x7BCD, 0x7BAC, 0x8C0E, 0x83ED, 0x83EE, 0x8C4F, 0x840E, 
        0x7BCD, 0x7BCD, 0x738C, 0x738C, 0x738B, 0x7BAC, 0x8C0E, 0x840E, 0x83ED, 0x840D, 0x840E, 0x7BCD, 0x7BCD, 0x7BEE, 0x83EE, 0x83EE, 0x8C2F, 0x942F, 0x8C2F, 0x8C2E, 0x944F, 0x83ED, 0x8C2E, 0x9C90, 0x840E, 0x7BCD, 0x7BCD, 0x8C2E, 0x9C8F, 0x944E, 
        0x8C0D, 0x8C2E, 0x8C0D, 0x9C6F, 0x944E, 0x944E, 0x9C6F, 0x8C0E, 0x946F, 0x8C0E, 0x8C0E, 0x738C, 0x83ED, 0x83ED, 0x738C, 0x840D, 0x8C2E, 0x7BCD, 0x83CD, 0x7BAC, 0x942E, 0x942E, 0x8C0D, 0x8C0E, 0x946F, 0x948F, 0x8C4E, 0x946F, 0x944E, 0x946F, 
        0x8C2E, 0x7BAC, 0x946F, 0x9C6F, 0x9C6F, 0x944E, 0x946F, 0x8C4F, 0x8C2E, 0x8C0E, 0x8C2E, 0x9C90, 0x8C2E, 0x8C0E, 0x8C0E, 0x944F, 0x9C6F, 0x944F, 0x942E, 0x8C2E, 0x8C0E, 0x944E, 0x9C8F, 0x942E, 0x8C0E, 0x7BAC, 0x8C0E, 0x83CD, 0x83CD, 0x7BCD, 
        0x8C2E, 0x944E, 0x7BAC, 0x7BAD, 0x83CD, 0x83EE, 0x840E, 0x83CD, 0x83ED, 0x840E, 0x7BCD, 0x8C0E, 0x8C0E, 0x8C2E, 0x840E, 0x840E, 0x83ED, 0x738C, 0x738C, 0x738C, 0x8C2E, 0x8C4F, 0x946F, 0x7BCD, 0x7BCD, 0x8C0E, 0x8C2F, 0x8C0E, 0x7BCD, 0x7BAD, 
        0x944F, 0x83ED, 0x83ED, 0x7BCD, 0x73AD, 0x840E, 0x9C90, 0x8C0E, 0x83EE, 0x8C0E, 0x8C0E, 0x83CD, 0x83CD, 0x8C0E, 0xA4B0, 0x946F, 0x942E, 0x83ED, 0x83ED, 0x738C, 0x738C, 0x83CD, 0x83CD, 0x8C2E, 0x8C2F, 0x8C2F, 0x840E, 0x83ED, 0x83ED, 0x840E, 
        0x83CD, 0x83EE, 0x7BAD, 0x738C, 0x7BAD, 0x83ED, 0x7B8C, 0x6B4A, 0x83EE, 0x946F, 0x840E, 0x7BCD, 0x7BAD, 0x7BCD, 0x7B8C, 0x83ED, 0x944F, 0x8C2E, 0x8C0E, 0x8C2E, 0x8C0E, 0x83ED, 0x7BCD, 0x7BAC, 0x7BCD, 0x83ED, 0x8C0E, 0x944E, 0x944F, 0x8C0E, 
        0x8C0E, 0x8C0E, 0x8C0E, 0x8C0E, 0x8C0E, 0x83ED, 0x8BED, 0x8BED, 0x83CD, 0x83ED, 0x8C0E, 0x8C0E, 0x8C0D, 0x7BAC, 0x83AC, 0x8C0E, 0x83ED, 0x8C2E, 0x944E, 0x8C0E, 0x8C0E, 0x83ED, 0x83CD, 0x83CD, 0x83ED, 0x8C0E, 0x8C2E, 0x840E, 0x83CD, 0x7BCD, 
        0x83ED, 0x83ED, 0x83ED, 0x83ED, 0x840E, 0x7BCD, 0x7BCD, 0x8C2E, 0x8C0E, 0x8C4E, 0x944F, 0x840D, 0x83ED, 0x83CD, 0xB553, 0xDEFA, 0xDED9, 0xE6B9, 0xDD32, 0xC46F, 0xD4B1, 0xDE58, 0xD699, 0xD699, 0xCE57, 0xBDD6, 0xD699, 0xD699, 0xD699, 0xDE37, 
        0xCD95, 0xD533, 0xD5D6, 0xCE58, 0xCE58, 0xBDD6, 0xBDF6, 0xB513, 0x92AB, 0x9ACB, 0x92AA, 0x71E7, 0x9AEB, 0xA2AA, 0xAA8A, 0xB36E, 0xBBAF, 0x59C8, 0x5ACB, 0x9C92, 0x324B, 0x00E8, 0x0108, 0x3AAD, 0x21CA, 0x118A, 0x7474, 0x7CB5, 0x19A9, 0x0083, 
        0x1904, 0x9514, 0x9DD8, 0x9597, 0x8D57, 0xADF8, 0xADF7, 0x6B4C, 0x3143, 0x62A5, 0x49C3, 0x49C4, 0x5203, 0x72A4, 0x7265, 0x5965, 0x8226, 0x92E8, 0xB3EB, 0xBCCD, 0xC50E, 0xCDB1, 0xD635, 0xBD93, 0xAD32, 0xB5B5, 0xAD74, 0xA553, 0xBDF5, 0xBDF5, 
        0xAD74, 0xB5B5, 0xAD53, 0xA553, 0xB594, 0xA532, 0xB5D5, 0xA553, 0xA554, 0xAD95, 0xAD74, 0xBDD5, 0xC636, 0xC5F4, 0xC550, 0xC4EE, 0xAC0B, 0x9B08, 0x8287, 0x7245, 0x6A85, 0x6265, 0x72E5, 0xA487, 0x3984, 0x9CB2, 0xD699, 0xC658, 0xCE99, 0xD6B9, 
        0xA533, 0x9490, 0x8C2F, 0x8C0E, 0x8C2E, 0x7BCD, 0x7BAD, 0x7BCD, 0x946F, 0x946F, 0x8C2E, 0x840E, 0x8C2E, 0x8C2E, 0x944F, 0x8C2E, 0x8C4F, 0x840E, 0x8C2F, 0x8C2E, 0x8C0E, 0x840E, 0x840E, 0x7BED, 0x83ED, 0x840E, 0x946F, 0x9C90, 0x8C4E, 0x946F, 
        0x9CB0, 0x946F, 0x8C2E, 0x8C2E, 0x8C2E, 0x942E, 0x944E, 0x942E, 0x8C2E, 0x942E, 0x8C0D, 0x942E, 0x944E, 0x8C0E, 0x8C0E, 0x8C2E, 0x9C6F, 0x944F, 0x9C8F, 0x942D, 0x8C0E, 0x942E, 0x8C0D, 0x944E, 0x942E, 0x8C0E, 0x8C2E, 0x83ED, 0x7BCD,
  0x632B, 0x6B6B, 0x73AD, 0x73AD, 0x6B4C, 0x6B4B, 0x630A, 0x73AD, 0x73AD, 0x6B6C, 0x73AD, 0x738C, 0x73AD, 0x7BED, 0x840E, 0x738C, 0x6B4B, 0x634B, 0x630B, 0x632B, 0x632A, 0x632B, 0x738D, 0x6B6C, 0x6B4B, 0x6B8C, 0x6B6C, 0x840E, 0x8C2E, 0x6B4B, 0x634B, 
        0x632B, 0x630A, 0x6B4B, 0x6B6C, 0x738D, 0x6B6C, 0x73CD, 0x842F, 0x7C0E, 0x6BAD, 0x73AD, 0x738C, 0x6B4B, 0x5B0A, 0x632A, 0x634B, 0x6B4B, 0x738C, 0x738C, 0x6B8C, 0x7BAD, 0x73AC, 0x6B6B, 0x7BAD, 0x7BCD, 0x946F, 0x946F, 0x840E, 0x83EE, 0x7BCD, 
        0x7BED, 0x840E, 0x7BCD, 0x7BCD, 0x8C2F, 0x83EE, 0x73AD, 0x73AD, 0x7BCD, 0x83EE, 0x83EE, 0x9C90, 0x8C4F, 0x6B6C, 0x6B8C, 0x7BCD, 0x8C0E, 0x7BAD, 0x7BED, 0x7BCD, 0x7BCD, 0x7BAC, 0x7BED, 0x83EE, 0x7BCD, 0x8C0E, 0x8C0E, 0x840E, 0x9470, 0x944F, 
        0x8C0E, 0x8C2E, 0x7BCD, 0x8C0E, 0x942E, 0x8BED, 0x942E, 0x944E, 0x83ED, 0x83ED, 0x944F, 0x840E, 0x7BCE, 0x840E, 0x840E, 0x840E, 0x8C4F, 0x8C2E, 0x8C0E, 0x8C0E, 0x840E, 0x83ED, 0x944F, 0x9C90, 0x8C2E, 0x83ED, 0x738C, 0x83ED, 0x9C90, 0x9C90, 
        0x8C2E, 0x942E, 0x8BED, 0x9C6F, 0x9C6F, 0x942E, 0x944E, 0x8C0E, 0x946F, 0x946F, 0x7BAD, 0x73AC, 0x7BED, 0x840E, 0x738C, 0x83CD, 0x944F, 0x8C0E, 0x7BAC, 0x738C, 0x840D, 0x942E, 0x942E, 0x946F, 0x946F, 0x8C2E, 0x8C0E, 0x944F, 0x942F, 0x944F, 
        0x946F, 0x7BCC, 0x83ED, 0x944F, 0x8C0D, 0x8C2E, 0x946F, 0x946F, 0x8C0E, 0x8C0E, 0x8C2E, 0x9CB0, 0x944F, 0x83ED, 0x83ED, 0x8C2E, 0x946F, 0x942E, 0x8C0D, 0x8C0D, 0x8C0E, 0x8C2E, 0x9C6F, 0x8C0D, 0x7B8C, 0x736B, 0x83CD, 0x7BAD, 0x738C, 0x738C, 
        0x7BAC, 0x83ED, 0x7BAC, 0x738C, 0x7BAC, 0x83EE, 0x7BAD, 0x7BAC, 0x73AC, 0x7BAC, 0x73AC, 0x73AC, 0x7BAC, 0x7BCD, 0x83CD, 0x83ED, 0x8C0D, 0x738B, 0x7BAC, 0x738C, 0x7BCD, 0x83ED, 0x8C2E, 0x83ED, 0x7BCD, 0x7BAC, 0x7BCD, 0x83CD, 0x7BCD, 0x7BAC, 
        0x83CD, 0x8C0D, 0x83ED, 0x7BCD, 0x83CD, 0x83ED, 0x8C4E, 0x8C0E, 0x7BCC, 0x7BAC, 0x83CD, 0x7BAC, 0x83ED, 0x840D, 0x840D, 0x83CD, 0x83CD, 0x83ED, 0x8C0E, 0x8C0D, 0x83CD, 0x83CD, 0x8C0D, 0x83CD, 0x83ED, 0x83EE, 0x83ED, 0x83EE, 0x83ED, 0x83ED, 
        0x7BED, 0x83EE, 0x83EE, 0x83EE, 0x83ED, 0x8C0E, 0x8C2E, 0x7BCD, 0x738C, 0x7BAC, 0x7BAC, 0x7BAD, 0x7BCD, 0x83CD, 0x83ED, 0x7BAC, 0x83ED, 0x83ED, 0x8C0E, 0x944F, 0x8C2E, 0x83ED, 0x83ED, 0x7BCD, 0x83ED, 0x942E, 0x83CD, 0x83ED, 0x8C2E, 0x8C0E, 
        0x7BCD, 0x83CD, 0x942E, 0x83ED, 0x8C0E, 0x8C0E, 0x942E, 0x8C0D, 0x83CD, 0x840E, 0x8C0E, 0x7BCD, 0x840D, 0x8BED, 0x7BAC, 0x7B8C, 0x7BAC, 0x8C2E, 0x9C90, 0x9C90, 0x944E, 0x8BED, 0x942E, 0x8BED, 0x83CD, 0x8C0E, 0x8C0E, 0x946F, 0x9490, 0x8C2F, 
        0x9CB0, 0xA4D1, 0x9C6F, 0x8C2E, 0x944E, 0x8C2E, 0x8C4E, 0x8C2E, 0x83ED, 0x840E, 0x8C0E, 0x8C0E, 0x944F, 0x944F, 0xC5D6, 0xDEFB, 0xDEDA, 0xE532, 0xBB29, 0xC532, 0xCBCD, 0xDCD1, 0xDEDA, 0xDEDA, 0xDEB9, 0xDEB9, 0xDEDA, 0xDF1B, 0xEE36, 0xDBAB, 
        0xBC6F, 0xCC6F, 0xDC4F, 0xE699, 0xDF1B, 0xE71B, 0xE73B, 0xCD54, 0xCC10, 0xCC51, 0xDC51, 0xCBAE, 0xD451, 0xCBAE, 0xC30D, 0xD410, 0xCBAF, 0x9B8F, 0xB5D8, 0xCEBC, 0x6C12, 0x0085, 0x00C6, 0x42CD, 0x08C5, 0x00C6, 0x42CC, 0x326B, 0x00A4, 0x0062, 
        0x31E8, 0x6CB5, 0x4C35, 0x6CD6, 0x5C95, 0x5C75, 0x74F6, 0x630B, 0x3964, 0x5A65, 0x6285, 0x6285, 0x6AC4, 0xBCE5, 0x8B25, 0x5104, 0x79E6, 0x9B08, 0xAB8A, 0xBC8C, 0xC52F, 0xC550, 0xCE15, 0xC5F5, 0xA511, 0xB5B5, 0xAD75, 0xA554, 0xBDF6, 0xBE16, 
        0xAD94, 0xB5B5, 0xB594, 0xAD53, 0xA553, 0xB594, 0xBDF6, 0xB5D5, 0xB5B6, 0xB5B6, 0xB5F6, 0xC616, 0xCE56, 0xCE15, 0xC571, 0xCD50, 0xB46D, 0xA38A, 0x8AA8, 0x59A5, 0x4985, 0x3965, 0x5A46, 0x7B87, 0x4A27, 0xB595, 0xD6BA, 0xD699, 0xCE78, 0xB5B5, 
        0xB5B6, 0xC575, 0xBC71, 0xC492, 0xC5B6, 0xA533, 0x94B1, 0x8C4F, 0x946F, 0x946F, 0x8C2E, 0x840E, 0x8C2E, 0x8C2E, 0x8C0E, 0x840D, 0x83ED, 0x83ED, 0x840E, 0x83ED, 0x7BED, 0x7BED, 0x840E, 0x83ED, 0x83ED, 0x83ED, 0x8C2E, 0x8C4F, 0x8C4F, 0x8C2E, 
        0x8C2E, 0x8C4E, 0x840E, 0x83ED, 0x840D, 0x840D, 0x8C2E, 0x8C0D, 0x8C0D, 0x83ED, 0x83ED, 0x83ED, 0x8C2E, 0x8C0E, 0x8C0D, 0x8C2E, 0x8C4E, 0x8C2E, 0x8C0D, 0x942E, 0x83ED, 0x83ED, 0x8C0E, 0x8C0E, 0x8C4E, 0x8C0E, 0x83ED, 0x8C2E, 0x8C2E,
  0x632A, 0x6B4B, 0x6B6B, 0x6B6B, 0x6B4B, 0x632B, 0x630A, 0x738C, 0x7BCD, 0x6B8C, 0x73AD, 0x73AD, 0x738C, 0x7BED, 0x944F, 0x7BED, 0x6B6B, 0x634B, 0x634B, 0x630A, 0x632A, 0x5B0A, 0x738C, 0x6B6C, 0x6B6B, 0x6B4B, 0x6B6B, 0x7BAC, 0x944F, 0x7BAD, 0x6B6C, 
        0x6B6B, 0x630A, 0x6B6B, 0x6B6B, 0x6B6C, 0x6B4B, 0x6B6C, 0x73CD, 0x7BEE, 0x738D, 0x738C, 0x738C, 0x632A, 0x6309, 0x630A, 0x634B, 0x6B4B, 0x738C, 0x738C, 0x6B8C, 0x738C, 0x7BAC, 0x6B6B, 0x6B4B, 0x7BCD, 0x944F, 0x944F, 0x840E, 0x7BED, 0x7BCD, 
        0x73CD, 0x73CD, 0x7BEE, 0x7BCD, 0x8C2E, 0x840E, 0x632B, 0x6B6C, 0x73CD, 0x7BEE, 0x7BED, 0x9C90, 0x9490, 0x6B6B, 0x6B6C, 0x73AD, 0x7BCD, 0x7BAD, 0x7BCD, 0x83ED, 0x83CD, 0x83ED, 0x7BCD, 0x840E, 0x7BAD, 0x7BCD, 0x7BCC, 0x7BCD, 0x8C4F, 0x8C2F, 
        0x8C2E, 0x8C2E, 0x83ED, 0x83ED, 0x9C6F, 0x942E, 0x942E, 0x944E, 0x840D, 0x83CD, 0x942E, 0x83ED, 0x738C, 0x7BCD, 0x7BCD, 0x83ED, 0x840E, 0x840E, 0x83EE, 0x83ED, 0x83ED, 0x83CD, 0x83ED, 0x840E, 0x83EE, 0x7BAD, 0x6B6C, 0x73AC, 0x8C4E, 0x8C2E, 
        0x83ED, 0x83CC, 0x83AC, 0x83ED, 0x83ED, 0x83CD, 0x83CD, 0x7BAC, 0x83ED, 0x8C2E, 0x7BAD, 0x73AC, 0x73AC, 0x7BCD, 0x738C, 0x7B8C, 0x83ED, 0x7BED, 0x6B6B, 0x6B4B, 0x7BAC, 0x7BAC, 0x83CD, 0x8C0D, 0x83ED, 0x83CD, 0x83CD, 0x83ED, 0x83ED, 0x83ED, 
        0x8C0D, 0x83ED, 0x7BCC, 0x83CD, 0x83CC, 0x83ED, 0x83ED, 0x83ED, 0x83EE, 0x7BCD, 0x8C0E, 0x8C2E, 0x8C4E, 0x840E, 0x840D, 0x8C0D, 0x942E, 0x8C0E, 0x8BED, 0x8C0D, 0x8C0D, 0x8C0D, 0x940D, 0x8BCD, 0x83AC, 0x83CD, 0x83ED, 0x8C0E, 0x83CD, 0x7BCD, 
        0x7BAC, 0x7BCC, 0x944E, 0x946F, 0x840D, 0x7BCD, 0x7BCD, 0x83CD, 0x83ED, 0x9C90, 0x9CB0, 0x8C0E, 0x83ED, 0x83ED, 0x944E, 0x9CB0, 0xA4B0, 0x944F, 0x9C6F, 0x946F, 0x9C90, 0x9C90, 0x9CB0, 0x946F, 0x8C2E, 0x8C0E, 0x83ED, 0x840D, 0x944F, 0x8C0E, 
        0x8C0E, 0x9C90, 0x946F, 0x8C4F, 0x8C2F, 0x8C2E, 0x946F, 0x9C90, 0x942E, 0x83CD, 0x83ED, 0x83ED, 0x8C2E, 0x946F, 0x8C2E, 0x83ED, 0x8C0E, 0x9C6F, 0xA48F, 0xA4B0, 0x942E, 0x83CD, 0x8C0E, 0x8BED, 0x83CD, 0x8C0E, 0x8C0E, 0x8C2E, 0x840E, 0x83ED, 
        0x83ED, 0x8C2E, 0x8C0E, 0x942F, 0x944F, 0x8C2F, 0x946F, 0x9C90, 0x83CD, 0x83AD, 0x83CD, 0x83ED, 0x840E, 0x8C4F, 0x946F, 0x83ED, 0x8C0E, 0x944F, 0x944E, 0xA48F, 0xA48F, 0x942E, 0x942E, 0x83ED, 0x8C2E, 0xA4B0, 0x940D, 0x83ED, 0x944F, 0x9C4F, 
        0x8C2E, 0x83AC, 0x944E, 0x8C0D, 0x8BED, 0x942E, 0x9C6F, 0x9C4E, 0x8BED, 0x942E, 0x944F, 0x83ED, 0x8C0E, 0x8C0D, 0x8BCC, 0x7BAC, 0x7BAC, 0x8BED, 0x9CB0, 0xA4D1, 0xA4B0, 0x942E, 0x944E, 0x944E, 0x83ED, 0x840E, 0x840E, 0x8C2F, 0x9CB0, 0x944F, 
        0x946F, 0x9C90, 0x9C6F, 0x8C2E, 0x944E, 0x8C0D, 0x8C2E, 0x8C2E, 0x83ED, 0x83ED, 0x83EE, 0x83EE, 0x840E, 0x944F, 0xD678, 0xDEDA, 0xDE99, 0xD44F, 0xC512, 0xE71A, 0xD532, 0xCC90, 0xDEB9, 0xDEDA, 0xDEB9, 0xDEDA, 0xDEDA, 0xDEFA, 0xE4CF, 0xCB4A, 
        0xD657, 0xDE98, 0xDCB0, 0xDD94, 0xDEFB, 0xDEDA, 0xDF1B, 0xC4D2, 0xB209, 0xB228, 0xB208, 0xB187, 0xB1E8, 0xB9E8, 0xB9C8, 0xBA08, 0xB9E8, 0xB3F1, 0x9D98, 0x8D36, 0xA597, 0x29C7, 0x3208, 0x534E, 0x1988, 0x21EA, 0x5BAF, 0x2A4B, 0x21C9, 0x3A29, 
        0x94D2, 0x95B8, 0x6CB5, 0x7D16, 0x9577, 0x9577, 0x9D76, 0x5AEA, 0x2903, 0x28E3, 0x3103, 0x3103, 0x49C4, 0xB4E8, 0x6265, 0x6A07, 0x82A9, 0xB40D, 0xB40B, 0xC4EE, 0xCD70, 0xC591, 0xCE14, 0xC615, 0xB594, 0xBDF6, 0xBDF6, 0xB5D6, 0xBE16, 0xC657, 
        0xBDF6, 0xBDF6, 0xC637, 0xC617, 0xBDF6, 0xC617, 0xC637, 0xBE37, 0xBE17, 0xBE17, 0xBE17, 0xBDF6, 0xBDD5, 0xBDB4, 0xBD93, 0xBD52, 0xACAF, 0x9C2E, 0x942F, 0x9450, 0x7BAE, 0x5ACC, 0x9CF3, 0xAD53, 0xBDD6, 0xD6B9, 0xCE79, 0xADB5, 0x94B1, 0x94D2, 
        0x9CF3, 0xAD54, 0xBD55, 0xA491, 0xB5B6, 0xBE17, 0xBE37, 0xBE17, 0xBDF6, 0xB594, 0x9CF2, 0x8C4F, 0x8C2E, 0x944F, 0x944E, 0x8C2E, 0x944F, 0x8C4F, 0x944F, 0x83EE, 0x840E, 0x83ED, 0x8C2E, 0x8C2E, 0x944F, 0x8C0E, 0x8C0E, 0x8C2E, 0x946F, 0x946F, 
        0x8C0D, 0x946F, 0x948F, 0x8C2E, 0x8C4E, 0x946F, 0x946F, 0x944F, 0x946F, 0x8C0E, 0x840D, 0x840D, 0x944E, 0x946F, 0x946F, 0x948F, 0x9490, 0x946F, 0x8C2E, 0x944F, 0x8C0D, 0x83ED, 0x944E, 0x944E, 0x9C90, 0x946F, 0x8C0E, 0x9C6F, 0x9CB0,
  0x6B4A, 0x6B4B, 0x6B6B, 0x73AD, 0x6B8C, 0x632B, 0x632A, 0x6B6B, 0x7BCD, 0x738D, 0x73AD, 0x7BCD, 0x738C, 0x73AC, 0x83EE, 0x83ED, 0x736C, 0x6B4B, 0x632B, 0x632A, 0x632A, 0x5AEA, 0x632B, 0x632A, 0x6B4B, 0x6B6B, 0x6B6B, 0x6B6B, 0x7BED, 0x83ED, 0x6B8C, 
        0x738C, 0x6B4B, 0x632A, 0x630A, 0x6B4B, 0x73AD, 0x73AD, 0x73AD, 0x73AD, 0x73AD, 0x738C, 0x736C, 0x6B2A, 0x6309, 0x6309, 0x6B4B, 0x736B, 0x738C, 0x738C, 0x6B6B, 0x6B6B, 0x738B, 0x6B6B, 0x6B6B, 0x6B6B, 0x738C, 0x7BCD, 0x7BCD, 0x7BCD, 0x7BCD, 
        0x738C, 0x6B6C, 0x6B8C, 0x6B8C, 0x73AD, 0x7BAD, 0x6B2B, 0x634B, 0x6B8C, 0x73AD, 0x73AD, 0x8C2E, 0x9C90, 0x83ED, 0x83ED, 0x7BAD, 0x7BCD, 0x7BCD, 0x7BAD, 0x7BCD, 0x83ED, 0x83ED, 0x7BAD, 0x7BAD, 0x7BCD, 0x83ED, 0x7BAC, 0x738C, 0x7BCD, 0x7BCD, 
        0x7BEE, 0x7BCD, 0x7BCD, 0x7BCD, 0x840D, 0x83CD, 0x7BAD, 0x83CD, 0x83ED, 0x83ED, 0x83ED, 0x7BAC, 0x736B, 0x736B, 0x7BAC, 0x83ED, 0x7BCD, 0x7BCD, 0x7BCD, 0x7BCD, 0x7BCD, 0x83CD, 0x7BCD, 0x7BEE, 0x7BCD, 0x7BAD, 0x73AD, 0x73AC, 0x7BAC, 0x83ED, 
        0x8C0E, 0x8C0E, 0x83AC, 0x83CD, 0x7BAC, 0x83CD, 0x8C2E, 0x8C0E, 0x8C0E, 0x944F, 0x9C6F, 0x946E, 0x8C0E, 0x8C2E, 0x8C2E, 0x83ED, 0x83ED, 0x83CD, 0x83ED, 0x8C2E, 0x7BCD, 0x8C0E, 0x944E, 0x9C6F, 0x944E, 0x8BED, 0x8C0E, 0x8C0E, 0x8C2E, 0x8C0E, 
        0x940E, 0x942E, 0x940D, 0x940E, 0x8BED, 0x8C0E, 0x83ED, 0x83EE, 0x8C2E, 0x840E, 0x83EE, 0x8C0E, 0x9CB0, 0x9CB0, 0xA4B0, 0xA4D0, 0xA4D0, 0xA4D0, 0xA48F, 0xA4AF, 0xA46E, 0x9C6E, 0x942D, 0x9C4E, 0x9C4F, 0x944F, 0x9C90, 0x9C6F, 0x8C4E, 0x946F, 
        0x8C4E, 0x8C2E, 0x9C6F, 0xA4B0, 0x9CB0, 0x8C0E, 0x942E, 0x8C2E, 0x8C2E, 0xA4B0, 0xAD11, 0x9C90, 0x944F, 0x944F, 0x944F, 0xA4F0, 0xAD11, 0xA4D0, 0x9C8F, 0x9C6F, 0x9CB0, 0x9CB0, 0xA4D1, 0xA4D1, 0x946F, 0x944F, 0x942E, 0x8C0D, 0x8C0E, 0x8C0E, 
        0x942E, 0x944F, 0x9C90, 0x944F, 0x8C4F, 0x944F, 0x946F, 0xA4F1, 0x9C6F, 0x8C0E, 0x83CD, 0x83ED, 0x8C0E, 0x8C2E, 0x8C2E, 0x8C0E, 0x9C4F, 0xACD0, 0xA4B0, 0x9C6F, 0x942E, 0x83CD, 0x83CD, 0x83CD, 0x83CD, 0x83ED, 0x8C0E, 0x8C0E, 0x83ED, 0x83ED, 
        0x83ED, 0x83ED, 0x840D, 0x8C0E, 0x944F, 0x8C2E, 0x8C2E, 0x9C6F, 0x8C0E, 0x7BAC, 0x7BAC, 0x7BAC, 0x83CD, 0x83EE, 0x83ED, 0x83CD, 0x83ED, 0x8C2F, 0x8C2E, 0x8C0E, 0x942E, 0x8BED, 0x7BCC, 0x7BAC, 0x7BAC, 0x9C6E, 0x944E, 0x83ED, 0x83ED, 0x8BED, 
        0x942E, 0x83ED, 0x83CD, 0x83ED, 0x83CD, 0x8BED, 0x8BED, 0x940D, 0x83ED, 0x83CD, 0x840D, 0x7BAC, 0x83CD, 0x83CC, 0x83AC, 0x7BAC, 0x83ED, 0x83ED, 0x8C2E, 0x8C2E, 0x8C2E, 0x942E, 0x8C0D, 0x942E, 0x83ED, 0x83ED, 0x83CD, 0x8C0E, 0x944F, 0x8C0E, 
        0x8C2E, 0x944F, 0x944F, 0x8C2E, 0x83ED, 0x8C0E, 0x8C4E, 0x8C2E, 0x8C2E, 0x944E, 0x8C2E, 0x83EE, 0x8C2E, 0x9490, 0xDEDA, 0xDF1B, 0xDEB9, 0xD38B, 0xE553, 0xEEB8, 0xDC2E, 0xCD74, 0xDF1B, 0xDEFB, 0xDEFA, 0xE71B, 0xDF1B, 0xDEFB, 0xD4D1, 0xD4D2, 
        0xE71B, 0xEEB8, 0xE3AA, 0xDD32, 0xDF1B, 0xDEFB, 0xDEFB, 0xC4F2, 0xC34D, 0xC38E, 0xC36D, 0xCA29, 0xD32D, 0xD38E, 0xD36D, 0xD38E, 0xDBAE, 0x930E, 0x9D99, 0xA5D9, 0x532E, 0x08E4, 0x4AAB, 0x52EB, 0x4B0E, 0x4330, 0x6C32, 0x53B0, 0x8CD4, 0xBE18, 
        0xD6BA, 0xCE99, 0xCE99, 0xCE9A, 0xD6BA, 0xD6BA, 0xCE99, 0x8C70, 0x630B, 0x6B4C, 0x6B2C, 0x6B0B, 0x738C, 0xC5D5, 0xCE37, 0xD658, 0xD679, 0xDE99, 0xB532, 0xB531, 0xB572, 0xBDB3, 0xBDD5, 0xBDD5, 0xBE16, 0xBDF7, 0xBE17, 0xBDF6, 0xB5D6, 0xB5D6, 
        0xBE17, 0xBE17, 0xBE17, 0xC637, 0xC617, 0xC637, 0xC658, 0xC658, 0xC658, 0xC658, 0xC638, 0xC658, 0xC658, 0xC658, 0xCE58, 0xCE58, 0xCE58, 0xCE78, 0xCE99, 0xD6BA, 0xBE18, 0xAD76, 0xCE99, 0xD6BA, 0xCE99, 0xB5F6, 0x7C2F, 0x634C, 0x52EA, 0x7BEE, 
        0xA534, 0xC658, 0xCE99, 0xADB6, 0xA554, 0xB5D6, 0xCE99, 0xD6BA, 0xD6BA, 0xD6B9, 0xC617, 0x9CF1, 0x8C6F, 0x8C2E, 0x8C2E, 0x8C2E, 0x8C2E, 0x8C2E, 0x8C0E, 0x840E, 0x83ED, 0x83ED, 0x840D, 0x8C0D, 0x83ED, 0x8C0E, 0x840E, 0x8C2E, 0x8C2E, 0x946F, 
        0x8C0E, 0x944E, 0x946F, 0x8C2E, 0x840D, 0x8C4F, 0x8C2E, 0x8C0D, 0x8C2E, 0x8C0E, 0x8C2E, 0x8C2E, 0x8C0E, 0x8C2E, 0x8C2E, 0x8C0E, 0x8C4F, 0x8C4F, 0x8C2E, 0x840D, 0x8C2D, 0x83ED, 0x8BED, 0x840D, 0x8C0E, 0x946F, 0x8C2E, 0x8C2E, 0x946F,
  0x736B, 0x6B4B, 0x6B6B, 0x738C, 0x738C, 0x6B4B, 0x6B6B, 0x6B8C, 0x73AD, 0x738D, 0x738C, 0x73AC, 0x738C, 0x7BCD, 0x83ED, 0x83ED, 0x7BCD, 0x6B6B, 0x6B4B, 0x6B4B, 0x6B6C, 0x738C, 0x738C, 0x73AC, 0x738C, 0x736C, 0x736C, 0x738C, 0x738C, 0x73AD, 0x738C, 
        0x6B8C, 0x738C, 0x738C, 0x736C, 0x73AC, 0x7BED, 0x7BCD, 0x7BCD, 0x7BCD, 0x7BCD, 0x83EE, 0x6B6C, 0x736B, 0x7B8B, 0x6B4A, 0x7BAC, 0x9C8F, 0x9C8F, 0x9C6E, 0x7BAC, 0x736B, 0x7BCD, 0x83ED, 0x83EE, 0x8C2E, 0x8C2E, 0x8C2E, 0x946F, 0x840E, 0x840E, 
        0x7BCD, 0x738C, 0x6B6C, 0x738C, 0x7BAC, 0x7BAC, 0x73AC, 0x736C, 0x7BCD, 0x7BCD, 0x8C2E, 0x944E, 0xACF1, 0xACF1, 0xA4D0, 0x944E, 0x83CD, 0x840E, 0x83ED, 0x7BAC, 0x83ED, 0x8C2E, 0x8C2E, 0x8C0E, 0x9C8F, 0x9C6F, 0x942E, 0x83ED, 0x83EE, 0x7BED, 
        0x7BCD, 0x7BCD, 0x7BAD, 0x7BAD, 0x83ED, 0x83ED, 0x73AD, 0x7BAC, 0x8C0E, 0x8C2E, 0x8C2E, 0x83CD, 0x7BAC, 0x738C, 0x83CD, 0x8C0E, 0x83ED, 0x842E, 0x83EE, 0x840E, 0x7BED, 0x840E, 0x7BEE, 0x7BCD, 0x7BED, 0x83EE, 0x7BCD, 0x83ED, 0x83ED, 0x840E, 
        0x8C2E, 0x944F, 0x8C2E, 0x7BCD, 0x83CD, 0x83CD, 0x840E, 0x8C2E, 0x944F, 0x946F, 0xACF1, 0xA4D0, 0x944E, 0x8C2E, 0x944F, 0x840E, 0x8BED, 0x8C0D, 0x8C0E, 0x944F, 0x8C4F, 0x944F, 0x9C8F, 0x9CB0, 0xA4D0, 0x942E, 0x8C0E, 0x942E, 0x942E, 0x942E, 
        0x940E, 0x942E, 0x942E, 0x9C4E, 0x8C0D, 0x83ED, 0x8C0E, 0x840E, 0x7BCD, 0x83CD, 0x7BAD, 0x83CD, 0x946F, 0xA4B0, 0x9CB0, 0xA4B0, 0xA4B0, 0x9C8F, 0x9C4E, 0xA46F, 0xA48F, 0x9C4E, 0x942D, 0x9C4E, 0x9C6F, 0x9C4F, 0x944E, 0x946F, 0x8C2E, 0x8C2E, 
        0x948F, 0x8C2E, 0x83ED, 0x9C6F, 0xA4D0, 0x8C2E, 0x83ED, 0x8C0E, 0x8C0E, 0x8C2E, 0xA4D0, 0x9CB0, 0x942F, 0x8C2E, 0x8C0E, 0x9C90, 0xB532, 0xAD11, 0x9C8F, 0x944F, 0x944F, 0x9C90, 0x9C90, 0x9CB0, 0x946F, 0x8C0E, 0x840D, 0x83CD, 0x83ED, 0x8BED, 
        0x8C0D, 0x8C0E, 0x942E, 0x8C0E, 0x8C2E, 0x8C0E, 0x8C0E, 0x946F, 0x942E, 0x8C0D, 0x83ED, 0x83CD, 0x83ED, 0x8C0E, 0x840E, 0x840D, 0x8C0E, 0x944E, 0x9C8F, 0x942E, 0x9C6F, 0x8C0D, 0x83CC, 0x7BAC, 0x7BAC, 0x8C0E, 0x8C2E, 0x8C0E, 0x8C2E, 0x8C2E, 
        0x8C2E, 0x8C2E, 0x9C90, 0x9C8F, 0x944F, 0x83EE, 0x840E, 0x7BED, 0x83ED, 0x83ED, 0x83CD, 0x83CD, 0x83CD, 0x7BCD, 0x7BAC, 0x8BED, 0x944E, 0x8C2E, 0x8C2E, 0x8C2E, 0x942E, 0x8C2E, 0x944E, 0x944E, 0x942E, 0x9C6E, 0x9C6E, 0x9C4E, 0x9C4E, 0x8C0D, 
        0x940D, 0x944E, 0x8BED, 0x83ED, 0x8BED, 0x8C0D, 0x8BED, 0x8BED, 0x942E, 0x946F, 0x9C6F, 0x9C6F, 0x9C8F, 0xA48F, 0x9C6E, 0x940D, 0x942E, 0x9C8F, 0x944E, 0x8C0D, 0x944E, 0x944E, 0x9C4E, 0x9C6F, 0x944E, 0x946F, 0x9C8F, 0x9C90, 0xA4B0, 0x9C8F, 
        0x9C8F, 0xA4D1, 0x9CB0, 0x9C90, 0x946F, 0x9CB0, 0xA4B0, 0x9CB0, 0xA4D0, 0xACF1, 0x9CB0, 0x8C2E, 0x946F, 0xAD53, 0xCD73, 0xED10, 0xECCF, 0xC2A8, 0xCB4B, 0xDB09, 0xB226, 0xDCD0, 0xED72, 0xDD53, 0xBDB6, 0xAD13, 0xDD94, 0xE5F5, 0xDC6F, 0xD32A, 
        0xDD12, 0xDC2E, 0xBAC9, 0xD5D6, 0xE698, 0xE699, 0xDED9, 0xD4D1, 0xD2CA, 0xD2A9, 0xD248, 0xCA08, 0xD2A9, 0xD269, 0xC228, 0xD268, 0xA249, 0x72AD, 0x5B70, 0x8CD5, 0x6390, 0x73F1, 0xA555, 0xAD75, 0xC617, 0xC659, 0xCE99, 0xD6DA, 0xDEFB, 0xDEDA, 
        0xD6BA, 0xD6B9, 0xD6BA, 0xD6BA, 0xD6BA, 0xD6BA, 0xCE99, 0xC638, 0xA554, 0x740F, 0x5B0B, 0x4248, 0x3A27, 0x8451, 0xBDF7, 0xCE78, 0xCE78, 0xC658, 0xCE99, 0xCE99, 0xCE79, 0xCE99, 0xCE99, 0xD699, 0xCE99, 0xD699, 0xD6B9, 0xD699, 0xCE99, 0xD6B9, 
        0xD6B9, 0xD6BA, 0xD6BA, 0xD6DA, 0xDEDA, 0xDEDA, 0xD6DA, 0xD6BA, 0xD6DA, 0xD6DA, 0xD6BA, 0xD6BA, 0xD6BA, 0xD6BA, 0xD6BA, 0xD6BA, 0xD6BA, 0xD6B9, 0xD6B9, 0xD69A, 0xCE99, 0xCE99, 0xD699, 0xD69A, 0xD699, 0xCE79, 0xBE38, 0xBE17, 0xAD75, 0x94F2, 
        0x8C91, 0x6BEF, 0x8471, 0x9D34, 0xB5D7, 0xC638, 0xBE17, 0xB5F7, 0xB5D6, 0xAD96, 0xAD75, 0xA553, 0x948F, 0x946F, 0x8C2F, 0x8C2E, 0x8C2E, 0x8C0E, 0x840D, 0x8C4E, 0x8C4F, 0x8C2E, 0x8C4F, 0x946F, 0x946F, 0x946F, 0x946F, 0x9490, 0x9490, 0x944F, 
        0x946F, 0x9CB0, 0x9CB0, 0x946F, 0x8C2E, 0x8C2E, 0x944F, 0x9C8F, 0x9C6F, 0x8C2E, 0x944F, 0x946F, 0x946F, 0x8C4E, 0x8C2E, 0x8C2E, 0x8C2E, 0x944F, 0x946F, 0x8C2E, 0x946F, 0x9C6F, 0x944E, 0x8C0D, 0x83ED, 0x8C2E, 0x946F, 0x946F, 0x946F,
  0x8C0E, 0x738C, 0x738C, 0x7BAC, 0x7BAC, 0x73AC, 0x738C, 0x73AD, 0x73CD, 0x73AD, 0x8C2E, 0x9490, 0x944E, 0x9C8F, 0x9C8F, 0x9C8F, 0x9C8F, 0x7BCD, 0x6B4B, 0x6B6B, 0x73AC, 0x8C2E, 0x8C2E, 0x942E, 0x942E, 0x83ED, 0x83CD, 0x83ED, 0x7BAC, 0x73AC, 0x7BED, 
        0x7BCD, 0x7BCD, 0x840E, 0x8C4E, 0x944E, 0x944F, 0x944F, 0x8C4F, 0x8C2E, 0x83ED, 0x840E, 0x7BCD, 0x7BAC, 0x8BCD, 0x7B8B, 0x7B8B, 0x9C8F, 0xACF0, 0xACF0, 0x8C0D, 0x7B8C, 0x7BAC, 0x83CD, 0x8C0E, 0x946F, 0x946F, 0x946F, 0x9CB0, 0x8C4F, 0x83ED, 
        0x83ED, 0x7BCD, 0x7BCD, 0x7BAC, 0x7BAC, 0x7BCC, 0x840E, 0x7BCD, 0x7BCD, 0x83ED, 0x8C2E, 0x944F, 0xA4B0, 0xAD11, 0x9C6E, 0x9C6F, 0x8BED, 0x83ED, 0x8BED, 0x83ED, 0x83CD, 0x8C2E, 0x8C0E, 0x83ED, 0x944E, 0x944F, 0x9C90, 0x8C2E, 0x840E, 0x840E, 
        0x7BAD, 0x738C, 0x738C, 0x73AC, 0x73AC, 0x7BAD, 0x738C, 0x6B6C, 0x7BCD, 0x83ED, 0x83ED, 0x83ED, 0x7BAC, 0x7BAC, 0x7BAC, 0x7BCD, 0x73AD, 0x738C, 0x738C, 0x73AD, 0x7BCD, 0x7BCD, 0x7BCD, 0x73AD, 0x7BCD, 0x7BAD, 0x7BAD, 0x7BAC, 0x7BAC, 0x7BAC, 
        0x83CD, 0x83CD, 0x840D, 0x8C0E, 0x8C2E, 0x8C2E, 0x83ED, 0x83ED, 0x83ED, 0x8C0E, 0x948F, 0x944E, 0x8C0D, 0x83ED, 0x840E, 0x8C0E, 0x8BED, 0x8C0D, 0x7BCC, 0x83ED, 0x8C0E, 0x7BCD, 0x83ED, 0x8C0E, 0x8C2E, 0x8C0E, 0x83CD, 0x83CD, 0x83CD, 0x840E, 
        0x8BED, 0x8BED, 0x83CD, 0x83ED, 0x83ED, 0x7BCD, 0x7BCD, 0x83CD, 0x7BCD, 0x7BCD, 0x7BAD, 0x7BCD, 0x8C2E, 0x9C90, 0x9C8F, 0x944F, 0x944F, 0x8C2E, 0x8BED, 0x942E, 0x944F, 0x942E, 0x942E, 0x9C6E, 0x9C6F, 0x9C4E, 0x8C0E, 0x83CD, 0x8BED, 0x83ED, 
        0x8C0D, 0x7BAC, 0x7BAC, 0x6B2A, 0x6B0A, 0x8C0E, 0x83ED, 0x83CD, 0x8C0E, 0x944F, 0x944F, 0x946F, 0x946F, 0x8C0D, 0x8BED, 0x9C8F, 0xA4D0, 0xA4D0, 0x9C6F, 0x8C0E, 0x83EE, 0x83EE, 0x946F, 0x9C90, 0x9CB0, 0x946F, 0x840E, 0x83ED, 0x8C2E, 0x944F, 
        0x8C0E, 0x944F, 0x942E, 0x8C0E, 0x8C2E, 0x8C2F, 0x8C0E, 0x8C2E, 0x944F, 0x9C8F, 0x9C8F, 0x9C6F, 0x948F, 0x946F, 0x946F, 0x944F, 0x946F, 0x9C8F, 0xA4B0, 0xA4B0, 0xACF1, 0xACF1, 0xA4B0, 0x9C90, 0x940E, 0x9C90, 0xAD12, 0xA4F1, 0xA4D0, 0xA4F1, 
        0xA4F1, 0xACF1, 0xAD32, 0xB532, 0xAD32, 0x944F, 0x8C0E, 0x840E, 0x840E, 0x946F, 0x944F, 0x944F, 0x8C4F, 0x8C0E, 0x8C0E, 0x9C8F, 0xA4AF, 0xA48F, 0xA4B0, 0xA4B0, 0x9C90, 0x9C90, 0xA4D0, 0xACD1, 0xA48F, 0xA4AF, 0xA4AF, 0xA4AF, 0xA4AF, 0xA48F, 
        0xA48F, 0xA4AF, 0xA4B0, 0x9C6F, 0xA4B0, 0x9C6F, 0x9C4E, 0x942E, 0x9C6E, 0xA4B0, 0x9C8F, 0xA4D0, 0xA4B0, 0xACD0, 0xA4AF, 0x942D, 0x8BED, 0x944E, 0x9C8F, 0x942E, 0x944E, 0x942E, 0x940D, 0x9C8F, 0x942E, 0x942E, 0x9C6F, 0x9C8F, 0x9C8F, 0x9C8F, 
        0x946F, 0x946F, 0x946F, 0x944F, 0x8C2E, 0x946F, 0x9C90, 0x946F, 0x944F, 0x9CB0, 0xA4D1, 0x9C90, 0x9CD1, 0xA513, 0x8BEE, 0x8AA9, 0x9288, 0x4986, 0x38E4, 0x6986, 0x61C8, 0x828A, 0x92EA, 0x8B4C, 0x73CF, 0x18C3, 0x8227, 0xB2E8, 0x9289, 0x8A48, 
        0x8A06, 0x69A5, 0x4904, 0x4965, 0xB2E9, 0xCB49, 0xDD72, 0xCB69, 0xC225, 0xBA25, 0x91A6, 0x71A6, 0x8ACA, 0x61A7, 0x51A8, 0x6209, 0x2967, 0x94D4, 0xD6BA, 0xCE99, 0xDEDA, 0xDEFB, 0xDEDA, 0xDEDB, 0xDEDA, 0xDEDA, 0xDEDA, 0xDEDA, 0xD6DA, 0xDEDA, 
        0xDEDA, 0xDEDA, 0xDEDA, 0xD6BA, 0xDEDA, 0xD6DA, 0xCE99, 0xBDF6, 0x94D2, 0x73CE, 0x5B4C, 0x4AAA, 0x3A28, 0x7C0F, 0x9D33, 0xB5B6, 0xCE58, 0xCE78, 0xD6B9, 0xD6B9, 0xD6B9, 0xD6B9, 0xD6BA, 0xD6BA, 0xD6BA, 0xD6BA, 0xD6BA, 0xD6DA, 0xD6BA, 0xD6BA, 
        0xD6DA, 0xD6BA, 0xD6BA, 0xD699, 0xD699, 0xD6BA, 0xCE99, 0xCE99, 0xCE99, 0xCE99, 0xCE79, 0xCE79, 0xCE79, 0xC658, 0xC658, 0xC658, 0xC658, 0xC638, 0xBE38, 0xBE18, 0xBE17, 0xBE37, 0xBE17, 0xB5F7, 0xB5F6, 0xB5F7, 0xADB6, 0xA575, 0xADB6, 0xADB6, 
        0xAD95, 0x7BEF, 0x73CF, 0x73CF, 0x8C91, 0xA574, 0x8CB2, 0x8471, 0x7C30, 0x7410, 0x8451, 0x8470, 0x9490, 0x9C90, 0x9C90, 0x944F, 0x8C2E, 0x8C2E, 0x8C2E, 0x944E, 0x944F, 0x8C4F, 0x8C4E, 0x946F, 0x9C90, 0x9C90, 0x946F, 0x946F, 0x946F, 0x946F, 
        0x946F, 0x946F, 0x946F, 0x948F, 0x8C4E, 0x944F, 0x944F, 0x944F, 0x942E, 0x8C0D, 0x840D, 0x8C4E, 0x946F, 0x944E, 0x8C4E, 0x8C0E, 0x8C0E, 0x840E, 0x842E, 0x8C4E, 0x8C2E, 0x946F, 0x944E, 0x83ED, 0x83ED, 0x840D, 0x8C2E, 0x946F, 0x8C4E,
  0x9C8F, 0x83ED, 0x7BAC, 0x7BCC, 0x7BCC, 0x738C, 0x738C, 0x738C, 0x73AD, 0x73AD, 0x8C4F, 0xA4F1, 0x9C8F, 0x9C8F, 0xA4D0, 0xA4B0, 0x9CB0, 0x8C0E, 0x6B4B, 0x6B2B, 0x738B, 0x8C0E, 0x942E, 0x944E, 0x942E, 0x8C0D, 0x8C0D, 0x8C0D, 0x83ED, 0x7BAC, 0x83ED, 
        0x83ED, 0x83ED, 0x7BAD, 0x948F, 0x8C2E, 0x83ED, 0x8C2E, 0x946F, 0x944F, 0x8C4F, 0x8C0E, 0x840E, 0x7BAC, 0x83CD, 0x83CC, 0x83AC, 0x9C6E, 0xACF0, 0xACF0, 0x944E, 0x7B8C, 0x83ED, 0x83CD, 0x83ED, 0x8C2F, 0x9470, 0x946F, 0x9490, 0x8C4F, 0x7BCD, 
        0x7BED, 0x840E, 0x840E, 0x7BCD, 0x83CD, 0x7BAC, 0x83ED, 0x83ED, 0x738C, 0x7BCD, 0x7BCD, 0x83ED, 0x944E, 0xACF1, 0xA4B0, 0x9C8F, 0x8C2E, 0x83CD, 0x83CD, 0x8BED, 0x7BCC, 0x83CD, 0x7BAD, 0x7BAC, 0x83ED, 0x8C0E, 0x946F, 0x8C2E, 0x7BCD, 0x7BCD, 
        0x7BAD, 0x738C, 0x738C, 0x73AC, 0x73AC, 0x73AD, 0x738C, 0x6B8C, 0x738C, 0x738C, 0x738C, 0x73AC, 0x7BCD, 0x7BAC, 0x738C, 0x73AC, 0x7BAD, 0x6B4B, 0x738C, 0x73AD, 0x7BCD, 0x7BCD, 0x7BAD, 0x73AD, 0x7BAD, 0x7BAD, 0x7BAD, 0x7BCD, 0x83CD, 0x83ED, 
        0x83ED, 0x83ED, 0x8C2E, 0x8C2E, 0x840E, 0x840E, 0x840E, 0x83EE, 0x83ED, 0x944F, 0x944F, 0x83ED, 0x8BED, 0x8C0D, 0x83ED, 0x8C0D, 0x942E, 0x83CD, 0x83CD, 0x840D, 0x840D, 0x83ED, 0x83ED, 0x944E, 0x942E, 0x83ED, 0x8C0E, 0x8BED, 0x8C0E, 0x942E, 
        0x9C90, 0x9C6F, 0x8C0E, 0x7BAC, 0x840E, 0x8C2E, 0x7BAC, 0x7BAC, 0x7BAC, 0x83ED, 0x83ED, 0x83CD, 0x946F, 0xACF1, 0xACF1, 0xA4B0, 0xACF1, 0xACD0, 0x9C90, 0x9C8F, 0x9CB0, 0x9C90, 0x944F, 0x9C8F, 0x9C8F, 0x946F, 0x9C6F, 0x8C2E, 0x944E, 0x942E, 
        0x942E, 0x83ED, 0x8BED, 0x7B6B, 0x62E9, 0x8C0E, 0x946F, 0x8C4E, 0x9C8F, 0xA4F1, 0xA4D0, 0xA4D0, 0xACF1, 0xA4B0, 0x9C6F, 0xA4D0, 0xACF1, 0xAD11, 0xA4D0, 0x942E, 0x83CD, 0x7BCD, 0x944F, 0xA4F1, 0xAD11, 0xA4F1, 0x946F, 0x8C2E, 0x8C2E, 0x8C2E, 
        0x8C0E, 0x944F, 0x9C6F, 0x946F, 0x8C2E, 0x8C2E, 0x8C0E, 0x8C0E, 0x8C2E, 0xA4D0, 0xACD0, 0xA4D0, 0x9C90, 0x946F, 0x9C8F, 0x944F, 0x944F, 0x9C8F, 0x9C8F, 0xA490, 0xACF1, 0xAD11, 0xAD11, 0xACF1, 0xACD1, 0xACF1, 0xAD32, 0xAD32, 0xACF1, 0xA4D0, 
        0xA4F1, 0xA4D1, 0xA511, 0xAD12, 0xAD32, 0x9490, 0x7BAD, 0x83ED, 0x83ED, 0x8C2E, 0x8C2E, 0x8C0E, 0x8C2E, 0x840E, 0x8BED, 0x942E, 0x9C8F, 0xA48F, 0xA48F, 0xA4AF, 0x9C8F, 0x9C8F, 0x9C8F, 0xA4D0, 0x9C8F, 0x9C6F, 0xA48F, 0xA48F, 0xA48F, 0x9C6F, 
        0xA48F, 0x9C8F, 0x9C6F, 0x9C6E, 0x9C8F, 0x9C6F, 0x9C4E, 0x942E, 0x942E, 0x944E, 0x8C2E, 0x946F, 0xA4B0, 0x9C8F, 0x9C6F, 0x942E, 0x8BED, 0x8BED, 0x942E, 0x8C0D, 0x8BED, 0x8BED, 0x8C0D, 0x8C2E, 0x940E, 0x942E, 0x944E, 0x8C0E, 0x8C2E, 0x942E, 
        0x944F, 0x944F, 0x8C2E, 0x83ED, 0x8C2E, 0x8C0E, 0x944E, 0x8C2E, 0x948F, 0xAD33, 0xAD54, 0xAD74, 0x9D13, 0x4AED, 0x328C, 0x2A6C, 0x226D, 0x226C, 0x220B, 0x2A6D, 0x2AAE, 0x2AAE, 0x2AAE, 0x32CE, 0x3ACD, 0x2A2B, 0x224C, 0x2A6C, 0x226E, 0x2AAE, 
        0x426C, 0x322B, 0x1989, 0x1189, 0x324C, 0x3A2B, 0x8452, 0x7B8E, 0x7B8F, 0x83F0, 0x73D1, 0x8431, 0x94F4, 0x8493, 0x8CF4, 0xA576, 0xB5D8, 0xCE9A, 0xDEFB, 0xDEDB, 0xDEDB, 0xDEDA, 0xDEDB, 0xDEFB, 0xDEFB, 0xDEDB, 0xDEDB, 0xDEDB, 0xDEFB, 0xDEFB, 
        0xDEFB, 0xDEFB, 0xDEFB, 0xDEFB, 0xDEFB, 0xDEFB, 0xD6BA, 0xCE99, 0xCE99, 0xCE99, 0xCE99, 0xCE99, 0xA554, 0x4AA9, 0x4ACA, 0x5B4C, 0x8450, 0xAD95, 0xC637, 0xCE58, 0xC658, 0xC658, 0xC638, 0xC638, 0xC638, 0xC637, 0xBE17, 0xBE17, 0xB5D6, 0xB5D6, 
        0xB5D6, 0xB5B6, 0xB5B6, 0xAD95, 0xAD95, 0xAD96, 0xAD95, 0xA575, 0xADB6, 0xB5F7, 0xB5D6, 0xADB6, 0xA575, 0xA575, 0xADB6, 0xA595, 0xA575, 0xA595, 0xA595, 0xA595, 0xA575, 0xADD6, 0xAD95, 0xA575, 0x9D55, 0x9D54, 0xADB5, 0xA575, 0xAD95, 0xADB6, 
        0xB5B6, 0x72EA, 0x938D, 0x9491, 0x8C91, 0x94B2, 0x632C, 0x7C30, 0x73EF, 0x42AB, 0x94F3, 0x6B6C, 0x840E, 0x8C2E, 0x944F, 0x946F, 0x944F, 0x944E, 0x8C2E, 0x83ED, 0x83ED, 0x83ED, 0x83ED, 0x840D, 0x8C4E, 0x944F, 0x944F, 0x8BEC, 0x8BCC, 0x944E, 
        0x8C2E, 0x840D, 0x8C2E, 0x948F, 0x948F, 0x946F, 0x944F, 0x944F, 0x8C2E, 0x8C0E, 0x8C0E, 0x944E, 0x8C4E, 0x8C2E, 0x8C2E, 0x944F, 0x8C4F, 0x8C2E, 0x842E, 0x8C2E, 0x946F, 0x948F, 0x946F, 0x8BED, 0x83ED, 0x8C2E, 0x8C4E, 0x944F, 0x946F,
  0x946F, 0x944E, 0x83CD, 0x840D, 0x83ED, 0x7BCC, 0x7BED, 0x738C, 0x738C, 0x73AC, 0x946F, 0xA4F1, 0x9C90, 0x946F, 0xA4D0, 0xA4B0, 0x9C90, 0x944F, 0x738C, 0x6B4B, 0x738B, 0x7BCC, 0x944E, 0x9C6F, 0x944E, 0x942E, 0x8C0D, 0x8BCD, 0x83CD, 0x738C, 0x7BAC, 
        0x83ED, 0x7BCD, 0x7BCD, 0x8C0E, 0x8C0E, 0x7BCD, 0x83ED, 0x8C2E, 0x840E, 0x840E, 0x83ED, 0x83ED, 0x7B8C, 0x7B8C, 0x7B8B, 0x83CC, 0x8C0D, 0x9C6E, 0x9C8F, 0x940D, 0x7BAC, 0x7B8C, 0x738B, 0x7BAC, 0x83ED, 0x8C2E, 0x8C0E, 0x83CD, 0x7BAC, 0x738C, 
        0x736B, 0x738B, 0x7BAC, 0x7BCD, 0x7B8C, 0x7B8B, 0x736B, 0x736B, 0x738C, 0x83CD, 0x83CD, 0x83AC, 0x83CC, 0x9C4E, 0x9C4E, 0x942E, 0x940D, 0x7B8C, 0x83CD, 0x8BED, 0x83CD, 0x83CC, 0x83CC, 0x940D, 0x8C0D, 0x940D, 0x940E, 0x8C2E, 0x946F, 0x946F, 
        0x840E, 0x83ED, 0x840E, 0x83CD, 0x840E, 0x83ED, 0x7BCD, 0x7BCD, 0x8C0E, 0x8BEE, 0x83ED, 0x8C0E, 0x8C2E, 0x83EE, 0x83CD, 0x8C0E, 0x8C2E, 0x83EE, 0x83EE, 0x8C2E, 0x8C2F, 0x840E, 0x8C2F, 0x946F, 0x946F, 0x944F, 0x8C0E, 0x946F, 0x9C90, 0x944F, 
        0x942E, 0x8C2E, 0x9C90, 0xA4D0, 0x9C90, 0x8C2E, 0x944E, 0x944F, 0x944F, 0x9C90, 0x9CB0, 0x9C6F, 0x9C8F, 0xA4B0, 0x9C6F, 0x942E, 0x9C6F, 0x8BED, 0x83ED, 0x9C8F, 0x9C8F, 0x8C2E, 0x946F, 0x9C6F, 0x9C6F, 0x8C2E, 0x8C0E, 0x8C0D, 0x8C0E, 0x942E, 
        0x9C90, 0x9C8F, 0x9C6F, 0x83CD, 0x8C2E, 0x8C4F, 0x83CD, 0x7B8C, 0x7B8C, 0x7BAC, 0x83CD, 0x83ED, 0x9CB0, 0xAD11, 0xAD11, 0xACF1, 0xACF1, 0xACF1, 0xAD11, 0xA4B0, 0x9C90, 0x9CB0, 0x944F, 0x8C2E, 0x942E, 0x942E, 0x946F, 0x942E, 0x8C2E, 0x942E, 
        0x942E, 0x8C0E, 0x8BED, 0x942E, 0x8C0D, 0x83ED, 0x942E, 0x944F, 0x9C8F, 0xA4D0, 0xA4D0, 0x9CB0, 0xA4D0, 0xACF1, 0xACF1, 0xA4B0, 0xA4B0, 0x9CB0, 0xA4B0, 0x944F, 0x7BCD, 0x7BAD, 0x840E, 0x9CB0, 0x9CB0, 0x9CB0, 0x9C90, 0x8C0E, 0x8C0E, 0x83ED, 
        0x83EE, 0x8C0E, 0x944E, 0x944F, 0x840E, 0x83ED, 0x83CD, 0x83ED, 0x840D, 0x9C6F, 0x9C6E, 0x946E, 0x944E, 0x8C2E, 0x8C2E, 0x8C0E, 0x8C0D, 0x944E, 0x9C4E, 0x9C8F, 0x9C8F, 0x944E, 0x9C6F, 0x9C8F, 0xA4AF, 0xA4D0, 0xA4D0, 0x9C8F, 0x9C90, 0x9C6F, 
        0x9C6F, 0x946F, 0x946F, 0x9490, 0x9C90, 0xA4B0, 0x9C8F, 0x9C6F, 0x83ED, 0x8C0E, 0x944E, 0x946F, 0x946F, 0x944E, 0x942E, 0x942E, 0x944E, 0x9C6F, 0xA4D0, 0xA4D0, 0x9C8F, 0xA4B0, 0xA4D1, 0xA4D0, 0x946F, 0x944E, 0x9C6F, 0x9C6F, 0x9C6F, 0xA4B0, 
        0x9C8F, 0x9C6F, 0x9C8F, 0xA4AF, 0x9C8F, 0xA4B0, 0xA4D0, 0xA4B0, 0x9C6F, 0x942E, 0x8C0E, 0x8C0E, 0x9C8F, 0x9C90, 0x9C6F, 0x9C6F, 0x9C4E, 0x940D, 0x940D, 0x9C4E, 0x9C8F, 0x9CB0, 0xA4D0, 0x946F, 0x9C8F, 0xACD0, 0xACD0, 0x9C6F, 0x946F, 0x946F, 
        0x946F, 0xA4D1, 0x9CB1, 0x946F, 0x9C8F, 0x944E, 0x8C0E, 0x942E, 0xA4F1, 0x842E, 0x4A68, 0x39E7, 0x2986, 0x2965, 0x2985, 0x2985, 0x29A6, 0x31C6, 0x31A6, 0x3A28, 0x4AA9, 0x4A89, 0x4248, 0x2A29, 0x326A, 0x4AAA, 0x3208, 0x31E8, 0x4AAB, 0x634E, 
        0x6BD0, 0x6BF1, 0x4B2E, 0x11A9, 0x19A8, 0x324A, 0x21A7, 0x52EB, 0x7C30, 0x9513, 0xBE17, 0xE71B, 0xE71C, 0xE73C, 0xE71C, 0xDEFB, 0xDF1B, 0xDEFB, 0xDEFB, 0xDEFB, 0xD6DA, 0xD6BA, 0xD6DA, 0xD6BA, 0xD6BA, 0xCEBA, 0xCE99, 0xC679, 0xC679, 0xC658, 
        0xBE38, 0xBE38, 0xBE18, 0xBE17, 0xB5F7, 0xB5D6, 0xADB6, 0xADB6, 0xAD95, 0xA595, 0xA595, 0xA595, 0xB5F6, 0x4AA9, 0x10C2, 0x29A6, 0x4A8A, 0x9D34, 0xBDF7, 0xB5D6, 0xADB6, 0xADB6, 0xADB6, 0xB5D6, 0xA595, 0xA575, 0x9D54, 0xA554, 0xA554, 0x9513, 
        0x94F3, 0x8CD2, 0x9D13, 0xAD95, 0xA575, 0x9D54, 0x9D34, 0xB5D6, 0x94F2, 0x634D, 0x634D, 0x6BCF, 0xA575, 0x742F, 0x5B4C, 0x5B2C, 0x8492, 0xB5F6, 0x4ACA, 0x31C6, 0x428A, 0xA575, 0x9533, 0x6BCF, 0x63AE, 0x638D, 0xADB6, 0x8CB2, 0x8471, 0x8492, 
        0xA554, 0x632B, 0x72AA, 0x8B8D, 0x8C91, 0x94D1, 0x6B6D, 0x8C91, 0x9513, 0x6BCF, 0x9D34, 0x7BCD, 0x7BED, 0x948F, 0x8C2E, 0x948F, 0x9CB0, 0x946F, 0x946F, 0x8C0E, 0x7BCD, 0x738B, 0x7BCC, 0x8C2E, 0x944E, 0x944F, 0x9C8F, 0x9C6E, 0x9C0D, 0x940D, 
        0x9C6F, 0x944E, 0x948F, 0x948F, 0x9C90, 0x9C90, 0x9CB0, 0x9C6F, 0x944E, 0x8C2E, 0x944E, 0x946F, 0x946F, 0x944E, 0x944F, 0x944F, 0x944E, 0x8C0E, 0x8C4E, 0x8C2E, 0x944E, 0x946F, 0x944E, 0x8C0D, 0x83ED, 0x840D, 0x8C0D, 0x8C2E, 0x944E,
  0x8BED, 0x83ED, 0x83CD, 0x83ED, 0x83CD, 0x83ED, 0x7BAC, 0x73AC, 0x7BAC, 0x7BAC, 0x7BED, 0x840D, 0x944E, 0x942E, 0x944E, 0x944E, 0x8C0D, 0x8C0D, 0x83CD, 0x736B, 0x6B6B, 0x736B, 0x738B, 0x83CC, 0x8BED, 0x8C0D, 0x83CC, 0x7B8B, 0x83CC, 0x83EC, 0x83ED, 
        0x83ED, 0x83AC, 0x83AC, 0x83CD, 0x8BED, 0x8BED, 0x83CC, 0x8BED, 0x8C2D, 0x942E, 0x942E, 0x8BED, 0x83AC, 0x8BED, 0x93ED, 0x8BEC, 0x83AC, 0x83AB, 0x940D, 0x8BED, 0x8C0D, 0x944E, 0x944E, 0x940D, 0x942D, 0xA46E, 0xA46F, 0x9C4E, 0x940D, 0x940D, 
        0x940D, 0x8BCC, 0x83CC, 0x940D, 0x8BED, 0x7BAC, 0x7BAB, 0x7B8B, 0x7B8B, 0x8C0D, 0xA48F, 0x9C6F, 0x940D, 0x9C4E, 0x9C2E, 0x9C2E, 0xA44E, 0x93ED, 0x83CC, 0x942E, 0x942E, 0x942D, 0x942D, 0x9C6E, 0x9C6E, 0xA46F, 0x9C6F, 0x9C6F, 0xA4D1, 0xA4D1, 
        0x9CB0, 0x8C0E, 0x83ED, 0x83CD, 0x8C0D, 0x83ED, 0x83ED, 0x83CD, 0x8C0E, 0x942E, 0x8C0E, 0x8C2E, 0x8C0E, 0x8C2E, 0x8C2E, 0x9C6F, 0xA4B0, 0x946F, 0x8C2F, 0x9490, 0x946F, 0x8C2E, 0x946F, 0x9C90, 0x948F, 0x9CB0, 0x9490, 0x9470, 0x944F, 0x8C0F, 
        0x8C2F, 0x8C2E, 0x946F, 0xA4B0, 0xA4B0, 0x942E, 0x8C2E, 0x8C2E, 0x944F, 0x8C2E, 0x946F, 0x944F, 0x9C8F, 0xA4D0, 0x9C6F, 0x942E, 0x942E, 0x944F, 0x8BED, 0x944E, 0x9C8F, 0x8C0D, 0x944E, 0x944E, 0x942E, 0x944E, 0x8C0D, 0x8C0E, 0x8C0E, 0x942E, 
        0x944F, 0xA4B0, 0x9CB0, 0x8C0E, 0x83CD, 0x83ED, 0x7BCD, 0x7BAC, 0x7BCD, 0x83ED, 0x83ED, 0x83CD, 0x944F, 0x9C90, 0x9C8F, 0x9C8F, 0xA4D0, 0xA4D0, 0xA4B0, 0x9C8F, 0x944F, 0x946F, 0x8C2E, 0x942E, 0x944F, 0x944F, 0x942E, 0x8C0E, 0x83ED, 0x83CD, 
        0x83ED, 0x83ED, 0x83ED, 0x8C0D, 0x8C0D, 0x83ED, 0x83CD, 0x8BED, 0x946F, 0x9CB0, 0x9CB0, 0x944E, 0x946F, 0x9CB0, 0xA4B0, 0x9C90, 0x9C8F, 0x946F, 0x946F, 0x944F, 0x8C0E, 0x83EE, 0x7BCD, 0x8C2E, 0x944F, 0x8C2E, 0x944F, 0x9C6F, 0x9C4F, 0x8C0E, 
        0x942E, 0x942E, 0x8C0E, 0x8C2E, 0x8C2E, 0x8C0E, 0x7BAC, 0x8C0E, 0x9C8F, 0xA4AF, 0x9C8F, 0xA4D0, 0xA4D0, 0x9CB0, 0x9C90, 0x9CB0, 0x9C8F, 0x9C4E, 0x9C4E, 0xA4AF, 0xAD10, 0xA4CF, 0xACD0, 0xA4CF, 0xA4CF, 0xACD0, 0xACD0, 0xA4AF, 0xA4B0, 0xACF0, 
        0xACD0, 0x9C90, 0x9C90, 0x9CB0, 0x9C90, 0xACF1, 0xBD52, 0xBD72, 0x9C90, 0x9C6F, 0x9C90, 0xA4D0, 0xAD11, 0xACD1, 0x9CB0, 0xA4B0, 0xA4B0, 0x9C90, 0xACD1, 0xAD11, 0xAD11, 0xAD12, 0xB532, 0xACF1, 0xA490, 0x9C8F, 0x9C6F, 0x9C6F, 0xA48F, 0xACD0, 
        0xA4B0, 0xA490, 0xA4B0, 0xA4D0, 0x9C8F, 0x9C8F, 0xACF1, 0xACF1, 0x9C8F, 0x9C6F, 0x944F, 0x8C0E, 0x942E, 0x946F, 0x944F, 0x942E, 0x942E, 0x8BEC, 0x8BCC, 0x940D, 0x9C8F, 0x9C6F, 0x9C90, 0x948F, 0x944F, 0x9C6F, 0x9C6E, 0x944E, 0x942E, 0x944F, 
        0x944F, 0x944F, 0x944F, 0x944F, 0x8C2E, 0x8C2E, 0x8C0E, 0x8C0E, 0x8C0E, 0x8C2E, 0x944F, 0x83CD, 0x39E7, 0x62EA, 0x8C0E, 0x944E, 0x62EA, 0x7B8C, 0x9C8F, 0x7BCD, 0x632B, 0x634B, 0x6B4B, 0x530D, 0x5B2C, 0x6B4B, 0x4A48, 0x39E7, 0x52CA, 0x6B6D, 
        0x7BEF, 0x632C, 0x3208, 0x1126, 0x29A7, 0x5ACA, 0x41C5, 0x2923, 0x4227, 0x4268, 0x52CA, 0x8CB1, 0xA555, 0xAD96, 0xB5D6, 0xC658, 0xCE79, 0xBE38, 0xADB6, 0x9D54, 0xADB6, 0xA554, 0x8471, 0x7C50, 0x7C50, 0x73EF, 0x9D54, 0x8CB1, 0x636D, 0x636D, 
        0x5B4C, 0x73EF, 0xADB6, 0x5B4C, 0x52CB, 0x4289, 0x3A48, 0x9513, 0x740F, 0x4B0C, 0x42AB, 0x3207, 0x8471, 0x632B, 0x0020, 0x10C3, 0x0882, 0x7C2F, 0xBE17, 0x4AAA, 0x3208, 0x3A28, 0x638D, 0xADB6, 0x7410, 0x6BEF, 0x6BEF, 0x8491, 0xB5D6, 0x8CD3, 
        0x7C71, 0x6BEF, 0x8471, 0xADB5, 0x29C6, 0x1903, 0x4269, 0xA596, 0x7C2F, 0x0020, 0x0041, 0x4A8A, 0xA595, 0x5B6C, 0x29A6, 0x3208, 0x8CD3, 0xBE37, 0x3A27, 0x0881, 0x3A07, 0xA554, 0xA596, 0x84D3, 0x84D3, 0x7C50, 0xAD95, 0xA575, 0xADB6, 0xADB6, 
        0xB5D6, 0x6BCE, 0x52A9, 0x6AEA, 0x7C0F, 0x9CF2, 0x7BCE, 0x8C71, 0xAD95, 0x8491, 0x9D34, 0x7BEE, 0x738C, 0x946F, 0x8C2E, 0x942E, 0x946F, 0x8C2E, 0x8C2E, 0x83ED, 0x7BAC, 0x6B2A, 0x6309, 0x738B, 0x83ED, 0x8C0D, 0x8C0D, 0x942E, 0x8C0D, 0x83CC, 
        0x83ED, 0x83CC, 0x7B8B, 0x7B8B, 0x83CC, 0x8C2D, 0x8C0D, 0x7BAC, 0x7B8B, 0x736B, 0x6B2A, 0x6B2A, 0x6B4A, 0x6B4A, 0x6B4A, 0x6B2A, 0x6B0A, 0x62E9, 0x62E9, 0x62E9, 0x5288, 0x5AA8, 0x5AC9, 0x5AC9, 0x5288, 0x5288, 0x52A8, 0x52A8, 0x52A8,
  0x8BED, 0x7BAC, 0x83CC, 0x940D, 0x940D, 0x942D, 0x8BEC, 0x7BAB, 0x83CC, 0x83CC, 0x83CC, 0x7BAC, 0x9C4E, 0x9C6F, 0x9C6E, 0x9C6F, 0x940D, 0x8BED, 0x940D, 0x7BAC, 0x6B4A, 0x736B, 0x6B4A, 0x736B, 0x8C0D, 0x93ED, 0x940D, 0x8BEC, 0x942D, 0x9C4D, 0x9C4D, 
        0x9C4E, 0x940D, 0x8BEC, 0x940D, 0x940D, 0x9C2D, 0x9C2D, 0x940D, 0x944E, 0x9C4E, 0x9C6E, 0x9C6F, 0x940D, 0x940D, 0x942E, 0x940D, 0x8BEC, 0x83AC, 0x8BED, 0x8C0D, 0x942D, 0xA48F, 0xA4AF, 0x9C4E, 0x942D, 0x9C4E, 0xA46E, 0xA48F, 0xA46E, 0xA48F, 
        0xA46F, 0x9C4E, 0x8C0C, 0x942E, 0x9C4E, 0x8C0D, 0x8C0D, 0x8C0D, 0x83AC, 0x83CC, 0x9C4E, 0x9C6E, 0x940D, 0x9C4E, 0xA46F, 0xA44E, 0x9C2E, 0x9C2E, 0x8BED, 0x8C2D, 0x944E, 0x944E, 0x942D, 0x9C4E, 0x9C6E, 0x9C4E, 0x9C4E, 0x944E, 0xA4D1, 0xA4F1, 
        0xA4F1, 0x9C90, 0x83CD, 0x83ED, 0x83ED, 0x7BCD, 0x7BCD, 0x83ED, 0x8C2E, 0x944F, 0x8C2E, 0x8C0D, 0x8C0E, 0x8C2E, 0x8C0E, 0x942E, 0x944F, 0x944F, 0x8C2E, 0x944F, 0x8C2E, 0x8C0E, 0x8C2E, 0x8C2E, 0x83ED, 0x840E, 0x8C4F, 0x8C2F, 0x83EE, 0x83EE, 
        0x83ED, 0x840D, 0x83ED, 0x8C2E, 0x8C0E, 0x83ED, 0x83CD, 0x83CD, 0x83ED, 0x83ED, 0x8C2E, 0x942E, 0x9C6F, 0xA4B0, 0x942E, 0x944E, 0x8C0E, 0x8C2E, 0x83CC, 0x7BAC, 0x83CD, 0x83ED, 0x83ED, 0x8C0D, 0x8C0E, 0x8C0E, 0x8C2E, 0x944F, 0xA4B0, 0xA4D0, 
        0xA4D0, 0x9C90, 0x9CB0, 0x9C90, 0x840E, 0x7BCD, 0x83ED, 0x7BCD, 0x83EE, 0x83EE, 0x8C0E, 0x8C0E, 0xA4D1, 0xAD11, 0xACF1, 0xACD0, 0xB531, 0xB552, 0xB532, 0xACF1, 0xB532, 0xB552, 0xA4D0, 0xA4D0, 0xB552, 0xBD72, 0xA4D0, 0x944F, 0x944F, 0x8C0E, 
        0x8C2E, 0x9CB0, 0xA4B0, 0x9C8F, 0x9C8F, 0x944E, 0x8BCC, 0x8BCC, 0xA4D0, 0xB532, 0xAD11, 0xA4D0, 0xACD1, 0xACF1, 0xA4D1, 0xACF1, 0xB531, 0xACF1, 0x9C8F, 0x9C6F, 0x8C2E, 0x8C0E, 0x83ED, 0x83EE, 0x9C8F, 0x9CB0, 0x9C6F, 0xA48F, 0xA4AF, 0x9C4E, 
        0x942E, 0x944F, 0x944F, 0x944F, 0x946F, 0x944F, 0x8C2E, 0x942E, 0xA4D0, 0xACD0, 0xA4D0, 0xACF1, 0xACF1, 0xA4D0, 0xA4B0, 0x9CB0, 0x9C8F, 0x9C4E, 0x9C4E, 0x9C4E, 0xACF0, 0xA4AF, 0x9C8F, 0x9CAF, 0xA4AF, 0xACF0, 0xACD0, 0xACD0, 0xA4AF, 0xA4D0, 
        0xACD0, 0x9C6F, 0x944F, 0x944F, 0x944F, 0x946F, 0xAD11, 0xB531, 0xAD11, 0x944F, 0x944E, 0x944F, 0x9CB0, 0x9CB0, 0xA4D1, 0x946F, 0x944E, 0x942E, 0x944E, 0xA4B0, 0xA4D0, 0xA4B0, 0x9C90, 0x942E, 0x942E, 0x8C0D, 0x942E, 0x9C6F, 0x946F, 0x944F, 
        0x944E, 0x944F, 0x942E, 0x942E, 0x946F, 0x944F, 0x944E, 0x946F, 0x8C2E, 0x8C2E, 0x944E, 0x944F, 0x9C4F, 0x9C6E, 0x9C90, 0x9C6F, 0x940D, 0x8BCC, 0x83AC, 0x8BED, 0x9C2D, 0x942E, 0x944F, 0x944F, 0x9CB0, 0xA4D0, 0xA4B0, 0x9C4F, 0x942E, 0x942E, 
        0x944E, 0x8C0D, 0x8C0D, 0x942E, 0x944F, 0x944F, 0x946F, 0x944F, 0x8C2E, 0x948F, 0x9CB0, 0x944F, 0x5288, 0x944F, 0xB511, 0xB511, 0x8BED, 0x9C8F, 0xAD32, 0x944F, 0x840E, 0x842F, 0x842F, 0x63AF, 0x7C0F, 0x842E, 0x4248, 0x3A27, 0x52CA, 0x634D, 
        0x6B8E, 0x5A89, 0x3124, 0x0083, 0x3A29, 0x7BCD, 0x6AEA, 0x3985, 0x632B, 0x632B, 0x5B2B, 0x52CA, 0x3A07, 0x31E7, 0x3207, 0x4A8A, 0xC658, 0x7C50, 0x3208, 0x31E7, 0x8CB1, 0x7C0F, 0x29A6, 0x3A07, 0x3A07, 0x29C6, 0x8C91, 0x6BAD, 0x29C6, 0x31E7, 
        0x29A6, 0x52EB, 0xB5D6, 0x3A27, 0x3207, 0x3A28, 0x428A, 0x9513, 0x63AE, 0x42CB, 0x3A8A, 0x29E7, 0x8471, 0x6B6C, 0x0840, 0x1904, 0x0062, 0x5B0B, 0xBE37, 0x29C6, 0x08A3, 0x2145, 0x5B2C, 0xB5D6, 0x8492, 0x84B2, 0x8492, 0x8CD3, 0xADD6, 0x8CB2, 
        0x84B2, 0x7C51, 0x8451, 0xB5D6, 0x2985, 0x0881, 0x4289, 0xA575, 0x8C91, 0x1081, 0x10A2, 0x5B0C, 0xADD6, 0x6BCE, 0x29A6, 0x4289, 0x94D3, 0xBE37, 0x4A88, 0x18E2, 0x4289, 0x9513, 0xADD6, 0x8D13, 0x8D14, 0x7C91, 0xA595, 0x9513, 0x7450, 0x6BEF, 
        0x8491, 0x73EE, 0x41E7, 0x6B4C, 0x73CE, 0x9491, 0x7BAE, 0x8450, 0xADB5, 0x8CF2, 0x9D54, 0x73AD, 0x5AC9, 0x5AC9, 0x4A68, 0x4A67, 0x4247, 0x4227, 0x4227, 0x4227, 0x4206, 0x4206, 0x39E5, 0x4206, 0x4226, 0x4206, 0x4206, 0x4206, 0x39E5, 0x39E6, 
        0x39E5, 0x39E5, 0x39C5, 0x39C5, 0x39C5, 0x39C5, 0x39E5, 0x39C5, 0x31A5, 0x3184, 0x31A4, 0x39C5, 0x3A06, 0x39C5, 0x31C5, 0x31A5, 0x31A5, 0x3184, 0x3184, 0x2984, 0x2984, 0x2964, 0x2964, 0x3185, 0x31C5, 0x39C5, 0x39C5, 0x31A5, 0x31A5,
  0x942E, 0x83CD, 0x8BED, 0x942E, 0x942E, 0x942E, 0x942D, 0x83AC, 0x7BAC, 0x83CC, 0x8BED, 0x83CC, 0x942E, 0xA48F, 0x9C4E, 0x9C6E, 0x942E, 0x8BED, 0x8C0D, 0x83AC, 0x6B4A, 0x7B8B, 0x736B, 0x7B8B, 0x8C0D, 0x940D, 0x940D, 0x8BED, 0x942D, 0x9C6E, 0x9C4D, 
        0x9C4D, 0x9C2D, 0x8BEC, 0x9C2D, 0x9C2D, 0x9C2D, 0x9C2D, 0x942D, 0x942E, 0x9C4E, 0x9C4E, 0x9C6F, 0x942E, 0x940D, 0x942E, 0x940D, 0x93ED, 0x83CC, 0x83CC, 0x8BEC, 0x940D, 0x9C6E, 0xA48F, 0x9C4E, 0x8BED, 0x940D, 0xA46E, 0x9C6E, 0x942D, 0x9C4E, 
        0x9C4E, 0x942D, 0x83AC, 0x8BED, 0x942E, 0x83AC, 0x7BAC, 0x8BED, 0x83CC, 0x83AC, 0x8BED, 0x940D, 0x8BED, 0x940D, 0x942E, 0x942E, 0x942D, 0x9C4E, 0x93ED, 0x8BED, 0x8C0D, 0x8C0D, 0x940D, 0x940D, 0x9C4E, 0x9C4E, 0x9C4E, 0x944E, 0x9C6F, 0x9C8F, 
        0xA4B0, 0x9C8F, 0x8C2E, 0x8C2E, 0x942E, 0x8C2E, 0x8C2E, 0x944E, 0x8C0E, 0x942E, 0x83ED, 0x840D, 0x944E, 0x9C90, 0x9C6F, 0x944F, 0x8C0E, 0x8C2E, 0x944F, 0x944F, 0x8C2E, 0x8C4F, 0x8C4E, 0x944F, 0x8C2E, 0x8C0E, 0x8C4F, 0x944F, 0x944F, 0x83ED, 
        0x83ED, 0x8C0D, 0x8C2E, 0x8C2E, 0x8C0E, 0x8C0E, 0x8BED, 0x8C0D, 0x8BED, 0x8C2E, 0x9C6F, 0xAD11, 0xAD11, 0xB531, 0x9CB0, 0x9C90, 0x9CB0, 0x944F, 0x8C0D, 0x840D, 0x83ED, 0x8C2E, 0x9C90, 0x944F, 0x944F, 0x9C90, 0x9C90, 0x9C90, 0xAD11, 0xB531, 
        0xB511, 0xAD11, 0xAD12, 0xAD12, 0x9CB0, 0x83ED, 0x840E, 0x840E, 0x83EE, 0x83EE, 0x83ED, 0x946F, 0xACF1, 0xB532, 0xB531, 0xB532, 0xB552, 0xB573, 0xB572, 0xBD72, 0xB552, 0xB552, 0xB552, 0xAD11, 0xB552, 0xBD72, 0xBD72, 0xA4B0, 0x9C6F, 0x942E, 
        0x942E, 0x9CB0, 0xA4D0, 0xA4B0, 0x9C8F, 0x9C90, 0x940D, 0x940D, 0x9C4E, 0xAD11, 0xB532, 0xACF1, 0xACF1, 0xACF1, 0xA4D1, 0xA4D0, 0xACF1, 0xB511, 0xACF1, 0xACF1, 0x9C6F, 0x83ED, 0x7BCD, 0x83CD, 0x8C0E, 0x944F, 0x946F, 0x9C6F, 0x9C6F, 0x9C6F, 
        0x942E, 0x944F, 0x944F, 0x8C0E, 0x8C0E, 0x8C2E, 0x8C0E, 0x8C0E, 0x944E, 0x944E, 0x9C8F, 0x9C8F, 0x9C6F, 0x9C6F, 0x9C8F, 0x944E, 0x942E, 0x944E, 0x942D, 0x942E, 0xA48F, 0x944E, 0x8C2E, 0x942E, 0x942E, 0x9C8F, 0x9C6F, 0x944E, 0x9C6F, 0xA4B0, 
        0xA48F, 0xA48F, 0x9C8F, 0x942E, 0x8C0E, 0x942E, 0x946F, 0x9C90, 0xA4F1, 0x944F, 0x8C0E, 0x946F, 0x9C6F, 0x944F, 0x944F, 0x942E, 0x8C0D, 0x8BED, 0x8BED, 0x942E, 0xA4AF, 0x9C6F, 0x942E, 0x9C4E, 0x9C6E, 0x9C6E, 0x9C90, 0xA4B0, 0x9CB0, 0x9C90, 
        0x9CB0, 0x944F, 0x942F, 0x944F, 0x9C90, 0x9CB0, 0x944E, 0x942E, 0x942E, 0x8C2E, 0x942E, 0xA48F, 0xA4AF, 0xA4AF, 0xA4D0, 0x9C90, 0x944E, 0x83CC, 0x7B8B, 0x8BCC, 0x942D, 0x9C8F, 0x946F, 0x946F, 0x9C6F, 0xAD11, 0xAD11, 0xACD0, 0x9C4E, 0x9C4F, 
        0x944F, 0x942E, 0x942E, 0x942E, 0x944E, 0x944F, 0x946F, 0x948F, 0x944F, 0x944F, 0x9C90, 0x7BAD, 0x630A, 0x946F, 0x9C6F, 0xA4B0, 0x83ED, 0x946E, 0xAD11, 0x9CB0, 0x94B0, 0x9CD1, 0x94B0, 0x7410, 0x8C90, 0x94B0, 0x52CA, 0x3A28, 0x52CB, 0x634D, 
        0x52CA, 0x2944, 0x2924, 0x0042, 0x4228, 0x7BEE, 0x5ACA, 0x3186, 0x4A69, 0x6B6C, 0x636C, 0x5B2B, 0x4289, 0x4268, 0x3208, 0x3A28, 0xB5D6, 0x4ACA, 0x3A28, 0x3A48, 0x8C91, 0x8470, 0x3A48, 0x4A8A, 0x4A89, 0x4248, 0x94B2, 0x8450, 0x4289, 0x4ACA, 
        0x3A49, 0x634D, 0xBE17, 0x3A28, 0x4269, 0x530C, 0x5B2C, 0x9D34, 0x7430, 0x532C, 0x4AEB, 0x3A69, 0x8471, 0x6B4C, 0x0820, 0x2145, 0x0882, 0x4A8A, 0xBE37, 0x4289, 0x1104, 0x29C7, 0x634D, 0xADD6, 0x84B2, 0x9514, 0x8CD2, 0x84B2, 0xB5D6, 0x9554, 
        0x8CF3, 0x7C92, 0x7C30, 0xB5D6, 0x3206, 0x10C2, 0x4ACB, 0x9D55, 0x9513, 0x10C2, 0x10A2, 0x4AAA, 0xA575, 0x6BEE, 0x2185, 0x4ACB, 0x8CB2, 0xBE37, 0x52EA, 0x2144, 0x52EB, 0x94D2, 0xADD6, 0x8D13, 0x9534, 0x84B2, 0xADB6, 0x8CF3, 0x7C71, 0x8491, 
        0x8491, 0x6BCE, 0x39E6, 0x634C, 0x7C30, 0x7C0F, 0x738D, 0x7C30, 0xA595, 0xA574, 0xA554, 0x73EE, 0x5ACA, 0x52CA, 0x39E6, 0x39E5, 0x31C5, 0x39C5, 0x31A5, 0x31A5, 0x31A5, 0x31A5, 0x31C5, 0x2944, 0x3184, 0x39C5, 0x39E5, 0x41E6, 0x4206, 0x4226, 
        0x4226, 0x4A47, 0x4A67, 0x4A67, 0x4A67, 0x4A47, 0x4A67, 0x4A47, 0x4A47, 0x4A67, 0x5287, 0x5AA8, 0x5AC8, 0x52A8, 0x52A8, 0x52A8, 0x4A88, 0x4A87, 0x4A68, 0x4A67, 0x4A67, 0x4A67, 0x4A47, 0x4A47, 0x4A68, 0x4A68, 0x5288, 0x52A9, 0x5AC9,
  0x944E, 0x8BED, 0x83AC, 0x940D, 0x942D, 0x942E, 0x940D, 0x83AC, 0x7B8B, 0x7BAB, 0x83CC, 0x83CC, 0x83EC, 0x944E, 0x9C4E, 0x9C4E, 0x9C4E, 0x8C0D, 0x83CD, 0x7B8B, 0x736B, 0x7BAC, 0x83CC, 0x7B8B, 0x83ED, 0x940D, 0x940D, 0x8BED, 0x8C0D, 0x942D, 0x940D, 
        0x940D, 0x942D, 0x8BEC, 0x8BED, 0x940D, 0x942D, 0x942D, 0x940D, 0x8C0D, 0x942D, 0x940D, 0x942E, 0x942E, 0x8BED, 0x8BED, 0x942D, 0x8BED, 0x83AC, 0x83CC, 0x8BED, 0x83CD, 0x8BED, 0x8BED, 0x83CD, 0x83AC, 0x8BED, 0x9C4E, 0x9C4E, 0x944E, 0x944E, 
        0x944E, 0x83CC, 0x8C0D, 0x940E, 0x944E, 0x83ED, 0x7BAC, 0x7B8C, 0x738C, 0x738C, 0x83CD, 0x8C2E, 0x942E, 0x946F, 0x944F, 0x944E, 0xA4AF, 0xA4B0, 0x944E, 0x9C90, 0x9C8F, 0x9C6F, 0x9C6F, 0x9C6F, 0xACD0, 0xACF0, 0xA4D0, 0xA4D0, 0xA4D0, 0xA4D0, 
        0xA4F1, 0xA4F1, 0xA4F1, 0x9CB0, 0x9CB0, 0xA4B0, 0xA4F1, 0xAD11, 0xA4F0, 0xA4B0, 0x9C8F, 0x942E, 0x9C8F, 0xB573, 0xBD73, 0xB532, 0xA4D0, 0x9CB0, 0xA4D0, 0xA4D1, 0x9C90, 0x9C90, 0x9C90, 0x9CB0, 0x9C90, 0x946F, 0x9C8F, 0x9C90, 0x9C90, 0x946F, 
        0x942E, 0x944E, 0x944E, 0x946F, 0x944E, 0x944E, 0x944E, 0x942E, 0x946F, 0x9C6F, 0x9C6F, 0xACF0, 0xB532, 0xAD11, 0xAD12, 0x9C90, 0x9C90, 0x9490, 0x944F, 0x8C0E, 0x8C0E, 0x83ED, 0x946F, 0x9CB0, 0x944E, 0x8C2E, 0x944F, 0x944E, 0xA4D0, 0xAD11, 
        0xAD11, 0xACF1, 0x9CB0, 0xA4F1, 0xAD12, 0x946F, 0x7BED, 0x83EE, 0x83EE, 0x840E, 0x83ED, 0x8C2E, 0x9C90, 0xA4F1, 0xA4D0, 0xA4B0, 0xACF0, 0xAD31, 0xB552, 0xB552, 0xAD11, 0xAD11, 0xAD11, 0xA4D0, 0x9C8F, 0xA4AF, 0xB531, 0xACF0, 0x9C6F, 0x942E, 
        0x940E, 0x940D, 0x942E, 0x942E, 0x942D, 0x9C6E, 0x942E, 0x940D, 0x940D, 0x9C6F, 0xA48F, 0x9C8F, 0x9CB0, 0xA4D0, 0xA4D0, 0xA4B0, 0x9C8F, 0x946F, 0x9C90, 0x9CB0, 0x9C6F, 0x942E, 0x7BAC, 0x7BAC, 0x7BAC, 0x83CD, 0x8C0E, 0x942E, 0x944E, 0x9C8F, 
        0x9C8F, 0x9C8F, 0x9C90, 0x9C6F, 0x944F, 0x8C0E, 0x944E, 0x9C90, 0x9C8F, 0x9C6F, 0x9C4E, 0x9C6F, 0x9C6F, 0x946F, 0x944E, 0x942E, 0x942E, 0xA4B0, 0x9C6F, 0x944F, 0xA4B0, 0xACD0, 0x942E, 0x8C0E, 0x8C2E, 0x944F, 0x944F, 0x942E, 0x9C8F, 0xB532, 
        0xB531, 0xB511, 0xBD31, 0xB511, 0x9C6F, 0x942E, 0x944F, 0x944E, 0x9C8F, 0x946F, 0x942E, 0x9C6F, 0xA4B0, 0x9C8F, 0x9C6F, 0x9C8F, 0x944F, 0x942E, 0x942E, 0x944E, 0x9C8F, 0xA4B0, 0xA48F, 0x9C6F, 0x9C8F, 0x9C6E, 0x9C8F, 0xA4D0, 0xA4D0, 0xA4B0, 
        0xA4B0, 0x9C6F, 0x8C2E, 0x8C2E, 0x944E, 0x9C6F, 0x944E, 0x942E, 0x942E, 0x942E, 0x8C2E, 0x9C4E, 0xA48F, 0x9C8E, 0x9C6E, 0x944E, 0x8C0D, 0x83AC, 0x6B2A, 0x62E9, 0x7B6B, 0x8C0D, 0x8C0D, 0x942E, 0x8C0D, 0x944F, 0x9C8F, 0xA48F, 0x9C6F, 0x944F, 
        0x942E, 0x942E, 0x942E, 0x942E, 0x942E, 0x942E, 0x8C0E, 0x944E, 0x8C2E, 0x8C2E, 0x8C2E, 0x630B, 0x7BAC, 0x8C2E, 0x8C0E, 0x942E, 0x83ED, 0x83ED, 0x8BED, 0x9CB0, 0x840E, 0x630A, 0x9CF2, 0x7C51, 0x9CD1, 0x9CD1, 0x73EE, 0x4289, 0x4ACA, 0x5B0C, 
        0x4A68, 0x3985, 0x18C3, 0x20C2, 0x5AA9, 0x634C, 0x3A4A, 0x2187, 0x31C7, 0x6B8D, 0x6B6C, 0x636C, 0x5B2C, 0x530B, 0x4AAA, 0x8471, 0x8CD3, 0x2A09, 0x530C, 0x532C, 0x8CB2, 0x9D13, 0x530B, 0x5B4D, 0x5B2C, 0x4AAB, 0x94D2, 0x8CD2, 0x532C, 0x5B6D, 
        0x530C, 0x6B8E, 0xBE37, 0x4289, 0x532D, 0x5B8E, 0x638E, 0x9D13, 0x8491, 0x5B8E, 0x534D, 0x42CB, 0x8471, 0x73AD, 0x0840, 0x2986, 0x0082, 0x3A08, 0xB5F7, 0x4ACA, 0x1945, 0x31E8, 0x636D, 0xADB6, 0x8CD3, 0x8CD3, 0x84D2, 0x7C51, 0xADD6, 0x9D75, 
        0x9534, 0x84D2, 0x7410, 0xB5F6, 0x3A47, 0x10C2, 0x5B2C, 0x9D34, 0xA554, 0x18E3, 0x18E3, 0x52CA, 0x9D33, 0x7C30, 0x29C6, 0x4ACA, 0x8471, 0xBE58, 0x5B2B, 0x2165, 0x5B6D, 0x8CB2, 0xADD6, 0x8CF3, 0x9534, 0x7451, 0xA595, 0x9534, 0x8CF3, 0x9533, 
        0x742F, 0x7C0F, 0x3207, 0x530B, 0x7C30, 0x8C91, 0x94B2, 0x9D13, 0xADB6, 0xADD6, 0xADB6, 0xA554, 0xA554, 0x844F, 0x5AE9, 0x5AE9, 0x5AC9, 0x5AC9, 0x5AA8, 0x5AA8, 0x5AA8, 0x5AC9, 0x5AC9, 0x52A9, 0x52A9, 0x5AC9, 0x5AE9, 0x5AE9, 0x630A, 0x5AE9, 
        0x5AE9, 0x6309, 0x632A, 0x5AE9, 0x630A, 0x6309, 0x5B09, 0x5AC9, 0x52C9, 0x5AC9, 0x5AE9, 0x5AE9, 0x5AC9, 0x5AC9, 0x52A9, 0x52C9, 0x52C9, 0x52C9, 0x52C9, 0x52A9, 0x52C9, 0x52A9, 0x5AC9, 0x5AE9, 0x52C9, 0x52A9, 0x4A88, 0x4AA9, 0x4AA9,
  0x7BAC, 0x7BAC, 0x7B8C, 0x83CC, 0x83CD, 0x83CC, 0x7B8B, 0x7BAC, 0x83AC, 0x83CC, 0x83CC, 0x83AC, 0x83ED, 0x8C0E, 0x8C2E, 0x942E, 0x944E, 0x8C0E, 0x8C0D, 0x83CD, 0x738C, 0x7B8B, 0x83CD, 0x83CD, 0x7BAC, 0x8C0D, 0x942E, 0x942E, 0x944E, 0x944E, 0x944E, 
        0x944E, 0x944E, 0x9C4E, 0x944E, 0x9C6F, 0x9C8F, 0x9C8F, 0x9C6F, 0x9C8F, 0xA48F, 0xA48F, 0xA48F, 0x9C8F, 0x9C8F, 0xA4D0, 0xACF0, 0x9CB0, 0x83ED, 0x83ED, 0x8C0D, 0x8C2E, 0x8C0D, 0x8C0D, 0x8C2E, 0x8C2E, 0x944E, 0xA4B0, 0xACF1, 0xA4D0, 0xACD1, 
        0xACF1, 0x9C8F, 0xA490, 0xA4D0, 0x9C8F, 0x9C8F, 0x8C0E, 0x83CD, 0x7BCD, 0x7BCD, 0x7BED, 0x946F, 0x9CB0, 0x9CB0, 0x9C90, 0x9C90, 0xA4F1, 0xACF0, 0xA4B0, 0xA4B0, 0xA4D0, 0xA4D0, 0xA4D0, 0xA48F, 0xA4D0, 0xA4D0, 0x9C8F, 0xA4D0, 0xAD11, 0xACD1, 
        0xA4D1, 0xAD11, 0xAD11, 0xAD11, 0xA511, 0x9CB0, 0x9C8F, 0x9CB0, 0xA4D0, 0xA4D0, 0xA4D0, 0xACD0, 0xA4D0, 0xAD11, 0xB573, 0xBD73, 0xB552, 0xA4B0, 0xA4B0, 0xA4B0, 0x9C8F, 0x944E, 0x944F, 0x944F, 0x944F, 0x8C4E, 0x8C2E, 0x944E, 0x944F, 0x944F, 
        0x942F, 0x8C0E, 0x83ED, 0x8C0E, 0x8C0E, 0x8C0E, 0x8C0D, 0x83CD, 0x83ED, 0x8C0E, 0x942E, 0x942E, 0x944F, 0x944F, 0x944F, 0x944F, 0x8C2F, 0x946F, 0x946F, 0x8C0E, 0x83ED, 0x7BAD, 0x7BCD, 0x8C2E, 0x8C2E, 0x8C0D, 0x83ED, 0x8C0D, 0x8C2E, 0x944E, 
        0x8C2E, 0x942E, 0x944E, 0x9C6F, 0xA48F, 0x9C6F, 0x8C0D, 0x8BED, 0x8BED, 0x8BCD, 0x8C0E, 0x8C0E, 0x8C2E, 0x944F, 0x944E, 0x8C0D, 0x9C4E, 0xA4AF, 0xACF0, 0xAD11, 0xAD32, 0xAD32, 0xA4D0, 0x9C8F, 0xA4AF, 0xA48F, 0xA4AF, 0xAD11, 0xB552, 0xACF0, 
        0xA48F, 0x9C8F, 0x942E, 0x9C4E, 0x8BED, 0x9C6F, 0xACD0, 0xA4B0, 0x9C6E, 0x942E, 0x940D, 0x942D, 0x9C8F, 0xACF1, 0xA4D1, 0xACF1, 0xA4D0, 0x944E, 0x8C2E, 0x944E, 0x946F, 0x944F, 0x83ED, 0x7BAC, 0x7BAC, 0x7BAC, 0x8C0D, 0x944E, 0x946F, 0x9470, 
        0xA4B0, 0x9C90, 0x9C90, 0xA4D1, 0xA4D1, 0xA4B0, 0x9C6F, 0x9C8F, 0xA490, 0xA48F, 0x9C6F, 0x9C4E, 0x944E, 0x942E, 0x8C0E, 0x942E, 0x942E, 0x9C6F, 0x9C90, 0x944E, 0x9C90, 0xA4B0, 0x9C8F, 0x8C0E, 0x8C0E, 0x8C0E, 0x942E, 0x944F, 0x944E, 0x946F, 
        0x9CB0, 0x9C8F, 0xACD0, 0xACAF, 0xA48F, 0x8C0E, 0x8C2E, 0x942E, 0x942E, 0x8C0E, 0x83CC, 0x8BCD, 0x942E, 0x944E, 0x942E, 0x942E, 0x942E, 0x8C2E, 0x942E, 0x942E, 0x942E, 0x9C6F, 0x9C6F, 0x9C6E, 0x942E, 0x940D, 0x940E, 0x944E, 0x944F, 0x944E, 
        0x942E, 0x942E, 0x8C0E, 0x8C0E, 0x83ED, 0x8C0D, 0x8C0D, 0x944E, 0x946F, 0x8C0D, 0x8C0E, 0x8C0E, 0x8C0D, 0x83ED, 0x83CD, 0x83AC, 0x7B8C, 0x736B, 0x6B0A, 0x4A47, 0x4A47, 0x62C9, 0x734A, 0x738B, 0x738B, 0x7BAC, 0x7B8B, 0x736B, 0x6B2A, 0x62E9, 
        0x62E9, 0x62C9, 0x62E9, 0x62E9, 0x62EA, 0x630A, 0x630A, 0x62C9, 0x5AC9, 0x5AC9, 0x634B, 0x4AAA, 0x4A68, 0x4A68, 0x4A47, 0x5288, 0x7C0E, 0x5288, 0x4206, 0x840E, 0x83ED, 0x41C5, 0x6BAE, 0x7431, 0x94D1, 0x94B1, 0x73EF, 0x4A89, 0x4AAA, 0x428A, 
        0x4A89, 0x39C7, 0x0041, 0x4165, 0x6ACA, 0x4ACB, 0x3A6C, 0x1988, 0x3A29, 0x6B6D, 0x5B4C, 0x638E, 0x6BAE, 0x636E, 0x6BAE, 0xB5F7, 0x3AAC, 0x2A0A, 0x63CF, 0x63AF, 0x8C92, 0xAD75, 0x6BAE, 0x6BCF, 0x6BCF, 0x636D, 0x8CB2, 0x9D13, 0x6BAF, 0x6BCF, 
        0x6BAF, 0x73F0, 0xB617, 0x4ACA, 0x63AF, 0x7410, 0x6BEF, 0x9514, 0x8492, 0x63AF, 0x5B6E, 0x4B0C, 0x7C51, 0x7C0F, 0x10A2, 0x29C7, 0x10E4, 0x31E8, 0xB5D6, 0x5B4C, 0x2186, 0x3249, 0x636D, 0xAD95, 0x9514, 0x8CF3, 0x8CF3, 0x7C30, 0xADB6, 0x9D54, 
        0x9534, 0x8CF3, 0x73EF, 0xADD6, 0x4288, 0x08A2, 0x638E, 0x8CD2, 0xAD95, 0x10E2, 0x10E3, 0x4ACA, 0x8C92, 0x94F2, 0x6B8D, 0x6BAE, 0x8CD2, 0xBE58, 0x6B8D, 0x29C7, 0x5B4D, 0x8471, 0xB617, 0xA5B6, 0xADF7, 0x9D55, 0xB617, 0xA595, 0x9D75, 0xA595, 
        0x94F3, 0x8471, 0x3A69, 0x4AAB, 0x6BAE, 0x94F3, 0xB5B6, 0xA555, 0xADB6, 0xA596, 0xADB6, 0xADB6, 0xA5B6, 0x8470, 0x4268, 0x4AA9, 0x52A9, 0x52A9, 0x52C9, 0x52C9, 0x5AE9, 0x52C9, 0x5AEA, 0x5AEA, 0x4A89, 0x4268, 0x4268, 0x4A88, 0x52A9, 0x52A9, 
        0x4AA9, 0x4A88, 0x4A88, 0x4A88, 0x4AA9, 0x4A88, 0x4A88, 0x4A88, 0x4268, 0x4A88, 0x4A68, 0x4A68, 0x4268, 0x4248, 0x4A68, 0x4268, 0x4268, 0x4268, 0x4268, 0x4268, 0x4A88, 0x4A88, 0x4A88, 0x4A89, 0x4A89, 0x4AA9, 0x4A88, 0x4288, 0x4288,
  0x73AC, 0x73AC, 0x73AC, 0x7BAC, 0x7BCD, 0x83ED, 0x7BAC, 0x8C0D, 0x9C6E, 0x9C6E, 0x9C6E, 0x942E, 0x8C0D, 0x944F, 0x9C8F, 0x9C8F, 0x9C8F, 0x9C8F, 0x946F, 0x946F, 0x83EE, 0x7BAC, 0x7B8C, 0x7BAC, 0x7BAC, 0x8C0D, 0x9C8F, 0x9C8F, 0xA4B0, 0xA4D0, 0x9C8F, 
        0x9CAF, 0xA48F, 0xA4AF, 0xA4AF, 0x9C8F, 0x9C8F, 0x9C8F, 0x9CB0, 0x9CB0, 0xA4B0, 0xA4D0, 0xA4D0, 0xA4F0, 0x9CB0, 0xA4D0, 0xACF0, 0xAD11, 0x9CB0, 0x8C0D, 0x83ED, 0x8C0D, 0x8C0D, 0x8C2E, 0x944E, 0x9C6F, 0x9C8F, 0xA4D0, 0xA4B0, 0xA4B0, 0xA4B0, 
        0xA4D0, 0xACF1, 0xA4D0, 0xACD0, 0x9C8F, 0x9CB0, 0x944F, 0x7BCD, 0x7BCD, 0x7BCD, 0x7BCD, 0x840E, 0x8C4E, 0x946F, 0x8C4F, 0x9490, 0x9C8F, 0xA4B0, 0xA4B0, 0x9C8F, 0xA4B0, 0xA4D0, 0xA4B0, 0x9C8F, 0x944E, 0x944E, 0x946F, 0x9C8F, 0x9CB0, 0x9C90, 
        0x9C70, 0x9C90, 0x9C90, 0x948F, 0x9C8F, 0x8C2E, 0x83ED, 0x83ED, 0x83CD, 0x8C0D, 0x944E, 0x946F, 0x946F, 0x9C8F, 0xA4D0, 0xAD11, 0xAD11, 0xA4B0, 0x9C8F, 0x9C8F, 0x9C8F, 0x8C2D, 0x8C0D, 0x948F, 0x9C6F, 0x944F, 0x942E, 0x83CD, 0x7BCD, 0x842E, 
        0x8C2F, 0x8C2E, 0x8C2E, 0x8C0E, 0x8C0E, 0x8C2E, 0x83ED, 0x7BCC, 0x7BAC, 0x83ED, 0x83ED, 0x83EE, 0x8C2E, 0x8C0E, 0x840E, 0x944F, 0x944F, 0x944F, 0x944F, 0x8C2E, 0x8C0E, 0x8C2F, 0x9490, 0x946F, 0x8C4E, 0x946F, 0x8C0D, 0x8BED, 0x8C0E, 0x8BED, 
        0x83CD, 0x83ED, 0x944E, 0xB4F0, 0xB531, 0xB510, 0xA4AF, 0x9C2E, 0x8BED, 0x8BCC, 0x93ED, 0x942E, 0x942E, 0x8C0D, 0x8C0D, 0x8BED, 0x940D, 0x9C4E, 0xA46E, 0xA48F, 0xAD11, 0xAD32, 0xA4F1, 0x9C6F, 0x9C4E, 0x9C6E, 0x9C4E, 0xA4AF, 0xB531, 0xBD72, 
        0xACF0, 0x9C8F, 0x944E, 0x944E, 0x8C0D, 0x942E, 0xACF0, 0xA4D0, 0xA48F, 0x944E, 0x9C4E, 0x9C4E, 0x944E, 0x9C8F, 0x9C90, 0xA4D0, 0xA4B0, 0x944F, 0x8C2E, 0x8C2E, 0x942E, 0x8C2E, 0x8BED, 0x83AC, 0x7BAC, 0x736B, 0x736B, 0x83CC, 0x8C0E, 0x8C2E, 
        0x8C2E, 0x944F, 0x942E, 0x944E, 0x944F, 0x9C4F, 0x944E, 0x83ED, 0x8BED, 0x8BED, 0x8C0D, 0x8BED, 0x8BED, 0x942E, 0x8C0E, 0x7BAC, 0x8C0D, 0x942E, 0x942E, 0x8BED, 0x8C0E, 0x83ED, 0x8C0D, 0x83ED, 0x83AC, 0x8C0D, 0x942E, 0x940D, 0x8C0D, 0x8C0D, 
        0x8C0D, 0x8C0D, 0x942D, 0x940D, 0x940D, 0x942E, 0x8BED, 0x8BED, 0x940D, 0x8C0D, 0x83CD, 0x83AC, 0x8BED, 0x8BEC, 0x83ED, 0x83CC, 0x83CC, 0x83CC, 0x8BED, 0x83CC, 0x83AC, 0x7B8C, 0x7B8C, 0x7BAC, 0x736B, 0x6B2A, 0x6B09, 0x62C9, 0x62C9, 0x5AA9, 
        0x5AA9, 0x5AA9, 0x5AA9, 0x5AC9, 0x5AA9, 0x5268, 0x4A47, 0x4A47, 0x4A67, 0x4A47, 0x4A47, 0x4A47, 0x4227, 0x4206, 0x41E6, 0x39C6, 0x39C5, 0x39C5, 0x39C6, 0x3185, 0x31A5, 0x39A5, 0x39A5, 0x39C5, 0x39C5, 0x31A5, 0x3185, 0x3184, 0x2984, 0x2964, 
        0x3184, 0x3185, 0x3185, 0x3185, 0x3185, 0x2985, 0x31A6, 0x31A6, 0x31A6, 0x31E8, 0x5B2D, 0x3A28, 0x2965, 0x2985, 0x2985, 0x39E7, 0x73CE, 0x31E6, 0x2985, 0x7BCD, 0x4A48, 0x39E7, 0x21C8, 0x534D, 0x7BEF, 0x8450, 0x73EF, 0x4AAA, 0x4A8A, 0x3A49, 
        0x3A69, 0x18E4, 0x0020, 0x2903, 0x62AA, 0x3A29, 0x3209, 0x1126, 0x428A, 0x636D, 0x5B4C, 0x6BAF, 0x7410, 0x6BCF, 0x9D34, 0x9D55, 0x0107, 0x328C, 0x7410, 0x73F0, 0x8C92, 0xB5D6, 0x7C10, 0x7C10, 0x73EF, 0x6B8E, 0x8C92, 0x9D34, 0x6BCF, 0x6BF0, 
        0x6BCF, 0x6BF0, 0xB5D7, 0x5B2C, 0x636E, 0x6BD0, 0x63AF, 0x8CB3, 0x8CB2, 0x5B8E, 0x5B8E, 0x5B6E, 0x7410, 0x8C71, 0x4A69, 0x5B4D, 0x4AEC, 0x4AAB, 0xA575, 0x638D, 0x1145, 0x3249, 0x5B6D, 0x9D54, 0x9D55, 0x9514, 0x8D13, 0x73EF, 0xADB6, 0xA575, 
        0x9D55, 0x9D54, 0x7C50, 0xADB6, 0x9D13, 0x8C91, 0xA575, 0xADB6, 0xB617, 0x73EF, 0x8450, 0x9D34, 0xAD95, 0xBE38, 0xC658, 0xBE38, 0xBE38, 0xB617, 0xADB6, 0xA575, 0xA596, 0xAD96, 0xA596, 0xADD7, 0xADD7, 0xB5F7, 0xADD7, 0xADD6, 0xB5F7, 0xADD7, 
        0xADF7, 0x6C30, 0x11EA, 0x224B, 0x3A6A, 0x8472, 0x9D55, 0x5BB0, 0x9535, 0xADD7, 0xA5B7, 0x9576, 0x8D56, 0x74B4, 0x430D, 0x428A, 0x3A48, 0x3A48, 0x3A48, 0x4248, 0x4248, 0x4248, 0x4248, 0x4248, 0x3A48, 0x3A48, 0x3A48, 0x4248, 0x4248, 0x4268, 
        0x4268, 0x4248, 0x3A28, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A07, 0x3A27, 0x3A27, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x4248, 0x4248, 0x3A28, 0x3A28, 0x3A28, 0x3A48, 0x3A48,
  0x8C2E, 0x738C, 0x73AC, 0x7BAC, 0x73AC, 0x7BAC, 0x7BAC, 0x8C0D, 0xA48F, 0xA4AF, 0x9C6E, 0x9C8F, 0x942E, 0x944F, 0x9C8F, 0x9C8F, 0x9C8F, 0x9C8F, 0x946F, 0x944F, 0x8C0E, 0x7BAC, 0x7BAC, 0x7BCC, 0x83CD, 0x83CD, 0x9C8F, 0xA4B0, 0xA4B0, 0xA4D0, 0xA4B0, 
        0x9C8F, 0xA4AF, 0xA48F, 0xA4AF, 0x9C8F, 0x9C8F, 0x9C8F, 0x9C8F, 0x9C8F, 0x9C8F, 0x9C8F, 0x9C8F, 0x9C8F, 0x9C8F, 0x944E, 0xA4F0, 0xA4F0, 0xA4F1, 0x9C6F, 0x8C2E, 0x8BED, 0x8C0D, 0x942E, 0x946F, 0x9C6F, 0x9C8F, 0x9CB0, 0x9C6F, 0x946F, 0x9C6F, 
        0x9CB0, 0x9C90, 0x944F, 0x944E, 0x946E, 0x9C8F, 0x9C6F, 0x83ED, 0x7BAC, 0x7BCD, 0x83ED, 0x83ED, 0x7BCD, 0x7BCD, 0x83ED, 0x8C2E, 0x946F, 0x9C8F, 0xA4B0, 0xA4B0, 0xA4D0, 0xA4F0, 0x9C8F, 0x9C6F, 0x944E, 0x944F, 0x942E, 0x7BCC, 0x83ED, 0x83ED, 
        0x8C2F, 0xA4B0, 0x9CB0, 0xA4B0, 0xA4D0, 0x944F, 0x8BED, 0x83ED, 0x83AD, 0x83CD, 0x83ED, 0x83CD, 0x83ED, 0x944F, 0x946F, 0xAD11, 0xB531, 0xAD11, 0xACF1, 0xACF1, 0xB511, 0xACD0, 0x9C8F, 0x9C8F, 0xACF1, 0xA4F1, 0xAD11, 0xA4D1, 0x942F, 0x840E, 
        0x8C2E, 0x8C2E, 0x8C2E, 0x8C2E, 0x8C0E, 0x8C0E, 0x8C0E, 0x83CD, 0x7B8C, 0x83CC, 0x83ED, 0x83ED, 0x8C2E, 0x942F, 0x8C2E, 0x946F, 0x946F, 0x944F, 0x944F, 0x942E, 0x8C0E, 0x946F, 0x9CB0, 0x9490, 0x8C2E, 0x9CB0, 0xA4AF, 0x8C0D, 0x8C0D, 0x8BED, 
        0x83ED, 0x83ED, 0x8BED, 0xA48F, 0xB511, 0xB511, 0x9C6E, 0x8BEC, 0x83AB, 0x838B, 0x8BCC, 0x8BED, 0x8BED, 0x8BED, 0x8C0E, 0x8C0E, 0x8C0D, 0x942D, 0x9C4E, 0x9C2E, 0x944E, 0x9C8F, 0x944E, 0x8C2E, 0x8BED, 0x8BED, 0x8BED, 0x942E, 0x9C8F, 0xA4B0, 
        0x9C6F, 0x8BED, 0x8BED, 0x8BED, 0x83ED, 0x83AC, 0x8C0D, 0x942E, 0x942E, 0x8BED, 0x83CC, 0x8C0D, 0x8C0D, 0x8C0D, 0x8C2E, 0x8C2E, 0x942E, 0x942E, 0x8C0D, 0x8BED, 0x8BED, 0x83ED, 0x7BAC, 0x7BAC, 0x6B4A, 0x5AC9, 0x5AA8, 0x6B4A, 0x7BAC, 0x83ED, 
        0x83ED, 0x7BCD, 0x7BAC, 0x7B8C, 0x736B, 0x7B8B, 0x83AC, 0x736B, 0x6B09, 0x6B0A, 0x732B, 0x6B0A, 0x734B, 0x7BAC, 0x7B8C, 0x62E9, 0x6B2A, 0x736B, 0x734B, 0x6B2A, 0x6B2A, 0x6B2A, 0x5AE9, 0x62E9, 0x5AC9, 0x5AC9, 0x62A9, 0x5A88, 0x5267, 0x4A47, 
        0x4A47, 0x4A26, 0x4A27, 0x4A47, 0x5267, 0x5AC9, 0x5288, 0x5288, 0x5288, 0x4A67, 0x4A67, 0x4A27, 0x4227, 0x4226, 0x4227, 0x4206, 0x4206, 0x39E6, 0x39E6, 0x39E5, 0x39A5, 0x39C5, 0x31A5, 0x39C5, 0x31A5, 0x3185, 0x2964, 0x2964, 0x3185, 0x2965, 
        0x2965, 0x2965, 0x2965, 0x2985, 0x2985, 0x2985, 0x2964, 0x2964, 0x2964, 0x2964, 0x2964, 0x2964, 0x2965, 0x2985, 0x3185, 0x3185, 0x3185, 0x31A5, 0x3185, 0x31A5, 0x2964, 0x3185, 0x39C6, 0x39C6, 0x39C6, 0x39C6, 0x39E6, 0x39E6, 0x39E6, 0x39E6, 
        0x39E6, 0x39E6, 0x39C6, 0x39E6, 0x39E6, 0x4248, 0x3A49, 0x3A28, 0x426A, 0x3A6B, 0x2A0A, 0x428A, 0x4269, 0x4A8A, 0x4A8A, 0x52CB, 0x634D, 0x5B0C, 0x5AEB, 0x6B8D, 0x39C7, 0x2146, 0x19A9, 0x2A4A, 0x530C, 0x73CF, 0x73CF, 0x428B, 0x3A6A, 0x3A6A, 
        0x3A8B, 0x1946, 0x10E4, 0x3186, 0x526A, 0x3A09, 0x3A29, 0x3209, 0x42CC, 0x5B4D, 0x532D, 0x63AF, 0x7411, 0x8472, 0xBE38, 0x63B0, 0x0908, 0x42CD, 0x6BF0, 0x638F, 0x7410, 0xB5D6, 0x740F, 0x7C31, 0x7C10, 0x73F0, 0x8451, 0x9D34, 0x73F0, 0x7410, 
        0x73F0, 0x6BCF, 0xA595, 0x638D, 0x6BCF, 0x7C31, 0x6BF0, 0x8CB2, 0x8CB2, 0x63AF, 0x63AF, 0x5B6E, 0x7410, 0x8C91, 0x4269, 0x6BCE, 0x5B0C, 0x4AAA, 0x94F3, 0x8CD2, 0x5B4D, 0x7410, 0x8CD3, 0xADB6, 0xADD7, 0xADD6, 0xADB6, 0x9D54, 0xB5D6, 0xADD6, 
        0xADB6, 0xADB6, 0xA575, 0xADB6, 0xB5F7, 0xB5F7, 0xB5D7, 0xADD6, 0xAD96, 0xB5F7, 0xB5F7, 0xADD6, 0xADB6, 0xA575, 0x9D55, 0x9D55, 0x9D55, 0x9D55, 0xA575, 0xA596, 0xA596, 0xA575, 0x9D55, 0xA596, 0xA596, 0xA596, 0xA596, 0xB618, 0xA5F8, 0x9DB8, 
        0x8D77, 0x3B50, 0x0A6E, 0x126F, 0x19EB, 0x430E, 0x4B70, 0x1A0C, 0x3AEE, 0x63F1, 0x53B0, 0x4B6F, 0x432E, 0x42ED, 0x3AAC, 0x3A69, 0x3A28, 0x3A28, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x4248, 0x3A48, 0x3A48, 0x3A48, 0x4248, 0x3A48, 
        0x3A48, 0x3A27, 0x3A27, 0x3A27, 0x3A28, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A28, 0x3A28, 0x4248, 0x4268, 0x4248, 0x4248, 0x3A48, 0x4248, 0x4248, 0x4268, 0x3A48, 0x3A48, 0x3A28,
  0x8C0E, 0x7BAC, 0x73AC, 0x7BAC, 0x7BAC, 0x7BCD, 0x83ED, 0x83CC, 0x942E, 0x944E, 0x944E, 0x9C6F, 0x944E, 0x83ED, 0x8C0D, 0x840D, 0x8C2E, 0x8C2E, 0x840D, 0x840D, 0x8C0E, 0x7BCD, 0x7BAC, 0x738C, 0x7BCC, 0x7BAC, 0x7BCC, 0x8C2E, 0x8C0D, 0x944F, 0x9C6F, 
        0x946F, 0x9C8F, 0x9C6F, 0x942E, 0x942E, 0x8C2E, 0x8C0D, 0x9C8F, 0xA4D0, 0x9CAF, 0xA4D0, 0xA4F0, 0x944E, 0x942E, 0x8C2E, 0x944F, 0x8C0E, 0x8C0D, 0x8C0D, 0x8BED, 0x942E, 0x8C2D, 0x944E, 0x9C8F, 0x9C8F, 0x9CB0, 0xA4D0, 0xA4D0, 0x9C8F, 0x9C8F, 
        0x9C8F, 0x944F, 0x9C6F, 0x942E, 0x8C0E, 0x946F, 0x9C8F, 0x9C8F, 0x83ED, 0x83ED, 0x8C0E, 0x8C2E, 0x83ED, 0x738C, 0x7BAC, 0x8C0D, 0x9C6F, 0xAD11, 0xAD11, 0xAD31, 0xAD11, 0xAD11, 0xA4D0, 0xA4D0, 0xA4D0, 0xA4B0, 0xACD0, 0x8BED, 0x83CD, 0x83ED, 
        0x83ED, 0x9CD0, 0xA4D0, 0xA4B0, 0x9C90, 0x9C8F, 0x940E, 0x8C0D, 0x8BED, 0x83CD, 0x83CD, 0x83ED, 0x8BED, 0x8C0D, 0x8C0D, 0x9C8F, 0xB532, 0xAD11, 0xA4D0, 0xA4B0, 0xA4D0, 0x9CAF, 0x9C8F, 0x944E, 0x946F, 0xA4D0, 0xACF1, 0xA4D0, 0x946F, 0x8C0E, 
        0x840E, 0x8C0E, 0x8C0E, 0x8C0E, 0x8C0D, 0x8C0D, 0x83ED, 0x83CC, 0x736B, 0x6B4A, 0x734A, 0x7BAC, 0x83ED, 0x840D, 0x8C0E, 0x8C2E, 0x942E, 0x942E, 0x944E, 0x942E, 0x83CD, 0x83ED, 0x8C2E, 0x946F, 0x8C2E, 0x942E, 0x944E, 0x942D, 0x944E, 0x944E, 
        0x942E, 0x8C0D, 0x83CC, 0x8BEC, 0x8C0D, 0x940D, 0x942D, 0x8BCC, 0x83AC, 0x838B, 0x8BED, 0x8C0D, 0x8C0D, 0x8C0D, 0x83ED, 0x83CD, 0x7BAC, 0x7BAC, 0x83CC, 0x8C0D, 0x942D, 0x8C2E, 0x944E, 0x944E, 0x942E, 0x8C0D, 0x8BED, 0x83CC, 0x7B8B, 0x6B2A, 
        0x6B0A, 0x6B2A, 0x62E9, 0x62E9, 0x5AA8, 0x62C8, 0x62C8, 0x62E9, 0x62E9, 0x52A8, 0x5267, 0x5267, 0x52A8, 0x5AA8, 0x5AA8, 0x5A88, 0x5A88, 0x5AA8, 0x5288, 0x5267, 0x4A47, 0x4A46, 0x4226, 0x4227, 0x4206, 0x39C5, 0x31A5, 0x41E6, 0x4A47, 0x4A47, 
        0x4206, 0x39E6, 0x39C5, 0x39C5, 0x39A5, 0x39A5, 0x39C5, 0x39C5, 0x39A5, 0x31A5, 0x3185, 0x3185, 0x3185, 0x3185, 0x3185, 0x31A5, 0x31A5, 0x3185, 0x3184, 0x2964, 0x2964, 0x2984, 0x2964, 0x2964, 0x3185, 0x2964, 0x2964, 0x2944, 0x2964, 0x2964, 
        0x2964, 0x2964, 0x2964, 0x2964, 0x2964, 0x2964, 0x2984, 0x2944, 0x2964, 0x3185, 0x2984, 0x3185, 0x2984, 0x2984, 0x2985, 0x2985, 0x3185, 0x3185, 0x31A5, 0x31A5, 0x31A5, 0x3185, 0x31A5, 0x31A5, 0x39C5, 0x39C6, 0x41E6, 0x4206, 0x4207, 0x4227, 
        0x4A47, 0x4206, 0x4206, 0x4227, 0x4A89, 0x4227, 0x4226, 0x4A47, 0x4A47, 0x4A47, 0x4A47, 0x4A68, 0x5268, 0x4A47, 0x4A47, 0x4A47, 0x4A68, 0x4A68, 0x4A67, 0x5267, 0x4A47, 0x5267, 0x5AA8, 0x62C9, 0x62C9, 0x62E9, 0x62E9, 0x62E9, 0x5AE9, 0x5AC9, 
        0x5AC9, 0x62E9, 0x630A, 0x5AEA, 0x4AAA, 0x3A6A, 0x2A09, 0x4AEB, 0x534D, 0x220A, 0x0947, 0x3A69, 0x3A28, 0x3A49, 0x3229, 0x42CC, 0x4B0D, 0x3208, 0x3208, 0x5AEC, 0x31E7, 0x2166, 0x11CA, 0x29C8, 0x52CB, 0x6BAF, 0x73F0, 0x42AB, 0x3A4A, 0x326A, 
        0x2A09, 0x3A8C, 0x2209, 0x1106, 0x428B, 0x5B2D, 0x21C9, 0x2A2A, 0x4B2E, 0x4AED, 0x532D, 0x5B8F, 0x5B6F, 0xA555, 0xC659, 0x42CD, 0x00E8, 0x42CD, 0x8492, 0x7BF0, 0x8451, 0xB5D6, 0x8C92, 0x7C30, 0x7410, 0x73CF, 0x7C30, 0xB595, 0x8BEF, 0x634D, 
        0x9C71, 0x9CB2, 0xADB6, 0x9513, 0x94F3, 0x9D34, 0x9D14, 0xAD96, 0xAD95, 0x9514, 0x9D34, 0x9D34, 0xA595, 0xB5F6, 0x9D33, 0xADB6, 0xADB6, 0xAD96, 0xADB6, 0xAD96, 0xADB6, 0xAD96, 0xAD96, 0xA575, 0xA595, 0xADB6, 0xADB6, 0xADB6, 0x9D55, 0x9D54, 
        0xA575, 0xA575, 0xA575, 0x9514, 0xA596, 0xADB6, 0xADB6, 0xADB6, 0xA596, 0xADB6, 0xADD6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADB6, 0xADF7, 0xB5F7, 0xADD7, 0xB5F7, 0xB5F7, 0xADD7, 0xB5F7, 0xADD7, 0xADD7, 0x7473, 0x4370, 0x3B2F, 0x228D, 0x120C, 
        0x1A4C, 0x122C, 0x09EB, 0x11CA, 0x19C9, 0x21C8, 0x1987, 0x1967, 0x1966, 0x1965, 0x2165, 0x2165, 0x2185, 0x29A5, 0x3A07, 0x3A48, 0x4268, 0x4268, 0x4268, 0x4268, 0x4248, 0x4248, 0x4248, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A28, 0x3A27, 
        0x3A27, 0x3A28, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A47, 0x3A47, 0x3A48, 0x3A27, 0x3A27, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x4248, 0x4268, 0x4268, 0x4268, 0x4268, 0x3A48, 0x3A48,
  0x83ED, 0x83ED, 0x83ED, 0x736B, 0x7BAC, 0x73AC, 0x7BCC, 0x83CD, 0x83ED, 0x944E, 0x8C2D, 0x8C2D, 0x83CD, 0x83ED, 0x83ED, 0x840D, 0x83ED, 0x83ED, 0x8BED, 0x946F, 0x944E, 0x9C6F, 0x942D, 0x7BAC, 0x738C, 0x738B, 0x736B, 0x736B, 0x736B, 0x7BCD, 0x946F, 
        0x9CB0, 0x9CB0, 0xA4D0, 0x946F, 0x8C4E, 0x8C2E, 0x8C0E, 0x8C4E, 0xAD11, 0xAD11, 0xAD11, 0xB531, 0xAD31, 0x9C8F, 0x9C8F, 0x944F, 0x8C2E, 0x8C2E, 0x8C2E, 0x83CD, 0x942E, 0x9C8F, 0x946E, 0x9C8F, 0xA4B0, 0xA4B0, 0xA4D0, 0xA4F1, 0xA4B0, 0x944E, 
        0x8C0D, 0x8BED, 0x942E, 0x942E, 0x8C0D, 0x840D, 0x8C0D, 0x944E, 0x8C0D, 0x83CD, 0x8C0E, 0x8C2E, 0x944F, 0x83CD, 0x83ED, 0x9CB0, 0xA4B0, 0xAD12, 0xAD12, 0xA4D0, 0xA4D0, 0xA4D0, 0xA4F1, 0x9CB0, 0x9C8F, 0xA48F, 0xA4B0, 0x944E, 0x7BAC, 0x7BAC, 
        0x7BAC, 0x840D, 0x9C8F, 0x8C0D, 0x83CD, 0x83ED, 0x83CD, 0x83AC, 0x83CC, 0x8BCC, 0x83AC, 0x83CD, 0x83ED, 0x8C0E, 0x8C0E, 0x8C0D, 0x944E, 0x944E, 0x940D, 0x8C0D, 0x942D, 0x942D, 0x940D, 0x8C0D, 0x83CC, 0x83CC, 0x8C0D, 0x83ED, 0x83ED, 0x8BED, 
        0x83ED, 0x83CC, 0x83CD, 0x83ED, 0x83CD, 0x83CC, 0x7BAC, 0x7B8B, 0x6B4A, 0x62E9, 0x62E8, 0x6B4A, 0x7B8C, 0x83ED, 0x840D, 0x8BED, 0x942E, 0x940D, 0x8BED, 0x83CC, 0x83CC, 0x83CC, 0x840D, 0x8C0D, 0x83ED, 0x83ED, 0x83CC, 0x83CC, 0x8C0C, 0x83CC, 
        0x7B8B, 0x6B2A, 0x5AA8, 0x5AA8, 0x5AA8, 0x5AA8, 0x5AA8, 0x5AA8, 0x5288, 0x5268, 0x5288, 0x5288, 0x5288, 0x5288, 0x4A47, 0x4206, 0x4206, 0x4206, 0x4A26, 0x5267, 0x5AA8, 0x62E9, 0x630A, 0x630A, 0x5AA9, 0x5267, 0x4A26, 0x39E6, 0x31A5, 0x3185, 
        0x31A5, 0x39C5, 0x31A5, 0x3185, 0x3185, 0x3164, 0x3185, 0x31A5, 0x3184, 0x3184, 0x2964, 0x2964, 0x2964, 0x2964, 0x2964, 0x2964, 0x2944, 0x2944, 0x2944, 0x2964, 0x2944, 0x2964, 0x2964, 0x2944, 0x2944, 0x2964, 0x3164, 0x2944, 0x3184, 0x2984, 
        0x2964, 0x3184, 0x3185, 0x2964, 0x2964, 0x2964, 0x3164, 0x2964, 0x2964, 0x3184, 0x3185, 0x31A5, 0x31A5, 0x31A5, 0x39A5, 0x3185, 0x31A5, 0x31A5, 0x39C5, 0x31A5, 0x31A5, 0x39A5, 0x39C5, 0x39C5, 0x31A5, 0x31A5, 0x39C5, 0x39E5, 0x39C5, 0x39C5, 
        0x39E6, 0x39E6, 0x39C5, 0x41E6, 0x4A47, 0x4A47, 0x4A47, 0x4206, 0x4226, 0x4A47, 0x4A47, 0x4A67, 0x5267, 0x4A27, 0x4A47, 0x4A67, 0x5267, 0x5267, 0x5AA8, 0x52A8, 0x5AA8, 0x62E9, 0x5AC9, 0x5AA8, 0x5AC9, 0x5AE9, 0x630A, 0x6309, 0x62E9, 0x6B2A, 
        0x6B2A, 0x5AE9, 0x5AC9, 0x5AE9, 0x5AEA, 0x62E9, 0x62E9, 0x630A, 0x630A, 0x62E9, 0x62EA, 0x62E9, 0x6309, 0x630A, 0x6309, 0x5AE9, 0x62E9, 0x6309, 0x62E9, 0x6309, 0x6B2A, 0x6B2A, 0x6B2A, 0x6B2A, 0x62E9, 0x5AC9, 0x5AE9, 0x5AE9, 0x630A, 0x632A, 
        0x6B6B, 0x6B4B, 0x42CC, 0x3ACC, 0x3B0E, 0x1A8E, 0x0A8F, 0x1B11, 0x1B11, 0x0AB0, 0x0A4E, 0x0A0C, 0x122C, 0x120C, 0x122D, 0x12B0, 0x0AAF, 0x0A0C, 0x0A2C, 0x3330, 0x330F, 0x124D, 0x12AF, 0x330F, 0x432F, 0x4B90, 0x63F1, 0x3AED, 0x328C, 0x2AAD, 
        0x11A9, 0x32AD, 0x11A9, 0x0084, 0x3A4A, 0x63B0, 0x0988, 0x19EA, 0x3ACD, 0x532D, 0x7C31, 0x8472, 0x8CB3, 0xBE59, 0xBE38, 0x6BF0, 0x4ACD, 0x7C52, 0xA575, 0xA575, 0xADB6, 0xBE17, 0xB5D6, 0xAD95, 0xAD75, 0xADB6, 0xB5F7, 0xC617, 0xC5D6, 0xB5D6, 
        0xC617, 0xBE17, 0xB617, 0xBE37, 0xBE37, 0xBE38, 0xBE38, 0xBE37, 0xB617, 0xBE17, 0xBE17, 0xBE38, 0xC658, 0xB5F7, 0xB617, 0xBE37, 0xBE38, 0xBE18, 0xB5D7, 0xADD7, 0xB617, 0x9D55, 0x7493, 0x6C53, 0x7493, 0x74D4, 0x8515, 0xA5B7, 0xADD7, 0xA576, 
        0xADD7, 0xB5D7, 0xADD7, 0xA575, 0xADB6, 0xB5D7, 0xADD7, 0xADD7, 0xADD7, 0xADF7, 0xADD7, 0xADB7, 0xADD7, 0xADD7, 0xB5F7, 0xB618, 0xB618, 0xB618, 0xB5F8, 0xB618, 0xB618, 0xADD7, 0xADF7, 0xA5B6, 0x7493, 0x09A9, 0x0129, 0x00C6, 0x0107, 0x0107, 
        0x0063, 0x0042, 0x10C4, 0x52CB, 0x52EB, 0x4AAA, 0x4AA9, 0x4289, 0x4289, 0x42AA, 0x4AA9, 0x4AA9, 0x4A89, 0x4AA9, 0x4AA9, 0x4AA9, 0x4289, 0x4289, 0x4268, 0x4268, 0x4268, 0x4268, 0x4268, 0x3A48, 0x4268, 0x4248, 0x4268, 0x4268, 0x4248, 0x3A48, 
        0x3A48, 0x4248, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A27, 0x3A48, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A28, 0x3A27, 0x3A27, 0x3A28, 0x3A27, 0x3A48, 0x3A28, 0x3A28, 0x3A28, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48,
  0x9C6E, 0x9C6E, 0x944E, 0x7BAC, 0x738B, 0x7BAC, 0x7BCC, 0x83CC, 0x8C0D, 0xA4AF, 0xA4AF, 0x9C8F, 0x946F, 0x83ED, 0x8C2E, 0x8C2E, 0x944F, 0x8C2E, 0x8C2E, 0x942E, 0x8C0D, 0x942D, 0x9C4E, 0x83AC, 0x7B8C, 0x738B, 0x736B, 0x736B, 0x7B8C, 0x7BAC, 0x840D, 
        0x946F, 0xA4D1, 0xA4F1, 0x946F, 0x8C2E, 0x946F, 0x8C2E, 0x83ED, 0xA4D0, 0xB552, 0xA4F0, 0xA4D0, 0xACF0, 0x9C8F, 0x9C8F, 0x9C6E, 0x942E, 0x942E, 0x83ED, 0x83CC, 0x83ED, 0x944E, 0x944E, 0x942D, 0x9C6F, 0xA4B0, 0xA4D0, 0xA4D0, 0x9C8F, 0x8C0E, 
        0x8BED, 0x8C0D, 0x8BED, 0x8C0D, 0x83ED, 0x83ED, 0x83CC, 0x8BED, 0x8BED, 0x83CD, 0x83CD, 0x7BAC, 0x83ED, 0x83CD, 0x8C0D, 0x9CB0, 0x9C8F, 0x946F, 0x9C90, 0x9C6F, 0x944E, 0x944E, 0x944E, 0x942E, 0x8C2D, 0x8C0D, 0x8C2D, 0x8C0D, 0x83CC, 0x7BAC, 
        0x7BCC, 0x83CD, 0x8C0D, 0x8C0D, 0x8BED, 0x83ED, 0x83CD, 0x83AC, 0x8BCC, 0x8BCC, 0x83AC, 0x83AC, 0x7BAC, 0x83CC, 0x83CC, 0x83CC, 0x83AC, 0x83AB, 0x83AB, 0x83AB, 0x83AB, 0x83AB, 0x83AB, 0x7B8B, 0x7B8B, 0x734A, 0x736A, 0x734B, 0x734B, 0x736B, 
        0x734B, 0x6B4A, 0x6B4A, 0x6B2A, 0x6B0A, 0x6B0A, 0x6B2A, 0x62E9, 0x4A67, 0x39E5, 0x39C5, 0x4A27, 0x5AA8, 0x62E9, 0x62E9, 0x5AA9, 0x5AA8, 0x5267, 0x4A47, 0x4A26, 0x4A26, 0x5288, 0x4A67, 0x4A27, 0x4206, 0x4206, 0x4206, 0x39C5, 0x3184, 0x2964, 
        0x2964, 0x2944, 0x2944, 0x2944, 0x2943, 0x2143, 0x2143, 0x2944, 0x2944, 0x2944, 0x2123, 0x2123, 0x2123, 0x2944, 0x2944, 0x2944, 0x2964, 0x2944, 0x2944, 0x2944, 0x2944, 0x2103, 0x1061, 0x2103, 0x2964, 0x2944, 0x2944, 0x2944, 0x2964, 0x3164, 
        0x3164, 0x2964, 0x2964, 0x2964, 0x2984, 0x3185, 0x3185, 0x2985, 0x3185, 0x3185, 0x31A5, 0x3185, 0x2964, 0x31A5, 0x31A5, 0x3185, 0x3185, 0x3185, 0x3185, 0x3185, 0x3185, 0x31A5, 0x31A5, 0x3185, 0x31A5, 0x31A5, 0x3185, 0x2103, 0x39A5, 0x39E6, 
        0x39C5, 0x39E6, 0x39E6, 0x41E6, 0x4206, 0x4A26, 0x4A27, 0x4206, 0x4206, 0x4A26, 0x4206, 0x4A26, 0x4A46, 0x5267, 0x5267, 0x4A67, 0x5288, 0x5288, 0x5288, 0x5288, 0x5A88, 0x5A88, 0x5AA8, 0x5288, 0x5AA8, 0x62E9, 0x62E9, 0x62C9, 0x5AC9, 0x6309, 
        0x6B2A, 0x62E9, 0x6B0A, 0x6B2A, 0x6B4A, 0x6B4A, 0x6B4B, 0x6B4B, 0x6B4A, 0x62E9, 0x62E9, 0x62E9, 0x5AC8, 0x52A8, 0x5AA8, 0x62E9, 0x6B0A, 0x6B4B, 0x6B4B, 0x6B0A, 0x62E9, 0x736B, 0x6B4A, 0x62E9, 0x62E9, 0x62E9, 0x6309, 0x630A, 0x6309, 0x630A, 
        0x632A, 0x5AE9, 0x5AE9, 0x6309, 0x5AE9, 0x5AC9, 0x5AC9, 0x52A8, 0x52A8, 0x52C9, 0x5AC9, 0x5AE9, 0x5AC9, 0x5AE9, 0x630A, 0x6309, 0x5AE9, 0x6309, 0x630A, 0x5AC9, 0x5AE9, 0x630A, 0x630A, 0x5AC9, 0x5AC9, 0x5AC9, 0x5AEA, 0x5AEA, 0x5AEA, 0x52C9, 
        0x5AC9, 0x634C, 0x63F1, 0x5BF2, 0x5BF2, 0x4BD2, 0x3B91, 0x3371, 0x2B71, 0x2B72, 0x2B31, 0x22F0, 0x1AF0, 0x1AD0, 0x12AF, 0x1ACF, 0x12AE, 0x12AF, 0x12D0, 0x1AF1, 0x1B11, 0x0B11, 0x0AF1, 0x12F1, 0x026F, 0x0A8F, 0x1AF0, 0x0AD0, 0x1332, 0x2373, 
        0x1312, 0x0AD0, 0x026F, 0x0AB0, 0x0AB0, 0x1AD0, 0x2A8D, 0x430E, 0x6BF1, 0x9D35, 0xBE18, 0xBE38, 0xC67A, 0xBE59, 0xBE38, 0xBE38, 0xBE59, 0xBE38, 0xBE17, 0xBE38, 0xBE58, 0xBE38, 0xBE38, 0xBE38, 0xBE17, 0xC638, 0xC638, 0xBE37, 0xBE37, 0xBE38, 
        0xBE38, 0xB618, 0xADF7, 0xA5D6, 0xB617, 0xBE18, 0xB617, 0xBE17, 0xBE17, 0xBE38, 0xBE18, 0xBE38, 0x84B2, 0xADB6, 0xB617, 0xB617, 0xB617, 0xB617, 0xB5F7, 0xB5F7, 0xBE38, 0x6411, 0x01CC, 0x01ED, 0x0A4E, 0x128E, 0x226D, 0x4B4F, 0xA596, 0xA596, 
        0xADB7, 0xADD7, 0xADD7, 0xADD7, 0xADD7, 0xADD7, 0xADD7, 0xADD7, 0xADD7, 0xB5F8, 0xB5F7, 0xB5F7, 0xB5F7, 0xB618, 0xBE38, 0xBE59, 0xBE59, 0xB618, 0xB618, 0xB618, 0xB618, 0xADF7, 0xB618, 0x9D76, 0x32CD, 0x0128, 0x0169, 0x0927, 0x0908, 0x0149, 
        0x00A5, 0x0084, 0x2146, 0x8CB3, 0x94B2, 0x8471, 0x7C0F, 0x6BAE, 0x5B2C, 0x4ACA, 0x42A9, 0x4AA9, 0x4AA9, 0x4AA9, 0x4A89, 0x4289, 0x4289, 0x4289, 0x4289, 0x4268, 0x4268, 0x4268, 0x4268, 0x4268, 0x4268, 0x4268, 0x4288, 0x4268, 0x4268, 0x3A48, 
        0x4268, 0x3A48, 0x4248, 0x3A48, 0x3A48, 0x3A28, 0x3A28, 0x3A48, 0x3A27, 0x3A27, 0x3A27, 0x3A27, 0x3A48, 0x3A28, 0x3A48, 0x3A48, 0x3A28, 0x3A48, 0x3A28, 0x3A28, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A28, 0x3A48, 0x3A48, 0x3A48,
  0x9C6E, 0x9C6E, 0x9C8F, 0x8C0D, 0x7BAC, 0x83ED, 0x8C2E, 0x83ED, 0x8C0D, 0x9C6F, 0xA4D0, 0xA4D0, 0x9C8F, 0x8C0D, 0x8C2E, 0x8C0E, 0x944F, 0x8C2E, 0x8C0E, 0x83ED, 0x83CC, 0x8BCC, 0x8BEC, 0x83CC, 0x7BAC, 0x7BAC, 0x7BAC, 0x83CD, 0x83ED, 0x83ED, 0x83CD, 
        0x8C0E, 0x944F, 0x946F, 0x8C2E, 0x7BED, 0x8C2E, 0x8C2E, 0x8C0D, 0x8C2E, 0xA4D0, 0x9CAF, 0x946E, 0x9C8F, 0x8C2E, 0x738B, 0x7BAC, 0x83ED, 0x8C2E, 0x8BED, 0x83ED, 0x83ED, 0x7BAC, 0x83CC, 0x83ED, 0x8BED, 0x8C0D, 0x83ED, 0x83ED, 0x83ED, 0x83CD, 
        0x83ED, 0x83ED, 0x83ED, 0x83ED, 0x83CC, 0x83ED, 0x8BED, 0x8BED, 0x8C0D, 0x8C2D, 0x8C0D, 0x83CC, 0x83CC, 0x83ED, 0x8BED, 0x8C0D, 0x8C0D, 0x83CC, 0x8C2D, 0x942D, 0x83AC, 0x83AC, 0x83AC, 0x7B8B, 0x7B8B, 0x738B, 0x736A, 0x6B4A, 0x6B09, 0x62E9, 
        0x5AC9, 0x5AC9, 0x62E9, 0x62E9, 0x62E9, 0x5AA8, 0x5288, 0x5288, 0x5288, 0x5288, 0x5288, 0x5267, 0x4A67, 0x4A47, 0x4226, 0x4206, 0x4206, 0x4206, 0x4206, 0x39C5, 0x31A5, 0x3185, 0x39A5, 0x39C5, 0x39A5, 0x31A5, 0x3185, 0x31A5, 0x3185, 0x3185, 
        0x3185, 0x3184, 0x3184, 0x3184, 0x2984, 0x2964, 0x2964, 0x2964, 0x2964, 0x2944, 0x2944, 0x2964, 0x2964, 0x2964, 0x2964, 0x2964, 0x2944, 0x2943, 0x2943, 0x2964, 0x2944, 0x2944, 0x2944, 0x2944, 0x2964, 0x2964, 0x2964, 0x2964, 0x2964, 0x2964, 
        0x2964, 0x2964, 0x2964, 0x3184, 0x3185, 0x31A5, 0x3185, 0x31A5, 0x31A5, 0x31A5, 0x31A5, 0x31A5, 0x3185, 0x31C5, 0x31A5, 0x31A5, 0x31A5, 0x31A5, 0x31A5, 0x31A5, 0x31A5, 0x3185, 0x2103, 0x2123, 0x31A5, 0x3185, 0x31A5, 0x39E6, 0x39E6, 0x31A5, 
        0x31A5, 0x31A5, 0x31A5, 0x31A5, 0x39A5, 0x39C5, 0x39C5, 0x39C5, 0x39C5, 0x39C5, 0x31A5, 0x31A5, 0x39C5, 0x39C5, 0x39C5, 0x4206, 0x4206, 0x4206, 0x41E6, 0x4206, 0x4A26, 0x4A27, 0x4A27, 0x4A26, 0x4A47, 0x4A26, 0x4A47, 0x5267, 0x5267, 0x5287, 
        0x5288, 0x5288, 0x52A8, 0x5AC9, 0x62E9, 0x6B09, 0x6B09, 0x6309, 0x62E9, 0x62E9, 0x62E9, 0x6B2A, 0x6B4A, 0x6B2A, 0x6B2A, 0x630A, 0x6309, 0x62E9, 0x62C9, 0x5AA8, 0x62E9, 0x62E9, 0x62E9, 0x6B09, 0x6B2A, 0x6B2A, 0x6B4A, 0x6B2A, 0x62E9, 0x630A, 
        0x6B0A, 0x6309, 0x6B2A, 0x6B2A, 0x6B4A, 0x6B2A, 0x6B2A, 0x6B4A, 0x6B2A, 0x6B2A, 0x630A, 0x630A, 0x62E9, 0x62E9, 0x62E9, 0x5AE9, 0x5AC9, 0x6B2A, 0x632A, 0x6309, 0x62E9, 0x62E9, 0x630A, 0x630A, 0x62EA, 0x5AE9, 0x62EA, 0x5AC9, 0x5AC9, 0x52A9, 
        0x5AEA, 0x52A9, 0x5AC9, 0x5AC9, 0x5AC9, 0x5AA9, 0x52A9, 0x52C9, 0x5AE9, 0x5AC9, 0x52C9, 0x5AEA, 0x5AEA, 0x5AE9, 0x630A, 0x5B0A, 0x5AC9, 0x5AC9, 0x5AC9, 0x52A9, 0x52A9, 0x52C9, 0x52A9, 0x52A9, 0x52A9, 0x52A9, 0x4AA8, 0x4AA9, 0x4A89, 0x4A89, 
        0x4268, 0x8C70, 0xDED9, 0xD698, 0xD698, 0xD698, 0xD699, 0xD699, 0xD699, 0xCE79, 0xCE9A, 0xC679, 0xBE39, 0xBE39, 0xB5F8, 0xADD7, 0xADD7, 0xA597, 0xA5B7, 0xA597, 0x9D77, 0x9D77, 0x9556, 0x8D15, 0x8D15, 0x8D15, 0x84D5, 0x7CD5, 0x6C74, 0x6C74, 
        0x74B5, 0x7CF6, 0x7516, 0x7517, 0x5434, 0x6475, 0xC69A, 0xC69A, 0xCEBA, 0xC699, 0xBE38, 0xBE59, 0xC679, 0xC679, 0xC659, 0xC679, 0xBE59, 0xB618, 0xB618, 0xB618, 0x9534, 0xBE38, 0xBE38, 0xBE38, 0xB617, 0xBE17, 0xBE18, 0xB5F7, 0xB5F7, 0xB5F7, 
        0xADB6, 0x6C52, 0x4B6F, 0x538F, 0x63F1, 0xB5F8, 0xB5D7, 0xB5D7, 0xADD6, 0xADB6, 0xADB6, 0xB5F7, 0x8D13, 0xADB6, 0xB5F7, 0xB617, 0xB617, 0xB5F7, 0xB5F7, 0xB5F7, 0xB5F7, 0x4B6E, 0x01AB, 0x01CC, 0x01AB, 0x01AB, 0x4B91, 0x3ACD, 0xA5B7, 0xB617, 
        0xB618, 0xB618, 0xB618, 0xB5F7, 0xB618, 0xADD7, 0xB618, 0xB638, 0xB618, 0xB618, 0xB618, 0xB639, 0xB638, 0xB639, 0xB659, 0xB659, 0xB639, 0xAE18, 0xAE18, 0xB639, 0xA618, 0x9DD8, 0x9DB7, 0x7CF5, 0x1A0B, 0x0128, 0x09AA, 0x0969, 0x0969, 0x09CB, 
        0x09AA, 0x0969, 0x21C9, 0x8492, 0x94B1, 0x73EF, 0x636D, 0x5B2C, 0x4AAA, 0x42A9, 0x42A9, 0x4ACA, 0x4AA9, 0x4AA9, 0x4AA9, 0x4289, 0x4AA9, 0x4AA9, 0x4289, 0x4289, 0x4289, 0x4AA9, 0x4288, 0x4268, 0x4269, 0x4268, 0x4248, 0x3A48, 0x3A48, 0x3A48, 
        0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A28, 0x3A48, 0x3A28, 0x3A48, 0x3A48, 0x3A47, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x4268, 0x3A48, 0x3A48, 0x3A48, 0x3A28, 0x3A28, 0x3A48, 0x3A48, 0x3A48, 0x3A48,
  0x8C0D, 0x944E, 0x942E, 0x8C0D, 0x83CD, 0x7BCC, 0x83ED, 0x83ED, 0x83ED, 0x83ED, 0x840D, 0x8C2E, 0x8C2E, 0x8C0D, 0x83CD, 0x7BCD, 0x83ED, 0x83CD, 0x7BAC, 0x7BAC, 0x7BAC, 0x83EC, 0x83CC, 0x7BAB, 0x7BAC, 0x7BAC, 0x7B8B, 0x7BAB, 0x7B8B, 0x7B8B, 0x7BAB, 
        0x7B8B, 0x7BAC, 0x7BAC, 0x7BAC, 0x7BAB, 0x7BAC, 0x736B, 0x6B4A, 0x632A, 0x6309, 0x6B4A, 0x738B, 0x7B8B, 0x734A, 0x6B4A, 0x6B4A, 0x6B4B, 0x6B4A, 0x736B, 0x734A, 0x6B4A, 0x6309, 0x6B2A, 0x734A, 0x6B2A, 0x6B2A, 0x630A, 0x630A, 0x630A, 0x62E9, 
        0x630A, 0x6B2A, 0x738B, 0x736B, 0x736B, 0x738B, 0x7B8B, 0x736B, 0x734B, 0x6B2A, 0x5AC9, 0x52A8, 0x5288, 0x4A47, 0x4A47, 0x4226, 0x4A27, 0x4226, 0x4206, 0x4206, 0x39E5, 0x39C5, 0x39C5, 0x31A5, 0x3185, 0x3185, 0x3185, 0x2944, 0x2924, 0x2123, 
        0x2143, 0x2143, 0x2123, 0x2123, 0x2944, 0x2143, 0x2144, 0x2944, 0x2944, 0x2944, 0x2944, 0x2944, 0x2144, 0x2123, 0x2123, 0x2123, 0x2144, 0x2144, 0x2944, 0x2944, 0x2944, 0x2944, 0x2964, 0x2964, 0x2964, 0x2985, 0x2965, 0x2964, 0x2964, 0x2964, 
        0x2944, 0x2964, 0x3185, 0x3185, 0x2964, 0x2984, 0x2964, 0x3185, 0x3185, 0x3185, 0x2964, 0x18E3, 0x3184, 0x3185, 0x31A5, 0x31A5, 0x31A5, 0x31A5, 0x31A5, 0x31A5, 0x31A5, 0x31A5, 0x31A5, 0x31C5, 0x39C6, 0x39C5, 0x39C5, 0x39C5, 0x39E6, 0x4206, 
        0x4206, 0x4206, 0x4206, 0x4206, 0x41E6, 0x41E6, 0x41E6, 0x41E6, 0x39C6, 0x39C6, 0x4206, 0x4206, 0x4206, 0x4206, 0x4206, 0x4226, 0x4A27, 0x4206, 0x4206, 0x4A27, 0x5288, 0x4A47, 0x4A47, 0x5288, 0x5288, 0x5288, 0x5267, 0x52A8, 0x5AC8, 0x5AC8, 
        0x5287, 0x5287, 0x5AA8, 0x5AA8, 0x5AA8, 0x5AA8, 0x5AC9, 0x5AC9, 0x62E9, 0x6309, 0x52A8, 0x5288, 0x5AA8, 0x5AA8, 0x5AA8, 0x5AC9, 0x62E9, 0x6309, 0x6309, 0x5AC9, 0x5AE9, 0x5AE9, 0x62E9, 0x6309, 0x6309, 0x6309, 0x5AE9, 0x62E9, 0x6309, 0x5AC9, 
        0x52A9, 0x52A8, 0x5AC9, 0x62E9, 0x6309, 0x630A, 0x5AE9, 0x5AC9, 0x5AC9, 0x5AA8, 0x5AC9, 0x630A, 0x62E9, 0x5AC9, 0x5AA8, 0x62E9, 0x62E9, 0x5AC9, 0x62E9, 0x62E9, 0x5AC9, 0x5AA9, 0x5AC9, 0x5AC9, 0x62E9, 0x62E9, 0x62E9, 0x62E9, 0x6309, 0x62E9, 
        0x6309, 0x6B4A, 0x6B4B, 0x6B2A, 0x62E9, 0x5AE9, 0x5AC9, 0x5AE9, 0x52A9, 0x52A9, 0x52A8, 0x52A9, 0x52A9, 0x5AA9, 0x52A9, 0x52A9, 0x52A9, 0x5AE9, 0x5B0A, 0x5B0A, 0x5AC9, 0x5AC9, 0x5AE9, 0x52A9, 0x52A9, 0x52A9, 0x52A9, 0x4A88, 0x4A88, 0x4A88, 
        0x4A88, 0x52C9, 0x5AC9, 0x5AC9, 0x5AC9, 0x5AC9, 0x52A9, 0x52A9, 0x5AE9, 0x52C9, 0x52C9, 0x52C9, 0x52C9, 0x52A9, 0x52C9, 0x52C9, 0x5AEA, 0x5AEA, 0x5AEA, 0x5AEA, 0x5B0A, 0x5AC9, 0x52A9, 0x5289, 0x52A9, 0x52C9, 0x52C9, 0x52A9, 0x52A9, 0x52A9, 
        0x52A9, 0xAD32, 0xDE98, 0xD676, 0xD677, 0xD697, 0xDE98, 0xDEB9, 0xDED9, 0xE6FA, 0xC658, 0xADD7, 0xD6B9, 0xBE38, 0xDEDA, 0xCE99, 0xC638, 0xE71A, 0xCE78, 0xC638, 0xDED9, 0xDEDA, 0xC638, 0xE6FA, 0xE6F9, 0xDEB8, 0xC616, 0xC5F5, 0xC616, 0xC5F5, 
        0xC5F6, 0xCE57, 0xDEFA, 0xEF5C, 0x8557, 0x6475, 0xD6DB, 0xCEBA, 0xCE99, 0xCE99, 0xC679, 0xBE58, 0xBE38, 0xBE38, 0xB618, 0xB618, 0xB5F7, 0xB5F7, 0xB617, 0xB618, 0x8CB3, 0xBE18, 0xBE38, 0xBE58, 0xBE58, 0xBE58, 0xB617, 0xB5F7, 0xADD7, 0x9D75, 
        0x8CD3, 0x3AED, 0x7432, 0xA576, 0x32AC, 0xADD7, 0xB638, 0xBE38, 0xBE38, 0xBE58, 0xC659, 0xBE58, 0xBE58, 0xB618, 0xBE38, 0xBE38, 0xB638, 0xB638, 0xBE38, 0xB618, 0xBE59, 0x53AF, 0x01CA, 0x01AB, 0x0169, 0x01AA, 0x120C, 0x224B, 0x9D97, 0xB639, 
        0xB639, 0xB639, 0xAE19, 0xADF8, 0x9D96, 0x9DB7, 0xA5F8, 0x9DD8, 0x95B8, 0x8D77, 0x8D77, 0x8577, 0x8536, 0x7D16, 0x74F5, 0x6CD6, 0x64B5, 0x5C75, 0x5C54, 0x5413, 0x4BB1, 0x3B30, 0x32EF, 0x2ACE, 0x1A2B, 0x19EA, 0x11C9, 0x19C9, 0x19A9, 0x1188, 
        0x1167, 0x1146, 0x10E5, 0x1924, 0x29A5, 0x4268, 0x4A89, 0x4289, 0x4AAA, 0x4AAA, 0x4AA9, 0x4ACA, 0x4AA9, 0x4AA9, 0x4AA9, 0x4AA9, 0x4289, 0x4AA9, 0x4AA9, 0x4289, 0x4288, 0x4289, 0x4268, 0x4268, 0x4268, 0x4268, 0x4268, 0x3A48, 0x4268, 0x4268, 
        0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A28, 0x3A48, 0x3A28, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48,
  0x7BAC, 0x7BAB, 0x7BAC, 0x83CD, 0x83CD, 0x7BCC, 0x7BAB, 0x7BAC, 0x7BCC, 0x7B8B, 0x7B8B, 0x736B, 0x738B, 0x7BAC, 0x738B, 0x738B, 0x738B, 0x736A, 0x6B2A, 0x6B2A, 0x6B4A, 0x736B, 0x6B4A, 0x630A, 0x632A, 0x6309, 0x5AE9, 0x5AC9, 0x5AC9, 0x5AA8, 0x52A8, 
        0x5267, 0x4A68, 0x4A67, 0x4A67, 0x4A47, 0x4206, 0x39C5, 0x31A5, 0x31A5, 0x2985, 0x31A5, 0x39E6, 0x31A5, 0x2984, 0x3185, 0x2984, 0x3164, 0x2964, 0x2984, 0x3185, 0x3185, 0x2964, 0x2964, 0x2964, 0x2964, 0x2964, 0x2964, 0x2964, 0x2944, 0x2944, 
        0x2944, 0x2964, 0x2984, 0x3185, 0x2984, 0x2123, 0x2964, 0x3185, 0x2964, 0x2944, 0x2944, 0x2964, 0x2944, 0x2944, 0x2944, 0x2944, 0x2144, 0x2964, 0x2944, 0x2944, 0x2944, 0x2964, 0x2964, 0x2964, 0x2964, 0x2964, 0x2964, 0x2964, 0x2964, 0x2964, 
        0x2964, 0x2964, 0x2944, 0x2964, 0x2964, 0x2985, 0x3185, 0x3185, 0x3185, 0x3185, 0x3185, 0x3185, 0x3184, 0x3184, 0x3185, 0x31A5, 0x31A5, 0x31A5, 0x3185, 0x2964, 0x2944, 0x3185, 0x31A5, 0x31A5, 0x31A5, 0x31A5, 0x31A5, 0x39C5, 0x39C5, 0x31C5, 
        0x31A5, 0x39C5, 0x39C5, 0x31A5, 0x31A5, 0x3184, 0x3184, 0x31A5, 0x31A5, 0x31A5, 0x31A5, 0x3185, 0x39E6, 0x39E5, 0x4206, 0x4226, 0x4226, 0x4206, 0x4206, 0x4206, 0x4A27, 0x4A47, 0x4A67, 0x5267, 0x4A47, 0x4A26, 0x4A67, 0x5288, 0x5AC9, 0x62C9, 
        0x62E9, 0x62E9, 0x62E9, 0x6309, 0x62E9, 0x62E9, 0x5AC8, 0x52A8, 0x5267, 0x4A67, 0x5AA8, 0x6309, 0x6B2A, 0x6309, 0x630A, 0x6B2A, 0x736B, 0x6B2A, 0x6B4A, 0x6B2A, 0x6B2A, 0x6B2A, 0x6B2A, 0x6B4A, 0x6B4A, 0x6B2A, 0x6B09, 0x6B2A, 0x6B2A, 0x62E9, 
        0x62E9, 0x5AC9, 0x5AC9, 0x5AA8, 0x5AC9, 0x5AA8, 0x5AA8, 0x5AC9, 0x5AE9, 0x6309, 0x5AE9, 0x5AE9, 0x5AC9, 0x5AE9, 0x630A, 0x62E9, 0x6309, 0x6B2A, 0x6309, 0x5AC9, 0x52C9, 0x5AE9, 0x5AE9, 0x62E9, 0x630A, 0x5AE9, 0x52A9, 0x52A8, 0x52C9, 0x5AC9, 
        0x5AEA, 0x5AC9, 0x52A8, 0x52A9, 0x5AE9, 0x5AEA, 0x5AC9, 0x5AC9, 0x5AA9, 0x5AA9, 0x52A8, 0x52A8, 0x5288, 0x5288, 0x5288, 0x5AA9, 0x5288, 0x4A67, 0x5288, 0x5268, 0x4A67, 0x4A47, 0x4A27, 0x4A68, 0x4A47, 0x4A27, 0x4A47, 0x4A47, 0x4A47, 0x4A68, 
        0x4A88, 0x4A68, 0x4A88, 0x52A8, 0x4A88, 0x4A88, 0x4A68, 0x4A68, 0x4A88, 0x4A68, 0x4A68, 0x4A68, 0x4A68, 0x4A68, 0x5268, 0x4A88, 0x52A9, 0x52A9, 0x52A9, 0x52A9, 0x52A9, 0x5AC9, 0x5AC9, 0x52A9, 0x5AC9, 0x5AEA, 0x52C9, 0x52C9, 0x52C9, 0x52C9, 
        0x5AC9, 0x5AEA, 0x5AEA, 0x5AEA, 0x5AEA, 0x5AE9, 0x5AEA, 0x5AEA, 0x5AEA, 0x5B0A, 0x5AEA, 0x52C9, 0x52A9, 0x52A9, 0x52C9, 0x5AC9, 0x5AEA, 0x5B0A, 0x630A, 0x5B0A, 0x5AEA, 0x5AE9, 0x5AC9, 0x5AEA, 0x5AEA, 0x5AEA, 0x52C9, 0x52A9, 0x52C9, 0x52C9, 
        0x5AEA, 0xBDD4, 0xCE56, 0xCE35, 0xCE56, 0xD656, 0xD677, 0xD698, 0xD6B8, 0xDED9, 0x9555, 0x9D56, 0xBE38, 0x9D55, 0xC658, 0xBE17, 0xADD6, 0xE6FA, 0xA596, 0x9535, 0xCE78, 0xADD7, 0x8CF4, 0xD698, 0xD698, 0xCE16, 0xCE36, 0xD677, 0xCE57, 0xCE57, 
        0xCE57, 0xCE57, 0xD6BA, 0xDF1B, 0x7D36, 0x43D4, 0xC69A, 0xCE9A, 0xC679, 0xCE9A, 0xCEBA, 0xC699, 0xBE38, 0xB617, 0xBE38, 0xBE58, 0xC659, 0xBE59, 0xC679, 0xCE99, 0xCE99, 0xC679, 0xC679, 0x9D96, 0x7493, 0x7CB3, 0xB618, 0xB618, 0x9D55, 0x84B3, 
        0x7C72, 0x2A6C, 0x4B2E, 0x84F4, 0x11C9, 0x6C52, 0x84D4, 0x84F4, 0x9535, 0x7C92, 0x7C72, 0x84D4, 0x7472, 0x74B3, 0x6C52, 0x5C12, 0x53B1, 0x6412, 0x6411, 0x7CD4, 0x84F5, 0x432D, 0x11EB, 0x09EB, 0x09AA, 0x09EB, 0x11EB, 0x2A8D, 0x5BF2, 0x6CB4, 
        0x6433, 0x53D1, 0x4B91, 0x4370, 0x3AED, 0x32CD, 0x32CD, 0x32AD, 0x2A8C, 0x2A6B, 0x222A, 0x2209, 0x1A09, 0x19C8, 0x19A8, 0x19A8, 0x11A8, 0x1988, 0x1987, 0x1986, 0x1966, 0x1945, 0x1924, 0x1104, 0x1103, 0x10E3, 0x10A2, 0x0882, 0x1061, 0x0861, 
        0x1081, 0x1061, 0x0840, 0x0861, 0x10C2, 0x2985, 0x31C6, 0x3A07, 0x3A27, 0x4268, 0x4268, 0x4AA9, 0x4A89, 0x4A89, 0x4AA9, 0x4289, 0x4268, 0x4269, 0x4289, 0x4268, 0x3A48, 0x4269, 0x4268, 0x4268, 0x3A68, 0x3A48, 0x4248, 0x3A48, 0x4248, 0x4268, 
        0x4268, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A28, 0x3A28, 0x3A48, 0x3A48, 0x3A48, 0x3A28, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A68, 0x3A68, 0x3A48, 0x3A48,
  0x6309, 0x62E9, 0x62E9, 0x6309, 0x630A, 0x62E9, 0x5AA8, 0x4A67, 0x4A47, 0x4206, 0x4206, 0x4226, 0x4206, 0x39E6, 0x4206, 0x4227, 0x4206, 0x39E6, 0x39C5, 0x39C5, 0x31A5, 0x2985, 0x2964, 0x2964, 0x2964, 0x2964, 0x2944, 0x2144, 0x2944, 0x2123, 0x2123, 
        0x2123, 0x2103, 0x2103, 0x2123, 0x2123, 0x2123, 0x2124, 0x2124, 0x2944, 0x2944, 0x2964, 0x2964, 0x2144, 0x2123, 0x2924, 0x2944, 0x2964, 0x2964, 0x2944, 0x2164, 0x2944, 0x2964, 0x2964, 0x2944, 0x2144, 0x2943, 0x2964, 0x2964, 0x3185, 0x2984, 
        0x2964, 0x2964, 0x2964, 0x2944, 0x2964, 0x1061, 0x0840, 0x2944, 0x2964, 0x2944, 0x2944, 0x2944, 0x2143, 0x2944, 0x2944, 0x2964, 0x2944, 0x31A5, 0x31A5, 0x31A5, 0x31A5, 0x31A5, 0x31A5, 0x31A5, 0x31A5, 0x3185, 0x3185, 0x31A5, 0x31A5, 0x39C6, 
        0x39E6, 0x4206, 0x39E6, 0x39C5, 0x4206, 0x4226, 0x41E6, 0x39E6, 0x4206, 0x41E6, 0x4206, 0x4A47, 0x4A27, 0x4A26, 0x4A47, 0x5288, 0x5288, 0x5AA8, 0x5267, 0x4206, 0x4206, 0x4A26, 0x4A26, 0x4A26, 0x4A47, 0x4A47, 0x4A47, 0x4A47, 0x4A47, 0x4A68, 
        0x5AA8, 0x52A8, 0x4A67, 0x4A67, 0x5267, 0x4A47, 0x4206, 0x4206, 0x4A27, 0x4A47, 0x4A67, 0x5288, 0x5288, 0x4A67, 0x52A8, 0x5AC8, 0x5AA8, 0x5AA8, 0x5AA8, 0x5AA8, 0x5AC9, 0x5AE9, 0x6309, 0x6309, 0x5AC9, 0x62E9, 0x62E9, 0x6309, 0x62E9, 0x6309, 
        0x6309, 0x6B0A, 0x6B2A, 0x6B2A, 0x6B2A, 0x6B0A, 0x6309, 0x62E9, 0x5AC9, 0x5AC9, 0x5AC9, 0x632A, 0x632A, 0x6309, 0x632A, 0x6B4A, 0x6B2A, 0x62E9, 0x62E9, 0x6B0A, 0x6B0A, 0x6B4B, 0x6B2A, 0x6B4A, 0x736B, 0x6B4B, 0x6B2A, 0x6B2A, 0x6309, 0x62E9, 
        0x62E9, 0x5AC9, 0x52A9, 0x5288, 0x5AE9, 0x62E9, 0x62E9, 0x6B2A, 0x632A, 0x5AE9, 0x5AC9, 0x5AC9, 0x5AE9, 0x52A9, 0x5AA9, 0x52A8, 0x52C9, 0x6309, 0x630A, 0x5AE9, 0x5AC9, 0x52A8, 0x52A9, 0x52A9, 0x52A9, 0x52A9, 0x52A8, 0x4A88, 0x52A9, 0x52A9, 
        0x52A9, 0x4A88, 0x4A88, 0x4A68, 0x4A68, 0x4A68, 0x4A68, 0x4A68, 0x4A68, 0x4A67, 0x4A67, 0x4227, 0x4A67, 0x4A47, 0x4A27, 0x4A27, 0x4A47, 0x4A68, 0x4A47, 0x4A27, 0x4227, 0x4227, 0x4227, 0x4A27, 0x4227, 0x4A27, 0x4A47, 0x4A27, 0x4A27, 0x4A27, 
        0x4227, 0x4247, 0x4247, 0x4A48, 0x4A68, 0x4A68, 0x4A68, 0x4A68, 0x4A68, 0x5288, 0x5288, 0x5268, 0x5268, 0x4A47, 0x4A47, 0x4A68, 0x4A88, 0x4A68, 0x4A68, 0x4A68, 0x4A68, 0x5288, 0x5288, 0x4A88, 0x4A88, 0x52A8, 0x52A9, 0x52A9, 0x52C9, 0x52C9, 
        0x52C9, 0x52C9, 0x52C9, 0x52A9, 0x5AC9, 0x5AC9, 0x5AEA, 0x5AEA, 0x5AEA, 0x5AEA, 0x5AEA, 0x5AEA, 0x5AEA, 0x5AEA, 0x5AC9, 0x52C9, 0x5AC9, 0x5AEA, 0x5AEA, 0x5AE9, 0x52A9, 0x52C9, 0x5AC9, 0x62EA, 0x5AEA, 0x52A9, 0x52A9, 0x52C9, 0x5ACA, 0x52C9, 
        0x6B6C, 0xC5F5, 0xCE56, 0xCE36, 0xD676, 0xDE97, 0xDEB8, 0xDED8, 0xDED8, 0xDEB8, 0xB5B5, 0xBDF7, 0xD699, 0xB5B6, 0xD6B9, 0xBDF6, 0xC637, 0xDEB9, 0xADB5, 0xAD95, 0xC657, 0x9513, 0x9D34, 0xD657, 0xD697, 0xC615, 0xD657, 0xD677, 0xCE57, 0xD677, 
        0xD677, 0xCE57, 0xD699, 0xDEFB, 0x8536, 0x2B72, 0xC69A, 0xCEBA, 0xCEBA, 0xC69A, 0xB638, 0xC69A, 0xBE7A, 0xB639, 0x9D96, 0x7CB3, 0x7C93, 0x7472, 0x7452, 0x7472, 0x6411, 0x7493, 0x6432, 0x226D, 0x01CB, 0x09CB, 0x3ACE, 0x53B0, 0x222A, 0x21E9, 
        0x1188, 0x0148, 0x19CA, 0x222B, 0x0148, 0x11CA, 0x11EB, 0x11EB, 0x1A2C, 0x11EB, 0x11CA, 0x1A0B, 0x120C, 0x1A4C, 0x122C, 0x120B, 0x120B, 0x224C, 0x224B, 0x2A8C, 0x328D, 0x328C, 0x2A6C, 0x1A2B, 0x19EA, 0x19EA, 0x19E9, 0x19A9, 0x1167, 0x1146, 
        0x1125, 0x1104, 0x1124, 0x1945, 0x1945, 0x1925, 0x1944, 0x2145, 0x2144, 0x2165, 0x2985, 0x2985, 0x2985, 0x2985, 0x2965, 0x3185, 0x2964, 0x2944, 0x2144, 0x2124, 0x2144, 0x2123, 0x18E2, 0x10A1, 0x10A1, 0x10A2, 0x1081, 0x0840, 0x18C2, 0x3185, 
        0x5ACA, 0x630B, 0x2103, 0x10A1, 0x10A2, 0x18C2, 0x18C2, 0x1902, 0x2144, 0x29A5, 0x31A6, 0x31E6, 0x3A27, 0x3A28, 0x3A28, 0x3A28, 0x3A48, 0x3A28, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A47, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 
        0x3A48, 0x3A48, 0x3A48, 0x3A28, 0x3A28, 0x3A28, 0x3A48, 0x3A48, 0x3A28, 0x3A28, 0x3A28, 0x3A28, 0x3A28, 0x3A28, 0x3A27, 0x3207, 0x3A27, 0x3A28, 0x3A28, 0x3A28, 0x3A28, 0x3A27, 0x3A27, 0x3A28, 0x3A28, 0x3A48, 0x4289, 0x4268, 0x3A48,
  0x2944, 0x2944, 0x2944, 0x2944, 0x2944, 0x2964, 0x2943, 0x2143, 0x2123, 0x2124, 0x2144, 0x2944, 0x2944, 0x2944, 0x2964, 0x2944, 0x2944, 0x2944, 0x2144, 0x2123, 0x2144, 0x2144, 0x2123, 0x2123, 0x2944, 0x2964, 0x2944, 0x2944, 0x2143, 0x2964, 0x2964, 
        0x2944, 0x2944, 0x2964, 0x2984, 0x2964, 0x2964, 0x2964, 0x2965, 0x3185, 0x3184, 0x3185, 0x3184, 0x3185, 0x3184, 0x3185, 0x3185, 0x31A5, 0x31A5, 0x3185, 0x31A5, 0x31A5, 0x31A5, 0x3185, 0x3185, 0x31A5, 0x31A5, 0x31A5, 0x31A5, 0x39C5, 0x39C5, 
        0x31A5, 0x31A5, 0x39C5, 0x39E6, 0x4206, 0x41E6, 0x39A5, 0x4206, 0x39E6, 0x39E5, 0x39C5, 0x39C5, 0x39E5, 0x4206, 0x4206, 0x4226, 0x4A67, 0x52A8, 0x5288, 0x5288, 0x5288, 0x5267, 0x4A47, 0x4A26, 0x5267, 0x5287, 0x5287, 0x4A67, 0x4A67, 0x52A8, 
        0x52A8, 0x5AC9, 0x5AA8, 0x5AC8, 0x6309, 0x5AE9, 0x5AA8, 0x5AC8, 0x5AC8, 0x52A8, 0x5288, 0x5288, 0x52A8, 0x5288, 0x5288, 0x52A8, 0x52A8, 0x5AC9, 0x62E9, 0x5AE9, 0x5AC9, 0x5288, 0x5AC8, 0x5AE9, 0x52A8, 0x5AC9, 0x52A8, 0x52A9, 0x5288, 0x4A68, 
        0x52A8, 0x52A8, 0x52A8, 0x5AC9, 0x6309, 0x62E9, 0x5AA8, 0x52A8, 0x5AC9, 0x5AC9, 0x5AC8, 0x62E9, 0x62E9, 0x62E9, 0x5AC9, 0x5AA8, 0x5AC9, 0x5AE9, 0x5AC9, 0x5AC9, 0x62E9, 0x5AE9, 0x62E9, 0x62E9, 0x62E9, 0x62E9, 0x62E9, 0x5AE9, 0x62E9, 0x62E9, 
        0x5AC9, 0x5AC8, 0x5AA8, 0x5AA8, 0x5AC8, 0x5AC9, 0x5AC9, 0x5AC9, 0x5AC9, 0x5AE9, 0x62E9, 0x6309, 0x5AA8, 0x52A8, 0x5AC8, 0x5AE9, 0x5AC9, 0x5AC8, 0x5AC8, 0x5AA8, 0x5AA8, 0x52A8, 0x4A88, 0x5AA9, 0x62E9, 0x5AC9, 0x5AA8, 0x52A8, 0x5AA8, 0x5AE9, 
        0x5AC9, 0x52A9, 0x5288, 0x4A88, 0x52A8, 0x5AC9, 0x5AC9, 0x5AC9, 0x52A8, 0x52A8, 0x52A9, 0x5AE9, 0x5AE9, 0x52A9, 0x52A9, 0x52A8, 0x52A8, 0x5288, 0x4A68, 0x5288, 0x4A88, 0x4A68, 0x4A68, 0x4A68, 0x4A68, 0x4A68, 0x4A68, 0x4A88, 0x4A68, 0x4A67, 
        0x4A68, 0x4A47, 0x4247, 0x4247, 0x4227, 0x4247, 0x4A48, 0x4A48, 0x4A67, 0x4A47, 0x4247, 0x4227, 0x4227, 0x4227, 0x4207, 0x4227, 0x4227, 0x4A47, 0x4A47, 0x4A47, 0x4A47, 0x4A27, 0x4A27, 0x4227, 0x4A27, 0x4A07, 0x4A27, 0x4A27, 0x4A47, 0x4A27, 
        0x4A47, 0x4A27, 0x4227, 0x4A27, 0x4A48, 0x4A27, 0x4A48, 0x4A68, 0x4A68, 0x4A68, 0x4A68, 0x4A68, 0x4A48, 0x4A48, 0x4A68, 0x4A68, 0x4A68, 0x4A48, 0x4A68, 0x4A88, 0x4A68, 0x4A68, 0x4A88, 0x4A88, 0x4A88, 0x4A88, 0x4A88, 0x52A9, 0x52C9, 0x5AC9, 
        0x52C9, 0x52C9, 0x52C9, 0x52C9, 0x52C9, 0x5AEA, 0x5AEA, 0x52EA, 0x52EA, 0x52EA, 0x5AEA, 0x5B0A, 0x5AEA, 0x5AEA, 0x52C9, 0x52C9, 0x5ACA, 0x52C9, 0x52C9, 0x5AEA, 0x5AEA, 0x52C9, 0x5AC9, 0x5AE9, 0x5AC9, 0x52C9, 0x52C9, 0x52A9, 0x52C9, 0x52CA, 
        0x4AED, 0x5BD1, 0x6C52, 0x6C32, 0x6C72, 0x7CD4, 0x8514, 0x9535, 0x9555, 0x9D76, 0x9DB7, 0xA5D7, 0xADF8, 0xB618, 0xBE59, 0xC658, 0xC658, 0xBE58, 0xBE38, 0xC658, 0xC658, 0xC657, 0xC657, 0xCE57, 0xCE77, 0xBDD5, 0xD657, 0xD677, 0xCE57, 0xD698, 
        0xD698, 0xCE78, 0xD6B9, 0xDF1B, 0x7D37, 0x1B12, 0x5C75, 0x5434, 0x4C14, 0x3B92, 0x22F0, 0x3352, 0x3331, 0x2B11, 0x1A8E, 0x01EC, 0x01ED, 0x020D, 0x020C, 0x01EC, 0x01CC, 0x020D, 0x0A0D, 0x0A0C, 0x122D, 0x122D, 0x122D, 0x122D, 0x122C, 0x11EB, 
        0x11EA, 0x11A9, 0x11A9, 0x19EA, 0x19C9, 0x222B, 0x222B, 0x1A0B, 0x19EA, 0x19EA, 0x21E9, 0x19A8, 0x19A8, 0x21A7, 0x2187, 0x2187, 0x1966, 0x2166, 0x2165, 0x1945, 0x1945, 0x2145, 0x2144, 0x2145, 0x2145, 0x2165, 0x2985, 0x2985, 0x31A5, 0x2985, 
        0x3185, 0x31A5, 0x31A5, 0x31A5, 0x31A5, 0x31C6, 0x31C6, 0x31A5, 0x3185, 0x2965, 0x2964, 0x2144, 0x2103, 0x18E3, 0x18C2, 0x18A2, 0x10A2, 0x1081, 0x0861, 0x1061, 0x1081, 0x20E3, 0x4228, 0x5AEB, 0x4207, 0x39C6, 0x3185, 0x5288, 0x6B4B, 0x738C, 
        0x8C70, 0xA554, 0x8C91, 0x39E7, 0x2103, 0x2964, 0x2964, 0x2143, 0x2144, 0x2985, 0x2985, 0x2985, 0x2985, 0x31C6, 0x3A07, 0x3A07, 0x3A28, 0x3A28, 0x3A48, 0x4248, 0x4269, 0x3A48, 0x3A28, 0x3A28, 0x3A28, 0x3A48, 0x4248, 0x3A48, 0x3A28, 0x3A48, 
        0x3A28, 0x3A28, 0x3A48, 0x3A48, 0x3A28, 0x3A28, 0x3A48, 0x3A48, 0x3A48, 0x3A48, 0x3A28, 0x3A27, 0x3A48, 0x3A48, 0x3A48, 0x3A28, 0x3A48, 0x3A48, 0x3A48, 0x3A28, 0x3A28, 0x3A28, 0x3A28, 0x3A48, 0x3A28, 0x3A28, 0x3A48, 0x3A48, 0x3A48,
  0x2123, 0x2944, 0x2964, 0x2944, 0x2944, 0x2964, 0x2985, 0x3185, 0x2964, 0x2964, 0x2984, 0x3185, 0x2985, 0x2985, 0x2985, 0x2984, 0x3185, 0x31A5, 0x31C5, 0x31A5, 0x31A5, 0x39C5, 0x39E5, 0x41E6, 0x39C5, 0x39C5, 0x39E5, 0x41E6, 0x41E6, 0x4206, 0x4226, 
        0x4226, 0x4206, 0x4206, 0x39C5, 0x39E5, 0x39E5, 0x39C5, 0x41E6, 0x4206, 0x4A47, 0x4A47, 0x4A47, 0x5267, 0x5267, 0x5267, 0x5288, 0x5287, 0x4A67, 0x4A47, 0x4A47, 0x4A47, 0x5287, 0x5287, 0x5288, 0x5AA8, 0x5AA8, 0x5AC8, 0x5AC9, 0x5AC9, 0x5AC9, 
        0x5AA8, 0x52A8, 0x5AC8, 0x5AC8, 0x62E9, 0x62E9, 0x5AC9, 0x5AC8, 0x5AC8, 0x62E9, 0x5AC9, 0x52A8, 0x5AA8, 0x52A8, 0x5267, 0x5287, 0x5AC9, 0x5AC9, 0x5AA8, 0x5288, 0x5AC9, 0x62E9, 0x6B0A, 0x6309, 0x6309, 0x5AE9, 0x6309, 0x6309, 0x5AC9, 0x5AA8, 
        0x5AC9, 0x5AC8, 0x5AC8, 0x6309, 0x6309, 0x5AC9, 0x52A8, 0x52A8, 0x52A8, 0x5288, 0x4A47, 0x4A67, 0x4A68, 0x52A8, 0x52A9, 0x5288, 0x52A8, 0x52A8, 0x52A9, 0x52A9, 0x52A8, 0x5AC9, 0x5AC9, 0x5288, 0x4A68, 0x4A88, 0x52A9, 0x52A9, 0x5288, 0x4A88, 
        0x52A9, 0x5AC9, 0x5AC9, 0x5AC9, 0x5AE9, 0x52A8, 0x5288, 0x52A8, 0x52A9, 0x52A9, 0x52A8, 0x5AC9, 0x52A8, 0x5AC9, 0x6309, 0x6309, 0x5AC9, 0x5AA9, 0x52A8, 0x5AC9, 0x5AC9, 0x5AC9, 0x5AE9, 0x5AE9, 0x62E9, 0x5AE9, 0x6309, 0x5AE9, 0x5AE9, 0x5AE9, 
        0x5AE9, 0x5AC9, 0x5AC8, 0x5AC9, 0x52A8, 0x5AA8, 0x5AA8, 0x5AC8, 0x52A8, 0x5AC8, 0x5AE9, 0x62E9, 0x62E9, 0x5AE9, 0x5AE9, 0x6309, 0x6309, 0x62E9, 0x6309, 0x5AC9, 0x5AC9, 0x5AE9, 0x52A8, 0x52A8, 0x5AC9, 0x5AC9, 0x52A8, 0x52A8, 0x5288, 0x5288, 
        0x4A88, 0x4A67, 0x4A67, 0x4A67, 0x4A88, 0x4A87, 0x5288, 0x4A88, 0x4A68, 0x4A88, 0x4A88, 0x4A88, 0x4A88, 0x4A88, 0x4A88, 0x4A68, 0x4A67, 0x4A47, 0x4A47, 0x4A47, 0x4247, 0x4247, 0x4247, 0x4227, 0x4247, 0x4A68, 0x4247, 0x4247, 0x4A47, 0x4A47, 
        0x4A67, 0x4A67, 0x4247, 0x4247, 0x4247, 0x4227, 0x4227, 0x4227, 0x4A47, 0x4A27, 0x4227, 0x4227, 0x4227, 0x4206, 0x4206, 0x4207, 0x4206, 0x4207, 0x4207, 0x4227, 0x4206, 0x4207, 0x4227, 0x4206, 0x4207, 0x4A07, 0x4A07, 0x4A27, 0x4A27, 0x4227, 
        0x4227, 0x4227, 0x4A47, 0x4A27, 0x4207, 0x4227, 0x4248, 0x4A47, 0x4A68, 0x52C9, 0x4A48, 0x4A47, 0x4227, 0x4A48, 0x4A68, 0x4A68, 0x4A88, 0x4A48, 0x4A48, 0x4A88, 0x4A68, 0x4A88, 0x52A9, 0x52A9, 0x52A9, 0x52A9, 0x5288, 0x4A88, 0x4A89, 0x4AA9, 
        0x52A9, 0x4A89, 0x4AA9, 0x52A9, 0x5AEA, 0x5B0A, 0x5AEA, 0x52C9, 0x52EA, 0x5B0A, 0x5B0A, 0x5B0A, 0x5B0A, 0x5B0A, 0x5B0A, 0x5B0A, 0x5AC9, 0x52C9, 0x5ACA, 0x52C9, 0x5ACA, 0x5AEA, 0x52C9, 0x52A9, 0x52A9, 0x52C9, 0x52A9, 0x4AA9, 0x52CA, 0x4289, 
        0x21E8, 0x19E9, 0x1A09, 0x222A, 0x222B, 0x11EA, 0x11EA, 0x120B, 0x228D, 0x228D, 0x2AAE, 0x1A6C, 0x124C, 0x1AAE, 0x1AAE, 0x1AAD, 0x1AAE, 0x1AAE, 0x2ACE, 0x2B0F, 0x330F, 0x3330, 0x3B50, 0x3B50, 0x3B2F, 0x3B0F, 0x3B91, 0x43B1, 0x4B90, 0x5C33, 
        0x5C32, 0x53F1, 0x5C33, 0x6474, 0x3BB2, 0x22CF, 0x126E, 0x024F, 0x024E, 0x0A4E, 0x0A4E, 0x0A4D, 0x0A2D, 0x0A0D, 0x124D, 0x1A4C, 0x1A2B, 0x1A0B, 0x19EA, 0x19EA, 0x1A0B, 0x1A0B, 0x1A0A, 0x19E9, 0x19A8, 0x19A8, 0x1988, 0x1967, 0x1967, 0x1946, 
        0x1946, 0x1125, 0x1925, 0x1925, 0x1104, 0x1924, 0x2124, 0x2124, 0x1924, 0x1924, 0x2124, 0x2124, 0x2124, 0x2144, 0x2944, 0x29