/*********************************************************************
*                SEGGER Microcontroller GmbH                         *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2018  SEGGER Microcontroller GmbH                *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.48 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software  has been licensed to  Cypress Semiconductor Corporation,
whose registered  office is situated  at 198 Champion Ct. San Jose, CA 
95134 USA  solely for the  purposes of creating  libraries for Cypress
PSoC3 and  PSoC5 processor-based devices,  sublicensed and distributed
under  the  terms  and  conditions  of  the  Cypress  End User License
Agreement.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information
Licensor:                 SEGGER Microcontroller Systems LLC
Licensed to:              Cypress Semiconductor Corp, 198 Champion Ct., San Jose, CA 95134, USA
Licensed SEGGER software: emWin
License number:           GUI-00319
License model:            Services and License Agreement, signed June 10th, 2009
Licensed platform:        Any Cypress platform (Initial targets are: PSoC3, PSoC5)
----------------------------------------------------------------------
Support and Update Agreement (SUA)
SUA period:               2009-06-12 - 2022-07-27
Contact to extend SUA:    sales@segger.com
---------------------------------------------------------------------
File        : Font39SL_AA4.c
Purpose     : GUI_FONT_PROP_EXT, AA4, 39 Pixel
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI.h"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

/* The following line needs to be included in any file selecting the
   font.
*/
extern GUI_CONST_STORAGE GUI_FONT GUI_Font39SL_AA4;

/* Start of unicode area <Basic Latin> */
GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0020[  1] = { /* code 0020, SPACE */
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0021[ 23] = { /* code 0021, EXCLAMATION MARK */
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xEE,
  0xDD,
  0xDD,
  0xBC,
  0xBB,
  0xAB,
  0x99,
  0x99,
  0x00,
  0x00,
  0x00,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0022[ 27] = { /* code 0022, QUOTATION MARK */
  0xF0, 0x00, 0xF0,
  0xF0, 0x00, 0xF0,
  0xF0, 0x00, 0xF0,
  0xF0, 0x00, 0xF0,
  0xF0, 0x00, 0xF0,
  0xF0, 0x00, 0xF0,
  0xF0, 0x00, 0xF0,
  0xF0, 0x00, 0xF0,
  0xF0, 0x00, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0023[253] = { /* code 0023, NUMBER SIGN */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x6F, 0x50, 0x00, 0x4F, 0x70, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xBF, 0x10, 0x00, 0xAF, 0x20, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x02, 0xFA, 0x00, 0x00, 0xEB, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x07, 0xF5, 0x00, 0x05, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0C, 0xE0, 0x00, 0x0A, 0xF1, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x2F, 0xA0, 0x00, 0x1F, 0xB0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x8F, 0x40, 0x00, 0x6F, 0x60, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xDE, 0x00, 0x00, 0xBF, 0x10, 0x00, 0x00,
  0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x0B, 0xF2, 0x00, 0x09, 0xF3, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1F, 0xB0, 0x00, 0x0E, 0xD0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x5F, 0x70, 0x00, 0x4F, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xAF, 0x20, 0x00, 0x8F, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xEC, 0x00, 0x00, 0xDD, 0x00, 0x00, 0x00, 0x00,
  0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0x00,
  0x00, 0x00, 0x0D, 0xE0, 0x00, 0x0B, 0xF1, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0x90, 0x00, 0x1F, 0xA0, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x8F, 0x40, 0x00, 0x6F, 0x50, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xDD, 0x00, 0x00, 0xBE, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x03, 0xF8, 0x00, 0x02, 0xFA, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x09, 0xF3, 0x00, 0x07, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0E, 0xD0, 0x00, 0x0C, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x4F, 0x70, 0x00, 0x3F, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0024[216] = { /* code 0024, DOLLAR SIGN */
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x01, 0x8C, 0xFF, 0xFC, 0x81, 0x00, 0x00,
  0x00, 0x4E, 0xFF, 0xFF, 0xFF, 0xFE, 0x50, 0x00,
  0x02, 0xEF, 0xB4, 0x1F, 0x14, 0xBF, 0xE2, 0x00,
  0x09, 0xFB, 0x00, 0x0F, 0x00, 0x0B, 0xF9, 0x00,
  0x0D, 0xF3, 0x00, 0x0F, 0x00, 0x03, 0xFD, 0x00,
  0x0F, 0xF0, 0x00, 0x0F, 0x00, 0x00, 0x99, 0x00,
  0x0F, 0xF1, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x0B, 0xF6, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x05, 0xFE, 0x60, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x7F, 0xFE, 0x9F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x03, 0xAF, 0xFF, 0xFB, 0x61, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x4F, 0xEF, 0xFF, 0x70, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x02, 0x7E, 0xFB, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x01, 0xDF, 0x70,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x4F, 0xC0,
  0xFF, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x0F, 0xF0,
  0xEF, 0x30, 0x00, 0x0F, 0x00, 0x00, 0x0F, 0xF0,
  0xAF, 0x90, 0x00, 0x0F, 0x00, 0x00, 0x4F, 0xC0,
  0x4F, 0xF5, 0x00, 0x0F, 0x00, 0x01, 0xDF, 0x70,
  0x0A, 0xFF, 0xA4, 0x1F, 0x03, 0x7E, 0xFC, 0x10,
  0x00, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xB1, 0x00,
  0x00, 0x02, 0x8C, 0xEF, 0xFD, 0x94, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0025[288] = { /* code 0025, PERCENT SIGN */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00,
  0x00, 0x3A, 0xEF, 0xEA, 0x20, 0x00, 0x00, 0x00, 0x04, 0xF5, 0x00, 0x00,
  0x05, 0xFF, 0xFF, 0xFF, 0xF5, 0x00, 0x00, 0x00, 0x1D, 0xB0, 0x00, 0x00,
  0x3F, 0xF9, 0x20, 0x2A, 0xFF, 0x20, 0x00, 0x00, 0x8F, 0x20, 0x00, 0x00,
  0xAF, 0x90, 0x00, 0x00, 0xAF, 0xA0, 0x00, 0x03, 0xF7, 0x00, 0x00, 0x00,
  0xEF, 0x20, 0x00, 0x00, 0x2F, 0xE0, 0x00, 0x0C, 0xD0, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x6F, 0x30, 0x00, 0x00, 0x00,
  0xEF, 0x20, 0x00, 0x00, 0x2F, 0xE0, 0x01, 0xE9, 0x00, 0x00, 0x00, 0x00,
  0xAF, 0x90, 0x00, 0x00, 0x9F, 0xA0, 0x0A, 0xE1, 0x00, 0x00, 0x00, 0x00,
  0x2F, 0xF9, 0x20, 0x29, 0xFE, 0x20, 0x4F, 0x60, 0x00, 0x00, 0x00, 0x00,
  0x05, 0xFF, 0xFF, 0xFF, 0xE5, 0x00, 0xDB, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x2A, 0xEF, 0xEA, 0x20, 0x08, 0xF2, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0x80, 0x02, 0xAE, 0xFE, 0xA3, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xBD, 0x00, 0x5F, 0xFF, 0xFF, 0xFF, 0x50,
  0x00, 0x00, 0x00, 0x00, 0x06, 0xF4, 0x03, 0xFF, 0x92, 0x02, 0x9F, 0xF3,
  0x00, 0x00, 0x00, 0x00, 0x1E, 0xA0, 0x0A, 0xF9, 0x00, 0x00, 0x09, 0xFA,
  0x00, 0x00, 0x00, 0x00, 0x9E, 0x10, 0x0E, 0xF2, 0x00, 0x00, 0x02, 0xFE,
  0x00, 0x00, 0x00, 0x03, 0xF6, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x0D, 0xC0, 0x00, 0x0E, 0xF2, 0x00, 0x00, 0x02, 0xFE,
  0x00, 0x00, 0x00, 0x7F, 0x30, 0x00, 0x0A, 0xFA, 0x00, 0x00, 0x09, 0xFA,
  0x00, 0x00, 0x02, 0xF8, 0x00, 0x00, 0x02, 0xEF, 0xA2, 0x02, 0x9F, 0xF2,
  0x00, 0x00, 0x0B, 0xD1, 0x00, 0x00, 0x00, 0x5E, 0xFF, 0xFF, 0xFF, 0x50,
  0x00, 0x00, 0x5F, 0x50, 0x00, 0x00, 0x00, 0x02, 0xAE, 0xFE, 0xA2, 0x00,
  0x00, 0x00, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0026[230] = { /* code 0026, AMPERSAND */
  0x00, 0x00, 0x06, 0xCF, 0xFC, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xAF, 0xFF, 0xFF, 0xFB, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x07, 0xFD, 0x40, 0x05, 0xEF, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x0D, 0xF4, 0x00, 0x00, 0x4F, 0xD0, 0x00, 0x00, 0x00,
  0x00, 0x0F, 0xF0, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x0E, 0xF1, 0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0x0A, 0xF7, 0x00, 0x00, 0x7F, 0xA0, 0x00, 0x00, 0x00,
  0x00, 0x04, 0xFE, 0x20, 0x05, 0xFF, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xAF, 0xC2, 0x9F, 0xF5, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1D, 0xFF, 0xFD, 0x30, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x02, 0x9F, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x5E, 0xFC, 0x7F, 0xF7, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x06, 0xFE, 0x60, 0x05, 0xFF, 0x60, 0x00, 0x00, 0x00, 0x00,
  0x2F, 0xF3, 0x00, 0x00, 0x6F, 0xF5, 0x00, 0x0F, 0xF0, 0x00,
  0x9F, 0x70, 0x00, 0x00, 0x07, 0xFF, 0x30, 0x1F, 0xD0, 0x00,
  0xDF, 0x20, 0x00, 0x00, 0x00, 0x7F, 0xE3, 0x5F, 0xA0, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x08, 0xFE, 0xBF, 0x60, 0x00,
  0xFF, 0x10, 0x00, 0x00, 0x00, 0x00, 0x9F, 0xFD, 0x00, 0x00,
  0xBF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xFC, 0x00, 0x00,
  0x6F, 0xE3, 0x00, 0x00, 0x00, 0x03, 0xDF, 0xEF, 0x80, 0x00,
  0x0B, 0xFF, 0x83, 0x00, 0x15, 0xAF, 0xFA, 0x2E, 0xF3, 0x00,
  0x01, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0x70, 0x06, 0xFD, 0x10,
  0x00, 0x04, 0xAD, 0xFF, 0xEB, 0x71, 0x00, 0x00, 0xBF, 0xA0
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0027[  9] = { /* code 0027, APOSTROPHE */
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0028[116] = { /* code 0028, LEFT PARENTHESIS */
  0x00, 0x00, 0x2E, 0x90,
  0x00, 0x00, 0xCD, 0x10,
  0x00, 0x08, 0xF4, 0x00,
  0x00, 0x3F, 0xA0, 0x00,
  0x00, 0xAF, 0x30, 0x00,
  0x03, 0xFB, 0x00, 0x00,
  0x09, 0xF5, 0x00, 0x00,
  0x0E, 0xE0, 0x00, 0x00,
  0x3F, 0xB0, 0x00, 0x00,
  0x7F, 0x70, 0x00, 0x00,
  0xAF, 0x50, 0x00, 0x00,
  0xCF, 0x30, 0x00, 0x00,
  0xEF, 0x10, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xEF, 0x10, 0x00, 0x00,
  0xCF, 0x30, 0x00, 0x00,
  0xAF, 0x40, 0x00, 0x00,
  0x7F, 0x70, 0x00, 0x00,
  0x3F, 0xB0, 0x00, 0x00,
  0x0E, 0xE0, 0x00, 0x00,
  0x09, 0xF5, 0x00, 0x00,
  0x03, 0xFB, 0x00, 0x00,
  0x00, 0xAF, 0x30, 0x00,
  0x00, 0x3F, 0xA0, 0x00,
  0x00, 0x08, 0xF4, 0x00,
  0x00, 0x00, 0xCD, 0x10,
  0x00, 0x00, 0x2E, 0x90
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0029[116] = { /* code 0029, RIGHT PARENTHESIS */
  0x9E, 0x20, 0x00, 0x00,
  0x1D, 0xC0, 0x00, 0x00,
  0x03, 0xF8, 0x00, 0x00,
  0x00, 0xAF, 0x30, 0x00,
  0x00, 0x2F, 0xA0, 0x00,
  0x00, 0x0A, 0xF3, 0x00,
  0x00, 0x05, 0xF9, 0x00,
  0x00, 0x00, 0xEE, 0x00,
  0x00, 0x00, 0xAF, 0x30,
  0x00, 0x00, 0x7F, 0x70,
  0x00, 0x00, 0x4F, 0xA0,
  0x00, 0x00, 0x2F, 0xC0,
  0x00, 0x00, 0x1F, 0xE0,
  0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x1F, 0xE0,
  0x00, 0x00, 0x2F, 0xC0,
  0x00, 0x00, 0x4F, 0xA0,
  0x00, 0x00, 0x7F, 0x70,
  0x00, 0x00, 0xBF, 0x30,
  0x00, 0x00, 0xEE, 0x00,
  0x00, 0x05, 0xF9, 0x00,
  0x00, 0x0B, 0xF3, 0x00,
  0x00, 0x2F, 0xA0, 0x00,
  0x00, 0xAF, 0x30, 0x00,
  0x04, 0xF8, 0x00, 0x00,
  0x1D, 0xC0, 0x00, 0x00,
  0x9E, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_002A[ 66] = { /* code 002A, ASTERISK */
  0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x9A, 0x40, 0x0F, 0x00, 0x49, 0x70,
  0xDF, 0xFD, 0x8F, 0x8D, 0xFF, 0xB0,
  0x03, 0x7B, 0xFF, 0xFB, 0x72, 0x00,
  0x00, 0x00, 0xBF, 0xB0, 0x00, 0x00,
  0x00, 0x08, 0xF4, 0xF8, 0x00, 0x00,
  0x00, 0x5F, 0x70, 0x8F, 0x50, 0x00,
  0x03, 0xED, 0x00, 0x0D, 0xE3, 0x00,
  0x01, 0xA4, 0x00, 0x04, 0xA1, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_002B[190] = { /* code 002B, PLUS SIGN */
  0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_002C[  7] = { /* code 002C, COMMA */
  0xFF,
  0xFF,
  0xFF,
  0x0F,
  0x1F,
  0x8B,
  0xB1
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_002D[  8] = { /* code 002D, HYPHEN-MINUS */
  0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_002E[  3] = { /* code 002E, FULL STOP */
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_002F[130] = { /* code 002F, SOLIDUS */
  0x00, 0x00, 0x00, 0x00, 0xBC,
  0x00, 0x00, 0x00, 0x01, 0xF7,
  0x00, 0x00, 0x00, 0x06, 0xF2,
  0x00, 0x00, 0x00, 0x0B, 0xC0,
  0x00, 0x00, 0x00, 0x1F, 0x70,
  0x00, 0x00, 0x00, 0x5F, 0x20,
  0x00, 0x00, 0x00, 0xAC, 0x00,
  0x00, 0x00, 0x01, 0xF7, 0x00,
  0x00, 0x00, 0x05, 0xF2, 0x00,
  0x00, 0x00, 0x0A, 0xB0, 0x00,
  0x00, 0x00, 0x0E, 0x70, 0x00,
  0x00, 0x00, 0x5F, 0x20, 0x00,
  0x00, 0x00, 0xAB, 0x00, 0x00,
  0x00, 0x00, 0xE7, 0x00, 0x00,
  0x00, 0x04, 0xF2, 0x00, 0x00,
  0x00, 0x09, 0xB0, 0x00, 0x00,
  0x00, 0x0E, 0x60, 0x00, 0x00,
  0x00, 0x4F, 0x10, 0x00, 0x00,
  0x00, 0x8B, 0x00, 0x00, 0x00,
  0x00, 0xD6, 0x00, 0x00, 0x00,
  0x03, 0xF1, 0x00, 0x00, 0x00,
  0x08, 0xB0, 0x00, 0x00, 0x00,
  0x0D, 0x50, 0x00, 0x00, 0x00,
  0x3F, 0x10, 0x00, 0x00, 0x00,
  0x8A, 0x00, 0x00, 0x00, 0x00,
  0xD5, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0030[176] = { /* code 0030, DIGIT ZERO */
  0x00, 0x00, 0x6B, 0xEF, 0xEB, 0x60, 0x00, 0x00,
  0x00, 0x1C, 0xFF, 0xFF, 0xFF, 0xFB, 0x10, 0x00,
  0x00, 0xCF, 0xD6, 0x10, 0x15, 0xDF, 0xC0, 0x00,
  0x07, 0xFD, 0x10, 0x00, 0x00, 0x1C, 0xF7, 0x00,
  0x0E, 0xF3, 0x00, 0x00, 0x00, 0x03, 0xFE, 0x00,
  0x5F, 0xB0, 0x00, 0x00, 0x00, 0x00, 0xBF, 0x40,
  0x8F, 0x70, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x80,
  0xBF, 0x40, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xB0,
  0xDF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xDF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0xBF, 0x40, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xB0,
  0x8F, 0x70, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x80,
  0x4F, 0xB0, 0x00, 0x00, 0x00, 0x00, 0xBF, 0x50,
  0x0E, 0xF3, 0x00, 0x00, 0x00, 0x03, 0xFE, 0x00,
  0x07, 0xFD, 0x10, 0x00, 0x00, 0x1C, 0xF7, 0x00,
  0x00, 0xCF, 0xD6, 0x10, 0x15, 0xDF, 0xC0, 0x00,
  0x00, 0x1C, 0xFF, 0xFF, 0xFF, 0xFC, 0x10, 0x00,
  0x00, 0x00, 0x6B, 0xEF, 0xEB, 0x60, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0031[ 88] = { /* code 0031, DIGIT ONE */
  0x00, 0x00, 0x00, 0xDF,
  0x00, 0x00, 0x02, 0xFF,
  0x00, 0x00, 0x1C, 0xFF,
  0x01, 0x37, 0xDF, 0xFF,
  0xFF, 0xEC, 0x94, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0032[176] = { /* code 0032, DIGIT TWO */
  0x00, 0x00, 0x39, 0xDF, 0xFE, 0xB6, 0x00, 0x00,
  0x00, 0x09, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0x00,
  0x00, 0x9F, 0xF8, 0x30, 0x02, 0x6D, 0xFC, 0x00,
  0x03, 0xFF, 0x30, 0x00, 0x00, 0x01, 0xDF, 0x70,
  0x09, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x6F, 0xC0,
  0x0D, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xE0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xA0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xEF, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x6E, 0xF7, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x3C, 0xFF, 0x60, 0x00,
  0x00, 0x00, 0x00, 0x2A, 0xFF, 0xB2, 0x00, 0x00,
  0x00, 0x00, 0x08, 0xFF, 0xD5, 0x00, 0x00, 0x00,
  0x00, 0x03, 0xDF, 0xE6, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x5E, 0xFA, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x04, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1D, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7F, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xCF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD0
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0033[154] = { /* code 0033, DIGIT THREE */
  0x00, 0x00, 0x7C, 0xFF, 0xEA, 0x30, 0x00,
  0x00, 0x1C, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0x00, 0xBF, 0xD5, 0x10, 0x39, 0xFF, 0x40,
  0x04, 0xFE, 0x10, 0x00, 0x00, 0x8F, 0xB0,
  0x0A, 0xF7, 0x00, 0x00, 0x00, 0x2F, 0xE0,
  0x0D, 0xF3, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x9F, 0x80,
  0x00, 0x00, 0x00, 0x01, 0x4B, 0xFC, 0x10,
  0x00, 0x00, 0x06, 0xFF, 0xFF, 0xA1, 0x00,
  0x00, 0x00, 0x06, 0xFF, 0xFF, 0xF9, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x37, 0xDF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xF6,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xFC,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xEF, 0x30, 0x00, 0x00, 0x00, 0x02, 0xFE,
  0xAF, 0x80, 0x00, 0x00, 0x00, 0x06, 0xFB,
  0x5F, 0xE3, 0x00, 0x00, 0x00, 0x2E, 0xF5,
  0x0A, 0xFE, 0x72, 0x00, 0x37, 0xEF, 0xB0,
  0x01, 0xAF, 0xFF, 0xFF, 0xFF, 0xFB, 0x10,
  0x00, 0x04, 0xAD, 0xFF, 0xEA, 0x50, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0034[176] = { /* code 0034, DIGIT FOUR */
  0x00, 0x00, 0x00, 0x00, 0x09, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x5F, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0xEE, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0xF5, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x6F, 0xA0, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x02, 0xED, 0x10, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0xF4, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0x80, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x02, 0xEC, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x0C, 0xF3, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x7F, 0x70, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x03, 0xFB, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x0C, 0xE2, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x7F, 0x50, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0035[154] = { /* code 0035, DIGIT FIVE */
  0x00, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x01, 0xFB, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x03, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x05, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x08, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0xF1, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0C, 0xE1, 0x8C, 0xFF, 0xEA, 0x40, 0x00,
  0x0E, 0xDD, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x1F, 0xFD, 0x62, 0x00, 0x39, 0xFF, 0x80,
  0x4F, 0xB1, 0x00, 0x00, 0x00, 0x6F, 0xF2,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xF8,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xFC,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0xEF, 0x10, 0x00, 0x00, 0x00, 0x03, 0xFC,
  0xBF, 0x50, 0x00, 0x00, 0x00, 0x09, 0xF8,
  0x6F, 0xD2, 0x00, 0x00, 0x00, 0x4F, 0xF2,
  0x0C, 0xFE, 0x72, 0x00, 0x38, 0xFF, 0x70,
  0x01, 0xBF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x00, 0x05, 0xAE, 0xFF, 0xD9, 0x30, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0036[176] = { /* code 0036, DIGIT SIX */
  0x00, 0x00, 0x17, 0xCE, 0xFF, 0xC9, 0x30, 0x00,
  0x00, 0x05, 0xEF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x00, 0x5F, 0xFA, 0x41, 0x01, 0x38, 0xEF, 0x70,
  0x02, 0xEF, 0x60, 0x00, 0x00, 0x00, 0x4F, 0xD0,
  0x09, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1F, 0xF1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5F, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0x60, 0x29, 0xDF, 0xFD, 0x93, 0x00, 0x00,
  0xBF, 0x35, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
  0xDF, 0x5F, 0xE7, 0x20, 0x03, 0x9F, 0xF7, 0x00,
  0xFF, 0xDE, 0x20, 0x00, 0x00, 0x05, 0xFF, 0x20,
  0xFF, 0xF4, 0x00, 0x00, 0x00, 0x00, 0xAF, 0x80,
  0xFF, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xC0,
  0xEF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xE0,
  0xDF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xAF, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x6F, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0,
  0x2F, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x8F, 0x80,
  0x09, 0xFD, 0x20, 0x00, 0x00, 0x03, 0xFF, 0x20,
  0x01, 0xDF, 0xE7, 0x20, 0x03, 0x8F, 0xF7, 0x00,
  0x00, 0x1C, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
  0x00, 0x00, 0x5B, 0xEF, 0xFD, 0x93, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0037[154] = { /* code 0037, DIGIT SEVEN */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xF9,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xC0,
  0x00, 0x00, 0x00, 0x00, 0x02, 0xEE, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x0B, 0xF6, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x5F, 0xC0, 0x00,
  0x00, 0x00, 0x00, 0x01, 0xEF, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x07, 0xF9, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1E, 0xF2, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xEF, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x06, 0xFC, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0xF6, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x2F, 0xF1, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xB0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0x60, 0x00, 0x00, 0x00,
  0x00, 0x01, 0xFF, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x04, 0xFE, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0xFA, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0B, 0xF7, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0E, 0xF5, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0038[154] = { /* code 0038, DIGIT EIGHT */
  0x00, 0x03, 0x9D, 0xFF, 0xD9, 0x30, 0x00,
  0x00, 0x6F, 0xFF, 0xFF, 0xFF, 0xF6, 0x00,
  0x03, 0xFF, 0xA3, 0x00, 0x3A, 0xFF, 0x30,
  0x0A, 0xF9, 0x00, 0x00, 0x00, 0x9F, 0xA0,
  0x0E, 0xF2, 0x00, 0x00, 0x00, 0x2F, 0xE0,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x0D, 0xF2, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0x08, 0xF8, 0x00, 0x00, 0x00, 0x8F, 0x80,
  0x01, 0xDF, 0x93, 0x00, 0x39, 0xFD, 0x10,
  0x00, 0x1B, 0xFF, 0xFF, 0xFF, 0xB1, 0x00,
  0x00, 0x6E, 0xFF, 0xFF, 0xFF, 0xE5, 0x00,
  0x08, 0xFE, 0x72, 0x00, 0x27, 0xEF, 0x80,
  0x3F, 0xD2, 0x00, 0x00, 0x00, 0x2E, 0xF3,
  0xAF, 0x60, 0x00, 0x00, 0x00, 0x06, 0xFA,
  0xEF, 0x10, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xEF, 0x20, 0x00, 0x00, 0x00, 0x02, 0xFE,
  0xBF, 0x70, 0x00, 0x00, 0x00, 0x07, 0xFB,
  0x6F, 0xE3, 0x00, 0x00, 0x00, 0x3E, 0xF6,
  0x0B, 0xFF, 0x83, 0x00, 0x38, 0xFF, 0xB0,
  0x01, 0xBF, 0xFF, 0xFF, 0xFF, 0xFB, 0x10,
  0x00, 0x05, 0xAD, 0xFF, 0xDA, 0x50, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0039[176] = { /* code 0039, DIGIT NINE */
  0x00, 0x03, 0x9D, 0xFF, 0xEB, 0x50, 0x00, 0x00,
  0x00, 0x8F, 0xFF, 0xFF, 0xFF, 0xFC, 0x10, 0x00,
  0x07, 0xFF, 0x83, 0x00, 0x27, 0xEF, 0xD1, 0x00,
  0x2F, 0xF3, 0x00, 0x00, 0x00, 0x2D, 0xF9, 0x00,
  0x8F, 0x80, 0x00, 0x00, 0x00, 0x04, 0xFF, 0x20,
  0xCF, 0x30, 0x00, 0x00, 0x00, 0x00, 0xCF, 0x60,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9F, 0xA0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xD0,
  0xEF, 0x10, 0x00, 0x00, 0x00, 0x00, 0x9F, 0xE0,
  0xCF, 0x40, 0x00, 0x00, 0x00, 0x00, 0xCF, 0xF0,
  0x8F, 0xA0, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xF0,
  0x2F, 0xF5, 0x00, 0x00, 0x00, 0x2E, 0xDF, 0xF0,
  0x07, 0xFF, 0x93, 0x00, 0x27, 0xEF, 0x5F, 0xD0,
  0x00, 0x8F, 0xFF, 0xFF, 0xFF, 0xF6, 0x3F, 0xB0,
  0x00, 0x03, 0x9D, 0xFF, 0xD9, 0x20, 0x6F, 0x90,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAF, 0x50,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xEF, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xF9, 0x00,
  0xDF, 0x40, 0x00, 0x00, 0x00, 0x5F, 0xE2, 0x00,
  0x7F, 0xE8, 0x31, 0x01, 0x39, 0xFF, 0x50, 0x00,
  0x09, 0xFF, 0xFF, 0xFF, 0xFF, 0xE5, 0x00, 0x00,
  0x00, 0x39, 0xDF, 0xFE, 0xC7, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_003A[ 16] = { /* code 003A, COLON */
  0xFF,
  0xFF,
  0xFF,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_003B[ 20] = { /* code 003B, SEMICOLON */
  0xFF,
  0xFF,
  0xFF,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0xFF,
  0xFF,
  0xFF,
  0x0F,
  0x1F,
  0x9B,
  0xB1
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_003C[144] = { /* code 003C, LESS-THAN SIGN */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x8E, 0xF9,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xBF, 0xD7, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x17, 0xDF, 0xA4, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x39, 0xFE, 0x82, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x5C, 0xFB, 0x50, 0x00, 0x00, 0x00, 0x00,
  0x02, 0x8E, 0xE9, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xAF, 0xC6, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xBF, 0xC6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x02, 0x8E, 0xE8, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x5C, 0xFB, 0x40, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x39, 0xFD, 0x71, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x17, 0xDF, 0xA3, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xBF, 0xC6, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x8E, 0xE9,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_003D[ 60] = { /* code 003D, EQUALS SIGN */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_003E[144] = { /* code 003E, GREATER-THAN SIGN */
  0xC6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xE8, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x7D, 0xFB, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x4A, 0xFD, 0x71, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x28, 0xEF, 0x93, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0xBF, 0xC5, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x9E, 0xE8, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x6C, 0xFA,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0xFB,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x8E, 0xE8, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x04, 0xBF, 0xC5, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x17, 0xDF, 0x93, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x3A, 0xFD, 0x71, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x6C, 0xFB, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x9E, 0xE8, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xC6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_003F[161] = { /* code 003F, QUESTION MARK */
  0x00, 0x04, 0xAD, 0xFF, 0xEB, 0x71, 0x00,
  0x01, 0xAF, 0xFF, 0xFF, 0xFF, 0xFD, 0x30,
  0x0A, 0xFF, 0x83, 0x00, 0x15, 0xCF, 0xE2,
  0x4F, 0xE3, 0x00, 0x00, 0x00, 0x1C, 0xF9,
  0x9F, 0x80, 0x00, 0x00, 0x00, 0x03, 0xFD,
  0xDF, 0x30, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFB,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xF5,
  0x00, 0x00, 0x00, 0x00, 0x03, 0xEF, 0xA0,
  0x00, 0x00, 0x00, 0x00, 0x5E, 0xFA, 0x00,
  0x00, 0x00, 0x00, 0x05, 0xFF, 0x70, 0x00,
  0x00, 0x00, 0x00, 0x3F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xAF, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xDF, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xDD, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xDD, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0040[378] = { /* code 0040, COMMERCIAL AT */
  0x00, 0x00, 0x00, 0x00, 0x01, 0x59, 0xCE, 0xFF, 0xFD, 0xB7, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x02, 0x9E, 0xA6, 0x31, 0x00, 0x02, 0x48, 0xDC, 0x40, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x8E, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xCA, 0x10, 0x00,
  0x00, 0x00, 0x1C, 0xA1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xD1, 0x00,
  0x00, 0x01, 0xD7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x00,
  0x00, 0x1D, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x80,
  0x00, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xE2,
  0x03, 0xD1, 0x00, 0x00, 0x00, 0x05, 0xBE, 0xFE, 0xA2, 0x03, 0x70, 0x00, 0x00, 0x87,
  0x0B, 0x60, 0x00, 0x00, 0x01, 0xAF, 0x92, 0x01, 0x7D, 0x2C, 0xA0, 0x00, 0x00, 0x4B,
  0x2E, 0x00, 0x00, 0x00, 0x0B, 0xF5, 0x00, 0x00, 0x06, 0xCF, 0x70, 0x00, 0x00, 0x1E,
  0x79, 0x00, 0x00, 0x00, 0x8F, 0x70, 0x00, 0x00, 0x00, 0xDF, 0x30, 0x00, 0x00, 0x0F,
  0xB5, 0x00, 0x00, 0x02, 0xFE, 0x00, 0x00, 0x00, 0x00, 0xAE, 0x00, 0x00, 0x00, 0x0F,
  0xD2, 0x00, 0x00, 0x07, 0xF8, 0x00, 0x00, 0x00, 0x00, 0xEB, 0x00, 0x00, 0x00, 0x2D,
  0xF0, 0x00, 0x00, 0x0B, 0xF4, 0x00, 0x00, 0x00, 0x02, 0xF7, 0x00, 0x00, 0x00, 0x5B,
  0xF0, 0x00, 0x00, 0x0E, 0xF1, 0x00, 0x00, 0x00, 0x06, 0xF4, 0x00, 0x00, 0x00, 0x97,
  0xF0, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, 0x09, 0xF1, 0x00, 0x00, 0x01, 0xE1,
  0xD2, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, 0x0E, 0xC0, 0x00, 0x00, 0x08, 0x90,
  0xA5, 0x00, 0x00, 0x0C, 0xF3, 0x00, 0x00, 0x00, 0x6F, 0x80, 0x00, 0x00, 0x4D, 0x10,
  0x69, 0x00, 0x00, 0x07, 0xFA, 0x00, 0x00, 0x03, 0xBF, 0x60, 0x00, 0x04, 0xD2, 0x00,
  0x1D, 0x10, 0x00, 0x00, 0xBF, 0x82, 0x02, 0x7B, 0x2F, 0xC2, 0x03, 0xAC, 0x20, 0x00,
  0x08, 0x80, 0x00, 0x00, 0x07, 0xCF, 0xFC, 0x70, 0x05, 0xDF, 0xEB, 0x60, 0x00, 0x00,
  0x00, 0xC4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x2D, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x02, 0xC6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x70, 0x00,
  0x00, 0x00, 0x19, 0xB4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0xC9, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x3A, 0xD9, 0x53, 0x10, 0x00, 0x24, 0x7B, 0xE9, 0x20, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x16, 0x9C, 0xDF, 0xFF, 0xDC, 0x85, 0x10, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0041[230] = { /* code 0041, LATIN CAPITAL LETTER A */
  0x00, 0x00, 0x00, 0x00, 0x8F, 0xF6, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xEF, 0xFC, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x04, 0xFC, 0xEF, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0xF6, 0x9F, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1F, 0xF1, 0x3F, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x6F, 0xA0, 0x0D, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xCF, 0x40, 0x07, 0xFA, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0xFD, 0x00, 0x01, 0xFF, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x08, 0xF8, 0x00, 0x00, 0xBF, 0x70, 0x00, 0x00,
  0x00, 0x00, 0x0E, 0xF2, 0x00, 0x00, 0x5F, 0xD0, 0x00, 0x00,
  0x00, 0x00, 0x4F, 0xB0, 0x00, 0x00, 0x0E, 0xF3, 0x00, 0x00,
  0x00, 0x00, 0xAF, 0x60, 0x00, 0x00, 0x08, 0xF9, 0x00, 0x00,
  0x00, 0x01, 0xFE, 0x10, 0x00, 0x00, 0x03, 0xFE, 0x00, 0x00,
  0x00, 0x07, 0xF9, 0x00, 0x00, 0x00, 0x00, 0xCF, 0x60, 0x00,
  0x00, 0x0C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0, 0x00,
  0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2, 0x00,
  0x00, 0x8F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xF8, 0x00,
  0x00, 0xEF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x04, 0xFD, 0x00,
  0x05, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEF, 0x40,
  0x0A, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8F, 0xA0,
  0x1F, 0xF1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xF1,
  0x7F, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0xF6,
  0xCF, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xFC
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0042[207] = { /* code 0042, LATIN CAPITAL LETTER B */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDA, 0x50, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x20, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x01, 0x37, 0xDF, 0xD1, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0xF8, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFD, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFB, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0xF4, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x02, 0x37, 0xDF, 0x80, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF5, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x25, 0xAF, 0xF9, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xEF, 0x40,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xA0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xE0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xC0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xCF, 0x70,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x13, 0x7D, 0xFC, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xED, 0xB6, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0043[230] = { /* code 0043, LATIN CAPITAL LETTER C */
  0x00, 0x00, 0x01, 0x7B, 0xEF, 0xFE, 0xC8, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x20, 0x00,
  0x00, 0x0B, 0xFF, 0xA5, 0x20, 0x01, 0x49, 0xFF, 0xE2, 0x00,
  0x00, 0xAF, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x2C, 0xFD, 0x00,
  0x05, 0xFE, 0x20, 0x00, 0x00, 0x00, 0x00, 0x01, 0xDF, 0x70,
  0x0D, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6F, 0xC0,
  0x4F, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xE0,
  0x8F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xBF, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xBF, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x8F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xE0,
  0x4F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xC0,
  0x0D, 0xF7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAF, 0x80,
  0x05, 0xFF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x04, 0xFF, 0x20,
  0x00, 0xAF, 0xE4, 0x00, 0x00, 0x00, 0x00, 0x4E, 0xF8, 0x00,
  0x00, 0x1B, 0xFF, 0xB5, 0x20, 0x02, 0x5A, 0xFF, 0xA0, 0x00,
  0x00, 0x00, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x02, 0x7B, 0xEF, 0xFE, 0xB7, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0044[207] = { /* code 0044, LATIN CAPITAL LETTER D */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xC9, 0x50, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x30, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x02, 0x37, 0xEF, 0xE3, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1A, 0xFD, 0x10,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xBF, 0x80,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xE1,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0xF5,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xF9,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFC,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xFE,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFD,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFC,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xF9,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xF5,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xE1,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xBF, 0x80,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xFD, 0x10,
  0xFF, 0x00, 0x00, 0x00, 0x02, 0x37, 0xDF, 0xE3, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x20, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xC9, 0x50, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0045[184] = { /* code 0045, LATIN CAPITAL LETTER E */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x90,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x90,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0046[184] = { /* code 0046, LATIN CAPITAL LETTER F */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0047[230] = { /* code 0047, LATIN CAPITAL LETTER G */
  0x00, 0x00, 0x00, 0x5A, 0xDF, 0xFF, 0xDB, 0x73, 0x00, 0x00,
  0x00, 0x00, 0x6E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA2, 0x00,
  0x00, 0x09, 0xFF, 0xC6, 0x30, 0x00, 0x25, 0x9F, 0xFE, 0x30,
  0x00, 0x8F, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x01, 0xBF, 0xE1,
  0x04, 0xFF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0xF8,
  0x0C, 0xF7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFD,
  0x3F, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x8F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xBF, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xDF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xBF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF,
  0x8F, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xFF,
  0x3F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xFF,
  0x0C, 0xF7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xFF,
  0x04, 0xFF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0xBF, 0xEF,
  0x00, 0x9F, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x1B, 0xF7, 0xDF,
  0x00, 0x0A, 0xFF, 0xB5, 0x20, 0x01, 0x49, 0xEF, 0xA0, 0xBF,
  0x00, 0x00, 0x7E, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x00, 0xBF,
  0x00, 0x00, 0x01, 0x7B, 0xDF, 0xFE, 0xB7, 0x10, 0x00, 0xAF
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0048[207] = { /* code 0048, LATIN CAPITAL LETTER H */
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0049[ 23] = { /* code 0049, LATIN CAPITAL LETTER I */
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_004A[138] = { /* code 004A, LATIN CAPITAL LETTER J */
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x10, 0x00, 0x00, 0x01, 0xFF,
  0xDF, 0x40, 0x00, 0x00, 0x04, 0xFC,
  0x9F, 0xA0, 0x00, 0x00, 0x0B, 0xF8,
  0x3F, 0xFA, 0x30, 0x03, 0xAF, 0xE1,
  0x07, 0xFF, 0xFF, 0xFF, 0xFE, 0x30,
  0x00, 0x3A, 0xEF, 0xFC, 0x82, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_004B[207] = { /* code 004B, LATIN CAPITAL LETTER K */
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0x70,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xF7, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x06, 0xFF, 0x70, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xF7, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x05, 0xFF, 0x70, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x5F, 0xF7, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x05, 0xFF, 0x70, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x5F, 0xF7, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x05, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x5F, 0xF9, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x05, 0xFF, 0xFE, 0x30, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x5F, 0xF7, 0xAF, 0xD1, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0x70, 0x1C, 0xFB, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF7, 0x00, 0x02, 0xEF, 0x70, 0x00, 0x00, 0x00,
  0xFF, 0x70, 0x00, 0x00, 0x5F, 0xF4, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x08, 0xFE, 0x20, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xBF, 0xC1, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xFA, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 0x70, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6F, 0xF4, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xFE, 0x20,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xCF, 0xC0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0xF9
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_004C[161] = { /* code 004C, LATIN CAPITAL LETTER L */
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_004D[253] = { /* code 004D, LATIN CAPITAL LETTER M */
  0xFF, 0xF2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xF0,
  0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xFF, 0xF0,
  0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0xFF, 0xF0,
  0xFF, 0xCF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xCF, 0xF0,
  0xFF, 0x6F, 0xB0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x7F, 0xF0,
  0xFF, 0x0E, 0xF2, 0x00, 0x00, 0x00, 0x00, 0x00, 0xCF, 0x2F, 0xF0,
  0xFF, 0x09, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFB, 0x0F, 0xF0,
  0xFF, 0x03, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x08, 0xF6, 0x0F, 0xF0,
  0xFF, 0x00, 0xCF, 0x50, 0x00, 0x00, 0x00, 0x0D, 0xF1, 0x0F, 0xF0,
  0xFF, 0x00, 0x6F, 0xB0, 0x00, 0x00, 0x00, 0x3F, 0xB0, 0x0F, 0xF0,
  0xFF, 0x00, 0x1E, 0xF2, 0x00, 0x00, 0x00, 0x9F, 0x50, 0x0F, 0xF0,
  0xFF, 0x00, 0x09, 0xF8, 0x00, 0x00, 0x00, 0xEF, 0x10, 0x0F, 0xF0,
  0xFF, 0x00, 0x03, 0xFD, 0x00, 0x00, 0x04, 0xFA, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0xCF, 0x40, 0x00, 0x0A, 0xF5, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x6F, 0xB0, 0x00, 0x0E, 0xE0, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x1E, 0xF2, 0x00, 0x5F, 0x90, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x09, 0xF7, 0x00, 0xAF, 0x40, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x03, 0xFD, 0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0xCF, 0x46, 0xF8, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x6F, 0xAB, 0xF3, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x1E, 0xFF, 0xD0, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x09, 0xFF, 0x80, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x03, 0xFF, 0x30, 0x00, 0x00, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_004E[207] = { /* code 004E, LATIN CAPITAL LETTER N */
  0xFF, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0xFD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0xCF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x3F, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x08, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x01, 0xDF, 0x70, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x4F, 0xF2, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x09, 0xFB, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x01, 0xEF, 0x60, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x5F, 0xE2, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0B, 0xFB, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x02, 0xEF, 0x50, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x6F, 0xE1, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0B, 0xF9, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x02, 0xFF, 0x40, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xD1, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0C, 0xF8, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 0x3F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8F, 0xCF, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xFF, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xFF, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_004F[253] = { /* code 004F, LATIN CAPITAL LETTER O */
  0x00, 0x00, 0x00, 0x5A, 0xDF, 0xFF, 0xDA, 0x50, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x5E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x50, 0x00, 0x00,
  0x00, 0x08, 0xFF, 0xD7, 0x30, 0x01, 0x37, 0xDF, 0xF8, 0x00, 0x00,
  0x00, 0x8F, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x08, 0xFF, 0x80, 0x00,
  0x03, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xF3, 0x00,
  0x0C, 0xF9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xFC, 0x00,
  0x3F, 0xF1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xEF, 0x30,
  0x8F, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9F, 0x80,
  0xBF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xB0,
  0xDF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xDF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0xBF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xB0,
  0x8F, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9F, 0x80,
  0x3F, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xEF, 0x30,
  0x0C, 0xF9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0xFC, 0x00,
  0x03, 0xFF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xF3, 0x00,
  0x00, 0x8F, 0xF7, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0x80, 0x00,
  0x00, 0x08, 0xFF, 0xD7, 0x30, 0x01, 0x37, 0xDF, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0x5E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x50, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x5A, 0xDF, 0xFF, 0xDA, 0x50, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0050[184] = { /* code 0050, LATIN CAPITAL LETTER P */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC9, 0x40, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x10,
  0xFF, 0x00, 0x00, 0x00, 0x01, 0x37, 0xEF, 0xC0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xF7,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xFC,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xFB,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0xF6,
  0xFF, 0x00, 0x00, 0x00, 0x02, 0x59, 0xFF, 0xB0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x10,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xB7, 0x20, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0051[264] = { /* code 0051, LATIN CAPITAL LETTER Q */
  0x00, 0x00, 0x00, 0x5A, 0xDF, 0xFF, 0xDA, 0x50, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x5E, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x50, 0x00, 0x00,
  0x00, 0x08, 0xFF, 0xD7, 0x30, 0x01, 0x37, 0xDF, 0xF9, 0x00, 0x00,
  0x00, 0x8F, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0x80, 0x00,
  0x03, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xF4, 0x00,
  0x0C, 0xF9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xFC, 0x00,
  0x3F, 0xF1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xEF, 0x30,
  0x8F, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8F, 0x80,
  0xBF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xB0,
  0xDF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xDF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0xBF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xB0,
  0x8F, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAF, 0x70,
  0x3F, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0x02, 0xFF, 0x20,
  0x0B, 0xF8, 0x00, 0x00, 0x00, 0x01, 0xEF, 0xB1, 0x0B, 0xFA, 0x00,
  0x03, 0xFF, 0x50, 0x00, 0x00, 0x00, 0x3E, 0xFC, 0x9F, 0xE2, 0x00,
  0x00, 0x7F, 0xF7, 0x00, 0x00, 0x00, 0x02, 0xDF, 0xFF, 0x50, 0x00,
  0x00, 0x08, 0xFF, 0xD7, 0x31, 0x00, 0x38, 0xEF, 0xFE, 0x20, 0x00,
  0x00, 0x00, 0x5D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xAF, 0xC0, 0x00,
  0x00, 0x00, 0x00, 0x5A, 0xDF, 0xFF, 0xDA, 0x50, 0x07, 0xF9, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x59, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0052[184] = { /* code 0052, LATIN CAPITAL LETTER R */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDA, 0x60, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x20,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x26, 0xDF, 0xD0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xF7,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xFC,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xFE,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xFA,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2E, 0xF4,
  0xFF, 0x00, 0x00, 0x00, 0x01, 0x38, 0xEF, 0x80,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE6, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD4, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x39, 0xFF, 0x30,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAF, 0x90,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xC0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xE0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0xF2,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0xF4,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xF5,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xF7,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFC
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0053[207] = { /* code 0053, LATIN CAPITAL LETTER S */
  0x00, 0x00, 0x4A, 0xDF, 0xFE, 0xC8, 0x20, 0x00, 0x00,
  0x00, 0x1C, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00,
  0x01, 0xDF, 0xE7, 0x30, 0x01, 0x4A, 0xFF, 0x80, 0x00,
  0x08, 0xFD, 0x10, 0x00, 0x00, 0x00, 0x5F, 0xF3, 0x00,
  0x0D, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x09, 0xF9, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFD, 0x00,
  0x0E, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x0B, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x05, 0xFE, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x7F, 0xFC, 0x74, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x03, 0xAF, 0xFF, 0xFC, 0x94, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x58, 0xBF, 0xFF, 0xE8, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0xEF, 0xE4, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFE, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8F, 0xA0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xE0,
  0xEF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xBF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xE0,
  0x6F, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xB0,
  0x0D, 0xFD, 0x20, 0x00, 0x00, 0x00, 0x04, 0xEF, 0x50,
  0x03, 0xEF, 0xF9, 0x41, 0x00, 0x25, 0xAF, 0xFA, 0x00,
  0x00, 0x3C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
  0x00, 0x00, 0x49, 0xCE, 0xFF, 0xEB, 0x72, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0054[184] = { /* code 0054, LATIN CAPITAL LETTER T */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0055[207] = { /* code 0055, LATIN CAPITAL LETTER U */
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF0,
  0xCF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0,
  0x9F, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x90,
  0x5F, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x01, 0xEF, 0x40,
  0x0D, 0xFA, 0x00, 0x00, 0x00, 0x00, 0x1A, 0xFC, 0x00,
  0x03, 0xEF, 0xD7, 0x30, 0x00, 0x37, 0xDF, 0xE3, 0x00,
  0x00, 0x3D, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x30, 0x00,
  0x00, 0x00, 0x5A, 0xDF, 0xFF, 0xDA, 0x50, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0056[207] = { /* code 0056, LATIN CAPITAL LETTER V */
  0xCF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xFC,
  0x7F, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xF7,
  0x2F, 0xF1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0xF2,
  0x0B, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xB0,
  0x07, 0xFA, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAF, 0x70,
  0x02, 0xFF, 0x10, 0x00, 0x00, 0x00, 0x01, 0xFF, 0x20,
  0x00, 0xBF, 0x50, 0x00, 0x00, 0x00, 0x05, 0xFB, 0x00,
  0x00, 0x6F, 0xB0, 0x00, 0x00, 0x00, 0x0A, 0xF6, 0x00,
  0x00, 0x1F, 0xF1, 0x00, 0x00, 0x00, 0x1F, 0xF1, 0x00,
  0x00, 0x0A, 0xF6, 0x00, 0x00, 0x00, 0x5F, 0xA0, 0x00,
  0x00, 0x05, 0xFB, 0x00, 0x00, 0x00, 0xAF, 0x50, 0x00,
  0x00, 0x01, 0xEF, 0x10, 0x00, 0x01, 0xFE, 0x10, 0x00,
  0x00, 0x00, 0xAF, 0x60, 0x00, 0x05, 0xFA, 0x00, 0x00,
  0x00, 0x00, 0x5F, 0xB0, 0x00, 0x0A, 0xF5, 0x00, 0x00,
  0x00, 0x00, 0x0E, 0xF1, 0x00, 0x1F, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0x09, 0xF6, 0x00, 0x5F, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x04, 0xFB, 0x00, 0xAF, 0x40, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xDF, 0x11, 0xFD, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x8F, 0x66, 0xF8, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3F, 0xBB, 0xF3, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0D, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x08, 0xFF, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0xFF, 0x30, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0057[322] = { /* code 0057, LATIN CAPITAL LETTER W */
  0xDF, 0x30, 0x00, 0x00, 0x00, 0x02, 0xFF, 0xF2, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0x9F, 0x70, 0x00, 0x00, 0x00, 0x06, 0xFF, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x6F, 0x90,
  0x5F, 0xB0, 0x00, 0x00, 0x00, 0x09, 0xFE, 0xF9, 0x00, 0x00, 0x00, 0x00, 0x9F, 0x50,
  0x1F, 0xE0, 0x00, 0x00, 0x00, 0x0D, 0xF7, 0xFD, 0x00, 0x00, 0x00, 0x00, 0xDF, 0x10,
  0x0C, 0xF3, 0x00, 0x00, 0x00, 0x2F, 0xE1, 0xFF, 0x20, 0x00, 0x00, 0x02, 0xFC, 0x00,
  0x08, 0xF7, 0x00, 0x00, 0x00, 0x6F, 0xA0, 0xBF, 0x60, 0x00, 0x00, 0x06, 0xF8, 0x00,
  0x05, 0xFB, 0x00, 0x00, 0x00, 0x9F, 0x60, 0x7F, 0x90, 0x00, 0x00, 0x09, 0xF5, 0x00,
  0x01, 0xFF, 0x00, 0x00, 0x00, 0xDF, 0x20, 0x3F, 0xD0, 0x00, 0x00, 0x0D, 0xF1, 0x00,
  0x00, 0xCF, 0x40, 0x00, 0x01, 0xFD, 0x00, 0x0E, 0xF2, 0x00, 0x00, 0x2F, 0xC0, 0x00,
  0x00, 0x8F, 0x70, 0x00, 0x05, 0xF9, 0x00, 0x0A, 0xF6, 0x00, 0x00, 0x6F, 0x80, 0x00,
  0x00, 0x4F, 0xB0, 0x00, 0x09, 0xF5, 0x00, 0x06, 0xFA, 0x00, 0x00, 0xAF, 0x40, 0x00,
  0x00, 0x0F, 0xF0, 0x00, 0x0D, 0xF1, 0x00, 0x02, 0xFE, 0x00, 0x00, 0xEF, 0x00, 0x00,
  0x00, 0x0B, 0xF4, 0x00, 0x1F, 0xC0, 0x00, 0x00, 0xDF, 0x20, 0x02, 0xFB, 0x00, 0x00,
  0x00, 0x07, 0xF7, 0x00, 0x5F, 0x80, 0x00, 0x00, 0x9F, 0x60, 0x06, 0xF7, 0x00, 0x00,
  0x00, 0x03, 0xFB, 0x00, 0x9F, 0x40, 0x00, 0x00, 0x5F, 0xA0, 0x0A, 0xF3, 0x00, 0x00,
  0x00, 0x00, 0xEF, 0x00, 0xDF, 0x00, 0x00, 0x00, 0x1F, 0xE0, 0x0E, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0xAF, 0x41, 0xFB, 0x00, 0x00, 0x00, 0x0B, 0xF2, 0x2F, 0xA0, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0x75, 0xF7, 0x00, 0x00, 0x00, 0x07, 0xF6, 0x6F, 0x70, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xB8, 0xF3, 0x00, 0x00, 0x00, 0x03, 0xFA, 0xAF, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x0E, 0xFD, 0xE0, 0x00, 0x00, 0x00, 0x00, 0xEE, 0xEE, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0xFF, 0xA0, 0x00, 0x00, 0x00, 0x00, 0xAF, 0xFA, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x06, 0xFF, 0x60, 0x00, 0x00, 0x00, 0x00, 0x6F, 0xF6, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x02, 0xFF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xF2, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0058[207] = { /* code 0058, LATIN CAPITAL LETTER X */
  0xAF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xBF, 0xA0,
  0x1E, 0xF7, 0x00, 0x00, 0x00, 0x00, 0x06, 0xFE, 0x10,
  0x05, 0xFE, 0x20, 0x00, 0x00, 0x00, 0x2E, 0xF6, 0x00,
  0x00, 0xBF, 0xB0, 0x00, 0x00, 0x00, 0xAF, 0xB0, 0x00,
  0x00, 0x2E, 0xF6, 0x00, 0x00, 0x05, 0xFE, 0x20, 0x00,
  0x00, 0x06, 0xFE, 0x10, 0x00, 0x1D, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0xA0, 0x00, 0x9F, 0xC0, 0x00, 0x00,
  0x00, 0x00, 0x2E, 0xF4, 0x03, 0xFF, 0x20, 0x00, 0x00,
  0x00, 0x00, 0x06, 0xFD, 0x1D, 0xF7, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xBF, 0xDF, 0xC0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x2E, 0xFF, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0D, 0xFE, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xFF, 0x90, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x02, 0xFF, 0x6F, 0xF5, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0xF9, 0x07, 0xFE, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x5F, 0xE1, 0x00, 0xBF, 0xB0, 0x00, 0x00,
  0x00, 0x01, 0xEF, 0x60, 0x00, 0x2E, 0xF6, 0x00, 0x00,
  0x00, 0x09, 0xFC, 0x00, 0x00, 0x06, 0xFF, 0x20, 0x00,
  0x00, 0x3F, 0xF3, 0x00, 0x00, 0x00, 0xBF, 0xC0, 0x00,
  0x00, 0xCF, 0x80, 0x00, 0x00, 0x00, 0x1E, 0xF8, 0x00,
  0x07, 0xFD, 0x10, 0x00, 0x00, 0x00, 0x05, 0xFF, 0x40,
  0x2E, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9F, 0xD1,
  0xAF, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xFA
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0059[207] = { /* code 0059, LATIN CAPITAL LETTER Y */
  0xAF, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xFA,
  0x2E, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xE2,
  0x07, 0xFD, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDF, 0x70,
  0x00, 0xCF, 0x80, 0x00, 0x00, 0x00, 0x08, 0xFC, 0x00,
  0x00, 0x3F, 0xF2, 0x00, 0x00, 0x00, 0x2F, 0xF3, 0x00,
  0x00, 0x09, 0xFB, 0x00, 0x00, 0x00, 0xBF, 0x90, 0x00,
  0x00, 0x01, 0xEF, 0x50, 0x00, 0x05, 0xFE, 0x10, 0x00,
  0x00, 0x00, 0x5F, 0xD1, 0x00, 0x1D, 0xF5, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0xF8, 0x00, 0x8F, 0xB0, 0x00, 0x00,
  0x00, 0x00, 0x02, 0xFF, 0x33, 0xFF, 0x20, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xBB, 0xF7, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0D, 0xFF, 0xD0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0xFF, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_005A[207] = { /* code 005A, LATIN CAPITAL LETTER Z */
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 0x40,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xF8, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAF, 0xB0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFE, 0x20, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xF4, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0xDF, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0A, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x6F, 0xE2, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0xFF, 0x40, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1D, 0xF8, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xAF, 0xC0, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x06, 0xFE, 0x20, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x3E, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x01, 0xCF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x09, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x5F, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x02, 0xEF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x0C, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_005B[ 87] = { /* code 005B, LEFT SQUARE BRACKET */
  0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_005C[130] = { /* code 005C, REVERSE SOLIDUS */
  0xD5, 0x00, 0x00, 0x00, 0x00,
  0x8A, 0x00, 0x00, 0x00, 0x00,
  0x3F, 0x10, 0x00, 0x00, 0x00,
  0x0D, 0x50, 0x00, 0x00, 0x00,
  0x08, 0xB0, 0x00, 0x00, 0x00,
  0x03, 0xF1, 0x00, 0x00, 0x00,
  0x00, 0xD6, 0x00, 0x00, 0x00,
  0x00, 0x8B, 0x00, 0x00, 0x00,
  0x00, 0x4F, 0x10, 0x00, 0x00,
  0x00, 0x0E, 0x60, 0x00, 0x00,
  0x00, 0x09, 0xB0, 0x00, 0x00,
  0x00, 0x04, 0xF2, 0x00, 0x00,
  0x00, 0x00, 0xE7, 0x00, 0x00,
  0x00, 0x00, 0xAB, 0x00, 0x00,
  0x00, 0x00, 0x5F, 0x20, 0x00,
  0x00, 0x00, 0x0E, 0x70, 0x00,
  0x00, 0x00, 0x0A, 0xB0, 0x00,
  0x00, 0x00, 0x05, 0xF2, 0x00,
  0x00, 0x00, 0x01, 0xF7, 0x00,
  0x00, 0x00, 0x00, 0xAC, 0x00,
  0x00, 0x00, 0x00, 0x5F, 0x20,
  0x00, 0x00, 0x00, 0x1F, 0x70,
  0x00, 0x00, 0x00, 0x0B, 0xC0,
  0x00, 0x00, 0x00, 0x06, 0xF2,
  0x00, 0x00, 0x00, 0x01, 0xF7,
  0x00, 0x00, 0x00, 0x00, 0xBC
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_005D[ 87] = { /* code 005D, RIGHT SQUARE BRACKET */
  0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_005E[ 90] = { /* code 005E, CIRCUMFLEX ACCENT */
  0x00, 0x00, 0x00, 0x01, 0xDF, 0xD1, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1C, 0xFA, 0xFB, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0xBF, 0x70, 0x7F, 0xB1, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1B, 0xF7, 0x00, 0x07, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xAF, 0x70, 0x00, 0x00, 0x7F, 0xA0, 0x00, 0x00,
  0x00, 0x0A, 0xF7, 0x00, 0x00, 0x00, 0x07, 0xFA, 0x00, 0x00,
  0x00, 0x9F, 0x70, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x90, 0x00,
  0x08, 0xF7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xF8, 0x00,
  0x8F, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x80
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_005F[  8] = { /* code 005F, LOW LINE */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0060[ 15] = { /* code 0060, GRAVE ACCENT */
  0x8F, 0xD0, 0x00,
  0x0A, 0xF9, 0x00,
  0x00, 0xBF, 0x40,
  0x00, 0x1C, 0xD1,
  0x00, 0x01, 0xDA
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0061[136] = { /* code 0061, LATIN SMALL LETTER A */
  0x00, 0x01, 0x7C, 0xEF, 0xFD, 0xA5, 0x00, 0x00,
  0x00, 0x4E, 0xFF, 0xFF, 0xFF, 0xFF, 0xA0, 0x00,
  0x03, 0xFF, 0xB4, 0x10, 0x02, 0x7E, 0xF7, 0x00,
  0x0A, 0xF9, 0x00, 0x00, 0x00, 0x05, 0xFC, 0x00,
  0x0E, 0xF2, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x04, 0x40, 0x00, 0x00, 0x00, 0x01, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x5C, 0xFF, 0x00,
  0x00, 0x01, 0x58, 0xBD, 0xEF, 0xFF, 0xFF, 0x00,
  0x01, 0x8F, 0xFF, 0xFD, 0xCA, 0x84, 0xFF, 0x00,
  0x1D, 0xFD, 0x72, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0x9F, 0xB1, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0xEF, 0x20, 0x00, 0x00, 0x00, 0x02, 0xFF, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x08, 0xFF, 0x00,
  0xDF, 0x60, 0x00, 0x00, 0x00, 0x5F, 0xFF, 0x00,
  0x7F, 0xF7, 0x30, 0x02, 0x5B, 0xFA, 0xDF, 0x30,
  0x0A, 0xFF, 0xFF, 0xFF, 0xFF, 0x70, 0xBF, 0xFF,
  0x00, 0x5B, 0xEF, 0xFC, 0x82, 0x00, 0x2C, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0062[184] = { /* code 0062, LATIN SMALL LETTER B */
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x3A, 0xEF, 0xFC, 0x81, 0x00, 0x00,
  0xFF, 0x07, 0xFF, 0xFF, 0xFF, 0xFE, 0x50, 0x00,
  0xFF, 0x5F, 0xB4, 0x10, 0x15, 0xCF, 0xF3, 0x00,
  0xFF, 0xE8, 0x00, 0x00, 0x00, 0x0A, 0xFD, 0x00,
  0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0xDF, 0x50,
  0xFF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xA0,
  0xFF, 0x10, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xD0,
  0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x10, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xD0,
  0xFF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xA0,
  0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0xDF, 0x50,
  0xFF, 0xE9, 0x00, 0x00, 0x00, 0x09, 0xFD, 0x00,
  0xFF, 0x6F, 0xB5, 0x10, 0x15, 0xBF, 0xF3, 0x00,
  0xFF, 0x08, 0xFF, 0xFF, 0xFF, 0xFE, 0x40, 0x00,
  0xFF, 0x00, 0x3A, 0xEF, 0xFC, 0x71, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0063[119] = { /* code 0063, LATIN SMALL LETTER C */
  0x00, 0x01, 0x7C, 0xEF, 0xEB, 0x50, 0x00,
  0x00, 0x3E, 0xFF, 0xFF, 0xFF, 0xFB, 0x10,
  0x03, 0xEF, 0xC5, 0x10, 0x27, 0xEF, 0xC0,
  0x0D, 0xFA, 0x00, 0x00, 0x00, 0x2E, 0xF6,
  0x5F, 0xD0, 0x00, 0x00, 0x00, 0x07, 0xFB,
  0x9F, 0x70, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0xDF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xAF, 0x70, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0x6F, 0xE1, 0x00, 0x00, 0x00, 0x07, 0xFB,
  0x0D, 0xFA, 0x00, 0x00, 0x00, 0x2E, 0xF5,
  0x04, 0xFF, 0xC4, 0x10, 0x27, 0xEF, 0xB0,
  0x00, 0x5E, 0xFF, 0xFF, 0xFF, 0xFB, 0x10,
  0x00, 0x02, 0x8C, 0xFF, 0xEA, 0x50, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0064[184] = { /* code 0064, LATIN SMALL LETTER D */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x01, 0x7C, 0xFF, 0xEA, 0x30, 0x0F, 0xF0,
  0x00, 0x4E, 0xFF, 0xFF, 0xFF, 0xF8, 0x0F, 0xF0,
  0x03, 0xFF, 0xC5, 0x10, 0x14, 0xBF, 0x6F, 0xF0,
  0x0D, 0xF9, 0x00, 0x00, 0x00, 0x07, 0xEF, 0xF0,
  0x5F, 0xD0, 0x00, 0x00, 0x00, 0x00, 0xBF, 0xF0,
  0xAF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xF0,
  0xDF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0xF0,
  0xDF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xAF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xF0,
  0x5F, 0xD0, 0x00, 0x00, 0x00, 0x00, 0xBF, 0xF0,
  0x0D, 0xFA, 0x00, 0x00, 0x00, 0x07, 0xEF, 0xF0,
  0x04, 0xFF, 0xC5, 0x10, 0x14, 0xBF, 0x6F, 0xF0,
  0x00, 0x5E, 0xFF, 0xFF, 0xFF, 0xF7, 0x0F, 0xF0,
  0x00, 0x01, 0x8C, 0xFF, 0xDA, 0x30, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0065[119] = { /* code 0065, LATIN SMALL LETTER E */
  0x00, 0x02, 0x8D, 0xFF, 0xDA, 0x30, 0x00,
  0x00, 0x6F, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x04, 0xFF, 0xA3, 0x00, 0x38, 0xFF, 0x70,
  0x0E, 0xF7, 0x00, 0x00, 0x00, 0x5F, 0xF1,
  0x6F, 0xB0, 0x00, 0x00, 0x00, 0x09, 0xF7,
  0xAF, 0x40, 0x00, 0x00, 0x00, 0x03, 0xFB,
  0xDF, 0x10, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xAF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x6F, 0xB0, 0x00, 0x00, 0x00, 0x05, 0xFA,
  0x1E, 0xF8, 0x00, 0x00, 0x00, 0x1D, 0xF5,
  0x05, 0xFF, 0xB3, 0x00, 0x26, 0xDF, 0xB0,
  0x00, 0x6F, 0xFF, 0xFF, 0xFF, 0xFB, 0x10,
  0x00, 0x02, 0x9D, 0xFF, 0xDA, 0x50, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0066[ 92] = { /* code 0066, LATIN SMALL LETTER F */
  0x00, 0x00, 0x7D, 0xFF,
  0x00, 0x08, 0xFF, 0xFF,
  0x00, 0x0E, 0xF6, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x6F, 0xFF, 0xFF, 0xFF,
  0x6F, 0xFF, 0xFF, 0xFF,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0067[192] = { /* code 0067, LATIN SMALL LETTER G */
  0x00, 0x01, 0x7C, 0xFF, 0xEA, 0x30, 0x0F, 0xF0,
  0x00, 0x4E, 0xFF, 0xFF, 0xFF, 0xF7, 0x0F, 0xF0,
  0x03, 0xFF, 0xC5, 0x10, 0x14, 0xBF, 0x5F, 0xF0,
  0x0D, 0xF9, 0x00, 0x00, 0x00, 0x08, 0xEF, 0xF0,
  0x5F, 0xD0, 0x00, 0x00, 0x00, 0x00, 0xBF, 0xF0,
  0xAF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xF0,
  0xDF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0xF0,
  0xDF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF0,
  0xAF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xF0,
  0x5F, 0xE1, 0x00, 0x00, 0x00, 0x00, 0xBF, 0xF0,
  0x0D, 0xFA, 0x00, 0x00, 0x00, 0x08, 0xEF, 0xF0,
  0x03, 0xFF, 0xC5, 0x10, 0x14, 0xBF, 0x5F, 0xF0,
  0x00, 0x4E, 0xFF, 0xFF, 0xFF, 0xF7, 0x0F, 0xF0,
  0x00, 0x01, 0x8C, 0xFF, 0xDA, 0x30, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6F, 0xA0,
  0x0E, 0xF1, 0x00, 0x00, 0x00, 0x00, 0xCF, 0x60,
  0x0A, 0xF8, 0x00, 0x00, 0x00, 0x08, 0xFE, 0x10,
  0x03, 0xFF, 0xA3, 0x10, 0x14, 0xBF, 0xF5, 0x00,
  0x00, 0x5E, 0xFF, 0xFF, 0xFF, 0xFF, 0x60, 0x00,
  0x00, 0x01, 0x8C, 0xFF, 0xEC, 0x82, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0068[161] = { /* code 0068, LATIN SMALL LETTER H */
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x4B, 0xEF, 0xEA, 0x40, 0x00,
  0xFF, 0x09, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0xFF, 0x7F, 0x93, 0x00, 0x38, 0xFF, 0x60,
  0xFF, 0xF5, 0x00, 0x00, 0x00, 0x9F, 0xB0,
  0xFF, 0x90, 0x00, 0x00, 0x00, 0x4F, 0xE0,
  0xFF, 0x40, 0x00, 0x00, 0x00, 0x1F, 0xF0,
  0xFF, 0x10, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0069[ 23] = { /* code 0069, LATIN SMALL LETTER I */
  0xFF,
  0xFF,
  0x00,
  0x00,
  0x00,
  0x00,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_006A[ 90] = { /* code 006A, LATIN SMALL LETTER J */
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x00, 0x00,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x01, 0x7F, 0xD0,
  0xFF, 0xFF, 0x80,
  0xEF, 0xD8, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_006B[161] = { /* code 006B, LATIN SMALL LETTER K */
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x08, 0xFB, 0x10,
  0xFF, 0x00, 0x00, 0x00, 0x8F, 0xB1, 0x00,
  0xFF, 0x00, 0x00, 0x07, 0xFC, 0x10, 0x00,
  0xFF, 0x00, 0x00, 0x7F, 0xD1, 0x00, 0x00,
  0xFF, 0x00, 0x07, 0xFD, 0x10, 0x00, 0x00,
  0xFF, 0x00, 0x5F, 0xD1, 0x00, 0x00, 0x00,
  0xFF, 0x05, 0xFF, 0x70, 0x00, 0x00, 0x00,
  0xFF, 0x5F, 0xEE, 0xE2, 0x00, 0x00, 0x00,
  0xFF, 0xFE, 0x26, 0xFB, 0x00, 0x00, 0x00,
  0xFF, 0xE2, 0x00, 0xCF, 0x50, 0x00, 0x00,
  0xFF, 0x20, 0x00, 0x3F, 0xD1, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x08, 0xF9, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0xDF, 0x30, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x4F, 0xC0, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x0A, 0xF7, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x02, 0xEE, 0x20,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x6F, 0xA0
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_006C[ 23] = { /* code 006C, LATIN SMALL LETTER L */
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_006D[187] = { /* code 006D, LATIN SMALL LETTER M */
  0xFD, 0x00, 0x6C, 0xFF, 0xC6, 0x00, 0x01, 0x8D, 0xFF, 0xC7, 0x00,
  0xFD, 0x0B, 0xFF, 0xFF, 0xFF, 0x80, 0x2D, 0xFF, 0xFF, 0xFF, 0xB0,
  0xFD, 0x9E, 0x72, 0x01, 0x7F, 0xF4, 0xCE, 0x61, 0x00, 0x5E, 0xF6,
  0xFF, 0xF3, 0x00, 0x00, 0x07, 0xFE, 0xE2, 0x00, 0x00, 0x06, 0xFB,
  0xFF, 0x80, 0x00, 0x00, 0x02, 0xFF, 0x70, 0x00, 0x00, 0x01, 0xFE,
  0xFF, 0x30, 0x00, 0x00, 0x00, 0xFF, 0x20, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_006E[119] = { /* code 006E, LATIN SMALL LETTER N */
  0xFD, 0x00, 0x5B, 0xEF, 0xEB, 0x40, 0x00,
  0xFD, 0x0A, 0xFF, 0xFF, 0xFF, 0xF9, 0x00,
  0xFD, 0x8F, 0x93, 0x00, 0x38, 0xFF, 0x60,
  0xFF, 0xF5, 0x00, 0x00, 0x00, 0x9F, 0xB0,
  0xFF, 0x90, 0x00, 0x00, 0x00, 0x3F, 0xE0,
  0xFF, 0x30, 0x00, 0x00, 0x00, 0x1F, 0xF0,
  0xFF, 0x10, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_006F[136] = { /* code 006F, LATIN SMALL LETTER O */
  0x00, 0x01, 0x8C, 0xEF, 0xEC, 0x71, 0x00, 0x00,
  0x00, 0x5E, 0xFF, 0xFF, 0xFF, 0xFE, 0x40, 0x00,
  0x04, 0xFF, 0xC5, 0x10, 0x15, 0xBF, 0xF4, 0x00,
  0x0D, 0xFA, 0x00, 0x00, 0x00, 0x09, 0xFD, 0x00,
  0x6F, 0xD0, 0x00, 0x00, 0x00, 0x00, 0xDF, 0x50,
  0xAF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xA0,
  0xDF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xD0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xDF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xD0,
  0xAF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xA0,
  0x6F, 0xD0, 0x00, 0x00, 0x00, 0x00, 0xDF, 0x60,
  0x0D, 0xFA, 0x00, 0x00, 0x00, 0x09, 0xFD, 0x00,
  0x04, 0xFF, 0xC5, 0x10, 0x15, 0xBF, 0xF4, 0x00,
  0x00, 0x5E, 0xFF, 0xFF, 0xFF, 0xFE, 0x50, 0x00,
  0x00, 0x01, 0x8C, 0xEF, 0xEC, 0x71, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0070[192] = { /* code 0070, LATIN SMALL LETTER P */
  0xFF, 0x00, 0x3A, 0xEF, 0xFC, 0x81, 0x00, 0x00,
  0xFF, 0x07, 0xFF, 0xFF, 0xFF, 0xFE, 0x50, 0x00,
  0xFF, 0x5F, 0xB4, 0x10, 0x15, 0xCF, 0xF4, 0x00,
  0xFF, 0xE8, 0x00, 0x00, 0x00, 0x0A, 0xFD, 0x00,
  0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0xDF, 0x50,
  0xFF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xA0,
  0xFF, 0x10, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xD0,
  0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x10, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xD0,
  0xFF, 0x60, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xA0,
  0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0xDF, 0x50,
  0xFF, 0xE9, 0x00, 0x00, 0x00, 0x09, 0xFD, 0x00,
  0xFF, 0x5F, 0xB4, 0x10, 0x15, 0xCF, 0xF3, 0x00,
  0xFF, 0x07, 0xFF, 0xFF, 0xFF, 0xFE, 0x40, 0x00,
  0xFF, 0x00, 0x3A, 0xEF, 0xFC, 0x81, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0071[192] = { /* code 0071, LATIN SMALL LETTER Q */
  0x00, 0x01, 0x8C, 0xFF, 0xEA, 0x30, 0x0F, 0xF0,
  0x00, 0x4E, 0xFF, 0xFF, 0xFF, 0xF7, 0x0F, 0xF0,
  0x03, 0xFF, 0xC5, 0x10, 0x14, 0xBF, 0x6F, 0xF0,
  0x0D, 0xF9, 0x00, 0x00, 0x00, 0x08, 0xEF, 0xF0,
  0x5F, 0xD0, 0x00, 0x00, 0x00, 0x00, 0xBF, 0xF0,
  0xAF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xF0,
  0xDF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0xF0,
  0xDF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xAF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xF0,
  0x5F, 0xD0, 0x00, 0x00, 0x00, 0x00, 0xBF, 0xF0,
  0x0D, 0xFA, 0x00, 0x00, 0x00, 0x07, 0xEF, 0xF0,
  0x04, 0xFF, 0xC5, 0x10, 0x14, 0xBF, 0x5F, 0xF0,
  0x00, 0x5E, 0xFF, 0xFF, 0xFF, 0xF6, 0x0F, 0xF0,
  0x00, 0x01, 0x8C, 0xFF, 0xEA, 0x30, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0072[ 68] = { /* code 0072, LATIN SMALL LETTER R */
  0xFD, 0x01, 0x8D, 0xF0,
  0xFD, 0x1D, 0xFF, 0xF0,
  0xFD, 0xBE, 0x72, 0x00,
  0xFF, 0xF3, 0x00, 0x00,
  0xFF, 0x90, 0x00, 0x00,
  0xFF, 0x40, 0x00, 0x00,
  0xFF, 0x10, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0073[102] = { /* code 0073, LATIN SMALL LETTER S */
  0x00, 0x4A, 0xEF, 0xFC, 0x82, 0x00,
  0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0x60,
  0x6F, 0xE7, 0x20, 0x03, 0xAF, 0xF3,
  0xCF, 0x50, 0x00, 0x00, 0x08, 0xFA,
  0xFF, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0xEF, 0x30, 0x00, 0x00, 0x00, 0x00,
  0xAF, 0xE5, 0x00, 0x00, 0x00, 0x00,
  0x1D, 0xFF, 0xD8, 0x41, 0x00, 0x00,
  0x00, 0x7D, 0xFF, 0xFF, 0xB5, 0x00,
  0x00, 0x00, 0x37, 0xBF, 0xFF, 0xB1,
  0x00, 0x00, 0x00, 0x01, 0x7E, 0xF9,
  0x00, 0x00, 0x00, 0x00, 0x04, 0xFE,
  0xFF, 0x10, 0x00, 0x00, 0x00, 0xFF,
  0xBF, 0x80, 0x00, 0x00, 0x05, 0xFD,
  0x4F, 0xF9, 0x30, 0x03, 0x7F, 0xF7,
  0x06, 0xFF, 0xFF, 0xFF, 0xFF, 0x90,
  0x00, 0x39, 0xDF, 0xFE, 0xA4, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0074[ 84] = { /* code 0074, LATIN SMALL LETTER T */
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x7F, 0xFF, 0xFF, 0xFF,
  0x7F, 0xFF, 0xFF, 0xFF,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF3, 0x00,
  0x00, 0x0B, 0xFF, 0xFF,
  0x00, 0x03, 0xCF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0075[119] = { /* code 0075, LATIN SMALL LETTER U */
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xF0,
  0xDF, 0x30, 0x00, 0x00, 0x00, 0x9F, 0xF0,
  0xAF, 0x90, 0x00, 0x00, 0x05, 0xFF, 0xF0,
  0x4F, 0xF9, 0x30, 0x03, 0x9F, 0x8F, 0xF0,
  0x08, 0xFF, 0xFF, 0xFF, 0xFA, 0x0F, 0xF0,
  0x00, 0x5B, 0xEF, 0xEB, 0x50, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0076[119] = { /* code 0076, LATIN SMALL LETTER V */
  0xCF, 0x30, 0x00, 0x00, 0x00, 0x02, 0xFC,
  0x7F, 0x80, 0x00, 0x00, 0x00, 0x07, 0xF7,
  0x2F, 0xD0, 0x00, 0x00, 0x00, 0x0B, 0xF2,
  0x0B, 0xF3, 0x00, 0x00, 0x00, 0x2F, 0xB0,
  0x06, 0xF8, 0x00, 0x00, 0x00, 0x7F, 0x60,
  0x01, 0xFD, 0x00, 0x00, 0x00, 0xCF, 0x10,
  0x00, 0xBF, 0x40, 0x00, 0x02, 0xFB, 0x00,
  0x00, 0x5F, 0x90, 0x00, 0x07, 0xF5, 0x00,
  0x00, 0x1E, 0xE0, 0x00, 0x0D, 0xE1, 0x00,
  0x00, 0x0A, 0xF4, 0x00, 0x3F, 0xA0, 0x00,
  0x00, 0x04, 0xFA, 0x00, 0x8F, 0x40, 0x00,
  0x00, 0x00, 0xEE, 0x00, 0xDE, 0x00, 0x00,
  0x00, 0x00, 0x9F, 0x53, 0xF9, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xA8, 0xF3, 0x00, 0x00,
  0x00, 0x00, 0x0D, 0xFD, 0xD0, 0x00, 0x00,
  0x00, 0x00, 0x08, 0xFF, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x03, 0xFF, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0077[187] = { /* code 0077, LATIN SMALL LETTER W */
  0xDF, 0x10, 0x00, 0x00, 0x02, 0xFF, 0x20, 0x00, 0x00, 0x01, 0xFD,
  0x8F, 0x50, 0x00, 0x00, 0x06, 0xFF, 0x60, 0x00, 0x00, 0x04, 0xF8,
  0x4F, 0x90, 0x00, 0x00, 0x0B, 0xFF, 0xB0, 0x00, 0x00, 0x09, 0xF4,
  0x0E, 0xD0, 0x00, 0x00, 0x0E, 0xBD, 0xF0, 0x00, 0x00, 0x0D, 0xE0,
  0x0A, 0xF3, 0x00, 0x00, 0x4F, 0x79, 0xF4, 0x00, 0x00, 0x3F, 0xA0,
  0x06, 0xF7, 0x00, 0x00, 0x8F, 0x34, 0xF8, 0x00, 0x00, 0x7F, 0x60,
  0x01, 0xFB, 0x00, 0x00, 0xCE, 0x00, 0xFD, 0x00, 0x00, 0xBF, 0x10,
  0x00, 0xCF, 0x10, 0x02, 0xF9, 0x00, 0xBF, 0x20, 0x01, 0xFC, 0x00,
  0x00, 0x7F, 0x50, 0x06, 0xF5, 0x00, 0x6F, 0x60, 0x05, 0xF7, 0x00,
  0x00, 0x3F, 0xA0, 0x0A, 0xF1, 0x00, 0x2F, 0xB0, 0x09, 0xF3, 0x00,
  0x00, 0x0E, 0xE0, 0x0E, 0xC0, 0x00, 0x0D, 0xE0, 0x0D, 0xE0, 0x00,
  0x00, 0x09, 0xF3, 0x3F, 0x80, 0x00, 0x09, 0xF4, 0x3F, 0x90, 0x00,
  0x00, 0x05, 0xF8, 0x7F, 0x40, 0x00, 0x04, 0xF8, 0x7F, 0x50, 0x00,
  0x00, 0x01, 0xFC, 0xCE, 0x00, 0x00, 0x00, 0xFC, 0xBF, 0x10, 0x00,
  0x00, 0x00, 0xBF, 0xFB, 0x00, 0x00, 0x00, 0xBF, 0xFB, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF6, 0x00, 0x00, 0x00, 0x6F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x2F, 0xF2, 0x00, 0x00, 0x00, 0x2F, 0xF2, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0078[119] = { /* code 0078, LATIN SMALL LETTER X */
  0xAF, 0xA0, 0x00, 0x00, 0x00, 0x8F, 0xA0,
  0x1E, 0xF4, 0x00, 0x00, 0x03, 0xFE, 0x20,
  0x06, 0xFD, 0x00, 0x00, 0x0C, 0xF6, 0x00,
  0x00, 0xBF, 0x80, 0x00, 0x6F, 0xB0, 0x00,
  0x00, 0x2E, 0xF3, 0x01, 0xEF, 0x20, 0x00,
  0x00, 0x06, 0xFC, 0x0A, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0x9F, 0xC0, 0x00, 0x00,
  0x00, 0x00, 0x2E, 0xFF, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0xFE, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x5F, 0xFF, 0x90, 0x00, 0x00,
  0x00, 0x01, 0xDF, 0x3D, 0xF5, 0x00, 0x00,
  0x00, 0x09, 0xF8, 0x03, 0xFE, 0x20, 0x00,
  0x00, 0x3F, 0xD1, 0x00, 0x8F, 0xB0, 0x00,
  0x00, 0xCF, 0x50, 0x00, 0x0D, 0xF7, 0x00,
  0x07, 0xFB, 0x00, 0x00, 0x03, 0xFF, 0x30,
  0x2E, 0xE2, 0x00, 0x00, 0x00, 0x7F, 0xD1,
  0xAF, 0x70, 0x00, 0x00, 0x00, 0x0C, 0xFA
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_0079[192] = { /* code 0079, LATIN SMALL LETTER Y */
  0xCF, 0xB0, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xC0,
  0x6F, 0xF2, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x70,
  0x1E, 0xF7, 0x00, 0x00, 0x00, 0x00, 0xDF, 0x20,
  0x09, 0xFC, 0x00, 0x00, 0x00, 0x03, 0xFB, 0x00,
  0x03, 0xFF, 0x30, 0x00, 0x00, 0x08, 0xF6, 0x00,
  0x00, 0xCF, 0x80, 0x00, 0x00, 0x0E, 0xF1, 0x00,
  0x00, 0x6F, 0xE0, 0x00, 0x00, 0x4F, 0xA0, 0x00,
  0x00, 0x0E, 0xF4, 0x00, 0x00, 0xAF, 0x40, 0x00,
  0x00, 0x09, 0xFA, 0x00, 0x01, 0xEE, 0x00, 0x00,
  0x00, 0x03, 0xFF, 0x10, 0x05, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0x60, 0x0B, 0xF3, 0x00, 0x00,
  0x00, 0x00, 0x5F, 0xB0, 0x1F, 0xD0, 0x00, 0x00,
  0x00, 0x00, 0x0E, 0xF2, 0x7F, 0x70, 0x00, 0x00,
  0x00, 0x00, 0x08, 0xF7, 0xCF, 0x20, 0x00, 0x00,
  0x00, 0x00, 0x02, 0xFE, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xBF, 0xF6, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x5F, 0xF1, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3F, 0xA0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x9F, 0x50, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xEE, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x06, 0xF9, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x4E, 0xF3, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xEF, 0xD7, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_007A[119] = { /* code 007A, LATIN SMALL LETTER Z */
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7,
  0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xC1,
  0x00, 0x00, 0x00, 0x00, 0x03, 0xEE, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x1D, 0xF4, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xBF, 0x60, 0x00,
  0x00, 0x00, 0x00, 0x09, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0xB0, 0x00, 0x00,
  0x00, 0x00, 0x04, 0xFD, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x2E, 0xE2, 0x00, 0x00, 0x00,
  0x00, 0x01, 0xDF, 0x40, 0x00, 0x00, 0x00,
  0x00, 0x0B, 0xF7, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x9F, 0x90, 0x00, 0x00, 0x00, 0x00,
  0x06, 0xFB, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x4F, 0xD1, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_007B[180] = { /* code 007B, LEFT CURLY BRACKET */
  0x00, 0x00, 0x00, 0x3A, 0xDF, 0xF0,
  0x00, 0x00, 0x03, 0xFE, 0x41, 0x00,
  0x00, 0x00, 0x0A, 0xF5, 0x00, 0x00,
  0x00, 0x00, 0x0D, 0xF2, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00,
  0x00, 0x00, 0xAF, 0x60, 0x00, 0x00,
  0x00, 0x39, 0xF9, 0x00, 0x00, 0x00,
  0xFF, 0xFE, 0x50, 0x00, 0x00, 0x00,
  0x00, 0x3A, 0xF8, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0x60, 0x00, 0x00,
  0x00, 0x00, 0x4F, 0xB0, 0x00, 0x00,
  0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0E, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0C, 0xF2, 0x00, 0x00,
  0x00, 0x00, 0x09, 0xF6, 0x00, 0x00,
  0x00, 0x00, 0x02, 0xEE, 0x51, 0x00,
  0x00, 0x00, 0x00, 0x2A, 0xDF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_007C[ 32] = { /* code 007C, VERTICAL LINE */
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_007D[180] = { /* code 007D, RIGHT CURLY BRACKET */
  0xFF, 0xDA, 0x30, 0x00, 0x00, 0x00,
  0x01, 0x4E, 0xF3, 0x00, 0x00, 0x00,
  0x00, 0x05, 0xFA, 0x00, 0x00, 0x00,
  0x00, 0x02, 0xFD, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xEF, 0x10, 0x00, 0x00,
  0x00, 0x00, 0xCF, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x09, 0xF9, 0x30, 0x00,
  0x00, 0x00, 0x00, 0x4E, 0xFF, 0xF0,
  0x00, 0x00, 0x08, 0xFA, 0x30, 0x00,
  0x00, 0x00, 0x5F, 0xB0, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0x40, 0x00, 0x00,
  0x00, 0x00, 0xEF, 0x10, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFE, 0x00, 0x00, 0x00,
  0x00, 0x02, 0xFC, 0x00, 0x00, 0x00,
  0x00, 0x06, 0xF9, 0x00, 0x00, 0x00,
  0x01, 0x5E, 0xE2, 0x00, 0x00, 0x00,
  0xFF, 0xDA, 0x20, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font39SL_AA4_007E[ 55] = { /* code 007E, TILDE */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x00, 0x39, 0xDF, 0xFC, 0x95, 0x10, 0x00, 0x00, 0x00, 0x06, 0xE0,
  0x3C, 0xE8, 0x30, 0x03, 0x6A, 0xEA, 0x63, 0x00, 0x37, 0xDC, 0x30,
  0xF8, 0x10, 0x00, 0x00, 0x00, 0x15, 0x9C, 0xFF, 0xD9, 0x30, 0x00,
  0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_Font39SL_AA4_CharInfo[95] = {
   {   1,   1,   0,  31,   9, acGUI_Font39SL_AA4_0020 } /* code 0020, SPACE */
  ,{   2,  23,   4,   8,  10, acGUI_Font39SL_AA4_0021 } /* code 0021, EXCLAMATION MARK */
  ,{   5,   9,   2,   9,   9, acGUI_Font39SL_AA4_0022 } /* code 0022, QUOTATION MARK */
  ,{  21,  23,   2,   8,  25, acGUI_Font39SL_AA4_0023 } /* code 0023, NUMBER SIGN */
  ,{  15,  27,   1,   7,  17, acGUI_Font39SL_AA4_0024 } /* code 0024, DOLLAR SIGN */
  ,{  24,  24,   1,   8,  26, acGUI_Font39SL_AA4_0025 } /* code 0025, PERCENT SIGN */
  ,{  19,  23,   2,   8,  21, acGUI_Font39SL_AA4_0026 } /* code 0026, AMPERSAND */
  ,{   1,   9,   2,   9,   4, acGUI_Font39SL_AA4_0027 } /* code 0027, APOSTROPHE */
  ,{   7,  29,   3,   8,  10, acGUI_Font39SL_AA4_0028 } /* code 0028, LEFT PARENTHESIS */
  ,{   7,  29,   0,   8,  10, acGUI_Font39SL_AA4_0029 } /* code 0029, RIGHT PARENTHESIS */
  ,{  11,  11,   2,   8,  16, acGUI_Font39SL_AA4_002A } /* code 002A, ASTERISK */
  ,{  19,  19,   4,  12,  27, acGUI_Font39SL_AA4_002B } /* code 002B, PLUS SIGN */
  ,{   2,   7,   3,  28,   9, acGUI_Font39SL_AA4_002C } /* code 002C, COMMA */
  ,{   8,   2,   1,  22,  10, acGUI_Font39SL_AA4_002D } /* code 002D, HYPHEN-MINUS */
  ,{   2,   3,   3,  28,   9, acGUI_Font39SL_AA4_002E } /* code 002E, FULL STOP */
  ,{  10,  26,   0,   8,   9, acGUI_Font39SL_AA4_002F } /* code 002F, SOLIDUS */
  ,{  15,  22,   1,   9,  17, acGUI_Font39SL_AA4_0030 } /* code 0030, DIGIT ZERO */
  ,{   8,  22,   3,   9,  17, acGUI_Font39SL_AA4_0031 } /* code 0031, DIGIT ONE */
  ,{  15,  22,   1,   9,  17, acGUI_Font39SL_AA4_0032 } /* code 0032, DIGIT TWO */
  ,{  14,  22,   1,   9,  17, acGUI_Font39SL_AA4_0033 } /* code 0033, DIGIT THREE */
  ,{  15,  22,   1,   9,  17, acGUI_Font39SL_AA4_0034 } /* code 0034, DIGIT FOUR */
  ,{  14,  22,   1,   9,  17, acGUI_Font39SL_AA4_0035 } /* code 0035, DIGIT FIVE */
  ,{  15,  22,   1,   9,  17, acGUI_Font39SL_AA4_0036 } /* code 0036, DIGIT SIX */
  ,{  14,  22,   2,   9,  17, acGUI_Font39SL_AA4_0037 } /* code 0037, DIGIT SEVEN */
  ,{  14,  22,   1,   9,  17, acGUI_Font39SL_AA4_0038 } /* code 0038, DIGIT EIGHT */
  ,{  15,  22,   1,   9,  17, acGUI_Font39SL_AA4_0039 } /* code 0039, DIGIT NINE */
  ,{   2,  16,   4,  15,   9, acGUI_Font39SL_AA4_003A } /* code 003A, COLON */
  ,{   2,  20,   4,  15,   9, acGUI_Font39SL_AA4_003B } /* code 003B, SEMICOLON */
  ,{  18,  16,   4,  13,  27, acGUI_Font39SL_AA4_003C } /* code 003C, LESS-THAN SIGN */
  ,{  19,   6,   4,  19,  27, acGUI_Font39SL_AA4_003D } /* code 003D, EQUALS SIGN */
  ,{  18,  16,   4,  13,  27, acGUI_Font39SL_AA4_003E } /* code 003E, GREATER-THAN SIGN */
  ,{  14,  23,   1,   8,  16, acGUI_Font39SL_AA4_003F } /* code 003F, QUESTION MARK */
  ,{  28,  27,   2,   8,  32, acGUI_Font39SL_AA4_0040 } /* code 0040, COMMERCIAL AT */
  ,{  20,  23,   0,   8,  20, acGUI_Font39SL_AA4_0041 } /* code 0041, LATIN CAPITAL LETTER A */
  ,{  17,  23,   3,   8,  20, acGUI_Font39SL_AA4_0042 } /* code 0042, LATIN CAPITAL LETTER B */
  ,{  19,  23,   2,   8,  22, acGUI_Font39SL_AA4_0043 } /* code 0043, LATIN CAPITAL LETTER C */
  ,{  18,  23,   3,   8,  22, acGUI_Font39SL_AA4_0044 } /* code 0044, LATIN CAPITAL LETTER D */
  ,{  15,  23,   3,   8,  19, acGUI_Font39SL_AA4_0045 } /* code 0045, LATIN CAPITAL LETTER E */
  ,{  15,  23,   3,   8,  18, acGUI_Font39SL_AA4_0046 } /* code 0046, LATIN CAPITAL LETTER F */
  ,{  20,  23,   2,   8,  24, acGUI_Font39SL_AA4_0047 } /* code 0047, LATIN CAPITAL LETTER G */
  ,{  17,  23,   3,   8,  23, acGUI_Font39SL_AA4_0048 } /* code 0048, LATIN CAPITAL LETTER H */
  ,{   2,  23,   3,   8,   8, acGUI_Font39SL_AA4_0049 } /* code 0049, LATIN CAPITAL LETTER I */
  ,{  12,  23,   1,   8,  15, acGUI_Font39SL_AA4_004A } /* code 004A, LATIN CAPITAL LETTER J */
  ,{  18,  23,   3,   8,  20, acGUI_Font39SL_AA4_004B } /* code 004B, LATIN CAPITAL LETTER K */
  ,{  14,  23,   3,   8,  17, acGUI_Font39SL_AA4_004C } /* code 004C, LATIN CAPITAL LETTER L */
  ,{  21,  23,   3,   8,  26, acGUI_Font39SL_AA4_004D } /* code 004D, LATIN CAPITAL LETTER M */
  ,{  17,  23,   3,   8,  23, acGUI_Font39SL_AA4_004E } /* code 004E, LATIN CAPITAL LETTER N */
  ,{  21,  23,   2,   8,  24, acGUI_Font39SL_AA4_004F } /* code 004F, LATIN CAPITAL LETTER O */
  ,{  16,  23,   3,   8,  19, acGUI_Font39SL_AA4_0050 } /* code 0050, LATIN CAPITAL LETTER P */
  ,{  21,  24,   2,   8,  24, acGUI_Font39SL_AA4_0051 } /* code 0051, LATIN CAPITAL LETTER Q */
  ,{  16,  23,   3,   8,  21, acGUI_Font39SL_AA4_0052 } /* code 0052, LATIN CAPITAL LETTER R */
  ,{  17,  23,   1,   8,  19, acGUI_Font39SL_AA4_0053 } /* code 0053, LATIN CAPITAL LETTER S */
  ,{  16,  23,   1,   8,  17, acGUI_Font39SL_AA4_0054 } /* code 0054, LATIN CAPITAL LETTER T */
  ,{  17,  23,   3,   8,  22, acGUI_Font39SL_AA4_0055 } /* code 0055, LATIN CAPITAL LETTER U */
  ,{  18,  23,   0,   8,  18, acGUI_Font39SL_AA4_0056 } /* code 0056, LATIN CAPITAL LETTER V */
  ,{  27,  23,   0,   8,  27, acGUI_Font39SL_AA4_0057 } /* code 0057, LATIN CAPITAL LETTER W */
  ,{  18,  23,   0,   8,  19, acGUI_Font39SL_AA4_0058 } /* code 0058, LATIN CAPITAL LETTER X */
  ,{  18,  23,   0,   8,  18, acGUI_Font39SL_AA4_0059 } /* code 0059, LATIN CAPITAL LETTER Y */
  ,{  17,  23,   1,   8,  18, acGUI_Font39SL_AA4_005A } /* code 005A, LATIN CAPITAL LETTER Z */
  ,{   6,  29,   4,   8,  11, acGUI_Font39SL_AA4_005B } /* code 005B, LEFT SQUARE BRACKET */
  ,{  10,  26,   0,   8,   9, acGUI_Font39SL_AA4_005C } /* code 005C, REVERSE SOLIDUS */
  ,{   6,  29,   1,   8,  11, acGUI_Font39SL_AA4_005D } /* code 005D, RIGHT SQUARE BRACKET */
  ,{  19,   9,   7,   8,  32, acGUI_Font39SL_AA4_005E } /* code 005E, CIRCUMFLEX ACCENT */
  ,{  16,   1,   0,  38,  16, acGUI_Font39SL_AA4_005F } /* code 005F, LOW LINE */
  ,{   6,   5,   4,   7,  16, acGUI_Font39SL_AA4_0060 } /* code 0060, GRAVE ACCENT */
  ,{  16,  17,   1,  14,  17, acGUI_Font39SL_AA4_0061 } /* code 0061, LATIN SMALL LETTER A */
  ,{  15,  23,   2,   8,  18, acGUI_Font39SL_AA4_0062 } /* code 0062, LATIN SMALL LETTER B */
  ,{  14,  17,   1,  14,  17, acGUI_Font39SL_AA4_0063 } /* code 0063, LATIN SMALL LETTER C */
  ,{  15,  23,   1,   8,  19, acGUI_Font39SL_AA4_0064 } /* code 0064, LATIN SMALL LETTER D */
  ,{  14,  17,   1,  14,  17, acGUI_Font39SL_AA4_0065 } /* code 0065, LATIN SMALL LETTER E */
  ,{   8,  23,   0,   8,   9, acGUI_Font39SL_AA4_0066 } /* code 0066, LATIN SMALL LETTER F */
  ,{  15,  24,   1,  14,  19, acGUI_Font39SL_AA4_0067 } /* code 0067, LATIN SMALL LETTER G */
  ,{  13,  23,   2,   8,  17, acGUI_Font39SL_AA4_0068 } /* code 0068, LATIN SMALL LETTER H */
  ,{   2,  23,   2,   8,   7, acGUI_Font39SL_AA4_0069 } /* code 0069, LATIN SMALL LETTER I */
  ,{   5,  30,   0,   8,   7, acGUI_Font39SL_AA4_006A } /* code 006A, LATIN SMALL LETTER J */
  ,{  13,  23,   2,   8,  15, acGUI_Font39SL_AA4_006B } /* code 006B, LATIN SMALL LETTER K */
  ,{   2,  23,   2,   8,   7, acGUI_Font39SL_AA4_006C } /* code 006C, LATIN SMALL LETTER L */
  ,{  22,  17,   2,  14,  27, acGUI_Font39SL_AA4_006D } /* code 006D, LATIN SMALL LETTER M */
  ,{  13,  17,   2,  14,  17, acGUI_Font39SL_AA4_006E } /* code 006E, LATIN SMALL LETTER N */
  ,{  15,  17,   1,  14,  18, acGUI_Font39SL_AA4_006F } /* code 006F, LATIN SMALL LETTER O */
  ,{  15,  24,   2,  14,  19, acGUI_Font39SL_AA4_0070 } /* code 0070, LATIN SMALL LETTER P */
  ,{  15,  24,   1,  14,  19, acGUI_Font39SL_AA4_0071 } /* code 0071, LATIN SMALL LETTER Q */
  ,{   7,  17,   2,  14,  10, acGUI_Font39SL_AA4_0072 } /* code 0072, LATIN SMALL LETTER R */
  ,{  12,  17,   2,  14,  16, acGUI_Font39SL_AA4_0073 } /* code 0073, LATIN SMALL LETTER S */
  ,{   8,  21,   0,  10,   9, acGUI_Font39SL_AA4_0074 } /* code 0074, LATIN SMALL LETTER T */
  ,{  13,  17,   2,  14,  17, acGUI_Font39SL_AA4_0075 } /* code 0075, LATIN SMALL LETTER U */
  ,{  14,  17,   0,  14,  15, acGUI_Font39SL_AA4_0076 } /* code 0076, LATIN SMALL LETTER V */
  ,{  22,  17,   0,  14,  22, acGUI_Font39SL_AA4_0077 } /* code 0077, LATIN SMALL LETTER W */
  ,{  14,  17,   0,  14,  14, acGUI_Font39SL_AA4_0078 } /* code 0078, LATIN SMALL LETTER X */
  ,{  15,  24,   0,  14,  15, acGUI_Font39SL_AA4_0079 } /* code 0079, LATIN SMALL LETTER Y */
  ,{  14,  17,   1,  14,  15, acGUI_Font39SL_AA4_007A } /* code 007A, LATIN SMALL LETTER Z */
  ,{  11,  30,   2,   8,  16, acGUI_Font39SL_AA4_007B } /* code 007B, LEFT CURLY BRACKET */
  ,{   1,  32,   7,   7,  16, acGUI_Font39SL_AA4_007C } /* code 007C, VERTICAL LINE */
  ,{  11,  30,   3,   8,  16, acGUI_Font39SL_AA4_007D } /* code 007D, RIGHT CURLY BRACKET */
  ,{  21,   5,   3,  19,  27, acGUI_Font39SL_AA4_007E } /* code 007E, TILDE */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font39SL_AA4_Prop1 = {
   0x0020 /* first character */
  ,0x007E /* last character  */
  ,&GUI_Font39SL_AA4_CharInfo[  0] /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT GUI_Font39SL_AA4 = {
   GUI_FONTTYPE_PROP_AA4_EXT /* type of font    */
  ,39 /* height of font  */
  ,39 /* space of font y */
  ,1 /* magnification x */
  ,1 /* magnification y */
  ,{&GUI_Font39SL_AA4_Prop1}
  ,31 /* Baseline */
  ,17 /* Height of lowercase characters */
  ,23 /* Height of capital characters */
};

