/*********************************************************************
*                SEGGER Microcontroller GmbH                         *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2018  SEGGER Microcontroller GmbH                *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.48 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software  has been licensed to  Cypress Semiconductor Corporation,
whose registered  office is situated  at 198 Champion Ct. San Jose, CA 
95134 USA  solely for the  purposes of creating  libraries for Cypress
PSoC3 and  PSoC5 processor-based devices,  sublicensed and distributed
under  the  terms  and  conditions  of  the  Cypress  End User License
Agreement.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information
Licensor:                 SEGGER Microcontroller Systems LLC
Licensed to:              Cypress Semiconductor Corp, 198 Champion Ct., San Jose, CA 95134, USA
Licensed SEGGER software: emWin
License number:           GUI-00319
License model:            Services and License Agreement, signed June 10th, 2009
Licensed platform:        Any Cypress platform (Initial targets are: PSoC3, PSoC5)
----------------------------------------------------------------------
Support and Update Agreement (SUA)
SUA period:               2009-06-12 - 2022-07-27
Contact to extend SUA:    sales@segger.com
---------------------------------------------------------------------
File        : Font32SL_AA4.c
Purpose     : GUI_FONT_PROP_EXT, AA4, 32 Pixel
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI.h"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

/* The following line needs to be included in any file selecting the
   font.
*/
extern GUI_CONST_STORAGE GUI_FONT GUI_Font32SL_AA4;

/* Start of unicode area <Basic Latin> */
GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0020[  1] = { /* code 0020, SPACE */
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0021[ 19] = { /* code 0021, EXCLAMATION MARK */
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xEE,
  0xDD,
  0xCD,
  0xBB,
  0xBB,
  0x9A,
  0x99,
  0x00,
  0x00,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0022[ 14] = { /* code 0022, QUOTATION MARK */
  0xF0, 0x0F,
  0xF0, 0x0F,
  0xF0, 0x0F,
  0xF0, 0x0F,
  0xF0, 0x0F,
  0xF0, 0x0F,
  0xF0, 0x0F
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0023[171] = { /* code 0023, NUMBER SIGN */
  0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x08, 0xD0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xD9, 0x00, 0x0D, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x03, 0xF3, 0x00, 0x4F, 0x20, 0x00,
  0x00, 0x00, 0x00, 0x09, 0xD0, 0x00, 0xAC, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0E, 0x70, 0x01, 0xF6, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x5F, 0x20, 0x06, 0xF1, 0x00, 0x00,
  0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0x00, 0x00, 0x02, 0xF5, 0x00, 0x3F, 0x40, 0x00, 0x00,
  0x00, 0x00, 0x07, 0xF1, 0x00, 0x8E, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0xA0, 0x00, 0xC9, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x2F, 0x50, 0x02, 0xF4, 0x00, 0x00, 0x00,
  0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x00,
  0x00, 0x00, 0xDA, 0x00, 0x0D, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x03, 0xF5, 0x00, 0x3F, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x07, 0xE0, 0x00, 0x8D, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0C, 0xA0, 0x00, 0xD9, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x2F, 0x50, 0x03, 0xF4, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x7E, 0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xCA, 0x00, 0x0C, 0x90, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0024[154] = { /* code 0024, DOLLAR SIGN */
  0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x39, 0xCF, 0xFF, 0xC6, 0x00, 0x00,
  0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0, 0x00,
  0x6F, 0xF9, 0x30, 0xF1, 0x6E, 0xF7, 0x00,
  0xDF, 0x60, 0x00, 0xF0, 0x05, 0xFC, 0x00,
  0xFF, 0x10, 0x00, 0xF0, 0x00, 0xDD, 0x00,
  0xEF, 0x10, 0x00, 0xF0, 0x00, 0x00, 0x00,
  0x9F, 0x90, 0x00, 0xF0, 0x00, 0x00, 0x00,
  0x1B, 0xFD, 0x74, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x5B, 0xFF, 0xFB, 0x72, 0x00, 0x00,
  0x00, 0x00, 0x04, 0xFB, 0xEF, 0xB2, 0x00,
  0x00, 0x00, 0x00, 0xF0, 0x06, 0xEE, 0x30,
  0x00, 0x00, 0x00, 0xF0, 0x00, 0x5F, 0xB0,
  0xDD, 0x00, 0x00, 0xF0, 0x00, 0x0F, 0xF0,
  0xDF, 0x30, 0x00, 0xF0, 0x00, 0x1F, 0xF0,
  0xAF, 0xB0, 0x00, 0xF0, 0x00, 0x7F, 0xC0,
  0x3F, 0xFC, 0x51, 0xF0, 0x39, 0xFF, 0x50,
  0x05, 0xEF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0x00, 0x17, 0xCE, 0xFF, 0xC9, 0x30, 0x00,
  0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0025[200] = { /* code 0025, PERCENT SIGN */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x30, 0x00,
  0x01, 0x8E, 0xFD, 0x81, 0x00, 0x00, 0x00, 0x6D, 0x10, 0x00,
  0x1D, 0xFF, 0xFF, 0xFC, 0x10, 0x00, 0x01, 0xE5, 0x00, 0x00,
  0x8F, 0xD3, 0x03, 0xDF, 0x80, 0x00, 0x09, 0xB0, 0x00, 0x00,
  0xEF, 0x30, 0x00, 0x3F, 0xD0, 0x00, 0x4F, 0x20, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0xD7, 0x00, 0x00, 0x00,
  0xDF, 0x30, 0x00, 0x3F, 0xD0, 0x07, 0xD0, 0x00, 0x00, 0x00,
  0x8F, 0xD3, 0x03, 0xDF, 0x80, 0x2F, 0x30, 0x00, 0x00, 0x00,
  0x1C, 0xFF, 0xFF, 0xFC, 0x10, 0xB9, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x8D, 0xFD, 0x81, 0x05, 0xE1, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1E, 0x60, 0x18, 0xDF, 0xE8, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x9B, 0x01, 0xDF, 0xFF, 0xFF, 0xD1,
  0x00, 0x00, 0x00, 0x03, 0xF2, 0x08, 0xFD, 0x30, 0x3D, 0xF8,
  0x00, 0x00, 0x00, 0x0C, 0x70, 0x0E, 0xF3, 0x00, 0x03, 0xFE,
  0x00, 0x00, 0x00, 0x7D, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x02, 0xF4, 0x00, 0x0D, 0xF3, 0x00, 0x03, 0xFD,
  0x00, 0x00, 0x0B, 0xA0, 0x00, 0x08, 0xFD, 0x30, 0x3D, 0xF8,
  0x00, 0x00, 0x5E, 0x10, 0x00, 0x01, 0xCF, 0xFF, 0xFF, 0xC1,
  0x00, 0x01, 0xD6, 0x00, 0x00, 0x00, 0x18, 0xDF, 0xD8, 0x10,
  0x00, 0x03, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0026[152] = { /* code 0026, AMPERSAND */
  0x00, 0x00, 0x4B, 0xFF, 0xC5, 0x00, 0x00, 0x00,
  0x00, 0x04, 0xFF, 0xFF, 0xFF, 0x50, 0x00, 0x00,
  0x00, 0x0C, 0xF9, 0x11, 0x9F, 0xC0, 0x00, 0x00,
  0x00, 0x0F, 0xF1, 0x00, 0x1F, 0xF0, 0x00, 0x00,
  0x00, 0x0E, 0xF1, 0x00, 0x1F, 0xE0, 0x00, 0x00,
  0x00, 0x08, 0xF7, 0x00, 0x7F, 0x80, 0x00, 0x00,
  0x00, 0x01, 0xCE, 0x27, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x2E, 0xFF, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x06, 0xDE, 0xEA, 0x00, 0x00, 0x00, 0x00,
  0x01, 0xCF, 0x81, 0x5F, 0x70, 0x00, 0x00, 0x00,
  0x1D, 0xE4, 0x00, 0x07, 0xF5, 0x00, 0xFF, 0x00,
  0x8F, 0x70, 0x00, 0x00, 0x9E, 0x31, 0xFC, 0x00,
  0xDF, 0x10, 0x00, 0x00, 0x0B, 0xE4, 0xF9, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x01, 0xDF, 0xF3, 0x00,
  0xEF, 0x30, 0x00, 0x00, 0x00, 0x2F, 0xB0, 0x00,
  0xAF, 0xB0, 0x00, 0x00, 0x00, 0xAF, 0xF5, 0x00,
  0x3F, 0xFB, 0x30, 0x02, 0x6D, 0xF4, 0xDE, 0x20,
  0x06, 0xFF, 0xFF, 0xFF, 0xFE, 0x40, 0x3F, 0xC0,
  0x00, 0x3A, 0xEF, 0xFC, 0x71, 0x00, 0x09, 0xF9
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0027[  7] = { /* code 0027, APOSTROPHE */
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0028[ 75] = { /* code 0028, LEFT PARENTHESIS */
  0x00, 0x00, 0xBA,
  0x00, 0x08, 0xE1,
  0x00, 0x3F, 0x60,
  0x00, 0xCD, 0x00,
  0x04, 0xF7, 0x00,
  0x0B, 0xF2, 0x00,
  0x1F, 0xC0, 0x00,
  0x6F, 0x80, 0x00,
  0x9F, 0x50, 0x00,
  0xCF, 0x30, 0x00,
  0xDF, 0x10, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xDF, 0x10, 0x00,
  0xCF, 0x30, 0x00,
  0x9F, 0x50, 0x00,
  0x6F, 0x80, 0x00,
  0x1F, 0xC0, 0x00,
  0x0B, 0xF2, 0x00,
  0x04, 0xF7, 0x00,
  0x00, 0xCE, 0x00,
  0x00, 0x3F, 0x70,
  0x00, 0x08, 0xE1,
  0x00, 0x00, 0xBA
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0029[ 75] = { /* code 0029, RIGHT PARENTHESIS */
  0xAB, 0x00, 0x00,
  0x1E, 0x80, 0x00,
  0x06, 0xF3, 0x00,
  0x00, 0xDC, 0x00,
  0x00, 0x7F, 0x40,
  0x00, 0x1F, 0xB0,
  0x00, 0x0B, 0xF1,
  0x00, 0x08, 0xF6,
  0x00, 0x05, 0xF9,
  0x00, 0x03, 0xFC,
  0x00, 0x01, 0xFD,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x01, 0xFD,
  0x00, 0x03, 0xFC,
  0x00, 0x05, 0xF9,
  0x00, 0x08, 0xF6,
  0x00, 0x0C, 0xF1,
  0x00, 0x2F, 0xB0,
  0x00, 0x7F, 0x40,
  0x00, 0xDC, 0x00,
  0x06, 0xF3, 0x00,
  0x1E, 0x80, 0x00,
  0xAB, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_002A[ 45] = { /* code 002A, ASTERISK */
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0xA9, 0x40, 0xF0, 0x49, 0x90,
  0x7B, 0xEE, 0xFE, 0xEB, 0x60,
  0x00, 0x0A, 0xFA, 0x00, 0x00,
  0x00, 0x5E, 0x4E, 0x50, 0x00,
  0x03, 0xF6, 0x06, 0xF3, 0x00,
  0x05, 0xA0, 0x00, 0xA5, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_002B[120] = { /* code 002B, PLUS SIGN */
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_002C[  6] = { /* code 002C, COMMA */
  0xFF,
  0xFF,
  0x0F,
  0x1F,
  0x8B,
  0xB1
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_002D[  8] = { /* code 002D, HYPHEN-MINUS */
  0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_002E[  2] = { /* code 002E, FULL STOP */
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_002F[110] = { /* code 002F, SOLIDUS */
  0x00, 0x00, 0x00, 0x09, 0xC0,
  0x00, 0x00, 0x00, 0x0E, 0x70,
  0x00, 0x00, 0x00, 0x5F, 0x20,
  0x00, 0x00, 0x00, 0xAB, 0x00,
  0x00, 0x00, 0x00, 0xE6, 0x00,
  0x00, 0x00, 0x05, 0xF1, 0x00,
  0x00, 0x00, 0x0A, 0xA0, 0x00,
  0x00, 0x00, 0x1F, 0x40, 0x00,
  0x00, 0x00, 0x5E, 0x00, 0x00,
  0x00, 0x00, 0xA8, 0x00, 0x00,
  0x00, 0x01, 0xF3, 0x00, 0x00,
  0x00, 0x06, 0xD0, 0x00, 0x00,
  0x00, 0x0B, 0x70, 0x00, 0x00,
  0x00, 0x1F, 0x20, 0x00, 0x00,
  0x00, 0x7B, 0x00, 0x00, 0x00,
  0x00, 0xB6, 0x00, 0x00, 0x00,
  0x02, 0xF1, 0x00, 0x00, 0x00,
  0x07, 0xA0, 0x00, 0x00, 0x00,
  0x0C, 0x50, 0x00, 0x00, 0x00,
  0x2E, 0x00, 0x00, 0x00, 0x00,
  0x79, 0x00, 0x00, 0x00, 0x00,
  0xC3, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0030[108] = { /* code 0030, DIGIT ZERO */
  0x00, 0x07, 0xCF, 0xFC, 0x70, 0x00,
  0x01, 0xBF, 0xFF, 0xFF, 0xFB, 0x00,
  0x09, 0xFE, 0x50, 0x05, 0xEF, 0x80,
  0x2F, 0xF3, 0x00, 0x00, 0x3F, 0xF1,
  0x7F, 0xA0, 0x00, 0x00, 0x09, 0xF6,
  0xAF, 0x50, 0x00, 0x00, 0x05, 0xFA,
  0xDF, 0x20, 0x00, 0x00, 0x02, 0xFD,
  0xFF, 0x10, 0x00, 0x00, 0x01, 0xFE,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xEF, 0x10, 0x00, 0x00, 0x01, 0xFF,
  0xDF, 0x20, 0x00, 0x00, 0x02, 0xFD,
  0xAF, 0x50, 0x00, 0x00, 0x05, 0xFA,
  0x7F, 0xA0, 0x00, 0x00, 0x09, 0xF7,
  0x2F, 0xF3, 0x00, 0x00, 0x3F, 0xF2,
  0x09, 0xFE, 0x50, 0x05, 0xEF, 0x90,
  0x01, 0xBF, 0xFF, 0xFF, 0xFB, 0x00,
  0x00, 0x07, 0xCF, 0xFC, 0x70, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0031[ 72] = { /* code 0031, DIGIT ONE */
  0x00, 0x00, 0x0D, 0xF0,
  0x00, 0x00, 0x1F, 0xF0,
  0x00, 0x00, 0xAF, 0xF0,
  0x01, 0x4B, 0xFF, 0xF0,
  0xFF, 0xDB, 0x5F, 0xF0,
  0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0032[108] = { /* code 0032, DIGIT TWO */
  0x00, 0x28, 0xCF, 0xFE, 0xA4, 0x00,
  0x03, 0xEF, 0xFF, 0xFF, 0xFF, 0x80,
  0x1E, 0xFB, 0x30, 0x03, 0x9F, 0xF5,
  0x8F, 0xB0, 0x00, 0x00, 0x08, 0xFC,
  0xCF, 0x30, 0x00, 0x00, 0x02, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x02, 0xFC,
  0x00, 0x00, 0x00, 0x00, 0x0A, 0xF5,
  0x00, 0x00, 0x00, 0x01, 0xAF, 0x80,
  0x00, 0x00, 0x00, 0x6E, 0xE6, 0x00,
  0x00, 0x00, 0x4D, 0xF9, 0x10, 0x00,
  0x00, 0x19, 0xFA, 0x20, 0x00, 0x00,
  0x01, 0xBD, 0x30, 0x00, 0x00, 0x00,
  0x0B, 0xB1, 0x00, 0x00, 0x00, 0x00,
  0x5E, 0x10, 0x00, 0x00, 0x00, 0x00,
  0xB9, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0033[108] = { /* code 0033, DIGIT THREE */
  0x00, 0x04, 0xBF, 0xFD, 0x91, 0x00,
  0x00, 0x7F, 0xFF, 0xFF, 0xFE, 0x20,
  0x03, 0xFF, 0x71, 0x04, 0xDF, 0xA0,
  0x09, 0xF9, 0x00, 0x00, 0x3F, 0xE0,
  0x0D, 0xF3, 0x00, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x00, 0x3F, 0xB0,
  0x00, 0x00, 0x00, 0x15, 0xDE, 0x30,
  0x00, 0x00, 0x0F, 0xFF, 0xD3, 0x00,
  0x00, 0x00, 0x0F, 0xFF, 0xFC, 0x30,
  0x00, 0x00, 0x00, 0x03, 0x9F, 0xE2,
  0x00, 0x00, 0x00, 0x00, 0x07, 0xFA,
  0x00, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xDF, 0x30, 0x00, 0x00, 0x02, 0xFE,
  0x9F, 0xA0, 0x00, 0x00, 0x09, 0xFA,
  0x2F, 0xFA, 0x30, 0x03, 0xAF, 0xF3,
  0x05, 0xEF, 0xFF, 0xFF, 0xFF, 0x60,
  0x00, 0x29, 0xDF, 0xFD, 0x93, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0034[126] = { /* code 0034, DIGIT FOUR */
  0x00, 0x00, 0x00, 0x03, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0D, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x8C, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x03, 0xF3, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x0C, 0x70, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x7C, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x02, 0xE3, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x0C, 0x80, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x6D, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x02, 0xE3, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x0B, 0x90, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x6D, 0x10, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0035[108] = { /* code 0035, DIGIT FIVE */
  0x00, 0xCF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x03, 0xF5, 0x00, 0x00, 0x00, 0x00,
  0x07, 0xF3, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0x0C, 0xC3, 0xAE, 0xFD, 0x92, 0x00,
  0x1F, 0xDF, 0xFF, 0xFF, 0xFE, 0x30,
  0x3F, 0xC5, 0x20, 0x04, 0xCF, 0xE1,
  0x00, 0x00, 0x00, 0x00, 0x1D, 0xF7,
  0x00, 0x00, 0x00, 0x00, 0x05, 0xFC,
  0x00, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0xEF, 0x10, 0x00, 0x00, 0x04, 0xFC,
  0xBF, 0x80, 0x00, 0x00, 0x0C, 0xF7,
  0x4F, 0xF9, 0x30, 0x03, 0xBF, 0xD1,
  0x07, 0xFF, 0xFF, 0xFF, 0xFE, 0x20,
  0x00, 0x3A, 0xDF, 0xFC, 0x81, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0036[108] = { /* code 0036, DIGIT SIX */
  0x00, 0x02, 0x9D, 0xFF, 0xC7, 0x00,
  0x00, 0x5F, 0xFF, 0xFF, 0xFF, 0xC1,
  0x03, 0xFF, 0x92, 0x01, 0x5D, 0xF8,
  0x0C, 0xF8, 0x00, 0x00, 0x03, 0xFE,
  0x3F, 0xE0, 0x00, 0x00, 0x00, 0x00,
  0x8F, 0x80, 0x00, 0x00, 0x00, 0x00,
  0xBF, 0x41, 0x8D, 0xFE, 0xB3, 0x00,
  0xDF, 0x3D, 0xFF, 0xFF, 0xFF, 0x60,
  0xFF, 0xAE, 0x61, 0x03, 0xAF, 0xF3,
  0xFF, 0xF3, 0x00, 0x00, 0x0A, 0xF9,
  0xFF, 0xA0, 0x00, 0x00, 0x03, 0xFD,
  0xEF, 0x60, 0x00, 0x00, 0x00, 0xFF,
  0xCF, 0x70, 0x00, 0x00, 0x00, 0xFF,
  0x8F, 0xA0, 0x00, 0x00, 0x03, 0xFD,
  0x3F, 0xF3, 0x00, 0x00, 0x09, 0xF9,
  0x0A, 0xFE, 0x51, 0x02, 0x9F, 0xF2,
  0x01, 0xBF, 0xFF, 0xFF, 0xFF, 0x50,
  0x00, 0x07, 0xCF, 0xFE, 0xA3, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0037[108] = { /* code 0037, DIGIT SEVEN */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x07, 0xF8,
  0x00, 0x00, 0x00, 0x00, 0x4F, 0xA0,
  0x00, 0x00, 0x00, 0x02, 0xED, 0x10,
  0x00, 0x00, 0x00, 0x0C, 0xF3, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0x70, 0x00,
  0x00, 0x00, 0x02, 0xFD, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0xF4, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xB0, 0x00, 0x00,
  0x00, 0x00, 0xAF, 0x50, 0x00, 0x00,
  0x00, 0x01, 0xFD, 0x00, 0x00, 0x00,
  0x00, 0x07, 0xF7, 0x00, 0x00, 0x00,
  0x00, 0x0C, 0xF2, 0x00, 0x00, 0x00,
  0x00, 0x2F, 0xD0, 0x00, 0x00, 0x00,
  0x00, 0x7F, 0x80, 0x00, 0x00, 0x00,
  0x00, 0xAF, 0x50, 0x00, 0x00, 0x00,
  0x00, 0xEF, 0x20, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0038[108] = { /* code 0038, DIGIT EIGHT */
  0x00, 0x07, 0xCF, 0xFC, 0x70, 0x00,
  0x00, 0xBF, 0xFF, 0xFF, 0xFB, 0x00,
  0x07, 0xFE, 0x50, 0x05, 0xEF, 0x70,
  0x0C, 0xF5, 0x00, 0x00, 0x5F, 0xC0,
  0x0F, 0xF1, 0x00, 0x00, 0x1F, 0xF0,
  0x0E, 0xF0, 0x00, 0x00, 0x0F, 0xE0,
  0x0B, 0xF5, 0x00, 0x00, 0x5F, 0xB0,
  0x03, 0xEE, 0x50, 0x05, 0xEE, 0x30,
  0x00, 0x3D, 0xFF, 0xFF, 0xC3, 0x00,
  0x01, 0x9F, 0xFF, 0xFF, 0xF9, 0x10,
  0x2E, 0xF8, 0x30, 0x03, 0x8F, 0xD1,
  0xAF, 0x60, 0x00, 0x00, 0x06, 0xFA,
  0xEF, 0x10, 0x00, 0x00, 0x00, 0xFE,
  0xFF, 0x10, 0x00, 0x00, 0x01, 0xFF,
  0xCF, 0x70, 0x00, 0x00, 0x07, 0xFC,
  0x6F, 0xF9, 0x30, 0x03, 0x9F, 0xF6,
  0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x00, 0x4A, 0xDF, 0xFD, 0xA4, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0039[108] = { /* code 0039, DIGIT NINE */
  0x00, 0x3A, 0xEF, 0xFC, 0x70, 0x00,
  0x05, 0xFF, 0xFF, 0xFF, 0xFB, 0x10,
  0x2F, 0xF9, 0x20, 0x15, 0xEF, 0xA0,
  0x9F, 0x90, 0x00, 0x00, 0x3F, 0xF3,
  0xDF, 0x30, 0x00, 0x00, 0x09, 0xF8,
  0xFF, 0x00, 0x00, 0x00, 0x06, 0xFC,
  0xFF, 0x00, 0x00, 0x00, 0x06, 0xFE,
  0xDF, 0x30, 0x00, 0x00, 0x09, 0xFF,
  0x9F, 0xA0, 0x00, 0x00, 0x3E, 0xFF,
  0x3F, 0xFA, 0x20, 0x16, 0xEA, 0xFF,
  0x06, 0xFF, 0xFF, 0xFF, 0xD3, 0xFD,
  0x00, 0x3B, 0xEF, 0xD8, 0x14, 0xFB,
  0x00, 0x00, 0x00, 0x00, 0x08, 0xF8,
  0x00, 0x00, 0x00, 0x00, 0x0D, 0xF3,
  0xEF, 0x30, 0x00, 0x00, 0x7F, 0xC0,
  0x8F, 0xD5, 0x10, 0x29, 0xFF, 0x40,
  0x1C, 0xFF, 0xFF, 0xFF, 0xF5, 0x00,
  0x01, 0x7C, 0xFF, 0xD9, 0x30, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_003A[ 14] = { /* code 003A, COLON */
  0xFF,
  0xFF,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_003B[ 18] = { /* code 003B, SEMICOLON */
  0xFF,
  0xFF,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0xFF,
  0xFF,
  0x0F,
  0x1F,
  0x9B,
  0xB1
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_003C[112] = { /* code 003C, LESS-THAN SIGN */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x8E, 0xD7,
  0x00, 0x00, 0x00, 0x00, 0x05, 0xBF, 0xA4, 0x00,
  0x00, 0x00, 0x00, 0x17, 0xDD, 0x71, 0x00, 0x00,
  0x00, 0x00, 0x4A, 0xFB, 0x40, 0x00, 0x00, 0x00,
  0x01, 0x7D, 0xE8, 0x20, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xB5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x9E, 0xB4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x7D, 0xD7, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x4A, 0xFA, 0x40, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x27, 0xED, 0x71, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0xBF, 0x93, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x8E, 0xC6,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_003D[ 48] = { /* code 003D, EQUALS SIGN */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_003E[112] = { /* code 003E, GREATER-THAN SIGN */
  0xC6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x7D, 0xE8, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x4A, 0xFB, 0x50, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x17, 0xDD, 0x71, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x04, 0xBF, 0xA4, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x8E, 0xD7, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5B, 0xF9,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4B, 0xE9,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x7D, 0xD7, 0x10,
  0x00, 0x00, 0x00, 0x04, 0xAF, 0xA4, 0x00, 0x00,
  0x00, 0x00, 0x17, 0xDE, 0x72, 0x00, 0x00, 0x00,
  0x00, 0x39, 0xFB, 0x50, 0x00, 0x00, 0x00, 0x00,
  0x6C, 0xE8, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xC6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_003F[114] = { /* code 003F, QUESTION MARK */
  0x00, 0x28, 0xCF, 0xFE, 0xA4, 0x00,
  0x05, 0xEF, 0xFF, 0xFF, 0xFF, 0x90,
  0x2E, 0xFB, 0x30, 0x02, 0x8F, 0xF6,
  0x8F, 0xB0, 0x00, 0x00, 0x07, 0xFC,
  0xCF, 0x30, 0x00, 0x00, 0x01, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x05, 0xFB,
  0x00, 0x00, 0x00, 0x00, 0x1D, 0xF4,
  0x00, 0x00, 0x00, 0x01, 0xBF, 0x70,
  0x00, 0x00, 0x00, 0x1B, 0xF7, 0x00,
  0x00, 0x00, 0x00, 0xBF, 0x70, 0x00,
  0x00, 0x00, 0x07, 0xFA, 0x00, 0x00,
  0x00, 0x00, 0x0C, 0xF2, 0x00, 0x00,
  0x00, 0x00, 0x0D, 0xD0, 0x00, 0x00,
  0x00, 0x00, 0x0D, 0xD0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0040[276] = { /* code 0040, COMMERCIAL AT */
  0x00, 0x00, 0x00, 0x00, 0x48, 0xCE, 0xFF, 0xEC, 0x95, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x7E, 0xB7, 0x31, 0x00, 0x13, 0x6B, 0xD6, 0x00, 0x00,
  0x00, 0x00, 0x3C, 0xA2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2B, 0xB1, 0x00,
  0x00, 0x03, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7B, 0x10,
  0x00, 0x3E, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x90,
  0x01, 0xD5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xD3,
  0x08, 0x90, 0x00, 0x00, 0x04, 0xBE, 0xFC, 0x40, 0x54, 0x00, 0x00, 0x79,
  0x1E, 0x10, 0x00, 0x00, 0x8C, 0x40, 0x05, 0xD4, 0xE5, 0x00, 0x00, 0x3C,
  0x6A, 0x00, 0x00, 0x07, 0xB1, 0x00, 0x00, 0x3E, 0xF1, 0x00, 0x00, 0x0F,
  0xA5, 0x00, 0x00, 0x1E, 0x20, 0x00, 0x00, 0x0C, 0xD0, 0x00, 0x00, 0x0F,
  0xD2, 0x00, 0x00, 0x88, 0x00, 0x00, 0x00, 0x0D, 0x90, 0x00, 0x00, 0x1E,
  0xF0, 0x00, 0x00, 0xC4, 0x00, 0x00, 0x00, 0x1F, 0x50, 0x00, 0x00, 0x4B,
  0xF0, 0x00, 0x00, 0xE1, 0x00, 0x00, 0x00, 0x5F, 0x10, 0x00, 0x00, 0x97,
  0xE1, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x9D, 0x00, 0x00, 0x01, 0xE1,
  0xC3, 0x00, 0x00, 0xE1, 0x00, 0x00, 0x01, 0xE9, 0x00, 0x00, 0x0A, 0x70,
  0x87, 0x00, 0x00, 0xB6, 0x00, 0x00, 0x09, 0xF6, 0x00, 0x00, 0x9B, 0x00,
  0x3C, 0x00, 0x00, 0x3E, 0x61, 0x04, 0xB5, 0xFB, 0x11, 0x5C, 0xA0, 0x00,
  0x0B, 0x60, 0x00, 0x04, 0xBF, 0xFB, 0x40, 0x5D, 0xFE, 0xA4, 0x00, 0x00,
  0x02, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x3D, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x70, 0x00,
  0x00, 0x02, 0xC9, 0x10, 0x00, 0x00, 0x00, 0x00, 0x01, 0x8E, 0x90, 0x00,
  0x00, 0x00, 0x07, 0xDA, 0x63, 0x10, 0x01, 0x37, 0xBF, 0xA3, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x04, 0x9C, 0xEF, 0xFF, 0xDA, 0x62, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0041[171] = { /* code 0041, LATIN CAPITAL LETTER A */
  0x00, 0x00, 0x00, 0x0D, 0xFB, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3F, 0xFF, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x9F, 0x6F, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0xEB, 0x0D, 0xD0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x06, 0xF4, 0x07, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0C, 0xD0, 0x01, 0xFA, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0x70, 0x00, 0x9F, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x8F, 0x10, 0x00, 0x3F, 0x70, 0x00, 0x00,
  0x00, 0x00, 0xEA, 0x00, 0x00, 0x0C, 0xD0, 0x00, 0x00,
  0x00, 0x05, 0xF3, 0x00, 0x00, 0x06, 0xF4, 0x00, 0x00,
  0x00, 0x0B, 0xC0, 0x00, 0x00, 0x00, 0xEA, 0x00, 0x00,
  0x00, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x10, 0x00,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x70, 0x00,
  0x00, 0xDD, 0x00, 0x00, 0x00, 0x00, 0x0E, 0xC0, 0x00,
  0x04, 0xF7, 0x00, 0x00, 0x00, 0x00, 0x09, 0xF3, 0x00,
  0x0A, 0xF1, 0x00, 0x00, 0x00, 0x00, 0x03, 0xF9, 0x00,
  0x1F, 0xB0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xDF, 0x10,
  0x6F, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x60,
  0xCE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xC0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0042[133] = { /* code 0042, LATIN CAPITAL LETTER B */
  0xFF, 0xFF, 0xFF, 0xFF, 0xDB, 0x50, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x00,
  0xFF, 0x00, 0x00, 0x01, 0x37, 0xEF, 0x60,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xD0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xE0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x5F, 0x90,
  0xFF, 0x00, 0x00, 0x01, 0x38, 0xEC, 0x10,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA1, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x20,
  0xFF, 0x00, 0x00, 0x00, 0x15, 0xBF, 0xD1,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xF8,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x02, 0xFD,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFB,
  0xFF, 0x00, 0x00, 0x00, 0x13, 0x8F, 0xF4,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0xFF, 0xFF, 0xFF, 0xFF, 0xED, 0xB4, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0043[152] = { /* code 0043, LATIN CAPITAL LETTER C */
  0x00, 0x00, 0x28, 0xCF, 0xFF, 0xC9, 0x30, 0x00,
  0x00, 0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x00,
  0x00, 0xAF, 0xF9, 0x31, 0x01, 0x49, 0xFF, 0xA0,
  0x07, 0xFE, 0x30, 0x00, 0x00, 0x00, 0x4E, 0xF6,
  0x1E, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFB,
  0x6F, 0xB0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0xAF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xAF, 0x60, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0x6F, 0xB0, 0x00, 0x00, 0x00, 0x00, 0x04, 0xFC,
  0x1E, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x0B, 0xF7,
  0x07, 0xFE, 0x40, 0x00, 0x00, 0x00, 0x7F, 0xE1,
  0x00, 0xAF, 0xF9, 0x41, 0x01, 0x5B, 0xFF, 0x60,
  0x00, 0x09, 0xFF, 0xFF, 0xFF, 0xFF, 0xE6, 0x00,
  0x00, 0x00, 0x39, 0xCF, 0xFE, 0xC7, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0044[152] = { /* code 0044, LATIN CAPITAL LETTER D */
  0xFF, 0xFF, 0xFF, 0xFF, 0xDB, 0x60, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x20, 0x00,
  0xFF, 0x00, 0x00, 0x01, 0x26, 0xDF, 0xE2, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x1B, 0xFA, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x02, 0xFF, 0x20,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9F, 0x70,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xB0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xB0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8F, 0x70,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x01, 0xEF, 0x30,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0B, 0xFA, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x25, 0xCF, 0xE2, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x20, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xDB, 0x60, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0045[133] = { /* code 0045, LATIN CAPITAL LETTER E */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x90,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x90,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0046[114] = { /* code 0046, LATIN CAPITAL LETTER F */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF2,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0047[171] = { /* code 0047, LATIN CAPITAL LETTER G */
  0x00, 0x00, 0x17, 0xBE, 0xFF, 0xEB, 0x83, 0x00, 0x00,
  0x00, 0x07, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xA1, 0x00,
  0x00, 0x8F, 0xFA, 0x51, 0x00, 0x14, 0x9F, 0xFB, 0x00,
  0x06, 0xFE, 0x50, 0x00, 0x00, 0x00, 0x02, 0xDF, 0x70,
  0x1E, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xD0,
  0x6F, 0xB0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xAF, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xF0,
  0xDF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xAF, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xF0,
  0x6F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6F, 0xF0,
  0x1E, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x01, 0xDF, 0xF0,
  0x07, 0xFF, 0x50, 0x00, 0x00, 0x00, 0x1B, 0xDD, 0xF0,
  0x00, 0xAF, 0xFA, 0x41, 0x00, 0x37, 0xEE, 0x3C, 0xF0,
  0x00, 0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xD3, 0x0B, 0xF0,
  0x00, 0x00, 0x28, 0xCF, 0xFE, 0xC7, 0x10, 0x0A, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0048[152] = { /* code 0048, LATIN CAPITAL LETTER H */
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0049[ 19] = { /* code 0049, LATIN CAPITAL LETTER I */
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_004A[ 95] = { /* code 004A, LATIN CAPITAL LETTER J */
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xEF, 0x10, 0x00, 0x02, 0xFE,
  0xCF, 0x60, 0x00, 0x06, 0xFB,
  0x7F, 0xE4, 0x01, 0x5E, 0xF5,
  0x0C, 0xFF, 0xFF, 0xFF, 0xA0,
  0x01, 0x8D, 0xFF, 0xC6, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_004B[152] = { /* code 004B, LATIN CAPITAL LETTER K */
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xF8, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x9F, 0x80, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x08, 0xFA, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x8F, 0xA0, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x08, 0xFA, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x8F, 0xA0, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x08, 0xFA, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x7F, 0xA0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x07, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x7F, 0xA7, 0xF9, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFB, 0x10, 0xAF, 0x60, 0x00, 0x00, 0x00,
  0xFF, 0xB1, 0x00, 0x1D, 0xF3, 0x00, 0x00, 0x00,
  0xFF, 0x10, 0x00, 0x03, 0xFD, 0x10, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x6F, 0xB0, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x09, 0xF7, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x01, 0xCF, 0x40, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x2E, 0xE2, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x05, 0xFC, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8F, 0x90
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_004C[114] = { /* code 004C, LATIN CAPITAL LETTER L */
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_004D[171] = { /* code 004D, LATIN CAPITAL LETTER M */
  0xFF, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0xFF,
  0xFF, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xFF,
  0xFF, 0xEA, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAE, 0xFF,
  0xFF, 0x9F, 0x10, 0x00, 0x00, 0x00, 0x01, 0xF9, 0xFF,
  0xFF, 0x4F, 0x60, 0x00, 0x00, 0x00, 0x07, 0xF4, 0xFF,
  0xFF, 0x0D, 0xC0, 0x00, 0x00, 0x00, 0x0C, 0xD0, 0xFF,
  0xFF, 0x08, 0xF2, 0x00, 0x00, 0x00, 0x3F, 0x80, 0xFF,
  0xFF, 0x03, 0xF8, 0x00, 0x00, 0x00, 0x8F, 0x30, 0xFF,
  0xFF, 0x00, 0xCD, 0x00, 0x00, 0x00, 0xEC, 0x00, 0xFF,
  0xFF, 0x00, 0x7F, 0x40, 0x00, 0x05, 0xF7, 0x00, 0xFF,
  0xFF, 0x00, 0x1F, 0xA0, 0x00, 0x0A, 0xF1, 0x00, 0xFF,
  0xFF, 0x00, 0x0B, 0xF1, 0x00, 0x1F, 0xB0, 0x00, 0xFF,
  0xFF, 0x00, 0x05, 0xF6, 0x00, 0x7F, 0x50, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xEB, 0x00, 0xCE, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x9F, 0x23, 0xF9, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x4F, 0x88, 0xF4, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x0D, 0xDE, 0xD0, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x08, 0xFF, 0x80, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x03, 0xFF, 0x30, 0x00, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_004E[152] = { /* code 004E, LATIN CAPITAL LETTER N */
  0xFF, 0x40, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0xE1, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0xFA, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x7F, 0x50, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x0C, 0xE1, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x02, 0xFB, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x6F, 0x60, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x0B, 0xE2, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x02, 0xEB, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x6F, 0x60, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0B, 0xE2, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x02, 0xEB, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x6F, 0x60, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0B, 0xE2, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x02, 0xEC, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x5F, 0x7F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xFF, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x01, 0xEF, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_004F[171] = { /* code 004F, LATIN CAPITAL LETTER O */
  0x00, 0x00, 0x17, 0xBE, 0xFF, 0xEB, 0x71, 0x00, 0x00,
  0x00, 0x05, 0xEF, 0xFF, 0xFF, 0xFF, 0xFE, 0x50, 0x00,
  0x00, 0x7F, 0xFC, 0x52, 0x00, 0x26, 0xCF, 0xF7, 0x00,
  0x05, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x07, 0xFF, 0x50,
  0x0E, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xE0,
  0x5F, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0xF5,
  0xAF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFA,
  0xDF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFD,
  0xFF, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xDF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFD,
  0xAF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFA,
  0x5F, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0xF5,
  0x0E, 0xF7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xE0,
  0x05, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x07, 0xFF, 0x50,
  0x00, 0x7F, 0xFC, 0x52, 0x00, 0x25, 0xCF, 0xF7, 0x00,
  0x00, 0x05, 0xEF, 0xFF, 0xFF, 0xFF, 0xFE, 0x50, 0x00,
  0x00, 0x00, 0x17, 0xBE, 0xFF, 0xEB, 0x71, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0050[133] = { /* code 0050, LATIN CAPITAL LETTER P */
  0xFF, 0xFF, 0xFF, 0xFF, 0xDA, 0x40, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x39, 0xFF, 0x40,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xB0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xE0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xE0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x8F, 0xB0,
  0xFF, 0x00, 0x00, 0x01, 0x4A, 0xFF, 0x30,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x00,
  0xFF, 0xFF, 0xFF, 0xFE, 0xB8, 0x20, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0051[180] = { /* code 0051, LATIN CAPITAL LETTER Q */
  0x00, 0x00, 0x17, 0xBE, 0xFF, 0xEB, 0x71, 0x00, 0x00,
  0x00, 0x05, 0xEF, 0xFF, 0xFF, 0xFF, 0xFE, 0x70, 0x00,
  0x00, 0x7F, 0xFC, 0x52, 0x00, 0x25, 0xCF, 0xF8, 0x00,
  0x05, 0xFF, 0x70, 0x00, 0x00, 0x00, 0x07, 0xFF, 0x60,
  0x0E, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xE1,
  0x5F, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0xF7,
  0xAF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xFB,
  0xDF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFD,
  0xFF, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0xDF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFC,
  0xAF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xF8,
  0x5F, 0xD0, 0x00, 0x00, 0x00, 0x69, 0x00, 0x1E, 0xF2,
  0x0E, 0xF7, 0x00, 0x00, 0x00, 0x9F, 0xB1, 0x9F, 0x90,
  0x05, 0xFF, 0x70, 0x00, 0x00, 0x07, 0xFF, 0xFB, 0x00,
  0x00, 0x8F, 0xFC, 0x62, 0x00, 0x27, 0xEF, 0xF5, 0x00,
  0x00, 0x06, 0xEF, 0xFF, 0xFF, 0xFF, 0xF9, 0xEF, 0x50,
  0x00, 0x00, 0x17, 0xBE, 0xFF, 0xD9, 0x30, 0x2E, 0xF7,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xC6
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0052[133] = { /* code 0052, LATIN CAPITAL LETTER R */
  0xFF, 0xFF, 0xFF, 0xFF, 0xED, 0x93, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x70,
  0xFF, 0x00, 0x00, 0x00, 0x13, 0xAF, 0xF4,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x08, 0xFB,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x02, 0xFE,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x02, 0xFD,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x09, 0xF7,
  0xFF, 0x00, 0x00, 0x00, 0x14, 0xBF, 0xC1,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE8, 0x10,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x15, 0xEF, 0x50,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x6F, 0xB0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xD0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0E, 0xF2,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0B, 0xF4,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x09, 0xF6,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x04, 0xFB
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0053[133] = { /* code 0053, LATIN CAPITAL LETTER S */
  0x00, 0x4A, 0xEF, 0xFD, 0x92, 0x00, 0x00,
  0x08, 0xFF, 0xFF, 0xFF, 0xFE, 0x50, 0x00,
  0x5F, 0xF8, 0x20, 0x03, 0xBF, 0xE2, 0x00,
  0xCF, 0x70, 0x00, 0x00, 0x0B, 0xF9, 0x00,
  0xFF, 0x10, 0x00, 0x00, 0x03, 0xFD, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0xCF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5F, 0xD3, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x06, 0xFF, 0xC8, 0x41, 0x00, 0x00, 0x00,
  0x00, 0x17, 0xCF, 0xFF, 0xB6, 0x10, 0x00,
  0x00, 0x00, 0x01, 0x58, 0xDF, 0xE5, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0xEF, 0x40,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xC0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xDF, 0x40, 0x00, 0x00, 0x00, 0x1F, 0xF0,
  0x9F, 0xC1, 0x00, 0x00, 0x00, 0x8F, 0xB0,
  0x2E, 0xFD, 0x51, 0x00, 0x3A, 0xFF, 0x50,
  0x03, 0xEF, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0x00, 0x17, 0xCE, 0xFF, 0xD9, 0x30, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0054[133] = { /* code 0054, LATIN CAPITAL LETTER T */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0055[152] = { /* code 0055, LATIN CAPITAL LETTER U */
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x10, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF0,
  0xDF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xD0,
  0x9F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x8F, 0x90,
  0x3F, 0xF3, 0x00, 0x00, 0x00, 0x03, 0xFF, 0x30,
  0x0A, 0xFF, 0x83, 0x00, 0x13, 0x8F, 0xFA, 0x00,
  0x00, 0xAF, 0xFF, 0xFF, 0xFF, 0xFF, 0x90, 0x00,
  0x00, 0x03, 0x9D, 0xFF, 0xFC, 0x93, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0056[152] = { /* code 0056, LATIN CAPITAL LETTER V */
  0xCF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFC,
  0x7F, 0x70, 0x00, 0x00, 0x00, 0x00, 0x06, 0xF7,
  0x1F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x0C, 0xF1,
  0x0B, 0xF3, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xB0,
  0x05, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x8F, 0x50,
  0x00, 0xED, 0x00, 0x00, 0x00, 0x00, 0xDE, 0x00,
  0x00, 0x9F, 0x40, 0x00, 0x00, 0x03, 0xF9, 0x00,
  0x00, 0x3F, 0xA0, 0x00, 0x00, 0x09, 0xF3, 0x00,
  0x00, 0x0D, 0xE1, 0x00, 0x00, 0x0E, 0xD0, 0x00,
  0x00, 0x07, 0xF5, 0x00, 0x00, 0x5F, 0x70, 0x00,
  0x00, 0x02, 0xFB, 0x00, 0x00, 0xAF, 0x20, 0x00,
  0x00, 0x00, 0xBF, 0x20, 0x01, 0xFB, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0x70, 0x06, 0xF6, 0x00, 0x00,
  0x00, 0x00, 0x1F, 0xC0, 0x0C, 0xF1, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0xF3, 0x2F, 0xA0, 0x00, 0x00,
  0x00, 0x00, 0x04, 0xF8, 0x8F, 0x40, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xED, 0xDE, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x8F, 0xF8, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x3F, 0xF3, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0057[228] = { /* code 0057, LATIN CAPITAL LETTER W */
  0xDD, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xF2, 0x00, 0x00, 0x00, 0x0C, 0xD0,
  0x9F, 0x20, 0x00, 0x00, 0x00, 0x7F, 0xF6, 0x00, 0x00, 0x00, 0x1F, 0x90,
  0x5F, 0x60, 0x00, 0x00, 0x00, 0xBD, 0xE9, 0x00, 0x00, 0x00, 0x5F, 0x50,
  0x1F, 0xA0, 0x00, 0x00, 0x01, 0xF8, 0xAD, 0x00, 0x00, 0x00, 0x9F, 0x10,
  0x0C, 0xE0, 0x00, 0x00, 0x05, 0xF4, 0x7F, 0x10, 0x00, 0x00, 0xDC, 0x00,
  0x08, 0xF3, 0x00, 0x00, 0x0A, 0xE0, 0x3F, 0x50, 0x00, 0x02, 0xF8, 0x00,
  0x04, 0xF7, 0x00, 0x00, 0x0E, 0xA0, 0x0F, 0x90, 0x00, 0x06, 0xF4, 0x00,
  0x01, 0xFB, 0x00, 0x00, 0x4F, 0x60, 0x0B, 0xD0, 0x00, 0x0A, 0xF1, 0x00,
  0x00, 0xBF, 0x00, 0x00, 0x8F, 0x10, 0x07, 0xF1, 0x00, 0x0E, 0xB0, 0x00,
  0x00, 0x7F, 0x40, 0x00, 0xDC, 0x00, 0x04, 0xF5, 0x00, 0x3F, 0x70, 0x00,
  0x00, 0x4F, 0x80, 0x02, 0xF7, 0x00, 0x01, 0xF8, 0x00, 0x7F, 0x40, 0x00,
  0x00, 0x0E, 0xC0, 0x07, 0xF3, 0x00, 0x00, 0xCC, 0x00, 0xBE, 0x00, 0x00,
  0x00, 0x0B, 0xF1, 0x0B, 0xE0, 0x00, 0x00, 0x8F, 0x10, 0xEB, 0x00, 0x00,
  0x00, 0x07, 0xF5, 0x1F, 0x90, 0x00, 0x00, 0x5F, 0x54, 0xF7, 0x00, 0x00,
  0x00, 0x03, 0xF9, 0x5F, 0x50, 0x00, 0x00, 0x1F, 0x87, 0xF3, 0x00, 0x00,
  0x00, 0x00, 0xED, 0xAF, 0x10, 0x00, 0x00, 0x0D, 0xCB, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0xAF, 0xFB, 0x00, 0x00, 0x00, 0x09, 0xFF, 0xA0, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0xF7, 0x00, 0x00, 0x00, 0x05, 0xFF, 0x60, 0x00, 0x00,
  0x00, 0x00, 0x2F, 0xF2, 0x00, 0x00, 0x00, 0x02, 0xFF, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0058[152] = { /* code 0058, LATIN CAPITAL LETTER X */
  0xAF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xA0,
  0x1D, 0xF3, 0x00, 0x00, 0x00, 0x03, 0xFD, 0x10,
  0x04, 0xFD, 0x10, 0x00, 0x00, 0x0C, 0xF4, 0x00,
  0x00, 0x8F, 0x90, 0x00, 0x00, 0x8F, 0x90, 0x00,
  0x00, 0x0C, 0xF4, 0x00, 0x03, 0xFD, 0x10, 0x00,
  0x00, 0x03, 0xFD, 0x10, 0x1D, 0xF3, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0xA0, 0x9F, 0x70, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0xF8, 0xFC, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x02, 0xEF, 0xF2, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xBF, 0xB0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x06, 0xFE, 0xF6, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x2E, 0xE3, 0xDE, 0x20, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0x60, 0x4F, 0xB0, 0x00, 0x00,
  0x00, 0x05, 0xFB, 0x00, 0x0A, 0xF6, 0x00, 0x00,
  0x00, 0x1E, 0xE2, 0x00, 0x01, 0xEE, 0x20, 0x00,
  0x00, 0xAF, 0x60, 0x00, 0x00, 0x5F, 0xA0, 0x00,
  0x05, 0xFB, 0x00, 0x00, 0x00, 0x0B, 0xF5, 0x00,
  0x1E, 0xE2, 0x00, 0x00, 0x00, 0x02, 0xEE, 0x10,
  0xAF, 0x60, 0x00, 0x00, 0x00, 0x00, 0x6F, 0xA0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0059[152] = { /* code 0059, LATIN CAPITAL LETTER Y */
  0xAF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFA,
  0x1E, 0xE2, 0x00, 0x00, 0x00, 0x00, 0x2E, 0xE1,
  0x06, 0xFB, 0x00, 0x00, 0x00, 0x00, 0xBF, 0x60,
  0x00, 0xBF, 0x60, 0x00, 0x00, 0x06, 0xFB, 0x00,
  0x00, 0x2E, 0xE2, 0x00, 0x00, 0x2E, 0xE2, 0x00,
  0x00, 0x06, 0xFB, 0x00, 0x00, 0xBF, 0x60, 0x00,
  0x00, 0x00, 0xBF, 0x60, 0x06, 0xFB, 0x00, 0x00,
  0x00, 0x00, 0x2E, 0xE2, 0x2E, 0xE2, 0x00, 0x00,
  0x00, 0x00, 0x06, 0xFA, 0xAF, 0x60, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xBF, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x2F, 0xF2, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_005A[133] = { /* code 005A, LATIN CAPITAL LETTER Z */
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD,
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xE2,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x50,
  0x00, 0x00, 0x00, 0x00, 0x03, 0xF8, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x1D, 0xC0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xBE, 0x20, 0x00,
  0x00, 0x00, 0x00, 0x07, 0xF5, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x01, 0xEC, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0xE2, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0x50, 0x00, 0x00, 0x00,
  0x00, 0x04, 0xF8, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x2E, 0xC0, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xBE, 0x20, 0x00, 0x00, 0x00, 0x00,
  0x08, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_005B[ 75] = { /* code 005B, LEFT SQUARE BRACKET */
  0xFF, 0xFF, 0xF0,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_005C[110] = { /* code 005C, REVERSE SOLIDUS */
  0xC3, 0x00, 0x00, 0x00, 0x00,
  0x79, 0x00, 0x00, 0x00, 0x00,
  0x2E, 0x00, 0x00, 0x00, 0x00,
  0x0C, 0x50, 0x00, 0x00, 0x00,
  0x07, 0xA0, 0x00, 0x00, 0x00,
  0x02, 0xF1, 0x00, 0x00, 0x00,
  0x00, 0xB6, 0x00, 0x00, 0x00,
  0x00, 0x7B, 0x00, 0x00, 0x00,
  0x00, 0x1F, 0x20, 0x00, 0x00,
  0x00, 0x0B, 0x70, 0x00, 0x00,
  0x00, 0x06, 0xD0, 0x00, 0x00,
  0x00, 0x01, 0xF3, 0x00, 0x00,
  0x00, 0x00, 0xA8, 0x00, 0x00,
  0x00, 0x00, 0x5E, 0x00, 0x00,
  0x00, 0x00, 0x1F, 0x40, 0x00,
  0x00, 0x00, 0x0A, 0xA0, 0x00,
  0x00, 0x00, 0x05, 0xF1, 0x00,
  0x00, 0x00, 0x00, 0xE6, 0x00,
  0x00, 0x00, 0x00, 0xAB, 0x00,
  0x00, 0x00, 0x00, 0x5F, 0x20,
  0x00, 0x00, 0x00, 0x0E, 0x70,
  0x00, 0x00, 0x00, 0x09, 0xC0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_005D[ 75] = { /* code 005D, RIGHT SQUARE BRACKET */
  0xFF, 0xFF, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_005E[ 56] = { /* code 005E, CIRCUMFLEX ACCENT */
  0x00, 0x00, 0x00, 0x5F, 0xF5, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x05, 0xF8, 0x8F, 0x50, 0x00, 0x00,
  0x00, 0x00, 0x5F, 0x80, 0x07, 0xF5, 0x00, 0x00,
  0x00, 0x07, 0xF7, 0x00, 0x00, 0x7F, 0x70, 0x00,
  0x00, 0x7F, 0x60, 0x00, 0x00, 0x05, 0xF7, 0x00,
  0x07, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x5F, 0x70,
  0x7E, 0x30, 0x00, 0x00, 0x00, 0x00, 0x03, 0xE7
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_005F[  7] = { /* code 005F, LOW LINE */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0060[ 15] = { /* code 0060, GRAVE ACCENT */
  0x9F, 0x60, 0x00,
  0x1C, 0xE1, 0x00,
  0x03, 0xF8, 0x00,
  0x00, 0x6F, 0x20,
  0x00, 0x0A, 0xB0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0061[ 98] = { /* code 0061, LATIN SMALL LETTER A */
  0x00, 0x17, 0xCF, 0xFE, 0xA3, 0x00, 0x00,
  0x01, 0xDE, 0x61, 0x03, 0xCF, 0x40, 0x00,
  0x09, 0xF6, 0x00, 0x00, 0x3F, 0xC0, 0x00,
  0x0E, 0xF1, 0x00, 0x00, 0x0F, 0xF0, 0x00,
  0x04, 0x40, 0x00, 0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x02, 0xAF, 0xF0, 0x00,
  0x00, 0x38, 0xBD, 0xDC, 0xAF, 0xF0, 0x00,
  0x1A, 0xFA, 0x30, 0x00, 0x0F, 0xF0, 0x00,
  0x9F, 0x90, 0x00, 0x00, 0x0F, 0xF0, 0x00,
  0xEF, 0x10, 0x00, 0x00, 0x1F, 0xF0, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x6F, 0xF0, 0x00,
  0xBF, 0x40, 0x00, 0x01, 0xDF, 0xF0, 0x00,
  0x3F, 0xE4, 0x01, 0x5D, 0x9D, 0xF3, 0x00,
  0x03, 0xBE, 0xFE, 0xA4, 0x05, 0xDF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0062[133] = { /* code 0062, LATIN SMALL LETTER B */
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x02, 0x9D, 0xFF, 0xC7, 0x10, 0x00,
  0xFF, 0x4D, 0x61, 0x02, 0x7E, 0xD1, 0x00,
  0xFF, 0xE3, 0x00, 0x00, 0x04, 0xFC, 0x00,
  0xFF, 0x80, 0x00, 0x00, 0x00, 0xAF, 0x50,
  0xFF, 0x30, 0x00, 0x00, 0x00, 0x4F, 0xB0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xE0,
  0xFD, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFD, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xE0,
  0xFF, 0x30, 0x00, 0x00, 0x00, 0x4F, 0xA0,
  0xFF, 0x80, 0x00, 0x00, 0x00, 0xAF, 0x50,
  0xFF, 0xE3, 0x00, 0x00, 0x04, 0xFC, 0x00,
  0xFF, 0x5E, 0x71, 0x02, 0x7E, 0xC1, 0x00,
  0xFF, 0x02, 0x9D, 0xFF, 0xC7, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0063[ 84] = { /* code 0063, LATIN SMALL LETTER C */
  0x00, 0x07, 0xCE, 0xFE, 0xA3, 0x00,
  0x01, 0xCE, 0x71, 0x03, 0xCF, 0x70,
  0x0B, 0xF4, 0x00, 0x00, 0x1D, 0xF4,
  0x5F, 0xA0, 0x00, 0x00, 0x05, 0xFB,
  0xAF, 0x40, 0x00, 0x00, 0x01, 0xFE,
  0xDF, 0x10, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xEF, 0x20, 0x00, 0x00, 0x00, 0x00,
  0xBF, 0x50, 0x00, 0x00, 0x01, 0xFE,
  0x5F, 0xA0, 0x00, 0x00, 0x05, 0xFA,
  0x0C, 0xF4, 0x00, 0x00, 0x1D, 0xF3,
  0x02, 0xDE, 0x71, 0x03, 0xCF, 0x60,
  0x00, 0x17, 0xCF, 0xFD, 0xA3, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0064[133] = { /* code 0064, LATIN SMALL LETTER D */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x07, 0xCF, 0xFD, 0x93, 0x0F, 0xF0,
  0x01, 0xCE, 0x72, 0x01, 0x6D, 0x5F, 0xF0,
  0x0C, 0xF4, 0x00, 0x00, 0x02, 0xEF, 0xF0,
  0x5F, 0xA0, 0x00, 0x00, 0x00, 0x7F, 0xF0,
  0xAF, 0x40, 0x00, 0x00, 0x00, 0x2F, 0xF0,
  0xEF, 0x10, 0x00, 0x00, 0x00, 0x0E, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0D, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0D, 0xF0,
  0xEF, 0x10, 0x00, 0x00, 0x00, 0x0E, 0xF0,
  0xBF, 0x40, 0x00, 0x00, 0x00, 0x2F, 0xF0,
  0x5F, 0xA0, 0x00, 0x00, 0x00, 0x7F, 0xF0,
  0x0C, 0xF4, 0x00, 0x00, 0x02, 0xDF, 0xF0,
  0x02, 0xDF, 0x72, 0x01, 0x6D, 0x5F, 0xF0,
  0x00, 0x17, 0xCF, 0xFD, 0x92, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0065[ 84] = { /* code 0065, LATIN SMALL LETTER E */
  0x00, 0x17, 0xCF, 0xFC, 0x81, 0x00,
  0x02, 0xDE, 0x71, 0x05, 0xED, 0x20,
  0x0C, 0xF5, 0x00, 0x00, 0x3F, 0xC0,
  0x5F, 0xB0, 0x00, 0x00, 0x0A, 0xF4,
  0xBF, 0x60, 0x00, 0x00, 0x05, 0xFA,
  0xEF, 0x30, 0x00, 0x00, 0x02, 0xFD,
  0xFF, 0x10, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xEF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xBF, 0x20, 0x00, 0x00, 0x00, 0x00,
  0x6F, 0x70, 0x00, 0x00, 0x03, 0xFA,
  0x0D, 0xE1, 0x00, 0x00, 0x0B, 0xF3,
  0x02, 0xED, 0x51, 0x03, 0xBF, 0x70,
  0x00, 0x18, 0xCF, 0xFD, 0xA3, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0066[ 76] = { /* code 0066, LATIN SMALL LETTER F */
  0x00, 0x02, 0xAE, 0xFF,
  0x00, 0x0C, 0xF6, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x6F, 0xFF, 0xFF, 0xFF,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x0F, 0xF0, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0067[140] = { /* code 0067, LATIN SMALL LETTER G */
  0x00, 0x07, 0xCF, 0xFD, 0x92, 0x0F, 0xF0,
  0x01, 0xCE, 0x72, 0x01, 0x6D, 0x5F, 0xF0,
  0x0C, 0xF4, 0x00, 0x00, 0x02, 0xEF, 0xF0,
  0x5F, 0xA0, 0x00, 0x00, 0x00, 0x7F, 0xF0,
  0xAF, 0x40, 0x00, 0x00, 0x00, 0x2F, 0xF0,
  0xEF, 0x10, 0x00, 0x00, 0x00, 0x0E, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0D, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0D, 0xF0,
  0xEF, 0x10, 0x00, 0x00, 0x00, 0x0E, 0xF0,
  0xBF, 0x50, 0x00, 0x00, 0x00, 0x2F, 0xF0,
  0x5F, 0xA0, 0x00, 0x00, 0x00, 0x8F, 0xF0,
  0x0C, 0xF5, 0x00, 0x00, 0x03, 0xEF, 0xF0,
  0x01, 0xDF, 0x72, 0x01, 0x6D, 0x4F, 0xF0,
  0x00, 0x17, 0xCF, 0xFD, 0x92, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xE0,
  0xEF, 0x10, 0x00, 0x00, 0x00, 0x3F, 0xB0,
  0xBF, 0x40, 0x00, 0x00, 0x00, 0x8F, 0x60,
  0x3F, 0xC0, 0x00, 0x00, 0x03, 0xFC, 0x00,
  0x06, 0xFB, 0x30, 0x03, 0x8F, 0xC2, 0x00,
  0x00, 0x39, 0xDF, 0xFE, 0xB6, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0068[114] = { /* code 0068, LATIN SMALL LETTER H */
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x04, 0xBE, 0xFE, 0xA2, 0x00,
  0xFF, 0x7C, 0x30, 0x04, 0xEE, 0x30,
  0xFF, 0xD1, 0x00, 0x00, 0x6F, 0xB0,
  0xFF, 0x50, 0x00, 0x00, 0x2F, 0xE0,
  0xFF, 0x10, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0069[ 19] = { /* code 0069, LATIN SMALL LETTER I */
  0xFF,
  0xFF,
  0x00,
  0x00,
  0x00,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_006A[ 50] = { /* code 006A, LATIN SMALL LETTER J */
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x05, 0xFC,
  0xFF, 0xC3
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_006B[114] = { /* code 006B, LATIN SMALL LETTER K */
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x01, 0xDD, 0x10,
  0xFF, 0x00, 0x00, 0x1D, 0xD1, 0x00,
  0xFF, 0x00, 0x01, 0xDE, 0x20, 0x00,
  0xFF, 0x00, 0x1B, 0xE2, 0x00, 0x00,
  0xFF, 0x01, 0xBE, 0x20, 0x00, 0x00,
  0xFF, 0x0B, 0xFB, 0x00, 0x00, 0x00,
  0xFF, 0xAE, 0x8F, 0x50, 0x00, 0x00,
  0xFF, 0xE3, 0x0B, 0xE1, 0x00, 0x00,
  0xFF, 0x30, 0x02, 0xF9, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x7F, 0x30, 0x00,
  0xFF, 0x00, 0x00, 0x0D, 0xC0, 0x00,
  0xFF, 0x00, 0x00, 0x04, 0xF7, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0xAE, 0x20,
  0xFF, 0x00, 0x00, 0x00, 0x1E, 0xA0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_006C[ 19] = { /* code 006C, LATIN SMALL LETTER L */
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_006D[126] = { /* code 006D, LATIN SMALL LETTER M */
  0xFD, 0x06, 0xCF, 0xFB, 0x40, 0x17, 0xDF, 0xFB, 0x50,
  0xFD, 0x8A, 0x20, 0x3D, 0xF4, 0xB9, 0x20, 0x2C, 0xF5,
  0xFF, 0xB0, 0x00, 0x04, 0xFE, 0xB0, 0x00, 0x03, 0xFB,
  0xFF, 0x40, 0x00, 0x01, 0xFF, 0x30, 0x00, 0x00, 0xFF,
  0xFF, 0x10, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_006E[ 84] = { /* code 006E, LATIN SMALL LETTER N */
  0xFD, 0x04, 0xBE, 0xFE, 0xA3, 0x00,
  0xFD, 0x8C, 0x30, 0x04, 0xEE, 0x30,
  0xFF, 0xC1, 0x00, 0x00, 0x6F, 0xB0,
  0xFF, 0x50, 0x00, 0x00, 0x2F, 0xE0,
  0xFF, 0x10, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_006F[ 98] = { /* code 006F, LATIN SMALL LETTER O */
  0x00, 0x07, 0xCE, 0xFE, 0xB6, 0x00, 0x00,
  0x01, 0xCE, 0x71, 0x01, 0x7E, 0xC1, 0x00,
  0x0C, 0xF4, 0x00, 0x00, 0x04, 0xFC, 0x00,
  0x5F, 0xA0, 0x00, 0x00, 0x00, 0xAF, 0x50,
  0xBF, 0x40, 0x00, 0x00, 0x00, 0x4F, 0xB0,
  0xEF, 0x10, 0x00, 0x00, 0x00, 0x1F, 0xE0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xEF, 0x10, 0x00, 0x00, 0x00, 0x1F, 0xE0,
  0xBF, 0x40, 0x00, 0x00, 0x00, 0x4F, 0xB0,
  0x5F, 0xA0, 0x00, 0x00, 0x00, 0xAF, 0x50,
  0x0C, 0xF4, 0x00, 0x00, 0x04, 0xFC, 0x00,
  0x01, 0xCE, 0x71, 0x01, 0x7E, 0xC1, 0x00,
  0x00, 0x07, 0xCE, 0xFE, 0xC7, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0070[140] = { /* code 0070, LATIN SMALL LETTER P */
  0xFF, 0x02, 0x9D, 0xFF, 0xC7, 0x10, 0x00,
  0xFF, 0x4D, 0x61, 0x02, 0x7E, 0xD1, 0x00,
  0xFF, 0xE3, 0x00, 0x00, 0x04, 0xFC, 0x00,
  0xFF, 0x80, 0x00, 0x00, 0x00, 0xAF, 0x50,
  0xFF, 0x30, 0x00, 0x00, 0x00, 0x4F, 0xB0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xE0,
  0xFD, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFD, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xE0,
  0xFF, 0x30, 0x00, 0x00, 0x00, 0x4F, 0xB0,
  0xFF, 0x80, 0x00, 0x00, 0x00, 0xAF, 0x50,
  0xFF, 0xE3, 0x00, 0x00, 0x04, 0xFC, 0x00,
  0xFF, 0x4E, 0x71, 0x02, 0x7E, 0xD1, 0x00,
  0xFF, 0x02, 0x9D, 0xFF, 0xC7, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0071[140] = { /* code 0071, LATIN SMALL LETTER Q */
  0x00, 0x17, 0xCF, 0xFD, 0xA2, 0x0F, 0xF0,
  0x01, 0xDE, 0x72, 0x01, 0x6D, 0x5F, 0xF0,
  0x0C, 0xF4, 0x00, 0x00, 0x02, 0xEF, 0xF0,
  0x5F, 0xA0, 0x00, 0x00, 0x00, 0x7F, 0xF0,
  0xBF, 0x40, 0x00, 0x00, 0x00, 0x2F, 0xF0,
  0xEF, 0x10, 0x00, 0x00, 0x00, 0x0E, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0D, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0D, 0xF0,
  0xEF, 0x10, 0x00, 0x00, 0x00, 0x0E, 0xF0,
  0xBF, 0x40, 0x00, 0x00, 0x00, 0x2F, 0xF0,
  0x5F, 0xA0, 0x00, 0x00, 0x00, 0x7F, 0xF0,
  0x0C, 0xF4, 0x00, 0x00, 0x02, 0xDF, 0xF0,
  0x01, 0xDF, 0x72, 0x01, 0x6D, 0x3F, 0xF0,
  0x00, 0x17, 0xCF, 0xFD, 0x92, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0072[ 42] = { /* code 0072, LATIN SMALL LETTER R */
  0xFD, 0x07, 0xDF,
  0xFD, 0xBB, 0x30,
  0xFF, 0xC0, 0x00,
  0xFF, 0x50, 0x00,
  0xFF, 0x20, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0073[ 84] = { /* code 0073, LATIN SMALL LETTER S */
  0x01, 0x7C, 0xFF, 0xEB, 0x60, 0x00,
  0x2D, 0xE5, 0x10, 0x28, 0xFB, 0x10,
  0xAF, 0x30, 0x00, 0x00, 0x7F, 0x90,
  0xFF, 0x00, 0x00, 0x00, 0x1F, 0xE0,
  0xEF, 0x60, 0x00, 0x00, 0x00, 0x00,
  0x9F, 0xF8, 0x10, 0x00, 0x00, 0x00,
  0x19, 0xFF, 0xFB, 0x84, 0x00, 0x00,
  0x00, 0x16, 0xAE, 0xFF, 0xE7, 0x00,
  0x00, 0x00, 0x00, 0x39, 0xFF, 0x80,
  0x00, 0x00, 0x00, 0x00, 0x6F, 0xE0,
  0xEF, 0x10, 0x00, 0x00, 0x0F, 0xF0,
  0x9F, 0x70, 0x00, 0x00, 0x4F, 0xB0,
  0x1C, 0xF8, 0x20, 0x16, 0xED, 0x20,
  0x00, 0x7C, 0xEF, 0xFC, 0x71, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0074[ 72] = { /* code 0074, LATIN SMALL LETTER T */
  0x00, 0xFF, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00,
  0x9F, 0xFF, 0xFF, 0xF0,
  0x00, 0xFF, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00,
  0x00, 0xEF, 0x30, 0x00,
  0x00, 0x6D, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0075[ 84] = { /* code 0075, LATIN SMALL LETTER U */
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x1F, 0xF0,
  0xEF, 0x10, 0x00, 0x00, 0x5F, 0xF0,
  0xAF, 0x60, 0x00, 0x01, 0xCF, 0xF0,
  0x3E, 0xE5, 0x00, 0x3C, 0x8F, 0xF0,
  0x03, 0xAE, 0xFE, 0xB4, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0076[ 84] = { /* code 0076, LATIN SMALL LETTER V */
  0xCD, 0x00, 0x00, 0x00, 0x00, 0xBC,
  0x7F, 0x30, 0x00, 0x00, 0x02, 0xF7,
  0x2F, 0x80, 0x00, 0x00, 0x07, 0xF2,
  0x0B, 0xE0, 0x00, 0x00, 0x0D, 0xB0,
  0x06, 0xF5, 0x00, 0x00, 0x3F, 0x60,
  0x01, 0xFA, 0x00, 0x00, 0x9F, 0x10,
  0x00, 0xAF, 0x10, 0x00, 0xEA, 0x00,
  0x00, 0x5F, 0x60, 0x05, 0xF5, 0x00,
  0x00, 0x0E, 0xB0, 0x0A, 0xE0, 0x00,
  0x00, 0x09, 0xF2, 0x1F, 0x90, 0x00,
  0x00, 0x04, 0xF7, 0x6F, 0x40, 0x00,
  0x00, 0x00, 0xDD, 0xBD, 0x00, 0x00,
  0x00, 0x00, 0x8F, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xF3, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0077[140] = { /* code 0077, LATIN SMALL LETTER W */
  0xDA, 0x00, 0x00, 0x02, 0xFF, 0x30, 0x00, 0x00, 0x0A, 0xD0,
  0x9E, 0x00, 0x00, 0x06, 0xFF, 0x80, 0x00, 0x00, 0x0E, 0x90,
  0x4F, 0x40, 0x00, 0x09, 0xDE, 0xD0, 0x00, 0x00, 0x3F, 0x40,
  0x0F, 0x80, 0x00, 0x0E, 0x9A, 0xF3, 0x00, 0x00, 0x8F, 0x00,
  0x0B, 0xD0, 0x00, 0x2F, 0x65, 0xF8, 0x00, 0x00, 0xDB, 0x00,
  0x06, 0xF2, 0x00, 0x6F, 0x20, 0xED, 0x00, 0x02, 0xF6, 0x00,
  0x02, 0xF7, 0x00, 0xAD, 0x00, 0x9F, 0x30, 0x06, 0xF2, 0x00,
  0x00, 0xDB, 0x00, 0xE9, 0x00, 0x4F, 0x90, 0x0B, 0xD0, 0x00,
  0x00, 0x9F, 0x12, 0xF6, 0x00, 0x0D, 0xE0, 0x1F, 0x90, 0x00,
  0x00, 0x4F, 0x56, 0xF2, 0x00, 0x08, 0xF4, 0x5F, 0x40, 0x00,
  0x00, 0x0F, 0xAA, 0xD0, 0x00, 0x03, 0xF9, 0x9F, 0x00, 0x00,
  0x00, 0x0B, 0xEE, 0x90, 0x00, 0x00, 0xDE, 0xEB, 0x00, 0x00,
  0x00, 0x06, 0xFF, 0x60, 0x00, 0x00, 0x8F, 0xF6, 0x00, 0x00,
  0x00, 0x02, 0xFF, 0x20, 0x00, 0x00, 0x3F, 0xF2, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0078[ 84] = { /* code 0078, LATIN SMALL LETTER X */
  0xAF, 0x40, 0x00, 0x00, 0x3F, 0xA0,
  0x1E, 0xD1, 0x00, 0x00, 0xDE, 0x10,
  0x05, 0xF9, 0x00, 0x07, 0xF5, 0x00,
  0x00, 0xAF, 0x30, 0x2F, 0xB0, 0x00,
  0x00, 0x1D, 0xD0, 0xBE, 0x20, 0x00,
  0x00, 0x04, 0xFC, 0xF6, 0x00, 0x00,
  0x00, 0x00, 0xAF, 0xB0, 0x00, 0x00,
  0x00, 0x00, 0xCF, 0xE2, 0x00, 0x00,
  0x00, 0x07, 0xF7, 0xEC, 0x00, 0x00,
  0x00, 0x2F, 0xA0, 0x6F, 0x90, 0x00,
  0x00, 0xBE, 0x20, 0x0A, 0xF5, 0x00,
  0x06, 0xF6, 0x00, 0x01, 0xDE, 0x20,
  0x2E, 0xC0, 0x00, 0x00, 0x3F, 0xC1,
  0xAF, 0x20, 0x00, 0x00, 0x08, 0xF9
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_0079[120] = { /* code 0079, LATIN SMALL LETTER Y */
  0xCA, 0x00, 0x00, 0x00, 0x00, 0xDC,
  0x7F, 0x10, 0x00, 0x00, 0x03, 0xF7,
  0x2F, 0x60, 0x00, 0x00, 0x09, 0xF2,
  0x0B, 0xB0, 0x00, 0x00, 0x0E, 0xB0,
  0x06, 0xF2, 0x00, 0x00, 0x5F, 0x60,
  0x01, 0xF8, 0x00, 0x00, 0xAF, 0x10,
  0x00, 0xAD, 0x00, 0x01, 0xFA, 0x00,
  0x00, 0x5F, 0x40, 0x06, 0xF5, 0x00,
  0x00, 0x0E, 0xA0, 0x0C, 0xE0, 0x00,
  0x00, 0x09, 0xF1, 0x2F, 0xA0, 0x00,
  0x00, 0x04, 0xF6, 0x8F, 0x40, 0x00,
  0x00, 0x00, 0xDC, 0xDE, 0x00, 0x00,
  0x00, 0x00, 0x8F, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xF3, 0x00, 0x00,
  0x00, 0x00, 0x0E, 0xD0, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x8F, 0x20, 0x00, 0x00,
  0x00, 0x00, 0xEC, 0x00, 0x00, 0x00,
  0x01, 0x19, 0xF4, 0x00, 0x00, 0x00,
  0x0F, 0xFC, 0x40, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_007A[ 84] = { /* code 007A, LATIN SMALL LETTER Z */
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x90,
  0x00, 0x00, 0x00, 0x00, 0xAF, 0x80,
  0x00, 0x00, 0x00, 0x06, 0xFC, 0x10,
  0x00, 0x00, 0x00, 0x3F, 0xE3, 0x00,
  0x00, 0x00, 0x01, 0xDF, 0x60, 0x00,
  0x00, 0x00, 0x0A, 0xF9, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0xC1, 0x00, 0x00,
  0x00, 0x03, 0xFE, 0x30, 0x00, 0x00,
  0x00, 0x1D, 0xF6, 0x00, 0x00, 0x00,
  0x00, 0xAF, 0x90, 0x00, 0x00, 0x00,
  0x06, 0xFC, 0x10, 0x00, 0x00, 0x00,
  0x3F, 0xE3, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0x60, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_007B[125] = { /* code 007B, LEFT CURLY BRACKET */
  0x00, 0x00, 0x06, 0xCF, 0xF0,
  0x00, 0x00, 0x6D, 0x31, 0x00,
  0x00, 0x00, 0xC4, 0x00, 0x00,
  0x00, 0x00, 0xE1, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x01, 0xE0, 0x00, 0x00,
  0x00, 0x06, 0xB0, 0x00, 0x00,
  0x01, 0x5E, 0x40, 0x00, 0x00,
  0xFF, 0xF5, 0x00, 0x00, 0x00,
  0x01, 0x5E, 0x40, 0x00, 0x00,
  0x00, 0x06, 0xB0, 0x00, 0x00,
  0x00, 0x01, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xE1, 0x00, 0x00,
  0x00, 0x00, 0xC5, 0x00, 0x00,
  0x00, 0x00, 0x6D, 0x41, 0x00,
  0x00, 0x00, 0x06, 0xCF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_007C[ 27] = { /* code 007C, VERTICAL LINE */
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_007D[125] = { /* code 007D, RIGHT CURLY BRACKET */
  0xFF, 0xC6, 0x00, 0x00, 0x00,
  0x01, 0x3D, 0x60, 0x00, 0x00,
  0x00, 0x04, 0xC0, 0x00, 0x00,
  0x00, 0x01, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xE1, 0x00, 0x00,
  0x00, 0x00, 0xB6, 0x00, 0x00,
  0x00, 0x00, 0x4E, 0x51, 0x00,
  0x00, 0x00, 0x05, 0xFF, 0xF0,
  0x00, 0x00, 0x4E, 0x51, 0x00,
  0x00, 0x00, 0xB6, 0x00, 0x00,
  0x00, 0x00, 0xE1, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x01, 0xE0, 0x00, 0x00,
  0x00, 0x05, 0xC0, 0x00, 0x00,
  0x01, 0x4D, 0x60, 0x00, 0x00,
  0xFF, 0xC6, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_007E[ 45] = { /* code 007E, TILDE */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x00, 0x6B, 0xFF, 0xC8, 0x30, 0x00, 0x00, 0x00, 0x3D,
  0x4D, 0xB5, 0x10, 0x37, 0xCC, 0x73, 0x01, 0x4A, 0xD4,
  0xD5, 0x00, 0x00, 0x00, 0x03, 0x8C, 0xFE, 0xB6, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/* Start of unicode area <Latin-1 Supplement> */
GUI_CONST_STORAGE unsigned char acGUI_Font32SL_AA4_00B0[ 28] = { /* code 00B0, DEGREE SIGN */
  0x05, 0xDF, 0xD5, 0x00,
  0x5D, 0x30, 0x3D, 0x50,
  0xD3, 0x00, 0x03, 0xD0,
  0xF0, 0x00, 0x00, 0xF0,
  0xD3, 0x00, 0x03, 0xD0,
  0x6D, 0x30, 0x3D, 0x50,
  0x06, 0xDF, 0xD5, 0x00
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_Font32SL_AA4_CharInfo[96] = {
   {   1,   1,   0,  26,   7, acGUI_Font32SL_AA4_0020 } /* code 0020, SPACE */
  ,{   2,  19,   3,   7,   8, acGUI_Font32SL_AA4_0021 } /* code 0021, EXCLAMATION MARK */
  ,{   4,   7,   1,   7,   7, acGUI_Font32SL_AA4_0022 } /* code 0022, QUOTATION MARK */
  ,{  17,  19,   2,   7,  21, acGUI_Font32SL_AA4_0023 } /* code 0023, NUMBER SIGN */
  ,{  13,  22,   1,   6,  14, acGUI_Font32SL_AA4_0024 } /* code 0024, DOLLAR SIGN */
  ,{  20,  20,   1,   7,  22, acGUI_Font32SL_AA4_0025 } /* code 0025, PERCENT SIGN */
  ,{  16,  19,   1,   7,  18, acGUI_Font32SL_AA4_0026 } /* code 0026, AMPERSAND */
  ,{   1,   7,   1,   7,   4, acGUI_Font32SL_AA4_0027 } /* code 0027, APOSTROPHE */
  ,{   6,  25,   3,   7,   8, acGUI_Font32SL_AA4_0028 } /* code 0028, LEFT PARENTHESIS */
  ,{   6,  25,   0,   7,   8, acGUI_Font32SL_AA4_0029 } /* code 0029, RIGHT PARENTHESIS */
  ,{   9,   9,   2,   7,  13, acGUI_Font32SL_AA4_002A } /* code 002A, ASTERISK */
  ,{  15,  15,   4,  11,  22, acGUI_Font32SL_AA4_002B } /* code 002B, PLUS SIGN */
  ,{   2,   6,   3,  24,   7, acGUI_Font32SL_AA4_002C } /* code 002C, COMMA */
  ,{   7,   2,   1,  18,   9, acGUI_Font32SL_AA4_002D } /* code 002D, HYPHEN-MINUS */
  ,{   2,   2,   3,  24,   7, acGUI_Font32SL_AA4_002E } /* code 002E, FULL STOP */
  ,{   9,  22,   0,   7,   8, acGUI_Font32SL_AA4_002F } /* code 002F, SOLIDUS */
  ,{  12,  18,   1,   8,  14, acGUI_Font32SL_AA4_0030 } /* code 0030, DIGIT ZERO */
  ,{   7,  18,   2,   8,  14, acGUI_Font32SL_AA4_0031 } /* code 0031, DIGIT ONE */
  ,{  12,  18,   1,   8,  14, acGUI_Font32SL_AA4_0032 } /* code 0032, DIGIT TWO */
  ,{  12,  18,   1,   8,  14, acGUI_Font32SL_AA4_0033 } /* code 0033, DIGIT THREE */
  ,{  13,  18,   1,   8,  14, acGUI_Font32SL_AA4_0034 } /* code 0034, DIGIT FOUR */
  ,{  12,  18,   1,   8,  14, acGUI_Font32SL_AA4_0035 } /* code 0035, DIGIT FIVE */
  ,{  12,  18,   1,   8,  14, acGUI_Font32SL_AA4_0036 } /* code 0036, DIGIT SIX */
  ,{  12,  18,   2,   8,  14, acGUI_Font32SL_AA4_0037 } /* code 0037, DIGIT SEVEN */
  ,{  12,  18,   1,   8,  14, acGUI_Font32SL_AA4_0038 } /* code 0038, DIGIT EIGHT */
  ,{  12,  18,   1,   8,  14, acGUI_Font32SL_AA4_0039 } /* code 0039, DIGIT NINE */
  ,{   2,  14,   3,  12,   8, acGUI_Font32SL_AA4_003A } /* code 003A, COLON */
  ,{   2,  18,   3,  12,   8, acGUI_Font32SL_AA4_003B } /* code 003B, SEMICOLON */
  ,{  16,  14,   3,  11,  22, acGUI_Font32SL_AA4_003C } /* code 003C, LESS-THAN SIGN */
  ,{  16,   6,   3,  15,  22, acGUI_Font32SL_AA4_003D } /* code 003D, EQUALS SIGN */
  ,{  16,  14,   3,  11,  22, acGUI_Font32SL_AA4_003E } /* code 003E, GREATER-THAN SIGN */
  ,{  12,  19,   1,   7,  13, acGUI_Font32SL_AA4_003F } /* code 003F, QUESTION MARK */
  ,{  24,  23,   2,   7,  27, acGUI_Font32SL_AA4_0040 } /* code 0040, COMMERCIAL AT */
  ,{  17,  19,   0,   7,  16, acGUI_Font32SL_AA4_0041 } /* code 0041, LATIN CAPITAL LETTER A */
  ,{  14,  19,   2,   7,  17, acGUI_Font32SL_AA4_0042 } /* code 0042, LATIN CAPITAL LETTER B */
  ,{  16,  19,   1,   7,  19, acGUI_Font32SL_AA4_0043 } /* code 0043, LATIN CAPITAL LETTER C */
  ,{  15,  19,   2,   7,  19, acGUI_Font32SL_AA4_0044 } /* code 0044, LATIN CAPITAL LETTER D */
  ,{  13,  19,   2,   7,  16, acGUI_Font32SL_AA4_0045 } /* code 0045, LATIN CAPITAL LETTER E */
  ,{  12,  19,   2,   7,  15, acGUI_Font32SL_AA4_0046 } /* code 0046, LATIN CAPITAL LETTER F */
  ,{  17,  19,   1,   7,  20, acGUI_Font32SL_AA4_0047 } /* code 0047, LATIN CAPITAL LETTER G */
  ,{  15,  19,   2,   7,  19, acGUI_Font32SL_AA4_0048 } /* code 0048, LATIN CAPITAL LETTER H */
  ,{   2,  19,   2,   7,   6, acGUI_Font32SL_AA4_0049 } /* code 0049, LATIN CAPITAL LETTER I */
  ,{  10,  19,   1,   7,  13, acGUI_Font32SL_AA4_004A } /* code 004A, LATIN CAPITAL LETTER J */
  ,{  15,  19,   2,   7,  17, acGUI_Font32SL_AA4_004B } /* code 004B, LATIN CAPITAL LETTER K */
  ,{  12,  19,   2,   7,  14, acGUI_Font32SL_AA4_004C } /* code 004C, LATIN CAPITAL LETTER L */
  ,{  18,  19,   2,   7,  22, acGUI_Font32SL_AA4_004D } /* code 004D, LATIN CAPITAL LETTER M */
  ,{  15,  19,   2,   7,  19, acGUI_Font32SL_AA4_004E } /* code 004E, LATIN CAPITAL LETTER N */
  ,{  18,  19,   1,   7,  20, acGUI_Font32SL_AA4_004F } /* code 004F, LATIN CAPITAL LETTER O */
  ,{  13,  19,   2,   7,  16, acGUI_Font32SL_AA4_0050 } /* code 0050, LATIN CAPITAL LETTER P */
  ,{  18,  20,   1,   7,  20, acGUI_Font32SL_AA4_0051 } /* code 0051, LATIN CAPITAL LETTER Q */
  ,{  14,  19,   2,   7,  17, acGUI_Font32SL_AA4_0052 } /* code 0052, LATIN CAPITAL LETTER R */
  ,{  13,  19,   2,   7,  16, acGUI_Font32SL_AA4_0053 } /* code 0053, LATIN CAPITAL LETTER S */
  ,{  14,  19,   0,   7,  14, acGUI_Font32SL_AA4_0054 } /* code 0054, LATIN CAPITAL LETTER T */
  ,{  15,  19,   2,   7,  19, acGUI_Font32SL_AA4_0055 } /* code 0055, LATIN CAPITAL LETTER U */
  ,{  16,  19,   0,   7,  15, acGUI_Font32SL_AA4_0056 } /* code 0056, LATIN CAPITAL LETTER V */
  ,{  23,  19,   0,   7,  23, acGUI_Font32SL_AA4_0057 } /* code 0057, LATIN CAPITAL LETTER W */
  ,{  15,  19,   0,   7,  16, acGUI_Font32SL_AA4_0058 } /* code 0058, LATIN CAPITAL LETTER X */
  ,{  16,  19,   0,   7,  15, acGUI_Font32SL_AA4_0059 } /* code 0059, LATIN CAPITAL LETTER Y */
  ,{  14,  19,   1,   7,  15, acGUI_Font32SL_AA4_005A } /* code 005A, LATIN CAPITAL LETTER Z */
  ,{   5,  25,   3,   7,   9, acGUI_Font32SL_AA4_005B } /* code 005B, LEFT SQUARE BRACKET */
  ,{   9,  22,   0,   7,   8, acGUI_Font32SL_AA4_005C } /* code 005C, REVERSE SOLIDUS */
  ,{   5,  25,   1,   7,   9, acGUI_Font32SL_AA4_005D } /* code 005D, RIGHT SQUARE BRACKET */
  ,{  16,   7,   6,   7,  27, acGUI_Font32SL_AA4_005E } /* code 005E, CIRCUMFLEX ACCENT */
  ,{  14,   1,   0,  31,  13, acGUI_Font32SL_AA4_005F } /* code 005F, LOW LINE */
  ,{   5,   5,   4,   5,  13, acGUI_Font32SL_AA4_0060 } /* code 0060, GRAVE ACCENT */
  ,{  13,  14,   1,  12,  14, acGUI_Font32SL_AA4_0061 } /* code 0061, LATIN SMALL LETTER A */
  ,{  13,  19,   2,   7,  15, acGUI_Font32SL_AA4_0062 } /* code 0062, LATIN SMALL LETTER B */
  ,{  12,  14,   1,  12,  14, acGUI_Font32SL_AA4_0063 } /* code 0063, LATIN SMALL LETTER C */
  ,{  13,  19,   1,   7,  16, acGUI_Font32SL_AA4_0064 } /* code 0064, LATIN SMALL LETTER D */
  ,{  12,  14,   1,  12,  14, acGUI_Font32SL_AA4_0065 } /* code 0065, LATIN SMALL LETTER E */
  ,{   8,  19,   0,   7,   7, acGUI_Font32SL_AA4_0066 } /* code 0066, LATIN SMALL LETTER F */
  ,{  13,  20,   1,  12,  15, acGUI_Font32SL_AA4_0067 } /* code 0067, LATIN SMALL LETTER G */
  ,{  11,  19,   2,   7,  14, acGUI_Font32SL_AA4_0068 } /* code 0068, LATIN SMALL LETTER H */
  ,{   2,  19,   2,   7,   5, acGUI_Font32SL_AA4_0069 } /* code 0069, LATIN SMALL LETTER I */
  ,{   4,  25,   0,   7,   6, acGUI_Font32SL_AA4_006A } /* code 006A, LATIN SMALL LETTER J */
  ,{  11,  19,   2,   7,  13, acGUI_Font32SL_AA4_006B } /* code 006B, LATIN SMALL LETTER K */
  ,{   2,  19,   2,   7,   5, acGUI_Font32SL_AA4_006C } /* code 006C, LATIN SMALL LETTER L */
  ,{  18,  14,   2,  12,  22, acGUI_Font32SL_AA4_006D } /* code 006D, LATIN SMALL LETTER M */
  ,{  11,  14,   2,  12,  14, acGUI_Font32SL_AA4_006E } /* code 006E, LATIN SMALL LETTER N */
  ,{  13,  14,   1,  12,  15, acGUI_Font32SL_AA4_006F } /* code 006F, LATIN SMALL LETTER O */
  ,{  13,  20,   2,  12,  15, acGUI_Font32SL_AA4_0070 } /* code 0070, LATIN SMALL LETTER P */
  ,{  13,  20,   1,  12,  16, acGUI_Font32SL_AA4_0071 } /* code 0071, LATIN SMALL LETTER Q */
  ,{   6,  14,   2,  12,   8, acGUI_Font32SL_AA4_0072 } /* code 0072, LATIN SMALL LETTER R */
  ,{  11,  14,   2,  12,  13, acGUI_Font32SL_AA4_0073 } /* code 0073, LATIN SMALL LETTER S */
  ,{   7,  18,   0,   8,   7, acGUI_Font32SL_AA4_0074 } /* code 0074, LATIN SMALL LETTER T */
  ,{  11,  14,   2,  12,  14, acGUI_Font32SL_AA4_0075 } /* code 0075, LATIN SMALL LETTER U */
  ,{  12,  14,   0,  12,  12, acGUI_Font32SL_AA4_0076 } /* code 0076, LATIN SMALL LETTER V */
  ,{  19,  14,   0,  12,  18, acGUI_Font32SL_AA4_0077 } /* code 0077, LATIN SMALL LETTER W */
  ,{  12,  14,   0,  12,  12, acGUI_Font32SL_AA4_0078 } /* code 0078, LATIN SMALL LETTER X */
  ,{  12,  20,   0,  12,  12, acGUI_Font32SL_AA4_0079 } /* code 0079, LATIN SMALL LETTER Y */
  ,{  11,  14,   1,  12,  12, acGUI_Font32SL_AA4_007A } /* code 007A, LATIN SMALL LETTER Z */
  ,{   9,  25,   2,   7,  13, acGUI_Font32SL_AA4_007B } /* code 007B, LEFT CURLY BRACKET */
  ,{   1,  27,   6,   5,  13, acGUI_Font32SL_AA4_007C } /* code 007C, VERTICAL LINE */
  ,{   9,  25,   2,   7,  13, acGUI_Font32SL_AA4_007D } /* code 007D, RIGHT CURLY BRACKET */
  ,{  18,   5,   2,  15,  22, acGUI_Font32SL_AA4_007E } /* code 007E, TILDE */
  ,{   7,   7,   1,   7,   9, acGUI_Font32SL_AA4_00B0 } /* code 00B0, DEGREE SIGN */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font32SL_AA4_Prop2 = {
   0x00B0 /* first character */
  ,0x00B0 /* last character  */
  ,&GUI_Font32SL_AA4_CharInfo[ 95] /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font32SL_AA4_Prop1 = {
   0x0020 /* first character */
  ,0x007E /* last character  */
  ,&GUI_Font32SL_AA4_CharInfo[  0] /* address of first character */
  ,&GUI_Font32SL_AA4_Prop2 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT GUI_Font32SL_AA4 = {
   GUI_FONTTYPE_PROP_AA4_EXT /* type of font    */
  ,32 /* height of font  */
  ,32 /* space of font y */
  ,1 /* magnification x */
  ,1 /* magnification y */
  ,{&GUI_Font32SL_AA4_Prop1}
  ,26 /* Baseline */
  ,14 /* Height of lowercase characters */
  ,19 /* Height of capital characters */
};

