/*********************************************************************
*                SEGGER Microcontroller GmbH                         *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2018  SEGGER Microcontroller GmbH                *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.48 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software  has been licensed to  Cypress Semiconductor Corporation,
whose registered  office is situated  at 198 Champion Ct. San Jose, CA 
95134 USA  solely for the  purposes of creating  libraries for Cypress
PSoC3 and  PSoC5 processor-based devices,  sublicensed and distributed
under  the  terms  and  conditions  of  the  Cypress  End User License
Agreement.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information
Licensor:                 SEGGER Microcontroller Systems LLC
Licensed to:              Cypress Semiconductor Corp, 198 Champion Ct., San Jose, CA 95134, USA
Licensed SEGGER software: emWin
License number:           GUI-00319
License model:            Services and License Agreement, signed June 10th, 2009
Licensed platform:        Any Cypress platform (Initial targets are: PSoC3, PSoC5)
----------------------------------------------------------------------
Support and Update Agreement (SUA)
SUA period:               2009-06-12 - 2022-07-27
Contact to extend SUA:    sales@segger.com
----------------------------------------------------------------------
File        : bmpartly_cloudy_day40x40.h
Content     : Bitmap 40 * 40
---------------------------END-OF-HEADER------------------------------
*/

#include <stdlib.h>

#include "GUI.h"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

extern GUI_CONST_STORAGE GUI_BITMAP bmpartly_cloudy_day40x40;

#if (GUI_USE_ARGB)

static GUI_CONST_STORAGE unsigned long _acbmpartly_cloudy_day40x40[] = {
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x07306DB5, 0x3A306DB5, 0x2F306DB5, 0x04306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
        0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x08306DB5, 0x01306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x26306DB5, 0xD6306DB5, 0xA5306DB5, 0x15306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x02306DB5, 0x05306DB5,
        0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x1D306DB5, 0x8A306DB5, 0x55306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x2D306DB5, 0xEC306DB5, 0xB2306DB5, 0x19306DB5, 0x00306DB5, 0x00306DB5, 0x08306DB5, 0x70306DB5, 0x7A306DB5,
        0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x3B306DB5, 0xDF306DB5, 0xCA306DB5, 0x22306DB5, 0x00306DB5, 0x00306DB5, 0x2D306DB5, 0xEC306DB5, 0xB2306DB5, 0x19306DB5, 0x00306DB5, 0x00306DB5, 0x4D306DB5, 0xE1306DB5, 0xC8306DB5,
        0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x0D306DB5, 0x8B306DB5, 0xF4306DB5, 0x87306DB5, 0x0F306DB5, 0x00306DB5, 0x29306DB5, 0xE2306DB5, 0xB2306DB5, 0x19306DB5, 0x00306DB5, 0x24306DB5, 0xB4306DB5, 0xF4306DB5, 0x5F306DB5,
        0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x2D306DB5, 0xE8306DB5, 0xDA306DB5, 0x45306DB5, 0x01306DB5, 0x29306DB5, 0xDF306DB5, 0xB0306DB5, 0x19306DB5, 0x06306DB5, 0x62306DB5, 0xE9306DB5, 0xB7306DB5, 0x15306DB5,
        0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x00306DB5, 0x00306DB5, 0x1E306DB5, 0x3C306DB5, 0x02306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x80306DB5, 0xFB306DB5, 0xA5306DB5, 0x6E306DB5, 0xA4306DB5, 0xF1306DB5, 0xDF306DB5, 0x8F306DB5, 0x6A306DB5, 0xC5306DB5, 0xEE306DB5, 0x51306DB5, 0x00306DB5,
        0x00306DB5, 0x00306DB5, 0x0B306DB5, 0x40306DB5, 0x14306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x00306DB5, 0x08306DB5, 0x8C306DB5, 0xE0306DB5, 0x99306DB5, 0x22306DB5, 0x00306DB5, 0x00306DB5, 0x2A306DB5, 0xD0306DB5, 0xF5306DB5, 0xF0306DB5, 0xFD306DB5, 0xFF306DB5, 0xFF306DB5, 0xF9306DB5, 0xED306DB5, 0xFA306DB5, 0xA1306DB5, 0x14306DB5, 0x00306DB5,
        0x02306DB5, 0x3C306DB5, 0xB2306DB5, 0xDC306DB5, 0x70306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x00306DB5, 0x00306DB5, 0x52306DB5, 0xCA306DB5, 0xF9306DB5, 0xE8306DB5, 0x80306DB5, 0x29306DB5, 0x90306DB5, 0xFD306DB5, 0xFF306DB5, 0xFF306DB5, 0xF9306DB5, 0xEE306DB5, 0xEE306DB5, 0xFB306DB5, 0xFF306DB5, 0xFF306DB5, 0xEC306DB5, 0x5E306DB5, 0x36306DB5,
        0xA1306DB5, 0xF4306DB5, 0xF1306DB5, 0xB5306DB5, 0x34306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x23306DB5, 0x8F306DB5, 0xD7306DB5, 0xFB306DB5, 0xCE306DB5, 0xFD306DB5, 0xFF306DB5, 0xFC306DB5, 0xCD306DB5, 0x86306DB5, 0x67306DB5, 0x67306DB5, 0x91306DB5, 0xDE306DB5, 0xFF306DB5, 0xFF306DB5, 0xEC306DB5, 0xDF306DB5,
        0xF5306DB5, 0xC6306DB5, 0x73306DB5, 0x11306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x0A306DB5, 0x42306DB5, 0xA4306DB5, 0xF5306DB5, 0xFF306DB5, 0xFC306DB5, 0xAC306DB5, 0x38306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x05306DB5, 0x56306DB5, 0xD7306DB5, 0xF1306DB5, 0xA3306DB5, 0x88306DB5,
        0x78306DB5, 0x2D306DB5, 0x0A306DB5, 0x21306DB5, 0x3B306DB5, 0x45306DB5, 0x3A306DB5, 0x11306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x01306DB5, 0x6E306DB5, 0xF0306DB5, 0xFF306DB5, 0xCC306DB5, 0x38306DB5, 0x02306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x06306DB5, 0x3E306DB5, 0x49306DB5, 0x15306DB5, 0x0B306DB5,
        0x14306DB5, 0x50306DB5, 0xB4306DB5, 0xD7306DB5, 0xE0306DB5, 0xE3306DB5, 0xDF306DB5, 0xCA306DB5, 0x7E306DB5, 0x1B306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x07306DB5, 0x26306DB5, 0x2D306DB5, 0x2D306DB5, 0x2D306DB5, 0x2C306DB5, 0xA4306DB5, 0xFD306DB5, 0xF9306DB5, 0x86306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x02306DB5, 0x40306DB5,
        0xC6306DB5, 0xFD306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xD7306DB5, 0x5E306DB5, 0x0D306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x32306DB5, 0xD9306DB5, 0xEC306DB5, 0xEC306DB5, 0xEC306DB5, 0xE6306DB5, 0xF2306DB5, 0xFF306DB5, 0xEE306DB5, 0x65306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x01306DB5, 0x44306DB5, 0xDA306DB5,
        0xFF306DB5, 0xFF306DB5, 0xFE306DB5, 0xDB306DB5, 0xC8306DB5, 0xC4306DB5, 0xDA306DB5, 0xF6306DB5, 0xFF306DB5, 0xFF306DB5, 0xF7306DB5, 0x79306DB5, 0x0C306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x27306DB5, 0xA3306DB5, 0xB2306DB5, 0xB2306DB5, 0xB2306DB5, 0xB2306DB5, 0xE0306DB5, 0xFF306DB5, 0xEF306DB5, 0x67306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x2D306DB5, 0xC7306DB5, 0xFF306DB5,
        0xFF306DB5, 0xDF306DB5, 0x8A306DB5, 0x42306DB5, 0x2F306DB5, 0x2B306DB5, 0x41306DB5, 0x6D306DB5, 0xCB306DB5, 0xFD306DB5, 0xFF306DB5, 0xE8306DB5, 0x5D306DB5, 0x03306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x03306DB5, 0x14306DB5, 0x19306DB5, 0x19306DB5, 0x19306DB5, 0x19306DB5, 0x94306DB5, 0xFA306DB5, 0xFA306DB5, 0x8E306DB5, 0x05306DB5, 0x00306DB5, 0x00306DB5, 0x02306DB5, 0x1E306DB5, 0x52306DB5, 0x7F306DB5, 0x81306DB5, 0xB4306DB5, 0xF9306DB5, 0xFF306DB5,
        0xDB306DB5, 0x56306DB5, 0x0C306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x05306DB5, 0x2E306DB5, 0xA8306DB5, 0xF9306DB5, 0xFE306DB5, 0xCB306DB5, 0x37306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x06306DB5, 0x6C306DB5, 0xEE306DB5, 0xF5306DB5, 0x9F306DB5, 0x1B306DB5, 0x01306DB5, 0x31306DB5, 0x9A306DB5, 0xF2306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xE3306DB5,
        0x4D306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x1B306DB5, 0xC0306DB5, 0xFF306DB5, 0xFF306DB5, 0x8B306DB5, 0x0D306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x1D306DB5, 0x67306DB5, 0xC5306DB5, 0xE6306DB5, 0x80306DB5, 0x1C306DB5, 0x00306DB5, 0x39306DB5, 0xD9306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0x9E306DB5,
        0x07306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x4A306DB5, 0xFF306DB5, 0xFF306DB5, 0xC9306DB5, 0x21306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x00306DB5, 0x00306DB5, 0x08306DB5, 0x4D306DB5, 0xB4306DB5, 0xEF306DB5, 0xEE306DB5, 0x78306DB5, 0x06306DB5, 0x00306DB5, 0x2E306DB5, 0xBF306DB5, 0xFF306DB5, 0xFF306DB5, 0xEE306DB5, 0xB6306DB5, 0x8C306DB5, 0x8F306DB5, 0xB6306DB5, 0xE9306DB5, 0x3A306DB5,
        0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x08306DB5, 0xF2306DB5, 0xFF306DB5, 0xF0306DB5, 0x2E306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x00306DB5, 0x04306DB5, 0x72306DB5, 0xE1306DB5, 0xFB306DB5, 0xC5306DB5, 0x50306DB5, 0x0E306DB5, 0x00306DB5, 0x09306DB5, 0x91306DB5, 0xF9306DB5, 0xFF306DB5, 0xD7306DB5, 0x59306DB5, 0x1C306DB5, 0x0D306DB5, 0x0E306DB5, 0x1B306DB5, 0x2C306DB5, 0x06306DB5,
        0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0xC7306DB5, 0xFF306DB5, 0xFE306DB5, 0xAB306DB5, 0x1A306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x00306DB5, 0x02306DB5, 0x73306DB5, 0xC9306DB5, 0x5B306DB5, 0x08306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x38306DB5, 0xD1306DB5, 0xFF306DB5, 0xE4306DB5, 0x4E306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
        0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0xAD306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xE5306DB5, 0x5C306DB5, 0x09306DB5, 0x00306DB5,
  0x00306DB5, 0x00306DB5, 0x04306DB5, 0x0B306DB5, 0x00306DB5, 0x00306DB5, 0x15306DB5, 0x3A306DB5, 0x58306DB5, 0x9B306DB5, 0xF7306DB5, 0xFF306DB5, 0xAF306DB5, 0x06306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
        0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x5E306DB5, 0xAB306DB5, 0xDC306DB5, 0xFB306DB5, 0xFF306DB5, 0xDD306DB5, 0x56306DB5, 0x06306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x04306DB5, 0x35306DB5, 0x9C306DB5, 0xD3306DB5, 0xF1306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0x79306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
        0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x01306DB5, 0x14306DB5, 0x44306DB5, 0xB5306DB5, 0xFF306DB5, 0xFF306DB5, 0xC3306DB5, 0x1F306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x3C306DB5, 0xD6306DB5, 0xF9306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0x67306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
        0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x1E306DB5, 0xE1306DB5, 0xFF306DB5, 0xF9306DB5, 0x64306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x0E306DB5, 0xD4306DB5, 0xFF306DB5, 0xFF306DB5, 0xEA306DB5, 0xC9306DB5, 0xBB306DB5, 0xD3306DB5, 0xEA306DB5, 0x71306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
        0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x67306DB5, 0xFF306DB5, 0xFF306DB5, 0xBF306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x61306DB5, 0xFF306DB5, 0xFF306DB5, 0xDF306DB5, 0x65306DB5, 0x06306DB5, 0x01306DB5, 0x1C306DB5, 0x59306DB5, 0x49306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
        0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x34306DB5, 0xF7306DB5, 0xFF306DB5, 0xE4306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0xA4306DB5, 0xFF306DB5, 0xFD306DB5, 0x84306DB5, 0x0B306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
        0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x2F306DB5, 0xF3306DB5, 0xFF306DB5, 0xF1306DB5,
  0x00306DB5, 0x00306DB5, 0x08306DB5, 0xCA306DB5, 0xFF306DB5, 0xEF306DB5, 0x57306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
        0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x4F306DB5, 0xFE306DB5, 0xFF306DB5, 0xE0306DB5,
  0x00306DB5, 0x00306DB5, 0x05306DB5, 0xAD306DB5, 0xFF306DB5, 0xF3306DB5, 0x67306DB5, 0x05306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
        0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x0C306DB5, 0xB7306DB5, 0xFF306DB5, 0xFF306DB5, 0x93306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x83306DB5, 0xFF306DB5, 0xFF306DB5, 0xB9306DB5, 0x2D306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
        0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x01306DB5, 0x1F306DB5, 0x7F306DB5, 0xFF306DB5, 0xFF306DB5, 0xE2306DB5, 0x41306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x2F306DB5, 0xEF306DB5, 0xFF306DB5, 0xF9306DB5, 0xBC306DB5, 0x66306DB5, 0x4F306DB5, 0x4C306DB5, 0x4C306DB5, 0x4C306DB5, 0x4C306DB5, 0x4C306DB5, 0x4C306DB5, 0x4C306DB5, 0x4C306DB5, 0x4C306DB5, 0x4C306DB5, 0x4C306DB5,
        0x4C306DB5, 0x4C306DB5, 0x4C306DB5, 0x4C306DB5, 0x4C306DB5, 0x4C306DB5, 0x4C306DB5, 0x4C306DB5, 0x4C306DB5, 0x4C306DB5, 0x4C306DB5, 0x56306DB5, 0x79306DB5, 0xB3306DB5, 0xF3306DB5, 0xFF306DB5, 0xF5306DB5, 0x81306DB5, 0x0C306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x02306DB5, 0x7F306DB5, 0xFF306DB5, 0xFF306DB5, 0xFE306DB5, 0xEE306DB5, 0xE6306DB5, 0xE5306DB5, 0xE5306DB5, 0xE5306DB5, 0xE5306DB5, 0xE5306DB5, 0xE5306DB5, 0xE5306DB5, 0xE5306DB5, 0xE5306DB5, 0xE5306DB5, 0xE5306DB5,
        0xE5306DB5, 0xE5306DB5, 0xE5306DB5, 0xE5306DB5, 0xE5306DB5, 0xE5306DB5, 0xE5306DB5, 0xE5306DB5, 0xE5306DB5, 0xE5306DB5, 0xE5306DB5, 0xE9306DB5, 0xF4306DB5, 0xFD306DB5, 0xFF306DB5, 0xFA306DB5, 0xAD306DB5, 0x23306DB5, 0x00306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x0F306DB5, 0x6F306DB5, 0xCD306DB5, 0xF6306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5,
        0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xFF306DB5, 0xF8306DB5, 0xDE306DB5, 0x66306DB5, 0x16306DB5, 0x00306DB5, 0x00306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x04306DB5, 0x3A306DB5, 0x7D306DB5, 0xA5306DB5, 0xB3306DB5, 0xB3306DB5, 0xB3306DB5, 0xB3306DB5, 0xB3306DB5, 0xB3306DB5, 0xB3306DB5, 0xB3306DB5, 0xB3306DB5, 0xB3306DB5, 0xB3306DB5, 0xB3306DB5,
        0xB3306DB5, 0xB3306DB5, 0xB3306DB5, 0xB3306DB5, 0xB3306DB5, 0xB3306DB5, 0xB3306DB5, 0xB3306DB5, 0xB3306DB5, 0xB3306DB5, 0xB3306DB5, 0xB2306DB5, 0xAA306DB5, 0x87306DB5, 0x3C306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x0C306DB5, 0x1A306DB5, 0x1A306DB5, 0x1A306DB5, 0x1A306DB5, 0x1A306DB5, 0x1A306DB5, 0x1A306DB5, 0x1A306DB5, 0x1A306DB5, 0x1A306DB5, 0x1A306DB5, 0x1A306DB5,
        0x1A306DB5, 0x1A306DB5, 0x1A306DB5, 0x1A306DB5, 0x1A306DB5, 0x1A306DB5, 0x1A306DB5, 0x1A306DB5, 0x1A306DB5, 0x1A306DB5, 0x1A306DB5, 0x19306DB5, 0x11306DB5, 0x03306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
        0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
        0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
        0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
        0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
  0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5,
        0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5, 0x00306DB5
};

GUI_CONST_STORAGE GUI_BITMAP bmpartly_cloudy_day40x40 = {
  40, // xSize
  40, // ySize
  160, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acbmpartly_cloudy_day40x40,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_BMPM8888I
};

#else

static GUI_CONST_STORAGE unsigned long _acbmpartly_cloudy_day40x40[] = {
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xF8B56D30, 0xC5B56D30, 0xD0B56D30, 0xFBB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
        0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xF7B56D30, 0xFEB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xD9B56D30, 0x29B56D30, 0x5AB56D30, 0xEAB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFDB56D30, 0xFAB56D30,
        0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xE2B56D30, 0x75B56D30, 0xAAB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xD2B56D30, 0x13B56D30, 0x4DB56D30, 0xE6B56D30, 0xFFB56D30, 0xFFB56D30, 0xF7B56D30, 0x8FB56D30, 0x85B56D30,
        0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xC4B56D30, 0x20B56D30, 0x35B56D30, 0xDDB56D30, 0xFFB56D30, 0xFFB56D30, 0xD2B56D30, 0x13B56D30, 0x4DB56D30, 0xE6B56D30, 0xFFB56D30, 0xFFB56D30, 0xB2B56D30, 0x1EB56D30, 0x37B56D30,
        0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xF2B56D30, 0x74B56D30, 0x0BB56D30, 0x78B56D30, 0xF0B56D30, 0xFFB56D30, 0xD6B56D30, 0x1DB56D30, 0x4DB56D30, 0xE6B56D30, 0xFFB56D30, 0xDBB56D30, 0x4BB56D30, 0x0BB56D30, 0xA0B56D30,
        0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xD2B56D30, 0x17B56D30, 0x25B56D30, 0xBAB56D30, 0xFEB56D30, 0xD6B56D30, 0x20B56D30, 0x4FB56D30, 0xE6B56D30, 0xF9B56D30, 0x9DB56D30, 0x16B56D30, 0x48B56D30, 0xEAB56D30,
        0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xFFB56D30, 0xFFB56D30, 0xE1B56D30, 0xC3B56D30, 0xFDB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0x7FB56D30, 0x04B56D30, 0x5AB56D30, 0x91B56D30, 0x5BB56D30, 0x0EB56D30, 0x20B56D30, 0x70B56D30, 0x95B56D30, 0x3AB56D30, 0x11B56D30, 0xAEB56D30, 0xFFB56D30,
        0xFFB56D30, 0xFFB56D30, 0xF4B56D30, 0xBFB56D30, 0xEBB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xFFB56D30, 0xF7B56D30, 0x73B56D30, 0x1FB56D30, 0x66B56D30, 0xDDB56D30, 0xFFB56D30, 0xFFB56D30, 0xD5B56D30, 0x2FB56D30, 0x0AB56D30, 0x0FB56D30, 0x02B56D30, 0x00B56D30, 0x00B56D30, 0x06B56D30, 0x12B56D30, 0x05B56D30, 0x5EB56D30, 0xEBB56D30, 0xFFB56D30,
        0xFDB56D30, 0xC3B56D30, 0x4DB56D30, 0x23B56D30, 0x8FB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xFFB56D30, 0xFFB56D30, 0xADB56D30, 0x35B56D30, 0x06B56D30, 0x17B56D30, 0x7FB56D30, 0xD6B56D30, 0x6FB56D30, 0x02B56D30, 0x00B56D30, 0x00B56D30, 0x06B56D30, 0x11B56D30, 0x11B56D30, 0x04B56D30, 0x00B56D30, 0x00B56D30, 0x13B56D30, 0xA1B56D30, 0xC9B56D30,
        0x5EB56D30, 0x0BB56D30, 0x0EB56D30, 0x4AB56D30, 0xCBB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xDCB56D30, 0x70B56D30, 0x28B56D30, 0x04B56D30, 0x31B56D30, 0x02B56D30, 0x00B56D30, 0x03B56D30, 0x32B56D30, 0x79B56D30, 0x98B56D30, 0x98B56D30, 0x6EB56D30, 0x21B56D30, 0x00B56D30, 0x00B56D30, 0x13B56D30, 0x20B56D30,
        0x0AB56D30, 0x39B56D30, 0x8CB56D30, 0xEEB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xF5B56D30, 0xBDB56D30, 0x5BB56D30, 0x0AB56D30, 0x00B56D30, 0x03B56D30, 0x53B56D30, 0xC7B56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFAB56D30, 0xA9B56D30, 0x28B56D30, 0x0EB56D30, 0x5CB56D30, 0x77B56D30,
        0x87B56D30, 0xD2B56D30, 0xF5B56D30, 0xDEB56D30, 0xC4B56D30, 0xBAB56D30, 0xC5B56D30, 0xEEB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFEB56D30, 0x91B56D30, 0x0FB56D30, 0x00B56D30, 0x33B56D30, 0xC7B56D30, 0xFDB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xF9B56D30, 0xC1B56D30, 0xB6B56D30, 0xEAB56D30, 0xF4B56D30,
        0xEBB56D30, 0xAFB56D30, 0x4BB56D30, 0x28B56D30, 0x1FB56D30, 0x1CB56D30, 0x20B56D30, 0x35B56D30, 0x81B56D30, 0xE4B56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xF8B56D30, 0xD9B56D30, 0xD2B56D30, 0xD2B56D30, 0xD2B56D30, 0xD3B56D30, 0x5BB56D30, 0x02B56D30, 0x06B56D30, 0x79B56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFDB56D30, 0xBFB56D30,
        0x39B56D30, 0x02B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x28B56D30, 0xA1B56D30, 0xF2B56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xCDB56D30, 0x26B56D30, 0x13B56D30, 0x13B56D30, 0x13B56D30, 0x19B56D30, 0x0DB56D30, 0x00B56D30, 0x11B56D30, 0x9AB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFEB56D30, 0xBBB56D30, 0x25B56D30,
        0x00B56D30, 0x00B56D30, 0x01B56D30, 0x24B56D30, 0x37B56D30, 0x3BB56D30, 0x25B56D30, 0x09B56D30, 0x00B56D30, 0x00B56D30, 0x08B56D30, 0x86B56D30, 0xF3B56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xD8B56D30, 0x5CB56D30, 0x4DB56D30, 0x4DB56D30, 0x4DB56D30, 0x4DB56D30, 0x1FB56D30, 0x00B56D30, 0x10B56D30, 0x98B56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xD2B56D30, 0x38B56D30, 0x00B56D30,
        0x00B56D30, 0x20B56D30, 0x75B56D30, 0xBDB56D30, 0xD0B56D30, 0xD4B56D30, 0xBEB56D30, 0x92B56D30, 0x34B56D30, 0x02B56D30, 0x00B56D30, 0x17B56D30, 0xA2B56D30, 0xFCB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xFCB56D30, 0xEBB56D30, 0xE6B56D30, 0xE6B56D30, 0xE6B56D30, 0xE6B56D30, 0x6BB56D30, 0x05B56D30, 0x05B56D30, 0x71B56D30, 0xFAB56D30, 0xFFB56D30, 0xFFB56D30, 0xFDB56D30, 0xE1B56D30, 0xADB56D30, 0x80B56D30, 0x7EB56D30, 0x4BB56D30, 0x06B56D30, 0x00B56D30,
        0x24B56D30, 0xA9B56D30, 0xF3B56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFAB56D30, 0xD1B56D30, 0x57B56D30, 0x06B56D30, 0x01B56D30, 0x34B56D30, 0xC8B56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xF9B56D30, 0x93B56D30, 0x11B56D30, 0x0AB56D30, 0x60B56D30, 0xE4B56D30, 0xFEB56D30, 0xCEB56D30, 0x65B56D30, 0x0DB56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x1CB56D30,
        0xB2B56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xE4B56D30, 0x3FB56D30, 0x00B56D30, 0x00B56D30, 0x74B56D30, 0xF2B56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xE2B56D30, 0x98B56D30, 0x3AB56D30, 0x19B56D30, 0x7FB56D30, 0xE3B56D30, 0xFFB56D30, 0xC6B56D30, 0x26B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x61B56D30,
        0xF8B56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xB5B56D30, 0x00B56D30, 0x00B56D30, 0x36B56D30, 0xDEB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xFFB56D30, 0xFFB56D30, 0xF7B56D30, 0xB2B56D30, 0x4BB56D30, 0x10B56D30, 0x11B56D30, 0x87B56D30, 0xF9B56D30, 0xFFB56D30, 0xD1B56D30, 0x40B56D30, 0x00B56D30, 0x00B56D30, 0x11B56D30, 0x49B56D30, 0x73B56D30, 0x70B56D30, 0x49B56D30, 0x16B56D30, 0xC5B56D30,
        0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xF7B56D30, 0x0DB56D30, 0x00B56D30, 0x0FB56D30, 0xD1B56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xFFB56D30, 0xFBB56D30, 0x8DB56D30, 0x1EB56D30, 0x04B56D30, 0x3AB56D30, 0xAFB56D30, 0xF1B56D30, 0xFFB56D30, 0xF6B56D30, 0x6EB56D30, 0x06B56D30, 0x00B56D30, 0x28B56D30, 0xA6B56D30, 0xE3B56D30, 0xF2B56D30, 0xF1B56D30, 0xE4B56D30, 0xD3B56D30, 0xF9B56D30,
        0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0x38B56D30, 0x00B56D30, 0x01B56D30, 0x54B56D30, 0xE5B56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xFFB56D30, 0xFDB56D30, 0x8CB56D30, 0x36B56D30, 0xA4B56D30, 0xF7B56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xC7B56D30, 0x2EB56D30, 0x00B56D30, 0x1BB56D30, 0xB1B56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
        0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0x52B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x1AB56D30, 0xA3B56D30, 0xF6B56D30, 0xFFB56D30,
  0xFFB56D30, 0xFFB56D30, 0xFBB56D30, 0xF4B56D30, 0xFFB56D30, 0xFFB56D30, 0xEAB56D30, 0xC5B56D30, 0xA7B56D30, 0x64B56D30, 0x08B56D30, 0x00B56D30, 0x50B56D30, 0xF9B56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
        0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xA1B56D30, 0x54B56D30, 0x23B56D30, 0x04B56D30, 0x00B56D30, 0x22B56D30, 0xA9B56D30, 0xF9B56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFBB56D30, 0xCAB56D30, 0x63B56D30, 0x2CB56D30, 0x0EB56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x86B56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
        0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFEB56D30, 0xEBB56D30, 0xBBB56D30, 0x4AB56D30, 0x00B56D30, 0x00B56D30, 0x3CB56D30, 0xE0B56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xC3B56D30, 0x29B56D30, 0x06B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x98B56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
        0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xE1B56D30, 0x1EB56D30, 0x00B56D30, 0x06B56D30, 0x9BB56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xF1B56D30, 0x2BB56D30, 0x00B56D30, 0x00B56D30, 0x15B56D30, 0x36B56D30, 0x44B56D30, 0x2CB56D30, 0x15B56D30, 0x8EB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
        0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0x98B56D30, 0x00B56D30, 0x00B56D30, 0x40B56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0x9EB56D30, 0x00B56D30, 0x00B56D30, 0x20B56D30, 0x9AB56D30, 0xF9B56D30, 0xFEB56D30, 0xE3B56D30, 0xA6B56D30, 0xB6B56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
        0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xCBB56D30, 0x08B56D30, 0x00B56D30, 0x1BB56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0x5BB56D30, 0x00B56D30, 0x02B56D30, 0x7BB56D30, 0xF4B56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
        0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xD0B56D30, 0x0CB56D30, 0x00B56D30, 0x0EB56D30,
  0xFFB56D30, 0xFFB56D30, 0xF7B56D30, 0x35B56D30, 0x00B56D30, 0x10B56D30, 0xA8B56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
        0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xB0B56D30, 0x01B56D30, 0x00B56D30, 0x1FB56D30,
  0xFFB56D30, 0xFFB56D30, 0xFAB56D30, 0x52B56D30, 0x00B56D30, 0x0CB56D30, 0x98B56D30, 0xFAB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
        0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xF3B56D30, 0x48B56D30, 0x00B56D30, 0x00B56D30, 0x6CB56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0x7CB56D30, 0x00B56D30, 0x00B56D30, 0x46B56D30, 0xD2B56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
        0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFEB56D30, 0xE0B56D30, 0x80B56D30, 0x00B56D30, 0x00B56D30, 0x1DB56D30, 0xBEB56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xD0B56D30, 0x10B56D30, 0x00B56D30, 0x06B56D30, 0x43B56D30, 0x99B56D30, 0xB0B56D30, 0xB3B56D30, 0xB3B56D30, 0xB3B56D30, 0xB3B56D30, 0xB3B56D30, 0xB3B56D30, 0xB3B56D30, 0xB3B56D30, 0xB3B56D30, 0xB3B56D30, 0xB3B56D30,
        0xB3B56D30, 0xB3B56D30, 0xB3B56D30, 0xB3B56D30, 0xB3B56D30, 0xB3B56D30, 0xB3B56D30, 0xB3B56D30, 0xB3B56D30, 0xB3B56D30, 0xB3B56D30, 0xA9B56D30, 0x86B56D30, 0x4CB56D30, 0x0CB56D30, 0x00B56D30, 0x0AB56D30, 0x7EB56D30, 0xF3B56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFDB56D30, 0x80B56D30, 0x00B56D30, 0x00B56D30, 0x01B56D30, 0x11B56D30, 0x19B56D30, 0x1AB56D30, 0x1AB56D30, 0x1AB56D30, 0x1AB56D30, 0x1AB56D30, 0x1AB56D30, 0x1AB56D30, 0x1AB56D30, 0x1AB56D30, 0x1AB56D30, 0x1AB56D30,
        0x1AB56D30, 0x1AB56D30, 0x1AB56D30, 0x1AB56D30, 0x1AB56D30, 0x1AB56D30, 0x1AB56D30, 0x1AB56D30, 0x1AB56D30, 0x1AB56D30, 0x1AB56D30, 0x16B56D30, 0x0BB56D30, 0x02B56D30, 0x00B56D30, 0x05B56D30, 0x52B56D30, 0xDCB56D30, 0xFFB56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xF0B56D30, 0x90B56D30, 0x32B56D30, 0x09B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30,
        0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x00B56D30, 0x07B56D30, 0x21B56D30, 0x99B56D30, 0xE9B56D30, 0xFFB56D30, 0xFFB56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFBB56D30, 0xC5B56D30, 0x82B56D30, 0x5AB56D30, 0x4CB56D30, 0x4CB56D30, 0x4CB56D30, 0x4CB56D30, 0x4CB56D30, 0x4CB56D30, 0x4CB56D30, 0x4CB56D30, 0x4CB56D30, 0x4CB56D30, 0x4CB56D30, 0x4CB56D30,
        0x4CB56D30, 0x4CB56D30, 0x4CB56D30, 0x4CB56D30, 0x4CB56D30, 0x4CB56D30, 0x4CB56D30, 0x4CB56D30, 0x4CB56D30, 0x4CB56D30, 0x4CB56D30, 0x4DB56D30, 0x55B56D30, 0x78B56D30, 0xC3B56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xF3B56D30, 0xE5B56D30, 0xE5B56D30, 0xE5B56D30, 0xE5B56D30, 0xE5B56D30, 0xE5B56D30, 0xE5B56D30, 0xE5B56D30, 0xE5B56D30, 0xE5B56D30, 0xE5B56D30, 0xE5B56D30,
        0xE5B56D30, 0xE5B56D30, 0xE5B56D30, 0xE5B56D30, 0xE5B56D30, 0xE5B56D30, 0xE5B56D30, 0xE5B56D30, 0xE5B56D30, 0xE5B56D30, 0xE5B56D30, 0xE6B56D30, 0xEEB56D30, 0xFCB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
        0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
        0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
        0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
        0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
  0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30,
        0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30, 0xFFB56D30
};

GUI_CONST_STORAGE GUI_BITMAP bmpartly_cloudy_day40x40 = {
  40, // xSize
  40, // ySize
  160, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acbmpartly_cloudy_day40x40,  // Pointer to picture data
  NULL,  // Pointer to palette
  GUI_DRAW_BMP8888
};

#endif

/*************************** End of file ****************************/
