/*********************************************************************
*                SEGGER Microcontroller GmbH                         *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2018  SEGGER Microcontroller GmbH                *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.48 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software  has been licensed to  Cypress Semiconductor Corporation,
whose registered  office is situated  at 198 Champion Ct. San Jose, CA 
95134 USA  solely for the  purposes of creating  libraries for Cypress
PSoC3 and  PSoC5 processor-based devices,  sublicensed and distributed
under  the  terms  and  conditions  of  the  Cypress  End User License
Agreement.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information
Licensor:                 SEGGER Microcontroller Systems LLC
Licensed to:              Cypress Semiconductor Corp, 198 Champion Ct., San Jose, CA 95134, USA
Licensed SEGGER software: emWin
License number:           GUI-00319
License model:            Services and License Agreement, signed June 10th, 2009
Licensed platform:        Any Cypress platform (Initial targets are: PSoC3, PSoC5)
----------------------------------------------------------------------
Support and Update Agreement (SUA)
SUA period:               2009-06-12 - 2022-07-27
Contact to extend SUA:    sales@segger.com
----------------------------------------------------------------------
File        : Font32.h
Content     : GUI_Font32_AA4 (GUI_FONTTYPE_PROP_AA4_EXT)
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI.h"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

/* The following line needs to be included in any file selecting the
   font.
*/
extern GUI_CONST_STORAGE GUI_FONT GUI_Font32_AA4;

/* Start of unicode area <Basic Latin> */
GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0020[  1] = { /* code 0020, SPACE */
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0041[152] = { /* code 0041, LATIN CAPITAL LETTER A */
  0x00, 0x00, 0x00, 0xBF, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0xFF, 0xFF, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x06, 0xFF, 0xFF, 0x60, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0xFF, 0xFF, 0xB0, 0x00, 0x00,
  0x00, 0x00, 0x2F, 0xFE, 0xDF, 0xF2, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF9, 0x8F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0xF4, 0x3F, 0xFB, 0x00, 0x00,
  0x00, 0x02, 0xFF, 0xE0, 0x0D, 0xFF, 0x20, 0x00,
  0x00, 0x07, 0xFF, 0x90, 0x09, 0xFF, 0x70, 0x00,
  0x00, 0x0B, 0xFF, 0x40, 0x04, 0xFF, 0xB0, 0x00,
  0x00, 0x2F, 0xFE, 0x00, 0x00, 0xEF, 0xF2, 0x00,
  0x00, 0x7F, 0xF9, 0x00, 0x00, 0x9F, 0xF7, 0x00,
  0x00, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x02, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x20,
  0x07, 0xFF, 0xA0, 0x00, 0x00, 0x0A, 0xFF, 0x70,
  0x0C, 0xFF, 0x50, 0x00, 0x00, 0x05, 0xFF, 0xC0,
  0x2F, 0xFE, 0x00, 0x00, 0x00, 0x00, 0xEF, 0xF2,
  0x7F, 0xFA, 0x00, 0x00, 0x00, 0x00, 0xAF, 0xF7,
  0xCF, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xFC
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0042[114] = { /* code 0042, LATIN CAPITAL LETTER B */
  0xFF, 0xFF, 0xFF, 0xFC, 0x81, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x20,
  0xFF, 0xF0, 0x00, 0x2B, 0xFF, 0xA0,
  0xFF, 0xF0, 0x00, 0x02, 0xFF, 0xE0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xE0,
  0xFF, 0xF0, 0x00, 0x04, 0xFF, 0x90,
  0xFF, 0xF0, 0x00, 0x3D, 0xFE, 0x20,
  0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x60,
  0xFF, 0xF0, 0x00, 0x15, 0xEF, 0xF4,
  0xFF, 0xF0, 0x00, 0x00, 0x5F, 0xFB,
  0xFF, 0xF0, 0x00, 0x00, 0x1F, 0xFE,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x1F, 0xFD,
  0xFF, 0xF0, 0x00, 0x00, 0x7F, 0xF9,
  0xFF, 0xF0, 0x00, 0x28, 0xFF, 0xE2,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x30,
  0xFF, 0xFF, 0xFF, 0xEC, 0x71, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0043[133] = { /* code 0043, LATIN CAPITAL LETTER C */
  0x00, 0x00, 0x28, 0xCF, 0xFE, 0xB7, 0x10,
  0x00, 0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,
  0x00, 0xAF, 0xFE, 0x72, 0x01, 0x6D, 0xFF,
  0x07, 0xFF, 0xD1, 0x00, 0x00, 0x00, 0x9F,
  0x1E, 0xFF, 0x30, 0x00, 0x00, 0x00, 0x09,
  0x6F, 0xFB, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xAF, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xF2, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xF2, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xAF, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x6F, 0xFB, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1F, 0xFF, 0x30, 0x00, 0x00, 0x00, 0x09,
  0x07, 0xFF, 0xD1, 0x00, 0x00, 0x00, 0x9F,
  0x00, 0xBF, 0xFE, 0x62, 0x01, 0x6D, 0xFF,
  0x00, 0x19, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7,
  0x00, 0x00, 0x39, 0xCF, 0xFE, 0xB6, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0044[152] = { /* code 0044, LATIN CAPITAL LETTER D */
  0xFF, 0xFF, 0xFF, 0xEC, 0x94, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD4, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x25, 0xAF, 0xFF, 0x60, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x04, 0xEF, 0xF4, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x4F, 0xFD, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0B, 0xFF, 0x50,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x06, 0xFF, 0xA0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x02, 0xFF, 0xD0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x02, 0xFF, 0xC0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x05, 0xFF, 0x90,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0B, 0xFF, 0x40,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x4F, 0xFC, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x04, 0xEF, 0xF3, 0x00,
  0xFF, 0xF0, 0x00, 0x24, 0xAF, 0xFF, 0x50, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC3, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xEC, 0x94, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0045[114] = { /* code 0045, LATIN CAPITAL LETTER E */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0046[114] = { /* code 0046, LATIN CAPITAL LETTER F */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0047[152] = { /* code 0047, LATIN CAPITAL LETTER G */
  0x00, 0x00, 0x17, 0xBE, 0xFF, 0xDA, 0x61, 0x00,
  0x00, 0x06, 0xEF, 0xFF, 0xFF, 0xFF, 0xFE, 0x70,
  0x00, 0x8F, 0xFE, 0x72, 0x00, 0x38, 0xEF, 0xF0,
  0x05, 0xFF, 0xE2, 0x00, 0x00, 0x00, 0x2B, 0xF0,
  0x0E, 0xFF, 0x40, 0x00, 0x00, 0x00, 0x00, 0xA0,
  0x5F, 0xFB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xAF, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xF2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xF0,
  0xDF, 0xF2, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xAF, 0xF5, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x6F, 0xFA, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x1E, 0xFF, 0x30, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x07, 0xFF, 0xD1, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0xAF, 0xFE, 0x62, 0x00, 0x37, 0xFF, 0xF0,
  0x00, 0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x90,
  0x00, 0x00, 0x27, 0xBE, 0xFF, 0xDA, 0x51, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0048[133] = { /* code 0048, LATIN CAPITAL LETTER H */
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0049[ 76] = { /* code 0049, LATIN CAPITAL LETTER I */
  0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0x00, 0xFF, 0xF0, 0x00,
  0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_004A[ 95] = { /* code 004A, LATIN CAPITAL LETTER J */
  0x00, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xFF, 0xF0,
  0x00, 0x00, 0x01, 0xFF, 0xF0,
  0x00, 0x00, 0x04, 0xFF, 0xC0,
  0xC4, 0x00, 0x4D, 0xFF, 0x60,
  0xFF, 0xFF, 0xFF, 0xF9, 0x00,
  0xBD, 0xFF, 0xEB, 0x50, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_004B[133] = { /* code 004B, LATIN CAPITAL LETTER K */
  0xFF, 0xF0, 0x00, 0x00, 0x6F, 0xFF, 0x90,
  0xFF, 0xF0, 0x00, 0x03, 0xFF, 0xFB, 0x00,
  0xFF, 0xF0, 0x00, 0x1E, 0xFF, 0xC1, 0x00,
  0xFF, 0xF0, 0x00, 0xCF, 0xFE, 0x20, 0x00,
  0xFF, 0xF0, 0x09, 0xFF, 0xE3, 0x00, 0x00,
  0xFF, 0xF0, 0x6F, 0xFF, 0x50, 0x00, 0x00,
  0xFF, 0xF4, 0xFF, 0xF7, 0x00, 0x00, 0x00,
  0xFF, 0xFE, 0xFF, 0x90, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0x70, 0x00, 0x00, 0x00,
  0xFF, 0xFD, 0xFF, 0xF3, 0x00, 0x00, 0x00,
  0xFF, 0xF1, 0xCF, 0xFC, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x2E, 0xFF, 0x80, 0x00, 0x00,
  0xFF, 0xF0, 0x06, 0xFF, 0xF3, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0xBF, 0xFD, 0x10, 0x00,
  0xFF, 0xF0, 0x00, 0x2E, 0xFF, 0x90, 0x00,
  0xFF, 0xF0, 0x00, 0x06, 0xFF, 0xF4, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0xAF, 0xFD, 0x10,
  0xFF, 0xF0, 0x00, 0x00, 0x1E, 0xFF, 0xA0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_004C[114] = { /* code 004C, LATIN CAPITAL LETTER L */
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_004D[152] = { /* code 004D, LATIN CAPITAL LETTER M */
  0xFF, 0xFF, 0x20, 0x00, 0x00, 0x01, 0xFF, 0xFF,
  0xFF, 0xFF, 0x80, 0x00, 0x00, 0x06, 0xFF, 0xFF,
  0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x0C, 0xFF, 0xFF,
  0xFF, 0xFA, 0xF5, 0x00, 0x00, 0x3F, 0xAF, 0xFF,
  0xFF, 0xF4, 0xFB, 0x00, 0x00, 0x8F, 0x4F, 0xFF,
  0xFF, 0xF0, 0xEF, 0x20, 0x00, 0xDE, 0x0F, 0xFF,
  0xFF, 0xF0, 0x8F, 0x70, 0x04, 0xF8, 0x0F, 0xFF,
  0xFF, 0xF0, 0x2F, 0xD0, 0x0A, 0xF2, 0x0F, 0xFF,
  0xFF, 0xF0, 0x0C, 0xF4, 0x1F, 0xB0, 0x0F, 0xFF,
  0xFF, 0xF0, 0x06, 0xFA, 0x6F, 0x60, 0x0F, 0xFF,
  0xFF, 0xF0, 0x01, 0xFF, 0xCE, 0x10, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0xAF, 0xF9, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x4F, 0xF3, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x0D, 0xD0, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_004E[133] = { /* code 004E, LATIN CAPITAL LETTER N */
  0xFF, 0xFF, 0x30, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xFF, 0x90, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xFF, 0xE0, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xFA, 0xF6, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF3, 0xFC, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0xCF, 0x30, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x6F, 0x90, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x1F, 0xE0, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x09, 0xF6, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x03, 0xFC, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0xCF, 0x30, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x6F, 0x90, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x1E, 0xE0, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x09, 0xF6, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x03, 0xFC, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0xCF, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x6F, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x0E, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x09, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_004F[152] = { /* code 004F, LATIN CAPITAL LETTER O */
  0x00, 0x00, 0x4A, 0xDF, 0xFD, 0xA4, 0x00, 0x00,
  0x00, 0x1B, 0xFF, 0xFF, 0xFF, 0xFF, 0xB1, 0x00,
  0x01, 0xCF, 0xFB, 0x30, 0x03, 0xBF, 0xFC, 0x10,
  0x08, 0xFF, 0xA0, 0x00, 0x00, 0x0A, 0xFF, 0x80,
  0x1F, 0xFE, 0x10, 0x00, 0x00, 0x01, 0xEF, 0xF1,
  0x7F, 0xF9, 0x00, 0x00, 0x00, 0x00, 0x8F, 0xF7,
  0xBF, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xFB,
  0xDF, 0xF2, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xFD,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xDF, 0xF2, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xFD,
  0xBF, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xFB,
  0x7F, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x8F, 0xF7,
  0x1F, 0xFE, 0x10, 0x00, 0x00, 0x01, 0xEF, 0xF1,
  0x08, 0xFF, 0xB0, 0x00, 0x00, 0x0A, 0xFF, 0x80,
  0x01, 0xCF, 0xFB, 0x40, 0x03, 0xBF, 0xFB, 0x00,
  0x00, 0x1B, 0xFF, 0xFF, 0xFF, 0xFF, 0xB1, 0x00,
  0x00, 0x00, 0x4A, 0xDF, 0xFD, 0xA4, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0050[114] = { /* code 0050, LATIN CAPITAL LETTER P */
  0xFF, 0xFF, 0xFF, 0xEB, 0x71, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0x30,
  0xFF, 0xF0, 0x00, 0x39, 0xFF, 0xE2,
  0xFF, 0xF0, 0x00, 0x00, 0x9F, 0xF9,
  0xFF, 0xF0, 0x00, 0x00, 0x2F, 0xFD,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x3F, 0xFC,
  0xFF, 0xF0, 0x00, 0x00, 0xBF, 0xF6,
  0xFF, 0xF0, 0x00, 0x3A, 0xFF, 0xC0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x10,
  0xFF, 0xFF, 0xFF, 0xEB, 0x50, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0051[192] = { /* code 0051, LATIN CAPITAL LETTER Q */
  0x00, 0x00, 0x4A, 0xDF, 0xFD, 0xA4, 0x00, 0x00,
  0x00, 0x1B, 0xFF, 0xFF, 0xFF, 0xFF, 0xB1, 0x00,
  0x01, 0xCF, 0xFB, 0x30, 0x03, 0xBF, 0xFC, 0x10,
  0x08, 0xFF, 0xA0, 0x00, 0x00, 0x0A, 0xFF, 0x80,
  0x1F, 0xFE, 0x10, 0x00, 0x00, 0x01, 0xEF, 0xF1,
  0x7F, 0xF9, 0x00, 0x00, 0x00, 0x00, 0x8F, 0xF7,
  0xBF, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xFB,
  0xDF, 0xF2, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xFD,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0xDF, 0xF2, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xFD,
  0xBF, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xFB,
  0x7F, 0xF9, 0x00, 0x00, 0x00, 0x00, 0x9F, 0xF7,
  0x1F, 0xFE, 0x10, 0x00, 0x00, 0x01, 0xEF, 0xF1,
  0x08, 0xFF, 0xB0, 0x00, 0x00, 0x0B, 0xFF, 0x80,
  0x01, 0xCF, 0xFB, 0x40, 0x03, 0xBF, 0xFC, 0x00,
  0x00, 0x1B, 0xFF, 0xFF, 0xFF, 0xFF, 0xE2, 0x00,
  0x00, 0x00, 0x4A, 0xDF, 0xFF, 0xFF, 0x20, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF, 0x50, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xC1, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xCF, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0xEF, 0xEC
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0052[133] = { /* code 0052, LATIN CAPITAL LETTER R */
  0xFF, 0xFF, 0xFF, 0xDB, 0x50, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFA, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x4E, 0xFF, 0x60, 0x00,
  0xFF, 0xF0, 0x00, 0x04, 0xFF, 0xC0, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0xFF, 0xF0, 0x00,
  0xFF, 0xF0, 0x00, 0x02, 0xFF, 0xC0, 0x00,
  0xFF, 0xF0, 0x00, 0x07, 0xFF, 0x80, 0x00,
  0xFF, 0xF0, 0x01, 0x6E, 0xFD, 0x10, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xC2, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x3F, 0xFF, 0x70, 0x00, 0x00,
  0xFF, 0xF0, 0x07, 0xFF, 0xF3, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0xBF, 0xFD, 0x10, 0x00,
  0xFF, 0xF0, 0x00, 0x1E, 0xFF, 0xA0, 0x00,
  0xFF, 0xF0, 0x00, 0x04, 0xFF, 0xF6, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x8F, 0xFF, 0x30,
  0xFF, 0xF0, 0x00, 0x00, 0x0C, 0xFF, 0xD1,
  0xFF, 0xF0, 0x00, 0x00, 0x02, 0xEF, 0xF9
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0053[114] = { /* code 0053, LATIN CAPITAL LETTER S */
  0x00, 0x29, 0xDF, 0xFD, 0xB7, 0x10,
  0x05, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x3F, 0xFE, 0x71, 0x02, 0x7E, 0xF0,
  0xAF, 0xF6, 0x00, 0x00, 0x01, 0xA0,
  0xEF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0xF4, 0x00, 0x00, 0x00, 0x00,
  0x8F, 0xFE, 0x40, 0x00, 0x00, 0x00,
  0x1D, 0xFF, 0xFE, 0xB7, 0x30, 0x00,
  0x01, 0x8E, 0xFF, 0xFF, 0xFB, 0x30,
  0x00, 0x01, 0x48, 0xCF, 0xFF, 0xE2,
  0x00, 0x00, 0x00, 0x02, 0xCF, 0xFA,
  0x00, 0x00, 0x00, 0x00, 0x3F, 0xFE,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF,
  0x90, 0x00, 0x00, 0x00, 0x1F, 0xFD,
  0xF9, 0x00, 0x00, 0x00, 0x7F, 0xF9,
  0xFF, 0xD6, 0x10, 0x27, 0xFF, 0xE2,
  0xAF, 0xFF, 0xFF, 0xFF, 0xFE, 0x40,
  0x02, 0x8C, 0xEF, 0xFD, 0x81, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0054[171] = { /* code 0054, LATIN CAPITAL LETTER T */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0055[133] = { /* code 0055, LATIN CAPITAL LETTER U */
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xFF, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0,
  0xDF, 0xF1, 0x00, 0x00, 0x01, 0xFF, 0xD0,
  0xBF, 0xF4, 0x00, 0x00, 0x04, 0xFF, 0xB0,
  0x6F, 0xFB, 0x00, 0x00, 0x0B, 0xFF, 0x60,
  0x0D, 0xFF, 0x92, 0x02, 0x9F, 0xFD, 0x00,
  0x02, 0xDF, 0xFF, 0xFF, 0xFF, 0xD2, 0x00,
  0x00, 0x17, 0xCE, 0xFF, 0xC7, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0056[152] = { /* code 0056, LATIN CAPITAL LETTER V */
  0xCF, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xFC,
  0x7F, 0xFA, 0x00, 0x00, 0x00, 0x00, 0xAF, 0xF7,
  0x2F, 0xFF, 0x10, 0x00, 0x00, 0x01, 0xFF, 0xF2,
  0x0B, 0xFF, 0x50, 0x00, 0x00, 0x05, 0xFF, 0xB0,
  0x07, 0xFF, 0xB0, 0x00, 0x00, 0x0A, 0xFF, 0x70,
  0x02, 0xFF, 0xF1, 0x00, 0x00, 0x1F, 0xFF, 0x20,
  0x00, 0xBF, 0xF6, 0x00, 0x00, 0x5F, 0xFB, 0x00,
  0x00, 0x6F, 0xFB, 0x00, 0x00, 0xAF, 0xF6, 0x00,
  0x00, 0x1F, 0xFF, 0x10, 0x01, 0xFF, 0xF1, 0x00,
  0x00, 0x0A, 0xFF, 0x60, 0x05, 0xFF, 0xA0, 0x00,
  0x00, 0x05, 0xFF, 0xB0, 0x0A, 0xFF, 0x50, 0x00,
  0x00, 0x01, 0xEF, 0xF1, 0x1F, 0xFE, 0x10, 0x00,
  0x00, 0x00, 0xAF, 0xF6, 0x6F, 0xFA, 0x00, 0x00,
  0x00, 0x00, 0x5F, 0xFB, 0xBF, 0xF5, 0x00, 0x00,
  0x00, 0x00, 0x0E, 0xFF, 0xFF, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0x09, 0xFF, 0xFF, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x04, 0xFF, 0xFF, 0x40, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xDF, 0xFD, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x8F, 0xF8, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0057[228] = { /* code 0057, LATIN CAPITAL LETTER W */
  0xDF, 0xF3, 0x00, 0x00, 0x00, 0xDF, 0xE0, 0x00, 0x00, 0x03, 0xFF, 0xD0,
  0x9F, 0xF7, 0x00, 0x00, 0x01, 0xFF, 0xF3, 0x00, 0x00, 0x07, 0xFF, 0x90,
  0x5F, 0xFA, 0x00, 0x00, 0x05, 0xFF, 0xF7, 0x00, 0x00, 0x0A, 0xFF, 0x60,
  0x1F, 0xFE, 0x00, 0x00, 0x09, 0xFD, 0xFA, 0x00, 0x00, 0x0E, 0xFF, 0x20,
  0x0D, 0xFF, 0x30, 0x00, 0x0C, 0xF7, 0xFE, 0x00, 0x00, 0x2F, 0xFD, 0x00,
  0x09, 0xFF, 0x70, 0x00, 0x1F, 0xE1, 0xFF, 0x30, 0x00, 0x6F, 0xF9, 0x00,
  0x05, 0xFF, 0xA0, 0x00, 0x5F, 0xB0, 0xCF, 0x60, 0x00, 0xAF, 0xF5, 0x00,
  0x01, 0xFF, 0xE0, 0x00, 0x8F, 0x70, 0x9F, 0xA0, 0x00, 0xDF, 0xF1, 0x00,
  0x00, 0xCF, 0xF2, 0x00, 0xCF, 0x40, 0x5F, 0xE0, 0x02, 0xFF, 0xD0, 0x00,
  0x00, 0x8F, 0xF6, 0x01, 0xFF, 0x10, 0x2F, 0xF2, 0x05, 0xFF, 0x90, 0x00,
  0x00, 0x5F, 0xFA, 0x04, 0xFC, 0x00, 0x0E, 0xF6, 0x09, 0xFF, 0x50, 0x00,
  0x00, 0x1F, 0xFD, 0x08, 0xF9, 0x00, 0x0A, 0xF9, 0x0C, 0xFF, 0x10, 0x00,
  0x00, 0x0C, 0xFF, 0x2B, 0xF5, 0x00, 0x07, 0xFD, 0x1F, 0xFD, 0x00, 0x00,
  0x00, 0x08, 0xFF, 0x6F, 0xF2, 0x00, 0x03, 0xFF, 0x6F, 0xF9, 0x00, 0x00,
  0x00, 0x04, 0xFF, 0xDF, 0xE0, 0x00, 0x00, 0xFF, 0xDF, 0xF5, 0x00, 0x00,
  0x00, 0x01, 0xFF, 0xFF, 0xA0, 0x00, 0x00, 0xCF, 0xFF, 0xF1, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0xFF, 0x70, 0x00, 0x00, 0x8F, 0xFF, 0xD0, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xFF, 0x30, 0x00, 0x00, 0x5F, 0xFF, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x4F, 0xFF, 0x00, 0x00, 0x00, 0x2F, 0xFF, 0x50, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0058[152] = { /* code 0058, LATIN CAPITAL LETTER X */
  0xAF, 0xF5, 0x00, 0x00, 0x00, 0x05, 0xFF, 0xA0,
  0x2E, 0xFE, 0x10, 0x00, 0x00, 0x1D, 0xFE, 0x20,
  0x06, 0xFF, 0x90, 0x00, 0x00, 0x9F, 0xF6, 0x00,
  0x00, 0xCF, 0xF3, 0x00, 0x03, 0xFF, 0xC0, 0x00,
  0x00, 0x3F, 0xFD, 0x00, 0x0C, 0xFF, 0x30, 0x00,
  0x00, 0x08, 0xFF, 0x70, 0x7F, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0xDF, 0xF4, 0xFF, 0xD0, 0x00, 0x00,
  0x00, 0x00, 0x4F, 0xFF, 0xFF, 0x40, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0xFF, 0xFA, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x02, 0xFF, 0xF2, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0xFF, 0xFA, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x4F, 0xFF, 0xFF, 0x40, 0x00, 0x00,
  0x00, 0x00, 0xDF, 0xF5, 0xFF, 0xD0, 0x00, 0x00,
  0x00, 0x08, 0xFF, 0x70, 0x7F, 0xF8, 0x00, 0x00,
  0x00, 0x3F, 0xFD, 0x00, 0x0D, 0xFF, 0x30, 0x00,
  0x00, 0xCF, 0xF3, 0x00, 0x03, 0xFF, 0xC0, 0x00,
  0x06, 0xFF, 0x90, 0x00, 0x00, 0x9F, 0xF6, 0x00,
  0x2E, 0xFD, 0x10, 0x00, 0x00, 0x1E, 0xFE, 0x20,
  0xAF, 0xF5, 0x00, 0x00, 0x00, 0x05, 0xFF, 0xA0
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_0059[152] = { /* code 0059, LATIN CAPITAL LETTER Y */
  0xBF, 0xFB, 0x00, 0x00, 0x00, 0x0B, 0xFF, 0xB0,
  0x3F, 0xFF, 0x40, 0x00, 0x00, 0x4F, 0xFF, 0x20,
  0x09, 0xFF, 0xC0, 0x00, 0x00, 0xCF, 0xF9, 0x00,
  0x01, 0xFF, 0xF5, 0x00, 0x06, 0xFF, 0xE1, 0x00,
  0x00, 0x7F, 0xFD, 0x00, 0x1E, 0xFF, 0x70, 0x00,
  0x00, 0x1E, 0xFF, 0x70, 0x7F, 0xFD, 0x00, 0x00,
  0x00, 0x06, 0xFF, 0xE2, 0xFF, 0xF5, 0x00, 0x00,
  0x00, 0x00, 0xDF, 0xFE, 0xFF, 0xB0, 0x00, 0x00,
  0x00, 0x00, 0x4F, 0xFF, 0xFF, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0xFF, 0xF9, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0xFF, 0xF1, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font32_AA4_005A[133] = { /* code 005A, LATIN CAPITAL LETTER Z */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x05, 0xFF, 0xA0,
  0x00, 0x00, 0x00, 0x00, 0x1E, 0xFE, 0x10,
  0x00, 0x00, 0x00, 0x00, 0xBF, 0xF5, 0x00,
  0x00, 0x00, 0x00, 0x06, 0xFF, 0xA0, 0x00,
  0x00, 0x00, 0x00, 0x2E, 0xFE, 0x10, 0x00,
  0x00, 0x00, 0x00, 0xBF, 0xF5, 0x00, 0x00,
  0x00, 0x00, 0x06, 0xFF, 0xA0, 0x00, 0x00,
  0x00, 0x00, 0x2E, 0xFE, 0x10, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0xF5, 0x00, 0x00, 0x00,
  0x00, 0x06, 0xFF, 0xA0, 0x00, 0x00, 0x00,
  0x00, 0x2E, 0xFE, 0x10, 0x00, 0x00, 0x00,
  0x00, 0xBF, 0xF5, 0x00, 0x00, 0x00, 0x00,
  0x06, 0xFF, 0x90, 0x00, 0x00, 0x00, 0x00,
  0x2E, 0xFD, 0x10, 0x00, 0x00, 0x00, 0x00,
  0xBF, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_Font32_AA4_CharInfo[27] = {
   {   1,   1,   0,  27,   8, acGUI_Font32_AA4_0020 } /* code 0020, SPACE */
  ,{  16,  19,   0,   8,  16, acGUI_Font32_AA4_0041 } /* code 0041, LATIN CAPITAL LETTER A */
  ,{  12,  19,   2,   8,  15, acGUI_Font32_AA4_0042 } /* code 0042, LATIN CAPITAL LETTER B */
  ,{  14,  19,   1,   8,  16, acGUI_Font32_AA4_0043 } /* code 0043, LATIN CAPITAL LETTER C */
  ,{  15,  19,   2,   8,  18, acGUI_Font32_AA4_0044 } /* code 0044, LATIN CAPITAL LETTER D */
  ,{  12,  19,   2,   8,  15, acGUI_Font32_AA4_0045 } /* code 0045, LATIN CAPITAL LETTER E */
  ,{  12,  19,   2,   8,  14, acGUI_Font32_AA4_0046 } /* code 0046, LATIN CAPITAL LETTER F */
  ,{  15,  19,   1,   8,  17, acGUI_Font32_AA4_0047 } /* code 0047, LATIN CAPITAL LETTER G */
  ,{  14,  19,   2,   8,  18, acGUI_Font32_AA4_0048 } /* code 0048, LATIN CAPITAL LETTER H */
  ,{   7,  19,   2,   8,  10, acGUI_Font32_AA4_0049 } /* code 0049, LATIN CAPITAL LETTER I */
  ,{   9,  19,   0,   8,  11, acGUI_Font32_AA4_004A } /* code 004A, LATIN CAPITAL LETTER J */
  ,{  13,  19,   2,   8,  15, acGUI_Font32_AA4_004B } /* code 004B, LATIN CAPITAL LETTER K */
  ,{  11,  19,   2,   8,  13, acGUI_Font32_AA4_004C } /* code 004C, LATIN CAPITAL LETTER L */
  ,{  16,  19,   2,   8,  20, acGUI_Font32_AA4_004D } /* code 004D, LATIN CAPITAL LETTER M */
  ,{  13,  19,   2,   8,  17, acGUI_Font32_AA4_004E } /* code 004E, LATIN CAPITAL LETTER N */
  ,{  16,  19,   1,   8,  18, acGUI_Font32_AA4_004F } /* code 004F, LATIN CAPITAL LETTER O */
  ,{  12,  19,   2,   8,  14, acGUI_Font32_AA4_0050 } /* code 0050, LATIN CAPITAL LETTER P */
  ,{  16,  24,   1,   8,  18, acGUI_Font32_AA4_0051 } /* code 0051, LATIN CAPITAL LETTER Q */
  ,{  14,  19,   2,   8,  16, acGUI_Font32_AA4_0052 } /* code 0052, LATIN CAPITAL LETTER R */
  ,{  12,  19,   1,   8,  14, acGUI_Font32_AA4_0053 } /* code 0053, LATIN CAPITAL LETTER S */
  ,{  17,  19,  -1,   8,  15, acGUI_Font32_AA4_0054 } /* code 0054, LATIN CAPITAL LETTER T */
  ,{  13,  19,   2,   8,  17, acGUI_Font32_AA4_0055 } /* code 0055, LATIN CAPITAL LETTER U */
  ,{  16,  19,   0,   8,  16, acGUI_Font32_AA4_0056 } /* code 0056, LATIN CAPITAL LETTER V */
  ,{  23,  19,   0,   8,  23, acGUI_Font32_AA4_0057 } /* code 0057, LATIN CAPITAL LETTER W */
  ,{  15,  19,   0,   8,  15, acGUI_Font32_AA4_0058 } /* code 0058, LATIN CAPITAL LETTER X */
  ,{  15,  19,   0,   8,  15, acGUI_Font32_AA4_0059 } /* code 0059, LATIN CAPITAL LETTER Y */
  ,{  13,  19,   1,   8,  15, acGUI_Font32_AA4_005A } /* code 005A, LATIN CAPITAL LETTER Z */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font32_AA4_Prop2 = {
   0x0041 /* first character */
  ,0x005A /* last character  */
  ,&GUI_Font32_AA4_CharInfo[  1] /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font32_AA4_Prop1 = {
   0x0020 /* first character */
  ,0x0020 /* last character  */
  ,&GUI_Font32_AA4_CharInfo[  0] /* address of first character */
  ,&GUI_Font32_AA4_Prop2 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT GUI_Font32_AA4 = {
   GUI_FONTTYPE_PROP_AA4_EXT /* type of font    */
  ,32 /* height of font  */
  ,32 /* space of font y */
  ,1 /* magnification x */
  ,1 /* magnification y */
  ,{&GUI_Font32_AA4_Prop1}
  ,27 /* Baseline */
  ,14 /* Height of lowercase characters */
  ,19 /* Height of capital characters */
};

/*************************** End of file ****************************/
