/*********************************************************************
*                SEGGER Microcontroller GmbH                         *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2018  SEGGER Microcontroller GmbH                *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.48 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software  has been licensed to  Cypress Semiconductor Corporation,
whose registered  office is situated  at 198 Champion Ct. San Jose, CA 
95134 USA  solely for the  purposes of creating  libraries for Cypress
PSoC3 and  PSoC5 processor-based devices,  sublicensed and distributed
under  the  terms  and  conditions  of  the  Cypress  End User License
Agreement.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information
Licensor:                 SEGGER Microcontroller Systems LLC
Licensed to:              Cypress Semiconductor Corp, 198 Champion Ct., San Jose, CA 95134, USA
Licensed SEGGER software: emWin
License number:           GUI-00319
License model:            Services and License Agreement, signed June 10th, 2009
Licensed platform:        Any Cypress platform (Initial targets are: PSoC3, PSoC5)
----------------------------------------------------------------------
Support and Update Agreement (SUA)
SUA period:               2009-06-12 - 2022-07-27
Contact to extend SUA:    sales@segger.com
---------------------------------------------------------------------
File        : Font30SL_AA4.c
Purpose     : GUI_FONT_PROP_EXT, AA4, 30 Pixel
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI.h"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

/* The following line needs to be included in any file selecting the
   font.
*/
extern GUI_CONST_STORAGE GUI_FONT GUI_Font30SL_AA4;

/* Start of unicode area <Basic Latin> */
GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0020[  1] = { /* code 0020, SPACE */
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0021[ 18] = { /* code 0021, EXCLAMATION MARK */
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xDD,
  0xDD,
  0xBB,
  0xBB,
  0x9A,
  0x99,
  0x00,
  0x00,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0022[ 14] = { /* code 0022, QUOTATION MARK */
  0xF0, 0x0F,
  0xF0, 0x0F,
  0xF0, 0x0F,
  0xF0, 0x0F,
  0xF0, 0x0F,
  0xF0, 0x0F,
  0xF0, 0x0F
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0023[144] = { /* code 0023, NUMBER SIGN */
  0x00, 0x00, 0x00, 0x00, 0xE5, 0x00, 0x5F, 0x10,
  0x00, 0x00, 0x00, 0x05, 0xF1, 0x00, 0xAA, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0xA0, 0x01, 0xF5, 0x00,
  0x00, 0x00, 0x00, 0x1F, 0x50, 0x06, 0xE0, 0x00,
  0x00, 0x00, 0x00, 0x6E, 0x00, 0x0B, 0x90, 0x00,
  0x00, 0x00, 0x00, 0xB9, 0x00, 0x2F, 0x40, 0x00,
  0x08, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC,
  0x00, 0x00, 0x07, 0xD0, 0x00, 0xC8, 0x00, 0x00,
  0x00, 0x00, 0x0C, 0x90, 0x02, 0xF3, 0x00, 0x00,
  0x00, 0x00, 0x1F, 0x40, 0x07, 0xE0, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0x00, 0x0B, 0x90, 0x00, 0x00,
  0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x00, 0x02, 0xF4, 0x00, 0x7D, 0x00, 0x00, 0x00,
  0x00, 0x07, 0xD0, 0x00, 0xC8, 0x00, 0x00, 0x00,
  0x00, 0x0C, 0x80, 0x02, 0xF3, 0x00, 0x00, 0x00,
  0x00, 0x3F, 0x30, 0x08, 0xD0, 0x00, 0x00, 0x00,
  0x00, 0x8C, 0x00, 0x0D, 0x70, 0x00, 0x00, 0x00,
  0x00, 0xD7, 0x00, 0x3F, 0x20, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0024[120] = { /* code 0024, DOLLAR SIGN */
  0x00, 0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x49, 0xDF, 0xFE, 0xB3, 0x00,
  0x0A, 0xF9, 0x30, 0xF2, 0xCF, 0x30,
  0x7F, 0x80, 0x00, 0xF0, 0x4F, 0xB0,
  0xDF, 0x10, 0x00, 0xF0, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0xF0, 0x00, 0x00,
  0xDF, 0x50, 0x00, 0xF0, 0x00, 0x00,
  0x5F, 0xF7, 0x20, 0xF0, 0x00, 0x00,
  0x05, 0xDF, 0xFD, 0xF4, 0x00, 0x00,
  0x00, 0x03, 0x7B, 0xFF, 0xE8, 0x10,
  0x00, 0x00, 0x00, 0xF5, 0xCF, 0xD1,
  0x00, 0x00, 0x00, 0xF0, 0x0A, 0xF9,
  0x44, 0x00, 0x00, 0xF0, 0x02, 0xFE,
  0xFF, 0x10, 0x00, 0xF0, 0x00, 0xFF,
  0xCF, 0x40, 0x00, 0xF0, 0x01, 0xFD,
  0x5F, 0xC1, 0x00, 0xF0, 0x06, 0xF8,
  0x07, 0xFC, 0x51, 0xF1, 0x6E, 0xB1,
  0x00, 0x28, 0xCE, 0xFF, 0xC7, 0x00,
  0x00, 0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xF0, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0025[171] = { /* code 0025, PERCENT SIGN */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x71, 0x00,
  0x03, 0xBF, 0xFB, 0x30, 0x00, 0x00, 0x09, 0xB0, 0x00,
  0x3E, 0x61, 0x16, 0xE3, 0x00, 0x00, 0x3E, 0x20, 0x00,
  0xB6, 0x00, 0x00, 0x6B, 0x00, 0x00, 0xC7, 0x00, 0x00,
  0xF1, 0x00, 0x00, 0x1F, 0x00, 0x07, 0xC0, 0x00, 0x00,
  0xF1, 0x00, 0x00, 0x1F, 0x00, 0x2E, 0x30, 0x00, 0x00,
  0xB6, 0x00, 0x00, 0x6B, 0x00, 0xB8, 0x00, 0x00, 0x00,
  0x3E, 0x61, 0x16, 0xE3, 0x06, 0xD0, 0x00, 0x00, 0x00,
  0x03, 0xBF, 0xFB, 0x30, 0x1E, 0x40, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xAA, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x04, 0xE1, 0x03, 0xBF, 0xFB, 0x30,
  0x00, 0x00, 0x00, 0x0D, 0x60, 0x3E, 0x61, 0x16, 0xE3,
  0x00, 0x00, 0x00, 0x8B, 0x00, 0xB6, 0x00, 0x00, 0x6B,
  0x00, 0x00, 0x03, 0xE2, 0x00, 0xF1, 0x00, 0x00, 0x1F,
  0x00, 0x00, 0x0C, 0x70, 0x00, 0xF1, 0x00, 0x00, 0x1F,
  0x00, 0x00, 0x7D, 0x00, 0x00, 0xB7, 0x00, 0x00, 0x6B,
  0x00, 0x02, 0xE3, 0x00, 0x00, 0x2E, 0x71, 0x16, 0xE3,
  0x00, 0x0B, 0x90, 0x00, 0x00, 0x02, 0xBF, 0xFB, 0x30,
  0x00, 0x17, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0026[144] = { /* code 0026, AMPERSAND */
  0x00, 0x04, 0xBF, 0xFC, 0x50, 0x00, 0x00, 0x00,
  0x00, 0x4F, 0xA1, 0x1A, 0xF5, 0x00, 0x00, 0x00,
  0x00, 0xCF, 0x10, 0x02, 0xFD, 0x00, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0xDF, 0x30, 0x03, 0xFD, 0x00, 0x00, 0x00,
  0x00, 0x6F, 0xB0, 0x1C, 0xF7, 0x00, 0x00, 0x00,
  0x00, 0x0A, 0xF8, 0xCF, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x02, 0xEF, 0xC4, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x8F, 0xDE, 0xC0, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0xFA, 0x13, 0xF9, 0x00, 0x00, 0x00, 0x00,
  0x6F, 0xC0, 0x00, 0x6F, 0x60, 0x0F, 0xF0, 0x00,
  0xCF, 0x40, 0x00, 0x08, 0xF4, 0x1F, 0xC0, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0xBE, 0x5F, 0x90, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x1C, 0xFF, 0x30, 0x00,
  0xCF, 0x30, 0x00, 0x00, 0x02, 0xFB, 0x00, 0x00,
  0x6F, 0xA0, 0x00, 0x00, 0x09, 0xFF, 0x80, 0x00,
  0x09, 0xFA, 0x20, 0x14, 0xBD, 0x3A, 0xF8, 0x00,
  0x00, 0x5B, 0xFF, 0xEB, 0x60, 0x00, 0xBF, 0x80
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0027[  7] = { /* code 0027, APOSTROPHE */
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0028[ 69] = { /* code 0028, LEFT PARENTHESIS */
  0x00, 0x06, 0xB0,
  0x00, 0x2E, 0x30,
  0x00, 0xBB, 0x00,
  0x04, 0xF5, 0x00,
  0x0A, 0xE0, 0x00,
  0x1F, 0xB0, 0x00,
  0x5F, 0x70, 0x00,
  0x9F, 0x40, 0x00,
  0xCF, 0x20, 0x00,
  0xDF, 0x10, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xDF, 0x10, 0x00,
  0xCF, 0x20, 0x00,
  0x9F, 0x40, 0x00,
  0x5F, 0x70, 0x00,
  0x1F, 0xB0, 0x00,
  0x0A, 0xE0, 0x00,
  0x04, 0xF5, 0x00,
  0x00, 0xBB, 0x00,
  0x00, 0x2E, 0x30,
  0x00, 0x06, 0xB0
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0029[ 69] = { /* code 0029, RIGHT PARENTHESIS */
  0xB6, 0x00, 0x00,
  0x3E, 0x20, 0x00,
  0x0B, 0xB0, 0x00,
  0x05, 0xF4, 0x00,
  0x00, 0xEA, 0x00,
  0x00, 0xAF, 0x10,
  0x00, 0x7F, 0x50,
  0x00, 0x4F, 0x90,
  0x00, 0x2F, 0xC0,
  0x00, 0x1F, 0xD0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x1F, 0xD0,
  0x00, 0x2F, 0xC0,
  0x00, 0x4F, 0x90,
  0x00, 0x7F, 0x50,
  0x00, 0xBF, 0x10,
  0x00, 0xEA, 0x00,
  0x05, 0xF4, 0x00,
  0x0B, 0xB0, 0x00,
  0x3E, 0x20, 0x00,
  0xB6, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_002A[ 45] = { /* code 002A, ASTERISK */
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0xA8, 0x20, 0xF0, 0x28, 0x80,
  0xAF, 0xFB, 0xFB, 0xFE, 0x90,
  0x01, 0x5B, 0xFB, 0x50, 0x00,
  0x00, 0x1D, 0xCD, 0x10, 0x00,
  0x00, 0xAC, 0x0C, 0xA0, 0x00,
  0x05, 0xF4, 0x04, 0xF6, 0x00,
  0x04, 0x90, 0x00, 0x95, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_002B[120] = { /* code 002B, PLUS SIGN */
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_002C[  6] = { /* code 002C, COMMA */
  0xFF,
  0xFF,
  0x0F,
  0x1F,
  0x8B,
  0xB1
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_002D[  6] = { /* code 002D, HYPHEN-MINUS */
  0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_002E[  2] = { /* code 002E, FULL STOP */
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_002F[ 84] = { /* code 002F, SOLIDUS */
  0x00, 0x00, 0x00, 0x7C,
  0x00, 0x00, 0x00, 0xB7,
  0x00, 0x00, 0x01, 0xF2,
  0x00, 0x00, 0x06, 0xC0,
  0x00, 0x00, 0x0B, 0x70,
  0x00, 0x00, 0x1F, 0x20,
  0x00, 0x00, 0x5C, 0x00,
  0x00, 0x00, 0xA7, 0x00,
  0x00, 0x00, 0xE2, 0x00,
  0x00, 0x05, 0xC0, 0x00,
  0x00, 0x0A, 0x70, 0x00,
  0x00, 0x0E, 0x20, 0x00,
  0x00, 0x4C, 0x00, 0x00,
  0x00, 0x97, 0x00, 0x00,
  0x00, 0xE2, 0x00, 0x00,
  0x03, 0xC0, 0x00, 0x00,
  0x08, 0x70, 0x00, 0x00,
  0x0D, 0x20, 0x00, 0x00,
  0x3C, 0x00, 0x00, 0x00,
  0x87, 0x00, 0x00, 0x00,
  0xD2, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0030[102] = { /* code 0030, DIGIT ZERO */
  0x00, 0x29, 0xEF, 0xE9, 0x20, 0x00,
  0x02, 0xEC, 0x30, 0x3C, 0xE2, 0x00,
  0x0C, 0xF2, 0x00, 0x02, 0xEB, 0x00,
  0x4F, 0x90, 0x00, 0x00, 0x9F, 0x30,
  0x8F, 0x50, 0x00, 0x00, 0x5F, 0x80,
  0xCF, 0x30, 0x00, 0x00, 0x3F, 0xB0,
  0xDF, 0x10, 0x00, 0x00, 0x1F, 0xD0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xDF, 0x10, 0x00, 0x00, 0x1F, 0xD0,
  0xCF, 0x30, 0x00, 0x00, 0x3F, 0xC0,
  0x8F, 0x50, 0x00, 0x00, 0x5F, 0x80,
  0x4F, 0x90, 0x00, 0x00, 0x9F, 0x40,
  0x0C, 0xF2, 0x00, 0x02, 0xEC, 0x00,
  0x02, 0xEC, 0x30, 0x3C, 0xE2, 0x00,
  0x00, 0x29, 0xEF, 0xE9, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0031[ 51] = { /* code 0031, DIGIT ONE */
  0x00, 0x00, 0xDF,
  0x00, 0x03, 0xFF,
  0x02, 0x6E, 0xFF,
  0xFE, 0xC6, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0032[102] = { /* code 0032, DIGIT TWO */
  0x00, 0x3A, 0xEF, 0xFB, 0x60, 0x00,
  0x06, 0xFB, 0x30, 0x18, 0xFA, 0x00,
  0x2F, 0xC0, 0x00, 0x00, 0x9F, 0x60,
  0x9F, 0x50, 0x00, 0x00, 0x3F, 0xC0,
  0xCF, 0x20, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x4F, 0xC0,
  0x00, 0x00, 0x00, 0x00, 0xCF, 0x60,
  0x00, 0x00, 0x00, 0x1B, 0xFB, 0x00,
  0x00, 0x00, 0x03, 0xDF, 0x90, 0x00,
  0x00, 0x00, 0x8F, 0xC3, 0x00, 0x00,
  0x00, 0x3D, 0xE7, 0x00, 0x00, 0x00,
  0x03, 0xEB, 0x20, 0x00, 0x00, 0x00,
  0x2E, 0xA0, 0x00, 0x00, 0x00, 0x00,
  0x9E, 0x10, 0x00, 0x00, 0x00, 0x00,
  0xE9, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD0
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0033[102] = { /* code 0033, DIGIT THREE */
  0x00, 0x18, 0xDF, 0xEA, 0x20, 0x00,
  0x00, 0xCE, 0x40, 0x3E, 0xE2, 0x00,
  0x07, 0xF7, 0x00, 0x05, 0xF9, 0x00,
  0x0C, 0xF3, 0x00, 0x01, 0xFE, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x01, 0xFE, 0x00,
  0x00, 0x00, 0x00, 0x06, 0xF8, 0x00,
  0x00, 0x00, 0x00, 0x5E, 0xB1, 0x00,
  0x00, 0x00, 0x6F, 0xFD, 0x40, 0x00,
  0x00, 0x00, 0x00, 0x27, 0xEB, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x6F, 0x80,
  0xFF, 0x00, 0x00, 0x00, 0x1F, 0xE0,
  0xDF, 0x20, 0x00, 0x00, 0x0F, 0xF0,
  0xAF, 0x50, 0x00, 0x00, 0x2F, 0xD0,
  0x3F, 0xC0, 0x00, 0x00, 0x8F, 0x70,
  0x07, 0xFA, 0x20, 0x28, 0xFB, 0x00,
  0x00, 0x3A, 0xEF, 0xEB, 0x60, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0034[102] = { /* code 0034, DIGIT FOUR */
  0x00, 0x00, 0x00, 0x1E, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0xAF, 0xF0, 0x00,
  0x00, 0x00, 0x04, 0xCF, 0xF0, 0x00,
  0x00, 0x00, 0x1D, 0x4F, 0xF0, 0x00,
  0x00, 0x00, 0x8A, 0x0F, 0xF0, 0x00,
  0x00, 0x03, 0xE2, 0x0F, 0xF0, 0x00,
  0x00, 0x0C, 0x80, 0x0F, 0xF0, 0x00,
  0x00, 0x7E, 0x10, 0x0F, 0xF0, 0x00,
  0x02, 0xE6, 0x00, 0x0F, 0xF0, 0x00,
  0x0B, 0xC0, 0x00, 0x0F, 0xF0, 0x00,
  0x5F, 0x40, 0x00, 0x0F, 0xF0, 0x00,
  0xDA, 0x00, 0x00, 0x0F, 0xF0, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0035[102] = { /* code 0035, DIGIT FIVE */
  0x00, 0xDF, 0xFF, 0xFF, 0xFF, 0x00,
  0x01, 0xF3, 0x00, 0x00, 0x00, 0x00,
  0x04, 0xF0, 0x00, 0x00, 0x00, 0x00,
  0x07, 0xD0, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0xB0, 0x00, 0x00, 0x00, 0x00,
  0x0C, 0xBA, 0xEF, 0xFB, 0x40, 0x00,
  0x1F, 0xF9, 0x20, 0x3B, 0xF7, 0x00,
  0x3F, 0x90, 0x00, 0x01, 0xDF, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x6F, 0xA0,
  0x00, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xEF, 0x00, 0x00, 0x00, 0x1F, 0xD0,
  0xBF, 0x30, 0x00, 0x00, 0x5F, 0x90,
  0x4F, 0xB0, 0x00, 0x00, 0xCF, 0x20,
  0x08, 0xFA, 0x20, 0x2B, 0xF5, 0x00,
  0x00, 0x4B, 0xEF, 0xEA, 0x30, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0036[102] = { /* code 0036, DIGIT SIX */
  0x00, 0x05, 0xBE, 0xFE, 0xA3, 0x00,
  0x00, 0xAE, 0x51, 0x04, 0xDF, 0x50,
  0x07, 0xF4, 0x00, 0x00, 0x2F, 0xD0,
  0x1E, 0xB0, 0x00, 0x00, 0x00, 0x00,
  0x6F, 0x60, 0x00, 0x00, 0x00, 0x00,
  0xAF, 0x34, 0xBF, 0xFC, 0x60, 0x00,
  0xCF, 0x6D, 0x50, 0x29, 0xF8, 0x00,
  0xEF, 0xE4, 0x00, 0x00, 0xBF, 0x40,
  0xFF, 0xB0, 0x00, 0x00, 0x5F, 0xA0,
  0xFF, 0x70, 0x00, 0x00, 0x2F, 0xD0,
  0xFF, 0x60, 0x00, 0x00, 0x0F, 0xF0,
  0xDF, 0x60, 0x00, 0x00, 0x0F, 0xF0,
  0xAF, 0x70, 0x00, 0x00, 0x1F, 0xD0,
  0x5F, 0xB0, 0x00, 0x00, 0x4F, 0xA0,
  0x0D, 0xF3, 0x00, 0x00, 0xBF, 0x30,
  0x02, 0xEE, 0x40, 0x19, 0xF7, 0x00,
  0x00, 0x29, 0xDF, 0xFB, 0x40, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0037[102] = { /* code 0037, DIGIT SEVEN */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x3F, 0x90,
  0x00, 0x00, 0x00, 0x01, 0xDC, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0xE2, 0x00,
  0x00, 0x00, 0x00, 0x5F, 0x70, 0x00,
  0x00, 0x00, 0x00, 0xDC, 0x00, 0x00,
  0x00, 0x00, 0x07, 0xF4, 0x00, 0x00,
  0x00, 0x00, 0x1E, 0xB0, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0x40, 0x00, 0x00,
  0x00, 0x00, 0xDD, 0x00, 0x00, 0x00,
  0x00, 0x04, 0xF7, 0x00, 0x00, 0x00,
  0x00, 0x0A, 0xF2, 0x00, 0x00, 0x00,
  0x00, 0x0E, 0xD0, 0x00, 0x00, 0x00,
  0x00, 0x4F, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x7F, 0x50, 0x00, 0x00, 0x00,
  0x00, 0xBF, 0x20, 0x00, 0x00, 0x00,
  0x00, 0xEE, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0038[102] = { /* code 0038, DIGIT EIGHT */
  0x00, 0x19, 0xEF, 0xE9, 0x20, 0x00,
  0x01, 0xEE, 0x40, 0x4E, 0xE1, 0x00,
  0x09, 0xF6, 0x00, 0x06, 0xF9, 0x00,
  0x0D, 0xF1, 0x00, 0x01, 0xFD, 0x00,
  0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00,
  0x0E, 0xF1, 0x00, 0x01, 0xFE, 0x00,
  0x08, 0xF5, 0x00, 0x05, 0xF8, 0x00,
  0x01, 0xBE, 0x30, 0x3E, 0xB1, 0x00,
  0x00, 0x3D, 0xFF, 0xFD, 0x20, 0x00,
  0x08, 0xF7, 0x10, 0x28, 0xF8, 0x00,
  0x7F, 0x70, 0x00, 0x00, 0x7F, 0x70,
  0xDF, 0x10, 0x00, 0x00, 0x1F, 0xD0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xDF, 0x20, 0x00, 0x00, 0x2F, 0xD0,
  0x7F, 0x90, 0x00, 0x00, 0x9F, 0x70,
  0x0B, 0xF9, 0x20, 0x28, 0xFB, 0x00,
  0x00, 0x6B, 0xEF, 0xEB, 0x60, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0039[102] = { /* code 0039, DIGIT NINE */
  0x00, 0x4B, 0xFF, 0xD9, 0x20, 0x00,
  0x07, 0xF9, 0x10, 0x4E, 0xE2, 0x00,
  0x3F, 0xB0, 0x00, 0x03, 0xFD, 0x00,
  0xAF, 0x40, 0x00, 0x00, 0xBF, 0x50,
  0xDF, 0x10, 0x00, 0x00, 0x7F, 0xA0,
  0xFF, 0x00, 0x00, 0x00, 0x6F, 0xD0,
  0xFF, 0x00, 0x00, 0x00, 0x6F, 0xF0,
  0xDF, 0x20, 0x00, 0x00, 0x7F, 0xF0,
  0xAF, 0x50, 0x00, 0x00, 0xBF, 0xF0,
  0x4F, 0xB0, 0x00, 0x03, 0xEF, 0xE0,
  0x08, 0xF9, 0x20, 0x4D, 0x6F, 0xC0,
  0x00, 0x6C, 0xFF, 0xB4, 0x3F, 0xA0,
  0x00, 0x00, 0x00, 0x00, 0x6F, 0x60,
  0x00, 0x00, 0x00, 0x00, 0xBE, 0x10,
  0xDF, 0x20, 0x00, 0x03, 0xF7, 0x00,
  0x5F, 0xD4, 0x00, 0x5E, 0xA0, 0x00,
  0x03, 0xAE, 0xFE, 0xB5, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_003A[ 13] = { /* code 003A, COLON */
  0xFF,
  0xFF,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_003B[ 17] = { /* code 003B, SEMICOLON */
  0xFF,
  0xFF,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0xFF,
  0xFF,
  0x0F,
  0x1F,
  0x9B,
  0xB1
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_003C[ 91] = { /* code 003C, LESS-THAN SIGN */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5C,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x7D, 0xC5,
  0x00, 0x00, 0x00, 0x02, 0x9E, 0xA3, 0x00,
  0x00, 0x00, 0x04, 0xBE, 0x81, 0x00, 0x00,
  0x00, 0x06, 0xDC, 0x60, 0x00, 0x00, 0x00,
  0x28, 0xEA, 0x40, 0x00, 0x00, 0x00, 0x00,
  0xFE, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x28, 0xEA, 0x30, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x16, 0xDC, 0x50, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x04, 0xBE, 0x71, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x9E, 0x93, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x7D, 0xB5,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5C
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_003D[ 40] = { /* code 003D, EQUALS SIGN */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_003E[ 91] = { /* code 003E, GREATER-THAN SIGN */
  0xC5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5C, 0xD7, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x3A, 0xE9, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x18, 0xEB, 0x40, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x06, 0xCD, 0x60, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0xAE, 0x82,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xEF,
  0x00, 0x00, 0x00, 0x00, 0x03, 0xAE, 0x82,
  0x00, 0x00, 0x00, 0x05, 0xCD, 0x61, 0x00,
  0x00, 0x00, 0x17, 0xEB, 0x40, 0x00, 0x00,
  0x00, 0x39, 0xE9, 0x30, 0x00, 0x00, 0x00,
  0x5B, 0xD7, 0x10, 0x00, 0x00, 0x00, 0x00,
  0xC5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_003F[108] = { /* code 003F, QUESTION MARK */
  0x00, 0x3A, 0xEF, 0xFC, 0x70, 0x00,
  0x06, 0xFB, 0x30, 0x17, 0xFB, 0x00,
  0x3F, 0xC0, 0x00, 0x00, 0x7F, 0x70,
  0x9F, 0x50, 0x00, 0x00, 0x2F, 0xD0,
  0xDF, 0x20, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x2F, 0xE0,
  0x00, 0x00, 0x00, 0x00, 0x6F, 0xA0,
  0x00, 0x00, 0x00, 0x00, 0xDE, 0x20,
  0x00, 0x00, 0x00, 0x07, 0xE3, 0x00,
  0x00, 0x00, 0x00, 0x5F, 0x50, 0x00,
  0x00, 0x00, 0x04, 0xF9, 0x00, 0x00,
  0x00, 0x00, 0x0B, 0xF2, 0x00, 0x00,
  0x00, 0x00, 0x0D, 0xD0, 0x00, 0x00,
  0x00, 0x00, 0x0D, 0xD0, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0040[231] = { /* code 0040, COMMERCIAL AT */
  0x00, 0x00, 0x00, 0x04, 0x8C, 0xEF, 0xFE, 0xC8, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x04, 0xCC, 0x73, 0x10, 0x01, 0x37, 0xCC, 0x30, 0x00,
  0x00, 0x01, 0xAC, 0x40, 0x00, 0x00, 0x00, 0x00, 0x05, 0xD6, 0x00,
  0x00, 0x1B, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1D, 0x50,
  0x00, 0xB9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xD1,
  0x06, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x88,
  0x0E, 0x30, 0x00, 0x00, 0x29, 0xEF, 0xD6, 0x06, 0x20, 0x00, 0x3C,
  0x5B, 0x00, 0x00, 0x02, 0xD7, 0x10, 0x3B, 0x7F, 0x00, 0x00, 0x0F,
  0xA6, 0x00, 0x00, 0x1D, 0x50, 0x00, 0x01, 0xEB, 0x00, 0x00, 0x0F,
  0xD2, 0x00, 0x00, 0x79, 0x00, 0x00, 0x00, 0xC7, 0x00, 0x00, 0x1E,
  0xF0, 0x00, 0x00, 0xC3, 0x00, 0x00, 0x01, 0xF3, 0x00, 0x00, 0x5B,
  0xF0, 0x00, 0x00, 0xF1, 0x00, 0x00, 0x05, 0xE0, 0x00, 0x00, 0xB6,
  0xE1, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x0A, 0xA0, 0x00, 0x04, 0xD0,
  0xC3, 0x00, 0x00, 0xD3, 0x00, 0x00, 0x4F, 0x60, 0x00, 0x2D, 0x30,
  0x78, 0x00, 0x00, 0x7D, 0x30, 0x17, 0x9D, 0x90, 0x27, 0xE4, 0x00,
  0x1E, 0x10, 0x00, 0x07, 0xDF, 0xE7, 0x06, 0xEF, 0xD9, 0x20, 0x00,
  0x07, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xA9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x09, 0xC3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x61, 0x00,
  0x00, 0x00, 0x4C, 0xB7, 0x31, 0x00, 0x13, 0x58, 0xB6, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x38, 0xBD, 0xFF, 0xEC, 0x95, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0041[144] = { /* code 0041, LATIN CAPITAL LETTER A */
  0x00, 0x00, 0x00, 0x4F, 0xF2, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xAF, 0xF8, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0xF9, 0xCE, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x06, 0xF4, 0x6F, 0x50, 0x00, 0x00,
  0x00, 0x00, 0x0C, 0xD0, 0x1E, 0xB0, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0x70, 0x09, 0xF2, 0x00, 0x00,
  0x00, 0x00, 0x9F, 0x10, 0x03, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0xEA, 0x00, 0x00, 0xCD, 0x00, 0x00,
  0x00, 0x05, 0xF4, 0x00, 0x00, 0x7F, 0x40, 0x00,
  0x00, 0x0B, 0xD0, 0x00, 0x00, 0x1F, 0xA0, 0x00,
  0x00, 0x2F, 0x80, 0x00, 0x00, 0x0A, 0xF1, 0x00,
  0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0x00, 0xD9, 0x00, 0x00, 0x00, 0x00, 0xBD, 0x00,
  0x04, 0xF4, 0x00, 0x00, 0x00, 0x00, 0x5F, 0x30,
  0x0A, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x90,
  0x1F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0A, 0xF1,
  0x6F, 0x30, 0x00, 0x00, 0x00, 0x00, 0x05, 0xF6,
  0xCC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEC
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0042[126] = { /* code 0042, LATIN CAPITAL LETTER B */
  0xFF, 0xFF, 0xFF, 0xFE, 0xC7, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x03, 0x7E, 0xB1, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x06, 0xF8, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x01, 0xFD, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x01, 0xFD, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x07, 0xF7, 0x00,
  0xFF, 0x00, 0x00, 0x03, 0x8F, 0x90, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0x30, 0x00,
  0xFF, 0x00, 0x00, 0x01, 0x4B, 0xF7, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xBF, 0x50,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xB0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xC0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x8F, 0x70,
  0xFF, 0x00, 0x00, 0x01, 0x39, 0xFB, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xDC, 0x70, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0043[144] = { /* code 0043, LATIN CAPITAL LETTER C */
  0x00, 0x00, 0x5A, 0xDF, 0xFD, 0xA4, 0x00, 0x00,
  0x00, 0x1C, 0xE7, 0x30, 0x03, 0xAF, 0xB1, 0x00,
  0x01, 0xDE, 0x20, 0x00, 0x00, 0x07, 0xFB, 0x00,
  0x0A, 0xF4, 0x00, 0x00, 0x00, 0x00, 0xBF, 0x60,
  0x3F, 0xB0, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xB0,
  0x8F, 0x60, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xE0,
  0xCF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xEF, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xEF, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xBF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x8F, 0x70, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xE0,
  0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xB0,
  0x0A, 0xF5, 0x00, 0x00, 0x00, 0x00, 0xAF, 0x60,
  0x01, 0xDE, 0x30, 0x00, 0x00, 0x06, 0xFB, 0x00,
  0x00, 0x2C, 0xF8, 0x30, 0x03, 0x9F, 0xB1, 0x00,
  0x00, 0x00, 0x5B, 0xEF, 0xFD, 0xA4, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0044[126] = { /* code 0044, LATIN CAPITAL LETTER D */
  0xFF, 0xFF, 0xFF, 0xFE, 0xC8, 0x20, 0x00,
  0xFF, 0x00, 0x00, 0x02, 0x5C, 0xF5, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xBF, 0x40,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xD0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x09, 0xF5,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x05, 0xF9,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x02, 0xFC,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x02, 0xFC,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x05, 0xF9,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x09, 0xF5,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xD0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xAF, 0x40,
  0xFF, 0x00, 0x00, 0x01, 0x4B, 0xF6, 0x00,
  0xFF, 0xFF, 0xFF, 0xFE, 0xC8, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0045[108] = { /* code 0045, LATIN CAPITAL LETTER E */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0046[108] = { /* code 0046, LATIN CAPITAL LETTER F */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x20,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0047[144] = { /* code 0047, LATIN CAPITAL LETTER G */
  0x00, 0x00, 0x39, 0xCF, 0xFF, 0xC9, 0x30, 0x00,
  0x00, 0x1A, 0xF9, 0x31, 0x01, 0x4A, 0xFB, 0x10,
  0x01, 0xBE, 0x40, 0x00, 0x00, 0x00, 0x5F, 0xD1,
  0x09, 0xF5, 0x00, 0x00, 0x00, 0x00, 0x09, 0xF8,
  0x2F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x02, 0xFD,
  0x8F, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xBF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xEF, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF,
  0xEF, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xBF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF,
  0x8F, 0x70, 0x00, 0x00, 0x00, 0x00, 0x04, 0xFF,
  0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x09, 0xFF,
  0x0A, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xFF,
  0x01, 0xDE, 0x40, 0x00, 0x00, 0x01, 0xCA, 0xDF,
  0x00, 0x1C, 0xF8, 0x30, 0x02, 0x7E, 0x90, 0xBF,
  0x00, 0x00, 0x5A, 0xEF, 0xFD, 0x93, 0x00, 0xAF
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0048[126] = { /* code 0048, LATIN CAPITAL LETTER H */
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0049[ 18] = { /* code 0049, LATIN CAPITAL LETTER I */
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_004A[ 90] = { /* code 004A, LATIN CAPITAL LETTER J */
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xEF, 0x10, 0x00, 0x02, 0xFD,
  0xAF, 0x60, 0x00, 0x06, 0xF8,
  0x2E, 0xE4, 0x01, 0x5E, 0xD1,
  0x02, 0x9D, 0xFF, 0xC8, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_004B[126] = { /* code 004B, LATIN CAPITAL LETTER K */
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xA0,
  0xFF, 0x00, 0x00, 0x00, 0x05, 0xFA, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x5F, 0xB0, 0x00,
  0xFF, 0x00, 0x00, 0x04, 0xFB, 0x10, 0x00,
  0xFF, 0x00, 0x00, 0x3E, 0xB1, 0x00, 0x00,
  0xFF, 0x00, 0x03, 0xED, 0x10, 0x00, 0x00,
  0xFF, 0x00, 0x2E, 0xD1, 0x00, 0x00, 0x00,
  0xFF, 0x02, 0xEF, 0x30, 0x00, 0x00, 0x00,
  0xFF, 0x2E, 0xEE, 0xC0, 0x00, 0x00, 0x00,
  0xFF, 0xDE, 0x26, 0xF8, 0x00, 0x00, 0x00,
  0xFF, 0xE2, 0x00, 0x9F, 0x50, 0x00, 0x00,
  0xFF, 0x30, 0x00, 0x1C, 0xE2, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x03, 0xEC, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x6F, 0x90, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x09, 0xF5, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x01, 0xCE, 0x20,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x3E, 0xC1,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x06, 0xF9
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_004C[108] = { /* code 004C, LATIN CAPITAL LETTER L */
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_004D[144] = { /* code 004D, LATIN CAPITAL LETTER M */
  0xFF, 0xB0, 0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF,
  0xFF, 0xF2, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xFF,
  0xFF, 0xE7, 0x00, 0x00, 0x00, 0x00, 0x7E, 0xFF,
  0xFF, 0x9B, 0x00, 0x00, 0x00, 0x00, 0xC9, 0xFF,
  0xFF, 0x5F, 0x20, 0x00, 0x00, 0x02, 0xF5, 0xFF,
  0xFF, 0x0E, 0x70, 0x00, 0x00, 0x07, 0xE0, 0xFF,
  0xFF, 0x0A, 0xC0, 0x00, 0x00, 0x0D, 0xA0, 0xFF,
  0xFF, 0x05, 0xF2, 0x00, 0x00, 0x3F, 0x50, 0xFF,
  0xFF, 0x01, 0xF7, 0x00, 0x00, 0x8F, 0x10, 0xFF,
  0xFF, 0x00, 0xBC, 0x00, 0x00, 0xDB, 0x00, 0xFF,
  0xFF, 0x00, 0x6F, 0x30, 0x03, 0xF6, 0x00, 0xFF,
  0xFF, 0x00, 0x1F, 0x80, 0x08, 0xF1, 0x00, 0xFF,
  0xFF, 0x00, 0x0B, 0xD0, 0x0D, 0xB0, 0x00, 0xFF,
  0xFF, 0x00, 0x07, 0xF3, 0x3F, 0x70, 0x00, 0xFF,
  0xFF, 0x00, 0x02, 0xF8, 0x8F, 0x20, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xCD, 0xDC, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x2F, 0xF2, 0x00, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_004E[126] = { /* code 004E, LATIN CAPITAL LETTER N */
  0xFF, 0x30, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0xE7, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x6F, 0x20, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x0B, 0xC0, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x02, 0xE7, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x6F, 0x20, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x0B, 0xB0, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x02, 0xE6, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x6E, 0x20, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x0C, 0xB0, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x02, 0xF6, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x7E, 0x20, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x0C, 0xB0, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x02, 0xF6, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x7E, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0C, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_004F[144] = { /* code 004F, LATIN CAPITAL LETTER O */
  0x00, 0x00, 0x5A, 0xDF, 0xFD, 0xA4, 0x00, 0x00,
  0x00, 0x1B, 0xF9, 0x30, 0x03, 0x8F, 0xB1, 0x00,
  0x01, 0xDF, 0x40, 0x00, 0x00, 0x04, 0xED, 0x10,
  0x0A, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x6F, 0x90,
  0x3F, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x0C, 0xF3,
  0x8F, 0x70, 0x00, 0x00, 0x00, 0x00, 0x07, 0xF8,
  0xBF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFB,
  0xEF, 0x10, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xEF, 0x10, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0xBF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFB,
  0x8F, 0x70, 0x00, 0x00, 0x00, 0x00, 0x07, 0xF8,
  0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x0C, 0xF3,
  0x0A, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x6F, 0x90,
  0x01, 0xDE, 0x30, 0x00, 0x00, 0x04, 0xED, 0x10,
  0x00, 0x1B, 0xF8, 0x30, 0x03, 0x8F, 0xB1, 0x00,
  0x00, 0x00, 0x5A, 0xDF, 0xFD, 0xA4, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0050[108] = { /* code 0050, LATIN CAPITAL LETTER P */
  0xFF, 0xFF, 0xFF, 0xFE, 0xB6, 0x00,
  0xFF, 0x00, 0x00, 0x02, 0x8F, 0xB0,
  0xFF, 0x00, 0x00, 0x00, 0x08, 0xF7,
  0xFF, 0x00, 0x00, 0x00, 0x03, 0xFC,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x03, 0xFC,
  0xFF, 0x00, 0x00, 0x00, 0x09, 0xF6,
  0xFF, 0x00, 0x00, 0x13, 0xAF, 0xA0,
  0xFF, 0xFF, 0xFF, 0xFD, 0xA4, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0051[152] = { /* code 0051, LATIN CAPITAL LETTER Q */
  0x00, 0x00, 0x5A, 0xDF, 0xFD, 0xA4, 0x00, 0x00,
  0x00, 0x1B, 0xF9, 0x30, 0x03, 0x8F, 0xB1, 0x00,
  0x01, 0xDF, 0x40, 0x00, 0x00, 0x03, 0xEC, 0x10,
  0x0A, 0xF6, 0x00, 0x00, 0x00, 0x00, 0x6F, 0x90,
  0x3F, 0xD0, 0x00, 0x00, 0x00, 0x00, 0x0C, 0xF2,
  0x8F, 0x70, 0x00, 0x00, 0x00, 0x00, 0x07, 0xF7,
  0xBF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFB,
  0xEF, 0x10, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xEF, 0x10, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0xCF, 0x30, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFC,
  0x8F, 0x70, 0x00, 0x00, 0x00, 0x00, 0x07, 0xF8,
  0x3F, 0xC0, 0x00, 0x00, 0x08, 0x50, 0x0D, 0xF3,
  0x0A, 0xF6, 0x00, 0x00, 0x0B, 0xF5, 0x7F, 0xA0,
  0x01, 0xDE, 0x40, 0x00, 0x01, 0xBF, 0xFD, 0x10,
  0x00, 0x1C, 0xF8, 0x30, 0x03, 0xAF, 0xF9, 0x00,
  0x00, 0x00, 0x5B, 0xEF, 0xFE, 0xB6, 0x8F, 0xD5,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xC6
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0052[126] = { /* code 0052, LATIN CAPITAL LETTER R */
  0xFF, 0xFF, 0xFF, 0xFF, 0xDB, 0x50, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x3A, 0xFA, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xAF, 0x60,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xB0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xAF, 0x40,
  0xFF, 0x00, 0x00, 0x01, 0x4B, 0xF6, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x30, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x4D, 0xE3, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x05, 0xFA, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x02, 0xFD, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xEF, 0x20,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xBF, 0x40,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x9F, 0x60,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xB0
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0053[108] = { /* code 0053, LATIN CAPITAL LETTER S */
  0x00, 0x6C, 0xEF, 0xEB, 0x50, 0x00,
  0x1B, 0xF7, 0x10, 0x29, 0xFA, 0x00,
  0x8F, 0x70, 0x00, 0x00, 0xAF, 0x60,
  0xEF, 0x10, 0x00, 0x00, 0x3F, 0xC0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xDF, 0x30, 0x00, 0x00, 0x00, 0x00,
  0x8F, 0xC2, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0xFF, 0xB6, 0x20, 0x00, 0x00,
  0x00, 0x39, 0xDF, 0xFD, 0x71, 0x00,
  0x00, 0x00, 0x03, 0x7C, 0xFF, 0x60,
  0x00, 0x00, 0x00, 0x00, 0x5E, 0xF5,
  0x00, 0x00, 0x00, 0x00, 0x06, 0xFC,
  0xFF, 0x00, 0x00, 0x00, 0x01, 0xFF,
  0xDF, 0x20, 0x00, 0x00, 0x00, 0xFF,
  0xAF, 0x70, 0x00, 0x00, 0x02, 0xFC,
  0x3F, 0xE1, 0x00, 0x00, 0x09, 0xF6,
  0x05, 0xFD, 0x51, 0x02, 0x9F, 0x80,
  0x00, 0x29, 0xDF, 0xFE, 0xA4, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0054[126] = { /* code 0054, LATIN CAPITAL LETTER T */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0055[126] = { /* code 0055, LATIN CAPITAL LETTER U */
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x10, 0x00, 0x00, 0x00, 0x01, 0xFF,
  0xCF, 0x30, 0x00, 0x00, 0x00, 0x03, 0xFC,
  0x7F, 0x80, 0x00, 0x00, 0x00, 0x08, 0xF7,
  0x1E, 0xE2, 0x00, 0x00, 0x00, 0x2E, 0xE1,
  0x03, 0xDE, 0x72, 0x00, 0x27, 0xED, 0x20,
  0x00, 0x16, 0xBE, 0xFF, 0xEB, 0x60, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0056[126] = { /* code 0056, LATIN CAPITAL LETTER V */
  0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xBD,
  0x8F, 0x20, 0x00, 0x00, 0x00, 0x02, 0xF8,
  0x3F, 0x70, 0x00, 0x00, 0x00, 0x07, 0xF3,
  0x0D, 0xC0, 0x00, 0x00, 0x00, 0x0C, 0xD0,
  0x08, 0xF2, 0x00, 0x00, 0x00, 0x2F, 0x80,
  0x03, 0xF8, 0x00, 0x00, 0x00, 0x7F, 0x30,
  0x00, 0xDD, 0x00, 0x00, 0x00, 0xCD, 0x00,
  0x00, 0x8F, 0x30, 0x00, 0x02, 0xF8, 0x00,
  0x00, 0x3F, 0x80, 0x00, 0x07, 0xF3, 0x00,
  0x00, 0x0D, 0xD0, 0x00, 0x0C, 0xD0, 0x00,
  0x00, 0x08, 0xF3, 0x00, 0x2F, 0x80, 0x00,
  0x00, 0x03, 0xF8, 0x00, 0x7F, 0x30, 0x00,
  0x00, 0x00, 0xDD, 0x00, 0xDD, 0x00, 0x00,
  0x00, 0x00, 0x8F, 0x33, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0x88, 0xF3, 0x00, 0x00,
  0x00, 0x00, 0x0D, 0xDD, 0xD0, 0x00, 0x00,
  0x00, 0x00, 0x08, 0xFF, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x03, 0xFF, 0x30, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0057[198] = { /* code 0057, LATIN CAPITAL LETTER W */
  0xD7, 0x00, 0x00, 0x00, 0x02, 0xFF, 0x10, 0x00, 0x00, 0x0C, 0xD0,
  0xAB, 0x00, 0x00, 0x00, 0x07, 0xFF, 0x40, 0x00, 0x00, 0x1F, 0x90,
  0x7F, 0x00, 0x00, 0x00, 0x0C, 0xCE, 0x70, 0x00, 0x00, 0x6F, 0x40,
  0x3F, 0x30, 0x00, 0x00, 0x2F, 0x7B, 0xA0, 0x00, 0x00, 0xAF, 0x10,
  0x0F, 0x70, 0x00, 0x00, 0x6F, 0x38, 0xD0, 0x00, 0x00, 0xEB, 0x00,
  0x0C, 0xB0, 0x00, 0x00, 0xBD, 0x05, 0xF1, 0x00, 0x03, 0xF7, 0x00,
  0x08, 0xE0, 0x00, 0x01, 0xF8, 0x03, 0xF4, 0x00, 0x07, 0xF3, 0x00,
  0x05, 0xF3, 0x00, 0x05, 0xF4, 0x00, 0xF7, 0x00, 0x0B, 0xE0, 0x00,
  0x02, 0xF6, 0x00, 0x0A, 0xE0, 0x00, 0xCA, 0x00, 0x1F, 0xA0, 0x00,
  0x00, 0xDA, 0x00, 0x1F, 0xA0, 0x00, 0x9C, 0x00, 0x5F, 0x50, 0x00,
  0x00, 0xAE, 0x00, 0x5F, 0x50, 0x00, 0x6F, 0x10, 0x9F, 0x10, 0x00,
  0x00, 0x7F, 0x20, 0xAF, 0x10, 0x00, 0x3F, 0x30, 0xDC, 0x00, 0x00,
  0x00, 0x3F, 0x60, 0xEB, 0x00, 0x00, 0x1F, 0x62, 0xF8, 0x00, 0x00,
  0x00, 0x0F, 0x94, 0xF6, 0x00, 0x00, 0x0D, 0x97, 0xF4, 0x00, 0x00,
  0x00, 0x0C, 0xD9, 0xF1, 0x00, 0x00, 0x0A, 0xCB, 0xE0, 0x00, 0x00,
  0x00, 0x08, 0xFE, 0xB0, 0x00, 0x00, 0x07, 0xFF, 0xB0, 0x00, 0x00,
  0x00, 0x05, 0xFF, 0x70, 0x00, 0x00, 0x04, 0xFF, 0x60, 0x00, 0x00,
  0x00, 0x02, 0xFF, 0x20, 0x00, 0x00, 0x01, 0xFF, 0x20, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0058[126] = { /* code 0058, LATIN CAPITAL LETTER X */
  0xAF, 0x60, 0x00, 0x00, 0x00, 0x05, 0xFA,
  0x1D, 0xE2, 0x00, 0x00, 0x00, 0x1E, 0xD1,
  0x04, 0xFB, 0x00, 0x00, 0x00, 0xAF, 0x40,
  0x00, 0x9F, 0x60, 0x00, 0x06, 0xF9, 0x00,
  0x00, 0x1D, 0xE2, 0x00, 0x2E, 0xD1, 0x00,
  0x00, 0x03, 0xFB, 0x00, 0xBF, 0x40, 0x00,
  0x00, 0x00, 0x7F, 0x76, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0x0C, 0xFE, 0xD0, 0x00, 0x00,
  0x00, 0x00, 0x03, 0xFF, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x07, 0xFF, 0x70, 0x00, 0x00,
  0x00, 0x00, 0x2F, 0xCB, 0xF2, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0x32, 0xFB, 0x00, 0x00,
  0x00, 0x06, 0xF8, 0x00, 0x7F, 0x60, 0x00,
  0x00, 0x2E, 0xD0, 0x00, 0x0C, 0xE2, 0x00,
  0x00, 0xBF, 0x30, 0x00, 0x03, 0xFB, 0x00,
  0x06, 0xF9, 0x00, 0x00, 0x00, 0x8F, 0x60,
  0x1E, 0xD1, 0x00, 0x00, 0x00, 0x0D, 0xE1,
  0xAF, 0x40, 0x00, 0x00, 0x00, 0x04, 0xFA
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0059[126] = { /* code 0059, LATIN CAPITAL LETTER Y */
  0xBF, 0x20, 0x00, 0x00, 0x00, 0x02, 0xFB,
  0x2F, 0xB0, 0x00, 0x00, 0x00, 0x0B, 0xF2,
  0x08, 0xF5, 0x00, 0x00, 0x00, 0x5F, 0x80,
  0x00, 0xDE, 0x10, 0x00, 0x01, 0xED, 0x00,
  0x00, 0x5F, 0x80, 0x00, 0x08, 0xF5, 0x00,
  0x00, 0x0B, 0xF3, 0x00, 0x3F, 0xB0, 0x00,
  0x00, 0x02, 0xFC, 0x00, 0xCF, 0x20, 0x00,
  0x00, 0x00, 0x8F, 0x66, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0x1D, 0xEE, 0xD1, 0x00, 0x00,
  0x00, 0x00, 0x05, 0xFF, 0x50, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_005A[126] = { /* code 005A, LATIN CAPITAL LETTER Z */
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xD0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xB0,
  0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x1D, 0xF7, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x9F, 0xB0, 0x00,
  0x00, 0x00, 0x00, 0x04, 0xFE, 0x20, 0x00,
  0x00, 0x00, 0x00, 0x1E, 0xF5, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xBF, 0xA0, 0x00, 0x00,
  0x00, 0x00, 0x06, 0xFD, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x2E, 0xF4, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xCF, 0x90, 0x00, 0x00, 0x00,
  0x00, 0x08, 0xFD, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x4F, 0xF3, 0x00, 0x00, 0x00, 0x00,
  0x01, 0xDF, 0x80, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x5F, 0xF2, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xEF, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_005B[ 69] = { /* code 005B, LEFT SQUARE BRACKET */
  0xFF, 0xFF, 0xF0,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_005C[ 84] = { /* code 005C, REVERSE SOLIDUS */
  0xD2, 0x00, 0x00, 0x00,
  0x87, 0x00, 0x00, 0x00,
  0x3C, 0x00, 0x00, 0x00,
  0x0D, 0x20, 0x00, 0x00,
  0x08, 0x70, 0x00, 0x00,
  0x03, 0xC0, 0x00, 0x00,
  0x00, 0xE2, 0x00, 0x00,
  0x00, 0x97, 0x00, 0x00,
  0x00, 0x4C, 0x00, 0x00,
  0x00, 0x0E, 0x20, 0x00,
  0x00, 0x0A, 0x70, 0x00,
  0x00, 0x05, 0xC0, 0x00,
  0x00, 0x00, 0xE2, 0x00,
  0x00, 0x00, 0xA7, 0x00,
  0x00, 0x00, 0x5C, 0x00,
  0x00, 0x00, 0x1F, 0x20,
  0x00, 0x00, 0x0B, 0x70,
  0x00, 0x00, 0x06, 0xC0,
  0x00, 0x00, 0x01, 0xF2,
  0x00, 0x00, 0x00, 0xB7,
  0x00, 0x00, 0x00, 0x7C
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_005D[ 69] = { /* code 005D, RIGHT SQUARE BRACKET */
  0xFF, 0xFF, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0x00, 0x0F, 0xF0,
  0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_005E[ 56] = { /* code 005E, CIRCUMFLEX ACCENT */
  0x00, 0x00, 0x00, 0xAF, 0xA0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0xE5, 0xEA, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xAE, 0x20, 0x2E, 0xA0, 0x00, 0x00,
  0x00, 0x09, 0xE2, 0x00, 0x02, 0xE8, 0x00, 0x00,
  0x00, 0x8E, 0x20, 0x00, 0x00, 0x2E, 0x80, 0x00,
  0x08, 0xE2, 0x00, 0x00, 0x00, 0x02, 0xE8, 0x00,
  0x8E, 0x20, 0x00, 0x00, 0x00, 0x00, 0x2E, 0x80
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_005F[  7] = { /* code 005F, LOW LINE */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0060[  8] = { /* code 0060, GRAVE ACCENT */
  0x9E, 0x10,
  0x1C, 0x80,
  0x03, 0xE2,
  0x00, 0x6B
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0061[ 78] = { /* code 0061, LATIN SMALL LETTER A */
  0x00, 0x28, 0xDF, 0xFE, 0xB4, 0x00,
  0x03, 0xEE, 0x51, 0x02, 0xBF, 0x70,
  0x0C, 0xF4, 0x00, 0x00, 0x2F, 0xE0,
  0x07, 0x80, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x01, 0x8F, 0xF0,
  0x00, 0x38, 0xBD, 0xDC, 0xAF, 0xF0,
  0x1A, 0xFA, 0x30, 0x00, 0x0F, 0xF0,
  0x9F, 0x90, 0x00, 0x00, 0x0F, 0xF0,
  0xEF, 0x10, 0x00, 0x00, 0x1F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x6F, 0xF0,
  0xBF, 0x40, 0x00, 0x01, 0xDF, 0xF0,
  0x3F, 0xE4, 0x01, 0x5D, 0x9D, 0xF1,
  0x03, 0xBE, 0xFE, 0xA4, 0x07, 0xEF
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0062[108] = { /* code 0062, LATIN SMALL LETTER B */
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x03, 0xBE, 0xFE, 0xA3, 0x00,
  0xFF, 0x6C, 0x40, 0x04, 0xDF, 0x40,
  0xFF, 0xD1, 0x00, 0x00, 0x1E, 0xE1,
  0xFF, 0x60, 0x00, 0x00, 0x07, 0xF8,
  0xFF, 0x10, 0x00, 0x00, 0x03, 0xFC,
  0xFE, 0x00, 0x00, 0x00, 0x00, 0xFE,
  0xFD, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFE, 0x00, 0x00, 0x00, 0x00, 0xFE,
  0xFF, 0x20, 0x00, 0x00, 0x03, 0xFC,
  0xFF, 0x60, 0x00, 0x00, 0x07, 0xF8,
  0xFF, 0xD1, 0x00, 0x00, 0x1E, 0xE1,
  0xFF, 0x6D, 0x40, 0x04, 0xDE, 0x40,
  0xFF, 0x04, 0xBE, 0xFD, 0x92, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0063[ 78] = { /* code 0063, LATIN SMALL LETTER C */
  0x00, 0x29, 0xDF, 0xFC, 0x70, 0x00,
  0x03, 0xED, 0x40, 0x18, 0xFC, 0x10,
  0x1E, 0xE1, 0x00, 0x00, 0x8F, 0x90,
  0x7F, 0x70, 0x00, 0x00, 0x1F, 0xE0,
  0xCF, 0x30, 0x00, 0x00, 0x00, 0x00,
  0xEF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x10, 0x00, 0x00, 0x00, 0x00,
  0xCF, 0x30, 0x00, 0x00, 0x00, 0x00,
  0x8F, 0x70, 0x00, 0x00, 0x2F, 0xE0,
  0x1E, 0xE1, 0x00, 0x00, 0x8F, 0x80,
  0x05, 0xFD, 0x40, 0x18, 0xFB, 0x10,
  0x00, 0x3A, 0xEF, 0xFC, 0x70, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0064[108] = { /* code 0064, LATIN SMALL LETTER D */
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x2A, 0xEF, 0xEB, 0x40, 0xFF,
  0x04, 0xED, 0x40, 0x03, 0xC6, 0xFF,
  0x1E, 0xE1, 0x00, 0x00, 0x1C, 0xFF,
  0x8F, 0x70, 0x00, 0x00, 0x05, 0xFF,
  0xCF, 0x30, 0x00, 0x00, 0x01, 0xFF,
  0xEF, 0x00, 0x00, 0x00, 0x00, 0xDF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xDF,
  0xEF, 0x00, 0x00, 0x00, 0x00, 0xDF,
  0xCF, 0x30, 0x00, 0x00, 0x01, 0xFF,
  0x8F, 0x70, 0x00, 0x00, 0x05, 0xFF,
  0x1E, 0xE2, 0x00, 0x00, 0x1C, 0xFF,
  0x05, 0xFD, 0x50, 0x03, 0xC6, 0xFF,
  0x00, 0x3A, 0xEF, 0xEB, 0x30, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0065[ 78] = { /* code 0065, LATIN SMALL LETTER E */
  0x00, 0x3A, 0xEF, 0xEA, 0x30, 0x00,
  0x05, 0xFC, 0x30, 0x2B, 0xF5, 0x00,
  0x1E, 0xE1, 0x00, 0x01, 0xDF, 0x20,
  0x8F, 0x70, 0x00, 0x00, 0x7F, 0x80,
  0xCF, 0x30, 0x00, 0x00, 0x3F, 0xC0,
  0xEF, 0x10, 0x00, 0x00, 0x0F, 0xE0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xCF, 0x20, 0x00, 0x00, 0x00, 0x00,
  0x8F, 0x60, 0x00, 0x00, 0x3F, 0xA0,
  0x2F, 0xD1, 0x00, 0x00, 0xAF, 0x40,
  0x05, 0xFC, 0x30, 0x28, 0xF8, 0x00,
  0x00, 0x3A, 0xEF, 0xEB, 0x40, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0066[ 54] = { /* code 0066, LATIN SMALL LETTER F */
  0x00, 0x3B, 0xFF,
  0x00, 0xCF, 0x40,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x9F, 0xFF, 0xFF,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0067[108] = { /* code 0067, LATIN SMALL LETTER G */
  0x00, 0x2A, 0xEF, 0xEB, 0x30, 0xFF,
  0x03, 0xED, 0x40, 0x03, 0xC6, 0xFF,
  0x1E, 0xE1, 0x00, 0x00, 0x1C, 0xFF,
  0x7F, 0x70, 0x00, 0x00, 0x05, 0xFF,
  0xCF, 0x30, 0x00, 0x00, 0x01, 0xFF,
  0xEF, 0x00, 0x00, 0x00, 0x00, 0xDF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xDF,
  0xEF, 0x10, 0x00, 0x00, 0x00, 0xDF,
  0xCF, 0x30, 0x00, 0x00, 0x01, 0xFF,
  0x8F, 0x80, 0x00, 0x00, 0x05, 0xFF,
  0x1E, 0xE2, 0x00, 0x00, 0x1C, 0xFF,
  0x05, 0xFD, 0x51, 0x04, 0xC6, 0xFF,
  0x00, 0x3A, 0xEF, 0xEB, 0x30, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0xEF, 0x10, 0x00, 0x00, 0x05, 0xFA,
  0x9F, 0x70, 0x00, 0x00, 0x1C, 0xF3,
  0x1C, 0xF7, 0x10, 0x15, 0xCF, 0x60,
  0x00, 0x7C, 0xEF, 0xFC, 0x82, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0068[ 90] = { /* code 0068, LATIN SMALL LETTER H */
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x06, 0xCF, 0xFB, 0x40,
  0xFF, 0x99, 0x20, 0x3D, 0xF5,
  0xFF, 0xB0, 0x00, 0x04, 0xFC,
  0xFF, 0x30, 0x00, 0x01, 0xFF,
  0xFF, 0x10, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0069[ 18] = { /* code 0069, LATIN SMALL LETTER I */
  0xFF,
  0xFF,
  0x00,
  0x00,
  0x00,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_006A[ 46] = { /* code 006A, LATIN SMALL LETTER J */
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x04, 0xFD,
  0xFF, 0xC3
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_006B[108] = { /* code 006B, LATIN SMALL LETTER K */
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x02, 0xED, 0x10,
  0xFF, 0x00, 0x00, 0x2E, 0xB1, 0x00,
  0xFF, 0x00, 0x02, 0xEB, 0x10, 0x00,
  0xFF, 0x00, 0x2E, 0xB1, 0x00, 0x00,
  0xFF, 0x03, 0xEC, 0x10, 0x00, 0x00,
  0xFF, 0x3E, 0xEE, 0x10, 0x00, 0x00,
  0xFF, 0xEA, 0x2E, 0xA0, 0x00, 0x00,
  0xFF, 0xA0, 0x06, 0xF5, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0xBE, 0x10, 0x00,
  0xFF, 0x00, 0x00, 0x2E, 0xA0, 0x00,
  0xFF, 0x00, 0x00, 0x06, 0xF5, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0xBE, 0x10,
  0xFF, 0x00, 0x00, 0x00, 0x2E, 0xA0
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_006C[ 18] = { /* code 006C, LATIN SMALL LETTER L */
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_006D[117] = { /* code 006D, LATIN SMALL LETTER M */
  0xFD, 0x06, 0xCF, 0xFB, 0x40, 0x18, 0xDF, 0xFC, 0x50,
  0xFD, 0xAA, 0x20, 0x3D, 0xF4, 0xD8, 0x20, 0x2B, 0xF5,
  0xFF, 0xA0, 0x00, 0x03, 0xFF, 0x90, 0x00, 0x03, 0xFC,
  0xFF, 0x30, 0x00, 0x00, 0xFF, 0x30, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_006E[ 65] = { /* code 006E, LATIN SMALL LETTER N */
  0xFD, 0x06, 0xCF, 0xFB, 0x40,
  0xFD, 0xA9, 0x10, 0x3D, 0xF5,
  0xFF, 0xA0, 0x00, 0x04, 0xFC,
  0xFF, 0x30, 0x00, 0x01, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_006F[ 78] = { /* code 006F, LATIN SMALL LETTER O */
  0x00, 0x29, 0xDF, 0xFD, 0x92, 0x00,
  0x03, 0xED, 0x40, 0x04, 0xDE, 0x30,
  0x1E, 0xE1, 0x00, 0x00, 0x1E, 0xE1,
  0x8F, 0x70, 0x00, 0x00, 0x07, 0xF8,
  0xCF, 0x30, 0x00, 0x00, 0x03, 0xFC,
  0xEF, 0x00, 0x00, 0x00, 0x00, 0xFE,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xCF, 0x30, 0x00, 0x00, 0x03, 0xFC,
  0x8F, 0x70, 0x00, 0x00, 0x07, 0xF8,
  0x1E, 0xE1, 0x00, 0x00, 0x1E, 0xE1,
  0x03, 0xED, 0x40, 0x04, 0xDE, 0x30,
  0x00, 0x29, 0xDF, 0xFD, 0x92, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0070[108] = { /* code 0070, LATIN SMALL LETTER P */
  0xFF, 0x04, 0xBE, 0xFE, 0xA3, 0x00,
  0xFF, 0x6C, 0x40, 0x04, 0xDF, 0x50,
  0xFF, 0xD1, 0x00, 0x00, 0x1E, 0xE1,
  0xFF, 0x60, 0x00, 0x00, 0x07, 0xF8,
  0xFF, 0x10, 0x00, 0x00, 0x03, 0xFC,
  0xFE, 0x00, 0x00, 0x00, 0x00, 0xFE,
  0xFD, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFE, 0x00, 0x00, 0x00, 0x00, 0xFE,
  0xFF, 0x20, 0x00, 0x00, 0x03, 0xFC,
  0xFF, 0x60, 0x00, 0x00, 0x07, 0xF8,
  0xFF, 0xD1, 0x00, 0x00, 0x1E, 0xE1,
  0xFF, 0x6C, 0x40, 0x04, 0xDE, 0x40,
  0xFF, 0x04, 0xBE, 0xFE, 0xA2, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0071[108] = { /* code 0071, LATIN SMALL LETTER Q */
  0x00, 0x2A, 0xEF, 0xEB, 0x40, 0xFF,
  0x04, 0xFD, 0x40, 0x03, 0xC6, 0xFF,
  0x1E, 0xE1, 0x00, 0x00, 0x1C, 0xFF,
  0x8F, 0x70, 0x00, 0x00, 0x05, 0xFF,
  0xCF, 0x30, 0x00, 0x00, 0x01, 0xFF,
  0xEF, 0x00, 0x00, 0x00, 0x00, 0xDF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xDF,
  0xEF, 0x00, 0x00, 0x00, 0x00, 0xDF,
  0xCF, 0x30, 0x00, 0x00, 0x01, 0xFF,
  0x8F, 0x70, 0x00, 0x00, 0x05, 0xFF,
  0x1E, 0xE2, 0x00, 0x00, 0x1C, 0xFF,
  0x05, 0xFD, 0x50, 0x03, 0xC5, 0xFF,
  0x00, 0x3A, 0xEF, 0xEB, 0x30, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0072[ 39] = { /* code 0072, LATIN SMALL LETTER R */
  0xFD, 0x18, 0xDF,
  0xFD, 0xBA, 0x30,
  0xFF, 0xB0, 0x00,
  0xFF, 0x40, 0x00,
  0xFF, 0x10, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0073[ 65] = { /* code 0073, LATIN SMALL LETTER S */
  0x02, 0x9D, 0xFF, 0xC7, 0x10,
  0x3E, 0xC3, 0x01, 0x6E, 0xD1,
  0xCF, 0x20, 0x00, 0x06, 0xF9,
  0xFF, 0x00, 0x00, 0x01, 0xFE,
  0xDF, 0x70, 0x00, 0x00, 0x00,
  0x5F, 0xFB, 0x51, 0x00, 0x00,
  0x02, 0x8D, 0xFF, 0xC7, 0x10,
  0x00, 0x00, 0x27, 0xCF, 0xE4,
  0x00, 0x00, 0x00, 0x08, 0xFC,
  0xEF, 0x10, 0x00, 0x00, 0xFF,
  0xAF, 0x60, 0x00, 0x02, 0xFC,
  0x2D, 0xE6, 0x10, 0x4D, 0xE3,
  0x01, 0x8C, 0xFF, 0xD9, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0074[ 51] = { /* code 0074, LATIN SMALL LETTER T */
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x9F, 0xFF, 0xFF,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xEF, 0x20,
  0x00, 0x7E, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0075[ 65] = { /* code 0075, LATIN SMALL LETTER U */
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x10, 0x00, 0x03, 0xFF,
  0xBF, 0x40, 0x00, 0x0A, 0xFF,
  0x5F, 0xD3, 0x02, 0x9A, 0xFF,
  0x05, 0xCF, 0xFC, 0x60, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0076[ 78] = { /* code 0076, LATIN SMALL LETTER V */
  0xCD, 0x00, 0x00, 0x00, 0x00, 0xCC,
  0x6F, 0x40, 0x00, 0x00, 0x03, 0xF6,
  0x1F, 0xA0, 0x00, 0x00, 0x08, 0xF1,
  0x0A, 0xF1, 0x00, 0x00, 0x0E, 0xA0,
  0x04, 0xF6, 0x00, 0x00, 0x5F, 0x40,
  0x00, 0xDC, 0x00, 0x00, 0xBD, 0x00,
  0x00, 0x7F, 0x30, 0x02, 0xF7, 0x00,
  0x00, 0x2F, 0x90, 0x07, 0xF2, 0x00,
  0x00, 0x0B, 0xE1, 0x0D, 0xB0, 0x00,
  0x00, 0x05, 0xF6, 0x4F, 0x50, 0x00,
  0x00, 0x00, 0xEC, 0xAE, 0x00, 0x00,
  0x00, 0x00, 0x9F, 0xF9, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xF3, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0077[117] = { /* code 0077, LATIN SMALL LETTER W */
  0xDA, 0x00, 0x00, 0x02, 0xFF, 0x10, 0x00, 0x0A, 0xD0,
  0x8E, 0x00, 0x00, 0x06, 0xFF, 0x40, 0x00, 0x0E, 0x80,
  0x3F, 0x50, 0x00, 0x0A, 0xDF, 0x70, 0x00, 0x4F, 0x30,
  0x0E, 0xA0, 0x00, 0x0E, 0x8C, 0xA0, 0x00, 0x9E, 0x00,
  0x09, 0xE0, 0x00, 0x3F, 0x49, 0xC0, 0x00, 0xE9, 0x00,
  0x05, 0xF4, 0x00, 0x7F, 0x16, 0xF0, 0x04, 0xF5, 0x00,
  0x00, 0xF9, 0x00, 0xCB, 0x03, 0xF3, 0x08, 0xF0, 0x00,
  0x00, 0xAE, 0x01, 0xF7, 0x01, 0xF6, 0x0D, 0xA0, 0x00,
  0x00, 0x6F, 0x35, 0xF3, 0x00, 0xD9, 0x3F, 0x60, 0x00,
  0x00, 0x1F, 0x89, 0xE0, 0x00, 0xAC, 0x8F, 0x10, 0x00,
  0x00, 0x0B, 0xDD, 0xA0, 0x00, 0x7E, 0xDB, 0x00, 0x00,
  0x00, 0x07, 0xFF, 0x60, 0x00, 0x4F, 0xF7, 0x00, 0x00,
  0x00, 0x02, 0xFF, 0x20, 0x00, 0x1F, 0xF2, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0078[ 78] = { /* code 0078, LATIN SMALL LETTER X */
  0xAF, 0x50, 0x00, 0x00, 0x4F, 0xA0,
  0x1D, 0xE1, 0x00, 0x01, 0xDD, 0x10,
  0x03, 0xFB, 0x00, 0x09, 0xF3, 0x00,
  0x00, 0x7F, 0x60, 0x4F, 0x80, 0x00,
  0x00, 0x0B, 0xE3, 0xDC, 0x00, 0x00,
  0x00, 0x01, 0xEF, 0xE2, 0x00, 0x00,
  0x00, 0x00, 0x9F, 0xB0, 0x00, 0x00,
  0x00, 0x03, 0xFC, 0xF5, 0x00, 0x00,
  0x00, 0x1D, 0xD1, 0xBE, 0x10, 0x00,
  0x00, 0x9F, 0x30, 0x2F, 0xA0, 0x00,
  0x04, 0xF8, 0x00, 0x07, 0xF5, 0x00,
  0x1D, 0xC0, 0x00, 0x00, 0xCE, 0x10,
  0xAF, 0x30, 0x00, 0x00, 0x3F, 0xA0
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_0079[108] = { /* code 0079, LATIN SMALL LETTER Y */
  0xC9, 0x00, 0x00, 0x00, 0x0A, 0xC0,
  0x7E, 0x00, 0x00, 0x00, 0x1F, 0x70,
  0x2F, 0x50, 0x00, 0x00, 0x6F, 0x20,
  0x0B, 0xB0, 0x00, 0x00, 0xBB, 0x00,
  0x05, 0xF1, 0x00, 0x02, 0xF6, 0x00,
  0x01, 0xE7, 0x00, 0x07, 0xF1, 0x00,
  0x00, 0xAC, 0x00, 0x0D, 0xA0, 0x00,
  0x00, 0x4F, 0x30, 0x3F, 0x50, 0x00,
  0x00, 0x0D, 0x80, 0x8E, 0x00, 0x00,
  0x00, 0x08, 0xD0, 0xE9, 0x00, 0x00,
  0x00, 0x03, 0xF8, 0xF3, 0x00, 0x00,
  0x00, 0x00, 0xCF, 0xD0, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x5F, 0x20, 0x00, 0x00,
  0x00, 0x00, 0xBC, 0x00, 0x00, 0x00,
  0x00, 0x02, 0xF6, 0x00, 0x00, 0x00,
  0x01, 0x1B, 0xD0, 0x00, 0x00, 0x00,
  0x0F, 0xFB, 0x20, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_007A[ 78] = { /* code 007A, LATIN SMALL LETTER Z */
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x90,
  0x00, 0x00, 0x00, 0x00, 0xAF, 0x70,
  0x00, 0x00, 0x00, 0x07, 0xFB, 0x00,
  0x00, 0x00, 0x00, 0x4F, 0xD1, 0x00,
  0x00, 0x00, 0x03, 0xEE, 0x20, 0x00,
  0x00, 0x00, 0x1D, 0xF4, 0x00, 0x00,
  0x00, 0x00, 0xBF, 0x70, 0x00, 0x00,
  0x00, 0x08, 0xFA, 0x00, 0x00, 0x00,
  0x00, 0x6F, 0xC1, 0x00, 0x00, 0x00,
  0x03, 0xFE, 0x20, 0x00, 0x00, 0x00,
  0x1E, 0xF4, 0x00, 0x00, 0x00, 0x00,
  0xCF, 0x60, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_007B[ 92] = { /* code 007B, LEFT CURLY BRACKET */
  0x00, 0x00, 0x19, 0xEF,
  0x00, 0x00, 0x9A, 0x20,
  0x00, 0x00, 0xD3, 0x00,
  0x00, 0x00, 0xF0, 0x00,
  0x00, 0x00, 0xF0, 0x00,
  0x00, 0x00, 0xF0, 0x00,
  0x00, 0x00, 0xF0, 0x00,
  0x00, 0x00, 0xF0, 0x00,
  0x00, 0x01, 0xE0, 0x00,
  0x00, 0x05, 0xB0, 0x00,
  0x01, 0x5D, 0x40, 0x00,
  0xFF, 0xF6, 0x00, 0x00,
  0x01, 0x5D, 0x50, 0x00,
  0x00, 0x05, 0xC0, 0x00,
  0x00, 0x01, 0xE0, 0x00,
  0x00, 0x00, 0xF0, 0x00,
  0x00, 0x00, 0xF0, 0x00,
  0x00, 0x00, 0xF0, 0x00,
  0x00, 0x00, 0xF0, 0x00,
  0x00, 0x00, 0xF0, 0x00,
  0x00, 0x00, 0xD3, 0x00,
  0x00, 0x00, 0x9A, 0x20,
  0x00, 0x00, 0x1A, 0xEF
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_007C[ 25] = { /* code 007C, VERTICAL LINE */
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_007D[ 92] = { /* code 007D, RIGHT CURLY BRACKET */
  0xFE, 0x91, 0x00, 0x00,
  0x02, 0xA9, 0x00, 0x00,
  0x00, 0x3D, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0E, 0x10, 0x00,
  0x00, 0x0C, 0x50, 0x00,
  0x00, 0x04, 0xD5, 0x10,
  0x00, 0x00, 0x6F, 0xFF,
  0x00, 0x04, 0xD5, 0x10,
  0x00, 0x0B, 0x50, 0x00,
  0x00, 0x0E, 0x10, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x3D, 0x00, 0x00,
  0x02, 0xA9, 0x00, 0x00,
  0xFE, 0xA1, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font30SL_AA4_007E[ 45] = { /* code 007E, TILDE */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x01, 0x7C, 0xFE, 0xB6, 0x10, 0x00, 0x00, 0x03, 0xC0,
  0x4E, 0xA3, 0x01, 0x49, 0xE9, 0x41, 0x03, 0x9D, 0x40,
  0xD4, 0x00, 0x00, 0x00, 0x16, 0xBE, 0xFC, 0x71, 0x00,
  0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_Font30SL_AA4_CharInfo[95] = {
   {   1,   1,   0,  24,   7, acGUI_Font30SL_AA4_0020 } /* code 0020, SPACE */
  ,{   2,  18,   3,   6,   8, acGUI_Font30SL_AA4_0021 } /* code 0021, EXCLAMATION MARK */
  ,{   4,   7,   1,   6,   7, acGUI_Font30SL_AA4_0022 } /* code 0022, QUOTATION MARK */
  ,{  16,  18,   2,   6,  19, acGUI_Font30SL_AA4_0023 } /* code 0023, NUMBER SIGN */
  ,{  12,  20,   1,   6,  13, acGUI_Font30SL_AA4_0024 } /* code 0024, DOLLAR SIGN */
  ,{  18,  19,   1,   6,  20, acGUI_Font30SL_AA4_0025 } /* code 0025, PERCENT SIGN */
  ,{  15,  18,   1,   6,  17, acGUI_Font30SL_AA4_0026 } /* code 0026, AMPERSAND */
  ,{   1,   7,   1,   6,   3, acGUI_Font30SL_AA4_0027 } /* code 0027, APOSTROPHE */
  ,{   5,  23,   2,   6,   8, acGUI_Font30SL_AA4_0028 } /* code 0028, LEFT PARENTHESIS */
  ,{   5,  23,   0,   6,   8, acGUI_Font30SL_AA4_0029 } /* code 0029, RIGHT PARENTHESIS */
  ,{   9,   9,   2,   6,  13, acGUI_Font30SL_AA4_002A } /* code 002A, ASTERISK */
  ,{  15,  15,   3,   9,  21, acGUI_Font30SL_AA4_002B } /* code 002B, PLUS SIGN */
  ,{   2,   6,   3,  22,   7, acGUI_Font30SL_AA4_002C } /* code 002C, COMMA */
  ,{   6,   2,   1,  16,   8, acGUI_Font30SL_AA4_002D } /* code 002D, HYPHEN-MINUS */
  ,{   2,   2,   3,  22,   7, acGUI_Font30SL_AA4_002E } /* code 002E, FULL STOP */
  ,{   8,  21,   0,   6,   7, acGUI_Font30SL_AA4_002F } /* code 002F, SOLIDUS */
  ,{  11,  17,   1,   7,  13, acGUI_Font30SL_AA4_0030 } /* code 0030, DIGIT ZERO */
  ,{   6,  17,   3,   7,  13, acGUI_Font30SL_AA4_0031 } /* code 0031, DIGIT ONE */
  ,{  11,  17,   1,   7,  13, acGUI_Font30SL_AA4_0032 } /* code 0032, DIGIT TWO */
  ,{  11,  17,   1,   7,  13, acGUI_Font30SL_AA4_0033 } /* code 0033, DIGIT THREE */
  ,{  11,  17,   1,   7,  13, acGUI_Font30SL_AA4_0034 } /* code 0034, DIGIT FOUR */
  ,{  11,  17,   1,   7,  13, acGUI_Font30SL_AA4_0035 } /* code 0035, DIGIT FIVE */
  ,{  11,  17,   1,   7,  13, acGUI_Font30SL_AA4_0036 } /* code 0036, DIGIT SIX */
  ,{  11,  17,   1,   7,  13, acGUI_Font30SL_AA4_0037 } /* code 0037, DIGIT SEVEN */
  ,{  11,  17,   1,   7,  13, acGUI_Font30SL_AA4_0038 } /* code 0038, DIGIT EIGHT */
  ,{  11,  17,   1,   7,  13, acGUI_Font30SL_AA4_0039 } /* code 0039, DIGIT NINE */
  ,{   2,  13,   3,  11,   7, acGUI_Font30SL_AA4_003A } /* code 003A, COLON */
  ,{   2,  17,   3,  11,   7, acGUI_Font30SL_AA4_003B } /* code 003B, SEMICOLON */
  ,{  14,  13,   3,  10,  21, acGUI_Font30SL_AA4_003C } /* code 003C, LESS-THAN SIGN */
  ,{  15,   5,   3,  14,  21, acGUI_Font30SL_AA4_003D } /* code 003D, EQUALS SIGN */
  ,{  14,  13,   3,  10,  21, acGUI_Font30SL_AA4_003E } /* code 003E, GREATER-THAN SIGN */
  ,{  11,  18,   1,   6,  12, acGUI_Font30SL_AA4_003F } /* code 003F, QUESTION MARK */
  ,{  22,  21,   1,   6,  25, acGUI_Font30SL_AA4_0040 } /* code 0040, COMMERCIAL AT */
  ,{  16,  18,   0,   6,  15, acGUI_Font30SL_AA4_0041 } /* code 0041, LATIN CAPITAL LETTER A */
  ,{  13,  18,   2,   6,  16, acGUI_Font30SL_AA4_0042 } /* code 0042, LATIN CAPITAL LETTER B */
  ,{  15,  18,   1,   6,  17, acGUI_Font30SL_AA4_0043 } /* code 0043, LATIN CAPITAL LETTER C */
  ,{  14,  18,   2,   6,  17, acGUI_Font30SL_AA4_0044 } /* code 0044, LATIN CAPITAL LETTER D */
  ,{  12,  18,   2,   6,  15, acGUI_Font30SL_AA4_0045 } /* code 0045, LATIN CAPITAL LETTER E */
  ,{  11,  18,   2,   6,  14, acGUI_Font30SL_AA4_0046 } /* code 0046, LATIN CAPITAL LETTER F */
  ,{  16,  18,   1,   6,  19, acGUI_Font30SL_AA4_0047 } /* code 0047, LATIN CAPITAL LETTER G */
  ,{  14,  18,   2,   6,  18, acGUI_Font30SL_AA4_0048 } /* code 0048, LATIN CAPITAL LETTER H */
  ,{   2,  18,   2,   6,   6, acGUI_Font30SL_AA4_0049 } /* code 0049, LATIN CAPITAL LETTER I */
  ,{  10,  18,   1,   6,  12, acGUI_Font30SL_AA4_004A } /* code 004A, LATIN CAPITAL LETTER J */
  ,{  14,  18,   2,   6,  16, acGUI_Font30SL_AA4_004B } /* code 004B, LATIN CAPITAL LETTER K */
  ,{  11,  18,   2,   6,  13, acGUI_Font30SL_AA4_004C } /* code 004C, LATIN CAPITAL LETTER L */
  ,{  16,  18,   2,   6,  20, acGUI_Font30SL_AA4_004D } /* code 004D, LATIN CAPITAL LETTER M */
  ,{  14,  18,   2,   6,  18, acGUI_Font30SL_AA4_004E } /* code 004E, LATIN CAPITAL LETTER N */
  ,{  16,  18,   1,   6,  19, acGUI_Font30SL_AA4_004F } /* code 004F, LATIN CAPITAL LETTER O */
  ,{  12,  18,   2,   6,  15, acGUI_Font30SL_AA4_0050 } /* code 0050, LATIN CAPITAL LETTER P */
  ,{  16,  19,   1,   6,  19, acGUI_Font30SL_AA4_0051 } /* code 0051, LATIN CAPITAL LETTER Q */
  ,{  13,  18,   2,   6,  16, acGUI_Font30SL_AA4_0052 } /* code 0052, LATIN CAPITAL LETTER R */
  ,{  12,  18,   2,   6,  15, acGUI_Font30SL_AA4_0053 } /* code 0053, LATIN CAPITAL LETTER S */
  ,{  14,  18,   0,   6,  13, acGUI_Font30SL_AA4_0054 } /* code 0054, LATIN CAPITAL LETTER T */
  ,{  14,  18,   2,   6,  17, acGUI_Font30SL_AA4_0055 } /* code 0055, LATIN CAPITAL LETTER U */
  ,{  14,  18,   0,   6,  14, acGUI_Font30SL_AA4_0056 } /* code 0056, LATIN CAPITAL LETTER V */
  ,{  21,  18,   0,   6,  21, acGUI_Font30SL_AA4_0057 } /* code 0057, LATIN CAPITAL LETTER W */
  ,{  14,  18,   0,   6,  15, acGUI_Font30SL_AA4_0058 } /* code 0058, LATIN CAPITAL LETTER X */
  ,{  14,  18,   0,   6,  14, acGUI_Font30SL_AA4_0059 } /* code 0059, LATIN CAPITAL LETTER Y */
  ,{  13,  18,   1,   6,  14, acGUI_Font30SL_AA4_005A } /* code 005A, LATIN CAPITAL LETTER Z */
  ,{   5,  23,   3,   6,   8, acGUI_Font30SL_AA4_005B } /* code 005B, LEFT SQUARE BRACKET */
  ,{   8,  21,   0,   6,   7, acGUI_Font30SL_AA4_005C } /* code 005C, REVERSE SOLIDUS */
  ,{   5,  23,   1,   6,   8, acGUI_Font30SL_AA4_005D } /* code 005D, RIGHT SQUARE BRACKET */
  ,{  15,   7,   5,   6,  25, acGUI_Font30SL_AA4_005E } /* code 005E, CIRCUMFLEX ACCENT */
  ,{  13,   1,   0,  29,  13, acGUI_Font30SL_AA4_005F } /* code 005F, LOW LINE */
  ,{   4,   4,   3,   5,  13, acGUI_Font30SL_AA4_0060 } /* code 0060, GRAVE ACCENT */
  ,{  12,  13,   1,  11,  13, acGUI_Font30SL_AA4_0061 } /* code 0061, LATIN SMALL LETTER A */
  ,{  12,  18,   2,   6,  14, acGUI_Font30SL_AA4_0062 } /* code 0062, LATIN SMALL LETTER B */
  ,{  11,  13,   1,  11,  13, acGUI_Font30SL_AA4_0063 } /* code 0063, LATIN SMALL LETTER C */
  ,{  12,  18,   1,   6,  15, acGUI_Font30SL_AA4_0064 } /* code 0064, LATIN SMALL LETTER D */
  ,{  11,  13,   1,  11,  13, acGUI_Font30SL_AA4_0065 } /* code 0065, LATIN SMALL LETTER E */
  ,{   6,  18,   0,   6,   7, acGUI_Font30SL_AA4_0066 } /* code 0066, LATIN SMALL LETTER F */
  ,{  12,  18,   1,  11,  14, acGUI_Font30SL_AA4_0067 } /* code 0067, LATIN SMALL LETTER G */
  ,{  10,  18,   2,   6,  14, acGUI_Font30SL_AA4_0068 } /* code 0068, LATIN SMALL LETTER H */
  ,{   2,  18,   2,   6,   5, acGUI_Font30SL_AA4_0069 } /* code 0069, LATIN SMALL LETTER I */
  ,{   4,  23,   0,   6,   5, acGUI_Font30SL_AA4_006A } /* code 006A, LATIN SMALL LETTER J */
  ,{  11,  18,   2,   6,  12, acGUI_Font30SL_AA4_006B } /* code 006B, LATIN SMALL LETTER K */
  ,{   2,  18,   2,   6,   5, acGUI_Font30SL_AA4_006C } /* code 006C, LATIN SMALL LETTER L */
  ,{  18,  13,   2,  11,  21, acGUI_Font30SL_AA4_006D } /* code 006D, LATIN SMALL LETTER M */
  ,{  10,  13,   2,  11,  13, acGUI_Font30SL_AA4_006E } /* code 006E, LATIN SMALL LETTER N */
  ,{  12,  13,   1,  11,  14, acGUI_Font30SL_AA4_006F } /* code 006F, LATIN SMALL LETTER O */
  ,{  12,  18,   2,  11,  15, acGUI_Font30SL_AA4_0070 } /* code 0070, LATIN SMALL LETTER P */
  ,{  12,  18,   1,  11,  15, acGUI_Font30SL_AA4_0071 } /* code 0071, LATIN SMALL LETTER Q */
  ,{   6,  13,   2,  11,   8, acGUI_Font30SL_AA4_0072 } /* code 0072, LATIN SMALL LETTER R */
  ,{  10,  13,   1,  11,  12, acGUI_Font30SL_AA4_0073 } /* code 0073, LATIN SMALL LETTER S */
  ,{   6,  17,   0,   7,   7, acGUI_Font30SL_AA4_0074 } /* code 0074, LATIN SMALL LETTER T */
  ,{  10,  13,   2,  11,  14, acGUI_Font30SL_AA4_0075 } /* code 0075, LATIN SMALL LETTER U */
  ,{  12,  13,   0,  11,  12, acGUI_Font30SL_AA4_0076 } /* code 0076, LATIN SMALL LETTER V */
  ,{  17,  13,   0,  11,  17, acGUI_Font30SL_AA4_0077 } /* code 0077, LATIN SMALL LETTER W */
  ,{  11,  13,   0,  11,  11, acGUI_Font30SL_AA4_0078 } /* code 0078, LATIN SMALL LETTER X */
  ,{  11,  18,   0,  11,  12, acGUI_Font30SL_AA4_0079 } /* code 0079, LATIN SMALL LETTER Y */
  ,{  11,  13,   1,  11,  12, acGUI_Font30SL_AA4_007A } /* code 007A, LATIN SMALL LETTER Z */
  ,{   8,  23,   2,   6,  13, acGUI_Font30SL_AA4_007B } /* code 007B, LEFT CURLY BRACKET */
  ,{   1,  25,   6,   5,  13, acGUI_Font30SL_AA4_007C } /* code 007C, VERTICAL LINE */
  ,{   8,  23,   2,   6,  13, acGUI_Font30SL_AA4_007D } /* code 007D, RIGHT CURLY BRACKET */
  ,{  17,   5,   2,  14,  21, acGUI_Font30SL_AA4_007E } /* code 007E, TILDE */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font30SL_AA4_Prop1 = {
   0x0020 /* first character */
  ,0x007E /* last character  */
  ,&GUI_Font30SL_AA4_CharInfo[  0] /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT GUI_Font30SL_AA4 = {
   GUI_FONTTYPE_PROP_AA4_EXT /* type of font    */
  ,30 /* height of font  */
  ,30 /* space of font y */
  ,1 /* magnification x */
  ,1 /* magnification y */
  ,{&GUI_Font30SL_AA4_Prop1}
  ,24 /* Baseline */
  ,13 /* Height of lowercase characters */
  ,18 /* Height of capital characters */
};

