/*********************************************************************
*                SEGGER Microcontroller GmbH                         *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2018  SEGGER Microcontroller GmbH                *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.48 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software  has been licensed to  Cypress Semiconductor Corporation,
whose registered  office is situated  at 198 Champion Ct. San Jose, CA 
95134 USA  solely for the  purposes of creating  libraries for Cypress
PSoC3 and  PSoC5 processor-based devices,  sublicensed and distributed
under  the  terms  and  conditions  of  the  Cypress  End User License
Agreement.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information
Licensor:                 SEGGER Microcontroller Systems LLC
Licensed to:              Cypress Semiconductor Corp, 198 Champion Ct., San Jose, CA 95134, USA
Licensed SEGGER software: emWin
License number:           GUI-00319
License model:            Services and License Agreement, signed June 10th, 2009
Licensed platform:        Any Cypress platform (Initial targets are: PSoC3, PSoC5)
----------------------------------------------------------------------
Support and Update Agreement (SUA)
SUA period:               2009-06-12 - 2022-07-27
Contact to extend SUA:    sales@segger.com
---------------------------------------------------------------------
File        : Font27SL_AA4.c
Purpose     : GUI_FONT_PROP_EXT, AA4, 27 Pixel
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI.h"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

/* The following line needs to be included in any file selecting the
   font.
*/
extern GUI_CONST_STORAGE GUI_FONT GUI_Font27SL_AA4;

/* Start of unicode area <Basic Latin> */
GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0020[  1] = { /* code 0020, SPACE */
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0021[ 17] = { /* code 0021, EXCLAMATION MARK */
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xEE,
  0xDD,
  0xBC,
  0xBB,
  0xAA,
  0x99,
  0x00,
  0x00,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0022[ 12] = { /* code 0022, QUOTATION MARK */
  0xF0, 0x0F,
  0xF0, 0x0F,
  0xF0, 0x0F,
  0xF0, 0x0F,
  0xF0, 0x0F,
  0xF0, 0x0F
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0023[128] = { /* code 0023, NUMBER SIGN */
  0x00, 0x00, 0x00, 0x07, 0xB0, 0x02, 0xF2, 0x00,
  0x00, 0x00, 0x00, 0x0D, 0x50, 0x08, 0xB0, 0x00,
  0x00, 0x00, 0x00, 0x4E, 0x00, 0x0E, 0x50, 0x00,
  0x00, 0x00, 0x00, 0xB9, 0x00, 0x5E, 0x00, 0x00,
  0x00, 0x00, 0x02, 0xF3, 0x00, 0xB8, 0x00, 0x00,
  0x09, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
  0x00, 0x00, 0x0D, 0x60, 0x07, 0xC0, 0x00, 0x00,
  0x00, 0x00, 0x4F, 0x10, 0x0D, 0x60, 0x00, 0x00,
  0x00, 0x00, 0x9A, 0x00, 0x4E, 0x10, 0x00, 0x00,
  0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0x00,
  0x00, 0x05, 0xE0, 0x00, 0xE4, 0x00, 0x00, 0x00,
  0x00, 0x0A, 0x90, 0x05, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0x1F, 0x40, 0x0A, 0x90, 0x00, 0x00, 0x00,
  0x00, 0x5E, 0x00, 0x0E, 0x40, 0x00, 0x00, 0x00,
  0x00, 0xA9, 0x00, 0x5E, 0x00, 0x00, 0x00, 0x00,
  0x01, 0xF3, 0x00, 0xA9, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0024[114] = { /* code 0024, DOLLAR SIGN */
  0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x01, 0x7C, 0xFF, 0xEB, 0x40, 0x00,
  0x1D, 0xE6, 0x1F, 0x2C, 0xF4, 0x00,
  0xAF, 0x50, 0x0F, 0x03, 0xFC, 0x00,
  0xEF, 0x00, 0x0F, 0x00, 0xDD, 0x00,
  0xFF, 0x10, 0x0F, 0x00, 0x00, 0x00,
  0xCF, 0x60, 0x0F, 0x00, 0x00, 0x00,
  0x3E, 0xFA, 0x4F, 0x00, 0x00, 0x00,
  0x01, 0x8E, 0xFF, 0xB6, 0x10, 0x00,
  0x00, 0x00, 0x3F, 0xBF, 0xE7, 0x00,
  0x00, 0x00, 0x0F, 0x03, 0xDF, 0x60,
  0x00, 0x00, 0x0F, 0x00, 0x4F, 0xD0,
  0xDD, 0x00, 0x0F, 0x00, 0x0F, 0xF0,
  0xDF, 0x30, 0x0F, 0x00, 0x1F, 0xE0,
  0x8F, 0x90, 0x0F, 0x00, 0x6F, 0x90,
  0x1B, 0xF8, 0x1F, 0x16, 0xEC, 0x10,
  0x00, 0x6B, 0xEF, 0xFC, 0x71, 0x00,
  0x00, 0x00, 0x0F, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0025[162] = { /* code 0025, PERCENT SIGN */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x20, 0x00,
  0x03, 0xBF, 0xFB, 0x30, 0x00, 0x00, 0x7B, 0x00, 0x00,
  0x3E, 0x61, 0x16, 0xE3, 0x00, 0x02, 0xE2, 0x00, 0x00,
  0xB6, 0x00, 0x00, 0x6B, 0x00, 0x0A, 0x70, 0x00, 0x00,
  0xF1, 0x00, 0x00, 0x1F, 0x00, 0x5D, 0x00, 0x00, 0x00,
  0xF1, 0x00, 0x00, 0x1F, 0x01, 0xD4, 0x00, 0x00, 0x00,
  0xB6, 0x00, 0x00, 0x6B, 0x08, 0xA0, 0x00, 0x00, 0x00,
  0x3E, 0x61, 0x16, 0xE3, 0x3E, 0x10, 0x00, 0x00, 0x00,
  0x03, 0xBF, 0xFB, 0x30, 0xC6, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x06, 0xC0, 0x3B, 0xFF, 0xB3, 0x00,
  0x00, 0x00, 0x00, 0x1E, 0x33, 0xE6, 0x11, 0x6E, 0x30,
  0x00, 0x00, 0x00, 0xA8, 0x0B, 0x60, 0x00, 0x06, 0xB0,
  0x00, 0x00, 0x04, 0xD1, 0x0F, 0x10, 0x00, 0x01, 0xF0,
  0x00, 0x00, 0x0D, 0x50, 0x0F, 0x10, 0x00, 0x01, 0xF0,
  0x00, 0x00, 0x7A, 0x00, 0x0B, 0x70, 0x00, 0x06, 0xB0,
  0x00, 0x02, 0xE2, 0x00, 0x02, 0xE7, 0x11, 0x6E, 0x30,
  0x00, 0x0B, 0x70, 0x00, 0x00, 0x2B, 0xFF, 0xB3, 0x00,
  0x00, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0026[119] = { /* code 0026, AMPERSAND */
  0x00, 0x06, 0xDF, 0xD7, 0x00, 0x00, 0x00,
  0x00, 0x6F, 0x80, 0x8F, 0x70, 0x00, 0x00,
  0x00, 0xDF, 0x10, 0x1F, 0xD0, 0x00, 0x00,
  0x00, 0xFF, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0xDF, 0x30, 0x3F, 0xD0, 0x00, 0x00,
  0x00, 0x6F, 0x80, 0xAF, 0x70, 0x00, 0x00,
  0x00, 0x0B, 0xE8, 0xFA, 0x00, 0x00, 0x00,
  0x00, 0x03, 0xFE, 0x70, 0x00, 0x00, 0x00,
  0x01, 0xAF, 0xCF, 0x40, 0x00, 0x00, 0x00,
  0x1D, 0xF7, 0x07, 0xE2, 0x00, 0x00, 0x00,
  0x8F, 0x90, 0x00, 0xBC, 0x00, 0xFF, 0x00,
  0xDF, 0x20, 0x00, 0x1D, 0x91, 0xFC, 0x00,
  0xFF, 0x00, 0x00, 0x03, 0xEA, 0xF7, 0x00,
  0xDF, 0x10, 0x00, 0x00, 0x5F, 0xC0, 0x00,
  0x8F, 0x70, 0x00, 0x00, 0x5F, 0xE4, 0x00,
  0x1C, 0xF7, 0x10, 0x38, 0xE4, 0xBF, 0x50,
  0x01, 0x8D, 0xFF, 0xC8, 0x10, 0x1B, 0xF7
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0027[  6] = { /* code 0027, APOSTROPHE */
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0028[ 63] = { /* code 0028, LEFT PARENTHESIS */
  0x00, 0x0B, 0x90,
  0x00, 0x6C, 0x00,
  0x01, 0xE3, 0x00,
  0x08, 0x90, 0x00,
  0x0E, 0x20, 0x00,
  0x4B, 0x00, 0x00,
  0x87, 0x00, 0x00,
  0xB4, 0x00, 0x00,
  0xD2, 0x00, 0x00,
  0xF0, 0x00, 0x00,
  0xF0, 0x00, 0x00,
  0xF0, 0x00, 0x00,
  0xD2, 0x00, 0x00,
  0xB4, 0x00, 0x00,
  0x87, 0x00, 0x00,
  0x4B, 0x00, 0x00,
  0x0E, 0x20, 0x00,
  0x08, 0x90, 0x00,
  0x01, 0xE3, 0x00,
  0x00, 0x6C, 0x00,
  0x00, 0x0B, 0x90
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0029[ 63] = { /* code 0029, RIGHT PARENTHESIS */
  0x9B, 0x00, 0x00,
  0x0C, 0x60, 0x00,
  0x03, 0xE1, 0x00,
  0x00, 0x98, 0x00,
  0x00, 0x2E, 0x00,
  0x00, 0x0B, 0x40,
  0x00, 0x07, 0x80,
  0x00, 0x04, 0xB0,
  0x00, 0x02, 0xD0,
  0x00, 0x00, 0xF0,
  0x00, 0x00, 0xF0,
  0x00, 0x00, 0xF0,
  0x00, 0x02, 0xD0,
  0x00, 0x04, 0xB0,
  0x00, 0x07, 0x80,
  0x00, 0x0B, 0x40,
  0x00, 0x2E, 0x00,
  0x00, 0x98, 0x00,
  0x03, 0xE1, 0x00,
  0x0C, 0x60, 0x00,
  0x9B, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_002A[ 40] = { /* code 002A, ASTERISK */
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00,
  0xA9, 0x40, 0xF0, 0x49, 0x90,
  0x7B, 0xEE, 0xFE, 0xEB, 0x60,
  0x00, 0x0A, 0xFA, 0x00, 0x00,
  0x00, 0x5E, 0x4E, 0x50, 0x00,
  0x03, 0xF6, 0x06, 0xF3, 0x00,
  0x05, 0xA0, 0x00, 0xA5, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_002B[ 91] = { /* code 002B, PLUS SIGN */
  0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_002C[  5] = { /* code 002C, COMMA */
  0xFF,
  0xFF,
  0x0F,
  0x3D,
  0xC3
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_002D[  3] = { /* code 002D, HYPHEN-MINUS */
  0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_002E[  2] = { /* code 002E, FULL STOP */
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_002F[ 76] = { /* code 002F, SOLIDUS */
  0x00, 0x00, 0x04, 0xD0,
  0x00, 0x00, 0x09, 0x80,
  0x00, 0x00, 0x0D, 0x30,
  0x00, 0x00, 0x3D, 0x00,
  0x00, 0x00, 0x88, 0x00,
  0x00, 0x00, 0xC3, 0x00,
  0x00, 0x02, 0xD0, 0x00,
  0x00, 0x07, 0x80, 0x00,
  0x00, 0x0B, 0x30, 0x00,
  0x00, 0x1D, 0x00, 0x00,
  0x00, 0x59, 0x00, 0x00,
  0x00, 0xA4, 0x00, 0x00,
  0x00, 0xD0, 0x00, 0x00,
  0x04, 0x90, 0x00, 0x00,
  0x09, 0x40, 0x00, 0x00,
  0x0D, 0x00, 0x00, 0x00,
  0x3A, 0x00, 0x00, 0x00,
  0x85, 0x00, 0x00, 0x00,
  0xC0, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0030[ 96] = { /* code 0030, DIGIT ZERO */
  0x00, 0x2A, 0xEF, 0xE9, 0x20, 0x00,
  0x03, 0xEC, 0x30, 0x3B, 0xE3, 0x00,
  0x0D, 0xE1, 0x00, 0x01, 0xED, 0x00,
  0x5F, 0x80, 0x00, 0x00, 0x8F, 0x50,
  0x9F, 0x40, 0x00, 0x00, 0x4F, 0x90,
  0xCF, 0x20, 0x00, 0x00, 0x2F, 0xC0,
  0xEF, 0x00, 0x00, 0x00, 0x0F, 0xE0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xEF, 0x00, 0x00, 0x00, 0x0F, 0xE0,
  0xCF, 0x20, 0x00, 0x00, 0x2F, 0xC0,
  0x9F, 0x40, 0x00, 0x00, 0x4F, 0x90,
  0x5F, 0x80, 0x00, 0x00, 0x8F, 0x50,
  0x0D, 0xE1, 0x00, 0x01, 0xED, 0x00,
  0x03, 0xEC, 0x30, 0x3B, 0xE3, 0x00,
  0x00, 0x2A, 0xEF, 0xEA, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0031[ 48] = { /* code 0031, DIGIT ONE */
  0x00, 0x00, 0xDF,
  0x00, 0x03, 0xFF,
  0x02, 0x6E, 0xFF,
  0xFE, 0xC6, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF,
  0x00, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0032[ 80] = { /* code 0032, DIGIT TWO */
  0x00, 0x7C, 0xFF, 0xD8, 0x10,
  0x0B, 0xF7, 0x10, 0x5E, 0xD1,
  0x7F, 0x80, 0x00, 0x06, 0xF8,
  0xCF, 0x30, 0x00, 0x01, 0xFD,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x01, 0xFE,
  0x00, 0x00, 0x00, 0x07, 0xFB,
  0x00, 0x00, 0x00, 0x4F, 0xF3,
  0x00, 0x00, 0x07, 0xFF, 0x50,
  0x00, 0x02, 0xBF, 0xC3, 0x00,
  0x00, 0x4E, 0xE7, 0x00, 0x00,
  0x05, 0xFC, 0x20, 0x00, 0x00,
  0x3F, 0xA0, 0x00, 0x00, 0x00,
  0xAE, 0x10, 0x00, 0x00, 0x00,
  0xE9, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFD
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0033[ 80] = { /* code 0033, DIGIT THREE */
  0x00, 0x2A, 0xEF, 0xC4, 0x00,
  0x01, 0xDD, 0x21, 0xCF, 0x40,
  0x08, 0xF6, 0x00, 0x3F, 0xB0,
  0x0C, 0xF2, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x3F, 0xA0,
  0x00, 0x00, 0x02, 0xCC, 0x10,
  0x00, 0x00, 0x9F, 0xE5, 0x00,
  0x00, 0x00, 0x00, 0x5E, 0xB1,
  0x00, 0x00, 0x00, 0x05, 0xF8,
  0x00, 0x00, 0x00, 0x01, 0xFE,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xCF, 0x30, 0x00, 0x02, 0xFD,
  0x7F, 0x80, 0x00, 0x07, 0xF8,
  0x0B, 0xF6, 0x01, 0x6E, 0xC1,
  0x00, 0x7C, 0xFF, 0xC7, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0034[ 80] = { /* code 0034, DIGIT FOUR */
  0x00, 0x00, 0x00, 0xCF, 0x00,
  0x00, 0x00, 0x07, 0xFF, 0x00,
  0x00, 0x00, 0x1A, 0xFF, 0x00,
  0x00, 0x00, 0xA3, 0xFF, 0x00,
  0x00, 0x04, 0xA0, 0xFF, 0x00,
  0x00, 0x0C, 0x20, 0xFF, 0x00,
  0x00, 0x79, 0x00, 0xFF, 0x00,
  0x02, 0xE1, 0x00, 0xFF, 0x00,
  0x0A, 0x80, 0x00, 0xFF, 0x00,
  0x4E, 0x10, 0x00, 0xFF, 0x00,
  0xD7, 0x00, 0x00, 0xFF, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0xFF, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0035[ 80] = { /* code 0035, DIGIT FIVE */
  0x00, 0xEF, 0xFF, 0xFF, 0xF0,
  0x01, 0xF0, 0x00, 0x00, 0x00,
  0x04, 0xD0, 0x00, 0x00, 0x00,
  0x07, 0xB0, 0x00, 0x00, 0x00,
  0x0A, 0x90, 0x00, 0x00, 0x00,
  0x0D, 0xAB, 0xEF, 0xD8, 0x00,
  0x1F, 0xF6, 0x11, 0x8F, 0xB0,
  0x3F, 0x80, 0x00, 0x0A, 0xF6,
  0x00, 0x00, 0x00, 0x04, 0xFB,
  0x00, 0x00, 0x00, 0x01, 0xFE,
  0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0xFE,
  0xBF, 0x30, 0x00, 0x03, 0xFB,
  0x6F, 0x90, 0x00, 0x09, 0xF5,
  0x0A, 0xF7, 0x11, 0x7F, 0xA0,
  0x00, 0x7C, 0xFF, 0xC6, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0036[ 80] = { /* code 0036, DIGIT SIX */
  0x00, 0x18, 0xDF, 0xEB, 0x40,
  0x01, 0xDC, 0x30, 0x3B, 0xF6,
  0x0A, 0xE1, 0x00, 0x02, 0xFD,
  0x3F, 0x90, 0x00, 0x00, 0x00,
  0x7F, 0x50, 0x00, 0x00, 0x00,
  0xBF, 0x26, 0xDF, 0xE9, 0x10,
  0xDF, 0x7B, 0x20, 0x6F, 0xC0,
  0xFF, 0xD1, 0x00, 0x09, 0xF6,
  0xFF, 0x80, 0x00, 0x03, 0xFB,
  0xFF, 0x50, 0x00, 0x01, 0xFE,
  0xEF, 0x40, 0x00, 0x00, 0xFF,
  0xBF, 0x60, 0x00, 0x00, 0xFE,
  0x7F, 0x80, 0x00, 0x03, 0xFB,
  0x1E, 0xE1, 0x00, 0x08, 0xF6,
  0x05, 0xFA, 0x20, 0x6F, 0xB0,
  0x00, 0x4B, 0xEF, 0xD7, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0037[ 80] = { /* code 0037, DIGIT SEVEN */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x00, 0x01, 0xE9,
  0x00, 0x00, 0x00, 0x0B, 0xD1,
  0x00, 0x00, 0x00, 0x6F, 0x30,
  0x00, 0x00, 0x01, 0xE9, 0x00,
  0x00, 0x00, 0x08, 0xE1, 0x00,
  0x00, 0x00, 0x1F, 0x70, 0x00,
  0x00, 0x00, 0x7F, 0x10, 0x00,
  0x00, 0x00, 0xE9, 0x00, 0x00,
  0x00, 0x05, 0xF4, 0x00, 0x00,
  0x00, 0x0A, 0xD0, 0x00, 0x00,
  0x00, 0x0E, 0x90, 0x00, 0x00,
  0x00, 0x4F, 0x50, 0x00, 0x00,
  0x00, 0x8F, 0x10, 0x00, 0x00,
  0x00, 0xBD, 0x00, 0x00, 0x00,
  0x00, 0xEB, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0038[ 80] = { /* code 0038, DIGIT EIGHT */
  0x00, 0x4B, 0xFF, 0xB4, 0x00,
  0x04, 0xFC, 0x11, 0xCF, 0x40,
  0x0B, 0xF3, 0x00, 0x3F, 0xB0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0F, 0xF0, 0x00, 0x0F, 0xF0,
  0x0A, 0xF3, 0x00, 0x3F, 0xB0,
  0x02, 0xDB, 0x11, 0xBD, 0x20,
  0x00, 0x3E, 0xFF, 0xE3, 0x00,
  0x08, 0xE5, 0x00, 0x6E, 0x80,
  0x7F, 0x60, 0x00, 0x06, 0xF7,
  0xDF, 0x10, 0x00, 0x01, 0xFD,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xDF, 0x20, 0x00, 0x02, 0xFD,
  0x8F, 0x70, 0x00, 0x07, 0xF8,
  0x1D, 0xF6, 0x11, 0x6F, 0xD1,
  0x01, 0x7C, 0xFF, 0xC7, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0039[ 80] = { /* code 0039, DIGIT NINE */
  0x00, 0x7D, 0xFE, 0xB4, 0x00,
  0x0B, 0xF6, 0x02, 0xAF, 0x50,
  0x6F, 0x80, 0x00, 0x1E, 0xE1,
  0xBF, 0x30, 0x00, 0x08, 0xF7,
  0xEF, 0x00, 0x00, 0x06, 0xFB,
  0xFF, 0x00, 0x00, 0x04, 0xFE,
  0xEF, 0x10, 0x00, 0x05, 0xFF,
  0xBF, 0x30, 0x00, 0x08, 0xFF,
  0x6F, 0x90, 0x00, 0x1D, 0xFF,
  0x0C, 0xF6, 0x02, 0xB8, 0xFD,
  0x01, 0x9E, 0xFD, 0x62, 0xFB,
  0x00, 0x00, 0x00, 0x05, 0xF8,
  0x00, 0x00, 0x00, 0x08, 0xF3,
  0xDF, 0x20, 0x00, 0x1E, 0xA0,
  0x6F, 0xB3, 0x03, 0xCD, 0x10,
  0x04, 0xBE, 0xFD, 0x81, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_003A[ 12] = { /* code 003A, COLON */
  0xFF,
  0xFF,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_003B[ 15] = { /* code 003B, SEMICOLON */
  0xFF,
  0xFF,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0xFF,
  0xFF,
  0x0F,
  0x3D,
  0xC3
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_003C[ 84] = { /* code 003C, LESS-THAN SIGN */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xC0,
  0x00, 0x00, 0x00, 0x00, 0x17, 0xDA, 0x40,
  0x00, 0x00, 0x00, 0x39, 0xE8, 0x20, 0x00,
  0x00, 0x00, 0x5B, 0xD6, 0x10, 0x00, 0x00,
  0x01, 0x7D, 0xB4, 0x00, 0x00, 0x00, 0x00,
  0x8D, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x9D, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x01, 0x7D, 0xA4, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x5B, 0xC6, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x39, 0xD8, 0x20, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x17, 0xDA, 0x30,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xC0
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_003D[ 35] = { /* code 003D, EQUALS SIGN */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_003E[ 84] = { /* code 003E, GREATER-THAN SIGN */
  0xC5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x4A, 0xD7, 0x10, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x28, 0xE9, 0x30, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x16, 0xDB, 0x50, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x04, 0xBD, 0x71, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x8D, 0x80,
  0x00, 0x00, 0x00, 0x00, 0x02, 0x8D, 0x90,
  0x00, 0x00, 0x00, 0x04, 0xAD, 0x71, 0x00,
  0x00, 0x00, 0x06, 0xCB, 0x50, 0x00, 0x00,
  0x00, 0x28, 0xD9, 0x30, 0x00, 0x00, 0x00,
  0x3A, 0xD7, 0x10, 0x00, 0x00, 0x00, 0x00,
  0xC5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_003F[ 85] = { /* code 003F, QUESTION MARK */
  0x00, 0x7C, 0xFF, 0xD9, 0x20,
  0x0B, 0xF7, 0x10, 0x4E, 0xE2,
  0x7F, 0x80, 0x00, 0x05, 0xFA,
  0xCF, 0x30, 0x00, 0x01, 0xFE,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x00, 0x04, 0xFB,
  0x00, 0x00, 0x00, 0x0B, 0xF3,
  0x00, 0x00, 0x00, 0x7E, 0x30,
  0x00, 0x00, 0x05, 0xF5, 0x00,
  0x00, 0x00, 0x4F, 0x90, 0x00,
  0x00, 0x00, 0xBF, 0x20, 0x00,
  0x00, 0x00, 0xDD, 0x00, 0x00,
  0x00, 0x00, 0xDD, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00,
  0x00, 0x00, 0xFF, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0040[190] = { /* code 0040, COMMERCIAL AT */
  0x00, 0x00, 0x00, 0x38, 0xBE, 0xFF, 0xEB, 0x72, 0x00, 0x00,
  0x00, 0x00, 0x3B, 0xD7, 0x31, 0x00, 0x14, 0x8D, 0x91, 0x00,
  0x00, 0x06, 0xE5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x8D, 0x10,
  0x00, 0x7D, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0xC0,
  0x04, 0xD1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA7,
  0x0D, 0x40, 0x00, 0x03, 0xBE, 0xFB, 0x23, 0x40, 0x00, 0x3C,
  0x4B, 0x00, 0x00, 0x5D, 0x51, 0x05, 0xBC, 0x50, 0x00, 0x0F,
  0xA6, 0x00, 0x03, 0xE2, 0x00, 0x00, 0x7F, 0x10, 0x00, 0x0F,
  0xD3, 0x00, 0x0A, 0x70, 0x00, 0x00, 0x6B, 0x00, 0x00, 0x2D,
  0xF0, 0x00, 0x0E, 0x20, 0x00, 0x00, 0xB7, 0x00, 0x00, 0x7A,
  0xF0, 0x00, 0x0F, 0x00, 0x00, 0x00, 0xE3, 0x00, 0x01, 0xD3,
  0xE1, 0x00, 0x0E, 0x20, 0x00, 0x08, 0xE0, 0x00, 0x0A, 0x90,
  0xB4, 0x00, 0x08, 0xB2, 0x02, 0x9A, 0xE2, 0x15, 0xC9, 0x00,
  0x6A, 0x00, 0x01, 0x8E, 0xFC, 0x51, 0xBF, 0xEB, 0x40, 0x00,
  0x0D, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x03, 0xD2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x4D, 0x50, 0x00, 0x00, 0x00, 0x00, 0x01, 0x71, 0x00,
  0x00, 0x02, 0xAD, 0x73, 0x10, 0x01, 0x37, 0xB8, 0x10, 0x00,
  0x00, 0x00, 0x03, 0x8B, 0xEF, 0xFE, 0xB7, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0041[119] = { /* code 0041, LATIN CAPITAL LETTER A */
  0x00, 0x00, 0x02, 0xFF, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x07, 0xFF, 0x60, 0x00, 0x00,
  0x00, 0x00, 0x0D, 0xAC, 0xB0, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0x57, 0xF2, 0x00, 0x00,
  0x00, 0x00, 0x8F, 0x12, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0xDA, 0x00, 0xBD, 0x00, 0x00,
  0x00, 0x04, 0xF5, 0x00, 0x7F, 0x30, 0x00,
  0x00, 0x09, 0xE0, 0x00, 0x2F, 0x80, 0x00,
  0x00, 0x0E, 0xA0, 0x00, 0x0B, 0xE0, 0x00,
  0x00, 0x5F, 0x50, 0x00, 0x06, 0xF4, 0x00,
  0x00, 0xAE, 0x00, 0x00, 0x01, 0xFA, 0x00,
  0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x10,
  0x06, 0xF2, 0x00, 0x00, 0x00, 0x3F, 0x60,
  0x0B, 0xB0, 0x00, 0x00, 0x00, 0x0D, 0xB0,
  0x2F, 0x60, 0x00, 0x00, 0x00, 0x07, 0xF2,
  0x7E, 0x10, 0x00, 0x00, 0x00, 0x02, 0xF7,
  0xC9, 0x00, 0x00, 0x00, 0x00, 0x00, 0xBC
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0042[102] = { /* code 0042, LATIN CAPITAL LETTER B */
  0xFF, 0xFF, 0xFF, 0xFD, 0x81, 0x00,
  0xFF, 0x00, 0x00, 0x16, 0xED, 0x10,
  0xFF, 0x00, 0x00, 0x00, 0x5F, 0x80,
  0xFF, 0x00, 0x00, 0x00, 0x1F, 0xD0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x1F, 0xD0,
  0xFF, 0x00, 0x00, 0x00, 0x6F, 0x70,
  0xFF, 0x00, 0x00, 0x26, 0xEA, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xC3, 0x00,
  0xFF, 0x00, 0x00, 0x03, 0x9F, 0xA0,
  0xFF, 0x00, 0x00, 0x00, 0x08, 0xF7,
  0xFF, 0x00, 0x00, 0x00, 0x02, 0xFD,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0xFF, 0x00, 0x00, 0x00, 0x06, 0xF9,
  0xFF, 0x00, 0x00, 0x02, 0x6E, 0xE2,
  0xFF, 0xFF, 0xFF, 0xFE, 0xD9, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0043[119] = { /* code 0043, LATIN CAPITAL LETTER C */
  0x00, 0x01, 0x7C, 0xEF, 0xEC, 0x71, 0x00,
  0x00, 0x4E, 0xC5, 0x10, 0x26, 0xEE, 0x50,
  0x03, 0xFB, 0x10, 0x00, 0x00, 0x2E, 0xF3,
  0x0D, 0xF2, 0x00, 0x00, 0x00, 0x06, 0xFA,
  0x5F, 0x90, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0xAF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xDF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xAF, 0x50, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0x5F, 0xA0, 0x00, 0x00, 0x00, 0x03, 0xFB,
  0x0D, 0xF2, 0x00, 0x00, 0x00, 0x09, 0xF6,
  0x03, 0xFC, 0x10, 0x00, 0x00, 0x4F, 0xC0,
  0x00, 0x4E, 0xD5, 0x10, 0x27, 0xFC, 0x10,
  0x00, 0x01, 0x8C, 0xFF, 0xEB, 0x60, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0044[119] = { /* code 0044, LATIN CAPITAL LETTER D */
  0xFF, 0xFF, 0xFF, 0xFD, 0xB5, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x13, 0x9F, 0xA0, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x07, 0xF7, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xDF, 0x10,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x70,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xB0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xB0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x70,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xCF, 0x10,
  0xFF, 0x00, 0x00, 0x00, 0x07, 0xF7, 0x00,
  0xFF, 0x00, 0x00, 0x03, 0x8F, 0xA0, 0x00,
  0xFF, 0xFF, 0xFF, 0xFD, 0xB5, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0045[102] = { /* code 0045, LATIN CAPITAL LETTER E */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xB0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0046[ 85] = { /* code 0046, LATIN CAPITAL LETTER F */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xF4,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0047[136] = { /* code 0047, LATIN CAPITAL LETTER G */
  0x00, 0x00, 0x6B, 0xEF, 0xFD, 0x93, 0x00, 0x00,
  0x00, 0x3D, 0xE7, 0x20, 0x04, 0xBF, 0x90, 0x00,
  0x02, 0xED, 0x10, 0x00, 0x00, 0x09, 0xF9, 0x00,
  0x0C, 0xF2, 0x00, 0x00, 0x00, 0x00, 0xCF, 0x40,
  0x4F, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xA0,
  0xAF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xE0,
  0xDF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xF0,
  0xDF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xAF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xF0,
  0x5F, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xF0,
  0x0D, 0xF3, 0x00, 0x00, 0x00, 0x00, 0xBF, 0xF0,
  0x03, 0xFD, 0x10, 0x00, 0x00, 0x08, 0xCD, 0xF0,
  0x00, 0x4E, 0xD6, 0x10, 0x14, 0xBC, 0x1B, 0xF0,
  0x00, 0x01, 0x7C, 0xFF, 0xEB, 0x50, 0x0A, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0048[119] = { /* code 0048, LATIN CAPITAL LETTER H */
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0049[ 17] = { /* code 0049, LATIN CAPITAL LETTER I */
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_004A[ 85] = { /* code 004A, LATIN CAPITAL LETTER J */
  0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xEF, 0x10, 0x00, 0x2F, 0xD0,
  0xAF, 0x50, 0x00, 0x5F, 0x90,
  0x3F, 0xD3, 0x03, 0xDE, 0x20,
  0x03, 0xBE, 0xFE, 0x92, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_004B[119] = { /* code 004B, LATIN CAPITAL LETTER K */
  0xFF, 0x00, 0x00, 0x00, 0x03, 0xEB, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x2E, 0xB1, 0x00,
  0xFF, 0x00, 0x00, 0x01, 0xDD, 0x10, 0x00,
  0xFF, 0x00, 0x00, 0x1D, 0xD1, 0x00, 0x00,
  0xFF, 0x00, 0x01, 0xBE, 0x20, 0x00, 0x00,
  0xFF, 0x00, 0x0B, 0xE3, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xAE, 0x30, 0x00, 0x00, 0x00,
  0xFF, 0x09, 0xFE, 0x20, 0x00, 0x00, 0x00,
  0xFF, 0x8F, 0x6E, 0xB0, 0x00, 0x00, 0x00,
  0xFF, 0xF6, 0x04, 0xF7, 0x00, 0x00, 0x00,
  0xFF, 0x70, 0x00, 0x8F, 0x30, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x0C, 0xD1, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x02, 0xEA, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x6F, 0x70, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x0A, 0xF3, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x01, 0xDD, 0x10,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x90
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_004C[ 85] = { /* code 004C, LATIN CAPITAL LETTER L */
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_004D[119] = { /* code 004D, LATIN CAPITAL LETTER M */
  0xFF, 0x90, 0x00, 0x00, 0x00, 0x0A, 0xFF,
  0xFF, 0xE0, 0x00, 0x00, 0x00, 0x0E, 0xFF,
  0xFF, 0xE3, 0x00, 0x00, 0x00, 0x4E, 0xFF,
  0xFF, 0xA8, 0x00, 0x00, 0x00, 0x8A, 0xFF,
  0xFF, 0x6C, 0x00, 0x00, 0x00, 0xD6, 0xFF,
  0xFF, 0x2F, 0x20, 0x00, 0x02, 0xF2, 0xFF,
  0xFF, 0x0D, 0x60, 0x00, 0x07, 0xD0, 0xFF,
  0xFF, 0x08, 0xB0, 0x00, 0x0B, 0x80, 0xFF,
  0xFF, 0x04, 0xF1, 0x00, 0x1F, 0x40, 0xFF,
  0xFF, 0x01, 0xF5, 0x00, 0x5F, 0x10, 0xFF,
  0xFF, 0x00, 0xBA, 0x00, 0xAB, 0x00, 0xFF,
  0xFF, 0x00, 0x7E, 0x00, 0xE7, 0x00, 0xFF,
  0xFF, 0x00, 0x3F, 0x34, 0xF3, 0x00, 0xFF,
  0xFF, 0x00, 0x0E, 0x89, 0xE0, 0x00, 0xFF,
  0xFF, 0x00, 0x0A, 0xDD, 0xA0, 0x00, 0xFF,
  0xFF, 0x00, 0x06, 0xFF, 0x60, 0x00, 0xFF,
  0xFF, 0x00, 0x02, 0xFF, 0x20, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_004E[119] = { /* code 004E, LATIN CAPITAL LETTER N */
  0xFE, 0x10, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x90, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0xD4, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x4D, 0x10, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x0A, 0x80, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x01, 0xE3, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x6C, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x0B, 0x70, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x02, 0xE2, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x7B, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0C, 0x60, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x03, 0xE1, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x8A, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x1D, 0x4F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x04, 0xDF, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xAF, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x1E, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_004F[136] = { /* code 004F, LATIN CAPITAL LETTER O */
  0x00, 0x01, 0x7C, 0xEF, 0xEC, 0x71, 0x00, 0x00,
  0x00, 0x3D, 0xD6, 0x10, 0x16, 0xDD, 0x30, 0x00,
  0x03, 0xED, 0x10, 0x00, 0x00, 0x1D, 0xE3, 0x00,
  0x0C, 0xF3, 0x00, 0x00, 0x00, 0x03, 0xFC, 0x00,
  0x5F, 0xB0, 0x00, 0x00, 0x00, 0x00, 0xAF, 0x40,
  0xAF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xA0,
  0xDF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xDF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0xAF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x5F, 0xA0,
  0x5F, 0xA0, 0x00, 0x00, 0x00, 0x00, 0xAF, 0x40,
  0x0C, 0xF3, 0x00, 0x00, 0x00, 0x03, 0xFC, 0x00,
  0x03, 0xED, 0x10, 0x00, 0x00, 0x1D, 0xE3, 0x00,
  0x00, 0x3D, 0xD6, 0x10, 0x16, 0xDD, 0x30, 0x00,
  0x00, 0x01, 0x7C, 0xEF, 0xEC, 0x71, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0050[102] = { /* code 0050, LATIN CAPITAL LETTER P */
  0xFF, 0xFF, 0xFF, 0xFC, 0x81, 0x00,
  0xFF, 0x00, 0x00, 0x16, 0xEE, 0x20,
  0xFF, 0x00, 0x00, 0x00, 0x6F, 0xA0,
  0xFF, 0x00, 0x00, 0x00, 0x1F, 0xE0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x1F, 0xE0,
  0xFF, 0x00, 0x00, 0x00, 0x7F, 0x90,
  0xFF, 0x00, 0x00, 0x27, 0xFD, 0x10,
  0xFF, 0xFF, 0xFF, 0xEB, 0x70, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0051[144] = { /* code 0051, LATIN CAPITAL LETTER Q */
  0x00, 0x01, 0x7C, 0xEF, 0xEC, 0x70, 0x00, 0x00,
  0x00, 0x3D, 0xD6, 0x10, 0x16, 0xED, 0x30, 0x00,
  0x03, 0xED, 0x10, 0x00, 0x00, 0x1D, 0xE2, 0x00,
  0x0C, 0xF3, 0x00, 0x00, 0x00, 0x03, 0xFC, 0x00,
  0x5F, 0xB0, 0x00, 0x00, 0x00, 0x00, 0xBF, 0x40,
  0xAF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x6F, 0x90,
  0xDF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xC0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xE0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xDF, 0x20, 0x00, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0xAF, 0x50, 0x00, 0x00, 0x00, 0x00, 0x4F, 0xA0,
  0x5F, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x9F, 0x50,
  0x0D, 0xF3, 0x00, 0x00, 0x5A, 0x11, 0xED, 0x00,
  0x03, 0xFD, 0x10, 0x00, 0x2C, 0xDB, 0xE3, 0x00,
  0x00, 0x4E, 0xD6, 0x20, 0x16, 0xFF, 0x80, 0x00,
  0x00, 0x01, 0x8C, 0xFF, 0xEC, 0x76, 0xFC, 0x40,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x60
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0052[102] = { /* code 0052, LATIN CAPITAL LETTER R */
  0xFF, 0xFF, 0xFF, 0xFE, 0xC7, 0x10,
  0xFF, 0x00, 0x00, 0x02, 0x7F, 0xD1,
  0xFF, 0x00, 0x00, 0x00, 0x07, 0xF9,
  0xFF, 0x00, 0x00, 0x00, 0x01, 0xFE,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x02, 0xFD,
  0xFF, 0x00, 0x00, 0x00, 0x07, 0xF7,
  0xFF, 0x00, 0x00, 0x03, 0x8F, 0x80,
  0xFF, 0xFF, 0xFF, 0xFF, 0xE4, 0x00,
  0xFF, 0x00, 0x00, 0x03, 0xCE, 0x30,
  0xFF, 0x00, 0x00, 0x00, 0x5F, 0xA0,
  0xFF, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0E, 0xF2,
  0xFF, 0x00, 0x00, 0x00, 0x0B, 0xF4,
  0xFF, 0x00, 0x00, 0x00, 0x09, 0xF6,
  0xFF, 0x00, 0x00, 0x00, 0x04, 0xFB
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0053[102] = { /* code 0053, LATIN CAPITAL LETTER S */
  0x00, 0x6C, 0xEF, 0xEB, 0x50, 0x00,
  0x1B, 0xF7, 0x10, 0x29, 0xFA, 0x00,
  0x8F, 0x70, 0x00, 0x00, 0xAF, 0x60,
  0xEF, 0x10, 0x00, 0x00, 0x3F, 0xC0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xDF, 0x30, 0x00, 0x00, 0x00, 0x00,
  0x8F, 0xC2, 0x00, 0x00, 0x00, 0x00,
  0x0A, 0xFF, 0xB6, 0x20, 0x00, 0x00,
  0x00, 0x39, 0xDF, 0xFC, 0x60, 0x00,
  0x00, 0x00, 0x03, 0x7E, 0xFC, 0x10,
  0x00, 0x00, 0x00, 0x01, 0xBF, 0x90,
  0x00, 0x00, 0x00, 0x00, 0x3F, 0xE0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xCF, 0x30, 0x00, 0x00, 0x1F, 0xD0,
  0x7F, 0xA0, 0x00, 0x00, 0x6F, 0x80,
  0x0B, 0xF9, 0x20, 0x17, 0xEB, 0x10,
  0x00, 0x6B, 0xEF, 0xFC, 0x70, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0054[102] = { /* code 0054, LATIN CAPITAL LETTER T */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0055[119] = { /* code 0055, LATIN CAPITAL LETTER U */
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xDF, 0x20, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0x9F, 0x60, 0x00, 0x00, 0x00, 0x6F, 0x90,
  0x2F, 0xD1, 0x00, 0x00, 0x01, 0xDF, 0x20,
  0x05, 0xFC, 0x51, 0x01, 0x5C, 0xF5, 0x00,
  0x00, 0x28, 0xCF, 0xFF, 0xC8, 0x20, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0056[102] = { /* code 0056, LATIN CAPITAL LETTER V */
  0xD8, 0x00, 0x00, 0x00, 0x00, 0x7D,
  0x8C, 0x00, 0x00, 0x00, 0x00, 0xC8,
  0x4F, 0x20, 0x00, 0x00, 0x02, 0xF4,
  0x0E, 0x70, 0x00, 0x00, 0x06, 0xE0,
  0x0A, 0xB0, 0x00, 0x00, 0x0B, 0xA0,
  0x06, 0xF1, 0x00, 0x00, 0x1F, 0x60,
  0x01, 0xF6, 0x00, 0x00, 0x5F, 0x10,
  0x00, 0xCA, 0x00, 0x00, 0xAC, 0x00,
  0x00, 0x7E, 0x00, 0x00, 0xE7, 0x00,
  0x00, 0x3F, 0x50, 0x04, 0xF3, 0x00,
  0x00, 0x0E, 0x90, 0x09, 0xE0, 0x00,
  0x00, 0x09, 0xE0, 0x0D, 0x90, 0x00,
  0x00, 0x05, 0xF3, 0x3F, 0x50, 0x00,
  0x00, 0x01, 0xF8, 0x8F, 0x10, 0x00,
  0x00, 0x00, 0xBD, 0xCB, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF7, 0x00, 0x00,
  0x00, 0x00, 0x2F, 0xF2, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0057[170] = { /* code 0057, LATIN CAPITAL LETTER W */
  0xD8, 0x00, 0x00, 0x00, 0x2F, 0xF2, 0x00, 0x00, 0x07, 0xD0,
  0xAC, 0x00, 0x00, 0x00, 0x6F, 0xF5, 0x00, 0x00, 0x0B, 0xA0,
  0x6F, 0x10, 0x00, 0x00, 0xAC, 0xE8, 0x00, 0x00, 0x0E, 0x60,
  0x3F, 0x40, 0x00, 0x00, 0xE8, 0xBB, 0x00, 0x00, 0x3F, 0x30,
  0x0E, 0x80, 0x00, 0x03, 0xF4, 0x8E, 0x00, 0x00, 0x7E, 0x00,
  0x0B, 0xC0, 0x00, 0x07, 0xF1, 0x5F, 0x20, 0x00, 0xBB, 0x00,
  0x07, 0xF1, 0x00, 0x0B, 0xB0, 0x2F, 0x50, 0x00, 0xE7, 0x00,
  0x03, 0xF4, 0x00, 0x0F, 0x70, 0x0E, 0x80, 0x03, 0xF3, 0x00,
  0x00, 0xF8, 0x00, 0x4F, 0x30, 0x0B, 0xB0, 0x07, 0xF0, 0x00,
  0x00, 0xBC, 0x00, 0x8E, 0x00, 0x08, 0xE0, 0x0B, 0xB0, 0x00,
  0x00, 0x8F, 0x10, 0xCB, 0x00, 0x05, 0xF2, 0x0E, 0x80, 0x00,
  0x00, 0x4F, 0x41, 0xF7, 0x00, 0x02, 0xF5, 0x3F, 0x40, 0x00,
  0x00, 0x1F, 0x85, 0xF3, 0x00, 0x00, 0xE8, 0x7F, 0x10, 0x00,
  0x00, 0x0C, 0xC9, 0xE0, 0x00, 0x00, 0xBB, 0xBC, 0x00, 0x00,
  0x00, 0x09, 0xFE, 0xA0, 0x00, 0x00, 0x8E, 0xE9, 0x00, 0x00,
  0x00, 0x05, 0xFF, 0x60, 0x00, 0x00, 0x5F, 0xF5, 0x00, 0x00,
  0x00, 0x02, 0xFF, 0x20, 0x00, 0x00, 0x2F, 0xF2, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0058[119] = { /* code 0058, LATIN CAPITAL LETTER X */
  0xAF, 0x30, 0x00, 0x00, 0x00, 0x3F, 0xA0,
  0x1E, 0xD0, 0x00, 0x00, 0x00, 0xCE, 0x10,
  0x04, 0xF8, 0x00, 0x00, 0x07, 0xF5, 0x00,
  0x00, 0x9F, 0x30, 0x00, 0x3F, 0xA0, 0x00,
  0x00, 0x1D, 0xD0, 0x00, 0xCE, 0x10, 0x00,
  0x00, 0x04, 0xF8, 0x07, 0xF5, 0x00, 0x00,
  0x00, 0x00, 0x9F, 0x6F, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x1D, 0xFD, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x09, 0xF9, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xEF, 0x30, 0x00, 0x00,
  0x00, 0x00, 0xCE, 0x2D, 0xC0, 0x00, 0x00,
  0x00, 0x07, 0xF5, 0x04, 0xF7, 0x00, 0x00,
  0x00, 0x2F, 0xA0, 0x00, 0xAF, 0x20, 0x00,
  0x00, 0xBE, 0x20, 0x00, 0x1E, 0xB0, 0x00,
  0x06, 0xF6, 0x00, 0x00, 0x06, 0xF6, 0x00,
  0x2E, 0xB0, 0x00, 0x00, 0x00, 0xBE, 0x20,
  0xAF, 0x20, 0x00, 0x00, 0x00, 0x2F, 0xA0
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0059[102] = { /* code 0059, LATIN CAPITAL LETTER Y */
  0xBD, 0x00, 0x00, 0x00, 0x00, 0xDB,
  0x3F, 0x60, 0x00, 0x00, 0x06, 0xF3,
  0x0A, 0xE1, 0x00, 0x00, 0x1E, 0xA0,
  0x03, 0xF7, 0x00, 0x00, 0x7F, 0x30,
  0x00, 0x9E, 0x10, 0x01, 0xE9, 0x00,
  0x00, 0x2F, 0x90, 0x09, 0xF2, 0x00,
  0x00, 0x09, 0xF2, 0x2F, 0x90, 0x00,
  0x00, 0x01, 0xFB, 0xBF, 0x10, 0x00,
  0x00, 0x00, 0x8F, 0xF8, 0x00, 0x00,
  0x00, 0x00, 0x1F, 0xF1, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_005A[102] = { /* code 005A, LATIN CAPITAL LETTER Z */
  0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD,
  0x00, 0x00, 0x00, 0x00, 0x04, 0xFB,
  0x00, 0x00, 0x00, 0x00, 0x1E, 0xE2,
  0x00, 0x00, 0x00, 0x00, 0xAF, 0x60,
  0x00, 0x00, 0x00, 0x06, 0xFB, 0x00,
  0x00, 0x00, 0x00, 0x2E, 0xE2, 0x00,
  0x00, 0x00, 0x00, 0xBF, 0x60, 0x00,
  0x00, 0x00, 0x07, 0xFB, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0xE2, 0x00, 0x00,
  0x00, 0x00, 0xCF, 0x60, 0x00, 0x00,
  0x00, 0x08, 0xFB, 0x00, 0x00, 0x00,
  0x00, 0x3F, 0xE2, 0x00, 0x00, 0x00,
  0x01, 0xDF, 0x60, 0x00, 0x00, 0x00,
  0x09, 0xFA, 0x00, 0x00, 0x00, 0x00,
  0x4F, 0xE1, 0x00, 0x00, 0x00, 0x00,
  0xEF, 0x50, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_005B[ 42] = { /* code 005B, LEFT SQUARE BRACKET */
  0xFF, 0xFF,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xF0, 0x00,
  0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_005C[ 76] = { /* code 005C, REVERSE SOLIDUS */
  0xC0, 0x00, 0x00, 0x00,
  0x85, 0x00, 0x00, 0x00,
  0x3A, 0x00, 0x00, 0x00,
  0x0D, 0x00, 0x00, 0x00,
  0x09, 0x40, 0x00, 0x00,
  0x04, 0x90, 0x00, 0x00,
  0x00, 0xD0, 0x00, 0x00,
  0x00, 0xA4, 0x00, 0x00,
  0x00, 0x59, 0x00, 0x00,
  0x00, 0x1D, 0x00, 0x00,
  0x00, 0x0B, 0x30, 0x00,
  0x00, 0x07, 0x80, 0x00,
  0x00, 0x02, 0xD0, 0x00,
  0x00, 0x00, 0xC3, 0x00,
  0x00, 0x00, 0x88, 0x00,
  0x00, 0x00, 0x3D, 0x00,
  0x00, 0x00, 0x0D, 0x30,
  0x00, 0x00, 0x09, 0x80,
  0x00, 0x00, 0x04, 0xD0
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_005D[ 42] = { /* code 005D, RIGHT SQUARE BRACKET */
  0xFF, 0xFF,
  0x00, 0x0F,
  0x00, 0x0F,
  0x00, 0x0F,
  0x00, 0x0F,
  0x00, 0x0F,
  0x00, 0x0F,
  0x00, 0x0F,
  0x00, 0x0F,
  0x00, 0x0F,
  0x00, 0x0F,
  0x00, 0x0F,
  0x00, 0x0F,
  0x00, 0x0F,
  0x00, 0x0F,
  0x00, 0x0F,
  0x00, 0x0F,
  0x00, 0x0F,
  0x00, 0x0F,
  0x00, 0x0F,
  0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_005E[ 42] = { /* code 005E, CIRCUMFLEX ACCENT */
  0x00, 0x00, 0x0A, 0xF8, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x9D, 0x3D, 0x80, 0x00, 0x00,
  0x00, 0x08, 0xD1, 0x01, 0xD8, 0x00, 0x00,
  0x00, 0x8D, 0x10, 0x00, 0x1D, 0x80, 0x00,
  0x08, 0xD1, 0x00, 0x00, 0x01, 0xD8, 0x00,
  0x8B, 0x10, 0x00, 0x00, 0x00, 0x1B, 0x80
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_005F[  6] = { /* code 005F, LOW LINE */
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0060[  8] = { /* code 0060, GRAVE ACCENT */
  0x9E, 0x10,
  0x1C, 0x80,
  0x03, 0xE2,
  0x00, 0x6B
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0061[ 72] = { /* code 0061, LATIN SMALL LETTER A */
  0x00, 0x3A, 0xEF, 0xFC, 0x60, 0x00,
  0x04, 0xFC, 0x30, 0x19, 0xF7, 0x00,
  0x0C, 0xF3, 0x00, 0x01, 0xFE, 0x00,
  0x07, 0x80, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x00, 0x00, 0x18, 0xFF, 0x00,
  0x00, 0x39, 0xCD, 0xDA, 0xFF, 0x00,
  0x1B, 0xE7, 0x10, 0x00, 0xFF, 0x00,
  0xBF, 0x50, 0x00, 0x00, 0xFF, 0x00,
  0xFF, 0x00, 0x00, 0x03, 0xFF, 0x00,
  0xDF, 0x20, 0x00, 0x0A, 0xFF, 0x00,
  0x7F, 0xB2, 0x02, 0x9B, 0xEF, 0x10,
  0x06, 0xCF, 0xFB, 0x60, 0x7F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0062[102] = { /* code 0062, LATIN SMALL LETTER B */
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x05, 0xCF, 0xFC, 0x50, 0x00,
  0xFF, 0x89, 0x20, 0x3B, 0xF8, 0x00,
  0xFF, 0xB0, 0x00, 0x00, 0xCF, 0x40,
  0xFF, 0x30, 0x00, 0x00, 0x5F, 0xA0,
  0xFF, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0xFD, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFD, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0xFF, 0x40, 0x00, 0x00, 0x5F, 0xA0,
  0xFF, 0xB0, 0x00, 0x00, 0xCF, 0x30,
  0xFF, 0x8A, 0x20, 0x2B, 0xF8, 0x00,
  0xFF, 0x06, 0xCF, 0xFB, 0x50, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0063[ 60] = { /* code 0063, LATIN SMALL LETTER C */
  0x00, 0x4B, 0xEF, 0xD8, 0x10,
  0x07, 0xF9, 0x10, 0x5E, 0xE2,
  0x3F, 0xB0, 0x00, 0x07, 0xFA,
  0x9F, 0x50, 0x00, 0x01, 0xFE,
  0xDF, 0x10, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xEF, 0x20, 0x00, 0x00, 0x00,
  0xAF, 0x50, 0x00, 0x01, 0xFE,
  0x4F, 0xB0, 0x00, 0x07, 0xF9,
  0x08, 0xF9, 0x10, 0x5E, 0xD1,
  0x00, 0x5B, 0xFF, 0xD8, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0064[102] = { /* code 0064, LATIN SMALL LETTER D */
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x5B, 0xFF, 0xC6, 0x0F, 0xF0,
  0x08, 0xFB, 0x30, 0x29, 0x8F, 0xF0,
  0x3F, 0xC0, 0x00, 0x00, 0xAF, 0xF0,
  0xAF, 0x50, 0x00, 0x00, 0x3F, 0xF0,
  0xDF, 0x20, 0x00, 0x00, 0x0E, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0D, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0D, 0xF0,
  0xDF, 0x20, 0x00, 0x00, 0x0E, 0xF0,
  0xAF, 0x50, 0x00, 0x00, 0x3F, 0xF0,
  0x4F, 0xC0, 0x00, 0x00, 0xAF, 0xF0,
  0x08, 0xFB, 0x30, 0x29, 0x8F, 0xF0,
  0x00, 0x5C, 0xFF, 0xC5, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0065[ 60] = { /* code 0065, LATIN SMALL LETTER E */
  0x00, 0x5C, 0xFF, 0xC5, 0x00,
  0x08, 0xF9, 0x11, 0x9F, 0x80,
  0x4F, 0xC0, 0x00, 0x0C, 0xF3,
  0xAF, 0x60, 0x00, 0x05, 0xF9,
  0xDF, 0x30, 0x00, 0x02, 0xFC,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xEF, 0x00, 0x00, 0x00, 0x00,
  0xAF, 0x30, 0x00, 0x00, 0x00,
  0x4F, 0x90, 0x00, 0x04, 0xFA,
  0x08, 0xF7, 0x10, 0x4D, 0xE2,
  0x00, 0x6C, 0xFF, 0xD8, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0066[ 51] = { /* code 0066, LATIN SMALL LETTER F */
  0x00, 0x3B, 0xFF,
  0x00, 0xCF, 0x40,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x9F, 0xFF, 0xFF,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0067[102] = { /* code 0067, LATIN SMALL LETTER G */
  0x00, 0x5B, 0xFF, 0xC5, 0x0F, 0xF0,
  0x08, 0xFB, 0x30, 0x29, 0x8F, 0xF0,
  0x3F, 0xC0, 0x00, 0x00, 0xAF, 0xF0,
  0xAF, 0x50, 0x00, 0x00, 0x3F, 0xF0,
  0xDF, 0x20, 0x00, 0x00, 0x0E, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0D, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0D, 0xF0,
  0xDF, 0x20, 0x00, 0x00, 0x0E, 0xF0,
  0xAF, 0x50, 0x00, 0x00, 0x3F, 0xF0,
  0x4F, 0xC0, 0x00, 0x00, 0xAF, 0xF0,
  0x08, 0xFB, 0x30, 0x29, 0x8F, 0xF0,
  0x00, 0x5C, 0xFF, 0xC5, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x1F, 0xE0,
  0xEF, 0x10, 0x00, 0x00, 0x4F, 0xA0,
  0x9F, 0x60, 0x00, 0x00, 0xBF, 0x40,
  0x1D, 0xE5, 0x10, 0x3B, 0xF8, 0x00,
  0x01, 0x8C, 0xFF, 0xEA, 0x40, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0068[ 85] = { /* code 0068, LATIN SMALL LETTER H */
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x08, 0xEF, 0xD7, 0x00,
  0xFF, 0xA6, 0x01, 0xBF, 0x70,
  0xFF, 0x70, 0x00, 0x3F, 0xD0,
  0xFF, 0x30, 0x00, 0x1F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0069[ 17] = { /* code 0069, LATIN SMALL LETTER I */
  0xFF,
  0xFF,
  0x00,
  0x00,
  0x00,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_006A[ 44] = { /* code 006A, LATIN SMALL LETTER J */
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x00, 0xFF,
  0x04, 0xFD,
  0xFF, 0xC4
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_006B[ 85] = { /* code 006B, LATIN SMALL LETTER K */
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x0A, 0xD2,
  0xFF, 0x00, 0x00, 0xAD, 0x10,
  0xFF, 0x00, 0x0A, 0xD1, 0x00,
  0xFF, 0x00, 0xAD, 0x10, 0x00,
  0xFF, 0x0A, 0xF4, 0x00, 0x00,
  0xFF, 0xAE, 0xBC, 0x00, 0x00,
  0xFF, 0xE2, 0x2E, 0x70, 0x00,
  0xFF, 0x20, 0x06, 0xF2, 0x00,
  0xFF, 0x00, 0x00, 0xBB, 0x00,
  0xFF, 0x00, 0x00, 0x2F, 0x60,
  0xFF, 0x00, 0x00, 0x07, 0xE2,
  0xFF, 0x00, 0x00, 0x00, 0xCA
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_006C[ 17] = { /* code 006C, LATIN SMALL LETTER L */
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_006D[ 96] = { /* code 006D, LATIN SMALL LETTER M */
  0xFD, 0x18, 0xEF, 0xD6, 0x02, 0xAE, 0xFD, 0x70,
  0xFD, 0xB6, 0x01, 0xBF, 0x6D, 0x50, 0x19, 0xF7,
  0xFF, 0x70, 0x00, 0x3F, 0xF7, 0x00, 0x02, 0xFD,
  0xFF, 0x20, 0x00, 0x0F, 0xF1, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_006E[ 60] = { /* code 006E, LATIN SMALL LETTER N */
  0xFD, 0x18, 0xEF, 0xD7, 0x00,
  0xFD, 0xB5, 0x01, 0xBF, 0x70,
  0xFF, 0x70, 0x00, 0x3F, 0xD0,
  0xFF, 0x20, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_006F[ 72] = { /* code 006F, LATIN SMALL LETTER O */
  0x00, 0x4B, 0xEF, 0xEB, 0x40, 0x00,
  0x07, 0xFB, 0x20, 0x2B, 0xF7, 0x00,
  0x3F, 0xC0, 0x00, 0x00, 0xCF, 0x30,
  0xAF, 0x50, 0x00, 0x00, 0x5F, 0xA0,
  0xDF, 0x20, 0x00, 0x00, 0x2F, 0xD0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xDF, 0x20, 0x00, 0x00, 0x2F, 0xD0,
  0xAF, 0x50, 0x00, 0x00, 0x5F, 0xA0,
  0x3F, 0xC0, 0x00, 0x00, 0xCF, 0x30,
  0x07, 0xFB, 0x20, 0x2B, 0xF7, 0x00,
  0x00, 0x4B, 0xEF, 0xEB, 0x40, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0070[102] = { /* code 0070, LATIN SMALL LETTER P */
  0xFF, 0x05, 0xCF, 0xFC, 0x50, 0x00,
  0xFF, 0x89, 0x20, 0x3B, 0xF8, 0x00,
  0xFF, 0xA0, 0x00, 0x00, 0xCF, 0x40,
  0xFF, 0x30, 0x00, 0x00, 0x5F, 0xA0,
  0xFF, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0xFD, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFD, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x2F, 0xD0,
  0xFF, 0x40, 0x00, 0x00, 0x5F, 0xA0,
  0xFF, 0xB0, 0x00, 0x00, 0xCF, 0x40,
  0xFF, 0x8A, 0x20, 0x3B, 0xF8, 0x00,
  0xFF, 0x05, 0xCF, 0xFB, 0x50, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0071[102] = { /* code 0071, LATIN SMALL LETTER Q */
  0x00, 0x5B, 0xFF, 0xC6, 0x0F, 0xF0,
  0x08, 0xFB, 0x30, 0x29, 0x8F, 0xF0,
  0x4F, 0xC0, 0x00, 0x00, 0xAF, 0xF0,
  0xAF, 0x50, 0x00, 0x00, 0x3F, 0xF0,
  0xDF, 0x20, 0x00, 0x00, 0x0E, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0D, 0xF0,
  0xFF, 0x00, 0x00, 0x00, 0x0D, 0xF0,
  0xDF, 0x20, 0x00, 0x00, 0x0E, 0xF0,
  0xAF, 0x50, 0x00, 0x00, 0x3F, 0xF0,
  0x4F, 0xC0, 0x00, 0x00, 0xAF, 0xF0,
  0x08, 0xFB, 0x30, 0x29, 0x7F, 0xF0,
  0x00, 0x5C, 0xFF, 0xC5, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0,
  0x00, 0x00, 0x00, 0x00, 0x0F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0072[ 36] = { /* code 0072, LATIN SMALL LETTER R */
  0xFD, 0x2B, 0xF0,
  0xFD, 0xC5, 0x00,
  0xFF, 0x70, 0x00,
  0xFF, 0x30, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0073[ 60] = { /* code 0073, LATIN SMALL LETTER S */
  0x04, 0xBE, 0xFD, 0x92, 0x00,
  0x6F, 0xB2, 0x04, 0xEE, 0x20,
  0xDF, 0x10, 0x00, 0x5F, 0xA0,
  0xFF, 0x10, 0x00, 0x1F, 0xE0,
  0xBF, 0xA1, 0x00, 0x00, 0x00,
  0x1A, 0xFE, 0x94, 0x10, 0x00,
  0x00, 0x16, 0x9E, 0xF9, 0x10,
  0x00, 0x00, 0x01, 0xAF, 0xA0,
  0xEF, 0x10, 0x00, 0x1F, 0xF0,
  0xBF, 0x50, 0x00, 0x2F, 0xE0,
  0x2E, 0xE3, 0x02, 0xBF, 0x60,
  0x02, 0xAE, 0xFE, 0xB4, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0074[ 45] = { /* code 0074, LATIN SMALL LETTER T */
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x9F, 0xFF, 0xFF,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xFF, 0x00,
  0x00, 0xEF, 0x20,
  0x00, 0x7E, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0075[ 60] = { /* code 0075, LATIN SMALL LETTER U */
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x0F, 0xF0,
  0xFF, 0x00, 0x00, 0x2F, 0xF0,
  0xCF, 0x30, 0x00, 0x7F, 0xF0,
  0x7F, 0xB1, 0x05, 0xBF, 0xF0,
  0x07, 0xDF, 0xE8, 0x1F, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0076[ 60] = { /* code 0076, LATIN SMALL LETTER V */
  0xD8, 0x00, 0x00, 0x00, 0x7D,
  0x8D, 0x00, 0x00, 0x00, 0xC8,
  0x3F, 0x30, 0x00, 0x03, 0xF3,
  0x0D, 0x90, 0x00, 0x08, 0xD0,
  0x08, 0xE0, 0x00, 0x0D, 0x80,
  0x03, 0xF5, 0x00, 0x3F, 0x30,
  0x00, 0xDA, 0x00, 0x9D, 0x00,
  0x00, 0x8F, 0x10, 0xE8, 0x00,
  0x00, 0x3F, 0x64, 0xF3, 0x00,
  0x00, 0x0D, 0xBA, 0xD0, 0x00,
  0x00, 0x08, 0xFF, 0x80, 0x00,
  0x00, 0x03, 0xFF, 0x30, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0077[ 96] = { /* code 0077, LATIN SMALL LETTER W */
  0xDA, 0x00, 0x00, 0x2F, 0xF2, 0x00, 0x00, 0xAD,
  0x8E, 0x00, 0x00, 0x6F, 0xF6, 0x00, 0x00, 0xE8,
  0x3F, 0x40, 0x00, 0x9C, 0xD9, 0x00, 0x04, 0xF3,
  0x0D, 0x80, 0x00, 0xD7, 0x9D, 0x00, 0x08, 0xD0,
  0x08, 0xD0, 0x02, 0xF3, 0x4F, 0x20, 0x0D, 0x80,
  0x03, 0xF2, 0x06, 0xD0, 0x0E, 0x60, 0x2F, 0x30,
  0x00, 0xD7, 0x09, 0x90, 0x0A, 0x90, 0x7D, 0x00,
  0x00, 0x8B, 0x0D, 0x50, 0x06, 0xD0, 0xB8, 0x00,
  0x00, 0x3F, 0x3F, 0x10, 0x01, 0xF3, 0xF3, 0x00,
  0x00, 0x0D, 0xBB, 0x00, 0x00, 0xBB, 0xD0, 0x00,
  0x00, 0x08, 0xF7, 0x00, 0x00, 0x7F, 0x80, 0x00,
  0x00, 0x03, 0xF2, 0x00, 0x00, 0x2F, 0x30, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0078[ 60] = { /* code 0078, LATIN SMALL LETTER X */
  0xAF, 0x20, 0x00, 0x02, 0xEA,
  0x1D, 0xC0, 0x00, 0x0B, 0xD1,
  0x03, 0xF7, 0x00, 0x6F, 0x40,
  0x00, 0x8F, 0x32, 0xE8, 0x00,
  0x00, 0x0C, 0xDB, 0xC0, 0x00,
  0x00, 0x02, 0xFF, 0x30, 0x00,
  0x00, 0x04, 0xFF, 0x60, 0x00,
  0x00, 0x1D, 0xA8, 0xE2, 0x00,
  0x00, 0x9E, 0x10, 0xDB, 0x00,
  0x04, 0xF5, 0x00, 0x4F, 0x50,
  0x1E, 0xA0, 0x00, 0x09, 0xE1,
  0xAE, 0x10, 0x00, 0x01, 0xEA
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_0079[ 85] = { /* code 0079, LATIN SMALL LETTER Y */
  0xC8, 0x00, 0x00, 0x00, 0x8C,
  0x7D, 0x00, 0x00, 0x00, 0xD7,
  0x2F, 0x40, 0x00, 0x03, 0xF2,
  0x0B, 0xA0, 0x00, 0x09, 0xC0,
  0x06, 0xE0, 0x00, 0x0E, 0x70,
  0x01, 0xF5, 0x00, 0x4F, 0x20,
  0x00, 0xAB, 0x00, 0xAB, 0x00,
  0x00, 0x5F, 0x10, 0xE7, 0x00,
  0x00, 0x0E, 0x75, 0xF1, 0x00,
  0x00, 0x09, 0xCA, 0xB0, 0x00,
  0x00, 0x03, 0xFF, 0x60, 0x00,
  0x00, 0x00, 0xDF, 0x10, 0x00,
  0x00, 0x00, 0xBB, 0x00, 0x00,
  0x00, 0x01, 0xF5, 0x00, 0x00,
  0x00, 0x06, 0xF1, 0x00, 0x00,
  0x01, 0x2D, 0x80, 0x00, 0x00,
  0x0F, 0xE9, 0x10, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_007A[ 60] = { /* code 007A, LATIN SMALL LETTER Z */
  0x9F, 0xFF, 0xFF, 0xFF, 0xF9,
  0x00, 0x00, 0x00, 0x07, 0xF6,
  0x00, 0x00, 0x00, 0x4F, 0xA0,
  0x00, 0x00, 0x02, 0xEC, 0x10,
  0x00, 0x00, 0x1D, 0xE2, 0x00,
  0x00, 0x00, 0xBF, 0x40, 0x00,
  0x00, 0x07, 0xF7, 0x00, 0x00,
  0x00, 0x5F, 0xA0, 0x00, 0x00,
  0x03, 0xEC, 0x00, 0x00, 0x00,
  0x1D, 0xE2, 0x00, 0x00, 0x00,
  0xBF, 0x40, 0x00, 0x00, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_007B[ 84] = { /* code 007B, LEFT CURLY BRACKET */
  0x00, 0x01, 0xAE, 0xF0,
  0x00, 0x09, 0x91, 0x00,
  0x00, 0x0D, 0x20, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x3C, 0x00, 0x00,
  0x02, 0xB7, 0x00, 0x00,
  0xFF, 0x90, 0x00, 0x00,
  0x02, 0xB7, 0x00, 0x00,
  0x00, 0x3D, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0D, 0x10, 0x00,
  0x00, 0x09, 0x81, 0x00,
  0x00, 0x01, 0xAE, 0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_007C[ 23] = { /* code 007C, VERTICAL LINE */
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0,
  0xF0
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_007D[ 84] = { /* code 007D, RIGHT CURLY BRACKET */
  0xFE, 0xA1, 0x00, 0x00,
  0x01, 0x99, 0x00, 0x00,
  0x00, 0x2D, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0C, 0x30, 0x00,
  0x00, 0x07, 0xB2, 0x00,
  0x00, 0x00, 0x9F, 0xF0,
  0x00, 0x07, 0xB2, 0x00,
  0x00, 0x0C, 0x30, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x0F, 0x00, 0x00,
  0x00, 0x1D, 0x00, 0x00,
  0x01, 0x89, 0x00, 0x00,
  0xFE, 0xA1, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font27SL_AA4_007E[ 40] = { /* code 007E, TILDE */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x02, 0x9E, 0xFC, 0x71, 0x00, 0x00, 0x02, 0xC0,
  0x5E, 0x72, 0x03, 0x9D, 0x93, 0x01, 0x7D, 0x50,
  0xB2, 0x00, 0x00, 0x01, 0x7C, 0xFE, 0x92, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_Font27SL_AA4_CharInfo[95] = {
   {   1,   1,   0,  22,   6, acGUI_Font27SL_AA4_0020 } /* code 0020, SPACE */
  ,{   2,  17,   3,   5,   7, acGUI_Font27SL_AA4_0021 } /* code 0021, EXCLAMATION MARK */
  ,{   4,   6,   1,   6,   6, acGUI_Font27SL_AA4_0022 } /* code 0022, QUOTATION MARK */
  ,{  15,  16,   1,   6,  17, acGUI_Font27SL_AA4_0023 } /* code 0023, NUMBER SIGN */
  ,{  11,  19,   1,   5,  12, acGUI_Font27SL_AA4_0024 } /* code 0024, DOLLAR SIGN */
  ,{  17,  18,   1,   5,  18, acGUI_Font27SL_AA4_0025 } /* code 0025, PERCENT SIGN */
  ,{  14,  17,   1,   5,  15, acGUI_Font27SL_AA4_0026 } /* code 0026, AMPERSAND */
  ,{   1,   6,   1,   6,   3, acGUI_Font27SL_AA4_0027 } /* code 0027, APOSTROPHE */
  ,{   5,  21,   2,   5,   7, acGUI_Font27SL_AA4_0028 } /* code 0028, LEFT PARENTHESIS */
  ,{   5,  21,   0,   5,   7, acGUI_Font27SL_AA4_0029 } /* code 0029, RIGHT PARENTHESIS */
  ,{   9,   8,   2,   5,  11, acGUI_Font27SL_AA4_002A } /* code 002A, ASTERISK */
  ,{  13,  13,   3,   9,  19, acGUI_Font27SL_AA4_002B } /* code 002B, PLUS SIGN */
  ,{   2,   5,   2,  20,   6, acGUI_Font27SL_AA4_002C } /* code 002C, COMMA */
  ,{   6,   1,   1,  16,   7, acGUI_Font27SL_AA4_002D } /* code 002D, HYPHEN-MINUS */
  ,{   2,   2,   2,  20,   6, acGUI_Font27SL_AA4_002E } /* code 002E, FULL STOP */
  ,{   7,  19,   0,   5,   7, acGUI_Font27SL_AA4_002F } /* code 002F, SOLIDUS */
  ,{  11,  16,   1,   6,  12, acGUI_Font27SL_AA4_0030 } /* code 0030, DIGIT ZERO */
  ,{   6,  16,   2,   6,  12, acGUI_Font27SL_AA4_0031 } /* code 0031, DIGIT ONE */
  ,{  10,  16,   1,   6,  12, acGUI_Font27SL_AA4_0032 } /* code 0032, DIGIT TWO */
  ,{  10,  16,   1,   6,  12, acGUI_Font27SL_AA4_0033 } /* code 0033, DIGIT THREE */
  ,{  10,  16,   1,   6,  12, acGUI_Font27SL_AA4_0034 } /* code 0034, DIGIT FOUR */
  ,{  10,  16,   1,   6,  12, acGUI_Font27SL_AA4_0035 } /* code 0035, DIGIT FIVE */
  ,{  10,  16,   1,   6,  12, acGUI_Font27SL_AA4_0036 } /* code 0036, DIGIT SIX */
  ,{  10,  16,   1,   6,  12, acGUI_Font27SL_AA4_0037 } /* code 0037, DIGIT SEVEN */
  ,{  10,  16,   1,   6,  12, acGUI_Font27SL_AA4_0038 } /* code 0038, DIGIT EIGHT */
  ,{  10,  16,   1,   6,  12, acGUI_Font27SL_AA4_0039 } /* code 0039, DIGIT NINE */
  ,{   2,  12,   3,  10,   7, acGUI_Font27SL_AA4_003A } /* code 003A, COLON */
  ,{   2,  15,   3,  10,   7, acGUI_Font27SL_AA4_003B } /* code 003B, SEMICOLON */
  ,{  13,  12,   3,   9,  19, acGUI_Font27SL_AA4_003C } /* code 003C, LESS-THAN SIGN */
  ,{  13,   5,   3,  13,  19, acGUI_Font27SL_AA4_003D } /* code 003D, EQUALS SIGN */
  ,{  13,  12,   3,   9,  19, acGUI_Font27SL_AA4_003E } /* code 003E, GREATER-THAN SIGN */
  ,{  10,  17,   1,   5,  11, acGUI_Font27SL_AA4_003F } /* code 003F, QUESTION MARK */
  ,{  20,  19,   1,   6,  23, acGUI_Font27SL_AA4_0040 } /* code 0040, COMMERCIAL AT */
  ,{  14,  17,   0,   5,  14, acGUI_Font27SL_AA4_0041 } /* code 0041, LATIN CAPITAL LETTER A */
  ,{  12,  17,   2,   5,  14, acGUI_Font27SL_AA4_0042 } /* code 0042, LATIN CAPITAL LETTER B */
  ,{  14,  17,   1,   5,  16, acGUI_Font27SL_AA4_0043 } /* code 0043, LATIN CAPITAL LETTER C */
  ,{  13,  17,   2,   5,  16, acGUI_Font27SL_AA4_0044 } /* code 0044, LATIN CAPITAL LETTER D */
  ,{  11,  17,   2,   5,  14, acGUI_Font27SL_AA4_0045 } /* code 0045, LATIN CAPITAL LETTER E */
  ,{  10,  17,   2,   5,  13, acGUI_Font27SL_AA4_0046 } /* code 0046, LATIN CAPITAL LETTER F */
  ,{  15,  17,   1,   5,  17, acGUI_Font27SL_AA4_0047 } /* code 0047, LATIN CAPITAL LETTER G */
  ,{  13,  17,   2,   5,  16, acGUI_Font27SL_AA4_0048 } /* code 0048, LATIN CAPITAL LETTER H */
  ,{   2,  17,   2,   5,   5, acGUI_Font27SL_AA4_0049 } /* code 0049, LATIN CAPITAL LETTER I */
  ,{   9,  17,   1,   5,  11, acGUI_Font27SL_AA4_004A } /* code 004A, LATIN CAPITAL LETTER J */
  ,{  13,  17,   2,   5,  14, acGUI_Font27SL_AA4_004B } /* code 004B, LATIN CAPITAL LETTER K */
  ,{  10,  17,   2,   5,  12, acGUI_Font27SL_AA4_004C } /* code 004C, LATIN CAPITAL LETTER L */
  ,{  14,  17,   2,   5,  18, acGUI_Font27SL_AA4_004D } /* code 004D, LATIN CAPITAL LETTER M */
  ,{  13,  17,   2,   5,  16, acGUI_Font27SL_AA4_004E } /* code 004E, LATIN CAPITAL LETTER N */
  ,{  15,  17,   1,   5,  17, acGUI_Font27SL_AA4_004F } /* code 004F, LATIN CAPITAL LETTER O */
  ,{  11,  17,   2,   5,  14, acGUI_Font27SL_AA4_0050 } /* code 0050, LATIN CAPITAL LETTER P */
  ,{  15,  18,   1,   5,  17, acGUI_Font27SL_AA4_0051 } /* code 0051, LATIN CAPITAL LETTER Q */
  ,{  12,  17,   2,   5,  15, acGUI_Font27SL_AA4_0052 } /* code 0052, LATIN CAPITAL LETTER R */
  ,{  11,  17,   1,   5,  14, acGUI_Font27SL_AA4_0053 } /* code 0053, LATIN CAPITAL LETTER S */
  ,{  12,  17,   0,   5,  12, acGUI_Font27SL_AA4_0054 } /* code 0054, LATIN CAPITAL LETTER T */
  ,{  13,  17,   2,   5,  16, acGUI_Font27SL_AA4_0055 } /* code 0055, LATIN CAPITAL LETTER U */
  ,{  12,  17,   0,   5,  13, acGUI_Font27SL_AA4_0056 } /* code 0056, LATIN CAPITAL LETTER V */
  ,{  19,  17,   0,   5,  19, acGUI_Font27SL_AA4_0057 } /* code 0057, LATIN CAPITAL LETTER W */
  ,{  13,  17,   0,   5,  13, acGUI_Font27SL_AA4_0058 } /* code 0058, LATIN CAPITAL LETTER X */
  ,{  12,  17,   0,   5,  13, acGUI_Font27SL_AA4_0059 } /* code 0059, LATIN CAPITAL LETTER Y */
  ,{  12,  17,   1,   5,  13, acGUI_Font27SL_AA4_005A } /* code 005A, LATIN CAPITAL LETTER Z */
  ,{   4,  21,   3,   5,   7, acGUI_Font27SL_AA4_005B } /* code 005B, LEFT SQUARE BRACKET */
  ,{   7,  19,   0,   5,   7, acGUI_Font27SL_AA4_005C } /* code 005C, REVERSE SOLIDUS */
  ,{   4,  21,   1,   5,   7, acGUI_Font27SL_AA4_005D } /* code 005D, RIGHT SQUARE BRACKET */
  ,{  13,   6,   5,   6,  23, acGUI_Font27SL_AA4_005E } /* code 005E, CIRCUMFLEX ACCENT */
  ,{  12,   1,   0,  26,  11, acGUI_Font27SL_AA4_005F } /* code 005F, LOW LINE */
  ,{   4,   4,   3,   5,  11, acGUI_Font27SL_AA4_0060 } /* code 0060, GRAVE ACCENT */
  ,{  11,  12,   1,  10,  12, acGUI_Font27SL_AA4_0061 } /* code 0061, LATIN SMALL LETTER A */
  ,{  11,  17,   2,   5,  13, acGUI_Font27SL_AA4_0062 } /* code 0062, LATIN SMALL LETTER B */
  ,{  10,  12,   1,  10,  12, acGUI_Font27SL_AA4_0063 } /* code 0063, LATIN SMALL LETTER C */
  ,{  11,  17,   1,   5,  13, acGUI_Font27SL_AA4_0064 } /* code 0064, LATIN SMALL LETTER D */
  ,{  10,  12,   1,  10,  12, acGUI_Font27SL_AA4_0065 } /* code 0065, LATIN SMALL LETTER E */
  ,{   6,  17,   0,   5,   6, acGUI_Font27SL_AA4_0066 } /* code 0066, LATIN SMALL LETTER F */
  ,{  11,  17,   1,  10,  13, acGUI_Font27SL_AA4_0067 } /* code 0067, LATIN SMALL LETTER G */
  ,{   9,  17,   2,   5,  12, acGUI_Font27SL_AA4_0068 } /* code 0068, LATIN SMALL LETTER H */
  ,{   2,  17,   2,   5,   5, acGUI_Font27SL_AA4_0069 } /* code 0069, LATIN SMALL LETTER I */
  ,{   4,  22,   0,   5,   5, acGUI_Font27SL_AA4_006A } /* code 006A, LATIN SMALL LETTER J */
  ,{  10,  17,   2,   5,  11, acGUI_Font27SL_AA4_006B } /* code 006B, LATIN SMALL LETTER K */
  ,{   2,  17,   2,   5,   5, acGUI_Font27SL_AA4_006C } /* code 006C, LATIN SMALL LETTER L */
  ,{  16,  12,   2,  10,  19, acGUI_Font27SL_AA4_006D } /* code 006D, LATIN SMALL LETTER M */
  ,{   9,  12,   2,  10,  12, acGUI_Font27SL_AA4_006E } /* code 006E, LATIN SMALL LETTER N */
  ,{  11,  12,   1,  10,  13, acGUI_Font27SL_AA4_006F } /* code 006F, LATIN SMALL LETTER O */
  ,{  11,  17,   2,  10,  13, acGUI_Font27SL_AA4_0070 } /* code 0070, LATIN SMALL LETTER P */
  ,{  11,  17,   1,  10,  13, acGUI_Font27SL_AA4_0071 } /* code 0071, LATIN SMALL LETTER Q */
  ,{   5,  12,   2,  10,   7, acGUI_Font27SL_AA4_0072 } /* code 0072, LATIN SMALL LETTER R */
  ,{   9,  12,   1,  10,  11, acGUI_Font27SL_AA4_0073 } /* code 0073, LATIN SMALL LETTER S */
  ,{   6,  15,   0,   7,   6, acGUI_Font27SL_AA4_0074 } /* code 0074, LATIN SMALL LETTER T */
  ,{   9,  12,   2,  10,  12, acGUI_Font27SL_AA4_0075 } /* code 0075, LATIN SMALL LETTER U */
  ,{  10,  12,   0,  10,  10, acGUI_Font27SL_AA4_0076 } /* code 0076, LATIN SMALL LETTER V */
  ,{  16,  12,   0,  10,  16, acGUI_Font27SL_AA4_0077 } /* code 0077, LATIN SMALL LETTER W */
  ,{  10,  12,   0,  10,  10, acGUI_Font27SL_AA4_0078 } /* code 0078, LATIN SMALL LETTER X */
  ,{  10,  17,   0,  10,  10, acGUI_Font27SL_AA4_0079 } /* code 0079, LATIN SMALL LETTER Y */
  ,{  10,  12,   0,  10,  10, acGUI_Font27SL_AA4_007A } /* code 007A, LATIN SMALL LETTER Z */
  ,{   7,  21,   2,   5,  11, acGUI_Font27SL_AA4_007B } /* code 007B, LEFT CURLY BRACKET */
  ,{   1,  23,   5,   4,  11, acGUI_Font27SL_AA4_007C } /* code 007C, VERTICAL LINE */
  ,{   7,  21,   2,   5,  11, acGUI_Font27SL_AA4_007D } /* code 007D, RIGHT CURLY BRACKET */
  ,{  15,   5,   2,  12,  19, acGUI_Font27SL_AA4_007E } /* code 007E, TILDE */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font27SL_AA4_Prop1 = {
   0x0020 /* first character */
  ,0x007E /* last character  */
  ,&GUI_Font27SL_AA4_CharInfo[  0] /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT GUI_Font27SL_AA4 = {
   GUI_FONTTYPE_PROP_AA4_EXT /* type of font    */
  ,27 /* height of font  */
  ,27 /* space of font y */
  ,1 /* magnification x */
  ,1 /* magnification y */
  ,{&GUI_Font27SL_AA4_Prop1}
  ,22 /* Baseline */
  ,12 /* Height of lowercase characters */
  ,17 /* Height of capital characters */
};

