/*********************************************************************
*                SEGGER Microcontroller GmbH                         *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2018  SEGGER Microcontroller GmbH                *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.48 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software  has been licensed to  Cypress Semiconductor Corporation,
whose registered  office is situated  at 198 Champion Ct. San Jose, CA 
95134 USA  solely for the  purposes of creating  libraries for Cypress
PSoC3 and  PSoC5 processor-based devices,  sublicensed and distributed
under  the  terms  and  conditions  of  the  Cypress  End User License
Agreement.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information
Licensor:                 SEGGER Microcontroller Systems LLC
Licensed to:              Cypress Semiconductor Corp, 198 Champion Ct., San Jose, CA 95134, USA
Licensed SEGGER software: emWin
License number:           GUI-00319
License model:            Services and License Agreement, signed June 10th, 2009
Licensed platform:        Any Cypress platform (Initial targets are: PSoC3, PSoC5)
----------------------------------------------------------------------
Support and Update Agreement (SUA)
SUA period:               2009-06-12 - 2022-07-27
Contact to extend SUA:    sales@segger.com
----------------------------------------------------------------------
File        : FONT_Chinese.c
Purpose     : Shows how to draw text in thai language
Requirements: WindowManager - ( )
              MemoryDevices - ( )
              AntiAliasing  - ( )
              VNC-Server    - ( )
              PNG-Library   - ( )
              TrueTypeFonts - ( )
----------------------------------------------------------------------
*/

#include "GUI.h"

/*******************************************************************
*
*       Static data
*
********************************************************************
*/
/* The following line needs to be included in any file selecting the
   font.
*/
extern GUI_CONST_STORAGE GUI_FONT GUI_FontChinese_24;

/* Start of unicode area <Basic Latin> */
GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_0020[  1] = { /* code 0020, SPACE */
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_0027[ 14] = { /* code 0027, APOSTROPHE */
  0x02, 0x20,
  0x3F, 0xF3,
  0x2F, 0xF9,
  0x02, 0xE7,
  0x00, 0xE2,
  0x09, 0x60,
  0x54, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_002E[  6] = { /* code 002E, FULL STOP */
  0x1B, 0xB1,
  0x6F, 0xF6,
  0x1B, 0xB1
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_003F[100] = { /* code 003F, QUESTION MARK */
  0x00, 0x16, 0x99, 0x72, 0x00,
  0x04, 0xB5, 0x44, 0x8E, 0x60,
  0x3B, 0x00, 0x00, 0x06, 0xF3,
  0xA6, 0x00, 0x00, 0x01, 0xF9,
  0xBE, 0x30, 0x00, 0x00, 0xDB,
  0x8F, 0x70, 0x00, 0x00, 0xFB,
  0x03, 0x10, 0x00, 0x04, 0xF7,
  0x00, 0x00, 0x00, 0x1C, 0xD1,
  0x00, 0x00, 0x00, 0xBB, 0x10,
  0x00, 0x00, 0x0A, 0x70, 0x00,
  0x00, 0x00, 0x49, 0x00, 0x00,
  0x00, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x00, 0x74, 0x00, 0x00,
  0x00, 0x00, 0x63, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x03, 0xED, 0x10, 0x00,
  0x00, 0x05, 0xFF, 0x30, 0x00,
  0x00, 0x01, 0x87, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_0042[102] = { /* code 0042, LATIN CAPITAL LETTER B */
  0x36, 0x66, 0x66, 0x64, 0x00, 0x00,
  0x5C, 0xFC, 0x99, 0xAD, 0xE5, 0x00,
  0x07, 0xF7, 0x00, 0x00, 0x9F, 0x10,
  0x07, 0xF7, 0x00, 0x00, 0x4F, 0x50,
  0x07, 0xF7, 0x00, 0x00, 0x4F, 0x60,
  0x07, 0xF7, 0x00, 0x00, 0x5F, 0x30,
  0x07, 0xF7, 0x00, 0x01, 0xCA, 0x00,
  0x07, 0xF9, 0x44, 0x6C, 0x60, 0x00,
  0x07, 0xFD, 0xBB, 0xBE, 0xA2, 0x00,
  0x07, 0xF7, 0x00, 0x00, 0x7E, 0x20,
  0x07, 0xF7, 0x00, 0x00, 0x0D, 0xB0,
  0x07, 0xF7, 0x00, 0x00, 0x0A, 0xF1,
  0x07, 0xF7, 0x00, 0x00, 0x09, 0xF2,
  0x07, 0xF7, 0x00, 0x00, 0x0B, 0xF1,
  0x07, 0xF7, 0x00, 0x00, 0x2F, 0xA0,
  0x08, 0xF8, 0x00, 0x04, 0xDC, 0x10,
  0x9F, 0xFF, 0xFF, 0xFE, 0x91, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_0043[102] = { /* code 0043, LATIN CAPITAL LETTER C */
  0x00, 0x00, 0x03, 0x65, 0x10, 0x10,
  0x00, 0x03, 0xC7, 0x45, 0xCF, 0x70,
  0x00, 0x3E, 0x30, 0x00, 0x1C, 0xB0,
  0x01, 0xD7, 0x00, 0x00, 0x02, 0xE0,
  0x07, 0xF1, 0x00, 0x00, 0x00, 0x91,
  0x0D, 0xB0, 0x00, 0x00, 0x00, 0x00,
  0x1F, 0x80, 0x00, 0x00, 0x00, 0x00,
  0x3F, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x4F, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x4F, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x2F, 0x80, 0x00, 0x00, 0x00, 0x00,
  0x0F, 0xA0, 0x00, 0x00, 0x00, 0x00,
  0x0B, 0xD0, 0x00, 0x00, 0x00, 0x90,
  0x05, 0xF3, 0x00, 0x00, 0x01, 0x90,
  0x00, 0xBB, 0x00, 0x00, 0x09, 0x20,
  0x00, 0x1D, 0xA3, 0x24, 0xB3, 0x00,
  0x00, 0x01, 0xAF, 0xFC, 0x40, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_0044[102] = { /* code 0044, LATIN CAPITAL LETTER D */
  0x36, 0x66, 0x65, 0x20, 0x00, 0x00,
  0x5C, 0xFA, 0x23, 0x8B, 0x30, 0x00,
  0x07, 0xF7, 0x00, 0x03, 0xE5, 0x00,
  0x07, 0xF7, 0x00, 0x00, 0x7E, 0x20,
  0x07, 0xF7, 0x00, 0x00, 0x1F, 0x80,
  0x07, 0xF7, 0x00, 0x00, 0x0D, 0xD0,
  0x07, 0xF7, 0x00, 0x00, 0x0B, 0xF1,
  0x07, 0xF7, 0x00, 0x00, 0x09, 0xF2,
  0x07, 0xF7, 0x00, 0x00, 0x09, 0xF2,
  0x07, 0xF7, 0x00, 0x00, 0x09, 0xF2,
  0x07, 0xF7, 0x00, 0x00, 0x0B, 0xF0,
  0x07, 0xF7, 0x00, 0x00, 0x0D, 0xC0,
  0x07, 0xF7, 0x00, 0x00, 0x1F, 0x80,
  0x07, 0xF7, 0x00, 0x00, 0x7F, 0x20,
  0x07, 0xF7, 0x00, 0x02, 0xE7, 0x00,
  0x08, 0xF8, 0x01, 0x7E, 0x80, 0x00,
  0x7F, 0xFF, 0xFF, 0xB4, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_0047[102] = { /* code 0047, LATIN CAPITAL LETTER G */
  0x00, 0x00, 0x15, 0x52, 0x01, 0x00,
  0x00, 0x06, 0xC5, 0x4A, 0xE8, 0x00,
  0x00, 0x5D, 0x10, 0x00, 0x9B, 0x00,
  0x01, 0xE5, 0x00, 0x00, 0x1D, 0x00,
  0x08, 0xE0, 0x00, 0x00, 0x09, 0x10,
  0x0D, 0xA0, 0x00, 0x00, 0x00, 0x00,
  0x2F, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x4F, 0x60, 0x00, 0x00, 0x00, 0x00,
  0x6F, 0x60, 0x00, 0x00, 0x00, 0x00,
  0x5F, 0x60, 0x00, 0x19, 0x99, 0x95,
  0x3F, 0x60, 0x00, 0x16, 0xFF, 0x73,
  0x1F, 0x80, 0x00, 0x00, 0xFF, 0x00,
  0x0C, 0xB0, 0x00, 0x00, 0xFF, 0x00,
  0x06, 0xF2, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0xB9, 0x00, 0x00, 0xFF, 0x00,
  0x00, 0x1D, 0x71, 0x18, 0xD8, 0x00,
  0x00, 0x01, 0xAF, 0xFA, 0x10, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_0049[ 68] = { /* code 0049, LATIN CAPITAL LETTER I */
  0x46, 0x66, 0x66, 0x64,
  0x79, 0xBF, 0xE9, 0x97,
  0x00, 0x4F, 0xB0, 0x00,
  0x00, 0x4F, 0xB0, 0x00,
  0x00, 0x4F, 0xB0, 0x00,
  0x00, 0x4F, 0xB0, 0x00,
  0x00, 0x4F, 0xB0, 0x00,
  0x00, 0x4F, 0xB0, 0x00,
  0x00, 0x4F, 0xB0, 0x00,
  0x00, 0x4F, 0xB0, 0x00,
  0x00, 0x4F, 0xB0, 0x00,
  0x00, 0x4F, 0xB0, 0x00,
  0x00, 0x4F, 0xB0, 0x00,
  0x00, 0x4F, 0xB0, 0x00,
  0x00, 0x4F, 0xB0, 0x00,
  0x00, 0x4F, 0xC0, 0x00,
  0xBF, 0xFF, 0xFF, 0xFB
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_0054[102] = { /* code 0054, LATIN CAPITAL LETTER T */
  0x03, 0x66, 0x66, 0x66, 0x66, 0x30,
  0x0B, 0xE6, 0x8F, 0xD4, 0x6E, 0x90,
  0x0E, 0x30, 0x6F, 0x90, 0x04, 0xC0,
  0x38, 0x00, 0x6F, 0x90, 0x00, 0x90,
  0x11, 0x00, 0x6F, 0x90, 0x00, 0x10,
  0x00, 0x00, 0x6F, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x6F, 0xB0, 0x00, 0x00,
  0x00, 0x07, 0xFF, 0xFF, 0x60, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_0061[ 66] = { /* code 0061, LATIN SMALL LETTER A */
  0x02, 0x8A, 0x99, 0x95, 0x00, 0x00,
  0x2E, 0x60, 0x00, 0x1C, 0x40, 0x00,
  0x6F, 0x30, 0x00, 0x06, 0x80, 0x00,
  0x15, 0x00, 0x00, 0x07, 0x90, 0x00,
  0x00, 0x03, 0x7B, 0xAA, 0x90, 0x00,
  0x03, 0xCA, 0x40, 0x06, 0x90, 0x00,
  0x4F, 0x70, 0x00, 0x06, 0x90, 0x00,
  0xDB, 0x00, 0x00, 0x06, 0x90, 0x00,
  0xEB, 0x00, 0x00, 0x07, 0x92, 0x00,
  0x6F, 0x71, 0x15, 0x9D, 0xA8, 0x00,
  0x06, 0xDF, 0xE8, 0x15, 0xF5, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_0065[ 55] = { /* code 0065, LATIN SMALL LETTER E */
  0x00, 0x18, 0x99, 0xA4, 0x00,
  0x02, 0xD5, 0x00, 0x1C, 0x70,
  0x0D, 0x70, 0x00, 0x04, 0xF2,
  0x4F, 0x20, 0x00, 0x01, 0xF6,
  0x7F, 0x44, 0x44, 0x44, 0xF8,
  0x7F, 0xBB, 0xBB, 0xBB, 0xB7,
  0x6F, 0x00, 0x00, 0x00, 0x00,
  0x3F, 0x30, 0x00, 0x00, 0x32,
  0x0C, 0xA0, 0x00, 0x01, 0xA0,
  0x02, 0xEA, 0x32, 0x5B, 0x20,
  0x00, 0x2B, 0xFF, 0xB2, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_0066[102] = { /* code 0066, LATIN SMALL LETTER F */
  0x00, 0x00, 0x02, 0x56, 0x40, 0x00,
  0x00, 0x00, 0xAB, 0x44, 0xAC, 0x10,
  0x00, 0x04, 0xC0, 0x00, 0x6F, 0x50,
  0x00, 0x07, 0x80, 0x00, 0x14, 0x00,
  0x00, 0x07, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x07, 0x70, 0x00, 0x00, 0x00,
  0xAD, 0xDE, 0xED, 0xDD, 0x70, 0x00,
  0x12, 0x28, 0x82, 0x22, 0x10, 0x00,
  0x00, 0x07, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x07, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x07, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x07, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x07, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x07, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x07, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x08, 0x90, 0x00, 0x00, 0x00,
  0x4F, 0xFF, 0xFF, 0xF9, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_0068[108] = { /* code 0068, LATIN SMALL LETTER H */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x26, 0xA6, 0x00, 0x00, 0x00, 0x00,
  0x39, 0xD6, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x96, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x96, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x96, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x96, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x96, 0x18, 0xBC, 0x81, 0x00,
  0x00, 0x97, 0xA3, 0x01, 0xB9, 0x00,
  0x00, 0x9C, 0x10, 0x00, 0x3D, 0x00,
  0x00, 0x96, 0x00, 0x00, 0x0E, 0x00,
  0x00, 0x96, 0x00, 0x00, 0x0F, 0x00,
  0x00, 0x96, 0x00, 0x00, 0x0F, 0x00,
  0x00, 0x96, 0x00, 0x00, 0x0F, 0x00,
  0x00, 0x96, 0x00, 0x00, 0x0F, 0x00,
  0x00, 0x96, 0x00, 0x00, 0x0F, 0x00,
  0x00, 0xB7, 0x00, 0x00, 0x2F, 0x10,
  0x4F, 0xFF, 0xB0, 0x0B, 0xFF, 0xF4
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_0069[ 68] = { /* code 0069, LATIN SMALL LETTER I */
  0x00, 0x05, 0x70, 0x00,
  0x00, 0x1F, 0xF3, 0x00,
  0x00, 0x07, 0xA0, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,
  0x00, 0x02, 0x40, 0x00,
  0x7D, 0xEF, 0x90, 0x00,
  0x12, 0x28, 0x90, 0x00,
  0x00, 0x06, 0x90, 0x00,
  0x00, 0x06, 0x90, 0x00,
  0x00, 0x06, 0x90, 0x00,
  0x00, 0x06, 0x90, 0x00,
  0x00, 0x06, 0x90, 0x00,
  0x00, 0x06, 0x90, 0x00,
  0x00, 0x06, 0x90, 0x00,
  0x00, 0x07, 0xB0, 0x00,
  0x7F, 0xFF, 0xFF, 0xF7
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_006B[108] = { /* code 006B, LATIN SMALL LETTER K */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x16, 0x97, 0x00, 0x00, 0x00, 0x00,
  0x19, 0xD7, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x77, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x77, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x77, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x77, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x77, 0x00, 0x7D, 0xDD, 0x70,
  0x00, 0x77, 0x00, 0x1B, 0x72, 0x10,
  0x00, 0x77, 0x00, 0x77, 0x00, 0x00,
  0x00, 0x77, 0x07, 0x90, 0x00, 0x00,
  0x00, 0x77, 0x5F, 0xA0, 0x00, 0x00,
  0x00, 0x7C, 0xA3, 0xF5, 0x00, 0x00,
  0x00, 0x7B, 0x00, 0x9E, 0x10, 0x00,
  0x00, 0x77, 0x00, 0x1D, 0x90, 0x00,
  0x00, 0x77, 0x00, 0x05, 0xF4, 0x00,
  0x00, 0x98, 0x00, 0x00, 0xCD, 0x10,
  0x2F, 0xFF, 0xB0, 0x0B, 0xFF, 0xF4
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_006C[ 72] = { /* code 006C, LATIN SMALL LETTER L */
  0x00, 0x00, 0x10, 0x00,
  0x36, 0x7B, 0x90, 0x00,
  0x69, 0x9C, 0x90, 0x00,
  0x00, 0x06, 0x90, 0x00,
  0x00, 0x06, 0x90, 0x00,
  0x00, 0x06, 0x90, 0x00,
  0x00, 0x06, 0x90, 0x00,
  0x00, 0x06, 0x90, 0x00,
  0x00, 0x06, 0x90, 0x00,
  0x00, 0x06, 0x90, 0x00,
  0x00, 0x06, 0x90, 0x00,
  0x00, 0x06, 0x90, 0x00,
  0x00, 0x06, 0x90, 0x00,
  0x00, 0x06, 0x90, 0x00,
  0x00, 0x06, 0x90, 0x00,
  0x00, 0x06, 0x90, 0x00,
  0x00, 0x07, 0xB0, 0x00,
  0x9F, 0xFF, 0xFF, 0xF9
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_006D[ 72] = { /* code 006D, LATIN SMALL LETTER M */
  0x00, 0x20, 0x00, 0x00, 0x00, 0x00,
  0x8F, 0x76, 0xCB, 0x14, 0xCC, 0x20,
  0x18, 0xC7, 0x39, 0xCA, 0x37, 0xC0,
  0x07, 0x90, 0x02, 0xE0, 0x00, 0xF0,
  0x07, 0x70, 0x02, 0xD0, 0x00, 0xF0,
  0x07, 0x70, 0x02, 0xD0, 0x00, 0xF0,
  0x07, 0x70, 0x02, 0xD0, 0x00, 0xF0,
  0x07, 0x70, 0x02, 0xD0, 0x00, 0xF0,
  0x07, 0x70, 0x02, 0xD0, 0x00, 0xF0,
  0x07, 0x70, 0x02, 0xD0, 0x00, 0xF0,
  0x08, 0x80, 0x03, 0xE0, 0x01, 0xF1,
  0xBF, 0xF7, 0x6F, 0xFB, 0x4F, 0xFD
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_006E[ 72] = { /* code 006E, LATIN SMALL LETTER N */
  0x00, 0x12, 0x00, 0x00, 0x00, 0x00,
  0x2D, 0xF6, 0x29, 0xBC, 0x80, 0x00,
  0x02, 0xA9, 0xA1, 0x01, 0xA8, 0x00,
  0x00, 0x9B, 0x00, 0x00, 0x2D, 0x00,
  0x00, 0x96, 0x00, 0x00, 0x0E, 0x00,
  0x00, 0x96, 0x00, 0x00, 0x0F, 0x00,
  0x00, 0x96, 0x00, 0x00, 0x0F, 0x00,
  0x00, 0x96, 0x00, 0x00, 0x0F, 0x00,
  0x00, 0x96, 0x00, 0x00, 0x0F, 0x00,
  0x00, 0x96, 0x00, 0x00, 0x0F, 0x00,
  0x00, 0xB7, 0x00, 0x00, 0x2F, 0x10,
  0x4F, 0xFF, 0xB0, 0x0B, 0xFF, 0xF4
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_006F[ 55] = { /* code 006F, LATIN SMALL LETTER O */
  0x00, 0x3A, 0xAA, 0x92, 0x00,
  0x05, 0xC3, 0x00, 0x4E, 0x30,
  0x2F, 0x20, 0x00, 0x05, 0xD1,
  0xAB, 0x00, 0x00, 0x00, 0xE6,
  0xE9, 0x00, 0x00, 0x00, 0xBB,
  0xF7, 0x00, 0x00, 0x00, 0xBB,
  0xD9, 0x00, 0x00, 0x00, 0xCA,
  0x8C, 0x00, 0x00, 0x00, 0xE6,
  0x1D, 0x30, 0x00, 0x06, 0xC0,
  0x03, 0xD4, 0x00, 0x5D, 0x20,
  0x00, 0x3B, 0xFF, 0xB2, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_0072[ 72] = { /* code 0072, LATIN SMALL LETTER R */
  0x00, 0x02, 0x50, 0x00, 0x00, 0x00,
  0x2D, 0xEF, 0xB0, 0x18, 0xCC, 0x50,
  0x02, 0x26, 0xB1, 0xA3, 0x0C, 0xE0,
  0x00, 0x04, 0xBA, 0x20, 0x03, 0x40,
  0x00, 0x04, 0xF7, 0x00, 0x00, 0x00,
  0x00, 0x04, 0xE0, 0x00, 0x00, 0x00,
  0x00, 0x04, 0xB0, 0x00, 0x00, 0x00,
  0x00, 0x04, 0xB0, 0x00, 0x00, 0x00,
  0x00, 0x04, 0xB0, 0x00, 0x00, 0x00,
  0x00, 0x04, 0xB0, 0x00, 0x00, 0x00,
  0x00, 0x05, 0xC0, 0x00, 0x00, 0x00,
  0x6F, 0xFF, 0xFF, 0xF9, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_0073[ 60] = { /* code 0073, LATIN SMALL LETTER S */
  0x00, 0x3A, 0x99, 0x97, 0x80,
  0x04, 0xD2, 0x00, 0x09, 0xE0,
  0x0B, 0x90, 0x00, 0x00, 0xC0,
  0x0A, 0xD2, 0x00, 0x00, 0x20,
  0x02, 0xBF, 0x93, 0x00, 0x00,
  0x00, 0x02, 0x8E, 0xD7, 0x10,
  0x00, 0x00, 0x00, 0x6D, 0xD0,
  0x27, 0x00, 0x00, 0x01, 0xF3,
  0x0E, 0x10, 0x00, 0x01, 0xF1,
  0x0F, 0xC3, 0x00, 0x1A, 0x80,
  0x0A, 0x37, 0xEF, 0xD7, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_0074[ 75] = { /* code 0074, LATIN SMALL LETTER T */
  0x00, 0x00, 0x50, 0x00, 0x00,
  0x00, 0x01, 0x90, 0x00, 0x00,
  0x00, 0x04, 0x90, 0x00, 0x00,
  0x00, 0x3D, 0x90, 0x00, 0x00,
  0x7E, 0xFF, 0xED, 0xDD, 0x50,
  0x12, 0x27, 0xA2, 0x22, 0x10,
  0x00, 0x06, 0x90, 0x00, 0x00,
  0x00, 0x06, 0x90, 0x00, 0x00,
  0x00, 0x06, 0x90, 0x00, 0x00,
  0x00, 0x06, 0x90, 0x00, 0x00,
  0x00, 0x06, 0x90, 0x00, 0x00,
  0x00, 0x06, 0x90, 0x00, 0x31,
  0x00, 0x05, 0xA0, 0x00, 0x90,
  0x00, 0x03, 0xE5, 0x48, 0x60,
  0x00, 0x00, 0x8F, 0xE7, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_0075[ 72] = { /* code 0075, LATIN SMALL LETTER U */
  0x00, 0x32, 0x00, 0x00, 0x05, 0x00,
  0x5E, 0xF4, 0x00, 0x0A, 0xED, 0x00,
  0x12, 0xC4, 0x00, 0x01, 0x4D, 0x00,
  0x00, 0xB4, 0x00, 0x00, 0x2D, 0x00,
  0x00, 0xB4, 0x00, 0x00, 0x2D, 0x00,
  0x00, 0xB4, 0x00, 0x00, 0x2D, 0x00,
  0x00, 0xB4, 0x00, 0x00, 0x2D, 0x00,
  0x00, 0xB4, 0x00, 0x00, 0x2D, 0x00,
  0x00, 0xB4, 0x00, 0x00, 0x3D, 0x00,
  0x00, 0x96, 0x00, 0x01, 0xCD, 0x00,
  0x00, 0x5E, 0x76, 0x7D, 0x6F, 0x82,
  0x00, 0x08, 0xFF, 0xC4, 0x2B, 0x72
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_0077[ 66] = { /* code 0077, LATIN SMALL LETTER W */
  0x8B, 0xB6, 0x8B, 0xB6, 0x3B, 0xBA,
  0x3E, 0xA2, 0x3D, 0xC2, 0x17, 0xB3,
  0x08, 0xB0, 0x08, 0xD0, 0x07, 0x40,
  0x04, 0xF0, 0x0B, 0xF1, 0x0B, 0x10,
  0x01, 0xF3, 0x0A, 0xE4, 0x0B, 0x00,
  0x00, 0xC7, 0x37, 0xA8, 0x37, 0x00,
  0x00, 0x8B, 0x73, 0x7B, 0x74, 0x00,
  0x00, 0x4E, 0xB0, 0x3E, 0xA0, 0x00,
  0x00, 0x1F, 0xB0, 0x0E, 0xB0, 0x00,
  0x00, 0x0C, 0x70, 0x0B, 0x70, 0x00,
  0x00, 0x07, 0x30, 0x06, 0x30, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_0079[ 84] = { /* code 0079, LATIN SMALL LETTER Y */
  0xDD, 0xDD, 0x00, 0xAD, 0xDD, 0x20,
  0x29, 0xF2, 0x00, 0x1A, 0x92, 0x00,
  0x02, 0xF4, 0x00, 0x0C, 0x10, 0x00,
  0x00, 0xB9, 0x00, 0x2A, 0x00, 0x00,
  0x00, 0x5E, 0x00, 0x75, 0x00, 0x00,
  0x00, 0x0E, 0x50, 0xB0, 0x00, 0x00,
  0x00, 0x08, 0xA2, 0xA0, 0x00, 0x00,
  0x00, 0x02, 0xF8, 0x50, 0x00, 0x00,
  0x00, 0x00, 0xCE, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x69, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x74, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xB0, 0x00, 0x00, 0x00,
  0x08, 0x95, 0x80, 0x00, 0x00, 0x00,
  0x0A, 0xFB, 0x10, 0x00, 0x00, 0x00
};

/* Start of unicode area <CJK Symbols and Punctuation> */
GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_3002[ 28] = { /* code 3002, IDEOGRAPHIC FULL STOP */
  0x00, 0x47, 0x72, 0x00,
  0x07, 0x72, 0x3A, 0x30,
  0x1A, 0x00, 0x01, 0xA0,
  0x27, 0x00, 0x00, 0xB0,
  0x0B, 0x00, 0x01, 0x90,
  0x06, 0x94, 0x5B, 0x20,
  0x00, 0x36, 0x51, 0x00
};

/* Start of unicode area <CJK Unified Ideographs> */
GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_4E2D[230] = { /* code 4E2D */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x6D, 0x30, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x22, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x32, 0x00,
  0x4E, 0xBB, 0xBB, 0xBB, 0xDE, 0xBB, 0xBB, 0xBB, 0xEE, 0x40,
  0x4C, 0x44, 0x44, 0x44, 0x8B, 0x44, 0x44, 0x44, 0x8B, 0x00,
  0x4B, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x69, 0x00,
  0x4B, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x69, 0x00,
  0x4B, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x69, 0x00,
  0x4B, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x69, 0x00,
  0x4B, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x69, 0x00,
  0x4D, 0x66, 0x66, 0x66, 0x9B, 0x66, 0x66, 0x66, 0x99, 0x00,
  0x4E, 0x99, 0x99, 0x99, 0xBD, 0x99, 0x99, 0x99, 0xB9, 0x00,
  0x26, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x33, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_4E86[200] = { /* code 4E86 */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0x20,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE2,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xD7, 0x62,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0xC7, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x22, 0x97, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0B, 0xF9, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0B, 0xF4, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0B, 0xF4, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0B, 0xF4, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0B, 0xF4, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0B, 0xF4, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0B, 0xF4, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0B, 0xF4, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0B, 0xF4, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0B, 0xF4, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0B, 0xF4, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x0B, 0xF4, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x34, 0x4D, 0xF4, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x36, 0xCF, 0xE2, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x4A, 0x30, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_4F5C[276] = { /* code 4F5C */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0xB3, 0x00, 0x08, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0E, 0x91, 0x00, 0x0D, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0x30, 0x00, 0x4F, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
  0x00, 0x00, 0x8C, 0x00, 0x00, 0xB9, 0x00, 0x00, 0x00, 0x08, 0xF6, 0x00,
  0x00, 0x00, 0xD6, 0x00, 0x03, 0xFE, 0xDD, 0xDD, 0xDD, 0xDF, 0xFF, 0x40,
  0x00, 0x05, 0xF2, 0x00, 0x0B, 0xB2, 0x7A, 0x22, 0x22, 0x22, 0x22, 0x00,
  0x00, 0x0B, 0xF4, 0x00, 0x4E, 0x20, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x4F, 0xF0, 0x00, 0xC4, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0xC7, 0xF0, 0x08, 0x70, 0x00, 0x69, 0x00, 0x00, 0x5E, 0x40, 0x00,
  0x06, 0xA0, 0xF0, 0x47, 0x00, 0x00, 0x6F, 0xFF, 0xFF, 0xFF, 0xF1, 0x00,
  0x2B, 0x00, 0xF0, 0x30, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x41, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x30, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x6A, 0x22, 0x22, 0x28, 0xF8, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x6E, 0xDD, 0xDD, 0xDD, 0xDD, 0x10,
  0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_4F60[276] = { /* code 4F60 */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xB8, 0x10, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0xF8, 0x00, 0x9F, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x05, 0xF1, 0x00, 0xD8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x09, 0xB0, 0x03, 0xF2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0E, 0x50, 0x08, 0xB0, 0x00, 0x00, 0x00, 0x00, 0x53, 0x00,
  0x00, 0x00, 0x5E, 0x00, 0x0D, 0xDB, 0xBB, 0xBB, 0xBB, 0xBB, 0xFF, 0x60,
  0x00, 0x00, 0xBF, 0x60, 0x5D, 0x44, 0x44, 0xE5, 0x44, 0x45, 0xE5, 0x20,
  0x00, 0x02, 0xFA, 0x00, 0xC4, 0x00, 0x00, 0xD2, 0x00, 0x09, 0x50, 0x00,
  0x00, 0x08, 0xF9, 0x05, 0x60, 0x00, 0x00, 0xD2, 0x00, 0x28, 0x00, 0x00,
  0x00, 0x2E, 0x99, 0x06, 0x00, 0x73, 0x00, 0xD2, 0x11, 0x20, 0x00, 0x00,
  0x00, 0xA7, 0x69, 0x00, 0x00, 0xFB, 0x20, 0xD2, 0x09, 0x20, 0x00, 0x00,
  0x04, 0xA0, 0x69, 0x00, 0x03, 0xF2, 0x00, 0xD2, 0x02, 0xD2, 0x00, 0x00,
  0x19, 0x10, 0x69, 0x00, 0x07, 0xC0, 0x00, 0xD2, 0x00, 0x6C, 0x10, 0x00,
  0x00, 0x00, 0x69, 0x00, 0x0B, 0x50, 0x00, 0xD2, 0x00, 0x0D, 0x80, 0x00,
  0x00, 0x00, 0x69, 0x00, 0x2D, 0x00, 0x00, 0xD2, 0x00, 0x07, 0xF1, 0x00,
  0x00, 0x00, 0x69, 0x00, 0x85, 0x00, 0x00, 0xD2, 0x00, 0x02, 0xF6, 0x00,
  0x00, 0x00, 0x69, 0x02, 0xB0, 0x00, 0x00, 0xD2, 0x00, 0x00, 0xD9, 0x00,
  0x00, 0x00, 0x69, 0x09, 0x10, 0x00, 0x00, 0xD2, 0x00, 0x00, 0xB9, 0x00,
  0x00, 0x00, 0x69, 0x12, 0x00, 0x00, 0x00, 0xD2, 0x00, 0x00, 0x22, 0x00,
  0x00, 0x00, 0x69, 0x00, 0x00, 0x05, 0x9A, 0xF1, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x1E, 0x80, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_4F7F[276] = { /* code 4F7F */
  0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x20, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0C, 0xC4, 0x00, 0x00, 0x07, 0xC2, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1F, 0x70, 0x00, 0x00, 0x07, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x4F, 0x10, 0x00, 0x00, 0x07, 0x70, 0x00, 0x00, 0x54, 0x00,
  0x00, 0x00, 0x8A, 0x03, 0x44, 0x44, 0x49, 0x94, 0x44, 0x46, 0xFF, 0x70,
  0x00, 0x00, 0xD4, 0x08, 0xBB, 0xBB, 0xBD, 0xDB, 0xBB, 0xBB, 0xBB, 0xA0,
  0x00, 0x03, 0xD0, 0x00, 0x00, 0x00, 0x07, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0A, 0xFA, 0x00, 0x50, 0x00, 0x07, 0x70, 0x00, 0x05, 0x00, 0x00,
  0x00, 0x1F, 0xF2, 0x00, 0xBE, 0xDD, 0xDE, 0xED, 0xDD, 0xEF, 0x80, 0x00,
  0x00, 0x9B, 0xD2, 0x00, 0xB5, 0x22, 0x28, 0x82, 0x22, 0x2D, 0x20, 0x00,
  0x02, 0xD1, 0xD2, 0x00, 0xB4, 0x00, 0x07, 0x70, 0x00, 0x0D, 0x20, 0x00,
  0x0A, 0x30, 0xD2, 0x00, 0xB4, 0x00, 0x07, 0x70, 0x00, 0x0D, 0x20, 0x00,
  0x43, 0x00, 0xD2, 0x00, 0xBC, 0xBB, 0xBD, 0xDB, 0xBB, 0xBF, 0x20, 0x00,
  0x00, 0x00, 0xD2, 0x00, 0xB6, 0x44, 0x4A, 0x84, 0x44, 0x4D, 0x10, 0x00,
  0x00, 0x00, 0xD2, 0x00, 0x31, 0x60, 0x0A, 0x40, 0x00, 0x01, 0x00, 0x00,
  0x00, 0x00, 0xD2, 0x00, 0x00, 0x92, 0x1D, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xD2, 0x00, 0x00, 0x2B, 0xA7, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xD2, 0x00, 0x00, 0x08, 0xF7, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xD2, 0x00, 0x00, 0x4D, 0x4B, 0xD6, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xD2, 0x00, 0x07, 0xC2, 0x00, 0x5D, 0xFB, 0x75, 0x20, 0x00,
  0x00, 0x00, 0xD2, 0x05, 0xB6, 0x00, 0x00, 0x00, 0x4A, 0xFF, 0xFF, 0x60,
  0x00, 0x00, 0xA2, 0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x85, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_55CE[242] = { /* code 55CE */
  0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x03, 0x90, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x7B, 0x99, 0x99, 0x99, 0x9E, 0xFB, 0x00,
  0x82, 0x22, 0x78, 0x00, 0x7A, 0x66, 0x6B, 0x96, 0x66, 0x65, 0x00,
  0xDD, 0xDD, 0xEE, 0x40, 0x77, 0x00, 0x09, 0x60, 0x04, 0x00, 0x00,
  0xD2, 0x00, 0x4B, 0x00, 0x79, 0x44, 0x4B, 0x84, 0x7F, 0xB1, 0x00,
  0xD2, 0x00, 0x4B, 0x00, 0x7D, 0xBB, 0xBE, 0xDB, 0xBB, 0xB3, 0x00,
  0xD2, 0x00, 0x4B, 0x00, 0x77, 0x00, 0x09, 0x60, 0x01, 0x00, 0x00,
  0xD2, 0x00, 0x4B, 0x00, 0x77, 0x00, 0x09, 0x60, 0x5E, 0x60, 0x00,
  0xD2, 0x00, 0x4B, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0x00,
  0xD2, 0x00, 0x4B, 0x00, 0x77, 0x00, 0x09, 0x60, 0x00, 0x00, 0x00,
  0xD2, 0x00, 0x4B, 0x00, 0x77, 0x00, 0x09, 0x60, 0x00, 0x01, 0x00,
  0xD2, 0x00, 0x4B, 0x00, 0x7B, 0x77, 0x7C, 0xA7, 0x77, 0xAD, 0x30,
  0xDD, 0xDD, 0xEB, 0x00, 0x7B, 0x77, 0x77, 0x77, 0x77, 0x7F, 0x20,
  0xD3, 0x22, 0x5B, 0x00, 0x42, 0x00, 0x00, 0x03, 0x00, 0x0F, 0x00,
  0xD2, 0x00, 0x35, 0x00, 0x00, 0x00, 0x34, 0x06, 0xA0, 0x0F, 0x00,
  0xC1, 0x00, 0x00, 0x03, 0x40, 0x92, 0x0B, 0x40, 0xD5, 0x1F, 0x00,
  0x00, 0x00, 0x00, 0x06, 0x60, 0x79, 0x06, 0xC0, 0x64, 0x4D, 0x00,
  0x00, 0x00, 0x00, 0x0C, 0x60, 0x6D, 0x02, 0xB0, 0x00, 0xAB, 0x00,
  0x00, 0x00, 0x00, 0x7F, 0x40, 0x5A, 0x00, 0x11, 0x03, 0xF6, 0x00,
  0x00, 0x00, 0x00, 0xBA, 0x00, 0x00, 0x00, 0x28, 0xDF, 0xD0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4B, 0x20, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_56FD[242] = { /* code 56FD */
  0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, 0x00,
  0x2F, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xFE, 0x20,
  0x2D, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0xA6, 0x00,
  0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22, 0x00, 0x96, 0x00,
  0x2D, 0x02, 0x77, 0x77, 0x77, 0x77, 0x77, 0xEE, 0x40, 0x96, 0x00,
  0x2D, 0x02, 0x77, 0x77, 0x7E, 0x87, 0x77, 0x77, 0x30, 0x96, 0x00,
  0x2D, 0x00, 0x00, 0x00, 0x0D, 0x20, 0x00, 0x00, 0x00, 0x96, 0x00,
  0x2D, 0x00, 0x00, 0x00, 0x0D, 0x20, 0x00, 0x00, 0x00, 0x96, 0x00,
  0x2D, 0x00, 0x00, 0x00, 0x0D, 0x20, 0x01, 0x30, 0x00, 0x96, 0x00,
  0x2D, 0x00, 0x39, 0x99, 0x9E, 0xA9, 0x9D, 0xF5, 0x00, 0x96, 0x00,
  0x2D, 0x00, 0x26, 0x66, 0x6E, 0x76, 0x66, 0x63, 0x00, 0x96, 0x00,
  0x2D, 0x00, 0x00, 0x00, 0x0D, 0x25, 0x40, 0x00, 0x00, 0x96, 0x00,
  0x2D, 0x00, 0x00, 0x00, 0x0D, 0x20, 0xBB, 0x00, 0x00, 0x96, 0x00,
  0x2D, 0x00, 0x00, 0x00, 0x0D, 0x20, 0x1E, 0x40, 0x00, 0x96, 0x00,
  0x2D, 0x00, 0x00, 0x00, 0x0D, 0x20, 0x02, 0x16, 0x40, 0x96, 0x00,
  0x2D, 0x05, 0x99, 0x99, 0x9E, 0xA9, 0x99, 0xAF, 0xF6, 0x96, 0x00,
  0x2D, 0x03, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x63, 0x96, 0x00,
  0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0x00,
  0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x96, 0x00,
  0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF6, 0x00,
  0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x93, 0x00,
  0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_5DE5[198] = { /* code 5DE5 */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
  0x12, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x7F, 0x80, 0x00,
  0x5D, 0xDD, 0xDD, 0xDD, 0xEF, 0xED, 0xDD, 0xDD, 0xDD, 0xD1, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x6F, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x6F, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x6F, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x6F, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x6F, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x6F, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x6F, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x6F, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x6F, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x6F, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x6F, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x6F, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x6F, 0x90, 0x00, 0x00, 0x00, 0x12, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x6F, 0x90, 0x00, 0x00, 0x01, 0xDE, 0x50,
  0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_5FB7[253] = { /* code 5FB7 */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x29, 0x10, 0x00, 0x00, 0x06, 0xD0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xAD, 0x50, 0x00, 0x00, 0x06, 0x90, 0x00, 0x01, 0x00,
  0x00, 0x05, 0xE2, 0x01, 0x66, 0x66, 0x69, 0xB6, 0x66, 0x8E, 0x30,
  0x00, 0x2E, 0x30, 0x02, 0x99, 0x99, 0x9B, 0xD9, 0x99, 0x99, 0x70,
  0x01, 0xC3, 0x01, 0x00, 0x00, 0x00, 0x06, 0x90, 0x00, 0x10, 0x00,
  0x1A, 0x20, 0x08, 0xC2, 0x2D, 0x99, 0x9B, 0xD9, 0x99, 0xEB, 0x10,
  0x30, 0x00, 0x1F, 0x82, 0x2E, 0x66, 0xE7, 0x6D, 0x86, 0xA9, 0x00,
  0x00, 0x00, 0x9D, 0x00, 0x2D, 0x00, 0xD2, 0x0B, 0x40, 0x77, 0x00,
  0x00, 0x04, 0xF3, 0x00, 0x2D, 0x00, 0xD2, 0x0B, 0x40, 0x77, 0x00,
  0x00, 0x1D, 0xF3, 0x00, 0x2F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0x00,
  0x00, 0xBD, 0xB0, 0x00, 0x15, 0x00, 0x00, 0x00, 0x00, 0x31, 0x00,
  0x08, 0x94, 0xB0, 0x01, 0x44, 0x44, 0x44, 0x44, 0x44, 0x7E, 0x50,
  0x55, 0x04, 0xB0, 0x03, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xA0,
  0x00, 0x04, 0xB0, 0x00, 0x00, 0x00, 0x06, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x04, 0xB0, 0x00, 0x00, 0x01, 0x02, 0xC2, 0x00, 0x00, 0x00,
  0x00, 0x04, 0xB0, 0x00, 0x02, 0x0B, 0x80, 0x5D, 0x01, 0x82, 0x00,
  0x00, 0x04, 0xB0, 0x00, 0x27, 0x0B, 0x40, 0x0C, 0x10, 0x1C, 0x60,
  0x00, 0x04, 0xB0, 0x00, 0x76, 0x0B, 0x40, 0x00, 0x04, 0x03, 0xF4,
  0x00, 0x04, 0xB0, 0x04, 0xF4, 0x0B, 0x40, 0x00, 0x17, 0x00, 0xA8,
  0x00, 0x04, 0xB0, 0x0B, 0xC0, 0x0B, 0x74, 0x44, 0x8A, 0x00, 0x00,
  0x00, 0x03, 0x90, 0x01, 0x00, 0x07, 0xBB, 0xBB, 0xB9, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_6211[264] = { /* code 6211 */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x10, 0x02, 0xF7, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x03, 0x9F, 0xD3, 0x02, 0xD0, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x01, 0x48, 0xDF, 0xA7, 0x62, 0x02, 0xD0, 0x6A, 0x50, 0x00, 0x00,
  0x03, 0x89, 0x75, 0x3F, 0x00, 0x00, 0x02, 0xD0, 0x03, 0xE9, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x02, 0xD0, 0x00, 0x5C, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x02, 0xD0, 0x00, 0x00, 0x20, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x02, 0xD0, 0x00, 0x05, 0xF9, 0x00,
  0x2D, 0xDD, 0xDD, 0xDF, 0xDD, 0xDD, 0xDD, 0xFD, 0xDD, 0xDF, 0xFF, 0x80,
  0x02, 0x22, 0x22, 0x2F, 0x22, 0x22, 0x22, 0xF2, 0x22, 0x22, 0x22, 0x10,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0xD2, 0x00, 0x3B, 0x20, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x02, 0x30, 0xB5, 0x00, 0xAD, 0x70, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x59, 0xA7, 0x10, 0x88, 0x03, 0xF3, 0x00, 0x00,
  0x00, 0x01, 0x47, 0xBF, 0x83, 0x00, 0x00, 0x5C, 0x0C, 0x90, 0x00, 0x00,
  0x08, 0xCF, 0xFA, 0x5F, 0x00, 0x00, 0x00, 0x1F, 0xAD, 0x10, 0x00, 0x00,
  0x07, 0xE6, 0x10, 0x0F, 0x00, 0x00, 0x00, 0x0B, 0xF3, 0x00, 0x00, 0x00,
  0x00, 0x60, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x3E, 0xF3, 0x00, 0x00, 0x50,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x03, 0xE7, 0xBD, 0x10, 0x05, 0x40,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x4E, 0x50, 0x1D, 0xD2, 0x0C, 0x00,
  0x00, 0x00, 0x00, 0x0F, 0x00, 0x07, 0xB2, 0x00, 0x02, 0xDF, 0xCD, 0x00,
  0x00, 0x00, 0x7B, 0xCE, 0x02, 0xA6, 0x00, 0x00, 0x00, 0x19, 0xFF, 0x20,
  0x00, 0x00, 0x01, 0xE6, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_65BC[264] = { /* code 65BC */
  0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD7, 0x00, 0x00, 0x00, 0x0B, 0xD3, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD2, 0x00, 0x00, 0x00, 0x0D, 0xD0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD2, 0x00, 0x00, 0x00, 0x1F, 0x94, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xD2, 0x00, 0x15, 0x00, 0x4E, 0x1A, 0x00, 0x00, 0x00,
  0x01, 0x66, 0x66, 0xE7, 0x66, 0xBF, 0x90, 0x89, 0x0A, 0x30, 0x00, 0x00,
  0x02, 0x99, 0x9D, 0xB9, 0x99, 0x99, 0x90, 0xD3, 0x04, 0xB0, 0x00, 0x00,
  0x00, 0x00, 0x09, 0x60, 0x00, 0x00, 0x03, 0xC0, 0x00, 0xC7, 0x00, 0x00,
  0x00, 0x00, 0x09, 0x60, 0x00, 0x00, 0x0A, 0x40, 0x00, 0x3F, 0x40, 0x00,
  0x00, 0x00, 0x09, 0x72, 0x27, 0x50, 0x3A, 0x00, 0x00, 0x08, 0xF5, 0x00,
  0x00, 0x00, 0x09, 0xED, 0xDE, 0xE2, 0xA2, 0x30, 0x00, 0x00, 0xBF, 0x60,
  0x00, 0x00, 0x0B, 0x60, 0x04, 0xB6, 0x20, 0x4A, 0x81, 0x00, 0x16, 0x00,
  0x00, 0x00, 0x0D, 0x40, 0x04, 0xA1, 0x00, 0x00, 0x8E, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0x20, 0x06, 0x90, 0x00, 0x00, 0x08, 0x90, 0x00, 0x00,
  0x00, 0x00, 0x4D, 0x00, 0x06, 0x90, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x88, 0x00, 0x08, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xD2, 0x00, 0x0A, 0x70, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x05, 0x90, 0x00, 0x0E, 0x40, 0x05, 0xBA, 0x50, 0x00, 0x00, 0x00,
  0x00, 0x1B, 0x10, 0x00, 0x5F, 0x10, 0x00, 0x04, 0xEC, 0x30, 0x00, 0x00,
  0x00, 0x83, 0x25, 0x44, 0xD9, 0x00, 0x00, 0x00, 0x1C, 0xF4, 0x00, 0x00,
  0x07, 0x30, 0x02, 0x7F, 0xD1, 0x00, 0x00, 0x00, 0x01, 0xCB, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_6613[253] = { /* code 6613 */
  0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x69, 0x66, 0x66, 0x66, 0x66, 0xCB, 0x20, 0x00,
  0x00, 0x00, 0x00, 0x6D, 0x99, 0x99, 0x99, 0x99, 0xBC, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x6E, 0xBB, 0xBB, 0xBB, 0xBB, 0xD9, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x6B, 0x44, 0x44, 0x44, 0x44, 0x89, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x69, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x6E, 0xDD, 0xDD, 0xDD, 0xDD, 0xE9, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x57, 0x2D, 0xA2, 0x22, 0x22, 0x54, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x9B, 0x10, 0x00, 0x00, 0x00, 0x02, 0x10,
  0x00, 0x00, 0x00, 0x08, 0xFA, 0x99, 0x99, 0x99, 0x99, 0x9D, 0xD3,
  0x00, 0x00, 0x01, 0xBC, 0x66, 0xAF, 0x76, 0x9F, 0x76, 0x6D, 0xB2,
  0x00, 0x00, 0x6D, 0x70, 0x03, 0xE7, 0x00, 0xBC, 0x00, 0x0C, 0x70,
  0x01, 0x6B, 0x71, 0x00, 0x3E, 0x80, 0x04, 0xF4, 0x00, 0x0E, 0x50,
  0x04, 0x20, 0x00, 0x05, 0xE6, 0x00, 0x2E, 0x90, 0x00, 0x1F, 0x20,
  0x00, 0x00, 0x01, 0xAC, 0x30, 0x01, 0xDB, 0x00, 0x00, 0x5E, 0x00,
  0x00, 0x02, 0x8B, 0x50, 0x00, 0x3D, 0xB1, 0x00, 0x00, 0xA9, 0x00,
  0x02, 0x77, 0x30, 0x00, 0x07, 0xE7, 0x03, 0x52, 0x05, 0xF3, 0x00,
  0x00, 0x00, 0x00, 0x06, 0xC9, 0x20, 0x00, 0x3B, 0xFF, 0x90, 0x00,
  0x00, 0x00, 0x48, 0xA6, 0x10, 0x00, 0x00, 0x03, 0xB6, 0x00, 0x00,
  0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_662F[276] = { /* code 662F */
  0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x09, 0x86, 0x66, 0x66, 0x66, 0x6D, 0x60, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x09, 0xB9, 0x99, 0x99, 0x99, 0x9C, 0xA0, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x09, 0x60, 0x00, 0x00, 0x00, 0x07, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x09, 0x84, 0x44, 0x44, 0x44, 0x49, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x09, 0xDB, 0xBB, 0xBB, 0xBB, 0xBD, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x09, 0x60, 0x00, 0x00, 0x00, 0x07, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x09, 0x60, 0x00, 0x00, 0x00, 0x07, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x09, 0xED, 0xDD, 0xDD, 0xDD, 0xDE, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x09, 0x72, 0x22, 0x22, 0x22, 0x28, 0x40, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1D, 0xB1, 0x00,
  0x7D, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xEF, 0xFB, 0x00,
  0x12, 0x22, 0x27, 0x52, 0x22, 0x5C, 0x22, 0x22, 0x22, 0x22, 0x21, 0x00,
  0x00, 0x00, 0x0C, 0xE4, 0x00, 0x4B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0E, 0x70, 0x00, 0x4B, 0x00, 0x00, 0x39, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x3F, 0x30, 0x00, 0x4E, 0x99, 0x99, 0xEF, 0xB0, 0x00, 0x00,
  0x00, 0x00, 0x9E, 0x30, 0x00, 0x4D, 0x66, 0x66, 0x66, 0x50, 0x00, 0x00,
  0x00, 0x01, 0xF5, 0xA4, 0x00, 0x4B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x09, 0xA0, 0x1A, 0x80, 0x4B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x4D, 0x10, 0x00, 0x7D, 0xBB, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x03, 0xB1, 0x00, 0x00, 0x01, 0x8D, 0xDB, 0x99, 0x99, 0x99, 0x94, 0x00,
  0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x66, 0x66, 0x66, 0x50, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_6765[276] = { /* code 6765 */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x7D, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00,
  0x01, 0x44, 0x44, 0x44, 0x44, 0x99, 0x44, 0x44, 0x44, 0xBF, 0x80, 0x00,
  0x03, 0xBB, 0xBB, 0xBB, 0xBB, 0xDD, 0xBB, 0xBB, 0xBB, 0xBB, 0xB0, 0x00,
  0x00, 0x02, 0x60, 0x00, 0x00, 0x77, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x78, 0x00, 0x00, 0x77, 0x00, 0x05, 0xFC, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0D, 0x70, 0x00, 0x77, 0x00, 0x0C, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x08, 0xF1, 0x00, 0x77, 0x00, 0x4B, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x05, 0xF2, 0x00, 0x77, 0x00, 0xA1, 0x00, 0x01, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x50, 0x00, 0x77, 0x00, 0x30, 0x00, 0x1B, 0xD3, 0x00,
  0x0D, 0xDD, 0xDD, 0xDD, 0xDD, 0xEE, 0xDD, 0xDD, 0xDD, 0xEF, 0xFE, 0x00,
  0x02, 0x22, 0x22, 0x22, 0x4F, 0xE9, 0x72, 0x22, 0x22, 0x22, 0x22, 0x00,
  0x00, 0x00, 0x00, 0x01, 0xCA, 0x77, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0B, 0xB0, 0x77, 0x08, 0x70, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xAB, 0x10, 0x77, 0x00, 0xAA, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x0A, 0xA0, 0x00, 0x77, 0x00, 0x0A, 0xE6, 0x00, 0x00, 0x00,
  0x00, 0x01, 0xB7, 0x00, 0x00, 0x77, 0x00, 0x00, 0x9F, 0xD6, 0x10, 0x00,
  0x00, 0x3B, 0x30, 0x00, 0x00, 0x77, 0x00, 0x00, 0x06, 0xEF, 0xE4, 0x00,
  0x18, 0x70, 0x00, 0x00, 0x00, 0x77, 0x00, 0x00, 0x00, 0x2B, 0x70, 0x00,
  0x41, 0x00, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_7528[231] = { /* code 7528 */
  0x00, 0x00, 0x09, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x29, 0x30,
  0x00, 0x00, 0x0F, 0xDD, 0xDD, 0xDD, 0xFD, 0xDD, 0xDD, 0xDE, 0xC0,
  0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x07, 0x70,
  0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x07, 0x70,
  0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x07, 0x70,
  0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x07, 0x70,
  0x00, 0x00, 0x0F, 0xBB, 0xBB, 0xBB, 0xFB, 0xBB, 0xBB, 0xBD, 0x70,
  0x00, 0x00, 0x0F, 0x44, 0x44, 0x44, 0xF4, 0x44, 0x44, 0x49, 0x70,
  0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x07, 0x70,
  0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x07, 0x70,
  0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x07, 0x70,
  0x00, 0x00, 0x0F, 0x66, 0x66, 0x66, 0xF6, 0x66, 0x66, 0x6A, 0x70,
  0x00, 0x00, 0x1F, 0x99, 0x99, 0x99, 0xF9, 0x99, 0x99, 0x9C, 0x70,
  0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x07, 0x70,
  0x00, 0x00, 0x7A, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x07, 0x70,
  0x00, 0x00, 0xB5, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x07, 0x70,
  0x00, 0x03, 0xD0, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x07, 0x70,
  0x00, 0x0B, 0x50, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x08, 0x70,
  0x00, 0x49, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x01, 0x77, 0x7D, 0x60,
  0x02, 0xA0, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x14, 0xFE, 0x20,
  0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x51, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_7684[253] = { /* code 7684 */
  0x00, 0x02, 0x51, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x05, 0xFB, 0x00, 0x00, 0x00, 0xBF, 0x70, 0x00, 0x00, 0x00,
  0x00, 0x08, 0xB0, 0x00, 0x00, 0x00, 0xF9, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0B, 0x50, 0x00, 0x00, 0x04, 0xF3, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x0C, 0x00, 0x00, 0x00, 0x08, 0xC0, 0x00, 0x00, 0x00, 0x00,
  0x75, 0x4B, 0x44, 0x6B, 0x10, 0x0D, 0x84, 0x44, 0x44, 0x89, 0x00,
  0x9D, 0xBB, 0xBB, 0xBF, 0x40, 0x3F, 0xBB, 0xBB, 0xBB, 0xCE, 0x30,
  0x96, 0x00, 0x00, 0x0F, 0x00, 0xA8, 0x00, 0x00, 0x00, 0x2D, 0x00,
  0x96, 0x00, 0x00, 0x0F, 0x01, 0xD1, 0x00, 0x00, 0x00, 0x2D, 0x00,
  0x96, 0x00, 0x00, 0x0F, 0x09, 0x40, 0x00, 0x00, 0x00, 0x2D, 0x00,
  0x96, 0x00, 0x00, 0x0F, 0x37, 0x07, 0x30, 0x00, 0x00, 0x2D, 0x00,
  0x9E, 0xDD, 0xDD, 0xDF, 0x10, 0x01, 0xD6, 0x00, 0x00, 0x2D, 0x00,
  0x97, 0x22, 0x22, 0x2F, 0x00, 0x00, 0x4F, 0x40, 0x00, 0x2D, 0x00,
  0x96, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x0C, 0x90, 0x00, 0x2D, 0x00,
  0x96, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x03, 0x30, 0x00, 0x2D, 0x00,
  0x96, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00,
  0x96, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5B, 0x00,
  0x9E, 0xDD, 0xDD, 0xDF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0x00,
  0x97, 0x22, 0x22, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x02, 0xF4, 0x00,
  0x96, 0x00, 0x00, 0x07, 0x00, 0x00, 0x15, 0x43, 0x5D, 0xD0, 0x00,
  0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x7F, 0xFD, 0x20, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x70, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_7F8E[276] = { /* code 7F8E */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x30, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x77, 0x00, 0x00, 0x05, 0xFA, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x0A, 0xB1, 0x00, 0x0A, 0x90, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0xF6, 0x00, 0x1D, 0x10, 0x00, 0x03, 0x00, 0x00,
  0x00, 0x24, 0x44, 0x44, 0xD8, 0x44, 0x77, 0x44, 0x44, 0x9F, 0x80, 0x00,
  0x00, 0x7B, 0xBB, 0xBB, 0xBB, 0xCF, 0xBB, 0xBB, 0xBB, 0xBB, 0xB1, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x01, 0x22, 0x22, 0x22, 0x3D, 0x22, 0x22, 0x28, 0xC2, 0x00, 0x00,
  0x00, 0x07, 0xDD, 0xDD, 0xDD, 0xDF, 0xDD, 0xDD, 0xDD, 0xD8, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x82, 0x00,
  0x04, 0x77, 0x77, 0x77, 0x77, 0x8E, 0x77, 0x77, 0x77, 0x7B, 0xFE, 0x30,
  0x04, 0x77, 0x77, 0x77, 0x77, 0x8E, 0x77, 0x77, 0x77, 0x77, 0x77, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x2D, 0x00, 0x00, 0x00, 0x01, 0x10, 0x00,
  0x00, 0x12, 0x22, 0x22, 0x22, 0x4C, 0x22, 0x22, 0x22, 0x2B, 0xC2, 0x00,
  0x00, 0x7D, 0xDD, 0xDD, 0xDD, 0xEF, 0xED, 0xDD, 0xDD, 0xDD, 0xD9, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0xA7, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x05, 0xD0, 0x2B, 0x20, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x7D, 0x20, 0x03, 0xD7, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x1A, 0xC2, 0x00, 0x00, 0x2C, 0xE9, 0x52, 0x00, 0x00,
  0x00, 0x00, 0x39, 0xC6, 0x00, 0x00, 0x00, 0x00, 0x6C, 0xFF, 0xEA, 0x10,
  0x06, 0x9A, 0x83, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x91, 0x00,
  0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_81EA[184] = { /* code 81EA */
  0x00, 0x00, 0x02, 0x71, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x05, 0xF8, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x07, 0xA0, 0x00, 0x00, 0x00, 0x00,
  0x21, 0x00, 0x0A, 0x30, 0x00, 0x00, 0x30, 0x00,
  0x6C, 0x99, 0x9D, 0x99, 0x99, 0x9B, 0xF7, 0x00,
  0x6B, 0x66, 0x66, 0x66, 0x66, 0x66, 0xD4, 0x00,
  0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB4, 0x00,
  0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB4, 0x00,
  0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB4, 0x00,
  0x6E, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xE4, 0x00,
  0x6B, 0x44, 0x44, 0x44, 0x44, 0x44, 0xC4, 0x00,
  0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB4, 0x00,
  0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB4, 0x00,
  0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB4, 0x00,
  0x6E, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xF4, 0x00,
  0x6A, 0x22, 0x22, 0x22, 0x22, 0x22, 0xC4, 0x00,
  0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB4, 0x00,
  0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB4, 0x00,
  0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB4, 0x00,
  0x6E, 0xBB, 0xBB, 0xBB, 0xBB, 0xBB, 0xE4, 0x00,
  0x6B, 0x44, 0x44, 0x44, 0x44, 0x44, 0xB2, 0x00,
  0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_9019[252] = { /* code 9019 */
  0x00, 0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50, 0x00, 0x00, 0x00,
  0x00, 0x0A, 0xC1, 0x00, 0x57, 0x77, 0x77, 0x7A, 0xFC, 0x00, 0x00, 0x00,
  0x00, 0x01, 0xD3, 0x00, 0x57, 0x77, 0x77, 0x77, 0x77, 0x01, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1B, 0xD3, 0x00,
  0x00, 0x00, 0x05, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xDD, 0xEF, 0xFF, 0x00,
  0x07, 0x30, 0x01, 0x22, 0x22, 0x22, 0x22, 0x22, 0x25, 0x22, 0x21, 0x00,
  0x01, 0xD9, 0x00, 0x00, 0x36, 0x66, 0x66, 0x66, 0x7F, 0xB0, 0x00, 0x00,
  0x00, 0x4F, 0x30, 0x00, 0x69, 0x99, 0x99, 0x99, 0x99, 0x91, 0x00, 0x00,
  0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x7B, 0xBB, 0xBB, 0xBB, 0xCF, 0xF2, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x24, 0x44, 0x44, 0x44, 0x44, 0x40, 0x00, 0x00,
  0x46, 0x66, 0xB7, 0x00, 0x09, 0x32, 0x22, 0x22, 0x2A, 0x20, 0x00, 0x00,
  0x79, 0x99, 0xCC, 0x10, 0x0D, 0xDD, 0xDD, 0xDD, 0xDE, 0xA0, 0x00, 0x00,
  0x00, 0x00, 0x77, 0x00, 0x0D, 0x20, 0x00, 0x00, 0x09, 0x60, 0x00, 0x00,
  0x00, 0x00, 0x77, 0x00, 0x0D, 0x20, 0x00, 0x00, 0x09, 0x60, 0x00, 0x00,
  0x00, 0x00, 0x77, 0x00, 0x0D, 0x20, 0x00, 0x00, 0x09, 0x60, 0x00, 0x00,
  0x00, 0x00, 0x77, 0x00, 0x0D, 0xDD, 0xDD, 0xDD, 0xDE, 0x60, 0x00, 0x00,
  0x00, 0x02, 0xA9, 0x00, 0x0D, 0x32, 0x22, 0x22, 0x27, 0x20, 0x00, 0x00,
  0x03, 0xAB, 0x14, 0xB7, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1E, 0xA0, 0x00, 0x05, 0xAD, 0xED, 0xDD, 0xDD, 0xDD, 0xDD, 0x90, 0x00,
  0x01, 0x20, 0x00, 0x00, 0x00, 0x01, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_9E97[276] = { /* code 9E97 */
  0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xAD, 0x30, 0x00, 0x00, 0x00, 0x01, 0xDB, 0x10,
  0x0B, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80,
  0x00, 0x30, 0x00, 0x00, 0x40, 0x00, 0x01, 0x00, 0x00, 0x03, 0x10, 0x00,
  0x00, 0xBC, 0xBB, 0xBB, 0xFC, 0x00, 0x07, 0xDB, 0xBB, 0xBE, 0xE2, 0x00,
  0x00, 0xB7, 0x85, 0x44, 0x98, 0x00, 0x07, 0x98, 0x64, 0x47, 0xB0, 0x00,
  0x00, 0xB4, 0x1D, 0x30, 0x77, 0x00, 0x07, 0x71, 0xC3, 0x04, 0xB0, 0x00,
  0x00, 0xB4, 0x08, 0xB0, 0x77, 0x0A, 0x47, 0x70, 0x6B, 0x04, 0xB0, 0x00,
  0x00, 0xB3, 0x01, 0x30, 0x76, 0x0F, 0x17, 0x60, 0x04, 0x03, 0x81, 0x00,
  0x00, 0x27, 0x44, 0x44, 0x54, 0x4F, 0x44, 0x44, 0x44, 0x44, 0xEE, 0x30,
  0x00, 0x0F, 0xBB, 0xBB, 0xDD, 0xBB, 0xBE, 0xDB, 0xBB, 0xBB, 0xBB, 0x70,
  0x00, 0x0F, 0x00, 0x00, 0x77, 0x00, 0x09, 0x60, 0x00, 0x32, 0x00, 0x00,
  0x00, 0x0F, 0xBB, 0xBB, 0xDD, 0xBB, 0xBE, 0xDB, 0xBB, 0xEE, 0x30, 0x00,
  0x00, 0x0F, 0x44, 0x44, 0x99, 0x44, 0x4B, 0x84, 0x44, 0x7B, 0x00, 0x00,
  0x00, 0x0F, 0x77, 0x77, 0xBB, 0x77, 0x7C, 0xA7, 0x77, 0x9B, 0x00, 0x00,
  0x00, 0x0E, 0x77, 0x7F, 0x77, 0x77, 0x7C, 0xA7, 0x77, 0x99, 0x10, 0x00,
  0x00, 0x1C, 0x00, 0x0F, 0x00, 0x78, 0x09, 0x60, 0x00, 0x5C, 0xE4, 0x20,
  0x00, 0x39, 0x00, 0x0F, 0xDD, 0xFF, 0x79, 0x64, 0x9B, 0x84, 0x00, 0x70,
  0x00, 0x75, 0x00, 0x0F, 0x22, 0x22, 0x09, 0xA4, 0x10, 0x00, 0x01, 0x90,
  0x00, 0xB0, 0x00, 0x0F, 0x26, 0x87, 0x39, 0x60, 0x00, 0x00, 0x03, 0x90,
  0x05, 0x51, 0x68, 0xBD, 0x84, 0x00, 0x09, 0xDB, 0xBB, 0xBB, 0xBE, 0xE1,
  0x17, 0x00, 0xBB, 0x30, 0x00, 0x00, 0x01, 0x44, 0x44, 0x44, 0x44, 0x20,
  0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/* Start of unicode area <Halfwidth and Fullwidth Forms> */
GUI_CONST_STORAGE unsigned char acGUI_FontChinese_24_FF1F[102] = { /* code FF1F, FULLWIDTH QUESTION MARK */
  0x00, 0x28, 0xBD, 0xDB, 0x71, 0x00,
  0x06, 0xB4, 0x10, 0x03, 0xAE, 0x60,
  0x4A, 0x00, 0x00, 0x00, 0x0B, 0xF4,
  0xA2, 0x00, 0x00, 0x00, 0x05, 0xFB,
  0xBD, 0xE2, 0x00, 0x00, 0x04, 0xFD,
  0x9F, 0xF5, 0x00, 0x00, 0x06, 0xFC,
  0x18, 0x70, 0x00, 0x00, 0x3E, 0xF5,
  0x00, 0x00, 0x00, 0x08, 0xFE, 0x60,
  0x00, 0x00, 0x01, 0xCF, 0x91, 0x00,
  0x00, 0x00, 0x07, 0xC2, 0x00, 0x00,
  0x00, 0x00, 0x09, 0x30, 0x00, 0x00,
  0x00, 0x00, 0x09, 0x10, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x1A, 0x70, 0x00, 0x00,
  0x00, 0x00, 0x7F, 0xF2, 0x00, 0x00,
  0x00, 0x00, 0x3C, 0xA0, 0x00, 0x00
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_FontChinese_24_CharInfo[48] = {
   {   1,   1,   0,  21,  12, acGUI_FontChinese_24_0020 } /* code 0020, SPACE */
  ,{   4,   7,   1,   1,  12, acGUI_FontChinese_24_0027 } /* code 0027, APOSTROPHE */
  ,{   4,   3,   1,  18,  12, acGUI_FontChinese_24_002E } /* code 002E, FULL STOP */
  ,{  10,  20,   1,   2,  12, acGUI_FontChinese_24_003F } /* code 003F, QUESTION MARK */
  ,{  12,  17,   0,   4,  12, acGUI_FontChinese_24_0042 } /* code 0042, LATIN CAPITAL LETTER B */
  ,{  12,  17,   0,   4,  12, acGUI_FontChinese_24_0043 } /* code 0043, LATIN CAPITAL LETTER C */
  ,{  12,  17,   0,   4,  12, acGUI_FontChinese_24_0044 } /* code 0044, LATIN CAPITAL LETTER D */
  ,{  12,  17,   0,   4,  12, acGUI_FontChinese_24_0047 } /* code 0047, LATIN CAPITAL LETTER G */
  ,{   8,  17,   2,   4,  12, acGUI_FontChinese_24_0049 } /* code 0049, LATIN CAPITAL LETTER I */
  ,{  12,  17,   0,   4,  12, acGUI_FontChinese_24_0054 } /* code 0054, LATIN CAPITAL LETTER T */
  ,{  11,  11,   1,  10,  12, acGUI_FontChinese_24_0061 } /* code 0061, LATIN SMALL LETTER A */
  ,{  10,  11,   1,  10,  12, acGUI_FontChinese_24_0065 } /* code 0065, LATIN SMALL LETTER E */
  ,{  11,  17,   1,   4,  12, acGUI_FontChinese_24_0066 } /* code 0066, LATIN SMALL LETTER F */
  ,{  12,  18,   0,   3,  12, acGUI_FontChinese_24_0068 } /* code 0068, LATIN SMALL LETTER H */
  ,{   8,  17,   2,   4,  12, acGUI_FontChinese_24_0069 } /* code 0069, LATIN SMALL LETTER I */
  ,{  12,  18,   0,   3,  12, acGUI_FontChinese_24_006B } /* code 006B, LATIN SMALL LETTER K */
  ,{   8,  18,   2,   3,  12, acGUI_FontChinese_24_006C } /* code 006C, LATIN SMALL LETTER L */
  ,{  12,  12,   0,   9,  12, acGUI_FontChinese_24_006D } /* code 006D, LATIN SMALL LETTER M */
  ,{  12,  12,   0,   9,  12, acGUI_FontChinese_24_006E } /* code 006E, LATIN SMALL LETTER N */
  ,{  10,  11,   1,  10,  12, acGUI_FontChinese_24_006F } /* code 006F, LATIN SMALL LETTER O */
  ,{  11,  12,   0,   9,  12, acGUI_FontChinese_24_0072 } /* code 0072, LATIN SMALL LETTER R */
  ,{  10,  12,   1,  10,  12, acGUI_FontChinese_24_0073 } /* code 0073, LATIN SMALL LETTER S */
  ,{  10,  15,   1,   6,  12, acGUI_FontChinese_24_0074 } /* code 0074, LATIN SMALL LETTER T */
  ,{  12,  12,   0,   9,  12, acGUI_FontChinese_24_0075 } /* code 0075, LATIN SMALL LETTER U */
  ,{  12,  11,   0,  10,  12, acGUI_FontChinese_24_0077 } /* code 0077, LATIN SMALL LETTER W */
  ,{  11,  14,   1,  10,  12, acGUI_FontChinese_24_0079 } /* code 0079, LATIN SMALL LETTER Y */
  ,{   7,   7,   0,  17,  24, acGUI_FontChinese_24_3002 } /* code 3002, IDEOGRAPHIC FULL STOP */
  ,{  19,  23,   3,   1,  24, acGUI_FontChinese_24_4E2D } /* code 4E2D */
  ,{  20,  20,   2,   3,  24, acGUI_FontChinese_24_4E86 } /* code 4E86 */
  ,{  23,  23,   1,   1,  24, acGUI_FontChinese_24_4F5C } /* code 4F5C */
  ,{  24,  23,   0,   1,  24, acGUI_FontChinese_24_4F60 } /* code 4F60 */
  ,{  24,  23,   0,   1,  24, acGUI_FontChinese_24_4F7F } /* code 4F7F */
  ,{  21,  22,   2,   2,  24, acGUI_FontChinese_24_55CE } /* code 55CE */
  ,{  21,  22,   2,   2,  24, acGUI_FontChinese_24_56FD } /* code 56FD */
  ,{  22,  18,   2,   3,  24, acGUI_FontChinese_24_5DE5 } /* code 5DE5 */
  ,{  22,  23,   1,   1,  24, acGUI_FontChinese_24_5FB7 } /* code 5FB7 */
  ,{  23,  22,   0,   1,  24, acGUI_FontChinese_24_6211 } /* code 6211 */
  ,{  23,  22,   0,   1,  24, acGUI_FontChinese_24_65BC } /* code 65BC */
  ,{  22,  23,   0,   1,  24, acGUI_FontChinese_24_6613 } /* code 6613 */
  ,{  23,  23,   1,   1,  24, acGUI_FontChinese_24_662F } /* code 662F */
  ,{  23,  23,   1,   1,  24, acGUI_FontChinese_24_6765 } /* code 6765 */
  ,{  22,  21,   0,   2,  24, acGUI_FontChinese_24_7528 } /* code 7528 */
  ,{  21,  23,   2,   1,  24, acGUI_FontChinese_24_7684 } /* code 7684 */
  ,{  23,  23,   0,   1,  24, acGUI_FontChinese_24_7F8E } /* code 7F8E */
  ,{  15,  23,   5,   1,  24, acGUI_FontChinese_24_81EA } /* code 81EA */
  ,{  23,  21,   1,   2,  24, acGUI_FontChinese_24_9019 } /* code 9019 */
  ,{  24,  23,   0,   1,  24, acGUI_FontChinese_24_9E97 } /* code 9E97 */
  ,{  12,  17,   6,   4,  24, acGUI_FontChinese_24_FF1F } /* code FF1F, FULLWIDTH QUESTION MARK */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop37 = {
   0xFF1F /* first character */
  ,0xFF1F /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 47] /* address of first character */
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop36 = {
   0x9E97 /* first character */
  ,0x9E97 /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 46] /* address of first character */
  ,&GUI_FontChinese_24_Prop37 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop35 = {
   0x9019 /* first character */
  ,0x9019 /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 45] /* address of first character */
  ,&GUI_FontChinese_24_Prop36 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop34 = {
   0x81EA /* first character */
  ,0x81EA /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 44] /* address of first character */
  ,&GUI_FontChinese_24_Prop35 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop33 = {
   0x7F8E /* first character */
  ,0x7F8E /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 43] /* address of first character */
  ,&GUI_FontChinese_24_Prop34 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop32 = {
   0x7684 /* first character */
  ,0x7684 /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 42] /* address of first character */
  ,&GUI_FontChinese_24_Prop33 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop31 = {
   0x7528 /* first character */
  ,0x7528 /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 41] /* address of first character */
  ,&GUI_FontChinese_24_Prop32 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop30 = {
   0x6765 /* first character */
  ,0x6765 /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 40] /* address of first character */
  ,&GUI_FontChinese_24_Prop31 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop29 = {
   0x662F /* first character */
  ,0x662F /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 39] /* address of first character */
  ,&GUI_FontChinese_24_Prop30 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop28 = {
   0x6613 /* first character */
  ,0x6613 /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 38] /* address of first character */
  ,&GUI_FontChinese_24_Prop29 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop27 = {
   0x65BC /* first character */
  ,0x65BC /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 37] /* address of first character */
  ,&GUI_FontChinese_24_Prop28 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop26 = {
   0x6211 /* first character */
  ,0x6211 /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 36] /* address of first character */
  ,&GUI_FontChinese_24_Prop27 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop25 = {
   0x5FB7 /* first character */
  ,0x5FB7 /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 35] /* address of first character */
  ,&GUI_FontChinese_24_Prop26 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop24 = {
   0x5DE5 /* first character */
  ,0x5DE5 /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 34] /* address of first character */
  ,&GUI_FontChinese_24_Prop25 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop23 = {
   0x56FD /* first character */
  ,0x56FD /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 33] /* address of first character */
  ,&GUI_FontChinese_24_Prop24 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop22 = {
   0x55CE /* first character */
  ,0x55CE /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 32] /* address of first character */
  ,&GUI_FontChinese_24_Prop23 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop21 = {
   0x4F7F /* first character */
  ,0x4F7F /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 31] /* address of first character */
  ,&GUI_FontChinese_24_Prop22 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop20 = {
   0x4F60 /* first character */
  ,0x4F60 /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 30] /* address of first character */
  ,&GUI_FontChinese_24_Prop21 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop19 = {
   0x4F5C /* first character */
  ,0x4F5C /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 29] /* address of first character */
  ,&GUI_FontChinese_24_Prop20 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop18 = {
   0x4E86 /* first character */
  ,0x4E86 /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 28] /* address of first character */
  ,&GUI_FontChinese_24_Prop19 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop17 = {
   0x4E2D /* first character */
  ,0x4E2D /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 27] /* address of first character */
  ,&GUI_FontChinese_24_Prop18 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop16 = {
   0x3002 /* first character */
  ,0x3002 /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 26] /* address of first character */
  ,&GUI_FontChinese_24_Prop17 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop15 = {
   0x0079 /* first character */
  ,0x0079 /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 25] /* address of first character */
  ,&GUI_FontChinese_24_Prop16 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop14 = {
   0x0077 /* first character */
  ,0x0077 /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 24] /* address of first character */
  ,&GUI_FontChinese_24_Prop15 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop13 = {
   0x0072 /* first character */
  ,0x0075 /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 20] /* address of first character */
  ,&GUI_FontChinese_24_Prop14 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop12 = {
   0x006B /* first character */
  ,0x006F /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 15] /* address of first character */
  ,&GUI_FontChinese_24_Prop13 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop11 = {
   0x0068 /* first character */
  ,0x0069 /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 13] /* address of first character */
  ,&GUI_FontChinese_24_Prop12 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop10 = {
   0x0065 /* first character */
  ,0x0066 /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 11] /* address of first character */
  ,&GUI_FontChinese_24_Prop11 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop9 = {
   0x0061 /* first character */
  ,0x0061 /* last character  */
  ,&GUI_FontChinese_24_CharInfo[ 10] /* address of first character */
  ,&GUI_FontChinese_24_Prop10 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop8 = {
   0x0054 /* first character */
  ,0x0054 /* last character  */
  ,&GUI_FontChinese_24_CharInfo[  9] /* address of first character */
  ,&GUI_FontChinese_24_Prop9 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop7 = {
   0x0049 /* first character */
  ,0x0049 /* last character  */
  ,&GUI_FontChinese_24_CharInfo[  8] /* address of first character */
  ,&GUI_FontChinese_24_Prop8 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop6 = {
   0x0047 /* first character */
  ,0x0047 /* last character  */
  ,&GUI_FontChinese_24_CharInfo[  7] /* address of first character */
  ,&GUI_FontChinese_24_Prop7 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop5 = {
   0x0042 /* first character */
  ,0x0044 /* last character  */
  ,&GUI_FontChinese_24_CharInfo[  4] /* address of first character */
  ,&GUI_FontChinese_24_Prop6 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop4 = {
   0x003F /* first character */
  ,0x003F /* last character  */
  ,&GUI_FontChinese_24_CharInfo[  3] /* address of first character */
  ,&GUI_FontChinese_24_Prop5 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop3 = {
   0x002E /* first character */
  ,0x002E /* last character  */
  ,&GUI_FontChinese_24_CharInfo[  2] /* address of first character */
  ,&GUI_FontChinese_24_Prop4 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop2 = {
   0x0027 /* first character */
  ,0x0027 /* last character  */
  ,&GUI_FontChinese_24_CharInfo[  1] /* address of first character */
  ,&GUI_FontChinese_24_Prop3 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_FontChinese_24_Prop1 = {
   0x0020 /* first character */
  ,0x0020 /* last character  */
  ,&GUI_FontChinese_24_CharInfo[  0] /* address of first character */
  ,&GUI_FontChinese_24_Prop2 /* pointer to next GUI_FONT_PROP_EXT */
};

GUI_CONST_STORAGE GUI_FONT GUI_FontChinese_24 = {
   GUI_FONTTYPE_PROP_AA4_EXT /* type of font    */
  ,24 /* height of font  */
  ,24 /* space of font y */
  ,1 /* magnification x */
  ,1 /* magnification y */
  ,{&GUI_FontChinese_24_Prop1}
  ,21 /* Baseline */
  ,11 /* Height of lowercase characters */
  ,17 /* Height of capital characters */
};

/*******************************************************************
*
*       Chinese text samples
*/
static char * _apText[] = {
  "\nI'm from Germany.\n\n\xe6\x88\x91\xe6\x9d\xa5\xe8\x87\xaa\xe5\xbe\xb7\xe5\x9b\xbd\xe3\x80\x82",
  "\nI'm from China.\n\n\xe6\x88\x91\xe6\x9d\xa5\xe8\x87\xaa\xe4\xb8\xad\xe5\x9b\xbd\xe3\x80\x82",
  "\nBeautiful\n\n\xe7\xbe\x8e\xe9\xba\x97",
  "\nDo you work?\n\n\xe4\xbd\xa0\xe5\xb7\xa5\xe4\xbd\x9c\xe4\xba\x86\xe5\x97\x8e\xef\xbc\x9f",
  "\nThis is easy to use.\n\n\xe9\x80\x99\xe6\x98\xaf\xe6\x98\x93\xe6\x96\xbc\xe4\xbd\xbf\xe7\x94\xa8\xe7\x9a\x84\xe3\x80\x82"
};

/********************************************************************
*
*       Static code
*
*********************************************************************
*/
/*******************************************************************
*
*       _ShowChineseTextSamples
*/
static void _ShowChineseTextSamples(void) {
  GUI_RECT Rect = {40, 60, 279, 199};

  GUI_SetFont(&GUI_FontChinese_24); // Set Chinese font
  while (1) {
    unsigned i;

    GUI_SetColor(GUI_RED);
    GUI_DrawRect(Rect.x0 - 1, Rect.y0 - 1, Rect.x1 + 1, Rect.y1 + 1);
    GUI_SetColor(GUI_WHITE);
    for (i = 0; i < GUI_COUNTOF(_apText); i++) {
      GUI_DispStringInRectWrap(_apText[i], &Rect, GUI_TA_HCENTER, GUI_WRAPMODE_WORD);
      GUI_Delay(2000);
      GUI_ClearRectEx(&Rect);
    }
  }
}

/********************************************************************
*
*       Public code
*
*********************************************************************
*/
/********************************************************************
*
*       MainTask
*/
void MainTask(void) {
  GUI_Init();
  GUI_UC_SetEncodeUTF8(); // Enable UTF8 decoding
  //
  // Lable the sample
  //
  GUI_SetFont(&GUI_Font24_ASCII);
  GUI_DispStringHCenterAt("Chinese language sample", 160, 5);
  //
  // Call demo loop
  //
  _ShowChineseTextSamples();
}

/*************************** End of file ****************************/
