/*********************************************************************
*                SEGGER Microcontroller GmbH                         *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2018  SEGGER Microcontroller GmbH                *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.48 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software  has been licensed to  Cypress Semiconductor Corporation,
whose registered  office is situated  at 198 Champion Ct. San Jose, CA 
95134 USA  solely for the  purposes of creating  libraries for Cypress
PSoC3 and  PSoC5 processor-based devices,  sublicensed and distributed
under  the  terms  and  conditions  of  the  Cypress  End User License
Agreement.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information
Licensor:                 SEGGER Microcontroller Systems LLC
Licensed to:              Cypress Semiconductor Corp, 198 Champion Ct., San Jose, CA 95134, USA
Licensed SEGGER software: emWin
License number:           GUI-00319
License model:            Services and License Agreement, signed June 10th, 2009
Licensed platform:        Any Cypress platform (Initial targets are: PSoC3, PSoC5)
----------------------------------------------------------------------
Support and Update Agreement (SUA)
SUA period:               2009-06-12 - 2022-07-27
Contact to extend SUA:    sales@segger.com
---------------------------------------------------------------------
File        : bmKNOB_175x175.c
Purpose     : 175 * 175 pixels, 16777216 colors + 8 bit Alpha
---------------------------END-OF-HEADER------------------------------
*/
/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
*                           www.segger.com                           *
**********************************************************************
*                                                                    *
* C-file generated by                                                *
*                                                                    *
*        Bitmap Converter for emWin V5.32.                           *
*        Compiled Oct  8 2015, 11:57:58                              *
*                                                                    *
*        (c) 1998 - 2015 Segger Microcontroller GmbH & Co. KG        *
*                                                                    *
**********************************************************************
*                                                                    *
* Source file: KNOB_175x175                                          *
* Dimensions:  175 * 175                                             *
* NumColors:   32bpp: 16777216 + 256                                 *
*                                                                    *
**********************************************************************
*/

#include <stdlib.h>

#include "GUI.h"

#ifndef GUI_CONST_STORAGE
  #define GUI_CONST_STORAGE const
#endif

extern GUI_CONST_STORAGE GUI_BITMAP bmKNOB_175x175;

static GUI_CONST_STORAGE unsigned long _acKNOB_175x175[] = {
#if GUI_USE_ARGB
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x00D6D7D8, 0x00D2D3D4, 0x00D1D2D2, 0x00CFD0D0, 0x00C8CACA, 0x00C3C5C6, 0x00C5C6C6, 0x00C1C2C3, 0x00BDBEBF, 0x00BBBDBE, 0x00B6B8B8, 0x00B6B7B8, 0x00B4B6B7, 0x00B1B3B4, 0x00AFB0B1, 0x00ACAEAF, 
        0x00AAABAC, 0x00A9ABAC, 0x00A6A8AA, 0x00A4A7A8, 0x00A2A4A5, 0x00A1A3A5, 0x00A0A2A3, 0x009EA0A2, 0x009C9E9F, 0x009A9D9D, 0x009A9D9E, 0x00989A9C, 0x00969899, 0x0095989A, 0x00949698, 0x00919495, 0x00909394, 0x008F9294, 0x008E9092, 0x008D8F91, 
        0x008B8F90, 0x008C8F90, 0x008C8D8F, 0x00888A8B, 0x00898C8D, 0x0086888A, 0x00878A8B, 0x00858789, 0x00838587, 0x00848789, 0x007F8183, 0x00818385, 0x0A808384, 0x167D7F80, 0x337B7E7F, 0x507D7F80, 0x6A787B7C, 0x7C77797A, 0x8B747778, 0x9E757879, 
        0xAC787A7B, 0xAF7A7C7D, 0xC27C7E80, 0xC4797C7D, 0xC4757778, 0xC4727576, 0xC4707374, 0xC36E7071, 0xB06B6D6E, 0xAD696A6C, 0x9F67696A, 0x8C5B5E5F, 0x7C333434, 0x6A333535, 0x515A5C5D, 0x34606263, 0x182E2F30, 0x0A050505, 0x000B0C0C, 0x00414344, 
        0x00000000, 0x00030403, 0x00222323, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x00D6D7D8, 0x00D2D3D4, 0x00D1D2D2, 0x00CFD0D0, 0x00C8CACA, 0x00C3C5C6, 0x00C5C6C6, 0x00C1C2C3, 0x00BDBEBF, 0x00BBBDBE, 0x00B6B8B8, 0x00B6B7B8, 0x00B4B6B7, 0x00B1B3B4, 0x00AFB0B1, 0x00ACAEAF, 
        0x00AAABAC, 0x00A9ABAC, 0x00A6A8AA, 0x00A4A7A8, 0x00A2A4A5, 0x00A1A3A5, 0x00A0A2A3, 0x009EA0A2, 0x009C9E9F, 0x009A9D9D, 0x009A9D9E, 0x00989A9C, 0x00969899, 0x0095989A, 0x00949698, 0x00919495, 0x00909394, 0x008F9294, 0x008E9092, 0x008D8F91, 
        0x008B8F90, 0x008C8F90, 0x008C8D8F, 0x00888A8B, 0x00898C8D, 0x0086888A, 0x0286898A, 0x17848688, 0x3F828486, 0x69818486, 0x8E7F8283, 0xB8838688, 0xDC848789, 0xF287898B, 0xFA8E9092, 0xFF949597, 0xFF96989A, 0xFF9C9E9F, 0xFFA2A3A5, 0xFFA6A8A9, 
        0xFFA9AAAC, 0xFFA8AAAC, 0xFFACAEAF, 0xFFACADAE, 0xFFABABAE, 0xFFA9AAAC, 0xFFA8A9AB, 0xFFA5A7A8, 0xFFA1A3A4, 0xFFA0A1A3, 0xFF9C9EA0, 0xFF999A9C, 0xFF999B9C, 0xFF8F9193, 0xFF7B7C7F, 0xFA727476, 0xF26D6F70, 0xDD626465, 0xBA57595B, 0x8F505253, 
        0x6A2D2E2E, 0x422F3131, 0x19262828, 0x02040505, 0x00010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x00D6D7D8, 0x00D2D3D4, 0x00D1D2D2, 0x00CFD0D0, 0x00C8CACA, 0x00C3C5C6, 0x00C5C6C6, 0x00C1C2C3, 0x00BDBEBF, 0x00BBBDBE, 0x00B6B8B8, 0x00B6B7B8, 0x00B4B6B7, 0x00B1B3B4, 0x00AFB0B1, 0x00ACAEAF, 
        0x00AAABAC, 0x00A9ABAC, 0x00A6A8AA, 0x00A4A7A8, 0x00A2A4A5, 0x00A1A3A5, 0x00A0A2A3, 0x009EA0A2, 0x009C9E9F, 0x009A9D9D, 0x009A9D9E, 0x00989A9C, 0x00969899, 0x0095989A, 0x00949698, 0x00919495, 0x00909394, 0x008F9294, 0x008E9092, 0x008D8F91, 
        0x008B8F90, 0x008C8F90, 0x048B8C8E, 0x2487898A, 0x5B878A8B, 0x8E858789, 0xC2898B8D, 0xEE8E9091, 0xFE959899, 0xFF9D9FA1, 0xFFA9ABAC, 0xFFB1B2B4, 0xFFB7B9BA, 0xFFC0C0C2, 0xFFC1C2C3, 0xFFBFBFC2, 0xFFBFC0C1, 0xFFBFC0C2, 0xFFBFC0C2, 0xFFBEBEC0, 
        0xFFBCBCBE, 0xFFBABBBC, 0xFFB8B8BA, 0xFFB8B8BA, 0xFFB7B8BA, 0xFFB7B8BA, 0xFFB7B8BA, 0xFFB6B7B9, 0xFFB6B8B9, 0xFFB8B9BA, 0xFFB9B9BB, 0xFFB9BABB, 0xFFB9B9BB, 0xFFB7B7B9, 0xFFB4B5B7, 0xFFB4B5B7, 0xFFB4B5B7, 0xFFA9AAAC, 0xFF9C9D9F, 0xFF949597, 
        0xFF87898B, 0xFE757879, 0xEF646667, 0xC4555858, 0x91434446, 0x5D28292A, 0x27202020, 0x05050505, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x00D6D7D8, 0x00D2D3D4, 0x00D1D2D2, 0x00CFD0D0, 0x00C8CACA, 0x00C3C5C6, 0x00C5C6C6, 0x00C1C2C3, 0x00BDBEBF, 0x00BBBDBE, 0x00B6B8B8, 0x00B6B7B8, 0x00B4B6B7, 0x00B1B3B4, 0x00AFB0B1, 0x00ACAEAF, 
        0x00AAABAC, 0x00A9ABAC, 0x00A6A8AA, 0x00A4A7A8, 0x00A2A4A5, 0x00A1A3A5, 0x00A0A2A3, 0x009EA0A2, 0x009C9E9F, 0x009A9D9D, 0x009A9D9E, 0x00989A9C, 0x00969899, 0x0095989A, 0x00949698, 0x00919495, 0x00909394, 0x008F9294, 0x008E8F91, 0x0D8C8E90, 
        0x488A8D8E, 0x8A8A8D8E, 0xC98D8F91, 0xF6959698, 0xFF9EA0A2, 0xFFADAEB0, 0xFFB5B6B8, 0xFFC0C1C2, 0xFFC4C4C6, 0xFFC2C3C4, 0xFFC2C3C4, 0xFFBEBFC1, 0xFFBBBBBC, 0xFFB8B8BA, 0xFFB5B6B8, 0xFFB3B3B5, 0xFFB2B3B5, 0xFFB1B2B4, 0xFFB0B1B3, 0xFFB0B0B2, 
        0xFFAFB0B2, 0xFFAFAFB1, 0xFFAEAFB0, 0xFFAEAEB0, 0xFFAEAEB0, 0xFFAEADB0, 0xFFACADAF, 0xFFACADAF, 0xFFABACAE, 0xFFABABAD, 0xFFAAABAD, 0xFFAAABAD, 0xFFAAABAD, 0xFFAAABAD, 0xFFAAABAD, 0xFFABABAE, 0xFFACADAF, 0xFFAFAFB1, 0xFFB1B2B4, 0xFFB4B4B6, 
        0xFFB2B2B4, 0xFFB0B1B3, 0xFFABABAD, 0xFF9A9C9D, 0xFF8F9092, 0xFF7C7D7F, 0xF6696A6C, 0xCC555658, 0x8E383A3A, 0x4B262727, 0x11101011, 0x00020102, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x00D6D7D8, 0x00D2D3D4, 0x00D1D2D2, 0x00CFD0D0, 0x00C8CACA, 0x00C3C5C6, 0x00C5C6C6, 0x00C1C2C3, 0x00BDBEBF, 0x00BBBDBE, 0x00B6B8B8, 0x00B6B7B8, 0x00B4B6B7, 0x00B1B3B4, 0x00AFB0B1, 0x00ACAEAF, 
        0x00AAABAC, 0x00A9ABAC, 0x00A6A8AA, 0x00A4A7A8, 0x00A2A4A5, 0x00A1A3A5, 0x00A0A2A3, 0x009EA0A2, 0x009C9E9F, 0x009A9D9D, 0x009A9D9E, 0x00989A9C, 0x00969899, 0x0095989A, 0x00949698, 0x00909494, 0x0C909394, 0x4C8E9192, 0x998E9091, 0xE1939597, 
        0xFF9C9EA0, 0xFFADAFB1, 0xFFBABBBC, 0xFFC4C5C7, 0xFFC4C5C7, 0xFFC4C4C6, 0xFFBFBFC2, 0xFFBABABC, 0xFFB7B7B9, 0xFFB5B6B7, 0xFFB3B4B6, 0xFFB2B3B4, 0xFFB2B2B4, 0xFFB1B1B4, 0xFFB1B1B3, 0xFFB0B1B3, 0xFFB0B1B3, 0xFFB0B1B3, 0xFFAFB0B2, 0xFFAFB0B1, 
        0xFFAEAFB1, 0xFFAEAFB1, 0xFFADAEB0, 0xFFADADAF, 0xFFACADAF, 0xFFACACAF, 0xFFACACAE, 0xFFABABAD, 0xFFABABAD, 0xFFAAAAAD, 0xFFA9AAAC, 0xFFA9AAAB, 0xFFA8A8AB, 0xFFA8A8AB, 0xFFA8A8AA, 0xFFA6A7A9, 0xFFA6A7A9, 0xFFA5A5A9, 0xFFA4A5A8, 0xFFA5A5A8, 
        0xFFA5A5A8, 0xFFA5A6AA, 0xFFA8A8AB, 0xFFACADAF, 0xFFAEB0B1, 0xFFACAEB0, 0xFFAAABAD, 0xFF9A9A9D, 0xFF8A8B8D, 0xFF717374, 0xE3595B5C, 0x9D424344, 0x4F252627, 0x110F0F0F, 0x00010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x00D6D7D8, 0x00D2D3D4, 0x00D1D2D2, 0x00CFD0D0, 0x00C8CACA, 0x00C3C5C6, 0x00C5C6C6, 0x00C1C2C3, 0x00BDBEBF, 0x00BBBDBE, 0x00B6B8B8, 0x00B6B7B8, 0x00B4B6B7, 0x00B1B3B4, 0x00AFB0B1, 0x00ACAEAF, 
        0x00AAABAC, 0x00A9ABAC, 0x00A6A8AA, 0x00A4A7A8, 0x00A2A4A5, 0x00A1A3A5, 0x00A0A2A3, 0x009EA0A2, 0x009C9E9F, 0x009A9D9D, 0x009A9D9E, 0x00989A9C, 0x00969899, 0x02949799, 0x3A939597, 0x92919394, 0xDE959899, 0xFFA0A2A3, 0xFFB1B2B4, 0xFFBFC0C2, 
        0xFFC6C7C9, 0xFFC5C6C8, 0xFFC0C1C2, 0xFFBABBBD, 0xFFB6B7B9, 0xFFB4B5B7, 0xFFB3B4B6, 0xFFB3B3B5, 0xFFB2B3B5, 0xFFB2B2B5, 0xFFB2B2B5, 0xFFB2B2B5, 0xFFB1B2B4, 0xFFB1B1B3, 0xFFB1B1B3, 0xFFB1B1B3, 0xFFB0B0B2, 0xFFB0B0B2, 0xFFAFAFB2, 0xFFAEAFB1, 
        0xFFAEAEB0, 0xFFADAEB0, 0xFFACADB0, 0xFFACACAF, 0xFFACACAF, 0xFFABABAE, 0xFFABABAD, 0xFFAAABAD, 0xFFAAAAAD, 0xFFAAAAAC, 0xFFA9AAAC, 0xFFA8A9AB, 0xFFA8A8AB, 0xFFA7A8AA, 0xFFA6A7A9, 0xFFA6A6A9, 0xFFA5A5A8, 0xFFA3A5A8, 0xFFA3A4A7, 0xFFA2A3A6, 
        0xFFA2A2A5, 0xFFA1A2A5, 0xFFA1A1A4, 0xFFA0A1A3, 0xFFA1A1A4, 0xFFA2A3A5, 0xFFA3A4A6, 0xFFA9A9AC, 0xFFABACAF, 0xFFA9AAAD, 0xFF9D9EA0, 0xFF888A8C, 0xFF707274, 0xE158595B, 0x973E4041, 0x3F1F2021, 0x04050505, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x00D6D7D8, 0x00D2D3D4, 0x00D1D2D2, 0x00CFD0D0, 0x00C8CACA, 0x00C3C5C6, 0x00C5C6C6, 0x00C1C2C3, 0x00BDBEBF, 0x00BBBDBE, 0x00B6B8B8, 0x00B6B7B8, 0x00B4B6B7, 0x00B1B3B4, 0x00AFB0B1, 0x00ACAEAF, 
        0x00AAABAC, 0x00A9ABAC, 0x00A6A8AA, 0x00A4A7A8, 0x00A2A4A5, 0x00A1A3A5, 0x00A0A2A3, 0x009EA0A2, 0x009C9E9F, 0x009A9D9D, 0x009A9D9E, 0x1797999B, 0x68959798, 0xC297999B, 0xFCA0A2A4, 0xFFB1B3B4, 0xFFC0C1C3, 0xFFC7C8C9, 0xFFC5C6C8, 0xFFBFBFC1, 
        0xFFB9BABB, 0xFFB6B7B9, 0xFFB4B5B7, 0xFFB4B4B6, 0xFFB4B4B6, 0xFFB3B4B5, 0xFFB3B4B5, 0xFFB3B3B5, 0xFFB2B3B5, 0xFFB2B3B5, 0xFFB1B2B5, 0xFFB1B2B5, 0xFFB1B2B4, 0xFFB1B1B4, 0xFFB0B1B3, 0xFFB0B0B3, 0xFFAFAFB2, 0xFFAFAFB1, 0xFFADAEB1, 0xFFADADB0, 
        0xFFADADAF, 0xFFACADAF, 0xFFACACAE, 0xFFABACAE, 0xFFABABAE, 0xFFABABAE, 0xFFAAABAD, 0xFFAAA9AD, 0xFFA9A9AC, 0xFFA8A9AB, 0xFFA8A9AA, 0xFFA7A8AA, 0xFFA7A7A9, 0xFFA6A6A9, 0xFFA5A6A8, 0xFFA5A5A8, 0xFFA4A4A7, 0xFFA3A3A6, 0xFFA2A3A6, 0xFFA2A3A5, 
        0xFFA2A2A5, 0xFFA1A2A4, 0xFFA0A1A4, 0xFF9FA0A4, 0xFF9FA0A2, 0xFF9E9FA2, 0xFF9D9EA1, 0xFF9D9EA0, 0xFF9D9DA1, 0xFF9F9FA2, 0xFFA3A4A7, 0xFFA7A8AB, 0xFFA6A7AA, 0xFF9A9B9E, 0xFF848587, 0xFE696B6D, 0xC54E5051, 0x6F303132, 0x1D121212, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x00D6D7D8, 0x00D2D3D4, 0x00D1D2D2, 0x00CFD0D0, 0x00C8CACA, 0x00C3C5C6, 0x00C5C6C6, 0x00C1C2C3, 0x00BDBEBF, 0x00BBBDBE, 0x00B6B8B8, 0x00B6B7B8, 0x00B4B6B7, 0x00B1B3B4, 0x00AFB0B1, 0x00ACAEAF, 
        0x00AAABAC, 0x00A9ABAC, 0x00A6A8AA, 0x00A4A7A8, 0x00A2A4A5, 0x00A1A3A5, 0x00A0A2A3, 0x009EA0A2, 0x009C9E9F, 0x29999C9C, 0x89999C9C, 0xE59DA0A1, 0xFFAAADAE, 0xFFBCBEBF, 0xFFC7C8CA, 0xFFC6C7C9, 0xFFC0C0C2, 0xFFBABABC, 0xFFB7B7B9, 0xFFB5B5B7, 
        0xFFB4B5B7, 0xFFB4B5B7, 0xFFB4B5B6, 0xFFB4B5B7, 0xFFB4B4B6, 0xFFB3B4B6, 0xFFB2B4B5, 0xFFB3B3B5, 0xFFB2B3B4, 0xFFB2B2B4, 0xFFB1B2B4, 0xFFB1B2B4, 0xFFB0B0B3, 0xFFB0B0B2, 0xFFAFB0B2, 0xFFAEAFB1, 0xFFAEAFB1, 0xFFADAEB0, 0xFFADAEB0, 0xFFADAEB0, 
        0xFFACADAF, 0xFFACACAF, 0xFFABACAE, 0xFFABACAE, 0xFFAAABAD, 0xFFA9AAAD, 0xFFA9A9AC, 0xFFA8A9AC, 0xFFA8A9AA, 0xFFA7A8AA, 0xFFA7A7AA, 0xFFA6A7A9, 0xFFA5A6A8, 0xFFA5A5A8, 0xFFA4A5A7, 0xFFA3A4A7, 0xFFA3A4A6, 0xFFA3A3A5, 0xFFA2A3A5, 0xFFA2A2A5, 
        0xFFA1A1A4, 0xFFA0A1A4, 0xFFA0A1A3, 0xFF9EA0A3, 0xFF9E9FA2, 0xFF9D9EA1, 0xFF9C9DA0, 0xFF9C9CA0, 0xFF9B9C9F, 0xFF9A9B9E, 0xFF9A9B9E, 0xFF9A9B9E, 0xFF9C9DA0, 0xFFA1A1A4, 0xFFA4A6A9, 0xFFA1A3A5, 0xFF909194, 0xFF787A7C, 0xE85B5D5E, 0x90373838, 
        0x2F1A1A1A, 0x00010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x00D6D7D8, 0x00D2D3D4, 0x00D1D2D2, 0x00CFD0D0, 0x00C8CACA, 0x00C3C5C6, 0x00C5C6C6, 0x00C1C2C3, 0x00BDBEBF, 0x00BBBDBE, 0x00B6B8B8, 0x00B6B7B8, 0x00B4B6B7, 0x00B1B3B4, 0x00AFB0B1, 0x00ACAEAF, 
        0x00AAABAC, 0x00A9ABAC, 0x00A6A8AA, 0x00A4A7A8, 0x00A2A4A5, 0x00A1A3A5, 0x00A0A2A3, 0x359D9FA1, 0xA09C9EA0, 0xF3A3A5A6, 0xFFB4B5B7, 0xFFC5C5C7, 0xFFC8C9CB, 0xFFC3C4C6, 0xFFBBBCBE, 0xFFB8B7BA, 0xFFB5B5B8, 0xFFB5B5B8, 0xFFB5B5B7, 0xFFB5B5B7, 
        0xFFB5B5B7, 0xFFB4B5B7, 0xFFB4B5B7, 0xFFB4B5B7, 0xFFB3B4B6, 0xFFB3B3B6, 0xFFB2B3B5, 0xFFB2B3B4, 0xFFB2B2B4, 0xFFB1B2B4, 0xFFB1B1B4, 0xFFB0B0B3, 0xFFAFAFB2, 0xFFAEAFB2, 0xFFAFAFB1, 0xFFAEAFB1, 0xFFAEAEB0, 0xFFAEAEB0, 0xFFADAEB0, 0xFFACADAF, 
        0xFFACACAE, 0xFFABACAE, 0xFFAAABAD, 0xFFAAA9AD, 0xFFA9AAAD, 0xFFA9AAAC, 0xFFA8A8AB, 0xFFA7A8AA, 0xFFA6A7A9, 0xFFA6A7A9, 0xFFA6A6A9, 0xFFA5A5A8, 0xFFA4A5A8, 0xFFA4A5A7, 0xFFA4A5A7, 0xFFA3A4A6, 0xFFA2A3A6, 0xFFA1A2A5, 0xFFA1A2A5, 0xFFA1A1A4, 
        0xFFA0A1A3, 0xFF9FA0A2, 0xFF9F9FA2, 0xFF9E9FA1, 0xFF9D9EA1, 0xFF9C9DA0, 0xFF9C9DA0, 0xFF9B9CA0, 0xFF9B9C9E, 0xFF9A9B9E, 0xFF9A9B9E, 0xFF99999D, 0xFF98989B, 0xFF97989B, 0xFF97989B, 0xFF9A9B9E, 0xFFA0A1A3, 0xFFA2A2A6, 0xFF97989B, 0xFF7F8082, 
        0xF6636466, 0xA6444546, 0x3C1D1E1E, 0x00010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x00D6D7D8, 0x00D2D3D4, 0x00D1D2D2, 0x00CFD0D0, 0x00C8CACA, 0x00C3C5C6, 0x00C5C6C6, 0x00C1C2C3, 0x00BDBEBF, 0x00BBBDBE, 0x00B6B8B8, 0x00B6B7B8, 0x00B4B6B7, 0x00B1B3B4, 0x00AFB0B1, 0x00ACAEAF, 
        0x00AAABAC, 0x00A9ABAC, 0x00A6A8AA, 0x00A4A7A8, 0x00A2A4A5, 0x31A0A2A4, 0xA2A0A2A4, 0xF9A7A9AB, 0xFFB8BABB, 0xFFC7C8CA, 0xFFC8C9CB, 0xFFC0C0C2, 0xFFB9BABC, 0xFFB6B7B9, 0xFFB5B6B8, 0xFFB5B6B9, 0xFFB5B6B8, 0xFFB5B6B8, 0xFFB5B6B8, 0xFFB4B5B8, 
        0xFFB4B5B8, 0xFFB4B4B7, 0xFFB4B4B6, 0xFFB3B4B6, 0xFFB3B3B5, 0xFFB2B3B5, 0xFFB2B2B4, 0xFFB1B1B3, 0xFFB1B1B3, 0xFFB0B1B3, 0xFFB0B0B2, 0xFFAFB0B3, 0xFFAEAFB2, 0xFFAEAFB2, 0xFFADAEB1, 0xFFAEADB0, 0xFFADADB0, 0xFFACADB0, 0xFFACADAF, 0xFFABACAE, 
        0xFFABABAD, 0xFFA9AAAD, 0xFFA9AAAC, 0xFFA9A9AC, 0xFFA8A9AC, 0xFFA8A8AA, 0xFFA7A7AA, 0xFFA6A7AA, 0xFFA5A6A9, 0xFFA5A6A9, 0xFFA5A5A8, 0xFFA4A5A8, 0xFFA4A5A7, 0xFFA4A4A6, 0xFFA3A3A7, 0xFFA2A3A6, 0xFFA1A2A4, 0xFFA1A2A4, 0xFFA0A1A3, 0xFF9FA0A2, 
        0xFF9FA0A2, 0xFF9E9FA1, 0xFF9D9FA1, 0xFF9D9EA1, 0xFF9C9DA0, 0xFF9C9D9F, 0xFF9B9D9F, 0xFF9A9B9F, 0xFF9A9A9E, 0xFF99999D, 0xFF989A9C, 0xFF98999C, 0xFF97989B, 0xFF96979A, 0xFF96979A, 0xFF959699, 0xFF949699, 0xFF96979B, 0xFF9B9C9F, 0xFF9FA0A3, 
        0xFF97999C, 0xFF838587, 0xFC67696B, 0xA9464748, 0x391C1D1D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x00D6D7D8, 0x00D2D3D4, 0x00D1D2D2, 0x00CFD0D0, 0x00C8CACA, 0x00C3C5C6, 0x00C5C6C6, 0x00C1C2C3, 0x00BDBEBF, 0x00BBBDBE, 0x00B6B8B8, 0x00B6B7B8, 0x00B4B6B7, 0x00B1B3B4, 0x00AFB0B1, 0x00ACAEAF, 
        0x00AAABAC, 0x00A9ABAC, 0x00A6A8A9, 0x24A3A6A7, 0x9AA2A4A5, 0xF7AAACAD, 0xFFBBBCBE, 0xFFC8C9CB, 0xFFC7C8CA, 0xFFBFC0C1, 0xFFB9B9BB, 0xFFB6B7B9, 0xFFB6B7B9, 0xFFB6B7B9, 0xFFB6B7B9, 0xFFB6B6B9, 0xFFB5B6B8, 0xFFB5B6B8, 0xFFB4B5B8, 0xFFB4B4B7, 
        0xFFB4B4B6, 0xFFB4B4B6, 0xFFB3B4B5, 0xFFB2B3B5, 0xFFB2B2B4, 0xFFB1B2B4, 0xFFB1B1B3, 0xFFB0B1B3, 0xFFB0B0B3, 0xFFB0B0B2, 0xFFAFB0B2, 0xFFAEB0B2, 0xFFAEAFB1, 0xFFADAEB1, 0xFFADADB0, 0xFFACADAF, 0xFFADADAF, 0xFFACADAF, 0xFFAAACAE, 0xFFAAABAD, 
        0xFFA9A9AC, 0xFFA9A9AD, 0xFFA8A9AB, 0xFFA8A9AB, 0xFFA8A8AB, 0xFFA7A8AA, 0xFFA6A7AA, 0xFFA6A6AA, 0xFFA5A6A9, 0xFFA4A6A8, 0xFFA4A5A7, 0xFFA3A4A7, 0xFFA3A3A6, 0xFFA2A3A6, 0xFFA2A2A5, 0xFFA1A2A4, 0xFFA1A1A4, 0xFFA0A1A3, 0xFF9FA1A2, 0xFF9F9FA2, 
        0xFF9E9FA2, 0xFF9D9EA1, 0xFF9D9EA1, 0xFF9C9DA0, 0xFF9C9D9F, 0xFF9A9B9F, 0xFF9A9A9E, 0xFF999A9D, 0xFF999A9D, 0xFF98999D, 0xFF98999C, 0xFF97989C, 0xFF96989B, 0xFF96979A, 0xFF95969A, 0xFF949598, 0xFF939498, 0xFF929397, 0xFF929397, 0xFF939498, 
        0xFF96979B, 0xFF9C9DA0, 0xFF97989C, 0xFF838587, 0xFA686A6C, 0xA2464748, 0x2D151616, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x00D6D7D8, 0x00D2D3D4, 0x00D1D2D2, 0x00CFD0D0, 0x00C8CACA, 0x00C3C5C6, 0x00C5C6C6, 0x00C1C2C3, 0x00BDBEBF, 0x00BBBDBE, 0x00B6B8B8, 0x00B6B7B8, 0x00B4B6B7, 0x00B1B3B4, 0x00AFB0B1, 0x00ACAEAF, 
        0x00AAABAC, 0x0DA9AAAC, 0x7AA6A8A9, 0xEBAAACAE, 0xFFBBBCBE, 0xFFC9CACC, 0xFFC9C9CB, 0xFFBFBFC2, 0xFFB9B9BC, 0xFFB7B8BA, 0xFFB7B8B9, 0xFFB6B8B9, 0xFFB6B7B9, 0xFFB6B7B9, 0xFFB6B6B9, 0xFFB5B5B8, 0xFFB4B5B8, 0xFFB4B5B8, 0xFFB3B4B7, 0xFFB3B3B6, 
        0xFFB3B3B5, 0xFFB3B3B5, 0xFFB2B2B5, 0xFFB1B2B5, 0xFFB1B2B4, 0xFFB1B2B4, 0xFFB0B1B4, 0xFFB0B0B3, 0xFFB0B0B3, 0xFFAFAFB2, 0xFFAEAFB1, 0xFFADAEB1, 0xFFADADB1, 0xFFACADB0, 0xFFACACAF, 0xFFACACAF, 0xFFABABAE, 0xFFAAABAD, 0xFFA9ABAD, 0xFFA9AAAD, 
        0xFFA9AAAC, 0xFFA9A9AB, 0xFFA8A8AB, 0xFFA7A8AB, 0xFFA6A8AA, 0xFFA6A7AA, 0xFFA5A6A9, 0xFFA5A5A9, 0xFFA4A5A7, 0xFFA3A4A7, 0xFFA3A3A7, 0xFFA2A3A6, 0xFFA1A2A6, 0xFFA1A2A6, 0xFFA1A2A5, 0xFFA0A1A5, 0xFFA0A0A4, 0xFF9FA0A2, 0xFF9F9FA2, 0xFF9D9EA2, 
        0xFF9D9EA1, 0xFF9C9DA0, 0xFF9C9D9F, 0xFF9A9C9F, 0xFF9A9B9F, 0xFF9A9A9D, 0xFF999A9D, 0xFF99999C, 0xFF98999C, 0xFF98989C, 0xFF97979B, 0xFF96979B, 0xFF96969A, 0xFF959699, 0xFF949598, 0xFF939497, 0xFF929497, 0xFF929397, 0xFF919296, 0xFF919295, 
        0xFF909195, 0xFF909195, 0xFF949599, 0xFF999A9E, 0xFF949699, 0xFF828486, 0xEE666869, 0x863D3E3F, 0x19101011, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x00D6D7D8, 0x00D2D3D4, 0x00D1D2D2, 0x00CFD0D0, 0x00C8CACA, 0x00C3C5C6, 0x00C5C6C6, 0x00C1C2C3, 0x00BDBEBF, 0x00BBBDBE, 0x00B6B8B8, 0x00B6B7B8, 0x00B4B6B7, 0x00B1B3B4, 0x00AFB0B1, 0x00ACADAF, 
        0x53AAABAC, 0xD2ACAEAF, 0xFFB8BABB, 0xFFC8C9CB, 0xFFCACACC, 0xFFC0C1C3, 0xFFB9BABC, 0xFFB8B8BA, 0xFFB7B8BA, 0xFFB7B8BA, 0xFFB7B8BA, 0xFFB7B7B9, 0xFFB6B6B9, 0xFFB6B6B8, 0xFFB5B5B7, 0xFFB3B5B7, 0xFFB3B5B7, 0xFFB3B4B7, 0xFFB3B3B6, 0xFFB3B3B6, 
        0xFFB2B3B5, 0xFFB2B3B5, 0xFFB2B2B5, 0xFFB1B2B4, 0xFFB1B1B4, 0xFFB0B1B3, 0xFFAFB1B3, 0xFFAFAFB2, 0xFFAFAEB2, 0xFFADAEB1, 0xFFADAEB0, 0xFFADADB0, 0xFFACACB0, 0xFFABACAF, 0xFFABABAF, 0xFFABABAE, 0xFFAAABAD, 0xFFAAABAD, 0xFFAAAAAD, 0xFFA9AAAD, 
        0xFFA9A9AC, 0xFFA8A8AB, 0xFFA7A7AA, 0xFFA6A7A9, 0xFFA5A6A9, 0xFFA5A6A8, 0xFFA4A5A8, 0xFFA4A5A8, 0xFFA3A4A7, 0xFFA3A3A7, 0xFFA2A3A6, 0xFFA2A2A6, 0xFFA1A2A5, 0xFFA0A2A4, 0xFF9FA1A4, 0xFF9F9FA3, 0xFF9E9FA3, 0xFF9E9EA2, 0xFF9E9EA1, 0xFF9D9DA1, 
        0xFF9D9DA0, 0xFF9C9DA0, 0xFF9B9C9F, 0xFF9A9C9F, 0xFF9A9B9E, 0xFF999A9D, 0xFF999A9D, 0xFF98989C, 0xFF97989B, 0xFF96979B, 0xFF96979A, 0xFF959699, 0xFF949699, 0xFF949598, 0xFF949598, 0xFF929397, 0xFF919397, 0xFF929296, 0xFF919296, 0xFF8F9195, 
        0xFF8F9095, 0xFF8E8F93, 0xFF8E8F93, 0xFF8F9093, 0xFF929497, 0xFF97989D, 0xFF919295, 0xFF7D7E80, 0xD9616263, 0x61323233, 0x04020202, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x00D6D7D8, 0x00D2D3D4, 0x00D1D2D2, 0x00CFD0D0, 0x00C8CACA, 0x00C3C5C6, 0x00C5C6C6, 0x00C1C2C3, 0x00BDBEBF, 0x00BBBDBE, 0x00B6B8B8, 0x00B6B7B8, 0x00B4B6B7, 0x00B1B3B4, 0x22AFB0B1, 0xA6ADAEB0, 
        0xFFB5B7B8, 0xFFC6C7C9, 0xFFCBCCCE, 0xFFC2C3C4, 0xFFBABBBD, 0xFFB8B8BB, 0xFFB7B8BA, 0xFFB8B8BA, 0xFFB7B8BA, 0xFFB7B8BA, 0xFFB6B7B9, 0xFFB5B5B8, 0xFFB5B5B8, 0xFFB5B5B8, 0xFFB4B5B7, 0xFFB4B5B7, 0xFFB4B5B6, 0xFFB3B3B6, 0xFFB2B3B6, 0xFFB1B2B6, 
        0xFFB2B2B5, 0xFFB1B2B5, 0xFFB1B1B4, 0xFFB0B1B4, 0xFFB0B1B3, 0xFFAFB0B3, 0xFFAEAFB2, 0xFFAEAEB1, 0xFFADAEB0, 0xFFADADB0, 0xFFACADB0, 0xFFACADB0, 0xFFACACAF, 0xFFABACAF, 0xFFABABAE, 0xFFAAABAE, 0xFFAAAAAD, 0xFFA9AAAD, 0xFFA8A9AC, 0xFFA8A8AC, 
        0xFFA7A8AB, 0xFFA7A7AA, 0xFFA6A6A9, 0xFFA6A6A9, 0xFFA5A6A8, 0xFFA5A6A8, 0xFFA4A5A8, 0xFFA3A5A8, 0xFFA3A4A7, 0xFFA1A3A6, 0xFFA2A2A6, 0xFFA1A1A5, 0xFFA0A1A5, 0xFF9FA0A4, 0xFF9EA0A3, 0xFF9D9FA2, 0xFF9D9EA2, 0xFF9D9EA1, 0xFF9D9DA1, 0xFF9C9CA0, 
        0xFF9C9CA0, 0xFF9B9C9F, 0xFF9B9B9F, 0xFF9A9B9E, 0xFF999A9D, 0xFF98999D, 0xFF97999C, 0xFF97989B, 0xFF96979B, 0xFF96969A, 0xFF96969A, 0xFF959598, 0xFF949598, 0xFF939498, 0xFF929497, 0xFF929396, 0xFF919296, 0xFF919195, 0xFF8F9194, 0xFF8F9095, 
        0xFF8F9094, 0xFF8F9094, 0xFF8E8F93, 0xFF8D8E92, 0xFF8C8E92, 0xFF8E8E93, 0xFF929397, 0xFF959599, 0xFF8B8C8F, 0xFF797B7C, 0xB1545556, 0x2F181818, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x00D6D7D8, 0x00D2D3D4, 0x00D1D2D2, 0x00CFD0D0, 0x00C8CACA, 0x00C3C5C6, 0x00C5C6C6, 0x00C1C2C3, 0x00BDBEBF, 0x00BBBDBE, 0x00B6B8B8, 0x00B6B7B8, 0x00B3B5B6, 0x65B1B3B4, 0xE5B4B5B6, 0xFFC2C3C4, 
        0xFFCCCDCE, 0xFFC6C6C9, 0xFFBCBDBF, 0xFFB8B9BB, 0xFFB7B8BB, 0xFFB7B7BA, 0xFFB7B7BA, 0xFFB6B7B9, 0xFFB6B7B9, 0xFFB6B6B9, 0xFFB5B6B8, 0xFFB5B6B8, 0xFFB5B6B8, 0xFFB5B5B7, 0xFFB4B5B7, 0xFFB4B4B7, 0xFFB3B4B6, 0xFFB2B3B5, 0xFFB1B2B6, 0xFFB1B1B5, 
        0xFFB1B1B5, 0xFFB0B1B4, 0xFFB0B0B3, 0xFFAFB0B2, 0xFFAFB0B2, 0xFFAEAFB2, 0xFFADAFB1, 0xFFADAEB1, 0xFFADADB0, 0xFFADADB0, 0xFFACADAF, 0xFFABACAF, 0xFFABACAF, 0xFFAAABAE, 0xFFAAAAAD, 0xFFA9A9AD, 0xFFA9A9AC, 0xFFA8A8AB, 0xFFA7A8AB, 0xFFA7A8AA, 
        0xFFA6A8AA, 0xFFA6A7AA, 0xFFA6A6A9, 0xFFA4A6A9, 0xFFA5A5A8, 0xFFA3A4A8, 0xFFA3A4A7, 0xFFA2A4A6, 0xFFA1A3A6, 0xFFA1A2A5, 0xFFA0A1A5, 0xFFA0A0A4, 0xFF9FA0A4, 0xFF9F9FA4, 0xFF9E9FA2, 0xFF9D9FA2, 0xFF9D9EA2, 0xFF9C9EA1, 0xFF9C9DA0, 0xFF9B9CA0, 
        0xFF9A9B9F, 0xFF9A9A9E, 0xFF9A9B9E, 0xFF99999D, 0xFF98999C, 0xFF97999C, 0xFF97989B, 0xFF96979A, 0xFF96979A, 0xFF959699, 0xFF949599, 0xFF949498, 0xFF939497, 0xFF939497, 0xFF929397, 0xFF919396, 0xFF919296, 0xFF909195, 0xFF909195, 0xFF8F9194, 
        0xFF8F9093, 0xFF8E8F92, 0xFF8E8F92, 0xFF8D8D92, 0xFF8C8D91, 0xFF8B8C90, 0xFF8A8C8F, 0xFF8C8D91, 0xFF919296, 0xFF909295, 0xFF86878A, 0xEA707172, 0x743E3E3F, 0x0A030303, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x00D6D7D8, 0x00D2D3D4, 0x00D1D2D2, 0x00CFD0D0, 0x00C8CACA, 0x00C3C5C6, 0x00C5C6C6, 0x00C1C2C3, 0x00BDBEBF, 0x00BBBDBE, 0x00B6B8B8, 0x1DB6B7B8, 0xA9B4B6B7, 0xFFBDBFC0, 0xFFCACCCD, 0xFFCACBCD, 
        0xFFBFBFC1, 0xFFB9B9BC, 0xFFB7B8BB, 0xFFB7B8BA, 0xFFB7B7BA, 0xFFB7B7BA, 0xFFB7B7BA, 0xFFB6B7B9, 0xFFB6B6B9, 0xFFB6B6B8, 0xFFB5B6B8, 0xFFB5B6B8, 0xFFB4B5B7, 0xFFB3B4B6, 0xFFB3B4B6, 0xFFB2B3B5, 0xFFB2B3B5, 0xFFB1B2B5, 0xFFB0B1B5, 0xFFB0B0B4, 
        0xFFB0B0B4, 0xFFB0B0B3, 0xFFAFAFB2, 0xFFAFB0B2, 0xFFAEAFB1, 0xFFAEAFB1, 0xFFAEAFB1, 0xFFADAEB1, 0xFFACADB0, 0xFFACADB0, 0xFFABACAE, 0xFFABABAD, 0xFFAAABAD, 0xFFA9AAAD, 0xFFA8A9AD, 0xFFA8A8AC, 0xFFA8A8AC, 0xFFA7A8AB, 0xFFA8A8AA, 0xFFA6A7AA, 
        0xFFA6A7AA, 0xFFA5A6A9, 0xFFA5A6A9, 0xFFA4A5A8, 0xFFA3A4A6, 0xFFA3A4A6, 0xFFA2A3A6, 0xFFA1A2A5, 0xFFA1A2A5, 0xFFA0A1A4, 0xFF9FA0A4, 0xFF9FA0A4, 0xFF9F9FA3, 0xFF9F9FA2, 0xFF9E9EA2, 0xFF9D9DA2, 0xFF9C9DA1, 0xFF9B9DA0, 0xFF9A9C9E, 0xFF9B9B9F, 
        0xFF999A9E, 0xFF999A9E, 0xFF99999D, 0xFF98989D, 0xFF98989C, 0xFF97979B, 0xFF97979B, 0xFF95969A, 0xFF949699, 0xFF949599, 0xFF949498, 0xFF939498, 0xFF939497, 0xFF929397, 0xFF929297, 0xFF919296, 0xFF909295, 0xFF909194, 0xFF909094, 0xFF8E9093, 
        0xFF8D8E93, 0xFF8C8D92, 0xFF8D8D91, 0xFF8C8D91, 0xFF8C8C91, 0xFF8A8C90, 0xFF8A8B8F, 0xFF898A8F, 0xFF898A8F, 0xFF8C8D91, 0xFF8F9095, 0xFF8B8C90, 0xFF828385, 0xB65E5F5F, 0x2D181818, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x00D6D7D8, 0x00D2D3D4, 0x00D1D2D2, 0x00CFD0D0, 0x00C8CACA, 0x00C3C5C6, 0x00C5C6C6, 0x00C1C2C3, 0x00BDBEBF, 0x00BBBCBD, 0x4CB6B8B9, 0xDCBABCBC, 0xFFC5C6C7, 0xFFCDCED0, 0xFFC4C5C7, 0xFFBBBCBE, 
        0xFFB7B8BA, 0xFFB7B8BA, 0xFFB7B8BA, 0xFFB7B8BA, 0xFFB7B7BA, 0xFFB6B7BA, 0xFFB6B7B9, 0xFFB6B6B9, 0xFFB6B6B8, 0xFFB5B5B8, 0xFFB4B5B8, 0xFFB4B4B7, 0xFFB4B4B6, 0xFFB2B3B5, 0xFFB2B3B5, 0xFFB1B3B5, 0xFFB1B1B4, 0xFFB0B1B5, 0xFFB0B1B4, 0xFFB0B0B4, 
        0xFFAFB0B3, 0xFFAFB0B3, 0xFFAFAFB2, 0xFFAFAEB2, 0xFFAEAFB1, 0xFFADAEB1, 0xFFADADB0, 0xFFACADAF, 0xFFABACAF, 0xFFABABAE, 0xFFAAABAD, 0xFFAAABAD, 0xFFA9AAAD, 0xFFA8AAAD, 0xFFA8A9AC, 0xFFA8A9AC, 0xFFA7A8AB, 0xFFA7A8AB, 0xFFA6A7AA, 0xFFA6A6AA, 
        0xFFA5A6A9, 0xFFA4A5A9, 0xFFA4A5A8, 0xFFA3A4A7, 0xFFA3A4A6, 0xFFA2A3A6, 0xFFA1A3A6, 0xFFA1A2A5, 0xFFA1A1A4, 0xFF9FA1A4, 0xFF9FA0A3, 0xFF9E9FA3, 0xFF9E9FA2, 0xFF9D9EA2, 0xFF9D9DA1, 0xFF9C9DA1, 0xFF9B9CA0, 0xFF9A9B9F, 0xFF9A9B9F, 0xFF9A9A9F, 
        0xFF999A9E, 0xFF989A9D, 0xFF97999C, 0xFF96989C, 0xFF97989B, 0xFF96979B, 0xFF95969A, 0xFF94969A, 0xFF949599, 0xFF949599, 0xFF939498, 0xFF939497, 0xFF929397, 0xFF919297, 0xFF909296, 0xFF909195, 0xFF909194, 0xFF8F9093, 0xFF8E8F93, 0xFF8D8F93, 
        0xFF8D8E92, 0xFF8C8E91, 0xFF8C8D91, 0xFF8B8C90, 0xFF8B8C90, 0xFF8A8A8F, 0xFF898A8E, 0xFF888A8E, 0xFF88898D, 0xFF87888D, 0xFF87898E, 0xFF8C8D91, 0xFF8B8D91, 0xFF8A8B8D, 0xE4777879, 0x60363737, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x00D6D7D8, 0x00D2D3D4, 0x00D1D2D2, 0x00CFD0D0, 0x00C8CACA, 0x00C3C5C6, 0x00C5C6C6, 0x00C1C2C3, 0x02BDBEBF, 0x84BCBDBE, 0xFFBFC1C2, 0xFFCACCCD, 0xFFC9CBCC, 0xFFBFBFC1, 0xFFB9BABC, 0xFFB8B8BA, 
        0xFFB8B8BA, 0xFFB8B8BA, 0xFFB7B8BA, 0xFFB7B8BA, 0xFFB6B7BA, 0xFFB5B6B9, 0xFFB5B6B9, 0xFFB5B5B8, 0xFFB4B5B8, 0xFFB4B4B7, 0xFFB3B4B7, 0xFFB2B4B6, 0xFFB2B3B6, 0xFFB2B2B5, 0xFFB2B2B5, 0xFFB1B2B4, 0xFFB1B1B4, 0xFFB0B1B4, 0xFFB0B1B4, 0xFFAFB0B3, 
        0xFFAFB0B3, 0xFFAEAFB2, 0xFFAEAEB2, 0xFFADAEB1, 0xFFADADB0, 0xFFADADAF, 0xFFACACAF, 0xFFABACAE, 0xFFAAABAE, 0xFFAAABAE, 0xFFAAABAE, 0xFFAAAAAD, 0xFFA9A9AD, 0xFFA8A9AB, 0xFFA7A8AB, 0xFFA7A8AB, 0xFFA7A6AA, 0xFFA6A6AA, 0xFFA5A6A9, 0xFFA4A5A9, 
        0xFFA4A5A8, 0xFFA4A5A8, 0xFFA3A4A7, 0xFFA3A3A6, 0xFFA2A3A6, 0xFFA2A3A6, 0xFFA0A2A5, 0xFFA0A1A4, 0xFF9FA0A3, 0xFF9E9FA2, 0xFF9E9FA2, 0xFF9D9EA1, 0xFF9D9EA1, 0xFF9C9DA1, 0xFF9C9DA0, 0xFF9B9DA0, 0xFF9B9B9F, 0xFF9A9B9E, 0xFF999A9F, 0xFF999A9E, 
        0xFF99999D, 0xFF98989C, 0xFF97989C, 0xFF97989C, 0xFF96979B, 0xFF95969B, 0xFF95969A, 0xFF94969A, 0xFF949599, 0xFF939498, 0xFF929497, 0xFF919397, 0xFF919296, 0xFF919295, 0xFF909195, 0xFF909194, 0xFF8F9094, 0xFF8E8F93, 0xFF8E8F93, 0xFF8D8F93, 
        0xFF8D8E91, 0xFF8C8D91, 0xFF8A8C90, 0xFF8A8B8F, 0xFF8A8B8F, 0xFF89898E, 0xFF88898E, 0xFF88898E, 0xFF88888D, 0xFF87888C, 0xFF86878C, 0xFF85868B, 0xFF888A8E, 0xFF8B8C91, 0xFF8A8B8E, 0xFF898A8B, 0x95525353, 0x14090909, 0x00000000, 0x01000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x00D6D7D8, 0x00D2D3D4, 0x00D1D2D2, 0x00CFD0D0, 0x00C8CACA, 0x00C3C5C6, 0x00C5C6C6, 0x1BC1C2C3, 0xB2C0C1C1, 0xFFC6C7C8, 0xFFCDCED0, 0xFFC6C7C9, 0xFFBCBDBF, 0xFFB8B9BB, 0xFFB8B8BA, 0xFFB8B8BB, 
        0xFFB8B8BA, 0xFFB7B8BA, 0xFFB6B7BA, 0xFFB6B7B9, 0xFFB5B6B9, 0xFFB5B5B9, 0xFFB4B5B9, 0xFFB4B5B8, 0xFFB4B4B7, 0xFFB3B4B6, 0xFFB3B4B6, 0xFFB2B3B6, 0xFFB2B3B6, 0xFFB2B2B5, 0xFFB1B2B5, 0xFFB1B2B4, 0xFFB0B1B4, 0xFFAFB1B4, 0xFFAFB0B3, 0xFFAFAFB3, 
        0xFFADAFB2, 0xFFAEAEB2, 0xFFADADB1, 0xFFADADB0, 0xFFACADB0, 0xFFABADB0, 0xFFACACB0, 0xFFABACAF, 0xFFAAABAE, 0xFFAAABAE, 0xFFA9AAAD, 0xFFA9A9AD, 0xFFA8A8AC, 0xFFA8A9AB, 0xFFA6A8AB, 0xFFA6A7AA, 0xFFA6A7AA, 0xFFA5A6AA, 0xFFA5A6A9, 0xFFA4A5A8, 
        0xFFA3A4A8, 0xFFA3A4A7, 0xFFA2A3A7, 0xFFA2A2A6, 0xFFA1A2A5, 0xFFA0A2A4, 0xFFA0A1A4, 0xFF9FA0A3, 0xFF9FA0A3, 0xFF9E9FA3, 0xFF9D9FA2, 0xFF9D9EA1, 0xFF9D9DA1, 0xFF9C9DA1, 0xFF9B9DA0, 0xFF9A9CA0, 0xFF9A9C9F, 0xFF9A9A9F, 0xFF999A9E, 0xFF98999D, 
        0xFF98999D, 0xFF98989C, 0xFF97989C, 0xFF96979C, 0xFF96979B, 0xFF95979A, 0xFF959699, 0xFF939599, 0xFF939399, 0xFF929398, 0xFF919397, 0xFF919296, 0xFF919196, 0xFF909195, 0xFF909095, 0xFF8F9095, 0xFF8F9094, 0xFF8E8F93, 0xFF8E8E93, 0xFF8C8E92, 
        0xFF8C8D91, 0xFF8B8C90, 0xFF8A8B90, 0xFF898B8F, 0xFF898A8E, 0xFF898A8E, 0xFF888A8E, 0xFF88898D, 0xFF87888D, 0xFF86888C, 0xFF86878C, 0xFF84868B, 0xFF84858A, 0xFF85888C, 0xFF88898E, 0xFF8A8A8F, 0xFF8E8F91, 0xC06E6F6F, 0x2F19191A, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x00D6D7D8, 0x00D2D3D4, 0x00D1D2D2, 0x00CFD0D0, 0x00C8CACA, 0x00C3C5C6, 0x38C4C5C6, 0xD7C5C6C7, 0xFFCBCCCE, 0xFFCCCDCF, 0xFFC2C3C5, 0xFFBABBBD, 0xFFB8B9BB, 0xFFB8B9BB, 0xFFB7B8BA, 0xFFB7B8BA, 
        0xFFB7B8B9, 0xFFB6B7B9, 0xFFB5B7B9, 0xFFB4B5B8, 0xFFB4B5B9, 0xFFB5B5B8, 0xFFB4B4B8, 0xFFB3B4B7, 0xFFB4B4B7, 0xFFB3B4B7, 0xFFB3B3B6, 0xFFB2B3B6, 0xFFB2B3B5, 0xFFB1B2B5, 0xFFB0B2B4, 0xFFB0B1B4, 0xFFAFB0B4, 0xFFAEAFB3, 0xFFAEB0B2, 0xFFAEAFB2, 
        0xFFADAEB1, 0xFFADAEB1, 0xFFACADB0, 0xFFACADB0, 0xFFACACB0, 0xFFABACB0, 0xFFAAABAF, 0xFFAAAAAE, 0xFFA9AAAD, 0xFFA8AAAC, 0xFFA8A9AD, 0xFFA7A8AC, 0xFFA7A8AB, 0xFFA6A8AB, 0xFFA6A7AB, 0xFFA6A7AA, 0xFFA5A7AA, 0xFFA4A6A9, 0xFFA4A4A9, 0xFFA3A4A7, 
        0xFFA2A3A6, 0xFFA1A2A6, 0xFFA1A2A6, 0xFFA1A1A5, 0xFFA1A1A5, 0xFFA0A0A4, 0xFFA0A0A4, 0xFF9FA0A3, 0xFF9EA0A3, 0xFF9E9FA2, 0xFF9C9EA1, 0xFF9C9DA1, 0xFF9C9CA1, 0xFF9B9CA0, 0xFF9B9CA0, 0xFF9A9C9F, 0xFF999C9E, 0xFF999A9F, 0xFF989A9E, 0xFF98999D, 
        0xFF97999D, 0xFF97989C, 0xFF96979C, 0xFF96969B, 0xFF95969A, 0xFF949599, 0xFF939599, 0xFF939499, 0xFF929397, 0xFF919397, 0xFF919296, 0xFF909295, 0xFF909196, 0xFF909095, 0xFF8F9095, 0xFF8E8F94, 0xFF8E8E93, 0xFF8D8E92, 0xFF8C8D91, 0xFF8B8D91, 
        0xFF8A8C90, 0xFF8A8B90, 0xFF898B90, 0xFF898B8F, 0xFF888A8E, 0xFF888A8E, 0xFF87888D, 0xFF87878C, 0xFF86878B, 0xFF85878B, 0xFF85868B, 0xFF84868B, 0xFF84858A, 0xFF838589, 0xFF83858A, 0xFF85868C, 0xFF86878C, 0xFF8F9194, 0xE0838486, 0x512B2B2C, 
        0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x00D6D7D8, 0x00D2D3D4, 0x00D1D2D2, 0x00CFD0D0, 0x00C8C9CA, 0x52C4C6C7, 0xEFC9CACB, 0xFFCECFD1, 0xFFCBCBCD, 0xFFBEBFC1, 0xFFB9BABC, 0xFFB8B9BB, 0xFFB8B8BB, 0xFFB7B8BA, 0xFFB7B7BA, 0xFFB6B6B9, 
        0xFFB5B6B9, 0xFFB5B6B9, 0xFFB5B6B9, 0xFFB4B5B9, 0xFFB4B5B8, 0xFFB4B5B8, 0xFFB4B4B7, 0xFFB3B4B6, 0xFFB3B4B6, 0xFFB2B3B6, 0xFFB2B3B5, 0xFFB1B2B4, 0xFFB1B1B4, 0xFFB0B1B4, 0xFFAFB1B3, 0xFFAFB0B3, 0xFFAEB0B3, 0xFFAEAFB2, 0xFFAEAFB2, 0xFFADAEB2, 
        0xFFADADB1, 0xFFACADB1, 0xFFABADB0, 0xFFAAACAF, 0xFFABABAE, 0xFFAAABAE, 0xFFAAABAD, 0xFFA9AAAD, 0xFFA8A9AD, 0xFFA8A9AC, 0xFFA7A8AC, 0xFFA7A8AB, 0xFFA7A8AA, 0xFFA6A7AA, 0xFFA6A7AA, 0xFFA4A6A9, 0xFFA4A5A9, 0xFFA3A4A8, 0xFFA2A3A8, 0xFFA2A3A7, 
        0xFFA2A3A6, 0xFFA1A2A6, 0xFFA0A2A6, 0xFFA0A1A5, 0xFFA0A0A5, 0xFF9FA0A3, 0xFF9FA0A3, 0xFF9EA0A2, 0xFF9D9FA2, 0xFF9D9EA2, 0xFF9C9EA1, 0xFF9C9DA1, 0xFF9B9CA0, 0xFF9B9C9F, 0xFF9B9C9F, 0xFF9A9B9F, 0xFF999A9D, 0xFF999A9D, 0xFF97999D, 0xFF96989C, 
        0xFF96989C, 0xFF96979B, 0xFF95979A, 0xFF95959A, 0xFF94959A, 0xFF939599, 0xFF939498, 0xFF929498, 0xFF929397, 0xFF919397, 0xFF909196, 0xFF8F9195, 0xFF8F9095, 0xFF8F9094, 0xFF8E8F94, 0xFF8E8E92, 0xFF8D8E92, 0xFF8C8D91, 0xFF8B8D91, 0xFF8B8D91, 
        0xFF8A8C90, 0xFF8A8B90, 0xFF898B8F, 0xFF898A8E, 0xFF888A8E, 0xFF87888D, 0xFF86878D, 0xFF86878D, 0xFF86878B, 0xFF85868B, 0xFF85868B, 0xFF84858B, 0xFF848489, 0xFF828489, 0xFF818388, 0xFF818388, 0xFF83858A, 0xFF85868B, 0xFF8D8E92, 0xF4909192, 
        0x6C414242, 0x07000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x00D6D7D8, 0x00D2D3D4, 0x00D1D2D2, 0x00CFD0D0, 0x6ECACBCC, 0xFBCDCECF, 0xFFCFD0D2, 0xFFC8C8CB, 0xFFBDBDBF, 0xFFB8B8BB, 0xFFB8B8BB, 0xFFB7B8BA, 0xFFB6B8BA, 0xFFB6B7BA, 0xFFB6B7BA, 0xFFB6B7BA, 
        0xFFB6B6BA, 0xFFB5B6B9, 0xFFB5B6B9, 0xFFB4B5B9, 0xFFB4B5B8, 0xFFB3B4B7, 0xFFB3B4B7, 0xFFB3B4B6, 0xFFB3B3B6, 0xFFB2B3B6, 0xFFB1B2B5, 0xFFB1B2B4, 0xFFB0B1B4, 0xFFB0B1B3, 0xFFB0B0B3, 0xFFAFB0B3, 0xFFAEB0B2, 0xFFAEAFB2, 0xFFADAEB1, 0xFFADAEB1, 
        0xFFACADB1, 0xFFACACB0, 0xFFABACAF, 0xFFABACAF, 0xFFABABAE, 0xFFAAABAE, 0xFFAAABAD, 0xFFA9AAAD, 0xFFA8AAAD, 0xFFA8A9AC, 0xFFA7A8AB, 0xFFA7A8AA, 0xFFA6A7AA, 0xFFA6A6AA, 0xFFA5A6A9, 0xFFA3A5A9, 0xFFA3A5A8, 0xFFA3A4A8, 0xFFA3A4A7, 0xFFA2A3A7, 
        0xFFA2A3A6, 0xFFA1A2A6, 0xFFA0A1A5, 0xFFA0A1A4, 0xFF9FA0A4, 0xFF9FA0A3, 0xFF9F9FA3, 0xFF9E9FA3, 0xFF9E9EA2, 0xFF9E9EA2, 0xFF9D9EA1, 0xFF9C9DA1, 0xFF9B9DA0, 0xFF9B9CA0, 0xFF9A9B9F, 0xFF999B9F, 0xFF99999E, 0xFF98989D, 0xFF97999D, 0xFF97989C, 
        0xFF96989C, 0xFF95979B, 0xFF95979A, 0xFF94959A, 0xFF94959A, 0xFF949499, 0xFF939398, 0xFF929397, 0xFF919297, 0xFF909196, 0xFF909296, 0xFF8F9195, 0xFF8F9095, 0xFF8E9094, 0xFF8D8F93, 0xFF8D8E92, 0xFF8D8D92, 0xFF8C8D92, 0xFF8B8C91, 0xFF8B8B91, 
        0xFF8B8C90, 0xFF8A8B8F, 0xFF898A8F, 0xFF898A8E, 0xFF88898E, 0xFF87888D, 0xFF87888D, 0xFF86888D, 0xFF85878C, 0xFF85868B, 0xFF84858B, 0xFF83848A, 0xFF838489, 0xFF838489, 0xFF828388, 0xFF828387, 0xFF818287, 0xFF828488, 0xFF82848A, 0xFF898B8F, 
        0xFE98999B, 0x87535455, 0x0F000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x00D6D7D8, 0x00D2D3D4, 0x00D0D1D1, 0x86D0D1D1, 0xFFD1D2D3, 0xFFD0D1D2, 0xFFC5C6C8, 0xFFBBBCBF, 0xFFB8B9BB, 0xFFB8B9BB, 0xFFB8B8BB, 0xFFB7B8BA, 0xFFB7B8BB, 0xFFB7B8BA, 0xFFB6B7BA, 0xFFB6B7B9, 
        0xFFB6B6B9, 0xFFB5B6B9, 0xFFB4B5B8, 0xFFB4B4B8, 0xFFB4B4B7, 0xFFB3B4B7, 0xFFB3B4B7, 0xFFB3B3B6, 0xFFB2B3B5, 0xFFB2B2B5, 0xFFB1B2B5, 0xFFB1B2B4, 0xFFB0B2B4, 0xFFB0B1B3, 0xFFAFB0B3, 0xFFAEAFB3, 0xFFADAEB2, 0xFFADAEB1, 0xFFADAEB1, 0xFFACAEB0, 
        0xFFACADB0, 0xFFABACAF, 0xFFABACAF, 0xFFAAABAF, 0xFFAAAAAE, 0xFFAAAAAE, 0xFFA9AAAD, 0xFFA9AAAC, 0xFFA8A9AB, 0xFFA7A9AB, 0xFFA7A7AB, 0xFFA6A7AB, 0xFFA6A6AB, 0xFFA5A6AA, 0xFFA4A6A9, 0xFFA4A5A9, 0xFFA4A5A8, 0xFFA3A4A8, 0xFFA2A3A7, 0xFFA2A3A6, 
        0xFFA1A2A5, 0xFFA1A2A5, 0xFFA0A1A5, 0xFFA0A1A4, 0xFF9FA0A4, 0xFF9FA0A4, 0xFF9E9FA3, 0xFF9E9FA3, 0xFF9E9EA3, 0xFF9D9DA1, 0xFF9C9DA0, 0xFF9B9CA0, 0xFF9B9C9F, 0xFF9A9B9F, 0xFF999A9E, 0xFF989A9E, 0xFF98999E, 0xFF98999C, 0xFF97989C, 0xFF97989C, 
        0xFF96979C, 0xFF95979B, 0xFF94969A, 0xFF949699, 0xFF939499, 0xFF929498, 0xFF929398, 0xFF929298, 0xFF919297, 0xFF909296, 0xFF909196, 0xFF909195, 0xFF8F9195, 0xFF8E8F94, 0xFF8D8F93, 0xFF8D8E92, 0xFF8C8D92, 0xFF8B8D92, 0xFF8B8D90, 0xFF8B8C90, 
        0xFF8A8C8F, 0xFF8A8A8F, 0xFF898A8F, 0xFF888A8E, 0xFF87898E, 0xFF87888D, 0xFF87888D, 0xFF86878B, 0xFF85878B, 0xFF85868B, 0xFF84858B, 0xFF83858A, 0xFF838489, 0xFF838489, 0xFF828389, 0xFF828288, 0xFF818188, 0xFF808187, 0xFF808288, 0xFF818389, 
        0xFF888A8F, 0xFF9FA0A2, 0x9E616262, 0x15010101, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x00D6D7D7, 0x00D2D3D4, 0x91D2D3D3, 0xFFD3D5D5, 0xFFCFD0D2, 0xFFC4C5C6, 0xFFBBBBBE, 0xFFB8B9BC, 0xFFB8B9BC, 0xFFB8B9BB, 0xFFB8B9BC, 0xFFB7B8BB, 0xFFB7B8BB, 0xFFB6B7BA, 0xFFB5B6B9, 0xFFB4B6B8, 
        0xFFB4B6B8, 0xFFB4B6B8, 0xFFB4B5B8, 0xFFB4B4B8, 0xFFB3B4B7, 0xFFB3B4B7, 0xFFB3B3B7, 0xFFB2B2B6, 0xFFB2B2B5, 0xFFB2B1B4, 0xFFB1B1B4, 0xFFB0B1B4, 0xFFAFB0B3, 0xFFAEB0B3, 0xFFAEAFB2, 0xFFAEAFB2, 0xFFADAFB2, 0xFFADAEB1, 0xFFADADB1, 0xFFACADB1, 
        0xFFACADB0, 0xFFABACAF, 0xFFAAABAF, 0xFFAAABAF, 0xFFAAAAAE, 0xFFA9AAAD, 0xFFA9A9AC, 0xFFA8A9AC, 0xFFA7A9AC, 0xFFA7A8AB, 0xFFA6A7AB, 0xFFA6A7AA, 0xFFA5A6A9, 0xFFA5A6A9, 0xFFA4A5A9, 0xFFA3A4A8, 0xFFA3A4A7, 0xFFA2A3A8, 0xFFA2A4A7, 0xFFA2A3A7, 
        0xFFA2A2A6, 0xFFA1A2A6, 0xFFA0A1A5, 0xFFA0A1A5, 0xFF9FA0A4, 0xFF9FA0A4, 0xFF9E9FA3, 0xFF9D9FA2, 0xFF9C9EA1, 0xFF9C9DA1, 0xFF9C9DA0, 0xFF9B9CA0, 0xFF9A9B9F, 0xFF9A9B9E, 0xFF999A9E, 0xFF999A9E, 0xFF97999D, 0xFF98999D, 0xFF97979C, 0xFF97979C, 
        0xFF96979B, 0xFF95969B, 0xFF94969A, 0xFF939599, 0xFF939499, 0xFF929498, 0xFF929397, 0xFF929397, 0xFF919297, 0xFF909296, 0xFF8F9096, 0xFF8F9195, 0xFF8E8F94, 0xFF8D8F94, 0xFF8D8F93, 0xFF8D8E93, 0xFF8C8E92, 0xFF8C8D92, 0xFF8B8D90, 0xFF8B8C90, 
        0xFF8A8B8F, 0xFF898A90, 0xFF898A8F, 0xFF888A8E, 0xFF87898E, 0xFF87888D, 0xFF87878D, 0xFF85878C, 0xFF85878C, 0xFF85868C, 0xFF84868B, 0xFF84858B, 0xFF83858A, 0xFF82848A, 0xFF828389, 0xFF818389, 0xFF818288, 0xFF818287, 0xFF7F8187, 0xFF818288, 
        0xFF818288, 0xFF85868B, 0xFFA2A4A6, 0xA96A6A6B, 0x1B050506, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DADBDB, 0x04D6D7D7, 0x9AD6D7D8, 0xFFD5D6D7, 0xFFCECFD1, 0xFFC2C3C5, 0xFFBABBBE, 0xFFB9B9BC, 0xFFB9B9BC, 0xFFB8B9BC, 0xFFB8B9BB, 0xFFB7B8BA, 0xFFB6B7BA, 0xFFB6B7BA, 0xFFB6B7B9, 0xFFB5B6B9, 0xFFB5B6B8, 
        0xFFB5B5B8, 0xFFB4B5B8, 0xFFB4B5B7, 0xFFB3B4B7, 0xFFB3B4B7, 0xFFB2B4B5, 0xFFB2B3B6, 0xFFB1B2B5, 0xFFB1B2B5, 0xFFB0B1B5, 0xFFB0B1B4, 0xFFAFB0B3, 0xFFAFB0B3, 0xFFAFB0B3, 0xFFAEAFB1, 0xFFAEAFB1, 0xFFAEAFB1, 0xFFADAEB1, 0xFFACADB1, 0xFFACACB0, 
        0xFFABABB0, 0xFFABABAF, 0xFFAAABAE, 0xFFAAABAE, 0xFFA9ABAE, 0xFFA9AAAD, 0xFFA8A9AC, 0xFFA8A9AC, 0xFFA7A9AC, 0xFFA6A7AB, 0xFFA6A7AA, 0xFFA6A7AA, 0xFFA5A6A9, 0xFFA4A5A9, 0xFFA4A5A9, 0xFFA3A5A8, 0xFFA3A4A7, 0xFFA3A4A7, 0xFFA2A4A7, 0xFFA2A3A6, 
        0xFFA1A2A6, 0xFFA0A2A5, 0xFFA0A1A5, 0xFF9FA0A4, 0xFF9EA0A4, 0xFF9E9FA2, 0xFF9D9EA2, 0xFF9D9EA2, 0xFF9C9DA1, 0xFF9C9CA1, 0xFF9C9CA0, 0xFF9A9CA0, 0xFF9A9C9F, 0xFF9A9B9E, 0xFF999A9E, 0xFF98999E, 0xFF97989D, 0xFF96989D, 0xFF96989C, 0xFF96979B, 
        0xFF95969B, 0xFF95969B, 0xFF94959A, 0xFF939599, 0xFF939598, 0xFF929498, 0xFF929298, 0xFF919297, 0xFF909295, 0xFF909195, 0xFF8F9095, 0xFF8F9094, 0xFF8E8F94, 0xFF8E8F94, 0xFF8D8F93, 0xFF8D8E92, 0xFF8C8E92, 0xFF8C8D92, 0xFF8B8B92, 0xFF8A8B91, 
        0xFF898A90, 0xFF898B90, 0xFF888A90, 0xFF88898F, 0xFF88888F, 0xFF87888E, 0xFF86888E, 0xFF86888D, 0xFF86878D, 0xFF85878C, 0xFF85868C, 0xFF84868A, 0xFF84858A, 0xFF83858A, 0xFF828489, 0xFF828489, 0xFF828388, 0xFF818288, 0xFF818288, 0xFF808187, 
        0xFF818287, 0xFF818287, 0xFF83848A, 0xFFA4A5A7, 0xB2727375, 0x20090909, 0x04000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x02D9DADB, 0x9EDADBDB, 0xFFD8D9DA, 0xFFCECFD1, 0xFFC1C2C5, 0xFFBABBBE, 0xFFB8B9BC, 0xFFB8B9BC, 0xFFB8B8BB, 0xFFB7B8BA, 0xFFB7B8BA, 0xFFB7B8BA, 0xFFB6B7BA, 0xFFB6B7B9, 0xFFB6B7B9, 0xFFB6B6B9, 0xFFB4B6B9, 
        0xFFB5B5B8, 0xFFB4B5B8, 0xFFB3B4B7, 0xFFB3B4B7, 0xFFB3B3B6, 0xFFB2B3B6, 0xFFB2B2B5, 0xFFB1B2B5, 0xFFB0B2B5, 0xFFB0B1B4, 0xFFAFB1B3, 0xFFB0B1B3, 0xFFAFB0B3, 0xFFAFB0B2, 0xFFAEAFB2, 0xFFAEAEB1, 0xFFACADB1, 0xFFABADB0, 0xFFABADB0, 0xFFABACAF, 
        0xFFABABAF, 0xFFABABAF, 0xFFAAAAAE, 0xFFA9AAAE, 0xFFA8A9AD, 0xFFA8A9AD, 0xFFA8A8AC, 0xFFA8A8AB, 0xFFA7A7AB, 0xFFA7A7AB, 0xFFA6A7AA, 0xFFA5A7AA, 0xFFA5A6AA, 0xFFA4A6A9, 0xFFA4A5A9, 0xFFA4A5A8, 0xFFA3A4A8, 0xFFA3A4A7, 0xFFA2A3A6, 0xFFA1A2A6, 
        0xFFA1A2A6, 0xFFA0A1A5, 0xFF9FA0A4, 0xFF9EA0A3, 0xFF9E9FA3, 0xFF9D9EA2, 0xFF9D9EA2, 0xFF9C9DA1, 0xFF9C9DA0, 0xFF9C9DA0, 0xFF9B9CA0, 0xFF9A9C9F, 0xFF999B9F, 0xFF999A9F, 0xFF989A9E, 0xFF98999E, 0xFF98999D, 0xFF97989C, 0xFF96989C, 0xFF95979C, 
        0xFF95969B, 0xFF95969A, 0xFF949599, 0xFF939499, 0xFF929398, 0xFF929398, 0xFF929297, 0xFF909297, 0xFF909196, 0xFF8F9196, 0xFF8F9095, 0xFF8E9095, 0xFF8E9095, 0xFF8E8F94, 0xFF8D8E93, 0xFF8C8D92, 0xFF8C8D93, 0xFF8B8D92, 0xFF8A8C92, 0xFF8A8C92, 
        0xFF898B91, 0xFF898B90, 0xFF898B90, 0xFF88898F, 0xFF88898F, 0xFF87898E, 0xFF87888E, 0xFF87888D, 0xFF86888C, 0xFF86878C, 0xFF85878B, 0xFF85868B, 0xFF84858B, 0xFF84858A, 0xFF838589, 0xFF828489, 0xFF828389, 0xFF828388, 0xFF818388, 0xFF818388, 
        0xFF808286, 0xFF808287, 0xFF818288, 0xFF838489, 0xFFA6A7AA, 0xB677787A, 0x21070707, 0x05000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DDDEDE, 0x00DDDEDE, 0x00DDDEDE, 0x00DDDEDE, 0x00DDDEDE, 0x00DDDEDE, 0x00DDDEDE, 0x00DDDEDE, 0x00DDDEDE, 0x00DDDEDE, 0x00DDDEDE, 0x00DDDEDE, 0x00DDDEDE, 0x00DDDEDE, 0x00DDDEDE, 0x00DDDEDE, 0x00DDDEDE, 0x00DDDEDE, 0x00DDDEDE, 0x00DDDEDE, 0x00DDDDDD, 
        0x00DCDDDD, 0x00DCDDDD, 0x00DCDDDD, 0x95DDDEDE, 0xFFDADBDC, 0xFFCECFD1, 0xFFC1C2C4, 0xFFB9BABD, 0xFFB8B9BC, 0xFFB8B9BC, 0xFFB8B9BC, 0xFFB7B8BB, 0xFFB7B8BB, 0xFFB7B8BB, 0xFFB7B7BA, 0xFFB6B7BA, 0xFFB6B6BA, 0xFFB5B6B9, 0xFFB5B6B9, 0xFFB4B6B8, 
        0xFFB3B5B8, 0xFFB4B5B7, 0xFFB3B3B7, 0xFFB2B3B7, 0xFFB2B3B6, 0xFFB2B3B6, 0xFFB2B1B6, 0xFFB1B1B5, 0xFFB1B1B4, 0xFFB0B1B3, 0xFFAFB1B3, 0xFFAFB0B3, 0xFFAFAFB2, 0xFFAEAFB2, 0xFFADAEB2, 0xFFADAEB1, 0xFFACAEB1, 0xFFACADB1, 0xFFACACB0, 0xFFABACAF, 
        0xFFABABAF, 0xFFA9ABAF, 0xFFA9AAAE, 0xFFA8AAAD, 0xFFA8A9AC, 0xFFA8A9AC, 0xFFA8A9AC, 0xFFA7A8AC, 0xFFA6A7AC, 0xFFA6A7AB, 0xFFA6A7AA, 0xFFA5A6AA, 0xFFA5A6A9, 0xFFA4A6A9, 0xFFA4A4A8, 0xFFA3A4A8, 0xFFA2A4A8, 0xFFA2A3A6, 0xFFA2A2A6, 0xFFA2A2A6, 
        0xFFA0A2A6, 0xFFA1A1A5, 0xFF9FA1A5, 0xFF9FA1A5, 0xFF9FA0A4, 0xFF9F9FA4, 0xFF9E9FA3, 0xFF9D9EA2, 0xFF9D9EA1, 0xFF9C9DA1, 0xFF9B9CA1, 0xFF9A9CA0, 0xFF9A9BA0, 0xFF999B9F, 0xFF999A9E, 0xFF98999E, 0xFF97989E, 0xFF97989D, 0xFF95979C, 0xFF95979B, 
        0xFF95969B, 0xFF94959A, 0xFF94959A, 0xFF93949A, 0xFF939399, 0xFF919398, 0xFF919398, 0xFF909298, 0xFF909197, 0xFF909197, 0xFF8F9196, 0xFF8E9195, 0xFF8E8F95, 0xFF8D8F94, 0xFF8D8F94, 0xFF8C8E93, 0xFF8C8E93, 0xFF8B8E93, 0xFF8B8D91, 0xFF8B8C91, 
        0xFF8A8C91, 0xFF898B90, 0xFF898B8F, 0xFF898A8F, 0xFF88898F, 0xFF87898F, 0xFF87898E, 0xFF87898D, 0xFF86888C, 0xFF86878C, 0xFF85878C, 0xFF85868B, 0xFF85868B, 0xFF84858A, 0xFF838589, 0xFF828489, 0xFF828489, 0xFF828489, 0xFF828488, 0xFF818388, 
        0xFF818288, 0xFF818288, 0xFF818287, 0xFF808287, 0xFF818388, 0xFFA9ABAD, 0xB0747476, 0x1F030303, 0x06000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEBEB, 0x00E4E5E5, 
        0x00E1E1E2, 0x00E2E2E2, 0x8CE2E2E2, 0xFFDDDDDF, 0xFFCECFD2, 0xFFC0C2C4, 0xFFB9BBBE, 0xFFB8B9BC, 0xFFB8BABC, 0xFFB8B9BC, 0xFFB8B9BC, 0xFFB7B8BB, 0xFFB7B8BB, 0xFFB7B8BB, 0xFFB6B7BA, 0xFFB6B7BA, 0xFFB5B6BA, 0xFFB4B6B9, 0xFFB4B5B9, 0xFFB4B4B8, 
        0xFFB3B4B8, 0xFFB3B4B7, 0xFFB3B3B7, 0xFFB2B3B6, 0xFFB1B3B6, 0xFFB1B2B6, 0xFFB0B2B5, 0xFFB0B1B5, 0xFFB0B1B4, 0xFFB0B0B4, 0xFFAFB0B3, 0xFFAFB0B3, 0xFFAEAFB3, 0xFFAEAFB2, 0xFFADAEB2, 0xFFADAEB1, 0xFFACADB1, 0xFFACACB0, 0xFFABACB0, 0xFFAAABAF, 
        0xFFAAABAF, 0xFFA9ABAE, 0xFFA9AAAE, 0xFFA9AAAE, 0xFFA9A9AD, 0xFFA8A9AD, 0xFFA7A8AD, 0xFFA7A8AC, 0xFFA6A7AC, 0xFFA6A7AB, 0xFFA6A6AB, 0xFFA5A6AA, 0xFFA5A6AA, 0xFFA4A6AA, 0xFFA4A5A9, 0xFFA4A5A9, 0xFFA3A4A8, 0xFFA1A3A7, 0xFF9FA1A5, 0xFF9E9FA4, 
        0xFF9D9EA3, 0xFF9A9CA0, 0xFF989A9F, 0xFF97989D, 0xFF96989C, 0xFF96979C, 0xFF96979D, 0xFF96989D, 0xFF98999E, 0xFF98999F, 0xFF999A9F, 0xFF999A9F, 0xFF999B9F, 0xFF9A9BA0, 0xFF999AA0, 0xFF989A9F, 0xFF98999F, 0xFF96999D, 0xFF96989C, 0xFF96979B, 
        0xFF95979B, 0xFF94969B, 0xFF94959A, 0xFF949599, 0xFF939499, 0xFF929498, 0xFF919298, 0xFF919397, 0xFF919296, 0xFF919296, 0xFF909296, 0xFF8F9195, 0xFF8F9095, 0xFF8E9095, 0xFF8E9094, 0xFF8D8F94, 0xFF8D8E92, 0xFF8D8D92, 0xFF8C8D91, 0xFF8A8C90, 
        0xFF8A8C90, 0xFF8A8B90, 0xFF898B90, 0xFF898B90, 0xFF898A8F, 0xFF88898F, 0xFF88898E, 0xFF87898E, 0xFF86888D, 0xFF86888C, 0xFF86878B, 0xFF85868B, 0xFF84868B, 0xFF84868B, 0xFF84858A, 0xFF84858A, 0xFF83848A, 0xFF838489, 0xFF828489, 0xFF818388, 
        0xFF818388, 0xFF818287, 0xFF808187, 0xFF808287, 0xFF7F8187, 0xFF818388, 0xFFAEAFB1, 0xAA6F6F70, 0x1D000000, 0x06000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBECEC, 0x00E5E5E5, 
        0x00E1E1E1, 0x7CE4E5E4, 0xFFE1E1E2, 0xFFCFD0D3, 0xFFC2C2C6, 0xFFBABBBE, 0xFFB9BABE, 0xFFB9B9BD, 0xFFB8BABD, 0xFFB8B9BC, 0xFFB8B9BC, 0xFFB7B8BC, 0xFFB7B8BB, 0xFFB7B7BB, 0xFFB6B7BA, 0xFFB5B7BA, 0xFFB5B6BA, 0xFFB5B6B9, 0xFFB4B6B9, 0xFFB3B5B8, 
        0xFFB3B4B8, 0xFFB3B4B8, 0xFFB2B3B7, 0xFFB2B3B7, 0xFFB2B2B6, 0xFFB1B2B6, 0xFFB0B2B6, 0xFFB0B1B5, 0xFFB0B1B5, 0xFFAFB1B4, 0xFFAFB1B4, 0xFFAFB0B4, 0xFFAEAFB3, 0xFFAEAFB2, 0xFFADAEB2, 0xFFACADB2, 0xFFACADB1, 0xFFABACB1, 0xFFABACB1, 0xFFAAACB0, 
        0xFFAAACB0, 0xFFAAACAF, 0xFFA9AAAF, 0xFFA9AAAF, 0xFFA8AAAE, 0xFFA8A9AD, 0xFFA7A8AD, 0xFFA7A8AC, 0xFFA7A8AC, 0xFFA6A8AC, 0xFFA6A8AC, 0xFFA5A7AB, 0xFFA3A4A8, 0xFFA0A1A5, 0xFF9A9CA0, 0xFF94969A, 0xFF8E9094, 0xFF87898E, 0xFF828489, 0xFF7E8086, 
        0xFF7B7D83, 0xFF787A80, 0xFF78797E, 0xFF75777C, 0xFF76787D, 0xFF76787D, 0xFF75777D, 0xFF76787E, 0xFF777A7F, 0xFF797B80, 0xFF7C7D82, 0xFF7E7F84, 0xFF818488, 0xFF888A8E, 0xFF8C8F93, 0xFF909397, 0xFF95979A, 0xFF96999C, 0xFF98999D, 0xFF97999C, 
        0xFF96989C, 0xFF95979B, 0xFF94969A, 0xFF949599, 0xFF929599, 0xFF929598, 0xFF929497, 0xFF929397, 0xFF919396, 0xFF919396, 0xFF909296, 0xFF8F9196, 0xFF8F9195, 0xFF8F9094, 0xFF8E9093, 0xFF8C8F93, 0xFF8D8F92, 0xFF8C8E92, 0xFF8B8D92, 0xFF8B8D91, 
        0xFF8B8D91, 0xFF8A8C91, 0xFF898C90, 0xFF898B8F, 0xFF898A8E, 0xFF87898E, 0xFF87898E, 0xFF87898D, 0xFF87898D, 0xFF86888C, 0xFF85888C, 0xFF85878C, 0xFF84878B, 0xFF85878C, 0xFF84868B, 0xFF83858B, 0xFF83858A, 0xFF828589, 0xFF828588, 0xFF828488, 
        0xFF818388, 0xFF818287, 0xFF818287, 0xFF808287, 0xFF818387, 0xFF7F8185, 0xFF818488, 0xFFB1B2B5, 0x9E666668, 0x18000000, 0x06000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBECEC, 0x00E4E5E5, 
        0x5EE4E4E4, 0xFEE5E6E7, 0xFFD2D3D6, 0xFFC2C4C7, 0xFFBABCBF, 0xFFB9BABE, 0xFFB9BABE, 0xFFB8BABD, 0xFFB8B9BD, 0xFFB8B9BC, 0xFFB7B9BC, 0xFFB7B9BC, 0xFFB6B8BB, 0xFFB6B8BB, 0xFFB6B7BA, 0xFFB5B7BA, 0xFFB5B7B9, 0xFFB4B6B9, 0xFFB3B6B9, 0xFFB3B5B8, 
        0xFFB3B5B8, 0xFFB3B5B8, 0xFFB2B4B7, 0xFFB2B4B7, 0xFFB2B3B7, 0xFFB1B3B6, 0xFFB1B3B6, 0xFFB1B2B5, 0xFFB0B2B5, 0xFFAFB1B4, 0xFFAFB1B4, 0xFFAEB0B4, 0xFFAEAFB3, 0xFFADAFB2, 0xFFACAFB2, 0xFFACAEB2, 0xFFACAEB1, 0xFFACAEB1, 0xFFABAEB1, 0xFFABADB0, 
        0xFFAAACB0, 0xFFAAACB0, 0xFFA9ABAF, 0xFFA9ABAE, 0xFFA8AAAE, 0xFFA8AAAE, 0xFFA8AAAE, 0xFFA7A9AD, 0xFFA5A7AB, 0xFFA0A3A6, 0xFF999B9F, 0xFF8F9195, 0xFF85878B, 0xFF7C7F84, 0xFF77797E, 0xFF74767C, 0xFF73757C, 0xFF76787F, 0xFF76787E, 0xFF717279, 
        0xFF6E6F76, 0xFF6C6E75, 0xFE6C6D74, 0xFE6B6D74, 0xFD6B6D74, 0xFD6B6D74, 0xFE6B6D74, 0xFE6C6D74, 0xFF6C6E75, 0xFF6E7077, 0xFF71737A, 0xFF75777E, 0xFF75777D, 0xFF72747A, 0xFF717379, 0xFF72747A, 0xFF76787E, 0xFF7C7E83, 0xFF84868B, 0xFF8C8E93, 
        0xFF929398, 0xFF94969B, 0xFF95979B, 0xFF95969B, 0xFF939599, 0xFF939599, 0xFF929498, 0xFF929398, 0xFF909397, 0xFF909397, 0xFF909296, 0xFF8F9196, 0xFF8F9195, 0xFF8E9095, 0xFF8D9094, 0xFF8C8F94, 0xFF8C8F94, 0xFF8C8F94, 0xFF8C8E92, 0xFF8B8D92, 
        0xFF8A8D92, 0xFF898C91, 0xFF898B90, 0xFF898B90, 0xFF888B90, 0xFF888B8F, 0xFF888B8F, 0xFF878A8E, 0xFF87898E, 0xFF87898E, 0xFF86888D, 0xFF86888D, 0xFF85888C, 0xFF85878C, 0xFF84878C, 0xFF84878B, 0xFF83868B, 0xFF83868A, 0xFF828589, 0xFF828589, 
        0xFF81848A, 0xFF818489, 0xFF818389, 0xFF818388, 0xFF808287, 0xFF808288, 0xFF7D7F85, 0xFF85878C, 0xFFB6B7BA, 0x86535455, 0x14000000, 0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x45E8E9E9, 
        0xF5E8E8E8, 0xFFD5D6D9, 0xFFC4C6C9, 0xFFBBBDC0, 0xFFBABBBE, 0xFFBABBBE, 0xFFB9BABE, 0xFFB9BABE, 0xFFB9BABD, 0xFFB8B9BD, 0xFFB7B9BD, 0xFFB7B9BC, 0xFFB6B8BB, 0xFFB6B8BB, 0xFFB5B8BA, 0xFFB5B7BA, 0xFFB5B7BA, 0xFFB5B6B9, 0xFFB5B5B9, 0xFFB4B5B9, 
        0xFFB4B5B8, 0xFFB3B4B8, 0xFFB2B4B8, 0xFFB2B4B7, 0xFFB2B3B7, 0xFFB2B3B6, 0xFFB1B3B6, 0xFFB1B2B5, 0xFFB0B1B5, 0xFFB0B1B5, 0xFFAFB1B4, 0xFFAFB1B4, 0xFFAEB0B3, 0xFFADB0B3, 0xFFADB0B2, 0xFFADAFB2, 0xFFADAEB2, 0xFFACAEB2, 0xFFABADB1, 0xFFABADB0, 
        0xFFAAACB0, 0xFFAAACAF, 0xFFAAABAF, 0xFFAAABAF, 0xFFA9ABAF, 0xFFA7A8AC, 0xFFA0A1A6, 0xFF95979C, 0xFF888A8F, 0xFF7C7E84, 0xFF76787F, 0xFF75777E, 0xFF787981, 0xFF72737A, 0xFD6E6F76, 0xF4626369, 0xEA515157, 0xE1424246, 0xD936363A, 0xD22B2B2E, 
        0xCB242426, 0xC41A1A1C, 0xC0141416, 0xBF151517, 0xB90B0B0C, 0xB90B0B0C, 0xBD151516, 0xBC141415, 0xC11A1A1C, 0xC7242426, 0xCC2C2C2F, 0xD537363A, 0xDE424247, 0xE8525358, 0xF363646A, 0xFD6F7077, 0xFF72747B, 0xFF76787F, 0xFF72747C, 0xFF71727A, 
        0xFF75767C, 0xFF7D7F84, 0xFF87898E, 0xFF8F9196, 0xFF929499, 0xFF93959A, 0xFF929499, 0xFF919498, 0xFF909398, 0xFF909397, 0xFF909296, 0xFF8F9196, 0xFF8F9196, 0xFF8E9095, 0xFF8E8F95, 0xFF8D8F95, 0xFF8D8E94, 0xFF8C8E93, 0xFF8C8E92, 0xFF8B8D92, 
        0xFF8B8D92, 0xFF8A8C92, 0xFF8A8C91, 0xFF898C91, 0xFF8A8C90, 0xFF898B90, 0xFF888B90, 0xFF888A90, 0xFF87898F, 0xFF87888F, 0xFF86888E, 0xFF86888E, 0xFF86888D, 0xFF85878D, 0xFF85878C, 0xFF85878C, 0xFF84858B, 0xFF83858B, 0xFF82858B, 0xFF82858A, 
        0xFF82848A, 0xFF828489, 0xFF828389, 0xFF818389, 0xFF808389, 0xFF808389, 0xFF81838A, 0xFF7D7F85, 0xFF8C8F93, 0xFBB6B6BA, 0x72404041, 0x10000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EFEFEF, 0x00ECECEC, 0x27ECECEC, 0xE8EDEDED, 
        0xFFD8D9DB, 0xFFC5C7C9, 0xFFBDBEC1, 0xFFBABBBF, 0xFFBABBBF, 0xFFBABBBE, 0xFFB9BBBE, 0xFFB9BABE, 0xFFB9BABD, 0xFFB8BABC, 0xFFB8B9BC, 0xFFB8B9BB, 0xFFB7B8BB, 0xFFB7B8BB, 0xFFB6B8BA, 0xFFB6B7BA, 0xFFB6B7BA, 0xFFB5B6B9, 0xFFB5B6B8, 0xFFB4B6B9, 
        0xFFB4B5B8, 0xFFB4B5B8, 0xFFB4B4B7, 0xFFB2B4B7, 0xFFB2B3B6, 0xFFB2B2B6, 0xFFB1B2B6, 0xFFB1B2B5, 0xFFB1B2B5, 0xFFB0B1B5, 0xFFB0B1B4, 0xFFB0B1B4, 0xFFAFB0B3, 0xFFAEB0B3, 0xFFAEAFB2, 0xFFADAEB2, 0xFFADAEB1, 0xFFACAEB1, 0xFFACADB0, 0xFFABADB0, 
        0xFFABACB0, 0xFFABACB0, 0xFFA9ABAE, 0xFFA4A6A9, 0xFF989A9E, 0xFF898B8F, 0xFF7C7D83, 0xFF77787E, 0xFF797B82, 0xFF76787E, 0xF96B6D73, 0xEA54555A, 0xDD3B3B3F, 0xCE242527, 0xBF0D0D0E, 0xB6040404, 0xAD000000, 0xA6000000, 0x9F000000, 0x9A000000, 
        0x94000000, 0x90000000, 0x8C000000, 0x88000000, 0x86000000, 0x84000000, 0x84000000, 0x84000000, 0x85000000, 0x87000000, 0x8A000000, 0x8E000000, 0x93000000, 0x9C000000, 0xA5040404, 0xB00D0D0E, 0xC2252528, 0xD53B3C40, 0xE656565C, 0xF96D6E75, 
        0xFF77787F, 0xFF777980, 0xFF72747A, 0xFF73757A, 0xFF7B7E83, 0xFF878A8E, 0xFF909296, 0xFF929498, 0xFF929499, 0xFF919398, 0xFF909297, 0xFF8F9196, 0xFF8F9296, 0xFF8E9195, 0xFF8E9095, 0xFF8E9094, 0xFF8E9093, 0xFF8D8F93, 0xFF8D8E93, 0xFF8C8E93, 
        0xFF8C8E93, 0xFF8C8E92, 0xFF8B8D92, 0xFF8A8C91, 0xFF8A8C90, 0xFF898B90, 0xFF898B90, 0xFF888A8F, 0xFF888A8F, 0xFF888A8F, 0xFF88898F, 0xFF87898E, 0xFF87898E, 0xFF86888D, 0xFF85878D, 0xFF85878C, 0xFF84878C, 0xFF84868C, 0xFF84868C, 0xFF84868B, 
        0xFF83868A, 0xFF83858A, 0xFF83858A, 0xFF82858A, 0xFF82858A, 0xFF818489, 0xFF818388, 0xFF818389, 0xFF7C7E84, 0xFF94969A, 0xF1B1B1B4, 0x58262627, 0x0D000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F2F2, 0x0DEDEEEE, 0xC8EFF0F0, 0xFFE0E0E2, 
        0xFFC7C9CC, 0xFFBEC0C3, 0xFFBBBCBF, 0xFFBABCBF, 0xFFBABBBE, 0xFFB9BBBE, 0xFFB9BBBD, 0xFFB9BABD, 0xFFB8BABD, 0xFFB8BABC, 0xFFB8B9BC, 0xFFB7B9BC, 0xFFB7B9BB, 0xFFB7B8BB, 0xFFB6B8BB, 0xFFB6B7BA, 0xFFB6B7BA, 0xFFB5B6B9, 0xFFB5B6B8, 0xFFB4B6B8, 
        0xFFB4B5B8, 0xFFB3B5B8, 0xFFB3B4B7, 0xFFB3B4B7, 0xFFB2B3B7, 0xFFB1B3B7, 0xFFB1B3B6, 0xFFB1B3B5, 0xFFB0B2B5, 0xFFB0B2B5, 0xFFB0B1B4, 0xFFAFB1B4, 0xFFAEB0B3, 0xFFAEB0B3, 0xFFAEAFB2, 0xFFADAFB1, 0xFFADAEB1, 0xFFACAEB1, 0xFFADAEB1, 0xFFABADB1, 
        0xFFAAABAF, 0xFFA1A3A6, 0xFF919397, 0xFF818287, 0xFF787A80, 0xFF7A7C83, 0xFF777980, 0xF467686F, 0xE2444549, 0xCE262729, 0xBD080809, 0xB1000000, 0xA7000000, 0x9E000000, 0x94000000, 0x8A000000, 0x7E000000, 0x73000000, 0x68000000, 0x5F000000, 
        0x57000000, 0x50000000, 0x4A000000, 0x46000000, 0x43000000, 0x41000000, 0x41000000, 0x41000000, 0x43000000, 0x46000000, 0x4A000000, 0x50000000, 0x57000000, 0x5F000000, 0x67000000, 0x72000000, 0x7B000000, 0x86000000, 0x94000000, 0xA5080909, 
        0xBE272729, 0xD946474B, 0xF36A6B71, 0xFF797B82, 0xFF7A7C82, 0xFF72747A, 0xFF75777C, 0xFF818488, 0xFF8D8F94, 0xFF919397, 0xFF929498, 0xFF909297, 0xFF909297, 0xFF909296, 0xFF8F9195, 0xFF8F9195, 0xFF8E9095, 0xFF8E9095, 0xFF8D9094, 0xFF8D8F94, 
        0xFF8C8F93, 0xFF8C8E92, 0xFF8B8D92, 0xFF8B8D91, 0xFF8B8D91, 0xFF8A8D91, 0xFF8A8C90, 0xFF898C90, 0xFF898B90, 0xFF888B8F, 0xFF888A8F, 0xFF878A8E, 0xFF87898E, 0xFF86898D, 0xFF86898D, 0xFF86898D, 0xFF86888D, 0xFF85888D, 0xFF85888C, 0xFF85878C, 
        0xFF84878C, 0xFF84868B, 0xFF83868B, 0xFF83868A, 0xFF83868A, 0xFF82858A, 0xFF82858A, 0xFF82848A, 0xFF828589, 0xFF7B7E83, 0xFFA3A4A8, 0xDCA1A1A4, 0x3D101010, 0x0C000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00E7E7E8, 0x00E7E7E8, 0x00E7E7E8, 0x00E7E7E8, 0x00E7E7E8, 0x00E7E7E8, 0x00E7E7E8, 0x00E7E7E8, 0x00E7E7E8, 0x00E7E7E8, 0x00E7E7E8, 0x00E7E7E8, 0x00E7E7E8, 0x00E7E7E8, 0x00E7E7E8, 0x00E7E7E8, 0x00E7E7E8, 0x00F0F0F0, 0x9CF3F3F4, 0xFFE6E6E7, 0xFFCBCCCE, 
        0xFFC0C1C4, 0xFFBABCBF, 0xFFBABCBF, 0xFFBABBBE, 0xFFBABBBE, 0xFFB9BBBD, 0xFFB9BABD, 0xFFB9B9BD, 0xFFB9B9BD, 0xFFB9B9BC, 0xFFB8B9BC, 0xFFB7B9BC, 0xFFB7B8BB, 0xFFB7B8BB, 0xFFB6B8BB, 0xFFB6B7BA, 0xFFB6B7BA, 0xFFB5B6B9, 0xFFB5B6B9, 0xFFB4B6B9, 
        0xFFB4B5B8, 0xFFB3B5B8, 0xFFB3B4B8, 0xFFB3B4B7, 0xFFB2B3B7, 0xFFB2B3B6, 0xFFB1B2B6, 0xFFB1B2B5, 0xFFB0B2B4, 0xFFB0B1B3, 0xFFAFB1B4, 0xFFAEB1B3, 0xFFAFB0B3, 0xFFAEAFB3, 0xFFADAFB2, 0xFFACAFB2, 0xFFACAEB2, 0xFFADAEB1, 0xFFAAACAF, 0xFFA0A2A5, 
        0xFF8D8F94, 0xFF7C7E82, 0xFF797B82, 0xFF7E7F87, 0xF86F7178, 0xE34A4B50, 0xCC222325, 0xBA040404, 0xAD000000, 0xA3000000, 0x96000000, 0x87000000, 0x76000000, 0x65000000, 0x55000000, 0x47000000, 0x3A000000, 0x31000000, 0x28000000, 0x21000000, 
        0x1C000000, 0x18000000, 0x15000000, 0x13000000, 0x11000000, 0x10000000, 0x0F000000, 0x10000000, 0x11000000, 0x13000000, 0x15000000, 0x18000000, 0x1C000000, 0x21000000, 0x28000000, 0x31000000, 0x3A000000, 0x47000000, 0x55000000, 0x64000000, 
        0x73000000, 0x84000000, 0x9A040405, 0xB7232426, 0xDA4C4D52, 0xF873747B, 0xFF808188, 0xFF76787F, 0xFF72757A, 0xFF7E8085, 0xFF8B8E92, 0xFF919397, 0xFF919398, 0xFF909296, 0xFF8F9196, 0xFF8F9196, 0xFF8E9095, 0xFF8E9095, 0xFF8D8F93, 0xFF8C8F93, 
        0xFF8C8E93, 0xFF8B8E93, 0xFF8B8E92, 0xFF8C8E92, 0xFF8B8D92, 0xFF8A8D92, 0xFF8A8C91, 0xFF898C91, 0xFF898B90, 0xFF898B8F, 0xFF898B8F, 0xFF888A8F, 0xFF88898F, 0xFF87898F, 0xFF87898E, 0xFF87898D, 0xFF86888D, 0xFF86888D, 0xFF85888D, 0xFF85878C, 
        0xFF85878C, 0xFF85878C, 0xFF85868B, 0xFF84868B, 0xFF83868A, 0xFF84868A, 0xFF83868A, 0xFF83858A, 0xFF82868A, 0xFF828489, 0xFF7D7F84, 0xFFB2B3B7, 0xBD818183, 0x2A010101, 0x0B000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DADADB, 0x00DADADB, 0x00DADADB, 0x00DADADB, 0x00DADADB, 0x00DADADB, 0x00DADADB, 0x00DADADB, 0x00DADADB, 0x00DADADB, 0x00DADADB, 0x00DADADB, 0x00DADADB, 0x00DADADB, 0x00DADADB, 0x00DADADB, 0x00DBDBDC, 0x69F2F2F3, 0xFFEFEFF0, 0xFFCFD0D3, 0xFFC1C3C5, 
        0xFFBBBDC0, 0xFFBABCBF, 0xFFBABCBF, 0xFFBABBBF, 0xFFBABBBE, 0xFFB9BBBE, 0xFFB9BBBE, 0xFFB9BABD, 0xFFB8BABD, 0xFFB8BABC, 0xFFB8B9BC, 0xFFB7B9BB, 0xFFB7B9BB, 0xFFB6B8BB, 0xFFB7B8BA, 0xFFB6B8BB, 0xFFB6B7BA, 0xFFB5B7BA, 0xFFB5B6B9, 0xFFB4B6B9, 
        0xFFB4B5B9, 0xFFB3B5B7, 0xFFB3B5B8, 0xFFB2B4B7, 0xFFB2B3B6, 0xFFB2B3B6, 0xFFB1B3B6, 0xFFB1B3B5, 0xFFB0B2B5, 0xFFB0B1B4, 0xFFAFB1B4, 0xFFAFB1B4, 0xFFAFB0B3, 0xFFAEAFB3, 0xFFADAFB3, 0xFFADAFB3, 0xFFACADB1, 0xFFA2A3A8, 0xFF8E9095, 0xFF7B7D82, 
        0xFF7B7D83, 0xFF7D7F86, 0xF066676D, 0xD6343437, 0xBF0A0B0B, 0xB0000000, 0xA4000000, 0x96000000, 0x83000000, 0x6E000000, 0x59000000, 0x45000000, 0x34000000, 0x26000000, 0x1C000000, 0x13000000, 0x0D000000, 0x09000000, 0x05000000, 0x03000000, 
        0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x03000000, 0x05000000, 0x09000000, 0x0D000000, 0x13000000, 0x1C000000, 0x26000000, 
        0x34000000, 0x45000000, 0x57000000, 0x6A000000, 0x7F000000, 0x9C0B0B0C, 0xC4353639, 0xEC696A6F, 0xFF808189, 0xFF7B7C83, 0xFF74767B, 0xFF7E8085, 0xFF8B8E93, 0xFF909398, 0xFF909397, 0xFF8F9196, 0xFF8F9196, 0xFF8E9195, 0xFF8D9095, 0xFF8D9095, 
        0xFF8D9094, 0xFF8D8F93, 0xFF8C8E93, 0xFF8C8E93, 0xFF8B8E93, 0xFF8B8D92, 0xFF8A8D92, 0xFF8A8D92, 0xFF898C91, 0xFF898C91, 0xFF898C91, 0xFF888B90, 0xFF888C90, 0xFF888A8F, 0xFF878A8F, 0xFF87898F, 0xFF868A8F, 0xFF878A8F, 0xFF87898E, 0xFF86898E, 
        0xFF85888D, 0xFF85888D, 0xFF85888C, 0xFF85888C, 0xFF85878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878B, 0xFF84878C, 0xFF828489, 0xFF82858A, 0xFFBEBFC2, 0x975D5D60, 0x1C000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00E5E6E6, 0x00E5E6E6, 0x00E5E6E6, 0x00E5E6E6, 0x00E5E6E6, 0x00E5E6E6, 0x00E5E6E6, 0x00E5E6E6, 0x00E5E6E6, 0x00E5E6E6, 0x00E5E6E6, 0x00E5E6E6, 0x00E5E6E6, 0x00E5E6E6, 0x00E5E6E6, 0x00E5E6E6, 0x2FEBEBEC, 0xF2F4F4F4, 0xFFD7D8DA, 0xFFC3C4C7, 0xFFBDBEC1, 
        0xFFBCBCC0, 0xFFBBBCC0, 0xFFBBBCBF, 0xFFBBBCBF, 0xFFBABCBE, 0xFFBABBBE, 0xFFBABBBD, 0xFFB9BBBD, 0xFFB9BABD, 0xFFB9BABD, 0xFFB8B9BC, 0xFFB8B9BC, 0xFFB8B9BB, 0xFFB7B8BB, 0xFFB7B8BB, 0xFFB6B8BB, 0xFFB6B7BA, 0xFFB5B7BA, 0xFFB5B6B9, 0xFFB4B5B8, 
        0xFFB4B5B9, 0xFFB3B5B8, 0xFFB3B4B7, 0xFFB3B4B7, 0xFFB2B3B6, 0xFFB2B3B6, 0xFFB2B3B6, 0xFFB1B3B5, 0xFFB1B2B5, 0xFFAFB1B5, 0xFFAFB1B4, 0xFFAEB0B3, 0xFFAEB0B3, 0xFFAEB0B3, 0xFFAEB0B3, 0xFFA7A8AC, 0xFF939599, 0xFF7E7F85, 0xFF7C7E85, 0xFF808189, 
        0xED606267, 0xD0292A2C, 0xB9020202, 0xAB000000, 0x9E000000, 0x89000000, 0x72000000, 0x59000000, 0x41000000, 0x2E000000, 0x1E000000, 0x13000000, 0x0A000000, 0x05000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x05000000, 
        0x0A000000, 0x13000000, 0x1E000000, 0x2D000000, 0x41000000, 0x57000000, 0x6D000000, 0x8A020202, 0xB62A2B2D, 0xE564656A, 0xFF85878E, 0xFF7C7E85, 0xFF74767B, 0xFF818388, 0xFF8E8F94, 0xFF919397, 0xFF909296, 0xFF8F9295, 0xFF8E9195, 0xFF8E9195, 
        0xFF8E9194, 0xFF8D9095, 0xFF8D9094, 0xFF8D8F94, 0xFF8D8F93, 0xFF8D8E93, 0xFF8B8D93, 0xFF8B8D92, 0xFF8B8D92, 0xFF8A8D91, 0xFF8A8C91, 0xFF898C91, 0xFF898C90, 0xFF888B90, 0xFF898B90, 0xFF898B90, 0xFF888B90, 0xFF888B8F, 0xFF888A8E, 0xFF878A8E, 
        0xFF86898E, 0xFF86898D, 0xFF86898D, 0xFF86888D, 0xFF86898D, 0xFF86888D, 0xFF86888D, 0xFF85888D, 0xFF85888D, 0xFF85888C, 0xFF85888C, 0xFF7F8288, 0xFF8F9196, 0xF8BBBBBF, 0x692D2E2F, 0x15000000, 0x06000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00F0F1F0, 0x00F0F1F0, 0x00F0F1F0, 0x00F0F1F0, 0x00F0F1F0, 0x00F0F1F0, 0x00F0F1F0, 0x00F0F1F0, 0x00F0F1F0, 0x00F0F1F0, 0x00F0F1F0, 0x00F0F1F0, 0x00F0F1F0, 0x00F0F1F0, 0x00F0F1F0, 0x0AF0F1F1, 0xC8FBFBFB, 0xFFE2E3E4, 0xFFC6C7CA, 0xFFBEC0C3, 0xFFBCBDC0, 
        0xFFBBBDC0, 0xFFBBBDBF, 0xFFBBBDBF, 0xFFBABCBF, 0xFFBABCBE, 0xFFBABBBE, 0xFFB9BBBD, 0xFFB9BABE, 0xFFB9BABD, 0xFFB8BBBD, 0xFFB8BABD, 0xFFB7BABC, 0xFFB7B9BC, 0xFFB6B8BB, 0xFFB6B8BB, 0xFFB5B7BA, 0xFFB5B7BA, 0xFFB5B6BA, 0xFFB4B6BA, 0xFFB3B5B8, 
        0xFFB3B5B8, 0xFFB3B5B8, 0xFFB3B5B7, 0xFFB3B4B7, 0xFFB2B4B7, 0xFFB2B3B6, 0xFFB1B3B6, 0xFFB0B2B5, 0xFFB0B2B5, 0xFFAFB1B4, 0xFFAFB1B4, 0xFFAFB1B4, 0xFFAFB1B4, 0xFFACADB0, 0xFF9C9EA2, 0xFF83858A, 0xFF7C7E85, 0xFF83858D, 0xEE65666C, 0xCF28292C, 
        0xB7000000, 0xAA000000, 0x9A000000, 0x81000000, 0x66000000, 0x4A000000, 0x31000000, 0x1F000000, 0x11000000, 0x08000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x03000000, 0x08000000, 0x11000000, 0x1F000000, 0x31000000, 0x49000000, 0x61000000, 0x80000000, 0xB029292C, 0xE76A6C72, 0xFF898A92, 0xFF7B7D83, 0xFF777A7F, 0xFF86898E, 0xFF909296, 0xFF909397, 0xFF909297, 0xFF8F9296, 
        0xFF8F9196, 0xFF8E9195, 0xFF8E9094, 0xFF8D8F94, 0xFF8D8F94, 0xFF8C8F93, 0xFF8C8E93, 0xFF8C8E92, 0xFF8C8E92, 0xFF8B8E92, 0xFF8B8E92, 0xFF8A8D92, 0xFF8A8D91, 0xFF8A8D91, 0xFF8A8C91, 0xFF8A8C90, 0xFF8A8B90, 0xFF898B8F, 0xFF888B8F, 0xFF888B8E, 
        0xFF888A8E, 0xFF888A8E, 0xFF888A8F, 0xFF87898E, 0xFF87898E, 0xFF87898E, 0xFF87898D, 0xFF87888E, 0xFF86898E, 0xFF86888D, 0xFF85888D, 0xFF86898D, 0xFF7D8085, 0xFFA6A8AC, 0xDEA3A5A8, 0x420B0B0C, 0x10000000, 0x03000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00F4F4F4, 0x00F4F4F4, 0x00F4F4F4, 0x00F4F4F4, 0x00F4F4F4, 0x00F4F4F4, 0x00F4F4F4, 0x00F4F4F4, 0x00F4F4F4, 0x00F4F4F4, 0x00F4F4F4, 0x00F4F4F4, 0x00F4F4F4, 0x00F4F4F4, 0x00F3F3F3, 0x89FBFBFB, 0xFFECEDEE, 0xFFCBCDCE, 0xFFC0C1C4, 0xFFBCBEC1, 0xFFBCBEC0, 
        0xFFBCBDC0, 0xFFBBBDC0, 0xFFBBBDBF, 0xFFBBBDBF, 0xFFBABCBF, 0xFFBBBCBF, 0xFFBABBBF, 0xFFB9BBBE, 0xFFB9BBBD, 0xFFB8BBBD, 0xFFB8BABD, 0xFFB7BABC, 0xFFB7B9BC, 0xFFB7B8BC, 0xFFB6B8BB, 0xFFB6B7BB, 0xFFB5B7BB, 0xFFB5B7BA, 0xFFB4B7BA, 0xFFB5B7B9, 
        0xFFB4B6B9, 0xFFB3B5B9, 0xFFB3B5B7, 0xFFB2B4B8, 0xFFB2B3B7, 0xFFB2B3B6, 0xFFB1B3B6, 0xFFB0B3B6, 0xFFB0B2B5, 0xFFB0B2B5, 0xFFB0B2B5, 0xFFAFB1B4, 0xFFA7A9AC, 0xFF8E9094, 0xFF7C7E84, 0xFF84868D, 0xF575767E, 0xD5333337, 0xB9000001, 0xAA000000, 
        0x99000000, 0x7F000000, 0x60000000, 0x42000000, 0x29000000, 0x17000000, 0x0A000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x0A000000, 0x16000000, 0x28000000, 0x41000000, 0x5B000000, 0x7E010101, 0xB937373A, 0xF17D7E84, 0xFF8B8D94, 0xFF777A7F, 0xFF7E8085, 0xFF8D9095, 0xFF919498, 0xFF909397, 
        0xFF8F9297, 0xFF8F9296, 0xFF8E9195, 0xFF8D9095, 0xFF8D9095, 0xFF8E9095, 0xFF8D9094, 0xFF8C9094, 0xFF8C8F94, 0xFF8C8F94, 0xFF8C8F93, 0xFF8C8E93, 0xFF8B8E92, 0xFF8B8E92, 0xFF8B8D92, 0xFF8B8D91, 0xFF8A8D91, 0xFF898D91, 0xFF898C91, 0xFF898C90, 
        0xFF888B90, 0xFF888C90, 0xFF888B90, 0xFF888B90, 0xFF888A8F, 0xFF878A90, 0xFF888A90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF898C91, 0xFF898C91, 0xFF86898E, 0xFF7D8086, 0xFFB6B7BB, 0xB4747477, 0x2A000000, 0x0B000000, 0x01000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F3F3F3, 0x00F2F2F2, 0x3EF8F8F8, 0xFAF7F8F8, 0xFFD3D5D6, 0xFFC3C4C6, 0xFFBDBFC1, 0xFFBDBEC0, 0xFFBDBEC1, 
        0xFFBCBEC1, 0xFFBCBEC0, 0xFFBBBDC0, 0xFFBBBDBF, 0xFFBBBCBF, 0xFFBBBCBF, 0xFFBABCBE, 0xFFBABCBE, 0xFFB9BBBE, 0xFFB9BABD, 0xFFB9BABD, 0xFFB8BABD, 0xFFB8B9BC, 0xFFB7B9BC, 0xFFB7B9BB, 0xFFB6B9BB, 0xFFB6B7BA, 0xFFB5B7BA, 0xFFB5B7B9, 0xFFB5B6B9, 
        0xFFB4B6B9, 0xFFB3B5B8, 0xFFB3B5B8, 0xFFB3B5B8, 0xFFB2B4B7, 0xFFB2B4B7, 0xFFB1B3B6, 0xFFB1B3B6, 0xFFB1B3B5, 0xFFB1B2B5, 0xFFAEAFB3, 0xFF9FA0A4, 0xFF83858A, 0xFF7F8188, 0xFE84868D, 0xE14D4E52, 0xBF0B0B0B, 0xAE000000, 0x9E000000, 0x82000000, 
        0x61000000, 0x41000000, 0x25000000, 0x13000000, 0x07000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x07000000, 0x13000000, 0x24000000, 0x3F000000, 0x5B000000, 0x880C0C0D, 0xCD535458, 0xFF8E8F96, 0xFF84858C, 0xFF787A80, 0xFF888B8F, 0xFF909397, 
        0xFF909397, 0xFF909396, 0xFF909296, 0xFF909296, 0xFF8F9296, 0xFF8F9195, 0xFF8E9195, 0xFF8D9195, 0xFF8D9194, 0xFF8D9094, 0xFF8D8F94, 0xFF8D8F93, 0xFF8D8F93, 0xFF8D8E93, 0xFF8C8E92, 0xFF8C8E92, 0xFF8B8E92, 0xFF8B8E92, 0xFF8A8D92, 0xFF8A8D91, 
        0xFF8A8D91, 0xFF8A8D91, 0xFF8A8D91, 0xFF8A8D92, 0xFF8A8D92, 0xFF8B8E93, 0xFF8B8E93, 0xFF898C90, 0xFF878A8F, 0xFF818489, 0xFF7B7D83, 0xFF74787C, 0xFF6F7277, 0xFF65686D, 0xFF6F7177, 0xFEBCBDC1, 0x7B38383A, 0x1B000000, 0x07000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00F0F0F0, 0x00F0F0F0, 0x00F0F0F0, 0x00F0F0F0, 0x00F0F0F0, 0x00F0F0F0, 0x00F0F0F0, 0x00F0F0F0, 0x00F0F0F0, 0x00F0F0F0, 0x00F0F0F0, 0x00F0F0F0, 0x00F0F0F0, 0x09F2F2F2, 0xCDFDFDFD, 0xFFE1E1E2, 0xFFC6C7C9, 0xFFBFC1C3, 0xFFBDBFC2, 0xFFBDBFC2, 0xFFBDBFC1, 
        0xFFBDBEC1, 0xFFBCBDC0, 0xFFBCBDC0, 0xFFBBBDBF, 0xFFBBBCBF, 0xFFBABCBE, 0xFFBABCBE, 0xFFBABBBE, 0xFFB9BBBE, 0xFFB9BBBD, 0xFFB8BBBD, 0xFFB8BABD, 0xFFB8BABC, 0xFFB7BABC, 0xFFB7B9BC, 0xFFB6B8BB, 0xFFB6B7BB, 0xFFB5B7BA, 0xFFB5B7BA, 0xFFB4B7BA, 
        0xFFB4B7BA, 0xFFB4B6B9, 0xFFB3B5B8, 0xFFB2B5B8, 0xFFB2B4B7, 0xFFB1B4B7, 0xFFB1B3B6, 0xFFB1B2B6, 0xFFB0B2B7, 0xFFABADB1, 0xFF96989D, 0xFF7C7E83, 0xFF85878E, 0xF2727379, 0xCC222325, 0xB3000000, 0xA5000000, 0x8A000000, 0x68000000, 0x44000000, 
        0x27000000, 0x12000000, 0x06000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x06000000, 0x12000000, 0x26000000, 0x42000000, 0x63000000, 0xA0252528, 0xEA7A7C82, 0xFF909399, 0xFF7B7E83, 0xFF82858A, 
        0xFF8F9397, 0xFF919498, 0xFF909397, 0xFF909397, 0xFF909297, 0xFF8F9397, 0xFF8F9296, 0xFF8F9296, 0xFF8F9296, 0xFF8E9195, 0xFF8E9195, 0xFF8D9094, 0xFF8D9094, 0xFF8D8F94, 0xFF8D8F94, 0xFF8C8F94, 0xFF8C8F94, 0xFF8B8F93, 0xFF8B8F93, 0xFF8C8F94, 
        0xFF8C9094, 0xFF8D9195, 0xFF8C8F94, 0xFF8A8D92, 0xFF85898E, 0xFF7F8287, 0xFF777B7F, 0xFF707479, 0xFF6A6E73, 0xFF676B70, 0xFF65696F, 0xFF64686E, 0xFF65696E, 0xFF666A6F, 0xFF5E6267, 0xFF8D9095, 0xE3A4A5A9, 0x490A0A0B, 0x13000000, 0x03000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x00EAEAEA, 0x7CFEFEFD, 0xFFF1F1F2, 0xFFCCCDCF, 0xFFC1C2C5, 0xFFBEBFC2, 0xFFBDBFC1, 0xFFBDBFC2, 0xFFBDBEC0, 
        0xFFBCBEC0, 0xFFBCBEC0, 0xFFBCBDC0, 0xFFBCBDBF, 0xFFBBBDBF, 0xFFBBBDBF, 0xFFBABCBE, 0xFFBABCBE, 0xFFBABCBE, 0xFFB9BBBD, 0xFFB9BABD, 0xFFB8BABD, 0xFFB8BABC, 0xFFB8BABC, 0xFFB7B9BC, 0xFFB7B9BB, 0xFFB6B9BB, 0xFFB6B8BB, 0xFFB5B7BA, 0xFFB5B8BA, 
        0xFFB4B7BA, 0xFFB3B6B9, 0xFFB4B5B8, 0xFFB2B5B7, 0xFFB3B4B7, 0xFFB2B4B7, 0xFFB2B4B7, 0xFFB2B4B6, 0xFFA9ABAF, 0xFF8C8E93, 0xFF7D7F85, 0xFF8A8C93, 0xE657585D, 0xBE0A0A0B, 0xAC000000, 0x98000000, 0x76000000, 0x4F000000, 0x2D000000, 0x15000000, 
        0x07000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x07000000, 0x15000000, 0x2D000000, 0x4A000000, 0x7A0A0A0A, 0xCC5A5B60, 0xFF999BA2, 0xFF818389, 
        0xFF7F8187, 0xFF8F9296, 0xFF919599, 0xFF919598, 0xFF919498, 0xFF919398, 0xFF909397, 0xFF909397, 0xFF909297, 0xFF8F9296, 0xFF8E9196, 0xFF8E9196, 0xFF8E9195, 0xFF8E9195, 0xFF8E9195, 0xFF8E9195, 0xFF8F9296, 0xFF8F9397, 0xFF8E9196, 0xFF8C8F94, 
        0xFF86898E, 0xFF7E8187, 0xFF777A7F, 0xFF6F7378, 0xFF6B6E74, 0xFF696C72, 0xFF676B70, 0xFF686C71, 0xFF696C72, 0xFF696D72, 0xFF696D72, 0xFF696D73, 0xFF696D73, 0xFF696D73, 0xFF686C71, 0xFF63676C, 0xFFB1B3B7, 0xAE6A6A6D, 0x2B000000, 0x0C000000, 
        0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00F4F4F4, 0x00F4F4F4, 0x00F4F4F4, 0x00F4F4F4, 0x00F4F4F4, 0x00F4F4F4, 0x00F4F4F4, 0x00F4F4F4, 0x00F4F4F4, 0x00F4F4F4, 0x00F4F4F4, 0x00F1F1F1, 0x2CF4F4F4, 0xF4FCFCFC, 0xFFD7D7DA, 0xFFC4C6C8, 0xFFBEC0C3, 0xFFBEBFC1, 0xFFBEBFC1, 0xFFBDBEC1, 0xFFBDBEC2, 
        0xFFBDBEC1, 0xFFBDBEC1, 0xFFBCBEC0, 0xFFBBBDC0, 0xFFBBBDC0, 0xFFBBBDBF, 0xFFBABCBF, 0xFFBABCBE, 0xFFBABCBE, 0xFFB9BBBD, 0xFFB9BBBD, 0xFFB8BBBD, 0xFFB8BABD, 0xFFB8BABD, 0xFFB8B9BC, 0xFFB8B9BB, 0xFFB7B9BB, 0xFFB6B8BB, 0xFFB5B7B9, 0xFFB5B6B9, 
        0xFFB4B7B9, 0xFFB4B6B9, 0xFFB4B6B9, 0xFFB4B6B8, 0xFFB3B5B8, 0xFFB3B5B8, 0xFFB2B4B7, 0xFFA5A8AB, 0xFF88898E, 0xFF82848C, 0xFB83858C, 0xD73A3B3E, 0xB6000000, 0xA6000000, 0x8A000000, 0x62000000, 0x3B000000, 0x1C000000, 0x0A000000, 0x02000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x0A000000, 0x1C000000, 0x38000000, 0x5C000000, 0xAB38393C, 0xF8929399, 
        0xFF8F9196, 0xFF7E8185, 0xFF8D9195, 0xFF93969A, 0xFF929599, 0xFF929598, 0xFF919498, 0xFF919498, 0xFF909398, 0xFF909397, 0xFF909398, 0xFF909398, 0xFF909398, 0xFF919499, 0xFF919498, 0xFF8F9296, 0xFF888C91, 0xFF818489, 0xFF787C81, 0xFF70757A, 
        0xFF6C7075, 0xFF6A6E74, 0xFF696E73, 0xFF6B6F74, 0xFF6B6F75, 0xFF6B6F75, 0xFF6C7075, 0xFF6C7075, 0xFF6C7075, 0xFF6C7075, 0xFF6C7075, 0xFF6C7075, 0xFF6C7075, 0xFF6C7075, 0xFF6C7075, 0xFF666A6F, 0xFF777A80, 0xFBB5B7BB, 0x70272829, 0x1B000000, 
        0x06000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DBDBDB, 0x00DBDBDB, 0x00DBDBDB, 0x00DBDBDB, 0x00DBDBDB, 0x00DBDBDB, 0x00DBDBDB, 0x00DBDBDB, 0x00DBDBDB, 0x00DBDBDB, 0x00D9D9D9, 0x00E9E9E9, 0xABFFFFFF, 0xFFE8E9E9, 0xFFC7C9CB, 0xFFC0C2C4, 0xFFBEC0C3, 0xFFBEC0C2, 0xFFBEC0C2, 0xFFBDBFC2, 0xFFBDBFC2, 
        0xFFBDBFC1, 0xFFBDBEC1, 0xFFBCBEC1, 0xFFBCBDC0, 0xFFBCBDC0, 0xFFBBBDBF, 0xFFBBBCBF, 0xFFBABCBF, 0xFFBABCBF, 0xFFBABCBE, 0xFFB9BBBE, 0xFFB9BBBD, 0xFFB8BABD, 0xFFB8B9BD, 0xFFB7B9BC, 0xFFB6B9BC, 0xFFB7B8BB, 0xFFB6B8BB, 0xFFB6B8BB, 0xFFB5B7BA, 
        0xFFB5B7BA, 0xFFB5B7BA, 0xFFB4B6B9, 0xFFB4B6B9, 0xFFB3B6B9, 0xFFB2B4B7, 0xFFA1A4A8, 0xFF82858A, 0xFF888991, 0xF376777E, 0xC91E1D1F, 0xB1000000, 0x9E000000, 0x7C000000, 0x51000000, 0x2A000000, 0x11000000, 0x04000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x10000000, 0x29000000, 0x49000000, 0x8C1E1F20, 
        0xEA86868D, 0xFF94969D, 0xFF7B7E83, 0xFF8C8F93, 0xFF92969A, 0xFF92969A, 0xFF92959A, 0xFF92959A, 0xFF92959A, 0xFF93969A, 0xFF94979B, 0xFF929699, 0xFF8E9295, 0xFF868A8E, 0xFF7D8185, 0xFF75797E, 0xFF6F7378, 0xFF6D7176, 0xFF6C7076, 0xFF6D7177, 
        0xFF6E7277, 0xFF6E7277, 0xFF6E7278, 0xFF6E7278, 0xFF6E7278, 0xFF6E7278, 0xFF6E7278, 0xFF6E7278, 0xFF6E7278, 0xFF6E7278, 0xFF6E7278, 0xFF6E7278, 0xFF6E7278, 0xFF6E7278, 0xFF6E7278, 0xFF6E7277, 0xFF64686D, 0xFF9FA1A6, 0xD08A8A8E, 0x3D000001, 
        0x12000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BEBEBE, 0x00BABABA, 0x49E0E0E0, 0xFEFBFBFB, 0xFFD0D2D4, 0xFFC3C5C7, 0xFFBFC1C3, 0xFFBFC1C3, 0xFFBEC0C3, 0xFFBEC0C3, 0xFFBEBFC2, 0xFFBDBFC2, 
        0xFFBDBEC2, 0xFFBDBEC2, 0xFFBDBEC1, 0xFFBCBDC1, 0xFFBCBDC0, 0xFFBCBDC0, 0xFFBBBDBF, 0xFFBBBDBF, 0xFFBABCBF, 0xFFBABCBE, 0xFFB9BBBE, 0xFFB9BBBE, 0xFFB8BABD, 0xFFB8B9BC, 0xFFB7B9BD, 0xFFB7B9BC, 0xFFB7B9BB, 0xFFB7B8BB, 0xFFB6B8BB, 0xFFB6B8BB, 
        0xFFB5B7BA, 0xFFB5B7BA, 0xFFB4B6B9, 0xFFB4B6B9, 0xFFB2B5B7, 0xFFA0A2A6, 0xFF808288, 0xFF878992, 0xEF6B6C73, 0xC10F0F10, 0xAD000000, 0x95000000, 0x6D000000, 0x43000000, 0x1F000000, 0x0A000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x09000000, 0x1D000000, 0x3A000000, 
        0x75111112, 0xE0787980, 0xFF96989F, 0xFF7E8086, 0xFF8C8F94, 0xFF95979C, 0xFF95989D, 0xFF95989D, 0xFF94969A, 0xFF8E9196, 0xFF85888D, 0xFF7B7F84, 0xFF73777C, 0xFF707479, 0xFF6F7278, 0xFF707379, 0xFF71747A, 0xFF71747A, 0xFF71757A, 0xFF71757A, 
        0xFF71757A, 0xFF71757A, 0xFF71757A, 0xFF71757A, 0xFF71757A, 0xFF71757A, 0xFF71757A, 0xFF71757A, 0xFF71757A, 0xFF71757A, 0xFF71757A, 0xFF71757A, 0xFF71757A, 0xFF71757A, 0xFF71757A, 0xFF71757A, 0xFF6F7278, 0xFF71747A, 0xFFB7B8BD, 0x8D3D3E3F, 
        0x25000000, 0x09000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00E8E8E8, 0x00E8E8E8, 0x00E8E8E8, 0x00E8E8E8, 0x00E8E8E8, 0x00E8E8E8, 0x00E8E8E8, 0x00E8E8E8, 0x00E8E8E8, 0x00E7E7E7, 0x07E9E9E9, 0xCCFCFCFC, 0xFFE0E1E2, 0xFFC7C8CA, 0xFFC1C3C4, 0xFFBFC1C3, 0xFFBFC1C3, 0xFFBFC0C3, 0xFFBEC0C3, 0xFFBEC0C3, 0xFFBDBFC2, 
        0xFFBDBFC2, 0xFFBDBFC2, 0xFFBDBFC1, 0xFFBDBFC1, 0xFFBCBEC0, 0xFFBCBEC0, 0xFFBBBDBF, 0xFFBBBDBF, 0xFFBABCBE, 0xFFBABBBE, 0xFFBABBBE, 0xFFB9BBBE, 0xFFB9BABD, 0xFFB8BABD, 0xFFB8BABC, 0xFFB8BABC, 0xFFB8BABB, 0xFFB7B9BB, 0xFFB7B8BB, 0xFFB6B8BB, 
        0xFFB5B7BA, 0xFFB5B7BA, 0xFFB4B7BA, 0xFFB3B5B8, 0xFFA0A2A6, 0xFF808288, 0xFF898B92, 0xEB616268, 0xBE09090A, 0xAA000000, 0x8D000000, 0x61000000, 0x36000000, 0x17000000, 0x06000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x05000000, 0x15000000, 
        0x30000000, 0x650B0B0C, 0xD56F7075, 0xFF9C9EA4, 0xFF818489, 0xFF8C8F93, 0xFF909397, 0xFF85898D, 0xFF7C7F84, 0xFF75797E, 0xFF72767B, 0xFF72767B, 0xFF73777C, 0xFF73777C, 0xFF74777D, 0xFF74777D, 0xFF74777D, 0xFF74777D, 0xFF74777D, 0xFF74777D, 
        0xFF74777D, 0xFF74777D, 0xFF74777D, 0xFF74777D, 0xFF74777D, 0xFF74777D, 0xFF74777D, 0xFF74777D, 0xFF74777D, 0xFF74777D, 0xFF74777D, 0xFF74777D, 0xFF74777D, 0xFF74777D, 0xFF74777D, 0xFF74777D, 0xFF74787D, 0xFF6B6F74, 0xFF8D9095, 0xE59A9BA0, 
        0x50070708, 0x18000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EEEEEE, 0x00EDEDED, 0x60F7F7F7, 0xFFF4F4F5, 0xFFCDCFD1, 0xFFC3C4C7, 0xFFC0C1C4, 0xFFBFC1C4, 0xFFBFC2C4, 0xFFBFC1C4, 0xFFBFC0C3, 0xFFBEC0C3, 0xFFBEC0C3, 
        0xFFBDBFC2, 0xFFBDBFC1, 0xFFBDBFC1, 0xFFBCBFC0, 0xFFBCBEC0, 0xFFBCBEC0, 0xFFBCBDC0, 0xFFBBBDC0, 0xFFBABDBF, 0xFFBBBCBF, 0xFFBABCBE, 0xFFBABCBE, 0xFFB9BBBE, 0xFFB9BABD, 0xFFB9BABC, 0xFFB9BABC, 0xFFB8BABC, 0xFFB7B9BC, 0xFFB7B9BB, 0xFFB6B9BB, 
        0xFFB5B9BB, 0xFFB6B8BA, 0xFFB5B6B9, 0xFFA0A2A6, 0xFF808388, 0xFF898B93, 0xE557585E, 0xBB040405, 0xA8000000, 0x87000000, 0x58000000, 0x2C000000, 0x10000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 
        0x0F000000, 0x28000000, 0x5A050506, 0xCA66676C, 0xFF9FA1A7, 0xFF707479, 0xFF6E7377, 0xFF74787D, 0xFF74797E, 0xFF75797E, 0xFF767A7F, 0xFF767A7F, 0xFF767A7F, 0xFF767A7F, 0xFF767A7F, 0xFF767A7F, 0xFF767A7F, 0xFF767A7F, 0xFF767A7F, 0xFF767A7F, 
        0xFF767A7F, 0xFF767A7F, 0xFF767A7F, 0xFF767A7F, 0xFF767A7F, 0xFF767A7F, 0xFF767A7F, 0xFF767A7F, 0xFF767A7F, 0xFF767A7F, 0xFF767A7F, 0xFF767A7F, 0xFF767A7F, 0xFF767A7F, 0xFF767A7F, 0xFF767A7F, 0xFF767A7F, 0xFF74787D, 0xFF6F7277, 0xFFAFB1B5, 
        0xA14D4D50, 0x2D000000, 0x0D000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00EFEFEF, 0x00EFEFEF, 0x00EFEFEF, 0x00EFEFEF, 0x00EFEFEF, 0x00EFEFEF, 0x00EFEFEF, 0x00EFEFEF, 0x00EFEFEF, 0x09F0F0F0, 0xD5FCFCFC, 0xFFDEDFE0, 0xFFC6C9CB, 0xFFC1C3C6, 0xFFC0C2C5, 0xFFC0C2C4, 0xFFC0C2C4, 0xFFBFC1C4, 0xFFBFC1C3, 0xFFBEC0C3, 0xFFBEC0C3, 
        0xFFBEC0C2, 0xFFBEC0C2, 0xFFBEC0C2, 0xFFBDBFC2, 0xFFBDBFC1, 0xFFBCBEC1, 0xFFBCBEC0, 0xFFBCBDBF, 0xFFBBBDC0, 0xFFBBBCBF, 0xFFBBBCBF, 0xFFBABCBF, 0xFFBABCBE, 0xFFB9BBBF, 0xFFB9BBBE, 0xFFB9BABD, 0xFFB8BABD, 0xFFB7BABC, 0xFFB7B9BC, 0xFFB7B9BC, 
        0xFFB7B9BC, 0xFFB5B8BA, 0xFFA3A6A8, 0xFF81848A, 0xFF898B92, 0xE3515257, 0xB8000000, 0xA6000000, 0x83000000, 0x53000000, 0x27000000, 0x0C000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x02000000, 0x0C000000, 0x24000000, 0x51010101, 0xC3616166, 0xFF9A9CA2, 0xFF6C7075, 0xFF72767B, 0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF797D82, 
        0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF797D82, 0xFF71757A, 0xFF8B8D93, 
        0xEB9B9CA1, 0x5B090A0A, 0x1C000000, 0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00EFEFEF, 0x00EFEFEF, 0x00EFEFEF, 0x00EFEFEF, 0x00EFEFEF, 0x00EFEFEF, 0x00EFEFEF, 0x00EFEFEF, 0x00EEEEEE, 0x67F6F6F6, 0xFFF1F1F2, 0xFFCDCFD1, 0xFFC4C6C8, 0xFFC1C3C6, 0xFFC1C3C5, 0xFFC1C3C5, 0xFFC0C2C4, 0xFFC0C2C4, 0xFFC0C2C4, 0xFFBFC1C4, 0xFFBFC1C3, 
        0xFFBFC0C3, 0xFFBEC0C3, 0xFFBEC0C2, 0xFFBEBFC2, 0xFFBEBFC1, 0xFFBDBEC1, 0xFFBCBFC0, 0xFFBCBEC1, 0xFFBBBEC1, 0xFFBBBEC1, 0xFFBBBDC0, 0xFFBABCBF, 0xFFBBBCC0, 0xFFBABCBF, 0xFFBABCBE, 0xFFB9BBBE, 0xFFB9BBBE, 0xFFB8BABD, 0xFFB8BABD, 0xFFB8BABD, 
        0xFFB7BABD, 0xFFA7A9AD, 0xFF84878C, 0xFF878992, 0xE555555A, 0xB8010101, 0xA4000000, 0x7F000000, 0x4E000000, 0x24000000, 0x0A000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x01000000, 0x0B000000, 0x21000000, 0x4D010101, 0xC666666B, 0xFF999BA1, 0xFF6E7177, 0xFF777B80, 0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 
        0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 0xFF7C8085, 0xFF7B7F84, 0xFF73777C, 
        0xFFABADB2, 0xA84F4F52, 0x32000000, 0x0E000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x00EBEBEB, 0x0BECECEC, 0xD9F8F8F8, 0xFFDCDDDF, 0xFFC8CACB, 0xFFC3C5C7, 0xFFC2C4C6, 0xFFC2C4C6, 0xFFC2C4C6, 0xFFC2C3C5, 0xFFC1C3C6, 0xFFC1C3C5, 0xFFC1C2C5, 0xFFC0C2C5, 
        0xFFBFC1C5, 0xFFBFC1C4, 0xFFBFC0C3, 0xFFBFC1C3, 0xFFBEC1C3, 0xFFBEC0C3, 0xFFBDC0C3, 0xFFBDBFC2, 0xFFBDBFC2, 0xFFBCBFC2, 0xFFBCBEC1, 0xFFBCBEC1, 0xFFBBBDC0, 0xFFBBBDC0, 0xFFBBBDC0, 0xFFBABDBF, 0xFFBABDBF, 0xFFBABCBF, 0xFFBABCBF, 0xFFB9BCBE, 
        0xFFADB0B3, 0xFF898B91, 0xFF86888F, 0xEA5C5D62, 0xB9020203, 0xA5000000, 0x7F000000, 0x4B000000, 0x21000000, 0x09000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x09000000, 0x1E000000, 0x4C030404, 0xCF6E6F74, 0xFF94969C, 0xFF71757A, 0xFF7D8186, 0xFF808489, 0xFF808489, 0xFF808489, 0xFF808489, 0xFF808489, 0xFF808489, 0xFF808489, 0xFF808489, 0xFF808489, 0xFF808489, 
        0xFF808489, 0xFF808489, 0xFF808489, 0xFF808489, 0xFF808489, 0xFF808489, 0xFF808489, 0xFF808489, 0xFF808489, 0xFF808489, 0xFF808489, 0xFF808489, 0xFF808489, 0xFF808489, 0xFF808489, 0xFF808489, 0xFF808489, 0xFF808489, 0xFF808489, 0xFF787D82, 
        0xFF8B8D93, 0xEE98999D, 0x5F0A0A0B, 0x1E000000, 0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DEDEDF, 0x00DEDEDF, 0x00DEDEDF, 0x00DEDEDF, 0x00DEDEDF, 0x00DEDEDF, 0x00DEDEDE, 0x00DADADB, 0x5EEAEAEB, 0xFFEEEFF0, 0xFFCFD1D3, 0xFFC6C8CB, 0xFFC4C5C7, 0xFFC3C6C7, 0xFFC3C5C8, 0xFFC3C5C7, 0xFFC2C5C7, 0xFFC2C4C6, 0xFFC2C4C6, 0xFFC1C4C6, 0xFFC1C3C6, 
        0xFFC1C3C5, 0xFFC1C2C5, 0xFFC1C2C5, 0xFFC0C2C4, 0xFFBFC2C5, 0xFFBFC2C4, 0xFFBFC1C4, 0xFFBEC0C3, 0xFFBEC0C3, 0xFFBEC0C2, 0xFFBDC0C2, 0xFFBDC0C2, 0xFFBCBFC2, 0xFFBDBFC2, 0xFFBCBEC2, 0xFFBCBEC1, 0xFFBBBEC0, 0xFFBCBDC0, 0xFFBBBEC0, 0xFFB3B5B8, 
        0xFF919398, 0xFF84868D, 0xF067686E, 0xBD070808, 0xA6000000, 0x80000000, 0x4C000000, 0x20000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08000000, 0x1C000000, 0x520B0B0C, 0xDC7C7D83, 0xFF93959B, 0xFF777B80, 0xFF82868B, 0xFF84888D, 0xFF84888D, 0xFF84888D, 0xFF84888D, 0xFF84888D, 0xFF84888D, 0xFF84888D, 0xFF84888D, 0xFF84888D, 
        0xFF84888D, 0xFF84888D, 0xFF84888D, 0xFF84888D, 0xFF84888D, 0xFF84888D, 0xFF84888D, 0xFF84888D, 0xFF84888D, 0xFF84888D, 0xFF84888D, 0xFF84888D, 0xFF84888D, 0xFF84888D, 0xFF84888D, 0xFF84888D, 0xFF84888D, 0xFF84888D, 0xFF84888D, 0xFF83878C, 
        0xFF7A7E83, 0xFFA6A7AD, 0xA5454548, 0x34000000, 0x0F000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 0x00A8A8A8, 0x00A7A7A7, 0x04B5B5B5, 0xC8F0F0F0, 0xFFDEDFE0, 0xFFCBCCCF, 0xFFC6C7CB, 0xFFC5C7C9, 0xFFC5C7C9, 0xFFC5C6C9, 0xFFC4C6C9, 0xFFC4C6C8, 0xFFC3C5C8, 0xFFC3C5C8, 0xFFC3C5C7, 0xFFC3C5C8, 
        0xFFC3C5C7, 0xFFC2C4C7, 0xFFC2C4C7, 0xFFC2C3C6, 0xFFC1C3C6, 0xFFC0C2C5, 0xFFC1C3C6, 0xFFC0C2C5, 0xFFC0C2C5, 0xFFC0C2C5, 0xFFBFC1C4, 0xFFBFC1C4, 0xFFBFC0C3, 0xFFBEC0C3, 0xFFBEC0C3, 0xFFBDBFC3, 0xFFBDBFC2, 0xFFBEBFC2, 0xFFBABBBF, 0xFF9B9DA2, 
        0xFF82838A, 0xF773747B, 0xC3111112, 0xA9000000, 0x85000000, 0x50000000, 0x21000000, 0x08000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x09000000, 0x1C000000, 0x61161618, 0xEE8F8F95, 0xFF8A8C92, 0xFF7D8187, 0xFF888C91, 0xFF898C92, 0xFF898C92, 0xFF898C92, 0xFF898C92, 0xFF898C92, 0xFF898C92, 0xFF898C92, 0xFF898C92, 
        0xFF898C92, 0xFF898C92, 0xFF898C92, 0xFF898C92, 0xFF898C92, 0xFF898C92, 0xFF898C92, 0xFF898C92, 0xFF898C92, 0xFF898C92, 0xFF898C92, 0xFF898C92, 0xFF898C92, 0xFF898C92, 0xFF898C92, 0xFF898C92, 0xFF898C92, 0xFF898C92, 0xFF898C92, 0xFF898C92, 
        0xFF80848A, 0xFF919398, 0xE686878C, 0x5A030304, 0x1E000000, 0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x001A1919, 0x001A1919, 0x001A1919, 0x001A1919, 0x001A1919, 0x001A1919, 0x00191919, 0x49828282, 0xFFF8F8F9, 0xFFD3D4D6, 0xFFC9CBCD, 0xFFC6C8CB, 0xFFC6C9CB, 0xFFC6C8CB, 0xFFC6C8CB, 0xFFC6C8CB, 0xFFC6C7CA, 0xFFC5C7CA, 0xFFC5C7CA, 0xFFC5C7C9, 0xFFC4C7C9, 
        0xFFC4C6C8, 0xFFC3C6C8, 0xFFC3C6C8, 0xFFC3C5C8, 0xFFC3C5C8, 0xFFC2C5C7, 0xFFC2C4C7, 0xFFC2C4C6, 0xFFC1C4C6, 0xFFC1C3C6, 0xFFC1C2C6, 0xFFC1C2C5, 0xFFC0C2C5, 0xFFBFC2C4, 0xFFBFC2C4, 0xFFBFC1C4, 0xFFBFC2C5, 0xFFBEC1C4, 0xFFA7AAAE, 0xFF84868D, 
        0xFD7C7D85, 0xCD212123, 0xAC000000, 0x8C000000, 0x56000000, 0x25000000, 0x09000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x09000000, 0x1D000000, 0x7A2A2A2C, 0xFB98999F, 0xFF878A90, 0xFF868A8F, 0xFF8D9196, 0xFF8D9196, 0xFF8D9196, 0xFF8D9196, 0xFF8D9196, 0xFF8D9196, 0xFF8D9196, 0xFF8D9196, 
        0xFF8D9196, 0xFF8D9196, 0xFF8D9196, 0xFF8D9196, 0xFF8D9196, 0xFF8D9196, 0xFF8D9196, 0xFF8D9196, 0xFF8D9196, 0xFF8D9196, 0xFF8D9196, 0xFF8D9196, 0xFF8D9196, 0xFF8D9196, 0xFF8D9196, 0xFF8D9196, 0xFF8D9196, 0xFF8D9196, 0xFF8D9196, 0xFF8D9196, 
        0xFF8C8F95, 0xFF82868A, 0xFFA0A1A6, 0x99333336, 0x32000000, 0x0D000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00DCDCDC, 0x00DCDCDC, 0x00DCDCDC, 0x00DCDCDC, 0x00DCDCDC, 0x00DCDCDC, 0x00D4D5D5, 0xAFE1E1E1, 0xFFE1E1E3, 0xFFCED0D2, 0xFFC9CBCD, 0xFFC8CACC, 0xFFC7CACD, 0xFFC7CACD, 0xFFC7C9CC, 0xFFC7C9CC, 0xFFC7C9CC, 0xFFC7C8CB, 0xFFC6C8CB, 0xFFC6C8CB, 0xFFC6C8CA, 
        0xFFC6C8CA, 0xFFC6C7C9, 0xFFC5C7C9, 0xFFC4C6C8, 0xFFC4C6C8, 0xFFC4C6C9, 0xFFC3C5C8, 0xFFC2C5C7, 0xFFC2C4C8, 0xFFC2C4C7, 0xFFC2C4C7, 0xFFC2C4C8, 0xFFC2C3C7, 0xFFC1C4C7, 0xFFC1C4C7, 0xFFC1C4C6, 0xFFC2C4C7, 0xFFB3B6B9, 0xFF8B8D93, 0xFF808289, 
        0xDA38393C, 0xB0000000, 0x93000000, 0x5F000000, 0x2B000000, 0x0C000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x0B000000, 0x23000000, 0x9E4A4B4E, 0xFF9D9EA3, 0xFF84888D, 0xFF8E9297, 0xFF91959A, 0xFF91959A, 0xFF91959A, 0xFF91959A, 0xFF91959A, 0xFF91959A, 0xFF91959A, 
        0xFF91959A, 0xFF91959A, 0xFF91959A, 0xFF91959A, 0xFF91959A, 0xFF91959A, 0xFF91959A, 0xFF91959A, 0xFF91959A, 0xFF91959A, 0xFF91959A, 0xFF91959A, 0xFF91959A, 0xFF91959A, 0xFF91959A, 0xFF91959A, 0xFF91959A, 0xFF91959A, 0xFF91959A, 0xFF91959A, 
        0xFF91959A, 0xFF878B91, 0xFF94979C, 0xDA727276, 0x52000000, 0x1C000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x005E5F5F, 0x005E5F5F, 0x005E5F5F, 0x005E5F5F, 0x005E5F5F, 0x005E5F5F, 0x269FA0A0, 0xF6F1F2F2, 0xFFD7D8DA, 0xFFCDCFD1, 0xFFCACCCE, 0xFFCACBCE, 0xFFC9CBCE, 0xFFC9CBCE, 0xFFC9CBCE, 0xFFC8CACD, 0xFFC8CACD, 0xFFC8CACC, 0xFFC8C9CC, 0xFFC8C9CC, 0xFFC7C9CC, 
        0xFFC7C9CB, 0xFFC7C8CC, 0xFFC6C8CC, 0xFFC6C8CB, 0xFFC6C7CB, 0xFFC5C7CB, 0xFFC6C8CB, 0xFFC5C7CA, 0xFFC5C7CA, 0xFFC5C6CA, 0xFFC5C6CA, 0xFFC4C6C9, 0xFFC4C6C9, 0xFFC4C5C9, 0xFFC3C5C9, 0xFFC4C6C9, 0xFFBDBFC2, 0xFF9A9CA1, 0xFF81838A, 0xEB54565A, 
        0xB7010101, 0x9C000000, 0x6B000000, 0x34000000, 0x0F000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x0D000000, 0x32020202, 0xCB6C6D72, 0xFF98999F, 0xFF8C8E95, 0xFF95989E, 0xFF96999F, 0xFF96999F, 0xFF96999F, 0xFF96999F, 0xFF96999F, 0xFF96999F, 
        0xFF96999F, 0xFF96999F, 0xFF96999F, 0xFF96999F, 0xFF96999F, 0xFF96999F, 0xFF96999F, 0xFF96999F, 0xFF96999F, 0xFF96999F, 0xFF96999F, 0xFF96999F, 0xFF96999F, 0xFF96999F, 0xFF96999F, 0xFF96999F, 0xFF96999F, 0xFF96999F, 0xFF96999F, 0xFF96999F, 
        0xFF96999F, 0xFF93969C, 0xFF8B8D94, 0xFD94959A, 0x83191A1A, 0x2E000000, 0x0B000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00616162, 0x00616162, 0x00616162, 0x00616162, 0x00616162, 0x005F5F60, 0x7EA2A2A3, 0xFFE8E9EA, 0xFFD3D5D7, 0xFFCDCFD2, 0xFFCBCED0, 0xFFCBCDD0, 0xFFCBCDD0, 0xFFCBCCCF, 0xFFCBCCCF, 0xFFCACCCF, 0xFFCACCCF, 0xFFC9CBCF, 0xFFC9CBCF, 0xFFC9CBCE, 0xFFC8CBCE, 
        0xFFC8CACE, 0xFFC8CACE, 0xFFC8CACE, 0xFFC8CACD, 0xFFC8CACD, 0xFFC8C9CD, 0xFFC7C9CD, 0xFFC7C9CC, 0xFFC7C9CC, 0xFFC6C9CC, 0xFFC6C8CC, 0xFFC5C7CB, 0xFFC5C8CB, 0xFFC5C7CB, 0xFFC5C8CA, 0xFFC4C6C9, 0xFFABADB2, 0xFF84868D, 0xF96C6D73, 0xC20F0F0F, 
        0xA5000000, 0x79000000, 0x40000000, 0x15000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x10000000, 0x53151516, 0xF0898A8F, 0xFF92959A, 0xFF94989D, 0xFF9A9EA3, 0xFF9A9EA3, 0xFF9A9EA3, 0xFF9A9EA3, 0xFF9A9EA3, 0xFF9A9EA3, 
        0xFF9A9EA3, 0xFF9A9EA3, 0xFF9A9EA3, 0xFF9A9EA3, 0xFF9A9EA3, 0xFF9A9EA3, 0xFF9A9EA3, 0xFF9A9EA3, 0xFF9A9EA3, 0xFF9A9EA3, 0xFF9A9EA3, 0xFF9A9EA3, 0xFF9A9EA3, 0xFF9A9EA3, 0xFF9A9EA3, 0xFF9A9EA3, 0xFF9A9EA3, 0xFF9A9EA3, 0xFF9A9EA3, 0xFF9A9EA3, 
        0xFF9A9EA3, 0xFF9A9EA3, 0xFF8E9298, 0xFF989A9F, 0xBF4D4D51, 0x46000000, 0x17000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x00C7C7C7, 0x09D0D0D1, 0xD8E7E7E8, 0xFFDADBDD, 0xFFD1D3D6, 0xFFCDCFD2, 0xFFCCCED2, 0xFFCCCFD1, 0xFFCDCED1, 0xFFCDCED2, 0xFFCDCED1, 0xFFCCCED1, 0xFFCCCED1, 0xFFCBCED1, 0xFFCBCDD1, 0xFFCBCDD0, 0xFFCBCDD0, 
        0xFFCBCCD0, 0xFFCACDD0, 0xFFCACDD0, 0xFFCACCD0, 0xFFC9CCCF, 0xFFC9CBCF, 0xFFC9CBCE, 0xFFC8CACE, 0xFFC8CACE, 0xFFC8CACD, 0xFFC8CACD, 0xFFC7C9CD, 0xFFC7CACD, 0xFFC7CACC, 0xFFC8CACD, 0xFFBBBDC1, 0xFF909399, 0xFF797A81, 0xD62D2D2F, 0xAB000000, 
        0x88000000, 0x4E000000, 0x1D000000, 0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x05000000, 0x15000000, 0x8B3C3C3F, 0xFF97999E, 0xFF93969C, 0xFF9DA0A6, 0xFF9FA2A8, 0xFF9FA2A8, 0xFF9FA2A8, 0xFF9FA2A8, 0xFF9FA2A8, 
        0xFF9FA2A8, 0xFF9FA2A8, 0xFF9FA2A8, 0xFF9FA2A8, 0xFF9FA2A8, 0xFF9FA2A8, 0xFF9FA2A8, 0xFF9FA2A8, 0xFF9FA2A8, 0xFF9FA2A8, 0xFF9FA2A8, 0xFF9FA2A8, 0xFF9FA2A8, 0xFF9FA2A8, 0xFF9FA2A8, 0xFF9FA2A8, 0xFF9FA2A8, 0xFF9FA2A8, 0xFF9FA2A8, 0xFF9FA2A8, 
        0xFF9FA2A8, 0xFF9FA3A8, 0xFF989CA2, 0xFF92959A, 0xF07C7C81, 0x6B060606, 0x27000000, 0x07000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00262626, 0x00262626, 0x00262626, 0x00262626, 0x00252525, 0x49787878, 0xFFE8E9EA, 0xFFD8DADC, 0xFFD1D4D5, 0xFFCFD2D4, 0xFFCED1D4, 0xFFCFD1D4, 0xFFCED1D4, 0xFFCED1D4, 0xFFCED0D3, 0xFFCED0D3, 0xFFCDD0D3, 0xFFCED0D3, 0xFFCDD0D2, 0xFFCDCFD2, 0xFFCDCFD2, 
        0xFFCDCFD1, 0xFFCCCFD1, 0xFFCCCED1, 0xFFCBCDD1, 0xFFCBCED1, 0xFFCACED1, 0xFFCBCED0, 0xFFCBCDD0, 0xFFCACDD0, 0xFFCACDD0, 0xFFCACCCF, 0xFFC9CCCF, 0xFFCACBCF, 0xFFCACDD0, 0xFFC6C8CC, 0xFFA5A7AC, 0xFF7F8188, 0xEC4F5055, 0xB5010101, 0x97000000, 
        0x61000000, 0x29000000, 0x09000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x07000000, 0x28010101, 0xCB696A6E, 0xFF9B9DA2, 0xFF9C9FA5, 0xFFA3A7AC, 0xFFA3A7AD, 0xFFA3A7AD, 0xFFA3A7AD, 0xFFA3A7AD, 
        0xFFA3A7AD, 0xFFA3A7AD, 0xFFA3A7AD, 0xFFA3A7AD, 0xFFA3A7AD, 0xFFA3A7AD, 0xFFA3A7AD, 0xFFA3A7AD, 0xFFA3A7AD, 0xFFA3A7AD, 0xFFA3A7AD, 0xFFA3A7AD, 0xFFA3A7AD, 0xFFA3A7AD, 0xFFA3A7AD, 0xFFA3A7AD, 0xFFA3A7AD, 0xFFA3A7AD, 0xFFA3A7AD, 0xFFA3A7AD, 
        0xFFA3A7AD, 0xFFA3A7AD, 0xFFA2A6AB, 0xFF93979E, 0xFF8F9196, 0xA02A2B2C, 0x39000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004B4B4B, 0x004F4F50, 0x9CC2C3C3, 0xFFDDDFE0, 0xFFD7D8DC, 0xFFD2D4D7, 0xFFD1D3D6, 0xFFD1D3D6, 0xFFD1D3D6, 0xFFD0D3D6, 0xFFD0D2D5, 0xFFD0D2D5, 0xFFCFD1D5, 0xFFD0D1D5, 0xFFCFD1D4, 0xFFCFD1D4, 0xFFCED1D4, 0xFFCED1D3, 
        0xFFCED1D3, 0xFFCED0D3, 0xFFCECFD3, 0xFFCECFD2, 0xFFCECFD2, 0xFFCDCFD2, 0xFFCDCFD3, 0xFFCDCED3, 0xFFCCCED2, 0xFFCCCED2, 0xFFCCCED2, 0xFFCCCED2, 0xFFCCCED1, 0xFFCCCED1, 0xFFBABCC0, 0xFF8C8E95, 0xFD6A6B72, 0xC7131314, 0xA4000000, 0x76000000, 
        0x3A000000, 0x11000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x0A000000, 0x5A1E1E20, 0xF98C8D91, 0xFF9C9EA5, 0xFFA5A9AF, 0xFFA8ABB1, 0xFFA8ABB1, 0xFFA8ABB1, 0xFFA8ABB1, 
        0xFFA8ABB1, 0xFFA8ABB1, 0xFFA8ABB1, 0xFFA8ABB1, 0xFFA8ABB1, 0xFFA8ABB1, 0xFFA8ABB1, 0xFFA8ABB1, 0xFFA8ABB1, 0xFFA8ABB1, 0xFFA8ABB1, 0xFFA8ABB1, 0xFFA8ABB1, 0xFFA8ABB1, 0xFFA8ABB1, 0xFFA8ABB1, 0xFFA8ABB1, 0xFFA8ABB1, 0xFFA8ABB1, 0xFFA8ABB1, 
        0xFFA8ABB1, 0xFFA8ABB1, 0xFFA8ACB2, 0xFF9DA0A7, 0xFF93959B, 0xD2535357, 0x54000000, 0x1E000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00484848, 0x00484848, 0x00484848, 0x00484848, 0x0F575757, 0xE6CDCECE, 0xFFDCDEE0, 0xFFD7D8DC, 0xFFD3D4D8, 0xFFD3D4D8, 0xFFD3D5D8, 0xFFD2D5D8, 0xFFD2D5D7, 0xFFD2D4D7, 0xFFD1D3D7, 0xFFD2D3D6, 0xFFD1D3D7, 0xFFD1D3D6, 0xFFD1D2D6, 0xFFD0D2D6, 0xFFD1D2D6, 
        0xFFD0D2D5, 0xFFD0D2D5, 0xFFD0D2D5, 0xFFD0D2D4, 0xFFCFD2D4, 0xFFCFD1D4, 0xFFCFD1D4, 0xFFCED1D4, 0xFFCFD1D4, 0xFFCFD0D4, 0xFFCED0D4, 0xFFCED0D3, 0xFFCED1D4, 0xFFC8CBCE, 0xFFA4A6AC, 0xFF797B81, 0xE23A3B3E, 0xAE000000, 0x8A000000, 0x4F000000, 
        0x1C000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x14000000, 0xAA515154, 0xFF999BA0, 0xFFA5A8AF, 0xFFACAFB5, 0xFFACB0B5, 0xFFACB0B5, 0xFFACB0B5, 
        0xFFACB0B5, 0xFFACB0B5, 0xFFACB0B5, 0xFFACB0B5, 0xFFACB0B5, 0xFFACB0B5, 0xFFACB0B5, 0xFFACB0B5, 0xFFACB0B5, 0xFFACB0B5, 0xFFACB0B5, 0xFFACB0B5, 0xFFACB0B5, 0xFFACB0B5, 0xFFACB0B5, 0xFFACB0B5, 0xFFACB0B5, 0xFFACB0B5, 0xFFACB0B5, 0xFFACB0B5, 
        0xFFACB0B5, 0xFFACB0B5, 0xFFADB1B6, 0xFFA8ABB1, 0xFF95989E, 0xF774757A, 0x7A09090A, 0x2F000000, 0x0A000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00323232, 0x00323232, 0x00323232, 0x00313131, 0x4F7C7C7C, 0xFFDEDFE0, 0xFFDCDEE1, 0xFFD7D8DC, 0xFFD5D7DA, 0xFFD4D6DA, 0xFFD4D6DA, 0xFFD4D6DA, 0xFFD4D6DA, 0xFFD4D6DA, 0xFFD3D6DA, 0xFFD3D5DA, 0xFFD3D6D9, 0xFFD3D5D9, 0xFFD3D5D9, 0xFFD3D5D9, 0xFFD2D4D8, 
        0xFFD2D4D9, 0xFFD2D5D8, 0xFFD2D4D8, 0xFFD2D4D8, 0xFFD1D4D8, 0xFFD2D4D8, 0xFFD1D3D7, 0xFFD1D3D7, 0xFFD0D3D7, 0xFFD0D3D6, 0xFFD0D3D6, 0xFFD0D2D6, 0xFFCFD2D6, 0xFFBCBEC4, 0xFF8B8D94, 0xFA5C5D63, 0xC00A0A0A, 0x9D000000, 0x68000000, 0x2D000000, 
        0x0A000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x05000000, 0x41111112, 0xF07E8084, 0xFFA2A5AB, 0xFFAFB2B9, 0xFFB1B4BA, 0xFFB1B4BA, 0xFFB1B4BA, 
        0xFFB1B4BA, 0xFFB1B4BA, 0xFFB1B4BA, 0xFFB1B4BA, 0xFFB1B4BA, 0xFFB1B4BA, 0xFFB1B4BA, 0xFFB1B4BA, 0xFFB1B4BA, 0xFFB1B4BA, 0xFFB1B4BA, 0xFFB1B4BA, 0xFFB1B4BA, 0xFFB1B4BA, 0xFFB1B4BA, 0xFFB1B4BA, 0xFFB1B4BA, 0xFFB1B4BA, 0xFFB1B4BA, 0xFFB1B4BA, 
        0xFFB1B4BA, 0xFFB1B4BA, 0xFFB1B5BA, 0xFFAFB3B9, 0xFF9EA1A8, 0xFF85878C, 0xA8272729, 0x41000000, 0x13000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x004A4B4B, 0x004A4B4B, 0x004A4B4B, 0x00505050, 0x98B2B2B2, 0xFFD9DADB, 0xFFDDE0E3, 0xFFD7D9DD, 0xFFD7D9DC, 0xFFD7D9DC, 0xFFD7D8DC, 0xFFD6D8DC, 0xFFD6D8DC, 0xFFD6D8DC, 0xFFD6D8DC, 0xFFD6D8DB, 0xFFD5D8DB, 0xFFD5D8DB, 0xFFD5D7DB, 0xFFD5D7DA, 0xFFD5D7DB, 
        0xFFD5D7DA, 0xFFD5D7DB, 0xFFD5D6DB, 0xFFD5D6DA, 0xFFD4D6DA, 0xFFD4D6DA, 0xFFD3D5D9, 0xFFD3D5D9, 0xFFD3D5D9, 0xFFD2D4D8, 0xFFD2D4D9, 0xFFD3D5DA, 0xFFCDCFD4, 0xFFA7AAB0, 0xFF74767C, 0xDE2F3032, 0xAA000000, 0x82000000, 0x44000000, 0x15000000, 
        0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x0C000000, 0x99464648, 0xFF98999E, 0xFFAFB2B9, 0xFFB5B8BE, 0xFFB5B8BE, 0xFFB5B8BE, 
        0xFFB5B8BE, 0xFFB5B8BE, 0xFFB5B8BE, 0xFFB5B8BE, 0xFFB5B8BE, 0xFFB5B8BE, 0xFFB5B8BE, 0xFFB5B8BE, 0xFFB5B8BE, 0xFFB5B8BE, 0xFFB5B8BE, 0xFFB5B8BE, 0xFFB5B8BE, 0xFFB5B8BE, 0xFFB5B8BE, 0xFFB5B8BE, 0xFFB5B8BE, 0xFFB5B8BE, 0xFFB5B8BE, 0xFFB5B8BE, 
        0xFFB5B8BE, 0xFFB5B8BE, 0xFFB5B8BE, 0xFFB6B9BF, 0xFFAAADB4, 0xFF8F9197, 0xD2464649, 0x59000000, 0x21000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x000D0D0D, 0x000D0D0D, 0x000D0D0D, 0x06121212, 0xD6B4B5B6, 0xFFDEE0E2, 0xFFDEDFE1, 0xFFD9DCDE, 0xFFD9DBDE, 0xFFD9DCDE, 0xFFD9DBDE, 0xFFD9DBDE, 0xFFD9DBDD, 0xFFD9DADD, 0xFFD8DADD, 0xFFD8DADD, 0xFFD9DADD, 0xFFD8DADD, 0xFFD8DADD, 0xFFD8D9DC, 0xFFD8D9DC, 
        0xFFD7D9DC, 0xFFD7D9DC, 0xFFD7D8DC, 0xFFD6D8DB, 0xFFD6D8DB, 0xFFD5D8DB, 0xFFD5D7DB, 0xFFD5D7DB, 0xFFD5D7DB, 0xFFD5D7DB, 0xFFD5D7DB, 0xFFD5D7DB, 0xFFC3C5C9, 0xFF8E9097, 0xF955565B, 0xBE080808, 0x99000000, 0x61000000, 0x26000000, 0x07000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x390F1010, 0xEF797A7D, 0xFFAAACB2, 0xFFB8BBC2, 0xFFB9BCC2, 0xFFB9BCC2, 
        0xFFB9BCC2, 0xFFB9BCC2, 0xFFB9BCC2, 0xFFB9BCC2, 0xFFB9BCC2, 0xFFB9BCC2, 0xFFB9BCC2, 0xFFB9BCC2, 0xFFB9BCC2, 0xFFB9BCC2, 0xFFB9BCC2, 0xFFB9BCC2, 0xFFB9BCC2, 0xFFB9BCC2, 0xFFB9BCC2, 0xFFB9BCC2, 0xFFB9BCC2, 0xFFB9BCC2, 0xFFB9BCC2, 0xFFB9BCC2, 
        0xFFB9BCC2, 0xFFB9BCC2, 0xFFB9BCC2, 0xFFBABDC3, 0xFFB4B6BD, 0xFF989BA1, 0xF1606165, 0x77030303, 0x31000000, 0x0A000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00444444, 0x00444444, 0x00434444, 0x33737374, 0xFCC7C8C9, 0xFFE1E3E5, 0xFFDDDFE2, 0xFFDCDDE0, 0xFFDCDDE0, 0xFFDCDDE0, 0xFFDBDDE0, 0xFFDBDDE0, 0xFFDBDDE0, 0xFFDBDCDF, 0xFFDADCDF, 0xFFDADCDF, 0xFFDADCDF, 0xFFDADBDE, 0xFFD9DBDF, 0xFFD9DBDE, 0xFFD9DADE, 
        0xFFD8DADE, 0xFFD9DADE, 0xFFD9DADD, 0xFFD8DADE, 0xFFD8D9DD, 0xFFD8DADD, 0xFFD8DADD, 0xFFD7DADD, 0xFFD7DADD, 0xFFD7D9DD, 0xFFD8DADD, 0xFFD4D6D9, 0xFFB0B1B7, 0xFF73757C, 0xE02D2E30, 0xA9000000, 0x7F000000, 0x40000000, 0x13000000, 0x01000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x09000000, 0x9F464749, 0xFF9B9CA1, 0xFFBBBEC4, 0xFFBDC0C6, 0xFFBDC0C6, 
        0xFFBDC0C6, 0xFFBDC0C6, 0xFFBDC0C6, 0xFFBDC0C6, 0xFFBDC0C6, 0xFFBDC0C6, 0xFFBDC0C6, 0xFFBDC0C6, 0xFFBDC0C6, 0xFFBDC0C6, 0xFFBDC0C6, 0xFFBDC0C6, 0xFFBDC0C6, 0xFFBDC0C6, 0xFFBDC0C6, 0xFFBDC0C6, 0xFFBDC0C6, 0xFFBDC0C6, 0xFFBDC0C6, 0xFFBDC0C6, 
        0xFFBDC0C6, 0xFFBDC0C6, 0xFFBDC0C6, 0xFFBEC1C7, 0xFFBBBEC4, 0xFFA5A8AF, 0xFF717377, 0x9B161617, 0x41000000, 0x12000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x003E3E3E, 0x003E3E3E, 0x003E3F3F, 0x777A7B7B, 0xFFD1D2D4, 0xFFE4E5E8, 0xFFDEDFE3, 0xFFDDDFE2, 0xFFDDDFE2, 0xFFDDDFE2, 0xFFDDDEE2, 0xFFDCDEE2, 0xFFDCDEE2, 0xFFDCDEE1, 0xFFDCDDE1, 0xFFDCDDE1, 0xFFDCDDE1, 0xFFDBDCE0, 0xFFDBDCE0, 0xFFDBDCE0, 0xFFDBDDE0, 
        0xFFDBDDE0, 0xFFDBDCE0, 0xFFDBDCDF, 0xFFDBDCE0, 0xFFDADCDF, 0xFFDADBDF, 0xFFDADBDF, 0xFFDADCDF, 0xFFDADCDF, 0xFFD9DBDF, 0xFFDADCE0, 0xFFCBCDD2, 0xFF96989F, 0xFD54555B, 0xC20B0B0C, 0x98000000, 0x60000000, 0x25000000, 0x06000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x42151617, 0xF77C7D80, 0xFFB5B8BE, 0xFFC2C5CB, 0xFFC1C4CA, 
        0xFFC1C4CA, 0xFFC1C4CA, 0xFFC1C4CA, 0xFFC1C4CA, 0xFFC1C4CA, 0xFFC1C4CA, 0xFFC1C4CA, 0xFFC1C4CA, 0xFFC1C4CA, 0xFFC1C4CA, 0xFFC1C4CA, 0xFFC1C4CA, 0xFFC1C4CA, 0xFFC1C4CA, 0xFFC1C4CA, 0xFFC1C4CA, 0xFFC1C4CA, 0xFFC1C4CA, 0xFFC1C4CA, 0xFFC1C4CA, 
        0xFFC1C4CA, 0xFFC1C4CA, 0xFFC1C4CA, 0xFFC1C4CA, 0xFFC1C4CA, 0xFFB2B5BC, 0xFF82848A, 0xC22C2C2E, 0x52000000, 0x1D000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000,
  0x000B0B0B, 0x000B0B0B, 0x00141414, 0xB2A3A5A5, 0xFFD7D8DA, 0xFFE4E6E9, 0xFFDFE1E5, 0xFFDFE1E4, 0xFFDFE1E4, 0xFFDFE0E3, 0xFFDFE0E3, 0xFFDEE0E3, 0xFFDEE0E3, 0xFFDEDFE3, 0xFFDDE0E2, 0xFFDDE0E3, 0xFFDDDFE3, 0xFFDDDFE2, 0xFFDDDFE2, 0xFFDDDFE2, 0xFFDDDFE2, 
        0xFFDDDFE2, 0xFFDDDEE2, 0xFFDDDEE2, 0xFFDCDEE2, 0xFFDCDEE2, 0xFFDCDEE2, 0xFFDCDEE2, 0xFFDCDEE2, 0xFFDCDEE2, 0xFFDCDEE2, 0xFFDADCE0, 0xFFBDC0C5, 0xFF797C82, 0xE8313235, 0xAC000000, 0x81000000, 0x42000000, 0x13000000, 0x01000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0C000000, 0xB7505153, 0xFFA2A4A9, 0xFFC6C9CF, 0xFFC5C8CE, 
        0xFFC5C8CE, 0xFFC5C8CE, 0xFFC5C8CE, 0xFFC5C8CE, 0xFFC5C8CE, 0xFFC5C8CE, 0xFFC5C8CE, 0xFFC5C8CE, 0xFFC5C8CE, 0xFFC5C8CE, 0xFFC5C8CE, 0xFFC5C8CE, 0xFFC5C8CE, 0xFFC5C8CE, 0xFFC5C8CE, 0xFFC5C8CE, 0xFFC5C8CE, 0xFFC5C8CE, 0xFFC5C8CE, 0xFFC5C8CE, 
        0xFFC5C8CE, 0xFFC5C8CE, 0xFFC5C8CE, 0xFFC5C8CE, 0xFFC6C9CF, 0xFFBDC0C6, 0xFF919399, 0xE1424346, 0x6A000000, 0x2A000000, 0x07000000, 0x00000000, 0x00000000, 0x00000000,
  0x004F4F50, 0x004F4F50, 0x0D4E4F4F, 0xE4A2A4A4, 0xFFE2E3E4, 0xFFE4E6E8, 0xFFE1E3E6, 0xFFE0E2E5, 0xFFE1E2E5, 0xFFE1E1E5, 0xFFE1E1E5, 0xFFE0E1E5, 0xFFE0E1E4, 0xFFE0E1E4, 0xFFE0E1E5, 0xFFE0E1E4, 0xFFE0E1E4, 0xFFE0E1E4, 0xFFDFE1E4, 0xFFDFE1E4, 0xFFDFE1E4, 
        0xFFDFE1E4, 0xFFDFE1E4, 0xFFDFE0E4, 0xFFDEE0E4, 0xFFDEE0E4, 0xFFDEE0E4, 0xFFDEE0E3, 0xFFDDE0E3, 0xFFDDE0E3, 0xFFDFE1E4, 0xFFD6D8DB, 0xFFA8AAB0, 0xFF5B5D63, 0xCE141516, 0x9C000000, 0x65000000, 0x29000000, 0x07000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x62262727, 0xFF86878A, 0xFFC5C8CD, 0xFFCACDD3, 
        0xFFC9CCD2, 0xFFC9CCD2, 0xFFC9CCD2, 0xFFC9CCD2, 0xFFC9CCD2, 0xFFC9CCD2, 0xFFC9CCD2, 0xFFC9CCD2, 0xFFC9CCD2, 0xFFC9CCD2, 0xFFC9CCD2, 0xFFC9CCD2, 0xFFC9CCD2, 0xFFC9CCD2, 0xFFC9CCD2, 0xFFC9CCD2, 0xFFC9CCD2, 0xFFC9CCD2, 0xFFC9CCD2, 0xFFC9CCD2, 
        0xFFC9CCD2, 0xFFC9CCD2, 0xFFC9CCD2, 0xFFC9CCD2, 0xFFCACDD3, 0xFFC4C7CD, 0xFFA1A4AA, 0xF7535457, 0x84030304, 0x39000000, 0x0E000000, 0x00000000, 0x00000000, 0x00000000,
  0x00525353, 0x00525353, 0x37767878, 0xFDB5B7B9, 0xFFE7E7EB, 0xFFE4E5E8, 0xFFE2E4E7, 0xFFE3E4E7, 0xFFE2E4E7, 0xFFE2E4E7, 0xFFE2E4E7, 0xFFE2E4E7, 0xFFE2E3E7, 0xFFE2E3E6, 0xFFE1E3E6, 0xFFE1E3E6, 0xFFE1E2E6, 0xFFE1E2E6, 0xFFE1E2E6, 0xFFE1E2E5, 0xFFE1E2E5, 
        0xFFE1E2E5, 0xFFE0E2E5, 0xFFE0E2E5, 0xFFE0E2E5, 0xFFE0E1E5, 0xFFE0E1E5, 0xFFE0E1E5, 0xFFE0E1E4, 0xFFE0E1E5, 0xFFE0E2E5, 0xFFCED0D4, 0xFF8C8E95, 0xF53B3D41, 0xB4010102, 0x89000000, 0x49000000, 0x16000000, 0x02000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1E070707, 0xDE606264, 0xFFB6B9BE, 0xFFD0D3D9, 
        0xFFCCCFD5, 0xFFCDCFD5, 0xFFCDCFD5, 0xFFCDCFD5, 0xFFCDCFD5, 0xFFCDCFD5, 0xFFCDCFD5, 0xFFCDCFD5, 0xFFCDCFD5, 0xFFCDCFD5, 0xFFCDCFD5, 0xFFCDCFD5, 0xFFCDCFD5, 0xFFCDCFD5, 0xFFCDCFD5, 0xFFCDCFD5, 0xFFCDCFD5, 0xFFCDCFD5, 0xFFCDCFD5, 0xFFCDCFD5, 
        0xFFCDCFD5, 0xFFCDCFD5, 0xFFCDCFD5, 0xFFCDCFD5, 0xFFCED0D6, 0xFFCBCED3, 0xFFB0B3BA, 0xFF636569, 0xA3111213, 0x48000000, 0x16000000, 0x01000000, 0x00000000, 0x00000000,
  0x00070707, 0x00060606, 0x6C454546, 0xFFC7C8CA, 0xFFEBEDF1, 0xFFE5E6EB, 0xFFE4E5EA, 0xFFE4E5EA, 0xFFE4E5E9, 0xFFE4E5E9, 0xFFE4E5E9, 0xFFE4E5E9, 0xFFE4E5E9, 0xFFE4E5E9, 0xFFE3E5E9, 0xFFE3E5E9, 0xFFE3E5E9, 0xFFE3E4E9, 0xFFE3E4E9, 0xFFE3E4E8, 0xFFE3E4E8, 
        0xFFE3E4E8, 0xFFE3E4E8, 0xFFE2E4E8, 0xFFE2E3E8, 0xFFE2E3E8, 0xFFE2E3E8, 0xFFE2E3E8, 0xFFE2E3E8, 0xFFE3E4E8, 0xFFE0E1E6, 0xFFC0C2C8, 0xFF6E7076, 0xDF1F2022, 0xA3000000, 0x71000000, 0x31000000, 0x0A000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x9738393A, 0xFF9D9FA3, 0xFFD5D7DD, 
        0xFFD1D3D9, 0xFFD1D3D9, 0xFFD1D3D9, 0xFFD1D3D9, 0xFFD1D3D9, 0xFFD1D3D9, 0xFFD1D3D9, 0xFFD1D3D9, 0xFFD1D3D9, 0xFFD1D3D9, 0xFFD1D3D9, 0xFFD1D3D9, 0xFFD1D3D9, 0xFFD1D3D9, 0xFFD1D3D9, 0xFFD1D3D9, 0xFFD1D3D9, 0xFFD1D3D9, 0xFFD1D3D9, 0xFFD1D3D9, 
        0xFFD1D3D9, 0xFFD1D3D9, 0xFFD1D3D9, 0xFFD1D3D9, 0xFFD1D3D9, 0xFFD0D3D9, 0xFFBFC1C8, 0xFF76787E, 0xC01C1D1E, 0x56000000, 0x20000000, 0x03000000, 0x00000000, 0x00000000,
  0x003A3A3A, 0x003D3D3D, 0x9E808282, 0xFFCCCED0, 0xFFEEF0F3, 0xFFE7E8EC, 0xFFE7E8EC, 0xFFE7E8EC, 0xFFE6E8EC, 0xFFE6E8EC, 0xFFE6E8EC, 0xFFE6E7EC, 0xFFE6E7EB, 0xFFE6E7EB, 0xFFE6E7EB, 0xFFE6E7EB, 0xFFE6E7EB, 0xFFE6E7EB, 0xFFE6E7EA, 0xFFE5E7EA, 0xFFE5E6EB, 
        0xFFE5E6EB, 0xFFE5E6EB, 0xFFE5E6EB, 0xFFE5E6EA, 0xFFE5E6EA, 0xFFE5E6EA, 0xFFE5E6EA, 0xFFE4E6EA, 0xFFE5E7EB, 0xFFDDDEE3, 0xFFACAEB6, 0xFF4F5055, 0xC70C0D0E, 0x94000000, 0x58000000, 0x1F000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4D1C1C1D, 0xFD797B7E, 0xFFD2D4DA, 
        0xFFD7D9DE, 0xFFD5D7DD, 0xFFD5D7DD, 0xFFD5D7DD, 0xFFD5D7DD, 0xFFD5D7DD, 0xFFD5D7DD, 0xFFD5D7DD, 0xFFD5D7DD, 0xFFD5D7DD, 0xFFD5D7DD, 0xFFD5D7DD, 0xFFD5D7DD, 0xFFD5D7DD, 0xFFD5D7DD, 0xFFD5D7DD, 0xFFD5D7DD, 0xFFD5D7DD, 0xFFD5D7DD, 0xFFD5D7DD, 
        0xFFD5D7DD, 0xFFD5D7DD, 0xFFD5D7DD, 0xFFD5D7DD, 0xFFD5D7DD, 0xFFD5D7DE, 0xFFCBCDD4, 0xFF888A90, 0xD92A2B2D, 0x69000000, 0x2B000000, 0x07000000, 0x00000000, 0x00000000,
  0x00000000, 0x03000000, 0xCB838485, 0xFFDCDEE0, 0xFFEFF0F3, 0xFFEAEBED, 0xFFEAEBED, 0xFFEAEBED, 0xFFEAEBEE, 0xFFE9EBEE, 0xFFE9EBEE, 0xFFE9EAEE, 0xFFE9EAED, 0xFFE9EAED, 0xFFE9EAED, 0xFFE9EAED, 0xFFE9EAED, 0xFFE9EAED, 0xFFE8E9ED, 0xFFE8EAED, 0xFFE8EAED, 
        0xFFE8EAED, 0xFFE8EAED, 0xFFE8EAED, 0xFFE8EAED, 0xFFE8E9ED, 0xFFE8E9ED, 0xFFE8E9ED, 0xFFE8E9EC, 0xFFE9EAEE, 0xFFD8D9DE, 0xFF94959C, 0xF6343539, 0xB2010101, 0x81000000, 0x41000000, 0x11000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x18030304, 0xDF56575A, 0xFFC4C6CB, 
        0xFFDEE0E5, 0xFFDADCE1, 0xFFDADCE1, 0xFFDADCE1, 0xFFDADCE1, 0xFFDADCE1, 0xFFDADCE1, 0xFFDADCE1, 0xFFDADCE1, 0xFFDADCE1, 0xFFDADCE1, 0xFFDADCE1, 0xFFDADCE1, 0xFFDADCE1, 0xFFDADCE1, 0xFFDADCE1, 0xFFDADCE1, 0xFFDADCE1, 0xFFDADCE1, 0xFFDADCE1, 
        0xFFDADCE1, 0xFFDADCE1, 0xFFDADCE1, 0xFFDADCE1, 0xFFDADCE1, 0xFFDBDDE2, 0xFFD3D5DB, 0xFF9C9DA4, 0xED38393C, 0x7D000000, 0x37000000, 0x0C000000, 0x00000000, 0x00000000,
  0x002F3030, 0x15343536, 0xEF898A8B, 0xFFEAEBED, 0xFFEEF0F2, 0xFFECEDF0, 0xFFECEDF0, 0xFFECEDF0, 0xFFECEDF0, 0xFFEBEDF0, 0xFFEBEDF0, 0xFFEBEDF0, 0xFFEBEDEF, 0xFFEBEDEF, 0xFFEBEDEF, 0xFFEBEDEF, 0xFFEBEDEF, 0xFFEBEDEF, 0xFFEBEDEF, 0xFFEBECEF, 0xFFEBECEF, 
        0xFFEBECEF, 0xFFEBECEF, 0xFFEBECEF, 0xFFEBECEE, 0xFFEBECEF, 0xFFEBECEF, 0xFFEBECEF, 0xFFEBECEF, 0xFFEAEBEE, 0xFFD0D1D6, 0xFF74767C, 0xE41C1D1F, 0xA2000000, 0x6D000000, 0x2D000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03010101, 0xA438393B, 0xFFA7A9AB, 
        0xFFE6E8EC, 0xFFDEE0E4, 0xFFDEE0E4, 0xFFDEE0E4, 0xFFDEE0E4, 0xFFDEE0E4, 0xFFDEE0E4, 0xFFDEE0E4, 0xFFDEE0E4, 0xFFDEE0E4, 0xFFDEE0E4, 0xFFDEE0E4, 0xFFDEE0E4, 0xFFDEE0E4, 0xFFDEE0E4, 0xFFDEE0E4, 0xFFDEE0E4, 0xFFDEE0E4, 0xFFDEE0E4, 0xFFDEE0E4, 
        0xFFDEE0E4, 0xFFDEE0E4, 0xFFDEE0E4, 0xFFDEE0E4, 0xFFDEE0E4, 0xFFDFE1E5, 0xFFDADBE0, 0xFFB0B2B9, 0xFB434448, 0x91030304, 0x44000000, 0x12000000, 0x00000000, 0x00000000,
  0x000E0E0E, 0x39404142, 0xFCA1A3A3, 0xFFEFF1F2, 0xFFF0F1F3, 0xFFEEF0F1, 0xFFEEF0F1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEF0F1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEDEFF1, 
        0xFFEDEEF1, 0xFFEDEEF1, 0xFFEDEEF1, 0xFFEDEEF1, 0xFFEDEFF1, 0xFFEDEFF0, 0xFFEDEFF0, 0xFFEEEFF1, 0xFFE9EBED, 0xFFC0C2C8, 0xFF56575C, 0xCF0D0E0E, 0x93000000, 0x58000000, 0x1E000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x681D1E1F, 0xFF87898B, 
        0xFFE6E8EC, 0xFFE3E5E9, 0xFFE2E4E8, 0xFFE2E4E8, 0xFFE2E4E8, 0xFFE2E4E8, 0xFFE2E4E8, 0xFFE2E4E8, 0xFFE2E4E8, 0xFFE2E4E8, 0xFFE2E4E8, 0xFFE2E4E8, 0xFFE2E4E8, 0xFFE2E4E8, 0xFFE2E4E8, 0xFFE2E4E8, 0xFFE2E4E8, 0xFFE2E4E8, 0xFFE2E4E8, 0xFFE2E4E8, 
        0xFFE2E4E8, 0xFFE2E4E8, 0xFFE2E4E8, 0xFFE2E4E8, 0xFFE2E4E8, 0xFFE3E5E9, 0xFFE0E2E6, 0xFFBFC1C7, 0xFF525357, 0xA80B0B0B, 0x50000000, 0x1A000000, 0x01000000, 0x00000000,
  0x00000000, 0x5C2F2F30, 0xFFAEB0B1, 0xFFF6F7F8, 0xFFF2F2F4, 0xFFF1F1F3, 0xFFF1F1F3, 0xFFF1F1F3, 0xFFF1F1F3, 0xFFF1F1F3, 0xFFF0F1F3, 0xFFF0F1F3, 0xFFF0F1F3, 0xFFF0F1F3, 0xFFF0F1F3, 0xFFF0F0F3, 0xFFF0F0F3, 0xFFF0F0F3, 0xFFEFF0F3, 0xFFEFF1F3, 0xFFF0F1F3, 
        0xFFF0F1F3, 0xFFF0F1F3, 0xFFF0F1F3, 0xFFF0F0F3, 0xFFF0F0F2, 0xFFF0F0F2, 0xFFF0F0F2, 0xFFF0F1F3, 0xFFE7E8EA, 0xFFAEAFB5, 0xFE393B3F, 0xBB040505, 0x86000000, 0x45000000, 0x12000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x31111112, 0xF8606264, 
        0xFFE1E2E6, 0xFFE8EAED, 0xFFE6E8EB, 0xFFE6E8EB, 0xFFE6E8EB, 0xFFE6E8EB, 0xFFE6E8EB, 0xFFE6E8EB, 0xFFE6E8EB, 0xFFE6E8EB, 0xFFE6E8EB, 0xFFE6E8EB, 0xFFE6E8EB, 0xFFE6E8EB, 0xFFE6E8EB, 0xFFE6E8EB, 0xFFE6E8EB, 0xFFE6E8EB, 0xFFE6E8EB, 0xFFE6E8EB, 
        0xFFE6E8EB, 0xFFE6E8EB, 0xFFE6E8EB, 0xFFE6E8EB, 0xFFE6E8EB, 0xFFE7E8EC, 0xFFE6E7EB, 0xFFCCCED3, 0xFF63656A, 0xBD0E0F10, 0x5C000000, 0x22000000, 0x04000000, 0x00000000,
  0x00292A2A, 0x7E404142, 0xFFB6B7B9, 0xFFFCFDFF, 0xFFF3F3F5, 0xFFF3F3F5, 0xFFF3F3F5, 0xFFF3F3F5, 0xFFF3F3F5, 0xFFF3F3F5, 0xFFF3F3F5, 0xFFF3F3F5, 0xFFF3F3F5, 0xFFF2F3F5, 0xFFF2F2F5, 0xFFF2F3F5, 0xFFF2F3F5, 0xFFF2F3F5, 0xFFF2F3F5, 0xFFF2F3F5, 0xFFF2F3F5, 
        0xFFF2F3F4, 0xFFF2F3F4, 0xFFF2F3F4, 0xFFF2F2F4, 0xFFF2F2F4, 0xFFF2F2F4, 0xFFF2F2F4, 0xFFF3F3F5, 0xFFE4E4E7, 0xFF95969D, 0xF3252629, 0xAB000000, 0x76000000, 0x34000000, 0x0A000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x10010101, 0xD5454749, 
        0xFFCDCFD1, 0xFFEFF0F4, 0xFFEAEBEF, 0xFFEAEBEF, 0xFFEAEBEF, 0xFFEAEBEF, 0xFFEAEBEF, 0xFFEAEBEF, 0xFFEAEBEF, 0xFFEAEBEF, 0xFFEAEBEF, 0xFFEAEBEF, 0xFFEAEBEF, 0xFFEAEBEF, 0xFFEAEBEF, 0xFFEAEBEF, 0xFFEAEBEF, 0xFFEAEBEF, 0xFFEAEBEF, 0xFFEAEBEF, 
        0xFFEAEBEF, 0xFFEAEBEF, 0xFFEAEBEF, 0xFFEAEBEF, 0xFFEAEBEF, 0xFFEAEBEF, 0xFFEAEBEF, 0xFFD9DADF, 0xFF74767B, 0xCC101113, 0x66000000, 0x2B000000, 0x06000000, 0x00000000,
  0x00313232, 0x9D5B5D5E, 0xFFC2C3C4, 0xFFFEFEFF, 0xFFF5F5F6, 0xFFF5F5F6, 0xFFF5F5F6, 0xFFF5F5F6, 0xFFF4F5F6, 0xFFF4F5F6, 0xFFF4F5F6, 0xFFF4F5F6, 0xFFF4F5F6, 0xFFF4F5F6, 0xFFF4F5F6, 0xFFF4F5F6, 0xFFF4F5F6, 0xFFF4F5F6, 0xFFF4F5F6, 0xFFF4F4F6, 0xFFF4F4F6, 
        0xFFF4F4F6, 0xFFF4F4F6, 0xFFF3F4F6, 0xFFF3F4F6, 0xFFF3F4F6, 0xFFF3F4F6, 0xFFF3F4F6, 0xFFF4F4F6, 0xFFDEDFE3, 0xFF797B80, 0xE5151618, 0x9E000000, 0x65000000, 0x27000000, 0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0xA72F3132, 
        0xFFAFB1B2, 0xFFF8F9FB, 0xFFEDEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 
        0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF1, 0xFFEEEFF2, 0xFFE2E3E8, 0xFF838589, 0xDC17181A, 0x74000000, 0x33000000, 0x0A000000, 0x00000000,
  0x00000000, 0xB85C5E5F, 0xFFD2D4D4, 0xFFFCFCFE, 0xFFF6F6F8, 0xFFF6F6F8, 0xFFF6F6F8, 0xFFF6F6F8, 0xFFF6F6F8, 0xFFF6F6F8, 0xFFF5F6F8, 0xFFF5F6F8, 0xFFF5F6F8, 0xFFF5F6F8, 0xFFF5F6F8, 0xFFF5F6F8, 0xFFF5F6F8, 0xFFF5F6F8, 0xFFF5F6F8, 0xFFF5F6F8, 0xFFF5F6F8, 
        0xFFF5F6F8, 0xFFF5F6F8, 0xFFF5F6F8, 0xFFF5F6F8, 0xFFF5F6F8, 0xFFF5F6F8, 0xFFF6F7F8, 0xFFF5F5F7, 0xFFD7D8DC, 0xFF616368, 0xD70A0A0B, 0x92000000, 0x55000000, 0x1B000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7E161718, 
        0xFF97989A, 0xFFFBFCFE, 0xFFF1F2F4, 0xFFF1F2F4, 0xFFF1F2F4, 0xFFF1F2F4, 0xFFF1F2F4, 0xFFF1F2F4, 0xFFF1F2F4, 0xFFF1F2F4, 0xFFF1F2F4, 0xFFF1F2F4, 0xFFF1F2F4, 0xFFF1F2F4, 0xFFF1F2F4, 0xFFF1F2F4, 0xFFF1F2F4, 0xFFF1F2F4, 0xFFF1F2F4, 0xFFF1F2F4, 
        0xFFF1F2F4, 0xFFF1F2F4, 0xFFF1F2F4, 0xFFF1F2F4, 0xFFF1F2F4, 0xFFF1F2F4, 0xFFF2F3F5, 0xFFE9E9ED, 0xFF939499, 0xE71D1E20, 0x81000000, 0x3C000000, 0x0D000000, 0x00000000,
  0x07020202, 0xD15C5D5E, 0xFFE0E1E1, 0xFFFDFDFE, 0xFFF8F8F9, 0xFFF8F8F9, 0xFFF8F8F9, 0xFFF8F8F9, 0xFFF8F8F9, 0xFFF8F8F9, 0xFFF8F8F9, 0xFFF8F8F9, 0xFFF8F8F9, 0xFFF8F8F9, 0xFFF8F8F9, 0xFFF8F8F9, 0xFFF8F8F9, 0xFFF8F8F9, 0xFFF8F8F9, 0xFFF8F8F9, 0xFFF8F8F9, 
        0xFFF8F8F9, 0xFFF8F8F9, 0xFFF8F8F9, 0xFFF8F8F9, 0xFFF8F8F9, 0xFFF8F8F9, 0xFFF9F9FA, 0xFFF5F5F7, 0xFFCACBCF, 0xFF484A4E, 0xC9050607, 0x87000000, 0x47000000, 0x13000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x57121314, 
        0xFF77797B, 0xFFF6F7F9, 0xFFF6F6F8, 0xFFF4F5F7, 0xFFF4F5F7, 0xFFF4F5F7, 0xFFF4F5F7, 0xFFF4F5F7, 0xFFF4F5F7, 0xFFF4F5F7, 0xFFF4F5F7, 0xFFF4F5F7, 0xFFF4F5F7, 0xFFF4F5F7, 0xFFF4F5F7, 0xFFF4F5F7, 0xFFF4F5F7, 0xFFF4F5F7, 0xFFF4F5F7, 0xFFF4F5F7, 
        0xFFF4F5F7, 0xFFF4F5F7, 0xFFF4F5F7, 0xFFF4F5F7, 0xFFF4F5F7, 0xFFF4F5F7, 0xFFF5F6F8, 0xFFECEDF0, 0xFFA5A6AB, 0xF1232527, 0x8C000000, 0x44000000, 0x12000000, 0x00000000,
  0x0D030303, 0xE657595A, 0xFFECECED, 0xFFFDFDFE, 0xFFF9FAFA, 0xFFF9FAFA, 0xFFF9FAFA, 0xFFF9FAFA, 0xFFF9FAFA, 0xFFF9FAFA, 0xFFF9FAFA, 0xFFF9FAFA, 0xFFF9FAFA, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 
        0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9F9FB, 0xFFF9F9FB, 0xFFF9F9FB, 0xFFF9F9FB, 0xFFFAFAFC, 0xFFF4F4F6, 0xFFBEBFC3, 0xFF333538, 0xBA020203, 0x7C000000, 0x3A000000, 0x0D000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x310E0F10, 
        0xF9555759, 0xFFF1F2F3, 0xFFF9FAFB, 0xFFF7F7F9, 0xFFF7F7F9, 0xFFF7F7F9, 0xFFF7F7F9, 0xFFF7F7F9, 0xFFF7F7F9, 0xFFF7F7F9, 0xFFF7F7F9, 0xFFF7F7F9, 0xFFF7F7F9, 0xFFF7F7F9, 0xFFF7F7F9, 0xFFF7F7F9, 0xFFF7F7F9, 0xFFF7F7F9, 0xFFF7F7F9, 0xFFF7F7F9, 
        0xFFF7F7F9, 0xFFF7F7F9, 0xFFF7F7F9, 0xFFF7F7F9, 0xFFF7F7F9, 0xFFF7F7F9, 0xFFF8F8FA, 0xFFEFF0F2, 0xFFB5B6BA, 0xF926282A, 0x94000000, 0x4C000000, 0x16000000, 0x00000000,
  0x1B2D2F30, 0xF35F6061, 0xFFF5F5F5, 0xFFFEFEFF, 0xFFFBFBFC, 0xFFFBFBFC, 0xFFFBFBFC, 0xFFFBFBFC, 0xFFFBFBFC, 0xFFFBFBFC, 0xFFFBFBFC, 0xFFFBFBFC, 0xFFFBFBFC, 0xFFFBFBFC, 0xFFFBFBFC, 0xFFFBFBFC, 0xFFFBFBFC, 0xFFFBFBFC, 0xFFFBFBFC, 0xFFFBFBFC, 0xFFFBFBFC, 
        0xFFFBFBFC, 0xFFFBFBFC, 0xFFFBFCFC, 0xFFFBFCFC, 0xFFFBFCFC, 0xFFFBFCFC, 0xFFFCFDFD, 0xFFF3F4F5, 0xFFB2B3B7, 0xFB242527, 0xAE000000, 0x72000000, 0x30000000, 0x09000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x17030303, 
        0xEC3F4142, 0xFFEAEAEB, 0xFFFEFDFE, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 
        0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFF9FAFB, 0xFFFAFBFC, 0xFFF4F4F6, 0xFFC1C2C6, 0xFD2C2D30, 0x9E000001, 0x54000000, 0x1A000000, 0x01000000,
  0x2C272829, 0xF86B6C6D, 0xFFF8F8F9, 0xFFFFFFFF, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFDFDFD, 0xFFFCFCFD, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 
        0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFF2F3F4, 0xFFA1A1A6, 0xF31A1B1D, 0xA5000000, 0x67000000, 0x28000000, 0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0C000000, 
        0xD4363839, 0xFFDADBDC, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 
        0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFF8F8FA, 0xFFC8C9CD, 0xFF333537, 0xA9010202, 0x5A000000, 0x1E000000, 0x01000000,
  0x3B141516, 0xFC757678, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 
        0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFEFEFF, 0xFFF3F3F4, 0xFF919296, 0xED121315, 0x9D000000, 0x5E000000, 0x21000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x05000000, 
        0xC02B2E2F, 0xFFCACBCB, 0xFFFFFFFF, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 
        0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFDFEFE, 0xFFFFFFFF, 0xFFFCFCFC, 0xFFCECFD3, 0xFF393B3E, 0xB2020202, 0x60000000, 0x22000000, 0x01000000,
  0x47151617, 0xFF7D7F80, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF1F2F3, 0xFF848589, 0xE70C0E0F, 0x96000000, 0x56000000, 0x1C000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 
        0xB1232526, 0xFFBCBDBD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFD3D4D7, 0xFF3F4144, 0xB8010202, 0x64000000, 0x25000000, 0x03000000,
  0x50141616, 0xFF848686, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF0F0F2, 0xFF797A7E, 0xE1070809, 0x8F000000, 0x4F000000, 0x18000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 
        0x9F1C1E1E, 0xFFAFB0B0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFD6D7DA, 0xFF454649, 0xBD010202, 0x68000000, 0x29000000, 0x04000000,
  0x56121314, 0xFF858687, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEEEFF0, 0xFF727478, 0xDD040506, 0x8A000000, 0x4A000000, 0x15000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x95191A1B, 0xFFA8A9AA, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFD9DADD, 0xFF494B4E, 0xC0010102, 0x6C000000, 0x2C000000, 0x04000000,
  0x5C0E0F10, 0xFF858687, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEEEFF0, 0xFF6F7074, 0xDA020304, 0x86000000, 0x45000000, 0x12000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x8E171919, 0xFFA5A6A6, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 
        0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFDBDBDE, 0xFF4D4E51, 0xC3010102, 0x6E000000, 0x2E000000, 0x04000000,
  0x5C0C0E0E, 0xFF828485, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFEFEFD, 0xFFFEFEFD, 0xFFFEFEFD, 0xFFFEFEFD, 0xFFFEFEFD, 0xFFFEFEFD, 0xFFFEFEFD, 0xFFFEFEFD, 0xFFFEFEFD, 0xFFFEFEFD, 0xFFFEFEFD, 0xFFFEFEFD, 0xFFFEFEFD, 0xFFFEFEFD, 0xFFFEFEFD, 0xFFFEFEFD, 0xFFFEFEFD, 
        0xFFFEFEFD, 0xFFFEFEFD, 0xFFFEFEFD, 0xFFFEFEFD, 0xFFFEFEFD, 0xFFFEFEFD, 0xFFFEFEFD, 0xFFEEEFF0, 0xFF6D6E71, 0xD8010203, 0x82000000, 0x42000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x89171819, 0xFFA3A4A4, 0xFFFFFFFF, 0xFFFEFEFC, 0xFFFEFEFC, 0xFFFEFEFC, 0xFFFEFEFC, 0xFFFEFEFC, 0xFFFEFEFC, 0xFFFEFEFC, 0xFFFEFEFC, 0xFFFEFEFC, 0xFFFEFEFC, 0xFFFEFEFC, 0xFFFEFEFC, 0xFFFEFEFC, 0xFFFEFEFC, 0xFFFEFEFC, 0xFFFEFEFC, 0xFFFEFEFC, 
        0xFFFEFEFC, 0xFFFEFEFC, 0xFFFEFEFC, 0xFFFEFEFC, 0xFFFEFEFC, 0xFFFEFEFC, 0xFFFFFFFD, 0xFFFDFDFB, 0xFFDADADC, 0xFF4C4E50, 0xC5000101, 0x70000000, 0x2F000000, 0x05000000,
  0x5C0B0C0D, 0xFF808182, 0xFFFFFFFF, 0xFFFDFDFC, 0xFFFCFCFB, 0xFFFCFCFB, 0xFFFCFCFB, 0xFFFCFCFB, 0xFFFCFCFB, 0xFFFCFCFB, 0xFFFCFCFB, 0xFFFCFCFB, 0xFFFCFCFB, 0xFFFCFCFB, 0xFFFCFCFB, 0xFFFCFCFB, 0xFFFCFCFB, 0xFFFCFCFB, 0xFFFCFCFB, 0xFFFCFCFB, 0xFFFCFCFB, 
        0xFFFCFCFB, 0xFFFCFCFB, 0xFFFCFCFB, 0xFFFCFCFB, 0xFFFCFCFB, 0xFFFCFCFB, 0xFFFCFCFB, 0xFFEEEEEF, 0xFF707174, 0xD9020303, 0x81000000, 0x40000000, 0x0F000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x8D1C1E1F, 0xFFA6A8A7, 0xFFFFFFFF, 0xFFFBFBF9, 0xFFFBFBF9, 0xFFFBFBF9, 0xFFFBFBF9, 0xFFFBFBF9, 0xFFFBFBF9, 0xFFFBFBF9, 0xFFFBFBF9, 0xFFFBFBF9, 0xFFFBFBF9, 0xFFFBFBF9, 0xFFFBFBF9, 0xFFFBFBF9, 0xFFFBFBF9, 0xFFFBFBF9, 0xFFFBFBF9, 0xFFFBFBF9, 
        0xFFFBFBF9, 0xFFFBFBF9, 0xFFFBFBF9, 0xFFFBFBF9, 0xFFFBFBF9, 0xFFFBFBF9, 0xFFFCFCFA, 0xFFFAFAF8, 0xFFD6D7D8, 0xFF4A4C4E, 0xC5000101, 0x72000000, 0x30000000, 0x05000000,
  0x570A0A0B, 0xFF777879, 0xFFFFFFFE, 0xFFFBFBFA, 0xFFFAFBF9, 0xFFFAFBF9, 0xFFFAFBF9, 0xFFFAFBF9, 0xFFFAFBF9, 0xFFFAFBF9, 0xFFFAFBF9, 0xFFFAFBF9, 0xFFFAFBF9, 0xFFFAFBF9, 0xFFFAFBF9, 0xFFFAFBF9, 0xFFFAFBF9, 0xFFFAFBF9, 0xFFFAFBF9, 0xFFFAFBF9, 0xFFFAFBF9, 
        0xFFFAFBF9, 0xFFFAFBF9, 0xFFFAFBF9, 0xFFFAFBF9, 0xFFFAFBF9, 0xFFFAFBF9, 0xFFFBFCFA, 0xFFEEEEEF, 0xFF747579, 0xDB040506, 0x81000000, 0x3F000000, 0x0F000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000F0F0F, 0x00686868, 0x00070707, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x93242527, 0xFFABADAC, 0xFFFFFFFF, 0xFFF8F9F7, 0xFFF8F9F7, 0xFFF8F9F7, 0xFFF8F9F7, 0xFFF8F9F7, 0xFFF8F9F7, 0xFFF8F9F7, 0xFFF8F9F7, 0xFFF8F9F7, 0xFFF8F9F7, 0xFFF8F9F7, 0xFFF8F9F7, 0xFFF8F9F7, 0xFFF8F9F7, 0xFFF8F9F7, 0xFFF8F9F7, 0xFFF8F9F7, 
        0xFFF8F9F7, 0xFFF8F9F7, 0xFFF8F9F7, 0xFFF8F9F7, 0xFFF8F9F7, 0xFFF8F9F7, 0xFFF9FAF8, 0xFFF7F8F6, 0xFFD1D1D2, 0xFF444649, 0xC3010102, 0x72000000, 0x30000000, 0x05000000,
  0x510A0B0B, 0xFF6E7070, 0xFFFCFCFB, 0xFFFAFAF9, 0xFFF8F9F8, 0xFFF8F9F8, 0xFFF8F9F8, 0xFFF8F9F8, 0xFFF8F9F8, 0xFFF8F9F8, 0xFFF8F9F8, 0xFFF8F9F8, 0xFFF8F9F7, 0xFFF8F9F7, 0xFFF8F9F7, 0xFFF8F8F7, 0xFFF8F8F7, 0xFFF8F8F7, 0xFFF8F8F7, 0xFFF8F8F7, 0xFFF8F8F7, 
        0xFFF8F8F7, 0xFFF8F8F7, 0xFFF8F8F7, 0xFFF8F8F7, 0xFFF8F8F7, 0xFFF8F8F7, 0xFFF9F9F8, 0xFFEEEFEE, 0xFF7B7C7F, 0xDE070809, 0x83000000, 0x40000000, 0x0F000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x006B6B6B, 0x00FFFFFF, 0x00A2A2A2, 0x00050505, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00010101, 
        0x9C303132, 0xFFB3B4B4, 0xFFFEFFFE, 0xFFF5F6F4, 0xFFF5F6F4, 0xFFF5F6F4, 0xFFF5F6F4, 0xFFF5F6F4, 0xFFF5F6F4, 0xFFF5F6F4, 0xFFF5F6F4, 0xFFF5F6F4, 0xFFF5F6F4, 0xFFF5F6F4, 0xFFF5F6F4, 0xFFF5F6F4, 0xFFF5F6F4, 0xFFF5F6F4, 0xFFF5F6F4, 0xFFF5F6F4, 
        0xFFF5F6F4, 0xFFF5F6F4, 0xFFF5F6F4, 0xFFF5F6F4, 0xFFF5F6F4, 0xFFF5F6F4, 0xFFF6F7F5, 0xFFF3F4F2, 0xFFCACCCD, 0xFF404144, 0xC1010202, 0x72000000, 0x30000000, 0x05000000,
  0x480B0C0C, 0xFF666869, 0xFFF7F8F7, 0xFFF8F9F7, 0xFFF6F7F5, 0xFFF6F7F5, 0xFFF6F7F5, 0xFFF6F7F5, 0xFFF6F7F5, 0xFFF6F7F5, 0xFFF6F7F5, 0xFFF6F7F5, 0xFFF6F7F5, 0xFFF6F7F5, 0xFFF6F7F5, 0xFFF6F6F5, 0xFFF6F6F5, 0xFFF6F6F5, 0xFFF6F6F5, 0xFFF6F6F5, 0xFFF6F6F5, 
        0xFFF5F6F5, 0xFFF5F6F5, 0xFFF5F6F5, 0xFFF5F6F4, 0xFFF6F6F4, 0xFFF5F6F4, 0xFFF6F7F5, 0xFFECEEED, 0xFF86888A, 0xE40D0E10, 0x86000000, 0x42000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x000D0D0D, 0x002B2B2B, 0x0069696A, 0x00F2F2F3, 0x00F4F4F4, 0x00A2A2A3, 0x00060605, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00010101, 
        0xAD3F4042, 0xFFC0C1C0, 0xFFFAFBF9, 0xFFF1F2F0, 0xFFF1F2F0, 0xFFF1F2F0, 0xFFF1F2F0, 0xFFF1F2F0, 0xFFF1F2F0, 0xFFF1F2F0, 0xFFF1F2F0, 0xFFF1F2F0, 0xFFF1F2F0, 0xFFF1F2F0, 0xFFF1F2F0, 0xFFF1F2F0, 0xFFF1F2F0, 0xFFF1F2F0, 0xFFF1F2F0, 0xFFF1F2F0, 
        0xFFF1F2F0, 0xFFF1F2F0, 0xFFF1F2F0, 0xFFF1F2F0, 0xFFF1F2F0, 0xFFF1F2F0, 0xFFF2F3F1, 0xFFEFF0EF, 0xFFC3C4C6, 0xFF3A3B3E, 0xBE010202, 0x72000000, 0x2F000000, 0x05000000,
  0x3E0C0D0E, 0xFD5E5F60, 0xFFF2F3F2, 0xFFF6F6F5, 0xFFF4F4F3, 0xFFF4F4F3, 0xFFF4F4F3, 0xFFF4F4F3, 0xFFF4F4F3, 0xFFF4F4F3, 0xFFF4F4F3, 0xFFF4F4F3, 0xFFF4F4F3, 0xFFF4F4F3, 0xFFF4F4F3, 0xFFF4F5F3, 0xFFF4F5F3, 0xFFF4F5F3, 0xFFF4F5F3, 0xFFF4F5F3, 0xFFF4F5F3, 
        0xFFF3F5F3, 0xFFF3F5F3, 0xFFF3F4F3, 0xFFF3F4F3, 0xFFF3F4F3, 0xFFF2F4F2, 0xFFF3F5F3, 0xFFEBECEC, 0xFF949597, 0xEA141416, 0x8B000000, 0x45000000, 0x12000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00050505, 0x00ADADAE, 0x006C6C6C, 0x005D5D5E, 0x00F1F1F2, 0x00E3E3E3, 0x00F6F6F7, 0x00A4A4A5, 0x00060606, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01010101, 
        0xBD464849, 0xFFC9CACA, 0xFFF6F7F5, 0xFFEFF0EE, 0xFFEFF0EE, 0xFFEFF0EE, 0xFFEFF0EE, 0xFFEFF0EE, 0xFFEFF0EE, 0xFFEFF0EE, 0xFFEFF0EE, 0xFFEFF0EE, 0xFFEFF0EE, 0xFFEFF0EE, 0xFFEFF0EE, 0xFFEFF0EE, 0xFFEFF0EE, 0xFFEFF0EE, 0xFFEFF0EE, 0xFFEFF0EE, 
        0xFFEFF0EE, 0xFFEFF0EE, 0xFFEFF0EE, 0xFFEFF0EE, 0xFFEFF0EE, 0xFFEFF0EE, 0xFFF0F1EF, 0xFFEBECEA, 0xFFBBBCBE, 0xFF343538, 0xBA010202, 0x70000000, 0x2E000000, 0x04000000,
  0x300E0F10, 0xF9555758, 0xFFEEEFEE, 0xFFF4F5F4, 0xFFF2F3F1, 0xFFF2F3F1, 0xFFF2F3F1, 0xFFF2F3F1, 0xFFF2F3F1, 0xFFF2F3F1, 0xFFF2F3F1, 0xFFF2F3F1, 0xFFF2F3F1, 0xFFF2F3F1, 0xFFF2F3F1, 0xFFF2F3F1, 0xFFF2F3F1, 0xFFF2F3F1, 0xFFF2F3F1, 0xFFF2F3F1, 0xFFF2F3F1, 
        0xFFF2F3F1, 0xFFF2F3F1, 0xFFF2F3F1, 0xFFF2F2F2, 0xFFF1F1F2, 0xFFF1F1F1, 0xFFF2F2F2, 0xFFEBECEC, 0xFFA4A5A7, 0xF21B1C1E, 0x90000000, 0x49000000, 0x15000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00050505, 0x009D9D9D, 0x00FDFDFE, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00F8F8F9, 0x00A4A4A4, 0x00060606, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x07000000, 
        0xD14B4D4E, 0xFFD4D6D5, 0xFFF2F3F2, 0xFFECEEEC, 0xFFECEEEC, 0xFFECEEEC, 0xFFECEEEC, 0xFFECEEEC, 0xFFECEEEC, 0xFFECEEEC, 0xFFECEEEC, 0xFFECEEEC, 0xFFECEEEC, 0xFFECEEEC, 0xFFECEEEC, 0xFFECEEEC, 0xFFECEEEC, 0xFFECEEEC, 0xFFECEEEC, 0xFFECEEEC, 
        0xFFECEEEC, 0xFFECEEEC, 0xFFECEEEC, 0xFFECEEEC, 0xFFECEEEC, 0xFFECEEEC, 0xFFEDEFED, 0xFFE7E8E7, 0xFFB4B5B7, 0xFF2D2F31, 0xB4010102, 0x6D000000, 0x2C000000, 0x04000000,
  0x1F0B0B0B, 0xF44B4D4D, 0xFFEAEBEA, 0xFFF4F5F3, 0xFFF1F2F0, 0xFFF1F2F0, 0xFFF1F2F0, 0xFFF1F2F1, 0xFFF0F2F0, 0xFFF0F2F0, 0xFFF0F2F0, 0xFFF0F2F0, 0xFFF0F2F0, 0xFFF0F2F0, 0xFFF0F2F0, 0xFFF0F2F0, 0xFFF0F2F0, 0xFFF0F2F0, 0xFFF0F2F0, 0xFFF0F2F0, 0xFFF0F2F0, 
        0xFFF0F2F0, 0xFFF0F2F0, 0xFFF0F2F0, 0xFFF0F2F0, 0xFFF0F1F0, 0xFFF1F1F0, 0xFFF2F2F1, 0xFFECEDED, 0xFFB7B9BB, 0xFA252729, 0x97000000, 0x4F000000, 0x18000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00060606, 0x009C9C9C, 0x00EDEDED, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00F8F8F8, 0x00A4A4A4, 0x001F1F1F, 0x000E0F0F, 0x00161717, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 
        0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 
        0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00171818, 0x00161717, 0x0F141616, 
        0xEA585A5A, 0xFFE2E4E3, 0xFFEEF0EE, 0xFFEBEDEA, 0xFFEBEDEA, 0xFFEBEDEA, 0xFFEBEDEA, 0xFFEBEDEA, 0xFFEBEDEA, 0xFFEBEDEA, 0xFFEBEDEA, 0xFFEBEDEA, 0xFFEBEDEA, 0xFFEBEDEA, 0xFFEBEDEA, 0xFFEBEDEA, 0xFFEBEDEA, 0xFFEBEDEA, 0xFFEBEDEA, 0xFFEBEDEA, 
        0xFFEBEDEA, 0xFFEBEDEA, 0xFFEBEDEA, 0xFFEBEDEA, 0xFFEBEDEA, 0xFFEBEDEA, 0xFFECEEEB, 0xFFE3E5E4, 0xFFACAEB0, 0xFD26282B, 0xAD010000, 0x6A000000, 0x29000000, 0x04000000,
  0x12000000, 0xE8414344, 0xFFE1E2E1, 0xFFF4F5F4, 0xFFEFF0F0, 0xFFEFF0F0, 0xFFEFF0F0, 0xFFEFF0F0, 0xFFEFF0EF, 0xFFEFF0EF, 0xFFEFF0EF, 0xFFEFF0EF, 0xFFEFF0EF, 0xFFEFF0EF, 0xFFEFF0EF, 0xFFEFF0EF, 0xFFEFF0EF, 0xFFEFF0EF, 0xFFEFF0EF, 0xFFEFF0EF, 0xFFEFF0EF, 
        0xFFEFF0EF, 0xFFEFF0EF, 0xFFEFF0EF, 0xFFEFF0EF, 0xFFEFF0EF, 0xFFEFF0EF, 0xFFF0F1F0, 0xFFEDEEEE, 0xFFC5C6C8, 0xFF37383A, 0xA6020203, 0x54000000, 0x1C000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00070707, 
        0x009C9C9D, 0x00EEEEEE, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00F2F2F3, 0x00E6E7E7, 0x00595A5B, 0x001F2021, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 
        0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 
        0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x00232425, 0x28353737, 
        0xF878797A, 0xFFE8E9E8, 0xFFEBEDEB, 0xFFE9EAE9, 0xFFE9EAE9, 0xFFE9EAE9, 0xFFE9EAE9, 0xFFE9EAE9, 0xFFE9EAE9, 0xFFE9EAE9, 0xFFE9EAE9, 0xFFE9EAE9, 0xFFE9EAE9, 0xFFE9EAE9, 0xFFE9EAE9, 0xFFE9EAE9, 0xFFE9EAE9, 0xFFE9EAE9, 0xFFE9EAE9, 0xFFE9EAE9, 
        0xFFE9EAE9, 0xFFE9EAE9, 0xFFE9EAE9, 0xFFE9EAE9, 0xFFE9EAE9, 0xFFE9EAE9, 0xFFEAEBEA, 0xFFDFE1E0, 0xFFA0A2A6, 0xFA212325, 0xA6000000, 0x66000000, 0x25000000, 0x03000000,
  0x0B000101, 0xD43C3D3E, 0xFFD0D1D2, 0xFFF4F5F5, 0xFFEEEFEF, 0xFFEEEFEF, 0xFFEEEFEF, 0xFFEEEEEF, 0xFFEEEEEF, 0xFFEEEEEE, 0xFFEDEEEE, 0xFFEDEEEE, 0xFFEDEEEE, 0xFFEDEEEE, 0xFFEDEEEE, 0xFFEDEEEE, 0xFFEDEEEE, 0xFFEDEEEE, 0xFFEDEDEE, 0xFFEDEDEE, 0xFFEDEDEE, 
        0xFFEDEDEE, 0xFFEDEDEE, 0xFFEDEDEE, 0xFFEDEDEE, 0xFFEDEDEE, 0xFFEDEDEE, 0xFFEDEEEE, 0xFFECEDED, 0xFFD0D1D3, 0xFF505154, 0xB6060607, 0x5B000000, 0x21000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000F0F0F, 
        0x00DBDBDC, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00F9F9F9, 0x00ADAEAE, 0x00010101, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4D232425, 
        0xFF959898, 0xFFEBECEC, 0xFFE8E9E9, 0xFFE6E7E8, 0xFFE6E7E8, 0xFFE6E7E8, 0xFFE6E7E8, 0xFFE6E7E8, 0xFFE6E7E8, 0xFFE6E7E8, 0xFFE6E7E8, 0xFFE6E7E8, 0xFFE6E7E8, 0xFFE6E7E8, 0xFFE6E7E8, 0xFFE6E7E8, 0xFFE6E7E8, 0xFFE6E7E8, 0xFFE6E7E8, 0xFFE6E7E8, 
        0xFFE6E7E8, 0xFFE6E7E8, 0xFFE6E7E8, 0xFFE6E7E8, 0xFFE6E7E8, 0xFFE6E7E8, 0xFFE7E8E9, 0xFFDBDCDD, 0xFF8F9196, 0xF31E1F21, 0xA2000000, 0x62000000, 0x22000000, 0x01000000,
  0x03010102, 0xBB363839, 0xFFBCBEBE, 0xFFF4F5F5, 0xFFEBEDED, 0xFFEBEDED, 0xFFEBEDED, 0xFFEBEDED, 0xFFEBEDED, 0xFFEBEEED, 0xFFEBEEED, 0xFFEBEEEE, 0xFFEBEDED, 0xFFEBEDED, 0xFFEAEDED, 0xFFEAEDED, 0xFFEAECEC, 0xFFEAECEC, 0xFFEAECEC, 0xFFEAECEC, 0xFFEBECEC, 
        0xFFEBECEC, 0xFFEBECEC, 0xFFEBECEC, 0xFFEBECEC, 0xFFEBECEC, 0xFFEBECEC, 0xFFEBECEC, 0xFFEBECEC, 0xFFDBDDDF, 0xFF6B6D70, 0xC80A0A0B, 0x63000000, 0x28000000, 0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00E9E9E9, 0x00F7F9F9, 0x00A6A7A7, 0x00292A2A, 0x001C1D1E, 0x00242526, 0x00252526, 0x00252526, 
        0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 
        0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00252526, 0x00232324, 0x74393A3B, 
        0xFFA8AAAB, 0xFFEEF0F0, 0xFFE4E6E6, 0xFFE3E6E5, 0xFFE3E6E5, 0xFFE3E6E5, 0xFFE3E6E5, 0xFFE3E6E5, 0xFFE3E6E5, 0xFFE3E6E5, 0xFFE3E6E5, 0xFFE3E6E5, 0xFFE3E6E5, 0xFFE3E6E5, 0xFFE3E6E5, 0xFFE3E6E5, 0xFFE3E6E5, 0xFFE3E6E5, 0xFFE3E6E5, 0xFFE3E6E5, 
        0xFFE3E6E5, 0xFFE3E6E5, 0xFFE3E6E5, 0xFFE3E6E5, 0xFFE3E6E5, 0xFFE3E6E5, 0xFFE4E6E6, 0xFFD4D6D7, 0xFF7E8085, 0xEB191A1C, 0x9C000000, 0x5C000000, 0x1E000000, 0x01000000,
  0x00010102, 0xA1333435, 0xFFACAEAF, 0xFFF3F6F6, 0xFFEAEBEC, 0xFFEAEBEC, 0xFFEAEBEC, 0xFFE9EBEC, 0xFFE9EBEC, 0xFFE9EBEC, 0xFFE9EBEC, 0xFFE9EBEB, 0xFFE9EAEB, 0xFFE9EAEB, 0xFFE9EAEB, 0xFFE9EBEB, 0xFFE9EBEB, 0xFFE9EBEB, 0xFFE9EBEB, 0xFFE9EBEB, 0xFFE9EBEB, 
        0xFFE9EBEB, 0xFFE9EBEB, 0xFFE9EBEB, 0xFFE9EBEB, 0xFFE9EBEB, 0xFFE9EBEB, 0xFFE9EBEB, 0xFFE9EBEC, 0xFFE1E4E5, 0xFF86888B, 0xDB171719, 0x71000000, 0x30000000, 0x09000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000E0E0E, 0x002F2F2F, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00F5F6F6, 0x00EBEDED, 0x00676869, 0x002A2B2C, 0x002E2F30, 0x002F2F30, 
        0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 
        0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x002F2F30, 0x00303031, 0x9D636566, 
        0xFFBCBEBF, 0xFFEAEDED, 0xFFE1E3E3, 0xFFE1E3E4, 0xFFE1E3E4, 0xFFE1E3E4, 0xFFE1E3E4, 0xFFE1E3E4, 0xFFE1E3E4, 0xFFE1E3E4, 0xFFE1E3E4, 0xFFE1E3E4, 0xFFE1E3E4, 0xFFE1E3E4, 0xFFE1E3E4, 0xFFE1E3E4, 0xFFE1E3E4, 0xFFE1E3E4, 0xFFE1E3E4, 0xFFE1E3E4, 
        0xFFE1E3E4, 0xFFE1E3E4, 0xFFE1E3E4, 0xFFE1E3E4, 0xFFE1E3E4, 0xFFE1E4E4, 0xFFE1E3E4, 0xFFCBCED1, 0xFF707276, 0xE3131516, 0x94000000, 0x55000000, 0x1A000000, 0x01000000,
  0x00000000, 0x84222323, 0xFF9EA0A1, 0xFFF3F4F5, 0xFFE8EAEA, 0xFFE8E9EA, 0xFFE8E9EA, 0xFFE8E9EA, 0xFFE8E9EA, 0xFFE8E9EA, 0xFFE8E9EA, 0xFFE8E9EA, 0xFFE8E9E9, 0xFFE7E9E9, 0xFFE8E9EA, 0xFFE8E9EA, 0xFFE7E9EA, 0xFFE7E9EA, 0xFFE7E9EA, 0xFFE7E9EA, 0xFFE7E9EA, 
        0xFFE7E9EA, 0xFFE6E9EA, 0xFFE6E9EA, 0xFFE6E9EA, 0xFFE6E9E9, 0xFFE6E9E9, 0xFFE6E8E9, 0xFFE7E9EA, 0xFFE2E3E6, 0xFFA4A6AB, 0xEF2A2B2E, 0x80000000, 0x39000000, 0x0D000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001E1E1E, 0x00646464, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00FAFBFB, 0x00ACADAD, 0x000E0E0D, 0x00000000, 0x00010101, 
        0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 
        0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x00010101, 0x04050505, 0xCF707172, 
        0xFFD3D6D6, 0xFFE4E6E7, 0xFFDEE1E2, 0xFFDEE1E2, 0xFFDEE1E2, 0xFFDEE1E2, 0xFFDEE1E2, 0xFFDEE1E2, 0xFFDEE1E2, 0xFFDEE1E2, 0xFFDEE1E2, 0xFFDEE1E2, 0xFFDEE1E2, 0xFFDEE1E2, 0xFFDEE1E2, 0xFFDEE1E2, 0xFFDEE1E2, 0xFFDEE1E2, 0xFFDEE1E2, 0xFFDEE1E2, 
        0xFFDEE1E2, 0xFFDEE1E2, 0xFFDEE1E2, 0xFFDEE1E2, 0xFFDEE1E2, 0xFFDFE2E3, 0xFFDEE0E1, 0xFFC3C5CA, 0xFF616368, 0xD80E0F10, 0x8B000000, 0x4D000000, 0x16000000, 0x00000000,
  0x00000000, 0x641C1C1C, 0xFF8B8D8E, 0xFFEBEDEE, 0xFFE6E9EA, 0xFFE6E8E9, 0xFFE6E8E9, 0xFFE6E8E9, 0xFFE5E8E9, 0xFFE5E8E9, 0xFFE5E8E9, 0xFFE5E8E9, 0xFFE5E8E9, 0xFFE5E8E9, 0xFFE5E8E8, 0xFFE4E7E8, 0xFFE5E7E8, 0xFFE4E7E8, 0xFFE4E7E8, 0xFFE4E7E8, 0xFFE4E6E8, 
        0xFFE4E6E8, 0xFFE4E6E8, 0xFFE3E6E8, 0xFFE3E6E8, 0xFFE3E6E8, 0xFFE3E6E8, 0xFFE3E6E8, 0xFFE4E7E9, 0xFFE1E5E6, 0xFFBEC1C5, 0xFD424447, 0x97050505, 0x44000000, 0x13000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00EBEBEB, 0x00F3F4F4, 0x00E1E2E2, 0x008A8B8B, 0x00555758, 
        0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 
        0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x005B5C5D, 0x215E6061, 0xF6898B8C, 
        0xFFDEE1E3, 0xFFDEE1E3, 0xFFDCDEE1, 0xFFDCDEE1, 0xFFDCDEE1, 0xFFDCDEE1, 0xFFDCDEE1, 0xFFDCDEE1, 0xFFDCDEE1, 0xFFDCDEE1, 0xFFDCDEE1, 0xFFDCDEE1, 0xFFDCDEE1, 0xFFDCDEE1, 0xFFDCDEE1, 0xFFDCDEE1, 0xFFDCDEE1, 0xFFDCDEE1, 0xFFDCDEE1, 0xFFDCDEE1, 
        0xFFDCDEE1, 0xFFDCDEE1, 0xFFDCDEE1, 0xFFDCDEE1, 0xFFDCDEE1, 0xFFDDDFE2, 0xFFD9DCDF, 0xFFB5B8BD, 0xFF525458, 0xCD0C0C0E, 0x85000000, 0x45000000, 0x12000000, 0x00000000,
  0x00000000, 0x431E1E1F, 0xFE767879, 0xFFE2E5E7, 0xFFE4E8EA, 0xFFE3E6E8, 0xFFE3E6E8, 0xFFE3E6E8, 0xFFE3E6E8, 0xFFE3E6E8, 0xFFE3E6E8, 0xFFE3E6E8, 0xFFE3E5E8, 0xFFE2E5E7, 0xFFE2E5E6, 0xFFE2E5E6, 0xFFE2E5E6, 0xFFE2E5E6, 0xFFE2E5E7, 0xFFE2E5E7, 0xFFE2E3E7, 
        0xFFE2E4E7, 0xFFE1E4E7, 0xFFE1E4E6, 0xFFE1E4E6, 0xFFE1E4E6, 0xFFE1E4E6, 0xFFE1E4E6, 0xFFE1E4E7, 0xFFE1E4E6, 0xFFCDCFD4, 0xFF64666A, 0xB50F0F10, 0x50000000, 0x1B000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00F7F8F8, 0x00E5E5E6, 0x00222222, 
        0x00131313, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 
        0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x001A1A1A, 0x0019191A, 0x57444545, 0xFFACAFB0, 
        0xFFE1E3E6, 0xFFDADCDF, 0xFFD9DCDF, 0xFFD9DCDF, 0xFFD9DCDF, 0xFFD9DCDF, 0xFFD9DCDF, 0xFFD9DCDF, 0xFFD9DCDF, 0xFFD9DCDF, 0xFFD9DCDF, 0xFFD9DCDF, 0xFFD9DCDF, 0xFFD9DCDF, 0xFFD9DCDF, 0xFFD9DCDF, 0xFFD9DCDF, 0xFFD9DCDF, 0xFFD9DCDF, 0xFFD9DCDF, 
        0xFFD9DCDF, 0xFFD9DCDF, 0xFFD9DCDF, 0xFFD9DCDF, 0xFFD9DCDF, 0xFFDADDE0, 0xFFD3D6DA, 0xFFA6A9AF, 0xFF434549, 0xC0090A0A, 0x7E000000, 0x3D000000, 0x0D000000, 0x00000000,
  0x00000000, 0x1F0E0E0E, 0xF1636566, 0xFFDADEE0, 0xFFE4E6E9, 0xFFE0E3E7, 0xFFE0E3E6, 0xFFE0E3E6, 0xFFE1E3E6, 0xFFE1E3E6, 0xFFE1E3E6, 0xFFE1E3E6, 0xFFE1E3E6, 0xFFE1E2E6, 0xFFE1E2E5, 0xFFE0E3E5, 0xFFE0E3E5, 0xFFE0E3E5, 0xFFE0E3E4, 0xFFE0E3E5, 0xFFE0E2E5, 
        0xFFE0E1E5, 0xFFE0E1E5, 0xFFE0E1E5, 0xFFE0E1E5, 0xFFE0E1E5, 0xFFE0E1E5, 0xFFDFE1E5, 0xFFDFE1E5, 0xFFE0E2E5, 0xFFD7DADE, 0xFF87898D, 0xD5202123, 0x62000000, 0x26000000, 0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EFEFF0, 0x00E6E6E6, 
        0x006A6A6B, 0x002D2E2E, 0x00313131, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 
        0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00313132, 0x00343435, 0x98767879, 0xFFBEC0C2, 
        0xFFE0E3E6, 0xFFD6D9DD, 0xFFD6D9DD, 0xFFD6D9DD, 0xFFD6D9DD, 0xFFD6D9DD, 0xFFD6D9DD, 0xFFD6D9DD, 0xFFD6D9DD, 0xFFD6D9DD, 0xFFD6D9DD, 0xFFD6D9DD, 0xFFD6D9DD, 0xFFD6D9DD, 0xFFD6D9DD, 0xFFD6D9DD, 0xFFD6D9DD, 0xFFD6D9DD, 0xFFD6D9DD, 0xFFD6D9DD, 
        0xFFD6D9DD, 0xFFD6D9DD, 0xFFD6D9DD, 0xFFD6D9DD, 0xFFD6D9DD, 0xFFD7DADE, 0xFFCCD0D4, 0xFF979AA0, 0xFC37393C, 0xB1030303, 0x76000000, 0x33000000, 0x0A000000, 0x00000000,
  0x00000000, 0x0B010102, 0xD0555759, 0xFFC6C8CA, 0xFFE3E6EA, 0xFFDEE1E5, 0xFFDFE1E5, 0xFFDFE1E5, 0xFFDEE1E4, 0xFFDEE1E4, 0xFFDEE1E3, 0xFFDEE1E3, 0xFFDEE1E3, 0xFFDEE1E3, 0xFFDEE1E4, 0xFFDDE1E4, 0xFFDDE1E4, 0xFFDDE1E4, 0xFFDDE1E3, 0xFFDDE1E2, 0xFFDDE1E3, 
        0xFFDDE0E3, 0xFFDDE0E3, 0xFFDDE0E3, 0xFFDDE0E3, 0xFFDDE0E3, 0xFFDDDFE3, 0xFFDCDFE3, 0xFFDCDFE3, 0xFFDEE0E3, 0xFFD9DCE0, 0xFFAAABB1, 0xF23D3E41, 0x7A000000, 0x33000000, 0x0A000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00FEFEFF, 
        0x00AEAFAF, 0x000D0D0D, 0x00040404, 0x000B0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 
        0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x000C0C0C, 0x060E0E0E, 0xD78A8C8D, 0xFFD3D5D8, 
        0xFFD8DCE0, 0xFFD3D7DA, 0xFFD3D7DB, 0xFFD3D7DB, 0xFFD3D7DB, 0xFFD3D7DB, 0xFFD3D7DB, 0xFFD3D7DB, 0xFFD3D7DB, 0xFFD3D7DB, 0xFFD3D7DB, 0xFFD3D7DB, 0xFFD3D7DB, 0xFFD3D7DB, 0xFFD3D7DB, 0xFFD3D7DB, 0xFFD3D7DB, 0xFFD3D7DB, 0xFFD3D7DB, 0xFFD3D7DB, 
        0xFFD3D7DB, 0xFFD3D7DB, 0xFFD3D7DB, 0xFFD3D7DB, 0xFFD3D7DA, 0xFFD4D7DC, 0xFFC3C7CC, 0xFF83868C, 0xF12E2F32, 0xA6000000, 0x6B000000, 0x2B000000, 0x06000000, 0x00000000,
  0x00000000, 0x00020202, 0xA64A4B4C, 0xFFB1B4B7, 0xFFE4E6EA, 0xFFDDDFE2, 0xFFDCDFE2, 0xFFDCDFE2, 0xFFDCDFE2, 0xFFDCDFE2, 0xFFDCDFE2, 0xFFDCDFE2, 0xFFDCDFE2, 0xFFDCDEE2, 0xFFDCDEE2, 0xFFDCDEE2, 0xFFDCDEE2, 0xFFDCDEE2, 0xFFDBDEE1, 0xFFDBDEE1, 0xFFDBDEE0, 
        0xFFDBDEE0, 0xFFDBDEE0, 0xFFDBDEE0, 0xFFDBDDE0, 0xFFDBDDE0, 0xFFDBDDE0, 0xFFDBDDE0, 0xFFDBDDE0, 0xFFDCDEE1, 0xFFD9DDE0, 0xFFC1C4C9, 0xFF5F6165, 0x9E0E0E0F, 0x42000000, 0x12000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EEEEEF, 
        0x00F6F7F7, 0x00E9EAEA, 0x00737475, 0x002D2E2E, 0x00323333, 0x00333434, 0x00333334, 0x00333334, 0x00333334, 0x00333334, 0x00333334, 0x00333334, 0x00333334, 0x00333334, 0x00333334, 0x00333334, 0x00333334, 0x00333334, 0x00333334, 0x00333334, 
        0x00333334, 0x00333334, 0x00333334, 0x00333334, 0x00333334, 0x00333334, 0x00333334, 0x00333334, 0x00333334, 0x00333334, 0x00333334, 0x00333334, 0x00333334, 0x00333334, 0x00333334, 0x00333334, 0x00333334, 0x395B5C5C, 0xFCACADAE, 0xFFD9DCDF, 
        0xFFD3D6DB, 0xFFD0D4D9, 0xFFD0D4D9, 0xFFD0D4D9, 0xFFD0D4D9, 0xFFD0D4D9, 0xFFD0D4D9, 0xFFD0D4D9, 0xFFD0D4D9, 0xFFD0D4D9, 0xFFD0D4D9, 0xFFD0D4D9, 0xFFD0D4D9, 0xFFD0D4D9, 0xFFD0D4D9, 0xFFD0D4D9, 0xFFD0D4D9, 0xFFD0D4D9, 0xFFD0D4D9, 0xFFD0D4D9, 
        0xFFD0D4D9, 0xFFD0D4D9, 0xFFD0D4D9, 0xFFD0D4D9, 0xFFD1D4D9, 0xFFD0D3D8, 0xFFB9BCC2, 0xFF71737A, 0xE4232426, 0x9B000000, 0x60000000, 0x22000000, 0x04000000, 0x00000000,
  0x00000000, 0x00000000, 0x772D2D2E, 0xFFA0A2A5, 0xFFDFE3E6, 0xFFDADDE1, 0xFFDADDE1, 0xFFDADDE1, 0xFFDADDE1, 0xFFDADDE1, 0xFFDADDE0, 0xFFDADDE0, 0xFFDADDE0, 0xFFDADDE0, 0xFFDADCE0, 0xFFDADCE0, 0xFFDADCE0, 0xFFDADCE0, 0xFFD9DCDF, 0xFFD9DCDF, 0xFFD9DCDF, 
        0xFFD9DCDF, 0xFFD9DCDF, 0xFFD9DCDF, 0xFFD9DBDF, 0xFFD9DCDF, 0xFFD9DCDF, 0xFFD9DCDF, 0xFFD9DBDF, 0xFFD8DBDF, 0xFFD8DCE0, 0xFFCED1D6, 0xFF87898E, 0xC9262729, 0x54000000, 0x1E000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00FDFDFE, 0x00B9B9BA, 0x005F5F5F, 0x00434344, 0x00444445, 0x00454546, 0x00454546, 0x00454546, 0x00454546, 0x00454546, 0x00454546, 0x00454546, 0x00454546, 0x00454546, 0x00454546, 0x00454546, 0x00454546, 0x00454546, 0x00454546, 
        0x00454546, 0x00454546, 0x00454546, 0x00454546, 0x00454546, 0x00454546, 0x00454546, 0x00454546, 0x00454546, 0x00454546, 0x00454546, 0x00454546, 0x00454546, 0x00454546, 0x00454546, 0x00454546, 0x00434344, 0x876F6F70, 0xFFC4C6C8, 0xFFD7DBE0, 
        0xFFCED2D7, 0xFFCED2D6, 0xFFCED2D6, 0xFFCED2D6, 0xFFCED2D6, 0xFFCED2D6, 0xFFCED2D6, 0xFFCED2D6, 0xFFCED2D6, 0xFFCED2D6, 0xFFCED2D6, 0xFFCED2D6, 0xFFCED2D6, 0xFFCED2D6, 0xFFCED2D6, 0xFFCED2D6, 0xFFCED2D6, 0xFFCED2D6, 0xFFCED2D6, 0xFFCED2D6, 
        0xFFCED2D6, 0xFFCED2D6, 0xFFCED2D6, 0xFFCED2D6, 0xFFCFD3D8, 0xFFCBCFD4, 0xFFAAAEB6, 0xFF606269, 0xD418181A, 0x90000000, 0x53000000, 0x1A000000, 0x01000000, 0x00000000,
  0x00000000, 0x00000000, 0x44272728, 0xFE898B8D, 0xFFD6DADE, 0xFFD9DCE0, 0xFFD8DBDF, 0xFFD7DBDF, 0xFFD7DBDF, 0xFFD7DBDF, 0xFFD7DBDF, 0xFFD7DBDD, 0xFFD7DBDD, 0xFFD7DBDD, 0xFFD7DBDD, 0xFFD7DBDD, 0xFFD7DBDD, 0xFFD7DADD, 0xFFD7DADD, 0xFFD7DADD, 0xFFD7DADD, 
        0xFFD6DADE, 0xFFD6DADD, 0xFFD6DADD, 0xFFD6DADD, 0xFFD6DADD, 0xFFD6DADD, 0xFFD7DADD, 0xFFD6D9DD, 0xFFD5D9DD, 0xFFD6DADE, 0xFFD2D6DA, 0xFFA8AAAF, 0xF0494A4E, 0x71010102, 0x2C000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F0F0F1, 0x00FBFBFC, 0x00FFFFFF, 0x00C1C1C2, 0x00717273, 0x00797A7B, 0x007A7B7C, 0x007A7B7C, 0x007A7B7C, 0x007A7B7C, 0x007A7B7C, 0x007A7B7C, 0x007A7B7C, 0x007A7B7C, 0x007A7B7C, 0x007A7B7C, 0x007A7B7C, 0x007A7B7C, 0x007A7B7C, 
        0x007A7B7C, 0x007A7B7C, 0x007A7B7C, 0x007A7B7C, 0x007A7B7C, 0x007A7B7C, 0x007A7B7C, 0x007A7B7C, 0x007A7B7C, 0x007A7B7C, 0x007A7B7C, 0x007A7B7C, 0x007A7B7C, 0x007A7B7C, 0x007A7B7C, 0x00797A7B, 0x06818283, 0xD5A8A9AA, 0xFFCED1D3, 0xFFD1D5D9, 
        0xFFCBCFD3, 0xFFCBCFD3, 0xFFCBCFD3, 0xFFCBCFD3, 0xFFCBCFD3, 0xFFCBCFD3, 0xFFCBCFD3, 0xFFCBCFD3, 0xFFCBCFD3, 0xFFCBCFD3, 0xFFCBCFD3, 0xFFCBCFD3, 0xFFCBCFD3, 0xFFCBCFD3, 0xFFCBCFD3, 0xFFCBCFD3, 0xFFCBCFD3, 0xFFCBCFD3, 0xFFCBCFD3, 0xFFCBCFD3, 
        0xFFCBCFD3, 0xFFCBCFD3, 0xFFCBCFD3, 0xFFCBCFD3, 0xFFCCD0D5, 0xFFC5C9CE, 0xFF9A9EA4, 0xFF505257, 0xC20E0E10, 0x86000000, 0x46000000, 0x12000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x1A0C0C0D, 0xE8737476, 0xFFCCCFD3, 0xFFD9DBE0, 0xFFD6D8DD, 0xFFD5D8DD, 0xFFD5D8DD, 0xFFD5D8DD, 0xFFD5D8DC, 0xFFD5D8DC, 0xFFD5D8DC, 0xFFD5D8DC, 0xFFD5D8DC, 0xFFD5D8DC, 0xFFD5D7DC, 0xFFD5D7DC, 0xFFD5D7DC, 0xFFD5D7DC, 0xFFD5D7DC, 
        0xFFD4D7DC, 0xFFD4D7DC, 0xFFD4D7DC, 0xFFD4D7DC, 0xFFD4D7DB, 0xFFD5D7DB, 0xFFD4D6DB, 0xFFD4D6DB, 0xFFD3D6DB, 0xFFD4D6DB, 0xFFD3D6DB, 0xFFC0C3C9, 0xFF737478, 0xA1181819, 0x3C000000, 0x11000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F8F9F9, 0x00E3E3E4, 0x00202020, 0x000C0C0D, 0x00111111, 0x00121212, 0x00121212, 0x00121212, 0x00121212, 0x00121212, 0x00121212, 0x00121212, 0x00121212, 0x00121212, 0x00121212, 0x00121212, 0x00121212, 
        0x00121212, 0x00121212, 0x00121212, 0x00121212, 0x00121212, 0x00121212, 0x00121212, 0x00121212, 0x00121212, 0x00121212, 0x00121212, 0x00121212, 0x00121212, 0x00121212, 0x00121212, 0x00111112, 0x48595959, 0xFFC0C3C3, 0xFFD3D7DC, 0xFFCBCED4, 
        0xFFC8CCD2, 0xFFC8CCD2, 0xFFC8CCD2, 0xFFC8CCD2, 0xFFC8CCD2, 0xFFC8CCD2, 0xFFC8CCD2, 0xFFC8CCD2, 0xFFC8CCD2, 0xFFC8CCD2, 0xFFC8CCD2, 0xFFC8CCD2, 0xFFC8CCD2, 0xFFC8CCD2, 0xFFC8CCD2, 0xFFC8CCD2, 0xFFC8CCD2, 0xFFC8CCD2, 0xFFC8CCD2, 0xFFC8CCD2, 
        0xFFC8CCD2, 0xFFC8CCD2, 0xFFC8CCD2, 0xFFC8CCD2, 0xFFC9CDD3, 0xFFBCBFC7, 0xFF888B94, 0xF9434448, 0xB1030303, 0x7A000000, 0x38000000, 0x0C000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x05020202, 0xBA656668, 0xFFBABDC1, 0xFFD9DCE0, 0xFFD3D7DC, 0xFFD4D7DC, 0xFFD4D7DC, 0xFFD4D7DC, 0xFFD4D7DC, 0xFFD4D7DC, 0xFFD4D7DC, 0xFFD4D7DC, 0xFFD4D7DC, 0xFFD4D6DC, 0xFFD4D6DC, 0xFFD4D6DC, 0xFFD4D6DC, 0xFFD4D6DB, 0xFFD3D6DB, 
        0xFFD3D6DA, 0xFFD3D6DA, 0xFFD3D6DA, 0xFFD3D6DA, 0xFFD3D5DA, 0xFFD3D5DA, 0xFFD2D5DA, 0xFFD2D5DA, 0xFFD2D5DA, 0xFFD2D5DA, 0xFFD2D6DB, 0xFFCCCFD5, 0xFF999BA1, 0xD63D3E40, 0x55000000, 0x1E000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00E4E4E4, 0x00C0C0C1, 0x00979899, 0x009B9C9E, 0x009D9E9F, 0x009D9E9F, 0x009D9E9F, 0x009D9E9F, 0x009D9E9F, 0x009D9E9F, 0x009D9E9F, 0x009D9E9F, 0x009D9E9F, 0x009D9E9F, 0x009D9E9F, 
        0x009D9E9F, 0x009D9E9F, 0x009D9E9F, 0x009D9E9F, 0x009D9E9F, 0x009D9E9F, 0x009D9E9F, 0x009D9E9F, 0x009D9E9F, 0x009D9E9F, 0x009D9E9F, 0x009D9E9F, 0x009D9E9F, 0x009D9E9F, 0x009C9D9F, 0x00969799, 0xA5A5A6A6, 0xFFC9CBCE, 0xFFD0D4D9, 0xFFC7CBD0, 
        0xFFC7CBD1, 0xFFC7CBD1, 0xFFC7CBD1, 0xFFC7CBD1, 0xFFC7CBD1, 0xFFC7CBD1, 0xFFC7CBD1, 0xFFC7CBD1, 0xFFC7CBD1, 0xFFC7CBD1, 0xFFC7CBD1, 0xFFC7CBD1, 0xFFC7CBD1, 0xFFC7CBD1, 0xFFC7CBD1, 0xFFC7CBD1, 0xFFC7CBD1, 0xFFC7CBD1, 0xFFC7CBD1, 0xFFC7CBD1, 
        0xFFC7CBD1, 0xFFC7CBD1, 0xFFC7CBD1, 0xFFC7CBD1, 0xFFC7CBD1, 0xFFB0B5BC, 0xFF787A82, 0xEB35363A, 0xA4000000, 0x6B000000, 0x2B000000, 0x07000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x83454546, 0xFFAAACAF, 0xFFD6DADD, 0xFFD3D7DB, 0xFFD2D6DB, 0xFFD2D6DB, 0xFFD2D6DB, 0xFFD2D6DB, 0xFFD2D6DB, 0xFFD2D6DA, 0xFFD2D6D9, 0xFFD2D6D9, 0xFFD2D6D9, 0xFFD2D6D9, 0xFFD2D6D9, 0xFFD2D6DA, 0xFFD1D6D9, 0xFFD1D5D9, 
        0xFFD1D5D8, 0xFFD1D5D8, 0xFFD1D5D8, 0xFFD1D5D8, 0xFFD1D4D8, 0xFFD0D4D8, 0xFFD0D4D8, 0xFFD0D4D8, 0xFFD0D4D8, 0xFFD0D4D8, 0xFFD2D5D9, 0xFFCFD3D7, 0xFFB0B3B9, 0xFB6A6B70, 0x820D0D0E, 0x2E000000, 0x0A000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00FAFAFA, 0x00FFFFFF, 0x00858586, 0x00444445, 0x004D4E4E, 0x004D4E4E, 0x004D4E4E, 0x004D4E4E, 0x004D4E4E, 0x004D4E4E, 0x004D4E4E, 0x004D4E4E, 0x004D4E4E, 0x004D4E4E, 0x004D4E4E, 
        0x004D4E4E, 0x004D4E4E, 0x004D4E4E, 0x004D4E4E, 0x004D4E4E, 0x004D4E4E, 0x004D4E4E, 0x004D4E4E, 0x004D4E4E, 0x004D4E4E, 0x004D4E4E, 0x004D4E4E, 0x004D4E4E, 0x004D4E4E, 0x004C4D4D, 0x22757576, 0xF2C3C3C5, 0xFFD0D3D7, 0xFFC9CDD2, 0xFFC5CACE, 
        0xFFC5CACE, 0xFFC5CACE, 0xFFC5CACE, 0xFFC5CACE, 0xFFC5CACE, 0xFFC5CACE, 0xFFC5CACE, 0xFFC5CACE, 0xFFC5CACE, 0xFFC5CACE, 0xFFC5CACE, 0xFFC5CACE, 0xFFC5CACE, 0xFFC5CACE, 0xFFC5CACE, 0xFFC5CACE, 0xFFC5CACE, 0xFFC5CACE, 0xFFC5CACE, 0xFFC5CACE, 
        0xFFC5CACE, 0xFFC5CACE, 0xFFC5CACE, 0xFFC6CBCF, 0xFFC3C7CC, 0xFFA3A7AD, 0xFF696B73, 0xD8232426, 0x96000000, 0x5C000000, 0x20000000, 0x03000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x432A2A2C, 0xFD97989B, 0xFFCFD2D6, 0xFFD2D6DA, 0xFFD1D5D9, 0xFFD1D5D9, 0xFFD1D5D9, 0xFFD1D5D9, 0xFFD1D5D9, 0xFFD1D5D8, 0xFFD1D5D8, 0xFFD1D5D8, 0xFFD1D5D8, 0xFFD1D5D8, 0xFFD1D4D8, 0xFFD0D4D7, 0xFFD0D4D7, 0xFFD0D3D7, 
        0xFFD0D3D7, 0xFFD0D3D7, 0xFFCFD3D7, 0xFFCFD2D7, 0xFFCFD3D7, 0xFFCFD3D7, 0xFFCFD3D7, 0xFFCFD3D7, 0xFFCFD3D7, 0xFFCFD3D7, 0xFFCFD3D8, 0xFFC9CDD2, 0xFFBBBFC5, 0xFF919399, 0xC239393B, 0x44000000, 0x16000000, 0x02000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00FBFBFB, 0x00BBBBBB, 0x002A2A29, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x86818181, 0xFFD3D4D6, 0xFFCED2D7, 0xFFC5C8CD, 0xFFC4C7CD, 
        0xFFC4C7CD, 0xFFC4C7CD, 0xFFC4C7CD, 0xFFC4C7CD, 0xFFC4C7CD, 0xFFC4C7CD, 0xFFC4C7CD, 0xFFC4C7CD, 0xFFC4C7CD, 0xFFC4C7CD, 0xFFC4C7CD, 0xFFC4C7CD, 0xFFC4C7CD, 0xFFC4C7CD, 0xFFC4C7CD, 0xFFC4C7CD, 0xFFC4C7CD, 0xFFC4C7CD, 0xFFC4C7CD, 0xFFC4C7CD, 
        0xFFC4C7CD, 0xFFC4C7CD, 0xFFC4C7CD, 0xFFC5C9CE, 0xFFBCC0C6, 0xFF92959D, 0xFF5B5D62, 0xC3111112, 0x8B000000, 0x4C000000, 0x16000000, 0x01000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x15070707, 0xDE808183, 0xFFC4C7CB, 0xFFD1D5DA, 0xFFCFD3D7, 0xFFD0D3D8, 0xFFD0D3D8, 0xFFD0D3D8, 0xFFD0D3D7, 0xFFD0D3D7, 0xFFD0D3D7, 0xFFD0D3D7, 0xFFD0D3D7, 0xFFD0D2D7, 0xFFCFD2D7, 0xFFCFD2D6, 0xFFCFD2D6, 0xFFCFD2D6, 
        0xFFCED2D5, 0xFFCED2D5, 0xFFCED1D5, 0xFFCED1D5, 0xFFCED1D5, 0xFFCED1D5, 0xFFCED1D6, 0xFFCED1D6, 0xFFCDD1D6, 0xFFCED1D6, 0xFFC8CCD1, 0xFFC2C6CC, 0xFFC0C4CA, 0xFFAAADB3, 0xF56E6F73, 0x710A0A0B, 0x26000000, 0x07000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F4F4F4, 0x00FFFFFF, 0x00C2C2C2, 0x00707070, 0x005F5F5F, 0x00606061, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 
        0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00636363, 0x00616162, 0x15656566, 0xE5C4C5C6, 0xFFD1D4D7, 0xFFC7CBD1, 0xFFC2C6CB, 0xFFC2C6CC, 
        0xFFC2C6CC, 0xFFC2C6CC, 0xFFC2C6CC, 0xFFC2C6CC, 0xFFC2C6CC, 0xFFC2C6CC, 0xFFC2C6CC, 0xFFC2C6CC, 0xFFC2C6CC, 0xFFC2C6CC, 0xFFC2C6CC, 0xFFC2C6CC, 0xFFC2C6CC, 0xFFC2C6CC, 0xFFC2C6CC, 0xFFC2C6CC, 0xFFC2C6CC, 0xFFC2C6CC, 0xFFC2C6CC, 0xFFC2C6CC, 
        0xFFC2C6CC, 0xFFC2C6CC, 0xFFC1C5CB, 0xFFC2C6CC, 0xFFB1B5BC, 0xFF81848C, 0xF64D4E53, 0xAF020302, 0x7D000000, 0x3B000000, 0x0E000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x02010101, 0xA4646567, 0xFFB6B8BC, 0xFFD1D3D9, 0xFFCFD1D6, 0xFFCED1D6, 0xFFCED1D6, 0xFFCED1D6, 0xFFCED1D5, 0xFFCED1D5, 0xFFCED1D5, 0xFFCED1D4, 0xFFCFD1D4, 0xFFCED0D4, 0xFFCED0D4, 0xFFCED0D4, 0xFFCDD0D5, 0xFFCDD0D5, 
        0xFFCDD0D4, 0xFFCDD0D4, 0xFFCECFD4, 0xFFCED0D4, 0xFFCDCFD4, 0xFFCDCFD4, 0xFFCCCFD4, 0xFFCCCFD4, 0xFFCDD0D4, 0xFFCACDD1, 0xFFC1C5CA, 0xFFC0C4C9, 0xFFC1C5CA, 0xFFB8BCC1, 0xFF97999D, 0xB93C3D3F, 0x3B000000, 0x12000000, 0x01000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F4F4F4, 0x00FEFFFF, 0x00FFFFFF, 0x00ECEDED, 0x00C9CBCB, 0x00C5C7C7, 0x00C5C7C7, 0x00C5C7C7, 0x00C5C7C7, 0x00C5C7C7, 0x00C5C7C7, 0x00C5C7C7, 0x00C5C7C7, 
        0x00C5C7C7, 0x00C5C7C7, 0x00C5C7C7, 0x00C5C7C7, 0x00C5C7C7, 0x00C5C7C7, 0x00C5C7C7, 0x00C5C7C7, 0x00C5C7C7, 0x00C5C7C7, 0x00C5C7C7, 0x00C5C7C7, 0x00C5C7C7, 0x00CBCDCD, 0x7CD2D4D4, 0xFFCFD1D2, 0xFFCCD0D4, 0xFFC2C6CB, 0xFFC0C4CA, 0xFFC0C4CA, 
        0xFFC0C4CA, 0xFFC0C4CA, 0xFFC0C4CA, 0xFFC0C4CA, 0xFFC0C4CA, 0xFFC0C4CA, 0xFFC0C4CA, 0xFFC0C4CA, 0xFFC0C4CA, 0xFFC0C4CA, 0xFFC0C4CA, 0xFFC0C4CA, 0xFFC0C4CA, 0xFFC0C4CA, 0xFFC0C4CA, 0xFFC0C4CA, 0xFFC0C4CA, 0xFFC0C4CA, 0xFFC0C4CA, 0xFFC0C4CA, 
        0xFFC0C4CA, 0xFFC0C4CA, 0xFFC1C5CA, 0xFFBFC3C9, 0xFFA3A7AE, 0xFF75787F, 0xE337383B, 0xA1000000, 0x6B000000, 0x2B000000, 0x07000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x613C3C3E, 0xFFA9AAAE, 0xFFCBCED2, 0xFFCDD1D6, 0xFFCDD0D5, 0xFFCDD0D4, 0xFFCDD0D4, 0xFFCDCFD4, 0xFFCDCFD4, 0xFFCDD0D4, 0xFFCDCFD4, 0xFFCCCED4, 0xFFCCCFD4, 0xFFCCCFD4, 0xFFCBCFD4, 0xFFCCCFD3, 0xFFCCCFD3, 
        0xFFCCCFD4, 0xFFCCCFD4, 0xFFCCCED3, 0xFFCCCED3, 0xFFCACED3, 0xFFCBCED3, 0xFFCBCED2, 0xFFCBCED3, 0xFFC9CDD2, 0xFFC0C4C9, 0xFFBEC2C8, 0xFFBFC3C8, 0xFFBFC3C9, 0xFFBDC1C7, 0xFFABAFB5, 0xF67B7D80, 0x6D0D0D0E, 0x22000000, 0x06000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F6F6, 0x00FAFAFA, 0x00FEFEFE, 0x00767777, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x17636465, 0xE7DDDEDF, 0xFFD0D3D7, 0xFFC4C8CE, 0xFFBEC2C8, 0xFFBFC3C8, 0xFFBFC3C8, 
        0xFFBFC3C8, 0xFFBFC3C8, 0xFFBFC3C8, 0xFFBFC3C8, 0xFFBFC3C8, 0xFFBFC3C8, 0xFFBFC3C8, 0xFFBFC3C8, 0xFFBFC3C8, 0xFFBFC3C8, 0xFFBFC3C8, 0xFFBFC3C8, 0xFFBFC3C8, 0xFFBFC3C8, 0xFFBFC3C8, 0xFFBFC3C8, 0xFFBFC3C8, 0xFFBFC3C8, 0xFFBFC3C8, 0xFFBFC3C8, 
        0xFFBFC3C8, 0xFFBFC3C8, 0xFFC0C4CA, 0xFFB8BCC2, 0xFF92969E, 0xFF6A6C73, 0xCE1F1F22, 0x94000000, 0x58000000, 0x1D000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x22151516, 0xEB939396, 0xFFC2C5C9, 0xFFCCD0D5, 0xFFCBCFD3, 0xFFCBCED3, 0xFFCBCED3, 0xFFCBCED3, 0xFFCBCED3, 0xFFCBCED3, 0xFFCBCDD3, 0xFFCACED3, 0xFFCACED3, 0xFFCACED3, 0xFFCACED2, 0xFFCACED2, 0xFFCACED2, 
        0xFFCACED2, 0xFFCACDD2, 0xFFCACDD1, 0xFFCACDD1, 0xFFCACDD1, 0xFFCACDD1, 0xFFC9CDD1, 0xFFC9CDD1, 0xFFC0C4C9, 0xFFBCC0C6, 0xFFBDC1C7, 0xFFBDC1C7, 0xFFBDC1C7, 0xFFBDC1C7, 0xFFB5BAC0, 0xFFA2A4A9, 0xBF4D4E51, 0x3A000000, 0x12000000, 0x01000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F6F6, 0x00F9F9F9, 0x00FDFDFD, 0x00B9B9BA, 0x00777878, 0x005D5D5D, 0x005C5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 
        0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5D5D, 0x005D5E5D, 0x899C9C9D, 0xFFDBDDDF, 0xFFC9CDD1, 0xFFBEC2C8, 0xFFBDC1C7, 0xFFBDC1C7, 0xFFBDC1C7, 
        0xFFBDC1C7, 0xFFBDC1C7, 0xFFBDC1C7, 0xFFBDC1C7, 0xFFBDC1C7, 0xFFBDC1C7, 0xFFBDC1C7, 0xFFBDC1C7, 0xFFBDC1C7, 0xFFBDC1C7, 0xFFBDC1C7, 0xFFBDC1C7, 0xFFBDC1C7, 0xFFBDC1C7, 0xFFBDC1C7, 0xFFBDC1C7, 0xFFBDC1C7, 0xFFBDC1C7, 0xFFBDC1C7, 0xFFBDC1C7, 
        0xFFBDC1C7, 0xFFBCC0C6, 0xFFBDC1C7, 0xFFADB1B8, 0xFF82868D, 0xFA5C5D63, 0xB7070708, 0x85000000, 0x44000000, 0x12000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0xAB6F7073, 0xFFB8BBBE, 0xFFCACDD1, 0xFFC9CED1, 0xFFC9CDD1, 0xFFC9CDD0, 0xFFC9CED0, 0xFFC9CDD0, 0xFFC9CCD0, 0xFFC9CCD0, 0xFFC9CCD0, 0xFFC9CCD0, 0xFFC8CCD0, 0xFFC9CCCF, 0xFFC9CCD0, 0xFFC9CCD0, 
        0xFFC9CCD0, 0xFFC8CBD0, 0xFFC8CBD0, 0xFFC8CBD0, 0xFFC8CBD0, 0xFFC8CBD0, 0xFFC8CCD0, 0xFFC1C4CA, 0xFFBBBFC4, 0xFFBBBFC5, 0xFFBBBFC5, 0xFFBBBFC5, 0xFFBBBFC5, 0xFFBBBFC5, 0xFFBBBFC4, 0xFFB0B3B8, 0xFB929397, 0x791B1B1D, 0x22000000, 0x07000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F6F6, 0x00F9F9F9, 0x00F9FAFA, 0x00FFFFFF, 0x00FFFFFF, 0x00EEEFEF, 0x00D7D8D8, 0x00D7D8D8, 0x00D9DADA, 0x00D9DADA, 0x00D9DADA, 0x00D9DADA, 
        0x00D9DADA, 0x00D9DADA, 0x00D9DADA, 0x00D9DADA, 0x00D9DADA, 0x00D9DADA, 0x00D9DADA, 0x00D9DADA, 0x00D9DADA, 0x00D9DADA, 0x00D9DADA, 0x00D9DADA, 0x2CDBDCDB, 0xF4DFE0E1, 0xFFCED1D4, 0xFFC1C5CA, 0xFFBBBFC4, 0xFFBBBFC5, 0xFFBBBFC5, 0xFFBBBFC5, 
        0xFFBBBFC5, 0xFFBBBFC5, 0xFFBBBFC5, 0xFFBBBFC5, 0xFFBBBFC5, 0xFFBBBFC5, 0xFFBBBFC5, 0xFFBBBFC5, 0xFFBBBFC5, 0xFFBBBFC5, 0xFFBBBFC5, 0xFFBBBFC5, 0xFFBBBFC5, 0xFFBBBFC5, 0xFFBBBFC5, 0xFFBBBFC5, 0xFFBBBFC5, 0xFFBBBFC5, 0xFFBBBFC5, 0xFFBBBFC5, 
        0xFFBBBFC5, 0xFFBCC0C5, 0xFFBABEC3, 0xFF9EA1A8, 0xFF787B83, 0xE5424246, 0xA5000000, 0x72000000, 0x32000000, 0x0A000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5F3E3E3F, 0xFFAFB0B4, 0xFFC3C6CB, 0xFFC9CDD0, 0xFFC8CCCF, 0xFFC8CCCF, 0xFFC8CCCF, 0xFFC8CBCF, 0xFFC8CBCF, 0xFFC8CBCF, 0xFFC7CBCF, 0xFFC7CBCF, 0xFFC7CBCF, 0xFFC7CBCE, 0xFFC7CBCE, 0xFFC7CBCD, 
        0xFFC7CACD, 0xFFC6CACD, 0xFFC6CACD, 0xFFC6CACD, 0xFFC6C9CD, 0xFFC6CACE, 0xFFC2C6CA, 0xFFB9BDC2, 0xFFB9BDC2, 0xFFBABEC3, 0xFFBABEC3, 0xFFBABEC3, 0xFFBABEC3, 0xFFBABEC3, 0xFFBABEC3, 0xFFB5B9BE, 0xFFAEB0B4, 0xD56E6F72, 0x43010101, 0x14000000, 
        0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F6F6, 0x00F9F9F9, 0x00F9FAFA, 0x00F8F8F9, 0x00FAFBFB, 0x00FEFFFF, 0x00EBECEC, 0x00DFE0E0, 0x00D5D5D5, 0x00D7D7D7, 0x00D7D7D7, 0x00D7D7D7, 
        0x00D7D7D7, 0x00D7D7D7, 0x00D7D7D7, 0x00D7D7D7, 0x00D7D7D7, 0x00D7D7D7, 0x00D7D7D7, 0x00D7D7D7, 0x00D7D7D7, 0x00D7D7D7, 0x00D7D8D8, 0x00D7D8D8, 0xB3DDDEDD, 0xFFD6D8DA, 0xFFC4C8CC, 0xFFBBBFC4, 0xFFBABEC2, 0xFFBABEC3, 0xFFBABEC3, 0xFFBABEC3, 
        0xFFBABEC3, 0xFFBABEC3, 0xFFBABEC3, 0xFFBABEC3, 0xFFBABEC3, 0xFFBABEC3, 0xFFBABEC3, 0xFFBABEC3, 0xFFBABEC3, 0xFFBABEC3, 0xFFBABEC3, 0xFFBABEC3, 0xFFBABEC3, 0xFFBABEC3, 0xFFBABEC3, 0xFFBABEC3, 0xFFBABEC3, 0xFFBABEC3, 0xFFBABEC3, 0xFFBABEC3, 
        0xFFBABEC2, 0xFFBBBFC4, 0xFFB2B6BB, 0xFF8B8F96, 0xFF71737B, 0xCD212224, 0x97000000, 0x5D000000, 0x21000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1D0E0E0F, 0xE196979A, 0xFFBCBFC3, 0xFFC6C9CD, 0xFFC7C9CE, 0xFFC7C9CD, 0xFFC7CACD, 0xFFC7CACD, 0xFFC7C9CD, 0xFFC6C9CD, 0xFFC6C9CD, 0xFFC6C9CD, 0xFFC6C9CD, 0xFFC5C9CC, 0xFFC5C8CC, 0xFFC5C8CC, 
        0xFFC5C8CC, 0xFFC5C8CC, 0xFFC4C7CC, 0xFFC4C7CC, 0xFFC5C8CC, 0xFFC3C6CA, 0xFFB9BCC1, 0xFFB7BBC0, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB7BBC0, 0xFFB0B4B9, 0xFFACADB1, 0x9A404042, 0x26000000, 
        0x0A000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F6F6, 0x00F9F9F9, 0x00F9FAFA, 0x00F8F8F9, 0x00FAFAFA, 0x00FCFCFC, 0x00FFFFFF, 0x00EDEDED, 0x00D8D8D8, 0x00DADADA, 0x00D9D9D9, 0x00D9D9D9, 
        0x00D9D9D9, 0x00D9D9D9, 0x00D9D9D9, 0x00D9D9D9, 0x00D9D9D9, 0x00D9D9D9, 0x00D9D9D9, 0x00D9D9D9, 0x00D9D9D9, 0x00D9D9D9, 0x00D8D8D8, 0x5DDDDDDD, 0xFFDFE0E1, 0xFFCACDD1, 0xFFBBBFC4, 0xFFB7BBC0, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 
        0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 0xFFB8BCC1, 
        0xFFB8BCC1, 0xFFB8BCC1, 0xFFA4A7AD, 0xFF7E8189, 0xF65F6167, 0xB4050505, 0x86000000, 0x46000000, 0x14000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x93626265, 0xFFB8BABE, 0xFFC0C3C7, 0xFFC5C8CC, 0xFFC5C8CC, 0xFFC5C7CC, 0xFFC5C7CC, 0xFFC5C7CC, 0xFFC5C6CB, 0xFFC4C6CB, 0xFFC4C6CB, 0xFFC4C6CA, 0xFFC4C6CA, 0xFFC4C5CA, 0xFFC4C5CA, 
        0xFFC4C6CA, 0xFFC3C6CA, 0xFFC3C6CA, 0xFFC3C6CB, 0xFFC3C5CA, 0xFFB8BDC1, 0xFFB5B9BE, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB3B8BD, 0xFFB1B4B9, 0xF39C9DA0, 0x61171718, 
        0x17000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F6F6, 0x00F9F9F9, 0x00F9FAFA, 0x00F8F8F9, 0x00FAFAFA, 0x00FCFCFC, 0x00FBFBFB, 0x00FBFBFB, 0x00FCFCFC, 0x00F2F2F3, 0x00E6E6E8, 0x00E8E8E9, 
        0x00E8E8E9, 0x00E8E8E9, 0x00E8E8E9, 0x00E8E8E9, 0x00E8E8E9, 0x00E8E8E9, 0x00E8E8E9, 0x00E8E8E9, 0x00E8E8E9, 0x00E7E7E8, 0x1BE1E1E2, 0xE5E5E5E6, 0xFFD2D4D7, 0xFFBDC1C6, 0xFFB6BABF, 0xFFB5B9BE, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 
        0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 0xFFB6BABF, 
        0xFFB6BABF, 0xFFB2B6BB, 0xFF91949B, 0xFF7A7C85, 0xDE3C3D40, 0xA3000000, 0x71000000, 0x31000000, 0x0A000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x40272729, 0xFAACADB1, 0xFFBBBEC2, 0xFFC2C5CA, 0xFFC3C6CA, 0xFFC3C5CA, 0xFFC3C5CA, 0xFFC3C5CA, 0xFFC2C5CA, 0xFFC1C5C9, 0xFFC2C5C9, 0xFFC2C5C9, 0xFFC2C5C9, 0xFFC2C5C9, 0xFFC1C4C9, 
        0xFFC0C4C9, 0xFFC0C4C9, 0xFFC0C4C8, 0xFFC1C4C9, 0xFFBABDC2, 0xFFB3B7BC, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFAFB3B8, 0xFFB8BABF, 0xCF7F7F82, 
        0x39020202, 0x0F000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F6F6, 0x00F9F9F9, 0x00F9FAFA, 0x00F8F8F9, 0x00FAFAFA, 0x00FCFCFC, 0x00FBFBFB, 0x00FCFCFC, 0x00FFFFFF, 0x00F5F5F6, 0x00E9E9EB, 0x00EAEAEB, 
        0x00EAEAEB, 0x00EAEAEB, 0x00EAEAEB, 0x00EAEAEB, 0x00EAEAEB, 0x00EAEAEB, 0x00EAEAEB, 0x00EAEAEB, 0x00E9E9EA, 0x01E8E8EA, 0xADE9E9EA, 0xFFDCDEE0, 0xFFC1C4C8, 0xFFB5B9BE, 0xFFB3B7BC, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 
        0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB4B8BD, 0xFFB3B7BC, 
        0xFFB5B9BE, 0xFFA7ABB0, 0xFF81848C, 0xFD73747C, 0xC2141415, 0x94000000, 0x58000000, 0x1F000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0D010102, 0xBF87878A, 0xFFB8BBBF, 0xFFBDC0C4, 0xFFC1C5C8, 0xFFC0C5C8, 0xFFC1C4C8, 0xFFC1C4C8, 0xFFC0C4C8, 0xFFC0C4C7, 0xFFC0C4C6, 0xFFC0C4C7, 0xFFC0C4C7, 0xFFC0C3C7, 0xFFBFC3C7, 
        0xFFBFC2C7, 0xFFBFC2C6, 0xFFBFC3C7, 0xFFBBBFC3, 0xFFB1B6BA, 0xFFB1B5BA, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB1B5BA, 0xFFAEB2B6, 0xFFBFC1C4, 
        0x9F58595A, 0x22000000, 0x09000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F6F6, 0x00F9F9F9, 0x00F9FAFA, 0x00F8F8F9, 0x00FAFAFA, 0x00FCFCFC, 0x00FBFBFB, 0x00FCFCFC, 0x00FDFDFD, 0x00FEFEFE, 0x00FEFEFE, 0x00F7F7F7, 
        0x00EEEEEE, 0x00EFEFEF, 0x00EFEFEF, 0x00EFEFEF, 0x00EFEFEF, 0x00EFEFEF, 0x00F0F0F0, 0x00F1F1F1, 0x00E8E9E9, 0x6DEBEBEB, 0xFFE7E7E9, 0xFFC6C9CD, 0xFFB6BABF, 0xFFB1B5BA, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 
        0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 0xFFB2B6BB, 
        0xFFB0B4B9, 0xFF94989E, 0xFF7C7F87, 0xEB57575D, 0xAC000000, 0x7F000000, 0x3F000000, 0x10000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x63414144, 0xFFB5B7BB, 0xFFB5B8BD, 0xFFBEC2C5, 0xFFBFC2C5, 0xFFBEC2C5, 0xFFBEC1C5, 0xFFBEC1C5, 0xFFBDC1C5, 0xFFBDC1C5, 0xFFBDC1C5, 0xFFBDC1C5, 0xFFBDC0C5, 0xFFBEC1C5, 
        0xFFBEC0C4, 0xFFBDC1C5, 0xFFBCBFC4, 0xFFB1B5BA, 0xFFAFB3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B4B9, 0xFFAEB2B7, 0xFFB3B6BA, 
        0xFABCBDC0, 0x73353536, 0x15000000, 0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F6F6, 0x00F9F9F9, 0x00F9FAFA, 0x00F8F8F9, 0x00FAFAFA, 0x00FCFCFC, 0x00FBFBFB, 0x00FCFCFC, 0x00FDFDFD, 0x00FFFFFF, 0x00FFFFFF, 0x00F9F9F9, 
        0x00F0F0F0, 0x00F1F1F1, 0x00F1F1F1, 0x00F1F1F1, 0x00F1F1F1, 0x00F1F1F1, 0x00F0F0F0, 0x00F1F1F1, 0x3AEEEFEE, 0xF3EDEEEE, 0xFFCFD1D4, 0xFFB7BBC0, 0xFFB0B4B9, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 
        0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFB0B3B8, 0xFFAFB3B8, 0xFFB1B5BA, 
        0xFFA6AAAF, 0xFF81858C, 0xFF7C7E86, 0xCE272729, 0x9D000000, 0x67000000, 0x29000000, 0x07000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1B080809, 0xD595969A, 0xFFB6B7BC, 0xFFB8BBBF, 0xFFBCBFC3, 0xFFBCBFC3, 0xFFBCBFC3, 0xFFBCBFC3, 0xFFBCBFC3, 0xFFBCBFC3, 0xFFBCBFC3, 0xFFBCBFC3, 0xFFBCBFC3, 0xFFBCBEC3, 
        0xFFBCBEC3, 0xFFBCBEC3, 0xFFB2B5BA, 0xFFADB0B5, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFAEB1B6, 0xFFAAADB3, 
        0xFFBBBEC2, 0xECB5B6B9, 0x521F1F20, 0x0E000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F6F6, 0x00F9F9F9, 0x00F9FAFA, 0x00F8F8F9, 0x00FAFAFA, 0x00FCFCFC, 0x00FBFBFB, 0x00FCFCFC, 0x00FDFDFD, 0x00FFFFFF, 0x00FEFEFE, 0x00FFFFFF, 
        0x00FBFBFB, 0x00F8F8F8, 0x00FCFCFC, 0x00FBFBFB, 0x00F9F9F9, 0x00F8F8F8, 0x00EEEEEE, 0x1AF1F1F1, 0xDBF5F5F6, 0xFFD7D9DB, 0xFFB9BCC0, 0xFFAFB2B7, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 
        0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFADB1B6, 0xFFAEB1B6, 0xFFADB0B5, 
        0xFF94979D, 0xFF7D7F87, 0xF266686D, 0xB4030303, 0x8A000000, 0x4B000000, 0x17000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x7A515255, 0xFFBABBC0, 0xFFB0B3B8, 0xFFBABCC1, 0xFFBBBDC1, 0xFFBABDC1, 0xFFBABDC1, 0xFFBABDC0, 0xFFBABDC0, 0xFFBABDC0, 0xFFBABCC0, 0xFFBABCC0, 0xFFBABBC0, 
        0xFFBBBDC1, 0xFFB3B6BB, 0xFFAAADB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 
        0xFFA8ABB1, 0xFFC6C7CC, 0xD6A6A7AA, 0x3B121213, 0x0A000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F6F6, 0x00F9F9F9, 0x00F9FAFA, 0x00F8F8F9, 0x00FAFAFA, 0x00FCFCFC, 0x00FBFBFB, 0x00FCFCFC, 0x00FDFDFD, 0x00FFFFFF, 0x00FEFEFE, 0x00FFFFFF, 
        0x00FCFCFC, 0x00F9F9F9, 0x00FDFDFD, 0x00FCFCFC, 0x00FAFAFA, 0x00F8F8F8, 0x0DEEEEEE, 0xBFF7F7F7, 0xFFE1E2E3, 0xFFBBBEC2, 0xFFAEB1B6, 0xFFAAAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 
        0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFABAEB3, 0xFFACAFB4, 0xFFA3A6AC, 
        0xFF7F8389, 0xFF81838B, 0xD5343437, 0xA2000000, 0x70000000, 0x32000000, 0x0B000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x27121212, 0xE3A1A2A6, 0xFFB1B3B8, 0xFFB2B5B9, 0xFFB7BBBE, 0xFFB7BABE, 0xFFB7BABE, 0xFFB7BABE, 0xFFB7BBBE, 0xFFB7BBBE, 0xFFB7BABD, 0xFFB7BABD, 0xFFB8BBBE, 
        0xFFB5B8BC, 0xFFA9ADB1, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 
        0xFFA8ABB0, 0xFFA6AAAE, 0xFFCDCFD2, 0xC39A9B9C, 0x2B070708, 0x08000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F6F6, 0x00F9F9F9, 0x00F9FAFA, 0x00F8F8F9, 0x00FAFAFA, 0x00FCFCFC, 0x00FBFBFB, 0x00FCFCFC, 0x00FDFDFD, 0x00FFFFFF, 0x00FEFEFE, 0x00FFFFFF, 
        0x00FCFCFC, 0x00F9F9F9, 0x00FDFDFD, 0x00FCFCFC, 0x00FAFAFA, 0x02F8F8F8, 0xA6F9F9F8, 0xFFE6E7E8, 0xFFBDBFC3, 0xFFACB0B4, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 
        0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA8ABB0, 0xFFA9ACB1, 0xFFA7ABB0, 0xFF909399, 
        0xFF797C84, 0xF7727279, 0xB9070708, 0x90000000, 0x54000000, 0x1D000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x8359595C, 0xFFBABBC0, 0xFFAAADB2, 0xFFB4B6BA, 0xFFB5B7BB, 0xFFB5B7BB, 0xFFB5B7BB, 0xFFB5B7BB, 0xFFB5B7BB, 0xFFB4B7BB, 0xFFB5B7BB, 0xFFB5B7BB, 
        0xFFA9ADB1, 0xFFA4A7AC, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 
        0xFFA5A8AD, 0xFFA4A7AC, 0xFFA6A9AE, 0xFFD6D8DA, 0xB5919193, 0x23030303, 0x06000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F6F6, 0x00F9F9F9, 0x00F9FAFA, 0x00F8F8F9, 0x00FAFAFA, 0x00FCFCFC, 0x00FBFBFB, 0x00FCFCFC, 0x00FDFDFD, 0x00FFFFFF, 0x00FEFEFE, 0x00FFFFFF, 
        0x00FCFCFC, 0x00F9F9F9, 0x00FDFDFD, 0x00FCFCFC, 0x00FAFAFA, 0x95FEFEFE, 0xFFECECED, 0xFFBFC1C5, 0xFFACAEB3, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 
        0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA5A8AD, 0xFFA6A9AE, 0xFF9DA1A5, 0xFF7B7E84, 
        0xFF83868D, 0xD73B3B3E, 0xA5000000, 0x77000000, 0x38000000, 0x0E000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x280F0F10, 0xE1A0A1A6, 0xFFAEB0B5, 0xFFACAEB3, 0xFFB2B5BA, 0xFFB2B5B9, 0xFFB2B5B9, 0xFFB2B4B9, 0xFFB2B4B9, 0xFFB2B4B9, 0xFFB3B6BA, 0xFFABAEB3, 
        0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 
        0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA7AAAF, 0xFFDFDFE2, 0xAC919192, 0x1E040405, 0x04000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F6F6, 0x00F9F9F9, 0x00F9FAFA, 0x00F8F8F9, 0x00FAFAFA, 0x00FCFCFC, 0x00FBFBFB, 0x00FCFCFC, 0x00FDFDFD, 0x00FFFFFF, 0x00FEFEFE, 0x00FFFFFF, 
        0x00FCFCFC, 0x00F9F9F9, 0x00FDFDFD, 0x00FDFDFD, 0x8DFFFFFF, 0xFFEEEFF0, 0xFFC0C2C6, 0xFFAAAEB2, 0xFFA3A6AB, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 
        0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA2A5AA, 0xFFA3A6AB, 0xFFA2A5AA, 0xFF8A8D93, 0xFF787B82, 
        0xF573757C, 0xB9070707, 0x94000000, 0x59000000, 0x20000000, 0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x05000000, 0x81535357, 0xFFB7B8BD, 0xFFA3A6AA, 0xFFAEB1B5, 0xFFB0B2B7, 0xFFB0B2B7, 0xFFB0B2B7, 0xFFB0B2B7, 0xFFB0B3B7, 0xFFADB0B4, 0xFFA0A3A8, 
        0xFF9FA2A7, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 
        0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFF9FA2A7, 0xFFA6A9AD, 0xFFE1E2E5, 0xB29F9FA0, 0x220F0F0F, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F6F6, 0x00F9F9F9, 0x00F9FAFA, 0x00F8F8F9, 0x00FAFAFA, 0x00FCFCFC, 0x00FBFBFB, 0x00FCFCFC, 0x00FDFDFD, 0x00FFFFFF, 0x00FEFEFE, 0x00FFFFFF, 
        0x00FCFCFC, 0x00F9F9F9, 0x04FDFDFD, 0x96FFFFFF, 0xFFEFF0F1, 0xFFBFC1C5, 0xFFA8ABAF, 0xFFA0A3A8, 0xFF9FA2A7, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 
        0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A8, 0xFFA0A3A7, 0xFFA0A3A8, 0xFF96999F, 0xFF75787F, 0xFF85888F, 
        0xD6393A3D, 0xA6000000, 0x79000000, 0x3A000000, 0x0F000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x260B0B0C, 0xDB97989D, 0xFFAAACB0, 0xFFA4A7AB, 0xFFADB0B4, 0xFFACB0B3, 0xFFACB0B3, 0xFFADB0B4, 0xFFADB0B4, 0xFFA1A4A9, 0xFF9C9FA4, 
        0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 
        0xFF9DA0A5, 0xFF9DA0A5, 0xFF9C9FA5, 0xFF9DA0A5, 0xFF9B9EA3, 0xFFA2A5AB, 0xFFDEE0E2, 0xBFB4B4B5, 0x291C1C1D, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F6F6, 0x00F9F9F9, 0x00F9FAFA, 0x00F8F8F9, 0x00FAFAFA, 0x00FCFCFC, 0x00FBFBFB, 0x00FCFCFC, 0x00FDFDFD, 0x00FFFFFF, 0x00FEFEFE, 0x00FFFFFF, 
        0x00FCFCFC, 0x0CFAFAFA, 0xA9FFFFFF, 0xFFEBEDED, 0xFFBCBEC2, 0xFFA5A8AD, 0xFF9DA0A5, 0xFF9C9FA4, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 
        0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9DA0A5, 0xFF9A9DA3, 0xFF818489, 0xFF777A82, 0xF372737A, 
        0xB8050505, 0x94000000, 0x58000000, 0x20000000, 0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x06000000, 0x6E3F3F42, 0xFFB5B6BC, 0xFF9FA1A5, 0xFFA7AAAE, 0xFFAAADB1, 0xFFAAACB1, 0xFFABAEB2, 0xFFA4A7AB, 0xFF999CA0, 0xFF9A9DA1, 
        0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 
        0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF999CA1, 0xFF9EA1A5, 0xFFDBDCDE, 0xCCCBCBCC, 0x34282828, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F6F6, 0x00F9F9F9, 0x00F9FAFA, 0x00F8F8F9, 0x00FAFAFA, 0x00FCFCFC, 0x00FBFBFB, 0x00FCFCFC, 0x00FDFDFD, 0x00FFFFFF, 0x00FEFEFE, 0x00FFFFFF, 
        0x16FCFCFC, 0xBAFFFFFF, 0xFFE7E8EA, 0xFFB7BABD, 0xFFA2A5A9, 0xFF9A9DA2, 0xFF999CA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 
        0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA1, 0xFF9A9DA2, 0xFF8D9095, 0xFF6F7279, 0xFF868890, 0xD02B2C2E, 
        0xA5000000, 0x77000000, 0x38000000, 0x0F000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x1B020202, 0xC3838489, 0xFFACAEB3, 0xFF9B9EA2, 0xFFA7A9AE, 0xFFA8AAAF, 0xFFA5A8AD, 0xFF989B9F, 0xFF96999D, 0xFF96999E, 
        0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 
        0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF989BA0, 0xFFD9DADD, 0xDADFDFDF, 0x4D444445, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F6F6, 0x00F9F9F9, 0x00F9FAFA, 0x00F8F8F9, 0x00FAFAFA, 0x00FCFCFC, 0x00FBFBFB, 0x00FCFCFC, 0x00FDFDFD, 0x00FFFFFF, 0x00FEFEFE, 0x30FFFFFF, 
        0xCDFFFFFF, 0xFFE2E4E5, 0xFFB0B3B7, 0xFF9EA1A5, 0xFF979A9E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 
        0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF96999E, 0xFF979A9E, 0xFF93969A, 0xFF74777D, 0xFF7B7E86, 0xEA636469, 0xB3000000, 
        0x90000000, 0x54000000, 0x1F000000, 0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x06000000, 0x5427282A, 0xF9AAABB2, 0xFF9B9DA1, 0xFF9EA0A5, 0xFFA5A8AC, 0xFF9A9DA1, 0xFF929599, 0xFF93969B, 0xFF93969B, 
        0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 
        0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF95989C, 0xFFC8CACD, 0xF3EFF0F1, 0x77838384, 0x0A020202, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F6F6, 0x00F9F9F9, 0x00F9FAFA, 0x00F8F8F9, 0x00FAFAFA, 0x00FCFCFC, 0x00FBFBFB, 0x00FCFCFC, 0x00FDFDFD, 0x00FFFFFF, 0x61FFFFFF, 0xECFCFCFC, 
        0xFFD6D8DA, 0xFFAAADB1, 0xFF999CA1, 0xFF94979B, 0xFF93969A, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 
        0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF93969B, 0xFF808388, 0xFF6C6E75, 0xFD83858D, 0xC61B1B1D, 0xA1000000, 
        0x70000000, 0x34000000, 0x0D000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x12000000, 0xA0616165, 0xFFADAFB5, 0xFF93969B, 0xFF9B9EA2, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 
        0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 
        0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8D8F95, 0xFFADAFB3, 0xFFF3F4F5, 0xA8B7B7B8, 0x21272727, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F6F6, 0x00F9F9F9, 0x00F9FAFA, 0x00F8F8F9, 0x00FAFAFA, 0x00FCFCFC, 0x00FBFBFB, 0x00FCFCFC, 0x0EFDFDFD, 0x97FFFFFF, 0xFFF4F5F5, 0xFFC4C6C9, 
        0xFFA1A3A8, 0xFF93969B, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 
        0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF8F9297, 0xFF909398, 0xFF878A8F, 0xFF696C72, 0xFF82848C, 0xDE4A4B4F, 0xAD000000, 0x89000000, 
        0x4C000000, 0x1A000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x06000000, 0x330B0B0C, 0xDE919297, 0xFF9D9EA3, 0xFF85878B, 0xFF8B8E92, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 
        0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 
        0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8E93, 0xFF8C8E93, 0xFF8C8F93, 0xFF8B8E93, 0xFF999B9F, 0xFFDEDFE0, 0xD5E3E3E3, 0x4D585858, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F6F6, 0x00F9F9F9, 0x00F9FAFA, 0x00F8F8F9, 0x00FAFAFA, 0x00FCFCFC, 0x00FBFBFB, 0x39FEFEFE, 0xCAFFFFFF, 0xFFE3E5E5, 0xFFB3B6B8, 0xFF999BA0, 
        0xFF8F9296, 0xFF8B8E92, 0xFF8C8E93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 
        0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8F93, 0xFF8C8E93, 0xFF8D8F94, 0xFF8A8C91, 0xFF6F7278, 0xFF71737A, 0xF372737A, 0xBA060607, 0x9B000000, 0x66000000, 
        0x2C000000, 0x09000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x0C000000, 0x6B313234, 0xFDA6A8AD, 0xFF818388, 0xFF828589, 0xFF888B90, 0xFF888B90, 0xFF888B90, 
        0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 
        0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B8F, 0xFF888B90, 0xFF888B8F, 0xFF8C8F93, 0xFFBFC1C4, 0xFBF6F6F7, 0x95ABABAB, 0x1D2C2C2C, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F6F6, 0x00F9F9F9, 0x00F9FAFA, 0x00F8F8F9, 0x00FAFAFA, 0x0FFDFDFD, 0x85FFFFFF, 0xF8F7F8F8, 0xFFCFD1D3, 0xFFA4A7AA, 0xFF919498, 0xFF898C90, 
        0xFF888B8F, 0xFF888B8F, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 
        0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B90, 0xFF888B8F, 0xFF777A7F, 0xFF63666C, 0xFE83848D, 0xCD252527, 0xA7000000, 0x7C000000, 0x41000000, 
        0x14000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x06000000, 0x1B000000, 0xAC636367, 0xFF9EA0A5, 0xFF77797F, 0xFF82858A, 0xFF84878C, 0xFF84878C, 
        0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 
        0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF85888D, 0xFF84878C, 0xFF9B9EA3, 0xFFDFE0E2, 0xDAEEEEEE, 0x67868685, 0x090D0D0D, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F6F6, 0x00F9F9F9, 0x00F9FAFA, 0x00F8F8F9, 0x58FDFDFD, 0xD3FEFEFE, 0xFFE2E3E5, 0xFFB4B7BA, 0xFF95999D, 0xFF898C91, 0xFF84878C, 0xFF84878C, 
        0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 
        0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF84878C, 0xFF85888D, 0xFF7C7F84, 0xFF606269, 0xFF7B7E85, 0xE24E4F54, 0xB1000000, 0x90000000, 0x56000000, 0x21000000, 
        0x06000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x09000000, 0x390A0B0B, 0xDC8A8B91, 0xFF8E9095, 0xFF73767B, 0xFF808287, 0xFF818388, 
        0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 
        0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF808388, 0xFF808388, 0xFF818388, 0xFF818389, 0xFF86898E, 0xFFAFB0B4, 0xFFEAEBEC, 0xC3DBDBDB, 0x516E6E6E, 
        0x040C0C0C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F5F5, 0x00F5F6F6, 0x00F9F9F9, 0x46FCFCFD, 0xB9FDFDFD, 0xFFEBECED, 0xFFC2C4C7, 0xFF9D9FA3, 0xFF8B8D92, 0xFF82858A, 0xFF808288, 0xFF808388, 0xFF818388, 
        0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 
        0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818388, 0xFF818489, 0xFF7D7F85, 0xFF63656B, 0xFF6E7077, 0xF26E6F76, 0xBB060607, 0x9E000000, 0x6C000000, 0x32000000, 0x0C000000, 
        0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x0F000000, 0x65262628, 0xF89A9AA1, 0xFF7B7C82, 0xFF75777B, 0xFF7D7F84, 
        0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 
        0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7E8085, 0xFF7E8186, 0xFF8A8C90, 0xFFB8BABC, 0xFFEEEFF0, 
        0xBAD6D6D6, 0x50706F6F, 0x07101010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x00F5F5F5, 0x00F5F5F5, 0x01F6F6F6, 0x47F9F9F9, 0xB3FCFCFC, 0xFFEEEEEF, 0xFFC9CACC, 0xFFA2A4A8, 0xFF8C8E93, 0xFF818389, 0xFF7D7F84, 0xFF7C7E84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 
        0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 
        0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7D7F84, 0xFF7C7E83, 0xFF696B70, 0xFF5F6168, 0xFC7D7E85, 0xC91D1D1F, 0xA8000000, 0x7F000000, 0x44000000, 0x16000000, 0x03000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x06000000, 0x1A000000, 0x984C4C50, 0xFF9C9DA3, 0xFF6E7076, 0xFF74777C, 
        0xFF7A7D81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 
        0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF797C81, 0xFF7A7D81, 0xFF7B7E82, 0xFF7C7F84, 0xFF8B8F92, 
        0xFFB9BABD, 0xFFE9E9EA, 0xC7DCDCDC, 0x678D8D8C, 0x17353434, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x00F2F2F3, 0x00F3F4F4, 0x00F3F3F4, 0x10F6F6F6, 0x5DF9F9F8, 0xC1F9F9F9, 0xFFE9EAEB, 0xFFC8CACC, 0xFFA3A5A9, 0xFF8B8E92, 0xFF808387, 0xFF7A7D82, 0xFF797C80, 0xFF797C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 
        0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 
        0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF7A7C81, 0xFF6C6F74, 0xFF57595F, 0xFF7C7E86, 0xD93C3C40, 0xAF000000, 0x8E000000, 0x56000000, 0x21000000, 0x07000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x0B000000, 0x2C000001, 0xC167686D, 0xFF8D8F95, 0xFF696B70, 
        0xFF74777B, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 
        0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF77797E, 0xFF77797E, 0xFF777A7E, 0xFF797C80, 
        0xFF7B7D82, 0xFF888A8F, 0xFFAFB0B3, 0xFFE0E1E2, 0xE4E9E9EA, 0x94B4B4B4, 0x41696969, 0x0A141414, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x001C1C1C, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x00EFEFEF, 
        0x00EFF0F0, 0x00F1F1F2, 0x06F3F3F4, 0x3CF6F6F7, 0x8EF8F8F9, 0xE0F3F3F3, 0xFFE1E2E2, 0xFFBFC1C3, 0xFF9EA0A4, 0xFF898B90, 0xFF7E8085, 0xFF787B7F, 0xFF76797D, 0xFF77797E, 0xFF77797E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 
        0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 
        0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF777A7E, 0xFF787A7E, 0xFF6F7277, 0xFF56585E, 0xFF71737B, 0xE755555A, 0xB5000000, 0x9B000000, 0x67000000, 0x2F000000, 0x0C000000, 0x01000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x0F000000, 0x450C0C0D, 0xDF7D7E83, 0xFF828389, 
        0xFF67696E, 0xFF73757A, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 
        0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74767B, 0xFF74767B, 0xFF74767B, 
        0xFF74777B, 0xFF76797D, 0xFF787B80, 0xFF828489, 0xFF9A9DA0, 0xFFC6C7CA, 0xFEE4E5E7, 0xD4DFDFDF, 0x8DA6A6A6, 0x49757575, 0x12343434, 0x000D0D0D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00181818, 0x005D5D5D, 0x00000000, 0x000E0E0E, 
        0x00D2D2D3, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005E5E5E, 0x005E5E5F, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x00EBECEC, 0x00ECECEC, 0x00ECEDED, 0x00EEEFEF, 0x00EEEEEF, 0x0DF0F0F0, 
        0x45F2F3F3, 0x87F5F5F6, 0xD0F2F3F3, 0xFDE5E5E7, 0xFFCDCED1, 0xFFAEB0B3, 0xFF94969A, 0xFF83868A, 0xFF7A7D81, 0xFF75777C, 0xFF73767A, 0xFF74767B, 0xFF74767B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 
        0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 
        0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF74777B, 0xFF6F7276, 0xFF57595F, 0xFF67686F, 0xF267696F, 0xBD080808, 0xA3000000, 0x77000000, 0x3D000000, 0x13000000, 0x02000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x06000000, 0x15000000, 0x631D1D1E, 0xF3898A8F, 
        0xFF73757A, 0xFF65676C, 0xFF707377, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 
        0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717378, 
        0xFF717378, 0xFF717378, 0xFF717478, 0xFF727579, 0xFF75777C, 0xFF797C80, 0xFF86898D, 0xFFA2A3A7, 0xFFC4C6C8, 0xFFE2E3E4, 0xE5E0E0E1, 0xACD7D8D8, 0x7A9A9A99, 0x45777777, 0x1A3C3C3C, 0x070E0E0E, 0x00292929, 0x00555555, 0x00000000, 0x00000000, 
        0x00D1D1D2, 0x00E1E1E1, 0x00DCDCDC, 0x00ECECED, 0x005C5C5C, 0x005C5C5D, 0x00F1F1F2, 0x00E3E3E3, 0x00E5E5E6, 0x00E7E7E8, 0x00E7E7E7, 0x00E9E8E9, 0x00EAEAEA, 0x00E8E9E9, 0x06ECEDED, 0x17EEEEEE, 0x42EFF0F0, 0x76F3F3F3, 0xA9F1F1F2, 0xE2EDEDED, 
        0xFFDFE0E1, 0xFFCACCCD, 0xFFB1B3B6, 0xFF979A9E, 0xFF86898D, 0xFF7C7E82, 0xFF75787B, 0xFF727479, 0xFF707377, 0xFF717378, 0xFF717378, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 
        0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 
        0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF717478, 0xFF6D7075, 0xFF585A60, 0xFF5A5C63, 0xFA717279, 0xC7171718, 0xA9000000, 0x83000000, 0x4B000000, 0x1C000000, 0x05000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08000000, 0x1D000000, 0x802D2E31, 
        0xFB888A90, 0xFF6A6C71, 0xFF64676B, 0xFF6E7075, 0xFF6E7175, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 
        0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 
        0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6F7175, 0xFF717377, 0xFF73757A, 0xFF787A7E, 0xFF838689, 0xFF96989C, 0xFFAEB0B3, 0xFFCACCCD, 0xFFE1E2E3, 0xF3DEDEDF, 0xD2D5D5D6, 0xAADCDCDD, 0x8BABACAC, 0x70777777, 0x567C7C7C, 
        0x44DDDDDD, 0x32E2E2E2, 0x26DFDFDF, 0x26EEEEEF, 0x14686868, 0x14686869, 0x26F3F3F3, 0x25E5E6E5, 0x31E8E8E9, 0x43EAEAEB, 0x54EBEBEB, 0x6FEDEDEE, 0x89EFEFEF, 0xA7ECEDED, 0xD0EBEBEC, 0xF2E6E7E8, 0xFFDCDDDD, 0xFFCBCCCE, 0xFFB9BBBD, 0xFFA4A6A9, 
        0xFF929498, 0xFF83868A, 0xFF7A7C80, 0xFF74767A, 0xFF6F7176, 0xFF6E7075, 0xFF6E7074, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 
        0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 
        0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6E7075, 0xFF6F7175, 0xFF6D6F73, 0xFF5A5C61, 0xFF55575D, 0xFD72747B, 0xCF242427, 0xAD000000, 0x8D000000, 0x57000000, 0x24000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x0C000000, 0x25000000, 
        0x983B3C3F, 0xFF88898F, 0xFF626469, 0xFF63666A, 0xFF6B6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 
        0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 
        0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6B6E72, 0xFF6B6D72, 0xFF6B6D71, 0xFF6B6D71, 0xFF6C6E72, 0xFF6E7074, 0xFF707277, 0xFF737579, 0xFF797B7F, 0xFF828489, 0xFF8F9195, 0xFFA1A2A5, 0xFFAEB0B2, 0xFFC0C2C4, 0xFFD3D4D6, 0xFFDADCDD, 
        0xFFD1D2D3, 0xFAD6D7D7, 0xF6DADBDC, 0xF6DCDDDD, 0xF1D8D9DA, 0xF1D9DADA, 0xF6DDDEDF, 0xF6DDDEDF, 0xFADBDCDD, 0xFFD6D7D8, 0xFFD0D1D2, 0xFFC8CACB, 0xFFC0C2C3, 0xFFB6B8BA, 0xFFA7A9AC, 0xFF999A9E, 0xFF8E9093, 0xFF828488, 0xFF7A7C80, 0xFF74777B, 
        0xFF6F7176, 0xFF6C6F73, 0xFF6B6D71, 0xFF6B6D71, 0xFF6B6D71, 0xFF6B6D72, 0xFF6B6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 
        0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 
        0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6C6E72, 0xFF6B6D71, 0xFF5B5D61, 0xFF505157, 0xFF73757B, 0xD7313134, 0xB0000000, 0x95000000, 0x62000000, 0x2D000000, 0x0C000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x0F000000, 
        0x31000000, 0xAE47484C, 0xFF828388, 0xFF5C5F63, 0xFF616469, 0xFF686B6F, 0xFF696B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 
        0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 
        0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686A6F, 0xFF686A6F, 0xFF686A6F, 0xFF696C70, 0xFF6A6D71, 0xFF6D7074, 0xFF6F7276, 0xFF717377, 0xFF74777C, 0xFF7A7D81, 0xFF808287, 
        0xFF838589, 0xFF878A8D, 0xFF8B8E91, 0xFF8D9093, 0xFF929599, 0xFF939599, 0xFF8F9195, 0xFF8E9195, 0xFF8B8E92, 0xFF888B8E, 0xFF84868B, 0xFF7F8185, 0xFF7A7C80, 0xFF75787C, 0xFF727479, 0xFF707276, 0xFF6B6E72, 0xFF696C70, 0xFF686B6F, 0xFF686A6F, 
        0xFF686A6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 
        0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 
        0xFF686B6F, 0xFF686B6F, 0xFF686B6F, 0xFF696B70, 0xFF686B6F, 0xFF5B5D61, 0xFF4B4C52, 0xFF6C6E75, 0xDE3D3D41, 0xB3000000, 0x9C000000, 0x6C000000, 0x35000000, 0x10000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 
        0x12000000, 0x3A000000, 0xBC4F5053, 0xFF7D7F84, 0xFF595B60, 0xFF5F6266, 0xFF65686C, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 
        0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 
        0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686C, 0xFF66686C, 0xFF65686C, 0xFF65676C, 0xFF65676C, 0xFF65676C, 0xFF65676C, 0xFF66686D, 0xFF67686D, 0xFF67696E, 
        0xFF676A6E, 0xFF686A6F, 0xFF696B70, 0xFF6A6C71, 0xFF6A6D71, 0xFF6A6D71, 0xFF6B6D72, 0xFF6A6C71, 0xFF686A6F, 0xFF676A6E, 0xFF67696E, 0xFF67696E, 0xFF66696D, 0xFF65676C, 0xFF65676C, 0xFF65676C, 0xFF65676C, 0xFF65676C, 0xFF65686C, 0xFF66686C, 
        0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 
        0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF66686D, 
        0xFF66686D, 0xFF66686D, 0xFF66686D, 0xFF65676C, 0xFF585B5F, 0xFF484B50, 0xFF66686E, 0xE3434348, 0xB6000000, 0xA0000000, 0x73000000, 0x3D000000, 0x15000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x05000000, 0x16000000, 0x42010101, 0xC3505155, 0xFF77797E, 0xFF56585C, 0xFF5D5F63, 0xFF636569, 0xFF63656A, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 
        0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 
        0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF626569, 
        0xFF626569, 0xFF626569, 0xFF626569, 0xFF626569, 0xFF626569, 0xFF626569, 0xFF626569, 0xFF626569, 0xFF626569, 0xFF626569, 0xFF626569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 
        0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 
        0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 0xFF636569, 
        0xFF63656A, 0xFF63666A, 0xFF636569, 0xFF56585D, 0xFF46484D, 0xFF62646A, 0xE544454A, 0xB8000001, 0xA3000000, 0x79000000, 0x44000000, 0x19000000, 0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x06000000, 0x1A000000, 0x48020203, 0xCA515256, 0xFF737379, 0xFF53555A, 0xFF5A5C60, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 
        0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 
        0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 
        0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 
        0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 
        0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 0xFF606367, 
        0xFF616367, 0xFF606266, 0xFF54555A, 0xFF45464B, 0xFF5F6067, 0xE746474B, 0xB9020202, 0xA5000000, 0x7D000000, 0x48000000, 0x1D000000, 0x06000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x07000000, 0x1C000000, 0x4D040304, 0xC94C4D51, 0xFF707277, 0xFF515358, 0xFF56595D, 0xFF5D6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 
        0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 
        0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 
        0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 
        0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 
        0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 0xFF5E6064, 
        0xFF5C5F62, 0xFF505356, 0xFF43444A, 0xFF5D5F64, 0xE6414347, 0xB9020203, 0xA6000000, 0x7F000000, 0x4B000000, 0x1F000000, 0x07000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x01000000, 0x09000000, 0x1D000000, 0x4D010102, 0xC445464A, 0xFF6B6D72, 0xFF4E5054, 0xFF535558, 0xFF5B5D61, 0xFF5C5E62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 
        0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 
        0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 
        0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 
        0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 
        0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5B5D62, 0xFF5C5E62, 0xFF595B5F, 
        0xFF4C4E53, 0xFF424348, 0xFF5B5C62, 0xE43C3D41, 0xB9010101, 0xA5000000, 0x80000000, 0x4D000000, 0x20000000, 0x09000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x09000000, 0x1F000000, 0x4C000000, 0xBE3D3E41, 0xFF65686D, 0xFF4F5155, 0xFF4E5055, 0xFF575A5E, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 
        0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 
        0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 
        0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 
        0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 
        0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF595B5F, 0xFF56585C, 0xFF47494E, 
        0xFF43454A, 0xFF5A5B61, 0xE136363A, 0xB7000000, 0xA5000000, 0x7F000000, 0x4D000000, 0x22000000, 0x09000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x09000000, 0x1F000000, 0x48000000, 0xB0303134, 0xFF616267, 0xFF4E5055, 0xFF4B4D51, 0xFF55575B, 0xFF57595D, 0xFF57595D, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 
        0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 
        0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 
        0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 
        0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 
        0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595C, 0xFF57595D, 0xFF56585C, 0xFF525458, 0xFF434549, 0xFF414349, 
        0xFE56585D, 0xDA2B2B2E, 0xB6000000, 0xA3000000, 0x7D000000, 0x4B000000, 0x21000000, 0x09000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x09000000, 0x1D000000, 0x42000000, 0x9F242426, 0xFA5B5C61, 0xFF505256, 0xFF47484D, 0xFF505257, 0xFF54565B, 0xFF54565B, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 
        0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 
        0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 
        0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 
        0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 
        0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565A, 0xFF54565B, 0xFF53555A, 0xFF4D4F53, 0xFF3E4045, 0xFF43464A, 0xFC505257, 
        0xD31F1F22, 0xB3000000, 0xA0000000, 0x79000000, 0x48000000, 0x1F000000, 0x08000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x07000000, 0x1C000000, 0x3D000000, 0x8E171719, 0xEF505155, 0xFF525358, 0xFF434549, 0xFF4B4D52, 0xFF515357, 0xFF525458, 0xFF515358, 0xFF515358, 0xFF515358, 
        0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 
        0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 
        0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 
        0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 
        0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF515358, 0xFF525458, 0xFF505257, 0xFF47494D, 0xFF3A3B41, 0xFF47494E, 0xF6484A4D, 0xCC141416, 
        0xB1000000, 0x9B000000, 0x73000000, 0x43000000, 0x1C000000, 0x07000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x06000000, 0x19000000, 0x37000000, 0x780C0C0C, 0xDD404144, 0xFF525458, 0xFF434448, 0xFF46484C, 0xFF4E5054, 0xFF505256, 0xFF505256, 0xFF505255, 
        0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 
        0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 
        0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 
        0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 
        0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505255, 0xFF505256, 0xFF505256, 0xFF505256, 0xFF4C4E52, 0xFF404246, 0xFF393B3F, 0xFF494A4F, 0xED3A3B3E, 0xC20A0A0A, 0xAE000000, 
        0x96000000, 0x6B000000, 0x3D000000, 0x19000000, 0x06000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x05000000, 0x15000000, 0x32000000, 0x63020203, 0xC42E2F31, 0xFF4F5155, 0xFF44464A, 0xFF414347, 0xFF494B50, 0xFF4D5054, 0xFF4E5054, 
        0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 
        0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 
        0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 
        0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 
        0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4E5054, 0xFF4D4F53, 0xFF47494D, 0xFF3A3C40, 0xFF3A3C41, 0xFF47494E, 0xE02A2B2D, 0xBA020202, 0xA9000000, 0x8E000000, 
        0x62000000, 0x35000000, 0x15000000, 0x05000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x10000000, 0x2B000000, 0x53000000, 0xA41A1B1D, 0xF245464A, 0xFF47494D, 0xFF3D3E43, 0xFF44464A, 0xFF4A4C50, 
        0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 
        0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 
        0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 
        0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 
        0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF4C4D51, 0xFF494A4E, 0xFF404145, 0xFF36373C, 0xFF3F4045, 0xF73F4044, 0xD2171819, 0xB4000000, 0xA4000000, 0x83000000, 0x57000000, 
        0x2D000000, 0x10000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x0C000000, 0x23000000, 0x45000000, 0x820A0A0B, 0xDB333436, 0xFF46484C, 0xFF3C3E42, 0xFF3D3E43, 
        0xFF45474B, 0xFF494A4E, 0xFF494B4F, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 
        0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 
        0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 
        0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 
        0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494A4E, 0xFF494B4F, 0xFF494B4F, 0xFF484A4E, 0xFF434448, 0xFF38393D, 0xFF35373B, 0xFF3F4145, 0xEA2F3033, 0xC309090A, 0xAF000000, 0x9A000000, 0x77000000, 0x4B000000, 0x24000000, 
        0x0C000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x08000000, 0x1C000000, 0x39000000, 0x66000000, 0xB61D1F20, 0xF73D3F43, 0xFF3E4145, 
        0xFF383A3F, 0xFF3F4045, 0xFF45474B, 0xFF47494D, 0xFF47494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 
        0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 
        0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 
        0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 
        0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF46494D, 0xFF47494D, 0xFF46484C, 0xFF434549, 0xFF3B3C41, 0xFF323439, 0xFF383A3F, 0xF9393A3E, 0xD81C1C1E, 0xB8000000, 0xA9000000, 0x8E000000, 0x67000000, 0x3D000000, 0x1C000000, 0x08000000, 
        0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x05000000, 0x13000000, 0x2E000000, 0x50000000, 0x8D0A0A0B, 0xDB2C2D30, 
        0xFF3E3F43, 0xFF37393D, 0xFF37393E, 0xFF3F4145, 0xFF44464A, 0xFF45474B, 0xFF45474B, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 
        0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 
        0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 
        0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474A, 
        0xFF45474A, 0xFF45474A, 0xFF45474A, 0xFF45474B, 0xFF45474B, 0xFF424448, 0xFF3C3E41, 0xFF323438, 0xFF323438, 0xFF393B3F, 0xE9292A2D, 0xC409090A, 0xB0000000, 0x9F000000, 0x7F000000, 0x56000000, 0x2F000000, 0x13000000, 0x05000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x0C000000, 0x22000000, 0x40000000, 0x6A000000, 
        0xB0151617, 0xF0323437, 0xFF393B3F, 0xFF34363A, 0xFF37393D, 0xFF3E4043, 0xFF424447, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 
        0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 
        0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 
        0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 0xFF434548, 
        0xFF434548, 0xFF434548, 0xFF434548, 0xFF414346, 0xFF3C3E41, 0xFF343539, 0xFF2F3135, 0xFF35363A, 0xF42F3034, 0xD3141415, 0xB6000000, 0xA8000000, 0x90000000, 0x6C000000, 0x44000000, 0x22000000, 0x0C000000, 0x02000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x07000000, 0x16000000, 0x31000000, 
        0x52000000, 0x83050505, 0xC81D1E20, 0xFA323437, 0xFF34363A, 0xFF323437, 0xFF36383B, 0xFF3D3F42, 0xFF404245, 0xFF414346, 0xFF414346, 0xFF414246, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 
        0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 
        0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 
        0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414245, 0xFF414346, 0xFF414346, 
        0xFF414346, 0xFF3F4144, 0xFF3B3C40, 0xFF333438, 0xFF2D2F33, 0xFF313136, 0xFB303135, 0xDE1C1C1E, 0xBF040404, 0xAE000000, 0x9C000000, 0x7D000000, 0x57000000, 0x32000000, 0x16000000, 0x07000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x0D000000, 
        0x21000000, 0x3F000000, 0x61000000, 0x97090909, 0xD9212224, 0xFF303235, 0xFF313336, 0xFF303135, 0xFF35363A, 0xFF3B3C40, 0xFF3E3F43, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 
        0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 
        0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 
        0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3F4044, 0xFF3D3E42, 
        0xFF39393E, 0xFF323237, 0xFF2C2D32, 0xFF2E2F33, 0xFD2E3032, 0xE61F2122, 0xC5080909, 0xB1000000, 0xA3000000, 0x8A000000, 0x66000000, 0x41000000, 0x21000000, 0x0D000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x06000000, 0x14000000, 0x2C000000, 0x49000000, 0x6D000000, 0xA20B0B0B, 0xDD1F2022, 0xFF2D2E31, 0xFF2E2F33, 0xFF2D2F33, 0xFF323438, 0xFF37393D, 0xFF3B3C40, 0xFF3C3E42, 0xFF3C3E42, 0xFF3C3E42, 0xFF3C3E42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 
        0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 
        0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 
        0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3D42, 0xFF3C3E42, 0xFF3C3E42, 0xFF3C3E42, 0xFF3C3E42, 0xFF3C3D41, 0xFF3A3C40, 0xFF35373B, 0xFF2F3034, 
        0xFF2B2B30, 0xFF2B2C30, 0xFF2B2D30, 0xE81E1F21, 0xC90A0A0B, 0xB4000000, 0xA6000000, 0x91000000, 0x70000000, 0x4D000000, 0x2C000000, 0x14000000, 0x06000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x02000000, 0x0A000000, 0x1A000000, 0x33000000, 0x51000000, 0x74000000, 0xA60A0B0B, 0xDD1C1E20, 0xFE292A2D, 0xFF2B2D30, 0xFF2B2C31, 0xFF2E3034, 0xFF343539, 0xFF37393D, 0xFF393B3F, 0xFF3A3C40, 0xFF3A3C40, 0xFF3A3C40, 0xFF393C40, 
        0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 
        0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 
        0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF393C40, 0xFF3A3C40, 0xFF3A3C40, 0xFF3A3C40, 0xFF393B3F, 0xFF36383C, 0xFF313337, 0xFF2B2D31, 0xFF28292E, 0xFF292A2E, 
        0xFD28292C, 0xE81C1D1F, 0xCA0A0A0B, 0xB4000000, 0xA7000000, 0x94000000, 0x77000000, 0x55000000, 0x34000000, 0x1A000000, 0x0A000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x0C000000, 0x1F000000, 0x39000000, 0x55000000, 0x76000000, 0xA2070708, 0xD4161719, 0xF8242627, 0xFF282A2D, 0xFF292A2E, 0xFF2B2C30, 0xFF2F3135, 0xFF333539, 0xFF36383C, 0xFF37393D, 0xFF383A3E, 
        0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 
        0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 
        0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF383A3E, 0xFF37393D, 0xFF35373B, 0xFF313438, 0xFF2D2E32, 0xFF282A2E, 0xFF26282C, 0xFF26282C, 0xF9222426, 0xE2161718, 
        0xC6070708, 0xB3000000, 0xA6000000, 0x94000000, 0x79000000, 0x58000000, 0x39000000, 0x1F000000, 0x0C000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x0F000000, 0x21000000, 0x3A000000, 0x56000000, 0x73000000, 0x99040404, 0xC7101112, 0xEC1D1E20, 0xFF232528, 0xFF25282B, 0xFF27282C, 0xFF2A2C30, 0xFF2E3034, 0xFF313437, 
        0xFF34363A, 0xFF35373B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 
        0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 
        0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF36383B, 0xFF35373B, 0xFF333539, 0xFF303336, 0xFF2C2E32, 0xFF28292D, 0xFF25262A, 0xFF242629, 0xFF232427, 0xF01C1D20, 0xD9101112, 0xC1040404, 0xB0000000, 
        0xA4000000, 0x91000000, 0x77000000, 0x58000000, 0x3A000000, 0x21000000, 0x0F000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x05000000, 0x0F000000, 0x20000000, 0x37000000, 0x52000000, 0x6B000000, 0x8C000000, 0xB209090A, 0xDA141616, 0xF71D1F21, 0xFF222426, 0xFF242529, 0xFF25272A, 
        0xFF282A2D, 0xFF2B2D30, 0xFF2F3134, 0xFF313336, 0xFF333538, 0xFF333538, 0xFF343639, 0xFF343639, 0xFF343639, 0xFF343639, 0xFF343639, 0xFF343638, 0xFF343638, 0xFF343638, 0xFF343638, 0xFF343638, 0xFF343638, 0xFF343638, 0xFF343638, 0xFF343638, 
        0xFF343638, 0xFF343638, 0xFF343638, 0xFF343638, 0xFF343638, 0xFF343638, 0xFF343638, 0xFF343638, 0xFF343638, 0xFF343638, 0xFF343638, 0xFF343638, 0xFF343638, 0xFF343638, 0xFF343638, 0xFF343638, 0xFF343638, 0xFF343638, 0xFF343638, 0xFF343639, 
        0xFF343639, 0xFF343639, 0xFF343639, 0xFF343639, 0xFF333538, 0xFF323437, 0xFF303235, 0xFF2E2F33, 0xFF2A2C2F, 0xFF26282B, 0xFF232528, 0xFF222427, 0xFF212225, 0xF81D1E21, 0xE5141516, 0xCB090909, 0xB8000000, 0xAA000000, 0x9E000000, 0x8B000000, 
        0x70000000, 0x54000000, 0x38000000, 0x20000000, 0x0F000000, 0x05000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x04000000, 0x0D000000, 0x1D000000, 0x32000000, 0x4B000000, 0x63000000, 0x7C000000, 0x9B020202, 0xBE0A0B0C, 0xDE131415, 0xF81B1D1F, 
        0xFF1F2124, 0xFF212326, 0xFF222427, 0xFF25272A, 0xFF28292D, 0xFF2A2C30, 0xFF2D2F32, 0xFF2F3134, 0xFF303235, 0xFF313336, 0xFF313336, 0xFF323437, 0xFF323437, 0xFF323437, 0xFF323437, 0xFF323437, 0xFF323437, 0xFF323437, 0xFF323437, 0xFF313437, 
        0xFF313437, 0xFF313437, 0xFF313437, 0xFF313437, 0xFF313437, 0xFF313437, 0xFF313437, 0xFF313437, 0xFF313437, 0xFF313437, 0xFF323437, 0xFF323437, 0xFF323437, 0xFF323437, 0xFF323437, 0xFF323437, 0xFF323437, 0xFF323437, 0xFF323437, 0xFF313336, 
        0xFF313336, 0xFF303235, 0xFF2E3033, 0xFF2C2E31, 0xFF292B2E, 0xFF26282B, 0xFF232528, 0xFF212326, 0xFF202225, 0xFF1E2022, 0xF81B1C1E, 0xE6131416, 0xD00A0B0B, 0xBD020202, 0xAF000000, 0xA4000000, 0x95000000, 0x80000000, 0x66000000, 0x4C000000, 
        0x32000000, 0x1D000000, 0x0E000000, 0x04000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04000000, 0x0B000000, 0x17000000, 0x29000000, 0x3F000000, 0x56000000, 0x6D000000, 0x84000000, 0x9E020202, 
        0xBD090A0A, 0xDA101112, 0xF117181A, 0xFE1B1D1F, 0xFF1E2022, 0xFF1F2124, 0xFF212225, 0xFF232427, 0xFF25272A, 0xFF28292C, 0xFF292A2E, 0xFF2B2D30, 0xFF2D2E31, 0xFF2E2F32, 0xFF2F3033, 0xFF2F3134, 0xFF2F3134, 0xFF303134, 0xFF303134, 0xFF303235, 
        0xFF303235, 0xFF303235, 0xFF303235, 0xFF303235, 0xFF303235, 0xFF303235, 0xFF303235, 0xFF303235, 0xFF303235, 0xFF303235, 0xFF303235, 0xFF303134, 0xFF303134, 0xFF2F3134, 0xFF2F3134, 0xFF2F3033, 0xFF2D2F32, 0xFF2C2E31, 0xFF2B2C2F, 0xFF29292D, 
        0xFF27282B, 0xFF242528, 0xFF222326, 0xFF202124, 0xFF1E2023, 0xFF1C1F21, 0xFE1B1D1F, 0xF317181A, 0xE3101112, 0xCF09090A, 0xBD020202, 0xAF000000, 0xA4000000, 0x98000000, 0x87000000, 0x71000000, 0x58000000, 0x3F000000, 0x29000000, 0x17000000, 
        0x0B000000, 0x04000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x07000000, 0x10000000, 0x1E000000, 0x31000000, 0x45000000, 0x5B000000, 
        0x6E000000, 0x83000000, 0x99010101, 0xB0040505, 0xC80A0B0C, 0xDD0E1011, 0xEF141618, 0xFC181A1C, 0xFF1B1C1E, 0xFF1C1E21, 0xFF1E2023, 0xFF1F2124, 0xFF202125, 0xFF222326, 0xFF232428, 0xFF252629, 0xFF26272B, 0xFF27282B, 0xFF28292C, 0xFF292A2D, 
        0xFF292A2E, 0xFF2A2B2F, 0xFF2A2B2F, 0xFF2B2C2F, 0xFF2B2C2F, 0xFF2B2C2F, 0xFF2A2B2F, 0xFF2A2B2F, 0xFF2A2B2E, 0xFF292A2E, 0xFF28292D, 0xFF28292C, 0xFF27282B, 0xFF25262A, 0xFF242529, 0xFF232427, 0xFF212226, 0xFF202125, 0xFF1F2023, 0xFF1D1F21, 
        0xFF1C1D20, 0xFF191C1E, 0xFC181A1C, 0xF1141617, 0xE30F1011, 0xD40A0B0C, 0xC4040505, 0xB6010101, 0xAB000000, 0xA2000000, 0x97000000, 0x86000000, 0x72000000, 0x5C000000, 0x46000000, 0x30000000, 0x1E000000, 0x10000000, 0x07000000, 0x02000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x0A000000, 0x13000000, 0x20000000, 
        0x31000000, 0x44000000, 0x58000000, 0x6B000000, 0x7A000000, 0x8A000000, 0x9B000000, 0xAC020303, 0xC0070708, 0xD00A0A0C, 0xDE0D0E10, 0xEC121315, 0xF7151619, 0xFD17181B, 0xFF18191C, 0xFF191A1D, 0xFF1B1C1F, 0xFF1C1D21, 0xFF1C1E21, 0xFF1C1E21, 
        0xFF1D1E22, 0xFF1D1E22, 0xFF1E1F22, 0xFF1E1F23, 0xFF1E1F23, 0xFF1E1F23, 0xFF1E1F23, 0xFF1E1F22, 0xFF1D1E22, 0xFF1D1E22, 0xFF1C1E21, 0xFF1C1D20, 0xFF1C1D21, 0xFF1B1C1F, 0xFF191A1D, 0xFF18191C, 0xFD16181A, 0xF8141619, 0xEE111315, 0xE30D0E10, 
        0xD80A0B0B, 0xCC060708, 0xBE020303, 0xB4000000, 0xAA000000, 0xA1000000, 0x99000000, 0x8D000000, 0x7E000000, 0x6D000000, 0x58000000, 0x45000000, 0x31000000, 0x20000000, 0x13000000, 0x0A000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 
        0x09000000, 0x12000000, 0x1E000000, 0x2C000000, 0x3C000000, 0x4C000000, 0x5C000000, 0x6B000000, 0x78000000, 0x84000000, 0x90000000, 0x9D000000, 0xA7010101, 0xB2020203, 0xBF050506, 0xCA070809, 0xD2090A0B, 0xD90B0C0D, 0xDF0C0D0E, 0xE50E0F10, 
        0xEA0F1012, 0xEA0F1112, 0xF0111214, 0xF0111214, 0xF0111214, 0xF0111214, 0xF0111214, 0xF0111214, 0xEB0F1112, 0xEA0F1012, 0xE60E0F10, 0xE10C0D0E, 0xDC0B0C0D, 0xD6090A0B, 0xCF070809, 0xC7050506, 0xBD020203, 0xB6010101, 0xB0000000, 0xA8000000, 
        0xA0000000, 0x9A000000, 0x92000000, 0x88000000, 0x7B000000, 0x6C000000, 0x5C000000, 0x4C000000, 0x3B000000, 0x2C000000, 0x1E000000, 0x13000000, 0x0A000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x03000000, 0x07000000, 0x0E000000, 0x16000000, 0x20000000, 0x2B000000, 0x38000000, 0x46000000, 0x52000000, 0x5D000000, 0x6A000000, 0x74000000, 0x7E000000, 0x85000000, 0x8C000000, 0x91000000, 0x97000000, 0x9D000000, 
        0xA1000000, 0xA4000000, 0xA7000000, 0xA9000000, 0xAA000000, 0xAB000000, 0xAB000000, 0xAB000000, 0xA9000000, 0xA7000000, 0xA4000000, 0xA1000000, 0x9D000000, 0x9B000000, 0x97000000, 0x93000000, 0x8E000000, 0x87000000, 0x7F000000, 0x76000000, 
        0x6B000000, 0x5E000000, 0x52000000, 0x46000000, 0x38000000, 0x2B000000, 0x20000000, 0x16000000, 0x0E000000, 0x07000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03000000, 0x07000000, 0x0C000000, 0x12000000, 0x19000000, 0x21000000, 0x2A000000, 0x33000000, 0x3B000000, 0x44000000, 0x4D000000, 0x54000000, 0x5B000000, 0x61000000, 
        0x65000000, 0x6A000000, 0x6E000000, 0x70000000, 0x73000000, 0x74000000, 0x74000000, 0x74000000, 0x73000000, 0x71000000, 0x6E000000, 0x6A000000, 0x66000000, 0x61000000, 0x5B000000, 0x54000000, 0x4D000000, 0x44000000, 0x3B000000, 0x33000000, 
        0x2A000000, 0x21000000, 0x19000000, 0x12000000, 0x0C000000, 0x07000000, 0x03000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x04000000, 0x06000000, 0x0A000000, 0x0E000000, 0x12000000, 0x16000000, 0x1A000000, 0x1E000000, 0x22000000, 
        0x26000000, 0x29000000, 0x2D000000, 0x2F000000, 0x31000000, 0x32000000, 0x32000000, 0x32000000, 0x31000000, 0x2F000000, 0x2D000000, 0x29000000, 0x26000000, 0x22000000, 0x1E000000, 0x1A000000, 0x16000000, 0x12000000, 0x0E000000, 0x0A000000, 
        0x06000000, 0x04000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x03000000, 
        0x05000000, 0x06000000, 0x07000000, 0x08000000, 0x08000000, 0x08000000, 0x08000000, 0x08000000, 0x08000000, 0x08000000, 0x07000000, 0x06000000, 0x05000000, 0x03000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000
#else
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFFD8D7D6, 0xFFD4D3D2, 0xFFD2D2D1, 0xFFD0D0CF, 0xFFCACAC8, 0xFFC6C5C3, 0xFFC6C6C5, 0xFFC3C2C1, 0xFFBFBEBD, 0xFFBEBDBB, 0xFFB8B8B6, 0xFFB8B7B6, 0xFFB7B6B4, 0xFFB4B3B1, 0xFFB1B0AF, 0xFFAFAEAC, 
        0xFFACABAA, 0xFFACABA9, 0xFFAAA8A6, 0xFFA8A7A4, 0xFFA5A4A2, 0xFFA5A3A1, 0xFFA3A2A0, 0xFFA2A09E, 0xFF9F9E9C, 0xFF9D9D9A, 0xFF9E9D9A, 0xFF9C9A98, 0xFF999896, 0xFF9A9895, 0xFF989694, 0xFF959491, 0xFF949390, 0xFF94928F, 0xFF92908E, 0xFF918F8D, 
        0xFF908F8B, 0xFF908F8C, 0xFF8F8D8C, 0xFF8B8A88, 0xFF8D8C89, 0xFF8A8886, 0xFF8B8A87, 0xFF898785, 0xFF878583, 0xFF898784, 0xFF83817F, 0xFF858381, 0xF5848380, 0xE9807F7D, 0xCC7F7E7B, 0xAF807F7D, 0x957C7B78, 0x837A7977, 0x74787774, 0x61797875, 
        0x537B7A78, 0x507D7C7A, 0x3D807E7C, 0x3B7D7C79, 0x3B787775, 0x3B767572, 0x3B747370, 0x3C71706E, 0x4F6E6D6B, 0x526C6A69, 0x606A6967, 0x735F5E5B, 0x83343433, 0x95353533, 0xAE5D5C5A, 0xCB636260, 0xE7302F2E, 0xF5050505, 0xFF0C0C0B, 0xFF444341, 
        0xFF000000, 0xFF030403, 0xFF232322, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFFD8D7D6, 0xFFD4D3D2, 0xFFD2D2D1, 0xFFD0D0CF, 0xFFCACAC8, 0xFFC6C5C3, 0xFFC6C6C5, 0xFFC3C2C1, 0xFFBFBEBD, 0xFFBEBDBB, 0xFFB8B8B6, 0xFFB8B7B6, 0xFFB7B6B4, 0xFFB4B3B1, 0xFFB1B0AF, 0xFFAFAEAC, 
        0xFFACABAA, 0xFFACABA9, 0xFFAAA8A6, 0xFFA8A7A4, 0xFFA5A4A2, 0xFFA5A3A1, 0xFFA3A2A0, 0xFFA2A09E, 0xFF9F9E9C, 0xFF9D9D9A, 0xFF9E9D9A, 0xFF9C9A98, 0xFF999896, 0xFF9A9895, 0xFF989694, 0xFF959491, 0xFF949390, 0xFF94928F, 0xFF92908E, 0xFF918F8D, 
        0xFF908F8B, 0xFF908F8C, 0xFF8F8D8C, 0xFF8B8A88, 0xFF8D8C89, 0xFF8A8886, 0xFD8A8986, 0xE8888684, 0xC0868482, 0x96868481, 0x7183827F, 0x47888683, 0x23898784, 0x0D8B8987, 0x0592908E, 0x00979594, 0x009A9896, 0x009F9E9C, 0x00A5A3A2, 0x00A9A8A6, 
        0x00ACAAA9, 0x00ACAAA8, 0x00AFAEAC, 0x00AEADAC, 0x00AEABAB, 0x00ACAAA9, 0x00ABA9A8, 0x00A8A7A5, 0x00A4A3A1, 0x00A3A1A0, 0x00A09E9C, 0x009C9A99, 0x009C9B99, 0x0093918F, 0x007F7C7B, 0x05767472, 0x0D706F6D, 0x22656462, 0x455B5957, 0x70535250, 
        0x952E2E2D, 0xBD31312F, 0xE6282826, 0xFD050504, 0xFF010101, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFFD8D7D6, 0xFFD4D3D2, 0xFFD2D2D1, 0xFFD0D0CF, 0xFFCACAC8, 0xFFC6C5C3, 0xFFC6C6C5, 0xFFC3C2C1, 0xFFBFBEBD, 0xFFBEBDBB, 0xFFB8B8B6, 0xFFB8B7B6, 0xFFB7B6B4, 0xFFB4B3B1, 0xFFB1B0AF, 0xFFAFAEAC, 
        0xFFACABAA, 0xFFACABA9, 0xFFAAA8A6, 0xFFA8A7A4, 0xFFA5A4A2, 0xFFA5A3A1, 0xFFA3A2A0, 0xFFA2A09E, 0xFF9F9E9C, 0xFF9D9D9A, 0xFF9E9D9A, 0xFF9C9A98, 0xFF999896, 0xFF9A9895, 0xFF989694, 0xFF959491, 0xFF949390, 0xFF94928F, 0xFF92908E, 0xFF918F8D, 
        0xFF908F8B, 0xFF908F8C, 0xFB8E8C8B, 0xDB8A8987, 0xA48B8A87, 0x71898785, 0x3D8D8B89, 0x1191908E, 0x01999895, 0x00A19F9D, 0x00ACABA9, 0x00B4B2B1, 0x00BAB9B7, 0x00C2C0C0, 0x00C3C2C1, 0x00C2BFBF, 0x00C1C0BF, 0x00C2C0BF, 0x00C2C0BF, 0x00C0BEBE, 
        0x00BEBCBC, 0x00BCBBBA, 0x00BAB8B8, 0x00BAB8B8, 0x00BAB8B7, 0x00BAB8B7, 0x00BAB8B7, 0x00B9B7B6, 0x00B9B8B6, 0x00BAB9B8, 0x00BBB9B9, 0x00BBBAB9, 0x00BBB9B9, 0x00B9B7B7, 0x00B7B5B4, 0x00B7B5B4, 0x00B7B5B4, 0x00ACAAA9, 0x009F9D9C, 0x00979594, 
        0x008B8987, 0x01797875, 0x10676664, 0x3B585855, 0x6E464443, 0xA22A2928, 0xD8202020, 0xFA050505, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFFD8D7D6, 0xFFD4D3D2, 0xFFD2D2D1, 0xFFD0D0CF, 0xFFCACAC8, 0xFFC6C5C3, 0xFFC6C6C5, 0xFFC3C2C1, 0xFFBFBEBD, 0xFFBEBDBB, 0xFFB8B8B6, 0xFFB8B7B6, 0xFFB7B6B4, 0xFFB4B3B1, 0xFFB1B0AF, 0xFFAFAEAC, 
        0xFFACABAA, 0xFFACABA9, 0xFFAAA8A6, 0xFFA8A7A4, 0xFFA5A4A2, 0xFFA5A3A1, 0xFFA3A2A0, 0xFFA2A09E, 0xFF9F9E9C, 0xFF9D9D9A, 0xFF9E9D9A, 0xFF9C9A98, 0xFF999896, 0xFF9A9895, 0xFF989694, 0xFF959491, 0xFF949390, 0xFF94928F, 0xFF918F8E, 0xF2908E8C, 
        0xB78E8D8A, 0x758E8D8A, 0x36918F8D, 0x09989695, 0x00A2A09E, 0x00B0AEAD, 0x00B8B6B5, 0x00C2C1C0, 0x00C6C4C4, 0x00C4C3C2, 0x00C4C3C2, 0x00C1BFBE, 0x00BCBBBB, 0x00BAB8B8, 0x00B8B6B5, 0x00B5B3B3, 0x00B5B3B2, 0x00B4B2B1, 0x00B3B1B0, 0x00B2B0B0, 
        0x00B2B0AF, 0x00B1AFAF, 0x00B0AFAE, 0x00B0AEAE, 0x00B0AEAE, 0x00B0ADAE, 0x00AFADAC, 0x00AFADAC, 0x00AEACAB, 0x00ADABAB, 0x00ADABAA, 0x00ADABAA, 0x00ADABAA, 0x00ADABAA, 0x00ADABAA, 0x00AEABAB, 0x00AFADAC, 0x00B1AFAF, 0x00B4B2B1, 0x00B6B4B4, 
        0x00B4B2B2, 0x00B3B1B0, 0x00ADABAB, 0x009D9C9A, 0x0092908F, 0x007F7D7C, 0x096C6A69, 0x33585655, 0x713A3A38, 0xB4272726, 0xEE111010, 0xFF020102, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFFD8D7D6, 0xFFD4D3D2, 0xFFD2D2D1, 0xFFD0D0CF, 0xFFCACAC8, 0xFFC6C5C3, 0xFFC6C6C5, 0xFFC3C2C1, 0xFFBFBEBD, 0xFFBEBDBB, 0xFFB8B8B6, 0xFFB8B7B6, 0xFFB7B6B4, 0xFFB4B3B1, 0xFFB1B0AF, 0xFFAFAEAC, 
        0xFFACABAA, 0xFFACABA9, 0xFFAAA8A6, 0xFFA8A7A4, 0xFFA5A4A2, 0xFFA5A3A1, 0xFFA3A2A0, 0xFFA2A09E, 0xFF9F9E9C, 0xFF9D9D9A, 0xFF9E9D9A, 0xFF9C9A98, 0xFF999896, 0xFF9A9895, 0xFF989694, 0xFF949490, 0xF3949390, 0xB392918E, 0x6691908E, 0x1E979593, 
        0x00A09E9C, 0x00B1AFAD, 0x00BCBBBA, 0x00C7C5C4, 0x00C7C5C4, 0x00C6C4C4, 0x00C2BFBF, 0x00BCBABA, 0x00B9B7B7, 0x00B7B6B5, 0x00B6B4B3, 0x00B4B3B2, 0x00B4B2B2, 0x00B4B1B1, 0x00B3B1B1, 0x00B3B1B0, 0x00B3B1B0, 0x00B3B1B0, 0x00B2B0AF, 0x00B1B0AF, 
        0x00B1AFAE, 0x00B1AFAE, 0x00B0AEAD, 0x00AFADAD, 0x00AFADAC, 0x00AFACAC, 0x00AEACAC, 0x00ADABAB, 0x00ADABAB, 0x00ADAAAA, 0x00ACAAA9, 0x00ABAAA9, 0x00ABA8A8, 0x00ABA8A8, 0x00AAA8A8, 0x00A9A7A6, 0x00A9A7A6, 0x00A9A5A5, 0x00A8A5A4, 0x00A8A5A5, 
        0x00A8A5A5, 0x00AAA6A5, 0x00ABA8A8, 0x00AFADAC, 0x00B1B0AE, 0x00B0AEAC, 0x00ADABAA, 0x009D9A9A, 0x008D8B8A, 0x00747371, 0x1C5C5B59, 0x62444342, 0xB0272625, 0xEE0F0F0F, 0xFF010101, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFFD8D7D6, 0xFFD4D3D2, 0xFFD2D2D1, 0xFFD0D0CF, 0xFFCACAC8, 0xFFC6C5C3, 0xFFC6C6C5, 0xFFC3C2C1, 0xFFBFBEBD, 0xFFBEBDBB, 0xFFB8B8B6, 0xFFB8B7B6, 0xFFB7B6B4, 0xFFB4B3B1, 0xFFB1B0AF, 0xFFAFAEAC, 
        0xFFACABAA, 0xFFACABA9, 0xFFAAA8A6, 0xFFA8A7A4, 0xFFA5A4A2, 0xFFA5A3A1, 0xFFA3A2A0, 0xFFA2A09E, 0xFF9F9E9C, 0xFF9D9D9A, 0xFF9E9D9A, 0xFF9C9A98, 0xFF999896, 0xFD999794, 0xC5979593, 0x6D949391, 0x21999895, 0x00A3A2A0, 0x00B4B2B1, 0x00C2C0BF, 
        0x00C9C7C6, 0x00C8C6C5, 0x00C2C1C0, 0x00BDBBBA, 0x00B9B7B6, 0x00B7B5B4, 0x00B6B4B3, 0x00B5B3B3, 0x00B5B3B2, 0x00B5B2B2, 0x00B5B2B2, 0x00B5B2B2, 0x00B4B2B1, 0x00B3B1B1, 0x00B3B1B1, 0x00B3B1B1, 0x00B2B0B0, 0x00B2B0B0, 0x00B2AFAF, 0x00B1AFAE, 
        0x00B0AEAE, 0x00B0AEAD, 0x00B0ADAC, 0x00AFACAC, 0x00AFACAC, 0x00AEABAB, 0x00ADABAB, 0x00ADABAA, 0x00ADAAAA, 0x00ACAAAA, 0x00ACAAA9, 0x00ABA9A8, 0x00ABA8A8, 0x00AAA8A7, 0x00A9A7A6, 0x00A9A6A6, 0x00A8A5A5, 0x00A8A5A3, 0x00A7A4A3, 0x00A6A3A2, 
        0x00A5A2A2, 0x00A5A2A1, 0x00A4A1A1, 0x00A3A1A0, 0x00A4A1A1, 0x00A5A3A2, 0x00A6A4A3, 0x00ACA9A9, 0x00AFACAB, 0x00ADAAA9, 0x00A09E9D, 0x008C8A88, 0x00747270, 0x1E5B5958, 0x6841403E, 0xC021201F, 0xFB050505, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFFD8D7D6, 0xFFD4D3D2, 0xFFD2D2D1, 0xFFD0D0CF, 0xFFCACAC8, 0xFFC6C5C3, 0xFFC6C6C5, 0xFFC3C2C1, 0xFFBFBEBD, 0xFFBEBDBB, 0xFFB8B8B6, 0xFFB8B7B6, 0xFFB7B6B4, 0xFFB4B3B1, 0xFFB1B0AF, 0xFFAFAEAC, 
        0xFFACABAA, 0xFFACABA9, 0xFFAAA8A6, 0xFFA8A7A4, 0xFFA5A4A2, 0xFFA5A3A1, 0xFFA3A2A0, 0xFFA2A09E, 0xFF9F9E9C, 0xFF9D9D9A, 0xFF9E9D9A, 0xE89B9997, 0x97989795, 0x3D9B9997, 0x03A4A2A0, 0x00B4B3B1, 0x00C3C1C0, 0x00C9C8C7, 0x00C8C6C5, 0x00C1BFBF, 
        0x00BBBAB9, 0x00B9B7B6, 0x00B7B5B4, 0x00B6B4B4, 0x00B6B4B4, 0x00B5B4B3, 0x00B5B4B3, 0x00B5B3B3, 0x00B5B3B2, 0x00B5B3B2, 0x00B5B2B1, 0x00B5B2B1, 0x00B4B2B1, 0x00B4B1B1, 0x00B3B1B0, 0x00B3B0B0, 0x00B2AFAF, 0x00B1AFAF, 0x00B1AEAD, 0x00B0ADAD, 
        0x00AFADAD, 0x00AFADAC, 0x00AEACAC, 0x00AEACAB, 0x00AEABAB, 0x00AEABAB, 0x00ADABAA, 0x00ADA9AA, 0x00ACA9A9, 0x00ABA9A8, 0x00AAA9A8, 0x00AAA8A7, 0x00A9A7A7, 0x00A9A6A6, 0x00A8A6A5, 0x00A8A5A5, 0x00A7A4A4, 0x00A6A3A3, 0x00A6A3A2, 0x00A5A3A2, 
        0x00A5A2A2, 0x00A4A2A1, 0x00A4A1A0, 0x00A4A09F, 0x00A2A09F, 0x00A29F9E, 0x00A19E9D, 0x00A09E9D, 0x00A19D9D, 0x00A29F9F, 0x00A7A4A3, 0x00ABA8A7, 0x00AAA7A6, 0x009E9B9A, 0x00878584, 0x016D6B69, 0x3A51504E, 0x90323130, 0xE2121212, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFFD8D7D6, 0xFFD4D3D2, 0xFFD2D2D1, 0xFFD0D0CF, 0xFFCACAC8, 0xFFC6C5C3, 0xFFC6C6C5, 0xFFC3C2C1, 0xFFBFBEBD, 0xFFBEBDBB, 0xFFB8B8B6, 0xFFB8B7B6, 0xFFB7B6B4, 0xFFB4B3B1, 0xFFB1B0AF, 0xFFAFAEAC, 
        0xFFACABAA, 0xFFACABA9, 0xFFAAA8A6, 0xFFA8A7A4, 0xFFA5A4A2, 0xFFA5A3A1, 0xFFA3A2A0, 0xFFA2A09E, 0xFF9F9E9C, 0xD69C9C99, 0x769C9C99, 0x1AA1A09D, 0x00AEADAA, 0x00BFBEBC, 0x00CAC8C7, 0x00C9C7C6, 0x00C2C0C0, 0x00BCBABA, 0x00B9B7B7, 0x00B7B5B5, 
        0x00B7B5B4, 0x00B7B5B4, 0x00B6B5B4, 0x00B7B5B4, 0x00B6B4B4, 0x00B6B4B3, 0x00B5B4B2, 0x00B5B3B3, 0x00B4B3B2, 0x00B4B2B2, 0x00B4B2B1, 0x00B4B2B1, 0x00B3B0B0, 0x00B2B0B0, 0x00B2B0AF, 0x00B1AFAE, 0x00B1AFAE, 0x00B0AEAD, 0x00B0AEAD, 0x00B0AEAD, 
        0x00AFADAC, 0x00AFACAC, 0x00AEACAB, 0x00AEACAB, 0x00ADABAA, 0x00ADAAA9, 0x00ACA9A9, 0x00ACA9A8, 0x00AAA9A8, 0x00AAA8A7, 0x00AAA7A7, 0x00A9A7A6, 0x00A8A6A5, 0x00A8A5A5, 0x00A7A5A4, 0x00A7A4A3, 0x00A6A4A3, 0x00A5A3A3, 0x00A5A3A2, 0x00A5A2A2, 
        0x00A4A1A1, 0x00A4A1A0, 0x00A3A1A0, 0x00A3A09E, 0x00A29F9E, 0x00A19E9D, 0x00A09D9C, 0x00A09C9C, 0x009F9C9B, 0x009E9B9A, 0x009E9B9A, 0x009E9B9A, 0x00A09D9C, 0x00A4A1A1, 0x00A9A6A4, 0x00A5A3A1, 0x00949190, 0x007C7A78, 0x175E5D5B, 0x6F383837, 
        0xD01A1A1A, 0xFF010101, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFFD8D7D6, 0xFFD4D3D2, 0xFFD2D2D1, 0xFFD0D0CF, 0xFFCACAC8, 0xFFC6C5C3, 0xFFC6C6C5, 0xFFC3C2C1, 0xFFBFBEBD, 0xFFBEBDBB, 0xFFB8B8B6, 0xFFB8B7B6, 0xFFB7B6B4, 0xFFB4B3B1, 0xFFB1B0AF, 0xFFAFAEAC, 
        0xFFACABAA, 0xFFACABA9, 0xFFAAA8A6, 0xFFA8A7A4, 0xFFA5A4A2, 0xFFA5A3A1, 0xFFA3A2A0, 0xCAA19F9D, 0x5FA09E9C, 0x0CA6A5A3, 0x00B7B5B4, 0x00C7C5C5, 0x00CBC9C8, 0x00C6C4C3, 0x00BEBCBB, 0x00BAB7B8, 0x00B8B5B5, 0x00B8B5B5, 0x00B7B5B5, 0x00B7B5B5, 
        0x00B7B5B5, 0x00B7B5B4, 0x00B7B5B4, 0x00B7B5B4, 0x00B6B4B3, 0x00B6B3B3, 0x00B5B3B2, 0x00B4B3B2, 0x00B4B2B2, 0x00B4B2B1, 0x00B4B1B1, 0x00B3B0B0, 0x00B2AFAF, 0x00B2AFAE, 0x00B1AFAF, 0x00B1AFAE, 0x00B0AEAE, 0x00B0AEAE, 0x00B0AEAD, 0x00AFADAC, 
        0x00AEACAC, 0x00AEACAB, 0x00ADABAA, 0x00ADA9AA, 0x00ADAAA9, 0x00ACAAA9, 0x00ABA8A8, 0x00AAA8A7, 0x00A9A7A6, 0x00A9A7A6, 0x00A9A6A6, 0x00A8A5A5, 0x00A8A5A4, 0x00A7A5A4, 0x00A7A5A4, 0x00A6A4A3, 0x00A6A3A2, 0x00A5A2A1, 0x00A5A2A1, 0x00A4A1A1, 
        0x00A3A1A0, 0x00A2A09F, 0x00A29F9F, 0x00A19F9E, 0x00A19E9D, 0x00A09D9C, 0x00A09D9C, 0x00A09C9B, 0x009E9C9B, 0x009E9B9A, 0x009E9B9A, 0x009D9999, 0x009B9898, 0x009B9897, 0x009B9897, 0x009E9B9A, 0x00A3A1A0, 0x00A6A2A2, 0x009B9897, 0x0082807F, 
        0x09666463, 0x59464544, 0xC31E1E1D, 0xFF010101, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFFD8D7D6, 0xFFD4D3D2, 0xFFD2D2D1, 0xFFD0D0CF, 0xFFCACAC8, 0xFFC6C5C3, 0xFFC6C6C5, 0xFFC3C2C1, 0xFFBFBEBD, 0xFFBEBDBB, 0xFFB8B8B6, 0xFFB8B7B6, 0xFFB7B6B4, 0xFFB4B3B1, 0xFFB1B0AF, 0xFFAFAEAC, 
        0xFFACABAA, 0xFFACABA9, 0xFFAAA8A6, 0xFFA8A7A4, 0xFFA5A4A2, 0xCEA4A2A0, 0x5DA4A2A0, 0x06ABA9A7, 0x00BBBAB8, 0x00CAC8C7, 0x00CBC9C8, 0x00C2C0C0, 0x00BCBAB9, 0x00B9B7B6, 0x00B8B6B5, 0x00B9B6B5, 0x00B8B6B5, 0x00B8B6B5, 0x00B8B6B5, 0x00B8B5B4, 
        0x00B8B5B4, 0x00B7B4B4, 0x00B6B4B4, 0x00B6B4B3, 0x00B5B3B3, 0x00B5B3B2, 0x00B4B2B2, 0x00B3B1B1, 0x00B3B1B1, 0x00B3B1B0, 0x00B2B0B0, 0x00B3B0AF, 0x00B2AFAE, 0x00B2AFAE, 0x00B1AEAD, 0x00B0ADAE, 0x00B0ADAD, 0x00B0ADAC, 0x00AFADAC, 0x00AEACAB, 
        0x00ADABAB, 0x00ADAAA9, 0x00ACAAA9, 0x00ACA9A9, 0x00ACA9A8, 0x00AAA8A8, 0x00AAA7A7, 0x00AAA7A6, 0x00A9A6A5, 0x00A9A6A5, 0x00A8A5A5, 0x00A8A5A4, 0x00A7A5A4, 0x00A6A4A4, 0x00A7A3A3, 0x00A6A3A2, 0x00A4A2A1, 0x00A4A2A1, 0x00A3A1A0, 0x00A2A09F, 
        0x00A2A09F, 0x00A19F9E, 0x00A19F9D, 0x00A19E9D, 0x00A09D9C, 0x009F9D9C, 0x009F9D9B, 0x009F9B9A, 0x009E9A9A, 0x009D9999, 0x009C9A98, 0x009C9998, 0x009B9897, 0x009A9796, 0x009A9796, 0x00999695, 0x00999694, 0x009B9796, 0x009F9C9B, 0x00A3A09F, 
        0x009C9997, 0x00878583, 0x036B6967, 0x56484746, 0xC61D1D1C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFFD8D7D6, 0xFFD4D3D2, 0xFFD2D2D1, 0xFFD0D0CF, 0xFFCACAC8, 0xFFC6C5C3, 0xFFC6C6C5, 0xFFC3C2C1, 0xFFBFBEBD, 0xFFBEBDBB, 0xFFB8B8B6, 0xFFB8B7B6, 0xFFB7B6B4, 0xFFB4B3B1, 0xFFB1B0AF, 0xFFAFAEAC, 
        0xFFACABAA, 0xFFACABA9, 0xFFA9A8A6, 0xDBA7A6A3, 0x65A5A4A2, 0x08ADACAA, 0x00BEBCBB, 0x00CBC9C8, 0x00CAC8C7, 0x00C1C0BF, 0x00BBB9B9, 0x00B9B7B6, 0x00B9B7B6, 0x00B9B7B6, 0x00B9B7B6, 0x00B9B6B6, 0x00B8B6B5, 0x00B8B6B5, 0x00B8B5B4, 0x00B7B4B4, 
        0x00B6B4B4, 0x00B6B4B4, 0x00B5B4B3, 0x00B5B3B2, 0x00B4B2B2, 0x00B4B2B1, 0x00B3B1B1, 0x00B3B1B0, 0x00B3B0B0, 0x00B2B0B0, 0x00B2B0AF, 0x00B2B0AE, 0x00B1AFAE, 0x00B1AEAD, 0x00B0ADAD, 0x00AFADAC, 0x00AFADAD, 0x00AFADAC, 0x00AEACAA, 0x00ADABAA, 
        0x00ACA9A9, 0x00ADA9A9, 0x00ABA9A8, 0x00ABA9A8, 0x00ABA8A8, 0x00AAA8A7, 0x00AAA7A6, 0x00AAA6A6, 0x00A9A6A5, 0x00A8A6A4, 0x00A7A5A4, 0x00A7A4A3, 0x00A6A3A3, 0x00A6A3A2, 0x00A5A2A2, 0x00A4A2A1, 0x00A4A1A1, 0x00A3A1A0, 0x00A2A19F, 0x00A29F9F, 
        0x00A29F9E, 0x00A19E9D, 0x00A19E9D, 0x00A09D9C, 0x009F9D9C, 0x009F9B9A, 0x009E9A9A, 0x009D9A99, 0x009D9A99, 0x009D9998, 0x009C9998, 0x009C9897, 0x009B9896, 0x009A9796, 0x009A9695, 0x00989594, 0x00989493, 0x00979392, 0x00979392, 0x00989493, 
        0x009B9796, 0x00A09D9C, 0x009C9897, 0x00878583, 0x056C6A68, 0x5D484746, 0xD2161615, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFFD8D7D6, 0xFFD4D3D2, 0xFFD2D2D1, 0xFFD0D0CF, 0xFFCACAC8, 0xFFC6C5C3, 0xFFC6C6C5, 0xFFC3C2C1, 0xFFBFBEBD, 0xFFBEBDBB, 0xFFB8B8B6, 0xFFB8B7B6, 0xFFB7B6B4, 0xFFB4B3B1, 0xFFB1B0AF, 0xFFAFAEAC, 
        0xFFACABAA, 0xF2ACAAA9, 0x85A9A8A6, 0x14AEACAA, 0x00BEBCBB, 0x00CCCAC9, 0x00CBC9C9, 0x00C2BFBF, 0x00BCB9B9, 0x00BAB8B7, 0x00B9B8B7, 0x00B9B8B6, 0x00B9B7B6, 0x00B9B7B6, 0x00B9B6B6, 0x00B8B5B5, 0x00B8B5B4, 0x00B8B5B4, 0x00B7B4B3, 0x00B6B3B3, 
        0x00B5B3B3, 0x00B5B3B3, 0x00B5B2B2, 0x00B5B2B1, 0x00B4B2B1, 0x00B4B2B1, 0x00B4B1B0, 0x00B3B0B0, 0x00B3B0B0, 0x00B2AFAF, 0x00B1AFAE, 0x00B1AEAD, 0x00B1ADAD, 0x00B0ADAC, 0x00AFACAC, 0x00AFACAC, 0x00AEABAB, 0x00ADABAA, 0x00ADABA9, 0x00ADAAA9, 
        0x00ACAAA9, 0x00ABA9A9, 0x00ABA8A8, 0x00ABA8A7, 0x00AAA8A6, 0x00AAA7A6, 0x00A9A6A5, 0x00A9A5A5, 0x00A7A5A4, 0x00A7A4A3, 0x00A7A3A3, 0x00A6A3A2, 0x00A6A2A1, 0x00A6A2A1, 0x00A5A2A1, 0x00A5A1A0, 0x00A4A0A0, 0x00A2A09F, 0x00A29F9F, 0x00A29E9D, 
        0x00A19E9D, 0x00A09D9C, 0x009F9D9C, 0x009F9C9A, 0x009F9B9A, 0x009D9A9A, 0x009D9A99, 0x009C9999, 0x009C9998, 0x009C9898, 0x009B9797, 0x009B9796, 0x009A9696, 0x00999695, 0x00989594, 0x00979493, 0x00979492, 0x00979392, 0x00969291, 0x00959291, 
        0x00959190, 0x00959190, 0x00999594, 0x009E9A99, 0x00999694, 0x00868482, 0x11696866, 0x793F3E3D, 0xE6111010, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFFD8D7D6, 0xFFD4D3D2, 0xFFD2D2D1, 0xFFD0D0CF, 0xFFCACAC8, 0xFFC6C5C3, 0xFFC6C6C5, 0xFFC3C2C1, 0xFFBFBEBD, 0xFFBEBDBB, 0xFFB8B8B6, 0xFFB8B7B6, 0xFFB7B6B4, 0xFFB4B3B1, 0xFFB1B0AF, 0xFFAFADAC, 
        0xACACABAA, 0x2DAFAEAC, 0x00BBBAB8, 0x00CBC9C8, 0x00CCCACA, 0x00C3C1C0, 0x00BCBAB9, 0x00BAB8B8, 0x00BAB8B7, 0x00BAB8B7, 0x00BAB8B7, 0x00B9B7B7, 0x00B9B6B6, 0x00B8B6B6, 0x00B7B5B5, 0x00B7B5B3, 0x00B7B5B3, 0x00B7B4B3, 0x00B6B3B3, 0x00B6B3B3, 
        0x00B5B3B2, 0x00B5B3B2, 0x00B5B2B2, 0x00B4B2B1, 0x00B4B1B1, 0x00B3B1B0, 0x00B3B1AF, 0x00B2AFAF, 0x00B2AEAF, 0x00B1AEAD, 0x00B0AEAD, 0x00B0ADAD, 0x00B0ACAC, 0x00AFACAB, 0x00AFABAB, 0x00AEABAB, 0x00ADABAA, 0x00ADABAA, 0x00ADAAAA, 0x00ADAAA9, 
        0x00ACA9A9, 0x00ABA8A8, 0x00AAA7A7, 0x00A9A7A6, 0x00A9A6A5, 0x00A8A6A5, 0x00A8A5A4, 0x00A8A5A4, 0x00A7A4A3, 0x00A7A3A3, 0x00A6A3A2, 0x00A6A2A2, 0x00A5A2A1, 0x00A4A2A0, 0x00A4A19F, 0x00A39F9F, 0x00A39F9E, 0x00A29E9E, 0x00A19E9E, 0x00A19D9D, 
        0x00A09D9D, 0x00A09D9C, 0x009F9C9B, 0x009F9C9A, 0x009E9B9A, 0x009D9A99, 0x009D9A99, 0x009C9898, 0x009B9897, 0x009B9796, 0x009A9796, 0x00999695, 0x00999694, 0x00989594, 0x00989594, 0x00979392, 0x00979391, 0x00969292, 0x00969291, 0x0095918F, 
        0x0095908F, 0x00938F8E, 0x00938F8E, 0x0093908F, 0x00979492, 0x009D9897, 0x00959291, 0x00807E7D, 0x26636261, 0x9E333232, 0xFB020202, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFFD8D7D6, 0xFFD4D3D2, 0xFFD2D2D1, 0xFFD0D0CF, 0xFFCACAC8, 0xFFC6C5C3, 0xFFC6C6C5, 0xFFC3C2C1, 0xFFBFBEBD, 0xFFBEBDBB, 0xFFB8B8B6, 0xFFB8B7B6, 0xFFB7B6B4, 0xFFB4B3B1, 0xDDB1B0AF, 0x59B0AEAD, 
        0x00B8B7B5, 0x00C9C7C6, 0x00CECCCB, 0x00C4C3C2, 0x00BDBBBA, 0x00BBB8B8, 0x00BAB8B7, 0x00BAB8B8, 0x00BAB8B7, 0x00BAB8B7, 0x00B9B7B6, 0x00B8B5B5, 0x00B8B5B5, 0x00B8B5B5, 0x00B7B5B4, 0x00B7B5B4, 0x00B6B5B4, 0x00B6B3B3, 0x00B6B3B2, 0x00B6B2B1, 
        0x00B5B2B2, 0x00B5B2B1, 0x00B4B1B1, 0x00B4B1B0, 0x00B3B1B0, 0x00B3B0AF, 0x00B2AFAE, 0x00B1AEAE, 0x00B0AEAD, 0x00B0ADAD, 0x00B0ADAC, 0x00B0ADAC, 0x00AFACAC, 0x00AFACAB, 0x00AEABAB, 0x00AEABAA, 0x00ADAAAA, 0x00ADAAA9, 0x00ACA9A8, 0x00ACA8A8, 
        0x00ABA8A7, 0x00AAA7A7, 0x00A9A6A6, 0x00A9A6A6, 0x00A8A6A5, 0x00A8A6A5, 0x00A8A5A4, 0x00A8A5A3, 0x00A7A4A3, 0x00A6A3A1, 0x00A6A2A2, 0x00A5A1A1, 0x00A5A1A0, 0x00A4A09F, 0x00A3A09E, 0x00A29F9D, 0x00A29E9D, 0x00A19E9D, 0x00A19D9D, 0x00A09C9C, 
        0x00A09C9C, 0x009F9C9B, 0x009F9B9B, 0x009E9B9A, 0x009D9A99, 0x009D9998, 0x009C9997, 0x009B9897, 0x009B9796, 0x009A9696, 0x009A9696, 0x00989595, 0x00989594, 0x00989493, 0x00979492, 0x00969392, 0x00969291, 0x00959191, 0x0094918F, 0x0095908F, 
        0x0094908F, 0x0094908F, 0x00938F8E, 0x00928E8D, 0x00928E8C, 0x00938E8E, 0x00979392, 0x00999595, 0x008F8C8B, 0x007C7B79, 0x4E565554, 0xD0181818, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFFD8D7D6, 0xFFD4D3D2, 0xFFD2D2D1, 0xFFD0D0CF, 0xFFCACAC8, 0xFFC6C5C3, 0xFFC6C6C5, 0xFFC3C2C1, 0xFFBFBEBD, 0xFFBEBDBB, 0xFFB8B8B6, 0xFFB8B7B6, 0xFFB6B5B3, 0x9AB4B3B1, 0x1AB6B5B4, 0x00C4C3C2, 
        0x00CECDCC, 0x00C9C6C6, 0x00BFBDBC, 0x00BBB9B8, 0x00BBB8B7, 0x00BAB7B7, 0x00BAB7B7, 0x00B9B7B6, 0x00B9B7B6, 0x00B9B6B6, 0x00B8B6B5, 0x00B8B6B5, 0x00B8B6B5, 0x00B7B5B5, 0x00B7B5B4, 0x00B7B4B4, 0x00B6B4B3, 0x00B5B3B2, 0x00B6B2B1, 0x00B5B1B1, 
        0x00B5B1B1, 0x00B4B1B0, 0x00B3B0B0, 0x00B2B0AF, 0x00B2B0AF, 0x00B2AFAE, 0x00B1AFAD, 0x00B1AEAD, 0x00B0ADAD, 0x00B0ADAD, 0x00AFADAC, 0x00AFACAB, 0x00AFACAB, 0x00AEABAA, 0x00ADAAAA, 0x00ADA9A9, 0x00ACA9A9, 0x00ABA8A8, 0x00ABA8A7, 0x00AAA8A7, 
        0x00AAA8A6, 0x00AAA7A6, 0x00A9A6A6, 0x00A9A6A4, 0x00A8A5A5, 0x00A8A4A3, 0x00A7A4A3, 0x00A6A4A2, 0x00A6A3A1, 0x00A5A2A1, 0x00A5A1A0, 0x00A4A0A0, 0x00A4A09F, 0x00A49F9F, 0x00A29F9E, 0x00A29F9D, 0x00A29E9D, 0x00A19E9C, 0x00A09D9C, 0x00A09C9B, 
        0x009F9B9A, 0x009E9A9A, 0x009E9B9A, 0x009D9999, 0x009C9998, 0x009C9997, 0x009B9897, 0x009A9796, 0x009A9796, 0x00999695, 0x00999594, 0x00989494, 0x00979493, 0x00979493, 0x00979392, 0x00969391, 0x00969291, 0x00959190, 0x00959190, 0x0094918F, 
        0x0093908F, 0x00928F8E, 0x00928F8E, 0x00928D8D, 0x00918D8C, 0x00908C8B, 0x008F8C8A, 0x00918D8C, 0x00969291, 0x00959290, 0x008A8786, 0x15727170, 0x8B3F3E3E, 0xF5030303, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFFD8D7D6, 0xFFD4D3D2, 0xFFD2D2D1, 0xFFD0D0CF, 0xFFCACAC8, 0xFFC6C5C3, 0xFFC6C6C5, 0xFFC3C2C1, 0xFFBFBEBD, 0xFFBEBDBB, 0xFFB8B8B6, 0xE2B8B7B6, 0x56B7B6B4, 0x00C0BFBD, 0x00CDCCCA, 0x00CDCBCA, 
        0x00C1BFBF, 0x00BCB9B9, 0x00BBB8B7, 0x00BAB8B7, 0x00BAB7B7, 0x00BAB7B7, 0x00BAB7B7, 0x00B9B7B6, 0x00B9B6B6, 0x00B8B6B6, 0x00B8B6B5, 0x00B8B6B5, 0x00B7B5B4, 0x00B6B4B3, 0x00B6B4B3, 0x00B5B3B2, 0x00B5B3B2, 0x00B5B2B1, 0x00B5B1B0, 0x00B4B0B0, 
        0x00B4B0B0, 0x00B3B0B0, 0x00B2AFAF, 0x00B2B0AF, 0x00B1AFAE, 0x00B1AFAE, 0x00B1AFAE, 0x00B1AEAD, 0x00B0ADAC, 0x00B0ADAC, 0x00AEACAB, 0x00ADABAB, 0x00ADABAA, 0x00ADAAA9, 0x00ADA9A8, 0x00ACA8A8, 0x00ACA8A8, 0x00ABA8A7, 0x00AAA8A8, 0x00AAA7A6, 
        0x00AAA7A6, 0x00A9A6A5, 0x00A9A6A5, 0x00A8A5A4, 0x00A6A4A3, 0x00A6A4A3, 0x00A6A3A2, 0x00A5A2A1, 0x00A5A2A1, 0x00A4A1A0, 0x00A4A09F, 0x00A4A09F, 0x00A39F9F, 0x00A29F9F, 0x00A29E9E, 0x00A29D9D, 0x00A19D9C, 0x00A09D9B, 0x009E9C9A, 0x009F9B9B, 
        0x009E9A99, 0x009E9A99, 0x009D9999, 0x009D9898, 0x009C9898, 0x009B9797, 0x009B9797, 0x009A9695, 0x00999694, 0x00999594, 0x00989494, 0x00989493, 0x00979493, 0x00979392, 0x00979292, 0x00969291, 0x00959290, 0x00949190, 0x00949090, 0x0093908E, 
        0x00938E8D, 0x00928D8C, 0x00918D8D, 0x00918D8C, 0x00918C8C, 0x00908C8A, 0x008F8B8A, 0x008F8A89, 0x008F8A89, 0x00918D8C, 0x0095908F, 0x00908C8B, 0x00858382, 0x495F5F5E, 0xD2181818, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFFD8D7D6, 0xFFD4D3D2, 0xFFD2D2D1, 0xFFD0D0CF, 0xFFCACAC8, 0xFFC6C5C3, 0xFFC6C6C5, 0xFFC3C2C1, 0xFFBFBEBD, 0xFFBDBCBB, 0xB3B9B8B6, 0x23BCBCBA, 0x00C7C6C5, 0x00D0CECD, 0x00C7C5C4, 0x00BEBCBB, 
        0x00BAB8B7, 0x00BAB8B7, 0x00BAB8B7, 0x00BAB8B7, 0x00BAB7B7, 0x00BAB7B6, 0x00B9B7B6, 0x00B9B6B6, 0x00B8B6B6, 0x00B8B5B5, 0x00B8B5B4, 0x00B7B4B4, 0x00B6B4B4, 0x00B5B3B2, 0x00B5B3B2, 0x00B5B3B1, 0x00B4B1B1, 0x00B5B1B0, 0x00B4B1B0, 0x00B4B0B0, 
        0x00B3B0AF, 0x00B3B0AF, 0x00B2AFAF, 0x00B2AEAF, 0x00B1AFAE, 0x00B1AEAD, 0x00B0ADAD, 0x00AFADAC, 0x00AFACAB, 0x00AEABAB, 0x00ADABAA, 0x00ADABAA, 0x00ADAAA9, 0x00ADAAA8, 0x00ACA9A8, 0x00ACA9A8, 0x00ABA8A7, 0x00ABA8A7, 0x00AAA7A6, 0x00AAA6A6, 
        0x00A9A6A5, 0x00A9A5A4, 0x00A8A5A4, 0x00A7A4A3, 0x00A6A4A3, 0x00A6A3A2, 0x00A6A3A1, 0x00A5A2A1, 0x00A4A1A1, 0x00A4A19F, 0x00A3A09F, 0x00A39F9E, 0x00A29F9E, 0x00A29E9D, 0x00A19D9D, 0x00A19D9C, 0x00A09C9B, 0x009F9B9A, 0x009F9B9A, 0x009F9A9A, 
        0x009E9A99, 0x009D9A98, 0x009C9997, 0x009C9896, 0x009B9897, 0x009B9796, 0x009A9695, 0x009A9694, 0x00999594, 0x00999594, 0x00989493, 0x00979493, 0x00979392, 0x00979291, 0x00969290, 0x00959190, 0x00949190, 0x0093908F, 0x00938F8E, 0x00938F8D, 
        0x00928E8D, 0x00918E8C, 0x00918D8C, 0x00908C8B, 0x00908C8B, 0x008F8A8A, 0x008E8A89, 0x008E8A88, 0x008D8988, 0x008D8887, 0x008E8987, 0x00918D8C, 0x00918D8B, 0x008D8B8A, 0x1B797877, 0x9F373736, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFFD8D7D6, 0xFFD4D3D2, 0xFFD2D2D1, 0xFFD0D0CF, 0xFFCACAC8, 0xFFC6C5C3, 0xFFC6C6C5, 0xFFC3C2C1, 0xFDBFBEBD, 0x7BBEBDBC, 0x00C2C1BF, 0x00CDCCCA, 0x00CCCBC9, 0x00C1BFBF, 0x00BCBAB9, 0x00BAB8B8, 
        0x00BAB8B8, 0x00BAB8B8, 0x00BAB8B7, 0x00BAB8B7, 0x00BAB7B6, 0x00B9B6B5, 0x00B9B6B5, 0x00B8B5B5, 0x00B8B5B4, 0x00B7B4B4, 0x00B7B4B3, 0x00B6B4B2, 0x00B6B3B2, 0x00B5B2B2, 0x00B5B2B2, 0x00B4B2B1, 0x00B4B1B1, 0x00B4B1B0, 0x00B4B1B0, 0x00B3B0AF, 
        0x00B3B0AF, 0x00B2AFAE, 0x00B2AEAE, 0x00B1AEAD, 0x00B0ADAD, 0x00AFADAD, 0x00AFACAC, 0x00AEACAB, 0x00AEABAA, 0x00AEABAA, 0x00AEABAA, 0x00ADAAAA, 0x00ADA9A9, 0x00ABA9A8, 0x00ABA8A7, 0x00ABA8A7, 0x00AAA6A7, 0x00AAA6A6, 0x00A9A6A5, 0x00A9A5A4, 
        0x00A8A5A4, 0x00A8A5A4, 0x00A7A4A3, 0x00A6A3A3, 0x00A6A3A2, 0x00A6A3A2, 0x00A5A2A0, 0x00A4A1A0, 0x00A3A09F, 0x00A29F9E, 0x00A29F9E, 0x00A19E9D, 0x00A19E9D, 0x00A19D9C, 0x00A09D9C, 0x00A09D9B, 0x009F9B9B, 0x009E9B9A, 0x009F9A99, 0x009E9A99, 
        0x009D9999, 0x009C9898, 0x009C9897, 0x009C9897, 0x009B9796, 0x009B9695, 0x009A9695, 0x009A9694, 0x00999594, 0x00989493, 0x00979492, 0x00979391, 0x00969291, 0x00959291, 0x00959190, 0x00949190, 0x0094908F, 0x00938F8E, 0x00938F8E, 0x00938F8D, 
        0x00918E8D, 0x00918D8C, 0x00908C8A, 0x008F8B8A, 0x008F8B8A, 0x008E8989, 0x008E8988, 0x008E8988, 0x008D8888, 0x008C8887, 0x008C8786, 0x008B8685, 0x008E8A88, 0x00918C8B, 0x008E8B8A, 0x008B8A89, 0x6A535352, 0xEB090909, 0xFF000000, 0xFE000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFFD8D7D6, 0xFFD4D3D2, 0xFFD2D2D1, 0xFFD0D0CF, 0xFFCACAC8, 0xFFC6C5C3, 0xFFC6C6C5, 0xE4C3C2C1, 0x4DC1C1C0, 0x00C8C7C6, 0x00D0CECD, 0x00C9C7C6, 0x00BFBDBC, 0x00BBB9B8, 0x00BAB8B8, 0x00BBB8B8, 
        0x00BAB8B8, 0x00BAB8B7, 0x00BAB7B6, 0x00B9B7B6, 0x00B9B6B5, 0x00B9B5B5, 0x00B9B5B4, 0x00B8B5B4, 0x00B7B4B4, 0x00B6B4B3, 0x00B6B4B3, 0x00B6B3B2, 0x00B6B3B2, 0x00B5B2B2, 0x00B5B2B1, 0x00B4B2B1, 0x00B4B1B0, 0x00B4B1AF, 0x00B3B0AF, 0x00B3AFAF, 
        0x00B2AFAD, 0x00B2AEAE, 0x00B1ADAD, 0x00B0ADAD, 0x00B0ADAC, 0x00B0ADAB, 0x00B0ACAC, 0x00AFACAB, 0x00AEABAA, 0x00AEABAA, 0x00ADAAA9, 0x00ADA9A9, 0x00ACA8A8, 0x00ABA9A8, 0x00ABA8A6, 0x00AAA7A6, 0x00AAA7A6, 0x00AAA6A5, 0x00A9A6A5, 0x00A8A5A4, 
        0x00A8A4A3, 0x00A7A4A3, 0x00A7A3A2, 0x00A6A2A2, 0x00A5A2A1, 0x00A4A2A0, 0x00A4A1A0, 0x00A3A09F, 0x00A3A09F, 0x00A39F9E, 0x00A29F9D, 0x00A19E9D, 0x00A19D9D, 0x00A19D9C, 0x00A09D9B, 0x00A09C9A, 0x009F9C9A, 0x009F9A9A, 0x009E9A99, 0x009D9998, 
        0x009D9998, 0x009C9898, 0x009C9897, 0x009C9796, 0x009B9796, 0x009A9795, 0x00999695, 0x00999593, 0x00999393, 0x00989392, 0x00979391, 0x00969291, 0x00969191, 0x00959190, 0x00959090, 0x0095908F, 0x0094908F, 0x00938F8E, 0x00938E8E, 0x00928E8C, 
        0x00918D8C, 0x00908C8B, 0x00908B8A, 0x008F8B89, 0x008E8A89, 0x008E8A89, 0x008E8A88, 0x008D8988, 0x008D8887, 0x008C8886, 0x008C8786, 0x008B8684, 0x008A8584, 0x008C8885, 0x008E8988, 0x008F8A8A, 0x00918F8E, 0x3F6F6F6E, 0xD01A1919, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFFD8D7D6, 0xFFD4D3D2, 0xFFD2D2D1, 0xFFD0D0CF, 0xFFCACAC8, 0xFFC6C5C3, 0xC7C6C5C4, 0x28C7C6C5, 0x00CECCCB, 0x00CFCDCC, 0x00C5C3C2, 0x00BDBBBA, 0x00BBB9B8, 0x00BBB9B8, 0x00BAB8B7, 0x00BAB8B7, 
        0x00B9B8B7, 0x00B9B7B6, 0x00B9B7B5, 0x00B8B5B4, 0x00B9B5B4, 0x00B8B5B5, 0x00B8B4B4, 0x00B7B4B3, 0x00B7B4B4, 0x00B7B4B3, 0x00B6B3B3, 0x00B6B3B2, 0x00B5B3B2, 0x00B5B2B1, 0x00B4B2B0, 0x00B4B1B0, 0x00B4B0AF, 0x00B3AFAE, 0x00B2B0AE, 0x00B2AFAE, 
        0x00B1AEAD, 0x00B1AEAD, 0x00B0ADAC, 0x00B0ADAC, 0x00B0ACAC, 0x00B0ACAB, 0x00AFABAA, 0x00AEAAAA, 0x00ADAAA9, 0x00ACAAA8, 0x00ADA9A8, 0x00ACA8A7, 0x00ABA8A7, 0x00ABA8A6, 0x00ABA7A6, 0x00AAA7A6, 0x00AAA7A5, 0x00A9A6A4, 0x00A9A4A4, 0x00A7A4A3, 
        0x00A6A3A2, 0x00A6A2A1, 0x00A6A2A1, 0x00A5A1A1, 0x00A5A1A1, 0x00A4A0A0, 0x00A4A0A0, 0x00A3A09F, 0x00A3A09E, 0x00A29F9E, 0x00A19E9C, 0x00A19D9C, 0x00A19C9C, 0x00A09C9B, 0x00A09C9B, 0x009F9C9A, 0x009E9C99, 0x009F9A99, 0x009E9A98, 0x009D9998, 
        0x009D9997, 0x009C9897, 0x009C9796, 0x009B9696, 0x009A9695, 0x00999594, 0x00999593, 0x00999493, 0x00979392, 0x00979391, 0x00969291, 0x00959290, 0x00969190, 0x00959090, 0x0095908F, 0x00948F8E, 0x00938E8E, 0x00928E8D, 0x00918D8C, 0x00918D8B, 
        0x00908C8A, 0x00908B8A, 0x00908B89, 0x008F8B89, 0x008E8A88, 0x008E8A88, 0x008D8887, 0x008C8787, 0x008B8786, 0x008B8785, 0x008B8685, 0x008B8684, 0x008A8584, 0x00898583, 0x008A8583, 0x008C8685, 0x008C8786, 0x0094918F, 0x1F868483, 0xAE2C2B2B, 
        0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFFD8D7D6, 0xFFD4D3D2, 0xFFD2D2D1, 0xFFD0D0CF, 0xFFCAC9C8, 0xADC7C6C4, 0x10CBCAC9, 0x00D1CFCE, 0x00CDCBCB, 0x00C1BFBE, 0x00BCBAB9, 0x00BBB9B8, 0x00BBB8B8, 0x00BAB8B7, 0x00BAB7B7, 0x00B9B6B6, 
        0x00B9B6B5, 0x00B9B6B5, 0x00B9B6B5, 0x00B9B5B4, 0x00B8B5B4, 0x00B8B5B4, 0x00B7B4B4, 0x00B6B4B3, 0x00B6B4B3, 0x00B6B3B2, 0x00B5B3B2, 0x00B4B2B1, 0x00B4B1B1, 0x00B4B1B0, 0x00B3B1AF, 0x00B3B0AF, 0x00B3B0AE, 0x00B2AFAE, 0x00B2AFAE, 0x00B2AEAD, 
        0x00B1ADAD, 0x00B1ADAC, 0x00B0ADAB, 0x00AFACAA, 0x00AEABAB, 0x00AEABAA, 0x00ADABAA, 0x00ADAAA9, 0x00ADA9A8, 0x00ACA9A8, 0x00ACA8A7, 0x00ABA8A7, 0x00AAA8A7, 0x00AAA7A6, 0x00AAA7A6, 0x00A9A6A4, 0x00A9A5A4, 0x00A8A4A3, 0x00A8A3A2, 0x00A7A3A2, 
        0x00A6A3A2, 0x00A6A2A1, 0x00A6A2A0, 0x00A5A1A0, 0x00A5A0A0, 0x00A3A09F, 0x00A3A09F, 0x00A2A09E, 0x00A29F9D, 0x00A29E9D, 0x00A19E9C, 0x00A19D9C, 0x00A09C9B, 0x009F9C9B, 0x009F9C9B, 0x009F9B9A, 0x009D9A99, 0x009D9A99, 0x009D9997, 0x009C9896, 
        0x009C9896, 0x009B9796, 0x009A9795, 0x009A9595, 0x009A9594, 0x00999593, 0x00989493, 0x00989492, 0x00979392, 0x00979391, 0x00969190, 0x0095918F, 0x0095908F, 0x0094908F, 0x00948F8E, 0x00928E8E, 0x00928E8D, 0x00918D8C, 0x00918D8B, 0x00918D8B, 
        0x00908C8A, 0x00908B8A, 0x008F8B89, 0x008E8A89, 0x008E8A88, 0x008D8887, 0x008D8786, 0x008D8786, 0x008B8786, 0x008B8685, 0x008B8685, 0x008B8584, 0x00898484, 0x00898482, 0x00888381, 0x00888381, 0x008A8583, 0x008B8685, 0x00928E8D, 0x0B929190, 
        0x93424241, 0xF8000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFFD8D7D6, 0xFFD4D3D2, 0xFFD2D2D1, 0xFFD0D0CF, 0x91CCCBCA, 0x04CFCECD, 0x00D2D0CF, 0x00CBC8C8, 0x00BFBDBD, 0x00BBB8B8, 0x00BBB8B8, 0x00BAB8B7, 0x00BAB8B6, 0x00BAB7B6, 0x00BAB7B6, 0x00BAB7B6, 
        0x00BAB6B6, 0x00B9B6B5, 0x00B9B6B5, 0x00B9B5B4, 0x00B8B5B4, 0x00B7B4B3, 0x00B7B4B3, 0x00B6B4B3, 0x00B6B3B3, 0x00B6B3B2, 0x00B5B2B1, 0x00B4B2B1, 0x00B4B1B0, 0x00B3B1B0, 0x00B3B0B0, 0x00B3B0AF, 0x00B2B0AE, 0x00B2AFAE, 0x00B1AEAD, 0x00B1AEAD, 
        0x00B1ADAC, 0x00B0ACAC, 0x00AFACAB, 0x00AFACAB, 0x00AEABAB, 0x00AEABAA, 0x00ADABAA, 0x00ADAAA9, 0x00ADAAA8, 0x00ACA9A8, 0x00ABA8A7, 0x00AAA8A7, 0x00AAA7A6, 0x00AAA6A6, 0x00A9A6A5, 0x00A9A5A3, 0x00A8A5A3, 0x00A8A4A3, 0x00A7A4A3, 0x00A7A3A2, 
        0x00A6A3A2, 0x00A6A2A1, 0x00A5A1A0, 0x00A4A1A0, 0x00A4A09F, 0x00A3A09F, 0x00A39F9F, 0x00A39F9E, 0x00A29E9E, 0x00A29E9E, 0x00A19E9D, 0x00A19D9C, 0x00A09D9B, 0x00A09C9B, 0x009F9B9A, 0x009F9B99, 0x009E9999, 0x009D9898, 0x009D9997, 0x009C9897, 
        0x009C9896, 0x009B9795, 0x009A9795, 0x009A9594, 0x009A9594, 0x00999494, 0x00989393, 0x00979392, 0x00979291, 0x00969190, 0x00969290, 0x0095918F, 0x0095908F, 0x0094908E, 0x00938F8D, 0x00928E8D, 0x00928D8D, 0x00928D8C, 0x00918C8B, 0x00918B8B, 
        0x00908C8B, 0x008F8B8A, 0x008F8A89, 0x008E8A89, 0x008E8988, 0x008D8887, 0x008D8887, 0x008D8886, 0x008C8785, 0x008B8685, 0x008B8584, 0x008A8483, 0x00898483, 0x00898483, 0x00888382, 0x00878382, 0x00878281, 0x00888482, 0x008A8482, 0x008F8B89, 
        0x019B9998, 0x78555453, 0xF0000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFFD8D7D6, 0xFFD4D3D2, 0xFFD1D1D0, 0x79D1D1D0, 0x00D3D2D1, 0x00D2D1D0, 0x00C8C6C5, 0x00BFBCBB, 0x00BBB9B8, 0x00BBB9B8, 0x00BBB8B8, 0x00BAB8B7, 0x00BBB8B7, 0x00BAB8B7, 0x00BAB7B6, 0x00B9B7B6, 
        0x00B9B6B6, 0x00B9B6B5, 0x00B8B5B4, 0x00B8B4B4, 0x00B7B4B4, 0x00B7B4B3, 0x00B7B4B3, 0x00B6B3B3, 0x00B5B3B2, 0x00B5B2B2, 0x00B5B2B1, 0x00B4B2B1, 0x00B4B2B0, 0x00B3B1B0, 0x00B3B0AF, 0x00B3AFAE, 0x00B2AEAD, 0x00B1AEAD, 0x00B1AEAD, 0x00B0AEAC, 
        0x00B0ADAC, 0x00AFACAB, 0x00AFACAB, 0x00AFABAA, 0x00AEAAAA, 0x00AEAAAA, 0x00ADAAA9, 0x00ACAAA9, 0x00ABA9A8, 0x00ABA9A7, 0x00ABA7A7, 0x00ABA7A6, 0x00ABA6A6, 0x00AAA6A5, 0x00A9A6A4, 0x00A9A5A4, 0x00A8A5A4, 0x00A8A4A3, 0x00A7A3A2, 0x00A6A3A2, 
        0x00A5A2A1, 0x00A5A2A1, 0x00A5A1A0, 0x00A4A1A0, 0x00A4A09F, 0x00A4A09F, 0x00A39F9E, 0x00A39F9E, 0x00A39E9E, 0x00A19D9D, 0x00A09D9C, 0x00A09C9B, 0x009F9C9B, 0x009F9B9A, 0x009E9A99, 0x009E9A98, 0x009E9998, 0x009C9998, 0x009C9897, 0x009C9897, 
        0x009C9796, 0x009B9795, 0x009A9694, 0x00999694, 0x00999493, 0x00989492, 0x00989392, 0x00989292, 0x00979291, 0x00969290, 0x00969190, 0x00959190, 0x0095918F, 0x00948F8E, 0x00938F8D, 0x00928E8D, 0x00928D8C, 0x00928D8B, 0x00908D8B, 0x00908C8B, 
        0x008F8C8A, 0x008F8A8A, 0x008F8A89, 0x008E8A88, 0x008E8987, 0x008D8887, 0x008D8887, 0x008B8786, 0x008B8785, 0x008B8685, 0x008B8584, 0x008A8583, 0x00898483, 0x00898483, 0x00898382, 0x00888282, 0x00888181, 0x00878180, 0x00888280, 0x00898381, 
        0x008F8A88, 0x00A2A09F, 0x61626261, 0xEA010101, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFFD7D7D6, 0xFFD4D3D2, 0x6ED3D3D2, 0x00D5D5D3, 0x00D2D0CF, 0x00C6C5C4, 0x00BEBBBB, 0x00BCB9B8, 0x00BCB9B8, 0x00BBB9B8, 0x00BCB9B8, 0x00BBB8B7, 0x00BBB8B7, 0x00BAB7B6, 0x00B9B6B5, 0x00B8B6B4, 
        0x00B8B6B4, 0x00B8B6B4, 0x00B8B5B4, 0x00B8B4B4, 0x00B7B4B3, 0x00B7B4B3, 0x00B7B3B3, 0x00B6B2B2, 0x00B5B2B2, 0x00B4B1B2, 0x00B4B1B1, 0x00B4B1B0, 0x00B3B0AF, 0x00B3B0AE, 0x00B2AFAE, 0x00B2AFAE, 0x00B2AFAD, 0x00B1AEAD, 0x00B1ADAD, 0x00B1ADAC, 
        0x00B0ADAC, 0x00AFACAB, 0x00AFABAA, 0x00AFABAA, 0x00AEAAAA, 0x00ADAAA9, 0x00ACA9A9, 0x00ACA9A8, 0x00ACA9A7, 0x00ABA8A7, 0x00ABA7A6, 0x00AAA7A6, 0x00A9A6A5, 0x00A9A6A5, 0x00A9A5A4, 0x00A8A4A3, 0x00A7A4A3, 0x00A8A3A2, 0x00A7A4A2, 0x00A7A3A2, 
        0x00A6A2A2, 0x00A6A2A1, 0x00A5A1A0, 0x00A5A1A0, 0x00A4A09F, 0x00A4A09F, 0x00A39F9E, 0x00A29F9D, 0x00A19E9C, 0x00A19D9C, 0x00A09D9C, 0x00A09C9B, 0x009F9B9A, 0x009E9B9A, 0x009E9A99, 0x009E9A99, 0x009D9997, 0x009D9998, 0x009C9797, 0x009C9797, 
        0x009B9796, 0x009B9695, 0x009A9694, 0x00999593, 0x00999493, 0x00989492, 0x00979392, 0x00979392, 0x00979291, 0x00969290, 0x0096908F, 0x0095918F, 0x00948F8E, 0x00948F8D, 0x00938F8D, 0x00938E8D, 0x00928E8C, 0x00928D8C, 0x00908D8B, 0x00908C8B, 
        0x008F8B8A, 0x00908A89, 0x008F8A89, 0x008E8A88, 0x008E8987, 0x008D8887, 0x008D8787, 0x008C8785, 0x008C8785, 0x008C8685, 0x008B8684, 0x008B8584, 0x008A8583, 0x008A8482, 0x00898382, 0x00898381, 0x00888281, 0x00878281, 0x0087817F, 0x00888281, 
        0x00888281, 0x008B8685, 0x00A6A4A2, 0x566B6A6A, 0xE4060505, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDBDBDA, 0xFBD7D7D6, 0x65D8D7D6, 0x00D7D6D5, 0x00D1CFCE, 0x00C5C3C2, 0x00BEBBBA, 0x00BCB9B9, 0x00BCB9B9, 0x00BCB9B8, 0x00BBB9B8, 0x00BAB8B7, 0x00BAB7B6, 0x00BAB7B6, 0x00B9B7B6, 0x00B9B6B5, 0x00B8B6B5, 
        0x00B8B5B5, 0x00B8B5B4, 0x00B7B5B4, 0x00B7B4B3, 0x00B7B4B3, 0x00B5B4B2, 0x00B6B3B2, 0x00B5B2B1, 0x00B5B2B1, 0x00B5B1B0, 0x00B4B1B0, 0x00B3B0AF, 0x00B3B0AF, 0x00B3B0AF, 0x00B1AFAE, 0x00B1AFAE, 0x00B1AFAE, 0x00B1AEAD, 0x00B1ADAC, 0x00B0ACAC, 
        0x00B0ABAB, 0x00AFABAB, 0x00AEABAA, 0x00AEABAA, 0x00AEABA9, 0x00ADAAA9, 0x00ACA9A8, 0x00ACA9A8, 0x00ACA9A7, 0x00ABA7A6, 0x00AAA7A6, 0x00AAA7A6, 0x00A9A6A5, 0x00A9A5A4, 0x00A9A5A4, 0x00A8A5A3, 0x00A7A4A3, 0x00A7A4A3, 0x00A7A4A2, 0x00A6A3A2, 
        0x00A6A2A1, 0x00A5A2A0, 0x00A5A1A0, 0x00A4A09F, 0x00A4A09E, 0x00A29F9E, 0x00A29E9D, 0x00A29E9D, 0x00A19D9C, 0x00A19C9C, 0x00A09C9C, 0x00A09C9A, 0x009F9C9A, 0x009E9B9A, 0x009E9A99, 0x009E9998, 0x009D9897, 0x009D9896, 0x009C9896, 0x009B9796, 
        0x009B9695, 0x009B9695, 0x009A9594, 0x00999593, 0x00989593, 0x00989492, 0x00989292, 0x00979291, 0x00959290, 0x00959190, 0x0095908F, 0x0094908F, 0x00948F8E, 0x00948F8E, 0x00938F8D, 0x00928E8D, 0x00928E8C, 0x00928D8C, 0x00928B8B, 0x00918B8A, 
        0x00908A89, 0x00908B89, 0x00908A88, 0x008F8988, 0x008F8888, 0x008E8887, 0x008E8886, 0x008D8886, 0x008D8786, 0x008C8785, 0x008C8685, 0x008A8684, 0x008A8584, 0x008A8583, 0x00898482, 0x00898482, 0x00888382, 0x00888281, 0x00888281, 0x00878180, 
        0x00878281, 0x00878281, 0x008A8483, 0x00A7A5A4, 0x4D757372, 0xDF090909, 0xFB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0xFDDBDAD9, 0x61DBDBDA, 0x00DAD9D8, 0x00D1CFCE, 0x00C5C2C1, 0x00BEBBBA, 0x00BCB9B8, 0x00BCB9B8, 0x00BBB8B8, 0x00BAB8B7, 0x00BAB8B7, 0x00BAB8B7, 0x00BAB7B6, 0x00B9B7B6, 0x00B9B7B6, 0x00B9B6B6, 0x00B9B6B4, 
        0x00B8B5B5, 0x00B8B5B4, 0x00B7B4B3, 0x00B7B4B3, 0x00B6B3B3, 0x00B6B3B2, 0x00B5B2B2, 0x00B5B2B1, 0x00B5B2B0, 0x00B4B1B0, 0x00B3B1AF, 0x00B3B1B0, 0x00B3B0AF, 0x00B2B0AF, 0x00B2AFAE, 0x00B1AEAE, 0x00B1ADAC, 0x00B0ADAB, 0x00B0ADAB, 0x00AFACAB, 
        0x00AFABAB, 0x00AFABAB, 0x00AEAAAA, 0x00AEAAA9, 0x00ADA9A8, 0x00ADA9A8, 0x00ACA8A8, 0x00ABA8A8, 0x00ABA7A7, 0x00ABA7A7, 0x00AAA7A6, 0x00AAA7A5, 0x00AAA6A5, 0x00A9A6A4, 0x00A9A5A4, 0x00A8A5A4, 0x00A8A4A3, 0x00A7A4A3, 0x00A6A3A2, 0x00A6A2A1, 
        0x00A6A2A1, 0x00A5A1A0, 0x00A4A09F, 0x00A3A09E, 0x00A39F9E, 0x00A29E9D, 0x00A29E9D, 0x00A19D9C, 0x00A09D9C, 0x00A09D9C, 0x00A09C9B, 0x009F9C9A, 0x009F9B99, 0x009F9A99, 0x009E9A98, 0x009E9998, 0x009D9998, 0x009C9897, 0x009C9896, 0x009C9795, 
        0x009B9695, 0x009A9695, 0x00999594, 0x00999493, 0x00989392, 0x00989392, 0x00979292, 0x00979290, 0x00969190, 0x0096918F, 0x0095908F, 0x0095908E, 0x0095908E, 0x00948F8E, 0x00938E8D, 0x00928D8C, 0x00938D8C, 0x00928D8B, 0x00928C8A, 0x00928C8A, 
        0x00918B89, 0x00908B89, 0x00908B89, 0x008F8988, 0x008F8988, 0x008E8987, 0x008E8887, 0x008D8887, 0x008C8886, 0x008C8786, 0x008B8785, 0x008B8685, 0x008B8584, 0x008A8584, 0x00898583, 0x00898482, 0x00898382, 0x00888382, 0x00888381, 0x00888381, 
        0x00868280, 0x00878280, 0x00888281, 0x00898483, 0x00AAA7A6, 0x497A7877, 0xDE070707, 0xFA000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDEDEDD, 0xFFDEDEDD, 0xFFDEDEDD, 0xFFDEDEDD, 0xFFDEDEDD, 0xFFDEDEDD, 0xFFDEDEDD, 0xFFDEDEDD, 0xFFDEDEDD, 0xFFDEDEDD, 0xFFDEDEDD, 0xFFDEDEDD, 0xFFDEDEDD, 0xFFDEDEDD, 0xFFDEDEDD, 0xFFDEDEDD, 0xFFDEDEDD, 0xFFDEDEDD, 0xFFDEDEDD, 0xFFDEDEDD, 0xFFDDDDDD, 
        0xFFDDDDDC, 0xFFDDDDDC, 0xFFDDDDDC, 0x6ADEDEDD, 0x00DCDBDA, 0x00D1CFCE, 0x00C4C2C1, 0x00BDBAB9, 0x00BCB9B8, 0x00BCB9B8, 0x00BCB9B8, 0x00BBB8B7, 0x00BBB8B7, 0x00BBB8B7, 0x00BAB7B7, 0x00BAB7B6, 0x00BAB6B6, 0x00B9B6B5, 0x00B9B6B5, 0x00B8B6B4, 
        0x00B8B5B3, 0x00B7B5B4, 0x00B7B3B3, 0x00B7B3B2, 0x00B6B3B2, 0x00B6B3B2, 0x00B6B1B2, 0x00B5B1B1, 0x00B4B1B1, 0x00B3B1B0, 0x00B3B1AF, 0x00B3B0AF, 0x00B2AFAF, 0x00B2AFAE, 0x00B2AEAD, 0x00B1AEAD, 0x00B1AEAC, 0x00B1ADAC, 0x00B0ACAC, 0x00AFACAB, 
        0x00AFABAB, 0x00AFABA9, 0x00AEAAA9, 0x00ADAAA8, 0x00ACA9A8, 0x00ACA9A8, 0x00ACA9A8, 0x00ACA8A7, 0x00ACA7A6, 0x00ABA7A6, 0x00AAA7A6, 0x00AAA6A5, 0x00A9A6A5, 0x00A9A6A4, 0x00A8A4A4, 0x00A8A4A3, 0x00A8A4A2, 0x00A6A3A2, 0x00A6A2A2, 0x00A6A2A2, 
        0x00A6A2A0, 0x00A5A1A1, 0x00A5A19F, 0x00A5A19F, 0x00A4A09F, 0x00A49F9F, 0x00A39F9E, 0x00A29E9D, 0x00A19E9D, 0x00A19D9C, 0x00A19C9B, 0x00A09C9A, 0x00A09B9A, 0x009F9B99, 0x009E9A99, 0x009E9998, 0x009E9897, 0x009D9897, 0x009C9795, 0x009B9795, 
        0x009B9695, 0x009A9594, 0x009A9594, 0x009A9493, 0x00999393, 0x00989391, 0x00989391, 0x00989290, 0x00979190, 0x00979190, 0x0096918F, 0x0095918E, 0x00958F8E, 0x00948F8D, 0x00948F8D, 0x00938E8C, 0x00938E8C, 0x00938E8B, 0x00918D8B, 0x00918C8B, 
        0x00918C8A, 0x00908B89, 0x008F8B89, 0x008F8A89, 0x008F8988, 0x008F8987, 0x008E8987, 0x008D8987, 0x008C8886, 0x008C8786, 0x008C8785, 0x008B8685, 0x008B8685, 0x008A8584, 0x00898583, 0x00898482, 0x00898482, 0x00898482, 0x00888482, 0x00888381, 
        0x00888281, 0x00888281, 0x00878281, 0x00878280, 0x00888381, 0x00ADABA9, 0x4F767474, 0xE0030303, 0xF9000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEBEBEA, 0xFFE5E5E4, 
        0xFFE2E1E1, 0xFFE2E2E2, 0x73E2E2E2, 0x00DFDDDD, 0x00D2CFCE, 0x00C4C2C0, 0x00BEBBB9, 0x00BCB9B8, 0x00BCBAB8, 0x00BCB9B8, 0x00BCB9B8, 0x00BBB8B7, 0x00BBB8B7, 0x00BBB8B7, 0x00BAB7B6, 0x00BAB7B6, 0x00BAB6B5, 0x00B9B6B4, 0x00B9B5B4, 0x00B8B4B4, 
        0x00B8B4B3, 0x00B7B4B3, 0x00B7B3B3, 0x00B6B3B2, 0x00B6B3B1, 0x00B6B2B1, 0x00B5B2B0, 0x00B5B1B0, 0x00B4B1B0, 0x00B4B0B0, 0x00B3B0AF, 0x00B3B0AF, 0x00B3AFAE, 0x00B2AFAE, 0x00B2AEAD, 0x00B1AEAD, 0x00B1ADAC, 0x00B0ACAC, 0x00B0ACAB, 0x00AFABAA, 
        0x00AFABAA, 0x00AEABA9, 0x00AEAAA9, 0x00AEAAA9, 0x00ADA9A9, 0x00ADA9A8, 0x00ADA8A7, 0x00ACA8A7, 0x00ACA7A6, 0x00ABA7A6, 0x00ABA6A6, 0x00AAA6A5, 0x00AAA6A5, 0x00AAA6A4, 0x00A9A5A4, 0x00A9A5A4, 0x00A8A4A3, 0x00A7A3A1, 0x00A5A19F, 0x00A49F9E, 
        0x00A39E9D, 0x00A09C9A, 0x009F9A98, 0x009D9897, 0x009C9896, 0x009C9796, 0x009D9796, 0x009D9896, 0x009E9998, 0x009F9998, 0x009F9A99, 0x009F9A99, 0x009F9B99, 0x00A09B9A, 0x00A09A99, 0x009F9A98, 0x009F9998, 0x009D9996, 0x009C9896, 0x009B9796, 
        0x009B9795, 0x009B9694, 0x009A9594, 0x00999594, 0x00999493, 0x00989492, 0x00989291, 0x00979391, 0x00969291, 0x00969291, 0x00969290, 0x0095918F, 0x0095908F, 0x0095908E, 0x0094908E, 0x00948F8D, 0x00928E8D, 0x00928D8D, 0x00918D8C, 0x00908C8A, 
        0x00908C8A, 0x00908B8A, 0x00908B89, 0x00908B89, 0x008F8A89, 0x008F8988, 0x008E8988, 0x008E8987, 0x008D8886, 0x008C8886, 0x008B8786, 0x008B8685, 0x008B8684, 0x008B8684, 0x008A8584, 0x008A8584, 0x008A8483, 0x00898483, 0x00898482, 0x00888381, 
        0x00888381, 0x00878281, 0x00878180, 0x00878280, 0x0087817F, 0x00888381, 0x00B1AFAE, 0x55706F6F, 0xE2000000, 0xF9000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFECECEB, 0xFFE5E5E5, 
        0xFFE1E1E1, 0x83E4E5E4, 0x00E2E1E1, 0x00D3D0CF, 0x00C6C2C2, 0x00BEBBBA, 0x00BEBAB9, 0x00BDB9B9, 0x00BDBAB8, 0x00BCB9B8, 0x00BCB9B8, 0x00BCB8B7, 0x00BBB8B7, 0x00BBB7B7, 0x00BAB7B6, 0x00BAB7B5, 0x00BAB6B5, 0x00B9B6B5, 0x00B9B6B4, 0x00B8B5B3, 
        0x00B8B4B3, 0x00B8B4B3, 0x00B7B3B2, 0x00B7B3B2, 0x00B6B2B2, 0x00B6B2B1, 0x00B6B2B0, 0x00B5B1B0, 0x00B5B1B0, 0x00B4B1AF, 0x00B4B1AF, 0x00B4B0AF, 0x00B3AFAE, 0x00B2AFAE, 0x00B2AEAD, 0x00B2ADAC, 0x00B1ADAC, 0x00B1ACAB, 0x00B1ACAB, 0x00B0ACAA, 
        0x00B0ACAA, 0x00AFACAA, 0x00AFAAA9, 0x00AFAAA9, 0x00AEAAA8, 0x00ADA9A8, 0x00ADA8A7, 0x00ACA8A7, 0x00ACA8A7, 0x00ACA8A6, 0x00ACA8A6, 0x00ABA7A5, 0x00A8A4A3, 0x00A5A1A0, 0x00A09C9A, 0x009A9694, 0x0094908E, 0x008E8987, 0x00898482, 0x0086807E, 
        0x00837D7B, 0x00807A78, 0x007E7978, 0x007C7775, 0x007D7876, 0x007D7876, 0x007D7775, 0x007E7876, 0x007F7A77, 0x00807B79, 0x00827D7C, 0x00847F7E, 0x00888481, 0x008E8A88, 0x00938F8C, 0x00979390, 0x009A9795, 0x009C9996, 0x009D9998, 0x009C9997, 
        0x009C9896, 0x009B9795, 0x009A9694, 0x00999594, 0x00999592, 0x00989592, 0x00979492, 0x00979392, 0x00969391, 0x00969391, 0x00969290, 0x0096918F, 0x0095918F, 0x0094908F, 0x0093908E, 0x00938F8C, 0x00928F8D, 0x00928E8C, 0x00928D8B, 0x00918D8B, 
        0x00918D8B, 0x00918C8A, 0x00908C89, 0x008F8B89, 0x008E8A89, 0x008E8987, 0x008E8987, 0x008D8987, 0x008D8987, 0x008C8886, 0x008C8885, 0x008C8785, 0x008B8784, 0x008C8785, 0x008B8684, 0x008B8583, 0x008A8583, 0x00898582, 0x00888582, 0x00888482, 
        0x00888381, 0x00878281, 0x00878281, 0x00878280, 0x00878381, 0x0085817F, 0x00888481, 0x00B5B2B1, 0x61686666, 0xE7000000, 0xF9000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFECECEB, 0xFFE5E5E4, 
        0xA1E4E4E4, 0x01E7E6E5, 0x00D6D3D2, 0x00C7C4C2, 0x00BFBCBA, 0x00BEBAB9, 0x00BEBAB9, 0x00BDBAB8, 0x00BDB9B8, 0x00BCB9B8, 0x00BCB9B7, 0x00BCB9B7, 0x00BBB8B6, 0x00BBB8B6, 0x00BAB7B6, 0x00BAB7B5, 0x00B9B7B5, 0x00B9B6B4, 0x00B9B6B3, 0x00B8B5B3, 
        0x00B8B5B3, 0x00B8B5B3, 0x00B7B4B2, 0x00B7B4B2, 0x00B7B3B2, 0x00B6B3B1, 0x00B6B3B1, 0x00B5B2B1, 0x00B5B2B0, 0x00B4B1AF, 0x00B4B1AF, 0x00B4B0AE, 0x00B3AFAE, 0x00B2AFAD, 0x00B2AFAC, 0x00B2AEAC, 0x00B1AEAC, 0x00B1AEAC, 0x00B1AEAB, 0x00B0ADAB, 
        0x00B0ACAA, 0x00B0ACAA, 0x00AFABA9, 0x00AEABA9, 0x00AEAAA8, 0x00AEAAA8, 0x00AEAAA8, 0x00ADA9A7, 0x00ABA7A5, 0x00A6A3A0, 0x009F9B99, 0x0095918F, 0x008B8785, 0x00847F7C, 0x007E7977, 0x007C7674, 0x007C7573, 0x007F7876, 0x007E7876, 0x00797271, 
        0x00766F6E, 0x00756E6C, 0x01746D6C, 0x01746D6B, 0x02746D6B, 0x02746D6B, 0x01746D6B, 0x01746D6C, 0x00756E6C, 0x0077706E, 0x007A7371, 0x007E7775, 0x007D7775, 0x007A7472, 0x00797371, 0x007A7472, 0x007E7876, 0x00837E7C, 0x008B8684, 0x00938E8C, 
        0x00989392, 0x009B9694, 0x009B9795, 0x009B9695, 0x00999593, 0x00999593, 0x00989492, 0x00989392, 0x00979390, 0x00979390, 0x00969290, 0x0096918F, 0x0095918F, 0x0095908E, 0x0094908D, 0x00948F8C, 0x00948F8C, 0x00948F8C, 0x00928E8C, 0x00928D8B, 
        0x00928D8A, 0x00918C89, 0x00908B89, 0x00908B89, 0x00908B88, 0x008F8B88, 0x008F8B88, 0x008E8A87, 0x008E8987, 0x008E8987, 0x008D8886, 0x008D8886, 0x008C8885, 0x008C8785, 0x008C8784, 0x008B8784, 0x008B8683, 0x008A8683, 0x00898582, 0x00898582, 
        0x008A8481, 0x00898481, 0x00898381, 0x00888381, 0x00878280, 0x00888280, 0x00857F7D, 0x008C8785, 0x00BAB7B6, 0x79555453, 0xEB000000, 0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xBAE9E9E8, 
        0x0AE8E8E8, 0x00D9D6D5, 0x00C9C6C4, 0x00C0BDBB, 0x00BEBBBA, 0x00BEBBBA, 0x00BEBAB9, 0x00BEBAB9, 0x00BDBAB9, 0x00BDB9B8, 0x00BDB9B7, 0x00BCB9B7, 0x00BBB8B6, 0x00BBB8B6, 0x00BAB8B5, 0x00BAB7B5, 0x00BAB7B5, 0x00B9B6B5, 0x00B9B5B5, 0x00B9B5B4, 
        0x00B8B5B4, 0x00B8B4B3, 0x00B8B4B2, 0x00B7B4B2, 0x00B7B3B2, 0x00B6B3B2, 0x00B6B3B1, 0x00B5B2B1, 0x00B5B1B0, 0x00B5B1B0, 0x00B4B1AF, 0x00B4B1AF, 0x00B3B0AE, 0x00B3B0AD, 0x00B2B0AD, 0x00B2AFAD, 0x00B2AEAD, 0x00B2AEAC, 0x00B1ADAB, 0x00B0ADAB, 
        0x00B0ACAA, 0x00AFACAA, 0x00AFABAA, 0x00AFABAA, 0x00AFABA9, 0x00ACA8A7, 0x00A6A1A0, 0x009C9795, 0x008F8A88, 0x00847E7C, 0x007F7876, 0x007E7775, 0x00817978, 0x007A7372, 0x02766F6E, 0x0B696362, 0x15575151, 0x1E464242, 0x263A3636, 0x2D2E2B2B, 
        0x34262424, 0x3B1C1A1A, 0x3F161414, 0x40171515, 0x460C0B0B, 0x460C0B0B, 0x42161515, 0x43151414, 0x3E1C1A1A, 0x38262424, 0x332F2C2C, 0x2A3A3637, 0x21474242, 0x17585352, 0x0C6A6463, 0x0277706F, 0x007B7472, 0x007F7876, 0x007C7472, 0x007A7271, 
        0x007C7675, 0x00847F7D, 0x008E8987, 0x0096918F, 0x00999492, 0x009A9593, 0x00999492, 0x00989491, 0x00989390, 0x00979390, 0x00969290, 0x0096918F, 0x0096918F, 0x0095908E, 0x00958F8E, 0x00958F8D, 0x00948E8D, 0x00938E8C, 0x00928E8C, 0x00928D8B, 
        0x00928D8B, 0x00928C8A, 0x00918C8A, 0x00918C89, 0x00908C8A, 0x00908B89, 0x00908B88, 0x00908A88, 0x008F8987, 0x008F8887, 0x008E8886, 0x008E8886, 0x008D8886, 0x008D8785, 0x008C8785, 0x008C8785, 0x008B8584, 0x008B8583, 0x008B8582, 0x008A8582, 
        0x008A8482, 0x00898482, 0x00898382, 0x00898381, 0x00898380, 0x00898380, 0x008A8381, 0x00857F7D, 0x00938F8C, 0x04BAB6B6, 0x8D414040, 0xEF000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFEEEEEE, 0xFFEEEEEE, 0xFFEEEEEE, 0xFFEEEEEE, 0xFFEEEEEE, 0xFFEEEEEE, 0xFFEEEEEE, 0xFFEEEEEE, 0xFFEEEEEE, 0xFFEEEEEE, 0xFFEEEEEE, 0xFFEEEEEE, 0xFFEEEEEE, 0xFFEEEEEE, 0xFFEEEEEE, 0xFFEEEEEE, 0xFFEEEEEE, 0xFFEFEFEF, 0xFFECECEC, 0xD8ECECEC, 0x17EDEDED, 
        0x00DBD9D8, 0x00C9C7C5, 0x00C1BEBD, 0x00BFBBBA, 0x00BFBBBA, 0x00BEBBBA, 0x00BEBBB9, 0x00BEBAB9, 0x00BDBAB9, 0x00BCBAB8, 0x00BCB9B8, 0x00BBB9B8, 0x00BBB8B7, 0x00BBB8B7, 0x00BAB8B6, 0x00BAB7B6, 0x00BAB7B6, 0x00B9B6B5, 0x00B8B6B5, 0x00B9B6B4, 
        0x00B8B5B4, 0x00B8B5B4, 0x00B7B4B4, 0x00B7B4B2, 0x00B6B3B2, 0x00B6B2B2, 0x00B6B2B1, 0x00B5B2B1, 0x00B5B2B1, 0x00B5B1B0, 0x00B4B1B0, 0x00B4B1B0, 0x00B3B0AF, 0x00B3B0AE, 0x00B2AFAE, 0x00B2AEAD, 0x00B1AEAD, 0x00B1AEAC, 0x00B0ADAC, 0x00B0ADAB, 
        0x00B0ACAB, 0x00B0ACAB, 0x00AEABA9, 0x00A9A6A4, 0x009E9A98, 0x008F8B89, 0x00837D7C, 0x007E7877, 0x00827B79, 0x007E7876, 0x06736D6B, 0x155A5554, 0x223F3B3B, 0x31272524, 0x400E0D0D, 0x49040404, 0x52000000, 0x59000000, 0x60000000, 0x65000000, 
        0x6B000000, 0x6F000000, 0x73000000, 0x77000000, 0x79000000, 0x7B000000, 0x7B000000, 0x7B000000, 0x7A000000, 0x78000000, 0x75000000, 0x71000000, 0x6C000000, 0x63000000, 0x5A040404, 0x4F0E0D0D, 0x3D282525, 0x2A403C3B, 0x195C5656, 0x06756E6D, 
        0x007F7877, 0x00807977, 0x007A7472, 0x007A7573, 0x00837E7B, 0x008E8A87, 0x00969290, 0x00989492, 0x00999492, 0x00989391, 0x00979290, 0x0096918F, 0x0096928F, 0x0095918E, 0x0095908E, 0x0094908E, 0x0093908E, 0x00938F8D, 0x00938E8D, 0x00938E8C, 
        0x00938E8C, 0x00928E8C, 0x00928D8B, 0x00918C8A, 0x00908C8A, 0x00908B89, 0x00908B89, 0x008F8A88, 0x008F8A88, 0x008F8A88, 0x008F8988, 0x008E8987, 0x008E8987, 0x008D8886, 0x008D8785, 0x008C8785, 0x008C8784, 0x008C8684, 0x008C8684, 0x008B8684, 
        0x008A8683, 0x008A8583, 0x008A8583, 0x008A8582, 0x008A8582, 0x00898481, 0x00888381, 0x00898381, 0x00847E7C, 0x009A9694, 0x0EB4B1B1, 0xA7272626, 0xF2000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF2F2F3, 0xF2EEEEED, 0x37F0F0EF, 0x00E2E0E0, 
        0x00CCC9C7, 0x00C3C0BE, 0x00BFBCBB, 0x00BFBCBA, 0x00BEBBBA, 0x00BEBBB9, 0x00BDBBB9, 0x00BDBAB9, 0x00BDBAB8, 0x00BCBAB8, 0x00BCB9B8, 0x00BCB9B7, 0x00BBB9B7, 0x00BBB8B7, 0x00BBB8B6, 0x00BAB7B6, 0x00BAB7B6, 0x00B9B6B5, 0x00B8B6B5, 0x00B8B6B4, 
        0x00B8B5B4, 0x00B8B5B3, 0x00B7B4B3, 0x00B7B4B3, 0x00B7B3B2, 0x00B7B3B1, 0x00B6B3B1, 0x00B5B3B1, 0x00B5B2B0, 0x00B5B2B0, 0x00B4B1B0, 0x00B4B1AF, 0x00B3B0AE, 0x00B3B0AE, 0x00B2AFAE, 0x00B1AFAD, 0x00B1AEAD, 0x00B1AEAC, 0x00B1AEAD, 0x00B1ADAB, 
        0x00AFABAA, 0x00A6A3A1, 0x00979391, 0x00878281, 0x00807A78, 0x00837C7A, 0x00807977, 0x0B6F6867, 0x1D494544, 0x31292726, 0x42090808, 0x4E000000, 0x58000000, 0x61000000, 0x6B000000, 0x75000000, 0x81000000, 0x8C000000, 0x97000000, 0xA0000000, 
        0xA8000000, 0xAF000000, 0xB5000000, 0xB9000000, 0xBC000000, 0xBE000000, 0xBE000000, 0xBE000000, 0xBC000000, 0xB9000000, 0xB5000000, 0xAF000000, 0xA8000000, 0xA0000000, 0x98000000, 0x8D000000, 0x84000000, 0x79000000, 0x6B000000, 0x5A090908, 
        0x41292727, 0x264B4746, 0x0C716B6A, 0x00827B79, 0x00827C7A, 0x007A7472, 0x007C7775, 0x00888481, 0x00948F8D, 0x00979391, 0x00989492, 0x00979290, 0x00979290, 0x00969290, 0x0095918F, 0x0095918F, 0x0095908E, 0x0095908E, 0x0094908D, 0x00948F8D, 
        0x00938F8C, 0x00928E8C, 0x00928D8B, 0x00918D8B, 0x00918D8B, 0x00918D8A, 0x00908C8A, 0x00908C89, 0x00908B89, 0x008F8B88, 0x008F8A88, 0x008E8A87, 0x008E8987, 0x008D8986, 0x008D8986, 0x008D8986, 0x008D8886, 0x008D8885, 0x008C8885, 0x008C8785, 
        0x008C8784, 0x008B8684, 0x008B8683, 0x008A8683, 0x008A8683, 0x008A8582, 0x008A8582, 0x008A8482, 0x00898582, 0x00837E7B, 0x00A8A4A3, 0x23A4A1A1, 0xC2101010, 0xF3000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFE8E7E7, 0xFFE8E7E7, 0xFFE8E7E7, 0xFFE8E7E7, 0xFFE8E7E7, 0xFFE8E7E7, 0xFFE8E7E7, 0xFFE8E7E7, 0xFFE8E7E7, 0xFFE8E7E7, 0xFFE8E7E7, 0xFFE8E7E7, 0xFFE8E7E7, 0xFFE8E7E7, 0xFFE8E7E7, 0xFFE8E7E7, 0xFFE8E7E7, 0xFFF0F0F0, 0x63F4F3F3, 0x00E7E6E6, 0x00CECCCB, 
        0x00C4C1C0, 0x00BFBCBA, 0x00BFBCBA, 0x00BEBBBA, 0x00BEBBBA, 0x00BDBBB9, 0x00BDBAB9, 0x00BDB9B9, 0x00BDB9B9, 0x00BCB9B9, 0x00BCB9B8, 0x00BCB9B7, 0x00BBB8B7, 0x00BBB8B7, 0x00BBB8B6, 0x00BAB7B6, 0x00BAB7B6, 0x00B9B6B5, 0x00B9B6B5, 0x00B9B6B4, 
        0x00B8B5B4, 0x00B8B5B3, 0x00B8B4B3, 0x00B7B4B3, 0x00B7B3B2, 0x00B6B3B2, 0x00B6B2B1, 0x00B5B2B1, 0x00B4B2B0, 0x00B3B1B0, 0x00B4B1AF, 0x00B3B1AE, 0x00B3B0AF, 0x00B3AFAE, 0x00B2AFAD, 0x00B2AFAC, 0x00B2AEAC, 0x00B1AEAD, 0x00AFACAA, 0x00A5A2A0, 
        0x00948F8D, 0x00827E7C, 0x00827B79, 0x00877F7E, 0x0778716F, 0x1C504B4A, 0x33252322, 0x45040404, 0x52000000, 0x5C000000, 0x69000000, 0x78000000, 0x89000000, 0x9A000000, 0xAA000000, 0xB8000000, 0xC5000000, 0xCE000000, 0xD7000000, 0xDE000000, 
        0xE3000000, 0xE7000000, 0xEA000000, 0xEC000000, 0xEE000000, 0xEF000000, 0xF0000000, 0xEF000000, 0xEE000000, 0xEC000000, 0xEA000000, 0xE7000000, 0xE3000000, 0xDE000000, 0xD7000000, 0xCE000000, 0xC5000000, 0xB8000000, 0xAA000000, 0x9B000000, 
        0x8C000000, 0x7B000000, 0x65050404, 0x48262423, 0x25524D4C, 0x077B7473, 0x00888180, 0x007F7876, 0x007A7572, 0x0085807E, 0x00928E8B, 0x00979391, 0x00989391, 0x00969290, 0x0096918F, 0x0096918F, 0x0095908E, 0x0095908E, 0x00938F8D, 0x00938F8C, 
        0x00938E8C, 0x00938E8B, 0x00928E8B, 0x00928E8C, 0x00928D8B, 0x00928D8A, 0x00918C8A, 0x00918C89, 0x00908B89, 0x008F8B89, 0x008F8B89, 0x008F8A88, 0x008F8988, 0x008F8987, 0x008E8987, 0x008D8987, 0x008D8886, 0x008D8886, 0x008D8885, 0x008C8785, 
        0x008C8785, 0x008C8785, 0x008B8685, 0x008B8684, 0x008A8683, 0x008A8684, 0x008A8683, 0x008A8583, 0x008A8682, 0x00898482, 0x00847F7D, 0x00B7B3B2, 0x42838181, 0xD5010101, 0xF4000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDBDADA, 0xFFDBDADA, 0xFFDBDADA, 0xFFDBDADA, 0xFFDBDADA, 0xFFDBDADA, 0xFFDBDADA, 0xFFDBDADA, 0xFFDBDADA, 0xFFDBDADA, 0xFFDBDADA, 0xFFDBDADA, 0xFFDBDADA, 0xFFDBDADA, 0xFFDBDADA, 0xFFDBDADA, 0xFFDCDBDB, 0x96F3F2F2, 0x00F0EFEF, 0x00D3D0CF, 0x00C5C3C1, 
        0x00C0BDBB, 0x00BFBCBA, 0x00BFBCBA, 0x00BFBBBA, 0x00BEBBBA, 0x00BEBBB9, 0x00BEBBB9, 0x00BDBAB9, 0x00BDBAB8, 0x00BCBAB8, 0x00BCB9B8, 0x00BBB9B7, 0x00BBB9B7, 0x00BBB8B6, 0x00BAB8B7, 0x00BBB8B6, 0x00BAB7B6, 0x00BAB7B5, 0x00B9B6B5, 0x00B9B6B4, 
        0x00B9B5B4, 0x00B7B5B3, 0x00B8B5B3, 0x00B7B4B2, 0x00B6B3B2, 0x00B6B3B2, 0x00B6B3B1, 0x00B5B3B1, 0x00B5B2B0, 0x00B4B1B0, 0x00B4B1AF, 0x00B4B1AF, 0x00B3B0AF, 0x00B3AFAE, 0x00B3AFAD, 0x00B3AFAD, 0x00B1ADAC, 0x00A8A3A2, 0x0095908E, 0x00827D7B, 
        0x00837D7B, 0x00867F7D, 0x0F6D6766, 0x29373434, 0x400B0B0A, 0x4F000000, 0x5B000000, 0x69000000, 0x7C000000, 0x91000000, 0xA6000000, 0xBA000000, 0xCB000000, 0xD9000000, 0xE3000000, 0xEC000000, 0xF2000000, 0xF6000000, 0xFA000000, 0xFC000000, 
        0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFA000000, 0xF6000000, 0xF2000000, 0xEC000000, 0xE3000000, 0xD9000000, 
        0xCB000000, 0xBA000000, 0xA8000000, 0x95000000, 0x80000000, 0x630C0B0B, 0x3B393635, 0x136F6A69, 0x00898180, 0x00837C7B, 0x007B7674, 0x0085807E, 0x00938E8B, 0x00989390, 0x00979390, 0x0096918F, 0x0096918F, 0x0095918E, 0x0095908D, 0x0095908D, 
        0x0094908D, 0x00938F8D, 0x00938E8C, 0x00938E8C, 0x00938E8B, 0x00928D8B, 0x00928D8A, 0x00928D8A, 0x00918C89, 0x00918C89, 0x00918C89, 0x00908B88, 0x00908C88, 0x008F8A88, 0x008F8A87, 0x008F8987, 0x008F8A86, 0x008F8A87, 0x008E8987, 0x008E8986, 
        0x008D8885, 0x008D8885, 0x008C8885, 0x008C8885, 0x008C8785, 0x008C8784, 0x008C8784, 0x008C8784, 0x008B8784, 0x008C8784, 0x00898482, 0x008A8582, 0x00C2BFBE, 0x68605D5D, 0xE3000000, 0xF7000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFE6E6E5, 0xFFE6E6E5, 0xFFE6E6E5, 0xFFE6E6E5, 0xFFE6E6E5, 0xFFE6E6E5, 0xFFE6E6E5, 0xFFE6E6E5, 0xFFE6E6E5, 0xFFE6E6E5, 0xFFE6E6E5, 0xFFE6E6E5, 0xFFE6E6E5, 0xFFE6E6E5, 0xFFE6E6E5, 0xFFE6E6E5, 0xD0ECEBEB, 0x0DF4F4F4, 0x00DAD8D7, 0x00C7C4C3, 0x00C1BEBD, 
        0x00C0BCBC, 0x00C0BCBB, 0x00BFBCBB, 0x00BFBCBB, 0x00BEBCBA, 0x00BEBBBA, 0x00BDBBBA, 0x00BDBBB9, 0x00BDBAB9, 0x00BDBAB9, 0x00BCB9B8, 0x00BCB9B8, 0x00BBB9B8, 0x00BBB8B7, 0x00BBB8B7, 0x00BBB8B6, 0x00BAB7B6, 0x00BAB7B5, 0x00B9B6B5, 0x00B8B5B4, 
        0x00B9B5B4, 0x00B8B5B3, 0x00B7B4B3, 0x00B7B4B3, 0x00B6B3B2, 0x00B6B3B2, 0x00B6B3B2, 0x00B5B3B1, 0x00B5B2B1, 0x00B5B1AF, 0x00B4B1AF, 0x00B3B0AE, 0x00B3B0AE, 0x00B3B0AE, 0x00B3B0AE, 0x00ACA8A7, 0x00999593, 0x00857F7E, 0x00857E7C, 0x00898180, 
        0x12676260, 0x2F2C2A29, 0x46020202, 0x54000000, 0x61000000, 0x76000000, 0x8D000000, 0xA6000000, 0xBE000000, 0xD1000000, 0xE1000000, 0xEC000000, 0xF5000000, 0xFA000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xFA000000, 
        0xF5000000, 0xEC000000, 0xE1000000, 0xD2000000, 0xBE000000, 0xA8000000, 0x92000000, 0x75020202, 0x492D2B2A, 0x1A6A6564, 0x008E8785, 0x00857E7C, 0x007B7674, 0x00888381, 0x00948F8E, 0x00979391, 0x00969290, 0x0095928F, 0x0095918E, 0x0095918E, 
        0x0094918E, 0x0095908D, 0x0094908D, 0x00948F8D, 0x00938F8D, 0x00938E8D, 0x00938D8B, 0x00928D8B, 0x00928D8B, 0x00918D8A, 0x00918C8A, 0x00918C89, 0x00908C89, 0x00908B88, 0x00908B89, 0x00908B89, 0x00908B88, 0x008F8B88, 0x008E8A88, 0x008E8A87, 
        0x008E8986, 0x008D8986, 0x008D8986, 0x008D8886, 0x008D8986, 0x008D8886, 0x008D8886, 0x008D8885, 0x008D8885, 0x008C8885, 0x008C8885, 0x0088827F, 0x0096918F, 0x07BFBBBB, 0x962F2E2D, 0xEA000000, 0xF9000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFF0F1F0, 0xFFF0F1F0, 0xFFF0F1F0, 0xFFF0F1F0, 0xFFF0F1F0, 0xFFF0F1F0, 0xFFF0F1F0, 0xFFF0F1F0, 0xFFF0F1F0, 0xFFF0F1F0, 0xFFF0F1F0, 0xFFF0F1F0, 0xFFF0F1F0, 0xFFF0F1F0, 0xFFF0F1F0, 0xF5F1F1F0, 0x37FBFBFB, 0x00E4E3E2, 0x00CAC7C6, 0x00C3C0BE, 0x00C0BDBC, 
        0x00C0BDBB, 0x00BFBDBB, 0x00BFBDBB, 0x00BFBCBA, 0x00BEBCBA, 0x00BEBBBA, 0x00BDBBB9, 0x00BEBAB9, 0x00BDBAB9, 0x00BDBBB8, 0x00BDBAB8, 0x00BCBAB7, 0x00BCB9B7, 0x00BBB8B6, 0x00BBB8B6, 0x00BAB7B5, 0x00BAB7B5, 0x00BAB6B5, 0x00BAB6B4, 0x00B8B5B3, 
        0x00B8B5B3, 0x00B8B5B3, 0x00B7B5B3, 0x00B7B4B3, 0x00B7B4B2, 0x00B6B3B2, 0x00B6B3B1, 0x00B5B2B0, 0x00B5B2B0, 0x00B4B1AF, 0x00B4B1AF, 0x00B4B1AF, 0x00B4B1AF, 0x00B0ADAC, 0x00A29E9C, 0x008A8583, 0x00857E7C, 0x008D8583, 0x116C6665, 0x302C2928, 
        0x48000000, 0x55000000, 0x65000000, 0x7E000000, 0x99000000, 0xB5000000, 0xCE000000, 0xE0000000, 0xEE000000, 0xF7000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFC000000, 0xF7000000, 0xEE000000, 0xE0000000, 0xCE000000, 0xB6000000, 0x9E000000, 0x7F000000, 0x4F2C2929, 0x18726C6A, 0x00928A89, 0x00837D7B, 0x007F7A77, 0x008E8986, 0x00969290, 0x00979390, 0x00979290, 0x0096928F, 
        0x0096918F, 0x0095918E, 0x0094908E, 0x00948F8D, 0x00948F8D, 0x00938F8C, 0x00938E8C, 0x00928E8C, 0x00928E8C, 0x00928E8B, 0x00928E8B, 0x00928D8A, 0x00918D8A, 0x00918D8A, 0x00918C8A, 0x00908C8A, 0x00908B8A, 0x008F8B89, 0x008F8B88, 0x008E8B88, 
        0x008E8A88, 0x008E8A88, 0x008F8A88, 0x008E8987, 0x008E8987, 0x008E8987, 0x008D8987, 0x008E8887, 0x008E8986, 0x008D8886, 0x008D8885, 0x008D8986, 0x0085807D, 0x00ACA8A6, 0x21A8A5A3, 0xBD0C0B0B, 0xEF000000, 0xFC000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFF4F4F4, 0xFFF4F4F4, 0xFFF4F4F4, 0xFFF4F4F4, 0xFFF4F4F4, 0xFFF4F4F4, 0xFFF4F4F4, 0xFFF4F4F4, 0xFFF4F4F4, 0xFFF4F4F4, 0xFFF4F4F4, 0xFFF4F4F4, 0xFFF4F4F4, 0xFFF4F4F4, 0xFFF3F3F3, 0x76FBFBFB, 0x00EEEDEC, 0x00CECDCB, 0x00C4C1C0, 0x00C1BEBC, 0x00C0BEBC, 
        0x00C0BDBC, 0x00C0BDBB, 0x00BFBDBB, 0x00BFBDBB, 0x00BFBCBA, 0x00BFBCBB, 0x00BFBBBA, 0x00BEBBB9, 0x00BDBBB9, 0x00BDBBB8, 0x00BDBAB8, 0x00BCBAB7, 0x00BCB9B7, 0x00BCB8B7, 0x00BBB8B6, 0x00BBB7B6, 0x00BBB7B5, 0x00BAB7B5, 0x00BAB7B4, 0x00B9B7B5, 
        0x00B9B6B4, 0x00B9B5B3, 0x00B7B5B3, 0x00B8B4B2, 0x00B7B3B2, 0x00B6B3B2, 0x00B6B3B1, 0x00B6B3B0, 0x00B5B2B0, 0x00B5B2B0, 0x00B5B2B0, 0x00B4B1AF, 0x00ACA9A7, 0x0094908E, 0x00847E7C, 0x008D8684, 0x0A7E7675, 0x2A373333, 0x46010000, 0x55000000, 
        0x66000000, 0x80000000, 0x9F000000, 0xBD000000, 0xD6000000, 0xE8000000, 0xF5000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0xF5000000, 0xE9000000, 0xD7000000, 0xBE000000, 0xA4000000, 0x81010101, 0x463A3737, 0x0E847E7D, 0x00948D8B, 0x007F7A77, 0x0085807E, 0x0095908D, 0x00989491, 0x00979390, 
        0x0097928F, 0x0096928F, 0x0095918E, 0x0095908D, 0x0095908D, 0x0095908E, 0x0094908D, 0x0094908C, 0x00948F8C, 0x00948F8C, 0x00938F8C, 0x00938E8C, 0x00928E8B, 0x00928E8B, 0x00928D8B, 0x00918D8B, 0x00918D8A, 0x00918D89, 0x00918C89, 0x00908C89, 
        0x00908B88, 0x00908C88, 0x00908B88, 0x00908B88, 0x008F8A88, 0x00908A87, 0x00908A88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00918C89, 0x00918C89, 0x008E8986, 0x0086807D, 0x00BBB7B6, 0x4B777474, 0xD5000000, 0xF4000000, 0xFE000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF3F3F3, 0xFFF2F2F2, 0xC1F8F8F8, 0x05F8F8F7, 0x00D6D5D3, 0x00C6C4C3, 0x00C1BFBD, 0x00C0BEBD, 0x00C1BEBD, 
        0x00C1BEBC, 0x00C0BEBC, 0x00C0BDBB, 0x00BFBDBB, 0x00BFBCBB, 0x00BFBCBB, 0x00BEBCBA, 0x00BEBCBA, 0x00BEBBB9, 0x00BDBAB9, 0x00BDBAB9, 0x00BDBAB8, 0x00BCB9B8, 0x00BCB9B7, 0x00BBB9B7, 0x00BBB9B6, 0x00BAB7B6, 0x00BAB7B5, 0x00B9B7B5, 0x00B9B6B5, 
        0x00B9B6B4, 0x00B8B5B3, 0x00B8B5B3, 0x00B8B5B3, 0x00B7B4B2, 0x00B7B4B2, 0x00B6B3B1, 0x00B6B3B1, 0x00B5B3B1, 0x00B5B2B1, 0x00B3AFAE, 0x00A4A09F, 0x008A8583, 0x0088817F, 0x018D8684, 0x1E524E4D, 0x400B0B0B, 0x51000000, 0x61000000, 0x7D000000, 
        0x9E000000, 0xBE000000, 0xDA000000, 0xEC000000, 0xF8000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xF8000000, 0xEC000000, 0xDB000000, 0xC0000000, 0xA4000000, 0x770D0C0C, 0x32585453, 0x00968F8E, 0x008C8584, 0x00807A78, 0x008F8B88, 0x00979390, 
        0x00979390, 0x00969390, 0x00969290, 0x00969290, 0x0096928F, 0x0095918F, 0x0095918E, 0x0095918D, 0x0094918D, 0x0094908D, 0x00948F8D, 0x00938F8D, 0x00938F8D, 0x00938E8D, 0x00928E8C, 0x00928E8C, 0x00928E8B, 0x00928E8B, 0x00928D8A, 0x00918D8A, 
        0x00918D8A, 0x00918D8A, 0x00918D8A, 0x00928D8A, 0x00928D8A, 0x00938E8B, 0x00938E8B, 0x00908C89, 0x008F8A87, 0x00898481, 0x00837D7B, 0x007C7874, 0x0077726F, 0x006D6865, 0x0077716F, 0x01C1BDBC, 0x843A3838, 0xE4000000, 0xF8000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFF0F0F0, 0xFFF0F0F0, 0xFFF0F0F0, 0xFFF0F0F0, 0xFFF0F0F0, 0xFFF0F0F0, 0xFFF0F0F0, 0xFFF0F0F0, 0xFFF0F0F0, 0xFFF0F0F0, 0xFFF0F0F0, 0xFFF0F0F0, 0xFFF0F0F0, 0xF6F2F2F2, 0x32FDFDFD, 0x00E2E1E1, 0x00C9C7C6, 0x00C3C1BF, 0x00C2BFBD, 0x00C2BFBD, 0x00C1BFBD, 
        0x00C1BEBD, 0x00C0BDBC, 0x00C0BDBC, 0x00BFBDBB, 0x00BFBCBB, 0x00BEBCBA, 0x00BEBCBA, 0x00BEBBBA, 0x00BEBBB9, 0x00BDBBB9, 0x00BDBBB8, 0x00BDBAB8, 0x00BCBAB8, 0x00BCBAB7, 0x00BCB9B7, 0x00BBB8B6, 0x00BBB7B6, 0x00BAB7B5, 0x00BAB7B5, 0x00BAB7B4, 
        0x00BAB7B4, 0x00B9B6B4, 0x00B8B5B3, 0x00B8B5B2, 0x00B7B4B2, 0x00B7B4B1, 0x00B6B3B1, 0x00B6B2B1, 0x00B7B2B0, 0x00B1ADAB, 0x009D9896, 0x00837E7C, 0x008E8785, 0x0D797372, 0x33252322, 0x4C000000, 0x5A000000, 0x75000000, 0x97000000, 0xBB000000, 
        0xD8000000, 0xED000000, 0xF9000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF9000000, 0xED000000, 0xD9000000, 0xBD000000, 0x9C000000, 0x5F282525, 0x15827C7A, 0x00999390, 0x00837E7B, 0x008A8582, 
        0x0097938F, 0x00989491, 0x00979390, 0x00979390, 0x00979290, 0x0097938F, 0x0096928F, 0x0096928F, 0x0096928F, 0x0095918E, 0x0095918E, 0x0094908D, 0x0094908D, 0x00948F8D, 0x00948F8D, 0x00948F8C, 0x00948F8C, 0x00938F8B, 0x00938F8B, 0x00948F8C, 
        0x0094908C, 0x0095918D, 0x00948F8C, 0x00928D8A, 0x008E8985, 0x0087827F, 0x007F7B77, 0x00797470, 0x00736E6A, 0x00706B67, 0x006F6965, 0x006E6864, 0x006E6965, 0x006F6A66, 0x0067625E, 0x0095908D, 0x1CA9A5A4, 0xB60B0A0A, 0xEC000000, 0xFC000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0xFFEAEAEA, 0x83FDFEFE, 0x00F2F1F1, 0x00CFCDCC, 0x00C5C2C1, 0x00C2BFBE, 0x00C1BFBD, 0x00C2BFBD, 0x00C0BEBD, 
        0x00C0BEBC, 0x00C0BEBC, 0x00C0BDBC, 0x00BFBDBC, 0x00BFBDBB, 0x00BFBDBB, 0x00BEBCBA, 0x00BEBCBA, 0x00BEBCBA, 0x00BDBBB9, 0x00BDBAB9, 0x00BDBAB8, 0x00BCBAB8, 0x00BCBAB8, 0x00BCB9B7, 0x00BBB9B7, 0x00BBB9B6, 0x00BBB8B6, 0x00BAB7B5, 0x00BAB8B5, 
        0x00BAB7B4, 0x00B9B6B3, 0x00B8B5B4, 0x00B7B5B2, 0x00B7B4B3, 0x00B7B4B2, 0x00B7B4B2, 0x00B6B4B2, 0x00AFABA9, 0x00938E8C, 0x00857F7D, 0x00938C8A, 0x195D5857, 0x410B0A0A, 0x53000000, 0x67000000, 0x89000000, 0xB0000000, 0xD2000000, 0xEA000000, 
        0xF8000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF8000000, 0xEA000000, 0xD2000000, 0xB5000000, 0x850A0A0A, 0x33605B5A, 0x00A29B99, 0x00898381, 
        0x0087817F, 0x0096928F, 0x00999591, 0x00989591, 0x00989491, 0x00989391, 0x00979390, 0x00979390, 0x00979290, 0x0096928F, 0x0096918E, 0x0096918E, 0x0095918E, 0x0095918E, 0x0095918E, 0x0095918E, 0x0096928F, 0x0097938F, 0x0096918E, 0x00948F8C, 
        0x008E8986, 0x0087817E, 0x007F7A77, 0x0078736F, 0x00746E6B, 0x00726C69, 0x00706B67, 0x00716C68, 0x00726C69, 0x00726D69, 0x00726D69, 0x00736D69, 0x00736D69, 0x00736D69, 0x00716C68, 0x006C6763, 0x00B7B3B1, 0x516D6A6A, 0xD4000000, 0xF3000000, 
        0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFF4F4F4, 0xFFF4F4F4, 0xFFF4F4F4, 0xFFF4F4F4, 0xFFF4F4F4, 0xFFF4F4F4, 0xFFF4F4F4, 0xFFF4F4F4, 0xFFF4F4F4, 0xFFF4F4F4, 0xFFF4F4F4, 0xFFF1F1F1, 0xD3F4F4F4, 0x0BFCFCFC, 0x00DAD7D7, 0x00C8C6C4, 0x00C3C0BE, 0x00C1BFBE, 0x00C1BFBE, 0x00C1BEBD, 0x00C2BEBD, 
        0x00C1BEBD, 0x00C1BEBD, 0x00C0BEBC, 0x00C0BDBB, 0x00C0BDBB, 0x00BFBDBB, 0x00BFBCBA, 0x00BEBCBA, 0x00BEBCBA, 0x00BDBBB9, 0x00BDBBB9, 0x00BDBBB8, 0x00BDBAB8, 0x00BDBAB8, 0x00BCB9B8, 0x00BBB9B8, 0x00BBB9B7, 0x00BBB8B6, 0x00B9B7B5, 0x00B9B6B5, 
        0x00B9B7B4, 0x00B9B6B4, 0x00B9B6B4, 0x00B8B6B4, 0x00B8B5B3, 0x00B8B5B3, 0x00B7B4B2, 0x00ABA8A5, 0x008E8988, 0x008C8482, 0x048C8583, 0x283E3B3A, 0x49000000, 0x59000000, 0x75000000, 0x9D000000, 0xC4000000, 0xE3000000, 0xF5000000, 0xFD000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xF5000000, 0xE3000000, 0xC7000000, 0xA3000000, 0x543C3938, 0x07999392, 
        0x0096918F, 0x0085817E, 0x0095918D, 0x009A9693, 0x00999592, 0x00989592, 0x00989491, 0x00989491, 0x00989390, 0x00979390, 0x00989390, 0x00989390, 0x00989390, 0x00999491, 0x00989491, 0x0096928F, 0x00918C88, 0x00898481, 0x00817C78, 0x007A7570, 
        0x0075706C, 0x00746E6A, 0x00736E69, 0x00746F6B, 0x00756F6B, 0x00756F6B, 0x0075706C, 0x0075706C, 0x0075706C, 0x0075706C, 0x0075706C, 0x0075706C, 0x0075706C, 0x0075706C, 0x0075706C, 0x006F6A66, 0x00807A77, 0x04BBB7B5, 0x8F292827, 0xE4000000, 
        0xF9000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDBDBDB, 0xFFDBDBDB, 0xFFDBDBDB, 0xFFDBDBDB, 0xFFDBDBDB, 0xFFDBDBDB, 0xFFDBDBDB, 0xFFDBDBDB, 0xFFDBDBDB, 0xFFDBDBDB, 0xFFD9D9D9, 0xFFE9E9E9, 0x54FFFFFF, 0x00E9E9E8, 0x00CBC9C7, 0x00C4C2C0, 0x00C3C0BE, 0x00C2C0BE, 0x00C2C0BE, 0x00C2BFBD, 0x00C2BFBD, 
        0x00C1BFBD, 0x00C1BEBD, 0x00C1BEBC, 0x00C0BDBC, 0x00C0BDBC, 0x00BFBDBB, 0x00BFBCBB, 0x00BFBCBA, 0x00BFBCBA, 0x00BEBCBA, 0x00BEBBB9, 0x00BDBBB9, 0x00BDBAB8, 0x00BDB9B8, 0x00BCB9B7, 0x00BCB9B6, 0x00BBB8B7, 0x00BBB8B6, 0x00BBB8B6, 0x00BAB7B5, 
        0x00BAB7B5, 0x00BAB7B5, 0x00B9B6B4, 0x00B9B6B4, 0x00B9B6B3, 0x00B7B4B2, 0x00A8A4A1, 0x008A8582, 0x00918988, 0x0C7E7776, 0x361F1D1E, 0x4E000000, 0x61000000, 0x83000000, 0xAE000000, 0xD5000000, 0xEE000000, 0xFB000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFB000000, 0xEF000000, 0xD6000000, 0xB6000000, 0x73201F1E, 
        0x158D8686, 0x009D9694, 0x00837E7B, 0x00938F8C, 0x009A9692, 0x009A9692, 0x009A9592, 0x009A9592, 0x009A9592, 0x009A9693, 0x009B9794, 0x00999692, 0x0095928E, 0x008E8A86, 0x0085817D, 0x007E7975, 0x0078736F, 0x0076716D, 0x0076706C, 0x0077716D, 
        0x0077726E, 0x0077726E, 0x0078726E, 0x0078726E, 0x0078726E, 0x0078726E, 0x0078726E, 0x0078726E, 0x0078726E, 0x0078726E, 0x0078726E, 0x0078726E, 0x0078726E, 0x0078726E, 0x0078726E, 0x0077726E, 0x006D6864, 0x00A6A19F, 0x2F8E8A8A, 0xC2010000, 
        0xED000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBEBEBE, 0xFFBABABA, 0xB6E0E0E0, 0x01FBFBFB, 0x00D4D2D0, 0x00C7C5C3, 0x00C3C1BF, 0x00C3C1BF, 0x00C3C0BE, 0x00C3C0BE, 0x00C2BFBE, 0x00C2BFBD, 
        0x00C2BEBD, 0x00C2BEBD, 0x00C1BEBD, 0x00C1BDBC, 0x00C0BDBC, 0x00C0BDBC, 0x00BFBDBB, 0x00BFBDBB, 0x00BFBCBA, 0x00BEBCBA, 0x00BEBBB9, 0x00BEBBB9, 0x00BDBAB8, 0x00BCB9B8, 0x00BDB9B7, 0x00BCB9B7, 0x00BBB9B7, 0x00BBB8B7, 0x00BBB8B6, 0x00BBB8B6, 
        0x00BAB7B5, 0x00BAB7B5, 0x00B9B6B4, 0x00B9B6B4, 0x00B7B5B2, 0x00A6A2A0, 0x00888280, 0x00928987, 0x10736C6B, 0x3E100F0F, 0x52000000, 0x6A000000, 0x92000000, 0xBC000000, 0xE0000000, 0xF5000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xF6000000, 0xE2000000, 0xC5000000, 
        0x8A121111, 0x1F807978, 0x009F9896, 0x0086807E, 0x00948F8C, 0x009C9795, 0x009D9895, 0x009D9895, 0x009A9694, 0x0096918E, 0x008D8885, 0x00847F7B, 0x007C7773, 0x00797470, 0x0078726F, 0x00797370, 0x007A7471, 0x007A7471, 0x007A7571, 0x007A7571, 
        0x007A7571, 0x007A7571, 0x007A7571, 0x007A7571, 0x007A7571, 0x007A7571, 0x007A7571, 0x007A7571, 0x007A7571, 0x007A7571, 0x007A7571, 0x007A7571, 0x007A7571, 0x007A7571, 0x007A7571, 0x007A7571, 0x0078726F, 0x007A7471, 0x00BDB8B7, 0x723F3E3D, 
        0xDA000000, 0xF6000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFE8E8E8, 0xFFE8E8E8, 0xFFE8E8E8, 0xFFE8E8E8, 0xFFE8E8E8, 0xFFE8E8E8, 0xFFE8E8E8, 0xFFE8E8E8, 0xFFE8E8E8, 0xFFE7E7E7, 0xF8E9E9E9, 0x33FCFCFC, 0x00E2E1E0, 0x00CAC8C7, 0x00C4C3C1, 0x00C3C1BF, 0x00C3C1BF, 0x00C3C0BF, 0x00C3C0BE, 0x00C3C0BE, 0x00C2BFBD, 
        0x00C2BFBD, 0x00C2BFBD, 0x00C1BFBD, 0x00C1BFBD, 0x00C0BEBC, 0x00C0BEBC, 0x00BFBDBB, 0x00BFBDBB, 0x00BEBCBA, 0x00BEBBBA, 0x00BEBBBA, 0x00BEBBB9, 0x00BDBAB9, 0x00BDBAB8, 0x00BCBAB8, 0x00BCBAB8, 0x00BBBAB8, 0x00BBB9B7, 0x00BBB8B7, 0x00BBB8B6, 
        0x00BAB7B5, 0x00BAB7B5, 0x00BAB7B4, 0x00B8B5B3, 0x00A6A2A0, 0x00888280, 0x00928B89, 0x14686261, 0x410A0909, 0x55000000, 0x72000000, 0x9E000000, 0xC9000000, 0xE8000000, 0xF9000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFA000000, 0xEA000000, 
        0xCF000000, 0x9A0C0B0B, 0x2A75706F, 0x00A49E9C, 0x00898481, 0x00938F8C, 0x00979390, 0x008D8985, 0x00847F7C, 0x007E7975, 0x007B7672, 0x007B7672, 0x007C7773, 0x007C7773, 0x007D7774, 0x007D7774, 0x007D7774, 0x007D7774, 0x007D7774, 0x007D7774, 
        0x007D7774, 0x007D7774, 0x007D7774, 0x007D7774, 0x007D7774, 0x007D7774, 0x007D7774, 0x007D7774, 0x007D7774, 0x007D7774, 0x007D7774, 0x007D7774, 0x007D7774, 0x007D7774, 0x007D7774, 0x007D7774, 0x007D7874, 0x00746F6B, 0x0095908D, 0x1AA09B9A, 
        0xAF080707, 0xE7000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFEEEEEE, 0xFFEEEEEE, 0xFFEEEEEE, 0xFFEEEEEE, 0xFFEEEEEE, 0xFFEEEEEE, 0xFFEEEEEE, 0xFFEEEEEE, 0xFFEEEEEE, 0xFFEDEDED, 0x9FF7F7F7, 0x00F5F4F4, 0x00D1CFCD, 0x00C7C4C3, 0x00C4C1C0, 0x00C4C1BF, 0x00C4C2BF, 0x00C4C1BF, 0x00C3C0BF, 0x00C3C0BE, 0x00C3C0BE, 
        0x00C2BFBD, 0x00C1BFBD, 0x00C1BFBD, 0x00C0BFBC, 0x00C0BEBC, 0x00C0BEBC, 0x00C0BDBC, 0x00C0BDBB, 0x00BFBDBA, 0x00BFBCBB, 0x00BEBCBA, 0x00BEBCBA, 0x00BEBBB9, 0x00BDBAB9, 0x00BCBAB9, 0x00BCBAB9, 0x00BCBAB8, 0x00BCB9B7, 0x00BBB9B7, 0x00BBB9B6, 
        0x00BBB9B5, 0x00BAB8B6, 0x00B9B6B5, 0x00A6A2A0, 0x00888380, 0x00938B89, 0x1A5E5857, 0x44050404, 0x57000000, 0x78000000, 0xA7000000, 0xD3000000, 0xEF000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 
        0xF0000000, 0xD7000000, 0xA5060505, 0x356C6766, 0x00A7A19F, 0x00797470, 0x0077736E, 0x007D7874, 0x007E7974, 0x007E7975, 0x007F7A76, 0x007F7A76, 0x007F7A76, 0x007F7A76, 0x007F7A76, 0x007F7A76, 0x007F7A76, 0x007F7A76, 0x007F7A76, 0x007F7A76, 
        0x007F7A76, 0x007F7A76, 0x007F7A76, 0x007F7A76, 0x007F7A76, 0x007F7A76, 0x007F7A76, 0x007F7A76, 0x007F7A76, 0x007F7A76, 0x007F7A76, 0x007F7A76, 0x007F7A76, 0x007F7A76, 0x007F7A76, 0x007F7A76, 0x007F7A76, 0x007D7874, 0x0077726F, 0x00B5B1AF, 
        0x5E504D4D, 0xD2000000, 0xF2000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFEFEFEF, 0xFFEFEFEF, 0xFFEFEFEF, 0xFFEFEFEF, 0xFFEFEFEF, 0xFFEFEFEF, 0xFFEFEFEF, 0xFFEFEFEF, 0xFFEFEFEF, 0xF6F0F0F0, 0x2AFCFCFC, 0x00E0DFDE, 0x00CBC9C6, 0x00C6C3C1, 0x00C5C2C0, 0x00C4C2C0, 0x00C4C2C0, 0x00C4C1BF, 0x00C3C1BF, 0x00C3C0BE, 0x00C3C0BE, 
        0x00C2C0BE, 0x00C2C0BE, 0x00C2C0BE, 0x00C2BFBD, 0x00C1BFBD, 0x00C1BEBC, 0x00C0BEBC, 0x00BFBDBC, 0x00C0BDBB, 0x00BFBCBB, 0x00BFBCBB, 0x00BFBCBA, 0x00BEBCBA, 0x00BFBBB9, 0x00BEBBB9, 0x00BDBAB9, 0x00BDBAB8, 0x00BCBAB7, 0x00BCB9B7, 0x00BCB9B7, 
        0x00BCB9B7, 0x00BAB8B5, 0x00A8A6A3, 0x008A8481, 0x00928B89, 0x1C575251, 0x47000000, 0x59000000, 0x7C000000, 0xAC000000, 0xD8000000, 0xF3000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFD000000, 0xF3000000, 0xDB000000, 0xAE010101, 0x3C666161, 0x00A29C9A, 0x0075706C, 0x007B7672, 0x00827D79, 0x00827D79, 0x00827D79, 0x00827D79, 0x00827D79, 0x00827D79, 0x00827D79, 0x00827D79, 0x00827D79, 0x00827D79, 0x00827D79, 0x00827D79, 
        0x00827D79, 0x00827D79, 0x00827D79, 0x00827D79, 0x00827D79, 0x00827D79, 0x00827D79, 0x00827D79, 0x00827D79, 0x00827D79, 0x00827D79, 0x00827D79, 0x00827D79, 0x00827D79, 0x00827D79, 0x00827D79, 0x00827D79, 0x00827D79, 0x007A7571, 0x00938D8B, 
        0x14A19C9B, 0xA40A0A09, 0xE3000000, 0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFEFEFEF, 0xFFEFEFEF, 0xFFEFEFEF, 0xFFEFEFEF, 0xFFEFEFEF, 0xFFEFEFEF, 0xFFEFEFEF, 0xFFEFEFEF, 0xFFEEEEEE, 0x98F6F6F6, 0x00F2F1F1, 0x00D1CFCD, 0x00C8C6C4, 0x00C6C3C1, 0x00C5C3C1, 0x00C5C3C1, 0x00C4C2C0, 0x00C4C2C0, 0x00C4C2C0, 0x00C4C1BF, 0x00C3C1BF, 
        0x00C3C0BF, 0x00C3C0BE, 0x00C2C0BE, 0x00C2BFBE, 0x00C1BFBE, 0x00C1BEBD, 0x00C0BFBC, 0x00C1BEBC, 0x00C1BEBB, 0x00C1BEBB, 0x00C0BDBB, 0x00BFBCBA, 0x00C0BCBB, 0x00BFBCBA, 0x00BEBCBA, 0x00BEBBB9, 0x00BEBBB9, 0x00BDBAB8, 0x00BDBAB8, 0x00BDBAB8, 
        0x00BDBAB7, 0x00ADA9A7, 0x008C8784, 0x00928987, 0x1A5A5555, 0x47010101, 0x5B000000, 0x80000000, 0xB1000000, 0xDB000000, 0xF5000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFE000000, 0xF4000000, 0xDE000000, 0xB2010101, 0x396B6666, 0x00A19B99, 0x0077716E, 0x00807B77, 0x0085807C, 0x0085807C, 0x0085807C, 0x0085807C, 0x0085807C, 0x0085807C, 0x0085807C, 0x0085807C, 0x0085807C, 0x0085807C, 0x0085807C, 
        0x0085807C, 0x0085807C, 0x0085807C, 0x0085807C, 0x0085807C, 0x0085807C, 0x0085807C, 0x0085807C, 0x0085807C, 0x0085807C, 0x0085807C, 0x0085807C, 0x0085807C, 0x0085807C, 0x0085807C, 0x0085807C, 0x0085807C, 0x0085807C, 0x00847F7B, 0x007C7773, 
        0x00B2ADAB, 0x57524F4F, 0xCD000000, 0xF1000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xFFEBEBEB, 0xF4ECECEC, 0x26F8F8F8, 0x00DFDDDC, 0x00CBCAC8, 0x00C7C5C3, 0x00C6C4C2, 0x00C6C4C2, 0x00C6C4C2, 0x00C5C3C2, 0x00C6C3C1, 0x00C5C3C1, 0x00C5C2C1, 0x00C5C2C0, 
        0x00C5C1BF, 0x00C4C1BF, 0x00C3C0BF, 0x00C3C1BF, 0x00C3C1BE, 0x00C3C0BE, 0x00C3C0BD, 0x00C2BFBD, 0x00C2BFBD, 0x00C2BFBC, 0x00C1BEBC, 0x00C1BEBC, 0x00C0BDBB, 0x00C0BDBB, 0x00C0BDBB, 0x00BFBDBA, 0x00BFBDBA, 0x00BFBCBA, 0x00BFBCBA, 0x00BEBCB9, 
        0x00B3B0AD, 0x00918B89, 0x008F8886, 0x15625D5C, 0x46030202, 0x5A000000, 0x80000000, 0xB4000000, 0xDE000000, 0xF6000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xF6000000, 0xE1000000, 0xB3040403, 0x30746F6E, 0x009C9694, 0x007A7571, 0x0086817D, 0x00898480, 0x00898480, 0x00898480, 0x00898480, 0x00898480, 0x00898480, 0x00898480, 0x00898480, 0x00898480, 0x00898480, 
        0x00898480, 0x00898480, 0x00898480, 0x00898480, 0x00898480, 0x00898480, 0x00898480, 0x00898480, 0x00898480, 0x00898480, 0x00898480, 0x00898480, 0x00898480, 0x00898480, 0x00898480, 0x00898480, 0x00898480, 0x00898480, 0x00898480, 0x00827D78, 
        0x00938D8B, 0x119D9998, 0xA00B0A0A, 0xE1000000, 0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDFDEDE, 0xFFDFDEDE, 0xFFDFDEDE, 0xFFDFDEDE, 0xFFDFDEDE, 0xFFDFDEDE, 0xFFDEDEDE, 0xFFDBDADA, 0xA1EBEAEA, 0x00F0EFEE, 0x00D3D1CF, 0x00CBC8C6, 0x00C7C5C4, 0x00C7C6C3, 0x00C8C5C3, 0x00C7C5C3, 0x00C7C5C2, 0x00C6C4C2, 0x00C6C4C2, 0x00C6C4C1, 0x00C6C3C1, 
        0x00C5C3C1, 0x00C5C2C1, 0x00C5C2C1, 0x00C4C2C0, 0x00C5C2BF, 0x00C4C2BF, 0x00C4C1BF, 0x00C3C0BE, 0x00C3C0BE, 0x00C2C0BE, 0x00C2C0BD, 0x00C2C0BD, 0x00C2BFBC, 0x00C2BFBD, 0x00C2BEBC, 0x00C1BEBC, 0x00C0BEBB, 0x00C0BDBC, 0x00C0BEBB, 0x00B8B5B3, 
        0x00989391, 0x008D8684, 0x0F6E6867, 0x42080807, 0x59000000, 0x7F000000, 0xB3000000, 0xDF000000, 0xF7000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF7000000, 0xE3000000, 0xAD0C0B0B, 0x23837D7C, 0x009B9593, 0x00807B77, 0x008B8682, 0x008D8884, 0x008D8884, 0x008D8884, 0x008D8884, 0x008D8884, 0x008D8884, 0x008D8884, 0x008D8884, 0x008D8884, 
        0x008D8884, 0x008D8884, 0x008D8884, 0x008D8884, 0x008D8884, 0x008D8884, 0x008D8884, 0x008D8884, 0x008D8884, 0x008D8884, 0x008D8884, 0x008D8884, 0x008D8884, 0x008D8884, 0x008D8884, 0x008D8884, 0x008D8884, 0x008D8884, 0x008D8884, 0x008C8783, 
        0x00837E7A, 0x00ADA7A6, 0x5A484545, 0xCB000000, 0xF0000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFA8A8A8, 0xFFA8A8A8, 0xFFA8A8A8, 0xFFA8A8A8, 0xFFA8A8A8, 0xFFA8A8A8, 0xFFA7A7A7, 0xFBB5B5B5, 0x37F0F0F0, 0x00E0DFDE, 0x00CFCCCB, 0x00CBC7C6, 0x00C9C7C5, 0x00C9C7C5, 0x00C9C6C5, 0x00C9C6C4, 0x00C8C6C4, 0x00C8C5C3, 0x00C8C5C3, 0x00C7C5C3, 0x00C8C5C3, 
        0x00C7C5C3, 0x00C7C4C2, 0x00C7C4C2, 0x00C6C3C2, 0x00C6C3C1, 0x00C5C2C0, 0x00C6C3C1, 0x00C5C2C0, 0x00C5C2C0, 0x00C5C2C0, 0x00C4C1BF, 0x00C4C1BF, 0x00C3C0BF, 0x00C3C0BE, 0x00C3C0BE, 0x00C3BFBD, 0x00C2BFBD, 0x00C2BFBE, 0x00BFBBBA, 0x00A29D9B, 
        0x008A8382, 0x087B7473, 0x3C121111, 0x56000000, 0x7A000000, 0xAF000000, 0xDE000000, 0xF7000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF6000000, 0xE3000000, 0x9E181616, 0x11958F8F, 0x00928C8A, 0x0087817D, 0x00918C88, 0x00928C89, 0x00928C89, 0x00928C89, 0x00928C89, 0x00928C89, 0x00928C89, 0x00928C89, 0x00928C89, 
        0x00928C89, 0x00928C89, 0x00928C89, 0x00928C89, 0x00928C89, 0x00928C89, 0x00928C89, 0x00928C89, 0x00928C89, 0x00928C89, 0x00928C89, 0x00928C89, 0x00928C89, 0x00928C89, 0x00928C89, 0x00928C89, 0x00928C89, 0x00928C89, 0x00928C89, 0x00928C89, 
        0x008A8480, 0x00989391, 0x198C8786, 0xA5040303, 0xE1000000, 0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF19191A, 0xFF19191A, 0xFF19191A, 0xFF19191A, 0xFF19191A, 0xFF19191A, 0xFF191919, 0xB6828282, 0x00F9F8F8, 0x00D6D4D3, 0x00CDCBC9, 0x00CBC8C6, 0x00CBC9C6, 0x00CBC8C6, 0x00CBC8C6, 0x00CBC8C6, 0x00CAC7C6, 0x00CAC7C5, 0x00CAC7C5, 0x00C9C7C5, 0x00C9C7C4, 
        0x00C8C6C4, 0x00C8C6C3, 0x00C8C6C3, 0x00C8C5C3, 0x00C8C5C3, 0x00C7C5C2, 0x00C7C4C2, 0x00C6C4C2, 0x00C6C4C1, 0x00C6C3C1, 0x00C6C2C1, 0x00C5C2C1, 0x00C5C2C0, 0x00C4C2BF, 0x00C4C2BF, 0x00C4C1BF, 0x00C5C2BF, 0x00C4C1BE, 0x00AEAAA7, 0x008D8684, 
        0x02857D7C, 0x32232121, 0x53000000, 0x73000000, 0xA9000000, 0xDA000000, 0xF6000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF6000000, 0xE2000000, 0x852C2A2A, 0x049F9998, 0x00908A87, 0x008F8A86, 0x0096918D, 0x0096918D, 0x0096918D, 0x0096918D, 0x0096918D, 0x0096918D, 0x0096918D, 0x0096918D, 
        0x0096918D, 0x0096918D, 0x0096918D, 0x0096918D, 0x0096918D, 0x0096918D, 0x0096918D, 0x0096918D, 0x0096918D, 0x0096918D, 0x0096918D, 0x0096918D, 0x0096918D, 0x0096918D, 0x0096918D, 0x0096918D, 0x0096918D, 0x0096918D, 0x0096918D, 0x0096918D, 
        0x00958F8C, 0x008A8682, 0x00A6A1A0, 0x66363333, 0xCD000000, 0xF2000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFDCDCDC, 0xFFDCDCDC, 0xFFDCDCDC, 0xFFDCDCDC, 0xFFDCDCDC, 0xFFDCDCDC, 0xFFD5D5D4, 0x50E1E1E1, 0x00E3E1E1, 0x00D2D0CE, 0x00CDCBC9, 0x00CCCAC8, 0x00CDCAC7, 0x00CDCAC7, 0x00CCC9C7, 0x00CCC9C7, 0x00CCC9C7, 0x00CBC8C7, 0x00CBC8C6, 0x00CBC8C6, 0x00CAC8C6, 
        0x00CAC8C6, 0x00C9C7C6, 0x00C9C7C5, 0x00C8C6C4, 0x00C8C6C4, 0x00C9C6C4, 0x00C8C5C3, 0x00C7C5C2, 0x00C8C4C2, 0x00C7C4C2, 0x00C7C4C2, 0x00C8C4C2, 0x00C7C3C2, 0x00C7C4C1, 0x00C7C4C1, 0x00C6C4C1, 0x00C7C4C2, 0x00B9B6B3, 0x00938D8B, 0x00898280, 
        0x253C3938, 0x4F000000, 0x6C000000, 0xA0000000, 0xD4000000, 0xF3000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF4000000, 0xDC000000, 0x614E4B4A, 0x00A39E9D, 0x008D8884, 0x0097928E, 0x009A9591, 0x009A9591, 0x009A9591, 0x009A9591, 0x009A9591, 0x009A9591, 0x009A9591, 
        0x009A9591, 0x009A9591, 0x009A9591, 0x009A9591, 0x009A9591, 0x009A9591, 0x009A9591, 0x009A9591, 0x009A9591, 0x009A9591, 0x009A9591, 0x009A9591, 0x009A9591, 0x009A9591, 0x009A9591, 0x009A9591, 0x009A9591, 0x009A9591, 0x009A9591, 0x009A9591, 
        0x009A9591, 0x00918B87, 0x009C9794, 0x25767272, 0xAD000000, 0xE3000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF5F5F5E, 0xFF5F5F5E, 0xFF5F5F5E, 0xFF5F5F5E, 0xFF5F5F5E, 0xFF5F5F5E, 0xD9A0A09F, 0x09F2F2F1, 0x00DAD8D7, 0x00D1CFCD, 0x00CECCCA, 0x00CECBCA, 0x00CECBC9, 0x00CECBC9, 0x00CECBC9, 0x00CDCAC8, 0x00CDCAC8, 0x00CCCAC8, 0x00CCC9C8, 0x00CCC9C8, 0x00CCC9C7, 
        0x00CBC9C7, 0x00CCC8C7, 0x00CCC8C6, 0x00CBC8C6, 0x00CBC7C6, 0x00CBC7C5, 0x00CBC8C6, 0x00CAC7C5, 0x00CAC7C5, 0x00CAC6C5, 0x00CAC6C5, 0x00C9C6C4, 0x00C9C6C4, 0x00C9C5C4, 0x00C9C5C3, 0x00C9C6C4, 0x00C2BFBD, 0x00A19C9A, 0x008A8381, 0x145A5654, 
        0x48010101, 0x63000000, 0x94000000, 0xCB000000, 0xF0000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xF2000000, 0xCD020202, 0x34726D6C, 0x009F9998, 0x00958E8C, 0x009E9895, 0x009F9996, 0x009F9996, 0x009F9996, 0x009F9996, 0x009F9996, 0x009F9996, 
        0x009F9996, 0x009F9996, 0x009F9996, 0x009F9996, 0x009F9996, 0x009F9996, 0x009F9996, 0x009F9996, 0x009F9996, 0x009F9996, 0x009F9996, 0x009F9996, 0x009F9996, 0x009F9996, 0x009F9996, 0x009F9996, 0x009F9996, 0x009F9996, 0x009F9996, 0x009F9996, 
        0x009F9996, 0x009C9693, 0x00948D8B, 0x029A9594, 0x7C1A1A19, 0xD1000000, 0xF4000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF626161, 0xFF626161, 0xFF626161, 0xFF626161, 0xFF626161, 0xFF605F5F, 0x81A3A2A2, 0x00EAE9E8, 0x00D7D5D3, 0x00D2CFCD, 0x00D0CECB, 0x00D0CDCB, 0x00D0CDCB, 0x00CFCCCB, 0x00CFCCCB, 0x00CFCCCA, 0x00CFCCCA, 0x00CFCBC9, 0x00CFCBC9, 0x00CECBC9, 0x00CECBC8, 
        0x00CECAC8, 0x00CECAC8, 0x00CECAC8, 0x00CDCAC8, 0x00CDCAC8, 0x00CDC9C8, 0x00CDC9C7, 0x00CCC9C7, 0x00CCC9C7, 0x00CCC9C6, 0x00CCC8C6, 0x00CBC7C5, 0x00CBC8C5, 0x00CBC7C5, 0x00CAC8C5, 0x00C9C6C4, 0x00B2ADAB, 0x008D8684, 0x06736D6C, 0x3D0F0F0F, 
        0x5A000000, 0x86000000, 0xBF000000, 0xEA000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0xEF000000, 0xAC161515, 0x0F8F8A89, 0x009A9592, 0x009D9894, 0x00A39E9A, 0x00A39E9A, 0x00A39E9A, 0x00A39E9A, 0x00A39E9A, 0x00A39E9A, 
        0x00A39E9A, 0x00A39E9A, 0x00A39E9A, 0x00A39E9A, 0x00A39E9A, 0x00A39E9A, 0x00A39E9A, 0x00A39E9A, 0x00A39E9A, 0x00A39E9A, 0x00A39E9A, 0x00A39E9A, 0x00A39E9A, 0x00A39E9A, 0x00A39E9A, 0x00A39E9A, 0x00A39E9A, 0x00A39E9A, 0x00A39E9A, 0x00A39E9A, 
        0x00A39E9A, 0x00A39E9A, 0x0098928E, 0x009F9A98, 0x40514D4D, 0xB9000000, 0xE8000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xFFC7C7C7, 0xF6D1D0D0, 0x27E8E7E7, 0x00DDDBDA, 0x00D6D3D1, 0x00D2CFCD, 0x00D2CECC, 0x00D1CFCC, 0x00D1CECD, 0x00D2CECD, 0x00D1CECD, 0x00D1CECC, 0x00D1CECC, 0x00D1CECB, 0x00D1CDCB, 0x00D0CDCB, 0x00D0CDCB, 
        0x00D0CCCB, 0x00D0CDCA, 0x00D0CDCA, 0x00D0CCCA, 0x00CFCCC9, 0x00CFCBC9, 0x00CECBC9, 0x00CECAC8, 0x00CECAC8, 0x00CDCAC8, 0x00CDCAC8, 0x00CDC9C7, 0x00CDCAC7, 0x00CCCAC7, 0x00CDCAC8, 0x00C1BDBB, 0x00999390, 0x00817A79, 0x292F2D2D, 0x54000000, 
        0x77000000, 0xB1000000, 0xE2000000, 0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFA000000, 0xEA000000, 0x743F3C3C, 0x009E9997, 0x009C9693, 0x00A6A09D, 0x00A8A29F, 0x00A8A29F, 0x00A8A29F, 0x00A8A29F, 0x00A8A29F, 
        0x00A8A29F, 0x00A8A29F, 0x00A8A29F, 0x00A8A29F, 0x00A8A29F, 0x00A8A29F, 0x00A8A29F, 0x00A8A29F, 0x00A8A29F, 0x00A8A29F, 0x00A8A29F, 0x00A8A29F, 0x00A8A29F, 0x00A8A29F, 0x00A8A29F, 0x00A8A29F, 0x00A8A29F, 0x00A8A29F, 0x00A8A29F, 0x00A8A29F, 
        0x00A8A29F, 0x00A8A39F, 0x00A29C98, 0x009A9592, 0x0F817C7C, 0x94060606, 0xD8000000, 0xF8000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF262626, 0xFF262626, 0xFF262626, 0xFF262626, 0xFF252525, 0xB6787878, 0x00EAE9E8, 0x00DCDAD8, 0x00D5D4D1, 0x00D4D2CF, 0x00D4D1CE, 0x00D4D1CF, 0x00D4D1CE, 0x00D4D1CE, 0x00D3D0CE, 0x00D3D0CE, 0x00D3D0CD, 0x00D3D0CE, 0x00D2D0CD, 0x00D2CFCD, 0x00D2CFCD, 
        0x00D1CFCD, 0x00D1CFCC, 0x00D1CECC, 0x00D1CDCB, 0x00D1CECB, 0x00D1CECA, 0x00D0CECB, 0x00D0CDCB, 0x00D0CDCA, 0x00D0CDCA, 0x00CFCCCA, 0x00CFCCC9, 0x00CFCBCA, 0x00D0CDCA, 0x00CCC8C6, 0x00ACA7A5, 0x0088817F, 0x1355504F, 0x4A010101, 0x68000000, 
        0x9E000000, 0xD6000000, 0xF6000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF8000000, 0xD7010101, 0x346E6A69, 0x00A29D9B, 0x00A59F9C, 0x00ACA7A3, 0x00ADA7A3, 0x00ADA7A3, 0x00ADA7A3, 0x00ADA7A3, 
        0x00ADA7A3, 0x00ADA7A3, 0x00ADA7A3, 0x00ADA7A3, 0x00ADA7A3, 0x00ADA7A3, 0x00ADA7A3, 0x00ADA7A3, 0x00ADA7A3, 0x00ADA7A3, 0x00ADA7A3, 0x00ADA7A3, 0x00ADA7A3, 0x00ADA7A3, 0x00ADA7A3, 0x00ADA7A3, 0x00ADA7A3, 0x00ADA7A3, 0x00ADA7A3, 0x00ADA7A3, 
        0x00ADA7A3, 0x00ADA7A3, 0x00ABA6A2, 0x009E9793, 0x0096918F, 0x5F2C2B2A, 0xC6000000, 0xEF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF4B4B4B, 0xFF504F4F, 0x63C3C3C2, 0x00E0DFDD, 0x00DCD8D7, 0x00D7D4D2, 0x00D6D3D1, 0x00D6D3D1, 0x00D6D3D1, 0x00D6D3D0, 0x00D5D2D0, 0x00D5D2D0, 0x00D5D1CF, 0x00D5D1D0, 0x00D4D1CF, 0x00D4D1CF, 0x00D4D1CE, 0x00D3D1CE, 
        0x00D3D1CE, 0x00D3D0CE, 0x00D3CFCE, 0x00D2CFCE, 0x00D2CFCE, 0x00D2CFCD, 0x00D3CFCD, 0x00D3CECD, 0x00D2CECC, 0x00D2CECC, 0x00D2CECC, 0x00D2CECC, 0x00D1CECC, 0x00D1CECC, 0x00C0BCBA, 0x00958E8C, 0x02726B6A, 0x38141313, 0x5B000000, 0x89000000, 
        0xC5000000, 0xEE000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF5000000, 0xA5201E1E, 0x06918D8C, 0x00A59E9C, 0x00AFA9A5, 0x00B1ABA8, 0x00B1ABA8, 0x00B1ABA8, 0x00B1ABA8, 
        0x00B1ABA8, 0x00B1ABA8, 0x00B1ABA8, 0x00B1ABA8, 0x00B1ABA8, 0x00B1ABA8, 0x00B1ABA8, 0x00B1ABA8, 0x00B1ABA8, 0x00B1ABA8, 0x00B1ABA8, 0x00B1ABA8, 0x00B1ABA8, 0x00B1ABA8, 0x00B1ABA8, 0x00B1ABA8, 0x00B1ABA8, 0x00B1ABA8, 0x00B1ABA8, 0x00B1ABA8, 
        0x00B1ABA8, 0x00B1ABA8, 0x00B2ACA8, 0x00A7A09D, 0x009B9593, 0x2D575353, 0xAB000000, 0xE1000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF484848, 0xFF484848, 0xFF484848, 0xFF484848, 0xF0575757, 0x19CECECD, 0x00E0DEDC, 0x00DCD8D7, 0x00D8D4D3, 0x00D8D4D3, 0x00D8D5D3, 0x00D8D5D2, 0x00D7D5D2, 0x00D7D4D2, 0x00D7D3D1, 0x00D6D3D2, 0x00D7D3D1, 0x00D6D3D1, 0x00D6D2D1, 0x00D6D2D0, 0x00D6D2D1, 
        0x00D5D2D0, 0x00D5D2D0, 0x00D5D2D0, 0x00D4D2D0, 0x00D4D2CF, 0x00D4D1CF, 0x00D4D1CF, 0x00D4D1CE, 0x00D4D1CF, 0x00D4D0CF, 0x00D4D0CE, 0x00D3D0CE, 0x00D4D1CE, 0x00CECBC8, 0x00ACA6A4, 0x00817B79, 0x1D3E3B3A, 0x51000000, 0x75000000, 0xB0000000, 
        0xE3000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFB000000, 0xEB000000, 0x55545151, 0x00A09B99, 0x00AFA8A5, 0x00B5AFAC, 0x00B5B0AC, 0x00B5B0AC, 0x00B5B0AC, 
        0x00B5B0AC, 0x00B5B0AC, 0x00B5B0AC, 0x00B5B0AC, 0x00B5B0AC, 0x00B5B0AC, 0x00B5B0AC, 0x00B5B0AC, 0x00B5B0AC, 0x00B5B0AC, 0x00B5B0AC, 0x00B5B0AC, 0x00B5B0AC, 0x00B5B0AC, 0x00B5B0AC, 0x00B5B0AC, 0x00B5B0AC, 0x00B5B0AC, 0x00B5B0AC, 0x00B5B0AC, 
        0x00B5B0AC, 0x00B5B0AC, 0x00B6B1AD, 0x00B1ABA8, 0x009E9895, 0x087A7574, 0x850A0909, 0xD0000000, 0xF5000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF323232, 0xFF323232, 0xFF323232, 0xFF313131, 0xB07C7C7C, 0x00E0DFDE, 0x00E1DEDC, 0x00DCD8D7, 0x00DAD7D5, 0x00DAD6D4, 0x00DAD6D4, 0x00DAD6D4, 0x00DAD6D4, 0x00DAD6D4, 0x00DAD6D3, 0x00DAD5D3, 0x00D9D6D3, 0x00D9D5D3, 0x00D9D5D3, 0x00D9D5D3, 0x00D8D4D2, 
        0x00D9D4D2, 0x00D8D5D2, 0x00D8D4D2, 0x00D8D4D2, 0x00D8D4D1, 0x00D8D4D2, 0x00D7D3D1, 0x00D7D3D1, 0x00D7D3D0, 0x00D6D3D0, 0x00D6D3D0, 0x00D6D2D0, 0x00D6D2CF, 0x00C4BEBC, 0x00948D8B, 0x05635D5C, 0x3F0A0A0A, 0x62000000, 0x97000000, 0xD2000000, 
        0xF5000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFA000000, 0xBE121111, 0x0F84807E, 0x00ABA5A2, 0x00B9B2AF, 0x00BAB4B1, 0x00BAB4B1, 0x00BAB4B1, 
        0x00BAB4B1, 0x00BAB4B1, 0x00BAB4B1, 0x00BAB4B1, 0x00BAB4B1, 0x00BAB4B1, 0x00BAB4B1, 0x00BAB4B1, 0x00BAB4B1, 0x00BAB4B1, 0x00BAB4B1, 0x00BAB4B1, 0x00BAB4B1, 0x00BAB4B1, 0x00BAB4B1, 0x00BAB4B1, 0x00BAB4B1, 0x00BAB4B1, 0x00BAB4B1, 0x00BAB4B1, 
        0x00BAB4B1, 0x00BAB4B1, 0x00BAB5B1, 0x00B9B3AF, 0x00A8A19E, 0x008C8785, 0x57292727, 0xBE000000, 0xEC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF4B4B4A, 0xFF4B4B4A, 0xFF4B4B4A, 0xFF505050, 0x67B2B2B2, 0x00DBDAD9, 0x00E3E0DD, 0x00DDD9D7, 0x00DCD9D7, 0x00DCD9D7, 0x00DCD8D7, 0x00DCD8D6, 0x00DCD8D6, 0x00DCD8D6, 0x00DCD8D6, 0x00DBD8D6, 0x00DBD8D5, 0x00DBD8D5, 0x00DBD7D5, 0x00DAD7D5, 0x00DBD7D5, 
        0x00DAD7D5, 0x00DBD7D5, 0x00DBD6D5, 0x00DAD6D5, 0x00DAD6D4, 0x00DAD6D4, 0x00D9D5D3, 0x00D9D5D3, 0x00D9D5D3, 0x00D8D4D2, 0x00D9D4D2, 0x00DAD5D3, 0x00D4CFCD, 0x00B0AAA7, 0x007C7674, 0x2132302F, 0x55000000, 0x7D000000, 0xBB000000, 0xEA000000, 
        0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xF3000000, 0x66484646, 0x009E9998, 0x00B9B2AF, 0x00BEB8B5, 0x00BEB8B5, 0x00BEB8B5, 
        0x00BEB8B5, 0x00BEB8B5, 0x00BEB8B5, 0x00BEB8B5, 0x00BEB8B5, 0x00BEB8B5, 0x00BEB8B5, 0x00BEB8B5, 0x00BEB8B5, 0x00BEB8B5, 0x00BEB8B5, 0x00BEB8B5, 0x00BEB8B5, 0x00BEB8B5, 0x00BEB8B5, 0x00BEB8B5, 0x00BEB8B5, 0x00BEB8B5, 0x00BEB8B5, 0x00BEB8B5, 
        0x00BEB8B5, 0x00BEB8B5, 0x00BEB8B5, 0x00BFB9B6, 0x00B4ADAA, 0x0097918F, 0x2D494646, 0xA6000000, 0xDE000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF0D0D0D, 0xFF0D0D0D, 0xFF0D0D0D, 0xF9121212, 0x29B6B5B4, 0x00E2E0DE, 0x00E1DFDE, 0x00DEDCD9, 0x00DEDBD9, 0x00DEDCD9, 0x00DEDBD9, 0x00DEDBD9, 0x00DDDBD9, 0x00DDDAD9, 0x00DDDAD8, 0x00DDDAD8, 0x00DDDAD9, 0x00DDDAD8, 0x00DDDAD8, 0x00DCD9D8, 0x00DCD9D8, 
        0x00DCD9D7, 0x00DCD9D7, 0x00DCD8D7, 0x00DBD8D6, 0x00DBD8D6, 0x00DBD8D5, 0x00DBD7D5, 0x00DBD7D5, 0x00DBD7D5, 0x00DBD7D5, 0x00DBD7D5, 0x00DBD7D5, 0x00C9C5C3, 0x0097908E, 0x065B5655, 0x41080808, 0x66000000, 0x9E000000, 0xD9000000, 0xF8000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xC610100F, 0x107D7A79, 0x00B2ACAA, 0x00C2BBB8, 0x00C2BCB9, 0x00C2BCB9, 
        0x00C2BCB9, 0x00C2BCB9, 0x00C2BCB9, 0x00C2BCB9, 0x00C2BCB9, 0x00C2BCB9, 0x00C2BCB9, 0x00C2BCB9, 0x00C2BCB9, 0x00C2BCB9, 0x00C2BCB9, 0x00C2BCB9, 0x00C2BCB9, 0x00C2BCB9, 0x00C2BCB9, 0x00C2BCB9, 0x00C2BCB9, 0x00C2BCB9, 0x00C2BCB9, 0x00C2BCB9, 
        0x00C2BCB9, 0x00C2BCB9, 0x00C2BCB9, 0x00C3BDBA, 0x00BDB6B4, 0x00A19B98, 0x0E656160, 0x88030303, 0xCE000000, 0xF5000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF444444, 0xFF444444, 0xFF444443, 0xCC747373, 0x03C9C8C7, 0x00E5E3E1, 0x00E2DFDD, 0x00E0DDDC, 0x00E0DDDC, 0x00E0DDDC, 0x00E0DDDB, 0x00E0DDDB, 0x00E0DDDB, 0x00DFDCDB, 0x00DFDCDA, 0x00DFDCDA, 0x00DFDCDA, 0x00DEDBDA, 0x00DFDBD9, 0x00DEDBD9, 0x00DEDAD9, 
        0x00DEDAD8, 0x00DEDAD9, 0x00DDDAD9, 0x00DEDAD8, 0x00DDD9D8, 0x00DDDAD8, 0x00DDDAD8, 0x00DDDAD7, 0x00DDDAD7, 0x00DDD9D7, 0x00DDDAD8, 0x00D9D6D4, 0x00B7B1B0, 0x007C7573, 0x1F302E2D, 0x56000000, 0x80000000, 0xBF000000, 0xEC000000, 0xFE000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF6000000, 0x60494746, 0x00A19C9B, 0x00C4BEBB, 0x00C6C0BD, 0x00C6C0BD, 
        0x00C6C0BD, 0x00C6C0BD, 0x00C6C0BD, 0x00C6C0BD, 0x00C6C0BD, 0x00C6C0BD, 0x00C6C0BD, 0x00C6C0BD, 0x00C6C0BD, 0x00C6C0BD, 0x00C6C0BD, 0x00C6C0BD, 0x00C6C0BD, 0x00C6C0BD, 0x00C6C0BD, 0x00C6C0BD, 0x00C6C0BD, 0x00C6C0BD, 0x00C6C0BD, 0x00C6C0BD, 
        0x00C6C0BD, 0x00C6C0BD, 0x00C6C0BD, 0x00C7C1BE, 0x00C4BEBB, 0x00AFA8A5, 0x00777371, 0x64171616, 0xBE000000, 0xED000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF3E3E3E, 0xFF3E3E3E, 0xFF3F3F3E, 0x887B7B7A, 0x00D4D2D1, 0x00E8E5E4, 0x00E3DFDE, 0x00E2DFDD, 0x00E2DFDD, 0x00E2DFDD, 0x00E2DEDD, 0x00E2DEDC, 0x00E2DEDC, 0x00E1DEDC, 0x00E1DDDC, 0x00E1DDDC, 0x00E1DDDC, 0x00E0DCDB, 0x00E0DCDB, 0x00E0DCDB, 0x00E0DDDB, 
        0x00E0DDDB, 0x00E0DCDB, 0x00DFDCDB, 0x00E0DCDB, 0x00DFDCDA, 0x00DFDBDA, 0x00DFDBDA, 0x00DFDCDA, 0x00DFDCDA, 0x00DFDBD9, 0x00E0DCDA, 0x00D2CDCB, 0x009F9896, 0x025B5554, 0x3D0C0B0B, 0x67000000, 0x9F000000, 0xDA000000, 0xF9000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xBD171615, 0x08807D7C, 0x00BEB8B5, 0x00CBC5C2, 0x00CAC4C1, 
        0x00CAC4C1, 0x00CAC4C1, 0x00CAC4C1, 0x00CAC4C1, 0x00CAC4C1, 0x00CAC4C1, 0x00CAC4C1, 0x00CAC4C1, 0x00CAC4C1, 0x00CAC4C1, 0x00CAC4C1, 0x00CAC4C1, 0x00CAC4C1, 0x00CAC4C1, 0x00CAC4C1, 0x00CAC4C1, 0x00CAC4C1, 0x00CAC4C1, 0x00CAC4C1, 0x00CAC4C1, 
        0x00CAC4C1, 0x00CAC4C1, 0x00CAC4C1, 0x00CAC4C1, 0x00CAC4C1, 0x00BCB5B2, 0x008A8482, 0x3D2E2C2C, 0xAD000000, 0xE2000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF0B0B0B, 0xFF0B0B0B, 0xFF141414, 0x4DA5A5A3, 0x00DAD8D7, 0x00E9E6E4, 0x00E5E1DF, 0x00E4E1DF, 0x00E4E1DF, 0x00E3E0DF, 0x00E3E0DF, 0x00E3E0DE, 0x00E3E0DE, 0x00E3DFDE, 0x00E2E0DD, 0x00E3E0DD, 0x00E3DFDD, 0x00E2DFDD, 0x00E2DFDD, 0x00E2DFDD, 0x00E2DFDD, 
        0x00E2DFDD, 0x00E2DEDD, 0x00E2DEDD, 0x00E2DEDC, 0x00E2DEDC, 0x00E2DEDC, 0x00E2DEDC, 0x00E2DEDC, 0x00E2DEDC, 0x00E2DEDC, 0x00E0DCDA, 0x00C5C0BD, 0x00827C79, 0x17353231, 0x53000000, 0x7E000000, 0xBD000000, 0xEC000000, 0xFE000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF3000000, 0x48535150, 0x00A9A4A2, 0x00CFC9C6, 0x00CEC8C5, 
        0x00CEC8C5, 0x00CEC8C5, 0x00CEC8C5, 0x00CEC8C5, 0x00CEC8C5, 0x00CEC8C5, 0x00CEC8C5, 0x00CEC8C5, 0x00CEC8C5, 0x00CEC8C5, 0x00CEC8C5, 0x00CEC8C5, 0x00CEC8C5, 0x00CEC8C5, 0x00CEC8C5, 0x00CEC8C5, 0x00CEC8C5, 0x00CEC8C5, 0x00CEC8C5, 0x00CEC8C5, 
        0x00CEC8C5, 0x00CEC8C5, 0x00CEC8C5, 0x00CEC8C5, 0x00CFC9C6, 0x00C6C0BD, 0x00999391, 0x1E464342, 0x95000000, 0xD5000000, 0xF8000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF504F4F, 0xFF504F4F, 0xF24F4F4E, 0x1BA4A4A2, 0x00E4E3E2, 0x00E8E6E4, 0x00E6E3E1, 0x00E5E2E0, 0x00E5E2E1, 0x00E5E1E1, 0x00E5E1E1, 0x00E5E1E0, 0x00E4E1E0, 0x00E4E1E0, 0x00E5E1E0, 0x00E4E1E0, 0x00E4E1E0, 0x00E4E1E0, 0x00E4E1DF, 0x00E4E1DF, 0x00E4E1DF, 
        0x00E4E1DF, 0x00E4E1DF, 0x00E4E0DF, 0x00E4E0DE, 0x00E4E0DE, 0x00E4E0DE, 0x00E3E0DE, 0x00E3E0DD, 0x00E3E0DD, 0x00E4E1DF, 0x00DBD8D6, 0x00B0AAA8, 0x00635D5B, 0x31161514, 0x63000000, 0x9A000000, 0xD6000000, 0xF8000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x9D272726, 0x008A8786, 0x00CDC8C5, 0x00D3CDCA, 
        0x00D2CCC9, 0x00D2CCC9, 0x00D2CCC9, 0x00D2CCC9, 0x00D2CCC9, 0x00D2CCC9, 0x00D2CCC9, 0x00D2CCC9, 0x00D2CCC9, 0x00D2CCC9, 0x00D2CCC9, 0x00D2CCC9, 0x00D2CCC9, 0x00D2CCC9, 0x00D2CCC9, 0x00D2CCC9, 0x00D2CCC9, 0x00D2CCC9, 0x00D2CCC9, 0x00D2CCC9, 
        0x00D2CCC9, 0x00D2CCC9, 0x00D2CCC9, 0x00D2CCC9, 0x00D3CDCA, 0x00CDC7C4, 0x00AAA4A1, 0x08575453, 0x7B040303, 0xC6000000, 0xF1000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF535352, 0xFF535352, 0xC8787876, 0x02B9B7B5, 0x00EBE7E7, 0x00E8E5E4, 0x00E7E4E2, 0x00E7E4E3, 0x00E7E4E2, 0x00E7E4E2, 0x00E7E4E2, 0x00E7E4E2, 0x00E7E3E2, 0x00E6E3E2, 0x00E6E3E1, 0x00E6E3E1, 0x00E6E2E1, 0x00E6E2E1, 0x00E6E2E1, 0x00E5E2E1, 0x00E5E2E1, 
        0x00E5E2E1, 0x00E5E2E0, 0x00E5E2E0, 0x00E5E2E0, 0x00E5E1E0, 0x00E5E1E0, 0x00E5E1E0, 0x00E4E1E0, 0x00E5E1E0, 0x00E5E2E0, 0x00D4D0CE, 0x00958E8C, 0x0A413D3B, 0x4B020101, 0x76000000, 0xB6000000, 0xE9000000, 0xFD000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE1070707, 0x21646260, 0x00BEB9B6, 0x00D9D3D0, 
        0x00D5CFCC, 0x00D5CFCD, 0x00D5CFCD, 0x00D5CFCD, 0x00D5CFCD, 0x00D5CFCD, 0x00D5CFCD, 0x00D5CFCD, 0x00D5CFCD, 0x00D5CFCD, 0x00D5CFCD, 0x00D5CFCD, 0x00D5CFCD, 0x00D5CFCD, 0x00D5CFCD, 0x00D5CFCD, 0x00D5CFCD, 0x00D5CFCD, 0x00D5CFCD, 0x00D5CFCD, 
        0x00D5CFCD, 0x00D5CFCD, 0x00D5CFCD, 0x00D5CFCD, 0x00D6D0CE, 0x00D3CECB, 0x00BAB3B0, 0x00696563, 0x5C131211, 0xB7000000, 0xE9000000, 0xFE000000, 0xFF000000, 0xFF000000,
  0xFF070707, 0xFF060606, 0x93464545, 0x00CAC8C7, 0x00F1EDEB, 0x00EBE6E5, 0x00EAE5E4, 0x00EAE5E4, 0x00E9E5E4, 0x00E9E5E4, 0x00E9E5E4, 0x00E9E5E4, 0x00E9E5E4, 0x00E9E5E4, 0x00E9E5E3, 0x00E9E5E3, 0x00E9E5E3, 0x00E9E4E3, 0x00E9E4E3, 0x00E8E4E3, 0x00E8E4E3, 
        0x00E8E4E3, 0x00E8E4E3, 0x00E8E4E2, 0x00E8E3E2, 0x00E8E3E2, 0x00E8E3E2, 0x00E8E3E2, 0x00E8E3E2, 0x00E8E4E3, 0x00E6E1E0, 0x00C8C2C0, 0x0076706E, 0x2022201F, 0x5C000000, 0x8E000000, 0xCE000000, 0xF5000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0x683A3938, 0x00A39F9D, 0x00DDD7D5, 
        0x00D9D3D1, 0x00D9D3D1, 0x00D9D3D1, 0x00D9D3D1, 0x00D9D3D1, 0x00D9D3D1, 0x00D9D3D1, 0x00D9D3D1, 0x00D9D3D1, 0x00D9D3D1, 0x00D9D3D1, 0x00D9D3D1, 0x00D9D3D1, 0x00D9D3D1, 0x00D9D3D1, 0x00D9D3D1, 0x00D9D3D1, 0x00D9D3D1, 0x00D9D3D1, 0x00D9D3D1, 
        0x00D9D3D1, 0x00D9D3D1, 0x00D9D3D1, 0x00D9D3D1, 0x00D9D3D1, 0x00D9D3D0, 0x00C8C1BF, 0x007E7876, 0x3F1E1D1C, 0xA9000000, 0xDF000000, 0xFC000000, 0xFF000000, 0xFF000000,
  0xFF3A3A3A, 0xFF3D3D3D, 0x61828280, 0x00D0CECC, 0x00F3F0EE, 0x00ECE8E7, 0x00ECE8E7, 0x00ECE8E7, 0x00ECE8E6, 0x00ECE8E6, 0x00ECE8E6, 0x00ECE7E6, 0x00EBE7E6, 0x00EBE7E6, 0x00EBE7E6, 0x00EBE7E6, 0x00EBE7E6, 0x00EBE7E6, 0x00EAE7E6, 0x00EAE7E5, 0x00EBE6E5, 
        0x00EBE6E5, 0x00EBE6E5, 0x00EBE6E5, 0x00EAE6E5, 0x00EAE6E5, 0x00EAE6E5, 0x00EAE6E5, 0x00EAE6E4, 0x00EBE7E5, 0x00E3DEDD, 0x00B6AEAC, 0x0055504F, 0x380E0D0C, 0x6B000000, 0xA7000000, 0xE0000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xB21D1C1C, 0x027E7B79, 0x00DAD4D2, 
        0x00DED9D7, 0x00DDD7D5, 0x00DDD7D5, 0x00DDD7D5, 0x00DDD7D5, 0x00DDD7D5, 0x00DDD7D5, 0x00DDD7D5, 0x00DDD7D5, 0x00DDD7D5, 0x00DDD7D5, 0x00DDD7D5, 0x00DDD7D5, 0x00DDD7D5, 0x00DDD7D5, 0x00DDD7D5, 0x00DDD7D5, 0x00DDD7D5, 0x00DDD7D5, 0x00DDD7D5, 
        0x00DDD7D5, 0x00DDD7D5, 0x00DDD7D5, 0x00DDD7D5, 0x00DDD7D5, 0x00DED7D5, 0x00D4CDCB, 0x00908A88, 0x262D2B2A, 0x96000000, 0xD4000000, 0xF8000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFC000000, 0x34858483, 0x00E0DEDC, 0x00F3F0EF, 0x00EDEBEA, 0x00EDEBEA, 0x00EDEBEA, 0x00EEEBEA, 0x00EEEBE9, 0x00EEEBE9, 0x00EEEAE9, 0x00EDEAE9, 0x00EDEAE9, 0x00EDEAE9, 0x00EDEAE9, 0x00EDEAE9, 0x00EDEAE9, 0x00EDE9E8, 0x00EDEAE8, 0x00EDEAE8, 
        0x00EDEAE8, 0x00EDEAE8, 0x00EDEAE8, 0x00EDEAE8, 0x00EDE9E8, 0x00EDE9E8, 0x00EDE9E8, 0x00ECE9E8, 0x00EEEAE9, 0x00DED9D8, 0x009C9594, 0x09393534, 0x4D010101, 0x7E000000, 0xBE000000, 0xEE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE7040303, 0x205A5756, 0x00CBC6C4, 
        0x00E5E0DE, 0x00E1DCDA, 0x00E1DCDA, 0x00E1DCDA, 0x00E1DCDA, 0x00E1DCDA, 0x00E1DCDA, 0x00E1DCDA, 0x00E1DCDA, 0x00E1DCDA, 0x00E1DCDA, 0x00E1DCDA, 0x00E1DCDA, 0x00E1DCDA, 0x00E1DCDA, 0x00E1DCDA, 0x00E1DCDA, 0x00E1DCDA, 0x00E1DCDA, 0x00E1DCDA, 
        0x00E1DCDA, 0x00E1DCDA, 0x00E1DCDA, 0x00E1DCDA, 0x00E1DCDA, 0x00E2DDDB, 0x00DBD5D3, 0x00A49D9C, 0x123C3938, 0x82000000, 0xC8000000, 0xF3000000, 0xFF000000, 0xFF000000,
  0xFF30302F, 0xEA363534, 0x108B8A89, 0x00EDEBEA, 0x00F2F0EE, 0x00F0EDEC, 0x00F0EDEC, 0x00F0EDEC, 0x00F0EDEC, 0x00F0EDEB, 0x00F0EDEB, 0x00F0EDEB, 0x00EFEDEB, 0x00EFEDEB, 0x00EFEDEB, 0x00EFEDEB, 0x00EFEDEB, 0x00EFEDEB, 0x00EFEDEB, 0x00EFECEB, 0x00EFECEB, 
        0x00EFECEB, 0x00EFECEB, 0x00EFECEB, 0x00EEECEB, 0x00EFECEB, 0x00EFECEB, 0x00EFECEB, 0x00EFECEB, 0x00EEEBEA, 0x00D6D1D0, 0x007C7674, 0x1B1F1D1C, 0x5D000000, 0x92000000, 0xD2000000, 0xF7000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC010101, 0x5B3B3938, 0x00ABA9A7, 
        0x00ECE8E6, 0x00E4E0DE, 0x00E4E0DE, 0x00E4E0DE, 0x00E4E0DE, 0x00E4E0DE, 0x00E4E0DE, 0x00E4E0DE, 0x00E4E0DE, 0x00E4E0DE, 0x00E4E0DE, 0x00E4E0DE, 0x00E4E0DE, 0x00E4E0DE, 0x00E4E0DE, 0x00E4E0DE, 0x00E4E0DE, 0x00E4E0DE, 0x00E4E0DE, 0x00E4E0DE, 
        0x00E4E0DE, 0x00E4E0DE, 0x00E4E0DE, 0x00E4E0DE, 0x00E4E0DE, 0x00E5E1DF, 0x00E0DBDA, 0x00B9B2B0, 0x04484443, 0x6E040303, 0xBB000000, 0xED000000, 0xFF000000, 0xFF000000,
  0xFF0E0E0E, 0xC6424140, 0x03A3A3A1, 0x00F2F1EF, 0x00F3F1F0, 0x00F1F0EE, 0x00F1F0EE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1F0EE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFED, 
        0x00F1EEED, 0x00F1EEED, 0x00F1EEED, 0x00F1EEED, 0x00F1EFED, 0x00F0EFED, 0x00F0EFED, 0x00F1EFEE, 0x00EDEBE9, 0x00C8C2C0, 0x005C5756, 0x300E0E0D, 0x6C000000, 0xA7000000, 0xE1000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x971F1E1D, 0x008B8987, 
        0x00ECE8E6, 0x00E9E5E3, 0x00E8E4E2, 0x00E8E4E2, 0x00E8E4E2, 0x00E8E4E2, 0x00E8E4E2, 0x00E8E4E2, 0x00E8E4E2, 0x00E8E4E2, 0x00E8E4E2, 0x00E8E4E2, 0x00E8E4E2, 0x00E8E4E2, 0x00E8E4E2, 0x00E8E4E2, 0x00E8E4E2, 0x00E8E4E2, 0x00E8E4E2, 0x00E8E4E2, 
        0x00E8E4E2, 0x00E8E4E2, 0x00E8E4E2, 0x00E8E4E2, 0x00E8E4E2, 0x00E9E5E3, 0x00E6E2E0, 0x00C7C1BF, 0x00575352, 0x570B0B0B, 0xAF000000, 0xE5000000, 0xFE000000, 0xFF000000,
  0xFF000000, 0xA3302F2F, 0x00B1B0AE, 0x00F8F7F6, 0x00F4F2F2, 0x00F3F1F1, 0x00F3F1F1, 0x00F3F1F1, 0x00F3F1F1, 0x00F3F1F1, 0x00F3F1F0, 0x00F3F1F0, 0x00F3F1F0, 0x00F3F1F0, 0x00F3F1F0, 0x00F3F0F0, 0x00F3F0F0, 0x00F3F0F0, 0x00F3F0EF, 0x00F3F1EF, 0x00F3F1F0, 
        0x00F3F1F0, 0x00F3F1F0, 0x00F3F1F0, 0x00F3F0F0, 0x00F2F0F0, 0x00F2F0F0, 0x00F2F0F0, 0x00F3F1F0, 0x00EAE8E7, 0x00B5AFAE, 0x013F3B39, 0x44050504, 0x79000000, 0xBA000000, 0xED000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCE121111, 0x07646260, 
        0x00E6E2E1, 0x00EDEAE8, 0x00EBE8E6, 0x00EBE8E6, 0x00EBE8E6, 0x00EBE8E6, 0x00EBE8E6, 0x00EBE8E6, 0x00EBE8E6, 0x00EBE8E6, 0x00EBE8E6, 0x00EBE8E6, 0x00EBE8E6, 0x00EBE8E6, 0x00EBE8E6, 0x00EBE8E6, 0x00EBE8E6, 0x00EBE8E6, 0x00EBE8E6, 0x00EBE8E6, 
        0x00EBE8E6, 0x00EBE8E6, 0x00EBE8E6, 0x00EBE8E6, 0x00EBE8E6, 0x00ECE8E7, 0x00EBE7E6, 0x00D3CECC, 0x006A6563, 0x42100F0E, 0xA3000000, 0xDD000000, 0xFB000000, 0xFF000000,
  0xFF2A2A29, 0x81424140, 0x00B9B7B6, 0x00FFFDFC, 0x00F5F3F3, 0x00F5F3F3, 0x00F5F3F3, 0x00F5F3F3, 0x00F5F3F3, 0x00F5F3F3, 0x00F5F3F3, 0x00F5F3F3, 0x00F5F3F3, 0x00F5F3F2, 0x00F5F2F2, 0x00F5F3F2, 0x00F5F3F2, 0x00F5F3F2, 0x00F5F3F2, 0x00F5F3F2, 0x00F5F3F2, 
        0x00F4F3F2, 0x00F4F3F2, 0x00F4F3F2, 0x00F4F2F2, 0x00F4F2F2, 0x00F4F2F2, 0x00F4F2F2, 0x00F5F3F3, 0x00E7E4E4, 0x009D9695, 0x0C292625, 0x54000000, 0x89000000, 0xCB000000, 0xF5000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xEF010101, 0x2A494745, 
        0x00D1CFCD, 0x00F4F0EF, 0x00EFEBEA, 0x00EFEBEA, 0x00EFEBEA, 0x00EFEBEA, 0x00EFEBEA, 0x00EFEBEA, 0x00EFEBEA, 0x00EFEBEA, 0x00EFEBEA, 0x00EFEBEA, 0x00EFEBEA, 0x00EFEBEA, 0x00EFEBEA, 0x00EFEBEA, 0x00EFEBEA, 0x00EFEBEA, 0x00EFEBEA, 0x00EFEBEA, 
        0x00EFEBEA, 0x00EFEBEA, 0x00EFEBEA, 0x00EFEBEA, 0x00EFEBEA, 0x00EFEBEA, 0x00EFEBEA, 0x00DFDAD9, 0x007B7674, 0x33131110, 0x99000000, 0xD4000000, 0xF9000000, 0xFF000000,
  0xFF323231, 0x625E5D5B, 0x00C4C3C2, 0x00FFFEFE, 0x00F6F5F5, 0x00F6F5F5, 0x00F6F5F5, 0x00F6F5F5, 0x00F6F5F4, 0x00F6F5F4, 0x00F6F5F4, 0x00F6F5F4, 0x00F6F5F4, 0x00F6F5F4, 0x00F6F5F4, 0x00F6F5F4, 0x00F6F5F4, 0x00F6F5F4, 0x00F6F5F4, 0x00F6F4F4, 0x00F6F4F4, 
        0x00F6F4F4, 0x00F6F4F4, 0x00F6F4F3, 0x00F6F4F3, 0x00F6F4F3, 0x00F6F4F3, 0x00F6F4F3, 0x00F6F4F4, 0x00E3DFDE, 0x00807B79, 0x1A181615, 0x61000000, 0x9A000000, 0xD8000000, 0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0x5832312F, 
        0x00B2B1AF, 0x00FBF9F8, 0x00F1EFED, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 
        0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F1EFEE, 0x00F2EFEE, 0x00E8E3E2, 0x00898583, 0x231A1817, 0x8B000000, 0xCC000000, 0xF5000000, 0xFF000000,
  0xFF000000, 0x475F5E5C, 0x00D4D4D2, 0x00FEFCFC, 0x00F8F6F6, 0x00F8F6F6, 0x00F8F6F6, 0x00F8F6F6, 0x00F8F6F6, 0x00F8F6F6, 0x00F8F6F5, 0x00F8F6F5, 0x00F8F6F5, 0x00F8F6F5, 0x00F8F6F5, 0x00F8F6F5, 0x00F8F6F5, 0x00F8F6F5, 0x00F8F6F5, 0x00F8F6F5, 0x00F8F6F5, 
        0x00F8F6F5, 0x00F8F6F5, 0x00F8F6F5, 0x00F8F6F5, 0x00F8F6F5, 0x00F8F6F5, 0x00F8F7F6, 0x00F7F5F5, 0x00DCD8D7, 0x00686361, 0x280B0A0A, 0x6D000000, 0xAA000000, 0xE4000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x81181716, 
        0x009A9897, 0x00FEFCFB, 0x00F4F2F1, 0x00F4F2F1, 0x00F4F2F1, 0x00F4F2F1, 0x00F4F2F1, 0x00F4F2F1, 0x00F4F2F1, 0x00F4F2F1, 0x00F4F2F1, 0x00F4F2F1, 0x00F4F2F1, 0x00F4F2F1, 0x00F4F2F1, 0x00F4F2F1, 0x00F4F2F1, 0x00F4F2F1, 0x00F4F2F1, 0x00F4F2F1, 
        0x00F4F2F1, 0x00F4F2F1, 0x00F4F2F1, 0x00F4F2F1, 0x00F4F2F1, 0x00F4F2F1, 0x00F5F3F2, 0x00EDE9E9, 0x00999493, 0x18201E1D, 0x7E000000, 0xC3000000, 0xF2000000, 0xFF000000,
  0xF8020202, 0x2E5E5D5C, 0x00E1E1E0, 0x00FEFDFD, 0x00F9F8F8, 0x00F9F8F8, 0x00F9F8F8, 0x00F9F8F8, 0x00F9F8F8, 0x00F9F8F8, 0x00F9F8F8, 0x00F9F8F8, 0x00F9F8F8, 0x00F9F8F8, 0x00F9F8F8, 0x00F9F8F8, 0x00F9F8F8, 0x00F9F8F8, 0x00F9F8F8, 0x00F9F8F8, 0x00F9F8F8, 
        0x00F9F8F8, 0x00F9F8F8, 0x00F9F8F8, 0x00F9F8F8, 0x00F9F8F8, 0x00F9F8F8, 0x00FAF9F9, 0x00F7F5F5, 0x00CFCBCA, 0x004E4A48, 0x36070605, 0x78000000, 0xB8000000, 0xEC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xA8141312, 
        0x007B7977, 0x00F9F7F6, 0x00F8F6F6, 0x00F7F5F4, 0x00F7F5F4, 0x00F7F5F4, 0x00F7F5F4, 0x00F7F5F4, 0x00F7F5F4, 0x00F7F5F4, 0x00F7F5F4, 0x00F7F5F4, 0x00F7F5F4, 0x00F7F5F4, 0x00F7F5F4, 0x00F7F5F4, 0x00F7F5F4, 0x00F7F5F4, 0x00F7F5F4, 0x00F7F5F4, 
        0x00F7F5F4, 0x00F7F5F4, 0x00F7F5F4, 0x00F7F5F4, 0x00F7F5F4, 0x00F7F5F4, 0x00F8F6F5, 0x00F0EDEC, 0x00ABA6A5, 0x0E272523, 0x73000000, 0xBB000000, 0xED000000, 0xFF000000,
  0xF2030303, 0x195A5957, 0x00EDECEC, 0x00FEFDFD, 0x00FAFAF9, 0x00FAFAF9, 0x00FAFAF9, 0x00FAFAF9, 0x00FAFAF9, 0x00FAFAF9, 0x00FAFAF9, 0x00FAFAF9, 0x00FAFAF9, 0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 
        0x00FBFAF9, 0x00FBFAF9, 0x00FBF9F9, 0x00FBF9F9, 0x00FBF9F9, 0x00FBF9F9, 0x00FCFAFA, 0x00F6F4F4, 0x00C3BFBE, 0x00383533, 0x45030202, 0x83000000, 0xC5000000, 0xF2000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xCE100F0E, 
        0x06595755, 0x00F3F2F1, 0x00FBFAF9, 0x00F9F7F7, 0x00F9F7F7, 0x00F9F7F7, 0x00F9F7F7, 0x00F9F7F7, 0x00F9F7F7, 0x00F9F7F7, 0x00F9F7F7, 0x00F9F7F7, 0x00F9F7F7, 0x00F9F7F7, 0x00F9F7F7, 0x00F9F7F7, 0x00F9F7F7, 0x00F9F7F7, 0x00F9F7F7, 0x00F9F7F7, 
        0x00F9F7F7, 0x00F9F7F7, 0x00F9F7F7, 0x00F9F7F7, 0x00F9F7F7, 0x00F9F7F7, 0x00FAF8F8, 0x00F2F0EF, 0x00BAB6B5, 0x062A2826, 0x6B000000, 0xB3000000, 0xE9000000, 0xFF000000,
  0xE4302F2D, 0x0C61605F, 0x00F5F5F5, 0x00FFFEFE, 0x00FCFBFB, 0x00FCFBFB, 0x00FCFBFB, 0x00FCFBFB, 0x00FCFBFB, 0x00FCFBFB, 0x00FCFBFB, 0x00FCFBFB, 0x00FCFBFB, 0x00FCFBFB, 0x00FCFBFB, 0x00FCFBFB, 0x00FCFBFB, 0x00FCFBFB, 0x00FCFBFB, 0x00FCFBFB, 0x00FCFBFB, 
        0x00FCFBFB, 0x00FCFBFB, 0x00FCFCFB, 0x00FCFCFB, 0x00FCFCFB, 0x00FCFCFB, 0x00FDFDFC, 0x00F5F4F3, 0x00B7B3B2, 0x04272524, 0x51000000, 0x8D000000, 0xCF000000, 0xF6000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE8030303, 
        0x1342413F, 0x00EBEAEA, 0x00FEFDFE, 0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 
        0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 0x00FBFAF9, 0x00FCFBFA, 0x00F6F4F4, 0x00C6C2C1, 0x02302D2C, 0x61010000, 0xAB000000, 0xE5000000, 0xFE000000,
  0xD3292827, 0x076D6C6B, 0x00F9F8F8, 0x00FFFFFF, 0x00FDFDFD, 0x00FDFDFD, 0x00FDFDFD, 0x00FDFDFD, 0x00FDFDFD, 0x00FDFDFD, 0x00FDFDFD, 0x00FDFDFD, 0x00FDFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 
        0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FDFDFD, 0x00F4F3F2, 0x00A6A1A1, 0x0C1D1B1A, 0x5A000000, 0x98000000, 0xD7000000, 0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF3000000, 
        0x2B393836, 0x00DCDBDA, 0x00FFFFFF, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 
        0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FCFCFC, 0x00FDFDFD, 0x00FAF8F8, 0x00CDC9C8, 0x00373533, 0x56020201, 0xA5000000, 0xE1000000, 0xFE000000,
  0xC4161514, 0x03787675, 0x00FCFCFC, 0x00FFFFFF, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFE, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 
        0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FFFEFE, 0x00F4F3F3, 0x00969291, 0x12151312, 0x62000000, 0xA1000000, 0xDE000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFA000000, 
        0x3F2F2E2B, 0x00CBCBCA, 0x00FFFFFF, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 
        0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FEFEFD, 0x00FFFFFF, 0x00FCFCFC, 0x00D3CFCE, 0x003E3B39, 0x4D020202, 0x9F000000, 0xDD000000, 0xFE000000,
  0xB8171615, 0x00807F7D, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F3F2F1, 0x00898584, 0x180F0E0C, 0x69000000, 0xA9000000, 0xE3000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF010000, 
        0x4E262523, 0x00BDBDBC, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00D7D4D3, 0x0044413F, 0x47020201, 0x9B000000, 0xDA000000, 0xFC000000,
  0xAF161614, 0x00868684, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F0F0, 0x007E7A79, 0x1E090807, 0x70000000, 0xB0000000, 0xE7000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF010000, 
        0x601E1E1C, 0x00B0B0AF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00DAD7D6, 0x00494645, 0x42020201, 0x97000000, 0xD6000000, 0xFB000000,
  0xA9141312, 0x00878685, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F0EFEE, 0x00787472, 0x22060504, 0x75000000, 0xB5000000, 0xEA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x6A1B1A19, 0x00AAA9A8, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00DDDAD9, 0x004E4B49, 0x3F020101, 0x93000000, 0xD3000000, 0xFB000000,
  0xA3100F0E, 0x00878685, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F0EFEE, 0x0074706F, 0x25040302, 0x79000000, 0xBA000000, 0xED000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x71191917, 0x00A6A6A5, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FEFEFE, 0x00DEDBDB, 0x00514E4D, 0x3C020101, 0x91000000, 0xD1000000, 0xFB000000,
  0xA30E0E0C, 0x00858482, 0x00FFFFFF, 0x00FEFEFE, 0x00FDFEFE, 0x00FDFEFE, 0x00FDFEFE, 0x00FDFEFE, 0x00FDFEFE, 0x00FDFEFE, 0x00FDFEFE, 0x00FDFEFE, 0x00FDFEFE, 0x00FDFEFE, 0x00FDFEFE, 0x00FDFEFE, 0x00FDFEFE, 0x00FDFEFE, 0x00FDFEFE, 0x00FDFEFE, 0x00FDFEFE, 
        0x00FDFEFE, 0x00FDFEFE, 0x00FDFEFE, 0x00FDFEFE, 0x00FDFEFE, 0x00FDFEFE, 0x00FDFEFE, 0x00F0EFEE, 0x00716E6D, 0x27030201, 0x7D000000, 0xBD000000, 0xEF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x76191817, 0x00A4A4A3, 0x00FFFFFF, 0x00FCFEFE, 0x00FCFEFE, 0x00FCFEFE, 0x00FCFEFE, 0x00FCFEFE, 0x00FCFEFE, 0x00FCFEFE, 0x00FCFEFE, 0x00FCFEFE, 0x00FCFEFE, 0x00FCFEFE, 0x00FCFEFE, 0x00FCFEFE, 0x00FCFEFE, 0x00FCFEFE, 0x00FCFEFE, 0x00FCFEFE, 
        0x00FCFEFE, 0x00FCFEFE, 0x00FCFEFE, 0x00FCFEFE, 0x00FCFEFE, 0x00FCFEFE, 0x00FDFFFF, 0x00FBFDFD, 0x00DCDADA, 0x00504E4C, 0x3A010100, 0x8F000000, 0xD0000000, 0xFA000000,
  0xA30D0C0B, 0x00828180, 0x00FFFFFF, 0x00FCFDFD, 0x00FBFCFC, 0x00FBFCFC, 0x00FBFCFC, 0x00FBFCFC, 0x00FBFCFC, 0x00FBFCFC, 0x00FBFCFC, 0x00FBFCFC, 0x00FBFCFC, 0x00FBFCFC, 0x00FBFCFC, 0x00FBFCFC, 0x00FBFCFC, 0x00FBFCFC, 0x00FBFCFC, 0x00FBFCFC, 0x00FBFCFC, 
        0x00FBFCFC, 0x00FBFCFC, 0x00FBFCFC, 0x00FBFCFC, 0x00FBFCFC, 0x00FBFCFC, 0x00FBFCFC, 0x00EFEEEE, 0x00747170, 0x26030302, 0x7E000000, 0xBF000000, 0xF0000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x721F1E1C, 0x00A7A8A6, 0x00FFFFFF, 0x00F9FBFB, 0x00F9FBFB, 0x00F9FBFB, 0x00F9FBFB, 0x00F9FBFB, 0x00F9FBFB, 0x00F9FBFB, 0x00F9FBFB, 0x00F9FBFB, 0x00F9FBFB, 0x00F9FBFB, 0x00F9FBFB, 0x00F9FBFB, 0x00F9FBFB, 0x00F9FBFB, 0x00F9FBFB, 0x00F9FBFB, 
        0x00F9FBFB, 0x00F9FBFB, 0x00F9FBFB, 0x00F9FBFB, 0x00F9FBFB, 0x00F9FBFB, 0x00FAFCFC, 0x00F8FAFA, 0x00D8D7D6, 0x004E4C4A, 0x3A010100, 0x8D000000, 0xCF000000, 0xFA000000,
  0xA80B0A0A, 0x00797877, 0x00FEFFFF, 0x00FAFBFB, 0x00F9FBFA, 0x00F9FBFA, 0x00F9FBFA, 0x00F9FBFA, 0x00F9FBFA, 0x00F9FBFA, 0x00F9FBFA, 0x00F9FBFA, 0x00F9FBFA, 0x00F9FBFA, 0x00F9FBFA, 0x00F9FBFA, 0x00F9FBFA, 0x00F9FBFA, 0x00F9FBFA, 0x00F9FBFA, 0x00F9FBFA, 
        0x00F9FBFA, 0x00F9FBFA, 0x00F9FBFA, 0x00F9FBFA, 0x00F9FBFA, 0x00F9FBFA, 0x00FAFCFB, 0x00EFEEEE, 0x00797574, 0x24060504, 0x7E000000, 0xC0000000, 0xF0000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF0F0F0F, 0xFF686868, 0xFF070707, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x6C272524, 0x00ACADAB, 0x00FFFFFF, 0x00F7F9F8, 0x00F7F9F8, 0x00F7F9F8, 0x00F7F9F8, 0x00F7F9F8, 0x00F7F9F8, 0x00F7F9F8, 0x00F7F9F8, 0x00F7F9F8, 0x00F7F9F8, 0x00F7F9F8, 0x00F7F9F8, 0x00F7F9F8, 0x00F7F9F8, 0x00F7F9F8, 0x00F7F9F8, 0x00F7F9F8, 
        0x00F7F9F8, 0x00F7F9F8, 0x00F7F9F8, 0x00F7F9F8, 0x00F7F9F8, 0x00F7F9F8, 0x00F8FAF9, 0x00F6F8F7, 0x00D2D1D1, 0x00494644, 0x3C020101, 0x8D000000, 0xCF000000, 0xFA000000,
  0xAE0B0B0A, 0x0070706E, 0x00FBFCFC, 0x00F9FAFA, 0x00F8F9F8, 0x00F8F9F8, 0x00F8F9F8, 0x00F8F9F8, 0x00F8F9F8, 0x00F8F9F8, 0x00F8F9F8, 0x00F8F9F8, 0x00F7F9F8, 0x00F7F9F8, 0x00F7F9F8, 0x00F7F8F8, 0x00F7F8F8, 0x00F7F8F8, 0x00F7F8F8, 0x00F7F8F8, 0x00F7F8F8, 
        0x00F7F8F8, 0x00F7F8F8, 0x00F7F8F8, 0x00F7F8F8, 0x00F7F8F8, 0x00F7F8F8, 0x00F8F9F9, 0x00EEEFEE, 0x007F7C7B, 0x21090807, 0x7C000000, 0xBF000000, 0xF0000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF6B6B6B, 0xFFFFFFFF, 0xFFA2A2A2, 0xFF050505, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF010101, 
        0x63323130, 0x00B4B4B3, 0x00FEFFFE, 0x00F4F6F5, 0x00F4F6F5, 0x00F4F6F5, 0x00F4F6F5, 0x00F4F6F5, 0x00F4F6F5, 0x00F4F6F5, 0x00F4F6F5, 0x00F4F6F5, 0x00F4F6F5, 0x00F4F6F5, 0x00F4F6F5, 0x00F4F6F5, 0x00F4F6F5, 0x00F4F6F5, 0x00F4F6F5, 0x00F4F6F5, 
        0x00F4F6F5, 0x00F4F6F5, 0x00F4F6F5, 0x00F4F6F5, 0x00F4F6F5, 0x00F4F6F5, 0x00F5F7F6, 0x00F2F4F3, 0x00CDCCCA, 0x00444140, 0x3E020201, 0x8D000000, 0xCF000000, 0xFA000000,
  0xB70C0C0B, 0x00696866, 0x00F7F8F7, 0x00F7F9F8, 0x00F5F7F6, 0x00F5F7F6, 0x00F5F7F6, 0x00F5F7F6, 0x00F5F7F6, 0x00F5F7F6, 0x00F5F7F6, 0x00F5F7F6, 0x00F5F7F6, 0x00F5F7F6, 0x00F5F7F6, 0x00F5F6F6, 0x00F5F6F6, 0x00F5F6F6, 0x00F5F6F6, 0x00F5F6F6, 0x00F5F6F6, 
        0x00F5F6F5, 0x00F5F6F5, 0x00F5F6F5, 0x00F4F6F5, 0x00F4F6F6, 0x00F4F6F5, 0x00F5F7F6, 0x00EDEEEC, 0x008A8886, 0x1B100E0D, 0x79000000, 0xBD000000, 0xEF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF0D0D0D, 0xFF2B2B2B, 0xFF6A6969, 0xFFF3F2F2, 0xFFF4F4F4, 0xFFA3A2A2, 0xFF050606, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF010101, 
        0x5242403F, 0x00C0C1C0, 0x00F9FBFA, 0x00F0F2F1, 0x00F0F2F1, 0x00F0F2F1, 0x00F0F2F1, 0x00F0F2F1, 0x00F0F2F1, 0x00F0F2F1, 0x00F0F2F1, 0x00F0F2F1, 0x00F0F2F1, 0x00F0F2F1, 0x00F0F2F1, 0x00F0F2F1, 0x00F0F2F1, 0x00F0F2F1, 0x00F0F2F1, 0x00F0F2F1, 
        0x00F0F2F1, 0x00F0F2F1, 0x00F0F2F1, 0x00F0F2F1, 0x00F0F2F1, 0x00F0F2F1, 0x00F1F3F2, 0x00EFF0EF, 0x00C6C4C3, 0x003E3B3A, 0x41020201, 0x8D000000, 0xD0000000, 0xFA000000,
  0xC10E0D0C, 0x02605F5E, 0x00F2F3F2, 0x00F5F6F6, 0x00F3F4F4, 0x00F3F4F4, 0x00F3F4F4, 0x00F3F4F4, 0x00F3F4F4, 0x00F3F4F4, 0x00F3F4F4, 0x00F3F4F4, 0x00F3F4F4, 0x00F3F4F4, 0x00F3F4F4, 0x00F3F5F4, 0x00F3F5F4, 0x00F3F5F4, 0x00F3F5F4, 0x00F3F5F4, 0x00F3F5F4, 
        0x00F3F5F3, 0x00F3F5F3, 0x00F3F4F3, 0x00F3F4F3, 0x00F3F4F3, 0x00F2F4F2, 0x00F3F5F3, 0x00ECECEB, 0x00979594, 0x15161414, 0x74000000, 0xBA000000, 0xED000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF050505, 0xFFAEADAD, 0xFF6C6C6C, 0xFF5E5D5D, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFF7F6F6, 0xFFA5A4A4, 0xFF060606, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE010101, 
        0x42494846, 0x00CACAC9, 0x00F5F7F6, 0x00EEF0EF, 0x00EEF0EF, 0x00EEF0EF, 0x00EEF0EF, 0x00EEF0EF, 0x00EEF0EF, 0x00EEF0EF, 0x00EEF0EF, 0x00EEF0EF, 0x00EEF0EF, 0x00EEF0EF, 0x00EEF0EF, 0x00EEF0EF, 0x00EEF0EF, 0x00EEF0EF, 0x00EEF0EF, 0x00EEF0EF, 
        0x00EEF0EF, 0x00EEF0EF, 0x00EEF0EF, 0x00EEF0EF, 0x00EEF0EF, 0x00EEF0EF, 0x00EFF1F0, 0x00EAECEB, 0x00BEBCBB, 0x00383534, 0x45020201, 0x8F000000, 0xD1000000, 0xFB000000,
  0xCF100F0E, 0x06585755, 0x00EEEFEE, 0x00F4F5F4, 0x00F1F3F2, 0x00F1F3F2, 0x00F1F3F2, 0x00F1F3F2, 0x00F1F3F2, 0x00F1F3F2, 0x00F1F3F2, 0x00F1F3F2, 0x00F1F3F2, 0x00F1F3F2, 0x00F1F3F2, 0x00F1F3F2, 0x00F1F3F2, 0x00F1F3F2, 0x00F1F3F2, 0x00F1F3F2, 0x00F1F3F2, 
        0x00F1F3F2, 0x00F1F3F2, 0x00F1F3F2, 0x00F2F2F2, 0x00F2F1F1, 0x00F1F1F1, 0x00F2F2F2, 0x00ECECEB, 0x00A7A5A4, 0x0D1E1C1B, 0x6F000000, 0xB6000000, 0xEA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF050505, 0xFF9D9D9D, 0xFFFEFDFD, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFF9F8F8, 0xFFA4A4A4, 0xFF060606, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF8000000, 
        0x2E4E4D4B, 0x00D5D6D4, 0x00F2F3F2, 0x00ECEEEC, 0x00ECEEEC, 0x00ECEEEC, 0x00ECEEEC, 0x00ECEEEC, 0x00ECEEEC, 0x00ECEEEC, 0x00ECEEEC, 0x00ECEEEC, 0x00ECEEEC, 0x00ECEEEC, 0x00ECEEEC, 0x00ECEEEC, 0x00ECEEEC, 0x00ECEEEC, 0x00ECEEEC, 0x00ECEEEC, 
        0x00ECEEEC, 0x00ECEEEC, 0x00ECEEEC, 0x00ECEEEC, 0x00ECEEEC, 0x00ECEEEC, 0x00EDEFED, 0x00E7E8E7, 0x00B7B5B4, 0x00312F2D, 0x4B020101, 0x92000000, 0xD3000000, 0xFB000000,
  0xE00B0B0B, 0x0B4D4D4B, 0x00EAEBEA, 0x00F3F5F4, 0x00F0F2F1, 0x00F0F2F1, 0x00F0F2F1, 0x00F1F2F1, 0x00F0F2F0, 0x00F0F2F0, 0x00F0F2F0, 0x00F0F2F0, 0x00F0F2F0, 0x00F0F2F0, 0x00F0F2F0, 0x00F0F2F0, 0x00F0F2F0, 0x00F0F2F0, 0x00F0F2F0, 0x00F0F2F0, 0x00F0F2F0, 
        0x00F0F2F0, 0x00F0F2F0, 0x00F0F2F0, 0x00F0F2F0, 0x00F0F1F0, 0x00F0F1F1, 0x00F1F2F2, 0x00EDEDEC, 0x00BBB9B7, 0x05292725, 0x68000000, 0xB0000000, 0xE7000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF060606, 0xFF9C9C9C, 0xFFEDEDED, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFF8F8F8, 0xFFA4A4A4, 0xFF1F1F1F, 0xFF0F0F0E, 0xFF171716, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 
        0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 
        0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF181817, 0xFF171716, 0xF0161614, 
        0x155A5A58, 0x00E3E4E2, 0x00EEF0EE, 0x00EAEDEB, 0x00EAEDEB, 0x00EAEDEB, 0x00EAEDEB, 0x00EAEDEB, 0x00EAEDEB, 0x00EAEDEB, 0x00EAEDEB, 0x00EAEDEB, 0x00EAEDEB, 0x00EAEDEB, 0x00EAEDEB, 0x00EAEDEB, 0x00EAEDEB, 0x00EAEDEB, 0x00EAEDEB, 0x00EAEDEB, 
        0x00EAEDEB, 0x00EAEDEB, 0x00EAEDEB, 0x00EAEDEB, 0x00EAEDEB, 0x00EAEDEB, 0x00EBEEEC, 0x00E4E5E3, 0x00B0AEAC, 0x022B2826, 0x52000001, 0x95000000, 0xD6000000, 0xFB000000,
  0xED000000, 0x17444341, 0x00E1E2E1, 0x00F4F5F4, 0x00F0F0EF, 0x00F0F0EF, 0x00F0F0EF, 0x00F0F0EF, 0x00EFF0EF, 0x00EFF0EF, 0x00EFF0EF, 0x00EFF0EF, 0x00EFF0EF, 0x00EFF0EF, 0x00EFF0EF, 0x00EFF0EF, 0x00EFF0EF, 0x00EFF0EF, 0x00EFF0EF, 0x00EFF0EF, 0x00EFF0EF, 
        0x00EFF0EF, 0x00EFF0EF, 0x00EFF0EF, 0x00EFF0EF, 0x00EFF0EF, 0x00EFF0EF, 0x00F0F1F0, 0x00EEEEED, 0x00C8C6C5, 0x003A3837, 0x59030202, 0xAB000000, 0xE3000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF070707, 
        0xFF9D9C9C, 0xFFEEEEEE, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFF3F2F2, 0xFFE7E7E6, 0xFF5B5A59, 0xFF21201F, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 
        0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 
        0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xFF252423, 0xD7373735, 
        0x077A7978, 0x00E8E9E8, 0x00EBEDEB, 0x00E9EAE9, 0x00E9EAE9, 0x00E9EAE9, 0x00E9EAE9, 0x00E9EAE9, 0x00E9EAE9, 0x00E9EAE9, 0x00E9EAE9, 0x00E9EAE9, 0x00E9EAE9, 0x00E9EAE9, 0x00E9EAE9, 0x00E9EAE9, 0x00E9EAE9, 0x00E9EAE9, 0x00E9EAE9, 0x00E9EAE9, 
        0x00E9EAE9, 0x00E9EAE9, 0x00E9EAE9, 0x00E9EAE9, 0x00E9EAE9, 0x00E9EAE9, 0x00EAEBEA, 0x00E0E1DF, 0x00A6A2A0, 0x05252321, 0x59000000, 0x99000000, 0xDA000000, 0xFC000000,
  0xF4010100, 0x2B3E3D3C, 0x00D2D1D0, 0x00F5F5F4, 0x00EFEFEE, 0x00EFEFEE, 0x00EFEFEE, 0x00EFEEEE, 0x00EFEEEE, 0x00EEEEEE, 0x00EEEEED, 0x00EEEEED, 0x00EEEEED, 0x00EEEEED, 0x00EEEEED, 0x00EEEEED, 0x00EEEEED, 0x00EEEEED, 0x00EEEDED, 0x00EEEDED, 0x00EEEDED, 
        0x00EEEDED, 0x00EEEDED, 0x00EEEDED, 0x00EEEDED, 0x00EEEDED, 0x00EEEDED, 0x00EEEEED, 0x00EDEDEC, 0x00D3D1D0, 0x00545150, 0x49070606, 0xA4000000, 0xDE000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF0F0F0F, 
        0xFFDCDBDB, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFF9F9F9, 0xFFAEAEAD, 0xFF010101, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xB2252423, 
        0x00989895, 0x00ECECEB, 0x00E9E9E8, 0x00E8E7E6, 0x00E8E7E6, 0x00E8E7E6, 0x00E8E7E6, 0x00E8E7E6, 0x00E8E7E6, 0x00E8E7E6, 0x00E8E7E6, 0x00E8E7E6, 0x00E8E7E6, 0x00E8E7E6, 0x00E8E7E6, 0x00E8E7E6, 0x00E8E7E6, 0x00E8E7E6, 0x00E8E7E6, 0x00E8E7E6, 
        0x00E8E7E6, 0x00E8E7E6, 0x00E8E7E6, 0x00E8E7E6, 0x00E8E7E6, 0x00E8E7E6, 0x00E9E8E7, 0x00DDDCDB, 0x0096918F, 0x0C211F1E, 0x5D000000, 0x9D000000, 0xDD000000, 0xFE000000,
  0xFC020101, 0x44393836, 0x00BEBEBC, 0x00F5F5F4, 0x00EDEDEB, 0x00EDEDEB, 0x00EDEDEB, 0x00EDEDEB, 0x00EDEDEB, 0x00EDEEEB, 0x00EDEEEB, 0x00EEEEEB, 0x00EDEDEB, 0x00EDEDEB, 0x00EDEDEA, 0x00EDEDEA, 0x00ECECEA, 0x00ECECEA, 0x00ECECEA, 0x00ECECEA, 0x00ECECEB, 
        0x00ECECEB, 0x00ECECEB, 0x00ECECEB, 0x00ECECEB, 0x00ECECEB, 0x00ECECEB, 0x00ECECEB, 0x00ECECEB, 0x00DFDDDB, 0x00706D6B, 0x370B0A0A, 0x9C000000, 0xD7000000, 0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFE9E9E9, 0xFFF9F9F7, 0xFFA7A7A6, 0xFF2A2A29, 0xFF1E1D1C, 0xFF262524, 0xFF262525, 0xFF262525, 
        0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 
        0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF262525, 0xFF242323, 0x8B3B3A39, 
        0x00ABAAA8, 0x00F0F0EE, 0x00E6E6E4, 0x00E5E6E3, 0x00E5E6E3, 0x00E5E6E3, 0x00E5E6E3, 0x00E5E6E3, 0x00E5E6E3, 0x00E5E6E3, 0x00E5E6E3, 0x00E5E6E3, 0x00E5E6E3, 0x00E5E6E3, 0x00E5E6E3, 0x00E5E6E3, 0x00E5E6E3, 0x00E5E6E3, 0x00E5E6E3, 0x00E5E6E3, 
        0x00E5E6E3, 0x00E5E6E3, 0x00E5E6E3, 0x00E5E6E3, 0x00E5E6E3, 0x00E5E6E3, 0x00E6E6E4, 0x00D7D6D4, 0x0085807E, 0x141C1A19, 0x63000000, 0xA3000000, 0xE1000000, 0xFE000000,
  0xFF020101, 0x5E353433, 0x00AFAEAC, 0x00F6F6F3, 0x00ECEBEA, 0x00ECEBEA, 0x00ECEBEA, 0x00ECEBE9, 0x00ECEBE9, 0x00ECEBE9, 0x00ECEBE9, 0x00EBEBE9, 0x00EBEAE9, 0x00EBEAE9, 0x00EBEAE9, 0x00EBEBE9, 0x00EBEBE9, 0x00EBEBE9, 0x00EBEBE9, 0x00EBEBE9, 0x00EBEBE9, 
        0x00EBEBE9, 0x00EBEBE9, 0x00EBEBE9, 0x00EBEBE9, 0x00EBEBE9, 0x00EBEBE9, 0x00EBEBE9, 0x00ECEBE9, 0x00E5E4E1, 0x008B8886, 0x24191717, 0x8E000000, 0xCF000000, 0xF6000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF0E0E0E, 0xFF2F2F2F, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFF6F6F5, 0xFFEDEDEB, 0xFF696867, 0xFF2C2B2A, 0xFF302F2E, 0xFF302F2F, 
        0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 
        0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF302F2F, 0xFF313030, 0x62666563, 
        0x00BFBEBC, 0x00EDEDEA, 0x00E3E3E1, 0x00E4E3E1, 0x00E4E3E1, 0x00E4E3E1, 0x00E4E3E1, 0x00E4E3E1, 0x00E4E3E1, 0x00E4E3E1, 0x00E4E3E1, 0x00E4E3E1, 0x00E4E3E1, 0x00E4E3E1, 0x00E4E3E1, 0x00E4E3E1, 0x00E4E3E1, 0x00E4E3E1, 0x00E4E3E1, 0x00E4E3E1, 
        0x00E4E3E1, 0x00E4E3E1, 0x00E4E3E1, 0x00E4E3E1, 0x00E4E3E1, 0x00E4E4E1, 0x00E4E3E1, 0x00D1CECB, 0x00767270, 0x1C161513, 0x6B000000, 0xAA000000, 0xE5000000, 0xFE000000,
  0xFF000000, 0x7B232322, 0x00A1A09E, 0x00F5F4F3, 0x00EAEAE8, 0x00EAE9E8, 0x00EAE9E8, 0x00EAE9E8, 0x00EAE9E8, 0x00EAE9E8, 0x00EAE9E8, 0x00EAE9E8, 0x00E9E9E8, 0x00E9E9E7, 0x00EAE9E8, 0x00EAE9E8, 0x00EAE9E7, 0x00EAE9E7, 0x00EAE9E7, 0x00EAE9E7, 0x00EAE9E7, 
        0x00EAE9E7, 0x00EAE9E6, 0x00EAE9E6, 0x00EAE9E6, 0x00E9E9E6, 0x00E9E9E6, 0x00E9E8E6, 0x00EAE9E7, 0x00E6E3E2, 0x00ABA6A4, 0x102E2B2A, 0x7F000000, 0xC6000000, 0xF2000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1E1E1E, 0xFF646464, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFFBFBFA, 0xFFADADAC, 0xFF0D0E0E, 0xFF000000, 0xFF010101, 
        0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 
        0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFF010101, 0xFB050505, 0x30727170, 
        0x00D6D6D3, 0x00E7E6E4, 0x00E2E1DE, 0x00E2E1DE, 0x00E2E1DE, 0x00E2E1DE, 0x00E2E1DE, 0x00E2E1DE, 0x00E2E1DE, 0x00E2E1DE, 0x00E2E1DE, 0x00E2E1DE, 0x00E2E1DE, 0x00E2E1DE, 0x00E2E1DE, 0x00E2E1DE, 0x00E2E1DE, 0x00E2E1DE, 0x00E2E1DE, 0x00E2E1DE, 
        0x00E2E1DE, 0x00E2E1DE, 0x00E2E1DE, 0x00E2E1DE, 0x00E2E1DE, 0x00E3E2DF, 0x00E1E0DE, 0x00CAC5C3, 0x00686361, 0x27100F0E, 0x74000000, 0xB2000000, 0xE9000000, 0xFF000000,
  0xFF000000, 0x9B1C1C1C, 0x008E8D8B, 0x00EEEDEB, 0x00EAE9E6, 0x00E9E8E6, 0x00E9E8E6, 0x00E9E8E6, 0x00E9E8E5, 0x00E9E8E5, 0x00E9E8E5, 0x00E9E8E5, 0x00E9E8E5, 0x00E9E8E5, 0x00E8E8E5, 0x00E8E7E4, 0x00E8E7E5, 0x00E8E7E4, 0x00E8E7E4, 0x00E8E7E4, 0x00E8E6E4, 
        0x00E8E6E4, 0x00E8E6E4, 0x00E8E6E3, 0x00E8E6E3, 0x00E8E6E3, 0x00E8E6E3, 0x00E8E6E3, 0x00E9E7E4, 0x00E6E5E1, 0x00C5C1BE, 0x02474442, 0x68050505, 0xBB000000, 0xEC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFEBEBEB, 0xFFF4F4F3, 0xFFE2E2E1, 0xFF8B8B8A, 0xFF585755, 
        0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 
        0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xFF5D5C5B, 0xDE61605E, 0x098C8B89, 
        0x00E3E1DE, 0x00E3E1DE, 0x00E1DEDC, 0x00E1DEDC, 0x00E1DEDC, 0x00E1DEDC, 0x00E1DEDC, 0x00E1DEDC, 0x00E1DEDC, 0x00E1DEDC, 0x00E1DEDC, 0x00E1DEDC, 0x00E1DEDC, 0x00E1DEDC, 0x00E1DEDC, 0x00E1DEDC, 0x00E1DEDC, 0x00E1DEDC, 0x00E1DEDC, 0x00E1DEDC, 
        0x00E1DEDC, 0x00E1DEDC, 0x00E1DEDC, 0x00E1DEDC, 0x00E1DEDC, 0x00E2DFDD, 0x00DFDCD9, 0x00BDB8B5, 0x00585452, 0x320E0C0C, 0x7A000000, 0xBA000000, 0xED000000, 0xFF000000,
  0xFF000000, 0xBC1F1E1E, 0x01797876, 0x00E7E5E2, 0x00EAE8E4, 0x00E8E6E3, 0x00E8E6E3, 0x00E8E6E3, 0x00E8E6E3, 0x00E8E6E3, 0x00E8E6E3, 0x00E8E6E3, 0x00E8E5E3, 0x00E7E5E2, 0x00E6E5E2, 0x00E6E5E2, 0x00E6E5E2, 0x00E6E5E2, 0x00E7E5E2, 0x00E7E5E2, 0x00E7E3E2, 
        0x00E7E4E2, 0x00E7E4E1, 0x00E6E4E1, 0x00E6E4E1, 0x00E6E4E1, 0x00E6E4E1, 0x00E6E4E1, 0x00E7E4E1, 0x00E6E4E1, 0x00D4CFCD, 0x006A6664, 0x4A100F0F, 0xAF000000, 0xE4000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFF8F8F7, 0xFFE6E5E5, 0xFF222222, 
        0xFF131313, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 
        0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1A1A, 0xFF1A1919, 0xA8454544, 0x00B0AFAC, 
        0x00E6E3E1, 0x00DFDCDA, 0x00DFDCD9, 0x00DFDCD9, 0x00DFDCD9, 0x00DFDCD9, 0x00DFDCD9, 0x00DFDCD9, 0x00DFDCD9, 0x00DFDCD9, 0x00DFDCD9, 0x00DFDCD9, 0x00DFDCD9, 0x00DFDCD9, 0x00DFDCD9, 0x00DFDCD9, 0x00DFDCD9, 0x00DFDCD9, 0x00DFDCD9, 0x00DFDCD9, 
        0x00DFDCD9, 0x00DFDCD9, 0x00DFDCD9, 0x00DFDCD9, 0x00DFDCD9, 0x00E0DDDA, 0x00DAD6D3, 0x00AFA9A6, 0x00494543, 0x3F0A0A09, 0x81000000, 0xC2000000, 0xF2000000, 0xFF000000,
  0xFF000000, 0xE00E0E0E, 0x0E666563, 0x00E0DEDA, 0x00E9E6E4, 0x00E7E3E0, 0x00E6E3E0, 0x00E6E3E0, 0x00E6E3E1, 0x00E6E3E1, 0x00E6E3E1, 0x00E6E3E1, 0x00E6E3E1, 0x00E6E2E1, 0x00E5E2E1, 0x00E5E3E0, 0x00E5E3E0, 0x00E5E3E0, 0x00E4E3E0, 0x00E5E3E0, 0x00E5E2E0, 
        0x00E5E1E0, 0x00E5E1E0, 0x00E5E1E0, 0x00E5E1E0, 0x00E5E1E0, 0x00E5E1E0, 0x00E5E1DF, 0x00E5E1DF, 0x00E5E2E0, 0x00DEDAD7, 0x008D8987, 0x2A232120, 0x9D000000, 0xD9000000, 0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFF0EFEF, 0xFFE6E6E6, 
        0xFF6B6A6A, 0xFF2E2E2D, 0xFF313131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 
        0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF323131, 0xFF353434, 0x67797876, 0x00C2C0BE, 
        0x00E6E3E0, 0x00DDD9D6, 0x00DDD9D6, 0x00DDD9D6, 0x00DDD9D6, 0x00DDD9D6, 0x00DDD9D6, 0x00DDD9D6, 0x00DDD9D6, 0x00DDD9D6, 0x00DDD9D6, 0x00DDD9D6, 0x00DDD9D6, 0x00DDD9D6, 0x00DDD9D6, 0x00DDD9D6, 0x00DDD9D6, 0x00DDD9D6, 0x00DDD9D6, 0x00DDD9D6, 
        0x00DDD9D6, 0x00DDD9D6, 0x00DDD9D6, 0x00DDD9D6, 0x00DDD9D6, 0x00DEDAD7, 0x00D4D0CC, 0x00A09A97, 0x033C3937, 0x4E030303, 0x89000000, 0xCC000000, 0xF5000000, 0xFF000000,
  0xFF000000, 0xF4020101, 0x2F595755, 0x00CAC8C6, 0x00EAE6E3, 0x00E5E1DE, 0x00E5E1DF, 0x00E5E1DF, 0x00E4E1DE, 0x00E4E1DE, 0x00E3E1DE, 0x00E3E1DE, 0x00E3E1DE, 0x00E3E1DE, 0x00E4E1DE, 0x00E4E1DD, 0x00E4E1DD, 0x00E4E1DD, 0x00E3E1DD, 0x00E2E1DD, 0x00E3E1DD, 
        0x00E3E0DD, 0x00E3E0DD, 0x00E3E0DD, 0x00E3E0DD, 0x00E3E0DD, 0x00E3DFDD, 0x00E3DFDC, 0x00E3DFDC, 0x00E3E0DE, 0x00E0DCD9, 0x00B1ABAA, 0x0D413E3D, 0x85000000, 0xCC000000, 0xF5000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFFFFEFE, 
        0xFFAFAFAE, 0xFF0D0D0D, 0xFF040404, 0xFF0C0C0B, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 
        0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xFF0C0C0C, 0xF90E0E0E, 0x288D8C8A, 0x00D8D5D3, 
        0x00E0DCD8, 0x00DAD7D3, 0x00DBD7D3, 0x00DBD7D3, 0x00DBD7D3, 0x00DBD7D3, 0x00DBD7D3, 0x00DBD7D3, 0x00DBD7D3, 0x00DBD7D3, 0x00DBD7D3, 0x00DBD7D3, 0x00DBD7D3, 0x00DBD7D3, 0x00DBD7D3, 0x00DBD7D3, 0x00DBD7D3, 0x00DBD7D3, 0x00DBD7D3, 0x00DBD7D3, 
        0x00DBD7D3, 0x00DBD7D3, 0x00DBD7D3, 0x00DBD7D3, 0x00DAD7D3, 0x00DCD7D4, 0x00CCC7C3, 0x008C8683, 0x0E322F2E, 0x59000000, 0x94000000, 0xD4000000, 0xF9000000, 0xFF000000,
  0xFF000000, 0xFF020202, 0x594C4B4A, 0x00B7B4B1, 0x00EAE6E4, 0x00E2DFDD, 0x00E2DFDC, 0x00E2DFDC, 0x00E2DFDC, 0x00E2DFDC, 0x00E2DFDC, 0x00E2DFDC, 0x00E2DFDC, 0x00E2DEDC, 0x00E2DEDC, 0x00E2DEDC, 0x00E2DEDC, 0x00E2DEDC, 0x00E1DEDB, 0x00E1DEDB, 0x00E0DEDB, 
        0x00E0DEDB, 0x00E0DEDB, 0x00E0DEDB, 0x00E0DDDB, 0x00E0DDDB, 0x00E0DDDB, 0x00E0DDDB, 0x00E0DDDB, 0x00E1DEDC, 0x00E0DDD9, 0x00C9C4C1, 0x0065615F, 0x610F0E0E, 0xBD000000, 0xED000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEEEE, 
        0xFFF7F7F6, 0xFFEAEAE9, 0xFF757473, 0xFF2E2E2D, 0xFF333332, 0xFF343433, 0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 
        0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 0xFF343333, 0xC65C5C5B, 0x03AEADAC, 0x00DFDCD9, 
        0x00DBD6D3, 0x00D9D4D0, 0x00D9D4D0, 0x00D9D4D0, 0x00D9D4D0, 0x00D9D4D0, 0x00D9D4D0, 0x00D9D4D0, 0x00D9D4D0, 0x00D9D4D0, 0x00D9D4D0, 0x00D9D4D0, 0x00D9D4D0, 0x00D9D4D0, 0x00D9D4D0, 0x00D9D4D0, 0x00D9D4D0, 0x00D9D4D0, 0x00D9D4D0, 0x00D9D4D0, 
        0x00D9D4D0, 0x00D9D4D0, 0x00D9D4D0, 0x00D9D4D0, 0x00D9D4D1, 0x00D8D3D0, 0x00C2BCB9, 0x007A7371, 0x1B262423, 0x64000000, 0x9F000000, 0xDD000000, 0xFB000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0x882E2D2D, 0x00A5A2A0, 0x00E6E3DF, 0x00E1DDDA, 0x00E1DDDA, 0x00E1DDDA, 0x00E1DDDA, 0x00E1DDDA, 0x00E0DDDA, 0x00E0DDDA, 0x00E0DDDA, 0x00E0DDDA, 0x00E0DCDA, 0x00E0DCDA, 0x00E0DCDA, 0x00E0DCDA, 0x00DFDCD9, 0x00DFDCD9, 0x00DFDCD9, 
        0x00DFDCD9, 0x00DFDCD9, 0x00DFDCD9, 0x00DFDBD9, 0x00DFDCD9, 0x00DFDCD9, 0x00DFDCD9, 0x00DFDBD9, 0x00DFDBD8, 0x00E0DCD8, 0x00D6D1CE, 0x008E8987, 0x36292726, 0xAB000000, 0xE1000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFFEFDFD, 0xFFBAB9B9, 0xFF5F5F5F, 0xFF444343, 0xFF454444, 0xFF464545, 0xFF464545, 0xFF464545, 0xFF464545, 0xFF464545, 0xFF464545, 0xFF464545, 0xFF464545, 0xFF464545, 0xFF464545, 0xFF464545, 0xFF464545, 0xFF464545, 0xFF464545, 
        0xFF464545, 0xFF464545, 0xFF464545, 0xFF464545, 0xFF464545, 0xFF464545, 0xFF464545, 0xFF464545, 0xFF464545, 0xFF464545, 0xFF464545, 0xFF464545, 0xFF464545, 0xFF464545, 0xFF464545, 0xFF464545, 0xFF444343, 0x78706F6F, 0x00C8C6C4, 0x00E0DBD7, 
        0x00D7D2CE, 0x00D6D2CE, 0x00D6D2CE, 0x00D6D2CE, 0x00D6D2CE, 0x00D6D2CE, 0x00D6D2CE, 0x00D6D2CE, 0x00D6D2CE, 0x00D6D2CE, 0x00D6D2CE, 0x00D6D2CE, 0x00D6D2CE, 0x00D6D2CE, 0x00D6D2CE, 0x00D6D2CE, 0x00D6D2CE, 0x00D6D2CE, 0x00D6D2CE, 0x00D6D2CE, 
        0x00D6D2CE, 0x00D6D2CE, 0x00D6D2CE, 0x00D6D2CE, 0x00D8D3CF, 0x00D4CFCB, 0x00B6AEAA, 0x00696260, 0x2B1A1818, 0x6F000000, 0xAC000000, 0xE5000000, 0xFE000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xBB282727, 0x018D8B89, 0x00DEDAD6, 0x00E0DCD9, 0x00DFDBD8, 0x00DFDBD7, 0x00DFDBD7, 0x00DFDBD7, 0x00DFDBD7, 0x00DDDBD7, 0x00DDDBD7, 0x00DDDBD7, 0x00DDDBD7, 0x00DDDBD7, 0x00DDDBD7, 0x00DDDAD7, 0x00DDDAD7, 0x00DDDAD7, 0x00DDDAD7, 
        0x00DEDAD6, 0x00DDDAD6, 0x00DDDAD6, 0x00DDDAD6, 0x00DDDAD6, 0x00DDDAD6, 0x00DDDAD7, 0x00DDD9D6, 0x00DDD9D5, 0x00DEDAD6, 0x00DAD6D2, 0x00AFAAA8, 0x0F4E4A49, 0x8E020101, 0xD3000000, 0xF7000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF1F0F0, 0xFFFCFBFB, 0xFFFFFFFF, 0xFFC2C1C1, 0xFF737271, 0xFF7B7A79, 0xFF7C7B7A, 0xFF7C7B7A, 0xFF7C7B7A, 0xFF7C7B7A, 0xFF7C7B7A, 0xFF7C7B7A, 0xFF7C7B7A, 0xFF7C7B7A, 0xFF7C7B7A, 0xFF7C7B7A, 0xFF7C7B7A, 0xFF7C7B7A, 0xFF7C7B7A, 
        0xFF7C7B7A, 0xFF7C7B7A, 0xFF7C7B7A, 0xFF7C7B7A, 0xFF7C7B7A, 0xFF7C7B7A, 0xFF7C7B7A, 0xFF7C7B7A, 0xFF7C7B7A, 0xFF7C7B7A, 0xFF7C7B7A, 0xFF7C7B7A, 0xFF7C7B7A, 0xFF7C7B7A, 0xFF7C7B7A, 0xFF7B7A79, 0xF9838281, 0x2AAAA9A8, 0x00D3D1CE, 0x00D9D5D1, 
        0x00D3CFCB, 0x00D3CFCB, 0x00D3CFCB, 0x00D3CFCB, 0x00D3CFCB, 0x00D3CFCB, 0x00D3CFCB, 0x00D3CFCB, 0x00D3CFCB, 0x00D3CFCB, 0x00D3CFCB, 0x00D3CFCB, 0x00D3CFCB, 0x00D3CFCB, 0x00D3CFCB, 0x00D3CFCB, 0x00D3CFCB, 0x00D3CFCB, 0x00D3CFCB, 0x00D3CFCB, 
        0x00D3CFCB, 0x00D3CFCB, 0x00D3CFCB, 0x00D3CFCB, 0x00D5D0CC, 0x00CEC9C5, 0x00A49E9A, 0x00575250, 0x3D100E0E, 0x79000000, 0xB9000000, 0xED000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xE50D0C0C, 0x17767473, 0x00D3CFCC, 0x00E0DBD9, 0x00DDD8D6, 0x00DDD8D5, 0x00DDD8D5, 0x00DDD8D5, 0x00DCD8D5, 0x00DCD8D5, 0x00DCD8D5, 0x00DCD8D5, 0x00DCD8D5, 0x00DCD8D5, 0x00DCD7D5, 0x00DCD7D5, 0x00DCD7D5, 0x00DCD7D5, 0x00DCD7D5, 
        0x00DCD7D4, 0x00DCD7D4, 0x00DCD7D4, 0x00DCD7D4, 0x00DBD7D4, 0x00DBD7D5, 0x00DBD6D4, 0x00DBD6D4, 0x00DBD6D3, 0x00DBD6D4, 0x00DBD6D3, 0x00C9C3C0, 0x00787473, 0x5E191818, 0xC3000000, 0xEE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF9F9F8, 0xFFE4E3E3, 0xFF202020, 0xFF0D0C0C, 0xFF111111, 0xFF121212, 0xFF121212, 0xFF121212, 0xFF121212, 0xFF121212, 0xFF121212, 0xFF121212, 0xFF121212, 0xFF121212, 0xFF121212, 0xFF121212, 0xFF121212, 
        0xFF121212, 0xFF121212, 0xFF121212, 0xFF121212, 0xFF121212, 0xFF121212, 0xFF121212, 0xFF121212, 0xFF121212, 0xFF121212, 0xFF121212, 0xFF121212, 0xFF121212, 0xFF121212, 0xFF121212, 0xFF121111, 0xB7595959, 0x00C3C3C0, 0x00DCD7D3, 0x00D4CECB, 
        0x00D2CCC8, 0x00D2CCC8, 0x00D2CCC8, 0x00D2CCC8, 0x00D2CCC8, 0x00D2CCC8, 0x00D2CCC8, 0x00D2CCC8, 0x00D2CCC8, 0x00D2CCC8, 0x00D2CCC8, 0x00D2CCC8, 0x00D2CCC8, 0x00D2CCC8, 0x00D2CCC8, 0x00D2CCC8, 0x00D2CCC8, 0x00D2CCC8, 0x00D2CCC8, 0x00D2CCC8, 
        0x00D2CCC8, 0x00D2CCC8, 0x00D2CCC8, 0x00D2CCC8, 0x00D3CDC9, 0x00C7BFBC, 0x00948B88, 0x06484443, 0x4E030303, 0x85000000, 0xC7000000, 0xF3000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFA020202, 0x45686665, 0x00C1BDBA, 0x00E0DCD9, 0x00DCD7D3, 0x00DCD7D4, 0x00DCD7D4, 0x00DCD7D4, 0x00DCD7D4, 0x00DCD7D4, 0x00DCD7D4, 0x00DCD7D4, 0x00DCD7D4, 0x00DCD6D4, 0x00DCD6D4, 0x00DCD6D4, 0x00DCD6D4, 0x00DBD6D4, 0x00DBD6D3, 
        0x00DAD6D3, 0x00DAD6D3, 0x00DAD6D3, 0x00DAD6D3, 0x00DAD5D3, 0x00DAD5D3, 0x00DAD5D2, 0x00DAD5D2, 0x00DAD5D2, 0x00DAD5D2, 0x00DBD6D2, 0x00D5CFCC, 0x00A19B99, 0x29403E3D, 0xAA000000, 0xE1000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFE4E4E4, 0xFFC1C0C0, 0xFF999897, 0xFF9E9C9B, 0xFF9F9E9D, 0xFF9F9E9D, 0xFF9F9E9D, 0xFF9F9E9D, 0xFF9F9E9D, 0xFF9F9E9D, 0xFF9F9E9D, 0xFF9F9E9D, 0xFF9F9E9D, 0xFF9F9E9D, 0xFF9F9E9D, 
        0xFF9F9E9D, 0xFF9F9E9D, 0xFF9F9E9D, 0xFF9F9E9D, 0xFF9F9E9D, 0xFF9F9E9D, 0xFF9F9E9D, 0xFF9F9E9D, 0xFF9F9E9D, 0xFF9F9E9D, 0xFF9F9E9D, 0xFF9F9E9D, 0xFF9F9E9D, 0xFF9F9E9D, 0xFF9F9D9C, 0xFF999796, 0x5AA6A6A5, 0x00CECBC9, 0x00D9D4D0, 0x00D0CBC7, 
        0x00D1CBC7, 0x00D1CBC7, 0x00D1CBC7, 0x00D1CBC7, 0x00D1CBC7, 0x00D1CBC7, 0x00D1CBC7, 0x00D1CBC7, 0x00D1CBC7, 0x00D1CBC7, 0x00D1CBC7, 0x00D1CBC7, 0x00D1CBC7, 0x00D1CBC7, 0x00D1CBC7, 0x00D1CBC7, 0x00D1CBC7, 0x00D1CBC7, 0x00D1CBC7, 0x00D1CBC7, 
        0x00D1CBC7, 0x00D1CBC7, 0x00D1CBC7, 0x00D1CBC7, 0x00D1CBC7, 0x00BCB5B0, 0x00827A78, 0x143A3635, 0x5B000000, 0x94000000, 0xD4000000, 0xF8000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x7C464545, 0x00AFACAA, 0x00DDDAD6, 0x00DBD7D3, 0x00DBD6D2, 0x00DBD6D2, 0x00DBD6D2, 0x00DBD6D2, 0x00DBD6D2, 0x00DAD6D2, 0x00D9D6D2, 0x00D9D6D2, 0x00D9D6D2, 0x00D9D6D2, 0x00D9D6D2, 0x00DAD6D2, 0x00D9D6D1, 0x00D9D5D1, 
        0x00D8D5D1, 0x00D8D5D1, 0x00D8D5D1, 0x00D8D5D1, 0x00D8D4D1, 0x00D8D4D0, 0x00D8D4D0, 0x00D8D4D0, 0x00D8D4D0, 0x00D8D4D0, 0x00D9D5D2, 0x00D7D3CF, 0x00B9B3B0, 0x04706B6A, 0x7D0E0D0D, 0xD1000000, 0xF5000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFFAFAFA, 0xFFFFFFFF, 0xFF868585, 0xFF454444, 0xFF4E4E4D, 0xFF4E4E4D, 0xFF4E4E4D, 0xFF4E4E4D, 0xFF4E4E4D, 0xFF4E4E4D, 0xFF4E4E4D, 0xFF4E4E4D, 0xFF4E4E4D, 0xFF4E4E4D, 0xFF4E4E4D, 
        0xFF4E4E4D, 0xFF4E4E4D, 0xFF4E4E4D, 0xFF4E4E4D, 0xFF4E4E4D, 0xFF4E4E4D, 0xFF4E4E4D, 0xFF4E4E4D, 0xFF4E4E4D, 0xFF4E4E4D, 0xFF4E4E4D, 0xFF4E4E4D, 0xFF4E4E4D, 0xFF4E4E4D, 0xFF4D4D4C, 0xDD767575, 0x0DC5C3C3, 0x00D7D3D0, 0x00D2CDC9, 0x00CECAC5, 
        0x00CECAC5, 0x00CECAC5, 0x00CECAC5, 0x00CECAC5, 0x00CECAC5, 0x00CECAC5, 0x00CECAC5, 0x00CECAC5, 0x00CECAC5, 0x00CECAC5, 0x00CECAC5, 0x00CECAC5, 0x00CECAC5, 0x00CECAC5, 0x00CECAC5, 0x00CECAC5, 0x00CECAC5, 0x00CECAC5, 0x00CECAC5, 0x00CECAC5, 
        0x00CECAC5, 0x00CECAC5, 0x00CECAC5, 0x00CFCBC6, 0x00CCC7C3, 0x00ADA7A3, 0x00736B69, 0x27262423, 0x69000000, 0xA3000000, 0xDF000000, 0xFC000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xBC2C2A2A, 0x029B9897, 0x00D6D2CF, 0x00DAD6D2, 0x00D9D5D1, 0x00D9D5D1, 0x00D9D5D1, 0x00D9D5D1, 0x00D9D5D1, 0x00D8D5D1, 0x00D8D5D1, 0x00D8D5D1, 0x00D8D5D1, 0x00D8D5D1, 0x00D8D4D1, 0x00D7D4D0, 0x00D7D4D0, 0x00D7D3D0, 
        0x00D7D3D0, 0x00D7D3D0, 0x00D7D3CF, 0x00D7D2CF, 0x00D7D3CF, 0x00D7D3CF, 0x00D7D3CF, 0x00D7D3CF, 0x00D7D3CF, 0x00D7D3CF, 0x00D8D3CF, 0x00D2CDC9, 0x00C5BFBB, 0x00999391, 0x3D3B3939, 0xBB000000, 0xE9000000, 0xFD000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFFBFBFB, 0xFFBBBBBB, 0xFF292A2A, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x79818181, 0x00D6D4D3, 0x00D7D2CE, 0x00CDC8C5, 0x00CDC7C4, 
        0x00CDC7C4, 0x00CDC7C4, 0x00CDC7C4, 0x00CDC7C4, 0x00CDC7C4, 0x00CDC7C4, 0x00CDC7C4, 0x00CDC7C4, 0x00CDC7C4, 0x00CDC7C4, 0x00CDC7C4, 0x00CDC7C4, 0x00CDC7C4, 0x00CDC7C4, 0x00CDC7C4, 0x00CDC7C4, 0x00CDC7C4, 0x00CDC7C4, 0x00CDC7C4, 0x00CDC7C4, 
        0x00CDC7C4, 0x00CDC7C4, 0x00CDC7C4, 0x00CEC9C5, 0x00C6C0BC, 0x009D9592, 0x00625D5B, 0x3C121111, 0x74000000, 0xB3000000, 0xE9000000, 0xFE000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xEA070707, 0x21838180, 0x00CBC7C4, 0x00DAD5D1, 0x00D7D3CF, 0x00D8D3D0, 0x00D8D3D0, 0x00D8D3D0, 0x00D7D3D0, 0x00D7D3D0, 0x00D7D3D0, 0x00D7D3D0, 0x00D7D3D0, 0x00D7D2D0, 0x00D7D2CF, 0x00D6D2CF, 0x00D6D2CF, 0x00D6D2CF, 
        0x00D5D2CE, 0x00D5D2CE, 0x00D5D1CE, 0x00D5D1CE, 0x00D5D1CE, 0x00D5D1CE, 0x00D6D1CE, 0x00D6D1CE, 0x00D6D1CD, 0x00D6D1CE, 0x00D1CCC8, 0x00CCC6C2, 0x00CAC4C0, 0x00B3ADAA, 0x0A736F6E, 0x8E0B0A0A, 0xD9000000, 0xF8000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF4F4F4, 0xFFFFFFFF, 0xFFC2C2C2, 0xFF707070, 0xFF5F5F5F, 0xFF616060, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 
        0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF636363, 0xFF626161, 0xEA666565, 0x1AC6C5C4, 0x00D7D4D1, 0x00D1CBC7, 0x00CBC6C2, 0x00CCC6C2, 
        0x00CCC6C2, 0x00CCC6C2, 0x00CCC6C2, 0x00CCC6C2, 0x00CCC6C2, 0x00CCC6C2, 0x00CCC6C2, 0x00CCC6C2, 0x00CCC6C2, 0x00CCC6C2, 0x00CCC6C2, 0x00CCC6C2, 0x00CCC6C2, 0x00CCC6C2, 0x00CCC6C2, 0x00CCC6C2, 0x00CCC6C2, 0x00CCC6C2, 0x00CCC6C2, 0x00CCC6C2, 
        0x00CCC6C2, 0x00CCC6C2, 0x00CBC5C1, 0x00CCC6C2, 0x00BCB5B1, 0x008C8481, 0x09534E4D, 0x50020302, 0x82000000, 0xC4000000, 0xF1000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFD010101, 0x5B676564, 0x00BCB8B6, 0x00D9D3D1, 0x00D6D1CF, 0x00D6D1CE, 0x00D6D1CE, 0x00D6D1CE, 0x00D5D1CE, 0x00D5D1CE, 0x00D5D1CE, 0x00D4D1CE, 0x00D4D1CF, 0x00D4D0CE, 0x00D4D0CE, 0x00D4D0CE, 0x00D5D0CD, 0x00D5D0CD, 
        0x00D4D0CD, 0x00D4D0CD, 0x00D4CFCE, 0x00D4D0CE, 0x00D4CFCD, 0x00D4CFCD, 0x00D4CFCC, 0x00D4CFCC, 0x00D4D0CD, 0x00D1CDCA, 0x00CAC5C1, 0x00C9C4C0, 0x00CAC5C1, 0x00C1BCB8, 0x009D9997, 0x463F3D3C, 0xC4000000, 0xED000000, 0xFE000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF4F4F4, 0xFFFFFFFE, 0xFFFFFFFF, 0xFFEDEDEC, 0xFFCBCBC9, 0xFFC7C7C5, 0xFFC7C7C5, 0xFFC7C7C5, 0xFFC7C7C5, 0xFFC7C7C5, 0xFFC7C7C5, 0xFFC7C7C5, 0xFFC7C7C5, 
        0xFFC7C7C5, 0xFFC7C7C5, 0xFFC7C7C5, 0xFFC7C7C5, 0xFFC7C7C5, 0xFFC7C7C5, 0xFFC7C7C5, 0xFFC7C7C5, 0xFFC7C7C5, 0xFFC7C7C5, 0xFFC7C7C5, 0xFFC7C7C5, 0xFFC7C7C5, 0xFFCDCDCB, 0x83D4D4D2, 0x00D2D1CF, 0x00D4D0CC, 0x00CBC6C2, 0x00CAC4C0, 0x00CAC4C0, 
        0x00CAC4C0, 0x00CAC4C0, 0x00CAC4C0, 0x00CAC4C0, 0x00CAC4C0, 0x00CAC4C0, 0x00CAC4C0, 0x00CAC4C0, 0x00CAC4C0, 0x00CAC4C0, 0x00CAC4C0, 0x00CAC4C0, 0x00CAC4C0, 0x00CAC4C0, 0x00CAC4C0, 0x00CAC4C0, 0x00CAC4C0, 0x00CAC4C0, 0x00CAC4C0, 0x00CAC4C0, 
        0x00CAC4C0, 0x00CAC4C0, 0x00CAC5C1, 0x00C9C3BF, 0x00AEA7A3, 0x007F7875, 0x1C3B3837, 0x5E000000, 0x94000000, 0xD4000000, 0xF8000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x9E3E3C3C, 0x00AEAAA9, 0x00D2CECB, 0x00D6D1CD, 0x00D5D0CD, 0x00D4D0CD, 0x00D4D0CD, 0x00D4CFCD, 0x00D4CFCD, 0x00D4D0CD, 0x00D4CFCD, 0x00D4CECC, 0x00D4CFCC, 0x00D4CFCC, 0x00D4CFCB, 0x00D3CFCC, 0x00D3CFCC, 
        0x00D4CFCC, 0x00D4CFCC, 0x00D3CECC, 0x00D3CECC, 0x00D3CECA, 0x00D3CECB, 0x00D2CECB, 0x00D3CECB, 0x00D2CDC9, 0x00C9C4C0, 0x00C8C2BE, 0x00C8C3BF, 0x00C9C3BF, 0x00C7C1BD, 0x00B5AFAB, 0x09807D7B, 0x920E0D0D, 0xDD000000, 0xF9000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF6F6F5, 0xFFFAFAFA, 0xFFFEFEFE, 0xFF777776, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE8656463, 0x18DFDEDD, 0x00D7D3D0, 0x00CEC8C4, 0x00C8C2BE, 0x00C8C3BF, 0x00C8C3BF, 
        0x00C8C3BF, 0x00C8C3BF, 0x00C8C3BF, 0x00C8C3BF, 0x00C8C3BF, 0x00C8C3BF, 0x00C8C3BF, 0x00C8C3BF, 0x00C8C3BF, 0x00C8C3BF, 0x00C8C3BF, 0x00C8C3BF, 0x00C8C3BF, 0x00C8C3BF, 0x00C8C3BF, 0x00C8C3BF, 0x00C8C3BF, 0x00C8C3BF, 0x00C8C3BF, 0x00C8C3BF, 
        0x00C8C3BF, 0x00C8C3BF, 0x00CAC4C0, 0x00C2BCB8, 0x009E9692, 0x00736C6A, 0x31221F1F, 0x6B000000, 0xA7000000, 0xE2000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xDD161515, 0x14969393, 0x00C9C5C2, 0x00D5D0CC, 0x00D3CFCB, 0x00D3CECB, 0x00D3CECB, 0x00D3CECB, 0x00D3CECB, 0x00D3CECB, 0x00D3CDCB, 0x00D3CECA, 0x00D3CECA, 0x00D3CECA, 0x00D2CECA, 0x00D2CECA, 0x00D2CECA, 
        0x00D2CECA, 0x00D2CDCA, 0x00D1CDCA, 0x00D1CDCA, 0x00D1CDCA, 0x00D1CDCA, 0x00D1CDC9, 0x00D1CDC9, 0x00C9C4C0, 0x00C6C0BC, 0x00C7C1BD, 0x00C7C1BD, 0x00C7C1BD, 0x00C7C1BD, 0x00C0BAB5, 0x00A9A4A2, 0x40514E4D, 0xC5000000, 0xED000000, 0xFE000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF6F6F5, 0xFFF9F9F9, 0xFFFDFDFD, 0xFFBAB9B9, 0xFF787877, 0xFF5D5D5D, 0xFF5D5D5C, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 
        0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5D5D, 0xFF5D5E5D, 0x769D9C9C, 0x00DFDDDB, 0x00D1CDC9, 0x00C8C2BE, 0x00C7C1BD, 0x00C7C1BD, 0x00C7C1BD, 
        0x00C7C1BD, 0x00C7C1BD, 0x00C7C1BD, 0x00C7C1BD, 0x00C7C1BD, 0x00C7C1BD, 0x00C7C1BD, 0x00C7C1BD, 0x00C7C1BD, 0x00C7C1BD, 0x00C7C1BD, 0x00C7C1BD, 0x00C7C1BD, 0x00C7C1BD, 0x00C7C1BD, 0x00C7C1BD, 0x00C7C1BD, 0x00C7C1BD, 0x00C7C1BD, 0x00C7C1BD, 
        0x00C7C1BD, 0x00C6C0BC, 0x00C7C1BD, 0x00B8B1AD, 0x008D8682, 0x05635D5C, 0x48080707, 0x7A000000, 0xBB000000, 0xED000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFB000000, 0x5473706F, 0x00BEBBB8, 0x00D1CDCA, 0x00D1CEC9, 0x00D1CDC9, 0x00D0CDC9, 0x00D0CEC9, 0x00D0CDC9, 0x00D0CCC9, 0x00D0CCC9, 0x00D0CCC9, 0x00D0CCC9, 0x00D0CCC8, 0x00CFCCC9, 0x00D0CCC9, 0x00D0CCC9, 
        0x00D0CCC9, 0x00D0CBC8, 0x00D0CBC8, 0x00D0CBC8, 0x00D0CBC8, 0x00D0CBC8, 0x00D0CCC8, 0x00CAC4C1, 0x00C4BFBB, 0x00C5BFBB, 0x00C5BFBB, 0x00C5BFBB, 0x00C5BFBB, 0x00C5BFBB, 0x00C4BFBB, 0x00B8B3B0, 0x04979392, 0x861D1B1B, 0xDD000000, 0xF8000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF6F6F5, 0xFFF9F9F9, 0xFFFAFAF9, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFEFEFEE, 0xFFD8D8D7, 0xFFD8D8D7, 0xFFDADAD9, 0xFFDADAD9, 0xFFDADAD9, 0xFFDADAD9, 
        0xFFDADAD9, 0xFFDADAD9, 0xFFDADAD9, 0xFFDADAD9, 0xFFDADAD9, 0xFFDADAD9, 0xFFDADAD9, 0xFFDADAD9, 0xFFDADAD9, 0xFFDADAD9, 0xFFDADAD9, 0xFFDADAD9, 0xD3DBDCDB, 0x0BE1E0DF, 0x00D4D1CE, 0x00CAC5C1, 0x00C4BFBB, 0x00C5BFBB, 0x00C5BFBB, 0x00C5BFBB, 
        0x00C5BFBB, 0x00C5BFBB, 0x00C5BFBB, 0x00C5BFBB, 0x00C5BFBB, 0x00C5BFBB, 0x00C5BFBB, 0x00C5BFBB, 0x00C5BFBB, 0x00C5BFBB, 0x00C5BFBB, 0x00C5BFBB, 0x00C5BFBB, 0x00C5BFBB, 0x00C5BFBB, 0x00C5BFBB, 0x00C5BFBB, 0x00C5BFBB, 0x00C5BFBB, 0x00C5BFBB, 
        0x00C5BFBB, 0x00C5C0BC, 0x00C3BEBA, 0x00A8A19E, 0x00837B78, 0x1A464242, 0x5A000000, 0x8D000000, 0xCD000000, 0xF5000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xA03F3E3E, 0x00B4B0AF, 0x00CBC6C3, 0x00D0CDC9, 0x00CFCCC8, 0x00CFCCC8, 0x00CFCCC8, 0x00CFCBC8, 0x00CFCBC8, 0x00CFCBC8, 0x00CFCBC7, 0x00CFCBC7, 0x00CFCBC7, 0x00CECBC7, 0x00CECBC7, 0x00CDCBC7, 
        0x00CDCAC7, 0x00CDCAC6, 0x00CDCAC6, 0x00CDCAC6, 0x00CDC9C6, 0x00CECAC6, 0x00CAC6C2, 0x00C2BDB9, 0x00C2BDB9, 0x00C3BEBA, 0x00C3BEBA, 0x00C3BEBA, 0x00C3BEBA, 0x00C3BEBA, 0x00C3BEBA, 0x00BEB9B5, 0x00B4B0AE, 0x2A726F6E, 0xBC010101, 0xEB000000, 
        0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF6F6F5, 0xFFF9F9F9, 0xFFFAFAF9, 0xFFF9F8F8, 0xFFFBFBFA, 0xFFFFFFFE, 0xFFECECEB, 0xFFE0E0DF, 0xFFD5D5D5, 0xFFD7D7D7, 0xFFD7D7D7, 0xFFD7D7D7, 
        0xFFD7D7D7, 0xFFD7D7D7, 0xFFD7D7D7, 0xFFD7D7D7, 0xFFD7D7D7, 0xFFD7D7D7, 0xFFD7D7D7, 0xFFD7D7D7, 0xFFD7D7D7, 0xFFD7D7D7, 0xFFD8D8D7, 0xFFD8D8D7, 0x4CDDDEDD, 0x00DAD8D6, 0x00CCC8C4, 0x00C4BFBB, 0x00C2BEBA, 0x00C3BEBA, 0x00C3BEBA, 0x00C3BEBA, 
        0x00C3BEBA, 0x00C3BEBA, 0x00C3BEBA, 0x00C3BEBA, 0x00C3BEBA, 0x00C3BEBA, 0x00C3BEBA, 0x00C3BEBA, 0x00C3BEBA, 0x00C3BEBA, 0x00C3BEBA, 0x00C3BEBA, 0x00C3BEBA, 0x00C3BEBA, 0x00C3BEBA, 0x00C3BEBA, 0x00C3BEBA, 0x00C3BEBA, 0x00C3BEBA, 0x00C3BEBA, 
        0x00C2BEBA, 0x00C4BFBB, 0x00BBB6B2, 0x00968F8B, 0x007B7371, 0x32242221, 0x68000000, 0xA2000000, 0xDE000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE20F0E0E, 0x1E9A9796, 0x00C3BFBC, 0x00CDC9C6, 0x00CEC9C7, 0x00CDC9C7, 0x00CDCAC7, 0x00CDCAC7, 0x00CDC9C7, 0x00CDC9C6, 0x00CDC9C6, 0x00CDC9C6, 0x00CDC9C6, 0x00CCC9C5, 0x00CCC8C5, 0x00CCC8C5, 
        0x00CCC8C5, 0x00CCC8C5, 0x00CCC7C4, 0x00CCC7C4, 0x00CCC8C5, 0x00CAC6C3, 0x00C1BCB9, 0x00C0BBB7, 0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 0x00C0BBB7, 0x00B9B4B0, 0x00B1ADAC, 0x65424040, 0xD9000000, 
        0xF5000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF6F6F5, 0xFFF9F9F9, 0xFFFAFAF9, 0xFFF9F8F8, 0xFFFAFAFA, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFEDEDED, 0xFFD8D8D8, 0xFFDADADA, 0xFFD9D9D9, 0xFFD9D9D9, 
        0xFFD9D9D9, 0xFFD9D9D9, 0xFFD9D9D9, 0xFFD9D9D9, 0xFFD9D9D9, 0xFFD9D9D9, 0xFFD9D9D9, 0xFFD9D9D9, 0xFFD9D9D9, 0xFFD9D9D9, 0xFFD8D8D8, 0xA2DDDDDD, 0x00E1E0DF, 0x00D1CDCA, 0x00C4BFBB, 0x00C0BBB7, 0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 
        0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 0x00C1BCB8, 
        0x00C1BCB8, 0x00C1BCB8, 0x00ADA7A4, 0x0089817E, 0x0967615F, 0x4B050505, 0x79000000, 0xB9000000, 0xEB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0x6C656262, 0x00BEBAB8, 0x00C7C3C0, 0x00CCC8C5, 0x00CCC8C5, 0x00CCC7C5, 0x00CCC7C5, 0x00CCC7C5, 0x00CBC6C5, 0x00CBC6C4, 0x00CBC6C4, 0x00CAC6C4, 0x00CAC6C4, 0x00CAC5C4, 0x00CAC5C4, 
        0x00CAC6C4, 0x00CAC6C3, 0x00CAC6C3, 0x00CBC6C3, 0x00CAC5C3, 0x00C1BDB8, 0x00BEB9B5, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BDB8B3, 0x00B9B4B1, 0x0CA09D9C, 0x9E181717, 
        0xE8000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF6F6F5, 0xFFF9F9F9, 0xFFFAFAF9, 0xFFF9F8F8, 0xFFFAFAFA, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFF3F2F2, 0xFFE8E6E6, 0xFFE9E8E8, 
        0xFFE9E8E8, 0xFFE9E8E8, 0xFFE9E8E8, 0xFFE9E8E8, 0xFFE9E8E8, 0xFFE9E8E8, 0xFFE9E8E8, 0xFFE9E8E8, 0xFFE9E8E8, 0xFFE8E7E7, 0xE4E2E1E1, 0x1AE6E5E5, 0x00D7D4D2, 0x00C6C1BD, 0x00BFBAB6, 0x00BEB9B5, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 
        0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 0x00BFBAB6, 
        0x00BFBAB6, 0x00BBB6B2, 0x009B9491, 0x00857C7A, 0x21403D3C, 0x5C000000, 0x8E000000, 0xCE000000, 0xF5000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xBF292727, 0x05B1ADAC, 0x00C2BEBB, 0x00CAC5C2, 0x00CAC6C3, 0x00CAC5C3, 0x00CAC5C3, 0x00CAC5C3, 0x00CAC5C2, 0x00C9C5C1, 0x00C9C5C2, 0x00C9C5C2, 0x00C9C5C2, 0x00C9C5C2, 0x00C9C4C1, 
        0x00C9C4C0, 0x00C9C4C0, 0x00C8C4C0, 0x00C9C4C1, 0x00C2BDBA, 0x00BCB7B3, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00B8B3AF, 0x00BFBAB8, 0x30827F7F, 
        0xC6020202, 0xF0000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF6F6F5, 0xFFF9F9F9, 0xFFFAFAF9, 0xFFF9F8F8, 0xFFFAFAFA, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFFFFFF, 0xFFF6F5F5, 0xFFEBE9E9, 0xFFEBEAEA, 
        0xFFEBEAEA, 0xFFEBEAEA, 0xFFEBEAEA, 0xFFEBEAEA, 0xFFEBEAEA, 0xFFEBEAEA, 0xFFEBEAEA, 0xFFEBEAEA, 0xFFEAE9E9, 0xFEEAE8E8, 0x52EAE9E9, 0x00E0DEDC, 0x00C8C4C1, 0x00BEB9B5, 0x00BCB7B3, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 
        0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BDB8B4, 0x00BCB7B3, 
        0x00BEB9B5, 0x00B0ABA7, 0x008C8481, 0x027C7473, 0x3D151414, 0x6B000000, 0xA7000000, 0xE0000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF2020101, 0x408A8787, 0x00BFBBB8, 0x00C4C0BD, 0x00C8C5C1, 0x00C8C5C0, 0x00C8C4C1, 0x00C8C4C1, 0x00C8C4C0, 0x00C7C4C0, 0x00C6C4C0, 0x00C7C4C0, 0x00C7C4C0, 0x00C7C3C0, 0x00C7C3BF, 
        0x00C7C2BF, 0x00C6C2BF, 0x00C7C3BF, 0x00C3BFBB, 0x00BAB6B1, 0x00BAB5B1, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BAB5B1, 0x00B6B2AE, 0x00C4C1BF, 
        0x605A5958, 0xDD000000, 0xF6000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF6F6F5, 0xFFF9F9F9, 0xFFFAFAF9, 0xFFF9F8F8, 0xFFFAFAFA, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFFEFEFE, 0xFFFEFEFE, 0xFFF7F7F7, 
        0xFFEEEEEE, 0xFFEFEFEF, 0xFFEFEFEF, 0xFFEFEFEF, 0xFFEFEFEF, 0xFFEFEFEF, 0xFFF0F0F0, 0xFFF1F1F1, 0xFFE9E9E8, 0x92EBEBEB, 0x00E9E7E7, 0x00CDC9C6, 0x00BFBAB6, 0x00BAB5B1, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 
        0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 0x00BBB6B2, 
        0x00B9B4B0, 0x009E9894, 0x00877F7C, 0x145D5757, 0x53000000, 0x80000000, 0xC0000000, 0xEF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x9C444141, 0x00BBB7B5, 0x00BDB8B5, 0x00C5C2BE, 0x00C5C2BF, 0x00C5C2BE, 0x00C5C1BE, 0x00C5C1BE, 0x00C5C1BD, 0x00C5C1BD, 0x00C5C1BD, 0x00C5C1BD, 0x00C5C0BD, 0x00C5C1BE, 
        0x00C4C0BE, 0x00C5C1BD, 0x00C4BFBC, 0x00BAB5B1, 0x00B8B3AF, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B9B4B0, 0x00B7B2AE, 0x00BAB6B3, 
        0x05C0BDBC, 0x8C363535, 0xEA000000, 0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF6F6F5, 0xFFF9F9F9, 0xFFFAFAF9, 0xFFF9F8F8, 0xFFFAFAFA, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFF9F9F9, 
        0xFFF0F0F0, 0xFFF1F1F1, 0xFFF1F1F1, 0xFFF1F1F1, 0xFFF1F1F1, 0xFFF1F1F1, 0xFFF0F0F0, 0xFFF1F1F1, 0xC5EEEFEE, 0x0CEEEEED, 0x00D4D1CF, 0x00C0BBB7, 0x00B9B4B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 
        0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3B0, 0x00B8B3AF, 0x00BAB5B1, 
        0x00AFAAA6, 0x008C8581, 0x00867E7C, 0x31292727, 0x62000000, 0x98000000, 0xD6000000, 0xF8000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xE4090808, 0x2A9A9695, 0x00BCB7B6, 0x00BFBBB8, 0x00C3BFBC, 0x00C3BFBC, 0x00C3BFBC, 0x00C3BFBC, 0x00C3BFBC, 0x00C3BFBC, 0x00C3BFBC, 0x00C3BFBC, 0x00C3BFBC, 0x00C3BEBC, 
        0x00C3BEBC, 0x00C3BEBC, 0x00BAB5B2, 0x00B5B0AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AE, 0x00B3ADAA, 
        0x00C2BEBB, 0x13B9B6B5, 0xAD201F1F, 0xF1000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF6F6F5, 0xFFF9F9F9, 0xFFFAFAF9, 0xFFF9F8F8, 0xFFFAFAFA, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 
        0xFFFBFBFB, 0xFFF8F8F8, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFF9F9F9, 0xFFF8F8F8, 0xFFEEEEEE, 0xE5F1F1F1, 0x24F6F5F5, 0x00DBD9D7, 0x00C0BCB9, 0x00B7B2AF, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 
        0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AD, 0x00B6B1AE, 0x00B5B0AD, 
        0x009D9794, 0x00877F7D, 0x0D6D6866, 0x4B030303, 0x75000000, 0xB4000000, 0xE8000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x85555251, 0x00C0BBBA, 0x00B8B3B0, 0x00C1BCBA, 0x00C1BDBB, 0x00C1BDBA, 0x00C1BDBA, 0x00C0BDBA, 0x00C0BDBA, 0x00C0BDBA, 0x00C0BCBA, 0x00C0BCBA, 0x00C0BBBA, 
        0x00C1BDBB, 0x00BBB6B3, 0x00B3ADAA, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 
        0x00B1ABA8, 0x00CCC7C6, 0x29AAA7A6, 0xC4131212, 0xF5000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF6F6F5, 0xFFF9F9F9, 0xFFFAFAF9, 0xFFF9F8F8, 0xFFFAFAFA, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 
        0xFFFCFCFC, 0xFFF9F9F9, 0xFFFDFDFD, 0xFFFCFCFC, 0xFFFAFAFA, 0xFFF8F8F8, 0xF2EEEEEE, 0x40F7F7F7, 0x00E3E2E1, 0x00C2BEBB, 0x00B6B1AE, 0x00B3AEAA, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 
        0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B3AEAB, 0x00B4AFAC, 0x00ACA6A3, 
        0x0089837F, 0x008B8381, 0x2A373434, 0x5D000000, 0x8F000000, 0xCD000000, 0xF4000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xD8121212, 0x1CA6A2A1, 0x00B8B3B1, 0x00B9B5B2, 0x00BEBBB7, 0x00BEBAB7, 0x00BEBAB7, 0x00BEBAB7, 0x00BEBBB7, 0x00BEBBB7, 0x00BDBAB7, 0x00BDBAB7, 0x00BEBBB8, 
        0x00BCB8B5, 0x00B1ADA9, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 
        0x00B0ABA8, 0x00AEAAA6, 0x00D2CFCD, 0x3C9C9B9A, 0xD4080707, 0xF7000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF6F6F5, 0xFFF9F9F9, 0xFFFAFAF9, 0xFFF9F8F8, 0xFFFAFAFA, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 
        0xFFFCFCFC, 0xFFF9F9F9, 0xFFFDFDFD, 0xFFFCFCFC, 0xFFFAFAFA, 0xFDF8F8F8, 0x59F8F9F9, 0x00E8E7E6, 0x00C3BFBD, 0x00B4B0AC, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 
        0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B0ABA8, 0x00B1ACA9, 0x00B0ABA7, 0x00999390, 
        0x00847C79, 0x08797272, 0x46080707, 0x6F000000, 0xAB000000, 0xE2000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFB000000, 0x7C5C5959, 0x00C0BBBA, 0x00B2ADAA, 0x00BAB6B4, 0x00BBB7B5, 0x00BBB7B5, 0x00BBB7B5, 0x00BBB7B5, 0x00BBB7B5, 0x00BBB7B4, 0x00BBB7B5, 0x00BBB7B5, 
        0x00B1ADA9, 0x00ACA7A4, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 
        0x00ADA8A5, 0x00ACA7A4, 0x00AEA9A6, 0x00DAD8D6, 0x4A939191, 0xDC030303, 0xF9000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF6F6F5, 0xFFF9F9F9, 0xFFFAFAF9, 0xFFF9F8F8, 0xFFFAFAFA, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 
        0xFFFCFCFC, 0xFFF9F9F9, 0xFFFDFDFD, 0xFFFCFCFC, 0xFFFAFAFA, 0x6AFEFEFE, 0x00EDECEC, 0x00C5C1BF, 0x00B3AEAC, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 
        0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00ADA8A5, 0x00AEA9A6, 0x00A5A19D, 0x00847E7B, 
        0x008D8683, 0x283E3B3B, 0x5A000000, 0x88000000, 0xC7000000, 0xF1000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xD7100F0F, 0x1EA6A1A0, 0x00B5B0AE, 0x00B3AEAC, 0x00BAB5B2, 0x00B9B5B2, 0x00B9B5B2, 0x00B9B4B2, 0x00B9B4B2, 0x00B9B4B2, 0x00BAB6B3, 0x00B3AEAB, 
        0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 
        0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AFAAA7, 0x00E2DFDF, 0x53929191, 0xE1050404, 0xFB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF6F6F5, 0xFFF9F9F9, 0xFFFAFAF9, 0xFFF9F8F8, 0xFFFAFAFA, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 
        0xFFFCFCFC, 0xFFF9F9F9, 0xFFFDFDFD, 0xFFFDFDFD, 0x72FFFFFF, 0x00F0EFEE, 0x00C6C2C0, 0x00B2AEAA, 0x00ABA6A3, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 
        0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00AAA5A2, 0x00ABA6A3, 0x00AAA5A2, 0x00938D8A, 0x00827B78, 
        0x0A7C7573, 0x46070707, 0x6B000000, 0xA6000000, 0xDF000000, 0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFA000000, 0x7E575353, 0x00BDB8B7, 0x00AAA6A3, 0x00B5B1AE, 0x00B7B2B0, 0x00B7B2B0, 0x00B7B2B0, 0x00B7B2B0, 0x00B7B3B0, 0x00B4B0AD, 0x00A8A3A0, 
        0x00A7A29F, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 
        0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A7A29F, 0x00ADA9A6, 0x00E5E2E1, 0x4DA09F9F, 0xDD0F0F0F, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF6F6F5, 0xFFF9F9F9, 0xFFFAFAF9, 0xFFF9F8F8, 0xFFFAFAFA, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 
        0xFFFCFCFC, 0xFFF9F9F9, 0xFBFDFDFD, 0x69FFFFFF, 0x00F1F0EF, 0x00C5C1BF, 0x00AFABA8, 0x00A8A3A0, 0x00A7A29F, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 
        0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A8A3A0, 0x00A7A3A0, 0x00A8A3A0, 0x009F9996, 0x007F7875, 0x008F8885, 
        0x293D3A39, 0x59000000, 0x86000000, 0xC5000000, 0xF0000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xD90C0B0B, 0x249D9897, 0x00B0ACAA, 0x00ABA7A4, 0x00B4B0AD, 0x00B3B0AC, 0x00B3B0AC, 0x00B4B0AD, 0x00B4B0AD, 0x00A9A4A1, 0x00A49F9C, 
        0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 
        0x00A5A09D, 0x00A5A09D, 0x00A59F9C, 0x00A5A09D, 0x00A39E9B, 0x00ABA5A2, 0x00E2E0DE, 0x40B5B4B4, 0xD61D1C1C, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF6F6F5, 0xFFF9F9F9, 0xFFFAFAF9, 0xFFF9F8F8, 0xFFFAFAFA, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 
        0xFFFCFCFC, 0xF3FAFAFA, 0x56FFFFFF, 0x00EDEDEB, 0x00C2BEBC, 0x00ADA8A5, 0x00A5A09D, 0x00A49F9C, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 
        0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A5A09D, 0x00A39D9A, 0x00898481, 0x00827A77, 0x0C7A7372, 
        0x47050505, 0x6B000000, 0xA7000000, 0xDF000000, 0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF9000000, 0x91423F3F, 0x00BCB6B5, 0x00A5A19F, 0x00AEAAA7, 0x00B1ADAA, 0x00B1ACAA, 0x00B2AEAB, 0x00ABA7A4, 0x00A09C99, 0x00A19D9A, 
        0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 
        0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19C99, 0x00A5A19E, 0x00DEDCDB, 0x33CCCBCB, 0xCB282828, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF6F6F5, 0xFFF9F9F9, 0xFFFAFAF9, 0xFFF9F8F8, 0xFFFAFAFA, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFEFEFE, 0xFFFFFFFF, 
        0xE9FCFCFC, 0x45FFFFFF, 0x00EAE8E7, 0x00BDBAB7, 0x00A9A5A2, 0x00A29D9A, 0x00A19C99, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 
        0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A19D9A, 0x00A29D9A, 0x0095908D, 0x0079726F, 0x00908886, 0x2F2E2C2B, 
        0x5A000000, 0x88000000, 0xC7000000, 0xF0000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0xE4020202, 0x3C898483, 0x00B3AEAC, 0x00A29E9B, 0x00AEA9A7, 0x00AFAAA8, 0x00ADA8A5, 0x009F9B98, 0x009D9996, 0x009E9996, 
        0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 
        0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x00A09B98, 0x00DDDAD9, 0x25DFDFDF, 0xB2454444, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF6F6F5, 0xFFF9F9F9, 0xFFFAFAF9, 0xFFF9F8F8, 0xFFFAFAFA, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFFFFFFF, 0xFFFEFEFE, 0xCFFFFFFF, 
        0x32FFFFFF, 0x00E5E4E2, 0x00B7B3B0, 0x00A5A19E, 0x009E9A97, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 
        0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9996, 0x009E9A97, 0x009A9693, 0x007D7774, 0x00867E7B, 0x15696463, 0x4C000000, 
        0x6F000000, 0xAB000000, 0xE0000000, 0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF9000000, 0xAB2A2827, 0x06B2ABAA, 0x00A19D9B, 0x00A5A09E, 0x00ACA8A5, 0x00A19D9A, 0x00999592, 0x009B9693, 0x009B9693, 
        0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 
        0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009C9895, 0x00CDCAC8, 0x0CF1F0EF, 0x88848383, 0xF5020202, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF6F6F5, 0xFFF9F9F9, 0xFFFAFAF9, 0xFFF9F8F8, 0xFFFAFAFA, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFCFCFC, 0xFFFDFDFD, 0xFFFFFFFF, 0x9EFFFFFF, 0x13FCFCFC, 
        0x00DAD8D6, 0x00B1ADAA, 0x00A19C99, 0x009B9794, 0x009A9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 
        0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x009B9693, 0x00888380, 0x00756E6C, 0x028D8583, 0x391D1B1B, 0x5E000000, 
        0x8F000000, 0xCB000000, 0xF2000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0xED000000, 0x5F656161, 0x00B5AFAD, 0x009B9693, 0x00A29E9B, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 
        0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 
        0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x00958F8D, 0x00B3AFAD, 0x00F5F4F3, 0x57B8B7B7, 0xDE272727, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF6F6F5, 0xFFF9F9F9, 0xFFFAFAF9, 0xFFF9F8F8, 0xFFFAFAFA, 0xFFFCFCFC, 0xFFFBFBFB, 0xFFFCFCFC, 0xF1FDFDFD, 0x68FFFFFF, 0x00F5F5F4, 0x00C9C6C4, 
        0x00A8A3A1, 0x009B9693, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 
        0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x0097928F, 0x00989390, 0x008F8A87, 0x00726C69, 0x008C8482, 0x214F4B4A, 0x52000000, 0x76000000, 
        0xB3000000, 0xE5000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF9000000, 0xCC0C0B0B, 0x21979291, 0x00A39E9D, 0x008B8785, 0x00928E8B, 0x00938F8C, 0x00938F8C, 0x00938F8C, 
        0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 
        0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938E8C, 0x00938E8C, 0x00938F8C, 0x00938E8B, 0x009F9B99, 0x00E0DFDE, 0x2AE3E3E3, 0xB2585858, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF6F6F5, 0xFFF9F9F9, 0xFFFAFAF9, 0xFFF9F8F8, 0xFFFAFAFA, 0xFFFCFCFC, 0xFFFBFBFB, 0xC6FEFEFE, 0x35FFFFFF, 0x00E5E5E3, 0x00B8B6B3, 0x00A09B99, 
        0x0096928F, 0x00928E8B, 0x00938E8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 
        0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938F8C, 0x00938E8C, 0x00948F8D, 0x00918C8A, 0x0078726F, 0x007A7371, 0x0C7A7372, 0x45070606, 0x64000000, 0x99000000, 
        0xD3000000, 0xF6000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xF3000000, 0x94343231, 0x02ADA8A6, 0x00888381, 0x00898582, 0x00908B88, 0x00908B88, 0x00908B88, 
        0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 
        0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x008F8B88, 0x00908B88, 0x008F8B88, 0x00938F8C, 0x00C4C1BF, 0x04F7F6F6, 0x6AABABAB, 0xE22C2C2C, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF6F6F5, 0xFFF9F9F9, 0xFFFAFAF9, 0xFFF9F8F8, 0xFFFAFAFA, 0xF0FDFDFD, 0x7AFFFFFF, 0x07F8F8F7, 0x00D3D1CF, 0x00AAA7A4, 0x00989491, 0x00908C89, 
        0x008F8B88, 0x008F8B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 
        0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x00908B88, 0x008F8B88, 0x007F7A77, 0x006C6663, 0x018D8483, 0x32272525, 0x58000000, 0x83000000, 0xBE000000, 
        0xEB000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF9000000, 0xE4000000, 0x53676363, 0x00A5A09E, 0x007F7977, 0x008A8582, 0x008C8784, 0x008C8784, 
        0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 
        0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008D8885, 0x008C8784, 0x00A39E9B, 0x00E2E0DF, 0x25EEEEEE, 0x98858686, 0xF60D0D0D, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF6F6F5, 0xFFF9F9F9, 0xFFFAFAF9, 0xFFF9F8F8, 0xA7FDFDFD, 0x2CFEFEFE, 0x00E5E3E2, 0x00BAB7B4, 0x009D9995, 0x00918C89, 0x008C8784, 0x008C8784, 
        0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 
        0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008C8784, 0x008D8885, 0x00847F7C, 0x00696260, 0x00857E7B, 0x1D544F4E, 0x4E000000, 0x6F000000, 0xA9000000, 0xDE000000, 
        0xF9000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF6000000, 0xC60B0B0A, 0x23918B8A, 0x0095908E, 0x007B7673, 0x00878280, 0x00888381, 
        0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 
        0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888380, 0x00888380, 0x00888381, 0x00898381, 0x008E8986, 0x00B4B0AF, 0x00ECEBEA, 0x3CDBDBDB, 0xAE6E6E6E, 
        0xFB0C0C0C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF5F5F5, 0xFFF6F6F5, 0xFFF9F9F9, 0xB9FDFCFC, 0x46FDFDFD, 0x00EDECEB, 0x00C7C4C2, 0x00A39F9D, 0x00928D8B, 0x008A8582, 0x00888280, 0x00888380, 0x00888381, 
        0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 
        0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00888381, 0x00898481, 0x00857F7D, 0x006B6563, 0x0077706E, 0x0D766F6E, 0x44070606, 0x61000000, 0x93000000, 0xCD000000, 0xF3000000, 
        0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0xF0000000, 0x9A282626, 0x07A19A9A, 0x00827C7B, 0x007B7775, 0x00847F7D, 
        0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 
        0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x0085807E, 0x0086817E, 0x00908C8A, 0x00BCBAB8, 0x00F0EFEE, 
        0x45D6D6D6, 0xAF6F6F70, 0xF8101010, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xFFF5F5F5, 0xFFF5F5F5, 0xFEF6F6F6, 0xB8F9F9F9, 0x4CFCFCFC, 0x00EFEEEE, 0x00CCCAC9, 0x00A8A4A2, 0x00938E8C, 0x00898381, 0x00847F7D, 0x00847E7C, 0x00847F7D, 0x00847F7D, 0x00847F7D, 
        0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 
        0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00847F7D, 0x00837E7C, 0x00706B69, 0x0068615F, 0x03857E7D, 0x361F1D1D, 0x57000000, 0x80000000, 0xBB000000, 0xE9000000, 0xFC000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF9000000, 0xE5000000, 0x67504C4C, 0x00A39D9C, 0x0076706E, 0x007C7774, 
        0x00817D7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 
        0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C79, 0x00817D7A, 0x00827E7B, 0x00847F7C, 0x00928F8B, 
        0x00BDBAB9, 0x00EAE9E9, 0x38DCDCDC, 0x988C8D8D, 0xE8343435, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xFFF3F2F2, 0xFFF4F4F3, 0xFFF4F3F3, 0xEFF6F6F6, 0xA2F8F9F9, 0x3EF9F9F9, 0x00EBEAE9, 0x00CCCAC8, 0x00A9A5A3, 0x00928E8B, 0x00878380, 0x00827D7A, 0x00807C79, 0x00817C79, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 
        0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 
        0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00817C7A, 0x00746F6C, 0x005F5957, 0x00867E7C, 0x26403C3C, 0x50000000, 0x71000000, 0xA9000000, 0xDE000000, 0xF8000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF4000000, 0xD3010000, 0x3E6D6867, 0x00958F8D, 0x00706B69, 
        0x007B7774, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 
        0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7977, 0x007E7977, 0x007E7A77, 0x00807C79, 
        0x00827D7B, 0x008F8A88, 0x00B3B0AF, 0x00E2E1E0, 0x1BEAE9E9, 0x6BB4B4B4, 0xBE696969, 0xF5141414, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF1C1C1C, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xFFEFEFEF, 
        0xFFF0F0EF, 0xFFF2F1F1, 0xF9F4F3F3, 0xC3F7F6F6, 0x71F9F8F8, 0x1FF3F3F3, 0x00E2E2E1, 0x00C3C1BF, 0x00A4A09E, 0x00908B89, 0x0085807E, 0x007F7B78, 0x007D7976, 0x007E7977, 0x007E7977, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 
        0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 
        0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A77, 0x007E7A78, 0x0077726F, 0x005E5856, 0x007B7371, 0x185A5555, 0x4A000000, 0x64000000, 0x98000000, 0xD0000000, 0xF3000000, 0xFE000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0xF0000000, 0xBA0D0C0C, 0x20837E7D, 0x00898382, 
        0x006E6967, 0x007A7573, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 
        0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7674, 0x007B7674, 0x007B7674, 
        0x007B7774, 0x007D7976, 0x00807B78, 0x00898482, 0x00A09D9A, 0x00CAC7C6, 0x01E7E5E4, 0x2BDFDFDF, 0x72A6A6A6, 0xB6757575, 0xED343434, 0xFF0D0D0D, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF181818, 0xFF5D5D5D, 0xFF000000, 0xFF0E0E0E, 
        0xFFD3D2D2, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5E5E5E, 0xFF5F5E5E, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xFFECECEB, 0xFFECECEC, 0xFFEDEDEC, 0xFFEFEFEE, 0xFFEFEEEE, 0xF2F0F0F0, 
        0xBAF3F3F2, 0x78F6F5F5, 0x2FF3F3F2, 0x02E7E5E5, 0x00D1CECD, 0x00B3B0AE, 0x009A9694, 0x008A8683, 0x00817D7A, 0x007C7775, 0x007A7673, 0x007B7674, 0x007B7674, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 
        0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 
        0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x007B7774, 0x0076726F, 0x005F5957, 0x006F6867, 0x0D6F6967, 0x42080808, 0x5C000000, 0x88000000, 0xC2000000, 0xEC000000, 0xFD000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF9000000, 0xEA000000, 0x9C1E1D1D, 0x0C8F8A89, 
        0x007A7573, 0x006C6765, 0x00777370, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 
        0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787371, 
        0x00787371, 0x00787371, 0x00787471, 0x00797572, 0x007C7775, 0x00807C79, 0x008D8986, 0x00A7A3A2, 0x00C8C6C4, 0x00E4E3E2, 0x1AE1E0E0, 0x53D8D8D7, 0x85999A9A, 0xBA777777, 0xE53C3C3C, 0xF80E0E0E, 0xFF292929, 0xFF555555, 0xFF000000, 0xFF000000, 
        0xFFD2D1D1, 0xFFE1E1E1, 0xFFDCDCDC, 0xFFEDECEC, 0xFF5C5C5C, 0xFF5D5C5C, 0xFFF2F1F1, 0xFFE3E3E3, 0xFFE6E5E5, 0xFFE8E7E7, 0xFFE7E7E7, 0xFFE9E8E9, 0xFFEAEAEA, 0xFFE9E9E8, 0xF9EDEDEC, 0xE8EEEEEE, 0xBDF0F0EF, 0x89F3F3F3, 0x56F2F1F1, 0x1DEDEDED, 
        0x00E1E0DF, 0x00CDCCCA, 0x00B6B3B1, 0x009E9A97, 0x008D8986, 0x00827E7C, 0x007B7875, 0x00797472, 0x00777370, 0x00787371, 0x00787371, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 
        0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 
        0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x00787471, 0x0075706D, 0x00605A58, 0x00635C5A, 0x05797271, 0x38181717, 0x56000000, 0x7C000000, 0xB4000000, 0xE3000000, 0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF7000000, 0xE2000000, 0x7F312E2D, 
        0x04908A88, 0x00716C6A, 0x006B6764, 0x0075706E, 0x0075716E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 
        0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 
        0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075716F, 0x00777371, 0x007A7573, 0x007E7A78, 0x00898683, 0x009C9896, 0x00B3B0AE, 0x00CDCCCA, 0x00E3E2E1, 0x0CDFDEDE, 0x2DD6D5D5, 0x55DDDCDC, 0x74ACACAB, 0x8F777777, 0xA97C7C7C, 
        0xBBDDDDDD, 0xCDE2E2E2, 0xD9DFDFDF, 0xD9EFEEEE, 0xEB686868, 0xEB696868, 0xD9F3F3F3, 0xDAE5E6E5, 0xCEE9E8E8, 0xBCEBEAEA, 0xABEBEBEB, 0x90EEEDED, 0x76EFEFEF, 0x58EDEDEC, 0x2FECEBEB, 0x0DE8E7E6, 0x00DDDDDC, 0x00CECCCB, 0x00BDBBB9, 0x00A9A6A4, 
        0x00989492, 0x008A8683, 0x00807C7A, 0x007A7674, 0x0076716F, 0x0075706E, 0x0074706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 
        0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 
        0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075706E, 0x0075716F, 0x00736F6D, 0x00615C5A, 0x005D5755, 0x027B7472, 0x30272424, 0x52000000, 0x72000000, 0xA8000000, 0xDB000000, 0xF7000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF3000000, 0xDA000000, 
        0x673F3C3B, 0x008F8988, 0x00696462, 0x006A6663, 0x00726E6B, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 
        0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 
        0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6B, 0x00726D6B, 0x00716D6B, 0x00716D6B, 0x00726E6C, 0x0074706E, 0x00777270, 0x00797573, 0x007F7B79, 0x00898482, 0x0095918F, 0x00A5A2A1, 0x00B2B0AE, 0x00C4C2C0, 0x00D6D4D3, 0x00DDDCDA, 
        0x00D3D2D1, 0x05D7D7D6, 0x09DCDBDA, 0x09DDDDDC, 0x0EDAD9D8, 0x0EDADAD9, 0x09DFDEDD, 0x09DFDEDD, 0x05DDDCDB, 0x00D8D7D6, 0x00D2D1D0, 0x00CBCAC8, 0x00C3C2C0, 0x00BAB8B6, 0x00ACA9A7, 0x009E9A99, 0x0093908E, 0x00888482, 0x00807C7A, 0x007B7774, 
        0x0076716F, 0x00736F6C, 0x00716D6B, 0x00716D6B, 0x00716D6B, 0x00726D6B, 0x00726E6B, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 
        0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 
        0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00726E6C, 0x00716D6B, 0x00615D5B, 0x00575150, 0x007B7573, 0x28343131, 0x4F000000, 0x6A000000, 0x9D000000, 0xD2000000, 0xF3000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xF0000000, 
        0xCE000000, 0x514C4847, 0x00888382, 0x00635F5C, 0x00696461, 0x006F6B68, 0x006F6B69, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 
        0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 
        0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6A68, 0x006F6A68, 0x006F6A68, 0x00706C69, 0x00716D6A, 0x0074706D, 0x0076726F, 0x00777371, 0x007C7774, 0x00817D7A, 0x00878280, 
        0x00898583, 0x008D8A87, 0x00918E8B, 0x0093908D, 0x00999592, 0x00999593, 0x0095918F, 0x0095918E, 0x00928E8B, 0x008E8B88, 0x008B8684, 0x0085817F, 0x00807C7A, 0x007C7875, 0x00797472, 0x00767270, 0x00726E6B, 0x00706C69, 0x006F6B68, 0x006F6A68, 
        0x006F6A68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 
        0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 0x006F6B68, 
        0x006F6B68, 0x006F6B68, 0x006F6B68, 0x00706B69, 0x006F6B68, 0x00615D5B, 0x00524C4B, 0x00756E6C, 0x21413D3D, 0x4C000000, 0x63000000, 0x93000000, 0xCA000000, 0xEF000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 
        0xED000000, 0xC5000000, 0x4353504F, 0x00847F7D, 0x00605B59, 0x0066625F, 0x006C6865, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 
        0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 
        0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006C6866, 0x006C6866, 0x006C6865, 0x006C6765, 0x006C6765, 0x006C6765, 0x006C6765, 0x006D6866, 0x006D6867, 0x006E6967, 
        0x006E6A67, 0x006F6A68, 0x00706B69, 0x00716C6A, 0x00716D6A, 0x00716D6A, 0x00726D6B, 0x00716C6A, 0x006F6A68, 0x006E6A67, 0x006E6967, 0x006E6967, 0x006D6966, 0x006C6765, 0x006C6765, 0x006C6765, 0x006C6765, 0x006C6765, 0x006C6865, 0x006C6866, 
        0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 
        0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 0x006D6866, 
        0x006D6866, 0x006D6866, 0x006D6866, 0x006C6765, 0x005F5B58, 0x00504B48, 0x006E6866, 0x1C484343, 0x49000000, 0x5F000000, 0x8C000000, 0xC2000000, 0xEA000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFA000000, 0xE9000000, 0xBD010101, 0x3C555150, 0x007E7977, 0x005C5856, 0x00635F5D, 0x00696563, 0x006A6563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 
        0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 
        0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696562, 
        0x00696562, 0x00696562, 0x00696562, 0x00696562, 0x00696562, 0x00696562, 0x00696562, 0x00696562, 0x00696562, 0x00696562, 0x00696562, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 
        0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 
        0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 0x00696563, 
        0x006A6563, 0x006A6663, 0x00696563, 0x005D5856, 0x004D4846, 0x006A6462, 0x1A4A4544, 0x47010000, 0x5C000000, 0x86000000, 0xBB000000, 0xE6000000, 0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xF9000000, 0xE5000000, 0xB7030202, 0x35565251, 0x00797373, 0x005A5553, 0x00605C5A, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 
        0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 
        0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 
        0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 
        0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 
        0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 0x00676360, 
        0x00676361, 0x00666260, 0x005A5554, 0x004B4645, 0x0067605F, 0x184B4746, 0x46020202, 0x5A000000, 0x82000000, 0xB7000000, 0xE2000000, 0xF9000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xF8000000, 0xE3000000, 0xB2040304, 0x36514D4C, 0x00777270, 0x00585351, 0x005D5956, 0x0064605D, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 
        0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 
        0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 
        0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 
        0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 
        0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 0x0064605E, 
        0x00625F5C, 0x00565350, 0x004A4443, 0x00645F5D, 0x19474341, 0x46030202, 0x59000000, 0x80000000, 0xB4000000, 0xE0000000, 0xF8000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFE000000, 0xF6000000, 0xE2000000, 0xB2020101, 0x3B4A4645, 0x00726D6B, 0x0054504E, 0x00585553, 0x00615D5B, 0x00625E5C, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 
        0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 
        0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 
        0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 
        0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 
        0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625D5B, 0x00625E5C, 0x005F5B59, 
        0x00534E4C, 0x00484342, 0x00625C5B, 0x1B413D3C, 0x46010101, 0x5A000000, 0x7F000000, 0xB2000000, 0xDF000000, 0xF6000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF6000000, 0xE0000000, 0xB3000000, 0x41413E3D, 0x006D6865, 0x0055514F, 0x0055504E, 0x005E5A57, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 
        0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 
        0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 
        0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 
        0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 
        0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005F5B59, 0x005C5856, 0x004E4947, 
        0x004A4543, 0x00615B5A, 0x1E3A3636, 0x48000000, 0x5A000000, 0x80000000, 0xB2000000, 0xDD000000, 0xF6000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF6000000, 0xE0000000, 0xB7000000, 0x4F343130, 0x00676261, 0x0055504E, 0x00514D4B, 0x005B5755, 0x005D5957, 0x005D5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 
        0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 
        0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 
        0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 
        0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 
        0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005C5957, 0x005D5957, 0x005C5856, 0x00585452, 0x00494543, 0x00494341, 
        0x015D5856, 0x252E2B2B, 0x49000000, 0x5C000000, 0x82000000, 0xB4000000, 0xDE000000, 0xF6000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF6000000, 0xE2000000, 0xBD000000, 0x60262424, 0x05615C5B, 0x00565250, 0x004D4847, 0x00575250, 0x005B5654, 0x005B5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 
        0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 
        0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 
        0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 
        0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 
        0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005A5654, 0x005B5654, 0x005A5553, 0x00534F4D, 0x0045403E, 0x004A4643, 0x03575250, 
        0x2C221F1F, 0x4C000000, 0x5F000000, 0x86000000, 0xB7000000, 0xE0000000, 0xF7000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF8000000, 0xE3000000, 0xC2000000, 0x71191717, 0x10555150, 0x00585352, 0x00494543, 0x00524D4B, 0x00575351, 0x00585452, 0x00585351, 0x00585351, 0x00585351, 
        0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 
        0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 
        0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 
        0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 
        0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585351, 0x00585452, 0x00575250, 0x004D4947, 0x00413B3A, 0x004E4947, 0x094D4A48, 0x33161414, 
        0x4E000000, 0x64000000, 0x8C000000, 0xBC000000, 0xE3000000, 0xF8000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF9000000, 0xE6000000, 0xC8000000, 0x870C0C0C, 0x22444140, 0x00585452, 0x00484443, 0x004C4846, 0x0054504E, 0x00565250, 0x00565250, 0x00555250, 
        0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 
        0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 
        0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 
        0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 
        0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00555250, 0x00565250, 0x00565250, 0x00565250, 0x00524E4C, 0x00464240, 0x003F3B39, 0x004F4A49, 0x123E3B3A, 0x3D0A0A0A, 0x51000000, 
        0x69000000, 0x94000000, 0xC2000000, 0xE6000000, 0xF9000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFA000000, 0xEA000000, 0xCD000000, 0x9C030202, 0x3B312F2E, 0x0055514F, 0x004A4644, 0x00474341, 0x00504B49, 0x0054504D, 0x0054504E, 
        0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 
        0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 
        0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 
        0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 
        0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x0054504E, 0x00534F4D, 0x004D4947, 0x00403C3A, 0x00413C3A, 0x004E4947, 0x1F2D2B2A, 0x45020202, 0x56000000, 0x71000000, 
        0x9D000000, 0xCA000000, 0xEA000000, 0xFA000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0xEF000000, 0xD4000000, 0xAC000000, 0x5B1D1B1A, 0x0D4A4645, 0x004D4947, 0x00433E3D, 0x004A4644, 0x00504C4A, 
        0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 
        0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 
        0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 
        0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 
        0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x00514D4C, 0x004E4A49, 0x00454140, 0x003C3736, 0x0045403F, 0x0844403F, 0x2D191817, 0x4B000000, 0x5B000000, 0x7C000000, 0xA8000000, 
        0xD2000000, 0xEF000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xF3000000, 0xDC000000, 0xBA000000, 0x7D0B0A0A, 0x24363433, 0x004C4846, 0x00423E3C, 0x00433E3D, 
        0x004B4745, 0x004E4A49, 0x004F4B49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 
        0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 
        0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 
        0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 
        0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004E4A49, 0x004F4B49, 0x004F4B49, 0x004E4A48, 0x00484443, 0x003D3938, 0x003B3735, 0x0045413F, 0x1533302F, 0x3C0A0909, 0x50000000, 0x65000000, 0x88000000, 0xB4000000, 0xDB000000, 
        0xF3000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xF7000000, 0xE3000000, 0xC6000000, 0x99000000, 0x49201F1D, 0x08433F3D, 0x0045413E, 
        0x003F3A38, 0x0045403F, 0x004B4745, 0x004D4947, 0x004D4947, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 
        0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 
        0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 
        0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 
        0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4946, 0x004D4947, 0x004C4846, 0x00494543, 0x00413C3B, 0x00393432, 0x003F3A38, 0x063E3A39, 0x271E1C1C, 0x47000000, 0x56000000, 0x71000000, 0x98000000, 0xC2000000, 0xE3000000, 0xF7000000, 
        0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFA000000, 0xEC000000, 0xD1000000, 0xAF000000, 0x720B0A0A, 0x24302D2C, 
        0x00433F3E, 0x003D3937, 0x003E3937, 0x0045413F, 0x004A4644, 0x004B4745, 0x004B4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 
        0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 
        0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 
        0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 0x004A4745, 
        0x004A4745, 0x004A4745, 0x004A4745, 0x004B4745, 0x004B4745, 0x00484442, 0x00413E3C, 0x00383432, 0x00383432, 0x003F3B39, 0x162D2A29, 0x3B0A0909, 0x4F000000, 0x60000000, 0x80000000, 0xA9000000, 0xD0000000, 0xEC000000, 0xFA000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xF3000000, 0xDD000000, 0xBF000000, 0x95000000, 
        0x4F171615, 0x0F373432, 0x003F3B39, 0x003A3634, 0x003D3937, 0x0043403E, 0x00474442, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 
        0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 
        0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 
        0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 0x00484543, 
        0x00484543, 0x00484543, 0x00484543, 0x00464341, 0x00413E3C, 0x00393534, 0x0035312F, 0x003A3635, 0x0B34302F, 0x2C151414, 0x49000000, 0x57000000, 0x6F000000, 0x93000000, 0xBB000000, 0xDD000000, 0xF3000000, 0xFD000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xF8000000, 0xE9000000, 0xCE000000, 
        0xAD000000, 0x7C050505, 0x37201E1D, 0x05373432, 0x003A3634, 0x00373432, 0x003B3836, 0x00423F3D, 0x00454240, 0x00464341, 0x00464341, 0x00464241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 
        0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 
        0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 
        0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00454241, 0x00464341, 0x00464341, 
        0x00464341, 0x0044413F, 0x00403C3B, 0x00383433, 0x00332F2D, 0x00363131, 0x04353130, 0x211E1C1C, 0x40040404, 0x51000000, 0x63000000, 0x82000000, 0xA8000000, 0xCD000000, 0xE9000000, 0xF8000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0xF2000000, 
        0xDE000000, 0xC0000000, 0x9E000000, 0x68090909, 0x26242221, 0x00353230, 0x00363331, 0x00353130, 0x003A3635, 0x00403C3B, 0x00433F3E, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 
        0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 
        0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 
        0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x0044403F, 0x00423E3D, 
        0x003E3939, 0x00373232, 0x00322D2C, 0x00332F2E, 0x0232302E, 0x1922211F, 0x3A090908, 0x4E000000, 0x5C000000, 0x75000000, 0x99000000, 0xBE000000, 0xDE000000, 0xF2000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xF9000000, 0xEB000000, 0xD3000000, 0xB6000000, 0x92000000, 0x5D0B0B0B, 0x2222201F, 0x00312E2D, 0x00332F2E, 0x00332F2D, 0x00383432, 0x003D3937, 0x00403C3B, 0x00423E3C, 0x00423E3C, 0x00423E3C, 0x00423E3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 
        0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 
        0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 
        0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423D3C, 0x00423E3C, 0x00423E3C, 0x00423E3C, 0x00423E3C, 0x00413D3C, 0x00403C3A, 0x003B3735, 0x0034302F, 
        0x00302B2B, 0x00302C2B, 0x00302D2B, 0x17211F1E, 0x360B0A0A, 0x4B000000, 0x59000000, 0x6E000000, 0x8F000000, 0xB2000000, 0xD3000000, 0xEB000000, 0xF9000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFD000000, 0xF5000000, 0xE5000000, 0xCC000000, 0xAE000000, 0x8B000000, 0x590B0B0A, 0x22201E1C, 0x012D2A29, 0x00302D2B, 0x00312C2B, 0x0034302E, 0x00393534, 0x003D3937, 0x003F3B39, 0x00403C3A, 0x00403C3A, 0x00403C3A, 0x00403C39, 
        0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 
        0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 
        0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C39, 0x00403C3A, 0x00403C3A, 0x00403C3A, 0x003F3B39, 0x003C3836, 0x00373331, 0x00312D2B, 0x002E2928, 0x002E2A29, 
        0x022C2928, 0x171F1D1C, 0x350B0A0A, 0x4B000000, 0x58000000, 0x6B000000, 0x88000000, 0xAA000000, 0xCB000000, 0xE5000000, 0xF5000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0xF3000000, 0xE0000000, 0xC6000000, 0xAA000000, 0x89000000, 0x5D080707, 0x2B191716, 0x07272624, 0x002D2A28, 0x002E2A29, 0x00302C2B, 0x0035312F, 0x00393533, 0x003C3836, 0x003D3937, 0x003E3A38, 
        0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 
        0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 
        0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003E3A38, 0x003D3937, 0x003B3735, 0x00383431, 0x00322E2D, 0x002E2A28, 0x002C2826, 0x002C2826, 0x06262422, 0x1D181716, 
        0x39080707, 0x4C000000, 0x59000000, 0x6B000000, 0x86000000, 0xA7000000, 0xC6000000, 0xE0000000, 0xF3000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFB000000, 0xF0000000, 0xDE000000, 0xC5000000, 0xA9000000, 0x8C000000, 0x66040404, 0x38121110, 0x13201E1D, 0x00282523, 0x002B2825, 0x002C2827, 0x00302C2A, 0x0034302E, 0x00373431, 
        0x003A3634, 0x003B3735, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 
        0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 
        0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3836, 0x003B3735, 0x00393533, 0x00363330, 0x00322E2C, 0x002D2928, 0x002A2625, 0x00292624, 0x00272423, 0x0F201D1C, 0x26121110, 0x3E040404, 0x4F000000, 
        0x5B000000, 0x6E000000, 0x88000000, 0xA7000000, 0xC5000000, 0xDE000000, 0xF0000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFA000000, 0xF0000000, 0xDF000000, 0xC8000000, 0xAD000000, 0x94000000, 0x73000000, 0x4D0A0909, 0x25161614, 0x08211F1D, 0x00262422, 0x00292524, 0x002A2725, 
        0x002D2A28, 0x00302D2B, 0x0034312F, 0x00363331, 0x00383533, 0x00383533, 0x00393634, 0x00393634, 0x00393634, 0x00393634, 0x00393634, 0x00383634, 0x00383634, 0x00383634, 0x00383634, 0x00383634, 0x00383634, 0x00383634, 0x00383634, 0x00383634, 
        0x00383634, 0x00383634, 0x00383634, 0x00383634, 0x00383634, 0x00383634, 0x00383634, 0x00383634, 0x00383634, 0x00383634, 0x00383634, 0x00383634, 0x00383634, 0x00383634, 0x00383634, 0x00383634, 0x00383634, 0x00383634, 0x00383634, 0x00393634, 
        0x00393634, 0x00393634, 0x00393634, 0x00393634, 0x00383533, 0x00373432, 0x00353230, 0x00332F2E, 0x002F2C2A, 0x002B2826, 0x00282523, 0x00272422, 0x00252221, 0x07211E1D, 0x1A161514, 0x34090909, 0x47000000, 0x55000000, 0x61000000, 0x74000000, 
        0x8F000000, 0xAB000000, 0xC7000000, 0xDF000000, 0xF0000000, 0xFA000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFB000000, 0xF2000000, 0xE2000000, 0xCD000000, 0xB4000000, 0x9C000000, 0x83000000, 0x64020202, 0x410C0B0A, 0x21151413, 0x071F1D1B, 
        0x0024211F, 0x00262321, 0x00272422, 0x002A2725, 0x002D2928, 0x00302C2A, 0x00322F2D, 0x0034312F, 0x00353230, 0x00363331, 0x00363331, 0x00373432, 0x00373432, 0x00373432, 0x00373432, 0x00373432, 0x00373432, 0x00373432, 0x00373432, 0x00373431, 
        0x00373431, 0x00373431, 0x00373431, 0x00373431, 0x00373431, 0x00373431, 0x00373431, 0x00373431, 0x00373431, 0x00373431, 0x00373432, 0x00373432, 0x00373432, 0x00373432, 0x00373432, 0x00373432, 0x00373432, 0x00373432, 0x00373432, 0x00363331, 
        0x00363331, 0x00353230, 0x0033302E, 0x00312E2C, 0x002E2B29, 0x002B2826, 0x00282523, 0x00262321, 0x00252220, 0x0022201E, 0x071E1C1B, 0x19161413, 0x2F0B0B0A, 0x42020202, 0x50000000, 0x5B000000, 0x6A000000, 0x7F000000, 0x99000000, 0xB3000000, 
        0xCD000000, 0xE2000000, 0xF1000000, 0xFB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFB000000, 0xF4000000, 0xE8000000, 0xD6000000, 0xC0000000, 0xA9000000, 0x92000000, 0x7B000000, 0x61020202, 
        0x420A0A09, 0x25121110, 0x0E1A1817, 0x011F1D1B, 0x0022201E, 0x0024211F, 0x00252221, 0x00272423, 0x002A2725, 0x002C2928, 0x002E2A29, 0x00302D2B, 0x00312E2D, 0x00322F2E, 0x0033302F, 0x0034312F, 0x0034312F, 0x00343130, 0x00343130, 0x00353230, 
        0x00353230, 0x00353230, 0x00353230, 0x00353230, 0x00353230, 0x00353230, 0x00353230, 0x00353230, 0x00353230, 0x00353230, 0x00353230, 0x00343130, 0x00343130, 0x0034312F, 0x0034312F, 0x0033302F, 0x00322F2D, 0x00312E2C, 0x002F2C2B, 0x002D2929, 
        0x002B2827, 0x00282524, 0x00262322, 0x00242120, 0x0023201E, 0x00211F1C, 0x011F1D1B, 0x0C1A1817, 0x1C121110, 0x300A0909, 0x42020202, 0x50000000, 0x5B000000, 0x67000000, 0x78000000, 0x8E000000, 0xA7000000, 0xC0000000, 0xD6000000, 0xE8000000, 
        0xF4000000, 0xFB000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xF8000000, 0xEF000000, 0xE1000000, 0xCE000000, 0xBA000000, 0xA4000000, 
        0x91000000, 0x7C000000, 0x66010101, 0x4F050504, 0x370C0B0A, 0x2211100E, 0x10181614, 0x031C1A18, 0x001E1C1B, 0x00211E1C, 0x0023201E, 0x0024211F, 0x00252120, 0x00262322, 0x00282423, 0x00292625, 0x002B2726, 0x002B2827, 0x002C2928, 0x002D2A29, 
        0x002E2A29, 0x002F2B2A, 0x002F2B2A, 0x002F2C2B, 0x002F2C2B, 0x002F2C2B, 0x002F2B2A, 0x002F2B2A, 0x002E2B2A, 0x002E2A29, 0x002D2928, 0x002C2928, 0x002B2827, 0x002A2625, 0x00292524, 0x00272423, 0x00262221, 0x00252120, 0x0023201F, 0x00211F1D, 
        0x00201D1C, 0x001E1C19, 0x031C1A18, 0x0E171614, 0x1C11100F, 0x2B0C0B0A, 0x3B050504, 0x49010101, 0x54000000, 0x5D000000, 0x68000000, 0x79000000, 0x8D000000, 0xA3000000, 0xB9000000, 0xCF000000, 0xE1000000, 0xEF000000, 0xF8000000, 0xFD000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0xF5000000, 0xEC000000, 0xDF000000, 
        0xCE000000, 0xBB000000, 0xA7000000, 0x94000000, 0x85000000, 0x75000000, 0x64000000, 0x53030302, 0x3F080707, 0x2F0C0A0A, 0x21100E0D, 0x13151312, 0x08191615, 0x021B1817, 0x001C1918, 0x001D1A19, 0x001F1C1B, 0x00211D1C, 0x00211E1C, 0x00211E1C, 
        0x00221E1D, 0x00221E1D, 0x00221F1E, 0x00231F1E, 0x00231F1E, 0x00231F1E, 0x00231F1E, 0x00221F1E, 0x00221E1D, 0x00221E1D, 0x00211E1C, 0x00201D1C, 0x00211D1C, 0x001F1C1B, 0x001D1A19, 0x001C1918, 0x021A1816, 0x07191614, 0x11151311, 0x1C100E0D, 
        0x270B0B0A, 0x33080706, 0x41030302, 0x4B000000, 0x55000000, 0x5E000000, 0x66000000, 0x72000000, 0x81000000, 0x92000000, 0xA7000000, 0xBA000000, 0xCE000000, 0xDF000000, 0xEC000000, 0xF5000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 
        0xF6000000, 0xED000000, 0xE1000000, 0xD3000000, 0xC3000000, 0xB3000000, 0xA3000000, 0x94000000, 0x87000000, 0x7B000000, 0x6F000000, 0x62000000, 0x58010101, 0x4D030202, 0x40060505, 0x35090807, 0x2D0B0A09, 0x260D0C0B, 0x200E0D0C, 0x1A100F0E, 
        0x1512100F, 0x1512110F, 0x0F141211, 0x0F141211, 0x0F141211, 0x0F141211, 0x0F141211, 0x0F141211, 0x1412110F, 0x1512100F, 0x19100F0E, 0x1E0E0D0C, 0x230D0C0B, 0x290B0A09, 0x30090807, 0x38060505, 0x42030202, 0x49010101, 0x4F000000, 0x57000000, 
        0x5F000000, 0x65000000, 0x6D000000, 0x77000000, 0x84000000, 0x93000000, 0xA3000000, 0xB3000000, 0xC4000000, 0xD3000000, 0xE1000000, 0xEC000000, 0xF5000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFC000000, 0xF8000000, 0xF1000000, 0xE9000000, 0xDF000000, 0xD4000000, 0xC7000000, 0xB9000000, 0xAD000000, 0xA2000000, 0x95000000, 0x8B000000, 0x81000000, 0x7A000000, 0x73000000, 0x6E000000, 0x68000000, 0x62000000, 
        0x5E000000, 0x5B000000, 0x58000000, 0x56000000, 0x55000000, 0x54000000, 0x54000000, 0x54000000, 0x56000000, 0x58000000, 0x5B000000, 0x5E000000, 0x62000000, 0x64000000, 0x68000000, 0x6C000000, 0x71000000, 0x78000000, 0x80000000, 0x89000000, 
        0x94000000, 0xA1000000, 0xAD000000, 0xB9000000, 0xC7000000, 0xD4000000, 0xDF000000, 0xE9000000, 0xF1000000, 0xF8000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFC000000, 0xF8000000, 0xF3000000, 0xED000000, 0xE6000000, 0xDE000000, 0xD5000000, 0xCC000000, 0xC4000000, 0xBB000000, 0xB2000000, 0xAB000000, 0xA4000000, 0x9E000000, 
        0x9A000000, 0x95000000, 0x91000000, 0x8F000000, 0x8C000000, 0x8B000000, 0x8B000000, 0x8B000000, 0x8C000000, 0x8E000000, 0x91000000, 0x95000000, 0x99000000, 0x9E000000, 0xA4000000, 0xAB000000, 0xB2000000, 0xBB000000, 0xC4000000, 0xCC000000, 
        0xD5000000, 0xDE000000, 0xE6000000, 0xED000000, 0xF3000000, 0xF8000000, 0xFC000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFB000000, 0xF9000000, 0xF5000000, 0xF1000000, 0xED000000, 0xE9000000, 0xE5000000, 0xE1000000, 0xDD000000, 
        0xD9000000, 0xD6000000, 0xD2000000, 0xD0000000, 0xCE000000, 0xCD000000, 0xCD000000, 0xCD000000, 0xCE000000, 0xD0000000, 0xD2000000, 0xD6000000, 0xD9000000, 0xDD000000, 0xE1000000, 0xE5000000, 0xE9000000, 0xED000000, 0xF1000000, 0xF5000000, 
        0xF9000000, 0xFB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 
        0xFA000000, 0xF9000000, 0xF8000000, 0xF7000000, 0xF7000000, 0xF7000000, 0xF7000000, 0xF7000000, 0xF7000000, 0xF7000000, 0xF8000000, 0xF9000000, 0xFA000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000
#endif
};

GUI_CONST_STORAGE GUI_BITMAP bmKNOB_175x175 = {
  175, // xSize
  175, // ySize
  700, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acKNOB_175x175,  // Pointer to picture data
  NULL,  // Pointer to palette
#if GUI_USE_ARGB
  GUI_DRAW_BMPM8888I
#else
  GUI_DRAW_BMP8888
#endif
};

/*************************** End of file ****************************/
