/*********************************************************************
*                SEGGER Microcontroller GmbH                         *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2018  SEGGER Microcontroller GmbH                *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.48 - Graphical user interface for embedded applications **
All  Intellectual Property rights  in the Software belongs to  SEGGER.
emWin is protected by  international copyright laws.  Knowledge of the
source code may not be used to write a similar product.  This file may
only be used in accordance with the following terms:

The software  has been licensed to  Cypress Semiconductor Corporation,
whose registered  office is situated  at 198 Champion Ct. San Jose, CA 
95134 USA  solely for the  purposes of creating  libraries for Cypress
PSoC3 and  PSoC5 processor-based devices,  sublicensed and distributed
under  the  terms  and  conditions  of  the  Cypress  End User License
Agreement.
Full source code is available at: www.segger.com

We appreciate your understanding and fairness.
----------------------------------------------------------------------
Licensing information
Licensor:                 SEGGER Microcontroller Systems LLC
Licensed to:              Cypress Semiconductor Corp, 198 Champion Ct., San Jose, CA 95134, USA
Licensed SEGGER software: emWin
License number:           GUI-00319
License model:            Services and License Agreement, signed June 10th, 2009
Licensed platform:        Any Cypress platform (Initial targets are: PSoC3, PSoC5)
----------------------------------------------------------------------
Support and Update Agreement (SUA)
SUA period:               2009-06-12 - 2022-07-27
Contact to extend SUA:    sales@segger.com
----------------------------------------------------------------------
File        : MULTILAYER_AlphaChromaMove.c
Purpose     : Multi layer sample
Requirements: WindowManager - (x)
              MemoryDevices - ( )
              AntiAliasing  - ( )
              VNC-Server    - ( )
              PNG-Library   - ( )
              TrueTypeFonts - ( )
---------------------------END-OF-HEADER------------------------------
*/

#include "GUI.h"
#include "DIALOG.h"
#include "LCD_SIM.h"

#ifdef WIN32
  #include "SIM.h"
#endif

//
// Recommended memory to run the sample with adequate performance
//
#define RECOMMENDED_MEMORY (1024L * 20)

/*********************************************************************
*
*       Types
*
**********************************************************************
*/
typedef struct {
  int LayerIndex;
  int xMin;
  int yMin;
  int xMax;
  int yMax;
  int xPos;
  int yPos;
  int xAdd;
  int yAdd;
  int Alpha;
  int AlphaAdd;
} ANIMATION_CONTEXT;

/*********************************************************************
*
*       Static data
*
**********************************************************************
*/
/*********************************************************************
*
*       _bmToucan
*
* Function description
*   Toucan with alpha channel
*/
static GUI_CONST_STORAGE unsigned long _acToucan[] = {
#if (GUI_USE_ARGB == 1)
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0xD2787244, 0xCB4A3822, 0xFF7D626D, 0xFF705957, 0xFF62404A, 0xFF62404A, 0xFF5F3B38, 0xFF5F3B38, 0xFF5F3B38, 0xFF4C1527, 0xFF55322E, 0xFF55322E, 0xFF5F3B38, 0xFF62404A, 0xFF7D626D, 0xCB4A3822, 0x74404022, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x74404022, 0xFF62404A, 0xFF62404A, 0xFF62404A, 0xFF55322E, 
        0xFF62404A, 0xFF705957, 0xFF705957, 0xFF705957, 0xFF705957, 0xFF62404A, 0xFF62404A, 0xFF62404A, 0xFF62404A, 0xFF62404A, 0xFF62404A, 0xFF62404A, 0xFF5F3B38, 0xFF55322E, 0xFF55322E, 0xFF482222, 0xFF3D0022, 0xFF3B001C, 0xFF48002B, 0xFF5F3B38, 
        0xE4553B2B, 0xCB4A3822, 0x74404022, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x74404022, 0xCB4A3822, 0xFF62404A, 0xFF55322E, 0xFF635248, 0xFF837278, 0xFF837278, 0xFF837278, 0xFF7D626D, 
        0xFF705957, 0xFF635248, 0xFF7D626D, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF837278, 0xFF837278, 0xFF837278, 0xFF7D626D, 0xFF705957, 0xFF705957, 0xFF62404A, 0xFF62404A, 0xFF55322E, 0xFF4C1527, 0xFF48002B, 
        0xFF400022, 0xFF3B001C, 0xFF3B001C, 0xFF55322E, 0xCB4A3822, 0x74404022, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xD2787244, 0xCB4A3822, 0xFF705957, 0xFF705957, 0xFF7D626D, 0xFF7D626D, 0xFF837278, 0xFF7D626D, 0xFF705957, 0xFF7D626D, 0xFF908494, 0xFFACA7B6, 
        0xFFACA7B6, 0xFFACA7B6, 0xFFACA7B6, 0xFFACA7B6, 0xFF908494, 0xFF837278, 0xFF7D626D, 0xFF7D626D, 0xFF7D626D, 0xFF705957, 0xFF62404A, 0xFF62404A, 0xFF62404A, 0xFF62404A, 0xFF5F3B38, 0xFF55322E, 0xFF4C1527, 0xFF4C1527, 0xFF4C1527, 0xFF48002B, 
        0xFF46001C, 0xFF420022, 0xFF3D001C, 0xFF2E0015, 0xFF35001C, 0xFF48002B, 0xE4553B2B, 0x74404022, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x74404022, 0xD2787244, 0xFF705957, 0xFF62404A, 0xFF7D626D, 0xFF837278, 0xFF837278, 0xFF837278, 0xFF635248, 0xFF908494, 0xFFACA7B6, 0xFFACA7B6, 0xFFACA7B6, 0xFFACA7B6, 0xFF908494, 
        0xFF837278, 0xFF837278, 0xFF837278, 0xFF837278, 0xFF837278, 0xFF837278, 0xFF837278, 0xFF837278, 0xFF837278, 0xFF7D626D, 0xFF837278, 0xFF7D626D, 0xFF705957, 0xFF705957, 0xFF635248, 0xFF5F3B38, 0xFF55322E, 0xFF48002B, 0xFF48002B, 0xFF48002B, 
        0xFF420022, 0xFF420022, 0xFF420022, 0xFF38001C, 0xFF3B001C, 0xFF35001C, 0xFF35001C, 0xFF55322E, 0xFF7D626D, 0x74404022, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x6F150000, 0xFF837278, 0xFF837278, 0xFF55322E, 0xFF705957, 0xFFACA7B6, 0xFF837278, 0xFF705957, 0xFFACA7B6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFF908494, 0xFF7D626D, 0xFF7D626D, 0xFF7D626D, 0xFF7D626D, 
        0xFF837278, 0xFF908494, 0xFF908494, 0xFF908494, 0xFFACA7B6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFACA7B6, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF837278, 0xFF705957, 0xFF635248, 0xFF62404A, 0xFF55322E, 0xFF4C1527, 0xFF48002B, 
        0xFF420022, 0xFF420022, 0xFF420022, 0xFF3D0022, 0xFF38001C, 0xFF350015, 0xFF35001C, 0xFF35001C, 0xFF3B001C, 0xFF83573D, 0x74404022, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0xD2787244, 0xFF705957, 0xFF5F3B38, 0xFF4C1527, 0xFF908494, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFACA7B6, 0xFFACA7B6, 0xFF908494, 0xFF7D626D, 0xFF705957, 0xFF62404A, 0xFF705957, 0xFF705957, 0xFF7D626D, 0xFF837278, 0xFF908494, 
        0xFFACA7B6, 0xFFACA7B6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFACA7B6, 0xFF908494, 0xFF908494, 0xFF837278, 0xFF837278, 0xFF7D626D, 0xFF705957, 0xFF62404A, 0xFF55322E, 0xFF4C1527, 0xFF48002B, 0xFF46001C, 
        0xFF420022, 0xFF3D001C, 0xFF38001C, 0xFF3B001C, 0xFF35001C, 0xFF35001C, 0xFF2E0015, 0xFF35001C, 0xFF35001C, 0xFF38001C, 0xFF83573D, 0x74404022, 0x02000000, 0x02000000, 0x01000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6F150000, 
        0xC8351500, 0xFF908494, 0xFF55322E, 0xFF482222, 0xFF4C1527, 0xFF5F3B38, 0xFF62404A, 0xFF705957, 0xFF635248, 0xFF55322E, 0xFF5F3B38, 0xFF62404A, 0xFF635248, 0xFF705957, 0xFF705957, 0xFF7D626D, 0xFF908494, 0xFF908494, 0xFF908494, 0xFFACA7B6, 
        0xFFACA7B6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFACA7B6, 0xFF908494, 0xFF908494, 0xFF837278, 0xFF7D626D, 0xFF7D626D, 0xFF7D626D, 0xFF62404A, 0xFF55322E, 0xFF4C1527, 0xFF48002B, 0xFF4C1527, 0xFF400022, 0xFF420022, 
        0xFF420022, 0xFF420022, 0xFF3B001C, 0xFF2E0015, 0xFF35001C, 0xFF35001C, 0xFF35001C, 0xFF2E0015, 0xFF350015, 0xFF35001C, 0xFF3B001C, 0xFF902E27, 0x74404022, 0x05000000, 0x04000000, 0x03000000, 0x02000000, 0x02000000, 0x01000000, 0x01000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xCB4A3822, 0xFF62404A, 0xFF4C1527, 0xFF420022, 
        0xFF55322E, 0xFF574027, 0xFF4C1527, 0xFF4C1527, 0xFF55322E, 0xFF5F3B38, 0xFF4C1527, 0xFF55322E, 0xFF5F3B38, 0xFF5F3B38, 0xFF635248, 0xFF635248, 0xFF705957, 0xFF7D626D, 0xFF837278, 0xFF908494, 0xFF908494, 0xFF908494, 0xFFACA7B6, 0xFFACA7B6, 
        0xFFACA7B6, 0xFFC2BEC6, 0xFFC2BEC6, 0xFFACA7B6, 0xFFACA7B6, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF837278, 0xFF7D626D, 0xFF7D626D, 0xFF705957, 0xFF635248, 0xFF62404A, 0xFF5F3B38, 0xFF55322E, 0xFF48002B, 0xFF48002B, 0xFF3D001C, 0xFF3B001C, 
        0xFF38001C, 0xFF38001C, 0xFF35001C, 0xFF35001C, 0xFF35001C, 0xFF350022, 0xFF35001C, 0xFF35001C, 0xFF2E0015, 0xFF350015, 0xFF38001C, 0xFF400022, 0xFFACA7B6, 0x0A000000, 0x09000000, 0x07000000, 0x06000000, 0x04000000, 0x03000000, 0x02000000, 
        0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xC8351500, 0xEA3D1515, 0xFF48002B, 0xFF400022, 0xFF400022, 0xFF4C1527, 0xFF3D0022, 
        0xFFA37622, 0xFFAD8722, 0xFF6F5A22, 0xFF5F3B38, 0xFF635248, 0xFF635248, 0xFF5F3B38, 0xFF5F3B38, 0xFF5F3B38, 0xFF62404A, 0xFF705957, 0xFF705957, 0xFF837278, 0xFF837278, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF908494, 0xFFACA7B6, 0xFFACA7B6, 
        0xFFACA7B6, 0xFFACA7B6, 0xFFACA7B6, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF837278, 0xFF837278, 0xFF7D626D, 0xFF7D626D, 0xFF62404A, 0xFF62404A, 0xFF5F3B38, 0xFF48002B, 0xFF400022, 0xFF3D0022, 0xFF3B001C, 0xFF3B001C, 0xC8351500, 0xC8351500, 
        0xC8351500, 0xC8351500, 0xC8351500, 0xC8351500, 0xC8351500, 0xC8351500, 0xC8351500, 0xC8351500, 0xC8351500, 0xC8351500, 0xC8351500, 0xEA3D1515, 0xFF66001C, 0x12000000, 0x10000000, 0x0E000000, 0x0B000000, 0x09000000, 0x07000000, 0x06000000, 
        0x04000000, 0x03000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xC8351500, 0xEA3D1515, 0xFF3D001C, 0xFF3D001C, 0xFF3B001C, 0xFF38001C, 0xFF3D001C, 0xFF4C1527, 0xFF46001C, 
        0xFFC87E1C, 0xFFFCD21C, 0xFFD8BE46, 0xFF7F7B42, 0xFF705957, 0xFF635248, 0xFF5F3B38, 0xFF5F3B38, 0xFF5F3B38, 0xFF635248, 0xFF705957, 0xFF705957, 0xFF7D626D, 0xFF837278, 0xFF837278, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF908494, 
        0xFF908494, 0xFF908494, 0xFFACA7B6, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF7D626D, 0xFF705957, 0xFF62404A, 0xFF5F3B38, 0xFF48002B, 0xFF48002B, 0xFE503227, 0xC8351500, 0xC8351500, 0xC8351500, 0xC8351500, 0x8B150000, 0x34000000, 0x34000000, 
        0x34000000, 0x34000000, 0x34000000, 0x34000000, 0x34000000, 0x33000000, 0x31000000, 0x2F000000, 0x2C000000, 0x2C000000, 0x27000000, 0x25000000, 0xC8351500, 0x1D000000, 0x1B000000, 0x17000000, 0x14000000, 0x11000000, 0x0E000000, 0x0B000000, 
        0x08000000, 0x06000000, 0x04000000, 0x03000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6F150000, 0xEA3D1515, 0xFF3B001C, 0xFF38001C, 0xFF3D001C, 0xFF38001C, 0xFF38001C, 0xFF35001C, 0xFF3D001C, 0xFF55322E, 0xFF55322E, 
        0xFFC87E1C, 0xFFFBE01C, 0xFFFAE632, 0xFFD8BE46, 0xFF87994C, 0xFF705957, 0xFF705957, 0xFF705957, 0xFF705957, 0xFF635248, 0xFF705957, 0xFF705957, 0xFF7D626D, 0xFF7D626D, 0xFF837278, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF908494, 0xFF908494, 
        0xFFACA7B6, 0xFFACA7B6, 0xFF908494, 0xFF7D626D, 0xFF62404A, 0xFF482222, 0xFF4C1527, 0xEA3D1515, 0xC8351500, 0x32000000, 0x34000000, 0x39000000, 0x3C000000, 0x3F000000, 0x42000000, 0x44000000, 0x44000000, 0x46000000, 0x48000000, 0x48000000, 
        0x49000000, 0x49000000, 0x49000000, 0x48000000, 0x46000000, 0x46000000, 0x44000000, 0x44000000, 0x3F000000, 0x3C000000, 0x39000000, 0x36000000, 0x32000000, 0x2F000000, 0x29000000, 0x25000000, 0x20000000, 0x1B000000, 0x17000000, 0x13000000, 
        0x0F000000, 0x0B000000, 0x08000000, 0x05000000, 0x03000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6F150000, 0xFF420022, 0xFF3D001C, 0xFF38001C, 0xFF3D001C, 0xFF66001C, 0xFE8D1C22, 0xFF66001C, 0xFF4C1527, 0xFF3D001C, 0xFF400022, 0xFF705957, 
        0xFFC87E1C, 0xFFFCE422, 0xFFFCED40, 0xFFF5F07A, 0xFFD4ED6D, 0xFFACA7B6, 0xFF908494, 0xFF837278, 0xFF7D626D, 0xFF7D626D, 0xFF705957, 0xFF705957, 0xFF705957, 0xFF7D626D, 0xFF7D626D, 0xFF908494, 0xFF908494, 0xFF908494, 0xFFACA7B6, 0xFF908494, 
        0xFF837278, 0xFF5F3B38, 0xFF482222, 0xFF482222, 0xC8351500, 0x34000000, 0x39000000, 0x3C000000, 0x42000000, 0x44000000, 0x49000000, 0x4E000000, 0x50150000, 0x54000000, 0x54000000, 0x58000000, 0x5B000000, 0x5B000000, 0x5D150000, 0x5D150000, 
        0x5E000000, 0x5E000000, 0x5E000000, 0x5D150000, 0x5B000000, 0x5B000000, 0x5B000000, 0x58000000, 0x54000000, 0x51000000, 0x4E000000, 0x49000000, 0x44000000, 0x3F000000, 0x3B000000, 0x34000000, 0x31000000, 0x2A000000, 0x24000000, 0x1D000000, 
        0x18000000, 0x13000000, 0x0E000000, 0x0A000000, 0x07000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x6B151C00, 0xFF400022, 0xFF3D001C, 0xFF3B001C, 0xFF46001C, 0xFF992B22, 0xFFC87E1C, 0xFFC87E1C, 0xFFC87E1C, 0xFF992B22, 0xFE8D1C22, 0xFF66001C, 0xFF705957, 
        0xFFC87E1C, 0xFFFFE922, 0xFFFCED40, 0xFFF5F07A, 0xFFF5F07A, 0xFFC2BEC6, 0xFFACA7B6, 0xFFC2BEC6, 0xFF7D626D, 0xFF635248, 0xFF62404A, 0xFF62404A, 0xFF62404A, 0xFF705957, 0xFF7D626D, 0xFF908494, 0xFFACA7B6, 0xFF908494, 0xFF705957, 0xFF55322E, 
        0xEA3D1515, 0x8B150000, 0x37000000, 0x3C000000, 0x42000000, 0x46000000, 0x4C150000, 0x51000000, 0x54000000, 0x5B000000, 0x5E000000, 0x61150000, 0x65150000, 0x67000000, 0x6A000000, 0x6E000000, 0x6E000000, 0x71000000, 0x71000000, 0x71000000, 
        0x71000000, 0x71000000, 0x71000000, 0x71000000, 0x71000000, 0x6F150000, 0x6E000000, 0x6B151500, 0x6A000000, 0x67000000, 0x63000000, 0x5E000000, 0x58150000, 0x54000000, 0x4E000000, 0x48000000, 0x42000000, 0x3B000000, 0x33000000, 0x2C000000, 
        0x24000000, 0x1D000000, 0x16000000, 0x10000000, 0x0B000000, 0x07000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x74404022, 0xFF482222, 0xFF3D001C, 0xFF35001C, 0xFF3B001C, 0xFF992B22, 0xFFC87E1C, 0xFF992B22, 0xFF7A382B, 0xFF902E27, 0xFF992B22, 0xFF992B22, 0xFF8D2E22, 0xFF837278, 
        0xFFAD8722, 0xFFFFEB32, 0xFFF5F07A, 0xFFF5F07A, 0xFFF5F07A, 0xFCBEC678, 0xFFC2BEC6, 0xFF908494, 0xFF7D626D, 0xFF5F3B38, 0xFF55322E, 0xFF55322E, 0xFF5F3B38, 0xFF62404A, 0xFF705957, 0xFF62404A, 0xFF4C1527, 0xEA3D1515, 0xCB4A3822, 0x37000000, 
        0x3E000000, 0x44000000, 0x4A000000, 0x50150000, 0x58150000, 0x5B000000, 0x61150000, 0x67000000, 0x6A000000, 0x6E000000, 0x71000000, 0x74000000, 0x77000000, 0x7A000000, 0x7C000000, 0x7F000000, 0x7F000000, 0x82000000, 0x82000000, 0x82000000, 
        0x82000000, 0x82000000, 0x82000000, 0x82000000, 0x82000000, 0x82000000, 0x7F000000, 0x7C000000, 0x7C000000, 0x77000000, 0x74000000, 0x71000000, 0x6B151500, 0x67000000, 0x61150000, 0x5B150000, 0x54150000, 0x4C150000, 0x44000000, 0x3B000000, 
        0x32000000, 0x27000000, 0x20000000, 0x18000000, 0x11000000, 0x0B000000, 0x07000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xFF4C1527, 0xFF3D001C, 0xFF380015, 0xFF350015, 0xFF4C1527, 0xFFC87E1C, 0xFFC87E1C, 0xFF66001C, 0xFF705957, 0xFF7D626D, 0xFF992B22, 0xFFC87E1C, 0xFF992B22, 0xFF66001C, 
        0xFF83573D, 0xFFF0C52B, 0xFFF5F07A, 0xFFF5F07A, 0xFFF5F07A, 0xFFD8BE46, 0xFF837278, 0xFF635248, 0xFF62404A, 0xFF4C1527, 0xFF4C1527, 0xFF4C1527, 0xFF4C1527, 0xFF4C1527, 0xEA3D1515, 0xC8351500, 0x34000000, 0x3B000000, 0x44000000, 0x4A000000, 
        0x51000000, 0x58150000, 0x5D150000, 0x65150000, 0x6A000000, 0x6F150000, 0x74000000, 0x77000000, 0x7C000000, 0x7F000000, 0x82000000, 0x85150000, 0x86000000, 0x8A000000, 0x8C000000, 0x8C000000, 0x8F000000, 0x8F000000, 0x8F000000, 0x8F000000, 
        0x8F000000, 0x8F000000, 0x8F000000, 0x8F000000, 0x8F000000, 0x8F000000, 0x8C000000, 0x8B150000, 0x86000000, 0x86000000, 0x82000000, 0x7F000000, 0x7C000000, 0x77150000, 0x71000000, 0x6B151500, 0x65150000, 0x5D150000, 0x54150000, 0x4A000000, 
        0x3F000000, 0x34000000, 0x2C000000, 0x21000000, 0x18000000, 0x10000000, 0x0A000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xCB4A3822, 0xFF420022, 0xFF35001C, 0xFF350015, 0xFF2E0015, 0xFF66001C, 0xFFC87E1C, 0xFF992B22, 0xFF5A001C, 0xFF705957, 0xFF7D626D, 0xFF8D2E22, 0xFFC87E1C, 0xFF992B22, 0xFF5A001C, 
        0xFF5F3B38, 0xFFD8BE46, 0xFFFCD21C, 0xFFF0C52B, 0xFFFACC1C, 0xFFF0C52B, 0xFF8E8140, 0xFF5F3B38, 0xFF48002B, 0xFF48002B, 0xFF48002B, 0xFF46001C, 0xEA3D1515, 0x8B150000, 0x34000000, 0x3C000000, 0x46000000, 0x4E000000, 0x58150000, 0x5D150000, 
        0x65150000, 0x6B151500, 0x71000000, 0x77000000, 0x7C000000, 0x80151500, 0x85150000, 0x86000000, 0x8B150000, 0x8F000000, 0x8F000000, 0x93000000, 0x93000000, 0x95000000, 0x96000000, 0x98000000, 0x98000000, 0x99000000, 0x99000000, 0x99000000, 
        0x99000000, 0x98000000, 0x98000000, 0x96000000, 0x96000000, 0x96000000, 0x93000000, 0x93000000, 0x91000000, 0x8F000000, 0x8C000000, 0x8A000000, 0x85150000, 0x82000000, 0x7E150000, 0x77150000, 0x71000000, 0x6B151500, 0x61150000, 0x58150000, 
        0x4E000000, 0x42000000, 0x36000000, 0x2A000000, 0x1F000000, 0x16000000, 0x0E000000, 0x09000000, 0x05000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xEA3D1515, 0xFF38001C, 0xFF2E0015, 0xFF2E0015, 0xFF350015, 0xFF66001C, 0xFFC87E1C, 0xFFC87E1C, 0xFF992B22, 0xFF66001C, 0xFF663D22, 0xFF992B22, 0xFFC87E1C, 0xFFC87E1C, 0xFF7A382B, 
        0xFF55322E, 0xFFD8BE46, 0xFFF8C11C, 0xFFF8C11C, 0xFFF8C11C, 0xFFFACC1C, 0xFFD8BE46, 0xFF727E3B, 0xFF705957, 0xFF55322E, 0xFF48002B, 0xEA3D1515, 0x8B150000, 0x3F000000, 0x46000000, 0x50150000, 0x58150000, 0x61150000, 0x6A150000, 0x71000000, 
        0xE4553B2B, 0xE4553B2B, 0xE4553B2B, 0xE4553B2B, 0xE4553B2B, 0xE4553B2B, 0xE4553B2B, 0xE6502222, 0xE6502222, 0xE4553B2B, 0xE4553B2B, 0xFF705957, 0xFF705957, 0x9D000000, 0x9D000000, 0x9D000000, 0x9D000000, 0x9D000000, 0x9D000000, 0x9D000000, 
        0x9C000000, 0x9C000000, 0x9A000000, 0x9A000000, 0x99000000, 0x98000000, 0x96000000, 0x95000000, 0x93000000, 0x91000000, 0x8F000000, 0x8C000000, 0x8A000000, 0x86000000, 0x82000000, 0x7E150000, 0x7A000000, 0x74151500, 0x6B151500, 0x61150000, 
        0x58150000, 0x4C150000, 0x3F000000, 0x32000000, 0x26000000, 0x1B000000, 0x12000000, 0x0B000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xE6502222, 0xFF400022, 0xFF35001C, 0xFF350015, 0xFF2E0015, 0xFF350015, 0xFF66001C, 0xFFE6841C, 0xFFE6841C, 0xFFC87E1C, 0xFFC87E1C, 0xFFC87E1C, 0xFFC87E1C, 0xFFC87E1C, 0xFFC87E1C, 0xFF7A382B, 
        0xFF4C1527, 0xFFC87E1C, 0xFFF8C11C, 0xFFF8C11C, 0xFFFCD21C, 0xFFFCED40, 0xFFF5F07A, 0xFCBEC678, 0xFF705957, 0xFF55322E, 0xEA3D1515, 0x42000000, 0x4A000000, 0x51000000, 0xD65C672E, 0xFF83573D, 0xFF8D2E22, 0xFF902E27, 0xFF902E27, 0xFF992B22, 
        0xFF992B22, 0xFF992B22, 0xFF902E27, 0xFF902E27, 0xFF8D2E22, 0xFF8D2E22, 0xFF8D2E22, 0xFF7A382B, 0xFF7A382B, 0xFF7A382B, 0xFF7A382B, 0xFF7A382B, 0xFF7A382B, 0xFF83573D, 0xFF83573D, 0xFF83573D, 0xFF83573D, 0xE4553B2B, 0xE4553B2B, 0xE4553B2B, 
        0x9A000000, 0x9A000000, 0x99000000, 0x98000000, 0x96000000, 0x95000000, 0x93000000, 0x93000000, 0x8F000000, 0x8F000000, 0x8C000000, 0x8A000000, 0x86000000, 0x85150000, 0x82000000, 0x7E150000, 0x7A000000, 0x74151500, 0x6F150000, 0x67000000, 
        0x5D150000, 0x54150000, 0x44000000, 0x37000000, 0x2C000000, 0x1F000000, 0x15000000, 0x0E000000, 0x08000000, 0x04000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xFF420022, 0xFF3D001C, 0xFF2E0015, 0xFF2E0015, 0xFF2E0015, 0xFF350015, 0xFF7A382B, 0xFFE6841C, 0xFFE6841C, 0xFFE6841C, 0xFFE6841C, 0xFFE6841C, 0xFFE6841C, 0xFFE6841C, 0xFFE6841C, 0xFF902E27, 
        0xFF46001C, 0xFFC87E1C, 0xFFFBE01C, 0xFFFCED40, 0xFFF5F07A, 0xFCBEC678, 0xFF83573D, 0xFF663D22, 0xFF7A382B, 0xFFA37622, 0xFFA37622, 0xFFC87E1C, 0xFFA37622, 0xFF992B22, 0xFF8D2E22, 0xFF7A382B, 0xFF66001C, 0xFF5F3B38, 0xFF5F3B38, 0xFF635248, 
        0xFF705957, 0xFF705957, 0xFF635248, 0xFF62404A, 0xFF635248, 0xFF62404A, 0xFF62404A, 0xFF55322E, 0xFF4C1527, 0xFF4C1527, 0xFF4C1527, 0xFF55322E, 0xFF48002B, 0xFF48002B, 0xFF48002B, 0xFF48002B, 0xFF4C1527, 0xFF5A001C, 0xFF7A382B, 0xFF83573D, 
        0xFF83573D, 0xFF83573D, 0xE4553B2B, 0xD2787244, 0xD65C672E, 0x8C000000, 0x8B150000, 0x8A000000, 0x86000000, 0x85150000, 0x82000000, 0x7F000000, 0x7E150000, 0x7C000000, 0x7A000000, 0x77000000, 0x74151500, 0x6F150000, 0x6B151500, 0x65150000, 
        0x5D150000, 0x54150000, 0x46000000, 0x3B000000, 0x2F000000, 0x22000000, 0x17000000, 0x0F000000, 0x09000000, 0x05000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xFF420022, 0xFF38001C, 0xFF350015, 0xFF2E0015, 0xFF2E0015, 0xFF46001C, 0xFF992B22, 0xFFE6841C, 0xFFE6841C, 0xFFF5AD1C, 0xFFE6841C, 0xFFE6841C, 0xFFF5AD1C, 0xFFE6841C, 0xFFE6841C, 0xFFC87E1C, 
        0xFD461C22, 0xFF992B22, 0xFFF5F07A, 0xFCBEC678, 0xFF8E8140, 0xFF663D22, 0xFF663D22, 0xFF5A001C, 0xFF663D22, 0xFF5F3B38, 0xFF705957, 0xFF7D626D, 0xFF7D626D, 0xFF7D626D, 0xFF7D626D, 0xFF7D626D, 0xFF705957, 0xFF705957, 0xFF62404A, 0xFF55322E, 
        0xFF48002B, 0xFF420022, 0xFF400022, 0xFF3B001C, 0xFF38001C, 0xFF35001C, 0xFF35001C, 0xFF35001C, 0xFF35001C, 0xFF35001C, 0xFF35001C, 0xFF2E0015, 0xFF35001C, 0xFF35001C, 0xFF35001C, 0xFF2E0015, 0xFF35001C, 0xFF35001C, 0xFF38001C, 0xFF35001C, 
        0xFF3D001C, 0xFF4C1527, 0xFF55322E, 0xFF663D22, 0xFF7A382B, 0xFF896D22, 0xFF705957, 0xA6444222, 0x7A000000, 0x77000000, 0x74000000, 0x71000000, 0x6F150000, 0x6E000000, 0x6A000000, 0x6A000000, 0x67000000, 0x65150000, 0x61150000, 0x5D150000, 
        0x54150000, 0x4C150000, 0x44000000, 0x37000000, 0x2C000000, 0x21000000, 0x17000000, 0x0F000000, 0x09000000, 0x05000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x6F150000, 0xFF3D001C, 0xFF38001C, 0xFF38001C, 0xFF35001C, 0xFF400022, 0xFFA37622, 0xFFE6841C, 0xFFF5AD1C, 0xFFF8C11C, 0xFFFCD21C, 0xFFFBCB1C, 0xFFFACC1C, 0xFFFCD21C, 0xFFF8C11C, 0xFFF8C11C, 0xFFF5AD1C, 
        0xFF896D22, 0xFF5A001C, 0xFF663D22, 0xFF5F3B38, 0xFF5D542B, 0xFF837278, 0xFF908494, 0xFF908494, 0xFF837278, 0xFF7D626D, 0xFF62404A, 0xFF3D0027, 0xFF3D0022, 0xFF38001C, 0xFF38001C, 0xFF38001C, 0xFF3B001C, 0xFF38001C, 0xFF35001C, 0xFF35001C, 
        0xFF35001C, 0xFF38001C, 0xFF38001C, 0xFF350022, 0xFF350022, 0xFF350022, 0xFF38001C, 0xFF350022, 0xFF2E0015, 0xFF2E0015, 0xFF2E0015, 0xFF2E0015, 0xFF35001C, 0xFF35001C, 0xFF2E0015, 0xFF2E0015, 0xFF2E0015, 0xFF2E0015, 0xFF2E0015, 0xFF2E0015, 
        0xFF2E0015, 0xFF2E0015, 0xFF35001C, 0xFF2E0015, 0xFF38001C, 0xFF3B001C, 0xFF5F3B38, 0xFF635248, 0xFF705957, 0xA6444222, 0x61150000, 0x5E000000, 0x5B000000, 0x5B000000, 0x58000000, 0x58000000, 0x54000000, 0x54000000, 0x51000000, 0x4E000000, 
        0x4A000000, 0x44000000, 0x3B000000, 0x32000000, 0x27000000, 0x1F000000, 0x16000000, 0x0E000000, 0x09000000, 0x05000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0xC8351500, 0xFF420022, 0xFF38001C, 0xFF38001C, 0xFF350015, 0xFF7A382B, 0xFFE6841C, 0xFFF5AD1C, 0xFFF5AD1C, 0xFFFBCB1C, 0xFFFACC1C, 0xFFFCD21C, 0xFFFBE01C, 0xFFFCE422, 0xFFFCE01C, 0xFFFCD21C, 0xFFFACC1C, 
        0xFFAD8722, 0xFF837278, 0xFCBEC678, 0xFFC2BEC6, 0xFFF5F07A, 0xFFF5F07A, 0xFFD8BE46, 0xFF83573D, 0xFF482222, 0xFF3B001C, 0xFF38001C, 0xFF38001C, 0xFF38001C, 0xFF350022, 0xFF38001C, 0xFF38001C, 0xFF38001C, 0xFF38001C, 0xFF38001C, 0xFF35001C, 
        0xFF38001C, 0xFF38001C, 0xFF35001C, 0xFF35001C, 0xFF38001C, 0xFF35001C, 0xFF35001C, 0xFF35001C, 0xFF350015, 0xFF350015, 0xFF35001C, 0xFF35001C, 0xFF48002B, 0xFF35001C, 0xFF35001C, 0xFF350015, 0xFF350015, 0xFF2E0015, 0xFF38001C, 0xFF350015, 
        0xFF350015, 0xFF350015, 0xFF3B001C, 0xFF3B001C, 0xFF3B001C, 0xFF35001C, 0xFF38001C, 0xFF35001C, 0xFF46001C, 0xFF5F3B38, 0xCB4A3822, 0x4A000000, 0x48000000, 0x46000000, 0x44000000, 0x44000000, 0x44000000, 0x42000000, 0x42000000, 0x3E000000, 
        0x3B000000, 0x36000000, 0x31000000, 0x29000000, 0x22000000, 0x1A000000, 0x12000000, 0x0C000000, 0x07000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0xFF420022, 0xFF3D001C, 0xFF400022, 0xFF35001C, 0xFF66001C, 0xFFC87E1C, 0xFFE6841C, 0xFFF5AD1C, 0xFFF8C11C, 0xFFFCE01C, 0xFFFFEB32, 0xFFFAE632, 0xFFFFEB32, 0xFFFEE622, 0xFFFAE632, 0xFFFAE632, 0xFFFBE01C, 
        0xFFAD8722, 0xFF62404A, 0xFFC87E1C, 0xFFF5F07A, 0xFFF5F07A, 0xFFF5AD1C, 0xFFF5AD1C, 0xFFC87E1C, 0xFF896D22, 0xFF3B001C, 0xFF38001C, 0xFF38001C, 0xFF35001C, 0xFF38001C, 0xFF38001C, 0xFF35001C, 0xFF35001C, 0xFF38001C, 0xFF38001C, 0xFF38001C, 
        0xFF38001C, 0xFF38001C, 0xFF38001C, 0xFF38001C, 0xFF3B001C, 0xFF3B001C, 0xFF3B001C, 0xFF3D001C, 0xFF3D001C, 0xFF3D001C, 0xFF400022, 0xFF420022, 0xFF48002B, 0xFF420022, 0xFF48002B, 0xFF482222, 0xFF4C1527, 0xFF4C1527, 0xFF4C1527, 0xFF55322E, 
        0xFF5F3B38, 0xFF5F3B38, 0xFF574027, 0xFF5F3B38, 0xFF5F3B38, 0xFF55322E, 0xFF55322E, 0xFE503227, 0xFF482222, 0xFF400022, 0xFF482222, 0xE6502222, 0x36000000, 0x34000000, 0x33000000, 0x32000000, 0x31000000, 0x31000000, 0x2F000000, 0x2F000000, 
        0x2C000000, 0x29000000, 0x25000000, 0x20000000, 0x1A000000, 0x14000000, 0x0F000000, 0x0A000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0xFF420022, 0xFF3B001C, 0xFF35001C, 0xFF380015, 0xFF992B22, 0xFFE6841C, 0xFFF5AD1C, 0xFFFBCB1C, 0xFFFCE01C, 0xFFFFEB32, 0xFFFCE422, 0xFFFCED40, 0xFFFCED40, 0xFFFFE922, 0xFFFCED40, 0xFFFCE422, 0xFFFBE01C, 
        0xFFB9C32E, 0xFF420022, 0xFF992B22, 0xFFFCD21C, 0xFFFACC1C, 0xFFF5AD1C, 0xFFE6841C, 0xFFE6841C, 0xFFC87E1C, 0xFF574027, 0xFF3D0022, 0xFF38001C, 0xFF38001C, 0xFF35001C, 0xFF38001C, 0xFF35001C, 0xFF38001C, 0xFF38001C, 0xFF3D0027, 0xFF38001C, 
        0xFF3D0022, 0xFF3B001C, 0xFF400022, 0xFF3D0022, 0xFF400022, 0xFF420022, 0xFF46001C, 0xFF4C1527, 0xFF5F3B38, 0xFF62404A, 0xFF62404A, 0xFF635248, 0xD65C672E, 0xE4553B2B, 0xE4553B2B, 0xE4553B2B, 0xCB4A3822, 0xE4553B2B, 0xE4553B2B, 0x51000000, 
        0x4E000000, 0x49000000, 0x44000000, 0x42000000, 0x3E000000, 0x3B000000, 0x37000000, 0x34000000, 0x32000000, 0x8B150000, 0xCB4A3822, 0xFF574027, 0xCB4A3822, 0x26000000, 0x24000000, 0x23000000, 0x22000000, 0x22000000, 0x21000000, 0x20000000, 
        0x1D000000, 0x1C000000, 0x1A000000, 0x16000000, 0x12000000, 0x0E000000, 0x0A000000, 0x07000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0xFF3D0022, 0xFF38001C, 0xFF38001C, 0xFF8D2E22, 0xFFE6841C, 0xFFF5AD1C, 0xFFF8C11C, 0xFFFCD21C, 0xFFFEE122, 0xFFFFEB32, 0xFFFFEB32, 0xFFFCED40, 0xFFFCED40, 0xFFFFEB32, 0xFFFEE622, 0xFFFBE01C, 0xFFFCE422, 
        0xFFD8BE46, 0xFF46001C, 0xFF5A001C, 0xFFE6841C, 0xFFF0C52B, 0xFFF0C52B, 0xFFF5AD1C, 0xFFF5AD1C, 0xFFE6841C, 0xFF6F5A22, 0xFF3D001C, 0xFF3D001C, 0xFF38001C, 0xFF35001C, 0xFF38001C, 0xFF3B001C, 0xFF3B001C, 0xFF3B001C, 0xFF3B001C, 0xFF420022, 
        0xFF400022, 0xFF4C1527, 0xFF55322E, 0xFF62404A, 0xFF705957, 0xE4553B2B, 0xE4553B2B, 0xE4553B2B, 0xCB4A3822, 0x7E150000, 0x77000000, 0x71000000, 0x6E000000, 0x67000000, 0x61150000, 0x5D150000, 0x54000000, 0x51000000, 0x4C150000, 0x46000000, 
        0x44000000, 0x3F000000, 0x3B000000, 0x37000000, 0x34000000, 0x31000000, 0x2F000000, 0x2C000000, 0x29000000, 0x26000000, 0x23000000, 0x21000000, 0x1D000000, 0x1C000000, 0x1B000000, 0x19000000, 0x18000000, 0x17000000, 0x16000000, 0x16000000, 
        0x14000000, 0x13000000, 0x11000000, 0x0F000000, 0x0C000000, 0x09000000, 0x07000000, 0x05000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0xC8351500, 0xFF35001C, 0xFF35001C, 0xFF3B001C, 0xFF8D2E22, 0xFFE6841C, 0xFFF5AD1C, 0xFFFCD21C, 0xFFFCE01C, 0xFFFFE922, 0xFFFFEB32, 0xFFFFE922, 0xFFFFEB32, 0xFFFCE422, 0xFFFAE632, 0xFFFAE632, 0xFFFBE01C, 0xFFFCD21C, 
        0xFFF0C52B, 0xFF655522, 0xFF400022, 0xFF8D2E22, 0xFFF5AD1C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFF5AD1C, 0xFFF5AD1C, 0xFF6F5A22, 0xFF400022, 0xFF38001C, 0xFF3D0022, 0xFF3D0022, 0xFF420022, 0xFF420022, 0xFF48002B, 0xFF48002B, 0xFF55322E, 0xFF55322E, 
        0xE6502222, 0xE4553B2B, 0xCB4A3822, 0x99000000, 0x93000000, 0x8F150000, 0x86000000, 0x80151500, 0x7C000000, 0x74000000, 0x6F150000, 0x6A150000, 0x65150000, 0x5E000000, 0x5B150000, 0x54150000, 0x50150000, 0x4C150000, 0x46000000, 0x44000000, 
        0x3F000000, 0x3C000000, 0x39000000, 0x36000000, 0x33000000, 0x2F000000, 0x2C000000, 0x2A000000, 0x27000000, 0x24000000, 0x21000000, 0x1D000000, 0x1C000000, 0x1A000000, 0x17000000, 0x16000000, 0x14000000, 0x12000000, 0x11000000, 0x10000000, 
        0x0E000000, 0x0D000000, 0x0B000000, 0x0A000000, 0x08000000, 0x06000000, 0x04000000, 0x03000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0xC8351500, 0xFF3B001C, 0xFF35001C, 0xFF8D2E22, 0xFFE6841C, 0xFFF5AD1C, 0xFFFACC1C, 0xFFFEE122, 0xFFFEE622, 0xFFFFEB32, 0xFFFFEB32, 0xFFFFEB32, 0xFFFEE622, 0xFFFCE422, 0xFFFEE122, 0xFFFCE422, 0xFFFBE01C, 0xFFFCD21C, 
        0xFFFACC1C, 0xFFD8BE46, 0xFF83573D, 0xFF4C1527, 0xFF5A001C, 0xFFA37622, 0xFFD8BE46, 0xFFF5AD1C, 0xFFF0C52B, 0xFFD8BE46, 0xFF8E8140, 0xFF655522, 0xFF5F3B38, 0xFF5F3B38, 0xFF55322E, 0xFF55322E, 0xE6502222, 0xC8351500, 0xA6000000, 0xA5000000, 
        0xA2000000, 0x9F000000, 0x9A000000, 0x95000000, 0x8F150000, 0x86000000, 0x82000000, 0x7C000000, 0x74000000, 0x6F150000, 0x6A150000, 0x65150000, 0x61150000, 0x5D150000, 0x58150000, 0x54150000, 0x50150000, 0x4C150000, 0x4A000000, 0x46000000, 
        0x44000000, 0x42000000, 0x3E000000, 0x3B000000, 0x37000000, 0x34000000, 0x32000000, 0x2F000000, 0x2C000000, 0x29000000, 0x26000000, 0x23000000, 0x20000000, 0x1D000000, 0x1B000000, 0x18000000, 0x16000000, 0x13000000, 0x11000000, 0x0F000000, 
        0x0D000000, 0x0B000000, 0x09000000, 0x07000000, 0x05000000, 0x04000000, 0x03000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0xEA3D1515, 0xFF420022, 0xFF4C1527, 0xFFC87E1C, 0xFFF5AD1C, 0xFFFBCB1C, 0xFFFEE622, 0xFFFFE922, 0xFFFFEB32, 0xFFFCED40, 0xFFFFEB32, 0xFFFFEB32, 0xFFFEE622, 0xFFFCE422, 0xFFFCE01C, 0xFFFCE01C, 0xFFFCD21C, 0xFFFCD21C, 
        0xFFF8C11C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFC87E1C, 0xFFA37622, 0xFF7A382B, 0xFF66001C, 0xFF55322E, 0xFF5A3D22, 0xE6502222, 0xE4553B2B, 0xE4553B2B, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA4000000, 
        0xA0000000, 0x9D000000, 0x99000000, 0x93000000, 0x8B150000, 0x85150000, 0x7F000000, 0x77000000, 0x74151500, 0x6F150000, 0x6A150000, 0x65150000, 0x61150000, 0x5E000000, 0x5D150000, 0x5B150000, 0x58150000, 0x54150000, 0x54150000, 0x50150000, 
        0x4E000000, 0x4C150000, 0x49000000, 0x46000000, 0x44000000, 0x42000000, 0x3E000000, 0x3B000000, 0x37000000, 0x34000000, 0x31000000, 0x2F000000, 0x2A000000, 0x27000000, 0x23000000, 0x20000000, 0x1C000000, 0x19000000, 0x16000000, 0x13000000, 
        0x10000000, 0x0D000000, 0x0A000000, 0x07000000, 0x05000000, 0x04000000, 0x02000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0xFF420022, 0xFF3B001C, 0xFF7A382B, 0xFFE6841C, 0xFFF5AD1C, 0xFFFCE01C, 0xFFFEE622, 0xFFFFEB32, 0xFFFCED40, 0xFFFFEB32, 0xFFFCED40, 0xFFFCED40, 0xFFFCE422, 0xFFFEE122, 0xFFFCE422, 0xFFFCD21C, 0xFFFCD21C, 0xFFFACC1C, 
        0xFFF8C11C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFF5AD1C, 0xFFE6841C, 0xFF896D22, 0xFF663D22, 0xE6502222, 0xC8351500, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA5000000, 0xA4000000, 
        0xA0000000, 0x9D000000, 0x98000000, 0x93000000, 0x8B150000, 0x85150000, 0x7F000000, 0x7A000000, 0x74000000, 0x71000000, 0x6F150000, 0x6B151500, 0x6A150000, 0x67000000, 0x65150000, 0x65150000, 0x63000000, 0x61150000, 0x61150000, 0x5D150000, 
        0x5D150000, 0x5B150000, 0x58150000, 0x58150000, 0x54150000, 0x50150000, 0x4E000000, 0x4A000000, 0x46000000, 0x44000000, 0x3F000000, 0x3C000000, 0x37000000, 0x34000000, 0x31000000, 0x2C000000, 0x27000000, 0x23000000, 0x1D000000, 0x1A000000, 
        0x15000000, 0x11000000, 0x0D000000, 0x0A000000, 0x07000000, 0x05000000, 0x03000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0xFF38001C, 0xFF46001C, 0xFFC87E1C, 0xFFF5AD1C, 0xFFFCD21C, 0xFFFFE922, 0xFFFEE622, 0xFFFFEB32, 0xFFFFEB32, 0xFFFFE922, 0xFFFFEB32, 0xFFFFEB32, 0xFFFCE422, 0xFFFCE01C, 0xFFFCD21C, 0xFFFACC1C, 0xFFFBCB1C, 0xFFF8C11C, 
        0xFFF5AD1C, 0xFFF5AD1C, 0xFFE6841C, 0xFFC87E1C, 0xFFA37622, 0xFE503227, 0xC8351500, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA5000000, 0xA4000000, 
        0xA0000000, 0x9D000000, 0x98000000, 0x93000000, 0x8C000000, 0x86000000, 0x82000000, 0x7E150000, 0x7C000000, 0x77000000, 0x77000000, 0x74151500, 0x74151500, 0x74151500, 0x74151500, 0x71000000, 0x71000000, 0x6F150000, 0x6F150000, 0x6F150000, 
        0x6B151500, 0x6B151500, 0x6A150000, 0x65150000, 0x65150000, 0x61150000, 0x5D150000, 0x5B150000, 0x58150000, 0x54000000, 0x50150000, 0x4C150000, 0x48000000, 0x44000000, 0x3F000000, 0x3B000000, 0x34000000, 0x2F000000, 0x2A000000, 0x24000000, 
        0x1D000000, 0x18000000, 0x13000000, 0x0E000000, 0x0A000000, 0x07000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x74404022, 0x74404022, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0xFF35001C, 0xFF66001C, 0xFFE6841C, 0xFFF8C11C, 0xFFFCE01C, 0xFFFFEB32, 0xFFFFE922, 0xFFFCED40, 0xFFFFEB32, 0xFFFFEB32, 0xFFFFEB32, 0xFFFCED40, 0xFFFCE422, 0xFFFBE01C, 0xFFF8C11C, 0xFFF8C11C, 0xFFF8C11C, 0xFFF5AD1C, 
        0xFFE6841C, 0xFFE6841C, 0xFFC87E1C, 0xFF992B22, 0xFF5A3D22, 0xC8351500, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA4000000, 
        0xA2000000, 0x9D000000, 0x9A000000, 0x96000000, 0x91000000, 0x8B150000, 0x86000000, 0x85150000, 0x82000000, 0x80151500, 0x80151500, 0x7F000000, 0x7E150000, 0x7E150000, 0x7E150000, 0x7E150000, 0x7E150000, 0x7E150000, 0x7C000000, 0x7C000000, 
        0x7A000000, 0x77150000, 0x77150000, 0x74151500, 0x71000000, 0x6F150000, 0x6E000000, 0x6A150000, 0x65150000, 0x63000000, 0x5E000000, 0x5B150000, 0x58150000, 0x51000000, 0x4C150000, 0x48000000, 0x42000000, 0x3C000000, 0x36000000, 0x2F000000, 
        0x27000000, 0x21000000, 0x1A000000, 0x14000000, 0x0E000000, 0x0A000000, 0x06000000, 0x03000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0xFF87994C, 0xFF97C335, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0xC8351500, 0xFF46001C, 0xFFC87E1C, 0xFFF5AD1C, 0xFFF8C11C, 0xFFFCE422, 0xFFFEE122, 0xFFFFEB32, 0xFFFCED40, 0xFFFFEB32, 0xFFFFEB32, 0xFFFCED40, 0xFFFCED40, 0xFFFCD21C, 0xFFFCD21C, 0xFFFBCB1C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFF5AD1C, 
        0xFFE6841C, 0xFFC87E1C, 0xFFC87E1C, 0xFF992B22, 0xFF5A3D22, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA4000000, 
        0xA2000000, 0xA0000000, 0x9C000000, 0x99000000, 0x95000000, 0x91000000, 0x8F000000, 0x8C000000, 0x8B150000, 0x8A000000, 0x8A000000, 0x8A000000, 0x8A000000, 0x86000000, 0x86000000, 0x86000000, 0x86000000, 0x85150000, 0x85150000, 0x85150000, 
        0x82000000, 0x80151500, 0x7E150000, 0x7E150000, 0x7C000000, 0x7A000000, 0x77150000, 0x74151500, 0x6F150000, 0x6E000000, 0x6A150000, 0x65150000, 0x61150000, 0x5D150000, 0x58150000, 0x51000000, 0x4C150000, 0x46000000, 0x3F000000, 0x39000000, 
        0x31000000, 0x2A000000, 0x22000000, 0x1A000000, 0x13000000, 0x0D000000, 0x09000000, 0x05000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0xFF7F7B42, 0xFFACC32E, 0xF1849C4C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0xEA3D1515, 0xFF7A382B, 0xFFE6841C, 0xFFF5AD1C, 0xFFFCD21C, 0xFFFEE622, 0xFFFFEB32, 0xFFFEE622, 0xFFFFE922, 0xFFFCED40, 0xFFFCED40, 0xFFFFEB32, 0xFFFFE922, 0xFFFCE422, 0xFFFCE01C, 0xFFFCD21C, 0xFFFBCB1C, 0xFFFBCB1C, 0xFFF5AD1C, 
        0xFFE6841C, 0xFFE6841C, 0xFFC87E1C, 0xFFA37622, 0xFE503227, 0xA7000000, 0xA7000000, 0xA7000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 
        0xA3000000, 0xA0000000, 0x9D000000, 0x9A000000, 0x98000000, 0x96000000, 0x93000000, 0x93000000, 0x91000000, 0x8F000000, 0x8F000000, 0x8F000000, 0x8F150000, 0x8C000000, 0x8C000000, 0x8B150000, 0x8B150000, 0x8A000000, 0x86000000, 0x86000000, 
        0x85150000, 0x82000000, 0x80151500, 0x7E150000, 0x7E150000, 0x7C000000, 0x77150000, 0x77150000, 0x74151500, 0x6F150000, 0x6B151500, 0x6A150000, 0x65150000, 0x61150000, 0x5D150000, 0x58150000, 0x51000000, 0x4C150000, 0x46000000, 0x3F000000, 
        0x37000000, 0x31000000, 0x27000000, 0x1F000000, 0x17000000, 0x10000000, 0x0B000000, 0x06000000, 0x03000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0xD65C672E, 0xFF98B427, 0xFFBAE42E, 0xD2787244, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x6F150000, 0xFF420022, 0xFFC87E1C, 0xFFF5AD1C, 0xFFFBCB1C, 0xFFFEE122, 0xFFFFEB32, 0xFFFFE922, 0xFFFFEB32, 0xFFFFEB32, 0xFFFCED40, 0xFFFFEB32, 0xFFFFEB32, 0xFFFFEB32, 0xFFFFEB32, 0xFFFCE01C, 0xFFFCE422, 0xFFFCE01C, 0xFFFBCB1C, 0xFFF5AD1C, 
        0xFFF5AD1C, 0xFFE6841C, 0xFFE6841C, 0xFFA37622, 0xFF4C1527, 0xFD461C22, 0xEA3D1515, 0xA8000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA4000000, 
        0xA2000000, 0xA0000000, 0x9D000000, 0x9C000000, 0x9A000000, 0x96000000, 0x96000000, 0x93000000, 0x93000000, 0x93000000, 0x8F000000, 0x8F000000, 0x8F150000, 0x8C000000, 0x8B150000, 0x8B150000, 0x86000000, 0x85150000, 0x85150000, 0x82000000, 
        0x80151500, 0x7E150000, 0x7C000000, 0x7A000000, 0x77150000, 0x74151500, 0x74151500, 0x71000000, 0x6F150000, 0x6B151500, 0x67000000, 0x65150000, 0x61150000, 0x5D150000, 0x58150000, 0x54150000, 0x50150000, 0x4C150000, 0x46000000, 0x42000000, 
        0x3B000000, 0x33000000, 0x2A000000, 0x22000000, 0x1A000000, 0x13000000, 0x0C000000, 0x08000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x74404022, 0xFF98B427, 0xFFACC32E, 0xFEA8C346, 0xD65C672E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0xEA3D1515, 0xFF7A382B, 0xFFF5AD1C, 0xFFFBCB1C, 0xFFFBCB1C, 0xFFFCE422, 0xFFFEE622, 0xFFFFE922, 0xFFFFEB32, 0xFFFFEB32, 0xFFFCED40, 0xFFFCED40, 0xFFFFEB32, 0xFFFFEB32, 0xFFFCED40, 0xFFFCE422, 0xFFFBE01C, 0xFFFCD21C, 0xFFFBCB1C, 0xFFF8C11C, 
        0xFFF5AD1C, 0xFFF5AD1C, 0xFFE6841C, 0xFFC87E1C, 0xFF663D22, 0xFF420022, 0xFF4C1527, 0xFD461C22, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA4000000, 0xA2000000, 
        0xA0000000, 0x9D000000, 0x9C000000, 0x9A000000, 0x98000000, 0x95000000, 0x93000000, 0x93000000, 0x8F000000, 0x8F000000, 0x8C000000, 0x8A000000, 0x86000000, 0x85150000, 0x85150000, 0x82000000, 0x7E150000, 0x7E150000, 0x7A000000, 0x77150000, 
        0x74151500, 0x71000000, 0x6F150000, 0x6E000000, 0x6B151500, 0x6A150000, 0x67000000, 0x65150000, 0x63000000, 0x61150000, 0x5D150000, 0x5B150000, 0x58150000, 0x54000000, 0x50150000, 0x4E000000, 0x4A000000, 0x46000000, 0x42000000, 0x3C000000, 
        0x37000000, 0x31000000, 0x2A000000, 0x22000000, 0x1A000000, 0x13000000, 0x0D000000, 0x08000000, 0x05000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0xFF829544, 0xFF97C335, 0xFFB9C32E, 0xFF84AE4C, 0xD2787244, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0xFF3B001C, 0xFFC87E1C, 0xFFF8C11C, 0xFFFBCB1C, 0xFFFCD21C, 0xFFFEE122, 0xFFFCE422, 0xFFFEE122, 0xFFFFEB32, 0xFFFCED40, 0xFFFCED40, 0xFFFCED40, 0xFFFCED40, 0xFFFFEB32, 0xFFFCED40, 0xFFFEE622, 0xFFFCE01C, 0xFFFCE01C, 0xFFFBCB1C, 0xFFF8C11C, 
        0xFFF5AD1C, 0xFFF5AD1C, 0xFFF5AD1C, 0xFFE6841C, 0xFF7A382B, 0xFF420022, 0xFF420022, 0xFF48002B, 0xFD461C22, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA4000000, 0xA3000000, 0xA0000000, 0x9D000000, 
        0x9C000000, 0x99000000, 0x96000000, 0x93000000, 0x91000000, 0x8F000000, 0x8C000000, 0x8A000000, 0x86000000, 0x85150000, 0x82000000, 0x7F000000, 0x7C000000, 0x7A000000, 0x77000000, 0x74000000, 0x71000000, 0x6E000000, 0x6A150000, 0x67000000, 
        0x65150000, 0x61150000, 0x5E000000, 0x5D150000, 0x5B150000, 0x58150000, 0x58150000, 0x54000000, 0x51000000, 0x50150000, 0x4E000000, 0x4A000000, 0x48000000, 0x44000000, 0x44000000, 0x3F000000, 0x3E000000, 0x3B000000, 0x39000000, 0x34000000, 
        0x31000000, 0x2C000000, 0x26000000, 0x1F000000, 0x19000000, 0x12000000, 0x0C000000, 0x08000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xD2787244, 
        0xFFADE12E, 0xFF97C335, 0xFFC8E42E, 0xFF84AE4C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 
        0xFF4C1527, 0xFFE6841C, 0xFFF8C11C, 0xFFFACC1C, 0xFFFACC1C, 0xFFFEE122, 0xFFFCE01C, 0xFFFFEB32, 0xFFFFEB32, 0xFFFFEB32, 0xFFFCED40, 0xFFFFEB32, 0xFFFCED40, 0xFFFFEB32, 0xFFFFEB32, 0xFFFFEB32, 0xFFFCE422, 0xFFFCD21C, 0xFFFCE01C, 0xFFFCD21C, 
        0xFFF8C11C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFE6841C, 0xFFA37622, 0xFF420022, 0xFF400022, 0xFF46001C, 0xFF4C1527, 0xFE503227, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA4000000, 0xA0000000, 0x9F000000, 0x9C000000, 0x98000000, 
        0x95000000, 0x91000000, 0x8C000000, 0x8A000000, 0x86000000, 0x85150000, 0x82000000, 0x7E150000, 0x7C000000, 0x77000000, 0x74000000, 0x71000000, 0x6E000000, 0x6A000000, 0x65150000, 0x61150000, 0x5D150000, 0x5B150000, 0x58150000, 0x54000000, 
        0x51000000, 0x4E000000, 0x4C150000, 0x49000000, 0x46000000, 0x44000000, 0x44000000, 0x42000000, 0x3F000000, 0x3E000000, 0x3C000000, 0x39000000, 0x37000000, 0x34000000, 0x33000000, 0x31000000, 0x31000000, 0x2F000000, 0x2C000000, 0x2A000000, 
        0x27000000, 0x24000000, 0x20000000, 0x1B000000, 0x15000000, 0x10000000, 0x0B000000, 0x07000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF8FA435, 0xFF6F7822, 0x74404022, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xD65C672E, 0xFF98B427, 
        0xFF9AD646, 0xFFB9C32E, 0xFFC8E42E, 0xFF74A422, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x01000000, 0x02000000, 0x02000000, 0x02000000, 0x02000000, 0x01000000, 0x01000000, 
        0xFF992B22, 0xFFF5AD1C, 0xFFFCD21C, 0xFFFCE01C, 0xFFFEE122, 0xFFFEE122, 0xFFFFEB32, 0xFFFCE01C, 0xFFFFEB32, 0xFFFEE122, 0xFFFCED40, 0xFFFCED40, 0xFFFFEB32, 0xFFFFEB32, 0xFFFEE622, 0xFFFFEB32, 0xFFFEE622, 0xFFFEE622, 0xFFFAE632, 0xFFFCE01C, 
        0xFFF8C11C, 0xFFF8C11C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFC87E1C, 0xFF55322E, 0xFF400022, 0xFF3D0022, 0xFF3D0027, 0xFF48002B, 0xFF55322E, 0xA7000000, 0xA6000000, 0xA5000000, 0xA3000000, 0xA0000000, 0x9D000000, 0x99000000, 0x95000000, 0x8F000000, 
        0x8A000000, 0x85150000, 0x7F000000, 0x7C000000, 0x77000000, 0x74000000, 0x71000000, 0x6E000000, 0x6A000000, 0x65150000, 0x63000000, 0x5E000000, 0x58000000, 0x54000000, 0x51000000, 0x4E000000, 0x4A000000, 0x46000000, 0x44000000, 0x3F000000, 
        0x3C000000, 0x3B000000, 0x37000000, 0x36000000, 0x34000000, 0x32000000, 0x31000000, 0x31000000, 0x2F000000, 0x2C000000, 0x2C000000, 0x29000000, 0x27000000, 0x25000000, 0x24000000, 0x23000000, 0x22000000, 0x21000000, 0x20000000, 0x1F000000, 
        0x1D000000, 0x1B000000, 0x18000000, 0x14000000, 0x10000000, 0x0C000000, 0x09000000, 0x05000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFB9C32E, 0xFFACC32E, 0xFF7E9A22, 0xFF626B27, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x74404022, 0xFF8FA435, 0xFFBAE42E, 
        0xFF97C335, 0xFFD4E62E, 0xFFADE12E, 0xD65C672E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x03000000, 0x03000000, 0x04000000, 0x04000000, 0x04000000, 0x04000000, 0x03000000, 0x02000000, 
        0xFFC87E1C, 0xFFFACC1C, 0xFFFCE01C, 0xFFF8C11C, 0xFFFCE01C, 0xFFFFEB32, 0xFFFEE122, 0xFFFEE622, 0xFFFEE122, 0xFFFFEB32, 0xFFFFEB32, 0xFFFCED40, 0xFFFFEB32, 0xFFFCED40, 0xFFFFEB32, 0xFFFFE922, 0xFFFFE922, 0xFFFBE01C, 0xFFFCE01C, 0xFFFCE01C, 
        0xFFFACC1C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFF5AD1C, 0xFFE6841C, 0xFF83573D, 0xFF400022, 0xFF400022, 0xFF400022, 0xFF420022, 0xFF48002B, 0xFD461C22, 0xA6000000, 0xA4000000, 0xA0000000, 0x9D000000, 0x98000000, 0x93000000, 0x8B150000, 0x85150000, 
        0x7C000000, 0x77000000, 0x71000000, 0x6A000000, 0x67000000, 0x61150000, 0x5D150000, 0x58000000, 0x54000000, 0x51000000, 0x4E000000, 0x49000000, 0x44000000, 0x42000000, 0x3C000000, 0x3B000000, 0x36000000, 0x33000000, 0x31000000, 0x2C000000, 
        0x2C000000, 0x27000000, 0x26000000, 0x24000000, 0x23000000, 0x22000000, 0x21000000, 0x20000000, 0x1D000000, 0x1D000000, 0x1C000000, 0x1B000000, 0x19000000, 0x18000000, 0x17000000, 0x16000000, 0x16000000, 0x16000000, 0x15000000, 0x15000000, 
        0x14000000, 0x13000000, 0x11000000, 0x0E000000, 0x0C000000, 0x09000000, 0x06000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFB9C32E, 0xFFC8E42E, 0xFFBAE42E, 0xFFACC32E, 0xFF7E9A22, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xF1849C4C, 0xFFBAE42E, 0xFF9AD646, 
        0xFFB9C32E, 0xFFDCEA32, 0xFF97C335, 0x74404022, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x02000000, 0x04000000, 0x05000000, 0x07000000, 0x08000000, 0x08000000, 0x08000000, 0x06000000, 0x05000000, 0x04000000, 
        0xFFC87E1C, 0xFFFEE122, 0xFFF8C11C, 0xFFFCD21C, 0xFFFEE122, 0xFFFEE122, 0xFFFEE122, 0xFFFEE622, 0xFFFFEB32, 0xFFFFEB32, 0xFFFEE622, 0xFFFCED40, 0xFFFFEB32, 0xFFFFEB32, 0xFFFEE122, 0xFFFEE622, 0xFFFFE922, 0xFFFBE01C, 0xFFFCD21C, 0xFFFBE01C, 
        0xFFFACC1C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFA37622, 0xFF46001C, 0xFF3D0022, 0xFF400022, 0xFF420022, 0xFF48002B, 0xFF48002B, 0xFD461C22, 0xA2000000, 0x9D000000, 0x99000000, 0x93000000, 0x8A000000, 0x82000000, 0x77000000, 
        0x6E000000, 0x67000000, 0x5E000000, 0x58000000, 0x51000000, 0x4E000000, 0x49000000, 0x44000000, 0x42000000, 0x3C000000, 0x39000000, 0x34000000, 0x32000000, 0x2F000000, 0x2C000000, 0x27000000, 0x25000000, 0x22000000, 0x20000000, 0x1D000000, 
        0x1C000000, 0x1A000000, 0x18000000, 0x17000000, 0x16000000, 0x15000000, 0x14000000, 0x13000000, 0x12000000, 0x11000000, 0x11000000, 0x10000000, 0x0F000000, 0x0E000000, 0x0D000000, 0x0D000000, 0x0D000000, 0x0D000000, 0x0D000000, 0x0C000000, 
        0x0C000000, 0x0C000000, 0x0B000000, 0x09000000, 0x08000000, 0x06000000, 0x04000000, 0x03000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFADE12E, 0xFFBAE42E, 0xFFC8E42E, 0xFFC8E42E, 0xFFADE12E, 0xFF627D27, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xD2787244, 0xFFACC32E, 0xFFBAE42E, 0xFF97B446, 
        0xFFD4E62E, 0xFFDCEA32, 0xFF87BA3B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x05000000, 0x07000000, 0x09000000, 0x0B000000, 0x0D000000, 0x0D000000, 0x0C000000, 0x0B000000, 0x08000000, 0x6F150000, 
        0xFFC87E1C, 0xFFFCE01C, 0xFFFBCB1C, 0xFFFACC1C, 0xFFFCE01C, 0xFFFEE122, 0xFFFFE922, 0xFFFEE122, 0xFFFFE922, 0xFFFCE422, 0xFFFEE622, 0xFFFFEB32, 0xFFFEE622, 0xFFFCED40, 0xFFFCE422, 0xFFFFEB32, 0xFFFEE622, 0xFFFBE01C, 0xFFFCD21C, 0xFFFBE01C, 
        0xFFFCD21C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFC87E1C, 0xFF604022, 0xFF400022, 0xFF420022, 0xFF3D0022, 0xFF3D0027, 0xFF400022, 0xFF48002B, 0xFF4C1527, 0x9A000000, 0x95000000, 0x8C000000, 0x82000000, 0x77000000, 0x6A000000, 
        0x5E000000, 0x54000000, 0x4C150000, 0x44000000, 0x3F000000, 0x3B000000, 0x34000000, 0x32000000, 0x2F000000, 0x2C000000, 0x27000000, 0x24000000, 0x21000000, 0x1F000000, 0x1C000000, 0x1A000000, 0x17000000, 0x15000000, 0x14000000, 0x12000000, 
        0x10000000, 0x0F000000, 0x0E000000, 0x0D000000, 0x0C000000, 0x0C000000, 0x0B000000, 0x0A000000, 0x0A000000, 0x09000000, 0x09000000, 0x08000000, 0x08000000, 0x07000000, 0x07000000, 0x07000000, 0x06000000, 0x06000000, 0x07000000, 0x07000000, 
        0x07000000, 0x06000000, 0x06000000, 0x05000000, 0x04000000, 0x03000000, 0x02000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFB3E442, 0xFFADE12E, 0xFFBAE42E, 0xFFBAE42E, 0xFFC8E42E, 0xFF97C335, 0x74404022, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xFF7F7B42, 0xFFBAE42E, 0xFF9AD646, 0xFFACC32E, 
        0xFFD4E62E, 0xFFD4E62E, 0xD2787244, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x05000000, 0x08000000, 0x0B000000, 0x0F000000, 0x12000000, 0x14000000, 0x14000000, 0x13000000, 0x10000000, 0x0C000000, 0xEA3D1515, 
        0xFFD8BE46, 0xFFFEE122, 0xFFFBCB1C, 0xFFFCD21C, 0xFFFEE622, 0xFFFEE622, 0xFFFFEB32, 0xFFFEE622, 0xFFFEE622, 0xFFFEE622, 0xFFFEE622, 0xFFFFEB32, 0xFFFCE422, 0xFFFFEB32, 0xFFFCE01C, 0xFFFFEB32, 0xFFFCE422, 0xFFFBE01C, 0xFFFCE01C, 0xFFFBE01C, 
        0xFFF8C11C, 0xFFF8C11C, 0xFFF8C11C, 0xFFFACC1C, 0xFFF5AD1C, 0xFFE6841C, 0xFF8D2E22, 0xFF400022, 0xFF420022, 0xFF3D0022, 0xFF420022, 0xFF3D0022, 0xFF420022, 0xFF4C1527, 0xFF5F3B38, 0x91000000, 0x86000000, 0x7A000000, 0x6B151500, 0x5E000000, 
        0x51000000, 0x46000000, 0x3C000000, 0x34000000, 0x2F000000, 0x29000000, 0x25000000, 0x21000000, 0x1F000000, 0x1C000000, 0x19000000, 0x17000000, 0x15000000, 0x13000000, 0x11000000, 0x0F000000, 0x0D000000, 0x0C000000, 0x0B000000, 0x0A000000, 
        0x09000000, 0x08000000, 0x07000000, 0x07000000, 0x06000000, 0x06000000, 0x05000000, 0x05000000, 0x05000000, 0x04000000, 0x04000000, 0x04000000, 0x03000000, 0x03000000, 0x03000000, 0x03000000, 0x03000000, 0x03000000, 0x03000000, 0x03000000, 
        0x03000000, 0x03000000, 0x03000000, 0x03000000, 0x02000000, 0x02000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFADE12E, 0xFFB3E442, 0xFF9AD646, 0xFFBAE42E, 0xFFD4E62E, 0xFFC8E42E, 0xFF74A422, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xD65C672E, 0xFFA3B12E, 0xFFBAE42E, 0xFF97B446, 0xFFC8E42E, 
        0xFFDAEB42, 0xFFC9EA4C, 0xD2787244, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x05000000, 0x08000000, 0x0C000000, 0x11000000, 0x16000000, 0x1A000000, 0x1C000000, 0x1C000000, 0x1A000000, 0x16000000, 0x77150000, 0xFF3D001C, 
        0xFFC87E1C, 0xFFFEE622, 0xFFFCE01C, 0xFFFCD21C, 0xFFFEE622, 0xFFFEE622, 0xFFFFEB32, 0xFFFEE622, 0xFFFEE622, 0xFFFFE922, 0xFFFEE622, 0xFFFFEB32, 0xFFFFE922, 0xFFFEE622, 0xFFFCE422, 0xFFFFE922, 0xFFFCE422, 0xFFFCE01C, 0xFFFCE01C, 0xFFFCE01C, 
        0xFFFACC1C, 0xFFFACC1C, 0xFFF8C11C, 0xFFFCD21C, 0xFFF5AD1C, 0xFFE6841C, 0xFFC87E1C, 0xFF46001C, 0xFF420022, 0xFF3D001C, 0xFF420022, 0xFF420022, 0xFF38001C, 0xFF4C1527, 0xFF48002B, 0xFF55322E, 0x82000000, 0x74000000, 0x65150000, 0x54000000, 
        0x46000000, 0x3B000000, 0x31000000, 0x27000000, 0x21000000, 0x1C000000, 0x18000000, 0x15000000, 0x13000000, 0x11000000, 0x0F000000, 0x0D000000, 0x0C000000, 0x0A000000, 0x09000000, 0x08000000, 0x07000000, 0x06000000, 0x05000000, 0x05000000, 
        0x04000000, 0x04000000, 0x03000000, 0x03000000, 0x02000000, 0x02000000, 0x02000000, 0x02000000, 0x02000000, 0x02000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 
        0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF98B427, 0xFFADE12E, 0xFFADE12E, 0xFF97D227, 0xFFBAE42E, 0xFFD4E62E, 0xFFADE12E, 0xD2787244, 0x00000000, 0x01000000, 0x01000000, 0x02000000, 0xFF727E3B, 0xFFACC32E, 0xFFACC32E, 0xFFA3B12E, 0xFFDCEA32, 
        0xFFDCEA32, 0xFFADE12E, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x04000000, 0x08000000, 0x0C000000, 0x12000000, 0x19000000, 0x1F000000, 0x24000000, 0x26000000, 0x26000000, 0x22000000, 0x1D000000, 0xC8351500, 0xFF38001C, 
        0xFFD8BE46, 0xFFFFE922, 0xFFF8C11C, 0xFFFCD21C, 0xFFFEE622, 0xFFFEE122, 0xFFFFEB32, 0xFFFFEB32, 0xFFFEE622, 0xFFFFEB32, 0xFFFFEB32, 0xFFFFE922, 0xFFFCE01C, 0xFFFFE922, 0xFFFFE922, 0xFFFEE622, 0xFFFFE922, 0xFFFFE922, 0xFFFCE01C, 0xFFFCD21C, 
        0xFFFCD21C, 0xFFFCD21C, 0xFFFCD21C, 0xFFFCD21C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFC87E1C, 0xFF5A001C, 0xFF420022, 0xFF400022, 0xFF420022, 0xFF400022, 0xFF3D0022, 0xFF48002B, 0xFF400022, 0xFF4C1527, 0xC8351500, 0x71000000, 0x63000000, 0x51000000, 
        0x42000000, 0x34000000, 0x29000000, 0x20000000, 0x19000000, 0x13000000, 0x10000000, 0x0D000000, 0x0B000000, 0x09000000, 0x08000000, 0x07000000, 0x06000000, 0x05000000, 0x04000000, 0x04000000, 0x03000000, 0x02000000, 0x02000000, 0x02000000, 
        0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFB554627, 0xFFACC32E, 0xFFADE12E, 0xFFB3E442, 0xFF97C335, 0xFFC8E42E, 0xFFBAE42E, 0xFF87BA3B, 0x01000000, 0x02000000, 0x03000000, 0x04000000, 0xFF8FA435, 0xFFB9C32E, 0xFF98B427, 0xFFB9C32E, 0xFFDCEA32, 
        0xFFDCEA32, 0xFF83BC22, 0x01000000, 0x01000000, 0x01000000, 0x02000000, 0x04000000, 0x07000000, 0x0C000000, 0x12000000, 0x1A000000, 0x22000000, 0x29000000, 0x2F000000, 0x31000000, 0x2F000000, 0x2A000000, 0x23000000, 0xC8351500, 0xFF3B001C, 
        0xFFC87E1C, 0xFFFEE122, 0xFFF8C11C, 0xFFF8C11C, 0xFFFCD21C, 0xFFFBCB1C, 0xFFFFE922, 0xFFFCE422, 0xFFFEE622, 0xFFFFEB32, 0xFFFFEB32, 0xFFFCE422, 0xFFFCE422, 0xFFFEE122, 0xFFFEE622, 0xFFFCD21C, 0xFFFBE01C, 0xFFFCE422, 0xFFFCD21C, 0xFFFCE01C, 
        0xFFFACC1C, 0xFFFBE01C, 0xFFFCE01C, 0xFFFCD21C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFE6841C, 0xFF7A382B, 0xFF46001C, 0xFF3D0027, 0xFF420022, 0xFF400022, 0xFF420022, 0xFF48002B, 0xFF420022, 0xFF48002B, 0xFF5F3B38, 0x74000000, 0x63000000, 0x54000000, 
        0x44000000, 0x34000000, 0x27000000, 0x1D000000, 0x15000000, 0x0F000000, 0x0B000000, 0x08000000, 0x06000000, 0x05000000, 0x04000000, 0x03000000, 0x02000000, 0x02000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0xFF7D7522, 0xFFADE12E, 0xFFADE12E, 0xFFADE12E, 0xFFACC32E, 0xFFC8E42E, 0xFFADE12E, 0xD2787244, 0x04000000, 0x05000000, 0xCB4A3822, 0xFFA3B12E, 0xFEA8C346, 0xFF8FA435, 0xFFD4E62E, 0xFFD4E62E, 
        0xFFC8E42E, 0x74404022, 0x03000000, 0x02000000, 0x02000000, 0x03000000, 0x74404022, 0xD65C672E, 0xFF727E3B, 0xFF727E3B, 0xFF829544, 0xFF7E9A22, 0xFF7E9A22, 0xFF829544, 0xFF829544, 0xFF727E3B, 0xFF727E3B, 0xD65C672E, 0xFF4C3822, 0xFF2E0015, 
        0xFFC87E1C, 0xFFFCD21C, 0xFFFCD21C, 0xFFF8C11C, 0xFFF8C11C, 0xFFFEE122, 0xFFFCE422, 0xFFFEE622, 0xFFFFEB32, 0xFFFFEB32, 0xFFFFE922, 0xFFFEE622, 0xFFFCE422, 0xFFFEE622, 0xFFFFEB32, 0xFFFCE01C, 0xFFFCD21C, 0xFFFEE622, 0xFFFCD21C, 0xFFFCE01C, 
        0xFFFACC1C, 0xFFFCE01C, 0xFFFCE01C, 0xFFFACC1C, 0xFFF8C11C, 0xFFF5AD1C, 0xFFE6841C, 0xFF902E27, 0xFF4C1527, 0xFF420022, 0xFF420022, 0xFF38001C, 0xFF420022, 0xFF48002B, 0xFF420022, 0xFF48002B, 0xFF48002B, 0xE4553B2B, 0x6A000000, 0x58000000, 
        0x48000000, 0x39000000, 0x2C000000, 0x20000000, 0x17000000, 0x10000000, 0x0B000000, 0x07000000, 0x04000000, 0x03000000, 0x02000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x74404022, 0xFFA3B12E, 0xFFADE12E, 0xFFBAE42E, 0xFF97D227, 0xFFACC32E, 0xFFB9C32E, 0xFF8FA435, 0x06000000, 0x09000000, 0xCB4A3822, 0xFFA3B12E, 0xFF98B427, 0xFFA3B12E, 0xFFD4E62E, 0xFFD4E62E, 
        0xFF97D227, 0x08000000, 0x06000000, 0x74404022, 0xFF606722, 0xFF829544, 0xFF8FA435, 0xFF98B427, 0xFFA3B12E, 0xFFA3B12E, 0xFFACC32E, 0xFFACC32E, 0xFFA3B12E, 0xFFA3B12E, 0xFF8FA435, 0xFF8FA435, 0xFFA3B12E, 0xFF8FA435, 0xFF4C3822, 0xFF2E0015, 
        0xFFA37622, 0xFFFCD21C, 0xFFFCE01C, 0xFFF5AD1C, 0xFFF5AD1C, 0xFFFEE122, 0xFFFCD21C, 0xFFFEE122, 0xFFFFE922, 0xFFFEE622, 0xFFFEE622, 0xFFFEE122, 0xFFFEE622, 0xFFFEE622, 0xFFFCE422, 0xFFFCE01C, 0xFFFBE01C, 0xFFFCE422, 0xFFFCD21C, 0xFFFCE01C, 
        0xFFFCE01C, 0xFFFCD21C, 0xFFFCE422, 0xFFFCD21C, 0xFFFACC1C, 0xFFF8C11C, 0xFFF5AD1C, 0xFF992B22, 0xFF66001C, 0xFF3D0022, 0xFF400022, 0xFF400022, 0xFF420022, 0xFF3D0022, 0xFF3D0022, 0xFF420022, 0xFF48002B, 0xFF4C1527, 0x71000000, 0x63000000, 
        0x51000000, 0x44000000, 0x34000000, 0x27000000, 0x1D000000, 0x14000000, 0x0D000000, 0x08000000, 0x05000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0xFF7D7522, 0xFFADE12E, 0xFFBAE42E, 0xFFADE12E, 0xFF97C335, 0xFFACC32E, 0xFFACC32E, 0x74404022, 0x0E000000, 0xD65C672E, 0xFF98B427, 0xFF85A42B, 0xFFB9C32E, 0xFFD4E62E, 0xFFC8E42E, 
        0xD2787244, 0x74404022, 0xD2787244, 0xFF829544, 0xFFA3B12E, 0xFFB9C32E, 0xFFB9C32E, 0xFFA3B12E, 0xFF8FA435, 0xFFA3B12E, 0xFFA3B12E, 0xFFA3B12E, 0xFFA3B12E, 0xFFACC32E, 0xFFACC32E, 0xFFACC32E, 0xFFACC32E, 0xFEA8C346, 0xFE4C3D22, 0xFF2E0015, 
        0xFF8D2E22, 0xFFFCE422, 0xFFFCD21C, 0xFFF5AD1C, 0xFFF8C11C, 0xFFFBCB1C, 0xFFFCD21C, 0xFFFCE01C, 0xFFFFE922, 0xFFFEE622, 0xFFFEE622, 0xFFFEE122, 0xFFFEE122, 0xFFFCE422, 0xFFFCE01C, 0xFFFCE01C, 0xFFFEE622, 0xFFFBE01C, 0xFFFCE01C, 0xFFFCD21C, 
        0xFFFBE01C, 0xFFFCE01C, 0xFFFBE01C, 0xFFFCD21C, 0xFFFCD21C, 0xFFFACC1C, 0xFFF0C52B, 0xFFA37622, 0xFE8D1C22, 0xFF46001C, 0xFF3D0027, 0xFF400022, 0xFF400022, 0xFF420022, 0xFF420022, 0xFF400022, 0xFF48002B, 0xFF48002B, 0xE4553B2B, 0x6E000000, 
        0x5E000000, 0x4E000000, 0x3F000000, 0x32000000, 0x26000000, 0x1B000000, 0x12000000, 0x0C000000, 0x07000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xFF8FA435, 0xFFBAE42E, 0xFFBAE42E, 0xFF97D227, 0xFF98B427, 0xFFACC32E, 0xF1849C4C, 0x14000000, 0xD65C672E, 0xFF8FA435, 0xFF7E9A22, 0xFFD4E62E, 0xFFD4E62E, 0xFF98B427, 
        0x1A000000, 0xFF98B427, 0xFFDAEB42, 0xFFB9C32E, 0xFFB9C32E, 0xFFB9C32E, 0xFFC8E42E, 0xFFC8E42E, 0xFFC8E42E, 0xFFD4E62E, 0xFFC8E42E, 0xFFD4E62E, 0xFFD4E62E, 0xFFD4E62E, 0xFFC8E42E, 0xFFD4E62E, 0xFFD4E62E, 0xFFD4E62E, 0xFF626735, 0xFF38001C, 
        0xFF66001C, 0xFFFACC1C, 0xFFFCD21C, 0xFFF5AD1C, 0xFFFBCB1C, 0xFFF8C11C, 0xFFF8C11C, 0xFFFCE01C, 0xFFFCE422, 0xFFFCE01C, 0xFFFCE01C, 0xFFFCE01C, 0xFFFEE122, 0xFFFCE01C, 0xFFFCE422, 0xFFFCE01C, 0xFFFFE922, 0xFFFCE422, 0xFFFBE01C, 0xFFFBE01C, 
        0xFFFBE01C, 0xFFFBE01C, 0xFFFBE01C, 0xFFFBE01C, 0xFFFAE632, 0xFFFBE01C, 0xFFFACC1C, 0xFFA37622, 0xFE8D1C22, 0xFF66001C, 0xFF400022, 0xFF3D0022, 0xFF3D0022, 0xFF48002B, 0xFF48002B, 0xFF4C1527, 0xFF46001C, 0xFF4C1527, 0xFF55322E, 0x7A000000, 
        0x6A000000, 0x5D150000, 0x4E000000, 0x3F000000, 0x31000000, 0x25000000, 0x1B000000, 0x12000000, 0x0C000000, 0x07000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xD2787244, 0xFFACC32E, 0xFFBAE42E, 0xFFBAE42E, 0xFF98B427, 0xFFA3B12E, 0xFF98B427, 0x74404022, 0xD65C672E, 0xFF7E9A22, 0xFF829544, 0xFFDAEB42, 0xFFB9C32E, 0x74404022, 
        0xFF7D7522, 0xFF98B427, 0xFFC8E42E, 0xFFDAEB42, 0xFFDCEA32, 0xFFDCEA32, 0xFFDCEA32, 0xFFDCEA32, 0xFFD4E62E, 0xFFD4E62E, 0xFFD4E62E, 0xFFD4E62E, 0xFFDCEA32, 0xFFD4E62E, 0xFFBAE42E, 0xFFB9C32E, 0xFFA3B12E, 0xFF757522, 0xFF55322E, 0xFF420022, 
        0xFF400015, 0xFFD8BE46, 0xFFFEE122, 0xFFFACC1C, 0xFFF8C11C, 0xFFF8C11C, 0xFFF8C11C, 0xFFFCE01C, 0xFFFCE01C, 0xFFFBCB1C, 0xFFFCD21C, 0xFFFCE422, 0xFFFCE01C, 0xFFFCE01C, 0xFFFEE122, 0xFFFCE01C, 0xFFFFEB32, 0xFFFCE422, 0xFFFEE622, 0xFFFBE01C, 
        0xFFFCE422, 0xFFFCE422, 0xFFFCE422, 0xFFFBE01C, 0xFFFAE632, 0xFFFAE632, 0xFFE6841C, 0xFF992B22, 0xFF992B22, 0xFF7A382B, 0xFF5A001C, 0xFF3D0022, 0xFF3D0022, 0xFF400022, 0xFF420022, 0xFF4C1527, 0xFF420022, 0xFF48002B, 0xFF48002B, 0xE4553B2B, 
        0x7A000000, 0x6A000000, 0x5D150000, 0x4E000000, 0x3F000000, 0x31000000, 0x25000000, 0x1A000000, 0x12000000, 0x0B000000, 0x07000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xFF829544, 0xFFBAE42E, 0xFFBAE42E, 0xFFADE12E, 0xFF8FA435, 0xFFA3B12E, 0xFF626B27, 0xD65C672E, 0xFF829544, 0xFF87994C, 0xFFDAEB42, 0xD2787244, 0x8F150000, 
        0xFF8FA435, 0xFF80B122, 0xFFADE12E, 0xFFFCED40, 0xFFDCEA32, 0xFFDCEA32, 0xFFD4E62E, 0xFFB9C32E, 0xFFA3B12E, 0xFFA3B12E, 0xFF89A422, 0xFF829544, 0xFF727E3B, 0xFF626B27, 0xFE4C3D22, 0xFE482B1C, 0xFF663D22, 0xFF5D542B, 0xFF574027, 0xFF420022, 
        0xFF35001C, 0xFFC87E1C, 0xFFFFEB32, 0xFFFEE122, 0xFFF8C11C, 0xFFF5AD1C, 0xFFF8C11C, 0xFFFCD21C, 0xFFFBCB1C, 0xFFFBCB1C, 0xFFFCD21C, 0xFFFCD21C, 0xFFFCD21C, 0xFFFCD21C, 0xFFFCE422, 0xFFFCD21C, 0xFFFCE01C, 0xFFFEE622, 0xFFFBE01C, 0xFFFBE01C, 
        0xFFFBE01C, 0xFFFCE422, 0xFFFBE01C, 0xFFFEE622, 0xFFFAE632, 0xFFFACC1C, 0xFFA37622, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFF66001C, 0xFF4C1527, 0xFF3D0027, 0xFF48002B, 0xFF420022, 0xFF420022, 0xFF48002B, 0xFF46001C, 0xFF48002B, 0xFF55322E, 
        0x85150000, 0x7A000000, 0x6A000000, 0x5D150000, 0x4E000000, 0x3E000000, 0x31000000, 0x24000000, 0x19000000, 0x11000000, 0x0A000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xCB4A3822, 0xD65C672E, 0xD2787244, 0xD65C672E, 0xFF6F5A22, 0xFF829544, 0xFFACC32E, 0xFFB9C32E, 0xFF98B427, 0xFF8FA435, 0xFF829544, 0xFF5D542B, 0xFF757522, 0xFF8FA435, 0xFEA8C346, 0x4E000000, 0xFF829544, 
        0xFFD4E62E, 0xFF97C335, 0xFF9AD646, 0xFFC8E42E, 0xFFC9EA4C, 0xFF626B27, 0xFF574027, 0xFE482B1C, 0xFE482B1C, 0xFE503227, 0xFF4C3822, 0xFF482222, 0xFF4C3822, 0xFE4C3D22, 0xFF595422, 0xFF5D542B, 0xFF5D542B, 0xFF5A3D22, 0xFE503227, 0xFF48002B, 
        0xFF35001C, 0xFF7A382B, 0xFFFCD21C, 0xFFFFEB32, 0xFFFCD21C, 0xFFF5AD1C, 0xFFF5AD1C, 0xFFF8C11C, 0xFFF8C11C, 0xFFF8C11C, 0xFFFBCB1C, 0xFFFBCB1C, 0xFFFCD21C, 0xFFFCD21C, 0xFFFCD21C, 0xFFFCD21C, 0xFFFCD21C, 0xFFFCE422, 0xFFFCE01C, 0xFFFBE01C, 
        0xFFFAE632, 0xFFFCE422, 0xFFFAE632, 0xFFFFEB32, 0xFFFBE01C, 0xFFC87E1C, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF902E27, 0xFE8D1C22, 0xFF66001C, 0xFF46001C, 0xFF3D0022, 0xFF420022, 0xFF420022, 0xFF48002B, 0xFF420022, 0xFF48002B, 0xFF55322E, 
        0x8F000000, 0x85150000, 0x7A000000, 0x6A000000, 0x5B000000, 0x4E000000, 0x3C000000, 0x2F000000, 0x22000000, 0x18000000, 0x0F000000, 0x09000000, 0x05000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF9AD646, 0xFF9AD646, 0xFF97C335, 0xFF97C335, 0xFF97B446, 0xFF85A42B, 0xFF69862B, 0xFF626B27, 0xFF7D7522, 0xFF829544, 0xFF8FA435, 0xFF626B27, 0xFF757522, 0xFFACC32E, 0xFF69862B, 0xFF8E8140, 0xFFD4E62E, 
        0xFFD4E62E, 0xFF8FA435, 0xFF97D227, 0xFFB3E442, 0xFFDAEB42, 0xFF69862B, 0xFF4C3822, 0xFE503227, 0xFE482B1C, 0xFE503227, 0xFF5F3B38, 0xFF5F3B38, 0xFF574027, 0xFE503227, 0xFE482B1C, 0xFF482222, 0xFF574027, 0xFF574027, 0xFF55322E, 0xFF4C1527, 
        0xFF35001C, 0xFF46001C, 0xFFC87E1C, 0xFFFAE632, 0xFFFFE922, 0xFFF8C11C, 0xFFF5AD1C, 0xFFF8C11C, 0xFFF8C11C, 0xFFF8C11C, 0xFFF8C11C, 0xFFFBCB1C, 0xFFFACC1C, 0xFFFACC1C, 0xFFFCD21C, 0xFFFCD21C, 0xFFFCE01C, 0xFFFCE01C, 0xFFFCE422, 0xFFFAE632, 
        0xFFFCED40, 0xFFFCED40, 0xFFFCED40, 0xFFFAE632, 0xFFC87E1C, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFF7A382B, 0xFF5A001C, 0xFF420022, 0xFF3D0022, 0xFF400022, 0xFF400022, 0xFF420022, 0xFF48002B, 0xFF48002B, 
        0xC8351500, 0x8F000000, 0x85150000, 0x77000000, 0x6A000000, 0x5B000000, 0x4A000000, 0x3B000000, 0x2C000000, 0x20000000, 0x16000000, 0x0E000000, 0x08000000, 0x04000000, 0x74404022, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFC8E42E, 0xFFBAE42E, 0xFFBAE42E, 0xFFC8E42E, 0xFFBAE42E, 0xFFC8E42E, 0xFFC8E42E, 0xFFB3E442, 0xFF87BA3B, 0xFF626B27, 0xFF757522, 0xFF8FA435, 0xFF829544, 0xFFACC32E, 0xFF8E8140, 0xFFC8E42E, 0xFF8FA435, 
        0xFF606722, 0xFF727E3B, 0xFF8CC92B, 0xFFADE12E, 0xFFC8E42E, 0xFFD4ED6D, 0xFF97B446, 0xFF98B427, 0xFF85A42B, 0xFF85A42B, 0xFF85A42B, 0xFF7E9A22, 0xFF7E9A22, 0xFF69862B, 0xFF6F7822, 0xFF5D542B, 0xFF4C3822, 0xFF482222, 0xFF55322E, 0xFE503227, 
        0xFF3D001C, 0xFF350015, 0xFF5A001C, 0xFFC87E1C, 0xFFFCED40, 0xFFFFE922, 0xFFFCD21C, 0xFFF8C11C, 0xFFF8C11C, 0xFFFBCB1C, 0xFFFACC1C, 0xFFFCD21C, 0xFFF8C11C, 0xFFF8C11C, 0xFFFCE01C, 0xFFFCE422, 0xFFFCE422, 0xFFFFE922, 0xFFFFEB32, 0xFFFCED40, 
        0xFFFCED40, 0xFFFCED40, 0xFFF0C52B, 0xFFC87E1C, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF7A382B, 0xFF66001C, 0xFF5A001C, 0xFF3D001C, 0xFF3D001C, 0xFF420022, 0xFF400022, 0xFF400022, 0xFF420022, 
        0xE6502222, 0x96000000, 0x8F000000, 0x85150000, 0x77000000, 0x67000000, 0x58000000, 0x48000000, 0x37000000, 0xD65C672E, 0xD65C672E, 0xCB4A3822, 0x0B000000, 0x74404022, 0xFF89A650, 0xFF5D542B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF97D227, 0xFFACC32E, 0xFFACC32E, 0xFFACC32E, 0xFEA8C346, 0xFF97C335, 0xFFACC32E, 0xFFACC32E, 0xFFACC32E, 0xFFACC32E, 0xFF8FA435, 0xFF8FA435, 0xFFACC32E, 0xFFBAE42E, 0xFFC8E42E, 0xFEA8C346, 0xFF8FA435, 
        0xFF98B427, 0xFF97C335, 0xFF8CC92B, 0xFF9AD646, 0xFFADE12E, 0xFFDAEB42, 0xFFC9EA4C, 0xFFACC32E, 0xFF97C335, 0xFF97C335, 0xFF97C335, 0xFF97C335, 0xFF97C335, 0xFF97C335, 0xFF97C335, 0xFF80B122, 0xFF7E9A22, 0xFF69862B, 0xFF606722, 0xFE503227, 
        0xFF420022, 0xFF2E0015, 0xFF46001C, 0xFF7A382B, 0xFFF5AD1C, 0xFFFAE632, 0xFFFCED40, 0xFFFEE622, 0xFFFCE01C, 0xFFFCD21C, 0xFFFACC1C, 0xFFFACC1C, 0xFFFCD21C, 0xFFFCD21C, 0xFFFAE632, 0xFFFCED40, 0xFFFCED40, 0xFFFCED40, 0xFFFCED40, 0xFFFCED40, 
        0xFFFAE632, 0xFFE6841C, 0xFFC87E1C, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFE8D1C22, 0xFF7A382B, 0xFF66001C, 0xFF420022, 0xFF38001C, 0xFF3D001C, 0xFF3D0022, 0xFF420022, 0xFF3D001C, 
        0xEA3D1515, 0x9C000000, 0x96000000, 0x8C000000, 0x82000000, 0x74000000, 0x65150000, 0x54000000, 0xA6444222, 0xFF89A650, 0xFF89A650, 0xFF69862B, 0xFF626735, 0xFF97B446, 0xFF84AE4C, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFDAEB42, 0xFFDCEA32, 0xFFDCEA32, 0xFFDAEB42, 0xFFDAEB42, 0xFFDAEB42, 0xFFDAEB42, 0xFFD4E62E, 0xFFC8E42E, 0xFFB9C32E, 0xFFB9C32E, 0xFFD4E62E, 0xFFC8E42E, 0xFFD4E62E, 0xFFC8E42E, 0xFFBAE42E, 0xFFBAE42E, 
        0xFFADE12E, 0xFF97D227, 0xFF87BA3B, 0xFF9AD646, 0xFF97D227, 0xFFC8E42E, 0xFFF5F07A, 0xFFDAEB42, 0xFFD4E62E, 0xFFC8E42E, 0xFFC8E42E, 0xFFB9C32E, 0xFFB9C32E, 0xFFACC32E, 0xFFACC32E, 0xFF97C335, 0xFF97C335, 0xFEA8C346, 0xFF98B427, 0xFF80B122, 
        0xFF69862B, 0xFE4A3B1C, 0xFF380015, 0xFF66001C, 0xFF992B22, 0xFFE6841C, 0xFFFACC1C, 0xFFFCED40, 0xFFFCED40, 0xFFFCED40, 0xFFFCE422, 0xFFFEE122, 0xFFFAE632, 0xFFFCED40, 0xFFF0C52B, 0xFFFACC1C, 0xFFFCD21C, 0xFFFCD21C, 0xFFF0C52B, 0xFFF5AD1C, 
        0xFFC87E1C, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFF7A382B, 0xFF66001C, 0xFF4C1527, 0xFF3D0022, 0xFF38001C, 0xFF3D001C, 0xFF4C1527, 0xFF3D001C, 
        0xFF4C1527, 0xA0000000, 0x9C000000, 0x95000000, 0x8C000000, 0x7F000000, 0x71000000, 0x61150000, 0xA6444222, 0x3E000000, 0x74404022, 0xFF97B446, 0xFF829544, 0xFF9AD646, 0xFF84AE4C, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFDCEA32, 0xFFDAEB42, 0xFFDAEB42, 0xFFDCEA32, 0xFFDCEA32, 0xFFDCEA32, 0xFFDCEA32, 0xFFDCEA32, 0xFFDCEA32, 0xFFDCEA32, 0xFFDCEA32, 0xFFC8E42E, 0xFF7E9A22, 0xFFAD8722, 0xFF98B427, 0xFB554627, 0xFF6F5A22, 
        0xFFB9C32E, 0xFFBAE42E, 0xFF83BC22, 0xFF97D227, 0xFF7ECA27, 0xFFADE12E, 0xFFDAEB42, 0xFFF5F07A, 0xFFDCEA32, 0xFFFCED40, 0xFFFCED40, 0xFFDCEA32, 0xFFFCED40, 0xFFFCED40, 0xFFFCED40, 0xFFFCED40, 0xFFFCED40, 0xFFFCED40, 0xFFFCED40, 0xFFDAEB42, 
        0xFFD4E62E, 0xFFB9C32E, 0xFF7E9A22, 0xFF482222, 0xFF7A382B, 0xFF992B22, 0xFFA37622, 0xFFE6841C, 0xFFF5AD1C, 0xFFFAE632, 0xFFFCED40, 0xFFFCED40, 0xFFFAE632, 0xFFD8BE46, 0xFF992B22, 0xFF992B22, 0xFFC87E1C, 0xFFC87E1C, 0xFFA37622, 0xFF992B22, 
        0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFE8D1C22, 0xFE8D1C22, 0xFF7A382B, 0xFF66001C, 0xFF5A001C, 0xFF3D001C, 0xFF3D0022, 0xFF3D001C, 0xFF3D001C, 0xFF420022, 
        0xFF46001C, 0xA3000000, 0xA0000000, 0x9A000000, 0x93000000, 0x8A000000, 0x7C000000, 0x6B151500, 0x5B000000, 0xFF727E3B, 0xFF97B446, 0xFF84AE4C, 0xFF829544, 0xFF84AE4C, 0xFF97B446, 0xFF97B446, 0xFF97B446, 0xD2787244, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xFF8FA435, 0xFFB9C32E, 0xFFC8E42E, 
        0xFFB9C32E, 0xFF98B427, 0xFF727E3B, 0x74404022, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFDCEA32, 0xFFDCEA32, 0xFFDCEA32, 0xFFDAEB42, 0xFFDAEB42, 0xFFDAEB42, 0xFFDAEB42, 0xFFDCEA32, 0xFFDAEB42, 0xFFC9EA4C, 0xFEA8C346, 0xFF6F7822, 0xFF4C3822, 0xFF896D22, 0xFFB9C32E, 0xFF87994C, 0xFF574027, 
        0xFF482222, 0xFF8E8140, 0xFF85A42B, 0xFF7ECA27, 0xFF97D227, 0xFF97C335, 0xFFD4E62E, 0xFFDAEB42, 0xFFF5F07A, 0xFFDCEA32, 0xFFDCEA32, 0xFFDCEA32, 0xFFDCEA32, 0xFFDCEA32, 0xFFDAEB42, 0xFFD4E62E, 0xFFB9C32E, 0xFFB9C32E, 0xFF8FA435, 0xFF7D7522, 
        0xFF757522, 0xFF6F5A22, 0xFF7D7522, 0xFF626735, 0xFF4C1527, 0xFF7A382B, 0xFE8D1C22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFFC87E1C, 0xFFC87E1C, 0xFFA37622, 0xFF902E27, 0xFF7A382B, 0xFF7A382B, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 
        0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFE8D1C22, 0xFF7A382B, 0xFE8D1C22, 0xFF7A382B, 0xFF66001C, 0xFF3D001C, 0xFF400022, 0xFF3D001C, 0xFF3D001C, 0xFF420022, 
        0xFF420022, 0xEA3D1515, 0xA3000000, 0x9F000000, 0xCB4A3822, 0xD2787244, 0xF1849C4C, 0xD2787244, 0xD2787244, 0xFF84AE4C, 0xFF727E3B, 0xFF97B446, 0xFF84AE4C, 0xFF84AE4C, 0xFF89A650, 0xF1849C4C, 0x74404022, 0x74404022, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xFF8FA435, 0xFFB9C32E, 0xFFB9C32E, 0xFFB9C32E, 
        0xFFB9C32E, 0xFFB9C32E, 0xFFA3B12E, 0xF1849C4C, 0x74404022, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF98B427, 0xFFACC32E, 0xFFACC32E, 0xFFACC32E, 0xFFACC32E, 0xFFACC32E, 0xFFC8E42E, 0xFFC9EA4C, 0xFFBAE42E, 0xFFADE12E, 0xFF97B446, 0xFF6F7822, 0xFF4C3822, 0xFF896D22, 0xFFD4E62E, 0xFFACC32E, 0xFF8E8140, 
        0xFF5D542B, 0xFF420022, 0xFF5D542B, 0xFF83BC22, 0xFF7ECA27, 0xFF83BC22, 0xFFACC32E, 0xFFC8E42E, 0xFFF5F07A, 0xFF97B446, 0xFF7D7522, 0xFF6F5A22, 0xFF595422, 0xFF5A3D22, 0xFF6F5A22, 0xFF5D542B, 0xFF574027, 0xFF574027, 0xFF574027, 0xFB554627, 
        0xFF595422, 0xFE4C3D22, 0xFF4C3822, 0xFF3D0022, 0xFF3B001C, 0xFF5A001C, 0xFF7A382B, 0xFE8D1C22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFE8D1C22, 0xFF7A382B, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 
        0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF902E27, 0xFE8D1C22, 0xFE8D1C22, 0xFF7A382B, 0xFF7A382B, 0xFF66001C, 0xFF46001C, 0xFF3D001C, 0xFF3D0015, 0xFF3D001C, 0xFF3D001C, 
        0xFF4C1527, 0xEA3D1515, 0xE4553B2B, 0xFF595422, 0xFF6F7822, 0xFF87994C, 0xFF97B446, 0xFF97B446, 0xFF97B446, 0xFFA3B12E, 0xFF89A650, 0xFF84AE4C, 0xFF6F5A22, 0xFF829544, 0xFF829544, 0xFF97B446, 0xFEA8C346, 0xF1849C4C, 0xD2787244, 0xD2787244, 
        0xD2787244, 0xD2787244, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xFF7F7B42, 0xFF8FA435, 0xFFA3B12E, 0xFFA3B12E, 0xFFA3B12E, 0xFF8FA435, 
        0xFF87994C, 0xFF8FA435, 0xFFAD8722, 0xFFA3B12E, 0xFF8FA435, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF757522, 0xFF6F7822, 0xFF6F7822, 0xFF606722, 0xFF829544, 0xFFC8E42E, 0xFFC9EA4C, 0xFFC9EA4C, 0xFFBAE42E, 0xFFBAE42E, 0xFFC8E42E, 0xFFC9EA4C, 0xFFB9C32E, 0xFF8FA435, 0xFFD4E62E, 0xFFD4E62E, 0xFF98B427, 
        0xFF8E8140, 0xFF595422, 0xFF5D542B, 0xFF80B122, 0xFF7ECA27, 0xFF7ECA27, 0xFF98B427, 0xFFC8E42E, 0xFFDAEB42, 0xFFD4ED6D, 0xFF5D542B, 0xFE482B1C, 0xFF3B151C, 0xFF400015, 0xFF595422, 0xFF606722, 0xFF574027, 0xFF574027, 0xFE503227, 0xFF4C3822, 
        0xFF574027, 0xFF595422, 0xFF574027, 0xFF4C3822, 0xFF3B151C, 0xFF46001C, 0xFF5A001C, 0xFF7A382B, 0xFE8D1C22, 0xFF992B22, 0xFF992B22, 0xFF902E27, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFE8D1C22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 
        0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFE8D1C22, 0xFE8D1C22, 0xFF992B22, 0xFE8D1C22, 0xFF7A382B, 0xFF66001C, 0xFF4C1527, 0xFF38001C, 0xFF3D001C, 0xFF482222, 0xFE503227, 
        0xFF604022, 0xFF655522, 0xFF757522, 0xFF757522, 0xFF757522, 0xFF7D7522, 0xFF7F7B42, 0xFF7D7522, 0xFF87994C, 0xFF829544, 0xFF87994C, 0xFF626B27, 0xFF655522, 0xFF6F5A22, 0xFF8FA435, 0xFF8FA435, 0xFF8FA435, 0xFF89A422, 0xFF8FA435, 0xFF8FA435, 
        0xFFA3B12E, 0xFFA3B12E, 0xFF98B427, 0xFF8FA435, 0xD2787244, 0x03000000, 0x03000000, 0x02000000, 0x02000000, 0x01000000, 0x01000000, 0x74404022, 0xD2787244, 0xFFA3B12E, 0xFFA3B12E, 0xFFA3B12E, 0xFF87994C, 0xFF8FA435, 0xFF8FA435, 0xFF87994C, 
        0xFF87994C, 0xFF8E8140, 0xFF8E8140, 0xFF8E8140, 0xFFA3B12E, 0xD2787244, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF7F7B42, 0xFF727E3B, 0xFF85A42B, 0xFF85A42B, 0xFFC8E42E, 0xFFC9EA4C, 0xFFBAE42E, 0xFFB3E442, 0xFFC9EA4C, 0xFFDAEB42, 0xFFDAEB42, 0xFFF5F07A, 0xFFF5F07A, 0xFFF5F07A, 0xFFF5F07A, 0xFFDCEA32, 0xFFC8E42E, 
        0xFF829544, 0xFF7D7522, 0xFF5D542B, 0xFF7E9A22, 0xFF83BC22, 0xFF7ECA27, 0xFF80B122, 0xFFBAE42E, 0xFFC9EA4C, 0xFFF5F07A, 0xFF89A650, 0xFF5A3D22, 0xFF574027, 0xFF4C3822, 0xFF595422, 0xFF626735, 0xFF574027, 0xFF574027, 0xFF5D542B, 0xFF6F7822, 
        0xFF829544, 0xFF89A650, 0xFF97B446, 0xFF97B446, 0xFF89A650, 0xFF87994C, 0xFF6F7822, 0xFF655522, 0xFF66001C, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFE8D1C22, 0xFE8D1C22, 0xFF902E27, 0xFF992B22, 
        0xFF902E27, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFE8D1C22, 0xFE8D1C22, 0xFE8D1C22, 0xFE8D1C22, 0xFE8D1C22, 0xFF7A382B, 0xFF5A001C, 0xFF4C1527, 0xFF482222, 0xFF5A3D22, 0xFF663D22, 0xFF6F5A22, 
        0xFF757522, 0xFF6F5A22, 0xFF626735, 0xFF655522, 0xFF6F5A22, 0xFF757522, 0xFF6F5A22, 0xFF7D7522, 0xFF757522, 0xFF757522, 0xFF757522, 0xFF6F5A22, 0xFF6F5A22, 0xFF7D7522, 0xFF8E8140, 0xFF8FA435, 0xFF829544, 0xFF6F7822, 0xFF757522, 0xFF8E8140, 
        0xFF829544, 0xFF8E8140, 0xFF8FA435, 0xFFA3B12E, 0xFF98B427, 0xFF829544, 0xFF829544, 0xFF829544, 0xFF98B427, 0xFF98B427, 0xFF98B427, 0xFFA3B12E, 0xFFACC32E, 0xFFA3B12E, 0xFF8FA435, 0xFF8FA435, 0xFF829544, 0xFF7D7522, 0xFF87994C, 0xFF7F7B42, 
        0xFF7F7B42, 0xFF896D22, 0xFF7F7B42, 0xFF83573D, 0xFFAD8722, 0xFF8FA435, 0x74404022, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFADE12E, 0xFF97C335, 0xFF7E9A22, 0xFFB9C32E, 0xFFC9EA4C, 0xFFADE12E, 0xFFB3E442, 0xFFDAEB42, 0xFFDAEB42, 0xFFDAEB42, 0xFFC9EA4C, 0xFEA8C346, 0xFF8FA435, 0xFF87994C, 0xFF8FA435, 0xFFB9C32E, 0xFFC8E42E, 
        0xFFACC32E, 0xFF8E8140, 0xFF655522, 0xFF626B27, 0xFF83BC22, 0xFF83BC22, 0xFF83BC22, 0xFF97C335, 0xFFC8E42E, 0xFFDAEB42, 0xFCBEC678, 0xFF604022, 0xFF574027, 0xFF574027, 0xFF574027, 0xFF4C3822, 0xFF5D542B, 0xFF8FA435, 0xFF9AD646, 0xFFBAE42E, 
        0xFFC9EA4C, 0xFFD4ED6D, 0xFFD4ED6D, 0xFFF5F07A, 0xFFF5F07A, 0xFFF5F07A, 0xFFF5F07A, 0xFFD4ED6D, 0xFCBEC678, 0xFF8FA435, 0xFF902E27, 0xFF902E27, 0xFF992B22, 0xFF992B22, 0xFF902E27, 0xFE8D1C22, 0xFF66001C, 0xFF7A382B, 0xFE8D1C22, 0xFF992B22, 
        0xFF902E27, 0xFF902E27, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFE8D1C22, 0xFE8D1C22, 0xFE8D1C22, 0xFF7A382B, 0xFF66001C, 0xFF4C1527, 0xFF5A3D22, 0xFF655522, 0xFF6F5A22, 0xFF6F5A22, 0xFF655522, 
        0xFF757522, 0xFF6F5A22, 0xFF6F7822, 0xFF6F5A22, 0xFF6F5A22, 0xFF7D7522, 0xFF757522, 0xFF7D7522, 0xFF7D7522, 0xFF6F5A22, 0xFF655522, 0xFF6F5A22, 0xFF7D7522, 0xFF8E8140, 0xFF6F5A22, 0xFF7D7522, 0xFF8E8140, 0xFF757522, 0xFF5D542B, 0xFF7D7522, 
        0xFF7D7522, 0xFF7D7522, 0xFF7D7522, 0xFF8FA435, 0xFF8E8140, 0xFF8FA435, 0xFF8FA435, 0xFF8FA435, 0xFF8FA435, 0xFF98B427, 0xFF8FA435, 0xFFB9C32E, 0xFF8FA435, 0xFF87994C, 0xFF8E8140, 0xFF8FA435, 0xFF829544, 0xFF626735, 0xFF8E8140, 0xFF6F5A22, 
        0xFF6F5A22, 0xFF7A382B, 0xFF6F5A22, 0xFF655522, 0xFF896D22, 0xFF8E8140, 0xD2787244, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x02000000, 0x02000000, 0x02000000, 0x01000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFADE12E, 0xFFB3E442, 0xFF97C335, 0xFFBAE42E, 0xFFADE12E, 0xFFBAE42E, 0xFFD4ED6D, 0xFFD4ED6D, 0xFEA8C346, 0xFF87994C, 0xFF757522, 0xFF5D542B, 0xFF727E3B, 0xFF626B27, 0xFF5D542B, 0xFF595422, 0xFF655522, 
        0xFF8E8140, 0xFF829544, 0xFF7D7522, 0xFE4C3D22, 0xFF74A422, 0xFF83BC22, 0xFF83BC22, 0xFF7DAF2B, 0xFFBAE42E, 0xFFD4E62E, 0xFFD4ED6D, 0xFF69862B, 0xFF574027, 0xFF574027, 0xFF5D542B, 0xFF6F5A22, 0xFFACC32E, 0xFFBAE42E, 0xFFBAE42E, 0xFFBAE42E, 
        0xFFC9EA4C, 0xFFF5F07A, 0xFFF5F07A, 0xFFF5F07A, 0xFFF5F07A, 0xFCBEC678, 0xFF829544, 0xFF5D542B, 0xFF655522, 0xFF7F7B42, 0xFF8E8140, 0xFF896D22, 0xFF902E27, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFF7A382B, 0xFF7A382B, 0xFE8D1C22, 0xFF992B22, 
        0xFF992B22, 0xFE8D1C22, 0xFE8D1C22, 0xFF902E27, 0xFF992B22, 0xFE8D1C22, 0xFF902E27, 0xFE8D1C22, 0xFF7D626D, 0xFF837278, 0xFF66001C, 0xFF66001C, 0xFF55322E, 0xFF5A3D22, 0xFF6F5A22, 0xFF6F5A22, 0xFF6F5A22, 0xFF6F5A22, 0xFF757522, 0xFF6F5A22, 
        0xFF6F5A22, 0xFF7D7522, 0xFF757522, 0xFF6F5A22, 0xFF655522, 0xFF6F5A22, 0xFF6F5A22, 0xFF7D7522, 0xFF757522, 0xFF604022, 0xFF604022, 0xFF6F5A22, 0xFF6F5A22, 0xFF6F5A22, 0xFF6F5A22, 0xFF7D7522, 0xFF757522, 0xFF7D7522, 0xFF5D542B, 0xFF5A3D22, 
        0xFF6F5A22, 0xFF6F5A22, 0xFF7D7522, 0xFF7D7522, 0xFF7F7B42, 0xFF7D7522, 0xFF7F7B42, 0xFF7F7B42, 0xFF8E8140, 0xFF8E8140, 0xFF7D7522, 0xFF8E8140, 0xFF7D7522, 0xFF7D7522, 0xFF6F5A22, 0xFFAD8722, 0xFF7F7B42, 0xFF6F5A22, 0xFF896D22, 0xFF6F5A22, 
        0xFF5F3B38, 0xFF5F3B38, 0xFF55322E, 0xFF5F3B38, 0xFF6F5A22, 0xFF83573D, 0xD2787244, 0x02000000, 0x03000000, 0x04000000, 0x04000000, 0x04000000, 0x05000000, 0x04000000, 0x04000000, 0x03000000, 0x02000000, 0x02000000, 0x01000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFB3E442, 0xFFB3E442, 0xFFACC32E, 0xFFBAE42E, 0xFFADE12E, 0xFFC9EA4C, 0xFFBAE42E, 0xFF69862B, 0xFF635248, 0xFF6F5A22, 0xFF5A3D22, 0xFF400022, 0xFF606722, 0xFF7E9A22, 0xFF69862B, 0xFF626735, 0xFF595422, 
        0xFF574027, 0xFFAD8722, 0xFF7F7B42, 0xFF606722, 0xFF627D27, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF98B427, 0xFFBAE42E, 0xFFDAEB42, 0xFCBEC678, 0xFE503227, 0xFF574027, 0xFF6F5A22, 0xFF97C335, 0xFFADE12E, 0xFFACC32E, 0xFFACC32E, 0xFFC8E42E, 
        0xFFD4ED6D, 0xFFD4ED6D, 0xFFF5F07A, 0xFFD4ED6D, 0xFF727E3B, 0xFF626735, 0xFF626735, 0xFE4C3D22, 0xFF38001C, 0xFF46001C, 0xFF4C1527, 0xFF7A382B, 0xFE8D1C22, 0xFE8D1C22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFF7A382B, 0xFF7A382B, 0xFE8D1C22, 
        0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFF992B22, 0xFE8D1C22, 0xFF7D626D, 0xFF7D626D, 0xFF7D626D, 0xFFC2BEC6, 0xFF4C3822, 0xFF574027, 0xFE503227, 0xFF5A3D22, 0xFF604022, 0xFF606722, 0xFF6F5A22, 0xFF6F5A22, 0xFF6F7822, 0xFF6F5A22, 
        0xFF757522, 0xFF7D7522, 0xFF626B27, 0xFF757522, 0xFF606722, 0xFF655522, 0xFF757522, 0xFF7D7522, 0xFF606722, 0xFF5A3D22, 0xFF574027, 0xFF604022, 0xFF604022, 0xFF6F5A22, 0xFF5A3D22, 0xFF7D7522, 0xFF6F5A22, 0xFF574027, 0xFF55322E, 0xFF5A3D22, 
        0xFF5A3D22, 0xFF604022, 0xFF7D7522, 0xFF7D7522, 0xFF757522, 0xFF5D542B, 0xFF757522, 0xFF757522, 0xFF6F5A22, 0xFF7D7522, 0xFF757522, 0xFF896D22, 0xFF6F5A22, 0xFF896D22, 0xFF757522, 0xFF8E8140, 0xFF7F7B42, 0xFF5A3D22, 0xFF6F5A22, 0xFE503227, 
        0xFF604022, 0xE4553B2B, 0xD2787244, 0xFF574027, 0xFF5F3B38, 0xFF6F5A22, 0xD2787244, 0x05000000, 0x07000000, 0x08000000, 0x09000000, 0x09000000, 0x0A000000, 0x09000000, 0x08000000, 0x07000000, 0x05000000, 0x04000000, 0x03000000, 0x01000000, 
        0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFADE12E, 0xFF9AD646, 0xFFACC32E, 0xFF9AD646, 0xFFC9EA4C, 0xFFB3E442, 0xFF97C335, 0xFF69862B, 0xFF574027, 0xFF6F5A22, 0xFF482222, 0xFF3D001C, 0xFE503227, 0xFF69862B, 0xFF69862B, 0xFF69862B, 0xFF7F7B42, 
        0xFF7E9A22, 0xFF89A422, 0xFF7E9A22, 0xFF7E9A22, 0xFF606722, 0xFF74A422, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF85A42B, 0xFFC8E42E, 0xFFDAEB42, 0xFFB6E45F, 0xFE4C3D22, 0xFF574027, 0xFF7F7B42, 0xFF97C335, 0xFF97C335, 0xFF97C335, 0xFFB9C32E, 0xFFDAEB42, 
        0xFFD4ED6D, 0xFFD4ED6D, 0xFFD4ED6D, 0xFF727E3B, 0xFF5D542B, 0xFE4C3D22, 0xFE4C3D22, 0xFF5D542B, 0xFE4C3D22, 0xFF38001C, 0xFF3B001C, 0xFF5A001C, 0xFF66001C, 0xFF7A382B, 0xFE8D1C22, 0xFE8D1C22, 0xFF902E27, 0xFF7A382B, 0xFF7A382B, 0xFE8D1C22, 
        0xFE8D1C22, 0xFF992B22, 0xFF7A382B, 0xFE8D1C22, 0xFF66001C, 0xFF5A001C, 0xFF705957, 0xFF908494, 0xFF62404A, 0xFF908494, 0xFF595422, 0xFF5D542B, 0xFF5A3D22, 0xFF655522, 0xFF604022, 0xFF6F5A22, 0xFF626B27, 0xFF655522, 0xFF7D7522, 0xFF6F7822, 
        0xFF6F5A22, 0xFF7D7522, 0xFF655522, 0xFF6F5A22, 0xFF757522, 0xFE503227, 0xFF604022, 0xFF6F5A22, 0xFF757522, 0xFF46001C, 0xFE503227, 0xFF46001C, 0xFF4C1527, 0xFF5A3D22, 0xFF46001C, 0xFF663D22, 0xFF604022, 0xFF4C1527, 0xFF420022, 0xFF5A3D22, 
        0xFF604022, 0xFF604022, 0xFF6F5A22, 0xFF7D7522, 0xFF6F5A22, 0xFF4C3822, 0xFF655522, 0xFF626B27, 0xFF655522, 0xFF6F5A22, 0xFF757522, 0xFF6F5A22, 0xFF6F5A22, 0xFF6F5A22, 0xFF6F5A22, 0xFF83573D, 0xFF6F5A22, 0xFF4C1527, 0xFF6F5A22, 0xCB4A3822, 
        0x01000000, 0x02000000, 0x02000000, 0x03000000, 0xFF655522, 0xFF5F3B38, 0xD65C672E, 0x0B000000, 0x0D000000, 0x0F000000, 0x11000000, 0x12000000, 0x12000000, 0x11000000, 0x0F000000, 0x0D000000, 0x0A000000, 0x08000000, 0x05000000, 0x03000000, 
        0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF7E9A22, 0xFF7E9A22, 0xFFACC32E, 0xFFADE12E, 0xFFBAE42E, 0xFF7E9A22, 0xFF829544, 0xFF85A42B, 0xFF595422, 0xFF5D542B, 0xFF574027, 0xFF626B27, 0xFF7E9A22, 0xFF98B427, 0xFFACC32E, 0xFFACC32E, 0xFEA8C346, 
        0xFFA3B12E, 0xFF98B427, 0xFF98B427, 0xFF98B427, 0xFF627D27, 0xFF627D27, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF7DAF2B, 0xFFACC32E, 0xFFC8E42E, 0xFFD4ED6D, 0xFF627D27, 0xFF574027, 0xFF7E9A22, 0xFF85A42B, 0xFF98B427, 0xFF97C335, 0xFFD4E62E, 0xFFDAEB42, 
        0xFFD4ED6D, 0xFFD4ED6D, 0xFF727E3B, 0xFE482B1C, 0xFF3D001C, 0xFF574027, 0xFF626735, 0xFF574027, 0xFF574027, 0xFF4C3822, 0xFF3D001C, 0xFF3D001C, 0xFF4C1527, 0xFF66001C, 0xFF7A382B, 0xFF7A382B, 0xFE8D1C22, 0xFF7A382B, 0xFF66001C, 0xFF5A001C, 
        0xFF66001C, 0xFF66001C, 0xFE503227, 0xFF4C1527, 0xFF46001C, 0xFD461C22, 0xFF62404A, 0xFF908494, 0xFF55322E, 0xFF908494, 0xFF626735, 0xFF5D542B, 0xFF606722, 0xFF655522, 0xFF5A3D22, 0xFF6F5A22, 0xFF6F5A22, 0xFF6F5A22, 0xFF7D7522, 0xFF757522, 
        0xFF655522, 0xFF8E8140, 0xFF6F5A22, 0xFF604022, 0xFF7D7522, 0xFF574027, 0xFF574027, 0xFF6F5A22, 0xFF757522, 0xFF46001C, 0xFF4C1527, 0xFF46001C, 0xFF4C1527, 0xFF482222, 0xFF3D001C, 0xFE503227, 0xFF482222, 0xFF420022, 0xFF46001C, 0xFF55322E, 
        0xFF604022, 0xFF655522, 0xFF6F5A22, 0xFF655522, 0xFF663D22, 0xFE503227, 0xFF6F5A22, 0xFF6F5A22, 0xFF6F5A22, 0xFF655522, 0xFF6F5A22, 0xFF663D22, 0xFF6F5A22, 0xFF663D22, 0xFF635248, 0xFF6F5A22, 0xFF5D542B, 0xFF635248, 0xD65C672E, 0x04000000, 
        0x04000000, 0x04000000, 0x05000000, 0x07000000, 0x09000000, 0x0C000000, 0x74404022, 0x13000000, 0x16000000, 0x19000000, 0x1C000000, 0x1D000000, 0x1D000000, 0x1B000000, 0x19000000, 0x15000000, 0x11000000, 0x0D000000, 0x09000000, 0x06000000, 
        0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF74A422, 0xFF4C3822, 0xFF97C335, 0xFFADE12E, 0xFF87BA3B, 0xFF574027, 0xFF6F5A22, 0xFF8FA435, 0xFF626B27, 0xFF7E9A22, 0xFF97C335, 0xFFACC32E, 0xFFADE12E, 0xFFADE12E, 0xFFADE12E, 0xFFACC32E, 0xFEA8C346, 
        0xFF98B427, 0xFF8FA435, 0xFF89A422, 0xFF8FA435, 0xFF69862B, 0xFF595422, 0xFF74A422, 0xFF74A422, 0xFF7DAF2B, 0xFF8FA435, 0xFFC8E42E, 0xFFD4ED6D, 0xFF74A422, 0xFE503227, 0xFF69862B, 0xFF7E9A22, 0xFF7E9A22, 0xFFB9C32E, 0xFFD4E62E, 0xFFDAEB42, 
        0xFFDAEB42, 0xFF89A650, 0xFD461C22, 0xFE482B1C, 0xFF5D542B, 0xFF626735, 0xFE4C3D22, 0xFF5D542B, 0xFF705957, 0xFF635248, 0xFF837278, 0xFE4C3D22, 0xFF400022, 0xFF46001C, 0xFF5A001C, 0xFF66001C, 0xFF5A001C, 0xFF4C1527, 0xFF482222, 0xFE503227, 
        0xFF574027, 0xFF574027, 0xFF604022, 0xFE503227, 0xFE503227, 0xFE482B1C, 0xFF55322E, 0xFF908494, 0xFF635248, 0xFF837278, 0xFF727E3B, 0xFF606722, 0xFF655522, 0xFF655522, 0xFF5D542B, 0xFF655522, 0xFF5D542B, 0xFF6F5A22, 0xFF7D7522, 0xFF757522, 
        0xFF6F5A22, 0xFF896D22, 0xFF7D7522, 0xFF482222, 0xFF7D7522, 0xFF574027, 0xFF482222, 0xFF663D22, 0xFF7D7522, 0xFF46001C, 0xFF3D0015, 0xFF400015, 0xFF482222, 0xFE503227, 0xFF482222, 0xFF482222, 0xFF46001C, 0xFF3D001C, 0xFF400015, 0xFF4C1527, 
        0xFF55322E, 0xFF655522, 0xFF655522, 0xFF5D542B, 0xFF55322E, 0xFF55322E, 0xFF5A3D22, 0xFF5F3B38, 0xFF5A3D22, 0xFF663D22, 0xFF5D542B, 0xFF5A3D22, 0xFF655522, 0xFF4C1527, 0xFF46001C, 0xFF663D22, 0xFF6F5A22, 0x74404022, 0x09000000, 0x08000000, 
        0x08000000, 0x09000000, 0x0B000000, 0x0D000000, 0x10000000, 0x14000000, 0x19000000, 0x1D000000, 0x23000000, 0x27000000, 0x2A000000, 0x2C000000, 0x2C000000, 0x2A000000, 0x26000000, 0x21000000, 0x1B000000, 0x15000000, 0x0F000000, 0x0A000000, 
        0x06000000, 0x03000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFB3E442, 0xFF69862B, 0xFF7E9A22, 0xFFADE12E, 0xFF6F7822, 0xFF5D542B, 0xFF7D7522, 0xFF98B427, 0xFFADE12E, 0xFF9AD646, 0xFFADE12E, 0xFFADE12E, 0xFFADE12E, 0xFFADE12E, 0xFFADE12E, 0xFFB3E442, 0xFFBAE42E, 
        0xFFBAE42E, 0xFFBAE42E, 0xFFBAE42E, 0xFFADE12E, 0xFF8CC92B, 0xFF627D27, 0xFF606722, 0xFF74A422, 0xFF7DAF2B, 0xFF74A422, 0xFFACC32E, 0xFFC8E42E, 0xFF9AD646, 0xFF69862B, 0xFF6F7822, 0xFF69862B, 0xFF8FA435, 0xFFC8E42E, 0xFFD4E62E, 0xFFD4E62E, 
        0xFEA8C346, 0xFF4C3822, 0xFB554627, 0xFF595422, 0xFF5D542B, 0xFE4C3D22, 0xFF482222, 0xFF62404A, 0xFFACA7B6, 0xFF837278, 0xFFC2BEC6, 0xFF635248, 0xFF604022, 0xFE503227, 0xFF5A3D22, 0xFF604022, 0xFF4C3822, 0xFF5A3D22, 0xFF4C3822, 0xFE503227, 
        0xFF5A3D22, 0xFF5A3D22, 0xFF604022, 0xFF655522, 0xFF5D542B, 0xFF655522, 0xFF4C1527, 0xFF837278, 0xFF635248, 0xFF908494, 0xFF829544, 0xFF6F7822, 0xFF626B27, 0xFF606722, 0xFF574027, 0xFF6F5A22, 0xFF6F5A22, 0xFF6F5A22, 0xFF896D22, 0xFF6F5A22, 
        0xFE503227, 0xFF6F5A22, 0xFF6F5A22, 0xFF4C1527, 0xFF604022, 0xFE503227, 0xFF482222, 0xFF6F5A22, 0xFF635248, 0xE4553B2B, 0x86000000, 0x7A000000, 0x6A000000, 0x5B000000, 0x4E000000, 0x44000000, 0x3F000000, 0x3F000000, 0xCB4A3822, 0xEA3D1515, 
        0xFF46001C, 0xFF4C1527, 0xFF655522, 0xFF8E8140, 0xFF757522, 0xFE503227, 0xFF4C1527, 0xFF4C1527, 0xFF46001C, 0xFF663D22, 0xFF482222, 0xFF5A001C, 0xFF6F5A22, 0xFF62404A, 0xFF6F5A22, 0x74404022, 0x14000000, 0x12000000, 0x11000000, 0x10000000, 
        0x10000000, 0x11000000, 0x13000000, 0x16000000, 0x1A000000, 0x20000000, 0x26000000, 0x2C000000, 0x33000000, 0x37000000, 0x3C000000, 0x3E000000, 0x3E000000, 0x3B000000, 0x36000000, 0x2F000000, 0x27000000, 0x1D000000, 0x16000000, 0x0F000000, 
        0x0A000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF98B427, 0xFF9AD646, 0xFF7F7B42, 0xFFADE12E, 0xFF85A42B, 0xFF98B427, 0xFF97D227, 0xFFADE12E, 0xFFBAE42E, 0xFFBAE42E, 0xFFB3E442, 0xFFB3E442, 0xFFB3E442, 0xFFC9EA4C, 0xFFBAE42E, 0xFFBAE42E, 0xFFBAE42E, 
        0xFFBAE42E, 0xFFC9EA4C, 0xFFBAE42E, 0xFFBAE42E, 0xFFADE12E, 0xFF69862B, 0xFF595422, 0xFF69862B, 0xFF74A422, 0xFF74A422, 0xFF8FA435, 0xFFBAE42E, 0xFFADE12E, 0xFF85A42B, 0xFF6F7822, 0xFF69862B, 0xFFB9C32E, 0xFFC8E42E, 0xFFC8E42E, 0xFFC9EA4C, 
        0xFF626B27, 0xFF574027, 0xFF5D542B, 0xFF595422, 0xFF626735, 0xFF595422, 0xFE482B1C, 0xFF62404A, 0xFFC2BEC6, 0xFF7D626D, 0xFF908494, 0xFF5D542B, 0xFF55322E, 0xFF574027, 0xFF5A3D22, 0xFF5D542B, 0xFF574027, 0xFF5A3D22, 0xFF574027, 0xFF574027, 
        0xFF55322E, 0xFF663D22, 0xFF574027, 0xFF655522, 0xFF655522, 0xFF655522, 0xFE503227, 0xFF62404A, 0xFF635248, 0xFF62404A, 0xFF908494, 0xFF7F7B42, 0xFF6F7822, 0xFF606722, 0xFF595422, 0xFF6F5A22, 0xFF6F5A22, 0xFF663D22, 0xFF6F5A22, 0xFF7D7522, 
        0xFF482222, 0xFF663D22, 0xFF7D7522, 0xFE503227, 0xFE503227, 0xFE482B1C, 0xFF482222, 0xCB4A3822, 0x9D000000, 0x96000000, 0x8C000000, 0x82000000, 0x74000000, 0x67000000, 0x5D150000, 0x54150000, 0x50150000, 0x50150000, 0x54150000, 0x58150000, 
        0xFF574027, 0xFE482B1C, 0xFF55322E, 0xFF757522, 0xFF8E8140, 0xFF757522, 0xE4553B2B, 0xCB4A3822, 0xCB4A3822, 0xCB4A3822, 0xFF635248, 0xFF7F7B42, 0xD2787244, 0x74404022, 0x29000000, 0x25000000, 0x21000000, 0x1D000000, 0x1C000000, 0x1B000000, 
        0x1B000000, 0x1C000000, 0x1F000000, 0x23000000, 0x27000000, 0x2F000000, 0x36000000, 0x3E000000, 0x44000000, 0x4A000000, 0x4E000000, 0x51000000, 0x51000000, 0x4E000000, 0x46000000, 0x3E000000, 0x34000000, 0x29000000, 0x1F000000, 0x15000000, 
        0x0E000000, 0x08000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF606722, 0xFFA3B12E, 0xFFBAE42E, 0xFFBAE42E, 0xFFADE12E, 0xFF74A422, 0xFF627D27, 0xFF626735, 0xFF727E3B, 0xFF97C335, 0xFFADE12E, 0xFFB6E45F, 0xFFB3E442, 0xFFB3E442, 0xFFBAE42E, 0xFFBAE42E, 0xFFB3E442, 
        0xFFB3E442, 0xFFB3E442, 0xFFBAE42E, 0xFFB3E442, 0xFFADE12E, 0xFF7DAF2B, 0xFF627D27, 0xFB554627, 0xFF7E9A22, 0xFF74A422, 0xFF7E9A22, 0xFFBAE42E, 0xFFB6E45F, 0xFF97D227, 0xFF627D27, 0xFF829544, 0xFFC8E42E, 0xFFC8E42E, 0xFFC8E42E, 0xFF97B446, 
        0xFE4C3D22, 0xFF595422, 0xFF595422, 0xFF595422, 0xFF595422, 0xFF4C3822, 0xFF400015, 0xFF5F3B38, 0xFFACA7B6, 0xFF705957, 0xFF837278, 0xFB554627, 0xFF4C3822, 0xFF574027, 0xFF574027, 0xFF5D542B, 0xFF604022, 0xFE503227, 0xFF4C1527, 0xFF482222, 
        0xFF482222, 0xFF5A3D22, 0xFF604022, 0xFF6F5A22, 0xFF5D542B, 0xFF55322E, 0xFF6F5A22, 0xFE503227, 0xFF62404A, 0xFF5F3B38, 0xFF908494, 0xFF606722, 0xFF606722, 0xFF606722, 0xFF5D542B, 0xFF6F5A22, 0xFF6F5A22, 0xFF4C1527, 0xFF663D22, 0xFF604022, 
        0xFF420022, 0xFF7D7522, 0xFF757522, 0xFF4C3822, 0xFB554627, 0xC8351500, 0xA6000000, 0xA3000000, 0xA0000000, 0x9A000000, 0x93000000, 0x8A000000, 0x7F000000, 0x74000000, 0x6B151500, 0x65150000, 0x61150000, 0x61150000, 0x65150000, 0x6B151C00, 
        0xA8000000, 0xE4553B2B, 0xFF46001C, 0xFF55322E, 0xFF5F3B38, 0xFF896D22, 0xFF83573D, 0xD2787244, 0x6B151C00, 0x61150000, 0x58150000, 0x50150000, 0x48000000, 0x42000000, 0x3B000000, 0x34000000, 0x31000000, 0x2C000000, 0x2C000000, 0x2A000000, 
        0x2A000000, 0x2C000000, 0x2F000000, 0x33000000, 0x39000000, 0x3F000000, 0x48000000, 0x50150000, 0x58150000, 0x5D150000, 0x61150000, 0x65150000, 0x63000000, 0x5E000000, 0x58150000, 0x4C150000, 0x42000000, 0x34000000, 0x27000000, 0x1C000000, 
        0x12000000, 0x0B000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFE482B1C, 0xFF8FA435, 0xFFADE12E, 0xFFADE12E, 0xFF9AD646, 0xFF85A42B, 0xFF97C335, 0xFF97D227, 0xFF85A42B, 0xFF69862B, 0xFF595422, 0xFF595422, 0xFF606722, 0xFF727E3B, 0xFF829544, 0xFF7E9A22, 0xFF84AE4C, 
        0xFF84AE4C, 0xFF7DAF2B, 0xFF85A42B, 0xFF7E9A22, 0xFF7E9A22, 0xFF627D27, 0xFF595422, 0xFE4C3D22, 0xFF595422, 0xFF74A422, 0xFF69862B, 0xFFACC32E, 0xFFB6E45F, 0xFF8CC92B, 0xFF626B27, 0xFF8FA435, 0xFFBAE42E, 0xFFBAE42E, 0xFFBAE42E, 0xFE4C3D22, 
        0xFE4C3D22, 0xFF595422, 0xFB554627, 0xFB554627, 0xFF574027, 0xFE482B1C, 0xFF400022, 0xFF62404A, 0xFF908494, 0xFF837278, 0xFF908494, 0xFF727E3B, 0xFF595422, 0xFF574027, 0xFF4C3822, 0xFE503227, 0xFF4C1527, 0xFF400022, 0xFF46001C, 0xFD461C22, 
        0xFF400022, 0xFF55322E, 0xFF663D22, 0xFF655522, 0xFF655522, 0xFF626735, 0xFF604022, 0xFF5D542B, 0xFF5F3B38, 0xFF5F3B38, 0xFF837278, 0xFF655522, 0xFF757522, 0xFF7F7B42, 0xFF5D542B, 0xFF604022, 0xFF6F5A22, 0xFE482B1C, 0xFF5A001C, 0xFF4C1527, 
        0xFF3B001C, 0xFF4C1527, 0xFF4C3822, 0xFB554627, 0xA7000000, 0xA7000000, 0xA6000000, 0xA4000000, 0xA2000000, 0x9D000000, 0x98000000, 0x91000000, 0x8A000000, 0x80151500, 0x7A000000, 0x74151500, 0x74151500, 0x74151500, 0x74151500, 0x7E151C00, 
        0x7E151C00, 0x85150000, 0xE4553B2B, 0xFF55322E, 0xFF5F3B38, 0xFF663D22, 0xFF5F3B38, 0xFF83573D, 0xFF8E8140, 0x74151500, 0x6B151C00, 0x61150000, 0x5B150000, 0x54150000, 0x4E000000, 0x48000000, 0x44000000, 0x3F000000, 0x3C000000, 0x3C000000, 
        0x3C000000, 0x3C000000, 0x42000000, 0x44000000, 0x4C150000, 0x54000000, 0x5B150000, 0x63000000, 0x6B151500, 0x6F150000, 0x74151500, 0x74151500, 0x71000000, 0x6F150000, 0x65150000, 0x5B150000, 0x4C150000, 0x3F000000, 0x31000000, 0x23000000, 
        0x17000000, 0x0E000000, 0x08000000, 0x04000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF606722, 0xFF9AD646, 0xFF87BA3B, 0xFF80B122, 0xFF9AD646, 0xFE4C3D22, 0xFF606722, 0xFF80B122, 0xFFADE12E, 0xFFADE12E, 0xFEA8C346, 0xFF74A422, 0xFF69862B, 0xFF606722, 0xFE4C3D22, 0xFB554627, 0xFF606722, 
        0xFF6F7822, 0xFF69862B, 0xFF69862B, 0xFF627D27, 0xFF627D27, 0xFF627D27, 0xFF595422, 0xFE482B1C, 0xFF3D001C, 0xFF595422, 0xFF69862B, 0xFF89A422, 0xFFB3E442, 0xFF627D27, 0xFF606722, 0xFFACC32E, 0xFFBAE42E, 0xFFB9C32E, 0xFF606722, 0xFF4C3822, 
        0xFE4C3D22, 0xFB554627, 0xFE4C3D22, 0xFB554627, 0xFF626735, 0xFF626735, 0xFF7F7B42, 0xFF8FA435, 0xFCBEC678, 0xFCBEC678, 0xFFB6E45F, 0xFEA8C346, 0xFF97B446, 0xFF8FA435, 0xFF829544, 0xFF5D542B, 0xFE503227, 0xFE503227, 0xFF5D542B, 0xFF604022, 
        0xFF4C3822, 0xFF482222, 0xFF4C1527, 0xFF655522, 0xFF6F5A22, 0xFF6F5A22, 0xFF604022, 0xFF6F5A22, 0xFF4C3822, 0xFF4C1527, 0xFE503227, 0xFF655522, 0xFF655522, 0xFF7D7522, 0xFE482B1C, 0xFF663D22, 0xFF663D22, 0xFF482222, 0xFF38001C, 0xFF4C1527, 
        0xFF3B151C, 0xFF420022, 0xEA3D1515, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA5000000, 0xA3000000, 0xA0000000, 0x9C000000, 0x96000000, 0x91000000, 0x8B150000, 0x86000000, 0x85150000, 0x80151500, 0x85150000, 0x85150000, 0x8B150000, 
        0x8B150000, 0x8F150000, 0x97151500, 0xC8351500, 0xE4553B2B, 0xFB554627, 0xFF5D542B, 0xFE503227, 0xFF6F5A22, 0xFF8E8140, 0x7E151C00, 0x74151500, 0x6B151C00, 0x67000000, 0x61150000, 0x5D150000, 0x58000000, 0x54000000, 0x51000000, 0x50150000, 
        0x50150000, 0x51000000, 0x54000000, 0x58150000, 0x5E000000, 0x65150000, 0x6B151500, 0x74151500, 0x7A000000, 0x7E150000, 0x80151500, 0x80151500, 0x7E150000, 0x77150000, 0x6F150000, 0x65150000, 0x58150000, 0x46000000, 0x37000000, 0x27000000, 
        0x1B000000, 0x11000000, 0x0A000000, 0x05000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF7DAF2B, 0xFFADE12E, 0xFF626B27, 0xFF626B27, 0xFF97B446, 0xFF8CC92B, 0xFE482B1C, 0xFE4C3D22, 0xFF69862B, 0xFF80B122, 0xFFACC32E, 0xFFC9EA4C, 0xFFB6E45F, 0xFEA8C346, 0xFF98B427, 0xFF74A422, 0xFF7DAF2B, 
        0xFF7DAF2B, 0xFF74A422, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF80B122, 0xFF7DAF2B, 0xFF69862B, 0xFE4C3D22, 0xFF574027, 0xFF7E9A22, 0xFFB9C32E, 0xFF627D27, 0xFF7D7522, 0xFFB9C32E, 0xFFA3B12E, 0xFF595422, 0xFE482B1C, 0xFF626735, 
        0xFF829544, 0xFF97B446, 0xFEA8C346, 0xFFB6E45F, 0xFFB6E45F, 0xFFB6E45F, 0xFFB6E45F, 0xFFB6E45F, 0xFFB3E442, 0xFFB3E442, 0xFFB3E442, 0xFFB3E442, 0xFFB3E442, 0xFFB3E442, 0xFFC9EA4C, 0xFFC9EA4C, 0xFFB6E45F, 0xFEA8C346, 0xFF89A650, 0xFF626735, 
        0xFF5A3D22, 0xFE503227, 0xFF4C1527, 0xFF5A3D22, 0xFF6F5A22, 0xFF83573D, 0xFF5A3D22, 0xFF6F5A22, 0xFF5D542B, 0xFF46001C, 0xFF482222, 0xFF604022, 0xFF5D542B, 0xFF6F5A22, 0xFE4A3B1C, 0xFF420022, 0xFE4C3D22, 0xFF35001C, 0xFF35001C, 0xFF3D001C, 
        0xFD461C22, 0xFF3D0015, 0xEA3D1515, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA3000000, 0xA0000000, 0x9D000000, 0x99000000, 0x95000000, 0x93000000, 0x8F150000, 0x8F150000, 0x8F150000, 0x91000000, 0x93000000, 
        0x97151500, 0x97151500, 0x9A000000, 0x9D1C0000, 0x9D1C0000, 0x9D1C0000, 0xC8351500, 0xFF635248, 0xFF5A3D22, 0xFF6F5A22, 0xFF8E8140, 0xD2787244, 0x7E151C00, 0x7A000000, 0x74151500, 0x71000000, 0x6B151500, 0x67000000, 0x67000000, 0x63000000, 
        0x63000000, 0x67000000, 0x67000000, 0x6B151500, 0x71000000, 0x77150000, 0x7C000000, 0x80151500, 0x85150000, 0x85150000, 0x86000000, 0x85150000, 0x80151500, 0x7C000000, 0x74151500, 0x6A150000, 0x5B150000, 0x4C150000, 0x3B000000, 0x2C000000, 
        0x1D000000, 0x13000000, 0x0B000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF83BC22, 0xFFB3E442, 0xFF595422, 0xFF595422, 0xFF69862B, 0xFFADE12E, 0xFF74A422, 0xFF482222, 0xFF595422, 0xFF7E9A22, 0xFF7E9A22, 0xFF97C335, 0xFFB3E442, 0xFFC9EA4C, 0xFFD4ED6D, 0xFFB6E45F, 0xFF97C335, 
        0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF80B122, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF74A422, 0xFF606722, 0xFF626B27, 0xFEA8C346, 0xFF7DAF2B, 0xFF98B427, 0xFF8FA435, 0xFF87994C, 0xFF97B446, 0xFEA8C346, 0xFFB6E45F, 
        0xFFB6E45F, 0xFFB6E45F, 0xFFB6E45F, 0xFFB3E442, 0xFFADE12E, 0xFFADE12E, 0xFFADE12E, 0xFF9AD646, 0xFF9AD646, 0xFF9AD646, 0xFF9AD646, 0xFF9AD646, 0xFF9AD646, 0xFF9AD646, 0xFF9AD646, 0xFFADE12E, 0xFFADE12E, 0xFFB3E442, 0xFFC9EA4C, 0xFFB6E45F, 
        0xFEA8C346, 0xFF727E3B, 0xFF4C3822, 0xFE503227, 0xFF655522, 0xFF6F5A22, 0xFF4C3822, 0xFF604022, 0xFF6F5A22, 0xFE503227, 0xFF46001C, 0xFE503227, 0xFF5A3D22, 0xFE503227, 0xFE482B1C, 0xFF3B001C, 0xFF3B151C, 0xFF35001C, 0xFF38001C, 0xFF38001C, 
        0xFF4C1527, 0xFF3B001C, 0xC8351500, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA3000000, 0xA0000000, 0x9D000000, 0x9C000000, 0x9A000000, 0x99000000, 0x97151500, 0x97151500, 0x97151500, 0x97151500, 
        0x9A000000, 0x9C000000, 0x9D000000, 0x9D000000, 0x9D000000, 0x9C000000, 0x9A000000, 0x97151500, 0xFF574027, 0xFF5A3D22, 0xFF8E8140, 0xFF8E8140, 0xFFAD8722, 0x86000000, 0x85150000, 0x80151500, 0x7C000000, 0x7A000000, 0x77000000, 0x77000000, 
        0x77000000, 0x77000000, 0x7A000000, 0x7C000000, 0x80151500, 0x82000000, 0x85150000, 0x86000000, 0x8A000000, 0x8A000000, 0x86000000, 0x85150000, 0x80151500, 0x7A000000, 0x74151500, 0x67000000, 0x5B150000, 0x4C150000, 0x3C000000, 0x2C000000, 
        0x20000000, 0x14000000, 0x0C000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF97D227, 0xFFC9EA4C, 0xFF98B427, 0xFF606722, 0xFF69862B, 0xFF97C335, 0xFFB6E45F, 0xFF626B27, 0xFF3D001C, 0xFF606722, 0xFF74A422, 0xFF74A422, 0xFF85A42B, 0xFF97D227, 0xFFB3E442, 0xFFC9EA4C, 0xFFC9EA4C, 
        0xFFC9EA4C, 0xFF8CC92B, 0xFF97D227, 0xFF97D227, 0xFF7ECA27, 0xFF7ECA27, 0xFF7ECA27, 0xFF7ECA27, 0xFF7ECA27, 0xFF83BC22, 0xFF83BC22, 0xFF80B122, 0xFF9AD646, 0xFFB3E442, 0xFFB3E442, 0xFFB6E45F, 0xFFB6E45F, 0xFF97B446, 0xFF84AE4C, 0xFF84AE4C, 
        0xFF7DAF2B, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF7E9A22, 0xFF7E9A22, 0xFF7E9A22, 0xFF7E9A22, 0xFF69862B, 0xFF7E9A22, 0xFF7E9A22, 0xFF7E9A22, 0xFF85A42B, 0xFF85A42B, 0xFF87BA3B, 0xFF97C335, 0xFF9AD646, 
        0xFFADE12E, 0xFFD4ED6D, 0xFCBEC678, 0xFF727E3B, 0xFF6F5A22, 0xFF7D7522, 0xFF574027, 0xFF5A001C, 0xFF655522, 0xFF46001C, 0xFF350022, 0xFF3D0022, 0xFF3B151C, 0xFF3D0015, 0xFE482B1C, 0xFF350015, 0xFF3B001C, 0xFF350015, 0xFF3B001C, 0xFF350015, 
        0xFF46001C, 0xFF3D001C, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA4000000, 0xA2000000, 0xA0000000, 0x9F000000, 0x9D000000, 0x9D000000, 0x9C000000, 0x9C000000, 0x9C000000, 
        0x9A000000, 0x9A000000, 0x9A000000, 0x9A000000, 0x9A000000, 0x99000000, 0x97151500, 0x97151500, 0x97151500, 0xFF663D22, 0xFF626735, 0xFF655522, 0xFF604022, 0xFFA37622, 0x8F150000, 0x8C000000, 0x8B150000, 0x8A000000, 0x86000000, 0x86000000, 
        0x85150000, 0x85150000, 0x85150000, 0x86000000, 0x8A000000, 0x8B150000, 0x8B150000, 0x8B150000, 0x8A000000, 0x86000000, 0x82000000, 0x7E150000, 0x77150000, 0x74151500, 0x6B151500, 0x61150000, 0x54150000, 0x48000000, 0x3B000000, 0x2C000000, 
        0x1F000000, 0x14000000, 0x0C000000, 0x07000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFADE12E, 0xFFC9EA4C, 0xFF97D227, 0xFF69862B, 0xFF627D27, 0xFF7E9A22, 0xFF9AD646, 0xFFB6E45F, 0xFE4C3D22, 0xFF595422, 0xFF69862B, 0xFF85A42B, 0xFF7DAF2B, 0xFF7E9A22, 0xFF98B427, 0xFFADE12E, 0xFFB3E442, 
        0xFFC9EA4C, 0xFFD4ED6D, 0xFFB3E442, 0xFF83BC22, 0xFF7ECA27, 0xFF83BC22, 0xFF69862B, 0xFF606722, 0xFE4A3B1C, 0xFE4A3B1C, 0xFF606722, 0xFFB6E45F, 0xFFBAE42E, 0xFFBAE42E, 0xFF97D227, 0xFF97C335, 0xFF97C335, 0xFF626B27, 0xFE482B1C, 0xFF420022, 
        0xFF4C3822, 0xFF5D542B, 0xFF69862B, 0xFF7E9A22, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF74A422, 0xFF7E9A22, 0xFF7E9A22, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF7DAF2B, 0xFF80B122, 0xFF80B122, 0xFF7DAF2B, 0xFF74A422, 
        0xFF7E9A22, 0xFF89A422, 0xFF97C335, 0xFFB6E45F, 0xFEA8C346, 0xFF626B27, 0xFF3D001C, 0xFF46001C, 0xFF655522, 0xFF3B001C, 0xFF38001C, 0xFF38001C, 0xFF3D001C, 0xFF38001C, 0xFF38001C, 0xFF35001C, 0xFF35001C, 0xFF35001C, 0xFF46001C, 0xFF3D001C, 
        0xFF3D001C, 0xFF48002B, 0xA8000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA4000000, 0xA3000000, 0xA2000000, 0xA0000000, 0x9F000000, 0x9D000000, 0x9A000000, 0x9A000000, 
        0x98000000, 0x96000000, 0x95000000, 0x93000000, 0x93000000, 0x93000000, 0x91000000, 0x91000000, 0x91000000, 0x93000000, 0xE6502222, 0xFB554627, 0xFF574027, 0xFF604022, 0xFFAD8722, 0x95000000, 0x93000000, 0x93000000, 0x91000000, 0x8F000000, 
        0x8F150000, 0x8F150000, 0x8F150000, 0x8F150000, 0x8C000000, 0x8B150000, 0x8B150000, 0x86000000, 0x85150000, 0x7E150000, 0x7A000000, 0x71000000, 0x6B151500, 0x65150000, 0x5D150000, 0x54150000, 0x4C150000, 0x3F000000, 0x34000000, 0x27000000, 
        0x1C000000, 0x13000000, 0x0B000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFBAE42E, 0xFFB6E45F, 0xFF98B427, 0xFF74A422, 0xFF627D27, 0xFF69862B, 0xFF97C335, 0xFFB3E442, 0xFF9AD646, 0xFF626B27, 0xFF595422, 0xFF69862B, 0xFF80B122, 0xFF80B122, 0xFF74A422, 0xFF85A42B, 0xFF97D227, 
        0xFFADE12E, 0xFFB3E442, 0xFFC9EA4C, 0xFFB6E45F, 0xFF7E9A22, 0xFE4A3B1C, 0xFE4C3D22, 0xFF595422, 0xFF626B27, 0xFF74A422, 0xFF9AD646, 0xFF97D227, 0xFF7F7B42, 0xFFACC32E, 0xFF9AD646, 0xFF595422, 0xFF626B27, 0xFF97B446, 0xFEA8C346, 0xFF97B446, 
        0xFF727E3B, 0xFE4C3D22, 0xFE482B1C, 0xFE4C3D22, 0xFF595422, 0xFF627D27, 0xFF69862B, 0xFF7E9A22, 0xFF74A422, 0xFF7DAF2B, 0xFF74A422, 0xFF74A422, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF80B122, 0xFF87BA3B, 0xFF8CC92B, 0xFF97C335, 0xFF8CC92B, 0xFF97C335, 
        0xFF97C335, 0xFF87BA3B, 0xFF80B122, 0xFF80B122, 0xFF98B427, 0xFEA8C346, 0xFF84AE4C, 0xFE4C3D22, 0xFE482B1C, 0xFF38001C, 0xFF38001C, 0xFF35001C, 0xFF35001C, 0xFF38001C, 0xFF350015, 0xFF35001C, 0xFF35001C, 0xFF3D001C, 0xFF4C1527, 0xFF46001C, 
        0xFF380015, 0xFF4C1527, 0xE6502222, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA6000000, 0xA5000000, 0xA3000000, 0xA2000000, 0xA0000000, 0x9D000000, 0x9A000000, 0x96000000, 0x93000000, 
        0x8F000000, 0x8C000000, 0x8B150000, 0x86000000, 0x86000000, 0x86000000, 0x86000000, 0x86000000, 0x86000000, 0x8A000000, 0x8C000000, 0x8F000000, 0xC8351500, 0xFF574027, 0xFF896D22, 0xD2787244, 0x98000000, 0x98000000, 0x97151500, 0x95000000, 
        0x93000000, 0x93000000, 0x91000000, 0x8F150000, 0x8B150000, 0x8A000000, 0x85150000, 0x7E150000, 0x7A000000, 0x71000000, 0x6A150000, 0x61150000, 0x5B150000, 0x54150000, 0x4C150000, 0x46000000, 0x3F000000, 0x36000000, 0x2C000000, 0x22000000, 
        0x18000000, 0x10000000, 0x0A000000, 0x05000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFC9EA4C, 0xFF9AD646, 0xFF74A422, 0xFF69862B, 0xFF626B27, 0xFF627D27, 0xFF7E9A22, 0xFF97D227, 0xFFB6E45F, 0xFF87BA3B, 0xFF595422, 0xFF595422, 0xFF7E9A22, 0xFF83BC22, 0xFF83BC22, 0xFF87BA3B, 0xFF85A42B, 
        0xFF80B122, 0xFF9AD646, 0xFFADE12E, 0xFFB3E442, 0xFFD4ED6D, 0xFF97C335, 0xFF6F7822, 0xFF8CC92B, 0xFF9AD646, 0xFF9AD646, 0xFFADE12E, 0xFF74A422, 0xFE482B1C, 0xFF606722, 0xFF97B446, 0xFF9AD646, 0xFF4C3822, 0xFF595422, 0xFF74A422, 0xFF7DAF2B, 
        0xFEA8C346, 0xFFB6E45F, 0xFCBEC678, 0xFF89A650, 0xFF595422, 0xFE482B1C, 0xFF574027, 0xFF595422, 0xFF595422, 0xFF626B27, 0xFF626B27, 0xFF626B27, 0xFF727E3B, 0xFF69862B, 0xFF69862B, 0xFF7E9A22, 0xFF69862B, 0xFF69862B, 0xFF7E9A22, 0xFF7E9A22, 
        0xFF7E9A22, 0xFF7E9A22, 0xFF85A42B, 0xFF80B122, 0xFF80B122, 0xFF80B122, 0xFF97C335, 0xFEA8C346, 0xFF69862B, 0xFF38001C, 0xFF38001C, 0xFF3B001C, 0xFF35001C, 0xFF38001C, 0xFF3B001C, 0xFF38001C, 0xFF3D001C, 0xFF5A001C, 0xFF5A001C, 0xFF4C1527, 
        0xFF35001C, 0xFF46001C, 0xE6502222, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA4000000, 0xA2000000, 0x9F000000, 0x9C000000, 0x98000000, 0x93000000, 0x8F000000, 0x8A000000, 
        0x85150000, 0x7F000000, 0x7C000000, 0x7A000000, 0x77000000, 0x77000000, 0x77000000, 0x77000000, 0x7A000000, 0x7C000000, 0x82000000, 0x86000000, 0x8C000000, 0xCB4A3822, 0xFF604022, 0xFF8E8140, 0x98000000, 0x98000000, 0x97151500, 0x97151500, 
        0x93000000, 0x91000000, 0x8F150000, 0x8B150000, 0x85150000, 0x80151500, 0x7A000000, 0x71000000, 0x6A150000, 0x61150000, 0x58150000, 0x50150000, 0x49000000, 0x42000000, 0x3C000000, 0x36000000, 0x31000000, 0x2A000000, 0x22000000, 0x1B000000, 
        0x13000000, 0x0D000000, 0x08000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFD4ED6D, 0xFF97C335, 0xFF69862B, 0xFF69862B, 0xFF626B27, 0xFF627D27, 0xFF69862B, 0xFF83BC22, 0xFF9AD646, 0xFFC9EA4C, 0xFF74A422, 0xFF606722, 0xFF595422, 0xFF74A422, 0xFF8CC92B, 0xFF83BC22, 0xFF87BA3B, 
        0xFF80B122, 0xFF85A42B, 0xFF97D227, 0xFFADE12E, 0xFFADE12E, 0xFFC9EA4C, 0xFF9AD646, 0xFF7DAF2B, 0xFF8CC92B, 0xFFADE12E, 0xFFB3E442, 0xFF606722, 0xFE4A3B1C, 0xFF4C3822, 0xFF69862B, 0xFFB6E45F, 0xFF89A650, 0xFE4C3D22, 0xFF606722, 0xFF7E9A22, 
        0xFF74A422, 0xFF85A42B, 0xFEA8C346, 0xFFB6E45F, 0xFFB6E45F, 0xFCBEC678, 0xFF89A650, 0xFF626735, 0xFE4C3D22, 0xFF604022, 0xFF606722, 0xFF574027, 0xFF5D542B, 0xFF5D542B, 0xFF574027, 0xFF5D542B, 0xFF5A3D22, 0xFF604022, 0xFF5D542B, 0xFF574027, 
        0xFF655522, 0xFF5D542B, 0xFF4C3822, 0xFF4C3822, 0xFE4C3D22, 0xFF5D542B, 0xFF6F7822, 0xFF7E9A22, 0xFF97B446, 0xFF627D27, 0xFF38001C, 0xFF38001C, 0xFF35001C, 0xFF3B001C, 0xFF38001C, 0xFF400015, 0xFF5A001C, 0xFF66001C, 0xFF5A001C, 0xFF4C1527, 
        0xFF38001C, 0xFF3D001C, 0xE6502222, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA4000000, 0xA2000000, 0x9F000000, 0x9A000000, 0x96000000, 0x8F000000, 0x8A000000, 0x82000000, 0x7C000000, 
        0x74000000, 0x6F150000, 0x6A000000, 0x67000000, 0x63000000, 0x63000000, 0x63000000, 0x65150000, 0x67000000, 0x6E000000, 0x74000000, 0x7A000000, 0x7F000000, 0x86000000, 0xCB4A3822, 0xD65C672E, 0x93000000, 0x95000000, 0x93000000, 0x93000000, 
        0x8F150000, 0x8B150000, 0x85150000, 0x80151500, 0x7C000000, 0x74151500, 0x6B151500, 0x63000000, 0x58150000, 0x50150000, 0x46000000, 0x3E000000, 0x37000000, 0x31000000, 0x2C000000, 0x27000000, 0x23000000, 0x1D000000, 0x19000000, 0x13000000, 
        0x0E000000, 0x0A000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFD4ED6D, 0xFF74A422, 0xFF595422, 0xFF69862B, 0xFF627D27, 0xFF69862B, 0xFF69862B, 0xFF74A422, 0xFF8CC92B, 0xFFB3E442, 0xFFB6E45F, 0xFF69862B, 0xFF595422, 0xFF606722, 0xFF80B122, 0xFF8CC92B, 0xFF97C335, 
        0xFF87BA3B, 0xFF80B122, 0xFF85A42B, 0xFF8CC92B, 0xFF9AD646, 0xFFADE12E, 0xFFB6E45F, 0xFF9AD646, 0xFF87BA3B, 0xFFB3E442, 0xFF8CC92B, 0xFB554627, 0xFE482B1C, 0xFF482222, 0xFF627D27, 0xFF8FA435, 0xFFB6E45F, 0xFF627D27, 0xFF4C3822, 0xFF626B27, 
        0xFF69862B, 0xFF69862B, 0xFF7E9A22, 0xFF85A42B, 0xFF97B446, 0xFEA8C346, 0xFCBEC678, 0xFFB6E45F, 0xFF89A650, 0xFF606722, 0xFF6F5A22, 0xFF595422, 0xFF655522, 0xFF655522, 0xFF574027, 0xFF6F5A22, 0xFF604022, 0xFF574027, 0xFF5A3D22, 0xFF655522, 
        0xFF6F5A22, 0xFF6F5A22, 0xFF5A3D22, 0xFF3B001C, 0xFF38001C, 0xFF3B001C, 0xFF38001C, 0xFF400022, 0xFF5A3D22, 0xFF6F7822, 0xFE482B1C, 0xFF3B001C, 0xFF3B001C, 0xFF3D001C, 0xFF400015, 0xFF5A001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF4C1527, 
        0xFF350015, 0xFF350015, 0xFF62404A, 0xA8000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA2000000, 0x9F000000, 0x9A000000, 0x93000000, 0x8C000000, 0x85150000, 0x7C000000, 0x74000000, 0x6A000000, 
        0x63000000, 0x5B000000, 0x58000000, 0x51000000, 0x4E000000, 0x4E000000, 0x4E000000, 0x51000000, 0x54000000, 0x5B000000, 0x61150000, 0x6A000000, 0x71000000, 0x7A000000, 0x80151500, 0x86000000, 0x8B150000, 0x8B150000, 0x8B150000, 0x8B150000, 
        0x8B150000, 0x85150000, 0x7E150000, 0x77150000, 0x6F150000, 0x65150000, 0x5D150000, 0x51000000, 0x48000000, 0x3E000000, 0x34000000, 0x2C000000, 0x27000000, 0x22000000, 0x1D000000, 0x1A000000, 0x17000000, 0x14000000, 0x11000000, 0x0D000000, 
        0x0A000000, 0x06000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFD4ED6D, 0xFF626B27, 0xFF420022, 0xFE4C3D22, 0xFF627D27, 0xFF69862B, 0xFF69862B, 0xFF69862B, 0xFF83BC22, 0xFF97D227, 0xFFC9EA4C, 0xFF8CC92B, 0xFE4A3B1C, 0xFF38001C, 0xFF5D542B, 0xFF80B122, 0xFF8CC92B, 
        0xFF97C335, 0xFF98B427, 0xFF98B427, 0xFF85A42B, 0xFF83BC22, 0xFF97D227, 0xFF9AD646, 0xFFB6E45F, 0xFFADE12E, 0xFF87BA3B, 0xFF626B27, 0xFF574027, 0xFE4C3D22, 0xFF482222, 0xFF626B27, 0xFF6F7822, 0xFF9AD646, 0xFFB6E45F, 0xFE4C3D22, 0xFE4C3D22, 
        0xFF627D27, 0xFF69862B, 0xFF74A422, 0xFF74A422, 0xFF69862B, 0xFF74A422, 0xFF87BA3B, 0xFF97C335, 0xFFB6E45F, 0xFFB6E45F, 0xFF89A650, 0xFF626735, 0xFF5D542B, 0xFF574027, 0xFF655522, 0xFF574027, 0xFF655522, 0xFF604022, 0xFB554627, 0xFF5A3D22, 
        0xFF574027, 0xFF55322E, 0xFF5A3D22, 0xFE482B1C, 0xFF420022, 0xFF420022, 0xFF3D001C, 0xFF3B001C, 0xFF38001C, 0xFF3B001C, 0xFF3D001C, 0xFF3B001C, 0xFF420022, 0xFF4C1527, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF4C1527, 
        0xFF350015, 0xFF35001C, 0xFF5A001C, 0xA8000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA3000000, 0xA0000000, 0x9A000000, 0x93000000, 0x8C000000, 0x82000000, 0x77000000, 0x6E000000, 0x63000000, 0x58000000, 
        0x50150000, 0x49000000, 0x44000000, 0x3E000000, 0x3B000000, 0x3B000000, 0x3B000000, 0x3C000000, 0x42000000, 0x46000000, 0x4E000000, 0x58000000, 0x61150000, 0x6A000000, 0x74151500, 0x7A000000, 0x7E150000, 0x85150000, 0x85150000, 0x80151500, 
        0x7E151C00, 0x77150000, 0x6F150000, 0x6B151C00, 0x61150000, 0x58150000, 0x4C150000, 0x42000000, 0x37000000, 0x2F000000, 0x26000000, 0x1F000000, 0x1A000000, 0x15000000, 0x12000000, 0x10000000, 0x0E000000, 0x0C000000, 0x0A000000, 0x08000000, 
        0x06000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFFB6E45F, 0xFE4C3D22, 0xFF420022, 0xFF46001C, 0xFF627D27, 0xFF627D27, 0xFF69862B, 0xFF69862B, 0xFF7E9A22, 0xFF97C335, 0xFEA8C346, 0xFFB6E45F, 0xFF69862B, 0xFE4A3B1C, 0xFE482B1C, 0xFF595422, 0xFF85A42B, 
        0xFF97D227, 0xFF97C335, 0xFF98B427, 0xFF98B427, 0xFF85A42B, 0xFF80B122, 0xFF8CC92B, 0xFF97D227, 0xFFB3E442, 0xFF9AD646, 0xFF606722, 0xFF4C3822, 0xFF4C3822, 0xFE482B1C, 0xFF626B27, 0xFF627D27, 0xFF7E9A22, 0xFFB6E45F, 0xFF9AD646, 0xFF595422, 
        0xFF595422, 0xFF606722, 0xFF69862B, 0xFF74A422, 0xFF7DAF2B, 0xFF74A422, 0xFF7E9A22, 0xFF74A422, 0xFF80B122, 0xFF97C335, 0xFFB6E45F, 0xFFB6E45F, 0xFF829544, 0xFF5D542B, 0xFF574027, 0xFE503227, 0xFF574027, 0xFF4C3822, 0xFF574027, 0xFF482222, 
        0xFF482222, 0xFF4C1527, 0xFE503227, 0xFF55322E, 0xFF400022, 0xFF46001C, 0xFF4C1527, 0xFF4C1527, 0xFF4C1527, 0xFF5A001C, 0xFF5A001C, 0xFF5A001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF4C1527, 
        0xFF38001C, 0xFF2E0015, 0xFF420022, 0xCB4A3822, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA4000000, 0xA0000000, 0x9C000000, 0x96000000, 0x8C000000, 0x82000000, 0x77000000, 0x6A000000, 0x5D150000, 0x51000000, 0x46000000, 
        0x3C000000, 0x36000000, 0x31000000, 0x2C000000, 0x29000000, 0x27000000, 0x29000000, 0x2C000000, 0x2F000000, 0x34000000, 0x3C000000, 0x44000000, 0x4E000000, 0x58000000, 0x61150000, 0x6A150000, 0x71000000, 0x74151500, 0x77150000, 0x74151500, 
        0x74151500, 0x6B151C00, 0x65150000, 0x5D150000, 0x54150000, 0x49000000, 0x3E000000, 0x34000000, 0x2A000000, 0x22000000, 0x1B000000, 0x15000000, 0x10000000, 0x0D000000, 0x0B000000, 0x09000000, 0x08000000, 0x07000000, 0x06000000, 0x04000000, 
        0x03000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF9AD646, 0xFF69862B, 0xFF46001C, 0xFE4C3D22, 0xFF74A422, 0xFF69862B, 0xFF69862B, 0xFF69862B, 0xFF69862B, 0xFF98B427, 0xFF98B427, 0xFEA8C346, 0xFF9AD646, 0xFF626B27, 0xFF595422, 0xFF4C3822, 0xFF574027, 
        0xFF7E9A22, 0xFF97C335, 0xFF97C335, 0xFF98B427, 0xFF98B427, 0xFF98B427, 0xFF7E9A22, 0xFF83BC22, 0xFF8CC92B, 0xFF9AD646, 0xFFB6E45F, 0xFF595422, 0xFF595422, 0xFF5D542B, 0xFF595422, 0xFF69862B, 0xFF626B27, 0xFF8CC92B, 0xFFB6E45F, 0xFF84AE4C, 
        0xFF5D542B, 0xFF626735, 0xFF595422, 0xFF69862B, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF69862B, 0xFF74A422, 0xFF80B122, 0xFF97C335, 0xFFB6E45F, 0xFF97B446, 0xFE4A3B1C, 0xFF420022, 0xFF3B001C, 0xFF46001C, 0xFF420022, 0xFF420022, 
        0xFF482222, 0xFF4C3822, 0xFF635248, 0xFE4C3D22, 0xFF482222, 0xFF3D001C, 0xFF46001C, 0xFF5A001C, 0xFF5A001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF5A001C, 0xFF4C1527, 
        0xFF3D001C, 0xFF2E0015, 0xFF3B001C, 0xE6502222, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA5000000, 0xA3000000, 0x9F000000, 0x99000000, 0x8F000000, 0x85150000, 0x77000000, 0x6A000000, 0x5B000000, 0x4E000000, 0x3F000000, 0x36000000, 
        0x2C000000, 0x26000000, 0x20000000, 0x1D000000, 0x1B000000, 0x1A000000, 0x1A000000, 0x1C000000, 0x1F000000, 0x25000000, 0x2C000000, 0x33000000, 0x3C000000, 0x46000000, 0x50150000, 0x58150000, 0x61150000, 0x65150000, 0x6A150000, 0x6B151C00, 
        0x6A150000, 0x61150000, 0x5D150000, 0x54150000, 0x4A000000, 0x3F000000, 0x34000000, 0x2A000000, 0x21000000, 0x19000000, 0x12000000, 0x0D000000, 0x0A000000, 0x07000000, 0x05000000, 0x04000000, 0x04000000, 0x03000000, 0x03000000, 0x02000000, 
        0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF74A422, 0xFF8FA435, 0xFF6F7822, 0xFF626B27, 0xFF7DAF2B, 0xFF83BC22, 0xFF69862B, 0xFF69862B, 0xFF69862B, 0xFF7E9A22, 0xFF80B122, 0xFF85A42B, 0xFF97B446, 0xFF7E9A22, 0xFF626B27, 0xFF606722, 0xFF626B27, 
        0xFF626B27, 0xFF727E3B, 0xFF97C335, 0xFF97C335, 0xFF98B427, 0xFF98B427, 0xFF98B427, 0xFF7E9A22, 0xFF80B122, 0xFF8CC92B, 0xFEA8C346, 0xFF9AD646, 0xFB554627, 0xFF574027, 0xFF595422, 0xFF69862B, 0xFF626B27, 0xFF7E9A22, 0xFF9AD646, 0xFFB6E45F, 
        0xFF627D27, 0xA8000000, 0xC8351500, 0xFB554627, 0xFF627D27, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF7E9A22, 0xFF80B122, 0xFF97C335, 0xFF9AD646, 0xFF9AD646, 0xFF595422, 0xEA3D1515, 0xEA3D1515, 0xEA3D1515, 0xEA3D1515, 
        0xCB4A3822, 0xA8000000, 0xA8000000, 0xA8000000, 0xFB554627, 0xFF400022, 0xFF400022, 0xFF4C1527, 0xFF5A001C, 0xFF5A001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF5A001C, 0xFF46001C, 
        0xFF3D0022, 0xFF35001C, 0xFF35001C, 0xFF55322E, 0xA8000000, 0xA8000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA2000000, 0x9D000000, 0x95000000, 0x8B150000, 0x7E150000, 0x6E000000, 0x5E000000, 0x4E000000, 0x3F000000, 0x32000000, 0x27000000, 
        0x1F000000, 0x19000000, 0x14000000, 0x11000000, 0x10000000, 0x0F000000, 0x0F000000, 0x11000000, 0x14000000, 0x18000000, 0x1D000000, 0x25000000, 0x2C000000, 0x36000000, 0x3F000000, 0x48000000, 0x50150000, 0x58150000, 0x5B150000, 0x5D150000, 
        0x5D150000, 0x5B150000, 0x54150000, 0x4C150000, 0x44000000, 0x39000000, 0x2F000000, 0x24000000, 0x1B000000, 0x13000000, 0x0D000000, 0x09000000, 0x06000000, 0x04000000, 0x02000000, 0x02000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF69862B, 0xFFA3B12E, 0xFFACC32E, 0xFF7E9A22, 0xFF7ECA27, 0xFF74A422, 0xFF626B27, 0xFF69862B, 0xFF69862B, 0xFF727E3B, 0xFF89A422, 0xFF7E9A22, 0xFF69862B, 0xFF69862B, 0xFF606722, 0xFF627D27, 0xFF83BC22, 
        0xFF7DAF2B, 0xFF606722, 0xFF6F7822, 0xFF80B122, 0xFF97C335, 0xFF97C335, 0xFF98B427, 0xFF8FA435, 0xFF7E9A22, 0xFF85A42B, 0xFF83BC22, 0xFEA8C346, 0xFF87BA3B, 0xFE4A3B1C, 0xFF574027, 0xFF69862B, 0xFF627D27, 0xFF626B27, 0xFF8CC92B, 0xFF9AD646, 
        0xFF9AD646, 0xCB4A3822, 0xA8000000, 0xA8000000, 0xFB554627, 0xFF626B27, 0xFF69862B, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF7E9A22, 0xFF7DAF2B, 0xFF97C335, 0xFF9AD646, 0xFF9AD646, 0xD65C672E, 0xA8000000, 0xA8000000, 0xA8000000, 
        0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xC8351500, 0xFE482B1C, 0xFF38001C, 0xFF46001C, 0xFF5A001C, 0xFF5A001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF4C1527, 0xFF3D001C, 
        0xFF3D001C, 0xFF400022, 0xFF35001C, 0xFF3D001C, 0xCB4A3822, 0xA8000000, 0xA7000000, 0xA6000000, 0xA4000000, 0xA0000000, 0x9A000000, 0x93000000, 0x86000000, 0x77000000, 0x67000000, 0x54000000, 0x44000000, 0x33000000, 0x26000000, 0x1C000000, 
        0x15000000, 0x0F000000, 0x0C000000, 0x0A000000, 0x08000000, 0x08000000, 0x08000000, 0x09000000, 0x0B000000, 0x0F000000, 0x13000000, 0x18000000, 0x1F000000, 0x27000000, 0x2F000000, 0x37000000, 0x3F000000, 0x46000000, 0x4C150000, 0x50150000, 
        0x50150000, 0x50150000, 0x4C150000, 0x46000000, 0x3F000000, 0x36000000, 0x2C000000, 0x22000000, 0x19000000, 0x11000000, 0x0B000000, 0x07000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF727E3B, 0xFFA3B12E, 0xFFACC32E, 0xFF87BA3B, 0xFF74A422, 0xFF4C3822, 0xFF595422, 0xFF69862B, 0xFF7E9A22, 0xFF69862B, 0xFF69862B, 0xFF627D27, 0xFF626B27, 0xFF626B27, 0xFF606722, 0xFF7DAF2B, 0xFF7ECA27, 
        0xFF7ECA27, 0xFF74A422, 0xFF606722, 0xFF606722, 0xFF89A422, 0xFF97C335, 0xFF97C335, 0xFF98B427, 0xFF98B427, 0xFF85A42B, 0xFF85A42B, 0xFF87BA3B, 0xFEA8C346, 0xFF74A422, 0xFE482B1C, 0xFF69862B, 0xFF69862B, 0xFF627D27, 0xFF7E9A22, 0xFF97D227, 
        0xFFB6E45F, 0xFF74A422, 0xA8000000, 0xA8000000, 0xA8000000, 0xC8351500, 0xFF595422, 0xFF69862B, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF7E9A22, 0xFF85A42B, 0xFF97C335, 0xFFB3E442, 0xFEA8C346, 0xD65C672E, 0xA8000000, 0xA8000000, 
        0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xC8351500, 0xFF3D001C, 0xFF38001C, 0xFF46001C, 0xFF4C1527, 0xFF5A001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF66001C, 0xFF5A001C, 0xFF46001C, 0xFF3B001C, 
        0xFF3D001C, 0xFF420022, 0xFF2E0015, 0xFF350015, 0xE6502222, 0xA8000000, 0xA7000000, 0xA6000000, 0xA4000000, 0xA0000000, 0x99000000, 0x8F000000, 0x82000000, 0x71000000, 0x5E000000, 0x4C150000, 0x3B000000, 0x2C000000, 0x1D000000, 0x14000000, 
        0x0E000000, 0x09000000, 0x06000000, 0x05000000, 0x04000000, 0x04000000, 0x04000000, 0x05000000, 0x06000000, 0x08000000, 0x0B000000, 0x0F000000, 0x14000000, 0x1A000000, 0x21000000, 0x27000000, 0x2F000000, 0x36000000, 0x3C000000, 0x42000000, 
        0x44000000, 0x46000000, 0x46000000, 0x44000000, 0x3C000000, 0x34000000, 0x2C000000, 0x22000000, 0x19000000, 0x11000000, 0x0B000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF627D27, 0xFFA3B12E, 0xFFACC32E, 0xFFB9C32E, 0xFF69862B, 0xFD461C22, 0xFE482B1C, 0xFF626B27, 0xFF69862B, 0xFF69862B, 0xFF626B27, 0xFF626735, 0xFF595422, 0xFF595422, 0xFF7DAF2B, 0xFF7ECA27, 0xFF7ECA27, 
        0xFF97D227, 0xFFB3E442, 0xFF8CC92B, 0xFF626B27, 0xFF69862B, 0xFF6F7822, 0xFF7E9A22, 0xFEA8C346, 0xFFACC32E, 0xFFACC32E, 0xFF98B427, 0xFF7E9A22, 0xFF80B122, 0xFF97C335, 0xFF74A422, 0xFF627D27, 0xFF69862B, 0xFF69862B, 0xFF69862B, 0xFF97C335, 
        0xFF97D227, 0xFFB6E45F, 0xD65C672E, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xC8351500, 0xFF595422, 0xFF69862B, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF7E9A22, 0xFF97C335, 0xFFBAE42E, 0xFF9AD646, 0xD65C672E, 0xA8000000, 
        0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xEA3D1515, 0xFF3B001C, 0xFF35001C, 0xFF3B001C, 0xFF420022, 0xFF4C1527, 0xFF5A001C, 0xFF5A001C, 0xFF5A001C, 0xFF5A001C, 0xFF4C1527, 0xFF46001C, 0xFF3D001C, 0xFF38001C, 
        0xFF38001C, 0xFF420022, 0xFF3B001C, 0xFF35001C, 0xFF55322E, 0xA8000000, 0xA7000000, 0xA6000000, 0xA3000000, 0x9F000000, 0x98000000, 0x8C000000, 0x7F000000, 0x6E000000, 0x5B000000, 0x46000000, 0x34000000, 0x25000000, 0x18000000, 0x0F000000, 
        0x09000000, 0x05000000, 0x03000000, 0x02000000, 0x01000000, 0x01000000, 0x01000000, 0x02000000, 0x03000000, 0x04000000, 0x06000000, 0x09000000, 0x0C000000, 0x11000000, 0x16000000, 0x1B000000, 0x21000000, 0x27000000, 0x2F000000, 0x34000000, 
        0x3B000000, 0x3C000000, 0x3E000000, 0x3C000000, 0x39000000, 0x33000000, 0x2C000000, 0x22000000, 0x19000000, 0x11000000, 0x0B000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF69862B, 0xFF8FA435, 0xFFD4E62E, 0xFFC8E42E, 0xFEA8C346, 0xFF4C3822, 0xFF4C3822, 0xFF574027, 0xFF69862B, 0xFF69862B, 0xFF595422, 0xFF595422, 0xFE4C3D22, 0xFF7E9A22, 0xFF7ECA27, 0xFF7ECA27, 0xFFADE12E, 
        0xFFB3E442, 0xFFC9EA4C, 0xFFB3E442, 0xFF87BA3B, 0xFF829544, 0xFE482B1C, 0xFE482B1C, 0xFF757522, 0xFF98B427, 0xFFACC32E, 0xFFB9C32E, 0xFFA3B12E, 0xFF7E9A22, 0xFF80B122, 0xFF97C335, 0xFF7E9A22, 0xFF69862B, 0xFF69862B, 0xFF69862B, 0xFF7E9A22, 
        0xFF97D227, 0xFF9AD646, 0xFF97C335, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xE6502222, 0xFF606722, 0xFF69862B, 0xFF74A422, 0xFF74A422, 0xFF74A422, 0xFF7E9A22, 0xFF98B427, 0xFFBAE42E, 0xFF97C335, 0xCB4A3822, 
        0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xFE482B1C, 0xFF38001C, 0xFF38001C, 0xFF35001C, 0xFF35001C, 0xFF3B001C, 0xFF420022, 0xFF46001C, 0xFF46001C, 0xFF3B001C, 0xFF3B001C, 0xFF38001C, 0xFF38001C, 
        0xFF38001C, 0xFF3D001C, 0xFF48002B, 0xFF35001C, 0xFF420022, 0xCB4A3822, 0xA7000000, 0xA6000000, 0xA3000000, 0x9F000000, 0x96000000, 0x8C000000, 0x7E150000, 0x6B151500, 0x58000000, 0x44000000, 0x32000000, 0x22000000, 0x15000000, 0x0D000000, 
        0x07000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x03000000, 0x04000000, 0x07000000, 0x0A000000, 0x0D000000, 0x11000000, 0x16000000, 0x1C000000, 0x22000000, 0x27000000, 
        0x2F000000, 0x33000000, 0x36000000, 0x36000000, 0x34000000, 0x31000000, 0x29000000, 0x22000000, 0x19000000, 0x12000000, 0x0B000000, 0x07000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF69862B, 0xFF7E9A22, 0xFFB9C32E, 0xFFC8E42E, 0xFFC9EA4C, 0xFF595422, 0xFF4C3822, 0xFE503227, 0xFF626735, 0xFF626B27, 0xFF5D542B, 0xFE4C3D22, 0xFF6F7822, 0xFF7ECA27, 0xFF7ECA27, 0xFF9AD646, 0xFFBAE42E, 
        0xFFC9EA4C, 0xFFC9EA4C, 0xFFD4ED6D, 0xFF89A650, 0xC8351500, 0xA8000000, 0xA8000000, 0xFE4A3B1C, 0xFF595422, 0xFF7F7B42, 0xFFACC32E, 0xFFB9C32E, 0xFFACC32E, 0xFF85A42B, 0xFF85A42B, 0xFF97C335, 0xFF74A422, 0xFF69862B, 0xFF69862B, 0xFF627D27, 
        0xFF98B427, 0xFF97D227, 0xFFB6E45F, 0xD65C672E, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xE4553B2B, 0xFF626B27, 0xFF85A42B, 0xFF7DAF2B, 0xFF7DAF2B, 0xFF74A422, 0xFF98B427, 0xFFBAE42E, 0xFF74A422, 
        0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xC8351500, 0xFF400022, 0xFF38001C, 0xFF38001C, 0xFF35001C, 0xFF35001C, 0xFF350022, 0xFF35001C, 0xFF3B001C, 0xFF3B001C, 0xFF3B001C, 0xFF35001C, 0xFF38001C, 
        0xFF3D001C, 0xFF3D001C, 0xFF46001C, 0xFF350015, 0xFF38001C, 0xE6502222, 0xA7000000, 0xA6000000, 0xA3000000, 0x9F000000, 0x98000000, 0x8C000000, 0x7E150000, 0x6B151500, 0x58000000, 0x44000000, 0x31000000, 0x21000000, 0x14000000, 0x0B000000, 
        0x06000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x03000000, 0x05000000, 0x07000000, 0x0A000000, 0x0E000000, 0x12000000, 0x18000000, 0x1D000000, 
        0x23000000, 0x27000000, 0x2C000000, 0x2F000000, 0x2F000000, 0x2C000000, 0x26000000, 0x20000000, 0x18000000, 0x11000000, 0x0B000000, 0x07000000, 0x04000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF69862B, 0xFF74A422, 0xFFA3B12E, 0xFFC8E42E, 0xFFC8E42E, 0xFF85A42B, 0xFF4C3822, 0xFE482B1C, 0xFF4C3822, 0xFF5D542B, 0xFE4C3D22, 0xFF595422, 0xFF83BC22, 0xFF7ECA27, 0xFFADE12E, 0xFFBAE42E, 0xFFC9EA4C, 
        0xFFC9EA4C, 0xFFD4ED6D, 0xFF87994C, 0xC8351500, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xC8351500, 0xFD461C22, 0xFF595422, 0xFF7E9A22, 0xFFACC32E, 0xFFADE12E, 0xFF87BA3B, 0xFF80B122, 0xFF97C335, 0xFF74A422, 0xFF69862B, 0xFF69862B, 
        0xFF7E9A22, 0xFF97C335, 0xFEA8C346, 0xFF97B446, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA6000000, 0xFB554627, 0xFF6F7822, 0xFF7E9A22, 0xFF7DAF2B, 0xFF74A422, 0xFF98B427, 0xFFADE12E, 
        0xFF69862B, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA6000000, 0xFE482B1C, 0xFF38001C, 0xFF3B001C, 0xFF35001C, 0xFF38001C, 0xFF35001C, 0xFF35001C, 0xFF35001C, 0xFF3B001C, 0xFF38001C, 0xFF35001C, 0xFF3D001C, 
        0xFF38001C, 0xFF3D001C, 0xFF420022, 0xFF3B001C, 0xFF2E0015, 0xFF5F3B38, 0xA7000000, 0xA6000000, 0xA4000000, 0x9F000000, 0x98000000, 0x8F000000, 0x7F000000, 0x6E000000, 0x5B000000, 0x44000000, 0x32000000, 0x21000000, 0x15000000, 0x0C000000, 
        0x06000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x02000000, 0x04000000, 0x06000000, 0x08000000, 0x0B000000, 0x0F000000, 0x14000000, 
        0x19000000, 0x1D000000, 0x22000000, 0x25000000, 0x26000000, 0x25000000, 0x21000000, 0x1C000000, 0x16000000, 0x10000000, 0x0B000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF7E9A22, 0xFF7DAF2B, 0xFF7E9A22, 0xFFB9C32E, 0xFFC8E42E, 0xFEA8C346, 0xFF4C3822, 0xFE482B1C, 0xFE482B1C, 0xFF4C3822, 0xFF4C3822, 0xFF74A422, 0xFF7ECA27, 0xFFADE12E, 0xFFBAE42E, 0xFFC9EA4C, 0xFFD4ED6D, 
        0xFFB6E45F, 0xFF727E3B, 0xC8351500, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xC8351500, 0xFE482B1C, 0xFF5D542B, 0xFF7E9A22, 0xFEA8C346, 0xFF97D227, 0xFF83BC22, 0xFF8CC92B, 0xFF7E9A22, 0xFF69862B, 
        0xFF69862B, 0xFF97C335, 0xFF97C335, 0xFFB6E45F, 0xE4553B2B, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA5000000, 0xA4000000, 0xC8351500, 0xFF606722, 0xFF69862B, 0xFF7DAF2B, 0xFF74A422, 0xFF97C335, 
        0xFF97C335, 0xCB4A3822, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA5000000, 0xA3000000, 0xFE482B1C, 0xFF38001C, 0xFF3D0022, 0xFF38001C, 0xFF38001C, 0xFF38001C, 0xFF350022, 0xFF3B001C, 0xFF3B001C, 0xFF38001C, 0xFF3D001C, 
        0xFF400022, 0xFF3D001C, 0xFF420022, 0xFF420022, 0xFF350015, 0xFF46001C, 0xCB4A3822, 0xA6000000, 0xA4000000, 0xA0000000, 0x99000000, 0x8F000000, 0x82000000, 0x71000000, 0x5B000000, 0x48000000, 0x34000000, 0x23000000, 0x16000000, 0x0D000000, 
        0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x03000000, 0x04000000, 0x07000000, 0x09000000, 0x0D000000, 
        0x11000000, 0x15000000, 0x19000000, 0x1C000000, 0x1D000000, 0x1D000000, 0x1B000000, 0x17000000, 0x13000000, 0x0E000000, 0x09000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF7E9A22, 0xFF83BC22, 0xFF7DAF2B, 0xFFA3B12E, 0xFFB9C32E, 0xFFB6E45F, 0xFB554627, 0xFE503227, 0xFF4C3822, 0xFF574027, 0xFF74A422, 0xFF7ECA27, 0xFFB3E442, 0xFFB3E442, 0xFFD4ED6D, 0xFFD4ED6D, 0xFFD4ED6D, 
        0xFF626B27, 0xA5000000, 0xA7000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xC8351500, 0xFE482B1C, 0xFF574027, 0xFF727E3B, 0xFF87BA3B, 0xFF83BC22, 0xFF83BC22, 0xFF7E9A22, 
        0xFF69862B, 0xFF85A42B, 0xFF97C335, 0xFFB9C32E, 0xFF87BA3B, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA4000000, 0xA3000000, 0xA2000000, 0xA0000000, 0xA0000000, 0xC8351500, 0xFF626B27, 0xFF74A422, 0xFF74A422, 
        0xFF97C335, 0xFF80B122, 0xA6000000, 0xA6000000, 0xA6000000, 0xA5000000, 0xA4000000, 0xA2000000, 0xA0000000, 0xEA3D1515, 0xFF3B001C, 0xFF3D001C, 0xFF38001C, 0xFF3D001C, 0xFF38001C, 0xFF350015, 0xFF35001C, 0xFF400015, 0xFF38001C, 0xFF400022, 
        0xFF3D001C, 0xFF3D0022, 0xFF3B001C, 0xFF46001C, 0xFF35001C, 0xFF380015, 0xE6502222, 0xA6000000, 0xA4000000, 0xA0000000, 0x9A000000, 0x91000000, 0x85150000, 0x74000000, 0x61150000, 0x4A000000, 0x37000000, 0x26000000, 0x18000000, 0x0E000000, 
        0x07000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x03000000, 0x05000000, 0x08000000, 
        0x0B000000, 0x0E000000, 0x11000000, 0x13000000, 0x15000000, 0x15000000, 0x14000000, 0x12000000, 0x0E000000, 0x0B000000, 0x07000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0xFF606722, 0xFF80B122, 0xFF7DAF2B, 0xFF98B427, 0xFFC8E42E, 0xFFC8E42E, 0xFF595422, 0xFF4C3822, 0xFF4C3822, 0xFF626B27, 0xFF7ECA27, 0xFFADE12E, 0xFFC9EA4C, 0xFFD4ED6D, 0xFFC9EA4C, 0xFFBAE42E, 0xFFC9EA4C, 
        0xFF87BA3B, 0xA5000000, 0xA7000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xC8351500, 0xFD461C22, 0xFF595422, 0xFF69862B, 0xFF74A422, 0xFF87BA3B, 
        0xFF829544, 0xFF727E3B, 0xFF98B427, 0xFFA3B12E, 0xFEA8C346, 0xC8351500, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA4000000, 0xA2000000, 0xA0000000, 0x9D000000, 0x9D000000, 0x9D000000, 0x9D000000, 0x9D000000, 0xD65C672E, 0xFF7E9A22, 
        0xFF74A422, 0xFF97C335, 0xFF627D27, 0xA5000000, 0xA5000000, 0xA4000000, 0xA2000000, 0x9F000000, 0x9C000000, 0x98000000, 0xFD461C22, 0xFF38001C, 0xFF420022, 0xFF3D0015, 0xFF38001C, 0xFF35001C, 0xFF350015, 0xFF3D001C, 0xFF3D001C, 0xFF3D0022, 
        0xFF3D001C, 0xFF3D001C, 0xFF3B001C, 0xFF46001C, 0xFF3D0022, 0xFF3B001C, 0xFF5A3D22, 0xA7000000, 0xA5000000, 0xA2000000, 0x9C000000, 0x93000000, 0x86000000, 0x77000000, 0x63000000, 0x4E000000, 0x3C000000, 0x2A000000, 0x1B000000, 0x10000000, 
        0x09000000, 0x04000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x02000000, 0x04000000, 
        0x06000000, 0x08000000, 0x0A000000, 0x0C000000, 0x0E000000, 0x0E000000, 0x0E000000, 0x0C000000, 0x0A000000, 0x08000000, 0x05000000, 0x03000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x74404022, 0xFF7E9A22, 0xFF83BC22, 0xFF85A42B, 0xFFB9C32E, 0xFFC8E42E, 0xFF627D27, 0xFF4C3822, 0xFF574027, 0xFF74A422, 0xFFADE12E, 0xFFC9EA4C, 0xFFD4ED6D, 0xFFB6E45F, 0xFF98B427, 0xFFACC32E, 0xFFB3E442, 
        0xFFB6E45F, 0xA5000000, 0xA7000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xEA3D1515, 0xFE4C3D22, 0xFF626B27, 
        0xFF7E9A22, 0xFF6F7822, 0xFF8FA435, 0xFFA3B12E, 0xFFB9C32E, 0xD65C672E, 0xA7000000, 0xA6000000, 0xA5000000, 0xA4000000, 0xA2000000, 0x9F000000, 0x9C000000, 0x9A000000, 0x98000000, 0x97151500, 0x97151500, 0x98000000, 0x9A000000, 0xCB4A3822, 
        0xFF7E9A22, 0xFF80B122, 0xFF85A42B, 0xCB4A3822, 0xA2000000, 0xA0000000, 0x9F000000, 0x9A000000, 0x97151500, 0x91000000, 0x8B150000, 0xFF3B151C, 0xFF3B001C, 0xFF38001C, 0xFF38001C, 0xFF350022, 0xFF35001C, 0xFF38001C, 0xFF3D001C, 0xFF3D0022, 
        0xFF3D0015, 0xFF420022, 0xFF3D001C, 0xFF46001C, 0xFF48002B, 0xFF35001C, 0xFF46001C, 0xCB4A3822, 0xA5000000, 0xA2000000, 0x9D000000, 0x95000000, 0x8A000000, 0x7C000000, 0x67000000, 0x54000000, 0x3F000000, 0x2F000000, 0x1F000000, 0x13000000, 
        0x0A000000, 0x05000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 
        0x03000000, 0x04000000, 0x06000000, 0x07000000, 0x08000000, 0x09000000, 0x09000000, 0x08000000, 0x07000000, 0x05000000, 0x03000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0xFF6F7822, 0xFF83BC22, 0xFF74A422, 0xFFB9C32E, 0xFFC8E42E, 0xFF627D27, 0xFF4C3822, 0xFF626B27, 0xFF97D227, 0xFFC9EA4C, 0xFFC9EA4C, 0xFF89A650, 0xFF98B427, 0xFF98B427, 0xFF98B427, 0xFFBAE42E, 
        0xFFD4ED6D, 0xD65C672E, 0xA7000000, 0xA8000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA6000000, 0xA5000000, 0xA5000000, 0xA5000000, 0xFF574027, 0xFF626735, 
        0xFF626B27, 0xFF69862B, 0xFF8E8140, 0xFFA3B12E, 0xFFA3B12E, 0xFF69862B, 0xA7000000, 0xA6000000, 0xA5000000, 0xA3000000, 0xA0000000, 0x9C000000, 0x97151500, 0x93000000, 0x91000000, 0x8F150000, 0x8F150000, 0x8F150000, 0x93000000, 0x95000000, 
        0xE4553B2B, 0xFF7E9A22, 0xFF87BA3B, 0xFF626B27, 0x9F000000, 0x9D000000, 0x9A000000, 0x97151500, 0x8F150000, 0x8A000000, 0x82000000, 0xFD461C22, 0xFF38001C, 0xFF3D001C, 0xFF38001C, 0xFF35001C, 0xFF38001C, 0xFF35001C, 0xFF3D001C, 0xFF46001C, 
        0xFF3D001C, 0xFF3D001C, 0xFF400015, 0xFF400022, 0xFF46001C, 0xFF38001C, 0xFF3D001C, 0xE6502222, 0xA6000000, 0xA3000000, 0x9F000000, 0x98000000, 0x8C000000, 0x7F000000, 0x6E000000, 0x5B000000, 0x46000000, 0x33000000, 0x23000000, 0x16000000, 
        0x0C000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 
        0x01000000, 0x02000000, 0x03000000, 0x04000000, 0x04000000, 0x05000000, 0x05000000, 0x04000000, 0x04000000, 0x03000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0xCB4A3822, 0xFF7DAF2B, 0xFF83BC22, 0xFFACC32E, 0xFFC8E42E, 0xFF627D27, 0xFB554627, 0xFF87BA3B, 0xFFC9EA4C, 0xFFB6E45F, 0xFF626735, 0xCB4A3822, 0xFF7D7522, 0xFF98B427, 0xFF8FA435, 0xFFACC32E, 
        0xFFC9EA4C, 0xFF87BA3B, 0xA7000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA4000000, 0xA3000000, 0xA3000000, 0xA2000000, 0xA0000000, 0xC8351500, 0xFF757522, 
        0xFF829544, 0xFF829544, 0xFF7D7522, 0xFF8FA435, 0xFFA3B12E, 0xFF87994C, 0xA6000000, 0xA6000000, 0xA4000000, 0xA2000000, 0x9D000000, 0x99000000, 0x93000000, 0x8F150000, 0x8B150000, 0x85150000, 0x85150000, 0x85150000, 0x86000000, 0x8B150000, 
        0x8F000000, 0xE4553B2B, 0xFF7E9A22, 0xFF74A422, 0x9A000000, 0x99000000, 0x97151500, 0x91000000, 0x8B150000, 0x80151500, 0x77150000, 0xA8000000, 0xFF3D001C, 0xFF3D001C, 0xFF3D001C, 0xFF3B001C, 0xFF38001C, 0xFF35001C, 0xFF350015, 0xFF420022, 
        0xFF420022, 0xFF420022, 0xFF420022, 0xFF420022, 0xFF46001C, 0xFF420022, 0xFF3B001C, 0xFF604022, 0xA6000000, 0xA4000000, 0xA0000000, 0x9A000000, 0x8F000000, 0x82000000, 0x74000000, 0x5E000000, 0x4A000000, 0x37000000, 0x27000000, 0x19000000, 
        0x0F000000, 0x08000000, 0x04000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x01000000, 0x01000000, 0x02000000, 0x02000000, 0x02000000, 0x02000000, 0x02000000, 0x02000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0xFF69862B, 0xFF83BC22, 0xFF98B427, 0xFFC8E42E, 0xFF627D27, 0xFF69862B, 0xFFC9EA4C, 0xFF97B446, 0xFB554627, 0x49000000, 0x5E000000, 0xA8000000, 0xFF626B27, 0xFF80B122, 0xFF8FA435, 
        0xFFADE12E, 0xFEA8C346, 0xA7000000, 0xA8000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA3000000, 0xA2000000, 0xA0000000, 0x9D000000, 0x9D000000, 0x9C000000, 0x9C000000, 0xFF655522, 
        0xFF7E9A22, 0xFF829544, 0xFF6F7822, 0xFF829544, 0xFFA3B12E, 0xFF97B446, 0xA5000000, 0xA5000000, 0xA4000000, 0xA0000000, 0x9D000000, 0x97151500, 0x8F150000, 0x8A000000, 0x82000000, 0x7E150000, 0x7A000000, 0x7A000000, 0x7C000000, 0x7E150000, 
        0x82000000, 0x86000000, 0xC8351500, 0xFF7E9A22, 0x93000000, 0x93000000, 0x91000000, 0x8B150000, 0x82000000, 0x7A000000, 0x6F150000, 0x65150000, 0xA3000000, 0xFF3B151C, 0xFF400022, 0xFF3D0022, 0xFF35001C, 0xFF38001C, 0xFF35001C, 0xFF400022, 
        0xFF400015, 0xFF420022, 0xFF400015, 0xFF46001C, 0xFF46001C, 0xFF420022, 0xFF3B001C, 0xFF46001C, 0xCB4A3822, 0xA5000000, 0xA0000000, 0x9C000000, 0x93000000, 0x86000000, 0x77000000, 0x65150000, 0x51000000, 0x3E000000, 0x2C000000, 0x1D000000, 
        0x12000000, 0x0A000000, 0x05000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0xFF606722, 0xFF83BC22, 0xFF98B427, 0xFFBAE42E, 0xFF626B27, 0xFF97C335, 0xFF829544, 0x80151500, 0x34000000, 0x49000000, 0x5E000000, 0x71000000, 0xC8351500, 0xFF727E3B, 0xFF85A42B, 
        0xFFACC32E, 0xFFB6E45F, 0xE4553B2B, 0xA7000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA4000000, 0xA3000000, 0xA0000000, 0x9D000000, 0x9A000000, 0x96000000, 0x95000000, 0x93000000, 0x93000000, 0xC8351500, 
        0xFF7D7522, 0xFF7E9A22, 0xFF727E3B, 0xFF829544, 0xFFA3B12E, 0xFFA3B12E, 0xE4553B2B, 0xA3000000, 0xA2000000, 0xA0000000, 0x9C000000, 0x95000000, 0x8F150000, 0x85150000, 0x7E151C00, 0x74151500, 0x6F150000, 0x6E000000, 0x6E000000, 0x71000000, 
        0x74000000, 0x7C000000, 0x80151500, 0x85150000, 0x8B150000, 0x8B150000, 0x8B150000, 0x85150000, 0x7E151C00, 0x74151500, 0x6B151C00, 0x5D150000, 0x54150000, 0xC8351500, 0xFF3D001C, 0xFF420022, 0xFF38001C, 0xFF38001C, 0xFF350015, 0xFF38001C, 
        0xFF46001C, 0xFF46001C, 0xFF46001C, 0xFF400015, 0xFF46001C, 0xFF46001C, 0xFF3B001C, 0xFF3B001C, 0xE4553B2B, 0xA5000000, 0xA3000000, 0x9D000000, 0x96000000, 0x8B150000, 0x7C000000, 0x6A000000, 0x58000000, 0x44000000, 0x32000000, 0x22000000, 
        0x15000000, 0x0C000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0xCB4A3822, 0xFF7DAF2B, 0xFF98B427, 0xFFADE12E, 0xFF626B27, 0xFF727E3B, 0x77150000, 0x23000000, 0x34000000, 0x49000000, 0x5E000000, 0x71000000, 0x82000000, 0xFB554627, 0xFF7E9A22, 
        0xFF98B427, 0xFFC9EA4C, 0xD65C672E, 0xA7000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA3000000, 0x9F000000, 0x9A000000, 0x96000000, 0x93000000, 0x8C000000, 0x8A000000, 0x86000000, 0x86000000, 0x8A000000, 
        0xFF655522, 0xFF7E9A22, 0xFF829544, 0xFF8E8140, 0xFF8FA435, 0xFFA3B12E, 0xE4553B2B, 0xA0000000, 0xA0000000, 0x9F000000, 0x9A000000, 0x93000000, 0x8B150000, 0x80151500, 0x77150000, 0x6F150000, 0x67000000, 0x61150000, 0x61150000, 0x61150000, 
        0x67000000, 0x6A000000, 0x71000000, 0x7A000000, 0x7E150000, 0x80151500, 0x80151500, 0x7E151C00, 0x7A000000, 0x6F150000, 0x65150000, 0x58150000, 0x50150000, 0x46000000, 0xFD461C22, 0xFF3D001C, 0xFF3B001C, 0xFF3B001C, 0xFF38001C, 0xFF2E0015, 
        0xFF46001C, 0xFF420022, 0xFF420022, 0xFF46001C, 0xFF46001C, 0xFF46001C, 0xFF3B001C, 0xFF3B001C, 0xFF5A3D22, 0xA6000000, 0xA4000000, 0xA0000000, 0x99000000, 0x8F000000, 0x82000000, 0x71000000, 0x5E000000, 0x4A000000, 0x37000000, 0x27000000, 
        0x19000000, 0x0F000000, 0x08000000, 0x04000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xFF7E9A22, 0xFF97C335, 0xFF97D227, 0xEA3D1515, 0x0C000000, 0x16000000, 0x23000000, 0x34000000, 0x48000000, 0x5D150000, 0x71000000, 0x82000000, 0x91000000, 0xFF6F5A22, 
        0xFF8FA435, 0xFFB6E45F, 0xFF74A422, 0xA7000000, 0xA8000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA5000000, 0xA3000000, 0xA0000000, 0x9A000000, 0x96000000, 0x8F000000, 0x86000000, 0x82000000, 0x7C000000, 0x7A000000, 0x77000000, 0x7A000000, 
        0xA8000000, 0xFF7D7522, 0xFF7E9A22, 0xFF7D7522, 0xFF8FA435, 0xFFA3B12E, 0xD65C672E, 0x9C000000, 0x9D000000, 0x9D000000, 0x99000000, 0x93000000, 0x8B150000, 0x80151500, 0x74151500, 0x6B151C00, 0x61150000, 0x58150000, 0x54000000, 0x54000000, 
        0x54000000, 0x5B000000, 0x63000000, 0x6A000000, 0x71000000, 0x74151500, 0x77150000, 0x77150000, 0x74151500, 0x6B151C00, 0x61150000, 0x58150000, 0x4C150000, 0x44000000, 0xC8351500, 0xFF3D001C, 0xFF46001C, 0xFF3B001C, 0xFF38001C, 0xFF2E0015, 
        0xFF3D001C, 0xFF46001C, 0xFF48002B, 0xFF46001C, 0xFF420022, 0xFF420022, 0xFF46001C, 0xFF38001C, 0xFF55322E, 0xA6000000, 0xA5000000, 0xA0000000, 0x9C000000, 0x93000000, 0x86000000, 0x77000000, 0x65150000, 0x51000000, 0x3E000000, 0x2C000000, 
        0x1D000000, 0x12000000, 0x0A000000, 0x05000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xFF7E9A22, 0xFF97C335, 0xFF85A42B, 0x06000000, 0x0C000000, 0x16000000, 0x23000000, 0x34000000, 0x48000000, 0x5D150000, 0x71000000, 0x82000000, 0x8F000000, 0xC8351500, 
        0xFF7D7522, 0xFFA3B12E, 0xFF84AE4C, 0xA7000000, 0xA7000000, 0xA7000000, 0xA7000000, 0xA6000000, 0xA4000000, 0xA0000000, 0x9D000000, 0x96000000, 0x8F000000, 0x85150000, 0x7C000000, 0x74000000, 0x6B151500, 0x67000000, 0x67000000, 0x67000000, 
        0x6B151500, 0xFB554627, 0xFF8E8140, 0xFF7D7522, 0xFF8FA435, 0xFFA3B12E, 0xD65C672E, 0x96000000, 0x98000000, 0x99000000, 0x98000000, 0x93000000, 0x8B150000, 0x80151500, 0x74151500, 0x67000000, 0x5D150000, 0x51000000, 0x4A000000, 0x46000000, 
        0x46000000, 0x4A000000, 0x50150000, 0x58000000, 0x61150000, 0x65150000, 0x6B151500, 0x6B151C00, 0x6B151C00, 0x67000000, 0x61150000, 0x58150000, 0x4C150000, 0x42000000, 0x3B000000, 0xFE482B1C, 0xFF3D001C, 0xFF3D001C, 0xFF3D001C, 0xFF35001C, 
        0xFF2E0015, 0xFF3D001C, 0xFF46001C, 0xFF46001C, 0xFF46001C, 0xFF420022, 0xFF4C1527, 0xFF3D001C, 0xFF400015, 0xCB4A3822, 0xA5000000, 0xA3000000, 0x9D000000, 0x96000000, 0x8B150000, 0x7C000000, 0x6A000000, 0x58000000, 0x44000000, 0x31000000, 
        0x22000000, 0x15000000, 0x0C000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xFF69862B, 0xFF97C335, 0xFF595422, 0x06000000, 0x0C000000, 0x15000000, 0x22000000, 0x33000000, 0x46000000, 0x5B000000, 0x71000000, 0x82000000, 0x8F000000, 0x99000000, 
        0xE6502222, 0xFF8FA435, 0xFF97B446, 0xA7000000, 0xA7000000, 0xA6000000, 0xA6000000, 0xA4000000, 0xA2000000, 0x9D000000, 0x98000000, 0x91000000, 0x86000000, 0x7C000000, 0x6F150000, 0x63000000, 0x5B000000, 0x54000000, 0x54000000, 0x54000000, 
        0x58000000, 0x61150000, 0xFF7D7522, 0xFF7F7B42, 0xFF8FA435, 0xFF8FA435, 0xE4553B2B, 0x8C000000, 0x91000000, 0x93000000, 0x93000000, 0x93000000, 0x8B150000, 0x82000000, 0x77150000, 0x6B151C00, 0x5B150000, 0x4E000000, 0x44000000, 0x3C000000, 
        0x3B000000, 0x3B000000, 0x3F000000, 0x46000000, 0x4E000000, 0x58150000, 0x5D150000, 0x61150000, 0x63000000, 0x61150000, 0x5D150000, 0x54150000, 0x4C150000, 0x42000000, 0x3B000000, 0xC8351500, 0xFF3B001C, 0xFF3B001C, 0xFF3D001C, 0xFF38001C, 
        0xFF35001C, 0xFF380015, 0xFF46001C, 0xFF4C1527, 0xFF4C1527, 0xFF420022, 0xFF46001C, 0xFF46001C, 0xFF3D001C, 0xE6502222, 0xA6000000, 0xA4000000, 0xA0000000, 0x99000000, 0x8F000000, 0x82000000, 0x71000000, 0x5E000000, 0x4A000000, 0x37000000, 
        0x26000000, 0x19000000, 0x0F000000, 0x08000000, 0x04000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xFF7E9A22, 0xFF85A42B, 0xEA3D1515, 0x05000000, 0x0B000000, 0x14000000, 0x21000000, 0x31000000, 0x44000000, 0x5B000000, 0x6E000000, 0x7F000000, 0x8F000000, 0x98000000, 
        0x9F000000, 0xFF896D22, 0xFF97B446, 0xA5000000, 0xA5000000, 0xA5000000, 0xA4000000, 0xA2000000, 0x9F000000, 0x9A000000, 0x93000000, 0x8B150000, 0x7F000000, 0x71000000, 0x63000000, 0x54000000, 0x4C150000, 0x44000000, 0x42000000, 0x42000000, 
        0x46000000, 0x4C150000, 0xFF757522, 0xFF829544, 0xFF8FA435, 0xFF89A650, 0x77000000, 0x7F000000, 0x86000000, 0x8C000000, 0x8F000000, 0x8F000000, 0x8B150000, 0x85150000, 0x7A000000, 0x6B151C00, 0x5D150000, 0x4C150000, 0x3F000000, 0x36000000, 
        0x31000000, 0x2F000000, 0x31000000, 0x36000000, 0x3C000000, 0x44000000, 0x4E000000, 0x54000000, 0x58150000, 0x58150000, 0x58150000, 0x54150000, 0x4C150000, 0x44000000, 0x3B000000, 0x34000000, 0xEA3D1515, 0xFF3B001C, 0xFF420022, 0xFF38001C, 
        0xFF38001C, 0xFF3D001C, 0xFF420022, 0xFF4C1527, 0xFF4C1527, 0xFF420022, 0xFF46001C, 0xFF4C1527, 0xFF400022, 0xEA3D1515, 0xA6000000, 0xA4000000, 0xA0000000, 0x9A000000, 0x93000000, 0x86000000, 0x77000000, 0x65150000, 0x51000000, 0x3E000000, 
        0x2C000000, 0x1D000000, 0x12000000, 0x0A000000, 0x05000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xFF7E9A22, 0xFF626B27, 0x02000000, 0x05000000, 0x0A000000, 0x13000000, 0x1F000000, 0x2F000000, 0x42000000, 0x58000000, 0x6A000000, 0x7C000000, 0x8B150000, 0x96000000, 
        0x9D000000, 0xE6502222, 0xFF727E3B, 0xA3000000, 0xA3000000, 0xA0000000, 0xA0000000, 0x9D000000, 0x9A000000, 0x96000000, 0x8F150000, 0x85150000, 0x77150000, 0x67000000, 0x58150000, 0x4A000000, 0x3E000000, 0x36000000, 0x31000000, 0x31000000, 
        0x34000000, 0x3B000000, 0xCB4A3822, 0xFF829544, 0xFF8FA435, 0xFF69862B, 0x67000000, 0x71000000, 0x7A000000, 0x82000000, 0x86000000, 0x8B150000, 0x8B150000, 0x85150000, 0x7C000000, 0x6F150000, 0x5D150000, 0x4E000000, 0x3E000000, 0x32000000, 
        0x29000000, 0x25000000, 0x25000000, 0x27000000, 0x2F000000, 0x34000000, 0x3C000000, 0x44000000, 0x4A000000, 0x4E000000, 0x50150000, 0x4E000000, 0x4A000000, 0x44000000, 0x3B000000, 0x34000000, 0x8B150000, 0xFF3B001C, 0xFF3D001C, 0xFF400022, 
        0xFF38001C, 0xFF46001C, 0xFF48002B, 0xFF420022, 0xFF4C1527, 0xFF482222, 0xFF3D001C, 0xFF48002B, 0xFF3D001C, 0xEA3D1515, 0xA6000000, 0xA5000000, 0xA2000000, 0x9D000000, 0x96000000, 0x8B150000, 0x7C000000, 0x6A000000, 0x58000000, 0x44000000, 
        0x31000000, 0x22000000, 0x15000000, 0x0C000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xFF727E3B, 0xC8351500, 0x02000000, 0x04000000, 0x09000000, 0x12000000, 0x1D000000, 0x2C000000, 0x3F000000, 0x54000000, 0x67000000, 0x7A000000, 0x86000000, 0x93000000, 
        0x9A000000, 0x9D000000, 0x9F000000, 0x9F000000, 0x9D000000, 0x9C000000, 0x9A000000, 0x98000000, 0x96000000, 0x91000000, 0x8B150000, 0x7E151C00, 0x71000000, 0x61150000, 0x50150000, 0x42000000, 0x33000000, 0x2A000000, 0x24000000, 0x23000000, 
        0x25000000, 0x29000000, 0xCB4A3822, 0xFF829544, 0xFF8FA435, 0xD65C672E, 0x54000000, 0x61150000, 0x6A000000, 0x74000000, 0x7E150000, 0x85150000, 0x86000000, 0x85150000, 0x7C000000, 0x71000000, 0x61150000, 0x50150000, 0x3F000000, 0x31000000, 
        0x26000000, 0x1F000000, 0x1C000000, 0x1D000000, 0x21000000, 0x27000000, 0x2F000000, 0x34000000, 0x3C000000, 0x42000000, 0x46000000, 0x46000000, 0x44000000, 0x42000000, 0x3B000000, 0x33000000, 0x2C000000, 0xEA3D1515, 0xFF3D001C, 0xFF420022, 
        0xFF3B001C, 0xFF48002B, 0xFF420022, 0xFF4C1527, 0xE4553B2B, 0xFB554627, 0xFE4A3B1C, 0xFF4C3822, 0xFF574027, 0xC8351500, 0xA5000000, 0xA5000000, 0xA3000000, 0xA0000000, 0x99000000, 0x8F000000, 0x82000000, 0x71000000, 0x5E000000, 0x4A000000, 
        0x37000000, 0x26000000, 0x19000000, 0x0F000000, 0x08000000, 0x04000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0xCB4A3822, 0x00000000, 0x01000000, 0x04000000, 0x08000000, 0x10000000, 0x1A000000, 0x29000000, 0x3B000000, 0x4E000000, 0x63000000, 0x74000000, 0x85150000, 0x8F000000, 
        0x96000000, 0x99000000, 0x9A000000, 0x99000000, 0x96000000, 0x95000000, 0x93000000, 0x8F000000, 0x8F150000, 0x8B150000, 0x82000000, 0x7A000000, 0x6B151C00, 0x5D150000, 0x4A000000, 0x3B000000, 0x2C000000, 0x22000000, 0x1B000000, 0x18000000, 
        0x19000000, 0x1C000000, 0xCB4A3822, 0xFF8FA435, 0xFF627D27, 0x39000000, 0x44000000, 0x4E000000, 0x5B000000, 0x67000000, 0x74000000, 0x7C000000, 0x82000000, 0x82000000, 0x7E150000, 0x74151500, 0x65150000, 0x54000000, 0x42000000, 0x31000000, 
        0x24000000, 0x1B000000, 0x16000000, 0x15000000, 0x16000000, 0x1B000000, 0x21000000, 0x27000000, 0x2F000000, 0x36000000, 0x3B000000, 0x3E000000, 0x3E000000, 0x3C000000, 0x37000000, 0x31000000, 0x2A000000, 0x27000000, 0xEA3D1515, 0xFF3D001C, 
        0xFF3D001C, 0xFF46001C, 0xFE503227, 0xA6000000, 0x74000000, 0x82000000, 0x8F000000, 0x98000000, 0x9D000000, 0xA2000000, 0xA5000000, 0xA5000000, 0xA4000000, 0xA0000000, 0x9A000000, 0x93000000, 0x86000000, 0x77000000, 0x65150000, 0x51000000, 
        0x3C000000, 0x2C000000, 0x1D000000, 0x12000000, 0x0A000000, 0x05000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x07000000, 0x0E000000, 0x17000000, 0x25000000, 0x36000000, 0x49000000, 0x5B000000, 0x6F150000, 0x7E150000, 0x8A000000, 
        0x8F000000, 0x93000000, 0x93000000, 0x8F000000, 0x8C000000, 0x8A000000, 0x86000000, 0x85150000, 0x82000000, 0x80151500, 0x7E151C00, 0x74151500, 0x67000000, 0x58150000, 0x46000000, 0x37000000, 0x27000000, 0x1D000000, 0x15000000, 0x11000000, 
        0x10000000, 0x12000000, 0x15000000, 0xD65C672E, 0x21000000, 0x29000000, 0x33000000, 0x3E000000, 0x4A000000, 0x58000000, 0x67000000, 0x71000000, 0x7C000000, 0x7F000000, 0x7C000000, 0x74151500, 0x67000000, 0x58150000, 0x44000000, 0x33000000, 
        0x24000000, 0x19000000, 0x12000000, 0x0F000000, 0x0F000000, 0x11000000, 0x16000000, 0x1C000000, 0x22000000, 0x29000000, 0x2F000000, 0x34000000, 0x36000000, 0x34000000, 0x31000000, 0x2C000000, 0x26000000, 0x22000000, 0x80151500, 0xFF46001C, 
        0xFF482222, 0xC8351500, 0xA6444222, 0x58000000, 0x6A000000, 0x7A000000, 0x86000000, 0x93000000, 0x9A000000, 0xA0000000, 0xA3000000, 0xA5000000, 0xA5000000, 0xA2000000, 0x9D000000, 0x96000000, 0x8B150000, 0x7C000000, 0x6A000000, 0x58150000, 
        0x44000000, 0x31000000, 0x21000000, 0x15000000, 0x0C000000, 0x06000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x06000000, 0x0C000000, 0x14000000, 0x21000000, 0x31000000, 0x42000000, 0x54000000, 0x67000000, 0x77000000, 0x82000000, 
        0x86000000, 0x8A000000, 0x8A000000, 0x85150000, 0x7F000000, 0x7C000000, 0x7A000000, 0x77000000, 0x77000000, 0x77150000, 0x74151500, 0x6B151C00, 0x63000000, 0x58150000, 0x46000000, 0x34000000, 0x26000000, 0x1A000000, 0x12000000, 0x0D000000, 
        0x0B000000, 0x0B000000, 0x0D000000, 0x11000000, 0x16000000, 0x1D000000, 0x25000000, 0x31000000, 0x3C000000, 0x4A000000, 0x5B000000, 0x67000000, 0x74000000, 0x7A000000, 0x7C000000, 0x77150000, 0x6B151500, 0x5B000000, 0x48000000, 0x36000000, 
        0x26000000, 0x19000000, 0x10000000, 0x0C000000, 0x0A000000, 0x0B000000, 0x0E000000, 0x12000000, 0x18000000, 0x1D000000, 0x24000000, 0x27000000, 0x2C000000, 0x2C000000, 0x2A000000, 0x26000000, 0x21000000, 0x1D000000, 0x1B000000, 0x1D000000, 
        0x24000000, 0x2F000000, 0x3C000000, 0x4E000000, 0x5E000000, 0x71000000, 0x7F000000, 0x8C000000, 0x96000000, 0x9D000000, 0xA2000000, 0xA4000000, 0xA5000000, 0xA3000000, 0x9F000000, 0x99000000, 0x8F000000, 0x80151500, 0x71000000, 0x5D150000, 
        0x4A000000, 0x36000000, 0x26000000, 0x18000000, 0x0E000000, 0x07000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x05000000, 0x0A000000, 0x11000000, 0x1C000000, 0x2C000000, 0x3C000000, 0x4E000000, 0x61150000, 0x6F150000, 0x7A000000, 
        0x7F000000, 0x7F000000, 0x7C000000, 0x77000000, 0x71000000, 0x6B151500, 0x67000000, 0x67000000, 0x67000000, 0x6A150000, 0x6A150000, 0x65150000, 0x5D150000, 0x54150000, 0x44000000, 0x34000000, 0x26000000, 0x1A000000, 0x10000000, 0x0A000000, 
        0x07000000, 0x06000000, 0x07000000, 0x0A000000, 0x0D000000, 0x13000000, 0x1A000000, 0x24000000, 0x31000000, 0x3F000000, 0x4E000000, 0x5E000000, 0x6A000000, 0x74151500, 0x77150000, 0x74151500, 0x6B151500, 0x5B000000, 0x4A000000, 0x37000000, 
        0x27000000, 0x1A000000, 0x10000000, 0x0A000000, 0x07000000, 0x07000000, 0x08000000, 0x0B000000, 0x10000000, 0x14000000, 0x19000000, 0x1D000000, 0x21000000, 0x22000000, 0x21000000, 0x1D000000, 0x1B000000, 0x17000000, 0x16000000, 0x17000000, 
        0x1D000000, 0x26000000, 0x33000000, 0x44000000, 0x54000000, 0x67000000, 0x77000000, 0x85150000, 0x8F000000, 0x99000000, 0x9F000000, 0xA3000000, 0xA4000000, 0xA4000000, 0xA0000000, 0x9A000000, 0x93000000, 0x85150000, 0x77000000, 0x63000000, 
        0x4E000000, 0x3C000000, 0x2A000000, 0x1B000000, 0x11000000, 0x09000000, 0x04000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x04000000, 0x08000000, 0x0F000000, 0x18000000, 0x26000000, 0x34000000, 0x46000000, 0x58000000, 0x65150000, 0x6F150000, 
        0x74000000, 0x74000000, 0x6E000000, 0x67000000, 0x61150000, 0x5B000000, 0x58000000, 0x54000000, 0x58150000, 0x5B150000, 0x5D150000, 0x5D150000, 0x58150000, 0x50150000, 0x44000000, 0x34000000, 0x26000000, 0x1A000000, 0x10000000, 0x09000000, 
        0x06000000, 0x04000000, 0x04000000, 0x05000000, 0x08000000, 0x0C000000, 0x12000000, 0x1A000000, 0x25000000, 0x33000000, 0x44000000, 0x54000000, 0x61150000, 0x6E000000, 0x74151500, 0x71000000, 0x6B151500, 0x5D150000, 0x4C150000, 0x3B000000, 
        0x29000000, 0x1B000000, 0x10000000, 0x09000000, 0x05000000, 0x04000000, 0x04000000, 0x07000000, 0x0A000000, 0x0D000000, 0x11000000, 0x15000000, 0x18000000, 0x19000000, 0x19000000, 0x17000000, 0x14000000, 0x11000000, 0x10000000, 0x11000000, 
        0x16000000, 0x1D000000, 0x29000000, 0x37000000, 0x49000000, 0x5B000000, 0x6B151500, 0x7C000000, 0x8A000000, 0x93000000, 0x9C000000, 0xA0000000, 0xA3000000, 0xA3000000, 0xA0000000, 0x9D000000, 0x95000000, 0x8A000000, 0x7A000000, 0x67000000, 
        0x54000000, 0x3F000000, 0x2F000000, 0x1F000000, 0x13000000, 0x0A000000, 0x05000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x06000000, 0x0C000000, 0x15000000, 0x21000000, 0x2F000000, 0x3F000000, 0x4E000000, 0x5B000000, 0x63000000, 
        0x67000000, 0x65150000, 0x5E000000, 0x58000000, 0x4E000000, 0x48000000, 0x44000000, 0x44000000, 0x46000000, 0x4C150000, 0x51000000, 0x54150000, 0x50150000, 0x4C150000, 0x3F000000, 0x33000000, 0x26000000, 0x1A000000, 0x10000000, 0x09000000, 
        0x05000000, 0x03000000, 0x02000000, 0x02000000, 0x04000000, 0x07000000, 0x0C000000, 0x13000000, 0x1D000000, 0x2A000000, 0x39000000, 0x49000000, 0x58150000, 0x65150000, 0x6E000000, 0x6F150000, 0x67000000, 0x5D150000, 0x4C150000, 0x3B000000, 
        0x29000000, 0x1B000000, 0x10000000, 0x09000000, 0x05000000, 0x03000000, 0x02000000, 0x03000000, 0x05000000, 0x08000000, 0x0B000000, 0x0D000000, 0x10000000, 0x11000000, 0x11000000, 0x10000000, 0x0E000000, 0x0C000000, 0x0B000000, 0x0C000000, 
        0x10000000, 0x17000000, 0x21000000, 0x2F000000, 0x3E000000, 0x50150000, 0x63000000, 0x74000000, 0x82000000, 0x8F000000, 0x96000000, 0x9D000000, 0xA0000000, 0xA2000000, 0xA0000000, 0x9D000000, 0x96000000, 0x8B150000, 0x7C000000, 0x6B151500, 
        0x58150000, 0x44000000, 0x32000000, 0x21000000, 0x15000000, 0x0C000000, 0x06000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x05000000, 0x0A000000, 0x12000000, 0x1C000000, 0x29000000, 0x37000000, 0x46000000, 0x51000000, 0x58000000, 
        0x5B000000, 0x58000000, 0x50150000, 0x46000000, 0x3E000000, 0x37000000, 0x34000000, 0x34000000, 0x37000000, 0x3E000000, 0x44000000, 0x48000000, 0x48000000, 0x44000000, 0x3C000000, 0x31000000, 0x25000000, 0x19000000, 0x10000000, 0x09000000, 
        0x05000000, 0x02000000, 0x01000000, 0x01000000, 0x02000000, 0x04000000, 0x08000000, 0x0E000000, 0x16000000, 0x22000000, 0x31000000, 0x3F000000, 0x4E000000, 0x5D150000, 0x65150000, 0x67000000, 0x65150000, 0x58150000, 0x4A000000, 0x39000000, 
        0x29000000, 0x1B000000, 0x10000000, 0x09000000, 0x04000000, 0x02000000, 0x01000000, 0x01000000, 0x03000000, 0x04000000, 0x06000000, 0x08000000, 0x0A000000, 0x0B000000, 0x0B000000, 0x0A000000, 0x09000000, 0x08000000, 0x07000000, 0x08000000, 
        0x0B000000, 0x11000000, 0x19000000, 0x25000000, 0x34000000, 0x44000000, 0x58000000, 0x6A000000, 0x7A000000, 0x86000000, 0x93000000, 0x9A000000, 0x9D000000, 0xA0000000, 0x9F000000, 0x9C000000, 0x95000000, 0x8B150000, 0x7E150000, 0x6E000000, 
        0x5B150000, 0x46000000, 0x34000000, 0x23000000, 0x16000000, 0x0D000000, 0x07000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x04000000, 0x08000000, 0x0F000000, 0x18000000, 0x24000000, 0x31000000, 0x3C000000, 0x46000000, 0x4C150000, 
        0x4E000000, 0x49000000, 0x42000000, 0x37000000, 0x2F000000, 0x29000000, 0x26000000, 0x27000000, 0x2A000000, 0x31000000, 0x37000000, 0x3C000000, 0x3F000000, 0x3C000000, 0x36000000, 0x2C000000, 0x22000000, 0x18000000, 0x0F000000, 0x09000000, 
        0x04000000, 0x02000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x05000000, 0x0A000000, 0x11000000, 0x1B000000, 0x27000000, 0x37000000, 0x46000000, 0x54000000, 0x5D150000, 0x61150000, 0x5D150000, 0x54150000, 0x46000000, 0x37000000, 
        0x27000000, 0x1A000000, 0x10000000, 0x08000000, 0x04000000, 0x01000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x03000000, 0x04000000, 0x05000000, 0x06000000, 0x06000000, 0x06000000, 0x05000000, 0x05000000, 0x04000000, 0x05000000, 
        0x07000000, 0x0C000000, 0x13000000, 0x1D000000, 0x2C000000, 0x3B000000, 0x4E000000, 0x5E000000, 0x71000000, 0x7F000000, 0x8B150000, 0x93000000, 0x99000000, 0x9C000000, 0x9A000000, 0x98000000, 0x93000000, 0x8A000000, 0x7C000000, 0x6B151500, 
        0x5B150000, 0x46000000, 0x34000000, 0x24000000, 0x17000000, 0x0D000000, 0x07000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x07000000, 0x0C000000, 0x15000000, 0x1D000000, 0x2A000000, 0x34000000, 0x3C000000, 0x42000000, 
        0x3F000000, 0x3B000000, 0x34000000, 0x2C000000, 0x23000000, 0x1D000000, 0x1B000000, 0x1B000000, 0x1F000000, 0x25000000, 0x2C000000, 0x31000000, 0x34000000, 0x34000000, 0x2F000000, 0x27000000, 0x1F000000, 0x16000000, 0x0E000000, 0x08000000, 
        0x04000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x07000000, 0x0D000000, 0x16000000, 0x21000000, 0x2F000000, 0x3C000000, 0x4A000000, 0x54150000, 0x58150000, 0x58150000, 0x50150000, 0x42000000, 0x33000000, 
        0x25000000, 0x18000000, 0x0F000000, 0x08000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x02000000, 0x02000000, 0x03000000, 0x03000000, 0x03000000, 0x03000000, 0x02000000, 0x02000000, 0x03000000, 
        0x05000000, 0x08000000, 0x0E000000, 0x17000000, 0x23000000, 0x31000000, 0x42000000, 0x54000000, 0x65150000, 0x74000000, 0x82000000, 0x8C000000, 0x93000000, 0x95000000, 0x93000000, 0x91000000, 0x8C000000, 0x82000000, 0x77000000, 0x67000000, 
        0x58000000, 0x44000000, 0x33000000, 0x24000000, 0x17000000, 0x0D000000, 0x07000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x06000000, 0x0A000000, 0x11000000, 0x1A000000, 0x23000000, 0x2C000000, 0x33000000, 0x36000000, 
        0x34000000, 0x31000000, 0x27000000, 0x20000000, 0x19000000, 0x14000000, 0x12000000, 0x12000000, 0x16000000, 0x1B000000, 0x21000000, 0x26000000, 0x2A000000, 0x2A000000, 0x27000000, 0x21000000, 0x1A000000, 0x13000000, 0x0C000000, 0x07000000, 
        0x04000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x05000000, 0x0A000000, 0x11000000, 0x1B000000, 0x27000000, 0x34000000, 0x3F000000, 0x4A000000, 0x50150000, 0x4E000000, 0x46000000, 0x3C000000, 0x2F000000, 
        0x21000000, 0x16000000, 0x0D000000, 0x07000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 
        0x03000000, 0x06000000, 0x0A000000, 0x12000000, 0x1C000000, 0x29000000, 0x37000000, 0x49000000, 0x5B000000, 0x6A000000, 0x77000000, 0x82000000, 0x86000000, 0x8B150000, 0x8A000000, 0x86000000, 0x82000000, 0x7A000000, 0x6E000000, 0x61150000, 
        0x51000000, 0x3F000000, 0x31000000, 0x22000000, 0x16000000, 0x0D000000, 0x07000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x04000000, 0x08000000, 0x0E000000, 0x15000000, 0x1D000000, 0x24000000, 0x29000000, 0x2C000000, 
        0x2A000000, 0x25000000, 0x1F000000, 0x18000000, 0x12000000, 0x0D000000, 0x0C000000, 0x0C000000, 0x0E000000, 0x13000000, 0x18000000, 0x1C000000, 0x20000000, 0x20000000, 0x1F000000, 0x1A000000, 0x15000000, 0x0F000000, 0x0A000000, 0x06000000, 
        0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x07000000, 0x0D000000, 0x16000000, 0x20000000, 0x2C000000, 0x37000000, 0x3F000000, 0x44000000, 0x44000000, 0x3C000000, 0x34000000, 0x27000000, 
        0x1D000000, 0x13000000, 0x0B000000, 0x06000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x02000000, 0x04000000, 0x07000000, 0x0D000000, 0x15000000, 0x20000000, 0x2F000000, 0x3C000000, 0x4E000000, 0x5D150000, 0x6A000000, 0x74000000, 0x7A000000, 0x7C000000, 0x7C000000, 0x7A000000, 0x74000000, 0x6B151500, 0x63000000, 0x54000000, 
        0x48000000, 0x39000000, 0x2C000000, 0x1D000000, 0x13000000, 0x0B000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x07000000, 0x0B000000, 0x11000000, 0x17000000, 0x1C000000, 0x20000000, 0x21000000, 
        0x20000000, 0x1C000000, 0x16000000, 0x11000000, 0x0C000000, 0x08000000, 0x07000000, 0x07000000, 0x09000000, 0x0C000000, 0x10000000, 0x14000000, 0x17000000, 0x18000000, 0x17000000, 0x14000000, 0x10000000, 0x0B000000, 0x07000000, 0x04000000, 
        0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x05000000, 0x0A000000, 0x11000000, 0x1A000000, 0x23000000, 0x2C000000, 0x34000000, 0x39000000, 0x37000000, 0x33000000, 0x2C000000, 0x21000000, 
        0x18000000, 0x0F000000, 0x09000000, 0x05000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x01000000, 0x02000000, 0x05000000, 0x09000000, 0x10000000, 0x19000000, 0x25000000, 0x32000000, 0x3F000000, 0x4E000000, 0x5B000000, 0x63000000, 0x6A000000, 0x6B151500, 0x6B151500, 0x67000000, 0x63000000, 0x5B000000, 0x51000000, 0x48000000, 
        0x3C000000, 0x31000000, 0x24000000, 0x19000000, 0x10000000, 0x0A000000, 0x05000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x05000000, 0x08000000, 0x0D000000, 0x11000000, 0x15000000, 0x18000000, 0x19000000, 
        0x17000000, 0x14000000, 0x10000000, 0x0B000000, 0x08000000, 0x05000000, 0x04000000, 0x04000000, 0x05000000, 0x08000000, 0x0B000000, 0x0D000000, 0x0F000000, 0x10000000, 0x10000000, 0x0E000000, 0x0B000000, 0x08000000, 0x05000000, 0x03000000, 
        0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02000000, 0x04000000, 0x08000000, 0x0D000000, 0x14000000, 0x1C000000, 0x24000000, 0x2A000000, 0x2C000000, 0x2C000000, 0x29000000, 0x22000000, 0x1B000000, 
        0x13000000, 0x0C000000, 0x07000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x01000000, 0x03000000, 0x06000000, 0x0B000000, 0x13000000, 0x1C000000, 0x27000000, 0x34000000, 0x3F000000, 0x4A000000, 0x54000000, 0x58000000, 0x5B000000, 0x58000000, 0x54000000, 0x50150000, 0x49000000, 0x42000000, 0x39000000, 
        0x2F000000, 0x25000000, 0x1C000000, 0x14000000, 0x0D000000, 0x07000000, 0x04000000, 0x02000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x03000000, 0x06000000, 0x09000000, 0x0C000000, 0x0F000000, 0x11000000, 0x11000000, 
        0x10000000, 0x0E000000, 0x0B000000, 0x07000000, 0x05000000, 0x03000000, 0x02000000, 0x02000000, 0x03000000, 0x04000000, 0x06000000, 0x08000000, 0x0A000000, 0x0A000000, 0x0A000000, 0x09000000, 0x07000000, 0x05000000, 0x03000000, 0x02000000, 
        0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x05000000, 0x0A000000, 0x0F000000, 0x15000000, 0x1B000000, 0x20000000, 0x22000000, 0x22000000, 0x1F000000, 0x1A000000, 0x14000000, 
        0x0E000000, 0x09000000, 0x05000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x01000000, 0x02000000, 0x04000000, 0x08000000, 0x0D000000, 0x15000000, 0x1D000000, 0x27000000, 0x31000000, 0x3B000000, 0x42000000, 0x44000000, 0x46000000, 0x44000000, 0x42000000, 0x3C000000, 0x37000000, 0x31000000, 0x2A000000, 
        0x23000000, 0x1B000000, 0x14000000, 0x0E000000, 0x09000000, 0x05000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x04000000, 0x06000000, 0x08000000, 0x0A000000, 0x0B000000, 0x0B000000, 
        0x0A000000, 0x09000000, 0x07000000, 0x04000000, 0x03000000, 0x02000000, 0x01000000, 0x01000000, 0x01000000, 0x02000000, 0x03000000, 0x05000000, 0x05000000, 0x06000000, 0x06000000, 0x05000000, 0x04000000, 0x03000000, 0x02000000, 0x01000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x04000000, 0x07000000, 0x0A000000, 0x0F000000, 0x13000000, 0x16000000, 0x18000000, 0x18000000, 0x16000000, 0x12000000, 0x0E000000, 
        0x0A000000, 0x06000000, 0x03000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x05000000, 0x09000000, 0x0E000000, 0x15000000, 0x1C000000, 0x24000000, 0x2C000000, 0x31000000, 0x33000000, 0x34000000, 0x32000000, 0x2F000000, 0x2C000000, 0x27000000, 0x22000000, 0x1D000000, 
        0x18000000, 0x12000000, 0x0E000000, 0x09000000, 0x06000000, 0x03000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x04000000, 0x05000000, 0x06000000, 0x07000000, 0x07000000, 
        0x06000000, 0x05000000, 0x04000000, 0x02000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x02000000, 0x03000000, 0x03000000, 0x03000000, 0x03000000, 0x02000000, 0x01000000, 0x01000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x04000000, 0x07000000, 0x0A000000, 0x0D000000, 0x0F000000, 0x10000000, 0x10000000, 0x0E000000, 0x0C000000, 0x09000000, 
        0x06000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x03000000, 0x06000000, 0x09000000, 0x0E000000, 0x13000000, 0x18000000, 0x1D000000, 0x21000000, 0x23000000, 0x24000000, 0x22000000, 0x20000000, 0x1D000000, 0x19000000, 0x16000000, 0x12000000, 
        0x0F000000, 0x0C000000, 0x08000000, 0x06000000, 0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x02000000, 0x03000000, 0x03000000, 0x04000000, 0x04000000, 
        0x03000000, 0x03000000, 0x02000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x04000000, 0x06000000, 0x08000000, 0x09000000, 0x0A000000, 0x0A000000, 0x09000000, 0x07000000, 0x05000000, 
        0x04000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x03000000, 0x06000000, 0x08000000, 0x0C000000, 0x0F000000, 0x13000000, 0x15000000, 0x16000000, 0x17000000, 0x16000000, 0x14000000, 0x12000000, 0x0F000000, 0x0D000000, 0x0B000000, 
        0x08000000, 0x06000000, 0x05000000, 0x03000000, 0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x02000000, 0x02000000, 0x02000000, 
        0x01000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x02000000, 0x03000000, 0x04000000, 0x05000000, 0x05000000, 0x05000000, 0x05000000, 0x04000000, 0x03000000, 
        0x02000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x02000000, 0x03000000, 0x05000000, 0x07000000, 0x09000000, 0x0B000000, 0x0C000000, 0x0D000000, 0x0D000000, 0x0C000000, 0x0B000000, 0x0A000000, 0x08000000, 0x07000000, 0x05000000, 
        0x04000000, 0x03000000, 0x02000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x02000000, 0x02000000, 0x03000000, 0x03000000, 0x02000000, 0x02000000, 0x01000000, 
        0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x02000000, 0x03000000, 0x05000000, 0x06000000, 0x06000000, 0x07000000, 0x07000000, 0x06000000, 0x06000000, 0x05000000, 0x04000000, 0x03000000, 0x02000000, 
        0x02000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x02000000, 0x02000000, 0x03000000, 0x03000000, 0x03000000, 0x03000000, 0x02000000, 0x02000000, 0x01000000, 0x01000000, 0x01000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x01000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000
#else
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0x2D447278, 0x3422384A, 0x006D627D, 0x00575970, 0x004A4062, 0x004A4062, 0x00383B5F, 0x00383B5F, 0x00383B5F, 0x0027154C, 0x002E3255, 0x002E3255, 0x00383B5F, 0x004A4062, 0x006D627D, 0x3422384A, 0x8B224040, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x8B224040, 0x004A4062, 0x004A4062, 0x004A4062, 0x002E3255, 
        0x004A4062, 0x00575970, 0x00575970, 0x00575970, 0x00575970, 0x004A4062, 0x004A4062, 0x004A4062, 0x004A4062, 0x004A4062, 0x004A4062, 0x004A4062, 0x00383B5F, 0x002E3255, 0x002E3255, 0x00222248, 0x0022003D, 0x001C003B, 0x002B0048, 0x00383B5F, 
        0x1B2B3B55, 0x3422384A, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x8B224040, 0x3422384A, 0x004A4062, 0x002E3255, 0x00485263, 0x00787283, 0x00787283, 0x00787283, 0x006D627D, 
        0x00575970, 0x00485263, 0x006D627D, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 0x00787283, 0x00787283, 0x00787283, 0x006D627D, 0x00575970, 0x00575970, 0x004A4062, 0x004A4062, 0x002E3255, 0x0027154C, 0x002B0048, 
        0x00220040, 0x001C003B, 0x001C003B, 0x002E3255, 0x3422384A, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x2D447278, 0x3422384A, 0x00575970, 0x00575970, 0x006D627D, 0x006D627D, 0x00787283, 0x006D627D, 0x00575970, 0x006D627D, 0x00948490, 0x00B6A7AC, 
        0x00B6A7AC, 0x00B6A7AC, 0x00B6A7AC, 0x00B6A7AC, 0x00948490, 0x00787283, 0x006D627D, 0x006D627D, 0x006D627D, 0x00575970, 0x004A4062, 0x004A4062, 0x004A4062, 0x004A4062, 0x00383B5F, 0x002E3255, 0x0027154C, 0x0027154C, 0x0027154C, 0x002B0048, 
        0x001C0046, 0x00220042, 0x001C003D, 0x0015002E, 0x001C0035, 0x002B0048, 0x1B2B3B55, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x8B224040, 0x2D447278, 0x00575970, 0x004A4062, 0x006D627D, 0x00787283, 0x00787283, 0x00787283, 0x00485263, 0x00948490, 0x00B6A7AC, 0x00B6A7AC, 0x00B6A7AC, 0x00B6A7AC, 0x00948490, 
        0x00787283, 0x00787283, 0x00787283, 0x00787283, 0x00787283, 0x00787283, 0x00787283, 0x00787283, 0x00787283, 0x006D627D, 0x00787283, 0x006D627D, 0x00575970, 0x00575970, 0x00485263, 0x00383B5F, 0x002E3255, 0x002B0048, 0x002B0048, 0x002B0048, 
        0x00220042, 0x00220042, 0x00220042, 0x001C0038, 0x001C003B, 0x001C0035, 0x001C0035, 0x002E3255, 0x006D627D, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x90000015, 0x00787283, 0x00787283, 0x002E3255, 0x00575970, 0x00B6A7AC, 0x00787283, 0x00575970, 0x00B6A7AC, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00948490, 0x006D627D, 0x006D627D, 0x006D627D, 0x006D627D, 
        0x00787283, 0x00948490, 0x00948490, 0x00948490, 0x00B6A7AC, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00B6A7AC, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 0x00787283, 0x00575970, 0x00485263, 0x004A4062, 0x002E3255, 0x0027154C, 0x002B0048, 
        0x00220042, 0x00220042, 0x00220042, 0x0022003D, 0x001C0038, 0x00150035, 0x001C0035, 0x001C0035, 0x001C003B, 0x003D5783, 0x8B224040, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x2D447278, 0x00575970, 0x00383B5F, 0x0027154C, 0x00948490, 0x00C6BEC2, 0x00C6BEC2, 0x00B6A7AC, 0x00B6A7AC, 0x00948490, 0x006D627D, 0x00575970, 0x004A4062, 0x00575970, 0x00575970, 0x006D627D, 0x00787283, 0x00948490, 
        0x00B6A7AC, 0x00B6A7AC, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00B6A7AC, 0x00948490, 0x00948490, 0x00787283, 0x00787283, 0x006D627D, 0x00575970, 0x004A4062, 0x002E3255, 0x0027154C, 0x002B0048, 0x001C0046, 
        0x00220042, 0x001C003D, 0x001C0038, 0x001C003B, 0x001C0035, 0x001C0035, 0x0015002E, 0x001C0035, 0x001C0035, 0x001C0038, 0x003D5783, 0x8B224040, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x90000015, 
        0x37001535, 0x00948490, 0x002E3255, 0x00222248, 0x0027154C, 0x00383B5F, 0x004A4062, 0x00575970, 0x00485263, 0x002E3255, 0x00383B5F, 0x004A4062, 0x00485263, 0x00575970, 0x00575970, 0x006D627D, 0x00948490, 0x00948490, 0x00948490, 0x00B6A7AC, 
        0x00B6A7AC, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00C6BEC2, 0x00B6A7AC, 0x00948490, 0x00948490, 0x00787283, 0x006D627D, 0x006D627D, 0x006D627D, 0x004A4062, 0x002E3255, 0x0027154C, 0x002B0048, 0x0027154C, 0x00220040, 0x00220042, 
        0x00220042, 0x00220042, 0x001C003B, 0x0015002E, 0x001C0035, 0x001C0035, 0x001C0035, 0x0015002E, 0x00150035, 0x001C0035, 0x001C003B, 0x00272E90, 0x8B224040, 0xFA000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x3422384A, 0x004A4062, 0x0027154C, 0x00220042, 
        0x002E3255, 0x00274057, 0x0027154C, 0x0027154C, 0x002E3255, 0x00383B5F, 0x0027154C, 0x002E3255, 0x00383B5F, 0x00383B5F, 0x00485263, 0x00485263, 0x00575970, 0x006D627D, 0x00787283, 0x00948490, 0x00948490, 0x00948490, 0x00B6A7AC, 0x00B6A7AC, 
        0x00B6A7AC, 0x00C6BEC2, 0x00C6BEC2, 0x00B6A7AC, 0x00B6A7AC, 0x00948490, 0x00948490, 0x00948490, 0x00787283, 0x006D627D, 0x006D627D, 0x00575970, 0x00485263, 0x004A4062, 0x00383B5F, 0x002E3255, 0x002B0048, 0x002B0048, 0x001C003D, 0x001C003B, 
        0x001C0038, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C0035, 0x00220035, 0x001C0035, 0x001C0035, 0x0015002E, 0x00150035, 0x001C0038, 0x00220040, 0x00B6A7AC, 0xF5000000, 0xF6000000, 0xF8000000, 0xF9000000, 0xFB000000, 0xFC000000, 0xFD000000, 
        0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x37001535, 0x1515153D, 0x002B0048, 0x00220040, 0x00220040, 0x0027154C, 0x0022003D, 
        0x002276A3, 0x002287AD, 0x00225A6F, 0x00383B5F, 0x00485263, 0x00485263, 0x00383B5F, 0x00383B5F, 0x00383B5F, 0x004A4062, 0x00575970, 0x00575970, 0x00787283, 0x00787283, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 0x00B6A7AC, 0x00B6A7AC, 
        0x00B6A7AC, 0x00B6A7AC, 0x00B6A7AC, 0x00948490, 0x00948490, 0x00948490, 0x00787283, 0x00787283, 0x006D627D, 0x006D627D, 0x004A4062, 0x004A4062, 0x00383B5F, 0x002B0048, 0x00220040, 0x0022003D, 0x001C003B, 0x001C003B, 0x37001535, 0x37001535, 
        0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x1515153D, 0x001C0066, 0xED000000, 0xEF000000, 0xF1000000, 0xF4000000, 0xF6000000, 0xF8000000, 0xF9000000, 
        0xFB000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x37001535, 0x1515153D, 0x001C003D, 0x001C003D, 0x001C003B, 0x001C0038, 0x001C003D, 0x0027154C, 0x001C0046, 
        0x001C7EC8, 0x001CD2FC, 0x0046BED8, 0x00427B7F, 0x00575970, 0x00485263, 0x00383B5F, 0x00383B5F, 0x00383B5F, 0x00485263, 0x00575970, 0x00575970, 0x006D627D, 0x00787283, 0x00787283, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 
        0x00948490, 0x00948490, 0x00B6A7AC, 0x00948490, 0x00948490, 0x00948490, 0x006D627D, 0x00575970, 0x004A4062, 0x00383B5F, 0x002B0048, 0x002B0048, 0x01273250, 0x37001535, 0x37001535, 0x37001535, 0x37001535, 0x74000015, 0xCB000000, 0xCB000000, 
        0xCB000000, 0xCB000000, 0xCB000000, 0xCB000000, 0xCB000000, 0xCC000000, 0xCE000000, 0xD0000000, 0xD3000000, 0xD3000000, 0xD8000000, 0xDA000000, 0x37001535, 0xE2000000, 0xE4000000, 0xE8000000, 0xEB000000, 0xEE000000, 0xF1000000, 0xF4000000, 
        0xF7000000, 0xF9000000, 0xFB000000, 0xFC000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x90000015, 0x1515153D, 0x001C003B, 0x001C0038, 0x001C003D, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C003D, 0x002E3255, 0x002E3255, 
        0x001C7EC8, 0x001CE0FB, 0x0032E6FA, 0x0046BED8, 0x004C9987, 0x00575970, 0x00575970, 0x00575970, 0x00575970, 0x00485263, 0x00575970, 0x00575970, 0x006D627D, 0x006D627D, 0x00787283, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 0x00948490, 
        0x00B6A7AC, 0x00B6A7AC, 0x00948490, 0x006D627D, 0x004A4062, 0x00222248, 0x0027154C, 0x1515153D, 0x37001535, 0xCD000000, 0xCB000000, 0xC6000000, 0xC3000000, 0xC0000000, 0xBD000000, 0xBB000000, 0xBB000000, 0xB9000000, 0xB7000000, 0xB7000000, 
        0xB6000000, 0xB6000000, 0xB6000000, 0xB7000000, 0xB9000000, 0xB9000000, 0xBB000000, 0xBB000000, 0xC0000000, 0xC3000000, 0xC6000000, 0xC9000000, 0xCD000000, 0xD0000000, 0xD6000000, 0xDA000000, 0xDF000000, 0xE4000000, 0xE8000000, 0xEC000000, 
        0xF0000000, 0xF4000000, 0xF7000000, 0xFA000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x90000015, 0x00220042, 0x001C003D, 0x001C0038, 0x001C003D, 0x001C0066, 0x01221C8D, 0x001C0066, 0x0027154C, 0x001C003D, 0x00220040, 0x00575970, 
        0x001C7EC8, 0x0022E4FC, 0x0040EDFC, 0x007AF0F5, 0x006DEDD4, 0x00B6A7AC, 0x00948490, 0x00787283, 0x006D627D, 0x006D627D, 0x00575970, 0x00575970, 0x00575970, 0x006D627D, 0x006D627D, 0x00948490, 0x00948490, 0x00948490, 0x00B6A7AC, 0x00948490, 
        0x00787283, 0x00383B5F, 0x00222248, 0x00222248, 0x37001535, 0xCB000000, 0xC6000000, 0xC3000000, 0xBD000000, 0xBB000000, 0xB6000000, 0xB1000000, 0xAF000015, 0xAB000000, 0xAB000000, 0xA7000000, 0xA4000000, 0xA4000000, 0xA2000015, 0xA2000015, 
        0xA1000000, 0xA1000000, 0xA1000000, 0xA2000015, 0xA4000000, 0xA4000000, 0xA4000000, 0xA7000000, 0xAB000000, 0xAE000000, 0xB1000000, 0xB6000000, 0xBB000000, 0xC0000000, 0xC4000000, 0xCB000000, 0xCE000000, 0xD5000000, 0xDB000000, 0xE2000000, 
        0xE7000000, 0xEC000000, 0xF1000000, 0xF5000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x94001C15, 0x00220040, 0x001C003D, 0x001C003B, 0x001C0046, 0x00222B99, 0x001C7EC8, 0x001C7EC8, 0x001C7EC8, 0x00222B99, 0x01221C8D, 0x001C0066, 0x00575970, 
        0x001C7EC8, 0x0022E9FF, 0x0040EDFC, 0x007AF0F5, 0x007AF0F5, 0x00C6BEC2, 0x00B6A7AC, 0x00C6BEC2, 0x006D627D, 0x00485263, 0x004A4062, 0x004A4062, 0x004A4062, 0x00575970, 0x006D627D, 0x00948490, 0x00B6A7AC, 0x00948490, 0x00575970, 0x002E3255, 
        0x1515153D, 0x74000015, 0xC8000000, 0xC3000000, 0xBD000000, 0xB9000000, 0xB3000015, 0xAE000000, 0xAB000000, 0xA4000000, 0xA1000000, 0x9E000015, 0x9A000015, 0x98000000, 0x95000000, 0x91000000, 0x91000000, 0x8E000000, 0x8E000000, 0x8E000000, 
        0x8E000000, 0x8E000000, 0x8E000000, 0x8E000000, 0x8E000000, 0x90000015, 0x91000000, 0x94001515, 0x95000000, 0x98000000, 0x9C000000, 0xA1000000, 0xA7000015, 0xAB000000, 0xB1000000, 0xB7000000, 0xBD000000, 0xC4000000, 0xCC000000, 0xD3000000, 
        0xDB000000, 0xE2000000, 0xE9000000, 0xEF000000, 0xF4000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x8B224040, 0x00222248, 0x001C003D, 0x001C0035, 0x001C003B, 0x00222B99, 0x001C7EC8, 0x00222B99, 0x002B387A, 0x00272E90, 0x00222B99, 0x00222B99, 0x00222E8D, 0x00787283, 
        0x002287AD, 0x0032EBFF, 0x007AF0F5, 0x007AF0F5, 0x007AF0F5, 0x0378C6BE, 0x00C6BEC2, 0x00948490, 0x006D627D, 0x00383B5F, 0x002E3255, 0x002E3255, 0x00383B5F, 0x004A4062, 0x00575970, 0x004A4062, 0x0027154C, 0x1515153D, 0x3422384A, 0xC8000000, 
        0xC1000000, 0xBB000000, 0xB5000000, 0xAF000015, 0xA7000015, 0xA4000000, 0x9E000015, 0x98000000, 0x95000000, 0x91000000, 0x8E000000, 0x8B000000, 0x88000000, 0x85000000, 0x83000000, 0x80000000, 0x80000000, 0x7D000000, 0x7D000000, 0x7D000000, 
        0x7D000000, 0x7D000000, 0x7D000000, 0x7D000000, 0x7D000000, 0x7D000000, 0x80000000, 0x83000000, 0x83000000, 0x88000000, 0x8B000000, 0x8E000000, 0x94001515, 0x98000000, 0x9E000015, 0xA4000015, 0xAB000015, 0xB3000015, 0xBB000000, 0xC4000000, 
        0xCD000000, 0xD8000000, 0xDF000000, 0xE7000000, 0xEE000000, 0xF4000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x0027154C, 0x001C003D, 0x00150038, 0x00150035, 0x0027154C, 0x001C7EC8, 0x001C7EC8, 0x001C0066, 0x00575970, 0x006D627D, 0x00222B99, 0x001C7EC8, 0x00222B99, 0x001C0066, 
        0x003D5783, 0x002BC5F0, 0x007AF0F5, 0x007AF0F5, 0x007AF0F5, 0x0046BED8, 0x00787283, 0x00485263, 0x004A4062, 0x0027154C, 0x0027154C, 0x0027154C, 0x0027154C, 0x0027154C, 0x1515153D, 0x37001535, 0xCB000000, 0xC4000000, 0xBB000000, 0xB5000000, 
        0xAE000000, 0xA7000015, 0xA2000015, 0x9A000015, 0x95000000, 0x90000015, 0x8B000000, 0x88000000, 0x83000000, 0x80000000, 0x7D000000, 0x7A000015, 0x79000000, 0x75000000, 0x73000000, 0x73000000, 0x70000000, 0x70000000, 0x70000000, 0x70000000, 
        0x70000000, 0x70000000, 0x70000000, 0x70000000, 0x70000000, 0x70000000, 0x73000000, 0x74000015, 0x79000000, 0x79000000, 0x7D000000, 0x80000000, 0x83000000, 0x88000015, 0x8E000000, 0x94001515, 0x9A000015, 0xA2000015, 0xAB000015, 0xB5000000, 
        0xC0000000, 0xCB000000, 0xD3000000, 0xDE000000, 0xE7000000, 0xEF000000, 0xF5000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x3422384A, 0x00220042, 0x001C0035, 0x00150035, 0x0015002E, 0x001C0066, 0x001C7EC8, 0x00222B99, 0x001C005A, 0x00575970, 0x006D627D, 0x00222E8D, 0x001C7EC8, 0x00222B99, 0x001C005A, 
        0x00383B5F, 0x0046BED8, 0x001CD2FC, 0x002BC5F0, 0x001CCCFA, 0x002BC5F0, 0x0040818E, 0x00383B5F, 0x002B0048, 0x002B0048, 0x002B0048, 0x001C0046, 0x1515153D, 0x74000015, 0xCB000000, 0xC3000000, 0xB9000000, 0xB1000000, 0xA7000015, 0xA2000015, 
        0x9A000015, 0x94001515, 0x8E000000, 0x88000000, 0x83000000, 0x7F001515, 0x7A000015, 0x79000000, 0x74000015, 0x70000000, 0x70000000, 0x6C000000, 0x6C000000, 0x6A000000, 0x69000000, 0x67000000, 0x67000000, 0x66000000, 0x66000000, 0x66000000, 
        0x66000000, 0x67000000, 0x67000000, 0x69000000, 0x69000000, 0x69000000, 0x6C000000, 0x6C000000, 0x6E000000, 0x70000000, 0x73000000, 0x75000000, 0x7A000015, 0x7D000000, 0x81000015, 0x88000015, 0x8E000000, 0x94001515, 0x9E000015, 0xA7000015, 
        0xB1000000, 0xBD000000, 0xC9000000, 0xD5000000, 0xE0000000, 0xE9000000, 0xF1000000, 0xF6000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x1515153D, 0x001C0038, 0x0015002E, 0x0015002E, 0x00150035, 0x001C0066, 0x001C7EC8, 0x001C7EC8, 0x00222B99, 0x001C0066, 0x00223D66, 0x00222B99, 0x001C7EC8, 0x001C7EC8, 0x002B387A, 
        0x002E3255, 0x0046BED8, 0x001CC1F8, 0x001CC1F8, 0x001CC1F8, 0x001CCCFA, 0x0046BED8, 0x003B7E72, 0x00575970, 0x002E3255, 0x002B0048, 0x1515153D, 0x74000015, 0xC0000000, 0xB9000000, 0xAF000015, 0xA7000015, 0x9E000015, 0x95000015, 0x8E000000, 
        0x1B2B3B55, 0x1B2B3B55, 0x1B2B3B55, 0x1B2B3B55, 0x1B2B3B55, 0x1B2B3B55, 0x1B2B3B55, 0x19222250, 0x19222250, 0x1B2B3B55, 0x1B2B3B55, 0x00575970, 0x00575970, 0x62000000, 0x62000000, 0x62000000, 0x62000000, 0x62000000, 0x62000000, 0x62000000, 
        0x63000000, 0x63000000, 0x65000000, 0x65000000, 0x66000000, 0x67000000, 0x69000000, 0x6A000000, 0x6C000000, 0x6E000000, 0x70000000, 0x73000000, 0x75000000, 0x79000000, 0x7D000000, 0x81000015, 0x85000000, 0x8B001515, 0x94001515, 0x9E000015, 
        0xA7000015, 0xB3000015, 0xC0000000, 0xCD000000, 0xD9000000, 0xE4000000, 0xED000000, 0xF4000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x19222250, 0x00220040, 0x001C0035, 0x00150035, 0x0015002E, 0x00150035, 0x001C0066, 0x001C84E6, 0x001C84E6, 0x001C7EC8, 0x001C7EC8, 0x001C7EC8, 0x001C7EC8, 0x001C7EC8, 0x001C7EC8, 0x002B387A, 
        0x0027154C, 0x001C7EC8, 0x001CC1F8, 0x001CC1F8, 0x001CD2FC, 0x0040EDFC, 0x007AF0F5, 0x0378C6BE, 0x00575970, 0x002E3255, 0x1515153D, 0xBD000000, 0xB5000000, 0xAE000000, 0x292E675C, 0x003D5783, 0x00222E8D, 0x00272E90, 0x00272E90, 0x00222B99, 
        0x00222B99, 0x00222B99, 0x00272E90, 0x00272E90, 0x00222E8D, 0x00222E8D, 0x00222E8D, 0x002B387A, 0x002B387A, 0x002B387A, 0x002B387A, 0x002B387A, 0x002B387A, 0x003D5783, 0x003D5783, 0x003D5783, 0x003D5783, 0x1B2B3B55, 0x1B2B3B55, 0x1B2B3B55, 
        0x65000000, 0x65000000, 0x66000000, 0x67000000, 0x69000000, 0x6A000000, 0x6C000000, 0x6C000000, 0x70000000, 0x70000000, 0x73000000, 0x75000000, 0x79000000, 0x7A000015, 0x7D000000, 0x81000015, 0x85000000, 0x8B001515, 0x90000015, 0x98000000, 
        0xA2000015, 0xAB000015, 0xBB000000, 0xC8000000, 0xD3000000, 0xE0000000, 0xEA000000, 0xF1000000, 0xF7000000, 0xFB000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x00220042, 0x001C003D, 0x0015002E, 0x0015002E, 0x0015002E, 0x00150035, 0x002B387A, 0x001C84E6, 0x001C84E6, 0x001C84E6, 0x001C84E6, 0x001C84E6, 0x001C84E6, 0x001C84E6, 0x001C84E6, 0x00272E90, 
        0x001C0046, 0x001C7EC8, 0x001CE0FB, 0x0040EDFC, 0x007AF0F5, 0x0378C6BE, 0x003D5783, 0x00223D66, 0x002B387A, 0x002276A3, 0x002276A3, 0x001C7EC8, 0x002276A3, 0x00222B99, 0x00222E8D, 0x002B387A, 0x001C0066, 0x00383B5F, 0x00383B5F, 0x00485263, 
        0x00575970, 0x00575970, 0x00485263, 0x004A4062, 0x00485263, 0x004A4062, 0x004A4062, 0x002E3255, 0x0027154C, 0x0027154C, 0x0027154C, 0x002E3255, 0x002B0048, 0x002B0048, 0x002B0048, 0x002B0048, 0x0027154C, 0x001C005A, 0x002B387A, 0x003D5783, 
        0x003D5783, 0x003D5783, 0x1B2B3B55, 0x2D447278, 0x292E675C, 0x73000000, 0x74000015, 0x75000000, 0x79000000, 0x7A000015, 0x7D000000, 0x80000000, 0x81000015, 0x83000000, 0x85000000, 0x88000000, 0x8B001515, 0x90000015, 0x94001515, 0x9A000015, 
        0xA2000015, 0xAB000015, 0xB9000000, 0xC4000000, 0xD0000000, 0xDD000000, 0xE8000000, 0xF0000000, 0xF6000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x00220042, 0x001C0038, 0x00150035, 0x0015002E, 0x0015002E, 0x001C0046, 0x00222B99, 0x001C84E6, 0x001C84E6, 0x001CADF5, 0x001C84E6, 0x001C84E6, 0x001CADF5, 0x001C84E6, 0x001C84E6, 0x001C7EC8, 
        0x02221C46, 0x00222B99, 0x007AF0F5, 0x0378C6BE, 0x0040818E, 0x00223D66, 0x00223D66, 0x001C005A, 0x00223D66, 0x00383B5F, 0x00575970, 0x006D627D, 0x006D627D, 0x006D627D, 0x006D627D, 0x006D627D, 0x00575970, 0x00575970, 0x004A4062, 0x002E3255, 
        0x002B0048, 0x00220042, 0x00220040, 0x001C003B, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C0035, 0x001C0035, 0x001C0035, 0x001C0035, 0x0015002E, 0x001C0035, 0x001C0035, 0x001C0035, 0x0015002E, 0x001C0035, 0x001C0035, 0x001C0038, 0x001C0035, 
        0x001C003D, 0x0027154C, 0x002E3255, 0x00223D66, 0x002B387A, 0x00226D89, 0x00575970, 0x59224244, 0x85000000, 0x88000000, 0x8B000000, 0x8E000000, 0x90000015, 0x91000000, 0x95000000, 0x95000000, 0x98000000, 0x9A000015, 0x9E000015, 0xA2000015, 
        0xAB000015, 0xB3000015, 0xBB000000, 0xC8000000, 0xD3000000, 0xDE000000, 0xE8000000, 0xF0000000, 0xF6000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x90000015, 0x001C003D, 0x001C0038, 0x001C0038, 0x001C0035, 0x00220040, 0x002276A3, 0x001C84E6, 0x001CADF5, 0x001CC1F8, 0x001CD2FC, 0x001CCBFB, 0x001CCCFA, 0x001CD2FC, 0x001CC1F8, 0x001CC1F8, 0x001CADF5, 
        0x00226D89, 0x001C005A, 0x00223D66, 0x00383B5F, 0x002B545D, 0x00787283, 0x00948490, 0x00948490, 0x00787283, 0x006D627D, 0x004A4062, 0x0027003D, 0x0022003D, 0x001C0038, 0x001C0038, 0x001C0038, 0x001C003B, 0x001C0038, 0x001C0035, 0x001C0035, 
        0x001C0035, 0x001C0038, 0x001C0038, 0x00220035, 0x00220035, 0x00220035, 0x001C0038, 0x00220035, 0x0015002E, 0x0015002E, 0x0015002E, 0x0015002E, 0x001C0035, 0x001C0035, 0x0015002E, 0x0015002E, 0x0015002E, 0x0015002E, 0x0015002E, 0x0015002E, 
        0x0015002E, 0x0015002E, 0x001C0035, 0x0015002E, 0x001C0038, 0x001C003B, 0x00383B5F, 0x00485263, 0x00575970, 0x59224244, 0x9E000015, 0xA1000000, 0xA4000000, 0xA4000000, 0xA7000000, 0xA7000000, 0xAB000000, 0xAB000000, 0xAE000000, 0xB1000000, 
        0xB5000000, 0xBB000000, 0xC4000000, 0xCD000000, 0xD8000000, 0xE0000000, 0xE9000000, 0xF1000000, 0xF6000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x37001535, 0x00220042, 0x001C0038, 0x001C0038, 0x00150035, 0x002B387A, 0x001C84E6, 0x001CADF5, 0x001CADF5, 0x001CCBFB, 0x001CCCFA, 0x001CD2FC, 0x001CE0FB, 0x0022E4FC, 0x001CE0FC, 0x001CD2FC, 0x001CCCFA, 
        0x002287AD, 0x00787283, 0x0378C6BE, 0x00C6BEC2, 0x007AF0F5, 0x007AF0F5, 0x0046BED8, 0x003D5783, 0x00222248, 0x001C003B, 0x001C0038, 0x001C0038, 0x001C0038, 0x00220035, 0x001C0038, 0x001C0038, 0x001C0038, 0x001C0038, 0x001C0038, 0x001C0035, 
        0x001C0038, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C0035, 0x00150035, 0x00150035, 0x001C0035, 0x001C0035, 0x002B0048, 0x001C0035, 0x001C0035, 0x00150035, 0x00150035, 0x0015002E, 0x001C0038, 0x00150035, 
        0x00150035, 0x00150035, 0x001C003B, 0x001C003B, 0x001C003B, 0x001C0035, 0x001C0038, 0x001C0035, 0x001C0046, 0x00383B5F, 0x3422384A, 0xB5000000, 0xB7000000, 0xB9000000, 0xBB000000, 0xBB000000, 0xBB000000, 0xBD000000, 0xBD000000, 0xC1000000, 
        0xC4000000, 0xC9000000, 0xCE000000, 0xD6000000, 0xDD000000, 0xE5000000, 0xED000000, 0xF3000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x00220042, 0x001C003D, 0x00220040, 0x001C0035, 0x001C0066, 0x001C7EC8, 0x001C84E6, 0x001CADF5, 0x001CC1F8, 0x001CE0FC, 0x0032EBFF, 0x0032E6FA, 0x0032EBFF, 0x0022E6FE, 0x0032E6FA, 0x0032E6FA, 0x001CE0FB, 
        0x002287AD, 0x004A4062, 0x001C7EC8, 0x007AF0F5, 0x007AF0F5, 0x001CADF5, 0x001CADF5, 0x001C7EC8, 0x00226D89, 0x001C003B, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C0038, 0x001C0038, 0x001C0038, 
        0x001C0038, 0x001C0038, 0x001C0038, 0x001C0038, 0x001C003B, 0x001C003B, 0x001C003B, 0x001C003D, 0x001C003D, 0x001C003D, 0x00220040, 0x00220042, 0x002B0048, 0x00220042, 0x002B0048, 0x00222248, 0x0027154C, 0x0027154C, 0x0027154C, 0x002E3255, 
        0x00383B5F, 0x00383B5F, 0x00274057, 0x00383B5F, 0x00383B5F, 0x002E3255, 0x002E3255, 0x01273250, 0x00222248, 0x00220040, 0x00222248, 0x19222250, 0xC9000000, 0xCB000000, 0xCC000000, 0xCD000000, 0xCE000000, 0xCE000000, 0xD0000000, 0xD0000000, 
        0xD3000000, 0xD6000000, 0xDA000000, 0xDF000000, 0xE5000000, 0xEB000000, 0xF0000000, 0xF5000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x00220042, 0x001C003B, 0x001C0035, 0x00150038, 0x00222B99, 0x001C84E6, 0x001CADF5, 0x001CCBFB, 0x001CE0FC, 0x0032EBFF, 0x0022E4FC, 0x0040EDFC, 0x0040EDFC, 0x0022E9FF, 0x0040EDFC, 0x0022E4FC, 0x001CE0FB, 
        0x002EC3B9, 0x00220042, 0x00222B99, 0x001CD2FC, 0x001CCCFA, 0x001CADF5, 0x001C84E6, 0x001C84E6, 0x001C7EC8, 0x00274057, 0x0022003D, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C0038, 0x001C0035, 0x001C0038, 0x001C0038, 0x0027003D, 0x001C0038, 
        0x0022003D, 0x001C003B, 0x00220040, 0x0022003D, 0x00220040, 0x00220042, 0x001C0046, 0x0027154C, 0x00383B5F, 0x004A4062, 0x004A4062, 0x00485263, 0x292E675C, 0x1B2B3B55, 0x1B2B3B55, 0x1B2B3B55, 0x3422384A, 0x1B2B3B55, 0x1B2B3B55, 0xAE000000, 
        0xB1000000, 0xB6000000, 0xBB000000, 0xBD000000, 0xC1000000, 0xC4000000, 0xC8000000, 0xCB000000, 0xCD000000, 0x74000015, 0x3422384A, 0x00274057, 0x3422384A, 0xD9000000, 0xDB000000, 0xDC000000, 0xDD000000, 0xDD000000, 0xDE000000, 0xDF000000, 
        0xE2000000, 0xE3000000, 0xE5000000, 0xE9000000, 0xED000000, 0xF1000000, 0xF5000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x0022003D, 0x001C0038, 0x001C0038, 0x00222E8D, 0x001C84E6, 0x001CADF5, 0x001CC1F8, 0x001CD2FC, 0x0022E1FE, 0x0032EBFF, 0x0032EBFF, 0x0040EDFC, 0x0040EDFC, 0x0032EBFF, 0x0022E6FE, 0x001CE0FB, 0x0022E4FC, 
        0x0046BED8, 0x001C0046, 0x001C005A, 0x001C84E6, 0x002BC5F0, 0x002BC5F0, 0x001CADF5, 0x001CADF5, 0x001C84E6, 0x00225A6F, 0x001C003D, 0x001C003D, 0x001C0038, 0x001C0035, 0x001C0038, 0x001C003B, 0x001C003B, 0x001C003B, 0x001C003B, 0x00220042, 
        0x00220040, 0x0027154C, 0x002E3255, 0x004A4062, 0x00575970, 0x1B2B3B55, 0x1B2B3B55, 0x1B2B3B55, 0x3422384A, 0x81000015, 0x88000000, 0x8E000000, 0x91000000, 0x98000000, 0x9E000015, 0xA2000015, 0xAB000000, 0xAE000000, 0xB3000015, 0xB9000000, 
        0xBB000000, 0xC0000000, 0xC4000000, 0xC8000000, 0xCB000000, 0xCE000000, 0xD0000000, 0xD3000000, 0xD6000000, 0xD9000000, 0xDC000000, 0xDE000000, 0xE2000000, 0xE3000000, 0xE4000000, 0xE6000000, 0xE7000000, 0xE8000000, 0xE9000000, 0xE9000000, 
        0xEB000000, 0xEC000000, 0xEE000000, 0xF0000000, 0xF3000000, 0xF6000000, 0xF8000000, 0xFA000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x37001535, 0x001C0035, 0x001C0035, 0x001C003B, 0x00222E8D, 0x001C84E6, 0x001CADF5, 0x001CD2FC, 0x001CE0FC, 0x0022E9FF, 0x0032EBFF, 0x0022E9FF, 0x0032EBFF, 0x0022E4FC, 0x0032E6FA, 0x0032E6FA, 0x001CE0FB, 0x001CD2FC, 
        0x002BC5F0, 0x00225565, 0x00220040, 0x00222E8D, 0x001CADF5, 0x001CC1F8, 0x001CADF5, 0x001CADF5, 0x001CADF5, 0x00225A6F, 0x00220040, 0x001C0038, 0x0022003D, 0x0022003D, 0x00220042, 0x00220042, 0x002B0048, 0x002B0048, 0x002E3255, 0x002E3255, 
        0x19222250, 0x1B2B3B55, 0x3422384A, 0x66000000, 0x6C000000, 0x70000015, 0x79000000, 0x7F001515, 0x83000000, 0x8B000000, 0x90000015, 0x95000015, 0x9A000015, 0xA1000000, 0xA4000015, 0xAB000015, 0xAF000015, 0xB3000015, 0xB9000000, 0xBB000000, 
        0xC0000000, 0xC3000000, 0xC6000000, 0xC9000000, 0xCC000000, 0xD0000000, 0xD3000000, 0xD5000000, 0xD8000000, 0xDB000000, 0xDE000000, 0xE2000000, 0xE3000000, 0xE5000000, 0xE8000000, 0xE9000000, 0xEB000000, 0xED000000, 0xEE000000, 0xEF000000, 
        0xF1000000, 0xF2000000, 0xF4000000, 0xF5000000, 0xF7000000, 0xF9000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x37001535, 0x001C003B, 0x001C0035, 0x00222E8D, 0x001C84E6, 0x001CADF5, 0x001CCCFA, 0x0022E1FE, 0x0022E6FE, 0x0032EBFF, 0x0032EBFF, 0x0032EBFF, 0x0022E6FE, 0x0022E4FC, 0x0022E1FE, 0x0022E4FC, 0x001CE0FB, 0x001CD2FC, 
        0x001CCCFA, 0x0046BED8, 0x003D5783, 0x0027154C, 0x001C005A, 0x002276A3, 0x0046BED8, 0x001CADF5, 0x002BC5F0, 0x0046BED8, 0x0040818E, 0x00225565, 0x00383B5F, 0x00383B5F, 0x002E3255, 0x002E3255, 0x19222250, 0x37001535, 0x59000000, 0x5A000000, 
        0x5D000000, 0x60000000, 0x65000000, 0x6A000000, 0x70000015, 0x79000000, 0x7D000000, 0x83000000, 0x8B000000, 0x90000015, 0x95000015, 0x9A000015, 0x9E000015, 0xA2000015, 0xA7000015, 0xAB000015, 0xAF000015, 0xB3000015, 0xB5000000, 0xB9000000, 
        0xBB000000, 0xBD000000, 0xC1000000, 0xC4000000, 0xC8000000, 0xCB000000, 0xCD000000, 0xD0000000, 0xD3000000, 0xD6000000, 0xD9000000, 0xDC000000, 0xDF000000, 0xE2000000, 0xE4000000, 0xE7000000, 0xE9000000, 0xEC000000, 0xEE000000, 0xF0000000, 
        0xF2000000, 0xF4000000, 0xF6000000, 0xF8000000, 0xFA000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x1515153D, 0x00220042, 0x0027154C, 0x001C7EC8, 0x001CADF5, 0x001CCBFB, 0x0022E6FE, 0x0022E9FF, 0x0032EBFF, 0x0040EDFC, 0x0032EBFF, 0x0032EBFF, 0x0022E6FE, 0x0022E4FC, 0x001CE0FC, 0x001CE0FC, 0x001CD2FC, 0x001CD2FC, 
        0x001CC1F8, 0x001CC1F8, 0x001CADF5, 0x001C7EC8, 0x002276A3, 0x002B387A, 0x001C0066, 0x002E3255, 0x00223D5A, 0x19222250, 0x1B2B3B55, 0x1B2B3B55, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5B000000, 
        0x5F000000, 0x62000000, 0x66000000, 0x6C000000, 0x74000015, 0x7A000015, 0x80000000, 0x88000000, 0x8B001515, 0x90000015, 0x95000015, 0x9A000015, 0x9E000015, 0xA1000000, 0xA2000015, 0xA4000015, 0xA7000015, 0xAB000015, 0xAB000015, 0xAF000015, 
        0xB1000000, 0xB3000015, 0xB6000000, 0xB9000000, 0xBB000000, 0xBD000000, 0xC1000000, 0xC4000000, 0xC8000000, 0xCB000000, 0xCE000000, 0xD0000000, 0xD5000000, 0xD8000000, 0xDC000000, 0xDF000000, 0xE3000000, 0xE6000000, 0xE9000000, 0xEC000000, 
        0xEF000000, 0xF2000000, 0xF5000000, 0xF8000000, 0xFA000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x00220042, 0x001C003B, 0x002B387A, 0x001C84E6, 0x001CADF5, 0x001CE0FC, 0x0022E6FE, 0x0032EBFF, 0x0040EDFC, 0x0032EBFF, 0x0040EDFC, 0x0040EDFC, 0x0022E4FC, 0x0022E1FE, 0x0022E4FC, 0x001CD2FC, 0x001CD2FC, 0x001CCCFA, 
        0x001CC1F8, 0x001CC1F8, 0x001CADF5, 0x001CADF5, 0x001C84E6, 0x00226D89, 0x00223D66, 0x19222250, 0x37001535, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x5A000000, 0x5B000000, 
        0x5F000000, 0x62000000, 0x67000000, 0x6C000000, 0x74000015, 0x7A000015, 0x80000000, 0x85000000, 0x8B000000, 0x8E000000, 0x90000015, 0x94001515, 0x95000015, 0x98000000, 0x9A000015, 0x9A000015, 0x9C000000, 0x9E000015, 0x9E000015, 0xA2000015, 
        0xA2000015, 0xA4000015, 0xA7000015, 0xA7000015, 0xAB000015, 0xAF000015, 0xB1000000, 0xB5000000, 0xB9000000, 0xBB000000, 0xC0000000, 0xC3000000, 0xC8000000, 0xCB000000, 0xCE000000, 0xD3000000, 0xD8000000, 0xDC000000, 0xE2000000, 0xE5000000, 
        0xEA000000, 0xEE000000, 0xF2000000, 0xF5000000, 0xF8000000, 0xFA000000, 0xFC000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x001C0038, 0x001C0046, 0x001C7EC8, 0x001CADF5, 0x001CD2FC, 0x0022E9FF, 0x0022E6FE, 0x0032EBFF, 0x0032EBFF, 0x0022E9FF, 0x0032EBFF, 0x0032EBFF, 0x0022E4FC, 0x001CE0FC, 0x001CD2FC, 0x001CCCFA, 0x001CCBFB, 0x001CC1F8, 
        0x001CADF5, 0x001CADF5, 0x001C84E6, 0x001C7EC8, 0x002276A3, 0x01273250, 0x37001535, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x5A000000, 0x5B000000, 
        0x5F000000, 0x62000000, 0x67000000, 0x6C000000, 0x73000000, 0x79000000, 0x7D000000, 0x81000015, 0x83000000, 0x88000000, 0x88000000, 0x8B001515, 0x8B001515, 0x8B001515, 0x8B001515, 0x8E000000, 0x8E000000, 0x90000015, 0x90000015, 0x90000015, 
        0x94001515, 0x94001515, 0x95000015, 0x9A000015, 0x9A000015, 0x9E000015, 0xA2000015, 0xA4000015, 0xA7000015, 0xAB000000, 0xAF000015, 0xB3000015, 0xB7000000, 0xBB000000, 0xC0000000, 0xC4000000, 0xCB000000, 0xD0000000, 0xD5000000, 0xDB000000, 
        0xE2000000, 0xE7000000, 0xEC000000, 0xF1000000, 0xF5000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x8B224040, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x001C0035, 0x001C0066, 0x001C84E6, 0x001CC1F8, 0x001CE0FC, 0x0032EBFF, 0x0022E9FF, 0x0040EDFC, 0x0032EBFF, 0x0032EBFF, 0x0032EBFF, 0x0040EDFC, 0x0022E4FC, 0x001CE0FB, 0x001CC1F8, 0x001CC1F8, 0x001CC1F8, 0x001CADF5, 
        0x001C84E6, 0x001C84E6, 0x001C7EC8, 0x00222B99, 0x00223D5A, 0x37001535, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5B000000, 
        0x5D000000, 0x62000000, 0x65000000, 0x69000000, 0x6E000000, 0x74000015, 0x79000000, 0x7A000015, 0x7D000000, 0x7F001515, 0x7F001515, 0x80000000, 0x81000015, 0x81000015, 0x81000015, 0x81000015, 0x81000015, 0x81000015, 0x83000000, 0x83000000, 
        0x85000000, 0x88000015, 0x88000015, 0x8B001515, 0x8E000000, 0x90000015, 0x91000000, 0x95000015, 0x9A000015, 0x9C000000, 0xA1000000, 0xA4000015, 0xA7000015, 0xAE000000, 0xB3000015, 0xB7000000, 0xBD000000, 0xC3000000, 0xC9000000, 0xD0000000, 
        0xD8000000, 0xDE000000, 0xE5000000, 0xEB000000, 0xF1000000, 0xF5000000, 0xF9000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0x004C9987, 0x0035C397, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0x37001535, 0x001C0046, 0x001C7EC8, 0x001CADF5, 0x001CC1F8, 0x0022E4FC, 0x0022E1FE, 0x0032EBFF, 0x0040EDFC, 0x0032EBFF, 0x0032EBFF, 0x0040EDFC, 0x0040EDFC, 0x001CD2FC, 0x001CD2FC, 0x001CCBFB, 0x001CC1F8, 0x001CADF5, 0x001CADF5, 
        0x001C84E6, 0x001C7EC8, 0x001C7EC8, 0x00222B99, 0x00223D5A, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5B000000, 
        0x5D000000, 0x5F000000, 0x63000000, 0x66000000, 0x6A000000, 0x6E000000, 0x70000000, 0x73000000, 0x74000015, 0x75000000, 0x75000000, 0x75000000, 0x75000000, 0x79000000, 0x79000000, 0x79000000, 0x79000000, 0x7A000015, 0x7A000015, 0x7A000015, 
        0x7D000000, 0x7F001515, 0x81000015, 0x81000015, 0x83000000, 0x85000000, 0x88000015, 0x8B001515, 0x90000015, 0x91000000, 0x95000015, 0x9A000015, 0x9E000015, 0xA2000015, 0xA7000015, 0xAE000000, 0xB3000015, 0xB9000000, 0xC0000000, 0xC6000000, 
        0xCE000000, 0xD5000000, 0xDD000000, 0xE5000000, 0xEC000000, 0xF2000000, 0xF6000000, 0xFA000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0x00427B7F, 0x002EC3AC, 0x0E4C9C84, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0x1515153D, 0x002B387A, 0x001C84E6, 0x001CADF5, 0x001CD2FC, 0x0022E6FE, 0x0032EBFF, 0x0022E6FE, 0x0022E9FF, 0x0040EDFC, 0x0040EDFC, 0x0032EBFF, 0x0022E9FF, 0x0022E4FC, 0x001CE0FC, 0x001CD2FC, 0x001CCBFB, 0x001CCBFB, 0x001CADF5, 
        0x001C84E6, 0x001C84E6, 0x001C7EC8, 0x002276A3, 0x01273250, 0x58000000, 0x58000000, 0x58000000, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 
        0x5C000000, 0x5F000000, 0x62000000, 0x65000000, 0x67000000, 0x69000000, 0x6C000000, 0x6C000000, 0x6E000000, 0x70000000, 0x70000000, 0x70000000, 0x70000015, 0x73000000, 0x73000000, 0x74000015, 0x74000015, 0x75000000, 0x79000000, 0x79000000, 
        0x7A000015, 0x7D000000, 0x7F001515, 0x81000015, 0x81000015, 0x83000000, 0x88000015, 0x88000015, 0x8B001515, 0x90000015, 0x94001515, 0x95000015, 0x9A000015, 0x9E000015, 0xA2000015, 0xA7000015, 0xAE000000, 0xB3000015, 0xB9000000, 0xC0000000, 
        0xC8000000, 0xCE000000, 0xD8000000, 0xE0000000, 0xE8000000, 0xEF000000, 0xF4000000, 0xF9000000, 0xFC000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0x292E675C, 0x0027B498, 0x002EE4BA, 0x2D447278, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x90000015, 0x00220042, 0x001C7EC8, 0x001CADF5, 0x001CCBFB, 0x0022E1FE, 0x0032EBFF, 0x0022E9FF, 0x0032EBFF, 0x0032EBFF, 0x0040EDFC, 0x0032EBFF, 0x0032EBFF, 0x0032EBFF, 0x0032EBFF, 0x001CE0FC, 0x0022E4FC, 0x001CE0FC, 0x001CCBFB, 0x001CADF5, 
        0x001CADF5, 0x001C84E6, 0x001C84E6, 0x002276A3, 0x0027154C, 0x02221C46, 0x1515153D, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 
        0x5D000000, 0x5F000000, 0x62000000, 0x63000000, 0x65000000, 0x69000000, 0x69000000, 0x6C000000, 0x6C000000, 0x6C000000, 0x70000000, 0x70000000, 0x70000015, 0x73000000, 0x74000015, 0x74000015, 0x79000000, 0x7A000015, 0x7A000015, 0x7D000000, 
        0x7F001515, 0x81000015, 0x83000000, 0x85000000, 0x88000015, 0x8B001515, 0x8B001515, 0x8E000000, 0x90000015, 0x94001515, 0x98000000, 0x9A000015, 0x9E000015, 0xA2000015, 0xA7000015, 0xAB000015, 0xAF000015, 0xB3000015, 0xB9000000, 0xBD000000, 
        0xC4000000, 0xCC000000, 0xD5000000, 0xDD000000, 0xE5000000, 0xEC000000, 0xF3000000, 0xF7000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x8B224040, 0x0027B498, 0x002EC3AC, 0x0146C3A8, 0x292E675C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x1515153D, 0x002B387A, 0x001CADF5, 0x001CCBFB, 0x001CCBFB, 0x0022E4FC, 0x0022E6FE, 0x0022E9FF, 0x0032EBFF, 0x0032EBFF, 0x0040EDFC, 0x0040EDFC, 0x0032EBFF, 0x0032EBFF, 0x0040EDFC, 0x0022E4FC, 0x001CE0FB, 0x001CD2FC, 0x001CCBFB, 0x001CC1F8, 
        0x001CADF5, 0x001CADF5, 0x001C84E6, 0x001C7EC8, 0x00223D66, 0x00220042, 0x0027154C, 0x02221C46, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5D000000, 
        0x5F000000, 0x62000000, 0x63000000, 0x65000000, 0x67000000, 0x6A000000, 0x6C000000, 0x6C000000, 0x70000000, 0x70000000, 0x73000000, 0x75000000, 0x79000000, 0x7A000015, 0x7A000015, 0x7D000000, 0x81000015, 0x81000015, 0x85000000, 0x88000015, 
        0x8B001515, 0x8E000000, 0x90000015, 0x91000000, 0x94001515, 0x95000015, 0x98000000, 0x9A000015, 0x9C000000, 0x9E000015, 0xA2000015, 0xA4000015, 0xA7000015, 0xAB000000, 0xAF000015, 0xB1000000, 0xB5000000, 0xB9000000, 0xBD000000, 0xC3000000, 
        0xC8000000, 0xCE000000, 0xD5000000, 0xDD000000, 0xE5000000, 0xEC000000, 0xF2000000, 0xF7000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x00449582, 0x0035C397, 0x002EC3B9, 0x004CAE84, 0x2D447278, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x001C003B, 0x001C7EC8, 0x001CC1F8, 0x001CCBFB, 0x001CD2FC, 0x0022E1FE, 0x0022E4FC, 0x0022E1FE, 0x0032EBFF, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0032EBFF, 0x0040EDFC, 0x0022E6FE, 0x001CE0FC, 0x001CE0FC, 0x001CCBFB, 0x001CC1F8, 
        0x001CADF5, 0x001CADF5, 0x001CADF5, 0x001C84E6, 0x002B387A, 0x00220042, 0x00220042, 0x002B0048, 0x02221C46, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5C000000, 0x5F000000, 0x62000000, 
        0x63000000, 0x66000000, 0x69000000, 0x6C000000, 0x6E000000, 0x70000000, 0x73000000, 0x75000000, 0x79000000, 0x7A000015, 0x7D000000, 0x80000000, 0x83000000, 0x85000000, 0x88000000, 0x8B000000, 0x8E000000, 0x91000000, 0x95000015, 0x98000000, 
        0x9A000015, 0x9E000015, 0xA1000000, 0xA2000015, 0xA4000015, 0xA7000015, 0xA7000015, 0xAB000000, 0xAE000000, 0xAF000015, 0xB1000000, 0xB5000000, 0xB7000000, 0xBB000000, 0xBB000000, 0xC0000000, 0xC1000000, 0xC4000000, 0xC6000000, 0xCB000000, 
        0xCE000000, 0xD3000000, 0xD9000000, 0xE0000000, 0xE6000000, 0xED000000, 0xF3000000, 0xF7000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x2D447278, 
        0x002EE1AD, 0x0035C397, 0x002EE4C8, 0x004CAE84, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0x0027154C, 0x001C84E6, 0x001CC1F8, 0x001CCCFA, 0x001CCCFA, 0x0022E1FE, 0x001CE0FC, 0x0032EBFF, 0x0032EBFF, 0x0032EBFF, 0x0040EDFC, 0x0032EBFF, 0x0040EDFC, 0x0032EBFF, 0x0032EBFF, 0x0032EBFF, 0x0022E4FC, 0x001CD2FC, 0x001CE0FC, 0x001CD2FC, 
        0x001CC1F8, 0x001CC1F8, 0x001CADF5, 0x001C84E6, 0x002276A3, 0x00220042, 0x00220040, 0x001C0046, 0x0027154C, 0x01273250, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5F000000, 0x60000000, 0x63000000, 0x67000000, 
        0x6A000000, 0x6E000000, 0x73000000, 0x75000000, 0x79000000, 0x7A000015, 0x7D000000, 0x81000015, 0x83000000, 0x88000000, 0x8B000000, 0x8E000000, 0x91000000, 0x95000000, 0x9A000015, 0x9E000015, 0xA2000015, 0xA4000015, 0xA7000015, 0xAB000000, 
        0xAE000000, 0xB1000000, 0xB3000015, 0xB6000000, 0xB9000000, 0xBB000000, 0xBB000000, 0xBD000000, 0xC0000000, 0xC1000000, 0xC3000000, 0xC6000000, 0xC8000000, 0xCB000000, 0xCC000000, 0xCE000000, 0xCE000000, 0xD0000000, 0xD3000000, 0xD5000000, 
        0xD8000000, 0xDB000000, 0xDF000000, 0xE4000000, 0xEA000000, 0xEF000000, 0xF4000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0035A48F, 0x0022786F, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x292E675C, 0x0027B498, 
        0x0046D69A, 0x002EC3B9, 0x002EE4C8, 0x0022A474, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 
        0x00222B99, 0x001CADF5, 0x001CD2FC, 0x001CE0FC, 0x0022E1FE, 0x0022E1FE, 0x0032EBFF, 0x001CE0FC, 0x0032EBFF, 0x0022E1FE, 0x0040EDFC, 0x0040EDFC, 0x0032EBFF, 0x0032EBFF, 0x0022E6FE, 0x0032EBFF, 0x0022E6FE, 0x0022E6FE, 0x0032E6FA, 0x001CE0FC, 
        0x001CC1F8, 0x001CC1F8, 0x001CC1F8, 0x001CADF5, 0x001C7EC8, 0x002E3255, 0x00220040, 0x0022003D, 0x0027003D, 0x002B0048, 0x002E3255, 0x58000000, 0x59000000, 0x5A000000, 0x5C000000, 0x5F000000, 0x62000000, 0x66000000, 0x6A000000, 0x70000000, 
        0x75000000, 0x7A000015, 0x80000000, 0x83000000, 0x88000000, 0x8B000000, 0x8E000000, 0x91000000, 0x95000000, 0x9A000015, 0x9C000000, 0xA1000000, 0xA7000000, 0xAB000000, 0xAE000000, 0xB1000000, 0xB5000000, 0xB9000000, 0xBB000000, 0xC0000000, 
        0xC3000000, 0xC4000000, 0xC8000000, 0xC9000000, 0xCB000000, 0xCD000000, 0xCE000000, 0xCE000000, 0xD0000000, 0xD3000000, 0xD3000000, 0xD6000000, 0xD8000000, 0xDA000000, 0xDB000000, 0xDC000000, 0xDD000000, 0xDE000000, 0xDF000000, 0xE0000000, 
        0xE2000000, 0xE4000000, 0xE7000000, 0xEB000000, 0xEF000000, 0xF3000000, 0xF6000000, 0xFA000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EC3B9, 0x002EC3AC, 0x00229A7E, 0x00276B62, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x8B224040, 0x0035A48F, 0x002EE4BA, 
        0x0035C397, 0x002EE6D4, 0x002EE1AD, 0x292E675C, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFC000000, 0xFB000000, 0xFB000000, 0xFB000000, 0xFB000000, 0xFC000000, 0xFD000000, 
        0x001C7EC8, 0x001CCCFA, 0x001CE0FC, 0x001CC1F8, 0x001CE0FC, 0x0032EBFF, 0x0022E1FE, 0x0022E6FE, 0x0022E1FE, 0x0032EBFF, 0x0032EBFF, 0x0040EDFC, 0x0032EBFF, 0x0040EDFC, 0x0032EBFF, 0x0022E9FF, 0x0022E9FF, 0x001CE0FB, 0x001CE0FC, 0x001CE0FC, 
        0x001CCCFA, 0x001CC1F8, 0x001CADF5, 0x001CADF5, 0x001C84E6, 0x003D5783, 0x00220040, 0x00220040, 0x00220040, 0x00220042, 0x002B0048, 0x02221C46, 0x59000000, 0x5B000000, 0x5F000000, 0x62000000, 0x67000000, 0x6C000000, 0x74000015, 0x7A000015, 
        0x83000000, 0x88000000, 0x8E000000, 0x95000000, 0x98000000, 0x9E000015, 0xA2000015, 0xA7000000, 0xAB000000, 0xAE000000, 0xB1000000, 0xB6000000, 0xBB000000, 0xBD000000, 0xC3000000, 0xC4000000, 0xC9000000, 0xCC000000, 0xCE000000, 0xD3000000, 
        0xD3000000, 0xD8000000, 0xD9000000, 0xDB000000, 0xDC000000, 0xDD000000, 0xDE000000, 0xDF000000, 0xE2000000, 0xE2000000, 0xE3000000, 0xE4000000, 0xE6000000, 0xE7000000, 0xE8000000, 0xE9000000, 0xE9000000, 0xE9000000, 0xEA000000, 0xEA000000, 
        0xEB000000, 0xEC000000, 0xEE000000, 0xF1000000, 0xF3000000, 0xF6000000, 0xF9000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EC3B9, 0x002EE4C8, 0x002EE4BA, 0x002EC3AC, 0x00229A7E, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x0E4C9C84, 0x002EE4BA, 0x0046D69A, 
        0x002EC3B9, 0x0032EADC, 0x0035C397, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xFA000000, 0xF8000000, 0xF7000000, 0xF7000000, 0xF7000000, 0xF9000000, 0xFA000000, 0xFB000000, 
        0x001C7EC8, 0x0022E1FE, 0x001CC1F8, 0x001CD2FC, 0x0022E1FE, 0x0022E1FE, 0x0022E1FE, 0x0022E6FE, 0x0032EBFF, 0x0032EBFF, 0x0022E6FE, 0x0040EDFC, 0x0032EBFF, 0x0032EBFF, 0x0022E1FE, 0x0022E6FE, 0x0022E9FF, 0x001CE0FB, 0x001CD2FC, 0x001CE0FB, 
        0x001CCCFA, 0x001CC1F8, 0x001CADF5, 0x001CC1F8, 0x001CADF5, 0x002276A3, 0x001C0046, 0x0022003D, 0x00220040, 0x00220042, 0x002B0048, 0x002B0048, 0x02221C46, 0x5D000000, 0x62000000, 0x66000000, 0x6C000000, 0x75000000, 0x7D000000, 0x88000000, 
        0x91000000, 0x98000000, 0xA1000000, 0xA7000000, 0xAE000000, 0xB1000000, 0xB6000000, 0xBB000000, 0xBD000000, 0xC3000000, 0xC6000000, 0xCB000000, 0xCD000000, 0xD0000000, 0xD3000000, 0xD8000000, 0xDA000000, 0xDD000000, 0xDF000000, 0xE2000000, 
        0xE3000000, 0xE5000000, 0xE7000000, 0xE8000000, 0xE9000000, 0xEA000000, 0xEB000000, 0xEC000000, 0xED000000, 0xEE000000, 0xEE000000, 0xEF000000, 0xF0000000, 0xF1000000, 0xF2000000, 0xF2000000, 0xF2000000, 0xF2000000, 0xF2000000, 0xF3000000, 
        0xF3000000, 0xF3000000, 0xF4000000, 0xF6000000, 0xF7000000, 0xF9000000, 0xFB000000, 0xFC000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EE1AD, 0x002EE4BA, 0x002EE4C8, 0x002EE4C8, 0x002EE1AD, 0x00277D62, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x2D447278, 0x002EC3AC, 0x002EE4BA, 0x0046B497, 
        0x002EE6D4, 0x0032EADC, 0x003BBA87, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xFA000000, 0xF8000000, 0xF6000000, 0xF4000000, 0xF2000000, 0xF2000000, 0xF3000000, 0xF4000000, 0xF7000000, 0x90000015, 
        0x001C7EC8, 0x001CE0FC, 0x001CCBFB, 0x001CCCFA, 0x001CE0FC, 0x0022E1FE, 0x0022E9FF, 0x0022E1FE, 0x0022E9FF, 0x0022E4FC, 0x0022E6FE, 0x0032EBFF, 0x0022E6FE, 0x0040EDFC, 0x0022E4FC, 0x0032EBFF, 0x0022E6FE, 0x001CE0FB, 0x001CD2FC, 0x001CE0FB, 
        0x001CD2FC, 0x001CC1F8, 0x001CADF5, 0x001CC1F8, 0x001CADF5, 0x001C7EC8, 0x00224060, 0x00220040, 0x00220042, 0x0022003D, 0x0027003D, 0x00220040, 0x002B0048, 0x0027154C, 0x65000000, 0x6A000000, 0x73000000, 0x7D000000, 0x88000000, 0x95000000, 
        0xA1000000, 0xAB000000, 0xB3000015, 0xBB000000, 0xC0000000, 0xC4000000, 0xCB000000, 0xCD000000, 0xD0000000, 0xD3000000, 0xD8000000, 0xDB000000, 0xDE000000, 0xE0000000, 0xE3000000, 0xE5000000, 0xE8000000, 0xEA000000, 0xEB000000, 0xED000000, 
        0xEF000000, 0xF0000000, 0xF1000000, 0xF2000000, 0xF3000000, 0xF3000000, 0xF4000000, 0xF5000000, 0xF5000000, 0xF6000000, 0xF6000000, 0xF7000000, 0xF7000000, 0xF8000000, 0xF8000000, 0xF8000000, 0xF9000000, 0xF9000000, 0xF8000000, 0xF8000000, 
        0xF8000000, 0xF9000000, 0xF9000000, 0xFA000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0042E4B3, 0x002EE1AD, 0x002EE4BA, 0x002EE4BA, 0x002EE4C8, 0x0035C397, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x00427B7F, 0x002EE4BA, 0x0046D69A, 0x002EC3AC, 
        0x002EE6D4, 0x002EE6D4, 0x2D447278, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xFA000000, 0xF7000000, 0xF4000000, 0xF0000000, 0xED000000, 0xEB000000, 0xEB000000, 0xEC000000, 0xEF000000, 0xF3000000, 0x1515153D, 
        0x0046BED8, 0x0022E1FE, 0x001CCBFB, 0x001CD2FC, 0x0022E6FE, 0x0022E6FE, 0x0032EBFF, 0x0022E6FE, 0x0022E6FE, 0x0022E6FE, 0x0022E6FE, 0x0032EBFF, 0x0022E4FC, 0x0032EBFF, 0x001CE0FC, 0x0032EBFF, 0x0022E4FC, 0x001CE0FB, 0x001CE0FC, 0x001CE0FB, 
        0x001CC1F8, 0x001CC1F8, 0x001CC1F8, 0x001CCCFA, 0x001CADF5, 0x001C84E6, 0x00222E8D, 0x00220040, 0x00220042, 0x0022003D, 0x00220042, 0x0022003D, 0x00220042, 0x0027154C, 0x00383B5F, 0x6E000000, 0x79000000, 0x85000000, 0x94001515, 0xA1000000, 
        0xAE000000, 0xB9000000, 0xC3000000, 0xCB000000, 0xD0000000, 0xD6000000, 0xDA000000, 0xDE000000, 0xE0000000, 0xE3000000, 0xE6000000, 0xE8000000, 0xEA000000, 0xEC000000, 0xEE000000, 0xF0000000, 0xF2000000, 0xF3000000, 0xF4000000, 0xF5000000, 
        0xF6000000, 0xF7000000, 0xF8000000, 0xF8000000, 0xF9000000, 0xF9000000, 0xFA000000, 0xFA000000, 0xFA000000, 0xFB000000, 0xFB000000, 0xFB000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFC000000, 
        0xFC000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EE1AD, 0x0042E4B3, 0x0046D69A, 0x002EE4BA, 0x002EE6D4, 0x002EE4C8, 0x0022A474, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x292E675C, 0x002EB1A3, 0x002EE4BA, 0x0046B497, 0x002EE4C8, 
        0x0042EBDA, 0x004CEAC9, 0x2D447278, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xFA000000, 0xF7000000, 0xF3000000, 0xEE000000, 0xE9000000, 0xE5000000, 0xE3000000, 0xE3000000, 0xE5000000, 0xE9000000, 0x88000015, 0x001C003D, 
        0x001C7EC8, 0x0022E6FE, 0x001CE0FC, 0x001CD2FC, 0x0022E6FE, 0x0022E6FE, 0x0032EBFF, 0x0022E6FE, 0x0022E6FE, 0x0022E9FF, 0x0022E6FE, 0x0032EBFF, 0x0022E9FF, 0x0022E6FE, 0x0022E4FC, 0x0022E9FF, 0x0022E4FC, 0x001CE0FC, 0x001CE0FC, 0x001CE0FC, 
        0x001CCCFA, 0x001CCCFA, 0x001CC1F8, 0x001CD2FC, 0x001CADF5, 0x001C84E6, 0x001C7EC8, 0x001C0046, 0x00220042, 0x001C003D, 0x00220042, 0x00220042, 0x001C0038, 0x0027154C, 0x002B0048, 0x002E3255, 0x7D000000, 0x8B000000, 0x9A000015, 0xAB000000, 
        0xB9000000, 0xC4000000, 0xCE000000, 0xD8000000, 0xDE000000, 0xE3000000, 0xE7000000, 0xEA000000, 0xEC000000, 0xEE000000, 0xF0000000, 0xF2000000, 0xF3000000, 0xF5000000, 0xF6000000, 0xF7000000, 0xF8000000, 0xF9000000, 0xFA000000, 0xFA000000, 
        0xFB000000, 0xFB000000, 0xFC000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 
        0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0027B498, 0x002EE1AD, 0x002EE1AD, 0x0027D297, 0x002EE4BA, 0x002EE6D4, 0x002EE1AD, 0x2D447278, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0x003B7E72, 0x002EC3AC, 0x002EC3AC, 0x002EB1A3, 0x0032EADC, 
        0x0032EADC, 0x002EE1AD, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xF7000000, 0xF3000000, 0xED000000, 0xE6000000, 0xE0000000, 0xDB000000, 0xD9000000, 0xD9000000, 0xDD000000, 0xE2000000, 0x37001535, 0x001C0038, 
        0x0046BED8, 0x0022E9FF, 0x001CC1F8, 0x001CD2FC, 0x0022E6FE, 0x0022E1FE, 0x0032EBFF, 0x0032EBFF, 0x0022E6FE, 0x0032EBFF, 0x0032EBFF, 0x0022E9FF, 0x001CE0FC, 0x0022E9FF, 0x0022E9FF, 0x0022E6FE, 0x0022E9FF, 0x0022E9FF, 0x001CE0FC, 0x001CD2FC, 
        0x001CD2FC, 0x001CD2FC, 0x001CD2FC, 0x001CD2FC, 0x001CC1F8, 0x001CADF5, 0x001C7EC8, 0x001C005A, 0x00220042, 0x00220040, 0x00220042, 0x00220040, 0x0022003D, 0x002B0048, 0x00220040, 0x0027154C, 0x37001535, 0x8E000000, 0x9C000000, 0xAE000000, 
        0xBD000000, 0xCB000000, 0xD6000000, 0xDF000000, 0xE6000000, 0xEC000000, 0xEF000000, 0xF2000000, 0xF4000000, 0xF6000000, 0xF7000000, 0xF8000000, 0xF9000000, 0xFA000000, 0xFB000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFD000000, 
        0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x04274655, 0x002EC3AC, 0x002EE1AD, 0x0042E4B3, 0x0035C397, 0x002EE4C8, 0x002EE4BA, 0x003BBA87, 0xFE000000, 0xFD000000, 0xFC000000, 0xFB000000, 0x0035A48F, 0x002EC3B9, 0x0027B498, 0x002EC3B9, 0x0032EADC, 
        0x0032EADC, 0x0022BC83, 0xFE000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xF8000000, 0xF3000000, 0xED000000, 0xE5000000, 0xDD000000, 0xD6000000, 0xD0000000, 0xCE000000, 0xD0000000, 0xD5000000, 0xDC000000, 0x37001535, 0x001C003B, 
        0x001C7EC8, 0x0022E1FE, 0x001CC1F8, 0x001CC1F8, 0x001CD2FC, 0x001CCBFB, 0x0022E9FF, 0x0022E4FC, 0x0022E6FE, 0x0032EBFF, 0x0032EBFF, 0x0022E4FC, 0x0022E4FC, 0x0022E1FE, 0x0022E6FE, 0x001CD2FC, 0x001CE0FB, 0x0022E4FC, 0x001CD2FC, 0x001CE0FC, 
        0x001CCCFA, 0x001CE0FB, 0x001CE0FC, 0x001CD2FC, 0x001CC1F8, 0x001CADF5, 0x001C84E6, 0x002B387A, 0x001C0046, 0x0027003D, 0x00220042, 0x00220040, 0x00220042, 0x002B0048, 0x00220042, 0x002B0048, 0x00383B5F, 0x8B000000, 0x9C000000, 0xAB000000, 
        0xBB000000, 0xCB000000, 0xD8000000, 0xE2000000, 0xEA000000, 0xF0000000, 0xF4000000, 0xF7000000, 0xF9000000, 0xFA000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0x0022757D, 0x002EE1AD, 0x002EE1AD, 0x002EE1AD, 0x002EC3AC, 0x002EE4C8, 0x002EE1AD, 0x2D447278, 0xFB000000, 0xFA000000, 0x3422384A, 0x002EB1A3, 0x0146C3A8, 0x0035A48F, 0x002EE6D4, 0x002EE6D4, 
        0x002EE4C8, 0x8B224040, 0xFC000000, 0xFD000000, 0xFD000000, 0xFC000000, 0x8B224040, 0x292E675C, 0x003B7E72, 0x003B7E72, 0x00449582, 0x00229A7E, 0x00229A7E, 0x00449582, 0x00449582, 0x003B7E72, 0x003B7E72, 0x292E675C, 0x0022384C, 0x0015002E, 
        0x001C7EC8, 0x001CD2FC, 0x001CD2FC, 0x001CC1F8, 0x001CC1F8, 0x0022E1FE, 0x0022E4FC, 0x0022E6FE, 0x0032EBFF, 0x0032EBFF, 0x0022E9FF, 0x0022E6FE, 0x0022E4FC, 0x0022E6FE, 0x0032EBFF, 0x001CE0FC, 0x001CD2FC, 0x0022E6FE, 0x001CD2FC, 0x001CE0FC, 
        0x001CCCFA, 0x001CE0FC, 0x001CE0FC, 0x001CCCFA, 0x001CC1F8, 0x001CADF5, 0x001C84E6, 0x00272E90, 0x0027154C, 0x00220042, 0x00220042, 0x001C0038, 0x00220042, 0x002B0048, 0x00220042, 0x002B0048, 0x002B0048, 0x1B2B3B55, 0x95000000, 0xA7000000, 
        0xB7000000, 0xC6000000, 0xD3000000, 0xDF000000, 0xE8000000, 0xEF000000, 0xF4000000, 0xF8000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0x8B224040, 0x002EB1A3, 0x002EE1AD, 0x002EE4BA, 0x0027D297, 0x002EC3AC, 0x002EC3B9, 0x0035A48F, 0xF9000000, 0xF6000000, 0x3422384A, 0x002EB1A3, 0x0027B498, 0x002EB1A3, 0x002EE6D4, 0x002EE6D4, 
        0x0027D297, 0xF7000000, 0xF9000000, 0x8B224040, 0x00226760, 0x00449582, 0x0035A48F, 0x0027B498, 0x002EB1A3, 0x002EB1A3, 0x002EC3AC, 0x002EC3AC, 0x002EB1A3, 0x002EB1A3, 0x0035A48F, 0x0035A48F, 0x002EB1A3, 0x0035A48F, 0x0022384C, 0x0015002E, 
        0x002276A3, 0x001CD2FC, 0x001CE0FC, 0x001CADF5, 0x001CADF5, 0x0022E1FE, 0x001CD2FC, 0x0022E1FE, 0x0022E9FF, 0x0022E6FE, 0x0022E6FE, 0x0022E1FE, 0x0022E6FE, 0x0022E6FE, 0x0022E4FC, 0x001CE0FC, 0x001CE0FB, 0x0022E4FC, 0x001CD2FC, 0x001CE0FC, 
        0x001CE0FC, 0x001CD2FC, 0x0022E4FC, 0x001CD2FC, 0x001CCCFA, 0x001CC1F8, 0x001CADF5, 0x00222B99, 0x001C0066, 0x0022003D, 0x00220040, 0x00220040, 0x00220042, 0x0022003D, 0x0022003D, 0x00220042, 0x002B0048, 0x0027154C, 0x8E000000, 0x9C000000, 
        0xAE000000, 0xBB000000, 0xCB000000, 0xD8000000, 0xE2000000, 0xEB000000, 0xF2000000, 0xF7000000, 0xFA000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0x0022757D, 0x002EE1AD, 0x002EE4BA, 0x002EE1AD, 0x0035C397, 0x002EC3AC, 0x002EC3AC, 0x8B224040, 0xF1000000, 0x292E675C, 0x0027B498, 0x002BA485, 0x002EC3B9, 0x002EE6D4, 0x002EE4C8, 
        0x2D447278, 0x8B224040, 0x2D447278, 0x00449582, 0x002EB1A3, 0x002EC3B9, 0x002EC3B9, 0x002EB1A3, 0x0035A48F, 0x002EB1A3, 0x002EB1A3, 0x002EB1A3, 0x002EB1A3, 0x002EC3AC, 0x002EC3AC, 0x002EC3AC, 0x002EC3AC, 0x0146C3A8, 0x01223D4C, 0x0015002E, 
        0x00222E8D, 0x0022E4FC, 0x001CD2FC, 0x001CADF5, 0x001CC1F8, 0x001CCBFB, 0x001CD2FC, 0x001CE0FC, 0x0022E9FF, 0x0022E6FE, 0x0022E6FE, 0x0022E1FE, 0x0022E1FE, 0x0022E4FC, 0x001CE0FC, 0x001CE0FC, 0x0022E6FE, 0x001CE0FB, 0x001CE0FC, 0x001CD2FC, 
        0x001CE0FB, 0x001CE0FC, 0x001CE0FB, 0x001CD2FC, 0x001CD2FC, 0x001CCCFA, 0x002BC5F0, 0x002276A3, 0x01221C8D, 0x001C0046, 0x0027003D, 0x00220040, 0x00220040, 0x00220042, 0x00220042, 0x00220040, 0x002B0048, 0x002B0048, 0x1B2B3B55, 0x91000000, 
        0xA1000000, 0xB1000000, 0xC0000000, 0xCD000000, 0xD9000000, 0xE4000000, 0xED000000, 0xF3000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x0035A48F, 0x002EE4BA, 0x002EE4BA, 0x0027D297, 0x0027B498, 0x002EC3AC, 0x0E4C9C84, 0xEB000000, 0x292E675C, 0x0035A48F, 0x00229A7E, 0x002EE6D4, 0x002EE6D4, 0x0027B498, 
        0xE5000000, 0x0027B498, 0x0042EBDA, 0x002EC3B9, 0x002EC3B9, 0x002EC3B9, 0x002EE4C8, 0x002EE4C8, 0x002EE4C8, 0x002EE6D4, 0x002EE4C8, 0x002EE6D4, 0x002EE6D4, 0x002EE6D4, 0x002EE4C8, 0x002EE6D4, 0x002EE6D4, 0x002EE6D4, 0x00356762, 0x001C0038, 
        0x001C0066, 0x001CCCFA, 0x001CD2FC, 0x001CADF5, 0x001CCBFB, 0x001CC1F8, 0x001CC1F8, 0x001CE0FC, 0x0022E4FC, 0x001CE0FC, 0x001CE0FC, 0x001CE0FC, 0x0022E1FE, 0x001CE0FC, 0x0022E4FC, 0x001CE0FC, 0x0022E9FF, 0x0022E4FC, 0x001CE0FB, 0x001CE0FB, 
        0x001CE0FB, 0x001CE0FB, 0x001CE0FB, 0x001CE0FB, 0x0032E6FA, 0x001CE0FB, 0x001CCCFA, 0x002276A3, 0x01221C8D, 0x001C0066, 0x00220040, 0x0022003D, 0x0022003D, 0x002B0048, 0x002B0048, 0x0027154C, 0x001C0046, 0x0027154C, 0x002E3255, 0x85000000, 
        0x95000000, 0xA2000015, 0xB1000000, 0xC0000000, 0xCE000000, 0xDA000000, 0xE4000000, 0xED000000, 0xF3000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x2D447278, 0x002EC3AC, 0x002EE4BA, 0x002EE4BA, 0x0027B498, 0x002EB1A3, 0x0027B498, 0x8B224040, 0x292E675C, 0x00229A7E, 0x00449582, 0x0042EBDA, 0x002EC3B9, 0x8B224040, 
        0x0022757D, 0x0027B498, 0x002EE4C8, 0x0042EBDA, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x002EE6D4, 0x002EE6D4, 0x002EE6D4, 0x002EE6D4, 0x0032EADC, 0x002EE6D4, 0x002EE4BA, 0x002EC3B9, 0x002EB1A3, 0x00227575, 0x002E3255, 0x00220042, 
        0x00150040, 0x0046BED8, 0x0022E1FE, 0x001CCCFA, 0x001CC1F8, 0x001CC1F8, 0x001CC1F8, 0x001CE0FC, 0x001CE0FC, 0x001CCBFB, 0x001CD2FC, 0x0022E4FC, 0x001CE0FC, 0x001CE0FC, 0x0022E1FE, 0x001CE0FC, 0x0032EBFF, 0x0022E4FC, 0x0022E6FE, 0x001CE0FB, 
        0x0022E4FC, 0x0022E4FC, 0x0022E4FC, 0x001CE0FB, 0x0032E6FA, 0x0032E6FA, 0x001C84E6, 0x00222B99, 0x00222B99, 0x002B387A, 0x001C005A, 0x0022003D, 0x0022003D, 0x00220040, 0x00220042, 0x0027154C, 0x00220042, 0x002B0048, 0x002B0048, 0x1B2B3B55, 
        0x85000000, 0x95000000, 0xA2000015, 0xB1000000, 0xC0000000, 0xCE000000, 0xDA000000, 0xE5000000, 0xED000000, 0xF4000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x00449582, 0x002EE4BA, 0x002EE4BA, 0x002EE1AD, 0x0035A48F, 0x002EB1A3, 0x00276B62, 0x292E675C, 0x00449582, 0x004C9987, 0x0042EBDA, 0x2D447278, 0x70000015, 
        0x0035A48F, 0x0022B180, 0x002EE1AD, 0x0040EDFC, 0x0032EADC, 0x0032EADC, 0x002EE6D4, 0x002EC3B9, 0x002EB1A3, 0x002EB1A3, 0x0022A489, 0x00449582, 0x003B7E72, 0x00276B62, 0x01223D4C, 0x011C2B48, 0x00223D66, 0x002B545D, 0x00274057, 0x00220042, 
        0x001C0035, 0x001C7EC8, 0x0032EBFF, 0x0022E1FE, 0x001CC1F8, 0x001CADF5, 0x001CC1F8, 0x001CD2FC, 0x001CCBFB, 0x001CCBFB, 0x001CD2FC, 0x001CD2FC, 0x001CD2FC, 0x001CD2FC, 0x0022E4FC, 0x001CD2FC, 0x001CE0FC, 0x0022E6FE, 0x001CE0FB, 0x001CE0FB, 
        0x001CE0FB, 0x0022E4FC, 0x001CE0FB, 0x0022E6FE, 0x0032E6FA, 0x001CCCFA, 0x002276A3, 0x00222B99, 0x00222B99, 0x01221C8D, 0x001C0066, 0x0027154C, 0x0027003D, 0x002B0048, 0x00220042, 0x00220042, 0x002B0048, 0x001C0046, 0x002B0048, 0x002E3255, 
        0x7A000015, 0x85000000, 0x95000000, 0xA2000015, 0xB1000000, 0xC1000000, 0xCE000000, 0xDB000000, 0xE6000000, 0xEE000000, 0xF5000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x3422384A, 0x292E675C, 0x2D447278, 0x292E675C, 0x00225A6F, 0x00449582, 0x002EC3AC, 0x002EC3B9, 0x0027B498, 0x0035A48F, 0x00449582, 0x002B545D, 0x00227575, 0x0035A48F, 0x0146C3A8, 0xB1000000, 0x00449582, 
        0x002EE6D4, 0x0035C397, 0x0046D69A, 0x002EE4C8, 0x004CEAC9, 0x00276B62, 0x00274057, 0x011C2B48, 0x011C2B48, 0x01273250, 0x0022384C, 0x00222248, 0x0022384C, 0x01223D4C, 0x00225459, 0x002B545D, 0x002B545D, 0x00223D5A, 0x01273250, 0x002B0048, 
        0x001C0035, 0x002B387A, 0x001CD2FC, 0x0032EBFF, 0x001CD2FC, 0x001CADF5, 0x001CADF5, 0x001CC1F8, 0x001CC1F8, 0x001CC1F8, 0x001CCBFB, 0x001CCBFB, 0x001CD2FC, 0x001CD2FC, 0x001CD2FC, 0x001CD2FC, 0x001CD2FC, 0x0022E4FC, 0x001CE0FC, 0x001CE0FB, 
        0x0032E6FA, 0x0022E4FC, 0x0032E6FA, 0x0032EBFF, 0x001CE0FB, 0x001C7EC8, 0x00222B99, 0x00222B99, 0x00222B99, 0x00272E90, 0x01221C8D, 0x001C0066, 0x001C0046, 0x0022003D, 0x00220042, 0x00220042, 0x002B0048, 0x00220042, 0x002B0048, 0x002E3255, 
        0x70000000, 0x7A000015, 0x85000000, 0x95000000, 0xA4000000, 0xB1000000, 0xC3000000, 0xD0000000, 0xDD000000, 0xE7000000, 0xF0000000, 0xF6000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0046D69A, 0x0046D69A, 0x0035C397, 0x0035C397, 0x0046B497, 0x002BA485, 0x002B8669, 0x00276B62, 0x0022757D, 0x00449582, 0x0035A48F, 0x00276B62, 0x00227575, 0x002EC3AC, 0x002B8669, 0x0040818E, 0x002EE6D4, 
        0x002EE6D4, 0x0035A48F, 0x0027D297, 0x0042E4B3, 0x0042EBDA, 0x002B8669, 0x0022384C, 0x01273250, 0x011C2B48, 0x01273250, 0x00383B5F, 0x00383B5F, 0x00274057, 0x01273250, 0x011C2B48, 0x00222248, 0x00274057, 0x00274057, 0x002E3255, 0x0027154C, 
        0x001C0035, 0x001C0046, 0x001C7EC8, 0x0032E6FA, 0x0022E9FF, 0x001CC1F8, 0x001CADF5, 0x001CC1F8, 0x001CC1F8, 0x001CC1F8, 0x001CC1F8, 0x001CCBFB, 0x001CCCFA, 0x001CCCFA, 0x001CD2FC, 0x001CD2FC, 0x001CE0FC, 0x001CE0FC, 0x0022E4FC, 0x0032E6FA, 
        0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0032E6FA, 0x001C7EC8, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x002B387A, 0x001C005A, 0x00220042, 0x0022003D, 0x00220040, 0x00220040, 0x00220042, 0x002B0048, 0x002B0048, 
        0x37001535, 0x70000000, 0x7A000015, 0x88000000, 0x95000000, 0xA4000000, 0xB5000000, 0xC4000000, 0xD3000000, 0xDF000000, 0xE9000000, 0xF1000000, 0xF7000000, 0xFB000000, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EE4C8, 0x002EE4BA, 0x002EE4BA, 0x002EE4C8, 0x002EE4BA, 0x002EE4C8, 0x002EE4C8, 0x0042E4B3, 0x003BBA87, 0x00276B62, 0x00227575, 0x0035A48F, 0x00449582, 0x002EC3AC, 0x0040818E, 0x002EE4C8, 0x0035A48F, 
        0x00226760, 0x003B7E72, 0x002BC98C, 0x002EE1AD, 0x002EE4C8, 0x006DEDD4, 0x0046B497, 0x0027B498, 0x002BA485, 0x002BA485, 0x002BA485, 0x00229A7E, 0x00229A7E, 0x002B8669, 0x0022786F, 0x002B545D, 0x0022384C, 0x00222248, 0x002E3255, 0x01273250, 
        0x001C003D, 0x00150035, 0x001C005A, 0x001C7EC8, 0x0040EDFC, 0x0022E9FF, 0x001CD2FC, 0x001CC1F8, 0x001CC1F8, 0x001CCBFB, 0x001CCCFA, 0x001CD2FC, 0x001CC1F8, 0x001CC1F8, 0x001CE0FC, 0x0022E4FC, 0x0022E4FC, 0x0022E9FF, 0x0032EBFF, 0x0040EDFC, 
        0x0040EDFC, 0x0040EDFC, 0x002BC5F0, 0x001C7EC8, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x002B387A, 0x001C0066, 0x001C005A, 0x001C003D, 0x001C003D, 0x00220042, 0x00220040, 0x00220040, 0x00220042, 
        0x19222250, 0x69000000, 0x70000000, 0x7A000015, 0x88000000, 0x98000000, 0xA7000000, 0xB7000000, 0xC8000000, 0x292E675C, 0x292E675C, 0x3422384A, 0xF4000000, 0x8B224040, 0x0050A689, 0x002B545D, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0027D297, 0x002EC3AC, 0x002EC3AC, 0x002EC3AC, 0x0146C3A8, 0x0035C397, 0x002EC3AC, 0x002EC3AC, 0x002EC3AC, 0x002EC3AC, 0x0035A48F, 0x0035A48F, 0x002EC3AC, 0x002EE4BA, 0x002EE4C8, 0x0146C3A8, 0x0035A48F, 
        0x0027B498, 0x0035C397, 0x002BC98C, 0x0046D69A, 0x002EE1AD, 0x0042EBDA, 0x004CEAC9, 0x002EC3AC, 0x0035C397, 0x0035C397, 0x0035C397, 0x0035C397, 0x0035C397, 0x0035C397, 0x0035C397, 0x0022B180, 0x00229A7E, 0x002B8669, 0x00226760, 0x01273250, 
        0x00220042, 0x0015002E, 0x001C0046, 0x002B387A, 0x001CADF5, 0x0032E6FA, 0x0040EDFC, 0x0022E6FE, 0x001CE0FC, 0x001CD2FC, 0x001CCCFA, 0x001CCCFA, 0x001CD2FC, 0x001CD2FC, 0x0032E6FA, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 
        0x0032E6FA, 0x001C84E6, 0x001C7EC8, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x002B387A, 0x001C0066, 0x00220042, 0x001C0038, 0x001C003D, 0x0022003D, 0x00220042, 0x001C003D, 
        0x1515153D, 0x63000000, 0x69000000, 0x73000000, 0x7D000000, 0x8B000000, 0x9A000015, 0xAB000000, 0x59224244, 0x0050A689, 0x0050A689, 0x002B8669, 0x00356762, 0x0046B497, 0x004CAE84, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0042EBDA, 0x0032EADC, 0x0032EADC, 0x0042EBDA, 0x0042EBDA, 0x0042EBDA, 0x0042EBDA, 0x002EE6D4, 0x002EE4C8, 0x002EC3B9, 0x002EC3B9, 0x002EE6D4, 0x002EE4C8, 0x002EE6D4, 0x002EE4C8, 0x002EE4BA, 0x002EE4BA, 
        0x002EE1AD, 0x0027D297, 0x003BBA87, 0x0046D69A, 0x0027D297, 0x002EE4C8, 0x007AF0F5, 0x0042EBDA, 0x002EE6D4, 0x002EE4C8, 0x002EE4C8, 0x002EC3B9, 0x002EC3B9, 0x002EC3AC, 0x002EC3AC, 0x0035C397, 0x0035C397, 0x0146C3A8, 0x0027B498, 0x0022B180, 
        0x002B8669, 0x011C3B4A, 0x00150038, 0x001C0066, 0x00222B99, 0x001C84E6, 0x001CCCFA, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0022E4FC, 0x0022E1FE, 0x0032E6FA, 0x0040EDFC, 0x002BC5F0, 0x001CCCFA, 0x001CD2FC, 0x001CD2FC, 0x002BC5F0, 0x001CADF5, 
        0x001C7EC8, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x002B387A, 0x001C0066, 0x0027154C, 0x0022003D, 0x001C0038, 0x001C003D, 0x0027154C, 0x001C003D, 
        0x0027154C, 0x5F000000, 0x63000000, 0x6A000000, 0x73000000, 0x80000000, 0x8E000000, 0x9E000015, 0x59224244, 0xC1000000, 0x8B224040, 0x0046B497, 0x00449582, 0x0046D69A, 0x004CAE84, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0032EADC, 0x0042EBDA, 0x0042EBDA, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x002EE4C8, 0x00229A7E, 0x002287AD, 0x0027B498, 0x04274655, 0x00225A6F, 
        0x002EC3B9, 0x002EE4BA, 0x0022BC83, 0x0027D297, 0x0027CA7E, 0x002EE1AD, 0x0042EBDA, 0x007AF0F5, 0x0032EADC, 0x0040EDFC, 0x0040EDFC, 0x0032EADC, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0040EDFC, 0x0042EBDA, 
        0x002EE6D4, 0x002EC3B9, 0x00229A7E, 0x00222248, 0x002B387A, 0x00222B99, 0x002276A3, 0x001C84E6, 0x001CADF5, 0x0032E6FA, 0x0040EDFC, 0x0040EDFC, 0x0032E6FA, 0x0046BED8, 0x00222B99, 0x00222B99, 0x001C7EC8, 0x001C7EC8, 0x002276A3, 0x00222B99, 
        0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x002B387A, 0x001C0066, 0x001C005A, 0x001C003D, 0x0022003D, 0x001C003D, 0x001C003D, 0x00220042, 
        0x001C0046, 0x5C000000, 0x5F000000, 0x65000000, 0x6C000000, 0x75000000, 0x83000000, 0x94001515, 0xA4000000, 0x003B7E72, 0x0046B497, 0x004CAE84, 0x00449582, 0x004CAE84, 0x0046B497, 0x0046B497, 0x0046B497, 0x2D447278, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x0035A48F, 0x002EC3B9, 0x002EE4C8, 
        0x002EC3B9, 0x0027B498, 0x003B7E72, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0042EBDA, 0x0042EBDA, 0x0042EBDA, 0x0042EBDA, 0x0032EADC, 0x0042EBDA, 0x004CEAC9, 0x0146C3A8, 0x0022786F, 0x0022384C, 0x00226D89, 0x002EC3B9, 0x004C9987, 0x00274057, 
        0x00222248, 0x0040818E, 0x002BA485, 0x0027CA7E, 0x0027D297, 0x0035C397, 0x002EE6D4, 0x0042EBDA, 0x007AF0F5, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0032EADC, 0x0042EBDA, 0x002EE6D4, 0x002EC3B9, 0x002EC3B9, 0x0035A48F, 0x0022757D, 
        0x00227575, 0x00225A6F, 0x0022757D, 0x00356762, 0x0027154C, 0x002B387A, 0x01221C8D, 0x00222B99, 0x00222B99, 0x00222B99, 0x001C7EC8, 0x001C7EC8, 0x002276A3, 0x00272E90, 0x002B387A, 0x002B387A, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 
        0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x002B387A, 0x01221C8D, 0x002B387A, 0x001C0066, 0x001C003D, 0x00220040, 0x001C003D, 0x001C003D, 0x00220042, 
        0x00220042, 0x1515153D, 0x5C000000, 0x60000000, 0x3422384A, 0x2D447278, 0x0E4C9C84, 0x2D447278, 0x2D447278, 0x004CAE84, 0x003B7E72, 0x0046B497, 0x004CAE84, 0x004CAE84, 0x0050A689, 0x0E4C9C84, 0x8B224040, 0x8B224040, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x0035A48F, 0x002EC3B9, 0x002EC3B9, 0x002EC3B9, 
        0x002EC3B9, 0x002EC3B9, 0x002EB1A3, 0x0E4C9C84, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0027B498, 0x002EC3AC, 0x002EC3AC, 0x002EC3AC, 0x002EC3AC, 0x002EC3AC, 0x002EE4C8, 0x004CEAC9, 0x002EE4BA, 0x002EE1AD, 0x0046B497, 0x0022786F, 0x0022384C, 0x00226D89, 0x002EE6D4, 0x002EC3AC, 0x0040818E, 
        0x002B545D, 0x00220042, 0x002B545D, 0x0022BC83, 0x0027CA7E, 0x0022BC83, 0x002EC3AC, 0x002EE4C8, 0x007AF0F5, 0x0046B497, 0x0022757D, 0x00225A6F, 0x00225459, 0x00223D5A, 0x00225A6F, 0x002B545D, 0x00274057, 0x00274057, 0x00274057, 0x04274655, 
        0x00225459, 0x01223D4C, 0x0022384C, 0x0022003D, 0x001C003B, 0x001C005A, 0x002B387A, 0x01221C8D, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x002B387A, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 
        0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00272E90, 0x01221C8D, 0x01221C8D, 0x002B387A, 0x002B387A, 0x001C0066, 0x001C0046, 0x001C003D, 0x0015003D, 0x001C003D, 0x001C003D, 
        0x0027154C, 0x1515153D, 0x1B2B3B55, 0x00225459, 0x0022786F, 0x004C9987, 0x0046B497, 0x0046B497, 0x0046B497, 0x002EB1A3, 0x0050A689, 0x004CAE84, 0x00225A6F, 0x00449582, 0x00449582, 0x0046B497, 0x0146C3A8, 0x0E4C9C84, 0x2D447278, 0x2D447278, 
        0x2D447278, 0x2D447278, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0x00427B7F, 0x0035A48F, 0x002EB1A3, 0x002EB1A3, 0x002EB1A3, 0x0035A48F, 
        0x004C9987, 0x0035A48F, 0x002287AD, 0x002EB1A3, 0x0035A48F, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x00227575, 0x0022786F, 0x0022786F, 0x00226760, 0x00449582, 0x002EE4C8, 0x004CEAC9, 0x004CEAC9, 0x002EE4BA, 0x002EE4BA, 0x002EE4C8, 0x004CEAC9, 0x002EC3B9, 0x0035A48F, 0x002EE6D4, 0x002EE6D4, 0x0027B498, 
        0x0040818E, 0x00225459, 0x002B545D, 0x0022B180, 0x0027CA7E, 0x0027CA7E, 0x0027B498, 0x002EE4C8, 0x0042EBDA, 0x006DEDD4, 0x002B545D, 0x011C2B48, 0x001C153B, 0x00150040, 0x00225459, 0x00226760, 0x00274057, 0x00274057, 0x01273250, 0x0022384C, 
        0x00274057, 0x00225459, 0x00274057, 0x0022384C, 0x001C153B, 0x001C0046, 0x001C005A, 0x002B387A, 0x01221C8D, 0x00222B99, 0x00222B99, 0x00272E90, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x00222B99, 0x00222B99, 0x00222B99, 
        0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x00222B99, 0x01221C8D, 0x002B387A, 0x001C0066, 0x0027154C, 0x001C0038, 0x001C003D, 0x00222248, 0x01273250, 
        0x00224060, 0x00225565, 0x00227575, 0x00227575, 0x00227575, 0x0022757D, 0x00427B7F, 0x0022757D, 0x004C9987, 0x00449582, 0x004C9987, 0x00276B62, 0x00225565, 0x00225A6F, 0x0035A48F, 0x0035A48F, 0x0035A48F, 0x0022A489, 0x0035A48F, 0x0035A48F, 
        0x002EB1A3, 0x002EB1A3, 0x0027B498, 0x0035A48F, 0x2D447278, 0xFC000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 0x8B224040, 0x2D447278, 0x002EB1A3, 0x002EB1A3, 0x002EB1A3, 0x004C9987, 0x0035A48F, 0x0035A48F, 0x004C9987, 
        0x004C9987, 0x0040818E, 0x0040818E, 0x0040818E, 0x002EB1A3, 0x2D447278, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x00427B7F, 0x003B7E72, 0x002BA485, 0x002BA485, 0x002EE4C8, 0x004CEAC9, 0x002EE4BA, 0x0042E4B3, 0x004CEAC9, 0x0042EBDA, 0x0042EBDA, 0x007AF0F5, 0x007AF0F5, 0x007AF0F5, 0x007AF0F5, 0x0032EADC, 0x002EE4C8, 
        0x00449582, 0x0022757D, 0x002B545D, 0x00229A7E, 0x0022BC83, 0x0027CA7E, 0x0022B180, 0x002EE4BA, 0x004CEAC9, 0x007AF0F5, 0x0050A689, 0x00223D5A, 0x00274057, 0x0022384C, 0x00225459, 0x00356762, 0x00274057, 0x00274057, 0x002B545D, 0x0022786F, 
        0x00449582, 0x0050A689, 0x0046B497, 0x0046B497, 0x0050A689, 0x004C9987, 0x0022786F, 0x00225565, 0x001C0066, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x00272E90, 0x00222B99, 
        0x00272E90, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x002B387A, 0x001C005A, 0x0027154C, 0x00222248, 0x00223D5A, 0x00223D66, 0x00225A6F, 
        0x00227575, 0x00225A6F, 0x00356762, 0x00225565, 0x00225A6F, 0x00227575, 0x00225A6F, 0x0022757D, 0x00227575, 0x00227575, 0x00227575, 0x00225A6F, 0x00225A6F, 0x0022757D, 0x0040818E, 0x0035A48F, 0x00449582, 0x0022786F, 0x00227575, 0x0040818E, 
        0x00449582, 0x0040818E, 0x0035A48F, 0x002EB1A3, 0x0027B498, 0x00449582, 0x00449582, 0x00449582, 0x0027B498, 0x0027B498, 0x0027B498, 0x002EB1A3, 0x002EC3AC, 0x002EB1A3, 0x0035A48F, 0x0035A48F, 0x00449582, 0x0022757D, 0x004C9987, 0x00427B7F, 
        0x00427B7F, 0x00226D89, 0x00427B7F, 0x003D5783, 0x002287AD, 0x0035A48F, 0x8B224040, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EE1AD, 0x0035C397, 0x00229A7E, 0x002EC3B9, 0x004CEAC9, 0x002EE1AD, 0x0042E4B3, 0x0042EBDA, 0x0042EBDA, 0x0042EBDA, 0x004CEAC9, 0x0146C3A8, 0x0035A48F, 0x004C9987, 0x0035A48F, 0x002EC3B9, 0x002EE4C8, 
        0x002EC3AC, 0x0040818E, 0x00225565, 0x00276B62, 0x0022BC83, 0x0022BC83, 0x0022BC83, 0x0035C397, 0x002EE4C8, 0x0042EBDA, 0x0378C6BE, 0x00224060, 0x00274057, 0x00274057, 0x00274057, 0x0022384C, 0x002B545D, 0x0035A48F, 0x0046D69A, 0x002EE4BA, 
        0x004CEAC9, 0x006DEDD4, 0x006DEDD4, 0x007AF0F5, 0x007AF0F5, 0x007AF0F5, 0x007AF0F5, 0x006DEDD4, 0x0378C6BE, 0x0035A48F, 0x00272E90, 0x00272E90, 0x00222B99, 0x00222B99, 0x00272E90, 0x01221C8D, 0x001C0066, 0x002B387A, 0x01221C8D, 0x00222B99, 
        0x00272E90, 0x00272E90, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x01221C8D, 0x002B387A, 0x001C0066, 0x0027154C, 0x00223D5A, 0x00225565, 0x00225A6F, 0x00225A6F, 0x00225565, 
        0x00227575, 0x00225A6F, 0x0022786F, 0x00225A6F, 0x00225A6F, 0x0022757D, 0x00227575, 0x0022757D, 0x0022757D, 0x00225A6F, 0x00225565, 0x00225A6F, 0x0022757D, 0x0040818E, 0x00225A6F, 0x0022757D, 0x0040818E, 0x00227575, 0x002B545D, 0x0022757D, 
        0x0022757D, 0x0022757D, 0x0022757D, 0x0035A48F, 0x0040818E, 0x0035A48F, 0x0035A48F, 0x0035A48F, 0x0035A48F, 0x0027B498, 0x0035A48F, 0x002EC3B9, 0x0035A48F, 0x004C9987, 0x0040818E, 0x0035A48F, 0x00449582, 0x00356762, 0x0040818E, 0x00225A6F, 
        0x00225A6F, 0x002B387A, 0x00225A6F, 0x00225565, 0x00226D89, 0x0040818E, 0x2D447278, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EE1AD, 0x0042E4B3, 0x0035C397, 0x002EE4BA, 0x002EE1AD, 0x002EE4BA, 0x006DEDD4, 0x006DEDD4, 0x0146C3A8, 0x004C9987, 0x00227575, 0x002B545D, 0x003B7E72, 0x00276B62, 0x002B545D, 0x00225459, 0x00225565, 
        0x0040818E, 0x00449582, 0x0022757D, 0x01223D4C, 0x0022A474, 0x0022BC83, 0x0022BC83, 0x002BAF7D, 0x002EE4BA, 0x002EE6D4, 0x006DEDD4, 0x002B8669, 0x00274057, 0x00274057, 0x002B545D, 0x00225A6F, 0x002EC3AC, 0x002EE4BA, 0x002EE4BA, 0x002EE4BA, 
        0x004CEAC9, 0x007AF0F5, 0x007AF0F5, 0x007AF0F5, 0x007AF0F5, 0x0378C6BE, 0x00449582, 0x002B545D, 0x00225565, 0x00427B7F, 0x0040818E, 0x00226D89, 0x00272E90, 0x00222B99, 0x00222B99, 0x01221C8D, 0x002B387A, 0x002B387A, 0x01221C8D, 0x00222B99, 
        0x00222B99, 0x01221C8D, 0x01221C8D, 0x00272E90, 0x00222B99, 0x01221C8D, 0x00272E90, 0x01221C8D, 0x006D627D, 0x00787283, 0x001C0066, 0x001C0066, 0x002E3255, 0x00223D5A, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x00227575, 0x00225A6F, 
        0x00225A6F, 0x0022757D, 0x00227575, 0x00225A6F, 0x00225565, 0x00225A6F, 0x00225A6F, 0x0022757D, 0x00227575, 0x00224060, 0x00224060, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x0022757D, 0x00227575, 0x0022757D, 0x002B545D, 0x00223D5A, 
        0x00225A6F, 0x00225A6F, 0x0022757D, 0x0022757D, 0x00427B7F, 0x0022757D, 0x00427B7F, 0x00427B7F, 0x0040818E, 0x0040818E, 0x0022757D, 0x0040818E, 0x0022757D, 0x0022757D, 0x00225A6F, 0x002287AD, 0x00427B7F, 0x00225A6F, 0x00226D89, 0x00225A6F, 
        0x00383B5F, 0x00383B5F, 0x002E3255, 0x00383B5F, 0x00225A6F, 0x003D5783, 0x2D447278, 0xFD000000, 0xFC000000, 0xFB000000, 0xFB000000, 0xFB000000, 0xFA000000, 0xFB000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0042E4B3, 0x0042E4B3, 0x002EC3AC, 0x002EE4BA, 0x002EE1AD, 0x004CEAC9, 0x002EE4BA, 0x002B8669, 0x00485263, 0x00225A6F, 0x00223D5A, 0x00220040, 0x00226760, 0x00229A7E, 0x002B8669, 0x00356762, 0x00225459, 
        0x00274057, 0x002287AD, 0x00427B7F, 0x00226760, 0x00277D62, 0x002BAF7D, 0x002BAF7D, 0x002BAF7D, 0x0027B498, 0x002EE4BA, 0x0042EBDA, 0x0378C6BE, 0x01273250, 0x00274057, 0x00225A6F, 0x0035C397, 0x002EE1AD, 0x002EC3AC, 0x002EC3AC, 0x002EE4C8, 
        0x006DEDD4, 0x006DEDD4, 0x007AF0F5, 0x006DEDD4, 0x003B7E72, 0x00356762, 0x00356762, 0x01223D4C, 0x001C0038, 0x001C0046, 0x0027154C, 0x002B387A, 0x01221C8D, 0x01221C8D, 0x00222B99, 0x00222B99, 0x01221C8D, 0x002B387A, 0x002B387A, 0x01221C8D, 
        0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x00222B99, 0x01221C8D, 0x006D627D, 0x006D627D, 0x006D627D, 0x00C6BEC2, 0x0022384C, 0x00274057, 0x01273250, 0x00223D5A, 0x00224060, 0x00226760, 0x00225A6F, 0x00225A6F, 0x0022786F, 0x00225A6F, 
        0x00227575, 0x0022757D, 0x00276B62, 0x00227575, 0x00226760, 0x00225565, 0x00227575, 0x0022757D, 0x00226760, 0x00223D5A, 0x00274057, 0x00224060, 0x00224060, 0x00225A6F, 0x00223D5A, 0x0022757D, 0x00225A6F, 0x00274057, 0x002E3255, 0x00223D5A, 
        0x00223D5A, 0x00224060, 0x0022757D, 0x0022757D, 0x00227575, 0x002B545D, 0x00227575, 0x00227575, 0x00225A6F, 0x0022757D, 0x00227575, 0x00226D89, 0x00225A6F, 0x00226D89, 0x00227575, 0x0040818E, 0x00427B7F, 0x00223D5A, 0x00225A6F, 0x01273250, 
        0x00224060, 0x1B2B3B55, 0x2D447278, 0x00274057, 0x00383B5F, 0x00225A6F, 0x2D447278, 0xFA000000, 0xF8000000, 0xF7000000, 0xF6000000, 0xF6000000, 0xF5000000, 0xF6000000, 0xF7000000, 0xF8000000, 0xFA000000, 0xFB000000, 0xFC000000, 0xFE000000, 
        0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EE1AD, 0x0046D69A, 0x002EC3AC, 0x0046D69A, 0x004CEAC9, 0x0042E4B3, 0x0035C397, 0x002B8669, 0x00274057, 0x00225A6F, 0x00222248, 0x001C003D, 0x01273250, 0x002B8669, 0x002B8669, 0x002B8669, 0x00427B7F, 
        0x00229A7E, 0x0022A489, 0x00229A7E, 0x00229A7E, 0x00226760, 0x0022A474, 0x002BAF7D, 0x002BAF7D, 0x002BA485, 0x002EE4C8, 0x0042EBDA, 0x005FE4B6, 0x01223D4C, 0x00274057, 0x00427B7F, 0x0035C397, 0x0035C397, 0x0035C397, 0x002EC3B9, 0x0042EBDA, 
        0x006DEDD4, 0x006DEDD4, 0x006DEDD4, 0x003B7E72, 0x002B545D, 0x01223D4C, 0x01223D4C, 0x002B545D, 0x01223D4C, 0x001C0038, 0x001C003B, 0x001C005A, 0x001C0066, 0x002B387A, 0x01221C8D, 0x01221C8D, 0x00272E90, 0x002B387A, 0x002B387A, 0x01221C8D, 
        0x01221C8D, 0x00222B99, 0x002B387A, 0x01221C8D, 0x001C0066, 0x001C005A, 0x00575970, 0x00948490, 0x004A4062, 0x00948490, 0x00225459, 0x002B545D, 0x00223D5A, 0x00225565, 0x00224060, 0x00225A6F, 0x00276B62, 0x00225565, 0x0022757D, 0x0022786F, 
        0x00225A6F, 0x0022757D, 0x00225565, 0x00225A6F, 0x00227575, 0x01273250, 0x00224060, 0x00225A6F, 0x00227575, 0x001C0046, 0x01273250, 0x001C0046, 0x0027154C, 0x00223D5A, 0x001C0046, 0x00223D66, 0x00224060, 0x0027154C, 0x00220042, 0x00223D5A, 
        0x00224060, 0x00224060, 0x00225A6F, 0x0022757D, 0x00225A6F, 0x0022384C, 0x00225565, 0x00276B62, 0x00225565, 0x00225A6F, 0x00227575, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x003D5783, 0x00225A6F, 0x0027154C, 0x00225A6F, 0x3422384A, 
        0xFE000000, 0xFD000000, 0xFD000000, 0xFC000000, 0x00225565, 0x00383B5F, 0x292E675C, 0xF4000000, 0xF2000000, 0xF0000000, 0xEE000000, 0xED000000, 0xED000000, 0xEE000000, 0xF0000000, 0xF2000000, 0xF5000000, 0xF7000000, 0xFA000000, 0xFC000000, 
        0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x00229A7E, 0x00229A7E, 0x002EC3AC, 0x002EE1AD, 0x002EE4BA, 0x00229A7E, 0x00449582, 0x002BA485, 0x00225459, 0x002B545D, 0x00274057, 0x00276B62, 0x00229A7E, 0x0027B498, 0x002EC3AC, 0x002EC3AC, 0x0146C3A8, 
        0x002EB1A3, 0x0027B498, 0x0027B498, 0x0027B498, 0x00277D62, 0x00277D62, 0x002BAF7D, 0x002BAF7D, 0x002BAF7D, 0x002EC3AC, 0x002EE4C8, 0x006DEDD4, 0x00277D62, 0x00274057, 0x00229A7E, 0x002BA485, 0x0027B498, 0x0035C397, 0x002EE6D4, 0x0042EBDA, 
        0x006DEDD4, 0x006DEDD4, 0x003B7E72, 0x011C2B48, 0x001C003D, 0x00274057, 0x00356762, 0x00274057, 0x00274057, 0x0022384C, 0x001C003D, 0x001C003D, 0x0027154C, 0x001C0066, 0x002B387A, 0x002B387A, 0x01221C8D, 0x002B387A, 0x001C0066, 0x001C005A, 
        0x001C0066, 0x001C0066, 0x01273250, 0x0027154C, 0x001C0046, 0x02221C46, 0x004A4062, 0x00948490, 0x002E3255, 0x00948490, 0x00356762, 0x002B545D, 0x00226760, 0x00225565, 0x00223D5A, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x0022757D, 0x00227575, 
        0x00225565, 0x0040818E, 0x00225A6F, 0x00224060, 0x0022757D, 0x00274057, 0x00274057, 0x00225A6F, 0x00227575, 0x001C0046, 0x0027154C, 0x001C0046, 0x0027154C, 0x00222248, 0x001C003D, 0x01273250, 0x00222248, 0x00220042, 0x001C0046, 0x002E3255, 
        0x00224060, 0x00225565, 0x00225A6F, 0x00225565, 0x00223D66, 0x01273250, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x00225565, 0x00225A6F, 0x00223D66, 0x00225A6F, 0x00223D66, 0x00485263, 0x00225A6F, 0x002B545D, 0x00485263, 0x292E675C, 0xFB000000, 
        0xFB000000, 0xFB000000, 0xFA000000, 0xF8000000, 0xF6000000, 0xF3000000, 0x8B224040, 0xEC000000, 0xE9000000, 0xE6000000, 0xE3000000, 0xE2000000, 0xE2000000, 0xE4000000, 0xE6000000, 0xEA000000, 0xEE000000, 0xF2000000, 0xF6000000, 0xF9000000, 
        0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0022A474, 0x0022384C, 0x0035C397, 0x002EE1AD, 0x003BBA87, 0x00274057, 0x00225A6F, 0x0035A48F, 0x00276B62, 0x00229A7E, 0x0035C397, 0x002EC3AC, 0x002EE1AD, 0x002EE1AD, 0x002EE1AD, 0x002EC3AC, 0x0146C3A8, 
        0x0027B498, 0x0035A48F, 0x0022A489, 0x0035A48F, 0x002B8669, 0x00225459, 0x0022A474, 0x0022A474, 0x002BAF7D, 0x0035A48F, 0x002EE4C8, 0x006DEDD4, 0x0022A474, 0x01273250, 0x002B8669, 0x00229A7E, 0x00229A7E, 0x002EC3B9, 0x002EE6D4, 0x0042EBDA, 
        0x0042EBDA, 0x0050A689, 0x02221C46, 0x011C2B48, 0x002B545D, 0x00356762, 0x01223D4C, 0x002B545D, 0x00575970, 0x00485263, 0x00787283, 0x01223D4C, 0x00220040, 0x001C0046, 0x001C005A, 0x001C0066, 0x001C005A, 0x0027154C, 0x00222248, 0x01273250, 
        0x00274057, 0x00274057, 0x00224060, 0x01273250, 0x01273250, 0x011C2B48, 0x002E3255, 0x00948490, 0x00485263, 0x00787283, 0x003B7E72, 0x00226760, 0x00225565, 0x00225565, 0x002B545D, 0x00225565, 0x002B545D, 0x00225A6F, 0x0022757D, 0x00227575, 
        0x00225A6F, 0x00226D89, 0x0022757D, 0x00222248, 0x0022757D, 0x00274057, 0x00222248, 0x00223D66, 0x0022757D, 0x001C0046, 0x0015003D, 0x00150040, 0x00222248, 0x01273250, 0x00222248, 0x00222248, 0x001C0046, 0x001C003D, 0x00150040, 0x0027154C, 
        0x002E3255, 0x00225565, 0x00225565, 0x002B545D, 0x002E3255, 0x002E3255, 0x00223D5A, 0x00383B5F, 0x00223D5A, 0x00223D66, 0x002B545D, 0x00223D5A, 0x00225565, 0x0027154C, 0x001C0046, 0x00223D66, 0x00225A6F, 0x8B224040, 0xF6000000, 0xF7000000, 
        0xF7000000, 0xF6000000, 0xF4000000, 0xF2000000, 0xEF000000, 0xEB000000, 0xE6000000, 0xE2000000, 0xDC000000, 0xD8000000, 0xD5000000, 0xD3000000, 0xD3000000, 0xD5000000, 0xD9000000, 0xDE000000, 0xE4000000, 0xEA000000, 0xF0000000, 0xF5000000, 
        0xF9000000, 0xFC000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0042E4B3, 0x002B8669, 0x00229A7E, 0x002EE1AD, 0x0022786F, 0x002B545D, 0x0022757D, 0x0027B498, 0x002EE1AD, 0x0046D69A, 0x002EE1AD, 0x002EE1AD, 0x002EE1AD, 0x002EE1AD, 0x002EE1AD, 0x0042E4B3, 0x002EE4BA, 
        0x002EE4BA, 0x002EE4BA, 0x002EE4BA, 0x002EE1AD, 0x002BC98C, 0x00277D62, 0x00226760, 0x0022A474, 0x002BAF7D, 0x0022A474, 0x002EC3AC, 0x002EE4C8, 0x0046D69A, 0x002B8669, 0x0022786F, 0x002B8669, 0x0035A48F, 0x002EE4C8, 0x002EE6D4, 0x002EE6D4, 
        0x0146C3A8, 0x0022384C, 0x04274655, 0x00225459, 0x002B545D, 0x01223D4C, 0x00222248, 0x004A4062, 0x00B6A7AC, 0x00787283, 0x00C6BEC2, 0x00485263, 0x00224060, 0x01273250, 0x00223D5A, 0x00224060, 0x0022384C, 0x00223D5A, 0x0022384C, 0x01273250, 
        0x00223D5A, 0x00223D5A, 0x00224060, 0x00225565, 0x002B545D, 0x00225565, 0x0027154C, 0x00787283, 0x00485263, 0x00948490, 0x00449582, 0x0022786F, 0x00276B62, 0x00226760, 0x00274057, 0x00225A6F, 0x00225A6F, 0x00225A6F, 0x00226D89, 0x00225A6F, 
        0x01273250, 0x00225A6F, 0x00225A6F, 0x0027154C, 0x00224060, 0x01273250, 0x00222248, 0x00225A6F, 0x00485263, 0x1B2B3B55, 0x79000000, 0x85000000, 0x95000000, 0xA4000000, 0xB1000000, 0xBB000000, 0xC0000000, 0xC0000000, 0x3422384A, 0x1515153D, 
        0x001C0046, 0x0027154C, 0x00225565, 0x0040818E, 0x00227575, 0x01273250, 0x0027154C, 0x0027154C, 0x001C0046, 0x00223D66, 0x00222248, 0x001C005A, 0x00225A6F, 0x004A4062, 0x00225A6F, 0x8B224040, 0xEB000000, 0xED000000, 0xEE000000, 0xEF000000, 
        0xEF000000, 0xEE000000, 0xEC000000, 0xE9000000, 0xE5000000, 0xDF000000, 0xD9000000, 0xD3000000, 0xCC000000, 0xC8000000, 0xC3000000, 0xC1000000, 0xC1000000, 0xC4000000, 0xC9000000, 0xD0000000, 0xD8000000, 0xE2000000, 0xE9000000, 0xF0000000, 
        0xF5000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0027B498, 0x0046D69A, 0x00427B7F, 0x002EE1AD, 0x002BA485, 0x0027B498, 0x0027D297, 0x002EE1AD, 0x002EE4BA, 0x002EE4BA, 0x0042E4B3, 0x0042E4B3, 0x0042E4B3, 0x004CEAC9, 0x002EE4BA, 0x002EE4BA, 0x002EE4BA, 
        0x002EE4BA, 0x004CEAC9, 0x002EE4BA, 0x002EE4BA, 0x002EE1AD, 0x002B8669, 0x00225459, 0x002B8669, 0x0022A474, 0x0022A474, 0x0035A48F, 0x002EE4BA, 0x002EE1AD, 0x002BA485, 0x0022786F, 0x002B8669, 0x002EC3B9, 0x002EE4C8, 0x002EE4C8, 0x004CEAC9, 
        0x00276B62, 0x00274057, 0x002B545D, 0x00225459, 0x00356762, 0x00225459, 0x011C2B48, 0x004A4062, 0x00C6BEC2, 0x006D627D, 0x00948490, 0x002B545D, 0x002E3255, 0x00274057, 0x00223D5A, 0x002B545D, 0x00274057, 0x00223D5A, 0x00274057, 0x00274057, 
        0x002E3255, 0x00223D66, 0x00274057, 0x00225565, 0x00225565, 0x00225565, 0x01273250, 0x004A4062, 0x00485263, 0x004A4062, 0x00948490, 0x00427B7F, 0x0022786F, 0x00226760, 0x00225459, 0x00225A6F, 0x00225A6F, 0x00223D66, 0x00225A6F, 0x0022757D, 
        0x00222248, 0x00223D66, 0x0022757D, 0x01273250, 0x01273250, 0x011C2B48, 0x00222248, 0x3422384A, 0x62000000, 0x69000000, 0x73000000, 0x7D000000, 0x8B000000, 0x98000000, 0xA2000015, 0xAB000015, 0xAF000015, 0xAF000015, 0xAB000015, 0xA7000015, 
        0x00274057, 0x011C2B48, 0x002E3255, 0x00227575, 0x0040818E, 0x00227575, 0x1B2B3B55, 0x3422384A, 0x3422384A, 0x3422384A, 0x00485263, 0x00427B7F, 0x2D447278, 0x8B224040, 0xD6000000, 0xDA000000, 0xDE000000, 0xE2000000, 0xE3000000, 0xE4000000, 
        0xE4000000, 0xE3000000, 0xE0000000, 0xDC000000, 0xD8000000, 0xD0000000, 0xC9000000, 0xC1000000, 0xBB000000, 0xB5000000, 0xB1000000, 0xAE000000, 0xAE000000, 0xB1000000, 0xB9000000, 0xC1000000, 0xCB000000, 0xD6000000, 0xE0000000, 0xEA000000, 
        0xF1000000, 0xF7000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x00226760, 0x002EB1A3, 0x002EE4BA, 0x002EE4BA, 0x002EE1AD, 0x0022A474, 0x00277D62, 0x00356762, 0x003B7E72, 0x0035C397, 0x002EE1AD, 0x005FE4B6, 0x0042E4B3, 0x0042E4B3, 0x002EE4BA, 0x002EE4BA, 0x0042E4B3, 
        0x0042E4B3, 0x0042E4B3, 0x002EE4BA, 0x0042E4B3, 0x002EE1AD, 0x002BAF7D, 0x00277D62, 0x04274655, 0x00229A7E, 0x0022A474, 0x00229A7E, 0x002EE4BA, 0x005FE4B6, 0x0027D297, 0x00277D62, 0x00449582, 0x002EE4C8, 0x002EE4C8, 0x002EE4C8, 0x0046B497, 
        0x01223D4C, 0x00225459, 0x00225459, 0x00225459, 0x00225459, 0x0022384C, 0x00150040, 0x00383B5F, 0x00B6A7AC, 0x00575970, 0x00787283, 0x04274655, 0x0022384C, 0x00274057, 0x00274057, 0x002B545D, 0x00224060, 0x01273250, 0x0027154C, 0x00222248, 
        0x00222248, 0x00223D5A, 0x00224060, 0x00225A6F, 0x002B545D, 0x002E3255, 0x00225A6F, 0x01273250, 0x004A4062, 0x00383B5F, 0x00948490, 0x00226760, 0x00226760, 0x00226760, 0x002B545D, 0x00225A6F, 0x00225A6F, 0x0027154C, 0x00223D66, 0x00224060, 
        0x00220042, 0x0022757D, 0x00227575, 0x0022384C, 0x04274655, 0x37001535, 0x59000000, 0x5C000000, 0x5F000000, 0x65000000, 0x6C000000, 0x75000000, 0x80000000, 0x8B000000, 0x94001515, 0x9A000015, 0x9E000015, 0x9E000015, 0x9A000015, 0x94001C15, 
        0x57000000, 0x1B2B3B55, 0x001C0046, 0x002E3255, 0x00383B5F, 0x00226D89, 0x003D5783, 0x2D447278, 0x94001C15, 0x9E000015, 0xA7000015, 0xAF000015, 0xB7000000, 0xBD000000, 0xC4000000, 0xCB000000, 0xCE000000, 0xD3000000, 0xD3000000, 0xD5000000, 
        0xD5000000, 0xD3000000, 0xD0000000, 0xCC000000, 0xC6000000, 0xC0000000, 0xB7000000, 0xAF000015, 0xA7000015, 0xA2000015, 0x9E000015, 0x9A000015, 0x9C000000, 0xA1000000, 0xA7000015, 0xB3000015, 0xBD000000, 0xCB000000, 0xD8000000, 0xE3000000, 
        0xED000000, 0xF4000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x011C2B48, 0x0035A48F, 0x002EE1AD, 0x002EE1AD, 0x0046D69A, 0x002BA485, 0x0035C397, 0x0027D297, 0x002BA485, 0x002B8669, 0x00225459, 0x00225459, 0x00226760, 0x003B7E72, 0x00449582, 0x00229A7E, 0x004CAE84, 
        0x004CAE84, 0x002BAF7D, 0x002BA485, 0x00229A7E, 0x00229A7E, 0x00277D62, 0x00225459, 0x01223D4C, 0x00225459, 0x0022A474, 0x002B8669, 0x002EC3AC, 0x005FE4B6, 0x002BC98C, 0x00276B62, 0x0035A48F, 0x002EE4BA, 0x002EE4BA, 0x002EE4BA, 0x01223D4C, 
        0x01223D4C, 0x00225459, 0x04274655, 0x04274655, 0x00274057, 0x011C2B48, 0x00220040, 0x004A4062, 0x00948490, 0x00787283, 0x00948490, 0x003B7E72, 0x00225459, 0x00274057, 0x0022384C, 0x01273250, 0x0027154C, 0x00220040, 0x001C0046, 0x02221C46, 
        0x00220040, 0x002E3255, 0x00223D66, 0x00225565, 0x00225565, 0x00356762, 0x00224060, 0x002B545D, 0x00383B5F, 0x00383B5F, 0x00787283, 0x00225565, 0x00227575, 0x00427B7F, 0x002B545D, 0x00224060, 0x00225A6F, 0x011C2B48, 0x001C005A, 0x0027154C, 
        0x001C003B, 0x0027154C, 0x0022384C, 0x04274655, 0x58000000, 0x58000000, 0x59000000, 0x5B000000, 0x5D000000, 0x62000000, 0x67000000, 0x6E000000, 0x75000000, 0x7F001515, 0x85000000, 0x8B001515, 0x8B001515, 0x8B001515, 0x8B001515, 0x81001C15, 
        0x81001C15, 0x7A000015, 0x1B2B3B55, 0x002E3255, 0x00383B5F, 0x00223D66, 0x00383B5F, 0x003D5783, 0x0040818E, 0x8B001515, 0x94001C15, 0x9E000015, 0xA4000015, 0xAB000015, 0xB1000000, 0xB7000000, 0xBB000000, 0xC0000000, 0xC3000000, 0xC3000000, 
        0xC3000000, 0xC3000000, 0xBD000000, 0xBB000000, 0xB3000015, 0xAB000000, 0xA4000015, 0x9C000000, 0x94001515, 0x90000015, 0x8B001515, 0x8B001515, 0x8E000000, 0x90000015, 0x9A000015, 0xA4000015, 0xB3000015, 0xC0000000, 0xCE000000, 0xDC000000, 
        0xE8000000, 0xF1000000, 0xF7000000, 0xFB000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x00226760, 0x0046D69A, 0x003BBA87, 0x0022B180, 0x0046D69A, 0x01223D4C, 0x00226760, 0x0022B180, 0x002EE1AD, 0x002EE1AD, 0x0146C3A8, 0x0022A474, 0x002B8669, 0x00226760, 0x01223D4C, 0x04274655, 0x00226760, 
        0x0022786F, 0x002B8669, 0x002B8669, 0x00277D62, 0x00277D62, 0x00277D62, 0x00225459, 0x011C2B48, 0x001C003D, 0x00225459, 0x002B8669, 0x0022A489, 0x0042E4B3, 0x00277D62, 0x00226760, 0x002EC3AC, 0x002EE4BA, 0x002EC3B9, 0x00226760, 0x0022384C, 
        0x01223D4C, 0x04274655, 0x01223D4C, 0x04274655, 0x00356762, 0x00356762, 0x00427B7F, 0x0035A48F, 0x0378C6BE, 0x0378C6BE, 0x005FE4B6, 0x0146C3A8, 0x0046B497, 0x0035A48F, 0x00449582, 0x002B545D, 0x01273250, 0x01273250, 0x002B545D, 0x00224060, 
        0x0022384C, 0x00222248, 0x0027154C, 0x00225565, 0x00225A6F, 0x00225A6F, 0x00224060, 0x00225A6F, 0x0022384C, 0x0027154C, 0x01273250, 0x00225565, 0x00225565, 0x0022757D, 0x011C2B48, 0x00223D66, 0x00223D66, 0x00222248, 0x001C0038, 0x0027154C, 
        0x001C153B, 0x00220042, 0x1515153D, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x5A000000, 0x5C000000, 0x5F000000, 0x63000000, 0x69000000, 0x6E000000, 0x74000015, 0x79000000, 0x7A000015, 0x7F001515, 0x7A000015, 0x7A000015, 0x74000015, 
        0x74000015, 0x70000015, 0x68001515, 0x37001535, 0x1B2B3B55, 0x04274655, 0x002B545D, 0x01273250, 0x00225A6F, 0x0040818E, 0x81001C15, 0x8B001515, 0x94001C15, 0x98000000, 0x9E000015, 0xA2000015, 0xA7000000, 0xAB000000, 0xAE000000, 0xAF000015, 
        0xAF000015, 0xAE000000, 0xAB000000, 0xA7000015, 0xA1000000, 0x9A000015, 0x94001515, 0x8B001515, 0x85000000, 0x81000015, 0x7F001515, 0x7F001515, 0x81000015, 0x88000015, 0x90000015, 0x9A000015, 0xA7000015, 0xB9000000, 0xC8000000, 0xD8000000, 
        0xE4000000, 0xEE000000, 0xF5000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002BAF7D, 0x002EE1AD, 0x00276B62, 0x00276B62, 0x0046B497, 0x002BC98C, 0x011C2B48, 0x01223D4C, 0x002B8669, 0x0022B180, 0x002EC3AC, 0x004CEAC9, 0x005FE4B6, 0x0146C3A8, 0x0027B498, 0x0022A474, 0x002BAF7D, 
        0x002BAF7D, 0x0022A474, 0x002BAF7D, 0x002BAF7D, 0x002BAF7D, 0x002BAF7D, 0x0022B180, 0x002BAF7D, 0x002B8669, 0x01223D4C, 0x00274057, 0x00229A7E, 0x002EC3B9, 0x00277D62, 0x0022757D, 0x002EC3B9, 0x002EB1A3, 0x00225459, 0x011C2B48, 0x00356762, 
        0x00449582, 0x0046B497, 0x0146C3A8, 0x005FE4B6, 0x005FE4B6, 0x005FE4B6, 0x005FE4B6, 0x005FE4B6, 0x0042E4B3, 0x0042E4B3, 0x0042E4B3, 0x0042E4B3, 0x0042E4B3, 0x0042E4B3, 0x004CEAC9, 0x004CEAC9, 0x005FE4B6, 0x0146C3A8, 0x0050A689, 0x00356762, 
        0x00223D5A, 0x01273250, 0x0027154C, 0x00223D5A, 0x00225A6F, 0x003D5783, 0x00223D5A, 0x00225A6F, 0x002B545D, 0x001C0046, 0x00222248, 0x00224060, 0x002B545D, 0x00225A6F, 0x011C3B4A, 0x00220042, 0x01223D4C, 0x001C0035, 0x001C0035, 0x001C003D, 
        0x02221C46, 0x0015003D, 0x1515153D, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5C000000, 0x5F000000, 0x62000000, 0x66000000, 0x6A000000, 0x6C000000, 0x70000015, 0x70000015, 0x70000015, 0x6E000000, 0x6C000000, 
        0x68001515, 0x68001515, 0x65000000, 0x6200001C, 0x6200001C, 0x6200001C, 0x37001535, 0x00485263, 0x00223D5A, 0x00225A6F, 0x0040818E, 0x2D447278, 0x81001C15, 0x85000000, 0x8B001515, 0x8E000000, 0x94001515, 0x98000000, 0x98000000, 0x9C000000, 
        0x9C000000, 0x98000000, 0x98000000, 0x94001515, 0x8E000000, 0x88000015, 0x83000000, 0x7F001515, 0x7A000015, 0x7A000015, 0x79000000, 0x7A000015, 0x7F001515, 0x83000000, 0x8B001515, 0x95000015, 0xA4000015, 0xB3000015, 0xC4000000, 0xD3000000, 
        0xE2000000, 0xEC000000, 0xF4000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0022BC83, 0x0042E4B3, 0x00225459, 0x00225459, 0x002B8669, 0x002EE1AD, 0x0022A474, 0x00222248, 0x00225459, 0x00229A7E, 0x00229A7E, 0x0035C397, 0x0042E4B3, 0x004CEAC9, 0x006DEDD4, 0x005FE4B6, 0x0035C397, 
        0x0022A474, 0x0022A474, 0x0022A474, 0x002BAF7D, 0x002BAF7D, 0x002BAF7D, 0x0022B180, 0x002BAF7D, 0x002BAF7D, 0x0022A474, 0x00226760, 0x00276B62, 0x0146C3A8, 0x002BAF7D, 0x0027B498, 0x0035A48F, 0x004C9987, 0x0046B497, 0x0146C3A8, 0x005FE4B6, 
        0x005FE4B6, 0x005FE4B6, 0x005FE4B6, 0x0042E4B3, 0x002EE1AD, 0x002EE1AD, 0x002EE1AD, 0x0046D69A, 0x0046D69A, 0x0046D69A, 0x0046D69A, 0x0046D69A, 0x0046D69A, 0x0046D69A, 0x0046D69A, 0x002EE1AD, 0x002EE1AD, 0x0042E4B3, 0x004CEAC9, 0x005FE4B6, 
        0x0146C3A8, 0x003B7E72, 0x0022384C, 0x01273250, 0x00225565, 0x00225A6F, 0x0022384C, 0x00224060, 0x00225A6F, 0x01273250, 0x001C0046, 0x01273250, 0x00223D5A, 0x01273250, 0x011C2B48, 0x001C003B, 0x001C153B, 0x001C0035, 0x001C0038, 0x001C0038, 
        0x0027154C, 0x001C003B, 0x37001535, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5C000000, 0x5F000000, 0x62000000, 0x63000000, 0x65000000, 0x66000000, 0x68001515, 0x68001515, 0x68001515, 0x68001515, 
        0x65000000, 0x63000000, 0x62000000, 0x62000000, 0x62000000, 0x63000000, 0x65000000, 0x68001515, 0x00274057, 0x00223D5A, 0x0040818E, 0x0040818E, 0x002287AD, 0x79000000, 0x7A000015, 0x7F001515, 0x83000000, 0x85000000, 0x88000000, 0x88000000, 
        0x88000000, 0x88000000, 0x85000000, 0x83000000, 0x7F001515, 0x7D000000, 0x7A000015, 0x79000000, 0x75000000, 0x75000000, 0x79000000, 0x7A000015, 0x7F001515, 0x85000000, 0x8B001515, 0x98000000, 0xA4000015, 0xB3000015, 0xC3000000, 0xD3000000, 
        0xDF000000, 0xEB000000, 0xF3000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0027D297, 0x004CEAC9, 0x0027B498, 0x00226760, 0x002B8669, 0x0035C397, 0x005FE4B6, 0x00276B62, 0x001C003D, 0x00226760, 0x0022A474, 0x0022A474, 0x002BA485, 0x0027D297, 0x0042E4B3, 0x004CEAC9, 0x004CEAC9, 
        0x004CEAC9, 0x002BC98C, 0x0027D297, 0x0027D297, 0x0027CA7E, 0x0027CA7E, 0x0027CA7E, 0x0027CA7E, 0x0027CA7E, 0x0022BC83, 0x0022BC83, 0x0022B180, 0x0046D69A, 0x0042E4B3, 0x0042E4B3, 0x005FE4B6, 0x005FE4B6, 0x0046B497, 0x004CAE84, 0x004CAE84, 
        0x002BAF7D, 0x002BAF7D, 0x002BAF7D, 0x002BAF7D, 0x0022A474, 0x0022A474, 0x0022A474, 0x00229A7E, 0x00229A7E, 0x00229A7E, 0x00229A7E, 0x002B8669, 0x00229A7E, 0x00229A7E, 0x00229A7E, 0x002BA485, 0x002BA485, 0x003BBA87, 0x0035C397, 0x0046D69A, 
        0x002EE1AD, 0x006DEDD4, 0x0378C6BE, 0x003B7E72, 0x00225A6F, 0x0022757D, 0x00274057, 0x001C005A, 0x00225565, 0x001C0046, 0x00220035, 0x0022003D, 0x001C153B, 0x0015003D, 0x011C2B48, 0x00150035, 0x001C003B, 0x00150035, 0x001C003B, 0x00150035, 
        0x001C0046, 0x001C003D, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5D000000, 0x5F000000, 0x60000000, 0x62000000, 0x62000000, 0x63000000, 0x63000000, 0x63000000, 
        0x65000000, 0x65000000, 0x65000000, 0x65000000, 0x65000000, 0x66000000, 0x68001515, 0x68001515, 0x68001515, 0x00223D66, 0x00356762, 0x00225565, 0x00224060, 0x002276A3, 0x70000015, 0x73000000, 0x74000015, 0x75000000, 0x79000000, 0x79000000, 
        0x7A000015, 0x7A000015, 0x7A000015, 0x79000000, 0x75000000, 0x74000015, 0x74000015, 0x74000015, 0x75000000, 0x79000000, 0x7D000000, 0x81000015, 0x88000015, 0x8B001515, 0x94001515, 0x9E000015, 0xAB000015, 0xB7000000, 0xC4000000, 0xD3000000, 
        0xE0000000, 0xEB000000, 0xF3000000, 0xF8000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EE1AD, 0x004CEAC9, 0x0027D297, 0x002B8669, 0x00277D62, 0x00229A7E, 0x0046D69A, 0x005FE4B6, 0x01223D4C, 0x00225459, 0x002B8669, 0x002BA485, 0x002BAF7D, 0x00229A7E, 0x0027B498, 0x002EE1AD, 0x0042E4B3, 
        0x004CEAC9, 0x006DEDD4, 0x0042E4B3, 0x0022BC83, 0x0027CA7E, 0x0022BC83, 0x002B8669, 0x00226760, 0x011C3B4A, 0x011C3B4A, 0x00226760, 0x005FE4B6, 0x002EE4BA, 0x002EE4BA, 0x0027D297, 0x0035C397, 0x0035C397, 0x00276B62, 0x011C2B48, 0x00220042, 
        0x0022384C, 0x002B545D, 0x002B8669, 0x00229A7E, 0x0022A474, 0x0022A474, 0x0022A474, 0x002BAF7D, 0x002BAF7D, 0x0022A474, 0x00229A7E, 0x00229A7E, 0x0022A474, 0x0022A474, 0x0022A474, 0x002BAF7D, 0x0022B180, 0x0022B180, 0x002BAF7D, 0x0022A474, 
        0x00229A7E, 0x0022A489, 0x0035C397, 0x005FE4B6, 0x0146C3A8, 0x00276B62, 0x001C003D, 0x001C0046, 0x00225565, 0x001C003B, 0x001C0038, 0x001C0038, 0x001C003D, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C0035, 0x001C0046, 0x001C003D, 
        0x001C003D, 0x002B0048, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5C000000, 0x5D000000, 0x5F000000, 0x60000000, 0x62000000, 0x65000000, 0x65000000, 
        0x67000000, 0x69000000, 0x6A000000, 0x6C000000, 0x6C000000, 0x6C000000, 0x6E000000, 0x6E000000, 0x6E000000, 0x6C000000, 0x19222250, 0x04274655, 0x00274057, 0x00224060, 0x002287AD, 0x6A000000, 0x6C000000, 0x6C000000, 0x6E000000, 0x70000000, 
        0x70000015, 0x70000015, 0x70000015, 0x70000015, 0x73000000, 0x74000015, 0x74000015, 0x79000000, 0x7A000015, 0x81000015, 0x85000000, 0x8E000000, 0x94001515, 0x9A000015, 0xA2000015, 0xAB000015, 0xB3000015, 0xC0000000, 0xCB000000, 0xD8000000, 
        0xE3000000, 0xEC000000, 0xF4000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002EE4BA, 0x005FE4B6, 0x0027B498, 0x0022A474, 0x00277D62, 0x002B8669, 0x0035C397, 0x0042E4B3, 0x0046D69A, 0x00276B62, 0x00225459, 0x002B8669, 0x0022B180, 0x0022B180, 0x0022A474, 0x002BA485, 0x0027D297, 
        0x002EE1AD, 0x0042E4B3, 0x004CEAC9, 0x005FE4B6, 0x00229A7E, 0x011C3B4A, 0x01223D4C, 0x00225459, 0x00276B62, 0x0022A474, 0x0046D69A, 0x0027D297, 0x00427B7F, 0x002EC3AC, 0x0046D69A, 0x00225459, 0x00276B62, 0x0046B497, 0x0146C3A8, 0x0046B497, 
        0x003B7E72, 0x01223D4C, 0x011C2B48, 0x01223D4C, 0x00225459, 0x00277D62, 0x002B8669, 0x00229A7E, 0x0022A474, 0x002BAF7D, 0x0022A474, 0x0022A474, 0x002BAF7D, 0x002BAF7D, 0x0022B180, 0x003BBA87, 0x002BC98C, 0x0035C397, 0x002BC98C, 0x0035C397, 
        0x0035C397, 0x003BBA87, 0x0022B180, 0x0022B180, 0x0027B498, 0x0146C3A8, 0x004CAE84, 0x01223D4C, 0x011C2B48, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C0038, 0x00150035, 0x001C0035, 0x001C0035, 0x001C003D, 0x0027154C, 0x001C0046, 
        0x00150038, 0x0027154C, 0x19222250, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x59000000, 0x5A000000, 0x5C000000, 0x5D000000, 0x5F000000, 0x62000000, 0x65000000, 0x69000000, 0x6C000000, 
        0x70000000, 0x73000000, 0x74000015, 0x79000000, 0x79000000, 0x79000000, 0x79000000, 0x79000000, 0x79000000, 0x75000000, 0x73000000, 0x70000000, 0x37001535, 0x00274057, 0x00226D89, 0x2D447278, 0x67000000, 0x67000000, 0x68001515, 0x6A000000, 
        0x6C000000, 0x6C000000, 0x6E000000, 0x70000015, 0x74000015, 0x75000000, 0x7A000015, 0x81000015, 0x85000000, 0x8E000000, 0x95000015, 0x9E000015, 0xA4000015, 0xAB000015, 0xB3000015, 0xB9000000, 0xC0000000, 0xC9000000, 0xD3000000, 0xDD000000, 
        0xE7000000, 0xEF000000, 0xF5000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x004CEAC9, 0x0046D69A, 0x0022A474, 0x002B8669, 0x00276B62, 0x00277D62, 0x00229A7E, 0x0027D297, 0x005FE4B6, 0x003BBA87, 0x00225459, 0x00225459, 0x00229A7E, 0x0022BC83, 0x0022BC83, 0x003BBA87, 0x002BA485, 
        0x0022B180, 0x0046D69A, 0x002EE1AD, 0x0042E4B3, 0x006DEDD4, 0x0035C397, 0x0022786F, 0x002BC98C, 0x0046D69A, 0x0046D69A, 0x002EE1AD, 0x0022A474, 0x011C2B48, 0x00226760, 0x0046B497, 0x0046D69A, 0x0022384C, 0x00225459, 0x0022A474, 0x002BAF7D, 
        0x0146C3A8, 0x005FE4B6, 0x0378C6BE, 0x0050A689, 0x00225459, 0x011C2B48, 0x00274057, 0x00225459, 0x00225459, 0x00276B62, 0x00276B62, 0x00276B62, 0x003B7E72, 0x002B8669, 0x002B8669, 0x00229A7E, 0x002B8669, 0x002B8669, 0x00229A7E, 0x00229A7E, 
        0x00229A7E, 0x00229A7E, 0x002BA485, 0x0022B180, 0x0022B180, 0x0022B180, 0x0035C397, 0x0146C3A8, 0x002B8669, 0x001C0038, 0x001C0038, 0x001C003B, 0x001C0035, 0x001C0038, 0x001C003B, 0x001C0038, 0x001C003D, 0x001C005A, 0x001C005A, 0x0027154C, 
        0x001C0035, 0x001C0046, 0x19222250, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5D000000, 0x60000000, 0x63000000, 0x67000000, 0x6C000000, 0x70000000, 0x75000000, 
        0x7A000015, 0x80000000, 0x83000000, 0x85000000, 0x88000000, 0x88000000, 0x88000000, 0x88000000, 0x85000000, 0x83000000, 0x7D000000, 0x79000000, 0x73000000, 0x3422384A, 0x00224060, 0x0040818E, 0x67000000, 0x67000000, 0x68001515, 0x68001515, 
        0x6C000000, 0x6E000000, 0x70000015, 0x74000015, 0x7A000015, 0x7F001515, 0x85000000, 0x8E000000, 0x95000015, 0x9E000015, 0xA7000015, 0xAF000015, 0xB6000000, 0xBD000000, 0xC3000000, 0xC9000000, 0xCE000000, 0xD5000000, 0xDD000000, 0xE4000000, 
        0xEC000000, 0xF2000000, 0xF7000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x006DEDD4, 0x0035C397, 0x002B8669, 0x002B8669, 0x00276B62, 0x00277D62, 0x002B8669, 0x0022BC83, 0x0046D69A, 0x004CEAC9, 0x0022A474, 0x00226760, 0x00225459, 0x0022A474, 0x002BC98C, 0x0022BC83, 0x003BBA87, 
        0x0022B180, 0x002BA485, 0x0027D297, 0x002EE1AD, 0x002EE1AD, 0x004CEAC9, 0x0046D69A, 0x002BAF7D, 0x002BC98C, 0x002EE1AD, 0x0042E4B3, 0x00226760, 0x011C3B4A, 0x0022384C, 0x002B8669, 0x005FE4B6, 0x0050A689, 0x01223D4C, 0x00226760, 0x00229A7E, 
        0x0022A474, 0x002BA485, 0x0146C3A8, 0x005FE4B6, 0x005FE4B6, 0x0378C6BE, 0x0050A689, 0x00356762, 0x01223D4C, 0x00224060, 0x00226760, 0x00274057, 0x002B545D, 0x002B545D, 0x00274057, 0x002B545D, 0x00223D5A, 0x00224060, 0x002B545D, 0x00274057, 
        0x00225565, 0x002B545D, 0x0022384C, 0x0022384C, 0x01223D4C, 0x002B545D, 0x0022786F, 0x00229A7E, 0x0046B497, 0x00277D62, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C003B, 0x001C0038, 0x00150040, 0x001C005A, 0x001C0066, 0x001C005A, 0x0027154C, 
        0x001C0038, 0x001C003D, 0x19222250, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5B000000, 0x5D000000, 0x60000000, 0x65000000, 0x69000000, 0x70000000, 0x75000000, 0x7D000000, 0x83000000, 
        0x8B000000, 0x90000015, 0x95000000, 0x98000000, 0x9C000000, 0x9C000000, 0x9C000000, 0x9A000015, 0x98000000, 0x91000000, 0x8B000000, 0x85000000, 0x80000000, 0x79000000, 0x3422384A, 0x292E675C, 0x6C000000, 0x6A000000, 0x6C000000, 0x6C000000, 
        0x70000015, 0x74000015, 0x7A000015, 0x7F001515, 0x83000000, 0x8B001515, 0x94001515, 0x9C000000, 0xA7000015, 0xAF000015, 0xB9000000, 0xC1000000, 0xC8000000, 0xCE000000, 0xD3000000, 0xD8000000, 0xDC000000, 0xE2000000, 0xE6000000, 0xEC000000, 
        0xF1000000, 0xF5000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x006DEDD4, 0x0022A474, 0x00225459, 0x002B8669, 0x00277D62, 0x002B8669, 0x002B8669, 0x0022A474, 0x002BC98C, 0x0042E4B3, 0x005FE4B6, 0x002B8669, 0x00225459, 0x00226760, 0x0022B180, 0x002BC98C, 0x0035C397, 
        0x003BBA87, 0x0022B180, 0x002BA485, 0x002BC98C, 0x0046D69A, 0x002EE1AD, 0x005FE4B6, 0x0046D69A, 0x003BBA87, 0x0042E4B3, 0x002BC98C, 0x04274655, 0x011C2B48, 0x00222248, 0x00277D62, 0x0035A48F, 0x005FE4B6, 0x00277D62, 0x0022384C, 0x00276B62, 
        0x002B8669, 0x002B8669, 0x00229A7E, 0x002BA485, 0x0046B497, 0x0146C3A8, 0x0378C6BE, 0x005FE4B6, 0x0050A689, 0x00226760, 0x00225A6F, 0x00225459, 0x00225565, 0x00225565, 0x00274057, 0x00225A6F, 0x00224060, 0x00274057, 0x00223D5A, 0x00225565, 
        0x00225A6F, 0x00225A6F, 0x00223D5A, 0x001C003B, 0x001C0038, 0x001C003B, 0x001C0038, 0x00220040, 0x00223D5A, 0x0022786F, 0x011C2B48, 0x001C003B, 0x001C003B, 0x001C003D, 0x00150040, 0x001C005A, 0x001C0066, 0x001C0066, 0x001C0066, 0x0027154C, 
        0x00150035, 0x00150035, 0x004A4062, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5D000000, 0x60000000, 0x65000000, 0x6C000000, 0x73000000, 0x7A000015, 0x83000000, 0x8B000000, 0x95000000, 
        0x9C000000, 0xA4000000, 0xA7000000, 0xAE000000, 0xB1000000, 0xB1000000, 0xB1000000, 0xAE000000, 0xAB000000, 0xA4000000, 0x9E000015, 0x95000000, 0x8E000000, 0x85000000, 0x7F001515, 0x79000000, 0x74000015, 0x74000015, 0x74000015, 0x74000015, 
        0x74000015, 0x7A000015, 0x81000015, 0x88000015, 0x90000015, 0x9A000015, 0xA2000015, 0xAE000000, 0xB7000000, 0xC1000000, 0xCB000000, 0xD3000000, 0xD8000000, 0xDD000000, 0xE2000000, 0xE5000000, 0xE8000000, 0xEB000000, 0xEE000000, 0xF2000000, 
        0xF5000000, 0xF9000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x006DEDD4, 0x00276B62, 0x00220042, 0x01223D4C, 0x00277D62, 0x002B8669, 0x002B8669, 0x002B8669, 0x0022BC83, 0x0027D297, 0x004CEAC9, 0x002BC98C, 0x011C3B4A, 0x001C0038, 0x002B545D, 0x0022B180, 0x002BC98C, 
        0x0035C397, 0x0027B498, 0x0027B498, 0x002BA485, 0x0022BC83, 0x0027D297, 0x0046D69A, 0x005FE4B6, 0x002EE1AD, 0x003BBA87, 0x00276B62, 0x00274057, 0x01223D4C, 0x00222248, 0x00276B62, 0x0022786F, 0x0046D69A, 0x005FE4B6, 0x01223D4C, 0x01223D4C, 
        0x00277D62, 0x002B8669, 0x0022A474, 0x0022A474, 0x002B8669, 0x0022A474, 0x003BBA87, 0x0035C397, 0x005FE4B6, 0x005FE4B6, 0x0050A689, 0x00356762, 0x002B545D, 0x00274057, 0x00225565, 0x00274057, 0x00225565, 0x00224060, 0x04274655, 0x00223D5A, 
        0x00274057, 0x002E3255, 0x00223D5A, 0x011C2B48, 0x00220042, 0x00220042, 0x001C003D, 0x001C003B, 0x001C0038, 0x001C003B, 0x001C003D, 0x001C003B, 0x00220042, 0x0027154C, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x0027154C, 
        0x00150035, 0x001C0035, 0x001C005A, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5C000000, 0x5F000000, 0x65000000, 0x6C000000, 0x73000000, 0x7D000000, 0x88000000, 0x91000000, 0x9C000000, 0xA7000000, 
        0xAF000015, 0xB6000000, 0xBB000000, 0xC1000000, 0xC4000000, 0xC4000000, 0xC4000000, 0xC3000000, 0xBD000000, 0xB9000000, 0xB1000000, 0xA7000000, 0x9E000015, 0x95000000, 0x8B001515, 0x85000000, 0x81000015, 0x7A000015, 0x7A000015, 0x7F001515, 
        0x81001C15, 0x88000015, 0x90000015, 0x94001C15, 0x9E000015, 0xA7000015, 0xB3000015, 0xBD000000, 0xC8000000, 0xD0000000, 0xD9000000, 0xE0000000, 0xE5000000, 0xEA000000, 0xED000000, 0xEF000000, 0xF1000000, 0xF3000000, 0xF5000000, 0xF7000000, 
        0xF9000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x005FE4B6, 0x01223D4C, 0x00220042, 0x001C0046, 0x00277D62, 0x00277D62, 0x002B8669, 0x002B8669, 0x00229A7E, 0x0035C397, 0x0146C3A8, 0x005FE4B6, 0x002B8669, 0x011C3B4A, 0x011C2B48, 0x00225459, 0x002BA485, 
        0x0027D297, 0x0035C397, 0x0027B498, 0x0027B498, 0x002BA485, 0x0022B180, 0x002BC98C, 0x0027D297, 0x0042E4B3, 0x0046D69A, 0x00226760, 0x0022384C, 0x0022384C, 0x011C2B48, 0x00276B62, 0x00277D62, 0x00229A7E, 0x005FE4B6, 0x0046D69A, 0x00225459, 
        0x00225459, 0x00226760, 0x002B8669, 0x0022A474, 0x002BAF7D, 0x0022A474, 0x00229A7E, 0x0022A474, 0x0022B180, 0x0035C397, 0x005FE4B6, 0x005FE4B6, 0x00449582, 0x002B545D, 0x00274057, 0x01273250, 0x00274057, 0x0022384C, 0x00274057, 0x00222248, 
        0x00222248, 0x0027154C, 0x01273250, 0x002E3255, 0x00220040, 0x001C0046, 0x0027154C, 0x0027154C, 0x0027154C, 0x001C005A, 0x001C005A, 0x001C005A, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x0027154C, 
        0x001C0038, 0x0015002E, 0x00220042, 0x3422384A, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x59000000, 0x5B000000, 0x5F000000, 0x63000000, 0x69000000, 0x73000000, 0x7D000000, 0x88000000, 0x95000000, 0xA2000015, 0xAE000000, 0xB9000000, 
        0xC3000000, 0xC9000000, 0xCE000000, 0xD3000000, 0xD6000000, 0xD8000000, 0xD6000000, 0xD3000000, 0xD0000000, 0xCB000000, 0xC3000000, 0xBB000000, 0xB1000000, 0xA7000000, 0x9E000015, 0x95000015, 0x8E000000, 0x8B001515, 0x88000015, 0x8B001515, 
        0x8B001515, 0x94001C15, 0x9A000015, 0xA2000015, 0xAB000015, 0xB6000000, 0xC1000000, 0xCB000000, 0xD5000000, 0xDD000000, 0xE4000000, 0xEA000000, 0xEF000000, 0xF2000000, 0xF4000000, 0xF6000000, 0xF7000000, 0xF8000000, 0xF9000000, 0xFB000000, 
        0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0046D69A, 0x002B8669, 0x001C0046, 0x01223D4C, 0x0022A474, 0x002B8669, 0x002B8669, 0x002B8669, 0x002B8669, 0x0027B498, 0x0027B498, 0x0146C3A8, 0x0046D69A, 0x00276B62, 0x00225459, 0x0022384C, 0x00274057, 
        0x00229A7E, 0x0035C397, 0x0035C397, 0x0027B498, 0x0027B498, 0x0027B498, 0x00229A7E, 0x0022BC83, 0x002BC98C, 0x0046D69A, 0x005FE4B6, 0x00225459, 0x00225459, 0x002B545D, 0x00225459, 0x002B8669, 0x00276B62, 0x002BC98C, 0x005FE4B6, 0x004CAE84, 
        0x002B545D, 0x00356762, 0x00225459, 0x002B8669, 0x0022A474, 0x0022A474, 0x0022A474, 0x0022A474, 0x002B8669, 0x0022A474, 0x0022B180, 0x0035C397, 0x005FE4B6, 0x0046B497, 0x011C3B4A, 0x00220042, 0x001C003B, 0x001C0046, 0x00220042, 0x00220042, 
        0x00222248, 0x0022384C, 0x00485263, 0x01223D4C, 0x00222248, 0x001C003D, 0x001C0046, 0x001C005A, 0x001C005A, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C005A, 0x0027154C, 
        0x001C003D, 0x0015002E, 0x001C003B, 0x19222250, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x5A000000, 0x5C000000, 0x60000000, 0x66000000, 0x70000000, 0x7A000015, 0x88000000, 0x95000000, 0xA4000000, 0xB1000000, 0xC0000000, 0xC9000000, 
        0xD3000000, 0xD9000000, 0xDF000000, 0xE2000000, 0xE4000000, 0xE5000000, 0xE5000000, 0xE3000000, 0xE0000000, 0xDA000000, 0xD3000000, 0xCC000000, 0xC3000000, 0xB9000000, 0xAF000015, 0xA7000015, 0x9E000015, 0x9A000015, 0x95000015, 0x94001C15, 
        0x95000015, 0x9E000015, 0xA2000015, 0xAB000015, 0xB5000000, 0xC0000000, 0xCB000000, 0xD5000000, 0xDE000000, 0xE6000000, 0xED000000, 0xF2000000, 0xF5000000, 0xF8000000, 0xFA000000, 0xFB000000, 0xFB000000, 0xFC000000, 0xFC000000, 0xFD000000, 
        0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x0022A474, 0x0035A48F, 0x0022786F, 0x00276B62, 0x002BAF7D, 0x0022BC83, 0x002B8669, 0x002B8669, 0x002B8669, 0x00229A7E, 0x0022B180, 0x002BA485, 0x0046B497, 0x00229A7E, 0x00276B62, 0x00226760, 0x00276B62, 
        0x00276B62, 0x003B7E72, 0x0035C397, 0x0035C397, 0x0027B498, 0x0027B498, 0x0027B498, 0x00229A7E, 0x0022B180, 0x002BC98C, 0x0146C3A8, 0x0046D69A, 0x04274655, 0x00274057, 0x00225459, 0x002B8669, 0x00276B62, 0x00229A7E, 0x0046D69A, 0x005FE4B6, 
        0x00277D62, 0x57000000, 0x37001535, 0x04274655, 0x00277D62, 0x0022A474, 0x0022A474, 0x0022A474, 0x0022A474, 0x0022A474, 0x00229A7E, 0x0022B180, 0x0035C397, 0x0046D69A, 0x0046D69A, 0x00225459, 0x1515153D, 0x1515153D, 0x1515153D, 0x1515153D, 
        0x3422384A, 0x57000000, 0x57000000, 0x57000000, 0x04274655, 0x00220040, 0x00220040, 0x0027154C, 0x001C005A, 0x001C005A, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C005A, 0x001C0046, 
        0x0022003D, 0x001C0035, 0x001C0035, 0x002E3255, 0x57000000, 0x57000000, 0x58000000, 0x59000000, 0x5A000000, 0x5D000000, 0x62000000, 0x6A000000, 0x74000015, 0x81000015, 0x91000000, 0xA1000000, 0xB1000000, 0xC0000000, 0xCD000000, 0xD8000000, 
        0xE0000000, 0xE6000000, 0xEB000000, 0xEE000000, 0xEF000000, 0xF0000000, 0xF0000000, 0xEE000000, 0xEB000000, 0xE7000000, 0xE2000000, 0xDA000000, 0xD3000000, 0xC9000000, 0xC0000000, 0xB7000000, 0xAF000015, 0xA7000015, 0xA4000015, 0xA2000015, 
        0xA2000015, 0xA4000015, 0xAB000015, 0xB3000015, 0xBB000000, 0xC6000000, 0xD0000000, 0xDB000000, 0xE4000000, 0xEC000000, 0xF2000000, 0xF6000000, 0xF9000000, 0xFB000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002B8669, 0x002EB1A3, 0x002EC3AC, 0x00229A7E, 0x0027CA7E, 0x0022A474, 0x00276B62, 0x002B8669, 0x002B8669, 0x003B7E72, 0x0022A489, 0x00229A7E, 0x002B8669, 0x002B8669, 0x00226760, 0x00277D62, 0x0022BC83, 
        0x002BAF7D, 0x00226760, 0x0022786F, 0x0022B180, 0x0035C397, 0x0035C397, 0x0027B498, 0x0035A48F, 0x00229A7E, 0x002BA485, 0x0022BC83, 0x0146C3A8, 0x003BBA87, 0x011C3B4A, 0x00274057, 0x002B8669, 0x00277D62, 0x00276B62, 0x002BC98C, 0x0046D69A, 
        0x0046D69A, 0x3422384A, 0x57000000, 0x57000000, 0x04274655, 0x00276B62, 0x002B8669, 0x0022A474, 0x0022A474, 0x0022A474, 0x0022A474, 0x00229A7E, 0x002BAF7D, 0x0035C397, 0x0046D69A, 0x0046D69A, 0x292E675C, 0x57000000, 0x57000000, 0x57000000, 
        0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x37001535, 0x011C2B48, 0x001C0038, 0x001C0046, 0x001C005A, 0x001C005A, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x0027154C, 0x001C003D, 
        0x001C003D, 0x00220040, 0x001C0035, 0x001C003D, 0x3422384A, 0x57000000, 0x58000000, 0x59000000, 0x5B000000, 0x5F000000, 0x65000000, 0x6C000000, 0x79000000, 0x88000000, 0x98000000, 0xAB000000, 0xBB000000, 0xCC000000, 0xD9000000, 0xE3000000, 
        0xEA000000, 0xF0000000, 0xF3000000, 0xF5000000, 0xF7000000, 0xF7000000, 0xF7000000, 0xF6000000, 0xF4000000, 0xF0000000, 0xEC000000, 0xE7000000, 0xE0000000, 0xD8000000, 0xD0000000, 0xC8000000, 0xC0000000, 0xB9000000, 0xB3000015, 0xAF000015, 
        0xAF000015, 0xAF000015, 0xB3000015, 0xB9000000, 0xC0000000, 0xC9000000, 0xD3000000, 0xDD000000, 0xE6000000, 0xEE000000, 0xF4000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x003B7E72, 0x002EB1A3, 0x002EC3AC, 0x003BBA87, 0x0022A474, 0x0022384C, 0x00225459, 0x002B8669, 0x00229A7E, 0x002B8669, 0x002B8669, 0x00277D62, 0x00276B62, 0x00276B62, 0x00226760, 0x002BAF7D, 0x0027CA7E, 
        0x0027CA7E, 0x0022A474, 0x00226760, 0x00226760, 0x0022A489, 0x0035C397, 0x0035C397, 0x0027B498, 0x0027B498, 0x002BA485, 0x002BA485, 0x003BBA87, 0x0146C3A8, 0x0022A474, 0x011C2B48, 0x002B8669, 0x002B8669, 0x00277D62, 0x00229A7E, 0x0027D297, 
        0x005FE4B6, 0x0022A474, 0x57000000, 0x57000000, 0x57000000, 0x37001535, 0x00225459, 0x002B8669, 0x0022A474, 0x0022A474, 0x0022A474, 0x0022A474, 0x00229A7E, 0x002BA485, 0x0035C397, 0x0042E4B3, 0x0146C3A8, 0x292E675C, 0x57000000, 0x57000000, 
        0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x37001535, 0x001C003D, 0x001C0038, 0x001C0046, 0x0027154C, 0x001C005A, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C0066, 0x001C005A, 0x001C0046, 0x001C003B, 
        0x001C003D, 0x00220042, 0x0015002E, 0x00150035, 0x19222250, 0x57000000, 0x58000000, 0x59000000, 0x5B000000, 0x5F000000, 0x66000000, 0x70000000, 0x7D000000, 0x8E000000, 0xA1000000, 0xB3000015, 0xC4000000, 0xD3000000, 0xE2000000, 0xEB000000, 
        0xF1000000, 0xF6000000, 0xF9000000, 0xFA000000, 0xFB000000, 0xFB000000, 0xFB000000, 0xFA000000, 0xF9000000, 0xF7000000, 0xF4000000, 0xF0000000, 0xEB000000, 0xE5000000, 0xDE000000, 0xD8000000, 0xD0000000, 0xC9000000, 0xC3000000, 0xBD000000, 
        0xBB000000, 0xB9000000, 0xB9000000, 0xBB000000, 0xC3000000, 0xCB000000, 0xD3000000, 0xDD000000, 0xE6000000, 0xEE000000, 0xF4000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x00277D62, 0x002EB1A3, 0x002EC3AC, 0x002EC3B9, 0x002B8669, 0x02221C46, 0x011C2B48, 0x00276B62, 0x002B8669, 0x002B8669, 0x00276B62, 0x00356762, 0x00225459, 0x00225459, 0x002BAF7D, 0x0027CA7E, 0x0027CA7E, 
        0x0027D297, 0x0042E4B3, 0x002BC98C, 0x00276B62, 0x002B8669, 0x0022786F, 0x00229A7E, 0x0146C3A8, 0x002EC3AC, 0x002EC3AC, 0x0027B498, 0x00229A7E, 0x0022B180, 0x0035C397, 0x0022A474, 0x00277D62, 0x002B8669, 0x002B8669, 0x002B8669, 0x0035C397, 
        0x0027D297, 0x005FE4B6, 0x292E675C, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x37001535, 0x00225459, 0x002B8669, 0x0022A474, 0x0022A474, 0x0022A474, 0x0022A474, 0x00229A7E, 0x0035C397, 0x002EE4BA, 0x0046D69A, 0x292E675C, 0x57000000, 
        0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x1515153D, 0x001C003B, 0x001C0035, 0x001C003B, 0x00220042, 0x0027154C, 0x001C005A, 0x001C005A, 0x001C005A, 0x001C005A, 0x0027154C, 0x001C0046, 0x001C003D, 0x001C0038, 
        0x001C0038, 0x00220042, 0x001C003B, 0x001C0035, 0x002E3255, 0x57000000, 0x58000000, 0x59000000, 0x5C000000, 0x60000000, 0x67000000, 0x73000000, 0x80000000, 0x91000000, 0xA4000000, 0xB9000000, 0xCB000000, 0xDA000000, 0xE7000000, 0xF0000000, 
        0xF6000000, 0xFA000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFB000000, 0xF9000000, 0xF6000000, 0xF3000000, 0xEE000000, 0xE9000000, 0xE4000000, 0xDE000000, 0xD8000000, 0xD0000000, 0xCB000000, 
        0xC4000000, 0xC3000000, 0xC1000000, 0xC3000000, 0xC6000000, 0xCC000000, 0xD3000000, 0xDD000000, 0xE6000000, 0xEE000000, 0xF4000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002B8669, 0x0035A48F, 0x002EE6D4, 0x002EE4C8, 0x0146C3A8, 0x0022384C, 0x0022384C, 0x00274057, 0x002B8669, 0x002B8669, 0x00225459, 0x00225459, 0x01223D4C, 0x00229A7E, 0x0027CA7E, 0x0027CA7E, 0x002EE1AD, 
        0x0042E4B3, 0x004CEAC9, 0x0042E4B3, 0x003BBA87, 0x00449582, 0x011C2B48, 0x011C2B48, 0x00227575, 0x0027B498, 0x002EC3AC, 0x002EC3B9, 0x002EB1A3, 0x00229A7E, 0x0022B180, 0x0035C397, 0x00229A7E, 0x002B8669, 0x002B8669, 0x002B8669, 0x00229A7E, 
        0x0027D297, 0x0046D69A, 0x0035C397, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x19222250, 0x00226760, 0x002B8669, 0x0022A474, 0x0022A474, 0x0022A474, 0x00229A7E, 0x0027B498, 0x002EE4BA, 0x0035C397, 0x3422384A, 
        0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x011C2B48, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C003B, 0x00220042, 0x001C0046, 0x001C0046, 0x001C003B, 0x001C003B, 0x001C0038, 0x001C0038, 
        0x001C0038, 0x001C003D, 0x002B0048, 0x001C0035, 0x00220042, 0x3422384A, 0x58000000, 0x59000000, 0x5C000000, 0x60000000, 0x69000000, 0x73000000, 0x81000015, 0x94001515, 0xA7000000, 0xBB000000, 0xCD000000, 0xDD000000, 0xEA000000, 0xF2000000, 
        0xF8000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFB000000, 0xF8000000, 0xF5000000, 0xF2000000, 0xEE000000, 0xE9000000, 0xE3000000, 0xDD000000, 0xD8000000, 
        0xD0000000, 0xCC000000, 0xC9000000, 0xC9000000, 0xCB000000, 0xCE000000, 0xD6000000, 0xDD000000, 0xE6000000, 0xED000000, 0xF4000000, 0xF8000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002B8669, 0x00229A7E, 0x002EC3B9, 0x002EE4C8, 0x004CEAC9, 0x00225459, 0x0022384C, 0x01273250, 0x00356762, 0x00276B62, 0x002B545D, 0x01223D4C, 0x0022786F, 0x0027CA7E, 0x0027CA7E, 0x0046D69A, 0x002EE4BA, 
        0x004CEAC9, 0x004CEAC9, 0x006DEDD4, 0x0050A689, 0x37001535, 0x57000000, 0x57000000, 0x011C3B4A, 0x00225459, 0x00427B7F, 0x002EC3AC, 0x002EC3B9, 0x002EC3AC, 0x002BA485, 0x002BA485, 0x0035C397, 0x0022A474, 0x002B8669, 0x002B8669, 0x00277D62, 
        0x0027B498, 0x0027D297, 0x005FE4B6, 0x292E675C, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x1B2B3B55, 0x00276B62, 0x002BA485, 0x002BAF7D, 0x002BAF7D, 0x0022A474, 0x0027B498, 0x002EE4BA, 0x0022A474, 
        0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x37001535, 0x00220040, 0x001C0038, 0x001C0038, 0x001C0035, 0x001C0035, 0x00220035, 0x001C0035, 0x001C003B, 0x001C003B, 0x001C003B, 0x001C0035, 0x001C0038, 
        0x001C003D, 0x001C003D, 0x001C0046, 0x00150035, 0x001C0038, 0x19222250, 0x58000000, 0x59000000, 0x5C000000, 0x60000000, 0x67000000, 0x73000000, 0x81000015, 0x94001515, 0xA7000000, 0xBB000000, 0xCE000000, 0xDE000000, 0xEB000000, 0xF4000000, 
        0xF9000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFA000000, 0xF8000000, 0xF5000000, 0xF1000000, 0xED000000, 0xE7000000, 0xE2000000, 
        0xDC000000, 0xD8000000, 0xD3000000, 0xD0000000, 0xD0000000, 0xD3000000, 0xD9000000, 0xDF000000, 0xE7000000, 0xEE000000, 0xF4000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x002B8669, 0x0022A474, 0x002EB1A3, 0x002EE4C8, 0x002EE4C8, 0x002BA485, 0x0022384C, 0x011C2B48, 0x0022384C, 0x002B545D, 0x01223D4C, 0x00225459, 0x0022BC83, 0x0027CA7E, 0x002EE1AD, 0x002EE4BA, 0x004CEAC9, 
        0x004CEAC9, 0x006DEDD4, 0x004C9987, 0x37001535, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x37001535, 0x02221C46, 0x00225459, 0x00229A7E, 0x002EC3AC, 0x002EE1AD, 0x003BBA87, 0x0022B180, 0x0035C397, 0x0022A474, 0x002B8669, 0x002B8669, 
        0x00229A7E, 0x0035C397, 0x0146C3A8, 0x0046B497, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x59000000, 0x04274655, 0x0022786F, 0x00229A7E, 0x002BAF7D, 0x0022A474, 0x0027B498, 0x002EE1AD, 
        0x002B8669, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x59000000, 0x011C2B48, 0x001C0038, 0x001C003B, 0x001C0035, 0x001C0038, 0x001C0035, 0x001C0035, 0x001C0035, 0x001C003B, 0x001C0038, 0x001C0035, 0x001C003D, 
        0x001C0038, 0x001C003D, 0x00220042, 0x001C003B, 0x0015002E, 0x00383B5F, 0x58000000, 0x59000000, 0x5B000000, 0x60000000, 0x67000000, 0x70000000, 0x80000000, 0x91000000, 0xA4000000, 0xBB000000, 0xCD000000, 0xDE000000, 0xEA000000, 0xF3000000, 
        0xF9000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xF9000000, 0xF7000000, 0xF4000000, 0xF0000000, 0xEB000000, 
        0xE6000000, 0xE2000000, 0xDD000000, 0xDA000000, 0xD9000000, 0xDA000000, 0xDE000000, 0xE3000000, 0xE9000000, 0xEF000000, 0xF4000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x00229A7E, 0x002BAF7D, 0x00229A7E, 0x002EC3B9, 0x002EE4C8, 0x0146C3A8, 0x0022384C, 0x011C2B48, 0x011C2B48, 0x0022384C, 0x0022384C, 0x0022A474, 0x0027CA7E, 0x002EE1AD, 0x002EE4BA, 0x004CEAC9, 0x006DEDD4, 
        0x005FE4B6, 0x003B7E72, 0x37001535, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x37001535, 0x011C2B48, 0x002B545D, 0x00229A7E, 0x0146C3A8, 0x0027D297, 0x0022BC83, 0x002BC98C, 0x00229A7E, 0x002B8669, 
        0x002B8669, 0x0035C397, 0x0035C397, 0x005FE4B6, 0x1B2B3B55, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5A000000, 0x5B000000, 0x37001535, 0x00226760, 0x002B8669, 0x002BAF7D, 0x0022A474, 0x0035C397, 
        0x0035C397, 0x3422384A, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5A000000, 0x5C000000, 0x011C2B48, 0x001C0038, 0x0022003D, 0x001C0038, 0x001C0038, 0x001C0038, 0x00220035, 0x001C003B, 0x001C003B, 0x001C0038, 0x001C003D, 
        0x00220040, 0x001C003D, 0x00220042, 0x00220042, 0x00150035, 0x001C0046, 0x3422384A, 0x59000000, 0x5B000000, 0x5F000000, 0x66000000, 0x70000000, 0x7D000000, 0x8E000000, 0xA4000000, 0xB7000000, 0xCB000000, 0xDC000000, 0xE9000000, 0xF2000000, 
        0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFB000000, 0xF8000000, 0xF6000000, 0xF2000000, 
        0xEE000000, 0xEA000000, 0xE6000000, 0xE3000000, 0xE2000000, 0xE2000000, 0xE4000000, 0xE8000000, 0xEC000000, 0xF1000000, 0xF6000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x00229A7E, 0x0022BC83, 0x002BAF7D, 0x002EB1A3, 0x002EC3B9, 0x005FE4B6, 0x04274655, 0x01273250, 0x0022384C, 0x00274057, 0x0022A474, 0x0027CA7E, 0x0042E4B3, 0x0042E4B3, 0x006DEDD4, 0x006DEDD4, 0x006DEDD4, 
        0x00276B62, 0x5A000000, 0x58000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x37001535, 0x011C2B48, 0x00274057, 0x003B7E72, 0x003BBA87, 0x0022BC83, 0x0022BC83, 0x00229A7E, 
        0x002B8669, 0x002BA485, 0x0035C397, 0x002EC3B9, 0x003BBA87, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5C000000, 0x5D000000, 0x5F000000, 0x5F000000, 0x37001535, 0x00276B62, 0x0022A474, 0x0022A474, 
        0x0035C397, 0x0022B180, 0x59000000, 0x59000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5D000000, 0x5F000000, 0x1515153D, 0x001C003B, 0x001C003D, 0x001C0038, 0x001C003D, 0x001C0038, 0x00150035, 0x001C0035, 0x00150040, 0x001C0038, 0x00220040, 
        0x001C003D, 0x0022003D, 0x001C003B, 0x001C0046, 0x001C0035, 0x00150038, 0x19222250, 0x59000000, 0x5B000000, 0x5F000000, 0x65000000, 0x6E000000, 0x7A000015, 0x8B000000, 0x9E000015, 0xB5000000, 0xC8000000, 0xD9000000, 0xE7000000, 0xF1000000, 
        0xF8000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFA000000, 0xF7000000, 
        0xF4000000, 0xF1000000, 0xEE000000, 0xEC000000, 0xEA000000, 0xEA000000, 0xEB000000, 0xED000000, 0xF1000000, 0xF4000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x00226760, 0x0022B180, 0x002BAF7D, 0x0027B498, 0x002EE4C8, 0x002EE4C8, 0x00225459, 0x0022384C, 0x0022384C, 0x00276B62, 0x0027CA7E, 0x002EE1AD, 0x004CEAC9, 0x006DEDD4, 0x004CEAC9, 0x002EE4BA, 0x004CEAC9, 
        0x003BBA87, 0x5A000000, 0x58000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x37001535, 0x02221C46, 0x00225459, 0x002B8669, 0x0022A474, 0x003BBA87, 
        0x00449582, 0x003B7E72, 0x0027B498, 0x002EB1A3, 0x0146C3A8, 0x37001535, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5D000000, 0x5F000000, 0x62000000, 0x62000000, 0x62000000, 0x62000000, 0x62000000, 0x292E675C, 0x00229A7E, 
        0x0022A474, 0x0035C397, 0x00277D62, 0x5A000000, 0x5A000000, 0x5B000000, 0x5D000000, 0x60000000, 0x63000000, 0x67000000, 0x02221C46, 0x001C0038, 0x00220042, 0x0015003D, 0x001C0038, 0x001C0035, 0x00150035, 0x001C003D, 0x001C003D, 0x0022003D, 
        0x001C003D, 0x001C003D, 0x001C003B, 0x001C0046, 0x0022003D, 0x001C003B, 0x00223D5A, 0x58000000, 0x5A000000, 0x5D000000, 0x63000000, 0x6C000000, 0x79000000, 0x88000000, 0x9C000000, 0xB1000000, 0xC3000000, 0xD5000000, 0xE4000000, 0xEF000000, 
        0xF6000000, 0xFB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFB000000, 
        0xF9000000, 0xF7000000, 0xF5000000, 0xF3000000, 0xF1000000, 0xF1000000, 0xF1000000, 0xF3000000, 0xF5000000, 0xF7000000, 0xFA000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0x8B224040, 0x00229A7E, 0x0022BC83, 0x002BA485, 0x002EC3B9, 0x002EE4C8, 0x00277D62, 0x0022384C, 0x00274057, 0x0022A474, 0x002EE1AD, 0x004CEAC9, 0x006DEDD4, 0x005FE4B6, 0x0027B498, 0x002EC3AC, 0x0042E4B3, 
        0x005FE4B6, 0x5A000000, 0x58000000, 0x57000000, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x1515153D, 0x01223D4C, 0x00276B62, 
        0x00229A7E, 0x0022786F, 0x0035A48F, 0x002EB1A3, 0x002EC3B9, 0x292E675C, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5D000000, 0x60000000, 0x63000000, 0x65000000, 0x67000000, 0x68001515, 0x68001515, 0x67000000, 0x65000000, 0x3422384A, 
        0x00229A7E, 0x0022B180, 0x002BA485, 0x3422384A, 0x5D000000, 0x5F000000, 0x60000000, 0x65000000, 0x68001515, 0x6E000000, 0x74000015, 0x001C153B, 0x001C003B, 0x001C0038, 0x001C0038, 0x00220035, 0x001C0035, 0x001C0038, 0x001C003D, 0x0022003D, 
        0x0015003D, 0x00220042, 0x001C003D, 0x001C0046, 0x002B0048, 0x001C0035, 0x001C0046, 0x3422384A, 0x5A000000, 0x5D000000, 0x62000000, 0x6A000000, 0x75000000, 0x83000000, 0x98000000, 0xAB000000, 0xC0000000, 0xD0000000, 0xE0000000, 0xEC000000, 
        0xF5000000, 0xFA000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 
        0xFC000000, 0xFB000000, 0xF9000000, 0xF8000000, 0xF7000000, 0xF6000000, 0xF6000000, 0xF7000000, 0xF8000000, 0xFA000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0x0022786F, 0x0022BC83, 0x0022A474, 0x002EC3B9, 0x002EE4C8, 0x00277D62, 0x0022384C, 0x00276B62, 0x0027D297, 0x004CEAC9, 0x004CEAC9, 0x0050A689, 0x0027B498, 0x0027B498, 0x0027B498, 0x002EE4BA, 
        0x006DEDD4, 0x292E675C, 0x58000000, 0x57000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x59000000, 0x5A000000, 0x5A000000, 0x5A000000, 0x00274057, 0x00356762, 
        0x00276B62, 0x002B8669, 0x0040818E, 0x002EB1A3, 0x002EB1A3, 0x002B8669, 0x58000000, 0x59000000, 0x5A000000, 0x5C000000, 0x5F000000, 0x63000000, 0x68001515, 0x6C000000, 0x6E000000, 0x70000015, 0x70000015, 0x70000015, 0x6C000000, 0x6A000000, 
        0x1B2B3B55, 0x00229A7E, 0x003BBA87, 0x00276B62, 0x60000000, 0x62000000, 0x65000000, 0x68001515, 0x70000015, 0x75000000, 0x7D000000, 0x02221C46, 0x001C0038, 0x001C003D, 0x001C0038, 0x001C0035, 0x001C0038, 0x001C0035, 0x001C003D, 0x001C0046, 
        0x001C003D, 0x001C003D, 0x00150040, 0x00220040, 0x001C0046, 0x001C0038, 0x001C003D, 0x19222250, 0x59000000, 0x5C000000, 0x60000000, 0x67000000, 0x73000000, 0x80000000, 0x91000000, 0xA4000000, 0xB9000000, 0xCC000000, 0xDC000000, 0xE9000000, 
        0xF3000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 
        0xFE000000, 0xFD000000, 0xFC000000, 0xFB000000, 0xFB000000, 0xFA000000, 0xFA000000, 0xFB000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0x3422384A, 0x002BAF7D, 0x0022BC83, 0x002EC3AC, 0x002EE4C8, 0x00277D62, 0x04274655, 0x003BBA87, 0x004CEAC9, 0x005FE4B6, 0x00356762, 0x3422384A, 0x0022757D, 0x0027B498, 0x0035A48F, 0x002EC3AC, 
        0x004CEAC9, 0x003BBA87, 0x58000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5B000000, 0x5C000000, 0x5C000000, 0x5D000000, 0x5F000000, 0x37001535, 0x00227575, 
        0x00449582, 0x00449582, 0x0022757D, 0x0035A48F, 0x002EB1A3, 0x004C9987, 0x59000000, 0x59000000, 0x5B000000, 0x5D000000, 0x62000000, 0x66000000, 0x6C000000, 0x70000015, 0x74000015, 0x7A000015, 0x7A000015, 0x7A000015, 0x79000000, 0x74000015, 
        0x70000000, 0x1B2B3B55, 0x00229A7E, 0x0022A474, 0x65000000, 0x66000000, 0x68001515, 0x6E000000, 0x74000015, 0x7F001515, 0x88000015, 0x57000000, 0x001C003D, 0x001C003D, 0x001C003D, 0x001C003B, 0x001C0038, 0x001C0035, 0x00150035, 0x00220042, 
        0x00220042, 0x00220042, 0x00220042, 0x00220042, 0x001C0046, 0x00220042, 0x001C003B, 0x00224060, 0x59000000, 0x5B000000, 0x5F000000, 0x65000000, 0x70000000, 0x7D000000, 0x8B000000, 0xA1000000, 0xB5000000, 0xC8000000, 0xD8000000, 0xE6000000, 
        0xF0000000, 0xF7000000, 0xFB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0x002B8669, 0x0022BC83, 0x0027B498, 0x002EE4C8, 0x00277D62, 0x002B8669, 0x004CEAC9, 0x0046B497, 0x04274655, 0xB6000000, 0xA1000000, 0x57000000, 0x00276B62, 0x0022B180, 0x0035A48F, 
        0x002EE1AD, 0x0146C3A8, 0x58000000, 0x57000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5C000000, 0x5D000000, 0x5F000000, 0x62000000, 0x62000000, 0x63000000, 0x63000000, 0x00225565, 
        0x00229A7E, 0x00449582, 0x0022786F, 0x00449582, 0x002EB1A3, 0x0046B497, 0x5A000000, 0x5A000000, 0x5B000000, 0x5F000000, 0x62000000, 0x68001515, 0x70000015, 0x75000000, 0x7D000000, 0x81000015, 0x85000000, 0x85000000, 0x83000000, 0x81000015, 
        0x7D000000, 0x79000000, 0x37001535, 0x00229A7E, 0x6C000000, 0x6C000000, 0x6E000000, 0x74000015, 0x7D000000, 0x85000000, 0x90000015, 0x9A000015, 0x5C000000, 0x001C153B, 0x00220040, 0x0022003D, 0x001C0035, 0x001C0038, 0x001C0035, 0x00220040, 
        0x00150040, 0x00220042, 0x00150040, 0x001C0046, 0x001C0046, 0x00220042, 0x001C003B, 0x001C0046, 0x3422384A, 0x5A000000, 0x5F000000, 0x63000000, 0x6C000000, 0x79000000, 0x88000000, 0x9A000015, 0xAE000000, 0xC1000000, 0xD3000000, 0xE2000000, 
        0xED000000, 0xF5000000, 0xFA000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0x00226760, 0x0022BC83, 0x0027B498, 0x002EE4BA, 0x00276B62, 0x0035C397, 0x00449582, 0x7F001515, 0xCB000000, 0xB6000000, 0xA1000000, 0x8E000000, 0x37001535, 0x003B7E72, 0x002BA485, 
        0x002EC3AC, 0x005FE4B6, 0x1B2B3B55, 0x58000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5B000000, 0x5C000000, 0x5F000000, 0x62000000, 0x65000000, 0x69000000, 0x6A000000, 0x6C000000, 0x6C000000, 0x37001535, 
        0x0022757D, 0x00229A7E, 0x003B7E72, 0x00449582, 0x002EB1A3, 0x002EB1A3, 0x1B2B3B55, 0x5C000000, 0x5D000000, 0x5F000000, 0x63000000, 0x6A000000, 0x70000015, 0x7A000015, 0x81001C15, 0x8B001515, 0x90000015, 0x91000000, 0x91000000, 0x8E000000, 
        0x8B000000, 0x83000000, 0x7F001515, 0x7A000015, 0x74000015, 0x74000015, 0x74000015, 0x7A000015, 0x81001C15, 0x8B001515, 0x94001C15, 0xA2000015, 0xAB000015, 0x37001535, 0x001C003D, 0x00220042, 0x001C0038, 0x001C0038, 0x00150035, 0x001C0038, 
        0x001C0046, 0x001C0046, 0x001C0046, 0x00150040, 0x001C0046, 0x001C0046, 0x001C003B, 0x001C003B, 0x1B2B3B55, 0x5A000000, 0x5C000000, 0x62000000, 0x69000000, 0x74000015, 0x83000000, 0x95000000, 0xA7000000, 0xBB000000, 0xCD000000, 0xDD000000, 
        0xEA000000, 0xF3000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0x3422384A, 0x002BAF7D, 0x0027B498, 0x002EE1AD, 0x00276B62, 0x003B7E72, 0x88000015, 0xDC000000, 0xCB000000, 0xB6000000, 0xA1000000, 0x8E000000, 0x7D000000, 0x04274655, 0x00229A7E, 
        0x0027B498, 0x004CEAC9, 0x292E675C, 0x58000000, 0x57000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5C000000, 0x60000000, 0x65000000, 0x69000000, 0x6C000000, 0x73000000, 0x75000000, 0x79000000, 0x79000000, 0x75000000, 
        0x00225565, 0x00229A7E, 0x00449582, 0x0040818E, 0x0035A48F, 0x002EB1A3, 0x1B2B3B55, 0x5F000000, 0x5F000000, 0x60000000, 0x65000000, 0x6C000000, 0x74000015, 0x7F001515, 0x88000015, 0x90000015, 0x98000000, 0x9E000015, 0x9E000015, 0x9E000015, 
        0x98000000, 0x95000000, 0x8E000000, 0x85000000, 0x81000015, 0x7F001515, 0x7F001515, 0x81001C15, 0x85000000, 0x90000015, 0x9A000015, 0xA7000015, 0xAF000015, 0xB9000000, 0x02221C46, 0x001C003D, 0x001C003B, 0x001C003B, 0x001C0038, 0x0015002E, 
        0x001C0046, 0x00220042, 0x00220042, 0x001C0046, 0x001C0046, 0x001C0046, 0x001C003B, 0x001C003B, 0x00223D5A, 0x59000000, 0x5B000000, 0x5F000000, 0x66000000, 0x70000000, 0x7D000000, 0x8E000000, 0xA1000000, 0xB5000000, 0xC8000000, 0xD8000000, 
        0xE6000000, 0xF0000000, 0xF7000000, 0xFB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x00229A7E, 0x0035C397, 0x0027D297, 0x1515153D, 0xF3000000, 0xE9000000, 0xDC000000, 0xCB000000, 0xB7000000, 0xA2000015, 0x8E000000, 0x7D000000, 0x6E000000, 0x00225A6F, 
        0x0035A48F, 0x005FE4B6, 0x0022A474, 0x58000000, 0x57000000, 0x58000000, 0x58000000, 0x59000000, 0x5A000000, 0x5C000000, 0x5F000000, 0x65000000, 0x69000000, 0x70000000, 0x79000000, 0x7D000000, 0x83000000, 0x85000000, 0x88000000, 0x85000000, 
        0x57000000, 0x0022757D, 0x00229A7E, 0x0022757D, 0x0035A48F, 0x002EB1A3, 0x292E675C, 0x63000000, 0x62000000, 0x62000000, 0x66000000, 0x6C000000, 0x74000015, 0x7F001515, 0x8B001515, 0x94001C15, 0x9E000015, 0xA7000015, 0xAB000000, 0xAB000000, 
        0xAB000000, 0xA4000000, 0x9C000000, 0x95000000, 0x8E000000, 0x8B001515, 0x88000015, 0x88000015, 0x8B001515, 0x94001C15, 0x9E000015, 0xA7000015, 0xB3000015, 0xBB000000, 0x37001535, 0x001C003D, 0x001C0046, 0x001C003B, 0x001C0038, 0x0015002E, 
        0x001C003D, 0x001C0046, 0x002B0048, 0x001C0046, 0x00220042, 0x00220042, 0x001C0046, 0x001C0038, 0x002E3255, 0x59000000, 0x5A000000, 0x5F000000, 0x63000000, 0x6C000000, 0x79000000, 0x88000000, 0x9A000015, 0xAE000000, 0xC1000000, 0xD3000000, 
        0xE2000000, 0xED000000, 0xF5000000, 0xFA000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x00229A7E, 0x0035C397, 0x002BA485, 0xF9000000, 0xF3000000, 0xE9000000, 0xDC000000, 0xCB000000, 0xB7000000, 0xA2000015, 0x8E000000, 0x7D000000, 0x70000000, 0x37001535, 
        0x0022757D, 0x002EB1A3, 0x004CAE84, 0x58000000, 0x58000000, 0x58000000, 0x58000000, 0x59000000, 0x5B000000, 0x5F000000, 0x62000000, 0x69000000, 0x70000000, 0x7A000015, 0x83000000, 0x8B000000, 0x94001515, 0x98000000, 0x98000000, 0x98000000, 
        0x94001515, 0x04274655, 0x0040818E, 0x0022757D, 0x0035A48F, 0x002EB1A3, 0x292E675C, 0x69000000, 0x67000000, 0x66000000, 0x67000000, 0x6C000000, 0x74000015, 0x7F001515, 0x8B001515, 0x98000000, 0xA2000015, 0xAE000000, 0xB5000000, 0xB9000000, 
        0xB9000000, 0xB5000000, 0xAF000015, 0xA7000000, 0x9E000015, 0x9A000015, 0x94001515, 0x94001C15, 0x94001C15, 0x98000000, 0x9E000015, 0xA7000015, 0xB3000015, 0xBD000000, 0xC4000000, 0x011C2B48, 0x001C003D, 0x001C003D, 0x001C003D, 0x001C0035, 
        0x0015002E, 0x001C003D, 0x001C0046, 0x001C0046, 0x001C0046, 0x00220042, 0x0027154C, 0x001C003D, 0x00150040, 0x3422384A, 0x5A000000, 0x5C000000, 0x62000000, 0x69000000, 0x74000015, 0x83000000, 0x95000000, 0xA7000000, 0xBB000000, 0xCE000000, 
        0xDD000000, 0xEA000000, 0xF3000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x002B8669, 0x0035C397, 0x00225459, 0xF9000000, 0xF3000000, 0xEA000000, 0xDD000000, 0xCC000000, 0xB9000000, 0xA4000000, 0x8E000000, 0x7D000000, 0x70000000, 0x66000000, 
        0x19222250, 0x0035A48F, 0x0046B497, 0x58000000, 0x58000000, 0x59000000, 0x59000000, 0x5B000000, 0x5D000000, 0x62000000, 0x67000000, 0x6E000000, 0x79000000, 0x83000000, 0x90000015, 0x9C000000, 0xA4000000, 0xAB000000, 0xAB000000, 0xAB000000, 
        0xA7000000, 0x9E000015, 0x0022757D, 0x00427B7F, 0x0035A48F, 0x0035A48F, 0x1B2B3B55, 0x73000000, 0x6E000000, 0x6C000000, 0x6C000000, 0x6C000000, 0x74000015, 0x7D000000, 0x88000015, 0x94001C15, 0xA4000015, 0xB1000000, 0xBB000000, 0xC3000000, 
        0xC4000000, 0xC4000000, 0xC0000000, 0xB9000000, 0xB1000000, 0xA7000015, 0xA2000015, 0x9E000015, 0x9C000000, 0x9E000015, 0xA2000015, 0xAB000015, 0xB3000015, 0xBD000000, 0xC4000000, 0x37001535, 0x001C003B, 0x001C003B, 0x001C003D, 0x001C0038, 
        0x001C0035, 0x00150038, 0x001C0046, 0x0027154C, 0x0027154C, 0x00220042, 0x001C0046, 0x001C0046, 0x001C003D, 0x19222250, 0x59000000, 0x5B000000, 0x5F000000, 0x66000000, 0x70000000, 0x7D000000, 0x8E000000, 0xA1000000, 0xB5000000, 0xC8000000, 
        0xD9000000, 0xE6000000, 0xF0000000, 0xF7000000, 0xFB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x00229A7E, 0x002BA485, 0x1515153D, 0xFA000000, 0xF4000000, 0xEB000000, 0xDE000000, 0xCE000000, 0xBB000000, 0xA4000000, 0x91000000, 0x80000000, 0x70000000, 0x67000000, 
        0x60000000, 0x00226D89, 0x0046B497, 0x5A000000, 0x5A000000, 0x5A000000, 0x5B000000, 0x5D000000, 0x60000000, 0x65000000, 0x6C000000, 0x74000015, 0x80000000, 0x8E000000, 0x9C000000, 0xAB000000, 0xB3000015, 0xBB000000, 0xBD000000, 0xBD000000, 
        0xB9000000, 0xB3000015, 0x00227575, 0x00449582, 0x0035A48F, 0x0050A689, 0x88000000, 0x80000000, 0x79000000, 0x73000000, 0x70000000, 0x70000000, 0x74000015, 0x7A000015, 0x85000000, 0x94001C15, 0xA2000015, 0xB3000015, 0xC0000000, 0xC9000000, 
        0xCE000000, 0xD0000000, 0xCE000000, 0xC9000000, 0xC3000000, 0xBB000000, 0xB1000000, 0xAB000000, 0xA7000015, 0xA7000015, 0xA7000015, 0xAB000015, 0xB3000015, 0xBB000000, 0xC4000000, 0xCB000000, 0x1515153D, 0x001C003B, 0x00220042, 0x001C0038, 
        0x001C0038, 0x001C003D, 0x00220042, 0x0027154C, 0x0027154C, 0x00220042, 0x001C0046, 0x0027154C, 0x00220040, 0x1515153D, 0x59000000, 0x5B000000, 0x5F000000, 0x65000000, 0x6C000000, 0x79000000, 0x88000000, 0x9A000015, 0xAE000000, 0xC1000000, 
        0xD3000000, 0xE2000000, 0xED000000, 0xF5000000, 0xFA000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x00229A7E, 0x00276B62, 0xFD000000, 0xFA000000, 0xF5000000, 0xEC000000, 0xE0000000, 0xD0000000, 0xBD000000, 0xA7000000, 0x95000000, 0x83000000, 0x74000015, 0x69000000, 
        0x62000000, 0x19222250, 0x003B7E72, 0x5C000000, 0x5C000000, 0x5F000000, 0x5F000000, 0x62000000, 0x65000000, 0x69000000, 0x70000015, 0x7A000015, 0x88000015, 0x98000000, 0xA7000015, 0xB5000000, 0xC1000000, 0xC9000000, 0xCE000000, 0xCE000000, 
        0xCB000000, 0xC4000000, 0x3422384A, 0x00449582, 0x0035A48F, 0x002B8669, 0x98000000, 0x8E000000, 0x85000000, 0x7D000000, 0x79000000, 0x74000015, 0x74000015, 0x7A000015, 0x83000000, 0x90000015, 0xA2000015, 0xB1000000, 0xC1000000, 0xCD000000, 
        0xD6000000, 0xDA000000, 0xDA000000, 0xD8000000, 0xD0000000, 0xCB000000, 0xC3000000, 0xBB000000, 0xB5000000, 0xB1000000, 0xAF000015, 0xB1000000, 0xB5000000, 0xBB000000, 0xC4000000, 0xCB000000, 0x74000015, 0x001C003B, 0x001C003D, 0x00220040, 
        0x001C0038, 0x001C0046, 0x002B0048, 0x00220042, 0x0027154C, 0x00222248, 0x001C003D, 0x002B0048, 0x001C003D, 0x1515153D, 0x59000000, 0x5A000000, 0x5D000000, 0x62000000, 0x69000000, 0x74000015, 0x83000000, 0x95000000, 0xA7000000, 0xBB000000, 
        0xCE000000, 0xDD000000, 0xEA000000, 0xF3000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x003B7E72, 0x37001535, 0xFD000000, 0xFB000000, 0xF6000000, 0xED000000, 0xE2000000, 0xD3000000, 0xC0000000, 0xAB000000, 0x98000000, 0x85000000, 0x79000000, 0x6C000000, 
        0x65000000, 0x62000000, 0x60000000, 0x60000000, 0x62000000, 0x63000000, 0x65000000, 0x67000000, 0x69000000, 0x6E000000, 0x74000015, 0x81001C15, 0x8E000000, 0x9E000015, 0xAF000015, 0xBD000000, 0xCC000000, 0xD5000000, 0xDB000000, 0xDC000000, 
        0xDA000000, 0xD6000000, 0x3422384A, 0x00449582, 0x0035A48F, 0x292E675C, 0xAB000000, 0x9E000015, 0x95000000, 0x8B000000, 0x81000015, 0x7A000015, 0x79000000, 0x7A000015, 0x83000000, 0x8E000000, 0x9E000015, 0xAF000015, 0xC0000000, 0xCE000000, 
        0xD9000000, 0xE0000000, 0xE3000000, 0xE2000000, 0xDE000000, 0xD8000000, 0xD0000000, 0xCB000000, 0xC3000000, 0xBD000000, 0xB9000000, 0xB9000000, 0xBB000000, 0xBD000000, 0xC4000000, 0xCC000000, 0xD3000000, 0x1515153D, 0x001C003D, 0x00220042, 
        0x001C003B, 0x002B0048, 0x00220042, 0x0027154C, 0x1B2B3B55, 0x04274655, 0x011C3B4A, 0x0022384C, 0x00274057, 0x37001535, 0x5A000000, 0x5A000000, 0x5C000000, 0x5F000000, 0x66000000, 0x70000000, 0x7D000000, 0x8E000000, 0xA1000000, 0xB5000000, 
        0xC8000000, 0xD9000000, 0xE6000000, 0xF0000000, 0xF7000000, 0xFB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0x3422384A, 0xFF000000, 0xFE000000, 0xFB000000, 0xF7000000, 0xEF000000, 0xE5000000, 0xD6000000, 0xC4000000, 0xB1000000, 0x9C000000, 0x8B000000, 0x7A000015, 0x70000000, 
        0x69000000, 0x66000000, 0x65000000, 0x66000000, 0x69000000, 0x6A000000, 0x6C000000, 0x70000000, 0x70000015, 0x74000015, 0x7D000000, 0x85000000, 0x94001C15, 0xA2000015, 0xB5000000, 0xC4000000, 0xD3000000, 0xDD000000, 0xE4000000, 0xE7000000, 
        0xE6000000, 0xE3000000, 0x3422384A, 0x0035A48F, 0x00277D62, 0xC6000000, 0xBB000000, 0xB1000000, 0xA4000000, 0x98000000, 0x8B000000, 0x83000000, 0x7D000000, 0x7D000000, 0x81000015, 0x8B001515, 0x9A000015, 0xAB000000, 0xBD000000, 0xCE000000, 
        0xDB000000, 0xE4000000, 0xE9000000, 0xEA000000, 0xE9000000, 0xE4000000, 0xDE000000, 0xD8000000, 0xD0000000, 0xC9000000, 0xC4000000, 0xC1000000, 0xC1000000, 0xC3000000, 0xC8000000, 0xCE000000, 0xD5000000, 0xD8000000, 0x1515153D, 0x001C003D, 
        0x001C003D, 0x001C0046, 0x01273250, 0x59000000, 0x8B000000, 0x7D000000, 0x70000000, 0x67000000, 0x62000000, 0x5D000000, 0x5A000000, 0x5A000000, 0x5B000000, 0x5F000000, 0x65000000, 0x6C000000, 0x79000000, 0x88000000, 0x9A000015, 0xAE000000, 
        0xC3000000, 0xD3000000, 0xE2000000, 0xED000000, 0xF5000000, 0xFA000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xF8000000, 0xF1000000, 0xE8000000, 0xDA000000, 0xC9000000, 0xB6000000, 0xA4000000, 0x90000015, 0x81000015, 0x75000000, 
        0x70000000, 0x6C000000, 0x6C000000, 0x70000000, 0x73000000, 0x75000000, 0x79000000, 0x7A000015, 0x7D000000, 0x7F001515, 0x81001C15, 0x8B001515, 0x98000000, 0xA7000015, 0xB9000000, 0xC8000000, 0xD8000000, 0xE2000000, 0xEA000000, 0xEE000000, 
        0xEF000000, 0xED000000, 0xEA000000, 0x292E675C, 0xDE000000, 0xD6000000, 0xCC000000, 0xC1000000, 0xB5000000, 0xA7000000, 0x98000000, 0x8E000000, 0x83000000, 0x80000000, 0x83000000, 0x8B001515, 0x98000000, 0xA7000015, 0xBB000000, 0xCC000000, 
        0xDB000000, 0xE6000000, 0xED000000, 0xF0000000, 0xF0000000, 0xEE000000, 0xE9000000, 0xE3000000, 0xDD000000, 0xD6000000, 0xD0000000, 0xCB000000, 0xC9000000, 0xCB000000, 0xCE000000, 0xD3000000, 0xD9000000, 0xDD000000, 0x7F001515, 0x001C0046, 
        0x00222248, 0x37001535, 0x59224244, 0xA7000000, 0x95000000, 0x85000000, 0x79000000, 0x6C000000, 0x65000000, 0x5F000000, 0x5C000000, 0x5A000000, 0x5A000000, 0x5D000000, 0x62000000, 0x69000000, 0x74000015, 0x83000000, 0x95000000, 0xA7000015, 
        0xBB000000, 0xCE000000, 0xDE000000, 0xEA000000, 0xF3000000, 0xF9000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xF9000000, 0xF3000000, 0xEB000000, 0xDE000000, 0xCE000000, 0xBD000000, 0xAB000000, 0x98000000, 0x88000000, 0x7D000000, 
        0x79000000, 0x75000000, 0x75000000, 0x7A000015, 0x80000000, 0x83000000, 0x85000000, 0x88000000, 0x88000000, 0x88000015, 0x8B001515, 0x94001C15, 0x9C000000, 0xA7000015, 0xB9000000, 0xCB000000, 0xD9000000, 0xE5000000, 0xED000000, 0xF2000000, 
        0xF4000000, 0xF4000000, 0xF2000000, 0xEE000000, 0xE9000000, 0xE2000000, 0xDA000000, 0xCE000000, 0xC3000000, 0xB5000000, 0xA4000000, 0x98000000, 0x8B000000, 0x85000000, 0x83000000, 0x88000015, 0x94001515, 0xA4000000, 0xB7000000, 0xC9000000, 
        0xD9000000, 0xE6000000, 0xEF000000, 0xF3000000, 0xF5000000, 0xF4000000, 0xF1000000, 0xED000000, 0xE7000000, 0xE2000000, 0xDB000000, 0xD8000000, 0xD3000000, 0xD3000000, 0xD5000000, 0xD9000000, 0xDE000000, 0xE2000000, 0xE4000000, 0xE2000000, 
        0xDB000000, 0xD0000000, 0xC3000000, 0xB1000000, 0xA1000000, 0x8E000000, 0x80000000, 0x73000000, 0x69000000, 0x62000000, 0x5D000000, 0x5B000000, 0x5A000000, 0x5C000000, 0x60000000, 0x66000000, 0x70000000, 0x7F001515, 0x8E000000, 0xA2000015, 
        0xB5000000, 0xC9000000, 0xD9000000, 0xE7000000, 0xF1000000, 0xF8000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xFA000000, 0xF5000000, 0xEE000000, 0xE3000000, 0xD3000000, 0xC3000000, 0xB1000000, 0x9E000015, 0x90000015, 0x85000000, 
        0x80000000, 0x80000000, 0x83000000, 0x88000000, 0x8E000000, 0x94001515, 0x98000000, 0x98000000, 0x98000000, 0x95000015, 0x95000015, 0x9A000015, 0xA2000015, 0xAB000015, 0xBB000000, 0xCB000000, 0xD9000000, 0xE5000000, 0xEF000000, 0xF5000000, 
        0xF8000000, 0xF9000000, 0xF8000000, 0xF5000000, 0xF2000000, 0xEC000000, 0xE5000000, 0xDB000000, 0xCE000000, 0xC0000000, 0xB1000000, 0xA1000000, 0x95000000, 0x8B001515, 0x88000015, 0x8B001515, 0x94001515, 0xA4000000, 0xB5000000, 0xC8000000, 
        0xD8000000, 0xE5000000, 0xEF000000, 0xF5000000, 0xF8000000, 0xF8000000, 0xF7000000, 0xF4000000, 0xEF000000, 0xEB000000, 0xE6000000, 0xE2000000, 0xDE000000, 0xDD000000, 0xDE000000, 0xE2000000, 0xE4000000, 0xE8000000, 0xE9000000, 0xE8000000, 
        0xE2000000, 0xD9000000, 0xCC000000, 0xBB000000, 0xAB000000, 0x98000000, 0x88000000, 0x7A000015, 0x70000000, 0x66000000, 0x60000000, 0x5C000000, 0x5B000000, 0x5B000000, 0x5F000000, 0x65000000, 0x6C000000, 0x7A000015, 0x88000000, 0x9C000000, 
        0xB1000000, 0xC3000000, 0xD5000000, 0xE4000000, 0xEE000000, 0xF6000000, 0xFB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFB000000, 0xF7000000, 0xF0000000, 0xE7000000, 0xD9000000, 0xCB000000, 0xB9000000, 0xA7000000, 0x9A000015, 0x90000015, 
        0x8B000000, 0x8B000000, 0x91000000, 0x98000000, 0x9E000015, 0xA4000000, 0xA7000000, 0xAB000000, 0xA7000015, 0xA4000015, 0xA2000015, 0xA2000015, 0xA7000015, 0xAF000015, 0xBB000000, 0xCB000000, 0xD9000000, 0xE5000000, 0xEF000000, 0xF6000000, 
        0xF9000000, 0xFB000000, 0xFB000000, 0xFA000000, 0xF7000000, 0xF3000000, 0xED000000, 0xE5000000, 0xDA000000, 0xCC000000, 0xBB000000, 0xAB000000, 0x9E000015, 0x91000000, 0x8B001515, 0x8E000000, 0x94001515, 0xA2000015, 0xB3000015, 0xC4000000, 
        0xD6000000, 0xE4000000, 0xEF000000, 0xF6000000, 0xFA000000, 0xFB000000, 0xFB000000, 0xF8000000, 0xF5000000, 0xF2000000, 0xEE000000, 0xEA000000, 0xE7000000, 0xE6000000, 0xE6000000, 0xE8000000, 0xEB000000, 0xEE000000, 0xEF000000, 0xEE000000, 
        0xE9000000, 0xE2000000, 0xD6000000, 0xC8000000, 0xB6000000, 0xA4000000, 0x94001515, 0x83000000, 0x75000000, 0x6C000000, 0x63000000, 0x5F000000, 0x5C000000, 0x5C000000, 0x5F000000, 0x62000000, 0x6A000000, 0x75000000, 0x85000000, 0x98000000, 
        0xAB000000, 0xC0000000, 0xD0000000, 0xE0000000, 0xEC000000, 0xF5000000, 0xFA000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xF9000000, 0xF3000000, 0xEA000000, 0xDE000000, 0xD0000000, 0xC0000000, 0xB1000000, 0xA4000000, 0x9C000000, 
        0x98000000, 0x9A000015, 0xA1000000, 0xA7000000, 0xB1000000, 0xB7000000, 0xBB000000, 0xBB000000, 0xB9000000, 0xB3000015, 0xAE000000, 0xAB000015, 0xAF000015, 0xB3000015, 0xC0000000, 0xCC000000, 0xD9000000, 0xE5000000, 0xEF000000, 0xF6000000, 
        0xFA000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFB000000, 0xF8000000, 0xF3000000, 0xEC000000, 0xE2000000, 0xD5000000, 0xC6000000, 0xB6000000, 0xA7000015, 0x9A000015, 0x91000000, 0x90000015, 0x98000000, 0xA2000015, 0xB3000015, 0xC4000000, 
        0xD6000000, 0xE4000000, 0xEF000000, 0xF6000000, 0xFA000000, 0xFC000000, 0xFD000000, 0xFC000000, 0xFA000000, 0xF7000000, 0xF4000000, 0xF2000000, 0xEF000000, 0xEE000000, 0xEE000000, 0xEF000000, 0xF1000000, 0xF3000000, 0xF4000000, 0xF3000000, 
        0xEF000000, 0xE8000000, 0xDE000000, 0xD0000000, 0xC1000000, 0xAF000015, 0x9C000000, 0x8B000000, 0x7D000000, 0x70000000, 0x69000000, 0x62000000, 0x5F000000, 0x5D000000, 0x5F000000, 0x62000000, 0x69000000, 0x74000015, 0x83000000, 0x94001515, 
        0xA7000015, 0xBB000000, 0xCD000000, 0xDE000000, 0xEA000000, 0xF3000000, 0xF9000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xFA000000, 0xF5000000, 0xED000000, 0xE3000000, 0xD6000000, 0xC8000000, 0xB9000000, 0xAE000000, 0xA7000000, 
        0xA4000000, 0xA7000000, 0xAF000015, 0xB9000000, 0xC1000000, 0xC8000000, 0xCB000000, 0xCB000000, 0xC8000000, 0xC1000000, 0xBB000000, 0xB7000000, 0xB7000000, 0xBB000000, 0xC3000000, 0xCE000000, 0xDA000000, 0xE6000000, 0xEF000000, 0xF6000000, 
        0xFA000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xF7000000, 0xF1000000, 0xE9000000, 0xDD000000, 0xCE000000, 0xC0000000, 0xB1000000, 0xA2000015, 0x9A000015, 0x98000000, 0x9A000015, 0xA7000015, 0xB5000000, 0xC6000000, 
        0xD6000000, 0xE4000000, 0xEF000000, 0xF6000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFC000000, 0xFB000000, 0xF9000000, 0xF7000000, 0xF5000000, 0xF4000000, 0xF4000000, 0xF5000000, 0xF6000000, 0xF7000000, 0xF8000000, 0xF7000000, 
        0xF4000000, 0xEE000000, 0xE6000000, 0xDA000000, 0xCB000000, 0xBB000000, 0xA7000000, 0x95000000, 0x85000000, 0x79000000, 0x6C000000, 0x65000000, 0x62000000, 0x5F000000, 0x60000000, 0x63000000, 0x6A000000, 0x74000015, 0x81000015, 0x91000000, 
        0xA4000015, 0xB9000000, 0xCB000000, 0xDC000000, 0xE9000000, 0xF2000000, 0xF8000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFB000000, 0xF7000000, 0xF0000000, 0xE7000000, 0xDB000000, 0xCE000000, 0xC3000000, 0xB9000000, 0xB3000015, 
        0xB1000000, 0xB6000000, 0xBD000000, 0xC8000000, 0xD0000000, 0xD6000000, 0xD9000000, 0xD8000000, 0xD5000000, 0xCE000000, 0xC8000000, 0xC3000000, 0xC0000000, 0xC3000000, 0xC9000000, 0xD3000000, 0xDD000000, 0xE7000000, 0xF0000000, 0xF6000000, 
        0xFB000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFA000000, 0xF5000000, 0xEE000000, 0xE4000000, 0xD8000000, 0xC8000000, 0xB9000000, 0xAB000000, 0xA2000015, 0x9E000015, 0xA2000015, 0xAB000015, 0xB9000000, 0xC8000000, 
        0xD8000000, 0xE5000000, 0xEF000000, 0xF7000000, 0xFB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFB000000, 0xFA000000, 0xF9000000, 0xF9000000, 0xF9000000, 0xFA000000, 0xFA000000, 0xFB000000, 0xFA000000, 
        0xF8000000, 0xF3000000, 0xEC000000, 0xE2000000, 0xD3000000, 0xC4000000, 0xB1000000, 0xA1000000, 0x8E000000, 0x80000000, 0x74000015, 0x6C000000, 0x66000000, 0x63000000, 0x65000000, 0x67000000, 0x6C000000, 0x75000000, 0x83000000, 0x94001515, 
        0xA4000015, 0xB9000000, 0xCB000000, 0xDB000000, 0xE8000000, 0xF2000000, 0xF8000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xF8000000, 0xF3000000, 0xEA000000, 0xE2000000, 0xD5000000, 0xCB000000, 0xC3000000, 0xBD000000, 
        0xC0000000, 0xC4000000, 0xCB000000, 0xD3000000, 0xDC000000, 0xE2000000, 0xE4000000, 0xE4000000, 0xE0000000, 0xDA000000, 0xD3000000, 0xCE000000, 0xCB000000, 0xCB000000, 0xD0000000, 0xD8000000, 0xE0000000, 0xE9000000, 0xF1000000, 0xF7000000, 
        0xFB000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xF8000000, 0xF2000000, 0xE9000000, 0xDE000000, 0xD0000000, 0xC3000000, 0xB5000000, 0xAB000015, 0xA7000015, 0xA7000015, 0xAF000015, 0xBD000000, 0xCC000000, 
        0xDA000000, 0xE7000000, 0xF0000000, 0xF7000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFD000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFC000000, 
        0xFA000000, 0xF7000000, 0xF1000000, 0xE8000000, 0xDC000000, 0xCE000000, 0xBD000000, 0xAB000000, 0x9A000015, 0x8B000000, 0x7D000000, 0x73000000, 0x6C000000, 0x6A000000, 0x6C000000, 0x6E000000, 0x73000000, 0x7D000000, 0x88000000, 0x98000000, 
        0xA7000000, 0xBB000000, 0xCC000000, 0xDB000000, 0xE8000000, 0xF2000000, 0xF8000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xF9000000, 0xF5000000, 0xEE000000, 0xE5000000, 0xDC000000, 0xD3000000, 0xCC000000, 0xC9000000, 
        0xCB000000, 0xCE000000, 0xD8000000, 0xDF000000, 0xE6000000, 0xEB000000, 0xED000000, 0xED000000, 0xE9000000, 0xE4000000, 0xDE000000, 0xD9000000, 0xD5000000, 0xD5000000, 0xD8000000, 0xDE000000, 0xE5000000, 0xEC000000, 0xF3000000, 0xF8000000, 
        0xFB000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xFA000000, 0xF5000000, 0xEE000000, 0xE4000000, 0xD8000000, 0xCB000000, 0xC0000000, 0xB5000000, 0xAF000015, 0xB1000000, 0xB9000000, 0xC3000000, 0xD0000000, 
        0xDE000000, 0xE9000000, 0xF2000000, 0xF8000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 
        0xFC000000, 0xF9000000, 0xF5000000, 0xED000000, 0xE3000000, 0xD6000000, 0xC8000000, 0xB6000000, 0xA4000000, 0x95000000, 0x88000000, 0x7D000000, 0x79000000, 0x74000015, 0x75000000, 0x79000000, 0x7D000000, 0x85000000, 0x91000000, 0x9E000015, 
        0xAE000000, 0xC0000000, 0xCE000000, 0xDD000000, 0xE9000000, 0xF2000000, 0xF8000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xFB000000, 0xF7000000, 0xF1000000, 0xEA000000, 0xE2000000, 0xDB000000, 0xD6000000, 0xD3000000, 
        0xD5000000, 0xDA000000, 0xE0000000, 0xE7000000, 0xED000000, 0xF2000000, 0xF3000000, 0xF3000000, 0xF1000000, 0xEC000000, 0xE7000000, 0xE3000000, 0xDF000000, 0xDF000000, 0xE0000000, 0xE5000000, 0xEA000000, 0xF0000000, 0xF5000000, 0xF9000000, 
        0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xF8000000, 0xF2000000, 0xE9000000, 0xDF000000, 0xD3000000, 0xC8000000, 0xC0000000, 0xBB000000, 0xBB000000, 0xC3000000, 0xCB000000, 0xD8000000, 
        0xE2000000, 0xEC000000, 0xF4000000, 0xF9000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFD000000, 0xFB000000, 0xF8000000, 0xF2000000, 0xEA000000, 0xDF000000, 0xD0000000, 0xC3000000, 0xB1000000, 0xA2000015, 0x95000000, 0x8B000000, 0x85000000, 0x83000000, 0x83000000, 0x85000000, 0x8B000000, 0x94001515, 0x9C000000, 0xAB000000, 
        0xB7000000, 0xC6000000, 0xD3000000, 0xE2000000, 0xEC000000, 0xF4000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xF8000000, 0xF4000000, 0xEE000000, 0xE8000000, 0xE3000000, 0xDF000000, 0xDE000000, 
        0xDF000000, 0xE3000000, 0xE9000000, 0xEE000000, 0xF3000000, 0xF7000000, 0xF8000000, 0xF8000000, 0xF6000000, 0xF3000000, 0xEF000000, 0xEB000000, 0xE8000000, 0xE7000000, 0xE8000000, 0xEB000000, 0xEF000000, 0xF4000000, 0xF8000000, 0xFB000000, 
        0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFA000000, 0xF5000000, 0xEE000000, 0xE5000000, 0xDC000000, 0xD3000000, 0xCB000000, 0xC6000000, 0xC8000000, 0xCC000000, 0xD3000000, 0xDE000000, 
        0xE7000000, 0xF0000000, 0xF6000000, 0xFA000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFE000000, 0xFD000000, 0xFA000000, 0xF6000000, 0xEF000000, 0xE6000000, 0xDA000000, 0xCD000000, 0xC0000000, 0xB1000000, 0xA4000000, 0x9C000000, 0x95000000, 0x94001515, 0x94001515, 0x98000000, 0x9C000000, 0xA4000000, 0xAE000000, 0xB7000000, 
        0xC3000000, 0xCE000000, 0xDB000000, 0xE6000000, 0xEF000000, 0xF5000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xFA000000, 0xF7000000, 0xF2000000, 0xEE000000, 0xEA000000, 0xE7000000, 0xE6000000, 
        0xE8000000, 0xEB000000, 0xEF000000, 0xF4000000, 0xF7000000, 0xFA000000, 0xFB000000, 0xFB000000, 0xFA000000, 0xF7000000, 0xF4000000, 0xF2000000, 0xF0000000, 0xEF000000, 0xEF000000, 0xF1000000, 0xF4000000, 0xF7000000, 0xFA000000, 0xFC000000, 
        0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFD000000, 0xFB000000, 0xF7000000, 0xF2000000, 0xEB000000, 0xE3000000, 0xDB000000, 0xD5000000, 0xD3000000, 0xD3000000, 0xD6000000, 0xDD000000, 0xE4000000, 
        0xEC000000, 0xF3000000, 0xF8000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFE000000, 0xFC000000, 0xF9000000, 0xF4000000, 0xEC000000, 0xE3000000, 0xD8000000, 0xCB000000, 0xC0000000, 0xB5000000, 0xAB000000, 0xA7000000, 0xA4000000, 0xA7000000, 0xAB000000, 0xAF000015, 0xB6000000, 0xBD000000, 0xC6000000, 
        0xD0000000, 0xDA000000, 0xE3000000, 0xEB000000, 0xF2000000, 0xF8000000, 0xFB000000, 0xFD000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xF9000000, 0xF6000000, 0xF3000000, 0xF0000000, 0xEE000000, 0xEE000000, 
        0xEF000000, 0xF1000000, 0xF4000000, 0xF8000000, 0xFA000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFC000000, 0xFB000000, 0xF9000000, 0xF7000000, 0xF5000000, 0xF5000000, 0xF5000000, 0xF6000000, 0xF8000000, 0xFA000000, 0xFC000000, 0xFD000000, 
        0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xFA000000, 0xF5000000, 0xF0000000, 0xEA000000, 0xE4000000, 0xDF000000, 0xDD000000, 0xDD000000, 0xE0000000, 0xE5000000, 0xEB000000, 
        0xF1000000, 0xF6000000, 0xFA000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xF7000000, 0xF2000000, 0xEA000000, 0xE2000000, 0xD8000000, 0xCE000000, 0xC4000000, 0xBD000000, 0xBB000000, 0xB9000000, 0xBB000000, 0xBD000000, 0xC3000000, 0xC8000000, 0xCE000000, 0xD5000000, 
        0xDC000000, 0xE4000000, 0xEB000000, 0xF1000000, 0xF6000000, 0xFA000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xF9000000, 0xF7000000, 0xF5000000, 0xF4000000, 0xF4000000, 
        0xF5000000, 0xF6000000, 0xF8000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFA000000, 0xFA000000, 0xF9000000, 0xF9000000, 0xFA000000, 0xFB000000, 0xFC000000, 0xFD000000, 0xFE000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xF8000000, 0xF5000000, 0xF0000000, 0xEC000000, 0xE9000000, 0xE7000000, 0xE7000000, 0xE9000000, 0xED000000, 0xF1000000, 
        0xF5000000, 0xF9000000, 0xFC000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xFA000000, 0xF6000000, 0xF1000000, 0xEA000000, 0xE3000000, 0xDB000000, 0xD3000000, 0xCE000000, 0xCC000000, 0xCB000000, 0xCD000000, 0xD0000000, 0xD3000000, 0xD8000000, 0xDD000000, 0xE2000000, 
        0xE7000000, 0xED000000, 0xF1000000, 0xF6000000, 0xF9000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xFA000000, 0xF9000000, 0xF8000000, 0xF8000000, 
        0xF9000000, 0xFA000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFD000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xF8000000, 0xF5000000, 0xF2000000, 0xF0000000, 0xEF000000, 0xEF000000, 0xF1000000, 0xF3000000, 0xF6000000, 
        0xF9000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFC000000, 0xF9000000, 0xF6000000, 0xF1000000, 0xEC000000, 0xE7000000, 0xE2000000, 0xDE000000, 0xDC000000, 0xDB000000, 0xDD000000, 0xDF000000, 0xE2000000, 0xE6000000, 0xE9000000, 0xED000000, 
        0xF0000000, 0xF3000000, 0xF7000000, 0xF9000000, 0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFC000000, 0xFB000000, 0xFB000000, 
        0xFC000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFB000000, 0xF9000000, 0xF7000000, 0xF6000000, 0xF5000000, 0xF5000000, 0xF6000000, 0xF8000000, 0xFA000000, 
        0xFB000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xF9000000, 0xF7000000, 0xF3000000, 0xF0000000, 0xEC000000, 0xEA000000, 0xE9000000, 0xE8000000, 0xE9000000, 0xEB000000, 0xED000000, 0xF0000000, 0xF2000000, 0xF4000000, 
        0xF7000000, 0xF9000000, 0xFA000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFD000000, 0xFD000000, 
        0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFB000000, 0xFA000000, 0xFA000000, 0xFA000000, 0xFA000000, 0xFB000000, 0xFC000000, 
        0xFD000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFA000000, 0xF8000000, 0xF6000000, 0xF4000000, 0xF3000000, 0xF2000000, 0xF2000000, 0xF3000000, 0xF4000000, 0xF5000000, 0xF7000000, 0xF8000000, 0xFA000000, 
        0xFB000000, 0xFC000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFD000000, 0xFC000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFE000000, 
        0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFC000000, 0xFA000000, 0xF9000000, 0xF9000000, 0xF8000000, 0xF8000000, 0xF9000000, 0xF9000000, 0xFA000000, 0xFB000000, 0xFC000000, 0xFD000000, 
        0xFD000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFD000000, 0xFD000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFC000000, 0xFD000000, 0xFD000000, 0xFE000000, 0xFE000000, 0xFE000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFE000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000,
  0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 0xFF000000, 
        0xFF000000
#endif
};

static GUI_CONST_STORAGE GUI_BITMAP _bmToucan = {
  158, // XSize
  150, // YSize
  632, // BytesPerLine
  32, // BitsPerPixel
  (unsigned char *)_acToucan,  // Pointer to picture data
  NULL, // Pointer to palette
#if (GUI_USE_ARGB == 1)
  GUI_DRAW_BMPM8888I
#else
  GUI_DRAW_BMP8888
#endif
};

static GUI_COLOR _aColor[] = {
  GUI_RED, 
  GUI_GREEN, 
  GUI_BLUE, 
  GUI_MAKE_COLOR(0x4080c0), 
  GUI_WHITE, 
  GUI_BLACK, 
  GUI_YELLOW, 
  GUI_MAGENTA, 
  GUI_CYAN, 
  GUI_MAKE_COLOR(0xc04080)
};

/*********************************************************************
*
*       Static code
*
**********************************************************************
*/
/*********************************************************************
*
*       _FillLayer
*/
static void _FillLayer(int LayerIndex) {
  WM_HWIN hWin;
  int     xSize;
  int     ySize;

  GUI_SelectLayer(LayerIndex);
  WM_SelectWindow(WM_HBKWIN);
  xSize = LCD_GetXSize();
  ySize = LCD_GetYSize();
  GUI_SetBkColor(GUI_MAKE_COLOR(0x000000));
  GUI_Clear();
  GUI_SetColor(GUI_WHITE);
  GUI_DrawRect(0, 0, xSize - 1, ySize - 1);
  GUI_DrawLine(0, 0, xSize - 1, ySize - 1);
  GUI_DrawLine(0, ySize - 1, xSize - 1, 0);
  GUI_SetTextMode(GUI_TM_TRANS);
  GUI_DispStringHCenterAt("Layer ", xSize / 2, 5);
  GUI_DispDecMin(LayerIndex);
  hWin = BUTTON_CreateEx(xSize / 2 - 20, ySize - 30, 40, 20, WM_HBKWIN, WM_CF_SHOW, 0, 0);
  BUTTON_SetText(hWin, "Button");
}

/*********************************************************************
*
*       _DrawStripes
*/
static void _DrawStripes(int LayerIndex) {
  int xSize;
  int ySize;
  int x;
  int Cnt;

  Cnt = 0;
  GUI_SelectLayer(LayerIndex);
  WM_SelectWindow(WM_HBKWIN);
  xSize = LCD_GetXSize();
  ySize = LCD_GetYSize();
  for (x = 0; x < xSize; x += 8) {
    GUI_SetColor(_aColor[Cnt]);
    GUI_FillRect(x, 0, x + 7, ySize - 1);
    if (++Cnt == GUI_COUNTOF(_aColor)) {
      Cnt = 0;
    }
  }
  GUI_SetColor(GUI_WHITE);
  GUI_DrawRect(0, 0, xSize - 1, ySize - 1);
}

/*********************************************************************
*
*       _DrawToucan
*/
static void _DrawToucan(int LayerIndex) {
  GUI_SelectLayer(LayerIndex);
  WM_SelectWindow(WM_HBKWIN);
  GUI_SetBkColor(GUI_MAKE_COLOR(0xff000000));
  GUI_Clear();
  GUI_DrawBitmap(&_bmToucan, 0, 0);
}

/*********************************************************************
*
*       _DoAnimation
*/
static void _DoAnimation(ANIMATION_CONTEXT * pContext) {
  pContext->xPos += pContext->xAdd;
  pContext->yPos += pContext->yAdd;
  GUI_SetLayerPosEx(pContext->LayerIndex, pContext->xPos, pContext->yPos);
  pContext->Alpha += pContext->AlphaAdd;
  GUI_SetLayerAlphaEx(pContext->LayerIndex, pContext->Alpha);
  if ((pContext->xPos == pContext->xMax) || (pContext->xPos == pContext->xMin)) {
    pContext->xAdd *= -1;
  }
  if ((pContext->yPos == pContext->yMax) || (pContext->yPos == pContext->yMin)) {
    pContext->yAdd *= -1;
  }
  if ((pContext->Alpha == 255) || (pContext->Alpha == 0)) {
    pContext->AlphaAdd *= -1;
  }
}

/*********************************************************************
*
*       Public code
*
**********************************************************************
*/
/*********************************************************************
*
*       MainTask
*/
void MainTask(void) {
  ANIMATION_CONTEXT aContext[2] = {{0}};
  int               TimeNextChroma;
  int               IndexChroma;

  IndexChroma = 0;

  #ifdef WIN32
    SIM_GUI_SetTransMode(1, GUI_TRANSMODE_CHROMA);
  #endif

  GUI_Init();
  //
  // Check if recommended memory for the sample is available
  //
  if (GUI_ALLOC_GetNumFreeBytes() < RECOMMENDED_MEMORY) {
    GUI_ErrorOut("Not enough memory available."); 
    return;
  }
  _FillLayer(0);
  _DrawStripes(1);
  _DrawToucan(2);
  aContext[0].LayerIndex = 1;
  aContext[0].xMax = 220;
  aContext[0].xAdd = 1;
  aContext[0].AlphaAdd = 5;
  aContext[0].yPos = 50;

  aContext[1].LayerIndex = 2;
  aContext[1].yMax = 100;
  aContext[1].yAdd = 2;

  TimeNextChroma = GUI_GetTime() + 1000;
  while (1) {
    _DoAnimation(&aContext[0]);
    _DoAnimation(&aContext[1]);
    if (GUI_GetTime() > TimeNextChroma) {
      TimeNextChroma += 1000;
      IndexChroma++;
      if (IndexChroma == GUI_COUNTOF(_aColor)) {
        IndexChroma = 0;
      }
      SIM_GUI_SetChroma(1, _aColor[IndexChroma], _aColor[IndexChroma]);
    }
    GUI_Delay(20);
  }
}

/*************************** End of file ****************************/
