#include "mbed.h"

#include <stdio.h>
#include <errno.h>

// Block devices
#if COMPONENT_SPIF
#include "SPIFBlockDevice.h"
#endif

#if COMPONENT_DATAFLASH
#include "DataFlashBlockDevice.h"
#endif 

#if COMPONENT_SD
#include "SDBlockDevice.h"
#endif 

#include "HeapBlockDevice.h"

// File systems
#include "LittleFileSystem.h"
#include "FATFileSystem.h"

// Physical block device, can be any device that supports the BlockDevice API
/*SPIFBlockDevice bd(
        MBED_CONF_SPIF_DRIVER_SPI_MOSI,
        MBED_CONF_SPIF_DRIVER_SPI_MISO,
        MBED_CONF_SPIF_DRIVER_SPI_CLK,
        MBED_CONF_SPIF_DRIVER_SPI_CS);*/

#define BLOCK_SIZE 512
HeapBlockDevice bd(16384, BLOCK_SIZE);
#include "stm32l475e_iot01_tsensor.h"

// File system declaration
LittleFileSystem fs("fs");

Ticker ticker;
Thread t;
static FILE *f;
EventQueue queue(16 * EVENTS_EVENT_SIZE);
InterruptIn button(USER_BUTTON);


void display_temperature() {
    int count = 1;
    fflush(stdout);
    fflush(f);
    fseek(f, 0, SEEK_SET);
    float value;
    while (!feof(f)) {
        fscanf(f, "%f", &value); 
        printf("The %dst/nd temperature recorded was %f degress.\n", count, value);
        count++;
    }
    fflush(stdout);
}


void store_temperature() {
    float temperature = 0;
    temperature = BSP_TSENSOR_ReadTemp();
    fprintf(f, "%f\n", temperature);
    fflush(f);
    fflush(stdout);
    printf("A new temperature is being stored...\n");
}

void rise_call() {
    queue.call(display_temperature);
}

void ticker_call() {    
    queue.call(store_temperature);
}

int main(){
    t.start(callback(&queue, &EventQueue::dispatch_forever));
    BSP_TSENSOR_Init();
    button.rise(&rise_call);
    
    // Try to mount the filesystem
    printf("Mounting the filesystem... ");
    fflush(stdout);
    int err = fs.mount(&bd);
    printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err) {
        // Reformat if we can't mount the filesystem
        // this should only happen on the first boot
        printf("No filesystem found, formatting... ");
        fflush(stdout);
        err = fs.reformat(&bd);
        printf("%s\n", (err ? "Fail :(" : "OK"));
        if (err) {
            error("error: %s (%d)\n", strerror(-err), err);
        }
    }
    
    // Open the numbers file
    printf("Opening \"/fs/numbers.txt\"... ");
    fflush(stdout);
    f = fopen("/fs/numbers.txt", "r+");
    printf("%s\n", (!f ? "Fail :(" : "OK"));
    if (!f) {
        // Create the numbers file if it doesn't exist
        printf("No file found, creating a new file... ");
        fflush(stdout);
        f = fopen("/fs/numbers.txt", "w+");
        printf("%s\n", (!f ? "Fail :(" : "OK"));
        if (!f) {
            error("error: %s (%d)\n", strerror(errno), -errno);
        }
    }

     ticker.attach(&ticker_call, 5);
}