#include "mbed.h"

typedef struct {
  int value;
} message_t;
Mutex mutex;
const int queue_size = 10;
ConditionVariable cond(mutex);
MemoryPool<message_t, queue_size> mpool;
Queue<message_t, queue_size> queue;
Thread thread_producer;
Thread thread_consumer;

int pointer = 0;

void producer () {
    while (true) {
        wait(rand()%3);
        mutex.lock(); 
        int rand_value = rand(); 
        message_t *message = mpool.alloc();
        message->value = rand_value;
        queue.put(message);
        pointer++;
        printf("\nProducer value %d \n", message->value);
        while (pointer == queue_size){
            printf("\nThe queue is full, wait a consumer\n");
            cond.wait();
            }
        cond.notify_all();
        mutex.unlock();
    }
}

void consumer(){
     while (true) {
        wait(rand()%5);
        mutex.lock();
          while (pointer == 0){
           printf("\nThe queue is empty, wait for a producer.\n");
           cond.wait();
            }
        osEvent evt = queue.get();
        pointer--;
        if (evt.status == osEventMessage) {
            message_t *message = (message_t*)evt.value.p;
            printf("\nGot value %.d .\n"   , message->value);
            mpool.free(message);
        }
        cond.notify_all();
        mutex.unlock();
    }

 }

int main () {
    
    thread_producer.start(&producer);
    thread_consumer.start(&consumer);

}
