#include "mbed.h"

// Sensors drivers present in the BSP library
#include "stm32l475e_iot01_tsensor.h"
#include "stm32l475e_iot01_hsensor.h"
#include "stm32l475e_iot01_psensor.h"
#include "stm32l475e_iot01_magneto.h"
#include "stm32l475e_iot01_gyro.h"
#include "stm32l475e_iot01_accelero.h"

DigitalOut led(LED1);
InterruptIn button(USER_BUTTON);
int options = 0;
bool has_changed = false; 

void toggle() {
    options = options + 1 % 5;
    has_changed = true;
}

int main()
{
    float sensor_value = 0;
    int16_t pDataXYZ[3] = {0};
    float pGyroDataXYZ[3] = {0};

    BSP_TSENSOR_Init();
    BSP_HSENSOR_Init();
    
    BSP_PSENSOR_Init();

    BSP_MAGNETO_Init();
    BSP_GYRO_Init();
    BSP_ACCELERO_Init();
    
    button.rise(&toggle);
    
    while(1) {

    led = !led; 

    switch (options) 
      { case 0:
          break;
        case 1:
            sensor_value = BSP_TSENSOR_ReadTemp();
            printf("\nTEMPERATURE = %.2f degC\n", sensor_value);
    
            sensor_value = BSP_HSENSOR_ReadHumidity();
            printf("HUMIDITY    = %.2f %%\n", sensor_value);
    
            sensor_value = BSP_PSENSOR_ReadPressure();
            printf("PRESSURE is = %.2f mBar\n", sensor_value);
            break;
        
        case 2: 
            BSP_MAGNETO_GetXYZ(pDataXYZ);
            printf("\nMAGNETO_X = %d\n", pDataXYZ[0]);
            printf("MAGNETO_Y = %d\n", pDataXYZ[1]);
            printf("MAGNETO_Z = %d\n", pDataXYZ[2]);
            break;
        case 3:
            BSP_GYRO_GetXYZ(pGyroDataXYZ);
            printf("\nGYRO_X = %.2f\n", pGyroDataXYZ[0]);
            printf("GYRO_Y = %.2f\n", pGyroDataXYZ[1]);
            printf("GYRO_Z = %.2f\n", pGyroDataXYZ[2]);
            break;
        case 4:
            BSP_ACCELERO_AccGetXYZ(pDataXYZ);
            printf("\nACCELERO_X = %d\n", pDataXYZ[0]);
            printf("ACCELERO_Y = %d\n", pDataXYZ[1]);
            printf("ACCELERO_Z = %d\n", pDataXYZ[2]);
            break;
        default:
            break;
            }
            
     if(has_changed){
         wait(1);
         has_changed = false;
     }
     led = !led; 

    }
}
