#include "mbed.h"

#include "stm32l475e_iot01_accelero.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

int main()
{
    int16_t pDataXYZ[3] = {0};
    
    BSP_ACCELERO_Init();

    while(1) {
        
        wait(1);
          
        BSP_ACCELERO_AccGetXYZ(pDataXYZ);
        printf("\nACCELERO_X = %d\n", pDataXYZ[0]);
        printf("ACCELERO_Y = %d\n", pDataXYZ[1]);
        printf("ACCELERO_Z = %d\n", pDataXYZ[2]);
        
       int16_t x_data = pDataXYZ[0];
       int16_t y_data = pDataXYZ[1];
       int16_t z_data = pDataXYZ[2];
        
         if(abs(z_data)>= 970 && abs(z_data) <= 1030 )
        {
            printf("the board is in horizontal position\n");
            led1 = 1;
            led2 = 0;
            led3 = 0;
            wait(1);
            led1 = 0;
         } else { led1 = 0;}
            
         if(abs(x_data)>= 970 && abs(x_data) <= 1030 ){
            printf("the board is in the short edge\n");
            led2 = 1;
            led1 = 0;
            led3 = 0;
            wait(1);
            led2 = 0;
            } else { led2 = 0; }
            
         if(abs(y_data)>= 970 && abs(y_data) <= 1030 ){
             printf("the board is in the long edge\n");
             led3 = 1;
             led2 = 0;
             led1 = 0;
             wait(1);
             led3 = 0;
             } else { led3 = 0; }
             
        if(!(abs(z_data)>= 970 && abs(z_data) <= 1030) && !(abs(x_data)>= 970 && abs(x_data) <= 1030) && !(abs(y_data)>= 970 && abs(y_data) <= 1030)){
            printf("unknown position\n");
            led1 = 1;
            led2 = 1;
            led3 = 1;
            wait(1);
            led1 = 0;
            led2 = 0;
            led3 = 0;
            } else {
            led1 = 0;
            led2 = 0;
            led3 = 0;
            }
            
    }
}
