#include "mbed.h"

DigitalOut led1(LED1);
InterruptIn button(USER_BUTTON);
EventQueue queue(32 * EVENTS_EVENT_SIZE);
Thread t;
time_t seconds = time(NULL);

void rise_handler_thread_context(void) {
    if(seconds - time(NULL) > 2){
          seconds = time(NULL); 
        }
   else {
          led1 = !led1;
          wait(1);
          led1 = !led1;
          wait(1);
          led1 = !led1;
          wait(1);
          led1 = !led1;  
          seconds = time(NULL); 
        }
}

void rise_handler_iterrupt_context(void) {
    queue.call(rise_handler_thread_context);
}

void fall_handler(void) {
    printf("hello\n");
}

int main() {
    // Start the event queue
    t.start(callback(&queue, &EventQueue::dispatch_forever));
    // The 'rise' handler will execute in IRQ context
    button.rise(rise_handler_iterrupt_context);
    // The 'fall' handler will execute in the context of thread 't'
    button.fall(queue.event(fall_handler));
}
