#include "mbed.h"

#include "stm32l475e_iot01_accelero.h"

#include <stdio.h>
#include <errno.h>
#include "nvstore.h"

// Block devices
#if COMPONENT_SPIF
#include "SPIFBlockDevice.h"
#endif

#if COMPONENT_DATAFLASH
#include "DataFlashBlockDevice.h"
#endif 

#if COMPONENT_SD
#include "SDBlockDevice.h"
#endif 

#include "HeapBlockDevice.h"

// File systems
#include "LittleFileSystem.h"
#include "FATFileSystem.h"

// Physical block device, can be any device that supports the BlockDevice API
/*SPIFBlockDevice bd(
        MBED_CONF_SPIF_DRIVER_SPI_MOSI,
        MBED_CONF_SPIF_DRIVER_SPI_MISO,
        MBED_CONF_SPIF_DRIVER_SPI_CLK,
        MBED_CONF_SPIF_DRIVER_SPI_CS);*/

#define BLOCK_SIZE 512
HeapBlockDevice bd(16384, BLOCK_SIZE);

// File system declaration
LittleFileSystem fs("fs");

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

Ticker ticker;
Thread t;

uint16_t key_led1 = 1; 
uint32_t value_led1;
uint16_t key_led2 = 2; 
uint32_t value_led2;
uint16_t key_led3 = 3;
uint32_t value_led3;

static FILE *f;
volatile int counter = 0;
EventQueue queue(16 * EVENTS_EVENT_SIZE);
InterruptIn button(USER_BUTTON);
int16_t pDataXYZ[3] = {0};


void save_accelero() {
    int16_t pDataXYZ[3] = {0};
    BSP_ACCELERO_AccGetXYZ(pDataXYZ);
    if ((pDataXYZ[0] < -950  && pDataXYZ[0] > -1030) || (pDataXYZ[0] < 1030 && pDataXYZ[0] > 950)){
            fprintf(f, "%d\n", 0);
        } else if ((pDataXYZ[1] < 1030 && pDataXYZ[1] > 950) || (pDataXYZ[1] < -950 && pDataXYZ[1] > -1030)) {
            fprintf(f, "%d\n", 1);
        } else if ((pDataXYZ[2] < 1030 && pDataXYZ[2] > 950) || (pDataXYZ[2] < -950 && pDataXYZ[2] > -1030)) {
             fprintf(f, "%d\n", 2);
        } else {
             fprintf(f, "%d\n", -1);
        }
    fflush(f);
    fflush(stdout);
}

void toggle_led_accelero() {
      int horizontal_count = 0;
      int long_count = 0;
      int short_count = 0;
      fflush(stdout);
      fflush(f);
      
      fseek(f, 0, SEEK_SET);
      int position;
      while (!feof(f)) {
        fscanf(f, "%d", &position); 
        if (position == 0) {
            short_count +=1;
        } else if(position == 1) {
            long_count +=1;
        } else if(position == 2) {
            horizontal_count +=1;
        }
      }
     NVStore &nvstore = NVStore::get_instance();
      if (short_count >= horizontal_count && short_count >= long_count) {
            led1 = 0;
            led2 = 0;
            led3 = 1;
            value_led3+=1;
            nvstore.set(key_led3, sizeof(value_led3), &value_led3);
            printf("The board stayed on the short edge for most time: %d \n",short_count);
        }  else if (long_count >= horizontal_count && long_count >= short_count ) {
            led1 = 0;
            led2 = 1;
            led3 = 0;
            value_led2+=1;
            nvstore.set(key_led2, sizeof(value_led2), &value_led2);
            printf("The board stayed on the long edge for most time: %d \n",long_count);
        } else if (horizontal_count >= long_count && horizontal_count >= short_count) {
            led1 = 1;
            led2 = 0;
            led3 = 0;
            value_led3+=1;
            nvstore.set(key_led3, sizeof(value_led3), &value_led3);
            printf("The board stayed horizontal for most time: %d \n",horizontal_count);
        }
    
      fflush(stdout);
      int err = fclose(f);
      printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
      if (err < 0) {
        error("error: %s (%d)\n", strerror(err), -err);
      }
      err = fs.unmount();
      printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
      if (err < 0) {
          error("error: %s (%d)\n", strerror(-err), err);
      }    
      
}

void toggle() {
    int16_t pDataXYZ[3] = {0};
    BSP_ACCELERO_AccGetXYZ(pDataXYZ);
    printf("ACCELERO_X = %d\n", pDataXYZ[0]);
    printf("ACCELERO_Y = %d\n", pDataXYZ[1]);
    printf("ACCELERO_Z = %d\n\n", pDataXYZ[2]);
}

void ticker_call() {    
    queue.call(save_accelero);
    counter++;
    if (counter == 1000) {
        ticker.detach();
      queue.call(toggle_led_accelero);
      counter = 0;
    }
}

int main(){
    t.start(callback(&queue, &EventQueue::dispatch_forever));
    BSP_ACCELERO_Init();
    
    //Setting up NVStore
    NVStore &nvstore = NVStore::get_instance();
   
    uint16_t actual_len_bytes = 0;
    int rc;
    
    rc = nvstore.init();
    printf("Init NVStore. \n");
    
    rc = nvstore.get(key_led1, sizeof(value_led1), &value_led1, actual_len_bytes);
    if (rc == NVSTORE_NOT_FOUND) {
        value_led1 = 0;
        value_led2 = 0;
        value_led3 = 0;
        nvstore.set(key_led1, sizeof(value_led1), &value_led1);
        nvstore.set(key_led2, sizeof(value_led2), &value_led2);
        nvstore.set(key_led3, sizeof(value_led3), &value_led3);
    } else {
        nvstore.get(key_led2, sizeof(value_led2), &value_led2, actual_len_bytes);
        nvstore.get(key_led3, sizeof(value_led3), &value_led3, actual_len_bytes);    
    }
 
    printf("LED1 switched on: %d times\n",value_led1);
    printf("LED2 switched on: %d times\n",value_led2);
    printf("LED3 switched on: %d times\n",value_led3);    
    
    // Try to mount the filesystem
    printf("Mounting the filesystem... ");
    fflush(stdout);
    int err = fs.mount(&bd);
    printf("%s\n", (err ? "Fail :(" : "OK"));
    if (err) {
        // Reformat if we can't mount the filesystem
        // this should only happen on the first boot
        printf("No filesystem found, formatting... ");
        fflush(stdout);
        err = fs.reformat(&bd);
        printf("%s\n", (err ? "Fail :(" : "OK"));
        if (err) {
            error("error: %s (%d)\n", strerror(-err), err);
        }
    }
    
    // Open the numbers file
    printf("Opening \"/fs/numbers.txt\"... ");
    fflush(stdout);
    f = fopen("/fs/numbers.txt", "r+");
    printf("%s\n", (!f ? "Fail :(" : "OK"));
    if (!f) {
        // Create the numbers file if it doesn't exist
        printf("No file found, creating a new file... ");
        fflush(stdout);
        f = fopen("/fs/numbers.txt", "w+");
        printf("%s\n", (!f ? "Fail :(" : "OK"));
        if (!f) {
            error("error: %s (%d)\n", strerror(errno), -errno);
        }
    }

    ticker.attach(&ticker_call, 0.01);
}