/*
 *  Copyright 2014 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
#ifndef APP_STATUS_H
#define APP_STATUS_H

#include "App.h"
#include "DMBoard.h"
#include "lpc_swim.h"
#include "ImageButton.h"
#include "Resource.h"

/**
 * An App example. Static display of information.
 *
 * The purpose of this example is to show some of the graphics primitives in
 * the SWIM library.
 */
class AppStatus : public App {
public:

	AppStatus();
	virtual ~AppStatus();

    virtual bool setup();
    virtual void runToCompletion();
    virtual bool teardown();

    enum Resources {
        Resource_Ok_button,
        Resource_About_image,
    };

    /** Specifies the resource to use
     *
     *  Adds a resource for a specific id. This allows the
     *  user program to select e.g. which image to use and
     *  if it should be loaded from a file or an array.
     *
     *  @param id  the identifier
     *  @param res the resource
     */
    void addResource(Resources id, Resource* res);

private:
    Display* _disp;
    SWIM_WINDOW_T* _win;
    void* _fb;
    ImageButton* _btn;
    Image::ImageData_t _bgImg;
    Resource* _resOk;
    Resource* _resAbout;

    void draw();
    void draw480x272();
    void draw800x480();
};

#endif


