/******************************************************************************
 * Includes
 *****************************************************************************/
 
#include "mbed.h"
#include "mbed_interface.h"
#include "rtos.h"

#include "DMBoard.h"

#include "AppLauncher.h"
#include "AppTouchCalibration.h"

#include "AppTemplate.h"
#include "image_data.h"


/******************************************************************************
 * Typedefs and defines
 *****************************************************************************/

typedef enum {
    MyFirstApp,
    
    // Add an application ID here
    
    CalibrationApp =  AppLauncher::CalibrationApp,
} myapps_t;

/******************************************************************************
 * Local functions
 *****************************************************************************/

static App* launchApp(uint32_t id)
{
  App* a = NULL;
  switch ((myapps_t)id) {
      case CalibrationApp:
          a = new AppTouchCalibration();
          break;
      case MyFirstApp:
          a = new AppTemplate();
          break;
      
      // Create your application here
      
      default:
          break;
  }
  return a;
}

void guiTask(void const* args)
{
  RtosLog* log = DMBoard::instance().logger();
    
  log->printf("guiTask started\n");
  
  AppLauncher launcher;
    
    
  if (launcher.setup()) {
    launcher.addImageButton(MyFirstApp, "Something", RED, img_empty, img_size_empty);
    
    // Add more buttons here
      
    launcher.setAppCreatorFunc(launchApp);
    log->printf("Starting menu system\n");
    launcher.runToCompletion();
    launcher.teardown();
  } else {
    log->printf("Failed to prepare menu system\n");
  }
  
  // Should never end up here  
  mbed_die();
}

/******************************************************************************
 * Main function
 *****************************************************************************/
int main()
{
  DMBoard::BoardError err;
  DMBoard* board = &DMBoard::instance();
  RtosLog* log = board->logger();
  err = board->init();
  if (err != DMBoard::Ok) {
    log->printf("Failed to initialize the board, got error %d\r\n", err);
    wait_ms(2000); // allow RtosLog to flush messages
    mbed_die();
  }
  
  log->printf("\n\n---\nApplication Launcher Example\nBuilt: " __DATE__ " at " __TIME__ "\n\n");

  Thread tGui(guiTask, NULL, osPriorityNormal, 8192);
  
  while(1) { 
    // Wait forever (in 1h increments) to prevent the tGui
    // thread from being garbage collected.
    Thread::wait(3600*1000);
  }
}

