/*
 *  Copyright 2014 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
#ifndef APP_TOUCHCALIBRATION_H
#define APP_TOUCHCALIBRATION_H

#include "App.h"
#include "DMBoard.h"
#include "lpc_swim.h"
#include "ImageButton.h"
#include "Resource.h"

/**
 * An App example guiding the user through the steps needed to (re)calibrate the
 * touch controller. After the user presses each of the four corner for calibration
 * the program turns into a very simple drawing application until the Done button
 * is pressed.
 *
 * The purpose of this example is to show how to (re)calibrate the touch controller
 * if that is ever needed.
 */
class AppTouchCalibration : public App {
public:

	AppTouchCalibration();
	virtual ~AppTouchCalibration();

    virtual bool setup();
    virtual void runToCompletion();
    virtual bool teardown();

    enum Resources {
        Resource_Ok_button,
    };

    /** Specifies the resource to use
     *
     *  Adds a resource for a specific id. This allows the
     *  user program to select e.g. which image to use and
     *  if it should be loaded from a file or an array.
     *
     *  @param id  the identifier
     *  @param res the resource
     */
    void addResource(Resources id, Resource* res);

private:
    Display* _disp;
    TouchPanel* _touch;
    SWIM_WINDOW_T* _win;
    SWIM_WINDOW_T* _msg;
    void* _fb;
    ImageButton* _btn;
    Resource* _resOk;

    void draw();
    void drawMarker(uint16_t x, uint16_t y, bool erase);
    bool calibrate();
    void showStatus(const char* message, int line=0);
};

#endif
