/*
 *  Copyright 2014 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

#include "Clickable.h"
#include "mbed.h"
#include "DMBoard.h"

#include "lpc_swim_font.h"

Clickable::Clickable(COLOR_T* fb, uint16_t x, uint16_t y, uint16_t width, uint16_t height)
{
  _enabled = true;
  _pressed = false;
  _func = NULL;
  
  Display* disp = DMBoard::instance().display();
    
  swim_window_open_noclear(
    &_win, 
    disp->width(), disp->height(),   // full size
    fb,
    x, y, x+width-1, y+height-1,     // window position and size
    0,                               // border
    BLACK, BLACK, BLACK);            // colors: pen, backgr, forgr
}

bool Clickable::handle(uint16_t x, uint16_t y, bool pressed)
{
  bool needsRepaint = false;
  if (_enabled) {
    if (!pressed && _pressed) {
      // user released => click
      needsRepaint = true;
      _pressed = false;
      if (_func != NULL) {
        _func(_funcArg);
      }       
    }
    else if ((x >= _win.xpmin) && (y >= _win.ypmin) && (x <= _win.xpmax) && (y <= _win.ypmax)) {
      if (pressed && !_pressed) {
        // user pressing inside area
        needsRepaint = true;
        _pressed = true;
      } 
    }
    else if (_pressed) {
      // pressed but moved outside of the button area
      needsRepaint = true;
      _pressed = false;
    }
  }
  return needsRepaint;
}

